% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgx_plot.R
\name{xgx_plot}
\alias{xgx_plot}
\title{Create a new xgx plot}
\usage{
xgx_plot(
  data = NULL,
  mapping = ggplot2::aes(),
  ...,
  environment = parent.frame()
)
}
\arguments{
\item{data}{Default dataset to use for plot. If not already a data.frame, 
will be converted to one by fortify.}

\item{mapping}{As in ggplot2; Default list of aesthetic mappings to use 
for plot. Must define x, y, and group for xgx_spaghetti.}

\item{...}{Other arguments passed on to methods. Not currently used.}

\item{environment}{If an variable defined in the aesthetic mapping is not 
found in the data, ggplot will look for it in this environment. It defaults 
to using the environment in which \code{\link[ggplot2]{ggplot}} is called.}
}
\value{
ggplot2 object
}
\description{
Create a new xgx plot
}
\examples{
 
time <- rep(seq(1, 10), 5)
id <- sort(rep(seq(1, 5), 10))
conc <- exp(-time) * sort(rep(stats::rlnorm(5), 10))

data <- data.frame(time = time, concentration = conc, id = id)
xgx_plot(data = data,
         mapping = ggplot2::aes(x = time, y = concentration, group = id)) + 
  ggplot2::geom_line() + 
  ggplot2::geom_point()
  
}
