% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xlr_vector.R
\name{xlr_vector}
\alias{xlr_vector}
\alias{is_xlr_vector}
\alias{as_xlr_vector}
\title{\code{xlr_vector} vector}
\usage{
xlr_vector(x = vector(), excel_format = "GENERAL", style = xlr_format())

is_xlr_vector(x)

as_xlr_vector(x, excel_format = "GENERAL", style = xlr_format())
}
\arguments{
\item{x}{A vector
\itemize{
\item For \code{xlr_vector()}: A vector
\item For \code{is_xlr_vector()}: An object to test
\item For \code{as_xlr_vector()} : a vector
}}

\item{excel_format}{a character, the \code{Excel} cell format, not validated. See
\link[openxlsx]{createStyle} argument numFmt for more details on what
you can specify.}

\item{style}{Additional styling options for the vector. See \link{xlr_format} for
more details.}
}
\value{
An S3 vector of class \code{xlr_vector}
}
\description{
A general container for including additional styling options within a vector
so that it can easily be exported to \code{Excel}. This vector type should be used
for characters, factors, Booleans, complex numbers, etc. It does
not support dates.
}
\details{
While you can use it with \code{integer}, and \code{double} types and specifying the
associated \code{Excel} format, we recommend using \link{xlr_integer}, \link{xlr_numeric},
or \link{xlr_percent} types instead.

You can convert a vector back to its base type with \code{\link[=as_base_r]{as_base_r()}}.
}
\examples{
library(xlr)
# Create a xlr_vector object, this is used so we can add styling to an existing
# vector so that it prints nicely in `Excel`
#
# Note currently the style will not change the style in the console
x <- xlr_vector(1:100,
                 excel_format = "00.0##",
                 style = xlr_format(font_size = 8))

# You can also use it so that dates are nicely printed in `Excel`
dates <- c("02/27/92", "02/27/92", "01/14/92", "02/28/92", "02/01/92")
dates <- as.Date(dates, "\%m/\%d/\%y")
x <- xlr_vector(dates,
                 # Print it as a long date in `Excel`
                 excel_format = "LONGDATE")
# You can convert existing data to a xlr_vectors using dplyr verbs
iris |>
  dplyr::mutate(iris_format = as_xlr_vector(Species,
                                             "TEXT",
                                             xlr_format(text_style = "italic")))
}
\seealso{
\code{\link[=xlr_percent]{xlr_percent()}}, \code{\link[=xlr_integer]{xlr_integer()}}, \code{\link[=xlr_numeric]{xlr_numeric()}}, \code{\link[=as_base_r]{as_base_r()}}
}
