% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml2relational.r
\name{xml2relational}
\alias{xml2relational}
\title{Package 'xml2relational'}
\description{
Transforming a hierarchical XML document into a relational data
  model.
}
\section{What is \code{xml2relational}}{

The \code{xml2relational} package is
  designed to 'flatten' XML documents with nested objects into relational
  dataframes. \code{xml2relational} takes an XML file as input and converts
  it into a set of dataframes (tables). The tables are linked among each
  other with foreign keys and can be exported as CSV or ready-to-use SQL code
  (\code{CREATE TABLE} for the data model, \code{INSERT INTO} for the data).
}

\section{How to use \code{xml2relational}}{

\itemize{ \item First, use
  \code{\link{toRelational}()} to read in an XML file and to convert into a
  relational data model. \item This will give you a list of dataframes, one
  for each table in the relational data model. Tables are linked by foreign
  keys. You can specify the naming convention for the tables' primary and
  foreign keys as arguments in \code{\link{toRelational}()}. \item You can
  now export the data structures of the tables (or a selection of tables)
  using  \code{\link{getCreateSQL}()}. It support multiple SQL dialects, and
  you also provide syntax and data type information for additional SQL
  dialects. \item You can also export the data as SQL \code{INSERT}
  statements with the \code{\link{getInsertSQL}()}. If you only want to
  export the data as CSV use \code{\link{savetofiles}()} to save the
  dataframes produced by \code{\link{toRelational}()} as comma-separated
  files.
  }
}

