% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adj.time.R, R/align.time.R
\name{adj.time}
\alias{adj.time}
\alias{align.time}
\alias{align.time.xts}
\alias{shift.time}
\title{Align seconds, minutes, and hours to beginning of next period.}
\usage{
adj.time(x, ...)

align.time(x, ...)

\method{align.time}{xts}(x, n = 60, ...)

shift.time(x, n = 60, ...)
}
\arguments{
\item{x}{Object containing timestamps to align.}

\item{\dots}{Additional arguments. See details.}

\item{n}{Number of seconds to adjust by.}
}
\value{
A new object with the same class as \code{x}.
}
\description{
Change timestamps to the start of the next period, specified in multiples of
seconds.
}
\details{
This function is an S3 generic. The result is to round up to the next period
determined by 'n modulo x'.
}
\examples{

x <- Sys.time() + 1:1000

# every 10 seconds
align.time(x, 10)

# align to next whole minute
align.time(x, 60)

# align to next whole 10 min interval
align.time(x, 10 * 60)

}
\seealso{
\code{\link[=to.period]{to.period()}}
}
\author{
Jeffrey A. Ryan with input from Brian Peterson
}
\keyword{chron}
\keyword{manip}
\keyword{misc}
\keyword{ts}
