% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grnn.imp.R
\name{grnn.imp}
\alias{grnn.imp}
\title{Derive the importance rank of all predictors used in the GRNN}
\usage{
grnn.imp(net, class = FALSE)
}
\arguments{
\item{net}{The GRNN object generated by grnn.fit()}

\item{class}{TRUE or FALSE, whether it is for the classification or not}
}
\value{
A dataframe with important values of all predictors in the GRNN
}
\description{
The function \code{grnn.imp} derives the importance rank of all predictors used in the GRNN
It essentially is a wrapper around the function \code{grnn.x_imp}.
}
\examples{
data(iris, package = "datasets")
Y <- ifelse(iris[, 5] == "setosa", 1, 0)
X <- scale(iris[, 1:3])
gnet <- grnn.fit(x = X, y = Y)
\dontrun{
grnn.imp(net = gnet, class = TRUE)
}
}
\seealso{
\code{\link{grnn.x_imp}}
}
