% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirror_deposit.R
\name{mirror_deposit}
\alias{mirror_deposit}
\title{Mirror a Zenodo deposit locally}
\usage{
mirror_deposit(
  deposit_id,
  file_name = NULL,
  cache_dir = NULL,
  cache_type = NULL,
  clear_cache = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{deposit_id}{numeric. The Zenodo deposit id.}

\item{file_name}{character. If \code{NULL}, all files from the file list. If a file name is specified, only this file will be downloaded.}

\item{cache_dir}{character. User specified cache directory for persistent cache type.}

\item{cache_type}{character. Use \code{temporary} to a session temporary folder, \code{persistent} for a persistent cache folder or \code{NULL} to use the environment default. Check the section Cache Type for more details.}

\item{clear_cache}{logical. If the mirror already exists, clear its content.}

\item{quiet}{logical. Show download info and progress bar.}
}
\value{
a string with the mirror path.
}
\description{
Mirror an entire Zenodo deposit or a specific file locally. The mirror is a folder with the deposit files created at the cache folder of the operating system.
}
\section{Cache type}{


The Zenodo mirror will be cached locally on a system folder. This folder can be temporary, being cleared when the R session is ended, or persistent across sections and reboots.

If the \code{cache_type} argument is \code{NULL} (the default) the package will check first the environment variable \code{zendown_cache_type}. If set, the package will use its value. If not set, a temporary cache folder will be used as default.

You can set an environment variable with \code{usethis::edit_r_environ()} and write as bellow for a persistent cache storage.

\code{zendown_cache_type = "persistent"}

After saving the file, remember to restart the session. With this setting, the cache will be persistent and stored at the directory given by \code{tools::R_user_dir("zendown", which = "cache")}

You may also use a different folder for persistent storage by setting the \code{zendown_cache_dir} environment variable. For example:

\verb{zendown_cache_dir = C:\\my_cache\\}

If you set the \code{cache_type} argument directly as \code{temporary} or \code{persistent}, it will override the environment setting.
}

\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# https://zenodo.org/records/10959197
mirror_path <- mirror_deposit(deposit_id = 10959197)
file.exists(file.path(mirror_path, "iris.rds"))
file.exists(file.path(mirror_path, "mtcars.rds"))
\dontshow{\}) # examplesIf}
}
