% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zample.R
\name{zample}
\alias{zample}
\title{Sample from a vector in a safe way}
\usage{
zample(x, size = length(x), replace = FALSE, prob = NULL)
}
\arguments{
\item{x}{The vector to sample from}

\item{size}{The number of elements to sample from \code{x} (defaults to \code{length(x)})}

\item{replace}{Should elements be replaced after sampling (defaults to \code{false})}

\item{prob}{A vector of probability weights (defaults to equal probabilities)}
}
\value{
The resulting sample
}
\description{
The \code{\link[=zample]{zample()}} function duplicates the functionality of \code{\link[=sample]{sample()}}, with the
exception that it does not attempt the (sometimes dangerous)
user-friendliness of switching the interpretation of the first element to a
number if the length of the vector is 1. \code{zample()} \emph{always} treats its first
argument as a vector containing elements that should be sampled, so your code
won't break in unexpected ways when the input vector happens to be of length
1.
}
\details{
If what you really want is to sample from an interval between 1 and n, you can
use \code{sample(n)} or \code{sample.int(n)} (but make sure to only pass vectors of
length one to those functions).
}
\examples{
# For vectors of length 2 or more, zample() and sample() are identical
set.seed(42); zample(7:11)
set.seed(42); sample(7:11)

# For vectors of length 1, zample() will still sample from the vector,
# whereas sample() will "magically" switch to interpreting the input
# as a number n, and sampling from the vector 1:n.
set.seed(42); zample(7)
set.seed(42); sample(7)

# The other arguments work in the same way as for sample()
set.seed(42); zample(7:11, size=13, replace=TRUE, prob=(5:1)^3)
set.seed(42); sample(7:11, size=13, replace=TRUE, prob=(5:1)^3)

# Of course, sampling more than the available elements without
# setting replace=TRUE will result in an error
set.seed(42); tryCatch(zample(7, size=2), error=wrap_error)

}
