









use rand_core::{impls, Error, RngCore};

#[cfg(feature = "serde1")]
use serde::{Serialize, Deserialize};















#[derive(Debug, Clone, PartialEq, Eq)]
#[cfg_attr(feature = "serde1", derive(Serialize, Deserialize))]
pub struct StepRng {
    v: u64,
    a: u64,
}

impl StepRng {
    
    
    pub fn new(initial: u64, increment: u64) -> Self {
        StepRng {
            v: initial,
            a: increment,
        }
    }
}

impl RngCore for StepRng {
    #[inline]
    fn next_u32(&mut self) -> u32 {
        self.next_u64() as u32
    }

    #[inline]
    fn next_u64(&mut self) -> u64 {
        let result = self.v;
        self.v = self.v.wrapping_add(self.a);
        result
    }

    #[inline]
    fn fill_bytes(&mut self, dest: &mut [u8]) {
        impls::fill_bytes_via_next(self, dest);
    }

    #[inline]
    fn try_fill_bytes(&mut self, dest: &mut [u8]) -> Result<(), Error> {
        self.fill_bytes(dest);
        Ok(())
    }
}

#[cfg(test)]
mod tests {
    #[test]
    #[cfg(feature = "serde1")]
    fn test_serialization_step_rng() {
        use super::StepRng;

        let some_rng = StepRng::new(42, 7);
        let de_some_rng: StepRng =
            bincode::deserialize(&bincode::serialize(&some_rng).unwrap()).unwrap();
        assert_eq!(some_rng.v, de_some_rng.v);
        assert_eq!(some_rng.a, de_some_rng.a);

    }
}
