#!/usr/bin/perl

use strict;
use warnings;
use lib '.';

use Test::More tests => 20;
use DateTime;
use DateTime::Format::Flexible;
my $base = 'DateTime::Format::Flexible';

my ( $base_dt ) = $base->parse_datetime( '2005-06-07' );
$base->base( $base_dt );

use t::lib::helper;

t::lib::helper::run_tests(
    "23:59:59   => 2005-06-07T23:59:59" ,
    "23:59      => 2005-06-07T23:59:00" ,
    "1:00 a.m.  => 2005-06-07T01:00:00" ,
    "00:00      => 2005-06-07T00:00:00" ,
    "12:00      => 2005-06-07T12:00:00" ,
    "12:00 a.m. => 2005-06-07T00:00:00" ,
    "12:00 p.m. => 2005-06-07T12:00:00" ,
    "noon       => 2005-06-07T12:00:00" ,
    "midnight   => 2005-06-07T00:00:00" ,
    "12:01 a.m. => 2005-06-07T00:01:00" ,
    "12:01 p.m. => 2005-06-07T12:01:00" ,
    "12:59 a.m. => 2005-06-07T00:59:00" ,
    "9:30 pm    => 2005-06-07T21:30:00" ,
    "9.30 pm    => 2005-06-07T21:30:00" ,
    "9.30 p.m.  => 2005-06-07T21:30:00" ,
    "5:30       => 2005-06-07T05:30:00",
    "5:30:02    => 2005-06-07T05:30:02",
    "3p         => 2005-06-07T15:00:00" ,
    "3:15p      => 2005-06-07T15:15:00" ,
    "15:15      => 2005-06-07T15:15:00" ,
);
