/* Copyright 2015 Google Inc. All Rights Reserved.

   Distributed under MIT license.
   See file LICENSE for detail or copy at https://opensource.org/licenses/MIT
*/

/* Lookup table for static dictionary and transforms. */

#ifndef BROTLI_ENC_STATIC_DICT_LUT_H_
#define BROTLI_ENC_STATIC_DICT_LUT_H_

#include "../common/types.h"

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

typedef struct DictWord {
  /* Highest bit is used to indicate end of bucket. */
  uint8_t len;
  uint8_t transform;
  uint16_t idx;
} DictWord;

static const int kDictNumBits = 15;
static const uint32_t kDictHashMul32 = 0x1e35a7bd;

static const uint16_t kStaticDictionaryBuckets[32768] = {
 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003,
 0x0006, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0014, 0x0000, 0x0000, 0x0000,
 0x0015, 0x0000, 0x0016, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0017, 0x0000, 0x0000, 0x0019, 0x0000, 0x001d, 0x0000, 0x0035, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0037, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x003d, 0x004c, 0x0000, 0x0000, 0x0000, 0x005e, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0060, 0x0000, 0x0061, 0x0000, 0x0062, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0063, 0x0065, 0x006a, 0x006c,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x006e, 0x0000, 0x006f, 0x0070, 0x0000,
 0x0071, 0x0076, 0x007c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x007d, 0x0080,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0081, 0x0000, 0x0000, 0x0083, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0084, 0x0000, 0x0000, 0x0087, 0x0000, 0x0000,
 0x0000, 0x0089, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x008a, 0x008b, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x008e, 0x008f, 0x0090, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0091, 0x0000, 0x0000, 0x0000, 0x0092, 0x0095,
 0x0097, 0x0098, 0x0000, 0x0000, 0x0099, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x009a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x009b, 0x0000, 0x0000,
 0x0000, 0x0000, 0x00a0, 0x00b6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x00b7, 0x0000, 0x0000, 0x0000, 0x00bc, 0x00bd, 0x0000, 0x0000, 0x00c0, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00c2, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x00c5, 0x00ca, 0x00d1, 0x0000, 0x0000, 0x00d2,
 0x0000, 0x00e0, 0x0000, 0x0000, 0x0000, 0x00e1, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00e7, 0x0000, 0x0000, 0x0000,
 0x00e8, 0x0000, 0x00f0, 0x0000, 0x0000, 0x00f2, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00f4, 0x0000, 0x0000,
 0x0000, 0x00f6, 0x0000, 0x0000, 0x00f9, 0x00fb, 0x00fd, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0102, 0x0000, 0x0000, 0x0105, 0x0107, 0x0000, 0x0000, 0x0000,
 0x010b, 0x0000, 0x0000, 0x010c, 0x0000, 0x010d, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x010f, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0110, 0x0000, 0x0111, 0x0000, 0x0115, 0x0000, 0x0116, 0x011e,
 0x0000, 0x0000, 0x0000, 0x0000, 0x011f, 0x0000, 0x0121, 0x0122, 0x0123, 0x0000,
 0x0000, 0x0000, 0x0127, 0x0000, 0x0000, 0x0128, 0x0129, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x012a, 0x0000, 0x0000,
 0x0000, 0x012b, 0x0000, 0x0000, 0x0131, 0x0000, 0x0144, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0147, 0x0000, 0x0148, 0x0149, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0150, 0x0000, 0x0000, 0x0154, 0x0000, 0x0155, 0x0156, 0x0157, 0x0000, 0x0000,
 0x015a, 0x0000, 0x015c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x015d,
 0x015f, 0x0000, 0x0000, 0x0163, 0x0000, 0x016b, 0x0000, 0x016c, 0x0000, 0x0170,
 0x0171, 0x0000, 0x0172, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0174, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0175, 0x0000, 0x0177, 0x0000, 0x0000, 0x0000, 0x0000, 0x0178,
 0x0179, 0x0000, 0x0000, 0x018a, 0x018b, 0x018c, 0x0000, 0x0000, 0x018e, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0190, 0x0000, 0x0000, 0x0198, 0x0000, 0x0000, 0x0000,
 0x0000, 0x01a4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01a5, 0x0000,
 0x0000, 0x01a6, 0x01a7, 0x0000, 0x0000, 0x01ad, 0x01b3, 0x01b4, 0x01ba, 0x0000,
 0x0000, 0x01bb, 0x0000, 0x01bc, 0x01bd, 0x01c5, 0x01c8, 0x0000, 0x01c9, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x01ca, 0x0000, 0x0000, 0x0000, 0x01cb, 0x0000,
 0x0000, 0x0000, 0x01cc, 0x0000, 0x01ce, 0x01cf, 0x01d1, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x01d2, 0x01d5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x01d6, 0x0000, 0x0000, 0x0000, 0x01da, 0x0000, 0x01dc, 0x0000, 0x0000,
 0x0000, 0x0000, 0x01e3, 0x0000, 0x01e5, 0x0000, 0x0000, 0x0000, 0x01e6, 0x0000,
 0x0000, 0x01e8, 0x01eb, 0x01ec, 0x0000, 0x0000, 0x01f1, 0x01f3, 0x01f4, 0x0000,
 0x01f5, 0x0000, 0x0000, 0x0000, 0x01f9, 0x0000, 0x0000, 0x01fa, 0x0000, 0x0000,
 0x0000, 0x01fb, 0x0000, 0x0000, 0x0000, 0x01fd, 0x0000, 0x0000, 0x0000, 0x0000,
 0x01ff, 0x0200, 0x0207, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0211,
 0x0212, 0x0000, 0x0000, 0x0000, 0x0216, 0x0000, 0x0000, 0x0000, 0x0000, 0x021f,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0229,
 0x0000, 0x0000, 0x0000, 0x0000, 0x022d, 0x0230, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0231, 0x0000, 0x0234, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0235, 0x0236, 0x0000, 0x023f, 0x0000, 0x026b, 0x0000, 0x026c, 0x0000,
 0x0000, 0x026f, 0x0270, 0x0000, 0x0000, 0x0000, 0x0271, 0x0000, 0x0000, 0x0272,
 0x0273, 0x0000, 0x0000, 0x0274, 0x0000, 0x0000, 0x0000, 0x0000, 0x0276, 0x0000,
 0x0277, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0281, 0x0000, 0x0000, 0x0000, 0x0000, 0x0283, 0x0290, 0x029c, 0x0000, 0x0000,
 0x0000, 0x02a1, 0x0000, 0x0000, 0x0000, 0x02a2, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x02aa, 0x0000, 0x02af, 0x0000, 0x02b2, 0x0000,
 0x02b5, 0x02bb, 0x02bc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x02c0,
 0x02c1, 0x0000, 0x0000, 0x0000, 0x0000, 0x02c3, 0x02c6, 0x0000, 0x02c7, 0x0000,
 0x0000, 0x0000, 0x0000, 0x02d6, 0x0000, 0x0000, 0x02d9, 0x0000, 0x0000, 0x0000,
 0x02da, 0x02db, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x02f0, 0x0000, 0x0000,
 0x0000, 0x02fa, 0x0000, 0x02fb, 0x0000, 0x0000, 0x02ff, 0x0000, 0x0000, 0x0000,
 0x0302, 0x0306, 0x0000, 0x0000, 0x0307, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0308, 0x0000, 0x0000, 0x0000, 0x0309,
 0x030f, 0x0000, 0x0000, 0x0000, 0x0311, 0x0314, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0316, 0x0000, 0x0000, 0x0000, 0x0319, 0x0000, 0x0000, 0x0000, 0x0000, 0x031a,
 0x0000, 0x0000, 0x0324, 0x0333, 0x0335, 0x0000, 0x033b, 0x0000, 0x0000, 0x0000,
 0x0342, 0x0000, 0x0000, 0x0343, 0x0000, 0x0000, 0x0000, 0x0349, 0x0000, 0x034c,
 0x0000, 0x0352, 0x0353, 0x035b, 0x0000, 0x035c, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x036a, 0x0000, 0x036c, 0x0000, 0x036d, 0x037a, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x037d, 0x037e, 0x0382,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0383, 0x0000, 0x0000, 0x0000, 0x0384,
 0x0388, 0x038a, 0x0000, 0x0000, 0x0000, 0x038b, 0x0000, 0x038c, 0x038d, 0x0000,
 0x038e, 0x0000, 0x0000, 0x0000, 0x0000, 0x038f, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0394, 0x0000, 0x0000, 0x0000, 0x039a, 0x039d, 0x0000, 0x03a2, 0x0000,
 0x03a6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03af, 0x0000, 0x0000, 0x03b0,
 0x0000, 0x03b9, 0x03ba, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03bb,
 0x0000, 0x03c2, 0x03c3, 0x0000, 0x0000, 0x03d0, 0x0000, 0x0000, 0x03d1, 0x03d2,
 0x03d3, 0x03d4, 0x0000, 0x03d5, 0x0000, 0x0000, 0x0000, 0x0000, 0x03d8, 0x0000,
 0x0000, 0x03d9, 0x0000, 0x0000, 0x03db, 0x03dd, 0x03df, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03e0, 0x0000, 0x0000, 0x0000,
 0x03e1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03e4, 0x0000, 0x0000,
 0x0000, 0x03e8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03ea, 0x0000, 0x0000,
 0x0000, 0x0000, 0x03ed, 0x03ef, 0x0000, 0x0000, 0x0000, 0x03f1, 0x0000, 0x0000,
 0x0000, 0x03f2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03f3, 0x0000,
 0x03f4, 0x0000, 0x0000, 0x0000, 0x0000, 0x03f6, 0x03f8, 0x0000, 0x0000, 0x0000,
 0x03fc, 0x0000, 0x03fd, 0x0000, 0x0000, 0x0000, 0x0000, 0x03fe, 0x0000, 0x0000,
 0x0000, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0401, 0x0000,
 0x0000, 0x0402, 0x0403, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0407, 0x0000,
 0x0409, 0x0000, 0x0000, 0x0000, 0x0000, 0x040a, 0x0000, 0x0000, 0x0000, 0x040d,
 0x0410, 0x0000, 0x0000, 0x0000, 0x0412, 0x0413, 0x0000, 0x0000, 0x041d, 0x0000,
 0x041e, 0x0000, 0x0000, 0x0421, 0x0000, 0x0000, 0x0000, 0x0422, 0x0000, 0x0000,
 0x0424, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0425, 0x0000,
 0x0000, 0x0426, 0x0000, 0x0000, 0x0000, 0x0000, 0x0427, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0428, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0429, 0x0000, 0x0000,
 0x0000, 0x0000, 0x042a, 0x042b, 0x0000, 0x0000, 0x0000, 0x042d, 0x042e, 0x0430,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0431, 0x0000, 0x0433, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0438, 0x043c, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0440, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0446, 0x0000,
 0x0447, 0x0000, 0x0453, 0x0000, 0x0000, 0x0000, 0x0458, 0x045a, 0x0000, 0x045f,
 0x0000, 0x0462, 0x0000, 0x0000, 0x0466, 0x0000, 0x0469, 0x0000, 0x046a, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x046c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0478, 0x0000, 0x0000, 0x0479, 0x047a, 0x0000, 0x047c, 0x047d, 0x0000,
 0x0000, 0x047e, 0x047f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0480, 0x0000, 0x0481,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0482, 0x0000, 0x048b, 0x0000, 0x0000,
 0x0000, 0x048c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x048d, 0x0000, 0x048f,
 0x0000, 0x0492, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0493, 0x0494, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0495, 0x0497, 0x0499,
 0x0000, 0x04a2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x04ab, 0x0000, 0x0000, 0x04c5, 0x0000, 0x0000, 0x04c8, 0x0000,
 0x0000, 0x04cb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x04cc, 0x04cd, 0x0000,
 0x0000, 0x04ce, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x04cf, 0x0000, 0x0000, 0x0000, 0x04d1, 0x0000, 0x0000, 0x04db, 0x04dc,
 0x04de, 0x04e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x04e6, 0x04e7, 0x04ea, 0x04eb,
 0x0000, 0x0000, 0x0000, 0x04ec, 0x0000, 0x0000, 0x04ed, 0x0000, 0x0000, 0x0000,
 0x04ee, 0x04f0, 0x0000, 0x0000, 0x04f1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x04f2, 0x0000, 0x04f3,
 0x0000, 0x0000, 0x0000, 0x0000, 0x04f9, 0x04fa, 0x04fc, 0x0509, 0x0000, 0x0000,
 0x050b, 0x050c, 0x050d, 0x0000, 0x0000, 0x050e, 0x050f, 0x0510, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0516, 0x0000, 0x0518, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x051f, 0x0520, 0x0000, 0x0522, 0x0000, 0x0524,
 0x0528, 0x0529, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x052a,
 0x052b, 0x052c, 0x0000, 0x0537, 0x0000, 0x0538, 0x0000, 0x0000, 0x0000, 0x0000,
 0x053d, 0x053e, 0x0000, 0x0542, 0x0000, 0x054d, 0x0000, 0x0000, 0x0000, 0x054e,
 0x0550, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0551, 0x0000, 0x0000,
 0x0000, 0x0552, 0x0555, 0x0000, 0x0556, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0563, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x056a, 0x0000, 0x056c, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0573, 0x0000, 0x0000, 0x0000, 0x0000, 0x057b, 0x0000, 0x057d,
 0x0000, 0x0000, 0x057f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0580, 0x0581,
 0x0000, 0x0582, 0x0000, 0x0000, 0x0000, 0x0584, 0x0585, 0x0588, 0x0000, 0x0000,
 0x0595, 0x05ab, 0x0000, 0x0000, 0x05ae, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x05af, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x05b0, 0x0000, 0x0000, 0x0000, 0x0000, 0x05b3, 0x05b4, 0x05b5, 0x05c3, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x05c5, 0x0000, 0x05c8, 0x0000, 0x05c9,
 0x0000, 0x0000, 0x05ce, 0x0000, 0x0000, 0x05d7, 0x0000, 0x0000, 0x0000, 0x05d8,
 0x0000, 0x0000, 0x05da, 0x05db, 0x05dd, 0x05f0, 0x05f1, 0x0000, 0x0000, 0x0000,
 0x05f6, 0x0000, 0x0000, 0x0000, 0x0000, 0x05f8, 0x05f9, 0x0000, 0x05fd, 0x0600,
 0x0000, 0x0000, 0x0000, 0x0601, 0x0602, 0x060d, 0x0000, 0x060e, 0x0616, 0x0617,
 0x0624, 0x0000, 0x0625, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0627, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x062b, 0x0000,
 0x063f, 0x0000, 0x0643, 0x0000, 0x0644, 0x0000, 0x0645, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0648, 0x064a, 0x0000, 0x0000, 0x0000, 0x0000, 0x064b, 0x0000,
 0x064f, 0x0000, 0x0650, 0x0652, 0x0000, 0x0653, 0x0000, 0x0000, 0x0656, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0662, 0x0000, 0x0000, 0x0000, 0x0663, 0x0000, 0x0000,
 0x0000, 0x0669, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x066b, 0x0000, 0x0000, 0x0000, 0x0672, 0x0000, 0x0000, 0x0674, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0675, 0x0000, 0x0000, 0x0000, 0x0676, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0677, 0x0000, 0x067e, 0x0000, 0x0000, 0x067f, 0x0680,
 0x0000, 0x0000, 0x0684, 0x0000, 0x0000, 0x0685, 0x0686, 0x0000, 0x0688, 0x0689,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x068a, 0x0000, 0x0000, 0x0000, 0x068b,
 0x068c, 0x0690, 0x0000, 0x0692, 0x0000, 0x0000, 0x0697, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x06a8, 0x0000, 0x0000, 0x06a9, 0x0000, 0x0000, 0x06b9, 0x0000,
 0x0000, 0x0000, 0x0000, 0x06c6, 0x06c7, 0x0000, 0x0000, 0x0000, 0x0000, 0x06c9,
 0x0000, 0x0000, 0x0000, 0x0000, 0x06cb, 0x0000, 0x0000, 0x06cc, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x06cd, 0x06cf,
 0x0000, 0x0000, 0x0000, 0x0000, 0x06d1, 0x0000, 0x0000, 0x0000, 0x06d5, 0x0000,
 0x0000, 0x0000, 0x06d7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x06e0,
 0x0000, 0x0000, 0x0000, 0x0000, 0x06e5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x06f8, 0x0000, 0x06f9, 0x06fb, 0x0000, 0x0000, 0x0000, 0x0000, 0x06fc, 0x06fd,
 0x0000, 0x0000, 0x0000, 0x0000, 0x06fe, 0x06ff, 0x0701, 0x0000, 0x0706, 0x0707,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0709, 0x0000, 0x070b, 0x070d, 0x0000, 0x0000,
 0x0000, 0x070e, 0x0713, 0x0000, 0x0714, 0x0716, 0x0000, 0x071d, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x071e, 0x0729, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0738, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0741, 0x0000,
 0x0000, 0x0000, 0x0743, 0x0000, 0x0000, 0x0000, 0x0000, 0x0745, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x074a, 0x0000, 0x0781, 0x0785, 0x0000,
 0x0000, 0x0000, 0x0789, 0x078a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x078b, 0x0000, 0x0000, 0x0000, 0x0000, 0x078c, 0x0000,
 0x0000, 0x0000, 0x078e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x079a, 0x0000, 0x0000, 0x079c, 0x0000, 0x0000, 0x0000, 0x0000, 0x079e,
 0x0000, 0x07a5, 0x0000, 0x07a6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07ad,
 0x07af, 0x0000, 0x0000, 0x0000, 0x0000, 0x07b0, 0x0000, 0x07b1, 0x0000, 0x07b3,
 0x07b4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07b5, 0x0000, 0x0000, 0x0000,
 0x0000, 0x07b7, 0x0000, 0x0000, 0x0000, 0x0000, 0x07b8, 0x07bb, 0x0000, 0x07be,
 0x0000, 0x0000, 0x0000, 0x0000, 0x07c0, 0x07c4, 0x0000, 0x0000, 0x0000, 0x0000,
 0x07c6, 0x07d4, 0x07d8, 0x0000, 0x0000, 0x0000, 0x07dc, 0x07dd, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07df, 0x0000,
 0x07e0, 0x07e1, 0x0000, 0x0000, 0x0000, 0x0000, 0x07e5, 0x0000, 0x0000, 0x07e9,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07ed, 0x07f4, 0x07f8, 0x0000, 0x07fa,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x07fb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x07fd, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07fe, 0x07ff,
 0x0000, 0x0800, 0x0801, 0x0000, 0x080b, 0x0000, 0x0000, 0x080f, 0x0000, 0x0810,
 0x0811, 0x0000, 0x0000, 0x0812, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0815, 0x0000, 0x0000, 0x0000, 0x0000, 0x0816, 0x0000, 0x0817, 0x0000, 0x0818,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0820, 0x0822, 0x0823, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0825, 0x0000, 0x0826, 0x0828, 0x0829, 0x0839, 0x0000, 0x0000,
 0x0000, 0x0000, 0x083b, 0x0000, 0x0000, 0x0844, 0x0845, 0x0000, 0x0848, 0x0000,
 0x0000, 0x084a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x084b, 0x0000, 0x0000,
 0x084d, 0x084f, 0x0850, 0x0000, 0x0000, 0x0000, 0x0852, 0x0000, 0x0000, 0x0000,
 0x0859, 0x085b, 0x085c, 0x085d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0860, 0x0861, 0x0000, 0x0000, 0x0862, 0x0865, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0866, 0x0000, 0x0000, 0x0867, 0x086e, 0x0000, 0x086f,
 0x0000, 0x0870, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0871, 0x0872,
 0x0000, 0x0000, 0x0892, 0x089a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x089d, 0x08a9, 0x0000, 0x08ac, 0x0000, 0x08ad, 0x0000, 0x08ae, 0x08b0, 0x0000,
 0x0000, 0x0000, 0x0000, 0x08bd, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x08be,
 0x0000, 0x08bf, 0x08c1, 0x0000, 0x0000, 0x08c2, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x08c3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x08cc, 0x0000,
 0x0000, 0x08cd, 0x0000, 0x0000, 0x0000, 0x08d1, 0x08d2, 0x0000, 0x0000, 0x0000,
 0x08d4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x08d6, 0x0000,
 0x08d8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x08dd, 0x08de, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x08df, 0x0000, 0x08e1,
 0x0000, 0x0000, 0x0000, 0x0000, 0x08e5, 0x0000, 0x0000, 0x0000, 0x0000, 0x08e6,
 0x0000, 0x0000, 0x0000, 0x0000, 0x08e7, 0x0000, 0x08e8, 0x0000, 0x08eb, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x08ef, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x08f1, 0x08f2, 0x0000, 0x0000, 0x0000,
 0x0000, 0x08f3, 0x0000, 0x08f4, 0x0000, 0x0000, 0x0000, 0x08f5, 0x08f7, 0x08f8,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x08fa, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x08ff, 0x0000, 0x0901, 0x0000, 0x0000, 0x0902, 0x0000,
 0x0903, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0909, 0x090a, 0x090b, 0x090c, 0x0000, 0x0000, 0x090e,
 0x0000, 0x090f, 0x0000, 0x0912, 0x0000, 0x0000, 0x0913, 0x0000, 0x0914, 0x0000,
 0x0916, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x091f, 0x0000,
 0x0920, 0x0922, 0x0923, 0x0000, 0x0924, 0x0000, 0x0000, 0x0000, 0x0933, 0x0000,
 0x0947, 0x0000, 0x094e, 0x0952, 0x0000, 0x0953, 0x0000, 0x0000, 0x095a, 0x0000,
 0x0000, 0x0000, 0x0000, 0x095b, 0x0000, 0x095d, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x095e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x095f,
 0x0962, 0x0964, 0x0968, 0x096b, 0x0000, 0x0000, 0x0000, 0x096d, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x096f, 0x0000, 0x0000, 0x0970, 0x0971, 0x0973, 0x0000, 0x0974,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0979, 0x0000, 0x0000, 0x0000, 0x097a,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x097b, 0x097c, 0x0000, 0x097d, 0x0000, 0x0000, 0x097e, 0x0982,
 0x0000, 0x0984, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0989, 0x098a,
 0x0000, 0x098d, 0x0000, 0x0000, 0x098e, 0x0999, 0x0000, 0x099b, 0x0000, 0x0000,
 0x099e, 0x0000, 0x09a0, 0x0000, 0x09ad, 0x0000, 0x09ae, 0x09b6, 0x0000, 0x0000,
 0x0000, 0x09bb, 0x0000, 0x0000, 0x09bd, 0x0000, 0x0000, 0x09be, 0x0000, 0x09bf,
 0x0000, 0x09d1, 0x09db, 0x0000, 0x0000, 0x0000, 0x0000, 0x09dc, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x09e0, 0x09e1, 0x09e2, 0x0000, 0x0000, 0x09e3,
 0x0000, 0x09e5, 0x0000, 0x0000, 0x09e6, 0x09e7, 0x0000, 0x09e8, 0x09e9, 0x0000,
 0x09ea, 0x0000, 0x09eb, 0x09ec, 0x0000, 0x0000, 0x0000, 0x09f1, 0x09f2, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x09f4, 0x0000, 0x0000, 0x09f5,
 0x0000, 0x09f6, 0x09fb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x09fd, 0x0000,
 0x0a00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0a01, 0x0000, 0x0a10, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0a11, 0x0a12, 0x0000, 0x0000, 0x0000, 0x0a13,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0a14, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0a15, 0x0000, 0x0000, 0x0000, 0x0000, 0x0a17, 0x0000, 0x0a18,
 0x0000, 0x0a1c, 0x0a1e, 0x0000, 0x0000, 0x0000, 0x0a1f, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0a21, 0x0a22, 0x0000, 0x0a23, 0x0000, 0x0a29, 0x0a2a, 0x0000, 0x0000,
 0x0a2b, 0x0000, 0x0a2d, 0x0000, 0x0000, 0x0000, 0x0a2e, 0x0a2f, 0x0a33, 0x0000,
 0x0a37, 0x0000, 0x0000, 0x0000, 0x0a39, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0a3b, 0x0000,
 0x0000, 0x0a3c, 0x0000, 0x0000, 0x0000, 0x0a3d, 0x0000, 0x0a3f, 0x0000, 0x0a41,
 0x0000, 0x0000, 0x0a44, 0x0a45, 0x0000, 0x0000, 0x0a4b, 0x0a4c, 0x0a4d, 0x0000,
 0x0000, 0x0a4f, 0x0000, 0x0000, 0x0000, 0x0a52, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0a53, 0x0000, 0x0a54, 0x0000, 0x0a59, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0a5f, 0x0a60, 0x0000, 0x0000, 0x0a61, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0a62, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0a63, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0a68, 0x0a7d, 0x0000, 0x0a7f, 0x0000, 0x0a80, 0x0000, 0x0000,
 0x0a81, 0x0000, 0x0000, 0x0a86, 0x0000, 0x0a87, 0x0000, 0x0000, 0x0a8a, 0x0000,
 0x0a8d, 0x0a92, 0x0000, 0x0000, 0x0000, 0x0a93, 0x0000, 0x0a95, 0x0a96, 0x0a97,
 0x0000, 0x0000, 0x0000, 0x0aa0, 0x0aaa, 0x0aaf, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0ab2, 0x0ab4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0abb, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0abc, 0x0000, 0x0000, 0x0abd, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0abe, 0x0000, 0x0000, 0x0ac0, 0x0ac2, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0ac6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0aca, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0acb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0acc, 0x0acf, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ad0, 0x0000, 0x0000, 0x0ad2,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ad3, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ad4, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0ad5, 0x0ad8, 0x0000, 0x0000, 0x0adf, 0x0000, 0x0000,
 0x0ae0, 0x0000, 0x0ae5, 0x0000, 0x0ae6, 0x0000, 0x0000, 0x0000, 0x0ae8, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ae9,
 0x0aeb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0aec, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0aed, 0x0aef, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0af3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0af6, 0x0000, 0x0af7, 0x0af8, 0x0b01,
 0x0b03, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0b05, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0b06, 0x0b07, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0b08, 0x0000, 0x0000, 0x0b0c, 0x0000, 0x0b12, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0b14, 0x0000, 0x0b16, 0x0000, 0x0000, 0x0b17, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0b19, 0x0000, 0x0000, 0x0000, 0x0b1a,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0b1b, 0x0b1c, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0b1e, 0x0000, 0x0000, 0x0b1f, 0x0000, 0x0b21, 0x0000, 0x0b25, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0b29, 0x0000, 0x0000, 0x0000, 0x0000, 0x0b2a,
 0x0000, 0x0b2b, 0x0000, 0x0000, 0x0b2c, 0x0000, 0x0b2e, 0x0b34, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0b3b, 0x0000, 0x0b3c, 0x0000, 0x0000, 0x0b3d, 0x0b3e, 0x0b44,
 0x0b49, 0x0b4a, 0x0000, 0x0000, 0x0b4b, 0x0000, 0x0000, 0x0b4c, 0x0000, 0x0000,
 0x0000, 0x0b5a, 0x0b60, 0x0000, 0x0b61, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0b64, 0x0000, 0x0b76, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0b77, 0x0000, 0x0000, 0x0000, 0x0000, 0x0b7b, 0x0000, 0x0b7c, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0b7d, 0x0000, 0x0000, 0x0000,
 0x0b82, 0x0000, 0x0b85, 0x0000, 0x0000, 0x0b86, 0x0b8a, 0x0b8b, 0x0000, 0x0000,
 0x0000, 0x0b8f, 0x0b91, 0x0000, 0x0000, 0x0b92, 0x0000, 0x0b93, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0b94, 0x0b95, 0x0b96, 0x0b97, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0b99, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0b9a, 0x0b9f, 0x0000, 0x0ba6, 0x0ba7, 0x0ba8, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0bad, 0x0000, 0x0000, 0x0bae, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0baf, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0bb6, 0x0000, 0x0bb8, 0x0bb9, 0x0000, 0x0000, 0x0bba, 0x0000,
 0x0000, 0x0000, 0x0bbb, 0x0000, 0x0000, 0x0bc4, 0x0000, 0x0000, 0x0bce, 0x0000,
 0x0000, 0x0bd0, 0x0000, 0x0000, 0x0bd1, 0x0bd3, 0x0000, 0x0000, 0x0000, 0x0bd6,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0bda, 0x0bdb, 0x0000, 0x0000, 0x0bdc, 0x0000,
 0x0bdf, 0x0000, 0x0be9, 0x0000, 0x0000, 0x0bea, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0beb, 0x0000, 0x0bed, 0x0000, 0x0000, 0x0000, 0x0000, 0x0bf1,
 0x0000, 0x0bf2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0bf7, 0x0000, 0x0000, 0x0c01, 0x0c02, 0x0c06, 0x0c07, 0x0000, 0x0c08, 0x0c0e,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c0f, 0x0000,
 0x0c14, 0x0000, 0x0c17, 0x0000, 0x0c1b, 0x0000, 0x0000, 0x0000, 0x0c1c, 0x0000,
 0x0c1d, 0x0c1e, 0x0000, 0x0c32, 0x0000, 0x0000, 0x0000, 0x0c34, 0x0000, 0x0c35,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c3c, 0x0c3e, 0x0000, 0x0000,
 0x0c40, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c4b, 0x0000,
 0x0000, 0x0c4d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c4e, 0x0c4f, 0x0c50,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0c56, 0x0000, 0x0000, 0x0c58, 0x0000, 0x0000,
 0x0c59, 0x0000, 0x0000, 0x0c5a, 0x0000, 0x0c5b, 0x0c5e, 0x0c60, 0x0000, 0x0000,
 0x0c61, 0x0c62, 0x0000, 0x0000, 0x0c63, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0c6e, 0x0000, 0x0c70, 0x0000, 0x0000, 0x0c74, 0x0000, 0x0000,
 0x0c7a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c84, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0c89, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0c90, 0x0c91, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0c93, 0x0000, 0x0000, 0x0c94, 0x0c96, 0x0000, 0x0c97,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0c98, 0x0000, 0x0c99, 0x0c9a, 0x0000, 0x0c9c,
 0x0ca1, 0x0000, 0x0ca7, 0x0ca9, 0x0caa, 0x0000, 0x0000, 0x0cb3, 0x0cb4, 0x0cb5,
 0x0cb7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0cbc,
 0x0000, 0x0000, 0x0cbd, 0x0000, 0x0000, 0x0000, 0x0cc3, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0cc7, 0x0000, 0x0000, 0x0000, 0x0cce,
 0x0000, 0x0cd2, 0x0000, 0x0000, 0x0000, 0x0cd4, 0x0000, 0x0000, 0x0000, 0x0cd5,
 0x0cd6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0cd7, 0x0cdc,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0cde, 0x0ce0, 0x0000, 0x0000, 0x0ce3, 0x0ce4,
 0x0ce5, 0x0000, 0x0ce6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ce8, 0x0cea,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0cec, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0cef, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0cf0, 0x0cf2, 0x0cf3, 0x0000, 0x0cf6,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0cf7, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0cf9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0cfa, 0x0000, 0x0000, 0x0cfc, 0x0cfd, 0x0000,
 0x0000, 0x0cfe, 0x0000, 0x0000, 0x0d00, 0x0d01, 0x0d03, 0x0000, 0x0000, 0x0d07,
 0x0000, 0x0000, 0x0d09, 0x0000, 0x0d0a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0d0f,
 0x0d13, 0x0000, 0x0000, 0x0000, 0x0d14, 0x0000, 0x0000, 0x0d17, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0d1a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0d1b, 0x0000, 0x0000, 0x0d25, 0x0d26,
 0x0d27, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0d28, 0x0d29, 0x0000,
 0x0d2a, 0x0000, 0x0000, 0x0d2d, 0x0000, 0x0000, 0x0d30, 0x0000, 0x0000, 0x0d31,
 0x0000, 0x0d33, 0x0d3b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0d3e, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0d4a, 0x0000, 0x0d4b, 0x0d6c,
 0x0d6d, 0x0d6f, 0x0000, 0x0000, 0x0d71, 0x0000, 0x0000, 0x0000, 0x0d72, 0x0000,
 0x0000, 0x0d79, 0x0000, 0x0000, 0x0000, 0x0d7a, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0d7b, 0x0000, 0x0000, 0x0d7c, 0x0000, 0x0d7d, 0x0d80,
 0x0000, 0x0d81, 0x0000, 0x0000, 0x0d82, 0x0000, 0x0d83, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0d84, 0x0000, 0x0000, 0x0d8d,
 0x0d8e, 0x0000, 0x0000, 0x0d93, 0x0000, 0x0000, 0x0000, 0x0d98, 0x0d9f, 0x0da1,
 0x0000, 0x0da2, 0x0000, 0x0000, 0x0da3, 0x0dab, 0x0000, 0x0dac, 0x0000, 0x0000,
 0x0dad, 0x0000, 0x0000, 0x0000, 0x0dae, 0x0000, 0x0dba, 0x0000, 0x0000, 0x0000,
 0x0dbc, 0x0dbd, 0x0000, 0x0000, 0x0000, 0x0dbe, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0dc0, 0x0dc1, 0x0dc2, 0x0000, 0x0000, 0x0dc6, 0x0dca, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0dcb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0dd0, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0dd3, 0x0dd5, 0x0000, 0x0000, 0x0dd6, 0x0dd8,
 0x0000, 0x0ddb, 0x0ddc, 0x0000, 0x0000, 0x0dde, 0x0000, 0x0de1, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0de2, 0x0000, 0x0de3, 0x0000, 0x0de6,
 0x0000, 0x0de7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0deb, 0x0000, 0x0dfd, 0x0000, 0x0000, 0x0000, 0x0e0f, 0x0000, 0x0000, 0x0000,
 0x0e10, 0x0000, 0x0e11, 0x0000, 0x0e12, 0x0e13, 0x0000, 0x0000, 0x0e16, 0x0e18,
 0x0000, 0x0e1a, 0x0e1b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0e1c, 0x0e20, 0x0e23, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e28, 0x0e2c,
 0x0000, 0x0e2d, 0x0e32, 0x0e33, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0e34, 0x0000, 0x0e35, 0x0000, 0x0000, 0x0e36, 0x0e43, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0e44, 0x0e45, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e48,
 0x0e49, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e4a, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0e4b, 0x0000, 0x0e4d, 0x0e4f, 0x0e50, 0x0000, 0x0e51, 0x0000, 0x0e6c,
 0x0000, 0x0000, 0x0000, 0x0e6e, 0x0e70, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e72, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0e74, 0x0000, 0x0000, 0x0e75, 0x0000, 0x0000, 0x0000,
 0x0e7c, 0x0e7d, 0x0000, 0x0000, 0x0000, 0x0e7f, 0x0e80, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0e8b, 0x0000, 0x0e8c, 0x0e8d, 0x0000, 0x0000, 0x0e8e, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e90, 0x0e91, 0x0000, 0x0e96, 0x0e97,
 0x0e99, 0x0000, 0x0000, 0x0000, 0x0e9f, 0x0000, 0x0ea1, 0x0000, 0x0000, 0x0ea2,
 0x0000, 0x0000, 0x0ea3, 0x0ea4, 0x0000, 0x0ead, 0x0000, 0x0eaf, 0x0eb6, 0x0eb7,
 0x0000, 0x0eb8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0eb9, 0x0000, 0x0000, 0x0ebb,
 0x0000, 0x0ebe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ebf, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ec0, 0x0000, 0x0ec1, 0x0eca, 0x0000,
 0x0ecc, 0x0ecd, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0ecf, 0x0000, 0x0ee3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ee6,
 0x0ee7, 0x0ee8, 0x0eec, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0eed, 0x0000, 0x0000, 0x0ef1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0efb, 0x0000,
 0x0000, 0x0f08, 0x0f09, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f0a, 0x0f0b, 0x0f0d,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0f13, 0x0000, 0x0f14, 0x0f16, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0f17, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0f21, 0x0000, 0x0f22, 0x0000, 0x0f23, 0x0f2e, 0x0000, 0x0f2f,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0f34, 0x0f49, 0x0000, 0x0f4a, 0x0000, 0x0000,
 0x0000, 0x0f55, 0x0f5b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f5e, 0x0f65, 0x0f66,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0f67, 0x0000, 0x0000, 0x0000, 0x0f68, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0f69, 0x0000, 0x0f6b, 0x0000, 0x0000, 0x0000,
 0x0f74, 0x0f75, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0f76, 0x0000, 0x0f77, 0x0f7d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f7e,
 0x0000, 0x0000, 0x0000, 0x0f7f, 0x0000, 0x0000, 0x0000, 0x0f80, 0x0f86, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0f87, 0x0f89, 0x0f8a, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0f8c, 0x0000, 0x0f91, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0f92, 0x0fab, 0x0000, 0x0000, 0x0fb1, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fb2, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0fb3, 0x0000, 0x0fb7, 0x0000, 0x0000, 0x0000, 0x0fbb,
 0x0fbc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fbf,
 0x0fc2, 0x0000, 0x0000, 0x0fc3, 0x0fc5, 0x0fc7, 0x0fc8, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0fdb, 0x0000, 0x0fdc, 0x0fdd, 0x0000, 0x0fde, 0x0fdf, 0x0fe2,
 0x0000, 0x0000, 0x0fe8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ff8, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0ffb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ffe, 0x0fff, 0x0000,
 0x0000, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1002, 0x1003, 0x0000,
 0x0000, 0x0000, 0x1005, 0x0000, 0x1008, 0x0000, 0x0000, 0x0000, 0x1009, 0x100c,
 0x0000, 0x1011, 0x0000, 0x0000, 0x1013, 0x1014, 0x0000, 0x101e, 0x0000, 0x0000,
 0x101f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1020, 0x1024,
 0x1025, 0x0000, 0x1026, 0x0000, 0x0000, 0x0000, 0x1029, 0x0000, 0x0000, 0x102d,
 0x0000, 0x0000, 0x0000, 0x0000, 0x1030, 0x1032, 0x1033, 0x0000, 0x0000, 0x0000,
 0x0000, 0x1034, 0x0000, 0x0000, 0x10d7, 0x0000, 0x0000, 0x0000, 0x10da, 0x10e9,
 0x0000, 0x10eb, 0x10ec, 0x0000, 0x10ed, 0x0000, 0x10ee, 0x0000, 0x0000, 0x0000,
 0x10ef, 0x0000, 0x10f0, 0x0000, 0x0000, 0x0000, 0x10f1, 0x0000, 0x0000, 0x0000,
 0x10f6, 0x10f9, 0x10fa, 0x10fe, 0x0000, 0x10ff, 0x1100, 0x0000, 0x1102, 0x1103,
 0x0000, 0x0000, 0x110c, 0x0000, 0x0000, 0x0000, 0x0000, 0x1111, 0x0000, 0x0000,
 0x0000, 0x1115, 0x0000, 0x1116, 0x0000, 0x0000, 0x0000, 0x0000, 0x1119, 0x0000,
 0x0000, 0x0000, 0x0000, 0x111a, 0x0000, 0x0000, 0x0000, 0x111c, 0x0000, 0x0000,
 0x0000, 0x111d, 0x111e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x1120, 0x0000, 0x0000, 0x0000, 0x0000, 0x1121, 0x0000, 0x0000, 0x0000, 0x1122,
 0x0000, 0x0000, 0x0000, 0x1127, 0x112e, 0x0000, 0x0000, 0x0000, 0x0000, 0x1137,
 0x1139, 0x0000, 0x0000, 0x0000, 0x0000, 0x113a, 0x0000, 0x0000, 0x113b, 0x0000,
 0x113e, 0x113f, 0x1142, 0x0000, 0x114b, 0x114c, 0x114e, 0x0000, 0x114f, 0x0000,
 0x1160, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1161, 0x0000, 0x0000, 0x0000,
 0x1163, 0x1164, 0x0000, 0x1165, 0x1166, 0x0000, 0x1168, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x116b, 0x0000, 0x116f, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x1172, 0x0000, 0x1173, 0x0000, 0x1175, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x1176, 0x1177, 0x0000, 0x1179, 0x0000, 0x0000, 0x117b, 0x0000, 0x0000, 0x0000,
 0x0000, 0x117d, 0x117e, 0x0000, 0x0000, 0x0000, 0x117f, 0x1181, 0x0000, 0x1182,
 0x0000, 0x1184, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1186,
 0x0000, 0x0000, 0x1188, 0x0000, 0x0000, 0x1191, 0x0000, 0x119c, 0x0000, 0x0000,
 0x119e, 0x119f, 0x0000, 0x11a8, 0x11ab, 0x0000, 0x11ac, 0x0000, 0x11ad, 0x0000,
 0x11af, 0x0000, 0x0000, 0x11b0, 0x0000, 0x0000, 0x0000, 0x0000, 0x11b2, 0x0000,
 0x11b3, 0x0000, 0x0000, 0x11b4, 0x0000, 0x0000, 0x0000, 0x11b5, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x11b7, 0x0000, 0x0000, 0x0000, 0x11b8, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x11bd, 0x11bf, 0x11c0, 0x11c1, 0x11c3, 0x0000, 0x11c4,
 0x0000, 0x0000, 0x0000, 0x0000, 0x11c6, 0x11c7, 0x0000, 0x11c9, 0x0000, 0x0000,
 0x0000, 0x0000, 0x11d2, 0x0000, 0x0000, 0x11db, 0x0000, 0x0000, 0x0000, 0x11de,
 0x0000, 0x0000, 0x0000, 0x11df, 0x0000, 0x11e0, 0x0000, 0x11e1, 0x0000, 0x0000,
 0x0000, 0x11e5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x11e6, 0x0000, 0x0000,
 0x11ea, 0x0000, 0x0000, 0x0000, 0x11ec, 0x0000, 0x0000, 0x11f5, 0x0000, 0x11f6,
 0x0000, 0x0000, 0x0000, 0x0000, 0x1208, 0x1209, 0x0000, 0x120a, 0x0000, 0x0000,
 0x0000, 0x0000, 0x120b, 0x0000, 0x120c, 0x0000, 0x0000, 0x120d, 0x0000, 0x1210,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1211, 0x0000, 0x0000, 0x0000, 0x0000,
 0x1231, 0x0000, 0x1233, 0x0000, 0x123b, 0x0000, 0x0000, 0x0000, 0x123c, 0x123e,
 0x0000, 0x1240, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1241, 0x1244, 0x0000,
 0x0000, 0x0000, 0x0000, 0x124f, 0x0000, 0x0000, 0x0000, 0x0000, 0x1259, 0x0000,
 0x0000, 0x0000, 0x0000, 0x125b, 0x0000, 0x125d, 0x0000, 0x0000, 0x0000, 0x0000,
 0x125e, 0x0000, 0x0000, 0x1262, 0x0000, 0x0000, 0x1269, 0x0000, 0x0000, 0x0000,
 0x126a, 0x126b, 0x126c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x126d, 0x0000, 0x0000, 0x1270, 0x0000,
 0x1271, 0x1279, 0x127f, 0x0000, 0x0000, 0x0000, 0x1281, 0x0000, 0x0000, 0x0000,
 0x1283, 0x0000, 0x0000, 0x0000, 0x1284, 0x0000, 0x0000, 0x0000, 0x1285, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x1286, 0x0000, 0x1289, 0x128a, 0x128b, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x128c, 0x0000, 0x0000,
 0x0000, 0x128d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x128f, 0x12b2, 0x0000, 0x12b3, 0x0000, 0x12b4, 0x12bc,
 0x0000, 0x0000, 0x12bd, 0x12be, 0x0000, 0x12bf, 0x12c6, 0x12c7, 0x0000, 0x0000,
 0x0000, 0x0000, 0x12c9, 0x12ca, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x12cb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x12cc, 0x0000, 0x12cd, 0x0000,
 0x0000, 0x12cf, 0x0000, 0x12d5, 0x12d6, 0x0000, 0x0000, 0x0000, 0x0000, 0x12d7,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x12d8, 0x0000, 0x0000, 0x0000, 0x0000, 0x12da, 0x0000, 0x0000, 0x0000, 0x12dc,
 0x0000, 0x12dd, 0x0000, 0x0000, 0x0000, 0x12eb, 0x0000, 0x0000, 0x12ef, 0x0000,
 0x12f5, 0x12f7, 0x12fa, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x12fb, 0x0000,
 0x1300, 0x0000, 0x0000, 0x130f, 0x0000, 0x0000, 0x0000, 0x0000, 0x1310, 0x0000,
 0x0000, 0x0000, 0x0000, 0x1311, 0x0000, 0x1312, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1313, 0x0000, 0x0000, 0x0000, 0x0000,
 0x1314, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1316, 0x1317, 0x1318, 0x131e,
 0x1320, 0x0000, 0x1326, 0x0000, 0x0000, 0x1329, 0x0000, 0x0000, 0x1333, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1334, 0x1335, 0x1337, 0x1339,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x133e, 0x0000, 0x0000, 0x0000, 0x0000,
 0x133f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1341,
 0x0000, 0x1342, 0x1343, 0x0000, 0x134a, 0x0000, 0x1358, 0x0000, 0x1359, 0x135d,
 0x1360, 0x1364, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x139b,
 0x139c, 0x139e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x139f, 0x0000, 0x0000,
 0x0000, 0x13a0, 0x0000, 0x0000, 0x0000, 0x13a1, 0x0000, 0x0000, 0x0000, 0x0000,
 0x13a4, 0x0000, 0x0000, 0x0000, 0x0000, 0x13a5, 0x13a6, 0x13a7, 0x0000, 0x13a9,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x13aa,
 0x13ab, 0x0000, 0x13ac, 0x0000, 0x0000, 0x13ad, 0x0000, 0x0000, 0x0000, 0x0000,
 0x13ae, 0x0000, 0x0000, 0x13af, 0x0000, 0x0000, 0x0000, 0x13b1, 0x13b2, 0x0000,
 0x0000, 0x0000, 0x0000, 0x13b4, 0x13b9, 0x13be, 0x0000, 0x13bf, 0x0000, 0x13c1,
 0x0000, 0x0000, 0x0000, 0x13c4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x13c7,
 0x0000, 0x13c8, 0x13c9, 0x0000, 0x13cb, 0x0000, 0x0000, 0x0000, 0x13cc, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x13d4,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x13d5, 0x0000, 0x0000,
 0x13d6, 0x13d8, 0x0000, 0x0000, 0x13db, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x13dd, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x13ea, 0x13eb, 0x13ed, 0x13f1, 0x13f3, 0x0000, 0x13f4, 0x0000, 0x13f5, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x13f6, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x13fd, 0x13fe, 0x0000, 0x1401, 0x0000, 0x1402, 0x0000, 0x0000,
 0x140a, 0x0000, 0x0000, 0x0000, 0x1411, 0x0000, 0x0000, 0x0000, 0x141c, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x141f, 0x1422, 0x0000, 0x0000,
 0x0000, 0x1423, 0x0000, 0x0000, 0x1424, 0x1427, 0x1429, 0x0000, 0x0000, 0x0000,
 0x0000, 0x142a, 0x0000, 0x0000, 0x0000, 0x0000, 0x142b, 0x142c, 0x0000, 0x142e,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x142f, 0x0000, 0x0000, 0x0000, 0x1434, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x143a, 0x143b, 0x0000, 0x0000, 0x1446, 0x0000, 0x0000, 0x1447, 0x1448,
 0x144a, 0x0000, 0x0000, 0x144e, 0x1451, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x1453, 0x0000, 0x1456, 0x1459, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x145d, 0x0000, 0x145e, 0x1460, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1461,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1462, 0x1463,
 0x0000, 0x146f, 0x0000, 0x0000, 0x147c, 0x1481, 0x0000, 0x1486, 0x0000, 0x1487,
 0x0000, 0x0000, 0x1489, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x148a, 0x0000,
 0x148c, 0x1496, 0x0000, 0x149d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x14a0, 0x14a1, 0x14a2, 0x14a3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x14a4,
 0x0000, 0x14a5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x14a7, 0x14a8, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x14a9,
 0x14ab, 0x0000, 0x0000, 0x14ae, 0x0000, 0x0000, 0x14af, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x14b8, 0x0000, 0x0000, 0x14ba, 0x14bb, 0x14bc,
 0x0000, 0x14bd, 0x0000, 0x0000, 0x14be, 0x0000, 0x0000, 0x0000, 0x0000, 0x14bf,
 0x14c0, 0x0000, 0x14c1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x14c4, 0x0000,
 0x0000, 0x0000, 0x14c5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x14cd, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x14ce,
 0x0000, 0x14cf, 0x14d1, 0x0000, 0x14d4, 0x0000, 0x0000, 0x0000, 0x0000, 0x14da,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x14dc, 0x0000,
 0x0000, 0x14dd, 0x0000, 0x0000, 0x0000, 0x14de, 0x0000, 0x14df, 0x14e0, 0x0000,
 0x0000, 0x14e1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x14e3, 0x14e4,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x14e5,
 0x0000, 0x14e6, 0x0000, 0x14ea, 0x0000, 0x0000, 0x0000, 0x0000, 0x14ee, 0x0000,
 0x0000, 0x14ef, 0x0000, 0x0000, 0x14f1, 0x0000, 0x0000, 0x14f5, 0x0000, 0x14f7,
 0x0000, 0x14fd, 0x0000, 0x0000, 0x0000, 0x1503, 0x0000, 0x0000, 0x0000, 0x1504,
 0x0000, 0x0000, 0x0000, 0x1506, 0x0000, 0x1508, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x1509, 0x0000, 0x0000, 0x0000, 0x0000, 0x150b, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x150c, 0x150e, 0x1511, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1514, 0x0000,
 0x0000, 0x0000, 0x0000, 0x1515, 0x151a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x151b, 0x0000, 0x0000, 0x0000, 0x151c, 0x151d, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x151e, 0x0000,
 0x0000, 0x0000, 0x0000, 0x1522, 0x0000, 0x0000, 0x1523, 0x0000, 0x1527, 0x0000,
 0x0000, 0x0000, 0x0000, 0x1528, 0x153a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x153e, 0x0000, 0x1540, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1541, 0x1542, 0x0000, 0x0000, 0x0000,
 0x1543, 0x1544, 0x1547, 0x0000, 0x0000, 0x1548, 0x1549, 0x154b, 0x0000, 0x0000,
 0x0000, 0x1550, 0x1551, 0x0000, 0x0000, 0x0000, 0x1553, 0x0000, 0x0000, 0x0000,
 0x1555, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1558, 0x0000, 0x155a, 0x0000, 0x0000,
 0x155b, 0x0000, 0x155e, 0x0000, 0x0000, 0x1561, 0x0000, 0x0000, 0x1562, 0x0000,
 0x0000, 0x1564, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x1565, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x156c, 0x0000, 0x0000, 0x156d, 0x156e, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x1570, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1571,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1583, 0x0000, 0x0000, 0x0000, 0x1586,
 0x0000, 0x1587, 0x0000, 0x0000, 0x1588, 0x0000, 0x0000, 0x0000, 0x1589, 0x0000,
 0x158b, 0x0000, 0x0000, 0x158c, 0x158d, 0x0000, 0x158e, 0x0000, 0x0000, 0x1592,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x159e, 0x159f, 0x0000, 0x0000, 0x15a0,
 0x0000, 0x15a2, 0x0000, 0x0000, 0x15a7, 0x0000, 0x15a8, 0x0000, 0x0000, 0x15a9,
 0x0000, 0x15ab, 0x0000, 0x15b5, 0x0000, 0x0000, 0x15b6, 0x0000, 0x15b8, 0x15bf,
 0x0000, 0x0000, 0x0000, 0x0000, 0x15c0, 0x0000, 0x0000, 0x0000, 0x15c3, 0x15c5,
 0x0000, 0x15c6, 0x0000, 0x15c7, 0x0000, 0x0000, 0x0000, 0x0000, 0x15c9, 0x0000,
 0x0000, 0x15de, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x15e0, 0x15e9, 0x0000, 0x0000, 0x0000, 0x0000, 0x15ea, 0x0000, 0x0000,
 0x15ec, 0x0000, 0x15f8, 0x0000, 0x15f9, 0x0000, 0x0000, 0x0000, 0x15fd, 0x0000,
 0x1609, 0x0000, 0x160a, 0x160b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x1613, 0x0000, 0x0000, 0x0000, 0x1614, 0x1615, 0x0000, 0x161d, 0x161e, 0x162e,
 0x0000, 0x162f, 0x0000, 0x0000, 0x0000, 0x0000, 0x1635, 0x1636, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x163a, 0x163c, 0x0000, 0x1647, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x164a, 0x0000, 0x0000, 0x0000, 0x0000, 0x164b, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x164c, 0x0000, 0x0000, 0x164d, 0x0000, 0x164e,
 0x0000, 0x0000, 0x0000, 0x1650, 0x0000, 0x1665, 0x0000, 0x1666, 0x1667, 0x0000,
 0x0000, 0x1670, 0x1677, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1678, 0x0000, 0x167a, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x167d, 0x167e, 0x0000, 0x1680, 0x1681, 0x0000,
 0x0000, 0x0000, 0x0000, 0x1683, 0x1684, 0x1685, 0x0000, 0x1686, 0x0000, 0x1687,
 0x1688, 0x0000, 0x168a, 0x0000, 0x0000, 0x0000, 0x0000, 0x1690, 0x1694, 0x0000,
 0x0000, 0x0000, 0x0000, 0x1696, 0x0000, 0x0000, 0x0000, 0x0000, 0x1698, 0x0000,
 0x0000, 0x169c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x16a5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x16a7,
 0x0000, 0x0000, 0x16a9, 0x0000, 0x0000, 0x0000, 0x16b3, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x16b8, 0x0000, 0x0000, 0x16c3, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x16c6, 0x16c7, 0x0000, 0x0000, 0x16c8,
 0x0000, 0x0000, 0x16c9, 0x0000, 0x16cb, 0x16d4, 0x16d5, 0x0000, 0x16d6, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x16da, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x16dc, 0x0000, 0x16df, 0x16e1, 0x0000, 0x0000, 0x16e3, 0x0000, 0x16e5, 0x0000,
 0x0000, 0x16e7, 0x0000, 0x16e9, 0x0000, 0x0000, 0x0000, 0x16f1, 0x16f3, 0x0000,
 0x0000, 0x0000, 0x16f5, 0x0000, 0x16f7, 0x0000, 0x0000, 0x0000, 0x1700, 0x0000,
 0x0000, 0x1701, 0x1703, 0x0000, 0x1706, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x1707, 0x0000, 0x1709, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x1713, 0x0000, 0x1717, 0x0000, 0x0000, 0x1718, 0x0000, 0x1719, 0x1722, 0x1724,
 0x0000, 0x1727, 0x1728, 0x0000, 0x0000, 0x0000, 0x0000, 0x1729, 0x172a, 0x0000,
 0x172d, 0x0000, 0x0000, 0x0000, 0x0000, 0x173d, 0x0000, 0x0000, 0x173f, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1741, 0x0000, 0x0000,
 0x1742, 0x0000, 0x1747, 0x1748, 0x1749, 0x0000, 0x174c, 0x0000, 0x0000, 0x0000,
 0x1758, 0x175a, 0x1763, 0x1766, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1767,
 0x0000, 0x1768, 0x0000, 0x0000, 0x0000, 0x176a, 0x176b, 0x0000, 0x0000, 0x176c,
 0x0000, 0x0000, 0x1771, 0x1773, 0x0000, 0x0000, 0x0000, 0x0000, 0x1777, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x1778, 0x0000, 0x0000, 0x1779, 0x0000, 0x177a,
 0x0000, 0x0000, 0x0000, 0x177b, 0x177f, 0x0000, 0x1781, 0x0000, 0x1783, 0x0000,
 0x1787, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1789, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x178a,
 0x0000, 0x178e, 0x0000, 0x0000, 0x1790, 0x0000, 0x0000, 0x0000, 0x1791, 0x1796,
 0x1798, 0x0000, 0x0000, 0x0000, 0x1799, 0x179d, 0x0000, 0x0000, 0x179e, 0x0000,
 0x0000, 0x17a5, 0x0000, 0x0000, 0x17a6, 0x0000, 0x17a7, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x17a9, 0x0000, 0x17af, 0x0000, 0x0000, 0x0000, 0x17b0,
 0x0000, 0x17b2, 0x17b7, 0x17b8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x17bb, 0x17bc, 0x0000, 0x0000, 0x17bd, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x17be, 0x17bf, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x17c0, 0x0000, 0x17c3, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x17c4, 0x0000, 0x0000, 0x17c8, 0x0000, 0x17c9, 0x0000, 0x0000,
 0x17cd, 0x17d9, 0x0000, 0x0000, 0x17db, 0x0000, 0x17de, 0x0000, 0x0000, 0x0000,
 0x17df, 0x17ed, 0x17ee, 0x0000, 0x0000, 0x0000, 0x17f1, 0x0000, 0x0000, 0x0000,
 0x0000, 0x17f2, 0x0000, 0x0000, 0x0000, 0x17f3, 0x17f6, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x17fe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1800,
 0x0000, 0x0000, 0x1802, 0x1807, 0x1809, 0x0000, 0x180c, 0x0000, 0x1813, 0x0000,
 0x1824, 0x1825, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1826, 0x0000, 0x0000,
 0x0000, 0x0000, 0x1828, 0x1833, 0x0000, 0x0000, 0x183e, 0x0000, 0x1840, 0x0000,
 0x0000, 0x1844, 0x1845, 0x1846, 0x0000, 0x1847, 0x0000, 0x0000, 0x0000, 0x1854,
 0x0000, 0x0000, 0x0000, 0x185a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x185b, 0x1860, 0x0000, 0x1862, 0x1863, 0x1864, 0x0000, 0x186a, 0x186f, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x1871, 0x0000, 0x0000, 0x0000, 0x1872, 0x1886,
 0x0000, 0x188c, 0x0000, 0x0000, 0x0000, 0x188d, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x188e, 0x0000, 0x0000, 0x0000, 0x18b0, 0x0000,
 0x0000, 0x18b2, 0x18bc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x18be, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x18bf,
 0x0000, 0x0000, 0x18c1, 0x0000, 0x18c2, 0x0000, 0x18c3, 0x18c4, 0x0000, 0x0000,
 0x18d4, 0x18d5, 0x18e1, 0x0000, 0x0000, 0x0000, 0x18e2, 0x18e3, 0x18e4, 0x0000,
 0x18e5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x18e8, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x18ee, 0x18ef, 0x18f0, 0x0000, 0x0000, 0x0000, 0x0000, 0x18f2,
 0x0000, 0x18f5, 0x18fd, 0x1900, 0x190b, 0x0000, 0x190e, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x190f, 0x1910, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x1911, 0x0000, 0x0000, 0x0000, 0x0000, 0x1912, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1914, 0x0000, 0x1915, 0x1917, 0x1919,
 0x0000, 0x191d, 0x191e, 0x0000, 0x1921, 0x1926, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1927, 0x1928, 0x0000, 0x0000,
 0x1929, 0x0000, 0x0000, 0x192c, 0x0000, 0x0000, 0x0000, 0x0000, 0x192e, 0x0000,
 0x0000, 0x0000, 0x0000, 0x192f, 0x1930, 0x0000, 0x0000, 0x1932, 0x0000, 0x0000,
 0x0000, 0x1936, 0x0000, 0x0000, 0x1937, 0x0000, 0x193d, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x193e, 0x0000, 0x0000, 0x193f, 0x0000, 0x1940, 0x0000,
 0x1941, 0x1943, 0x0000, 0x0000, 0x0000, 0x1944, 0x0000, 0x194f, 0x1950, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1951, 0x0000, 0x0000, 0x1955,
 0x1957, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x195d, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x195e, 0x195f, 0x1960, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x1962, 0x0000, 0x0000, 0x0000, 0x196b, 0x196c,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x196f, 0x1970, 0x0000, 0x0000, 0x0000, 0x0000, 0x1971, 0x0000, 0x0000, 0x0000,
 0x1972, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1974, 0x0000, 0x0000, 0x1975,
 0x1976, 0x0000, 0x0000, 0x0000, 0x1977, 0x1978, 0x1979, 0x0000, 0x197b, 0x0000,
 0x0000, 0x0000, 0x0000, 0x197c, 0x1980, 0x0000, 0x1982, 0x0000, 0x0000, 0x1984,
 0x0000, 0x19b2, 0x0000, 0x0000, 0x0000, 0x19b7, 0x0000, 0x19b8, 0x0000, 0x0000,
 0x0000, 0x19bb, 0x0000, 0x0000, 0x0000, 0x19be, 0x0000, 0x19bf, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x19c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x19c1, 0x19c2,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x19c7, 0x19c8, 0x0000, 0x0000, 0x19c9,
 0x19ca, 0x19cc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x19d0, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x19d2, 0x19d3, 0x0000, 0x19d7, 0x0000,
 0x19d8, 0x19da, 0x19dc, 0x0000, 0x19ed, 0x0000, 0x0000, 0x0000, 0x0000, 0x19ef,
 0x0000, 0x0000, 0x0000, 0x0000, 0x19f1, 0x0000, 0x19f2, 0x0000, 0x0000, 0x0000,
 0x19f7, 0x0000, 0x1a04, 0x1a07, 0x0000, 0x1a08, 0x0000, 0x1a0a, 0x1a0d, 0x0000,
 0x1a13, 0x1a14, 0x1a15, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x1a16, 0x0000, 0x0000, 0x0000, 0x1a17, 0x0000, 0x1a18, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1a25, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1a30, 0x1a31, 0x1a32, 0x0000,
 0x0000, 0x1a37, 0x1a39, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1a3c, 0x0000,
 0x0000, 0x0000, 0x1a3d, 0x0000, 0x1a3f, 0x1a44, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x1a45, 0x1a46, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x1a48, 0x1a49, 0x1a4f, 0x0000, 0x1a51, 0x1a56, 0x0000, 0x0000, 0x1a57,
 0x1a5e, 0x0000, 0x1a5f, 0x0000, 0x0000, 0x1a60, 0x1a61, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x1a62, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1a64,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1a6b, 0x0000, 0x0000, 0x1a6c,
 0x1a6d, 0x0000, 0x0000, 0x0000, 0x1a72, 0x0000, 0x0000, 0x0000, 0x1a78, 0x1a7c,
 0x0000, 0x1a7d, 0x0000, 0x0000, 0x0000, 0x1a7f, 0x0000, 0x1a80, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1a81, 0x0000, 0x0000,
 0x0000, 0x1a88, 0x0000, 0x0000, 0x0000, 0x1a89, 0x0000, 0x0000, 0x1a92, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x1a93, 0x0000, 0x0000, 0x0000, 0x1a94, 0x0000,
 0x0000, 0x0000, 0x1a9c, 0x0000, 0x0000, 0x1aa7, 0x0000, 0x1aa8, 0x1ab7, 0x0000,
 0x0000, 0x0000, 0x0000, 0x1ac4, 0x0000, 0x0000, 0x1ac6, 0x0000, 0x1ac8, 0x1ac9,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ad3,
 0x0000, 0x1ad4, 0x1ad6, 0x1ad8, 0x0000, 0x0000, 0x0000, 0x1ad9, 0x1ada, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x1adb, 0x0000, 0x0000, 0x1add, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ade, 0x0000, 0x0000, 0x0000, 0x1adf,
 0x0000, 0x1ae0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x1ae7, 0x0000, 0x1ae8, 0x1aeb, 0x1aed, 0x0000, 0x1aef, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1af3, 0x0000, 0x0000,
 0x0000, 0x0000, 0x1af5, 0x0000, 0x0000, 0x0000, 0x0000, 0x1afe, 0x0000, 0x1aff,
 0x0000, 0x0000, 0x1b00, 0x0000, 0x0000, 0x1b01, 0x1b02, 0x0000, 0x0000, 0x0000,
 0x1b03, 0x0000, 0x0000, 0x0000, 0x1b04, 0x1b07, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x1b0c, 0x0000, 0x1b0d, 0x0000, 0x0000, 0x0000, 0x1b0e, 0x1b0f,
 0x1b10, 0x0000, 0x1b11, 0x0000, 0x1b12, 0x0000, 0x0000, 0x1b13, 0x1b17, 0x0000,
 0x1b18, 0x0000, 0x0000, 0x0000, 0x0000, 0x1b1b, 0x1b1c, 0x1b1d, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x1b1e, 0x1b24, 0x1b25, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x1b28, 0x1b2a, 0x1b33, 0x1b35, 0x1b36, 0x0000, 0x0000,
 0x1b37, 0x1b38, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x1b39, 0x0000, 0x0000, 0x1b3a, 0x1b43, 0x0000, 0x0000, 0x1b44, 0x0000,
 0x0000, 0x1b47, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1b48, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1b4c, 0x1b4e, 0x1b50, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1b53, 0x0000, 0x0000, 0x0000, 0x1b64,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1b6b,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1b6d, 0x0000,
 0x0000, 0x1b6e, 0x1b6f, 0x1b74, 0x0000, 0x1b76, 0x1b79, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x1b7e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x1b7f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x1b86, 0x0000, 0x1b87, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x1b88, 0x1b8c, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x1b8e, 0x0000, 0x1b94, 0x0000, 0x0000, 0x0000, 0x0000, 0x1b95, 0x0000,
 0x1b99, 0x0000, 0x0000, 0x0000, 0x0000, 0x1b9b, 0x1b9d, 0x0000, 0x1b9e, 0x1b9f,
 0x1ba0, 0x0000, 0x0000, 0x1ba6, 0x0000, 0x1ba8, 0x1ba9, 0x0000, 0x1bab, 0x0000,
 0x0000, 0x0000, 0x1bac, 0x1baf, 0x1bb0, 0x0000, 0x0000, 0x1bb2, 0x0000, 0x1bb5,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1bc3, 0x0000, 0x0000, 0x1bc4, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1bc6, 0x0000, 0x1bca,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1bcb, 0x0000, 0x1bcc,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1bcd, 0x0000, 0x0000, 0x1bce, 0x0000,
 0x0000, 0x1bd4, 0x0000, 0x1bd5, 0x0000, 0x0000, 0x1bd6, 0x0000, 0x0000, 0x0000,
 0x0000, 0x1bd8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1bd9, 0x0000, 0x1bda,
 0x0000, 0x1bdc, 0x1bdd, 0x0000, 0x0000, 0x1bde, 0x0000, 0x0000, 0x1be3, 0x0000,
 0x1bec, 0x1bee, 0x0000, 0x0000, 0x0000, 0x0000, 0x1bf0, 0x0000, 0x0000, 0x0000,
 0x1bf1, 0x1bf4, 0x1bf5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1bf6, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1bfb,
 0x1bfd, 0x1c01, 0x0000, 0x1c03, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x1c04, 0x0000, 0x1c05, 0x1c0d, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x1c0e, 0x1c11, 0x0000, 0x0000, 0x0000, 0x0000, 0x1c13, 0x0000,
 0x1c21, 0x1c24, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1c26, 0x1c27, 0x0000,
 0x0000, 0x0000, 0x0000, 0x1c2b, 0x1c30, 0x0000, 0x1c32, 0x0000, 0x0000, 0x0000,
 0x0000, 0x1c3a, 0x1c3c, 0x1c3e, 0x1c40, 0x1c41, 0x1c43, 0x1c45, 0x0000, 0x0000,
 0x0000, 0x0000, 0x1c46, 0x1c49, 0x0000, 0x1c4a, 0x0000, 0x0000, 0x1c4f, 0x0000,
 0x0000, 0x0000, 0x1c62, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x1c79, 0x0000, 0x0000, 0x1c7a, 0x1c7b, 0x0000, 0x0000, 0x1c7c, 0x0000, 0x1c81,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x1c84, 0x0000, 0x1c85, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1c86, 0x0000, 0x0000, 0x0000, 0x0000,
 0x1c89, 0x0000, 0x0000, 0x0000, 0x0000, 0x1c8b, 0x0000, 0x1c8c, 0x0000, 0x1c8e,
 0x0000, 0x1ca7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ca9,
 0x0000, 0x1caf, 0x1cb3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1cb4, 0x0000,
 0x1cb5, 0x1cb6, 0x1cb8, 0x1cba, 0x0000, 0x0000, 0x0000, 0x0000, 0x1cbd, 0x0000,
 0x1cbe, 0x1cc6, 0x0000, 0x1cc7, 0x1cc8, 0x0000, 0x0000, 0x1ccd, 0x0000, 0x0000,
 0x0000, 0x1cce, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1cd0,
 0x0000, 0x0000, 0x0000, 0x1cd1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1cd2,
 0x0000, 0x1cd3, 0x1cd4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1cd7, 0x0000,
 0x0000, 0x1cda, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ce6, 0x0000, 0x0000, 0x0000,
 0x1ce7, 0x1ce8, 0x0000, 0x1ce9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x1cea, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ced, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x1cee, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x1cfd, 0x1d03, 0x1d05, 0x0000, 0x0000, 0x0000, 0x1d0b, 0x0000,
 0x0000, 0x1d0c, 0x0000, 0x0000, 0x0000, 0x1d0d, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x1d0e, 0x1d13, 0x0000, 0x1d16, 0x0000, 0x1d18, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1d20, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x1d21, 0x0000, 0x0000, 0x1d25, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x1d26, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1d27, 0x1d2a,
 0x1d30, 0x0000, 0x1d34, 0x0000, 0x0000, 0x1d42, 0x0000, 0x1d43, 0x0000, 0x0000,
 0x1d45, 0x0000, 0x0000, 0x0000, 0x1d4a, 0x1d4b, 0x0000, 0x0000, 0x1d54, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x1d58, 0x0000, 0x0000, 0x0000, 0x1d59, 0x1d5a,
 0x1d5c, 0x0000, 0x0000, 0x0000, 0x0000, 0x1d5e, 0x0000, 0x0000, 0x1d5f, 0x1d61,
 0x1d62, 0x0000, 0x0000, 0x0000, 0x1d66, 0x0000, 0x0000, 0x1d69, 0x0000, 0x0000,
 0x1d6b, 0x0000, 0x1d70, 0x0000, 0x1d72, 0x0000, 0x1d73, 0x0000, 0x0000, 0x1d75,
 0x1d76, 0x1d7a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1d7b, 0x0000, 0x1d7c,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1d7e, 0x0000, 0x0000, 0x1d80, 0x1d81,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x1d82, 0x1d8b, 0x0000, 0x1d95, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x1d96, 0x1d98, 0x0000, 0x1d9a, 0x1d9d, 0x1d9f, 0x0000, 0x0000, 0x0000, 0x1da0,
 0x0000, 0x1da3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1da5, 0x0000, 0x0000,
 0x0000, 0x1daa, 0x0000, 0x0000, 0x1dab, 0x0000, 0x0000, 0x1db0, 0x1db2, 0x1dba,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1dbc, 0x0000, 0x1dbd, 0x1dbe, 0x0000,
 0x0000, 0x1dbf, 0x0000, 0x0000, 0x1dc0, 0x0000, 0x1dc4, 0x0000, 0x1dc5, 0x1dc6,
 0x0000, 0x1dc7, 0x0000, 0x0000, 0x0000, 0x0000, 0x1dca, 0x0000, 0x0000, 0x0000,
 0x0000, 0x1dcb, 0x1dcd, 0x1dcf, 0x0000, 0x0000, 0x1dd1, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x1dd7, 0x0000, 0x1dd8, 0x1dda, 0x0000, 0x0000, 0x1ddb, 0x0000,
 0x0000, 0x0000, 0x0000, 0x1ddc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x1ddd, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ded, 0x1dee, 0x1def,
 0x1df1, 0x0000, 0x1df2, 0x0000, 0x1df3, 0x0000, 0x1e04, 0x1e08, 0x1e0a, 0x0000,
 0x1e0b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e0c, 0x0000, 0x0000,
 0x1e14, 0x0000, 0x1e1b, 0x0000, 0x1e1c, 0x0000, 0x1e1d, 0x0000, 0x1e29, 0x0000,
 0x0000, 0x0000, 0x1e2a, 0x0000, 0x1e2c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x1e31, 0x1e33, 0x0000, 0x1e34, 0x0000, 0x1e35, 0x1e37, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e3b, 0x0000, 0x0000, 0x1e3d, 0x1e41,
 0x0000, 0x1e44, 0x0000, 0x0000, 0x0000, 0x1e47, 0x0000, 0x0000, 0x0000, 0x1e48,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e49, 0x0000, 0x0000,
 0x1e4c, 0x0000, 0x1e4d, 0x0000, 0x1e4f, 0x0000, 0x1e50, 0x0000, 0x0000, 0x0000,
 0x0000, 0x1e51, 0x1e58, 0x0000, 0x0000, 0x1e59, 0x0000, 0x0000, 0x1e5a, 0x0000,
 0x0000, 0x1e5b, 0x0000, 0x0000, 0x1e5c, 0x0000, 0x0000, 0x1e5d, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x1e62, 0x1e67, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x1e68, 0x1e69, 0x0000, 0x1e6e, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e70, 0x0000,
 0x1e76, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e77, 0x0000, 0x1e82, 0x0000,
 0x0000, 0x1e85, 0x0000, 0x1e86, 0x0000, 0x1e88, 0x0000, 0x1e8a, 0x1e90, 0x1e91,
 0x1e92, 0x0000, 0x1e94, 0x1e96, 0x0000, 0x0000, 0x0000, 0x1ea0, 0x0000, 0x1ea2,
 0x0000, 0x1ea3, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ea4, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x1ea6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x1eb0, 0x1eb1, 0x1eb2, 0x1eb6, 0x0000, 0x1eb9, 0x0000, 0x0000, 0x1eba, 0x0000,
 0x0000, 0x1ee9, 0x0000, 0x0000, 0x0000, 0x0000, 0x1eea, 0x0000, 0x0000, 0x1eeb,
 0x1eed, 0x1eee, 0x1eef, 0x0000, 0x1ef0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x1ef1, 0x1ef2, 0x0000, 0x1ef4, 0x0000, 0x0000, 0x1ef5, 0x0000, 0x0000, 0x1ef7,
 0x0000, 0x1efa, 0x1eff, 0x0000, 0x0000, 0x1f01, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x1f03, 0x0000, 0x1f04, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x1f05, 0x0000, 0x0000, 0x0000, 0x0000, 0x1f09, 0x0000, 0x0000, 0x0000, 0x0000,
 0x1f0d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1f0e,
 0x0000, 0x1f11, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1f20,
 0x0000, 0x0000, 0x0000, 0x0000, 0x1f21, 0x1f24, 0x1f38, 0x0000, 0x1f39, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x1f3a, 0x0000, 0x0000, 0x0000, 0x0000, 0x1f47, 0x1f48, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1f4a,
 0x0000, 0x0000, 0x0000, 0x1f4c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x1f52, 0x0000, 0x1f5c, 0x1f5d, 0x0000, 0x0000, 0x1f5e, 0x0000,
 0x0000, 0x1f60, 0x1f61, 0x0000, 0x0000, 0x1f62, 0x1f64, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1f65, 0x0000, 0x0000,
 0x0000, 0x1f6b, 0x1f74, 0x1f7b, 0x1f7c, 0x0000, 0x0000, 0x1f7d, 0x0000, 0x0000,
 0x0000, 0x1f7e, 0x0000, 0x1f7f, 0x0000, 0x1f80, 0x0000, 0x1f82, 0x1f84, 0x0000,
 0x0000, 0x0000, 0x1f90, 0x1f91, 0x0000, 0x1f99, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x1f9c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1f9d, 0x1fae,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1faf, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x1fb0, 0x1fb3, 0x0000, 0x1fb5, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x1fb8, 0x1fb9, 0x1fba, 0x1fc0, 0x1fc1, 0x1fc2, 0x1fc3,
 0x0000, 0x0000, 0x1fcb, 0x0000, 0x0000, 0x1fd0, 0x0000, 0x0000, 0x0000, 0x0000,
 0x1fd1, 0x1fd2, 0x1fd9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x1fda, 0x0000, 0x1fdd, 0x1fe0, 0x1fe2, 0x0000, 0x1fe4, 0x1fe5, 0x0000,
 0x0000, 0x0000, 0x0000, 0x1fe6, 0x1fe7, 0x0000, 0x0000, 0x1ff3, 0x0000, 0x0000,
 0x0000, 0x1ff9, 0x0000, 0x0000, 0x0000, 0x1ffa, 0x0000, 0x0000, 0x1ffb, 0x0000,
 0x0000, 0x0000, 0x1ffc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x200c, 0x0000,
 0x0000, 0x0000, 0x0000, 0x2012, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2015,
 0x0000, 0x2016, 0x0000, 0x0000, 0x2017, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x201a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x201b, 0x0000, 0x201d, 0x0000, 0x0000, 0x201e, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x2021, 0x0000, 0x0000, 0x0000, 0x2029, 0x0000, 0x0000,
 0x2032, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x2037, 0x0000, 0x2038, 0x203c, 0x0000, 0x2040, 0x2041, 0x0000,
 0x0000, 0x2045, 0x0000, 0x2048, 0x2049, 0x0000, 0x0000, 0x0000, 0x0000, 0x204b,
 0x0000, 0x0000, 0x0000, 0x204d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x204e, 0x0000, 0x0000, 0x0000, 0x2056, 0x0000, 0x2057,
 0x205b, 0x0000, 0x0000, 0x205d, 0x205e, 0x2061, 0x2064, 0x0000, 0x0000, 0x0000,
 0x0000, 0x2065, 0x2067, 0x206b, 0x206c, 0x206d, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x2070, 0x2073, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x2081, 0x0000, 0x0000, 0x0000, 0x2082, 0x2083, 0x2085, 0x2086, 0x2087,
 0x0000, 0x0000, 0x208c, 0x2092, 0x0000, 0x0000, 0x2094, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x209e, 0x0000, 0x0000, 0x209f, 0x0000, 0x20a2, 0x20a3, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x20a8, 0x20b4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x20b9, 0x0000, 0x0000, 0x0000, 0x0000, 0x20bc, 0x0000,
 0x0000, 0x0000, 0x20bf, 0x0000, 0x20c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x20c2,
 0x20c8, 0x0000, 0x0000, 0x20ca, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x20cc, 0x20cd, 0x0000, 0x20ce, 0x0000, 0x20cf, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x20d0, 0x0000, 0x20d1, 0x20da, 0x20db, 0x0000, 0x20dc, 0x20dd,
 0x20e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x20e7, 0x0000, 0x0000, 0x0000, 0x0000,
 0x20e8, 0x0000, 0x0000, 0x20e9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x20f9, 0x20fa, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x20fb,
 0x0000, 0x0000, 0x20fc, 0x0000, 0x20ff, 0x0000, 0x0000, 0x0000, 0x0000, 0x2103,
 0x0000, 0x210a, 0x0000, 0x210e, 0x0000, 0x0000, 0x2114, 0x0000, 0x2115, 0x0000,
 0x0000, 0x0000, 0x2116, 0x0000, 0x2119, 0x211f, 0x2120, 0x0000, 0x0000, 0x0000,
 0x0000, 0x2121, 0x2123, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x2124, 0x0000, 0x0000, 0x212a, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x212b, 0x212d, 0x212e, 0x0000, 0x2150, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x2152, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x2156, 0x215a, 0x215c, 0x0000, 0x0000, 0x215d, 0x0000,
 0x0000, 0x2161, 0x0000, 0x216d, 0x0000, 0x0000, 0x2179, 0x217a, 0x0000, 0x0000,
 0x217b, 0x217e, 0x217f, 0x2183, 0x0000, 0x2187, 0x0000, 0x0000, 0x0000, 0x0000,
 0x218f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x219e,
 0x0000, 0x219f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x21a0, 0x0000, 0x0000, 0x21a1, 0x0000, 0x0000, 0x0000, 0x21a2, 0x0000,
 0x0000, 0x0000, 0x21a3, 0x0000, 0x0000, 0x21a5, 0x21a9, 0x21ad, 0x0000, 0x0000,
 0x21ae, 0x0000, 0x21af, 0x0000, 0x21b0, 0x21b1, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x21bd, 0x21be, 0x21bf, 0x21ca, 0x0000,
 0x0000, 0x0000, 0x0000, 0x21cc, 0x21ce, 0x21cf, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x21d0, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x21d1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x21d2, 0x0000, 0x0000, 0x21d3, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x21d4, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x21d5, 0x21d7, 0x21d8, 0x0000, 0x0000, 0x0000, 0x0000,
 0x21d9, 0x0000, 0x21dd, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x21df, 0x21e2, 0x0000, 0x21ec, 0x0000, 0x21ee, 0x0000, 0x0000, 0x0000, 0x21f1,
 0x0000, 0x0000, 0x0000, 0x21f2, 0x0000, 0x2202, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2206, 0x0000, 0x2207,
 0x2209, 0x220a, 0x2214, 0x2217, 0x2218, 0x221d, 0x2220, 0x0000, 0x2221, 0x2223,
 0x0000, 0x0000, 0x0000, 0x0000, 0x2226, 0x2227, 0x2229, 0x2232, 0x0000, 0x0000,
 0x0000, 0x0000, 0x2234, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2235,
 0x2238, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x223a, 0x223b, 0x223c, 0x0000,
 0x223e, 0x2241, 0x2242, 0x2245, 0x0000, 0x2246, 0x0000, 0x224b, 0x0000, 0x0000,
 0x0000, 0x0000, 0x224c, 0x0000, 0x0000, 0x224d, 0x0000, 0x0000, 0x224f, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x2250, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x2251, 0x0000, 0x0000, 0x0000, 0x0000, 0x2252, 0x0000, 0x0000, 0x0000, 0x0000,
 0x2254, 0x2256, 0x0000, 0x0000, 0x0000, 0x2263, 0x0000, 0x226d, 0x226e, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x226f, 0x2270, 0x0000, 0x0000, 0x0000, 0x0000,
 0x2272, 0x0000, 0x0000, 0x0000, 0x0000, 0x2276, 0x227c, 0x227d, 0x0000, 0x227f,
 0x0000, 0x0000, 0x0000, 0x0000, 0x2281, 0x0000, 0x0000, 0x0000, 0x2282, 0x0000,
 0x0000, 0x0000, 0x2283, 0x0000, 0x2284, 0x0000, 0x0000, 0x0000, 0x2285, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2286, 0x2287, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2288, 0x0000,
 0x0000, 0x0000, 0x2289, 0x0000, 0x228a, 0x0000, 0x0000, 0x0000, 0x228e, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x228f, 0x0000, 0x2290, 0x0000,
 0x0000, 0x22a0, 0x0000, 0x0000, 0x22a2, 0x0000, 0x0000, 0x22a6, 0x22a8, 0x0000,
 0x0000, 0x22a9, 0x22aa, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x22ab,
 0x0000, 0x22ac, 0x0000, 0x0000, 0x0000, 0x0000, 0x22c0, 0x22c4, 0x0000, 0x0000,
 0x0000, 0x0000, 0x22c5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x22c8, 0x0000,
 0x22cb, 0x0000, 0x0000, 0x0000, 0x0000, 0x22cf, 0x22d0, 0x22d1, 0x0000, 0x0000,
 0x0000, 0x22d2, 0x0000, 0x22d3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x22d4, 0x0000, 0x0000, 0x0000,
 0x22e1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x22e2, 0x0000, 0x22e4, 0x0000, 0x22ef, 0x0000, 0x0000, 0x0000, 0x22f1,
 0x22f3, 0x0000, 0x0000, 0x0000, 0x0000, 0x22f5, 0x0000, 0x22f6, 0x0000, 0x22fa,
 0x22fd, 0x0000, 0x0000, 0x230a, 0x0000, 0x0000, 0x0000, 0x0000, 0x230b, 0x0000,
 0x2324, 0x0000, 0x0000, 0x0000, 0x0000, 0x2325, 0x2328, 0x0000, 0x0000, 0x0000,
 0x0000, 0x2329, 0x232a, 0x0000, 0x232c, 0x2331, 0x2340, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2343,
 0x237a, 0x0000, 0x0000, 0x237b, 0x2381, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x2382, 0x0000, 0x0000, 0x0000, 0x2384, 0x0000, 0x0000, 0x2385, 0x0000,
 0x2387, 0x0000, 0x0000, 0x2388, 0x2389, 0x238d, 0x238e, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2398, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x239a, 0x0000, 0x0000, 0x23a0, 0x0000, 0x23a1, 0x23a2, 0x0000,
 0x0000, 0x0000, 0x23a3, 0x23a4, 0x0000, 0x0000, 0x23a5, 0x0000, 0x0000, 0x23a6,
 0x0000, 0x23a7, 0x0000, 0x0000, 0x23a9, 0x23ab, 0x0000, 0x0000, 0x0000, 0x23ac,
 0x0000, 0x0000, 0x23b0, 0x0000, 0x23b8, 0x0000, 0x0000, 0x23bc, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x23bd, 0x0000, 0x23c0, 0x23cb, 0x0000, 0x0000,
 0x23cd, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x23ce, 0x0000, 0x23d1, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x23d2, 0x0000, 0x0000, 0x0000, 0x0000, 0x23d4,
 0x0000, 0x23d6, 0x23d7, 0x23d8, 0x0000, 0x23d9, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x23e2, 0x0000, 0x23e3, 0x0000, 0x0000, 0x0000,
 0x23e4, 0x23e5, 0x0000, 0x0000, 0x23e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x23e7,
 0x0000, 0x0000, 0x0000, 0x23e9, 0x0000, 0x0000, 0x0000, 0x0000, 0x23ed, 0x23ee,
 0x0000, 0x0000, 0x0000, 0x23f8, 0x23fb, 0x0000, 0x0000, 0x0000, 0x0000, 0x2400,
 0x2401, 0x0000, 0x2404, 0x0000, 0x0000, 0x0000, 0x0000, 0x2405, 0x2406, 0x2407,
 0x0000, 0x2408, 0x2409, 0x0000, 0x0000, 0x240b, 0x0000, 0x240c, 0x240d, 0x0000,
 0x0000, 0x240e, 0x0000, 0x2410, 0x0000, 0x2411, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x2412, 0x2413, 0x0000, 0x0000, 0x2415, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x2416, 0x2418, 0x0000, 0x0000, 0x2419, 0x0000,
 0x0000, 0x0000, 0x0000, 0x241c, 0x0000, 0x0000, 0x0000, 0x0000, 0x241f, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2420,
 0x0000, 0x0000, 0x0000, 0x2421, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2422,
 0x0000, 0x0000, 0x0000, 0x0000, 0x2423, 0x0000, 0x0000, 0x2424, 0x2427, 0x0000,
 0x0000, 0x0000, 0x2428, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x2429, 0x0000, 0x0000, 0x242a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x242b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x242e, 0x242f, 0x0000, 0x0000,
 0x2431, 0x2432, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x2434, 0x2437, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x2439, 0x0000, 0x0000, 0x0000, 0x243c, 0x243d, 0x243f, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2440, 0x0000, 0x0000, 0x244d, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x2451, 0x2455, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x245c, 0x245d, 0x2461,
 0x2469, 0x246a, 0x0000, 0x246e, 0x246f, 0x0000, 0x0000, 0x2505, 0x0000, 0x2507,
 0x0000, 0x0000, 0x0000, 0x0000, 0x250a, 0x0000, 0x0000, 0x0000, 0x250b, 0x0000,
 0x250c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x250d, 0x0000, 0x0000, 0x250e, 0x0000, 0x0000, 0x0000, 0x2511, 0x0000, 0x0000,
 0x0000, 0x0000, 0x2512, 0x2513, 0x0000, 0x0000, 0x0000, 0x0000, 0x2515, 0x0000,
 0x2517, 0x2518, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x251c, 0x0000, 0x251e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2520, 0x2523,
 0x0000, 0x2525, 0x0000, 0x2527, 0x0000, 0x0000, 0x2529, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x252b, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x252c, 0x252d, 0x0000, 0x0000, 0x0000, 0x0000, 0x253c, 0x0000,
 0x0000, 0x253d, 0x0000, 0x0000, 0x2542, 0x0000, 0x2543, 0x2544, 0x0000, 0x0000,
 0x0000, 0x0000, 0x2545, 0x0000, 0x0000, 0x0000, 0x2546, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2548, 0x2549, 0x0000, 0x254a, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x254b, 0x254c, 0x0000, 0x0000, 0x0000,
 0x254e, 0x0000, 0x2555, 0x0000, 0x2556, 0x0000, 0x2559, 0x0000, 0x255b, 0x2562,
 0x0000, 0x2564, 0x2566, 0x2567, 0x0000, 0x0000, 0x0000, 0x2569, 0x2578, 0x0000,
 0x0000, 0x257c, 0x0000, 0x0000, 0x0000, 0x257e, 0x0000, 0x2580, 0x0000, 0x2581,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2588, 0x0000, 0x25a6, 0x25a7,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x25a9, 0x0000, 0x0000,
 0x25ab, 0x25ac, 0x25ad, 0x25ae, 0x0000, 0x0000, 0x0000, 0x25b0, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x25b2, 0x25b6, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x25b7, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x25b8, 0x0000, 0x25b9, 0x0000, 0x0000, 0x0000, 0x0000, 0x25ba, 0x0000,
 0x0000, 0x25bb, 0x0000, 0x0000, 0x25c0, 0x0000, 0x0000, 0x25c1, 0x0000, 0x25c3,
 0x25c5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x25c7, 0x0000, 0x25c9, 0x25d1, 0x0000, 0x0000, 0x0000,
 0x0000, 0x25d2, 0x25d3, 0x25d4, 0x0000, 0x0000, 0x0000, 0x0000, 0x25d6, 0x25e2,
 0x0000, 0x0000, 0x25e4, 0x25e5, 0x25e6, 0x0000, 0x25e7, 0x25f5, 0x0000, 0x0000,
 0x0000, 0x0000, 0x25f6, 0x0000, 0x25fe, 0x0000, 0x0000, 0x0000, 0x0000, 0x25ff,
 0x0000, 0x0000, 0x0000, 0x2600, 0x0000, 0x260e, 0x0000, 0x2610, 0x0000, 0x0000,
 0x0000, 0x2616, 0x0000, 0x261a, 0x261b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x261c, 0x0000, 0x261d, 0x2628, 0x0000, 0x2629, 0x0000, 0x0000, 0x0000, 0x262a,
 0x262b, 0x0000, 0x262d, 0x0000, 0x262e, 0x0000, 0x262f, 0x0000, 0x0000, 0x0000,
 0x2630, 0x2631, 0x2638, 0x0000, 0x0000, 0x0000, 0x263a, 0x0000, 0x263d, 0x0000,
 0x0000, 0x0000, 0x0000, 0x2641, 0x2642, 0x0000, 0x0000, 0x0000, 0x2650, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x2653, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2654, 0x0000, 0x265c,
 0x0000, 0x265f, 0x0000, 0x2664, 0x0000, 0x0000, 0x0000, 0x0000, 0x2666, 0x0000,
 0x0000, 0x2669, 0x266c, 0x0000, 0x0000, 0x0000, 0x2670, 0x0000, 0x0000, 0x0000,
 0x2671, 0x0000, 0x0000, 0x2672, 0x0000, 0x2675, 0x0000, 0x0000, 0x0000, 0x2677,
 0x2678, 0x0000, 0x0000, 0x267f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x2680, 0x2687, 0x2689, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x268a, 0x268b, 0x268c, 0x2691, 0x2693, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x2698, 0x0000, 0x269e, 0x0000, 0x0000, 0x0000, 0x269f, 0x0000,
 0x0000, 0x26a3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x26b2,
 0x26b3, 0x26b4, 0x0000, 0x0000, 0x0000, 0x26b5, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x26b6, 0x0000, 0x0000, 0x0000, 0x0000, 0x26b9, 0x0000, 0x0000,
 0x0000, 0x0000, 0x26ba, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x26c2, 0x0000,
 0x0000, 0x0000, 0x0000, 0x26c3, 0x26c5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x26ca, 0x0000, 0x0000, 0x0000, 0x26cb, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x26cc, 0x0000, 0x26d3, 0x0000, 0x0000, 0x26d4, 0x26ea, 0x26ee, 0x0000,
 0x26f1, 0x26f2, 0x0000, 0x0000, 0x26f6, 0x0000, 0x26fb, 0x26fd, 0x26fe, 0x0000,
 0x0000, 0x0000, 0x2701, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2703,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2704, 0x2709, 0x0000,
 0x0000, 0x270a, 0x0000, 0x0000, 0x0000, 0x270d, 0x0000, 0x2714, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x2717, 0x2723, 0x2724, 0x2726, 0x0000, 0x0000, 0x0000,
 0x272f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2730, 0x0000, 0x0000, 0x2732,
 0x0000, 0x2734, 0x0000, 0x0000, 0x0000, 0x0000, 0x2736, 0x0000, 0x2737, 0x2738,
 0x2739, 0x273a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x273b, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x273d, 0x2746, 0x0000, 0x0000, 0x0000, 0x0000, 0x2747,
 0x0000, 0x0000, 0x2749, 0x274a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x274b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x274c, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x274f, 0x0000, 0x2752, 0x0000,
 0x0000, 0x0000, 0x2756, 0x0000, 0x2758, 0x0000, 0x0000, 0x275c, 0x275d, 0x0000,
 0x0000, 0x2764, 0x0000, 0x2767, 0x276a, 0x276b, 0x0000, 0x0000, 0x0000, 0x276e,
 0x2771, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2772, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x2777, 0x0000, 0x2778, 0x0000, 0x277c, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2788, 0x0000, 0x0000,
 0x0000, 0x278a, 0x0000, 0x0000, 0x278d, 0x0000, 0x0000, 0x0000, 0x0000, 0x278f,
 0x2790, 0x0000, 0x0000, 0x2796, 0x0000, 0x2797, 0x2798, 0x0000, 0x2799, 0x0000,
 0x0000, 0x27a3, 0x0000, 0x27a5, 0x27a6, 0x0000, 0x0000, 0x27ac, 0x0000, 0x27ae,
 0x27af, 0x27b0, 0x27b8, 0x0000, 0x0000, 0x27bb, 0x0000, 0x27bd, 0x0000, 0x0000,
 0x0000, 0x27c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x27c1, 0x0000, 0x0000, 0x0000,
 0x0000, 0x27c2, 0x0000, 0x0000, 0x0000, 0x0000, 0x27d2, 0x0000, 0x27da, 0x0000,
 0x0000, 0x27db, 0x27dc, 0x0000, 0x27dd, 0x27de, 0x0000, 0x27df, 0x0000, 0x0000,
 0x0000, 0x0000, 0x27e1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x27e5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x27e9, 0x0000, 0x27f5,
 0x0000, 0x27f6, 0x27f7, 0x0000, 0x0000, 0x27f8, 0x0000, 0x0000, 0x27fd, 0x27fe,
 0x2804, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x280a, 0x0000, 0x280c, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x280f, 0x0000, 0x0000, 0x2811, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2812, 0x0000, 0x2813, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2814, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x282c, 0x2830, 0x2831, 0x0000, 0x0000, 0x0000,
 0x2832, 0x0000, 0x2838, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2839, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x283a, 0x0000, 0x0000, 0x0000, 0x0000,
 0x283b, 0x283f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2842, 0x0000, 0x0000,
 0x0000, 0x2843, 0x0000, 0x2844, 0x0000, 0x0000, 0x0000, 0x0000, 0x2847, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x284b, 0x284d, 0x0000, 0x0000,
 0x0000, 0x284e, 0x284f, 0x0000, 0x2851, 0x0000, 0x2856, 0x0000, 0x2858, 0x0000,
 0x0000, 0x0000, 0x0000, 0x2859, 0x0000, 0x0000, 0x285b, 0x0000, 0x285c, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x285e, 0x0000, 0x0000, 0x285f, 0x2862,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2863, 0x286d, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x286f, 0x0000, 0x2871, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x287a, 0x0000, 0x2880, 0x0000, 0x2881, 0x0000, 0x0000, 0x0000,
 0x2884, 0x2885, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2886, 0x0000, 0x0000,
 0x0000, 0x2887, 0x0000, 0x2888, 0x0000, 0x0000, 0x2892, 0x2894, 0x2896, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2897, 0x0000, 0x0000, 0x2898,
 0x289a, 0x0000, 0x0000, 0x289c, 0x0000, 0x289d, 0x0000, 0x28a3, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x28a4, 0x0000, 0x28a5, 0x28aa,
 0x0000, 0x0000, 0x28ab, 0x0000, 0x28ac, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x28b5, 0x28b6, 0x28b7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x28b9, 0x0000, 0x0000, 0x28bb, 0x0000, 0x0000,
 0x28be, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x28c0, 0x0000, 0x28c1, 0x28c2,
 0x0000, 0x0000, 0x0000, 0x0000, 0x28c4, 0x28c5, 0x0000, 0x28c6, 0x0000, 0x28c7,
 0x0000, 0x28cc, 0x28ce, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x28d0, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x28d1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x28d3, 0x0000, 0x28d5, 0x0000, 0x0000, 0x0000, 0x28d6, 0x28d9,
 0x0000, 0x0000, 0x28db, 0x0000, 0x28e5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x28e8, 0x28f1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x28f2, 0x28f3, 0x0000,
 0x28fc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x2903, 0x0000, 0x0000, 0x0000, 0x2906, 0x0000, 0x0000, 0x290e, 0x0000,
 0x2919, 0x291c, 0x0000, 0x0000, 0x291d, 0x291e, 0x2920, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2922, 0x0000, 0x0000, 0x0000, 0x0000,
 0x2925, 0x0000, 0x2926, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x2927, 0x2928, 0x0000, 0x0000, 0x2930, 0x0000, 0x2939,
 0x293c, 0x0000, 0x293d, 0x293f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2942,
 0x2943, 0x2944, 0x0000, 0x2945, 0x0000, 0x0000, 0x0000, 0x2946, 0x0000, 0x2947,
 0x0000, 0x0000, 0x0000, 0x0000, 0x294f, 0x0000, 0x0000, 0x2950, 0x0000, 0x2952,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x2959, 0x295a, 0x295b, 0x295d, 0x0000, 0x295e, 0x0000, 0x0000, 0x2962, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x2966, 0x0000, 0x0000, 0x2969, 0x0000, 0x0000,
 0x0000, 0x296a, 0x0000, 0x296b, 0x0000, 0x296c, 0x0000, 0x296d, 0x0000, 0x0000,
 0x296f, 0x0000, 0x2982, 0x0000, 0x2983, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x2985, 0x2986, 0x2987, 0x0000, 0x0000, 0x0000, 0x2996, 0x0000, 0x0000, 0x0000,
 0x2997, 0x0000, 0x299a, 0x0000, 0x299b, 0x0000, 0x0000, 0x0000, 0x299c, 0x299d,
 0x299f, 0x0000, 0x29a2, 0x0000, 0x0000, 0x29a3, 0x0000, 0x29ab, 0x0000, 0x0000,
 0x0000, 0x0000, 0x29ad, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x29ae, 0x0000, 0x0000, 0x0000, 0x29af, 0x0000, 0x0000, 0x0000,
 0x0000, 0x29b0, 0x29b1, 0x0000, 0x29b2, 0x0000, 0x0000, 0x0000, 0x29b4, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x29b6, 0x0000, 0x29ba, 0x0000, 0x0000,
 0x29c4, 0x0000, 0x29c9, 0x0000, 0x0000, 0x0000, 0x0000, 0x29ca, 0x0000, 0x0000,
 0x0000, 0x29cc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x29cf, 0x0000, 0x29d0,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x29d1, 0x0000, 0x29db,
 0x29de, 0x29e0, 0x0000, 0x0000, 0x29e2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x29e3, 0x0000, 0x0000, 0x0000, 0x0000, 0x29e6, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x29e7, 0x29ea, 0x29f7, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x29f8, 0x0000, 0x0000, 0x29f9, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x29fc, 0x0000, 0x0000, 0x0000, 0x0000, 0x29fe, 0x0000,
 0x0000, 0x2a00, 0x2a01, 0x0000, 0x0000, 0x0000, 0x2a04, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x2a06, 0x0000, 0x0000, 0x0000, 0x2a07, 0x0000, 0x2a11,
 0x0000, 0x0000, 0x2a14, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2a15,
 0x0000, 0x0000, 0x0000, 0x2a19, 0x0000, 0x0000, 0x2a1b, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2a1c, 0x2a20, 0x0000, 0x0000, 0x0000,
 0x2a25, 0x0000, 0x0000, 0x0000, 0x2a27, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x2a2b, 0x0000, 0x0000, 0x2a2c, 0x0000, 0x2a38,
 0x0000, 0x2a39, 0x0000, 0x0000, 0x0000, 0x2a3a, 0x0000, 0x0000, 0x0000, 0x2a3c,
 0x0000, 0x0000, 0x2a3e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x2a3f, 0x0000, 0x0000, 0x0000, 0x0000, 0x2a40, 0x2a41, 0x0000,
 0x0000, 0x0000, 0x0000, 0x2a43, 0x0000, 0x2a44, 0x0000, 0x0000, 0x0000, 0x0000,
 0x2a45, 0x2a46, 0x2a47, 0x0000, 0x2a4a, 0x2a61, 0x0000, 0x0000, 0x0000, 0x0000,
 0x2a62, 0x0000, 0x0000, 0x2a64, 0x0000, 0x2a65, 0x0000, 0x0000, 0x2a68, 0x0000,
 0x0000, 0x2a69, 0x2a6a, 0x2a6b, 0x2a6c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x2a6f, 0x0000, 0x2a72, 0x2a73, 0x2a78, 0x2a8a, 0x0000, 0x0000, 0x2a8b,
 0x2a8c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2a8d, 0x0000, 0x0000, 0x0000,
 0x2a90, 0x2a93, 0x0000, 0x0000, 0x2a94, 0x2a96, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x2a97, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x2a99, 0x0000, 0x2a9a, 0x0000, 0x0000, 0x0000,
 0x0000, 0x2a9c, 0x2a9f, 0x0000, 0x2aa0, 0x0000, 0x0000, 0x2aa4, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x2aa5, 0x0000, 0x2aa6, 0x0000, 0x0000, 0x0000, 0x2aab,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2aac, 0x0000, 0x0000, 0x2ab0, 0x2ab1,
 0x0000, 0x0000, 0x2ab2, 0x0000, 0x0000, 0x0000, 0x2ab4, 0x0000, 0x0000, 0x0000,
 0x0000, 0x2abb, 0x0000, 0x0000, 0x2ac1, 0x0000, 0x0000, 0x0000, 0x2ac3, 0x0000,
 0x0000, 0x2ac4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x2ace, 0x0000, 0x2ad0, 0x2ad2, 0x0000, 0x0000,
 0x2ad4, 0x0000, 0x0000, 0x0000, 0x2ad6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2ad7, 0x0000, 0x0000, 0x0000, 0x2ad8,
 0x0000, 0x0000, 0x0000, 0x2add, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2adf,
 0x0000, 0x0000, 0x0000, 0x2ae0, 0x2ae2, 0x0000, 0x0000, 0x2ae6, 0x2ae8, 0x2aeb,
 0x0000, 0x0000, 0x2aec, 0x0000, 0x2aed, 0x0000, 0x0000, 0x2aef, 0x0000, 0x0000,
 0x0000, 0x0000, 0x2af0, 0x0000, 0x0000, 0x0000, 0x2af1, 0x0000, 0x2af3, 0x0000,
 0x0000, 0x0000, 0x2af4, 0x2af5, 0x0000, 0x0000, 0x0000, 0x2af6, 0x0000, 0x2af7,
 0x0000, 0x2af9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2b02, 0x2b04,
 0x0000, 0x2b05, 0x2b08, 0x2b09, 0x0000, 0x0000, 0x2b0b, 0x2b0c, 0x2b0d, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x2b0e, 0x0000, 0x0000, 0x2b0f, 0x2b15, 0x0000, 0x0000, 0x0000, 0x0000,
 0x2b17, 0x0000, 0x0000, 0x0000, 0x2b1a, 0x0000, 0x0000, 0x0000, 0x0000, 0x2b2f,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2b30, 0x2b34, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x2b35, 0x0000, 0x0000, 0x2b38, 0x2b39, 0x0000, 0x2b3a,
 0x0000, 0x2b3d, 0x0000, 0x2b4d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2b4e,
 0x0000, 0x0000, 0x0000, 0x2b50, 0x0000, 0x0000, 0x0000, 0x2b56, 0x0000, 0x0000,
 0x0000, 0x2b57, 0x2b58, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2b59,
 0x2b5a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2b5b, 0x0000, 0x0000,
 0x2b5e, 0x2b64, 0x0000, 0x0000, 0x0000, 0x2b65, 0x0000, 0x2b6a, 0x2b6f, 0x0000,
 0x2b7b, 0x0000, 0x0000, 0x0000, 0x2b86, 0x0000, 0x0000, 0x2b87, 0x0000, 0x2b8a,
 0x0000, 0x2b8b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2b8c, 0x0000, 0x2b8d,
 0x2b90, 0x2b91, 0x2b92, 0x0000, 0x2b94, 0x0000, 0x2b95, 0x0000, 0x0000, 0x0000,
 0x2b96, 0x0000, 0x0000, 0x2b97, 0x2b98, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2b9b, 0x0000, 0x0000,
 0x2b9c, 0x2b9e, 0x0000, 0x0000, 0x0000, 0x2ba4, 0x2ba6, 0x0000, 0x0000, 0x0000,
 0x2ba8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2bae, 0x2baf, 0x0000, 0x0000,
 0x0000, 0x2bb0, 0x2bb3, 0x0000, 0x0000, 0x2bb4, 0x2bb5, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x2bba, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x2bc0, 0x2bc2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2bc3,
 0x0000, 0x2bc4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2bc5, 0x0000, 0x0000,
 0x0000, 0x2bc6, 0x0000, 0x2bc7, 0x0000, 0x0000, 0x2bc9, 0x0000, 0x2bcb, 0x0000,
 0x2bce, 0x0000, 0x0000, 0x2bdf, 0x0000, 0x0000, 0x0000, 0x2c1d, 0x2c1f, 0x0000,
 0x0000, 0x2c20, 0x2c21, 0x2c26, 0x0000, 0x0000, 0x0000, 0x2c2b, 0x0000, 0x0000,
 0x0000, 0x0000, 0x2c2d, 0x2c2e, 0x0000, 0x2c2f, 0x0000, 0x0000, 0x0000, 0x2c31,
 0x0000, 0x2c32, 0x0000, 0x0000, 0x0000, 0x0000, 0x2c46, 0x0000, 0x2c4a, 0x0000,
 0x0000, 0x0000, 0x2c4b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2c4c, 0x0000,
 0x2c4d, 0x2c4e, 0x0000, 0x2c50, 0x0000, 0x2c51, 0x0000, 0x0000, 0x0000, 0x2c54,
 0x2c55, 0x0000, 0x0000, 0x2c56, 0x0000, 0x0000, 0x0000, 0x2c5b, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x2c5c, 0x0000, 0x2c5d, 0x2c6a, 0x0000, 0x0000,
 0x2c6b, 0x0000, 0x2c6e, 0x2c70, 0x0000, 0x0000, 0x0000, 0x2c71, 0x0000, 0x0000,
 0x2c72, 0x2c77, 0x0000, 0x2c7a, 0x2c87, 0x0000, 0x2c88, 0x2c8e, 0x0000, 0x0000,
 0x0000, 0x2c90, 0x0000, 0x0000, 0x2c91, 0x2c94, 0x0000, 0x0000, 0x0000, 0x0000,
 0x2c99, 0x0000, 0x0000, 0x0000, 0x2c9a, 0x0000, 0x2c9d, 0x0000, 0x2ca2, 0x2ca5,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2ca6, 0x0000, 0x2cad, 0x0000, 0x2cae,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2cb0, 0x2cbd, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x2cbe, 0x0000, 0x0000, 0x0000, 0x0000, 0x2cbf, 0x0000,
 0x0000, 0x2cc0, 0x2cc4, 0x2cc5, 0x2cc7, 0x0000, 0x2ccd, 0x0000, 0x2cd1, 0x0000,
 0x0000, 0x0000, 0x0000, 0x2cd2, 0x0000, 0x0000, 0x0000, 0x2cd3, 0x0000, 0x2cd4,
 0x2cd5, 0x2cd8, 0x0000, 0x0000, 0x0000, 0x0000, 0x2cd9, 0x0000, 0x0000, 0x2cdc,
 0x0000, 0x0000, 0x2cdf, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x2ce9, 0x0000, 0x0000, 0x2cee, 0x0000, 0x2cf5, 0x0000,
 0x0000, 0x2cf6, 0x2cf7, 0x2cf9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x2cfb, 0x0000, 0x0000, 0x0000, 0x0000, 0x2cfc,
 0x0000, 0x2d00, 0x2d01, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x2d09, 0x2d0a, 0x2d0b, 0x2d0e, 0x0000, 0x0000,
 0x2d17, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2d1b, 0x0000, 0x2d1c, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x2d20, 0x2d24, 0x0000, 0x2d25, 0x0000, 0x0000,
 0x2d27, 0x0000, 0x2d28, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2d29,
 0x0000, 0x0000, 0x2d2b, 0x2d2c, 0x0000, 0x2d2d, 0x0000, 0x0000, 0x0000, 0x0000,
 0x2d2f, 0x0000, 0x0000, 0x0000, 0x2d31, 0x0000, 0x2d36, 0x0000, 0x2d37, 0x0000,
 0x0000, 0x0000, 0x2d39, 0x0000, 0x2d3a, 0x0000, 0x0000, 0x0000, 0x2d3c, 0x2d3d,
 0x0000, 0x0000, 0x0000, 0x2d3e, 0x2d40, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x2d43, 0x0000, 0x2d44, 0x2d47, 0x0000, 0x2d4b, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2d4c, 0x0000, 0x2d4d, 0x0000,
 0x0000, 0x0000, 0x0000, 0x2d4e, 0x2d51, 0x0000, 0x0000, 0x0000, 0x2d52, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2d53, 0x2d54, 0x0000,
 0x2d56, 0x0000, 0x0000, 0x2d58, 0x0000, 0x0000, 0x0000, 0x0000, 0x2d5a, 0x0000,
 0x0000, 0x2d5b, 0x0000, 0x0000, 0x0000, 0x0000, 0x2d5d, 0x0000, 0x2d66, 0x0000,
 0x0000, 0x0000, 0x2d67, 0x0000, 0x0000, 0x0000, 0x0000, 0x2d69, 0x0000, 0x0000,
 0x2d6a, 0x2d6b, 0x2d6c, 0x2d6e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x2d77, 0x0000, 0x0000, 0x2d7e, 0x0000, 0x2d80, 0x2d81, 0x0000, 0x2d82, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2d83, 0x0000,
 0x0000, 0x2d84, 0x2d85, 0x2d88, 0x0000, 0x0000, 0x2d9d, 0x2d9f, 0x0000, 0x0000,
 0x0000, 0x0000, 0x2da0, 0x0000, 0x0000, 0x2da1, 0x0000, 0x2da5, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2da8, 0x0000, 0x0000, 0x0000,
 0x2dc4, 0x0000, 0x2dc7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2dc9, 0x0000,
 0x0000, 0x2dcc, 0x2ddf, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x2de1, 0x2de4, 0x2de6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2de7,
 0x0000, 0x0000, 0x0000, 0x2de8, 0x2dea, 0x0000, 0x2deb, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x2def, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x2df0, 0x0000, 0x0000, 0x0000, 0x2df1, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x2df6, 0x2df7, 0x0000, 0x2dfc, 0x2dfd, 0x0000, 0x2dfe, 0x0000,
 0x0000, 0x2dff, 0x0000, 0x2e01, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x2e02, 0x2e04, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x2e07, 0x0000, 0x2e08, 0x0000, 0x0000, 0x0000, 0x2e09, 0x0000,
 0x0000, 0x0000, 0x2e0a, 0x0000, 0x0000, 0x0000, 0x0000, 0x2e0c, 0x0000, 0x0000,
 0x2e0d, 0x2e0f, 0x2e10, 0x0000, 0x0000, 0x0000, 0x0000, 0x2e13, 0x2e3a, 0x2e3b,
 0x2e3c, 0x0000, 0x0000, 0x2e3d, 0x0000, 0x0000, 0x0000, 0x2e3e, 0x0000, 0x0000,
 0x2e46, 0x2e4b, 0x0000, 0x2e4c, 0x0000, 0x2e5d, 0x0000, 0x0000, 0x0000, 0x2e5f,
 0x0000, 0x0000, 0x0000, 0x2e60, 0x2e62, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x2e63, 0x0000, 0x2e64, 0x2e65, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2e6b, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x2e6c, 0x0000, 0x2e6d, 0x0000, 0x2e6e, 0x0000, 0x0000,
 0x2e6f, 0x0000, 0x2e76, 0x2e77, 0x2e79, 0x2e85, 0x2e86, 0x0000, 0x2e88, 0x2e8e,
 0x0000, 0x0000, 0x2e90, 0x0000, 0x2e92, 0x2e94, 0x2e97, 0x2e98, 0x0000, 0x0000,
 0x0000, 0x0000, 0x2e99, 0x0000, 0x2e9e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x2ea5, 0x2ea7, 0x2ea8, 0x0000, 0x2ea9, 0x0000, 0x0000, 0x0000, 0x0000, 0x2eac,
 0x2ead, 0x0000, 0x0000, 0x0000, 0x0000, 0x2eb1, 0x0000, 0x2eb2, 0x0000, 0x2eb3,
 0x0000, 0x2eb4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2eb5, 0x0000, 0x0000,
 0x2eb7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2eb9,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2eca, 0x0000, 0x0000, 0x0000, 0x2ecb,
 0x2ecc, 0x2ed2, 0x2ed3, 0x0000, 0x2ed8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x2ed9, 0x0000, 0x0000, 0x0000, 0x2eda, 0x0000, 0x2edf, 0x2ee4, 0x2ee5, 0x2ee6,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2eeb, 0x0000, 0x0000, 0x2eec, 0x2eee,
 0x0000, 0x0000, 0x2eef, 0x0000, 0x0000, 0x2ef3, 0x2efc, 0x0000, 0x0000, 0x2efd,
 0x0000, 0x0000, 0x2f00, 0x2f01, 0x0000, 0x0000, 0x0000, 0x0000, 0x2f02, 0x0000,
 0x2f09, 0x2f0b, 0x0000, 0x0000, 0x2f0c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x2f0e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x2f16, 0x2f17, 0x0000, 0x2f18, 0x0000, 0x0000, 0x0000, 0x2f1c, 0x2f20, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x2f21, 0x2f23, 0x2f24, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2f2a, 0x0000, 0x0000, 0x0000, 0x2f2b,
 0x2f2c, 0x0000, 0x0000, 0x0000, 0x2f2f, 0x0000, 0x2f31, 0x2f36, 0x2f37, 0x0000,
 0x0000, 0x2f38, 0x0000, 0x0000, 0x0000, 0x0000, 0x2f39, 0x0000, 0x2f3c, 0x0000,
 0x0000, 0x0000, 0x0000, 0x2f41, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x2f42, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2f46, 0x2f47, 0x2f48, 0x2f4f,
 0x0000, 0x0000, 0x2f52, 0x2f54, 0x0000, 0x0000, 0x0000, 0x2f56, 0x0000, 0x0000,
 0x0000, 0x2f57, 0x2f58, 0x2f60, 0x0000, 0x0000, 0x0000, 0x0000, 0x2f62, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2f63, 0x0000, 0x0000, 0x0000, 0x2f64,
 0x2f66, 0x0000, 0x0000, 0x0000, 0x0000, 0x2f69, 0x0000, 0x2f6b, 0x0000, 0x2f6d,
 0x0000, 0x0000, 0x2f6e, 0x0000, 0x0000, 0x0000, 0x2f70, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x2f71, 0x0000, 0x2f74, 0x0000, 0x2f79, 0x0000, 0x0000, 0x0000,
 0x0000, 0x2f7a, 0x2f8b, 0x2f8d, 0x0000, 0x0000, 0x0000, 0x2f8f, 0x0000, 0x0000,
 0x0000, 0x0000, 0x2f92, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x2f97, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2f98,
 0x0000, 0x0000, 0x0000, 0x2f9a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2f9b,
 0x2f9c, 0x0000, 0x0000, 0x2f9d, 0x0000, 0x2fa4, 0x0000, 0x2fa5, 0x0000, 0x0000,
 0x2fa6, 0x0000, 0x2fa9, 0x0000, 0x0000, 0x0000, 0x0000, 0x2fab, 0x0000, 0x2fb1,
 0x0000, 0x0000, 0x0000, 0x0000, 0x2fb2, 0x2fb3, 0x2fb4, 0x2fb5, 0x0000, 0x2fb9,
 0x2fba, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x2fbe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2fbf, 0x0000,
 0x0000, 0x2fc5, 0x0000, 0x0000, 0x0000, 0x0000, 0x2fc9, 0x0000, 0x0000, 0x0000,
 0x0000, 0x2fca, 0x0000, 0x0000, 0x2fcc, 0x2fd2, 0x0000, 0x0000, 0x0000, 0x2fd3,
 0x0000, 0x0000, 0x0000, 0x2fd4, 0x2fdd, 0x0000, 0x2fde, 0x2fe0, 0x0000, 0x2fe1,
 0x0000, 0x0000, 0x2ff3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2ff5, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x2ff6, 0x0000, 0x3001, 0x0000, 0x0000, 0x3002,
 0x0000, 0x3004, 0x3005, 0x0000, 0x0000, 0x3006, 0x0000, 0x3007, 0x0000, 0x0000,
 0x3008, 0x0000, 0x3009, 0x0000, 0x300a, 0x0000, 0x0000, 0x0000, 0x0000, 0x300d,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x3015, 0x0000, 0x3032, 0x3034, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3035, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x3036, 0x3037, 0x0000, 0x3038, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x3039, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x303a, 0x0000, 0x0000, 0x0000, 0x0000, 0x303c, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x303e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x303f, 0x0000, 0x3043, 0x3044,
 0x3045, 0x0000, 0x0000, 0x304f, 0x3052, 0x3053, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3054, 0x3058, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x305b, 0x0000, 0x305e, 0x0000, 0x305f, 0x0000, 0x0000, 0x3060, 0x0000,
 0x0000, 0x0000, 0x0000, 0x3069, 0x0000, 0x0000, 0x306a, 0x0000, 0x0000, 0x0000,
 0x0000, 0x306e, 0x3073, 0x0000, 0x0000, 0x3074, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x307a,
 0x0000, 0x0000, 0x0000, 0x307b, 0x0000, 0x0000, 0x0000, 0x307c, 0x0000, 0x0000,
 0x0000, 0x0000, 0x3084, 0x0000, 0x3085, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x3087, 0x0000, 0x3089, 0x308d, 0x0000, 0x0000, 0x0000, 0x308f, 0x3090, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3092, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3093, 0x3094, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3095, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x3096, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x309d, 0x0000, 0x0000, 0x0000, 0x30a2, 0x30a3, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x30a4, 0x30bb, 0x0000, 0x0000,
 0x30cd, 0x30ce, 0x0000, 0x0000, 0x0000, 0x30cf, 0x0000, 0x0000, 0x0000, 0x0000,
 0x30d0, 0x30d6, 0x30dd, 0x0000, 0x0000, 0x0000, 0x0000, 0x30de, 0x0000, 0x30e0,
 0x30e1, 0x0000, 0x0000, 0x0000, 0x0000, 0x30e2, 0x0000, 0x0000, 0x0000, 0x30e3,
 0x0000, 0x30e8, 0x0000, 0x0000, 0x0000, 0x30ec, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x30ef, 0x0000, 0x0000, 0x0000, 0x30f0, 0x0000, 0x0000, 0x0000,
 0x30f1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x30f2, 0x0000, 0x30f7, 0x0000,
 0x0000, 0x30f8, 0x0000, 0x30fa, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x30fc, 0x0000, 0x3104, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x3106, 0x0000, 0x0000, 0x0000, 0x3107, 0x3108,
 0x0000, 0x0000, 0x0000, 0x310a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x310b, 0x0000, 0x0000, 0x3112, 0x0000, 0x3115, 0x0000, 0x3116,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x3119, 0x0000, 0x0000, 0x0000, 0x311b, 0x311e, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3121, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x3122, 0x3123, 0x313b, 0x0000, 0x3140, 0x0000, 0x0000,
 0x3143, 0x0000, 0x3144, 0x0000, 0x3147, 0x0000, 0x3151, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3153, 0x3166, 0x0000, 0x3168, 0x0000, 0x0000, 0x3171, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x317e, 0x0000, 0x0000, 0x317f, 0x0000, 0x3181, 0x3185, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x3187, 0x0000, 0x3189, 0x0000, 0x318a, 0x3195, 0x0000, 0x3196, 0x0000, 0x3199,
 0x0000, 0x319d, 0x0000, 0x0000, 0x0000, 0x319f, 0x31a0, 0x0000, 0x0000, 0x0000,
 0x0000, 0x31a3, 0x31c1, 0x0000, 0x0000, 0x31c3, 0x0000, 0x0000, 0x31c4, 0x0000,
 0x0000, 0x31c6, 0x31c7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x31c9, 0x0000, 0x31ca, 0x31cb, 0x0000, 0x31cc, 0x0000, 0x0000,
 0x31d7, 0x31df, 0x0000, 0x0000, 0x0000, 0x0000, 0x31e5, 0x0000, 0x31e6, 0x31ea,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x31eb, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x31ec, 0x31f9, 0x0000, 0x3218, 0x0000, 0x3219, 0x0000,
 0x3224, 0x0000, 0x0000, 0x0000, 0x0000, 0x3227, 0x0000, 0x322a, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x322b, 0x322d, 0x0000, 0x322e, 0x0000, 0x0000, 0x0000, 0x0000, 0x322f, 0x0000,
 0x0000, 0x3232, 0x3234, 0x3235, 0x0000, 0x0000, 0x0000, 0x3236, 0x0000, 0x0000,
 0x0000, 0x3237, 0x0000, 0x3238, 0x0000, 0x323a, 0x0000, 0x0000, 0x323b, 0x0000,
 0x323e, 0x0000, 0x323f, 0x0000, 0x0000, 0x3242, 0x0000, 0x3245, 0x3248, 0x3249,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x324b,
 0x0000, 0x324d, 0x0000, 0x0000, 0x324e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x3254, 0x3255, 0x3258, 0x0000, 0x3259, 0x0000,
 0x0000, 0x0000, 0x0000, 0x325d, 0x0000, 0x0000, 0x0000, 0x325f, 0x3260, 0x3262,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3266, 0x0000, 0x326d,
 0x326e, 0x0000, 0x327e, 0x0000, 0x3280, 0x0000, 0x0000, 0x0000, 0x3281, 0x0000,
 0x3282, 0x0000, 0x0000, 0x0000, 0x0000, 0x3283, 0x0000, 0x3284, 0x3285, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3286, 0x0000, 0x328e, 0x0000, 0x0000,
 0x0000, 0x0000, 0x3290, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3292, 0x0000, 0x0000, 0x3294, 0x0000, 0x0000, 0x3295, 0x0000, 0x0000,
 0x0000, 0x0000, 0x3296, 0x0000, 0x0000, 0x0000, 0x0000, 0x3297, 0x0000, 0x3298,
 0x0000, 0x3299, 0x0000, 0x0000, 0x0000, 0x329a, 0x329e, 0x329f, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x32a0, 0x32a4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x32a6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x32aa,
 0x0000, 0x32ab, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x32ac, 0x0000,
 0x0000, 0x32b6, 0x0000, 0x0000, 0x0000, 0x32b8, 0x32b9, 0x0000, 0x32ba, 0x32c4,
 0x32c5, 0x32c9, 0x32ca, 0x0000, 0x0000, 0x0000, 0x0000, 0x32cc, 0x0000, 0x0000,
 0x32cd, 0x0000, 0x0000, 0x32cf, 0x32d1, 0x0000, 0x32d9, 0x0000, 0x0000, 0x0000,
 0x32dc, 0x0000, 0x32dd, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x32de, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x32e0, 0x32e3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x32e4,
 0x0000, 0x0000, 0x32e5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x32e8, 0x0000, 0x32ed, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x32f0,
 0x0000, 0x0000, 0x32f1, 0x0000, 0x0000, 0x0000, 0x32f3, 0x32f4, 0x32f6, 0x0000,
 0x0000, 0x0000, 0x0000, 0x32f7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x32f9, 0x32fe, 0x0000, 0x3300, 0x0000, 0x0000, 0x3304, 0x3305, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x330b, 0x0000, 0x0000, 0x330c, 0x0000, 0x330f,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3315, 0x3316, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x3317, 0x3318, 0x3319, 0x0000, 0x331a, 0x0000, 0x0000, 0x0000,
 0x331d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x331e, 0x0000,
 0x331f, 0x3320, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3326, 0x0000, 0x332b,
 0x0000, 0x332c, 0x0000, 0x0000, 0x0000, 0x332d, 0x0000, 0x3345, 0x3346, 0x3348,
 0x3349, 0x0000, 0x0000, 0x334a, 0x0000, 0x334b, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x334e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x335e, 0x0000, 0x3370, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3371, 0x0000, 0x0000, 0x3372,
 0x0000, 0x0000, 0x0000, 0x0000, 0x3376, 0x0000, 0x0000, 0x0000, 0x3378, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x3379, 0x0000, 0x337a, 0x337f, 0x3383, 0x0000,
 0x0000, 0x0000, 0x3385, 0x0000, 0x0000, 0x3386, 0x0000, 0x0000, 0x3387, 0x0000,
 0x0000, 0x3396, 0x0000, 0x0000, 0x0000, 0x3397, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x339c, 0x0000, 0x0000, 0x33a3,
 0x33b0, 0x0000, 0x0000, 0x0000, 0x33b9, 0x0000, 0x33c1, 0x33c5, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x33c7, 0x33cb, 0x0000, 0x33cc, 0x33cd, 0x0000, 0x33ce,
 0x0000, 0x33d8, 0x0000, 0x0000, 0x0000, 0x0000, 0x33dc, 0x0000, 0x0000, 0x0000,
 0x0000, 0x33dd, 0x33f3, 0x0000, 0x0000, 0x33f5, 0x33f6, 0x0000, 0x0000, 0x33f7,
 0x0000, 0x0000, 0x33f9, 0x0000, 0x33fe, 0x0000, 0x0000, 0x0000, 0x33ff, 0x0000,
 0x0000, 0x0000, 0x0000, 0x340d, 0x0000, 0x3410, 0x0000, 0x0000, 0x0000, 0x3411,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3412, 0x0000, 0x0000, 0x3413,
 0x0000, 0x3417, 0x0000, 0x0000, 0x341e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x341f, 0x0000, 0x342a, 0x0000, 0x3432, 0x0000, 0x3436, 0x3437, 0x3439, 0x0000,
 0x0000, 0x343b, 0x343c, 0x0000, 0x343d, 0x343e, 0x0000, 0x3440, 0x0000, 0x3444,
 0x3445, 0x344a, 0x0000, 0x344b, 0x344c, 0x0000, 0x344d, 0x344f, 0x3453, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x3459, 0x3461, 0x0000, 0x3462, 0x0000, 0x0000,
 0x0000, 0x0000, 0x346c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x346e, 0x0000,
 0x0000, 0x0000, 0x0000, 0x346f, 0x0000, 0x0000, 0x0000, 0x0000, 0x3471, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x3473, 0x0000, 0x0000, 0x0000, 0x3474, 0x0000,
 0x0000, 0x3476, 0x347e, 0x0000, 0x347f, 0x0000, 0x3485, 0x0000, 0x3488, 0x3489,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x348b, 0x0000, 0x3491, 0x0000,
 0x0000, 0x0000, 0x0000, 0x3492, 0x3493, 0x0000, 0x3494, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3498, 0x3499, 0x349a, 0x349e, 0x0000, 0x349f, 0x34a0, 0x34a2, 0x34a3,
 0x0000, 0x34a4, 0x0000, 0x0000, 0x34a6, 0x34a7, 0x0000, 0x34a9, 0x0000, 0x0000,
 0x0000, 0x0000, 0x34af, 0x0000, 0x34b2, 0x0000, 0x34b5, 0x0000, 0x0000, 0x34b6,
 0x0000, 0x0000, 0x34b7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x34b8, 0x34b9, 0x0000,
 0x34bc, 0x0000, 0x0000, 0x34cc, 0x34d2, 0x0000, 0x0000, 0x34d5, 0x34d8, 0x0000,
 0x0000, 0x0000, 0x34da, 0x34df, 0x0000, 0x34e1, 0x34e3, 0x0000, 0x34e4, 0x0000,
 0x34e7, 0x0000, 0x34e8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x34e9,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x34eb, 0x0000, 0x0000, 0x0000,
 0x34ed, 0x34f3, 0x0000, 0x0000, 0x0000, 0x34f4, 0x34f5, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x34f6, 0x0000, 0x34fb, 0x0000, 0x0000, 0x0000,
 0x0000, 0x34fc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x34fe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3501, 0x0000, 0x0000,
 0x3503, 0x0000, 0x0000, 0x0000, 0x0000, 0x3505, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x350a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x350d, 0x0000, 0x3512, 0x0000, 0x351b, 0x0000, 0x3520,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3521, 0x3523,
 0x0000, 0x3524, 0x3525, 0x3526, 0x3527, 0x0000, 0x0000, 0x3531, 0x3532, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3537, 0x0000, 0x3539, 0x353b,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x353d, 0x0000,
 0x0000, 0x0000, 0x3542, 0x0000, 0x0000, 0x0000, 0x3546, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3556, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3558, 0x0000, 0x355b, 0x0000,
 0x0000, 0x355c, 0x0000, 0x0000, 0x355e, 0x0000, 0x0000, 0x0000, 0x355f, 0x0000,
 0x3560, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3564, 0x0000, 0x3565, 0x3567,
 0x0000, 0x0000, 0x3568, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x356b,
 0x3575, 0x0000, 0x3576, 0x0000, 0x0000, 0x0000, 0x3577, 0x0000, 0x0000, 0x0000,
 0x357c, 0x357e, 0x3581, 0x0000, 0x0000, 0x0000, 0x3586, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x3589, 0x0000, 0x0000, 0x0000, 0x0000, 0x358b, 0x0000, 0x0000,
 0x0000, 0x3592, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3593, 0x0000, 0x3594, 0x3595, 0x0000, 0x0000, 0x3597, 0x359c, 0x35a2,
 0x35a3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x35a4,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x35a6, 0x0000, 0x35a8,
 0x0000, 0x0000, 0x35a9, 0x35aa, 0x35b3, 0x0000, 0x35b7, 0x0000, 0x0000, 0x35b8,
 0x0000, 0x0000, 0x0000, 0x35b9, 0x0000, 0x35bd, 0x0000, 0x0000, 0x35c2, 0x35c3,
 0x0000, 0x35c4, 0x35c5, 0x0000, 0x35c6, 0x0000, 0x0000, 0x35c7, 0x0000, 0x0000,
 0x0000, 0x35c8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x35c9,
 0x0000, 0x0000, 0x35cc, 0x0000, 0x35cf, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x35d0, 0x35d2, 0x35db, 0x0000, 0x0000, 0x0000, 0x35e5,
 0x0000, 0x35e6, 0x0000, 0x35e9, 0x0000, 0x35ec, 0x35ee, 0x0000, 0x0000, 0x0000,
 0x0000, 0x35f8, 0x35f9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x360a, 0x0000, 0x360c, 0x0000,
 0x0000, 0x360e, 0x0000, 0x0000, 0x360f, 0x0000, 0x3610, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3612, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3613, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3615, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x3622, 0x0000, 0x0000, 0x3624, 0x0000, 0x0000,
 0x3625, 0x0000, 0x0000, 0x3626, 0x3627, 0x0000, 0x362c, 0x0000, 0x362d, 0x362e,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x3630, 0x0000, 0x0000, 0x0000, 0x0000, 0x3631, 0x3636, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x363e, 0x0000, 0x3640,
 0x3641, 0x3642, 0x0000, 0x0000, 0x3643, 0x3646, 0x0000, 0x3649, 0x364b, 0x364c,
 0x3650, 0x0000, 0x0000, 0x3652, 0x0000, 0x0000, 0x0000, 0x3655, 0x0000, 0x0000,
 0x0000, 0x3656, 0x0000, 0x0000, 0x0000, 0x3657, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3658, 0x365d, 0x0000, 0x0000, 0x0000, 0x0000, 0x365e, 0x0000, 0x365f,
 0x0000, 0x0000, 0x3660, 0x0000, 0x0000, 0x0000, 0x3661, 0x0000, 0x0000, 0x3662,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3664, 0x0000, 0x3667,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x366c, 0x0000, 0x366d, 0x0000, 0x366e,
 0x0000, 0x0000, 0x366f, 0x0000, 0x3678, 0x0000, 0x0000, 0x0000, 0x3682, 0x0000,
 0x0000, 0x3683, 0x0000, 0x0000, 0x0000, 0x0000, 0x3684, 0x0000, 0x3685, 0x0000,
 0x368f, 0x3691, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x3692, 0x36a6, 0x0000, 0x36a7, 0x36aa, 0x0000,
 0x36ab, 0x0000, 0x0000, 0x0000, 0x0000, 0x36ac, 0x0000, 0x0000, 0x36af, 0x0000,
 0x0000, 0x0000, 0x36c2, 0x0000, 0x36c3, 0x0000, 0x36c5, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x36d9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x36db, 0x0000, 0x0000, 0x0000, 0x0000, 0x36de, 0x0000, 0x0000,
 0x0000, 0x36e0, 0x36e1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x36e3, 0x0000, 0x0000, 0x36e4, 0x36e8, 0x0000, 0x36ef,
 0x0000, 0x36f0, 0x36f2, 0x0000, 0x0000, 0x36f3, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x36f4, 0x0000, 0x0000, 0x0000, 0x36f8,
 0x0000, 0x36fa, 0x36fb, 0x0000, 0x36fc, 0x36ff, 0x3705, 0x3706, 0x3707, 0x370d,
 0x0000, 0x0000, 0x0000, 0x0000, 0x370f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3710, 0x3711, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x3712, 0x0000, 0x3716, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3717, 0x0000,
 0x0000, 0x0000, 0x3718, 0x0000, 0x0000, 0x3719, 0x0000, 0x0000, 0x0000, 0x371b,
 0x371c, 0x0000, 0x0000, 0x371d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x3725, 0x0000, 0x0000, 0x0000, 0x0000, 0x3726, 0x0000, 0x0000,
 0x0000, 0x0000, 0x3727, 0x0000, 0x0000, 0x3728, 0x0000, 0x0000, 0x3729, 0x0000,
 0x372a, 0x372f, 0x0000, 0x3730, 0x3738, 0x0000, 0x0000, 0x373a, 0x0000, 0x373c,
 0x0000, 0x0000, 0x0000, 0x373d, 0x373e, 0x0000, 0x0000, 0x0000, 0x0000, 0x3742,
 0x0000, 0x0000, 0x3745, 0x0000, 0x3747, 0x0000, 0x0000, 0x0000, 0x3748, 0x0000,
 0x0000, 0x3749, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x374a, 0x0000, 0x374c, 0x374d, 0x0000, 0x0000, 0x374f, 0x0000, 0x3751,
 0x0000, 0x0000, 0x0000, 0x0000, 0x3752, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3753, 0x0000, 0x0000, 0x375d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x375e, 0x0000, 0x0000, 0x3760, 0x0000, 0x0000, 0x3762, 0x0000, 0x0000,
 0x3763, 0x3765, 0x0000, 0x0000, 0x3766, 0x3769, 0x376b, 0x0000, 0x376e, 0x0000,
 0x0000, 0x3775, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x3776, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3777, 0x3778, 0x0000, 0x0000, 0x0000, 0x377c, 0x0000, 0x0000, 0x3780,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3797, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x379a, 0x0000, 0x0000, 0x379b, 0x0000, 0x0000, 0x0000, 0x37a0, 0x37a1,
 0x0000, 0x0000, 0x0000, 0x37a6, 0x0000, 0x0000, 0x0000, 0x37a7, 0x0000, 0x37aa,
 0x0000, 0x0000, 0x37ab, 0x0000, 0x0000, 0x37ae, 0x0000, 0x0000, 0x37b0, 0x0000,
 0x0000, 0x0000, 0x37b4, 0x0000, 0x37b5, 0x0000, 0x0000, 0x0000, 0x0000, 0x37b6,
 0x37bb, 0x37bd, 0x0000, 0x0000, 0x37c5, 0x0000, 0x0000, 0x37c6, 0x0000, 0x37c7,
 0x37ca, 0x0000, 0x0000, 0x0000, 0x37cb, 0x0000, 0x0000, 0x0000, 0x37cc, 0x37cd,
 0x0000, 0x0000, 0x0000, 0x0000, 0x37ce, 0x0000, 0x0000, 0x0000, 0x37d0, 0x0000,
 0x0000, 0x0000, 0x37d1, 0x0000, 0x37d2, 0x0000, 0x37d5, 0x37dd, 0x37de, 0x37e0,
 0x37e1, 0x0000, 0x37e3, 0x0000, 0x37e4, 0x37e5, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x37e7, 0x37e8, 0x0000,
 0x0000, 0x37ed, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x37ee,
 0x0000, 0x0000, 0x0000, 0x0000, 0x37f0, 0x0000, 0x0000, 0x0000, 0x0000, 0x37f1,
 0x37f2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x37f6, 0x37f9, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x37fa, 0x37fb, 0x0000, 0x0000, 0x0000, 0x0000, 0x37fc, 0x0000,
 0x0000, 0x0000, 0x37fd, 0x0000, 0x0000, 0x3801, 0x3804, 0x0000, 0x3805, 0x0000,
 0x0000, 0x3806, 0x0000, 0x3809, 0x380a, 0x0000, 0x0000, 0x380b, 0x0000, 0x381a,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x381c, 0x381d, 0x3823, 0x0000, 0x3825,
 0x0000, 0x0000, 0x3826, 0x0000, 0x382b, 0x0000, 0x3840, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x3841, 0x0000, 0x0000, 0x3845, 0x0000, 0x3846, 0x0000, 0x3848,
 0x3849, 0x0000, 0x0000, 0x0000, 0x3851, 0x0000, 0x0000, 0x3858, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x385e, 0x0000, 0x0000,
 0x0000, 0x385f, 0x0000, 0x0000, 0x3863, 0x0000, 0x3868, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x386a, 0x0000, 0x0000, 0x386b, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x386e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x3876, 0x0000, 0x3879, 0x0000, 0x387c, 0x0000, 0x0000, 0x3882, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x3883, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x3885, 0x0000, 0x388d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x388e,
 0x3892, 0x0000, 0x0000, 0x0000, 0x3893, 0x0000, 0x0000, 0x0000, 0x3895, 0x3896,
 0x0000, 0x0000, 0x0000, 0x3897, 0x3898, 0x3899, 0x389c, 0x389d, 0x389e, 0x389f,
 0x38a0, 0x38a1, 0x0000, 0x38a3, 0x0000, 0x38a5, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x38a6, 0x0000, 0x38ab, 0x38b0,
 0x38b1, 0x38b2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x38b3, 0x38be, 0x38c2, 0x0000, 0x38c9, 0x0000, 0x38d0,
 0x0000, 0x38d3, 0x0000, 0x0000, 0x38d4, 0x38d6, 0x38d7, 0x0000, 0x0000, 0x38d8,
 0x0000, 0x0000, 0x0000, 0x38d9, 0x0000, 0x38da, 0x0000, 0x0000, 0x0000, 0x0000,
 0x38dc, 0x38e4, 0x0000, 0x0000, 0x38e5, 0x38e6, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x38e8, 0x0000, 0x0000, 0x38e9, 0x0000, 0x0000, 0x0000, 0x38eb,
 0x38f0, 0x0000, 0x0000, 0x38f1, 0x38f2, 0x38f3, 0x0000, 0x0000, 0x38f4, 0x0000,
 0x0000, 0x0000, 0x0000, 0x38f6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x38f7, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x38fb, 0x0000, 0x38fc, 0x0000, 0x0000, 0x3908, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3909, 0x0000,
 0x0000, 0x390c, 0x390d, 0x3913, 0x0000, 0x3915, 0x0000, 0x0000, 0x0000, 0x0000,
 0x3917, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3923, 0x0000, 0x3924,
 0x0000, 0x0000, 0x0000, 0x0000, 0x3927, 0x0000, 0x3929, 0x392a, 0x0000, 0x0000,
 0x0000, 0x0000, 0x392b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x392c, 0x0000, 0x0000, 0x392f, 0x3932, 0x0000, 0x0000, 0x0000, 0x0000,
 0x3934, 0x0000, 0x0000, 0x0000, 0x0000, 0x3935, 0x3936, 0x0000, 0x393d, 0x0000,
 0x0000, 0x393e, 0x0000, 0x3942, 0x0000, 0x3945, 0x0000, 0x0000, 0x0000, 0x3949,
 0x0000, 0x0000, 0x0000, 0x394c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x394d, 0x0000, 0x0000, 0x394e, 0x0000, 0x0000, 0x0000,
 0x3958, 0x0000, 0x0000, 0x3959, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x395a,
 0x395b, 0x0000, 0x0000, 0x0000, 0x0000, 0x395e, 0x0000, 0x0000, 0x0000, 0x0000,
 0x395f, 0x3969, 0x0000, 0x0000, 0x0000, 0x0000, 0x396b, 0x3971, 0x3977, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3978,
 0x0000, 0x0000, 0x0000, 0x3979, 0x0000, 0x0000, 0x0000, 0x0000, 0x397f, 0x0000,
 0x3980, 0x3981, 0x3986, 0x0000, 0x0000, 0x0000, 0x3988, 0x3989, 0x0000, 0x0000,
 0x0000, 0x0000, 0x398b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x398d, 0x3990, 0x3991, 0x0000, 0x0000, 0x3994, 0x3996, 0x0000, 0x0000, 0x0000,
 0x3998, 0x39a1, 0x0000, 0x0000, 0x0000, 0x0000, 0x39a3, 0x39a6, 0x39a8, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x39a9, 0x39aa, 0x39ad, 0x39b3, 0x0000, 0x39b4,
 0x0000, 0x39b5, 0x39b6, 0x0000, 0x0000, 0x39b7, 0x0000, 0x0000, 0x39b8, 0x0000,
 0x0000, 0x0000, 0x0000, 0x39b9, 0x0000, 0x39bb, 0x0000, 0x0000, 0x39be, 0x0000,
 0x0000, 0x39c1, 0x39c2, 0x39c4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x39cb,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x39ce, 0x0000, 0x39d3, 0x39d4,
 0x39d6, 0x0000, 0x0000, 0x0000, 0x39d9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x39da, 0x0000, 0x0000, 0x0000, 0x0000, 0x39db, 0x0000, 0x39dc, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x39df, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x39e0, 0x0000, 0x39e2, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x39e3, 0x0000, 0x39e4, 0x0000, 0x39e7, 0x0000, 0x0000, 0x0000,
 0x39e8, 0x0000, 0x0000, 0x39ea, 0x39eb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x39ee, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x39f1, 0x0000, 0x39fd, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x39fe, 0x0000, 0x0000, 0x39ff, 0x3a17, 0x0000, 0x3a19, 0x0000, 0x3a1c,
 0x0000, 0x3a1d, 0x3a1e, 0x3a20, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3a21,
 0x0000, 0x3a22, 0x3a2e, 0x0000, 0x0000, 0x0000, 0x0000, 0x3a2f, 0x0000, 0x3a3b,
 0x0000, 0x3a3c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3a3f,
 0x0000, 0x0000, 0x0000, 0x0000, 0x3a48, 0x0000, 0x0000, 0x3a53, 0x0000, 0x3a54,
 0x3a56, 0x3a57, 0x0000, 0x0000, 0x3a58, 0x0000, 0x3a61, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x3a63, 0x0000, 0x0000, 0x3a64, 0x3a65, 0x3a67,
 0x0000, 0x0000, 0x3a68, 0x0000, 0x0000, 0x0000, 0x3a74, 0x3a7d, 0x0000, 0x0000,
 0x3a8e, 0x0000, 0x0000, 0x0000, 0x0000, 0x3a93, 0x0000, 0x0000, 0x3a96, 0x3a99,
 0x0000, 0x0000, 0x3a9a, 0x3aac, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x3aad, 0x0000, 0x3aae, 0x0000, 0x0000, 0x0000, 0x0000, 0x3aaf, 0x0000, 0x0000,
 0x3ab1, 0x3ab5, 0x3ab9, 0x0000, 0x0000, 0x0000, 0x3aba, 0x0000, 0x0000, 0x0000,
 0x3abb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3ac3, 0x3ac4, 0x0000, 0x0000,
 0x0000, 0x3ac5, 0x3ac6, 0x3ac8, 0x3aca, 0x0000, 0x3ad9, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3ada, 0x0000, 0x0000, 0x3ae3, 0x3aea, 0x3aec, 0x0000, 0x0000, 0x3aed,
 0x3aee, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3af0,
 0x0000, 0x0000, 0x0000, 0x3af1, 0x0000, 0x0000, 0x0000, 0x0000, 0x3af6, 0x0000,
 0x3af8, 0x0000, 0x3af9, 0x0000, 0x3afc, 0x0000, 0x0000, 0x3afe, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3b01, 0x0000, 0x0000, 0x3b02,
 0x0000, 0x3b05, 0x3b09, 0x0000, 0x0000, 0x0000, 0x3b0b, 0x0000, 0x3b0e, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3b0f, 0x0000, 0x0000, 0x3b10, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x3b13, 0x3b19, 0x0000, 0x0000, 0x0000, 0x3b1a,
 0x0000, 0x3b1b, 0x0000, 0x0000, 0x3b1e, 0x0000, 0x3b1f, 0x0000, 0x0000, 0x0000,
 0x3b21, 0x3b22, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3b23, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x3b24, 0x0000, 0x0000, 0x3b32, 0x3b3a, 0x0000,
 0x3b41, 0x3b42, 0x0000, 0x3b47, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3b49,
 0x0000, 0x3b4a, 0x3b4b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3b4f, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3b51, 0x3b53, 0x0000, 0x3b5a, 0x3b5b, 0x3b5c, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x3b64, 0x0000, 0x0000, 0x0000, 0x0000, 0x3b66,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3b67, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3b6d, 0x0000, 0x3b6e, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3b80, 0x0000, 0x0000, 0x0000, 0x0000,
 0x3b82, 0x0000, 0x3b86, 0x3b88, 0x0000, 0x3b90, 0x0000, 0x0000, 0x0000, 0x0000,
 0x3b92, 0x3b93, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3b94,
 0x0000, 0x0000, 0x0000, 0x3b97, 0x3b9e, 0x3ba2, 0x0000, 0x0000, 0x0000, 0x3ba3,
 0x0000, 0x0000, 0x0000, 0x3bad, 0x3baf, 0x0000, 0x0000, 0x0000, 0x3bb0, 0x3bb1,
 0x3bb2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3bb5, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3bb9, 0x0000, 0x0000, 0x3bbb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x3bc0, 0x3bc1, 0x0000, 0x0000, 0x3bc8, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3bca, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3bcb, 0x3bcc,
 0x0000, 0x3bcd, 0x0000, 0x0000, 0x3bcf, 0x0000, 0x0000, 0x3bd0, 0x3bd1, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3bd2, 0x3bd5, 0x0000, 0x0000, 0x0000, 0x3bd6, 0x3bd7, 0x0000, 0x0000,
 0x0000, 0x0000, 0x3bd8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3bd9,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3bdc, 0x0000, 0x3bdd, 0x3bde, 0x0000,
 0x3be2, 0x0000, 0x0000, 0x0000, 0x0000, 0x3be6, 0x0000, 0x3be7, 0x0000, 0x3bed,
 0x0000, 0x0000, 0x3bee, 0x0000, 0x0000, 0x3bef, 0x3bf0, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3bf1, 0x0000, 0x0000, 0x0000, 0x0000, 0x3bf3, 0x0000, 0x0000, 0x3bf4,
 0x3bf5, 0x3bf6, 0x0000, 0x3bfc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x3bfd, 0x0000, 0x3bfe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x3bff, 0x3c00, 0x3c04, 0x0000, 0x3c14, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x3c20, 0x0000, 0x0000, 0x3c21, 0x0000, 0x3c23, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x3c24, 0x0000, 0x0000, 0x3c25, 0x3c26, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3c27, 0x0000,
 0x3c28, 0x0000, 0x0000, 0x0000, 0x3c2a, 0x0000, 0x3c2d, 0x3c32, 0x0000, 0x0000,
 0x0000, 0x0000, 0x3c33, 0x0000, 0x0000, 0x0000, 0x3c34, 0x0000, 0x3c38, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3c44, 0x0000, 0x3c4b, 0x0000,
 0x0000, 0x3c4e, 0x0000, 0x0000, 0x0000, 0x0000, 0x3c4f, 0x0000, 0x0000, 0x0000,
 0x3c50, 0x0000, 0x0000, 0x0000, 0x3c51, 0x3c59, 0x3c5b, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x3c5c, 0x0000, 0x0000, 0x3c5f, 0x0000, 0x0000,
 0x0000, 0x3c60, 0x0000, 0x0000, 0x3c62, 0x0000, 0x3c64, 0x3c65, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x3c66, 0x3c68, 0x0000, 0x3c69, 0x0000, 0x0000, 0x3c6a,
 0x0000, 0x0000, 0x3c6b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3c6c, 0x0000,
 0x0000, 0x0000, 0x0000, 0x3c79, 0x0000, 0x0000, 0x3c7c, 0x0000, 0x3c7d, 0x3c7e,
 0x0000, 0x0000, 0x0000, 0x3c7f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3c80,
 0x0000, 0x3c84, 0x3c8a, 0x0000, 0x0000, 0x0000, 0x3c8b, 0x0000, 0x0000, 0x0000,
 0x3c8c, 0x0000, 0x3c8d, 0x0000, 0x0000, 0x3c98, 0x0000, 0x3ca2, 0x0000, 0x0000,
 0x0000, 0x3ca4, 0x0000, 0x3ca5, 0x3ca6, 0x0000, 0x0000, 0x3ca7, 0x0000, 0x0000,
 0x3cb9, 0x3cba, 0x0000, 0x3cbc, 0x3cc0, 0x0000, 0x3cc1, 0x0000, 0x0000, 0x0000,
 0x3cc2, 0x0000, 0x3cc3, 0x0000, 0x3cc5, 0x3ccd, 0x3cd5, 0x3cd9, 0x3cda, 0x0000,
 0x3cde, 0x0000, 0x3cdf, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3ce2, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3ce4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3ce5, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3ce9, 0x3cea, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3ceb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3cec, 0x0000,
 0x0000, 0x0000, 0x3ced, 0x0000, 0x0000, 0x0000, 0x0000, 0x3cf0, 0x0000, 0x0000,
 0x3cf1, 0x0000, 0x0000, 0x0000, 0x0000, 0x3cf2, 0x3cf3, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x3cf4, 0x0000, 0x3cf9, 0x0000, 0x0000, 0x3cfc, 0x0000,
 0x0000, 0x3cfd, 0x0000, 0x0000, 0x3cff, 0x3d01, 0x3d02, 0x0000, 0x0000, 0x3d04,
 0x0000, 0x3d14, 0x3d15, 0x0000, 0x0000, 0x3d21, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x3d22, 0x0000, 0x0000, 0x3d23, 0x0000, 0x0000, 0x0000,
 0x3d28, 0x0000, 0x3d2a, 0x0000, 0x0000, 0x0000, 0x3d30, 0x0000, 0x0000, 0x3d31,
 0x0000, 0x0000, 0x3d34, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3d35, 0x0000,
 0x0000, 0x3d3a, 0x0000, 0x0000, 0x3d3b, 0x0000, 0x0000, 0x0000, 0x0000, 0x3d3c,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3d3d, 0x0000, 0x0000, 0x0000, 0x0000, 0x3d3e, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x3d3f, 0x0000, 0x0000, 0x3d41, 0x0000, 0x3d46, 0x0000, 0x0000,
 0x0000, 0x0000, 0x3d47, 0x0000, 0x3d48, 0x0000, 0x0000, 0x3d4a, 0x0000, 0x0000,
 0x0000, 0x3d51, 0x0000, 0x3d53, 0x3d54, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x3d55, 0x0000, 0x3d56, 0x3d57, 0x0000, 0x3d58,
 0x0000, 0x3d59, 0x0000, 0x3d5b, 0x0000, 0x3d5d, 0x0000, 0x3d60, 0x3d64, 0x0000,
 0x3d65, 0x0000, 0x3d66, 0x3d68, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3d6c,
 0x0000, 0x0000, 0x0000, 0x3d6d, 0x0000, 0x3d6e, 0x0000, 0x0000, 0x0000, 0x3d7c,
 0x0000, 0x3d81, 0x3d82, 0x0000, 0x0000, 0x3d83, 0x0000, 0x3d84, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x3d85, 0x0000, 0x0000, 0x0000, 0x3d88, 0x0000, 0x3d89,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3d8f, 0x0000, 0x0000, 0x0000,
 0x3d95, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x3d97, 0x0000, 0x0000, 0x0000, 0x3d9b, 0x0000, 0x0000, 0x3da8, 0x0000, 0x0000,
 0x0000, 0x0000, 0x3da9, 0x3dae, 0x3daf, 0x0000, 0x0000, 0x3db0, 0x0000, 0x0000,
 0x0000, 0x3dbf, 0x0000, 0x3dc3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3dca, 0x0000, 0x0000, 0x0000,
 0x3dcb, 0x0000, 0x0000, 0x0000, 0x0000, 0x3dcd, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3dce, 0x3dd0, 0x0000, 0x0000, 0x3dd3, 0x0000, 0x0000, 0x3dd5, 0x3dd7,
 0x0000, 0x3dd8, 0x0000, 0x0000, 0x3dd9, 0x0000, 0x3ddb, 0x3dde, 0x3ddf, 0x3de3,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3de4, 0x0000, 0x0000, 0x0000, 0x0000, 0x3de5, 0x3deb, 0x3df0, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3df2, 0x3df4, 0x0000, 0x3df5,
 0x0000, 0x0000, 0x0000, 0x3df8, 0x0000, 0x0000, 0x0000, 0x0000, 0x3df9, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3dfa, 0x0000, 0x3e00, 0x0000, 0x0000,
 0x3e04, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e05, 0x3e06, 0x3e0b, 0x3e0d, 0x0000,
 0x0000, 0x3e10, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e11, 0x3e12, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e14, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e15, 0x0000, 0x0000, 0x3e16, 0x0000,
 0x0000, 0x0000, 0x3e17, 0x0000, 0x3e18, 0x3e19, 0x0000, 0x3e1a, 0x3e1d, 0x3e1e,
 0x0000, 0x3e27, 0x3e2b, 0x0000, 0x3e2c, 0x0000, 0x3e34, 0x3e3f, 0x0000, 0x3e41,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e4e, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x3e56, 0x0000, 0x0000, 0x0000, 0x3e59, 0x0000, 0x0000,
 0x3e5e, 0x0000, 0x3e5f, 0x0000, 0x0000, 0x3e69, 0x0000, 0x0000, 0x3e6a, 0x0000,
 0x0000, 0x3e6d, 0x3e6e, 0x3e6f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3e72, 0x0000, 0x0000, 0x0000, 0x3e76, 0x0000, 0x3e77, 0x3e7b, 0x3e7e,
 0x0000, 0x3e7f, 0x0000, 0x3e80, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e88, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e89, 0x3e8b,
 0x0000, 0x3e8d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x3e8e, 0x0000, 0x0000, 0x3e8f, 0x3e97, 0x3e98, 0x3e99, 0x0000, 0x0000, 0x3e9a,
 0x0000, 0x3e9e, 0x0000, 0x3ea0, 0x0000, 0x3ea1, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x3ea3, 0x3ea4, 0x3ea5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x3ea7, 0x0000, 0x0000, 0x0000, 0x0000, 0x3ea9, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x3eab, 0x3eac, 0x0000, 0x0000, 0x3eaf, 0x0000, 0x0000, 0x0000, 0x3eb0,
 0x0000, 0x0000, 0x3eb1, 0x3eb2, 0x3eb4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x3eb7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3eb8,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3eba, 0x3ebc, 0x3ebd,
 0x0000, 0x0000, 0x3ebf, 0x0000, 0x0000, 0x3ec0, 0x0000, 0x0000, 0x0000, 0x3ec3,
 0x3ec4, 0x0000, 0x0000, 0x3ec5, 0x3ece, 0x0000, 0x0000, 0x0000, 0x3ecf, 0x0000,
 0x0000, 0x0000, 0x3ed0, 0x0000, 0x3ed1, 0x0000, 0x0000, 0x0000, 0x3ed8, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x3ed9, 0x3edd, 0x0000, 0x3ee1, 0x0000, 0x3ee7, 0x0000, 0x3ee8, 0x3ee9, 0x0000,
 0x0000, 0x3f80, 0x0000, 0x0000, 0x3f83, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x3f84, 0x3f85, 0x0000, 0x0000, 0x3f86, 0x0000, 0x0000, 0x3f87,
 0x0000, 0x3f8c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3f8d,
 0x0000, 0x0000, 0x3f8e, 0x3f91, 0x0000, 0x3f92, 0x0000, 0x0000, 0x0000, 0x0000,
 0x3f93, 0x3f94, 0x3f95, 0x3f98, 0x0000, 0x0000, 0x0000, 0x3f99, 0x3f9c, 0x0000,
 0x0000, 0x0000, 0x3f9e, 0x0000, 0x3fa1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x3fa2, 0x0000, 0x0000, 0x0000, 0x0000, 0x3fa3,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3fa4, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3fa5, 0x3fa7, 0x3fa9, 0x0000,
 0x3fae, 0x0000, 0x3fb0, 0x0000, 0x3fb1, 0x0000, 0x3fb2, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3fb3,
 0x3fb4, 0x3fb8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3fb9, 0x3fbb,
 0x0000, 0x3fbe, 0x0000, 0x0000, 0x0000, 0x3fc1, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x3fc6, 0x3fcd, 0x3fd0, 0x0000, 0x0000, 0x0000, 0x0000,
 0x3fd1, 0x3fd4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3fd9, 0x0000, 0x0000,
 0x3fda, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x3fdb, 0x0000, 0x0000, 0x3fdc, 0x0000, 0x0000, 0x0000, 0x0000, 0x3fdd, 0x0000,
 0x0000, 0x0000, 0x3fde, 0x0000, 0x3fe5, 0x0000, 0x0000, 0x0000, 0x0000, 0x3fe7,
 0x3fe8, 0x0000, 0x0000, 0x0000, 0x0000, 0x3fea, 0x3feb, 0x3fec, 0x3fed, 0x0000,
 0x0000, 0x3fee, 0x0000, 0x0000, 0x0000, 0x0000, 0x3fef, 0x3ff0, 0x0000, 0x3ff1,
 0x3ff6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3ff8, 0x0000,
 0x0000, 0x0000, 0x0000, 0x3ffa, 0x3ffb, 0x0000, 0x3ffc, 0x0000, 0x0000, 0x0000,
 0x3ffd, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4006, 0x0000, 0x0000,
 0x0000, 0x400f, 0x0000, 0x4012, 0x4014, 0x4016, 0x4017, 0x0000, 0x0000, 0x0000,
 0x4019, 0x401b, 0x0000, 0x0000, 0x0000, 0x0000, 0x401c, 0x0000, 0x401d, 0x401f,
 0x4027, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4028, 0x0000, 0x0000, 0x0000,
 0x402c, 0x4032, 0x4033, 0x4041, 0x0000, 0x4042, 0x4043, 0x0000, 0x0000, 0x0000,
 0x4045, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4046, 0x0000, 0x0000, 0x4048,
 0x404a, 0x0000, 0x0000, 0x404b, 0x0000, 0x0000, 0x404c, 0x0000, 0x0000, 0x0000,
 0x0000, 0x404e, 0x0000, 0x404f, 0x0000, 0x0000, 0x4052, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x405f, 0x0000, 0x0000, 0x4060, 0x0000, 0x4061, 0x4064, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4065,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4069, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x406b, 0x0000, 0x0000, 0x4072, 0x0000, 0x0000, 0x4077, 0x0000,
 0x4079, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x407a,
 0x0000, 0x0000, 0x0000, 0x407c, 0x407d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x407f, 0x4081, 0x0000, 0x0000, 0x0000, 0x4084, 0x0000,
 0x4085, 0x0000, 0x4087, 0x0000, 0x4091, 0x0000, 0x0000, 0x4093, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x4096, 0x0000, 0x0000, 0x409d, 0x409e, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x409f, 0x40a3,
 0x40a4, 0x0000, 0x0000, 0x0000, 0x40a7, 0x0000, 0x40a8, 0x0000, 0x0000, 0x0000,
 0x40a9, 0x0000, 0x0000, 0x40ae, 0x0000, 0x0000, 0x40b2, 0x40b5, 0x0000, 0x0000,
 0x0000, 0x40ba, 0x0000, 0x0000, 0x0000, 0x40bd, 0x40c9, 0x0000, 0x0000, 0x0000,
 0x40ca, 0x40cb, 0x40d3, 0x0000, 0x40d4, 0x0000, 0x40d6, 0x0000, 0x0000, 0x0000,
 0x40d8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x40d9, 0x0000, 0x0000, 0x0000, 0x0000, 0x40db,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x40dc, 0x40e4, 0x0000,
 0x0000, 0x0000, 0x0000, 0x40e5, 0x0000, 0x40ea, 0x0000, 0x0000, 0x0000, 0x4100,
 0x0000, 0x0000, 0x4101, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4105,
 0x0000, 0x0000, 0x0000, 0x0000, 0x4106, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x410b, 0x0000, 0x0000, 0x0000, 0x0000, 0x410d, 0x410e, 0x0000, 0x0000,
 0x0000, 0x410f, 0x0000, 0x0000, 0x4110, 0x411b, 0x0000, 0x0000, 0x0000, 0x0000,
 0x411f, 0x0000, 0x4120, 0x0000, 0x0000, 0x0000, 0x4121, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x4124, 0x0000, 0x412e, 0x0000, 0x0000, 0x0000, 0x0000, 0x4131,
 0x0000, 0x4132, 0x0000, 0x4134, 0x0000, 0x4135, 0x0000, 0x4136, 0x0000, 0x4138,
 0x0000, 0x0000, 0x0000, 0x4141, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x4143, 0x0000, 0x0000, 0x0000, 0x4145, 0x0000, 0x0000, 0x0000, 0x0000, 0x4147,
 0x0000, 0x4148, 0x4149, 0x0000, 0x0000, 0x0000, 0x414b, 0x0000, 0x0000, 0x0000,
 0x0000, 0x414c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x414e, 0x4154, 0x0000, 0x0000, 0x4156, 0x4157, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x4158, 0x0000, 0x4159, 0x0000, 0x0000, 0x415a,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x415b, 0x0000, 0x0000, 0x0000, 0x415c,
 0x0000, 0x0000, 0x0000, 0x0000, 0x415e, 0x4162, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x4167, 0x0000, 0x0000, 0x4169, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x416d, 0x0000, 0x4170, 0x0000, 0x0000, 0x0000, 0x0000,
 0x4174, 0x0000, 0x0000, 0x4176, 0x0000, 0x4177, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x4178, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x417a,
 0x0000, 0x4181, 0x0000, 0x4182, 0x0000, 0x4184, 0x0000, 0x0000, 0x0000, 0x4189,
 0x418c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x418d, 0x0000, 0x0000,
 0x418e, 0x0000, 0x4190, 0x0000, 0x0000, 0x4191, 0x4193, 0x4198, 0x0000, 0x0000,
 0x419a, 0x0000, 0x0000, 0x0000, 0x419e, 0x0000, 0x0000, 0x41a9, 0x0000, 0x0000,
 0x41ae, 0x41b0, 0x41b1, 0x0000, 0x41b3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x41b4, 0x0000, 0x0000, 0x41c4, 0x41c7,
 0x0000, 0x0000, 0x41c9, 0x41d3, 0x41d9, 0x0000, 0x0000, 0x41da, 0x41db, 0x0000,
 0x0000, 0x41dc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x41de, 0x0000, 0x41df, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x41e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x41ec, 0x0000,
 0x41f1, 0x41f2, 0x0000, 0x41f5, 0x41f6, 0x0000, 0x41f7, 0x0000, 0x0000, 0x0000,
 0x41f9, 0x41fb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x41fe, 0x41ff, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x4201, 0x0000, 0x4202, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4211, 0x0000,
 0x0000, 0x421c, 0x421d, 0x421e, 0x0000, 0x0000, 0x421f, 0x0000, 0x0000, 0x0000,
 0x4229, 0x422a, 0x0000, 0x0000, 0x0000, 0x422c, 0x422d, 0x0000, 0x0000, 0x0000,
 0x422e, 0x4231, 0x0000, 0x4232, 0x4235, 0x4236, 0x0000, 0x0000, 0x0000, 0x4238,
 0x423b, 0x0000, 0x0000, 0x0000, 0x4245, 0x0000, 0x4249, 0x0000, 0x0000, 0x424f,
 0x0000, 0x0000, 0x4250, 0x0000, 0x0000, 0x0000, 0x0000, 0x4252, 0x0000, 0x0000,
 0x4255, 0x0000, 0x4257, 0x425d, 0x0000, 0x0000, 0x0000, 0x0000, 0x425e, 0x0000,
 0x0000, 0x425f, 0x0000, 0x0000, 0x0000, 0x4261, 0x0000, 0x4262, 0x4264, 0x4268,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x426a, 0x426c, 0x0000, 0x426e, 0x0000,
 0x0000, 0x426f, 0x0000, 0x0000, 0x0000, 0x0000, 0x4270, 0x4275, 0x4276, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x427d, 0x0000,
 0x4287, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4289, 0x428c, 0x0000, 0x428e,
 0x0000, 0x0000, 0x428f, 0x0000, 0x4295, 0x0000, 0x0000, 0x4296, 0x4297, 0x0000,
 0x0000, 0x0000, 0x0000, 0x4298, 0x0000, 0x4299, 0x429a, 0x0000, 0x429b, 0x429d,
 0x0000, 0x429e, 0x0000, 0x429f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x42a7,
 0x0000, 0x0000, 0x42a8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x42a9, 0x0000, 0x0000, 0x42ac, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x42b0,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x42b1, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x42b2, 0x0000, 0x42b8, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x42b9,
 0x42bb, 0x42bc, 0x0000, 0x0000, 0x0000, 0x42bd, 0x0000, 0x0000, 0x0000, 0x0000,
 0x42c4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x42c5, 0x0000, 0x42c7, 0x42ce, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x42cf, 0x0000, 0x0000, 0x42d1, 0x0000, 0x42d3, 0x0000, 0x0000, 0x0000, 0x0000,
 0x42da, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x42db, 0x42e5, 0x42e7, 0x0000,
 0x0000, 0x42e8, 0x0000, 0x0000, 0x0000, 0x42e9, 0x42ea, 0x0000, 0x42eb, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x42ec, 0x42ef, 0x42f9, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x42fa, 0x0000, 0x42fb, 0x0000, 0x42fc,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x42fd, 0x42fe, 0x0000, 0x42ff,
 0x4301, 0x0000, 0x4303, 0x0000, 0x0000, 0x0000, 0x0000, 0x430b, 0x4313, 0x0000,
 0x4316, 0x0000, 0x0000, 0x0000, 0x0000, 0x431b, 0x0000, 0x0000, 0x431e, 0x4321,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4322, 0x0000, 0x0000, 0x4324, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4325, 0x4327, 0x0000, 0x432a,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x432b,
 0x432c, 0x4333, 0x4334, 0x0000, 0x0000, 0x4335, 0x4341, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x4342, 0x0000, 0x0000, 0x0000, 0x0000, 0x4343, 0x0000, 0x4344,
 0x0000, 0x4345, 0x0000, 0x0000, 0x434e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x4354, 0x0000, 0x4356, 0x4357, 0x0000, 0x0000, 0x0000, 0x4359, 0x435c, 0x0000,
 0x0000, 0x435d, 0x0000, 0x4360, 0x0000, 0x0000, 0x4363, 0x0000, 0x4364, 0x0000,
 0x0000, 0x4370, 0x0000, 0x4372, 0x0000, 0x0000, 0x0000, 0x4374, 0x0000, 0x0000,
 0x0000, 0x0000, 0x4377, 0x4378, 0x0000, 0x4379, 0x0000, 0x438f, 0x0000, 0x4396,
 0x0000, 0x4399, 0x0000, 0x0000, 0x0000, 0x439a, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x439c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x439d, 0x0000, 0x439e, 0x43a1, 0x0000, 0x0000, 0x0000, 0x0000, 0x43a2, 0x43a3,
 0x0000, 0x43a5, 0x0000, 0x0000, 0x0000, 0x0000, 0x43a6, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x43a8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x43b6, 0x0000, 0x43c0, 0x43c4, 0x0000, 0x0000, 0x0000, 0x43c6, 0x43c7,
 0x0000, 0x0000, 0x43c9, 0x0000, 0x0000, 0x43ca, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x43cb, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x43cc, 0x43cd, 0x0000, 0x0000, 0x43cf, 0x0000, 0x0000, 0x0000,
 0x43db, 0x0000, 0x43dc, 0x0000, 0x0000, 0x0000, 0x43f1, 0x0000, 0x0000, 0x0000,
 0x0000, 0x43f2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x43f3, 0x0000, 0x0000,
 0x43f7, 0x0000, 0x0000, 0x0000, 0x43f9, 0x4409, 0x0000, 0x440a, 0x0000, 0x440b,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x440e, 0x440f, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x4410, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4414, 0x4415,
 0x4419, 0x0000, 0x0000, 0x0000, 0x441d, 0x0000, 0x0000, 0x4421, 0x0000, 0x0000,
 0x4422, 0x0000, 0x0000, 0x442d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x442e, 0x4430, 0x4436, 0x0000, 0x0000, 0x443a, 0x0000, 0x0000,
 0x443c, 0x0000, 0x0000, 0x443d, 0x0000, 0x0000, 0x0000, 0x0000, 0x443e, 0x0000,
 0x4443, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4447, 0x0000, 0x0000, 0x0000,
 0x444b, 0x444c, 0x0000, 0x444d, 0x0000, 0x444e, 0x0000, 0x4453, 0x4454, 0x0000,
 0x0000, 0x4455, 0x0000, 0x4456, 0x4457, 0x0000, 0x0000, 0x0000, 0x4458, 0x0000,
 0x0000, 0x0000, 0x4459, 0x0000, 0x0000, 0x0000, 0x445e, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x445f, 0x0000, 0x4461, 0x0000, 0x4463, 0x0000, 0x0000, 0x0000,
 0x4468, 0x4469, 0x446a, 0x0000, 0x0000, 0x446b, 0x0000, 0x0000, 0x0000, 0x446f,
 0x0000, 0x0000, 0x0000, 0x4472, 0x0000, 0x0000, 0x4473, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4477, 0x0000, 0x0000, 0x0000,
 0x4478, 0x0000, 0x0000, 0x0000, 0x447e, 0x0000, 0x0000, 0x0000, 0x0000, 0x4480,
 0x0000, 0x0000, 0x0000, 0x4483, 0x0000, 0x4484, 0x4487, 0x448d, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x4494, 0x0000, 0x0000, 0x4496, 0x0000, 0x4497,
 0x0000, 0x0000, 0x4498, 0x0000, 0x0000, 0x0000, 0x449b, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x449c, 0x0000, 0x0000, 0x449d, 0x449e, 0x0000, 0x449f,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x44a1, 0x44a2, 0x0000, 0x44a7,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x44ad, 0x0000, 0x0000, 0x0000, 0x44ae, 0x44af, 0x0000, 0x44b2, 0x0000,
 0x0000, 0x44b3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x44b4,
 0x0000, 0x0000, 0x0000, 0x0000, 0x44bc, 0x44bd, 0x0000, 0x0000, 0x44be, 0x44c0,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x44c1, 0x0000, 0x0000, 0x0000,
 0x44c4, 0x0000, 0x0000, 0x44c5, 0x0000, 0x0000, 0x44c7, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x44cc, 0x0000, 0x0000, 0x44d2,
 0x0000, 0x44d5, 0x44d6, 0x0000, 0x0000, 0x0000, 0x0000, 0x44d7, 0x0000, 0x0000,
 0x44d8, 0x0000, 0x0000, 0x44de, 0x0000, 0x0000, 0x44df, 0x44e1, 0x44e2, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x44e3, 0x0000, 0x0000, 0x44e4,
 0x0000, 0x0000, 0x44e5, 0x0000, 0x44e6, 0x0000, 0x44e8, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x44e9, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x44eb, 0x0000,
 0x0000, 0x0000, 0x0000, 0x44ed, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x44ee, 0x44fe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x44ff, 0x4500, 0x0000, 0x4501, 0x4502, 0x0000, 0x0000,
 0x0000, 0x4505, 0x4507, 0x4509, 0x0000, 0x450f, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x4514, 0x0000, 0x0000, 0x0000, 0x4516, 0x0000, 0x4532,
 0x0000, 0x0000, 0x4538, 0x453a, 0x453e, 0x0000, 0x0000, 0x4540, 0x0000, 0x0000,
 0x4541, 0x0000, 0x0000, 0x0000, 0x4544, 0x0000, 0x4545, 0x0000, 0x4546, 0x0000,
 0x0000, 0x0000, 0x4547, 0x0000, 0x0000, 0x0000, 0x0000, 0x4549, 0x0000, 0x0000,
 0x0000, 0x0000, 0x454b, 0x0000, 0x0000, 0x0000, 0x454d, 0x454e, 0x0000, 0x0000,
 0x0000, 0x0000, 0x454f, 0x4550, 0x4551, 0x0000, 0x0000, 0x0000, 0x4555, 0x0000,
 0x4556, 0x4557, 0x4558, 0x455a, 0x4561, 0x4562, 0x0000, 0x4563, 0x0000, 0x4566,
 0x0000, 0x456c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x456f, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4570, 0x0000, 0x0000, 0x4571, 0x0000,
 0x0000, 0x4572, 0x4573, 0x0000, 0x4576, 0x4577, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4578, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x459d, 0x0000, 0x0000, 0x0000, 0x459e, 0x0000,
 0x0000, 0x0000, 0x459f, 0x45a1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x45a2,
 0x45a7, 0x45a8, 0x45a9, 0x0000, 0x0000, 0x45b5, 0x0000, 0x0000, 0x0000, 0x45b6,
 0x0000, 0x0000, 0x0000, 0x45b8, 0x45ba, 0x45be, 0x0000, 0x45bf, 0x0000, 0x0000,
 0x45c3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x45c4, 0x45c5, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x45ce, 0x45cf,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x45d0, 0x0000, 0x0000, 0x0000,
 0x45d7, 0x0000, 0x0000, 0x0000, 0x45d9, 0x45db, 0x0000, 0x45dc, 0x0000, 0x45dd,
 0x0000, 0x0000, 0x45de, 0x0000, 0x0000, 0x45df, 0x45e3, 0x4621, 0x0000, 0x0000,
 0x0000, 0x0000, 0x4622, 0x0000, 0x0000, 0x4623, 0x0000, 0x4630, 0x0000, 0x0000,
 0x4634, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4636, 0x0000, 0x0000, 0x0000,
 0x0000, 0x4638, 0x463a, 0x0000, 0x0000, 0x463f, 0x0000, 0x0000, 0x0000, 0x0000,
 0x4653, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4657, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x4659, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x465a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x465c, 0x0000, 0x0000,
 0x465e, 0x0000, 0x0000, 0x0000, 0x465f, 0x0000, 0x0000, 0x0000, 0x4660, 0x0000,
 0x4661, 0x0000, 0x0000, 0x0000, 0x466e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x466f, 0x0000, 0x0000, 0x4674, 0x4675, 0x4676, 0x0000, 0x0000,
 0x4681, 0x4688, 0x0000, 0x4689, 0x468a, 0x0000, 0x468b, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x468e, 0x0000, 0x0000, 0x0000, 0x0000,
 0x4690, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4693,
 0x0000, 0x0000, 0x0000, 0x4694, 0x0000, 0x0000, 0x469b, 0x0000, 0x0000, 0x469e,
 0x46ad, 0x46ae, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x46b1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x46b2, 0x46b4, 0x0000, 0x0000,
 0x0000, 0x46bc, 0x0000, 0x46bf, 0x0000, 0x0000, 0x46c0, 0x0000, 0x46c1, 0x0000,
 0x0000, 0x46c3, 0x46c4, 0x0000, 0x46c6, 0x0000, 0x0000, 0x0000, 0x0000, 0x46c9,
 0x0000, 0x0000, 0x0000, 0x0000, 0x46cb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x46cc, 0x0000, 0x0000, 0x0000, 0x0000, 0x46cd,
 0x46ce, 0x0000, 0x46cf, 0x0000, 0x0000, 0x46d0, 0x46d7, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x46e6, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x46e7, 0x46e8, 0x0000, 0x0000, 0x46ec, 0x46f4, 0x0000, 0x46f6,
 0x46fb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x46fc, 0x4707, 0x0000, 0x4708, 0x0000, 0x0000, 0x0000, 0x0000, 0x4709, 0x0000,
 0x470b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x470c, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x470d, 0x0000, 0x0000, 0x470e, 0x0000,
 0x0000, 0x470f, 0x4710, 0x0000, 0x0000, 0x4712, 0x4713, 0x4714, 0x0000, 0x0000,
 0x0000, 0x4715, 0x0000, 0x471b, 0x0000, 0x471c, 0x0000, 0x0000, 0x0000, 0x0000,
 0x471d, 0x0000, 0x0000, 0x0000, 0x471f, 0x4720, 0x0000, 0x0000, 0x4726, 0x0000,
 0x0000, 0x0000, 0x4727, 0x4728, 0x0000, 0x0000, 0x0000, 0x472c, 0x0000, 0x0000,
 0x472e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x472f, 0x0000, 0x4731, 0x4737,
 0x0000, 0x473a, 0x0000, 0x473b, 0x0000, 0x0000, 0x0000, 0x0000, 0x4740, 0x0000,
 0x0000, 0x4741, 0x4742, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4743, 0x474b,
 0x0000, 0x474d, 0x0000, 0x474e, 0x0000, 0x0000, 0x0000, 0x475a, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x475d, 0x475e, 0x475f, 0x4761, 0x4769, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x476a, 0x0000, 0x476b, 0x0000, 0x476c, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x476d, 0x0000, 0x476f, 0x4771, 0x0000, 0x0000, 0x4772, 0x0000,
 0x0000, 0x0000, 0x0000, 0x4784, 0x0000, 0x0000, 0x0000, 0x4786, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x4787, 0x0000, 0x4788, 0x4789, 0x0000, 0x478b, 0x0000, 0x0000, 0x478c, 0x4790,
 0x0000, 0x479b, 0x0000, 0x479c, 0x0000, 0x47a0, 0x0000, 0x0000, 0x0000, 0x0000,
 0x47a1, 0x0000, 0x47a4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x47a5, 0x0000, 0x47a8, 0x47a9, 0x0000, 0x47aa, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x47ac, 0x0000, 0x47af, 0x0000, 0x0000, 0x47b4, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x47b5, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x47bf, 0x0000, 0x0000, 0x0000, 0x47c0, 0x0000, 0x47c1, 0x0000, 0x47c2,
 0x47c3, 0x0000, 0x0000, 0x0000, 0x4805, 0x480c, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x480d, 0x4812, 0x0000, 0x0000, 0x0000, 0x0000, 0x4813, 0x0000, 0x4814, 0x0000,
 0x0000, 0x0000, 0x4815, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4817, 0x0000,
 0x0000, 0x0000, 0x4818, 0x0000, 0x4819, 0x0000, 0x481c, 0x0000, 0x0000, 0x481d,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4822, 0x0000,
 0x0000, 0x4823, 0x0000, 0x0000, 0x0000, 0x0000, 0x4829, 0x0000, 0x0000, 0x0000,
 0x482c, 0x0000, 0x482d, 0x0000, 0x0000, 0x0000, 0x482e, 0x482f, 0x4830, 0x0000,
 0x0000, 0x0000, 0x4835, 0x0000, 0x0000, 0x0000, 0x4836, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x4838, 0x483a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x483b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x483f, 0x0000, 0x0000,
 0x4840, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4849, 0x0000, 0x4859,
 0x0000, 0x485a, 0x485b, 0x0000, 0x0000, 0x0000, 0x485d, 0x485e, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x485f, 0x0000, 0x0000, 0x0000, 0x0000, 0x4864, 0x4865,
 0x0000, 0x4866, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4867, 0x4869,
 0x0000, 0x486a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x486c, 0x486d,
 0x486e, 0x486f, 0x0000, 0x4872, 0x0000, 0x0000, 0x0000, 0x0000, 0x4879, 0x487c,
 0x0000, 0x0000, 0x487e, 0x0000, 0x0000, 0x4889, 0x488b, 0x0000, 0x0000, 0x0000,
 0x488c, 0x0000, 0x488e, 0x0000, 0x0000, 0x0000, 0x0000, 0x489a, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x489c, 0x0000, 0x0000, 0x489d, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x489e, 0x0000, 0x48a0, 0x0000, 0x0000, 0x0000, 0x0000,
 0x48a2, 0x0000, 0x0000, 0x0000, 0x48a4, 0x0000, 0x0000, 0x48a5, 0x48a6, 0x0000,
 0x0000, 0x48a9, 0x0000, 0x0000, 0x0000, 0x0000, 0x48aa, 0x0000, 0x0000, 0x0000,
 0x48ab, 0x48ac, 0x0000, 0x48ad, 0x0000, 0x0000, 0x0000, 0x0000, 0x48b0, 0x0000,
 0x0000, 0x48b3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x48b4, 0x0000, 0x48b8, 0x0000, 0x0000, 0x48b9, 0x48bb, 0x0000, 0x0000,
 0x0000, 0x48c4, 0x0000, 0x0000, 0x0000, 0x48c5, 0x0000, 0x0000, 0x48c6, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x48c7, 0x0000, 0x48c8, 0x0000,
 0x0000, 0x48cb, 0x48cd, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x48d1,
 0x48d3, 0x48d8, 0x0000, 0x48dc, 0x0000, 0x0000, 0x48dd, 0x0000, 0x48df, 0x48e0,
 0x0000, 0x0000, 0x0000, 0x48e1, 0x0000, 0x0000, 0x48ea, 0x48f2, 0x0000, 0x0000,
 0x0000, 0x0000, 0x48f5, 0x48fc, 0x48fd, 0x0000, 0x0000, 0x48fe, 0x0000, 0x0000,
 0x4902, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4907, 0x4908,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x4909, 0x0000, 0x0000, 0x490c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x490e, 0x0000, 0x4914, 0x0000, 0x0000, 0x4915, 0x0000, 0x4916, 0x0000, 0x0000,
 0x4917, 0x0000, 0x491a, 0x0000, 0x0000, 0x491e, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x491f, 0x0000, 0x0000, 0x4922, 0x0000, 0x4926, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x492b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4933, 0x4935, 0x0000,
 0x0000, 0x4936, 0x0000, 0x4937, 0x4938, 0x493a, 0x493c, 0x0000, 0x4940, 0x4941,
 0x0000, 0x0000, 0x4942, 0x494b, 0x0000, 0x494d, 0x0000, 0x0000, 0x0000, 0x494e,
 0x0000, 0x0000, 0x0000, 0x4951, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4955,
 0x495a, 0x495b, 0x495d, 0x0000, 0x0000, 0x4960, 0x4963, 0x0000, 0x4964, 0x0000,
 0x4969, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x496b, 0x0000, 0x0000,
 0x4970, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4971, 0x4974, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4976, 0x0000, 0x0000, 0x0000, 0x497b,
 0x497f, 0x4980, 0x0000, 0x0000, 0x0000, 0x0000, 0x4989, 0x0000, 0x0000, 0x498b,
 0x498d, 0x0000, 0x0000, 0x498e, 0x0000, 0x0000, 0x0000, 0x0000, 0x498f, 0x0000,
 0x0000, 0x4990, 0x0000, 0x0000, 0x0000, 0x0000, 0x4991, 0x0000, 0x4998, 0x0000,
 0x4999, 0x0000, 0x499a, 0x0000, 0x0000, 0x0000, 0x0000, 0x499b, 0x0000, 0x499c,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x499d, 0x499e, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x49a0, 0x0000, 0x0000,
 0x0000, 0x49a5, 0x49ac, 0x0000, 0x0000, 0x49ae, 0x49b2, 0x0000, 0x0000, 0x49b3,
 0x49b5, 0x0000, 0x0000, 0x49ba, 0x49c1, 0x49cb, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x49cc, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x49cf, 0x0000, 0x49d0, 0x0000, 0x0000,
 0x0000, 0x49d4, 0x0000, 0x0000, 0x0000, 0x49d5, 0x0000, 0x49d6, 0x49e3, 0x49e4,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x49e7, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x49e8, 0x0000, 0x0000, 0x0000, 0x49e9, 0x49f1,
 0x0000, 0x0000, 0x0000, 0x0000, 0x49f2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x49f4, 0x0000, 0x0000, 0x0000, 0x0000, 0x49f6, 0x49fe, 0x0000, 0x0000,
 0x0000, 0x4a07, 0x4a0d, 0x0000, 0x0000, 0x0000, 0x0000, 0x4a0e, 0x0000, 0x0000,
 0x0000, 0x0000, 0x4a0f, 0x4a10, 0x0000, 0x0000, 0x4a11, 0x0000, 0x0000, 0x4a12,
 0x0000, 0x0000, 0x0000, 0x0000, 0x4a13, 0x4a14, 0x0000, 0x0000, 0x0000, 0x4a15,
 0x0000, 0x4a17, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x4a18, 0x0000, 0x4a19, 0x0000, 0x4a1a, 0x4a1d, 0x4a20, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x4a21, 0x0000, 0x0000, 0x0000, 0x4a25, 0x0000,
 0x0000, 0x0000, 0x4a2e, 0x0000, 0x4a36, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x4a37, 0x4a3b, 0x0000, 0x0000, 0x4a3d, 0x0000, 0x0000, 0x0000, 0x4a3e, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4a40, 0x4a43, 0x0000, 0x0000, 0x4a4a,
 0x0000, 0x0000, 0x4a4b, 0x0000, 0x4a50, 0x0000, 0x4a57, 0x4a58, 0x0000, 0x4a5f,
 0x0000, 0x4a61, 0x4a6a, 0x0000, 0x0000, 0x0000, 0x4a6b, 0x4a6f, 0x4a70, 0x0000,
 0x4a73, 0x4a77, 0x4a78, 0x0000, 0x0000, 0x4a90, 0x0000, 0x0000, 0x0000, 0x4a95,
 0x4a96, 0x0000, 0x0000, 0x0000, 0x0000, 0x4a97, 0x0000, 0x4a98, 0x0000, 0x0000,
 0x0000, 0x4a99, 0x0000, 0x0000, 0x4a9a, 0x0000, 0x4a9b, 0x4a9c, 0x0000, 0x0000,
 0x4a9f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4aa7, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4aa8, 0x0000, 0x0000, 0x0000, 0x4aac,
 0x4aad, 0x0000, 0x4ab1, 0x4ab2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4ab3, 0x4ab4, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4ab5, 0x4ab6, 0x0000, 0x4ab8, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4ab9,
 0x4aba, 0x4abb, 0x4abc, 0x0000, 0x0000, 0x4aca, 0x0000, 0x0000, 0x4acb, 0x4ad4,
 0x4ad6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4aee,
 0x4af1, 0x0000, 0x0000, 0x4af3, 0x0000, 0x0000, 0x0000, 0x4af9, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x4afa, 0x0000, 0x4afd, 0x0000, 0x0000, 0x0000, 0x0000,
 0x4afe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x4b02, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4b03, 0x0000, 0x4b05, 0x4b0a,
 0x0000, 0x0000, 0x0000, 0x4b0d, 0x0000, 0x4b12, 0x0000, 0x0000, 0x0000, 0x4b17,
 0x4b1d, 0x0000, 0x0000, 0x4b1e, 0x0000, 0x0000, 0x4b1f, 0x4b20, 0x4b21, 0x4b27,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4b28, 0x0000, 0x4b30, 0x4b31, 0x0000,
 0x0000, 0x0000, 0x0000, 0x4b36, 0x0000, 0x4b38, 0x4b3a, 0x4b3b, 0x0000, 0x0000,
 0x4b3d, 0x0000, 0x4b42, 0x0000, 0x0000, 0x0000, 0x4b48, 0x0000, 0x4b4e, 0x4b51,
 0x4b52, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x4b53, 0x0000, 0x0000, 0x4b54, 0x0000, 0x0000, 0x4b55,
 0x4b57, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4b58, 0x4b5b, 0x0000, 0x4b5c, 0x0000,
 0x0000, 0x0000, 0x0000, 0x4b61, 0x0000, 0x4b62, 0x0000, 0x0000, 0x0000, 0x0000,
 0x4b66, 0x4b67, 0x0000, 0x0000, 0x0000, 0x0000, 0x4b68, 0x4b69, 0x0000, 0x0000,
 0x0000, 0x0000, 0x4b72, 0x0000, 0x0000, 0x4b73, 0x0000, 0x0000, 0x4b79, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4b7a, 0x0000, 0x4b85, 0x0000,
 0x4b86, 0x4b87, 0x0000, 0x4b88, 0x4b89, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4b92, 0x0000, 0x0000, 0x4b99,
 0x0000, 0x4b9a, 0x4ba2, 0x0000, 0x4ba6, 0x4ba7, 0x0000, 0x0000, 0x4ba9, 0x0000,
 0x4baf, 0x0000, 0x4bb1, 0x4bb4, 0x4bbc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x4bbd, 0x4bbe, 0x0000, 0x0000, 0x0000, 0x0000, 0x4bc0, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x4bca, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x4bd4, 0x0000, 0x0000, 0x4bd5, 0x4bde, 0x0000, 0x4be0, 0x0000, 0x0000,
 0x0000, 0x4be1, 0x0000, 0x0000, 0x0000, 0x4be4, 0x0000, 0x0000, 0x0000, 0x0000,
 0x4be7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4be8, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x4bf8, 0x4c03, 0x0000, 0x0000, 0x4c05, 0x0000, 0x4c06, 0x4c07,
 0x0000, 0x4c0b, 0x4c12, 0x4c1a, 0x0000, 0x0000, 0x0000, 0x0000, 0x4c26, 0x0000,
 0x0000, 0x0000, 0x0000, 0x4c2d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x4c2e, 0x4c30, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x4c31, 0x0000, 0x0000, 0x0000, 0x0000, 0x4c32, 0x4c33,
 0x0000, 0x0000, 0x0000, 0x4c34, 0x0000, 0x0000, 0x4c37, 0x0000, 0x0000, 0x4c3a,
 0x0000, 0x4c3b, 0x0000, 0x4c3c, 0x0000, 0x4c3e, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x4c4a, 0x0000, 0x4c51, 0x4c52, 0x0000, 0x4c57,
 0x4c5a, 0x0000, 0x4c5b, 0x4c5f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x4c60, 0x4c61, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x4c63, 0x0000, 0x0000, 0x4c64, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x4c68, 0x4c69, 0x0000, 0x0000, 0x4c6a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x4c6d, 0x4c6f, 0x0000, 0x4c70, 0x0000, 0x0000, 0x0000, 0x4c71, 0x4c72,
 0x0000, 0x4c7a, 0x0000, 0x0000, 0x0000, 0x0000, 0x4c7c, 0x0000, 0x0000, 0x0000,
 0x0000, 0x4c7d, 0x4c80, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x4c81, 0x4c82, 0x0000, 0x0000, 0x0000, 0x4c83, 0x4c84, 0x0000, 0x4c85, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4c88, 0x4c89, 0x4c8f, 0x0000, 0x4c90,
 0x0000, 0x0000, 0x4c94, 0x0000, 0x0000, 0x4c95, 0x0000, 0x4c96, 0x4c98, 0x4c9a,
 0x0000, 0x4c9d, 0x4c9e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4ca0,
 0x4ca1, 0x0000, 0x0000, 0x4ca2, 0x0000, 0x0000, 0x4ca3, 0x0000, 0x0000, 0x0000,
 0x4ca4, 0x4ca5, 0x4caf, 0x0000, 0x0000, 0x4cb0, 0x4cb2, 0x4cb4, 0x0000, 0x4cbb,
 0x0000, 0x0000, 0x4cbc, 0x4cca, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x4ccb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4cdb, 0x4cdd, 0x0000, 0x0000,
 0x0000, 0x0000, 0x4cdf, 0x0000, 0x4ce3, 0x0000, 0x4ce4, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x4ce7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x4ce8, 0x4ce9, 0x4cec, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x4cef, 0x4cf1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4cf2,
 0x4cf3, 0x0000, 0x0000, 0x4cf4, 0x0000, 0x4cf6, 0x0000, 0x0000, 0x4cf7, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4cf8, 0x4cfc, 0x0000, 0x4cfe, 0x0000,
 0x4d01, 0x0000, 0x0000, 0x0000, 0x4d03, 0x0000, 0x0000, 0x0000, 0x0000, 0x4d06,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4d08, 0x0000, 0x4d0a,
 0x0000, 0x0000, 0x4d0d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4d12, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x4d13, 0x0000, 0x4d16, 0x4d17, 0x4d1b, 0x0000, 0x0000, 0x4d1c,
 0x0000, 0x4d1d, 0x0000, 0x0000, 0x0000, 0x4d22, 0x0000, 0x0000, 0x4d23, 0x0000,
 0x4d3b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4d3c,
 0x4d3f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4d42, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x4d43, 0x0000, 0x0000, 0x4d44, 0x4d4e, 0x0000, 0x4d4f,
 0x0000, 0x0000, 0x4d50, 0x0000, 0x0000, 0x0000, 0x4d51, 0x0000, 0x0000, 0x4d54,
 0x4d55, 0x0000, 0x0000, 0x0000, 0x4d57, 0x0000, 0x0000, 0x0000, 0x4d59, 0x0000,
 0x0000, 0x0000, 0x0000, 0x4d5b, 0x0000, 0x4d5c, 0x0000, 0x4d5d, 0x0000, 0x0000,
 0x4d5f, 0x0000, 0x0000, 0x0000, 0x4d60, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x4d61, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4d68,
 0x0000, 0x4d6d, 0x0000, 0x4d6e, 0x4d76, 0x4d77, 0x0000, 0x0000, 0x0000, 0x4d79,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x4d7e, 0x0000, 0x0000, 0x0000, 0x0000, 0x4d7f, 0x0000, 0x0000, 0x4d83, 0x0000,
 0x0000, 0x0000, 0x0000, 0x4d85, 0x0000, 0x0000, 0x0000, 0x0000, 0x4d87, 0x0000,
 0x0000, 0x4d88, 0x0000, 0x4d89, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x4d8b, 0x0000, 0x0000, 0x0000, 0x4d8e, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4d98, 0x0000, 0x4d99, 0x0000, 0x4d9a,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4d9c, 0x0000, 0x0000,
 0x4d9e, 0x0000, 0x0000, 0x4d9f, 0x0000, 0x0000, 0x4da0, 0x4da1, 0x4da3, 0x0000,
 0x4da8, 0x4daa, 0x4dac, 0x0000, 0x0000, 0x4dad, 0x4dae, 0x4db0, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x4db2, 0x4db4, 0x4db5, 0x0000, 0x0000, 0x4db6, 0x0000, 0x0000, 0x0000, 0x4db7,
 0x0000, 0x4db8, 0x4dbe, 0x0000, 0x0000, 0x4dbf, 0x0000, 0x0000, 0x4dc1, 0x0000,
 0x0000, 0x0000, 0x4dc2, 0x0000, 0x4dc4, 0x0000, 0x4dc5, 0x4dc7, 0x0000, 0x0000,
 0x0000, 0x4dc9, 0x4dd0, 0x0000, 0x4de2, 0x4de3, 0x4de4, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x4de6, 0x0000, 0x4de7, 0x0000, 0x4de9, 0x0000,
 0x0000, 0x0000, 0x4def, 0x4df0, 0x4df2, 0x4df8, 0x0000, 0x4dfd, 0x0000, 0x4e03,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4e07, 0x0000, 0x4e08, 0x0000, 0x4e16,
 0x0000, 0x0000, 0x4e17, 0x0000, 0x4e19, 0x0000, 0x4e1b, 0x0000, 0x0000, 0x0000,
 0x4e1e, 0x4e1f, 0x4e21, 0x0000, 0x4e23, 0x4e25, 0x0000, 0x4e2b, 0x4e2c, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4e2e, 0x0000, 0x4e34, 0x0000, 0x0000,
 0x0000, 0x0000, 0x4e35, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4e37, 0x4e38,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4e39, 0x0000, 0x0000, 0x4e3b, 0x0000,
 0x0000, 0x4e3d, 0x0000, 0x0000, 0x4e40, 0x0000, 0x0000, 0x0000, 0x0000, 0x4e4c,
 0x4e4d, 0x0000, 0x4e50, 0x4e51, 0x0000, 0x0000, 0x4e52, 0x0000, 0x4e54, 0x0000,
 0x0000, 0x4e56, 0x4e59, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x4e5b, 0x0000, 0x0000, 0x4e5d, 0x0000, 0x4e5e, 0x0000, 0x4e60,
 0x0000, 0x0000, 0x4e62, 0x0000, 0x0000, 0x4e63, 0x0000, 0x0000, 0x0000, 0x0000,
 0x4e65, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4e66, 0x4e67, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x4e68, 0x0000, 0x0000, 0x4e69, 0x4e6a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x4e6b, 0x0000, 0x4e6e, 0x0000, 0x0000, 0x0000, 0x0000, 0x4e70, 0x0000, 0x4e71,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4e7f, 0x0000, 0x4e82, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4e8b, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4e90, 0x0000, 0x0000, 0x0000, 0x4e91,
 0x4e92, 0x0000, 0x0000, 0x0000, 0x4e93, 0x4e9b, 0x4e9c, 0x0000, 0x0000, 0x0000,
 0x4ea3, 0x4ea5, 0x4ea6, 0x0000, 0x0000, 0x0000, 0x0000, 0x4ea8, 0x0000, 0x0000,
 0x4ea9, 0x4eaa, 0x4eb6, 0x0000, 0x4eb8, 0x0000, 0x0000, 0x0000, 0x4eb9, 0x0000,
 0x0000, 0x4eba, 0x0000, 0x0000, 0x0000, 0x4ebe, 0x0000, 0x4ec3, 0x0000, 0x0000,
 0x4ec4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4ec6, 0x0000,
 0x4ec8, 0x0000, 0x4eca, 0x0000, 0x4ecf, 0x0000, 0x0000, 0x4ed2, 0x0000, 0x0000,
 0x0000, 0x0000, 0x4eff, 0x0000, 0x0000, 0x0000, 0x0000, 0x4f00, 0x0000, 0x4f02,
 0x0000, 0x0000, 0x4f06, 0x0000, 0x4f07, 0x0000, 0x0000, 0x0000, 0x0000, 0x4f08,
 0x0000, 0x0000, 0x4f09, 0x4f0a, 0x0000, 0x4f14, 0x0000, 0x4f17, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x4f19, 0x0000, 0x0000, 0x0000, 0x4f1a, 0x0000,
 0x0000, 0x0000, 0x0000, 0x4f1b, 0x0000, 0x4f1d, 0x0000, 0x4f1e, 0x0000, 0x0000,
 0x0000, 0x0000, 0x4f20, 0x0000, 0x0000, 0x4f28, 0x0000, 0x0000, 0x0000, 0x0000,
 0x4f2a, 0x0000, 0x0000, 0x0000, 0x4f36, 0x0000, 0x0000, 0x4f37, 0x4f3a, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x4f3b, 0x0000, 0x4f3c, 0x0000, 0x4f3d, 0x0000,
 0x4f3f, 0x4f42, 0x0000, 0x0000, 0x0000, 0x0000, 0x4f44, 0x0000, 0x0000, 0x0000,
 0x0000, 0x4f45, 0x4f49, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4f4b,
 0x0000, 0x4f4c, 0x4f4f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4f53,
 0x0000, 0x0000, 0x4f54, 0x0000, 0x4f55, 0x0000, 0x4f56, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x4f58, 0x0000, 0x0000, 0x0000, 0x4f5a, 0x0000, 0x0000,
 0x0000, 0x0000, 0x4f5b, 0x4f5c, 0x0000, 0x4f62, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x4f73, 0x0000, 0x0000, 0x0000, 0x4f76, 0x0000, 0x0000, 0x0000,
 0x0000, 0x4f80, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x4f8a, 0x0000, 0x0000, 0x4f8d, 0x0000, 0x4f97, 0x4f99, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x4f9a, 0x4f9b, 0x0000, 0x4f9c, 0x0000, 0x0000, 0x4f9d, 0x0000, 0x4f9e, 0x0000,
 0x4f9f, 0x0000, 0x4fa4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4fa6, 0x4fa8, 0x4fa9,
 0x0000, 0x0000, 0x4fab, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4fac, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4fae, 0x4fbf, 0x0000,
 0x0000, 0x0000, 0x4fc1, 0x0000, 0x0000, 0x4fc4, 0x0000, 0x0000, 0x4fca, 0x4fcc,
 0x0000, 0x4fcf, 0x0000, 0x0000, 0x4fd0, 0x0000, 0x4fd1, 0x4fd2, 0x4fd3, 0x0000,
 0x0000, 0x0000, 0x0000, 0x4fd8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4fda,
 0x0000, 0x4fdb, 0x0000, 0x4fde, 0x0000, 0x0000, 0x0000, 0x0000, 0x4fe0, 0x0000,
 0x4fe3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x4fe4, 0x4fe5, 0x0000, 0x0000, 0x4fe6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x4fe9, 0x0000, 0x4fea, 0x0000, 0x0000, 0x0000, 0x4ff1, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x4ff5, 0x0000, 0x0000, 0x0000, 0x4ff9, 0x0000, 0x4ffc,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4ffd, 0x0000,
 0x0000, 0x5005, 0x0000, 0x0000, 0x5006, 0x0000, 0x0000, 0x5007, 0x0000, 0x5010,
 0x0000, 0x5011, 0x0000, 0x0000, 0x5012, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5013, 0x5014, 0x0000, 0x5015, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x5028, 0x502f, 0x0000, 0x5031, 0x0000, 0x0000,
 0x0000, 0x0000, 0x503b, 0x0000, 0x0000, 0x503c, 0x0000, 0x0000, 0x0000, 0x503f,
 0x0000, 0x0000, 0x0000, 0x5042, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5044,
 0x0000, 0x0000, 0x5053, 0x0000, 0x0000, 0x5054, 0x0000, 0x5056, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x506d, 0x0000, 0x0000, 0x0000, 0x0000, 0x506e, 0x0000,
 0x0000, 0x5071, 0x5072, 0x0000, 0x0000, 0x0000, 0x0000, 0x5073, 0x0000, 0x5075,
 0x5076, 0x0000, 0x0000, 0x0000, 0x508a, 0x508c, 0x0000, 0x0000, 0x0000, 0x0000,
 0x508d, 0x0000, 0x0000, 0x0000, 0x0000, 0x5093, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x5094, 0x0000, 0x0000, 0x0000, 0x5095, 0x0000, 0x5096, 0x0000, 0x0000,
 0x509f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x50e3, 0x0000, 0x0000, 0x50e5,
 0x0000, 0x0000, 0x0000, 0x50e9, 0x50ea, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x50f4, 0x50f5, 0x0000, 0x0000, 0x0000, 0x0000, 0x50f6, 0x50f8, 0x50f9, 0x0000,
 0x50fd, 0x0000, 0x50fe, 0x0000, 0x50ff, 0x5100, 0x0000, 0x5101, 0x0000, 0x0000,
 0x5108, 0x0000, 0x5109, 0x0000, 0x510c, 0x0000, 0x0000, 0x510d, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x510e, 0x0000, 0x0000, 0x0000,
 0x0000, 0x5112, 0x0000, 0x0000, 0x0000, 0x5119, 0x0000, 0x0000, 0x511b, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x511e, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x511f, 0x0000, 0x0000, 0x0000, 0x0000, 0x5120, 0x0000, 0x5121, 0x5129,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5131, 0x0000, 0x0000, 0x0000,
 0x5132, 0x513b, 0x5141, 0x0000, 0x5142, 0x0000, 0x5147, 0x0000, 0x0000, 0x5148,
 0x0000, 0x0000, 0x514a, 0x0000, 0x0000, 0x514b, 0x0000, 0x514c, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x514d, 0x0000, 0x0000, 0x5152, 0x5154, 0x5155, 0x0000,
 0x0000, 0x0000, 0x5156, 0x0000, 0x5157, 0x0000, 0x0000, 0x0000, 0x515a, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x515d, 0x515e, 0x515f, 0x0000,
 0x5160, 0x5164, 0x0000, 0x0000, 0x5167, 0x0000, 0x0000, 0x5168, 0x516a, 0x0000,
 0x516b, 0x0000, 0x516c, 0x0000, 0x5176, 0x0000, 0x0000, 0x0000, 0x5177, 0x0000,
 0x0000, 0x0000, 0x0000, 0x5178, 0x0000, 0x0000, 0x0000, 0x5185, 0x0000, 0x0000,
 0x5187, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5189, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x518c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x5190, 0x0000, 0x0000, 0x5192, 0x0000, 0x0000, 0x0000, 0x0000, 0x5193, 0x5194,
 0x0000, 0x0000, 0x519a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x519b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x51a9, 0x0000,
 0x51aa, 0x51ae, 0x0000, 0x0000, 0x51b0, 0x51b3, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x51b4, 0x0000, 0x51b5, 0x0000, 0x51b7, 0x51b8, 0x51ba, 0x0000, 0x51bf,
 0x0000, 0x51c0, 0x51c1, 0x51c2, 0x0000, 0x0000, 0x51c7, 0x0000, 0x0000, 0x51cb,
 0x0000, 0x0000, 0x51cd, 0x0000, 0x0000, 0x0000, 0x51cf, 0x0000, 0x0000, 0x0000,
 0x51d2, 0x51d3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x51d6, 0x0000, 0x51da,
 0x0000, 0x0000, 0x51db, 0x51e4, 0x0000, 0x0000, 0x51e7, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x51ed, 0x51ef, 0x0000, 0x0000, 0x0000, 0x51f8, 0x0000, 0x51fb,
 0x51fc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x51fd, 0x0000, 0x0000, 0x0000,
 0x5203, 0x0000, 0x5206, 0x0000, 0x5207, 0x0000, 0x0000, 0x0000, 0x0000, 0x5208,
 0x5209, 0x0000, 0x0000, 0x0000, 0x0000, 0x5210, 0x0000, 0x5212, 0x0000, 0x5218,
 0x0000, 0x0000, 0x0000, 0x5219, 0x521a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x521d, 0x5222, 0x5223, 0x5224, 0x0000, 0x0000, 0x5225, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x5226, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5227, 0x5228, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x522d, 0x0000, 0x0000, 0x522e, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x522f, 0x0000, 0x5231, 0x0000,
 0x5236, 0x5237, 0x0000, 0x0000, 0x0000, 0x5239, 0x523d, 0x0000, 0x0000, 0x5241,
 0x5248, 0x5249, 0x0000, 0x0000, 0x524a, 0x524b, 0x0000, 0x0000, 0x0000, 0x524d,
 0x0000, 0x0000, 0x0000, 0x524f, 0x5250, 0x0000, 0x0000, 0x5251, 0x0000, 0x5252,
 0x0000, 0x0000, 0x5256, 0x0000, 0x0000, 0x0000, 0x0000, 0x5257, 0x0000, 0x0000,
 0x5258, 0x5259, 0x0000, 0x0000, 0x525e, 0x525f, 0x0000, 0x5261, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5263, 0x0000, 0x5265, 0x0000, 0x5266,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5267, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x5268, 0x0000, 0x526a, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x526b, 0x0000, 0x0000, 0x526c, 0x526d, 0x526e,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x526f, 0x0000, 0x5270, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x5271, 0x5274, 0x5275, 0x0000, 0x0000, 0x5278, 0x5279,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x527b, 0x5282, 0x5283, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x5285, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x5289, 0x528b, 0x0000, 0x0000, 0x528e, 0x0000, 0x0000,
 0x0000, 0x5291, 0x5296, 0x0000, 0x5297, 0x0000, 0x0000, 0x5298, 0x0000, 0x5299,
 0x529a, 0x0000, 0x52a0, 0x52a2, 0x52a3, 0x52a4, 0x0000, 0x0000, 0x0000, 0x52a8,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x52a9, 0x0000, 0x52ac, 0x0000,
 0x52ae, 0x0000, 0x0000, 0x0000, 0x0000, 0x52b2, 0x0000, 0x0000, 0x0000, 0x0000,
 0x52b3, 0x0000, 0x0000, 0x52b4, 0x0000, 0x52b6, 0x0000, 0x52b7, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x52b8, 0x52bb, 0x52c4, 0x0000, 0x0000, 0x0000, 0x52c5,
 0x0000, 0x0000, 0x52c6, 0x0000, 0x0000, 0x0000, 0x52c8, 0x0000, 0x0000, 0x52c9,
 0x0000, 0x0000, 0x0000, 0x52ce, 0x0000, 0x52dc, 0x0000, 0x0000, 0x52dd, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x52df, 0x52e0, 0x0000, 0x0000, 0x52e7,
 0x52e9, 0x0000, 0x52ea, 0x0000, 0x0000, 0x0000, 0x0000, 0x52eb, 0x52ec, 0x0000,
 0x0000, 0x52ed, 0x0000, 0x0000, 0x0000, 0x0000, 0x52ee, 0x52f4, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x52f5, 0x0000, 0x0000, 0x52f6, 0x52f7, 0x0000, 0x0000, 0x0000, 0x0000,
 0x5308, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5309, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x530b, 0x0000, 0x0000, 0x0000, 0x530f, 0x0000,
 0x5318, 0x0000, 0x531a, 0x0000, 0x5322, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x5323, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x532e, 0x0000, 0x0000, 0x5331, 0x0000, 0x0000, 0x0000, 0x0000,
 0x5332, 0x0000, 0x0000, 0x0000, 0x5333, 0x0000, 0x5334, 0x5336, 0x0000, 0x5344,
 0x0000, 0x5346, 0x534a, 0x534b, 0x0000, 0x534c, 0x0000, 0x534e, 0x0000, 0x0000,
 0x0000, 0x534f, 0x5350, 0x0000, 0x0000, 0x0000, 0x5368, 0x0000, 0x0000, 0x536a,
 0x5371, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x5372, 0x0000, 0x0000, 0x0000, 0x5373, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5376, 0x0000,
 0x0000, 0x5377, 0x537c, 0x537e, 0x0000, 0x0000, 0x0000, 0x537f, 0x5381, 0x0000,
 0x5382, 0x0000, 0x0000, 0x0000, 0x5384, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5385, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x5386, 0x0000, 0x5387, 0x0000, 0x0000, 0x5388, 0x0000, 0x0000,
 0x5389, 0x0000, 0x0000, 0x0000, 0x0000, 0x538d, 0x538e, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x5395, 0x5396, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x5397, 0x0000, 0x5398, 0x0000, 0x0000, 0x0000, 0x0000, 0x539a,
 0x0000, 0x0000, 0x0000, 0x539b, 0x539c, 0x0000, 0x539d, 0x539e, 0x0000, 0x0000,
 0x0000, 0x539f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x53a0, 0x0000, 0x0000, 0x0000, 0x0000, 0x53a1,
 0x0000, 0x53ad, 0x0000, 0x53ae, 0x0000, 0x0000, 0x0000, 0x53b1, 0x53b4, 0x0000,
 0x0000, 0x0000, 0x0000, 0x53b5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x53b9,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x53ba, 0x0000, 0x53c3, 0x0000, 0x53c4, 0x53c9, 0x0000, 0x53cc, 0x0000, 0x53cd,
 0x53ce, 0x0000, 0x0000, 0x0000, 0x53d1, 0x0000, 0x0000, 0x53d2, 0x0000, 0x0000,
 0x0000, 0x53d4, 0x53d5, 0x0000, 0x0000, 0x53d8, 0x0000, 0x0000, 0x0000, 0x53e1,
 0x53e6, 0x0000, 0x0000, 0x53e7, 0x0000, 0x0000, 0x53e9, 0x53eb, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x53ec, 0x0000, 0x0000, 0x53ed,
 0x53ee, 0x0000, 0x0000, 0x53f0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x5413, 0x0000, 0x0000, 0x5415, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x5416, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5419, 0x541a,
 0x0000, 0x0000, 0x541b, 0x0000, 0x0000, 0x541d, 0x0000, 0x0000, 0x5423, 0x543c,
 0x0000, 0x543f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x5447, 0x0000, 0x0000, 0x0000, 0x0000, 0x5449, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x5457, 0x0000, 0x0000, 0x5464, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x5465, 0x0000, 0x5466, 0x0000, 0x0000, 0x5471,
 0x5472, 0x5473, 0x5474, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5477, 0x0000, 0x0000, 0x0000,
 0x0000, 0x547f, 0x0000, 0x5483, 0x0000, 0x0000, 0x0000, 0x0000, 0x5487, 0x548e,
 0x5495, 0x549e, 0x0000, 0x0000, 0x549f, 0x54a0, 0x0000, 0x54a2, 0x0000, 0x0000,
 0x54a3, 0x0000, 0x54a6, 0x54a8, 0x54a9, 0x0000, 0x54aa, 0x54b3, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x54b4, 0x0000, 0x54be, 0x0000, 0x0000, 0x0000, 0x0000,
 0x54bf, 0x54c4, 0x0000, 0x54c7, 0x0000, 0x54c8, 0x0000, 0x0000, 0x54cd, 0x0000,
 0x0000, 0x0000, 0x54ce, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x54cf, 0x0000, 0x0000, 0x0000, 0x54d0, 0x0000, 0x54d5, 0x0000, 0x54e2,
 0x0000, 0x0000, 0x0000, 0x54e3, 0x54e5, 0x0000, 0x0000, 0x0000, 0x0000, 0x54e9,
 0x54ed, 0x54ee, 0x0000, 0x54f3, 0x0000, 0x0000, 0x0000, 0x54f5, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x54f6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x54f8, 0x0000, 0x0000,
 0x0000, 0x0000, 0x54f9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x54fb,
 0x54fc, 0x0000, 0x54fd, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5500,
 0x0000, 0x0000, 0x5503, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x5504, 0x0000, 0x0000, 0x5506, 0x0000, 0x0000, 0x5507, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x550d, 0x0000,
 0x550e, 0x0000, 0x0000, 0x550f, 0x0000, 0x0000, 0x0000, 0x0000, 0x5510, 0x0000,
 0x0000, 0x5511, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x5514, 0x551b, 0x551c, 0x551f, 0x0000, 0x0000, 0x0000, 0x5525, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x552d, 0x0000, 0x0000, 0x0000, 0x0000, 0x552e,
 0x0000, 0x552f, 0x5531, 0x0000, 0x5532, 0x5533, 0x0000, 0x5539, 0x553b, 0x553c,
 0x0000, 0x553f, 0x0000, 0x5540, 0x0000, 0x0000, 0x5541, 0x0000, 0x0000, 0x5542,
 0x5548, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5549, 0x5558, 0x5559, 0x0000,
 0x0000, 0x556b, 0x556e, 0x556f, 0x5571, 0x0000, 0x0000, 0x0000, 0x5572, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5573, 0x0000,
 0x5576, 0x0000, 0x0000, 0x0000, 0x5577, 0x0000, 0x5579, 0x557e, 0x0000, 0x0000,
 0x0000, 0x0000, 0x557f, 0x0000, 0x0000, 0x5580, 0x5586, 0x5587, 0x5589, 0x0000,
 0x558d, 0x0000, 0x5590, 0x0000, 0x0000, 0x5592, 0x0000, 0x0000, 0x0000, 0x5595,
 0x5596, 0x5597, 0x0000, 0x0000, 0x5598, 0x0000, 0x0000, 0x5599, 0x559a, 0x559b,
 0x0000, 0x559f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x55a1,
 0x0000, 0x0000, 0x55a2, 0x55ad, 0x55b3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x55b8, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x55b9, 0x0000, 0x55bb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x55bd, 0x0000, 0x0000, 0x0000, 0x55be,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x55bf, 0x0000, 0x55c0, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x55c2, 0x55c5, 0x0000, 0x0000, 0x0000,
 0x0000, 0x55c6, 0x0000, 0x55c7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x55ca, 0x55cb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x55cc, 0x55cd, 0x0000, 0x0000, 0x55d1, 0x55d2, 0x0000, 0x0000, 0x0000, 0x55d6,
 0x0000, 0x0000, 0x55dc, 0x55dd, 0x0000, 0x55de, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x55e1, 0x0000, 0x55e4, 0x0000, 0x55e8, 0x0000, 0x55ef, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x55f1, 0x0000, 0x55f2, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x55f3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x55f4,
 0x0000, 0x0000, 0x0000, 0x55f8, 0x0000, 0x55f9, 0x55ff, 0x0000, 0x0000, 0x5600,
 0x0000, 0x0000, 0x0000, 0x5601, 0x5603, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x5604, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5605, 0x5615, 0x0000, 0x5617, 0x0000,
 0x0000, 0x0000, 0x5618, 0x0000, 0x0000, 0x0000, 0x5620, 0x5621, 0x0000, 0x0000,
 0x5625, 0x5627, 0x5628, 0x562b, 0x0000, 0x0000, 0x562c, 0x562d, 0x0000, 0x0000,
 0x5630, 0x0000, 0x0000, 0x0000, 0x0000, 0x5632, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x5639, 0x0000, 0x0000, 0x0000, 0x563a, 0x563b, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x563c, 0x0000, 0x0000, 0x0000,
 0x0000, 0x563d, 0x5644, 0x5653, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x5658, 0x0000, 0x0000, 0x565b, 0x0000, 0x565c, 0x0000, 0x565d, 0x0000,
 0x565e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x565f, 0x5667,
 0x0000, 0x5668, 0x566a, 0x0000, 0x0000, 0x0000, 0x0000, 0x566d, 0x0000, 0x0000,
 0x0000, 0x5670, 0x5671, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x567d,
 0x0000, 0x0000, 0x0000, 0x567e, 0x0000, 0x0000, 0x5680, 0x5682, 0x0000, 0x5684,
 0x5685, 0x5687, 0x568a, 0x0000, 0x0000, 0x0000, 0x5692, 0x0000, 0x0000, 0x0000,
 0x0000, 0x5694, 0x56a1, 0x0000, 0x0000, 0x0000, 0x0000, 0x56a3, 0x0000, 0x56a6,
 0x56a7, 0x0000, 0x0000, 0x56a8, 0x56ac, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x56ae, 0x0000, 0x56b2, 0x56b9, 0x0000, 0x0000, 0x56c0,
 0x0000, 0x56c1, 0x0000, 0x56c4, 0x0000, 0x0000, 0x56c7, 0x0000, 0x56cf, 0x56d7,
 0x0000, 0x0000, 0x56d8, 0x0000, 0x56da, 0x0000, 0x0000, 0x56db, 0x56dc, 0x0000,
 0x56dd, 0x0000, 0x56e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x56e1, 0x0000,
 0x0000, 0x0000, 0x56e2, 0x56e6, 0x56e7, 0x0000, 0x0000, 0x0000, 0x56f3, 0x56fc,
 0x0000, 0x56fd, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x56fe,
 0x0000, 0x0000, 0x0000, 0x0000, 0x56ff, 0x0000, 0x5700, 0x0000, 0x5705, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x5706, 0x5708, 0x570b, 0x570e, 0x0000, 0x0000,
 0x570f, 0x5711, 0x0000, 0x0000, 0x5712, 0x0000, 0x5715, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5717, 0x0000, 0x571d,
 0x571e, 0x0000, 0x0000, 0x0000, 0x5721, 0x0000, 0x5724, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x572b, 0x0000, 0x0000,
 0x0000, 0x572d, 0x0000, 0x573e, 0x0000, 0x0000, 0x0000, 0x573f, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x5740, 0x0000, 0x5742, 0x5748, 0x0000, 0x574b, 0x574d,
 0x0000, 0x574e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5755,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5756, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5757, 0x5758, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5759, 0x575e, 0x0000, 0x0000,
 0x5761, 0x0000, 0x5762, 0x5765, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5767,
 0x0000, 0x5769, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x576a, 0x0000, 0x0000,
 0x0000, 0x0000, 0x576d, 0x0000, 0x0000, 0x0000, 0x0000, 0x576e, 0x0000, 0x576f,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5777,
 0x0000, 0x0000, 0x5778, 0x577b, 0x577c, 0x5782, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5785,
 0x0000, 0x0000, 0x5786, 0x0000, 0x0000, 0x5788, 0x0000, 0x0000, 0x5789, 0x578a,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5798, 0x0000, 0x0000, 0x0000,
 0x0000, 0x579a, 0x0000, 0x0000, 0x0000, 0x579b, 0x0000, 0x579c, 0x0000, 0x57a0,
 0x0000, 0x57a3, 0x57aa, 0x57ab, 0x0000, 0x0000, 0x0000, 0x0000, 0x57ac, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x57ae, 0x0000, 0x57b6, 0x0000, 0x57b7, 0x0000,
 0x0000, 0x0000, 0x57c1, 0x0000, 0x57c6, 0x0000, 0x57c7, 0x0000, 0x0000, 0x0000,
 0x0000, 0x57c8, 0x57c9, 0x0000, 0x57d7, 0x0000, 0x0000, 0x0000, 0x57d8, 0x0000,
 0x0000, 0x0000, 0x0000, 0x57d9, 0x0000, 0x0000, 0x57e3, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x57f2, 0x0000, 0x0000, 0x57f3, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x57f4, 0x0000, 0x0000, 0x0000, 0x57f5, 0x57f8,
 0x0000, 0x0000, 0x0000, 0x5806, 0x0000, 0x0000, 0x5807, 0x0000, 0x0000, 0x5808,
 0x0000, 0x580c, 0x5819, 0x0000, 0x581b, 0x0000, 0x0000, 0x0000, 0x0000, 0x5821,
 0x0000, 0x0000, 0x5822, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x5826, 0x0000, 0x0000, 0x0000, 0x0000, 0x5827,
 0x5828, 0x0000, 0x0000, 0x582f, 0x0000, 0x5833, 0x0000, 0x5836, 0x5837, 0x5839,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x583a, 0x0000, 0x0000, 0x583b, 0x0000,
 0x0000, 0x583e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x583f, 0x0000, 0x5840,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5841, 0x0000, 0x584a, 0x0000, 0x0000,
 0x584c, 0x0000, 0x0000, 0x5851, 0x0000, 0x0000, 0x585a, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x585b, 0x0000, 0x5860, 0x5861, 0x0000, 0x0000, 0x586e,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x586f, 0x0000, 0x0000, 0x5870, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5874, 0x0000, 0x5875, 0x5877,
 0x0000, 0x0000, 0x0000, 0x0000, 0x587c, 0x587d, 0x0000, 0x0000, 0x0000, 0x587e,
 0x0000, 0x587f, 0x0000, 0x0000, 0x0000, 0x5880, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5891, 0x5893, 0x5894, 0x0000,
 0x0000, 0x5896, 0x5897, 0x0000, 0x58a3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x58a5, 0x0000, 0x0000, 0x58a8, 0x0000, 0x58ab, 0x58b3, 0x58b4,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x58be, 0x0000,
 0x58bf, 0x0000, 0x0000, 0x0000, 0x0000, 0x58c3, 0x0000, 0x0000, 0x0000, 0x58c4,
 0x58c5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x58c6, 0x58c8, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x58c9, 0x0000, 0x0000, 0x58cb, 0x0000,
 0x0000, 0x0000, 0x0000, 0x58cc, 0x58cf, 0x58d0, 0x0000, 0x0000, 0x0000, 0x0000,
 0x58d3, 0x0000, 0x58dd, 0x0000, 0x0000, 0x58df, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x58e6, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x58e8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x58ec,
 0x58ed, 0x58ee, 0x0000, 0x58f0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x58f1,
 0x58f2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x58f3, 0x0000, 0x0000,
 0x58f4, 0x58f7, 0x0000, 0x58f8, 0x58f9, 0x58fc, 0x0000, 0x0000, 0x58fe, 0x5900,
 0x0000, 0x5903, 0x0000, 0x5905, 0x590c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x590e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5912, 0x0000, 0x5913,
 0x5914, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x5915, 0x0000, 0x0000, 0x591a, 0x591b, 0x591e, 0x5920, 0x0000, 0x5929,
 0x592a, 0x0000, 0x592f, 0x5931, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x5932, 0x0000, 0x5934, 0x5936, 0x0000, 0x5937, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x5938, 0x0000, 0x593f, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x5948, 0x5949, 0x0000, 0x594a, 0x594b, 0x0000, 0x0000, 0x594e,
 0x0000, 0x0000, 0x5950, 0x0000, 0x0000, 0x0000, 0x0000, 0x5951, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5952,
 0x0000, 0x5953, 0x5954, 0x0000, 0x0000, 0x0000, 0x0000, 0x5955, 0x0000, 0x5957,
 0x0000, 0x5958, 0x0000, 0x5959, 0x5961, 0x5962, 0x5964, 0x5965, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5966, 0x5967, 0x0000, 0x596e, 0x0000,
 0x596f, 0x0000, 0x0000, 0x0000, 0x5974, 0x0000, 0x5975, 0x0000, 0x0000, 0x0000,
 0x0000, 0x5978, 0x0000, 0x0000, 0x0000, 0x0000, 0x5979, 0x597b, 0x0000, 0x0000,
 0x0000, 0x5983, 0x5985, 0x0000, 0x0000, 0x5986, 0x0000, 0x0000, 0x0000, 0x5988,
 0x0000, 0x0000, 0x0000, 0x5991, 0x5992, 0x0000, 0x0000, 0x0000, 0x599d, 0x599e,
 0x0000, 0x0000, 0x0000, 0x599f, 0x0000, 0x0000, 0x0000, 0x59a0, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x59a2, 0x0000, 0x59a3, 0x0000, 0x0000,
 0x59aa, 0x0000, 0x59ac, 0x0000, 0x0000, 0x59b2, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x59b3, 0x0000, 0x0000, 0x59b4, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x59b5, 0x0000, 0x59b8, 0x0000, 0x0000, 0x0000,
 0x59b9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x59ba, 0x0000, 0x59bb, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x59c2, 0x0000, 0x0000, 0x59c3, 0x0000, 0x59cb,
 0x0000, 0x0000, 0x59cd, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x59ce,
 0x0000, 0x59dd, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x59de,
 0x59df, 0x59e0, 0x0000, 0x0000, 0x59ef, 0x59f0, 0x59f5, 0x0000, 0x0000, 0x0000,
 0x0000, 0x59f6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x59f8, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x59fb, 0x0000, 0x0000, 0x0000, 0x0000, 0x59fe, 0x0000,
 0x0000, 0x0000, 0x5a08, 0x0000, 0x5a09, 0x5a0c, 0x5a0d, 0x5a14, 0x5a15, 0x0000,
 0x5a17, 0x0000, 0x0000, 0x0000, 0x0000, 0x5a1b, 0x5a1c, 0x0000, 0x0000, 0x0000,
 0x5a1d, 0x5a21, 0x0000, 0x0000, 0x0000, 0x5a57, 0x0000, 0x5a58, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x5a59, 0x0000, 0x5a62, 0x5a65, 0x0000, 0x5a6d, 0x0000,
 0x0000, 0x5a6e, 0x0000, 0x0000, 0x0000, 0x5a70, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x5a72, 0x0000, 0x0000, 0x0000, 0x0000, 0x5a75,
 0x5a77, 0x5a78, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x5a8c, 0x0000, 0x0000, 0x0000, 0x0000, 0x5a8d,
 0x0000, 0x0000, 0x5a94, 0x0000, 0x5a95, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5a9b, 0x0000, 0x0000,
 0x5a9c, 0x5a9f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x5aa2, 0x0000, 0x5aa4, 0x0000, 0x5aa7, 0x0000, 0x5aa9, 0x5aaa, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5abb, 0x5abd, 0x0000, 0x0000, 0x5abe,
 0x5ac2, 0x5ac6, 0x0000, 0x0000, 0x0000, 0x5acd, 0x5ace, 0x5ad0, 0x0000, 0x0000,
 0x0000, 0x0000, 0x5ad1, 0x5ad6, 0x0000, 0x0000, 0x0000, 0x5ae1, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5ae4, 0x0000, 0x5aec, 0x0000, 0x0000,
 0x0000, 0x0000, 0x5aed, 0x0000, 0x5b01, 0x0000, 0x5b02, 0x0000, 0x0000, 0x0000,
 0x0000, 0x5b03, 0x0000, 0x5b06, 0x0000, 0x0000, 0x5b07, 0x5b10, 0x0000, 0x0000,
 0x5b12, 0x0000, 0x5b18, 0x0000, 0x0000, 0x0000, 0x0000, 0x5b1c, 0x0000, 0x5b1d,
 0x0000, 0x5b20, 0x0000, 0x5b26, 0x0000, 0x0000, 0x0000, 0x5b29, 0x0000, 0x0000,
 0x0000, 0x0000, 0x5b2f, 0x5b30, 0x5b32, 0x0000, 0x5b34, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5b39, 0x0000, 0x0000, 0x0000, 0x0000,
 0x5b3b, 0x0000, 0x5b3c, 0x5b3e, 0x0000, 0x0000, 0x0000, 0x5b3f, 0x5b40, 0x0000,
 0x5b41, 0x0000, 0x5b47, 0x0000, 0x5b49, 0x0000, 0x0000, 0x5b4d, 0x0000, 0x5b52,
 0x5b53, 0x0000, 0x5b56, 0x5b57, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5b5b, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5b5c, 0x5b5e, 0x0000, 0x0000, 0x5b61,
 0x5b66, 0x0000, 0x0000, 0x0000, 0x5b67, 0x0000, 0x0000, 0x0000, 0x5b68, 0x0000,
 0x0000, 0x0000, 0x0000, 0x5b69, 0x0000, 0x0000, 0x0000, 0x5b77, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5b78, 0x0000, 0x5b7e, 0x0000,
 0x5b93, 0x5b94, 0x0000, 0x0000, 0x0000, 0x0000, 0x5b98, 0x0000, 0x5b9e, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5ba0, 0x0000, 0x0000, 0x5ba2, 0x5ba8,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5ba9, 0x0000, 0x0000, 0x0000,
 0x5bae, 0x5baf, 0x0000, 0x0000, 0x5bb0, 0x0000, 0x0000, 0x0000, 0x5bb1, 0x5bc8,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5bc9, 0x0000,
 0x5bcb, 0x0000, 0x0000, 0x5bce, 0x0000, 0x0000, 0x5bcf, 0x0000, 0x0000, 0x5bd9,
 0x0000, 0x0000, 0x5bdb, 0x0000, 0x0000, 0x0000, 0x5bdd, 0x0000, 0x0000, 0x0000,
 0x0000, 0x5bde, 0x5bdf, 0x5be1, 0x5be4, 0x0000, 0x5be5, 0x5be8, 0x5bf3, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x5bf5, 0x0000, 0x0000, 0x5bf8, 0x0000, 0x0000,
 0x5c04, 0x0000, 0x0000, 0x5c05, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5c07, 0x0000, 0x5c08,
 0x0000, 0x0000, 0x5c09, 0x0000, 0x0000, 0x5c0e, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x5c10, 0x5c11, 0x5c12, 0x0000, 0x0000, 0x0000, 0x0000, 0x5c13, 0x0000,
 0x5c16, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x5c17, 0x0000, 0x5c1b, 0x0000, 0x0000, 0x5c1d, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x5c23, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x5c2c, 0x5c2e, 0x0000, 0x0000, 0x0000, 0x0000, 0x5c32, 0x5c36,
 0x0000, 0x0000, 0x5c37, 0x0000, 0x5c38, 0x0000, 0x0000, 0x0000, 0x5c3e, 0x5c40,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5c42, 0x0000, 0x0000, 0x5c43, 0x0000,
 0x0000, 0x0000, 0x0000, 0x5c45, 0x5c4a, 0x0000, 0x5c4b, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x5c4d, 0x0000, 0x5c4e, 0x0000, 0x0000, 0x0000,
 0x0000, 0x5c52, 0x0000, 0x5c54, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x5c56, 0x0000, 0x0000, 0x0000, 0x0000, 0x5c58, 0x5c73, 0x0000, 0x5c75, 0x0000,
 0x0000, 0x0000, 0x5c81, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x5c82, 0x0000, 0x5c83, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5c84, 0x0000,
 0x0000, 0x0000, 0x5c85, 0x5c89, 0x0000, 0x5c8d, 0x5c8e, 0x5c94, 0x0000, 0x5c96,
 0x0000, 0x5c9d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5ca0,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5ca2, 0x0000, 0x0000, 0x5ca3, 0x0000,
 0x0000, 0x0000, 0x0000, 0x5ca6, 0x0000, 0x0000, 0x5ca8, 0x0000, 0x0000, 0x0000,
 0x0000, 0x5caa, 0x0000, 0x0000, 0x0000, 0x5cae, 0x5cb1, 0x0000, 0x5cbd, 0x5cc2,
 0x0000, 0x5cc4, 0x0000, 0x0000, 0x0000, 0x0000, 0x5cc5, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x5cc6, 0x0000, 0x0000, 0x0000, 0x0000, 0x5cc7, 0x0000, 0x5cc9,
 0x0000, 0x0000, 0x0000, 0x0000, 0x5ccd, 0x5cd5, 0x0000, 0x0000, 0x0000, 0x5cda,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5cdb, 0x0000, 0x5cdc,
 0x5ce5, 0x0000, 0x0000, 0x5cf4, 0x0000, 0x0000, 0x0000, 0x0000, 0x5cf6, 0x0000,
 0x5cf7, 0x0000, 0x0000, 0x0000, 0x5cfa, 0x0000, 0x0000, 0x5cfe, 0x0000, 0x5cff,
 0x0000, 0x0000, 0x5d00, 0x0000, 0x5d01, 0x0000, 0x5d0b, 0x0000, 0x0000, 0x0000,
 0x5d0d, 0x0000, 0x5d13, 0x0000, 0x0000, 0x0000, 0x5d15, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x5d16, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x5d18, 0x5d19, 0x5d1a, 0x5d1b, 0x0000, 0x0000, 0x0000, 0x0000, 0x5d1d,
 0x5d1e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5d26, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x5d27, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5d47,
 0x5d49, 0x0000, 0x0000, 0x5d4a, 0x5d4b, 0x5d57, 0x0000, 0x5d5b, 0x0000, 0x0000,
 0x0000, 0x0000, 0x5d5d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5d5e,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5d5f, 0x5d61, 0x0000, 0x5d62, 0x0000,
 0x5d63, 0x5d6e, 0x5d6f, 0x5d70, 0x0000, 0x5d72, 0x0000, 0x5d74, 0x0000, 0x5d77,
 0x0000, 0x5d7e, 0x0000, 0x5d81, 0x5d85, 0x0000, 0x5d86, 0x5d8a, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x5d93, 0x5d94, 0x5d96, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x5d97, 0x0000, 0x5d9a, 0x5d9d, 0x0000, 0x5d9e, 0x0000, 0x0000,
 0x0000, 0x0000, 0x5d9f, 0x5da0, 0x0000, 0x0000, 0x5da5, 0x0000, 0x0000, 0x5da6,
 0x0000, 0x0000, 0x0000, 0x0000, 0x5da7, 0x0000, 0x5da8, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x5da9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5dac,
 0x0000, 0x0000, 0x5db0, 0x0000, 0x5db1, 0x0000, 0x0000, 0x5db3, 0x0000, 0x0000,
 0x5db4, 0x5db6, 0x5db7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5db8,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5dba, 0x0000,
 0x0000, 0x0000, 0x5dbe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x5dbf, 0x0000, 0x0000, 0x5dc3, 0x0000, 0x5dc4, 0x0000, 0x5dc6,
 0x0000, 0x0000, 0x0000, 0x5dc7, 0x0000, 0x0000, 0x5dc8, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x5dc9, 0x0000, 0x0000, 0x5dca, 0x0000, 0x0000,
 0x5dcb, 0x0000, 0x0000, 0x5dcd, 0x5dce, 0x0000, 0x0000, 0x5dcf, 0x5dd0, 0x5ddb,
 0x0000, 0x5ddc, 0x5ddd, 0x0000, 0x5dde, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x5de1, 0x5de2, 0x0000, 0x5de3, 0x0000, 0x0000, 0x5de4, 0x0000, 0x0000, 0x5dec,
 0x0000, 0x5df0, 0x5df1, 0x5dff, 0x5e03, 0x0000, 0x5e04, 0x5e06, 0x0000, 0x0000,
 0x5e07, 0x5e0e, 0x5e17, 0x0000, 0x5e1a, 0x0000, 0x0000, 0x0000, 0x5e1f, 0x0000,
 0x5e22, 0x5e25, 0x5e28, 0x5e2a, 0x0000, 0x5e2b, 0x0000, 0x0000, 0x0000, 0x5e2c,
 0x0000, 0x0000, 0x0000, 0x0000, 0x5e2e, 0x5e2f, 0x0000, 0x5e31, 0x0000, 0x0000,
 0x5e33, 0x5e38, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5e3c, 0x0000,
 0x5e3d, 0x0000, 0x5e3e, 0x0000, 0x5e3f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x5e47, 0x0000, 0x0000, 0x5e48, 0x0000, 0x5e49, 0x5e4e, 0x0000, 0x0000, 0x0000,
 0x5e52, 0x0000, 0x0000, 0x5e53, 0x5e55, 0x5e5a, 0x0000, 0x5e63, 0x0000, 0x0000,
 0x0000, 0x5e65, 0x5e66, 0x5e67, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x5e69, 0x5e6a, 0x5e6f, 0x0000, 0x0000, 0x0000,
 0x5e72, 0x0000, 0x0000, 0x5e73, 0x0000, 0x0000, 0x5e75, 0x0000, 0x5e78, 0x5e85,
 0x0000, 0x5e89, 0x5e8c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5e8e,
 0x5e94, 0x5e9c, 0x0000, 0x0000, 0x0000, 0x5ea0, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x5ea2, 0x0000, 0x5eaa, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x5eab, 0x0000, 0x5eac, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x5eaf, 0x5eb0, 0x5eb1, 0x0000, 0x0000, 0x5eb8, 0x0000, 0x0000, 0x5eb9,
 0x0000, 0x5ebb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5ebd, 0x0000,
 0x5ecc, 0x0000, 0x0000, 0x0000, 0x5ecd, 0x0000, 0x5ecf, 0x5ed0, 0x0000, 0x0000,
 0x0000, 0x0000, 0x5ed1, 0x0000, 0x0000, 0x5ed2, 0x0000, 0x0000, 0x5ed7, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5ed8, 0x0000, 0x5ee5, 0x5ee6,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5ee8, 0x0000, 0x0000, 0x5f03,
 0x0000, 0x0000, 0x0000, 0x5f09, 0x5f0a, 0x5f0b, 0x5f13, 0x0000, 0x5f1f, 0x0000,
 0x0000, 0x5f31, 0x5f32, 0x0000, 0x0000, 0x0000, 0x5f33, 0x0000, 0x0000, 0x0000,
 0x0000, 0x5f34, 0x5f35, 0x5f36, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5f3a,
 0x0000, 0x0000, 0x0000, 0x0000, 0x5f3b, 0x0000, 0x5f3d, 0x0000, 0x5f3f, 0x5f45,
 0x0000, 0x5f46, 0x0000, 0x0000, 0x5f4a, 0x5f4b, 0x5f50, 0x0000, 0x0000, 0x0000,
 0x5f51, 0x5f52, 0x0000, 0x5f56, 0x0000, 0x0000, 0x0000, 0x5f5b, 0x0000, 0x0000,
 0x0000, 0x5f5f, 0x0000, 0x5f60, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5f61,
 0x0000, 0x5f63, 0x0000, 0x5f66, 0x0000, 0x5f67, 0x5f6c, 0x0000, 0x5f73, 0x0000,
 0x0000, 0x0000, 0x5f77, 0x0000, 0x0000, 0x0000, 0x5f78, 0x5f7a, 0x5f7e, 0x0000,
 0x0000, 0x0000, 0x5f7f, 0x5f80, 0x5f81, 0x5f84, 0x0000, 0x0000, 0x0000, 0x0000,
 0x5f85, 0x5f89, 0x0000, 0x0000, 0x5f8a, 0x5f8b, 0x5f8c, 0x0000, 0x5f91, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5f96, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5f97, 0x0000, 0x5f99, 0x5f9a, 0x5f9b,
 0x5f9c, 0x0000, 0x5f9e, 0x0000, 0x0000, 0x0000, 0x0000, 0x5fa0, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5fa1, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5fa2,
 0x5fa5, 0x0000, 0x0000, 0x0000, 0x0000, 0x5fa6, 0x0000, 0x0000, 0x0000, 0x5fa8,
 0x0000, 0x0000, 0x0000, 0x5fae, 0x0000, 0x0000, 0x0000, 0x0000, 0x5fb1, 0x0000,
 0x0000, 0x5fb2, 0x0000, 0x0000, 0x0000, 0x5fb3, 0x5fba, 0x0000, 0x0000, 0x0000,
 0x5fbb, 0x0000, 0x0000, 0x5fbf, 0x0000, 0x0000, 0x5fc1, 0x5fc2, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x5fc5, 0x0000, 0x5fc6, 0x0000, 0x5fc8, 0x0000, 0x5fc9,
 0x5fcc, 0x5fcd, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5fcf, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x5fd0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5fd9,
 0x5fdb, 0x0000, 0x5fdc, 0x0000, 0x0000, 0x0000, 0x5fe4, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x5fe5, 0x5fe6, 0x0000, 0x0000, 0x0000, 0x5fe9, 0x5fea, 0x0000,
 0x5feb, 0x0000, 0x5fec, 0x0000, 0x5fee, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x5ff0, 0x0000, 0x0000, 0x0000, 0x5ff1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x5ff2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x5ff7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x5ff9, 0x0000, 0x0000, 0x0000, 0x5ffe, 0x0000, 0x5fff, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6001, 0x6005,
 0x0000, 0x6008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6009, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x600a, 0x0000, 0x0000, 0x600b, 0x0000, 0x600c, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x600e,
 0x600f, 0x0000, 0x0000, 0x0000, 0x0000, 0x6010, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x6012, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x6014, 0x6015, 0x0000, 0x0000, 0x0000, 0x0000, 0x601a, 0x601b, 0x0000,
 0x0000, 0x0000, 0x0000, 0x601c, 0x0000, 0x0000, 0x601d, 0x0000, 0x6022, 0x0000,
 0x0000, 0x6023, 0x0000, 0x0000, 0x0000, 0x0000, 0x6024, 0x6027, 0x6028, 0x6030,
 0x0000, 0x0000, 0x0000, 0x6033, 0x0000, 0x603e, 0x603f, 0x0000, 0x0000, 0x0000,
 0x0000, 0x6040, 0x0000, 0x0000, 0x0000, 0x604f, 0x6050, 0x6051, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6056, 0x0000, 0x6057, 0x6058,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6059, 0x0000, 0x0000, 0x0000, 0x0000,
 0x605b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x605c, 0x605d, 0x0000,
 0x605e, 0x6062, 0x0000, 0x0000, 0x0000, 0x6063, 0x0000, 0x6066, 0x0000, 0x0000,
 0x6067, 0x0000, 0x0000, 0x0000, 0x6069, 0x0000, 0x606b, 0x0000, 0x0000, 0x0000,
 0x0000, 0x606c, 0x0000, 0x606d, 0x0000, 0x0000, 0x606e, 0x0000, 0x0000, 0x6070,
 0x6071, 0x0000, 0x0000, 0x0000, 0x0000, 0x6072, 0x6073, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x6079, 0x0000, 0x607a, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6085, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x6086, 0x0000, 0x6088, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x6089, 0x608a, 0x0000, 0x608b, 0x0000, 0x608c, 0x608e, 0x0000, 0x608f, 0x0000,
 0x0000, 0x0000, 0x0000, 0x6090, 0x0000, 0x0000, 0x6095, 0x0000, 0x0000, 0x60a2,
 0x0000, 0x60ad, 0x60ae, 0x0000, 0x0000, 0x0000, 0x60b0, 0x0000, 0x0000, 0x0000,
 0x60b1, 0x0000, 0x0000, 0x0000, 0x60b6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x60ba, 0x0000, 0x60bb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x60bc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x60bd, 0x60bf, 0x60c0, 0x0000,
 0x60c4, 0x0000, 0x0000, 0x0000, 0x0000, 0x60c5, 0x0000, 0x0000, 0x0000, 0x0000,
 0x60c9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x60d1, 0x0000, 0x60d2, 0x60d4,
 0x0000, 0x0000, 0x0000, 0x60d5, 0x0000, 0x0000, 0x0000, 0x0000, 0x60da, 0x60de,
 0x0000, 0x60df, 0x60e0, 0x0000, 0x0000, 0x0000, 0x60e3, 0x0000, 0x60e4, 0x60e6,
 0x0000, 0x60e7, 0x0000, 0x0000, 0x0000, 0x60ea, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x60fb, 0x60fc, 0x0000, 0x6103, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x6104, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6107, 0x0000,
 0x610b, 0x610c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x610f, 0x0000, 0x0000, 0x6110, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x6111, 0x0000, 0x6112, 0x6113, 0x0000, 0x0000, 0x0000, 0x6114,
 0x0000, 0x6115, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x6116, 0x0000, 0x6117, 0x0000, 0x0000, 0x6124, 0x0000, 0x0000, 0x0000,
 0x6133, 0x0000, 0x0000, 0x0000, 0x6134, 0x0000, 0x613f, 0x6141, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x6143, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6144,
 0x0000, 0x6151, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6152, 0x0000,
 0x0000, 0x6155, 0x6162, 0x6163, 0x0000, 0x0000, 0x0000, 0x6164, 0x0000, 0x0000,
 0x616b, 0x0000, 0x0000, 0x616e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x6171, 0x6176, 0x0000, 0x6177, 0x0000, 0x0000, 0x6179,
 0x0000, 0x0000, 0x0000, 0x617a, 0x0000, 0x617f, 0x0000, 0x0000, 0x0000, 0x6181,
 0x0000, 0x0000, 0x6182, 0x0000, 0x6184, 0x6188, 0x618a, 0x618c, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x6190, 0x0000, 0x0000, 0x0000, 0x6191, 0x0000, 0x6196,
 0x0000, 0x0000, 0x6197, 0x0000, 0x0000, 0x6198, 0x0000, 0x0000, 0x0000, 0x61a1,
 0x0000, 0x0000, 0x0000, 0x61a2, 0x0000, 0x0000, 0x61a9, 0x0000, 0x0000, 0x0000,
 0x61ab, 0x0000, 0x0000, 0x61ba, 0x0000, 0x0000, 0x61bf, 0x0000, 0x0000, 0x0000,
 0x61ca, 0x0000, 0x0000, 0x61cb, 0x61cc, 0x0000, 0x61cd, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x61cf, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x61d0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x61d2, 0x0000,
 0x0000, 0x61d3, 0x61d5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x61d9,
 0x0000, 0x0000, 0x61db, 0x0000, 0x61dc, 0x61dd, 0x0000, 0x0000, 0x61de, 0x0000,
 0x0000, 0x0000, 0x61df, 0x0000, 0x0000, 0x0000, 0x0000, 0x61e1, 0x61e3, 0x0000,
 0x0000, 0x61e4, 0x61e8, 0x0000, 0x61e9, 0x61ed, 0x61ee, 0x0000, 0x0000, 0x0000,
 0x0000, 0x61f0, 0x0000, 0x61f1, 0x0000, 0x6202, 0x0000, 0x0000, 0x6204, 0x6205,
 0x620d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6211, 0x6214, 0x0000,
 0x0000, 0x6219, 0x0000, 0x0000, 0x621b, 0x621c, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x621d, 0x0000, 0x0000, 0x0000, 0x6220, 0x6221, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6225, 0x0000, 0x0000, 0x0000, 0x6226,
 0x0000, 0x622a, 0x622e, 0x0000, 0x6233, 0x0000, 0x6237, 0x0000, 0x0000, 0x0000,
 0x623f, 0x0000, 0x6249, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x624b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x6256, 0x0000, 0x6257, 0x0000, 0x6277, 0x0000, 0x0000, 0x0000, 0x6279, 0x0000,
 0x0000, 0x0000, 0x0000, 0x627d, 0x0000, 0x6283, 0x0000, 0x6287, 0x0000, 0x6289,
 0x0000, 0x0000, 0x0000, 0x628b, 0x0000, 0x0000, 0x0000, 0x628c, 0x0000, 0x0000,
 0x0000, 0x628d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x628f,
 0x6291, 0x0000, 0x0000, 0x0000, 0x0000, 0x6295, 0x6297, 0x0000, 0x0000, 0x0000,
 0x629b, 0x0000, 0x0000, 0x0000, 0x62a4, 0x0000, 0x62a9, 0x62aa, 0x0000, 0x0000,
 0x0000, 0x0000, 0x62ac, 0x62b1, 0x0000, 0x62b4, 0x0000, 0x0000, 0x62b9, 0x62ec,
 0x0000, 0x62ed, 0x0000, 0x62ee, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x62ef, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x62f0, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x62f4, 0x0000, 0x0000, 0x0000, 0x62f5,
 0x0000, 0x0000, 0x0000, 0x62f8, 0x62f9, 0x62fa, 0x0000, 0x0000, 0x62ff, 0x0000,
 0x6306, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6308, 0x0000,
 0x630a, 0x0000, 0x631f, 0x0000, 0x6323, 0x0000, 0x0000, 0x0000, 0x0000, 0x6328,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x632a,
 0x0000, 0x632c, 0x0000, 0x632e, 0x0000, 0x0000, 0x6337, 0x0000, 0x0000, 0x6339,
 0x0000, 0x0000, 0x0000, 0x633a, 0x0000, 0x0000, 0x0000, 0x633f, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6345,
 0x6347, 0x0000, 0x0000, 0x6349, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x634b, 0x0000, 0x0000, 0x0000, 0x634d, 0x0000, 0x0000, 0x0000, 0x6350,
 0x0000, 0x0000, 0x0000, 0x0000, 0x6359, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x635b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x635c, 0x0000, 0x0000, 0x0000, 0x635d, 0x0000, 0x0000, 0x6360, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6362, 0x0000, 0x0000, 0x6363, 0x0000,
 0x6366, 0x0000, 0x0000, 0x6369, 0x0000, 0x0000, 0x0000, 0x636a, 0x0000, 0x0000,
 0x0000, 0x0000, 0x636c, 0x0000, 0x636d, 0x636e, 0x636f, 0x0000, 0x0000, 0x0000,
 0x6370, 0x0000, 0x6371, 0x0000, 0x0000, 0x0000, 0x6373, 0x0000, 0x6375, 0x0000,
 0x637c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x637d,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x637f, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x6382, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x6383, 0x0000, 0x0000, 0x0000, 0x0000, 0x6385, 0x0000, 0x0000, 0x0000, 0x0000,
 0x638b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x638c, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x638d,
 0x0000, 0x6399, 0x0000, 0x0000, 0x639a, 0x0000, 0x63a0, 0x0000, 0x63a6, 0x0000,
 0x63a8, 0x0000, 0x0000, 0x63a9, 0x63aa, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x63ad, 0x63ae, 0x63af, 0x0000, 0x63b0, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x63b1, 0x0000, 0x63b2, 0x63b7, 0x63be, 0x0000, 0x63c0,
 0x0000, 0x63c1, 0x0000, 0x0000, 0x63cc, 0x63ce, 0x0000, 0x0000, 0x63cf, 0x0000,
 0x63d0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x63d2, 0x0000, 0x63d3, 0x0000,
 0x63d4, 0x63d5, 0x63e0, 0x0000, 0x0000, 0x0000, 0x63e2, 0x63e3, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x63e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x63eb,
 0x0000, 0x0000, 0x0000, 0x63ed, 0x0000, 0x0000, 0x0000, 0x63ee, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x63f4, 0x0000, 0x0000,
 0x0000, 0x0000, 0x63f5, 0x0000, 0x0000, 0x0000, 0x0000, 0x63f6, 0x0000, 0x63f7,
 0x63f8, 0x63f9, 0x0000, 0x63fa, 0x0000, 0x0000, 0x0000, 0x63fc, 0x0000, 0x63fd,
 0x640f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6412, 0x0000, 0x0000, 0x0000,
 0x0000, 0x6413, 0x6417, 0x0000, 0x0000, 0x641d, 0x0000, 0x0000, 0x641f, 0x0000,
 0x0000, 0x0000, 0x6423, 0x6424, 0x0000, 0x0000, 0x6431, 0x0000, 0x0000, 0x0000,
 0x0000, 0x6436, 0x0000, 0x0000, 0x0000, 0x643d, 0x643f, 0x0000, 0x0000, 0x6447,
 0x0000, 0x0000, 0x644e, 0x6462, 0x0000, 0x6463, 0x6466, 0x6467, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6468, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x646a, 0x0000, 0x0000, 0x646e, 0x0000, 0x646f, 0x0000, 0x6470,
 0x0000, 0x6473, 0x6474, 0x6475, 0x0000, 0x0000, 0x6476, 0x6480, 0x6484, 0x0000,
 0x0000, 0x0000, 0x6486, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x6489, 0x0000, 0x0000, 0x648b, 0x0000, 0x0000, 0x0000, 0x648c,
 0x0000, 0x648d, 0x6491, 0x0000, 0x6492, 0x0000, 0x6494, 0x64ac, 0x64b2, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x64b4, 0x0000, 0x0000, 0x0000, 0x0000, 0x64b5,
 0x0000, 0x64b6, 0x64b8, 0x64b9, 0x0000, 0x0000, 0x0000, 0x64bd, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x64c5, 0x64c9, 0x0000, 0x0000, 0x0000, 0x64d0,
 0x64d1, 0x0000, 0x0000, 0x64d3, 0x64d6, 0x64d7, 0x0000, 0x0000, 0x64d9, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x64dc, 0x0000, 0x0000,
 0x0000, 0x0000, 0x64e8, 0x64e9, 0x0000, 0x0000, 0x0000, 0x64f6, 0x0000, 0x0000,
 0x0000, 0x64f7, 0x64f8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x64f9, 0x64fa, 0x0000, 0x0000, 0x64fb, 0x0000, 0x0000, 0x64fc,
 0x0000, 0x6506, 0x0000, 0x0000, 0x0000, 0x6507, 0x6509, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x650b, 0x650c, 0x0000, 0x650d, 0x6512, 0x0000,
 0x6513, 0x0000, 0x6514, 0x6515, 0x0000, 0x0000, 0x0000, 0x0000, 0x6516, 0x652e,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x652f, 0x6530, 0x6531,
 0x0000, 0x0000, 0x0000, 0x6534, 0x6535, 0x0000, 0x0000, 0x0000, 0x0000, 0x6536,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6538, 0x0000, 0x6539,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x653a, 0x0000,
 0x0000, 0x653c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x653d, 0x6547, 0x0000,
 0x0000, 0x0000, 0x0000, 0x6548, 0x0000, 0x0000, 0x654a, 0x0000, 0x0000, 0x0000,
 0x654d, 0x0000, 0x0000, 0x6552, 0x6556, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x6559, 0x0000, 0x655e, 0x0000, 0x6564, 0x0000, 0x0000, 0x6569,
 0x656a, 0x0000, 0x0000, 0x656b, 0x0000, 0x656c, 0x656d, 0x656e, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x656f, 0x0000, 0x0000, 0x0000, 0x0000, 0x6570, 0x0000,
 0x0000, 0x0000, 0x6571, 0x6573, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6575,
 0x6577, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x657a, 0x0000,
 0x657d, 0x0000, 0x0000, 0x0000, 0x657e, 0x0000, 0x0000, 0x0000, 0x6580, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6589, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x6592, 0x0000, 0x0000, 0x0000, 0x6595, 0x0000, 0x0000, 0x0000, 0x6596, 0x6597,
 0x0000, 0x0000, 0x659e, 0x659f, 0x65a0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x65a1, 0x65a2, 0x65a4, 0x0000, 0x65a6, 0x65a7, 0x0000, 0x0000, 0x0000,
 0x65a8, 0x65ac, 0x0000, 0x65ad, 0x65b1, 0x65b2, 0x65bc, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x65be, 0x0000, 0x0000, 0x65bf, 0x0000, 0x0000, 0x65c1, 0x0000,
 0x65c2, 0x0000, 0x65c3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x65c5, 0x0000,
 0x0000, 0x0000, 0x0000, 0x65c6, 0x65cb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x65cc, 0x0000, 0x65d2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x65d3, 0x0000, 0x65d5, 0x0000,
 0x0000, 0x65d7, 0x0000, 0x0000, 0x0000, 0x65d9, 0x0000, 0x65da, 0x65dd, 0x0000,
 0x0000, 0x0000, 0x0000, 0x65de, 0x0000, 0x0000, 0x0000, 0x65df, 0x0000, 0x65ea,
 0x0000, 0x0000, 0x65ee, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x65ef, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x65f0, 0x65f5, 0x0000, 0x65fb, 0x660a, 0x0000, 0x660c,
 0x0000, 0x0000, 0x660d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6618,
 0x661d, 0x662b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x6634, 0x6636, 0x0000, 0x0000, 0x0000, 0x6637, 0x0000, 0x663a, 0x663b,
 0x0000, 0x0000, 0x663c, 0x0000, 0x0000, 0x663e, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x663f,
 0x0000, 0x0000, 0x0000, 0x6640, 0x6641, 0x0000, 0x66d1, 0x66d2, 0x0000, 0x66d3,
 0x0000, 0x0000, 0x66d4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x66d5, 0x0000, 0x66db, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x66df,
 0x0000, 0x0000, 0x0000, 0x66ee, 0x0000, 0x0000, 0x0000, 0x670b, 0x0000, 0x0000,
 0x670e, 0x670f, 0x6711, 0x0000, 0x0000, 0x6718, 0x6726, 0x0000, 0x0000, 0x0000,
 0x0000, 0x672b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x672c, 0x0000, 0x0000,
 0x6734, 0x0000, 0x0000, 0x6737, 0x0000, 0x6738, 0x673a, 0x6740, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x6743, 0x0000, 0x6744, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x6749, 0x0000, 0x674c, 0x0000, 0x0000, 0x0000, 0x674e, 0x0000,
 0x0000, 0x0000, 0x0000, 0x674f, 0x0000, 0x0000, 0x0000, 0x0000, 0x6751, 0x0000,
 0x6752, 0x6754, 0x0000, 0x6755, 0x6756, 0x0000, 0x0000, 0x0000, 0x6757, 0x0000,
 0x0000, 0x0000, 0x6758, 0x0000, 0x0000, 0x675a, 0x0000, 0x0000, 0x675c, 0x0000,
 0x675f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6760,
 0x6766, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x6769, 0x0000, 0x0000, 0x676a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x676b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x676d,
 0x0000, 0x6775, 0x0000, 0x0000, 0x6776, 0x0000, 0x6777, 0x0000, 0x0000, 0x6778,
 0x677d, 0x677e, 0x0000, 0x0000, 0x677f, 0x0000, 0x6781, 0x6788, 0x678a, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x678b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x678d, 0x0000, 0x0000, 0x678e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6790, 0x0000, 0x6791,
 0x6793, 0x0000, 0x0000, 0x0000, 0x6796, 0x0000, 0x0000, 0x0000, 0x6797, 0x0000,
 0x679c, 0x679e, 0x0000, 0x0000, 0x0000, 0x679f, 0x0000, 0x67a4, 0x0000, 0x67a5,
 0x67a9, 0x67be, 0x0000, 0x0000, 0x0000, 0x67bf, 0x0000, 0x0000, 0x0000, 0x67cb,
 0x0000, 0x0000, 0x67cd, 0x0000, 0x67dc, 0x0000, 0x67e1, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x67eb, 0x0000, 0x67ec, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x67ee, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x67ef, 0x67f1, 0x67f3, 0x67f6, 0x0000, 0x0000,
 0x0000, 0x67f8, 0x67fc, 0x0000, 0x67fd, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x6803, 0x0000, 0x6805, 0x0000, 0x0000, 0x6806, 0x0000, 0x0000, 0x6808, 0x6813,
 0x0000, 0x0000, 0x0000, 0x6814, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x6816, 0x6817, 0x0000, 0x0000, 0x0000, 0x681a, 0x0000,
 0x0000, 0x6820, 0x0000, 0x0000, 0x0000, 0x0000, 0x6827, 0x682e, 0x682f, 0x0000,
 0x0000, 0x0000, 0x683d, 0x683e, 0x683f, 0x0000, 0x6841, 0x0000, 0x0000, 0x0000,
 0x0000, 0x6878, 0x0000, 0x6879, 0x0000, 0x687b, 0x687c, 0x0000, 0x687d, 0x687e,
 0x687f, 0x0000, 0x0000, 0x0000, 0x0000, 0x6880, 0x6883, 0x0000, 0x0000, 0x0000,
 0x6884, 0x6891, 0x0000, 0x0000, 0x0000, 0x6896, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x6897, 0x0000, 0x6899, 0x689a, 0x0000, 0x68a2, 0x0000, 0x0000, 0x0000,
 0x68a3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x68a4, 0x0000, 0x0000, 0x68a5, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x68a7, 0x0000, 0x68a8, 0x68a9, 0x0000, 0x0000, 0x0000,
 0x68aa, 0x0000, 0x68ad, 0x68ae, 0x0000, 0x0000, 0x0000, 0x68b0, 0x0000, 0x0000,
 0x68b3, 0x0000, 0x68b4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x68b5, 0x0000, 0x0000, 0x68b8, 0x0000, 0x0000, 0x68b9, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x68bc, 0x0000, 0x68c9, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x68ca, 0x0000, 0x0000, 0x68cb,
 0x68cd, 0x68d2, 0x0000, 0x0000, 0x0000, 0x0000, 0x68d3, 0x0000, 0x0000, 0x68e1,
 0x0000, 0x68e3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x68e4, 0x0000, 0x68e5, 0x68e9, 0x0000, 0x68ea, 0x0000, 0x68eb, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x68fc, 0x0000, 0x68fe, 0x6902,
 0x6903, 0x0000, 0x0000, 0x0000, 0x0000, 0x690a, 0x690e, 0x0000, 0x0000, 0x0000,
 0x0000, 0x690f, 0x6910, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6914, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x691f, 0x6921, 0x6922, 0x6923,
 0x6924, 0x6927, 0x0000, 0x0000, 0x0000, 0x6929, 0x692a, 0x0000, 0x0000, 0x692d,
 0x0000, 0x0000, 0x0000, 0x6930, 0x0000, 0x0000, 0x6931, 0x6932, 0x0000, 0x0000,
 0x0000, 0x6933, 0x0000, 0x6934, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6935,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6939, 0x0000, 0x0000, 0x693f,
 0x0000, 0x0000, 0x6940, 0x0000, 0x0000, 0x0000, 0x6942, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x694c, 0x0000, 0x694e, 0x0000, 0x0000, 0x6953,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6955, 0x0000, 0x6959,
 0x695a, 0x695c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x695d, 0x0000, 0x695e,
 0x0000, 0x6962, 0x0000, 0x6964, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x6966, 0x0000, 0x696a, 0x696b, 0x0000, 0x696e, 0x0000, 0x0000, 0x0000, 0x0000,
 0x697b, 0x697e, 0x0000, 0x0000, 0x697f, 0x6982, 0x6984, 0x6985, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6986, 0x6987, 0x698a, 0x0000,
 0x698b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6991, 0x0000, 0x0000, 0x0000,
 0x6992, 0x0000, 0x0000, 0x0000, 0x0000, 0x6995, 0x6996, 0x6997, 0x699a, 0x0000,
 0x0000, 0x699c, 0x699d, 0x0000, 0x0000, 0x0000, 0x699e, 0x69a2, 0x0000, 0x0000,
 0x0000, 0x69a4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x69a5, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x69a6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x69a7, 0x69a9, 0x0000, 0x69aa, 0x0000, 0x0000, 0x0000, 0x69ab,
 0x69ac, 0x0000, 0x69af, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x69b0, 0x69b2, 0x69b3, 0x0000, 0x69b5, 0x0000, 0x69b8, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x69bd, 0x0000, 0x0000, 0x69be, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x69c0, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x69c4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x69c6, 0x0000, 0x69c7, 0x0000, 0x0000, 0x0000, 0x69c9, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x69ca, 0x0000, 0x69cb, 0x69ce, 0x0000, 0x0000, 0x0000,
 0x0000, 0x69cf, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x69d0, 0x69d2, 0x0000,
 0x69d6, 0x0000, 0x0000, 0x69d7, 0x0000, 0x69db, 0x69de, 0x0000, 0x0000, 0x0000,
 0x69df, 0x0000, 0x0000, 0x0000, 0x0000, 0x69e1, 0x0000, 0x0000, 0x0000, 0x69e2,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x69e3, 0x0000, 0x0000, 0x0000,
 0x0000, 0x69e4, 0x69ed, 0x0000, 0x0000, 0x0000, 0x0000, 0x69ee, 0x0000, 0x0000,
 0x69f4, 0x0000, 0x69f6, 0x0000, 0x0000, 0x69fa, 0x69fb, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x6a0b, 0x0000, 0x0000, 0x0000, 0x0000, 0x6a0c, 0x6a0d,
 0x0000, 0x0000, 0x0000, 0x0000, 0x6a0e, 0x6a0f, 0x0000, 0x6a10, 0x0000, 0x6a17,
 0x0000, 0x0000, 0x0000, 0x6a1c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x6a27, 0x0000, 0x6a35, 0x0000, 0x0000, 0x6a37, 0x0000, 0x6a39, 0x0000,
 0x6a3b, 0x0000, 0x6a3e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6a40, 0x0000,
 0x0000, 0x0000, 0x0000, 0x6a42, 0x0000, 0x0000, 0x0000, 0x0000, 0x6a43, 0x0000,
 0x0000, 0x6a44, 0x0000, 0x0000, 0x6a46, 0x0000, 0x6a47, 0x0000, 0x0000, 0x0000,
 0x0000, 0x6a49, 0x0000, 0x0000, 0x0000, 0x6a4d, 0x0000, 0x0000, 0x6a50, 0x6a53,
 0x6a54, 0x6a56, 0x6a57, 0x0000, 0x6a58, 0x0000, 0x6a59, 0x6a5a, 0x0000, 0x0000,
 0x6a61, 0x0000, 0x0000, 0x0000, 0x0000, 0x6a63, 0x0000, 0x6a65, 0x0000, 0x6a66,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x6a67, 0x0000, 0x6a6a, 0x6a6b, 0x0000, 0x6a72,
 0x0000, 0x0000, 0x0000, 0x6a73, 0x0000, 0x6a75, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6a76, 0x6a77, 0x6a7a,
 0x0000, 0x0000, 0x0000, 0x6a7b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x6a83, 0x0000, 0x6a8c, 0x6a8e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x6aa0, 0x6aa1, 0x6aa5, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x6aa6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6ab0,
 0x6ab1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6ab6, 0x0000, 0x6ab8, 0x0000,
 0x6ac1, 0x0000, 0x6ac2, 0x6ac3, 0x0000, 0x6ac4, 0x0000, 0x0000, 0x0000, 0x0000,
 0x6acc, 0x0000, 0x0000, 0x0000, 0x6ad4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x6ad6, 0x0000, 0x6ad7, 0x0000, 0x0000, 0x0000, 0x0000, 0x6adb, 0x0000,
 0x0000, 0x6ade, 0x6adf, 0x6ae1, 0x0000, 0x0000, 0x0000, 0x6ae5, 0x0000, 0x6ae7,
 0x0000, 0x6af0, 0x6af2, 0x0000, 0x0000, 0x6af3, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x6b04, 0x0000, 0x6b05, 0x6b0c, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x6b10, 0x0000, 0x0000, 0x0000, 0x0000, 0x6b3d, 0x0000, 0x0000, 0x0000,
 0x6b40, 0x0000, 0x0000, 0x0000, 0x6b42, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x6b43, 0x0000, 0x0000, 0x0000, 0x6b44, 0x0000, 0x0000, 0x6b45,
 0x0000, 0x6b49, 0x6b4b, 0x0000, 0x0000, 0x6b4d, 0x0000, 0x6b4e, 0x0000, 0x6b4f,
 0x0000, 0x6b55, 0x6b5a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6b5c,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6b5d, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x6b65, 0x0000, 0x6b66, 0x6b6e, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6b77, 0x6b8c,
 0x0000, 0x0000, 0x0000, 0x6b8d, 0x6b99, 0x0000, 0x0000, 0x0000, 0x6b9a, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6b9b,
 0x0000, 0x0000, 0x6b9d, 0x6b9e, 0x0000, 0x6b9f, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x6ba3, 0x0000, 0x0000, 0x6bb3, 0x0000, 0x6bb5, 0x6bb6,
 0x6bb7, 0x6bb9, 0x0000, 0x6bba, 0x0000, 0x0000, 0x6bbb, 0x6bc1, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x6bc2, 0x0000, 0x0000, 0x6bc4, 0x6bc5, 0x0000, 0x0000,
 0x0000, 0x0000, 0x6bcc, 0x0000, 0x0000, 0x6bd0, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6bd8, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6bda,
 0x0000, 0x0000, 0x0000, 0x6be2, 0x0000, 0x0000, 0x6be4, 0x0000, 0x0000, 0x0000,
 0x6bef, 0x0000, 0x0000, 0x6bf0, 0x6bf2, 0x0000, 0x6bf4, 0x6bf6, 0x0000, 0x0000,
 0x0000, 0x6bfb, 0x0000, 0x6bfc, 0x6c01, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6c03, 0x6c0c,
 0x0000, 0x6c0d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6c0e,
 0x0000, 0x0000, 0x6c10, 0x0000, 0x6c11, 0x0000, 0x0000, 0x0000, 0x6c15, 0x0000,
 0x6c17, 0x0000, 0x0000, 0x0000, 0x6c19, 0x6c1a, 0x0000, 0x0000, 0x0000, 0x6c22,
 0x0000, 0x0000, 0x0000, 0x6c3f, 0x0000, 0x6c40, 0x6c41, 0x6c47, 0x6c48, 0x0000,
 0x0000, 0x6c50, 0x0000, 0x6c51, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x6c53, 0x0000, 0x0000, 0x6c54, 0x0000, 0x6c55, 0x0000,
 0x6c5a, 0x0000, 0x0000, 0x0000, 0x6c5e, 0x0000, 0x0000, 0x0000, 0x6c5f, 0x6c60,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6c61, 0x6c62, 0x0000, 0x0000,
 0x0000, 0x6c63, 0x6c64, 0x6c67, 0x6c68, 0x0000, 0x0000, 0x0000, 0x6c78, 0x6c7a,
 0x0000, 0x0000, 0x0000, 0x6c7e, 0x6c7f, 0x0000, 0x6c80, 0x6c81, 0x0000, 0x0000,
 0x6c85, 0x0000, 0x6c88, 0x0000, 0x6c8a, 0x0000, 0x0000, 0x6c8f, 0x0000, 0x6c90,
 0x6c91, 0x6c9c, 0x0000, 0x6ca4, 0x6ca5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x6ca6, 0x0000, 0x6cb1, 0x0000, 0x6cb3, 0x0000, 0x0000,
 0x0000, 0x0000, 0x6cb4, 0x6cd5, 0x6cd6, 0x0000, 0x0000, 0x0000, 0x6cd8, 0x0000,
 0x0000, 0x0000, 0x6cd9, 0x6cec, 0x0000, 0x6cf1, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x6cf2, 0x0000, 0x6cf3, 0x0000, 0x0000, 0x0000, 0x6cf4, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x6cf9, 0x6cfa, 0x0000, 0x0000, 0x6cfb, 0x0000, 0x0000,
 0x0000, 0x6cfd, 0x6d01, 0x0000, 0x0000, 0x6d10, 0x0000, 0x0000, 0x6d11, 0x0000,
 0x6d12, 0x0000, 0x0000, 0x0000, 0x6d1b, 0x6d1e, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6d25, 0x0000, 0x6d26, 0x0000,
 0x6d29, 0x0000, 0x6d2b, 0x6d32, 0x0000, 0x0000, 0x0000, 0x0000, 0x6d38, 0x6d3b,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6d3c, 0x6d3d,
 0x0000, 0x0000, 0x0000, 0x6d3f, 0x0000, 0x6d41, 0x6d47, 0x0000, 0x6d48, 0x6d49,
 0x0000, 0x6d4d, 0x0000, 0x6d4f, 0x6d93, 0x6d94, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x6d98, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6d9a, 0x6d9b,
 0x0000, 0x0000, 0x6d9d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x6d9f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6da2, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x6da5, 0x6da6, 0x6da8, 0x0000, 0x6da9, 0x0000,
 0x0000, 0x6daa, 0x0000, 0x0000, 0x0000, 0x0000, 0x6dab, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x6dae, 0x0000, 0x0000, 0x0000, 0x0000, 0x6db5,
 0x0000, 0x0000, 0x0000, 0x0000, 0x6db6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x6db8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x6dba, 0x0000, 0x6dc1, 0x6dd2, 0x6dd3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x6dd4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6dd6, 0x0000,
 0x6de1, 0x0000, 0x6de3, 0x0000, 0x0000, 0x6de7, 0x0000, 0x0000, 0x0000, 0x6dec,
 0x6ded, 0x0000, 0x0000, 0x0000, 0x6df2, 0x0000, 0x0000, 0x0000, 0x0000, 0x6df8,
 0x0000, 0x0000, 0x0000, 0x0000, 0x6dfb, 0x6dfd, 0x6e01, 0x0000, 0x0000, 0x0000,
 0x0000, 0x6e06, 0x0000, 0x6e07, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6e0c, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x6e0d, 0x0000, 0x0000, 0x6e0f, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6e12, 0x6e1c, 0x0000, 0x6e1e, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x6e1f, 0x0000, 0x6e21, 0x6e2e, 0x0000, 0x0000,
 0x6e2f, 0x6e31, 0x0000, 0x6e33, 0x0000, 0x6e35, 0x0000, 0x0000, 0x0000, 0x6e37,
 0x6e38, 0x6e39, 0x0000, 0x6e3e, 0x0000, 0x6e3f, 0x6e41, 0x0000, 0x0000, 0x0000,
 0x6e42, 0x0000, 0x6e43, 0x6e45, 0x6e48, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x6e4b, 0x0000, 0x6e51, 0x0000, 0x0000, 0x6e52,
 0x0000, 0x0000, 0x0000, 0x0000, 0x6e53, 0x0000, 0x0000, 0x0000, 0x6e55, 0x0000,
 0x0000, 0x0000, 0x6e58, 0x6e5a, 0x0000, 0x6e5b, 0x6e5c, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x6e5d, 0x0000, 0x0000, 0x6e5e, 0x6e5f, 0x0000, 0x0000,
 0x6e60, 0x0000, 0x0000, 0x6e62, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6e63,
 0x0000, 0x0000, 0x6e64, 0x0000, 0x0000, 0x6e65, 0x0000, 0x0000, 0x0000, 0x0000,
 0x6e66, 0x6e67, 0x0000, 0x0000, 0x6e68, 0x0000, 0x0000, 0x0000, 0x6e6a, 0x0000,
 0x6e6c, 0x6e6d, 0x0000, 0x6e6e, 0x6e70, 0x6e72, 0x0000, 0x6e75, 0x6e76, 0x0000,
 0x0000, 0x0000, 0x6e77, 0x0000, 0x6e78, 0x6e79, 0x6e7b, 0x0000, 0x6e84, 0x0000,
 0x6e86, 0x0000, 0x6e89, 0x0000, 0x0000, 0x0000, 0x0000, 0x6e8b, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x6e8c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x6e8d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6e8e, 0x6e8f, 0x0000, 0x0000, 0x0000,
 0x0000, 0x6e90, 0x0000, 0x0000, 0x6e91, 0x0000, 0x6e98, 0x0000, 0x6e99, 0x6e9a,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6e9b, 0x0000, 0x0000, 0x0000,
 0x6ea0, 0x6ea1, 0x0000, 0x0000, 0x6ea8, 0x0000, 0x0000, 0x0000, 0x6ea9, 0x6eb2,
 0x0000, 0x6eb3, 0x0000, 0x0000, 0x6eb8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x6ebb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x6ebc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6efb, 0x0000,
 0x6efc, 0x6efd, 0x0000, 0x6f00, 0x0000, 0x0000, 0x0000, 0x6f04, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x6f05, 0x0000, 0x0000, 0x0000, 0x0000, 0x6f07, 0x0000,
 0x0000, 0x0000, 0x6f08, 0x0000, 0x0000, 0x6f0c, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x6f0d, 0x0000, 0x0000, 0x0000, 0x6f0f, 0x6f12, 0x0000, 0x6f2a, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x6f30, 0x0000, 0x0000, 0x0000, 0x0000, 0x6f31, 0x0000, 0x6f33, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x6f37, 0x0000, 0x0000, 0x0000, 0x0000, 0x6f3a,
 0x0000, 0x6f40, 0x0000, 0x6f41, 0x0000, 0x0000, 0x6f45, 0x0000, 0x0000, 0x0000,
 0x0000, 0x6f46, 0x6f48, 0x0000, 0x0000, 0x6f49, 0x0000, 0x0000, 0x0000, 0x0000,
 0x6f4c, 0x0000, 0x0000, 0x0000, 0x6f4f, 0x0000, 0x6f51, 0x0000, 0x6f53, 0x0000,
 0x0000, 0x0000, 0x0000, 0x6f54, 0x0000, 0x0000, 0x6f56, 0x6f57, 0x0000, 0x0000,
 0x0000, 0x6f5c, 0x0000, 0x0000, 0x0000, 0x6f5e, 0x0000, 0x0000, 0x6f60, 0x6f61,
 0x6f62, 0x6f69, 0x0000, 0x6f6e, 0x0000, 0x6f6f, 0x6f70, 0x0000, 0x0000, 0x0000,
 0x0000, 0x6f71, 0x0000, 0x0000, 0x6f74, 0x0000, 0x0000, 0x6f79, 0x6f7a, 0x0000,
 0x0000, 0x0000, 0x6f7b, 0x0000, 0x6f84, 0x0000, 0x6f89, 0x6f8a, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x6f90, 0x6f93, 0x0000, 0x0000, 0x6f94, 0x0000, 0x0000, 0x0000, 0x0000, 0x6f95,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6f96, 0x6f98, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6f99, 0x0000, 0x0000, 0x0000, 0x6f9a,
 0x0000, 0x6f9c, 0x6f9d, 0x0000, 0x0000, 0x0000, 0x0000, 0x6f9f, 0x0000, 0x0000,
 0x0000, 0x0000, 0x6fa0, 0x6fa5, 0x6fac, 0x0000, 0x0000, 0x6fad, 0x0000, 0x0000,
 0x0000, 0x6fae, 0x6fb3, 0x0000, 0x6fb6, 0x0000, 0x0000, 0x6fb9, 0x0000, 0x0000,
 0x6fbd, 0x0000, 0x0000, 0x0000, 0x0000, 0x6fc6, 0x6fc7, 0x6fcb, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x6fcc, 0x0000, 0x6fd2, 0x0000, 0x0000, 0x6fd4,
 0x0000, 0x6fd7, 0x0000, 0x6fd8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x6fdb, 0x0000, 0x0000, 0x0000, 0x6fdd, 0x6fde, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6fdf, 0x0000, 0x6fe3,
 0x0000, 0x0000, 0x6fec, 0x0000, 0x0000, 0x0000, 0x6ff6, 0x0000, 0x6ffe, 0x6fff,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7000,
 0x7001, 0x7003, 0x7004, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x7013, 0x0000, 0x0000, 0x0000, 0x7017, 0x0000, 0x0000, 0x0000, 0x7018, 0x0000,
 0x7019, 0x701a, 0x0000, 0x7021, 0x0000, 0x7023, 0x7024, 0x7026, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7027, 0x7038, 0x0000, 0x0000, 0x0000,
 0x7040, 0x0000, 0x0000, 0x0000, 0x7041, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x7042, 0x0000, 0x7043, 0x0000, 0x7045, 0x0000,
 0x0000, 0x7046, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x7049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x704d, 0x704e, 0x7050, 0x7052, 0x7054, 0x0000, 0x7055, 0x0000, 0x0000, 0x0000,
 0x0000, 0x7057, 0x7058, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x705a,
 0x0000, 0x0000, 0x0000, 0x705c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x705e, 0x0000, 0x705f, 0x7060, 0x0000, 0x0000, 0x0000, 0x0000, 0x7061, 0x7062,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x7063, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7064,
 0x0000, 0x7065, 0x0000, 0x706e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x7070, 0x0000, 0x7071, 0x0000, 0x7072, 0x0000, 0x0000, 0x0000, 0x7073, 0x0000,
 0x0000, 0x0000, 0x707d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x707f,
 0x0000, 0x0000, 0x7081, 0x0000, 0x0000, 0x0000, 0x0000, 0x7082, 0x0000, 0x7085,
 0x0000, 0x0000, 0x7086, 0x0000, 0x0000, 0x7087, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x7088, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x708a,
 0x708c, 0x0000, 0x0000, 0x7090, 0x7093, 0x0000, 0x0000, 0x7095, 0x0000, 0x709a,
 0x0000, 0x0000, 0x0000, 0x70aa, 0x70b4, 0x0000, 0x0000, 0x70b5, 0x0000, 0x70b6,
 0x70b7, 0x0000, 0x0000, 0x0000, 0x70b9, 0x0000, 0x0000, 0x0000, 0x70ba, 0x0000,
 0x70c3, 0x70c4, 0x70c5, 0x0000, 0x0000, 0x0000, 0x70ca, 0x70d0, 0x70d2, 0x70da,
 0x70dc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x70df, 0x0000,
 0x0000, 0x0000, 0x70e2, 0x70e3, 0x0000, 0x0000, 0x0000, 0x70e4, 0x0000, 0x0000,
 0x70e8, 0x0000, 0x70ea, 0x0000, 0x0000, 0x0000, 0x0000, 0x70eb, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x70ec, 0x0000, 0x0000, 0x0000, 0x70ee, 0x0000,
 0x70f2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x70f3, 0x70f4,
 0x70f7, 0x0000, 0x0000, 0x70f8, 0x0000, 0x70f9, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x70fc, 0x0000, 0x0000, 0x0000, 0x0000, 0x70fe,
 0x7101, 0x0000, 0x0000, 0x0000, 0x7102, 0x0000, 0x7108, 0x0000, 0x710b, 0x0000,
 0x0000, 0x0000, 0x0000, 0x710e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x711c, 0x0000, 0x0000, 0x0000, 0x7126, 0x0000, 0x0000, 0x0000, 0x0000, 0x7127,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7128,
 0x0000, 0x712b, 0x0000, 0x712f, 0x7130, 0x0000, 0x7136, 0x7137, 0x0000, 0x0000,
 0x7138, 0x713d, 0x7144, 0x7145, 0x7146, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x7147, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7148, 0x0000, 0x7149,
 0x0000, 0x0000, 0x0000, 0x7151, 0x0000, 0x0000, 0x7153, 0x0000, 0x0000, 0x715d,
 0x0000, 0x0000, 0x0000, 0x0000, 0x7160, 0x0000, 0x7161, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x7162, 0x0000, 0x0000, 0x0000, 0x716c, 0x0000, 0x0000, 0x0000,
 0x716d, 0x0000, 0x0000, 0x0000, 0x0000, 0x716e, 0x0000, 0x7175, 0x0000, 0x7177,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x717b,
 0x0000, 0x0000, 0x0000, 0x717e, 0x7180, 0x7186, 0x0000, 0x718e, 0x719a, 0x0000,
 0x0000, 0x0000, 0x719b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x719c,
 0x0000, 0x0000, 0x0000, 0x0000, 0x719d, 0x71a0, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x71a2, 0x71a9, 0x0000, 0x0000, 0x0000, 0x71af, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x71b1, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x71b3, 0x0000, 0x71b5, 0x0000, 0x0000, 0x0000, 0x71bb,
 0x0000, 0x0000, 0x71c0, 0x0000, 0x0000, 0x71d2, 0x71d4, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x71e0, 0x0000, 0x71e8, 0x71f6,
 0x0000, 0x71f8, 0x0000, 0x0000, 0x71fc, 0x0000, 0x71fd, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x722c, 0x0000, 0x0000, 0x722d, 0x0000,
 0x0000, 0x722e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x7232, 0x0000, 0x0000, 0x0000, 0x7239, 0x0000, 0x723d, 0x0000,
 0x7240, 0x0000, 0x7242, 0x7248, 0x7260, 0x0000, 0x7262, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x7265, 0x0000, 0x0000, 0x7266, 0x726b, 0x726c, 0x0000, 0x0000,
 0x0000, 0x0000, 0x726e, 0x0000, 0x726f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x7270, 0x7271, 0x7272, 0x7274, 0x0000, 0x7276, 0x0000, 0x0000, 0x7278, 0x727b,
 0x0000, 0x7280, 0x0000, 0x0000, 0x0000, 0x728a, 0x0000, 0x0000, 0x728b, 0x0000,
 0x0000, 0x728c, 0x728e, 0x7290, 0x0000, 0x7297, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x729a, 0x729b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x729d, 0x729f, 0x0000, 0x0000, 0x0000, 0x0000, 0x72a0, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x72a1, 0x0000, 0x0000, 0x0000, 0x0000, 0x72a2, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x72a3, 0x72a4, 0x72a5, 0x0000, 0x0000, 0x72aa,
 0x0000, 0x0000, 0x72ab, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x72ad, 0x0000, 0x0000, 0x0000, 0x0000, 0x72b4, 0x0000, 0x72b5, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x72b6, 0x0000, 0x0000, 0x72b8,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x72c2, 0x0000,
 0x72c5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x72ca,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x72cd, 0x0000, 0x0000, 0x0000,
 0x72ce, 0x0000, 0x0000, 0x72cf, 0x72d5, 0x0000, 0x72d6, 0x72e4, 0x72e6, 0x72ea,
 0x72eb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x72ec, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x72ef, 0x0000, 0x0000, 0x0000,
 0x72fb, 0x0000, 0x0000, 0x0000, 0x72fd, 0x0000, 0x0000, 0x72ff, 0x0000, 0x7301,
 0x0000, 0x0000, 0x0000, 0x0000, 0x7303, 0x0000, 0x7306, 0x730a, 0x730c, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x7310, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x7315, 0x0000, 0x0000, 0x0000, 0x7318, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x731c, 0x0000, 0x7321, 0x0000, 0x0000, 0x0000, 0x732e,
 0x0000, 0x0000, 0x0000, 0x7332, 0x0000, 0x0000, 0x0000, 0x7333, 0x7334, 0x0000,
 0x0000, 0x7339, 0x0000, 0x0000, 0x0000, 0x733a, 0x0000, 0x733b, 0x0000, 0x733e,
 0x7341, 0x0000, 0x7345, 0x0000, 0x0000, 0x0000, 0x7346, 0x0000, 0x0000, 0x0000,
 0x7348, 0x0000, 0x0000, 0x0000, 0x734c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x734e, 0x0000, 0x734f, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x7350, 0x7351, 0x7359, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x735a, 0x0000, 0x0000, 0x735b, 0x7362, 0x0000, 0x7364, 0x0000,
 0x0000, 0x0000, 0x7366, 0x0000, 0x7367, 0x7368, 0x736b, 0x0000, 0x0000, 0x736c,
 0x0000, 0x0000, 0x0000, 0x736d, 0x0000, 0x0000, 0x0000, 0x736e, 0x0000, 0x0000,
 0x7370, 0x0000, 0x0000, 0x0000, 0x0000, 0x7376, 0x7379, 0x0000, 0x737a, 0x737c,
 0x0000, 0x0000, 0x737d, 0x0000, 0x0000, 0x737e, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x738a, 0x7390, 0x7392, 0x7397,
 0x0000, 0x0000, 0x0000, 0x0000, 0x7399, 0x739a, 0x0000, 0x0000, 0x739d, 0x0000,
 0x0000, 0x73ad, 0x0000, 0x73ae, 0x0000, 0x73af, 0x0000, 0x0000, 0x0000, 0x0000,
 0x73b0, 0x73b1, 0x0000, 0x0000, 0x73b9, 0x0000, 0x0000, 0x0000, 0x73c0, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x73c1, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x73c2, 0x73c3, 0x73c5, 0x0000, 0x73c6, 0x0000, 0x73c9, 0x73cb,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x73cc, 0x0000, 0x73cd, 0x0000,
 0x73d1, 0x0000, 0x0000, 0x0000, 0x73d2, 0x0000, 0x73d5, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x73d8, 0x73db, 0x0000, 0x0000, 0x73dc, 0x0000, 0x0000, 0x0000, 0x73dd,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x73e0, 0x0000, 0x0000, 0x0000, 0x73e7,
 0x73e9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x73eb, 0x0000,
 0x73ed, 0x73ef, 0x0000, 0x0000, 0x73f4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x73f5, 0x0000, 0x0000, 0x0000, 0x73f7, 0x0000, 0x0000, 0x0000, 0x73f8, 0x0000,
 0x73f9, 0x73fa, 0x7404, 0x0000, 0x7405, 0x0000, 0x0000, 0x0000, 0x7406, 0x0000,
 0x740a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7418, 0x0000,
 0x7419, 0x0000, 0x741f, 0x0000, 0x7425, 0x7426, 0x0000, 0x7436, 0x7441, 0x0000,
 0x7443, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7444, 0x0000, 0x0000, 0x7445,
 0x0000, 0x0000, 0x0000, 0x744b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x744c, 0x0000, 0x0000, 0x0000,
 0x744d, 0x744e, 0x744f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x747e, 0x0000, 0x0000, 0x0000, 0x7480, 0x0000,
 0x7481, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7483, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7485, 0x0000, 0x7488, 0x748a, 0x0000,
 0x0000, 0x748b, 0x0000, 0x0000, 0x748d, 0x748e, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x7493, 0x0000, 0x0000, 0x0000, 0x0000, 0x7494,
 0x7495, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x7499, 0x0000, 0x0000, 0x74ad, 0x74b0, 0x74c2, 0x74d1, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x74d3, 0x74e1, 0x0000, 0x74e2, 0x0000, 0x0000, 0x74e3, 0x74e6,
 0x74f8, 0x74fa, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x74fb,
 0x74fc, 0x0000, 0x0000, 0x0000, 0x74ff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x7501, 0x0000, 0x0000, 0x7504, 0x0000, 0x7505, 0x0000, 0x0000, 0x750a, 0x0000,
 0x0000, 0x0000, 0x0000, 0x7513, 0x0000, 0x0000, 0x0000, 0x7514, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x751a, 0x0000, 0x751b, 0x7528, 0x7537, 0x7538, 0x753a,
 0x0000, 0x0000, 0x0000, 0x753d, 0x0000, 0x0000, 0x0000, 0x0000, 0x753e, 0x7540,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x7541, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7547, 0x754f, 0x0000,
 0x0000, 0x7551, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x7552, 0x0000, 0x7556, 0x0000, 0x7557, 0x0000, 0x7558, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7573, 0x7574, 0x0000, 0x0000, 0x0000,
 0x7575, 0x0000, 0x7578, 0x0000, 0x0000, 0x0000, 0x7579, 0x0000, 0x0000, 0x0000,
 0x0000, 0x757b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x757f, 0x0000,
 0x0000, 0x7580, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7582, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7584,
 0x758a, 0x0000, 0x0000, 0x758b, 0x0000, 0x0000, 0x0000, 0x0000, 0x7592, 0x75a6,
 0x0000, 0x75a7, 0x0000, 0x75a9, 0x75b2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x75b3, 0x75b4,
 0x75b5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x75b7, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x75b8,
 0x0000, 0x0000, 0x75b9, 0x75ba, 0x0000, 0x0000, 0x0000, 0x75bb, 0x75c2, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x75c3, 0x0000, 0x0000, 0x75c4, 0x75c7, 0x0000,
 0x0000, 0x0000, 0x75d8, 0x0000, 0x75dc, 0x75dd, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x75e4, 0x75e5, 0x0000, 0x75f0, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x75f2, 0x75f4, 0x0000, 0x0000, 0x75f7,
 0x0000, 0x0000, 0x75fa, 0x0000, 0x0000, 0x0000, 0x0000, 0x75fb, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7605, 0x0000,
 0x0000, 0x0000, 0x7608, 0x0000, 0x0000, 0x7609, 0x0000, 0x0000, 0x0000, 0x760a,
 0x0000, 0x0000, 0x0000, 0x0000, 0x760b, 0x0000, 0x760c, 0x0000, 0x760e, 0x7613,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7617, 0x0000, 0x0000, 0x7619, 0x761b,
 0x0000, 0x0000, 0x0000, 0x0000, 0x761e, 0x0000, 0x7620, 0x7623, 0x7625, 0x0000,
 0x762a, 0x762c, 0x0000, 0x0000, 0x0000, 0x763d, 0x0000, 0x0000, 0x763f, 0x7640,
 0x0000, 0x0000, 0x0000, 0x7646, 0x7648, 0x0000, 0x0000, 0x764a, 0x0000, 0x764c,
 0x0000, 0x7656, 0x0000, 0x0000, 0x0000, 0x0000, 0x7657, 0x7658, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x765a, 0x765b, 0x765e, 0x7660, 0x7662, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x766c, 0x766d, 0x0000, 0x0000, 0x0000, 0x766e,
 0x0000, 0x0000, 0x0000, 0x766f, 0x0000, 0x7670, 0x7672, 0x7676, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x7677, 0x0000, 0x767c, 0x768c, 0x768d, 0x0000, 0x0000,
 0x7694, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7695,
 0x0000, 0x7696, 0x0000, 0x7697, 0x7698, 0x0000, 0x0000, 0x769d, 0x769e, 0x76aa,
 0x0000, 0x0000, 0x0000, 0x0000, 0x76ab, 0x0000, 0x0000, 0x76ad, 0x0000, 0x76b1,
 0x0000, 0x76b4, 0x76bd, 0x0000, 0x0000, 0x0000, 0x76c1, 0x0000, 0x0000, 0x0000,
 0x0000, 0x76c3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x76c4, 0x0000, 0x0000,
 0x76c5, 0x0000, 0x76c6, 0x76c8, 0x0000, 0x76c9, 0x0000, 0x76ca, 0x0000, 0x0000,
 0x0000, 0x76d1, 0x0000, 0x0000, 0x76d2, 0x76d3, 0x0000, 0x76d4, 0x0000, 0x76d8,
 0x0000, 0x0000, 0x0000, 0x76db, 0x76de, 0x76e0, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x76e1, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x76e4, 0x0000, 0x76e5, 0x76e6, 0x0000, 0x76e9, 0x76ea,
 0x0000, 0x0000, 0x0000, 0x76ed, 0x0000, 0x0000, 0x0000, 0x0000, 0x76f4, 0x76f8,
 0x76f9, 0x0000, 0x0000, 0x0000, 0x76fa, 0x0000, 0x7700, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x7703, 0x0000, 0x7705, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x770d, 0x0000, 0x0000, 0x7714, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x7715, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7716, 0x7717, 0x7721, 0x7722,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x7729, 0x0000, 0x772c, 0x0000, 0x0000, 0x0000, 0x772d, 0x772e, 0x0000, 0x7732,
 0x7734, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x773b, 0x0000, 0x773c, 0x0000, 0x773d, 0x0000, 0x0000, 0x0000,
 0x0000, 0x7749, 0x0000, 0x0000, 0x774a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x7759, 0x0000, 0x0000, 0x775b, 0x775c, 0x775e, 0x775f, 0x7760, 0x0000, 0x0000,
 0x7761, 0x0000, 0x7762, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x7763, 0x776a, 0x776b, 0x0000, 0x777a, 0x777b, 0x0000, 0x0000, 0x777e,
 0x0000, 0x0000, 0x7782, 0x0000, 0x0000, 0x0000, 0x0000, 0x7793, 0x7794, 0x779f,
 0x77aa, 0x0000, 0x0000, 0x77ac, 0x77b0, 0x77bf, 0x77c0, 0x0000, 0x77c1, 0x0000,
 0x0000, 0x77c2, 0x77cd, 0x0000, 0x77ce, 0x0000, 0x77d4, 0x77d6, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x77d7, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x77e7, 0x0000, 0x0000,
 0x77ea, 0x0000, 0x0000, 0x0000, 0x0000, 0x77ec, 0x0000, 0x0000, 0x0000, 0x0000,
 0x77ed, 0x0000, 0x77ee, 0x77ef, 0x0000, 0x0000, 0x0000, 0x0000, 0x77f3, 0x0000,
 0x0000, 0x0000, 0x77f5, 0x0000, 0x0000, 0x77f6, 0x77ff, 0x7809, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x780b, 0x0000, 0x0000,
 0x780d, 0x0000, 0x0000, 0x0000, 0x780e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x7810, 0x7811, 0x0000, 0x0000, 0x0000, 0x7814, 0x0000, 0x0000, 0x0000, 0x7817,
 0x0000, 0x781a, 0x0000, 0x781b, 0x781c, 0x0000, 0x0000, 0x781f, 0x7820, 0x7821,
 0x0000, 0x0000, 0x0000, 0x7822, 0x0000, 0x0000, 0x7828, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x782b, 0x0000, 0x782c, 0x0000, 0x0000, 0x782e,
 0x0000, 0x7831, 0x7832, 0x7833, 0x7836, 0x7839, 0x0000, 0x0000, 0x783b, 0x783c,
 0x783d, 0x0000, 0x0000, 0x0000, 0x0000, 0x7846, 0x0000, 0x0000, 0x0000, 0x7848,
 0x0000, 0x0000, 0x0000, 0x0000, 0x785a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x785c, 0x7863, 0x0000, 0x0000, 0x7867, 0x7868, 0x0000, 0x7869,
 0x0000, 0x786b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x786c, 0x0000,
 0x0000, 0x786e, 0x0000, 0x0000, 0x0000, 0x7872, 0x0000, 0x7873, 0x0000, 0x7875,
 0x7876, 0x0000, 0x787d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x787e, 0x787f,
 0x0000, 0x0000, 0x7881, 0x0000, 0x7883, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x7884, 0x788a, 0x0000, 0x0000, 0x788b, 0x0000, 0x7891, 0x0000, 0x0000, 0x7892,
 0x0000, 0x0000, 0x7894, 0x0000, 0x0000, 0x7895, 0x0000, 0x0000, 0x0000, 0x78a1,
 0x78a3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x78a9, 0x0000, 0x78ab, 0x0000,
 0x0000, 0x0000, 0x0000, 0x78ae, 0x0000, 0x78af, 0x0000, 0x78b1, 0x0000, 0x78b2,
 0x0000, 0x0000, 0x0000, 0x78b8, 0x78ba, 0x0000, 0x78bd, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x78be, 0x0000, 0x0000, 0x0000, 0x78c3, 0x78d5, 0x78de,
 0x0000, 0x0000, 0x0000, 0x0000, 0x78df, 0x0000, 0x0000, 0x78e1, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x78e2, 0x0000, 0x0000, 0x78e3, 0x0000, 0x0000,
 0x78eb, 0x78ec, 0x0000, 0x0000, 0x78f0, 0x0000, 0x0000, 0x78f1, 0x78f2, 0x78f6,
 0x0000, 0x0000, 0x78f9, 0x78fe, 0x0000, 0x0000, 0x0000, 0x7900, 0x0000, 0x0000,
 0x7901, 0x0000, 0x7902, 0x7906, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x7912, 0x7913, 0x7916, 0x0000, 0x7918, 0x0000, 0x0000, 0x7919, 0x0000,
 0x0000, 0x791b, 0x791d, 0x0000, 0x0000, 0x791e, 0x7923, 0x0000, 0x0000, 0x7926,
 0x0000, 0x7928, 0x0000, 0x0000, 0x0000, 0x0000, 0x792a, 0x0000, 0x0000, 0x792c,
 0x792f, 0x7930, 0x7931, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7933, 0x7934, 0x7935,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7938, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x793c, 0x793d,
 0x793e, 0x0000, 0x0000, 0x0000, 0x7941, 0x7943, 0x7945, 0x0000, 0x7947, 0x0000,
 0x0000, 0x0000, 0x7948, 0x0000, 0x7949, 0x0000, 0x0000, 0x0000, 0x794d, 0x794e,
 0x794f, 0x0000, 0x0000, 0x7957, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x795a,
 0x0000, 0x795c, 0x795f, 0x0000, 0x0000, 0x0000, 0x7960, 0x7961, 0x0000, 0x0000,
 0x0000, 0x0000, 0x7963, 0x0000, 0x0000, 0x7964, 0x0000, 0x0000, 0x0000, 0x7965,
 0x7967, 0x0000, 0x7968, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x796f, 0x0000, 0x79a6, 0x0000, 0x79a8, 0x0000, 0x0000,
 0x79a9, 0x79aa, 0x79ab, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x79ad, 0x0000, 0x79af,
 0x79b0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x79ba, 0x79c3,
 0x79c6, 0x79c7, 0x0000, 0x0000, 0x0000, 0x79c8, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x79cb, 0x0000, 0x0000, 0x0000, 0x79d2, 0x0000, 0x0000,
 0x0000, 0x79d8, 0x79db, 0x0000, 0x0000, 0x79dc, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x79de, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x79df, 0x0000, 0x0000, 0x0000, 0x79e5, 0x0000, 0x0000, 0x0000, 0x0000, 0x79eb,
 0x79ef, 0x0000, 0x0000, 0x0000, 0x0000, 0x79ff, 0x0000, 0x7a00, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7a01, 0x7a04,
 0x7a15, 0x0000, 0x7a16, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7a17,
 0x0000, 0x0000, 0x7a19, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x7a1a, 0x7a1b, 0x0000, 0x0000, 0x7a1c, 0x0000, 0x7a1d, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x7a1e, 0x7a1f, 0x0000, 0x0000, 0x7a20, 0x0000,
 0x7a22, 0x0000, 0x7a23, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7a31, 0x0000,
 0x7a32, 0x0000, 0x7a34, 0x0000, 0x0000, 0x7a35, 0x7a37, 0x7a38, 0x0000, 0x0000,
 0x7a3a, 0x0000, 0x0000, 0x0000, 0x7a3c, 0x7a3f, 0x0000, 0x7a43, 0x0000, 0x7a44,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7a46, 0x0000, 0x0000, 0x0000, 0x0000,
 0x7a47, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7a48, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x7a49, 0x7a4c, 0x7a4d, 0x7a53, 0x0000, 0x7a55, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x7a5b, 0x0000, 0x7a5c, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x7a5d, 0x7a5f, 0x0000, 0x0000, 0x7a63, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x7a65, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7a68, 0x0000,
 0x0000, 0x7a69, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7a6a, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x7a6b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7a6e,
 0x0000, 0x0000, 0x0000, 0x0000, 0x7a71, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x7a73, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x7a74, 0x0000, 0x0000, 0x7a76, 0x7a77, 0x0000, 0x7a78, 0x0000, 0x0000, 0x7a7a,
 0x0000, 0x0000, 0x0000, 0x0000, 0x7a7b, 0x0000, 0x0000, 0x7a7c, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7a83, 0x0000,
 0x7a8c, 0x0000, 0x0000, 0x7a8d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x7a90, 0x0000, 0x7a9c, 0x0000, 0x7a9d, 0x0000, 0x7aa0,
 0x0000, 0x7aa9, 0x0000, 0x7aad, 0x7aaf, 0x7ab0, 0x0000, 0x7ab1, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x7ab5, 0x7ab7, 0x0000, 0x0000, 0x0000, 0x7ab8,
 0x7aba, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7abe, 0x7abf, 0x0000,
 0x0000, 0x7ac0, 0x0000, 0x7ac1, 0x7ac8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x7ac9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x7aca, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x7acb, 0x0000, 0x0000, 0x0000, 0x0000, 0x7ace, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x7ad2, 0x0000, 0x7ad4, 0x0000, 0x7ad8, 0x0000,
 0x0000, 0x7adb, 0x0000, 0x0000, 0x0000, 0x0000, 0x7adc, 0x0000, 0x7ae5, 0x7ae9,
 0x0000, 0x0000, 0x7aea, 0x0000, 0x0000, 0x7aeb, 0x0000, 0x0000, 0x7aec, 0x0000,
 0x0000, 0x0000, 0x7aed, 0x7af1, 0x0000, 0x7af4, 0x0000, 0x0000, 0x0000, 0x0000,
 0x7b01, 0x7b02, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7b04,
 0x7b05, 0x7b06, 0x0000, 0x0000, 0x0000, 0x0000, 0x7b0d, 0x7b10, 0x7b11, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7b15, 0x0000,
 0x0000, 0x0000, 0x0000, 0x7b16, 0x0000, 0x0000, 0x7b17, 0x0000, 0x0000, 0x7b19,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7b1a,
 0x0000, 0x7b22, 0x7b30, 0x7b33, 0x7b34, 0x0000, 0x7b35, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x7b3a, 0x7b41, 0x7b47, 0x0000, 0x0000, 0x0000, 0x7b48,
 0x7b49, 0x7b4a, 0x0000, 0x0000, 0x7b4c, 0x7b4f, 0x0000, 0x7b51, 0x0000, 0x0000,
 0x0000, 0x7b52, 0x0000, 0x0000, 0x0000, 0x0000, 0x7b53, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x7b54, 0x7b56, 0x7b5c, 0x7b5d, 0x0000, 0x0000, 0x7b5e,
 0x7b60, 0x7b61, 0x7b62, 0x7b6b, 0x0000, 0x7b6c, 0x0000, 0x0000, 0x0000, 0x0000,
 0x7b6d, 0x0000, 0x7b6f, 0x0000, 0x7b70, 0x7b71, 0x0000, 0x0000, 0x7b73, 0x7b74,
 0x0000, 0x0000, 0x7b78, 0x7b7a, 0x0000, 0x0000, 0x0000, 0x7b7b, 0x0000, 0x7b7f,
 0x0000, 0x0000, 0x0000, 0x0000, 0x7b80, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x7b81, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7b82, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x7b85, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x7b86, 0x7b89, 0x0000, 0x0000, 0x0000, 0x0000,
 0x7b8b, 0x0000, 0x7b99, 0x0000, 0x0000, 0x7b9a, 0x0000, 0x0000, 0x7b9b, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7b9c, 0x0000,
 0x7b9e, 0x0000, 0x0000, 0x0000, 0x0000, 0x7ba0, 0x0000, 0x0000, 0x0000, 0x7ba4,
 0x0000, 0x0000, 0x0000, 0x7ba9, 0x0000, 0x0000, 0x7bbc, 0x0000, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0000, 0x0000, 0x7bc9, 0x7bcb, 0x7bcc, 0x0000, 0x7bce, 0x0000,
 0x0000, 0x0000, 0x7bd0, 0x0000, 0x7bd6, 0x0000, 0x7bd7, 0x0000};

static const DictWord kStaticDictionaryWords[31705] = {
  {   0,  0,    0 }, {   8,  0, 1002 }, { 136,  0, 1015 }, {   4,  0,  683 },
  {   4, 10,  325 }, { 138, 10,  125 }, {   7, 11,  572 }, {   9, 11,  592 },
  {  11, 11,  680 }, {  11, 11,  842 }, {  11, 11,  924 }, {  12, 11,  356 },
  {  12, 11,  550 }, {  13, 11,  317 }, {  13, 11,  370 }, {  13, 11,  469 },
  {  13, 11,  471 }, {  14, 11,  397 }, {  18, 11,   69 }, { 146, 11,  145 },
  { 134,  0, 1265 }, { 136, 11,  534 }, { 134,  0, 1431 }, {  11,  0,  138 },
  { 140,  0,   40 }, {   4,  0,  155 }, {   7,  0, 1689 }, {   4, 10,  718 },
  { 135, 10, 1216 }, {   4,  0,  245 }, {   5,  0,  151 }, {   5,  0,  741 },
  {   6,  0, 1147 }, {   7,  0,  498 }, {   7,  0,  870 }, {   7,  0, 1542 },
  {  12,  0,  213 }, {  14,  0,   36 }, {  14,  0,  391 }, {  17,  0,  111 },
  {  18,  0,    6 }, {  18,  0,   46 }, {  18,  0,  151 }, {  19,  0,   36 },
  {  20,  0,   32 }, {  20,  0,   56 }, {  20,  0,   69 }, {  20,  0,  102 },
  {  21,  0,    4 }, {  22,  0,    8 }, {  22,  0,   10 }, {  22,  0,   14 },
  { 150,  0,   31 }, {   4,  0,  624 }, { 135,  0, 1752 }, {   5, 10,  124 },
  {   5, 10,  144 }, {   6, 10,  548 }, {   7, 10,   15 }, {   7, 10,  153 },
  { 137, 10,  629 }, {   6,  0,  503 }, {   9,  0,  586 }, {  13,  0,  468 },
  {  14,  0,   66 }, {  16,  0,   58 }, {   7, 10, 1531 }, {   8, 10,  416 },
  {   9, 10,  275 }, {  10, 10,  100 }, {  11, 10,  658 }, {  11, 10,  979 },
  {  12, 10,   86 }, {  14, 10,  207 }, {  15, 10,   20 }, { 143, 10,   25 },
  {   5,  0,  603 }, {   7,  0, 1212 }, {   9,  0,  565 }, {  14,  0,  301 },
  {   5, 10,  915 }, {   6, 10, 1783 }, {   7, 10,  211 }, {   7, 10, 1353 },
  {   9, 10,   83 }, {  10, 10,  376 }, {  10, 10,  431 }, {  11, 10,  543 },
  {  12, 10,  664 }, {  13, 10,  280 }, {  13, 10,  428 }, {  14, 10,  128 },
  {  17, 10,   52 }, { 145, 10,   81 }, {   4,  0,  492 }, { 133,  0,  451 },
  { 135,  0,  835 }, { 141,  0,   70 }, { 132,  0,  539 }, {   7, 11,  748 },
  { 139, 11,  700 }, {   7, 11, 1517 }, {  11, 11,  597 }, {  14, 11,   76 },
  {  14, 11,  335 }, { 148, 11,   33 }, {   6,  0,  113 }, { 135,  0,  436 },
  {   4, 10,  338 }, { 133, 10,  400 }, { 136,  0,  718 }, { 133, 11,  127 },
  { 133, 11,  418 }, {   6,  0, 1505 }, {   7,  0,  520 }, {   6, 11,  198 },
  {  11, 10,  892 }, { 140, 11,   83 }, {   4, 10,  221 }, {   5, 10,  659 },
  {   5, 10,  989 }, {   7, 10,  697 }, {   7, 10, 1211 }, { 138, 10,  284 },
  { 135,  0, 1070 }, {   5, 11,  276 }, {   6, 11,   55 }, { 135, 11, 1369 },
  { 134,  0, 1515 }, {   6, 11, 1752 }, { 136, 11,  726 }, { 138, 10,  507 },
  {  15,  0,   78 }, {   4, 10,  188 }, { 135, 10,  805 }, {   5, 10,  884 },
  { 139, 10,  991 }, { 133, 11,  764 }, { 134, 10, 1653 }, {   6, 11,  309 },
  {   7, 11,  331 }, { 138, 11,  550 }, { 135, 11, 1861 }, { 132, 11,  348 },
  { 135, 11,  986 }, { 135, 11, 1573 }, {  12,  0,  610 }, {  13,  0,  431 },
  { 144,  0,   59 }, {   9, 11,  799 }, { 140, 10,  166 }, { 134,  0, 1530 },
  { 132,  0,  750 }, { 132,  0,  307 }, { 133,  0,  964 }, {   6, 11,  194 },
  {   7, 11,  133 }, {  10, 11,  493 }, {  10, 11,  570 }, { 139, 11,  664 },
  {   5, 11,   24 }, {   5, 11,  569 }, {   6, 11,    3 }, {   6, 11,  119 },
  {   6, 11,  143 }, {   6, 11,  440 }, {   7, 11,  295 }, {   7, 11,  599 },
  {   7, 11, 1686 }, {   7, 11, 1854 }, {   8, 11,  424 }, {   9, 11,   43 },
  {   9, 11,  584 }, {   9, 11,  760 }, {  10, 11,  148 }, {  10, 11,  328 },
  {  11, 11,  159 }, {  11, 11,  253 }, {  11, 11,  506 }, {  12, 11,  487 },
  {  12, 11,  531 }, { 144, 11,   33 }, { 136, 10,  760 }, {   5, 11,   14 },
  {   5, 11,  892 }, {   6, 11,  283 }, {   7, 11,  234 }, { 136, 11,  537 },
  { 135, 11, 1251 }, {   4, 11,  126 }, {   8, 11,  635 }, { 147, 11,   34 },
  {   4, 11,  316 }, { 135, 11, 1561 }, {   6,  0,  999 }, {   6,  0, 1310 },
  { 137, 11,  861 }, {   4, 11,   64 }, {   5, 11,  352 }, {   5, 11,  720 },
  {   6, 11,  368 }, { 139, 11,  359 }, {   4,  0,   75 }, {   5,  0,  180 },
  {   6,  0,  500 }, {   7,  0,   58 }, {   7,  0,  710 }, {  10,  0,  645 },
  { 136, 10,  770 }, { 133,  0,  649 }, {   6,  0,  276 }, {   7,  0,  282 },
  {   7,  0,  879 }, {   7,  0,  924 }, {   8,  0,  459 }, {   9,  0,  599 },
  {   9,  0,  754 }, {  11,  0,  574 }, {  12,  0,  128 }, {  12,  0,  494 },
  {  13,  0,   52 }, {  13,  0,  301 }, {  15,  0,   30 }, { 143,  0,  132 },
  { 132,  0,  200 }, {   4, 10,   89 }, {   5, 10,  489 }, {   6, 10,  315 },
  {   7, 10,  553 }, {   7, 10, 1745 }, { 138, 10,  243 }, { 135, 11, 1050 },
  {   7,  0, 1621 }, {   6, 10, 1658 }, {   9, 10,    3 }, {  10, 10,  154 },
  {  11, 10,  641 }, {  13, 10,   85 }, {  13, 10,  201 }, { 141, 10,  346 },
  {   6, 11,  175 }, { 137, 11,  289 }, {   5, 11,  432 }, { 133, 11,  913 },
  {   6,  0,  225 }, { 137,  0,  211 }, {   7,  0,  718 }, {   8,  0,  687 },
  { 139,  0,  374 }, {   4, 10,  166 }, { 133, 10,  505 }, {   9,  0,  110 },
  { 134, 10, 1670 }, {   8,  0,   58 }, {   9,  0,  724 }, {  11,  0,  809 },
  {  13,  0,  113 }, { 145,  0,   72 }, {   6,  0,  345 }, {   7,  0, 1247 },
  { 144, 11,   82 }, {   5, 11,  931 }, { 134, 11, 1698 }, {   8,  0,  767 },
  {   8,  0,  803 }, {   9,  0,  301 }, { 137,  0,  903 }, { 139,  0,  203 },
  { 134,  0, 1154 }, {   7,  0, 1949 }, { 136,  0,  674 }, { 134,  0,  259 },
  { 135,  0, 1275 }, {   5, 11,  774 }, {   6, 11, 1637 }, {   6, 11, 1686 },
  { 134, 11, 1751 }, { 134,  0, 1231 }, {   7, 10,  445 }, {   8, 10,  307 },
  {   8, 10,  704 }, {  10, 10,   41 }, {  10, 10,  439 }, {  11, 10,  237 },
  {  11, 10,  622 }, { 140, 10,  201 }, { 136,  0,  254 }, {   6, 11,  260 },
  { 135, 11, 1484 }, { 139,  0,  277 }, { 135, 10, 1977 }, {   4, 10,  189 },
  {   5, 10,  713 }, {   6, 11,  573 }, { 136, 10,   57 }, { 138, 10,  371 },
  { 132, 10,  552 }, { 134, 11,  344 }, { 133,  0,  248 }, {   9,  0,  800 },
  {  10,  0,  693 }, {  11,  0,  482 }, {  11,  0,  734 }, {  11,  0,  789 },
  { 134, 11,  240 }, {   4,  0,  116 }, {   5,  0,   95 }, {   5,  0,  445 },
  {   7,  0, 1688 }, {   8,  0,   29 }, {   9,  0,  272 }, {  11,  0,  509 },
  {  11,  0,  915 }, {   4, 11,  292 }, {   4, 11,  736 }, {   5, 11,  871 },
  {   6, 11,  171 }, {   6, 11, 1689 }, {   7, 11, 1324 }, {   7, 11, 1944 },
  {   9, 11,  415 }, {   9, 11,  580 }, {  14, 11,  230 }, { 146, 11,   68 },
  {   7,  0,  490 }, {  13,  0,  100 }, { 143,  0,   75 }, { 135,  0, 1641 },
  { 133,  0,  543 }, {   7, 11,  209 }, {   8, 11,  661 }, {  10, 11,   42 },
  {  11, 11,   58 }, {  12, 11,   58 }, {  12, 11,  118 }, { 141, 11,   32 },
  {   5,  0,  181 }, {   8,  0,   41 }, {   6, 11,   63 }, { 135, 11,  920 },
  { 133,  0,  657 }, { 133, 11,  793 }, { 138,  0,  709 }, {   7,  0,   25 },
  {   8,  0,  202 }, { 138,  0,  536 }, {   5, 11,  665 }, { 135, 10, 1788 },
  { 145, 10,   49 }, {   9,  0,  423 }, { 140,  0,   89 }, {   5, 11,   67 },
  {   6, 11,   62 }, {   6, 11,  374 }, { 135, 11, 1391 }, {   8,  0,  113 },
  {   9,  0,  877 }, {  10,  0,  554 }, {  11,  0,   83 }, {  12,  0,  136 },
  {  19,  0,  109 }, {   9, 11,  790 }, { 140, 11,   47 }, { 138, 10,  661 },
  {   4,  0,  963 }, {  10,  0,  927 }, {  14,  0,  442 }, { 135, 10, 1945 },
  { 133,  0,  976 }, { 132,  0,  206 }, {   4, 11,  391 }, { 135, 11, 1169 },
  { 134,  0, 2002 }, {   6,  0,  696 }, { 134,  0, 1008 }, { 134,  0, 1170 },
  { 132, 11,  271 }, {   7,  0,   13 }, {   8,  0,  226 }, {  10,  0,  537 },
  {  11,  0,  570 }, {  11,  0,  605 }, {  11,  0,  799 }, {  11,  0,  804 },
  {  12,  0,   85 }, {  12,  0,  516 }, {  12,  0,  623 }, {  13,  0,  112 },
  {  13,  0,  361 }, {  14,  0,   77 }, {  14,  0,   78 }, {  17,  0,   28 },
  {  19,  0,  110 }, { 140, 11,  314 }, { 132,  0,  769 }, { 134,  0, 1544 },
  {   4,  0,  551 }, { 137,  0,  678 }, {   5, 10,   84 }, { 134, 10,  163 },
  {   9,  0,   57 }, {   9,  0,  459 }, {  10,  0,  425 }, {  11,  0,  119 },
  {  12,  0,  184 }, {  12,  0,  371 }, {  13,  0,  358 }, { 145,  0,   51 },
  {   5,  0,  188 }, {   5,  0,  814 }, {   8,  0,   10 }, {   9,  0,  421 },
  {   9,  0,  729 }, {  10,  0,  609 }, {  11,  0,  689 }, {   4, 11,  253 },
  {   5, 10,  410 }, {   5, 11,  544 }, {   7, 11,  300 }, { 137, 11,  340 },
  { 134,  0,  624 }, { 138, 11,  321 }, { 135,  0, 1941 }, {  18,  0,  130 },
  {   5, 10,  322 }, {   8, 10,  186 }, {   9, 10,  262 }, {  10, 10,  187 },
  { 142, 10,  208 }, {   5, 11,   53 }, {   5, 11,  541 }, {   6, 11,   94 },
  {   6, 11,  499 }, {   7, 11,  230 }, { 139, 11,  321 }, { 133, 10,  227 },
  {   4,  0,  378 }, {   4, 11,  920 }, {   5, 11,   25 }, {   5, 11,  790 },
  {   6, 11,  457 }, { 135, 11,  853 }, { 137,  0,  269 }, { 132,  0,  528 },
  { 134,  0, 1146 }, {   7, 10, 1395 }, {   8, 10,  486 }, {   9, 10,  236 },
  {   9, 10,  878 }, {  10, 10,  218 }, {  11, 10,   95 }, {  19, 10,   17 },
  { 147, 10,   31 }, {   7, 10, 2043 }, {   8, 10,  672 }, { 141, 10,  448 },
  { 134,  0, 1105 }, { 134,  0, 1616 }, { 134, 11, 1765 }, { 140, 11,  163 },
  {   5, 10,  412 }, { 133, 11,  822 }, { 132, 11,  634 }, {   6,  0,  656 },
  { 134, 11, 1730 }, { 134,  0, 1940 }, {   5,  0,  104 }, {   6,  0,  173 },
  { 135,  0, 1631 }, { 136, 10,  562 }, {   6, 11,   36 }, {   7, 11,  658 },
  {   8, 11,  454 }, { 147, 11,   86 }, {   5,  0,  457 }, { 134, 10, 1771 },
  {   7,  0,  810 }, {   8,  0,  138 }, {   8,  0,  342 }, {   9,  0,   84 },
  {  10,  0,  193 }, {  11,  0,  883 }, { 140,  0,  359 }, {   9,  0,  620 },
  { 135, 10, 1190 }, { 137, 10,  132 }, {   7, 11,  975 }, { 137, 11,  789 },
  {   6,  0,   95 }, {   6,  0, 1934 }, { 136,  0,  967 }, { 141, 11,  335 },
  {   6,  0,  406 }, {  10,  0,  409 }, {  10,  0,  447 }, {  11,  0,   44 },
  { 140,  0,  100 }, {   4, 10,  317 }, { 135, 10, 1279 }, { 132,  0,  477 },
  { 134,  0, 1268 }, {   6,  0, 1941 }, {   8,  0,  944 }, {   5, 10,   63 },
  { 133, 10,  509 }, { 132,  0,  629 }, { 132, 11,  104 }, {   4,  0,  246 },
  { 133,  0,  375 }, {   6,  0, 1636 }, { 132, 10,  288 }, { 135, 11, 1614 },
  {   9,  0,   49 }, {  10,  0,  774 }, {   8, 10,   89 }, {   8, 10,  620 },
  {  11, 10,  628 }, {  12, 10,  322 }, { 143, 10,  124 }, {   4,  0,  282 },
  {   7,  0, 1034 }, {  11,  0,  398 }, {  11,  0,  634 }, {  12,  0,    1 },
  {  12,  0,   79 }, {  12,  0,  544 }, {  14,  0,  237 }, {  17,  0,   10 },
  { 146,  0,   20 }, { 132,  0,  824 }, {   7, 11,   45 }, {   9, 11,  542 },
  {   9, 11,  566 }, { 138, 11,  728 }, {   5,  0,  118 }, {   5,  0,  499 },
  {   6,  0,  476 }, {   6,  0,  665 }, {   6,  0, 1176 }, {   6,  0, 1196 },
  {   7,  0,  600 }, {   7,  0,  888 }, { 135,  0, 1096 }, {   7,  0,  296 },
  {   7,  0,  596 }, {   8,  0,  560 }, {   8,  0,  586 }, {   9,  0,  612 },
  {  11,  0,  304 }, {  12,  0,   46 }, {  13,  0,   89 }, {  14,  0,  112 },
  { 145,  0,  122 }, {   5,  0,  894 }, {   6,  0, 1772 }, {   9,  0, 1009 },
  { 138, 10,  120 }, {   5, 11,  533 }, {   7, 11,  755 }, { 138, 11,  780 },
  { 151, 10,    1 }, {   6,  0, 1474 }, {   7, 11,   87 }, { 142, 11,  288 },
  { 139,  0,  366 }, { 137, 10,  461 }, {   7, 11,  988 }, {   7, 11, 1939 },
  {   9, 11,   64 }, {   9, 11,  502 }, {  12, 11,    7 }, {  12, 11,   34 },
  {  13, 11,   12 }, {  13, 11,  234 }, { 147, 11,   77 }, {   7,  0, 1599 },
  {   7,  0, 1723 }, {   8,  0,   79 }, {   8,  0,  106 }, {   8,  0,  190 },
  {   8,  0,  302 }, {   8,  0,  383 }, {   8,  0,  713 }, {   9,  0,  119 },
  {   9,  0,  233 }, {   9,  0,  419 }, {   9,  0,  471 }, {  10,  0,  181 },
  {  10,  0,  406 }, {  11,  0,   57 }, {  11,  0,   85 }, {  11,  0,  120 },
  {  11,  0,  177 }, {  11,  0,  296 }, {  11,  0,  382 }, {  11,  0,  454 },
  {  11,  0,  758 }, {  11,  0,  999 }, {  12,  0,   27 }, {  12,  0,   98 },
  {  12,  0,  131 }, {  12,  0,  245 }, {  12,  0,  312 }, {  12,  0,  446 },
  {  12,  0,  454 }, {  13,  0,   25 }, {  13,  0,   98 }, {  13,  0,  426 },
  {  13,  0,  508 }, {  14,  0,   70 }, {  14,  0,  163 }, {  14,  0,  272 },
  {  14,  0,  277 }, {  14,  0,  370 }, {  15,  0,   95 }, {  15,  0,  138 },
  {  15,  0,  167 }, {  17,  0,   38 }, { 148,  0,   96 }, { 135, 10, 1346 },
  {  10,  0,  200 }, {  19,  0,    2 }, { 151,  0,   22 }, { 135, 11,  141 },
  { 134, 10,   85 }, { 134,  0, 1759 }, { 138,  0,  372 }, { 145,  0,   16 },
  {   8,  0,  943 }, { 132, 11,  619 }, { 139, 11,   88 }, {   5, 11,  246 },
  {   8, 11,  189 }, {   9, 11,  355 }, {   9, 11,  512 }, {  10, 11,  124 },
  {  10, 11,  453 }, {  11, 11,  143 }, {  11, 11,  416 }, {  11, 11,  859 },
  { 141, 11,  341 }, {   5,  0,  258 }, { 134,  0,  719 }, {   6,  0, 1798 },
  {   6,  0, 1839 }, {   8,  0,  900 }, {  10,  0,  874 }, {  10,  0,  886 },
  {  12,  0,  698 }, {  12,  0,  732 }, {  12,  0,  770 }, {  16,  0,  106 },
  {  18,  0,  163 }, {  18,  0,  170 }, {  18,  0,  171 }, { 152,  0,   20 },
  {   9,  0,  707 }, {  11,  0,  326 }, {  11,  0,  339 }, {  12,  0,  423 },
  {  12,  0,  502 }, {  20,  0,   62 }, {   9, 11,  707 }, {  11, 11,  326 },
  {  11, 11,  339 }, {  12, 11,  423 }, {  12, 11,  502 }, { 148, 11,   62 },
  {   5,  0,   30 }, {   7,  0,  495 }, {   8,  0,  134 }, {   9,  0,  788 },
  { 140,  0,  438 }, { 133, 11,  678 }, {   5, 10,  279 }, {   6, 10,  235 },
  {   7, 10,  468 }, {   8, 10,  446 }, {   9, 10,  637 }, {  10, 10,  717 },
  {  11, 10,  738 }, { 140, 10,  514 }, {   5, 11,   35 }, {   6, 11,  287 },
  {   7, 11,  862 }, {   7, 11, 1886 }, { 138, 11,  179 }, {   7,  0, 1948 },
  {   7,  0, 2004 }, { 132, 11,  517 }, {   5, 10,   17 }, {   6, 10,  371 },
  { 137, 10,  528 }, {   4,  0,  115 }, {   5,  0,  669 }, {   6,  0,  407 },
  {   8,  0,  311 }, {  11,  0,   10 }, { 141,  0,    5 }, { 137,  0,  381 },
  {   5,  0,   50 }, {   6,  0,  439 }, {   7,  0,  780 }, { 135,  0, 1040 },
  { 136, 11,  667 }, {  11, 11,  403 }, { 146, 11,   83 }, {   5,  0,    1 },
  {   6,  0,   81 }, { 138,  0,  520 }, { 134,  0,  738 }, {   5,  0,  482 },
  {   8,  0,   98 }, {   9,  0,  172 }, {  10,  0,  360 }, {  10,  0,  700 },
  {  10,  0,  822 }, {  11,  0,  302 }, {  11,  0,  778 }, {  12,  0,   50 },
  {  12,  0,  127 }, {  12,  0,  396 }, {  13,  0,   62 }, {  13,  0,  328 },
  {  14,  0,  122 }, { 147,  0,   72 }, {   9, 11,  157 }, {  10, 11,  131 },
  { 140, 11,   72 }, { 135, 11,  714 }, { 135, 11,  539 }, {   5,  0,    2 },
  {   6,  0,  512 }, {   7,  0,  797 }, {   7,  0, 1494 }, {   8,  0,  253 },
  {   8,  0,  589 }, {   9,  0,   77 }, {  10,  0,    1 }, {  10,  0,  129 },
  {  10,  0,  225 }, {  11,  0,  118 }, {  11,  0,  226 }, {  11,  0,  251 },
  {  11,  0,  430 }, {  11,  0,  701 }, {  11,  0,  974 }, {  11,  0,  982 },
  {  12,  0,   64 }, {  12,  0,  260 }, {  12,  0,  488 }, { 140,  0,  690 },
  {   5, 11,  394 }, {   7, 11,  367 }, {   7, 11,  487 }, {   7, 11,  857 },
  {   7, 11, 1713 }, {   8, 11,  246 }, {   9, 11,  537 }, {  10, 11,  165 },
  {  12, 11,  219 }, { 140, 11,  561 }, { 136,  0,  557 }, {   5, 10,  779 },
  {   5, 10,  807 }, {   6, 10, 1655 }, { 134, 10, 1676 }, {   4, 10,  196 },
  {   5, 10,  558 }, { 133, 10,  949 }, {  11, 11,  827 }, {  12, 11,   56 },
  {  14, 11,   34 }, { 143, 11,  148 }, { 137,  0,  347 }, { 133,  0,  572 },
  { 134,  0,  832 }, {   4,  0,   12 }, {   7,  0,  504 }, {   7,  0,  522 },
  {   7,  0,  809 }, {   8,  0,  797 }, { 141,  0,   88 }, {   4, 10,  752 },
  { 133, 11,  449 }, {   7, 11,   86 }, {   8, 11,  103 }, { 145, 11,   69 },
  {   7, 11, 2028 }, { 138, 11,  641 }, {   5,  0,  528 }, {   6, 11,    1 },
  { 142, 11,    2 }, { 134,  0,  861 }, {  10,  0,  294 }, {   4, 10,  227 },
  {   5, 10,  159 }, {   5, 10,  409 }, {   7, 10,   80 }, {  10, 10,  479 },
  {  12, 10,  418 }, {  14, 10,   50 }, {  14, 10,  249 }, { 142, 10,  295 },
  {   7, 10, 1470 }, {   8, 10,   66 }, {   8, 10,  137 }, {   8, 10,  761 },
  {   9, 10,  638 }, {  11, 10,   80 }, {  11, 10,  212 }, {  11, 10,  368 },
  {  11, 10,  418 }, {  12, 10,    8 }, {  13, 10,   15 }, {  16, 10,   61 },
  {  17, 10,   59 }, {  19, 10,   28 }, { 148, 10,   84 }, {  20,  0,  109 },
  { 135, 11, 1148 }, {   6, 11,  277 }, {   7, 11, 1274 }, {   7, 11, 1386 },
  {   7, 11, 1392 }, {  12, 11,  129 }, { 146, 11,   87 }, {   6, 11,  187 },
  {   7, 11,   39 }, {   7, 11, 1203 }, {   8, 11,  380 }, {   8, 11,  542 },
  {  14, 11,  117 }, { 149, 11,   28 }, { 134,  0, 1187 }, {   5,  0,  266 },
  {   9,  0,  290 }, {   9,  0,  364 }, {  10,  0,  293 }, {  11,  0,  606 },
  { 142,  0,   45 }, {   6, 11,  297 }, {   7, 11,  793 }, { 139, 11,  938 },
  {   4,  0,   50 }, {   6,  0,  594 }, {   9,  0,  121 }, {  10,  0,   49 },
  {  10,  0,  412 }, { 139,  0,  834 }, { 136,  0,  748 }, {   7, 11,  464 },
  {   8, 11,  438 }, {  11, 11,  105 }, {  11, 11,  363 }, {  12, 11,  231 },
  {  14, 11,  386 }, {  15, 11,  102 }, { 148, 11,   75 }, { 132,  0,  466 },
  {  13,  0,  399 }, {  14,  0,  337 }, {   6, 10,   38 }, {   7, 10, 1220 },
  {   8, 10,  185 }, {   8, 10,  256 }, {   9, 10,   22 }, {   9, 10,  331 },
  {  10, 10,  738 }, {  11, 10,  205 }, {  11, 10,  540 }, {  11, 10,  746 },
  {  13, 10,  465 }, { 142, 10,  194 }, {   9,  0,  378 }, { 141,  0,  162 },
  { 137,  0,  519 }, {   4, 10,  159 }, {   6, 10,  115 }, {   7, 10,  252 },
  {   7, 10,  257 }, {   7, 10, 1928 }, {   8, 10,   69 }, {   9, 10,  384 },
  {  10, 10,   91 }, {  10, 10,  615 }, {  12, 10,  375 }, {  14, 10,  235 },
  {  18, 10,  117 }, { 147, 10,  123 }, {   5, 11,  604 }, {   5, 10,  911 },
  { 136, 10,  278 }, { 132,  0,  667 }, {   8,  0,  351 }, {   9,  0,  322 },
  {   4, 10,  151 }, { 135, 10, 1567 }, { 134,  0,  902 }, { 133, 10,  990 },
  {  12,  0,  180 }, {   5, 10,  194 }, {   7, 10, 1662 }, { 137, 10,   90 },
  {   4,  0,  869 }, { 134,  0, 1996 }, { 134,  0,  813 }, { 133, 10,  425 },
  { 137, 11,  761 }, { 132,  0,  260 }, { 133, 10,  971 }, {   5, 11,   20 },
  {   6, 11,  298 }, {   7, 11,  659 }, {   7, 11, 1366 }, { 137, 11,  219 },
  {   4,  0,   39 }, {   5,  0,   36 }, {   7,  0, 1843 }, {   8,  0,  407 },
  {  11,  0,  144 }, { 140,  0,  523 }, {   4,  0,  510 }, {  10,  0,  587 },
  { 139, 10,  752 }, {   7,  0,   29 }, {   7,  0,   66 }, {   7,  0, 1980 },
  {  10,  0,  487 }, { 138,  0,  809 }, {  13,  0,  260 }, {  14,  0,   82 },
  {  18,  0,   63 }, { 137, 10,  662 }, {   5, 10,   72 }, {   6, 10,  264 },
  {   7, 10,   21 }, {   7, 10,   46 }, {   7, 10, 2013 }, {   8, 10,  215 },
  {   8, 10,  513 }, {  10, 10,  266 }, { 139, 10,   22 }, { 134,  0,  570 },
  {   6,  0,  565 }, {   7,  0, 1667 }, {   4, 11,  439 }, {  10, 10,   95 },
  {  11, 10,  603 }, {  12, 11,  242 }, {  13, 10,  443 }, {  14, 10,  160 },
  { 143, 10,    4 }, { 134,  0, 1464 }, { 134, 10,  431 }, {   9,  0,  372 },
  {  15,  0,    2 }, {  19,  0,   10 }, {  19,  0,   18 }, {   5, 10,  874 },
  {   6, 10, 1677 }, { 143, 10,    0 }, { 132,  0,  787 }, {   6,  0,  380 },
  {  12,  0,  399 }, {  21,  0,   19 }, {   7, 10,  939 }, {   7, 10, 1172 },
  {   7, 10, 1671 }, {   9, 10,  540 }, {  10, 10,  696 }, {  11, 10,  265 },
  {  11, 10,  732 }, {  11, 10,  928 }, {  11, 10,  937 }, { 141, 10,  438 },
  { 137,  0,  200 }, { 132, 11,  233 }, { 132,  0,  516 }, { 134, 11,  577 },
  { 132,  0,  844 }, {  11,  0,  887 }, {  14,  0,  365 }, { 142,  0,  375 },
  { 132, 11,  482 }, {   8,  0,  821 }, { 140,  0,   44 }, {   7,  0, 1655 },
  { 136,  0,  305 }, {   5, 10,  682 }, { 135, 10, 1887 }, { 135, 11,  346 },
  { 132, 10,  696 }, {   4,  0,   10 }, {   7,  0,  917 }, { 139,  0,  786 },
  {   5, 11,  795 }, {   6, 11, 1741 }, {   8, 11,  417 }, { 137, 11,  782 },
  {   4,  0, 1016 }, { 134,  0, 2031 }, {   5,  0,  684 }, {   4, 10,  726 },
  { 133, 10,  630 }, {   6,  0, 1021 }, { 134,  0, 1480 }, {   8, 10,  802 },
  { 136, 10,  838 }, { 134,  0,   27 }, { 134,  0,  395 }, { 135, 11,  622 },
  {   7, 11,  625 }, { 135, 11, 1750 }, {   4, 11,  203 }, { 135, 11, 1936 },
  {   6, 10,  118 }, {   7, 10,  215 }, {   7, 10, 1521 }, { 140, 10,   11 },
  { 132,  0,  813 }, { 136,  0,  511 }, {   7, 10,  615 }, { 138, 10,  251 },
  { 135, 10, 1044 }, { 145,  0,   56 }, { 133, 10,  225 }, {   6,  0,  342 },
  {   6,  0,  496 }, {   8,  0,  275 }, { 137,  0,  206 }, {   4,  0,  909 },
  { 133,  0,  940 }, { 132,  0,  891 }, {   7, 11,  311 }, {   9, 11,  308 },
  { 140, 11,  255 }, {   4, 10,  370 }, {   5, 10,  756 }, { 135, 10, 1326 },
  {   4,  0,  687 }, { 134,  0, 1596 }, { 134,  0, 1342 }, {   6, 10, 1662 },
  {   7, 10,   48 }, {   8, 10,  771 }, {  10, 10,  116 }, {  13, 10,  104 },
  {  14, 10,  105 }, {  14, 10,  184 }, {  15, 10,  168 }, {  19, 10,   92 },
  { 148, 10,   68 }, { 138, 10,  209 }, {   4, 11,  400 }, {   5, 11,  267 },
  { 135, 11,  232 }, { 151, 11,   12 }, {   6,  0,   41 }, { 141,  0,  160 },
  { 141, 11,  314 }, { 134,  0, 1718 }, { 136,  0,  778 }, { 142, 11,  261 },
  { 134,  0, 1610 }, { 133,  0,  115 }, { 132,  0,  294 }, {  14,  0,  314 },
  { 132, 10,  120 }, { 132,  0,  983 }, {   5,  0,  193 }, { 140,  0,  178 },
  { 138, 10,  429 }, {   5, 10,  820 }, { 135, 10,  931 }, {   6,  0,  994 },
  {   6,  0, 1051 }, {   6,  0, 1439 }, {   7,  0,  174 }, { 133, 11,  732 },
  {   4, 11,  100 }, {   7, 11,  679 }, {   8, 11,  313 }, { 138, 10,  199 },
  {   6, 10,  151 }, {   6, 10, 1675 }, {   7, 10,  383 }, { 151, 10,   10 },
  {   6,  0, 1796 }, {   8,  0,  848 }, {   8,  0,  867 }, {   8,  0,  907 },
  {  10,  0,  855 }, { 140,  0,  703 }, { 140,  0,  221 }, {   4,  0,  122 },
  {   5,  0,  796 }, {   5,  0,  952 }, {   6,  0, 1660 }, {   6,  0, 1671 },
  {   8,  0,  567 }, {   9,  0,  687 }, {   9,  0,  742 }, {  10,  0,  686 },
  {  11,  0,  682 }, {  11,  0,  909 }, { 140,  0,  281 }, {   5, 11,  362 },
  {   5, 11,  443 }, {   6, 11,  318 }, {   7, 11, 1019 }, { 139, 11,  623 },
  {   5, 11,  463 }, { 136, 11,  296 }, {  11,  0,  583 }, {  13,  0,  262 },
  {   6, 10, 1624 }, {  12, 10,  422 }, { 142, 10,  360 }, {   5,  0,  179 },
  {   7,  0, 1095 }, { 135,  0, 1213 }, {   4, 10,   43 }, {   4, 11,  454 },
  {   5, 10,  344 }, { 133, 10,  357 }, {   4,  0,   66 }, {   7,  0,  722 },
  { 135,  0,  904 }, { 134,  0,  773 }, {   7,  0,  352 }, { 133, 10,  888 },
  {   5, 11,   48 }, {   5, 11,  404 }, {   6, 11,  557 }, {   7, 11,  458 },
  {   8, 11,  597 }, {  10, 11,  455 }, {  10, 11,  606 }, {  11, 11,   49 },
  {  11, 11,  548 }, {  12, 11,  476 }, {  13, 11,   18 }, { 141, 11,  450 },
  { 134, 11,  418 }, { 132, 10,  711 }, {   5, 11,  442 }, { 135, 11, 1984 },
  { 141,  0,   35 }, { 137,  0,  152 }, { 134,  0, 1197 }, { 135, 11, 1093 },
  { 137, 11,  203 }, { 137, 10,  440 }, {  10,  0,  592 }, {  10,  0,  753 },
  {  12,  0,  317 }, {  12,  0,  355 }, {  12,  0,  465 }, {  12,  0,  469 },
  {  12,  0,  560 }, {  12,  0,  578 }, { 141,  0,  243 }, { 133,  0,  564 },
  { 134,  0,  797 }, {   5, 10,  958 }, { 133, 10,  987 }, {   5, 11,   55 },
  {   7, 11,  376 }, { 140, 11,  161 }, { 133, 11,  450 }, { 134,  0,  556 },
  { 134,  0,  819 }, {  11, 10,  276 }, { 142, 10,  293 }, {   7,  0,  544 },
  { 138,  0,   61 }, {   8,  0,  719 }, {   4, 10,   65 }, {   5, 10,  479 },
  {   5, 10, 1004 }, {   7, 10, 1913 }, {   8, 10,  317 }, {   9, 10,  302 },
  {  10, 10,  612 }, { 141, 10,   22 }, {   4,  0,    5 }, {   5,  0,  498 },
  {   8,  0,  637 }, {   9,  0,  521 }, {   4, 11,  213 }, {   4, 10,  261 },
  {   7, 11,  223 }, {   7, 10,  510 }, { 136, 11,   80 }, {   5,  0,  927 },
  {   7,  0,  101 }, {   4, 10,  291 }, {   7, 11,  381 }, {   7, 11,  806 },
  {   7, 11,  820 }, {   8, 11,  354 }, {   8, 11,  437 }, {   8, 11,  787 },
  {   9, 10,  515 }, {   9, 11,  657 }, {  10, 11,   58 }, {  10, 11,  339 },
  {  10, 11,  749 }, {  11, 11,  914 }, {  12, 10,  152 }, {  12, 11,  162 },
  {  12, 10,  443 }, {  13, 11,   75 }, {  13, 10,  392 }, {  14, 11,  106 },
  {  14, 11,  198 }, {  14, 11,  320 }, {  14, 10,  357 }, {  14, 11,  413 },
  { 146, 11,   43 }, {   6,  0, 1153 }, {   7,  0, 1441 }, { 136, 11,  747 },
  {   4,  0,  893 }, {   5,  0,  780 }, { 133,  0,  893 }, { 138, 11,  654 },
  { 133, 11,  692 }, { 133,  0,  238 }, { 134, 11,  191 }, {   4, 10,  130 },
  { 135, 10,  843 }, {   6,  0, 1296 }, {   5, 10,   42 }, {   5, 10,  879 },
  {   7, 10,  245 }, {   7, 10,  324 }, {   7, 10, 1532 }, {  11, 10,  463 },
  {  11, 10,  472 }, {  13, 10,  363 }, { 144, 10,   52 }, { 134,  0, 1729 },
  {   6,  0, 1999 }, { 136,  0,  969 }, {   4, 10,  134 }, { 133, 10,  372 },
  {   4,  0,   60 }, {   7,  0,  941 }, {   7,  0, 1800 }, {   8,  0,  314 },
  {   9,  0,  700 }, { 139,  0,  487 }, { 134,  0, 1144 }, {   6, 11,  162 },
  {   7, 11, 1960 }, { 136, 11,  831 }, { 132, 11,  706 }, { 135,  0, 1147 },
  { 138, 11,  426 }, { 138, 11,   89 }, {   7,  0, 1853 }, { 138,  0,  437 },
  { 136,  0,  419 }, { 135, 10, 1634 }, { 133,  0,  828 }, {   5,  0,  806 },
  {   7,  0,  176 }, {   7,  0,  178 }, {   7,  0, 1240 }, {   7,  0, 1976 },
  { 132, 10,  644 }, { 135, 11, 1877 }, {   5, 11,  420 }, { 135, 11, 1449 },
  {   4,  0,   51 }, {   5,  0,   39 }, {   6,  0,    4 }, {   7,  0,  591 },
  {   7,  0,  849 }, {   7,  0,  951 }, {   7,  0, 1613 }, {   7,  0, 1760 },
  {   7,  0, 1988 }, {   9,  0,  434 }, {  10,  0,  754 }, {  11,  0,   25 },
  { 139,  0,   37 }, {  10, 11,   57 }, { 138, 11,  277 }, { 135, 10,  540 },
  { 132, 11,  204 }, { 135,  0,  159 }, { 139, 11,  231 }, { 133,  0,  902 },
  {   7,  0,  928 }, {   7, 11,  366 }, {   9, 11,  287 }, {  12, 11,  199 },
  {  12, 11,  556 }, { 140, 11,  577 }, {   6, 10,  623 }, { 136, 10,  789 },
  {   4, 10,  908 }, {   5, 10,  359 }, {   5, 10,  508 }, {   6, 10, 1723 },
  {   7, 10,  343 }, {   7, 10, 1996 }, { 135, 10, 2026 }, { 134,  0,  270 },
  {   4, 10,  341 }, { 135, 10,  480 }, {   5, 11,  356 }, { 135, 11,  224 },
  {  11, 11,  588 }, {  11, 11,  864 }, {  11, 11,  968 }, { 143, 11,  160 },
  { 132,  0,  556 }, { 137,  0,  801 }, { 132,  0,  416 }, { 142,  0,  372 },
  {   5,  0,  152 }, {   5,  0,  197 }, {   7,  0,  340 }, {   7,  0,  867 },
  {  10,  0,  548 }, {  10,  0,  581 }, {  11,  0,    6 }, {  12,  0,    3 },
  {  12,  0,   19 }, {  14,  0,  110 }, { 142,  0,  289 }, { 139,  0,  369 },
  {   7, 11,  630 }, {   9, 11,  567 }, {  11, 11,  150 }, {  11, 11,  444 },
  { 141, 11,  119 }, { 134, 11,  539 }, {   7, 10, 1995 }, {   8, 10,  299 },
  {  11, 10,  890 }, { 140, 10,  674 }, {   7,  0,   34 }, {   7,  0,  190 },
  {   8,  0,   28 }, {   8,  0,  141 }, {   8,  0,  444 }, {   8,  0,  811 },
  {   9,  0,  468 }, {  11,  0,  334 }, {  12,  0,   24 }, {  12,  0,  386 },
  { 140,  0,  576 }, { 133,  0,  757 }, {   7,  0, 1553 }, { 136,  0,  898 },
  { 133,  0,  721 }, { 136,  0, 1012 }, {   4,  0,  789 }, {   5,  0,  647 },
  { 135,  0, 1102 }, { 132,  0,  898 }, {  10,  0,  183 }, {   4, 10,  238 },
  {   5, 10,  503 }, {   6, 10,  179 }, {   7, 10, 2003 }, {   8, 10,  381 },
  {   8, 10,  473 }, {   9, 10,  149 }, {  10, 10,  788 }, {  15, 10,   45 },
  {  15, 10,   86 }, {  20, 10,  110 }, { 150, 10,   57 }, {   9,  0,  136 },
  {  19,  0,  107 }, {   4, 10,  121 }, {   5, 10,  156 }, {   5, 10,  349 },
  {  10, 10,  605 }, { 142, 10,  342 }, {   4, 11,  235 }, { 135, 11,  255 },
  {   4, 11,  194 }, {   5, 11,  584 }, {   6, 11,  384 }, {   7, 11,  583 },
  {  10, 11,  761 }, {  11, 11,  760 }, { 139, 11,  851 }, {   6, 10,   80 },
  {   6, 10, 1694 }, {   7, 10,  173 }, {   7, 10, 1974 }, {   9, 10,  547 },
  {  10, 10,  730 }, {  14, 10,   18 }, { 150, 10,   39 }, {   4, 10,  923 },
  { 134, 10, 1711 }, {   5,  0,  277 }, { 141,  0,  247 }, { 132,  0,  435 },
  { 133, 11,  562 }, { 134,  0, 1311 }, {   5, 11,  191 }, { 137, 11,  271 },
  { 132, 10,  595 }, {   7, 11, 1537 }, {  14, 11,   96 }, { 143, 11,   73 },
  {   5,  0,  437 }, {   7,  0,  502 }, {   7,  0,  519 }, {   7,  0, 1122 },
  {   7,  0, 1751 }, {  14,  0,  211 }, {   6, 10,  459 }, {   7, 10, 1753 },
  {   7, 10, 1805 }, {   8, 10,  658 }, {   9, 10,    1 }, {  11, 10,  959 },
  { 141, 10,  446 }, {   6,  0,  814 }, {   4, 11,  470 }, {   5, 11,  473 },
  {   6, 11,  153 }, {   7, 11, 1503 }, {   7, 11, 1923 }, {  10, 11,  701 },
  {  11, 11,  132 }, {  11, 11,  168 }, {  11, 11,  227 }, {  11, 11,  320 },
  {  11, 11,  436 }, {  11, 11,  525 }, {  11, 11,  855 }, {  12, 11,   41 },
  {  12, 11,  286 }, {  13, 11,  103 }, {  13, 11,  284 }, {  14, 11,  255 },
  {  14, 11,  262 }, {  15, 11,  117 }, { 143, 11,  127 }, {   5,  0,  265 },
  {   6,  0,  212 }, { 135,  0,   28 }, { 138,  0,  750 }, { 133, 11,  327 },
  {   6, 11,  552 }, {   7, 11, 1754 }, { 137, 11,  604 }, { 134,  0, 2012 },
  { 132,  0,  702 }, {   5, 11,   80 }, {   6, 11,  405 }, {   7, 11,  403 },
  {   7, 11, 1502 }, {   7, 11, 1626 }, {   8, 11,  456 }, {   9, 11,  487 },
  {   9, 11,  853 }, {   9, 11,  889 }, {  10, 11,  309 }, {  11, 11,  721 },
  {  11, 11,  994 }, {  12, 11,  430 }, { 141, 11,  165 }, {   5,  0,  808 },
  { 135,  0, 2045 }, {   5,  0,  166 }, {   8,  0,  739 }, { 140,  0,  511 },
  { 134, 10,  490 }, {   4, 11,  453 }, {   5, 11,  887 }, {   6, 11,  535 },
  {   8, 11,    6 }, { 136, 11,  543 }, {   4,  0,  119 }, {   5,  0,  170 },
  {   5,  0,  447 }, {   7,  0, 1708 }, {   7,  0, 1889 }, {   9,  0,  357 },
  {   9,  0,  719 }, {  12,  0,  486 }, { 140,  0,  596 }, { 137,  0,  500 },
  {   7, 10,  250 }, { 136, 10,  507 }, { 132, 10,  158 }, {   6,  0,  809 },
  { 134,  0, 1500 }, {   9,  0,  327 }, {  11,  0,  350 }, {  11,  0,  831 },
  {  13,  0,  352 }, {   4, 10,  140 }, {   7, 10,  362 }, {   8, 10,  209 },
  {   9, 10,   10 }, {   9, 10,  503 }, {   9, 10,  614 }, {  10, 10,  689 },
  {  11, 10,  327 }, {  11, 10,  725 }, {  12, 10,  252 }, {  12, 10,  583 },
  {  13, 10,  192 }, {  14, 10,  269 }, {  14, 10,  356 }, { 148, 10,   50 },
  { 135, 11,  741 }, {   4,  0,  450 }, {   7,  0, 1158 }, {  19, 10,    1 },
  {  19, 10,   26 }, { 150, 10,    9 }, {   6,  0,  597 }, { 135,  0, 1318 },
  { 134,  0, 1602 }, {   6, 10,  228 }, {   7, 10, 1341 }, {   9, 10,  408 },
  { 138, 10,  343 }, {   7,  0, 1375 }, {   7,  0, 1466 }, { 138,  0,  331 },
  { 132,  0,  754 }, { 132, 10,  557 }, {   5, 11,  101 }, {   6, 11,   88 },
  {   6, 11,  543 }, {   7, 11, 1677 }, {   9, 11,  100 }, {  10, 11,  677 },
  {  14, 11,  169 }, {  14, 11,  302 }, {  14, 11,  313 }, {  15, 11,   48 },
  { 143, 11,   84 }, { 134,  0, 1368 }, {   4, 11,  310 }, {   9, 11,  795 },
  {  10, 11,  733 }, {  11, 11,  451 }, {  12, 11,  249 }, {  14, 11,  115 },
  {  14, 11,  286 }, { 143, 11,  100 }, { 132, 10,  548 }, {  10,  0,  557 },
  {   7, 10,  197 }, {   8, 10,  142 }, {   8, 10,  325 }, {   9, 10,  150 },
  {   9, 10,  596 }, {  10, 10,  353 }, {  11, 10,   74 }, {  11, 10,  315 },
  {  12, 10,  662 }, {  12, 10,  681 }, {  14, 10,  423 }, { 143, 10,  141 },
  { 133, 11,  587 }, {   5,  0,  850 }, { 136,  0,  799 }, {  10,  0,  908 },
  {  12,  0,  701 }, {  12,  0,  757 }, { 142,  0,  466 }, {   4,  0,   62 },
  {   5,  0,  275 }, {  18,  0,   19 }, {   6, 10,  399 }, {   6, 10,  579 },
  {   7, 10,  692 }, {   7, 10,  846 }, {   7, 10, 1015 }, {   7, 10, 1799 },
  {   8, 10,  403 }, {   9, 10,  394 }, {  10, 10,  133 }, {  12, 10,    4 },
  {  12, 10,  297 }, {  12, 10,  452 }, {  16, 10,   81 }, {  18, 10,   25 },
  {  21, 10,   14 }, {  22, 10,   12 }, { 151, 10,   18 }, {  12,  0,  459 },
  {   7, 10, 1546 }, {  11, 10,  299 }, { 142, 10,  407 }, { 132, 10,  177 },
  { 132, 11,  498 }, {   7, 11,  217 }, {   8, 11,  140 }, { 138, 11,  610 },
  {   5, 10,  411 }, { 135, 10,  653 }, { 134,  0, 1802 }, {   7, 10,  439 },
  {  10, 10,  727 }, {  11, 10,  260 }, { 139, 10,  684 }, { 133, 11,  905 },
  {  11, 11,  580 }, { 142, 11,  201 }, { 134,  0, 1397 }, {   5, 10,  208 },
  {   7, 10,  753 }, { 135, 10, 1528 }, {   7,  0,  238 }, {   7,  0, 2033 },
  {   8,  0,  120 }, {   8,  0,  188 }, {   8,  0,  659 }, {   9,  0,  598 },
  {  10,  0,  466 }, {  12,  0,  342 }, {  12,  0,  588 }, {  13,  0,  503 },
  {  14,  0,  246 }, { 143,  0,   92 }, { 135, 11, 1041 }, {   4, 11,  456 },
  {   7, 11,  105 }, {   7, 11,  358 }, {   7, 11, 1637 }, {   8, 11,  643 },
  { 139, 11,  483 }, {   6,  0, 1318 }, { 134,  0, 1324 }, {   4,  0,  201 },
  {   7,  0, 1744 }, {   8,  0,  602 }, {  11,  0,  247 }, {  11,  0,  826 },
  {  17,  0,   65 }, { 133, 10,  242 }, {   8,  0,  164 }, { 146,  0,   62 },
  { 133, 10,  953 }, { 139, 10,  802 }, { 133,  0,  615 }, {   7, 11, 1566 },
  {   8, 11,  269 }, {   9, 11,  212 }, {   9, 11,  718 }, {  14, 11,   15 },
  {  14, 11,  132 }, { 142, 11,  227 }, { 133, 10,  290 }, { 132, 10,  380 },
  {   5, 10,   52 }, {   7, 10,  277 }, {   9, 10,  368 }, { 139, 10,  791 },
  { 135,  0, 1243 }, { 133, 11,  539 }, {  11, 11,  919 }, { 141, 11,  409 },
  { 136,  0,  968 }, { 133, 11,  470 }, { 134,  0,  882 }, { 132,  0,  907 },
  {   5,  0,  100 }, {  10,  0,  329 }, {  12,  0,  416 }, { 149,  0,   29 },
  {  10, 10,  138 }, { 139, 10,  476 }, {   5, 10,  725 }, {   5, 10,  727 },
  {   6, 11,   91 }, {   7, 11,  435 }, { 135, 10, 1811 }, {   4, 11,   16 },
  {   5, 11,  316 }, {   5, 11,  842 }, {   6, 11,  370 }, {   6, 11, 1778 },
  {   8, 11,  166 }, {  11, 11,  812 }, {  12, 11,  206 }, {  12, 11,  351 },
  {  14, 11,  418 }, {  16, 11,   15 }, {  16, 11,   34 }, {  18, 11,    3 },
  {  19, 11,    3 }, {  19, 11,    7 }, {  20, 11,    4 }, { 149, 11,   21 },
  { 132,  0,  176 }, {   5,  0,  636 }, {   5,  0,  998 }, {   7,  0,    9 },
  {   7,  0, 1508 }, {   8,  0,   26 }, {   9,  0,  317 }, {   9,  0,  358 },
  {  10,  0,  210 }, {  10,  0,  292 }, {  10,  0,  533 }, {  11,  0,  555 },
  {  12,  0,  526 }, {  12,  0,  607 }, {  13,  0,  263 }, {  13,  0,  459 },
  { 142,  0,  271 }, {   6,  0,  256 }, {   8,  0,  265 }, {   4, 10,   38 },
  {   7, 10,  307 }, {   7, 10,  999 }, {   7, 10, 1481 }, {   7, 10, 1732 },
  {   7, 10, 1738 }, {   9, 10,  414 }, {  11, 10,  316 }, {  12, 10,   52 },
  {  13, 10,  420 }, { 147, 10,  100 }, { 135, 10, 1296 }, {   4, 11,  611 },
  { 133, 11,  606 }, {   4,  0,  643 }, { 142, 11,   21 }, { 133, 11,  715 },
  { 133, 10,  723 }, {   6,  0,  610 }, { 135, 11,  597 }, {  10,  0,  127 },
  { 141,  0,   27 }, {   6,  0, 1995 }, {   6,  0, 2001 }, {   8,  0,  119 },
  { 136,  0,  973 }, {   4, 11,  149 }, { 138, 11,  368 }, {  12,  0,  522 },
  {   4, 11,  154 }, {   5, 10,  109 }, {   6, 10, 1784 }, {   7, 11, 1134 },
  {   7, 10, 1895 }, {   8, 11,  105 }, {  12, 10,  296 }, { 140, 10,  302 },
  {   4, 11,   31 }, {   6, 11,  429 }, {   7, 11,  962 }, {   9, 11,  458 },
  { 139, 11,  691 }, {  10,  0,  553 }, {  11,  0,  876 }, {  13,  0,  193 },
  {  13,  0,  423 }, {  14,  0,  166 }, {  19,  0,   84 }, {   4, 11,  312 },
  {   5, 10,  216 }, {   7, 10, 1879 }, {   9, 10,  141 }, {   9, 10,  270 },
  {   9, 10,  679 }, {  10, 10,  159 }, {  11, 10,  197 }, {  12, 10,  538 },
  {  12, 10,  559 }, {  14, 10,  144 }, {  14, 10,  167 }, { 143, 10,   67 },
  { 134,  0, 1582 }, {   7,  0, 1578 }, { 135, 11, 1578 }, { 137, 10,   81 },
  { 132, 11,  236 }, { 134, 10,  391 }, { 134,  0,  795 }, {   7, 10,  322 },
  { 136, 10,  249 }, {   5, 11,  836 }, {   5, 11,  857 }, {   6, 11, 1680 },
  {   7, 11,   59 }, { 147, 11,   53 }, { 135,  0,  432 }, {  10, 11,   68 },
  { 139, 11,  494 }, {   4, 11,   81 }, { 139, 11,  867 }, {   7,  0,  126 },
  { 136,  0,   84 }, { 142, 11,  280 }, {   5, 11,  282 }, {   8, 11,  650 },
  {   9, 11,  295 }, {   9, 11,  907 }, { 138, 11,  443 }, { 136,  0,  790 },
  {   5, 10,  632 }, { 138, 10,  526 }, {   6,  0,   64 }, {  12,  0,  377 },
  {  13,  0,  309 }, {  14,  0,  141 }, {  14,  0,  429 }, {  14, 11,  141 },
  { 142, 11,  429 }, { 134,  0, 1529 }, {   6,  0,  321 }, {   7,  0, 1857 },
  {   9,  0,  530 }, {  19,  0,   99 }, {   7, 10,  948 }, {   7, 10, 1042 },
  {   8, 10,  235 }, {   8, 10,  461 }, {   9, 10,  453 }, {  10, 10,  354 },
  { 145, 10,   77 }, {   7,  0, 1104 }, {  11,  0,  269 }, {  11,  0,  539 },
  {  11,  0,  627 }, {  11,  0,  706 }, {  11,  0,  975 }, {  12,  0,  248 },
  {  12,  0,  434 }, {  12,  0,  600 }, {  12,  0,  622 }, {  13,  0,  297 },
  {  13,  0,  485 }, {  14,  0,   69 }, {  14,  0,  409 }, { 143,  0,  108 },
  {   4, 10,  362 }, {   7, 10,   52 }, {   7, 10,  303 }, {  10, 11,   70 },
  {  12, 11,   26 }, {  14, 11,   17 }, {  14, 11,  178 }, {  15, 11,   34 },
  { 149, 11,   12 }, {  11,  0,  977 }, { 141,  0,  507 }, {   9,  0,   34 },
  { 139,  0,  484 }, {   5, 10,  196 }, {   6, 10,  486 }, {   7, 10,  212 },
  {   8, 10,  309 }, { 136, 10,  346 }, {   6,  0, 1700 }, {   7,  0,   26 },
  {   7,  0,  293 }, {   7,  0,  382 }, {   7,  0, 1026 }, {   7,  0, 1087 },
  {   7,  0, 2027 }, {   8,  0,   24 }, {   8,  0,  114 }, {   8,  0,  252 },
  {   8,  0,  727 }, {   8,  0,  729 }, {   9,  0,   30 }, {   9,  0,  199 },
  {   9,  0,  231 }, {   9,  0,  251 }, {   9,  0,  334 }, {   9,  0,  361 },
  {   9,  0,  712 }, {  10,  0,   55 }, {  10,  0,   60 }, {  10,  0,  232 },
  {  10,  0,  332 }, {  10,  0,  384 }, {  10,  0,  396 }, {  10,  0,  504 },
  {  10,  0,  542 }, {  10,  0,  652 }, {  11,  0,   20 }, {  11,  0,   48 },
  {  11,  0,  207 }, {  11,  0,  291 }, {  11,  0,  298 }, {  11,  0,  342 },
  {  11,  0,  365 }, {  11,  0,  394 }, {  11,  0,  620 }, {  11,  0,  705 },
  {  11,  0, 1017 }, {  12,  0,  123 }, {  12,  0,  340 }, {  12,  0,  406 },
  {  12,  0,  643 }, {  13,  0,   61 }, {  13,  0,  269 }, {  13,  0,  311 },
  {  13,  0,  319 }, {  13,  0,  486 }, {  14,  0,  234 }, {  15,  0,   62 },
  {  15,  0,   85 }, {  16,  0,   71 }, {  18,  0,  119 }, {  20,  0,  105 },
  { 135, 10, 1912 }, {   4, 11,   71 }, {   5, 11,  376 }, {   7, 11,  119 },
  { 138, 11,  665 }, {  10,  0,  918 }, {  10,  0,  926 }, {   4, 10,  686 },
  { 136, 11,   55 }, { 138, 10,  625 }, { 136, 10,  706 }, { 132, 11,  479 },
  {   4, 10,   30 }, { 133, 10,   43 }, {   6,  0,  379 }, {   7,  0,  270 },
  {   8,  0,  176 }, {   8,  0,  183 }, {   9,  0,  432 }, {   9,  0,  661 },
  {  12,  0,  247 }, {  12,  0,  617 }, {  18,  0,  125 }, {   7, 11,  607 },
  {   8, 11,   99 }, { 152, 11,    4 }, {   5,  0,  792 }, { 133,  0,  900 },
  {   4, 11,  612 }, { 133, 11,  561 }, {   4, 11,   41 }, {   4, 10,  220 },
  {   5, 11,   74 }, {   7, 10, 1535 }, {   7, 11, 1627 }, {  11, 11,  871 },
  { 140, 11,  619 }, { 135,  0, 1920 }, {   7, 11,   94 }, {  11, 11,  329 },
  {  11, 11,  965 }, {  12, 11,  241 }, {  14, 11,  354 }, {  15, 11,   22 },
  { 148, 11,   63 }, {   9, 11,  209 }, { 137, 11,  300 }, { 134,  0,  771 },
  { 135,  0, 1979 }, {   4,  0,  901 }, { 133,  0,  776 }, { 142,  0,  254 },
  { 133, 11,   98 }, {   9, 11,   16 }, { 141, 11,  386 }, { 133, 11,  984 },
  {   4, 11,  182 }, {   6, 11,  205 }, { 135, 11,  220 }, {   7, 10, 1725 },
  {   7, 10, 1774 }, { 138, 10,  393 }, {   5, 10,  263 }, { 134, 10,  414 },
  {   4, 11,   42 }, {   9, 11,  205 }, {   9, 11,  786 }, { 138, 11,  659 },
  {  14,  0,  140 }, { 148,  0,   41 }, {   8,  0,  440 }, {  10,  0,  359 },
  {   6, 10,  178 }, {   6, 11,  289 }, {   6, 10, 1750 }, {   7, 11, 1670 },
  {   9, 10,  690 }, {  10, 10,  155 }, {  10, 10,  373 }, {  11, 10,  698 },
  {  12, 11,   57 }, {  13, 10,  155 }, {  20, 10,   93 }, { 151, 11,    4 },
  {   4,  0,   37 }, {   5,  0,  334 }, {   7,  0, 1253 }, { 151, 11,   25 },
  {   4,  0,  508 }, {   4, 11,  635 }, {   5, 10,   97 }, { 137, 10,  393 },
  { 139, 11,  533 }, {   4,  0,  640 }, { 133,  0,  513 }, { 134, 10, 1639 },
  { 132, 11,  371 }, {   4, 11,  272 }, {   7, 11,  836 }, {   7, 11, 1651 },
  { 145, 11,   89 }, {   5, 11,  825 }, {   6, 11,  444 }, {   6, 11, 1640 },
  { 136, 11,  308 }, {   4, 10,  191 }, {   7, 10,  934 }, {   8, 10,  647 },
  { 145, 10,   97 }, {  12,  0,  246 }, {  15,  0,  162 }, {  19,  0,   64 },
  {  20,  0,    8 }, {  20,  0,   95 }, {  22,  0,   24 }, { 152,  0,   17 },
  {   4,  0,  533 }, {   5, 10,  165 }, {   9, 10,  346 }, { 138, 10,  655 },
  {   5, 11,  737 }, { 139, 10,  885 }, { 133, 10,  877 }, {   8, 10,  128 },
  { 139, 10,  179 }, { 137, 11,  307 }, { 140,  0,  752 }, { 133,  0,  920 },
  { 135,  0, 1048 }, {   5,  0,  153 }, {   6,  0,  580 }, {   6, 10, 1663 },
  {   7, 10,  132 }, {   7, 10, 1154 }, {   7, 10, 1415 }, {   7, 10, 1507 },
  {  12, 10,  493 }, {  15, 10,  105 }, { 151, 10,   15 }, {   5, 10,  459 },
  {   7, 10, 1073 }, {   8, 10,  241 }, { 136, 10,  334 }, { 138,  0,  391 },
  { 135,  0, 1952 }, { 133, 11,  525 }, {   8, 11,  641 }, {  11, 11,  388 },
  { 140, 11,  580 }, { 142,  0,  126 }, { 134,  0,  640 }, { 132,  0,  483 },
  {   7,  0, 1616 }, {   9,  0,   69 }, {   6, 10,  324 }, {   6, 10,  520 },
  {   7, 10,  338 }, {   7, 10, 1729 }, {   8, 10,  228 }, { 139, 10,  750 },
  {   5, 11,  493 }, { 134, 11,  528 }, { 135,  0,  734 }, {   4, 11,  174 },
  { 135, 11,  911 }, { 138,  0,  480 }, {   9,  0,  495 }, { 146,  0,  104 },
  { 135, 10,  705 }, {   9,  0,  472 }, {   4, 10,   73 }, {   6, 10,  612 },
  {   7, 10,  927 }, {   7, 10, 1330 }, {   7, 10, 1822 }, {   8, 10,  217 },
  {   9, 10,  765 }, {   9, 10,  766 }, {  10, 10,  408 }, {  11, 10,   51 },
  {  11, 10,  793 }, {  12, 10,  266 }, {  15, 10,  158 }, {  20, 10,   89 },
  { 150, 10,   32 }, {   7, 11,  548 }, { 137, 11,   58 }, {   4, 11,   32 },
  {   5, 11,  215 }, {   6, 11,  269 }, {   7, 11, 1782 }, {   7, 11, 1892 },
  {  10, 11,   16 }, {  11, 11,  822 }, {  11, 11,  954 }, { 141, 11,  481 },
  { 132,  0,  874 }, {   9,  0,  229 }, {   5, 10,  389 }, { 136, 10,  636 },
  {   7, 11, 1749 }, { 136, 11,  477 }, { 134,  0,  948 }, {   5, 11,  308 },
  { 135, 11, 1088 }, {   4,  0,  748 }, { 139,  0, 1009 }, { 136, 10,   21 },
  {   6,  0,  555 }, { 135,  0,  485 }, {   5, 11,  126 }, {   8, 11,  297 },
  {   9, 11,  366 }, {   9, 11,  445 }, {  12, 11,   53 }, {  12, 11,  374 },
  { 141, 11,  492 }, {   7, 11, 1551 }, { 139, 11,  361 }, { 136,  0,  193 },
  { 136,  0,  472 }, {   8,  0,  653 }, {  13,  0,   93 }, { 147,  0,   14 },
  { 132,  0,  984 }, { 132, 11,  175 }, {   5,  0,  172 }, {   6,  0, 1971 },
  { 132, 11,  685 }, { 149, 11,    8 }, { 133, 11,  797 }, {  13,  0,   83 },
  {   5, 10,  189 }, {   7, 10,  442 }, {   7, 10,  443 }, {   8, 10,  281 },
  {  12, 10,  174 }, { 141, 10,  261 }, { 134,  0, 1568 }, { 133, 11,  565 },
  { 139,  0,  384 }, { 133,  0,  260 }, {   7,  0,  758 }, {   7,  0,  880 },
  {   7,  0, 1359 }, {   9,  0,  164 }, {   9,  0,  167 }, {  10,  0,  156 },
  {  10,  0,  588 }, {  12,  0,  101 }, {  14,  0,   48 }, {  15,  0,   70 },
  {   6, 10,    2 }, {   7, 10, 1262 }, {   7, 10, 1737 }, {   8, 10,   22 },
  {   8, 10,  270 }, {   8, 10,  612 }, {   9, 10,  312 }, {   9, 10,  436 },
  {  10, 10,  311 }, {  10, 10,  623 }, {  11, 10,   72 }, {  11, 10,  330 },
  {  11, 10,  455 }, {  12, 10,  321 }, {  12, 10,  504 }, {  12, 10,  530 },
  {  12, 10,  543 }, {  13, 10,   17 }, {  13, 10,  156 }, {  13, 10,  334 },
  {  17, 10,   60 }, { 148, 10,   64 }, {   4, 11,  252 }, {   7, 11, 1068 },
  {  10, 11,  434 }, {  11, 11,  228 }, {  11, 11,  426 }, {  13, 11,  231 },
  {  18, 11,  106 }, { 148, 11,   87 }, {   7, 10,  354 }, {  10, 10,  410 },
  { 139, 10,  815 }, {   6,  0,  367 }, {   7, 10,  670 }, {   7, 10, 1327 },
  {   8, 10,  411 }, {   8, 10,  435 }, {   9, 10,  653 }, {   9, 10,  740 },
  {  10, 10,  385 }, {  11, 10,  222 }, {  11, 10,  324 }, {  11, 10,  829 },
  { 140, 10,  611 }, {   7,  0, 1174 }, {   6, 10,  166 }, { 135, 10,  374 },
  { 146,  0,  121 }, { 132,  0,  828 }, {   5, 11,  231 }, { 138, 11,  509 },
  {   7, 11,  601 }, {   9, 11,  277 }, {   9, 11,  674 }, {  10, 11,  178 },
  {  10, 11,  257 }, {  10, 11,  418 }, {  11, 11,  531 }, {  11, 11,  544 },
  {  11, 11,  585 }, {  12, 11,  113 }, {  12, 11,  475 }, {  13, 11,   99 },
  { 142, 11,  428 }, { 134,  0, 1541 }, { 135, 11, 1779 }, {   5,  0,  343 },
  { 134, 10,  398 }, { 135, 10,   50 }, { 135, 11, 1683 }, {   4,  0,  440 },
  {   7,  0,   57 }, {   8,  0,  167 }, {   8,  0,  375 }, {   9,  0,   82 },
  {   9,  0,  561 }, {   9,  0,  744 }, {  10,  0,  620 }, { 137, 11,  744 },
  { 134,  0,  926 }, {   6, 10,  517 }, {   7, 10, 1159 }, {  10, 10,  621 },
  { 139, 10,  192 }, { 137,  0,  827 }, {   8,  0,  194 }, { 136,  0,  756 },
  {  10, 10,  223 }, { 139, 10,  645 }, {   7, 10,   64 }, { 136, 10,  245 },
  {   4, 11,  399 }, {   5, 11,  119 }, {   5, 11,  494 }, {   7, 11,  751 },
  { 137, 11,  556 }, { 132,  0,  808 }, { 135,  0,   22 }, {   7, 10, 1763 },
  { 140, 10,  310 }, {   5,  0,  639 }, {   7,  0, 1249 }, {  11,  0,  896 },
  { 134, 11,  584 }, { 134,  0, 1614 }, { 135,  0,  860 }, { 135, 11, 1121 },
  {   5, 10,  129 }, {   6, 10,   61 }, { 135, 10,  947 }, {   4,  0,  102 },
  {   7,  0,  815 }, {   7,  0, 1699 }, { 139,  0,  964 }, {  13, 10,  505 },
  { 141, 10,  506 }, { 139, 10, 1000 }, { 132, 11,  679 }, { 132,  0,  899 },
  { 132,  0,  569 }, {   5, 11,  694 }, { 137, 11,  714 }, { 136,  0,  795 },
  {   6,  0, 2045 }, { 139, 11,    7 }, {   6,  0,   52 }, {   9,  0,  104 },
  {   9,  0,  559 }, {  12,  0,  308 }, { 147,  0,   87 }, {   4,  0,  301 },
  { 132,  0,  604 }, { 133, 10,  637 }, { 136,  0,  779 }, {   5, 11,  143 },
  {   5, 11,  769 }, {   6, 11, 1760 }, {   7, 11,  682 }, {   7, 11, 1992 },
  { 136, 11,  736 }, { 137, 10,  590 }, { 147,  0,   32 }, { 137, 11,  527 },
  {   5, 10,  280 }, { 135, 10, 1226 }, { 134,  0,  494 }, {   6,  0,  677 },
  {   6,  0,  682 }, { 134,  0, 1044 }, { 133, 10,  281 }, { 135, 10, 1064 },
  {   7,  0,  508 }, { 133, 11,  860 }, {   6, 11,  422 }, {   7, 11,    0 },
  {   7, 11, 1544 }, {   9, 11,  577 }, {  11, 11,  990 }, {  12, 11,  141 },
  {  12, 11,  453 }, {  13, 11,   47 }, { 141, 11,  266 }, { 134,  0, 1014 },
  {   5, 11,  515 }, { 137, 11,  131 }, { 134,  0,  957 }, { 132, 11,  646 },
  {   6,  0,  310 }, {   7,  0, 1849 }, {   8,  0,   72 }, {   8,  0,  272 },
  {   8,  0,  431 }, {   9,  0,   12 }, {   9,  0,  376 }, {  10,  0,  563 },
  {  10,  0,  630 }, {  10,  0,  796 }, {  10,  0,  810 }, {  11,  0,  367 },
  {  11,  0,  599 }, {  11,  0,  686 }, { 140,  0,  672 }, {   7,  0,  570 },
  {   4, 11,  396 }, {   7, 10,  120 }, {   7, 11,  728 }, {   8, 10,  489 },
  {   9, 11,  117 }, {   9, 10,  319 }, {  10, 10,  820 }, {  11, 10, 1004 },
  {  12, 10,  379 }, {  12, 10,  679 }, {  13, 10,  117 }, {  13, 11,  202 },
  {  13, 10,  412 }, {  14, 10,   25 }, {  15, 10,   52 }, {  15, 10,  161 },
  {  16, 10,   47 }, {  20, 11,   51 }, { 149, 10,    2 }, {   6, 11,  121 },
  {   6, 11,  124 }, {   6, 11,  357 }, {   7, 11, 1138 }, {   7, 11, 1295 },
  {   8, 11,  162 }, { 139, 11,  655 }, {   8,  0,  449 }, {   4, 10,  937 },
  {   5, 10,  801 }, { 136, 11,  449 }, { 139, 11,  958 }, {   6,  0,  181 },
  {   7,  0,  537 }, {   8,  0,   64 }, {   9,  0,  127 }, {  10,  0,  496 },
  {  12,  0,  510 }, { 141,  0,  384 }, { 138, 11,  253 }, {   4,  0,  244 },
  { 135,  0,  233 }, { 133, 11,  237 }, { 132, 10,  365 }, {   6,  0, 1650 },
  {  10,  0,  702 }, { 139,  0,  245 }, {   5, 10,    7 }, { 139, 10,  774 },
  {  13,  0,  463 }, {  20,  0,   49 }, {  13, 11,  463 }, { 148, 11,   49 },
  {   4, 10,  734 }, {   5, 10,  662 }, { 134, 10,  430 }, {   4, 10,  746 },
  { 135, 10, 1090 }, {   5, 10,  360 }, { 136, 10,  237 }, { 137,  0,  338 },
  { 143, 11,   10 }, {   7, 11,  571 }, { 138, 11,  366 }, { 134,  0, 1279 },
  {   9, 11,  513 }, {  10, 11,   22 }, {  10, 11,   39 }, {  12, 11,  122 },
  { 140, 11,  187 }, { 133,  0,  896 }, { 146,  0,  178 }, { 134,  0,  695 },
  { 137,  0,  808 }, { 134, 11,  587 }, {   7, 11,  107 }, {   7, 11,  838 },
  {   8, 11,  550 }, { 138, 11,  401 }, {   7,  0, 1117 }, { 136,  0,  539 },
  {   4, 10,  277 }, {   5, 10,  608 }, {   6, 10,  493 }, {   7, 10,  457 },
  { 140, 10,  384 }, { 133, 11,  768 }, {  12,  0,  257 }, {   7, 10,   27 },
  { 135, 10,  316 }, { 140,  0, 1003 }, {   4,  0,  207 }, {   5,  0,  586 },
  {   5,  0,  676 }, {   6,  0,  448 }, {   8,  0,  244 }, {  11,  0,    1 },
  {  13,  0,    3 }, {  16,  0,   54 }, {  17,  0,    4 }, {  18,  0,   13 },
  { 133, 10,  552 }, {   4, 10,  401 }, { 137, 10,  264 }, {   5,  0,  516 },
  {   7,  0, 1883 }, { 135, 11, 1883 }, {  12,  0,  960 }, { 132, 11,  894 },
  {   5,  0,    4 }, {   5,  0,  810 }, {   6,  0,   13 }, {   6,  0,  538 },
  {   6,  0, 1690 }, {   6,  0, 1726 }, {   7,  0,  499 }, {   7,  0, 1819 },
  {   8,  0,  148 }, {   8,  0,  696 }, {   8,  0,  791 }, {  12,  0,  125 },
  { 143,  0,    9 }, { 135,  0, 1268 }, {  11,  0,   30 }, {  14,  0,  315 },
  {   9, 10,  543 }, {  10, 10,  524 }, {  12, 10,  524 }, {  16, 10,   18 },
  {  20, 10,   26 }, { 148, 10,   65 }, {   6,  0,  748 }, {   4, 10,  205 },
  {   5, 10,  623 }, {   7, 10,  104 }, { 136, 10,  519 }, {  11,  0,  542 },
  { 139,  0,  852 }, { 140,  0,    6 }, { 132,  0,  848 }, {   7,  0, 1385 },
  {  11,  0,  582 }, {  11,  0,  650 }, {  11,  0,  901 }, {  11,  0,  949 },
  {  12,  0,  232 }, {  12,  0,  236 }, {  13,  0,  413 }, {  13,  0,  501 },
  {  18,  0,  116 }, {   7, 10,  579 }, {   9, 10,   41 }, {   9, 10,  244 },
  {   9, 10,  669 }, {  10, 10,    5 }, {  11, 10,  861 }, {  11, 10,  951 },
  { 139, 10,  980 }, {   4,  0,  945 }, {   6,  0, 1811 }, {   6,  0, 1845 },
  {   6,  0, 1853 }, {   6,  0, 1858 }, {   8,  0,  862 }, {  12,  0,  782 },
  {  12,  0,  788 }, {  18,  0,  160 }, { 148,  0,  117 }, { 132, 10,  717 },
  {   4,  0,  925 }, {   5,  0,  803 }, {   8,  0,  698 }, { 138,  0,  828 },
  { 134,  0, 1416 }, { 132,  0,  610 }, { 139,  0,  992 }, {   6,  0,  878 },
  { 134,  0, 1477 }, { 135,  0, 1847 }, { 138, 11,  531 }, { 137, 11,  539 },
  { 134, 11,  272 }, { 133,  0,  383 }, { 134,  0, 1404 }, { 132, 10,  489 },
  {   4, 11,    9 }, {   5, 11,  128 }, {   7, 11,  368 }, {  11, 11,  480 },
  { 148, 11,    3 }, { 136,  0,  986 }, {   9,  0,  660 }, { 138,  0,  347 },
  { 135, 10,  892 }, { 136, 11,  682 }, {   7,  0,  572 }, {   9,  0,  592 },
  {  11,  0,  680 }, {  12,  0,  356 }, { 140,  0,  550 }, {   7,  0, 1411 },
  { 138, 11,  527 }, {   4, 11,    2 }, {   7, 11,  545 }, { 135, 11,  894 },
  { 137, 10,  473 }, {  11,  0,   64 }, {   7, 11,  481 }, {   7, 10,  819 },
  {   9, 10,   26 }, {   9, 10,  392 }, {   9, 11,  792 }, {  10, 10,  152 },
  {  10, 10,  226 }, {  12, 10,  276 }, {  12, 10,  426 }, {  12, 10,  589 },
  {  13, 10,  460 }, {  15, 10,   97 }, {  19, 10,   48 }, { 148, 10,  104 },
  { 135, 10,   51 }, { 136, 11,  445 }, { 136, 11,  646 }, { 135,  0,  606 },
  { 132, 10,  674 }, {   6,  0, 1829 }, { 134,  0, 1830 }, { 132, 10,  770 },
  {   5, 10,   79 }, {   7, 10, 1027 }, {   7, 10, 1477 }, { 139, 10,   52 },
  {   5, 11,  530 }, { 142, 11,  113 }, { 134, 10, 1666 }, {   7,  0,  748 },
  { 139,  0,  700 }, { 134, 10,  195 }, { 133, 10,  789 }, {   9,  0,   87 },
  {  10,  0,  365 }, {   4, 10,  251 }, {   4, 10,  688 }, {   7, 10,  513 },
  { 135, 10, 1284 }, { 136, 11,  111 }, { 133,  0,  127 }, {   6,  0,  198 },
  { 140,  0,   83 }, { 133, 11,  556 }, { 133, 10,  889 }, {   4, 10,  160 },
  {   5, 10,  330 }, {   7, 10, 1434 }, { 136, 10,  174 }, {   5,  0,  276 },
  {   6,  0,   55 }, {   7,  0, 1369 }, { 138,  0,  864 }, {   8, 11,   16 },
  { 140, 11,  568 }, {   6,  0, 1752 }, { 136,  0,  726 }, { 135,  0, 1066 },
  { 133,  0,  764 }, {   6, 11,  186 }, { 137, 11,  426 }, {  11,  0,  683 },
  { 139, 11,  683 }, {   6,  0,  309 }, {   7,  0,  331 }, { 138,  0,  550 },
  { 133, 10,  374 }, {   6,  0, 1212 }, {   6,  0, 1852 }, {   7,  0, 1062 },
  {   8,  0,  874 }, {   8,  0,  882 }, { 138,  0,  936 }, { 132, 11,  585 },
  { 134,  0, 1364 }, {   7,  0,  986 }, { 133, 10,  731 }, {   6,  0,  723 },
  {   6,  0, 1408 }, { 138,  0,  381 }, { 135,  0, 1573 }, { 134,  0, 1025 },
  {   4, 10,  626 }, {   5, 10,  642 }, {   6, 10,  425 }, {  10, 10,  202 },
  { 139, 10,  141 }, {   4, 11,   93 }, {   5, 11,  252 }, {   6, 11,  229 },
  {   7, 11,  291 }, {   9, 11,  550 }, { 139, 11,  644 }, { 137, 11,  749 },
  { 137, 11,  162 }, { 132, 11,  381 }, { 135,  0, 1559 }, {   6,  0,  194 },
  {   7,  0,  133 }, {  10,  0,  493 }, {  10,  0,  570 }, { 139,  0,  664 },
  {   5,  0,   24 }, {   5,  0,  569 }, {   6,  0,    3 }, {   6,  0,  119 },
  {   6,  0,  143 }, {   6,  0,  440 }, {   7,  0,  295 }, {   7,  0,  599 },
  {   7,  0, 1686 }, {   7,  0, 1854 }, {   8,  0,  424 }, {   9,  0,   43 },
  {   9,  0,  584 }, {   9,  0,  760 }, {  10,  0,  148 }, {  10,  0,  328 },
  {  11,  0,  159 }, {  11,  0,  253 }, {  11,  0,  506 }, {  12,  0,  487 },
  { 140,  0,  531 }, {   6,  0,  661 }, { 134,  0, 1517 }, { 136, 10,  835 },
  { 151, 10,   17 }, {   5,  0,   14 }, {   5,  0,  892 }, {   6,  0,  283 },
  {   7,  0,  234 }, { 136,  0,  537 }, { 139,  0,  541 }, {   4,  0,  126 },
  {   8,  0,  635 }, { 147,  0,   34 }, {   4,  0,  316 }, {   4,  0,  495 },
  { 135,  0, 1561 }, {   4, 11,  187 }, {   5, 11,  184 }, {   5, 11,  690 },
  {   7, 11, 1869 }, { 138, 11,  756 }, { 139, 11,  783 }, {   4,  0,  998 },
  { 137,  0,  861 }, { 136,  0, 1009 }, { 139, 11,  292 }, {   5, 11,   21 },
  {   6, 11,   77 }, {   6, 11,  157 }, {   7, 11,  974 }, {   7, 11, 1301 },
  {   7, 11, 1339 }, {   7, 11, 1490 }, {   7, 11, 1873 }, { 137, 11,  628 },
  {   7, 11, 1283 }, {   9, 11,  227 }, {   9, 11,  499 }, {  10, 11,  341 },
  {  11, 11,  325 }, {  11, 11,  408 }, {  14, 11,  180 }, {  15, 11,  144 },
  {  18, 11,   47 }, { 147, 11,   49 }, {   4,  0,   64 }, {   5,  0,  352 },
  {   5,  0,  720 }, {   6,  0,  368 }, { 139,  0,  359 }, {   5, 10,  384 },
  {   8, 10,  455 }, { 140, 10,   48 }, {   5, 10,  264 }, { 134, 10,  184 },
  {   7,  0, 1577 }, {  10,  0,  304 }, {  10,  0,  549 }, {  12,  0,  365 },
  {  13,  0,  220 }, {  13,  0,  240 }, { 142,  0,   33 }, { 134,  0, 1107 },
  { 134,  0,  929 }, { 135,  0, 1142 }, {   6,  0,  175 }, { 137,  0,  289 },
  {   5,  0,  432 }, { 133,  0,  913 }, {   6,  0,  279 }, {   7,  0,  219 },
  {   5, 10,  633 }, { 135, 10, 1323 }, {   7,  0,  785 }, {   7, 10,  359 },
  {   8, 10,  243 }, { 140, 10,  175 }, { 139,  0,  595 }, { 132, 10,  105 },
  {   8, 11,  398 }, {   9, 11,  681 }, { 139, 11,  632 }, { 140,  0,   80 },
  {   5,  0,  931 }, { 134,  0, 1698 }, { 142, 11,  241 }, { 134, 11,   20 },
  { 134,  0, 1323 }, {  11,  0,  526 }, {  11,  0,  939 }, { 141,  0,  290 },
  {   5,  0,  774 }, {   6,  0,  780 }, {   6,  0, 1637 }, {   6,  0, 1686 },
  {   6,  0, 1751 }, {   8,  0,  559 }, { 141,  0,  109 }, { 141,  0,  127 },
  {   7,  0, 1167 }, {  11,  0,  934 }, {  13,  0,  391 }, {  17,  0,   76 },
  { 135, 11,  709 }, { 135,  0,  963 }, {   6,  0,  260 }, { 135,  0, 1484 },
  { 134,  0,  573 }, {   4, 10,  758 }, { 139, 11,  941 }, { 135, 10, 1649 },
  { 145, 11,   36 }, {   4,  0,  292 }, { 137,  0,  580 }, {   4,  0,  736 },
  {   5,  0,  871 }, {   6,  0, 1689 }, { 135,  0, 1944 }, {   7, 11,  945 },
  {  11, 11,  713 }, { 139, 11,  744 }, { 134,  0, 1164 }, { 135, 11,  937 },
  {   6,  0, 1922 }, {   9,  0,  982 }, {  15,  0,  173 }, {  15,  0,  178 },
  {  15,  0,  200 }, {  18,  0,  189 }, {  18,  0,  207 }, {  21,  0,   47 },
  { 135, 11, 1652 }, {   7,  0, 1695 }, { 139, 10,  128 }, {   6,  0,   63 },
  { 135,  0,  920 }, { 133,  0,  793 }, { 143, 11,  134 }, { 133, 10,  918 },
  {   5,  0,   67 }, {   6,  0,   62 }, {   6,  0,  374 }, { 135,  0, 1391 },
  {   9,  0,  790 }, {  12,  0,   47 }, {   4, 11,  579 }, {   5, 11,  226 },
  {   5, 11,  323 }, { 135, 11,  960 }, {  10, 11,  784 }, { 141, 11,  191 },
  {   4,  0,  391 }, { 135,  0, 1169 }, { 137,  0,  443 }, {  13, 11,  232 },
  { 146, 11,   35 }, { 132, 10,  340 }, { 132,  0,  271 }, { 137, 11,  313 },
  {   5, 11,  973 }, { 137, 11,  659 }, { 134,  0, 1140 }, {   6, 11,  135 },
  { 135, 11, 1176 }, {   4,  0,  253 }, {   5,  0,  544 }, {   7,  0,  300 },
  { 137,  0,  340 }, {   7,  0,  897 }, {   5, 10,  985 }, {   7, 10,  509 },
  { 145, 10,   96 }, { 138, 11,  735 }, { 135, 10, 1919 }, { 138,  0,  890 },
  {   5,  0,  818 }, { 134,  0, 1122 }, {   5,  0,   53 }, {   5,  0,  541 },
  {   6,  0,   94 }, {   6,  0,  499 }, {   7,  0,  230 }, { 139,  0,  321 },
  {   4,  0,  920 }, {   5,  0,   25 }, {   5,  0,  790 }, {   6,  0,  457 },
  {   7,  0,  853 }, {   8,  0,  788 }, { 142, 11,   31 }, { 132, 10,  247 },
  { 135, 11,  314 }, { 132,  0,  468 }, {   7,  0,  243 }, {   6, 10,  337 },
  {   7, 10,  494 }, {   8, 10,   27 }, {   8, 10,  599 }, { 138, 10,  153 },
  {   4, 10,  184 }, {   5, 10,  390 }, {   7, 10,  618 }, {   7, 10, 1456 },
  { 139, 10,  710 }, { 134,  0,  870 }, { 134,  0, 1238 }, { 134,  0, 1765 },
  {  10,  0,  853 }, {  10,  0,  943 }, {  14,  0,  437 }, {  14,  0,  439 },
  {  14,  0,  443 }, {  14,  0,  446 }, {  14,  0,  452 }, {  14,  0,  469 },
  {  14,  0,  471 }, {  14,  0,  473 }, {  16,  0,   93 }, {  16,  0,  102 },
  {  16,  0,  110 }, { 148,  0,  121 }, {   4,  0,  605 }, {   7,  0,  518 },
  {   7,  0, 1282 }, {   7,  0, 1918 }, {  10,  0,  180 }, { 139,  0,  218 },
  { 133,  0,  822 }, {   4,  0,  634 }, {  11,  0,  916 }, { 142,  0,  419 },
  {   6, 11,  281 }, {   7, 11,    6 }, {   8, 11,  282 }, {   8, 11,  480 },
  {   8, 11,  499 }, {   9, 11,  198 }, {  10, 11,  143 }, {  10, 11,  169 },
  {  10, 11,  211 }, {  10, 11,  417 }, {  10, 11,  574 }, {  11, 11,  147 },
  {  11, 11,  395 }, {  12, 11,   75 }, {  12, 11,  407 }, {  12, 11,  608 },
  {  13, 11,  500 }, { 142, 11,  251 }, { 134,  0,  898 }, {   6,  0,   36 },
  {   7,  0,  658 }, {   8,  0,  454 }, { 150, 11,   48 }, { 133, 11,  674 },
  { 135, 11, 1776 }, {   4, 11,  419 }, {  10, 10,  227 }, {  11, 10,  497 },
  {  11, 10,  709 }, { 140, 10,  415 }, {   6, 10,  360 }, {   7, 10, 1664 },
  { 136, 10,  478 }, { 137,  0,  806 }, {  12, 11,  508 }, {  14, 11,  102 },
  {  14, 11,  226 }, { 144, 11,   57 }, { 135, 11, 1123 }, {   4, 11,  138 },
  {   7, 11, 1012 }, {   7, 11, 1280 }, { 137, 11,   76 }, {   5, 11,   29 },
  { 140, 11,  638 }, { 136, 10,  699 }, { 134,  0, 1326 }, { 132,  0,  104 },
  { 135, 11,  735 }, { 132, 10,  739 }, { 134,  0, 1331 }, {   7,  0,  260 },
  { 135, 11,  260 }, { 135, 11, 1063 }, {   7,  0,   45 }, {   9,  0,  542 },
  {   9,  0,  566 }, {  10,  0,  728 }, { 137, 10,  869 }, {   4, 10,   67 },
  {   5, 10,  422 }, {   7, 10, 1037 }, {   7, 10, 1289 }, {   7, 10, 1555 },
  {   9, 10,  741 }, { 145, 10,  108 }, { 139,  0,  263 }, { 134,  0, 1516 },
  {  14,  0,  146 }, {  15,  0,   42 }, {  16,  0,   23 }, {  17,  0,   86 },
  { 146,  0,   17 }, { 138,  0,  468 }, { 136,  0, 1005 }, {   4, 11,   17 },
  {   5, 11,   23 }, {   7, 11,  995 }, {  11, 11,  383 }, {  11, 11,  437 },
  {  12, 11,  460 }, { 140, 11,  532 }, {   7,  0,   87 }, { 142,  0,  288 },
  { 138, 10,   96 }, { 135, 11,  626 }, { 144, 10,   26 }, {   7,  0,  988 },
  {   7,  0, 1939 }, {   9,  0,   64 }, {   9,  0,  502 }, {  12,  0,   22 },
  {  12,  0,   34 }, {  13,  0,   12 }, {  13,  0,  234 }, { 147,  0,   77 },
  {  13,  0,  133 }, {   8, 10,  203 }, {  11, 10,  823 }, {  11, 10,  846 },
  {  12, 10,  482 }, {  13, 10,  277 }, {  13, 10,  302 }, {  13, 10,  464 },
  {  14, 10,  205 }, { 142, 10,  221 }, {   4, 10,  449 }, { 133, 10,  718 },
  { 135,  0,  141 }, {   6,  0, 1842 }, { 136,  0,  872 }, {   8, 11,   70 },
  {  12, 11,  171 }, { 141, 11,  272 }, {   4, 10,  355 }, {   6, 10,  311 },
  {   9, 10,  256 }, { 138, 10,  404 }, { 132,  0,  619 }, { 137,  0,  261 },
  {  10, 11,  233 }, {  10, 10,  758 }, { 139, 11,   76 }, {   5,  0,  246 },
  {   8,  0,  189 }, {   9,  0,  355 }, {   9,  0,  512 }, {  10,  0,  124 },
  {  10,  0,  453 }, {  11,  0,  143 }, {  11,  0,  416 }, {  11,  0,  859 },
  { 141,  0,  341 }, { 134, 11,  442 }, { 133, 10,  827 }, {   5, 10,   64 },
  { 140, 10,  581 }, {   4, 10,  442 }, {   7, 10, 1047 }, {   7, 10, 1352 },
  { 135, 10, 1643 }, { 134, 11, 1709 }, {   5,  0,  678 }, {   6,  0,  305 },
  {   7,  0,  775 }, {   7,  0, 1065 }, { 133, 10,  977 }, {  11, 11,   69 },
  {  12, 11,  105 }, {  12, 11,  117 }, {  13, 11,  213 }, {  14, 11,   13 },
  {  14, 11,   62 }, {  14, 11,  177 }, {  14, 11,  421 }, {  15, 11,   19 },
  { 146, 11,  141 }, { 137, 11,  309 }, {   5,  0,   35 }, {   7,  0,  862 },
  {   7,  0, 1886 }, { 138,  0,  179 }, { 136,  0,  285 }, { 132,  0,  517 },
  {   7, 11,  976 }, {   9, 11,  146 }, {  10, 11,  206 }, {  10, 11,  596 },
  {  13, 11,  218 }, { 142, 11,  153 }, { 132, 10,  254 }, {   6,  0,  214 },
  {  12,  0,  540 }, {   4, 10,  275 }, {   7, 10, 1219 }, { 140, 10,  376 },
  {   8,  0,  667 }, {  11,  0,  403 }, { 146,  0,   83 }, {  12,  0,   74 },
  {  10, 11,  648 }, {  11, 11,  671 }, { 143, 11,   46 }, { 135,  0,  125 },
  { 134, 10, 1753 }, { 133,  0,  761 }, {   6,  0,  912 }, {   4, 11,  518 },
  {   6, 10,  369 }, {   6, 10,  502 }, {   7, 10, 1036 }, {   7, 11, 1136 },
  {   8, 10,  348 }, {   9, 10,  452 }, {  10, 10,   26 }, {  11, 10,  224 },
  {  11, 10,  387 }, {  11, 10,  772 }, {  12, 10,   95 }, {  12, 10,  629 },
  {  13, 10,  195 }, {  13, 10,  207 }, {  13, 10,  241 }, {  14, 10,  260 },
  {  14, 10,  270 }, { 143, 10,  140 }, {  10,  0,  131 }, { 140,  0,   72 },
  { 132, 10,  269 }, {   5, 10,  480 }, {   7, 10,  532 }, {   7, 10, 1197 },
  {   7, 10, 1358 }, {   8, 10,  291 }, {  11, 10,  349 }, { 142, 10,  396 },
  {   8, 11,  689 }, { 137, 11,  863 }, {   8,  0,  333 }, { 138,  0,  182 },
  {   4, 11,   18 }, {   7, 11,  145 }, {   7, 11,  444 }, {   7, 11, 1278 },
  {   8, 11,   49 }, {   8, 11,  400 }, {   9, 11,   71 }, {   9, 11,  250 },
  {  10, 11,  459 }, {  12, 11,  160 }, { 144, 11,   24 }, {  14, 11,   35 },
  { 142, 11,  191 }, { 135, 11, 1864 }, { 135,  0, 1338 }, { 148, 10,   15 },
  {  14,  0,   94 }, {  15,  0,   65 }, {  16,  0,    4 }, {  16,  0,   77 },
  {  16,  0,   80 }, { 145,  0,    5 }, {  12, 11,   82 }, { 143, 11,   36 },
  { 133, 11, 1010 }, { 133,  0,  449 }, { 133,  0,  646 }, {   7,  0,   86 },
  {   8,  0,  103 }, { 135, 10,  657 }, {   7,  0, 2028 }, { 138,  0,  641 },
  { 136, 10,  533 }, { 134,  0,    1 }, { 139, 11,  970 }, {   5, 11,   87 },
  {   7, 11,  313 }, {   7, 11, 1103 }, {  10, 11,  112 }, {  10, 11,  582 },
  {  11, 11,  389 }, {  11, 11,  813 }, {  12, 11,  385 }, {  13, 11,  286 },
  {  14, 11,  124 }, { 146, 11,  108 }, {   6,  0,  869 }, { 132, 11,  267 },
  {   6,  0,  277 }, {   7,  0, 1274 }, {   7,  0, 1386 }, { 146,  0,   87 },
  {   6,  0,  187 }, {   7,  0,   39 }, {   7,  0, 1203 }, {   8,  0,  380 },
  {  14,  0,  117 }, { 149,  0,   28 }, {   4, 10,  211 }, {   4, 10,  332 },
  {   5, 10,  335 }, {   6, 10,  238 }, {   7, 10,  269 }, {   7, 10,  811 },
  {   7, 10, 1797 }, {   8, 10,  836 }, {   9, 10,  507 }, { 141, 10,  242 },
  {   4,  0,  785 }, {   5,  0,  368 }, {   6,  0,  297 }, {   7,  0,  793 },
  { 139,  0,  938 }, {   7,  0,  464 }, {   8,  0,  558 }, {  11,  0,  105 },
  {  12,  0,  231 }, {  14,  0,  386 }, {  15,  0,  102 }, { 148,  0,   75 },
  { 133, 10, 1009 }, {   8,  0,  877 }, { 140,  0,  731 }, { 139, 11,  289 },
  {  10, 11,  249 }, { 139, 11,  209 }, { 132, 11,  561 }, { 134,  0, 1608 },
  { 132, 11,  760 }, { 134,  0, 1429 }, {   9, 11,  154 }, { 140, 11,  485 },
  {   5, 10,  228 }, {   6, 10,  203 }, {   7, 10,  156 }, {   8, 10,  347 },
  { 137, 10,  265 }, {   7,  0, 1010 }, {  11,  0,  733 }, {  11,  0,  759 },
  {  13,  0,   34 }, {  14,  0,  427 }, { 146,  0,   45 }, {   7, 10, 1131 },
  { 135, 10, 1468 }, { 136, 11,  255 }, {   7,  0, 1656 }, {   9,  0,  369 },
  {  10,  0,  338 }, {  10,  0,  490 }, {  11,  0,  154 }, {  11,  0,  545 },
  {  11,  0,  775 }, {  13,  0,   77 }, { 141,  0,  274 }, { 133, 11,  621 },
  { 134,  0, 1038 }, {   4, 11,  368 }, { 135, 11,  641 }, {   6,  0, 2010 },
  {   8,  0,  979 }, {   8,  0,  985 }, {  10,  0,  951 }, { 138,  0, 1011 },
  { 134,  0, 1005 }, {  19,  0,  121 }, {   5, 10,  291 }, {   5, 10,  318 },
  {   7, 10,  765 }, {   9, 10,  389 }, { 140, 10,  548 }, {   5,  0,   20 },
  {   6,  0,  298 }, {   7,  0,  659 }, { 137,  0,  219 }, {   7,  0, 1440 },
  {  11,  0,  854 }, {  11,  0,  872 }, {  11,  0,  921 }, {  12,  0,  551 },
  {  13,  0,  472 }, { 142,  0,  367 }, {   5,  0,  490 }, {   6,  0,  615 },
  {   6,  0,  620 }, { 135,  0,  683 }, {   6,  0, 1070 }, { 134,  0, 1597 },
  { 139,  0,  522 }, { 132,  0,  439 }, { 136,  0,  669 }, {   6,  0,  766 },
  {   6,  0, 1143 }, {   6,  0, 1245 }, {  10, 10,  525 }, { 139, 10,   82 },
  {   9, 11,   92 }, { 147, 11,   91 }, {   6,  0,  668 }, { 134,  0, 1218 },
  {   6, 11,  525 }, {   9, 11,  876 }, { 140, 11,  284 }, { 132,  0,  233 },
  { 136,  0,  547 }, { 132, 10,  422 }, {   5, 10,  355 }, { 145, 10,    0 },
  {   6, 11,  300 }, { 135, 11, 1515 }, {   4,  0,  482 }, { 137, 10,  905 },
  {   4,  0,  886 }, {   7,  0,  346 }, { 133, 11,  594 }, { 133, 10,  865 },
  {   5, 10,  914 }, { 134, 10, 1625 }, { 135,  0,  334 }, {   5,  0,  795 },
  {   6,  0, 1741 }, { 133, 10,  234 }, { 135, 10, 1383 }, {   6, 11, 1641 },
  { 136, 11,  820 }, { 135,  0,  371 }, {   7, 11, 1313 }, { 138, 11,  660 },
  { 135, 10, 1312 }, { 135,  0,  622 }, {   7,  0,  625 }, { 135,  0, 1750 },
  { 135,  0,  339 }, {   4,  0,  203 }, { 135,  0, 1936 }, {  15,  0,   29 },
  {  16,  0,   38 }, {  15, 11,   29 }, { 144, 11,   38 }, {   5,  0,  338 },
  { 135,  0, 1256 }, { 135, 10, 1493 }, {  10,  0,  130 }, {   6, 10,  421 },
  {   7, 10,   61 }, {   7, 10, 1540 }, { 138, 10,  501 }, {   6, 11,  389 },
  {   7, 11,  149 }, {   9, 11,  142 }, { 138, 11,   94 }, { 137, 10,  341 },
  {  11,  0,  678 }, {  12,  0,  307 }, { 142, 10,   98 }, {   6, 11,    8 },
  {   7, 11, 1881 }, { 136, 11,   91 }, { 135,  0, 2044 }, {   6,  0,  770 },
  {   6,  0,  802 }, {   6,  0,  812 }, {   7,  0,  311 }, {   9,  0,  308 },
  {  12,  0,  255 }, {   6, 10,  102 }, {   7, 10,   72 }, {  15, 10,  142 },
  { 147, 10,   67 }, { 151, 10,   30 }, { 135, 10,  823 }, { 135,  0, 1266 },
  { 135, 11, 1746 }, { 135, 10, 1870 }, {   4,  0,  400 }, {   5,  0,  267 },
  { 135,  0,  232 }, {   7, 11,   24 }, {  11, 11,  542 }, { 139, 11,  852 },
  { 135, 11, 1739 }, {   4, 11,  503 }, { 135, 11, 1661 }, {   5, 11,  130 },
  {   7, 11, 1314 }, {   9, 11,  610 }, {  10, 11,  718 }, {  11, 11,  601 },
  {  11, 11,  819 }, {  11, 11,  946 }, { 140, 11,  536 }, {  10, 11,  149 },
  {  11, 11,  280 }, { 142, 11,  336 }, {   7,  0,  739 }, {  11,  0,  690 },
  {   7, 11, 1946 }, {   8, 10,   48 }, {   8, 10,   88 }, {   8, 10,  582 },
  {   8, 10,  681 }, {   9, 10,  373 }, {   9, 10,  864 }, {  11, 10,  157 },
  {  11, 10,  843 }, { 148, 10,   27 }, { 134,  0,  990 }, {   4, 10,   88 },
  {   5, 10,  137 }, {   5, 10,  174 }, {   5, 10,  777 }, {   6, 10, 1664 },
  {   6, 10, 1725 }, {   7, 10,   77 }, {   7, 10,  426 }, {   7, 10, 1317 },
  {   7, 10, 1355 }, {   8, 10,  126 }, {   8, 10,  563 }, {   9, 10,  523 },
  {   9, 10,  750 }, {  10, 10,  310 }, {  10, 10,  836 }, {  11, 10,   42 },
  {  11, 10,  318 }, {  11, 10,  731 }, {  12, 10,   68 }, {  12, 10,   92 },
  {  12, 10,  507 }, {  12, 10,  692 }, {  13, 10,   81 }, {  13, 10,  238 },
  {  13, 10,  374 }, {  14, 10,  436 }, {  18, 10,  138 }, {  19, 10,   78 },
  {  19, 10,  111 }, {  20, 10,   55 }, {  20, 10,   77 }, { 148, 10,   92 },
  { 141, 10,  418 }, {   7,  0, 1831 }, { 132, 10,  938 }, {   6,  0,  776 },
  { 134,  0,  915 }, { 138, 10,  351 }, {   5, 11,  348 }, {   6, 11,  522 },
  {   6, 10, 1668 }, {   7, 10, 1499 }, {   8, 10,  117 }, {   9, 10,  314 },
  { 138, 10,  174 }, { 135, 10,  707 }, { 132,  0,  613 }, { 133, 10,  403 },
  { 132, 11,  392 }, {   5, 11,  433 }, {   9, 11,  633 }, { 139, 11,  629 },
  { 133,  0,  763 }, { 132,  0,  878 }, { 132,  0,  977 }, { 132,  0,  100 },
  {   6,  0,  463 }, {   4, 10,   44 }, {   5, 10,  311 }, {   7, 10,  639 },
  {   7, 10,  762 }, {   7, 10, 1827 }, {   9, 10,    8 }, {   9, 10,  462 },
  { 148, 10,   83 }, { 134, 11,  234 }, {   4, 10,  346 }, {   7, 10,  115 },
  {   9, 10,  180 }, {   9, 10,  456 }, { 138, 10,  363 }, {   5,  0,  362 },
  {   5,  0,  443 }, {   6,  0,  318 }, {   7,  0, 1019 }, { 139,  0,  623 },
  {   5,  0,  463 }, {   8,  0,  296 }, {   7, 11,  140 }, {   7, 11, 1950 },
  {   8, 11,  680 }, {  11, 11,  817 }, { 147, 11,   88 }, {   7, 11, 1222 },
  { 138, 11,  386 }, { 142,  0,  137 }, { 132,  0,  454 }, {   7,  0, 1914 },
  {   6, 11,    5 }, {   7, 10, 1051 }, {   9, 10,  545 }, {  11, 11,  249 },
  {  12, 11,  313 }, {  16, 11,   66 }, { 145, 11,   26 }, { 135,  0, 1527 },
  { 145,  0,   58 }, { 148, 11,   59 }, {   5,  0,   48 }, {   5,  0,  404 },
  {   6,  0,  557 }, {   7,  0,  458 }, {   8,  0,  597 }, {  10,  0,  455 },
  {  10,  0,  606 }, {  11,  0,   49 }, {  11,  0,  548 }, {  12,  0,  476 },
  {  13,  0,   18 }, { 141,  0,  450 }, {   5, 11,  963 }, { 134, 11, 1773 },
  { 133,  0,  729 }, { 138, 11,  586 }, {   5,  0,  442 }, { 135,  0, 1984 },
  { 134,  0,  449 }, { 144,  0,   40 }, {   4,  0,  853 }, {   7, 11,  180 },
  {   8, 11,  509 }, { 136, 11,  792 }, {   6, 10,  185 }, {   7, 10, 1899 },
  {   9, 10,  875 }, { 139, 10,  673 }, { 134, 11,  524 }, {  12,  0,  227 },
  {   4, 10,  327 }, {   5, 10,  478 }, {   7, 10, 1332 }, { 136, 10,  753 },
  {   6,  0, 1491 }, {   5, 10, 1020 }, { 133, 10, 1022 }, {   4, 10,  103 },
  { 133, 10,  401 }, { 132, 11,  931 }, {   4, 10,  499 }, { 135, 10, 1421 },
  {   5,  0,   55 }, {   7,  0,  376 }, { 140,  0,  161 }, { 133,  0,  450 },
  {   6,  0, 1174 }, { 134,  0, 1562 }, {  10,  0,   62 }, {  13,  0,  400 },
  { 135, 11, 1837 }, { 140,  0,  207 }, { 135,  0,  869 }, {   4, 11,  773 },
  {   5, 11,  618 }, { 137, 11,  756 }, { 132, 10,   96 }, {   4,  0,  213 },
  {   7,  0,  223 }, {   8,  0,   80 }, { 135, 10,  968 }, {   4, 11,   90 },
  {   5, 11,  337 }, {   5, 11,  545 }, {   7, 11,  754 }, {   9, 11,  186 },
  {  10, 11,   72 }, {  10, 11,  782 }, {  11, 11,  513 }, {  11, 11,  577 },
  {  11, 11,  610 }, {  11, 11,  889 }, {  11, 11,  961 }, {  12, 11,  354 },
  {  12, 11,  362 }, {  12, 11,  461 }, {  12, 11,  595 }, {  13, 11,   79 },
  { 143, 11,  121 }, {   7,  0,  381 }, {   7,  0,  806 }, {   7,  0,  820 },
  {   8,  0,  354 }, {   8,  0,  437 }, {   8,  0,  787 }, {   9,  0,  657 },
  {  10,  0,   58 }, {  10,  0,  339 }, {  10,  0,  749 }, {  11,  0,  914 },
  {  12,  0,  162 }, {  13,  0,   75 }, {  14,  0,  106 }, {  14,  0,  198 },
  {  14,  0,  320 }, {  14,  0,  413 }, { 146,  0,   43 }, { 136,  0,  747 },
  { 136,  0,  954 }, { 134,  0, 1073 }, { 135,  0,  556 }, {   7, 11,  151 },
  {   9, 11,  329 }, { 139, 11,  254 }, {   5,  0,  692 }, { 134,  0, 1395 },
  {   6, 10,  563 }, { 137, 10,  224 }, { 134,  0,  191 }, { 132,  0,  804 },
  {   9, 11,  187 }, {  10, 11,   36 }, {  17, 11,   44 }, { 146, 11,   64 },
  {   7, 11,  165 }, {   7, 11,  919 }, { 136, 11,  517 }, {   4, 11,  506 },
  {   5, 11,  295 }, {   7, 11, 1680 }, {  15, 11,   14 }, { 144, 11,    5 },
  {   4,  0,  706 }, {   6,  0,  162 }, {   7,  0, 1960 }, { 136,  0,  831 },
  { 135, 11, 1376 }, {   7, 11,  987 }, {   9, 11,  688 }, {  10, 11,  522 },
  {  11, 11,  788 }, { 140, 11,  566 }, { 150,  0,   35 }, { 138,  0,  426 },
  { 135,  0, 1235 }, { 135, 11, 1741 }, {   7, 11,  389 }, {   7, 11,  700 },
  {   7, 11,  940 }, {   8, 11,  514 }, {   9, 11,  116 }, {   9, 11,  535 },
  {  10, 11,  118 }, {  11, 11,  107 }, {  11, 11,  148 }, {  11, 11,  922 },
  {  12, 11,  254 }, {  12, 11,  421 }, { 142, 11,  238 }, { 134,  0, 1234 },
  { 132, 11,  743 }, {   4, 10,  910 }, {   5, 10,  832 }, { 135, 11, 1335 },
  { 141,  0,   96 }, { 135, 11,  185 }, { 146,  0,  149 }, {   4,  0,  204 },
  { 137,  0,  902 }, {   4, 11,  784 }, { 133, 11,  745 }, { 136,  0,  833 },
  { 136,  0,  949 }, {   7,  0,  366 }, {   9,  0,  287 }, {  12,  0,  199 },
  {  12,  0,  556 }, {  12,  0,  577 }, {   5, 11,   81 }, {   7, 11,  146 },
  {   7, 11, 1342 }, {   7, 11, 1446 }, {   8, 11,   53 }, {   8, 11,  561 },
  {   8, 11,  694 }, {   8, 11,  754 }, {   9, 11,   97 }, {   9, 11,  115 },
  {   9, 11,  894 }, {  10, 11,  462 }, {  10, 11,  813 }, {  11, 11,  230 },
  {  11, 11,  657 }, {  11, 11,  699 }, {  11, 11,  748 }, {  12, 11,  119 },
  {  12, 11,  200 }, {  12, 11,  283 }, {  14, 11,  273 }, { 145, 11,   15 },
  {   5, 11,  408 }, { 137, 11,  747 }, {   9, 11,  498 }, { 140, 11,  181 },
  {   6,  0, 2020 }, { 136,  0,  992 }, {   5,  0,  356 }, { 135,  0,  224 },
  { 134,  0,  784 }, {   7,  0,  630 }, {   9,  0,  567 }, {  11,  0,  150 },
  {  11,  0,  444 }, {  13,  0,  119 }, {   8, 10,  528 }, { 137, 10,  348 },
  { 134,  0,  539 }, {   4, 10,   20 }, { 133, 10,  616 }, { 142,  0,   27 },
  {   7, 11,   30 }, {   8, 11,   86 }, {   8, 11,  315 }, {   8, 11,  700 },
  {   9, 11,  576 }, {   9, 11,  858 }, {  11, 11,  310 }, {  11, 11,  888 },
  {  11, 11,  904 }, {  12, 11,  361 }, { 141, 11,  248 }, { 138, 11,  839 },
  { 134,  0,  755 }, { 134,  0, 1063 }, {   7, 10, 1091 }, { 135, 10, 1765 },
  { 134, 11,  428 }, {   7, 11,  524 }, {   8, 11,  169 }, {   8, 11,  234 },
  {   9, 11,  480 }, { 138, 11,  646 }, { 139,  0,  814 }, {   7, 11, 1462 },
  { 139, 11,  659 }, {   4, 10,   26 }, {   5, 10,  429 }, {   6, 10,  245 },
  {   7, 10,  704 }, {   7, 10, 1379 }, { 135, 10, 1474 }, {   7, 11, 1205 },
  { 138, 11,  637 }, { 139, 11,  803 }, { 132, 10,  621 }, { 136,  0,  987 },
  {   4, 11,  266 }, {   8, 11,    4 }, {   9, 11,   39 }, {  10, 11,  166 },
  {  11, 11,  918 }, {  12, 11,  635 }, {  20, 11,   10 }, {  22, 11,   27 },
  { 150, 11,   43 }, {   4,  0,  235 }, { 135,  0,  255 }, {   4,  0,  194 },
  {   5,  0,  584 }, {   6,  0,  384 }, {   7,  0,  583 }, {  10,  0,  761 },
  {  11,  0,  760 }, { 139,  0,  851 }, { 133, 10,  542 }, { 134,  0, 1086 },
  { 133, 10,  868 }, {   8,  0, 1016 }, { 136,  0, 1018 }, {   7,  0, 1396 },
  {   7, 11, 1396 }, { 136, 10,  433 }, { 135, 10, 1495 }, { 138, 10,  215 },
  { 141, 10,  124 }, {   7, 11,  157 }, {   8, 11,  279 }, {   9, 11,  759 },
  {  16, 11,   31 }, {  16, 11,   39 }, {  16, 11,   75 }, {  18, 11,   24 },
  {  20, 11,   42 }, { 152, 11,    1 }, {   5,  0,  562 }, { 134, 11,  604 },
  { 134,  0,  913 }, {   5,  0,  191 }, { 137,  0,  271 }, {   4,  0,  470 },
  {   6,  0,  153 }, {   7,  0, 1503 }, {   7,  0, 1923 }, {  10,  0,  701 },
  {  11,  0,  132 }, {  11,  0,  227 }, {  11,  0,  320 }, {  11,  0,  436 },
  {  11,  0,  525 }, {  11,  0,  855 }, {  11,  0,  873 }, {  12,  0,   41 },
  {  12,  0,  286 }, {  13,  0,  103 }, {  13,  0,  284 }, {  14,  0,  255 },
  {  14,  0,  262 }, {  15,  0,  117 }, { 143,  0,  127 }, {   7,  0,  475 },
  {  12,  0,   45 }, { 147, 10,  112 }, { 132, 11,  567 }, { 137, 11,  859 },
  {   6,  0,  713 }, {   6,  0,  969 }, {   6,  0, 1290 }, { 134,  0, 1551 },
  { 133,  0,  327 }, {   6,  0,  552 }, {   6,  0, 1292 }, {   7,  0, 1754 },
  { 137,  0,  604 }, {   4,  0,  223 }, {   6,  0,  359 }, {  11,  0,    3 },
  {  13,  0,  108 }, {  14,  0,   89 }, {  16,  0,   22 }, {   5, 11,  762 },
  {   7, 11, 1880 }, {   9, 11,  680 }, { 139, 11,  798 }, {   5,  0,   80 },
  {   6,  0,  405 }, {   7,  0,  403 }, {   7,  0, 1502 }, {   8,  0,  456 },
  {   9,  0,  487 }, {   9,  0,  853 }, {   9,  0,  889 }, {  10,  0,  309 },
  {  11,  0,  721 }, {  11,  0,  994 }, {  12,  0,  430 }, { 141,  0,  165 },
  { 133, 11,  298 }, { 132, 10,  647 }, { 134,  0, 2016 }, {  18, 10,   10 },
  { 146, 11,   10 }, {   4,  0,  453 }, {   5,  0,  887 }, {   6,  0,  535 },
  {   8,  0,    6 }, {   8,  0,  543 }, { 136,  0,  826 }, { 136,  0,  975 },
  {  10,  0,  961 }, { 138,  0,  962 }, { 138, 10,  220 }, {   6,  0, 1891 },
  {   6,  0, 1893 }, {   9,  0,  916 }, {   9,  0,  965 }, {   9,  0,  972 },
  {  12,  0,  801 }, {  12,  0,  859 }, {  12,  0,  883 }, {  15,  0,  226 },
  { 149,  0,   51 }, { 132, 10,  109 }, { 135, 11,  267 }, {   7, 11,   92 },
  {   7, 11,  182 }, {   8, 11,  453 }, {   9, 11,  204 }, {  11, 11,  950 },
  {  12, 11,   94 }, {  12, 11,  644 }, {  16, 11,   20 }, {  16, 11,   70 },
  {  16, 11,   90 }, { 147, 11,   55 }, { 134, 10, 1746 }, {   6, 11,   71 },
  {   7, 11,  845 }, {   7, 11, 1308 }, {   8, 11,  160 }, { 137, 11,  318 },
  {   5,  0,  101 }, {   6,  0,   88 }, {   7,  0,  263 }, {   7,  0,  628 },
  {   7,  0, 1677 }, {   8,  0,  349 }, {   9,  0,  100 }, {  10,  0,  677 },
  {  14,  0,  169 }, {  14,  0,  302 }, {  14,  0,  313 }, {  15,  0,   48 },
  {  15,  0,   84 }, {   7, 11,  237 }, {   8, 11,  664 }, {   9, 11,   42 },
  {   9, 11,  266 }, {   9, 11,  380 }, {   9, 11,  645 }, {  10, 11,  177 },
  { 138, 11,  276 }, { 138, 11,   69 }, {   4,  0,  310 }, {   7,  0,  708 },
  {   7,  0,  996 }, {   9,  0,  795 }, {  10,  0,  390 }, {  10,  0,  733 },
  {  11,  0,  451 }, {  12,  0,  249 }, {  14,  0,  115 }, {  14,  0,  286 },
  { 143,  0,  100 }, {   5,  0,  587 }, {   4, 10,   40 }, {  10, 10,   67 },
  {  11, 10,  117 }, {  11, 10,  768 }, { 139, 10,  935 }, {   6,  0, 1942 },
  {   7,  0,  512 }, { 136,  0,  983 }, {   7, 10,  992 }, {   8, 10,  301 },
  {   9, 10,  722 }, {  12, 10,   63 }, {  13, 10,   29 }, {  14, 10,  161 },
  { 143, 10,   18 }, { 136, 11,   76 }, { 139, 10,  923 }, { 134,  0,  645 },
  { 134,  0,  851 }, {   4,  0,  498 }, { 132, 11,  293 }, {   7,  0,  217 },
  {   8,  0,  140 }, {  10,  0,  610 }, {  14, 11,  352 }, {  17, 11,   53 },
  {  18, 11,  146 }, {  18, 11,  152 }, {  19, 11,   11 }, { 150, 11,   54 },
  { 134,  0, 1448 }, { 138, 11,  841 }, { 133,  0,  905 }, {   4, 11,  605 },
  {   7, 11,  518 }, {   7, 11, 1282 }, {   7, 11, 1918 }, {  10, 11,  180 },
  { 139, 11,  218 }, { 139, 11,  917 }, { 135, 10,  825 }, { 140, 10,  328 },
  {   4,  0,  456 }, {   7,  0,  105 }, {   7,  0,  358 }, {   7,  0, 1637 },
  {   8,  0,  643 }, { 139,  0,  483 }, { 134,  0,  792 }, {   6, 11,   96 },
  { 135, 11, 1426 }, { 137, 11,  691 }, {   4, 11,  651 }, { 133, 11,  289 },
  {   7, 11,  688 }, {   8, 11,   35 }, {   9, 11,  511 }, {  10, 11,  767 },
  { 147, 11,  118 }, { 150,  0,   56 }, {   5,  0,  243 }, {   5,  0,  535 },
  {   6, 10,  204 }, {  10, 10,  320 }, {  10, 10,  583 }, {  13, 10,  502 },
  {  14, 10,   72 }, {  14, 10,  274 }, {  14, 10,  312 }, {  14, 10,  344 },
  {  15, 10,  159 }, {  16, 10,   62 }, {  16, 10,   69 }, {  17, 10,   30 },
  {  18, 10,   42 }, {  18, 10,   53 }, {  18, 10,   84 }, {  18, 10,  140 },
  {  19, 10,   68 }, {  19, 10,   85 }, {  20, 10,    5 }, {  20, 10,   45 },
  {  20, 10,  101 }, {  22, 10,    7 }, { 150, 10,   20 }, {   4, 10,  558 },
  {   6, 10,  390 }, {   7, 10,  162 }, {   7, 10,  689 }, {   9, 10,  360 },
  { 138, 10,  653 }, { 146, 11,   23 }, { 135,  0, 1748 }, {   5, 10,  856 },
  {   6, 10, 1672 }, {   6, 10, 1757 }, { 134, 10, 1781 }, {   5,  0,  539 },
  {   5,  0,  754 }, {   6,  0,  876 }, { 132, 11,  704 }, { 135, 11, 1078 },
  {   5, 10,   92 }, {  10, 10,  736 }, { 140, 10,  102 }, {  17,  0,   91 },
  {   5, 10,  590 }, { 137, 10,  213 }, { 134,  0, 1565 }, {   6,  0,   91 },
  { 135,  0,  435 }, {   4,  0,  939 }, { 140,  0,  792 }, { 134,  0, 1399 },
  {   4,  0,   16 }, {   5,  0,  316 }, {   5,  0,  842 }, {   6,  0,  370 },
  {   6,  0, 1778 }, {   8,  0,  166 }, {  11,  0,  812 }, {  12,  0,  206 },
  {  12,  0,  351 }, {  14,  0,  418 }, {  16,  0,   15 }, {  16,  0,   34 },
  {  18,  0,    3 }, {  19,  0,    3 }, {  19,  0,    7 }, {  20,  0,    4 },
  {  21,  0,   21 }, {   4, 11,  720 }, { 133, 11,  306 }, { 144,  0,   95 },
  { 133, 11,  431 }, { 132, 11,  234 }, { 135,  0,  551 }, {   4,  0,  999 },
  {   6,  0, 1966 }, { 134,  0, 2042 }, {   7,  0,  619 }, {  10,  0,  547 },
  {  11,  0,  122 }, {  12,  0,  601 }, {  15,  0,    7 }, { 148,  0,   20 },
  {   5, 11,  464 }, {   6, 11,  236 }, {   7, 11,  276 }, {   7, 11,  696 },
  {   7, 11,  914 }, {   7, 11, 1108 }, {   7, 11, 1448 }, {   9, 11,   15 },
  {   9, 11,  564 }, {  10, 11,   14 }, {  12, 11,  565 }, {  13, 11,  449 },
  {  14, 11,   53 }, {  15, 11,   13 }, {  16, 11,   64 }, { 145, 11,   41 },
  {   6,  0,  884 }, {   6,  0, 1019 }, { 134,  0, 1150 }, {   6, 11, 1767 },
  {  12, 11,  194 }, { 145, 11,  107 }, { 136, 10,  503 }, { 133, 11,  840 },
  {   7,  0,  671 }, { 134, 10,  466 }, { 132,  0,  888 }, {   4,  0,  149 },
  { 138,  0,  368 }, {   4,  0,  154 }, {   7,  0, 1134 }, { 136,  0,  105 },
  { 135,  0,  983 }, {   9, 11,  642 }, {  11, 11,  236 }, { 142, 11,  193 },
  {   4,  0,   31 }, {   6,  0,  429 }, {   7,  0,  962 }, {   9,  0,  458 },
  { 139,  0,  691 }, {   6,  0,  643 }, { 134,  0, 1102 }, { 132,  0,  312 },
  {   4, 11,   68 }, {   5, 11,  634 }, {   6, 11,  386 }, {   7, 11,  794 },
  {   8, 11,  273 }, {   9, 11,  563 }, {  10, 11,  105 }, {  10, 11,  171 },
  {  11, 11,   94 }, { 139, 11,  354 }, { 133,  0,  740 }, { 135,  0, 1642 },
  {   4, 11,   95 }, {   7, 11,  416 }, {   8, 11,  211 }, { 139, 11,  830 },
  { 132,  0,  236 }, { 138, 10,  241 }, {   7, 11,  731 }, {  13, 11,   20 },
  { 143, 11,   11 }, {   5,  0,  836 }, {   5,  0,  857 }, {   6,  0, 1680 },
  { 135,  0,   59 }, {  10,  0,   68 }, {  11,  0,  494 }, { 152, 11,    6 },
  {   4,  0,   81 }, { 139,  0,  867 }, { 135,  0,  795 }, { 133, 11,  689 },
  {   4,  0, 1001 }, {   5,  0,  282 }, {   6,  0, 1932 }, {   6,  0, 1977 },
  {   6,  0, 1987 }, {   6,  0, 1992 }, {   8,  0,  650 }, {   8,  0,  919 },
  {   8,  0,  920 }, {   8,  0,  923 }, {   8,  0,  926 }, {   8,  0,  927 },
  {   8,  0,  931 }, {   8,  0,  939 }, {   8,  0,  947 }, {   8,  0,  956 },
  {   8,  0,  997 }, {   9,  0,  907 }, {  10,  0,  950 }, {  10,  0,  953 },
  {  10,  0,  954 }, {  10,  0,  956 }, {  10,  0,  958 }, {  10,  0,  959 },
  {  10,  0,  964 }, {  10,  0,  970 }, {  10,  0,  972 }, {  10,  0,  973 },
  {  10,  0,  975 }, {  10,  0,  976 }, {  10,  0,  980 }, {  10,  0,  981 },
  {  10,  0,  984 }, {  10,  0,  988 }, {  10,  0,  990 }, {  10,  0,  995 },
  {  10,  0,  999 }, {  10,  0, 1002 }, {  10,  0, 1003 }, {  10,  0, 1005 },
  {  10,  0, 1006 }, {  10,  0, 1008 }, {  10,  0, 1009 }, {  10,  0, 1012 },
  {  10,  0, 1014 }, {  10,  0, 1015 }, {  10,  0, 1019 }, {  10,  0, 1020 },
  {  10,  0, 1022 }, {  12,  0,  959 }, {  12,  0,  961 }, {  12,  0,  962 },
  {  12,  0,  963 }, {  12,  0,  964 }, {  12,  0,  965 }, {  12,  0,  967 },
  {  12,  0,  968 }, {  12,  0,  969 }, {  12,  0,  970 }, {  12,  0,  971 },
  {  12,  0,  972 }, {  12,  0,  973 }, {  12,  0,  974 }, {  12,  0,  975 },
  {  12,  0,  976 }, {  12,  0,  977 }, {  12,  0,  979 }, {  12,  0,  981 },
  {  12,  0,  982 }, {  12,  0,  983 }, {  12,  0,  984 }, {  12,  0,  985 },
  {  12,  0,  986 }, {  12,  0,  987 }, {  12,  0,  989 }, {  12,  0,  990 },
  {  12,  0,  992 }, {  12,  0,  993 }, {  12,  0,  995 }, {  12,  0,  998 },
  {  12,  0,  999 }, {  12,  0, 1000 }, {  12,  0, 1001 }, {  12,  0, 1002 },
  {  12,  0, 1004 }, {  12,  0, 1005 }, {  12,  0, 1006 }, {  12,  0, 1007 },
  {  12,  0, 1008 }, {  12,  0, 1009 }, {  12,  0, 1010 }, {  12,  0, 1011 },
  {  12,  0, 1012 }, {  12,  0, 1014 }, {  12,  0, 1015 }, {  12,  0, 1016 },
  {  12,  0, 1017 }, {  12,  0, 1018 }, {  12,  0, 1019 }, {  12,  0, 1022 },
  {  12,  0, 1023 }, {  14,  0,  475 }, {  14,  0,  477 }, {  14,  0,  478 },
  {  14,  0,  479 }, {  14,  0,  480 }, {  14,  0,  482 }, {  14,  0,  483 },
  {  14,  0,  484 }, {  14,  0,  485 }, {  14,  0,  486 }, {  14,  0,  487 },
  {  14,  0,  488 }, {  14,  0,  489 }, {  14,  0,  490 }, {  14,  0,  491 },
  {  14,  0,  492 }, {  14,  0,  493 }, {  14,  0,  494 }, {  14,  0,  495 },
  {  14,  0,  496 }, {  14,  0,  497 }, {  14,  0,  498 }, {  14,  0,  499 },
  {  14,  0,  500 }, {  14,  0,  501 }, {  14,  0,  502 }, {  14,  0,  503 },
  {  14,  0,  504 }, {  14,  0,  506 }, {  14,  0,  507 }, {  14,  0,  508 },
  {  14,  0,  509 }, {  14,  0,  510 }, {  14,  0,  511 }, {  16,  0,  113 },
  {  16,  0,  114 }, {  16,  0,  115 }, {  16,  0,  117 }, {  16,  0,  118 },
  {  16,  0,  119 }, {  16,  0,  121 }, {  16,  0,  122 }, {  16,  0,  123 },
  {  16,  0,  124 }, {  16,  0,  125 }, {  16,  0,  126 }, {  16,  0,  127 },
  {  18,  0,  242 }, {  18,  0,  243 }, {  18,  0,  244 }, {  18,  0,  245 },
  {  18,  0,  248 }, {  18,  0,  249 }, {  18,  0,  250 }, {  18,  0,  251 },
  {  18,  0,  252 }, {  18,  0,  253 }, {  18,  0,  254 }, {  18,  0,  255 },
  {  20,  0,  125 }, {  20,  0,  126 }, { 148,  0,  127 }, {   7, 11, 1717 },
  {   7, 11, 1769 }, { 138, 11,  546 }, {   7, 11, 1127 }, {   7, 11, 1572 },
  {  10, 11,  297 }, {  10, 11,  422 }, {  11, 11,  764 }, {  11, 11,  810 },
  {  12, 11,  264 }, {  13, 11,  102 }, {  13, 11,  300 }, {  13, 11,  484 },
  {  14, 11,  147 }, {  14, 11,  229 }, {  17, 11,   71 }, {  18, 11,  118 },
  { 147, 11,  120 }, {   6,  0, 1148 }, { 134,  0, 1586 }, { 132,  0,  775 },
  { 135, 10,  954 }, { 133, 11,  864 }, { 133, 11,  928 }, { 138, 11,  189 },
  { 135, 10, 1958 }, {   6, 10,  549 }, {   8, 10,   34 }, {   8, 10,  283 },
  {   9, 10,  165 }, { 138, 10,  475 }, {   5, 10,  652 }, {   5, 10,  701 },
  { 135, 10,  449 }, { 135, 11,  695 }, {   4, 10,  655 }, {   7, 10,  850 },
  {  17, 10,   75 }, { 146, 10,  137 }, { 140, 11,  682 }, { 133, 11,  523 },
  {   8,  0,  970 }, { 136, 10,  670 }, { 136, 11,  555 }, {   7, 11,   76 },
  {   8, 11,   44 }, {   9, 11,  884 }, {  10, 11,  580 }, {  11, 11,  399 },
  {  11, 11,  894 }, {  15, 11,  122 }, {  18, 11,  144 }, { 147, 11,   61 },
  {   6, 10,  159 }, {   6, 10,  364 }, {   7, 10,  516 }, {   7, 10, 1439 },
  { 137, 10,  518 }, {   4,  0,   71 }, {   5,  0,  376 }, {   7,  0,  119 },
  { 138,  0,  665 }, { 141, 10,  151 }, {  11,  0,  827 }, {  14,  0,   34 },
  { 143,  0,  148 }, { 133, 11,  518 }, {   4,  0,  479 }, { 135, 11, 1787 },
  { 135, 11, 1852 }, { 135, 10,  993 }, {   7,  0,  607 }, { 136,  0,   99 },
  { 134,  0, 1960 }, { 132,  0,  793 }, {   4,  0,   41 }, {   5,  0,   74 },
  {   7,  0, 1627 }, {  11,  0,  871 }, { 140,  0,  619 }, {   7,  0,   94 },
  {  11,  0,  329 }, {  11,  0,  965 }, {  12,  0,  241 }, {  14,  0,  354 },
  {  15,  0,   22 }, { 148,  0,   63 }, {   7, 10,  501 }, {   9, 10,  111 },
  {  10, 10,  141 }, {  11, 10,  332 }, {  13, 10,   43 }, {  13, 10,  429 },
  {  14, 10,  130 }, {  14, 10,  415 }, { 145, 10,  102 }, {   9,  0,  209 },
  { 137,  0,  300 }, { 134,  0, 1497 }, { 138, 11,  255 }, {   4, 11,  934 },
  {   5, 11,  138 }, { 136, 11,  610 }, { 133,  0,   98 }, {   6,  0, 1316 },
  {  10, 11,  804 }, { 138, 11,  832 }, {   8, 11,   96 }, {   9, 11,   36 },
  {  10, 11,  607 }, {  11, 11,  423 }, {  11, 11,  442 }, {  12, 11,  309 },
  {  14, 11,  199 }, {  15, 11,   90 }, { 145, 11,  110 }, { 132,  0,  463 },
  {   5, 10,  149 }, { 136, 10,  233 }, { 133, 10,  935 }, {   4, 11,  652 },
  {   8, 11,  320 }, {   9, 11,   13 }, {   9, 11,  398 }, {   9, 11,  727 },
  {  10, 11,   75 }, {  10, 11,  184 }, {  10, 11,  230 }, {  10, 11,  564 },
  {  10, 11,  569 }, {  11, 11,  973 }, {  12, 11,   70 }, {  12, 11,  189 },
  {  13, 11,   57 }, {  13, 11,  257 }, {  22, 11,    6 }, { 150, 11,   16 },
  { 142,  0,  291 }, {  12, 10,  582 }, { 146, 10,  131 }, { 136, 10,  801 },
  { 133,  0,  984 }, { 145, 11,  116 }, {   4, 11,  692 }, { 133, 11,  321 },
  {   4,  0,  182 }, {   6,  0,  205 }, { 135,  0,  220 }, {   4,  0,   42 },
  {   9,  0,  205 }, {   9,  0,  786 }, { 138,  0,  659 }, {   6,  0,  801 },
  {  11, 11,  130 }, { 140, 11,  609 }, { 132,  0,  635 }, {   5, 11,  345 },
  { 135, 11, 1016 }, { 139,  0,  533 }, { 132,  0,  371 }, {   4,  0,  272 },
  { 135,  0,  836 }, {   6,  0, 1282 }, { 135, 11, 1100 }, {   5,  0,  825 },
  { 134,  0, 1640 }, { 135, 11, 1325 }, { 133, 11,  673 }, {   4, 11,  287 },
  { 133, 11, 1018 }, { 135,  0,  357 }, {   6,  0,  467 }, { 137,  0,  879 },
  {   7,  0,  317 }, { 135,  0,  569 }, {   6,  0,  924 }, { 134,  0, 1588 },
  {   5, 11,   34 }, {   5, 10,  406 }, {  10, 11,  724 }, {  12, 11,  444 },
  {  13, 11,  354 }, {  18, 11,   32 }, {  23, 11,   24 }, {  23, 11,   31 },
  { 152, 11,    5 }, {   6,  0, 1795 }, {   6,  0, 1835 }, {   6,  0, 1836 },
  {   6,  0, 1856 }, {   8,  0,  844 }, {   8,  0,  849 }, {   8,  0,  854 },
  {   8,  0,  870 }, {   8,  0,  887 }, {  10,  0,  852 }, { 138,  0,  942 },
  {   6, 10,   69 }, { 135, 10,  117 }, { 137,  0,  307 }, {   4,  0,  944 },
  {   6,  0, 1799 }, {   6,  0, 1825 }, {  10,  0,  848 }, {  10,  0,  875 },
  {  10,  0,  895 }, {  10,  0,  899 }, {  10,  0,  902 }, { 140,  0,  773 },
  {  11,  0,   43 }, {  13,  0,   72 }, { 141,  0,  142 }, { 135, 10, 1830 },
  { 134, 11,  382 }, {   4, 10,  432 }, { 135, 10,  824 }, { 132, 11,  329 },
  {   7,  0, 1820 }, { 139, 11,  124 }, { 133, 10,  826 }, { 133,  0,  525 },
  { 132, 11,  906 }, {   7, 11, 1940 }, { 136, 11,  366 }, { 138, 11,   10 },
  {   4, 11,  123 }, {   4, 11,  649 }, {   5, 11,  605 }, {   7, 11, 1509 },
  { 136, 11,   36 }, {   6,  0,  110 }, { 135,  0, 1681 }, { 133,  0,  493 },
  { 133, 11,  767 }, {   4,  0,  174 }, { 135,  0,  911 }, { 138, 11,  786 },
  {   8,  0,  417 }, { 137,  0,  782 }, { 133, 10, 1000 }, {   7,  0,  733 },
  { 137,  0,  583 }, {   4, 10,  297 }, {   6, 10,  529 }, {   7, 10,  152 },
  {   7, 10,  713 }, {   7, 10, 1845 }, {   8, 10,  710 }, {   8, 10,  717 },
  {  12, 10,  639 }, { 140, 10,  685 }, {   4,  0,   32 }, {   5,  0,  215 },
  {   6,  0,  269 }, {   7,  0, 1782 }, {   7,  0, 1892 }, {  10,  0,   16 },
  {  11,  0,  822 }, {  11,  0,  954 }, { 141,  0,  481 }, {   4, 11,  273 },
  {   5, 11,  658 }, { 133, 11,  995 }, { 136,  0,  477 }, { 134, 11,   72 },
  { 135, 11, 1345 }, {   5,  0,  308 }, {   7,  0, 1088 }, {   4, 10,  520 },
  { 135, 10,  575 }, { 133, 11,  589 }, {   5,  0,  126 }, {   8,  0,  297 },
  {   9,  0,  366 }, { 140,  0,  374 }, {   7,  0, 1551 }, { 139,  0,  361 },
  {   5, 11,  117 }, {   6, 11,  514 }, {   6, 11,  541 }, {   7, 11, 1164 },
  {   7, 11, 1436 }, {   8, 11,  220 }, {   8, 11,  648 }, {  10, 11,  688 },
  { 139, 11,  560 }, { 133, 11,  686 }, {   4,  0,  946 }, {   6,  0, 1807 },
  {   8,  0,  871 }, {  10,  0,  854 }, {  10,  0,  870 }, {  10,  0,  888 },
  {  10,  0,  897 }, {  10,  0,  920 }, {  12,  0,  722 }, {  12,  0,  761 },
  {  12,  0,  763 }, {  12,  0,  764 }, {  14,  0,  454 }, {  14,  0,  465 },
  {  16,  0,  107 }, {  18,  0,  167 }, {  18,  0,  168 }, { 146,  0,  172 },
  { 132,  0,  175 }, { 135,  0, 1307 }, { 132,  0,  685 }, { 135, 11, 1834 },
  { 133,  0,  797 }, {   6,  0,  745 }, {   6,  0,  858 }, { 134,  0,  963 },
  { 133,  0,  565 }, {   5, 10,  397 }, {   6, 10,  154 }, {   7, 11,  196 },
  {   7, 10,  676 }, {   8, 10,  443 }, {   8, 10,  609 }, {   9, 10,   24 },
  {   9, 10,  325 }, {  10, 10,   35 }, {  10, 11,  765 }, {  11, 11,  347 },
  {  11, 10,  535 }, {  11, 11,  552 }, {  11, 11,  576 }, {  11, 10,  672 },
  {  11, 11,  790 }, {  11, 10, 1018 }, {  12, 11,  263 }, {  12, 10,  637 },
  {  13, 11,  246 }, {  13, 11,  270 }, {  13, 11,  395 }, {  14, 11,   74 },
  {  14, 11,  176 }, {  14, 11,  190 }, {  14, 11,  398 }, {  14, 11,  412 },
  {  15, 11,   32 }, {  15, 11,   63 }, {  16, 10,   30 }, {  16, 11,   88 },
  { 147, 11,  105 }, {  13, 11,   84 }, { 141, 11,  122 }, {   4,  0,  252 },
  {   7,  0, 1068 }, {  10,  0,  434 }, {  11,  0,  228 }, {  11,  0,  426 },
  {  13,  0,  231 }, {  18,  0,  106 }, { 148,  0,   87 }, { 137,  0,  826 },
  {   4, 11,  589 }, { 139, 11,  282 }, {   5, 11,  381 }, { 135, 11, 1792 },
  { 132,  0,  791 }, {   5,  0,  231 }, {  10,  0,  509 }, { 133, 10,  981 },
  {   7,  0,  601 }, {   9,  0,  277 }, {   9,  0,  674 }, {  10,  0,  178 },
  {  10,  0,  418 }, {  10,  0,  571 }, {  11,  0,  531 }, {  12,  0,  113 },
  {  12,  0,  475 }, {  13,  0,   99 }, { 142,  0,  428 }, {   4, 10,   56 },
  {   7, 11,  616 }, {   7, 10, 1791 }, {   8, 10,  607 }, {   8, 10,  651 },
  {  10, 11,  413 }, {  11, 10,  465 }, {  11, 10,  835 }, {  12, 10,  337 },
  { 141, 10,  480 }, {   7,  0, 1591 }, { 144,  0,   43 }, {   9, 10,  158 },
  { 138, 10,  411 }, { 135,  0, 1683 }, {   8,  0,  289 }, {  11,  0,   45 },
  {  12,  0,  278 }, { 140,  0,  537 }, {   6, 11,  120 }, {   7, 11, 1188 },
  {   7, 11, 1710 }, {   8, 11,  286 }, {   9, 11,  667 }, {  11, 11,  592 },
  { 139, 11,  730 }, { 136, 10,  617 }, { 135,  0, 1120 }, { 135, 11, 1146 },
  { 139, 10,  563 }, {   4, 11,  352 }, {   4, 10,  369 }, { 135, 11,  687 },
  { 143, 11,   38 }, {   4,  0,  399 }, {   5,  0,  119 }, {   5,  0,  494 },
  {   7,  0,  751 }, {   9,  0,  556 }, {  14, 11,  179 }, {  15, 11,  151 },
  { 150, 11,   11 }, {   4, 11,  192 }, {   5, 11,   49 }, {   6, 11,  200 },
  {   6, 11,  293 }, {   6, 11, 1696 }, { 135, 11,  488 }, {   4,  0,  398 },
  { 133,  0,  660 }, {   7,  0, 1030 }, { 134, 10,  622 }, { 135, 11,  595 },
  { 141,  0,  168 }, { 132, 11,  147 }, {   7,  0,  973 }, {  10, 10,  624 },
  { 142, 10,  279 }, { 132, 10,  363 }, { 132,  0,  642 }, { 133, 11,  934 },
  { 134,  0, 1615 }, {   7, 11,  505 }, { 135, 11,  523 }, {   7,  0,  594 },
  {   7,  0,  851 }, {   7,  0, 1858 }, {   9,  0,  411 }, {   9,  0,  574 },
  {   9,  0,  666 }, {   9,  0,  737 }, {  10,  0,  346 }, {  10,  0,  712 },
  {  11,  0,  246 }, {  11,  0,  432 }, {  11,  0,  517 }, {  11,  0,  647 },
  {  11,  0,  679 }, {  11,  0,  727 }, {  12,  0,  304 }, {  12,  0,  305 },
  {  12,  0,  323 }, {  12,  0,  483 }, {  12,  0,  572 }, {  12,  0,  593 },
  {  12,  0,  602 }, {  13,  0,   95 }, {  13,  0,  101 }, {  13,  0,  171 },
  {  13,  0,  315 }, {  13,  0,  378 }, {  13,  0,  425 }, {  13,  0,  475 },
  {  14,  0,   63 }, {  14,  0,  380 }, {  14,  0,  384 }, {  15,  0,  133 },
  {  18,  0,  112 }, { 148,  0,   72 }, { 135,  0, 1093 }, { 132,  0,  679 },
  {   8,  0,  913 }, {  10,  0,  903 }, {  10,  0,  915 }, {  12,  0,  648 },
  {  12,  0,  649 }, {  14,  0,  455 }, {  16,  0,  112 }, { 138, 11,  438 },
  { 137,  0,  203 }, { 134, 10,  292 }, { 134,  0, 1492 }, {   7,  0, 1374 },
  {   8,  0,  540 }, {   5, 10,  177 }, {   6, 10,  616 }, {   7, 10,  827 },
  {   9, 10,  525 }, { 138, 10,  656 }, { 135,  0, 1486 }, {   9,  0,  714 },
  { 138, 10,   31 }, { 136,  0,  825 }, { 134,  0, 1511 }, { 132, 11,  637 },
  { 134,  0,  952 }, {   4, 10,  161 }, { 133, 10,  631 }, {   5,  0,  143 },
  {   5,  0,  769 }, {   6,  0, 1760 }, {   7,  0,  682 }, {   7,  0, 1992 },
  { 136,  0,  736 }, { 132,  0,  700 }, { 134,  0, 1540 }, { 132, 11,  777 },
  {   9, 11,  867 }, { 138, 11,  837 }, {   7,  0, 1557 }, { 135, 10, 1684 },
  { 133,  0,  860 }, {   6,  0,  422 }, {   7,  0,    0 }, {   7,  0, 1544 },
  {   9,  0,  605 }, {  11,  0,  990 }, {  12,  0,  235 }, {  12,  0,  453 },
  {  13,  0,   47 }, {  13,  0,  266 }, {   9, 10,  469 }, {   9, 10,  709 },
  {  12, 10,  512 }, {  14, 10,   65 }, { 145, 10,   12 }, {  11,  0,  807 },
  {  10, 10,  229 }, {  11, 10,   73 }, { 139, 10,  376 }, {   6, 11,  170 },
  {   7, 11, 1080 }, {   8, 11,  395 }, {   8, 11,  487 }, {  11, 11,  125 },
  { 141, 11,  147 }, {   5,  0,  515 }, { 137,  0,  131 }, {   7,  0, 1605 },
  {  11,  0,  962 }, { 146,  0,  139 }, { 132,  0,  646 }, {   4,  0,  396 },
  {   7,  0,  728 }, {   9,  0,  117 }, {  13,  0,  202 }, { 148,  0,   51 },
  {   6,  0,  121 }, {   6,  0,  124 }, {   6,  0,  357 }, {   7,  0, 1138 },
  {   7,  0, 1295 }, {   8,  0,  162 }, {   8,  0,  508 }, {  11,  0,  655 },
  {   4, 11,  535 }, {   6, 10,  558 }, {   7, 10,  651 }, {   8, 11,  618 },
  {   9, 10,    0 }, {  10, 10,   34 }, { 139, 10, 1008 }, { 135, 11, 1245 },
  { 138,  0,  357 }, { 150, 11,   23 }, { 133,  0,  237 }, { 135,  0, 1784 },
  {   7, 10, 1832 }, { 138, 10,  374 }, { 132,  0,  713 }, { 132, 11,   46 },
  {   6,  0, 1536 }, {  10,  0,  348 }, {   5, 11,  811 }, {   6, 11, 1679 },
  {   6, 11, 1714 }, { 135, 11, 2032 }, {  11, 11,  182 }, { 142, 11,  195 },
  {   6,  0,  523 }, {   7,  0,  738 }, {   7, 10,  771 }, {   7, 10, 1731 },
  {   9, 10,  405 }, { 138, 10,  421 }, {   7, 11, 1458 }, {   9, 11,  407 },
  { 139, 11,   15 }, {   6, 11,   34 }, {   7, 11,   69 }, {   7, 11,  640 },
  {   7, 11, 1089 }, {   8, 11,  708 }, {   8, 11,  721 }, {   9, 11,  363 },
  {   9, 11,  643 }, {  10, 11,  628 }, { 148, 11,   98 }, { 133,  0,  434 },
  { 135,  0, 1877 }, {   7,  0,  571 }, { 138,  0,  366 }, {   5, 10,  881 },
  { 133, 10,  885 }, {   9,  0,  513 }, {  10,  0,   25 }, {  10,  0,   39 },
  {  12,  0,  122 }, { 140,  0,  187 }, { 132,  0,  580 }, {   5, 10,  142 },
  { 134, 10,  546 }, { 132, 11,  462 }, { 137,  0,  873 }, {   5, 10,  466 },
  {  11, 10,  571 }, {  12, 10,  198 }, {  13, 10,  283 }, {  14, 10,  186 },
  {  15, 10,   21 }, { 143, 10,  103 }, {   7,  0,  171 }, {   4, 10,  185 },
  {   5, 10,  257 }, {   5, 10,  839 }, {   5, 10,  936 }, {   9, 10,  399 },
  {  10, 10,  258 }, {  10, 10,  395 }, {  10, 10,  734 }, {  11, 10, 1014 },
  {  12, 10,   23 }, {  13, 10,  350 }, {  14, 10,  150 }, { 147, 10,    6 },
  { 134,  0,  625 }, {   7,  0,  107 }, {   7,  0,  838 }, {   8,  0,  550 },
  { 138,  0,  401 }, {   5, 11,   73 }, {   6, 11,   23 }, { 134, 11,  338 },
  {   4,  0,  943 }, {   6,  0, 1850 }, {  12,  0,  713 }, { 142,  0,  434 },
  {  11,  0,  588 }, {  11,  0,  864 }, {  11,  0,  936 }, {  11,  0,  968 },
  {  12,  0,   73 }, {  12,  0,  343 }, {  12,  0,  394 }, {  13,  0,  275 },
  {  14,  0,  257 }, {  15,  0,  160 }, {   7, 10,  404 }, {   7, 10, 1377 },
  {   7, 10, 1430 }, {   7, 10, 2017 }, {   8, 10,  149 }, {   8, 10,  239 },
  {   8, 10,  512 }, {   8, 10,  793 }, {   8, 10,  818 }, {   9, 10,  474 },
  {   9, 10,  595 }, {  10, 10,  122 }, {  10, 10,  565 }, {  10, 10,  649 },
  {  10, 10,  783 }, {  11, 10,  239 }, {  11, 10,  295 }, {  11, 10,  447 },
  {  11, 10,  528 }, {  11, 10,  639 }, {  11, 10,  800 }, {  12, 10,   25 },
  {  12, 10,  157 }, {  12, 10,  316 }, {  12, 10,  390 }, {  12, 10,  391 },
  {  12, 10,  395 }, {  12, 10,  478 }, {  12, 10,  503 }, {  12, 10,  592 },
  {  12, 10,  680 }, {  13, 10,   50 }, {  13, 10,   53 }, {  13, 10,  132 },
  {  13, 10,  198 }, {  13, 10,  322 }, {  13, 10,  415 }, {  13, 10,  511 },
  {  14, 10,   71 }, {  14, 10,  395 }, {  15, 10,   71 }, {  15, 10,  136 },
  {  17, 10,  123 }, {  18, 10,   93 }, { 147, 10,   58 }, { 133,  0,  768 },
  {  11,  0,  103 }, { 142,  0,    0 }, { 136, 10,  712 }, { 132,  0,  799 },
  { 132,  0,  894 }, {   7, 11,  725 }, {   8, 11,  498 }, { 139, 11,  268 },
  { 135, 11, 1798 }, { 135, 11,  773 }, { 141, 11,  360 }, {   4, 10,  377 },
  { 152, 10,   13 }, { 135,  0, 1673 }, { 132, 11,  583 }, { 134,  0, 1052 },
  { 133, 11,  220 }, { 140, 11,   69 }, { 132, 11,  544 }, {   4, 10,  180 },
  { 135, 10, 1906 }, { 134,  0,  272 }, {   4,  0,  441 }, { 134,  0, 1421 },
  {   4,  0,    9 }, {   5,  0,  128 }, {   7,  0,  368 }, {  11,  0,  480 },
  { 148,  0,    3 }, {   5, 11,  176 }, {   6, 11,  437 }, {   6, 11,  564 },
  {  11, 11,  181 }, { 141, 11,  183 }, { 132, 10,  491 }, {   7,  0, 1182 },
  { 141, 11,   67 }, {   6,  0, 1346 }, {   4, 10,  171 }, { 138, 10,  234 },
  {   4, 10,  586 }, {   7, 10, 1186 }, { 138, 10,  631 }, { 136,  0,  682 },
  { 134,  0, 1004 }, {  15,  0,   24 }, { 143, 11,   24 }, { 134,  0,  968 },
  {   4,  0,    2 }, {   6,  0,  742 }, {   6,  0,  793 }, {   7,  0,  545 },
  {   7,  0,  894 }, {   9, 10,  931 }, {  10, 10,  334 }, { 148, 10,   71 },
  { 136, 11,  600 }, { 133, 10,  765 }, {   9,  0,  769 }, { 140,  0,  185 },
  {   4, 11,  790 }, {   5, 11,  273 }, { 134, 11,  394 }, {   7,  0,  474 },
  { 137,  0,  578 }, {   4, 11,  135 }, {   6, 11,  127 }, {   7, 11, 1185 },
  {   7, 11, 1511 }, {   8, 11,  613 }, {  11, 11,    5 }, {  12, 11,  133 },
  {  12, 11,  495 }, {  12, 11,  586 }, {  14, 11,  385 }, {  15, 11,  118 },
  {  17, 11,   20 }, { 146, 11,   98 }, { 133, 10,  424 }, {   5,  0,  530 },
  { 142,  0,  113 }, {   6, 11,  230 }, {   7, 11,  961 }, {   7, 11, 1085 },
  { 136, 11,  462 }, {   7, 11, 1954 }, { 137, 11,  636 }, { 136, 10,  714 },
  { 149, 11,    6 }, { 135, 10,  685 }, {   9, 10,  420 }, {  10, 10,  269 },
  {  10, 10,  285 }, {  10, 10,  576 }, {  11, 10,  397 }, {  13, 10,  175 },
  { 145, 10,   90 }, { 132, 10,  429 }, {   5,  0,  556 }, {   5, 11,  162 },
  { 136, 11,   68 }, { 132, 11,  654 }, {   4, 11,  156 }, {   7, 11,  998 },
  {   7, 11, 1045 }, {   7, 11, 1860 }, {   9, 11,   48 }, {   9, 11,  692 },
  {  11, 11,  419 }, { 139, 11,  602 }, {   6,  0, 1317 }, {   8,  0,   16 },
  {   9,  0,  825 }, {  12,  0,  568 }, {   7, 11, 1276 }, {   8, 11,  474 },
  { 137, 11,  652 }, {  18,  0,   97 }, {   7, 10,   18 }, {   7, 10,  699 },
  {   7, 10, 1966 }, {   8, 10,  752 }, {   9, 10,  273 }, {   9, 10,  412 },
  {   9, 10,  703 }, {  10, 10,   71 }, {  10, 10,  427 }, { 138, 10,  508 },
  {  10,  0,  703 }, {   7, 11, 1454 }, { 138, 11,  703 }, {   4, 10,   53 },
  {   5, 10,  186 }, { 135, 10,  752 }, { 134,  0,  892 }, { 134,  0, 1571 },
  {   8, 10,  575 }, {  10, 10,  289 }, { 139, 10,  319 }, {   6,  0,  186 },
  { 137,  0,  426 }, { 134,  0, 1101 }, { 132, 10,  675 }, { 132,  0,  585 },
  {   6,  0, 1870 }, { 137,  0,  937 }, { 152, 11,   10 }, {   9, 11,  197 },
  {  10, 11,  300 }, {  12, 11,  473 }, {  13, 11,   90 }, { 141, 11,  405 },
  {   4,  0,   93 }, {   5,  0,  252 }, {   6,  0,  229 }, {   7,  0,  291 },
  {   9,  0,  550 }, { 139,  0,  644 }, { 137,  0,  749 }, {   9,  0,  162 },
  {   6, 10,  209 }, {   8, 10,  468 }, {   9, 10,  210 }, {  11, 10,   36 },
  {  12, 10,   28 }, {  12, 10,  630 }, {  13, 10,   21 }, {  13, 10,  349 },
  {  14, 10,    7 }, { 145, 10,   13 }, { 132,  0,  381 }, { 132, 11,  606 },
  {   4, 10,  342 }, { 135, 10, 1179 }, {   7, 11, 1587 }, {   7, 11, 1707 },
  {  10, 11,  528 }, { 139, 11,  504 }, {  12, 11,   39 }, {  13, 11,  265 },
  { 141, 11,  439 }, {   4, 10,  928 }, { 133, 10,  910 }, {   7, 10, 1838 },
  {   7, 11, 1978 }, { 136, 11,  676 }, {   6,  0,  762 }, {   6,  0,  796 },
  { 134,  0,  956 }, {   4, 10,  318 }, {   4, 10,  496 }, {   7, 10,  856 },
  { 139, 10,  654 }, { 137, 11,  242 }, {   4, 11,  361 }, { 133, 11,  315 },
  { 132, 11,  461 }, { 132, 11,  472 }, { 132,  0,  857 }, {   5,  0,   21 },
  {   6,  0,   77 }, {   6,  0,  157 }, {   7,  0,  974 }, {   7,  0, 1301 },
  {   7,  0, 1339 }, {   7,  0, 1490 }, {   7,  0, 1873 }, {   9,  0,  628 },
  {   7, 10,  915 }, {   8, 10,  247 }, { 147, 10,    0 }, {   4, 10,  202 },
  {   5, 10,  382 }, {   6, 10,  454 }, {   7, 10,  936 }, {   7, 10, 1803 },
  {   8, 10,  758 }, {   9, 10,  375 }, {   9, 10,  895 }, {  10, 10,  743 },
  {  10, 10,  792 }, {  11, 10,  978 }, {  11, 10, 1012 }, { 142, 10,  109 },
  {   7, 11,  617 }, {  10, 11,  498 }, {  11, 11,  501 }, {  12, 11,   16 },
  { 140, 11,  150 }, {   7, 10, 1150 }, {   7, 10, 1425 }, {   7, 10, 1453 },
  {  10, 11,  747 }, { 140, 10,  513 }, { 133, 11,  155 }, {  11,  0,  919 },
  { 141,  0,  409 }, { 138, 10,  791 }, {  10,  0,  633 }, { 139, 11,  729 },
  {   7, 11,  163 }, {   8, 11,  319 }, {   9, 11,  402 }, {  10, 11,   24 },
  {  10, 11,  681 }, {  11, 11,  200 }, {  11, 11,  567 }, {  12, 11,  253 },
  {  12, 11,  410 }, { 142, 11,  219 }, {   5, 11,  475 }, {   7, 11, 1780 },
  {   9, 11,  230 }, {  11, 11,  297 }, {  11, 11,  558 }, {  14, 11,  322 },
  { 147, 11,   76 }, {   7,  0,  332 }, {   6, 10,  445 }, { 137, 10,  909 },
  { 135, 11, 1956 }, { 136, 11,  274 }, { 134, 10,  578 }, { 135,  0, 1489 },
  { 135, 11, 1848 }, {   5, 11,  944 }, { 134, 11, 1769 }, { 132, 11,  144 },
  { 136, 10,  766 }, {   4,  0,  832 }, { 135, 10,  541 }, {   8,  0,  398 },
  {   9,  0,  681 }, { 139,  0,  632 }, { 136,  0,  645 }, {   9,  0,  791 },
  {  10,  0,   93 }, {  16,  0,   13 }, {  17,  0,   23 }, {  18,  0,  135 },
  {  19,  0,   12 }, {  20,  0,    1 }, {  20,  0,   12 }, { 148,  0,   14 },
  {   6, 11,  247 }, { 137, 11,  555 }, { 134,  0,   20 }, { 132,  0,  800 },
  { 135,  0, 1841 }, { 139, 10,  983 }, { 137, 10,  768 }, { 132, 10,  584 },
  { 141, 11,   51 }, {   6,  0, 1993 }, {   4, 11,  620 }, { 138, 11,  280 },
  { 136,  0,  769 }, {  11,  0,  290 }, {  11,  0,  665 }, {   7, 11, 1810 },
  {  11, 11,  866 }, {  12, 11,  103 }, {  13, 11,  495 }, {  17, 11,   67 },
  { 147, 11,   74 }, { 134,  0, 1426 }, { 139,  0,   60 }, {   4, 10,  326 },
  { 135, 10, 1770 }, {   7,  0, 1874 }, {   9,  0,  641 }, { 132, 10,  226 },
  {   6,  0,  644 }, {   5, 10,  426 }, {   8, 10,   30 }, {   9, 10,    2 },
  {  11, 10,  549 }, { 147, 10,  122 }, {   5, 11,  428 }, { 138, 11,  442 },
  { 135, 11, 1871 }, { 135,  0, 1757 }, { 147, 10,  117 }, { 135,  0,  937 },
  { 135,  0, 1652 }, {   6,  0,  654 }, { 134,  0, 1476 }, { 133, 11,   99 },
  { 135,  0,  527 }, { 132, 10,  345 }, {   4, 10,  385 }, {   4, 11,  397 },
  {   7, 10,  265 }, { 135, 10,  587 }, {   4,  0,  579 }, {   5,  0,  226 },
  {   5,  0,  323 }, { 135,  0,  960 }, { 134,  0, 1486 }, {   8, 11,  502 },
  { 144, 11,    9 }, {   4, 10,  347 }, {   5, 10,  423 }, {   5, 10,  996 },
  { 135, 10, 1329 }, {   7, 11,  727 }, { 146, 11,   73 }, {   4, 11,  485 },
  {   7, 11,  353 }, {   7, 10, 1259 }, {   7, 11, 1523 }, {   9, 10,  125 },
  { 139, 10,   65 }, {   6,  0,  325 }, {   5, 10,  136 }, {   6, 11,  366 },
  {   7, 11, 1384 }, {   7, 11, 1601 }, { 136, 10,  644 }, { 138, 11,  160 },
  {   6,  0, 1345 }, { 137, 11,  282 }, {  18,  0,   91 }, { 147,  0,   70 },
  { 136,  0,  404 }, {   4, 11,  157 }, { 133, 11,  471 }, { 133,  0,  973 },
  {   6,  0,  135 }, { 135,  0, 1176 }, {   8, 11,  116 }, {  11, 11,  551 },
  { 142, 11,  159 }, {   4,  0,  549 }, {   4, 10,  433 }, { 133, 10,  719 },
  { 136,  0,  976 }, {   5, 11,  160 }, {   7, 11,  363 }, {   7, 11,  589 },
  {  10, 11,  170 }, { 141, 11,   55 }, { 144,  0,   21 }, { 144,  0,   51 },
  { 135,  0,  314 }, { 135, 10, 1363 }, {   4, 11,  108 }, {   7, 11,  405 },
  {  10, 11,  491 }, { 139, 11,  498 }, { 146,  0,    4 }, {   4, 10,  555 },
  {   8, 10,  536 }, {  10, 10,  288 }, { 139, 10, 1005 }, { 135, 11, 1005 },
  {   6,  0,  281 }, {   7,  0,    6 }, {   8,  0,  282 }, {   8,  0,  480 },
  {   8,  0,  499 }, {   9,  0,  198 }, {  10,  0,  143 }, {  10,  0,  169 },
  {  10,  0,  211 }, {  10,  0,  417 }, {  10,  0,  574 }, {  11,  0,  147 },
  {  11,  0,  395 }, {  12,  0,   75 }, {  12,  0,  407 }, {  12,  0,  608 },
  {  13,  0,  500 }, { 142,  0,  251 }, {   6,  0, 1093 }, {   6,  0, 1405 },
  {   9, 10,  370 }, { 138, 10,   90 }, {   4, 11,  926 }, { 133, 11,  983 },
  { 135,  0, 1776 }, { 134,  0, 1528 }, { 132,  0,  419 }, { 132, 11,  538 },
  {   6, 11,  294 }, {   7, 11, 1267 }, { 136, 11,  624 }, { 135, 11, 1772 },
  { 138, 11,  301 }, {   4, 10,  257 }, { 135, 10, 2031 }, {   4,  0,  138 },
  {   7,  0, 1012 }, {   7,  0, 1280 }, {   9,  0,   76 }, { 135, 10, 1768 },
  { 132, 11,  757 }, {   5,  0,   29 }, { 140,  0,  638 }, {   7, 11,  655 },
  { 135, 11, 1844 }, {   7,  0, 1418 }, {   6, 11,  257 }, { 135, 11, 1522 },
  {   8, 11,  469 }, { 138, 11,   47 }, { 142, 11,  278 }, {   6, 10,   83 },
  {   6, 10, 1733 }, { 135, 10, 1389 }, {  11, 11,  204 }, {  11, 11,  243 },
  { 140, 11,  293 }, { 135, 11, 1875 }, {   6,  0, 1710 }, { 135,  0, 2038 },
  { 137, 11,  299 }, {   4,  0,   17 }, {   5,  0,   23 }, {   7,  0,  995 },
  {  11,  0,  383 }, {  11,  0,  437 }, {  12,  0,  460 }, { 140,  0,  532 },
  { 133,  0,  862 }, { 137, 10,  696 }, {   6,  0,  592 }, { 138,  0,  946 },
  { 138, 11,  599 }, {   7, 10, 1718 }, {   9, 10,   95 }, {   9, 10,  274 },
  {  10, 10,  279 }, {  10, 10,  317 }, {  10, 10,  420 }, {  11, 10,  303 },
  {  11, 10,  808 }, {  12, 10,  134 }, {  12, 10,  367 }, {  13, 10,  149 },
  {  13, 10,  347 }, {  14, 10,  349 }, {  14, 10,  406 }, {  18, 10,   22 },
  {  18, 10,   89 }, {  18, 10,  122 }, { 147, 10,   47 }, {   8,  0,   70 },
  {  12,  0,  171 }, { 141,  0,  272 }, { 133, 10,   26 }, { 132, 10,  550 },
  { 137,  0,  812 }, {  10,  0,  233 }, { 139,  0,   76 }, { 134,  0,  988 },
  { 134,  0,  442 }, { 136, 10,  822 }, {   7,  0,  896 }, {   4, 10,  902 },
  {   5, 10,  809 }, { 134, 10,  122 }, {   5, 11,  150 }, {   7, 11,  106 },
  {   8, 11,  603 }, {   9, 11,  593 }, {   9, 11,  634 }, {  10, 11,   44 },
  {  10, 11,  173 }, {  11, 11,  462 }, {  11, 11,  515 }, {  13, 11,  216 },
  {  13, 11,  288 }, { 142, 11,  400 }, { 136,  0,  483 }, { 135, 10,  262 },
  {   6,  0, 1709 }, { 133, 10,  620 }, {   4, 10,   34 }, {   5, 10,  574 },
  {   7, 10,  279 }, {   7, 10, 1624 }, { 136, 10,  601 }, { 137, 10,  170 },
  { 147,  0,  119 }, {  12, 11,  108 }, { 141, 11,  291 }, {  11,  0,   69 },
  {  12,  0,  105 }, {  12,  0,  117 }, {  13,  0,  213 }, {  14,  0,   13 },
  {  14,  0,   62 }, {  14,  0,  177 }, {  14,  0,  421 }, {  15,  0,   19 },
  { 146,  0,  141 }, { 137,  0,  309 }, {  11, 11,  278 }, { 142, 11,   73 },
  {   7,  0,  608 }, {   7,  0,  976 }, {   9,  0,  146 }, {  10,  0,  206 },
  {  10,  0,  596 }, {  13,  0,  218 }, { 142,  0,  153 }, { 133, 10,  332 },
  {   6, 10,  261 }, {   8, 10,  182 }, { 139, 10,  943 }, {   4, 11,  493 },
  { 144, 11,   55 }, { 134, 10, 1721 }, { 132,  0,  768 }, {   4, 10,  933 },
  { 133, 10,  880 }, {   7, 11,  555 }, {   7, 11, 1316 }, {   7, 11, 1412 },
  {   7, 11, 1839 }, {   9, 11,  192 }, {   9, 11,  589 }, {  11, 11,  241 },
  {  11, 11,  676 }, {  11, 11,  811 }, {  11, 11,  891 }, {  12, 11,  140 },
  {  12, 11,  346 }, {  12, 11,  479 }, {  13, 11,   30 }, {  13, 11,   49 },
  {  13, 11,  381 }, {  14, 11,  188 }, {  15, 11,  150 }, {  16, 11,   76 },
  {  18, 11,   30 }, { 148, 11,   52 }, {   4,  0,  518 }, { 135,  0, 1136 },
  {   6, 11,  568 }, {   7, 11,  112 }, {   7, 11, 1804 }, {   8, 11,  362 },
  {   8, 11,  410 }, {   8, 11,  830 }, {   9, 11,  514 }, {  11, 11,  649 },
  { 142, 11,  157 }, { 135, 11,  673 }, {   8,  0,  689 }, { 137,  0,  863 },
  {   4,  0,   18 }, {   7,  0,  145 }, {   7,  0,  444 }, {   7,  0, 1278 },
  {   8,  0,   49 }, {   8,  0,  400 }, {   9,  0,   71 }, {   9,  0,  250 },
  {  10,  0,  459 }, {  12,  0,  160 }, {  16,  0,   24 }, { 132, 11,  625 },
  { 140,  0, 1020 }, {   4,  0,  997 }, {   6,  0, 1946 }, {   6,  0, 1984 },
  { 134,  0, 1998 }, {   6, 11,   16 }, {   6, 11,  158 }, {   7, 11,   43 },
  {   7, 11,  129 }, {   7, 11,  181 }, {   8, 11,  276 }, {   8, 11,  377 },
  {  10, 11,  523 }, {  11, 11,  816 }, {  12, 11,  455 }, {  13, 11,  303 },
  { 142, 11,  135 }, { 133, 10,  812 }, { 134,  0,  658 }, {   4, 11,    1 },
  {   7, 11, 1143 }, {   7, 11, 1463 }, {   8, 11,   61 }, {   9, 11,  207 },
  {   9, 11,  390 }, {   9, 11,  467 }, { 139, 11,  836 }, { 150, 11,   26 },
  { 140,  0,  106 }, {   6,  0, 1827 }, {  10,  0,  931 }, {  18,  0,  166 },
  {  20,  0,  114 }, {   4, 10,  137 }, {   7, 10, 1178 }, {   7, 11, 1319 },
  { 135, 10, 1520 }, { 133,  0, 1010 }, {   4, 11,  723 }, {   5, 11,  895 },
  {   7, 11, 1031 }, {   8, 11,  199 }, {   8, 11,  340 }, {   9, 11,  153 },
  {   9, 11,  215 }, {  10, 11,   21 }, {  10, 11,   59 }, {  10, 11,   80 },
  {  10, 11,  224 }, {  11, 11,  229 }, {  11, 11,  652 }, {  12, 11,  192 },
  {  13, 11,  146 }, { 142, 11,   91 }, { 132, 11,  295 }, {   6, 11,  619 },
  {   7, 11,  898 }, {   7, 11, 1092 }, {   8, 11,  485 }, {  18, 11,   28 },
  { 147, 11,  116 }, { 137, 11,   51 }, {   6, 10, 1661 }, {   7, 10, 1975 },
  {   7, 10, 2009 }, { 135, 10, 2011 }, {   5, 11,  309 }, { 140, 11,  211 },
  {   5,  0,   87 }, {   7,  0,  313 }, {   7,  0, 1103 }, {  10,  0,  208 },
  {  10,  0,  582 }, {  11,  0,  389 }, {  11,  0,  813 }, {  12,  0,  385 },
  {  13,  0,  286 }, {  14,  0,  124 }, { 146,  0,  108 }, {   5, 11,  125 },
  {   8, 11,   77 }, { 138, 11,   15 }, { 132,  0,  267 }, { 133,  0,  703 },
  { 137, 11,  155 }, { 133, 11,  439 }, {  11, 11,  164 }, { 140, 11,   76 },
  {   9,  0,  496 }, {   5, 10,   89 }, {   7, 10, 1915 }, {   9, 10,  185 },
  {   9, 10,  235 }, {  10, 10,   64 }, {  10, 10,  270 }, {  10, 10,  403 },
  {  10, 10,  469 }, {  10, 10,  529 }, {  10, 10,  590 }, {  11, 10,  140 },
  {  11, 10,  860 }, {  13, 10,    1 }, {  13, 10,  422 }, {  14, 10,  341 },
  {  14, 10,  364 }, {  17, 10,   93 }, {  18, 10,  113 }, {  19, 10,   97 },
  { 147, 10,  113 }, { 133, 10,  695 }, { 135,  0, 1121 }, {   5, 10,    6 },
  {   6, 10,  183 }, {   7, 10,  680 }, {   7, 10,  978 }, {   7, 10, 1013 },
  {   7, 10, 1055 }, {  12, 10,  230 }, {  13, 10,  172 }, { 146, 10,   29 },
  {   4, 11,    8 }, {   7, 11, 1152 }, {   7, 11, 1153 }, {   7, 11, 1715 },
  {   9, 11,  374 }, {  10, 11,  478 }, { 139, 11,  648 }, { 135, 11, 1099 },
  {   6, 10,   29 }, { 139, 10,   63 }, {   4,  0,  561 }, {  10,  0,  249 },
  { 139,  0,  209 }, { 132,  0,  760 }, {   7, 11,  799 }, { 138, 11,  511 },
  { 136, 11,   87 }, {   9,  0,  154 }, { 140,  0,  485 }, { 136,  0,  255 },
  { 132,  0,  323 }, { 140,  0,  419 }, { 132, 10,  311 }, { 134, 10, 1740 },
  {   4,  0,  368 }, { 135,  0,  641 }, {   7, 10,  170 }, {   8, 10,   90 },
  {   8, 10,  177 }, {   8, 10,  415 }, {  11, 10,  714 }, { 142, 10,  281 },
  {   4, 11,   69 }, {   5, 11,  122 }, {   9, 11,  656 }, { 138, 11,  464 },
  {   5, 11,  849 }, { 134, 11, 1633 }, {   8,  0,  522 }, { 142,  0,  328 },
  {  11, 10,   91 }, {  13, 10,  129 }, {  15, 10,  101 }, { 145, 10,  125 },
  {   7,  0,  562 }, {   8,  0,  551 }, {   4, 10,  494 }, {   6, 10,   74 },
  {   7, 10,   44 }, {  11, 11,  499 }, {  12, 10,   17 }, {  15, 10,    5 },
  { 148, 10,   11 }, {   4, 10,  276 }, { 133, 10,  296 }, {   9,  0,   92 },
  { 147,  0,   91 }, {   4, 10,    7 }, {   5, 10,   90 }, {   5, 10,  158 },
  {   6, 10,  542 }, {   7, 10,  221 }, {   7, 10, 1574 }, {   9, 10,  490 },
  {  10, 10,  540 }, {  11, 10,  443 }, { 139, 10,  757 }, {   6,  0,  525 },
  {   6,  0, 1976 }, {   8,  0,  806 }, {   9,  0,  876 }, { 140,  0,  284 },
  {   5, 11,  859 }, {   7, 10,  588 }, {   7, 11, 1160 }, {   8, 11,  107 },
  {   9, 10,  175 }, {   9, 11,  291 }, {   9, 11,  439 }, {  10, 10,  530 },
  {  10, 11,  663 }, {  11, 11,  609 }, { 140, 11,  197 }, {   7, 11,  168 },
  {  13, 11,  196 }, { 141, 11,  237 }, { 139,  0,  958 }, { 133,  0,  594 },
  { 135, 10,  580 }, {   7, 10,   88 }, { 136, 10,  627 }, {   6,  0,  479 },
  {   6,  0,  562 }, {   7,  0, 1060 }, {  13,  0,    6 }, {   5, 10,  872 },
  {   6, 10,   57 }, {   7, 10,  471 }, {   9, 10,  447 }, { 137, 10,  454 },
  { 136, 11,  413 }, { 145, 11,   19 }, {   4, 11,  117 }, {   6, 11,  372 },
  {   7, 11, 1905 }, { 142, 11,  323 }, {   4, 11,  722 }, { 139, 11,  471 },
  {  17,  0,   61 }, {   5, 10,   31 }, { 134, 10,  614 }, {   8, 10,  330 },
  { 140, 10,  477 }, {   7, 10, 1200 }, { 138, 10,  460 }, {   6, 10,  424 },
  { 135, 10, 1866 }, {   6,  0, 1641 }, { 136,  0,  820 }, {   6,  0, 1556 },
  { 134,  0, 1618 }, {   9, 11,    5 }, {  12, 11,  216 }, {  12, 11,  294 },
  {  12, 11,  298 }, {  12, 11,  400 }, {  12, 11,  518 }, {  13, 11,  229 },
  { 143, 11,  139 }, {  15, 11,  155 }, { 144, 11,   79 }, {   4,  0,  302 },
  { 135,  0, 1766 }, {   5, 10,   13 }, { 134, 10,  142 }, {   6,  0,  148 },
  {   7,  0, 1313 }, {   7, 10,  116 }, {   8, 10,  322 }, {   8, 10,  755 },
  {   9, 10,  548 }, {  10, 10,  714 }, {  11, 10,  884 }, { 141, 10,  324 },
  { 137,  0,  676 }, {   9, 11,   88 }, { 139, 11,  270 }, {   5, 11,   12 },
  {   7, 11,  375 }, { 137, 11,  438 }, { 134,  0, 1674 }, {   7, 10, 1472 },
  { 135, 10, 1554 }, {  11,  0,  178 }, {   7, 10, 1071 }, {   7, 10, 1541 },
  {   7, 10, 1767 }, {   7, 10, 1806 }, {  11, 10,  162 }, {  11, 10,  242 },
  {  12, 10,  605 }, {  15, 10,   26 }, { 144, 10,   44 }, {   6,  0,  389 },
  {   7,  0,  149 }, {   9,  0,  142 }, { 138,  0,   94 }, { 140, 11,   71 },
  { 145, 10,  115 }, {   6,  0,    8 }, {   7,  0, 1881 }, {   8,  0,   91 },
  {  11, 11,  966 }, {  12, 11,  287 }, {  13, 11,  342 }, {  13, 11,  402 },
  {  15, 11,  110 }, { 143, 11,  163 }, {   4, 11,  258 }, { 136, 11,  639 },
  {   6, 11,   22 }, {   7, 11,  903 }, { 138, 11,  577 }, { 133, 11,  681 },
  { 135, 10, 1111 }, { 135, 11, 1286 }, {   9,  0,  112 }, {   8, 10,    1 },
  { 138, 10,  326 }, {   5, 10,  488 }, {   6, 10,  527 }, {   7, 10,  489 },
  {   7, 10, 1636 }, {   8, 10,  121 }, {   8, 10,  144 }, {   8, 10,  359 },
  {   9, 10,  193 }, {   9, 10,  241 }, {   9, 10,  336 }, {   9, 10,  882 },
  {  11, 10,  266 }, {  11, 10,  372 }, {  11, 10,  944 }, {  12, 10,  401 },
  { 140, 10,  641 }, {   4, 11,  664 }, { 133, 11,  804 }, {   6,  0,  747 },
  { 134,  0, 1015 }, { 135,  0, 1746 }, {   9, 10,   31 }, {  10, 10,  244 },
  {  10, 10,  699 }, {  12, 10,  149 }, { 141, 10,  497 }, { 133, 10,  377 },
  { 135,  0,   24 }, {   6,  0, 1352 }, {   5, 11,   32 }, { 145, 10,  101 },
  {   7,  0, 1530 }, {  10,  0,  158 }, {  13,  0,   13 }, {  13,  0,  137 },
  {  13,  0,  258 }, {  14,  0,  111 }, {  14,  0,  225 }, {  14,  0,  253 },
  {  14,  0,  304 }, {  14,  0,  339 }, {  14,  0,  417 }, { 146,  0,   33 },
  {   4,  0,  503 }, { 135,  0, 1661 }, {   5,  0,  130 }, {   6,  0,  845 },
  {   7,  0, 1314 }, {   9,  0,  610 }, {  10,  0,  718 }, {  11,  0,  601 },
  {  11,  0,  819 }, {  11,  0,  946 }, { 140,  0,  536 }, {  10,  0,  149 },
  {  11,  0,  280 }, { 142,  0,  336 }, { 134,  0, 1401 }, { 135,  0, 1946 },
  {   8,  0,  663 }, { 144,  0,    8 }, { 134,  0, 1607 }, { 135, 10, 2023 },
  {   4, 11,  289 }, {   7, 11,  629 }, {   7, 11, 1698 }, {   7, 11, 1711 },
  { 140, 11,  215 }, {   6, 11,  450 }, { 136, 11,  109 }, {  10,  0,  882 },
  {  10,  0,  883 }, {  10,  0,  914 }, { 138,  0,  928 }, { 133, 10,  843 },
  { 136, 11,  705 }, { 132, 10,  554 }, { 133, 10,  536 }, {   5,  0,  417 },
  {   9, 10,   79 }, {  11, 10,  625 }, { 145, 10,    7 }, {   7, 11, 1238 },
  { 142, 11,   37 }, {   4,  0,  392 }, { 135,  0, 1597 }, {   5,  0,  433 },
  {   9,  0,  633 }, {  11,  0,  629 }, { 132, 10,  424 }, {   7, 10,  336 },
  { 136, 10,  785 }, { 134, 11,  355 }, {   6,  0,  234 }, {   7,  0,  769 },
  {   9,  0,   18 }, { 138,  0,  358 }, {   4, 10,  896 }, { 134, 10, 1777 },
  { 138, 11,  323 }, {   7,  0,  140 }, {   7,  0, 1950 }, {   8,  0,  680 },
  {  11,  0,  817 }, { 147,  0,   88 }, {   7,  0, 1222 }, { 138,  0,  386 },
  { 139, 11,  908 }, {  11,  0,  249 }, {  12,  0,  313 }, {  16,  0,   66 },
  { 145,  0,   26 }, { 134,  0,    5 }, {   7, 10,  750 }, {   9, 10,  223 },
  {  11, 10,   27 }, {  11, 10,  466 }, {  12, 10,  624 }, {  14, 10,  265 },
  { 146, 10,   61 }, { 134, 11,   26 }, { 134,  0, 1216 }, {   5,  0,  963 },
  { 134,  0, 1773 }, {   4, 11,  414 }, {   5, 11,  467 }, {   9, 11,  654 },
  {  10, 11,  451 }, {  12, 11,   59 }, { 141, 11,  375 }, { 135, 11,   17 },
  {   4, 10,  603 }, { 133, 10,  661 }, {   4, 10,   11 }, {   6, 10,  128 },
  {   7, 10,  231 }, {   7, 10, 1533 }, { 138, 10,  725 }, { 135, 11,  955 },
  {   7,  0,  180 }, {   8,  0,  509 }, { 136,  0,  792 }, { 132, 10,  476 },
  { 132,  0, 1002 }, { 133, 11,  538 }, { 135, 10, 1807 }, { 132,  0,  931 },
  {   7,  0,  943 }, {  11,  0,  614 }, { 140,  0,  747 }, { 135,  0, 1837 },
  {   9, 10,   20 }, {  10, 10,  324 }, {  10, 10,  807 }, { 139, 10,  488 },
  { 134,  0,  641 }, {   6, 11,  280 }, {  10, 11,  502 }, {  11, 11,  344 },
  { 140, 11,   38 }, {   5, 11,   45 }, {   7, 11, 1161 }, {  11, 11,  448 },
  {  11, 11,  880 }, {  13, 11,  139 }, {  13, 11,  407 }, {  15, 11,   16 },
  {  17, 11,   95 }, {  18, 11,   66 }, {  18, 11,   88 }, {  18, 11,  123 },
  { 149, 11,    7 }, {   9,  0,  280 }, { 138,  0,  134 }, {  22,  0,   22 },
  {  23,  0,    5 }, { 151,  0,   29 }, { 136, 11,  777 }, {   4,  0,   90 },
  {   5,  0,  545 }, {   7,  0,  754 }, {   9,  0,  186 }, {  10,  0,   72 },
  {  10,  0,  782 }, {  11,  0,  577 }, {  11,  0,  610 }, {  11,  0,  960 },
  {  12,  0,  354 }, {  12,  0,  362 }, {  12,  0,  595 }, {   4, 11,  410 },
  { 135, 11,  521 }, { 135, 11, 1778 }, {   5, 10,  112 }, {   6, 10,  103 },
  { 134, 10,  150 }, { 138, 10,  356 }, { 132,  0,  742 }, {   7,  0,  151 },
  {   9,  0,  329 }, { 139,  0,  254 }, {   8,  0,  853 }, {   8,  0,  881 },
  {   8,  0,  911 }, {   8,  0,  912 }, {  10,  0,  872 }, {  12,  0,  741 },
  {  12,  0,  742 }, { 152,  0,   18 }, {   4, 11,  573 }, { 136, 11,  655 },
  {   6,  0,  921 }, { 134,  0,  934 }, {   9,  0,  187 }, {  10,  0,   36 },
  {  11,  0, 1016 }, {  17,  0,   44 }, { 146,  0,   64 }, {   7,  0,  833 },
  { 136,  0,  517 }, {   4,  0,  506 }, {   5,  0,  295 }, { 135,  0, 1680 },
  {   4, 10,  708 }, {   8, 10,   15 }, {   9, 10,   50 }, {   9, 10,  386 },
  {  11, 10,   18 }, {  11, 10,  529 }, { 140, 10,  228 }, {   7,  0,  251 },
  {   7,  0, 1701 }, {   8,  0,  436 }, {   4, 10,  563 }, {   7, 10,  592 },
  {   7, 10,  637 }, {   7, 10,  770 }, {   8, 10,  463 }, {   9, 10,   60 },
  {   9, 10,  335 }, {   9, 10,  904 }, {  10, 10,   73 }, {  11, 10,  434 },
  {  12, 10,  585 }, {  13, 10,  331 }, {  18, 10,  110 }, { 148, 10,   60 },
  { 132, 10,  502 }, { 136,  0,  584 }, {   6, 10,  347 }, { 138, 10,  161 },
  {   7,  0,  987 }, {   9,  0,  688 }, {  10,  0,  522 }, {  11,  0,  788 },
  {  12,  0,  137 }, {  12,  0,  566 }, {  14,  0,    9 }, {  14,  0,   24 },
  {  14,  0,   64 }, {   7, 11,  899 }, { 142, 11,  325 }, {   4,  0,  214 },
  {   5,  0,  500 }, {   5, 10,  102 }, {   6, 10,  284 }, {   7, 10, 1079 },
  {   7, 10, 1423 }, {   7, 10, 1702 }, {   8, 10,  470 }, {   9, 10,  554 },
  {   9, 10,  723 }, { 139, 10,  333 }, {   7, 10,  246 }, { 135, 10,  840 },
  {   6, 10,   10 }, {   8, 10,  571 }, {   9, 10,  739 }, { 143, 10,   91 },
  { 133, 10,  626 }, { 146,  0,  195 }, { 134,  0, 1775 }, {   7,  0,  389 },
  {   7,  0,  700 }, {   7,  0,  940 }, {   8,  0,  514 }, {   9,  0,  116 },
  {   9,  0,  535 }, {  10,  0,  118 }, {  11,  0,  107 }, {  11,  0,  148 },
  {  11,  0,  922 }, {  12,  0,  254 }, {  12,  0,  421 }, { 142,  0,  238 },
  {   5, 10,   18 }, {   6, 10,  526 }, {  13, 10,   24 }, {  13, 10,  110 },
  {  19, 10,    5 }, { 147, 10,   44 }, { 132,  0,  743 }, {  11,  0,  292 },
  {   4, 10,  309 }, {   5, 10,  462 }, {   7, 10,  970 }, { 135, 10, 1097 },
  {  22, 10,   30 }, { 150, 10,   33 }, { 139, 11,  338 }, { 135, 11, 1598 },
  {   7,  0, 1283 }, {   9,  0,  227 }, {  11,  0,  325 }, {  11,  0,  408 },
  {  14,  0,  180 }, { 146,  0,   47 }, {   4,  0,  953 }, {   6,  0, 1805 },
  {   6,  0, 1814 }, {   6,  0, 1862 }, { 140,  0,  774 }, {   6, 11,  611 },
  { 135, 11, 1733 }, { 135, 11, 1464 }, {   5,  0,   81 }, {   7,  0,  146 },
  {   7,  0, 1342 }, {   8,  0,   53 }, {   8,  0,  561 }, {   8,  0,  694 },
  {   8,  0,  754 }, {   9,  0,  115 }, {   9,  0,  179 }, {   9,  0,  894 },
  {  10,  0,  462 }, {  10,  0,  813 }, {  11,  0,  230 }, {  11,  0,  657 },
  {  11,  0,  699 }, {  11,  0,  748 }, {  12,  0,  119 }, {  12,  0,  200 },
  {  12,  0,  283 }, { 142,  0,  273 }, {   5,  0,  408 }, {   6,  0,  789 },
  {   6,  0,  877 }, {   6,  0, 1253 }, {   6,  0, 1413 }, { 137,  0,  747 },
  { 134, 10, 1704 }, { 135, 11,  663 }, {   6,  0, 1910 }, {   6,  0, 1915 },
  {   6,  0, 1923 }, {   9,  0,  913 }, {   9,  0,  928 }, {   9,  0,  950 },
  {   9,  0,  954 }, {   9,  0,  978 }, {   9,  0,  993 }, {  12,  0,  812 },
  {  12,  0,  819 }, {  12,  0,  831 }, {  12,  0,  833 }, {  12,  0,  838 },
  {  12,  0,  909 }, {  12,  0,  928 }, {  12,  0,  931 }, {  12,  0,  950 },
  {  15,  0,  186 }, {  15,  0,  187 }, {  15,  0,  195 }, {  15,  0,  196 },
  {  15,  0,  209 }, {  15,  0,  215 }, {  15,  0,  236 }, {  15,  0,  241 },
  {  15,  0,  249 }, {  15,  0,  253 }, {  18,  0,  180 }, {  18,  0,  221 },
  {  18,  0,  224 }, {  18,  0,  227 }, {  18,  0,  229 }, { 149,  0,   60 },
  {   7,  0, 1826 }, { 135,  0, 1938 }, {  11,  0,  490 }, {  18,  0,  143 },
  {   5, 10,   86 }, {   7, 10,  743 }, {   9, 10,   85 }, {  10, 10,  281 },
  {  10, 10,  432 }, {  12, 10,  251 }, {  13, 10,  118 }, { 142, 10,  378 },
  {   5, 10,  524 }, { 133, 10,  744 }, { 141, 11,  442 }, {  10, 10,  107 },
  { 140, 10,  436 }, { 135, 11,  503 }, { 134,  0, 1162 }, { 132, 10,  927 },
  {   7,  0,   30 }, {   8,  0,   86 }, {   8,  0,  315 }, {   8,  0,  700 },
  {   9,  0,  576 }, {   9,  0,  858 }, {  10,  0,  414 }, {  11,  0,  310 },
  {  11,  0,  888 }, {  11,  0,  904 }, {  12,  0,  361 }, {  13,  0,  248 },
  {  13,  0,  371 }, {  14,  0,  142 }, {  12, 10,  670 }, { 146, 10,   94 },
  { 134,  0,  721 }, {   4, 11,  113 }, {   5, 11,  163 }, {   5, 11,  735 },
  {   7, 11, 1009 }, {   7, 10, 1149 }, {   9, 11,    9 }, {   9, 10,  156 },
  {   9, 11,  771 }, {  12, 11,   90 }, {  13, 11,  138 }, {  13, 11,  410 },
  { 143, 11,  128 }, { 138,  0,  839 }, { 133, 10,  778 }, { 137,  0,  617 },
  { 133, 10,  502 }, {   8, 10,  196 }, {  10, 10,  283 }, { 139, 10,  406 },
  {   6,  0,  428 }, {   7,  0,  524 }, {   8,  0,  169 }, {   8,  0,  234 },
  {   9,  0,  480 }, { 138,  0,  646 }, { 133, 10,  855 }, { 134,  0, 1648 },
  {   7,  0, 1205 }, { 138,  0,  637 }, {   7,  0, 1596 }, {   4, 11,  935 },
  { 133, 11,  823 }, {   5, 11,  269 }, {   7, 11,  434 }, {   7, 11,  891 },
  {   8, 11,  339 }, {   9, 11,  702 }, {  11, 11,  594 }, {  11, 11,  718 },
  { 145, 11,  100 }, {   7, 11,  878 }, {   9, 11,  485 }, { 141, 11,  264 },
  {   4,  0,  266 }, {   8,  0,    4 }, {   9,  0,   39 }, {  10,  0,  166 },
  {  11,  0,  918 }, {  12,  0,  635 }, {  20,  0,   10 }, {  22,  0,   27 },
  {  22,  0,   43 }, {  22,  0,   52 }, { 134, 11, 1713 }, {   7, 10, 1400 },
  {   9, 10,  446 }, { 138, 10,   45 }, { 135, 11,  900 }, { 132,  0,  862 },
  { 134,  0, 1554 }, { 135, 11, 1033 }, {  19,  0,   16 }, { 147, 11,   16 },
  { 135, 11, 1208 }, {   7,  0,  157 }, { 136,  0,  279 }, {   6,  0,  604 },
  { 136,  0,  391 }, {  13, 10,  455 }, {  15, 10,   99 }, {  15, 10,  129 },
  { 144, 10,   68 }, { 135, 10,  172 }, {   7,  0,  945 }, {  11,  0,  713 },
  { 139,  0,  744 }, {   4,  0,  973 }, {  10,  0,  877 }, {  10,  0,  937 },
  {  10,  0,  938 }, { 140,  0,  711 }, { 139,  0, 1022 }, { 132, 10,  568 },
  { 142, 11,  143 }, {   4,  0,  567 }, {   9,  0,  859 }, { 132, 10,  732 },
  {   7,  0, 1846 }, { 136,  0,  628 }, { 136, 10,  733 }, { 133,  0,  762 },
  {   4, 10,  428 }, { 135, 10, 1789 }, {  10,  0,  784 }, {  13,  0,  191 },
  {   7, 10, 2015 }, { 140, 10,  665 }, { 133,  0,  298 }, {   7,  0,  633 },
  {   7,  0,  905 }, {   7,  0,  909 }, {   7,  0, 1538 }, {   9,  0,  767 },
  { 140,  0,  636 }, { 138, 10,  806 }, { 132,  0,  795 }, { 139,  0,  301 },
  { 135,  0, 1970 }, {   5, 11,  625 }, { 135, 11, 1617 }, { 135, 11,  275 },
  {   7, 11,   37 }, {   8, 11,  425 }, {   8, 11,  693 }, {   9, 11,  720 },
  {  10, 11,  380 }, {  10, 11,  638 }, {  11, 11,  273 }, {  11, 11,  307 },
  {  11, 11,  473 }, {  12, 11,   61 }, { 143, 11,   43 }, { 135, 11,  198 },
  { 134,  0, 1236 }, {   7,  0,  369 }, {  12,  0,  644 }, {  12,  0,  645 },
  { 144,  0,   90 }, {  19,  0,   15 }, { 149,  0,   27 }, {   6,  0,   71 },
  {   7,  0,  845 }, {   8,  0,  160 }, {   9,  0,  318 }, {   6, 10, 1623 },
  { 134, 10, 1681 }, { 134,  0, 1447 }, { 134,  0, 1255 }, { 138,  0,  735 },
  {   8,  0,   76 }, { 132, 11,  168 }, {   6, 10, 1748 }, {   8, 10,  715 },
  {   9, 10,  802 }, {  10, 10,   46 }, {  10, 10,  819 }, {  13, 10,  308 },
  {  14, 10,  351 }, {  14, 10,  363 }, { 146, 10,   67 }, { 135, 11,   91 },
  {   6,  0,  474 }, {   4, 10,   63 }, { 133, 10,  347 }, { 133, 10,  749 },
  { 138,  0,  841 }, { 133, 10,  366 }, {   6,  0,  836 }, { 132, 11,  225 },
  { 135,  0, 1622 }, { 135, 10,   89 }, { 140,  0,  735 }, { 134,  0, 1601 },
  { 138, 11,  145 }, {   6,  0, 1390 }, { 137,  0,  804 }, { 142,  0,  394 },
  {   6, 11,   15 }, {   7, 11,   70 }, {  10, 11,  240 }, { 147, 11,   93 },
  {   6,  0,   96 }, { 135,  0, 1426 }, {   4,  0,  651 }, { 133,  0,  289 },
  {   7, 11,  956 }, {   7, 10,  977 }, {   7, 11, 1157 }, {   7, 11, 1506 },
  {   7, 11, 1606 }, {   7, 11, 1615 }, {   7, 11, 1619 }, {   7, 11, 1736 },
  {   7, 11, 1775 }, {   8, 11,  590 }, {   9, 11,  324 }, {   9, 11,  736 },
  {   9, 11,  774 }, {   9, 11,  776 }, {   9, 11,  784 }, {  10, 11,  567 },
  {  10, 11,  708 }, {  11, 11,  518 }, {  11, 11,  613 }, {  11, 11,  695 },
  {  11, 11,  716 }, {  11, 11,  739 }, {  11, 11,  770 }, {  11, 11,  771 },
  {  11, 11,  848 }, {  11, 11,  857 }, {  11, 11,  931 }, {  11, 11,  947 },
  {  12, 11,  326 }, {  12, 11,  387 }, {  12, 11,  484 }, {  12, 11,  528 },
  {  12, 11,  552 }, {  12, 11,  613 }, {  13, 11,  189 }, {  13, 11,  256 },
  {  13, 11,  340 }, {  13, 11,  432 }, {  13, 11,  436 }, {  13, 11,  440 },
  {  13, 11,  454 }, {  14, 11,  174 }, {  14, 11,  220 }, {  14, 11,  284 },
  {  14, 11,  390 }, { 145, 11,  121 }, {   7,  0,  688 }, {   8,  0,   35 },
  {   9,  0,  511 }, {  10,  0,  767 }, { 147,  0,  118 }, { 134,  0,  667 },
  {   4,  0,  513 }, {   5, 10,  824 }, { 133, 10,  941 }, {   7, 10,  440 },
  {   8, 10,  230 }, { 139, 10,  106 }, { 134,  0, 2034 }, { 135, 11, 1399 },
  { 143, 11,   66 }, { 135, 11, 1529 }, {   4, 11,  145 }, {   6, 11,  176 },
  {   7, 11,  395 }, {   9, 11,  562 }, { 144, 11,   28 }, { 132, 11,  501 },
  { 132,  0,  704 }, { 134,  0, 1524 }, {   7,  0, 1078 }, { 134, 11,  464 },
  {   6, 11,  509 }, {  10, 11,   82 }, {  20, 11,   91 }, { 151, 11,   13 },
  {   4,  0,  720 }, { 133,  0,  306 }, { 133,  0,  431 }, {   7,  0, 1196 },
  {   4, 10,  914 }, {   5, 10,  800 }, { 133, 10,  852 }, { 135, 11, 1189 },
  {  10,  0,   54 }, { 141, 10,  115 }, {   7, 10,  564 }, { 142, 10,  168 },
  {   5,  0,  464 }, {   6,  0,  236 }, {   7,  0,  696 }, {   7,  0,  914 },
  {   7,  0, 1108 }, {   7,  0, 1448 }, {   9,  0,   15 }, {   9,  0,  564 },
  {  10,  0,   14 }, {  12,  0,  565 }, {  13,  0,  449 }, {  14,  0,   53 },
  {  15,  0,   13 }, {  16,  0,   64 }, {  17,  0,   41 }, {   4, 10,  918 },
  { 133, 10,  876 }, {   6,  0, 1418 }, { 134, 10, 1764 }, {   4, 10,   92 },
  { 133, 10,  274 }, { 134,  0,  907 }, {   4, 11,  114 }, {   8, 10,  501 },
  {   9, 11,  492 }, {  13, 11,  462 }, { 142, 11,  215 }, {   4, 11,   77 },
  {   5, 11,  361 }, {   6, 11,  139 }, {   6, 11,  401 }, {   6, 11,  404 },
  {   7, 11,  413 }, {   7, 11,  715 }, {   7, 11, 1716 }, {  11, 11,  279 },
  {  12, 11,  179 }, {  12, 11,  258 }, {  13, 11,  244 }, { 142, 11,  358 },
  {   6,  0, 1767 }, {  12,  0,  194 }, { 145,  0,  107 }, { 134, 11, 1717 },
  {   5, 10,  743 }, { 142, 11,  329 }, {   4, 10,   49 }, {   7, 10,  280 },
  { 135, 10, 1633 }, {   5,  0,  840 }, {   7, 11, 1061 }, {   8, 11,   82 },
  {  11, 11,  250 }, {  12, 11,  420 }, { 141, 11,  184 }, { 135, 11,  724 },
  { 134,  0,  900 }, { 136, 10,   47 }, { 134,  0, 1436 }, { 144, 11,    0 },
  {   6,  0,  675 }, {   7,  0, 1008 }, {   7,  0, 1560 }, {   9,  0,  642 },
  {  11,  0,  236 }, {  14,  0,  193 }, {   5, 10,  272 }, {   5, 10,  908 },
  {   5, 10,  942 }, {   8, 10,  197 }, {   9, 10,   47 }, {  11, 10,  538 },
  { 139, 10,  742 }, {   4,  0,   68 }, {   5,  0,  628 }, {   5,  0,  634 },
  {   6,  0,  386 }, {   7,  0,  794 }, {   8,  0,  273 }, {   9,  0,  563 },
  {  10,  0,  105 }, {  10,  0,  171 }, {  11,  0,   94 }, { 139,  0,  354 },
  { 135, 10, 1911 }, { 137, 10,  891 }, {   4,  0,   95 }, {   6,  0, 1297 },
  {   6,  0, 1604 }, {   7,  0,  416 }, { 139,  0,  830 }, {   6, 11,  513 },
  { 135, 11, 1052 }, {   7,  0,  731 }, {  13,  0,   20 }, { 143,  0,   11 },
  { 137, 11,  899 }, {  10,  0,  850 }, { 140,  0,  697 }, {   4,  0,  662 },
  {   7, 11, 1417 }, {  12, 11,  382 }, {  17, 11,   48 }, { 152, 11,   12 },
  { 133,  0,  736 }, { 132,  0,  861 }, {   4, 10,  407 }, { 132, 10,  560 },
  { 141, 10,  490 }, {   6, 11,  545 }, {   7, 11,  565 }, {   7, 11, 1669 },
  {  10, 11,  114 }, {  11, 11,  642 }, { 140, 11,  618 }, {   6,  0,  871 },
  { 134,  0, 1000 }, {   5,  0,  864 }, {  10,  0,  648 }, {  11,  0,  671 },
  {  15,  0,   46 }, { 133, 11,    5 }, { 133,  0,  928 }, {  11,  0,   90 },
  {  13,  0,    7 }, {   4, 10,  475 }, {  11, 10,   35 }, {  13, 10,   71 },
  {  13, 10,  177 }, { 142, 10,  422 }, { 136,  0,  332 }, { 135, 11,  192 },
  { 134,  0, 1055 }, { 136, 11,  763 }, {  11,  0,  986 }, { 140,  0,  682 },
  {   7,  0,   76 }, {   8,  0,   44 }, {   9,  0,  884 }, {  10,  0,  580 },
  {  11,  0,  399 }, {  11,  0,  894 }, { 143,  0,  122 }, { 135, 11, 1237 },
  { 135, 10,  636 }, {  11,  0,  300 }, {   6, 10,  222 }, {   7, 10, 1620 },
  {   8, 10,  409 }, { 137, 10,  693 }, {   4, 11,   87 }, {   5, 11,  250 },
  {  10, 11,  601 }, {  13, 11,  298 }, {  13, 11,  353 }, { 141, 11,  376 },
  {   5,  0,  518 }, {  10,  0,  340 }, {  11,  0,  175 }, { 149,  0,   16 },
  { 140,  0,  771 }, {   6,  0, 1108 }, { 137,  0,  831 }, { 132,  0,  836 },
  { 135,  0, 1852 }, {   4,  0,  957 }, {   6,  0, 1804 }, {   8,  0,  842 },
  {   8,  0,  843 }, {   8,  0,  851 }, {   8,  0,  855 }, { 140,  0,  767 },
  { 135, 11,  814 }, {   4, 11,   57 }, {   7, 11, 1195 }, {   7, 11, 1438 },
  {   7, 11, 1548 }, {   7, 11, 1835 }, {   7, 11, 1904 }, {   9, 11,  757 },
  {  10, 11,  604 }, { 139, 11,  519 }, { 133, 10,  882 }, { 138,  0,  246 },
  {   4,  0,  934 }, {   5,  0,  202 }, {   8,  0,  610 }, {   7, 11, 1897 },
  {  12, 11,  290 }, {  13, 11,   80 }, {  13, 11,  437 }, { 145, 11,   74 },
  {   8,  0,   96 }, {   9,  0,   36 }, {  10,  0,  607 }, {  10,  0,  804 },
  {  10,  0,  832 }, {  11,  0,  423 }, {  11,  0,  442 }, {  12,  0,  309 },
  {  14,  0,  199 }, {  15,  0,   90 }, { 145,  0,  110 }, { 132, 10,  426 },
  {   7,  0,  654 }, {   8,  0,  240 }, {   6, 10,   58 }, {   7, 10,  745 },
  {   7, 10, 1969 }, {   8, 10,  675 }, {   9, 10,  479 }, {   9, 10,  731 },
  {  10, 10,  330 }, {  10, 10,  593 }, {  10, 10,  817 }, {  11, 10,   32 },
  {  11, 10,  133 }, {  11, 10,  221 }, { 145, 10,   68 }, {   9,  0,   13 },
  {   9,  0,  398 }, {   9,  0,  727 }, {  10,  0,   75 }, {  10,  0,  184 },
  {  10,  0,  230 }, {  10,  0,  564 }, {  10,  0,  569 }, {  11,  0,  973 },
  {  12,  0,   70 }, {  12,  0,  189 }, {  13,  0,   57 }, { 141,  0,  257 },
  {   4, 11,  209 }, { 135, 11,  902 }, {   7,  0,  391 }, { 137, 10,  538 },
  { 134,  0,  403 }, {   6, 11,  303 }, {   7, 11,  335 }, {   7, 11, 1437 },
  {   7, 11, 1668 }, {   8, 11,  553 }, {   8, 11,  652 }, {   8, 11,  656 },
  {   9, 11,  558 }, {  11, 11,  743 }, { 149, 11,   18 }, { 132, 11,  559 },
  {  11,  0,   75 }, { 142,  0,  267 }, {   6,  0,  815 }, { 141, 11,    2 },
  { 141,  0,  366 }, { 137,  0,  631 }, { 133, 11, 1017 }, {   5,  0,  345 },
  { 135,  0, 1016 }, { 133, 11,  709 }, { 134, 11, 1745 }, { 133, 10,  566 },
  {   7,  0,  952 }, {   6, 10,   48 }, {   9, 10,  139 }, {  10, 10,  399 },
  {  11, 10,  469 }, {  12, 10,  634 }, { 141, 10,  223 }, { 133,  0,  673 },
  {   9,  0,  850 }, {   7, 11,    8 }, { 136, 11,  206 }, {   6,  0,  662 },
  { 149,  0,   35 }, {   4,  0,  287 }, { 133,  0, 1018 }, {   6, 10,  114 },
  {   7, 10, 1224 }, {   7, 10, 1556 }, { 136, 10,    3 }, {   8, 10,  576 },
  { 137, 10,  267 }, {   4,  0,  884 }, {   5,  0,   34 }, {  10,  0,  724 },
  {  12,  0,  444 }, {  13,  0,  354 }, {  18,  0,   32 }, {  23,  0,   24 },
  {  23,  0,   31 }, { 152,  0,    5 }, { 133, 10,  933 }, { 132, 11,  776 },
  { 138,  0,  151 }, { 136,  0,  427 }, { 134,  0,  382 }, { 132,  0,  329 },
  {   9,  0,  846 }, {  10,  0,  827 }, { 138, 11,   33 }, {   9,  0,  279 },
  {  10,  0,  407 }, {  14,  0,   84 }, {  22,  0,   18 }, { 135, 11, 1297 },
  { 136, 11,  406 }, { 132,  0,  906 }, { 136,  0,  366 }, { 134,  0,  843 },
  { 134,  0, 1443 }, { 135,  0, 1372 }, { 138,  0,  992 }, {   4,  0,  123 },
  {   5,  0,  605 }, {   7,  0, 1509 }, { 136,  0,   36 }, { 132,  0,  649 },
  {   8, 11,  175 }, {  10, 11,  168 }, { 138, 11,  573 }, { 133,  0,  767 },
  { 134,  0, 1018 }, { 135, 11, 1305 }, {  12, 10,   30 }, {  13, 10,  148 },
  {  14, 10,   87 }, {  14, 10,  182 }, {  16, 10,   42 }, { 148, 10,   70 },
  { 134, 11,  607 }, {   4,  0,  273 }, {   5,  0,  658 }, { 133,  0,  995 },
  {   6,  0,   72 }, { 139, 11,  174 }, {  10,  0,  483 }, {  12,  0,  368 },
  {   7, 10,   56 }, {   7, 10, 1989 }, {   8, 10,  337 }, {   8, 10,  738 },
  {   9, 10,  600 }, {  13, 10,  447 }, { 142, 10,   92 }, {   5, 11,  784 },
  { 138, 10,  666 }, { 135,  0, 1345 }, { 139, 11,  882 }, { 134,  0, 1293 },
  { 133,  0,  589 }, { 134,  0, 1988 }, {   5,  0,  117 }, {   6,  0,  514 },
  {   6,  0,  541 }, {   7,  0, 1164 }, {   7,  0, 1436 }, {   8,  0,  220 },
  {   8,  0,  648 }, {  10,  0,  688 }, { 139,  0,  560 }, { 136,  0,  379 },
  {   5,  0,  686 }, {   7, 10,  866 }, { 135, 10, 1163 }, { 132, 10,  328 },
  {   9, 11,   14 }, {   9, 11,  441 }, {  10, 11,  306 }, { 139, 11,    9 },
  {   4, 10,  101 }, { 135, 10, 1171 }, {   5, 10,  833 }, { 136, 10,  744 },
  {   5, 11,  161 }, {   7, 11,  839 }, { 135, 11,  887 }, {   7,  0,  196 },
  {  10,  0,  765 }, {  11,  0,  347 }, {  11,  0,  552 }, {  11,  0,  790 },
  {  12,  0,  263 }, {  13,  0,  246 }, {  13,  0,  270 }, {  13,  0,  395 },
  {  14,  0,  176 }, {  14,  0,  190 }, {  14,  0,  398 }, {  14,  0,  412 },
  {  15,  0,   32 }, {  15,  0,   63 }, {  16,  0,   88 }, { 147,  0,  105 },
  {   6, 10,    9 }, {   6, 10,  397 }, {   7, 10,   53 }, {   7, 10, 1742 },
  {  10, 10,  632 }, {  11, 10,  828 }, { 140, 10,  146 }, {   5,  0,  381 },
  { 135,  0, 1792 }, { 134,  0, 1452 }, { 135, 11,  429 }, {   8,  0,  367 },
  {  10,  0,  760 }, {  14,  0,   79 }, {  20,  0,   17 }, { 152,  0,    0 },
  {   7,  0,  616 }, { 138,  0,  413 }, {  11, 10,  417 }, {  12, 10,  223 },
  { 140, 10,  265 }, {   7, 11, 1611 }, {  13, 11,   14 }, {  15, 11,   44 },
  {  19, 11,   13 }, { 148, 11,   76 }, { 135,  0, 1229 }, {   6,  0,  120 },
  {   7,  0, 1188 }, {   7,  0, 1710 }, {   8,  0,  286 }, {   9,  0,  667 },
  {  11,  0,  592 }, { 139,  0,  730 }, { 135, 11, 1814 }, { 135,  0, 1146 },
  {   4, 10,  186 }, {   5, 10,  157 }, {   8, 10,  168 }, { 138, 10,    6 },
  {   4,  0,  352 }, { 135,  0,  687 }, {   4,  0,  192 }, {   5,  0,   49 },
  {   6,  0,  200 }, {   6,  0,  293 }, {   6,  0, 1696 }, { 135,  0, 1151 },
  { 133, 10,  875 }, {   5, 10,  773 }, {   5, 10,  991 }, {   6, 10, 1635 },
  { 134, 10, 1788 }, {   7, 10,  111 }, { 136, 10,  581 }, {   6,  0,  935 },
  { 134,  0, 1151 }, { 134,  0, 1050 }, { 132,  0,  650 }, { 132,  0,  147 },
  {  11,  0,  194 }, {  12,  0,   62 }, {  12,  0,   88 }, {  11, 11,  194 },
  {  12, 11,   62 }, { 140, 11,   88 }, {   6,  0,  339 }, { 135,  0,  923 },
  { 134, 10, 1747 }, {   7, 11,  643 }, { 136, 11,  236 }, { 133,  0,  934 },
  {   7, 10, 1364 }, {   7, 10, 1907 }, { 141, 10,  158 }, { 132, 10,  659 },
  {   4, 10,  404 }, { 135, 10,  675 }, {   7, 11,  581 }, {   9, 11,  644 },
  { 137, 11,  699 }, {  13,  0,  211 }, {  14,  0,  133 }, {  14,  0,  204 },
  {  15,  0,   64 }, {  15,  0,   69 }, {  15,  0,  114 }, {  16,  0,   10 },
  {  19,  0,   23 }, {  19,  0,   35 }, {  19,  0,   39 }, {  19,  0,   51 },
  {  19,  0,   71 }, {  19,  0,   75 }, { 152,  0,   15 }, { 133, 10,  391 },
  {   5, 11,   54 }, { 135, 11, 1513 }, {   7,  0,  222 }, {   8,  0,  341 },
  {   5, 10,  540 }, { 134, 10, 1697 }, { 134, 10,   78 }, { 132, 11,  744 },
  { 136,  0,  293 }, { 137, 11,  701 }, {   7, 11,  930 }, {  10, 11,  402 },
  {  10, 11,  476 }, {  13, 11,  452 }, {  18, 11,   55 }, { 147, 11,  104 },
  { 132,  0,  637 }, { 133, 10,  460 }, {   8, 11,   50 }, { 137, 11,  624 },
  { 132, 11,  572 }, { 134,  0, 1159 }, {   4, 10,  199 }, { 139, 10,   34 },
  { 134,  0,  847 }, { 134, 10,  388 }, {   6, 11,   43 }, {   7, 11,   38 },
  {   8, 11,  248 }, {   9, 11,  504 }, { 138, 11,  513 }, {   9,  0,  683 },
  {   4, 10,  511 }, {   6, 10,  608 }, {   9, 10,  333 }, {  10, 10,  602 },
  {  11, 10,  441 }, {  11, 10,  723 }, {  11, 10,  976 }, { 140, 10,  357 },
  {   9,  0,  867 }, { 138,  0,  837 }, {   6,  0,  944 }, { 135, 11,  326 },
  { 135,  0, 1809 }, {   5, 10,  938 }, {   7, 11,  783 }, { 136, 10,  707 },
  { 133, 11,  766 }, { 133, 11,  363 }, {   6,  0,  170 }, {   7,  0, 1080 },
  {   8,  0,  395 }, {   8,  0,  487 }, { 141,  0,  147 }, {   6, 11,  258 },
  { 140, 11,  409 }, {   4,  0,  535 }, {   8,  0,  618 }, {   5, 11,  249 },
  { 148, 11,   82 }, {   6,  0, 1379 }, { 149, 11,   15 }, { 135,  0, 1625 },
  { 150,  0,   23 }, {   5, 11,  393 }, {   6, 11,  378 }, {   7, 11, 1981 },
  {   9, 11,   32 }, {   9, 11,  591 }, {  10, 11,  685 }, {  10, 11,  741 },
  { 142, 11,  382 }, { 133, 11,  788 }, {   7, 11, 1968 }, {  10, 11,   19 },
  { 139, 11,  911 }, {   7, 11, 1401 }, { 135, 11, 1476 }, {   4, 11,   61 },
  {   5, 11,   58 }, {   5, 11,  171 }, {   5, 11,  635 }, {   5, 11,  683 },
  {   5, 11,  700 }, {   6, 11,  291 }, {   6, 11,  566 }, {   7, 11, 1650 },
  {  11, 11,  523 }, {  12, 11,  273 }, {  12, 11,  303 }, {  15, 11,   39 },
  { 143, 11,  111 }, {   6, 10,  469 }, {   7, 10, 1709 }, { 138, 10,  515 },
  {   4,  0,  778 }, { 134, 11,  589 }, { 132,  0,   46 }, {   5,  0,  811 },
  {   6,  0, 1679 }, {   6,  0, 1714 }, { 135,  0, 2032 }, {   7,  0, 1458 },
  {   9,  0,  407 }, {  11,  0,   15 }, {  12,  0,  651 }, { 149,  0,   37 },
  {   7,  0,  938 }, { 132, 10,  500 }, {   6,  0,   34 }, {   7,  0,   69 },
  {   7,  0, 1089 }, {   7,  0, 1281 }, {   8,  0,  708 }, {   8,  0,  721 },
  {   9,  0,  363 }, { 148,  0,   98 }, {  10, 11,  231 }, { 147, 11,  124 },
  {   7, 11,  726 }, { 152, 11,    9 }, {   5, 10,   68 }, { 134, 10,  383 },
  { 136, 11,  583 }, {   4, 11,  917 }, { 133, 11, 1005 }, {  11, 10,  216 },
  { 139, 10,  340 }, { 135, 11, 1675 }, {   8,  0,  441 }, {  10,  0,  314 },
  { 143,  0,    3 }, { 132, 11,  919 }, {   4, 10,  337 }, {   6, 10,  353 },
  {   7, 10, 1934 }, {   8, 10,  488 }, { 137, 10,  429 }, {   7,  0,  889 },
  {   7, 10, 1795 }, {   8, 10,  259 }, {   9, 10,  135 }, {   9, 10,  177 },
  {   9, 10,  860 }, {  10, 10,  825 }, {  11, 10,  115 }, {  11, 10,  370 },
  {  11, 10,  405 }, {  11, 10,  604 }, {  12, 10,   10 }, {  12, 10,  667 },
  {  12, 10,  669 }, {  13, 10,   76 }, {  14, 10,  310 }, {  15, 10,   76 },
  {  15, 10,  147 }, { 148, 10,   23 }, {   4, 10,   15 }, {   4, 11,  255 },
  {   5, 10,   22 }, {   5, 11,  302 }, {   6, 11,  132 }, {   6, 10,  244 },
  {   7, 10,   40 }, {   7, 11,  128 }, {   7, 10,  200 }, {   7, 11,  283 },
  {   7, 10,  906 }, {   7, 10, 1199 }, {   7, 11, 1299 }, {   9, 10,  616 },
  {  10, 11,   52 }, {  10, 11,  514 }, {  10, 10,  716 }, {  11, 10,  635 },
  {  11, 10,  801 }, {  11, 11,  925 }, {  12, 10,  458 }, {  13, 11,   92 },
  { 142, 11,  309 }, { 132,  0,  462 }, { 137, 11,  173 }, { 135, 10, 1735 },
  {   8,  0,  525 }, {   5, 10,  598 }, {   7, 10,  791 }, {   8, 10,  108 },
  { 137, 10,  123 }, {   5,  0,   73 }, {   6,  0,   23 }, { 134,  0,  338 },
  { 132,  0,  676 }, { 132, 10,  683 }, {   7,  0,  725 }, {   8,  0,  498 },
  { 139,  0,  268 }, {  12,  0,   21 }, { 151,  0,    7 }, { 135,  0,  773 },
  {   4, 10,  155 }, { 135, 10, 1689 }, {   4,  0,  164 }, {   5,  0,  730 },
  {   5, 10,  151 }, {   5, 10,  741 }, {   6, 11,  210 }, {   7, 10,  498 },
  {   7, 10,  870 }, {   7, 10, 1542 }, {  12, 10,  213 }, {  14, 10,   36 },
  {  14, 10,  391 }, {  17, 10,  111 }, {  18, 10,    6 }, {  18, 10,   46 },
  {  18, 10,  151 }, {  19, 10,   36 }, {  20, 10,   32 }, {  20, 10,   56 },
  {  20, 10,   69 }, {  20, 10,  102 }, {  21, 10,    4 }, {  22, 10,    8 },
  {  22, 10,   10 }, {  22, 10,   14 }, { 150, 10,   31 }, {   4, 10,  624 },
  { 135, 10, 1752 }, {   4,  0,  583 }, {   9,  0,  936 }, {  15,  0,  214 },
  {  18,  0,  199 }, {  24,  0,   26 }, { 134, 11,  588 }, {   7,  0, 1462 },
  {  11,  0,  659 }, {   4, 11,  284 }, { 134, 11,  223 }, { 133,  0,  220 },
  { 139,  0,  803 }, { 132,  0,  544 }, {   4, 10,  492 }, { 133, 10,  451 },
  {  16,  0,   98 }, { 148,  0,  119 }, {   4, 11,  218 }, {   7, 11,  526 },
  { 143, 11,  137 }, { 135, 10,  835 }, {   4, 11,  270 }, {   5, 11,  192 },
  {   6, 11,  332 }, {   7, 11, 1322 }, {  13, 11,    9 }, {  13, 10,   70 },
  {  14, 11,  104 }, { 142, 11,  311 }, { 132, 10,  539 }, { 140, 11,  661 },
  {   5,  0,  176 }, {   6,  0,  437 }, {   6,  0,  564 }, {  11,  0,  181 },
  { 141,  0,  183 }, { 135,  0, 1192 }, {   6, 10,  113 }, { 135, 10,  436 },
  { 136, 10,  718 }, { 135, 10,  520 }, { 135,  0, 1878 }, { 140, 11,  196 },
  {   7, 11,  379 }, {   8, 11,  481 }, { 137, 11,  377 }, {   5, 11, 1003 },
  {   6, 11,  149 }, { 137, 11,  746 }, {   8, 11,  262 }, {   9, 11,  627 },
  {  10, 11,   18 }, {  11, 11,  214 }, {  11, 11,  404 }, {  11, 11,  457 },
  {  11, 11,  780 }, {  11, 11,  849 }, {  11, 11,  913 }, {  13, 11,  330 },
  {  13, 11,  401 }, { 142, 11,  200 }, { 149,  0,   26 }, { 136, 11,  304 },
  { 132, 11,  142 }, { 135,  0,  944 }, {   4,  0,  790 }, {   5,  0,  273 },
  { 134,  0,  394 }, { 134,  0,  855 }, {   4,  0,  135 }, {   6,  0,  127 },
  {   7,  0, 1185 }, {   7,  0, 1511 }, {   8,  0,  613 }, {  11,  0,    5 },
  {  12,  0,  336 }, {  12,  0,  495 }, {  12,  0,  586 }, {  12,  0,  660 },
  {  12,  0,  668 }, {  14,  0,  385 }, {  15,  0,  118 }, {  17,  0,   20 },
  { 146,  0,   98 }, {   6,  0,  230 }, {   9,  0,  752 }, {  18,  0,  109 },
  {  12, 10,  610 }, {  13, 10,  431 }, { 144, 10,   59 }, {   7,  0, 1954 },
  { 135, 11,  925 }, {   4, 11,  471 }, {   5, 11,   51 }, {   6, 11,  602 },
  {   8, 11,  484 }, {  10, 11,  195 }, { 140, 11,  159 }, { 132, 10,  307 },
  { 136, 11,  688 }, { 132, 11,  697 }, {   7, 11,  812 }, {   7, 11, 1261 },
  {   7, 11, 1360 }, {   9, 11,  632 }, { 140, 11,  352 }, {   5,  0,  162 },
  {   8,  0,   68 }, { 133, 10,  964 }, {   4,  0,  654 }, { 136, 11,  212 },
  {   4,  0,  156 }, {   7,  0,  998 }, {   7,  0, 1045 }, {   7,  0, 1860 },
  {   9,  0,   48 }, {   9,  0,  692 }, {  11,  0,  419 }, { 139,  0,  602 },
  { 133, 11,  221 }, {   4, 11,  373 }, {   5, 11,  283 }, {   6, 11,  480 },
  { 135, 11,  609 }, { 142, 11,  216 }, { 132,  0,  240 }, {   6, 11,  192 },
  {   9, 11,  793 }, { 145, 11,   55 }, {   4, 10,   75 }, {   5, 10,  180 },
  {   6, 10,  500 }, {   7, 10,   58 }, {   7, 10,  710 }, { 138, 10,  645 },
  {   4, 11,  132 }, {   5, 11,   69 }, {   5, 10,  649 }, { 135, 11, 1242 },
  {   6, 10,  276 }, {   7, 10,  282 }, {   7, 10,  879 }, {   7, 10,  924 },
  {   8, 10,  459 }, {   9, 10,  599 }, {   9, 10,  754 }, {  11, 10,  574 },
  {  12, 10,  128 }, {  12, 10,  494 }, {  13, 10,   52 }, {  13, 10,  301 },
  {  15, 10,   30 }, { 143, 10,  132 }, { 132, 10,  200 }, {   4, 11,  111 },
  { 135, 11,  302 }, {   9,  0,  197 }, {  10,  0,  300 }, {  12,  0,  473 },
  {  13,  0,   90 }, { 141,  0,  405 }, { 132, 11,  767 }, {   6, 11,   42 },
  {   7, 11, 1416 }, {   7, 11, 1590 }, {   7, 11, 2005 }, {   8, 11,  131 },
  {   8, 11,  466 }, {   9, 11,  672 }, {  13, 11,  252 }, { 148, 11,  103 },
  {   8,  0,  958 }, {   8,  0,  999 }, {  10,  0,  963 }, { 138,  0, 1001 },
  { 135, 10, 1621 }, { 135,  0,  858 }, {   4,  0,  606 }, { 137, 11,  444 },
  {   6, 11,   44 }, { 136, 11,  368 }, { 139, 11,  172 }, {   4, 11,  570 },
  { 133, 11,  120 }, { 139, 11,  624 }, {   7,  0, 1978 }, {   8,  0,  676 },
  {   6, 10,  225 }, { 137, 10,  211 }, {   7,  0,  972 }, {  11,  0,  102 },
  { 136, 10,  687 }, {   6, 11,  227 }, { 135, 11, 1589 }, {   8, 10,   58 },
  {   9, 10,  724 }, {  11, 10,  809 }, {  13, 10,  113 }, { 145, 10,   72 },
  {   4,  0,  361 }, { 133,  0,  315 }, { 132,  0,  461 }, {   6, 10,  345 },
  { 135, 10, 1247 }, { 132,  0,  472 }, {   8, 10,  767 }, {   8, 10,  803 },
  {   9, 10,  301 }, { 137, 10,  903 }, { 135, 11, 1333 }, { 135, 11,  477 },
  {   7, 10, 1949 }, { 136, 10,  674 }, {   6,  0,  905 }, { 138,  0,  747 },
  { 133,  0,  155 }, { 134, 10,  259 }, {   7,  0,  163 }, {   8,  0,  319 },
  {   9,  0,  402 }, {  10,  0,   24 }, {  10,  0,  681 }, {  11,  0,  200 },
  {  12,  0,  253 }, {  12,  0,  410 }, { 142,  0,  219 }, {   5,  0,  475 },
  {   7,  0, 1780 }, {   9,  0,  230 }, {  11,  0,  297 }, {  11,  0,  558 },
  {  14,  0,  322 }, {  19,  0,   76 }, {   6, 11, 1667 }, {   7, 11, 2036 },
  { 138, 11,  600 }, { 136, 10,  254 }, {   6,  0,  848 }, { 135,  0, 1956 },
  {   6, 11,  511 }, { 140, 11,  132 }, {   5, 11,  568 }, {   6, 11,  138 },
  { 135, 11, 1293 }, {   6,  0,  631 }, { 137,  0,  838 }, { 149,  0,   36 },
  {   4, 11,  565 }, {   8, 11,   23 }, { 136, 11,  827 }, {   5,  0,  944 },
  { 134,  0, 1769 }, {   4,  0,  144 }, {   6,  0,  842 }, {   6,  0, 1400 },
  {   4, 11,  922 }, { 133, 11, 1023 }, { 133, 10,  248 }, {   9, 10,  800 },
  {  10, 10,  693 }, {  11, 10,  482 }, {  11, 10,  734 }, { 139, 10,  789 },
  {   7, 11, 1002 }, { 139, 11,  145 }, {   4, 10,  116 }, {   5, 10,   95 },
  {   5, 10,  445 }, {   7, 10, 1688 }, {   8, 10,   29 }, {   9, 10,  272 },
  {  11, 10,  509 }, { 139, 10,  915 }, {  14,  0,  369 }, { 146,  0,   72 },
  { 135, 10, 1641 }, { 132, 11,  740 }, { 133, 10,  543 }, { 140, 11,  116 },
  {   6,  0,  247 }, {   9,  0,  555 }, {   5, 10,  181 }, { 136, 10,   41 },
  { 133, 10,  657 }, { 136,  0,  996 }, { 138, 10,  709 }, {   7,  0,  189 },
  {   8, 10,  202 }, { 138, 10,  536 }, { 136, 11,  402 }, {   4, 11,  716 },
  { 141, 11,   31 }, {  10,  0,  280 }, { 138,  0,  797 }, {   9, 10,  423 },
  { 140, 10,   89 }, {   8, 10,  113 }, {   9, 10,  877 }, {  10, 10,  554 },
  {  11, 10,   83 }, {  12, 10,  136 }, { 147, 10,  109 }, { 133, 10,  976 },
  {   7,  0,  746 }, { 132, 10,  206 }, { 136,  0,  526 }, { 139,  0,  345 },
  { 136,  0, 1017 }, {   8, 11,  152 }, {   9, 11,   53 }, {   9, 11,  268 },
  {   9, 11,  901 }, {  10, 11,  518 }, {  10, 11,  829 }, {  11, 11,  188 },
  {  13, 11,   74 }, {  14, 11,   46 }, {  15, 11,   17 }, {  15, 11,   33 },
  {  17, 11,   40 }, {  18, 11,   36 }, {  19, 11,   20 }, {  22, 11,    1 },
  { 152, 11,    2 }, { 133, 11,  736 }, { 136, 11,  532 }, {   5,  0,  428 },
  { 138,  0,  651 }, { 135, 11,  681 }, { 135,  0, 1162 }, {   7,  0,  327 },
  {  13,  0,  230 }, {  17,  0,  113 }, {   8, 10,  226 }, {  10, 10,  537 },
  {  11, 10,  570 }, {  11, 10,  605 }, {  11, 10,  799 }, {  11, 10,  804 },
  {  12, 10,   85 }, {  12, 10,  516 }, {  12, 10,  623 }, {  12, 11,  677 },
  {  13, 10,  361 }, {  14, 10,   77 }, {  14, 10,   78 }, { 147, 10,  110 },
  {   4,  0,  792 }, {   7,  0, 1717 }, {  10,  0,  546 }, { 132, 10,  769 },
  {   4, 11,  684 }, { 136, 11,  384 }, { 132, 10,  551 }, { 134,  0, 1203 },
  {   9, 10,   57 }, {   9, 10,  459 }, {  10, 10,  425 }, {  11, 10,  119 },
  {  12, 10,  184 }, {  12, 10,  371 }, {  13, 10,  358 }, { 145, 10,   51 },
  {   5,  0,  672 }, {   5, 10,  814 }, {   8, 10,   10 }, {   9, 10,  421 },
  {   9, 10,  729 }, {  10, 10,  609 }, { 139, 10,  689 }, { 138,  0,  189 },
  { 134, 10,  624 }, {   7, 11,  110 }, {   7, 11,  188 }, {   8, 11,  290 },
  {   8, 11,  591 }, {   9, 11,  382 }, {   9, 11,  649 }, {  11, 11,   71 },
  {  11, 11,  155 }, {  11, 11,  313 }, {  12, 11,    5 }, {  13, 11,  325 },
  { 142, 11,  287 }, { 133,  0,   99 }, {   6,  0, 1053 }, { 135,  0,  298 },
  {   7, 11,  360 }, {   7, 11,  425 }, {   9, 11,   66 }, {   9, 11,  278 },
  { 138, 11,  644 }, {   4,  0,  397 }, { 136,  0,  555 }, { 137, 10,  269 },
  { 132, 10,  528 }, {   4, 11,  900 }, { 133, 11,  861 }, {   6,  0, 1157 },
  {   5, 11,  254 }, {   7, 11,  985 }, { 136, 11,   73 }, {   7, 11, 1959 },
  { 136, 11,  683 }, {  12,  0,  398 }, {  20,  0,   39 }, {  21,  0,   11 },
  { 150,  0,   41 }, {   4,  0,  485 }, {   7,  0,  353 }, { 135,  0, 1523 },
  {   6,  0,  366 }, {   7,  0, 1384 }, { 135,  0, 1601 }, { 138,  0,  787 },
  { 137,  0,  282 }, {   5, 10,  104 }, {   6, 10,  173 }, { 135, 10, 1631 },
  { 139, 11,  146 }, {   4,  0,  157 }, { 133,  0,  471 }, { 134,  0,  941 },
  { 132, 11,  725 }, {   7,  0, 1336 }, {   8, 10,  138 }, {   8, 10,  342 },
  {   9, 10,   84 }, {  10, 10,  193 }, {  11, 10,  883 }, { 140, 10,  359 },
  { 134, 11,  196 }, { 136,  0,  116 }, { 133, 11,  831 }, { 134,  0,  787 },
  { 134, 10,   95 }, {   6, 10,  406 }, {  10, 10,  409 }, {  10, 10,  447 },
  {  11, 10,   44 }, { 140, 10,  100 }, {   5,  0,  160 }, {   7,  0,  363 },
  {   7,  0,  589 }, {  10,  0,  170 }, { 141,  0,   55 }, { 134,  0, 1815 },
  { 132,  0,  866 }, {   6,  0,  889 }, {   6,  0, 1067 }, {   6,  0, 1183 },
  {   4, 11,  321 }, { 134, 11,  569 }, {   5, 11,  848 }, { 134, 11,   66 },
  {   4, 11,   36 }, {   6, 10, 1636 }, {   7, 11, 1387 }, {  10, 11,  205 },
  {  11, 11,  755 }, { 141, 11,  271 }, { 132,  0,  689 }, {   9,  0,  820 },
  {   4, 10,  282 }, {   7, 10, 1034 }, {  11, 10,  398 }, {  11, 10,  634 },
  {  12, 10,    1 }, {  12, 10,   79 }, {  12, 10,  544 }, {  14, 10,  237 },
  {  17, 10,   10 }, { 146, 10,   20 }, {   4,  0,  108 }, {   7,  0,  804 },
  { 139,  0,  498 }, { 132, 11,  887 }, {   6,  0, 1119 }, { 135, 11,  620 },
  {   6, 11,  165 }, { 138, 11,  388 }, {   5,  0,  244 }, {   5, 10,  499 },
  {   6, 10,  476 }, {   7, 10,  600 }, {   7, 10,  888 }, { 135, 10, 1096 },
  { 140,  0,  609 }, { 135,  0, 1005 }, {   4,  0,  412 }, { 133,  0,  581 },
  {   4, 11,  719 }, { 135, 11,  155 }, {   7, 10,  296 }, {   7, 10,  596 },
  {   8, 10,  560 }, {   8, 10,  586 }, {   9, 10,  612 }, {  11, 10,  304 },
  {  12, 10,   46 }, {  13, 10,   89 }, {  14, 10,  112 }, { 145, 10,  122 },
  {   4,  0,  895 }, { 133,  0,  772 }, { 142, 11,  307 }, { 135,  0, 1898 },
  {   4,  0,  926 }, { 133,  0,  983 }, {   4, 11,  353 }, {   6, 11,  146 },
  {   6, 11, 1789 }, {   7, 11,  288 }, {   7, 11,  990 }, {   7, 11, 1348 },
  {   9, 11,  665 }, {   9, 11,  898 }, {  11, 11,  893 }, { 142, 11,  212 },
  { 132,  0,  538 }, { 133, 11,  532 }, {   6,  0,  294 }, {   7,  0, 1267 },
  {   8,  0,  624 }, { 141,  0,  496 }, {   7,  0, 1325 }, {   4, 11,   45 },
  { 135, 11, 1257 }, { 138,  0,  301 }, {   9,  0,  298 }, {  12,  0,  291 },
  {  13,  0,  276 }, {  14,  0,    6 }, {  17,  0,   18 }, {  21,  0,   32 },
  {   7, 10, 1599 }, {   7, 10, 1723 }, {   8, 10,   79 }, {   8, 10,  106 },
  {   8, 10,  190 }, {   8, 10,  302 }, {   8, 10,  383 }, {   8, 10,  713 },
  {   9, 10,  119 }, {   9, 10,  233 }, {   9, 10,  419 }, {   9, 10,  471 },
  {  10, 10,  181 }, {  10, 10,  406 }, {  11, 10,   57 }, {  11, 10,   85 },
  {  11, 10,  120 }, {  11, 10,  177 }, {  11, 10,  296 }, {  11, 10,  382 },
  {  11, 10,  454 }, {  11, 10,  758 }, {  11, 10,  999 }, {  12, 10,   27 },
  {  12, 10,  131 }, {  12, 10,  245 }, {  12, 10,  312 }, {  12, 10,  446 },
  {  12, 10,  454 }, {  13, 10,   98 }, {  13, 10,  426 }, {  13, 10,  508 },
  {  14, 10,  163 }, {  14, 10,  272 }, {  14, 10,  277 }, {  14, 10,  370 },
  {  15, 10,   95 }, {  15, 10,  138 }, {  15, 10,  167 }, {  17, 10,   38 },
  { 148, 10,   96 }, { 132,  0,  757 }, { 134,  0, 1263 }, {   4,  0,  820 },
  { 134, 10, 1759 }, { 133,  0,  722 }, { 136, 11,  816 }, { 138, 10,  372 },
  { 145, 10,   16 }, { 134,  0, 1039 }, {   4,  0,  991 }, { 134,  0, 2028 },
  { 133, 10,  258 }, {   7,  0, 1875 }, { 139,  0,  124 }, {   6, 11,  559 },
  {   6, 11, 1691 }, { 135, 11,  586 }, {   5,  0,  324 }, {   7,  0,  881 },
  {   8, 10,  134 }, {   9, 10,  788 }, { 140, 10,  438 }, {   7, 11, 1823 },
  { 139, 11,  693 }, {   6,  0, 1348 }, { 134,  0, 1545 }, { 134,  0,  911 },
  { 132,  0,  954 }, {   8,  0,  329 }, {   8,  0,  414 }, {   7, 10, 1948 },
  { 135, 10, 2004 }, {   5,  0,  517 }, {   6, 10,  439 }, {   7, 10,  780 },
  { 135, 10, 1040 }, { 132,  0,  816 }, {   5, 10,    1 }, {   6, 10,   81 },
  { 138, 10,  520 }, {   9,  0,  713 }, {  10,  0,  222 }, {   5, 10,  482 },
  {   8, 10,   98 }, {  10, 10,  700 }, {  10, 10,  822 }, {  11, 10,  302 },
  {  11, 10,  778 }, {  12, 10,   50 }, {  12, 10,  127 }, {  12, 10,  396 },
  {  13, 10,   62 }, {  13, 10,  328 }, {  14, 10,  122 }, { 147, 10,   72 },
  { 137,  0,   33 }, {   5, 10,    2 }, {   7, 10, 1494 }, { 136, 10,  589 },
  {   6, 10,  512 }, {   7, 10,  797 }, {   8, 10,  253 }, {   9, 10,   77 },
  {  10, 10,    1 }, {  10, 11,  108 }, {  10, 10,  129 }, {  10, 10,  225 },
  {  11, 11,  116 }, {  11, 10,  118 }, {  11, 10,  226 }, {  11, 10,  251 },
  {  11, 10,  430 }, {  11, 10,  701 }, {  11, 10,  974 }, {  11, 10,  982 },
  {  12, 10,   64 }, {  12, 10,  260 }, {  12, 10,  488 }, { 140, 10,  690 },
  { 134, 11,  456 }, { 133, 11,  925 }, {   5,  0,  150 }, {   7,  0,  106 },
  {   7,  0,  774 }, {   8,  0,  603 }, {   9,  0,  593 }, {   9,  0,  634 },
  {  10,  0,   44 }, {  10,  0,  173 }, {  11,  0,  462 }, {  11,  0,  515 },
  {  13,  0,  216 }, {  13,  0,  288 }, { 142,  0,  400 }, { 137, 10,  347 },
  {   5,  0,  748 }, { 134,  0,  553 }, {  12,  0,  108 }, { 141,  0,  291 },
  {   7,  0,  420 }, {   4, 10,   12 }, {   7, 10,  522 }, {   7, 10,  809 },
  {   8, 10,  797 }, { 141, 10,   88 }, {   6, 11,  193 }, {   7, 11,  240 },
  {   7, 11, 1682 }, {  10, 11,   51 }, {  10, 11,  640 }, {  11, 11,  410 },
  {  13, 11,   82 }, {  14, 11,  247 }, {  14, 11,  331 }, { 142, 11,  377 },
  { 133, 10,  528 }, { 135,  0, 1777 }, {   4,  0,  493 }, { 144,  0,   55 },
  { 136, 11,  633 }, { 139,  0,   81 }, {   6,  0,  980 }, { 136,  0,  321 },
  { 148, 10,  109 }, {   5, 10,  266 }, {   9, 10,  290 }, {   9, 10,  364 },
  {  10, 10,  293 }, {  11, 10,  606 }, { 142, 10,   45 }, {   6,  0,  568 },
  {   7,  0,  112 }, {   7,  0, 1804 }, {   8,  0,  362 }, {   8,  0,  410 },
  {   8,  0,  830 }, {   9,  0,  514 }, {  11,  0,  649 }, { 142,  0,  157 },
  {   4,  0,   74 }, {   6,  0,  510 }, {   6, 10,  594 }, {   9, 10,  121 },
  {  10, 10,   49 }, {  10, 10,  412 }, { 139, 10,  834 }, { 134,  0,  838 },
  { 136, 10,  748 }, { 132, 10,  466 }, { 132,  0,  625 }, { 135, 11, 1443 },
  {   4, 11,  237 }, { 135, 11,  514 }, {   9, 10,  378 }, { 141, 10,  162 },
  {   6,  0,   16 }, {   6,  0,  158 }, {   7,  0,   43 }, {   7,  0,  129 },
  {   7,  0,  181 }, {   8,  0,  276 }, {   8,  0,  377 }, {  10,  0,  523 },
  {  11,  0,  816 }, {  12,  0,  455 }, {  13,  0,  303 }, { 142,  0,  135 },
  { 135,  0,  281 }, {   4,  0,    1 }, {   7,  0, 1143 }, {   7,  0, 1463 },
  {   8,  0,   61 }, {   9,  0,  207 }, {   9,  0,  390 }, {   9,  0,  467 },
  { 139,  0,  836 }, {   6, 11,  392 }, {   7, 11,   65 }, { 135, 11, 2019 },
  { 132, 10,  667 }, {   4,  0,  723 }, {   5,  0,  895 }, {   7,  0, 1031 },
  {   8,  0,  199 }, {   8,  0,  340 }, {   9,  0,  153 }, {   9,  0,  215 },
  {  10,  0,   21 }, {  10,  0,   59 }, {  10,  0,   80 }, {  10,  0,  224 },
  {  10,  0,  838 }, {  11,  0,  229 }, {  11,  0,  652 }, {  12,  0,  192 },
  {  13,  0,  146 }, { 142,  0,   91 }, { 132,  0,  295 }, { 137,  0,   51 },
  {   9, 11,  222 }, {  10, 11,   43 }, { 139, 11,  900 }, {   5,  0,  309 },
  { 140,  0,  211 }, {   5,  0,  125 }, {   8,  0,   77 }, { 138,  0,   15 },
  { 136, 11,  604 }, { 138,  0,  789 }, {   5,  0,  173 }, {   4, 10,   39 },
  {   7, 10, 1843 }, {   8, 10,  407 }, {  11, 10,  144 }, { 140, 10,  523 },
  { 138, 11,  265 }, { 133,  0,  439 }, { 132, 10,  510 }, {   7,  0,  648 },
  {   7,  0,  874 }, {  11,  0,  164 }, {  12,  0,   76 }, {  18,  0,    9 },
  {   7, 10, 1980 }, {  10, 10,  487 }, { 138, 10,  809 }, {  12,  0,  111 },
  {  14,  0,  294 }, {  19,  0,   45 }, {  13, 10,  260 }, { 146, 10,   63 },
  { 133, 11,  549 }, { 134, 10,  570 }, {   4,  0,    8 }, {   7,  0, 1152 },
  {   7,  0, 1153 }, {   7,  0, 1715 }, {   9,  0,  374 }, {  10,  0,  478 },
  { 139,  0,  648 }, { 135,  0, 1099 }, {   5,  0,  575 }, {   6,  0,  354 },
  { 135,  0,  701 }, {   7, 11,   36 }, {   8, 11,  201 }, { 136, 11,  605 },
  {   4, 10,  787 }, { 136, 11,  156 }, {   6,  0,  518 }, { 149, 11,   13 },
  { 140, 11,  224 }, { 134,  0,  702 }, { 132, 10,  516 }, {   5, 11,  724 },
  {  10, 11,  305 }, {  11, 11,  151 }, {  12, 11,   33 }, {  12, 11,  121 },
  {  12, 11,  381 }, {  17, 11,    3 }, {  17, 11,   27 }, {  17, 11,   78 },
  {  18, 11,   18 }, {  19, 11,   54 }, { 149, 11,    5 }, {   8,  0,   87 },
  {   4, 11,  523 }, {   5, 11,  638 }, {  11, 10,  887 }, {  14, 10,  365 },
  { 142, 10,  375 }, { 138,  0,  438 }, { 136, 10,  821 }, { 135, 11, 1908 },
  {   6, 11,  242 }, {   7, 11,  227 }, {   7, 11, 1581 }, {   8, 11,  104 },
  {   9, 11,  113 }, {   9, 11,  220 }, {   9, 11,  427 }, {  10, 11,   74 },
  {  10, 11,  239 }, {  11, 11,  579 }, {  11, 11, 1023 }, {  13, 11,    4 },
  {  13, 11,  204 }, {  13, 11,  316 }, {  18, 11,   95 }, { 148, 11,   86 },
  {   4,  0,   69 }, {   5,  0,  122 }, {   5,  0,  849 }, {   6,  0, 1633 },
  {   9,  0,  656 }, { 138,  0,  464 }, {   7,  0, 1802 }, {   4, 10,   10 },
  { 139, 10,  786 }, { 135, 11,  861 }, { 139,  0,  499 }, {   7,  0,  476 },
  {   7,  0, 1592 }, { 138,  0,   87 }, { 133, 10,  684 }, {   4,  0,  840 },
  { 134, 10,   27 }, { 142,  0,  283 }, {   6,  0, 1620 }, {   7, 11, 1328 },
  { 136, 11,  494 }, {   5,  0,  859 }, {   7,  0, 1160 }, {   8,  0,  107 },
  {   9,  0,  291 }, {   9,  0,  439 }, {  10,  0,  663 }, {  11,  0,  609 },
  { 140,  0,  197 }, {   7, 11, 1306 }, {   8, 11,  505 }, {   9, 11,  482 },
  {  10, 11,  126 }, {  11, 11,  225 }, {  12, 11,  347 }, {  12, 11,  449 },
  {  13, 11,   19 }, { 142, 11,  218 }, {   5, 11,  268 }, {  10, 11,  764 },
  {  12, 11,  120 }, {  13, 11,   39 }, { 145, 11,  127 }, { 145, 10,   56 },
  {   7, 11, 1672 }, {  10, 11,  472 }, {  11, 11,  189 }, { 143, 11,   51 },
  {   6, 10,  342 }, {   6, 10,  496 }, {   8, 10,  275 }, { 137, 10,  206 },
  { 133,  0,  600 }, {   4,  0,  117 }, {   6,  0,  372 }, {   7,  0, 1905 },
  { 142,  0,  323 }, {   4, 10,  909 }, {   5, 10,  940 }, { 135, 11, 1471 },
  { 132, 10,  891 }, {   4,  0,  722 }, { 139,  0,  471 }, {   4, 11,  384 },
  { 135, 11, 1022 }, { 132, 10,  687 }, {   9,  0,    5 }, {  12,  0,  216 },
  {  12,  0,  294 }, {  12,  0,  298 }, {  12,  0,  400 }, {  12,  0,  518 },
  {  13,  0,  229 }, { 143,  0,  139 }, { 135, 11, 1703 }, {   7, 11, 1602 },
  {  10, 11,  698 }, {  12, 11,  212 }, { 141, 11,  307 }, {   6, 10,   41 },
  { 141, 10,  160 }, { 135, 11, 1077 }, {   9, 11,  159 }, {  11, 11,   28 },
  { 140, 11,  603 }, {   4,  0,  514 }, {   7,  0, 1304 }, { 138,  0,  477 },
  { 134,  0, 1774 }, {   9,  0,   88 }, { 139,  0,  270 }, {   5,  0,   12 },
  {   7,  0,  375 }, {   9,  0,  438 }, { 134, 10, 1718 }, { 132, 11,  515 },
  { 136, 10,  778 }, {   8, 11,  632 }, {   8, 11,  697 }, { 137, 11,  854 },
  {   6,  0,  362 }, {   6,  0,  997 }, { 146,  0,   51 }, {   7,  0,  816 },
  {   7,  0, 1241 }, {   9,  0,  283 }, {   9,  0,  520 }, {  10,  0,  213 },
  {  10,  0,  307 }, {  10,  0,  463 }, {  10,  0,  671 }, {  10,  0,  746 },
  {  11,  0,  401 }, {  11,  0,  794 }, {  12,  0,  517 }, {  18,  0,  107 },
  { 147,  0,  115 }, { 133, 10,  115 }, { 150, 11,   28 }, {   4, 11,  136 },
  { 133, 11,  551 }, { 142, 10,  314 }, { 132,  0,  258 }, {   6,  0,   22 },
  {   7,  0,  903 }, {   7,  0, 1963 }, {   8,  0,  639 }, { 138,  0,  577 },
  {   5,  0,  681 }, {   8,  0,  782 }, {  13,  0,  130 }, {  17,  0,   84 },
  {   5, 10,  193 }, { 140, 10,  178 }, {   9, 11,   17 }, { 138, 11,  291 },
  {   7, 11, 1287 }, {   9, 11,   44 }, {  10, 11,  552 }, {  10, 11,  642 },
  {  11, 11,  839 }, {  12, 11,  274 }, {  12, 11,  275 }, {  12, 11,  372 },
  {  13, 11,   91 }, { 142, 11,  125 }, { 135, 10,  174 }, {   4,  0,  664 },
  {   5,  0,  804 }, { 139,  0, 1013 }, { 134,  0,  942 }, {   6,  0, 1349 },
  {   6,  0, 1353 }, {   6,  0, 1450 }, {   7, 11, 1518 }, { 139, 11,  694 },
  {  11,  0,  356 }, {   4, 10,  122 }, {   5, 10,  796 }, {   5, 10,  952 },
  {   6, 10, 1660 }, {   6, 10, 1671 }, {   8, 10,  567 }, {   9, 10,  687 },
  {   9, 10,  742 }, {  10, 10,  686 }, {  11, 10,  682 }, { 140, 10,  281 },
  {   5,  0,   32 }, {   6, 11,  147 }, {   7, 11,  886 }, {   9, 11,  753 },
  { 138, 11,  268 }, {   5, 10,  179 }, {   7, 10, 1095 }, { 135, 10, 1213 },
  {   4, 10,   66 }, {   7, 10,  722 }, { 135, 10,  904 }, { 135, 10,  352 },
  {   9, 11,  245 }, { 138, 11,  137 }, {   4,  0,  289 }, {   7,  0,  629 },
  {   7,  0, 1698 }, {   7,  0, 1711 }, {  12,  0,  215 }, { 133, 11,  414 },
  {   6,  0, 1975 }, { 135, 11, 1762 }, {   6,  0,  450 }, { 136,  0,  109 },
  { 141, 10,   35 }, { 134, 11,  599 }, { 136,  0,  705 }, { 133,  0,  664 },
  { 134, 11, 1749 }, {  11, 11,  402 }, {  12, 11,  109 }, {  12, 11,  431 },
  {  13, 11,  179 }, {  13, 11,  206 }, {  14, 11,  175 }, {  14, 11,  217 },
  {  16, 11,    3 }, { 148, 11,   53 }, { 135,  0, 1238 }, { 134, 11, 1627 },
  { 132, 11,  488 }, {  13,  0,  318 }, {  10, 10,  592 }, {  10, 10,  753 },
  {  12, 10,  317 }, {  12, 10,  355 }, {  12, 10,  465 }, {  12, 10,  469 },
  {  12, 10,  560 }, { 140, 10,  578 }, { 133, 10,  564 }, { 132, 11,   83 },
  { 140, 11,  676 }, {   6,  0, 1872 }, {   6,  0, 1906 }, {   6,  0, 1907 },
  {   9,  0,  934 }, {   9,  0,  956 }, {   9,  0,  960 }, {   9,  0,  996 },
  {  12,  0,  794 }, {  12,  0,  876 }, {  12,  0,  880 }, {  12,  0,  918 },
  {  15,  0,  230 }, {  18,  0,  234 }, {  18,  0,  238 }, {  21,  0,   38 },
  { 149,  0,   62 }, { 134, 10,  556 }, { 134, 11,  278 }, { 137,  0,  103 },
  {   7, 10,  544 }, {   8, 10,  719 }, { 138, 10,   61 }, {   4, 10,    5 },
  {   5, 10,  498 }, {   8, 10,  637 }, { 137, 10,  521 }, {   7,  0,  777 },
  {  12,  0,  229 }, {  12,  0,  239 }, {  15,  0,   12 }, {  12, 11,  229 },
  {  12, 11,  239 }, { 143, 11,   12 }, {   6,  0,   26 }, {   7, 11,  388 },
  {   7, 11,  644 }, { 139, 11,  781 }, {   7, 11,  229 }, {   8, 11,   59 },
  {   9, 11,  190 }, {   9, 11,  257 }, {  10, 11,  378 }, { 140, 11,  191 },
  { 133, 10,  927 }, { 135, 10, 1441 }, {   4, 10,  893 }, {   5, 10,  780 },
  { 133, 10,  893 }, {   4,  0,  414 }, {   5,  0,  467 }, {   9,  0,  654 },
  {  10,  0,  451 }, {  12,  0,   59 }, { 141,  0,  375 }, { 142,  0,  173 },
  { 135,  0,   17 }, {   7,  0, 1350 }, { 133, 10,  238 }, { 135,  0,  955 },
  {   4,  0,  960 }, {  10,  0,  887 }, {  12,  0,  753 }, {  18,  0,  161 },
  {  18,  0,  162 }, { 152,  0,   19 }, { 136, 11,  344 }, {   6, 10, 1729 },
  { 137, 11,  288 }, { 132, 11,  660 }, {   4,  0,  217 }, {   5,  0,  710 },
  {   7,  0,  760 }, {   7,  0, 1926 }, {   9,  0,  428 }, {   9,  0,  708 },
  {  10,  0,  254 }, {  10,  0,  296 }, {  10,  0,  720 }, {  11,  0,  109 },
  {  11,  0,  255 }, {  12,  0,  165 }, {  12,  0,  315 }, {  13,  0,  107 },
  {  13,  0,  203 }, {  14,  0,   54 }, {  14,  0,   99 }, {  14,  0,  114 },
  {  14,  0,  388 }, {  16,  0,   85 }, {  17,  0,    9 }, {  17,  0,   33 },
  {  20,  0,   25 }, {  20,  0,   28 }, {  20,  0,   29 }, {  21,  0,    9 },
  {  21,  0,   10 }, {  21,  0,   34 }, {  22,  0,   17 }, {   4, 10,   60 },
  {   7, 10, 1800 }, {   8, 10,  314 }, {   9, 10,  700 }, { 139, 10,  487 },
  {   7, 11, 1035 }, { 138, 11,  737 }, {   7, 11,  690 }, {   9, 11,  217 },
  {   9, 11,  587 }, { 140, 11,  521 }, {   6,  0,  919 }, {   7, 11,  706 },
  {   7, 11, 1058 }, { 138, 11,  538 }, {   7, 10, 1853 }, { 138, 10,  437 },
  { 136, 10,  419 }, {   6,  0,  280 }, {  10,  0,  502 }, {  11,  0,  344 },
  { 140,  0,   38 }, {   5,  0,   45 }, {   7,  0, 1161 }, {  11,  0,  448 },
  {  11,  0,  880 }, {  13,  0,  139 }, {  13,  0,  407 }, {  15,  0,   16 },
  {  17,  0,   95 }, {  18,  0,   66 }, {  18,  0,   88 }, {  18,  0,  123 },
  { 149,  0,    7 }, {  11, 11,   92 }, {  11, 11,  196 }, {  11, 11,  409 },
  {  11, 11,  450 }, {  11, 11,  666 }, {  11, 11,  777 }, {  12, 11,  262 },
  {  13, 11,  385 }, {  13, 11,  393 }, {  15, 11,  115 }, {  16, 11,   45 },
  { 145, 11,   82 }, { 136,  0,  777 }, { 134, 11, 1744 }, {   4,  0,  410 },
  {   7,  0,  521 }, { 133, 10,  828 }, { 134,  0,  673 }, {   7,  0, 1110 },
  {   7,  0, 1778 }, {   7, 10,  176 }, { 135, 10,  178 }, {   5, 10,  806 },
  {   7, 11,  268 }, {   7, 10, 1976 }, { 136, 11,  569 }, {   4, 11,  733 },
  {   9, 11,  194 }, {  10, 11,   92 }, {  11, 11,  198 }, {  12, 11,   84 },
  {  12, 11,   87 }, {  13, 11,  128 }, { 144, 11,   74 }, {   5,  0,  341 },
  {   7,  0, 1129 }, {  11,  0,  414 }, {   4, 10,   51 }, {   6, 10,    4 },
  {   7, 10,  591 }, {   7, 10,  849 }, {   7, 10,  951 }, {   7, 10, 1613 },
  {   7, 10, 1760 }, {   7, 10, 1988 }, {   9, 10,  434 }, {  10, 10,  754 },
  {  11, 10,   25 }, { 139, 10,   37 }, { 133, 10,  902 }, { 135, 10,  928 },
  { 135,  0,  787 }, { 132,  0,  436 }, { 134, 10,  270 }, {   7,  0, 1587 },
  { 135,  0, 1707 }, {   6,  0,  377 }, {   7,  0, 1025 }, {   9,  0,  613 },
  { 145,  0,  104 }, {   7, 11,  982 }, {   7, 11, 1361 }, {  10, 11,   32 },
  { 143, 11,   56 }, { 139,  0,   96 }, { 132,  0,  451 }, { 132, 10,  416 },
  { 142, 10,  372 }, {   5, 10,  152 }, {   5, 10,  197 }, {   7, 11,  306 },
  {   7, 10,  340 }, {   7, 10,  867 }, {  10, 10,  548 }, {  10, 10,  581 },
  {  11, 10,    6 }, {  12, 10,    3 }, {  12, 10,   19 }, {  14, 10,  110 },
  { 142, 10,  289 }, { 134,  0,  680 }, { 134, 11,  609 }, {   7,  0,  483 },
  {   7, 10,  190 }, {   8, 10,   28 }, {   8, 10,  141 }, {   8, 10,  444 },
  {   8, 10,  811 }, {   9, 10,  468 }, {  11, 10,  334 }, {  12, 10,   24 },
  {  12, 10,  386 }, { 140, 10,  576 }, {  10,  0,  916 }, { 133, 10,  757 },
  {   5, 10,  721 }, { 135, 10, 1553 }, { 133, 11,  178 }, { 134,  0,  937 },
  { 132, 10,  898 }, { 133,  0,  739 }, { 147,  0,   82 }, { 135,  0,  663 },
  { 146,  0,  128 }, {   5, 10,  277 }, { 141, 10,  247 }, { 134,  0, 1087 },
  { 132, 10,  435 }, {   6, 11,  381 }, {   7, 11,  645 }, {   7, 11,  694 },
  { 136, 11,  546 }, {   7,  0,  503 }, { 135,  0, 1885 }, {   6,  0, 1965 },
  {   8,  0,  925 }, { 138,  0,  955 }, {   4,  0,  113 }, {   5,  0,  163 },
  {   5,  0,  735 }, {   7,  0, 1009 }, {   9,  0,    9 }, {   9,  0,  771 },
  {  12,  0,   90 }, {  13,  0,  138 }, {  13,  0,  410 }, { 143,  0,  128 },
  {   4,  0,  324 }, { 138,  0,  104 }, {   7,  0,  460 }, {   5, 10,  265 },
  { 134, 10,  212 }, { 133, 11,  105 }, {   7, 11,  261 }, {   7, 11, 1107 },
  {   7, 11, 1115 }, {   7, 11, 1354 }, {   7, 11, 1588 }, {   7, 11, 1705 },
  {   7, 11, 1902 }, {   9, 11,  465 }, {  10, 11,  248 }, {  10, 11,  349 },
  {  10, 11,  647 }, {  11, 11,  527 }, {  11, 11,  660 }, {  11, 11,  669 },
  {  12, 11,  529 }, { 141, 11,  305 }, {   5, 11,  438 }, {   9, 11,  694 },
  {  12, 11,  627 }, { 141, 11,  210 }, { 152, 11,   11 }, {   4,  0,  935 },
  { 133,  0,  823 }, { 132, 10,  702 }, {   5,  0,  269 }, {   7,  0,  434 },
  {   7,  0,  891 }, {   8,  0,  339 }, {   9,  0,  702 }, {  11,  0,  594 },
  {  11,  0,  718 }, {  17,  0,  100 }, {   5, 10,  808 }, { 135, 10, 2045 },
  {   7,  0, 1014 }, {   9,  0,  485 }, { 141,  0,  264 }, { 134,  0, 1713 },
  {   7,  0, 1810 }, {  11,  0,  866 }, {  12,  0,  103 }, {  13,  0,  495 },
  { 140, 11,  233 }, {   4,  0,  423 }, {  10,  0,  949 }, { 138,  0, 1013 },
  { 135,  0,  900 }, {   8, 11,   25 }, { 138, 11,  826 }, {   5, 10,  166 },
  {   8, 10,  739 }, { 140, 10,  511 }, { 134,  0, 2018 }, {   7, 11, 1270 },
  { 139, 11,  612 }, {   4, 10,  119 }, {   5, 10,  170 }, {   5, 10,  447 },
  {   7, 10, 1708 }, {   7, 10, 1889 }, {   9, 10,  357 }, {   9, 10,  719 },
  {  12, 10,  486 }, { 140, 10,  596 }, {  12,  0,  574 }, { 140, 11,  574 },
  { 132, 11,  308 }, {   6,  0,  964 }, {   6,  0, 1206 }, { 134,  0, 1302 },
  {   4, 10,  450 }, { 135, 10, 1158 }, { 135, 11,  150 }, { 136, 11,  649 },
  {  14,  0,  213 }, { 148,  0,   38 }, {   9, 11,   45 }, {   9, 11,  311 },
  { 141, 11,   42 }, { 134, 11,  521 }, {   7, 10, 1375 }, {   7, 10, 1466 },
  { 138, 10,  331 }, { 132, 10,  754 }, {   5, 11,  339 }, {   7, 11, 1442 },
  {  14, 11,    3 }, {  15, 11,   41 }, { 147, 11,   66 }, { 136, 11,  378 },
  { 134,  0, 1022 }, {   5, 10,  850 }, { 136, 10,  799 }, { 142,  0,  143 },
  { 135,  0, 2029 }, { 134, 11, 1628 }, {   8,  0,  523 }, { 150,  0,   34 },
  {   5,  0,  625 }, { 135,  0, 1617 }, {   7,  0,  275 }, {   7, 10,  238 },
  {   7, 10, 2033 }, {   8, 10,  120 }, {   8, 10,  188 }, {   8, 10,  659 },
  {   9, 10,  598 }, {  10, 10,  466 }, {  12, 10,  342 }, {  12, 10,  588 },
  {  13, 10,  503 }, {  14, 10,  246 }, { 143, 10,   92 }, {   7,  0,   37 },
  {   8,  0,  425 }, {   8,  0,  693 }, {   9,  0,  720 }, {  10,  0,  380 },
  {  10,  0,  638 }, {  11,  0,  273 }, {  11,  0,  473 }, {  12,  0,   61 },
  { 143,  0,   43 }, { 135, 11,  829 }, { 135,  0, 1943 }, { 132,  0,  765 },
  {   5, 11,  486 }, { 135, 11, 1349 }, {   7, 11, 1635 }, {   8, 11,   17 },
  {  10, 11,  217 }, { 138, 11,  295 }, {   4, 10,  201 }, {   7, 10, 1744 },
  {   8, 10,  602 }, {  11, 10,  247 }, {  11, 10,  826 }, { 145, 10,   65 },
  { 138, 11,  558 }, {  11,  0,  551 }, { 142,  0,  159 }, {   8, 10,  164 },
  { 146, 10,   62 }, { 139, 11,  176 }, { 132,  0,  168 }, { 136,  0, 1010 },
  { 134,  0, 1994 }, { 135,  0,   91 }, { 138,  0,  532 }, { 135, 10, 1243 },
  { 135,  0, 1884 }, { 132, 10,  907 }, {   5, 10,  100 }, {  10, 10,  329 },
  {  12, 10,  416 }, { 149, 10,   29 }, { 134, 11,  447 }, { 132, 10,  176 },
  {   5, 10,  636 }, {   5, 10,  998 }, {   7, 10,    9 }, {   7, 10, 1508 },
  {   8, 10,   26 }, {   9, 10,  317 }, {   9, 10,  358 }, {  10, 10,  210 },
  {  10, 10,  292 }, {  10, 10,  533 }, {  11, 10,  555 }, {  12, 10,  526 },
  {  12, 10,  607 }, {  13, 10,  263 }, {  13, 10,  459 }, { 142, 10,  271 },
  {   4, 11,  609 }, { 135, 11,  756 }, {   6,  0,   15 }, {   7,  0,   70 },
  {  10,  0,  240 }, { 147,  0,   93 }, {   4, 11,  930 }, { 133, 11,  947 },
  { 134,  0, 1227 }, { 134,  0, 1534 }, { 133, 11,  939 }, { 133, 11,  962 },
  {   5, 11,  651 }, {   8, 11,  170 }, {   9, 11,   61 }, {   9, 11,   63 },
  {  10, 11,   23 }, {  10, 11,   37 }, {  10, 11,  834 }, {  11, 11,    4 },
  {  11, 11,  187 }, {  11, 11,  281 }, {  11, 11,  503 }, {  11, 11,  677 },
  {  12, 11,   96 }, {  12, 11,  130 }, {  12, 11,  244 }, {  14, 11,    5 },
  {  14, 11,   40 }, {  14, 11,  162 }, {  14, 11,  202 }, { 146, 11,  133 },
  {   4, 11,  406 }, {   5, 11,  579 }, {  12, 11,  492 }, { 150, 11,   15 },
  { 139,  0,  392 }, {   6, 10,  610 }, {  10, 10,  127 }, { 141, 10,   27 },
  {   7,  0,  655 }, {   7,  0, 1844 }, { 136, 10,  119 }, {   4,  0,  145 },
  {   6,  0,  176 }, {   7,  0,  395 }, { 137,  0,  562 }, { 132,  0,  501 },
  { 140, 11,  145 }, { 136,  0, 1019 }, { 134,  0,  509 }, { 139,  0,  267 },
  {   6, 11,   17 }, {   7, 11,   16 }, {   7, 11, 1001 }, {   7, 11, 1982 },
  {   9, 11,  886 }, {  10, 11,  489 }, {  10, 11,  800 }, {  11, 11,  782 },
  {  12, 11,  320 }, {  13, 11,  467 }, {  14, 11,  145 }, {  14, 11,  387 },
  { 143, 11,  119 }, { 145, 11,   17 }, {   6,  0, 1099 }, { 133, 11,  458 },
  {   7, 11, 1983 }, {   8, 11,    0 }, {   8, 11,  171 }, {   9, 11,  120 },
  {   9, 11,  732 }, {  10, 11,  473 }, {  11, 11,  656 }, {  11, 11,  998 },
  {  18, 11,    0 }, {  18, 11,    2 }, { 147, 11,   21 }, {  12, 11,  427 },
  { 146, 11,   38 }, {  10,  0,  948 }, { 138,  0,  968 }, {   7, 10,  126 },
  { 136, 10,   84 }, { 136, 10,  790 }, {   4,  0,  114 }, {   9,  0,  492 },
  {  13,  0,  462 }, { 142,  0,  215 }, {   6, 10,   64 }, {  12, 10,  377 },
  { 141, 10,  309 }, {   4,  0,   77 }, {   5,  0,  361 }, {   6,  0,  139 },
  {   6,  0,  401 }, {   6,  0,  404 }, {   7,  0,  413 }, {   7,  0,  715 },
  {   7,  0, 1716 }, {  11,  0,  279 }, {  12,  0,  179 }, {  12,  0,  258 },
  {  13,  0,  244 }, { 142,  0,  358 }, { 134,  0, 1717 }, {   7,  0,  772 },
  {   7,  0, 1061 }, {   7,  0, 1647 }, {   8,  0,   82 }, {  11,  0,  250 },
  {  11,  0,  607 }, {  12,  0,  311 }, {  12,  0,  420 }, {  13,  0,  184 },
  {  13,  0,  367 }, {   7, 10, 1104 }, {  11, 10,  269 }, {  11, 10,  539 },
  {  11, 10,  627 }, {  11, 10,  706 }, {  11, 10,  975 }, {  12, 10,  248 },
  {  12, 10,  434 }, {  12, 10,  600 }, {  12, 10,  622 }, {  13, 10,  297 },
  {  13, 10,  485 }, {  14, 10,   69 }, {  14, 10,  409 }, { 143, 10,  108 },
  { 135,  0,  724 }, {   4, 11,  512 }, {   4, 11,  519 }, { 133, 11,  342 },
  { 134,  0, 1133 }, { 145, 11,   29 }, {  11, 10,  977 }, { 141, 10,  507 },
  {   6,  0,  841 }, {   6,  0, 1042 }, {   6,  0, 1194 }, {  10,  0,  993 },
  { 140,  0, 1021 }, {   6, 11,   31 }, {   7, 11,  491 }, {   7, 11,  530 },
  {   8, 11,  592 }, {   9, 10,   34 }, {  11, 11,   53 }, {  11, 10,  484 },
  {  11, 11,  779 }, {  12, 11,  167 }, {  12, 11,  411 }, {  14, 11,   14 },
  {  14, 11,  136 }, {  15, 11,   72 }, {  16, 11,   17 }, { 144, 11,   72 },
  {   4,  0, 1021 }, {   6,  0, 2037 }, { 133, 11,  907 }, {   7,  0,  373 },
  {   8,  0,  335 }, {   8,  0,  596 }, {   9,  0,  488 }, {   6, 10, 1700 },
  {   7, 10,  293 }, {   7, 10,  382 }, {   7, 10, 1026 }, {   7, 10, 1087 },
  {   7, 10, 2027 }, {   8, 10,  252 }, {   8, 10,  727 }, {   8, 10,  729 },
  {   9, 10,   30 }, {   9, 10,  199 }, {   9, 10,  231 }, {   9, 10,  251 },
  {   9, 10,  334 }, {   9, 10,  361 }, {   9, 10,  712 }, {  10, 10,   55 },
  {  10, 10,   60 }, {  10, 10,  232 }, {  10, 10,  332 }, {  10, 10,  384 },
  {  10, 10,  396 }, {  10, 10,  504 }, {  10, 10,  542 }, {  10, 10,  652 },
  {  11, 10,   20 }, {  11, 10,   48 }, {  11, 10,  207 }, {  11, 10,  291 },
  {  11, 10,  298 }, {  11, 10,  342 }, {  11, 10,  365 }, {  11, 10,  394 },
  {  11, 10,  620 }, {  11, 10,  705 }, {  11, 10, 1017 }, {  12, 10,  123 },
  {  12, 10,  340 }, {  12, 10,  406 }, {  12, 10,  643 }, {  13, 10,   61 },
  {  13, 10,  269 }, {  13, 10,  311 }, {  13, 10,  319 }, {  13, 10,  486 },
  {  14, 10,  234 }, {  15, 10,   62 }, {  15, 10,   85 }, {  16, 10,   71 },
  {  18, 10,  119 }, { 148, 10,  105 }, { 150,  0,   37 }, {   4, 11,  208 },
  {   5, 11,  106 }, {   6, 11,  531 }, {   8, 11,  408 }, {   9, 11,  188 },
  { 138, 11,  572 }, { 132,  0,  564 }, {   6,  0,  513 }, { 135,  0, 1052 },
  { 132,  0,  825 }, {   9,  0,  899 }, { 140, 11,  441 }, { 134,  0,  778 },
  { 133, 11,  379 }, {   7,  0, 1417 }, {  12,  0,  382 }, {  17,  0,   48 },
  { 152,  0,   12 }, { 132, 11,  241 }, {   7,  0, 1116 }, {   6, 10,  379 },
  {   7, 10,  270 }, {   8, 10,  176 }, {   8, 10,  183 }, {   9, 10,  432 },
  {   9, 10,  661 }, {  12, 10,  247 }, {  12, 10,  617 }, { 146, 10,  125 },
  {   5, 10,  792 }, { 133, 10,  900 }, {   6,  0,  545 }, {   7,  0,  565 },
  {   7,  0, 1669 }, {  10,  0,  114 }, {  11,  0,  642 }, { 140,  0,  618 },
  { 133,  0,    5 }, { 138, 11,    7 }, { 132, 11,  259 }, { 135,  0,  192 },
  { 134,  0,  701 }, { 136,  0,  763 }, { 135, 10, 1979 }, {   4, 10,  901 },
  { 133, 10,  776 }, {  10,  0,  755 }, { 147,  0,   29 }, { 133,  0,  759 },
  {   4, 11,  173 }, {   5, 11,  312 }, {   5, 11,  512 }, { 135, 11, 1285 },
  {   7, 11, 1603 }, {   7, 11, 1691 }, {   9, 11,  464 }, {  11, 11,  195 },
  {  12, 11,  279 }, {  12, 11,  448 }, {  14, 11,   11 }, { 147, 11,  102 },
  {   7,  0,  370 }, {   7,  0, 1007 }, {   7,  0, 1177 }, { 135,  0, 1565 },
  { 135,  0, 1237 }, {   4,  0,   87 }, {   5,  0,  250 }, { 141,  0,  298 },
  {   4, 11,  452 }, {   5, 11,  583 }, {   5, 11,  817 }, {   6, 11,  433 },
  {   7, 11,  593 }, {   7, 11,  720 }, {   7, 11, 1378 }, {   8, 11,  161 },
  {   9, 11,  284 }, {  10, 11,  313 }, { 139, 11,  886 }, {   4, 11,  547 },
  { 135, 11, 1409 }, { 136, 11,  722 }, {   4, 10,   37 }, {   5, 10,  334 },
  { 135, 10, 1253 }, { 132, 10,  508 }, {  12,  0,  107 }, { 146,  0,   31 },
  {   8, 11,  420 }, { 139, 11,  193 }, { 135,  0,  814 }, { 135, 11,  409 },
  { 140,  0,  991 }, {   4,  0,   57 }, {   7,  0, 1195 }, {   7,  0, 1438 },
  {   7,  0, 1548 }, {   7,  0, 1835 }, {   7,  0, 1904 }, {   9,  0,  757 },
  {  10,  0,  604 }, { 139,  0,  519 }, { 132,  0,  540 }, { 138, 11,  308 },
  { 132, 10,  533 }, { 136,  0,  608 }, { 144, 11,   65 }, {   4,  0, 1014 },
  { 134,  0, 2029 }, {   4,  0,  209 }, {   7,  0,  902 }, {   5, 11, 1002 },
  { 136, 11,  745 }, { 134,  0, 2030 }, {   6,  0,  303 }, {   7,  0,  335 },
  {   7,  0, 1437 }, {   7,  0, 1668 }, {   8,  0,  553 }, {   8,  0,  652 },
  {   8,  0,  656 }, {   9,  0,  558 }, {  11,  0,  743 }, { 149,  0,   18 },
  {   5, 11,  575 }, {   6, 11,  354 }, { 135, 11,  701 }, {   4, 11,  239 },
  {   6, 11,  477 }, {   7, 11, 1607 }, {  11, 11,   68 }, { 139, 11,  617 },
  { 132,  0,  559 }, {   8,  0,  527 }, {  18,  0,   60 }, { 147,  0,   24 },
  { 133, 10,  920 }, { 138,  0,  511 }, { 133,  0, 1017 }, { 133,  0,  675 },
  { 138, 10,  391 }, {  11,  0,  156 }, { 135, 10, 1952 }, { 138, 11,  369 },
  { 132, 11,  367 }, { 133,  0,  709 }, {   6,  0,  698 }, { 134,  0,  887 },
  { 142, 10,  126 }, { 134,  0, 1745 }, { 132, 10,  483 }, {  13, 11,  299 },
  { 142, 11,   75 }, { 133,  0,  714 }, {   7,  0,    8 }, { 136,  0,  206 },
  { 138, 10,  480 }, {   4, 11,  694 }, {   9, 10,  495 }, { 146, 10,  104 },
  {   7, 11, 1248 }, {  11, 11,  621 }, { 139, 11,  702 }, { 140, 11,  687 },
  { 132,  0,  776 }, { 139, 10, 1009 }, { 135,  0, 1272 }, { 134,  0, 1059 },
  {   8, 10,  653 }, {  13, 10,   93 }, { 147, 10,   14 }, { 135, 11,  213 },
  { 136,  0,  406 }, { 133, 10,  172 }, { 132,  0,  947 }, {   8,  0,  175 },
  {  10,  0,  168 }, { 138,  0,  573 }, { 132,  0,  870 }, {   6,  0, 1567 },
  { 151, 11,   28 }, { 134, 11,  472 }, {   5, 10,  260 }, { 136, 11,  132 },
  {   4, 11,  751 }, {  11, 11,  390 }, { 140, 11,   32 }, {   4, 11,  409 },
  { 133, 11,   78 }, {  12,  0,  554 }, {   6, 11,  473 }, { 145, 11,  105 },
  { 133,  0,  784 }, {   8,  0,  908 }, { 136, 11,  306 }, { 139,  0,  882 },
  {   6,  0,  358 }, {   7,  0, 1393 }, {   8,  0,  396 }, {  10,  0,  263 },
  {  14,  0,  154 }, {  16,  0,   48 }, {  17,  0,    8 }, {   7, 11, 1759 },
  {   8, 11,  396 }, {  10, 11,  263 }, {  14, 11,  154 }, {  16, 11,   48 },
  { 145, 11,    8 }, {  13, 11,  163 }, {  13, 11,  180 }, {  18, 11,   78 },
  { 148, 11,   35 }, {  14,  0,   32 }, {  18,  0,   85 }, {  20,  0,    2 },
  { 152,  0,   16 }, {   7,  0,  228 }, {  10,  0,  770 }, {   8, 10,  167 },
  {   8, 10,  375 }, {   9, 10,   82 }, {   9, 10,  561 }, { 138, 10,  620 },
  { 132,  0,  845 }, {   9,  0,   14 }, {   9,  0,  441 }, {  10,  0,  306 },
  { 139,  0,    9 }, {  11,  0,  966 }, {  12,  0,  287 }, {  13,  0,  342 },
  {  13,  0,  402 }, {  15,  0,  110 }, {  15,  0,  163 }, {   8, 10,  194 },
  { 136, 10,  756 }, { 134,  0, 1578 }, {   4,  0,  967 }, {   6,  0, 1820 },
  {   6,  0, 1847 }, { 140,  0,  716 }, { 136,  0,  594 }, {   7,  0, 1428 },
  {   7,  0, 1640 }, {   7,  0, 1867 }, {   9,  0,  169 }, {   9,  0,  182 },
  {   9,  0,  367 }, {   9,  0,  478 }, {   9,  0,  506 }, {   9,  0,  551 },
  {   9,  0,  557 }, {   9,  0,  648 }, {   9,  0,  697 }, {   9,  0,  705 },
  {   9,  0,  725 }, {   9,  0,  787 }, {   9,  0,  794 }, {  10,  0,  198 },
  {  10,  0,  214 }, {  10,  0,  267 }, {  10,  0,  275 }, {  10,  0,  456 },
  {  10,  0,  551 }, {  10,  0,  561 }, {  10,  0,  613 }, {  10,  0,  627 },
  {  10,  0,  668 }, {  10,  0,  675 }, {  10,  0,  691 }, {  10,  0,  695 },
  {  10,  0,  707 }, {  10,  0,  715 }, {  11,  0,  183 }, {  11,  0,  201 },
  {  11,  0,  244 }, {  11,  0,  262 }, {  11,  0,  352 }, {  11,  0,  439 },
  {  11,  0,  493 }, {  11,  0,  572 }, {  11,  0,  591 }, {  11,  0,  608 },
  {  11,  0,  611 }, {  11,  0,  646 }, {  11,  0,  674 }, {  11,  0,  711 },
  {  11,  0,  751 }, {  11,  0,  761 }, {  11,  0,  776 }, {  11,  0,  785 },
  {  11,  0,  850 }, {  11,  0,  853 }, {  11,  0,  862 }, {  11,  0,  865 },
  {  11,  0,  868 }, {  11,  0,  875 }, {  11,  0,  898 }, {  11,  0,  902 },
  {  11,  0,  903 }, {  11,  0,  910 }, {  11,  0,  932 }, {  11,  0,  942 },
  {  11,  0,  957 }, {  11,  0,  967 }, {  11,  0,  972 }, {  12,  0,  148 },
  {  12,  0,  195 }, {  12,  0,  220 }, {  12,  0,  237 }, {  12,  0,  318 },
  {  12,  0,  339 }, {  12,  0,  393 }, {  12,  0,  445 }, {  12,  0,  450 },
  {  12,  0,  474 }, {  12,  0,  505 }, {  12,  0,  509 }, {  12,  0,  533 },
  {  12,  0,  591 }, {  12,  0,  594 }, {  12,  0,  597 }, {  12,  0,  621 },
  {  12,  0,  633 }, {  12,  0,  642 }, {  13,  0,   59 }, {  13,  0,   60 },
  {  13,  0,  145 }, {  13,  0,  239 }, {  13,  0,  250 }, {  13,  0,  329 },
  {  13,  0,  344 }, {  13,  0,  365 }, {  13,  0,  372 }, {  13,  0,  387 },
  {  13,  0,  403 }, {  13,  0,  414 }, {  13,  0,  456 }, {  13,  0,  470 },
  {  13,  0,  478 }, {  13,  0,  483 }, {  13,  0,  489 }, {  14,  0,   55 },
  {  14,  0,   57 }, {  14,  0,   81 }, {  14,  0,   90 }, {  14,  0,  148 },
  {  14,  0,  239 }, {  14,  0,  266 }, {  14,  0,  321 }, {  14,  0,  326 },
  {  14,  0,  327 }, {  14,  0,  330 }, {  14,  0,  347 }, {  14,  0,  355 },
  {  14,  0,  401 }, {  14,  0,  404 }, {  14,  0,  411 }, {  14,  0,  414 },
  {  14,  0,  416 }, {  14,  0,  420 }, {  15,  0,   61 }, {  15,  0,   74 },
  {  15,  0,   87 }, {  15,  0,   88 }, {  15,  0,   94 }, {  15,  0,   96 },
  {  15,  0,  116 }, {  15,  0,  149 }, {  15,  0,  154 }, {  16,  0,   50 },
  {  16,  0,   63 }, {  16,  0,   73 }, {  17,  0,    2 }, {  17,  0,   66 },
  {  17,  0,   92 }, {  17,  0,  103 }, {  17,  0,  112 }, {  17,  0,  120 },
  {  18,  0,   50 }, {  18,  0,   54 }, {  18,  0,   82 }, {  18,  0,   86 },
  {  18,  0,   90 }, {  18,  0,  111 }, {  18,  0,  115 }, {  18,  0,  156 },
  {  19,  0,   40 }, {  19,  0,   79 }, {  20,  0,   78 }, {  21,  0,   22 },
  { 135, 11,  883 }, {   5,  0,  161 }, { 135,  0,  839 }, {   4,  0,  782 },
  {  13, 11,  293 }, { 142, 11,   56 }, { 133, 11,  617 }, { 139, 11,   50 },
  { 135, 10,   22 }, { 145,  0,   64 }, {   5, 10,  639 }, {   7, 10, 1249 },
  { 139, 10,  896 }, { 138,  0,  998 }, { 135, 11, 2042 }, {   4, 11,  546 },
  { 142, 11,  233 }, {   6,  0, 1043 }, { 134,  0, 1574 }, { 134,  0, 1496 },
  {   4, 10,  102 }, {   7, 10,  815 }, {   7, 10, 1699 }, { 139, 10,  964 },
  {  12,  0,  781 }, { 142,  0,  461 }, {   4, 11,  313 }, { 133, 11,  577 },
  {   6,  0,  639 }, {   6,  0, 1114 }, { 137,  0,  817 }, {   8, 11,  184 },
  { 141, 11,  433 }, {   7,  0, 1814 }, { 135, 11,  935 }, {  10,  0,  997 },
  { 140,  0,  958 }, {   4,  0,  812 }, { 137, 11,  625 }, { 132, 10,  899 },
  { 136, 10,  795 }, {   5, 11,  886 }, {   6, 11,   46 }, {   6, 11, 1790 },
  {   7, 11,   14 }, {   7, 11,  732 }, {   7, 11, 1654 }, {   8, 11,   95 },
  {   8, 11,  327 }, {   8, 11,  616 }, {  10, 11,  598 }, {  10, 11,  769 },
  {  11, 11,  134 }, {  11, 11,  747 }, {  12, 11,  378 }, { 142, 11,   97 },
  { 136,  0,  139 }, {   6, 10,   52 }, {   9, 10,  104 }, {   9, 10,  559 },
  {  12, 10,  308 }, { 147, 10,   87 }, { 133, 11, 1021 }, { 132, 10,  604 },
  { 132, 10,  301 }, { 136, 10,  779 }, {   7,  0,  643 }, { 136,  0,  236 },
  { 132, 11,  153 }, { 134,  0, 1172 }, { 147, 10,   32 }, { 133, 11,  798 },
  {   6,  0, 1338 }, { 132, 11,  587 }, {   6, 11,  598 }, {   7, 11,   42 },
  {   8, 11,  695 }, {  10, 11,  212 }, {  11, 11,  158 }, {  14, 11,  196 },
  { 145, 11,   85 }, { 135, 10,  508 }, {   5, 11,  957 }, {   5, 11, 1008 },
  { 135, 11,  249 }, {   4, 11,  129 }, { 135, 11,  465 }, {   5,  0,   54 },
  {   7, 11,  470 }, {   7, 11, 1057 }, {   7, 11, 1201 }, {   9, 11,  755 },
  {  11, 11,  906 }, { 140, 11,  527 }, {   7, 11,  908 }, { 146, 11,    7 },
  {   5, 11,  148 }, { 136, 11,  450 }, { 144, 11,    1 }, {   4,  0,  256 },
  { 135,  0, 1488 }, {   9,  0,  351 }, {   6, 10,  310 }, {   7, 10, 1849 },
  {   8, 10,   72 }, {   8, 10,  272 }, {   8, 10,  431 }, {   9, 10,   12 },
  {  10, 10,  563 }, {  10, 10,  630 }, {  10, 10,  796 }, {  10, 10,  810 },
  {  11, 10,  367 }, {  11, 10,  599 }, {  11, 10,  686 }, { 140, 10,  672 },
  {   6,  0, 1885 }, {   6,  0, 1898 }, {   6,  0, 1899 }, { 140,  0,  955 },
  {   4,  0,  714 }, { 133,  0,  469 }, {   6,  0, 1270 }, { 134,  0, 1456 },
  { 132,  0,  744 }, {   6,  0,  313 }, {   7, 10,  537 }, {   8, 10,   64 },
  {   9, 10,  127 }, {  10, 10,  496 }, {  12, 10,  510 }, { 141, 10,  384 },
  {   4, 11,  217 }, {   4, 10,  244 }, {   5, 11,  710 }, {   7, 10,  233 },
  {   7, 11, 1926 }, {   9, 11,  428 }, {   9, 11,  708 }, {  10, 11,  254 },
  {  10, 11,  296 }, {  10, 11,  720 }, {  11, 11,  109 }, {  11, 11,  255 },
  {  12, 11,  165 }, {  12, 11,  315 }, {  13, 11,  107 }, {  13, 11,  203 },
  {  14, 11,   54 }, {  14, 11,   99 }, {  14, 11,  114 }, {  14, 11,  388 },
  {  16, 11,   85 }, {  17, 11,    9 }, {  17, 11,   33 }, {  20, 11,   25 },
  {  20, 11,   28 }, {  20, 11,   29 }, {  21, 11,    9 }, {  21, 11,   10 },
  {  21, 11,   34 }, { 150, 11,   17 }, { 138,  0,  402 }, {   7,  0,  969 },
  { 146,  0,   55 }, {   8,  0,   50 }, { 137,  0,  624 }, { 134,  0, 1355 },
  { 132,  0,  572 }, { 134, 10, 1650 }, {  10, 10,  702 }, { 139, 10,  245 },
  {  10,  0,  847 }, { 142,  0,  445 }, {   6,  0,   43 }, {   7,  0,   38 },
  {   8,  0,  248 }, { 138,  0,  513 }, { 133,  0,  369 }, { 137, 10,  338 },
  { 133,  0,  766 }, { 133,  0,  363 }, { 133, 10,  896 }, {   8, 11,  392 },
  {  11, 11,   54 }, {  13, 11,  173 }, {  13, 11,  294 }, { 148, 11,    7 },
  { 134,  0,  678 }, {   7, 11, 1230 }, { 136, 11,  531 }, {   6,  0,  258 },
  { 140,  0,  409 }, {   5,  0,  249 }, { 148,  0,   82 }, {   7, 10, 1117 },
  { 136, 10,  539 }, {   5,  0,  393 }, {   6,  0,  378 }, {   7,  0, 1981 },
  {   9,  0,   32 }, {   9,  0,  591 }, {  10,  0,  685 }, {  10,  0,  741 },
  { 142,  0,  382 }, { 133,  0,  788 }, { 134,  0, 1281 }, { 134,  0, 1295 },
  {   7,  0, 1968 }, { 141,  0,  509 }, {   4,  0,   61 }, {   5,  0,   58 },
  {   5,  0,  171 }, {   5,  0,  683 }, {   6,  0,  291 }, {   6,  0,  566 },
  {   7,  0, 1650 }, {  11,  0,  523 }, {  12,  0,  273 }, {  12,  0,  303 },
  {  15,  0,   39 }, { 143,  0,  111 }, {   6,  0,  706 }, { 134,  0, 1283 },
  { 134,  0,  589 }, { 135, 11, 1433 }, { 133, 11,  435 }, {   7,  0, 1059 },
  {  13,  0,   54 }, {   5, 10,    4 }, {   5, 10,  810 }, {   6, 10,   13 },
  {   6, 10,  538 }, {   6, 10, 1690 }, {   6, 10, 1726 }, {   7, 10, 1819 },
  {   8, 10,  148 }, {   8, 10,  696 }, {   8, 10,  791 }, {  12, 10,  125 },
  { 143, 10,    9 }, { 135, 10, 1268 }, {   5, 11,   85 }, {   6, 11,  419 },
  {   7, 11,  134 }, {   7, 11,  305 }, {   7, 11,  361 }, {   7, 11, 1337 },
  {   8, 11,   71 }, { 140, 11,  519 }, { 137,  0,  824 }, { 140, 11,  688 },
  {   5, 11,  691 }, {   7, 11,  345 }, {   7, 10, 1385 }, {   9, 11,   94 },
  {  11, 10,  582 }, {  11, 10,  650 }, {  11, 10,  901 }, {  11, 10,  949 },
  {  12, 11,  169 }, {  12, 10,  232 }, {  12, 10,  236 }, {  13, 10,  413 },
  {  13, 10,  501 }, { 146, 10,  116 }, {   4,  0,  917 }, { 133,  0, 1005 },
  {   7,  0, 1598 }, {   5, 11,  183 }, {   6, 11,  582 }, {   9, 11,  344 },
  {  10, 11,  679 }, { 140, 11,  435 }, {   4, 10,  925 }, {   5, 10,  803 },
  {   8, 10,  698 }, { 138, 10,  828 }, { 132,  0,  919 }, { 135, 11,  511 },
  { 139, 10,  992 }, {   4,  0,  255 }, {   5,  0,  302 }, {   6,  0,  132 },
  {   7,  0,  128 }, {   7,  0,  283 }, {   7,  0, 1299 }, {  10,  0,   52 },
  {  10,  0,  514 }, {  11,  0,  925 }, {  13,  0,   92 }, { 142,  0,  309 },
  { 134,  0, 1369 }, { 135, 10, 1847 }, { 134,  0,  328 }, {   7, 11, 1993 },
  { 136, 11,  684 }, { 133, 10,  383 }, { 137,  0,  173 }, { 134, 11,  583 },
  { 134,  0, 1411 }, {  19,  0,   65 }, {   5, 11,  704 }, {   8, 11,  357 },
  {  10, 11,  745 }, {  14, 11,  426 }, {  17, 11,   94 }, { 147, 11,   57 },
  {   9, 10,  660 }, { 138, 10,  347 }, {   4, 11,  179 }, {   5, 11,  198 },
  { 133, 11,  697 }, {   7, 11,  347 }, {   7, 11,  971 }, {   8, 11,  181 },
  { 138, 11,  711 }, { 141,  0,  442 }, {  11,  0,  842 }, {  11,  0,  924 },
  {  13,  0,  317 }, {  13,  0,  370 }, {  13,  0,  469 }, {  13,  0,  471 },
  {  14,  0,  397 }, {  18,  0,   69 }, {  18,  0,  145 }, {   7, 10,  572 },
  {   9, 10,  592 }, {  11, 10,  680 }, {  12, 10,  356 }, { 140, 10,  550 },
  {  14, 11,   19 }, {  14, 11,   28 }, { 144, 11,   29 }, { 136,  0,  534 },
  {   4, 11,  243 }, {   5, 11,  203 }, {   7, 11,   19 }, {   7, 11,   71 },
  {   7, 11,  113 }, {  10, 11,  405 }, {  11, 11,  357 }, { 142, 11,  240 },
  {   6,  0,  210 }, {  10,  0,  845 }, { 138,  0,  862 }, {   7, 11, 1351 },
  {   9, 11,  581 }, {  10, 11,  639 }, {  11, 11,  453 }, { 140, 11,  584 },
  {   7, 11, 1450 }, { 139, 11,   99 }, {  10,  0,  892 }, {  12,  0,  719 },
  { 144,  0,  105 }, {   4,  0,  284 }, {   6,  0,  223 }, { 134, 11,  492 },
  {   5, 11,  134 }, {   6, 11,  408 }, {   6, 11,  495 }, { 135, 11, 1593 },
  { 136,  0,  529 }, { 137,  0,  807 }, {   4,  0,  218 }, {   7,  0,  526 },
  { 143,  0,  137 }, {   6,  0, 1444 }, { 142, 11,    4 }, { 132, 11,  665 },
  {   4,  0,  270 }, {   5,  0,  192 }, {   6,  0,  332 }, {   7,  0, 1322 },
  {   4, 11,  248 }, {   7, 11,  137 }, { 137, 11,  349 }, { 140,  0,  661 },
  {   7,  0, 1517 }, {  11,  0,  597 }, {  14,  0,   76 }, {  14,  0,  335 },
  {  20,  0,   33 }, {   7, 10,  748 }, { 139, 10,  700 }, {   5, 11,  371 },
  { 135, 11,  563 }, { 146, 11,   57 }, { 133, 10,  127 }, { 133,  0,  418 },
  {   4, 11,  374 }, {   7, 11,  547 }, {   7, 11, 1700 }, {   7, 11, 1833 },
  { 139, 11,  858 }, {   6, 10,  198 }, { 140, 10,   83 }, {   7, 11, 1812 },
  {  13, 11,  259 }, {  13, 11,  356 }, {  14, 11,  242 }, { 147, 11,  114 },
  {   7,  0,  379 }, {   8,  0,  481 }, {   9,  0,  377 }, {   5, 10,  276 },
  {   6, 10,   55 }, { 135, 10, 1369 }, { 138, 11,  286 }, {   5,  0, 1003 },
  {   6,  0,  149 }, {   6, 10, 1752 }, { 136, 10,  726 }, {   8,  0,  262 },
  {   9,  0,  627 }, {  10,  0,   18 }, {  11,  0,  214 }, {  11,  0,  404 },
  {  11,  0,  457 }, {  11,  0,  780 }, {  11,  0,  913 }, {  13,  0,  401 },
  {  14,  0,  200 }, {   6, 11, 1647 }, {   7, 11, 1552 }, {   7, 11, 2010 },
  {   9, 11,  494 }, { 137, 11,  509 }, { 135,  0,  742 }, { 136,  0,  304 },
  { 132,  0,  142 }, { 133, 10,  764 }, {   6, 10,  309 }, {   7, 10,  331 },
  { 138, 10,  550 }, { 135, 10, 1062 }, {   6, 11,  123 }, {   7, 11,  214 },
  {   7, 10,  986 }, {   9, 11,  728 }, {  10, 11,  157 }, {  11, 11,  346 },
  {  11, 11,  662 }, { 143, 11,  106 }, { 135, 10, 1573 }, {   7,  0,  925 },
  { 137,  0,  799 }, {   4,  0,  471 }, {   5,  0,   51 }, {   6,  0,  602 },
  {   8,  0,  484 }, { 138,  0,  195 }, { 136,  0,  688 }, { 132,  0,  697 },
  {   6,  0, 1169 }, {   6,  0, 1241 }, {   6, 10,  194 }, {   7, 10,  133 },
  {  10, 10,  493 }, {  10, 10,  570 }, { 139, 10,  664 }, { 140,  0,  751 },
  {   7,  0,  929 }, {  10,  0,  452 }, {  11,  0,  878 }, {  16,  0,   33 },
  {   5, 10,   24 }, {   5, 10,  569 }, {   6, 10,    3 }, {   6, 10,  119 },
  {   6, 10,  143 }, {   6, 10,  440 }, {   7, 10,  599 }, {   7, 10, 1686 },
  {   7, 10, 1854 }, {   8, 10,  424 }, {   9, 10,   43 }, {   9, 10,  584 },
  {   9, 10,  760 }, {  10, 10,  328 }, {  11, 10,  159 }, {  11, 10,  253 },
  {  12, 10,  487 }, { 140, 10,  531 }, {   4, 11,  707 }, {  13, 11,  106 },
  {  18, 11,   49 }, { 147, 11,   41 }, {   5,  0,  221 }, {   5, 11,  588 },
  { 134, 11,  393 }, { 134,  0, 1437 }, {   6, 11,  211 }, {   7, 11, 1690 },
  {  11, 11,  486 }, { 140, 11,  369 }, {   5, 10,   14 }, {   5, 10,  892 },
  {   6, 10,  283 }, {   7, 10,  234 }, { 136, 10,  537 }, {   4,  0,  988 },
  { 136,  0,  955 }, { 135,  0, 1251 }, {   4, 10,  126 }, {   8, 10,  635 },
  { 147, 10,   34 }, {   4, 10,  316 }, { 135, 10, 1561 }, { 137, 10,  861 },
  {   4, 10,   64 }, {   5, 10,  352 }, {   5, 10,  720 }, {   6, 10,  368 },
  { 139, 10,  359 }, { 134,  0,  192 }, {   4,  0,  132 }, {   5,  0,   69 },
  { 135,  0, 1242 }, {   7, 10, 1577 }, {  10, 10,  304 }, {  10, 10,  549 },
  {  12, 10,  365 }, {  13, 10,  220 }, {  13, 10,  240 }, { 142, 10,   33 },
  {   4,  0,  111 }, {   7,  0,  865 }, { 134, 11,  219 }, {   5, 11,  582 },
  {   6, 11, 1646 }, {   7, 11,   99 }, {   7, 11, 1962 }, {   7, 11, 1986 },
  {   8, 11,  515 }, {   8, 11,  773 }, {   9, 11,   23 }, {   9, 11,  491 },
  {  12, 11,  620 }, {  14, 11,   52 }, { 145, 11,   50 }, { 132,  0,  767 },
  {   7, 11,  568 }, { 148, 11,   21 }, {   6,  0,   42 }, {   7,  0, 1416 },
  {   7,  0, 2005 }, {   8,  0,  131 }, {   8,  0,  466 }, {   9,  0,  672 },
  {  13,  0,  252 }, {  20,  0,  103 }, { 133, 11,  851 }, { 135,  0, 1050 },
  {   6, 10,  175 }, { 137, 10,  289 }, {   5, 10,  432 }, { 133, 10,  913 },
  {   6,  0,   44 }, { 136,  0,  368 }, { 135, 11,  784 }, { 132,  0,  570 },
  { 133,  0,  120 }, { 139, 10,  595 }, { 140,  0,   29 }, {   6,  0,  227 },
  { 135,  0, 1589 }, {   4, 11,   98 }, {   7, 11, 1365 }, {   9, 11,  422 },
  {   9, 11,  670 }, {  10, 11,  775 }, {  11, 11,  210 }, {  13, 11,   26 },
  {  13, 11,  457 }, { 141, 11,  476 }, { 140, 10,   80 }, {   5, 10,  931 },
  { 134, 10, 1698 }, { 133,  0,  522 }, { 134,  0, 1120 }, { 135,  0, 1529 },
  {  12,  0,  739 }, {  14,  0,  448 }, { 142,  0,  467 }, {  11, 10,  526 },
  {  11, 10,  939 }, { 141, 10,  290 }, {   5, 10,  774 }, {   6, 10, 1637 },
  {   6, 10, 1686 }, { 134, 10, 1751 }, {   6,  0, 1667 }, { 135,  0, 2036 },
  {   7, 10, 1167 }, {  11, 10,  934 }, {  13, 10,  391 }, { 145, 10,   76 },
  { 137, 11,  147 }, {   6, 10,  260 }, {   7, 10, 1484 }, {  11, 11,  821 },
  {  12, 11,  110 }, {  12, 11,  153 }, {  18, 11,   41 }, { 150, 11,   19 },
  {   6,  0,  511 }, {  12,  0,  132 }, { 134, 10,  573 }, {   5,  0,  568 },
  {   6,  0,  138 }, { 135,  0, 1293 }, { 132,  0, 1020 }, {   8,  0,  258 },
  {   9,  0,  208 }, { 137,  0,  359 }, {   4,  0,  565 }, {   8,  0,   23 },
  { 136,  0,  827 }, { 134,  0,  344 }, {   4,  0,  922 }, {   5,  0, 1023 },
  {  13, 11,  477 }, {  14, 11,  120 }, { 148, 11,   61 }, { 134,  0,  240 },
  {   5, 11,  209 }, {   6, 11,   30 }, {  11, 11,   56 }, { 139, 11,  305 },
  {   6,  0,  171 }, {   7,  0, 1002 }, {   7,  0, 1324 }, {   9,  0,  415 },
  {  14,  0,  230 }, {  18,  0,   68 }, {   4, 10,  292 }, {   4, 10,  736 },
  {   5, 10,  871 }, {   6, 10, 1689 }, {   7, 10, 1944 }, { 137, 10,  580 },
  {   9, 11,  635 }, { 139, 11,  559 }, {   4, 11,  150 }, {   5, 11,  303 },
  { 134, 11,  327 }, {   6, 10,   63 }, { 135, 10,  920 }, { 133, 10,  793 },
  {   8, 11,  192 }, {  10, 11,   78 }, {  10, 11,  555 }, {  11, 11,  308 },
  {  13, 11,  359 }, { 147, 11,   95 }, { 135, 11,  786 }, { 135, 11, 1712 },
  { 136,  0,  402 }, {   6,  0,  754 }, {   6, 11, 1638 }, {   7, 11,   79 },
  {   7, 11,  496 }, {   9, 11,  138 }, {  10, 11,  336 }, {  11, 11,   12 },
  {  12, 11,  412 }, {  12, 11,  440 }, { 142, 11,  305 }, {   4,  0,  716 },
  { 141,  0,   31 }, { 133,  0,  982 }, {   8,  0,  691 }, {   8,  0,  731 },
  {   5, 10,   67 }, {   6, 10,   62 }, {   6, 10,  374 }, { 135, 10, 1391 },
  {   9, 10,  790 }, { 140, 10,   47 }, { 139, 11,  556 }, { 151, 11,    1 },
  {   7, 11,  204 }, {   7, 11,  415 }, {   8, 11,   42 }, {  10, 11,   85 },
  {  11, 11,   33 }, {  11, 11,  564 }, {  12, 11,  571 }, { 149, 11,    1 },
  {   8,  0,  888 }, {   7, 11,  610 }, { 135, 11, 1501 }, {   4, 10,  391 },
  { 135, 10, 1169 }, {   5,  0,  847 }, {   9,  0,  840 }, { 138,  0,  803 },
  { 137,  0,  823 }, { 134,  0,  785 }, {   8,  0,  152 }, {   9,  0,   53 },
  {   9,  0,  268 }, {   9,  0,  901 }, {  10,  0,  518 }, {  10,  0,  829 },
  {  11,  0,  188 }, {  13,  0,   74 }, {  14,  0,   46 }, {  15,  0,   17 },
  {  15,  0,   33 }, {  17,  0,   40 }, {  18,  0,   36 }, {  19,  0,   20 },
  {  22,  0,    1 }, { 152,  0,    2 }, {   4, 11,    3 }, {   5, 11,  247 },
  {   5, 11,  644 }, {   7, 11,  744 }, {   7, 11, 1207 }, {   7, 11, 1225 },
  {   7, 11, 1909 }, { 146, 11,  147 }, { 136,  0,  532 }, { 135,  0,  681 },
  { 132, 10,  271 }, { 140,  0,  314 }, { 140,  0,  677 }, {   4,  0,  684 },
  { 136,  0,  384 }, {   5, 11,  285 }, {   9, 11,   67 }, {  13, 11,  473 },
  { 143, 11,   82 }, {   4, 10,  253 }, {   5, 10,  544 }, {   7, 10,  300 },
  { 137, 10,  340 }, {   7,  0,  110 }, {   7,  0,  447 }, {   8,  0,  290 },
  {   8,  0,  591 }, {   9,  0,  382 }, {   9,  0,  649 }, {  11,  0,   71 },
  {  11,  0,  155 }, {  11,  0,  313 }, {  12,  0,    5 }, {  13,  0,  325 },
  { 142,  0,  287 }, { 134,  0, 1818 }, { 136,  0, 1007 }, { 138,  0,  321 },
  {   7,  0,  360 }, {   7,  0,  425 }, {   9,  0,   66 }, {   9,  0,  278 },
  { 138,  0,  644 }, { 133, 10,  818 }, {   5,  0,  385 }, {   5, 10,  541 },
  {   6, 10,   94 }, {   6, 10,  499 }, {   7, 10,  230 }, { 139, 10,  321 },
  {   4, 10,  920 }, {   5, 10,   25 }, {   5, 10,  790 }, {   6, 10,  457 },
  {   7, 10,  853 }, { 136, 10,  788 }, {   4,  0,  900 }, { 133,  0,  861 },
  {   5,  0,  254 }, {   7,  0,  985 }, { 136,  0,   73 }, {   7,  0, 1959 },
  { 136,  0,  683 }, { 134, 10, 1765 }, { 133, 10,  822 }, { 132, 10,  634 },
  {   4, 11,   29 }, {   6, 11,  532 }, {   7, 11, 1628 }, {   7, 11, 1648 },
  {   9, 11,  303 }, {   9, 11,  350 }, {  10, 11,  433 }, {  11, 11,   97 },
  {  11, 11,  557 }, {  11, 11,  745 }, {  12, 11,  289 }, {  12, 11,  335 },
  {  12, 11,  348 }, {  12, 11,  606 }, {  13, 11,  116 }, {  13, 11,  233 },
  {  13, 11,  466 }, {  14, 11,  181 }, {  14, 11,  209 }, {  14, 11,  232 },
  {  14, 11,  236 }, {  14, 11,  300 }, {  16, 11,   41 }, { 148, 11,   97 },
  {  19,  0,   86 }, {   6, 10,   36 }, {   7, 10,  658 }, { 136, 10,  454 },
  { 135, 11, 1692 }, { 132,  0,  725 }, {   5, 11,  501 }, {   7, 11, 1704 },
  {   9, 11,  553 }, {  11, 11,  520 }, {  12, 11,  557 }, { 141, 11,  249 },
  { 134,  0,  196 }, { 133,  0,  831 }, { 136,  0,  723 }, {   7,  0, 1897 },
  {  13,  0,   80 }, {  13,  0,  437 }, { 145,  0,   74 }, {   4,  0,  992 },
  {   6,  0,  627 }, { 136,  0,  994 }, { 135, 11, 1294 }, { 132, 10,  104 },
  {   5,  0,  848 }, {   6,  0,   66 }, { 136,  0,  764 }, {   4,  0,   36 },
  {   7,  0, 1387 }, {  10,  0,  205 }, { 139,  0,  755 }, {   6,  0, 1046 },
  { 134,  0, 1485 }, { 134,  0,  950 }, { 132,  0,  887 }, {  14,  0,  450 },
  { 148,  0,  111 }, {   7,  0,  620 }, {   7,  0,  831 }, {   9, 10,  542 },
  {   9, 10,  566 }, { 138, 10,  728 }, {   6,  0,  165 }, { 138,  0,  388 },
  { 139, 10,  263 }, {   4,  0,  719 }, { 135,  0,  155 }, { 138, 10,  468 },
  {   6, 11,  453 }, { 144, 11,   36 }, { 134, 11,  129 }, {   5,  0,  533 },
  {   7,  0,  755 }, { 138,  0,  780 }, { 134,  0, 1465 }, {   4,  0,  353 },
  {   6,  0,  146 }, {   6,  0, 1789 }, {   7,  0,  427 }, {   7,  0,  990 },
  {   7,  0, 1348 }, {   9,  0,  665 }, {   9,  0,  898 }, {  11,  0,  893 },
  { 142,  0,  212 }, {   7, 10,   87 }, { 142, 10,  288 }, {   4,  0,   45 },
  { 135,  0, 1257 }, {  12,  0,    7 }, {   7, 10,  988 }, {   7, 10, 1939 },
  {   9, 10,   64 }, {   9, 10,  502 }, {  12, 10,   34 }, {  13, 10,   12 },
  {  13, 10,  234 }, { 147, 10,   77 }, {   4,  0,  607 }, {   5, 11,   60 },
  {   6, 11,  504 }, {   7, 11,  614 }, {   7, 11, 1155 }, { 140, 11,    0 },
  { 135, 10,  141 }, {   8, 11,  198 }, {  11, 11,   29 }, { 140, 11,  534 },
  { 140,  0,   65 }, { 136,  0,  816 }, { 132, 10,  619 }, { 139,  0,   88 },
  {   5, 10,  246 }, {   8, 10,  189 }, {   9, 10,  355 }, {   9, 10,  512 },
  {  10, 10,  124 }, {  10, 10,  453 }, {  11, 10,  143 }, {  11, 10,  416 },
  {  11, 10,  859 }, { 141, 10,  341 }, {   4, 11,  379 }, { 135, 11, 1397 },
  {   4,  0,  600 }, { 137,  0,  621 }, { 133,  0,  367 }, { 134,  0,  561 },
  {   6,  0,  559 }, { 134,  0, 1691 }, {   6,  0,  585 }, { 134, 11,  585 },
  { 135, 11, 1228 }, {   4, 11,  118 }, {   5, 10,  678 }, {   6, 11,  274 },
  {   6, 11,  361 }, {   7, 11,   75 }, { 141, 11,  441 }, { 135, 11, 1818 },
  { 137, 11,  841 }, {   5,  0,  573 }, {   6,  0,  287 }, {   7, 10,  862 },
  {   7, 10, 1886 }, { 138, 10,  179 }, { 132, 10,  517 }, { 140, 11,  693 },
  {   5, 11,  314 }, {   6, 11,  221 }, {   7, 11,  419 }, {  10, 11,  650 },
  {  11, 11,  396 }, {  12, 11,  156 }, {  13, 11,  369 }, {  14, 11,  333 },
  { 145, 11,   47 }, { 140, 10,  540 }, { 136, 10,  667 }, {  11, 10,  403 },
  { 146, 10,   83 }, {   6,  0,  672 }, { 133, 10,  761 }, {   9,  0,  157 },
  {  10, 10,  131 }, { 140, 10,   72 }, {   7,  0,  714 }, { 134, 11,  460 },
  { 134,  0,  456 }, { 133,  0,  925 }, {   5, 11,  682 }, { 135, 11, 1887 },
  { 136, 11,  510 }, { 136, 11,  475 }, { 133, 11, 1016 }, {   9,  0,   19 },
  {   7, 11,  602 }, {   8, 11,  179 }, {  10, 11,  781 }, { 140, 11,  126 },
  {   6, 11,  329 }, { 138, 11,  111 }, {   6,  0,  822 }, { 134,  0, 1473 },
  { 144, 11,   86 }, {  11,  0,  113 }, { 139, 11,  113 }, {   5, 11,  821 },
  { 134, 11, 1687 }, { 133, 10,  449 }, {   7,  0,  463 }, {  17,  0,   69 },
  { 136, 10,  103 }, {   7, 10, 2028 }, { 138, 10,  641 }, {   6,  0,  193 },
  {   7,  0,  240 }, {   7,  0, 1682 }, {  10,  0,   51 }, {  10,  0,  640 },
  {  11,  0,  410 }, {  13,  0,   82 }, {  14,  0,  247 }, {  14,  0,  331 },
  { 142,  0,  377 }, {   6,  0,  471 }, {  11,  0,  411 }, { 142,  0,    2 },
  {   5, 11,   71 }, {   7, 11, 1407 }, {   9, 11,  388 }, {   9, 11,  704 },
  {  10, 11,  261 }, {  10, 11,  619 }, {  11, 11,  547 }, {  11, 11,  619 },
  { 143, 11,  157 }, { 136,  0,  633 }, { 135,  0, 1148 }, {   6,  0,  554 },
  {   7,  0, 1392 }, {  12,  0,  129 }, {   7, 10, 1274 }, {   7, 10, 1386 },
  {   7, 11, 2008 }, {   9, 11,  337 }, {  10, 11,  517 }, { 146, 10,   87 },
  {   7,  0,  803 }, {   8,  0,  542 }, {   6, 10,  187 }, {   7, 10, 1203 },
  {   8, 10,  380 }, {  14, 10,  117 }, { 149, 10,   28 }, {   6, 10,  297 },
  {   7, 10,  793 }, { 139, 10,  938 }, {   8,  0,  438 }, {  11,  0,  363 },
  {   7, 10,  464 }, {  11, 10,  105 }, {  12, 10,  231 }, {  14, 10,  386 },
  {  15, 10,  102 }, { 148, 10,   75 }, {   5, 11,   16 }, {   6, 11,   86 },
  {   6, 11,  603 }, {   7, 11,  292 }, {   7, 11,  561 }, {   8, 11,  257 },
  {   8, 11,  382 }, {   9, 11,  721 }, {   9, 11,  778 }, {  11, 11,  581 },
  { 140, 11,  466 }, {   6,  0,  717 }, {   4, 11,  486 }, { 133, 11,  491 },
  { 132,  0,  875 }, { 132, 11,   72 }, {   6, 11,  265 }, { 135, 11,  847 },
  {   4,  0,  237 }, { 135,  0,  514 }, {   6,  0,  392 }, {   7,  0,   65 },
  { 135,  0, 2019 }, { 140, 11,  261 }, { 135, 11,  922 }, { 137, 11,  404 },
  {  12,  0,  563 }, {  14,  0,  101 }, {  18,  0,  129 }, {   7, 10, 1010 },
  {  11, 10,  733 }, {  11, 10,  759 }, {  13, 10,   34 }, { 146, 10,   45 },
  {   7, 10, 1656 }, {   9, 10,  369 }, {  10, 10,  338 }, {  10, 10,  490 },
  {  11, 10,  154 }, {  11, 10,  545 }, {  11, 10,  775 }, {  13, 10,   77 },
  { 141, 10,  274 }, {   4,  0,  444 }, {  10,  0,  146 }, { 140,  0,    9 },
  { 139, 11,  163 }, {   7,  0, 1260 }, { 135,  0, 1790 }, {   9,  0,  222 },
  {  10,  0,   43 }, { 139,  0,  900 }, { 137, 11,  234 }, { 138,  0,  971 },
  { 137,  0,  761 }, { 134,  0,  699 }, { 136, 11,  434 }, {   6,  0, 1116 },
  {   7,  0, 1366 }, {   5, 10,   20 }, {   6, 11,  197 }, {   6, 10,  298 },
  {   7, 10,  659 }, {   8, 11,  205 }, { 137, 10,  219 }, { 132, 11,  490 },
  {  11, 11,  820 }, { 150, 11,   51 }, {   7, 10, 1440 }, {  11, 10,  854 },
  {  11, 10,  872 }, {  11, 10,  921 }, {  12, 10,  551 }, {  13, 10,  472 },
  { 142, 10,  367 }, { 140, 11,   13 }, { 132,  0,  829 }, {  12,  0,  242 },
  { 132, 10,  439 }, { 136, 10,  669 }, {   6,  0,  593 }, {   6, 11,  452 },
  {   7, 11,  312 }, { 138, 11,  219 }, {   4, 11,  333 }, {   9, 11,  176 },
  {  12, 11,  353 }, { 141, 11,  187 }, {   7,  0,   36 }, {   8,  0,  201 },
  { 136,  0,  605 }, { 140,  0,  224 }, { 132, 10,  233 }, { 134,  0, 1430 },
  { 134,  0, 1806 }, {   4,  0,  523 }, { 133,  0,  638 }, {   6,  0, 1889 },
  {   9,  0,  958 }, {   9,  0,  971 }, {   9,  0,  976 }, {  12,  0,  796 },
  {  12,  0,  799 }, {  12,  0,  808 }, {  12,  0,  835 }, {  12,  0,  836 },
  {  12,  0,  914 }, {  12,  0,  946 }, {  15,  0,  216 }, {  15,  0,  232 },
  {  18,  0,  183 }, {  18,  0,  187 }, {  18,  0,  194 }, {  18,  0,  212 },
  {  18,  0,  232 }, { 149,  0,   49 }, { 132, 10,  482 }, {   6,  0,  827 },
  { 134,  0, 1434 }, { 135, 10,  346 }, { 134,  0, 2043 }, {   6,  0,  242 },
  {   7,  0,  227 }, {   7,  0, 1581 }, {   8,  0,  104 }, {   9,  0,  113 },
  {   9,  0,  220 }, {   9,  0,  427 }, {  10,  0,  136 }, {  10,  0,  239 },
  {  11,  0,  579 }, {  11,  0, 1023 }, {  13,  0,    4 }, {  13,  0,  204 },
  {  13,  0,  316 }, { 148,  0,   86 }, { 134, 11, 1685 }, {   7,  0,  148 },
  {   8,  0,  284 }, { 141,  0,   63 }, { 142,  0,   10 }, { 135, 11,  584 },
  { 134,  0, 1249 }, {   7,  0,  861 }, { 135, 10,  334 }, {   5, 10,  795 },
  {   6, 10, 1741 }, { 137, 11,   70 }, { 132,  0,  807 }, {   7, 11,  135 },
  {   8, 11,    7 }, {   8, 11,   62 }, {   9, 11,  243 }, {  10, 11,  658 },
  {  10, 11,  697 }, {  11, 11,  456 }, { 139, 11,  756 }, {   9, 11,  395 },
  { 138, 11,   79 }, { 137, 11,  108 }, { 147,  0,   94 }, { 136,  0,  494 },
  { 135, 11,  631 }, { 135, 10,  622 }, {   7,  0, 1510 }, { 135, 10, 1750 },
  {   4, 10,  203 }, { 135, 10, 1936 }, {   7, 11,  406 }, {   7, 11,  459 },
  {   8, 11,  606 }, { 139, 11,  726 }, {   7,  0, 1306 }, {   8,  0,  505 },
  {   9,  0,  482 }, {  10,  0,  126 }, {  11,  0,  225 }, {  12,  0,  347 },
  {  12,  0,  449 }, {  13,  0,   19 }, {  14,  0,  218 }, { 142,  0,  435 },
  {   5,  0,  268 }, {  10,  0,  764 }, {  12,  0,  120 }, {  13,  0,   39 },
  { 145,  0,  127 }, { 142, 11,   68 }, {  11, 10,  678 }, { 140, 10,  307 },
  {  12, 11,  268 }, {  12, 11,  640 }, { 142, 11,  119 }, { 135, 10, 2044 },
  { 133, 11,  612 }, {   4, 11,  372 }, {   7, 11,  482 }, {   8, 11,  158 },
  {   9, 11,  602 }, {   9, 11,  615 }, {  10, 11,  245 }, {  10, 11,  678 },
  {  10, 11,  744 }, {  11, 11,  248 }, { 139, 11,  806 }, {   7, 10,  311 },
  {   9, 10,  308 }, { 140, 10,  255 }, {   4,  0,  384 }, { 135,  0, 1022 },
  {   5, 11,  854 }, { 135, 11, 1991 }, { 135, 10, 1266 }, {   4, 10,  400 },
  {   5, 10,  267 }, { 135, 10,  232 }, { 135,  0, 1703 }, {   9,  0,  159 },
  {  11,  0,  661 }, { 140,  0,  603 }, {   4,  0,  964 }, {  14,  0,  438 },
  {  14,  0,  444 }, {  14,  0,  456 }, {  22,  0,   60 }, {  22,  0,   63 },
  {   9, 11,  106 }, {   9, 11,  163 }, {   9, 11,  296 }, {  10, 11,  167 },
  {  10, 11,  172 }, {  10, 11,  777 }, { 139, 11,   16 }, { 136,  0,  583 },
  { 132,  0,  515 }, {   8,  0,  632 }, {   8,  0,  697 }, { 137,  0,  854 },
  {   5, 11,  195 }, { 135, 11, 1685 }, {   6,  0, 1123 }, { 134,  0, 1365 },
  { 134, 11,  328 }, {   7, 11, 1997 }, {   8, 11,  730 }, { 139, 11, 1006 },
  {   4,  0,  136 }, { 133,  0,  551 }, { 134,  0, 1782 }, {   7,  0, 1287 },
  {   9,  0,   44 }, {  10,  0,  552 }, {  10,  0,  642 }, {  11,  0,  839 },
  {  12,  0,  274 }, {  12,  0,  275 }, {  12,  0,  372 }, {  13,  0,   91 },
  { 142,  0,  125 }, {   5, 11,  751 }, {  11, 11,  797 }, { 140, 11,  203 },
  { 133,  0,  732 }, {   7,  0,  679 }, {   8,  0,  313 }, {   4, 10,  100 },
  { 135, 11,  821 }, {  10,  0,  361 }, { 142,  0,  316 }, { 134,  0,  595 },
  {   6,  0,  147 }, {   7,  0,  886 }, {   9,  0,  753 }, { 138,  0,  268 },
  {   5, 10,  362 }, {   5, 10,  443 }, {   6, 10,  318 }, {   7, 10, 1019 },
  { 139, 10,  623 }, {   5, 10,  463 }, { 136, 10,  296 }, {   4, 10,  454 },
  {   5, 11,  950 }, {   5, 11,  994 }, { 134, 11,  351 }, { 138,  0,  137 },
  {   5, 10,   48 }, {   5, 10,  404 }, {   6, 10,  557 }, {   7, 10,  458 },
  {   8, 10,  597 }, {  10, 10,  455 }, {  10, 10,  606 }, {  11, 10,   49 },
  {  11, 10,  548 }, {  12, 10,  476 }, {  13, 10,   18 }, { 141, 10,  450 },
  { 133,  0,  414 }, { 135,  0, 1762 }, {   5, 11,  421 }, { 135, 11,   47 },
  {   5, 10,  442 }, { 135, 10, 1984 }, { 134,  0,  599 }, { 134,  0, 1749 },
  { 134,  0, 1627 }, {   4,  0,  488 }, { 132, 11,  350 }, { 137, 11,  751 },
  { 132,  0,   83 }, { 140,  0,  676 }, { 133, 11,  967 }, {   7,  0, 1639 },
  {   5, 10,   55 }, { 140, 10,  161 }, {   4, 11,  473 }, {   7, 11,  623 },
  {   8, 11,  808 }, {   9, 11,  871 }, {   9, 11,  893 }, {  11, 11,   38 },
  {  11, 11,  431 }, {  12, 11,  112 }, {  12, 11,  217 }, {  12, 11,  243 },
  {  12, 11,  562 }, {  12, 11,  683 }, {  13, 11,  141 }, {  13, 11,  197 },
  {  13, 11,  227 }, {  13, 11,  406 }, {  13, 11,  487 }, {  14, 11,  156 },
  {  14, 11,  203 }, {  14, 11,  224 }, {  14, 11,  256 }, {  18, 11,   58 },
  { 150, 11,    0 }, { 133, 10,  450 }, {   7, 11,  736 }, { 139, 11,  264 },
  { 134,  0,  278 }, {   4, 11,  222 }, {   7, 11,  286 }, { 136, 11,  629 },
  { 135, 10,  869 }, { 140,  0,   97 }, { 144,  0,   14 }, { 134,  0, 1085 },
  {   4, 10,  213 }, {   7, 10,  223 }, { 136, 10,   80 }, {   7,  0,  388 },
  {   7,  0,  644 }, { 139,  0,  781 }, { 132,  0,  849 }, {   7,  0,  229 },
  {   8,  0,   59 }, {   9,  0,  190 }, {  10,  0,  378 }, { 140,  0,  191 },
  {   7, 10,  381 }, {   7, 10,  806 }, {   7, 10,  820 }, {   8, 10,  354 },
  {   8, 10,  437 }, {   8, 10,  787 }, {   9, 10,  657 }, {  10, 10,   58 },
  {  10, 10,  339 }, {  10, 10,  749 }, {  11, 10,  914 }, {  12, 10,  162 },
  {  13, 10,   75 }, {  14, 10,  106 }, {  14, 10,  198 }, {  14, 10,  320 },
  {  14, 10,  413 }, { 146, 10,   43 }, { 141, 11,  306 }, { 136, 10,  747 },
  { 134,  0, 1115 }, {  16,  0,   94 }, {  16,  0,  108 }, { 136, 11,  146 },
  {   6,  0,  700 }, {   6,  0,  817 }, { 134,  0, 1002 }, { 133, 10,  692 },
  {   4, 11,  465 }, { 135, 11, 1663 }, { 134, 10,  191 }, {   6,  0, 1414 },
  { 135, 11,  913 }, { 132,  0,  660 }, {   7,  0, 1035 }, { 138,  0,  737 },
  {   6, 10,  162 }, {   7, 10, 1960 }, { 136, 10,  831 }, { 132, 10,  706 },
  {   7,  0,  690 }, {   9,  0,  217 }, {   9,  0,  587 }, { 140,  0,  521 },
  { 138, 10,  426 }, { 135, 10, 1235 }, {   6, 11,   82 }, {   7, 11,  138 },
  {   7, 11,  517 }, {   9, 11,  673 }, { 139, 11,  238 }, { 138,  0,  272 },
  {   5, 11,  495 }, {   7, 11,  834 }, {   9, 11,  733 }, { 139, 11,  378 },
  { 134,  0, 1744 }, { 132,  0, 1011 }, {   7, 11,  828 }, { 142, 11,  116 },
  {   4,  0,  733 }, {   9,  0,  194 }, {  10,  0,   92 }, {  11,  0,  198 },
  {  12,  0,   84 }, {  13,  0,  128 }, { 133, 11,  559 }, {  10,  0,   57 },
  {  10,  0,  277 }, {   6, 11,   21 }, {   6, 11, 1737 }, {   7, 11, 1444 },
  { 136, 11,  224 }, {   4, 10,  204 }, { 137, 10,  902 }, { 136, 10,  833 },
  {  11,  0,  348 }, {  12,  0,   99 }, {  18,  0,    1 }, {  18,  0,   11 },
  {  19,  0,    4 }, {   7, 10,  366 }, {   9, 10,  287 }, {  12, 10,  199 },
  {  12, 10,  556 }, { 140, 10,  577 }, {   6,  0, 1981 }, { 136,  0,  936 },
  {  21,  0,   33 }, { 150,  0,   40 }, {   5, 11,  519 }, { 138, 11,  204 },
  {   5, 10,  356 }, { 135, 10,  224 }, { 134,  0,  775 }, { 135,  0,  306 },
  {   7, 10,  630 }, {   9, 10,  567 }, {  11, 10,  150 }, {  11, 10,  444 },
  { 141, 10,  119 }, {   5,  0,  979 }, { 134, 10,  539 }, { 133,  0,  611 },
  {   4, 11,  402 }, { 135, 11, 1679 }, {   5,  0,  178 }, {   7, 11,    2 },
  {   8, 11,  323 }, { 136, 11,  479 }, {   5, 11,   59 }, { 135, 11,  672 },
  {   4,  0, 1010 }, {   6,  0, 1969 }, { 138, 11,  237 }, { 133, 11,  412 },
  { 146, 11,   34 }, {   7, 11, 1740 }, { 146, 11,   48 }, { 134,  0,  664 },
  { 139, 10,  814 }, {   4, 11,   85 }, { 135, 11,  549 }, { 133, 11,   94 },
  { 133, 11,  457 }, { 132,  0,  390 }, { 134,  0, 1510 }, {   4, 10,  235 },
  { 135, 10,  255 }, {   4, 10,  194 }, {   5, 10,  584 }, {   6, 11,   11 },
  {   6, 10,  384 }, {   7, 11,  187 }, {   7, 10,  583 }, {  10, 10,  761 },
  {  11, 10,  760 }, { 139, 10,  851 }, {   4, 11,  522 }, { 139, 11,  802 },
  { 135,  0,  493 }, {  10, 11,  776 }, {  13, 11,  345 }, { 142, 11,  425 },
  { 146,  0,   37 }, {   4, 11,   52 }, { 135, 11,  661 }, { 134,  0,  724 },
  { 134,  0,  829 }, { 133, 11,  520 }, { 133, 10,  562 }, {   4, 11,  281 },
  {   5, 11,   38 }, {   7, 11,  194 }, {   7, 11,  668 }, {   7, 11, 1893 },
  { 137, 11,  397 }, {   5, 10,  191 }, { 137, 10,  271 }, {   7,  0, 1537 },
  {  14,  0,   96 }, { 143,  0,   73 }, {   5,  0,  473 }, {  11,  0,  168 },
  {   4, 10,  470 }, {   6, 10,  153 }, {   7, 10, 1503 }, {   7, 10, 1923 },
  {  10, 10,  701 }, {  11, 10,  132 }, {  11, 10,  227 }, {  11, 10,  320 },
  {  11, 10,  436 }, {  11, 10,  525 }, {  11, 10,  855 }, {  12, 10,   41 },
  {  12, 10,  286 }, {  13, 10,  103 }, {  13, 10,  284 }, {  14, 10,  255 },
  {  14, 10,  262 }, {  15, 10,  117 }, { 143, 10,  127 }, { 133,  0,  105 },
  {   5,  0,  438 }, {   9,  0,  694 }, {  12,  0,  627 }, { 141,  0,  210 },
  { 133, 10,  327 }, {   6, 10,  552 }, {   7, 10, 1754 }, { 137, 10,  604 },
  { 134,  0, 1256 }, { 152,  0,   11 }, {   5, 11,  448 }, {  11, 11,   98 },
  { 139, 11,  524 }, {   7,  0, 1626 }, {   5, 10,   80 }, {   6, 10,  405 },
  {   7, 10,  403 }, {   7, 10, 1502 }, {   8, 10,  456 }, {   9, 10,  487 },
  {   9, 10,  853 }, {   9, 10,  889 }, {  10, 10,  309 }, {  11, 10,  721 },
  {  11, 10,  994 }, {  12, 10,  430 }, {  13, 10,  165 }, {  14, 11,   16 },
  { 146, 11,   44 }, { 132,  0,  779 }, {   8,  0,   25 }, { 138,  0,  826 },
  {   4, 10,  453 }, {   5, 10,  887 }, {   6, 10,  535 }, {   8, 10,    6 },
  {   8, 10,  543 }, { 136, 10,  826 }, { 137, 11,  461 }, { 140, 11,  632 },
  { 132,  0,  308 }, { 135,  0,  741 }, { 132,  0,  671 }, {   7,  0,  150 },
  {   8,  0,  649 }, { 136,  0, 1020 }, {   9,  0,   99 }, {   6, 11,  336 },
  {   8, 11,  552 }, {   9, 11,  285 }, {  10, 11,   99 }, { 139, 11,  568 },
  { 134,  0,  521 }, {   5,  0,  339 }, {  14,  0,    3 }, {  15,  0,   41 },
  {  15,  0,  166 }, { 147,  0,   66 }, {   6, 11,  423 }, {   7, 11,  665 },
  {   7, 11, 1210 }, {   9, 11,  218 }, { 141, 11,  222 }, {   6,  0,  543 },
  {   5, 10,  101 }, {   5, 11,  256 }, {   6, 10,   88 }, {   7, 10, 1677 },
  {   9, 10,  100 }, {  10, 10,  677 }, {  14, 10,  169 }, {  14, 10,  302 },
  {  14, 10,  313 }, {  15, 10,   48 }, { 143, 10,   84 }, {   4, 10,  310 },
  {   7, 10,  708 }, {   7, 10,  996 }, {   9, 10,  795 }, {  10, 10,  390 },
  {  10, 10,  733 }, {  11, 10,  451 }, {  12, 10,  249 }, {  14, 10,  115 },
  {  14, 10,  286 }, { 143, 10,  100 }, { 133, 10,  587 }, {  13, 11,  417 },
  {  14, 11,  129 }, { 143, 11,   15 }, { 134,  0, 1358 }, { 136, 11,  554 },
  { 132, 10,  498 }, {   7, 10,  217 }, {   8, 10,  140 }, { 138, 10,  610 },
  { 135, 11,  989 }, { 135, 11,  634 }, {   6,  0,  155 }, { 140,  0,  234 },
  { 135, 11,  462 }, { 132, 11,  618 }, { 134,  0, 1628 }, { 132,  0,  766 },
  {   4, 11,  339 }, {   5, 10,  905 }, { 135, 11,  259 }, { 135,  0,  829 },
  {   4, 11,  759 }, { 141, 11,  169 }, {   7,  0, 1445 }, {   4, 10,  456 },
  {   7, 10,  358 }, {   7, 10, 1637 }, {   8, 10,  643 }, { 139, 10,  483 },
  {   5,  0,  486 }, { 135,  0, 1349 }, {   5, 11,  688 }, { 135, 11,  712 },
  {   7,  0, 1635 }, {   8,  0,   17 }, {  10,  0,  217 }, {  10,  0,  295 },
  {  12,  0,    2 }, { 140, 11,    2 }, { 138,  0,  558 }, { 150, 10,   56 },
  {   4, 11,  278 }, {   5, 11,  465 }, { 135, 11, 1367 }, { 136, 11,  482 },
  { 133, 10,  535 }, {   6,  0, 1362 }, {   6,  0, 1461 }, {  10, 11,  274 },
  {  10, 11,  625 }, { 139, 11,  530 }, {   5,  0,  599 }, {   5, 11,  336 },
  {   6, 11,  341 }, {   6, 11,  478 }, {   6, 11, 1763 }, { 136, 11,  386 },
  {   7, 10, 1748 }, { 137, 11,  151 }, { 134,  0, 1376 }, { 133, 10,  539 },
  { 135, 11,   73 }, { 135, 11, 1971 }, { 139, 11,  283 }, {   9,  0,   93 },
  { 139,  0,  474 }, {   6, 10,   91 }, { 135, 10,  435 }, {   6,  0,  447 },
  {   5, 11,  396 }, { 134, 11,  501 }, {   4, 10,   16 }, {   5, 10,  316 },
  {   5, 10,  842 }, {   6, 10,  370 }, {   6, 10, 1778 }, {   8, 10,  166 },
  {  11, 10,  812 }, {  12, 10,  206 }, {  12, 10,  351 }, {  14, 10,  418 },
  {  16, 10,   15 }, {  16, 10,   34 }, {  18, 10,    3 }, {  19, 10,    3 },
  {  19, 10,    7 }, {  20, 10,    4 }, { 149, 10,   21 }, {   7,  0,  577 },
  {   7,  0, 1432 }, {   9,  0,  475 }, {   9,  0,  505 }, {   9,  0,  526 },
  {   9,  0,  609 }, {   9,  0,  689 }, {   9,  0,  726 }, {   9,  0,  735 },
  {   9,  0,  738 }, {  10,  0,  556 }, {  10,  0,  674 }, {  10,  0,  684 },
  {  11,  0,   89 }, {  11,  0,  202 }, {  11,  0,  272 }, {  11,  0,  380 },
  {  11,  0,  415 }, {  11,  0,  505 }, {  11,  0,  537 }, {  11,  0,  550 },
  {  11,  0,  562 }, {  11,  0,  640 }, {  11,  0,  667 }, {  11,  0,  688 },
  {  11,  0,  847 }, {  11,  0,  927 }, {  11,  0,  930 }, {  11,  0,  940 },
  {  12,  0,  144 }, {  12,  0,  325 }, {  12,  0,  329 }, {  12,  0,  389 },
  {  12,  0,  403 }, {  12,  0,  451 }, {  12,  0,  515 }, {  12,  0,  604 },
  {  12,  0,  616 }, {  12,  0,  626 }, {  13,  0,   66 }, {  13,  0,  131 },
  {  13,  0,  167 }, {  13,  0,  236 }, {  13,  0,  368 }, {  13,  0,  411 },
  {  13,  0,  434 }, {  13,  0,  453 }, {  13,  0,  461 }, {  13,  0,  474 },
  {  14,  0,   59 }, {  14,  0,   60 }, {  14,  0,  139 }, {  14,  0,  152 },
  {  14,  0,  276 }, {  14,  0,  353 }, {  14,  0,  402 }, {  15,  0,   28 },
  {  15,  0,   81 }, {  15,  0,  123 }, {  15,  0,  152 }, {  18,  0,  136 },
  { 148,  0,   88 }, {   4, 11,  929 }, { 133, 11,  799 }, { 136, 11,   46 },
  { 142,  0,  307 }, {   4,  0,  609 }, {   7,  0,  756 }, {   9,  0,  544 },
  {  11,  0,  413 }, { 144,  0,   25 }, {  10,  0,  687 }, {   7, 10,  619 },
  {  10, 10,  547 }, {  11, 10,  122 }, { 140, 10,  601 }, {   4,  0,  930 },
  { 133,  0,  947 }, { 133,  0,  939 }, { 142,  0,   21 }, {   4, 11,  892 },
  { 133, 11,  770 }, { 133,  0,  962 }, {   5,  0,  651 }, {   8,  0,  170 },
  {   9,  0,   61 }, {   9,  0,   63 }, {  10,  0,   23 }, {  10,  0,   37 },
  {  10,  0,  834 }, {  11,  0,    4 }, {  11,  0,  187 }, {  11,  0,  281 },
  {  11,  0,  503 }, {  11,  0,  677 }, {  12,  0,   96 }, {  12,  0,  130 },
  {  12,  0,  244 }, {  14,  0,    5 }, {  14,  0,   40 }, {  14,  0,  162 },
  {  14,  0,  202 }, { 146,  0,  133 }, {   4,  0,  406 }, {   5,  0,  579 },
  {  12,  0,  492 }, { 150,  0,   15 }, { 135, 11,  158 }, { 135,  0,  597 },
  { 132,  0,  981 }, { 132, 10,  888 }, {   4, 10,  149 }, { 138, 10,  368 },
  { 132,  0,  545 }, {   4, 10,  154 }, {   7, 10, 1134 }, { 136, 10,  105 },
  { 135, 11, 2001 }, { 134,  0, 1558 }, {   4, 10,   31 }, {   6, 10,  429 },
  {   7, 10,  962 }, {   9, 10,  458 }, { 139, 10,  691 }, { 132, 10,  312 },
  { 135, 10, 1642 }, {   6,  0,   17 }, {   6,  0, 1304 }, {   7,  0,   16 },
  {   7,  0, 1001 }, {   9,  0,  886 }, {  10,  0,  489 }, {  10,  0,  800 },
  {  11,  0,  782 }, {  12,  0,  320 }, {  13,  0,  467 }, {  14,  0,  145 },
  {  14,  0,  387 }, { 143,  0,  119 }, { 135,  0, 1982 }, {  17,  0,   17 },
  {   7, 11, 1461 }, { 140, 11,   91 }, {   4, 10,  236 }, { 132, 11,  602 },
  { 138,  0,  907 }, { 136,  0,  110 }, {   7,  0,  272 }, {  19,  0,   53 },
  {   5, 10,  836 }, {   5, 10,  857 }, { 134, 10, 1680 }, {   5,  0,  458 },
  {   7, 11, 1218 }, { 136, 11,  303 }, {   7,  0, 1983 }, {   8,  0,    0 },
  {   8,  0,  171 }, {   9,  0,  120 }, {   9,  0,  732 }, {  10,  0,  473 },
  {  11,  0,  656 }, {  11,  0,  998 }, {  18,  0,    0 }, {  18,  0,    2 },
  {  19,  0,   21 }, {  10, 10,   68 }, { 139, 10,  494 }, { 137, 11,  662 },
  {   4, 11,   13 }, {   5, 11,  567 }, {   7, 11, 1498 }, {   9, 11,  124 },
  {  11, 11,  521 }, { 140, 11,  405 }, {   4, 10,   81 }, { 139, 10,  867 },
  { 135, 11, 1006 }, {   7, 11,  800 }, {   7, 11, 1783 }, { 138, 11,   12 },
  {   9,  0,  295 }, {  10,  0,  443 }, {   5, 10,  282 }, {   8, 10,  650 },
  { 137, 10,  907 }, { 132, 11,  735 }, {   4, 11,  170 }, {   4, 10,  775 },
  { 135, 11,  323 }, {   6,  0, 1844 }, {  10,  0,  924 }, {  11, 11,  844 },
  {  12, 11,  104 }, { 140, 11,  625 }, {   5, 11,  304 }, {   7, 11, 1403 },
  { 140, 11,  498 }, { 134,  0, 1232 }, {   4,  0,  519 }, {  10,  0,   70 },
  {  12,  0,   26 }, {  14,  0,   17 }, {  14,  0,  178 }, {  15,  0,   34 },
  { 149,  0,   12 }, { 132,  0,  993 }, {   4, 11,  148 }, { 133, 11,  742 },
  {   6,  0,   31 }, {   7,  0,  491 }, {   7,  0,  530 }, {   8,  0,  592 },
  {  11,  0,   53 }, {  11,  0,  779 }, {  12,  0,  167 }, {  12,  0,  411 },
  {  14,  0,   14 }, {  14,  0,  136 }, {  15,  0,   72 }, {  16,  0,   17 },
  { 144,  0,   72 }, { 133,  0,  907 }, { 134,  0,  733 }, { 133, 11,  111 },
  {   4, 10,   71 }, {   5, 10,  376 }, {   7, 10,  119 }, { 138, 10,  665 },
  { 136,  0,   55 }, {   8,  0,  430 }, { 136, 11,  430 }, {   4,  0,  208 },
  {   5,  0,  106 }, {   6,  0,  531 }, {   8,  0,  408 }, {   9,  0,  188 },
  { 138,  0,  572 }, {  12,  0,   56 }, {  11, 10,  827 }, {  14, 10,   34 },
  { 143, 10,  148 }, { 134,  0, 1693 }, { 133, 11,  444 }, { 132, 10,  479 },
  { 140,  0,  441 }, {   9,  0,  449 }, {  10,  0,  192 }, { 138,  0,  740 },
  { 134,  0,  928 }, {   4,  0,  241 }, {   7, 10,  607 }, { 136, 10,   99 },
  {   8, 11,  123 }, {  15, 11,    6 }, { 144, 11,    7 }, {   6, 11,  285 },
  {   8, 11,  654 }, {  11, 11,  749 }, {  12, 11,  190 }, {  12, 11,  327 },
  {  13, 11,  120 }, {  13, 11,  121 }, {  13, 11,  327 }, {  15, 11,   47 },
  { 146, 11,   40 }, {   4, 10,   41 }, {   5, 10,   74 }, {   7, 10, 1627 },
  {  11, 10,  871 }, { 140, 10,  619 }, {   7,  0, 1525 }, {  11, 10,  329 },
  {  11, 10,  965 }, {  12, 10,  241 }, {  14, 10,  354 }, {  15, 10,   22 },
  { 148, 10,   63 }, { 132,  0,  259 }, { 135, 11,  183 }, {   9, 10,  209 },
  { 137, 10,  300 }, {   5, 11,  937 }, { 135, 11,  100 }, { 133, 10,   98 },
  {   4,  0,  173 }, {   5,  0,  312 }, {   5,  0,  512 }, { 135,  0, 1285 },
  { 141,  0,  185 }, {   7,  0, 1603 }, {   7,  0, 1691 }, {   9,  0,  464 },
  {  11,  0,  195 }, {  12,  0,  279 }, {  12,  0,  448 }, {  14,  0,   11 },
  { 147,  0,  102 }, { 135,  0, 1113 }, { 133, 10,  984 }, {   4,  0,  452 },
  {   5,  0,  583 }, { 135,  0,  720 }, {   4,  0,  547 }, {   5,  0,  817 },
  {   6,  0,  433 }, {   7,  0,  593 }, {   7,  0, 1378 }, {   8,  0,  161 },
  {   9,  0,  284 }, {  10,  0,  313 }, { 139,  0,  886 }, {   8,  0,  722 },
  {   4, 10,  182 }, {   6, 10,  205 }, { 135, 10,  220 }, { 150,  0,   13 },
  {   4, 10,   42 }, {   9, 10,  205 }, {   9, 10,  786 }, { 138, 10,  659 },
  {   6,  0,  289 }, {   7,  0, 1670 }, {  12,  0,   57 }, { 151,  0,    4 },
  { 132, 10,  635 }, {  14,  0,   43 }, { 146,  0,   21 }, { 139, 10,  533 },
  { 135,  0, 1694 }, {   8,  0,  420 }, { 139,  0,  193 }, { 135,  0,  409 },
  { 132, 10,  371 }, {   4, 10,  272 }, { 135, 10,  836 }, {   5, 10,  825 },
  { 134, 10, 1640 }, {   5, 11,  251 }, {   5, 11,  956 }, {   8, 11,  268 },
  {   9, 11,  214 }, { 146, 11,  142 }, { 138,  0,  308 }, {   6,  0, 1863 },
  { 141, 11,   37 }, { 137, 10,  879 }, {   7, 10,  317 }, { 135, 10,  569 },
  { 132, 11,  294 }, { 134,  0,  790 }, {   5,  0, 1002 }, { 136,  0,  745 },
  {   5, 11,  346 }, {   5, 11,  711 }, { 136, 11,  390 }, { 135,  0,  289 },
  {   5,  0,  504 }, {  11,  0,   68 }, { 137, 10,  307 }, {   4,  0,  239 },
  {   6,  0,  477 }, {   7,  0, 1607 }, { 139,  0,  617 }, { 149,  0,   13 },
  { 133,  0,  609 }, { 133, 11,  624 }, {   5, 11,  783 }, {   7, 11, 1998 },
  { 135, 11, 2047 }, { 133, 10,  525 }, { 132,  0,  367 }, { 132, 11,  594 },
  {   6,  0,  528 }, { 133, 10,  493 }, {   4, 10,  174 }, { 135, 10,  911 },
  {   8, 10,  417 }, { 137, 10,  782 }, { 132,  0,  694 }, {   7,  0,  548 },
  { 137,  0,   58 }, {   4, 10,   32 }, {   5, 10,  215 }, {   6, 10,  269 },
  {   7, 10, 1782 }, {   7, 10, 1892 }, {  10, 10,   16 }, {  11, 10,  822 },
  {  11, 10,  954 }, { 141, 10,  481 }, { 140,  0,  687 }, {   7,  0, 1749 },
  { 136, 10,  477 }, { 132, 11,  569 }, { 133, 10,  308 }, { 135, 10, 1088 },
  {   4,  0,  661 }, { 138,  0, 1004 }, {   5, 11,   37 }, {   6, 11,   39 },
  {   6, 11,  451 }, {   7, 11,  218 }, {   7, 11,  667 }, {   7, 11, 1166 },
  {   7, 11, 1687 }, {   8, 11,  662 }, { 144, 11,    2 }, {   9,  0,  445 },
  {  12,  0,   53 }, {  13,  0,  492 }, {   5, 10,  126 }, {   8, 10,  297 },
  {   9, 10,  366 }, { 140, 10,  374 }, {   7, 10, 1551 }, { 139, 10,  361 },
  { 148,  0,   74 }, { 134, 11,  508 }, { 135,  0,  213 }, { 132, 10,  175 },
  { 132, 10,  685 }, {   6,  0,  760 }, {   6,  0,  834 }, { 134,  0, 1248 },
  {   7, 11,  453 }, {   7, 11,  635 }, {   7, 11,  796 }, {   8, 11,  331 },
  {   9, 11,  328 }, {   9, 11,  330 }, {   9, 11,  865 }, {  10, 11,  119 },
  {  10, 11,  235 }, {  11, 11,  111 }, {  11, 11,  129 }, {  11, 11,  240 },
  {  12, 11,   31 }, {  12, 11,   66 }, {  12, 11,  222 }, {  12, 11,  269 },
  {  12, 11,  599 }, {  12, 11,  689 }, {  13, 11,  186 }, {  13, 11,  364 },
  { 142, 11,  345 }, {   7,  0, 1672 }, { 139,  0,  189 }, { 133, 10,  797 },
  { 133, 10,  565 }, {   6,  0, 1548 }, {   6, 11,   98 }, {   7, 11,  585 },
  { 135, 11,  702 }, {   9,  0,  968 }, {  15,  0,  192 }, { 149,  0,   56 },
  {   4, 10,  252 }, {   6, 11,   37 }, {   7, 11,  299 }, {   7, 10, 1068 },
  {   7, 11, 1666 }, {   8, 11,  195 }, {   8, 11,  316 }, {   9, 11,  178 },
  {   9, 11,  276 }, {   9, 11,  339 }, {   9, 11,  536 }, {  10, 11,  102 },
  {  10, 11,  362 }, {  10, 10,  434 }, {  10, 11,  785 }, {  11, 11,   55 },
  {  11, 11,  149 }, {  11, 10,  228 }, {  11, 10,  426 }, {  11, 11,  773 },
  {  13, 10,  231 }, {  13, 11,  416 }, {  13, 11,  419 }, {  14, 11,   38 },
  {  14, 11,   41 }, {  14, 11,  210 }, {  18, 10,  106 }, { 148, 10,   87 },
  {   4,  0,  751 }, {  11,  0,  390 }, { 140,  0,   32 }, {   4,  0,  409 },
  { 133,  0,   78 }, {  11, 11,  458 }, {  12, 11,   15 }, { 140, 11,  432 },
  {   7,  0, 1602 }, {  10,  0,  257 }, {  10,  0,  698 }, {  11,  0,  544 },
  {  11,  0,  585 }, {  12,  0,  212 }, {  13,  0,  307 }, {   5, 10,  231 },
  {   7, 10,  601 }, {   9, 10,  277 }, {   9, 10,  674 }, {  10, 10,  178 },
  {  10, 10,  418 }, {  10, 10,  509 }, {  11, 10,  531 }, {  12, 10,  113 },
  {  12, 10,  475 }, {  13, 10,   99 }, { 142, 10,  428 }, {   6,  0,  473 },
  { 145,  0,  105 }, {   6,  0, 1949 }, {  15,  0,  156 }, { 133, 11,  645 },
  {   7, 10, 1591 }, { 144, 10,   43 }, { 135,  0, 1779 }, { 135, 10, 1683 },
  {   4, 11,  290 }, { 135, 11, 1356 }, { 134,  0,  763 }, {   6, 11,   70 },
  {   7, 11, 1292 }, {  10, 11,  762 }, { 139, 11,  288 }, { 142,  0,   29 },
  { 140, 11,  428 }, {   7,  0,  883 }, {   7, 11,  131 }, {   7, 11,  422 },
  {   8, 11,  210 }, { 140, 11,  573 }, { 134,  0,  488 }, {   4, 10,  399 },
  {   5, 10,  119 }, {   5, 10,  494 }, {   7, 10,  751 }, { 137, 10,  556 },
  { 133,  0,  617 }, { 132, 11,  936 }, { 139,  0,   50 }, {   7,  0, 1518 },
  { 139,  0,  694 }, { 137,  0,  785 }, {   4,  0,  546 }, { 135,  0, 2042 },
  {   7, 11,  716 }, {  13, 11,   97 }, { 141, 11,  251 }, { 132, 11,  653 },
  { 145,  0,   22 }, { 134,  0, 1016 }, {   4,  0,  313 }, { 133,  0,  577 },
  { 136, 11,  657 }, {   8,  0,  184 }, { 141,  0,  433 }, { 135,  0,  935 },
  {   6,  0,  720 }, {   9,  0,  114 }, { 146, 11,   80 }, {  12,  0,  186 },
  {  12,  0,  292 }, {  14,  0,  100 }, {  18,  0,   70 }, {   7, 10,  594 },
  {   7, 10,  851 }, {   7, 10, 1858 }, {   9, 10,  411 }, {   9, 10,  574 },
  {   9, 10,  666 }, {   9, 10,  737 }, {  10, 10,  346 }, {  10, 10,  712 },
  {  11, 10,  246 }, {  11, 10,  432 }, {  11, 10,  517 }, {  11, 10,  647 },
  {  11, 10,  679 }, {  11, 10,  727 }, {  12, 10,  304 }, {  12, 10,  305 },
  {  12, 10,  323 }, {  12, 10,  483 }, {  12, 10,  572 }, {  12, 10,  593 },
  {  12, 10,  602 }, {  13, 10,   95 }, {  13, 10,  101 }, {  13, 10,  171 },
  {  13, 10,  315 }, {  13, 10,  378 }, {  13, 10,  425 }, {  13, 10,  475 },
  {  14, 10,   63 }, {  14, 10,  380 }, {  14, 10,  384 }, {  15, 10,  133 },
  {  18, 10,  112 }, { 148, 10,   72 }, { 135, 10, 1093 }, { 135, 11, 1836 },
  { 132, 10,  679 }, { 137, 10,  203 }, {  11,  0,  402 }, {  12,  0,  109 },
  {  12,  0,  431 }, {  13,  0,  179 }, {  13,  0,  206 }, {  14,  0,  217 },
  {  16,  0,    3 }, { 148,  0,   53 }, {   7, 11, 1368 }, {   8, 11,  232 },
  {   8, 11,  361 }, {  10, 11,  682 }, { 138, 11,  742 }, { 137, 10,  714 },
  {   5,  0,  886 }, {   6,  0,   46 }, {   6,  0, 1790 }, {   7,  0,   14 },
  {   7,  0,  732 }, {   7,  0, 1654 }, {   8,  0,   95 }, {   8,  0,  327 },
  {   8,  0,  616 }, {   9,  0,  892 }, {  10,  0,  598 }, {  10,  0,  769 },
  {  11,  0,  134 }, {  11,  0,  747 }, {  12,  0,  378 }, {  14,  0,   97 },
  { 137, 11,  534 }, {   4,  0,  969 }, { 136, 10,  825 }, { 137, 11,   27 },
  {   6,  0,  727 }, { 142, 11,   12 }, { 133,  0, 1021 }, { 134,  0, 1190 },
  { 134, 11, 1657 }, {   5, 10,  143 }, {   5, 10,  769 }, {   6, 10, 1760 },
  {   7, 10,  682 }, {   7, 10, 1992 }, { 136, 10,  736 }, { 132,  0,  153 },
  { 135, 11,  127 }, { 133,  0,  798 }, { 132,  0,  587 }, {   6,  0,  598 },
  {   7,  0,   42 }, {   8,  0,  695 }, {  10,  0,  212 }, {  11,  0,  158 },
  {  14,  0,  196 }, { 145,  0,   85 }, { 133, 10,  860 }, {   6,  0, 1929 },
  { 134,  0, 1933 }, {   5,  0,  957 }, {   5,  0, 1008 }, {   9,  0,  577 },
  {  12,  0,  141 }, {   6, 10,  422 }, {   7, 10,    0 }, {   7, 10, 1544 },
  {   8, 11,  364 }, {  11, 10,  990 }, {  12, 10,  453 }, {  13, 10,   47 },
  { 141, 10,  266 }, { 134,  0, 1319 }, {   4,  0,  129 }, { 135,  0,  465 },
  {   7,  0,  470 }, {   7,  0, 1057 }, {   7,  0, 1201 }, {   9,  0,  755 },
  {  11,  0,  906 }, { 140,  0,  527 }, {   7,  0,  908 }, { 146,  0,    7 },
  {   5,  0,  148 }, { 136,  0,  450 }, {   5, 10,  515 }, { 137, 10,  131 },
  {   7, 10, 1605 }, {  11, 10,  962 }, { 146, 10,  139 }, { 132, 10,  646 },
  { 134,  0, 1166 }, {   4, 10,  396 }, {   7, 10,  728 }, {   9, 10,  117 },
  {  13, 10,  202 }, { 148, 10,   51 }, {   6, 10,  121 }, {   6, 10,  124 },
  {   6, 10,  357 }, {   7, 10, 1138 }, {   7, 10, 1295 }, {   8, 10,  162 },
  { 139, 10,  655 }, {  14,  0,  374 }, { 142, 11,  374 }, { 138,  0,  253 },
  { 139,  0, 1003 }, {   5, 11,  909 }, {   9, 11,  849 }, { 138, 11,  805 },
  { 133, 10,  237 }, {   7, 11,  525 }, {   7, 11, 1579 }, {   8, 11,  497 },
  { 136, 11,  573 }, { 137,  0,   46 }, { 132,  0,  879 }, { 134,  0,  806 },
  { 135,  0, 1868 }, {   6,  0, 1837 }, { 134,  0, 1846 }, {   6,  0,  730 },
  { 134,  0,  881 }, {   7,  0,  965 }, {   7,  0, 1460 }, {   7,  0, 1604 },
  {   7, 11,  193 }, {   7, 11,  397 }, {   7, 11, 1105 }, {   8, 11,  124 },
  {   8, 11,  619 }, {   9, 11,  305 }, {  10, 11,  264 }, {  11, 11,   40 },
  {  12, 11,  349 }, {  13, 11,  134 }, {  13, 11,  295 }, {  14, 11,  155 },
  {  15, 11,  120 }, { 146, 11,  105 }, { 136,  0,  506 }, { 143,  0,   10 },
  {   4, 11,  262 }, {   7, 11,  342 }, {   7, 10,  571 }, {   7, 10, 1877 },
  {  10, 10,  366 }, { 141, 11,   23 }, { 133, 11,  641 }, {  10,  0,   22 },
  {   9, 10,  513 }, {  10, 10,   39 }, {  12, 10,  122 }, { 140, 10,  187 },
  { 135, 11, 1431 }, { 150, 11,   49 }, {   4, 11,   99 }, {   6, 11,  250 },
  {   6, 11,  346 }, {   8, 11,  127 }, { 138, 11,   81 }, {   6,  0, 2014 },
  {   8,  0,  928 }, {  10,  0,  960 }, {  10,  0,  979 }, { 140,  0,  996 },
  { 134,  0,  296 }, { 132, 11,  915 }, {   5, 11,   75 }, {   9, 11,  517 },
  {  10, 11,  470 }, {  12, 11,  155 }, { 141, 11,  224 }, { 137, 10,  873 },
  {   4,  0,  854 }, { 140, 11,   18 }, { 134,  0,  587 }, {   7, 10,  107 },
  {   7, 10,  838 }, {   8, 10,  550 }, { 138, 10,  401 }, {  11,  0,  636 },
  {  15,  0,  145 }, {  17,  0,   34 }, {  19,  0,   50 }, {  23,  0,   20 },
  {  11, 10,  588 }, {  11, 10,  864 }, {  11, 10,  968 }, { 143, 10,  160 },
  { 135, 11,  216 }, {   7,  0,  982 }, {  10,  0,   32 }, { 143,  0,   56 },
  { 133, 10,  768 }, { 133, 11,  954 }, {   6, 11,  304 }, {   7, 11, 1114 },
  {   8, 11,  418 }, {  10, 11,  345 }, {  11, 11,  341 }, {  11, 11,  675 },
  { 141, 11,   40 }, {   9, 11,  410 }, { 139, 11,  425 }, { 136,  0,  941 },
  {   5,  0,  435 }, { 132, 10,  894 }, {   5,  0,   85 }, {   6,  0,  419 },
  {   7,  0,  134 }, {   7,  0,  305 }, {   7,  0,  361 }, {   7,  0, 1337 },
  {   8,  0,   71 }, { 140,  0,  519 }, { 140,  0,  688 }, { 135,  0,  740 },
  {   5,  0,  691 }, {   7,  0,  345 }, {   9,  0,   94 }, { 140,  0,  169 },
  {   5,  0,  183 }, {   6,  0,  582 }, {  10,  0,  679 }, { 140,  0,  435 },
  { 134, 11,   14 }, {   6,  0,  945 }, { 135,  0,  511 }, { 134, 11, 1708 },
  {   5, 11,  113 }, {   6, 11,  243 }, {   7, 11, 1865 }, {  11, 11,  161 },
  {  16, 11,   37 }, { 145, 11,   99 }, { 132, 11,  274 }, { 137,  0,  539 },
  {   7,  0, 1993 }, {   8,  0,  684 }, { 134, 10,  272 }, {   6,  0,  659 },
  { 134,  0,  982 }, {   4, 10,    9 }, {   5, 10,  128 }, {   7, 10,  368 },
  {  11, 10,  480 }, { 148, 10,    3 }, { 134,  0,  583 }, { 132,  0,  803 },
  { 133,  0,  704 }, {   4,  0,  179 }, {   5,  0,  198 }, { 133,  0,  697 },
  {   7,  0,  347 }, {   7,  0,  971 }, {   8,  0,  181 }, {  10,  0,  711 },
  { 135, 11,  166 }, { 136, 10,  682 }, {   4, 10,    2 }, {   7, 10,  545 },
  {   7, 10,  894 }, { 136, 11,  521 }, { 135,  0,  481 }, { 132,  0,  243 },
  {   5,  0,  203 }, {   7,  0,   19 }, {   7,  0,   71 }, {   7,  0,  113 },
  {  10,  0,  405 }, {  11,  0,  357 }, { 142,  0,  240 }, {   5, 11,  725 },
  {   5, 11,  727 }, { 135, 11, 1811 }, {   6,  0,  826 }, { 137, 11,  304 },
  {   7,  0, 1450 }, { 139,  0,   99 }, { 133, 11,  654 }, { 134,  0,  492 },
  {   5,  0,  134 }, {   6,  0,  408 }, {   6,  0,  495 }, {   7,  0, 1593 },
  {   6, 11,  273 }, {  10, 11,  188 }, {  13, 11,  377 }, { 146, 11,   77 },
  {   9, 10,  769 }, { 140, 10,  185 }, { 135, 11,  410 }, { 142,  0,    4 },
  {   4,  0,  665 }, { 134, 11, 1785 }, {   4,  0,  248 }, {   7,  0,  137 },
  { 137,  0,  349 }, {   5, 10,  530 }, { 142, 10,  113 }, {   7,  0, 1270 },
  { 139,  0,  612 }, { 132, 11,  780 }, {   5,  0,  371 }, { 135,  0,  563 },
  { 135,  0,  826 }, {   6,  0, 1535 }, {  23,  0,   21 }, { 151,  0,   23 },
  {   4,  0,  374 }, {   7,  0,  547 }, {   7,  0, 1700 }, {   7,  0, 1833 },
  { 139,  0,  858 }, { 133, 10,  556 }, {   7, 11,  612 }, {   8, 11,  545 },
  {   8, 11,  568 }, {   8, 11,  642 }, {   9, 11,  717 }, {  10, 11,  541 },
  {  10, 11,  763 }, {  11, 11,  449 }, {  12, 11,  489 }, {  13, 11,  153 },
  {  13, 11,  296 }, {  14, 11,  138 }, {  14, 11,  392 }, {  15, 11,   50 },
  {  16, 11,    6 }, {  16, 11,   12 }, { 148, 11,    9 }, {   9,  0,  311 },
  { 141,  0,   42 }, {   8, 10,   16 }, { 140, 10,  568 }, {   6,  0, 1968 },
  {   6,  0, 2027 }, { 138,  0,  991 }, {   6,  0, 1647 }, {   7,  0, 1552 },
  {   7,  0, 2010 }, {   9,  0,  494 }, { 137,  0,  509 }, { 133, 11,  948 },
  {   6, 10,  186 }, { 137, 10,  426 }, { 134,  0,  769 }, { 134,  0,  642 },
  { 132, 10,  585 }, {   6,  0,  123 }, {   7,  0,  214 }, {   9,  0,  728 },
  {  10,  0,  157 }, {  11,  0,  346 }, {  11,  0,  662 }, { 143,  0,  106 },
  { 142, 11,  381 }, { 135,  0, 1435 }, {   4, 11,  532 }, {   5, 11,  706 },
  { 135, 11,  662 }, {   5, 11,  837 }, { 134, 11, 1651 }, {   4, 10,   93 },
  {   5, 10,  252 }, {   6, 10,  229 }, {   7, 10,  291 }, {   9, 10,  550 },
  { 139, 10,  644 }, { 148,  0,   79 }, { 137, 10,  749 }, { 134,  0, 1425 },
  { 137, 10,  162 }, {   4, 11,  362 }, {   7, 11,   52 }, {   7, 11,  303 },
  { 140, 11,  166 }, { 132, 10,  381 }, {   4, 11,  330 }, {   7, 11,  933 },
  {   7, 11, 2012 }, { 136, 11,  292 }, { 135, 11,  767 }, {   4,  0,  707 },
  {   5,  0,  588 }, {   6,  0,  393 }, {  13,  0,  106 }, {  18,  0,   49 },
  { 147,  0,   41 }, {   6,  0,  211 }, {   7,  0, 1690 }, {  11,  0,  486 },
  { 140,  0,  369 }, { 137, 11,  883 }, {   4, 11,  703 }, { 135, 11,  207 },
  {   4,  0,  187 }, {   5,  0,  184 }, {   5,  0,  690 }, {   7,  0, 1869 },
  {  10,  0,  756 }, { 139,  0,  783 }, { 132, 11,  571 }, { 134,  0, 1382 },
  {   5,  0,  175 }, {   6, 10,   77 }, {   6, 10,  157 }, {   7, 10,  974 },
  {   7, 10, 1301 }, {   7, 10, 1339 }, {   7, 10, 1490 }, {   7, 10, 1873 },
  { 137, 10,  628 }, { 134,  0, 1493 }, {   5, 11,  873 }, { 133, 11,  960 },
  { 134,  0, 1007 }, {  12, 11,   93 }, {  12, 11,  501 }, {  13, 11,  362 },
  {  14, 11,  151 }, {  15, 11,   40 }, {  15, 11,   59 }, {  16, 11,   46 },
  {  17, 11,   25 }, {  18, 11,   14 }, {  18, 11,  134 }, {  19, 11,   25 },
  {  19, 11,   69 }, {  20, 11,   16 }, {  20, 11,   19 }, {  20, 11,   66 },
  {  21, 11,   23 }, {  21, 11,   25 }, { 150, 11,   42 }, {  11, 10,  919 },
  { 141, 10,  409 }, { 134,  0,  219 }, {   5,  0,  582 }, {   6,  0, 1646 },
  {   7,  0,   99 }, {   7,  0, 1962 }, {   7,  0, 1986 }, {   8,  0,  515 },
  {   8,  0,  773 }, {   9,  0,   23 }, {   9,  0,  491 }, {  12,  0,  620 },
  { 142,  0,   93 }, { 133,  0,  851 }, {   5, 11,   33 }, { 134, 11,  470 },
  { 135, 11, 1291 }, { 134,  0, 1278 }, { 135, 11, 1882 }, { 135, 10, 1489 },
  { 132,  0, 1000 }, { 138,  0,  982 }, {   8,  0,  762 }, {   8,  0,  812 },
  { 137,  0,  910 }, {   6, 11,   47 }, {   7, 11,   90 }, {   7, 11,  664 },
  {   7, 11,  830 }, {   7, 11, 1380 }, {   7, 11, 2025 }, {   8, 11,  448 },
  { 136, 11,  828 }, {   4,  0,   98 }, {   4,  0,  940 }, {   6,  0, 1819 },
  {   6,  0, 1834 }, {   6,  0, 1841 }, {   7,  0, 1365 }, {   8,  0,  859 },
  {   8,  0,  897 }, {   8,  0,  918 }, {   9,  0,  422 }, {   9,  0,  670 },
  {  10,  0,  775 }, {  10,  0,  894 }, {  10,  0,  909 }, {  10,  0,  910 },
  {  10,  0,  935 }, {  11,  0,  210 }, {  12,  0,  750 }, {  12,  0,  755 },
  {  13,  0,   26 }, {  13,  0,  457 }, {  13,  0,  476 }, {  16,  0,  100 },
  {  16,  0,  109 }, {  18,  0,  173 }, {  18,  0,  175 }, {   8, 10,  398 },
  {   9, 10,  681 }, { 139, 10,  632 }, {   9, 11,  417 }, { 137, 11,  493 },
  { 136, 10,  645 }, { 138,  0,  906 }, { 134,  0, 1730 }, { 134, 10,   20 },
  { 133, 11, 1019 }, { 134,  0, 1185 }, {  10,  0,   40 }, { 136, 10,  769 },
  {   9,  0,  147 }, { 134, 11,  208 }, { 140,  0,  650 }, {   5,  0,  209 },
  {   6,  0,   30 }, {  11,  0,   56 }, { 139,  0,  305 }, { 132,  0,  553 },
  { 138, 11,  344 }, {   6, 11,   68 }, {   7, 11,  398 }, {   7, 11,  448 },
  {   7, 11, 1629 }, {   7, 11, 1813 }, {   8, 11,  387 }, {   8, 11,  442 },
  {   9, 11,  710 }, {  10, 11,  282 }, { 138, 11,  722 }, {   5,  0,  597 },
  {  14,  0,   20 }, { 142, 11,   20 }, { 135,  0, 1614 }, { 135, 10, 1757 },
  {   4,  0,  150 }, {   5,  0,  303 }, {   6,  0,  327 }, { 135, 10,  937 },
  {  16,  0,   49 }, {   7, 10, 1652 }, { 144, 11,   49 }, {   8,  0,  192 },
  {  10,  0,   78 }, { 141,  0,  359 }, { 135,  0,  786 }, { 143,  0,  134 },
  {   6,  0, 1638 }, {   7,  0,   79 }, {   7,  0,  496 }, {   9,  0,  138 },
  {  10,  0,  336 }, {  11,  0,   12 }, {  12,  0,  412 }, {  12,  0,  440 },
  { 142,  0,  305 }, { 136, 11,  491 }, {   4, 10,  579 }, {   5, 10,  226 },
  {   5, 10,  323 }, { 135, 10,  960 }, {   7,  0,  204 }, {   7,  0,  415 },
  {   8,  0,   42 }, {  10,  0,   85 }, { 139,  0,  564 }, { 132,  0,  614 },
  {   4, 11,  403 }, {   5, 11,  441 }, {   7, 11,  450 }, {  11, 11,  101 },
  {  12, 11,  193 }, { 141, 11,  430 }, { 135, 11, 1927 }, { 135, 11, 1330 },
  {   4,  0,    3 }, {   5,  0,  247 }, {   5,  0,  644 }, {   7,  0,  744 },
  {   7,  0, 1207 }, {   7,  0, 1225 }, {   7,  0, 1909 }, { 146,  0,  147 },
  { 136,  0,  942 }, {   4,  0, 1019 }, { 134,  0, 2023 }, {   5, 11,  679 },
  { 133, 10,  973 }, {   5,  0,  285 }, {   9,  0,   67 }, {  13,  0,  473 },
  { 143,  0,   82 }, {   7, 11,  328 }, { 137, 11,  326 }, { 151,  0,    8 },
  {   6, 10,  135 }, { 135, 10, 1176 }, { 135, 11, 1128 }, { 134,  0, 1309 },
  { 135, 11, 1796 }, { 135, 10,  314 }, {   4, 11,  574 }, {   7, 11,  350 },
  {   7, 11, 1024 }, {   8, 11,  338 }, {   9, 11,  677 }, {  10, 11,  808 },
  { 139, 11,  508 }, {   7, 11,  818 }, {  17, 11,   14 }, {  17, 11,   45 },
  {  18, 11,   75 }, { 148, 11,   18 }, { 146, 10,    4 }, { 135, 11, 1081 },
  {   4,  0,   29 }, {   6,  0,  532 }, {   7,  0, 1628 }, {   7,  0, 1648 },
  {   9,  0,  350 }, {  10,  0,  433 }, {  11,  0,   97 }, {  11,  0,  557 },
  {  11,  0,  745 }, {  12,  0,  289 }, {  12,  0,  335 }, {  12,  0,  348 },
  {  12,  0,  606 }, {  13,  0,  116 }, {  13,  0,  233 }, {  13,  0,  466 },
  {  14,  0,  181 }, {  14,  0,  209 }, {  14,  0,  232 }, {  14,  0,  236 },
  {  14,  0,  300 }, {  16,  0,   41 }, { 148,  0,   97 }, {   7,  0,  318 },
  {   6, 10,  281 }, {   8, 10,  282 }, {   8, 10,  480 }, {   8, 10,  499 },
  {   9, 10,  198 }, {  10, 10,  143 }, {  10, 10,  169 }, {  10, 10,  211 },
  {  10, 10,  417 }, {  10, 10,  574 }, {  11, 10,  147 }, {  11, 10,  395 },
  {  12, 10,   75 }, {  12, 10,  407 }, {  12, 10,  608 }, {  13, 10,  500 },
  { 142, 10,  251 }, { 135, 11, 1676 }, { 135, 11, 2037 }, { 135,  0, 1692 },
  {   5,  0,  501 }, {   7,  0, 1704 }, {   9,  0,  553 }, {  11,  0,  520 },
  {  12,  0,  557 }, { 141,  0,  249 }, {   6,  0, 1527 }, {  14,  0,  324 },
  {  15,  0,   55 }, {  15,  0,   80 }, {  14, 11,  324 }, {  15, 11,   55 },
  { 143, 11,   80 }, { 135, 10, 1776 }, {   8,  0,  988 }, { 137, 11,  297 },
  { 132, 10,  419 }, { 142,  0,  223 }, { 139, 11,  234 }, {   7,  0, 1123 },
  {  12,  0,  508 }, {  14,  0,  102 }, {  14,  0,  226 }, { 144,  0,   57 },
  {   4, 10,  138 }, {   7, 10, 1012 }, {   7, 10, 1280 }, { 137, 10,   76 },
  {   7,  0, 1764 }, {   5, 10,   29 }, { 140, 10,  638 }, { 134,  0, 2015 },
  { 134,  0, 1599 }, { 138, 11,   56 }, {   6, 11,  306 }, {   7, 11, 1140 },
  {   7, 11, 1340 }, {   8, 11,  133 }, { 138, 11,  449 }, { 139, 11, 1011 },
  {   6, 10, 1710 }, { 135, 10, 2038 }, {   7, 11, 1763 }, { 140, 11,  310 },
  {   6,  0,  129 }, {   4, 10,   17 }, {   5, 10,   23 }, {   7, 10,  995 },
  {  11, 10,  383 }, {  11, 10,  437 }, {  12, 10,  460 }, { 140, 10,  532 },
  {   5, 11,  329 }, { 136, 11,  260 }, { 133, 10,  862 }, { 132,  0,  534 },
  {   6,  0,  811 }, { 135,  0,  626 }, { 132, 11,  657 }, {   4,  0,   25 },
  {   5,  0,   60 }, {   6,  0,  504 }, {   7,  0,  614 }, {   7,  0, 1155 },
  {  12,  0,    0 }, { 152, 11,    7 }, {   7,  0, 1248 }, {  11,  0,  621 },
  { 139,  0,  702 }, { 137,  0,  321 }, {   8, 10,   70 }, {  12, 10,  171 },
  { 141, 10,  272 }, {  10, 10,  233 }, { 139, 10,   76 }, {   4,  0,  379 },
  {   7,  0, 1397 }, { 134, 10,  442 }, {   5, 11,   66 }, {   7, 11, 1896 },
  { 136, 11,  288 }, { 134, 11, 1643 }, { 134, 10, 1709 }, {   4, 11,   21 },
  {   5, 11,   91 }, {   5, 11,  570 }, {   5, 11,  648 }, {   5, 11,  750 },
  {   5, 11,  781 }, {   6, 11,   54 }, {   6, 11,  112 }, {   6, 11,  402 },
  {   6, 11, 1732 }, {   7, 11,  315 }, {   7, 11,  749 }, {   7, 11, 1347 },
  {   7, 11, 1900 }, {   9, 11,   78 }, {   9, 11,  508 }, {  10, 11,  611 },
  {  11, 11,  510 }, {  11, 11,  728 }, {  13, 11,   36 }, {  14, 11,   39 },
  {  16, 11,   83 }, {  17, 11,  124 }, { 148, 11,   30 }, {   4,  0,  118 },
  {   6,  0,  274 }, {   6,  0,  361 }, {   7,  0,   75 }, { 141,  0,  441 },
  {  10, 11,  322 }, {  10, 11,  719 }, { 139, 11,  407 }, { 147, 10,  119 },
  {  12, 11,  549 }, {  14, 11,   67 }, { 147, 11,   60 }, {  11, 10,   69 },
  {  12, 10,  105 }, {  12, 10,  117 }, {  13, 10,  213 }, {  14, 10,   13 },
  {  14, 10,   62 }, {  14, 10,  177 }, {  14, 10,  421 }, {  15, 10,   19 },
  { 146, 10,  141 }, {   9,  0,  841 }, { 137, 10,  309 }, {   7, 10,  608 },
  {   7, 10,  976 }, {   8, 11,  125 }, {   8, 11,  369 }, {   8, 11,  524 },
  {   9, 10,  146 }, {  10, 10,  206 }, {  10, 11,  486 }, {  10, 10,  596 },
  {  11, 11,   13 }, {  11, 11,  381 }, {  11, 11,  736 }, {  11, 11,  766 },
  {  11, 11,  845 }, {  13, 11,  114 }, {  13, 10,  218 }, {  13, 11,  292 },
  {  14, 11,   47 }, { 142, 10,  153 }, {  12,  0,  693 }, { 135, 11,  759 },
  {   5,  0,  314 }, {   6,  0,  221 }, {   7,  0,  419 }, {  10,  0,  650 },
  {  11,  0,  396 }, {  12,  0,  156 }, {  13,  0,  369 }, {  14,  0,  333 },
  { 145,  0,   47 }, {   6, 11, 1684 }, {   6, 11, 1731 }, {   7, 11,  356 },
  {   7, 11, 1932 }, {   8, 11,   54 }, {   8, 11,  221 }, {   9, 11,  225 },
  {   9, 11,  356 }, {  10, 11,   77 }, {  10, 11,  446 }, {  10, 11,  731 },
  {  12, 11,  404 }, { 141, 11,  491 }, { 132, 11,  375 }, {   4, 10,  518 },
  { 135, 10, 1136 }, {   4,  0,  913 }, {   4, 11,  411 }, {  11, 11,  643 },
  { 140, 11,  115 }, {   4, 11,   80 }, { 133, 11,   44 }, {   8, 10,  689 },
  { 137, 10,  863 }, { 138,  0,  880 }, {   4, 10,   18 }, {   7, 10,  145 },
  {   7, 10,  444 }, {   7, 10, 1278 }, {   8, 10,   49 }, {   8, 10,  400 },
  {   9, 10,   71 }, {   9, 10,  250 }, {  10, 10,  459 }, {  12, 10,  160 },
  { 144, 10,   24 }, { 136,  0,  475 }, {   5,  0, 1016 }, {   5, 11,  299 },
  { 135, 11, 1083 }, {   7,  0,  602 }, {   8,  0,  179 }, {  10,  0,  781 },
  { 140,  0,  126 }, {   6,  0,  329 }, { 138,  0,  111 }, { 135,  0, 1864 },
  {   4, 11,  219 }, {   7, 11, 1761 }, { 137, 11,   86 }, {   6,  0, 1888 },
  {   6,  0, 1892 }, {   6,  0, 1901 }, {   6,  0, 1904 }, {   9,  0,  953 },
  {   9,  0,  985 }, {   9,  0,  991 }, {   9,  0, 1001 }, {  12,  0,  818 },
  {  12,  0,  846 }, {  12,  0,  847 }, {  12,  0,  861 }, {  12,  0,  862 },
  {  12,  0,  873 }, {  12,  0,  875 }, {  12,  0,  877 }, {  12,  0,  879 },
  {  12,  0,  881 }, {  12,  0,  884 }, {  12,  0,  903 }, {  12,  0,  915 },
  {  12,  0,  926 }, {  12,  0,  939 }, {  15,  0,  182 }, {  15,  0,  219 },
  {  15,  0,  255 }, {  18,  0,  191 }, {  18,  0,  209 }, {  18,  0,  211 },
  { 149,  0,   41 }, {   5, 11,  328 }, { 135, 11,  918 }, { 137,  0,  780 },
  {  12,  0,   82 }, { 143,  0,   36 }, { 133, 10, 1010 }, {   5,  0,  821 },
  { 134,  0, 1687 }, { 133, 11,  514 }, { 132,  0,  956 }, { 134,  0, 1180 },
  {  10,  0,  112 }, {   5, 10,   87 }, {   7, 10,  313 }, {   7, 10, 1103 },
  {  10, 10,  582 }, {  11, 10,  389 }, {  11, 10,  813 }, {  12, 10,  385 },
  {  13, 10,  286 }, {  14, 10,  124 }, { 146, 10,  108 }, {   5,  0,   71 },
  {   7,  0, 1407 }, {   9,  0,  704 }, {  10,  0,  261 }, {  10,  0,  619 },
  {  11,  0,  547 }, {  11,  0,  619 }, { 143,  0,  157 }, {   4,  0,  531 },
  {   5,  0,  455 }, {   5, 11,  301 }, {   6, 11,  571 }, {  14, 11,   49 },
  { 146, 11,  102 }, { 132, 10,  267 }, {   6,  0,  385 }, {   7,  0, 2008 },
  {   9,  0,  337 }, { 138,  0,  517 }, { 133, 11,  726 }, { 133, 11,  364 },
  {   4, 11,   76 }, {   7, 11, 1550 }, {   9, 11,  306 }, {   9, 11,  430 },
  {   9, 11,  663 }, {  10, 11,  683 }, {  11, 11,  427 }, {  11, 11,  753 },
  {  12, 11,  334 }, {  12, 11,  442 }, {  14, 11,  258 }, {  14, 11,  366 },
  { 143, 11,  131 }, {   6,  0, 1865 }, {   6,  0, 1879 }, {   6,  0, 1881 },
  {   6,  0, 1894 }, {   6,  0, 1908 }, {   9,  0,  915 }, {   9,  0,  926 },
  {   9,  0,  940 }, {   9,  0,  943 }, {   9,  0,  966 }, {   9,  0,  980 },
  {   9,  0,  989 }, {   9,  0, 1005 }, {   9,  0, 1010 }, {  12,  0,  813 },
  {  12,  0,  817 }, {  12,  0,  840 }, {  12,  0,  843 }, {  12,  0,  855 },
  {  12,  0,  864 }, {  12,  0,  871 }, {  12,  0,  872 }, {  12,  0,  899 },
  {  12,  0,  905 }, {  12,  0,  924 }, {  15,  0,  171 }, {  15,  0,  181 },
  {  15,  0,  224 }, {  15,  0,  235 }, {  15,  0,  251 }, { 146,  0,  184 },
  { 137, 11,   52 }, {   5,  0,   16 }, {   6,  0,   86 }, {   6,  0,  603 },
  {   7,  0,  292 }, {   7,  0,  561 }, {   8,  0,  257 }, {   8,  0,  382 },
  {   9,  0,  721 }, {   9,  0,  778 }, {  11,  0,  581 }, { 140,  0,  466 },
  {   4,  0,  486 }, {   5,  0,  491 }, { 135, 10, 1121 }, {   4,  0,   72 },
  {   6,  0,  265 }, { 135,  0, 1300 }, { 135, 11, 1183 }, {  10, 10,  249 },
  { 139, 10,  209 }, { 132, 10,  561 }, { 137, 11,  519 }, {   4, 11,  656 },
  {   4, 10,  760 }, { 135, 11,  779 }, {   9, 10,  154 }, { 140, 10,  485 },
  { 135, 11, 1793 }, { 135, 11,  144 }, { 136, 10,  255 }, { 133,  0,  621 },
  {   4, 10,  368 }, { 135, 10,  641 }, { 135, 11, 1373 }, {   7, 11,  554 },
  {   7, 11,  605 }, { 141, 11,   10 }, { 137,  0,  234 }, {   5,  0,  815 },
  {   6,  0, 1688 }, { 134,  0, 1755 }, {   5, 11,  838 }, {   5, 11,  841 },
  { 134, 11, 1649 }, {   7,  0, 1987 }, {   7,  0, 2040 }, { 136,  0,  743 },
  { 133, 11, 1012 }, {   6,  0,  197 }, { 136,  0,  205 }, {   6,  0,  314 },
  { 134, 11,  314 }, { 144, 11,   53 }, {   6, 11,  251 }, {   7, 11,  365 },
  {   7, 11, 1357 }, {   7, 11, 1497 }, {   8, 11,  154 }, { 141, 11,  281 },
  { 133, 11,  340 }, {   6,  0,  452 }, {   7,  0,  312 }, { 138,  0,  219 },
  { 138,  0,  589 }, {   4,  0,  333 }, {   9,  0,  176 }, {  12,  0,  353 },
  { 141,  0,  187 }, {   9, 10,   92 }, { 147, 10,   91 }, { 134,  0, 1110 },
  {  11,  0,   47 }, { 139, 11,  495 }, {   6, 10,  525 }, {   8, 10,  806 },
  {   9, 10,  876 }, { 140, 10,  284 }, {   8, 11,  261 }, {   9, 11,  144 },
  {   9, 11,  466 }, {  10, 11,  370 }, {  12, 11,  470 }, {  13, 11,  144 },
  { 142, 11,  348 }, { 137, 11,  897 }, {   8,  0,  863 }, {   8,  0,  864 },
  {   8,  0,  868 }, {   8,  0,  884 }, {  10,  0,  866 }, {  10,  0,  868 },
  {  10,  0,  873 }, {  10,  0,  911 }, {  10,  0,  912 }, {  10,  0,  944 },
  {  12,  0,  727 }, {   6, 11,  248 }, {   9, 11,  546 }, {  10, 11,  535 },
  {  11, 11,  681 }, { 141, 11,  135 }, {   6,  0,  300 }, { 135,  0, 1515 },
  { 134,  0, 1237 }, { 139, 10,  958 }, { 133, 10,  594 }, { 140, 11,  250 },
  { 134,  0, 1685 }, { 134, 11,  567 }, {   7,  0,  135 }, {   8,  0,    7 },
  {   8,  0,   62 }, {   9,  0,  243 }, {  10,  0,  658 }, {  10,  0,  697 },
  {  11,  0,  456 }, { 139,  0,  756 }, {   9,  0,  395 }, { 138,  0,   79 },
  {   6, 10, 1641 }, { 136, 10,  820 }, {   4, 10,  302 }, { 135, 10, 1766 },
  { 134, 11,  174 }, { 135, 10, 1313 }, { 135,  0,  631 }, { 134, 10, 1674 },
  { 134, 11,  395 }, { 138,  0,  835 }, {   7,  0,  406 }, {   7,  0,  459 },
  {   8,  0,  606 }, { 139,  0,  726 }, { 134, 11,  617 }, { 134,  0,  979 },
  {   6, 10,  389 }, {   7, 10,  149 }, {   9, 10,  142 }, { 138, 10,   94 },
  {   5, 11,  878 }, { 133, 11,  972 }, {   6, 10,    8 }, {   7, 10, 1881 },
  {   8, 10,   91 }, { 136, 11,  511 }, { 133,  0,  612 }, { 132, 11,  351 },
  {   4,  0,  372 }, {   7,  0,  482 }, {   8,  0,  158 }, {   9,  0,  602 },
  {   9,  0,  615 }, {  10,  0,  245 }, {  10,  0,  678 }, {  10,  0,  744 },
  {  11,  0,  248 }, { 139,  0,  806 }, {   5,  0,  854 }, { 135,  0, 1991 },
  { 132, 11,  286 }, { 135, 11,  344 }, {   7, 11,  438 }, {   7, 11,  627 },
  {   7, 11, 1516 }, {   8, 11,   40 }, {   9, 11,   56 }, {   9, 11,  294 },
  {  10, 11,   30 }, {  10, 11,  259 }, {  11, 11,  969 }, { 146, 11,  148 },
  { 135,  0, 1492 }, {   5, 11,  259 }, {   7, 11,  414 }, {   7, 11,  854 },
  { 142, 11,  107 }, { 135, 10, 1746 }, {   6,  0,  833 }, { 134,  0,  998 },
  { 135, 10,   24 }, {   6,  0,  750 }, { 135,  0, 1739 }, {   4, 10,  503 },
  { 135, 10, 1661 }, {   5, 10,  130 }, {   7, 10, 1314 }, {   9, 10,  610 },
  {  10, 10,  718 }, {  11, 10,  601 }, {  11, 10,  819 }, {  11, 10,  946 },
  { 140, 10,  536 }, {  10, 10,  149 }, {  11, 10,  280 }, { 142, 10,  336 },
  { 132, 11,  738 }, { 135, 10, 1946 }, {   5,  0,  195 }, { 135,  0, 1685 },
  {   7,  0, 1997 }, {   8,  0,  730 }, { 139,  0, 1006 }, { 151, 11,   17 },
  { 133, 11,  866 }, {  14,  0,  463 }, {  14,  0,  470 }, { 150,  0,   61 },
  {   5,  0,  751 }, {   8,  0,  266 }, {  11,  0,  578 }, {   4, 10,  392 },
  { 135, 10, 1597 }, {   5, 10,  433 }, {   9, 10,  633 }, { 139, 10,  629 },
  { 135,  0,  821 }, {   6,  0,  715 }, { 134,  0, 1325 }, { 133, 11,  116 },
  {   6,  0,  868 }, { 132, 11,  457 }, { 134,  0,  959 }, {   6, 10,  234 },
  { 138, 11,  199 }, {   7,  0, 1053 }, {   7, 10, 1950 }, {   8, 10,  680 },
  {  11, 10,  817 }, { 147, 10,   88 }, {   7, 10, 1222 }, { 138, 10,  386 },
  {   5,  0,  950 }, {   5,  0,  994 }, {   6,  0,  351 }, { 134,  0, 1124 },
  { 134,  0, 1081 }, {   7,  0, 1595 }, {   6, 10,    5 }, {  11, 10,  249 },
  {  12, 10,  313 }, {  16, 10,   66 }, { 145, 10,   26 }, { 148,  0,   59 },
  {   5, 11,  527 }, {   6, 11,  189 }, { 135, 11,  859 }, {   5, 10,  963 },
  {   6, 10, 1773 }, {  11, 11,  104 }, {  11, 11,  554 }, {  15, 11,   60 },
  { 143, 11,  125 }, { 135,  0,   47 }, { 137,  0,  684 }, { 134, 11,  116 },
  { 134,  0, 1606 }, { 134,  0,  777 }, {   7,  0, 1020 }, {   8, 10,  509 },
  { 136, 10,  792 }, { 135,  0, 1094 }, { 132,  0,  350 }, { 133, 11,  487 },
  {   4, 11,   86 }, {   5, 11,  667 }, {   5, 11,  753 }, {   6, 11,  316 },
  {   6, 11,  455 }, { 135, 11,  946 }, {   7,  0, 1812 }, {  13,  0,  259 },
  {  13,  0,  356 }, {  14,  0,  242 }, { 147,  0,  114 }, { 132, 10,  931 },
  { 133,  0,  967 }, {   4,  0,  473 }, {   7,  0,  623 }, {   8,  0,  808 },
  {   9,  0,  871 }, {   9,  0,  893 }, {  11,  0,   38 }, {  11,  0,  431 },
  {  12,  0,  112 }, {  12,  0,  217 }, {  12,  0,  243 }, {  12,  0,  562 },
  {  12,  0,  663 }, {  12,  0,  683 }, {  13,  0,  141 }, {  13,  0,  197 },
  {  13,  0,  227 }, {  13,  0,  406 }, {  13,  0,  487 }, {  14,  0,  156 },
  {  14,  0,  203 }, {  14,  0,  224 }, {  14,  0,  256 }, {  18,  0,   58 },
  { 150,  0,    0 }, { 138,  0,  286 }, {   7, 10,  943 }, { 139, 10,  614 },
  { 135, 10, 1837 }, { 150, 11,   45 }, { 132,  0,  798 }, {   4,  0,  222 },
  {   7,  0,  286 }, { 136,  0,  629 }, {   4, 11,   79 }, {   7, 11, 1773 },
  {  10, 11,  450 }, {  11, 11,  589 }, {  13, 11,  332 }, {  13, 11,  493 },
  {  14, 11,  183 }, {  14, 11,  334 }, {  14, 11,  362 }, {  14, 11,  368 },
  {  14, 11,  376 }, {  14, 11,  379 }, {  19, 11,   90 }, {  19, 11,  103 },
  {  19, 11,  127 }, { 148, 11,   90 }, {   5,  0,  337 }, {  11,  0,  513 },
  {  11,  0,  889 }, {  11,  0,  961 }, {  12,  0,  461 }, {  13,  0,   79 },
  {  15,  0,  121 }, {   4, 10,   90 }, {   5, 10,  545 }, {   7, 10,  754 },
  {   9, 10,  186 }, {  10, 10,   72 }, {  10, 10,  782 }, {  11, 10,  577 },
  {  11, 10,  610 }, {  12, 10,  354 }, {  12, 10,  362 }, { 140, 10,  595 },
  { 141,  0,  306 }, { 136,  0,  146 }, {   7,  0, 1646 }, {   9, 10,  329 },
  {  11, 10,  254 }, { 141, 11,  124 }, {   4,  0,  465 }, { 135,  0, 1663 },
  { 132,  0,  525 }, { 133, 11,  663 }, {  10,  0,  299 }, {  18,  0,   74 },
  {   9, 10,  187 }, {  11, 10, 1016 }, { 145, 10,   44 }, {   7,  0,  165 },
  {   7,  0,  919 }, {   4, 10,  506 }, { 136, 10,  517 }, {   5, 10,  295 },
  { 135, 10, 1680 }, { 133, 11,  846 }, { 134,  0, 1064 }, {   5, 11,  378 },
  {   7, 11, 1402 }, {   7, 11, 1414 }, {   8, 11,  465 }, {   9, 11,  286 },
  {  10, 11,  185 }, {  10, 11,  562 }, {  10, 11,  635 }, {  11, 11,   31 },
  {  11, 11,  393 }, {  12, 11,  456 }, {  13, 11,  312 }, {  18, 11,   65 },
  {  18, 11,   96 }, { 147, 11,   89 }, { 132,  0,  596 }, {   7, 10,  987 },
  {   9, 10,  688 }, {  10, 10,  522 }, {  11, 10,  788 }, { 140, 10,  566 },
  {   6,  0,   82 }, {   7,  0,  138 }, {   7,  0,  517 }, {   7,  0, 1741 },
  {  11,  0,  238 }, {   4, 11,  648 }, { 134, 10, 1775 }, {   7,  0, 1233 },
  {   7, 10,  700 }, {   7, 10,  940 }, {   8, 10,  514 }, {   9, 10,  116 },
  {   9, 10,  535 }, {  10, 10,  118 }, {  11, 10,  107 }, {  11, 10,  148 },
  {  11, 10,  922 }, {  12, 10,  254 }, {  12, 10,  421 }, { 142, 10,  238 },
  {   4,  0,  962 }, {   6,  0, 1824 }, {   8,  0,  894 }, {  12,  0,  708 },
  {  12,  0,  725 }, {  14,  0,  451 }, {  20,  0,   94 }, {  22,  0,   59 },
  { 150,  0,   62 }, {   5, 11,  945 }, {   6, 11, 1656 }, {   6, 11, 1787 },
  {   7, 11,  167 }, {   8, 11,  824 }, {   9, 11,  391 }, {  10, 11,  375 },
  { 139, 11,  185 }, {   5,  0,  495 }, {   7,  0,  834 }, {   9,  0,  733 },
  { 139,  0,  378 }, {   4, 10,  743 }, { 135, 11, 1273 }, {   6,  0, 1204 },
  {   7, 11, 1645 }, {   8, 11,  352 }, { 137, 11,  249 }, { 139, 10,  292 },
  { 133,  0,  559 }, { 132, 11,  152 }, {   9,  0,  499 }, {  10,  0,  341 },
  {  15,  0,  144 }, {  19,  0,   49 }, {   7, 10, 1283 }, {   9, 10,  227 },
  {  11, 10,  325 }, {  11, 10,  408 }, {  14, 10,  180 }, { 146, 10,   47 },
  {   6,  0,   21 }, {   6,  0, 1737 }, {   7,  0, 1444 }, { 136,  0,  224 },
  { 133, 11, 1006 }, {   7,  0, 1446 }, {   9,  0,   97 }, {  17,  0,   15 },
  {   5, 10,   81 }, {   7, 10,  146 }, {   7, 10, 1342 }, {   8, 10,   53 },
  {   8, 10,  561 }, {   8, 10,  694 }, {   8, 10,  754 }, {   9, 10,  115 },
  {   9, 10,  894 }, {  10, 10,  462 }, {  10, 10,  813 }, {  11, 10,  230 },
  {  11, 10,  657 }, {  11, 10,  699 }, {  11, 10,  748 }, {  12, 10,  119 },
  {  12, 10,  200 }, {  12, 10,  283 }, { 142, 10,  273 }, {   5, 10,  408 },
  { 137, 10,  747 }, { 135, 11,  431 }, { 135, 11,  832 }, {   6,  0,  729 },
  { 134,  0,  953 }, {   4,  0,  727 }, {   8,  0,  565 }, {   5, 11,  351 },
  {   7, 11,  264 }, { 136, 11,  565 }, { 134,  0, 1948 }, {   5,  0,  519 },
  {   5, 11,   40 }, {   7, 11,  598 }, {   7, 11, 1638 }, {   8, 11,   78 },
  {   9, 11,  166 }, {   9, 11,  640 }, {   9, 11,  685 }, {   9, 11,  773 },
  {  11, 11,  215 }, {  13, 11,   65 }, {  14, 11,  172 }, {  14, 11,  317 },
  { 145, 11,    6 }, {   8, 11,   60 }, {   9, 11,  343 }, { 139, 11,  769 },
  { 137, 11,  455 }, { 134,  0, 1193 }, { 140,  0,  790 }, {   7, 11, 1951 },
  {   8, 11,  765 }, {   8, 11,  772 }, { 140, 11,  671 }, {   7, 11,  108 },
  {   8, 11,  219 }, {   8, 11,  388 }, {   9, 11,  639 }, {   9, 11,  775 },
  {  11, 11,  275 }, { 140, 11,  464 }, { 132, 11,  468 }, {   7, 10,   30 },
  {   8, 10,   86 }, {   8, 10,  315 }, {   8, 10,  700 }, {   9, 10,  576 },
  {   9, 10,  858 }, {  11, 10,  310 }, {  11, 10,  888 }, {  11, 10,  904 },
  {  12, 10,  361 }, { 141, 10,  248 }, {   5, 11,   15 }, {   6, 11,   56 },
  {   7, 11, 1758 }, {   8, 11,  500 }, {   9, 11,  730 }, {  11, 11,  331 },
  {  13, 11,  150 }, { 142, 11,  282 }, {   4,  0,  402 }, {   7,  0,    2 },
  {   8,  0,  323 }, { 136,  0,  479 }, { 138, 10,  839 }, {  11,  0,  580 },
  { 142,  0,  201 }, {   5,  0,   59 }, { 135,  0,  672 }, { 137, 10,  617 },
  { 146,  0,   34 }, { 134, 11, 1886 }, {   4,  0,  961 }, { 136,  0,  896 },
  {   6,  0, 1285 }, {   5, 11,  205 }, {   6, 11,  438 }, { 137, 11,  711 },
  { 134, 10,  428 }, {   7, 10,  524 }, {   8, 10,  169 }, {   8, 10,  234 },
  {   9, 10,  480 }, { 138, 10,  646 }, { 148,  0,   46 }, { 141,  0,  479 },
  { 133, 11,  534 }, {   6,  0, 2019 }, { 134, 10, 1648 }, {   4,  0,   85 },
  {   7,  0,  549 }, {   7, 10, 1205 }, { 138, 10,  637 }, {   4,  0,  663 },
  {   5,  0,   94 }, {   7, 11,  235 }, {   7, 11, 1475 }, {  15, 11,   68 },
  { 146, 11,  120 }, {   6, 11,  443 }, {   9, 11,  237 }, {   9, 11,  571 },
  {   9, 11,  695 }, {  10, 11,  139 }, {  11, 11,  715 }, {  12, 11,  417 },
  { 141, 11,  421 }, { 132,  0,  783 }, {   4,  0,  682 }, {   8,  0,   65 },
  {   9, 10,   39 }, {  10, 10,  166 }, {  11, 10,  918 }, {  12, 10,  635 },
  {  20, 10,   10 }, {  22, 10,   27 }, {  22, 10,   43 }, { 150, 10,   52 },
  {   6,  0,   11 }, { 135,  0,  187 }, { 132,  0,  522 }, {   4,  0,   52 },
  { 135,  0,  661 }, {   4,  0,  383 }, { 133,  0,  520 }, { 135, 11,  546 },
  {  11,  0,  343 }, { 142,  0,  127 }, {   4, 11,  578 }, {   7, 10,  157 },
  {   7, 11,  624 }, {   7, 11,  916 }, {   8, 10,  279 }, {  10, 11,  256 },
  {  11, 11,   87 }, { 139, 11,  703 }, { 134, 10,  604 }, {   4,  0,  281 },
  {   5,  0,   38 }, {   7,  0,  194 }, {   7,  0,  668 }, {   7,  0, 1893 },
  { 137,  0,  397 }, {   7, 10,  945 }, {  11, 10,  713 }, { 139, 10,  744 },
  { 139, 10, 1022 }, {   9,  0,  635 }, { 139,  0,  559 }, {   5, 11,  923 },
  {   7, 11,  490 }, {  12, 11,  553 }, {  13, 11,  100 }, {  14, 11,  118 },
  { 143, 11,   75 }, { 132,  0,  975 }, { 132, 10,  567 }, { 137, 10,  859 },
  {   7, 10, 1846 }, {   7, 11, 1846 }, {   8, 10,  628 }, { 136, 11,  628 },
  { 148,  0,  116 }, { 138, 11,  750 }, {  14,  0,   51 }, {  14, 11,   51 },
  {  15, 11,    7 }, { 148, 11,   20 }, { 132,  0,  858 }, { 134,  0, 1075 },
  {   4, 11,  924 }, { 133, 10,  762 }, { 136,  0,  535 }, { 133,  0,  448 },
  {  10, 10,  784 }, { 141, 10,  191 }, { 133, 10,  298 }, {   7,  0,  610 },
  { 135,  0, 1501 }, {   7, 10,  633 }, {   7, 10,  905 }, {   7, 10,  909 },
  {   7, 10, 1538 }, {   9, 10,  767 }, { 140, 10,  636 }, {   4, 11,  265 },
  {   7, 11,  807 }, { 135, 11,  950 }, {   5, 11,   93 }, {  12, 11,  267 },
  { 144, 11,   26 }, { 136,  0,  191 }, { 139, 10,  301 }, { 135, 10, 1970 },
  { 135,  0,  267 }, {   4,  0,  319 }, {   5,  0,  699 }, { 138,  0,  673 },
  {   6,  0,  336 }, {   7,  0,   92 }, {   7,  0,  182 }, {   8,  0,  453 },
  {   8,  0,  552 }, {   9,  0,  204 }, {   9,  0,  285 }, {  10,  0,   99 },
  {  11,  0,  568 }, {  11,  0,  950 }, {  12,  0,   94 }, {  16,  0,   20 },
  {  16,  0,   70 }, {  19,  0,   55 }, {  12, 10,  644 }, { 144, 10,   90 },
  {   6,  0,  551 }, {   7,  0, 1308 }, {   7, 10,  845 }, {   7, 11,  994 },
  {   8, 10,  160 }, { 137, 10,  318 }, {  19, 11,    1 }, {  19, 11,   26 },
  { 150, 11,    9 }, {   7,  0, 1406 }, {   9,  0,  218 }, { 141,  0,  222 },
  {   5,  0,  256 }, { 138,  0,   69 }, {   5, 11,  233 }, {   5, 11,  320 },
  {   6, 11,  140 }, {   7, 11,  330 }, { 136, 11,  295 }, {   6,  0, 1980 },
  { 136,  0,  952 }, {   4,  0,  833 }, { 137, 11,  678 }, { 133, 11,  978 },
  {   4, 11,  905 }, {   6, 11, 1701 }, { 137, 11,  843 }, { 138, 10,  735 },
  { 136, 10,   76 }, {  17,  0,   39 }, { 148,  0,   36 }, {  18,  0,   81 },
  { 146, 11,   81 }, {  14,  0,  352 }, {  17,  0,   53 }, {  18,  0,  146 },
  {  18,  0,  152 }, {  19,  0,   11 }, { 150,  0,   54 }, { 135,  0,  634 },
  { 138, 10,  841 }, { 132,  0,  618 }, {   4,  0,  339 }, {   7,  0,  259 },
  {  17,  0,   73 }, {   4, 11,  275 }, { 140, 11,  376 }, { 132, 11,  509 },
  {   7, 11,  273 }, { 139, 11,  377 }, {   4,  0,  759 }, {  13,  0,  169 },
  { 137, 10,  804 }, {   6, 10,   96 }, { 135, 10, 1426 }, {   4, 10,  651 },
  { 133, 10,  289 }, {   7,  0, 1075 }, {   8, 10,   35 }, {   9, 10,  511 },
  {  10, 10,  767 }, { 147, 10,  118 }, {   6,  0,  649 }, {   6,  0,  670 },
  { 136,  0,  482 }, {   5,  0,  336 }, {   6,  0,  341 }, {   6,  0,  478 },
  {   6,  0, 1763 }, { 136,  0,  386 }, {   5, 11,  802 }, {   7, 11, 2021 },
  {   8, 11,  805 }, {  14, 11,   94 }, {  15, 11,   65 }, {  16, 11,    4 },
  {  16, 11,   77 }, {  16, 11,   80 }, { 145, 11,    5 }, {   6,  0, 1035 },
  {   5, 11,  167 }, {   5, 11,  899 }, {   6, 11,  410 }, { 137, 11,  777 },
  { 134, 11, 1705 }, {   5,  0,  924 }, { 133,  0,  969 }, { 132, 10,  704 },
  { 135,  0,   73 }, { 135, 11,   10 }, { 135, 10, 1078 }, {   5, 11,   11 },
  {   6, 11,  117 }, {   6, 11,  485 }, {   7, 11, 1133 }, {   9, 11,  582 },
  {   9, 11,  594 }, {  11, 11,   21 }, {  11, 11,  818 }, {  12, 11,  535 },
  { 141, 11,   86 }, { 135,  0, 1971 }, {   4, 11,  264 }, {   7, 11, 1067 },
  {   8, 11,  204 }, {   8, 11,  385 }, { 139, 11,  953 }, {   6,  0, 1458 },
  { 135,  0, 1344 }, {   5,  0,  396 }, { 134,  0,  501 }, {   4, 10,  720 },
  { 133, 10,  306 }, {   4,  0,  929 }, {   5,  0,  799 }, {   8,  0,   46 },
  {   8,  0,  740 }, { 133, 10,  431 }, {   7, 11,  646 }, {   7, 11, 1730 },
  {  11, 11,  446 }, { 141, 11,  178 }, {   7,  0,  276 }, {   5, 10,  464 },
  {   6, 10,  236 }, {   7, 10,  696 }, {   7, 10,  914 }, {   7, 10, 1108 },
  {   7, 10, 1448 }, {   9, 10,   15 }, {   9, 10,  564 }, {  10, 10,   14 },
  {  12, 10,  565 }, {  13, 10,  449 }, {  14, 10,   53 }, {  15, 10,   13 },
  {  16, 10,   64 }, { 145, 10,   41 }, {   4,  0,  892 }, { 133,  0,  770 },
  {   6, 10, 1767 }, {  12, 10,  194 }, { 145, 10,  107 }, { 135,  0,  158 },
  {   5, 10,  840 }, { 138, 11,  608 }, { 134,  0, 1432 }, { 138, 11,  250 },
  {   8, 11,  794 }, {   9, 11,  400 }, {  10, 11,  298 }, { 142, 11,  228 },
  { 151,  0,   25 }, {   7, 11, 1131 }, { 135, 11, 1468 }, { 135,  0, 2001 },
  {   9, 10,  642 }, {  11, 10,  236 }, { 142, 10,  193 }, {   4, 10,   68 },
  {   5, 10,  634 }, {   6, 10,  386 }, {   7, 10,  794 }, {   8, 10,  273 },
  {   9, 10,  563 }, {  10, 10,  105 }, {  10, 10,  171 }, {  11, 10,   94 },
  { 139, 10,  354 }, { 136, 11,  724 }, { 132,  0,  478 }, {  11, 11,  512 },
  {  13, 11,  205 }, {  19, 11,   30 }, {  22, 11,   36 }, { 151, 11,   19 },
  {   7,  0, 1461 }, { 140,  0,   91 }, {   6, 11,  190 }, {   7, 11,  768 },
  { 135, 11, 1170 }, {   4,  0,  602 }, {   8,  0,  211 }, {   4, 10,   95 },
  {   7, 10,  416 }, { 139, 10,  830 }, {   7, 10,  731 }, {  13, 10,   20 },
  { 143, 10,   11 }, {   6,  0, 1068 }, { 135,  0, 1872 }, {   4,  0,   13 },
  {   5,  0,  567 }, {   7,  0, 1498 }, {   9,  0,  124 }, {  11,  0,  521 },
  {  12,  0,  405 }, { 135, 11, 1023 }, { 135,  0, 1006 }, { 132,  0,  735 },
  { 138,  0,  812 }, {   4,  0,  170 }, { 135,  0,  323 }, {   6, 11,  137 },
  {   9, 11,   75 }, {   9, 11,  253 }, {  10, 11,  194 }, { 138, 11,  444 },
  {   5,  0,  304 }, {   7,  0, 1403 }, {   5, 10,  864 }, {  10, 10,  648 },
  {  11, 10,  671 }, { 143, 10,   46 }, { 135, 11, 1180 }, { 133, 10,  928 },
  {   4,  0,  148 }, { 133,  0,  742 }, {  11, 10,  986 }, { 140, 10,  682 },
  { 133,  0,  523 }, { 135, 11, 1743 }, {   7,  0,  730 }, {  18,  0,  144 },
  {  19,  0,   61 }, {   8, 10,   44 }, {   9, 10,  884 }, {  10, 10,  580 },
  {  11, 10,  399 }, {  11, 10,  894 }, { 143, 10,  122 }, {   5, 11,  760 },
  {   7, 11,  542 }, {   8, 11,  135 }, { 136, 11,  496 }, { 136,  0,  981 },
  { 133,  0,  111 }, {  10,  0,  132 }, {  11,  0,  191 }, {  11,  0,  358 },
  { 139,  0,  460 }, {   7, 11,  319 }, {   7, 11,  355 }, {   7, 11,  763 },
  {  10, 11,  389 }, { 145, 11,   43 }, { 134,  0,  890 }, { 134,  0, 1420 },
  { 136, 11,  557 }, { 133, 10,  518 }, { 133,  0,  444 }, { 135,  0, 1787 },
  { 135, 10, 1852 }, {   8,  0,  123 }, {  15,  0,    6 }, { 144,  0,    7 },
  {   6,  0, 2041 }, {  10, 11,   38 }, { 139, 11,  784 }, { 136,  0,  932 },
  {   5,  0,  937 }, { 135,  0,  100 }, {   6,  0,  995 }, {   4, 11,   58 },
  {   5, 11,  286 }, {   6, 11,  319 }, {   7, 11,  402 }, {   7, 11, 1254 },
  {   7, 11, 1903 }, {   8, 11,  356 }, { 140, 11,  408 }, {   4, 11,  389 },
  {   9, 11,  181 }, {   9, 11,  255 }, {  10, 11,    8 }, {  10, 11,   29 },
  {  10, 11,  816 }, {  11, 11,  311 }, {  11, 11,  561 }, {  12, 11,   67 },
  { 141, 11,  181 }, { 138,  0,  255 }, {   5,  0,  138 }, {   4, 10,  934 },
  { 136, 10,  610 }, {   4,  0,  965 }, {  10,  0,  863 }, { 138,  0,  898 },
  {  10, 10,  804 }, { 138, 10,  832 }, {  12,  0,  631 }, {   8, 10,   96 },
  {   9, 10,   36 }, {  10, 10,  607 }, {  11, 10,  423 }, {  11, 10,  442 },
  {  12, 10,  309 }, {  14, 10,  199 }, {  15, 10,   90 }, { 145, 10,  110 },
  { 134,  0, 1394 }, {   4,  0,  652 }, {   8,  0,  320 }, {  22,  0,    6 },
  {  22,  0,   16 }, {   9, 10,   13 }, {   9, 10,  398 }, {   9, 10,  727 },
  {  10, 10,   75 }, {  10, 10,  184 }, {  10, 10,  230 }, {  10, 10,  564 },
  {  10, 10,  569 }, {  11, 10,  973 }, {  12, 10,   70 }, {  12, 10,  189 },
  {  13, 10,   57 }, { 141, 10,  257 }, {   6,  0,  897 }, { 134,  0, 1333 },
  {   4,  0,  692 }, { 133,  0,  321 }, { 133, 11,  373 }, { 135,  0,  922 },
  {   5,  0,  619 }, { 133,  0,  698 }, { 137, 10,  631 }, {   5, 10,  345 },
  { 135, 10, 1016 }, {   9,  0,  957 }, {   9,  0, 1018 }, {  12,  0,  828 },
  {  12,  0,  844 }, {  12,  0,  897 }, {  12,  0,  901 }, {  12,  0,  943 },
  {  15,  0,  180 }, {  18,  0,  197 }, {  18,  0,  200 }, {  18,  0,  213 },
  {  18,  0,  214 }, { 146,  0,  226 }, {   5,  0,  917 }, { 134,  0, 1659 },
  { 135,  0, 1100 }, { 134,  0, 1173 }, { 134,  0, 1930 }, {   5,  0,  251 },
  {   5,  0,  956 }, {   8,  0,  268 }, {   9,  0,  214 }, { 146,  0,  142 },
  { 133, 10,  673 }, { 137, 10,  850 }, {   4, 10,  287 }, { 133, 10, 1018 },
  { 132, 11,  672 }, {   5,  0,  346 }, {   5,  0,  711 }, {   8,  0,  390 },
  {  11, 11,  752 }, { 139, 11,  885 }, {   5, 10,   34 }, {  10, 10,  724 },
  {  12, 10,  444 }, {  13, 10,  354 }, {  18, 10,   32 }, {  23, 10,   24 },
  {  23, 10,   31 }, { 152, 10,    5 }, {   4, 11,  710 }, { 134, 11,  606 },
  { 134,  0,  744 }, { 134, 10,  382 }, { 133, 11,  145 }, {   4, 10,  329 },
  {   7, 11,  884 }, { 140, 11,  124 }, {   4, 11,  467 }, {   5, 11,  405 },
  { 134, 11,  544 }, {   9, 10,  846 }, { 138, 10,  827 }, { 133,  0,  624 },
  {   9, 11,  372 }, {  15, 11,    2 }, {  19, 11,   10 }, { 147, 11,   18 },
  {   4, 11,  387 }, { 135, 11, 1288 }, {   5,  0,  783 }, {   7,  0, 1998 },
  { 135,  0, 2047 }, { 132, 10,  906 }, { 136, 10,  366 }, { 135, 11,  550 },
  {   4, 10,  123 }, {   4, 10,  649 }, {   5, 10,  605 }, {   7, 10, 1509 },
  { 136, 10,   36 }, { 134,  0, 1125 }, { 132,  0,  594 }, { 133, 10,  767 },
  { 135, 11, 1227 }, { 136, 11,  467 }, {   4, 11,  576 }, { 135, 11, 1263 },
  {   4,  0,  268 }, {   7,  0, 1534 }, { 135, 11, 1534 }, {   4, 10,  273 },
  {   5, 10,  658 }, {   5, 11,  919 }, {   5, 10,  995 }, { 134, 11, 1673 },
  { 133,  0,  563 }, { 134, 10,   72 }, { 135, 10, 1345 }, {   4, 11,   82 },
  {   5, 11,  333 }, {   5, 11,  904 }, {   6, 11,  207 }, {   7, 11,  325 },
  {   7, 11, 1726 }, {   8, 11,  101 }, {  10, 11,  778 }, { 139, 11,  220 },
  {   5,  0,   37 }, {   6,  0,   39 }, {   6,  0,  451 }, {   7,  0,  218 },
  {   7,  0,  667 }, {   7,  0, 1166 }, {   7,  0, 1687 }, {   8,  0,  662 },
  {  16,  0,    2 }, { 133, 10,  589 }, { 134,  0, 1332 }, { 133, 11,  903 },
  { 134,  0,  508 }, {   5, 10,  117 }, {   6, 10,  514 }, {   6, 10,  541 },
  {   7, 10, 1164 }, {   7, 10, 1436 }, {   8, 10,  220 }, {   8, 10,  648 },
  {  10, 10,  688 }, {  11, 10,  560 }, { 140, 11,  147 }, {   6, 11,  555 },
  { 135, 11,  485 }, { 133, 10,  686 }, {   7,  0,  453 }, {   7,  0,  635 },
  {   7,  0,  796 }, {   8,  0,  331 }, {   9,  0,  330 }, {   9,  0,  865 },
  {  10,  0,  119 }, {  10,  0,  235 }, {  11,  0,  111 }, {  11,  0,  129 },
  {  11,  0,  240 }, {  12,  0,   31 }, {  12,  0,   66 }, {  12,  0,  222 },
  {  12,  0,  269 }, {  12,  0,  599 }, {  12,  0,  684 }, {  12,  0,  689 },
  {  12,  0,  691 }, { 142,  0,  345 }, { 135,  0, 1834 }, {   4, 11,  705 },
  {   7, 11,  615 }, { 138, 11,  251 }, { 136, 11,  345 }, { 137,  0,  527 },
  {   6,  0,   98 }, {   7,  0,  702 }, { 135,  0,  991 }, {  11,  0,  576 },
  {  14,  0,   74 }, {   7, 10,  196 }, {  10, 10,  765 }, {  11, 10,  347 },
  {  11, 10,  552 }, {  11, 10,  790 }, {  12, 10,  263 }, {  13, 10,  246 },
  {  13, 10,  270 }, {  13, 10,  395 }, {  14, 10,  176 }, {  14, 10,  190 },
  {  14, 10,  398 }, {  14, 10,  412 }, {  15, 10,   32 }, {  15, 10,   63 },
  {  16, 10,   88 }, { 147, 10,  105 }, { 134, 11,   90 }, {  13,  0,   84 },
  { 141,  0,  122 }, {   6,  0,   37 }, {   7,  0,  299 }, {   7,  0, 1666 },
  {   8,  0,  195 }, {   8,  0,  316 }, {   9,  0,  178 }, {   9,  0,  276 },
  {   9,  0,  339 }, {   9,  0,  536 }, {  10,  0,  102 }, {  10,  0,  362 },
  {  10,  0,  785 }, {  11,  0,   55 }, {  11,  0,  149 }, {  11,  0,  773 },
  {  13,  0,  416 }, {  13,  0,  419 }, {  14,  0,   38 }, {  14,  0,   41 },
  { 142,  0,  210 }, {   5, 10,  381 }, { 135, 10, 1792 }, {   7, 11,  813 },
  {  12, 11,  497 }, { 141, 11,   56 }, {   7, 10,  616 }, { 138, 10,  413 },
  { 133,  0,  645 }, {   6, 11,  125 }, { 135, 11, 1277 }, { 132,  0,  290 },
  {   6,  0,   70 }, {   7,  0, 1292 }, {  10,  0,  762 }, { 139,  0,  288 },
  {   6, 10,  120 }, {   7, 10, 1188 }, {   7, 10, 1710 }, {   8, 10,  286 },
  {   9, 10,  667 }, {  11, 10,  592 }, { 139, 10,  730 }, { 135, 11, 1784 },
  {   7,  0, 1315 }, { 135, 11, 1315 }, { 134,  0, 1955 }, { 135, 10, 1146 },
  {   7,  0,  131 }, {   7,  0,  422 }, {   8,  0,  210 }, { 140,  0,  573 },
  {   4, 10,  352 }, { 135, 10,  687 }, { 139,  0,  797 }, { 143,  0,   38 },
  {  14,  0,  179 }, {  15,  0,  151 }, { 150,  0,   11 }, {   7,  0,  488 },
  {   4, 10,  192 }, {   5, 10,   49 }, {   6, 10,  200 }, {   6, 10,  293 },
  { 134, 10, 1696 }, { 132,  0,  936 }, { 135, 11,  703 }, {   6, 11,  160 },
  {   7, 11, 1106 }, {   9, 11,  770 }, {  10, 11,  618 }, {  11, 11,  112 },
  { 140, 11,  413 }, {   5,  0,  453 }, { 134,  0,  441 }, { 135,  0,  595 },
  { 132, 10,  650 }, { 132, 10,  147 }, {   6,  0,  991 }, {   6,  0, 1182 },
  {  12, 11,  271 }, { 145, 11,  109 }, { 133, 10,  934 }, { 140, 11,  221 },
  { 132,  0,  653 }, {   7,  0,  505 }, { 135,  0,  523 }, { 134,  0,  903 },
  { 135, 11,  479 }, {   7, 11,  304 }, {   9, 11,  646 }, {   9, 11,  862 },
  {  10, 11,  262 }, {  11, 11,  696 }, {  12, 11,  208 }, {  15, 11,   79 },
  { 147, 11,  108 }, { 146,  0,   80 }, { 135, 11,  981 }, { 142,  0,  432 },
  { 132,  0,  314 }, { 137, 11,  152 }, {   7,  0, 1368 }, {   8,  0,  232 },
  {   8,  0,  361 }, {  10,  0,  682 }, { 138,  0,  742 }, { 135, 11, 1586 },
  {   9,  0,  534 }, {   4, 11,  434 }, {  11, 11,  663 }, {  12, 11,  210 },
  {  13, 11,  166 }, {  13, 11,  310 }, {  14, 11,  373 }, { 147, 11,   43 },
  {   7, 11, 1091 }, { 135, 11, 1765 }, {   6, 11,  550 }, { 135, 11,  652 },
  { 137,  0,   27 }, { 142,  0,   12 }, {   4, 10,  637 }, {   5, 11,  553 },
  {   7, 11,  766 }, { 138, 11,  824 }, {   7, 11,  737 }, {   8, 11,  298 },
  { 136, 11,  452 }, {   7,  0,  736 }, { 139,  0,  264 }, { 134,  0, 1657 },
  { 133, 11,  292 }, { 138, 11,  135 }, {   6,  0,  844 }, { 134,  0, 1117 },
  { 135,  0,  127 }, {   9, 10,  867 }, { 138, 10,  837 }, {   6,  0, 1184 },
  { 134,  0, 1208 }, { 134,  0, 1294 }, { 136,  0,  364 }, {   6,  0, 1415 },
  {   7,  0, 1334 }, {  11,  0,  125 }, {   6, 10,  170 }, {   7, 11,  393 },
  {   8, 10,  395 }, {   8, 10,  487 }, {  10, 11,  603 }, {  11, 11,  206 },
  { 141, 10,  147 }, { 137, 11,  748 }, {   4, 11,  912 }, { 137, 11,  232 },
  {   4, 10,  535 }, { 136, 10,  618 }, { 137,  0,  792 }, {   7, 11, 1973 },
  { 136, 11,  716 }, { 135, 11,   98 }, {   5,  0,  909 }, {   9,  0,  849 },
  { 138,  0,  805 }, {   4,  0,  630 }, { 132,  0,  699 }, {   5, 11,  733 },
  {  14, 11,  103 }, { 150, 10,   23 }, {  12, 11,  158 }, {  18, 11,    8 },
  {  19, 11,   62 }, {  20, 11,    6 }, {  22, 11,    4 }, {  23, 11,    2 },
  { 151, 11,    9 }, { 132,  0,  968 }, { 132, 10,  778 }, { 132, 10,   46 },
  {   5, 10,  811 }, {   6, 10, 1679 }, {   6, 10, 1714 }, { 135, 10, 2032 },
  {   6,  0, 1446 }, {   7, 10, 1458 }, {   9, 10,  407 }, { 139, 10,   15 },
  {   7,  0,  206 }, {   7,  0,  397 }, {   7,  0,  621 }, {   7,  0,  640 },
  {   8,  0,  124 }, {   8,  0,  619 }, {   9,  0,  305 }, {   9,  0,  643 },
  {  10,  0,  264 }, {  10,  0,  628 }, {  11,  0,   40 }, {  12,  0,  349 },
  {  13,  0,  134 }, {  13,  0,  295 }, {  14,  0,  155 }, {  15,  0,  120 },
  {  18,  0,  105 }, {   6, 10,   34 }, {   7, 10, 1089 }, {   8, 10,  708 },
  {   8, 10,  721 }, {   9, 10,  363 }, { 148, 10,   98 }, {   4,  0,  262 },
  {   5,  0,  641 }, { 135,  0,  342 }, { 137, 11,   72 }, {   4,  0,   99 },
  {   6,  0,  250 }, {   6,  0,  346 }, {   8,  0,  127 }, { 138,  0,   81 },
  { 132,  0,  915 }, {   5,  0,   75 }, {   9,  0,  517 }, {  10,  0,  470 },
  {  12,  0,  155 }, { 141,  0,  224 }, { 132, 10,  462 }, {  11, 11,  600 },
  {  11, 11,  670 }, { 141, 11,  245 }, { 142,  0,   83 }, {   5, 10,   73 },
  {   6, 10,   23 }, { 134, 10,  338 }, {   6,  0, 1031 }, { 139, 11,  923 },
  {   7, 11,  164 }, {   7, 11, 1571 }, {   9, 11,  107 }, { 140, 11,  225 },
  { 134,  0, 1470 }, { 133,  0,  954 }, {   6,  0,  304 }, {   8,  0,  418 },
  {  10,  0,  345 }, {  11,  0,  341 }, { 139,  0,  675 }, {   9,  0,  410 },
  { 139,  0,  425 }, {   4, 11,   27 }, {   5, 11,  484 }, {   5, 11,  510 },
  {   6, 11,  434 }, {   7, 11, 1000 }, {   7, 11, 1098 }, {   8, 11,    2 },
  { 136, 11,  200 }, { 134,  0,  734 }, { 140, 11,  257 }, {   7, 10,  725 },
  {   8, 10,  498 }, { 139, 10,  268 }, { 134,  0, 1822 }, { 135,  0, 1798 },
  { 135, 10,  773 }, { 132, 11,  460 }, {   4, 11,  932 }, { 133, 11,  891 },
  { 134,  0,   14 }, { 132, 10,  583 }, {   7, 10, 1462 }, {   8, 11,  625 },
  { 139, 10,  659 }, {   5,  0,  113 }, {   6,  0,  243 }, {   6,  0, 1708 },
  {   7,  0, 1865 }, {  11,  0,  161 }, {  16,  0,   37 }, {  17,  0,   99 },
  { 133, 10,  220 }, { 134, 11,   76 }, {   5, 11,  461 }, { 135, 11, 1925 },
  { 140,  0,   69 }, {   8, 11,   92 }, { 137, 11,  221 }, { 139, 10,  803 },
  { 132, 10,  544 }, {   4,  0,  274 }, { 134,  0,  922 }, { 132,  0,  541 },
  {   5,  0,  627 }, {   6, 10,  437 }, {   6, 10,  564 }, {  11, 10,  181 },
  { 141, 10,  183 }, { 135, 10, 1192 }, {   7,  0,  166 }, { 132, 11,  763 },
  { 133, 11,  253 }, { 134,  0,  849 }, {   9, 11,   73 }, {  10, 11,  110 },
  {  14, 11,  185 }, { 145, 11,  119 }, {   5, 11,  212 }, {  12, 11,   35 },
  { 141, 11,  382 }, { 133,  0,  717 }, { 137,  0,  304 }, { 136,  0,  600 },
  { 133,  0,  654 }, {   6,  0,  273 }, {  10,  0,  188 }, {  13,  0,  377 },
  { 146,  0,   77 }, {   4, 10,  790 }, {   5, 10,  273 }, { 134, 10,  394 },
  { 132,  0,  543 }, { 135,  0,  410 }, {  11,  0,   98 }, {  11,  0,  524 },
  { 141,  0,   87 }, { 132,  0,  941 }, { 135, 11, 1175 }, {   4,  0,  250 },
  {   7,  0, 1612 }, {  11,  0,  186 }, {  12,  0,  133 }, {   6, 10,  127 },
  {   7, 10, 1511 }, {   8, 10,  613 }, {  12, 10,  495 }, {  12, 10,  586 },
  {  12, 10,  660 }, {  12, 10,  668 }, {  14, 10,  385 }, {  15, 10,  118 },
  {  17, 10,   20 }, { 146, 10,   98 }, {   6,  0, 1785 }, { 133, 11,  816 },
  { 134,  0, 1339 }, {   7,  0,  961 }, {   7,  0, 1085 }, {   7,  0, 1727 },
  {   8,  0,  462 }, {   6, 10,  230 }, { 135, 11, 1727 }, {   9,  0,  636 },
  { 135, 10, 1954 }, { 132,  0,  780 }, {   5, 11,  869 }, {   5, 11,  968 },
  {   6, 11, 1626 }, {   8, 11,  734 }, { 136, 11,  784 }, {   4, 11,  542 },
  {   6, 11, 1716 }, {   6, 11, 1727 }, {   7, 11, 1082 }, {   7, 11, 1545 },
  {   8, 11,   56 }, {   8, 11,  118 }, {   8, 11,  412 }, {   8, 11,  564 },
  {   9, 11,  888 }, {   9, 11,  908 }, {  10, 11,   50 }, {  10, 11,  423 },
  {  11, 11,  685 }, {  11, 11,  697 }, {  11, 11,  933 }, {  12, 11,  299 },
  {  13, 11,  126 }, {  13, 11,  136 }, {  13, 11,  170 }, { 141, 11,  190 },
  { 134, 11,  226 }, {   4, 11,  232 }, {   9, 11,  202 }, {  10, 11,  474 },
  { 140, 11,  433 }, { 137, 11,  500 }, {   5,  0,  529 }, { 136, 10,   68 },
  { 132, 10,  654 }, {   4, 10,  156 }, {   7, 10,  998 }, {   7, 10, 1045 },
  {   7, 10, 1860 }, {   9, 10,   48 }, {   9, 10,  692 }, {  11, 10,  419 },
  { 139, 10,  602 }, {   7,  0, 1276 }, {   8,  0,  474 }, {   9,  0,  652 },
  {   6, 11,  108 }, {   7, 11, 1003 }, {   7, 11, 1181 }, { 136, 11,  343 },
  {   7, 11, 1264 }, {   7, 11, 1678 }, {  11, 11,  945 }, {  12, 11,  341 },
  {  12, 11,  471 }, { 140, 11,  569 }, { 134, 11, 1712 }, {   5,  0,  948 },
  {  12,  0,  468 }, {  19,  0,   96 }, { 148,  0,   24 }, {   4, 11,  133 },
  {   7, 11,  711 }, {   7, 11, 1298 }, {   7, 11, 1585 }, { 135, 11, 1929 },
  {   6,  0,  753 }, { 140,  0,  657 }, { 139,  0,  941 }, {   6, 11,   99 },
  {   7, 11, 1808 }, { 145, 11,   57 }, {   6, 11,  574 }, {   7, 11,  428 },
  {   7, 11, 1250 }, {  10, 11,  669 }, {  11, 11,  485 }, {  11, 11,  840 },
  {  12, 11,  300 }, { 142, 11,  250 }, {   4,  0,  532 }, {   5,  0,  706 },
  { 135,  0,  662 }, {   5,  0,  837 }, {   6,  0, 1651 }, { 139,  0,  985 },
  {   7,  0, 1861 }, {   9, 10,  197 }, {  10, 10,  300 }, {  12, 10,  473 },
  {  13, 10,   90 }, { 141, 10,  405 }, { 137, 11,  252 }, {   6, 11,  323 },
  { 135, 11, 1564 }, {   4,  0,  330 }, {   4,  0,  863 }, {   7,  0,  933 },
  {   7,  0, 2012 }, {   8,  0,  292 }, {   7, 11,  461 }, {   8, 11,  775 },
  { 138, 11,  435 }, { 132, 10,  606 }, {   4, 11,  655 }, {   7, 11,  850 },
  {  17, 11,   75 }, { 146, 11,  137 }, { 135,  0,  767 }, {   7, 10, 1978 },
  { 136, 10,  676 }, { 132,  0,  641 }, { 135, 11, 1559 }, { 134,  0, 1233 },
  { 137,  0,  242 }, {  17,  0,  114 }, {   4, 10,  361 }, { 133, 10,  315 },
  { 137,  0,  883 }, { 132, 10,  461 }, { 138,  0,  274 }, { 134,  0, 2008 },
  { 134,  0, 1794 }, {   4,  0,  703 }, { 135,  0,  207 }, {  12,  0,  285 },
  { 132, 10,  472 }, { 132,  0,  571 }, {   5,  0,  873 }, {   5,  0,  960 },
  {   8,  0,  823 }, {   9,  0,  881 }, { 136, 11,  577 }, {   7,  0,  617 },
  {  10,  0,  498 }, {  11,  0,  501 }, {  12,  0,   16 }, { 140,  0,  150 },
  { 138, 10,  747 }, { 132,  0,  431 }, { 133, 10,  155 }, {  11,  0,  283 },
  {  11,  0,  567 }, {   7, 10,  163 }, {   8, 10,  319 }, {   9, 10,  402 },
  {  10, 10,   24 }, {  10, 10,  681 }, {  11, 10,  200 }, {  12, 10,  253 },
  {  12, 10,  410 }, { 142, 10,  219 }, {   4, 11,  413 }, {   5, 11,  677 },
  {   8, 11,  432 }, { 140, 11,  280 }, {   9,  0,  401 }, {   5, 10,  475 },
  {   7, 10, 1780 }, {  11, 10,  297 }, {  11, 10,  558 }, {  14, 10,  322 },
  { 147, 10,   76 }, {   6,  0,  781 }, {   9,  0,  134 }, {  10,  0,    2 },
  {  10,  0,   27 }, {  10,  0,  333 }, {  11,  0,  722 }, { 143,  0,    1 },
  {   5,  0,   33 }, {   6,  0,  470 }, { 139,  0,  424 }, { 135,  0, 2006 },
  {  12,  0,  783 }, { 135, 10, 1956 }, { 136,  0,  274 }, { 135,  0, 1882 },
  { 132,  0,  794 }, { 135,  0, 1848 }, {   5, 10,  944 }, { 134, 10, 1769 },
  {   6,  0,   47 }, {   7,  0,   90 }, {   7,  0,  664 }, {   7,  0,  830 },
  {   7,  0, 1380 }, {   7,  0, 2025 }, {   8,  0,  448 }, { 136,  0,  828 },
  { 132, 10,  144 }, { 134,  0, 1199 }, {   4, 11,  395 }, { 139, 11,  762 },
  { 135, 11, 1504 }, {   9,  0,  417 }, { 137,  0,  493 }, {   9, 11,  174 },
  {  10, 11,  164 }, {  11, 11,  440 }, {  11, 11,  841 }, { 143, 11,   98 },
  { 134, 11,  426 }, { 139, 11, 1002 }, { 134,  0,  295 }, { 134,  0,  816 },
  {   6, 10,  247 }, { 137, 10,  555 }, { 133,  0, 1019 }, {   4,  0,  620 },
  {   5, 11,  476 }, {  10, 10,  280 }, { 138, 10,  797 }, { 139,  0,  464 },
  {   5, 11,   76 }, {   6, 11,  458 }, {   6, 11,  497 }, {   7, 11,  764 },
  {   7, 11,  868 }, {   9, 11,  658 }, {  10, 11,  594 }, {  11, 11,  173 },
  {  11, 11,  566 }, {  12, 11,   20 }, {  12, 11,  338 }, { 141, 11,  200 },
  { 134,  0,  208 }, {   4, 11,  526 }, {   7, 11, 1029 }, { 135, 11, 1054 },
  { 132, 11,  636 }, {   6, 11,  233 }, {   7, 11,  660 }, {   7, 11, 1124 },
  {  17, 11,   31 }, {  19, 11,   22 }, { 151, 11,   14 }, {  10,  0,  442 },
  { 133, 10,  428 }, {  10,  0,  930 }, { 140,  0,  778 }, {   6,  0,   68 },
  {   7,  0,  448 }, {   7,  0, 1629 }, {   7,  0, 1769 }, {   7,  0, 1813 },
  {   8,  0,  442 }, {   8,  0,  516 }, {   9,  0,  710 }, {  10,  0,  282 },
  {  10,  0,  722 }, {   7, 10, 1717 }, { 138, 10,  546 }, { 134,  0, 1128 },
  {  11,  0,  844 }, {  12,  0,  104 }, { 140,  0,  625 }, {   4, 11,  432 },
  { 135, 11,  824 }, { 138, 10,  189 }, { 133,  0,  787 }, { 133, 10,   99 },
  {   4, 11,  279 }, {   7, 11,  301 }, { 137, 11,  362 }, {   8,  0,  491 },
  {   4, 10,  397 }, { 136, 10,  555 }, {   4, 11,  178 }, { 133, 11,  399 },
  { 134,  0,  711 }, { 144,  0,    9 }, {   4,  0,  403 }, {   5,  0,  441 },
  {   7,  0,  450 }, {  10,  0,  840 }, {  11,  0,  101 }, {  12,  0,  193 },
  { 141,  0,  430 }, { 135, 11, 1246 }, {  12, 10,  398 }, {  20, 10,   39 },
  {  21, 10,   11 }, { 150, 10,   41 }, {   4, 10,  485 }, {   7, 10,  353 },
  { 135, 10, 1523 }, {   6, 10,  366 }, {   7, 10, 1384 }, {   7, 10, 1601 },
  { 135, 11, 1912 }, {   7,  0,  396 }, {  10,  0,  160 }, { 135, 11,  396 },
  { 137, 10,  282 }, { 134, 11, 1692 }, {   4, 10,  157 }, {   5, 10,  471 },
  {   6, 11,  202 }, {  10, 11,  448 }, {  11, 11,  208 }, {  12, 11,  360 },
  {  17, 11,  117 }, {  17, 11,  118 }, {  18, 11,   27 }, { 148, 11,   67 },
  { 133,  0,  679 }, { 137,  0,  326 }, { 136, 10,  116 }, {   7, 11,  872 },
  {  10, 11,  516 }, { 139, 11,  167 }, { 132, 11,  224 }, {   5, 11,  546 },
  {   7, 11,   35 }, {   8, 11,   11 }, {   8, 11,   12 }, {   9, 11,  315 },
  {   9, 11,  533 }, {  10, 11,  802 }, {  11, 11,  166 }, {  12, 11,  525 },
  { 142, 11,  243 }, {   7,  0, 1128 }, { 135, 11, 1920 }, {   5, 11,  241 },
  {   8, 11,  242 }, {   9, 11,  451 }, {  10, 11,  667 }, {  11, 11,  598 },
  { 140, 11,  429 }, {   6,  0,  737 }, {   5, 10,  160 }, {   7, 10,  363 },
  {   7, 10,  589 }, {  10, 10,  170 }, { 141, 10,   55 }, { 135,  0, 1796 },
  { 142, 11,  254 }, {   4,  0,  574 }, {   7,  0,  350 }, {   7,  0, 1024 },
  {   8,  0,  338 }, {   9,  0,  677 }, { 138,  0,  808 }, { 134,  0, 1096 },
  { 137, 11,  516 }, {   7,  0,  405 }, {  10,  0,  491 }, {   4, 10,  108 },
  {   4, 11,  366 }, { 139, 10,  498 }, {  11, 11,  337 }, { 142, 11,  303 },
  { 134, 11, 1736 }, {   7,  0, 1081 }, { 140, 11,  364 }, {   7, 10, 1005 },
  { 140, 10,  609 }, {   7,  0, 1676 }, {   4, 10,  895 }, { 133, 10,  772 },
  { 135,  0, 2037 }, {   6,  0, 1207 }, {  11, 11,  916 }, { 142, 11,  419 },
  {  14, 11,  140 }, { 148, 11,   41 }, {   6, 11,  331 }, { 136, 11,  623 },
  {   9,  0,  944 }, {   9,  0,  969 }, {   9,  0, 1022 }, {  12,  0,  913 },
  {  12,  0,  936 }, {  15,  0,  177 }, {  15,  0,  193 }, {   4, 10,  926 },
  { 133, 10,  983 }, {   5,  0,  354 }, { 135, 11,  506 }, {   8,  0,  598 },
  {   9,  0,  664 }, { 138,  0,  441 }, {   4, 11,  640 }, { 133, 11,  513 },
  { 137,  0,  297 }, { 132, 10,  538 }, {   6, 10,  294 }, {   7, 10, 1267 },
  { 136, 10,  624 }, {   7,  0, 1772 }, {   7, 11, 1888 }, {   8, 11,  289 },
  {  11, 11,   45 }, {  12, 11,  278 }, { 140, 11,  537 }, { 135, 10, 1325 },
  { 138,  0,  751 }, { 141,  0,   37 }, { 134,  0, 1828 }, { 132, 10,  757 },
  { 132, 11,  394 }, {   6,  0,  257 }, { 135,  0, 1522 }, {   4,  0,  582 },
  {   9,  0,  191 }, { 135, 11, 1931 }, {   7, 11,  574 }, {   7, 11, 1719 },
  { 137, 11,  145 }, { 132, 11,  658 }, {  10,  0,  790 }, { 132, 11,  369 },
  {   9, 11,  781 }, {  10, 11,  144 }, {  11, 11,  385 }, {  13, 11,  161 },
  {  13, 11,  228 }, {  13, 11,  268 }, { 148, 11,  107 }, {   8,  0,  469 },
  {  10,  0,   47 }, { 136, 11,  374 }, {   6,  0,  306 }, {   7,  0, 1140 },
  {   7,  0, 1340 }, {   8,  0,  133 }, { 138,  0,  449 }, { 139,  0, 1011 },
  {   7, 10, 1875 }, { 139, 10,  124 }, {   4, 11,  344 }, {   6, 11,  498 },
  { 139, 11,  323 }, { 137,  0,  299 }, { 132,  0,  837 }, { 133, 11,  906 },
  {   5,  0,  329 }, {   8,  0,  260 }, { 138,  0,   10 }, { 134,  0, 1320 },
  {   4,  0,  657 }, { 146,  0,  158 }, { 135,  0, 1191 }, { 152,  0,    7 },
  {   6,  0, 1939 }, {   8,  0,  974 }, { 138,  0,  996 }, { 135,  0, 1665 },
  {  11, 11,  126 }, { 139, 11,  287 }, { 143,  0,    8 }, {  14, 11,  149 },
  {  14, 11,  399 }, { 143, 11,   57 }, {   5,  0,   66 }, {   7,  0, 1896 },
  { 136,  0,  288 }, {   7,  0,  175 }, {  10,  0,  494 }, {   5, 10,  150 },
  {   8, 10,  603 }, {   9, 10,  593 }, {   9, 10,  634 }, {  10, 10,  173 },
  {  11, 10,  462 }, {  11, 10,  515 }, {  13, 10,  216 }, {  13, 10,  288 },
  { 142, 10,  400 }, { 134,  0, 1643 }, { 136, 11,   21 }, {   4,  0,   21 },
  {   5,  0,   91 }, {   5,  0,  648 }, {   5,  0,  750 }, {   5,  0,  781 },
  {   6,  0,   54 }, {   6,  0,  112 }, {   6,  0,  402 }, {   6,  0, 1732 },
  {   7,  0,  315 }, {   7,  0,  749 }, {   7,  0, 1427 }, {   7,  0, 1900 },
  {   9,  0,   78 }, {   9,  0,  508 }, {  10,  0,  611 }, {  10,  0,  811 },
  {  11,  0,  510 }, {  11,  0,  728 }, {  13,  0,   36 }, {  14,  0,   39 },
  {  16,  0,   83 }, {  17,  0,  124 }, { 148,  0,   30 }, {   4,  0,  668 },
  { 136,  0,  570 }, {  10,  0,  322 }, {  10,  0,  719 }, { 139,  0,  407 },
  { 135, 11, 1381 }, { 136, 11,  193 }, {  12, 10,  108 }, { 141, 10,  291 },
  { 132, 11,  616 }, { 136, 11,  692 }, {   8,  0,  125 }, {   8,  0,  369 },
  {   8,  0,  524 }, {  10,  0,  486 }, {  11,  0,   13 }, {  11,  0,  381 },
  {  11,  0,  736 }, {  11,  0,  766 }, {  11,  0,  845 }, {  13,  0,  114 },
  {  13,  0,  292 }, { 142,  0,   47 }, { 134,  0, 1247 }, {   6,  0, 1684 },
  {   6,  0, 1731 }, {   7,  0,  356 }, {   8,  0,   54 }, {   8,  0,  221 },
  {   9,  0,  225 }, {   9,  0,  356 }, {  10,  0,   77 }, {  10,  0,  446 },
  {  10,  0,  731 }, {  12,  0,  404 }, { 141,  0,  491 }, { 135, 10, 1777 },
  {   4, 11,  305 }, {   4, 10,  493 }, { 144, 10,   55 }, {   4,  0,  951 },
  {   6,  0, 1809 }, {   6,  0, 1849 }, {   8,  0,  846 }, {   8,  0,  866 },
  {   8,  0,  899 }, {  10,  0,  896 }, {  12,  0,  694 }, { 142,  0,  468 },
  {   5, 11,  214 }, {   7, 11,  603 }, {   8, 11,  611 }, {   9, 11,  686 },
  {  10, 11,   88 }, {  11, 11,  459 }, {  11, 11,  496 }, {  12, 11,  463 },
  {  12, 11,  590 }, {  13, 11,    0 }, { 142, 11,  214 }, { 132,  0,  411 },
  {   4,  0,   80 }, { 133,  0,   44 }, { 140, 11,   74 }, { 143,  0,   31 },
  {   7,  0,  669 }, {   6, 10,  568 }, {   7, 10, 1804 }, {   8, 10,  362 },
  {   8, 10,  410 }, {   8, 10,  830 }, {   9, 10,  514 }, {  11, 10,  649 },
  { 142, 10,  157 }, {   7,  0,  673 }, { 134, 11, 1703 }, { 132, 10,  625 },
  { 134,  0, 1303 }, {   5,  0,  299 }, { 135,  0, 1083 }, { 138,  0,  704 },
  {   6,  0,  275 }, {   7,  0,  408 }, {   6, 10,  158 }, {   7, 10,  129 },
  {   7, 10,  181 }, {   8, 10,  276 }, {   8, 10,  377 }, {  10, 10,  523 },
  {  11, 10,  816 }, {  12, 10,  455 }, {  13, 10,  303 }, { 142, 10,  135 },
  {   4,  0,  219 }, {   7,  0,  367 }, {   7,  0, 1713 }, {   7,  0, 1761 },
  {   9,  0,   86 }, {   9,  0,  537 }, {  10,  0,  165 }, {  12,  0,  219 },
  { 140,  0,  561 }, {   8,  0,  216 }, {   4, 10,    1 }, {   4, 11,  737 },
  {   6, 11,  317 }, {   7, 10, 1143 }, {   7, 10, 1463 }, {   9, 10,  207 },
  {   9, 10,  390 }, {   9, 10,  467 }, {  10, 11,   98 }, {  11, 11,  294 },
  {  11, 10,  836 }, {  12, 11,   60 }, {  12, 11,  437 }, {  13, 11,   64 },
  {  13, 11,  380 }, { 142, 11,  430 }, {   6, 11, 1758 }, {   8, 11,  520 },
  {   9, 11,  345 }, {   9, 11,  403 }, { 142, 11,  350 }, {   5, 11,   47 },
  {  10, 11,  242 }, { 138, 11,  579 }, {   5, 11,  139 }, {   7, 11, 1168 },
  { 138, 11,  539 }, { 135,  0, 1319 }, {   4, 10,  295 }, {   4, 10,  723 },
  {   5, 10,  895 }, {   7, 10, 1031 }, {   8, 10,  199 }, {   8, 10,  340 },
  {   9, 10,  153 }, {   9, 10,  215 }, {  10, 10,   21 }, {  10, 10,   59 },
  {  10, 10,   80 }, {  10, 10,  224 }, {  10, 10,  838 }, {  11, 10,  229 },
  {  11, 10,  652 }, {  12, 10,  192 }, {  13, 10,  146 }, { 142, 10,   91 },
  { 140,  0,  428 }, { 137, 10,   51 }, { 133,  0,  514 }, {   5, 10,  309 },
  { 140, 10,  211 }, {   6,  0, 1010 }, {   5, 10,  125 }, {   8, 10,   77 },
  { 138, 10,   15 }, {   4,  0,   55 }, {   5,  0,  301 }, {   6,  0,  571 },
  { 142,  0,   49 }, { 146,  0,  102 }, { 136, 11,  370 }, {   4, 11,  107 },
  {   7, 11,  613 }, {   8, 11,  358 }, {   8, 11,  439 }, {   8, 11,  504 },
  {   9, 11,  501 }, {  10, 11,  383 }, { 139, 11,  477 }, { 132, 11,  229 },
  { 133,  0,  364 }, { 133, 10,  439 }, {   4, 11,  903 }, { 135, 11, 1816 },
  {  11,  0,  379 }, { 140, 10,   76 }, {   4,  0,   76 }, {   4,  0,  971 },
  {   7,  0, 1550 }, {   9,  0,  306 }, {   9,  0,  430 }, {   9,  0,  663 },
  {  10,  0,  683 }, {  10,  0,  921 }, {  11,  0,  427 }, {  11,  0,  753 },
  {  12,  0,  334 }, {  12,  0,  442 }, {  14,  0,  258 }, {  14,  0,  366 },
  { 143,  0,  131 }, { 137,  0,   52 }, {   4, 11,   47 }, {   6, 11,  373 },
  {   7, 11,  452 }, {   7, 11,  543 }, {   7, 11, 1714 }, {   7, 11, 1856 },
  {   9, 11,    6 }, {  11, 11,  257 }, { 139, 11,  391 }, {   4, 10,    8 },
  {   7, 10, 1152 }, {   7, 10, 1153 }, {   7, 10, 1715 }, {   9, 10,  374 },
  {  10, 10,  478 }, { 139, 10,  648 }, {   4, 11,  785 }, { 133, 11,  368 },
  { 135, 10, 1099 }, { 135, 11,  860 }, {   5, 11,  980 }, { 134, 11, 1754 },
  { 134,  0, 1258 }, {   6,  0, 1058 }, {   6,  0, 1359 }, {   7, 11,  536 },
  {   7, 11, 1331 }, { 136, 11,  143 }, {   4,  0,  656 }, { 135,  0,  779 },
  { 136, 10,   87 }, {   5, 11,   19 }, {   6, 11,  533 }, { 146, 11,  126 },
  {   7,  0,  144 }, { 138, 10,  438 }, {   5, 11,  395 }, {   5, 11,  951 },
  { 134, 11, 1776 }, { 135,  0, 1373 }, {   7,  0,  554 }, {   7,  0,  605 },
  { 141,  0,   10 }, {   4, 10,   69 }, {   5, 10,  122 }, {   9, 10,  656 },
  { 138, 10,  464 }, {   5, 10,  849 }, { 134, 10, 1633 }, {   5,  0,  838 },
  {   5,  0,  841 }, { 134,  0, 1649 }, { 133,  0, 1012 }, { 139, 10,  499 },
  {   7, 10,  476 }, {   7, 10, 1592 }, { 138, 10,   87 }, {   6,  0,  251 },
  {   7,  0,  365 }, {   7,  0, 1357 }, {   7,  0, 1497 }, {   8,  0,  154 },
  { 141,  0,  281 }, { 132, 11,  441 }, { 132, 11,  695 }, {   7, 11,  497 },
  {   9, 11,  387 }, { 147, 11,   81 }, { 133,  0,  340 }, {  14, 10,  283 },
  { 142, 11,  283 }, { 134,  0,  810 }, { 135, 11, 1894 }, { 139,  0,  495 },
  {   5, 11,  284 }, {   6, 11,   49 }, {   6, 11,  350 }, {   7, 11,    1 },
  {   7, 11,  377 }, {   7, 11, 1693 }, {   8, 11,   18 }, {   8, 11,  678 },
  {   9, 11,  161 }, {   9, 11,  585 }, {   9, 11,  671 }, {   9, 11,  839 },
  {  11, 11,  912 }, { 141, 11,  427 }, {   5, 10,  859 }, {   7, 10, 1160 },
  {   8, 10,  107 }, {   9, 10,  291 }, {   9, 10,  439 }, {  10, 10,  663 },
  {  11, 10,  609 }, { 140, 10,  197 }, {   8,  0,  261 }, {   9,  0,  144 },
  {   9,  0,  466 }, {  10,  0,  370 }, {  12,  0,  470 }, {  13,  0,  144 },
  { 142,  0,  348 }, { 137,  0,  897 }, {   6,  0,  248 }, {   9,  0,  546 },
  {  10,  0,  535 }, {  11,  0,  681 }, { 141,  0,  135 }, {   4,  0,  358 },
  { 135,  0, 1496 }, { 134,  0,  567 }, { 136,  0,  445 }, {   4, 10,  117 },
  {   6, 10,  372 }, {   7, 10, 1905 }, { 142, 10,  323 }, {   4, 10,  722 },
  { 139, 10,  471 }, {   6,  0,  697 }, { 134,  0,  996 }, {   7, 11, 2007 },
  {   9, 11,  101 }, {   9, 11,  450 }, {  10, 11,   66 }, {  10, 11,  842 },
  {  11, 11,  536 }, { 140, 11,  587 }, { 132,  0,  577 }, { 134,  0, 1336 },
  {   9, 10,    5 }, {  12, 10,  216 }, {  12, 10,  294 }, {  12, 10,  298 },
  {  12, 10,  400 }, {  12, 10,  518 }, {  13, 10,  229 }, { 143, 10,  139 },
  {   6,  0,  174 }, { 138,  0,  917 }, { 134, 10, 1774 }, {   5, 10,   12 },
  {   7, 10,  375 }, {   9, 10,   88 }, {   9, 10,  438 }, {  11, 11,   62 },
  { 139, 10,  270 }, { 134, 11, 1766 }, {   6, 11,    0 }, {   7, 11,   84 },
  {   7, 10,  816 }, {   7, 10, 1241 }, {   9, 10,  283 }, {   9, 10,  520 },
  {  10, 10,  213 }, {  10, 10,  307 }, {  10, 10,  463 }, {  10, 10,  671 },
  {  10, 10,  746 }, {  11, 10,  401 }, {  11, 10,  794 }, {  11, 11,  895 },
  {  12, 10,  517 }, {  17, 11,   11 }, {  18, 10,  107 }, { 147, 10,  115 },
  {   5,  0,  878 }, { 133,  0,  972 }, {   6, 11, 1665 }, {   7, 11,  256 },
  {   7, 11, 1388 }, { 138, 11,  499 }, {   4, 10,  258 }, { 136, 10,  639 },
  {   4, 11,   22 }, {   5, 11,   10 }, {   6, 10,   22 }, {   7, 11,  848 },
  {   7, 10,  903 }, {   7, 10, 1963 }, {   8, 11,   97 }, { 138, 10,  577 },
  {   5, 10,  681 }, { 136, 10,  782 }, { 133, 11,  481 }, { 132,  0,  351 },
  {   4, 10,  664 }, {   5, 10,  804 }, { 139, 10, 1013 }, {   6, 11,  134 },
  {   7, 11,  437 }, {   7, 11,  959 }, {   9, 11,   37 }, {  14, 11,  285 },
  {  14, 11,  371 }, { 144, 11,   60 }, {   7, 11,  486 }, {   8, 11,  155 },
  {  11, 11,   93 }, { 140, 11,  164 }, { 132,  0,  286 }, {   7,  0,  438 },
  {   7,  0,  627 }, {   7,  0, 1516 }, {   8,  0,   40 }, {   9,  0,   56 },
  {   9,  0,  294 }, {  10,  0,   30 }, {  11,  0,  969 }, {  11,  0,  995 },
  { 146,  0,  148 }, {   5, 11,  591 }, { 135, 11,  337 }, { 134,  0, 1950 },
  { 133, 10,   32 }, { 138, 11,  500 }, {   5, 11,  380 }, {   5, 11,  650 },
  { 136, 11,  310 }, {   4, 11,  364 }, {   7, 11, 1156 }, {   7, 11, 1187 },
  { 137, 11,  409 }, {   4,  0,  738 }, { 134, 11,  482 }, {   4, 11,  781 },
  {   6, 11,  487 }, {   7, 11,  926 }, {   8, 11,  263 }, { 139, 11,  500 },
  { 135, 11,  418 }, {   6,  0, 2047 }, {  10,  0,  969 }, {   4, 10,  289 },
  {   7, 10,  629 }, {   7, 10, 1698 }, {   7, 10, 1711 }, { 140, 10,  215 },
  {   6, 10,  450 }, { 136, 10,  109 }, { 134,  0,  818 }, { 136, 10,  705 },
  { 133,  0,  866 }, {   4, 11,   94 }, { 135, 11, 1265 }, { 132, 11,  417 },
  { 134,  0, 1467 }, { 135, 10, 1238 }, {   4,  0,  972 }, {   6,  0, 1851 },
  { 134,  0, 1857 }, { 134,  0,  355 }, { 133,  0,  116 }, { 132,  0,  457 },
  { 135, 11, 1411 }, {   4, 11,  408 }, {   4, 11,  741 }, { 135, 11,  500 },
  { 134, 10,   26 }, { 142, 11,  137 }, {   5,  0,  527 }, {   6,  0,  189 },
  {   7,  0,  859 }, { 136,  0,  267 }, {  11,  0,  104 }, {  11,  0,  554 },
  {  15,  0,   60 }, { 143,  0,  125 }, { 134,  0, 1613 }, {   4, 10,  414 },
  {   5, 10,  467 }, {   9, 10,  654 }, {  10, 10,  451 }, {  12, 10,   59 },
  { 141, 10,  375 }, { 135, 10,   17 }, { 134,  0,  116 }, { 135, 11,  541 },
  { 135, 10,  955 }, {   6, 11,   73 }, { 135, 11,  177 }, { 133, 11,  576 },
  { 134,  0,  886 }, { 133,  0,  487 }, {   4,  0,   86 }, {   5,  0,  667 },
  {   5,  0,  753 }, {   6,  0,  316 }, {   6,  0,  455 }, { 135,  0,  946 },
  { 142, 11,  231 }, { 150,  0,   45 }, { 134,  0,  863 }, { 134,  0, 1953 },
  {   6, 10,  280 }, {  10, 10,  502 }, {  11, 10,  344 }, { 140, 10,   38 },
  {   4,  0,   79 }, {   7,  0, 1773 }, {  10,  0,  450 }, {  11,  0,  589 },
  {  13,  0,  332 }, {  13,  0,  493 }, {  14,  0,  183 }, {  14,  0,  334 },
  {  14,  0,  362 }, {  14,  0,  368 }, {  14,  0,  376 }, {  14,  0,  379 },
  {  19,  0,   90 }, {  19,  0,  103 }, {  19,  0,  127 }, { 148,  0,   90 },
  {   5, 10,   45 }, {   7, 10, 1161 }, {  11, 10,  448 }, {  11, 10,  880 },
  {  13, 10,  139 }, {  13, 10,  407 }, {  15, 10,   16 }, {  17, 10,   95 },
  {  18, 10,   66 }, {  18, 10,   88 }, {  18, 10,  123 }, { 149, 10,    7 },
  { 136, 10,  777 }, {   4, 10,  410 }, { 135, 10,  521 }, { 135, 10, 1778 },
  { 135, 11,  538 }, { 142,  0,  381 }, { 133, 11,  413 }, { 134,  0, 1142 },
  {   6,  0, 1189 }, { 136, 11,  495 }, {   5,  0,  663 }, {   6,  0, 1962 },
  { 134,  0, 2003 }, {   7, 11,   54 }, {   8, 11,  312 }, {  10, 11,  191 },
  {  10, 11,  614 }, { 140, 11,  567 }, { 132, 10,  436 }, { 133,  0,  846 },
  {  10,  0,  528 }, {  11,  0,  504 }, {   7, 10, 1587 }, { 135, 10, 1707 },
  {   5,  0,  378 }, {   8,  0,  465 }, {   9,  0,  286 }, {  10,  0,  185 },
  {  10,  0,  562 }, {  10,  0,  635 }, {  11,  0,   31 }, {  11,  0,  393 },
  {  13,  0,  312 }, {  18,  0,   65 }, {  18,  0,   96 }, { 147,  0,   89 },
  {   7,  0,  899 }, {  14,  0,  325 }, {   6, 11,  468 }, {   7, 11,  567 },
  {   7, 11, 1478 }, {   8, 11,  530 }, { 142, 11,  290 }, {   7,  0, 1880 },
  {   9,  0,  680 }, { 139,  0,  798 }, { 134,  0, 1770 }, { 132,  0,  648 },
  { 150, 11,   35 }, {   5,  0,  945 }, {   6,  0, 1656 }, {   6,  0, 1787 },
  {   7,  0,  167 }, {   8,  0,  824 }, {   9,  0,  391 }, {  10,  0,  375 },
  { 139,  0,  185 }, {   6, 11,  484 }, { 135, 11,  822 }, { 134,  0, 2046 },
  {   7,  0, 1645 }, {   8,  0,  352 }, { 137,  0,  249 }, { 132,  0,  152 },
  {   6,  0,  611 }, { 135,  0, 1733 }, {   6, 11, 1724 }, { 135, 11, 2022 },
  { 133,  0, 1006 }, { 141, 11,   96 }, {   5,  0,  420 }, { 135,  0, 1449 },
  { 146, 11,  149 }, { 135,  0,  832 }, { 135, 10,  663 }, { 133,  0,  351 },
  {   5,  0,   40 }, {   7,  0,  598 }, {   7,  0, 1638 }, {   8,  0,   78 },
  {   9,  0,  166 }, {   9,  0,  640 }, {   9,  0,  685 }, {   9,  0,  773 },
  {  11,  0,  215 }, {  13,  0,   65 }, {  14,  0,  172 }, {  14,  0,  317 },
  { 145,  0,    6 }, {   8,  0,   60 }, {   9,  0,  343 }, { 139,  0,  769 },
  { 134,  0, 1354 }, { 132,  0,  724 }, { 137,  0,  745 }, { 132, 11,  474 },
  {   7,  0, 1951 }, {   8,  0,  765 }, {   8,  0,  772 }, { 140,  0,  671 },
  {   7,  0,  108 }, {   8,  0,  219 }, {   8,  0,  388 }, {   9,  0,  775 },
  {  11,  0,  275 }, { 140,  0,  464 }, { 137,  0,  639 }, { 135, 10,  503 },
  { 133, 11,  366 }, {   5,  0,   15 }, {   6,  0,   56 }, {   7,  0, 1758 },
  {   8,  0,  500 }, {   9,  0,  730 }, {  11,  0,  331 }, {  13,  0,  150 },
  {  14,  0,  282 }, {   5, 11,  305 }, {   9, 11,  560 }, { 141, 11,  208 },
  {   4, 10,  113 }, {   5, 10,  163 }, {   5, 10,  735 }, {   7, 10, 1009 },
  {   9, 10,    9 }, {   9, 10,  771 }, {  12, 10,   90 }, {  13, 10,  138 },
  {  13, 10,  410 }, { 143, 10,  128 }, {   4, 10,  324 }, { 138, 10,  104 },
  { 135, 11,  466 }, { 142, 11,   27 }, { 134,  0, 1886 }, {   5,  0,  205 },
  {   6,  0,  438 }, {   9,  0,  711 }, {   4, 11,  480 }, {   6, 11,  167 },
  {   6, 11,  302 }, {   6, 11, 1642 }, {   7, 11,  130 }, {   7, 11,  656 },
  {   7, 11,  837 }, {   7, 11, 1547 }, {   7, 11, 1657 }, {   8, 11,  429 },
  {   9, 11,  228 }, {  10, 11,  643 }, {  13, 11,  289 }, {  13, 11,  343 },
  { 147, 11,  101 }, { 134,  0,  865 }, {   6,  0, 2025 }, { 136,  0,  965 },
  {   7, 11,  278 }, {  10, 11,  739 }, {  11, 11,  708 }, { 141, 11,  348 },
  { 133,  0,  534 }, { 135, 11, 1922 }, { 137,  0,  691 }, {   4, 10,  935 },
  { 133, 10,  823 }, {   6,  0,  443 }, {   9,  0,  237 }, {   9,  0,  571 },
  {   9,  0,  695 }, {  10,  0,  139 }, {  11,  0,  715 }, {  12,  0,  417 },
  { 141,  0,  421 }, {   5, 10,  269 }, {   7, 10,  434 }, {   7, 10,  891 },
  {   8, 10,  339 }, {   9, 10,  702 }, {  11, 10,  594 }, {  11, 10,  718 },
  { 145, 10,  100 }, {   6,  0, 1555 }, {   7,  0,  878 }, {   9, 10,  485 },
  { 141, 10,  264 }, { 134, 10, 1713 }, {   7, 10, 1810 }, {  11, 10,  866 },
  {  12, 10,  103 }, { 141, 10,  495 }, { 135, 10,  900 }, {   6,  0, 1410 },
  {   9, 11,  316 }, { 139, 11,  256 }, {   4,  0,  995 }, { 135,  0, 1033 },
  { 132,  0,  578 }, {  10,  0,  881 }, {  12,  0,  740 }, {  12,  0,  743 },
  { 140,  0,  759 }, { 132,  0,  822 }, { 133,  0,  923 }, { 142, 10,  143 },
  { 135, 11, 1696 }, {   6, 11,  363 }, {   7, 11, 1955 }, { 136, 11,  725 },
  { 132,  0,  924 }, { 133,  0,  665 }, { 135, 10, 2029 }, { 135,  0, 1901 },
  {   4,  0,  265 }, {   6,  0, 1092 }, {   6,  0, 1417 }, {   7,  0,  807 },
  { 135,  0,  950 }, {   5,  0,   93 }, {  12,  0,  267 }, { 141,  0,  498 },
  { 135,  0, 1451 }, {   5, 11,  813 }, { 135, 11, 2046 }, {   5, 10,  625 },
  { 135, 10, 1617 }, { 135,  0,  747 }, {   6,  0,  788 }, { 137,  0,  828 },
  {   7,  0,  184 }, {  11,  0,  307 }, {  11,  0,  400 }, {  15,  0,  130 },
  {   5, 11,  712 }, {   7, 11, 1855 }, {   8, 10,  425 }, {   8, 10,  693 },
  {   9, 10,  720 }, {  10, 10,  380 }, {  10, 10,  638 }, {  11, 11,   17 },
  {  11, 10,  473 }, {  12, 10,   61 }, {  13, 11,  321 }, { 144, 11,   67 },
  { 135,  0,  198 }, {   6, 11,  320 }, {   7, 11,  781 }, {   7, 11, 1921 },
  {   9, 11,   55 }, {  10, 11,  186 }, {  10, 11,  273 }, {  10, 11,  664 },
  {  10, 11,  801 }, {  11, 11,  996 }, {  11, 11,  997 }, {  13, 11,  157 },
  { 142, 11,  170 }, { 136, 11,  271 }, { 135,  0,  994 }, {   7, 11,  103 },
  {   7, 11,  863 }, {  11, 11,  184 }, {  14, 11,  299 }, { 145, 11,   62 },
  {  11, 10,  551 }, { 142, 10,  159 }, {   5,  0,  233 }, {   5,  0,  320 },
  {   6,  0,  140 }, {   8,  0,  295 }, {   8,  0,  615 }, { 136, 11,  615 },
  { 133,  0,  978 }, {   4,  0,  905 }, {   6,  0, 1701 }, { 137,  0,  843 },
  { 132, 10,  168 }, {   4,  0,  974 }, {   8,  0,  850 }, {  12,  0,  709 },
  {  12,  0,  768 }, { 140,  0,  786 }, { 135, 10,   91 }, { 152,  0,    6 },
  { 138, 10,  532 }, { 135, 10, 1884 }, { 132,  0,  509 }, {   6,  0, 1307 },
  { 135,  0,  273 }, {   5, 11,   77 }, {   7, 11, 1455 }, {  10, 11,  843 },
  {  19, 11,   73 }, { 150, 11,    5 }, { 132, 11,  458 }, { 135, 11, 1420 },
  {   6, 11,  109 }, { 138, 11,  382 }, {   6,  0,  201 }, {   6, 11,  330 },
  {   7, 10,   70 }, {   7, 11, 1084 }, {  10, 10,  240 }, {  11, 11,  142 },
  { 147, 10,   93 }, {   7,  0, 1041 }, { 140, 11,  328 }, { 133, 11,  354 },
  { 134,  0, 1040 }, { 133,  0,  693 }, { 134,  0,  774 }, { 139,  0,  234 },
  { 132,  0,  336 }, {   7,  0, 1399 }, { 139, 10,  392 }, {  20,  0,   22 },
  { 148, 11,   22 }, {   5,  0,  802 }, {   7,  0, 2021 }, { 136,  0,  805 },
  {   5,  0,  167 }, {   5,  0,  899 }, {   6,  0,  410 }, { 137,  0,  777 },
  { 137,  0,  789 }, { 134,  0, 1705 }, {   7, 10,  655 }, { 135, 10, 1844 },
  {   4, 10,  145 }, {   6, 10,  176 }, {   7, 10,  395 }, { 137, 10,  562 },
  { 132, 10,  501 }, { 135,  0,   10 }, {   5,  0,   11 }, {   6,  0,  117 },
  {   6,  0,  485 }, {   7,  0, 1133 }, {   9,  0,  582 }, {   9,  0,  594 },
  {  10,  0,   82 }, {  11,  0,   21 }, {  11,  0,  818 }, {  12,  0,  535 },
  {  13,  0,   86 }, {  20,  0,   91 }, {  23,  0,   13 }, { 134, 10,  509 },
  {   4,  0,  264 }, {   7,  0, 1067 }, {   8,  0,  204 }, {   8,  0,  385 },
  { 139,  0,  953 }, { 139, 11,  737 }, { 138,  0,   56 }, { 134,  0, 1917 },
  { 133,  0,  470 }, {  10, 11,  657 }, {  14, 11,  297 }, { 142, 11,  361 },
  { 135, 11,  412 }, {   7,  0, 1198 }, {   7, 11, 1198 }, {   8, 11,  556 },
  {  14, 11,  123 }, {  14, 11,  192 }, { 143, 11,   27 }, {   7, 11, 1985 },
  {  14, 11,  146 }, {  15, 11,   42 }, {  16, 11,   23 }, {  17, 11,   86 },
  { 146, 11,   17 }, {  11,  0, 1015 }, { 136, 11,  122 }, {   4, 10,  114 },
  {   9, 10,  492 }, {  13, 10,  462 }, { 142, 10,  215 }, {   4, 10,   77 },
  {   5, 10,  361 }, {   6, 10,  139 }, {   6, 10,  401 }, {   6, 10,  404 },
  {   7, 10,  413 }, {   7, 10,  715 }, {   7, 10, 1716 }, {  11, 10,  279 },
  {  12, 10,  179 }, {  12, 10,  258 }, {  13, 10,  244 }, { 142, 10,  358 },
  { 134, 10, 1717 }, {   7, 10, 1061 }, {   8, 10,   82 }, {  11, 10,  250 },
  {  12, 10,  420 }, { 141, 10,  184 }, { 133,  0,  715 }, { 135, 10,  724 },
  {   9,  0,  919 }, {   9,  0,  922 }, {   9,  0,  927 }, {   9,  0,  933 },
  {   9,  0,  962 }, {   9,  0, 1000 }, {   9,  0, 1002 }, {   9,  0, 1021 },
  {  12,  0,  890 }, {  12,  0,  907 }, {  12,  0,  930 }, {  15,  0,  207 },
  {  15,  0,  228 }, {  15,  0,  238 }, { 149,  0,   61 }, {   8,  0,  794 },
  {   9,  0,  400 }, {  10,  0,  298 }, { 142,  0,  228 }, {   5, 11,  430 },
  {   5, 11,  932 }, {   6, 11,  131 }, {   7, 11,  417 }, {   9, 11,  522 },
  {  11, 11,  314 }, { 141, 11,  390 }, { 132,  0,  867 }, {   8,  0,  724 },
  { 132, 11,  507 }, { 137, 11,  261 }, {   4, 11,  343 }, { 133, 11,  511 },
  {   6,  0,  190 }, {   7,  0,  768 }, { 135,  0, 1170 }, {   6, 10,  513 },
  { 135, 10, 1052 }, {   7, 11,  455 }, { 138, 11,  591 }, { 134,  0, 1066 },
  { 137, 10,  899 }, {  14,  0,   67 }, { 147,  0,   60 }, {   4,  0,  948 },
  {  18,  0,  174 }, { 146,  0,  176 }, { 135,  0, 1023 }, {   7, 10, 1417 },
  {  12, 10,  382 }, {  17, 10,   48 }, { 152, 10,   12 }, { 134, 11,  575 },
  { 132,  0,  764 }, {   6, 10,  545 }, {   7, 10,  565 }, {   7, 10, 1669 },
  {  10, 10,  114 }, {  11, 10,  642 }, { 140, 10,  618 }, {   6,  0,  137 },
  {   9,  0,   75 }, {   9,  0,  253 }, {  10,  0,  194 }, { 138,  0,  444 },
  {   4,  0,  756 }, { 133, 10,    5 }, {   8,  0, 1008 }, { 135, 10,  192 },
  { 132,  0,  842 }, {  11,  0,  643 }, {  12,  0,  115 }, { 136, 10,  763 },
  { 139,  0,   67 }, { 133, 10,  759 }, {   4,  0,  821 }, {   5,  0,  760 },
  {   7,  0,  542 }, {   8,  0,  135 }, {   8,  0,  496 }, { 135, 11,  580 },
  {   7, 10,  370 }, {   7, 10, 1007 }, {   7, 10, 1177 }, { 135, 10, 1565 },
  { 135, 10, 1237 }, { 140,  0,  736 }, {   7,  0,  319 }, {   7,  0,  355 },
  {   7,  0,  763 }, {  10,  0,  389 }, { 145,  0,   43 }, {   8, 11,  333 },
  { 138, 11,  182 }, {   4, 10,   87 }, {   5, 10,  250 }, { 141, 10,  298 },
  { 138,  0,  786 }, { 134,  0, 2044 }, {   8, 11,  330 }, { 140, 11,  477 },
  { 135, 11, 1338 }, { 132, 11,  125 }, { 134,  0, 1030 }, { 134,  0, 1083 },
  { 132, 11,  721 }, { 135, 10,  814 }, {   7, 11,  776 }, {   8, 11,  145 },
  { 147, 11,   56 }, { 134,  0, 1226 }, {   4, 10,   57 }, {   7, 10, 1195 },
  {   7, 10, 1438 }, {   7, 10, 1548 }, {   7, 10, 1835 }, {   7, 10, 1904 },
  {   9, 10,  757 }, {  10, 10,  604 }, { 139, 10,  519 }, {   7, 11,  792 },
  {   8, 11,  147 }, {  10, 11,  821 }, { 139, 11, 1021 }, { 137, 11,  797 },
  {   4,  0,   58 }, {   5,  0,  286 }, {   6,  0,  319 }, {   7,  0,  402 },
  {   7,  0, 1254 }, {   7,  0, 1903 }, {   8,  0,  356 }, { 140,  0,  408 },
  {   4,  0,  389 }, {   4,  0,  815 }, {   9,  0,  181 }, {   9,  0,  255 },
  {  10,  0,    8 }, {  10,  0,   29 }, {  10,  0,  816 }, {  11,  0,  311 },
  {  11,  0,  561 }, {  12,  0,   67 }, { 141,  0,  181 }, {   7, 11, 1472 },
  { 135, 11, 1554 }, {   7, 11, 1071 }, {   7, 11, 1541 }, {   7, 11, 1767 },
  {   7, 11, 1806 }, {   7, 11, 1999 }, {   9, 11,  248 }, {  10, 11,  400 },
  {  11, 11,  162 }, {  11, 11,  178 }, {  11, 11,  242 }, {  12, 11,  605 },
  {  15, 11,   26 }, { 144, 11,   44 }, {   5, 11,  168 }, {   5, 11,  930 },
  {   8, 11,   74 }, {   9, 11,  623 }, {  12, 11,  500 }, {  12, 11,  579 },
  {  13, 11,   41 }, { 143, 11,   93 }, {   6, 11,  220 }, {   7, 11, 1101 },
  { 141, 11,  105 }, {   5,  0,  474 }, {   7,  0,  507 }, {   4, 10,  209 },
  {   7, 11,  507 }, { 135, 10,  902 }, { 132,  0,  427 }, {   6,  0,  413 },
  {   7, 10,  335 }, {   7, 10, 1437 }, {   7, 10, 1668 }, {   8, 10,  553 },
  {   8, 10,  652 }, {   8, 10,  656 }, {   9, 10,  558 }, {  11, 10,  743 },
  { 149, 10,   18 }, { 132,  0,  730 }, {   6, 11,   19 }, {   7, 11, 1413 },
  { 139, 11,  428 }, { 133,  0,  373 }, { 132, 10,  559 }, {   7, 11,   96 },
  {   8, 11,  401 }, { 137, 11,  896 }, {   7,  0,  799 }, {   7,  0, 1972 },
  {   5, 10, 1017 }, { 138, 10,  511 }, { 135,  0, 1793 }, {   7, 11, 1961 },
  {   7, 11, 1965 }, {   8, 11,  702 }, { 136, 11,  750 }, {   8, 11,  150 },
  {   8, 11,  737 }, { 140, 11,  366 }, { 132,  0,  322 }, { 133, 10,  709 },
  {   8, 11,  800 }, {   9, 11,  148 }, {   9, 11,  872 }, {   9, 11,  890 },
  {  11, 11,  309 }, {  11, 11, 1001 }, {  13, 11,  267 }, { 141, 11,  323 },
  { 134, 10, 1745 }, {   7,  0,  290 }, { 136, 10,  206 }, {   7,  0, 1651 },
  { 145,  0,   89 }, { 139,  0,    2 }, { 132,  0,  672 }, {   6,  0, 1860 },
  {   8,  0,  905 }, {  10,  0,  844 }, {  10,  0,  846 }, {  10,  0,  858 },
  {  12,  0,  699 }, {  12,  0,  746 }, { 140,  0,  772 }, { 135, 11,  424 },
  { 133, 11,  547 }, { 133,  0,  737 }, {   5, 11,  490 }, {   6, 11,  615 },
  {   6, 11,  620 }, { 135, 11,  683 }, {   6,  0,  746 }, { 134,  0, 1612 },
  { 132, 10,  776 }, {   9, 11,  385 }, { 149, 11,   17 }, { 133,  0,  145 },
  { 135, 10, 1272 }, {   7,  0,  884 }, { 140,  0,  124 }, {   4,  0,  387 },
  { 135,  0, 1288 }, {   5, 11,  133 }, { 136, 10,  406 }, { 136, 11,  187 },
  {   6,  0,  679 }, {   8, 11,    8 }, { 138, 11,    0 }, { 135,  0,  550 },
  { 135, 11,  798 }, { 136, 11,  685 }, {   7, 11, 1086 }, { 145, 11,   46 },
  {   8, 10,  175 }, {  10, 10,  168 }, { 138, 10,  573 }, { 135,  0, 1305 },
  {   4,  0,  576 }, { 135,  0, 1263 }, {   6,  0,  686 }, { 134,  0, 1563 },
  { 134,  0,  607 }, {   5,  0,  919 }, { 134,  0, 1673 }, { 148,  0,   37 },
  {   8, 11,  774 }, {  10, 11,  670 }, { 140, 11,   51 }, { 133, 10,  784 },
  { 139, 10,  882 }, {   4,  0,   82 }, {   5,  0,  333 }, {   5,  0,  904 },
  {   6,  0,  207 }, {   7,  0,  325 }, {   7,  0, 1726 }, {   8,  0,  101 },
  {  10,  0,  778 }, { 139,  0,  220 }, { 135, 11,  371 }, { 132,  0,  958 },
  { 133,  0,  903 }, {   4, 11,  127 }, {   5, 11,  350 }, {   6, 11,  356 },
  {   8, 11,  426 }, {   9, 11,  572 }, {  10, 11,  247 }, { 139, 11,  312 },
  { 140,  0,  147 }, {   6, 11,   59 }, {   7, 11,  885 }, {   9, 11,  603 },
  { 141, 11,  397 }, {  10,  0,  367 }, {   9, 10,   14 }, {   9, 10,  441 },
  { 139, 10,    9 }, {  11, 10,  966 }, {  12, 10,  287 }, {  13, 10,  342 },
  {  13, 10,  402 }, {  15, 10,  110 }, { 143, 10,  163 }, { 134,  0,  690 },
  { 132,  0,  705 }, {   9,  0,  651 }, {  11,  0,  971 }, {  13,  0,  273 },
  {   7, 10, 1428 }, {   7, 10, 1640 }, {   7, 10, 1867 }, {   9, 10,  169 },
  {   9, 10,  182 }, {   9, 10,  367 }, {   9, 10,  478 }, {   9, 10,  506 },
  {   9, 10,  551 }, {   9, 10,  557 }, {   9, 10,  648 }, {   9, 10,  697 },
  {   9, 10,  705 }, {   9, 10,  725 }, {   9, 10,  787 }, {   9, 10,  794 },
  {  10, 10,  198 }, {  10, 10,  214 }, {  10, 10,  267 }, {  10, 10,  275 },
  {  10, 10,  456 }, {  10, 10,  551 }, {  10, 10,  561 }, {  10, 10,  613 },
  {  10, 10,  627 }, {  10, 10,  668 }, {  10, 10,  675 }, {  10, 10,  691 },
  {  10, 10,  695 }, {  10, 10,  707 }, {  10, 10,  715 }, {  11, 10,  183 },
  {  11, 10,  201 }, {  11, 10,  262 }, {  11, 10,  352 }, {  11, 10,  439 },
  {  11, 10,  493 }, {  11, 10,  572 }, {  11, 10,  591 }, {  11, 10,  608 },
  {  11, 10,  611 }, {  11, 10,  646 }, {  11, 10,  674 }, {  11, 10,  711 },
  {  11, 10,  751 }, {  11, 10,  761 }, {  11, 10,  776 }, {  11, 10,  785 },
  {  11, 10,  850 }, {  11, 10,  853 }, {  11, 10,  862 }, {  11, 10,  865 },
  {  11, 10,  868 }, {  11, 10,  875 }, {  11, 10,  898 }, {  11, 10,  902 },
  {  11, 10,  903 }, {  11, 10,  910 }, {  11, 10,  932 }, {  11, 10,  942 },
  {  11, 10,  957 }, {  11, 10,  967 }, {  11, 10,  972 }, {  12, 10,  148 },
  {  12, 10,  195 }, {  12, 10,  220 }, {  12, 10,  237 }, {  12, 10,  318 },
  {  12, 10,  339 }, {  12, 10,  393 }, {  12, 10,  445 }, {  12, 10,  450 },
  {  12, 10,  474 }, {  12, 10,  505 }, {  12, 10,  509 }, {  12, 10,  533 },
  {  12, 10,  591 }, {  12, 10,  594 }, {  12, 10,  597 }, {  12, 10,  621 },
  {  12, 10,  633 }, {  12, 10,  642 }, {  13, 10,   59 }, {  13, 10,   60 },
  {  13, 10,  145 }, {  13, 10,  239 }, {  13, 10,  250 }, {  13, 10,  329 },
  {  13, 10,  344 }, {  13, 10,  365 }, {  13, 10,  372 }, {  13, 10,  387 },
  {  13, 10,  403 }, {  13, 10,  414 }, {  13, 10,  456 }, {  13, 10,  470 },
  {  13, 10,  478 }, {  13, 10,  483 }, {  13, 10,  489 }, {  14, 10,   55 },
  {  14, 10,   57 }, {  14, 10,   81 }, {  14, 10,   90 }, {  14, 10,  148 },
  {  14, 10,  239 }, {  14, 10,  266 }, {  14, 10,  321 }, {  14, 10,  326 },
  {  14, 10,  327 }, {  14, 10,  330 }, {  14, 10,  347 }, {  14, 10,  355 },
  {  14, 10,  401 }, {  14, 10,  404 }, {  14, 10,  411 }, {  14, 10,  414 },
  {  14, 10,  416 }, {  14, 10,  420 }, {  15, 10,   61 }, {  15, 10,   74 },
  {  15, 10,   87 }, {  15, 10,   88 }, {  15, 10,   94 }, {  15, 10,   96 },
  {  15, 10,  116 }, {  15, 10,  149 }, {  15, 10,  154 }, {  16, 10,   50 },
  {  16, 10,   63 }, {  16, 10,   73 }, {  17, 10,    2 }, {  17, 10,   66 },
  {  17, 10,   92 }, {  17, 10,  103 }, {  17, 10,  112 }, {  17, 10,  120 },
  {  18, 10,   50 }, {  18, 10,   54 }, {  18, 10,   82 }, {  18, 10,   86 },
  {  18, 10,   90 }, {  18, 10,  111 }, {  18, 10,  115 }, {  18, 10,  156 },
  {  19, 10,   40 }, {  19, 10,   79 }, {  20, 10,   78 }, { 149, 10,   22 },
  {   7,  0,  887 }, {   5, 10,  161 }, { 135, 10,  839 }, { 142, 11,   98 },
  { 134,  0,   90 }, { 138, 11,  356 }, { 135, 11,  441 }, {   6, 11,  111 },
  {   7, 11,    4 }, {   8, 11,  163 }, {   8, 11,  776 }, { 138, 11,  566 },
  { 134,  0,  908 }, { 134,  0, 1261 }, {   7,  0,  813 }, {  12,  0,  497 },
  { 141,  0,   56 }, { 134,  0, 1235 }, { 135,  0,  429 }, { 135, 11, 1994 },
  { 138,  0,  904 }, {   6,  0,  125 }, {   7,  0, 1277 }, { 137,  0,  772 },
  { 151,  0,   12 }, {   4,  0,  841 }, {   5,  0,  386 }, { 133, 11,  386 },
  {   5, 11,  297 }, { 135, 11, 1038 }, {   6,  0,  860 }, {   6,  0, 1069 },
  { 135, 11,  309 }, { 136,  0,  946 }, { 135, 10, 1814 }, { 141, 11,  418 },
  { 136, 11,  363 }, {  10,  0,  768 }, { 139,  0,  787 }, {  22, 11,   30 },
  { 150, 11,   33 }, {   6,  0,  160 }, {   7,  0, 1106 }, {   9,  0,  770 },
  {  11,  0,  112 }, { 140,  0,  413 }, {  11, 11,  216 }, { 139, 11,  340 },
  { 136, 10,  139 }, { 135, 11, 1390 }, { 135, 11,  808 }, { 132, 11,  280 },
  {  12,  0,  271 }, {  17,  0,  109 }, {   7, 10,  643 }, { 136, 10,  236 },
  { 140, 11,   54 }, {   4, 11,  421 }, { 133, 11,  548 }, {  11,  0,  719 },
  {  12,  0,   36 }, { 141,  0,  337 }, {   7,  0,  581 }, {   9,  0,  644 },
  { 137,  0,  699 }, {  11, 11,  511 }, {  13, 11,  394 }, {  14, 11,  298 },
  {  14, 11,  318 }, { 146, 11,  103 }, {   7,  0,  304 }, {   9,  0,  646 },
  {   9,  0,  862 }, {  11,  0,  696 }, {  12,  0,  208 }, {  15,  0,   79 },
  { 147,  0,  108 }, {   4,  0,  631 }, {   7,  0, 1126 }, { 135,  0, 1536 },
  { 135, 11, 1527 }, {   8,  0,  880 }, {  10,  0,  869 }, { 138,  0,  913 },
  {   7,  0, 1513 }, {   5, 10,   54 }, {   6, 11,  254 }, {   9, 11,  109 },
  { 138, 11,  103 }, { 135,  0,  981 }, { 133, 11,  729 }, { 132, 10,  744 },
  { 132,  0,  434 }, { 134,  0,  550 }, {   7,  0,  930 }, {  10,  0,  476 },
  {  13,  0,  452 }, {  19,  0,  104 }, {   6, 11, 1630 }, {  10, 10,  402 },
  { 146, 10,   55 }, {   5,  0,  553 }, { 138,  0,  824 }, { 136,  0,  452 },
  {   8,  0,  151 }, { 137, 10,  624 }, { 132, 10,  572 }, { 132,  0,  772 },
  { 133, 11,  671 }, { 133,  0,  292 }, { 138,  0,  135 }, { 132, 11,  889 },
  { 140, 11,  207 }, {   9,  0,  504 }, {   6, 10,   43 }, {   7, 10,   38 },
  {   8, 10,  248 }, { 138, 10,  513 }, {   6,  0, 1089 }, { 135, 11, 1910 },
  {   4, 11,  627 }, { 133, 11,  775 }, { 135,  0,  783 }, { 133, 10,  766 },
  { 133, 10,  363 }, {   7,  0,  387 }, { 135, 11,  387 }, {   7,  0,  393 },
  {  10,  0,  603 }, {  11,  0,  206 }, {   7, 11,  202 }, {  11, 11,  362 },
  {  11, 11,  948 }, { 140, 11,  388 }, {   6, 11,  507 }, {   7, 11,  451 },
  {   8, 11,  389 }, {  12, 11,  490 }, {  13, 11,   16 }, {  13, 11,  215 },
  {  13, 11,  351 }, {  18, 11,  132 }, { 147, 11,  125 }, {   4,  0,  912 },
  {   9,  0,  232 }, { 135, 11,  841 }, {   6, 10,  258 }, { 140, 10,  409 },
  {   5, 10,  249 }, { 148, 10,   82 }, { 136, 11,  566 }, {   6,  0,  977 },
  { 135, 11, 1214 }, {   7,  0, 1973 }, { 136,  0,  716 }, { 135,  0,   98 },
  { 133,  0,  733 }, {   5, 11,  912 }, { 134, 11, 1695 }, {   5, 10,  393 },
  {   6, 10,  378 }, {   7, 10, 1981 }, {   9, 10,   32 }, {   9, 10,  591 },
  {  10, 10,  685 }, {  10, 10,  741 }, { 142, 10,  382 }, { 133, 10,  788 },
  {  10,  0,   19 }, {  11,  0,  911 }, {   7, 10, 1968 }, { 141, 10,  509 },
  {   5,  0,  668 }, {   5, 11,  236 }, {   6, 11,  572 }, {   8, 11,  492 },
  {  11, 11,  618 }, { 144, 11,   56 }, { 135, 11, 1789 }, {   4,  0,  360 },
  {   5,  0,  635 }, {   5,  0,  700 }, {   5, 10,   58 }, {   5, 10,  171 },
  {   5, 10,  683 }, {   6, 10,  291 }, {   6, 10,  566 }, {   7, 10, 1650 },
  {  11, 10,  523 }, {  12, 10,  273 }, {  12, 10,  303 }, {  15, 10,   39 },
  { 143, 10,  111 }, { 133,  0,  901 }, { 134, 10,  589 }, {   5, 11,  190 },
  { 136, 11,  318 }, { 140,  0,  656 }, {   7,  0,  726 }, { 152,  0,    9 },
  {   4, 10,  917 }, { 133, 10, 1005 }, { 135, 10, 1598 }, { 134, 11,  491 },
  {   4, 10,  919 }, { 133, 11,  434 }, { 137,  0,   72 }, {   6,  0, 1269 },
  {   6,  0, 1566 }, { 134,  0, 1621 }, {   9,  0,  463 }, {  10,  0,  595 },
  {   4, 10,  255 }, {   5, 10,  302 }, {   6, 10,  132 }, {   7, 10,  128 },
  {   7, 10,  283 }, {   7, 10, 1299 }, {  10, 10,   52 }, {  10, 10,  514 },
  {  11, 10,  925 }, {  13, 10,   92 }, { 142, 10,  309 }, { 135,  0, 1454 },
  { 134,  0, 1287 }, {  11,  0,  600 }, {  13,  0,  245 }, { 137, 10,  173 },
  { 136,  0,  989 }, {   7,  0,  164 }, {   7,  0, 1571 }, {   9,  0,  107 },
  { 140,  0,  225 }, {   6,  0, 1061 }, { 141, 10,  442 }, {   4,  0,   27 },
  {   5,  0,  484 }, {   5,  0,  510 }, {   6,  0,  434 }, {   7,  0, 1000 },
  {   7,  0, 1098 }, { 136,  0,    2 }, {   7, 11,   85 }, {   7, 11,  247 },
  {   8, 11,  585 }, {  10, 11,  163 }, { 138, 11,  316 }, {  11, 11,  103 },
  { 142, 11,    0 }, { 134,  0, 1127 }, {   4,  0,  460 }, { 134,  0,  852 },
  { 134, 10,  210 }, {   4,  0,  932 }, { 133,  0,  891 }, {   6,  0,  588 },
  { 147, 11,   83 }, {   8,  0,  625 }, {   4, 10,  284 }, { 134, 10,  223 },
  { 134,  0,   76 }, {   8,  0,   92 }, { 137,  0,  221 }, {   4, 11,  124 },
  {  10, 11,  457 }, {  11, 11,  121 }, {  11, 11,  169 }, {  11, 11,  422 },
  {  11, 11,  870 }, {  12, 11,  214 }, {  13, 11,  389 }, {  14, 11,  187 },
  { 143, 11,   77 }, {   9, 11,  618 }, { 138, 11,  482 }, {   4, 10,  218 },
  {   7, 10,  526 }, { 143, 10,  137 }, {  13,  0,    9 }, {  14,  0,  104 },
  {  14,  0,  311 }, {   4, 10,  270 }, {   5, 10,  192 }, {   6, 10,  332 },
  { 135, 10, 1322 }, { 140, 10,  661 }, { 135, 11, 1193 }, {   6, 11,  107 },
  {   7, 11,  638 }, {   7, 11, 1632 }, { 137, 11,  396 }, { 132,  0,  763 },
  {   4,  0,  622 }, {   5, 11,  370 }, { 134, 11, 1756 }, { 133,  0,  253 },
  { 135,  0,  546 }, {   9,  0,   73 }, {  10,  0,  110 }, {  14,  0,  185 },
  {  17,  0,  119 }, { 133, 11,  204 }, {   7,  0,  624 }, {   7,  0,  916 },
  {  10,  0,  256 }, { 139,  0,   87 }, {   7, 10,  379 }, {   8, 10,  481 },
  { 137, 10,  377 }, {   5,  0,  212 }, {  12,  0,   35 }, {  13,  0,  382 },
  {   5, 11,  970 }, { 134, 11, 1706 }, {   9,  0,  746 }, {   5, 10, 1003 },
  { 134, 10,  149 }, {  10,  0,  150 }, {  11,  0,  849 }, {  13,  0,  330 },
  {   8, 10,  262 }, {   9, 10,  627 }, {  11, 10,  214 }, {  11, 10,  404 },
  {  11, 10,  457 }, {  11, 10,  780 }, {  11, 10,  913 }, {  13, 10,  401 },
  { 142, 10,  200 }, { 134,  0, 1466 }, { 135, 11,    3 }, {   6,  0, 1299 },
  {   4, 11,   35 }, {   5, 11,  121 }, {   5, 11,  483 }, {   5, 11,  685 },
  {   6, 11,  489 }, {   7, 11, 1204 }, { 136, 11,  394 }, { 135, 10,  742 },
  {   4, 10,  142 }, { 136, 10,  304 }, {   4, 11,  921 }, { 133, 11, 1007 },
  { 134,  0, 1518 }, {   6,  0, 1229 }, { 135,  0, 1175 }, { 133,  0,  816 },
  {  12,  0,  159 }, {   4, 10,  471 }, {   4, 11,  712 }, {   5, 10,   51 },
  {   6, 10,  602 }, {   7, 10,  925 }, {   8, 10,  484 }, { 138, 10,  195 },
  { 134, 11, 1629 }, {   5,  0,  869 }, {   5,  0,  968 }, {   6,  0, 1626 },
  {   8,  0,  734 }, { 136,  0,  784 }, {   4,  0,  542 }, {   6,  0, 1716 },
  {   6,  0, 1727 }, {   7,  0, 1082 }, {   7,  0, 1545 }, {   8,  0,   56 },
  {   8,  0,  118 }, {   8,  0,  412 }, {   8,  0,  564 }, {   9,  0,  888 },
  {   9,  0,  908 }, {  10,  0,   50 }, {  10,  0,  423 }, {  11,  0,  685 },
  {  11,  0,  697 }, {  11,  0,  933 }, {  12,  0,  299 }, {  13,  0,  126 },
  {  13,  0,  136 }, {  13,  0,  170 }, {  13,  0,  190 }, { 136, 10,  688 },
  { 132, 10,  697 }, {   4,  0,  232 }, {   9,  0,  202 }, {  10,  0,  474 },
  { 140,  0,  433 }, { 136,  0,  212 }, {   6,  0,  108 }, {   7,  0, 1003 },
  {   7,  0, 1181 }, {   8,  0,  111 }, { 136,  0,  343 }, {   5, 10,  221 },
  { 135, 11, 1255 }, { 133, 11,  485 }, { 134,  0, 1712 }, { 142,  0,  216 },
  {   5,  0,  643 }, {   6,  0,  516 }, {   4, 11,  285 }, {   5, 11,  317 },
  {   6, 11,  301 }, {   7, 11,    7 }, {   8, 11,  153 }, {  10, 11,  766 },
  {  11, 11,  468 }, {  12, 11,  467 }, { 141, 11,  143 }, {   4,  0,  133 },
  {   7,  0,  711 }, {   7,  0, 1298 }, { 135,  0, 1585 }, { 134,  0,  650 },
  { 135, 11,  512 }, {   6,  0,   99 }, {   7,  0, 1808 }, { 145,  0,   57 },
  {   6,  0,  246 }, {   6,  0,  574 }, {   7,  0,  428 }, {   9,  0,  793 },
  {  10,  0,  669 }, {  11,  0,  485 }, {  11,  0,  840 }, {  12,  0,  300 },
  {  14,  0,  250 }, { 145,  0,   55 }, {   4, 10,  132 }, {   5, 10,   69 },
  { 135, 10, 1242 }, { 136,  0, 1023 }, {   7,  0,  302 }, { 132, 10,  111 },
  { 135,  0, 1871 }, { 132,  0,  728 }, {   9,  0,  252 }, { 132, 10,  767 },
  {   6,  0,  461 }, {   7,  0, 1590 }, {   7, 10, 1416 }, {   7, 10, 2005 },
  {   8, 10,  131 }, {   8, 10,  466 }, {   9, 10,  672 }, {  13, 10,  252 },
  { 148, 10,  103 }, {   6,  0,  323 }, { 135,  0, 1564 }, {   7,  0,  461 },
  { 136,  0,  775 }, {   6, 10,   44 }, { 136, 10,  368 }, { 139,  0,  172 },
  { 132,  0,  464 }, {   4, 10,  570 }, { 133, 10,  120 }, { 137, 11,  269 },
  {   6, 10,  227 }, { 135, 10, 1589 }, {   6, 11, 1719 }, {   6, 11, 1735 },
  {   7, 11, 2016 }, {   7, 11, 2020 }, {   8, 11,  837 }, { 137, 11,  852 },
  {   7,  0,  727 }, { 146,  0,   73 }, { 132,  0, 1023 }, { 135, 11,  852 },
  { 135, 10, 1529 }, { 136,  0,  577 }, { 138, 11,  568 }, { 134,  0, 1037 },
  {   8, 11,   67 }, { 138, 11,  419 }, {   4,  0,  413 }, {   5,  0,  677 },
  {   8,  0,  432 }, { 140,  0,  280 }, {  10,  0,  600 }, {   6, 10, 1667 },
  {   7, 11,  967 }, {   7, 10, 2036 }, { 141, 11,   11 }, {   6, 10,  511 },
  { 140, 10,  132 }, {   6,  0,  799 }, {   5, 10,  568 }, {   6, 10,  138 },
  { 135, 10, 1293 }, {   8,  0,  159 }, {   4, 10,  565 }, { 136, 10,  827 },
  {   7,  0,  646 }, {   7,  0, 1730 }, {  11,  0,  446 }, { 141,  0,  178 },
  {   4, 10,  922 }, { 133, 10, 1023 }, { 135, 11,   11 }, { 132,  0,  395 },
  {  11,  0,  145 }, { 135, 10, 1002 }, {   9,  0,  174 }, {  10,  0,  164 },
  {  11,  0,  440 }, {  11,  0,  514 }, {  11,  0,  841 }, {  15,  0,   98 },
  { 149,  0,   20 }, { 134,  0,  426 }, {  10,  0,  608 }, { 139,  0, 1002 },
  {   7, 11,  320 }, {   8, 11,   51 }, {  12, 11,  481 }, {  12, 11,  570 },
  { 148, 11,  106 }, {   9,  0,  977 }, {   9,  0,  983 }, { 132, 11,  445 },
  { 138,  0,  250 }, { 139,  0,  100 }, {   6,  0, 1982 }, { 136, 10,  402 },
  { 133, 11,  239 }, {   4, 10,  716 }, { 141, 10,   31 }, {   5,  0,  476 },
  {   7, 11,   83 }, {   7, 11, 1990 }, {   8, 11,  130 }, { 139, 11,  720 },
  {   8, 10,  691 }, { 136, 10,  731 }, {   5, 11,  123 }, {   6, 11,  530 },
  {   7, 11,  348 }, { 135, 11, 1419 }, {   5,  0,   76 }, {   6,  0,  458 },
  {   6,  0,  497 }, {   7,  0,  868 }, {   9,  0,  658 }, {  10,  0,  594 },
  {  11,  0,  173 }, {  11,  0,  566 }, {  12,  0,   20 }, {  12,  0,  338 },
  { 141,  0,  200 }, {   9, 11,  139 }, {  10, 11,  399 }, {  11, 11,  469 },
  {  12, 11,  634 }, { 141, 11,  223 }, {   9, 10,  840 }, { 138, 10,  803 },
  { 133, 10,  847 }, {  11, 11,  223 }, { 140, 11,  168 }, { 132, 11,  210 },
  {   8,  0,  447 }, {   9, 10,   53 }, {   9, 10,  268 }, {   9, 10,  901 },
  {  10, 10,  518 }, {  10, 10,  829 }, {  11, 10,  188 }, {  13, 10,   74 },
  {  14, 10,   46 }, {  15, 10,   17 }, {  15, 10,   33 }, {  17, 10,   40 },
  {  18, 10,   36 }, {  19, 10,   20 }, {  22, 10,    1 }, { 152, 10,    2 },
  {   4,  0,  526 }, {   7,  0, 1029 }, { 135,  0, 1054 }, {  19, 11,   59 },
  { 150, 11,    2 }, {   4,  0,  636 }, {   6,  0, 1875 }, {   6,  0, 1920 },
  {   9,  0,  999 }, {  12,  0,  807 }, {  12,  0,  825 }, {  15,  0,  179 },
  {  15,  0,  190 }, {  18,  0,  182 }, { 136, 10,  532 }, {   6,  0, 1699 },
  {   7,  0,  660 }, {   7,  0, 1124 }, {  17,  0,   31 }, {  19,  0,   22 },
  { 151,  0,   14 }, { 135, 10,  681 }, { 132, 11,  430 }, { 140, 10,  677 },
  {   4, 10,  684 }, { 136, 10,  384 }, { 132, 11,  756 }, { 133, 11,  213 },
  {   7,  0,  188 }, {   7, 10,  110 }, {   8, 10,  290 }, {   8, 10,  591 },
  {   9, 10,  382 }, {   9, 10,  649 }, {  11, 10,   71 }, {  11, 10,  155 },
  {  11, 10,  313 }, {  12, 10,    5 }, {  13, 10,  325 }, { 142, 10,  287 },
  {   7, 10,  360 }, {   7, 10,  425 }, {   9, 10,   66 }, {   9, 10,  278 },
  { 138, 10,  644 }, { 142, 11,  164 }, {   4,  0,  279 }, {   7,  0,  301 },
  { 137,  0,  362 }, { 134, 11,  586 }, { 135,  0, 1743 }, {   4,  0,  178 },
  { 133,  0,  399 }, {   4, 10,  900 }, { 133, 10,  861 }, {   5, 10,  254 },
  {   7, 10,  985 }, { 136, 10,   73 }, { 133, 11,  108 }, {   7, 10, 1959 },
  { 136, 10,  683 }, { 133, 11,  219 }, {   4, 11,  193 }, {   5, 11,  916 },
  {   7, 11,  364 }, {  10, 11,  398 }, {  10, 11,  726 }, {  11, 11,  317 },
  {  11, 11,  626 }, {  12, 11,  142 }, {  12, 11,  288 }, {  12, 11,  678 },
  {  13, 11,  313 }, {  15, 11,  113 }, {  18, 11,  114 }, {  21, 11,   30 },
  { 150, 11,   53 }, {   6, 11,  241 }, {   7, 11,  907 }, {   8, 11,  832 },
  {   9, 11,  342 }, {  10, 11,  729 }, {  11, 11,  284 }, {  11, 11,  445 },
  {  11, 11,  651 }, {  11, 11,  863 }, {  13, 11,  398 }, { 146, 11,   99 },
  { 132,  0,  872 }, { 134,  0,  831 }, { 134,  0, 1692 }, {   6,  0,  202 },
  {   6,  0, 1006 }, {   9,  0,  832 }, {  10,  0,  636 }, {  11,  0,  208 },
  {  12,  0,  360 }, {  17,  0,  118 }, {  18,  0,   27 }, {  20,  0,   67 },
  { 137, 11,  734 }, { 132, 10,  725 }, {   7, 11,  993 }, { 138, 11,  666 },
  { 134,  0, 1954 }, { 134, 10,  196 }, {   7,  0,  872 }, {  10,  0,  516 },
  { 139,  0,  167 }, { 133, 10,  831 }, {   4, 11,  562 }, {   9, 11,  254 },
  { 139, 11,  879 }, { 137,  0,  313 }, {   4,  0,  224 }, { 132, 11,  786 },
  {  11,  0,   24 }, {  12,  0,  170 }, { 136, 10,  723 }, {   5,  0,  546 },
  {   7,  0,   35 }, {   8,  0,   11 }, {   8,  0,   12 }, {   9,  0,  315 },
  {   9,  0,  533 }, {  10,  0,  802 }, {  11,  0,  166 }, {  12,  0,  525 },
  { 142,  0,  243 }, {   7,  0, 1937 }, {  13, 10,   80 }, {  13, 10,  437 },
  { 145, 10,   74 }, {   5,  0,  241 }, {   8,  0,  242 }, {   9,  0,  451 },
  {  10,  0,  667 }, {  11,  0,  598 }, { 140,  0,  429 }, { 150,  0,   46 },
  {   6,  0, 1273 }, { 137,  0,  830 }, {   5, 10,  848 }, {   6, 10,   66 },
  { 136, 10,  764 }, {   6,  0,  825 }, { 134,  0,  993 }, {   4,  0, 1006 },
  {  10,  0,  327 }, {  13,  0,  271 }, {   4, 10,   36 }, {   7, 10, 1387 },
  { 139, 10,  755 }, { 134,  0, 1023 }, { 135,  0, 1580 }, {   4,  0,  366 },
  { 137,  0,  516 }, { 132, 10,  887 }, {   6,  0, 1736 }, { 135,  0, 1891 },
  {   6, 11,  216 }, {   7, 11,  901 }, {   7, 11, 1343 }, { 136, 11,  493 },
  {   6, 10,  165 }, { 138, 10,  388 }, {   7, 11,  341 }, { 139, 11,  219 },
  {   4, 10,  719 }, { 135, 10,  155 }, { 134,  0, 1935 }, { 132,  0,  826 },
  {   6,  0,  331 }, {   6,  0, 1605 }, {   8,  0,  623 }, {  11,  0,  139 },
  { 139,  0,  171 }, { 135, 11, 1734 }, {  10, 11,  115 }, {  11, 11,  420 },
  {  12, 11,  154 }, {  13, 11,  404 }, {  14, 11,  346 }, {  15, 11,   54 },
  { 143, 11,  112 }, {   7,  0,  288 }, {   4, 10,  353 }, {   6, 10,  146 },
  {   6, 10, 1789 }, {   7, 10,  990 }, {   7, 10, 1348 }, {   9, 10,  665 },
  {   9, 10,  898 }, {  11, 10,  893 }, { 142, 10,  212 }, {   6,  0,  916 },
  { 134,  0, 1592 }, {   7,  0, 1888 }, {   4, 10,   45 }, { 135, 10, 1257 },
  {   5, 11, 1011 }, { 136, 11,  701 }, { 139, 11,  596 }, {   4, 11,   54 },
  {   5, 11,  666 }, {   7, 11, 1039 }, {   7, 11, 1130 }, {   9, 11,  195 },
  { 138, 11,  302 }, { 134,  0, 1471 }, { 134,  0, 1570 }, { 132,  0,  394 },
  { 140, 10,   65 }, { 136, 10,  816 }, { 135,  0, 1931 }, {   7,  0,  574 },
  { 135,  0, 1719 }, { 134, 11,  467 }, { 132,  0,  658 }, {   9,  0,  781 },
  {  10,  0,  144 }, {  11,  0,  385 }, {  13,  0,  161 }, {  13,  0,  228 },
  {  13,  0,  268 }, {  20,  0,  107 }, { 134, 11, 1669 }, { 136,  0,  374 },
  { 135,  0,  735 }, {   4,  0,  344 }, {   6,  0,  498 }, { 139,  0,  323 },
  {   7,  0,  586 }, {   7,  0, 1063 }, {   6, 10,  559 }, { 134, 10, 1691 },
  { 137,  0,  155 }, { 133,  0,  906 }, {   7, 11,  122 }, {   9, 11,  259 },
  {  10, 11,   84 }, {  11, 11,  470 }, {  12, 11,  541 }, { 141, 11,  379 },
  { 134,  0, 1139 }, {  10,  0,  108 }, { 139,  0,  116 }, { 134, 10,  456 },
  { 133, 10,  925 }, {   5, 11,   82 }, {   5, 11,  131 }, {   7, 11, 1755 },
  {   8, 11,   31 }, {   9, 11,  168 }, {   9, 11,  764 }, { 139, 11,  869 },
  { 134, 11,  605 }, {   5, 11,  278 }, { 137, 11,   68 }, {   4, 11,  163 },
  {   5, 11,  201 }, {   5, 11,  307 }, {   5, 11,  310 }, {   6, 11,  335 },
  {   7, 11,  284 }, { 136, 11,  165 }, { 135, 11, 1660 }, {   6, 11,   33 },
  { 135, 11, 1244 }, {   4,  0,  616 }, { 136, 11,  483 }, {   8,  0,  857 },
  {   8,  0,  902 }, {   8,  0,  910 }, {  10,  0,  879 }, {  12,  0,  726 },
  {   4, 11,  199 }, { 139, 11,   34 }, { 136,  0,  692 }, {   6, 10,  193 },
  {   7, 10,  240 }, {   7, 10, 1682 }, {  10, 10,   51 }, {  10, 10,  640 },
  {  11, 10,  410 }, {  13, 10,   82 }, {  14, 10,  247 }, {  14, 10,  331 },
  { 142, 10,  377 }, {   6,  0,  823 }, { 134,  0,  983 }, { 139, 10,  411 },
  { 132,  0,  305 }, { 136, 10,  633 }, { 138, 11,  203 }, { 134,  0,  681 },
  {   6, 11,  326 }, {   7, 11,  677 }, { 137, 11,  425 }, {   5,  0,  214 },
  {   7,  0,  603 }, {   8,  0,  611 }, {   9,  0,  686 }, {  10,  0,   88 },
  {  11,  0,  459 }, {  11,  0,  496 }, {  12,  0,  463 }, {  12,  0,  590 },
  { 141,  0,    0 }, { 136,  0, 1004 }, { 142,  0,   23 }, { 134,  0, 1703 },
  { 147, 11,    8 }, { 145, 11,   56 }, { 135,  0, 1443 }, {   4, 10,  237 },
  { 135, 10,  514 }, {   6,  0,  714 }, { 145,  0,   19 }, {   5, 11,  358 },
  {   7, 11,  473 }, {   7, 11, 1184 }, {  10, 11,  662 }, {  13, 11,  212 },
  {  13, 11,  304 }, {  13, 11,  333 }, { 145, 11,   98 }, {   4,  0,  737 },
  {  10,  0,   98 }, {  11,  0,  294 }, {  12,  0,   60 }, {  12,  0,  437 },
  {  13,  0,   64 }, {  13,  0,  380 }, { 142,  0,  430 }, {   6, 10,  392 },
  {   7, 10,   65 }, { 135, 10, 2019 }, {   6,  0, 1758 }, {   8,  0,  520 },
  {   9,  0,  345 }, {   9,  0,  403 }, { 142,  0,  350 }, {   5,  0,   47 },
  {  10,  0,  242 }, { 138,  0,  579 }, {   5,  0,  139 }, {   7,  0, 1168 },
  { 138,  0,  539 }, { 134,  0, 1459 }, {  13,  0,  388 }, { 141, 11,  388 },
  { 134,  0,  253 }, {   7, 10, 1260 }, { 135, 10, 1790 }, {  10,  0,  252 },
  {   9, 10,  222 }, { 139, 10,  900 }, { 140,  0,  745 }, { 133, 11,  946 },
  {   4,  0,  107 }, {   7,  0,  613 }, {   8,  0,  439 }, {   8,  0,  504 },
  {   9,  0,  501 }, {  10,  0,  383 }, { 139,  0,  477 }, { 135, 11, 1485 },
  { 132,  0,  871 }, {   7, 11,  411 }, {   7, 11,  590 }, {   8, 11,  631 },
  {   9, 11,  323 }, {  10, 11,  355 }, {  11, 11,  491 }, {  12, 11,  143 },
  {  12, 11,  402 }, {  13, 11,   73 }, {  14, 11,  408 }, {  15, 11,  107 },
  { 146, 11,   71 }, { 132,  0,  229 }, { 132,  0,  903 }, { 140,  0,   71 },
  { 133,  0,  549 }, {   4,  0,   47 }, {   6,  0,  373 }, {   7,  0,  452 },
  {   7,  0,  543 }, {   7,  0, 1828 }, {   7,  0, 1856 }, {   9,  0,    6 },
  {  11,  0,  257 }, { 139,  0,  391 }, {   7, 11, 1467 }, {   8, 11,  328 },
  {  10, 11,  544 }, {  11, 11,  955 }, {  13, 11,  320 }, { 145, 11,   83 },
  {   5,  0,  980 }, { 134,  0, 1754 }, { 136,  0,  865 }, {   5,  0,  705 },
  { 137,  0,  606 }, {   7,  0,  161 }, {   8, 10,  201 }, { 136, 10,  605 },
  { 143, 11,   35 }, {   5, 11,  835 }, {   6, 11,  483 }, { 140, 10,  224 },
  {   7,  0,  536 }, {   7,  0, 1331 }, { 136,  0,  143 }, { 134,  0, 1388 },
  {   5,  0,  724 }, {  10,  0,  305 }, {  11,  0,  151 }, {  12,  0,   33 },
  {  12,  0,  121 }, {  12,  0,  381 }, {  17,  0,    3 }, {  17,  0,   27 },
  {  17,  0,   78 }, {  18,  0,   18 }, {  19,  0,   54 }, { 149,  0,    5 },
  {   4, 10,  523 }, { 133, 10,  638 }, {   5,  0,   19 }, { 134,  0,  533 },
  {   5,  0,  395 }, {   5,  0,  951 }, { 134,  0, 1776 }, { 135,  0, 1908 },
  { 132,  0,  846 }, {  10,  0,   74 }, {  11,  0,  663 }, {  12,  0,  210 },
  {  13,  0,  166 }, {  13,  0,  310 }, {  14,  0,  373 }, {  18,  0,   95 },
  {  19,  0,   43 }, {   6, 10,  242 }, {   7, 10,  227 }, {   7, 10, 1581 },
  {   8, 10,  104 }, {   9, 10,  113 }, {   9, 10,  220 }, {   9, 10,  427 },
  {  10, 10,  239 }, {  11, 10,  579 }, {  11, 10, 1023 }, {  13, 10,    4 },
  {  13, 10,  204 }, {  13, 10,  316 }, { 148, 10,   86 }, {   9, 11,  716 },
  {  11, 11,  108 }, {  13, 11,  123 }, {  14, 11,  252 }, {  19, 11,   38 },
  {  21, 11,    3 }, { 151, 11,   11 }, {   8,  0,  372 }, {   9,  0,  122 },
  { 138,  0,  175 }, { 132, 11,  677 }, {   7, 11, 1374 }, { 136, 11,  540 },
  { 135, 10,  861 }, { 132,  0,  695 }, {   7,  0,  497 }, {   9,  0,  387 },
  { 147,  0,   81 }, { 136,  0,  937 }, { 134,  0,  718 }, {   7,  0, 1328 },
  { 136, 10,  494 }, { 132, 11,  331 }, {   6,  0, 1581 }, { 133, 11,  747 },
  {   5,  0,  284 }, {   6,  0,   49 }, {   6,  0,  350 }, {   7,  0,    1 },
  {   7,  0,  377 }, {   7,  0, 1693 }, {   8,  0,   18 }, {   8,  0,  678 },
  {   9,  0,  161 }, {   9,  0,  585 }, {   9,  0,  671 }, {   9,  0,  839 },
  {  11,  0,  912 }, { 141,  0,  427 }, {   7, 10, 1306 }, {   8, 10,  505 },
  {   9, 10,  482 }, {  10, 10,  126 }, {  11, 10,  225 }, {  12, 10,  347 },
  {  12, 10,  449 }, {  13, 10,   19 }, {  14, 10,  218 }, { 142, 10,  435 },
  {  10, 10,  764 }, {  12, 10,  120 }, {  13, 10,   39 }, { 145, 10,  127 },
  {   4,  0,  597 }, { 133, 10,  268 }, { 134,  0, 1094 }, {   4,  0, 1008 },
  { 134,  0, 1973 }, { 132,  0,  811 }, { 139,  0,  908 }, { 135,  0, 1471 },
  { 133, 11,  326 }, {   4, 10,  384 }, { 135, 10, 1022 }, {   7,  0, 1935 },
  {   8,  0,  324 }, {  12,  0,   42 }, {   4, 11,  691 }, {   7, 11, 1935 },
  {   8, 11,  324 }, {   9, 11,   35 }, {  10, 11,  680 }, {  11, 11,  364 },
  {  12, 11,   42 }, {  13, 11,  357 }, { 146, 11,   16 }, { 135,  0, 2014 },
  {   7,  0, 2007 }, {   9,  0,  101 }, {   9,  0,  450 }, {  10,  0,   66 },
  {  10,  0,  842 }, {  11,  0,  536 }, {  12,  0,  587 }, {   6, 11,   32 },
  {   7, 11,  385 }, {   7, 11,  757 }, {   7, 11, 1916 }, {   8, 11,   37 },
  {   8, 11,   94 }, {   8, 11,  711 }, {   9, 11,  541 }, {  10, 11,  162 },
  {  10, 11,  795 }, {  11, 11,  989 }, {  11, 11, 1010 }, {  12, 11,   14 },
  { 142, 11,  308 }, { 139,  0,  586 }, { 135, 10, 1703 }, {   7,  0, 1077 },
  {  11,  0,   28 }, {   9, 10,  159 }, { 140, 10,  603 }, {   6,  0, 1221 },
  { 136, 10,  583 }, {   6, 11,  152 }, {   6, 11,  349 }, {   6, 11, 1682 },
  {   7, 11, 1252 }, {   8, 11,  112 }, {   9, 11,  435 }, {   9, 11,  668 },
  {  10, 11,  290 }, {  10, 11,  319 }, {  10, 11,  815 }, {  11, 11,  180 },
  {  11, 11,  837 }, {  12, 11,  240 }, {  13, 11,  152 }, {  13, 11,  219 },
  { 142, 11,  158 }, { 139,  0,   62 }, { 132, 10,  515 }, {   8, 10,  632 },
  {   8, 10,  697 }, { 137, 10,  854 }, { 134,  0, 1766 }, { 132, 11,  581 },
  {   6, 11,  126 }, {   7, 11,  573 }, {   8, 11,  397 }, { 142, 11,   44 },
  { 150,  0,   28 }, {  11,  0,  670 }, {  22,  0,   25 }, {   4, 10,  136 },
  { 133, 10,  551 }, {   6,  0, 1665 }, {   7,  0,  256 }, {   7,  0, 1388 },
  { 138,  0,  499 }, {   4,  0,   22 }, {   5,  0,   10 }, {   7,  0, 1576 },
  { 136,  0,   97 }, { 134, 10, 1782 }, {   5,  0,  481 }, {   7, 10, 1287 },
  {   9, 10,   44 }, {  10, 10,  552 }, {  10, 10,  642 }, {  11, 10,  839 },
  {  12, 10,  274 }, {  12, 10,  275 }, {  12, 10,  372 }, {  13, 10,   91 },
  { 142, 10,  125 }, { 133, 11,  926 }, {   7, 11, 1232 }, { 137, 11,  531 },
  {   6,  0,  134 }, {   7,  0,  437 }, {   7,  0, 1824 }, {   9,  0,   37 },
  {  14,  0,  285 }, { 142,  0,  371 }, {   7,  0,  486 }, {   8,  0,  155 },
  {  11,  0,   93 }, { 140,  0,  164 }, {   6,  0, 1391 }, { 134,  0, 1442 },
  { 133, 11,  670 }, { 133,  0,  591 }, {   6, 10,  147 }, {   7, 10,  886 },
  {   7, 11, 1957 }, {   9, 10,  753 }, { 138, 10,  268 }, {   5,  0,  380 },
  {   5,  0,  650 }, {   7,  0, 1173 }, { 136,  0,  310 }, {   4,  0,  364 },
  {   7,  0, 1156 }, {   7,  0, 1187 }, { 137,  0,  409 }, { 135, 11, 1621 },
  { 134,  0,  482 }, { 133, 11,  506 }, {   4,  0,  781 }, {   6,  0,  487 },
  {   7,  0,  926 }, {   8,  0,  263 }, { 139,  0,  500 }, { 138, 10,  137 },
  { 135, 11,  242 }, { 139, 11,   96 }, { 133, 10,  414 }, { 135, 10, 1762 },
  { 134,  0,  804 }, {   5, 11,  834 }, {   7, 11, 1202 }, {   8, 11,   14 },
  {   9, 11,  481 }, { 137, 11,  880 }, { 134, 10,  599 }, {   4,  0,   94 },
  { 135,  0, 1265 }, {   4,  0,  415 }, { 132,  0,  417 }, {   5,  0,  348 },
  {   6,  0,  522 }, {   6, 10, 1749 }, {   7, 11, 1526 }, { 138, 11,  465 },
  { 134, 10, 1627 }, { 132,  0, 1012 }, { 132, 10,  488 }, {   4, 11,  357 },
  {   6, 11,  172 }, {   7, 11,  143 }, { 137, 11,  413 }, {   4, 10,   83 },
  {   4, 11,  590 }, { 146, 11,   76 }, { 140, 10,  676 }, {   7, 11,  287 },
  {   8, 11,  355 }, {   9, 11,  293 }, { 137, 11,  743 }, { 134, 10,  278 },
  {   6,  0, 1803 }, {  18,  0,  165 }, {  24,  0,   21 }, {   5, 11,  169 },
  {   7, 11,  333 }, { 136, 11,   45 }, {  12, 10,   97 }, { 140, 11,   97 },
  {   4,  0,  408 }, {   4,  0,  741 }, { 135,  0,  500 }, { 132, 11,  198 },
  {   7, 10,  388 }, {   7, 10,  644 }, { 139, 10,  781 }, {   4, 11,   24 },
  {   5, 11,  140 }, {   5, 11,  185 }, {   7, 11, 1500 }, {  11, 11,  565 },
  { 139, 11,  838 }, {   6,  0, 1321 }, {   9,  0,  257 }, {   7, 10,  229 },
  {   8, 10,   59 }, {   9, 10,  190 }, {  10, 10,  378 }, { 140, 10,  191 },
  {   4, 11,  334 }, { 133, 11,  593 }, { 135, 11, 1885 }, { 134,  0, 1138 },
  {   4,  0,  249 }, {   6,  0,   73 }, { 135,  0,  177 }, { 133,  0,  576 },
  { 142,  0,  231 }, { 137,  0,  288 }, { 132, 10,  660 }, {   7, 10, 1035 },
  { 138, 10,  737 }, { 135,  0, 1487 }, {   6,  0,  989 }, {   9,  0,  433 },
  {   7, 10,  690 }, {   9, 10,  587 }, { 140, 10,  521 }, {   7,  0, 1264 },
  {   7,  0, 1678 }, {  11,  0,  945 }, {  12,  0,  341 }, {  12,  0,  471 },
  { 140,  0,  569 }, { 132, 11,  709 }, { 133, 11,  897 }, {   5, 11,  224 },
  {  13, 11,  174 }, { 146, 11,   52 }, { 135, 11, 1840 }, { 134, 10, 1744 },
  {  12,  0,   87 }, {  16,  0,   74 }, {   4, 10,  733 }, {   9, 10,  194 },
  {  10, 10,   92 }, {  11, 10,  198 }, {  12, 10,   84 }, { 141, 10,  128 },
  { 140,  0,  779 }, { 135,  0,  538 }, {   4, 11,  608 }, { 133, 11,  497 },
  { 133,  0,  413 }, {   7, 11, 1375 }, {   7, 11, 1466 }, { 138, 11,  331 },
  { 136,  0,  495 }, {   6, 11,  540 }, { 136, 11,  136 }, {   7,  0,   54 },
  {   8,  0,  312 }, {  10,  0,  191 }, {  10,  0,  614 }, { 140,  0,  567 },
  {   6,  0,  468 }, {   7,  0,  567 }, {   7,  0, 1478 }, {   8,  0,  530 },
  {  14,  0,  290 }, { 133, 11,  999 }, {   4, 11,  299 }, {   7, 10,  306 },
  { 135, 11, 1004 }, { 142, 11,  296 }, { 134,  0, 1484 }, { 133, 10,  979 },
  {   6,  0,  609 }, {   9,  0,  815 }, {  12, 11,  137 }, {  14, 11,    9 },
  {  14, 11,   24 }, { 142, 11,   64 }, { 133, 11,  456 }, {   6,  0,  484 },
  { 135,  0,  822 }, { 133, 10,  178 }, { 136, 11,  180 }, { 132, 11,  755 },
  { 137,  0,  900 }, { 135,  0, 1335 }, {   6,  0, 1724 }, { 135,  0, 2022 },
  { 135, 11, 1139 }, {   5,  0,  640 }, { 132, 10,  390 }, {   6,  0, 1831 },
  { 138, 11,  633 }, { 135, 11,  566 }, {   4, 11,  890 }, {   5, 11,  805 },
  {   5, 11,  819 }, {   5, 11,  961 }, {   6, 11,  396 }, {   6, 11, 1631 },
  {   6, 11, 1678 }, {   7, 11, 1967 }, {   7, 11, 2041 }, {   9, 11,  630 },
  {  11, 11,    8 }, {  11, 11, 1019 }, {  12, 11,  176 }, {  13, 11,  225 },
  {  14, 11,  292 }, { 149, 11,   24 }, { 132,  0,  474 }, { 134,  0, 1103 },
  { 135,  0, 1504 }, { 134,  0, 1576 }, {   6,  0,  961 }, {   6,  0, 1034 },
  { 140,  0,  655 }, {  11, 11,  514 }, { 149, 11,   20 }, {   5,  0,  305 },
  { 135, 11, 1815 }, {   7, 11, 1505 }, {  10, 11,  190 }, {  10, 11,  634 },
  {  11, 11,  792 }, {  12, 11,  358 }, { 140, 11,  447 }, {   5, 11,    0 },
  {   6, 11,  536 }, {   7, 11,  604 }, {  13, 11,  445 }, { 145, 11,  126 },
  {   7,  0, 1236 }, { 133, 10,  105 }, {   4,  0,  480 }, {   6,  0,  217 },
  {   6,  0,  302 }, {   6,  0, 1642 }, {   7,  0,  130 }, {   7,  0,  837 },
  {   7,  0, 1321 }, {   7,  0, 1547 }, {   7,  0, 1657 }, {   8,  0,  429 },
  {   9,  0,  228 }, {  13,  0,  289 }, {  13,  0,  343 }, {  19,  0,  101 },
  {   6, 11,  232 }, {   6, 11,  412 }, {   7, 11, 1074 }, {   8, 11,    9 },
  {   8, 11,  157 }, {   8, 11,  786 }, {   9, 11,  196 }, {   9, 11,  352 },
  {   9, 11,  457 }, {  10, 11,  337 }, {  11, 11,  232 }, {  11, 11,  877 },
  {  12, 11,  480 }, { 140, 11,  546 }, {   5, 10,  438 }, {   7, 11,  958 },
  {   9, 10,  694 }, {  12, 10,  627 }, {  13, 11,   38 }, { 141, 10,  210 },
  {   4, 11,  382 }, { 136, 11,  579 }, {   7,  0,  278 }, {  10,  0,  739 },
  {  11,  0,  708 }, { 141,  0,  348 }, {   4, 11,  212 }, { 135, 11, 1206 },
  { 135, 11, 1898 }, {   6,  0,  708 }, {   6,  0, 1344 }, { 152, 10,   11 },
  { 137, 11,  768 }, { 134,  0, 1840 }, { 140,  0,  233 }, {   8, 10,   25 },
  { 138, 10,  826 }, {   6,  0, 2017 }, { 133, 11,  655 }, {   6,  0, 1488 },
  { 139, 11,  290 }, { 132, 10,  308 }, { 134,  0, 1590 }, { 134,  0, 1800 },
  { 134,  0, 1259 }, {  16,  0,   28 }, {   6, 11,  231 }, {   7, 11,   95 },
  { 136, 11,  423 }, { 133, 11,  300 }, { 135, 10,  150 }, { 136, 10,  649 },
  {   7, 11, 1874 }, { 137, 11,  641 }, {   6, 11,  237 }, {   7, 11,  611 },
  {   8, 11,  100 }, {   9, 11,  416 }, {  11, 11,  335 }, {  12, 11,  173 },
  { 146, 11,  101 }, { 137,  0,   45 }, { 134, 10,  521 }, {  17,  0,   36 },
  {  14, 11,   26 }, { 146, 11,  150 }, {   7,  0, 1442 }, {  14,  0,   22 },
  {   5, 10,  339 }, {  15, 10,   41 }, {  15, 10,  166 }, { 147, 10,   66 },
  {   8,  0,  378 }, {   6, 11,  581 }, { 135, 11, 1119 }, { 134,  0, 1507 },
  { 147, 11,  117 }, { 139,  0,   39 }, { 134,  0, 1054 }, {   6,  0,  363 },
  {   7,  0, 1955 }, { 136,  0,  725 }, { 134,  0, 2036 }, { 133, 11,  199 },
  {   6,  0, 1871 }, {   9,  0,  935 }, {   9,  0,  961 }, {   9,  0, 1004 },
  {   9,  0, 1016 }, {  12,  0,  805 }, {  12,  0,  852 }, {  12,  0,  853 },
  {  12,  0,  869 }, {  12,  0,  882 }, {  12,  0,  896 }, {  12,  0,  906 },
  {  12,  0,  917 }, {  12,  0,  940 }, {  15,  0,  170 }, {  15,  0,  176 },
  {  15,  0,  188 }, {  15,  0,  201 }, {  15,  0,  205 }, {  15,  0,  212 },
  {  15,  0,  234 }, {  15,  0,  244 }, {  18,  0,  181 }, {  18,  0,  193 },
  {  18,  0,  196 }, {  18,  0,  201 }, {  18,  0,  202 }, {  18,  0,  210 },
  {  18,  0,  217 }, {  18,  0,  235 }, {  18,  0,  236 }, {  18,  0,  237 },
  {  21,  0,   54 }, {  21,  0,   55 }, {  21,  0,   58 }, {  21,  0,   59 },
  { 152,  0,   22 }, { 134, 10, 1628 }, { 137,  0,  805 }, {   5,  0,  813 },
  { 135,  0, 2046 }, { 142, 11,   42 }, {   5,  0,  712 }, {   6,  0, 1240 },
  {  11,  0,   17 }, {  13,  0,  321 }, { 144,  0,   67 }, { 132,  0,  617 },
  { 135, 10,  829 }, {   6,  0,  320 }, {   7,  0,  781 }, {   7,  0, 1921 },
  {   9,  0,   55 }, {  10,  0,  186 }, {  10,  0,  273 }, {  10,  0,  664 },
  {  10,  0,  801 }, {  11,  0,  996 }, {  11,  0,  997 }, {  13,  0,  157 },
  { 142,  0,  170 }, { 136,  0,  271 }, {   5, 10,  486 }, { 135, 10, 1349 },
  {  18, 11,   91 }, { 147, 11,   70 }, {  10,  0,  445 }, {   7, 10, 1635 },
  {   8, 10,   17 }, { 138, 10,  295 }, { 136, 11,  404 }, {   7,  0,  103 },
  {   7,  0,  863 }, {  11,  0,  184 }, { 145,  0,   62 }, { 138, 10,  558 },
  { 137,  0,  659 }, {   6, 11,  312 }, {   6, 11, 1715 }, {  10, 11,  584 },
  {  11, 11,  546 }, {  11, 11,  692 }, {  12, 11,  259 }, {  12, 11,  295 },
  {  13, 11,   46 }, { 141, 11,  154 }, { 134,  0,  676 }, { 132, 11,  588 },
  {   4, 11,  231 }, {   5, 11,   61 }, {   6, 11,  104 }, {   7, 11,  729 },
  {   7, 11,  964 }, {   7, 11, 1658 }, { 140, 11,  414 }, {   6, 11,  263 },
  { 138, 11,  757 }, {  11,  0,  337 }, { 142,  0,  303 }, { 135, 11, 1363 },
  { 132, 11,  320 }, { 140,  0,  506 }, { 134, 10,  447 }, {   5,  0,   77 },
  {   7,  0, 1455 }, {  10,  0,  843 }, { 147,  0,   73 }, {   7, 10,  577 },
  {   7, 10, 1432 }, {   9, 10,  475 }, {   9, 10,  505 }, {   9, 10,  526 },
  {   9, 10,  609 }, {   9, 10,  689 }, {   9, 10,  726 }, {   9, 10,  735 },
  {   9, 10,  738 }, {  10, 10,  556 }, {  10, 10,  674 }, {  10, 10,  684 },
  {  11, 10,   89 }, {  11, 10,  202 }, {  11, 10,  272 }, {  11, 10,  380 },
  {  11, 10,  415 }, {  11, 10,  505 }, {  11, 10,  537 }, {  11, 10,  550 },
  {  11, 10,  562 }, {  11, 10,  640 }, {  11, 10,  667 }, {  11, 10,  688 },
  {  11, 10,  847 }, {  11, 10,  927 }, {  11, 10,  930 }, {  11, 10,  940 },
  {  12, 10,  144 }, {  12, 10,  325 }, {  12, 10,  329 }, {  12, 10,  389 },
  {  12, 10,  403 }, {  12, 10,  451 }, {  12, 10,  515 }, {  12, 10,  604 },
  {  12, 10,  616 }, {  12, 10,  626 }, {  13, 10,   66 }, {  13, 10,  131 },
  {  13, 10,  167 }, {  13, 10,  236 }, {  13, 10,  368 }, {  13, 10,  411 },
  {  13, 10,  434 }, {  13, 10,  453 }, {  13, 10,  461 }, {  13, 10,  474 },
  {  14, 10,   59 }, {  14, 10,   60 }, {  14, 10,  139 }, {  14, 10,  152 },
  {  14, 10,  276 }, {  14, 10,  353 }, {  14, 10,  402 }, {  15, 10,   28 },
  {  15, 10,   81 }, {  15, 10,  123 }, {  15, 10,  152 }, {  18, 10,  136 },
  { 148, 10,   88 }, { 132,  0,  458 }, { 135,  0, 1420 }, {   6,  0,  109 },
  {  10,  0,  382 }, {   4, 11,  405 }, {   4, 10,  609 }, {   7, 10,  756 },
  {   7, 11,  817 }, {   9, 10,  544 }, {  11, 10,  413 }, {  14, 11,   58 },
  {  14, 10,  307 }, {  16, 10,   25 }, {  17, 11,   37 }, { 146, 11,  124 },
  {   6,  0,  330 }, {   7,  0, 1084 }, {  11,  0,  142 }, { 133, 11,  974 },
  {   4, 10,  930 }, { 133, 10,  947 }, {   5, 10,  939 }, { 142, 11,  394 },
  {  16,  0,   91 }, { 145,  0,   87 }, {   5, 11,  235 }, {   5, 10,  962 },
  {   7, 11, 1239 }, {  11, 11,  131 }, { 140, 11,  370 }, {  11,  0,  492 },
  {   5, 10,  651 }, {   8, 10,  170 }, {   9, 10,   61 }, {   9, 10,   63 },
  {  10, 10,   23 }, {  10, 10,   37 }, {  10, 10,  834 }, {  11, 10,    4 },
  {  11, 10,  281 }, {  11, 10,  503 }, {  11, 10,  677 }, {  12, 10,   96 },
  {  12, 10,  130 }, {  12, 10,  244 }, {  14, 10,    5 }, {  14, 10,   40 },
  {  14, 10,  162 }, {  14, 10,  202 }, { 146, 10,  133 }, {   4, 10,  406 },
  {   5, 10,  579 }, {  12, 10,  492 }, { 150, 10,   15 }, {   9, 11,  137 },
  { 138, 11,  221 }, { 134,  0, 1239 }, {  11,  0,  211 }, { 140,  0,  145 },
  {   7, 11,  390 }, { 138, 11,  140 }, { 135, 11, 1418 }, { 135, 11, 1144 },
  { 134,  0, 1049 }, {   7,  0,  321 }, {   6, 10,   17 }, {   7, 10, 1001 },
  {   7, 10, 1982 }, {   9, 10,  886 }, {  10, 10,  489 }, {  10, 10,  800 },
  {  11, 10,  782 }, {  12, 10,  320 }, {  13, 10,  467 }, {  14, 10,  145 },
  {  14, 10,  387 }, { 143, 10,  119 }, { 145, 10,   17 }, {   5, 11,  407 },
  {  11, 11,  489 }, {  19, 11,   37 }, {  20, 11,   73 }, { 150, 11,   38 },
  { 133, 10,  458 }, { 135,  0, 1985 }, {   7, 10, 1983 }, {   8, 10,    0 },
  {   8, 10,  171 }, {   9, 10,  120 }, {   9, 10,  732 }, {  10, 10,  473 },
  {  11, 10,  656 }, {  11, 10,  998 }, {  18, 10,    0 }, {  18, 10,    2 },
  { 147, 10,   21 }, {   5, 11,  325 }, {   7, 11, 1483 }, {   8, 11,    5 },
  {   8, 11,  227 }, {   9, 11,  105 }, {  10, 11,  585 }, { 140, 11,  614 },
  { 136,  0,  122 }, { 132,  0,  234 }, { 135, 11, 1196 }, {   6,  0,  976 },
  {   6,  0, 1098 }, { 134,  0, 1441 }, {   7,  0,  253 }, { 136,  0,  549 },
  {   6, 11,  621 }, {  13, 11,  504 }, { 144, 11,   19 }, { 132, 10,  519 },
  {   5,  0,  430 }, {   5,  0,  932 }, {   6,  0,  131 }, {   7,  0,  417 },
  {   9,  0,  522 }, {  11,  0,  314 }, { 141,  0,  390 }, {  14,  0,  149 },
  {  14,  0,  399 }, { 143,  0,   57 }, {   5, 10,  907 }, {   6, 10,   31 },
  {   6, 11,  218 }, {   7, 10,  491 }, {   7, 10,  530 }, {   8, 10,  592 },
  {  11, 10,   53 }, {  11, 10,  779 }, {  12, 10,  167 }, {  12, 10,  411 },
  {  14, 10,   14 }, {  14, 10,  136 }, {  15, 10,   72 }, {  16, 10,   17 },
  { 144, 10,   72 }, { 140, 11,  330 }, {   7, 11,  454 }, {   7, 11,  782 },
  { 136, 11,  768 }, { 132,  0,  507 }, {  10, 11,  676 }, { 140, 11,  462 },
  {   6,  0,  630 }, {   9,  0,  811 }, {   4, 10,  208 }, {   5, 10,  106 },
  {   6, 10,  531 }, {   8, 10,  408 }, {   9, 10,  188 }, { 138, 10,  572 },
  {   4,  0,  343 }, {   5,  0,  511 }, { 134, 10, 1693 }, { 134, 11,  164 },
  { 132,  0,  448 }, {   7,  0,  455 }, { 138,  0,  591 }, { 135,  0, 1381 },
  {  12, 10,  441 }, { 150, 11,   50 }, {   9, 10,  449 }, {  10, 10,  192 },
  { 138, 10,  740 }, {   6,  0,  575 }, { 132, 10,  241 }, { 134,  0, 1175 },
  { 134,  0,  653 }, { 134,  0, 1761 }, { 134,  0, 1198 }, { 132, 10,  259 },
  {   6, 11,  343 }, {   7, 11,  195 }, {   9, 11,  226 }, {  10, 11,  197 },
  {  10, 11,  575 }, {  11, 11,  502 }, { 139, 11,  899 }, {   7,  0, 1127 },
  {   7,  0, 1572 }, {  10,  0,  297 }, {  10,  0,  422 }, {  11,  0,  764 },
  {  11,  0,  810 }, {  12,  0,  264 }, {  13,  0,  102 }, {  13,  0,  300 },
  {  13,  0,  484 }, {  14,  0,  147 }, {  14,  0,  229 }, {  17,  0,   71 },
  {  18,  0,  118 }, { 147,  0,  120 }, { 135, 11,  666 }, { 132,  0,  678 },
  {   4, 10,  173 }, {   5, 10,  312 }, {   5, 10,  512 }, { 135, 10, 1285 },
  {   7, 10, 1603 }, {   7, 10, 1691 }, {   9, 10,  464 }, {  11, 10,  195 },
  {  12, 10,  279 }, {  12, 10,  448 }, {  14, 10,   11 }, { 147, 10,  102 },
  {  16,  0,   99 }, { 146,  0,  164 }, {   7, 11, 1125 }, {   9, 11,  143 },
  {  11, 11,   61 }, {  14, 11,  405 }, { 150, 11,   21 }, { 137, 11,  260 },
  {   4, 10,  452 }, {   5, 10,  583 }, {   5, 10,  817 }, {   6, 10,  433 },
  {   7, 10,  593 }, {   7, 10,  720 }, {   7, 10, 1378 }, {   8, 10,  161 },
  {   9, 10,  284 }, {  10, 10,  313 }, { 139, 10,  886 }, { 132, 10,  547 },
  { 136, 10,  722 }, {  14,  0,   35 }, { 142,  0,  191 }, { 141,  0,   45 },
  { 138,  0,  121 }, { 132,  0,  125 }, { 134,  0, 1622 }, { 133, 11,  959 },
  {   8, 10,  420 }, { 139, 10,  193 }, { 132,  0,  721 }, { 135, 10,  409 },
  { 136,  0,  145 }, {   7,  0,  792 }, {   8,  0,  147 }, {  10,  0,  821 },
  {  11,  0,  970 }, {  11,  0, 1021 }, { 136, 11,  173 }, { 134, 11,  266 },
  { 132,  0,  715 }, {   7,  0, 1999 }, { 138, 10,  308 }, { 133,  0,  531 },
  {   5,  0,  168 }, {   5,  0,  930 }, {   8,  0,   74 }, {   9,  0,  623 },
  {  12,  0,  500 }, { 140,  0,  579 }, { 144,  0,   65 }, { 138, 11,  246 },
  {   6,  0,  220 }, {   7,  0, 1101 }, {  13,  0,  105 }, { 142, 11,  314 },
  {   5, 10, 1002 }, { 136, 10,  745 }, { 134,  0,  960 }, {  20,  0,    0 },
  { 148, 11,    0 }, {   4,  0, 1005 }, {   4, 10,  239 }, {   6, 10,  477 },
  {   7, 10, 1607 }, {  11, 10,   68 }, { 139, 10,  617 }, {   6,  0,   19 },
  {   7,  0, 1413 }, { 139,  0,  428 }, { 149, 10,   13 }, {   7,  0,   96 },
  {   8,  0,  401 }, {   8,  0,  703 }, {   9,  0,  896 }, { 136, 11,  300 },
  { 134,  0, 1595 }, { 145,  0,  116 }, { 136,  0, 1021 }, {   7,  0, 1961 },
  {   7,  0, 1965 }, {   7,  0, 2030 }, {   8,  0,  150 }, {   8,  0,  702 },
  {   8,  0,  737 }, {   8,  0,  750 }, { 140,  0,  366 }, {  11, 11,   75 },
  { 142, 11,  267 }, { 132, 10,  367 }, {   8,  0,  800 }, {   9,  0,  148 },
  {   9,  0,  872 }, {   9,  0,  890 }, {  11,  0,  309 }, {  11,  0, 1001 },
  {  13,  0,  267 }, {  13,  0,  323 }, {   5, 11,  427 }, {   5, 11,  734 },
  {   7, 11,  478 }, { 136, 11,   52 }, {   7, 11,  239 }, {  11, 11,  217 },
  { 142, 11,  165 }, { 132, 11,  323 }, { 140, 11,  419 }, {  13,  0,  299 },
  { 142,  0,   75 }, {   6, 11,   87 }, {   6, 11, 1734 }, {   7, 11,   20 },
  {   7, 11, 1056 }, {   8, 11,  732 }, {   9, 11,  406 }, {   9, 11,  911 },
  { 138, 11,  694 }, { 134,  0, 1383 }, { 132, 10,  694 }, { 133, 11,  613 },
  { 137,  0,  779 }, {   4,  0,  598 }, { 140, 10,  687 }, {   6,  0,  970 },
  { 135,  0,  424 }, { 133,  0,  547 }, {   7, 11,   32 }, {   7, 11,  984 },
  {   8, 11,   85 }, {   8, 11,  709 }, {   9, 11,  579 }, {   9, 11,  847 },
  {   9, 11,  856 }, {  10, 11,  799 }, {  11, 11,  258 }, {  11, 11, 1007 },
  {  12, 11,  331 }, {  12, 11,  615 }, {  13, 11,  188 }, {  13, 11,  435 },
  {  14, 11,    8 }, {  15, 11,  165 }, {  16, 11,   27 }, { 148, 11,   40 },
  {   6,  0, 1222 }, { 134,  0, 1385 }, { 132,  0,  876 }, { 138, 11,  151 },
  { 135, 10,  213 }, {   4, 11,  167 }, { 135, 11,   82 }, { 133,  0,  133 },
  {   6, 11,   24 }, {   7, 11,   74 }, {   7, 11,  678 }, { 137, 11,  258 },
  {   5, 11,   62 }, {   6, 11,  534 }, {   7, 11,  684 }, {   7, 11, 1043 },
  {   7, 11, 1072 }, {   8, 11,  280 }, {   8, 11,  541 }, {   8, 11,  686 },
  {  10, 11,  519 }, {  11, 11,  252 }, { 140, 11,  282 }, { 136,  0,  187 },
  {   8,  0,    8 }, {  10,  0,    0 }, {  10,  0,  818 }, { 139,  0,  988 },
  { 132, 11,  359 }, {  11,  0,  429 }, {  15,  0,   51 }, { 135, 10, 1672 },
  { 136,  0,  685 }, {   5, 11,  211 }, {   7, 11,   88 }, { 136, 11,  627 },
  { 134,  0,  472 }, { 136,  0,  132 }, {   6, 11,  145 }, { 141, 11,  336 },
  {   4, 10,  751 }, {  11, 10,  390 }, { 140, 10,   32 }, {   6,  0,  938 },
  {   6,  0, 1060 }, {   4, 11,  263 }, {   4, 10,  409 }, { 133, 10,   78 },
  { 137,  0,  874 }, {   8,  0,  774 }, {  10,  0,  670 }, {  12,  0,   51 },
  {   4, 11,  916 }, {   6, 10,  473 }, {   7, 10, 1602 }, {  10, 10,  698 },
  {  12, 10,  212 }, {  13, 10,  307 }, { 145, 10,  105 }, { 146,  0,   92 },
  { 143, 10,  156 }, { 132,  0,  830 }, { 137,  0,  701 }, {   4, 11,  599 },
  {   6, 11, 1634 }, {   7, 11,    5 }, {   7, 11,   55 }, {   7, 11,   67 },
  {   7, 11,   97 }, {   7, 11,  691 }, {   7, 11,  979 }, {   7, 11, 1697 },
  {   8, 11,  207 }, {   8, 11,  214 }, {   8, 11,  231 }, {   8, 11,  294 },
  {   8, 11,  336 }, {   8, 11,  428 }, {   8, 11,  451 }, {   8, 11,  460 },
  {   8, 11,  471 }, {   8, 11,  622 }, {   8, 11,  626 }, {   8, 11,  679 },
  {   8, 11,  759 }, {   8, 11,  829 }, {   9, 11,   11 }, {   9, 11,  246 },
  {   9, 11,  484 }, {   9, 11,  573 }, {   9, 11,  706 }, {   9, 11,  762 },
  {   9, 11,  798 }, {   9, 11,  855 }, {   9, 11,  870 }, {   9, 11,  912 },
  {  10, 11,  303 }, {  10, 11,  335 }, {  10, 11,  424 }, {  10, 11,  461 },
  {  10, 11,  543 }, {  10, 11,  759 }, {  10, 11,  814 }, {  11, 11,   59 },
  {  11, 11,  199 }, {  11, 11,  235 }, {  11, 11,  475 }, {  11, 11,  590 },
  {  11, 11,  929 }, {  11, 11,  963 }, {  12, 11,  114 }, {  12, 11,  182 },
  {  12, 11,  226 }, {  12, 11,  332 }, {  12, 11,  439 }, {  12, 11,  575 },
  {  12, 11,  598 }, {  13, 11,    8 }, {  13, 11,  125 }, {  13, 11,  194 },
  {  13, 11,  287 }, {  14, 11,  197 }, {  14, 11,  383 }, {  15, 11,   53 },
  {  17, 11,   63 }, {  19, 11,   46 }, {  19, 11,   98 }, {  19, 11,  106 },
  { 148, 11,   85 }, {   4,  0,  127 }, {   5,  0,  350 }, {   6,  0,  356 },
  {   8,  0,  426 }, {   9,  0,  572 }, {  10,  0,  247 }, { 139,  0,  312 },
  { 134,  0, 1215 }, {   6,  0,   59 }, {   9,  0,  603 }, {  13,  0,  397 },
  {   7, 11, 1853 }, { 138, 11,  437 }, { 134,  0, 1762 }, { 147, 11,  126 },
  { 135, 10,  883 }, {  13,  0,  293 }, { 142,  0,   56 }, { 133, 10,  617 },
  { 139, 10,   50 }, {   5, 11,  187 }, {   7, 10, 1518 }, { 139, 10,  694 },
  { 135,  0,  441 }, {   6,  0,  111 }, {   7,  0,    4 }, {   8,  0,  163 },
  {   8,  0,  776 }, { 138,  0,  566 }, { 132,  0,  806 }, {   4, 11,  215 },
  {   9, 11,   38 }, {  10, 11,    3 }, {  11, 11,   23 }, {  11, 11,  127 },
  { 139, 11,  796 }, {  14,  0,  233 }, {   4, 10,  546 }, { 135, 10, 2042 },
  { 135,  0, 1994 }, { 134,  0, 1739 }, { 135, 11, 1530 }, { 136,  0,  393 },
  {   5,  0,  297 }, {   7,  0, 1038 }, {  14,  0,  359 }, {  19,  0,   52 },
  { 148,  0,   47 }, { 135,  0,  309 }, {   4, 10,  313 }, { 133, 10,  577 },
  {   8, 10,  184 }, { 141, 10,  433 }, { 135, 10,  935 }, {  12, 10,  186 },
  {  12, 10,  292 }, {  14, 10,  100 }, { 146, 10,   70 }, { 136,  0,  363 },
  {  14,  0,  175 }, {  11, 10,  402 }, {  12, 10,  109 }, {  12, 10,  431 },
  {  13, 10,  179 }, {  13, 10,  206 }, {  14, 10,  217 }, {  16, 10,    3 },
  { 148, 10,   53 }, {   5, 10,  886 }, {   6, 10,   46 }, {   6, 10, 1790 },
  {   7, 10,   14 }, {   7, 10,  732 }, {   7, 10, 1654 }, {   8, 10,   95 },
  {   8, 10,  327 }, {   8, 10,  616 }, {   9, 10,  892 }, {  10, 10,  598 },
  {  10, 10,  769 }, {  11, 10,  134 }, {  11, 10,  747 }, {  12, 10,  378 },
  { 142, 10,   97 }, { 136,  0,  666 }, { 135,  0, 1675 }, {   6,  0,  655 },
  { 134,  0, 1600 }, { 135,  0,  808 }, { 133, 10, 1021 }, {   4, 11,   28 },
  {   5, 11,  440 }, {   7, 11,  248 }, {  11, 11,  833 }, { 140, 11,  344 },
  { 134, 11, 1654 }, { 132,  0,  280 }, { 140,  0,   54 }, {   4,  0,  421 },
  { 133,  0,  548 }, { 132, 10,  153 }, {   6, 11,  339 }, { 135, 11,  923 },
  { 133, 11,  853 }, { 133, 10,  798 }, { 132, 10,  587 }, {   6, 11,  249 },
  {   7, 11, 1234 }, { 139, 11,  573 }, {   6, 10,  598 }, {   7, 10,   42 },
  {   8, 10,  695 }, {  10, 10,  212 }, {  11, 10,  158 }, {  14, 10,  196 },
  { 145, 10,   85 }, {   7,  0,  249 }, {   5, 10,  957 }, { 133, 10, 1008 },
  {   4, 10,  129 }, { 135, 10,  465 }, {   6,  0,  254 }, {   7,  0,  842 },
  {   7,  0, 1659 }, {   9,  0,  109 }, {  10,  0,  103 }, {   7, 10,  908 },
  {   7, 10, 1201 }, {   9, 10,  755 }, {  11, 10,  906 }, {  12, 10,  527 },
  { 146, 10,    7 }, {   5,  0,  262 }, { 136, 10,  450 }, { 144,  0,    1 },
  {  10, 11,  201 }, { 142, 11,  319 }, {   7, 11,   49 }, {   7, 11,  392 },
  {   8, 11,   20 }, {   8, 11,  172 }, {   8, 11,  690 }, {   9, 11,  383 },
  {   9, 11,  845 }, {  10, 11,   48 }, {  11, 11,  293 }, {  11, 11,  832 },
  {  11, 11,  920 }, { 141, 11,  221 }, {   5, 11,  858 }, { 133, 11,  992 },
  { 134,  0,  805 }, { 139, 10, 1003 }, {   6,  0, 1630 }, { 134, 11,  307 },
  {   7, 11, 1512 }, { 135, 11, 1794 }, {   6, 11,  268 }, { 137, 11,   62 },
  { 135, 10, 1868 }, { 133,  0,  671 }, {   4,  0,  989 }, {   8,  0,  972 },
  { 136,  0,  998 }, { 132, 11,  423 }, { 132,  0,  889 }, { 135,  0, 1382 },
  { 135,  0, 1910 }, {   7, 10,  965 }, {   7, 10, 1460 }, { 135, 10, 1604 },
  {   4,  0,  627 }, {   5,  0,  775 }, { 138, 11,  106 }, { 134, 11,  348 },
  {   7,  0,  202 }, {  11,  0,  362 }, {  11,  0,  948 }, { 140,  0,  388 },
  { 138, 11,  771 }, {   6, 11,  613 }, { 136, 11,  223 }, {   6,  0,  560 },
  {   7,  0,  451 }, {   8,  0,  389 }, {  12,  0,  490 }, {  13,  0,   16 },
  {  13,  0,  215 }, {  13,  0,  351 }, {  18,  0,  132 }, { 147,  0,  125 },
  { 135,  0,  841 }, { 136,  0,  566 }, { 136,  0,  938 }, { 132, 11,  670 },
  {   5,  0,  912 }, {   6,  0, 1695 }, { 140, 11,   55 }, {   9, 11,   40 },
  { 139, 11,  136 }, {   7,  0, 1361 }, {   7, 10,  982 }, {  10, 10,   32 },
  { 143, 10,   56 }, {  11, 11,  259 }, { 140, 11,  270 }, {   5,  0,  236 },
  {   6,  0,  572 }, {   8,  0,  492 }, {  11,  0,  618 }, { 144,  0,   56 },
  {   8, 11,  572 }, {   9, 11,  310 }, {   9, 11,  682 }, { 137, 11,  698 },
  { 134,  0, 1854 }, {   5,  0,  190 }, { 136,  0,  318 }, { 133, 10,  435 },
  { 135,  0, 1376 }, {   4, 11,  296 }, {   6, 11,  352 }, {   7, 11,  401 },
  {   7, 11, 1410 }, {   7, 11, 1594 }, {   7, 11, 1674 }, {   8, 11,   63 },
  {   8, 11,  660 }, { 137, 11,   74 }, {   7,  0,  349 }, {   5, 10,   85 },
  {   6, 10,  419 }, {   7, 10,  305 }, {   7, 10,  361 }, {   7, 10, 1337 },
  {   8, 10,   71 }, { 140, 10,  519 }, {   4, 11,  139 }, {   4, 11,  388 },
  { 140, 11,  188 }, {   6,  0, 1972 }, {   6,  0, 2013 }, {   8,  0,  951 },
  {  10,  0,  947 }, {  10,  0,  974 }, {  10,  0, 1018 }, { 142,  0,  476 },
  { 140, 10,  688 }, { 135, 10,  740 }, {   5, 10,  691 }, {   7, 10,  345 },
  {   9, 10,   94 }, { 140, 10,  169 }, {   9,  0,  344 }, {   5, 10,  183 },
  {   6, 10,  582 }, {  10, 10,  679 }, { 140, 10,  435 }, { 135, 10,  511 },
  { 132,  0,  850 }, {   8, 11,  441 }, {  10, 11,  314 }, { 143, 11,    3 },
  {   7, 10, 1993 }, { 136, 10,  684 }, {   4, 11,  747 }, {   6, 11,  290 },
  {   6, 10,  583 }, {   7, 11,  649 }, {   7, 11, 1479 }, { 135, 11, 1583 },
  { 133, 11,  232 }, { 133, 10,  704 }, { 134,  0,  910 }, {   4, 10,  179 },
  {   5, 10,  198 }, { 133, 10,  697 }, {   7, 10,  347 }, {   7, 10,  971 },
  {   8, 10,  181 }, { 138, 10,  711 }, { 136, 11,  525 }, {  14,  0,   19 },
  {  14,  0,   28 }, { 144,  0,   29 }, {   7,  0,   85 }, {   7,  0,  247 },
  {   8,  0,  585 }, { 138,  0,  163 }, {   4,  0,  487 }, {   7, 11,  472 },
  {   7, 11, 1801 }, {  10, 11,  748 }, { 141, 11,  458 }, {   4, 10,  243 },
  {   5, 10,  203 }, {   7, 10,   19 }, {   7, 10,   71 }, {   7, 10,  113 },
  {  10, 10,  405 }, {  11, 10,  357 }, { 142, 10,  240 }, {   7, 10, 1450 },
  { 139, 10,   99 }, { 132, 11,  425 }, { 138,  0,  145 }, { 147,  0,   83 },
  {   6, 10,  492 }, { 137, 11,  247 }, {   4,  0, 1013 }, { 134,  0, 2033 },
  {   5, 10,  134 }, {   6, 10,  408 }, {   6, 10,  495 }, { 135, 10, 1593 },
  { 135,  0, 1922 }, { 134, 11, 1768 }, {   4,  0,  124 }, {  10,  0,  457 },
  {  11,  0,  121 }, {  11,  0,  169 }, {  11,  0,  870 }, {  11,  0,  874 },
  {  12,  0,  214 }, {  14,  0,  187 }, { 143,  0,   77 }, {   5,  0,  557 },
  { 135,  0, 1457 }, { 139,  0,   66 }, {   5, 11,  943 }, {   6, 11, 1779 },
  { 142, 10,    4 }, {   4, 10,  248 }, {   4, 10,  665 }, {   7, 10,  137 },
  { 137, 10,  349 }, {   7,  0, 1193 }, {   5, 11,  245 }, {   6, 11,  576 },
  {   7, 11,  582 }, { 136, 11,  225 }, { 144,  0,   82 }, {   7, 10, 1270 },
  { 139, 10,  612 }, {   5,  0,  454 }, {  10,  0,  352 }, { 138, 11,  352 },
  {  18,  0,   57 }, {   5, 10,  371 }, { 135, 10,  563 }, { 135,  0, 1333 },
  {   6,  0,  107 }, {   7,  0,  638 }, {   7,  0, 1632 }, {   9,  0,  396 },
  { 134, 11,  610 }, {   5,  0,  370 }, { 134,  0, 1756 }, {   4, 10,  374 },
  {   7, 10,  547 }, {   7, 10, 1700 }, {   7, 10, 1833 }, { 139, 10,  858 },
  { 133,  0,  204 }, {   6,  0, 1305 }, {   9, 10,  311 }, { 141, 10,   42 },
  {   5,  0,  970 }, { 134,  0, 1706 }, {   6, 10, 1647 }, {   7, 10, 1552 },
  {   7, 10, 2010 }, {   9, 10,  494 }, { 137, 10,  509 }, {  13, 11,  455 },
  {  15, 11,   99 }, {  15, 11,  129 }, { 144, 11,   68 }, { 135,  0,    3 },
  {   4,  0,   35 }, {   5,  0,  121 }, {   5,  0,  483 }, {   5,  0,  685 },
  {   6,  0,  489 }, {   6,  0,  782 }, {   6,  0, 1032 }, {   7,  0, 1204 },
  { 136,  0,  394 }, {   4,  0,  921 }, { 133,  0, 1007 }, {   8, 11,  360 },
  { 138, 11,   63 }, { 135,  0, 1696 }, { 134,  0, 1519 }, { 132, 11,  443 },
  { 135, 11,  944 }, {   6, 10,  123 }, {   7, 10,  214 }, {   9, 10,  728 },
  {  10, 10,  157 }, {  11, 10,  346 }, {  11, 10,  662 }, { 143, 10,  106 },
  { 137,  0,  981 }, { 135, 10, 1435 }, { 134,  0, 1072 }, { 132,  0,  712 },
  { 134,  0, 1629 }, { 134,  0,  728 }, {   4, 11,  298 }, { 137, 11,  483 },
  {   6,  0, 1177 }, {   6,  0, 1271 }, {   5, 11,  164 }, {   7, 11,  121 },
  { 142, 11,  189 }, {   7,  0, 1608 }, {   4, 10,  707 }, {   5, 10,  588 },
  {   6, 10,  393 }, {  13, 10,  106 }, {  18, 10,   49 }, { 147, 10,   41 },
  {  23,  0,   16 }, { 151, 11,   16 }, {   6, 10,  211 }, {   7, 10, 1690 },
  {  11, 10,  486 }, { 140, 10,  369 }, { 133,  0,  485 }, {  19, 11,   15 },
  { 149, 11,   27 }, {   4, 11,  172 }, {   9, 11,  611 }, {  10, 11,  436 },
  {  12, 11,  673 }, { 141, 11,  255 }, {   5, 11,  844 }, {  10, 11,  484 },
  {  11, 11,  754 }, {  12, 11,  457 }, {  14, 11,  171 }, {  14, 11,  389 },
  { 146, 11,  153 }, {   4,  0,  285 }, {   5,  0,   27 }, {   5,  0,  317 },
  {   6,  0,  301 }, {   7,  0,    7 }, {   8,  0,  153 }, {  10,  0,  766 },
  {  11,  0,  468 }, {  12,  0,  467 }, { 141,  0,  143 }, { 134,  0, 1462 },
  {   9, 11,  263 }, {  10, 11,  147 }, { 138, 11,  492 }, { 133, 11,  537 },
  {   6,  0, 1945 }, {   6,  0, 1986 }, {   6,  0, 1991 }, { 134,  0, 2038 },
  { 134, 10,  219 }, { 137, 11,  842 }, {  14,  0,   52 }, {  17,  0,   50 },
  {   5, 10,  582 }, {   6, 10, 1646 }, {   7, 10,   99 }, {   7, 10, 1962 },
  {   7, 10, 1986 }, {   8, 10,  515 }, {   8, 10,  773 }, {   9, 10,   23 },
  {   9, 10,  491 }, {  12, 10,  620 }, { 142, 10,   93 }, { 138, 11,   97 },
  {  20,  0,   21 }, {  20,  0,   44 }, { 133, 10,  851 }, { 136,  0,  819 },
  { 139,  0,  917 }, {   5, 11,  230 }, {   5, 11,  392 }, {   6, 11,  420 },
  {   8, 10,  762 }, {   8, 10,  812 }, {   9, 11,  568 }, {   9, 10,  910 },
  { 140, 11,  612 }, { 135,  0,  784 }, {  15,  0,  135 }, { 143, 11,  135 },
  {  10,  0,  454 }, { 140,  0,  324 }, {   4, 11,    0 }, {   5, 11,   41 },
  {   7, 11, 1459 }, {   7, 11, 1469 }, {   7, 11, 1618 }, {   7, 11, 1859 },
  {   9, 11,  549 }, { 139, 11,  905 }, {   4, 10,   98 }, {   7, 10, 1365 },
  {   9, 10,  422 }, {   9, 10,  670 }, {  10, 10,  775 }, {  11, 10,  210 },
  {  13, 10,   26 }, {  13, 10,  457 }, { 141, 10,  476 }, {   6,  0, 1719 },
  {   6,  0, 1735 }, {   7,  0, 2016 }, {   7,  0, 2020 }, {   8,  0,  837 },
  { 137,  0,  852 }, { 133, 11,  696 }, { 135,  0,  852 }, { 132,  0,  952 },
  { 134, 10, 1730 }, { 132, 11,  771 }, { 138,  0,  568 }, { 137,  0,  448 },
  { 139,  0,  146 }, {   8,  0,   67 }, { 138,  0,  419 }, { 133, 11,  921 },
  { 137, 10,  147 }, { 134,  0, 1826 }, {  10,  0,  657 }, {  14,  0,  297 },
  { 142,  0,  361 }, {   6,  0,  666 }, {   6,  0,  767 }, { 134,  0, 1542 },
  { 139,  0,  729 }, {   6, 11,  180 }, {   7, 11, 1137 }, {   8, 11,  751 },
  { 139, 11,  805 }, {   4, 11,  183 }, {   7, 11,  271 }, {  11, 11,  824 },
  {  11, 11,  952 }, {  13, 11,  278 }, {  13, 11,  339 }, {  13, 11,  482 },
  {  14, 11,  424 }, { 148, 11,   99 }, {   4,  0,  669 }, {   5, 11,  477 },
  {   5, 11,  596 }, {   6, 11,  505 }, {   7, 11, 1221 }, {  11, 11,  907 },
  {  12, 11,  209 }, { 141, 11,  214 }, { 135, 11, 1215 }, {   5,  0,  402 },
  {   6, 10,   30 }, {  11, 10,   56 }, { 139, 10,  305 }, {   7, 11,  564 },
  { 142, 11,  168 }, { 139,  0,  152 }, {   7,  0,  912 }, { 135, 10, 1614 },
  {   4, 10,  150 }, {   5, 10,  303 }, { 134, 10,  327 }, {   7,  0,  320 },
  {   8,  0,   51 }, {   9,  0,  868 }, {  10,  0,  833 }, {  12,  0,  481 },
  {  12,  0,  570 }, { 148,  0,  106 }, { 132,  0,  445 }, {   7, 11,  274 },
  {  11, 11,  263 }, {  11, 11,  479 }, {  11, 11,  507 }, { 140, 11,  277 },
  {  10,  0,  555 }, {  11,  0,  308 }, {  19,  0,   95 }, {   6, 11, 1645 },
  {   8, 10,  192 }, {  10, 10,   78 }, { 141, 10,  359 }, { 135, 10,  786 },
  {   6, 11,   92 }, {   6, 11,  188 }, {   7, 11, 1269 }, {   7, 11, 1524 },
  {   7, 11, 1876 }, {  10, 11,  228 }, { 139, 11, 1020 }, {   4, 11,  459 },
  { 133, 11,  966 }, {  11,  0,  386 }, {   6, 10, 1638 }, {   7, 10,   79 },
  {   7, 10,  496 }, {   9, 10,  138 }, {  10, 10,  336 }, {  12, 10,  412 },
  {  12, 10,  440 }, { 142, 10,  305 }, { 133,  0,  239 }, {   7,  0,   83 },
  {   7,  0, 1990 }, {   8,  0,  130 }, { 139,  0,  720 }, { 138, 11,  709 },
  {   4,  0,  143 }, {   5,  0,  550 }, { 133,  0,  752 }, {   5,  0,  123 },
  {   6,  0,  530 }, {   7,  0,  348 }, { 135,  0, 1419 }, { 135,  0, 2024 },
  {   6, 11,   18 }, {   7, 11,  179 }, {   7, 11,  721 }, {   7, 11,  932 },
  {   8, 11,  548 }, {   8, 11,  757 }, {   9, 11,   54 }, {   9, 11,   65 },
  {   9, 11,  532 }, {   9, 11,  844 }, {  10, 11,  113 }, {  10, 11,  117 },
  {  10, 11,  236 }, {  10, 11,  315 }, {  10, 11,  430 }, {  10, 11,  798 },
  {  11, 11,  153 }, {  11, 11,  351 }, {  11, 11,  375 }, {  12, 11,   78 },
  {  12, 11,  151 }, {  12, 11,  392 }, {  14, 11,  248 }, { 143, 11,   23 },
  {   7, 10,  204 }, {   7, 10,  415 }, {   8, 10,   42 }, {  10, 10,   85 },
  { 139, 10,  564 }, { 134,  0,  958 }, { 133, 11,  965 }, { 132,  0,  210 },
  { 135, 11, 1429 }, { 138, 11,  480 }, { 134, 11,  182 }, { 139, 11,  345 },
  {  10, 11,   65 }, {  10, 11,  488 }, { 138, 11,  497 }, {   4, 10,    3 },
  {   5, 10,  247 }, {   5, 10,  644 }, {   7, 10,  744 }, {   7, 10, 1207 },
  {   7, 10, 1225 }, {   7, 10, 1909 }, { 146, 10,  147 }, { 132,  0,  430 },
  {   5, 10,  285 }, {   9, 10,   67 }, {  13, 10,  473 }, { 143, 10,   82 },
  { 144, 11,   16 }, {   7, 11, 1162 }, {   9, 11,  588 }, {  10, 11,  260 },
  { 151, 10,    8 }, { 133,  0,  213 }, { 138,  0,    7 }, { 135,  0,  801 },
  { 134, 11, 1786 }, { 135, 11,  308 }, {   6,  0,  936 }, { 134,  0, 1289 },
  { 133,  0,  108 }, { 132,  0,  885 }, { 133,  0,  219 }, { 139,  0,  587 },
  {   4,  0,  193 }, {   5,  0,  916 }, {   6,  0, 1041 }, {   7,  0,  364 },
  {  10,  0,  398 }, {  10,  0,  726 }, {  11,  0,  317 }, {  11,  0,  626 },
  {  12,  0,  142 }, {  12,  0,  288 }, {  12,  0,  678 }, {  13,  0,  313 },
  {  15,  0,  113 }, { 146,  0,  114 }, { 135,  0, 1165 }, {   6,  0,  241 },
  {   9,  0,  342 }, {  10,  0,  729 }, {  11,  0,  284 }, {  11,  0,  445 },
  {  11,  0,  651 }, {  11,  0,  863 }, {  13,  0,  398 }, { 146,  0,   99 },
  {   7,  0,  907 }, { 136,  0,  832 }, {   9,  0,  303 }, {   4, 10,   29 },
  {   6, 10,  532 }, {   7, 10, 1628 }, {   7, 10, 1648 }, {   9, 10,  350 },
  {  10, 10,  433 }, {  11, 10,   97 }, {  11, 10,  557 }, {  11, 10,  745 },
  {  12, 10,  289 }, {  12, 10,  335 }, {  12, 10,  348 }, {  12, 10,  606 },
  {  13, 10,  116 }, {  13, 10,  233 }, {  13, 10,  466 }, {  14, 10,  181 },
  {  14, 10,  209 }, {  14, 10,  232 }, {  14, 10,  236 }, {  14, 10,  300 },
  {  16, 10,   41 }, { 148, 10,   97 }, {   7, 11,  423 }, {   7, 10, 1692 },
  { 136, 11,  588 }, {   6,  0,  931 }, { 134,  0, 1454 }, {   5, 10,  501 },
  {   7, 10, 1704 }, {   9, 10,  553 }, {  11, 10,  520 }, {  12, 10,  557 },
  { 141, 10,  249 }, { 136, 11,  287 }, {   4,  0,  562 }, {   9,  0,  254 },
  { 139,  0,  879 }, { 132,  0,  786 }, {  14, 11,   32 }, {  18, 11,   85 },
  {  20, 11,    2 }, { 152, 11,   16 }, { 135,  0, 1294 }, {   7, 11,  723 },
  { 135, 11, 1135 }, {   6,  0,  216 }, {   7,  0,  901 }, {   7,  0, 1343 },
  {   8,  0,  493 }, { 134, 11,  403 }, {   7, 11,  719 }, {   8, 11,  809 },
  { 136, 11,  834 }, {   5, 11,  210 }, {   6, 11,  213 }, {   7, 11,   60 },
  {  10, 11,  364 }, { 139, 11,  135 }, {   7,  0,  341 }, {  11,  0,  219 },
  {   5, 11,  607 }, {   8, 11,  326 }, { 136, 11,  490 }, {   4, 11,  701 },
  {   5, 11,  472 }, {   5, 11,  639 }, {   7, 11, 1249 }, {   9, 11,  758 },
  { 139, 11,  896 }, { 135, 11,  380 }, { 135, 11, 1947 }, { 139,  0,  130 },
  { 135,  0, 1734 }, {  10,  0,  115 }, {  11,  0,  420 }, {  12,  0,  154 },
  {  13,  0,  404 }, {  14,  0,  346 }, { 143,  0,   54 }, { 134, 10,  129 },
  {   4, 11,  386 }, {   7, 11,   41 }, {   8, 11,  405 }, {   9, 11,  497 },
  {  11, 11,  110 }, {  11, 11,  360 }, {  15, 11,   37 }, { 144, 11,   84 },
  { 141, 11,  282 }, {   5, 11,   46 }, {   7, 11, 1452 }, {   7, 11, 1480 },
  {   8, 11,  634 }, { 140, 11,  472 }, {   4, 11,  524 }, { 136, 11,  810 },
  {  10, 11,  238 }, { 141, 11,   33 }, { 133,  0,  604 }, {   5,  0, 1011 },
  { 136,  0,  701 }, {   8,  0,  856 }, {   8,  0,  858 }, {   8,  0,  879 },
  {  12,  0,  702 }, { 142,  0,  447 }, {   4,  0,   54 }, {   5,  0,  666 },
  {   7,  0, 1039 }, {   7,  0, 1130 }, {   9,  0,  195 }, { 138,  0,  302 },
  {   4, 10,   25 }, {   5, 10,   60 }, {   6, 10,  504 }, {   7, 10,  614 },
  {   7, 10, 1155 }, { 140, 10,    0 }, {   7, 10, 1248 }, {  11, 10,  621 },
  { 139, 10,  702 }, { 133, 11,  997 }, { 137, 10,  321 }, { 134,  0, 1669 },
  { 134,  0, 1791 }, {   4, 10,  379 }, { 135, 10, 1397 }, { 138, 11,  372 },
  {   5, 11,  782 }, {   5, 11,  829 }, { 134, 11, 1738 }, { 135,  0, 1228 },
  {   4, 10,  118 }, {   6, 10,  274 }, {   6, 10,  361 }, {   7, 10,   75 },
  { 141, 10,  441 }, { 132,  0,  623 }, {   9, 11,  279 }, {  10, 11,  407 },
  {  14, 11,   84 }, { 150, 11,   18 }, { 137, 10,  841 }, { 135,  0,  798 },
  { 140, 10,  693 }, {   5, 10,  314 }, {   6, 10,  221 }, {   7, 10,  419 },
  {  10, 10,  650 }, {  11, 10,  396 }, {  12, 10,  156 }, {  13, 10,  369 },
  {  14, 10,  333 }, { 145, 10,   47 }, { 135, 11, 1372 }, {   7,  0,  122 },
  {   9,  0,  259 }, {  10,  0,   84 }, {  11,  0,  470 }, {  12,  0,  541 },
  { 141,  0,  379 }, { 134,  0,  837 }, {   8,  0, 1013 }, {   4, 11,   78 },
  {   5, 11,   96 }, {   5, 11,  182 }, {   7, 11, 1724 }, {   7, 11, 1825 },
  {  10, 11,  394 }, {  10, 11,  471 }, {  11, 11,  532 }, {  14, 11,  340 },
  { 145, 11,   88 }, { 134,  0,  577 }, { 135, 11, 1964 }, { 132, 10,  913 },
  { 134,  0,  460 }, {   8,  0,  891 }, {  10,  0,  901 }, {  10,  0,  919 },
  {  10,  0,  932 }, {  12,  0,  715 }, {  12,  0,  728 }, {  12,  0,  777 },
  {  14,  0,  457 }, { 144,  0,  103 }, {   5,  0,   82 }, {   5,  0,  131 },
  {   7,  0, 1755 }, {   8,  0,   31 }, {   9,  0,  168 }, {   9,  0,  764 },
  { 139,  0,  869 }, { 136, 10,  475 }, {   6,  0,  605 }, {   5, 10, 1016 },
  {   9, 11,  601 }, {   9, 11,  619 }, {  10, 11,  505 }, {  10, 11,  732 },
  {  11, 11,  355 }, { 140, 11,  139 }, {   7, 10,  602 }, {   8, 10,  179 },
  {  10, 10,  781 }, { 140, 10,  126 }, { 134,  0, 1246 }, {   6, 10,  329 },
  { 138, 10,  111 }, {   6, 11,  215 }, {   7, 11, 1028 }, {   7, 11, 1473 },
  {   7, 11, 1721 }, {   9, 11,  424 }, { 138, 11,  779 }, {   5,  0,  278 },
  { 137,  0,   68 }, {   6,  0,  932 }, {   6,  0, 1084 }, { 144,  0,   86 },
  {   4,  0,  163 }, {   5,  0,  201 }, {   5,  0,  307 }, {   5,  0,  310 },
  {   6,  0,  335 }, {   7,  0,  284 }, {   7,  0, 1660 }, { 136,  0,  165 },
  { 136,  0,  781 }, { 134,  0,  707 }, {   6,  0,   33 }, { 135,  0, 1244 },
  {   5, 10,  821 }, {   6, 11,   67 }, {   6, 10, 1687 }, {   7, 11,  258 },
  {   7, 11, 1630 }, {   9, 11,  354 }, {   9, 11,  675 }, {  10, 11,  830 },
  {  14, 11,   80 }, { 145, 11,   80 }, {   6, 11,  141 }, {   7, 11,  225 },
  {   9, 11,   59 }, {   9, 11,  607 }, {  10, 11,  312 }, {  11, 11,  687 },
  {  12, 11,  555 }, {  13, 11,  373 }, {  13, 11,  494 }, { 148, 11,   58 },
  { 134,  0, 1113 }, {   9,  0,  388 }, {   5, 10,   71 }, {   7, 10, 1407 },
  {   9, 10,  704 }, {  10, 10,  261 }, {  10, 10,  619 }, {  11, 10,  547 },
  {  11, 10,  619 }, { 143, 10,  157 }, {   7,  0, 1953 }, { 136,  0,  720 },
  { 138,  0,  203 }, {   7, 10, 2008 }, {   9, 10,  337 }, { 138, 10,  517 },
  {   6,  0,  326 }, {   7,  0,  677 }, { 137,  0,  425 }, { 139, 11,   81 },
  {   7,  0, 1316 }, {   7,  0, 1412 }, {   7,  0, 1839 }, {   9,  0,  589 },
  {  11,  0,  241 }, {  11,  0,  676 }, {  11,  0,  811 }, {  11,  0,  891 },
  {  12,  0,  140 }, {  12,  0,  346 }, {  12,  0,  479 }, {  13,  0,  140 },
  {  13,  0,  381 }, {  14,  0,  188 }, {  18,  0,   30 }, { 148,  0,  108 },
  {   5,  0,  416 }, {   6, 10,   86 }, {   6, 10,  603 }, {   7, 10,  292 },
  {   7, 10,  561 }, {   8, 10,  257 }, {   8, 10,  382 }, {   9, 10,  721 },
  {   9, 10,  778 }, {  11, 10,  581 }, { 140, 10,  466 }, {   4, 10,  486 },
  { 133, 10,  491 }, { 134,  0, 1300 }, { 132, 10,   72 }, {   7,  0,  847 },
  {   6, 10,  265 }, {   7, 11,  430 }, { 139, 11,   46 }, {   5, 11,  602 },
  {   6, 11,  106 }, {   7, 11, 1786 }, {   7, 11, 1821 }, {   7, 11, 2018 },
  {   9, 11,  418 }, { 137, 11,  763 }, {   5,  0,  358 }, {   7,  0,  535 },
  {   7,  0, 1184 }, {  10,  0,  662 }, {  13,  0,  212 }, {  13,  0,  304 },
  {  13,  0,  333 }, { 145,  0,   98 }, {   5, 11,   65 }, {   6, 11,  416 },
  {   7, 11, 1720 }, {   7, 11, 1924 }, {   8, 11,  677 }, {  10, 11,  109 },
  {  11, 11,   14 }, {  11, 11,   70 }, {  11, 11,  569 }, {  11, 11,  735 },
  {  15, 11,  153 }, { 148, 11,   80 }, {   6,  0, 1823 }, {   8,  0,  839 },
  {   8,  0,  852 }, {   8,  0,  903 }, {  10,  0,  940 }, {  12,  0,  707 },
  { 140,  0,  775 }, { 135, 11, 1229 }, {   6,  0, 1522 }, { 140,  0,  654 },
  { 136, 11,  595 }, { 139,  0,  163 }, { 141,  0,  314 }, { 132,  0,  978 },
  {   4,  0,  601 }, {   6,  0, 2035 }, { 137, 10,  234 }, {   5, 10,  815 },
  {   6, 10, 1688 }, { 134, 10, 1755 }, { 133,  0,  946 }, { 136,  0,  434 },
  {   6, 10,  197 }, { 136, 10,  205 }, {   7,  0,  411 }, {   7,  0,  590 },
  {   8,  0,  631 }, {   9,  0,  323 }, {  10,  0,  355 }, {  11,  0,  491 },
  {  12,  0,  143 }, {  12,  0,  402 }, {  13,  0,   73 }, {  14,  0,  408 },
  {  15,  0,  107 }, { 146,  0,   71 }, {   7,  0, 1467 }, {   8,  0,  328 },
  {  10,  0,  544 }, {  11,  0,  955 }, {  12,  0,   13 }, {  13,  0,  320 },
  { 145,  0,   83 }, { 142,  0,  410 }, {  11,  0,  511 }, {  13,  0,  394 },
  {  14,  0,  298 }, {  14,  0,  318 }, { 146,  0,  103 }, {   6, 10,  452 },
  {   7, 10,  312 }, { 138, 10,  219 }, { 138, 10,  589 }, {   4, 10,  333 },
  {   9, 10,  176 }, {  12, 10,  353 }, { 141, 10,  187 }, { 135, 11,  329 },
  { 132, 11,  469 }, {   5,  0,  835 }, { 134,  0,  483 }, { 134, 11, 1743 },
  {   5, 11,  929 }, {   6, 11,  340 }, {   8, 11,  376 }, { 136, 11,  807 },
  { 134, 10, 1685 }, { 132,  0,  677 }, {   5, 11,  218 }, {   7, 11, 1610 },
  { 138, 11,   83 }, {   5, 11,  571 }, { 135, 11, 1842 }, { 132, 11,  455 },
  { 137,  0,   70 }, { 135,  0, 1405 }, {   7, 10,  135 }, {   8, 10,    7 },
  {   8, 10,   62 }, {   9, 10,  243 }, {  10, 10,  658 }, {  10, 10,  697 },
  {  11, 10,  456 }, { 139, 10,  756 }, {   9, 10,  395 }, { 138, 10,   79 },
  { 137,  0,  108 }, {   6, 11,  161 }, {   7, 11,  372 }, { 137, 11,  597 },
  { 132, 11,  349 }, { 132,  0,  777 }, { 132,  0,  331 }, { 135, 10,  631 },
  { 133,  0,  747 }, {   6, 11,  432 }, {   6, 11,  608 }, { 139, 11,  322 },
  { 138, 10,  835 }, {   5, 11,  468 }, {   7, 11, 1809 }, {  10, 11,  325 },
  {  11, 11,  856 }, {  12, 11,  345 }, { 143, 11,  104 }, { 133, 11,  223 },
  {   7, 10,  406 }, {   7, 10,  459 }, {   8, 10,  606 }, { 139, 10,  726 },
  { 132, 11,  566 }, { 142,  0,   68 }, {   4, 11,   59 }, { 135, 11, 1394 },
  {   6, 11,  436 }, { 139, 11,  481 }, {   4, 11,   48 }, {   5, 11,  271 },
  { 135, 11,  953 }, { 139, 11,  170 }, {   5, 11,  610 }, { 136, 11,  457 },
  { 133, 11,  755 }, { 135, 11, 1217 }, { 133, 10,  612 }, { 132, 11,  197 },
  { 132,  0,  505 }, {   4, 10,  372 }, {   7, 10,  482 }, {   8, 10,  158 },
  {   9, 10,  602 }, {   9, 10,  615 }, {  10, 10,  245 }, {  10, 10,  678 },
  {  10, 10,  744 }, {  11, 10,  248 }, { 139, 10,  806 }, { 133,  0,  326 },
  {   5, 10,  854 }, { 135, 10, 1991 }, {   4,  0,  691 }, { 146,  0,   16 },
  {   6,  0,  628 }, {   9,  0,   35 }, {  10,  0,  680 }, {  10,  0,  793 },
  {  11,  0,  364 }, {  13,  0,  357 }, { 143,  0,  164 }, { 138,  0,  654 },
  {   6,  0,   32 }, {   7,  0,  385 }, {   7,  0,  757 }, {   7,  0, 1916 },
  {   8,  0,   37 }, {   8,  0,   94 }, {   8,  0,  711 }, {   9,  0,  541 },
  {  10,  0,  162 }, {  10,  0,  795 }, {  11,  0,  989 }, {  11,  0, 1010 },
  {  12,  0,   14 }, { 142,  0,  308 }, { 133, 11,  217 }, {   6,  0,  152 },
  {   6,  0,  349 }, {   6,  0, 1682 }, {   7,  0, 1252 }, {   8,  0,  112 },
  {   9,  0,  435 }, {   9,  0,  668 }, {  10,  0,  290 }, {  10,  0,  319 },
  {  10,  0,  815 }, {  11,  0,  180 }, {  11,  0,  837 }, {  12,  0,  240 },
  {  13,  0,  152 }, {  13,  0,  219 }, { 142,  0,  158 }, {   4,  0,  581 },
  { 134,  0,  726 }, {   5, 10,  195 }, { 135, 10, 1685 }, {   6,  0,  126 },
  {   7,  0,  573 }, {   8,  0,  397 }, { 142,  0,   44 }, { 138,  0,   89 },
  {   7, 10, 1997 }, {   8, 10,  730 }, { 139, 10, 1006 }, { 134,  0, 1531 },
  { 134,  0, 1167 }, {   5,  0,  926 }, {  12,  0,  203 }, { 133, 10,  751 },
  {   4, 11,  165 }, {   7, 11, 1398 }, { 135, 11, 1829 }, {   7,  0, 1232 },
  { 137,  0,  531 }, { 135, 10,  821 }, { 134,  0,  943 }, { 133,  0,  670 },
  {   4,  0,  880 }, { 139,  0,  231 }, { 134,  0, 1617 }, { 135,  0, 1957 },
  {   5, 11,    9 }, {   7, 11,  297 }, {   7, 11,  966 }, { 140, 11,  306 },
  {   6,  0,  975 }, { 134,  0,  985 }, {   5, 10,  950 }, {   5, 10,  994 },
  { 134, 10,  351 }, {  12, 11,   21 }, { 151, 11,    7 }, {   5, 11,  146 },
  {   6, 11,  411 }, { 138, 11,  721 }, {   7,  0,  242 }, { 135,  0, 1942 },
  {   6, 11,  177 }, { 135, 11,  467 }, {   5,  0,  421 }, {   7, 10,   47 },
  { 137, 10,  684 }, {   5,  0,  834 }, {   7,  0, 1202 }, {   8,  0,   14 },
  {   9,  0,  481 }, { 137,  0,  880 }, { 138,  0,  465 }, {   6,  0,  688 },
  {   9,  0,  834 }, { 132, 10,  350 }, { 132,  0,  855 }, {   4,  0,  357 },
  {   6,  0,  172 }, {   7,  0,  143 }, { 137,  0,  413 }, { 133, 11,  200 },
  { 132,  0,  590 }, {   7, 10, 1812 }, {  13, 10,  259 }, {  13, 10,  356 },
  {  14, 10,  242 }, { 147, 10,  114 }, { 133, 10,  967 }, {  11,  0,  114 },
  {   4, 10,  473 }, {   7, 10,  623 }, {   8, 10,  808 }, {   9, 10,  871 },
  {   9, 10,  893 }, {  11, 10,  431 }, {  12, 10,  112 }, {  12, 10,  217 },
  {  12, 10,  243 }, {  12, 10,  562 }, {  12, 10,  663 }, {  12, 10,  683 },
  {  13, 10,  141 }, {  13, 10,  197 }, {  13, 10,  227 }, {  13, 10,  406 },
  {  13, 10,  487 }, {  14, 10,  156 }, {  14, 10,  203 }, {  14, 10,  224 },
  {  14, 10,  256 }, {  18, 10,   58 }, { 150, 10,    0 }, { 138, 10,  286 },
  {   4, 10,  222 }, {   7, 10,  286 }, { 136, 10,  629 }, {   5,  0,  169 },
  {   7,  0,  333 }, { 136,  0,   45 }, { 134, 11,  481 }, { 132,  0,  198 },
  {   4,  0,   24 }, {   5,  0,  140 }, {   5,  0,  185 }, {   7,  0, 1500 },
  {  11,  0,  565 }, {  11,  0,  838 }, {   4, 11,   84 }, {   7, 11, 1482 },
  {  10, 11,   76 }, { 138, 11,  142 }, { 133,  0,  585 }, { 141, 10,  306 },
  { 133, 11, 1015 }, {   4, 11,  315 }, {   5, 11,  507 }, { 135, 11, 1370 },
  { 136, 10,  146 }, {   6,  0,  691 }, { 134,  0, 1503 }, {   4,  0,  334 },
  { 133,  0,  593 }, {   4, 10,  465 }, { 135, 10, 1663 }, { 142, 11,  173 },
  { 135,  0,  913 }, {  12,  0,  116 }, { 134, 11, 1722 }, { 134,  0, 1360 },
  { 132,  0,  802 }, {   8, 11,  222 }, {   8, 11,  476 }, {   9, 11,  238 },
  {  11, 11,  516 }, {  11, 11,  575 }, {  15, 11,  109 }, { 146, 11,  100 },
  {   6,  0,  308 }, {   9,  0,  673 }, {   7, 10,  138 }, {   7, 10,  517 },
  { 139, 10,  238 }, { 132,  0,  709 }, {   6,  0, 1876 }, {   6,  0, 1895 },
  {   9,  0,  994 }, {   9,  0, 1006 }, {  12,  0,  829 }, {  12,  0,  888 },
  {  12,  0,  891 }, { 146,  0,  185 }, { 148, 10,   94 }, {   4,  0,  228 },
  { 133,  0,  897 }, {   7,  0, 1840 }, {   5, 10,  495 }, {   7, 10,  834 },
  {   9, 10,  733 }, { 139, 10,  378 }, { 133, 10,  559 }, {   6, 10,   21 },
  {   6, 10, 1737 }, {   7, 10, 1444 }, { 136, 10,  224 }, {   4,  0,  608 },
  { 133,  0,  497 }, {   6, 11,   40 }, { 135, 11, 1781 }, { 134,  0, 1573 },
  { 135,  0, 2039 }, {   6,  0,  540 }, { 136,  0,  136 }, {   4,  0,  897 },
  {   5,  0,  786 }, { 133, 10,  519 }, {   6,  0, 1878 }, {   6,  0, 1884 },
  {   9,  0,  938 }, {   9,  0,  948 }, {   9,  0,  955 }, {   9,  0,  973 },
  {   9,  0, 1012 }, {  12,  0,  895 }, {  12,  0,  927 }, { 143,  0,  254 },
  { 134,  0, 1469 }, { 133,  0,  999 }, {   4,  0,  299 }, { 135,  0, 1004 },
  {   4,  0,  745 }, { 133,  0,  578 }, { 136, 11,  574 }, { 133,  0,  456 },
  { 134,  0, 1457 }, {   7,  0, 1679 }, { 132, 10,  402 }, {   7,  0,  693 },
  {   8,  0,  180 }, {  12,  0,  163 }, {   8, 10,  323 }, { 136, 10,  479 },
  {  11, 10,  580 }, { 142, 10,  201 }, {   5, 10,   59 }, { 135, 10,  672 },
  { 132, 11,  354 }, { 146, 10,   34 }, {   4,  0,  755 }, { 135, 11, 1558 },
  {   7,  0, 1740 }, { 146,  0,   48 }, {   4, 10,   85 }, { 135, 10,  549 },
  { 139,  0,  338 }, { 133, 10,   94 }, { 134,  0, 1091 }, { 135, 11,  469 },
  {  12,  0,  695 }, {  12,  0,  704 }, {  20,  0,  113 }, {   5, 11,  830 },
  {  14, 11,  338 }, { 148, 11,   81 }, { 135,  0, 1464 }, {   6, 10,   11 },
  { 135, 10,  187 }, { 135,  0,  975 }, {  13,  0,  335 }, { 132, 10,  522 },
  { 134,  0, 1979 }, {   5, 11,  496 }, { 135, 11,  203 }, {   4, 10,   52 },
  { 135, 10,  661 }, {   7,  0, 1566 }, {   8,  0,  269 }, {   9,  0,  212 },
  {   9,  0,  718 }, {  14,  0,   15 }, {  14,  0,  132 }, { 142,  0,  227 },
  {   4,  0,  890 }, {   5,  0,  805 }, {   5,  0,  819 }, {   5,  0,  961 },
  {   6,  0,  396 }, {   6,  0, 1631 }, {   6,  0, 1678 }, {   7,  0, 1967 },
  {   7,  0, 2041 }, {   9,  0,  630 }, {  11,  0,    8 }, {  11,  0, 1019 },
  {  12,  0,  176 }, {  13,  0,  225 }, {  14,  0,  292 }, {  21,  0,   24 },
  {   4, 10,  383 }, { 133, 10,  520 }, { 134, 11,  547 }, { 135, 11, 1748 },
  {   5, 11,   88 }, { 137, 11,  239 }, { 146, 11,  128 }, {   7, 11,  650 },
  { 135, 11, 1310 }, {   4, 10,  281 }, {   5, 10,   38 }, {   7, 10,  194 },
  {   7, 10,  668 }, {   7, 10, 1893 }, { 137, 10,  397 }, { 135,  0, 1815 },
  {   9, 10,  635 }, { 139, 10,  559 }, {   7,  0, 1505 }, {  10,  0,  190 },
  {  10,  0,  634 }, {  11,  0,  792 }, {  12,  0,  358 }, { 140,  0,  447 },
  {   5,  0,    0 }, {   6,  0,  536 }, {   7,  0,  604 }, {  13,  0,  445 },
  { 145,  0,  126 }, {   7, 11, 1076 }, {   9, 11,   80 }, {  11, 11,   78 },
  {  11, 11,  421 }, {  11, 11,  534 }, { 140, 11,  545 }, {   8,  0,  966 },
  {  10,  0, 1023 }, {  14, 11,  369 }, { 146, 11,   72 }, { 135, 11, 1641 },
  {   6,  0,  232 }, {   6,  0,  412 }, {   7,  0, 1074 }, {   8,  0,    9 },
  {   8,  0,  157 }, {   8,  0,  786 }, {   9,  0,  196 }, {   9,  0,  352 },
  {   9,  0,  457 }, {  10,  0,  337 }, {  11,  0,  232 }, {  11,  0,  877 },
  {  12,  0,  480 }, { 140,  0,  546 }, { 135,  0,  958 }, {   4,  0,  382 },
  { 136,  0,  579 }, {   4,  0,  212 }, { 135,  0, 1206 }, {   4, 11,  497 },
  {   5, 11,  657 }, { 135, 11, 1584 }, { 132,  0,  681 }, {   8,  0,  971 },
  { 138,  0,  965 }, {   5, 10,  448 }, { 136, 10,  535 }, {  14,  0,   16 },
  { 146,  0,   44 }, {  11,  0,  584 }, {  11,  0,  616 }, {  14,  0,  275 },
  {  11, 11,  584 }, {  11, 11,  616 }, { 142, 11,  275 }, { 136, 11,   13 },
  {   7, 10,  610 }, { 135, 10, 1501 }, {   7, 11,  642 }, {   8, 11,  250 },
  {  11, 11,  123 }, {  11, 11,  137 }, {  13, 11,   48 }, { 142, 11,   95 },
  { 133,  0,  655 }, {  17,  0,   67 }, { 147,  0,   74 }, { 134,  0,  751 },
  { 134,  0, 1967 }, {   6,  0,  231 }, { 136,  0,  423 }, {   5,  0,  300 },
  { 138,  0, 1016 }, {   4, 10,  319 }, {   5, 10,  699 }, { 138, 10,  673 },
  {   6,  0,  237 }, {   7,  0,  611 }, {   8,  0,  100 }, {   9,  0,  416 },
  {  11,  0,  335 }, {  12,  0,  173 }, {  18,  0,  101 }, {   6, 10,  336 },
  {   8, 10,  552 }, {   9, 10,  285 }, {  10, 10,   99 }, { 139, 10,  568 },
  { 134,  0, 1370 }, {   7, 10, 1406 }, {   9, 10,  218 }, { 141, 10,  222 },
  { 133, 10,  256 }, { 135,  0, 1208 }, {  14, 11,  213 }, { 148, 11,   38 },
  {   6,  0, 1219 }, { 135, 11, 1642 }, {  13,  0,  417 }, {  14,  0,  129 },
  { 143,  0,   15 }, {  10, 11,  545 }, { 140, 11,  301 }, {  17, 10,   39 },
  { 148, 10,   36 }, { 133,  0,  199 }, {   4, 11,  904 }, { 133, 11,  794 },
  {  12,  0,  427 }, { 146,  0,   38 }, { 134,  0,  949 }, {   8,  0,  665 },
  { 135, 10,  634 }, { 132, 10,  618 }, { 135, 10,  259 }, { 132, 10,  339 },
  { 133, 11,  761 }, { 141, 10,  169 }, { 132, 10,  759 }, {   5,  0,  688 },
  {   7,  0,  539 }, { 135,  0,  712 }, {   7, 11,  386 }, { 138, 11,  713 },
  { 134,  0, 1186 }, {   6, 11,    7 }, {   6, 11,   35 }, {   7, 11,  147 },
  {   7, 11, 1069 }, {   7, 11, 1568 }, {   7, 11, 1575 }, {   7, 11, 1917 },
  {   8, 11,   43 }, {   8, 11,  208 }, {   9, 11,  128 }, {   9, 11,  866 },
  {  10, 11,   20 }, {  11, 11,  981 }, { 147, 11,   33 }, {   7, 11,  893 },
  {   8, 10,  482 }, { 141, 11,  424 }, {   6,  0,  312 }, {   6,  0, 1715 },
  {  10,  0,  584 }, {  11,  0,  546 }, {  11,  0,  692 }, {  12,  0,  259 },
  {  12,  0,  295 }, {  13,  0,   46 }, { 141,  0,  154 }, {   5, 10,  336 },
  {   6, 10,  341 }, {   6, 10,  478 }, {   6, 10, 1763 }, { 136, 10,  386 },
  { 137,  0,  151 }, { 132,  0,  588 }, { 152,  0,    4 }, {   6, 11,  322 },
  {   9, 11,  552 }, {  11, 11,  274 }, {  13, 11,  209 }, {  13, 11,  499 },
  {  14, 11,   85 }, {  15, 11,  126 }, { 145, 11,   70 }, { 135, 10,   73 },
  {   4,  0,  231 }, {   5,  0,   61 }, {   6,  0,  104 }, {   7,  0,  729 },
  {   7,  0,  964 }, {   7,  0, 1658 }, { 140,  0,  414 }, {   6,  0,  263 },
  { 138,  0,  757 }, { 135, 10, 1971 }, {   4,  0,  612 }, { 133,  0,  561 },
  { 132,  0,  320 }, { 135, 10, 1344 }, {   8, 11,   83 }, {   8, 11,  817 },
  {   9, 11,   28 }, {   9, 11,   29 }, {   9, 11,  885 }, {  10, 11,  387 },
  {  11, 11,  633 }, {  11, 11,  740 }, {  13, 11,  235 }, {  13, 11,  254 },
  {  15, 11,  143 }, { 143, 11,  146 }, {   5, 10,  396 }, { 134, 10,  501 },
  { 140, 11,   49 }, { 132,  0,  225 }, {   4, 10,  929 }, {   5, 10,  799 },
  {   8, 10,   46 }, { 136, 10,  740 }, {   4,  0,  405 }, {   7,  0,  817 },
  {  14,  0,   58 }, {  17,  0,   37 }, { 146,  0,  124 }, { 133,  0,  974 },
  {   4, 11,  412 }, { 133, 11,  581 }, {   4, 10,  892 }, { 133, 10,  770 },
  {   4,  0,  996 }, { 134,  0, 2026 }, {   4,  0,  527 }, {   5,  0,  235 },
  {   7,  0, 1239 }, {  11,  0,  131 }, { 140,  0,  370 }, {   9,  0,   16 },
  {  13,  0,  386 }, { 135, 11,  421 }, {   7,  0,  956 }, {   7,  0, 1157 },
  {   7,  0, 1506 }, {   7,  0, 1606 }, {   7,  0, 1615 }, {   7,  0, 1619 },
  {   7,  0, 1736 }, {   7,  0, 1775 }, {   8,  0,  590 }, {   9,  0,  324 },
  {   9,  0,  736 }, {   9,  0,  774 }, {   9,  0,  776 }, {   9,  0,  784 },
  {  10,  0,  567 }, {  10,  0,  708 }, {  11,  0,  518 }, {  11,  0,  613 },
  {  11,  0,  695 }, {  11,  0,  716 }, {  11,  0,  739 }, {  11,  0,  770 },
  {  11,  0,  771 }, {  11,  0,  848 }, {  11,  0,  857 }, {  11,  0,  931 },
  {  11,  0,  947 }, {  12,  0,  326 }, {  12,  0,  387 }, {  12,  0,  484 },
  {  12,  0,  528 }, {  12,  0,  552 }, {  12,  0,  613 }, {  13,  0,  189 },
  {  13,  0,  256 }, {  13,  0,  340 }, {  13,  0,  432 }, {  13,  0,  436 },
  {  13,  0,  440 }, {  13,  0,  454 }, {  14,  0,  174 }, {  14,  0,  220 },
  {  14,  0,  284 }, {  14,  0,  390 }, { 145,  0,  121 }, { 135, 10,  158 },
  {   9,  0,  137 }, { 138,  0,  221 }, {   4, 11,  110 }, {  10, 11,  415 },
  {  10, 11,  597 }, { 142, 11,  206 }, { 141, 11,  496 }, { 135, 11,  205 },
  { 151, 10,   25 }, { 135, 11,  778 }, {   7, 11, 1656 }, {   7, 10, 2001 },
  {   9, 11,  369 }, {  10, 11,  338 }, {  10, 11,  490 }, {  11, 11,  154 },
  {  11, 11,  545 }, {  11, 11,  775 }, {  13, 11,   77 }, { 141, 11,  274 },
  {   4, 11,  444 }, {  10, 11,  146 }, { 140, 11,    9 }, {   7,  0,  390 },
  { 138,  0,  140 }, { 135,  0, 1144 }, { 134,  0,  464 }, {   7, 10, 1461 },
  { 140, 10,   91 }, { 132, 10,  602 }, {   4, 11,  283 }, { 135, 11, 1194 },
  {   5,  0,  407 }, {  11,  0,  204 }, {  11,  0,  243 }, {  11,  0,  489 },
  {  12,  0,  293 }, {  19,  0,   37 }, {  20,  0,   73 }, { 150,  0,   38 },
  {   7,  0, 1218 }, { 136,  0,  303 }, {   5,  0,  325 }, {   8,  0,    5 },
  {   8,  0,  227 }, {   9,  0,  105 }, {  10,  0,  585 }, {  12,  0,  614 },
  {   4, 10,   13 }, {   5, 10,  567 }, {   7, 10, 1498 }, {   9, 10,  124 },
  {  11, 10,  521 }, { 140, 10,  405 }, { 135, 10, 1006 }, {   7,  0,  800 },
  {  10,  0,   12 }, { 134, 11, 1720 }, { 135,  0, 1783 }, { 132, 10,  735 },
  { 138, 10,  812 }, {   4, 10,  170 }, { 135, 10,  323 }, {   6,  0,  621 },
  {  13,  0,  504 }, { 144,  0,   89 }, {   5, 10,  304 }, { 135, 10, 1403 },
  { 137, 11,  216 }, {   6,  0,  920 }, {   6,  0, 1104 }, {   9, 11,  183 },
  { 139, 11,  286 }, {   4,  0,  376 }, { 133, 10,  742 }, { 134,  0,  218 },
  {   8,  0,  641 }, {  11,  0,  388 }, { 140,  0,  580 }, {   7,  0,  454 },
  {   7,  0,  782 }, {   8,  0,  768 }, { 140,  0,  686 }, { 137, 11,   33 },
  { 133, 10,  111 }, { 144,  0,    0 }, {  10,  0,  676 }, { 140,  0,  462 },
  {   6,  0,  164 }, { 136, 11,  735 }, { 133, 10,  444 }, { 150,  0,   50 },
  {   7, 11, 1862 }, {  12, 11,  491 }, {  12, 11,  520 }, {  13, 11,  383 },
  {  14, 11,  244 }, { 146, 11,   12 }, {   5, 11,  132 }, {   9, 11,  486 },
  {   9, 11,  715 }, {  10, 11,  458 }, {  11, 11,  373 }, {  11, 11,  668 },
  {  11, 11,  795 }, {  11, 11,  897 }, {  12, 11,  272 }, {  12, 11,  424 },
  {  12, 11,  539 }, {  12, 11,  558 }, {  14, 11,  245 }, {  14, 11,  263 },
  {  14, 11,  264 }, {  14, 11,  393 }, { 142, 11,  403 }, {   8, 10,  123 },
  {  15, 10,    6 }, { 144, 10,    7 }, {   6,  0,  285 }, {   8,  0,  654 },
  {  11,  0,  749 }, {  12,  0,  190 }, {  12,  0,  327 }, {  13,  0,  120 },
  {  13,  0,  121 }, {  13,  0,  327 }, {  15,  0,   47 }, { 146,  0,   40 },
  {   5, 11,    8 }, {   6, 11,   89 }, {   6, 11,  400 }, {   7, 11, 1569 },
  {   7, 11, 1623 }, {   7, 11, 1850 }, {   8, 11,  218 }, {   8, 11,  422 },
  {   9, 11,  570 }, { 138, 11,  626 }, {   6, 11,  387 }, {   7, 11,  882 },
  { 141, 11,  111 }, {   6,  0,  343 }, {   7,  0,  195 }, {   9,  0,  226 },
  {  10,  0,  197 }, {  10,  0,  575 }, {  11,  0,  502 }, {  11,  0,  899 },
  {   6, 11,  224 }, {   7, 11,  877 }, { 137, 11,  647 }, {   5, 10,  937 },
  { 135, 10,  100 }, { 135, 11,  790 }, { 150,  0,   29 }, { 147,  0,    8 },
  { 134,  0, 1812 }, { 149,  0,    8 }, { 135, 11,  394 }, {   7,  0, 1125 },
  {   9,  0,  143 }, {  11,  0,   61 }, {  14,  0,  405 }, { 150,  0,   21 },
  {  10, 11,  755 }, { 147, 11,   29 }, {   9, 11,  378 }, { 141, 11,  162 },
  { 135, 10,  922 }, {   5, 10,  619 }, { 133, 10,  698 }, { 134,  0, 1327 },
  {   6,  0, 1598 }, { 137,  0,  575 }, {   9, 11,  569 }, {  12, 11,   12 },
  {  12, 11,   81 }, {  12, 11,  319 }, {  13, 11,   69 }, {  14, 11,  259 },
  {  16, 11,   87 }, {  17, 11,    1 }, {  17, 11,   21 }, {  17, 11,   24 },
  {  18, 11,   15 }, {  18, 11,   56 }, {  18, 11,   59 }, {  18, 11,  127 },
  {  18, 11,  154 }, {  19, 11,   19 }, { 148, 11,   31 }, {   6,  0,  895 },
  { 135, 11, 1231 }, {   5,  0,  959 }, {   7, 11,  124 }, { 136, 11,   38 },
  {   5, 11,  261 }, {   7, 11,   78 }, {   7, 11,  199 }, {   8, 11,  815 },
  {   9, 11,  126 }, { 138, 11,  342 }, {   5, 10,  917 }, { 134, 10, 1659 },
  {   7,  0, 1759 }, {   5, 11,  595 }, { 135, 11, 1863 }, { 136,  0,  173 },
  { 134,  0,  266 }, { 142,  0,  261 }, { 132, 11,  628 }, {   5, 10,  251 },
  {   5, 10,  956 }, {   8, 10,  268 }, {   9, 10,  214 }, { 146, 10,  142 },
  {   7, 11,  266 }, { 136, 11,  804 }, { 135, 11,  208 }, {   6, 11,   79 },
  {   7, 11, 1021 }, { 135, 11, 1519 }, {  11, 11,  704 }, { 141, 11,  396 },
  {   5, 10,  346 }, {   5, 10,  711 }, { 136, 10,  390 }, { 136, 11,  741 },
  { 134, 11,  376 }, { 134,  0, 1427 }, {   6,  0, 1033 }, {   6,  0, 1217 },
  { 136,  0,  300 }, { 133, 10,  624 }, {   6, 11,  100 }, {   7, 11,  244 },
  {   7, 11,  632 }, {   7, 11, 1609 }, {   8, 11,  178 }, {   8, 11,  638 },
  { 141, 11,   58 }, {   6,  0,  584 }, {   5, 10,  783 }, {   7, 10, 1998 },
  { 135, 10, 2047 }, {   5,  0,  427 }, {   5,  0,  734 }, {   7,  0,  478 },
  { 136,  0,   52 }, {   7,  0,  239 }, {  11,  0,  217 }, { 142,  0,  165 },
  { 134,  0, 1129 }, {   6,  0,  168 }, {   6,  0, 1734 }, {   7,  0,   20 },
  {   7,  0, 1056 }, {   8,  0,  732 }, {   9,  0,  406 }, {   9,  0,  911 },
  { 138,  0,  694 }, { 132, 10,  594 }, { 133, 11,  791 }, {   7, 11,  686 },
  {   8, 11,   33 }, {   8, 11,  238 }, {  10, 11,  616 }, {  11, 11,  467 },
  {  11, 11,  881 }, {  13, 11,  217 }, {  13, 11,  253 }, { 142, 11,  268 },
  { 137, 11,  476 }, { 134,  0,  418 }, { 133,  0,  613 }, { 132,  0,  632 },
  { 132, 11,  447 }, {   7,  0,   32 }, {   7,  0,  984 }, {   8,  0,   85 },
  {   8,  0,  709 }, {   9,  0,  579 }, {   9,  0,  847 }, {   9,  0,  856 },
  {  10,  0,  799 }, {  11,  0,  258 }, {  11,  0, 1007 }, {  12,  0,  331 },
  {  12,  0,  615 }, {  13,  0,  188 }, {  13,  0,  435 }, {  14,  0,    8 },
  {  15,  0,  165 }, {  16,  0,   27 }, {  20,  0,   40 }, { 144, 11,   35 },
  {   4, 11,  128 }, {   5, 11,  415 }, {   6, 11,  462 }, {   7, 11,  294 },
  {   7, 11,  578 }, {  10, 11,  710 }, { 139, 11,   86 }, {   5,  0,  694 },
  { 136,  0,  909 }, {   7,  0, 1109 }, {  11,  0,    7 }, {   5, 10,   37 },
  {   6, 10,   39 }, {   6, 10,  451 }, {   7, 10,  218 }, {   7, 10, 1166 },
  {   7, 10, 1687 }, {   8, 10,  662 }, { 144, 10,    2 }, { 136, 11,  587 },
  {   6, 11,  427 }, {   7, 11, 1018 }, { 138, 11,  692 }, {   4, 11,  195 },
  {   6, 10,  508 }, { 135, 11,  802 }, {   4,  0,  167 }, { 135,  0,   82 },
  {   5,  0,   62 }, {   6,  0,   24 }, {   6,  0,  534 }, {   7,  0,   74 },
  {   7,  0,  678 }, {   7,  0,  684 }, {   7,  0, 1043 }, {   7,  0, 1072 },
  {   8,  0,  280 }, {   8,  0,  541 }, {   8,  0,  686 }, {   9,  0,  258 },
  {  10,  0,  519 }, {  11,  0,  252 }, { 140,  0,  282 }, { 138,  0,   33 },
  {   4,  0,  359 }, { 133, 11,  738 }, {   7,  0,  980 }, {   9,  0,  328 },
  {  13,  0,  186 }, {  13,  0,  364 }, {   7, 10,  635 }, {   7, 10,  796 },
  {   8, 10,  331 }, {   9, 10,  330 }, {   9, 10,  865 }, {  10, 10,  119 },
  {  10, 10,  235 }, {  11, 10,  111 }, {  11, 10,  129 }, {  11, 10,  240 },
  {  12, 10,   31 }, {  12, 10,   66 }, {  12, 10,  222 }, {  12, 10,  269 },
  {  12, 10,  599 }, {  12, 10,  684 }, {  12, 10,  689 }, {  12, 10,  691 },
  { 142, 10,  345 }, { 137, 10,  527 }, {   6,  0,  596 }, {   7,  0,  585 },
  { 135, 10,  702 }, { 134, 11, 1683 }, { 133,  0,  211 }, {   6,  0,  145 },
  { 141,  0,  336 }, { 134,  0, 1130 }, {   7,  0,  873 }, {   6, 10,   37 },
  {   7, 10, 1666 }, {   8, 10,  195 }, {   8, 10,  316 }, {   9, 10,  178 },
  {   9, 10,  276 }, {   9, 10,  339 }, {   9, 10,  536 }, {  10, 10,  102 },
  {  10, 10,  362 }, {  10, 10,  785 }, {  11, 10,   55 }, {  11, 10,  149 },
  {  11, 10,  773 }, {  13, 10,  416 }, {  13, 10,  419 }, {  14, 10,   38 },
  {  14, 10,   41 }, { 142, 10,  210 }, {   8,  0,  840 }, { 136,  0,  841 },
  { 132,  0,  263 }, {   5, 11,    3 }, {   8, 11,  578 }, {   9, 11,  118 },
  {  10, 11,  705 }, {  12, 11,  383 }, { 141, 11,  279 }, { 132,  0,  916 },
  { 133, 11,  229 }, { 133, 10,  645 }, {  15,  0,  155 }, {  16,  0,   79 },
  {   8, 11,  102 }, {  10, 11,  578 }, {  10, 11,  672 }, {  12, 11,  496 },
  {  13, 11,  408 }, {  14, 11,  121 }, { 145, 11,  106 }, {   4,  0,  599 },
  {   5,  0,  592 }, {   6,  0, 1634 }, {   7,  0,    5 }, {   7,  0,   55 },
  {   7,  0,   67 }, {   7,  0,   97 }, {   7,  0,  691 }, {   7,  0,  979 },
  {   7,  0, 1600 }, {   7,  0, 1697 }, {   8,  0,  207 }, {   8,  0,  214 },
  {   8,  0,  231 }, {   8,  0,  294 }, {   8,  0,  336 }, {   8,  0,  428 },
  {   8,  0,  471 }, {   8,  0,  622 }, {   8,  0,  626 }, {   8,  0,  679 },
  {   8,  0,  759 }, {   8,  0,  829 }, {   9,  0,   11 }, {   9,  0,  246 },
  {   9,  0,  484 }, {   9,  0,  573 }, {   9,  0,  706 }, {   9,  0,  762 },
  {   9,  0,  798 }, {   9,  0,  855 }, {   9,  0,  870 }, {   9,  0,  912 },
  {  10,  0,  303 }, {  10,  0,  335 }, {  10,  0,  424 }, {  10,  0,  461 },
  {  10,  0,  543 }, {  10,  0,  759 }, {  10,  0,  814 }, {  11,  0,   59 },
  {  11,  0,  199 }, {  11,  0,  235 }, {  11,  0,  590 }, {  11,  0,  631 },
  {  11,  0,  929 }, {  11,  0,  963 }, {  11,  0,  987 }, {  12,  0,  114 },
  {  12,  0,  182 }, {  12,  0,  226 }, {  12,  0,  332 }, {  12,  0,  439 },
  {  12,  0,  575 }, {  12,  0,  598 }, {  12,  0,  675 }, {  13,  0,    8 },
  {  13,  0,  125 }, {  13,  0,  194 }, {  13,  0,  287 }, {  14,  0,  197 },
  {  14,  0,  383 }, {  15,  0,   53 }, {  17,  0,   63 }, {  19,  0,   46 },
  {  19,  0,   98 }, {  19,  0,  106 }, { 148,  0,   85 }, {   7,  0, 1356 },
  { 132, 10,  290 }, {   6, 10,   70 }, {   7, 10, 1292 }, {  10, 10,  762 },
  { 139, 10,  288 }, { 150, 11,   55 }, {   4,  0,  593 }, {   8, 11,  115 },
  {   8, 11,  350 }, {   9, 11,  489 }, {  10, 11,  128 }, {  11, 11,  306 },
  {  12, 11,  373 }, {  14, 11,   30 }, {  17, 11,   79 }, { 147, 11,   80 },
  { 135, 11, 1235 }, { 134,  0, 1392 }, {   4, 11,  230 }, { 133, 11,  702 },
  { 147,  0,  126 }, {   7, 10,  131 }, {   7, 10,  422 }, {   8, 10,  210 },
  { 140, 10,  573 }, { 134,  0, 1179 }, { 139, 11,  435 }, { 139, 10,  797 },
  { 134, 11, 1728 }, {   4,  0,  162 }, {  18, 11,   26 }, {  19, 11,   42 },
  {  20, 11,   43 }, {  21, 11,    0 }, {  23, 11,   27 }, { 152, 11,   14 },
  { 132, 10,  936 }, {   6,  0,  765 }, {   5, 10,  453 }, { 134, 10,  441 },
  { 133,  0,  187 }, { 135,  0, 1286 }, {   6,  0,  635 }, {   6,  0,  904 },
  {   6,  0, 1210 }, { 134,  0, 1489 }, {   4,  0,  215 }, {   8,  0,  890 },
  {   9,  0,   38 }, {  10,  0,  923 }, {  11,  0,   23 }, {  11,  0,  127 },
  { 139,  0,  796 }, {   6,  0, 1165 }, { 134,  0, 1306 }, {   7,  0,  716 },
  {  13,  0,   97 }, { 141,  0,  251 }, { 132, 10,  653 }, { 136,  0,  657 },
  { 146, 10,   80 }, {   5, 11,  622 }, {   7, 11, 1032 }, {  11, 11,   26 },
  {  11, 11,  213 }, {  11, 11,  707 }, {  12, 11,  380 }, {  13, 11,  226 },
  { 141, 11,  355 }, {   6,  0,  299 }, {   5, 11,   70 }, {   6, 11,  334 },
  {   9, 11,  171 }, {  11, 11,  637 }, {  12, 11,  202 }, {  14, 11,  222 },
  { 145, 11,   42 }, { 142,  0,  134 }, {   4, 11,   23 }, {   5, 11,  313 },
  {   5, 11, 1014 }, {   6, 11,   50 }, {   6, 11,   51 }, {   7, 11,  142 },
  {   7, 11,  384 }, {   9, 11,  783 }, { 139, 11,  741 }, {   4, 11,  141 },
  {   7, 11,  559 }, {   8, 11,  640 }, {   9, 11,  460 }, {  12, 11,  183 },
  { 141, 11,  488 }, { 136, 11,  614 }, {   7, 10, 1368 }, {   8, 10,  232 },
  {   8, 10,  361 }, {  10, 10,  682 }, { 138, 10,  742 }, { 137, 10,  534 },
  {   6,  0, 1082 }, { 140,  0,  658 }, { 137, 10,   27 }, { 135,  0, 2002 },
  { 142, 10,   12 }, {   4,  0,   28 }, {   5,  0,  440 }, {   7,  0,  248 },
  {  11,  0,  833 }, { 140,  0,  344 }, {   7, 10,  736 }, { 139, 10,  264 },
  { 134, 10, 1657 }, { 134,  0, 1654 }, { 138,  0,  531 }, {   5, 11,  222 },
  {   9, 11,  140 }, { 138, 11,  534 }, {   6,  0,  634 }, {   6,  0,  798 },
  { 134,  0,  840 }, { 138, 11,  503 }, { 135, 10,  127 }, { 133,  0,  853 },
  {   5, 11,  154 }, {   7, 11, 1491 }, {  10, 11,  379 }, { 138, 11,  485 },
  {   6,  0,  249 }, {   7,  0, 1234 }, { 139,  0,  573 }, { 133, 11,  716 },
  {   7, 11, 1570 }, { 140, 11,  542 }, { 136, 10,  364 }, { 138,  0,  527 },
  {   4, 11,   91 }, {   5, 11,  388 }, {   5, 11,  845 }, {   6, 11,  206 },
  {   6, 11,  252 }, {   6, 11,  365 }, {   7, 11,  136 }, {   7, 11,  531 },
  {   8, 11,  264 }, { 136, 11,  621 }, { 134,  0, 1419 }, { 135, 11, 1441 },
  {   7,  0,   49 }, {   7,  0,  392 }, {   8,  0,   20 }, {   8,  0,  172 },
  {   8,  0,  690 }, {   9,  0,  383 }, {   9,  0,  845 }, {  10,  0,   48 },
  {  11,  0,  293 }, {  11,  0,  832 }, {  11,  0,  920 }, {  11,  0,  984 },
  { 141,  0,  221 }, {   5,  0,  858 }, { 133,  0,  992 }, {   5,  0,  728 },
  { 137, 10,  792 }, {   5, 10,  909 }, {   9, 10,  849 }, { 138, 10,  805 },
  {   7,  0,  525 }, {   7,  0, 1579 }, {   8,  0,  497 }, { 136,  0,  573 },
  {   6,  0,  268 }, { 137,  0,   62 }, { 135, 11,  576 }, { 134,  0, 1201 },
  {   5, 11,  771 }, {   5, 11,  863 }, {   5, 11,  898 }, {   6, 11, 1632 },
  {   6, 11, 1644 }, { 134, 11, 1780 }, { 133, 11,  331 }, {   7,  0,  193 },
  {   7,  0, 1105 }, {  10,  0,  495 }, {   7, 10,  397 }, {   8, 10,  124 },
  {   8, 10,  619 }, {   9, 10,  305 }, {  11, 10,   40 }, {  12, 10,  349 },
  {  13, 10,  134 }, {  13, 10,  295 }, {  14, 10,  155 }, {  15, 10,  120 },
  { 146, 10,  105 }, { 138,  0,  106 }, {   6,  0,  859 }, {   5, 11,  107 },
  {   7, 11,  201 }, { 136, 11,  518 }, {   6, 11,  446 }, { 135, 11, 1817 },
  {  13,  0,   23 }, {   4, 10,  262 }, { 135, 10,  342 }, { 133, 10,  641 },
  { 137, 11,  851 }, {   6,  0,  925 }, { 137,  0,  813 }, { 132, 11,  504 },
  {   6,  0,  613 }, { 136,  0,  223 }, {   4, 10,   99 }, {   6, 10,  250 },
  {   6, 10,  346 }, {   8, 10,  127 }, { 138, 10,   81 }, { 136,  0,  953 },
  { 132, 10,  915 }, { 139, 11,  892 }, {   5, 10,   75 }, {   9, 10,  517 },
  {  10, 10,  470 }, {  12, 10,  155 }, { 141, 10,  224 }, {   4,  0,  666 },
  {   7,  0, 1017 }, {   7, 11,  996 }, { 138, 11,  390 }, {   5, 11,  883 },
  { 133, 11,  975 }, {  14, 10,   83 }, { 142, 11,   83 }, {   4,  0,  670 },
  {   5, 11,  922 }, { 134, 11, 1707 }, { 135,  0,  216 }, {   9,  0,   40 },
  {  11,  0,  136 }, { 135, 11,  787 }, {   5, 10,  954 }, {   5, 11,  993 },
  {   7, 11,  515 }, { 137, 11,   91 }, { 139,  0,  259 }, {   7,  0, 1114 },
  {   9,  0,  310 }, {   9,  0,  682 }, {  10,  0,  440 }, {  13,  0,   40 },
  {   6, 10,  304 }, {   8, 10,  418 }, {  11, 10,  341 }, { 139, 10,  675 },
  {  14,  0,  296 }, {   9, 10,  410 }, { 139, 10,  425 }, {  10, 11,  377 },
  {  12, 11,  363 }, {  13, 11,   68 }, {  13, 11,   94 }, {  14, 11,  108 },
  { 142, 11,  306 }, {   7,  0, 1401 }, { 135,  0, 1476 }, {   4,  0,  296 },
  {   6,  0,  475 }, {   7,  0,  401 }, {   7,  0, 1410 }, {   7,  0, 1594 },
  {   7,  0, 1674 }, {   8,  0,   63 }, {   8,  0,  660 }, { 137,  0,   74 },
  {   4,  0,  139 }, {   4,  0,  388 }, { 140,  0,  188 }, { 132,  0,  797 },
  { 132, 11,  766 }, {   5, 11,  103 }, {   7, 11,  921 }, {   8, 11,  580 },
  {   8, 11,  593 }, {   8, 11,  630 }, { 138, 11,   28 }, {   4, 11,  911 },
  {   5, 11,  867 }, { 133, 11, 1013 }, { 134, 10,   14 }, { 134,  0, 1572 },
  { 134, 10, 1708 }, {  21,  0,   39 }, {   5, 10,  113 }, {   6, 10,  243 },
  {   7, 10, 1865 }, {  11, 10,  161 }, {  16, 10,   37 }, { 145, 10,   99 },
  {   7, 11, 1563 }, { 141, 11,  182 }, {   5, 11,  135 }, {   6, 11,  519 },
  {   7, 11, 1722 }, {  10, 11,  271 }, {  11, 11,  261 }, { 145, 11,   54 },
  { 132, 10,  274 }, { 134,  0, 1594 }, {   4, 11,  300 }, {   5, 11,  436 },
  { 135, 11,  484 }, {   4,  0,  747 }, {   6,  0,  290 }, {   7,  0,  649 },
  {   7,  0, 1479 }, { 135,  0, 1583 }, { 133, 11,  535 }, { 147, 11,   82 },
  { 133,  0,  232 }, { 137,  0,  887 }, { 135, 10,  166 }, { 136,  0,  521 },
  {   4,  0,   14 }, {   7,  0,  472 }, {   7,  0, 1801 }, {  10,  0,  748 },
  { 141,  0,  458 }, { 134,  0,  741 }, { 134,  0,  992 }, {  16,  0,  111 },
  { 137, 10,  304 }, {   4,  0,  425 }, {   5, 11,  387 }, {   7, 11,  557 },
  {  12, 11,  547 }, { 142, 11,   86 }, { 135, 11, 1747 }, {   5, 10,  654 },
  { 135, 11, 1489 }, {   7,  0,  789 }, {   4, 11,    6 }, {   5, 11,  708 },
  { 136, 11,   75 }, {   6, 10,  273 }, {  10, 10,  188 }, {  13, 10,  377 },
  { 146, 10,   77 }, {   6,  0, 1593 }, {   4, 11,  303 }, {   7, 11,  619 },
  {  10, 11,  547 }, {  10, 11,  687 }, {  11, 11,  122 }, { 140, 11,  601 },
  { 134,  0, 1768 }, { 135, 10,  410 }, { 138, 11,  772 }, {  11,  0,  233 },
  { 139, 10,  524 }, {   5,  0,  943 }, { 134,  0, 1779 }, { 134, 10, 1785 },
  { 136, 11,  529 }, { 132,  0,  955 }, {   5,  0,  245 }, {   6,  0,  576 },
  {   7,  0,  582 }, { 136,  0,  225 }, { 132, 10,  780 }, { 142,  0,  241 },
  { 134,  0, 1943 }, {   4, 11,  106 }, {   7, 11,  310 }, {   7, 11, 1785 },
  {  10, 11,  690 }, { 139, 11,  717 }, { 134,  0, 1284 }, {   5, 11,  890 },
  { 133, 11,  988 }, {   6, 11,  626 }, { 142, 11,  431 }, {  10, 11,  706 },
  { 145, 11,   32 }, { 137, 11,  332 }, { 132, 11,  698 }, { 135,  0,  709 },
  {   5, 10,  948 }, { 138, 11,   17 }, { 136,  0,  554 }, { 134,  0, 1564 },
  { 139, 10,  941 }, { 132,  0,  443 }, { 134,  0,  909 }, { 134, 11,   84 },
  { 142,  0,  280 }, {   4, 10,  532 }, {   5, 10,  706 }, { 135, 10,  662 },
  { 132,  0,  729 }, {   5, 10,  837 }, {   6, 10, 1651 }, { 139, 10,  985 },
  { 135, 10, 1861 }, {   4,  0,  348 }, { 152, 11,    3 }, {   5, 11,  986 },
  {   6, 11,  130 }, {   7, 11, 1582 }, {   8, 11,  458 }, {  10, 11,  101 },
  {  10, 11,  318 }, { 138, 11,  823 }, { 134,  0,  758 }, {   4,  0,  298 },
  { 137,  0,  848 }, {   4, 10,  330 }, {   7, 10,  933 }, {   7, 10, 2012 },
  { 136, 10,  292 }, {   7, 11, 1644 }, { 137, 11,  129 }, {   6,  0, 1422 },
  {   9,  0,  829 }, { 135, 10,  767 }, {   5,  0,  164 }, {   7,  0,  121 },
  { 142,  0,  189 }, {   7,  0,  812 }, {   7,  0, 1261 }, {   7,  0, 1360 },
  {   9,  0,  632 }, { 140,  0,  352 }, { 135, 11, 1788 }, { 139,  0,  556 },
  { 135, 11,  997 }, { 145, 10,  114 }, {   4,  0,  172 }, {   9,  0,  611 },
  {  10,  0,  436 }, {  12,  0,  673 }, {  13,  0,  255 }, { 137, 10,  883 },
  {  11,  0,  530 }, { 138, 10,  274 }, { 133,  0,  844 }, { 134,  0,  984 },
  {  13,  0,  232 }, {  18,  0,   35 }, {   4, 10,  703 }, { 135, 10,  207 },
  { 132, 10,  571 }, {   9,  0,  263 }, {  10,  0,  147 }, { 138,  0,  492 },
  {   7, 11, 1756 }, { 137, 11,   98 }, {   5, 10,  873 }, {   5, 10,  960 },
  {   8, 10,  823 }, { 137, 10,  881 }, { 133,  0,  537 }, { 132,  0,  859 },
  {   7, 11, 1046 }, { 139, 11,  160 }, { 137,  0,  842 }, { 139, 10,  283 },
  {   5, 10,   33 }, {   6, 10,  470 }, { 139, 10,  424 }, {   6, 11,   45 },
  {   7, 11,  433 }, {   8, 11,  129 }, {   9, 11,   21 }, {  10, 11,  392 },
  {  11, 11,   79 }, {  12, 11,  499 }, {  13, 11,  199 }, { 141, 11,  451 },
  { 135,  0, 1291 }, { 135, 10, 1882 }, {   7, 11,  558 }, { 136, 11,  353 },
  { 134,  0, 1482 }, {   5,  0,  230 }, {   5,  0,  392 }, {   6,  0,  420 },
  {   9,  0,  568 }, { 140,  0,  612 }, {   6,  0,  262 }, {   7, 10,   90 },
  {   7, 10,  664 }, {   7, 10,  830 }, {   7, 10, 1380 }, {   7, 10, 2025 },
  {   8, 11,   81 }, {   8, 10,  448 }, {   8, 10,  828 }, {   9, 11,  189 },
  {   9, 11,  201 }, {  11, 11,  478 }, {  11, 11,  712 }, { 141, 11,  338 },
  { 142,  0,   31 }, {   5, 11,  353 }, { 151, 11,   26 }, { 132,  0,  753 },
  {   4,  0,    0 }, {   5,  0,   41 }, {   7,  0, 1459 }, {   7,  0, 1469 },
  {   7,  0, 1859 }, {   9,  0,  549 }, { 139,  0,  905 }, {   9, 10,  417 },
  { 137, 10,  493 }, { 135, 11, 1113 }, { 133,  0,  696 }, { 141, 11,  448 },
  { 134, 10,  295 }, { 132,  0,  834 }, {   4,  0,  771 }, {   5, 10, 1019 },
  {   6, 11,   25 }, {   7, 11,  855 }, {   7, 11, 1258 }, { 144, 11,   32 },
  { 134,  0, 1076 }, { 133,  0,  921 }, { 133,  0,  674 }, {   4, 11,    4 },
  {   7, 11, 1118 }, {   7, 11, 1320 }, {   7, 11, 1706 }, {   8, 11,  277 },
  {   9, 11,  622 }, {  10, 11,    9 }, {  11, 11,  724 }, {  12, 11,  350 },
  {  12, 11,  397 }, {  13, 11,   28 }, {  13, 11,  159 }, {  15, 11,   89 },
  {  18, 11,    5 }, {  19, 11,    9 }, {  20, 11,   34 }, { 150, 11,   47 },
  { 134, 10,  208 }, {   6,  0,  444 }, { 136,  0,  308 }, {   6,  0,  180 },
  {   7,  0, 1137 }, {   8,  0,  751 }, { 139,  0,  805 }, {   4,  0,  183 },
  {   7,  0,  271 }, {  11,  0,  824 }, {  11,  0,  952 }, {  13,  0,  278 },
  {  13,  0,  339 }, {  13,  0,  482 }, {  14,  0,  424 }, { 148,  0,   99 },
  {   7, 11,  317 }, { 135, 11,  569 }, {   4,  0,   19 }, {   5,  0,  477 },
  {   5,  0,  596 }, {   6,  0,  505 }, {   7,  0, 1221 }, {  11,  0,  907 },
  {  12,  0,  209 }, { 141,  0,  214 }, { 135,  0, 1215 }, {   6,  0,  271 },
  {   7,  0,  398 }, {   8,  0,  387 }, {  10,  0,  344 }, {   7, 10,  448 },
  {   7, 10, 1629 }, {   7, 10, 1813 }, {   8, 10,  442 }, {   9, 10,  710 },
  {  10, 10,  282 }, { 138, 10,  722 }, {  11, 10,  844 }, {  12, 10,  104 },
  { 140, 10,  625 }, { 134, 11,  255 }, { 133, 10,  787 }, { 134,  0, 1645 },
  {  11, 11,  956 }, { 151, 11,    3 }, {   6,  0,   92 }, {   6,  0,  188 },
  {   7,  0,  209 }, {   7,  0, 1269 }, {   7,  0, 1524 }, {   7,  0, 1876 },
  {   8,  0,  661 }, {  10,  0,   42 }, {  10,  0,  228 }, {  11,  0,   58 },
  {  11,  0, 1020 }, {  12,  0,   58 }, {  12,  0,  118 }, { 141,  0,   32 },
  {   4,  0,  459 }, { 133,  0,  966 }, {   4, 11,  536 }, {   7, 11, 1141 },
  {  10, 11,  723 }, { 139, 11,  371 }, { 140,  0,  330 }, { 134,  0, 1557 },
  {   7, 11,  285 }, { 135, 11,  876 }, { 136, 10,  491 }, { 135, 11,  560 },
  {   6,  0,   18 }, {   7,  0,  179 }, {   7,  0,  932 }, {   8,  0,  548 },
  {   8,  0,  757 }, {   9,  0,   54 }, {   9,  0,   65 }, {   9,  0,  532 },
  {   9,  0,  844 }, {  10,  0,  113 }, {  10,  0,  117 }, {  10,  0,  315 },
  {  10,  0,  560 }, {  10,  0,  622 }, {  10,  0,  798 }, {  11,  0,  153 },
  {  11,  0,  351 }, {  11,  0,  375 }, {  12,  0,   78 }, {  12,  0,  151 },
  {  12,  0,  392 }, {  12,  0,  666 }, {  14,  0,  248 }, { 143,  0,   23 },
  {   6,  0, 1742 }, { 132, 11,  690 }, {   4, 10,  403 }, {   5, 10,  441 },
  {   7, 10,  450 }, {  10, 10,  840 }, {  11, 10,  101 }, {  12, 10,  193 },
  { 141, 10,  430 }, { 133,  0,  965 }, { 134,  0,  182 }, {  10,  0,   65 },
  {  10,  0,  488 }, { 138,  0,  497 }, { 135, 11, 1346 }, {   6,  0,  973 },
  {   6,  0, 1158 }, {  10, 11,  200 }, {  19, 11,    2 }, { 151, 11,   22 },
  {   4, 11,  190 }, { 133, 11,  554 }, { 133, 10,  679 }, {   7,  0,  328 },
  { 137, 10,  326 }, { 133, 11, 1001 }, {   9,  0,  588 }, { 138,  0,  260 },
  { 133, 11,  446 }, { 135, 10, 1128 }, { 135, 10, 1796 }, { 147, 11,  119 },
  { 134,  0, 1786 }, {   6,  0, 1328 }, {   6,  0, 1985 }, {   8,  0,  962 },
  { 138,  0, 1017 }, { 135,  0,  308 }, {  11,  0,  508 }, {   4, 10,  574 },
  {   7, 10,  350 }, {   7, 10, 1024 }, {   8, 10,  338 }, {   9, 10,  677 },
  { 138, 10,  808 }, { 138, 11,  752 }, { 135, 10, 1081 }, { 137, 11,   96 },
  {   7, 10, 1676 }, { 135, 10, 2037 }, { 136,  0,  588 }, { 132, 11,  304 },
  { 133,  0,  614 }, { 140,  0,  793 }, { 136,  0,  287 }, { 137, 10,  297 },
  { 141, 10,   37 }, {   6, 11,   53 }, {   6, 11,  199 }, {   7, 11, 1408 },
  {   8, 11,   32 }, {   8, 11,   93 }, {   9, 11,  437 }, {  10, 11,  397 },
  {  10, 11,  629 }, {  11, 11,  593 }, {  11, 11,  763 }, {  13, 11,  326 },
  { 145, 11,   35 }, { 134, 11,  105 }, {   9, 11,  320 }, {  10, 11,  506 },
  { 138, 11,  794 }, {   5, 11,  114 }, {   5, 11,  255 }, { 141, 11,  285 },
  { 140,  0,  290 }, {   7, 11, 2035 }, {   8, 11,   19 }, {   9, 11,   89 },
  { 138, 11,  831 }, { 134,  0, 1136 }, {   7,  0,  719 }, {   8,  0,  796 },
  {   8,  0,  809 }, {   8,  0,  834 }, {   6, 10,  306 }, {   7, 10, 1140 },
  {   7, 10, 1340 }, {   8, 10,  133 }, { 138, 10,  449 }, { 139, 10, 1011 },
  {   5,  0,  210 }, {   6,  0,  213 }, {   7,  0,   60 }, {  10,  0,  364 },
  { 139,  0,  135 }, {   5,  0,  607 }, {   8,  0,  326 }, { 136,  0,  490 },
  { 138, 11,  176 }, { 132,  0,  701 }, {   5,  0,  472 }, {   7,  0,  380 },
  { 137,  0,  758 }, { 135,  0, 1947 }, {   6,  0, 1079 }, { 138,  0,  278 },
  { 138, 11,  391 }, {   5, 10,  329 }, {   8, 10,  260 }, { 139, 11,  156 },
  {   4,  0,  386 }, {   7,  0,   41 }, {   8,  0,  405 }, {   8,  0,  728 },
  {   9,  0,  497 }, {  11,  0,  110 }, {  11,  0,  360 }, {  15,  0,   37 },
  { 144,  0,   84 }, {   5,  0,   46 }, {   7,  0, 1452 }, {   7,  0, 1480 },
  {   8,  0,  634 }, { 140,  0,  472 }, { 136,  0,  961 }, {   4,  0,  524 },
  { 136,  0,  810 }, {  10,  0,  238 }, { 141,  0,   33 }, { 132, 10,  657 },
  { 152, 10,    7 }, { 133,  0,  532 }, {   5,  0,  997 }, { 135, 10, 1665 },
  {   7, 11,  594 }, {   7, 11,  851 }, {   7, 11, 1858 }, {   9, 11,  411 },
  {   9, 11,  574 }, {   9, 11,  666 }, {   9, 11,  737 }, {  10, 11,  346 },
  {  10, 11,  712 }, {  11, 11,  246 }, {  11, 11,  432 }, {  11, 11,  517 },
  {  11, 11,  647 }, {  11, 11,  679 }, {  11, 11,  727 }, {  12, 11,  304 },
  {  12, 11,  305 }, {  12, 11,  323 }, {  12, 11,  483 }, {  12, 11,  572 },
  {  12, 11,  593 }, {  12, 11,  602 }, {  13, 11,   95 }, {  13, 11,  101 },
  {  13, 11,  171 }, {  13, 11,  315 }, {  13, 11,  378 }, {  13, 11,  425 },
  {  13, 11,  475 }, {  14, 11,   63 }, {  14, 11,  380 }, {  14, 11,  384 },
  {  15, 11,  133 }, {  18, 11,  112 }, { 148, 11,   72 }, {   5, 11,  955 },
  { 136, 11,  814 }, { 134,  0, 1301 }, {   5, 10,   66 }, {   7, 10, 1896 },
  { 136, 10,  288 }, { 133, 11,   56 }, { 134, 10, 1643 }, {   6,  0, 1298 },
  { 148, 11,  100 }, {   5,  0,  782 }, {   5,  0,  829 }, {   6,  0,  671 },
  {   6,  0, 1156 }, {   6,  0, 1738 }, { 137, 11,  621 }, {   4,  0,  306 },
  {   5,  0,  570 }, {   7,  0, 1347 }, {   5, 10,   91 }, {   5, 10,  648 },
  {   5, 10,  750 }, {   5, 10,  781 }, {   6, 10,   54 }, {   6, 10,  112 },
  {   6, 10,  402 }, {   6, 10, 1732 }, {   7, 10,  315 }, {   7, 10,  749 },
  {   7, 10, 1900 }, {   9, 10,   78 }, {   9, 10,  508 }, {  10, 10,  611 },
  {  10, 10,  811 }, {  11, 10,  510 }, {  11, 10,  728 }, {  13, 10,   36 },
  {  14, 10,   39 }, {  16, 10,   83 }, {  17, 10,  124 }, { 148, 10,   30 },
  {   8, 10,  570 }, {   9, 11,  477 }, { 141, 11,   78 }, {   4, 11,  639 },
  {  10, 11,    4 }, {  10, 10,  322 }, {  10, 10,  719 }, {  11, 10,  407 },
  {  11, 11,  638 }, {  12, 11,  177 }, { 148, 11,   57 }, {   7,  0, 1823 },
  { 139,  0,  693 }, {   7,  0,  759 }, {   5, 11,  758 }, {   8, 10,  125 },
  {   8, 10,  369 }, {   8, 10,  524 }, {  10, 10,  486 }, {  11, 10,   13 },
  {  11, 10,  381 }, {  11, 10,  736 }, {  11, 10,  766 }, {  11, 10,  845 },
  {  13, 10,  114 }, {  13, 10,  292 }, { 142, 10,   47 }, {   7,  0, 1932 },
  {   6, 10, 1684 }, {   6, 10, 1731 }, {   7, 10,  356 }, {   8, 10,   54 },
  {   8, 10,  221 }, {   9, 10,  225 }, {   9, 10,  356 }, {  10, 10,   77 },
  {  10, 10,  446 }, {  10, 10,  731 }, {  12, 10,  404 }, { 141, 10,  491 },
  { 135, 11,  552 }, { 135, 11, 1112 }, {   4,  0,   78 }, {   5,  0,   96 },
  {   5,  0,  182 }, {   6,  0, 1257 }, {   7,  0, 1724 }, {   7,  0, 1825 },
  {  10,  0,  394 }, {  10,  0,  471 }, {  11,  0,  532 }, {  14,  0,  340 },
  { 145,  0,   88 }, { 139, 11,  328 }, { 135,  0, 1964 }, { 132, 10,  411 },
  {   4, 10,   80 }, {   5, 10,   44 }, { 137, 11,  133 }, {   5, 11,  110 },
  {   6, 11,  169 }, {   6, 11, 1702 }, {   7, 11,  400 }, {   8, 11,  538 },
  {   9, 11,  184 }, {   9, 11,  524 }, { 140, 11,  218 }, {   4,  0,  521 },
  {   5, 10,  299 }, {   7, 10, 1083 }, { 140, 11,  554 }, {   6, 11,  133 },
  {   9, 11,  353 }, {  12, 11,  628 }, { 146, 11,   79 }, {   6,  0,  215 },
  {   7,  0,  584 }, {   7,  0, 1028 }, {   7,  0, 1473 }, {   7,  0, 1721 },
  {   9,  0,  424 }, { 138,  0,  779 }, {   7,  0,  857 }, {   7,  0, 1209 },
  {   7, 10, 1713 }, {   9, 10,  537 }, {  10, 10,  165 }, {  12, 10,  219 },
  { 140, 10,  561 }, {   4, 10,  219 }, {   6, 11,   93 }, {   7, 11, 1422 },
  {   7, 10, 1761 }, {   7, 11, 1851 }, {   8, 11,  673 }, {   9, 10,   86 },
  {   9, 11,  529 }, { 140, 11,   43 }, { 137, 11,  371 }, { 136,  0,  671 },
  {   5,  0,  328 }, { 135,  0,  918 }, { 132,  0,  529 }, {   9, 11,   25 },
  {  10, 11,  467 }, { 138, 11,  559 }, {   4, 11,  335 }, { 135, 11,  942 },
  { 134,  0,  716 }, { 134,  0, 1509 }, {   6,  0,   67 }, {   7,  0,  258 },
  {   7,  0, 1630 }, {   9,  0,  354 }, {   9,  0,  675 }, {  10,  0,  830 },
  {  14,  0,   80 }, {  17,  0,   80 }, { 140, 10,  428 }, { 134,  0, 1112 },
  {   6,  0,  141 }, {   7,  0,  225 }, {   9,  0,   59 }, {   9,  0,  607 },
  {  10,  0,  312 }, {  11,  0,  687 }, {  12,  0,  555 }, {  13,  0,  373 },
  {  13,  0,  494 }, { 148,  0,   58 }, { 133, 10,  514 }, {   8, 11,   39 },
  {  10, 11,  773 }, {  11, 11,   84 }, {  12, 11,  205 }, { 142, 11,    1 },
  {   8,  0,  783 }, {   5, 11,  601 }, { 133, 11,  870 }, { 136, 11,  594 },
  {   4, 10,   55 }, {   5, 10,  301 }, {   6, 10,  571 }, {  14, 10,   49 },
  { 146, 10,  102 }, { 132, 11,  181 }, { 134, 11, 1652 }, { 133, 10,  364 },
  {   4, 11,   97 }, {   5, 11,  147 }, {   6, 11,  286 }, {   7, 11, 1362 },
  { 141, 11,  176 }, {   4, 10,   76 }, {   7, 10, 1550 }, {   9, 10,  306 },
  {   9, 10,  430 }, {   9, 10,  663 }, {  10, 10,  683 }, {  11, 10,  427 },
  {  11, 10,  753 }, {  12, 10,  334 }, {  12, 10,  442 }, {  14, 10,  258 },
  {  14, 10,  366 }, { 143, 10,  131 }, { 137, 10,   52 }, {   6,  0,  955 },
  { 134,  0, 1498 }, {   6, 11,  375 }, {   7, 11,  169 }, {   7, 11,  254 },
  { 136, 11,  780 }, {   7,  0,  430 }, {  11,  0,   46 }, {  14,  0,  343 },
  { 142, 11,  343 }, { 135,  0, 1183 }, {   5,  0,  602 }, {   7,  0, 2018 },
  {   9,  0,  418 }, {   9,  0,  803 }, { 135, 11, 1447 }, {   8,  0,  677 },
  { 135, 11, 1044 }, { 139, 11,  285 }, {   4, 10,  656 }, { 135, 10,  779 },
  { 135, 10,  144 }, {   5, 11,  629 }, { 135, 11, 1549 }, { 135, 10, 1373 },
  { 138, 11,  209 }, {   7, 10,  554 }, {   7, 10,  605 }, { 141, 10,   10 },
  {   5, 10,  838 }, {   5, 10,  841 }, { 134, 10, 1649 }, { 133, 10, 1012 },
  {   6,  0, 1357 }, { 134,  0, 1380 }, { 144,  0,   53 }, {   6,  0,  590 },
  {   7, 10,  365 }, {   7, 10, 1357 }, {   7, 10, 1497 }, {   8, 10,  154 },
  { 141, 10,  281 }, { 133, 10,  340 }, { 132, 11,  420 }, { 135,  0,  329 },
  { 147, 11,   32 }, {   4,  0,  469 }, {  10, 11,  429 }, { 139, 10,  495 },
  {   8, 10,  261 }, {   9, 10,  144 }, {   9, 10,  466 }, {  10, 10,  370 },
  {  12, 10,  470 }, {  13, 10,  144 }, { 142, 10,  348 }, { 142,  0,  460 },
  {   4, 11,  325 }, {   9, 10,  897 }, { 138, 11,  125 }, {   6,  0, 1743 },
  {   6, 10,  248 }, {   9, 10,  546 }, {  10, 10,  535 }, {  11, 10,  681 },
  { 141, 10,  135 }, {   4,  0,  990 }, {   5,  0,  929 }, {   6,  0,  340 },
  {   8,  0,  376 }, {   8,  0,  807 }, {   8,  0,  963 }, {   8,  0,  980 },
  { 138,  0, 1007 }, { 134,  0, 1603 }, { 140,  0,  250 }, {   4, 11,  714 },
  { 133, 11,  469 }, { 134, 10,  567 }, { 136, 10,  445 }, {   5,  0,  218 },
  {   7,  0, 1610 }, {   8,  0,  646 }, {  10,  0,   83 }, {  11, 11,  138 },
  { 140, 11,   40 }, {   7,  0, 1512 }, { 135,  0, 1794 }, { 135, 11, 1216 },
  {  11,  0,    0 }, {  16,  0,   78 }, { 132, 11,  718 }, { 133,  0,  571 },
  { 132,  0,  455 }, { 134,  0, 1012 }, {   5, 11,  124 }, {   5, 11,  144 },
  {   6, 11,  548 }, {   7, 11,   15 }, {   7, 11,  153 }, { 137, 11,  629 },
  { 142, 11,   10 }, {   6, 11,   75 }, {   7, 11, 1531 }, {   8, 11,  416 },
  {   9, 11,  240 }, {   9, 11,  275 }, {  10, 11,  100 }, {  11, 11,  658 },
  {  11, 11,  979 }, {  12, 11,   86 }, {  13, 11,  468 }, {  14, 11,   66 },
  {  14, 11,  207 }, {  15, 11,   20 }, {  15, 11,   25 }, { 144, 11,   58 },
  { 132, 10,  577 }, {   5, 11,  141 }, {   5, 11,  915 }, {   6, 11, 1783 },
  {   7, 11,  211 }, {   7, 11,  698 }, {   7, 11, 1353 }, {   9, 11,   83 },
  {   9, 11,  281 }, {  10, 11,  376 }, {  10, 11,  431 }, {  11, 11,  543 },
  {  12, 11,  664 }, {  13, 11,  280 }, {  13, 11,  428 }, {  14, 11,   61 },
  {  14, 11,  128 }, {  17, 11,   52 }, { 145, 11,   81 }, {   6,  0,  161 },
  {   7,  0,  372 }, { 137,  0,  597 }, { 132,  0,  349 }, {  10, 11,  702 },
  { 139, 11,  245 }, { 134,  0,  524 }, { 134, 10,  174 }, {   6,  0,  432 },
  {   9,  0,  751 }, { 139,  0,  322 }, { 147, 11,   94 }, {   4, 11,  338 },
  { 133, 11,  400 }, {   5,  0,  468 }, {  10,  0,  325 }, {  11,  0,  856 },
  {  12,  0,  345 }, { 143,  0,  104 }, { 133,  0,  223 }, { 132,  0,  566 },
  {   4, 11,  221 }, {   5, 11,  659 }, {   5, 11,  989 }, {   7, 11,  697 },
  {   7, 11, 1211 }, { 138, 11,  284 }, { 135, 11, 1070 }, {   4,  0,   59 },
  { 135,  0, 1394 }, {   6,  0,  436 }, {  11,  0,  481 }, {   5, 10,  878 },
  { 133, 10,  972 }, {   4,  0,   48 }, {   5,  0,  271 }, { 135,  0,  953 },
  {   5,  0,  610 }, { 136,  0,  457 }, {   4,  0,  773 }, {   5,  0,  618 },
  { 137,  0,  756 }, { 133,  0,  755 }, { 135,  0, 1217 }, { 138, 11,  507 },
  { 132, 10,  351 }, { 132,  0,  197 }, { 143, 11,   78 }, {   4, 11,  188 },
  {   7, 11,  805 }, {  11, 11,  276 }, { 142, 11,  293 }, {   5, 11,  884 },
  { 139, 11,  991 }, { 132, 10,  286 }, {  10,  0,  259 }, {  10,  0,  428 },
  {   7, 10,  438 }, {   7, 10,  627 }, {   7, 10, 1516 }, {   8, 10,   40 },
  {   9, 10,   56 }, {   9, 10,  294 }, {  11, 10,  969 }, {  11, 10,  995 },
  { 146, 10,  148 }, {   4,  0,  356 }, {   5,  0,  217 }, {   5,  0,  492 },
  {   5,  0,  656 }, {   8,  0,  544 }, { 136, 11,  544 }, {   5,  0,  259 },
  {   6,  0, 1230 }, {   7,  0,  414 }, {   7,  0,  854 }, { 142,  0,  107 },
  { 132,  0, 1007 }, {  15,  0,   14 }, { 144,  0,    5 }, {   6,  0, 1580 },
  { 132, 10,  738 }, { 132, 11,  596 }, { 132,  0,  673 }, { 133, 10,  866 },
  {   6,  0, 1843 }, { 135, 11, 1847 }, {   4,  0,  165 }, {   7,  0, 1398 },
  { 135,  0, 1829 }, { 135, 11, 1634 }, { 147, 11,   65 }, {   6,  0,  885 },
  {   6,  0, 1009 }, { 137,  0,  809 }, { 133, 10,  116 }, { 132, 10,  457 },
  { 136, 11,  770 }, {   9,  0,  498 }, {  12,  0,  181 }, {  10, 11,  361 },
  { 142, 11,  316 }, { 134, 11,  595 }, {   5,  0,    9 }, {   7,  0,  297 },
  {   7,  0,  966 }, { 140,  0,  306 }, {   4, 11,   89 }, {   5, 11,  489 },
  {   6, 11,  315 }, {   7, 11,  553 }, {   7, 11, 1745 }, { 138, 11,  243 },
  { 134,  0, 1487 }, { 132,  0,  437 }, {   5,  0,  146 }, {   6,  0,  411 },
  { 138,  0,  721 }, {   5, 10,  527 }, {   6, 10,  189 }, { 135, 10,  859 },
  {  11, 10,  104 }, {  11, 10,  554 }, {  15, 10,   60 }, { 143, 10,  125 },
  {   6, 11, 1658 }, {   9, 11,    3 }, {  10, 11,  154 }, {  11, 11,  641 },
  {  13, 11,   85 }, {  13, 11,  201 }, { 141, 11,  346 }, {   6,  0,  177 },
  { 135,  0,  467 }, { 134,  0, 1377 }, { 134, 10,  116 }, { 136, 11,  645 },
  {   4, 11,  166 }, {   5, 11,  505 }, {   6, 11, 1670 }, { 137, 11,  110 },
  { 133, 10,  487 }, {   4, 10,   86 }, {   5, 10,  667 }, {   5, 10,  753 },
  {   6, 10,  316 }, {   6, 10,  455 }, { 135, 10,  946 }, { 133,  0,  200 },
  { 132,  0,  959 }, {   6,  0, 1928 }, { 134,  0, 1957 }, { 139, 11,  203 },
  { 150, 10,   45 }, {   4, 10,   79 }, {   7, 10, 1773 }, {  10, 10,  450 },
  {  11, 10,  589 }, {  13, 10,  332 }, {  13, 10,  493 }, {  14, 10,  183 },
  {  14, 10,  334 }, {  14, 10,  362 }, {  14, 10,  368 }, {  14, 10,  376 },
  {  14, 10,  379 }, {  19, 10,   90 }, {  19, 10,  103 }, {  19, 10,  127 },
  { 148, 10,   90 }, {   6,  0, 1435 }, { 135, 11, 1275 }, { 134,  0,  481 },
  {   7, 11,  445 }, {   8, 11,  307 }, {   8, 11,  704 }, {  10, 11,   41 },
  {  10, 11,  439 }, {  11, 11,  237 }, {  11, 11,  622 }, { 140, 11,  201 },
  { 135, 11,  869 }, {   4,  0,   84 }, {   7,  0, 1482 }, {  10,  0,   76 },
  { 138,  0,  142 }, {  11, 11,  277 }, { 144, 11,   14 }, { 135, 11, 1977 },
  {   4, 11,  189 }, {   5, 11,  713 }, { 136, 11,   57 }, { 133,  0, 1015 },
  { 138, 11,  371 }, {   4,  0,  315 }, {   5,  0,  507 }, { 135,  0, 1370 },
  {   4, 11,  552 }, { 142, 10,  381 }, {   9,  0,  759 }, {  16,  0,   31 },
  {  16,  0,   39 }, {  16,  0,   75 }, {  18,  0,   24 }, {  20,  0,   42 },
  { 152,  0,    1 }, { 134,  0,  712 }, { 134,  0, 1722 }, { 133, 10,  663 },
  { 133, 10,  846 }, {   8,  0,  222 }, {   8,  0,  476 }, {   9,  0,  238 },
  {  11,  0,  516 }, {  11,  0,  575 }, {  15,  0,  109 }, { 146,  0,  100 },
  {   7,  0, 1402 }, {   7,  0, 1414 }, {  12,  0,  456 }, {   5, 10,  378 },
  {   8, 10,  465 }, {   9, 10,  286 }, {  10, 10,  185 }, {  10, 10,  562 },
  {  10, 10,  635 }, {  11, 10,   31 }, {  11, 10,  393 }, {  13, 10,  312 },
  {  18, 10,   65 }, {  18, 10,   96 }, { 147, 10,   89 }, {   4,  0,  986 },
  {   6,  0, 1958 }, {   6,  0, 2032 }, {   8,  0,  934 }, { 138,  0,  985 },
  {   7, 10, 1880 }, {   9, 10,  680 }, { 139, 10,  798 }, { 134, 10, 1770 },
  { 145, 11,   49 }, { 132, 11,  614 }, { 132, 10,  648 }, {   5, 10,  945 },
  {   6, 10, 1656 }, {   6, 10, 1787 }, {   7, 10,  167 }, {   8, 10,  824 },
  {   9, 10,  391 }, {  10, 10,  375 }, { 139, 10,  185 }, { 138, 11,  661 },
  {   7,  0, 1273 }, { 135, 11, 1945 }, {   7,  0,  706 }, {   7,  0, 1058 },
  { 138,  0,  538 }, {   7, 10, 1645 }, {   8, 10,  352 }, { 137, 10,  249 },
  { 132, 10,  152 }, {  11,  0,   92 }, {  11,  0,  196 }, {  11,  0,  409 },
  {  11,  0,  450 }, {  11,  0,  666 }, {  11,  0,  777 }, {  12,  0,  262 },
  {  13,  0,  385 }, {  13,  0,  393 }, {  15,  0,  115 }, {  16,  0,   45 },
  { 145,  0,   82 }, { 133, 10, 1006 }, {   6,  0,   40 }, { 135,  0, 1781 },
  {   9, 11,  614 }, { 139, 11,  327 }, {   5, 10,  420 }, { 135, 10, 1449 },
  { 135,  0,  431 }, {  10,  0,   97 }, { 135, 10,  832 }, {   6,  0,  423 },
  {   7,  0,  665 }, { 135,  0, 1210 }, {   7,  0,  237 }, {   8,  0,  664 },
  {   9,  0,   42 }, {   9,  0,  266 }, {   9,  0,  380 }, {   9,  0,  645 },
  {  10,  0,  177 }, { 138,  0,  276 }, {   7,  0,  264 }, { 133, 10,  351 },
  {   8,  0,  213 }, {   5, 10,   40 }, {   7, 10,  598 }, {   7, 10, 1638 },
  {   9, 10,  166 }, {   9, 10,  640 }, {   9, 10,  685 }, {   9, 10,  773 },
  {  11, 10,  215 }, {  13, 10,   65 }, {  14, 10,  172 }, {  14, 10,  317 },
  { 145, 10,    6 }, {   5, 11,   84 }, { 134, 11,  163 }, {   8, 10,   60 },
  {   9, 10,  343 }, { 139, 10,  769 }, { 137,  0,  455 }, { 133, 11,  410 },
  {   8,  0,  906 }, {  12,  0,  700 }, {  12,  0,  706 }, { 140,  0,  729 },
  {  21, 11,   33 }, { 150, 11,   40 }, {   7, 10, 1951 }, {   8, 10,  765 },
  {   8, 10,  772 }, { 140, 10,  671 }, {   7, 10,  108 }, {   8, 10,  219 },
  {   8, 10,  388 }, {   9, 10,  639 }, {   9, 10,  775 }, {  11, 10,  275 },
  { 140, 10,  464 }, {   5, 11,  322 }, {   7, 11, 1941 }, {   8, 11,  186 },
  {   9, 11,  262 }, {  10, 11,  187 }, {  14, 11,  208 }, { 146, 11,  130 },
  { 139,  0,  624 }, {   8,  0,  574 }, {   5, 11,  227 }, { 140, 11,   29 },
  {   7, 11, 1546 }, {  11, 11,  299 }, { 142, 11,  407 }, {   5, 10,   15 },
  {   6, 10,   56 }, {   7, 10, 1758 }, {   8, 10,  500 }, {   9, 10,  730 },
  {  11, 10,  331 }, {  13, 10,  150 }, { 142, 10,  282 }, {   7, 11, 1395 },
  {   8, 11,  486 }, {   9, 11,  236 }, {   9, 11,  878 }, {  10, 11,  218 },
  {  11, 11,   95 }, {  19, 11,   17 }, { 147, 11,   31 }, { 135, 11, 2043 },
  {   4,  0,  354 }, { 146, 11,    4 }, { 140, 11,   80 }, { 135,  0, 1558 },
  { 134, 10, 1886 }, {   5, 10,  205 }, {   6, 10,  438 }, { 137, 10,  711 },
  { 133, 11,  522 }, { 133, 10,  534 }, {   7,  0,  235 }, {   7,  0, 1475 },
  {  15,  0,   68 }, { 146,  0,  120 }, { 137, 10,  691 }, {   4,  0,  942 },
  {   6,  0, 1813 }, {   8,  0,  917 }, {  10,  0,  884 }, {  12,  0,  696 },
  {  12,  0,  717 }, {  12,  0,  723 }, {  12,  0,  738 }, {  12,  0,  749 },
  {  12,  0,  780 }, {  16,  0,   97 }, { 146,  0,  169 }, {   6, 10,  443 },
  {   8, 11,  562 }, {   9, 10,  237 }, {   9, 10,  571 }, {   9, 10,  695 },
  {  10, 10,  139 }, {  11, 10,  715 }, {  12, 10,  417 }, { 141, 10,  421 },
  { 135,  0,  957 }, { 133,  0,  830 }, { 134, 11, 1771 }, { 146,  0,   23 },
  {   5,  0,  496 }, {   6,  0,  694 }, {   7,  0,  203 }, {   7, 11, 1190 },
  { 137, 11,  620 }, { 137, 11,  132 }, {   6,  0,  547 }, { 134,  0, 1549 },
  {   8, 11,  258 }, {   9, 11,  208 }, { 137, 11,  359 }, {   4,  0,  864 },
  {   5,  0,   88 }, { 137,  0,  239 }, { 135, 11,  493 }, {   4, 11,  317 },
  { 135, 11, 1279 }, { 132, 11,  477 }, {   4, 10,  578 }, {   5, 11,   63 },
  { 133, 11,  509 }, {   7,  0,  650 }, { 135,  0, 1310 }, {   7,  0, 1076 },
  {   9,  0,   80 }, {  11,  0,   78 }, {  11,  0,  421 }, {  11,  0,  534 },
  { 140,  0,  545 }, { 132, 11,  288 }, {  12,  0,  553 }, {  14,  0,  118 },
  { 133, 10,  923 }, {   7,  0,  274 }, {  11,  0,  479 }, { 139,  0,  507 },
  {   8, 11,   89 }, {   8, 11,  620 }, {   9, 11,   49 }, {  10, 11,  774 },
  {  11, 11,  628 }, {  12, 11,  322 }, { 143, 11,  124 }, {   4,  0,  497 },
  { 135,  0, 1584 }, {   7,  0,  261 }, {   7,  0, 1115 }, {   7,  0, 1354 },
  {   7,  0, 1404 }, {   7,  0, 1588 }, {   7,  0, 1705 }, {   7,  0, 1902 },
  {   9,  0,  465 }, {  10,  0,  248 }, {  10,  0,  349 }, {  10,  0,  647 },
  {  11,  0,  527 }, {  11,  0,  660 }, {  11,  0,  669 }, {  12,  0,  529 },
  {  13,  0,  305 }, { 132, 10,  924 }, { 133, 10,  665 }, { 136,  0,   13 },
  {   6,  0,  791 }, { 138, 11,  120 }, {   7,  0,  642 }, {   8,  0,  250 },
  {  11,  0,  123 }, {  11,  0,  137 }, {  13,  0,   48 }, { 142,  0,   95 },
  {   4, 10,  265 }, {   7, 10,  807 }, { 135, 10,  950 }, {   5, 10,   93 },
  { 140, 10,  267 }, { 135,  0, 1429 }, {   4,  0,  949 }, {  10,  0,  885 },
  {  10,  0,  891 }, {  10,  0,  900 }, {  10,  0,  939 }, {  12,  0,  760 },
  { 142,  0,  449 }, { 139, 11,  366 }, { 132,  0,  818 }, { 134, 11,   85 },
  { 135, 10,  994 }, {   7,  0,  330 }, {   5, 10,  233 }, {   5, 10,  320 },
  {   6, 10,  140 }, { 136, 10,  295 }, {   4,  0, 1004 }, {   8,  0,  982 },
  { 136,  0,  993 }, { 133, 10,  978 }, {   4, 10,  905 }, {   6, 10, 1701 },
  { 137, 10,  843 }, {  10,  0,  545 }, { 140,  0,  301 }, {   6,  0,  947 },
  { 134,  0, 1062 }, { 134,  0, 1188 }, {   4,  0,  904 }, {   5,  0,  794 },
  { 152, 10,    6 }, { 134,  0, 1372 }, { 135, 11,  608 }, {   5, 11,  279 },
  {   6, 11,  235 }, {   7, 11,  468 }, {   8, 11,  446 }, {   9, 11,  637 },
  {  10, 11,  717 }, {  11, 11,  738 }, { 140, 11,  514 }, { 132, 10,  509 },
  {   5, 11,   17 }, {   6, 11,  371 }, { 137, 11,  528 }, { 132,  0,  693 },
  {   4, 11,  115 }, {   5, 11,  669 }, {   6, 11,  407 }, {   8, 11,  311 },
  {  11, 11,   10 }, { 141, 11,    5 }, {  11,  0,  377 }, {   7, 10,  273 },
  { 137, 11,  381 }, { 135,  0,  695 }, {   7,  0,  386 }, { 138,  0,  713 },
  { 135, 10, 1041 }, { 134,  0, 1291 }, {   6,  0,    7 }, {   6,  0,   35 },
  {   7,  0,  147 }, {   7,  0, 1069 }, {   7,  0, 1568 }, {   7,  0, 1575 },
  {   7,  0, 1917 }, {   8,  0,   43 }, {   8,  0,  208 }, {   9,  0,  128 },
  {   9,  0,  866 }, {  10,  0,   20 }, {  11,  0,  981 }, { 147,  0,   33 },
  {   7,  0,  893 }, { 141,  0,  424 }, { 139, 10,  234 }, { 150, 11,   56 },
  {   5, 11,  779 }, {   5, 11,  807 }, {   6, 11, 1655 }, { 134, 11, 1676 },
  {   5, 10,  802 }, {   7, 10, 2021 }, { 136, 10,  805 }, {   4, 11,  196 },
  {   5, 10,  167 }, {   5, 11,  558 }, {   5, 10,  899 }, {   5, 11,  949 },
  {   6, 10,  410 }, { 137, 10,  777 }, { 137, 10,  789 }, { 134, 10, 1705 },
  {   8,  0,  904 }, { 140,  0,  787 }, {   6,  0,  322 }, {   9,  0,  552 },
  {  11,  0,  274 }, {  13,  0,  209 }, {  13,  0,  499 }, {  14,  0,   85 },
  {  15,  0,  126 }, { 145,  0,   70 }, { 135, 10,   10 }, {   5, 10,   11 },
  {   6, 10,  117 }, {   6, 10,  485 }, {   7, 10, 1133 }, {   9, 10,  582 },
  {   9, 10,  594 }, {  11, 10,   21 }, {  11, 10,  818 }, {  12, 10,  535 },
  { 141, 10,   86 }, {   4, 10,  264 }, {   7, 10, 1067 }, {   8, 10,  204 },
  {   8, 10,  385 }, { 139, 10,  953 }, { 132, 11,  752 }, { 138, 10,   56 },
  { 133, 10,  470 }, {   6,  0, 1808 }, {   8,  0,   83 }, {   8,  0,  742 },
  {   8,  0,  817 }, {   9,  0,   28 }, {   9,  0,   29 }, {   9,  0,  885 },
  {  10,  0,  387 }, {  11,  0,  633 }, {  11,  0,  740 }, {  13,  0,  235 },
  {  13,  0,  254 }, {  15,  0,  143 }, { 143,  0,  146 }, { 140,  0,   49 },
  { 134,  0, 1832 }, {   4, 11,  227 }, {   5, 11,  159 }, {   5, 11,  409 },
  {   7, 11,   80 }, {  10, 11,  294 }, {  10, 11,  479 }, {  12, 11,  418 },
  {  14, 11,   50 }, {  14, 11,  249 }, { 142, 11,  295 }, {   7, 11, 1470 },
  {   8, 11,   66 }, {   8, 11,  137 }, {   8, 11,  761 }, {   9, 11,  638 },
  {  11, 11,   80 }, {  11, 11,  212 }, {  11, 11,  368 }, {  11, 11,  418 },
  {  12, 11,    8 }, {  13, 11,   15 }, {  16, 11,   61 }, {  17, 11,   59 },
  {  19, 11,   28 }, { 148, 11,   84 }, { 139, 10, 1015 }, { 138, 11,  468 },
  { 135,  0,  421 }, {   6,  0,  415 }, {   7,  0, 1049 }, { 137,  0,  442 },
  {   6, 11,   38 }, {   7, 11, 1220 }, {   8, 11,  185 }, {   8, 11,  256 },
  {   9, 11,   22 }, {   9, 11,  331 }, {  10, 11,  738 }, {  11, 11,  205 },
  {  11, 11,  540 }, {  11, 11,  746 }, {  13, 11,  399 }, {  13, 11,  465 },
  {  14, 11,   88 }, { 142, 11,  194 }, { 139,  0,  289 }, { 133, 10,  715 },
  {   4,  0,  110 }, {  10,  0,  415 }, {  10,  0,  597 }, { 142,  0,  206 },
  {   4, 11,  159 }, {   6, 11,  115 }, {   7, 11,  252 }, {   7, 11,  257 },
  {   7, 11, 1928 }, {   8, 11,   69 }, {   9, 11,  384 }, {  10, 11,   91 },
  {  10, 11,  615 }, {  12, 11,  375 }, {  14, 11,  235 }, {  18, 11,  117 },
  { 147, 11,  123 }, {   5, 11,  911 }, { 136, 11,  278 }, {   7,  0,  205 },
  {   7,  0, 2000 }, {   8, 10,  794 }, {   9, 10,  400 }, {  10, 10,  298 },
  { 142, 10,  228 }, { 135, 11, 1774 }, {   4, 11,  151 }, {   7, 11, 1567 },
  {   8, 11,  351 }, { 137, 11,  322 }, { 136, 10,  724 }, { 133, 11,  990 },
  {   7,  0, 1539 }, {  11,  0,  512 }, {  13,  0,  205 }, {  19,  0,   30 },
  {  22,  0,   36 }, {  23,  0,   19 }, { 135, 11, 1539 }, {   5, 11,  194 },
  {   7, 11, 1662 }, {   9, 11,   90 }, { 140, 11,  180 }, {   6, 10,  190 },
  {   7, 10,  768 }, { 135, 10, 1170 }, { 134,  0, 1340 }, {   4,  0,  283 },
  { 135,  0, 1194 }, { 133, 11,  425 }, { 133, 11,  971 }, {  12,  0,  549 },
  {  14, 10,   67 }, { 147, 10,   60 }, { 135, 10, 1023 }, { 134,  0, 1720 },
  { 138, 11,  587 }, {   5, 11,   72 }, {   6, 11,  264 }, {   7, 11,   21 },
  {   7, 11,   46 }, {   7, 11, 2013 }, {   8, 11,  215 }, {   8, 11,  513 },
  {  10, 11,  266 }, { 139, 11,   22 }, {   5,  0,  319 }, { 135,  0,  534 },
  {   6, 10,  137 }, {   9, 10,   75 }, {   9, 10,  253 }, {  10, 10,  194 },
  { 138, 10,  444 }, {   7,  0, 1180 }, {  20,  0,  112 }, {   6, 11,  239 },
  {   7, 11,  118 }, {  10, 11,   95 }, {  11, 11,  603 }, {  13, 11,  443 },
  {  14, 11,  160 }, { 143, 11,    4 }, { 134, 11,  431 }, {   5, 11,  874 },
  {   6, 11, 1677 }, {  11, 10,  643 }, {  12, 10,  115 }, { 143, 11,    0 },
  { 134,  0,  967 }, {   6, 11,   65 }, {   7, 11,  939 }, {   7, 11, 1172 },
  {   7, 11, 1671 }, {   9, 11,  540 }, {  10, 11,  696 }, {  11, 11,  265 },
  {  11, 11,  732 }, {  11, 11,  928 }, {  11, 11,  937 }, {  12, 11,  399 },
  {  13, 11,  438 }, { 149, 11,   19 }, { 137, 11,  200 }, { 135,  0, 1940 },
  {   5, 10,  760 }, {   7, 10,  542 }, {   8, 10,  135 }, { 136, 10,  496 },
  { 140, 11,   44 }, {   7, 11, 1655 }, { 136, 11,  305 }, {   7, 10,  319 },
  {   7, 10,  355 }, {   7, 10,  763 }, {  10, 10,  389 }, { 145, 10,   43 },
  { 136,  0,  735 }, { 138, 10,  786 }, { 137, 11,   19 }, { 132, 11,  696 },
  {   5,  0,  132 }, {   9,  0,  486 }, {   9,  0,  715 }, {  10,  0,  458 },
  {  11,  0,  373 }, {  11,  0,  668 }, {  11,  0,  795 }, {  11,  0,  897 },
  {  12,  0,  272 }, {  12,  0,  424 }, {  12,  0,  539 }, {  12,  0,  558 },
  {  14,  0,  245 }, {  14,  0,  263 }, {  14,  0,  264 }, {  14,  0,  393 },
  { 142,  0,  403 }, {  10,  0,   38 }, { 139,  0,  784 }, { 132,  0,  838 },
  {   4, 11,  302 }, { 135, 11, 1766 }, { 133,  0,  379 }, {   5,  0,    8 },
  {   6,  0,   89 }, {   6,  0,  400 }, {   7,  0, 1569 }, {   7,  0, 1623 },
  {   7,  0, 1850 }, {   8,  0,  218 }, {   8,  0,  422 }, {   9,  0,  570 },
  {  10,  0,  626 }, {   4, 11,  726 }, { 133, 11,  630 }, {   4,  0, 1017 },
  { 138,  0,  660 }, {   6,  0,  387 }, {   7,  0,  882 }, { 141,  0,  111 },
  {   6,  0,  224 }, {   7,  0,  877 }, { 137,  0,  647 }, {   4, 10,   58 },
  {   5, 10,  286 }, {   6, 10,  319 }, {   7, 10,  402 }, {   7, 10, 1254 },
  {   7, 10, 1903 }, {   8, 10,  356 }, { 140, 10,  408 }, { 135,  0,  790 },
  {   9,  0,  510 }, {  10,  0,   53 }, {   4, 10,  389 }, {   9, 10,  181 },
  {  10, 10,   29 }, {  10, 10,  816 }, {  11, 10,  311 }, {  11, 10,  561 },
  {  12, 10,   67 }, { 141, 10,  181 }, { 142,  0,  458 }, {   6, 11,  118 },
  {   7, 11,  215 }, {   7, 11, 1521 }, { 140, 11,   11 }, { 134,  0,  954 },
  { 135,  0,  394 }, { 134,  0, 1367 }, {   5, 11,  225 }, { 133, 10,  373 },
  { 132,  0,  882 }, {   7,  0, 1409 }, { 135, 10, 1972 }, { 135, 10, 1793 },
  {   4, 11,  370 }, {   5, 11,  756 }, { 135, 11, 1326 }, { 150, 11,   13 },
  {   7, 11,  354 }, {  10, 11,  410 }, { 139, 11,  815 }, {   6, 11, 1662 },
  {   7, 11,   48 }, {   8, 11,  771 }, {  10, 11,  116 }, {  13, 11,  104 },
  {  14, 11,  105 }, {  14, 11,  184 }, {  15, 11,  168 }, {  19, 11,   92 },
  { 148, 11,   68 }, {   7,  0,  124 }, { 136,  0,   38 }, {   5,  0,  261 },
  {   7,  0,   78 }, {   7,  0,  199 }, {   8,  0,  815 }, {   9,  0,  126 },
  {  10,  0,  342 }, { 140,  0,  647 }, {   4,  0,  628 }, { 140,  0,  724 },
  {   7,  0,  266 }, {   8,  0,  804 }, {   7, 10, 1651 }, { 145, 10,   89 },
  { 135,  0,  208 }, { 134,  0, 1178 }, {   6,  0,   79 }, { 135,  0, 1519 },
  { 132, 10,  672 }, { 133, 10,  737 }, { 136,  0,  741 }, { 132, 11,  120 },
  {   4,  0,  710 }, {   6,  0,  376 }, { 134,  0,  606 }, { 134,  0, 1347 },
  { 134,  0, 1494 }, {   6,  0,  850 }, {   6,  0, 1553 }, { 137,  0,  821 },
  {   5, 10,  145 }, { 134, 11,  593 }, {   7,  0, 1311 }, { 140,  0,  135 },
  {   4,  0,  467 }, {   5,  0,  405 }, { 134,  0,  544 }, {   5, 11,  820 },
  { 135, 11,  931 }, {   6,  0,  100 }, {   7,  0,  244 }, {   7,  0,  632 },
  {   7,  0, 1609 }, {   8,  0,  178 }, {   8,  0,  638 }, { 141,  0,   58 },
  {   4, 10,  387 }, { 135, 10, 1288 }, {   6, 11,  151 }, {   6, 11, 1675 },
  {   7, 11,  383 }, { 151, 11,   10 }, { 132,  0,  481 }, { 135, 10,  550 },
  { 134,  0, 1378 }, {   6, 11, 1624 }, {  11, 11,   11 }, {  12, 11,  422 },
  {  13, 11,  262 }, { 142, 11,  360 }, { 133,  0,  791 }, {   4, 11,   43 },
  {   5, 11,  344 }, { 133, 11,  357 }, {   7,  0, 1227 }, { 140,  0,  978 },
  {   7,  0,  686 }, {   8,  0,   33 }, {   8,  0,  238 }, {  10,  0,  616 },
  {  11,  0,  467 }, {  11,  0,  881 }, {  13,  0,  217 }, {  13,  0,  253 },
  { 142,  0,  268 }, { 137,  0,  857 }, {   8,  0,  467 }, {   8,  0, 1006 },
  {   7, 11,  148 }, {   8, 11,  284 }, { 141, 11,   63 }, {   4, 10,  576 },
  { 135, 10, 1263 }, { 133, 11,  888 }, {   5, 10,  919 }, { 134, 10, 1673 },
  {  20, 10,   37 }, { 148, 11,   37 }, { 132,  0,  447 }, { 132, 11,  711 },
  {   4,  0,  128 }, {   5,  0,  415 }, {   6,  0,  462 }, {   7,  0,  294 },
  {   7,  0,  578 }, {  10,  0,  710 }, { 139,  0,   86 }, {   4, 10,   82 },
  {   5, 10,  333 }, {   5, 10,  904 }, {   6, 10,  207 }, {   7, 10,  325 },
  {   7, 10, 1726 }, {   8, 10,  101 }, {  10, 10,  778 }, { 139, 10,  220 },
  { 136,  0,  587 }, { 137, 11,  440 }, { 133, 10,  903 }, {   6,  0,  427 },
  {   7,  0, 1018 }, { 138,  0,  692 }, {   4,  0,  195 }, { 135,  0,  802 },
  { 140, 10,  147 }, { 134,  0, 1546 }, { 134,  0,  684 }, { 132, 10,  705 },
  { 136,  0,  345 }, {  11, 11,  678 }, { 140, 11,  307 }, { 133,  0,  365 },
  { 134,  0, 1683 }, {   4, 11,   65 }, {   5, 11,  479 }, {   5, 11, 1004 },
  {   7, 11, 1913 }, {   8, 11,  317 }, {   9, 11,  302 }, {  10, 11,  612 },
  { 141, 11,   22 }, { 138,  0,  472 }, {   4, 11,  261 }, { 135, 11,  510 },
  { 134, 10,   90 }, { 142,  0,  433 }, { 151,  0,   28 }, {   4, 11,  291 },
  {   7, 11,  101 }, {   9, 11,  515 }, {  12, 11,  152 }, {  12, 11,  443 },
  {  13, 11,  392 }, { 142, 11,  357 }, { 140,  0,  997 }, {   5,  0,    3 },
  {   8,  0,  578 }, {   9,  0,  118 }, {  10,  0,  705 }, { 141,  0,  279 },
  { 135, 11, 1266 }, {   7, 10,  813 }, {  12, 10,  497 }, { 141, 10,   56 },
  { 133,  0,  229 }, {   6, 10,  125 }, { 135, 10, 1277 }, {   8,  0,  102 },
  {  10,  0,  578 }, {  10,  0,  672 }, {  12,  0,  496 }, {  13,  0,  408 },
  {  14,  0,  121 }, {  17,  0,  106 }, { 151, 10,   12 }, {   6,  0,  866 },
  { 134,  0, 1080 }, { 136,  0, 1022 }, {   4, 11,  130 }, { 135, 11,  843 },
  {   5, 11,   42 }, {   5, 11,  879 }, {   7, 11,  245 }, {   7, 11,  324 },
  {   7, 11, 1532 }, {  11, 11,  463 }, {  11, 11,  472 }, {  13, 11,  363 },
  { 144, 11,   52 }, { 150,  0,   55 }, {   8,  0,  115 }, {   8,  0,  350 },
  {   9,  0,  489 }, {  10,  0,  128 }, {  11,  0,  306 }, {  12,  0,  373 },
  {  14,  0,   30 }, {  17,  0,   79 }, {  19,  0,   80 }, {   4, 11,  134 },
  { 133, 11,  372 }, { 134,  0,  657 }, { 134,  0,  933 }, { 135, 11, 1147 },
  {   4,  0,  230 }, { 133,  0,  702 }, { 134,  0, 1728 }, {   4,  0,  484 },
  {  18,  0,   26 }, {  19,  0,   42 }, {  20,  0,   43 }, {  21,  0,    0 },
  {  23,  0,   27 }, { 152,  0,   14 }, {   7,  0,  185 }, { 135,  0,  703 },
  {   6,  0,  417 }, {  10,  0,  618 }, {   7, 10, 1106 }, {   9, 10,  770 },
  {  11, 10,  112 }, { 140, 10,  413 }, { 134,  0,  803 }, { 132, 11,  644 },
  { 134,  0, 1262 }, {   7, 11,  540 }, {  12, 10,  271 }, { 145, 10,  109 },
  { 135, 11,  123 }, { 132,  0,  633 }, { 134, 11,  623 }, {   4, 11,  908 },
  {   5, 11,  359 }, {   5, 11,  508 }, {   6, 11, 1723 }, {   7, 11,  343 },
  {   7, 11, 1996 }, { 135, 11, 2026 }, { 135,  0,  479 }, {  10,  0,  262 },
  {   7, 10,  304 }, {   9, 10,  646 }, {   9, 10,  862 }, {  11, 10,  696 },
  {  12, 10,  208 }, {  15, 10,   79 }, { 147, 10,  108 }, {   4, 11,  341 },
  { 135, 11,  480 }, { 134,  0,  830 }, {   5,  0,   70 }, {   5,  0,  622 },
  {   6,  0,  334 }, {   7,  0, 1032 }, {   9,  0,  171 }, {  11,  0,   26 },
  {  11,  0,  213 }, {  11,  0,  637 }, {  11,  0,  707 }, {  12,  0,  202 },
  {  12,  0,  380 }, {  13,  0,  226 }, {  13,  0,  355 }, {  14,  0,  222 },
  { 145,  0,   42 }, { 135, 10,  981 }, { 143,  0,  217 }, { 137, 11,  114 },
  {   4,  0,   23 }, {   4,  0,  141 }, {   5,  0,  313 }, {   5,  0, 1014 },
  {   6,  0,   50 }, {   6,  0,   51 }, {   7,  0,  142 }, {   7,  0,  384 },
  {   7,  0,  559 }, {   8,  0,  640 }, {   9,  0,  460 }, {   9,  0,  783 },
  {  11,  0,  741 }, {  12,  0,  183 }, { 141,  0,  488 }, { 141,  0,  360 },
  {   7,  0, 1586 }, {   7, 11, 1995 }, {   8, 11,  299 }, {  11, 11,  890 },
  { 140, 11,  674 }, { 132, 10,  434 }, {   7,  0,  652 }, { 134, 10,  550 },
  {   7,  0,  766 }, {   5, 10,  553 }, { 138, 10,  824 }, {   7,  0,  737 },
  {   8,  0,  298 }, { 136, 10,  452 }, {   4, 11,  238 }, {   5, 11,  503 },
  {   6, 11,  179 }, {   7, 11, 2003 }, {   8, 11,  381 }, {   8, 11,  473 },
  {   9, 11,  149 }, {  10, 11,  183 }, {  15, 11,   45 }, { 143, 11,   86 },
  { 133, 10,  292 }, {   5,  0,  222 }, {   9,  0,  655 }, { 138,  0,  534 },
  { 138, 10,  135 }, {   4, 11,  121 }, {   5, 11,  156 }, {   5, 11,  349 },
  {   9, 11,  136 }, {  10, 11,  605 }, {  14, 11,  342 }, { 147, 11,  107 },
  { 137,  0,  906 }, {   6,  0, 1013 }, { 134,  0, 1250 }, {   6,  0, 1956 },
  {   6,  0, 2009 }, {   8,  0,  991 }, { 144,  0,  120 }, { 135, 11, 1192 },
  { 138,  0,  503 }, {   5,  0,  154 }, {   7,  0, 1491 }, {  10,  0,  379 },
  { 138,  0,  485 }, {   6,  0, 1867 }, {   6,  0, 1914 }, {   6,  0, 1925 },
  {   9,  0,  917 }, {   9,  0,  925 }, {   9,  0,  932 }, {   9,  0,  951 },
  {   9,  0, 1007 }, {   9,  0, 1013 }, {  12,  0,  806 }, {  12,  0,  810 },
  {  12,  0,  814 }, {  12,  0,  816 }, {  12,  0,  824 }, {  12,  0,  832 },
  {  12,  0,  837 }, {  12,  0,  863 }, {  12,  0,  868 }, {  12,  0,  870 },
  {  12,  0,  889 }, {  12,  0,  892 }, {  12,  0,  900 }, {  12,  0,  902 },
  {  12,  0,  908 }, {  12,  0,  933 }, {  12,  0,  942 }, {  12,  0,  949 },
  {  12,  0,  954 }, {  15,  0,  175 }, {  15,  0,  203 }, {  15,  0,  213 },
  {  15,  0,  218 }, {  15,  0,  225 }, {  15,  0,  231 }, {  15,  0,  239 },
  {  15,  0,  248 }, {  15,  0,  252 }, {  18,  0,  190 }, {  18,  0,  204 },
  {  18,  0,  215 }, {  18,  0,  216 }, {  18,  0,  222 }, {  18,  0,  225 },
  {  18,  0,  230 }, {  18,  0,  239 }, {  18,  0,  241 }, {  21,  0,   42 },
  {  21,  0,   43 }, {  21,  0,   44 }, {  21,  0,   45 }, {  21,  0,   46 },
  {  21,  0,   53 }, {  24,  0,   27 }, { 152,  0,   31 }, { 133,  0,  716 },
  { 135,  0,  844 }, {   4,  0,   91 }, {   5,  0,  388 }, {   5,  0,  845 },
  {   6,  0,  206 }, {   6,  0,  252 }, {   6,  0,  365 }, {   7,  0,  136 },
  {   7,  0,  531 }, { 136,  0,  621 }, {   7, 10,  393 }, {  10, 10,  603 },
  { 139, 10,  206 }, {   6, 11,   80 }, {   6, 11, 1694 }, {   7, 11,  173 },
  {   7, 11, 1974 }, {   9, 11,  547 }, {  10, 11,  730 }, {  14, 11,   18 },
  { 150, 11,   39 }, { 137,  0,  748 }, {   4, 11,  923 }, { 134, 11, 1711 },
  {   4, 10,  912 }, { 137, 10,  232 }, {   7, 10,   98 }, {   7, 10, 1973 },
  { 136, 10,  716 }, {  14,  0,  103 }, { 133, 10,  733 }, { 132, 11,  595 },
  {  12,  0,  158 }, {  18,  0,    8 }, {  19,  0,   62 }, {  20,  0,    6 },
  {  22,  0,    4 }, {  23,  0,    2 }, {  23,  0,    9 }, {   5, 11,  240 },
  {   6, 11,  459 }, {   7, 11,   12 }, {   7, 11,  114 }, {   7, 11,  502 },
  {   7, 11, 1751 }, {   7, 11, 1753 }, {   7, 11, 1805 }, {   8, 11,  658 },
  {   9, 11,    1 }, {  11, 11,  959 }, {  13, 11,  446 }, { 142, 11,  211 },
  { 135,  0,  576 }, {   5,  0,  771 }, {   5,  0,  863 }, {   5,  0,  898 },
  {   6,  0,  648 }, {   6,  0, 1632 }, {   6,  0, 1644 }, { 134,  0, 1780 },
  { 133,  0,  331 }, {   7, 11,  633 }, {   7, 11,  905 }, {   7, 11,  909 },
  {   7, 11, 1538 }, {   9, 11,  767 }, { 140, 11,  636 }, { 140,  0,  632 },
  {   5,  0,  107 }, {   7,  0,  201 }, { 136,  0,  518 }, {   6,  0,  446 },
  {   7,  0, 1817 }, { 134, 11,  490 }, {   9,  0,  851 }, { 141,  0,  510 },
  {   7, 11,  250 }, {   8, 11,  506 }, { 136, 11,  507 }, {   4,  0,  504 },
  { 137, 10,   72 }, { 132, 11,  158 }, {   4, 11,  140 }, {   7, 11,  362 },
  {   8, 11,  209 }, {   9, 11,   10 }, {   9, 11,  160 }, {   9, 11,  503 },
  {  10, 11,  689 }, {  11, 11,  350 }, {  11, 11,  553 }, {  11, 11,  725 },
  {  12, 11,  252 }, {  12, 11,  583 }, {  13, 11,  192 }, {  13, 11,  352 },
  {  14, 11,  269 }, {  14, 11,  356 }, { 148, 11,   50 }, {   6, 11,  597 },
  { 135, 11, 1318 }, { 135, 10, 1454 }, {   5,  0,  883 }, {   5,  0,  975 },
  {   8,  0,  392 }, { 148,  0,    7 }, {   6, 11,  228 }, {   7, 11, 1341 },
  {   9, 11,  408 }, { 138, 11,  343 }, {  11, 11,  348 }, {  11, 10,  600 },
  {  12, 11,   99 }, {  13, 10,  245 }, {  18, 11,    1 }, {  18, 11,   11 },
  { 147, 11,    4 }, { 134, 11,  296 }, {   5,  0,  922 }, { 134,  0, 1707 },
  { 132, 11,  557 }, {   4, 11,  548 }, {   7, 10,  164 }, {   7, 10, 1571 },
  {   9, 10,  107 }, { 140, 10,  225 }, {   7, 11,  197 }, {   8, 11,  142 },
  {   8, 11,  325 }, {   9, 11,  150 }, {   9, 11,  596 }, {  10, 11,  350 },
  {  10, 11,  353 }, {  11, 11,   74 }, {  11, 11,  315 }, {  14, 11,  423 },
  { 143, 11,  141 }, {   5,  0,  993 }, {   7,  0,  515 }, { 137,  0,   91 },
  {   4,  0,  131 }, {   8,  0,  200 }, {   5, 10,  484 }, {   5, 10,  510 },
  {   6, 10,  434 }, {   7, 10, 1000 }, {   7, 10, 1098 }, { 136, 10,    2 },
  { 152,  0,   10 }, {   4, 11,   62 }, {   5, 11,   83 }, {   6, 11,  399 },
  {   6, 11,  579 }, {   7, 11,  692 }, {   7, 11,  846 }, {   7, 11, 1015 },
  {   7, 11, 1799 }, {   8, 11,  403 }, {   9, 11,  394 }, {  10, 11,  133 },
  {  12, 11,    4 }, {  12, 11,  297 }, {  12, 11,  452 }, {  16, 11,   81 },
  {  18, 11,   19 }, {  18, 11,   25 }, {  21, 11,   14 }, {  22, 11,   12 },
  { 151, 11,   18 }, { 140, 11,  459 }, { 132, 11,  177 }, {   7,  0, 1433 },
  {   9,  0,  365 }, { 137, 11,  365 }, { 132, 10,  460 }, {   5,  0,  103 },
  {   6,  0, 2004 }, {   7,  0,  921 }, {   8,  0,  580 }, {   8,  0,  593 },
  {   8,  0,  630 }, {  10,  0,   28 }, {   5, 11,  411 }, { 135, 11,  653 },
  {   4, 10,  932 }, { 133, 10,  891 }, {   4,  0,  911 }, {   5,  0,  867 },
  {   5,  0, 1013 }, {   7,  0, 2034 }, {   8,  0,  798 }, { 136,  0,  813 },
  {   7, 11,  439 }, {  10, 11,  727 }, {  11, 11,  260 }, { 139, 11,  684 },
  { 136, 10,  625 }, {   5, 11,  208 }, {   7, 11,  753 }, { 135, 11, 1528 },
  {   5,  0,  461 }, {   7,  0, 1925 }, {  12,  0,   39 }, {  13,  0,  265 },
  {  13,  0,  439 }, { 134, 10,   76 }, {   6,  0,  853 }, {   8, 10,   92 },
  { 137, 10,  221 }, {   5,  0,  135 }, {   6,  0,  519 }, {   7,  0, 1722 },
  {  10,  0,  271 }, {  11,  0,  261 }, { 145,  0,   54 }, { 139, 11,  814 },
  {  14,  0,  338 }, { 148,  0,   81 }, {   4,  0,  300 }, { 133,  0,  436 },
  {   5,  0,  419 }, {   5,  0,  687 }, {   7,  0,  864 }, {   9,  0,  470 },
  { 135, 11,  864 }, {   9,  0,  836 }, { 133, 11,  242 }, { 134,  0, 1937 },
  {   4, 10,  763 }, { 133, 11,  953 }, { 132, 10,  622 }, { 132,  0,  393 },
  { 133, 10,  253 }, {   8,  0,  357 }, {  10,  0,  745 }, {  14,  0,  426 },
  {  17,  0,   94 }, {  19,  0,   57 }, { 135, 10,  546 }, {   5, 11,  615 },
  { 146, 11,   37 }, {   9, 10,   73 }, {  10, 10,  110 }, {  14, 10,  185 },
  { 145, 10,  119 }, {  11,  0,  703 }, {   7, 10,  624 }, {   7, 10,  916 },
  {  10, 10,  256 }, { 139, 10,   87 }, { 133, 11,  290 }, {   5, 10,  212 },
  {  12, 10,   35 }, { 141, 10,  382 }, { 132, 11,  380 }, {   5, 11,   52 },
  {   7, 11,  277 }, {   9, 11,  368 }, { 139, 11,  791 }, { 133,  0,  387 },
  {  10, 11,  138 }, { 139, 11,  476 }, {   4,  0,    6 }, {   5,  0,  708 },
  { 136,  0,   75 }, {   7,  0, 1351 }, {   9,  0,  581 }, {  10,  0,  639 },
  {  11,  0,  453 }, { 140,  0,  584 }, { 132,  0,  303 }, { 138,  0,  772 },
  { 135, 10, 1175 }, {   4,  0,  749 }, {   5, 10,  816 }, {   6, 11,  256 },
  {   7, 11,  307 }, {   7, 11,  999 }, {   7, 11, 1481 }, {   7, 11, 1732 },
  {   7, 11, 1738 }, {   8, 11,  265 }, {   9, 11,  414 }, {  11, 11,  316 },
  {  12, 11,   52 }, {  13, 11,  420 }, { 147, 11,  100 }, { 135, 11, 1296 },
  {   6,  0, 1065 }, {   5, 10,  869 }, {   5, 10,  968 }, {   6, 10, 1626 },
  {   8, 10,  734 }, { 136, 10,  784 }, {   4, 10,  542 }, {   6, 10, 1716 },
  {   6, 10, 1727 }, {   7, 10, 1082 }, {   7, 10, 1545 }, {   8, 10,   56 },
  {   8, 10,  118 }, {   8, 10,  412 }, {   8, 10,  564 }, {   9, 10,  888 },
  {   9, 10,  908 }, {  10, 10,   50 }, {  10, 10,  423 }, {  11, 10,  685 },
  {  11, 10,  697 }, {  11, 10,  933 }, {  12, 10,  299 }, {  13, 10,  126 },
  {  13, 10,  136 }, {  13, 10,  170 }, { 141, 10,  190 }, { 134,  0,  226 },
  {   4,  0,  106 }, {   7,  0,  310 }, {  11,  0,  717 }, { 133, 11,  723 },
  {   5,  0,  890 }, {   5,  0,  988 }, {   4, 10,  232 }, {   9, 10,  202 },
  {  10, 10,  474 }, { 140, 10,  433 }, {   6,  0,  626 }, { 142,  0,  431 },
  {  10,  0,  706 }, { 150,  0,   44 }, {  13,  0,   51 }, {   6, 10,  108 },
  {   7, 10, 1003 }, {   7, 10, 1181 }, {   8, 10,  111 }, { 136, 10,  343 },
  { 132,  0,  698 }, {   5, 11,  109 }, {   6, 11, 1784 }, {   7, 11, 1895 },
  {  12, 11,  296 }, { 140, 11,  302 }, { 134,  0,  828 }, { 134, 10, 1712 },
  { 138,  0,   17 }, {   7,  0, 1929 }, {   4, 10,  133 }, {   5, 11,  216 },
  {   7, 10,  711 }, {   7, 10, 1298 }, {   7, 10, 1585 }, {   7, 11, 1879 },
  {   9, 11,  141 }, {   9, 11,  270 }, {   9, 11,  679 }, {  10, 11,  159 },
  {  10, 11,  553 }, {  11, 11,  197 }, {  11, 11,  438 }, {  12, 11,  538 },
  {  12, 11,  559 }, {  13, 11,  193 }, {  13, 11,  423 }, {  14, 11,  144 },
  {  14, 11,  166 }, {  14, 11,  167 }, {  15, 11,   67 }, { 147, 11,   84 },
  { 141, 11,  127 }, {   7, 11, 1872 }, { 137, 11,   81 }, {   6, 10,   99 },
  {   7, 10, 1808 }, { 145, 10,   57 }, { 134, 11,  391 }, {   5,  0,  689 },
  {   6,  0,   84 }, {   7,  0, 1250 }, {   6, 10,  574 }, {   7, 10,  428 },
  {  10, 10,  669 }, {  11, 10,  485 }, {  11, 10,  840 }, {  12, 10,  300 },
  { 142, 10,  250 }, {   7, 11,  322 }, { 136, 11,  249 }, {   7, 11,  432 },
  { 135, 11, 1649 }, { 135, 10, 1871 }, { 137, 10,  252 }, {   6, 11,  155 },
  { 140, 11,  234 }, {   7,  0,  871 }, {  19,  0,   27 }, { 147, 11,   27 },
  { 140,  0,  498 }, {   5,  0,  986 }, {   6,  0,  130 }, { 138,  0,  823 },
  {   6,  0, 1793 }, {   7,  0, 1582 }, {   8,  0,  458 }, {  10,  0,  101 },
  {  10,  0,  318 }, {  10,  0,  945 }, {  12,  0,  734 }, {  16,  0,  104 },
  {  18,  0,  177 }, {   6, 10,  323 }, { 135, 10, 1564 }, {   5, 11,  632 },
  { 138, 11,  526 }, {  10,  0,  435 }, {   7, 10,  461 }, { 136, 10,  775 },
  {   6, 11,  144 }, {   7, 11,  948 }, {   7, 11, 1042 }, {   7, 11, 1857 },
  {   8, 11,  235 }, {   8, 11,  461 }, {   9, 11,  453 }, {   9, 11,  530 },
  {  10, 11,  354 }, {  17, 11,   77 }, {  19, 11,   99 }, { 148, 11,   79 },
  { 138,  0,  966 }, {   7,  0, 1644 }, { 137,  0,  129 }, { 135,  0,  997 },
  { 136,  0,  502 }, {   5, 11,  196 }, {   6, 11,  486 }, {   7, 11,  212 },
  {   8, 11,  309 }, { 136, 11,  346 }, {   7, 10,  727 }, { 146, 10,   73 },
  { 132,  0,  823 }, { 132, 11,  686 }, { 135,  0, 1927 }, {   4,  0,  762 },
  {   7,  0, 1756 }, { 137,  0,   98 }, { 136, 10,  577 }, {  24,  0,    8 },
  {   4, 11,   30 }, {   5, 11,   43 }, { 152, 11,    8 }, {   7,  0, 1046 },
  { 139,  0,  160 }, {   7,  0,  492 }, {   4, 10,  413 }, {   5, 10,  677 },
  {   7, 11,  492 }, {   8, 10,  432 }, { 140, 10,  280 }, {   6,  0,   45 },
  {   7,  0,  433 }, {   8,  0,  129 }, {   9,  0,   21 }, {  10,  0,  392 },
  {  11,  0,   79 }, {  12,  0,  499 }, {  13,  0,  199 }, { 141,  0,  451 },
  {   7,  0,  558 }, { 136,  0,  353 }, {   4, 11,  220 }, {   7, 11, 1535 },
  {   9, 11,   93 }, { 139, 11,  474 }, {   7, 10,  646 }, {   7, 10, 1730 },
  {  11, 10,  446 }, { 141, 10,  178 }, { 133,  0,  785 }, { 134,  0, 1145 },
  {   8,  0,   81 }, {   9,  0,  189 }, {   9,  0,  201 }, {  11,  0,  478 },
  {  11,  0,  712 }, { 141,  0,  338 }, {   5,  0,  353 }, { 151,  0,   26 },
  {  11,  0,  762 }, { 132, 10,  395 }, { 134,  0, 2024 }, {   4,  0,  611 },
  { 133,  0,  606 }, {   9, 10,  174 }, {  10, 10,  164 }, {  11, 10,  440 },
  {  11, 10,  841 }, { 143, 10,   98 }, { 134, 10,  426 }, {  10, 10,  608 },
  { 139, 10, 1002 }, { 138, 10,  250 }, {   6,  0,   25 }, {   7,  0,  855 },
  {   7,  0, 1258 }, { 144,  0,   32 }, {   7, 11, 1725 }, { 138, 11,  393 },
  {   5, 11,  263 }, { 134, 11,  414 }, {   6,  0, 2011 }, { 133, 10,  476 },
  {   4,  0,    4 }, {   7,  0, 1118 }, {   7,  0, 1320 }, {   7,  0, 1706 },
  {   8,  0,  277 }, {   9,  0,  622 }, {  10,  0,    9 }, {  11,  0,  724 },
  {  12,  0,  350 }, {  12,  0,  397 }, {  13,  0,   28 }, {  13,  0,  159 },
  {  15,  0,   89 }, {  18,  0,    5 }, {  19,  0,    9 }, {  20,  0,   34 },
  {  22,  0,   47 }, {   6, 11,  178 }, {   6, 11, 1750 }, {   8, 11,  251 },
  {   9, 11,  690 }, {  10, 11,  155 }, {  10, 11,  196 }, {  10, 11,  373 },
  {  11, 11,  698 }, {  13, 11,  155 }, { 148, 11,   93 }, {   5, 11,   97 },
  { 137, 11,  393 }, {   7,  0,  764 }, {  11,  0,  461 }, {  12,  0,  172 },
  {   5, 10,   76 }, {   6, 10,  458 }, {   6, 10,  497 }, {   7, 10,  868 },
  {   9, 10,  658 }, {  10, 10,  594 }, {  11, 10,  566 }, {  12, 10,  338 },
  { 141, 10,  200 }, { 134,  0, 1449 }, { 138, 11,   40 }, { 134, 11, 1639 },
  { 134,  0, 1445 }, {   6,  0, 1168 }, {   4, 10,  526 }, {   7, 10, 1029 },
  { 135, 10, 1054 }, {   4, 11,  191 }, {   7, 11,  934 }, {   8, 11,  647 },
  { 145, 11,   97 }, { 132, 10,  636 }, {   6,  0,  233 }, {   7, 10,  660 },
  {   7, 10, 1124 }, {  17, 10,   31 }, {  19, 10,   22 }, { 151, 10,   14 },
  {   6, 10, 1699 }, { 136, 11,  110 }, {  12, 11,  246 }, {  15, 11,  162 },
  {  19, 11,   64 }, {  20, 11,    8 }, {  20, 11,   95 }, {  22, 11,   24 },
  { 152, 11,   17 }, {   5, 11,  165 }, {   9, 11,  346 }, { 138, 11,  655 },
  {   5, 11,  319 }, { 135, 11,  534 }, { 134,  0,  255 }, {   9,  0,  216 },
  {   8, 11,  128 }, { 139, 11,  179 }, {   9,  0,  183 }, { 139,  0,  286 },
  {  11,  0,  956 }, { 151,  0,    3 }, {   4,  0,  536 }, {   7,  0, 1141 },
  {  10,  0,  723 }, { 139,  0,  371 }, {   4, 10,  279 }, {   7, 10,  301 },
  { 137, 10,  362 }, {   7,  0,  285 }, {   5, 11,   57 }, {   6, 11,  101 },
  {   6, 11, 1663 }, {   7, 11,  132 }, {   7, 11, 1048 }, {   7, 11, 1154 },
  {   7, 11, 1415 }, {   7, 11, 1507 }, {  12, 11,  493 }, {  15, 11,  105 },
  { 151, 11,   15 }, {   5, 11,  459 }, {   7, 11, 1073 }, {   7, 10, 1743 },
  {   8, 11,  241 }, { 136, 11,  334 }, {   4, 10,  178 }, { 133, 10,  399 },
  { 135,  0,  560 }, { 132,  0,  690 }, { 135,  0, 1246 }, {  18,  0,  157 },
  { 147,  0,   63 }, {  10,  0,  599 }, {  11,  0,   33 }, {  12,  0,  571 },
  { 149,  0,    1 }, {   6, 11,  324 }, {   6, 11,  520 }, {   7, 11,  338 },
  {   7, 11, 1616 }, {   7, 11, 1729 }, {   8, 11,  228 }, {   9, 11,   69 },
  { 139, 11,  750 }, {   7,  0, 1862 }, {  12,  0,  491 }, {  12,  0,  520 },
  {  13,  0,  383 }, { 142,  0,  244 }, { 135, 11,  734 }, { 134, 10, 1692 },
  {  10,  0,  448 }, {  11,  0,  630 }, {  17,  0,  117 }, {   6, 10,  202 },
  {   7, 11,  705 }, {  12, 10,  360 }, {  17, 10,  118 }, {  18, 10,   27 },
  { 148, 10,   67 }, {   4, 11,   73 }, {   6, 11,  612 }, {   7, 11,  927 },
  {   7, 11, 1822 }, {   8, 11,  217 }, {   9, 11,  472 }, {   9, 11,  765 },
  {   9, 11,  766 }, {  10, 11,  408 }, {  11, 11,   51 }, {  11, 11,  793 },
  {  12, 11,  266 }, {  15, 11,  158 }, {  20, 11,   89 }, { 150, 11,   32 },
  {   4,  0,  190 }, { 133,  0,  554 }, { 133,  0, 1001 }, {   5, 11,  389 },
  {   8, 11,  636 }, { 137, 11,  229 }, {   5,  0,  446 }, {   7, 10,  872 },
  {  10, 10,  516 }, { 139, 10,  167 }, { 137, 10,  313 }, { 132, 10,  224 },
  { 134,  0, 1313 }, {   5, 10,  546 }, {   7, 10,   35 }, {   8, 10,   11 },
  {   8, 10,   12 }, {   9, 10,  315 }, {   9, 10,  533 }, {  10, 10,  802 },
  {  11, 10,  166 }, {  12, 10,  525 }, { 142, 10,  243 }, {   6,  0,  636 },
  { 137,  0,  837 }, {   5, 10,  241 }, {   8, 10,  242 }, {   9, 10,  451 },
  {  10, 10,  667 }, {  11, 10,  598 }, { 140, 10,  429 }, {  22, 10,   46 },
  { 150, 11,   46 }, { 136, 11,  472 }, {  11,  0,  278 }, { 142,  0,   73 },
  { 141, 11,  185 }, { 132,  0,  868 }, { 134,  0,  972 }, {   4, 10,  366 },
  { 137, 10,  516 }, { 138,  0, 1010 }, {   5, 11,  189 }, {   6, 10, 1736 },
  {   7, 11,  442 }, {   7, 11,  443 }, {   8, 11,  281 }, {  12, 11,  174 },
  {  13, 11,   83 }, { 141, 11,  261 }, { 139, 11,  384 }, {   6, 11,    2 },
  {   7, 11,  191 }, {   7, 11,  446 }, {   7, 11,  758 }, {   7, 11, 1262 },
  {   7, 11, 1737 }, {   8, 11,   22 }, {   8, 11,  270 }, {   8, 11,  612 },
  {   9, 11,    4 }, {   9, 11,  167 }, {   9, 11,  312 }, {   9, 11,  436 },
  {  10, 11,  156 }, {  10, 11,  216 }, {  10, 11,  311 }, {  10, 11,  623 },
  {  11, 11,   72 }, {  11, 11,  330 }, {  11, 11,  455 }, {  12, 11,  101 },
  {  12, 11,  321 }, {  12, 11,  504 }, {  12, 11,  530 }, {  12, 11,  543 },
  {  13, 11,   17 }, {  13, 11,  156 }, {  13, 11,  334 }, {  14, 11,   48 },
  {  15, 11,   70 }, {  17, 11,   60 }, { 148, 11,   64 }, {   6, 10,  331 },
  { 136, 10,  623 }, { 135,  0, 1231 }, { 132,  0,  304 }, {   6, 11,   60 },
  {   7, 11,  670 }, {   7, 11, 1327 }, {   8, 11,  411 }, {   8, 11,  435 },
  {   9, 11,  653 }, {   9, 11,  740 }, {  10, 11,  385 }, {  11, 11,  222 },
  {  11, 11,  324 }, {  11, 11,  829 }, { 140, 11,  611 }, {   7,  0,  506 },
  {   6, 11,  166 }, {   7, 11,  374 }, { 135, 11, 1174 }, {  14, 11,   43 },
  { 146, 11,   21 }, { 135, 11, 1694 }, { 135, 10, 1888 }, {   5, 11,  206 },
  { 134, 11,  398 }, { 135, 11,   50 }, { 150,  0,   26 }, {   6,  0,   53 },
  {   6,  0,  199 }, {   7,  0, 1408 }, {   8,  0,   32 }, {   8,  0,   93 },
  {  10,  0,  397 }, {  10,  0,  629 }, {  11,  0,  593 }, {  11,  0,  763 },
  {  13,  0,  326 }, { 145,  0,   35 }, { 134,  0,  105 }, { 132, 10,  394 },
  {   4,  0,  843 }, { 138,  0,  794 }, {  11,  0,  704 }, { 141,  0,  396 },
  {   5,  0,  114 }, {   5,  0,  255 }, { 141,  0,  285 }, {   6,  0,  619 },
  {   7,  0,  898 }, {   7,  0, 1092 }, {   8,  0,  485 }, {  18,  0,   28 },
  {  19,  0,  116 }, { 135, 10, 1931 }, {   9,  0,  145 }, {   7, 10,  574 },
  { 135, 10, 1719 }, {   7,  0, 2035 }, {   8,  0,   19 }, {   9,  0,   89 },
  { 138,  0,  831 }, { 132, 10,  658 }, {   6, 11,  517 }, {   7, 11, 1159 },
  {  10, 11,  621 }, { 139, 11,  192 }, {   7,  0, 1933 }, {   7, 11, 1933 },
  {   9, 10,  781 }, {  10, 10,  144 }, {  11, 10,  385 }, {  13, 10,  161 },
  {  13, 10,  228 }, {  13, 10,  268 }, { 148, 10,  107 }, { 136, 10,  374 },
  {  10, 11,  223 }, { 139, 11,  645 }, { 135,  0, 1728 }, {   7, 11,   64 },
  {   7, 11,  289 }, { 136, 11,  245 }, {   4, 10,  344 }, {   6, 10,  498 },
  { 139, 10,  323 }, { 136,  0,  746 }, { 135, 10, 1063 }, { 137, 10,  155 },
  {   4,  0,  987 }, {   6,  0, 1964 }, {   6,  0, 1974 }, {   6,  0, 1990 },
  { 136,  0,  995 }, { 133, 11,  609 }, { 133, 10,  906 }, { 134,  0, 1550 },
  { 134,  0,  874 }, {   5, 11,  129 }, {   6, 11,   61 }, { 135, 11,  947 },
  {   4,  0, 1018 }, {   6,  0, 1938 }, {   6,  0, 2021 }, { 134,  0, 2039 },
  { 132,  0,  814 }, {  11,  0,  126 }, { 139,  0,  287 }, { 134,  0, 1264 },
  {   5,  0,  955 }, { 136,  0,  814 }, { 141, 11,  506 }, { 132, 11,  314 },
  {   6,  0,  981 }, { 139, 11, 1000 }, {   5,  0,   56 }, {   8,  0,  892 },
  {   8,  0,  915 }, { 140,  0,  776 }, { 148,  0,  100 }, {  10,  0,    4 },
  {  10,  0,   13 }, {  11,  0,  638 }, { 148,  0,   57 }, { 148, 11,   74 },
  {   5,  0,  738 }, { 132, 10,  616 }, { 133, 11,  637 }, { 136, 10,  692 },
  { 133,  0,  758 }, { 132, 10,  305 }, { 137, 11,  590 }, {   5, 11,  280 },
  { 135, 11, 1226 }, { 134, 11,  494 }, { 135,  0, 1112 }, { 133, 11,  281 },
  {  13,  0,   44 }, {  14,  0,  214 }, {   5, 10,  214 }, {   7, 10,  603 },
  {   8, 10,  611 }, {   9, 10,  686 }, {  10, 10,   88 }, {  11, 10,  459 },
  {  11, 10,  496 }, {  12, 10,  463 }, { 140, 10,  590 }, { 139,  0,  328 },
  { 135, 11, 1064 }, { 137,  0,  133 }, {   7,  0,  168 }, {  13,  0,  196 },
  { 141,  0,  237 }, { 134, 10, 1703 }, { 134,  0, 1152 }, { 135,  0, 1245 },
  {   5,  0,  110 }, {   6,  0,  169 }, {   6,  0, 1702 }, {   7,  0,  400 },
  {   8,  0,  538 }, {   9,  0,  184 }, {   9,  0,  524 }, { 140,  0,  218 },
  {   6,  0, 1816 }, {  10,  0,  871 }, {  12,  0,  769 }, { 140,  0,  785 },
  { 132, 11,  630 }, {   7, 11,   33 }, {   7, 11,  120 }, {   8, 11,  489 },
  {   9, 11,  319 }, {  10, 11,  820 }, {  11, 11, 1004 }, {  12, 11,  379 },
  {  13, 11,  117 }, {  13, 11,  412 }, {  14, 11,   25 }, {  15, 11,   52 },
  {  15, 11,  161 }, {  16, 11,   47 }, { 149, 11,    2 }, {   6,  0,  133 },
  {   8,  0,  413 }, {   9,  0,  353 }, { 139,  0,  993 }, { 145, 10,   19 },
  {   4, 11,  937 }, { 133, 11,  801 }, { 134,  0,  978 }, {   6,  0,   93 },
  {   6,  0, 1508 }, {   7,  0, 1422 }, {   7,  0, 1851 }, {   8,  0,  673 },
  {   9,  0,  529 }, { 140,  0,   43 }, {   6,  0,  317 }, {  10,  0,  512 },
  {   4, 10,  737 }, {  11, 10,  294 }, {  12, 10,   60 }, {  12, 10,  437 },
  {  13, 10,   64 }, {  13, 10,  380 }, { 142, 10,  430 }, {   9,  0,  371 },
  {   7, 11, 1591 }, { 144, 11,   43 }, {   6, 10, 1758 }, {   8, 10,  520 },
  {   9, 10,  345 }, {   9, 10,  403 }, { 142, 10,  350 }, {   5,  0,  526 },
  {  10, 10,  242 }, { 138, 10,  579 }, {   9,  0,   25 }, {  10,  0,  467 },
  { 138,  0,  559 }, {   5, 10,  139 }, {   7, 10, 1168 }, { 138, 10,  539 },
  {   4,  0,  335 }, { 135,  0,  942 }, { 140,  0,  754 }, { 132, 11,  365 },
  {  11,  0,  182 }, { 142,  0,  195 }, { 142, 11,   29 }, {   5, 11,    7 },
  { 139, 11,  774 }, {   4, 11,  746 }, { 135, 11, 1090 }, {   8,  0,   39 },
  {  10,  0,  773 }, {  11,  0,   84 }, {  12,  0,  205 }, { 142,  0,    1 },
  {   5,  0,  601 }, {   5,  0,  870 }, {   5, 11,  360 }, { 136, 11,  237 },
  { 132,  0,  181 }, { 136,  0,  370 }, { 134,  0, 1652 }, {   8,  0,  358 },
  {   4, 10,  107 }, {   7, 10,  613 }, {   8, 10,  439 }, {   8, 10,  504 },
  {   9, 10,  501 }, {  10, 10,  383 }, { 139, 10,  477 }, { 132, 10,  229 },
  { 137, 11,  785 }, {   4,  0,   97 }, {   5,  0,  147 }, {   6,  0,  286 },
  {   7,  0, 1362 }, { 141,  0,  176 }, {   6,  0,  537 }, {   7,  0,  788 },
  {   7,  0, 1816 }, { 132, 10,  903 }, { 140, 10,   71 }, {   6,  0,  743 },
  { 134,  0, 1223 }, {   6,  0,  375 }, {   7,  0,  169 }, {   7,  0,  254 },
  {   8,  0,  780 }, { 135, 11, 1493 }, {   7,  0, 1714 }, {   4, 10,   47 },
  {   6, 10,  373 }, {   7, 10,  452 }, {   7, 10,  543 }, {   7, 10, 1856 },
  {   9, 10,    6 }, {  11, 10,  257 }, { 139, 10,  391 }, {   6,  0,  896 },
  { 136,  0, 1003 }, { 135,  0, 1447 }, { 137, 11,  341 }, {   5, 10,  980 },
  { 134, 10, 1754 }, { 145, 11,   22 }, {   4, 11,  277 }, {   5, 11,  608 },
  {   6, 11,  493 }, {   7, 11,  457 }, { 140, 11,  384 }, {   7, 10,  536 },
  {   7, 10, 1331 }, { 136, 10,  143 }, { 140,  0,  744 }, {   7, 11,   27 },
  { 135, 11,  316 }, {  18,  0,  126 }, {   5, 10,   19 }, { 134, 10,  533 },
  {   4,  0,  788 }, {  11,  0,   41 }, {   5, 11,  552 }, {   5, 11,  586 },
  {   5, 11,  676 }, {   6, 11,  448 }, {   8, 11,  244 }, {  11, 11,    1 },
  {  11, 11,   41 }, {  13, 11,    3 }, {  16, 11,   54 }, {  17, 11,    4 },
  { 146, 11,   13 }, {   4,  0,  985 }, {   6,  0, 1801 }, {   4, 11,  401 },
  { 137, 11,  264 }, {   5, 10,  395 }, {   5, 10,  951 }, { 134, 10, 1776 },
  {   5,  0,  629 }, { 135,  0, 1549 }, {  11, 10,  663 }, {  12, 10,  210 },
  {  13, 10,  166 }, {  13, 10,  310 }, {  14, 10,  373 }, { 147, 10,   43 },
  {   9, 11,  543 }, {  10, 11,  524 }, {  11, 11,   30 }, {  12, 11,  524 },
  {  14, 11,  315 }, {  16, 11,   18 }, {  20, 11,   26 }, { 148, 11,   65 },
  {   4, 11,  205 }, {   5, 11,  623 }, {   7, 11,  104 }, { 136, 11,  519 },
  {   5,  0,  293 }, { 134,  0,  601 }, {   7, 11,  579 }, {   9, 11,   41 },
  {   9, 11,  244 }, {   9, 11,  669 }, {  10, 11,    5 }, {  11, 11,  861 },
  {  11, 11,  951 }, { 139, 11,  980 }, { 132, 11,  717 }, { 132, 10,  695 },
  {   7, 10,  497 }, {   9, 10,  387 }, { 147, 10,   81 }, { 132,  0,  420 },
  { 142,  0,   37 }, {   6,  0, 1134 }, {   6,  0, 1900 }, {  12,  0,  830 },
  {  12,  0,  878 }, {  12,  0,  894 }, {  15,  0,  221 }, { 143,  0,  245 },
  { 132, 11,  489 }, {   7,  0, 1570 }, { 140,  0,  542 }, {   8,  0,  933 },
  { 136,  0,  957 }, {   6,  0, 1371 }, {   7,  0,   31 }, {   8,  0,  373 },
  {   5, 10,  284 }, {   6, 10,   49 }, {   6, 10,  350 }, {   7, 10,  377 },
  {   7, 10, 1693 }, {   8, 10,  678 }, {   9, 10,  161 }, {   9, 10,  585 },
  {   9, 10,  671 }, {   9, 10,  839 }, {  11, 10,  912 }, { 141, 10,  427 },
  { 135, 11,  892 }, {   4,  0,  325 }, { 138,  0,  125 }, { 139, 11,   47 },
  { 132, 10,  597 }, { 138,  0,  323 }, {   6,  0, 1547 }, {   7, 11, 1605 },
  {   9, 11,  473 }, {  11, 11,  962 }, { 146, 11,  139 }, { 139, 10,  908 },
  {   7, 11,  819 }, {   9, 11,   26 }, {   9, 11,  392 }, {  10, 11,  152 },
  {  10, 11,  226 }, {  11, 11,   19 }, {  12, 11,  276 }, {  12, 11,  426 },
  {  12, 11,  589 }, {  13, 11,  460 }, {  15, 11,   97 }, {  19, 11,   48 },
  { 148, 11,  104 }, { 135, 11,   51 }, {   4,  0,  718 }, { 135,  0, 1216 },
  {   6,  0, 1896 }, {   6,  0, 1905 }, {   6,  0, 1912 }, {   9,  0,  947 },
  {   9,  0,  974 }, {  12,  0,  809 }, {  12,  0,  850 }, {  12,  0,  858 },
  {  12,  0,  874 }, {  12,  0,  887 }, {  12,  0,  904 }, {  12,  0,  929 },
  {  12,  0,  948 }, {  12,  0,  952 }, {  15,  0,  198 }, {  15,  0,  206 },
  {  15,  0,  220 }, {  15,  0,  227 }, {  15,  0,  247 }, {  18,  0,  188 },
  {  21,  0,   48 }, {  21,  0,   50 }, {  24,  0,   25 }, {  24,  0,   29 },
  {   7, 11,  761 }, {   7, 11, 1051 }, { 137, 11,  545 }, {   5,  0,  124 },
  {   5,  0,  144 }, {   6,  0,  548 }, {   7,  0,   15 }, {   7,  0,  153 },
  { 137,  0,  629 }, { 135, 11,  606 }, { 135, 10, 2014 }, {   7, 10, 2007 },
  {   9, 11,   46 }, {   9, 10,  101 }, {   9, 10,  450 }, {  10, 10,   66 },
  {  10, 10,  842 }, {  11, 10,  536 }, { 140, 10,  587 }, {   6,  0,   75 },
  {   7,  0, 1531 }, {   8,  0,  416 }, {   9,  0,  240 }, {   9,  0,  275 },
  {  10,  0,  100 }, {  11,  0,  658 }, {  11,  0,  979 }, {  12,  0,   86 },
  {  14,  0,  207 }, {  15,  0,   20 }, { 143,  0,   25 }, {   5,  0,  141 },
  {   5,  0,  915 }, {   6,  0, 1783 }, {   7,  0,  211 }, {   7,  0,  698 },
  {   7,  0, 1353 }, {   9,  0,   83 }, {   9,  0,  281 }, {  10,  0,  376 },
  {  10,  0,  431 }, {  11,  0,  543 }, {  12,  0,  664 }, {  13,  0,  280 },
  {  13,  0,  428 }, {  14,  0,   61 }, {  14,  0,  128 }, {  17,  0,   52 },
  { 145,  0,   81 }, { 132, 11,  674 }, { 135,  0,  533 }, { 149,  0,    6 },
  { 132, 11,  770 }, { 133,  0,  538 }, {   5, 11,   79 }, {   7, 11, 1027 },
  {   7, 11, 1477 }, { 139, 11,   52 }, { 139, 10,   62 }, {   4,  0,  338 },
  { 133,  0,  400 }, {   5, 11,  789 }, { 134, 11,  195 }, {   4, 11,  251 },
  {   4, 11,  688 }, {   7, 11,  513 }, {   7, 11, 1284 }, {   9, 11,   87 },
  { 138, 11,  365 }, { 134, 10, 1766 }, {   6,  0,    0 }, {   7,  0,   84 },
  {  11,  0,  895 }, { 145,  0,   11 }, { 139,  0,  892 }, {   4,  0,  221 },
  {   5,  0,  659 }, {   7,  0,  697 }, {   7,  0, 1211 }, { 138,  0,  284 },
  { 133,  0,  989 }, { 133, 11,  889 }, {   4, 11,  160 }, {   5, 11,  330 },
  {   7, 11, 1434 }, { 136, 11,  174 }, {   6, 10, 1665 }, {   7, 10,  256 },
  {   7, 10, 1388 }, {  10, 10,  499 }, { 139, 10,  670 }, {   7,  0,  848 },
  {   4, 10,   22 }, {   5, 10,   10 }, { 136, 10,   97 }, { 138,  0,  507 },
  { 133, 10,  481 }, {   4,  0,  188 }, { 135,  0,  805 }, {   5,  0,  884 },
  {   6,  0,  732 }, { 139,  0,  991 }, { 135, 11,  968 }, {  11, 11,  636 },
  {  15, 11,  145 }, {  17, 11,   34 }, {  19, 11,   50 }, { 151, 11,   20 },
  {   7,  0,  959 }, {  16,  0,   60 }, {   6, 10,  134 }, {   7, 10,  437 },
  {   9, 10,   37 }, {  14, 10,  285 }, { 142, 10,  371 }, {   7, 10,  486 },
  {   8, 10,  155 }, {  11, 10,   93 }, { 140, 10,  164 }, { 134,  0, 1653 },
  {   7,  0,  337 }, { 133, 10,  591 }, {   6,  0, 1989 }, {   8,  0,  922 },
  {   8,  0,  978 }, { 133, 11,  374 }, { 132,  0,  638 }, { 138,  0,  500 },
  { 133, 11,  731 }, {   5, 10,  380 }, {   5, 10,  650 }, { 136, 10,  310 },
  { 138, 11,  381 }, {   4, 10,  364 }, {   7, 10, 1156 }, {   7, 10, 1187 },
  { 137, 10,  409 }, { 137, 11,  224 }, { 140,  0,  166 }, { 134, 10,  482 },
  {   4, 11,  626 }, {   5, 11,  642 }, {   6, 11,  425 }, {  10, 11,  202 },
  { 139, 11,  141 }, {   4, 10,  781 }, {   6, 10,  487 }, {   7, 10,  926 },
  {   8, 10,  263 }, { 139, 10,  500 }, { 135,  0,  418 }, {   4, 10,   94 },
  { 135, 10, 1265 }, { 136,  0,  760 }, { 132, 10,  417 }, { 136, 11,  835 },
  {   5, 10,  348 }, { 134, 10,  522 }, {   6,  0, 1277 }, { 134,  0, 1538 },
  { 139, 11,  541 }, { 135, 11, 1597 }, {   5, 11,  384 }, {   8, 11,  455 },
  { 140, 11,   48 }, { 136,  0,  770 }, {   5, 11,  264 }, { 134, 11,  184 },
  {   4,  0,   89 }, {   5,  0,  489 }, {   6,  0,  315 }, {   7,  0,  553 },
  {   7,  0, 1745 }, { 138,  0,  243 }, {   4, 10,  408 }, {   4, 10,  741 },
  { 135, 10,  500 }, { 134,  0, 1396 }, { 133,  0,  560 }, {   6,  0, 1658 },
  {   9,  0,    3 }, {  10,  0,  154 }, {  11,  0,  641 }, {  13,  0,   85 },
  {  13,  0,  201 }, { 141,  0,  346 }, { 135, 11, 1595 }, {   5, 11,  633 },
  {   6, 11,   28 }, {   7, 11,  219 }, { 135, 11, 1323 }, {   9, 11,  769 },
  { 140, 11,  185 }, { 135, 11,  785 }, {   7, 11,  359 }, {   8, 11,  243 },
  { 140, 11,  175 }, { 138,  0,  586 }, {   7,  0, 1271 }, { 134, 10,   73 },
  { 132, 11,  105 }, {   4,  0,  166 }, {   5,  0,  505 }, { 134,  0, 1670 },
  { 133, 10,  576 }, {   4, 11,  324 }, { 138, 11,  104 }, { 142, 10,  231 },
  {   6,  0,  637 }, {   7, 10, 1264 }, {   7, 10, 1678 }, {  11, 10,  945 },
  {  12, 10,  341 }, {  12, 10,  471 }, {  12, 10,  569 }, {  23, 11,   21 },
  { 151, 11,   23 }, {   8, 11,  559 }, { 141, 11,  109 }, { 134,  0, 1947 },
  {   7,  0,  445 }, {   8,  0,  307 }, {   8,  0,  704 }, {  10,  0,   41 },
  {  10,  0,  439 }, {  11,  0,  237 }, {  11,  0,  622 }, { 140,  0,  201 },
  { 135, 11,  963 }, { 135,  0, 1977 }, {   4,  0,  189 }, {   5,  0,  713 },
  { 136,  0,   57 }, { 138,  0,  371 }, { 135, 10,  538 }, { 132,  0,  552 },
  {   6,  0,  883 }, { 133, 10,  413 }, {   6,  0,  923 }, { 132, 11,  758 },
  { 138, 11,  215 }, { 136, 10,  495 }, {   7, 10,   54 }, {   8, 10,  312 },
  {  10, 10,  191 }, {  10, 10,  614 }, { 140, 10,  567 }, {   7, 11,  351 },
  { 139, 11,  128 }, {   7,  0,  875 }, {   6, 10,  468 }, {   7, 10, 1478 },
  {   8, 10,  530 }, { 142, 10,  290 }, { 135,  0, 1788 }, {  17,  0,   49 },
  { 133, 11,  918 }, {  12, 11,  398 }, {  20, 11,   39 }, {  21, 11,   11 },
  { 150, 11,   41 }, {  10,  0,  661 }, {   6, 10,  484 }, { 135, 10,  822 },
  { 135,  0, 1945 }, { 134,  0,  794 }, { 137, 10,  900 }, { 135, 10, 1335 },
  {   6, 10, 1724 }, { 135, 10, 2022 }, { 132, 11,  340 }, { 134,  0, 1135 },
  {   4,  0,  784 }, { 133,  0,  745 }, {   5,  0,   84 }, { 134,  0,  163 },
  { 133,  0,  410 }, {   4,  0,  976 }, {   5, 11,  985 }, {   7, 11,  509 },
  {   7, 11,  529 }, { 145, 11,   96 }, { 132, 10,  474 }, { 134,  0,  703 },
  { 135, 11, 1919 }, {   5,  0,  322 }, {   8,  0,  186 }, {   9,  0,  262 },
  {  10,  0,  187 }, { 142,  0,  208 }, { 135, 10, 1504 }, { 133,  0,  227 },
  {   9,  0,  560 }, {  13,  0,  208 }, { 133, 10,  305 }, { 132, 11,  247 },
  {   7,  0, 1395 }, {   8,  0,  486 }, {   9,  0,  236 }, {   9,  0,  878 },
  {  10,  0,  218 }, {  11,  0,   95 }, {  19,  0,   17 }, { 147,  0,   31 },
  {   7,  0, 2043 }, {   8,  0,  672 }, { 141,  0,  448 }, {   4, 11,  184 },
  {   5, 11,  390 }, {   6, 11,  337 }, {   7, 11,   23 }, {   7, 11,  494 },
  {   7, 11,  618 }, {   7, 11, 1456 }, {   8, 11,   27 }, {   8, 11,  599 },
  {  10, 11,  153 }, { 139, 11,  710 }, { 135,  0,  466 }, { 135, 10, 1236 },
  {   6,  0,  167 }, {   7,  0,  186 }, {   7,  0,  656 }, {  10,  0,  643 },
  {   4, 10,  480 }, {   6, 10,  302 }, {   6, 10, 1642 }, {   7, 10,  837 },
  {   7, 10, 1547 }, {   7, 10, 1657 }, {   8, 10,  429 }, {   9, 10,  228 },
  {  13, 10,  289 }, {  13, 10,  343 }, { 147, 10,  101 }, { 134,  0, 1428 },
  { 134,  0, 1440 }, {   5,  0,  412 }, {   7, 10,  278 }, {  10, 10,  739 },
  {  11, 10,  708 }, { 141, 10,  348 }, { 134,  0, 1118 }, { 136,  0,  562 },
  { 148, 11,   46 }, {   9,  0,  316 }, { 139,  0,  256 }, { 134,  0, 1771 },
  { 135,  0, 1190 }, { 137,  0,  132 }, {  10, 11,  227 }, {  11, 11,  497 },
  {  11, 11,  709 }, { 140, 11,  415 }, { 143,  0,   66 }, {   6, 11,  360 },
  {   7, 11, 1664 }, { 136, 11,  478 }, { 144, 10,   28 }, {   4,  0,  317 },
  { 135,  0, 1279 }, {   5,  0,   63 }, { 133,  0,  509 }, { 136, 11,  699 },
  { 145, 10,   36 }, { 134,  0, 1475 }, {  11, 11,  343 }, { 142, 11,  127 },
  { 132, 11,  739 }, { 132,  0,  288 }, { 135, 11, 1757 }, {   8,  0,   89 },
  {   8,  0,  620 }, {   9,  0,  608 }, {  11,  0,  628 }, {  12,  0,  322 },
  { 143,  0,  124 }, { 134,  0, 1225 }, {   7,  0, 1189 }, {   4, 11,   67 },
  {   5, 11,  422 }, {   6, 10,  363 }, {   7, 11, 1037 }, {   7, 11, 1289 },
  {   7, 11, 1555 }, {   7, 10, 1955 }, {   8, 10,  725 }, {   9, 11,  741 },
  { 145, 11,  108 }, { 134,  0, 1468 }, {   6,  0,  689 }, { 134,  0, 1451 },
  { 138,  0,  120 }, { 151,  0,    1 }, { 137, 10,  805 }, { 142,  0,  329 },
  {   5, 10,  813 }, { 135, 10, 2046 }, { 135,  0,  226 }, { 138, 11,   96 },
  {   7,  0, 1855 }, {   5, 10,  712 }, {  11, 10,   17 }, {  13, 10,  321 },
  { 144, 10,   67 }, {   9,  0,  461 }, {   6, 10,  320 }, {   7, 10,  781 },
  {   7, 10, 1921 }, {   9, 10,   55 }, {  10, 10,  186 }, {  10, 10,  273 },
  {  10, 10,  664 }, {  10, 10,  801 }, {  11, 10,  996 }, {  11, 10,  997 },
  {  13, 10,  157 }, { 142, 10,  170 }, {   8, 11,  203 }, {   8, 10,  271 },
  {  11, 11,  823 }, {  11, 11,  846 }, {  12, 11,  482 }, {  13, 11,  133 },
  {  13, 11,  277 }, {  13, 11,  302 }, {  13, 11,  464 }, {  14, 11,  205 },
  { 142, 11,  221 }, { 135,  0, 1346 }, {   4, 11,  449 }, { 133, 11,  718 },
  { 134,  0,   85 }, {  14,  0,  299 }, {   7, 10,  103 }, {   7, 10,  863 },
  {  11, 10,  184 }, { 145, 10,   62 }, {   4, 11,  355 }, {   6, 11,  311 },
  {   9, 11,  256 }, { 138, 11,  404 }, { 137, 10,  659 }, { 138, 11,  758 },
  { 133, 11,  827 }, {   5, 11,   64 }, { 140, 11,  581 }, { 134,  0, 1171 },
  {   4, 11,  442 }, {   7, 11, 1047 }, {   7, 11, 1352 }, { 135, 11, 1643 },
  { 132,  0,  980 }, {   5, 11,  977 }, {   6, 11,  288 }, {   7, 11,  528 },
  { 135, 11, 1065 }, {   5,  0,  279 }, {   6,  0,  235 }, {   7,  0,  468 },
  {   8,  0,  446 }, {   9,  0,  637 }, {  10,  0,  717 }, {  11,  0,  738 },
  { 140,  0,  514 }, { 132,  0,  293 }, {  11, 10,  337 }, { 142, 10,  303 },
  { 136, 11,  285 }, {   5,  0,   17 }, {   6,  0,  371 }, {   9,  0,  528 },
  {  12,  0,  364 }, { 132, 11,  254 }, {   5, 10,   77 }, {   7, 10, 1455 },
  {  10, 10,  843 }, { 147, 10,   73 }, { 150,  0,    5 }, { 132, 10,  458 },
  {   6, 11,   12 }, {   7, 11, 1219 }, { 145, 11,   73 }, { 135, 10, 1420 },
  {   6, 10,  109 }, { 138, 10,  382 }, { 135, 11,  125 }, {   6, 10,  330 },
  {   7, 10, 1084 }, { 139, 10,  142 }, {   6, 11,  369 }, {   6, 11,  502 },
  {   7, 11, 1036 }, {   8, 11,  348 }, {   9, 11,  452 }, {  10, 11,   26 },
  {  11, 11,  224 }, {  11, 11,  387 }, {  11, 11,  772 }, {  12, 11,   95 },
  {  12, 11,  629 }, {  13, 11,  195 }, {  13, 11,  207 }, {  13, 11,  241 },
  {  14, 11,  260 }, {  14, 11,  270 }, { 143, 11,  140 }, { 132, 11,  269 },
  {   5, 11,  480 }, {   7, 11,  532 }, {   7, 11, 1197 }, {   7, 11, 1358 },
  {   8, 11,  291 }, {  11, 11,  349 }, { 142, 11,  396 }, { 150,  0,   48 },
  {  10,  0,  601 }, {  13,  0,  353 }, { 141,  0,  376 }, {   5,  0,  779 },
  {   5,  0,  807 }, {   6,  0, 1655 }, { 134,  0, 1676 }, { 142, 11,  223 },
  {   4,  0,  196 }, {   5,  0,  558 }, { 133,  0,  949 }, { 148, 11,   15 },
  { 135, 11, 1764 }, { 134,  0, 1322 }, { 132,  0,  752 }, { 139,  0,  737 },
  { 135, 11,  657 }, { 136, 11,  533 }, { 135,  0,  412 }, {   4,  0,  227 },
  {   5,  0,  159 }, {   5,  0,  409 }, {   7,  0,   80 }, {   8,  0,  556 },
  {  10,  0,  479 }, {  12,  0,  418 }, {  14,  0,   50 }, {  14,  0,  123 },
  {  14,  0,  192 }, {  14,  0,  249 }, {  14,  0,  295 }, { 143,  0,   27 },
  {   7,  0, 1470 }, {   8,  0,   66 }, {   8,  0,  137 }, {   8,  0,  761 },
  {   9,  0,  638 }, {  11,  0,   80 }, {  11,  0,  212 }, {  11,  0,  368 },
  {  11,  0,  418 }, {  12,  0,    8 }, {  13,  0,   15 }, {  16,  0,   61 },
  {  17,  0,   59 }, {  19,  0,   28 }, { 148,  0,   84 }, { 135, 10, 1985 },
  {   4, 11,  211 }, {   4, 11,  332 }, {   5, 11,  335 }, {   6, 11,  238 },
  {   7, 11,  269 }, {   7, 11,  811 }, {   7, 11, 1797 }, {   8, 10,  122 },
  {   8, 11,  836 }, {   9, 11,  507 }, { 141, 11,  242 }, {   6,  0,  683 },
  { 134,  0, 1252 }, {   4,  0,  873 }, { 132, 10,  234 }, { 134,  0,  835 },
  {   6,  0,   38 }, {   7,  0, 1220 }, {   8,  0,  185 }, {   8,  0,  256 },
  {   9,  0,   22 }, {   9,  0,  331 }, {  10,  0,  738 }, {  11,  0,  205 },
  {  11,  0,  540 }, {  11,  0,  746 }, {  13,  0,  465 }, {  14,  0,   88 },
  { 142,  0,  194 }, { 138,  0,  986 }, {   5, 11, 1009 }, {  12, 11,  582 },
  { 146, 11,  131 }, {   4,  0,  159 }, {   6,  0,  115 }, {   7,  0,  252 },
  {   7,  0,  257 }, {   7,  0, 1928 }, {   8,  0,   69 }, {   9,  0,  384 },
  {  10,  0,   91 }, {  10,  0,  615 }, {  12,  0,  375 }, {  14,  0,  235 },
  {  18,  0,  117 }, { 147,  0,  123 }, { 133,  0,  911 }, { 136,  0,  278 },
  {   5, 10,  430 }, {   5, 10,  932 }, {   6, 10,  131 }, {   7, 10,  417 },
  {   9, 10,  522 }, {  11, 10,  314 }, { 141, 10,  390 }, {  14, 10,  149 },
  {  14, 10,  399 }, { 143, 10,   57 }, {   4,  0,  151 }, {   7,  0, 1567 },
  { 136,  0,  749 }, {   5, 11,  228 }, {   6, 11,  203 }, {   7, 11,  156 },
  {   8, 11,  347 }, { 137, 11,  265 }, { 132, 10,  507 }, {  10,  0,  989 },
  { 140,  0,  956 }, { 133,  0,  990 }, {   5,  0,  194 }, {   6,  0,  927 },
  {   7,  0, 1662 }, {   9,  0,   90 }, { 140,  0,  564 }, {   4, 10,  343 },
  { 133, 10,  511 }, { 133,  0,  425 }, {   7, 10,  455 }, { 138, 10,  591 },
  {   4,  0,  774 }, {   7, 11,  476 }, {   7, 11, 1592 }, { 138, 11,   87 },
  {   5,  0,  971 }, { 135, 10, 1381 }, {   5, 11,  318 }, { 147, 11,  121 },
  {   5, 11,  291 }, {   7, 11,  765 }, {   9, 11,  389 }, { 140, 11,  548 },
  { 134, 10,  575 }, {   4,  0,  827 }, {  12,  0,  646 }, {  12,  0,  705 },
  {  12,  0,  712 }, { 140,  0,  714 }, { 139,  0,  752 }, { 137,  0,  662 },
  {   5,  0,   72 }, {   6,  0,  264 }, {   7,  0,   21 }, {   7,  0,   46 },
  {   7,  0, 2013 }, {   8,  0,  215 }, {   8,  0,  513 }, {  10,  0,  266 },
  { 139,  0,   22 }, { 139, 11,  522 }, {   6,  0,  239 }, {   7,  0,  118 },
  {  10,  0,   95 }, {  11,  0,  603 }, {  13,  0,  443 }, {  14,  0,  160 },
  { 143,  0,    4 }, {   6,  0,  431 }, { 134,  0,  669 }, {   7, 10, 1127 },
  {   7, 10, 1572 }, {  10, 10,  297 }, {  10, 10,  422 }, {  11, 10,  764 },
  {  11, 10,  810 }, {  12, 10,  264 }, {  13, 10,  102 }, {  13, 10,  300 },
  {  13, 10,  484 }, {  14, 10,  147 }, {  14, 10,  229 }, {  17, 10,   71 },
  {  18, 10,  118 }, { 147, 10,  120 }, {   5,  0,  874 }, {   6,  0, 1677 },
  {  15,  0,    0 }, {  10, 11,  525 }, { 139, 11,   82 }, {   6,  0,   65 },
  {   7,  0,  939 }, {   7,  0, 1172 }, {   7,  0, 1671 }, {   9,  0,  540 },
  {  10,  0,  696 }, {  11,  0,  265 }, {  11,  0,  732 }, {  11,  0,  928 },
  {  11,  0,  937 }, { 141,  0,  438 }, { 134,  0, 1350 }, { 136, 11,  547 },
  { 132, 11,  422 }, {   5, 11,  355 }, { 145, 11,    0 }, { 137, 11,  905 },
  {   5,  0,  682 }, { 135,  0, 1887 }, { 132,  0,  809 }, {   4,  0,  696 },
  { 133, 11,  865 }, {   6,  0, 1074 }, {   6,  0, 1472 }, {  14, 10,   35 },
  { 142, 10,  191 }, {   5, 11,  914 }, { 134, 11, 1625 }, { 133, 11,  234 },
  { 135, 11, 1383 }, { 137, 11,  780 }, { 132, 10,  125 }, {   4,  0,  726 },
  { 133,  0,  630 }, {   8,  0,  802 }, { 136,  0,  838 }, { 132, 10,  721 },
  {   6,  0, 1337 }, {   7,  0,  776 }, {  19,  0,   56 }, { 136, 10,  145 },
  { 132,  0,  970 }, {   7, 10,  792 }, {   8, 10,  147 }, {  10, 10,  821 },
  { 139, 10, 1021 }, { 139, 10,  970 }, {   8,  0,  940 }, { 137,  0,  797 },
  { 135, 11, 1312 }, {   9,  0,  248 }, {  10,  0,  400 }, {   7, 11,  816 },
  {   7, 11, 1241 }, {   7, 10, 1999 }, {   9, 11,  283 }, {   9, 11,  520 },
  {  10, 11,  213 }, {  10, 11,  307 }, {  10, 11,  463 }, {  10, 11,  671 },
  {  10, 11,  746 }, {  11, 11,  401 }, {  11, 11,  794 }, {  12, 11,  517 },
  {  18, 11,  107 }, { 147, 11,  115 }, {   6,  0, 1951 }, { 134,  0, 2040 },
  { 135, 11,  339 }, {  13,  0,   41 }, {  15,  0,   93 }, {   5, 10,  168 },
  {   5, 10,  930 }, {   8, 10,   74 }, {   9, 10,  623 }, {  12, 10,  500 },
  { 140, 10,  579 }, {   6,  0,  118 }, {   7,  0,  215 }, {   7,  0, 1521 },
  { 140,  0,   11 }, {   6, 10,  220 }, {   7, 10, 1101 }, { 141, 10,  105 },
  {   6, 11,  421 }, {   7, 11,   61 }, {   7, 11, 1540 }, {  10, 11,   11 },
  { 138, 11,  501 }, {   7,  0,  615 }, { 138,  0,  251 }, { 140, 11,  631 },
  { 135,  0, 1044 }, {   6, 10,   19 }, {   7, 10, 1413 }, { 139, 10,  428 },
  { 133,  0,  225 }, {   7, 10,   96 }, {   8, 10,  401 }, {   8, 10,  703 },
  { 137, 10,  896 }, { 145, 10,  116 }, {   6, 11,  102 }, {   7, 11,   72 },
  {  15, 11,  142 }, { 147, 11,   67 }, {   7, 10, 1961 }, {   7, 10, 1965 },
  {   8, 10,  702 }, { 136, 10,  750 }, {   7, 10, 2030 }, {   8, 10,  150 },
  {   8, 10,  737 }, {  12, 10,  366 }, { 151, 11,   30 }, {   4,  0,  370 },
  {   5,  0,  756 }, {   7,  0, 1326 }, { 135, 11,  823 }, {   8, 10,  800 },
  {   9, 10,  148 }, {   9, 10,  872 }, {   9, 10,  890 }, {  11, 10,  309 },
  {  11, 10, 1001 }, {  13, 10,  267 }, { 141, 10,  323 }, {   6,  0, 1662 },
  {   7,  0,   48 }, {   8,  0,  771 }, {  10,  0,  116 }, {  13,  0,  104 },
  {  14,  0,  105 }, {  14,  0,  184 }, {  15,  0,  168 }, {  19,  0,   92 },
  { 148,  0,   68 }, {  10,  0,  209 }, { 135, 11, 1870 }, {   7, 11,   68 },
  {   8, 11,   48 }, {   8, 11,   88 }, {   8, 11,  582 }, {   8, 11,  681 },
  {   9, 11,  373 }, {   9, 11,  864 }, {  11, 11,  157 }, {  11, 11,  336 },
  {  11, 11,  843 }, { 148, 11,   27 }, { 134,  0,  930 }, {   4, 11,   88 },
  {   5, 11,  137 }, {   5, 11,  174 }, {   5, 11,  777 }, {   6, 11, 1664 },
  {   6, 11, 1725 }, {   7, 11,   77 }, {   7, 11,  426 }, {   7, 11, 1317 },
  {   7, 11, 1355 }, {   8, 11,  126 }, {   8, 11,  563 }, {   9, 11,  523 },
  {   9, 11,  750 }, {  10, 11,  310 }, {  10, 11,  836 }, {  11, 11,   42 },
  {  11, 11,  318 }, {  11, 11,  731 }, {  12, 11,   68 }, {  12, 11,   92 },
  {  12, 11,  507 }, {  12, 11,  692 }, {  13, 11,   81 }, {  13, 11,  238 },
  {  13, 11,  374 }, {  18, 11,  138 }, {  19, 11,   78 }, {  19, 11,  111 },
  {  20, 11,   55 }, {  20, 11,   77 }, { 148, 11,   92 }, {   4, 11,  938 },
  { 135, 11, 1831 }, {   5, 10,  547 }, {   7, 10,  424 }, {   8, 11,  617 },
  { 138, 11,  351 }, {   6,  0, 1286 }, {   6, 11, 1668 }, {   7, 11, 1499 },
  {   8, 11,  117 }, {   9, 11,  314 }, { 138, 11,  174 }, {   6,  0,  759 },
  {   6,  0,  894 }, {   7, 11,  707 }, { 139, 11,  563 }, {   4,  0,  120 },
  { 135,  0, 1894 }, {   9,  0,  385 }, { 149,  0,   17 }, { 138,  0,  429 },
  { 133, 11,  403 }, {   5,  0,  820 }, { 135,  0,  931 }, {  10,  0,  199 },
  { 133, 10,  133 }, {   6,  0,  151 }, {   6,  0, 1675 }, {   7,  0,  383 },
  { 151,  0,   10 }, {   6,  0,  761 }, { 136, 10,  187 }, {   8,  0,  365 },
  {  10, 10,    0 }, {  10, 10,  818 }, { 139, 10,  988 }, {   4, 11,   44 },
  {   5, 11,  311 }, {   6, 11,  156 }, {   7, 11,  639 }, {   7, 11,  762 },
  {   7, 11, 1827 }, {   9, 11,    8 }, {   9, 11,  462 }, { 148, 11,   83 },
  {   4, 11,  346 }, {   7, 11,  115 }, {   9, 11,  180 }, {   9, 11,  456 },
  { 138, 11,  363 }, { 136, 10,  685 }, {   7,  0, 1086 }, { 145,  0,   46 },
  {   6,  0, 1624 }, {  11,  0,   11 }, {  12,  0,  422 }, {  13,  0,  444 },
  { 142,  0,  360 }, {   6,  0, 1020 }, {   6,  0, 1260 }, { 134,  0, 1589 },
  {   4,  0,   43 }, {   5,  0,  344 }, {   5,  0,  357 }, {  14,  0,  472 },
  { 150,  0,   58 }, {   6,  0, 1864 }, {   6,  0, 1866 }, {   6,  0, 1868 },
  {   6,  0, 1869 }, {   6,  0, 1874 }, {   6,  0, 1877 }, {   6,  0, 1903 },
  {   6,  0, 1911 }, {   9,  0,  920 }, {   9,  0,  921 }, {   9,  0,  924 },
  {   9,  0,  946 }, {   9,  0,  959 }, {   9,  0,  963 }, {   9,  0,  970 },
  {   9,  0,  997 }, {   9,  0, 1008 }, {   9,  0, 1017 }, {  12,  0,  795 },
  {  12,  0,  797 }, {  12,  0,  798 }, {  12,  0,  800 }, {  12,  0,  803 },
  {  12,  0,  811 }, {  12,  0,  820 }, {  12,  0,  821 }, {  12,  0,  839 },
  {  12,  0,  841 }, {  12,  0,  848 }, {  12,  0,  911 }, {  12,  0,  921 },
  {  12,  0,  922 }, {  12,  0,  925 }, {  12,  0,  937 }, {  12,  0,  944 },
  {  12,  0,  945 }, {  12,  0,  953 }, {  15,  0,  184 }, {  15,  0,  191 },
  {  15,  0,  199 }, {  15,  0,  237 }, {  15,  0,  240 }, {  15,  0,  243 },
  {  15,  0,  246 }, {  18,  0,  203 }, {  21,  0,   40 }, {  21,  0,   52 },
  {  21,  0,   57 }, {  24,  0,   23 }, {  24,  0,   28 }, { 152,  0,   30 },
  { 134,  0,  725 }, { 145, 11,   58 }, { 133,  0,  888 }, { 137, 10,  874 },
  {   4,  0,  711 }, {   8, 10,  774 }, {  10, 10,  670 }, { 140, 10,   51 },
  { 144, 11,   40 }, {   6, 11,  185 }, {   7, 11, 1899 }, { 139, 11,  673 },
  { 137, 10,  701 }, { 137,  0,  440 }, {   4, 11,  327 }, {   5, 11,  478 },
  {   7, 11, 1332 }, {   8, 11,  753 }, { 140, 11,  227 }, {   4, 10,  127 },
  {   5, 10,  350 }, {   6, 10,  356 }, {   8, 10,  426 }, {   9, 10,  572 },
  {  10, 10,  247 }, { 139, 10,  312 }, {   5, 11, 1020 }, { 133, 11, 1022 },
  {   4, 11,  103 }, { 133, 11,  401 }, {   6,  0, 1913 }, {   6,  0, 1926 },
  {   6,  0, 1959 }, {   9,  0,  914 }, {   9,  0,  939 }, {   9,  0,  952 },
  {   9,  0,  979 }, {   9,  0,  990 }, {   9,  0,  998 }, {   9,  0, 1003 },
  {   9,  0, 1023 }, {  12,  0,  827 }, {  12,  0,  834 }, {  12,  0,  845 },
  {  12,  0,  912 }, {  12,  0,  935 }, {  12,  0,  951 }, {  15,  0,  172 },
  {  15,  0,  174 }, {  18,  0,  198 }, { 149,  0,   63 }, {   5,  0,  958 },
  {   5,  0,  987 }, {   4, 11,  499 }, { 135, 11, 1421 }, {   7,  0,  885 },
  {   6, 10,   59 }, {   6, 10, 1762 }, {   9, 10,  603 }, { 141, 10,  397 },
  {  10, 11,   62 }, { 141, 11,  164 }, {   4,  0,  847 }, { 135,  0,  326 },
  {  11,  0,  276 }, { 142,  0,  293 }, {   4,  0,   65 }, {   5,  0,  479 },
  {   5,  0, 1004 }, {   7,  0, 1913 }, {   8,  0,  317 }, {   9,  0,  302 },
  {  10,  0,  612 }, {  13,  0,   22 }, { 132, 11,   96 }, {   4,  0,  261 },
  { 135,  0,  510 }, { 135,  0, 1514 }, {   6, 10,  111 }, {   7, 10,    4 },
  {   8, 10,  163 }, {   8, 10,  776 }, { 138, 10,  566 }, {   4,  0,  291 },
  {   9,  0,  515 }, {  12,  0,  152 }, {  12,  0,  443 }, {  13,  0,  392 },
  { 142,  0,  357 }, {   7, 11,  399 }, { 135, 11, 1492 }, {   4,  0,  589 },
  { 139,  0,  282 }, {   6, 11,  563 }, { 135, 10, 1994 }, {   5, 10,  297 },
  { 135, 10, 1038 }, {   4,  0,  130 }, {   7,  0,  843 }, { 135,  0, 1562 },
  {   5,  0,   42 }, {   5,  0,  879 }, {   7,  0,  245 }, {   7,  0,  324 },
  {   7,  0, 1532 }, {  11,  0,  463 }, {  11,  0,  472 }, {  13,  0,  363 },
  { 144,  0,   52 }, {   4,  0,  134 }, { 133,  0,  372 }, { 133,  0,  680 },
  { 136, 10,  363 }, {   6,  0, 1997 }, {   8,  0,  935 }, { 136,  0,  977 },
  {   4,  0,  810 }, { 135,  0, 1634 }, { 135, 10, 1675 }, {   7,  0, 1390 },
  {   4, 11,  910 }, { 133, 11,  832 }, {   7, 10,  808 }, {   8, 11,  266 },
  { 139, 11,  578 }, { 132,  0,  644 }, {   4,  0,  982 }, { 138,  0,  867 },
  { 132, 10,  280 }, { 135,  0,  540 }, { 140, 10,   54 }, { 135,  0,  123 },
  { 134,  0, 1978 }, {   4, 10,  421 }, { 133, 10,  548 }, {   6,  0,  623 },
  { 136,  0,  789 }, {   4,  0,  908 }, {   5,  0,  359 }, {   5,  0,  508 },
  {   6,  0, 1723 }, {   7,  0,  343 }, {   7,  0, 1996 }, { 135,  0, 2026 },
  { 134,  0, 1220 }, {   4,  0,  341 }, { 135,  0,  480 }, {   6, 10,  254 },
  {   9, 10,  109 }, { 138, 10,  103 }, { 134,  0,  888 }, {   8, 11,  528 },
  { 137, 11,  348 }, {   7,  0, 1995 }, {   8,  0,  299 }, {  11,  0,  890 },
  {  12,  0,  674 }, {   4, 11,   20 }, { 133, 11,  616 }, { 135, 11, 1094 },
  { 134, 10, 1630 }, {   4,  0,  238 }, {   5,  0,  503 }, {   6,  0,  179 },
  {   7,  0, 2003 }, {   8,  0,  381 }, {   8,  0,  473 }, {   9,  0,  149 },
  {  10,  0,  788 }, {  15,  0,   45 }, {  15,  0,   86 }, {  20,  0,  110 },
  { 150,  0,   57 }, { 133, 10,  671 }, {   4, 11,   26 }, {   5, 11,  429 },
  {   6, 11,  245 }, {   7, 11,  704 }, {   7, 11, 1379 }, { 135, 11, 1474 },
  {   4,  0,  121 }, {   5,  0,  156 }, {   5,  0,  349 }, {   9,  0,  431 },
  {  10,  0,  605 }, { 142,  0,  342 }, {   7, 11,  943 }, { 139, 11,  614 },
  { 132, 10,  889 }, { 132, 11,  621 }, {   7, 10, 1382 }, {   7, 11, 1382 },
  { 135, 10, 1910 }, { 132, 10,  627 }, { 133, 10,  775 }, { 133, 11,  542 },
  { 133, 11,  868 }, { 136, 11,  433 }, {   6,  0, 1373 }, {   7,  0, 1011 },
  {  11, 10,  362 }, {  11, 10,  948 }, { 140, 10,  388 }, {   6,  0,   80 },
  {   7,  0,  173 }, {   9,  0,  547 }, {  10,  0,  730 }, {  14,  0,   18 },
  {  22,  0,   39 }, { 135, 11, 1495 }, {   6,  0, 1694 }, { 135,  0, 1974 },
  { 140,  0,  196 }, {   4,  0,  923 }, {   6,  0,  507 }, {   6,  0, 1711 },
  {   7, 10,  451 }, {   8, 10,  389 }, {  12, 10,  490 }, {  13, 10,   16 },
  {  13, 10,  215 }, {  13, 10,  351 }, {  18, 10,  132 }, { 147, 10,  125 },
  {   6,  0,  646 }, { 134,  0, 1047 }, { 135, 10,  841 }, { 136, 10,  566 },
  {   6,  0, 1611 }, { 135,  0, 1214 }, { 139,  0,  926 }, { 132, 11,  525 },
  { 132,  0,  595 }, {   5,  0,  240 }, {   6,  0,  459 }, {   7,  0,   12 },
  {   7,  0,  114 }, {   7,  0,  949 }, {   7,  0, 1753 }, {   7,  0, 1805 },
  {   8,  0,  658 }, {   9,  0,    1 }, {  11,  0,  959 }, { 141,  0,  446 },
  {   5, 10,  912 }, { 134, 10, 1695 }, { 132,  0,  446 }, {   7, 11,   62 },
  {  12, 11,   45 }, { 147, 11,  112 }, {   5, 10,  236 }, {   6, 10,  572 },
  {   8, 10,  492 }, {  11, 10,  618 }, { 144, 10,   56 }, {   5, 10,  190 },
  { 136, 10,  318 }, { 135, 10, 1376 }, {   4, 11,  223 }, {   6, 11,  359 },
  {  11, 11,    3 }, {  13, 11,  108 }, {  14, 11,   89 }, { 144, 11,   22 },
  { 132, 11,  647 }, { 134,  0,  490 }, { 134,  0,  491 }, { 134,  0, 1584 },
  { 135, 11,  685 }, { 138, 11,  220 }, {   7,  0,  250 }, { 136,  0,  507 },
  { 132,  0,  158 }, {   4,  0,  140 }, {   7,  0,  362 }, {   8,  0,  209 },
  {   9,  0,   10 }, {   9,  0,  160 }, {   9,  0,  503 }, {   9,  0,  614 },
  {  10,  0,  689 }, {  11,  0,  327 }, {  11,  0,  553 }, {  11,  0,  725 },
  {  11,  0,  767 }, {  12,  0,  252 }, {  12,  0,  583 }, {  13,  0,  192 },
  {  14,  0,  269 }, {  14,  0,  356 }, { 148,  0,   50 }, {  19,  0,    1 },
  {  19,  0,   26 }, { 150,  0,    9 }, { 132, 11,  109 }, {   6,  0,  228 },
  {   7,  0, 1341 }, {   9,  0,  408 }, { 138,  0,  343 }, {   4,  0,  373 },
  {   5,  0,  283 }, {   6,  0,  480 }, {   7,  0,  609 }, {  10,  0,  860 },
  { 138,  0,  878 }, {   6,  0,  779 }, { 134,  0, 1209 }, {   4,  0,  557 },
  {   7, 11,  263 }, {   7, 11,  628 }, { 136, 11,  349 }, { 132,  0,  548 },
  {   7,  0,  197 }, {   8,  0,  142 }, {   8,  0,  325 }, {   9,  0,  150 },
  {   9,  0,  596 }, {  10,  0,  350 }, {  10,  0,  353 }, {  11,  0,   74 },
  {  11,  0,  315 }, {  12,  0,  662 }, {  12,  0,  681 }, {  14,  0,  423 },
  { 143,  0,  141 }, {   4, 11,   40 }, {  10, 11,   67 }, {  11, 11,  117 },
  {  11, 11,  768 }, { 139, 11,  935 }, {   7, 11,  992 }, {   8, 11,  301 },
  {   9, 11,  722 }, {  12, 11,   63 }, {  13, 11,   29 }, {  14, 11,  161 },
  { 143, 11,   18 }, {   6,  0, 1490 }, { 138, 11,  532 }, {   5,  0,  580 },
  {   7,  0,  378 }, {   7,  0,  674 }, {   7,  0, 1424 }, {  15,  0,   83 },
  {  16,  0,   11 }, {  15, 11,   83 }, { 144, 11,   11 }, {   6,  0, 1057 },
  {   6,  0, 1335 }, {  10,  0,  316 }, {   7, 10,   85 }, {   7, 10,  247 },
  {   8, 10,  585 }, { 138, 10,  163 }, {   4,  0,  169 }, {   5,  0,   83 },
  {   6,  0,  399 }, {   6,  0,  579 }, {   6,  0, 1513 }, {   7,  0,  692 },
  {   7,  0,  846 }, {   7,  0, 1015 }, {   7,  0, 1799 }, {   8,  0,  403 },
  {   9,  0,  394 }, {  10,  0,  133 }, {  12,  0,    4 }, {  12,  0,  297 },
  {  12,  0,  452 }, {  16,  0,   81 }, {  18,  0,   25 }, {  21,  0,   14 },
  {  22,  0,   12 }, { 151,  0,   18 }, { 134,  0, 1106 }, {   7,  0, 1546 },
  {  11,  0,  299 }, { 142,  0,  407 }, { 134,  0, 1192 }, { 132,  0,  177 },
  {   5,  0,  411 }, { 135,  0,  653 }, {   7,  0,  439 }, {  10,  0,  727 },
  {  11,  0,  260 }, { 139,  0,  684 }, { 138, 10,  145 }, { 147, 10,   83 },
  {   5,  0,  208 }, {   7,  0,  753 }, { 135,  0, 1528 }, { 137, 11,  617 },
  { 135, 10, 1922 }, { 135, 11,  825 }, {  11,  0,  422 }, {  13,  0,  389 },
  {   4, 10,  124 }, {  10, 10,  457 }, {  11, 10,  121 }, {  11, 10,  169 },
  {  11, 10,  870 }, {  12, 10,  214 }, {  14, 10,  187 }, { 143, 10,   77 },
  {  11,  0,  615 }, {  15,  0,   58 }, {  11, 11,  615 }, { 143, 11,   58 },
  {   9,  0,  618 }, { 138,  0,  482 }, {   6,  0, 1952 }, {   6,  0, 1970 },
  { 142,  0,  505 }, {   7, 10, 1193 }, { 135, 11, 1838 }, { 133,  0,  242 },
  { 135, 10, 1333 }, {   6, 10,  107 }, {   7, 10,  638 }, {   7, 10, 1632 },
  { 137, 10,  396 }, { 133,  0,  953 }, {   5, 10,  370 }, { 134, 10, 1756 },
  {   5, 11,   28 }, {   6, 11,  204 }, {  10, 11,  320 }, {  10, 11,  583 },
  {  13, 11,  502 }, {  14, 11,   72 }, {  14, 11,  274 }, {  14, 11,  312 },
  {  14, 11,  344 }, {  15, 11,  159 }, {  16, 11,   62 }, {  16, 11,   69 },
  {  17, 11,   30 }, {  18, 11,   42 }, {  18, 11,   53 }, {  18, 11,   84 },
  {  18, 11,  140 }, {  19, 11,   68 }, {  19, 11,   85 }, {  20, 11,    5 },
  {  20, 11,   45 }, {  20, 11,  101 }, {  22, 11,    7 }, { 150, 11,   20 },
  {   4, 11,  558 }, {   6, 11,  390 }, {   7, 11,  162 }, {   7, 11,  689 },
  {   9, 11,  360 }, { 138, 11,  653 }, {  11,  0,  802 }, { 141,  0,   67 },
  { 133, 10,  204 }, { 133,  0,  290 }, {   5, 10,  970 }, { 134, 10, 1706 },
  { 132,  0,  380 }, {   5,  0,   52 }, {   7,  0,  277 }, {   9,  0,  368 },
  { 139,  0,  791 }, {   5, 11,  856 }, {   6, 11, 1672 }, {   6, 11, 1757 },
  {   6, 11, 1781 }, {   7, 11, 1150 }, {   7, 11, 1425 }, {   7, 11, 1453 },
  { 140, 11,  513 }, {   5, 11,   92 }, {   7, 10,    3 }, {  10, 11,  736 },
  { 140, 11,  102 }, {   4,  0,  112 }, {   5,  0,  653 }, {   5, 10,  483 },
  {   5, 10,  685 }, {   6, 10,  489 }, {   7, 10, 1204 }, { 136, 10,  394 },
  { 132, 10,  921 }, {   6,  0, 1028 }, { 133, 10, 1007 }, {   5, 11,  590 },
  {   9, 11,  213 }, { 145, 11,   91 }, { 135, 10, 1696 }, {  10,  0,  138 },
  { 139,  0,  476 }, {   5,  0,  725 }, {   5,  0,  727 }, { 135,  0, 1811 },
  {   4,  0,  979 }, {   6,  0, 1821 }, {   6,  0, 1838 }, {   8,  0,  876 },
  {   8,  0,  883 }, {   8,  0,  889 }, {   8,  0,  893 }, {   8,  0,  895 },
  {  10,  0,  934 }, {  12,  0,  720 }, {  14,  0,  459 }, { 148,  0,  123 },
  { 135, 11,  551 }, {   4,  0,   38 }, {   6,  0,  435 }, {   7,  0,  307 },
  {   7,  0,  999 }, {   7,  0, 1481 }, {   7,  0, 1732 }, {   7,  0, 1738 },
  {   8,  0,  371 }, {   9,  0,  414 }, {  11,  0,  316 }, {  12,  0,   52 },
  {  13,  0,  420 }, { 147,  0,  100 }, { 135,  0, 1296 }, { 132, 10,  712 },
  { 134, 10, 1629 }, { 133,  0,  723 }, { 134,  0,  651 }, { 136, 11,  191 },
  {   9, 11,  791 }, {  10, 11,   93 }, {  11, 11,  301 }, {  16, 11,   13 },
  {  17, 11,   23 }, {  18, 11,  135 }, {  19, 11,   12 }, {  20, 11,    1 },
  {  20, 11,   12 }, { 148, 11,   14 }, { 136, 11,  503 }, {   6, 11,  466 },
  { 135, 11,  671 }, {   6,  0, 1200 }, { 134,  0, 1330 }, { 135,  0, 1255 },
  { 134,  0,  986 }, {   5,  0,  109 }, {   6,  0, 1784 }, {   7,  0, 1895 },
  {  12,  0,  296 }, { 140,  0,  302 }, { 135, 11,  983 }, { 133, 10,  485 },
  { 134,  0,  660 }, { 134,  0,  800 }, {   5,  0,  216 }, {   5,  0,  294 },
  {   6,  0,  591 }, {   7,  0, 1879 }, {   9,  0,  141 }, {   9,  0,  270 },
  {   9,  0,  679 }, {  10,  0,  159 }, {  11,  0,  197 }, {  11,  0,  438 },
  {  12,  0,  538 }, {  12,  0,  559 }, {  14,  0,  144 }, {  14,  0,  167 },
  {  15,  0,   67 }, {   4, 10,  285 }, {   5, 10,  317 }, {   6, 10,  301 },
  {   7, 10,    7 }, {   8, 10,  153 }, {  10, 10,  766 }, {  11, 10,  468 },
  {  12, 10,  467 }, { 141, 10,  143 }, { 136,  0,  945 }, { 134,  0, 1090 },
  { 137,  0,   81 }, {  12, 11,  468 }, {  19, 11,   96 }, { 148, 11,   24 },
  { 134,  0,  391 }, { 138, 11,  241 }, {   7,  0,  322 }, { 136,  0,  249 },
  { 134,  0, 1412 }, { 135, 11,  795 }, {   5,  0,  632 }, { 138,  0,  526 },
  { 136, 10,  819 }, {   6,  0,  144 }, {   7,  0,  948 }, {   7,  0, 1042 },
  {   8,  0,  235 }, {   8,  0,  461 }, {   9,  0,  453 }, {   9,  0,  796 },
  {  10,  0,  354 }, {  17,  0,   77 }, { 135, 11,  954 }, { 139, 10,  917 },
  {   6,  0,  940 }, { 134,  0, 1228 }, {   4,  0,  362 }, {   7,  0,   52 },
  { 135,  0,  303 }, {   6, 11,  549 }, {   8, 11,   34 }, {   8, 11,  283 },
  {   9, 11,  165 }, { 138, 11,  475 }, {   7, 11,  370 }, {   7, 11, 1007 },
  {   7, 11, 1177 }, { 135, 11, 1565 }, {   5, 11,  652 }, {   5, 11,  701 },
  { 135, 11,  449 }, {   5,  0,  196 }, {   6,  0,  486 }, {   7,  0,  212 },
  {   8,  0,  309 }, { 136,  0,  346 }, {   6, 10, 1719 }, {   6, 10, 1735 },
  {   7, 10, 2016 }, {   7, 10, 2020 }, {   8, 10,  837 }, { 137, 10,  852 },
  {   6, 11,  159 }, {   6, 11,  364 }, {   7, 11,  516 }, {   7, 11, 1439 },
  { 137, 11,  518 }, { 135,  0, 1912 }, { 135,  0, 1290 }, { 132,  0,  686 },
  { 141, 11,  151 }, { 138,  0,  625 }, { 136,  0,  706 }, { 138, 10,  568 },
  { 139,  0,  412 }, {   4,  0,   30 }, { 133,  0,   43 }, {   8, 10,   67 },
  { 138, 10,  419 }, {   7,  0,  967 }, { 141,  0,   11 }, {  12,  0,  758 },
  {  14,  0,  441 }, { 142,  0,  462 }, {  10, 10,  657 }, {  14, 10,  297 },
  { 142, 10,  361 }, { 139, 10,  729 }, {   4,  0,  220 }, { 135,  0, 1535 },
  {   7, 11,  501 }, {   9, 11,  111 }, {  10, 11,  141 }, {  11, 11,  332 },
  {  13, 11,   43 }, {  13, 11,  429 }, {  14, 11,  130 }, {  14, 11,  415 },
  { 145, 11,  102 }, {   4,  0,  950 }, {   6,  0, 1859 }, {   7,  0,   11 },
  {   8,  0,  873 }, {  12,  0,  710 }, {  12,  0,  718 }, {  12,  0,  748 },
  {  12,  0,  765 }, { 148,  0,  124 }, {   5, 11,  149 }, {   5, 11,  935 },
  { 136, 11,  233 }, { 142, 11,  291 }, { 134,  0, 1579 }, {   7,  0,  890 },
  {   8, 10,   51 }, {   9, 10,  868 }, {  10, 10,  833 }, {  12, 10,  481 },
  {  12, 10,  570 }, { 148, 10,  106 }, { 141,  0,    2 }, { 132, 10,  445 },
  { 136, 11,  801 }, { 135,  0, 1774 }, {   7,  0, 1725 }, { 138,  0,  393 },
  {   5,  0,  263 }, { 134,  0,  414 }, { 132, 11,  322 }, { 133, 10,  239 },
  {   7,  0,  456 }, {   7, 10, 1990 }, {   8, 10,  130 }, { 139, 10,  720 },
  { 137,  0,  818 }, {   5, 10,  123 }, {   6, 10,  530 }, {   7, 10,  348 },
  { 135, 10, 1419 }, { 135, 10, 2024 }, {   6,  0,  178 }, {   6,  0, 1750 },
  {   8,  0,  251 }, {   9,  0,  690 }, {  10,  0,  155 }, {  10,  0,  196 },
  {  10,  0,  373 }, {  11,  0,  698 }, {  13,  0,  155 }, { 148,  0,   93 },
  {   5,  0,   97 }, { 137,  0,  393 }, { 134,  0,  674 }, {  11,  0,  223 },
  { 140,  0,  168 }, { 132, 10,  210 }, { 139, 11,  464 }, {   6,  0, 1639 },
  { 146,  0,  159 }, { 139, 11,    2 }, {   7,  0,  934 }, {   8,  0,  647 },
  {  17,  0,   97 }, {  19,  0,   59 }, { 150,  0,    2 }, { 132,  0,  191 },
  {   5,  0,  165 }, {   9,  0,  346 }, {  10,  0,  655 }, {  11,  0,  885 },
  {   4, 10,  430 }, { 135, 11,  357 }, { 133,  0,  877 }, {   5, 10,  213 },
  { 133, 11,  406 }, {   8,  0,  128 }, { 139,  0,  179 }, {   6, 11,   69 },
  { 135, 11,  117 }, { 135,  0, 1297 }, {  11, 11,   43 }, {  13, 11,   72 },
  { 141, 11,  142 }, { 135, 11, 1830 }, { 142,  0,  164 }, {   5,  0,   57 },
  {   6,  0,  101 }, {   6,  0,  586 }, {   6,  0, 1663 }, {   7,  0,  132 },
  {   7,  0, 1154 }, {   7,  0, 1415 }, {   7,  0, 1507 }, {  12,  0,  493 },
  {  15,  0,  105 }, { 151,  0,   15 }, {   5,  0,  459 }, {   7,  0, 1073 },
  {   8,  0,  241 }, { 136,  0,  334 }, { 133, 11,  826 }, { 133, 10,  108 },
  {   5, 10,  219 }, {  10, 11,  132 }, {  11, 11,  191 }, {  11, 11,  358 },
  { 139, 11,  460 }, {   6,  0,  324 }, {   6,  0,  520 }, {   7,  0,  338 },
  {   7,  0, 1729 }, {   8,  0,  228 }, { 139,  0,  750 }, {  21,  0,   30 },
  {  22,  0,   53 }, {   4, 10,  193 }, {   5, 10,  916 }, {   7, 10,  364 },
  {  10, 10,  398 }, {  10, 10,  726 }, {  11, 10,  317 }, {  11, 10,  626 },
  {  12, 10,  142 }, {  12, 10,  288 }, {  12, 10,  678 }, {  13, 10,  313 },
  {  15, 10,  113 }, { 146, 10,  114 }, {   6, 11,  110 }, { 135, 11, 1681 },
  { 135,  0,  910 }, {   6, 10,  241 }, {   7, 10,  907 }, {   8, 10,  832 },
  {   9, 10,  342 }, {  10, 10,  729 }, {  11, 10,  284 }, {  11, 10,  445 },
  {  11, 10,  651 }, {  11, 10,  863 }, {  13, 10,  398 }, { 146, 10,   99 },
  {   7,  0,  705 }, {   9,  0,  734 }, {   5, 11, 1000 }, {   7, 11,  733 },
  { 137, 11,  583 }, {   4,  0,   73 }, {   6,  0,  612 }, {   7,  0,  927 },
  {   7,  0, 1822 }, {   8,  0,  217 }, {   9,  0,  765 }, {   9,  0,  766 },
  {  10,  0,  408 }, {  11,  0,   51 }, {  11,  0,  793 }, {  12,  0,  266 },
  {  15,  0,  158 }, {  20,  0,   89 }, { 150,  0,   32 }, {   7,  0, 1330 },
  {   4, 11,  297 }, {   6, 11,  529 }, {   7, 11,  152 }, {   7, 11,  713 },
  {   7, 11, 1845 }, {   8, 11,  710 }, {   8, 11,  717 }, { 140, 11,  639 },
  {   5,  0,  389 }, { 136,  0,  636 }, { 134,  0, 1409 }, {   4, 10,  562 },
  {   9, 10,  254 }, { 139, 10,  879 }, { 134,  0,  893 }, { 132, 10,  786 },
  {   4, 11,  520 }, { 135, 11,  575 }, { 136,  0,   21 }, { 140,  0,  721 },
  { 136,  0,  959 }, {   7, 11, 1428 }, {   7, 11, 1640 }, {   9, 11,  169 },
  {   9, 11,  182 }, {   9, 11,  367 }, {   9, 11,  478 }, {   9, 11,  506 },
  {   9, 11,  551 }, {   9, 11,  648 }, {   9, 11,  651 }, {   9, 11,  697 },
  {   9, 11,  705 }, {   9, 11,  725 }, {   9, 11,  787 }, {   9, 11,  794 },
  {  10, 11,  198 }, {  10, 11,  214 }, {  10, 11,  267 }, {  10, 11,  275 },
  {  10, 11,  456 }, {  10, 11,  551 }, {  10, 11,  561 }, {  10, 11,  613 },
  {  10, 11,  627 }, {  10, 11,  668 }, {  10, 11,  675 }, {  10, 11,  691 },
  {  10, 11,  695 }, {  10, 11,  707 }, {  10, 11,  715 }, {  11, 11,  183 },
  {  11, 11,  201 }, {  11, 11,  244 }, {  11, 11,  262 }, {  11, 11,  352 },
  {  11, 11,  439 }, {  11, 11,  493 }, {  11, 11,  572 }, {  11, 11,  591 },
  {  11, 11,  608 }, {  11, 11,  611 }, {  11, 11,  646 }, {  11, 11,  674 },
  {  11, 11,  711 }, {  11, 11,  751 }, {  11, 11,  761 }, {  11, 11,  776 },
  {  11, 11,  785 }, {  11, 11,  850 }, {  11, 11,  853 }, {  11, 11,  862 },
  {  11, 11,  865 }, {  11, 11,  868 }, {  11, 11,  898 }, {  11, 11,  902 },
  {  11, 11,  903 }, {  11, 11,  910 }, {  11, 11,  932 }, {  11, 11,  942 },
  {  11, 11,  957 }, {  11, 11,  967 }, {  11, 11,  972 }, {  12, 11,  148 },
  {  12, 11,  195 }, {  12, 11,  220 }, {  12, 11,  237 }, {  12, 11,  318 },
  {  12, 11,  339 }, {  12, 11,  393 }, {  12, 11,  445 }, {  12, 11,  450 },
  {  12, 11,  474 }, {  12, 11,  509 }, {  12, 11,  533 }, {  12, 11,  591 },
  {  12, 11,  594 }, {  12, 11,  597 }, {  12, 11,  621 }, {  12, 11,  633 },
  {  12, 11,  642 }, {  13, 11,   59 }, {  13, 11,   60 }, {  13, 11,  145 },
  {  13, 11,  239 }, {  13, 11,  250 }, {  13, 11,  273 }, {  13, 11,  329 },
  {  13, 11,  344 }, {  13, 11,  365 }, {  13, 11,  372 }, {  13, 11,  387 },
  {  13, 11,  403 }, {  13, 11,  414 }, {  13, 11,  456 }, {  13, 11,  478 },
  {  13, 11,  483 }, {  13, 11,  489 }, {  14, 11,   55 }, {  14, 11,   57 },
  {  14, 11,   81 }, {  14, 11,   90 }, {  14, 11,  148 }, {  14, 11,  239 },
  {  14, 11,  266 }, {  14, 11,  321 }, {  14, 11,  326 }, {  14, 11,  327 },
  {  14, 11,  330 }, {  14, 11,  347 }, {  14, 11,  355 }, {  14, 11,  401 },
  {  14, 11,  411 }, {  14, 11,  414 }, {  14, 11,  416 }, {  14, 11,  420 },
  {  15, 11,   61 }, {  15, 11,   74 }, {  15, 11,   87 }, {  15, 11,   88 },
  {  15, 11,   94 }, {  15, 11,   96 }, {  15, 11,  116 }, {  15, 11,  149 },
  {  15, 11,  154 }, {  16, 11,   50 }, {  16, 11,   63 }, {  16, 11,   73 },
  {  17, 11,    2 }, {  17, 11,   66 }, {  17, 11,   92 }, {  17, 11,  103 },
  {  17, 11,  112 }, {  18, 11,   50 }, {  18, 11,   54 }, {  18, 11,   82 },
  {  18, 11,   86 }, {  18, 11,   90 }, {  18, 11,  111 }, {  18, 11,  115 },
  {  18, 11,  156 }, {  19, 11,   40 }, {  19, 11,   79 }, {  20, 11,   78 },
  { 149, 11,   22 }, { 137, 11,  170 }, { 134,  0, 1433 }, { 135, 11, 1307 },
  { 139, 11,  411 }, {   5,  0,  189 }, {   7,  0,  442 }, {   7,  0,  443 },
  {   8,  0,  281 }, {  12,  0,  174 }, { 141,  0,  261 }, {   6, 10,  216 },
  {   7, 10,  901 }, {   7, 10, 1343 }, { 136, 10,  493 }, {   5, 11,  397 },
  {   6, 11,  154 }, {   7, 10,  341 }, {   7, 11,  676 }, {   8, 11,  443 },
  {   8, 11,  609 }, {   9, 11,   24 }, {   9, 11,  325 }, {  10, 11,   35 },
  {  11, 10,  219 }, {  11, 11,  535 }, {  11, 11,  672 }, {  11, 11, 1018 },
  {  12, 11,  637 }, { 144, 11,   30 }, {   6,  0,    2 }, {   7,  0,  191 },
  {   7,  0,  446 }, {   7,  0, 1262 }, {   7,  0, 1737 }, {   8,  0,   22 },
  {   8,  0,  270 }, {   8,  0,  612 }, {   9,  0,    4 }, {   9,  0,  312 },
  {   9,  0,  436 }, {   9,  0,  626 }, {  10,  0,  216 }, {  10,  0,  311 },
  {  10,  0,  521 }, {  10,  0,  623 }, {  11,  0,   72 }, {  11,  0,  330 },
  {  11,  0,  455 }, {  12,  0,  321 }, {  12,  0,  504 }, {  12,  0,  530 },
  {  12,  0,  543 }, {  13,  0,   17 }, {  13,  0,  156 }, {  13,  0,  334 },
  {  14,  0,  131 }, {  17,  0,   60 }, { 148,  0,   64 }, {   7,  0,  354 },
  {  10,  0,  410 }, { 139,  0,  815 }, { 139, 10,  130 }, {   7, 10, 1734 },
  { 137, 11,  631 }, {  12,  0,  425 }, {  15,  0,  112 }, {  10, 10,  115 },
  {  11, 10,  420 }, {  13, 10,  404 }, {  14, 10,  346 }, { 143, 10,   54 },
  {   6,  0,   60 }, {   6,  0,  166 }, {   7,  0,  374 }, {   7,  0,  670 },
  {   7,  0, 1327 }, {   8,  0,  411 }, {   8,  0,  435 }, {   9,  0,  653 },
  {   9,  0,  740 }, {  10,  0,  385 }, {  11,  0,  222 }, {  11,  0,  324 },
  {  11,  0,  829 }, { 140,  0,  611 }, {   7,  0, 1611 }, {  13,  0,   14 },
  {  15,  0,   44 }, {  19,  0,   13 }, { 148,  0,   76 }, { 133, 11,  981 },
  {   4, 11,   56 }, {   7, 11, 1791 }, {   8, 11,  607 }, {   8, 11,  651 },
  {  11, 11,  465 }, {  11, 11,  835 }, {  12, 11,  337 }, { 141, 11,  480 },
  {   6,  0, 1478 }, {   5, 10, 1011 }, { 136, 10,  701 }, { 139,  0,  596 },
  {   5,  0,  206 }, { 134,  0,  398 }, {   4, 10,   54 }, {   5, 10,  666 },
  {   7, 10, 1039 }, {   7, 10, 1130 }, {   9, 10,  195 }, { 138, 10,  302 },
  {   7,  0,   50 }, {   9, 11,  158 }, { 138, 11,  411 }, { 135, 11, 1120 },
  {   6,  0,  517 }, {   7,  0, 1159 }, {  10,  0,  621 }, {  11,  0,  192 },
  { 134, 10, 1669 }, {   4,  0,  592 }, {   6,  0,  600 }, { 135,  0, 1653 },
  {  10,  0,  223 }, { 139,  0,  645 }, { 136, 11,  139 }, {   7,  0,   64 },
  { 136,  0,  245 }, { 142,  0,  278 }, {   6, 11,  622 }, { 135, 11, 1030 },
  { 136,  0,  604 }, { 134,  0, 1502 }, { 138,  0,  265 }, { 141, 11,  168 },
  {   7,  0, 1763 }, { 140,  0,  310 }, {   7, 10,  798 }, { 139, 11,  719 },
  {   7, 11,  160 }, {  10, 11,  624 }, { 142, 11,  279 }, { 132, 11,  363 },
  {   7, 10,  122 }, {   9, 10,  259 }, {  10, 10,   84 }, {  11, 10,  470 },
  {  12, 10,  541 }, { 141, 10,  379 }, {   5,  0,  129 }, {   6,  0,   61 },
  { 135,  0,  947 }, { 134,  0, 1356 }, { 135, 11, 1191 }, {  13,  0,  505 },
  { 141,  0,  506 }, {  11,  0, 1000 }, {   5, 10,   82 }, {   5, 10,  131 },
  {   7, 10, 1755 }, {   8, 10,   31 }, {   9, 10,  168 }, {   9, 10,  764 },
  { 139, 10,  869 }, { 134,  0,  966 }, { 134, 10,  605 }, { 134, 11,  292 },
  {   5, 11,  177 }, {   6, 11,  616 }, {   7, 11,  827 }, {   9, 11,  525 },
  { 138, 11,  656 }, { 135, 11, 1486 }, { 138, 11,   31 }, {   5, 10,  278 },
  { 137, 10,   68 }, {   4, 10,  163 }, {   5, 10,  201 }, {   5, 10,  307 },
  {   5, 10,  310 }, {   6, 10,  335 }, {   7, 10,  284 }, { 136, 10,  165 },
  {   6,  0,  839 }, { 135, 10, 1660 }, { 136, 10,  781 }, {   6, 10,   33 },
  { 135, 10, 1244 }, { 133,  0,  637 }, {   4, 11,  161 }, { 133, 11,  631 },
  { 137,  0,  590 }, {   7, 10, 1953 }, { 136, 10,  720 }, {   5,  0,  280 },
  {   7,  0, 1226 }, { 138, 10,  203 }, { 134,  0, 1386 }, {   5,  0,  281 },
  {   6,  0, 1026 }, {   6, 10,  326 }, {   7, 10,  677 }, { 137, 10,  425 },
  {   7, 11, 1557 }, { 135, 11, 1684 }, { 135,  0, 1064 }, {   9, 11,  469 },
  {   9, 11,  709 }, {  12, 11,  512 }, {  14, 11,   65 }, { 145, 11,   12 },
  { 134,  0,  917 }, {  10, 11,  229 }, {  11, 11,   73 }, {  11, 11,  376 },
  { 139, 11,  433 }, {   7,  0,  555 }, {   9,  0,  192 }, {  13,  0,   30 },
  {  13,  0,   49 }, {  15,  0,  150 }, {  16,  0,   76 }, {  20,  0,   52 },
  {   7, 10, 1316 }, {   7, 10, 1412 }, {   7, 10, 1839 }, {   9, 10,  589 },
  {  11, 10,  241 }, {  11, 10,  676 }, {  11, 10,  811 }, {  11, 10,  891 },
  {  12, 10,  140 }, {  12, 10,  346 }, {  12, 10,  479 }, {  13, 10,  381 },
  {  14, 10,  188 }, { 146, 10,   30 }, { 149,  0,   15 }, {   6,  0, 1882 },
  {   6,  0, 1883 }, {   6,  0, 1897 }, {   9,  0,  945 }, {   9,  0, 1014 },
  {   9,  0, 1020 }, {  12,  0,  823 }, {  12,  0,  842 }, {  12,  0,  866 },
  {  12,  0,  934 }, {  15,  0,  242 }, { 146,  0,  208 }, {   6,  0,  965 },
  { 134,  0, 1499 }, {   7,  0,   33 }, {   7,  0,  120 }, {   8,  0,  489 },
  {   9,  0,  319 }, {  10,  0,  820 }, {  11,  0, 1004 }, {  12,  0,  379 },
  {  12,  0,  679 }, {  13,  0,  117 }, {  13,  0,  412 }, {  14,  0,   25 },
  {  15,  0,   52 }, {  15,  0,  161 }, {  16,  0,   47 }, { 149,  0,    2 },
  {   6, 11,  558 }, {   7, 11,  651 }, {   8, 11,  421 }, {   9, 11,    0 },
  { 138, 11,   34 }, {   4,  0,  937 }, {   5,  0,  801 }, {   7,  0,  473 },
  {   5, 10,  358 }, {   7, 10, 1184 }, {  10, 10,  662 }, {  13, 10,  212 },
  {  13, 10,  304 }, {  13, 10,  333 }, { 145, 10,   98 }, { 132,  0,  877 },
  {   6,  0,  693 }, { 134,  0,  824 }, { 132,  0,  365 }, {   7, 11, 1832 },
  { 138, 11,  374 }, {   5,  0,    7 }, { 139,  0,  774 }, {   4,  0,  734 },
  {   5,  0,  662 }, { 134,  0,  430 }, {   4,  0,  746 }, { 135,  0, 1090 },
  {   5,  0,  360 }, {   8,  0,  237 }, {  10,  0,  231 }, { 147,  0,  124 },
  { 138, 11,  348 }, {   6, 11,    6 }, {   7, 11,   81 }, {   7, 11,  771 },
  {   7, 11, 1731 }, {   9, 11,  405 }, { 138, 11,  421 }, {   6,  0,  740 },
  { 137,  0,  822 }, { 133, 10,  946 }, {   7,  0, 1485 }, { 136,  0,  929 },
  {   7, 10,  411 }, {   8, 10,  631 }, {   9, 10,  323 }, {  10, 10,  355 },
  {  11, 10,  491 }, {  12, 10,  143 }, {  12, 10,  402 }, {  13, 10,   73 },
  {  14, 10,  408 }, {  15, 10,  107 }, { 146, 10,   71 }, { 135, 10,  590 },
  {   5, 11,  881 }, { 133, 11,  885 }, { 150, 11,   25 }, {   4,  0,  852 },
  {   5, 11,  142 }, { 134, 11,  546 }, {   7, 10, 1467 }, {   8, 10,  328 },
  {  10, 10,  544 }, {  11, 10,  955 }, {  13, 10,  320 }, { 145, 10,   83 },
  {   9,  0,   17 }, {  10,  0,  291 }, {  11, 10,  511 }, {  13, 10,  394 },
  {  14, 10,  298 }, {  14, 10,  318 }, { 146, 10,  103 }, {   5, 11,  466 },
  {  11, 11,  571 }, {  12, 11,  198 }, {  13, 11,  283 }, {  14, 11,  186 },
  {  15, 11,   21 }, { 143, 11,  103 }, { 134,  0, 1001 }, {   4, 11,  185 },
  {   5, 11,  257 }, {   5, 11,  839 }, {   5, 11,  936 }, {   7, 11,  171 },
  {   9, 11,  399 }, {  10, 11,  258 }, {  10, 11,  395 }, {  10, 11,  734 },
  {  11, 11, 1014 }, {  12, 11,   23 }, {  13, 11,  350 }, {  14, 11,  150 },
  { 147, 11,    6 }, { 143,  0,   35 }, { 132,  0,  831 }, {   5, 10,  835 },
  { 134, 10,  483 }, {   4,  0,  277 }, {   5,  0,  608 }, {   6,  0,  493 },
  {   7,  0,  457 }, {  12,  0,  384 }, {   7, 11,  404 }, {   7, 11, 1377 },
  {   7, 11, 1430 }, {   7, 11, 2017 }, {   8, 11,  149 }, {   8, 11,  239 },
  {   8, 11,  512 }, {   8, 11,  793 }, {   8, 11,  818 }, {   9, 11,  474 },
  {   9, 11,  595 }, {  10, 11,  122 }, {  10, 11,  565 }, {  10, 11,  649 },
  {  10, 11,  783 }, {  11, 11,  239 }, {  11, 11,  295 }, {  11, 11,  447 },
  {  11, 11,  528 }, {  11, 11,  639 }, {  11, 11,  800 }, {  11, 11,  936 },
  {  12, 11,   25 }, {  12, 11,   73 }, {  12, 11,   77 }, {  12, 11,  157 },
  {  12, 11,  316 }, {  12, 11,  390 }, {  12, 11,  391 }, {  12, 11,  394 },
  {  12, 11,  395 }, {  12, 11,  478 }, {  12, 11,  503 }, {  12, 11,  592 },
  {  12, 11,  680 }, {  13, 11,   50 }, {  13, 11,   53 }, {  13, 11,  132 },
  {  13, 11,  198 }, {  13, 11,  275 }, {  13, 11,  322 }, {  13, 11,  415 },
  {  14, 11,   71 }, {  14, 11,  257 }, {  14, 11,  395 }, {  15, 11,   71 },
  {  15, 11,  136 }, {  17, 11,  123 }, {  18, 11,   93 }, { 147, 11,   58 },
  { 134,  0, 1351 }, {   7,  0,   27 }, { 135,  0,  316 }, { 136, 11,  712 },
  { 136,  0,  984 }, { 133,  0,  552 }, { 137,  0,  264 }, { 132,  0,  401 },
  {   6,  0,  710 }, {   6,  0, 1111 }, { 134,  0, 1343 }, { 134,  0, 1211 },
  {   9,  0,  543 }, {  10,  0,  524 }, {  11,  0,  108 }, {  11,  0,  653 },
  {  12,  0,  524 }, {  13,  0,  123 }, {  14,  0,  252 }, {  16,  0,   18 },
  {  19,  0,   38 }, {  20,  0,   26 }, {  20,  0,   65 }, {  21,  0,    3 },
  { 151,  0,   11 }, {   4,  0,  205 }, {   5,  0,  623 }, {   7,  0,  104 },
  {   8,  0,  519 }, { 137,  0,  716 }, { 132, 10,  677 }, {   4, 11,  377 },
  { 152, 11,   13 }, { 135, 11, 1673 }, {   7,  0,  579 }, {   9,  0,   41 },
  {   9,  0,  244 }, {   9,  0,  669 }, {  10,  0,    5 }, {  11,  0,  861 },
  {  11,  0,  951 }, { 139,  0,  980 }, { 132,  0,  717 }, { 136,  0, 1011 },
  { 132,  0,  805 }, {   4, 11,  180 }, { 135, 11, 1906 }, { 132, 10,  777 },
  { 132, 10,  331 }, { 132,  0,  489 }, {   6,  0, 1024 }, {   4, 11,  491 },
  { 133, 10,  747 }, { 135, 11, 1182 }, {   4, 11,  171 }, { 138, 11,  234 },
  {   4, 11,  586 }, {   7, 11, 1186 }, { 138, 11,  631 }, { 135,  0,  892 },
  { 135, 11,  336 }, {   9, 11,  931 }, {  10, 11,  334 }, { 148, 11,   71 },
  { 137,  0,  473 }, {   6,  0,  864 }, {  12,  0,  659 }, { 139, 11,  926 },
  {   7,  0,  819 }, {   9,  0,   26 }, {   9,  0,  392 }, {  10,  0,  152 },
  {  10,  0,  226 }, {  11,  0,   19 }, {  12,  0,  276 }, {  12,  0,  426 },
  {  12,  0,  589 }, {  13,  0,  460 }, {  15,  0,   97 }, {  19,  0,   48 },
  { 148,  0,  104 }, { 135,  0,   51 }, { 133, 10,  326 }, {   4, 10,  691 },
  { 146, 10,   16 }, {   9,  0,  130 }, {  11,  0,  765 }, {  10, 10,  680 },
  {  10, 10,  793 }, { 141, 10,  357 }, { 133, 11,  765 }, {   8,  0,  229 },
  {   6, 10,   32 }, {   7, 10,  385 }, {   7, 10,  757 }, {   7, 10, 1916 },
  {   8, 10,   94 }, {   8, 10,  711 }, {   9, 10,  541 }, {  10, 10,  162 },
  {  10, 10,  795 }, {  11, 10,  989 }, {  11, 10, 1010 }, {  12, 10,   14 },
  { 142, 10,  308 }, {   7, 11,  474 }, { 137, 11,  578 }, { 132,  0,  674 },
  { 132,  0,  770 }, {   5,  0,   79 }, {   7,  0, 1027 }, {   7,  0, 1477 },
  { 139,  0,   52 }, { 133, 11,  424 }, { 134,  0, 1666 }, {   6,  0,  409 },
  {   6, 10,  349 }, {   6, 10, 1682 }, {   7, 10, 1252 }, {   8, 10,  112 },
  {   8, 11,  714 }, {   9, 10,  435 }, {   9, 10,  668 }, {  10, 10,  290 },
  {  10, 10,  319 }, {  10, 10,  815 }, {  11, 10,  180 }, {  11, 10,  837 },
  {  12, 10,  240 }, {  13, 10,  152 }, {  13, 10,  219 }, { 142, 10,  158 },
  {   5,  0,  789 }, { 134,  0,  195 }, {   4,  0,  251 }, {   4,  0,  688 },
  {   7,  0,  513 }, { 135,  0, 1284 }, { 132, 10,  581 }, {   9, 11,  420 },
  {  10, 11,  269 }, {  10, 11,  285 }, {  10, 11,  576 }, {  11, 11,  397 },
  {  13, 11,  175 }, { 145, 11,   90 }, {   6, 10,  126 }, {   7, 10,  573 },
  {   8, 10,  397 }, { 142, 10,   44 }, { 132, 11,  429 }, { 133,  0,  889 },
  {   4,  0,  160 }, {   5,  0,  330 }, {   7,  0, 1434 }, { 136,  0,  174 },
  {   7, 11,   18 }, {   7, 11,  699 }, {   7, 11, 1966 }, {   8, 11,  752 },
  {   9, 11,  273 }, {   9, 11,  412 }, {   9, 11,  703 }, {  10, 11,   71 },
  {  10, 11,  427 }, {  10, 11,  508 }, { 146, 11,   97 }, {   6,  0,  872 },
  { 134,  0,  899 }, { 133, 10,  926 }, { 134,  0, 1126 }, { 134,  0,  918 },
  {   4, 11,   53 }, {   5, 11,  186 }, { 135, 11,  752 }, {   7,  0,  268 },
  { 136,  0,  569 }, { 134,  0, 1224 }, {   6,  0, 1361 }, {   7, 10, 1232 },
  { 137, 10,  531 }, {   8, 11,  575 }, {  10, 11,  289 }, { 139, 11,  319 },
  { 133, 10,  670 }, { 132, 11,  675 }, { 133,  0,  374 }, { 135, 10, 1957 },
  { 133,  0,  731 }, {  11,  0,  190 }, {  15,  0,   49 }, {  11, 11,  190 },
  { 143, 11,   49 }, {   4,  0,  626 }, {   5,  0,  506 }, {   5,  0,  642 },
  {   6,  0,  425 }, {  10,  0,  202 }, { 139,  0,  141 }, { 137,  0,  444 },
  {   7, 10,  242 }, { 135, 10, 1942 }, {   6, 11,  209 }, {   8, 11,  468 },
  {   9, 11,  210 }, {  11, 11,   36 }, {  12, 11,   28 }, {  12, 11,  630 },
  {  13, 11,   21 }, {  13, 11,  349 }, {  14, 11,    7 }, { 145, 11,   13 },
  {   4, 11,  342 }, { 135, 11, 1179 }, {   5, 10,  834 }, {   7, 10, 1202 },
  {   8, 10,   14 }, {   9, 10,  481 }, { 137, 10,  880 }, {   4, 11,  928 },
  { 133, 11,  910 }, {   4, 11,  318 }, {   4, 11,  496 }, {   7, 11,  856 },
  { 139, 11,  654 }, { 136,  0,  835 }, {   7,  0, 1526 }, { 138, 10,  465 },
  { 151,  0,   17 }, { 135,  0,  477 }, {   4, 10,  357 }, {   6, 10,  172 },
  {   7, 10,  143 }, { 137, 10,  413 }, {   6,  0, 1374 }, { 138,  0,  994 },
  {  18,  0,   76 }, { 132, 10,  590 }, {   7,  0,  287 }, {   8,  0,  355 },
  {   9,  0,  293 }, { 137,  0,  743 }, { 134,  0, 1389 }, {   7, 11,  915 },
  {   8, 11,  247 }, { 147, 11,    0 }, {   4, 11,  202 }, {   5, 11,  382 },
  {   6, 11,  454 }, {   7, 11,  936 }, {   7, 11, 1803 }, {   8, 11,  758 },
  {   9, 11,  375 }, {   9, 11,  895 }, {  10, 11,  743 }, {  10, 11,  792 },
  {  11, 11,  978 }, {  11, 11, 1012 }, { 142, 11,  109 }, {   5,  0,  384 },
  {   8,  0,  455 }, { 140,  0,   48 }, { 132, 11,  390 }, {   5, 10,  169 },
  {   7, 10,  333 }, { 136, 10,   45 }, {   5,  0,  264 }, { 134,  0,  184 },
  { 138, 11,  791 }, { 133, 11,  717 }, { 132, 10,  198 }, {   6, 11,  445 },
  {   7, 11,  332 }, { 137, 11,  909 }, { 136,  0, 1001 }, {   4, 10,   24 },
  {   5, 10,  140 }, {   5, 10,  185 }, {   7, 10, 1500 }, {  11, 10,  565 },
  { 139, 10,  838 }, { 134, 11,  578 }, {   5,  0,  633 }, {   6,  0,   28 },
  { 135,  0, 1323 }, { 132,  0,  851 }, { 136, 11,  267 }, {   7,  0,  359 },
  {   8,  0,  243 }, { 140,  0,  175 }, {   4, 10,  334 }, { 133, 10,  593 },
  { 141, 11,   87 }, { 136, 11,  766 }, {  10,  0,  287 }, {  12,  0,  138 },
  {  10, 11,  287 }, { 140, 11,  138 }, {   4,  0,  105 }, { 132,  0,  740 },
  { 140, 10,  116 }, { 134,  0,  857 }, { 135, 11, 1841 }, {   6,  0, 1402 },
  { 137,  0,  819 }, { 132, 11,  584 }, { 132, 10,  709 }, { 133, 10,  897 },
  {   5,  0,  224 }, {  13,  0,  174 }, { 146,  0,   52 }, { 135, 10, 1840 },
  {   4, 10,  608 }, { 133, 10,  497 }, { 139, 11,   60 }, {   4,  0,  758 },
  { 135,  0, 1649 }, {   4, 11,  226 }, {   4, 11,  326 }, { 135, 11, 1770 },
  {   5, 11,  426 }, {   8, 11,   30 }, {   9, 11,    2 }, {  11, 11,  549 },
  { 147, 11,  122 }, { 135, 10, 2039 }, {   6, 10,  540 }, { 136, 10,  136 },
  {   4,  0,  573 }, {   8,  0,  655 }, {   4, 10,  897 }, { 133, 10,  786 },
  {   7,  0,  351 }, { 139,  0,  128 }, { 133, 10,  999 }, {   4, 10,  299 },
  { 135, 10, 1004 }, { 133,  0,  918 }, { 132, 11,  345 }, {   4, 11,  385 },
  {   7, 11,  265 }, { 135, 11,  587 }, { 133, 10,  456 }, { 136, 10,  180 },
  {   6,  0,  687 }, { 134,  0, 1537 }, {   4, 11,  347 }, {   5, 11,  423 },
  {   5, 11,  996 }, { 135, 11, 1329 }, { 132, 10,  755 }, {   7, 11, 1259 },
  {   9, 11,  125 }, {  11, 11,   65 }, { 140, 11,  285 }, {   5, 11,  136 },
  {   6, 11,  136 }, { 136, 11,  644 }, { 134,  0, 1525 }, {   4,  0, 1009 },
  { 135,  0, 1139 }, { 139, 10,  338 }, { 132,  0,  340 }, { 135, 10, 1464 },
  {   8,  0,  847 }, {  10,  0,  861 }, {  10,  0,  876 }, {  10,  0,  889 },
  {  10,  0,  922 }, {  10,  0,  929 }, {  10,  0,  933 }, {  12,  0,  784 },
  { 140,  0,  791 }, { 139,  0,  176 }, {   9, 11,  134 }, {  10, 11,    2 },
  {  10, 11,   27 }, {  10, 11,  333 }, {  11, 11,  722 }, { 143, 11,    1 },
  {   4, 11,  433 }, { 133, 11,  719 }, {   5,  0,  985 }, {   7,  0,  509 },
  {   7,  0,  529 }, { 145,  0,   96 }, { 132,  0,  615 }, {   4, 10,  890 },
  {   5, 10,  805 }, {   5, 10,  819 }, {   5, 10,  961 }, {   6, 10,  396 },
  {   6, 10, 1631 }, {   6, 10, 1678 }, {   7, 10, 1967 }, {   7, 10, 2041 },
  {   9, 10,  630 }, {  11, 10,    8 }, {  11, 10, 1019 }, {  12, 10,  176 },
  {  13, 10,  225 }, {  14, 10,  292 }, { 149, 10,   24 }, { 135,  0, 1919 },
  { 134,  0, 1131 }, { 144, 11,   21 }, { 144, 11,   51 }, { 135, 10, 1815 },
  {   4,  0,  247 }, {   7, 10, 1505 }, {  10, 10,  190 }, {  10, 10,  634 },
  {  11, 10,  792 }, {  12, 10,  358 }, { 140, 10,  447 }, {   5, 10,    0 },
  {   6, 10,  536 }, {   7, 10,  604 }, {  13, 10,  445 }, { 145, 10,  126 },
  {   4,  0,  184 }, {   5,  0,  390 }, {   6,  0,  337 }, {   7,  0,   23 },
  {   7,  0,  494 }, {   7,  0,  618 }, {   7,  0, 1456 }, {   8,  0,   27 },
  {   8,  0,  599 }, {  10,  0,  153 }, { 139,  0,  710 }, {   6, 10,  232 },
  {   6, 10,  412 }, {   7, 10, 1074 }, {   8, 10,    9 }, {   8, 10,  157 },
  {   8, 10,  786 }, {   9, 10,  196 }, {   9, 10,  352 }, {   9, 10,  457 },
  {  10, 10,  337 }, {  11, 10,  232 }, {  11, 10,  877 }, {  12, 10,  480 },
  { 140, 10,  546 }, {  13,  0,   38 }, { 135, 10,  958 }, {   4, 10,  382 },
  { 136, 10,  579 }, {   4, 10,  212 }, { 135, 10, 1206 }, {   4, 11,  555 },
  {   8, 11,  536 }, { 138, 11,  288 }, {  11, 11,  139 }, { 139, 11,  171 },
  {   9, 11,  370 }, { 138, 11,   90 }, { 132,  0, 1015 }, { 134,  0, 1088 },
  {   5, 10,  655 }, { 135, 11,  977 }, { 134,  0, 1585 }, {  17, 10,   67 },
  { 147, 10,   74 }, {  10,  0,  227 }, {  11,  0,  497 }, {  11,  0,  709 },
  { 140,  0,  415 }, {   6,  0,  360 }, {   7,  0, 1664 }, { 136,  0,  478 },
  {   7,  0,   95 }, {   6, 10,  231 }, { 136, 10,  423 }, { 140, 11,   65 },
  {   4, 11,  257 }, { 135, 11, 2031 }, { 135, 11, 1768 }, { 133, 10,  300 },
  { 139, 11,  211 }, { 136,  0,  699 }, {   6, 10,  237 }, {   7, 10,  611 },
  {   8, 10,  100 }, {   9, 10,  416 }, {  11, 10,  335 }, {  12, 10,  173 },
  { 146, 10,  101 }, {  14,  0,   26 }, { 146,  0,  150 }, {   6,  0,  581 },
  { 135,  0, 1119 }, { 135, 10, 1208 }, { 132,  0,  739 }, {   6, 11,   83 },
  {   6, 11, 1733 }, { 135, 11, 1389 }, { 137,  0,  869 }, {   4,  0,   67 },
  {   5,  0,  422 }, {   7,  0, 1037 }, {   7,  0, 1289 }, {   7,  0, 1555 },
  {   9,  0,  741 }, { 145,  0,  108 }, { 133, 10,  199 }, {  12, 10,  427 },
  { 146, 10,   38 }, { 136,  0,  464 }, { 142,  0,   42 }, {  10,  0,   96 },
  {   8, 11,  501 }, { 137, 11,  696 }, { 134, 11,  592 }, {   4,  0,  512 },
  {   4,  0,  966 }, {   5,  0,  342 }, {   6,  0, 1855 }, {   8,  0,  869 },
  {   8,  0,  875 }, {   8,  0,  901 }, { 144,  0,   26 }, {   8,  0,  203 },
  {  11,  0,  823 }, {  11,  0,  846 }, {  12,  0,  482 }, {  13,  0,  277 },
  {  13,  0,  302 }, {  13,  0,  464 }, {  14,  0,  205 }, { 142,  0,  221 },
  {   4,  0,  449 }, { 133,  0,  718 }, {   7, 11, 1718 }, {   9, 11,   95 },
  {   9, 11,  274 }, {  10, 11,  279 }, {  10, 11,  317 }, {  10, 11,  420 },
  {  11, 11,  303 }, {  11, 11,  808 }, {  12, 11,  134 }, {  12, 11,  367 },
  {  13, 11,  149 }, {  13, 11,  347 }, {  14, 11,  349 }, {  14, 11,  406 },
  {  18, 11,   22 }, {  18, 11,   89 }, {  18, 11,  122 }, { 147, 11,   47 },
  { 133, 11,   26 }, {   4,  0,  355 }, {   6,  0,  311 }, {   9,  0,  256 },
  { 138,  0,  404 }, { 132, 11,  550 }, {  10,  0,  758 }, {   6, 10,  312 },
  {   6, 10, 1715 }, {  10, 10,  584 }, {  11, 10,  546 }, {  11, 10,  692 },
  {  12, 10,  259 }, {  12, 10,  295 }, {  13, 10,   46 }, { 141, 10,  154 },
  { 136, 11,  822 }, {   5,  0,  827 }, {   4, 11,  902 }, {   5, 11,  809 },
  {   6, 11,  122 }, { 135, 11,  896 }, {   5,  0,   64 }, { 140,  0,  581 },
  {   4,  0,  442 }, {   6,  0,  739 }, {   7,  0, 1047 }, {   7,  0, 1352 },
  {   7,  0, 1643 }, {   7, 11, 1911 }, {   9, 11,  449 }, {  10, 11,  192 },
  { 138, 11,  740 }, { 135, 11,  262 }, { 132, 10,  588 }, { 133, 11,  620 },
  {   5,  0,  977 }, {   6,  0,  288 }, {   7,  0,  528 }, {   4, 11,   34 },
  {   5, 11,  574 }, {   7, 11,  279 }, {   7, 11, 1624 }, { 136, 11,  601 },
  {   6,  0, 1375 }, {   4, 10,  231 }, {   5, 10,   61 }, {   6, 10,  104 },
  {   7, 10,  729 }, {   7, 10,  964 }, {   7, 10, 1658 }, { 140, 10,  414 },
  {   6, 10,  263 }, { 138, 10,  757 }, { 132, 10,  320 }, {   4,  0,  254 },
  {   7,  0, 1309 }, {   5, 11,  332 }, { 135, 11, 1309 }, {   6, 11,  261 },
  {   8, 11,  182 }, { 139, 11,  943 }, { 132, 10,  225 }, {   6,  0,   12 },
  { 135,  0, 1219 }, {   4,  0,  275 }, {  12,  0,  376 }, {   6, 11, 1721 },
  { 141, 11,  490 }, {   4, 11,  933 }, { 133, 11,  880 }, {   6,  0,  951 },
  {   6,  0, 1109 }, {   6,  0, 1181 }, {   7,  0,  154 }, {   4, 10,  405 },
  {   7, 10,  817 }, {  14, 10,   58 }, {  17, 10,   37 }, { 146, 10,  124 },
  {   6,  0, 1520 }, { 133, 10,  974 }, { 134,  0, 1753 }, {   6,  0,  369 },
  {   6,  0,  502 }, {   7,  0, 1036 }, {   8,  0,  348 }, {   9,  0,  452 },
  {  10,  0,   26 }, {  11,  0,  224 }, {  11,  0,  387 }, {  11,  0,  772 },
  {  12,  0,   95 }, {  12,  0,  629 }, {  13,  0,  195 }, {  13,  0,  207 },
  {  13,  0,  241 }, {  14,  0,  260 }, {  14,  0,  270 }, { 143,  0,  140 },
  { 132,  0,  269 }, {   5,  0,  480 }, {   7,  0,  532 }, {   7,  0, 1197 },
  {   7,  0, 1358 }, {   8,  0,  291 }, {  11,  0,  349 }, { 142,  0,  396 },
  {   5, 10,  235 }, {   7, 10, 1239 }, {  11, 10,  131 }, { 140, 10,  370 },
  {   7, 10,  956 }, {   7, 10, 1157 }, {   7, 10, 1506 }, {   7, 10, 1606 },
  {   7, 10, 1615 }, {   7, 10, 1619 }, {   7, 10, 1736 }, {   7, 10, 1775 },
  {   8, 10,  590 }, {   9, 10,  324 }, {   9, 10,  736 }, {   9, 10,  774 },
  {   9, 10,  776 }, {   9, 10,  784 }, {  10, 10,  567 }, {  10, 10,  708 },
  {  11, 10,  518 }, {  11, 10,  613 }, {  11, 10,  695 }, {  11, 10,  716 },
  {  11, 10,  739 }, {  11, 10,  770 }, {  11, 10,  771 }, {  11, 10,  848 },
  {  11, 10,  857 }, {  11, 10,  931 }, {  11, 10,  947 }, {  12, 10,  326 },
  {  12, 10,  387 }, {  12, 10,  484 }, {  12, 10,  528 }, {  12, 10,  552 },
  {  12, 10,  613 }, {  13, 10,  189 }, {  13, 10,  256 }, {  13, 10,  340 },
  {  13, 10,  432 }, {  13, 10,  436 }, {  13, 10,  440 }, {  13, 10,  454 },
  {  14, 10,  174 }, {  14, 10,  220 }, {  14, 10,  284 }, {  14, 10,  390 },
  { 145, 10,  121 }, {   8, 11,  598 }, {   9, 11,  664 }, { 138, 11,  441 },
  {   9, 10,  137 }, { 138, 10,  221 }, { 133, 11,  812 }, { 148,  0,   15 },
  { 134,  0, 1341 }, {   6,  0, 1017 }, {   4, 11,  137 }, {   7, 11, 1178 },
  { 135, 11, 1520 }, {   7, 10,  390 }, { 138, 10,  140 }, {   7, 11, 1260 },
  { 135, 11, 1790 }, { 137, 11,  191 }, { 135, 10, 1144 }, {   6,  0, 1810 },
  {   7,  0,  657 }, {   8,  0,  886 }, {  10,  0,  857 }, {  14,  0,  440 },
  { 144,  0,   96 }, {   8,  0,  533 }, {   6, 11, 1661 }, {   7, 11, 1975 },
  {   7, 11, 2009 }, { 135, 11, 2011 }, {   6,  0, 1453 }, { 134, 10,  464 },
  { 132, 11,  715 }, {   5, 10,  407 }, {  11, 10,  204 }, {  11, 10,  243 },
  {  11, 10,  489 }, {  12, 10,  293 }, {  19, 10,   37 }, {  20, 10,   73 },
  { 150, 10,   38 }, { 133, 11,  703 }, {   4,  0,  211 }, {   7,  0, 1483 },
  {   5, 10,  325 }, {   8, 10,    5 }, {   8, 10,  227 }, {   9, 10,  105 },
  {  10, 10,  585 }, { 140, 10,  614 }, {   4,  0,  332 }, {   5,  0,  335 },
  {   6,  0,  238 }, {   7,  0,  269 }, {   7,  0,  811 }, {   7,  0, 1797 },
  {   8,  0,  836 }, {   9,  0,  507 }, { 141,  0,  242 }, {   5, 11,   89 },
  {   7, 11, 1915 }, {   9, 11,  185 }, {   9, 11,  235 }, {   9, 11,  496 },
  {  10, 11,   64 }, {  10, 11,  270 }, {  10, 11,  403 }, {  10, 11,  469 },
  {  10, 11,  529 }, {  10, 11,  590 }, {  11, 11,  140 }, {  11, 11,  860 },
  {  13, 11,    1 }, {  13, 11,  422 }, {  14, 11,  341 }, {  14, 11,  364 },
  {  17, 11,   93 }, {  18, 11,  113 }, {  19, 11,   97 }, { 147, 11,  113 },
  { 133, 11,  695 }, {  16,  0,   19 }, {   5, 11,    6 }, {   6, 11,  183 },
  {   6, 10,  621 }, {   7, 11,  680 }, {   7, 11,  978 }, {   7, 11, 1013 },
  {   7, 11, 1055 }, {  12, 11,  230 }, {  13, 11,  172 }, {  13, 10,  504 },
  { 146, 11,   29 }, { 136,  0,  156 }, { 133,  0, 1009 }, {   6, 11,   29 },
  { 139, 11,   63 }, { 134,  0,  820 }, { 134, 10,  218 }, {   7, 10,  454 },
  {   7, 10,  782 }, {   8, 10,  768 }, { 140, 10,  686 }, {   5,  0,  228 },
  {   6,  0,  203 }, {   7,  0,  156 }, {   8,  0,  347 }, {   9,  0,  265 },
  {  18,  0,   39 }, {  20,  0,   54 }, {  21,  0,   31 }, {  22,  0,    3 },
  {  23,  0,    0 }, {  15, 11,    8 }, {  18, 11,   39 }, {  20, 11,   54 },
  {  21, 11,   31 }, {  22, 11,    3 }, { 151, 11,    0 }, {   7,  0, 1131 },
  { 135,  0, 1468 }, { 144, 10,    0 }, { 134,  0, 1276 }, {  10, 10,  676 },
  { 140, 10,  462 }, { 132, 11,  311 }, { 134, 11, 1740 }, {   7, 11,  170 },
  {   8, 11,   90 }, {   8, 11,  177 }, {   8, 11,  415 }, {  11, 11,  714 },
  { 142, 11,  281 }, { 134, 10,  164 }, {   6,  0, 1792 }, { 138,  0,  849 },
  { 150, 10,   50 }, {   5,  0,  291 }, {   5,  0,  318 }, {   7,  0,  765 },
  {   9,  0,  389 }, {  12,  0,  548 }, {   8, 11,  522 }, { 142, 11,  328 },
  {  11, 11,   91 }, {  13, 11,  129 }, {  15, 11,  101 }, { 145, 11,  125 },
  {   4, 11,  494 }, {   6, 11,   74 }, {   7, 11,   44 }, {   7, 11,  407 },
  {   8, 11,  551 }, {  12, 11,   17 }, {  15, 11,    5 }, { 148, 11,   11 },
  {   4, 11,  276 }, { 133, 11,  296 }, {   6, 10,  343 }, {   7, 10,  195 },
  {   7, 11, 1777 }, {   9, 10,  226 }, {  10, 10,  197 }, {  10, 10,  575 },
  {  11, 10,  502 }, { 139, 10,  899 }, {  10,  0,  525 }, { 139,  0,   82 },
  {  14,  0,  453 }, {   4, 11,    7 }, {   5, 11,   90 }, {   5, 11,  158 },
  {   6, 11,  542 }, {   7, 11,  221 }, {   7, 11, 1574 }, {   9, 11,  490 },
  {  10, 11,  540 }, {  11, 11,  443 }, { 139, 11,  757 }, { 135,  0,  666 },
  {  22, 10,   29 }, { 150, 11,   29 }, {   4,  0,  422 }, { 147, 10,    8 },
  {   5,  0,  355 }, { 145,  0,    0 }, {   6,  0, 1873 }, {   9,  0,  918 },
  {   7, 11,  588 }, {   9, 11,  175 }, { 138, 11,  530 }, { 143, 11,   31 },
  {  11,  0,  165 }, {   7, 10, 1125 }, {   9, 10,  143 }, {  14, 10,  405 },
  { 150, 10,   21 }, {   9,  0,  260 }, { 137,  0,  905 }, {   5, 11,  872 },
  {   6, 11,   57 }, {   6, 11,  479 }, {   6, 11,  562 }, {   7, 11,  471 },
  {   7, 11, 1060 }, {   9, 11,  447 }, {   9, 11,  454 }, { 141, 11,    6 },
  { 138, 11,  704 }, { 133,  0,  865 }, {   5,  0,  914 }, { 134,  0, 1625 },
  { 133,  0,  234 }, {   7,  0, 1383 }, {   5, 11,   31 }, {   6, 11,  614 },
  { 145, 11,   61 }, {   7, 11, 1200 }, { 138, 11,  460 }, {   6, 11,  424 },
  { 135, 11, 1866 }, { 136,  0,  306 }, {   5, 10,  959 }, {  12, 11,   30 },
  {  13, 11,  148 }, {  14, 11,   87 }, {  14, 11,  182 }, {  16, 11,   42 },
  {  18, 11,   92 }, { 148, 11,   70 }, {   6,  0, 1919 }, {   6,  0, 1921 },
  {   9,  0,  923 }, {   9,  0,  930 }, {   9,  0,  941 }, {   9,  0,  949 },
  {   9,  0,  987 }, {   9,  0,  988 }, {   9,  0,  992 }, {  12,  0,  802 },
  {  12,  0,  815 }, {  12,  0,  856 }, {  12,  0,  885 }, {  12,  0,  893 },
  {  12,  0,  898 }, {  12,  0,  919 }, {  12,  0,  920 }, {  12,  0,  941 },
  {  12,  0,  947 }, {  15,  0,  183 }, {  15,  0,  185 }, {  15,  0,  189 },
  {  15,  0,  197 }, {  15,  0,  202 }, {  15,  0,  233 }, {  18,  0,  218 },
  {  18,  0,  219 }, {  18,  0,  233 }, { 143, 11,  156 }, { 135, 10, 1759 },
  { 136, 10,  173 }, {  13,  0,  163 }, {  13,  0,  180 }, {  18,  0,   78 },
  {  20,  0,   35 }, {   5, 11,   13 }, { 134, 11,  142 }, { 134, 10,  266 },
  {   6, 11,   97 }, {   7, 11,  116 }, {   8, 11,  322 }, {   8, 11,  755 },
  {   9, 11,  548 }, {  10, 11,  714 }, {  11, 11,  884 }, { 141, 11,  324 },
  { 135,  0, 1312 }, {   9,  0,  814 }, { 137, 11,  676 }, { 133,  0,  707 },
  { 135,  0, 1493 }, {   6,  0,  421 }, {   7,  0,   61 }, {   7,  0, 1540 },
  {  10,  0,   11 }, { 138,  0,  501 }, {  12,  0,  733 }, {  12,  0,  766 },
  {   7, 11,  866 }, { 135, 11, 1163 }, { 137,  0,  341 }, { 142,  0,   98 },
  { 145, 11,  115 }, { 135, 11, 1111 }, { 136, 10,  300 }, { 136,  0, 1014 },
  {   8, 11,    1 }, {   9, 11,  112 }, { 138, 11,  326 }, { 132, 11,  730 },
  {   5, 11,  488 }, {   6, 11,  527 }, {   7, 11,  489 }, {   7, 11, 1636 },
  {   8, 11,  121 }, {   8, 11,  144 }, {   8, 11,  359 }, {   9, 11,  193 },
  {   9, 11,  241 }, {   9, 11,  336 }, {   9, 11,  882 }, {  11, 11,  266 },
  {  11, 11,  372 }, {  11, 11,  944 }, {  12, 11,  401 }, { 140, 11,  641 },
  {   6,  0,  971 }, { 134,  0, 1121 }, {   6,  0,  102 }, {   7,  0,   72 },
  {  15,  0,  142 }, { 147,  0,   67 }, { 151,  0,   30 }, { 135,  0,  823 },
  { 134,  0, 1045 }, {   5, 10,  427 }, {   5, 10,  734 }, {   7, 10,  478 },
  { 136, 10,   52 }, {   7,  0, 1930 }, {  11, 10,  217 }, { 142, 10,  165 },
  {   6,  0, 1512 }, { 135,  0, 1870 }, {   9, 11,   31 }, {  10, 11,  244 },
  {  10, 11,  699 }, {  12, 11,  149 }, { 141, 11,  497 }, { 133, 11,  377 },
  { 145, 11,  101 }, {  10, 11,  158 }, {  13, 11,   13 }, {  13, 11,  137 },
  {  13, 11,  258 }, {  14, 11,  111 }, {  14, 11,  225 }, {  14, 11,  253 },
  {  14, 11,  304 }, {  14, 11,  339 }, {  14, 11,  417 }, { 146, 11,   33 },
  {   6,  0,   87 }, {   6, 10, 1734 }, {   7, 10,   20 }, {   7, 10, 1056 },
  {   8, 10,  732 }, {   9, 10,  406 }, {   9, 10,  911 }, { 138, 10,  694 },
  { 134,  0, 1243 }, { 137,  0,  245 }, {   7,  0,   68 }, {   8,  0,   48 },
  {   8,  0,   88 }, {   8,  0,  582 }, {   8,  0,  681 }, {   9,  0,  373 },
  {   9,  0,  864 }, {  11,  0,  157 }, {  11,  0,  336 }, {  11,  0,  843 },
  { 148,  0,   27 }, {   8, 11,  663 }, { 144, 11,    8 }, { 133, 10,  613 },
  {   4,  0,   88 }, {   5,  0,  137 }, {   5,  0,  174 }, {   5,  0,  777 },
  {   6,  0, 1664 }, {   6,  0, 1725 }, {   7,  0,   77 }, {   7,  0,  426 },
  {   7,  0, 1317 }, {   7,  0, 1355 }, {   8,  0,  126 }, {   8,  0,  563 },
  {   9,  0,  523 }, {   9,  0,  750 }, {  10,  0,  310 }, {  10,  0,  836 },
  {  11,  0,   42 }, {  11,  0,  318 }, {  11,  0,  731 }, {  12,  0,   68 },
  {  12,  0,   92 }, {  12,  0,  507 }, {  12,  0,  692 }, {  13,  0,   81 },
  {  13,  0,  238 }, {  13,  0,  374 }, {  14,  0,  436 }, {  18,  0,  138 },
  {  19,  0,   78 }, {  19,  0,  111 }, {  20,  0,   55 }, {  20,  0,   77 },
  { 148,  0,   92 }, { 141,  0,  418 }, {   4,  0,  938 }, { 137,  0,  625 },
  { 138,  0,  351 }, {   5, 11,  843 }, {   7, 10,   32 }, {   7, 10,  984 },
  {   8, 10,   85 }, {   8, 10,  709 }, {   9, 10,  579 }, {   9, 10,  847 },
  {   9, 10,  856 }, {  10, 10,  799 }, {  11, 10,  258 }, {  11, 10, 1007 },
  {  12, 10,  331 }, {  12, 10,  615 }, {  13, 10,  188 }, {  13, 10,  435 },
  {  14, 10,    8 }, {  15, 10,  165 }, {  16, 10,   27 }, { 148, 10,   40 },
  {   6,  0, 1668 }, {   7,  0, 1499 }, {   8,  0,  117 }, {   9,  0,  314 },
  { 138,  0,  174 }, { 135,  0,  707 }, { 132, 11,  554 }, { 133, 11,  536 },
  {   5,  0,  403 }, {   5, 11,  207 }, {   9, 11,   79 }, {  11, 11,  625 },
  { 145, 11,    7 }, { 132, 11,  424 }, { 136, 11,  785 }, {   4, 10,  167 },
  { 135, 10,   82 }, {   9,  0,    7 }, {  23,  0,    6 }, {   9, 11,    7 },
  { 151, 11,    6 }, {   6,  0,  282 }, {   5, 10,   62 }, {   6, 10,  534 },
  {   7, 10,   74 }, {   7, 10,  678 }, {   7, 10,  684 }, {   7, 10, 1043 },
  {   7, 10, 1072 }, {   8, 10,  280 }, {   8, 10,  541 }, {   8, 10,  686 },
  {   9, 10,  258 }, {  10, 10,  519 }, {  11, 10,  252 }, { 140, 10,  282 },
  { 138, 10,   33 }, { 132, 10,  359 }, {   4,  0,   44 }, {   5,  0,  311 },
  {   6,  0,  156 }, {   7,  0,  639 }, {   7,  0,  762 }, {   7,  0, 1827 },
  {   9,  0,    8 }, {   9,  0,  462 }, { 148,  0,   83 }, {   7, 11,  769 },
  {   9, 11,   18 }, { 138, 11,  358 }, {   4,  0,  346 }, {   7,  0,  115 },
  {   9,  0,  180 }, {   9,  0,  456 }, {  10,  0,  363 }, {   4, 11,  896 },
  { 134, 11, 1777 }, { 133, 10,  211 }, {   7,  0,  761 }, {   7,  0, 1051 },
  { 137,  0,  545 }, {   6, 10,  145 }, { 141, 10,  336 }, {   7, 11,  750 },
  {   9, 11,  223 }, {  11, 11,   27 }, {  11, 11,  466 }, {  12, 11,  624 },
  {  14, 11,  265 }, { 146, 11,   61 }, {   6,  0,  752 }, {   6,  0,  768 },
  {   6,  0, 1195 }, {   6,  0, 1254 }, {   6,  0, 1619 }, { 137,  0,  835 },
  {   6,  0, 1936 }, {   8,  0,  930 }, { 136,  0,  960 }, { 132, 10,  263 },
  { 132, 11,  249 }, {  12,  0,  653 }, { 132, 10,  916 }, {   4, 11,  603 },
  { 133, 11,  661 }, {   8,  0,  344 }, {   4, 11,   11 }, {   6, 11,  128 },
  {   7, 11,  231 }, {   7, 11, 1533 }, { 138, 11,  725 }, { 134,  0, 1483 },
  { 134,  0,  875 }, {   6,  0,  185 }, {   7,  0, 1899 }, {   9,  0,  875 },
  { 139,  0,  673 }, {  15, 10,  155 }, { 144, 10,   79 }, {   7,  0,   93 },
  {   7,  0,  210 }, {   7,  0, 1223 }, {   8,  0,  451 }, {   8,  0,  460 },
  {  11,  0,  353 }, {  11,  0,  475 }, {   4, 10,  599 }, {   6, 10, 1634 },
  {   7, 10,   67 }, {   7, 10,  691 }, {   7, 10,  979 }, {   7, 10, 1697 },
  {   8, 10,  207 }, {   8, 10,  214 }, {   8, 10,  231 }, {   8, 10,  294 },
  {   8, 10,  336 }, {   8, 10,  428 }, {   8, 10,  471 }, {   8, 10,  622 },
  {   8, 10,  626 }, {   8, 10,  679 }, {   8, 10,  759 }, {   8, 10,  829 },
  {   9, 10,   11 }, {   9, 10,  246 }, {   9, 10,  484 }, {   9, 10,  573 },
  {   9, 10,  706 }, {   9, 10,  762 }, {   9, 10,  798 }, {   9, 10,  855 },
  {   9, 10,  870 }, {   9, 10,  912 }, {  10, 10,  303 }, {  10, 10,  335 },
  {  10, 10,  424 }, {  10, 10,  461 }, {  10, 10,  543 }, {  10, 10,  759 },
  {  10, 10,  814 }, {  11, 10,   59 }, {  11, 10,  235 }, {  11, 10,  590 },
  {  11, 10,  929 }, {  11, 10,  963 }, {  11, 10,  987 }, {  12, 10,  114 },
  {  12, 10,  182 }, {  12, 10,  226 }, {  12, 10,  332 }, {  12, 10,  439 },
  {  12, 10,  575 }, {  12, 10,  598 }, {  12, 10,  675 }, {  13, 10,    8 },
  {  13, 10,  125 }, {  13, 10,  194 }, {  13, 10,  287 }, {  14, 10,  197 },
  {  14, 10,  383 }, {  15, 10,   53 }, {  17, 10,   63 }, {  19, 10,   46 },
  {  19, 10,   98 }, {  19, 10,  106 }, { 148, 10,   85 }, { 132, 11,  476 },
  {   4,  0,  327 }, {   5,  0,  478 }, {   7,  0, 1332 }, { 136,  0,  753 },
  {   5,  0, 1020 }, { 133,  0, 1022 }, { 135, 11, 1807 }, {   4,  0,  103 },
  { 133,  0,  401 }, {   4,  0,  499 }, { 135,  0, 1421 }, {  10,  0,  207 },
  {  13,  0,  164 }, { 147, 10,  126 }, {   9, 11,   20 }, {  10, 11,  324 },
  { 139, 11,  488 }, { 132,  0,   96 }, {   9, 11,  280 }, { 138, 11,  134 },
  { 135,  0,  968 }, { 133, 10,  187 }, { 135, 10, 1286 }, {   5, 11,  112 },
  {   6, 11,  103 }, { 134, 11,  150 }, {   8,  0,  914 }, {  10,  0,    3 },
  {   4, 10,  215 }, {   9, 10,   38 }, {  11, 10,   23 }, {  11, 10,  127 },
  { 139, 10,  796 }, { 135,  0,  399 }, {   6,  0,  563 }, { 137,  0,  224 },
  {   6,  0,  704 }, { 134,  0, 1214 }, {   4, 11,  708 }, {   8, 11,   15 },
  {   9, 11,   50 }, {   9, 11,  386 }, {  11, 11,   18 }, {  11, 11,  529 },
  { 140, 11,  228 }, {   4, 11,  563 }, {   7, 11,  109 }, {   7, 11,  592 },
  {   7, 11,  637 }, {   7, 11,  770 }, {   7, 11, 1701 }, {   8, 11,  436 },
  {   8, 11,  463 }, {   9, 11,   60 }, {   9, 11,  335 }, {   9, 11,  904 },
  {  10, 11,   73 }, {  11, 11,  434 }, {  12, 11,  585 }, {  13, 11,  331 },
  {  18, 11,  110 }, { 148, 11,   60 }, { 134,  0, 1559 }, { 132, 11,  502 },
  {   6, 11,  347 }, { 138, 11,  161 }, {   4, 11,   33 }, {   5, 11,  102 },
  {   5, 11,  500 }, {   6, 11,  284 }, {   7, 11, 1079 }, {   7, 11, 1423 },
  {   7, 11, 1702 }, {   8, 11,  470 }, {   9, 11,  554 }, {   9, 11,  723 },
  { 139, 11,  333 }, {   7, 11,  246 }, { 135, 11,  840 }, {   6, 11,   10 },
  {   8, 11,  571 }, {   9, 11,  739 }, { 143, 11,   91 }, {   8,  0,  861 },
  {  10,  0,  905 }, {  12,  0,  730 }, {  12,  0,  789 }, { 133, 11,  626 },
  { 134,  0,  946 }, {   5,  0,  746 }, {  12,  0,  333 }, {  14,  0,  332 },
  {  12, 11,  333 }, { 142, 11,  332 }, {   5, 11,   18 }, {   6, 11,  526 },
  {  13, 11,   24 }, {  13, 11,  110 }, {  19, 11,    5 }, { 147, 11,   44 },
  {   4,  0,  910 }, {   5,  0,  832 }, { 135, 10, 2002 }, {  10, 11,  768 },
  { 139, 11,  787 }, {   4, 11,  309 }, {   5, 11,  462 }, {   7, 11,  970 },
  { 135, 11, 1097 }, {   4, 10,   28 }, {   5, 10,  440 }, {   7, 10,  248 },
  {  11, 10,  833 }, { 140, 10,  344 }, { 134, 10, 1654 }, {   6,  0,  632 },
  {   6,  0,  652 }, {   6,  0, 1272 }, {   6,  0, 1384 }, { 134,  0, 1560 },
  { 134, 11, 1704 }, {   6,  0, 1393 }, { 133, 10,  853 }, {   6, 10,  249 },
  {   7, 10, 1234 }, { 139, 10,  573 }, {   5, 11,   86 }, {   7, 11,  743 },
  {   9, 11,   85 }, {  10, 11,  281 }, {  10, 11,  432 }, {  11, 11,  490 },
  {  12, 11,  251 }, {  13, 11,  118 }, {  14, 11,  378 }, { 146, 11,  143 },
  {   5, 11,  524 }, { 133, 11,  744 }, { 134,  0, 1514 }, {  10,  0,  201 },
  { 142,  0,  319 }, {   7,  0,  717 }, {  10,  0,  510 }, {   7, 10,  392 },
  {   8, 10,   20 }, {   8, 10,  172 }, {   8, 10,  690 }, {   9, 10,  383 },
  {   9, 10,  845 }, {  11, 10,  293 }, {  11, 10,  832 }, {  11, 10,  920 },
  {  11, 10,  984 }, { 141, 10,  221 }, { 134,  0, 1381 }, {   5, 10,  858 },
  { 133, 10,  992 }, {   8,  0,  528 }, { 137,  0,  348 }, {  10, 11,  107 },
  { 140, 11,  436 }, {   4,  0,   20 }, { 133,  0,  616 }, { 134,  0, 1251 },
  { 132, 11,  927 }, {  10, 11,  123 }, {  12, 11,  670 }, {  13, 11,  371 },
  {  14, 11,  142 }, { 146, 11,   94 }, { 134,  0, 1163 }, {   7, 11, 1149 },
  { 137, 11,  156 }, { 134,  0,  307 }, { 133, 11,  778 }, {   7,  0, 1091 },
  { 135,  0, 1765 }, {   5, 11,  502 }, {   6, 10,  268 }, { 137, 10,   62 },
  {   8, 11,  196 }, {  10, 11,  283 }, { 139, 11,  406 }, {   4,  0,   26 },
  {   5,  0,  429 }, {   6,  0,  245 }, {   7,  0,  704 }, {   7,  0, 1379 },
  { 135,  0, 1474 }, { 133, 11,  855 }, { 132,  0,  881 }, {   4,  0,  621 },
  { 135, 11, 1596 }, {   7, 11, 1400 }, {   9, 11,  446 }, { 138, 11,   45 },
  {   6,  0,  736 }, { 138, 10,  106 }, { 133,  0,  542 }, { 134,  0,  348 },
  { 133,  0,  868 }, { 136,  0,  433 }, { 135,  0, 1495 }, { 138,  0,  771 },
  {   6, 10,  613 }, { 136, 10,  223 }, { 138,  0,  215 }, { 141,  0,  124 },
  { 136, 11,  391 }, { 135, 11,  172 }, { 132, 10,  670 }, { 140,  0,   55 },
  {   9, 10,   40 }, { 139, 10,  136 }, {   7,  0,   62 }, { 147,  0,  112 },
  { 132,  0,  856 }, { 132, 11,  568 }, {  12,  0,  270 }, { 139, 10,  259 },
  {   8,  0,  572 }, { 137,  0,  698 }, {   4, 11,  732 }, {   9, 10,  310 },
  { 137, 10,  682 }, { 142, 10,  296 }, { 134,  0,  939 }, { 136, 11,  733 },
  { 135, 11, 1435 }, {   7, 10, 1401 }, { 135, 10, 1476 }, {   6,  0,  352 },
  {   4, 10,  296 }, {   7, 10,  401 }, {   7, 10, 1410 }, {   7, 10, 1594 },
  {   7, 10, 1674 }, {   8, 10,   63 }, {   8, 10,  660 }, { 137, 10,   74 },
  {   4, 11,  428 }, { 133, 11,  668 }, {   4, 10,  139 }, {   4, 10,  388 },
  { 140, 10,  188 }, {   7, 11, 2015 }, { 140, 11,  665 }, { 132,  0,  647 },
  { 146,  0,   10 }, { 138,  0,  220 }, { 142,  0,  464 }, { 132,  0,  109 },
  { 134,  0, 1746 }, {   6,  0,  515 }, {   4, 10,  747 }, {   6, 11, 1623 },
  {   6, 11, 1681 }, {   7, 10,  649 }, {   7, 10, 1479 }, { 135, 10, 1583 },
  { 133, 10,  232 }, { 135,  0,  566 }, { 137, 10,  887 }, {   4,  0,   40 },
  {  10,  0,   67 }, {  11,  0,  117 }, {  11,  0,  768 }, { 139,  0,  935 },
  { 132,  0,  801 }, {   7,  0,  992 }, {   8,  0,  301 }, {   9,  0,  722 },
  {  12,  0,   63 }, {  13,  0,   29 }, {  14,  0,  161 }, { 143,  0,   18 },
  { 139,  0,  923 }, {   6, 11, 1748 }, {   8, 11,  715 }, {   9, 11,  802 },
  {  10, 11,   46 }, {  10, 11,  819 }, {  13, 11,  308 }, {  14, 11,  351 },
  {  14, 11,  363 }, { 146, 11,   67 }, { 137, 11,  745 }, {   7,  0, 1145 },
  {   4, 10,   14 }, {   7, 10, 1801 }, {  10, 10,  748 }, { 141, 10,  458 },
  {   4, 11,   63 }, {   5, 11,  347 }, { 134, 11,  474 }, { 135,  0,  568 },
  {   4, 10,  425 }, {   7, 11,  577 }, {   7, 11, 1432 }, {   9, 11,  475 },
  {   9, 11,  505 }, {   9, 11,  526 }, {   9, 11,  609 }, {   9, 11,  689 },
  {   9, 11,  726 }, {   9, 11,  735 }, {   9, 11,  738 }, {  10, 11,  556 },
  {  10, 11,  674 }, {  10, 11,  684 }, {  11, 11,   89 }, {  11, 11,  202 },
  {  11, 11,  272 }, {  11, 11,  380 }, {  11, 11,  415 }, {  11, 11,  505 },
  {  11, 11,  537 }, {  11, 11,  550 }, {  11, 11,  562 }, {  11, 11,  640 },
  {  11, 11,  667 }, {  11, 11,  688 }, {  11, 11,  847 }, {  11, 11,  927 },
  {  11, 11,  930 }, {  11, 11,  940 }, {  12, 11,  144 }, {  12, 11,  325 },
  {  12, 11,  329 }, {  12, 11,  389 }, {  12, 11,  403 }, {  12, 11,  451 },
  {  12, 11,  515 }, {  12, 11,  604 }, {  12, 11,  616 }, {  12, 11,  626 },
  {  13, 11,   66 }, {  13, 11,  131 }, {  13, 11,  167 }, {  13, 11,  236 },
  {  13, 11,  368 }, {  13, 11,  411 }, {  13, 11,  434 }, {  13, 11,  453 },
  {  13, 11,  461 }, {  13, 11,  474 }, {  14, 11,   59 }, {  14, 11,   60 },
  {  14, 11,  139 }, {  14, 11,  152 }, {  14, 11,  276 }, {  14, 11,  353 },
  {  14, 11,  402 }, {  15, 11,   28 }, {  15, 11,   81 }, {  15, 11,  123 },
  {  15, 11,  152 }, {  18, 11,  136 }, { 148, 11,   88 }, { 137,  0,  247 },
  { 135, 11, 1622 }, {   9, 11,  544 }, {  11, 11,  413 }, { 144, 11,   25 },
  {   4,  0,  645 }, {   7,  0,  825 }, {   6, 10, 1768 }, { 135, 11,   89 },
  { 140,  0,  328 }, {   5, 10,  943 }, { 134, 10, 1779 }, { 134,  0, 1363 },
  {   5, 10,  245 }, {   6, 10,  576 }, {   7, 10,  582 }, { 136, 10,  225 },
  { 134,  0, 1280 }, {   5, 11,  824 }, { 133, 11,  941 }, {   7, 11,  440 },
  {   8, 11,  230 }, { 139, 11,  106 }, {   5,  0,   28 }, {   6,  0,  204 },
  {  10,  0,  320 }, {  10,  0,  583 }, {  13,  0,  502 }, {  14,  0,   72 },
  {  14,  0,  274 }, {  14,  0,  312 }, {  14,  0,  344 }, {  15,  0,  159 },
  {  16,  0,   62 }, {  16,  0,   69 }, {  17,  0,   30 }, {  18,  0,   42 },
  {  18,  0,   53 }, {  18,  0,   84 }, {  18,  0,  140 }, {  19,  0,   68 },
  {  19,  0,   85 }, {  20,  0,    5 }, {  20,  0,   45 }, {  20,  0,  101 },
  {  22,  0,    7 }, { 150,  0,   20 }, {   4,  0,  558 }, {   6,  0,  390 },
  {   7,  0,  162 }, {   7,  0,  689 }, {   9,  0,  360 }, { 138,  0,  653 },
  { 134,  0,  764 }, {   6,  0,  862 }, { 137,  0,  833 }, {   5,  0,  856 },
  {   6,  0, 1672 }, {   6,  0, 1757 }, { 134,  0, 1781 }, {   5,  0,   92 },
  {  10,  0,  736 }, { 140,  0,  102 }, {   6,  0, 1927 }, {   6,  0, 1944 },
  {   8,  0,  924 }, {   8,  0,  948 }, {  10,  0,  967 }, { 138,  0,  978 },
  { 134,  0, 1479 }, {   5,  0,  590 }, {   8,  0,  360 }, {   9,  0,  213 },
  { 138,  0,   63 }, { 134,  0, 1521 }, {   6,  0,  709 }, { 134,  0,  891 },
  { 132, 10,  443 }, {  13,  0,  477 }, {  14,  0,  120 }, { 148,  0,   61 },
  {   4, 11,  914 }, {   5, 11,  800 }, { 133, 11,  852 }, {  10, 11,   54 },
  { 141, 11,  115 }, {   4, 11,  918 }, { 133, 11,  876 }, { 139, 11,  152 },
  {   4, 11,   92 }, { 133, 11,  274 }, { 135, 11, 1901 }, {   9, 11,  800 },
  {  10, 11,  693 }, {  11, 11,  482 }, {  11, 11,  734 }, { 139, 11,  789 },
  {   9,  0,  483 }, { 132, 10,  298 }, {   6,  0, 1213 }, { 141, 11,  498 },
  { 135, 11, 1451 }, { 133, 11,  743 }, {   4,  0, 1022 }, {  10,  0, 1000 },
  {  12,  0,  957 }, {  12,  0,  980 }, {  12,  0, 1013 }, {  14,  0,  481 },
  { 144,  0,  116 }, {   8,  0,  503 }, {  17,  0,   29 }, {   4, 11,   49 },
  {   7, 11,  280 }, { 135, 11, 1633 }, { 135,  0, 1712 }, { 134,  0,  466 },
  { 136, 11,   47 }, {   5, 10,  164 }, {   7, 10,  121 }, { 142, 10,  189 },
  {   7, 10,  812 }, {   7, 10, 1261 }, {   7, 10, 1360 }, {   9, 10,  632 },
  { 140, 10,  352 }, { 139, 10,  556 }, { 132,  0,  731 }, {   5, 11,  272 },
  {   5, 11,  908 }, {   5, 11,  942 }, {   7, 11, 1008 }, {   7, 11, 1560 },
  {   8, 11,  197 }, {   9, 11,   47 }, {  11, 11,  538 }, { 139, 11,  742 },
  {   4, 10,  172 }, {   9, 10,  611 }, {  10, 10,  436 }, {  12, 10,  673 },
  { 141, 10,  255 }, { 133, 10,  844 }, {  10,  0,  484 }, {  11,  0,  754 },
  {  12,  0,  457 }, {  14,  0,  171 }, {  14,  0,  389 }, { 146,  0,  153 },
  {   9, 10,  263 }, {  10, 10,  147 }, { 138, 10,  492 }, { 137, 11,  891 },
  { 138,  0,  241 }, { 133, 10,  537 }, {   6,  0, 2005 }, { 136,  0,  964 },
  { 137, 10,  842 }, { 151, 11,    8 }, {   4, 11,  407 }, { 132, 11,  560 },
  { 135, 11, 1884 }, {   6,  0, 1100 }, { 134,  0, 1242 }, { 135,  0,  954 },
  {   5, 10,  230 }, {   5, 10,  392 }, {   6, 10,  420 }, {   9, 10,  568 },
  { 140, 10,  612 }, {   4, 11,  475 }, {  11, 11,   35 }, {  11, 11,   90 },
  {  13, 11,    7 }, {  13, 11,   71 }, {  13, 11,  177 }, { 142, 11,  422 },
  { 136, 11,  332 }, { 135,  0, 1958 }, {   6,  0,  549 }, {   8,  0,   34 },
  {   8,  0,  283 }, {   9,  0,  165 }, { 138,  0,  475 }, {  10,  0,  952 },
  {  12,  0,  966 }, { 140,  0,  994 }, {   5,  0,  652 }, {   5,  0,  701 },
  { 135,  0,  449 }, {   4,  0,  655 }, {   7,  0,  850 }, {  17,  0,   75 },
  { 146,  0,  137 }, {   4,  0,  146 }, {   7,  0, 1618 }, {   8,  0,  670 },
  {   5, 10,   41 }, {   7, 10, 1459 }, {   7, 10, 1469 }, {   7, 10, 1859 },
  {   9, 10,  549 }, { 139, 10,  905 }, { 133, 10,  696 }, {   6,  0,  159 },
  {   6,  0,  364 }, {   7,  0,  516 }, { 137,  0,  518 }, { 135,  0, 1439 },
  {   6, 11,  222 }, {   7, 11,  636 }, {   7, 11, 1620 }, {   8, 11,  409 },
  {   9, 11,  693 }, { 139, 11,   77 }, {  13,  0,  151 }, { 141, 11,   45 },
  {   6,  0, 1027 }, {   4, 11,  336 }, { 132, 10,  771 }, { 139, 11,  392 },
  {  10, 11,  121 }, {  11, 11,  175 }, { 149, 11,   16 }, {   8,  0,  950 },
  { 138,  0,  983 }, { 133, 10,  921 }, { 135,  0,  993 }, {   6, 10,  180 },
  {   7, 10, 1137 }, {   8, 10,  751 }, { 139, 10,  805 }, {   7,  0,  501 },
  {   9,  0,  111 }, {  10,  0,  141 }, {  11,  0,  332 }, {  13,  0,   43 },
  {  13,  0,  429 }, {  14,  0,  130 }, {  14,  0,  415 }, { 145,  0,  102 },
  {   4, 10,  183 }, {   5, 11,  882 }, {   7, 10,  271 }, {  11, 10,  824 },
  {  11, 10,  952 }, {  13, 10,  278 }, {  13, 10,  339 }, {  13, 10,  482 },
  {  14, 10,  424 }, { 148, 10,   99 }, {   4, 10,   19 }, {   5, 10,  477 },
  {   5, 10,  596 }, {   6, 10,  505 }, {   7, 10, 1221 }, {  11, 10,  907 },
  {  12, 10,  209 }, { 141, 10,  214 }, { 135, 10, 1215 }, { 133,  0,  452 },
  { 132, 11,  426 }, {   5,  0,  149 }, { 136,  0,  233 }, { 133,  0,  935 },
  {   6, 11,   58 }, {   7, 11,  654 }, {   7, 11,  745 }, {   7, 11, 1969 },
  {   8, 11,  240 }, {   8, 11,  675 }, {   9, 11,  479 }, {   9, 11,  731 },
  {  10, 11,  330 }, {  10, 11,  593 }, {  10, 11,  817 }, {  11, 11,   32 },
  {  11, 11,  133 }, {  11, 11,  221 }, { 145, 11,   68 }, {  12,  0,  582 },
  {  18,  0,  131 }, {   7, 11,  102 }, { 137, 11,  538 }, { 136,  0,  801 },
  { 134, 10, 1645 }, { 132,  0,   70 }, {   6, 10,   92 }, {   6, 10,  188 },
  {   7, 10, 1269 }, {   7, 10, 1524 }, {   7, 10, 1876 }, {  10, 10,  228 },
  { 139, 10, 1020 }, {   4, 10,  459 }, { 133, 10,  966 }, { 138,  0,  369 },
  {  16,  0,   36 }, { 140, 10,  330 }, { 141, 11,  366 }, {   7,  0,  721 },
  {  10,  0,  236 }, {  12,  0,  204 }, {   6, 10,   18 }, {   7, 10,  932 },
  {   8, 10,  757 }, {   9, 10,   54 }, {   9, 10,   65 }, {   9, 10,  844 },
  {  10, 10,  113 }, {  10, 10,  315 }, {  10, 10,  798 }, {  11, 10,  153 },
  {  12, 10,  151 }, {  12, 10,  392 }, {  12, 10,  666 }, { 142, 10,  248 },
  {   7,  0,  241 }, {  10,  0,  430 }, {   8, 10,  548 }, {   9, 10,  532 },
  {  10, 10,  117 }, {  11, 10,  351 }, {  11, 10,  375 }, { 143, 10,   23 },
  { 134, 10, 1742 }, { 133, 10,  965 }, { 133, 11,  566 }, {   6, 11,   48 },
  { 135, 11,   63 }, { 134, 10,  182 }, {  10, 10,   65 }, {  10, 10,  488 },
  { 138, 10,  497 }, {   6, 11,  114 }, {   7, 11, 1224 }, {   7, 11, 1556 },
  { 136, 11,    3 }, { 134,  0, 1817 }, {   8, 11,  576 }, { 137, 11,  267 },
  {   6,  0, 1078 }, { 144,  0,   16 }, {   9, 10,  588 }, { 138, 10,  260 },
  { 138,  0, 1021 }, {   5,  0,  406 }, { 134,  0, 2022 }, { 133, 11,  933 },
  {   6,  0,   69 }, { 135,  0,  117 }, {   7,  0, 1830 }, { 136, 11,  427 },
  {   4,  0,  432 }, { 135,  0,  824 }, { 134, 10, 1786 }, { 133,  0,  826 },
  { 139, 11,   67 }, { 133, 11,  759 }, { 135, 10,  308 }, { 137,  0,  816 },
  { 133,  0, 1000 }, {   4,  0,  297 }, {   6,  0,  529 }, {   7,  0,  152 },
  {   7,  0,  713 }, {   7,  0, 1845 }, {   8,  0,  710 }, {   8,  0,  717 },
  {  12,  0,  639 }, { 140,  0,  685 }, {   7,  0,  423 }, { 136, 10,  588 },
  { 136, 10,  287 }, { 136,  0,  510 }, { 134,  0, 1048 }, {   6,  0,  618 },
  {   7, 11,   56 }, {   7, 11, 1989 }, {   8, 11,  337 }, {   8, 11,  738 },
  {   9, 11,  600 }, {  10, 11,  483 }, {  12, 11,   37 }, {  13, 11,  447 },
  { 142, 11,   92 }, {   4,  0,  520 }, { 135,  0,  575 }, {   8,  0,  990 },
  { 138,  0,  977 }, { 135, 11,  774 }, {   9, 11,  347 }, {  11, 11,   24 },
  { 140, 11,  170 }, { 136, 11,  379 }, { 140, 10,  290 }, { 132, 11,  328 },
  {   4,  0,  321 }, { 134,  0,  569 }, {   4, 11,  101 }, { 135, 11, 1171 },
  {   7,  0,  723 }, {   7,  0, 1135 }, {   5, 11,  833 }, { 136, 11,  744 },
  {   7, 10,  719 }, {   8, 10,  809 }, { 136, 10,  834 }, {   8,  0,  921 },
  { 136, 10,  796 }, {   5, 10,  210 }, {   6, 10,  213 }, {   7, 10,   60 },
  {  10, 10,  364 }, { 139, 10,  135 }, {   5,  0,  397 }, {   6,  0,  154 },
  {   7,  0,  676 }, {   8,  0,  443 }, {   8,  0,  609 }, {   9,  0,   24 },
  {   9,  0,  325 }, {  10,  0,   35 }, {  11,  0,  535 }, {  11,  0,  672 },
  {  11,  0, 1018 }, {  12,  0,  637 }, {  16,  0,   30 }, {   5, 10,  607 },
  {   8, 10,  326 }, { 136, 10,  490 }, {   4, 10,  701 }, {   5, 10,  472 },
  {   6, 11,    9 }, {   6, 11,  397 }, {   7, 11,   53 }, {   7, 11, 1742 },
  {   9, 10,  758 }, {  10, 11,  632 }, {  11, 11,  828 }, { 140, 11,  146 },
  { 135, 10,  380 }, { 135, 10, 1947 }, { 148, 11,  109 }, {  10, 10,  278 },
  { 138, 11,  278 }, { 134,  0,  856 }, {   7,  0,  139 }, {   4, 10,  386 },
  {   8, 10,  405 }, {   8, 10,  728 }, {   9, 10,  497 }, {  11, 10,  110 },
  {  11, 10,  360 }, {  15, 10,   37 }, { 144, 10,   84 }, { 141,  0,  282 },
  { 133,  0,  981 }, {   5,  0,  288 }, {   7, 10, 1452 }, {   7, 10, 1480 },
  {   8, 10,  634 }, { 140, 10,  472 }, {   7,  0, 1890 }, {   8, 11,  367 },
  {  10, 11,  760 }, {  14, 11,   79 }, {  20, 11,   17 }, { 152, 11,    0 },
  {   4, 10,  524 }, { 136, 10,  810 }, {   4,  0,   56 }, {   7,  0, 1791 },
  {   8,  0,  607 }, {   8,  0,  651 }, {  11,  0,  465 }, {  11,  0,  835 },
  {  12,  0,  337 }, { 141,  0,  480 }, {  10, 10,  238 }, { 141, 10,   33 },
  {  11, 11,  417 }, {  12, 11,  223 }, { 140, 11,  265 }, {   9,  0,  158 },
  {  10,  0,  411 }, { 140,  0,  261 }, { 133, 10,  532 }, { 133, 10,  997 },
  {  12, 11,  186 }, {  12, 11,  292 }, {  14, 11,  100 }, { 146, 11,   70 },
  {   6,  0, 1403 }, { 136,  0,  617 }, { 134,  0, 1205 }, { 139,  0,  563 },
  {   4,  0,  242 }, { 134,  0,  333 }, {   4, 11,  186 }, {   5, 11,  157 },
  {   8, 11,  168 }, { 138, 11,    6 }, { 132,  0,  369 }, { 133, 11,  875 },
  {   5, 10,  782 }, {   5, 10,  829 }, { 134, 10, 1738 }, { 134,  0,  622 },
  { 135, 11, 1272 }, {   6,  0, 1407 }, {   7, 11,  111 }, { 136, 11,  581 },
  {   7, 10, 1823 }, { 139, 10,  693 }, {   7,  0,  160 }, {  10,  0,  624 },
  { 142,  0,  279 }, { 132,  0,  363 }, {  10, 11,  589 }, {  12, 11,  111 },
  {  13, 11,  260 }, {  14, 11,   82 }, {  18, 11,   63 }, { 147, 11,   45 },
  {   7, 11, 1364 }, {   7, 11, 1907 }, { 141, 11,  158 }, {   4, 11,  404 },
  {   4, 11,  659 }, { 135, 11,  675 }, {  13, 11,  211 }, {  14, 11,  133 },
  {  14, 11,  204 }, {  15, 11,   64 }, {  15, 11,   69 }, {  15, 11,  114 },
  {  16, 11,   10 }, {  19, 11,   23 }, {  19, 11,   35 }, {  19, 11,   39 },
  {  19, 11,   51 }, {  19, 11,   71 }, {  19, 11,   75 }, { 152, 11,   15 },
  {   4, 10,   78 }, {   5, 10,   96 }, {   5, 10,  182 }, {   7, 10, 1724 },
  {   7, 10, 1825 }, {  10, 10,  394 }, {  10, 10,  471 }, {  11, 10,  532 },
  {  14, 10,  340 }, { 145, 10,   88 }, { 135, 10, 1964 }, { 133, 11,  391 },
  {  11, 11,  887 }, {  14, 11,  365 }, { 142, 11,  375 }, {   5, 11,  540 },
  {   6, 11, 1697 }, {   7, 11,  222 }, { 136, 11,  341 }, { 134, 11,   78 },
  {   9,  0,  601 }, {   9,  0,  619 }, {  10,  0,  505 }, {  10,  0,  732 },
  {  11,  0,  355 }, { 140,  0,  139 }, { 134,  0,  292 }, { 139,  0,  174 },
  {   5,  0,  177 }, {   6,  0,  616 }, {   7,  0,  827 }, {   9,  0,  525 },
  { 138,  0,  656 }, {  10,  0,   31 }, {   6, 10,  215 }, {   7, 10, 1028 },
  {   7, 10, 1473 }, {   7, 10, 1721 }, {   9, 10,  424 }, { 138, 10,  779 },
  { 135, 10,  584 }, { 136, 11,  293 }, { 134,  0,  685 }, { 135, 11, 1868 },
  { 133, 11,  460 }, {   7,  0,  647 }, {   6, 10,   67 }, {   7, 10, 1630 },
  {   9, 10,  354 }, {   9, 10,  675 }, {  10, 10,  830 }, {  14, 10,   80 },
  { 145, 10,   80 }, {   4,  0,  161 }, { 133,  0,  631 }, {   6, 10,  141 },
  {   7, 10,  225 }, {   9, 10,   59 }, {   9, 10,  607 }, {  10, 10,  312 },
  {  11, 10,  687 }, {  12, 10,  555 }, {  13, 10,  373 }, {  13, 10,  494 },
  { 148, 10,   58 }, {   7, 11,  965 }, {   7, 11, 1460 }, { 135, 11, 1604 },
  { 136, 10,  783 }, { 134, 11,  388 }, {   6,  0,  722 }, {   6,  0, 1267 },
  {   4, 11,  511 }, {   9, 11,  333 }, {   9, 11,  379 }, {  10, 11,  602 },
  {  11, 11,  441 }, {  11, 11,  723 }, {  11, 11,  976 }, { 140, 11,  357 },
  { 134,  0, 1797 }, { 135,  0, 1684 }, {   9,  0,  469 }, {   9,  0,  709 },
  {  12,  0,  512 }, {  14,  0,   65 }, {  17,  0,   12 }, {   5, 11,  938 },
  { 136, 11,  707 }, {   7,  0, 1230 }, { 136,  0,  531 }, {  10,  0,  229 },
  {  11,  0,   73 }, {  11,  0,  376 }, { 139,  0,  433 }, {  12,  0,  268 },
  {  12,  0,  640 }, { 142,  0,  119 }, {   7, 10,  430 }, { 139, 10,   46 },
  {   6,  0,  558 }, {   7,  0,  651 }, {   8,  0,  421 }, {   9,  0,    0 },
  {  10,  0,   34 }, { 139,  0, 1008 }, {   6,  0,  106 }, {   7,  0, 1786 },
  {   7,  0, 1821 }, {   9,  0,  102 }, {   9,  0,  763 }, {   5, 10,  602 },
  {   7, 10, 2018 }, { 137, 10,  418 }, {   5,  0,   65 }, {   6,  0,  416 },
  {   7,  0, 1720 }, {   7,  0, 1924 }, {  10,  0,  109 }, {  11,  0,   14 },
  {  11,  0,   70 }, {  11,  0,  569 }, {  11,  0,  735 }, {  15,  0,  153 },
  {  20,  0,   80 }, { 136, 10,  677 }, { 135, 11, 1625 }, { 137, 11,  772 },
  { 136,  0,  595 }, {   6, 11,  469 }, {   7, 11, 1709 }, { 138, 11,  515 },
  {   7,  0, 1832 }, { 138,  0,  374 }, {   9,  0,  106 }, {   9,  0,  163 },
  {   9,  0,  296 }, {  10,  0,  167 }, {  10,  0,  172 }, {  10,  0,  777 },
  { 139,  0,   16 }, {   6,  0,    6 }, {   7,  0,   81 }, {   7,  0,  771 },
  {   7,  0, 1731 }, {   9,  0,  405 }, { 138,  0,  421 }, {   4, 11,  500 },
  { 135, 11,  938 }, {   5, 11,   68 }, { 134, 11,  383 }, {   5,  0,  881 },
  { 133,  0,  885 }, {   6,  0,  854 }, {   6,  0, 1132 }, {   6,  0, 1495 },
  {   6,  0, 1526 }, {   6,  0, 1533 }, { 134,  0, 1577 }, {   4, 11,  337 },
  {   6, 11,  353 }, {   7, 11, 1934 }, {   8, 11,  488 }, { 137, 11,  429 },
  {   7, 11,  236 }, {   7, 11, 1795 }, {   8, 11,  259 }, {   9, 11,  135 },
  {   9, 11,  177 }, {  10, 11,  825 }, {  11, 11,  115 }, {  11, 11,  370 },
  {  11, 11,  405 }, {  11, 11,  604 }, {  12, 11,   10 }, {  12, 11,  667 },
  {  12, 11,  669 }, {  13, 11,   76 }, {  14, 11,  310 }, {  15, 11,   76 },
  {  15, 11,  147 }, { 148, 11,   23 }, {   5,  0,  142 }, { 134,  0,  546 },
  {   4, 11,   15 }, {   5, 11,   22 }, {   6, 11,  244 }, {   7, 11,   40 },
  {   7, 11,  200 }, {   7, 11,  906 }, {   7, 11, 1199 }, {   9, 11,  616 },
  {  10, 11,  716 }, {  11, 11,  635 }, {  11, 11,  801 }, { 140, 11,  458 },
  {   5,  0,  466 }, {  11,  0,  571 }, {  12,  0,  198 }, {  13,  0,  283 },
  {  14,  0,  186 }, {  15,  0,   21 }, {  15,  0,  103 }, { 135, 10,  329 },
  {   4,  0,  185 }, {   5,  0,  257 }, {   5,  0,  839 }, {   5,  0,  936 },
  {   9,  0,  399 }, {  10,  0,  258 }, {  10,  0,  395 }, {  10,  0,  734 },
  {  11,  0, 1014 }, {  12,  0,   23 }, {  13,  0,  350 }, {  14,  0,  150 },
  {  19,  0,    6 }, { 135, 11, 1735 }, {  12, 11,   36 }, { 141, 11,  337 },
  {   5, 11,  598 }, {   7, 11,  791 }, {   8, 11,  108 }, { 137, 11,  123 },
  { 132, 10,  469 }, {   7,  0,  404 }, {   7,  0, 1377 }, {   7,  0, 1430 },
  {   7,  0, 2017 }, {   8,  0,  149 }, {   8,  0,  239 }, {   8,  0,  512 },
  {   8,  0,  793 }, {   8,  0,  818 }, {   9,  0,  474 }, {   9,  0,  595 },
  {  10,  0,  122 }, {  10,  0,  565 }, {  10,  0,  649 }, {  10,  0,  783 },
  {  11,  0,  239 }, {  11,  0,  295 }, {  11,  0,  447 }, {  11,  0,  528 },
  {  11,  0,  639 }, {  11,  0,  800 }, {  12,  0,   25 }, {  12,  0,   77 },
  {  12,  0,  157 }, {  12,  0,  256 }, {  12,  0,  316 }, {  12,  0,  390 },
  {  12,  0,  391 }, {  12,  0,  395 }, {  12,  0,  478 }, {  12,  0,  503 },
  {  12,  0,  592 }, {  12,  0,  680 }, {  13,  0,   50 }, {  13,  0,   53 },
  {  13,  0,  132 }, {  13,  0,  198 }, {  13,  0,  322 }, {  13,  0,  415 },
  {  13,  0,  511 }, {  14,  0,   71 }, {  14,  0,  395 }, {  15,  0,   71 },
  {  15,  0,  136 }, {  17,  0,  123 }, {  18,  0,   93 }, { 147,  0,   58 },
  { 136,  0,  712 }, { 134, 10, 1743 }, {   5, 10,  929 }, {   6, 10,  340 },
  {   8, 10,  376 }, { 136, 10,  807 }, {   6,  0, 1848 }, {   8,  0,  860 },
  {  10,  0,  856 }, {  10,  0,  859 }, {  10,  0,  925 }, {  10,  0,  941 },
  { 140,  0,  762 }, {   6,  0,  629 }, {   6,  0,  906 }, {   9,  0,  810 },
  { 140,  0,  652 }, {   5, 10,  218 }, {   7, 10, 1610 }, { 138, 10,   83 },
  {   7, 10, 1512 }, { 135, 10, 1794 }, {   4,  0,  377 }, {  24,  0,   13 },
  {   4, 11,  155 }, {   7, 11, 1689 }, {  11, 10,    0 }, { 144, 10,   78 },
  {   4, 11,  164 }, {   5, 11,  151 }, {   5, 11,  730 }, {   5, 11,  741 },
  {   7, 11,  498 }, {   7, 11,  870 }, {   7, 11, 1542 }, {  12, 11,  213 },
  {  14, 11,   36 }, {  14, 11,  391 }, {  17, 11,  111 }, {  18, 11,    6 },
  {  18, 11,   46 }, {  18, 11,  151 }, {  19, 11,   36 }, {  20, 11,   32 },
  {  20, 11,   56 }, {  20, 11,   69 }, {  20, 11,  102 }, {  21, 11,    4 },
  {  22, 11,    8 }, {  22, 11,   10 }, {  22, 11,   14 }, { 150, 11,   31 },
  {   7,  0, 1842 }, { 133, 10,  571 }, {   4, 10,  455 }, {   4, 11,  624 },
  { 135, 11, 1752 }, { 134,  0, 1501 }, {   4, 11,  492 }, {   5, 11,  451 },
  {   6, 10,  161 }, {   7, 10,  372 }, { 137, 10,  597 }, { 132, 10,  349 },
  {   4,  0,  180 }, { 135,  0, 1906 }, { 135, 11,  835 }, { 141, 11,   70 },
  { 132,  0,  491 }, { 137, 10,  751 }, {   6, 10,  432 }, { 139, 10,  322 },
  {   4,  0,  171 }, { 138,  0,  234 }, {   6, 11,  113 }, { 135, 11,  436 },
  {   4,  0,  586 }, {   7,  0, 1186 }, { 138,  0,  631 }, {   5, 10,  468 },
  {  10, 10,  325 }, {  11, 10,  856 }, {  12, 10,  345 }, { 143, 10,  104 },
  {   5, 10,  223 }, {  10, 11,  592 }, {  10, 11,  753 }, {  12, 11,  317 },
  {  12, 11,  355 }, {  12, 11,  465 }, {  12, 11,  469 }, {  12, 11,  560 },
  {  12, 11,  578 }, { 141, 11,  243 }, { 132, 10,  566 }, { 135, 11,  520 },
  {   4, 10,   59 }, { 135, 10, 1394 }, {   6, 10,  436 }, { 139, 10,  481 },
  {   9,  0,  931 }, {  10,  0,  334 }, {  20,  0,   71 }, {   4, 10,   48 },
  {   5, 10,  271 }, {   7, 10,  953 }, { 135, 11, 1878 }, {  11,  0,  170 },
  {   5, 10,  610 }, { 136, 10,  457 }, { 133, 10,  755 }, {   6,  0, 1587 },
  { 135, 10, 1217 }, {   4, 10,  197 }, { 149, 11,   26 }, { 133, 11,  585 },
  { 137, 11,  521 }, { 133,  0,  765 }, { 133, 10,  217 }, { 139, 11,  586 },
  { 133,  0,  424 }, {   9, 11,  752 }, {  12, 11,  610 }, {  13, 11,  431 },
  {  16, 11,   59 }, { 146, 11,  109 }, { 136,  0,  714 }, {   7,  0,  685 },
  { 132, 11,  307 }, {   9,  0,  420 }, {  10,  0,  269 }, {  10,  0,  285 },
  {  10,  0,  576 }, {  11,  0,  397 }, {  13,  0,  175 }, { 145,  0,   90 },
  { 132,  0,  429 }, { 133, 11,  964 }, {   9, 11,  463 }, { 138, 11,  595 },
  {   7,  0,   18 }, {   7,  0,  699 }, {   7,  0, 1966 }, {   8,  0,  752 },
  {   9,  0,  273 }, {   9,  0,  412 }, {   9,  0,  703 }, {  10,  0,   71 },
  {  10,  0,  427 }, { 138,  0,  508 }, {   4, 10,  165 }, {   7, 10, 1398 },
  { 135, 10, 1829 }, {   4,  0,   53 }, {   5,  0,  186 }, {   7,  0,  752 },
  {   7,  0,  828 }, { 142,  0,  116 }, {   8,  0,  575 }, {  10,  0,  289 },
  { 139,  0,  319 }, { 132,  0,  675 }, { 134,  0, 1424 }, {   4, 11,   75 },
  {   5, 11,  180 }, {   6, 11,  500 }, {   7, 11,   58 }, {   7, 11,  710 },
  { 138, 11,  645 }, { 133, 11,  649 }, {   6, 11,  276 }, {   7, 11,  282 },
  {   7, 11,  879 }, {   7, 11,  924 }, {   8, 11,  459 }, {   9, 11,  599 },
  {   9, 11,  754 }, {  11, 11,  574 }, {  12, 11,  128 }, {  12, 11,  494 },
  {  13, 11,   52 }, {  13, 11,  301 }, {  15, 11,   30 }, { 143, 11,  132 },
  {   6,  0,  647 }, { 134,  0, 1095 }, {   5, 10,    9 }, {   7, 10,  297 },
  {   7, 10,  966 }, { 140, 10,  306 }, { 132, 11,  200 }, { 134,  0, 1334 },
  {   5, 10,  146 }, {   6, 10,  411 }, { 138, 10,  721 }, {   6,  0,  209 },
  {   6,  0, 1141 }, {   6,  0, 1288 }, {   8,  0,  468 }, {   9,  0,  210 },
  {  11,  0,   36 }, {  12,  0,   28 }, {  12,  0,  630 }, {  13,  0,   21 },
  {  13,  0,  349 }, {  14,  0,    7 }, { 145,  0,   13 }, {   6, 10,  177 },
  { 135, 10,  467 }, {   4,  0,  342 }, { 135,  0, 1179 }, {  10, 11,  454 },
  { 140, 11,  324 }, {   4,  0,  928 }, { 133,  0,  910 }, {   7,  0, 1838 },
  {   6, 11,  225 }, { 137, 11,  211 }, {  16,  0,  101 }, {  20,  0,  115 },
  {  20,  0,  118 }, { 148,  0,  122 }, {   4,  0,  496 }, { 135,  0,  856 },
  {   4,  0,  318 }, {  11,  0,  654 }, {   7, 11,  718 }, { 139, 11,  102 },
  {   8, 11,   58 }, {   9, 11,  724 }, {  11, 11,  809 }, {  13, 11,  113 },
  { 145, 11,   72 }, {   5, 10,  200 }, {   6, 11,  345 }, { 135, 11, 1247 },
  {   8, 11,  767 }, {   8, 11,  803 }, {   9, 11,  301 }, { 137, 11,  903 },
  {   7,  0,  915 }, {   8,  0,  247 }, {  19,  0,    0 }, {   7, 11, 1949 },
  { 136, 11,  674 }, {   4,  0,  202 }, {   5,  0,  382 }, {   6,  0,  454 },
  {   7,  0,  936 }, {   7,  0, 1803 }, {   8,  0,  758 }, {   9,  0,  375 },
  {   9,  0,  895 }, {  10,  0,  743 }, {  10,  0,  792 }, {  11,  0,  978 },
  {  11,  0, 1012 }, { 142,  0,  109 }, {   7,  0, 1150 }, {   7,  0, 1425 },
  {   7,  0, 1453 }, { 140,  0,  513 }, { 134, 11,  259 }, { 138,  0,  791 },
  {  11,  0,  821 }, {  12,  0,  110 }, {  12,  0,  153 }, {  18,  0,   41 },
  { 150,  0,   19 }, { 134, 10,  481 }, { 132,  0,  796 }, {   6,  0,  445 },
  {   9,  0,  909 }, { 136, 11,  254 }, {  10,  0,  776 }, {  13,  0,  345 },
  { 142,  0,  425 }, {   4, 10,   84 }, {   7, 10, 1482 }, {  10, 10,   76 },
  { 138, 10,  142 }, { 135, 11,  742 }, {   6,  0,  578 }, { 133, 10, 1015 },
  {   6,  0, 1387 }, {   4, 10,  315 }, {   5, 10,  507 }, { 135, 10, 1370 },
  {   4,  0,  438 }, { 133,  0,  555 }, { 136,  0,  766 }, { 133, 11,  248 },
  { 134, 10, 1722 }, {   4, 11,  116 }, {   5, 11,   95 }, {   5, 11,  445 },
  {   7, 11, 1688 }, {   8, 11,   29 }, {   9, 11,  272 }, {  11, 11,  509 },
  { 139, 11,  915 }, { 135,  0,  541 }, { 133, 11,  543 }, {   8, 10,  222 },
  {   8, 10,  476 }, {   9, 10,  238 }, {  11, 10,  516 }, {  11, 10,  575 },
  {  15, 10,  109 }, { 146, 10,  100 }, {   6,  0,  880 }, { 134,  0, 1191 },
  {   5, 11,  181 }, { 136, 11,   41 }, { 134,  0, 1506 }, { 132, 11,  681 },
  {   7, 11,   25 }, {   8, 11,  202 }, { 138, 11,  536 }, { 139,  0,  983 },
  { 137,  0,  768 }, { 132,  0,  584 }, {   9, 11,  423 }, { 140, 11,   89 },
  {   8, 11,  113 }, {   9, 11,  877 }, {  10, 11,  554 }, {  11, 11,   83 },
  {  12, 11,  136 }, { 147, 11,  109 }, {   7, 10,  706 }, {   7, 10, 1058 },
  { 138, 10,  538 }, { 133, 11,  976 }, {   4, 11,  206 }, { 135, 11,  746 },
  { 136, 11,  526 }, { 140,  0,  737 }, {  11, 10,   92 }, {  11, 10,  196 },
  {  11, 10,  409 }, {  11, 10,  450 }, {  11, 10,  666 }, {  11, 10,  777 },
  {  12, 10,  262 }, {  13, 10,  385 }, {  13, 10,  393 }, {  15, 10,  115 },
  {  16, 10,   45 }, { 145, 10,   82 }, {   4,  0,  226 }, {   4,  0,  326 },
  {   7,  0, 1770 }, {   4, 11,  319 }, {   5, 11,  699 }, { 138, 11,  673 },
  {   6, 10,   40 }, { 135, 10, 1781 }, {   5,  0,  426 }, {   8,  0,   30 },
  {   9,  0,    2 }, {  11,  0,  549 }, { 147,  0,  122 }, {   6,  0, 1161 },
  { 134,  0, 1329 }, { 138, 10,   97 }, {   6, 10,  423 }, {   7, 10,  665 },
  { 135, 10, 1210 }, {   7, 11,   13 }, {   8, 11,  226 }, {  10, 11,  537 },
  {  11, 11,  570 }, {  11, 11,  605 }, {  11, 11,  799 }, {  11, 11,  804 },
  {  12, 11,   85 }, {  12, 11,  516 }, {  12, 11,  623 }, {  13, 11,  112 },
  {  13, 11,  361 }, {  14, 11,   77 }, {  14, 11,   78 }, {  17, 11,   28 },
  { 147, 11,  110 }, { 132, 11,  769 }, { 132, 11,  551 }, { 132, 11,  728 },
  { 147,  0,  117 }, {   9, 11,   57 }, {   9, 11,  459 }, {  10, 11,  425 },
  {  11, 11,  119 }, {  12, 11,  184 }, {  12, 11,  371 }, {  13, 11,  358 },
  { 145, 11,   51 }, {   5, 11,  188 }, {   5, 11,  814 }, {   8, 11,   10 },
  {   9, 11,  421 }, {   9, 11,  729 }, {  10, 11,  609 }, { 139, 11,  689 },
  { 134, 11,  624 }, { 135, 11,  298 }, { 135,  0,  462 }, {   4,  0,  345 },
  { 139, 10,  624 }, { 136, 10,  574 }, {   4,  0,  385 }, {   7,  0,  265 },
  { 135,  0,  587 }, {   6,  0,  808 }, { 132, 11,  528 }, { 133,  0,  398 },
  { 132, 10,  354 }, {   4,  0,  347 }, {   5,  0,  423 }, {   5,  0,  996 },
  { 135,  0, 1329 }, { 135, 10, 1558 }, {   7,  0, 1259 }, {   9,  0,  125 },
  { 139,  0,   65 }, {   5,  0,  136 }, {   6,  0,  136 }, { 136,  0,  644 },
  {   5, 11,  104 }, {   6, 11,  173 }, { 135, 11, 1631 }, { 135,  0,  469 },
  { 133, 10,  830 }, {   4,  0,  278 }, {   5,  0,  465 }, { 135,  0, 1367 },
  {   7, 11,  810 }, {   8, 11,  138 }, {   8, 11,  342 }, {   9, 11,   84 },
  {  10, 11,  193 }, {  11, 11,  883 }, { 140, 11,  359 }, {   5, 10,  496 },
  { 135, 10,  203 }, {   4,  0,  433 }, { 133,  0,  719 }, {   6, 11,   95 },
  { 134, 10,  547 }, {   5, 10,   88 }, { 137, 10,  239 }, {   6, 11,  406 },
  {  10, 11,  409 }, {  10, 11,  447 }, {  11, 11,   44 }, { 140, 11,  100 },
  { 134,  0, 1423 }, {   7, 10,  650 }, { 135, 10, 1310 }, { 134,  0,  749 },
  { 135, 11, 1243 }, { 135,  0, 1363 }, {   6,  0,  381 }, {   7,  0,  645 },
  {   7,  0,  694 }, {   8,  0,  546 }, {   7, 10, 1076 }, {   9, 10,   80 },
  {  11, 10,   78 }, {  11, 10,  421 }, {  11, 10,  534 }, { 140, 10,  545 },
  { 134, 11, 1636 }, { 135, 11, 1344 }, {  12,  0,  277 }, {   7, 10,  274 },
  {  11, 10,  479 }, { 139, 10,  507 }, {   6,  0,  705 }, {   6,  0,  783 },
  {   6,  0, 1275 }, {   6,  0, 1481 }, {   4, 11,  282 }, {   7, 11, 1034 },
  {  11, 11,  398 }, {  11, 11,  634 }, {  12, 11,    1 }, {  12, 11,   79 },
  {  12, 11,  544 }, {  14, 11,  237 }, {  17, 11,   10 }, { 146, 11,   20 },
  { 134,  0,  453 }, {   4,  0,  555 }, {   8,  0,  536 }, {  10,  0,  288 },
  {  11,  0, 1005 }, {   4, 10,  497 }, { 135, 10, 1584 }, {   5, 11,  118 },
  {   5, 11,  499 }, {   6, 11,  476 }, {   7, 11,  600 }, {   7, 11,  888 },
  { 135, 11, 1096 }, { 138,  0,  987 }, {   7,  0, 1107 }, {   7, 10,  261 },
  {   7, 10, 1115 }, {   7, 10, 1354 }, {   7, 10, 1588 }, {   7, 10, 1705 },
  {   7, 10, 1902 }, {   9, 10,  465 }, {  10, 10,  248 }, {  10, 10,  349 },
  {  10, 10,  647 }, {  11, 10,  527 }, {  11, 10,  660 }, {  11, 10,  669 },
  {  12, 10,  529 }, { 141, 10,  305 }, {   7, 11,  296 }, {   7, 11,  596 },
  {   8, 11,  560 }, {   8, 11,  586 }, {   9, 11,  612 }, {  11, 11,  100 },
  {  11, 11,  304 }, {  12, 11,   46 }, {  13, 11,   89 }, {  14, 11,  112 },
  { 145, 11,  122 }, {   9,  0,  370 }, { 138,  0,   90 }, { 136, 10,   13 },
  { 132,  0,  860 }, {   7, 10,  642 }, {   8, 10,  250 }, {  11, 10,  123 },
  {  11, 10,  137 }, {  13, 10,   48 }, { 142, 10,   95 }, { 135, 10, 1429 },
  { 137, 11,  321 }, { 132,  0,  257 }, { 135,  0, 2031 }, {   7,  0, 1768 },
  {   7, 11, 1599 }, {   7, 11, 1723 }, {   8, 11,   79 }, {   8, 11,  106 },
  {   8, 11,  190 }, {   8, 11,  302 }, {   8, 11,  383 }, {   9, 11,  119 },
  {   9, 11,  233 }, {   9, 11,  298 }, {   9, 11,  419 }, {   9, 11,  471 },
  {  10, 11,  181 }, {  10, 11,  406 }, {  11, 11,   57 }, {  11, 11,   85 },
  {  11, 11,  120 }, {  11, 11,  177 }, {  11, 11,  296 }, {  11, 11,  382 },
  {  11, 11,  454 }, {  11, 11,  758 }, {  11, 11,  999 }, {  12, 11,   27 },
  {  12, 11,   98 }, {  12, 11,  131 }, {  12, 11,  245 }, {  12, 11,  312 },
  {  12, 11,  446 }, {  12, 11,  454 }, {  13, 11,   25 }, {  13, 11,   98 },
  {  13, 11,  426 }, {  13, 11,  508 }, {  14, 11,    6 }, {  14, 11,  163 },
  {  14, 11,  272 }, {  14, 11,  277 }, {  14, 11,  370 }, {  15, 11,   95 },
  {  15, 11,  138 }, {  15, 11,  167 }, {  17, 11,   18 }, {  17, 11,   38 },
  {  20, 11,   96 }, { 149, 11,   32 }, {   5, 11,  722 }, { 134, 11, 1759 },
  { 145, 11,   16 }, {   6,  0, 1071 }, { 134,  0, 1561 }, {  10, 10,  545 },
  { 140, 10,  301 }, {   6,  0,   83 }, {   6,  0, 1733 }, { 135,  0, 1389 },
  {   4,  0,  835 }, { 135,  0, 1818 }, { 133, 11,  258 }, {   4, 10,  904 },
  { 133, 10,  794 }, { 134,  0, 2006 }, {   5, 11,   30 }, {   7, 11,  495 },
  {   8, 11,  134 }, {   9, 11,  788 }, { 140, 11,  438 }, { 135, 11, 2004 },
  { 137,  0,  696 }, {   5, 11,   50 }, {   6, 11,  439 }, {   7, 11,  780 },
  { 135, 11, 1040 }, {   7, 11,  772 }, {   7, 11, 1104 }, {   7, 11, 1647 },
  {  11, 11,  269 }, {  11, 11,  539 }, {  11, 11,  607 }, {  11, 11,  627 },
  {  11, 11,  706 }, {  11, 11,  975 }, {  12, 11,  248 }, {  12, 11,  311 },
  {  12, 11,  434 }, {  12, 11,  600 }, {  12, 11,  622 }, {  13, 11,  297 },
  {  13, 11,  367 }, {  13, 11,  485 }, {  14, 11,   69 }, {  14, 11,  409 },
  { 143, 11,  108 }, {   5, 11,    1 }, {   6, 11,   81 }, { 138, 11,  520 },
  {   7,  0, 1718 }, {   9,  0,   95 }, {   9,  0,  274 }, {  10,  0,  279 },
  {  10,  0,  317 }, {  10,  0,  420 }, {  11,  0,  303 }, {  11,  0,  808 },
  {  12,  0,  134 }, {  12,  0,  367 }, {  13,  0,  149 }, {  13,  0,  347 },
  {  14,  0,  349 }, {  14,  0,  406 }, {  18,  0,   22 }, {  18,  0,   89 },
  {  18,  0,  122 }, { 147,  0,   47 }, {   5, 11,  482 }, {   8, 11,   98 },
  {   9, 11,  172 }, {  10, 11,  222 }, {  10, 11,  700 }, {  10, 11,  822 },
  {  11, 11,  302 }, {  11, 11,  778 }, {  12, 11,   50 }, {  12, 11,  127 },
  {  12, 11,  396 }, {  13, 11,   62 }, {  13, 11,  328 }, {  14, 11,  122 },
  { 147, 11,   72 }, {   7, 10,  386 }, { 138, 10,  713 }, {   6, 10,    7 },
  {   6, 10,   35 }, {   7, 10,  147 }, {   7, 10, 1069 }, {   7, 10, 1568 },
  {   7, 10, 1575 }, {   7, 10, 1917 }, {   8, 10,   43 }, {   8, 10,  208 },
  {   9, 10,  128 }, {   9, 10,  866 }, {  10, 10,   20 }, {  11, 10,  981 },
  { 147, 10,   33 }, { 133,  0,   26 }, { 132,  0,  550 }, {   5, 11,    2 },
  {   7, 11, 1494 }, { 136, 11,  589 }, {   6, 11,  512 }, {   7, 11,  797 },
  {   8, 11,  253 }, {   9, 11,   77 }, {  10, 11,    1 }, {  10, 11,  129 },
  {  10, 11,  225 }, {  11, 11,  118 }, {  11, 11,  226 }, {  11, 11,  251 },
  {  11, 11,  430 }, {  11, 11,  701 }, {  11, 11,  974 }, {  11, 11,  982 },
  {  12, 11,   64 }, {  12, 11,  260 }, {  12, 11,  488 }, { 140, 11,  690 },
  {   7, 10,  893 }, { 141, 10,  424 }, { 134,  0,  901 }, { 136,  0,  822 },
  {   4,  0,  902 }, {   5,  0,  809 }, { 134,  0,  122 }, {   6,  0,  807 },
  { 134,  0, 1366 }, {   7,  0,  262 }, {   5, 11,  748 }, { 134, 11,  553 },
  { 133,  0,  620 }, {   4,  0,   34 }, {   5,  0,  574 }, {   7,  0,  279 },
  {   7,  0, 1624 }, { 136,  0,  601 }, {   9,  0,  170 }, {   6, 10,  322 },
  {   9, 10,  552 }, {  11, 10,  274 }, {  13, 10,  209 }, {  13, 10,  499 },
  {  14, 10,   85 }, {  15, 10,  126 }, { 145, 10,   70 }, { 132,  0,  537 },
  {   4, 11,   12 }, {   7, 11,  420 }, {   7, 11,  522 }, {   7, 11,  809 },
  {   8, 11,  797 }, { 141, 11,   88 }, { 133,  0,  332 }, {   8, 10,   83 },
  {   8, 10,  742 }, {   8, 10,  817 }, {   9, 10,   28 }, {   9, 10,   29 },
  {   9, 10,  885 }, {  10, 10,  387 }, {  11, 10,  633 }, {  11, 10,  740 },
  {  13, 10,  235 }, {  13, 10,  254 }, {  15, 10,  143 }, { 143, 10,  146 },
  {   6,  0, 1909 }, {   9,  0,  964 }, {  12,  0,  822 }, {  12,  0,  854 },
  {  12,  0,  865 }, {  12,  0,  910 }, {  12,  0,  938 }, {  15,  0,  169 },
  {  15,  0,  208 }, {  15,  0,  211 }, {  18,  0,  205 }, {  18,  0,  206 },
  {  18,  0,  220 }, {  18,  0,  223 }, { 152,  0,   24 }, { 140, 10,   49 },
  {   5, 11,  528 }, { 135, 11, 1580 }, {   6,  0,  261 }, {   8,  0,  182 },
  { 139,  0,  943 }, { 134,  0, 1721 }, {   4,  0,  933 }, { 133,  0,  880 },
  { 136, 11,  321 }, {   5, 11,  266 }, {   9, 11,  290 }, {   9, 11,  364 },
  {  10, 11,  293 }, {  11, 11,  606 }, { 142, 11,   45 }, {   6,  0, 1609 },
  {   4, 11,   50 }, {   6, 11,  510 }, {   6, 11,  594 }, {   9, 11,  121 },
  {  10, 11,   49 }, {  10, 11,  412 }, { 139, 11,  834 }, {   7,  0,  895 },
  { 136, 11,  748 }, { 132, 11,  466 }, {   4, 10,  110 }, {  10, 10,  415 },
  {  10, 10,  597 }, { 142, 10,  206 }, { 133,  0,  812 }, { 135, 11,  281 },
  {   6,  0, 1890 }, {   6,  0, 1902 }, {   6,  0, 1916 }, {   9,  0,  929 },
  {   9,  0,  942 }, {   9,  0,  975 }, {   9,  0,  984 }, {   9,  0,  986 },
  {   9,  0, 1011 }, {   9,  0, 1019 }, {  12,  0,  804 }, {  12,  0,  851 },
  {  12,  0,  867 }, {  12,  0,  916 }, {  12,  0,  923 }, {  15,  0,  194 },
  {  15,  0,  204 }, {  15,  0,  210 }, {  15,  0,  222 }, {  15,  0,  223 },
  {  15,  0,  229 }, {  15,  0,  250 }, {  18,  0,  179 }, {  18,  0,  186 },
  {  18,  0,  192 }, {   7, 10,  205 }, { 135, 10, 2000 }, { 132, 11,  667 },
  { 135,  0,  778 }, {   4,  0,  137 }, {   7,  0, 1178 }, { 135,  0, 1520 },
  { 134,  0, 1314 }, {   4, 11,  242 }, { 134, 11,  333 }, {   6,  0, 1661 },
  {   7,  0, 1975 }, {   7,  0, 2009 }, { 135,  0, 2011 }, { 134,  0, 1591 },
  {   4, 10,  283 }, { 135, 10, 1194 }, {  11,  0,  820 }, { 150,  0,   51 },
  {   4, 11,   39 }, {   5, 11,   36 }, {   7, 11, 1843 }, {   8, 11,  407 },
  {  11, 11,  144 }, { 140, 11,  523 }, { 134, 10, 1720 }, {   4, 11,  510 },
  {   7, 11,   29 }, {   7, 11,   66 }, {   7, 11, 1980 }, {  10, 11,  487 },
  {  10, 11,  809 }, { 146, 11,    9 }, {   5,  0,   89 }, {   7,  0, 1915 },
  {   9,  0,  185 }, {   9,  0,  235 }, {  10,  0,   64 }, {  10,  0,  270 },
  {  10,  0,  403 }, {  10,  0,  469 }, {  10,  0,  529 }, {  10,  0,  590 },
  {  11,  0,  140 }, {  11,  0,  860 }, {  13,  0,    1 }, {  13,  0,  422 },
  {  14,  0,  341 }, {  14,  0,  364 }, {  17,  0,   93 }, {  18,  0,  113 },
  {  19,  0,   97 }, { 147,  0,  113 }, { 133,  0,  695 }, {   6,  0,  987 },
  { 134,  0, 1160 }, {   5,  0,    6 }, {   6,  0,  183 }, {   7,  0,  680 },
  {   7,  0,  978 }, {   7,  0, 1013 }, {   7,  0, 1055 }, {  12,  0,  230 },
  {  13,  0,  172 }, { 146,  0,   29 }, { 134, 11,  570 }, { 132, 11,  787 },
  { 134, 11,  518 }, {   6,  0,   29 }, { 139,  0,   63 }, { 132, 11,  516 },
  { 136, 11,  821 }, { 132,  0,  311 }, { 134,  0, 1740 }, {   7,  0,  170 },
  {   8,  0,   90 }, {   8,  0,  177 }, {   8,  0,  415 }, {  11,  0,  714 },
  {  14,  0,  281 }, { 136, 10,  735 }, { 134,  0, 1961 }, { 135, 11, 1405 },
  {   4, 11,   10 }, {   7, 11,  917 }, { 139, 11,  786 }, {   5, 10,  132 },
  {   9, 10,  486 }, {   9, 10,  715 }, {  10, 10,  458 }, {  11, 10,  373 },
  {  11, 10,  668 }, {  11, 10,  795 }, {  11, 10,  897 }, {  12, 10,  272 },
  {  12, 10,  424 }, {  12, 10,  539 }, {  12, 10,  558 }, {  14, 10,  245 },
  {  14, 10,  263 }, {  14, 10,  264 }, {  14, 10,  393 }, { 142, 10,  403 },
  {  11,  0,   91 }, {  13,  0,  129 }, {  15,  0,  101 }, { 145,  0,  125 },
  { 135,  0, 1132 }, {   4,  0,  494 }, {   6,  0,   74 }, {   7,  0,   44 },
  {   7,  0,  407 }, {  12,  0,   17 }, {  15,  0,    5 }, { 148,  0,   11 },
  { 133, 10,  379 }, {   5,  0,  270 }, {   5, 11,  684 }, {   6, 10,   89 },
  {   6, 10,  400 }, {   7, 10, 1569 }, {   7, 10, 1623 }, {   7, 10, 1850 },
  {   8, 10,  218 }, {   8, 10,  422 }, {   9, 10,  570 }, { 138, 10,  626 },
  {   4,  0,  276 }, { 133,  0,  296 }, {   6,  0, 1523 }, { 134, 11,   27 },
  {   6, 10,  387 }, {   7, 10,  882 }, { 141, 10,  111 }, {   6, 10,  224 },
  {   7, 10,  877 }, { 137, 10,  647 }, { 135, 10,  790 }, {   4,  0,    7 },
  {   5,  0,   90 }, {   5,  0,  158 }, {   6,  0,  542 }, {   7,  0,  221 },
  {   7,  0, 1574 }, {   9,  0,  490 }, {  10,  0,  540 }, {  11,  0,  443 },
  { 139,  0,  757 }, {   7,  0,  588 }, {   9,  0,  175 }, { 138,  0,  530 },
  { 135, 10,  394 }, { 142, 11,   23 }, { 134,  0,  786 }, { 135,  0,  580 },
  {   7,  0,   88 }, { 136,  0,  627 }, {   5,  0,  872 }, {   6,  0,   57 },
  {   7,  0,  471 }, {   9,  0,  447 }, { 137,  0,  454 }, {   6, 11,  342 },
  {   6, 11,  496 }, {   8, 11,  275 }, { 137, 11,  206 }, {   4, 11,  909 },
  { 133, 11,  940 }, {   6,  0,  735 }, { 132, 11,  891 }, {   8,  0,  845 },
  {   8,  0,  916 }, { 135, 10, 1409 }, {   5,  0,   31 }, { 134,  0,  614 },
  {  11,  0,  458 }, {  12,  0,   15 }, { 140,  0,  432 }, {   8,  0,  330 },
  { 140,  0,  477 }, {   4,  0,  530 }, {   5,  0,  521 }, {   7,  0, 1200 },
  {  10,  0,  460 }, { 132, 11,  687 }, {   6,  0,  424 }, { 135,  0, 1866 },
  {   9,  0,  569 }, {  12,  0,   12 }, {  12,  0,   81 }, {  12,  0,  319 },
  {  13,  0,   69 }, {  14,  0,  259 }, {  16,  0,   87 }, {  17,  0,    1 },
  {  17,  0,   21 }, {  17,  0,   24 }, {  18,  0,   15 }, {  18,  0,   56 },
  {  18,  0,   59 }, {  18,  0,  127 }, {  18,  0,  154 }, {  19,  0,   19 },
  { 148,  0,   31 }, {   7,  0, 1302 }, { 136, 10,   38 }, { 134, 11,  253 },
  {   5, 10,  261 }, {   7, 10,   78 }, {   7, 10,  199 }, {   8, 10,  815 },
  {   9, 10,  126 }, { 138, 10,  342 }, {   5,  0,  595 }, { 135,  0, 1863 },
  {   6, 11,   41 }, { 141, 11,  160 }, {   5,  0,   13 }, { 134,  0,  142 },
  {   6,  0,   97 }, {   7,  0,  116 }, {   8,  0,  322 }, {   8,  0,  755 },
  {   9,  0,  548 }, {  10,  0,  714 }, {  11,  0,  884 }, {  13,  0,  324 },
  {   7, 11, 1304 }, { 138, 11,  477 }, { 132, 10,  628 }, { 134, 11, 1718 },
  {   7, 10,  266 }, { 136, 10,  804 }, { 135, 10,  208 }, {   7,  0, 1021 },
  {   6, 10,   79 }, { 135, 10, 1519 }, {   7,  0, 1472 }, { 135,  0, 1554 },
  {   6, 11,  362 }, { 146, 11,   51 }, {   7,  0, 1071 }, {   7,  0, 1541 },
  {   7,  0, 1767 }, {   7,  0, 1806 }, {  11,  0,  162 }, {  11,  0,  242 },
  {  11,  0,  452 }, {  12,  0,  605 }, {  15,  0,   26 }, { 144,  0,   44 },
  { 136, 10,  741 }, { 133, 11,  115 }, { 145,  0,  115 }, { 134, 10,  376 },
  {   6,  0, 1406 }, { 134,  0, 1543 }, {   5, 11,  193 }, {  12, 11,  178 },
  {  13, 11,  130 }, { 145, 11,   84 }, { 135,  0, 1111 }, {   8,  0,    1 },
  {   9,  0,  650 }, {  10,  0,  326 }, {   5, 11,  705 }, { 137, 11,  606 },
  {   5,  0,  488 }, {   6,  0,  527 }, {   7,  0,  489 }, {   7,  0, 1636 },
  {   8,  0,  121 }, {   8,  0,  144 }, {   8,  0,  359 }, {   9,  0,  193 },
  {   9,  0,  241 }, {   9,  0,  336 }, {   9,  0,  882 }, {  11,  0,  266 },
  {  11,  0,  372 }, {  11,  0,  944 }, {  12,  0,  401 }, { 140,  0,  641 },
  { 135, 11,  174 }, {   6,  0,  267 }, {   7, 10,  244 }, {   7, 10,  632 },
  {   7, 10, 1609 }, {   8, 10,  178 }, {   8, 10,  638 }, { 141, 10,   58 },
  { 134,  0, 1983 }, { 134,  0, 1155 }, { 134,  0, 1575 }, { 134,  0, 1438 },
  {   9,  0,   31 }, {  10,  0,  244 }, {  10,  0,  699 }, {  12,  0,  149 },
  { 141,  0,  497 }, { 133,  0,  377 }, {   4, 11,  122 }, {   5, 11,  796 },
  {   5, 11,  952 }, {   6, 11, 1660 }, {   6, 11, 1671 }, {   8, 11,  567 },
  {   9, 11,  687 }, {   9, 11,  742 }, {  10, 11,  686 }, {  11, 11,  356 },
  {  11, 11,  682 }, { 140, 11,  281 }, { 145,  0,  101 }, {  11, 11,    0 },
  { 144, 11,   78 }, {   5, 11,  179 }, {   5, 10,  791 }, {   7, 11, 1095 },
  { 135, 11, 1213 }, {   8, 11,  372 }, {   9, 11,  122 }, { 138, 11,  175 },
  {   7, 10,  686 }, {   8, 10,   33 }, {   8, 10,  238 }, {  10, 10,  616 },
  {  11, 10,  467 }, {  11, 10,  881 }, {  13, 10,  217 }, {  13, 10,  253 },
  { 142, 10,  268 }, {   9,  0,  476 }, {   4, 11,   66 }, {   7, 11,  722 },
  { 135, 11,  904 }, {   7, 11,  352 }, { 137, 11,  684 }, { 135,  0, 2023 },
  { 135,  0, 1836 }, { 132, 10,  447 }, {   5,  0,  843 }, { 144,  0,   35 },
  { 137, 11,  779 }, { 141, 11,   35 }, {   4, 10,  128 }, {   5, 10,  415 },
  {   6, 10,  462 }, {   7, 10,  294 }, {   7, 10,  578 }, {  10, 10,  710 },
  { 139, 10,   86 }, { 132,  0,  554 }, { 133,  0,  536 }, { 136, 10,  587 },
  {   5,  0,  207 }, {   9,  0,   79 }, {  11,  0,  625 }, { 145,  0,    7 },
  {   7,  0, 1371 }, {   6, 10,  427 }, { 138, 10,  692 }, {   4,  0,  424 },
  {   4, 10,  195 }, { 135, 10,  802 }, {   8,  0,  785 }, { 133, 11,  564 },
  { 135,  0,  336 }, {   4,  0,  896 }, {   6,  0, 1777 }, { 134, 11,  556 },
  { 137, 11,  103 }, { 134, 10, 1683 }, {   7, 11,  544 }, {   8, 11,  719 },
  { 138, 11,   61 }, { 138, 10,  472 }, {   4, 11,    5 }, {   5, 11,  498 },
  { 136, 11,  637 }, {   7,  0,  750 }, {   9,  0,  223 }, {  11,  0,   27 },
  {  11,  0,  466 }, {  12,  0,  624 }, {  14,  0,  265 }, { 146,  0,   61 },
  {  12,  0,  238 }, {  18,  0,  155 }, {  12, 11,  238 }, { 146, 11,  155 },
  { 151, 10,   28 }, { 133, 11,  927 }, {  12,  0,  383 }, {   5, 10,    3 },
  {   8, 10,  578 }, {   9, 10,  118 }, {  10, 10,  705 }, { 141, 10,  279 },
  {   4, 11,  893 }, {   5, 11,  780 }, { 133, 11,  893 }, {   4,  0,  603 },
  { 133,  0,  661 }, {   4,  0,   11 }, {   6,  0,  128 }, {   7,  0,  231 },
  {   7,  0, 1533 }, {  10,  0,  725 }, {   5, 10,  229 }, {   5, 11,  238 },
  { 135, 11, 1350 }, {   8, 10,  102 }, {  10, 10,  578 }, {  10, 10,  672 },
  {  12, 10,  496 }, {  13, 10,  408 }, {  14, 10,  121 }, { 145, 10,  106 },
  { 132,  0,  476 }, { 134,  0, 1552 }, { 134, 11, 1729 }, {   8, 10,  115 },
  {   8, 10,  350 }, {   9, 10,  489 }, {  10, 10,  128 }, {  11, 10,  306 },
  {  12, 10,  373 }, {  14, 10,   30 }, {  17, 10,   79 }, {  19, 10,   80 },
  { 150, 10,   55 }, { 135,  0, 1807 }, {   4,  0,  680 }, {   4, 11,   60 },
  {   7, 11,  760 }, {   7, 11, 1800 }, {   8, 11,  314 }, {   9, 11,  700 },
  { 139, 11,  487 }, {   4, 10,  230 }, {   5, 10,  702 }, { 148, 11,   94 },
  { 132, 11,  228 }, { 139,  0,  435 }, {   9,  0,   20 }, {  10,  0,  324 },
  {  10,  0,  807 }, { 139,  0,  488 }, {   6, 10, 1728 }, { 136, 11,  419 },
  {   4, 10,  484 }, {  18, 10,   26 }, {  19, 10,   42 }, {  20, 10,   43 },
  {  21, 10,    0 }, {  23, 10,   27 }, { 152, 10,   14 }, { 135,  0, 1431 },
  { 133, 11,  828 }, {   5,  0,  112 }, {   6,  0,  103 }, {   6,  0,  150 },
  {   7,  0, 1303 }, {   9,  0,  292 }, {  10,  0,  481 }, {  20,  0,   13 },
  {   7, 11,  176 }, {   7, 11,  178 }, {   7, 11, 1110 }, {  10, 11,  481 },
  { 148, 11,   13 }, { 138,  0,  356 }, {   4, 11,   51 }, {   5, 11,   39 },
  {   6, 11,    4 }, {   7, 11,  591 }, {   7, 11,  849 }, {   7, 11,  951 },
  {   7, 11, 1129 }, {   7, 11, 1613 }, {   7, 11, 1760 }, {   7, 11, 1988 },
  {   9, 11,  434 }, {  10, 11,  754 }, {  11, 11,   25 }, {  11, 11,   37 },
  { 139, 11,  414 }, {   6,  0, 1963 }, { 134,  0, 2000 }, { 132, 10,  633 },
  {   6,  0, 1244 }, { 133, 11,  902 }, { 135, 11,  928 }, { 140,  0,   18 },
  { 138,  0,  204 }, { 135, 11, 1173 }, { 134,  0,  867 }, {   4,  0,  708 },
  {   8,  0,   15 }, {   9,  0,   50 }, {   9,  0,  386 }, {  11,  0,   18 },
  {  11,  0,  529 }, { 140,  0,  228 }, { 134, 11,  270 }, {   4,  0,  563 },
  {   7,  0,  109 }, {   7,  0,  592 }, {   7,  0,  637 }, {   7,  0,  770 },
  {   8,  0,  463 }, {   9,  0,   60 }, {   9,  0,  335 }, {   9,  0,  904 },
  {  10,  0,   73 }, {  11,  0,  434 }, {  12,  0,  585 }, {  13,  0,  331 },
  {  18,  0,  110 }, { 148,  0,   60 }, { 132,  0,  502 }, {  14, 11,  359 },
  {  19, 11,   52 }, { 148, 11,   47 }, {   6, 11,  377 }, {   7, 11, 1025 },
  {   9, 11,  613 }, { 145, 11,  104 }, {   6,  0,  347 }, {  10,  0,  161 },
  {   5, 10,   70 }, {   5, 10,  622 }, {   6, 10,  334 }, {   7, 10, 1032 },
  {   9, 10,  171 }, {  11, 10,   26 }, {  11, 10,  213 }, {  11, 10,  637 },
  {  11, 10,  707 }, {  12, 10,  202 }, {  12, 10,  380 }, {  13, 10,  226 },
  {  13, 10,  355 }, {  14, 10,  222 }, { 145, 10,   42 }, { 132, 11,  416 },
  {   4,  0,   33 }, {   5,  0,  102 }, {   6,  0,  284 }, {   7,  0, 1079 },
  {   7,  0, 1423 }, {   7,  0, 1702 }, {   8,  0,  470 }, {   9,  0,  554 },
  {   9,  0,  723 }, {  11,  0,  333 }, { 142, 11,  372 }, {   5, 11,  152 },
  {   5, 11,  197 }, {   7, 11,  340 }, {   7, 11,  867 }, {  10, 11,  548 },
  {  10, 11,  581 }, {  11, 11,    6 }, {  12, 11,    3 }, {  12, 11,   19 },
  {  14, 11,  110 }, { 142, 11,  289 }, {   7,  0,  246 }, { 135,  0,  840 },
  {   6,  0,   10 }, {   8,  0,  571 }, {   9,  0,  739 }, { 143,  0,   91 },
  {   6,  0,  465 }, {   7,  0, 1465 }, {   4, 10,   23 }, {   4, 10,  141 },
  {   5, 10,  313 }, {   5, 10, 1014 }, {   6, 10,   50 }, {   7, 10,  142 },
  {   7, 10,  559 }, {   8, 10,  640 }, {   9, 10,  460 }, {   9, 10,  783 },
  {  11, 10,  741 }, {  12, 10,  183 }, { 141, 10,  488 }, { 133,  0,  626 },
  { 136,  0,  614 }, { 138,  0,  237 }, {   7, 11,   34 }, {   7, 11,  190 },
  {   8, 11,   28 }, {   8, 11,  141 }, {   8, 11,  444 }, {   8, 11,  811 },
  {   9, 11,  468 }, {  11, 11,  334 }, {  12, 11,   24 }, {  12, 11,  386 },
  { 140, 11,  576 }, { 133, 11,  757 }, {   5,  0,   18 }, {   6,  0,  526 },
  {  13,  0,   24 }, {  13,  0,  110 }, {  19,  0,    5 }, { 147,  0,   44 },
  {   6,  0,  506 }, { 134, 11,  506 }, { 135, 11, 1553 }, {   4,  0,  309 },
  {   5,  0,  462 }, {   7,  0,  970 }, {   7,  0, 1097 }, {  22,  0,   30 },
  {  22,  0,   33 }, {   7, 11, 1385 }, {  11, 11,  582 }, {  11, 11,  650 },
  {  11, 11,  901 }, {  11, 11,  949 }, {  12, 11,  232 }, {  12, 11,  236 },
  {  13, 11,  413 }, {  13, 11,  501 }, { 146, 11,  116 }, {   9,  0,  140 },
  {   5, 10,  222 }, { 138, 10,  534 }, {   6,  0, 1056 }, { 137, 10,  906 },
  { 134,  0, 1704 }, { 138, 10,  503 }, { 134,  0, 1036 }, {   5, 10,  154 },
  {   7, 10, 1491 }, {  10, 10,  379 }, { 138, 10,  485 }, {   4, 11,  383 },
  { 133, 10,  716 }, { 134,  0, 1315 }, {   5,  0,   86 }, {   7,  0,  743 },
  {   9,  0,   85 }, {  10,  0,  281 }, {  10,  0,  432 }, {  11,  0,  825 },
  {  12,  0,  251 }, {  13,  0,  118 }, { 142,  0,  378 }, {   8,  0,  264 },
  {   4, 10,   91 }, {   5, 10,  388 }, {   5, 10,  845 }, {   6, 10,  206 },
  {   6, 10,  252 }, {   6, 10,  365 }, {   7, 10,  136 }, {   7, 10,  531 },
  { 136, 10,  621 }, {   5,  0,  524 }, { 133,  0,  744 }, {   5, 11,  277 },
  { 141, 11,  247 }, { 132, 11,  435 }, {  10,  0,  107 }, { 140,  0,  436 },
  { 132,  0,  927 }, {  10,  0,  123 }, {  12,  0,  670 }, { 146,  0,   94 },
  {   7,  0, 1149 }, {   9,  0,  156 }, { 138,  0,  957 }, {   5, 11,  265 },
  {   6, 11,  212 }, { 135, 11,   28 }, { 133,  0,  778 }, { 133,  0,  502 },
  {   8,  0,  196 }, {  10,  0,  283 }, { 139,  0,  406 }, { 135, 10,  576 },
  { 136, 11,  535 }, { 134,  0, 1312 }, {   5, 10,  771 }, {   5, 10,  863 },
  {   5, 10,  898 }, {   6, 10, 1632 }, {   6, 10, 1644 }, { 134, 10, 1780 },
  {   5,  0,  855 }, {   5, 10,  331 }, { 135, 11, 1487 }, { 132, 11,  702 },
  {   5, 11,  808 }, { 135, 11, 2045 }, {   7,  0, 1400 }, {   9,  0,  446 },
  { 138,  0,   45 }, { 140, 10,  632 }, { 132,  0, 1003 }, {   5, 11,  166 },
  {   8, 11,  739 }, { 140, 11,  511 }, {   5, 10,  107 }, {   7, 10,  201 },
  { 136, 10,  518 }, {   6, 10,  446 }, { 135, 10, 1817 }, { 134,  0, 1532 },
  { 134,  0, 1097 }, {   4, 11,  119 }, {   5, 11,  170 }, {   5, 11,  447 },
  {   7, 11, 1708 }, {   7, 11, 1889 }, {   9, 11,  357 }, {   9, 11,  719 },
  {  12, 11,  486 }, { 140, 11,  596 }, {   9, 10,  851 }, { 141, 10,  510 },
  {   7,  0,  612 }, {   8,  0,  545 }, {   8,  0,  568 }, {   8,  0,  642 },
  {   9,  0,  717 }, {  10,  0,  541 }, {  10,  0,  763 }, {  11,  0,  449 },
  {  12,  0,  489 }, {  13,  0,  153 }, {  13,  0,  296 }, {  14,  0,  138 },
  {  14,  0,  392 }, {  15,  0,   50 }, {  16,  0,    6 }, {  16,  0,   12 },
  {  20,  0,    9 }, { 132, 10,  504 }, {   4, 11,  450 }, { 135, 11, 1158 },
  {  11,  0,   54 }, {  13,  0,  173 }, {  13,  0,  294 }, {   5, 10,  883 },
  {   5, 10,  975 }, {   8, 10,  392 }, { 148, 10,    7 }, {  13,  0,  455 },
  {  15,  0,   99 }, {  15,  0,  129 }, { 144,  0,   68 }, { 135,  0,  172 },
  { 132, 11,  754 }, {   5, 10,  922 }, { 134, 10, 1707 }, { 134,  0, 1029 },
  {  17, 11,   39 }, { 148, 11,   36 }, {   4,  0,  568 }, {   5, 10,  993 },
  {   7, 10,  515 }, { 137, 10,   91 }, { 132,  0,  732 }, {  10,  0,  617 },
  { 138, 11,  617 }, { 134,  0,  974 }, {   7,  0,  989 }, {  10,  0,  377 },
  {  12,  0,  363 }, {  13,  0,   68 }, {  13,  0,   94 }, {  14,  0,  108 },
  { 142,  0,  306 }, { 136,  0,  733 }, { 132,  0,  428 }, {   7,  0, 1789 },
  { 135, 11, 1062 }, {   7,  0, 2015 }, { 140,  0,  665 }, { 135, 10, 1433 },
  {   5,  0,  287 }, {   7, 10,  921 }, {   8, 10,  580 }, {   8, 10,  593 },
  {   8, 10,  630 }, { 138, 10,   28 }, { 138,  0,  806 }, {   4, 10,  911 },
  {   5, 10,  867 }, {   5, 10, 1013 }, {   7, 10, 2034 }, {   8, 10,  798 },
  { 136, 10,  813 }, { 134,  0, 1539 }, {   8, 11,  523 }, { 150, 11,   34 },
  { 135, 11,  740 }, {   7, 11,  238 }, {   7, 11, 2033 }, {   8, 11,  120 },
  {   8, 11,  188 }, {   8, 11,  659 }, {   9, 11,  598 }, {  10, 11,  466 },
  {  12, 11,  342 }, {  12, 11,  588 }, {  13, 11,  503 }, {  14, 11,  246 },
  { 143, 11,   92 }, {   7,  0, 1563 }, { 141,  0,  182 }, {   5, 10,  135 },
  {   6, 10,  519 }, {   7, 10, 1722 }, {  10, 10,  271 }, {  11, 10,  261 },
  { 145, 10,   54 }, {  14, 10,  338 }, { 148, 10,   81 }, {   7,  0,  484 },
  {   4, 10,  300 }, { 133, 10,  436 }, { 145, 11,  114 }, {   6,  0, 1623 },
  { 134,  0, 1681 }, { 133, 11,  640 }, {   4, 11,  201 }, {   7, 11, 1744 },
  {   8, 11,  602 }, {  11, 11,  247 }, {  11, 11,  826 }, { 145, 11,   65 },
  {   8, 11,  164 }, { 146, 11,   62 }, {   6,  0, 1833 }, {   6,  0, 1861 },
  { 136,  0,  878 }, { 134,  0, 1569 }, {   8, 10,  357 }, {  10, 10,  745 },
  {  14, 10,  426 }, {  17, 10,   94 }, { 147, 10,   57 }, {  12,  0,   93 },
  {  12,  0,  501 }, {  13,  0,  362 }, {  14,  0,  151 }, {  15,  0,   40 },
  {  15,  0,   59 }, {  16,  0,   46 }, {  17,  0,   25 }, {  18,  0,   14 },
  {  18,  0,  134 }, {  19,  0,   25 }, {  19,  0,   69 }, {  20,  0,   16 },
  {  20,  0,   19 }, {  20,  0,   66 }, {  21,  0,   23 }, {  21,  0,   25 },
  { 150,  0,   42 }, {   6,  0, 1748 }, {   8,  0,  715 }, {   9,  0,  802 },
  {  10,  0,   46 }, {  10,  0,  819 }, {  13,  0,  308 }, {  14,  0,  351 },
  {  14,  0,  363 }, { 146,  0,   67 }, { 132,  0,  994 }, {   4,  0,   63 },
  { 133,  0,  347 }, { 132,  0,  591 }, { 133,  0,  749 }, {   7, 11, 1577 },
  {  10, 11,  304 }, {  10, 11,  549 }, {  11, 11,  424 }, {  12, 11,  365 },
  {  13, 11,  220 }, {  13, 11,  240 }, { 142, 11,   33 }, { 133,  0,  366 },
  {   7,  0,  557 }, {  12,  0,  547 }, {  14,  0,   86 }, { 133, 10,  387 },
  { 135,  0, 1747 }, { 132, 11,  907 }, {   5, 11,  100 }, {  10, 11,  329 },
  {  12, 11,  416 }, { 149, 11,   29 }, {   4, 10,    6 }, {   5, 10,  708 },
  { 136, 10,   75 }, {   7, 10, 1351 }, {   9, 10,  581 }, {  10, 10,  639 },
  {  11, 10,  453 }, { 140, 10,  584 }, {   7,  0,   89 }, { 132, 10,  303 },
  { 138, 10,  772 }, { 132, 11,  176 }, {   5, 11,  636 }, {   5, 11,  998 },
  {   8, 11,   26 }, { 137, 11,  358 }, {   7, 11,    9 }, {   7, 11, 1508 },
  {   9, 11,  317 }, {  10, 11,  210 }, {  10, 11,  292 }, {  10, 11,  533 },
  {  11, 11,  555 }, {  12, 11,  526 }, {  12, 11,  607 }, {  13, 11,  263 },
  {  13, 11,  459 }, { 142, 11,  271 }, { 134,  0, 1463 }, {   6,  0,  772 },
  {   6,  0, 1137 }, { 139, 11,  595 }, {   7,  0,  977 }, { 139, 11,   66 },
  { 138,  0,  893 }, {  20,  0,   48 }, { 148, 11,   48 }, {   5,  0,  824 },
  { 133,  0,  941 }, { 134, 11,  295 }, {   7,  0, 1543 }, {   7,  0, 1785 },
  {  10,  0,  690 }, {   4, 10,  106 }, { 139, 10,  717 }, {   7,  0,  440 },
  {   8,  0,  230 }, { 139,  0,  106 }, {   5, 10,  890 }, { 133, 10,  988 },
  {   6, 10,  626 }, { 142, 10,  431 }, {  10, 11,  127 }, { 141, 11,   27 },
  {  17,  0,   32 }, {  10, 10,  706 }, { 150, 10,   44 }, { 132,  0,  216 },
  { 137,  0,  332 }, {   4, 10,  698 }, { 136, 11,  119 }, { 139, 11,  267 },
  { 138, 10,   17 }, {  11, 11,  526 }, {  11, 11,  939 }, { 141, 11,  290 },
  {   7, 11, 1167 }, {  11, 11,  934 }, {  13, 11,  391 }, { 145, 11,   76 },
  { 139, 11,   39 }, { 134, 10,   84 }, {   4,  0,  914 }, {   5,  0,  800 },
  { 133,  0,  852 }, {  10,  0,  416 }, { 141,  0,  115 }, {   7,  0,  564 },
  { 142,  0,  168 }, {   4,  0,  918 }, { 133,  0,  876 }, { 134,  0, 1764 },
  { 152,  0,    3 }, {   4,  0,   92 }, {   5,  0,  274 }, {   7, 11,  126 },
  { 136, 11,   84 }, { 140, 10,  498 }, { 136, 11,  790 }, {   8,  0,  501 },
  {   5, 10,  986 }, {   6, 10,  130 }, {   7, 10, 1582 }, {   8, 10,  458 },
  {  10, 10,  101 }, {  10, 10,  318 }, { 138, 10,  823 }, {   6, 11,   64 },
  {  12, 11,  377 }, { 141, 11,  309 }, {   5,  0,  743 }, { 138,  0,  851 },
  {   4,  0,   49 }, {   7,  0,  280 }, { 135,  0, 1633 }, { 134,  0,  879 },
  { 136,  0,   47 }, {   7, 10, 1644 }, { 137, 10,  129 }, { 132,  0,  865 },
  { 134,  0, 1202 }, {   9, 11,   34 }, { 139, 11,  484 }, { 135, 10,  997 },
  {   5,  0,  272 }, {   5,  0,  908 }, {   5,  0,  942 }, {   8,  0,  197 },
  {   9,  0,   47 }, {  11,  0,  538 }, { 139,  0,  742 }, {   6, 11, 1700 },
  {   7, 11,   26 }, {   7, 11,  293 }, {   7, 11,  382 }, {   7, 11, 1026 },
  {   7, 11, 1087 }, {   7, 11, 2027 }, {   8, 11,   24 }, {   8, 11,  114 },
  {   8, 11,  252 }, {   8, 11,  727 }, {   8, 11,  729 }, {   9, 11,   30 },
  {   9, 11,  199 }, {   9, 11,  231 }, {   9, 11,  251 }, {   9, 11,  334 },
  {   9, 11,  361 }, {   9, 11,  488 }, {   9, 11,  712 }, {  10, 11,   55 },
  {  10, 11,   60 }, {  10, 11,  232 }, {  10, 11,  332 }, {  10, 11,  384 },
  {  10, 11,  396 }, {  10, 11,  504 }, {  10, 11,  542 }, {  10, 11,  652 },
  {  11, 11,   20 }, {  11, 11,   48 }, {  11, 11,  207 }, {  11, 11,  291 },
  {  11, 11,  298 }, {  11, 11,  342 }, {  11, 11,  365 }, {  11, 11,  394 },
  {  11, 11,  620 }, {  11, 11,  705 }, {  11, 11, 1017 }, {  12, 11,  123 },
  {  12, 11,  340 }, {  12, 11,  406 }, {  12, 11,  643 }, {  13, 11,   61 },
  {  13, 11,  269 }, {  13, 11,  311 }, {  13, 11,  319 }, {  13, 11,  486 },
  {  14, 11,  234 }, {  15, 11,   62 }, {  15, 11,   85 }, {  16, 11,   71 },
  {  18, 11,  119 }, { 148, 11,  105 }, {   6,  0, 1455 }, { 150, 11,   37 },
  { 135, 10, 1927 }, { 135,  0, 1911 }, { 137,  0,  891 }, {   7, 10, 1756 },
  { 137, 10,   98 }, {   7, 10, 1046 }, { 139, 10,  160 }, { 132,  0,  761 },
  {   6, 11,  379 }, {   7, 11,  270 }, {   7, 11, 1116 }, {   8, 11,  176 },
  {   8, 11,  183 }, {   9, 11,  432 }, {   9, 11,  661 }, {  12, 11,  247 },
  {  12, 11,  617 }, { 146, 11,  125 }, {   6, 10,   45 }, {   7, 10,  433 },
  {   8, 10,  129 }, {   9, 10,   21 }, {  10, 10,  392 }, {  11, 10,   79 },
  {  12, 10,  499 }, {  13, 10,  199 }, { 141, 10,  451 }, {   4,  0,  407 },
  {   5, 11,  792 }, { 133, 11,  900 }, { 132,  0,  560 }, { 135,  0,  183 },
  {  13,  0,  490 }, {   7, 10,  558 }, { 136, 10,  353 }, {   4,  0,  475 },
  {   6,  0,  731 }, {  11,  0,   35 }, {  13,  0,   71 }, {  13,  0,  177 },
  {  14,  0,  422 }, { 133, 10,  785 }, {   8, 10,   81 }, {   9, 10,  189 },
  {   9, 10,  201 }, {  11, 10,  478 }, {  11, 10,  712 }, { 141, 10,  338 },
  {   4,  0,  418 }, {   4,  0,  819 }, { 133, 10,  353 }, { 151, 10,   26 },
  {   4, 11,  901 }, { 133, 11,  776 }, { 132,  0,  575 }, {   7,  0,  818 },
  {  16,  0,   92 }, {  17,  0,   14 }, {  17,  0,   45 }, {  18,  0,   75 },
  { 148,  0,   18 }, {   6,  0,  222 }, {   7,  0,  636 }, {   7,  0, 1620 },
  {   8,  0,  409 }, {   9,  0,  693 }, { 139,  0,   77 }, {   6, 10,   25 },
  {   7, 10,  855 }, {   7, 10, 1258 }, { 144, 10,   32 }, {   6,  0, 1880 },
  {   6,  0, 1887 }, {   6,  0, 1918 }, {   6,  0, 1924 }, {   9,  0,  967 },
  {   9,  0,  995 }, {   9,  0, 1015 }, {  12,  0,  826 }, {  12,  0,  849 },
  {  12,  0,  857 }, {  12,  0,  860 }, {  12,  0,  886 }, {  12,  0,  932 },
  {  18,  0,  228 }, {  18,  0,  231 }, { 146,  0,  240 }, { 134,  0,  633 },
  { 134,  0, 1308 }, {   4, 11,   37 }, {   5, 11,  334 }, { 135, 11, 1253 },
  {  10,  0,   86 }, {   4, 10,    4 }, {   7, 10, 1118 }, {   7, 10, 1320 },
  {   7, 10, 1706 }, {   8, 10,  277 }, {   9, 10,  622 }, {  11, 10,  724 },
  {  12, 10,  350 }, {  12, 10,  397 }, {  13, 10,   28 }, {  13, 10,  159 },
  {  15, 10,   89 }, {  18, 10,    5 }, {  19, 10,    9 }, {  20, 10,   34 },
  { 150, 10,   47 }, { 132, 11,  508 }, { 137, 11,  448 }, {  12, 11,  107 },
  { 146, 11,   31 }, { 132,  0,  817 }, { 134,  0,  663 }, { 133,  0,  882 },
  { 134,  0,  914 }, { 132, 11,  540 }, { 132, 11,  533 }, { 136, 11,  608 },
  {   8,  0,  885 }, { 138,  0,  865 }, { 132,  0,  426 }, {   6,  0,   58 },
  {   7,  0,  745 }, {   7,  0, 1969 }, {   8,  0,  399 }, {   8,  0,  675 },
  {   9,  0,  479 }, {   9,  0,  731 }, {  10,  0,  330 }, {  10,  0,  593 },
  {  10,  0,  817 }, {  11,  0,   32 }, {  11,  0,  133 }, {  11,  0,  221 },
  { 145,  0,   68 }, { 134, 10,  255 }, {   7,  0,  102 }, { 137,  0,  538 },
  { 137, 10,  216 }, {   7, 11,  253 }, { 136, 11,  549 }, { 135, 11,  912 },
  {   9, 10,  183 }, { 139, 10,  286 }, {  11, 10,  956 }, { 151, 10,    3 },
  {   8, 11,  527 }, {  18, 11,   60 }, { 147, 11,   24 }, {   4, 10,  536 },
  {   7, 10, 1141 }, {  10, 10,  723 }, { 139, 10,  371 }, { 133, 11,  920 },
  {   7,  0,  876 }, { 135, 10,  285 }, { 135, 10,  560 }, { 132, 10,  690 },
  { 142, 11,  126 }, {  11, 10,   33 }, {  12, 10,  571 }, { 149, 10,    1 },
  { 133,  0,  566 }, {   9,  0,  139 }, {  10,  0,  399 }, {  11,  0,  469 },
  {  12,  0,  634 }, {  13,  0,  223 }, { 132, 11,  483 }, {   6,  0,   48 },
  { 135,  0,   63 }, {  18,  0,   12 }, {   7, 10, 1862 }, {  12, 10,  491 },
  {  12, 10,  520 }, {  13, 10,  383 }, { 142, 10,  244 }, { 135, 11, 1665 },
  { 132, 11,  448 }, {   9, 11,  495 }, { 146, 11,  104 }, {   6,  0,  114 },
  {   7,  0, 1224 }, {   7,  0, 1556 }, { 136,  0,    3 }, {   4, 10,  190 },
  { 133, 10,  554 }, {   8,  0,  576 }, {   9,  0,  267 }, { 133, 10, 1001 },
  { 133, 10,  446 }, { 133,  0,  933 }, { 139, 11, 1009 }, {   8, 11,  653 },
  {  13, 11,   93 }, { 147, 11,   14 }, {   6,  0,  692 }, {   6,  0,  821 },
  { 134,  0, 1077 }, {   5, 11,  172 }, { 135, 11,  801 }, { 138,  0,  752 },
  {   4,  0,  375 }, { 134,  0,  638 }, { 134,  0, 1011 }, { 140, 11,  540 },
  {   9,  0,   96 }, { 133, 11,  260 }, { 139, 11,  587 }, { 135, 10, 1231 },
  {  12,  0,   30 }, {  13,  0,  148 }, {  14,  0,   87 }, {  14,  0,  182 },
  {  16,  0,   42 }, {  20,  0,   70 }, { 132, 10,  304 }, {   6,  0, 1398 },
  {   7,  0,   56 }, {   7,  0, 1989 }, {   8,  0,  337 }, {   8,  0,  738 },
  {   9,  0,  600 }, {  12,  0,   37 }, {  13,  0,  447 }, { 142,  0,   92 },
  { 138,  0,  666 }, {   5,  0,  394 }, {   7,  0,  487 }, { 136,  0,  246 },
  {   9,  0,  437 }, {   6, 10,   53 }, {   6, 10,  199 }, {   7, 10, 1408 },
  {   8, 10,   32 }, {   8, 10,   93 }, {  10, 10,  397 }, {  10, 10,  629 },
  {  11, 10,  593 }, {  11, 10,  763 }, {  13, 10,  326 }, { 145, 10,   35 },
  { 134, 10,  105 }, {   9,  0,  320 }, {  10,  0,  506 }, { 138, 10,  794 },
  {   7, 11,   57 }, {   8, 11,  167 }, {   8, 11,  375 }, {   9, 11,   82 },
  {   9, 11,  561 }, {  10, 11,  620 }, {  10, 11,  770 }, {  11, 10,  704 },
  { 141, 10,  396 }, {   6,  0, 1003 }, {   5, 10,  114 }, {   5, 10,  255 },
  { 141, 10,  285 }, {   7,  0,  866 }, { 135,  0, 1163 }, { 133, 11,  531 },
  { 132,  0,  328 }, {   7, 10, 2035 }, {   8, 10,   19 }, {   9, 10,   89 },
  { 138, 10,  831 }, {   8, 11,  194 }, { 136, 11,  756 }, { 136,  0, 1000 },
  {   5, 11,  453 }, { 134, 11,  441 }, {   4,  0,  101 }, {   5,  0,  833 },
  {   7,  0, 1171 }, { 136,  0,  744 }, { 133,  0,  726 }, { 136, 10,  746 },
  { 138,  0,  176 }, {   6,  0,    9 }, {   6,  0,  397 }, {   7,  0,   53 },
  {   7,  0, 1742 }, {  10,  0,  632 }, {  11,  0,  828 }, { 140,  0,  146 },
  { 135, 11,   22 }, { 145, 11,   64 }, { 132,  0,  839 }, {  11,  0,  417 },
  {  12,  0,  223 }, { 140,  0,  265 }, {   4, 11,  102 }, {   7, 11,  815 },
  {   7, 11, 1699 }, { 139, 11,  964 }, {   5, 10,  955 }, { 136, 10,  814 },
  {   6,  0, 1931 }, {   6,  0, 2007 }, {  18,  0,  246 }, { 146,  0,  247 },
  {   8,  0,  198 }, {  11,  0,   29 }, { 140,  0,  534 }, { 135,  0, 1771 },
  {   6,  0,  846 }, {   7, 11, 1010 }, {  11, 11,  733 }, {  11, 11,  759 },
  {  12, 11,  563 }, {  13, 11,   34 }, {  14, 11,  101 }, {  18, 11,   45 },
  { 146, 11,  129 }, {   4,  0,  186 }, {   5,  0,  157 }, {   8,  0,  168 },
  { 138,  0,    6 }, { 132, 11,  899 }, { 133, 10,   56 }, { 148, 10,  100 },
  { 133,  0,  875 }, {   5,  0,  773 }, {   5,  0,  991 }, {   6,  0, 1635 },
  { 134,  0, 1788 }, {   6,  0, 1274 }, {   9,  0,  477 }, { 141,  0,   78 },
  {   4,  0,  639 }, {   7,  0,  111 }, {   8,  0,  581 }, {  12,  0,  177 },
  {   6, 11,   52 }, {   9, 11,  104 }, {   9, 11,  559 }, {  10, 10,    4 },
  {  10, 10,   13 }, {  11, 10,  638 }, {  12, 11,  308 }, {  19, 11,   87 },
  { 148, 10,   57 }, { 132, 11,  604 }, {   4, 11,  301 }, { 133, 10,  738 },
  { 133, 10,  758 }, { 134,  0, 1747 }, {   7, 11, 1440 }, {  11, 11,  854 },
  {  11, 11,  872 }, {  11, 11,  921 }, {  12, 11,  551 }, {  13, 11,  472 },
  { 142, 11,  367 }, {   7,  0, 1364 }, {   7,  0, 1907 }, { 141,  0,  158 },
  { 134,  0,  873 }, {   4,  0,  404 }, {   4,  0,  659 }, {   7,  0,  552 },
  { 135,  0,  675 }, { 135, 10, 1112 }, { 139, 10,  328 }, {   7, 11,  508 },
  { 137, 10,  133 }, { 133,  0,  391 }, {   5, 10,  110 }, {   6, 10,  169 },
  {   6, 10, 1702 }, {   7, 10,  400 }, {   8, 10,  538 }, {   9, 10,  184 },
  {   9, 10,  524 }, { 140, 10,  218 }, {   6, 11,  310 }, {   7, 11, 1849 },
  {   8, 11,   72 }, {   8, 11,  272 }, {   8, 11,  431 }, {   9, 11,   12 },
  {   9, 11,  351 }, {  10, 11,  563 }, {  10, 11,  630 }, {  10, 11,  810 },
  {  11, 11,  367 }, {  11, 11,  599 }, {  11, 11,  686 }, { 140, 11,  672 },
  {   5,  0,  540 }, {   6,  0, 1697 }, { 136,  0,  668 }, { 132,  0,  883 },
  { 134,  0,   78 }, {  12,  0,  628 }, {  18,  0,   79 }, {   6, 10,  133 },
  {   9, 10,  353 }, { 139, 10,  993 }, {   6, 11,  181 }, {   7, 11,  537 },
  {   8, 11,   64 }, {   9, 11,  127 }, {  10, 11,  496 }, {  12, 11,  510 },
  { 141, 11,  384 }, {   6, 10,   93 }, {   7, 10, 1422 }, {   7, 10, 1851 },
  {   8, 10,  673 }, {   9, 10,  529 }, { 140, 10,   43 }, { 137, 10,  371 },
  { 134,  0, 1460 }, { 134,  0,  962 }, {   4, 11,  244 }, { 135, 11,  233 },
  {   9, 10,   25 }, {  10, 10,  467 }, { 138, 10,  559 }, {   4, 10,  335 },
  { 135, 10,  942 }, { 133,  0,  460 }, { 135, 11,  334 }, { 134, 11, 1650 },
  {   4,  0,  199 }, { 139,  0,   34 }, {   5, 10,  601 }, {   8, 10,   39 },
  {  10, 10,  773 }, {  11, 10,   84 }, {  12, 10,  205 }, { 142, 10,    1 },
  { 133, 10,  870 }, { 134,  0,  388 }, {  14,  0,  474 }, { 148,  0,  120 },
  { 133, 11,  369 }, { 139,  0,  271 }, {   4,  0,  511 }, {   9,  0,  333 },
  {   9,  0,  379 }, {  10,  0,  602 }, {  11,  0,  441 }, {  11,  0,  723 },
  {  11,  0,  976 }, {  12,  0,  357 }, { 132, 10,  181 }, { 134,  0,  608 },
  { 134, 10, 1652 }, {  22,  0,   49 }, { 137, 11,  338 }, { 140,  0,  988 },
  { 134,  0,  617 }, {   5,  0,  938 }, { 136,  0,  707 }, { 132, 10,   97 },
  {   5, 10,  147 }, {   6, 10,  286 }, {   7, 10, 1362 }, { 141, 10,  176 },
  {   6,  0,  756 }, { 134,  0, 1149 }, { 133, 11,  896 }, {   6, 10,  375 },
  {   7, 10,  169 }, {   7, 10,  254 }, { 136, 10,  780 }, { 134,  0, 1583 },
  { 135, 10, 1447 }, { 139,  0,  285 }, {   7, 11, 1117 }, {   8, 11,  393 },
  { 136, 11,  539 }, { 135,  0,  344 }, {   6,  0,  469 }, {   7,  0, 1709 },
  { 138,  0,  515 }, {   5, 10,  629 }, { 135, 10, 1549 }, {   5, 11,    4 },
  {   5, 11,  810 }, {   6, 11,   13 }, {   6, 11,  538 }, {   6, 11, 1690 },
  {   6, 11, 1726 }, {   7, 11,  499 }, {   7, 11, 1819 }, {   8, 11,  148 },
  {   8, 11,  696 }, {   8, 11,  791 }, {  12, 11,  125 }, {  13, 11,   54 },
  { 143, 11,    9 }, { 135, 11, 1268 }, { 137,  0,  404 }, { 132,  0,  500 },
  {   5,  0,   68 }, { 134,  0,  383 }, {  11,  0,  216 }, { 139,  0,  340 },
  {   4, 11,  925 }, {   5, 11,  803 }, {   8, 11,  698 }, { 138, 11,  828 },
  {   4,  0,  337 }, {   6,  0,  353 }, {   7,  0, 1934 }, {   8,  0,  488 },
  { 137,  0,  429 }, {   7,  0,  236 }, {   7,  0, 1795 }, {   8,  0,  259 },
  {   9,  0,  135 }, {   9,  0,  177 }, {   9,  0,  860 }, {  10,  0,  825 },
  {  11,  0,  115 }, {  11,  0,  370 }, {  11,  0,  405 }, {  11,  0,  604 },
  {  12,  0,   10 }, {  12,  0,  667 }, {  12,  0,  669 }, {  13,  0,   76 },
  {  14,  0,  310 }, {  15,  0,   76 }, {  15,  0,  147 }, { 148,  0,   23 },
  {   4,  0,   15 }, {   4,  0,  490 }, {   5,  0,   22 }, {   6,  0,  244 },
  {   7,  0,   40 }, {   7,  0,  200 }, {   7,  0,  906 }, {   7,  0, 1199 },
  {   9,  0,  616 }, {  10,  0,  716 }, {  11,  0,  635 }, {  11,  0,  801 },
  { 140,  0,  458 }, {  12,  0,  756 }, { 132, 10,  420 }, { 134,  0, 1504 },
  {   6,  0,  757 }, { 133, 11,  383 }, {   6,  0, 1266 }, { 135,  0, 1735 },
  {   5,  0,  598 }, {   7,  0,  791 }, {   8,  0,  108 }, {   9,  0,  123 },
  {   7, 10, 1570 }, { 140, 10,  542 }, { 142, 11,  410 }, {   9, 11,  660 },
  { 138, 11,  347 }
};

#if defined(__cplusplus) || defined(c_plusplus)
}  /* extern "C" */
#endif

#endif  /* BROTLI_ENC_STATIC_DICT_LUT_H_ */
