# automatically generated file, don't edit



# Copyright 2025 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::BG;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20250605193633;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '1',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '2',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d)(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            43[1-6]|
            70[1-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '2',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [356]|
            4[124-7]|
            7[1-9]|
            8[1-6]|
            9[1-7]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{2,3})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            (?:
              70|
              8
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{3})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            43[1-7]|
            7
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [48]|
            9[08]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '9',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                }
              ];

my $validators = {
                'fixed_line' => '
          2\\d{5,7}|
          (?:
            43[1-6]|
            70[1-9]
          )\\d{4,5}|
          (?:
            [36]\\d|
            4[124-7]|
            [57][1-9]|
            8[1-6]|
            9[1-7]
          )\\d{5,6}
        ',
                'geographic' => '
          2\\d{5,7}|
          (?:
            43[1-6]|
            70[1-9]
          )\\d{4,5}|
          (?:
            [36]\\d|
            4[124-7]|
            [57][1-9]|
            8[1-6]|
            9[1-7]
          )\\d{5,6}
        ',
                'mobile' => '
          (?:
            43[07-9]|
            99[69]\\d
          )\\d{5}|
          (?:
            8[7-9]|
            98
          )\\d{7}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(700\\d{5})|(90\\d{6})',
                'toll_free' => '
          (?:
            00800\\d\\d|
            800
          )\\d{5}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"3593514", "Chernogorovo\,\ Pazardzhik",
"3594582", "Gradets\,\ Sliven",
"3596117", "Debelets\,\ V\.\ Tarnovo",
"35961603", "Lozen\,\ V\.\ Tarnovo",
"3596732", "Sennik",
"3597146", "Chernyovo",
"3596039", "Opaka",
"3596954", "Vrabevo",
"3599318", "Bukovets\,\ Vidin",
"3595767", "Zhitnitsa\,\ Dobr\.",
"3598642", "Dulovo",
"3596066", "Buynovo\,\ Targ\.",
"35961406", "Karantsi",
"3594526", "Mlekarevo",
"3594799", "Golyam\ manastir",
"3598669", "Garvan\,\ Silistra",
"35974202", "Klyuch",
"359723", "Botevgrad",
"3593126", "Trud",
"3595554", "Momina\ tsarkva",
"35963568", "Bukovlak",
"35931258", "Glavatar",
"3598636", "Glavinitsa\,\ Silistra",
"35984394", "Duhovets",
"3593933", "Stransko",
"3597717", "Divotino",
"3593077", "Sredets\,\ Smol\.",
"3597132", "Radotina",
"3593323", "Bolyartsi\,\ Plovdiv",
"3599517", "Kobilyak",
"35993342", "Kireevo",
"3593556", "Radilovo",
"3593589", "Tserovo\,\ Pazardzhik",
"35991180", "Lesura",
"35951428", "Gospodinovo\,\ Varna",
"3595124", "Komarevo\,\ Varna",
"3598442", "Zavet\,\ Razgrad",
"359860", "Silistra",
"35984766", "Kamenar\,\ Razgrad",
"35936402", "Gorna\ kula",
"35963565", "Mechka\,\ Pleven",
"3595310", "Radko\ Dimitrievo",
"359707", "Sapareva\ banya",
"3596916", "Brestovo\,\ Lovech",
"3593538", "Elshitsa",
"3594353", "Srednogorovo",
"3597103", "Brusen\,\ Sofia",
"35947203", "Trankovo\,\ Yambol",
"35930410", "Breze\,\ Smol\.",
"3594777", "Tenevo",
"3594138", "Gita",
"3597174", "Kalotina",
"3595516", "Indzhe\ voyvoda",
"3598167", "Tserovets",
"3595131", "Valchi\ dol",
"3594156", "Aprilovo\,\ St\.\ Zagora",
"3595135", "Stefan\ Karadzha\,\ Varna",
"35993212", "Karbintsi",
"35941149", "Lovets\,\ St\.\ Zagora",
"3593927", "Chernogorovo\,\ Hask\.",
"3599325", "Belo\ pole\,\ Vidin",
"35959403", "Rechitsa",
"3597447", "Dobrinishte",
"3597149", "Zhivkovo\,\ Sofia",
"3596728", "Burya",
"3596941", "Letnitsa",
"3594347", "Rozovo\,\ St\.\ Zagora",
"35961303", "Gorna\ Lipnitsa",
"3594552", "Stara\ reka\,\ Sliven",
"3595392", "Mengishevo",
"35995276", "Draganitsa",
"3596069", "Vasil\ Levski\,\ Targ\.",
"3594529", "Sadievo\,\ Sliven",
"3593148", "Yoakim\ Gruevo",
"359335", "Karlovo",
"3595112", "Beloslav",
"3595750", "Kableshkovo\,\ Dobr\.",
"3595737", "Lyulyakovo\,\ Dobr\.",
"3596036", "Sadina",
"3596984", "Bezhanovo\,\ Lovech",
"3594713", "Stara\ reka\,\ Yambol",
"3598639", "Kolarovo\,\ Silistra",
"359750", "Borovets\,\ Sofia",
"359519", "Devnya",
"3593129", "Skutare",
"359726", "Svoge",
"3596042", "Iliyno",
"3594796", "General\ Toshevo\,\ Yambol",
"3598666", "Tutrakan",
"35941356", "Rupkite",
"35951314", "Voyvodino",
"3597162", "Lakatnik",
"3598123", "Bosilkovtsi",
"3593710", "Uzundzhovo",
"3593633", "Rogozche",
"35963577", "Pelishat",
"3593559", "Kapitan\ Dimitrievo",
"3593586", "Borimechkovo",
"3596173", "Dolna\ Oryahovitsa",
"3593522", "Gelemenovo",
"3595723", "Gurkovo\,\ Dobr\.",
"3593568", "Vinogradets",
"3596919", "Slatina\,\ Lovech",
"3596570", "Deventsi",
"3595519", "Zidarovo",
"3594122", "Elenino",
"35974204", "Gega",
"35984723", "Dyankovo",
"3596711", "Kozi\ rog",
"3597920", "Skrinyano",
"3598137", "Golyamo\ Vranovo",
"3595161", "Vetrino",
"3595165", "Nevsha",
"3594107", "Sredets\,\ St\.\ Zagora",
"35941144", "Kaloyanovets",
"3598150", "Semerdzhievo",
"35984392", "Belintsi",
"3599742", "Yakimovo",
"3595313", "Madara",
"35961397", "Musina",
"3595535", "Lyaskovo\,\ Burgas",
"35969242", "Presyaka",
"35984464", "Veselets\,\ Razgrad",
"35967392", "Yavorets",
"3596990", "Malak\ izvor\,\ Lovech",
"3593643", "Golyama\ Chinka",
"3595396", "Lovets\,\ Shumen",
"3594556", "Sotirya",
"3595116", "Krumovo\,\ Varna",
"3598649", "Yarebitsa",
"3596032", "Zaraevo",
"35941484", "Zemlen",
"3598628", "Tsar\ Asen\,\ Silistra",
"3593138", "Vedrare",
"3593777", "Mezek",
"3594792", "Botevo\,\ Yambol",
"35935255", "Rosen\,\ Pazardzhik",
"35960458", "Verentsi",
"3598662", "Dobrotitsa\,\ Silistra",
"3595747", "Vaklino",
"3597188", "Petrich\,\ Sofia",
"3596046", "Vrani\ kon",
"35961606", "Vladislav",
"3597437", "Melnik",
"3597139", "Dzhurovo",
"3596935", "Sopot\,\ Lovech",
"3595590", "Zhitosvyat",
"3594350", "Gorno\ Izvorovo",
"3596931", "Ugarchin",
"3593156", "Shishmantsi",
"3594337", "Yasenovo\,\ St\.\ Zagora",
"3596325", "Kozlovets",
"3595524", "Ekzarh\ Antimovo",
"35961403", "Orlovets",
"3597166", "Vlado\ Trichkov",
"3596321", "Gorna\ Studena",
"35984737", "Raynino",
"3598147", "Baniska",
"3596003", "Preselets",
"3599117", "Krivodol",
"3595917", "Izvor\,\ Burgas",
"3597532", "Bukovo\,\ Blag\.",
"359777", "Radomir",
"359301", "Smolyan",
"3594514", "Krushare",
"3593582", "Momina\ klisura",
"35969249", "Doyrentsi",
"35967399", "Malki\ Varshets",
"3595783", "Kotlentsi",
"3596074", "Lyubichevo",
"3593705", "Vaglarovo",
"35935258", "Tsar\ Asen\,\ Pazardzhik",
"3593526", "Dinkata",
"35937421", "Dolno\ pole",
"3593701", "Elena\,\ Hask\.",
"359748", "Simitli",
"35959406", "Razboyna\,\ Burgas",
"35961704", "Pravda\,\ V\.\ Tarnovo",
"35984", "Razgrad",
"3594126", "Hrishteni",
"35938", "Haskovo",
"3599351", "Izvor\,\ Vidin",
"35984763", "Beli\ Lom",
"35931997", "Zlatosel",
"3599355", "Kosovo\,\ Vidin",
"35984744", "Belovets",
"3593320", "Oreshets\,\ Plovdiv",
"3597546", "Slashten",
"3594323", "Tulovo",
"35977221", "Kondofrey",
"35931701", "Krastevich",
"35969614", "Gorno\ trape",
"3597423", "Kolarovo\,\ Blag\.",
"3596517", "Podem",
"3599746", "Razgrad\,\ Mont\.",
"3593114", "Brestnik",
"35984469", "Bozhurovo\,\ Razgrad",
"3594586", "Neykovo\,\ Sliven",
"3597142", "Kostenets",
"3599173", "Galovo",
"3596736", "Gradnitsa\,\ Gabr\.",
"3596028", "Vardun",
"35941489", "Bozduganovo",
"359724", "Ihtiman",
"35941353", "Plodovitovo",
"3596062", "Strazha\,\ Targ\.",
"3594522", "Korten",
"3598646", "Vokil",
"3595119", "Ignatievo",
"3596049", "Kamburovo",
"3597158", "Doganovo",
"35941171", "Dalboki",
"3597923", "Vrattsa",
"3593168", "Ezerovo\,\ Plovdiv",
"35953435", "Izgrev\,\ Shumen",
"3598632", "Zafirovo",
"3593122", "Manole",
"35961306", "Patresh",
"3597169", "Tompsan",
"3596965", "Beli\ Osam",
"3596573", "Koynare",
"3593159", "Belozem",
"35930476", "Selcha",
"35969612", "Terziysko\,\ Lovech",
"3594367", "Tazha",
"3593107", "Graf\ Ignatievo",
"3597136", "Novachene\,\ Sofia",
"3593552", "Bratsigovo",
"35984462", "Ostrovo",
"35969244", "Tepava",
"3595141", "Staro\ Oryahovo",
"35967394", "Bogatovo",
"3593347", "Lenovo",
"3595753", "Orlyak",
"35951537", "Chernevo",
"3599728", "Slivata",
"3595145", "Grozdyovo",
"35984726", "Ushintsi",
"3593175", "Dalgo\ pole\,\ Plovdiv",
"3597528", "Hadzhidimovo",
"3593691", "Chernoochene",
"3596912", "Bahovitsa",
"3593695", "Komuniga",
"359745", "Petrich\,\ Blag\.",
"3593529", "Mokrishte",
"359559", "Karnobat",
"35984749", "Sevar",
"3598194", "Sandrovo",
"3595578", "Terziysko\,\ Burgas",
"3593657", "Zhaltusha",
"3593713", "Dinevo",
"3593548", "Pashovo",
"3597937", "Razhdavitsa",
"359670", "Troyan\,\ Lovech",
"3594129", "Madzherito",
"3599749", "Cherni\ vrah\,\ Mont\.",
"3594710", "Bolyarsko",
"3594152", "Obruchishte",
"3599344", "Vrav",
"3598674", "Profesor\ Ishirkovo",
"3597549", "Dolen\,\ Blag\.",
"3594519", "Samuilovo\,\ Sliven",
"3599540", "Belotintsi",
"35967393", "Dushevo",
"35969243", "Kazachevo",
"3595122", "Slaveykovo\,\ Varna",
"3599332", "Rakovitsa",
"35957305", "Rositsa\,\ Dobr\.",
"3595168", "Petrov\ dol\,\ Varna",
"359478", "Elhovo\,\ Yambol",
"3596718", "Draganovtsi",
"35941146", "Hristianovo",
"3596543", "Muselievo",
"35974405", "Kraishte\,\ Blag\.",
"35960385", "Lomtsi",
"3597118", "Dragovishtitsa\,\ Sofia",
"3593037", "Sivino",
"35984769", "Gorotsvet",
"3593561", "Septemvri",
"3598196", "Nisovo",
"3598113", "Novo\ selo\,\ Ruse",
"35984730", "Golyam\ Porovets",
"3599143", "Enitsa",
"3595943", "Vresovo",
"3593720", "Madzharovo",
"3597172", "Dragoman",
"3593050", "Bukova\ polyana",
"359727", "Slivnitsa\,\ Sofia",
"3594723", "Boyanovo\,\ Yambol",
"3593119", "Galabovo\,\ Plovdiv",
"35961402", "Stefan\ Stambolovo",
"3598676", "Vetren\,\ Silistra",
"3599346", "Sinagovtsi",
"3593512", "Hadzhievo",
"3595713", "Stefanovo\,\ Dobr\.",
"3594584", "Ticha",
"3597125", "Govedartsi",
"359308", "Madan\,\ Smol\.",
"3596734", "Petko\ Slaveykov",
"3596929", "Radyuvene",
"3599187", "Lyutadzhik",
"3599160", "Glozhene\,\ Vratsa",
"3597043", "Golemo\ selo",
"3596952", "Oreshak\,\ Lovech",
"35953220", "Pamukchii\,\ Shumen",
"35941354", "Malko\ Tranovo",
"3598644", "Chernolik",
"35971471", "Ochusha",
"359431", "Kazanlak",
"3596163", "Kamen\,\ V\.\ Tarnovo",
"35960388", "Goritsa\,\ Targ\.",
"3597910", "Bersin",
"3593753", "Oryahovo\,\ Hask\.",
"3595347", "Zhivkovo\,\ Shumen",
"3595552", "Dyulevo\,\ Burgas",
"35984718", "Dryanovets\,\ Razgrad",
"3593023", "Momchilovtsi",
"35974408", "Obidim",
"3593145", "Krichim",
"3595529", "Krushovo\,\ Burgas",
"359359", "Velingrad",
"3596587", "Petokladentsi",
"3596560", "Kreta\,\ Pleven",
"3594112", "Badeshte",
"35957308", "Chernookovo\,\ Dobr\.",
"3597134", "Vrachesh",
"3594737", "Sinapovo",
"3596948", "Karpachevo",
"3596725", "Gostilitsa",
"3593747", "Tatarevo\,\ Hask\.",
"3594593", "Shivachevo",
"3595353", "Veselinovo\,\ Shumen",
"3599328", "Dolni\ Lom",
"3596076", "Taymishte",
"3595138", "Dobrotich",
"3594516", "Kermen",
"3593524", "Apriltsi\,\ Pazardzhik",
"35961105", "Prisovo",
"35941352", "Vinarovo\,\ St\.\ Zagora",
"35961703", "Varbitsa\,\ V\.\ Tarnovo",
"35992", "Vratsa",
"3593535", "Levski\,\ Pazardzhik",
"3599785", "Vasilovtsi\,\ Mont\.",
"3597727", "Kovachevtsi\,\ Pernik",
"359596", "Pomorie",
"3597057", "Malo\ selo",
"3594124", "Zmeyovo",
"3593673", "Tihomir",
"3597030", "Resilovo",
"35984764", "Seydol",
"35984743", "Brestovene",
"3599527", "Varshets",
"3599349", "Slanotran",
"3597544", "Osina",
"3598679", "Kaynardzha",
"35969613", "Chiflik\,\ Lovech",
"3593193", "Borets",
"3593116", "Krumovo\,\ Plovdiv",
"3599744", "Valchedram",
"3595320", "Pet\ mogili\,\ Shumen",
"3596926", "Gorno\ Pavlikene",
"3595394", "Byala\ reka\,\ Shumen",
"3594554", "Trapoklovo",
"3596591", "Gornik",
"35984463", "Prelez",
"35958", "Dobrich",
"3599130", "Tlachene",
"35931401", "Kadievo",
"3595114", "Ezerovo\,\ Varna",
"35941359", "Izvorovo\,\ St\.\ Zagora",
"3596982", "aglen",
"3596133", "Mihaltsi",
"35974321", "Harsovo\,\ Blag\.",
"3593783", "Svirkovo",
"3596044", "Dolno\ Kozarevo",
"3599311", "Kutovo",
"35971337", "Kalugerovo\,\ Sofia",
"35961108", "Plakovo",
"3599315", "Gradets\,\ Vidin",
"3597733", "Filipovtsi",
"3596530", "Tranchovitsa",
"3598697", "Sokol\,\ Silistra",
"3597164", "Rebrovo",
"3596557", "Bregare",
"3593154", "Chalakovi",
"3595526", "Klikach",
"3599339", "Makresh",
"35961602", "Tsarski\ izvor",
"3594512", "Blatets\,\ Sliven",
"3593584", "Vetren\,\ Pazardzhik",
"3596072", "Dobrotitsa\,\ Targ\.",
"3595129", "Blaskovo",
"35981461", "Karan\ Varbovka",
"3593545", "Draginovo",
"359331", "Asenovgrad",
"3595710", "Pobeda\,\ Dobr\.",
"3595571", "Sungurlare",
"3599163", "Harlets",
"3595575", "Prilep\,\ Burgas",
"3596563", "Brest\,\ Pleven",
"3594753", "Zornitsa\,\ Yambol",
"35967396", "Berievo",
"3597179", "Golemo\ Malovo",
"3594145", "Znamenosets",
"35974203", "Rupite",
"35931395", "Iganovo",
"3597521", "Koprivlen",
"35959409", "Cheresha",
"3593178", "Krasnovo",
"3599560", "Bezdenitsa",
"3597913", "Rashka\ Grashtitsa",
"3597525", "Banichan",
"3599721", "Dolno\ Tserovene",
"3593112", "Markovo\,\ Plovdiv",
"3599725", "Komoshtitsa",
"3593020", "Davidkovo",
"3595148", "Rudnik\,\ Varna",
"3596922", "Leshnitsa\,\ Lovech",
"3596540", "Asenovo\,\ Pleven",
"3593519", "Velichkovo\,\ Pazardzhik",
"35961304", "Dimcha",
"3596968", "Dobrodan",
"35953234", "Zlatna\ niva",
"3596907", "Gradezhnitsa",
"35931398", "Slatina\,\ Plovdiv",
"3595367", "Todor\ Ikonomovo",
"359953", "Berkovitsa",
"3596034", "Slavyanovo\,\ Targ\.",
"3597155", "Lesnovo",
"3596986", "Daben",
"3596959", "Debnevo",
"35935419", "Sveta\ Petka",
"3597743", "Divlya",
"3593165", "Karadzhalovo",
"3595559", "Kubadin",
"3596025", "Alvanovo",
"35947202", "Zhrebino",
"3594794", "Ovchi\ kladenets",
"3598664", "Polyana\,\ Silistra",
"3596021", "Buhovtsi",
"3596143", "Maslarevo",
"35930457", "Kasak",
"3595522", "Iskra\,\ Burgas",
"35941331", "Granit",
"3593053", "Hvoyna",
"35930417", "Grohotno",
"3599140", "Gabare",
"3593554", "Kozarsko",
"3595126", "Cherkovna\,\ Varna",
"35961302", "Batak\,\ V\.\ Tarnovo",
"3596157", "Slivovitsa",
"3599336", "Staropatitsa",
"35941115", "Borilovo",
"35967307", "Mlechevo",
"3595323", "Pliska",
"3596914", "Slivek",
"35969616", "Staro\ selo\,\ Lovech",
"3599133", "Komarevo\,\ Vratsa",
"35930472", "Mihalkovo",
"35984729", "Ezerche",
"3596533", "Stezherovo",
"3598192", "Hotantsa",
"35947204", "Pchela",
"3593708", "Orlovo\,\ Hask\.",
"3597176", "Hrabarsko",
"35971225", "Novo\ selo\,\ Sofia",
"3593767", "Branitsa",
"359538", "Veliki\ Preslav",
"35937705", "Pastrogor",
"3594154", "Mednikarovo",
"35961706", "Pisarevo\,\ V\.\ Tarnovo",
"3598672", "Bradvari",
"3599342", "Inovo",
"3599557", "Gorno\ Tserovene",
"35959404", "Yasenovo\,\ Burgas",
"3596328", "Oresh",
"3593516", "Tsrancha\,\ Pazardzhik",
"35961309", "Gorsko\ Kalugerovo",
"35971228", "Maritsa",
"3597144", "Kostenets",
"3596938", "Kalenik\,\ Lovech",
"35961604", "Mirovo\,\ V\.\ Tarnovo",
"3594747", "Dennitsa\,\ Yambol",
"3597181", "Pirdop",
"3599127", "Lyutidol",
"35963570", "Staroseltsi",
"3597185", "Chelopech",
"3596956", "Lomets\,\ Lovech",
"3596989", "Toros",
"3595337", "Kochovo",
"3596064", "Golyamo\ Novo",
"3598625", "Oven",
"3594524", "Kamenovo\,\ Sliven",
"35962", "Veliko\ Tarnovo",
"3593135", "Karnare",
"3598621", "Silistra",
"35984722", "Yasenovets",
"3593190", "Varben\,\ Plovdiv",
"35984466", "Zvanartsi",
"3596527", "Odarne",
"3598634", "Nova\ Cherna",
"3593124", "Kalekovets",
"3595589", "Vinarsko",
"3595556", "Golyamo\ Bukovo",
"35975214", "Gaytaninovo",
"35984393", "Vazovo",
"3594116", "Rakitnitsa\,\ St\.\ Zagora",
"3595538", "Karanovo\,\ Burgas",
"35941118", "Ostra\ mogila\,\ St\.\ Zagora",
"35936702", "Gorski\ izvor\,\ Kardzh\.",
"3597033", "Kraynitsi",
"3593709", "Karamantsi",
"35996", "Montana",
"3599567", "Dolna\ Verenitsa",
"3595343", "Venets\,\ Shumen",
"3593696", "Pchelarovo\,\ Kardzh\.",
"3593757", "Georgi\ Dobrevo",
"3593027", "Slaveyno",
"35941116", "Sladak\ Kladenets",
"35984745", "Vladimirovtsi",
"3598445", "Yuper",
"3593176", "Starosel",
"3596583", "Belene",
"35969615", "Balabansko",
"3595146", "Goren\ chiflik",
"35930411", "Devin",
"3594733", "Orlov\ dol",
"35941337", "Sarnevets",
"3595717", "Vedrina",
"3599322", "Oreshets\,\ Vidin",
"3599183", "Lilyache",
"3595132", "Mihalich\,\ Varna",
"3597047", "Usoyka",
"35960454", "Zmeyno",
"35961103", "Rusalya",
"35937706", "Chernodab",
"3593564", "Semchinovo",
"35961705", "Gorski\ dolen\ Trambesh",
"3596167", "Kesarevo",
"3598645", "Mezhden",
"35937604", "Varbovo\,\ Hask\.",
"3598641", "Okorsh",
"35935254", "Dobrovnitsa",
"3598117", "Marten",
"3599147", "Borovan",
"3595947", "Prosenik",
"3597124", "Belchinski\ bani",
"3594727", "Malak\ manastir",
"35941277", "Zagore",
"35994", "Vidin",
"3595539", "Chernograd",
"3594585", "Zheravna",
"3597135", "Trudovets",
"3596939", "Dragana",
"3596724", "Yantra\,\ Gabr\.",
"3596900", "Vasilyovo",
"359702", "Bobov\ dol",
"3596329", "Tsarevets\,\ V\.\ Tarnovo",
"35984465", "Savin",
"3596966", "Shipkovo",
"35984266", "Prostorno",
"3596352", "Dolni\ Lukovit",
"3596547", "Dragash\ voyvoda",
"3596988", "Peshterna",
"3593787", "Tyanevo\,\ Hask\.",
"3593699", "Gabrovo\,\ Kardzh\.",
"35935252", "Topoli\ dol",
"35937602", "Cherna\ mogila\,\ Hask\.",
"3599550", "Mitrovtsi",
"3593521", "Zvanichevo",
"3593706", "Tankovo\,\ Hask\.",
"3594134", "Bratya\ Daskalovi",
"3597178", "Prolesha",
"35931792", "Chernichevo\,\ Plovdiv",
"3595149", "Golitsa",
"3598693", "Zvenimir",
"3596553", "Oryahovitsa\,\ Pleven",
"3594763", "Irechekovo",
"359721", "Kostinbrod",
"35969245", "Devetaki",
"3599741", "Dolni\ Tsibar",
"35967395", "Gorna\ Rositsa",
"3593040", "Trigrad",
"3599745", "Zlatia\,\ Mont\.",
"3595128", "Zhitnitsa\,\ Varna",
"3597541", "Satovcha",
"35931396", "Domlyan",
"3599338", "Shishentsi",
"3597545", "Kochan",
"3595162", "Belogradets",
"3599356", "Kalenik\,\ Vidin",
"3596712", "Gabene",
"35984713", "Blagoevo\,\ Razgrad",
"3596150", "Zlataritsa",
"35974403", "Dolno\ Draglishte",
"359550", "Sozopol",
"35960383", "Berkovski",
"3593534", "Popintsi",
"3599784", "Kiselevo",
"3594121", "Lyulyak",
"35961502", "Gorsko\ Novo\ Selo",
"3596137", "Butovo",
"3594125", "Mihaylovo\,\ St\.\ Zagora",
"3597723", "Dolni\ Rakovets",
"3597053", "Kocherinovo",
"35953434", "Yasenkovo",
"3593677", "Drangovo\,\ Kardzh\.",
"3595558", "Debelt",
"3599523", "Barzia",
"3595115", "General\ Kantardzhievo",
"3595395", "Chernookovo\,\ Shumen",
"359618", "Gorna\ Oryahovitsa",
"3595391", "Varbitsa\,\ Shumen",
"3595536", "Maglen",
"3593197", "Tyurkmen",
"3594551", "Byala\,\ Sliven",
"3594118", "Pamukchii\,\ St\.\ Zagora",
"3596942", "Aleksandrovo\,\ Lovech",
"35969248", "Skobelevo\,\ Lovech",
"35967398", "Damyanovo",
"3596520", "Nikolaevo\,\ Pleven",
"3594597", "Borov\ dol",
"3593151", "Rakovski\,\ Plovdiv",
"3593743", "Silen",
"3597165", "Milanovo\,\ Sofia",
"35930257", "Vishnevo",
"3593518", "Dragor",
"3596969", "Beklemeto",
"3596326", "Morava",
"3593155", "Momino\ selo",
"35971398", "Osikovitsa",
"35991202", "Kunino",
"35967301", "Idilevo",
"3595330", "Zlatar",
"3595773", "Lozenets\,\ Dobr\.",
"359373", "Harmanli",
"35935393", "Smilets\,\ Pazardzhik",
"3596958", "Apriltsi\,\ Lovech",
"3599314", "Dunavtsi\,\ Vidin",
"3596123", "Bukovets\,\ V\.\ Tarnovo",
"359747", "Razlog",
"35931388", "Beguntsi",
"3599719", "Asparuhovo\,\ Mont\.",
"35931700", "Belovitsa",
"3595574", "Saedinenie\,\ Burgas",
"3597116", "Petarch",
"3593544", "Kostandovo",
"3593702", "Tsareva\ polyana",
"3597193", "Golesh\,\ Sofia",
"3596147", "Ivancha\,\ V\.\ Tarnovo",
"3593581", "Belovo",
"35937703", "Dimitrovche",
"35964", "Pleven",
"3593585", "Akandzhievo",
"35961106", "Novo\ selo\,\ V\.\ Tarnovo",
"3593030", "Shiroka\ laka",
"3593727", "Nova\ Nadezhda",
"3597531", "Dolno\ Dryanovo",
"3593057", "Plovdivtsi",
"3599348", "Negovanovtsi",
"3598678", "Sratsimir\,\ Silistra",
"359915", "Byala\ Slatina",
"35935501", "Ravnogor",
"3595100", "Sindel",
"35937420", "Podkrepa",
"3599724", "Stanevo",
"3595139", "Oborishte\,\ Varna",
"3595166", "Dobroplodno",
"35941113", "Pryaporets\,\ St\.\ Zagora",
"3599329", "Rabisha",
"3597524", "Ablanitsa\,\ Blag\.",
"3599352", "Druzhba",
"35963564", "Bivolare",
"3596716", "Zhaltesh",
"3599547", "Vinishte",
"35951125", "Konstantinovo\,\ Varna",
"359391", "Dimitrovgrad",
"359817", "Byala\,\ Ruse",
"3595363", "Gusla",
"35969032", "Balgarski\ izvor",
"3594144", "Kovachevo\,\ St\.\ Zagora",
"35966", "Gabrovo",
"3597154", "Stolnik",
"3596035", "Palamartsa",
"3594757", "Nedyalsko",
"3596567", "Somovit",
"3596580", "Tatari",
"3593164", "Dalbok\ izvor",
"3594730", "Knyazhevo",
"3595532", "Topolitsa",
"3597917", "Tavalichevo",
"3595340", "Visoka\ polyana\,\ Shumen",
"3596946", "Chavdartsi",
"3596322", "Alekovo\,\ V\.\ Tarnovo",
"3596932", "Mikre",
"3596024", "Ruets",
"3594795", "Skalitsa",
"3594564", "Novoselets",
"3598665", "Iskra\,\ Silistra",
"3598661", "Tutrakan",
"3596359", "Glava",
"3599167", "Lipnitsa\,\ Vratsa",
"3599180", "Golyamo\ Peshtene",
"3595967", "Bata",
"35967194", "Grablevtsi",
"359306", "Rudozem",
"35974327", "Novo\ Delchevo",
"3597119", "Dramsha",
"3596915", "Smochan",
"35957306", "Izvorovo\,\ Dobr\.",
"3596523", "Krushovitsa\,\ Pleven",
"35931393", "Voynyagovo",
"3596911", "Lisets\,\ Lovech",
"35974406", "Dobarsko",
"3598424", "Tsar\ Kaloyan\,\ Razgrad",
"3597720", "Priboy",
"35941145", "Arnautito",
"3593555", "Nova\ mahala\,\ Pazardzhik",
"3599520", "Gorno\ Ozirovo",
"3593118", "Sadovo\,\ Plovdiv",
"35960386", "Voditsa\,\ Targ\.",
"3595142", "Dolni\ chiflik",
"3599326", "Gorni\ Lom",
"3598431", "Isperih",
"3595169", "Momchilovo",
"3594743", "Mamarchevo",
"3594518", "Topolchane",
"35960377", "Aprilovo\,\ Targ\.",
"3595136", "Brestak",
"35965617", "Iskar\,\ Pleven",
"3594155", "Glavan\,\ St\.\ Zagora",
"3595515", "Kameno",
"3599123", "Roman",
"3593740", "Pchelari",
"3595511", "Lukoil\ Neftochim",
"359361", "Kardzhali",
"3595333", "Han\ Krum",
"35963569", "Kamenets\,\ Pleven",
"359337", "Hisarya",
"3596065", "Bistra\,\ Targ\.",
"3598624", "Kalipetrovo",
"3594525", "Omarchevo\,\ Sliven",
"3596537", "Asenovtsi",
"3596061", "Golyamo\ Sokolovo",
"3593134", "Sopot\,\ Plovdiv",
"3597184", "Koprivshtitsa",
"3598690", "Silistra",
"3596550", "Stavertsi",
"3597145", "Mirovo\,\ Sofia",
"3593763", "Balgarin",
"35951429", "Solnik",
"3597753", "Noevtsi",
"3595528", "Nevestino\,\ Burgas",
"3599553", "Prevala",
"3596928", "Kakrina",
"3596153", "Zlataritsa",
"3596962", "Cherni\ Osam",
"3593121", "Rogosh",
"3595327", "Kaspichan\,\ Shumen",
"3593043", "Zmeitsa",
"3598635", "Tsar\ Samuil",
"3593125", "Razhevo\ Konare",
"35930517", "Zabardo",
"3598631", "Silistra",
"3599137", "Popitsa",
"35963562", "Komarevo\,\ Pleven",
"3593136", "Rozino\,\ Plovdiv",
"3594357", "Gorno\ Sahrane",
"3597430", "Damyanitsa",
"3598626", "Sredishte\,\ Silistra",
"3596048", "Izvorovo\,\ Targ\.",
"3597159", "Aprilovo\,\ Sofia",
"3597186", "Anton",
"3596955", "Dalbok\ dol",
"3594773", "Okop",
"3594330", "Nikolaevo\,\ St\.\ Zagora",
"359722", "Samokov",
"359537", "Novi\ pazar\,\ Shumen",
"3598163", "Bazan",
"35931707", "Chernozemen",
"3593923", "Radievo",
"3597168", "Bov",
"3593515", "Kalugerovo\,\ Pazardzhik",
"35984269", "Nedoklan",
"35937702", "Mustrak",
"3593511", "Ognyanovo\,\ Pazardzhik",
"3595740", "Gorichane",
"3596722", "Sokolovo\,\ Gabr\.",
"35941112", "Starozagorski\ bani",
"35953221", "Stoyan\ Mihaylovski",
"35961305", "Lesicheri",
"35953436", "Chernoglavtsi",
"3594115", "Kirilovo\,\ St\.\ Zagora",
"35930475", "Stomanevo",
"3595555", "Fakia",
"3593142", "Brestovitsa\,\ Plovdiv",
"35984728", "Rakovski\,\ Razgrad",
"3595551", "Sredets\,\ Burgas",
"3595118", "Voditsa\,\ Varna",
"3596997", "Dobrevtsi\,\ Lovech",
"3596029", "Nadarevo",
"3593549", "Grashevo",
"35931394", "Vasil\ Levski\,\ Plovdiv",
"3595579", "Vedrovo",
"35984725", "Kichenitsa",
"3596510", "Totleben",
"3593937", "Yabalkovo\,\ Hask\.",
"35961308", "Vishovgrad",
"3599335", "Tsar\ Petrovo",
"3593073", "Startsevo",
"3597713", "Rudartsi",
"3597548", "Godeshevo",
"3593327", "Bachkovo",
"3595121", "Tutrakantsi",
"3593667", "Pokrovan",
"3599748", "Dalgodeltsi",
"3599513", "Boychinovtsi",
"3595125", "Gradinarovo",
"35961391", "Slomer",
"3599324", "Ruzhintsi",
"35941119", "Elhovo\,\ St\.\ Zagora",
"3597529", "Breznitsa",
"3596113", "Balvan",
"3595134", "Cherventsi",
"3599729", "Rasovo",
"359746", "Sandanski",
"3593528", "Govedare",
"3598140", "Borovo\,\ Ruse",
"3597175", "Gaber",
"3599110", "Virovsko",
"3595910", "Cherni\ vrah\,\ Burgas",
"3594149", "Trankovo\,\ St\.\ Zagora",
"3593562", "Slavovitsa\,\ Pazardzhik",
"3595763", "Plachidol",
"3593166", "Byala\ reka\,\ Plovdiv",
"3596981", "Petrevene",
"35931392", "Dabene",
"3597156", "Ravno\ pole",
"3597189", "Chavdar\,\ Sofia",
"3596985", "Rumyantsevo",
"3593100", "Belashtitsa",
"3598629", "Smilets\,\ Silistra",
"3598133", "Ryahovo",
"35975215", "Teshovo",
"3594103", "Byal\ izvor\,\ St\.\ Zagora",
"3593623", "Boyno",
"3597138", "Litakovo",
"3596944", "Krushuna",
"35930205", "Starnitsa",
"35937606", "Shishmanovo",
"35961203", "Emen",
"35959408", "Razhitsa",
"3594588", "Filaretovo",
"3596177", "Yantra\,\ V\.\ Tarnovo",
"3596738", "Dobromirka",
"35961605", "Novo\ gradishte",
"35935256", "Sbor\,\ Pazardzhik",
"3595727", "Senokos\,\ Dobr\.",
"3599312", "Bregovo\,\ Vidin",
"3596026", "Makariopolsko",
"3594566", "Pitovo",
"35967193", "Kmetovtsi",
"3598648", "Sekulovo",
"35960370", "Golyamo\ gradishte",
"3595576", "Lozarevo",
"3594717", "Chargan",
"35935418", "Krastava",
"3594132", "Orizovo",
"35971224", "Shipochane",
"35961608", "Gorski\ Senovets",
"35937704", "Mladinovo",
"3597930", "Eremia",
"3598127", "Karamanovo",
"35978", "Kyustendil",
"35959405", "Zaychar",
"3593637", "Gruevo",
"3599726", "Zamfir",
"3597526", "Ribnovo",
"3594343", "Konare\,\ St\.\ Zagora",
"3598448", "Terter",
"35941114", "Lozen\,\ St\.\ Zagora",
"3595164", "Neofit\ Rilski",
"3596714", "Popovtsi",
"35963563", "Borislav",
"3593340", "Novi\ izvor",
"359701", "Dupnitsa",
"3593532", "Strelcha",
"3594146", "Dinya",
"3595733", "Kardam\,\ Dobr\.",
"3599782", "Bukovets\,\ Mont\.",
"35971798", "Vasilovtsi\,Sof\.",
"3597152", "Gorna\ Malina",
"3593162", "Gradina\,\ Plovdiv",
"3598638", "Bogdantsi\,\ Silistra",
"35941330", "Tsenovo\,\ St\.\ Zagora",
"3593128", "Zlatitrap",
"3594327", "Sheynovo",
"3595534", "Karageorgievo",
"3597129", "Raduil",
"3597427", "Parvomay\,\ Blag\.",
"3596925", "Vladinya",
"3596513", "Pordim",
"3596921", "Ablanitsa\,\ Lovech",
"359725", "Elin\ Pelin",
"359350", "Peshtera\,\ Pazardzhik",
"3598143", "Obretenik",
"3596007", "Ralitsa",
"3596324", "Vardim",
"3595525", "Devetak",
"3595913", "Krushevets",
"3599113", "Mramoren",
"3595521", "Venets\,\ Burgas",
"3597148", "Muhovo",
"3596934", "Katunets",
"359336", "Parvomay\,\ Plovdiv",
"3595760", "Bozhurovo\,\ Dobr\.",
"35935394", "Oborishte\,\ Pazardzhik",
"3599316", "Novo\ selo\,\ Vidin",
"3596022", "Probuda\,\ Targ\.",
"3594562", "Kriva\ krusha",
"35941355", "Yavorovo",
"3596068", "Bozhurka",
"3594528", "Lyubenova\ mahala",
"3593149", "Tsalapitsa",
"35961102", "Pchelishte",
"35941270", "Malka\ Vereya",
"35931324", "Mrachenik",
"3595572", "Beronovo",
"3598187", "Tetovo",
"3593773", "Kapitan\ Andreevo",
"3593542", "Rakitovo",
"3593704", "Bryagovo\,\ Hask\.",
"3595743", "Shabla",
"3595518", "Rudnik\,\ Burgas",
"3594136", "Cherna\ gora\,\ St\.\ Zagora",
"3593920", "Zlatopole",
"35941358", "Opalchenets",
"3597433", "Kresna",
"3594515", "Mokren",
"3596071", "Antonovo",
"3594158", "Iskritsa",
"3594511", "Slivenski\ mineralni\ bani",
"3594333", "Dabovo\,\ St\.\ Zagora",
"3594770", "General\ Inzovo",
"3593558", "Isperihovo",
"3595317", "Ivanski",
"3593111", "Parvenets\,\ Plovdiv",
"3593115", "Kuklen",
"3599722", "Staliyska\ mahala",
"3597522", "Dabnitsa",
"3593647", "Chernichevo\,\ Kardzh\.",
"35957304", "Dabovik",
"3593569", "Karabunar",
"3596918", "Drenov",
"35974404", "Babyak",
"3599354", "Antimovo\,\ Vidin",
"35960384", "Gagovo",
"3593536", "Banya\,\ Pazardzhik",
"35961109", "Vaglevtsi",
"3594142", "Troyanovo\,\ St\.\ Zagora",
"3598622", "Alekovo\,\ Silistra",
"3593132", "Banya\,\ Plovdiv",
"35937603", "Rogozinovo",
"3593653", "Mlechino",
"3593717", "Konush\,\ Hask\.",
"3594798", "Savino",
"3598668", "Popina",
"3597933", "Gramazhdano",
"3597182", "Mirkovo",
"359728", "Zlatitsa",
"35982", "Ruse",
"3597126", "Gorni\ Okol",
"35961405", "Petko\ Karavelovo",
"3595757", "Bezmer\,\ Dobr\.",
"3593343", "Kozanovo",
"35963571", "Brestovets",
"3596726", "Skalsko",
"3596964", "Velchevo\,\ Lovech",
"3593146", "Kurtovo\ Konare",
"35961503", "Chakali",
"35984768", "Sinya\ voda",
"3598475", "Loznitsa\,\ Razgrad",
"35960382", "Kovachevets",
"35974402", "Godlevo",
"3599319", "Gamzovo",
"3594340", "Panicherevo",
"35984712", "Kostandenets",
"3594100", "Stoletovo\,\ St\.\ Zagora",
"35974347", "Razdol",
"3597927", "Treklyano",
"3594139", "Svoboda\,\ St\.\ Zagora",
"35984765", "Veselina",
"35963566", "Brashlyanitsa",
"3593174", "Staro\ Zhelezare",
"3596577", "Breste",
"3594363", "Gabarevo",
"3593103", "Milevo",
"3595144", "Kamchia",
"3598671", "Silistra",
"3599341", "Dimovo\,\ Vidin",
"3599345", "Vinarovo\,\ Vidin",
"3598675", "Aydemir",
"35991203", "Lik",
"3593588", "Menenkyovo",
"35960453", "Moravka",
"35961104", "Vodoley",
"35960389", "Kardam\,\ Targ\.",
"35974409", "Mesta",
"35984719", "Balkanski",
"3593566", "Boshulya",
"35935392", "Dyulevo\,\ Pazardzhik",
"3597425", "Kulata",
"3596927", "Umarevtsi",
"3599189", "Pavolche",
"3594325", "Kanchevo",
"35952", "Varna",
"3594321", "Maglizh",
"3595328", "Nikola\ Kozlevo",
"3596902", "Ribaritsa\,\ Lovech",
"3599353", "Koshava",
"35960450", "Dolna\ Hubavka",
"3595362", "Kliment\,\ Shumen",
"3599138", "Altimir",
"3595349", "Studenitsa",
"3596538", "Obnova",
"3593774", "Levka",
"3593703", "Zhalti\ bryag",
"3597192", "Gintsi",
"3597434", "Strumyani",
"3594739", "Radovets",
"3595781", "Svoboda\,\ Dobr\.",
"359729", "Godech",
"3594334", "Elhovo\,\ St\.\ Zagora\,\ mun\.\ Nikolaevo",
"3595527", "Sokolovo\,\ Burgas",
"3598696", "Suhodol\,\ Silistra",
"3596001", "Cherkovna\,\ Targ\.",
"3596556", "Gorna\ Mitropolia",
"3596589", "Kulina\ voda",
"3596323", "Balgarsko\ slivovo",
"35984717", "Pobit\ kamak\,\ Razgrad",
"3598144", "Batishnitsa",
"3595914", "Atia",
"3593746", "Sirakovo\,\ Hask\.",
"359417", "Radnevo",
"35974407", "Kremen\,\ Blag\.",
"3595776", "Cherna\,\ Dobr\.",
"3596933", "Golets",
"3594517", "Ichera",
"35960387", "Gloginka",
"3596077", "Stevrek",
"3599320", "Stakevtsi",
"3596126", "Tserova\ koria",
"3595130", "General\ Kiselovo",
"3598185", "Senovo",
"35957307", "Zhiten\,\ Dobr\.",
"3597726", "Dren",
"3597056", "Mursalevo",
"3599526", "Slatina\,\ Mont\.",
"3593039", "Polkovnik\ Serafimovo",
"35984774", "Golyam\ izvor\,\ Razgrad",
"359357", "Panagyurishte",
"35931603", "Vinitsa",
"3593641", "Krumovgrad",
"3595533", "Pirne",
"35971503", "Dolno\ Kamartsi",
"3593645", "Avren\,\ Kardzh\.",
"3595315", "Tsarev\ brod",
"3596514", "Dolni\ Dabnik",
"3593117", "Katunitsa",
"3595311", "Gradishte\,\ Shumen",
"359554", "Sunny\ Beach",
"35960376", "Lyublen",
"35981886", "Chereshovo\,\ Ruse",
"35981463", "Mogilino",
"3594742", "Stefan\ Karadzhovo",
"3595959", "Zvezdets",
"3599186", "Zgorigrad",
"3599122", "Zverino",
"3593711", "Dolno\ Botevo",
"3595332", "Dragoevo",
"3599168", "Butan",
"3595968", "Kableshkovo\,\ Burgas",
"3596568", "Dabovan",
"3596522", "Zgalevo",
"3595346", "Kamenyak\,\ Shumen",
"3593693", "Lyaskovo\,\ Kardzh\.",
"3598477", "Samuil",
"3598699", "Tarnovtsi\,\ Silistra",
"3593173", "Panicheri",
"3596586", "Belene",
"3596559", "Gostilya",
"3597918", "Yabalkovo\,\ Kyust\.",
"3594364", "Osetenovo",
"35974201", "Kapatovo",
"3595755", "Kolartsi",
"3593104", "Yagodovo\,\ Plovdiv",
"3595143", "Byala\,\ Varna",
"3594736", "Svetlina",
"3595751", "Tervel\,\ Dobr\.",
"35961107", "Momin\ sbor",
"35971338", "Osikovska\ Lakavitsa",
"3593344", "Novakovo\,\ Plovdiv",
"3596710", "Donino",
"3596152", "Bebrovo",
"3596571", "Lepitsa",
"3593749", "Garvanovo",
"3596963", "Balkanets",
"3596575", "Telish",
"35936401", "Strandzhevo",
"3593042", "Borino",
"3595106", "Avren\,\ Varna",
"3598151", "Prosena",
"3599548", "Krapchene",
"3597921", "Zhilentsi",
"359470", "Topolovgrad",
"3597925", "Gyueshevo",
"3596129", "Gabrovtsi",
"35984779", "Zdravets\,\ Razgrad",
"3593036", "Mogilitsa",
"3599529", "Borovtsi",
"3597934", "Bunovo\,\ Kyust\.",
"3597729", "Dolna\ Dikanya",
"35974496", "Filipovo\,\ Blag\.",
"35941333", "Sredno\ gradishte",
"3596148", "Pavel",
"3593762", "Izvorovo\,\ Hask\.",
"3599171", "Oryahovo\,\ Vratsa",
"3597752", "Rezhantsi",
"3597110", "Opitsvet",
"3599175", "Ostrov",
"35931627", "Krushevo\,\ Plovdiv",
"3593728", "Slavyanovo\,\ Hask\.",
"3593058", "Mugla",
"3599347", "Bela\ Rada",
"3598677", "Srebarna",
"3599552", "Belimel",
"35937424", "Kozlets",
"3593517", "Lesichovo",
"35991185", "Pudria",
"3599323", "Drenovets",
"3596114", "Kilifarevo",
"35974388", "Gorno\ Spanchevo",
"3594746", "Popovo\,\ Yambol",
"3599182", "Devene",
"3595133", "General\ Kolevo\,\ Varna",
"35963560", "Radishevo",
"3596957", "Golyama\ Zhelyazna",
"3599126", "Kameno\ pole",
"3597105", "Malki\ Iskar",
"3594355", "Buzovgrad",
"3595764", "Vladimirovo\,\ Dobr\.",
"3596909", "Malka\ Zhelyazna",
"35963202", "Dragomirovo\,\ V\.\ Tarnovo",
"3595336", "Imrenchevo",
"3594351", "Koprinka",
"35968", "Lovech",
"3596930", "Slavshtitsa",
"3596991", "Yablanitsa",
"359938", "Kula",
"3595530", "Peshtersko",
"35931704", "Ivan\ Vazovo",
"3593678", "Chakalarovo",
"3595342", "Kapitan\ Petko",
"3595557", "Bistrets\,\ Burgas",
"3596526", "Varbitsa\,\ Pleven",
"35930415", "Devin",
"3597714", "Meshtitsa",
"3593074", "Erma\ reka",
"3593198", "Chehlare",
"3596582", "Belene",
"35930256", "Galabovo\,\ Smol\.",
"35941172", "Gorno\ Botevo",
"359457", "Nova\ Zagora",
"3594732", "Ustrem",
"35951108", "Izvorsko",
"359601", "Targovishte",
"3599514", "Vladimirovo\,\ Mont\.",
"35931403", "Trivoditsi",
"3593325", "Cherven\,\ Plovdiv",
"3593661", "Ivaylovgrad",
"3596156", "Rodina",
"3593665", "Svirachi",
"3595127", "Manastir\,\ Varna",
"3593321", "Topolovo\,\ Plovdiv",
"3593935", "Varbitsa\,\ Hask\.",
"3593931", "Kasnakovo",
"3599337", "Gramada",
"359556", "Obzor",
"35971506", "Gabra",
"35930458", "Lyubcha",
"35931606", "Voden\,\ Plovdiv",
"3595102", "Padina\,\ Varna",
"3593046", "Barutin",
"35930418", "Buynovo\,\ Smol\.",
"35960373", "Posabina",
"3596138", "Nedan",
"359751", "Gotse\ Delchev",
"3593032", "Srednogortsi",
"359971", "Lom",
"3594774", "Krumovo\,\ Yambol",
"3597177", "Aldomirovtsi",
"3598164", "Pisanets",
"35974323", "Lozenitsa",
"3593766", "Biser",
"35941179", "Han\ Asparuhovo",
"3593924", "Krepost",
"3599556", "Govezhda",
"35991188", "Galatin",
"3593700", "Trakiets",
"35931397", "Hristo\ Danovo",
"3597444", "Belitsa\,\ Blag\.",
"3595952", "Malko\ Tarnovo",
"3594749", "Ruzhitsa\,\ Yambol",
"35941276", "Mogila\,\ St\.\ Zagora",
"3594344", "Shanovo",
"359861", "Silistra",
"3595163", "Mlada\ gvardia",
"3596548", "Debovo",
"3596713", "Vranilovtsi",
"35969241", "Yoglav",
"35967391", "Stolat",
"3596906", "Cherni\ Vit",
"3599129", "Sinyo\ bardo",
"3595734", "Preselentsi",
"35967774", "Belitsa\,\ Gabr\.",
"3595366", "Branichevo",
"3596987", "Karlukovo",
"3596960", "Belish",
"35981466", "Pomen",
"3596529", "Koilovtsi",
"35967308", "Lovnidol",
"3598118", "Nikolovo\,\ Ruse",
"35931709", "Mihiltsi",
"35977229", "Galabnik",
"3599148", "Barkachevo",
"3595948", "Snyagovo\,\ Burgas",
"3596175", "Parvomaytsi",
"3594728", "Melnitsa",
"3598692", "Stefan\ Karadzha\,\ Silistra",
"3596552", "Dolna\ Mitropolia",
"3594762", "Vodenichane",
"3598125", "Koprivets",
"3595718", "Smolnitsa",
"3593631", "Momchilgrad",
"35981268", "Krivina\,\ Ruse",
"35941336", "Yazdach",
"3595772", "Telerig",
"3596159", "Zlataritsa",
"35937422", "Dolni\ Glavanak",
"3597048", "Blazhievo",
"35963204", "Delyanovtsi",
"3596122", "Belyakovets",
"35941117", "Kazanka",
"3594715", "Kalchevo",
"3593049", "Beden",
"3594711", "Bezmer\,\ Yambol",
"3596168", "Sushitsa\,\ V\.\ Tarnovo",
"35967305", "Stokite",
"35937707", "Shtit",
"35971227", "Beli\ Iskar",
"3599568", "Blagovo\,\ Mont\.",
"3597052", "Pastra",
"35931702", "Dolna\ mahala\,\ Plovdiv",
"3593758", "Yerusalimovo",
"3595140", "Shkorpilovtsi",
"3593028", "Arda",
"35977222", "Gorna\ Dikanya",
"3599522", "Kotenovtsi",
"3598134", "Malko\ Vranovo",
"3599559", "Gorna\ Kovachitsa",
"3594104", "Kravino",
"35941174", "Podslon\,\ St\.\ Zagora",
"3593624", "Chiflik\,\ Kardzh\.",
"3593769", "Oreshets\,\ Hask\.",
"3596943", "Gorsko\ Slivovo",
"3593725", "Stamboliyski\,\ Hask\.",
"3598142", "Bazovets\,\ Ruse",
"35941351", "Partizanin",
"3593055", "Elhovets",
"3595912", "Polski\ izvor",
"3599112", "Banitsa",
"3593721", "Stambolovo\,\ Hask\.",
"3593051", "Chepelare",
"35963567", "Gradina\,\ Pleven",
"359865", "Silistra",
"3593587", "Sestrimo",
"359659", "Cherven\ bryag",
"3596023", "Podgoritsa",
"3596141", "Polski\ Trambesh",
"35974346", "Tsaparevo",
"35963203", "Hadzhidimitrovo\,\ V\.\ Tarnovo",
"3596145", "Strahilovo",
"3597741", "Zemen",
"3594779", "Hanovo",
"3597745", "Egalnitsa",
"3593163", "Iskra\,\ Plovdiv",
"3597928", "Garlyano",
"3598158", "Mechka\,\ Ruse",
"3599541", "Doktor\ Yosifovo",
"3599545", "Gabrovnitsa",
"3593929", "Golyamo\ Asenovo",
"3593626", "Perperek",
"3594106", "Pastren",
"359608", "Popovo\,\ Targ\.",
"35941018", "Knyazhevsko",
"3596578", "Reselets",
"3598136", "Stambolovo\,\ Ruse",
"35941173", "Bratya\ Kunchevi",
"3596512", "Gorni\ Dabnik",
"359570", "Kavarna",
"3595758", "Kladentsi",
"3597446", "Eleshnitsa\,\ Blag\.",
"3599723", "Traykovo",
"3597911", "Granitsa",
"3594346", "Golyamo\ Dryanovo",
"3597523", "Garmen",
"3597915", "Nevestino\,\ Kyust\.",
"3596119", "Dichin",
"35931402", "Skobelevo\,\ Plovdiv",
"3595769", "Hitovo",
"3596720", "Kereka",
"35960372", "Krepcha",
"3594755", "Tamarino",
"3596565", "Milkovitsa",
"3596561", "Gulyantsi",
"3594143", "Sarnevo\,\ St\.\ Zagora",
"3594751", "Voynika",
"3595736", "Vasilevo",
"3599165", "Sofronievo",
"3595573", "Vezenkovo",
"3597120", "Dolna\ banya",
"3599161", "Mizia",
"3593772", "Momkovo",
"35991668", "Manastirishte",
"3593543", "Dorkovo",
"3593718", "Voyvodovo\,\ Hask\.",
"3594797", "Galabintsi",
"35931390", "Moskovets",
"3595742", "Rakovski\,\ Dobr\.",
"3598667", "Belitsa\,\ Silistra",
"35991888", "Veslets\,\ Vratsa",
"3594332", "Vetren\,\ St\.\ Zagora",
"3593079", "Kozarka",
"3597719", "Yardzhilovtsi",
"35974322", "Petrovo\,\ Blag\.",
"359868", "Silistra",
"3593557", "Byaga",
"3595318", "Srednya",
"3593342", "Narechenski\ bani",
"3597031", "Gorna\ Koznitsa",
"3596154", "Buynovtsi",
"3597035", "Cherven\ breg",
"35976", "Pernik",
"35984776", "Harsovo\,\ Razgrad",
"3593530", "Poibrene",
"3593648", "Golyamo\ Kamenyane",
"3597415", "Selishte\,\ Blag\.",
"35931108", "Bogdanitsa",
"35963575", "Bohot",
"3596917", "Balgarene\,\ Lovech",
"3593044", "Lyaskovo\,\ Smol\.",
"35960374", "Gorsko\ Ablanovo",
"359454", "Tvarditsa\,\ Sliven",
"3598623", "Golesh\,\ Silistra",
"3593133", "Kalofer",
"359517", "Dalgopol",
"3593652", "Byal\ izvor\,\ Kardzh\.",
"3595517", "Ravnets\,\ Burgas",
"3597183", "Dushantsi",
"3597932", "Shipochano",
"35974324", "Struma",
"3593764", "Polyanovo\,\ Hask\.",
"3598166", "Svalenik",
"3597754", "Kosharevo",
"3594157", "Razdelna\,\ St\.\ Zagora",
"3594130", "Spasovo\,\ St\.\ Zagora",
"3593926", "Dobrich\,\ Hask\.",
"3599554", "Chiprovtsi",
"3593629", "Most",
"3594109", "Trakia",
"359605", "Omurtag",
"35937423", "Golemantsi",
"3596116", "Golemanite",
"3597147", "Pchelin\,\ Sofia",
"3594744", "Golyamo\ Krushevo",
"35941110", "Starozagorski\ bani",
"359416", "Chirpan",
"3599124", "Tipchenitsa",
"3595739", "Pchelarovo\,\ Dobr\.",
"359848", "Kubrat",
"3595334", "Osmar",
"3596067", "Kralevo\,\ Targ\.",
"3594527", "Zagortsi\,\ Sliven",
"3596535", "Kozar\ Belene",
"3596531", "Izgrev\,\ Pleven",
"3595766", "Metodievo\,\ Dobr\.",
"3599135", "Bardarski\ geran",
"3596590", "Rakita\,\ Pleven",
"3599131", "Dobrolevo",
"35931703", "Zhitnitsa\,\ Plovdiv",
"35963578", "Opanets\,\ Pleven",
"3595325", "Voyvoda",
"3596524", "Petarnitsa",
"3598637", "Malak\ Preslavets",
"35942", "Stara\ Zagora",
"3593127", "Tsaratsovo",
"3595321", "Praventsi",
"3593076", "Tsatsarovtsi",
"35971220", "Gutsal",
"3597428", "Gabrene",
"3594362", "Manolovo",
"3599516", "Lehchevo",
"3593102", "Karadzhovo",
"35984761", "Gradina\,\ Razgrad",
"3596723", "Tsareva\ livada",
"3593346", "Muldava",
"3598149", "Katselovo",
"3594140", "Polski\ Gradets",
"3599119", "Tishevitsa",
"3595919", "Marinka",
"3593755", "Belitsa\,\ Hask\.",
"3593025", "Banite",
"3599720", "Kovachitsa",
"3593751", "Lyubimets",
"3593143", "Perushtitsa",
"35984738", "Kitanchevo",
"3597520", "Kornitsa",
"3599561", "Sumer",
"35961301", "Byala\ reka\,\ V\.\ Tarnovo",
"359678", "Teteven",
"3593034", "Levochevo",
"3596161", "Strazhitsa\,\ V\.\ Tarnovo",
"3594718", "Roza",
"3596165", "Asenovo\,\ V\.\ Tarnovo",
"3597936", "Slokoshtitsa",
"359453", "Kotel",
"3594772", "Simeonovo\,\ Yambol",
"35941334", "Saedinenie\,\ St\.\ Zagora",
"3595570", "Manolich",
"3597123", "Kovachevtsi\,\ Sofia",
"3596519", "Beglezh",
"3597041", "Shatrovo",
"3597045", "Golem\ Varbovnik",
"3593922", "Brod",
"3598128", "Polsko\ Kosovo",
"3595715", "Popgrigorovo",
"3593638", "Zvezdel",
"3595711", "Ovcharovo\,\ Dobr\.",
"35931995", "Streltsi\,\ Plovdiv",
"35981464", "Ostritsa\,\ Ruse",
"3596020", "Lilyak",
"3596112", "Samovodene",
"3594587", "Yablanovo",
"35931998", "Choba",
"3596178", "Strelets\,\ V\.\ Tarnovo",
"3596737", "Krushevo\,\ Gabr\.",
"3594725", "Lesovo",
"3599184", "Ohoden",
"3598115", "Chervena\ voda",
"3599145", "Brenitsa\,\ Vratsa",
"3595945", "Dobromir",
"3598111", "Shtraklevo",
"3599141", "Malorad",
"35984710", "Osenets",
"3595941", "Skalak\,\ Burgas",
"35961395", "Paskalevets",
"3593563", "Varvara\,\ Pazardzhik",
"3598647", "Paisievo",
"3595762", "Stefan\ Karadzha\,\ Dobr\.",
"35960380", "Drinovo",
"3595749", "Krapets\,\ Dobr\.",
"35941274", "Samuilovo\,\ St\.\ Zagora",
"3595344", "Velino",
"3596545", "Lyubenovo\,\ Pleven",
"35984735", "Sveshtari",
"3596541", "Nikopol",
"359631", "Svishtov",
"3593779", "Siva\ reka",
"3594339", "Yulievo",
"359619", "Lyaskovets\,\ V\.\ Tarnovo",
"3593072", "Nedelino",
"3597712", "Batanovtsi",
"3596584", "Belene",
"3597439", "Ploski",
"3597137", "Skravena",
"3593106", "Stroevo",
"35971502", "Eleshnitsa\,\ Sofia",
"3594734", "Srem",
"35935257", "Saraya",
"35984721", "Lipnik",
"35931602", "Tatarevo\,\ Plovdiv",
"3599512", "Beli\ breg",
"3593744", "Sarnitsa\,\ Hask\.",
"35930528", "Manastir\,\ Plovdiv",
"3595916", "Rosen\,\ Burgas",
"3599116", "Kostelevo",
"35981462", "Volovo",
"3593349", "Boyantsi",
"3595774", "Koriten",
"3597731", "Tran",
"3593527", "Aleko\ Konstantinovo",
"3597735", "Leva\ reka",
"3599313", "Kapitanovtsi",
"3596124", "Ledenik",
"3593781", "Simeonovgrad",
"3593785", "Dryanovo\,\ Hask\.",
"35941339", "Dimitrievo",
"35932", "Plovdiv",
"3597939", "Tsarvaritsa",
"3597724", "Izvor\,\ Pernik",
"3597054", "Rila",
"3596135", "Varbovka",
"359675", "Sevlievo",
"3599524", "Yagodovo\,\ Mont\.",
"35931604", "Dragoynovo",
"3598132", "Yudelnik",
"35971504", "Belopoptsi",
"3597547", "Valkosel",
"3593622", "Stremtsi",
"3594102", "Yastrebovo\,\ St\.\ Zagora",
"3593328", "Dolnoslav",
"3599747", "Mokresh\,\ Mont\.",
"35955505", "Drachevo",
"35931309", "Kliment\,\ Plovdiv",
"3596516", "Iskar\,\ Pleven",
"3597442", "Yakoruda",
"35977226", "Debeli\ lag",
"35931706", "Suhozem",
"3594342", "Ovoshtnik",
"3594557", "Bikovo",
"3593191", "Brezovo\,\ Plovdiv",
"3595397", "Metodievo\,\ Shumen",
"3593195", "Rozovets",
"3593675", "Fotinovo\,\ Kardzh\.",
"3593671", "Podkova",
"3595117", "Botevo\,\ Varna",
"3596998", "Golyam\ izvor\,\ Lovech",
"3593533", "Bata",
"3595732", "Petleshkovo",
"3599783", "Brusartsi",
"35931620", "Dobri\ dol\,\ Plovdiv",
"3594358", "Skobelevo\,\ St\.\ Zagora",
"35941332", "Naydenovo",
"3593776", "Raykova\ mogila",
"359697", "Lukovit",
"3596047", "Zelena\ morava",
"35941279", "Strelets\,\ St\.\ Zagora",
"35991401", "Vranyak",
"35951538", "Izgrev\,\ Varna",
"3595746", "Belgun",
"3593130", "Karavelovo\,\ Plovdiv",
"3594369", "Aleksandrovo\,\ St\.\ Zagora",
"35947201", "Izgrev\,\ Yambol",
"3593109", "Lilkovo",
"3597436", "Levunovo",
"3598620", "Silistra",
"3594595", "Sborishte",
"3598694", "Zebil",
"3597167", "Tserovo\,\ Sofia",
"3594764", "Malenovo",
"35953437", "Gabritsa\,\ Shumen",
"3596554", "Krushovene",
"3593157", "Bolyarino",
"3594336", "Dolno\ Izvorovo",
"3595351", "Smyadovo",
"3595577", "Podvis\,\ Burgas",
"3593658", "Padina\,\ Kardzh\.",
"3594716", "Veselinovo\,\ Yambol",
"3594793", "Boyadzhik",
"3593547", "Sarnitsa\,\ Pazardzhik",
"3598663", "Sitovo\,\ Silistra",
"3597938", "Dolno\ Uyno",
"35931791", "Begovo",
"3596144", "Dolna\ Lipnitsa",
"35981262", "Bistrentsi",
"35951536", "Nikolaevka",
"359676", "Dryanovo\,\ Gabr\.",
"3593724", "Susam",
"3593054", "Podvis\,\ Smol\.",
"3593636", "Raven",
"35935251", "Bratanitsa",
"35984727", "Kamenovo\,\ Razgrad",
"3595312", "Dibich",
"35951104", "Dolishte\,\ Varna",
"3593348", "Dobralak",
"35944", "Sliven",
"3599727", "Medkovets",
"35973", "Blagoevgrad",
"3597527", "Gorno\ Dryanovo",
"3593642", "Potochnitsa",
"35967309", "Agatovo",
"35963573", "Disevitsa",
"3599544", "Studeno\ buche",
"3596033", "Medovina",
"3597744", "Elovdol\,\ Pernik",
"3594147", "Lyubenovo\,\ St\.\ Zagora",
"35931708", "Pesnopoy\,\ Plovdiv",
"3595365", "Lyatno",
"3597157", "Sarantsi",
"3594754", "Kamenets\,\ Yambol",
"35971302", "Bozhenitsa",
"3596564", "Zagrazhden\,\ Pleven",
"3595361", "Kaolinovo",
"3593167", "Bryagovo\,\ Plovdiv",
"35931705", "Gorna\ mahala",
"3594359", "Asen\,\ St\.\ Zagora",
"3595599", "Hadzhiite",
"3596905", "Divchovoto",
"35930414", "Devin",
"3596901", "Glozhene\,\ Lovech",
"3594322", "Yagoda",
"3597914", "Vaksevo",
"3594368", "Tarnicheni",
"3597422", "Topolnitsa\,\ Blag\.",
"3593108", "Boykovo",
"3596002", "Saedinenie\,\ Targ\.",
"35991184", "Rakevo",
"35960451", "Obitel",
"3597533", "Osikovo\,\ Blag\.",
"3593583", "Gabrovitsa",
"3596176", "Polikraishte",
"3595782", "Benkovski\,\ Dobr\.",
"3598640", "Pravda\,\ Silistra",
"35946", "Yambol",
"3596027", "Dralfa",
"35967302", "Kravenik",
"35991201", "Lyuti\ brod",
"3594580", "Borintsi",
"3594567", "Banya\,\ Sliven",
"3595726", "Tsarichino",
"35961307", "Stambolovo\,\ V\.\ Tarnovo",
"3599164", "Krushovitsa\,\ Vratsa",
"35930412", "Devin",
"35943616", "Turia",
"3597922", "Dragovishtitsa\,\ Kyust\.",
"35947192", "Zavoy",
"3598152", "Krasen\,\ Ruse",
"3598633", "Staro\ selo\,\ Silistra",
"3599740", "Septemvriytsi\,\ Mont\.",
"3593045", "Dospat",
"35971304", "Lipnitsa\,\ Sofia",
"35959407", "Sini\ rid",
"3593123", "Kaloyanovo\,\ Plovdiv",
"3598129", "Lom\ Cherkovna",
"3596572", "Suhache",
"3593936", "Gorski\ izvor\,\ Hask\.",
"35941175", "Kolena",
"3593639", "Nanovitsa\,\ Kardzh\.",
"3596518", "Riben",
"3593666", "Popsko",
"3596151", "Elena\,\ V\.\ Tarnovo",
"3596155", "Konstantin",
"3597034", "Dzherman",
"3593326", "Patriarh\ Evtimovo",
"3598148", "Gorno\ Ablanovo",
"3595918", "Rusokastro",
"3599551", "Georgi\ Damyanovo",
"3593520", "Miryantsi",
"3599555", "Kopilovtsi\,\ Mont\.",
"3597751", "Breznik",
"3593765", "Ivanovo\,\ Hask\.",
"3597143", "Vakarel",
"35991182", "Osen\,\ Vratsa",
"3599172", "Selanovtsi",
"3597755", "Velkovtsi\,\ Pernik",
"359318", "Saedinenie\,\ Plovdiv",
"35963205", "Chervena",
"3596063", "Bayachevo",
"35931996", "Svezhen",
"3594523", "Stoil\ voyvoda",
"35967304", "Kramolin",
"3595335", "Milanovo\,\ Shumen",
"35930419", "Yagodina",
"3598627", "Babuk",
"3596534", "Malchika",
"35930459", "Brashten",
"3593137", "Klisura\,\ Plovdiv",
"3597106", "Yamna",
"3594356", "Hadzhidimitrovo\,\ St\.\ Zagora",
"3593778", "Studena\,\ Hask\.",
"3593712", "Malevo\,\ Hask\.",
"3599125", "Gorna\ Beshovitsa",
"3595748", "Durankulak",
"3595513", "Gabar",
"3597187", "Bunovo\,\ Sofia",
"3599121", "Tsarevets\,\ Vratsa",
"3597438", "Katuntsi",
"3594745", "Sharkovo",
"3593019", "Pisanitsa",
"3594741", "Bolyarovo",
"3594153", "Madrets\,\ St\.\ Zagora",
"3594338", "Kran",
"35981264", "Piperkovo",
"3596179", "Krusheto",
"3593553", "Batak\,\ Pazardzhik",
"3595752", "Nova\ Kamena",
"35984736", "Podayva",
"35991189", "Tri\ kladentsi",
"35941178", "Oryahovitsa\,\ St\.\ Zagora",
"3595324", "Harsovo\,\ Shumen",
"3596525", "Barkach",
"3596913", "Slavyani",
"3596521", "Sadovets",
"35961607", "Balkantsi\,\ V\.\ Tarnovo",
"3599134", "Tarnak",
"359379", "Svilengrad",
"3597926", "Konyavo",
"3599564", "Stubel",
"3593754", "Lozen\,\ Hask\.",
"3595101", "Dabravino",
"3593024", "Taran",
"3598156", "Cherven\,\ Ruse",
"3595105", "Priseltsi\,\ Varna",
"3596576", "Radomirtsi",
"3598138", "Brashlen",
"3593932", "Bodrovo",
"35963576", "Tuchenitsa",
"3594108", "Vasil\ Levski\,\ St\.\ Zagora",
"3593628", "Miladinovo",
"3597133", "Pravets",
"3593322", "Zlatovrah",
"3593662", "Zhelezino",
"3595714", "Karapelit",
"3594583", "Kipilovo",
"3599176", "Leskovets\,\ Vratsa",
"3595319", "Drumevo",
"3596733", "Kormyansko",
"3597044", "Babino",
"3593567", "Kovachevo\,\ Pazardzhik",
"3593035", "Varbina",
"35941480", "Kolarovo\,\ St\.\ Zagora",
"3598643", "Zlatoklas",
"3596164", "Bryagovitsa",
"3597102", "Lopyan",
"3594352", "Gorno\ Cherkovishte",
"3598114", "Pirgovo",
"3595944", "Ruen\,\ Burgas",
"3599144", "Nivyanin",
"35984740", "Bisertsi",
"3597127", "Shiroki\ dol",
"3594724", "Razdel\,\ Yambol",
"3599181", "Kravoder",
"3599185", "Beli\ Izvor",
"3594329", "Dolno\ Sahrane",
"35995277", "Cherkaski",
"3598660", "Tutrakan",
"359720", "Etropole",
"3597448", "Bachevo",
"35963561", "Grivitsa",
"3596727", "Ganchovets",
"35941357", "Zetyovo\,\ St\.\ Zagora",
"3595756", "Bozhan",
"35934", "Pazardzhik",
"3594348", "Dunavtsi\,\ St\.\ Zagora",
"3596581", "Byala\ voda\,\ Pleven",
"3596030", "Svetlen\,\ Targ\.",
"3596585", "Belene",
"3595345", "Razvigorovo",
"3596544", "Novachene\,\ Pleven",
"3595341", "Hitrino",
"3593147", "Novo\ selo\,\ Plovdiv",
"35984778", "Bogdantsi\,\ Razgrad",
"3596992", "Zlatna\ Panega",
"3595738", "Spasovo\,\ Dobr\.",
"3598159", "Koshov",
"3594712", "Kabile",
"3593784", "Konstantinovo\,\ Hask\.",
"3596043", "Dolno\ Novkovo",
"3596121", "Nikyup",
"3594778", "Pobeda\,\ Yambol",
"3597734", "Glavanovtsi\,\ Pernik",
"3597929", "Sovolyano",
"3594137", "Veren",
"3596125", "Pushevo",
"3595771", "Krushari",
"3595775", "Polkovnik\ Dyakovo",
"3598122", "Tsenovo\,\ Ruse",
"3593745", "Malak\ izvor\,\ Hask\.",
"3597163", "Iskrets",
"3593928", "Dolno\ Belevo",
"3593153", "Stryama",
"3593741", "Mandra",
"3596579", "Ruptsi\,\ Pleven",
"3593632", "Dzhebel",
"35931993", "Sarnegor",
"35947354", "Kamenna\ reka",
"3595316", "Salmanovo",
"35969031", "Galata",
"3596910", "Malinovo",
"3594553", "Rakovo\,\ Sliven",
"3595393", "Ivanovo\,\ Shumen",
"3593646", "Tokachka",
"35953223", "Tsarkvitsa",
"3599521", "Zamfirovo",
"3599525", "Dolno\ Ozirovo",
"3593537", "Panagyurski\ kolonii",
"3599787", "Smirnenski\,\ Mont\.",
"35935502", "Fotinovo\,\ Pazardzhik",
"3597725", "Klenovik",
"3596134", "Byala\ cherkva\,\ V\.\ Tarnovo",
"3593719", "Knizhovnik",
"3594123", "Bogomilovo",
"3593674", "Samodiva",
"35984733", "Ludogortsi",
"359973", "Kozloduy",
"3594326", "Enina",
"3597718", "Dragichevo",
"3593194", "Zelenikovo\,\ Plovdiv",
"3593120", "Hrabrino",
"3597426", "Marikostinovo",
"3598630", "Silistra",
"3599518", "Marchevo",
"3598695", "Nozharevo",
"3595354", "Rish",
"3596555", "Baykal",
"3598691", "Silistra",
"3596006", "Presian",
"359418", "Galabovo\,\ St\.\ Zagora",
"35967390", "Shumata",
"35969240", "Hlevene",
"3596551", "Trastenik\,\ Pleven",
"3596118", "Voneshta\ voda",
"3594761", "Straldzha",
"35974348", "Igralishte",
"3595759", "Kochmar",
"3596060", "Ovcharovo\,\ Targ\.",
"3594520", "Konyovo",
"359309", "Pamporovo",
"3593523", "Sinitevo",
"3599317", "Archar",
"35961393", "Gorsko\ Kosovo",
"3595768", "Odrintsi\,\ Dobr\.",
"3599149", "Bukovets\,\ Vratsa",
"3596562", "Gigen",
"3595949", "Planinitsa\,\ Burgas",
"3594752", "Parvenets\,\ Yambol",
"35941275", "Lyaskovo\,\ St\.\ Zagora",
"3596528", "Valchitran",
"3593676", "Benkovski\,\ Kardzh\.",
"35984734", "Todorovo\,\ Razgrad",
"35955502", "Suhodol\,\ Burgas",
"3594324", "Shipka",
"3595537", "Sadievo\,\ Burgas",
"359936", "Belogradchik",
"3593196", "Drangovo\,\ Plovdiv",
"3597912", "Gorna\ Grashtitsa",
"3597424", "Karnalovo",
"359610", "Pavlikeni\,\ V\.\ Tarnovo",
"3594729", "Kirilovo\,\ Yambol",
"3593113", "Branipole",
"35965165", "Pisarovo\,\ Pleven",
"3594335", "Razhena",
"3596004", "Makovo",
"3596327", "Ovcha\ mogila",
"35981465", "Batin",
"3594331", "Gurkovo\,\ St\.\ Zagora",
"3596950", "Gumoshtnik",
"3597435", "Sklave",
"35931308", "Bogdan\,\ Plovdiv",
"3594748", "Voden\,\ Yambol",
"3596937", "Sokolovo\,\ Lovech",
"3594513", "Gavrailovoc",
"3595784", "Vrachantsi",
"3599128", "Eliseyna",
"3595745", "Vranino",
"3593510", "Ovchepoltsi",
"35961394", "Daskot",
"35941338", "Tselina",
"3595153", "Suvorovo",
"3595338", "Troitsa",
"35981266", "Starmen\,\ Ruse",
"3599162", "Mihaylovo\,\ Vratsa",
"3596549", "Sanadinovo",
"35984467", "Seslav",
"3593775", "Generalovo",
"3593759", "Borislavtsi",
"3593786", "Navasen",
"3593029", "Petkovo\,\ Smol\.",
"3598184", "Glodzhevo",
"3593707", "Nikolovo\,\ Hask\.",
"3596142", "Obedinenie",
"3599569", "Lipen",
"35941335", "Mogilovo",
"3593768", "Dositeevo",
"35971587", "Golema\ Rakovitsa",
"3598145", "Trastenik\,\ Ruse",
"3593722", "Mineralni\ bani\,\ Hask\.",
"3599115", "Chiren",
"3595915", "Balgarovo",
"3593052", "Laki\,\ Plovdiv",
"3595523", "Krumovo\ gradishte",
"35967306", "Gradishte\,\ Gabr\.",
"3598141", "Dve\ mogili",
"3599558", "Gavril\ Genovo",
"3599111", "Chelopek",
"3595314", "Belokopitovo",
"3596515", "Slavyanovo\,\ Pleven",
"3596923", "Goran",
"35947353", "Balgarska\ polyana",
"3596158", "Sredni\ kolibi",
"3596511", "Pobeda\,\ Pleven",
"35971306", "Rashkovo",
"3596770", "Plachkovtsi",
"3595719", "Donchevo",
"3593644", "Egrek",
"35941350", "Mirovo\,\ St\.\ Zagora",
"3595120", "Bozveliysko",
"3599542", "Smolyanovtsi",
"3596169", "Blagoevo\,\ V\.\ Tarnovo",
"35951539", "Levski\,\ Varna",
"3599330", "Rabrovo",
"359558", "Aytos",
"3596136", "Suhindol",
"3597742", "Kalishte",
"3593679", "Kirkovo",
"359677", "Tryavna",
"3596532", "Balgarene\,\ Pleven",
"35971221", "Yarlovo",
"35937701", "Sladun",
"35991186", "Baurene",
"3598116", "Ivanovo\,\ Ruse",
"3599146", "Sokolare",
"35984760", "Trapishte",
"3595946", "Tranak",
"35931992", "Padarsko",
"35956", "Burgas",
"3595580", "Troyanovo\,\ Burgas",
"3594726", "Malomirovo",
"3598673", "Alfatar",
"3599343", "Gomotartsi",
"3593101", "Voyvodinovo",
"3595754", "Zarnevo",
"3593105", "Manolsko\ Konare",
"3594361", "Pavel\ banya",
"3594599", "Chervenakovo",
"35930416", "Gyovren",
"3596980", "Belentsi",
"3596967", "Kaleytsa",
"35930456", "Chavdar\,\ Smol\.",
"3596908", "Glogovo",
"3596546", "Lozitsa\,\ Pleven",
"3595368", "Takach",
"3599132", "Knezha",
"35941111", "Starozagorski\ bani",
"35953222", "Markovo\,\ Shumen",
"35984732", "Yonkovo",
"35954", "Shumen",
"3597924", "Shishkovtsi",
"35951106", "Osenovo\,\ Varna",
"3593756", "Valche\ pole",
"3593026", "Smilyan",
"35931605", "Bukovo\,\ Plovdiv",
"3593177", "Novo\ Zhelezare",
"35971505", "Churek",
"3596574", "Chomakovtsi",
"35931387", "Prolom",
"3593345", "Lyaskovo\,\ Plovdiv",
"3592", "Sofia",
"35955504", "Bogdanovo\,\ Burgas",
"3593341", "Konush\,\ Plovdiv",
"3597032", "Yahinovo",
"3595147", "Pchelnik\,\ Varna",
"3595716", "Paskalevo",
"3597046", "Boboshevo",
"3599174", "Gorni\ Vadin",
"35969247", "Gostinya",
"35967397", "Ryahovtsite",
"3597935", "Dolno\ selo",
"35974386", "Pirin",
"3596166", "Vinograd",
"3593651", "Ardino",
"359749", "Bansko",
"3597104", "Laga",
"3594354", "Zimnitsa\,\ St\.\ Zagora",
"3595765", "Lovchantsi",
"359518", "Provadia",
"3596536", "Asparuhovo\,\ Pleven",
"3595761", "Batovo",
"3595942", "Lyulyakovo\,\ Burgas",
"3599142", "Lazarovo",
"35984720", "Topchii",
"3596569", "Lenkovo",
"3595520", "Cherkovo",
"3594722", "Granitovo\,\ Yambol",
"3598698", "Shumentsi",
"35936700", "Shoptsi",
"3594768", "Zimnitsa\,\ Yambol",
"3596111", "Kapinovo\,\ V\.\ Tarnovo",
"3596558", "Slavovitsa\,\ Pleven",
"3596115", "Resen",
"35974401", "Gorno\ Draglishte",
"3595958", "Gramatikovo",
"3595123", "Ravna\,\ Varna",
"3599515", "Madan\,\ Mont\.",
"35984711", "Mortagonovo",
"3593071", "Zlatograd",
"3597711", "Kladnitsa",
"3593075", "Dolen\,\ Smol\.",
"3599333", "Boynitsa",
"3597715", "Studena\,\ Pernik",
"3599169", "Rogozen",
"3595969", "Galabets\,\ Burgas",
"3596542", "Vabel\,\ Pleven",
"3595326", "Varbyane",
"3596920", "Lesidren",
"3596994", "Brestnitsa\,\ Lovech",
"3599136", "Galiche",
"35963572", "Yasen\,\ Pleven",
"3597728", "Drugan",
"3597058", "Stob",
"35947356", "Mramor\,\ Yambol",
"3596149", "Kutsina",
"3593752", "Malko\ gradishte",
"3593110", "Popovitsa",
"3593022", "Vievo",
"3595553", "Orlintsi",
"3599528", "Gaganitsa",
"3593729", "Krivo\ pole",
"3593934", "Skobelevo\,\ Hask\.",
"3593059", "Kutela",
"3594113", "Preslaven",
"359579", "Albena",
"3593324", "Izbeglii",
"3597036", "Balanovo",
"359590", "Tsarevo",
"359910", "Mezdra",
"3593664", "Plevun",
"3593748", "Lyaskovets\,\ Hask\.",
"3593513", "Malo\ Konare",
"3593925", "Krum",
"3595712", "Stozher",
"3599327", "Chuprene",
"35935391", "Blatnitsa",
"35951127", "Razdelna\,\ Varna",
"359650", "Levski\,\ Pleven",
"3593921", "Merichleri",
"3598165", "Smirnenski\,\ Ruse",
"35974495", "Yurukovo",
"3598161", "Vetovo",
"3595137", "Kaloyan",
"3597042", "Korkina",
"3594771", "Malomir\,\ Yambol",
"3596953", "Borima",
"3594775", "Karavelovo\,\ Yambol",
"3596128", "Hotnitsa",
"35967303", "Batoshevo",
"3594510", "Zhelyu\ voyvoda",
"3599549", "Dolna\ Riksa",
"35963579", "Ralevo",
"35960378", "Tsar\ Asen\,\ Targ\.",
"3595735", "Krasen\,\ Dobr\.",
"3596566", "Dolni\ Vit",
"3594756", "Polyana\,\ Yambol",
"3595731", "General\ Toshevo\,\ Dobr\.",
"3595348", "Trem",
"3593672", "Chorbadzhiysko",
"35947193", "Mogila\,\ Yambol",
"3596539", "Gradishte\,\ Pleven",
"35930413", "Devin",
"3597916", "Bagrentsi",
"3594345", "Raduntsi",
"3594341", "Cherganovo",
"3596588", "Dekov",
"3593192", "Babek",
"3597445", "Banya\,\ Blag\.",
"3594738", "Hlyabovo",
"35959400", "Daskotna",
"3595352", "Yankovo",
"3594592", "Byala\ palanka",
"35991183", "Furen",
"35941019", "Venets\,\ St\.\ Zagora",
"35961101", "Velchevo\,\ V\.\ Tarnovo",
"3596174", "Draganovo\,\ V\.\ Tarnovo",
"3599188", "Gorno\ Peshtene",
"3595724", "Dropla\,\ Dobr\.",
"3599139", "Tarnava\,\ Vratsa",
"3595329", "Mirovtsi",
"359339", "Stamboliyski\,\ Plovdiv",
"3599166", "Hayredin",
"3597117", "Gradets\,\ Sofia",
"3593038", "Chokmanovo",
"3594714", "Drazhevo",
"3593782", "Kalugerovo\,\ Hask\.",
"3598670", "Silistra",
"3599340", "Septemvriytsi\,\ Vidin",
"3596146", "Polski\ Senovets",
"3597732", "Vukan",
"35974325", "Lilyanovo",
"3597039", "Samoranovo",
"3598124", "Novgrad",
"35930200", "Zagrazhden\,\ Smol\.",
"3593726", "Klokotnitsa",
"3593634", "Pripek\,\ Kardzh\.",
"3593056", "Chepintsi\,\ Smol\.",
"35974207", "General\ Todorov",
"35951103", "Lyuben\ Karavelovo",
"3598135", "Babovo",
"3594101", "Opan",
"3598131", "Borisovo\,\ Ruse",
"3595167", "Venchan",
"3593625", "Shiroko\ pole",
"3594105", "Byalo\ pole",
"35963574", "Todorovo\,\ Pleven",
"3599546", "Slavotin",
"35959694", "Gaberovo",
"3596717", "Lesicharka",
"3595108", "Sadovo\,\ Varna",
"35960375", "Garchinovo",
"3596983", "Dermantsi",
"3596132", "Karaisen",};
$areanames{bg} = {"3598118", "Николово\,\ Русе",
"35931709", "Михилци",
"3599148", "Бъркачево",
"35977229", "Гълъбник",
"3595948", "Снягово\,\ Бургас",
"35967308", "Ловнидол",
"35981466", "Помен",
"3596529", "Коиловци",
"3598692", "Стефан\ Караджа\,\ Силистра",
"3594762", "Воденичане",
"3596552", "Долна\ Митрополия",
"3596175", "Първомайци",
"3594728", "Мелница",
"359861", "Силистра",
"3595163", "Млада\ гвардия",
"3594344", "Шаново",
"3597444", "Белица\,\ Благ\.",
"3594749", "Ружица\,\ Ямбол",
"35941276", "Могила\,\ Ст\.\ Загора",
"3595952", "Малко\ Търново",
"3595366", "Браничево",
"35967774", "Белица\,\ Габр\.",
"3596987", "Карлуково",
"3596960", "Белиш",
"3595734", "Преселенци",
"3599129", "Синьо\ бърдо",
"3596906", "Черни\ Вит",
"35967391", "Столът",
"35969241", "Йоглав",
"3596713", "Враниловци",
"3596548", "Дебово",
"3599522", "Котеновци",
"3593758", "Йерусалимово",
"35931702", "Долна\ махала\,\ Пловдив",
"3593028", "Арда",
"35977222", "Горна\ Диканя",
"3595140", "Шкорпиловци",
"3597052", "Пастра",
"3599568", "Благово\,\ Монт\.",
"35937707", "Щит",
"35971227", "Бели\ Искър",
"3593769", "Орешец\,\ Хаск\.",
"3596943", "Горско\ Сливово",
"3594104", "Кравино",
"35941174", "Подслон\,\ Ст\.\ Загора",
"3593624", "Чифлик\,\ Кърдж\.",
"3599559", "Горна\ Ковачица",
"3598134", "Малко\ Враново",
"3595772", "Телериг",
"3597048", "Блажиево",
"35937422", "Долни\ Главанак",
"3596159", "Златарица",
"35941336", "Яздач",
"35981268", "Кривина\,\ Русе",
"3598125", "Копривец",
"3593631", "Момчилград",
"3595718", "Смолница",
"3594711", "Безмер\,\ Ямбол",
"3596168", "Сушица\,\ В\.\ Търново",
"35967305", "Стоките",
"35941117", "Казанка",
"3593049", "Беден",
"3594715", "Калчево",
"35963204", "Деляновци",
"3596122", "Беляковец",
"35930415", "Девин",
"3596526", "Върбица\,\ Плевен",
"3593678", "Чакаларово",
"3595342", "Капитан\ Петко",
"3595557", "Бистрец\,\ Бургас",
"3596991", "Ябланица",
"35931704", "Иван\ Вазово",
"359938", "Кула",
"3595530", "Пещерско",
"3599514", "Владимирово\,\ Монт\.",
"359601", "Търговище",
"35941172", "Горно\ Ботево",
"3594732", "Устрем",
"359457", "Нова\ Загора",
"35951108", "Изворско",
"3593074", "Ерма\ река",
"3597714", "Мещица",
"35930256", "Гълъбово\,\ Смол\.",
"3596582", "Белене",
"3593198", "Чехларе",
"3599182", "Девене",
"3595133", "Генерал\ Колево\,\ Варна",
"3594746", "Попово\,\ Ямбол",
"35974388", "Горно\ Спанчево",
"3599323", "Дреновец",
"3596114", "Килифарево",
"3593517", "Лесичово",
"35937424", "Козлец",
"35991185", "Пудрия",
"3595336", "Имренчево",
"3594351", "Копринка",
"3596930", "Славщица",
"35968", "Ловеч",
"3594355", "Бузовград",
"3597105", "Малки\ Искър",
"3596909", "Малка\ Желязна",
"35963202", "Драгомирово\,\ В\.\ Търново",
"3595764", "Владимирово\,\ Добр\.",
"3599126", "Камено\ поле",
"35963560", "Радишево",
"3596957", "Голяма\ Желязна",
"3594774", "Крумово\,\ Ямбол",
"3597177", "Алдомировци",
"359971", "Лом",
"359751", "Гоце\ Делчев",
"3593032", "Средногорци",
"3593700", "Тракиец",
"35931397", "Христо\ Даново",
"3593924", "Крепост",
"35941179", "Хан\ Аспарухово",
"3599556", "Говежда",
"35991188", "Галатин",
"3593766", "Бисер",
"35974323", "Лозеница",
"3598164", "Писанец",
"359556", "Обзор",
"3599337", "Грамада",
"3593931", "Каснаково",
"3593935", "Върбица\,\ Хаск\.",
"3593321", "Тополово\,\ Пловдив",
"3595127", "Манастир\,\ Варна",
"3593665", "Свирачи",
"35931403", "Триводици",
"3596156", "Родина",
"3593661", "Ивайловград",
"3593325", "Червен\,\ Пловдив",
"3596138", "Недан",
"35960373", "Посабина",
"35931606", "Воден\,\ Пловдив",
"35930418", "Буйново\,\ Смол\.",
"3593046", "Барутин",
"3595102", "Падина\,\ Варна",
"35971506", "Габра",
"35930458", "Любча",
"3595346", "Каменяк\,\ Шумен",
"3593693", "Лясково\,\ Кърдж\.",
"3598477", "Самуил",
"3596522", "Згалево",
"3596568", "Дъбован",
"3593104", "Ягодово\,\ Пловдив",
"3594736", "Светлина",
"3595751", "Тервел\,\ Добр\.",
"3595143", "Бяла\,\ Варна",
"35974201", "Капатово",
"3594364", "Осетеново",
"3595755", "Коларци",
"3597918", "Ябълково\,\ Кюст\.",
"3598699", "Търновци\,\ Силистра",
"3596559", "Гостиля",
"3596586", "Белене",
"3593173", "Паничери",
"3599186", "Згориград",
"3595959", "Звездец",
"3594742", "Стефан\ Караджово",
"35981463", "Могилино",
"35981886", "Черешово\,\ Русе",
"3595332", "Драгоево",
"3595968", "Каблешково\,\ Бургас",
"3599168", "Бутан",
"3593711", "Долно\ Ботево",
"3599122", "Зверино",
"3597934", "Буново\,\ Кюст\.",
"35974496", "Филипово\,\ Благ\.",
"3597729", "Долна\ Диканя",
"3596148", "Павел",
"35941333", "Средно\ градище",
"3593036", "Могилица",
"3599529", "Боровци",
"35984779", "Здравец\,\ Разград",
"3598677", "Сребърна",
"3599347", "Бела\ Рада",
"3599552", "Белимел",
"3593728", "Славяново\,\ Хаск\.",
"3593058", "Мугла",
"3597110", "Опицвет",
"3599175", "Остров",
"3597752", "Режанци",
"35931627", "Крушево\,\ Пловдив",
"3593762", "Изворово\,\ Хаск\.",
"3599171", "Оряхово\,\ Враца",
"3596575", "Телиш",
"35936401", "Странджево",
"3596571", "Лепица",
"3593749", "Гарваново",
"3596963", "Балканец",
"3596152", "Беброво",
"3596710", "Донино",
"35971338", "Осиковска\ Лакавица",
"35961107", "Момин\ сбор",
"3593344", "Новаково\,\ Пловдив",
"3597925", "Гюешево",
"359470", "Тополовград",
"3596129", "Габровци",
"3597921", "Жиленци",
"3598151", "Просена",
"3599548", "Крапчене",
"3595106", "Аврен\,\ Варна",
"3593042", "Борино",
"3593703", "Жълти\ бряг",
"3597192", "Гинци",
"3593774", "Левка",
"3595349", "Студеница",
"3596538", "Обнова",
"3596001", "Черковна\,\ Търг\.",
"3598696", "Суходол\,\ Силистра",
"3596556", "Горна\ Митрополия",
"3596589", "Кулина\ вода",
"3594334", "Елхово\,\ Ст\.\ Загора\,\ общ\.\ Николаево",
"3595527", "Соколово\,\ Бургас",
"359729", "Годеч",
"3597434", "Струмяни",
"3595781", "Свобода\,\ Добр\.",
"3594739", "Радовец",
"3594321", "Мъглиж",
"3594325", "Кънчево",
"35952", "Варна",
"3599189", "Паволче",
"3597425", "Кулата",
"3596927", "Умаревци",
"3595362", "Климент\,\ Шумен",
"3599138", "Алтимир",
"3599353", "Кошава",
"35960450", "Долна\ Хубавка",
"3595328", "Никола\ Козлево",
"3596902", "Рибарица\,\ Ловеч",
"35984774", "Голям\ извор\,\ Разград",
"3593039", "Полковник\ Серафимово",
"3599526", "Слатина\,\ Монт\.",
"3597726", "Дрен",
"3597056", "Мурсалево",
"35960376", "Люблен",
"3595311", "Градище\,\ Шумен",
"3593117", "Катуница",
"359554", "Слънчев\ бряг",
"3595315", "Царев\ брод",
"3596514", "Долни\ Дъбник",
"35971503", "Долно\ Камарци",
"3593645", "Аврен\,\ Кърдж\.",
"35931603", "Виница",
"359357", "Панагюрище",
"3593641", "Крумовград",
"3595533", "Пирне",
"3596077", "Стеврек",
"3595776", "Черна\,\ Добр\.",
"35960387", "Глогинка",
"3594517", "Ичера",
"3596933", "Голец",
"3593746", "Сираково\,\ Хаск\.",
"35974407", "Кремен\,\ Благ\.",
"359417", "Раднево",
"3598144", "Батишница",
"35984717", "Побит\ камък\,\ Разград",
"3596323", "Българско\ сливово",
"3595914", "Атия",
"3598185", "Сеново",
"35957307", "Житен\,\ Добр\.",
"3595130", "Генерал\ Киселово",
"3599320", "Стакевци",
"3596126", "Церова\ кория",
"359675", "Севлиево",
"3599524", "Ягодово\,\ Монт\.",
"3597724", "Извор\,\ Перник",
"3597939", "Църварица",
"3596135", "Върбовка",
"3597054", "Рила",
"35932", "Пловдив",
"35941339", "Димитриево",
"35955505", "Драчево",
"3596516", "Искър\,\ Плевен",
"35931309", "Климент\,\ Пловдив",
"3599747", "Мокреш\,\ Монт\.",
"3593328", "Долнослав",
"3597547", "Вълкосел",
"35971504", "Белопопци",
"3593622", "Стремци",
"3594102", "Ястребово\,\ Ст\.\ Загора",
"3598132", "Юделник",
"35931604", "Драгойново",
"3595774", "Коритен",
"35981462", "Волово",
"3593349", "Боянци",
"3599116", "Костелево",
"3595916", "Росен\,\ Бургас",
"3593744", "Сърница\,\ Хаск\.",
"35930528", "Манастир\,\ Пловдив",
"3593785", "Дряново\,\ Хаск\.",
"3593781", "Симеоновград",
"3597735", "Лева\ река",
"3599313", "Капитановци",
"3596124", "Леденик",
"3593527", "Алеко\ Константиново",
"3597731", "Трън",
"35951538", "Изгрев\,\ Варна",
"3595746", "Белгун",
"3596047", "Зелена\ морава",
"35941279", "Стрелец\,\ Ст\.\ Загора",
"35991401", "Враняк",
"35941332", "Найденово",
"35931620", "Добри\ дол\,\ Пловдив",
"3594358", "Скобелево\,\ Ст\.\ Загора",
"359697", "Луковит",
"3593776", "Райкова\ могила",
"3594336", "Долно\ Изворово",
"3595351", "Смядово",
"3593157", "Болярино",
"3597167", "Церово\,\ София",
"3598694", "Зебил",
"3594595", "Сборище",
"3596554", "Крушовене",
"35953437", "Габрица\,\ Шумен",
"3594764", "Маленово",
"3597436", "Левуново",
"3593109", "Лилково",
"3598620", "Силистра",
"3594369", "Александрово\,\ Ст\.\ Загора",
"3593130", "Каравелово\,\ Пловдив",
"35947201", "Изгрев\,\ Ямбол",
"3593195", "Розовец",
"3594342", "Овощник",
"3595397", "Методиево\,\ Шумен",
"3594557", "Биково",
"3593191", "Брезово\,\ Пловдив",
"3597442", "Якоруда",
"35977226", "Дебели\ лаг",
"35931706", "Сухозем",
"3593533", "Бъта",
"3596998", "Голям\ извор\,\ Ловеч",
"3599783", "Брусарци",
"3595732", "Петлешково",
"3593671", "Подкова",
"3595117", "Ботево\,\ Варна",
"3593675", "Фотиново\,\ Кърдж\.",
"3594772", "Симеоново\,\ Ямбол",
"359453", "Котел",
"35941334", "Съединение\,\ Ст\.\ Загора",
"3597936", "Слокощица",
"3596165", "Асеново\,\ В\.\ Търново",
"359678", "Тетевен",
"3596161", "Стражица\,\ В\.\ Търново",
"3594718", "Роза",
"3593034", "Левочево",
"35931995", "Стрелци\,\ Пловдив",
"3595711", "Овчарово\,\ Добр\.",
"3593638", "Звездел",
"3598128", "Полско\ Косово",
"3593922", "Брод",
"3595715", "Попгригорово",
"3597045", "Голем\ Върбовник",
"3597123", "Ковачевци\,\ София",
"3595570", "Манолич",
"3597041", "Шатрово",
"3596519", "Беглеж",
"3598149", "Кацелово",
"3599119", "Тишевица",
"3595919", "Маринка",
"3594140", "Полски\ Градец",
"3593346", "Мулдава",
"3596723", "Царева\ ливада",
"35961301", "Бяла\ река\,\ В\.\ Търново",
"3597520", "Корница",
"3599561", "Сумер",
"3593143", "Перущица",
"3593751", "Любимец",
"35984738", "Китанчево",
"3593755", "Белица\,\ Хаск\.",
"3593025", "Баните",
"3599720", "Ковачица",
"359631", "Свищов",
"3593779", "Сива\ река",
"3596541", "Никопол",
"35984735", "Свещари",
"3595344", "Велино",
"3596545", "Любеново\,\ Плевен",
"35941274", "Самуилово\,\ Ст\.\ Загора",
"3595749", "Крапец\,\ Добр\.",
"35931602", "Татарево\,\ Пловдив",
"3599512", "Бели\ брег",
"3597439", "Плоски",
"3597137", "Скравена",
"3593106", "Строево",
"35935257", "Сарая",
"35984721", "Липник",
"35971502", "Елешница\,\ София",
"3594734", "Срем",
"3597712", "Батановци",
"3593072", "Неделино",
"3596584", "Белене",
"3594339", "Юлиево",
"359619", "Лясковец\,\ В\.\ Търново",
"3599184", "Оходен",
"3596178", "Стрелец\,\ В\.\ Търново",
"3594725", "Лесово",
"3596737", "Крушево\,\ Габр\.",
"3596020", "Лиляк",
"35981464", "Острица\,\ Русе",
"35931998", "Чоба",
"3594587", "Ябланово",
"3596112", "Самоводене",
"35960380", "Дриново",
"3593563", "Варвара\,\ Пазарджик",
"3595762", "Стефан\ Караджа\,\ Добр\.",
"3598647", "Паисиево",
"3598111", "Щръклево",
"35984710", "Осенец",
"3599141", "Малорад",
"35961395", "Паскалевец",
"3595941", "Скалак\,\ Бургас",
"3598115", "Червена\ вода",
"3595945", "Добромир",
"3599145", "Бреница\,\ Враца",
"3597183", "Душанци",
"3597932", "Шипочано",
"3595517", "Равнец\,\ Бургас",
"3593133", "Калофер",
"3593652", "Бял\ извор\,\ Кърдж\.",
"359517", "Дългопол",
"3598623", "Голеш\,\ Силистра",
"3593926", "Добрич\,\ Хаск\.",
"3594109", "Тракия",
"3593629", "Мост",
"359605", "Омуртаг",
"3599554", "Чипровци",
"3594130", "Спасово\,\ Ст\.\ Загора",
"3598166", "Сваленик",
"3597754", "Кошарево",
"3594157", "Разделна\,\ Ст\.\ Загора",
"3593764", "Поляново\,\ Хаск\.",
"35974324", "Струма",
"3593530", "Поибрене",
"3593648", "Голямо\ Каменяне",
"35984776", "Хърсово\,\ Разград",
"35976", "Перник",
"3596154", "Буйновци",
"3597035", "Червен\ брег",
"3595318", "Средня",
"3593557", "Бяга",
"359868", "Силистра",
"3597031", "Горна\ Козница",
"3593342", "Нареченски\ бани",
"359454", "Твърдица\,\ Сливен",
"35960374", "Горско\ Абланово",
"35963575", "Бохот",
"3597415", "Селище\,\ Благ\.",
"35931108", "Богданица",
"3593044", "Лясково\,\ Смол\.",
"3596917", "Българене\,\ Ловеч",
"3595321", "Правенци",
"3593127", "Царацово",
"3595325", "Войвода",
"35963578", "Опанец\,\ Плевен",
"35942", "Стара\ Загора",
"3598637", "Малък\ Преславец",
"3596524", "Петърница",
"3596590", "Ракита\,\ Плевен",
"35931703", "Житница\,\ Пловдив",
"3599131", "Добролево",
"3599135", "Бърдарски\ геран",
"3593102", "Караджово",
"35984761", "Градина\,\ Разград",
"3594362", "Манолово",
"3597428", "Габрене",
"3599516", "Лехчево",
"35971220", "Гуцал",
"3593076", "Цацаровци",
"35941110", "Старозагорски\ бани",
"3597147", "Пчелин\,\ София",
"3594744", "Голямо\ Крушево",
"35937423", "Големанци",
"3596116", "Големаните",
"3595766", "Методиево\,\ Добр\.",
"3596531", "Изгрев\,\ Плевен",
"3596067", "Кралево\,\ Търг\.",
"3595334", "Осмар",
"3596535", "Козар\ Белене",
"3594527", "Загорци\,\ Сливен",
"359416", "Чирпан",
"359848", "Кубрат",
"3599124", "Типченица",
"3595739", "Пчеларово\,\ Добр\.",
"3599545", "Габровница",
"3598158", "Мечка\,\ Русе",
"3599541", "Доктор\ Йосифово",
"3597928", "Гърляно",
"3597745", "Егълница",
"3593163", "Искра\,\ Пловдив",
"3594779", "Ханово",
"3597741", "Земен",
"359570", "Каварна",
"3596512", "Горни\ Дъбник",
"3598136", "Стамболово\,\ Русе",
"3596578", "Реселец",
"35941173", "Братя\ Кунчеви",
"3593929", "Голямо\ Асеново",
"35941018", "Княжевско",
"3593626", "Перперек",
"3594106", "Пъстрен",
"359608", "Попово\,\ Търг\.",
"359865", "Силистра",
"3593587", "Сестримо",
"359659", "Червен\ бряг",
"3593721", "Стамболово\,\ Хаск\.",
"35963567", "Градина\,\ Плевен",
"3593051", "Чепеларе",
"3598142", "Бъзовец\,\ Русе",
"3593725", "Стамболийски\,\ Хаск\.",
"3595912", "Полски\ извор",
"3599112", "Баница",
"35941351", "Партизанин",
"3593055", "Елховец",
"35974346", "Цапарево",
"35963203", "Хаджидимитрово\,\ В\.\ Търново",
"3596145", "Страхилово",
"3596023", "Подгорица",
"3596141", "Полски\ Тръмбеш",
"35931390", "Московец",
"3594797", "Гълъбинци",
"3593718", "Войводово\,\ Хаск\.",
"3593543", "Дорково",
"3598667", "Белица\,\ Силистра",
"3595742", "Раковски\,\ Добр\.",
"3597120", "Долна\ баня",
"3595573", "Везенково",
"35991668", "Манастирище",
"3593772", "Момково",
"3599161", "Мизия",
"3599165", "Софрониево",
"3593079", "Козарка",
"3597719", "Ярджиловци",
"35974322", "Петрово\,\ Благ\.",
"3594332", "Ветрен\,\ Ст\.\ Загора",
"35991888", "Веслец\,\ Враца",
"3597915", "Невестино\,\ Кюст\.",
"3594346", "Голямо\ Дряново",
"3597523", "Гърмен",
"3596119", "Дичин",
"35931402", "Скобелево\,\ Пловдив",
"3597911", "Граница",
"3597446", "Елешница\,\ Благ\.",
"3599723", "Трайково",
"3595758", "Кладенци",
"3595736", "Василево",
"3594751", "Войника",
"3596561", "Гулянци",
"3594143", "Сърнево\,\ Ст\.\ Загора",
"3596565", "Милковица",
"3594755", "Тамарино",
"35960372", "Крепча",
"3596720", "Керека",
"3595769", "Хитово",
"3593646", "Токачка",
"3595393", "Иваново\,\ Шумен",
"3594553", "Раково\,\ Сливен",
"3595316", "Салманово",
"35969031", "Галата",
"3596910", "Малиново",
"35947354", "Каменна\ река",
"3597725", "Кленовик",
"3596134", "Бяла\ черква\,\ В\.\ Търново",
"3593537", "Панагюрски\ колонии",
"35935502", "Фотиново\,\ Пазарджик",
"3599787", "Смирненски\,\ Монт\.",
"3599525", "Долно\ Озирово",
"35953223", "Църквица",
"3599521", "Замфирово",
"3597929", "Соволяно",
"3597734", "Главановци\,\ Перник",
"3594778", "Победа\,\ Ямбол",
"3596125", "Пушево",
"3594137", "Верен",
"3596043", "Долно\ Новково",
"3596121", "Никюп",
"3593784", "Константиново\,\ Хаск\.",
"3598159", "Кошов",
"3594712", "Кабиле",
"3596579", "Рупци\,\ Плевен",
"3593741", "Мандра",
"3593153", "Стряма",
"35931993", "Сърнегор",
"3593632", "Джебел",
"3593928", "Долно\ Белево",
"3598122", "Ценово\,\ Русе",
"3597163", "Искрец",
"3593745", "Малък\ извор\,\ Хаск\.",
"3595775", "Полковник\ Дяково",
"3595771", "Крушари",
"3596060", "Овчарово\,\ Търг\.",
"3594520", "Коньово",
"359309", "Пампорово",
"35974348", "Игралище",
"3595759", "Кочмар",
"3596006", "Пресиян",
"3598691", "Силистра",
"359418", "Гълъбово\,\ Ст\.\ Загора",
"3594761", "Стралджа",
"3596118", "Вонеща\ вода",
"35969240", "Хлевене",
"3596551", "Тръстеник\,\ Плевен",
"35967390", "Шумата",
"3598695", "Ножарево",
"3595354", "Риш",
"3596555", "Байкал",
"3595768", "Одринци\,\ Добр\.",
"3599317", "Арчар",
"35961393", "Горско\ Косово",
"3593523", "Синитево",
"35984733", "Лудогорци",
"3593674", "Самодива",
"3594123", "Богомилово",
"3593719", "Книжовник",
"3597426", "Марикостиново",
"3599518", "Мърчево",
"3598630", "Силистра",
"3593120", "Храбрино",
"3597718", "Драгичево",
"3594326", "Енина",
"3593194", "Зелениково\,\ Пловдив",
"359973", "Козлодуй",
"3597044", "Бабино",
"3595319", "Друмево",
"3599176", "Лесковец\,\ Враца",
"3596733", "Кормянско",
"3594583", "Кипилово",
"3595714", "Карапелит",
"3596164", "Бряговица",
"3593567", "Ковачево\,\ Пазарджик",
"3598643", "Златоклас",
"35941480", "Коларово\,\ Ст\.\ Загора",
"3593035", "Върбина",
"3598156", "Червен\,\ Русе",
"3595105", "Приселци\,\ Варна",
"3593754", "Лозен\,\ Хаск\.",
"3593024", "Търън",
"3595101", "Дъбравино",
"3599564", "Стубел",
"3597926", "Коняво",
"3593662", "Железино",
"3597133", "Правец",
"3593322", "Златовръх",
"35963576", "Тученица",
"3593628", "Миладиново",
"3594108", "Васил\ Левски\,\ Ст\.\ Загора",
"3593932", "Бодрово",
"3596576", "Радомирци",
"3598138", "Бръшлен",
"3596030", "Светлен\,\ Търг\.",
"3596585", "Белене",
"3594348", "Дунавци\,\ Ст\.\ Загора",
"35934", "Пазарджик",
"3596581", "Бяла\ вода\,\ Плевен",
"35941357", "Зетьово\,\ Ст\.\ Загора",
"3595756", "Божан",
"35963561", "Гривица",
"3597448", "Бачево",
"3596727", "Ганчовец",
"3596992", "Златна\ Панега",
"3595738", "Спасово\,\ Добр\.",
"3593147", "Ново\ село\,\ Пловдив",
"3595341", "Хитрино",
"35984778", "Богданци\,\ Разград",
"3595345", "Развигорово",
"3596544", "Новачене\,\ Плевен",
"3598114", "Пиргово",
"3595944", "Руен\,\ Бургас",
"3599144", "Нивянин",
"35984740", "Бисерци",
"3594352", "Горно\ Черковище",
"3597102", "Лопян",
"35995277", "Черкаски",
"359720", "Етрополе",
"3598660", "Тутракан",
"3594329", "Долно\ Сахране",
"3599185", "Бели\ Извор",
"3597127", "Широки\ дол",
"3594724", "Раздел\,\ Ямбол",
"3599181", "Краводер",
"3597755", "Велковци\,\ Перник",
"35991182", "Осен\,\ Враца",
"3599172", "Селановци",
"359318", "Съединение\,\ Пловдив",
"3597143", "Вакарел",
"3593765", "Иваново\,\ Хаск\.",
"3597751", "Брезник",
"3593520", "Мирянци",
"3599555", "Копиловци\,\ Монт\.",
"3598148", "Горно\ Абланово",
"3599551", "Георги\ Дамяново",
"3595918", "Русокастро",
"35967304", "Крамолин",
"3596063", "Баячево",
"3594523", "Стоил\ войвода",
"35931996", "Свежен",
"35963205", "Червена",
"35959407", "Сини\ рид",
"3593123", "Калояново\,\ Пловдив",
"35971304", "Липница\,\ София",
"3598152", "Красен\,\ Русе",
"3599740", "Септемврийци\,\ Монт\.",
"3593045", "Доспат",
"3598633", "Старо\ село\,\ Силистра",
"35947192", "Завой",
"3597922", "Драговищица\,\ Кюст\.",
"35943616", "Турия",
"35930412", "Девин",
"3593326", "Патриарх\ Евтимово",
"3597034", "Джерман",
"3596155", "Константин",
"3593666", "Попско",
"3596151", "Елена\,\ В\.\ Търново",
"3596518", "Рибен",
"3593936", "Горски\ извор\,\ Хаск\.",
"3596572", "Сухаче",
"3593639", "Нановица\,\ Кърдж\.",
"35941175", "Колена",
"3598129", "Лом\ Черковна",
"35991189", "Три\ кладенци",
"35941178", "Оряховица\,\ Ст\.\ Загора",
"35984736", "Подайва",
"3593553", "Батак\,\ Пазарджик",
"3596179", "Крушето",
"3595752", "Нова\ Камена",
"359379", "Свиленград",
"35961607", "Балканци\,\ В\.\ Търново",
"3599134", "Търнак",
"3596521", "Садовец",
"3595324", "Хърсово\,\ Шумен",
"3596913", "Славяни",
"3596525", "Бъркач",
"3597187", "Буново\,\ София",
"3599121", "Царевец\,\ Враца",
"3593712", "Малево\,\ Хаск\.",
"3595748", "Дуранкулак",
"3595513", "Габър",
"3599125", "Горна\ Бешовица",
"3597106", "Ямна",
"3594356", "Хаджидимитрово\,\ Ст\.\ Загора",
"3593137", "Клисура\,\ Пловдив",
"35930459", "Бръщен",
"3593778", "Студена\,\ Хаск\.",
"35930419", "Ягодина",
"3595335", "Миланово\,\ Шумен",
"3596534", "Малчика",
"3598627", "Бабук",
"35981264", "Пиперково",
"3594338", "Крън",
"3594153", "Мъдрец\,\ Ст\.\ Загора",
"3594741", "Болярово",
"3597438", "Катунци",
"3594745", "Шарково",
"3593019", "Писаница",
"3597527", "Горно\ Дряново",
"3593642", "Поточница",
"35973", "Благоевград",
"3599727", "Медковец",
"3595312", "Дибич",
"35944", "Сливен",
"35951104", "Долище\,\ Варна",
"3593348", "Добралък",
"3597744", "Еловдол\,\ Перник",
"3594147", "Любеново\,\ Ст\.\ Загора",
"35931708", "Песнопой\,\ Пловдив",
"3596033", "Медовина",
"3599544", "Студено\ буче",
"35963573", "Дисевица",
"35967309", "Агатово",
"3597938", "Долно\ Уйно",
"3596144", "Долна\ Липница",
"35931791", "Бегово",
"3593547", "Сърница\,\ Пазарджик",
"3594793", "Бояджик",
"3598663", "Ситово\,\ Силистра",
"3595577", "Подвис\,\ Бургас",
"3594716", "Веселиново\,\ Ямбол",
"3593658", "Падина\,\ Кърдж\.",
"35984727", "Каменово\,\ Разград",
"35935251", "Братаница",
"3593724", "Сусам",
"3593636", "Равен",
"3593054", "Подвис\,\ Смол\.",
"359676", "Дряново\,\ Габр\.",
"35951536", "Николаевка",
"35981262", "Бистренци",
"3596176", "Поликраище",
"3593583", "Габровица",
"3598640", "Правда\,\ Силистра",
"3595782", "Бенковски\,\ Добр\.",
"3597533", "Осиково\,\ Благ\.",
"35960451", "Обител",
"3596002", "Съединение\,\ Търг\.",
"35991184", "Ракево",
"35961307", "Стамболово\,\ В\.\ Търново",
"3599164", "Крушовица\,\ Враца",
"3595726", "Царичино",
"35967302", "Кръвеник",
"3596027", "Дралфа",
"35946", "Ямбол",
"35991201", "Люти\ брод",
"3594567", "Баня\,\ Сливен",
"3594580", "Боринци",
"3596901", "Гложене\,\ Ловеч",
"35930414", "Девин",
"3595599", "Хаджиите",
"3594359", "Асен\,\ Ст\.\ Загора",
"3596905", "Дивчовото",
"3595361", "Каолиново",
"3593167", "Брягово\,\ Пловдив",
"35931705", "Горна\ махала",
"3597157", "Саранци",
"3595365", "Лятно",
"3596564", "Загражден\,\ Плевен",
"35971302", "Боженица",
"3594754", "Каменец\,\ Ямбол",
"3593108", "Бойково",
"3597422", "Тополница\,\ Благ\.",
"3594368", "Търничени",
"3597914", "Ваксево",
"3594322", "Ягода",
"3599188", "Горно\ Пещене",
"3596174", "Драганово\,\ В\.\ Търново",
"35941019", "Венец\,\ Ст\.\ Загора",
"35961101", "Велчево\,\ В\.\ Търново",
"3595352", "Янково",
"3594592", "Бяла\ паланка",
"35991183", "Фурен",
"3599166", "Хайредин",
"359339", "Стамболийски\,\ Пловдив",
"3595329", "Мировци",
"3599139", "Търнава\,\ Враца",
"3595724", "Дропла\,\ Добр\.",
"35930413", "Девин",
"3593672", "Чорбаджийско",
"3595348", "Трем",
"3596539", "Градище\,\ Плевен",
"35947193", "Могила\,\ Ямбол",
"3595731", "Генерал\ Тошево\,\ Добр\.",
"3594756", "Поляна\,\ Ямбол",
"3596566", "Долни\ Вит",
"35960378", "Цар\ Асен\,\ Търг\.",
"3595735", "Красен\,\ Добр\.",
"3597445", "Баня\,\ Благ\.",
"35959400", "Дъскотна",
"3594738", "Хлябово",
"3594341", "Черганово",
"3593192", "Бабек",
"3596588", "Деков",
"3594345", "Радунци",
"3597916", "Багренци",
"3598131", "Борисово\,\ Русе",
"3593625", "Широко\ поле",
"3594105", "Бяло\ поле",
"3595167", "Венчан",
"3598135", "Бабово",
"3594101", "Опан",
"35951103", "Любен\ Каравелово",
"3596983", "Дерманци",
"3596132", "Караисен",
"35960375", "Гърчиново",
"3595108", "Садово\,\ Варна",
"35963574", "Тодорово\,\ Плевен",
"35959694", "Габерово",
"3596717", "Лесичарка",
"3599546", "Славотин",
"3597732", "Вукан",
"3599340", "Септемврийци\,\ Видин",
"3598670", "Силистра",
"3596146", "Полски\ Сеновец",
"3593782", "Калугерово\,\ Хаск\.",
"3597117", "Градец\,\ София",
"3594714", "Дражево",
"3593038", "Чокманово",
"3593726", "Клокотница",
"3593056", "Чепинци\,\ Смол\.",
"35974207", "Генерал\ Тодоров",
"3593634", "Припек\,\ Кърдж\.",
"3598124", "Новград",
"35930200", "Загражден\,\ Смол\.",
"3597039", "Самораново",
"35974325", "Лиляново",
"3597715", "Студена\,\ Перник",
"3599333", "Бойница",
"3593075", "Долен\,\ Смол\.",
"3593071", "Златоград",
"3597711", "Кладница",
"35984711", "Мортагоново",
"3599515", "Мадан\,\ Монт\.",
"3595123", "Равна\,\ Варна",
"35974401", "Горно\ Драглище",
"3595958", "Граматиково",
"3599136", "Галиче",
"35963572", "Ясен\,\ Плевен",
"3596994", "Брестница\,\ Ловеч",
"3595326", "Върбяне",
"3596920", "Лесидрен",
"3599169", "Рогозен",
"3596542", "Въбел\,\ Плевен",
"3595969", "Гълъбец\,\ Бургас",
"3595520", "Черково",
"3595942", "Люляково\,\ Бургас",
"3599142", "Лазарово",
"35984720", "Топчии",
"3596569", "Ленково",
"359518", "Провадия",
"3595761", "Батово",
"3596536", "Аспарухово\,\ Плевен",
"3594354", "Зимница\,\ Ст\.\ Загора",
"3597104", "Лъга",
"3595765", "Ловчанци",
"3596115", "Ресен",
"35936700", "Шопци",
"3598698", "Шуменци",
"3596558", "Славовица\,\ Плевен",
"3596111", "Къпиново\,\ В\.\ Търново",
"3594768", "Зимница\,\ Ямбол",
"3594722", "Гранитово\,\ Ямбол",
"3598161", "Ветово",
"3597042", "Коркина",
"3595137", "Калоян",
"35974495", "Юруково",
"3598165", "Смирненски\,\ Русе",
"3593921", "Меричлери",
"3599327", "Чупрене",
"35935391", "Блатница",
"35951127", "Разделна\,\ Варна",
"359650", "Левски\,\ Плевен",
"3593925", "Крум",
"3593513", "Мало\ Конаре",
"3593748", "Лясковец\,\ Хаск\.",
"3595712", "Стожер",
"3594510", "Желю\ войвода",
"3599549", "Долна\ Рикса",
"35963579", "Ралево",
"35967303", "Батошево",
"3594775", "Каравелово\,\ Ямбол",
"3596128", "Хотница",
"3594771", "Маломир\,\ Ямбол",
"3596953", "Борима",
"3599528", "Гаганица",
"3593110", "Поповица",
"3593752", "Малко\ градище",
"3593022", "Виево",
"3595553", "Орлинци",
"3597728", "Друган",
"3596149", "Куцина",
"3597058", "Стоб",
"35947356", "Мрамор\,\ Ямбол",
"359910", "Мездра",
"359590", "Царево",
"3593664", "Плевун",
"3597036", "Баланово",
"3593324", "Избеглии",
"359579", "Албена",
"3594113", "Преславен",
"3593729", "Криво\ поле",
"3593934", "Скобелево\,\ Хаск\.",
"3593059", "Кутела",
"35930456", "Чавдар\,\ Смол\.",
"3594599", "Червенаково",
"3596980", "Беленци",
"3596967", "Калейца",
"35930416", "Гьоврен",
"3594361", "Павел\ баня",
"3593105", "Манолско\ Конаре",
"3593101", "Войводиново",
"3595754", "Зърнево",
"35953222", "Марково\,\ Шумен",
"35941111", "Старозагорски\ бани",
"3595368", "Тъкач",
"3599132", "Кнежа",
"3596546", "Лозица\,\ Плевен",
"3596908", "Глогово",
"3598116", "Иваново\,\ Русе",
"3595946", "Трънак",
"3599146", "Соколаре",
"35984760", "Трапище",
"35971221", "Ярлово",
"35937701", "Сладун",
"35991186", "Баурене",
"3593679", "Кирково",
"359677", "Трявна",
"3596532", "Българене\,\ Плевен",
"3599343", "Гомотарци",
"3598673", "Алфатар",
"3594726", "Маломирово",
"35956", "Бургас",
"35931992", "Пъдарско",
"3595580", "Трояново\,\ Бургас",
"3599174", "Горни\ Вадин",
"3597046", "Бобошево",
"3595716", "Паскалево",
"359749", "Банско",
"3593651", "Ардино",
"3596166", "Виноград",
"35974386", "Пирин",
"3597935", "Долно\ село",
"35969247", "Гостиня",
"35967397", "Ряховците",
"3593756", "Вълче\ поле",
"3593026", "Смилян",
"3597924", "Шишковци",
"35951106", "Осеново\,\ Варна",
"35984732", "Йонково",
"35954", "Шумен",
"3597032", "Яхиново",
"3595147", "Пчелник\,\ Варна",
"3593341", "Конуш\,\ Пловдив",
"35955504", "Богданово\,\ Бургас",
"3592", "София",
"3593345", "Лясково\,\ Пловдив",
"3596574", "Чомаковци",
"35971505", "Чурек",
"35931387", "Пролом",
"35931605", "Буково\,\ Пловдив",
"3593177", "Ново\ Железаре",
"3595784", "Врачанци",
"35931308", "Богдан\,\ Пловдив",
"3597435", "Склаве",
"3596937", "Соколово\,\ Ловеч",
"3594513", "Гавраилово",
"3594748", "Воден\,\ Ямбол",
"3594331", "Гурково\,\ Ст\.\ Загора",
"35981465", "Батин",
"3596950", "Гумощник",
"3596327", "Овча\ могила",
"3596004", "Маково",
"3594335", "Ръжена",
"3593775", "Генералово",
"35984467", "Сеслав",
"3595338", "Троица",
"35981266", "Стърмен\,\ Русе",
"3596549", "Санадиново",
"3599162", "Михайлово\,\ Враца",
"3593510", "Овчеполци",
"3595153", "Суворово",
"35961394", "Дъскот",
"35941338", "Целина",
"3595745", "Вранино",
"3599128", "Елисейна",
"3593676", "Бенковски\,\ Кърдж\.",
"35984734", "Тодорово\,\ Разград",
"3596528", "Вълчитрън",
"35941275", "Лясково\,\ Ст\.\ Загора",
"3594752", "Първенец\,\ Ямбол",
"3596562", "Гиген",
"3599149", "Буковец\,\ Враца",
"3595949", "Планиница\,\ Бургас",
"3593113", "Браниполе",
"35965165", "Писарово\,\ Плевен",
"359610", "Павликени\,\ В\.\ Търново",
"3597424", "Кърналово",
"3594729", "Кирилово\,\ Ямбол",
"3597912", "Горна\ Гращица",
"3594324", "Шипка",
"35955502", "Суходол\,\ Бургас",
"359936", "Белоградчик",
"3593196", "Дрангово\,\ Пловдив",
"3595537", "Съдиево\,\ Бургас",
"3593644", "Егрек",
"3596770", "Плачковци",
"35971306", "Рашково",
"3595719", "Дончево",
"3596511", "Победа\,\ Плевен",
"3596158", "Средни\ колиби",
"3595314", "Белокопитово",
"35947353", "Българска\ поляна",
"3596923", "Горан",
"3596515", "Славяново\,\ Плевен",
"3597742", "Калище",
"3599330", "Раброво",
"359558", "Айтос",
"35951539", "Левски\,\ Варна",
"3596136", "Сухиндол",
"3596169", "Благоево\,\ В\.\ Търново",
"3599542", "Смоляновци",
"3595120", "Бозвелийско",
"35941350", "Мирово\,\ Ст\.\ Загора",
"35941335", "Могилово",
"3599569", "Липен",
"3596142", "Обединение",
"3593707", "Николово\,\ Хаск\.",
"3598184", "Глоджево",
"3593786", "Навъсен",
"3593759", "Бориславци",
"3593029", "Петково\,\ Смол\.",
"3598141", "Две\ могили",
"3599111", "Челопек",
"3599558", "Гаврил\ Геново",
"3598145", "Тръстеник\,\ Русе",
"3593722", "Минерални\ бани\,\ Хаск\.",
"35967306", "Градище\,\ Габр\.",
"3595523", "Крумово\ градище",
"3593052", "Лъки\,\ Пловдив",
"3599115", "Чирен",
"3595915", "Българово",
"3593768", "Доситеево",
"35971587", "Голема\ Раковица",
"3593122", "Маноле",
"35961306", "Патреш",
"35953435", "Изгрев\,\ Шумен",
"3598632", "Зафирово",
"3593168", "Езерово\,\ Пловдив",
"3597923", "Вратца",
"3597158", "Доганово",
"3596049", "Камбурово",
"35941171", "Дълбоки",
"3597136", "Новачене\,\ София",
"3593107", "Граф\ Игнатиево",
"3594367", "Тъжа",
"35969612", "Терзийско\,\ Ловеч",
"3593159", "Белозем",
"3596573", "Койнаре",
"35930476", "Селча",
"3597169", "Томпсън",
"3596965", "Бели\ Осъм",
"3599173", "Галово",
"3596736", "Градница\,\ Габр\.",
"3597142", "Костенец",
"35984469", "Божурово\,\ Разград",
"3594586", "Нейково\,\ Сливен",
"3595119", "Игнатиево",
"3598646", "Вокил",
"3596062", "Стража\,\ Търг\.",
"3594522", "Кортен",
"35941353", "Плодовитово",
"359724", "Ихтиман",
"3596028", "Вардун",
"35941489", "Боздуганово",
"359670", "Троян\,\ Ловеч",
"3597937", "Ръждавица",
"3594129", "Маджерито",
"3593713", "Динево",
"3593548", "Пашово",
"3595578", "Терзийско\,\ Бургас",
"3593657", "Жълтуша",
"35984749", "Севар",
"3598194", "Сандрово",
"3597549", "Долен\,\ Благ\.",
"3598674", "Професор\ Иширково",
"3599344", "Връв",
"3594152", "Обручище",
"3594710", "Болярско",
"3599749", "Черни\ връх\,\ Монт\.",
"3597528", "Хаджидимово",
"35984726", "Ушинци",
"3593175", "Дълго\ поле\,\ Пловдив",
"35951537", "Чернево",
"3595145", "Гроздьово",
"3599728", "Сливата",
"3593552", "Брацигово",
"3595753", "Орляк",
"35967394", "Богатово",
"35984462", "Острово",
"35969244", "Тепава",
"3595141", "Старо\ Оряхово",
"3593347", "Леново",
"359559", "Карнобат",
"3593529", "Мокрище",
"3593695", "Комунига",
"359745", "Петрич\,\ Благ\.",
"3593691", "Черноочeне",
"3596912", "Баховица",
"3596046", "Врани\ кон",
"3597188", "Петрич\,\ София",
"35961606", "Владислав",
"35960458", "Веренци",
"3594792", "Ботево\,\ Ямбол",
"35935255", "Росен\,\ Пазарджик",
"3595747", "Ваклино",
"3598662", "Добротица\,\ Силистра",
"3593138", "Ведраре",
"3593777", "Мезек",
"3598628", "Цар\ Асен\,\ Силистра",
"35984737", "Райнино",
"3597166", "Владо\ Тричков",
"3596321", "Горна\ Студена",
"3596325", "Козловец",
"3593156", "Шишманци",
"3594337", "Ясеново\,\ Ст\.\ Загора",
"35961403", "Орловец",
"3595524", "Екзарх\ Антимово",
"3594350", "Горно\ Изворово",
"3595590", "Житосвят",
"3596931", "Угърчин",
"3597437", "Мелник",
"3597139", "Джурово",
"3596935", "Сопот\,\ Ловеч",
"3596990", "Малък\ извор\,\ Ловеч",
"35967392", "Яворец",
"35984464", "Веселец\,\ Разград",
"35969242", "Пресяка",
"3594556", "Сотиря",
"3595396", "Ловец\,\ Шумен",
"3593643", "Голяма\ Чинка",
"3595535", "Лясково\,\ Бургас",
"35961397", "Мусина",
"3595313", "Мадара",
"35941484", "Землен",
"3596032", "Зараево",
"3598649", "Яребица",
"3595116", "Крумово\,\ Варна",
"3599355", "Косово\,\ Видин",
"35931997", "Златосел",
"3593320", "Орешец\,\ Пловдив",
"35984744", "Беловец",
"3599351", "Извор\,\ Видин",
"35984763", "Бели\ Лом",
"35938", "Хасково",
"3594126", "Хрищени",
"3593114", "Брестник",
"3597423", "Коларово\,\ Благ\.",
"3599746", "Разград\,\ Монт\.",
"3596517", "Подем",
"35969614", "Горно\ трапе",
"35977221", "Кондофрей",
"3597546", "Слащен",
"3594323", "Тулово",
"35931701", "Кръстевич",
"35969249", "Дойренци",
"35967399", "Малки\ Вършец",
"3593582", "Момина\ клисура",
"3596074", "Любичево",
"3595783", "Котленци",
"3594514", "Крушаре",
"359777", "Радомир",
"359301", "Смолян",
"3597532", "Буково\,\ Благ\.",
"3596003", "Преселец",
"3598147", "Баниска",
"3595917", "Извор\,\ Бургас",
"3599117", "Криводол",
"35984", "Разград",
"35961704", "Правда\,\ В\.\ Търново",
"35959406", "Разбойна\,\ Бургас",
"359748", "Симитли",
"35937421", "Долно\ поле",
"3593701", "Елена\,\ Хаск\.",
"3593526", "Динката",
"3593705", "Въгларово",
"35935258", "Цар\ Асен\,\ Пазарджик",
"3594796", "Генерал\ Тошево\,\ Ямбол",
"3598666", "Тутракан",
"3596042", "Илийно",
"3593129", "Скутаре",
"359726", "Своге",
"3598639", "Коларово\,\ Силистра",
"359750", "Боровец\,\ София",
"359519", "Девня",
"3594713", "Стара\ река\,\ Ямбол",
"3593710", "Узунджово",
"3593633", "Рогозче",
"3598123", "Босилковци",
"3597162", "Лакатник",
"35951314", "Войводино",
"35941356", "Рупките",
"3594347", "Розово\,\ Ст\.\ Загора",
"35995276", "Драганица",
"3595392", "Менгишево",
"35961303", "Горна\ Липница",
"3594552", "Стара\ река\,\ Сливен",
"3596941", "Летница",
"3597447", "Добринище",
"3597149", "Живково\,\ София",
"3596728", "Буря",
"3596036", "Садина",
"3596984", "Бежаново\,\ Ловеч",
"3595737", "Люляково\,\ Добр\.",
"359335", "Карлово",
"3593148", "Йоаким\ Груево",
"3595750", "Каблешково\,\ Добр\.",
"3595112", "Белослав",
"3596069", "Васил\ Левски\,\ Търг\.",
"3594529", "Съдиево\,\ Сливен",
"35974204", "Гега",
"3596711", "Кози\ рог",
"35984723", "Дянково",
"3594122", "Еленино",
"3596570", "Девенци",
"3595519", "Зидарово",
"3598150", "Семерджиево",
"3599742", "Якимово",
"35984392", "Белинци",
"3594107", "Средец\,\ Ст\.\ Загора",
"35941144", "Калояновец",
"3595165", "Невша",
"3598137", "Голямо\ Враново",
"3597920", "Скриняно",
"3595161", "Ветрино",
"3596173", "Долна\ Оряховица",
"3593559", "Капитан\ Димитриево",
"3593586", "Боримечково",
"35963577", "Пелишат",
"3593568", "Виноградец",
"3596919", "Слатина\,\ Ловеч",
"3593522", "Гелеменово",
"3595723", "Гурково\,\ Добр\.",
"35931258", "Главатар",
"35963568", "Буковлък",
"3598636", "Главиница\,\ Силистра",
"3593126", "Труд",
"3595554", "Момина\ църква",
"359723", "Ботевград",
"3594799", "Голям\ манастир",
"3598669", "Гарван\,\ Силистра",
"35974202", "Ключ",
"3599517", "Кобиляк",
"3597132", "Радотина",
"3593323", "Болярци\,\ Пловдив",
"3597717", "Дивотино",
"3593077", "Средец\,\ Смол\.",
"3593933", "Странско",
"35984394", "Духовец",
"3597146", "Черньово",
"3596732", "Сенник",
"35961603", "Лозен\,\ В\.\ Търново",
"3594582", "Градец\,\ Сливен",
"3596117", "Дебелец\,\ В\.\ Търново",
"3593514", "Черногорово\,\ Пазарджик",
"3596066", "Буйново\,\ Търг\.",
"3594526", "Млекарево",
"35961406", "Каранци",
"3598642", "Дулово",
"3595767", "Житница\,\ Добр\.",
"3599318", "Буковец\,\ Видин",
"3596039", "Опака",
"3596954", "Врабево",
"3594777", "Тенево",
"3595516", "Индже\ войвода",
"3597174", "Калотина",
"3594138", "Гита",
"35930410", "Брезе\,\ Смол\.",
"35947203", "Трънково\,\ Ямбол",
"3594353", "Средногорово",
"3597103", "Брусен\,\ София",
"3599325", "Бело\ поле\,\ Видин",
"35959403", "Речица",
"3593927", "Черногорово\,\ Хаск\.",
"35941149", "Ловец\,\ Ст\.\ Загора",
"35993212", "Карбинци",
"3595135", "Стефан\ Караджа\,\ Варна",
"3598167", "Церовец",
"3595131", "Вълчи\ дол",
"3594156", "Априлово\,\ Ст\.\ Загора",
"359860", "Силистра",
"35984766", "Каменар\,\ Разград",
"3598442", "Завет\,\ Разград",
"3593556", "Радилово",
"3593589", "Церово\,\ Пазарджик",
"3595124", "Комарево\,\ Варна",
"35951428", "Господиново\,\ Варна",
"35991180", "Лесура",
"35993342", "Киреево",
"3593538", "Елшица",
"3595310", "Радко\ Димитриево",
"35963565", "Мечка\,\ Плевен",
"35936402", "Горна\ кула",
"3596916", "Брестово\,\ Ловеч",
"359707", "Сапарева\ баня",
"3593708", "Орлово\,\ Хаск\.",
"3597176", "Храбърско",
"35947204", "Пчела",
"35984729", "Езерче",
"3596533", "Стежерово",
"3598192", "Хотанца",
"3599342", "Иново",
"3598672", "Брадвари",
"35959404", "Ясеново\,\ Бургас",
"3599557", "Горно\ Церовене",
"35961706", "Писарево\,\ В\.\ Търново",
"3594154", "Медникарово",
"3593767", "Браница",
"35971225", "Ново\ село\,\ София",
"35937705", "Пъстрогор",
"359538", "Велики\ Преслав",
"35967307", "Млечево",
"3599336", "Старопатица",
"35941115", "Борилово",
"35961302", "Батак\,\ В\.\ Търново",
"3596157", "Сливовица",
"3593554", "Козарско",
"3595126", "Черковна\,\ Варна",
"35930472", "Михалково",
"3599133", "Комарево\,\ Враца",
"3595323", "Плиска",
"3596914", "Сливек",
"35969616", "Старо\ село\,\ Ловеч",
"3593124", "Калековец",
"3595589", "Винарско",
"3595556", "Голямо\ Буково",
"35984466", "Звънарци",
"3598634", "Нова\ Черна",
"3596527", "Одърне",
"35984722", "Ясеновец",
"3593190", "Върбен\,\ Пловдив",
"3597033", "Крайници",
"35984393", "Вазово",
"35975214", "Гайтаниново",
"35941118", "Остра\ могила\,\ Ст\.\ Загора",
"3595538", "Караново\,\ Бургас",
"35936702", "Горски\ извор\,\ Кърдж\.",
"3594116", "Ракитница\,\ Ст\.\ Загора",
"3597144", "Костенец",
"35971228", "Марица",
"35961604", "Мирово\,\ В\.\ Търново",
"3596938", "Каленик\,\ Ловеч",
"3594747", "Денница\,\ Ямбол",
"35961309", "Горско\ Калугерово",
"3593516", "Црънча\,\ Пазарджик",
"3596328", "Ореш",
"3593135", "Кърнаре",
"3598621", "Силистра",
"3596064", "Голямо\ Ново",
"3595337", "Кочово",
"35962", "Велико\ Търново",
"3594524", "Каменово\,\ Сливен",
"3598625", "Овен",
"35963570", "Староселци",
"3597185", "Челопеч",
"3596989", "Торос",
"3596956", "Ломец\,\ Ловеч",
"3597181", "Пирдоп",
"3599127", "Лютидол",
"35931395", "Иганово",
"35974203", "Рупите",
"3597179", "Големо\ Малово",
"3594145", "Знаменосец",
"35967396", "Бериево",
"3594753", "Зорница\,\ Ямбол",
"3596563", "Брест\,\ Плевен",
"3593112", "Марково\,\ Пловдив",
"3595148", "Рудник\,\ Варна",
"3593020", "Давидково",
"3599725", "Комощица",
"3599721", "Долно\ Церовене",
"3597525", "Баничан",
"3597913", "Рашка\ Гращица",
"3597521", "Копривлен",
"35959409", "Череша",
"3599560", "Безденица",
"3593178", "Красново",
"3593584", "Ветрен\,\ Пазарджик",
"3595129", "Блъсково",
"3596072", "Добротица\,\ Търг\.",
"3594512", "Блатец\,\ Сливен",
"35961602", "Царски\ извор",
"3599339", "Макреш",
"3595575", "Прилеп\,\ Бургас",
"3595571", "Сунгурларе",
"3599163", "Хърлец",
"359331", "Асеновград",
"3595710", "Победа\,\ Добр\.",
"3593545", "Драгиново",
"35981461", "Каран\ Върбовка",
"3596021", "Буховци",
"3596143", "Масларево",
"3594794", "Овчи\ кладенец",
"35947202", "Жребино",
"3596025", "Алваново",
"3598664", "Поляна\,\ Силистра",
"3595559", "Кубадин",
"35930417", "Грохотно",
"3599140", "Габаре",
"35930457", "Късак",
"3595522", "Искра\,\ Бургас",
"3593053", "Хвойна",
"35941331", "Гранит",
"3593519", "Величково\,\ Пазарджик",
"3596968", "Добродан",
"35961304", "Димча",
"3596540", "Асеново\,\ Плевен",
"3596922", "Лешница\,\ Ловеч",
"3597743", "Дивля",
"3593165", "Караджалово",
"3597155", "Лесново",
"3596034", "Славяново\,\ Търг\.",
"3595367", "Тодор\ Икономово",
"359953", "Берковица",
"3596986", "Дъбен",
"3596959", "Дебнево",
"35935419", "Света\ Петка",
"35931398", "Слатина\,\ Пловдив",
"35953234", "Златна\ нива",
"3596907", "Градежница",
"3599527", "Вършец",
"35984743", "Брестовене",
"3593673", "Тихомир",
"3597030", "Ресилово",
"35984764", "Сейдол",
"359596", "Поморие",
"3597727", "Ковачевци\,\ Перник",
"3594124", "Змейово",
"3597057", "Мало\ село",
"3593535", "Левски\,\ Пазарджик",
"3599785", "Василовци\,\ Монт\.",
"3599744", "Вълчедръм",
"3593116", "Крумово\,\ Пловдив",
"3597544", "Осина",
"3598679", "Кайнарджа",
"3599349", "Сланотрън",
"35969613", "Чифлик\,\ Ловеч",
"3593193", "Борец",
"3594516", "Кермен",
"3595138", "Добротич",
"3596076", "Таймище",
"3599328", "Долни\ Лом",
"3595353", "Веселиново\,\ Шумен",
"3594593", "Шивачево",
"3593747", "Татарево\,\ Хаск\.",
"35961703", "Върбица\,\ В\.\ Търново",
"35992", "Враца",
"35941352", "Винарово\,\ Ст\.\ Загора",
"3593524", "Априлци\,\ Пазарджик",
"35961105", "Присово",
"3597733", "Филиповци",
"3599315", "Градец\,\ Видин",
"3599311", "Кутово",
"3596044", "Долно\ Козарево",
"35961108", "Плаково",
"35971337", "Калугерово\,\ София",
"3593783", "Свирково",
"35974321", "Хърсово\,\ Благ\.",
"3593154", "Чалъкови",
"3595526", "Кликач",
"3597164", "Реброво",
"3598697", "Сокол\,\ Силистра",
"3596557", "Брегаре",
"3596530", "Трънчовица",
"3596591", "Горник",
"35984463", "Прелез",
"35958", "Добрич",
"3599130", "Тлачене",
"3595394", "Бяла\ река\,\ Шумен",
"3594554", "Трапоклово",
"3595320", "Пет\ могили\,\ Шумен",
"3596926", "Горно\ Павликене",
"3596982", "Ъглен",
"3596133", "Михалци",
"35941359", "Изворово\,\ Ст\.\ Загора",
"35931401", "Кадиево",
"3595114", "Езерово\,\ Варна",
"3593720", "Маджарово",
"3593050", "Букова\ поляна",
"3597172", "Драгоман",
"3598113", "Ново\ село\,\ Русе",
"3599143", "Еница",
"3595943", "Вресово",
"35984730", "Голям\ Поровец",
"3593561", "Септември",
"35984769", "Гороцвет",
"3598196", "Нисово",
"3597118", "Драговищица\,\ София",
"3593037", "Сивино",
"3599346", "Синаговци",
"3598676", "Ветрен\,\ Силистра",
"3593119", "Гълъбово\,\ Пловдив",
"35961402", "Стефан\ Стамболово",
"359727", "Сливница\,\ София",
"3594723", "Бояново\,\ Ямбол",
"3599332", "Раковица",
"3595168", "Петров\ дол\,\ Варна",
"35957305", "Росица\,\ Добр\.",
"3595122", "Славейково\,\ Варна",
"35967393", "Душево",
"35969243", "Казачево",
"3599540", "Белотинци",
"3594519", "Самуилово\,\ Сливен",
"35960385", "Ломци",
"35974405", "Краище\,\ Благ\.",
"359478", "Елхово\,\ Ямбол",
"35941146", "Християново",
"3596718", "Драгановци",
"3596543", "Муселиево",
"3593145", "Кричим",
"35974408", "Обидим",
"3595347", "Живково\,\ Шумен",
"3593753", "Оряхово\,\ Хаск\.",
"3595552", "Дюлево\,\ Бургас",
"35984718", "Дряновец\,\ Разград",
"3593023", "Момчиловци",
"3597910", "Берсин",
"35960388", "Горица\,\ Търг\.",
"3597134", "Врачеш",
"3596725", "Гостилица",
"3594737", "Синапово",
"3596948", "Кърпачево",
"359359", "Велинград",
"3596560", "Крета\,\ Плевен",
"3596587", "Петокладенци",
"35957308", "Чернооково\,\ Добр\.",
"3594112", "Бъдеще",
"3595529", "Крушово\,\ Бургас",
"3599187", "Лютаджик",
"3597043", "Големо\ село",
"3599160", "Гложене\,\ Враца",
"359308", "Мадан\,\ Смол\.",
"3597125", "Говедарци",
"3596734", "Петко\ Славейков",
"3596929", "Радювене",
"3594584", "Тича",
"3593512", "Хаджиево",
"3595713", "Стефаново\,\ Добр\.",
"35971471", "Очуша",
"3596163", "Камен\,\ В\.\ Търново",
"359431", "Казанлък",
"3598644", "Чернолик",
"35953220", "Памукчии\,\ Шумен",
"35941354", "Малко\ Тръново",
"3596952", "Орешак\,\ Ловеч",
"35965617", "Искър\,\ Плевен",
"3594155", "Главан\,\ Ст\.\ Загора",
"3595136", "Брестак",
"35960377", "Априлово\,\ Търг\.",
"3594743", "Мамарчево",
"3594518", "Тополчане",
"3598431", "Исперих",
"3595169", "Момчилово",
"3599326", "Горни\ Лом",
"359361", "Кърджали",
"3595333", "Хан\ Крум",
"359337", "Хисаря",
"35963569", "Каменец\,\ Плевен",
"3593740", "Пчелари",
"3595511", "Лукойл\ Нефтохим",
"3599123", "Роман",
"3595515", "Камено",
"35931393", "Войнягово",
"3596911", "Лисец\,\ Ловеч",
"3597119", "Дръмша",
"35957306", "Изворово\,\ Добр\.",
"3596523", "Крушовица\,\ Плевен",
"3596915", "Смочан",
"35974327", "Ново\ Делчево",
"35960386", "Водица\,\ Търг\.",
"3593118", "Садово\,\ Пловдив",
"3595142", "Долни\ чифлик",
"3593555", "Нова\ махала\,\ Пазарджик",
"3599520", "Горно\ Озирово",
"35941145", "Арнаутито",
"3598424", "Цар\ Калоян\,\ Разград",
"35974406", "Добърско",
"3597720", "Прибой",
"3596962", "Черни\ Осъм",
"3596153", "Златарица",
"3596928", "Къкрина",
"3599137", "Попица",
"35963562", "Комарево\,\ Плевен",
"35930517", "Забърдо",
"3593125", "Ръжево\ Конаре",
"3598631", "Силистра",
"3593121", "Рогош",
"3595327", "Каспичан\,\ Шумен",
"3598635", "Цар\ Самуил",
"3593043", "Змеица",
"3598690", "Силистра",
"3597184", "Копривщица",
"3596550", "Ставерци",
"3593134", "Сопот\,\ Пловдив",
"3596061", "Голямо\ Соколово",
"3596065", "Бистра\,\ Търг\.",
"3596537", "Асеновци",
"3598624", "Калипетрово",
"3594525", "Омарчево\,\ Сливен",
"3599553", "Превала",
"3595528", "Невестино\,\ Бургас",
"3597753", "Ноевци",
"35951429", "Солник",
"3597145", "Мирово\,\ София",
"3593763", "Българин",
"3597524", "Абланица\,\ Благ\.",
"3599329", "Рабиша",
"3595166", "Доброплодно",
"35941113", "Пряпорец\,\ Ст\.\ Загора",
"35937420", "Подкрепа",
"3595139", "Оборище\,\ Варна",
"3599724", "Станево",
"35935501", "Равногор",
"3595100", "Синдел",
"35969032", "Български\ извор",
"3594144", "Ковачево\,\ Ст\.\ Загора",
"3595363", "Гусла",
"359817", "Бяла\,\ Русе",
"35963564", "Биволаре",
"3599352", "Дружба",
"35951125", "Константиново\,\ Варна",
"3599547", "Винище",
"359391", "Димитровград",
"3596716", "Жълтеш",
"3596147", "Иванча\,\ В\.\ Търново",
"3593702", "Царева\ поляна",
"3593544", "Костандово",
"3597193", "Голеш\,\ София",
"3595574", "Съединение\,\ Бургас",
"3597116", "Петърч",
"35931700", "Беловица",
"3598678", "Срацимир\,\ Силистра",
"359915", "Бяла\ Слатина",
"3599348", "Неговановци",
"3597531", "Долно\ Дряново",
"3593727", "Нова\ Надежда",
"3593057", "Пловдивци",
"3593585", "Аканджиево",
"3593030", "Широка\ лъка",
"35961106", "Ново\ село\,\ В\.\ Търново",
"3593581", "Белово",
"35964", "Плевен",
"35937703", "Димитровче",
"3596932", "Микре",
"3596322", "Алеково\,\ В\.\ Търново",
"359306", "Рудозем",
"3596359", "Глава",
"3599180", "Голямо\ Пещене",
"35967194", "Гръблевци",
"3599167", "Липница\,\ Враца",
"3595967", "Бата",
"3598661", "Тутракан",
"3594795", "Скалица",
"3596024", "Руец",
"3598665", "Искра\,\ Силистра",
"3594564", "Новоселец",
"3594730", "Княжево",
"3593164", "Дълбок\ извор",
"3596035", "Паламарца",
"3597154", "Столник",
"35966", "Габрово",
"3596567", "Сомовит",
"3596580", "Татари",
"3594757", "Недялско",
"3595340", "Висока\ поляна\,\ Шумен",
"3596946", "Чавдарци",
"3597917", "Таваличево",
"3595532", "Тополица",
"3597545", "Кочан",
"3599338", "Шишенци",
"3595162", "Белоградец",
"35931396", "Домлян",
"3597541", "Сатовча",
"3595128", "Житница\,\ Варна",
"3593040", "Триград",
"3599745", "Златия\,\ Монт\.",
"35967395", "Горна\ Росица",
"3599741", "Долни\ Цибър",
"35969245", "Деветаки",
"35961502", "Горско\ Ново\ Село",
"3594125", "Михайлово\,\ Ст\.\ Загора",
"3596137", "Бутово",
"3593534", "Попинци",
"35960383", "Берковски",
"3594121", "Люляк",
"3599784", "Киселево",
"35974403", "Долно\ Драглище",
"359550", "Созопол",
"3599356", "Каленик\,\ Видин",
"3596150", "Златарица",
"3596712", "Гъбене",
"35984713", "Благоево\,\ Разград",
"3593706", "Тънково\,\ Хаск\.",
"3593521", "Звъничево",
"3597178", "Пролеша",
"3594134", "Братя\ Даскалови",
"3599550", "Митровци",
"35937602", "Черна\ могила\,\ Хаск\.",
"3593699", "Габрово\,\ Кърдж\.",
"3593787", "Тянево\,\ Хаск\.",
"35935252", "Тополи\ дол",
"359721", "Костинброд",
"3598693", "Звенимир",
"3594763", "Иречеково",
"3596553", "Оряховица\,\ Плевен",
"35931792", "Черничево\,\ Пловдив",
"3595149", "Голица",
"3595330", "Златар",
"3595773", "Лозенец\,\ Добр\.",
"359373", "Харманли",
"35991202", "Кунино",
"35971398", "Осиковица",
"35967301", "Идилево",
"3593155", "Момино\ село",
"3596326", "Морава",
"3597165", "Миланово\,\ София",
"3593743", "Силен",
"3593518", "Драгор",
"35930257", "Вишнево",
"3593151", "Раковски\,\ Пловдив",
"3594597", "Боров\ дол",
"3596969", "Беклемето",
"35931388", "Бегунци",
"3599719", "Аспарухово\,\ Монт\.",
"359747", "Разлог",
"3599314", "Дунавци\,\ Видин",
"3596123", "Буковец\,\ В\.\ Търново",
"35935393", "Смилец\,\ Пазарджик",
"3596958", "Априлци\,\ Ловеч",
"3595115", "Генерал\ Кантарджиево",
"3599523", "Бързия",
"3593677", "Дрангово\,\ Кърдж\.",
"35953434", "Ясенково",
"3595558", "Дебелт",
"3597723", "Долни\ Раковец",
"3597053", "Кочериново",
"3596520", "Николаево\,\ Плевен",
"35967398", "Дамяново",
"3596942", "Александрово\,\ Ловеч",
"35969248", "Скобелево\,\ Ловеч",
"359618", "Горна\ Оряховица",
"3594118", "Памукчии\,\ Ст\.\ Загора",
"3595536", "Мъглен",
"3595391", "Върбица\,\ Шумен",
"3594551", "Бяла\,\ Сливен",
"3593197", "Тюркмен",
"3595395", "Чернооково\,\ Шумен",
"3595132", "Михалич\,\ Варна",
"3599183", "Лиляче",
"3597047", "Усойка",
"3599322", "Орешец\,\ Видин",
"3595717", "Ведрина",
"35961705", "Горски\ долен\ Тръмбеш",
"3596167", "Кесарево",
"3593564", "Семчиново",
"35937706", "Чернодъб",
"35960454", "Змейно",
"35961103", "Русаля",
"35984745", "Владимировци",
"35941116", "Сладък\ Кладенец",
"3593757", "Георги\ Добрево",
"3595343", "Венец\,\ Шумен",
"3593696", "Пчеларово\,\ Кърдж\.",
"3593027", "Славейно",
"35996", "Монтана",
"3599567", "Долна\ Вереница",
"3593709", "Караманци",
"35941337", "Сърневец",
"3594733", "Орлов\ дол",
"35930411", "Девин",
"3595146", "Горен\ чифлик",
"35969615", "Балабанско",
"3596583", "Белене",
"3593176", "Старосел",
"3598445", "Юпер",
"35984465", "Савин",
"3596966", "Шипково",
"3596329", "Царевец\,\ В\.\ Търново",
"359702", "Бобов\ дол",
"3596900", "Васильово",
"3597135", "Трудовец",
"3596724", "Янтра\,\ Габр\.",
"3596939", "Драгана",
"3596988", "Пещерна",
"3596352", "Долни\ Луковит",
"35984266", "Просторно",
"3596547", "Драгаш\ войвода",
"3598117", "Мартен",
"35935254", "Добровница",
"3595947", "Просеник",
"3599147", "Борован",
"35937604", "Върбово\,\ Хаск\.",
"3598641", "Окорш",
"3598645", "Межден",
"3594585", "Жеравна",
"3595539", "Черноград",
"35941277", "Загоре",
"35994", "Видин",
"3597124", "Белчински\ бани",
"3594727", "Малък\ манастир",
"3596964", "Велчево\,\ Ловеч",
"35963571", "Брестовец",
"3596726", "Скалско",
"3593343", "Козаново",
"3595757", "Безмер\,\ Добр\.",
"35984712", "Костанденец",
"3599319", "Гъмзово",
"3594340", "Паничерево",
"35974402", "Годлево",
"35960382", "Ковачевец",
"3598475", "Лозница\,\ Разград",
"3593146", "Куртово\ Конаре",
"35961503", "Чакали",
"35984768", "Синя\ вода",
"3597182", "Мирково",
"3597933", "Грамаждано",
"3594798", "Савино",
"3593717", "Конуш\,\ Хаск\.",
"3598668", "Попина",
"35937603", "Рогозиново",
"3593132", "Баня\,\ Пловдив",
"3593653", "Млечино",
"3598622", "Алеково\,\ Силистра",
"35961405", "Петко\ Каравелово",
"3597126", "Горни\ Окол",
"35982", "Русе",
"359728", "Златица",
"3593588", "Мененкьово",
"3598675", "Айдемир",
"3599345", "Винарово\,\ Видин",
"35991203", "Лик",
"3599341", "Димово\,\ Видин",
"3598671", "Силистра",
"3593566", "Бошуля",
"35984719", "Балкански",
"35935392", "Дюлево\,\ Пазарджик",
"35974409", "Места",
"35960389", "Кардам\,\ Търг\.",
"35960453", "Моравка",
"35961104", "Водолей",
"35984765", "Веселина",
"3597927", "Трекляно",
"3594139", "Свобода\,\ Ст\.\ Загора",
"35974347", "Раздол",
"3594100", "Столетово\,\ Ст\.\ Загора",
"3593103", "Милево",
"3595144", "Камчия",
"3594363", "Габарево",
"3596577", "Бресте",
"35963566", "Бръшляница",
"3593174", "Старо\ Железаре",
"359336", "Първомай\,\ Пловдив",
"3595760", "Божурово\,\ Добр\.",
"3597148", "Мухово",
"3596934", "Катунец",
"3595521", "Венец\,\ Бургас",
"3596324", "Вардим",
"3596007", "Ралица",
"3598143", "Обретеник",
"3595913", "Крушевец",
"3599113", "Мраморен",
"3595525", "Деветак",
"35961102", "Пчелище",
"3593149", "Цалапица",
"3596068", "Божурка",
"3594528", "Любенова\ махала",
"35941355", "Яворово",
"3599316", "Ново\ село\,\ Видин",
"3596022", "Пробуда\,\ Търг\.",
"35935394", "Оборище\,\ Пазарджик",
"3594562", "Крива\ круша",
"3593128", "Златитрап",
"3598638", "Богданци\,\ Силистра",
"35941330", "Ценово\,\ Ст\.\ Загора",
"3593162", "Градина\,\ Пловдив",
"3597152", "Горна\ Малина",
"359725", "Елин\ Пелин",
"359350", "Пещера\,\ Пазарджик",
"3596921", "Абланица\,\ Ловеч",
"3597129", "Радуил",
"3597427", "Първомай\,\ Благ\.",
"3596513", "Пордим",
"3596925", "Владиня",
"3594327", "Шейново",
"3595534", "Карагеоргиево",
"3597522", "Дъбница",
"35957304", "Дъбовик",
"3593647", "Черничево\,\ Кърдж\.",
"3593115", "Куклен",
"3599722", "Сталийска\ махала",
"3595317", "Ивански",
"3593111", "Първенец\,\ Пловдив",
"3593558", "Исперихово",
"3593536", "Баня\,\ Пазарджик",
"35961109", "Въглевци",
"3594142", "Трояново\,\ Ст\.\ Загора",
"35960384", "Гагово",
"35974404", "Бабяк",
"3599354", "Антимово\,\ Видин",
"3593569", "Карабунар",
"3596918", "Дренов",
"3593920", "Златополе",
"35941358", "Опълченец",
"3593704", "Брягово\,\ Хаск\.",
"3593542", "Ракитово",
"3594136", "Черна\ гора\,\ Ст\.\ Загора",
"3595743", "Шабла",
"3595518", "Рудник\,\ Бургас",
"3598187", "Тетово",
"3595572", "Бероново",
"35931324", "Мраченик",
"3593773", "Капитан\ Андреево",
"35941270", "Малка\ Верея",
"3594770", "Генерал\ Инзово",
"3594333", "Дъбово\,\ Ст\.\ Загора",
"3594511", "Сливенски\ минерални\ бани",
"3594158", "Искрица",
"3597433", "Кресна",
"3596071", "Антоново",
"3594515", "Мокрен",
"35935256", "Сбор\,\ Пазарджик",
"3596177", "Янтра\,\ В\.\ Търново",
"3596738", "Добромирка",
"35961605", "Ново\ градище",
"3594588", "Филаретово",
"35959408", "Ръжица",
"35937606", "Шишманово",
"35961203", "Емен",
"35960370", "Голямо\ градище",
"3598648", "Секулово",
"35967193", "Кметовци",
"3599312", "Брегово\,\ Видин",
"3596026", "Макариополско",
"3594566", "Питово",
"3595727", "Сенокос\,\ Добр\.",
"3593100", "Белащица",
"3598629", "Смилец\,\ Силистра",
"3597156", "Равно\ поле",
"3597189", "Чавдар\,\ София",
"3596985", "Румянцево",
"3593166", "Бяла\ река\,\ Пловдив",
"3596981", "Петревене",
"35931392", "Дъбене",
"35930205", "Стърница",
"3597138", "Литаково",
"3596944", "Крушуна",
"3594103", "Бял\ извор\,\ Ст\.\ Загора",
"3593623", "Бойно",
"3598133", "Ряхово",
"35975215", "Тешово",
"3595164", "Неофит\ Рилски",
"3598448", "Тертер",
"3594343", "Конаре\,\ Ст\.\ Загора",
"3597526", "Рибново",
"35941114", "Лозен\,\ Ст\.\ Загора",
"3599726", "Замфир",
"35971798", "Василовци\,Соф\.",
"3593532", "Стрелча",
"359701", "Дупница",
"3599782", "Буковец\,\ Монт\.",
"3595733", "Кардам\,\ Добр\.",
"3594146", "Диня",
"35963563", "Борислав",
"3593340", "Нови\ извор",
"3596714", "Поповци",
"35935418", "Кръстава",
"3594132", "Оризово",
"3595576", "Лозарево",
"3594717", "Чарган",
"35959405", "Зайчар",
"3593637", "Груево",
"3598127", "Караманово",
"3597930", "Еремия",
"35978", "Кюстендил",
"35971224", "Шипочане",
"35961608", "Горски\ Сеновец",
"35937704", "Младиново",
"35953436", "Черноглавци",
"3594115", "Кирилово\,\ Ст\.\ Загора",
"35961305", "Лесичери",
"35941112", "Старозагорски\ бани",
"35953221", "Стоян\ Михайловски",
"3596722", "Соколово\,\ Габр\.",
"3596029", "Надарево",
"3596997", "Добревци\,\ Ловеч",
"3593142", "Брестовица\,\ Пловдив",
"3595118", "Водица\,\ Варна",
"35984728", "Раковски\,\ Разград",
"3595551", "Средец\,\ Бургас",
"3595555", "Факия",
"35930475", "Стоманево",
"3594773", "Окоп",
"3594330", "Николаево\,\ Ст\.\ Загора",
"359722", "Самоков",
"3597159", "Априлово\,\ София",
"3597186", "Антон",
"3596048", "Изворово\,\ Търг\.",
"3596955", "Дълбок\ дол",
"3597430", "Дамяница",
"3598626", "Средище\,\ Силистра",
"3593136", "Розино\,\ Пловдив",
"3594357", "Горно\ Сахране",
"35937702", "Мустрак",
"3593511", "Огняново\,\ Пазарджик",
"3595740", "Горичане",
"3597168", "Бов",
"3593515", "Калугерово\,\ Пазарджик",
"3593923", "Радиево",
"35984269", "Недоклан",
"35931707", "Черноземен",
"3598163", "Бъзън",
"359537", "Нови\ пазар\,\ Шумен",
"359746", "Сандански",
"3595134", "Червенци",
"3599729", "Расово",
"35941119", "Елхово\,\ Ст\.\ Загора",
"3597529", "Брезница",
"3599324", "Ружинци",
"3596113", "Балван",
"35961391", "Сломер",
"3593562", "Славовица\,\ Пазарджик",
"3595763", "Плачидол",
"3598140", "Борово\,\ Русе",
"3599110", "Вировско",
"3597175", "Габер",
"3595910", "Черни\ връх\,\ Бургас",
"3594149", "Трънково\,\ Ст\.\ Загора",
"3593528", "Говедаре",
"3595579", "Ведрово",
"35931394", "Васил\ Левски\,\ Пловдив",
"3596510", "Тотлебен",
"35984725", "Киченица",
"3593549", "Грашево",
"3595125", "Градинарово",
"3599513", "Бойчиновци",
"3599748", "Дългоделци",
"3593667", "Покрован",
"3595121", "Тутраканци",
"3593327", "Бачково",
"3599335", "Цар\ Петрово",
"3597548", "Годешево",
"3597713", "Рударци",
"3593073", "Старцево",
"3593937", "Ябълково\,\ Хаск\.",
"35961308", "Вишовград",};
my $timezones = {
               '' => [
                       'Europe/Sofia'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+359|\D)//g;
      my $self = bless({ country_code => '359', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '359', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;