/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2009 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef	LAPACK_V9A_SS13
#define	LAPACK_V9A_SS13

/* 64-bit golden values for V9A/SS13 Lapack */


static struct LinpVals LinpValsA[] = {

#ifdef DP /* { */

/* Start of DP golden values */


{, 0.0000000000000000e+00,
	0.0000000000000000e+00, 0.0000000000000000e+00,
	0.0000000000000000e+00, /* L0 */
{0.0000000000000000e+00, 0.0000000000000000e+00,
	2.2204460492503131e-16, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L1 */
{0.0000000000000000e+00, 0.0000000000000000e+00,
	2.2204460492503131e-16, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L2 */
{0.0000000000000000e+00, 0.0000000000000000e+00,
	2.2204460492503131e-16, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L3 */
{3.8260177822204688e-01, 1.6653345369377348e-16,
	2.2204460492503131e-16, 2.2204460492503131e-16,
	2.2204460492503131e-16}, /* L4 */
{4.0810856343684981e-01, 2.2204460492503131e-16,
	2.2204460492503131e-16, -3.3306690738754696e-16,
	0.0000000000000000e+00}, /* L5 */
{3.4009046953070693e-01, 2.2204460492503131e-16,
	2.2204460492503131e-16, 8.8817841970012523e-16,
	2.6645352591003757e-15}, /* L6 */
{3.6373773558278227e-01, 2.7755575615628914e-16,
	2.2204460492503131e-16, -3.3306690738754696e-16,
	8.8817841970012523e-16}, /* L7 */
{3.2492063115128750e-01, 2.8449465006019636e-16,
	2.2204460492503131e-16, -1.7763568394002505e-15,
	-1.1102230246251565e-16}, /* L8 */
{4.5083838251885799e-01, 4.4408920985006262e-16,
	2.2204460492503131e-16, -1.5543122344752192e-15,
	-4.5519144009631418e-15}, /* L9 */
{4.0575454426697483e-01, 4.4408920985006262e-16,
	2.2204460492503131e-16, -1.1102230246251565e-16,
	-2.2204460492503131e-16}, /* L10 */
{5.9941012221257661e-01, 7.2164496600635175e-16,
	2.2204460492503131e-16, 2.2204460492503131e-16,
	2.2204460492503131e-16}, /* L11 */
{2.9586268852800246e-01, 3.8857805861880479e-16,
	2.2204460492503131e-16, -5.5511151231257827e-16,
	0.0000000000000000e+00}, /* L12 */
{6.2922387221750764e-01, 9.0205620750793969e-16,
	2.2204460492503131e-16, -1.6653345369377348e-15,
	-2.2204460492503131e-16}, /* L13 */
{5.3933474761500677e-01, 8.3266726846886741e-16,
	2.2204460492503131e-16, -4.4408920985006262e-16,
	0.0000000000000000e+00}, /* L14 */
{6.7117213036534140e-01, 1.1102230246251565e-15,
	2.2204460492503131e-16, -6.6613381477509392e-16,
	-1.1102230246251565e-16}, /* L15 */
{7.8652984027188344e-01, 1.3877787807814457e-15,
	2.2204460492503131e-16, -6.6613381477509392e-16,
	0.0000000000000000e+00}, /* L16 */
{6.3662650600829918e-01, 1.1934897514720433e-15,
	2.2204460492503131e-16, -1.1102230246251565e-15,
	-1.3322676295501878e-15}, /* L17 */
{2.9363780703483666e-01, 5.8286708792820718e-16,
	2.2204460492503131e-16, 4.4408920985006262e-16,
	4.4408920985006262e-16}, /* L18 */
{8.0143251092966705e-01, 1.6792123247455493e-15,
	2.2204460492503131e-16, -5.5511151231257827e-16,
	8.8817841970012523e-16}, /* L19 */
{5.9147043988445613e-01, 1.3045120539345589e-15,
	2.2204460492503131e-16, -6.6613381477509392e-16,
	-2.2204460492503131e-16}, /* L20 */
{5.9684867319455459e-01, 1.3877787807814457e-15,
	2.2204460492503131e-16, 2.2204460492503131e-15,
	-1.4432899320127035e-15}, /* L21 */
{4.7856411796145321e-01, 1.1657341758564144e-15,
	2.2204460492503131e-16, -5.5511151231257827e-16,
	-2.3314683517128287e-15}, /* L22 */
{4.5775698239791013e-01, 1.1657341758564144e-15,
	2.2204460492503131e-16, 2.4424906541753444e-15,
	-2.9976021664879227e-15}, /* L23 */
{6.7891536575880340e-01, 1.8041124150158794e-15,
	2.2204460492503131e-16, -1.1546319456101628e-14,
	-2.2204460492503131e-15}, /* L24 */
{5.8156934716077235e-01, 1.6098233857064770e-15,
	2.2204460492503131e-16, 1.5543122344752192e-15,
	3.3306690738754696e-15}, /* L25 */
{6.1704970521036173e-01, 1.7763568394002505e-15,
	2.2204460492503131e-16, -2.9976021664879227e-15,
	-4.2188474935755949e-15}, /* L26 */
{8.9129401863720303e-01, 2.6645352591003757e-15,
	2.2204460492503131e-16, -4.4408920985006262e-16,
	2.4424906541753444e-15}, /* L27 */
{8.9527300979183411e-01, 2.7755575615628914e-15,
	2.2204460492503131e-16, 1.5543122344752192e-15,
	-1.3322676295501878e-15}, /* L28 */
{8.1253743509383025e-01, 2.6090241078691179e-15,
	2.2204460492503131e-16, 0.0000000000000000e+00,
	6.6613381477509392e-16}, /* L29 */
{8.6065578674654963e-01, 2.8588242884097781e-15,
	2.2204460492503131e-16, 8.8817841970012523e-16,
	8.8817841970012523e-16}, /* L30 */
{9.0566972861522066e-01, 3.1086244689504383e-15,
	2.2204460492503131e-16, 1.7763568394002505e-15,
	-1.6653345369377348e-15}, /* L31 */
{7.3636205055376436e-01, 2.6090241078691179e-15,
	2.2204460492503131e-16, -9.9920072216264089e-16,
	2.1760371282653068e-14}, /* L32 */
{8.4318439831303504e-01, 3.0808688933348094e-15,
	2.2204460492503131e-16, 6.6613381477509392e-16,
	1.1102230246251565e-15}, /* L33 */
{9.7321442476194397e-01, 3.6637359812630166e-15,
	2.2204460492503131e-16, -2.6645352591003757e-15,
	2.2204460492503131e-16}, /* L34 */
{1.4583044708110673e+00, 5.6621374255882984e-15,
	2.2204460492503131e-16, -3.9968028886505635e-15,
	-4.4408920985006262e-16}, /* L35 */
{8.0446023793208044e-01, 3.2127078775090467e-15,
	2.2204460492503131e-16, -2.4091839634365897e-14,
	1.9984014443252818e-14}, /* L36 */
{5.3420930866356575e-01, 2.1926904736346842e-15,
	2.2204460492503131e-16, -2.2204460492503131e-15,
	-5.5511151231257827e-16}, /* L37 */
{4.6747763286447808e-01, 1.9706458687096529e-15,
	2.2204460492503131e-16, 7.1054273576010019e-15,
	1.5543122344752192e-15}, /* L38 */
{9.8796645269880079e-01, 4.2743586448068527e-15,
	2.2204460492503131e-16, 8.8817841970012523e-16,
	1.3322676295501878e-15}, /* L39 */
{6.1611576753753372e-01, 2.7339241981394480e-15,
	2.2204460492503131e-16, -9.5390362275793450e-13,
	2.3319124409226788e-12}, /* L40 */
{6.2244703022421788e-01, 2.8310687127941492e-15,
	2.2204460492503131e-16, 2.3536728122053319e-14,
	2.1982415887578100e-14}, /* L41 */
{8.7271897456624437e-01, 4.0661918276896358e-15,
	2.2204460492503131e-16, 7.9936057773011271e-15,
	-9.8809849191638932e-15}, /* L42 */
{6.8659341819991870e-01, 3.2751579226442118e-15,
	2.2204460492503131e-16, -2.2204460492503131e-16,
	-2.9976021664879227e-15}, /* L43 */
{7.2500932497707793e-01, 3.5388358909926865e-15,
	2.2204460492503131e-16, -1.1657341758564144e-14,
	4.2188474935755949e-15}, /* L44 */
{8.8403751416813714e-01, 4.4131365228849972e-15,
	2.2204460492503131e-16, -4.5519144009631418e-15,
	-1.2101430968414206e-14}, /* L45 */
{6.3093735629719305e-01, 3.2196467714129540e-15,
	2.2204460492503131e-16, -7.9936057773011271e-15,
	-3.3306690738754696e-15}, /* L46 */
{9.2094634655374696e-01, 4.8017145815038020e-15,
	2.2204460492503131e-16, -1.9872992140790302e-14,
	1.3322676295501878e-15}, /* L47 */
{7.9229777213175645e-01, 4.2188474935755949e-15,
	2.2204460492503131e-16, 2.1538326677728037e-14,
	1.2212453270876722e-14}, /* L48 */
{6.0205010610116116e-01, 3.2751579226442118e-15,
	2.2204460492503131e-16, -4.4408920985006262e-16,
	1.3322676295501878e-15}, /* L49 */
{1.3500208311387045e+00, 7.4940054162198066e-15,
	2.2204460492503131e-16, 4.4408920985006262e-16,
	-1.9984014443252818e-15}, /* L50 */
{1.1666846688849217e+00, 6.6058269965196814e-15,
	2.2204460492503131e-16, -1.2212453270876722e-14,
	9.3702823278363212e-14}, /* L51 */
{1.0480930953997019e+00, 6.0507154842071031e-15,
	2.2204460492503131e-16, 1.1102230246251565e-15,
	9.9920072216264089e-15}, /* L52 */
{8.8208908253996454e-01, 5.1902926401226068e-15,
	2.2204460492503131e-16, 1.5543122344752192e-15,
	-2.4424906541753444e-15}, /* L53 */
{8.2408678992692186e-01, 4.9404924595819466e-15,
	2.2204460492503131e-16, 1.7763568394002505e-15,
	-6.8833827526759706e-15}, /* L54 */
{8.6364968995405822e-01, 5.2735593669694936e-15,
	2.2204460492503131e-16, 3.1086244689504383e-15,
	-6.6613381477509392e-16}, /* L55 */
{7.5001157285481435e-01, 4.6629367034256575e-15,
	2.2204460492503131e-16, 2.2204460492503131e-14,
	8.8817841970012523e-16}, /* L56 */
{1.2017729296036601e+00, 7.6050277186823223e-15,
	2.2204460492503131e-16, 1.9984014443252818e-15,
	5.5511151231257827e-15}, /* L57 */
{1.0194122814946389e+00, 6.5641936330962380e-15,
	2.2204460492503131e-16, 2.6534330288541241e-13,
	1.6364687382974807e-13}, /* L58 */
{9.9577807695415899e-01, 6.5225602696727947e-15,
	2.2204460492503131e-16, 3.3306690738754696e-15,
	3.7747582837255322e-15}, /* L59 */
{8.5001311590214701e-01, 5.6621374255882984e-15,
	2.2204460492503131e-16, -6.5503158452884236e-15,
	1.5543122344752192e-15}, /* L60 */
{9.2624380035615839e-01, 6.2727600891321345e-15,
	2.2204460492503131e-16, -5.4067861299245124e-14,
	-9.2481577951275540e-14}, /* L61 */
{1.5242170674146556e+00, 1.0491607582707729e-14,
	2.2204460492503131e-16, 6.8833827526759706e-15,
	3.9968028886505635e-15}, /* L62 */
{8.9981547166579190e-01, 6.2935767708438561e-15,
	2.2204460492503131e-16, 3.7747582837255322e-15,
	4.4408920985006262e-16}, /* L63 */
{7.6563681395596928e-01, 5.4400928206632670e-15,
	2.2204460492503131e-16, -5.5511151231257827e-15,
	1.6875389974302379e-14}, /* L64 */
{9.1155252700817435e-01, 6.5780714209040525e-15,
	2.2204460492503131e-16, -5.8841820305133297e-15,
	-1.3322676295501878e-15}, /* L65 */
{8.6364968995405356e-01, 6.3282712403633923e-15,
	2.2204460492503131e-16, 3.7747582837255322e-15,
	-1.3322676295501878e-15}, /* L66 */
{1.0447922407927950e+00, 7.7715611723760958e-15,
	2.2204460492503131e-16, -6.7723604502134549e-15,
	4.8849813083506888e-15}, /* L67 */
{7.8677684603399289e-01, 5.9396931817445875e-15,
	2.2204460492503131e-16, -6.8833827526759706e-15,
	-2.9976021664879227e-15}, /* L68 */
{1.2246565778977070e+00, 9.3813845580825728e-15,
	2.2204460492503131e-16, 1.5032419753424620e-13,
	3.1863400806741993e-13}, /* L69 */
{1.6214535908385190e+00, 1.2601031329495527e-14,
	2.2204460492503131e-16, 2.2204460492503131e-15,
	-1.2212453270876722e-15}, /* L70 */
{9.7184598172736347e-01, 7.6605388699135801e-15,
	2.2204460492503131e-16, -1.9206858326015208e-14,
	-1.0325074129013956e-14}, /* L71 */
{8.4723529526194563e-01, 6.7723604502134549e-15,
	2.2204460492503131e-16, -1.4432899320127035e-15,
	4.2188474935755949e-15}, /* L72 */
{1.3493358890629930e+00, 1.0935696792557792e-14,
	2.2204460492503131e-16, -1.8318679906315083e-14,
	5.1070259132757201e-15}, /* L73 */
{1.1790722474159370e+00, 9.6866958898544908e-15,
	2.2204460492503131e-16, 2.8865798640254070e-15,
	-7.1054273576010019e-15}, /* L74 */
{1.0000154304731115e+00, 8.3266726846886741e-15,
	2.2204460492503131e-16, 1.7763568394002505e-15,
	-5.3290705182007514e-15}, /* L75 */
{9.9672590603067746e-01, 8.4099394115355608e-15,
	2.2204460492503131e-16, -5.6510351953420468e-14,
	-4.3631764867768652e-14}, /* L76 */
{1.8831459405013156e+00, 1.6098233857064770e-14,
	2.2204460492503131e-16, -1.2212453270876722e-15,
	-1.9984014443252818e-15}, /* L77 */
{1.1538639582381141e+00, 9.9920072216264089e-15,
	2.2204460492503131e-16, -3.3306690738754696e-16,
	4.2410519540680980e-14}, /* L78 */
{9.2090028565720605e-01, 8.0768725041480138e-15,
	2.2204460492503131e-16, 1.7763568394002505e-15,
	-6.4392935428259079e-15}, /* L79 */
{1.0812666841987244e+00, 9.6034291630076041e-15,
	2.2204460492503131e-16, 1.5609735726229701e-13,
	4.5519144009631418e-14}, /* L80 */
{9.4445901766904117e-01, 8.4932061383824475e-15,
	2.2204460492503131e-16, -6.5503158452884236e-15,
	1.1768364061026659e-14}, /* L81 */
{1.1158708766864638e+00, 1.0158540675320182e-14,
	2.2204460492503131e-16, -2.2204460492503131e-15,
	-1.7763568394002505e-15}, /* L82 */
{1.3976119269262395e+00, 1.2878587085651816e-14,
	2.2204460492503131e-16, 1.6209256159527285e-14,
	-9.8809849191638932e-15}, /* L83 */
{1.1964470328874373e+00, 1.1157741397482823e-14,
	2.2204460492503131e-16, 4.5075054799781356e-14,
	-7.4384942649885488e-15}, /* L84 */
{1.5279647533258061e+00, 1.4419021532319221e-14,
	2.2204460492503131e-16, 1.3322676295501878e-15,
	1.3322676295501878e-15}, /* L85 */
{1.0581558624773642e+00, 1.0103029524088925e-14,
	2.2204460492503131e-16, -2.5535129566378600e-15,
	2.2204460492503131e-15}, /* L86 */
{1.3391011224150913e+00, 1.2934098236883074e-14,
	2.2204460492503131e-16, -3.1752378504279477e-14,
	-1.2878587085651816e-14}, /* L87 */
{1.1306992651372059e+00, 1.1046719095020308e-14,
	2.2204460492503131e-16, 3.3306690738754696e-15,
	-1.8873791418627661e-15}, /* L88 */
{1.2584463844155744e+00, 1.2434497875801753e-14,
	2.2204460492503131e-16, 6.6613381477509392e-15,
	8.8817841970012523e-16}, /* L89 */
{1.4757172151078655e+00, 1.4745149545802860e-14,
	2.2204460492503131e-16, 3.2196467714129540e-14,
	2.1094237467877974e-14}, /* L90 */
{9.5880600339315103e-01, 9.6866958898544908e-15,
	2.2204460492503131e-16, 1.2434497875801753e-14,
	2.6645352591003757e-14}, /* L91 */
{1.0407769289978044e+00, 1.0630385460785874e-14,
	2.2204460492503131e-16, 2.8421709430404007e-14,
	-2.7755575615628914e-15}, /* L92 */
{1.3226010532063741e+00, 1.3655743202889425e-14,
	2.2204460492503131e-16, -5.6621374255882984e-15,
	1.9984014443252818e-15}, /* L93 */
{9.5480196686123875e-01, 9.9642516460107800e-15,
	2.2204460492503131e-16, -1.8873791418627661e-15,
	-1.5543122344752192e-15}, /* L94 */
{1.3822581706736938e+00, 1.4578616092109087e-14,
	2.2204460492503131e-16, 8.4376949871511897e-15,
	-5.1070259132757201e-15}, /* L95 */
{1.9166962417400433e+00, 2.0428103653102880e-14,
	2.2204460492503131e-16, -3.7747582837255322e-15,
	-3.1086244689504383e-15}, /* L96 */
{1.2371324913069346e+00, 1.3322676295501878e-14,
	2.2204460492503131e-16, -8.8817841970012523e-16,
	6.6613381477509392e-15}, /* L97 */
{8.9797303960849595e-01, 9.7699626167013776e-15,
	2.2204460492503131e-16, 6.4392935428259079e-15,
	-1.1102230246251565e-15}, /* L98 */
{1.4040620690480938e+00, 1.5432100042289676e-14,
	2.2204460492503131e-16, 6.2172489379008766e-15,
	1.3322676295501878e-15}, /* L99 */
{1.2800197510055726e+00, 1.4210854715202004e-14,
	2.2204460492503131e-16, 9.9920072216264089e-15,
	5.7731597280508140e-15}, /* L100 */
{1.5198254314615605e+00, 1.7041923427996153e-14,
	2.2204460492503131e-16, -1.7097434579227411e-14,
	2.8865798640254070e-15}, /* L101 */
{1.0593760277936337e+00, 1.1996480198117609e-14,
	2.2204460492503131e-16, -6.1062266354383610e-15,
	-1.5543122344752192e-15}, /* L102 */
{9.8059765512410590e-01, 1.1213252548714081e-14,
	2.2204460492503131e-16, -1.2989609388114332e-14,
	3.3306690738754696e-15}, /* L103 */
{1.1184066803548092e+00, 1.2913281555171352e-14,
	2.2204460492503131e-16, -9.6589403142388619e-15,
	1.1546319456101628e-14}, /* L104 */
{1.4190695156236912e+00, 1.6542323066914832e-14,
	2.2204460492503131e-16, -3.1641356201816961e-14,
	-6.1062266354383610e-15}, /* L105 */
{9.9529837655541686e-01, 1.1712852909795402e-14,
	2.2204460492503131e-16, 4.6851411639181606e-14,
	-1.0380585280245214e-13}, /* L106 */
{1.7804013037862301e+00, 2.1149748619109232e-14,
	2.2204460492503131e-16, 7.1054273576010019e-15,
	7.3274719625260332e-15}, /* L107 */
{1.2916865976944309e+00, 1.5487611193520934e-14,
	2.2204460492503131e-16, 7.7715611723760958e-15,
	1.4654943925052066e-14}, /* L108 */
{1.0527685380438851e+00, 1.2739809207573671e-14,
	2.2204460492503131e-16, -1.4321877017664519e-14,
	-5.3290705182007514e-15}, /* L109 */
{1.0727438254166126e+00, 1.3100631690576847e-14,
	2.2204460492503131e-16, 4.8849813083506888e-15,
	-2.2204460492503131e-15}, /* L110 */
{1.6441695140661536e+00, 2.0261570199409107e-14,
	2.2204460492503131e-16, 1.1102230246251565e-15,
	-5.6621374255882984e-15}, /* L111 */
{1.4509152451060254e+00, 1.8041124150158794e-14,
	2.2204460492503131e-16, 1.7097434579227411e-14,
	-2.2426505097428162e-14}, /* L112 */
{1.1725844649352746e+00, 1.4710455076283324e-14,
	2.2204460492503131e-16, 5.3290705182007514e-15,
	8.6597395920762210e-15}, /* L113 */
{1.0033049549154456e+00, 1.2698175844150228e-14,
	2.2204460492503131e-16, -5.5511151231257827e-15,
	3.9968028886505635e-15}, /* L114 */
{1.5000231457096496e+00, 1.9151347174783950e-14,
	2.2204460492503131e-16, 5.9952043329758453e-15,
	-1.4432899320127035e-15}, /* L115 */
{8.9279394843423010e-01, 1.1497747198774277e-14,
	2.2204460492503131e-16, -4.9960036108132044e-15,
	-1.1990408665951691e-14}, /* L116 */
{1.5042967159233618e+00, 1.9539925233402755e-14,
	2.2204460492503131e-16, -2.7056135110115065e-13,
	-2.5757174171303632e-13}, /* L117 */
{1.3474784190248486e+00, 1.7652546091539989e-14,
	2.2204460492503131e-16, 3.9968028886505635e-15,
	-1.9443335830260366e-12}, /* L118 */
{9.4119099338644763e-01, 1.2434497875801753e-14,
	2.2204460492503131e-16, -4.6629367034256575e-15,
	-2.1094237467877974e-15}, /* L119 */
{1.7194275728381851e+00, 2.2907023500273738e-14,
	2.2204460492503131e-16, -1.4099832412739488e-14,
	-7.5495165674510645e-15}, /* L120 */
{1.1518772778689883e+00, 1.5473733405713119e-14,
	2.2204460492503131e-16, 5.4178883601707639e-14,
	-3.8413716652030416e-14}, /* L121 */
{1.3360861898943925e+00, 1.8096635301390052e-14,
	2.2204460492503131e-16, 1.8429702208777599e-14,
	-3.4416913763379853e-15}, /* L122 */
{1.1829450823886922e+00, 1.6153745008296028e-14,
	2.2204460492503131e-16, -1.7763568394002505e-14,
	-1.9317880628477724e-14}, /* L123 */
{1.5010312257805758e+00, 2.0664026045835726e-14,
	2.2204460492503131e-16, 4.3298697960381105e-14,
	5.4845017416482733e-14}, /* L124 */
{1.1720180845143169e+00, 1.6264767310758543e-14,
	2.2204460492503131e-16, -4.9960036108132044e-14,
	3.3750779948604759e-14}, /* L125 */
{1.6666923841217633e+00, 2.3314683517128287e-14,
	2.2204460492503131e-16, 4.3520742565306136e-14,
	-6.3282712403633923e-15}, /* L126 */
{1.4389985820389368e+00, 2.0289325775024736e-14,
	2.2204460492503131e-16, 4.4408920985006262e-15,
	-4.0301095793893182e-14}, /* L127 */
{1.2754103048807188e+00, 1.8124390877005681e-14,
	2.2204460492503131e-16, -4.9960036108132044e-15,
	6.6613381477509392e-16}, /* L128 */
{1.4728909441076405e+00, 2.1094237467877974e-14,
	2.2204460492503131e-16, 2.6645352591003757e-14,
	3.0864200084579352e-14}, /* L129 */
{1.8423361199869592e+00, 2.6589841439772499e-14,
	2.2204460492503131e-16, -2.1649348980190553e-14,
	-1.7652546091539989e-14}, /* L130 */
{1.7175837546289456e+00, 2.4980018054066022e-14,
	2.2204460492503131e-16, -6.5059069243034173e-14,
	-1.1546319456101628e-14}, /* L131 */
{1.5094929888012547e+00, 2.2121193765656244e-14,
	2.2204460492503131e-16, 1.4432899320127035e-14,
	-5.5511151231257827e-16}, /* L132 */
{1.4812258631818391e+00, 2.1871393585115584e-14,
	2.2204460492503131e-16, -1.3655743202889425e-14,
	5.4400928206632670e-14}, /* L133 */
{2.1977951065248100e+00, 3.2696068075210860e-14,
	2.2204460492503131e-16, 1.1102230246251565e-15,
	-8.4376949871511897e-15}, /* L134 */
{1.1889072340069056e+00, 1.7819079545233762e-14,
	2.2204460492503131e-16, -3.3306690738754696e-15,
	-4.1078251911130792e-15}, /* L135 */
{1.7610565852814140e+00, 2.6589841439772499e-14,
	2.2204460492503131e-16, -7.6272321791748254e-14,
	-3.0642155479654321e-14}, /* L136 */
{1.7591512317081397e+00, 2.6756374893466273e-14,
	2.2204460492503131e-16, 4.8849813083506888e-15,
	2.6645352591003757e-15}, /* L137 */
{2.3614494811986848e+00, 3.6179392814972289e-14,
	2.2204460492503131e-16, -3.4749980670767400e-14,
	-1.0991207943789050e-14}, /* L138 */
{1.6259243689706477e+00, 2.5091040356528538e-14,
	2.2204460492503131e-16, 1.0658141036401503e-14,
	-9.3258734068513149e-15}, /* L139 */
{1.2660909646518197e+00, 1.9678703111480900e-14,
	2.2204460492503131e-16, -2.0439205883349132e-13,
	-2.3725466036239595e-13}, /* L140 */
{1.5895635344310999e+00, 2.4882873539411321e-14,
	2.2204460492503131e-16, -1.3211653993039363e-14,
	5.1070259132757201e-15}, /* L141 */
{1.1056508632695603e+00, 1.7430501486614958e-14,
	2.2204460492503131e-16, 2.6645352591003757e-15,
	7.7715611723760958e-15}, /* L142 */
{1.5489749499983407e+00, 2.4591439995447217e-14,
	2.2204460492503131e-16, 3.3306690738754696e-15,
	-8.8151708155237429e-14}, /* L143 */
{1.3066607870829714e+00, 2.0889540097712711e-14,
	2.2204460492503131e-16, -1.4543921622589551e-14,
	-4.2188474935755949e-15}, /* L144 */
{1.1310519351557555e+00, 1.8207657603852567e-14,
	2.2204460492503131e-16, 2.0206059048177849e-14,
	3.0198066269804258e-14}, /* L145 */
{1.5753667740327297e+00, 2.5535129566378600e-14,
	2.2204460492503131e-16, 5.9952043329758453e-15,
	2.0206059048177849e-14}, /* L146 */
{1.4864174935942889e+00, 2.4258373088059670e-14,
	2.2204460492503131e-16, -6.9610983643997315e-14,
	-4.4408920985006262e-15}, /* L147 */
{1.3116756448688298e+00, 2.1552204465535851e-14,
	2.2204460492503131e-16, 1.0658141036401503e-14,
	-5.1070259132757201e-15}, /* L148 */
{1.7114358038296786e+00, 2.8310687127941492e-14,
	2.2204460492503131e-16, 3.0642155479654321e-14,
	4.5297099404706387e-14}, /* L149 */
{2.0364897568488090e+00, 3.3913843955346579e-14,
	2.2204460492503131e-16, -4.6185277824406512e-14,
	-2.0539125955565396e-14}, /* L150 */
{1.2980332739915474e+00, 2.1760371282653068e-14,
	2.2204460492503131e-16, 4.1078251911130792e-14,
	2.3536728122053319e-14}, /* L151 */
{1.5806164945471264e+00, 2.6673108166619386e-14,
	2.2204460492503131e-16, 5.7731597280508140e-15,
	8.8817841970012523e-16}, /* L152 */
{1.5425074613829926e+00, 2.6201263381153694e-14,
	2.2204460492503131e-16, -4.6962433941644122e-14,
	-6.8056671409522096e-14}, /* L153 */
{1.6688569196855765e+00, 2.8532731732866523e-14,
	2.2204460492503131e-16, 3.1086244689504383e-15,
	1.0436096431476471e-14}, /* L154 */
{1.8822871086485009e+00, 3.2390756743438942e-14,
	2.2204460492503131e-16, 2.8865798640254070e-15,
	-2.5424107263916085e-14}, /* L155 */
{1.8654133991516275e+00, 3.2307490016592055e-14,
	2.2204460492503131e-16, 8.9483975784787617e-14,
	-5.5511151231257827e-15}, /* L156 */
{1.5637183960582457e+00, 2.7255975254547593e-14,
	2.2204460492503131e-16, 9.9920072216264089e-15,
	3.2862601528904634e-14}, /* L157 */
{1.7595208207058148e+00, 3.0864200084579352e-14,
	2.2204460492503131e-16, 3.9968028886505635e-15,
	1.7097434579227411e-14}, /* L158 */
{1.6069430345020865e+00, 2.8366198279172750e-14,
	2.2204460492503131e-16, 9.9920072216264089e-14,
	-5.9285909514983359e-14}, /* L159 */
{1.5562740136737514e+00, 2.7644553313166398e-14,
	2.2204460492503131e-16, -4.2188474935755949e-15,
	9.1038288019262836e-15}, /* L160 */
{1.7942823445832710e+00, 3.2071567623859210e-14,
	2.2204460492503131e-16, 2.5091040356528538e-14,
	-3.3306690738754696e-15}, /* L161 */
{1.7515702370168520e+00, 3.1502578323738817e-14,
	2.2204460492503131e-16, -1.4988010832439613e-14,
	8.4376949871511897e-15}, /* L162 */
{1.7753341422891886e+00, 3.2127078775090467e-14,
	2.2204460492503131e-16, 1.7097434579227411e-14,
	1.5099033134902129e-14}, /* L163 */
{1.8529249325305224e+00, 3.3736902160796944e-14,
	2.2204460492503131e-16, 1.3544720900426910e-14,
	-1.0769163338864018e-14}, /* L164 */
{1.1894122923051262e+00, 2.1788126858268697e-14,
	2.2204460492503131e-16, -1.4210854715202004e-14,
	-3.3306690738754696e-15}, /* L165 */
{1.7620753820078119e+00, 3.2474023470285829e-14,
	2.2204460492503131e-16, 9.4368957093138306e-14,
	2.8954616482224083e-13}, /* L166 */
{2.1242842752113966e+00, 3.9385161798577428e-14,
	2.2204460492503131e-16, -1.9984014443252818e-15,
	-3.2196467714129540e-14}, /* L167 */
{2.2321773001623937e+00, 4.1633363423443370e-14,
	2.2204460492503131e-16, 1.3367085216486885e-13,
	-8.4710016778899444e-14}, /* L168 */
{1.4674782648362414e+00, 2.7533531010703882e-14,
	2.2204460492503131e-16, 1.1990408665951691e-14,
	1.3100631690576847e-14}, /* L169 */
{1.3264910563040142e+00, 2.5035529205297280e-14,
	2.2204460492503131e-16, 5.7731597280508140e-15,
	1.7541523789077473e-14}, /* L170 */
{2.4971145544562403e+00, 4.7406523151494184e-14,
	2.2204460492503131e-16, -1.0991207943789050e-14,
	-8.3266726846886741e-15}, /* L171 */
{1.0436207544762772e+00, 1.9928503292021560e-14,
	2.2204460492503131e-16, 1.7763568394002505e-15,
	-4.3298697960381105e-15}, /* L172 */
{1.6792166621527975e+00, 3.2251978865360797e-14,
	2.2204460492503131e-16, -7.1054273576010019e-15,
	5.3290705182007514e-15}, /* L173 */
{1.6322090934143754e+00, 3.1530333899354446e-14,
	2.2204460492503131e-16, 2.0317081350640365e-13,
	-2.2049029269055609e-13}, /* L174 */
{2.5086101370152787e+00, 4.8738790781044372e-14,
	2.2204460492503131e-16, -8.5487172896137054e-15,
	-2.8088642523016460e-14}, /* L175 */
{1.6988898506325165e+00, 3.3195668436292181e-14,
	2.2204460492503131e-16, -9.6589403142388619e-14,
	4.7073456244106637e-14}, /* L176 */
{1.7683888685765838e+00, 3.4749980670767400e-14,
	2.2204460492503131e-16, 6.1284310959308641e-14,
	2.8421709430404007e-14}, /* L177 */
{1.5955302373829998e+00, 3.1530333899354446e-14,
	2.2204460492503131e-16, -1.1901590823981678e-13,
	-1.3200551762793111e-13}, /* L178 */
{1.7758653908470168e+00, 3.5291214395272164e-14,
	2.2204460492503131e-16, -1.6764367671839864e-14,
	5.8397731095283234e-14}, /* L179 */
{1.1736292204852639e+00, 2.3453461395206432e-14,
	2.2204460492503131e-16, -8.8817841970012523e-16,
	-1.6053824936079764e-13}, /* L180 */
{2.2514159553467405e+00, 4.5241588253475129e-14,
	2.2204460492503131e-16, -3.6859404417555197e-14,
	-3.8302694349567901e-14}, /* L181 */
{1.9890416803911044e+00, 4.0190073491430667e-14,
	2.2204460492503131e-16, -3.1530333899354446e-14,
	1.2212453270876722e-14}, /* L182 */
{1.8494137827908461e+00, 3.7574110489657642e-14,
	2.2204460492503131e-16, -4.8183679268731794e-14,
	4.4630965589931293e-14}, /* L183 */
{2.5000385761827033e+00, 5.1070259132757201e-14,
	2.2204460492503131e-16, 7.1054273576010019e-15,
	1.8429702208777599e-14}, /* L184 */
{2.2189531578855655e+00, 4.5574655160862676e-14,
	2.2204460492503131e-16, -4.9027448767446913e-13,
	2.4358293160275934e-13}, /* L185 */
{2.3306811242462593e+00, 4.8128168117500536e-14,
	2.2204460492503131e-16, 2.9753977059954195e-13,
	1.7630341631047486e-13}, /* L186 */
{2.3422821312684450e+00, 4.8627768478581856e-14,
	2.2204460492503131e-16, -3.3306690738754696e-15,
	-7.6605388699135801e-15}, /* L187 */
{1.7260904637671115e+00, 3.6026737149086330e-14,
	2.2204460492503131e-16, 1.6564527527407336e-13,
	2.0938806244430452e-13}, /* L188 */
{1.8733754674700820e+00, 3.9308833965634449e-14,
	2.2204460492503131e-16, -3.0420110874729289e-14,
	-2.8865798640254070e-15}, /* L189 */
{1.5184444825867374e+00, 3.2029934260435766e-14,
	2.2204460492503131e-16, -3.0309088572266774e-14,
	2.0650148258027912e-14}, /* L190 */
{1.8900815204229877e+00, 4.0079051188968151e-14,
	2.2204460492503131e-16, -7.1054273576010019e-15,
	-1.3100631690576847e-14}, /* L191 */
{1.4349179744548259e+00, 3.0586644328423063e-14,
	2.2204460492503131e-16, -2.3314683517128287e-15,
	-5.1070259132757201e-15}, /* L192 */
{2.2979629192475857e+00, 4.9238391142125693e-14,
	2.2204460492503131e-16, 7.5495165674510645e-15,
	-3.6082248300317588e-14}, /* L193 */
{1.5876533638438366e+00, 3.4194869158454821e-14,
	2.2204460492503131e-16, 3.1308289294429414e-14,
	2.2204460492503131e-14}, /* L194 */
{1.7923353484632876e+00, 3.8802294710649221e-14,
	2.2204460492503131e-16, 9.7699626167013776e-15,
	4.7961634663806763e-14}, /* L195 */
{1.8922884459041780e+00, 4.1176263787523482e-14,
	2.2204460492503131e-16, 4.3964831775156199e-14,
	4.8405723873656825e-14}, /* L196 */
{2.3109493640753707e+00, 5.0542903196060252e-14,
	2.2204460492503131e-16, 6.6613381477509392e-14,
	-1.7541523789077473e-14}, /* L197 */
{2.2374082611088202e+00, 4.9182879990894435e-14,
	2.2204460492503131e-16, -6.1284310959308641e-14,
	1.9761969838327786e-14}, /* L198 */
{1.9786737474811122e+00, 4.3715031594615539e-14,
	2.2204460492503131e-16, 1.3100631690576847e-13,
	-2.2315482794965646e-14}, /* L199 */
{2.8323874544038095e+00, 6.2890664898063164e-14,
	2.2204460492503131e-16, 1.6875389974302379e-14,
	2.0872192862952943e-14}, /* L200 */
{2.4428237629964049e+00, 5.4511950509095186e-14,
	2.2204460492503131e-16, 2.2648549702353193e-14,
	1.1324274851176597e-14}, /* L201 */
{1.4604185742056859e+00, 3.2751579226442118e-14,
	2.2204460492503131e-16, -7.4829031859735551e-14,
	3.4194869158454821e-14}, /* L202 */
{2.0000308609461306e+00, 4.5075054799781356e-14,
	2.2204460492503131e-16, 1.2212453270876722e-14,
	1.4654943925052066e-14}, /* L203 */
{1.8284595861100834e+00, 4.1411318818518339e-14,
	2.2204460492503131e-16, 2.0206059048177849e-14,
	9.9920072216264089e-15}, /* L204 */
{2.1146667761305893e+00, 4.8128168117500536e-14,
	2.2204460492503131e-16, 5.1856297034191812e-12,
	-7.4718009557273035e-13}, /* L205 */
{1.6650742361758482e+00, 3.8080649744642869e-14,
	2.2204460492503131e-16, -7.4051875742497941e-14,
	1.6853185513809876e-13}, /* L206 */
{1.9770836469618631e+00, 4.5435877282784531e-14,
	2.2204460492503131e-16, 7.3274719625260332e-15,
	3.4194869158454821e-14}, /* L207 */
{2.9327375605219776e+00, 6.7723604502134549e-14,
	2.2204460492503131e-16, 1.1990408665951691e-14,
	-7.6605388699135801e-15}, /* L208 */
{1.7512231940341563e+00, 4.0634162701280729e-14,
	2.2204460492503131e-16, -2.6645352591003757e-15,
	6.5503158452884236e-14}, /* L209 */
{2.1286042734352204e+00, 4.9626969200744497e-14,
	2.2204460492503131e-16, 2.6867397195928788e-14,
	1.1679546219056647e-13}, /* L210 */
{2.0885985782776806e+00, 4.8926140916449867e-14,
	2.2204460492503131e-16, 6.6613381477509392e-15,
	5.7731597280508140e-15}, /* L211 */
{2.4599436178854401e+00, 5.7898130734201914e-14,
	2.2204460492503131e-16, 1.3100631690576847e-14,
	-4.1078251911130792e-15}, /* L212 */
{2.1353029012769920e+00, 5.0494330938732901e-14,
	2.2204460492503131e-16, 1.0214051826551440e-14,
	1.3544720900426910e-14}, /* L213 */
{1.7967566963405959e+00, 4.2688075296837269e-14,
	2.2204460492503131e-16, -2.2093438190040615e-14,
	-5.1736392947532295e-14}, /* L214 */
{2.7514959446009066e+00, 6.5676630800481917e-14,
	2.2204460492503131e-16, 1.3544720900426910e-14,
	-5.2180482157382357e-15}, /* L215 */
{1.8773437826704427e+00, 4.5019543648550098e-14,
	2.2204460492503131e-16, 2.3758772726978350e-14,
	5.3512749786932545e-14}, /* L216 */
{1.5345858910015440e+00, 3.6970426720017713e-14,
	2.2204460492503131e-16, -3.7159164634203989e-13,
	9.9698027611339057e-14}, /* L217 */
{1.7683759103089505e+00, 4.2799097599299785e-14,
	2.2204460492503131e-16, -2.2648549702353193e-14,
	-2.0095036745715333e-14}, /* L218 */
{2.2546009990687268e+00, 5.4817261840867104e-14,
	2.2204460492503131e-16, 4.0856207306205761e-14,
	1.6875389974302379e-14}, /* L219 */
{2.4454922799750403e+00, 5.9729998724833422e-14,
	2.2204460492503131e-16, -2.9976021664879227e-15,
	3.3306690738754696e-15}, /* L220 */
{1.5588475827962787e+00, 3.8247183198336643e-14,
	2.2204460492503131e-16, -1.1768364061026659e-14,
	-1.5099033134902129e-14}, /* L221 */
{1.9651204123596644e+00, 4.8433479449272454e-14,
	2.2204460492503131e-16, 4.4408920985006262e-16,
	3.4861002973229915e-14}, /* L222 */
{2.5762729363532069e+00, 6.3782312764715243e-14,
	2.2204460492503131e-16, -4.3409720262843621e-14,
	1.1102230246251565e-14}, /* L223 */
{2.6339692141866542e+00, 6.5503158452884236e-14,
	2.2204460492503131e-16, -5.6299409578741688e-13,
	-1.0330625244137082e-12}, /* L224 */
{2.3311470812579520e+00, 5.8231197641589461e-14,
	2.2204460492503131e-16, 2.2093438190040615e-13,
	-3.2973623831367149e-14}, /* L225 */
{1.3761274286598091e+00, 3.4527936065842368e-14,
	2.2204460492503131e-16, 1.3100631690576847e-14,
	1.8429702208777599e-14}, /* L226 */
{2.2401226713460232e+00, 5.6454840802189210e-14,
	2.2204460492503131e-16, 1.2656542480726785e-14,
	-4.9404924595819466e-14}, /* L227 */
{4.3926116386781411e+00, 1.1118883591620943e-13,
	2.2204460492503131e-16, 3.0198066269804258e-14,
	1.5099033134902129e-14}, /* L228 */
{2.3013455539520424e+00, 5.8508753397745750e-14,
	2.2204460492503131e-16, -2.8419488984354757e-12,
	9.1238128163695364e-13}, /* L229 */
{1.7543748965038315e+00, 4.4797499043625066e-14,
	2.2204460492503131e-16, 2.6201263381153694e-14,
	3.3972824553529790e-14}, /* L230 */
{1.9348242270864668e+00, 4.9620030306840590e-14,
	2.2204460492503131e-16, 7.5495165674510645e-15,
	-1.5543122344752192e-15}, /* L231 */
{3.2349637093533472e+00, 8.3322237998117998e-14,
	2.2204460492503131e-16, 3.8191672047105385e-14,
	2.7755575615628914e-14}, /* L232 */
{2.3412378425880735e+00, 6.0562665993302289e-14,
	2.2204460492503131e-16, -5.0404125317982107e-14,
	3.0198066269804258e-14}, /* L233 */
{2.1773840248973513e+00, 5.6565863104651726e-14,
	2.2204460492503131e-16, 1.0125233984581428e-13,
	-9.7699626167013776e-15}, /* L234 */
{1.8787523938461115e+00, 4.9016346537200661e-14,
	2.2204460492503131e-16, -3.6637359812630166e-14,
	-2.1538326677728037e-14}, /* L235 */
{2.1292701432741032e+00, 5.5788706987414116e-14,
	2.2204460492503131e-16, 1.3544720900426910e-14,
	-2.3425705819590803e-14}, /* L236 */
{2.5422333200845082e+00, 6.6890937233665682e-14,
	2.2204460492503131e-16, -8.7707618945387367e-15,
	9.5479180117763462e-15}, /* L237 */
{1.7195643484079930e+00, 4.5435877282784531e-14,
	2.2204460492503131e-16, 1.9984014443252818e-15,
	1.6653345369377348e-14}, /* L238 */
{2.6799576703675378e+00, 7.1109784727241276e-14,
	2.2204460492503131e-16, -2.0827783941967937e-13,
	-2.3203661214665772e-14}, /* L239 */
{2.6667078145948717e+00, 7.1054273576010019e-14,
	2.2204460492503131e-16, -2.5091040356528538e-14,
	-1.2101430968414206e-14}, /* L240 */
{2.8563718753176426e+00, 7.6424977457634213e-14,
	2.2204460492503131e-16, 8.0380146982861334e-14,
	-7.8381745538536052e-14}, /* L241 */
{2.0961067235843580e+00, 5.6316062924111066e-14,
	2.2204460492503131e-16, 7.0388139761234925e-14,
	5.6399329650957952e-14}, /* L242 */
{1.7572287605426158e+00, 4.7406523151494184e-14,
	2.2204460492503131e-16, 3.1152858070981893e-13,
	1.0946799022804043e-13}, /* L243 */
{2.0896838836574534e+00, 5.6607496468075169e-14,
	2.2204460492503131e-16, -1.6764367671839864e-14,
	1.7541523789077473e-14}, /* L244 */
{2.0265618825707352e+00, 5.5122573172639022e-14,
	2.2204460492503131e-16, 1.3988810110276972e-14,
	5.4400928206632670e-14}, /* L245 */
{1.9146636900521390e+00, 5.2291504459844873e-14,
	2.2204460492503131e-16, -1.4321877017664519e-14,
	7.1054273576010019e-15}, /* L246 */
{2.9433652548737679e+00, 8.0713213890248880e-14,
	2.2204460492503131e-16, 1.0835776720341528e-13,
	6.5725203057809267e-14}, /* L247 */
{2.1814852737334989e+00, 6.0063065632220969e-14,
	2.2204460492503131e-16, -9.3258734068513149e-14,
	-1.6431300764452317e-14}, /* L248 */
{2.6255425207666603e+00, 7.2580830234869609e-14,
	2.2204460492503131e-16, -7.2830630415410269e-14,
	-1.2911893776390571e-13}, /* L249 */
{2.7360422177743606e+00, 7.5939254884360707e-14,
	2.2204460492503131e-16, 4.8849813083506888e-15,
	-1.8429702208777599e-14}, /* L250 */
{1.8685547286517161e+00, 5.2069459854919842e-14,
	2.2204460492503131e-16, -3.3528735343679728e-14,
	-8.8040685852774914e-14}, /* L251 */
{2.0397140129490610e+00, 5.7065463465733046e-14,
	2.2204460492503131e-16, -1.8873791418627661e-15,
	-1.3433698597964394e-14}, /* L252 */
{1.9461762750161948e+00, 5.4664606174981145e-14,
	2.2204460492503131e-16, 3.5749181392930041e-14,
	9.3480778673438181e-14}, /* L253 */
{2.2825155347116022e+00, 6.4365179852643450e-14,
	2.2204460492503131e-16, 2.9531932455029164e-14,
	4.7517545453956700e-14}, /* L254 */
{2.7804350596286973e+00, 7.8714812445923599e-14,
	2.2204460492503131e-16, 2.0428103653102880e-14,
	-9.3369756370975665e-14}, /* L255 */
{2.5801179368259426e+00, 7.3330230776491589e-14,
	2.2204460492503131e-16, -4.7739590058881731e-14,
	5.0626169922907138e-14}, /* L256 */
{1.7938019978472670e+00, 5.1181281435219717e-14,
	2.2204460492503131e-16, -2.3425705819590803e-14,
	-4.4841907964610073e-13}, /* L257 */
{2.3566255105721221e+00, 6.7501559897209518e-14,
	2.2204460492503131e-16, -3.4194869158454821e-14,
	2.6201263381153694e-14}, /* L258 */
{2.8436732221749996e+00, 8.1767925763642779e-14,
	2.2204460492503131e-16, -2.5424107263916085e-14,
	4.0856207306205761e-14}, /* L259 */
{2.9615841594774968e+00, 8.5487172896137054e-14,
	2.2204460492503131e-16, -2.8754776337791554e-14,
	6.2172489379008766e-15}, /* L260 */
{2.3122962156713154e+00, 6.7001959536128197e-14,
	2.2204460492503131e-16, 7.2830630415410269e-14,
	8.6375351315837179e-14}, /* L261 */
{3.0114968497822918e+00, 8.7596596642924851e-14,
	2.2204460492503131e-16, -2.2726265314076954e-13,
	1.7963408538435033e-13}, /* L262 */
{3.1902227049732002e+00, 9.3149446489526611e-14,
	2.2204460492503131e-16, 6.8167693711984612e-14,
	-5.0515147620444623e-14}, /* L263 */
{2.2905182977808596e+00, 6.7133798520302435e-14,
	2.2204460492503131e-16, -1.2545520178264269e-14,
	-6.3282712403633923e-14}, /* L264 */
{2.2878890762496615e+00, 6.7310740314852069e-14,
	2.2204460492503131e-16, -2.8799185258776561e-13,
	-2.1671553440683056e-13}, /* L265 */
{2.6334992821291503e+00, 7.7771122874992216e-14,
	2.2204460492503131e-16, -3.5416114485542494e-14,
	-4.5186077102243871e-14}, /* L266 */
{2.6835620072418931e+00, 7.9547479714392466e-14,
	2.2204460492503131e-16, -1.8418599978531347e-13,
	-9.0816243414337805e-14}, /* L267 */
{1.7780125097773152e+00, 5.2902127123388709e-14,
	2.2204460492503131e-16, -1.6719958750854857e-13,
	6.4170890823334048e-14}, /* L268 */
{2.7816414343914424e+00, 8.3072437817577338e-14,
	2.2204460492503131e-16, -9.4368957093138306e-15,
	4.9737991503207013e-14}, /* L269 */
{2.0782728089783720e+00, 6.2297389469279096e-14,
	2.2204460492503131e-16, 8.7263529735537304e-14,
	3.6859404417555197e-14}, /* L270 */
{2.4742079193066253e+00, 7.4440453801116746e-14,
	2.2204460492503131e-16, 1.0436096431476471e-13,
	6.6835426082434424e-14}, /* L271 */
{2.5055533671591936e+00, 7.5661699128204418e-14,
	2.2204460492503131e-16, -4.7850612361344247e-14,
	-5.4622972811557702e-14}, /* L272 */
{2.1612055090809590e+00, 6.5503158452884236e-14,
	2.2204460492503131e-16, 1.9984014443252818e-14,
	-1.3322676295501878e-14}, /* L273 */
{3.1560705967207814e+00, 9.6006536054460412e-14,
	2.2204460492503131e-16, 1.2212453270876722e-14,
	-5.7731597280508140e-15}, /* L274 */
{2.0473043176593291e+00, 6.2505556286396313e-14,
	2.2204460492503131e-16, -4.1744385725905886e-14,
	2.8865798640254070e-15}, /* L275 */
{2.4710526216759376e+00, 7.5717210279435676e-14,
	2.2204460492503131e-16, 1.1546319456101628e-14,
	-1.4432899320127035e-14}, /* L276 */
{2.2798185716353379e+00, 7.0110584005078636e-14,
	2.2204460492503131e-16, -5.1492143882114760e-13,
	5.0959236830294685e-13}, /* L277 */
{2.6448249829313464e+00, 8.1629147885564635e-14,
	2.2204460492503131e-16, 5.9285909514983359e-14,
	-1.6264767310758543e-13}, /* L278 */
{1.7132880851832031e+00, 5.3068660577082483e-14,
	2.2204460492503131e-16, -1.6098233857064770e-14,
	1.7763568394002505e-14}, /* L279 */
{2.6000401192288352e+00, 8.0824236192711396e-14,
	2.2204460492503131e-16, -5.7953641885433171e-14,
	2.2426505097428162e-14}, /* L280 */
{2.1094631544940370e+00, 6.5808469784656154e-14,
	2.2204460492503131e-16, -2.2204460492503131e-15,
	1.9317880628477724e-14}, /* L281 */
{2.4060654949502083e+00, 7.5328632220816871e-14,
	2.2204460492503131e-16, 3.1086244689504383e-14,
	8.8817841970012523e-15}, /* L282 */
{3.0861783624971655e+00, 9.6964103413199609e-14,
	2.2204460492503131e-16, 4.8849813083506888e-14,
	4.5741188614556449e-13}, /* L283 */
{2.8415931422244336e+00, 8.9594998087250133e-14,
	2.2204460492503131e-16, 2.6645352591003757e-14,
	-1.0880185641326534e-14}, /* L284 */
{2.6057419615963195e+00, 8.2447937366225688e-14,
	2.2204460492503131e-16, 6.3282712403633923e-14,
	5.7953641885433171e-14}, /* L285 */
{3.2002242053862524e+00, 1.0161316232881745e-13,
	2.2204460492503131e-16, -1.4876988529977098e-14,
	7.1054273576010019e-15}, /* L286 */
{3.0923822109572510e+00, 9.8532293435482643e-14,
	2.2204460492503131e-16, -1.3322676295501878e-15,
	1.1102230246251565e-14}, /* L287 */
{2.6523846769162907e+00, 8.4807161293554145e-14,
	2.2204460492503131e-16, 4.7739590058881731e-14,
	-1.7608137170554983e-13}, /* L288 */
{2.7219278131344971e+00, 8.7332918674576376e-14,
	2.2204460492503131e-16, 6.8167693711984612e-14,
	2.0206059048177849e-14}, /* L289 */
{1.7474407565246566e+00, 5.6260551772879808e-14,
	2.2204460492503131e-16, 6.4392935428259079e-15,
	9.9920072216264089e-15}, /* L290 */
{3.4055508302359989e+00, 1.1002310174035301e-13,
	2.2204460492503131e-16, -8.1823436914874037e-14,
	-1.1013412404281553e-13}, /* L291 */
{2.3493513195358955e+00, 7.6161299489285739e-14,
	2.2204460492503131e-16, 2.7755575615628914e-14,
	-8.3710816056736803e-14}, /* L292 */
{2.8763242458400216e+00, 9.3564045400285067e-14,
	2.2204460492503131e-16, -2.9976021664879227e-15,
	4.2410519540680980e-14}, /* L293 */
{3.3895080832180957e+00, 1.1063372440389685e-13,
	2.2204460492503131e-16, -1.1379786002407855e-13,
	2.9021229863701592e-13}, /* L294 */
{2.9129686765961855e+00, 9.5402852284820483e-14,
	2.2204460492503131e-16, 2.0605739337042905e-13,
	8.3821838359199319e-13}, /* L295 */
{2.5253768049952692e+00, 8.2989171090730451e-14,
	2.2204460492503131e-16, 7.9936057773011271e-15,
	5.9063864910058328e-14}, /* L296 */
{2.1254536716697880e+00, 7.0082828429463007e-14,
	2.2204460492503131e-16, 7.9491968563161208e-14,
	6.0840221749458578e-14}, /* L297 */
{2.7013839648678228e+00, 8.9372953482325102e-14,
	2.2204460492503131e-16, 8.4376949871511897e-15,
	-2.5812685322534890e-13}, /* L298 */
{2.2257868527747759e+00, 7.3885342288804168e-14,
	2.2204460492503131e-16, -1.0258460747536446e-13,
	1.2811973704174306e-13}, /* L299 */
{2.3400361073059397e+00, 7.7937656328685989e-14,
	2.2204460492503131e-16, 2.4669155607170978e-13,
	-3.1974423109204508e-13}, /* L300 */
{2.9302777730136529e+00, 9.7921670771938807e-14,
	2.2204460492503131e-16, 8.5931262105987116e-14,
	5.5289106626332796e-14}, /* L301 */
{2.9487209961444791e+00, 9.8865360342870190e-14,
	2.2204460492503131e-16, -1.5509815654013437e-13,
	1.5654144647214707e-13}, /* L302 */
{2.8465785768414800e+00, 9.5756735873919752e-14,
	2.2204460492503131e-16, -1.4099832412739488e-14,
	5.2846615972157451e-14}, /* L303 */
{2.5691185894716448e+00, 8.6708418223224726e-14,
	2.2204460492503131e-16, 3.1530333899354446e-14,
	-3.7414515929867775e-14}, /* L304 */
{2.4983992066243110e+00, 8.4598994476436928e-14,
	2.2204460492503131e-16, 1.1768364061026659e-14,
	1.3988810110276972e-14}, /* L305 */
{2.9363198179032119e+00, 9.9753538762570315e-14,
	2.2204460492503131e-16, 4.5385917246676399e-13,
	7.8381745538536052e-13}, /* L306 */
{2.5782156782379668e+00, 8.7874152399081140e-14,
	2.2204460492503131e-16, 5.4622972811557702e-14,
	3.7747582837255322e-15}, /* L307 */
{3.2955053958770213e+00, 1.1268763699945339e-13,
	2.2204460492503131e-16, 3.7747582837255322e-14,
	6.6613381477509392e-14}, /* L308 */
{2.7338609543427785e+00, 9.3786090005210099e-14,
	2.2204460492503131e-16, -7.4384942649885488e-15,
	-5.5733195836182858e-14}, /* L309 */
{3.1911782728880511e+00, 1.0982881271104361e-13,
	2.2204460492503131e-16, -1.8207657603852567e-14,
	7.5273121069585613e-14}, /* L310 */
{2.1286502089167438e+00, 7.3496764230185363e-14,
	2.2204460492503131e-16, -9.1926466438962962e-14,
	-3.2196467714129540e-15}, /* L311 */
{3.2378304092011843e+00, 1.1215334216885253e-13,
	2.2204460492503131e-16, 1.7652546091539989e-13,
	-4.4408920985006262e-15}, /* L312 */
{2.3195246087010419e+00, 8.0602191587786365e-14,
	2.2204460492503131e-16, -6.7279515292284486e-14,
	-4.0745185003743245e-14}, /* L313 */
{3.9773702889525016e+00, 1.3865297798787424e-13,
	2.2204460492503131e-16, -2.9842794901924208e-13,
	-3.2984726061613401e-13}, /* L314 */
{2.6254373365114159e+00, 9.1815444136500446e-14,
	2.2204460492503131e-16, -5.9396931817445875e-14,
	-1.4765966227514582e-14}, /* L315 */
{3.0429662574816128e+00, 1.0675488271161271e-13,
	2.2204460492503131e-16, 8.2822637637036678e-14,
	-2.6090241078691179e-14}, /* L316 */
{2.7642382364412246e+00, 9.7283292532779342e-14,
	2.2204460492503131e-16, -8.3932860661661834e-14,
	1.7097434579227411e-14}, /* L317 */
{2.0049444587766967e+00, 7.0783656713757637e-14,
	2.2204460492503131e-16, 3.3306690738754696e-15,
	-6.7723604502134549e-15}, /* L318 */
{2.1990934936576845e+00, 7.7882145177454731e-14,
	2.2204460492503131e-16, 1.2434497875801753e-14,
	8.3488771451811772e-14}, /* L319 */
{2.8328562116367904e+00, 1.0064171718227044e-13,
	2.2204460492503131e-16, -4.7184478546569153e-14,
	-4.2965631052993558e-14}, /* L320 */
{2.3009506132426520e+00, 8.2000378709423671e-14,
	2.2204460492503131e-16, -1.4299672557172016e-13,
	7.7937656328685989e-14}, /* L321 */
{2.5365298224804689e+00, 9.0677465536259660e-14,
	2.2204460492503131e-16, -2.3869795029440866e-14,
	-1.2401191185062999e-13}, /* L322 */
{2.7523644510519953e+00, 9.8698826889176416e-14,
	2.2204460492503131e-16, -1.8451906669270102e-13,
	2.9309887850104133e-14}, /* L323 */
{2.7114615915716738e+00, 9.7533092713320002e-14,
	2.2204460492503131e-16, -3.1452618287630685e-13,
	-8.4598994476436928e-14}, /* L324 */
{3.1777413409872746e+00, 1.1465828286816304e-13,
	2.2204460492503131e-16, -1.9984014443252818e-15,
	-1.2656542480726785e-14}, /* L325 */
{2.6779554319104117e+00, 9.6922470049776166e-14,
	2.2204460492503131e-16, -9.4591001698063337e-14,
	8.5487172896137054e-14}, /* L326 */
{2.9427059571018237e+00, 1.0683121054455569e-13,
	2.2204460492503131e-16, 5.3290705182007514e-15,
	-2.5535129566378600e-14}, /* L327 */
{2.3811343024345368e+00, 8.6708418223224726e-14,
	2.2204460492503131e-16, 3.2818192607919627e-13,
	1.2407852523210749e-12}, /* L328 */
{3.4149463104369420e+00, 1.2473355681663634e-13,
	2.2204460492503131e-16, -2.5512925105886097e-13,
	2.5934809855243657e-13}, /* L329 */
{3.9894554976294163e+00, 1.4616086119190186e-13,
	2.2204460492503131e-16, -7.4940054162198066e-14,
	-3.3306690738754696e-14}, /* L330 */
{3.5517919651051515e+00, 1.3052059433249497e-13,
	2.2204460492503131e-16, -9.5479180117763462e-15,
	-5.9174887212520844e-14}, /* L331 */
{2.5734583837660527e+00, 9.4854679666411812e-14,
	2.2204460492503131e-16, 3.1752378504279477e-14,
	-3.2640556923979602e-14}, /* L332 */
{3.2230227049620011e+00, 1.1915468611789493e-13,
	2.2204460492503131e-16, -6.2794214272798854e-13,
	-1.5784040741095851e-12}, /* L333 */
{2.4483910726605513e+00, 9.0788487838722176e-14,
	2.2204460492503131e-16, 3.3506530883187224e-13,
	6.6613381477509392e-14}, /* L334 */
{3.4418441532396629e+00, 1.2800871473928055e-13,
	2.2204460492503131e-16, 5.9952043329758453e-14,
	2.4424906541753444e-14}, /* L335 */
{2.7664117340012329e+00, 1.0319523013890830e-13,
	2.2204460492503131e-16, 1.9761969838327786e-14,
	-4.6518344731794059e-14}, /* L336 */
{2.7700724164584529e+00, 1.0363931934875836e-13,
	2.2204460492503131e-16, -4.4853010194856324e-14,
	2.9976021664879227e-14}, /* L337 */
{3.4142538661712134e+00, 1.2811973704174306e-13,
	2.2204460492503131e-16, -6.7945649107059580e-14,
	-5.3290705182007514e-15}, /* L338 */
{2.5929603639686984e+00, 9.7588603864551260e-14,
	2.2204460492503131e-16, -5.1070259132757201e-15,
	-1.1579626146840383e-13}, /* L339 */
{3.1441661622755182e+00, 1.1868284133242923e-13,
	2.2204460492503131e-16, -3.9046543776066756e-13,
	-5.3890225615305098e-13}, /* L340 */
{3.3284971072928826e+00, 1.2601031329495527e-13,
	2.2204460492503131e-16, 6.9499961341534799e-14,
	6.5503158452884236e-14}, /* L341 */
{2.4766464023700530e+00, 9.4035890185750759e-14,
	2.2204460492503131e-16, 1.2523315717771766e-13,
	-3.1086244689504383e-15}, /* L342 */
{2.5496020231715848e+00, 9.7089003503469939e-14,
	2.2204460492503131e-16, -4.8194781498978045e-13,
	-1.8129941992128806e-13}, /* L343 */
{3.1846421630322994e+00, 1.2162493234768590e-13,
	2.2204460492503131e-16, -1.1912693054227930e-13,
	5.1514348342607263e-14}, /* L344 */
{2.8420728393588695e+00, 1.0885736756449660e-13,
	2.2204460492503131e-16, -1.4765966227514582e-14,
	2.3758772726978350e-14}, /* L345 */
{2.8743218081081521e+00, 1.1041167979897182e-13,
	2.2204460492503131e-16, -1.1990408665951691e-14,
	-1.3877787807814457e-14}, /* L346 */
{3.5324752562018067e+00, 1.3608558724342856e-13,
	2.2204460492503131e-16, -5.5511151231257827e-14,
	-3.1308289294429414e-14}, /* L347 */
{2.3351653424946766e+00, 9.0219498538601783e-14,
	2.2204460492503131e-16, 1.7319479184152442e-14,
	5.4622972811557702e-14}, /* L348 */
{2.5845671011079387e+00, 1.0014211682118912e-13,
	2.2204460492503131e-16, -5.3734794391857577e-14,
	8.8817841970012523e-15}, /* L349 */
{4.4757833481027554e+00, 1.7391643680753077e-13,
	2.2204460492503131e-16, 7.4162898044960457e-14,
	-1.6209256159527285e-14}, /* L350 */
{2.3652430489624368e+00, 9.2169327725599715e-14,
	2.2204460492503131e-16, -5.8952842607595812e-14,
	1.6653345369377348e-14}, /* L351 */
{3.5341454417838407e+00, 1.3811174426336947e-13,
	2.2204460492503131e-16, 5.5511151231257827e-14,
	2.7533531010703882e-14}, /* L352 */
{3.5156349836156866e+00, 1.3777867735598193e-13,
	2.2204460492503131e-16, -2.9143354396410359e-13,
	-2.9243274468626623e-13}, /* L353 */
{2.6426961446536787e+00, 1.0386136395368339e-13,
	2.2204460492503131e-16, -6.6835426082434424e-14,
	-2.0872192862952943e-13}, /* L354 */
{3.2127256294481543e+00, 1.2662093595849910e-13,
	2.2204460492503131e-16, 9.4146912488213275e-14,
	4.3476333644321130e-13}, /* L355 */
{3.6638556914563796e+00, 1.4480777688063995e-13,
	2.2204460492503131e-16, -1.2334577803585489e-13,
	-8.7485574340462335e-14}, /* L356 */
{2.6947194513026353e+00, 1.0680345496894006e-13,
	2.2204460492503131e-16, 7.2830630415410269e-14,
	2.5757174171303632e-14}, /* L357 */
{2.8952960717466705e+00, 1.1507461650239748e-13,
	2.2204460492503131e-16, -8.4376949871511897e-15,
	-3.8857805861880479e-15}, /* L358 */
{2.8131092147355066e+00, 1.1212038242280897e-13,
	2.2204460492503131e-16, 3.3306690738754696e-14,
	-1.2101430968414206e-14}, /* L359 */
{3.4507476902917014e+00, 1.3791745523406007e-13,
	2.2204460492503131e-16, -9.6811447747313650e-14,
	1.1768364061026659e-14}, /* L360 */
{2.6420075257996265e+00, 1.0588752097362431e-13,
	2.2204460492503131e-16, 1.1546319456101628e-14,
	-3.9745984281580604e-14}, /* L361 */
{3.9627683287668272e+00, 1.5926149288247871e-13,
	2.2204460492503131e-16, -4.9404924595819466e-14,
	-1.8540724511240114e-14}, /* L362 */
{3.3154781558519222e+00, 1.3361534101363759e-13,
	2.2204460492503131e-16, -8.1823436914874037e-14,
	4.7517545453956700e-14}, /* L363 */
{2.6976721202175087e+00, 1.0901696212428647e-13,
	2.2204460492503131e-16, -3.0575542098176811e-13,
	2.9642954757491680e-13}, /* L364 */
{3.1774462890150366e+00, 1.2875811528090253e-13,
	2.2204460492503131e-16, -1.7430501486614958e-14,
	2.2737367544323206e-13}, /* L365 */
{3.0014124327175957e+00, 1.2195799925507345e-13,
	2.2204460492503131e-16, -9.6589403142388619e-15,
	4.6629367034256575e-15}, /* L366 */
{2.3844032769162014e+00, 9.7151453548605105e-14,
	2.2204460492503131e-16, 5.3956838996782608e-14,
	6.3948846218409017e-14}, /* L367 */
{2.1032933238739719e+00, 8.5931262105987116e-14,
	2.2204460492503131e-16, 2.9309887850104133e-14,
	-7.3163697322797816e-14}, /* L368 */
{3.4905687654446971e+00, 1.4299672557172016e-13,
	2.2204460492503131e-16, -4.5741188614556449e-14,
	-7.5606187976973160e-14}, /* L369 */
{2.4143109020328741e+00, 9.9174141121594062e-14,
	2.2204460492503131e-16, -1.0325074129013956e-14,
	-9.9920072216264089e-16}, /* L370 */
{2.7830618112220349e+00, 1.1463052729254741e-13,
	2.2204460492503131e-16, 3.9523939676655573e-14,
	-8.1046280797636427e-15}, /* L371 */
{2.8863012567365454e+00, 1.1920325837522228e-13,
	2.2204460492503131e-16, -9.1038288019262836e-15,
	-2.1871393585115584e-14}, /* L372 */
{3.5308855815872668e+00, 1.4621637234313312e-13,
	2.2204460492503131e-16, -1.3034018309099338e-13,
	-3.0664359940146824e-13}, /* L373 */
{3.2834731246155977e+00, 1.3633538742396922e-13,
	2.2204460492503131e-16, 5.8306692807263971e-12,
	6.0407234769854767e-12}, /* L374 */
{3.2087161779091744e+00, 1.3358758543802196e-13,
	2.2204460492503131e-16, 2.7755575615628914e-14,
	-2.6822988274943782e-13}, /* L375 */
{3.0652068713280611e+00, 1.2795320358804929e-13,
	2.2204460492503131e-16, 8.0491169285323849e-13,
	-1.0191847366058937e-13}, /* L376 */
{2.8080672018142567e+00, 1.1753098494438063e-13,
	2.2204460492503131e-16, -9.3147711766050634e-14,
	-6.7834626804597065e-14}, /* L377 */
{2.3955809458579114e+00, 1.0053242960328390e-13,
	2.2204460492503131e-16, 5.6399329650957952e-14,
	-1.4210854715202004e-14}, /* L378 */
{3.7916152337449427e+00, 1.5953904863863499e-13,
	2.2204460492503131e-16, 1.9806378759312793e-13,
	7.9047879353311146e-14}, /* L379 */
{3.4263686591469731e+00, 1.4455103780619538e-13,
	2.2204460492503131e-16, -2.7644553313166398e-14,
	-2.4980018054066022e-14}, /* L380 */
{2.8084422850553752e+00, 1.1879386363489175e-13,
	2.2204460492503131e-16, -7.5495165674510645e-15,
	-4.0523140398818214e-14}, /* L381 */
{2.9503000230005201e+00, 1.2512213487525514e-13,
	2.2204460492503131e-16, -2.6312285683616210e-14,
	6.5503158452884236e-14}, /* L382 */
{2.6947150865654810e+00, 1.1458195503522006e-13,
	2.2204460492503131e-16, -5.0182080713057076e-14,
	-2.3314683517128287e-14}, /* L383 */
{3.1471762115440272e+00, 1.3417045252595017e-13,
	2.2204460492503131e-16, -2.9176661087149114e-13,
	1.4410694859634532e-13}, /* L384 */
{3.0870530025517655e+00, 1.3195000647669985e-13,
	2.2204460492503131e-16, -7.4384942649885488e-15,
	-1.0524914273446484e-13}, /* L385 */
{3.0201168680899886e+00, 1.2942424909567762e-13,
	2.2204460492503131e-16, 4.4497738826976274e-13,
	6.8389738316909643e-13}, /* L386 */
{2.6033929192825904e+00, 1.1185496973098452e-13,
	2.2204460492503131e-16, -7.8159700933611020e-14,
	-2.9753977059954195e-14}, /* L387 */
{2.3428138735867621e+00, 1.0091927293842673e-13,
	2.2204460492503131e-16, -6.0729199446996063e-14,
	5.3290705182007514e-14}, /* L388 */
{3.2172653537863467e+00, 1.3894441153183834e-13,
	2.2204460492503131e-16, -6.1173288656846125e-14,
	-4.5519144009631418e-15}, /* L389 */
{3.0296867078335241e+00, 1.3117978925336615e-13,
	2.2204460492503131e-16, -3.1197266991966899e-14,
	3.4194869158454821e-14}, /* L390 */
{3.0224176943362226e+00, 1.3120060593507787e-13,
	2.2204460492503131e-16, 5.2402526762307389e-14,
	9.1926466438962962e-14}, /* L391 */
{3.4356013734763642e+00, 1.4951798479878597e-13,
	2.2204460492503131e-16, -1.0769163338864018e-14,
	2.1516122217235534e-13}, /* L392 */
{4.1081957456122611e+00, 1.7924550732573152e-13,
	2.2204460492503131e-16, -8.4376949871511897e-15,
	-2.9864999362416711e-14}, /* L393 */
{2.8096810901907747e+00, 1.2290168882600483e-13,
	2.2204460492503131e-16, 1.2789769243681803e-13,
	-1.0513812043200232e-13}, /* L394 */
{4.0789294548925659e+00, 1.7887427650187249e-13,
	2.2204460492503131e-16, -2.6645352591003757e-14,
	9.1038288019262836e-15}, /* L395 */
{2.5404369704987446e+00, 1.1168843627729075e-13,
	2.2204460492503131e-16, -3.9890313274781874e-13,
	2.1183055309847987e-13}, /* L396 */
{3.9142509898791693e+00, 1.7252171913284542e-13,
	2.2204460492503131e-16, -4.2854608750531042e-14,
	-6.5503158452884236e-14}, /* L397 */
{3.6018054819236860e+00, 1.5915047058001619e-13,
	2.2204460492503131e-16, -1.2090328738167955e-13,
	6.9722005946459831e-14}, /* L398 */
{3.0501648506604173e+00, 1.3511414209688155e-13,
	2.2204460492503131e-16, 9.5257135512838431e-14,
	1.6120438317557273e-13}, /* L399 */
{3.1037902324932563e+00, 1.3783418850721318e-13,
	2.2204460492503131e-16, 7.3274719625260332e-15,
	1.0658141036401503e-14}, /* L400 */
{2.9077683649015804e+00, 1.2945200467129325e-13,
	2.2204460492503131e-16, 3.1086244689504383e-15,
	1.6431300764452317e-14}, /* L401 */
{2.7997875356778432e+00, 1.2495560142156137e-13,
	2.2204460492503131e-16, 3.3084646133829665e-14,
	4.2188474935755949e-15}, /* L402 */
{3.3145477446901417e+00, 1.4829804051430528e-13,
	2.2204460492503131e-16, -2.3092638912203256e-14,
	-1.1568523916594131e-13}, /* L403 */
{2.7840612091019641e+00, 1.2487233469471448e-13,
	2.2204460492503131e-16, -1.6764367671839864e-14,
	1.3833378886829450e-13}, /* L404 */
{3.1605239736696809e+00, 1.4210854715202004e-13,
	2.2204460492503131e-16, -2.6978419498391304e-14,
	-9.9920072216264089e-15}, /* L405 */
{3.0129597734580815e+00, 1.3580803148727227e-13,
	2.2204460492503131e-16, -4.8738790781044372e-14,
	2.6867397195928788e-14}, /* L406 */
{2.4189419918830888e+00, 1.0930145677434666e-13,
	2.2204460492503131e-16, 1.3677947663381929e-13,
	5.4622972811557702e-14}, /* L407 */
{3.5331219358110206e+00, 1.6003864899971632e-13,
	2.2204460492503131e-16, 1.1324274851176597e-14,
	-3.5527136788005009e-14}, /* L408 */
{2.8530223234434553e+00, 1.2954914918594795e-13,
	2.2204460492503131e-16, 1.8429702208777599e-14,
	8.1490370007486490e-14}, /* L409 */
{3.8695491046318975e+00, 1.7613688285678109e-13,
	2.2204460492503131e-16, -1.5154544286133387e-13,
	1.0480505352461478e-13}, /* L410 */
{2.9185193223444195e+00, 1.3317125180378753e-13,
	2.2204460492503131e-16, 2.1982415887578100e-14,
	-2.3314683517128287e-14}, /* L411 */
{3.2342541507519655e+00, 1.4793721803130211e-13,
	2.2204460492503131e-16, -8.3155704544424225e-14,
	8.6153306710912148e-14}, /* L412 */
{3.4207348076949251e+00, 1.5684675780391899e-13,
	2.2204460492503131e-16, -8.7707618945387367e-15,
	2.3980817331903381e-14}, /* L413 */
{2.8460416395875563e+00, 1.3081202787645907e-13,
	2.2204460492503131e-16, -1.1868284133242923e-13,
	-8.6708418223224726e-14}, /* L414 */
{2.7798457925364786e+00, 1.2807810367831962e-13,
	2.2204460492503131e-16, -3.2640556923979602e-14,
	9.6367358537463588e-14}, /* L415 */
{2.7470213946415964e+00, 1.2687073613903976e-13,
	2.2204460492503131e-16, -6.2394533983933798e-14,
	-2.5424107263916085e-14}, /* L416 */
{2.6235262234220178e+00, 1.2145839889399213e-13,
	2.2204460492503131e-16, -8.7818641247849882e-14,
	-1.6586731987899839e-13}, /* L417 */
{2.7458395881874389e+00, 1.2742584765135234e-13,
	2.2204460492503131e-16, 3.7547742692822794e-13,
	3.9968028886505635e-14}, /* L418 */
{3.5477665371019338e+00, 1.6503465261052952e-13,
	2.2204460492503131e-16, -2.0539125955565396e-14,
	-2.5646151868841116e-14}, /* L419 */
{4.1205750181967931e+00, 1.9213797219919115e-13,
	2.2204460492503131e-16, 6.1728400169158704e-14,
	4.0190073491430667e-14}, /* L420 */
{3.4008637928984364e+00, 1.5895618155070679e-13,
	2.2204460492503131e-16, -4.8294701571194310e-14,
	-2.2981616609740740e-14}, /* L421 */
{3.8163871133290233e+00, 1.7880141811588146e-13,
	2.2204460492503131e-16, 9.3924867883288243e-14,
	-7.7937656328685989e-14}, /* L422 */
{3.4001506354855526e+00, 1.5967782651671314e-13,
	2.2204460492503131e-16, -1.7641443861293737e-13,
	4.4186876380081230e-14}, /* L423 */
{3.1321053471373599e+00, 1.4743761767022079e-13,
	2.2204460492503131e-16, -2.0161650127192843e-13,
	-1.0125233984581428e-13}, /* L424 */
{3.9518023999635195e+00, 1.8646195698579504e-13,
	2.2204460492503131e-16, 2.8421709430404007e-14,
	-1.1213252548714081e-14}, /* L425 */
{3.3518512203012865e+00, 1.5852597012866454e-13,
	2.2204460492503131e-16, -1.4876988529977098e-14,
	-4.6074255521943996e-14}, /* L426 */
{4.1159643184800112e+00, 1.9512169657787126e-13,
	2.2204460492503131e-16, 3.5971225997855072e-14,
	-8.3155704544424225e-14}, /* L427 */
{3.7219981189256077e+00, 1.7685852782278744e-13,
	2.2204460492503131e-16, 5.3290705182007514e-15,
	-1.6397994073713562e-13}, /* L428 */
{3.4720610900995896e+00, 1.6536771951791707e-13,
	2.2204460492503131e-16, -1.0251799409388695e-12,
	-1.5043521983670871e-13}, /* L429 */
{2.9471211342319137e+00, 1.4069301279562296e-13,
	2.2204460492503131e-16, -1.3877787807814457e-14,
	7.5273121069585613e-14}, /* L430 */
{2.8074513726880035e+00, 1.3433698597964394e-13,
	2.2204460492503131e-16, 2.9909408283401717e-12,
	2.9931612743894220e-12}, /* L431 */
{3.4016528168757301e+00, 1.6314727346866675e-13,
	2.2204460492503131e-16, 4.0190073491430667e-14,
	-1.1435297153639112e-14}, /* L432 */
{3.2355966824424964e+00, 1.5554224574998443e-13,
	2.2204460492503131e-16, 4.2010839251815923e-13,
	-2.5479618415147343e-13}, /* L433 */
{3.3554467523147924e+00, 1.6167622796103842e-13,
	2.2204460492503131e-16, -3.4083846855992306e-14,
	-1.8318679906315083e-14}, /* L434 */
{3.5448613987000157e+00, 1.7119639039719914e-13,
	2.2204460492503131e-16, 7.7271522513910895e-14,
	-6.8833827526759706e-14}, /* L435 */
{3.7787057677774731e+00, 1.8290924330699454e-13,
	2.2204460492503131e-16, -1.4244161405940758e-13,
	-1.6431300764452317e-14}, /* L436 */
{2.9176479671478339e+00, 1.4155343563970746e-13,
	2.2204460492503131e-16, 4.5297099404706387e-14,
	1.0436096431476471e-14}, /* L437 */
{3.0650977294400357e+00, 1.4904744105592727e-13,
	2.2204460492503131e-16, 2.6245672302138701e-13,
	1.1257661469699087e-13}, /* L438 */
{3.3363074496354850e+00, 1.6260603974416199e-13,
	2.2204460492503131e-16, -1.8873791418627661e-14,
	1.4432899320127035e-14}, /* L439 */
{3.5079880062308026e+00, 1.7136292385089291e-13,
	2.2204460492503131e-16, 3.4261482539932331e-13,
	-6.2172489379008766e-15}, /* L440 */
{4.0845060800503443e+00, 1.9997892231060632e-13,
	2.2204460492503131e-16, -5.0515147620444623e-14,
	9.9698027611339057e-14}, /* L441 */
{3.3948287615052553e+00, 1.6658896484500474e-13,
	2.2204460492503131e-16, -2.1982415887578100e-14,
	2.2870594307278225e-14}, /* L442 */
{3.2754262763595272e+00, 1.6109336087311021e-13,
	2.2204460492503131e-16, -3.4416913763379853e-15,
	-5.1958437552457326e-14}, /* L443 */
{2.9069815569300879e+00, 1.4329509800958817e-13,
	2.2204460492503131e-16, -3.6082248300317588e-14,
	1.3788969965844444e-13}, /* L444 */
{2.7831726145768565e+00, 1.3750112159982564e-13,
	2.2204460492503131e-16, -6.0174087934683484e-14,
	-6.1173288656846125e-14}, /* L445 */
{4.1408746993324366e+00, 2.0503737596655469e-13,
	2.2204460492503131e-16, -4.1633363423443370e-14,
	-8.5043083686286991e-14}, /* L446 */
{3.5342898637817606e+00, 1.7539442120906301e-13,
	2.2204460492503131e-16, 3.2418512319054571e-13,
	-3.8113956435381624e-13}, /* L447 */
{3.0669935400880073e+00, 1.5254464358349651e-13,
	2.2204460492503131e-16, -2.0095036745715333e-14,
	2.5535129566378600e-14}, /* L448 */
{3.4465807592355593e+00, 1.7180701306074297e-13,
	2.2204460492503131e-16, 8.0158102377936302e-14,
	1.1635137298071641e-13}, /* L449 */
{3.7383689915903049e+00, 1.8676726831756696e-13,
	2.2204460492503131e-16, 2.1316282072803006e-14,
	5.5733195836182858e-14}, /* L450 */
{2.5964770945342641e+00, 1.3000711618360583e-13,
	2.2204460492503131e-16, -6.3504757008558954e-14,
	1.0436096431476471e-14}, /* L451 */
{3.2686982137223382e+00, 1.6402851299446297e-13,
	2.2204460492503131e-16, -6.3171690101171407e-14,
	7.3496764230185363e-14}, /* L452 */
{3.1611780556178743e+00, 1.5898393712632242e-13,
	2.2204460492503131e-16, 3.5527136788005009e-14,
	-1.3988810110276972e-14}, /* L453 */
{3.5870386200857056e+00, 1.8079981956020674e-13,
	2.2204460492503131e-16, -1.1768364061026659e-14,
	-5.5733195836182858e-14}, /* L454 */
{4.3005904715297234e+00, 2.1724289034352751e-13,
	2.2204460492503131e-16, 8.2156503822261584e-15,
	-8.9594998087250133e-14}, /* L455 */
{2.9528790430907952e+00, 1.4949153026577733e-13,
	2.2204460492503131e-16, -7.2719608112947753e-14,
	-5.9396931817445875e-14}, /* L456 */
{3.6603193776794329e+00, 1.8571255644417306e-13,
	2.2204460492503131e-16, -7.6605388699135801e-15,
	3.4194869158454821e-14}, /* L457 */
{4.7243900415343143e+00, 2.4022450695326825e-13,
	2.2204460492503131e-16, -1.3855583347321954e-13,
	-1.5176748746625890e-13}, /* L458 */
{3.5926268606948866e+00, 1.8307577676068831e-13,
	2.2204460492503131e-16, -2.7644553313166398e-14,
	3.7969627442180354e-14}, /* L459 */
{4.4978689896627992e+00, 2.2970514379494489e-13,
	2.2204460492503131e-16, -3.0420110874729289e-13,
	5.8086868648388190e-13}, /* L460 */
{2.7896144611003399e+00, 1.4277468096679513e-13,
	2.2204460492503131e-16, 6.4392935428259079e-14,
	2.8199664825478976e-14}, /* L461 */
{2.6002683090286216e+00, 1.3337247972700084e-13,
	2.2204460492503131e-16, -5.7287508070658077e-14,
	-2.5490720645393594e-13}, /* L462 */
{4.2818982940877479e+00, 2.2010171463193728e-13,
	2.2204460492503131e-16, 1.0658141036401503e-13,
	4.6629367034256575e-15}, /* L463 */
{2.6984362992440358e+00, 1.3900686157697351e-13,
	2.2204460492503131e-16, -9.1393559387142886e-13,
	-8.1934459217336553e-13}, /* L464 */
{2.8634681732717886e+00, 1.4782619572883959e-13,
	2.2204460492503131e-16, -2.4424906541753444e-15,
	1.3322676295501878e-14}, /* L465 */
{4.2065851886922889e+00, 2.1763146840214631e-13,
	2.2204460492503131e-16, 5.8841820305133297e-14,
	1.2656542480726785e-14}, /* L466 */
{3.8931045860150277e+00, 2.0184548477075737e-13,
	2.2204460492503131e-16, 7.0610184366159956e-14,
	-5.3845816694320092e-14}, /* L467 */
{4.0983296900140092e+00, 2.1294077612310502e-13,
	2.2204460492503131e-16, -1.8496315590255108e-13,
	1.6742163211347361e-13}, /* L468 */
{2.7106655976936054e+00, 1.4114154723438022e-13,
	2.2204460492503131e-16, 1.1612932837579137e-13,
	2.9753977059954195e-14}, /* L469 */
{2.8872615825615484e+00, 1.5065726444163374e-13,
	2.2204460492503131e-16, -5.6954441163270531e-14,
	1.2612133559741778e-13}, /* L470 */
{4.3949463795672923e+00, 2.2981616609740740e-13,
	2.2204460492503131e-16, 1.5809575870662229e-12,
	-6.8556271770603416e-13}, /* L471 */
{3.3652333703068122e+00, 1.7634504967389830e-13,
	2.2204460492503131e-16, -2.0983215165415459e-14,
	-9.9920072216264089e-16}, /* L472 */
{3.1363935527024820e+00, 1.6470158570314197e-13,
	2.2204460492503131e-16, -4.2832404290038539e-13,
	2.5934809855243657e-13}, /* L473 */
{3.5095271463458029e+00, 1.8468560014639479e-13,
	2.2204460492503131e-16, 3.4194869158454821e-14,
	3.3084646133829665e-14}, /* L474 */
{3.1543064029916388e+00, 1.6634263411141603e-13,
	2.2204460492503131e-16, -1.1335377081422848e-13,
	-1.5565326805244695e-13}, /* L475 */
{3.2379510530979623e+00, 1.7111312367035225e-13,
	2.2204460492503131e-16, 7.8581585682968580e-13,
	-1.4657164371101317e-12}, /* L476 */
{3.4748759122362918e+00, 1.8401946633161970e-13,
	2.2204460492503131e-16, 3.9745984281580604e-14,
	5.0626169922907138e-14}, /* L477 */
{3.3938608240648978e+00, 1.8010593016981602e-13,
	2.2204460492503131e-16, -2.4757973449140991e-14,
	-1.3988810110276972e-14}, /* L478 */
{2.8485396967577867e+00, 1.5148299281619870e-13,
	2.2204460492503131e-16, -7.2719608112947753e-14,
	-4.6851411639181606e-14}, /* L479 */
{3.2906563877714197e+00, 1.7535972673954348e-13,
	2.2204460492503131e-16, -2.6090241078691179e-14,
	4.2188474935755949e-14}, /* L480 */
{4.2973382872557266e+00, 2.2948309919001986e-13,
	2.2204460492503131e-16, 2.1738166822160565e-13,
	-1.9984014443252818e-13}, /* L481 */
{4.7407091194431139e+00, 2.5368596112684827e-13,
	2.2204460492503131e-16, -1.7585932710062480e-13,
	-2.2382096176443156e-13}, /* L482 */
{3.9701465647087679e+00, 2.1289220386577767e-13,
	2.2204460492503131e-16, -2.5535129566378600e-14,
	-1.5099033134902129e-14}, /* L483 */
{4.2218894438472043e+00, 2.2686019729434292e-13,
	2.2204460492503131e-16, -9.9698027611339057e-14,
	-6.6280314570121845e-14}, /* L484 */
{4.2856078883776236e+00, 2.3075985566833879e-13,
	2.2204460492503131e-16, 2.6645352591003757e-15,
	5.2180482157382357e-14}, /* L485 */
{5.0041629583105456e+00, 2.7000623958883807e-13,
	2.2204460492503131e-16, -3.5638159090467525e-14,
	1.1102230246251565e-15}, /* L486 */
{3.9761672899342675e+00, 2.1498081093085375e-13,
	2.2204460492503131e-16, 3.6415315207705135e-14,
	1.3988810110276972e-14}, /* L487 */
{3.5481895819436158e+00, 1.9223511671384585e-13,
	2.2204460492503131e-16, 2.0228263508670352e-13,
	-2.6578739209526248e-13}, /* L488 */
{3.8568875044854569e+00, 2.0938806244430452e-13,
	2.2204460492503131e-16, 1.7164047960704920e-13,
	2.6689761511988763e-13}, /* L489 */
{3.4296245500450815e+00, 1.8657297928825756e-13,
	2.2204460492503131e-16, 3.0020430585864233e-13,
	3.8746783559417963e-13}, /* L490 */
{3.9857813990434323e+00, 2.1727064591914313e-13,
	2.2204460492503131e-16, 9.9920072216264089e-15,
	-4.0634162701280729e-14}, /* L491 */
{3.5584689016346811e+00, 1.9437229603624928e-13,
	2.2204460492503131e-16, 5.7531757136075612e-13,
	-2.8688162956314045e-13}, /* L492 */
{4.4315838526046063e+00, 2.4255597530498108e-13,
	2.2204460492503131e-16, -3.0531133177191805e-14,
	4.2188474935755949e-14}, /* L493 */
{4.0223055730475217e+00, 2.2060131499301860e-13,
	2.2204460492503131e-16, -1.9417800700693988e-13,
	1.8274270985330077e-13}, /* L494 */
{4.2937278242070258e+00, 2.3596402609626921e-13,
	2.2204460492503131e-16, 4.1966430330830917e-14,
	-5.9063864910058328e-14}, /* L495 */
{3.7994314019880351e+00, 2.0922152899061075e-13,
	2.2204460492503131e-16, 1.1990408665951691e-14,
	3.5305092183079978e-14}, /* L496 */
{3.9527540009447519e+00, 2.1810331318761200e-13,
	2.2204460492503131e-16, -6.8833827526759706e-14,
	2.2204460492503131e-16}, /* L497 */
{3.7806585515930990e+00, 2.0902723996130135e-13,
	2.2204460492503131e-16, -9.9809049913801573e-14,
	-4.4408920985006262e-15}, /* L498 */
{4.0491368188907284e+00, 2.2432056212551288e-13,
	2.2204460492503131e-16, 4.1522341120980855e-14,
	1.7097434579227411e-14}, /* L499 */
{3.6490348061458717e+00, 2.0256019084285981e-13,
	2.2204460492503131e-16, -1.2634338020234281e-13,
	9.2814644858663087e-14}, /* L500 */
{3.7470417290047706e+00, 2.0841661729775751e-13,
	2.2204460492503131e-16, -1.8318679906315083e-13,
	1.1390888232654106e-13}, /* L501 */
{3.7627350938529784e+00, 2.0970725156388426e-13,
	2.2204460492503131e-16, 5.3290705182007514e-14,
	5.1114668053742207e-13}, /* L502 */
{3.8201159608551989e+00, 2.1332935418172383e-13,
	2.2204460492503131e-16, -4.3942627314663696e-13,
	-1.6875389974302379e-14}, /* L503 */
{3.1032042029420688e+00, 1.7363888105137448e-13,
	2.2204460492503131e-16, 2.8865798640254070e-15,
	1.9984014443252818e-14}, /* L504 */
{3.4349337540531777e+00, 1.9258206140904122e-13,
	2.2204460492503131e-16, 2.4646951146678475e-14,
	7.4384942649885488e-14}, /* L505 */
{4.4323545307677756e+00, 2.4899526884780698e-13,
	2.2204460492503131e-16, -4.5885517607757720e-13,
	-2.7644553313166398e-14}, /* L506 */
{3.6381017630030588e+00, 2.0478063689211012e-13,
	2.2204460492503131e-16, 7.0832228971084987e-13,
	3.2152058793144533e-13}, /* L507 */
{4.3248444019275958e+00, 2.4391599851014689e-13,
	2.2204460492503131e-16, 1.1368683772161603e-13,
	-4.7928327973068008e-13}, /* L508 */
{3.7426683122308577e+00, 2.1149748619109232e-13,
	2.2204460492503131e-16, 1.0769163338864018e-13,
	-1.8007817459420039e-13}, /* L509 */
{4.0175628311364857e+00, 2.2747775885179067e-13,
	2.2204460492503131e-16, 2.7289281945286348e-13,
	2.2204460492503131e-14}, /* L510 */
{3.9584526303127823e+00, 2.2457036230605354e-13,
	2.2204460492503131e-16, 1.5321077739827160e-14,
	3.8191672047105385e-14}, /* L511 */
{3.4482750787088032e+00, 1.9600987499757139e-13,
	2.2204460492503131e-16, -1.0569323194431490e-13,
	3.0486724256206799e-13}, /* L512 */
{3.6130948921851922e+00, 2.0577983761427276e-13,
	2.2204460492503131e-16, 4.8183679268731794e-14,
	-7.0832228971084987e-14}, /* L513 */
{4.5914834843654369e+00, 2.6201263381153694e-13,
	2.2204460492503131e-16, 1.1102230246251565e-14,
	-6.6613381477509392e-14}, /* L514 */
{3.7922691820898811e+00, 2.1682655670929307e-13,
	2.2204460492503131e-16, 2.4424906541753444e-14,
	-1.8762769116165146e-14}, /* L515 */
{4.7948616270350248e+00, 2.7468305408007154e-13,
	2.2204460492503131e-16, -5.1958437552457326e-14,
	-2.2204460492503131e-16}, /* L516 */
{3.3007789020518277e+00, 1.8945955915228296e-13,
	2.2204460492503131e-16, 5.1070259132757201e-15,
	6.1950444774083735e-14}, /* L517 */
{3.5608164287359032e+00, 2.0478063689211012e-13,
	2.2204460492503131e-16, 2.2604140781368187e-13,
	1.3322676295501878e-15}, /* L518 */
{4.2230317108763122e+00, 2.4333313142221868e-13,
	2.2204460492503131e-16, 4.6185277824406512e-14,
	-2.9976021664879227e-15}, /* L519 */
{4.2031316313108409e+00, 2.4265311981963578e-13,
	2.2204460492503131e-16, 2.1094237467877974e-14,
	1.0014211682118912e-13}, /* L520 */
{4.0969354464748733e+00, 2.3697710460623966e-13,
	2.2204460492503131e-16, -6.6946448384896939e-13,
	2.5091040356528538e-13}, /* L521 */
{3.2538365512224146e+00, 1.8857138073258284e-13,
	2.2204460492503131e-16, -3.3395508580724709e-13,
	-2.6123547769429933e-13}, /* L522 */
{4.0798343526533376e+00, 2.3689383787939278e-13,
	2.2204460492503131e-16, 2.2870594307278225e-13,
	3.1419311596891930e-13}, /* L523 */
{4.2576403050934264e+00, 2.4769075679387242e-13,
	2.2204460492503131e-16, 2.5801583092288638e-13,
	-1.1635137298071641e-13}, /* L524 */
{3.6419105077699592e+00, 2.1227464230832993e-13,
	2.2204460492503131e-16, -3.4761082901013651e-13,
	-2.5857094243519896e-13}, /* L525 */
{3.8193976608706248e+00, 2.2304380564719395e-13,
	2.2204460492503131e-16, -8.4598994476436928e-14,
	-1.2767564783189300e-14}, /* L526 */
{3.7707602185948801e+00, 2.2062213167473033e-13,
	2.2204460492503131e-16, -5.6010751592339147e-13,
	-3.4594549447319878e-13}, /* L527 */
{2.6875042400933435e+00, 1.5754064719430971e-13,
	2.2204460492503131e-16, -1.3000711618360583e-13,
	-1.3233858453531866e-13}, /* L528 */
{3.4248636264941545e+00, 2.0114465648646274e-13,
	2.2204460492503131e-16, 1.1990408665951691e-14,
	1.6808776592824870e-13}, /* L529 */
{4.7217055626738080e+00, 2.7783331191244542e-13,
	2.2204460492503131e-16, 2.6112445539183682e-13,
	4.9049653227939416e-13}, /* L530 */
{3.9180852776255568e+00, 2.3098190027326382e-13,
	2.2204460492503131e-16, 1.9537704787353505e-12,
	1.4488410471358293e-12}, /* L531 */
{4.4924882908376471e+00, 2.6534330288541241e-13,
	2.2204460492503131e-16, 2.8865798640254070e-14,
	-2.1316282072803006e-14}, /* L532 */
{4.1414523595111215e+00, 2.4506958962167147e-13,
	2.2204460492503131e-16, -5.2724491439448684e-13,
	-1.3111733920823099e-13}, /* L533 */
{4.1638642472613547e+00, 2.4685808952540356e-13,
	2.2204460492503131e-16, 5.0404125317982107e-14,
	-1.0758061108617767e-13}, /* L534 */
{4.0196325100246018e+00, 2.3875346144563991e-13,
	2.2204460492503131e-16, 3.1397107136399427e-13,
	4.7517545453956700e-14}, /* L535 */
{3.3936620706212892e+00, 2.0194956817931597e-13,
	2.2204460492503131e-16, 5.3290705182007514e-15,
	-2.0095036745715333e-14}, /* L536 */
{5.1992633239527803e+00, 3.0997426847534371e-13,
	2.2204460492503131e-16, -3.4372504842394846e-13,
	4.6740389336719090e-13}, /* L537 */
{4.0845789349757995e+00, 2.4397150966137815e-13,
	2.2204460492503131e-16, 1.7985612998927536e-14,
	-8.0602191587786365e-14}, /* L538 */
{4.2013053297279059e+00, 2.5141000392636670e-13,
	2.2204460492503131e-16, 1.9317880628477724e-14,
	-2.8643754035329039e-14}, /* L539 */
{2.8611156251133827e+00, 1.7152945730458669e-13,
	2.2204460492503131e-16, 7.2164496600635175e-14,
	2.8643754035329039e-14}, /* L540 */
{3.7865124435089976e+00, 2.2742918659446332e-13,
	2.2204460492503131e-16, 4.6629367034256575e-15,
	5.9952043329758453e-15}, /* L541 */
{3.8708548155620677e+00, 2.3292479056635784e-13,
	2.2204460492503131e-16, -1.6209256159527285e-14,
	-2.4980018054066022e-14}, /* L542 */
{4.0577872491350524e+00, 2.4462376568834543e-13,
	2.2204460492503131e-16, 8.3577589293781784e-13,
	-8.9217522258877580e-13}, /* L543 */
{4.6378749642641965e+00, 2.8010926911292700e-13,
	2.2204460492503131e-16, 5.8997251528580819e-13,
	-3.4339198151656092e-13}, /* L544 */
{4.3266123307146982e+00, 2.6179058920661191e-13,
	2.2204460492503131e-16, -1.3322676295501878e-14,
	4.9960036108132044e-14}, /* L545 */
{3.5796759773510858e+00, 2.1699309016298685e-13,
	2.2204460492503131e-16, 4.3298697960381105e-14,
	5.5733195836182858e-14}, /* L546 */
{5.1325492311101639e+00, 3.1169511416351270e-13,
	2.2204460492503131e-16, 4.2810199829546036e-13,
	1.1435297153639112e-13}, /* L547 */
{3.7408818144226443e+00, 2.2759572004815709e-13,
	2.2204460492503131e-16, -1.2267964422107980e-13,
	3.4283687000424834e-13}, /* L548 */
{4.3528074139020729e+00, 2.6530860841589288e-13,
	2.2204460492503131e-16, 1.7474910407599964e-13,
	-2.0217161278424101e-13}, /* L549 */
{4.9263714087347372e+00, 3.0081492852218616e-13,
	2.2204460492503131e-16, 1.0147438445073931e-13,
	1.1568523916594131e-13}, /* L550 */
{3.6824014540338030e+00, 2.2526425169644426e-13,
	2.2204460492503131e-16, -6.3504757008558954e-14,
	7.6827433304060833e-14}, /* L551 */
{4.2056225772699012e+00, 2.5773827516673009e-13,
	2.2204460492503131e-16, -4.9849013805669529e-14,
	5.9952043329758453e-14}, /* L552 */
{3.5741466877700083e+00, 2.1943558081716219e-13,
	2.2204460492503131e-16, -4.3376413572104866e-13,
	-5.0648374383399641e-13}, /* L553 */
{5.1525352050029385e+00, 3.1691316237925093e-13,
	2.2204460492503131e-16, -5.5511151231257827e-16,
	-6.6280314570121845e-14}, /* L554 */
{3.6936995212701897e+00, 2.2759572004815709e-13,
	2.2204460492503131e-16, -4.0301095793893182e-14,
	3.3528735343679728e-14}, /* L555 */
{4.3682622875204240e+00, 2.6964541710583489e-13,
	2.2204460492503131e-16, 4.7073456244106637e-14,
	-6.9722005946459831e-14}, /* L556 */
{4.1059310740014645e+00, 2.5390800573177330e-13,
	2.2204460492503131e-16, 3.6637359812630166e-13,
	-4.4975134727565091e-13}, /* L557 */
{4.7016203209999583e+00, 2.9126701051040982e-13,
	2.2204460492503131e-16, 2.6534330288541241e-13,
	-2.7255975254547593e-13}, /* L558 */
{5.0485600671172648e+00, 3.1332055006050297e-13,
	2.2204460492503131e-16, 8.1490370007486490e-14,
	-4.2521541843143495e-14}, /* L559 */
{3.5267912785288869e+00, 2.1926904736346842e-13,
	2.2204460492503131e-16, -2.1027624086400465e-13,
	-2.7866597918091429e-14}, /* L560 */
{4.4986701991871820e+00, 2.8019253583977388e-13,
	2.2204460492503131e-16, 1.1679546219056647e-13,
	-1.6986412276764895e-13}, /* L561 */
{3.5315892017067032e+00, 2.2035151481247794e-13,
	2.2204460492503131e-16, -1.1635137298071641e-13,
	1.9340085088970227e-13}, /* L562 */
{4.0519602116335465e+00, 2.5326962749261384e-13,
	2.2204460492503131e-16, 4.1300296516055823e-14,
	-2.0428103653102880e-14}, /* L563 */
{4.5077365001846319e+00, 2.8225859149966226e-13,
	2.2204460492503131e-16, -1.2645440250480533e-13,
	-1.5198953207118393e-13}, /* L564 */
{4.5657151679584773e+00, 2.8639590698986694e-13,
	2.2204460492503131e-16, -1.3622436512150671e-13,
	-3.3761882178851010e-13}, /* L565 */
{3.4682033516461410e+00, 2.1793677973391823e-13,
	2.2204460492503131e-16, -1.9362289549462730e-13,
	-6.3016258877723885e-13}, /* L566 */
{3.6383434827446650e+00, 2.2903207108626589e-13,
	2.2204460492503131e-16, 3.8857805861880479e-14,
	2.6201263381153694e-14}, /* L567 */
{3.3292306046620355e+00, 2.0994317395661710e-13,
	2.2204460492503131e-16, 1.2767564783189300e-13,
	1.7719159473017498e-13}, /* L568 */
{4.2987765537377243e+00, 2.7156055182331329e-13,
	2.2204460492503131e-16, -1.6486811915683575e-13,
	8.9706020389712648e-14}, /* L569 */
{3.9824624235088586e+00, 2.5202062658991053e-13,
	2.2204460492503131e-16, -1.8862689188381410e-13,
	-9.1038288019262836e-15}, /* L570 */
{4.6795170151308154e+00, 2.9665159217984183e-13,
	2.2204460492503131e-16, -1.6298074001497298e-13,
	-1.6020518245341009e-13}, /* L571 */
{4.3138179947530322e+00, 2.7394753132625738e-13,
	2.2204460492503131e-16, 1.3322676295501878e-14,
	5.2846615972157451e-14}, /* L572 */
{4.7460807863420671e+00, 3.0192515154681132e-13,
	2.2204460492503131e-16, 1.2829737272568309e-12,
	2.4802382370125997e-13}, /* L573 */
{3.8571489425866452e+00, 2.4580337765200966e-13,
	2.2204460492503131e-16, -3.1641356201816961e-14,
	-4.1466829969749597e-13}, /* L574 */
{4.0264737439010414e+00, 2.5704091632938741e-13,
	2.2204460492503131e-16, 6.9944050551384862e-14,
	3.2196467714129540e-14}, /* L575 */
{4.9314313914632564e+00, 3.1535885014477572e-13,
	2.2204460492503131e-16, -2.9420910152566648e-14,
	-6.5503158452884236e-15}, /* L576 */
{3.8318951270626589e+00, 2.4547031074462211e-13,
	2.2204460492503131e-16, -1.3611334281904419e-13,
	-2.6900703886667543e-13}, /* L577 */
{4.6911838718611856e+00, 3.0103697312711120e-13,
	2.2204460492503131e-16, 2.5763835509451383e-12,
	1.4515055823949297e-12}, /* L578 */
{4.9956900924434926e+00, 3.2113200987282653e-13,
	2.2204460492503131e-16, -5.8508753397745750e-14,
	-7.5384143372048129e-14}, /* L579 */
{3.4931089593791089e+00, 2.2493118478905672e-13,
	2.2204460492503131e-16, 1.2168044349891716e-13,
	-1.8984813721090177e-14}, /* L580 */
{4.2082682573108157e+00, 2.7144952952085077e-13,
	2.2204460492503131e-16, 2.7355895326763857e-13,
	-3.6737279884846430e-13}, /* L581 */
{4.7281002430629755e+00, 3.0550562080122745e-13,
	2.2204460492503131e-16, -3.5527136788005009e-15,
	9.5479180117763462e-15}, /* L582 */
{4.1320819909077322e+00, 2.6745272663220021e-13,
	2.2204460492503131e-16, -6.5503158452884236e-13,
	-4.9871218266162032e-13}, /* L583 */
{4.4422159126112470e+00, 2.8801960816338124e-13,
	2.2204460492503131e-16, 7.9625195326116227e-13,
	1.3131717935266352e-12}, /* L584 */
{4.9991531863442376e+00, 3.2468472355162703e-13,
	2.2204460492503131e-16, -4.0079051188968151e-14,
	9.6811447747313650e-14}, /* L585 */
{5.7367837949917355e+00, 3.7322922530336200e-13,
	2.2204460492503131e-16, 1.8629542353210127e-13,
	-1.7652546091539989e-14}, /* L586 */
{4.6771794405476221e+00, 3.0481173141083673e-13,
	2.2204460492503131e-16, 6.8833827526759706e-15,
	5.2180482157382357e-14}, /* L587 */
{4.8469464225722128e+00, 3.1641356201816961e-13,
	2.2204460492503131e-16, 2.7755575615628914e-14,
	2.4202861936828413e-14}, /* L588 */
{3.7822640318199698e+00, 2.4732993431086925e-13,
	2.2204460492503131e-16, 3.7081449022480228e-13,
	-4.4630965589931293e-14}, /* L589 */
{4.7262786431246555e+00, 3.0958569041672490e-13,
	2.2204460492503131e-16, -5.7176485768195562e-14,
	2.2426505097428162e-14}, /* L590 */
{5.2368948951128393e+00, 3.4361402612148595e-13,
	2.2204460492503131e-16, -3.9968028886505635e-15,
	-2.6534330288541241e-14}, /* L591 */
{5.3674071168447686e+00, 3.5277336607464349e-13,
	2.2204460492503131e-16, 1.2878587085651816e-14,
	5.5733195836182858e-14}, /* L592 */
{3.8265237437090223e+00, 2.5192348207525583e-13,
	2.2204460492503131e-16, -8.8151708155237429e-14,
	7.3274719625260332e-14}, /* L593 */
{4.3501752134710729e+00, 2.8688162956314045e-13,
	2.2204460492503131e-16, -4.9626969200744497e-14,
	-4.8849813083506888e-15}, /* L594 */
{4.7840411612590721e+00, 3.1602498395955081e-13,
	2.2204460492503131e-16, 1.8363088827300089e-13,
	2.8155255904493970e-13}, /* L595 */
{5.3028607153457576e+00, 3.5088598693278072e-13,
	2.2204460492503131e-16, 3.6237679523765109e-13,
	-6.1373128801278654e-13}, /* L596 */
{4.3157522026187944e+00, 2.8604896229467158e-13,
	2.2204460492503131e-16, 1.0604850331219495e-12,
	4.8694381860059366e-13}, /* L597 */
{4.9682352631687854e+00, 3.2984726061613401e-13,
	2.2204460492503131e-16, -8.7041485130612273e-14,
	1.7741363933510002e-13}, /* L598 */
{3.8572681891448370e+00, 2.5651702983964242e-13,
	2.2204460492503131e-16, 1.7985612998927536e-14,
	1.8363088827300089e-13}, /* L599 */
{4.7225074506925866e+00, 3.1458169402753811e-13,
	2.2204460492503131e-16, 3.7112535267169733e-12,
	4.2388315080188477e-13}, /* L600 */
{6.0170644016469739e+00, 4.0148440128007223e-13,
	2.2204460492503131e-16, -1.2723155862204294e-13,
	3.3750779948604759e-14}, /* L601 */
{4.7383795687956880e+00, 3.1669111777432590e-13,
	2.2204460492503131e-16, 5.6177285046032921e-14,
	-5.5966342671354141e-13}, /* L602 */
{3.2073019091364419e+00, 2.1471713296250527e-13,
	2.2204460492503131e-16, 3.5791369867865797e-12,
	-8.1187279121763822e-12}, /* L603 */
{3.9147412756285060e+00, 2.6251223417261826e-13,
	2.2204460492503131e-16, 2.5721647034515627e-12,
	-1.8585133432225120e-13}, /* L604 */
{4.1876099126076411e+00, 2.8127500328878341e-13,
	2.2204460492503131e-16, -1.4432899320127035e-14,
	-6.4614980033184111e-14}, /* L605 */
{4.1939010061472404e+00, 2.8216318170848353e-13,
	2.2204460492503131e-16, -3.3536506904852104e-12,
	2.5079938126282286e-12}, /* L606 */
{3.9674691919587990e+00, 2.6736945990535332e-13,
	2.2204460492503131e-16, 3.9301895071730542e-14,
	1.9317880628477724e-14}, /* L607 */
{4.1801052791859110e+00, 2.8216318170848353e-13,
	2.2204460492503131e-16, 9.3258734068513149e-14,
	-1.9706458687096529e-13}, /* L608 */
{5.1695483859186648e+00, 3.4952596372761491e-13,
	2.2204460492503131e-16, -2.4091839634365897e-14,
	8.6153306710912148e-14}, /* L609 */
{4.3811544531626838e+00, 2.9670710333107309e-13,
	2.2204460492503131e-16, 7.1720407390785113e-14,
	3.1530333899354446e-14}, /* L610 */
{5.0167836924298115e+00, 3.4031111262322611e-13,
	2.2204460492503131e-16, 2.2204460492503131e-14,
	-9.7033492352238682e-14}, /* L611 */
{3.3041310299420852e+00, 2.2450097336701447e-13,
	2.2204460492503131e-16, -3.5094149808401198e-13,
	-4.4964032497318840e-14}, /* L612 */
{4.9983765645898623e+00, 3.4017233474514796e-13,
	2.2204460492503131e-16, -1.8591794770372871e-12,
	-1.6487922138708200e-12}, /* L613 */
{5.8326639253624437e+00, 3.9759862069388419e-13,
	2.2204460492503131e-16, -9.7477581562088744e-14,
	8.2822637637036678e-14}, /* L614 */
{8.5264362164440506e+00, 5.8217319853781646e-13,
	2.2204460492503131e-16, 3.6814995496570191e-13,
	-1.6675549829869851e-13}, /* L615 */
{4.6903483090863878e+00, 3.2077118738982335e-13,
	2.2204460492503131e-16, -1.9961809982760315e-13,
	-1.4588330543574557e-13}, /* L616 */
{5.5998872790648981e+00, 3.8359593279579940e-13,
	2.2204460492503131e-16, 3.5571545708990016e-13,
	9.1260332624187868e-14}, /* L617 */
{4.4508565367102459e+00, 3.0538072071095712e-13,
	2.2204460492503131e-16, 1.2878587085651816e-14,
	-2.4091839634365897e-13}, /* L618 */
{5.7932240026869808e+00, 3.9812597663058114e-13,
	2.2204460492503131e-16, -2.3936408410918375e-13,
	-2.9509727994536661e-13}, /* L619 */
{4.2258131187057746e+00, 2.9087843245179101e-13,
	2.2204460492503131e-16, 3.5638159090467525e-13,
	5.8286708792820718e-13}, /* L620 */
{4.2014080979914290e+00, 2.8966499338034524e-13,
	2.2204460492503131e-16, 4.5674575233078940e-13,
	4.3054448894963571e-13}, /* L621 */
{4.2445806504467534e+00, 2.9311275628884914e-13,
	2.2204460492503131e-16, 8.3488327362601922e-11,
	-7.2851724652878147e-11}, /* L622 */
{3.7664585908304860e+00, 2.6051383272829298e-13,
	2.2204460492503131e-16, 1.7421619702417956e-12,
	-9.0294438592763981e-13}, /* L623 */
{5.1935178092343115e+00, 3.5979552670539761e-13,
	2.2204460492503131e-16, -4.7961634663806763e-14,
	-1.6853185513809876e-13}, /* L624 */
{5.9548093949449319e+00, 4.1319725418986764e-13,
	2.2204460492503131e-16, -8.9928064994637680e-15,
	-6.3282712403633923e-14}, /* L625 */
{5.1094329813164139e+00, 3.5510483442635632e-13,
	2.2204460492503131e-16, -7.5384143372048129e-14,
	2.1094237467877974e-14}, /* L626 */
{4.4709001957007031e+00, 3.1122326937804701e-13,
	2.2204460492503131e-16, 3.2374103398069565e-13,
	-4.0412118096355698e-14}, /* L627 */
{3.8051413537108512e+00, 2.6530166952198897e-13,
	2.2204460492503131e-16, -2.6756374893466273e-14,
	6.6791017161449417e-13}, /* L628 */
{6.0685707826870976e+00, 4.2378600628723007e-13,
	2.2204460492503131e-16, -2.2093438190040615e-14,
	5.3290705182007514e-14}, /* L629 */
{5.2039268610432954e+00, 3.6398314917640562e-13,
	2.2204460492503131e-16, 1.1985967773853190e-12,
	8.3244522386394237e-13}, /* L630 */
{5.4496916408061979e+00, 3.8177794259297571e-13,
	2.2204460492503131e-16, -3.4527936065842368e-14,
	-7.8603790143461083e-14}, /* L631 */
{5.2257796055009651e+00, 3.6667197056416967e-13,
	2.2204460492503131e-16, -9.1382457156896635e-13,
	7.5939254884360707e-14}, /* L632 */
{4.9431357609062028e+00, 3.4738878440521148e-13,
	2.2204460492503131e-16, -4.5186077102243871e-14,
	8.8817841970012523e-16}, /* L633 */
{5.2634152441824300e+00, 3.7048142331741474e-13,
	2.2204460492503131e-16, 2.8221869285971479e-13,
	2.2826185386293218e-13}, /* L634 */
{4.6795349419897887e+00, 3.2990277176736527e-13,
	2.2204460492503131e-16, 7.0832228971084987e-14,
	-2.5746071941057380e-13}, /* L635 */
{4.5522870563855422e+00, 3.2143732120459845e-13,
	2.2204460492503131e-16, -3.0486724256206799e-13,
	1.7519319328584970e-13}, /* L636 */
{4.5659412696495645e+00, 3.2290836671222678e-13,
	2.2204460492503131e-16, -2.2204460492503131e-16,
	4.1322500976548326e-13}, /* L637 */
{3.8017301359429263e+00, 2.6928459462283172e-13,
	2.2204460492503131e-16, 2.5646151868841116e-13,
	2.4225066397320916e-13}, /* L638 */
{5.3943747079250342e+00, 3.8269387658829146e-13,
	2.2204460492503131e-16, 5.3312909642500017e-13,
	-2.1804780203638074e-13}, /* L639 */
{5.5650478425127439e+00, 3.9541980800805732e-13,
	2.2204460492503131e-16, -4.4264591991804991e-13,
	-3.1874503036988244e-13}, /* L640 */
{3.5881491867893223e+00, 2.5535129566378600e-13,
	2.2204460492503131e-16, -4.7850612361344247e-14,
	-1.7763568394002505e-14}, /* L641 */
{4.8733527042976643e+00, 3.4735408993569195e-13,
	2.2204460492503131e-16, 1.3833378886829450e-13,
	-1.8218759834098819e-13}, /* L642 */
{4.3335993721418626e+00, 3.0936364581179987e-13,
	2.2204460492503131e-16, -1.2878587085651816e-13,
	-5.8508753397745750e-14}, /* L643 */
{4.8757840900745046e+00, 3.4861002973229915e-13,
	2.2204460492503131e-16, 4.6629367034256575e-15,
	-5.9396931817445875e-14}, /* L644 */
{4.2325648172777619e+00, 3.0309088572266774e-13,
	2.2204460492503131e-16, 6.3726801613483985e-14,
	-1.2978507157868080e-13}, /* L645 */
{5.5464483791548833e+00, 3.9779290972319359e-13,
	2.2204460492503131e-16, 4.3520742565306136e-14,
	-2.5868196473766147e-14}, /* L646 */
{5.4237914010474704e+00, 3.8959807602267915e-13,
	2.2204460492503131e-16, 1.9406698470447736e-13,
	-2.2726265314076954e-13}, /* L647 */
{5.4020146956345565e+00, 3.8863356977003605e-13,
	2.2204460492503131e-16, -8.4932061383824475e-14,
	1.0103029524088925e-13}, /* L648 */
{7.5524002051446724e+00, 5.4417581552002048e-13,
	2.2204460492503131e-16, 7.7426953737358417e-13,
	4.0145664570445661e-13}, /* L649 */
{4.2492374732833662e+00, 3.0664359940146824e-13,
	2.2204460492503131e-16, -9.0372154204487742e-14,
	-1.1879386363489175e-14}, /* L650 */
{4.4527840029154957e+00, 3.2182676662495524e-13,
	2.2204460492503131e-16, 8.0380146982861334e-14,
	1.4721557306529576e-13}, /* L651 */
{3.5874289727938069e+00, 2.5968116545982411e-13,
	2.2204460492503131e-16, -6.1251004268569886e-13,
	-9.8809849191638932e-14}, /* L652 */
{5.3384464010648651e+00, 3.8702374638432957e-13,
	2.2204460492503131e-16, 8.2156503822261584e-14,
	-3.9857006584043120e-14}, /* L653 */
{5.1307420397616967e+00, 3.7253533591297128e-13,
	2.2204460492503131e-16, -7.5717210279435676e-14,
	-6.2172489379008766e-14}, /* L654 */
{4.9259619701975410e+00, 3.5821345889530676e-13,
	2.2204460492503131e-16, 8.9261931179862586e-14,
	3.4416913763379853e-14}, /* L655 */
{4.7033229692459528e+00, 3.4254543646028424e-13,
	2.2204460492503131e-16, 4.7961634663806763e-14,
	1.7141843500212417e-13}, /* L656 */
{4.8297260369403956e+00, 3.5228764350136998e-13,
	2.2204460492503131e-16, 6.3504757008558954e-14,
	7.2830630415410269e-14}, /* L657 */
{4.6573021806852921e+00, 3.4022784589637922e-13,
	2.2204460492503131e-16, -6.6502359175046877e-14,
	1.2212453270876722e-14}, /* L658 */
{4.3228444529591563e+00, 3.1627478414009147e-13,
	2.2204460492503131e-16, -4.8294701571194310e-14,
	-2.6090241078691179e-14}, /* L659 */
{5.0192314037204078e+00, 3.6778219358879483e-13,
	2.2204460492503131e-16, 6.4859229098601645e-13,
	-2.9609648066752925e-13}, /* L660 */
{4.7813993742079255e+00, 3.5088598693278072e-13,
	2.2204460492503131e-16, -1.0325074129013956e-14,
	-6.9166894434147252e-14}, /* L661 */
{4.3923785310871120e+00, 3.2282509998537989e-13,
	2.2204460492503131e-16, -7.7782225105238467e-13,
	-2.6545432518787493e-13}, /* L662 */
{5.7119245471869471e+00, 4.2044145942554678e-13,
	2.2204460492503131e-16, 1.7896795156957523e-13,
	1.3966605649784469e-13}, /* L663 */
{4.2213922022854637e+00, 3.1119551380243138e-13,
	2.2204460492503131e-16, -2.7755575615628914e-13,
	-2.6789681584205027e-13}, /* L664 */
{4.6131651729595946e+00, 3.4058866837938240e-13,
	2.2204460492503131e-16, -6.3615779311021470e-14,
	-7.4162898044960457e-14}, /* L665 */
{4.8611187805292762e+00, 3.5943470422239443e-13,
	2.2204460492503131e-16, 1.9984014443252818e-15,
	4.8916426464984397e-13}, /* L666 */
{5.3725721944840128e+00, 3.9784842087442485e-13,
	2.2204460492503131e-16, 4.2854608750531042e-13,
	2.2182256032010628e-13}, /* L667 */
{5.2133315784024230e+00, 3.8663516832571077e-13,
	2.2204460492503131e-16, -1.0602629885170245e-13,
	4.7739590058881731e-14}, /* L668 */
{5.6393960423081229e+00, 4.1885939161545593e-13,
	2.2204460492503131e-16, -8.1712414612411521e-14,
	8.6153306710912148e-14}, /* L669 */
{5.6223969301958707e+00, 4.1822101337629647e-13,
	2.2204460492503131e-16, 6.7945649107059580e-14,
	-7.6605388699135801e-14}, /* L670 */
{6.2108890834889703e+00, 4.6268544551253399e-13,
	2.2204460492503131e-16, -3.9124259387790516e-13,
	5.5047078006964512e-12}, /* L671 */
{4.7715849091128026e+00, 3.5599301284605644e-13,
	2.2204460492503131e-16, -2.6090241078691179e-13,
	-2.8210767055725228e-13}, /* L672 */
{4.2410913865939781e+00, 3.1688540680363531e-13,
	2.2204460492503131e-16, 1.6653345369377348e-14,
	2.8421709430404007e-14}, /* L673 */
{6.1209295383359006e+00, 4.5802250880910833e-13,
	2.2204460492503131e-16, -5.8952842607595812e-14,
	5.1958437552457326e-14}, /* L674 */
{5.4748234524831494e+00, 4.1028291875022660e-13,
	2.2204460492503131e-16, 8.0158102377936302e-14,
	2.5313084961453569e-14}, /* L675 */
{4.7108062488399876e+00, 3.5355052219188110e-13,
	2.2204460492503131e-16, -1.6875389974302379e-13,
	1.0524914273446484e-13}, /* L676 */
{4.8578363200777002e+00, 3.6512459722359836e-13,
	2.2204460492503131e-16, -1.7319479184152442e-14,
	-1.0647038806155251e-13}, /* L677 */
{3.9719826677937946e+00, 2.9898306053155466e-13,
	2.2204460492503131e-16, -9.1637808452560421e-13,
	5.5244697705347789e-13}, /* L678 */
{5.7054581915063958e+00, 4.3010039973978564e-13,
	2.2204460492503131e-16, 6.0063065632220969e-13,
	1.3078427230084344e-12}, /* L679 */
{4.6167352249966322e+00, 3.4854064079326008e-13,
	2.2204460492503131e-16, -1.4002132786572474e-12,
	-7.6849637764553336e-13}, /* L680 */
{5.6505228649430661e+00, 4.2721381987576024e-13,
	2.2204460492503131e-16, 2.1027624086400465e-13,
	9.6589403142388619e-14}, /* L681 */
{4.1162088402135071e+00, 3.1166735858789707e-13,
	2.2204460492503131e-16, 5.0404125317982107e-14,
	7.0166095156309893e-14}, /* L682 */
{4.5968227722062069e+00, 3.4856839636887571e-13,
	2.2204460492503131e-16, -5.0404125317982107e-14,
	5.1070259132757201e-15}, /* L683 */
{4.0570239446551604e+00, 3.0808688933348094e-13,
	2.2204460492503131e-16, -6.1506355564233672e-14,
	-1.5221157667610896e-13}, /* L684 */
{5.0416137936030383e+00, 3.8341552155429781e-13,
	2.2204460492503131e-16, 3.5860203695392556e-13,
	-2.0838886172214188e-13}, /* L685 */
{3.8443938204289747e+00, 2.9279356716926941e-13,
	2.2204460492503131e-16, -1.3844481117075702e-13,
	1.6409096303959814e-13}, /* L686 */
{6.6259202063039382e+00, 5.0537352080937126e-13,
	2.2204460492503131e-16, -1.7319479184152442e-13,
	-1.6875389974302379e-14}, /* L687 */
{4.8343099527041407e+00, 3.6926017799032707e-13,
	2.2204460492503131e-16, -1.0014211682118912e-13,
	-4.4386716524513758e-13}, /* L688 */
{4.5587880342320082e+00, 3.4872105203476167e-13,
	2.2204460492503131e-16, 1.1213252548714081e-13,
	-4.7517545453956700e-14}, /* L689 */
{6.5869669140207634e+00, 5.0459636469213365e-13,
	2.2204460492503131e-16, 2.3281376826389533e-12,
	8.1978868138321559e-13}, /* L690 */
{6.5066582395463364e+00, 4.9916668021232624e-13,
	2.2204460492503131e-16, 5.8064664187895687e-13,
	5.9507954119908391e-14}, /* L691 */
{6.4544899520722341e+00, 4.9588111394882617e-13,
	2.2204460492503131e-16, -3.3673064336880998e-13,
	4.5363712786183896e-13}, /* L692 */
{4.7359382078537360e+00, 3.6437519668197638e-13,
	2.2204460492503131e-16, -3.5860203695392556e-14,
	1.7541523789077473e-14}, /* L693 */
{3.7175851159186775e+00, 2.8643754035329039e-13,
	2.2204460492503131e-16, 9.3356433694680163e-12,
	5.9161564536225342e-12}, /* L694 */
{6.1838227058953752e+00, 4.7714610040827665e-13,
	2.2204460492503131e-16, 2.1227464230832993e-13,
	-3.8768988019910466e-13}, /* L695 */
{5.1544621552201750e+00, 3.9829251008427491e-13,
	2.2204460492503131e-16, 1.9850787680297799e-13,
	1.0214051826551440e-14}, /* L696 */
{5.2546711310781351e+00, 4.0661918276896358e-13,
	2.2204460492503131e-16, -2.7644553313166398e-14,
	6.8167693711984612e-14}, /* L697 */
{5.1683462630156631e+00, 4.0051295613352522e-13,
	2.2204460492503131e-16, -2.0594637106796654e-13,
	-4.8949733155723152e-13}, /* L698 */
{4.1867018843598354e+00, 3.2490676815655206e-13,
	2.2204460492503131e-16, -5.4845017416482733e-14,
	-4.5075054799781356e-14}, /* L699 */
{4.7735789598809486e+00, 3.7098102367849606e-13,
	2.2204460492503131e-16, -7.5384143372048129e-14,
	6.4837024638109142e-14}, /* L700 */
{5.0649152662736672e+00, 3.9418468489316183e-13,
	2.2204460492503131e-16, -9.2592600253738055e-14,
	4.9293902293356950e-14}, /* L701 */
{4.7935438875946925e+00, 3.7359698668026908e-13,
	2.2204460492503131e-16, 6.7501559897209518e-14,
	1.4077627952246985e-13}, /* L702 */
{5.6426120318247355e+00, 4.4039771829318397e-13,
	2.2204460492503131e-16, 1.8518520050747611e-13,
	-9.5368157815300947e-13}, /* L703 */
{3.8313270674372735e+00, 2.9945490531702035e-13,
	2.2204460492503131e-16, -3.3473224192448470e-13,
	4.1144865292608301e-13}, /* L704 */
{4.0787298392966198e+00, 3.1924463073096376e-13,
	2.2204460492503131e-16, 4.5963233219481481e-14,
	1.0991207943789050e-13}, /* L705 */
{4.3813808502119818e+00, 3.4341973709217655e-13,
	2.2204460492503131e-16, 9.9920072216264089e-15,
	1.2878587085651816e-14}, /* L706 */
{4.5339534050160450e+00, 3.5588199054359393e-13,
	2.2204460492503131e-16, 3.5682568011452531e-13,
	5.2891024893142458e-13}, /* L707 */
{5.2118726295850646e+00, 4.0967229608668276e-13,
	2.2204460492503131e-16, 2.9398705692074145e-13,
	9.8809849191638932e-14}, /* L708 */
{4.8180611981047941e+00, 3.7925218521195347e-13,
	2.2204460492503131e-16, -1.9650947535865271e-14,
	-5.1070259132757201e-15}, /* L709 */
{5.3802901786618191e+00, 4.2410519540680980e-13,
	2.2204460492503131e-16, 1.4543921622589551e-13,
	2.7089441800853820e-13}, /* L710 */
{5.5858034681761168e+00, 4.4092507422988092e-13,
	2.2204460492503131e-16, -2.0838886172214188e-13,
	-8.5598195198599569e-14}, /* L711 */
{4.5674229363923331e+00, 3.6104452760810091e-13,
	2.2204460492503131e-16, 4.5519144009631418e-14,
	3.1086244689504383e-15}, /* L712 */
{4.3099647241253880e+00, 3.4117153546731060e-13,
	2.2204460492503131e-16, 5.4845017416482733e-14,
	-3.0830893393840597e-13}, /* L713 */
{5.5490283625570518e+00, 4.3987036235648702e-13,
	2.2204460492503131e-16, 1.9406698470447736e-13,
	-1.0960121699099545e-12}, /* L714 */
{6.3098001648026454e+00, 5.0087711755963937e-13,
	2.2204460492503131e-16, 1.1701750679549150e-13,
	-2.8088642523016460e-14}, /* L715 */
{5.4015448349052813e+00, 4.2937875477377929e-13,
	2.2204460492503131e-16, 1.9761969838327786e-14,
	-1.3244960683778118e-13}, /* L716 */
{5.9492771686437464e+00, 4.7357950894166834e-13,
	2.2204460492503131e-16, 4.8405723873656825e-14,
	-1.4765966227514582e-14}, /* L717 */
{4.0334325474155115e+00, 3.2152058793144533e-13,
	2.2204460492503131e-16, -5.9874327718034692e-13,
	3.4527936065842368e-13}, /* L718 */
{6.2489667436003877e+00, 4.9882320496408283e-13,
	2.2204460492503131e-16, -1.4876988529977098e-13,
	4.6851411639181606e-14}, /* L719 */
{4.7618130683010955e+00, 3.8063996399273492e-13,
	2.2204460492503131e-16, -1.5765166949677223e-14,
	1.8030021919912542e-13}, /* L720 */
{4.8190089899344413e+00, 3.8574698990601064e-13,
	2.2204460492503131e-16, 6.0573768223548541e-13,
	5.7709392820015637e-13}, /* L721 */
{5.4452994498122900e+00, 4.3648418213138029e-13,
	2.2204460492503131e-16, -8.8706819667550008e-14,
	2.6867397195928788e-14}, /* L722 */
{4.9979331964771694e+00, 4.0117908994830032e-13,
	2.2204460492503131e-16, -1.9317880628477724e-14,
	-1.3022916078853086e-13}, /* L723 */
{5.3266658624814962e+00, 4.2815750944669162e-13,
	2.2204460492503131e-16, 1.2390088954816747e-13,
	3.9079850466805510e-14}, /* L724 */
{5.2551807049291215e+00, 4.2299497238218464e-13,
	2.2204460492503131e-16, 5.7731597280508140e-14,
	8.1712414612411521e-14}, /* L725 */
{5.3311034522421563e+00, 4.2969794389335902e-13,
	2.2204460492503131e-16, 1.1701750679549150e-13,
	-3.5416114485542494e-14}, /* L726 */
{6.4026923574185375e+00, 5.1678106238739474e-13,
	2.2204460492503131e-16, -2.5424107263916085e-14,
	3.1086244689504383e-14}, /* L727 */
{5.4828383206431903e+00, 4.4314552027913123e-13,
	2.2204460492503131e-16, 3.0198066269804258e-14,
	-6.8722805224297190e-14}, /* L728 */
{5.2227448654761517e+00, 4.2270353883822054e-13,
	2.2204460492503131e-16, -1.1501910535116622e-13,
	4.6629367034256575e-15}, /* L729 */
{5.5294607786639238e+00, 4.4814152388994444e-13,
	2.2204460492503131e-16, 5.4845017416482733e-14,
	-7.5495165674510645e-15}, /* L730 */
{3.6812643578872324e+00, 2.9876101592662963e-13,
	2.2204460492503131e-16, -3.6703973194107675e-13,
	2.7644553313166398e-13}, /* L731 */
{5.0747230422844911e+00, 4.1241359285959511e-13,
	2.2204460492503131e-16, 1.2723155862204294e-13,
	7.4384942649885488e-14}, /* L732 */
{4.9051919135809046e+00, 3.9918068850397503e-13,
	2.2204460492503131e-16, 2.9309887850104133e-14,
	-7.3940853440035426e-14}, /* L733 */
{4.4186037015068136e+00, 3.6007308246155389e-13,
	2.2204460492503131e-16, 2.4424906541753444e-14,
	3.8902214782865485e-13}, /* L734 */
{4.7938851143583223e+00, 3.9118708272667391e-13,
	2.2204460492503131e-16, 3.7636560534792807e-13,
	4.8228088189716800e-13}, /* L735 */
{5.0954564086903238e+00, 4.1636138981004933e-13,
	2.2204460492503131e-16, 7.3430150848707854e-13,
	-3.8147263126120379e-13}, /* L736 */
{6.5230767772173435e+00, 5.3373971908854401e-13,
	2.2204460492503131e-16, -1.7069679003611782e-12,
	1.9806378759312793e-13}, /* L737 */
{7.4590226082607352e+00, 6.1115001948053305e-13,
	2.2204460492503131e-16, 9.1038288019262836e-15,
	2.9753977059954195e-13}, /* L738 */
{5.9905371915005796e+00, 4.9149573300155680e-13,
	2.2204460492503131e-16, -8.9594998087250133e-14,
	-4.5519144009631418e-15}, /* L739 */
{6.1905503074137398e+00, 5.0859316758078421e-13,
	2.2204460492503131e-16, -1.1246559239452836e-13,
	-2.0738966099997924e-13}, /* L740 */
{6.0897531975904897e+00, 5.0098813986210189e-13,
	2.2204460492503131e-16, -5.5622173533720343e-14,
	5.4845017416482733e-14}, /* L741 */
{5.0532424738830288e+00, 4.1627812308320244e-13,
	2.2204460492503131e-16, -1.4299672557172016e-13,
	1.8651746813702630e-14}, /* L742 */
{4.7153506426472500e+00, 3.8896663667742359e-13,
	2.2204460492503131e-16, 5.2047255394427339e-13,
	-2.2862822746105849e-12}, /* L743 */
{5.1660027740936192e+00, 4.2671421951467892e-13,
	2.2204460492503131e-16, -5.1292303737682232e-14,
	2.4558133304708463e-13}, /* L744 */
{6.3798758373864874e+00, 5.2768900360433690e-13,
	2.2204460492503131e-16, -6.7723604502134549e-14,
	-2.1982415887578100e-13}, /* L745 */
{6.1806397780477473e+00, 5.1189608107904405e-13,
	2.2204460492503131e-16, 2.2426505097428162e-14,
	3.2862601528904634e-14}, /* L746 */
{4.9215271757058083e+00, 4.0815961721563099e-13,
	2.2204460492503131e-16, 4.7961634663806763e-14,
	1.4321877017664519e-13}, /* L747 */
{6.4737735827010674e+00, 5.3761162188692424e-13,
	2.2204460492503131e-16, 2.0827783941967937e-13,
	1.7896795156957523e-13}, /* L748 */
{5.8938677767679390e+00, 4.9010795422077535e-13,
	2.2204460492503131e-16, -4.3631764867768652e-14,
	5.5511151231257827e-15}, /* L749 */
{5.6600089298247420e+00, 4.7128967395337895e-13,
	2.2204460492503131e-16, 2.2204460492503131e-14,
	6.0174087934683484e-13}, /* L750 */
{5.0938828702085779e+00, 4.2471581807035363e-13,
	2.2204460492503131e-16, 8.7707618945387367e-14,
	-2.9309887850104133e-13}, /* L751 */
{5.9521370503034259e+00, 4.9693582582222007e-13,
	2.2204460492503131e-16, 2.0428103653102880e-14,
	-1.7297274723659939e-13}, /* L752 */
{5.0783612658165858e+00, 4.2454928461665986e-13,
	2.2204460492503131e-16, -2.5102142586774789e-13,
	6.1728400169158704e-14}, /* L753 */
{5.1691062985628413e+00, 4.3270942384765476e-13,
	2.2204460492503131e-16, -4.0822900615467006e-13,
	-2.5301982731207318e-13}, /* L754 */
{4.8622593268501086e+00, 4.0756287233989497e-13,
	2.2204460492503131e-16, -4.3187675657918589e-14,
	4.5963233219481481e-14}, /* L755 */
{4.9604079583435956e+00, 4.1634057312833761e-13,
	2.2204460492503131e-16, -2.2037927038809357e-13,
	-1.3766765505351941e-14}, /* L756 */
{5.0647371848585072e+00, 4.2565950764128502e-13,
	2.2204460492503131e-16, 6.4170890823334048e-14,
	-6.9610983643997315e-14}, /* L757 */
{4.9386621453236152e+00, 4.1561198926842735e-13,
	2.2204460492503131e-16, 1.4632739464559563e-13,
	9.3036689463588118e-14}, /* L758 */
{5.5849890486292120e+00, 4.7062354013860386e-13,
	2.2204460492503131e-16, -6.3282712403633923e-15,
	-2.4635848916432224e-13}, /* L759 */
{6.0394832127454210e+00, 5.0959236830294685e-13,
	2.2204460492503131e-16, 1.4410694859634532e-13,
	7.9936057773011271e-15}, /* L760 */
{6.4704438484036633e+00, 5.4667381732542708e-13,
	2.2204460492503131e-16, 7.1054273576010019e-14,
	-2.1083135237631723e-13}, /* L761 */
{5.8162821422666831e+00, 4.9205084451386938e-13,
	2.2204460492503131e-16, 3.5282887722587475e-13,
	8.8817841970012523e-16}, /* L762 */
{8.0249143647637453e+00, 6.7978955797798335e-13,
	2.2204460492503131e-16, 3.3750779948604759e-14,
	-6.9499961341534799e-14}, /* L763 */
{6.7755342500098648e+00, 5.7470694869721228e-13,
	2.2204460492503131e-16, 1.8252066524837574e-13,
	-3.1241675912951905e-13}, /* L764 */
{4.8758246860250267e+00, 4.1411318818518339e-13,
	2.2204460492503131e-16, -5.2446935683292395e-13,
	1.8687273950490635e-12}, /* L765 */
{5.4402827346089841e+00, 4.6265768993691836e-13,
	2.2204460492503131e-16, -2.2160051571518125e-13,
	4.4408920985006262e-15}, /* L766 */
{6.6494563839787721e+00, 5.6622762034663765e-13,
	2.2204460492503131e-16, 6.0862426209951082e-13,
	2.5934809855243657e-13}, /* L767 */
{5.7496835504787178e+00, 4.9024673209885350e-13,
	2.2204460492503131e-16, -9.6256336235001072e-14,
	4.0811798385220754e-13}, /* L768 */
{5.2392800475839456e+00, 4.4730885662147557e-13,
	2.2204460492503131e-16, 8.8817841970012523e-15,
	-1.6431300764452317e-13}, /* L769 */
{5.4026059263202448e+00, 4.6185277824406512e-13,
	2.2204460492503131e-16, -1.0125233984581428e-13,
	-4.4464432136237519e-13}, /* L770 */
{4.7307143378691014e+00, 4.0493997044421803e-13,
	2.2204460492503131e-16, -1.3467005288703149e-13,
	3.7747582837255322e-15}, /* L771 */
{5.4776640825639777e+00, 4.6948556153836307e-13,
	2.2204460492503131e-16, 1.1679546219056647e-13,
	4.2410519540680980e-14}, /* L772 */
{4.5417277347125538e+00, 3.8977154837027683e-13,
	2.2204460492503131e-16, -1.1282086376240841e-12,
	1.0476064460362977e-12}, /* L773 */
{6.5058242177679810e+00, 5.5905280404999758e-13,
	2.2204460492503131e-16, -1.4654943925052066e-14,
	-5.2180482157382357e-14}, /* L774 */
{5.4361376088906992e+00, 4.6773696027457845e-13,
	2.2204460492503131e-16, -1.2689849171465539e-13,
	-3.1863400806741993e-14}, /* L775 */
{5.5992356380756574e+00, 4.8239190419963052e-13,
	2.2204460492503131e-16, 3.1130653610489389e-13,
	3.5282887722587475e-13}, /* L776 */
{4.8360758409790794e+00, 4.1718017929071038e-13,
	2.2204460492503131e-16, -8.4487972173974413e-14,
	-9.9142916099026479e-14}, /* L777 */
{4.7892106408032511e+00, 4.1366909897533333e-13,
	2.2204460492503131e-16, -1.5076828674409626e-13,
	-1.3766765505351941e-14}, /* L778 */
{6.0006513157923154e+00, 5.1897375286102942e-13,
	2.2204460492503131e-16, 1.5210055437364645e-13,
	-1.8762769116165146e-14}, /* L779 */
{4.2705195581422490e+00, 3.6981528950263964e-13,
	2.2204460492503131e-16, -7.5051076464660582e-14,
	6.8833827526759706e-14}, /* L780 */
{5.5966797646122730e+00, 4.8527848406365592e-13,
	2.2204460492503131e-16, -4.1222580904332062e-13,
	-1.1654011089490268e-12}, /* L781 */
{5.3714918506004858e+00, 4.6634918149379700e-13,
	2.2204460492503131e-16, -2.4535928844215960e-14,
	-2.4980018054066022e-14}, /* L782 */
{5.0805875175942159e+00, 4.4165712753674313e-13,
	2.2204460492503131e-16, -4.5519144009631418e-15,
	-9.7699626167013776e-15}, /* L783 */
{4.7464998355253565e+00, 4.1314174303863638e-13,
	2.2204460492503131e-16, 6.2394533983933798e-14,
	7.1720407390785113e-14}, /* L784 */
{3.9261208439437265e+00, 3.4217073618947325e-13,
	2.2204460492503131e-16, 5.0648374383399641e-13,
	2.3536728122053319e-14}, /* L785 */
{4.6774882957369188e+00, 4.0817349500343880e-13,
	2.2204460492503131e-16, 1.1102230246251565e-14,
	2.5091040356528538e-14}, /* L786 */
{5.4371115006593902e+00, 4.7506443223710448e-13,
	2.2204460492503131e-16, 5.1070259132757201e-14,
	-4.1633363423443370e-14}, /* L787 */
{5.5780544858105578e+00, 4.8799853047398756e-13,
	2.2204460492503131e-16, -3.7614356074300304e-13,
	5.6021853822585399e-13}, /* L788 */
{4.8637592578527356e+00, 4.2604808569990382e-13,
	2.2204460492503131e-16, -4.6040948831205242e-13,
	2.9087843245179101e-14}, /* L789 */
{4.9607673203088325e+00, 4.3509640335059885e-13,
	2.2204460492503131e-16, 3.0198066269804258e-14,
	2.1316282072803006e-14}, /* L790 */
{5.5463997904164684e+00, 4.8707652494650588e-13,
	2.2204460492503131e-16, 1.3722356584366935e-13,
	7.3718808835110394e-14}, /* L791 */
{7.4968552621604037e+00, 6.5919492087118670e-13,
	2.2204460492503131e-16, 1.0678125050844756e-12,
	-4.5585757391108928e-13}, /* L792 */
{5.7465412227243586e+00, 5.0592863232168384e-13,
	2.2204460492503131e-16, -9.4924068605450884e-14,
	6.2394533983933798e-14}, /* L793 */
{5.4773386164466649e+00, 4.8283599340948058e-13,
	2.2204460492503131e-16, -2.5424107263916085e-14,
	1.8607337892717624e-13}, /* L794 */
{6.7452936609527079e+00, 5.9535709695524019e-13,
	2.2204460492503131e-16, 1.1588507931037384e-12,
	-1.0323963905989331e-12}, /* L795 */
{5.6677225098294119e+00, 5.0087711755963937e-13,
	2.2204460492503131e-16, -1.2045919817182948e-13,
	3.2107649872159527e-13}, /* L796 */
{5.7716919793125445e+00, 5.1070606077452396e-13,
	2.2204460492503131e-16, -2.2648549702353193e-14,
	1.1546319456101628e-14}, /* L797 */
{7.7575310361044254e+00, 6.8728356339420316e-13,
	2.2204460492503131e-16, -1.0436096431476471e-14,
	-8.3710816056736803e-14}, /* L798 */
{5.5982566421632196e+00, 4.9660275891483252e-13,
	2.2204460492503131e-16, 8.9639407008235139e-13,
	-1.3355982986240633e-13}, /* L799 */
{5.1640706473886384e+00, 4.5866088704826780e-13,
	2.2204460492503131e-16, 4.2010839251815923e-13,
	-2.7089441800853820e-14}, /* L800 */
{6.0293478396294509e+00, 5.3618220974271935e-13,
	2.2204460492503131e-16, -3.7680969455777813e-13,
	2.3270274596143281e-13}, /* L801 */
{5.9975156967327594e+00, 5.3401727484470030e-13,
	2.2204460492503131e-16, 8.2600593032111647e-14,
	8.0158102377936302e-14}, /* L802 */
{4.9206179749994252e+00, 4.3867687260501498e-13,
	2.2204460492503131e-16, -6.1395333261771157e-14,
	-1.1657341758564144e-13}, /* L803 */
{5.0876945940554847e+00, 4.5413672822292028e-13,
	2.2204460492503131e-16, 1.3988810110276972e-14,
	-2.9420910152566648e-14}, /* L804 */
{5.1867317856259181e+00, 4.6355280725052239e-13,
	2.2204460492503131e-16, -2.4757973449140991e-14,
	3.6637359812630166e-14}, /* L805 */
{6.6606029402411666e+00, 5.9601629187611138e-13,
	2.2204460492503131e-16, -2.2060131499301860e-13,
	-5.6732396558345499e-14}, /* L806 */
{5.3853864395590136e+00, 4.8250292650209303e-13,
	2.2204460492503131e-16, 1.7186252421197423e-13,
	1.2012613126444194e-13}, /* L807 */
{5.3459242758868228e+00, 4.7956083548683637e-13,
	2.2204460492503131e-16, -7.3052675020335300e-14,
	4.8849813083506888e-15}, /* L808 */
{6.3844352890848084e+00, 5.7343019221889335e-13,
	2.2204460492503131e-16, -1.2412293415309250e-13,
	-8.6930462828149757e-14}, /* L809 */
{6.0456885506712004e+00, 5.4367621515893916e-13,
	2.2204460492503131e-16, -3.7081449022480228e-14,
	8.7485574340462335e-14}, /* L810 */
{5.9192448505473703e+00, 5.3296256297130640e-13,
	2.2204460492503131e-16, 5.7731597280508140e-15,
	1.2212453270876722e-14}, /* L811 */
{4.9039486236889385e+00, 4.4209080840573733e-13,
	2.2204460492503131e-16, 5.7953641885433171e-14,
	-2.8221869285971479e-13}, /* L812 */
{5.8108947767463297e+00, 5.2449711240853958e-13,
	2.2204460492503131e-16, 1.0280665208028950e-13,
	-8.5487172896137054e-14}, /* L813 */
{5.8472911663449612e+00, 5.2843146525205498e-13,
	2.2204460492503131e-16, -7.1720407390785113e-14,
	2.9531932455029164e-14}, /* L814 */
{5.2760819437426676e+00, 4.7739590058881731e-13,
	2.2204460492503131e-16, -6.4392935428259079e-15,
	2.3536728122053319e-14}, /* L815 */
{4.9963314121564366e+00, 4.5263792713967632e-13,
	2.2204460492503131e-16, 2.8066438062523957e-13,
	-9.9809049913801573e-14}, /* L816 */
{9.8972004374043845e+00, 8.9772633771190158e-13,
	2.2204460492503131e-16, 6.7057470687359455e-14,
	1.0680345496894006e-13}, /* L817 */
{6.0547161540341738e+00, 5.4986570852122441e-13,
	2.2204460492503131e-16, 1.0258460747536446e-13,
	-1.8762769116165146e-13}, /* L818 */
{5.6835788693408089e+00, 5.1679147072825060e-13,
	2.2204460492503131e-16, -2.0883295093199195e-13,
	1.4788170688007085e-13}, /* L819 */
{7.7658659107967294e+00, 7.0699002208129968e-13,
	2.2204460492503131e-16, -1.6586731987899839e-13,
	-2.8610447344590284e-13}, /* L820 */
{7.6443482359374508e+00, 6.9677597025474824e-13,
	2.2204460492503131e-16, -2.0738966099997924e-13,
	-3.7303493627405260e-14}, /* L821 */
{4.9203240645320649e+00, 4.4902970230964456e-13,
	2.2204460492503131e-16, -9.9920072216264089e-15,
	4.5985437679973984e-13}, /* L822 */
{5.4878579899365851e+00, 5.0143222907195195e-13,
	2.2204460492503131e-16, 9.5545793499240972e-13,
	6.0151883474190981e-13}, /* L823 */
{6.2803497143765901e+00, 5.7454041524351851e-13,
	2.2204460492503131e-16, 1.0880185641326534e-14,
	-8.9372953482325102e-14}, /* L824 */
{8.0253156918978181e+00, 7.3506478681650833e-13,
	2.2204460492503131e-16, -5.2069459854919842e-14,
	4.8849813083506888e-14}, /* L825 */
{4.3955880487509509e+00, 4.0309422466577871e-13,
	2.2204460492503131e-16, 1.0436096431476471e-14,
	2.7666757773658901e-13}, /* L826 */
{4.9359207257683675e+00, 4.5319303865198890e-13,
	2.2204460492503131e-16, 2.1538326677728037e-14,
	1.4632739464559563e-13}, /* L827 */
{6.7110613127196102e+00, 6.1692317920858386e-13,
	2.2204460492503131e-16, 3.9479530755670567e-13,
	2.1938006966593093e-13}, /* L828 */
{4.5184027861190534e+00, 4.1586178944896801e-13,
	2.2204460492503131e-16, 1.5285550603039155e-12,
	-1.9910739723627557e-12}, /* L829 */
{7.1277220888234192e+00, 6.5680794136824261e-13,
	2.2204460492503131e-16, 2.3336887977620790e-13,
	-1.4099832412739488e-14}, /* L830 */
{4.5854464643221036e+00, 4.2305048353341590e-13,
	2.2204460492503131e-16, 1.5254464358349651e-12,
	9.8032693074401323e-13}, /* L831 */
{5.6953590457039507e+00, 5.2608264966558238e-13,
	2.2204460492503131e-16, 1.4166445794216997e-13,
	8.8817841970012523e-14}, /* L832 */
{5.1566708007782589e+00, 4.7689630022773599e-13,
	2.2204460492503131e-16, -6.5569771834361745e-13,
	-1.4122036873231991e-13}, /* L833 */
{5.6810641189063018e+00, 5.2602366906739917e-13,
	2.2204460492503131e-16, 1.1255441023649837e-12,
	-2.2061241722326486e-12}, /* L834 */
{7.5390837507531092e+00, 6.9889927178934386e-13,
	2.2204460492503131e-16, -2.3314683517128287e-15,
	-1.8030021919912542e-13}, /* L835 */
{6.5557818742044169e+00, 6.0847160643362486e-13,
	2.2204460492503131e-16, 4.0634162701280729e-14,
	-4.9737991503207013e-14}, /* L836 */
{4.5770681531677999e+00, 4.2532644073389747e-13,
	2.2204460492503131e-16, -3.1452618287630685e-13,
	-9.8920871494101448e-14}, /* L837 */
{4.8242916208647806e+00, 4.4883541328033516e-13,
	2.2204460492503131e-16, 6.9944050551384862e-14,
	2.4202861936828413e-14}, /* L838 */
{6.6103538439799037e+00, 6.1573836307449170e-13,
	2.2204460492503131e-16, 1.4455103780619538e-13,
	-5.7398530373120593e-14}, /* L839 */
{4.9940554981994092e+00, 4.6573855883025317e-13,
	2.2204460492503131e-16, 1.5321077739827160e-14,
	-5.6066262743570405e-14}, /* L840 */
{5.7401993060558745e+00, 5.3596016513779432e-13,
	2.2204460492503131e-16, 1.3078427230084344e-13,
	5.5289106626332796e-14}, /* L841 */
{6.2256630289172081e+00, 5.8197890950850706e-13,
	2.2204460492503131e-16, -1.8007817459420039e-13,
	1.4677148385544569e-13}, /* L842 */
{5.8446118307928137e+00, 5.4700688423281463e-13,
	2.2204460492503131e-16, -1.6151524562246777e-12,
	2.3188118092321020e-12}, /* L843 */
{5.6466321314715486e+00, 5.2910453796073398e-13,
	2.2204460492503131e-16, -8.4021678503631847e-13,
	9.3547392054915690e-13}, /* L844 */
{5.3997126611756201e+00, 5.0656701056084330e-13,
	2.2204460492503131e-16, -7.7826634026223473e-14,
	2.6689761511988763e-13}, /* L845 */
{5.2452801431278946e+00, 4.9266146717741321e-13,
	2.2204460492503131e-16, 5.7509552675583109e-14,
	-5.9285909514983359e-14}, /* L846 */
{5.7857234138907518e+00, 5.4406479321755796e-13,
	2.2204460492503131e-16, 1.1901590823981678e-13,
	1.9317880628477724e-14}, /* L847 */
{5.3661641266103519e+00, 5.0520698735567748e-13,
	2.2204460492503131e-16, -2.5424107263916085e-13,
	-2.2359891715950653e-13}, /* L848 */
{6.3798687228077453e+00, 6.0135230128821604e-13,
	2.2204460492503131e-16, -6.2394533983933798e-14,
	-1.2212453270876722e-15}, /* L849 */
{6.7017752793213372e+00, 6.3243854597772042e-13,
	2.2204460492503131e-16, -3.1308289294429414e-14,
	2.2204460492503131e-16}, /* L850 */
{5.7622740735211968e+00, 5.4441867680665723e-13,
	2.2204460492503131e-16, -2.8941293805928581e-12,
	1.8149926006572059e-12}, /* L851 */
{5.9629825592457770e+00, 5.6404360349038285e-13,
	2.2204460492503131e-16, -1.0946799022804043e-13,
	-1.4777068457760834e-13}, /* L852 */
{5.0861744957595070e+00, 4.8167025923362417e-13,
	2.2204460492503131e-16, -1.2292389328649733e-12,
	6.4215299744319054e-13}, /* L853 */
{5.0556285851944835e+00, 4.7933879088191134e-13,
	2.2204460492503131e-16, -5.7731597280508140e-15,
	1.0635936575909000e-13}, /* L854 */
{6.2374367413835543e+00, 5.9208193903259598e-13,
	2.2204460492503131e-16, 4.6629367034256575e-13,
	4.5146109073357366e-12}, /* L855 */
{5.9497757421420419e+00, 5.6543658644159223e-13,
	2.2204460492503131e-16, 1.2900791546144319e-13,
	1.5099033134902129e-14}, /* L856 */
{5.0644770684410663e+00, 4.8186454826293357e-13,
	2.2204460492503131e-16, -1.0880185641326534e-13,
	1.0436096431476471e-14}, /* L857 */
{6.2309247489302457e+00, 5.9353910675241650e-13,
	2.2204460492503131e-16, 1.9899637493381306e-12,
	4.6647130602650577e-12}, /* L858 */
{4.4090581785389666e+00, 4.2048309278897023e-13,
	2.2204460492503131e-16, 7.4784622938750545e-13,
	-1.0299538999447577e-12}, /* L859 */
{6.9174527740754632e+00, 6.6047167734950563e-13,
	2.2204460492503131e-16, -3.7346792325365641e-12,
	-7.3641093223386633e-13}, /* L860 */
{5.5769542111074966e+00, 5.3310134084938454e-13,
	2.2204460492503131e-16, -4.6074255521943996e-14,
	8.0824236192711396e-14}, /* L861 */
{6.3616689695639250e+00, 6.0881855112882022e-13,
	2.2204460492503131e-16, 4.6629367034256575e-15,
	-7.5939254884360707e-14}, /* L862 */
{4.7879565690563686e+00, 4.5874415377511468e-13,
	2.2204460492503131e-16, -1.6431300764452317e-13,
	1.5742962489184720e-13}, /* L863 */
{6.5356729271103298e+00, 6.2692212532411418e-13,
	2.2204460492503131e-16, -1.9484414082171497e-13,
	-3.0264679651281767e-13}, /* L864 */
{5.1370023243348175e+00, 4.9332760099218831e-13,
	2.2204460492503131e-16, -1.8285373215576328e-13,
	3.6703973194107675e-13}, /* L865 */
{6.7863848408743417e+00, 6.5247807157220450e-13,
	2.2204460492503131e-16, -1.8418599978531347e-13,
	3.0975222387041867e-13}, /* L866 */
{6.4708867950856597e+00, 6.2286287239032845e-13,
	2.2204460492503131e-16, 5.3734794391857577e-14,
	3.0486724256206799e-13}, /* L867 */
{6.7753563116450861e+00, 6.5292216078205456e-13,
	2.2204460492503131e-16, -2.4824586830618500e-13,
	-1.2900791546144319e-13}, /* L868 */
{5.1585236737345079e+00, 4.9768522636384205e-13,
	2.2204460492503131e-16, -3.3750779948604759e-14,
	-1.8984813721090177e-14}, /* L869 */
{7.3713478367140581e+00, 7.1199296458601680e-13,
	2.2204460492503131e-16, 2.9332092310596636e-13,
	-2.4069635173873394e-13}, /* L870 */
{7.3077038371027525e+00, 7.0665695517391214e-13,
	2.2204460492503131e-16, -2.8721469647052800e-13,
	-5.0881521218570924e-13}, /* L871 */
{5.4753526751941850e+00, 5.3007598310728099e-13,
	2.2204460492503131e-16, -3.5804692544161298e-13,
	-1.1535217225855376e-13}, /* L872 */
{5.1340287185483042e+00, 4.9760195963699516e-13,
	2.2204460492503131e-16, -2.3170354523927017e-13,
	-1.6509016376176078e-13}, /* L873 */
{5.6175717919442070e+00, 5.4509174951533623e-13,
	2.2204460492503131e-16, 1.7430501486614958e-13,
	5.7953641885433171e-14}, /* L874 */
{6.0377238114716985e+00, 5.8653082390947020e-13,
	2.2204460492503131e-16, -3.1419311596891930e-14,
	-8.3932860661661834e-14}, /* L875 */
{6.1301466578670061e+00, 5.9618976422370906e-13,
	2.2204460492503131e-16, 7.1409544943890069e-13,
	1.9251267247000214e-12}, /* L876 */
{6.2750954190688208e+00, 6.1098348602683927e-13,
	2.2204460492503131e-16, -3.6359804056473877e-13,
	1.4579448759377556e-12}, /* L877 */
{6.1107727389561139e+00, 5.9566240828701211e-13,
	2.2204460492503131e-16, 1.1990408665951691e-14,
	2.6134649999676185e-13}, /* L878 */
{6.6204598194266104e+00, 6.4608041139280203e-13,
	2.2204460492503131e-16, 1.8363088827300089e-13,
	4.3232084578903596e-13}, /* L879 */
{6.5198966501069764e+00, 6.3699046037868357e-13,
	2.2204460492503131e-16, -9.1993079820440471e-13,
	-2.1993518117824351e-13}, /* L880 */
{6.6342329413196772e+00, 6.4889760231778837e-13,
	2.2204460492503131e-16, 2.7200464103316335e-13,
	1.5276668818842154e-13}, /* L881 */
{5.9053381150579725e+00, 5.7825966237601278e-13,
	2.2204460492503131e-16, 1.3633538742396922e-13,
	6.5702998597316764e-13}, /* L882 */
{6.0271895770870376e+00, 5.9086069370550831e-13,
	2.2204460492503131e-16, -6.5503158452884236e-14,
	2.4469315462738450e-13}, /* L883 */
{5.7030632964053680e+00, 5.5971893786477267e-13,
	2.2204460492503131e-16, 8.8595797365087492e-14,
	9.7699626167013776e-15}, /* L884 */
{7.0096155788907950e+00, 6.8872685332621586e-13,
	2.2204460492503131e-16, -3.8880010322372982e-13,
	2.2115642650533118e-13}, /* L885 */
{8.0350013901915709e+00, 7.9036777123064894e-13,
	2.2204460492503131e-16, 7.9491968563161208e-14,
	-2.5246471579976060e-13}, /* L886 */
{6.3557033758012915e+00, 6.2588823013243200e-13,
	2.2204460492503131e-16, -2.5313084961453569e-14,
	-2.0383694732117874e-13}, /* L887 */
{5.8378470482479052e+00, 5.7553961596568115e-13,
	2.2204460492503131e-16, -1.6220358389773537e-13,
	2.6578739209526248e-13}, /* L888 */
{5.8582769591789754e+00, 5.7820415122478153e-13,
	2.2204460492503131e-16, 1.5365486660812167e-13,
	1.8207657603852567e-13}, /* L889 */
{6.8000107284255273e+00, 6.7190697450314474e-13,
	2.2204460492503131e-16, -7.2275518903097691e-14,
	6.7279515292284486e-14}, /* L890 */
{8.0757703169420463e+00, 7.9886097736903139e-13,
	2.2204460492503131e-16, 2.3625545964023331e-13,
	-8.7863050168834889e-13}, /* L891 */
{5.7140995420799570e+00, 5.6587720620449034e-13,
	2.2204460492503131e-16, -3.1863400806741993e-13,
	9.3480778673438181e-14}, /* L892 */
{7.0554422624398523e+00, 6.9949601666507988e-13,
	2.2204460492503131e-16, -3.1752378504279477e-14,
	-1.6653345369377348e-15}, /* L893 */
{4.9636543636273327e+00, 4.9266146717741321e-13,
	2.2204460492503131e-16, -1.6919798895287386e-13,
	6.9522165802027303e-13}, /* L894 */
{6.3481943731287842e+00, 6.3078708922859050e-13,
	2.2204460492503131e-16, -7.0132788465571139e-13,
	3.3772984409097262e-13}, /* L895 */
{6.9894083486650374e+00, 6.9527716917150428e-13,
	2.2204460492503131e-16, -3.1763480734525729e-13,
	-1.7030821197749901e-13}, /* L896 */
{6.6542224549305811e+00, 6.6267304144052019e-13,
	2.2204460492503131e-16, -1.0014211682118912e-13,
	-3.5593750169482519e-13}, /* L897 */
{7.0843652973185325e+00, 7.0629613269090896e-13,
	2.2204460492503131e-16, -1.5165646516379638e-13,
	2.1693757901175559e-13}, /* L898 */
{5.8309324475313371e+00, 5.8197890950850706e-13,
	2.2204460492503131e-16, 1.0942358130705543e-12,
	6.3282712403633923e-13}, /* L899 */
{6.6433438145839370e+00, 6.6380234642338110e-13,
	2.2204460492503131e-16, -4.0523140398818214e-14,
	7.4384942649885488e-14}, /* L900 */
{6.9370253729904032e+00, 6.9391714596633847e-13,
	2.2204460492503131e-16, -7.4795725168996796e-13,
	-8.1212814251330201e-13}, /* L901 */
{6.4007861517729747e+00, 6.4098726326733413e-13,
	2.2204460492503131e-16, 2.6134649999676185e-13,
	-1.1302070390684094e-13}, /* L902 */
{7.6472988869014422e+00, 7.6666450965490185e-13,
	2.2204460492503131e-16, 1.9584334154387761e-13,
	-8.0824236192711396e-14}, /* L903 */
{6.6161608808319823e+00, 6.6402439102830613e-13,
	2.2204460492503131e-16, 7.0898842352562497e-13,
	2.3647750424515834e-13}, /* L904 */
{7.4878571174627959e+00, 7.5234263263723733e-13,
	2.2204460492503131e-16, 3.0724311983476582e-12,
	4.3143266736933583e-13}, /* L905 */
{8.0027720079277849e+00, 8.0496720400446975e-13,
	2.2204460492503131e-16, -4.8738790781044372e-14,
	6.4392935428259079e-14}, /* L906 */
{6.3291169314673299e+00, 6.3732352728607111e-13,
	2.2204460492503131e-16, 2.4646951146678475e-14,
	2.4868995751603507e-14}, /* L907 */
{5.9894092292604926e+00, 6.0378091415458357e-13,
	2.2204460492503131e-16, 1.6608936448392342e-13,
	-5.2413628992553640e-13}, /* L908 */
{7.1226735037165598e+00, 7.1881389729355760e-13,
	2.2204460492503131e-16, -4.6851411639181606e-14,
	2.2204460492503131e-15}, /* L909 */
{1.2004963995260768e+01, 1.2128631432517523e-12,
	2.2204460492503131e-16, -1.1879386363489175e-14,
	-7.1498362785860081e-14}, /* L910 */
{5.2436965276595409e+00, 5.3035353886343728e-13,
	2.2204460492503131e-16, 1.4608314558017810e-12,
	9.5767838104166003e-13}, /* L911 */
{5.4082330733706163e+00, 5.4759538917203976e-13,
	2.2204460492503131e-16, 6.2074789752841752e-12,
	2.5446311724408588e-13}, /* L912 */
{5.1336335100961161e+00, 5.2036153164181087e-13,
	2.2204460492503131e-16, 1.3966605649784469e-13,
	9.4058094646243262e-13}, /* L913 */
{6.1307536550257353e+00, 6.2211347184870647e-13,
	2.2204460492503131e-16, 9.4368957093138306e-14,
	2.1094237467877974e-14}, /* L914 */
{6.5106660096199507e+00, 6.6138761134482138e-13,
	2.2204460492503131e-16, 5.0759396685862157e-13,
	-1.1102230246251565e-13}, /* L915 */
{8.3286157600311341e+00, 8.4698914548653192e-13,
	2.2204460492503131e-16, -1.0836886943366153e-12,
	5.4738436006118718e-12}, /* L916 */
{5.2467367401910279e+00, 5.3415605272277844e-13,
	2.2204460492503131e-16, 2.6645352591003757e-15,
	-4.6740389336719090e-14}, /* L917 */
{7.6448922354710795e+00, 7.7915451868193486e-13,
	2.2204460492503131e-16, 6.1779470428291461e-12,
	1.6034951144661136e-11}, /* L918 */
{5.4037081990071005e+00, 5.5133675402885274e-13,
	2.2204460492503131e-16, -4.3998138465894954e-13,
	-1.2402301408087624e-12}, /* L919 */
{4.3652242783491957e+00, 4.4586556668946287e-13,
	2.2204460492503131e-16, -3.4305891460917337e-14,
	-6.0951244051921094e-14}, /* L920 */
{6.3895323392144743e+00, 6.5333849441628900e-13,
	2.2204460492503131e-16, 1.1612932837579137e-13,
	-3.1674662892555716e-13}, /* L921 */
{5.8123735953795981e+00, 5.9496851889662139e-13,
	2.2204460492503131e-16, -5.8375526634790731e-13,
	-9.4768637382003362e-13}, /* L922 */
{6.5474101132018605e+00, 6.7093552935659773e-13,
	2.2204460492503131e-16, -6.0607074914287296e-13,
	-8.4632301167175683e-13}, /* L923 */
{5.7401335151183037e+00, 5.8884841447337521e-13,
	2.2204460492503131e-16, 5.9752203185325925e-13,
	4.7628567756419216e-13}, /* L924 */
{6.8264972566862019e+00, 7.0105032889955510e-13,
	2.2204460492503131e-16, 1.4004353232621725e-12,
	-5.8375526634790731e-13}, /* L925 */
{6.4638330921997484e+00, 6.6452399138938745e-13,
	2.2204460492503131e-16, -2.8677060726067793e-13,
	-5.5944138210861638e-13}, /* L926 */
{6.1794865563184924e+00, 6.3597738186871311e-13,
	2.2204460492503131e-16, 4.0101255649460654e-13,
	-1.5787371410169726e-13}, /* L927 */
{8.3223124297326248e+00, 8.5743565025886426e-13,
	2.2204460492503131e-16, -1.8762769116165146e-14,
	-2.0916601783937949e-13}, /* L928 */
{7.4370407969731209e+00, 7.6705308771352065e-13,
	2.2204460492503131e-16, -9.6112007241799802e-13,
	3.5260683262094972e-13}, /* L929 */
{6.5539081896025664e+00, 6.7669481129684073e-13,
	2.2204460492503131e-16, 1.1857181902996672e-13,
	-9.2148511043887993e-15}, /* L930 */
{8.1063500611954957e+00, 8.3788531668460564e-13,
	2.2204460492503131e-16, 8.1490370007486490e-14,
	7.0832228971084987e-14}, /* L931 */
{5.0944286380281163e+00, 5.2713389209202433e-13,
	2.2204460492503131e-16, 7.9602990865623724e-13,
	-1.0729306332279975e-11}, /* L932 */
{6.4677553810622532e+00, 6.6995367586919485e-13,
	2.2204460492503131e-16, 4.0856207306205761e-13,
	-2.1882495815361835e-13}, /* L933 */
{5.1754631974800116e+00, 5.3666793231599286e-13,
	2.2204460492503131e-16, 6.5281113847959205e-13,
	1.9029222642075183e-13}, /* L934 */
{5.5473349552734277e+00, 5.7584492729745307e-13,
	2.2204460492503131e-16, -1.0713652187632761e-13,
	-1.4399592629388280e-13}, /* L935 */
{6.4204161123026866e+00, 6.6718852664848782e-13,
	2.2204460492503131e-16, -1.6613377340490842e-12,
	6.1659566341631944e-12}, /* L936 */
{5.8863486679335608e+00, 6.1234350923200509e-13,
	2.2204460492503131e-16, -1.5709655798445965e-13,
	4.4408920985006262e-14}, /* L937 */
{7.0773032767795323e+00, 7.3702155489741017e-13,
	2.2204460492503131e-16, 4.1899816949353408e-13,
	-5.4400928206632670e-14}, /* L938 */
{7.1384564168047788e+00, 7.4418249340624243e-13,
	2.2204460492503131e-16, 2.1316282072803006e-13,
	8.6930462828149757e-13}, /* L939 */
{7.2005432752390668e+00, 7.5145445421753720e-13,
	2.2204460492503131e-16, 1.1635137298071641e-13,
	-1.0236256287043943e-13}, /* L940 */
{5.2109540236965906e+00, 5.4439786012494551e-13,
	2.2204460492503131e-16, -1.0424994201230220e-13,
	4.4408920985006262e-16}, /* L941 */
{7.2018425725798965e+00, 7.5318917769351401e-13,
	2.2204460492503131e-16, 6.1728400169158704e-13,
	1.6231460620019789e-13}, /* L942 */
{7.5646991034900575e+00, 7.9197759461635542e-13,
	2.2204460492503131e-16, -4.1189274213593308e-14,
	6.6391336872584361e-14}, /* L943 */
{8.0042499164981002e+00, 8.3888451740676828e-13,
	2.2204460492503131e-16, 9.6811447747313650e-14,
	1.1080025785759062e-13}, /* L944 */
{7.2097997347402023e+00, 7.5642270225273478e-13,
	2.2204460492503131e-16, 3.7081449022480228e-14,
	8.9483975784787617e-14}, /* L945 */
{4.6287007350864569e+00, 4.8613890690774042e-13,
	2.2204460492503131e-16, -9.7588603864551260e-14,
	2.5313084961453569e-14}, /* L946 */
{6.6119337702020271e+00, 6.9516614686904177e-13,
	2.2204460492503131e-16, 1.8274270985330077e-13,
	6.1461946643248666e-13}, /* L947 */
{5.5200433228603947e+00, 5.8097970878634442e-13,
	2.2204460492503131e-16, 1.6053824936079764e-13,
	2.1138646388862981e-13}, /* L948 */
{5.4968399016857976e+00, 5.7914784079571291e-13,
	2.2204460492503131e-16, -9.5479180117763462e-15,
	-1.3922196728799463e-13}, /* L949 */
{5.8255275069440060e+00, 6.1442517740317726e-13,
	2.2204460492503131e-16, -7.0555783437953323e-12,
	1.0891287871572786e-11}, /* L950 */
{6.8811791147795152e+00, 7.2652994731470244e-13,
	2.2204460492503131e-16, -8.1379347705023974e-14,
	-2.1538326677728037e-14}, /* L951 */
{9.0120816747706520e+00, 9.5251584397715305e-13,
	2.2204460492503131e-16, 2.0716761639505421e-13,
	3.2818192607919627e-13}, /* L952 */
{6.6128030311209933e+00, 6.9966255011877365e-13,
	2.2204460492503131e-16, 1.1841638780651920e-12,
	1.8962609260597674e-13}, /* L953 */
{4.9091991170558229e+00, 5.1995907579538425e-13,
	2.2204460492503131e-16, 2.1982415887578100e-14,
	9.2126306583395490e-13}, /* L954 */
{6.3900536626935871e+00, 6.7751360077750178e-13,
	2.2204460492503131e-16, 1.2656542480726785e-13,
	7.9691808707593736e-13}, /* L955 */
{5.8969677330262291e+00, 6.2588823013243200e-13,
	2.2204460492503131e-16, 1.5756285165480222e-12,
	-6.2350125062948791e-13}, /* L956 */
{7.6933140078650801e+00, 8.1740170188027150e-13,
	2.2204460492503131e-16, -5.2735593669694936e-14,
	-1.6120438317557273e-13}, /* L957 */
{5.8556901326765569e+00, 6.2280736123909719e-13,
	2.2204460492503131e-16, -1.0802470029602773e-13,
	7.5406347832540632e-13}, /* L958 */
{6.8952047467702009e+00, 7.3413497503338476e-13,
	2.2204460492503131e-16, 2.0872192862952943e-13,
	9.4035890185750759e-13}, /* L959 */
{6.1161470839986061e+00, 6.5186744890866066e-13,
	2.2204460492503131e-16, 6.1728400169158704e-14,
	-6.3837823915946501e-14}, /* L960 */
{6.1335860617206910e+00, 6.5440708407749071e-13,
	2.2204460492503131e-16, -4.2188474935755949e-14,
	-1.3622436512150671e-13}, /* L961 */
{5.7419450410871500e+00, 6.1325944322732084e-13,
	2.2204460492503131e-16, -4.3332004651119860e-13,
	-2.2770674235061961e-13}, /* L962 */
{6.4761176274904235e+00, 6.9239058930747888e-13,
	2.2204460492503131e-16, 6.6613381477509392e-14,
	5.0648374383399641e-13}, /* L963 */
{5.2842334456957394e+00, 5.6554760874405474e-13,
	2.2204460492503131e-16, -2.0439205883349132e-13,
	-1.0547118733938987e-13}, /* L964 */
{6.9018148828218333e+00, 7.3943628997596988e-13,
	2.2204460492503131e-16, -1.1624035067825389e-13,
	2.8044233602031454e-13}, /* L965 */
{5.8033138160706299e+00, 6.2239102760486276e-13,
	2.2204460492503131e-16, -6.7146288529329468e-13,
	-2.7422508708241367e-14}, /* L966 */
{7.3660821680963160e+00, 7.9081186044049900e-13,
	2.2204460492503131e-16, 1.3300471835009375e-13,
	2.1360690993788012e-13}, /* L967 */
{6.4925116581854301e+00, 6.9774741540129526e-13,
	2.2204460492503131e-16, -4.2765790908561030e-13,
	1.6875389974302379e-13}, /* L968 */
{5.7084634995950481e+00, 6.1411986607140534e-13,
	2.2204460492503131e-16, -4.5641268542340185e-13,
	-3.9779290972319359e-13}, /* L969 */
{6.9384034806582662e+00, 7.4720785114834598e-13,
	2.2204460492503131e-16, 1.8429702208777599e-14,
	2.3026025530725747e-13}, /* L970 */
{6.5687449065401884e+00, 7.0812800068154047e-13,
	2.2204460492503131e-16, 3.3595348725157237e-13,
	-9.3069996154326873e-13}, /* L971 */
{5.8868324794816296e+00, 6.3526961469051457e-13,
	2.2204460492503131e-16, 7.2875039336395275e-13,
	-1.0487166690609229e-12}, /* L972 */
{7.8915740700310826e+00, 8.5248474945842645e-13,
	2.2204460492503131e-16, -2.3903101720179620e-13,
	-1.8807178037150152e-13}, /* L973 */
{5.2992823977846522e+00, 5.7304161416027455e-13,
	2.2204460492503131e-16, -8.4809936851115708e-13,
	-8.0846440653203899e-13}, /* L974 */
{7.8897452030801762e+00, 8.5403906169290167e-13,
	2.2204460492503131e-16, -4.7895021282329253e-13,
	1.0214051826551440e-14}, /* L975 */
{5.5701855652531194e+00, 6.0357274733746635e-13,
	2.2204460492503131e-16, -1.5420997812043424e-13,
	5.4400928206632670e-14}, /* L976 */
{8.8536353826019187e+00, 9.6034291630076041e-13,
	2.2204460492503131e-16, 7.2830630415410269e-14,
	2.6645352591003757e-14}, /* L977 */
{7.4910547015443365e+00, 8.1337714341600531e-13,
	2.2204460492503131e-16, -1.8041124150158794e-13,
	-1.5976109324356003e-13}, /* L978 */
{6.9984692553917132e+00, 7.6066930532192600e-13,
	2.2204460492503131e-16, 9.5701224722688494e-14,
	9.5146113210375916e-13}, /* L979 */
{5.6237256397473212e+00, 6.1187166444653940e-13,
	2.2204460492503131e-16, -1.4513945600924671e-12,
	1.7341683644644945e-12}, /* L980 */
{6.8144764189416032e+00, 7.4218409196191715e-13,
	2.2204460492503131e-16, 3.3084646133829665e-14,
	7.1054273576010019e-14}, /* L981 */
{6.8194387671740184e+00, 7.4348166512194780e-13,
	2.2204460492503131e-16, 3.8768988019910466e-13,
	1.0855760734784781e-12}, /* L982 */
{6.1744671832417808e+00, 6.7384986479623876e-13,
	2.2204460492503131e-16, -1.1679546219056647e-13,
	1.3034018309099338e-13}, /* L983 */
{6.6580298167526362e+00, 7.2736261458317131e-13,
	2.2204460492503131e-16, -2.4358293160275934e-13,
	-3.3195668436292181e-14}, /* L984 */
{6.9218288265079506e+00, 7.5695005818943173e-13,
	2.2204460492503131e-16, -5.2785553705803068e-12,
	1.2372325386422744e-12}, /* L985 */
{8.8133892261460289e+00, 9.6478380839926103e-13,
	2.2204460492503131e-16, -2.9298785619857881e-13,
	-9.4368957093138306e-14}, /* L986 */
{7.7326510239734114e+00, 8.4733609018172729e-13,
	2.2204460492503131e-16, -1.3389289676979388e-13,
	1.5210055437364645e-13}, /* L987 */
{6.5222685401886586e+00, 7.1542771706845087e-13,
	2.2204460492503131e-16, 1.2811973704174306e-13,
	3.2640556923979602e-14}, /* L988 */
{9.8710839194041888e+00, 1.0838552277903091e-12,
	2.2204460492503131e-16, -5.1725290717286043e-13,
	5.0848214527832170e-13}, /* L989 */
{6.3823245374172632e+00, 7.0149441810940516e-13,
	2.2204460492503131e-16, 2.0516921495072893e-13,
	3.2551739082009590e-13}, /* L990 */
{6.0630688482802162e+00, 6.6707750434602531e-13,
	2.2204460492503131e-16, -3.6415315207705135e-13,
	5.9574567501385900e-13}, /* L991 */
{6.6491949080503927e+00, 7.3230310704275325e-13,
	2.2204460492503131e-16, 3.1996627569697011e-13,
	1.2234657731369225e-13}, /* L992 */
{7.4598454327789847e+00, 8.2241158327889252e-13,
	2.2204460492503131e-16, 6.7812422344104561e-13,
	4.6185277824406512e-14}, /* L993 */
{8.9547302012872230e+00, 9.8820951421885184e-13,
	2.2204460492503131e-16, -1.5176748746625890e-12,
	2.4202861936828413e-14}, /* L994 */
{6.8987451292889022e+00, 7.6208483967832308e-13,
	2.2204460492503131e-16, -4.3742787170231168e-14,
	3.8413716652030416e-14}, /* L995 */
{5.9713867632325286e+00, 6.6030514389581185e-13,
	2.2204460492503131e-16, -9.8809849191638932e-15,
	1.8718360195180139e-13}, /* L996 */
{5.5250763554684852e+00, 6.1156635311476748e-13,
	2.2204460492503131e-16, -1.3222756223285614e-13,
	1.8895995879120164e-13}, /* L997 */
{6.2720453707206296e+00, 6.9494410226411674e-13,
	2.2204460492503131e-16, -4.5630166312093934e-14,
	-1.0880185641326534e-13}, /* L998 */
{8.0370386804875285e+00, 8.9139806647153819e-13,
	2.2204460492503131e-16, -3.5416114485542494e-14,
	-4.7517545453956700e-14}, /* L999 */
{7.2375014799653465e+00, 8.0352391407245705e-13,
	2.2204460492503131e-16, -3.5860203695392556e-14,
	-1.8474111129762605e-13}, /* L1000 */
{1.0704751534462535e+01, 2.3769319845712289e-12,
	2.2204460492503131e-16, -5.1324500205396362e-12,
	2.5088819910479288e-12}, /* L1001 */
{1.9969666668716467e+01, 6.6512351182268503e-12,
	2.2204460492503131e-16, -7.0245698147175517e-11,
	9.7082342165322189e-12}, /* L1002 */
{2.5142056782565259e+01, 1.1209977390791437e-11,
	2.2204460492503131e-16, 5.4001247917767614e-13,
	-5.6191717945353048e-12}, /* L1003 */
{2.8323200010548174e+01, 1.5722534385531617e-11,
	2.2204460492503131e-16, -3.7680969455777813e-12,
	-3.6082248300317588e-12}, /* L1004 */
{3.2321791678561532e+01, 2.1530638383282508e-11,
	2.2204460492503131e-16, 1.4333201292515696e-11,
	6.5796257331385277e-12}, /* L1005 */
{3.7391747446514401e+01, 2.9125646339167588e-11,
	2.2204460492503131e-16, -2.7823965353945823e-11,
	-1.8096635301390052e-11}, /* L1006 */
{3.5997876224631987e+01, 3.2108420089382861e-11,
	2.2204460492503131e-16, 1.3131717935266352e-11,
	1.3136158827364852e-11}, /* L1007 */
{4.6061583130257695e+01, 4.6024767330621330e-11,
	2.2204460492503131e-16, -8.7482243671388460e-11,
	9.2451313271624258e-10}, /* L1008 */
{6.2174100014595624e+01, 6.9027117355346945e-11,
	2.2204460492503131e-16, -4.0004777268620728e-11,
	1.7784218542260533e-11}, /* L1009 */#else  /* }  { */

/* Start of SP golden values */


{, 0.0000000000000000e+00,
	0.0000000000000000e+00, 0.0000000000000000e+00,
	0.0000000000000000e+00, /* L1010 */
{0.0000000000000000e+00, 0.0000000000000000e+00,
	1.1920928955078125e-07, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L1011 */
{0.0000000000000000e+00, 0.0000000000000000e+00,
	1.1920928955078125e-07, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L1012 */
{6.8018096685409546e-01, 1.1920928955078125e-07,
	1.1920928955078125e-07, -5.9604644775390625e-08,
	-1.1920928955078125e-07}, /* L1013 */
{8.9273703098297119e-01, 2.0861625671386719e-07,
	1.1920928955078125e-07, -1.1920928955078125e-07,
	-2.3841857910156250e-07}, /* L1014 */
{7.1418994665145874e-01, 2.0861625671386719e-07,
	1.1920928955078125e-07, -5.9604644775390625e-08,
	1.1920928955078125e-07}, /* L1015 */
{3.6134567856788635e-01, 1.2665987014770508e-07,
	1.1920928955078125e-07, 2.3841857910156250e-07,
	7.1525573730468750e-07}, /* L1016 */
{4.3648514151573181e-01, 1.7881393432617188e-07,
	1.1920928955078125e-07, -5.9604644775390625e-08,
	3.5762786865234375e-07}, /* L1017 */
{4.7549185156822205e-01, 2.2351741790771484e-07,
	1.1920928955078125e-07, 3.6954879760742188e-06,
	-5.9604644775390625e-07}, /* L1018 */
{4.2266038060188293e-01, 2.2351741790771484e-07,
	1.1920928955078125e-07, 4.7683715820312500e-07,
	8.3446502685546875e-07}, /* L1019 */
{4.0575435757637024e-01, 2.3841857910156250e-07,
	1.1920928955078125e-07, 3.5762786865234375e-07,
	3.5762786865234375e-07}, /* L1020 */
{3.2275927066802979e-01, 2.0861625671386719e-07,
	1.1920928955078125e-07, -1.1920928955078125e-07,
	1.1920928955078125e-07}, /* L1021 */
{2.9586255550384521e-01, 2.0861625671386719e-07,
	1.1920928955078125e-07, -1.1920928955078125e-07,
	-2.3841857910156250e-07}, /* L1022 */
{7.8410917520523071e-01, 6.0349702835083008e-07,
	1.1920928955078125e-07, 7.1525573730468750e-07,
	-7.1525573730468750e-07}, /* L1023 */
{3.5955643653869629e-01, 2.9802322387695312e-07,
	1.1920928955078125e-07, -3.5762786865234375e-07,
	-3.5762786865234375e-07}, /* L1024 */
{4.0270313620567322e-01, 3.5762786865234375e-07,
	1.1920928955078125e-07, -2.3841857910156250e-07,
	3.5762786865234375e-07}, /* L1025 */
{2.9888099431991577e-01, 2.8312206268310547e-07,
	1.1920928955078125e-07, -7.1525573730468750e-07,
	-1.1920928955078125e-07}, /* L1026 */
{5.8850812911987305e-01, 5.9232115745544434e-07,
	1.1920928955078125e-07, -1.7285346984863281e-06,
	3.5762786865234375e-07}, /* L1027 */
{5.0337857007980347e-01, 5.3644180297851562e-07,
	1.1920928955078125e-07, -4.7683715820312500e-07,
	-4.7683715820312500e-07}, /* L1028 */
{4.5867058634757996e-01, 5.1595270633697510e-07,
	1.1920928955078125e-07, 7.1525573730468750e-07,
	-1.2516975402832031e-06}, /* L1029 */
{4.7820881009101868e-01, 5.6624412536621094e-07,
	1.1920928955078125e-07, 0.0000000000000000e+00,
	-1.0728836059570312e-06}, /* L1030 */
{9.7883027791976929e-01, 1.2218952178955078e-06,
	1.1920928955078125e-07, 8.3446502685546875e-07,
	2.3841857910156250e-07}, /* L1031 */
{4.2159116268157959e-01, 5.5134296417236328e-07,
	1.1920928955078125e-07, -2.6822090148925781e-06,
	-8.9406967163085938e-07}, /* L1032 */
{5.0135254859924316e-01, 6.8545341491699219e-07,
	1.1920928955078125e-07, 1.1920928955078125e-07,
	-1.7881393432617188e-07}, /* L1033 */
{1.0027021169662476e+00, 1.4305114746093750e-06,
	1.1920928955078125e-07, -3.6954879760742188e-06,
	-2.3841857910156250e-07}, /* L1034 */
{7.2194659709930420e-01, 1.0728836059570312e-06,
	1.1920928955078125e-07, -5.3644180297851562e-07,
	4.7683715820312500e-07}, /* L1035 */
{3.9529633522033691e-01, 6.1094760894775391e-07,
	1.1920928955078125e-07, -1.6093254089355469e-06,
	1.1920928955078125e-07}, /* L1036 */
{5.9419322013854980e-01, 9.5367431640625000e-07,
	1.1920928955078125e-07, 2.2649765014648438e-06,
	0.0000000000000000e+00}, /* L1037 */
{5.9087789058685303e-01, 9.8347663879394531e-07,
	1.1920928955078125e-07, 2.2649765014648438e-06,
	-2.9802322387695312e-06}, /* L1038 */
{6.3101136684417725e-01, 1.0877847671508789e-06,
	1.1920928955078125e-07, 2.3841857910156250e-07,
	1.1920928955078125e-06}, /* L1039 */
{1.1363973617553711e+00, 2.0265579223632812e-06,
	1.1920928955078125e-07, -5.9604644775390625e-07,
	2.3841857910156250e-07}, /* L1040 */
{5.0943696498870850e-01, 9.3877315521240234e-07,
	1.1920928955078125e-07, 2.8610229492187500e-06,
	-3.1590461730957031e-06}, /* L1041 */
{9.7332048416137695e-01, 1.8514692783355713e-06,
	1.1920928955078125e-07, -5.9604644775390625e-07,
	7.2717666625976562e-06}, /* L1042 */
{8.8116312026977539e-01, 1.7285346984863281e-06,
	1.1920928955078125e-07, 1.0728836059570312e-06,
	-1.0132789611816406e-06}, /* L1043 */
{1.0469392538070679e+00, 2.1159648895263672e-06,
	1.1920928955078125e-07, 0.0000000000000000e+00,
	-1.7285346984863281e-06}, /* L1044 */
{6.3979321718215942e-01, 1.3336539268493652e-06,
	1.1920928955078125e-07, -1.1920928955078125e-07,
	1.4305114746093750e-06}, /* L1045 */
{9.8686885833740234e-01, 2.1159648895263672e-06,
	1.1920928955078125e-07, 2.7179718017578125e-05,
	-2.1398067474365234e-05}, /* L1046 */
{5.1392030715942383e-01, 1.1324882507324219e-06,
	1.1920928955078125e-07, 3.0994415283203125e-06,
	-1.0728836059570312e-06}, /* L1047 */
{5.0039225816726685e-01, 1.1324882507324219e-06,
	1.1920928955078125e-07, 4.2915344238281250e-06,
	1.1920928955078125e-07}, /* L1048 */
{8.0833417177200317e-01, 1.8775463104248047e-06,
	1.1920928955078125e-07, 9.5367431640625000e-07,
	-4.7683715820312500e-07}, /* L1049 */
{6.4095199108123779e-01, 1.5273690223693848e-06,
	1.1920928955078125e-07, -9.3042850494384766e-05,
	2.2375583648681641e-04}, /* L1050 */
{1.0251988172531128e+00, 2.5033950805664062e-06,
	1.1920928955078125e-07, -2.5629997253417969e-06,
	-2.5629997253417969e-06}, /* L1051 */
{7.3866742849349976e-01, 1.8477439880371094e-06,
	1.1920928955078125e-07, -3.5762786865234375e-07,
	1.0728836059570312e-06}, /* L1052 */
{1.1637136936187744e+00, 2.9802322387695312e-06,
	1.1920928955078125e-07, 1.9073486328125000e-06,
	-9.5367431640625000e-07}, /* L1053 */
{6.5105575323104858e-01, 1.7061829566955566e-06,
	1.1920928955078125e-07, -1.5676021575927734e-05,
	1.1682510375976562e-05}, /* L1054 */
{8.4511369466781616e-01, 2.2649765014648438e-06,
	1.1920928955078125e-07, -4.7683715820312500e-07,
	-6.1392784118652344e-06}, /* L1055 */
{1.0660614967346191e+00, 2.9206275939941406e-06,
	1.1920928955078125e-07, -5.5432319641113281e-06,
	-1.7881393432617188e-06}, /* L1056 */
{1.0486901998519897e+00, 2.9355287551879883e-06,
	1.1920928955078125e-07, 1.1920928955078125e-07,
	-6.5565109252929688e-07}, /* L1057 */
{8.1313973665237427e-01, 2.3245811462402344e-06,
	1.1920928955078125e-07, 2.2649765014648438e-06,
	7.1525573730468750e-07}, /* L1058 */
{1.0204066038131714e+00, 2.9802322387695312e-06,
	1.1920928955078125e-07, 1.0013580322265625e-05,
	-3.5762786865234375e-07}, /* L1059 */
{8.1000715494155884e-01, 2.4139881134033203e-06,
	1.1920928955078125e-07, -1.7881393432617188e-06,
	-3.0398368835449219e-06}, /* L1060 */
{9.7052782773971558e-01, 2.9504299163818359e-06,
	1.1920928955078125e-07, 6.0796737670898438e-06,
	-2.6702880859375000e-05}, /* L1061 */
{6.6346895694732666e-01, 2.0563602447509766e-06,
	1.1920928955078125e-07, -1.0728836059570312e-06,
	-1.1324882507324219e-06}, /* L1062 */
{8.2547765970230103e-01, 2.6077032089233398e-06,
	1.1920928955078125e-07, 7.1525573730468750e-07,
	7.1525573730468750e-07}, /* L1063 */
{1.0555671453475952e+00, 3.3974647521972656e-06,
	1.1920928955078125e-07, 3.5762786865234375e-07,
	-7.1525573730468750e-07}, /* L1064 */
{6.0000658035278320e-01, 1.9669532775878906e-06,
	1.1920928955078125e-07, -1.0132789611816406e-06,
	-5.9604644775390625e-08}, /* L1065 */
{6.0714846849441528e-01, 2.0265579223632812e-06,
	1.1920928955078125e-07, -5.8412551879882812e-06,
	-1.4305114746093750e-06}, /* L1066 */
{6.2719875574111938e-01, 2.1308660507202148e-06,
	1.1920928955078125e-07, -3.4570693969726562e-06,
	-8.3446502685546875e-07}, /* L1067 */
{7.5642675161361694e-01, 2.6151537895202637e-06,
	1.1920928955078125e-07, -3.0875205993652344e-05,
	-1.6927719116210938e-05}, /* L1068 */
{7.1186864376068115e-01, 2.5033950805664062e-06,
	1.1920928955078125e-07, -4.4107437133789062e-06,
	-4.2319297790527344e-06}, /* L1069 */
{5.5729919672012329e-01, 1.9930303096771240e-06,
	1.1920928955078125e-07, 5.9604644775390625e-07,
	1.0728836059570312e-06}, /* L1070 */
{9.2214035987854004e-01, 3.3527612686157227e-06,
	1.1920928955078125e-07, -2.3841857910156250e-07,
	2.3841857910156250e-06}, /* L1071 */
{1.1209777593612671e+00, 4.1425228118896484e-06,
	1.1920928955078125e-07, -8.3446502685546875e-07,
	-3.3378601074218750e-06}, /* L1072 */
{8.2143312692642212e-01, 3.0845403671264648e-06,
	1.1920928955078125e-07, 2.0265579223632812e-06,
	1.4305114746093750e-06}, /* L1073 */
{9.1016262769699097e-01, 3.4719705581665039e-06,
	1.1920928955078125e-07, 4.7683715820312500e-07,
	-7.2121620178222656e-06}, /* L1074 */
{8.4808546304702759e-01, 3.2857060432434082e-06,
	1.1920928955078125e-07, 3.8146972656250000e-06,
	-1.7285346984863281e-06}, /* L1075 */
{7.8788590431213379e-01, 3.0994415283203125e-06,
	1.1920928955078125e-07, -4.7087669372558594e-06,
	2.0265579223632812e-06}, /* L1076 */
{8.2463252544403076e-01, 3.2931566238403320e-06,
	1.1920928955078125e-07, -2.3841857910156250e-07,
	-1.9073486328125000e-06}, /* L1077 */
{8.6029779911041260e-01, 3.4868717193603516e-06,
	1.1920928955078125e-07, 1.5497207641601562e-06,
	1.9073486328125000e-06}, /* L1078 */
{8.8033676147460938e-01, 3.6209821701049805e-06,
	1.1920928955078125e-07, -5.0604343414306641e-05,
	-1.2701749801635742e-04}, /* L1079 */
{1.2535502910614014e+00, 5.2303075790405273e-06,
	1.1920928955078125e-07, 8.4638595581054688e-06,
	1.1920928955078125e-06}, /* L1080 */
{9.0141552686691284e-01, 3.8146972656250000e-06,
	1.1920928955078125e-07, 2.2649765014648438e-06,
	3.3378601074218750e-06}, /* L1081 */
{7.7777242660522461e-01, 3.3378601074218750e-06,
	1.1920928955078125e-07, -9.0599060058593750e-06,
	-1.4185905456542969e-05}, /* L1082 */
{1.0034232139587402e+00, 4.3660402297973633e-06,
	1.1920928955078125e-07, -1.0013580322265625e-05,
	2.9802322387695312e-06}, /* L1083 */
{8.9863836765289307e-01, 3.9637088775634766e-06,
	1.1920928955078125e-07, -7.4505805969238281e-06,
	-6.9737434387207031e-06}, /* L1084 */
{1.0266774892807007e+00, 4.5895576477050781e-06,
	1.1920928955078125e-07, 1.6689300537109375e-06,
	-7.7486038208007812e-07}, /* L1085 */
{6.6445106267929077e-01, 3.0100345611572266e-06,
	1.1920928955078125e-07, -2.8014183044433594e-05,
	-2.6226043701171875e-05}, /* L1086 */
{1.2500019073486328e+00, 5.7369470596313477e-06,
	1.1920928955078125e-07, 1.0728836059570312e-06,
	-2.9802322387695312e-07}, /* L1087 */
{1.0576709508895874e+00, 4.9173831939697266e-06,
	1.1920928955078125e-07, 4.7683715820312500e-07,
	1.9669532775878906e-05}, /* L1088 */
{8.0380576848983765e-01, 3.7848949432373047e-06,
	1.1920928955078125e-07, -2.9802322387695312e-07,
	1.3113021850585938e-06}, /* L1089 */
{6.3124734163284302e-01, 3.0100345611572266e-06,
	1.1920928955078125e-07, -7.3313713073730469e-06,
	-4.0531158447265625e-06}, /* L1090 */
{1.2044825553894043e+00, 5.8151781558990479e-06,
	1.1920928955078125e-07, 2.8610229492187500e-06,
	-4.4107437133789062e-06}, /* L1091 */
{8.1098091602325439e-01, 3.9637088775634766e-06,
	1.1920928955078125e-07, 2.6226043701171875e-06,
	-5.0067901611328125e-06}, /* L1092 */
{1.2168718576431274e+00, 6.0200691223144531e-06,
	1.1920928955078125e-07, 1.4305114746093750e-06,
	-1.4901161193847656e-06}, /* L1093 */
{5.6548178195953369e-01, 2.8312206268310547e-06,
	1.1920928955078125e-07, 5.1259994506835938e-06,
	-1.6689300537109375e-06}, /* L1094 */
{1.3882204294204712e+00, 7.0333480834960938e-06,
	1.1920928955078125e-07, 2.8610229492187500e-06,
	1.5497207641601562e-06}, /* L1095 */
{1.7107630968093872e+00, 8.7693333625793457e-06,
	1.1920928955078125e-07, 6.7949295043945312e-06,
	3.0994415283203125e-06}, /* L1096 */
{8.1896400451660156e-01, 4.2468309402465820e-06,
	1.1920928955078125e-07, 5.2452087402343750e-06,
	5.4836273193359375e-06}, /* L1097 */
{7.6276636123657227e-01, 4.0009617805480957e-06,
	1.1920928955078125e-07, 1.5497207641601562e-06,
	2.9802322387695312e-06}, /* L1098 */
{8.0899810791015625e-01, 4.2915344238281250e-06,
	1.1920928955078125e-07, -2.2053718566894531e-06,
	1.1920928955078125e-07}, /* L1099 */
{8.7223005294799805e-01, 4.6789646148681641e-06,
	1.1920928955078125e-07, -2.2649765014648438e-06,
	-1.1920928955078125e-06}, /* L1100 */
{8.2417380809783936e-01, 4.4703483581542969e-06,
	1.1920928955078125e-07, 8.5830688476562500e-06,
	1.2516975402832031e-05}, /* L1101 */
{7.5204324722290039e-01, 4.1238963603973389e-06,
	1.1920928955078125e-07, 1.3113021850585938e-06,
	-5.0663948059082031e-06}, /* L1102 */
{1.4193508625030518e+00, 7.8678131103515625e-06,
	1.1920928955078125e-07, 9.6559524536132812e-06,
	0.0000000000000000e+00}, /* L1103 */
{9.6275132894515991e-01, 5.3942203521728516e-06,
	1.1920928955078125e-07, -6.2584877014160156e-06,
	-3.3974647521972656e-06}, /* L1104 */
{9.3683904409408569e-01, 5.3048133850097656e-06,
	1.1920928955078125e-07, -5.9008598327636719e-06,
	5.3644180297851562e-06}, /* L1105 */
{1.0781044960021973e+00, 6.1690807342529297e-06,
	1.1920928955078125e-07, 7.1525573730468750e-06,
	1.6689300537109375e-06}, /* L1106 */
{1.0644396543502808e+00, 6.1541795730590820e-06,
	1.1920928955078125e-07, -1.3113021850585938e-06,
	3.4570693969726562e-06}, /* L1107 */
{9.8469865322113037e-01, 5.7518482208251953e-06,
	1.1920928955078125e-07, 2.2649765014648438e-06,
	-5.4240226745605469e-06}, /* L1108 */
{1.1337554454803467e+00, 6.6906213760375977e-06,
	1.1920928955078125e-07, -6.7949295043945312e-06,
	9.0599060058593750e-06}, /* L1109 */
{9.7000402212142944e-01, 5.7816505432128906e-06,
	1.1920928955078125e-07, -2.0265579223632812e-06,
	1.0728836059570312e-06}, /* L1110 */
{9.5541024208068848e-01, 5.7518482208251953e-06,
	1.1920928955078125e-07, -3.1709671020507812e-05,
	-8.5830688476562500e-06}, /* L1111 */
{8.3822196722030640e-01, 5.0961971282958984e-06,
	1.1920928955078125e-07, -6.6757202148437500e-06,
	1.7881393432617188e-06}, /* L1112 */
{1.9174509048461914e+00, 1.1771917343139648e-05,
	1.1920928955078125e-07, -5.0663948059082031e-06,
	-2.3245811462402344e-06}, /* L1113 */
{1.0769299268722534e+00, 6.6757202148437500e-06,
	1.1920928955078125e-07, -2.4437904357910156e-06,
	2.8610229492187500e-06}, /* L1114 */
{1.1833299398422241e+00, 7.4058771133422852e-06,
	1.1920928955078125e-07, -8.3446502685546875e-06,
	-1.7285346984863281e-06}, /* L1115 */
{8.6897367238998413e-01, 5.4910778999328613e-06,
	1.1920928955078125e-07, 2.3961067199707031e-05,
	-4.7624111175537109e-05}, /* L1116 */
{1.0105159282684326e+00, 6.4447522163391113e-06,
	1.1920928955078125e-07, -5.5432319641113281e-06,
	-1.4901161193847656e-06}, /* L1117 */
{1.2222226858139038e+00, 7.8678131103515625e-06,
	1.1920928955078125e-07, -9.9539756774902344e-06,
	-1.0073184967041016e-05}, /* L1118 */
{9.9771076440811157e-01, 6.4820051193237305e-06,
	1.1920928955078125e-07, 6.6757202148437500e-06,
	3.8146972656250000e-06}, /* L1119 */
{8.5909843444824219e-01, 5.6326389312744141e-06,
	1.1920928955078125e-07, 1.7881393432617188e-06,
	-1.6689300537109375e-06}, /* L1120 */
{1.0945979356765747e+00, 7.2419643402099609e-06,
	1.1920928955078125e-07, 1.7881393432617188e-06,
	4.7683715820312500e-06}, /* L1121 */
{9.4642227888107300e-01, 6.3180923461914062e-06,
	1.1920928955078125e-07, -9.1791152954101562e-06,
	7.2717666625976562e-06}, /* L1122 */
{9.4248169660568237e-01, 6.3478946685791016e-06,
	1.1920928955078125e-07, -1.5497207641601562e-06,
	-7.8678131103515625e-06}, /* L1123 */
{1.0350898504257202e+00, 7.0333480834960938e-06,
	1.1920928955078125e-07, 1.4305114746093750e-06,
	-6.0200691223144531e-06}, /* L1124 */
{1.2651975154876709e+00, 8.6724758148193359e-06,
	1.1920928955078125e-07, -1.4424324035644531e-05,
	1.0013580322265625e-05}, /* L1125 */
{9.2753994464874268e-01, 6.4130872488021851e-06,
	1.1920928955078125e-07, -2.0265579223632812e-06,
	-4.7683715820312500e-06}, /* L1126 */
{1.3073544502258301e+00, 9.1195106506347656e-06,
	1.1920928955078125e-07, 7.1644783020019531e-05,
	6.3896179199218750e-05}, /* L1127 */
{9.6987730264663696e-01, 6.8247318267822266e-06,
	1.1920928955078125e-07, 3.6954879760742188e-06,
	-5.2165985107421875e-04}, /* L1128 */
{9.7899848222732544e-01, 6.9439411163330078e-06,
	1.1920928955078125e-07, 2.0265579223632812e-06,
	-5.4836273193359375e-06}, /* L1129 */
{8.6979395151138306e-01, 6.2212347984313965e-06,
	1.1920928955078125e-07, 1.4305114746093750e-06,
	-1.5497207641601562e-06}, /* L1130 */
{9.7924292087554932e-01, 7.0631504058837891e-06,
	1.1920928955078125e-07, -4.1127204895019531e-05,
	1.7762184143066406e-05}, /* L1131 */
{9.7541624307632446e-01, 7.0929527282714844e-06,
	1.1920928955078125e-07, -7.6293945312500000e-06,
	-1.0728836059570312e-06}, /* L1132 */
{1.6664739847183228e+00, 1.2218952178955078e-05,
	1.1920928955078125e-07, -1.9609928131103516e-05,
	-1.3291835784912109e-05}, /* L1133 */
{8.2053667306900024e-01, 6.0647726058959961e-06,
	1.1920928955078125e-07, -1.8298625946044922e-05,
	-2.4974346160888672e-05}, /* L1134 */
{1.2599431276321411e+00, 9.3877315521240234e-06,
	1.1920928955078125e-07, 1.0609626770019531e-05,
	3.5762786865234375e-07}, /* L1135 */
{1.3730195760726929e+00, 1.0311603546142578e-05,
	1.1920928955078125e-07, -1.5497207641601562e-06,
	-1.9669532775878906e-06}, /* L1136 */
{1.4950799942016602e+00, 1.1317431926727295e-05,
	1.1920928955078125e-07, -1.1920928955078125e-07,
	-2.9802322387695312e-06}, /* L1137 */
{8.7696063518524170e-01, 6.6906213760375977e-06,
	1.1920928955078125e-07, 3.9339065551757812e-06,
	0.0000000000000000e+00}, /* L1138 */
{9.5106983184814453e-01, 7.3127448558807373e-06,
	1.1920928955078125e-07, -5.5432319641113281e-06,
	-6.6161155700683594e-06}, /* L1139 */
{9.4996523857116699e-01, 7.3611736297607422e-06,
	1.1920928955078125e-07, 9.1791152954101562e-06,
	-3.5166740417480469e-06}, /* L1140 */
{1.2995917797088623e+00, 1.0147690773010254e-05,
	1.1920928955078125e-07, 1.2397766113281250e-05,
	-2.5868415832519531e-05}, /* L1141 */
{7.4620795249938965e-01, 5.8710575103759766e-06,
	1.1920928955078125e-07, 9.5367431640625000e-07,
	-2.0861625671386719e-06}, /* L1142 */
{1.1202967166900635e+00, 8.8810920715332031e-06,
	1.1920928955078125e-07, -2.9802322387695312e-07,
	-8.5234642028808594e-06}, /* L1143 */
{1.3694064617156982e+00, 1.0937452316284180e-05,
	1.1920928955078125e-07, 5.0067901611328125e-06,
	-6.6161155700683594e-06}, /* L1144 */
{1.0537055730819702e+00, 8.4787607192993164e-06,
	1.1920928955078125e-07, -2.8610229492187500e-06,
	-4.7087669372558594e-06}, /* L1145 */
{1.2646913528442383e+00, 1.0251998901367188e-05,
	1.1920928955078125e-07, -1.2874603271484375e-05,
	-3.1590461730957031e-06}, /* L1146 */
{1.2353997230529785e+00, 1.0088086128234863e-05,
	1.1920928955078125e-07, 2.9802322387695312e-06,
	0.0000000000000000e+00}, /* L1147 */
{1.0905735492706299e+00, 8.9704990386962891e-06,
	1.1920928955078125e-07, -1.7642974853515625e-05,
	-1.9550323486328125e-05}, /* L1148 */
{1.2841809988021851e+00, 1.0639429092407227e-05,
	1.1920928955078125e-07, -2.2053718566894531e-06,
	-3.3378601074218750e-06}, /* L1149 */
{1.1500061750411987e+00, 9.5963478088378906e-06,
	1.1920928955078125e-07, 5.1259994506835938e-06,
	-4.1723251342773438e-07}, /* L1150 */
{1.3510324954986572e+00, 1.1354684829711914e-05,
	1.1920928955078125e-07, 1.2159347534179688e-05,
	1.5377998352050781e-05}, /* L1151 */
{9.4499003887176514e-01, 7.9981982707977295e-06,
	1.1920928955078125e-07, -8.1062316894531250e-06,
	-1.0132789611816406e-06}, /* L1152 */
{1.3810083866119385e+00, 1.1771917343139648e-05,
	1.1920928955078125e-07, 2.1457672119140625e-06,
	4.3511390686035156e-05}, /* L1153 */
{1.1562519073486328e+00, 9.9241733551025391e-06,
	1.1920928955078125e-07, 2.3841857910156250e-07,
	9.2983245849609375e-06}, /* L1154 */
{1.0793009996414185e+00, 9.3281269073486328e-06,
	1.1920928955078125e-07, -1.0728836059570312e-05,
	-1.5497207641601562e-06}, /* L1155 */
{1.6061439514160156e+00, 1.3977289199829102e-05,
	1.1920928955078125e-07, 8.8214874267578125e-06,
	2.2649765014648438e-06}, /* L1156 */
{1.0843659639358521e+00, 9.5013529062271118e-06,
	1.1920928955078125e-07, -4.5716762542724609e-05,
	-7.1525573730468750e-06}, /* L1157 */
{1.2195807695388794e+00, 1.0758638381958008e-05,
	1.1920928955078125e-07, 1.1086463928222656e-05,
	-5.5432319641113281e-06}, /* L1158 */
{1.0805189609527588e+00, 9.5963478088378906e-06,
	1.1920928955078125e-07, -5.7816505432128906e-06,
	-5.5432319641113281e-06}, /* L1159 */
{1.2214741706848145e+00, 1.0922551155090332e-05,
	1.1920928955078125e-07, 4.6491622924804688e-06,
	3.4809112548828125e-05}, /* L1160 */
{9.9667584896087646e-01, 8.9704990386962891e-06,
	1.1920928955078125e-07, -2.3365020751953125e-05,
	-1.6868114471435547e-05}, /* L1161 */
{1.1175954341888428e+00, 1.0125339031219482e-05,
	1.1920928955078125e-07, 1.0728836059570312e-06,
	-2.3841857910156250e-06}, /* L1162 */
{1.5759546756744385e+00, 1.4372169971466064e-05,
	1.1920928955078125e-07, -7.0333480834960938e-06,
	-1.6748905181884766e-05}, /* L1163 */
{1.2970726490020752e+00, 1.1906027793884277e-05,
	1.1920928955078125e-07, 8.2254409790039062e-06,
	1.3113021850585938e-06}, /* L1164 */
{1.3951190710067749e+00, 1.2889504432678223e-05,
	1.1920928955078125e-07, 2.3841857910156250e-07,
	3.2186508178710938e-05}, /* L1165 */
{1.2964704036712646e+00, 1.2055039405822754e-05,
	1.1920928955078125e-07, 1.5139579772949219e-05,
	-1.1920928955078125e-06}, /* L1166 */
{1.0063484907150269e+00, 9.4175338745117188e-06,
	1.1920928955078125e-07, -6.7949295043945312e-06,
	-2.3782253265380859e-05}, /* L1167 */
{9.6187907457351685e-01, 9.0599060058593750e-06,
	1.1920928955078125e-07, -7.9274177551269531e-06,
	-2.8252601623535156e-05}, /* L1168 */
{1.5304667949676514e+00, 1.4506280422210693e-05,
	1.1920928955078125e-07, 6.9260597229003906e-05,
	-3.3318996429443359e-05}, /* L1169 */
{1.2531182765960693e+00, 1.1950731277465820e-05,
	1.1920928955078125e-07, -4.2319297790527344e-06,
	-8.0466270446777344e-06}, /* L1170 */
{1.0869301557540894e+00, 1.0430812835693359e-05,
	1.1920928955078125e-07, -4.5299530029296875e-06,
	1.6331672668457031e-05}, /* L1171 */
{9.2123973369598389e-01, 8.8959932327270508e-06,
	1.1920928955078125e-07, 2.6345252990722656e-05,
	1.5497207641601562e-06}, /* L1172 */
{1.2883348464965820e+00, 1.2516975402832031e-05,
	1.1920928955078125e-07, -1.9252300262451172e-05,
	-8.9406967163085938e-07}, /* L1173 */
{7.4848139286041260e-01, 7.3164701461791992e-06,
	1.1920928955078125e-07, -2.7418136596679688e-06,
	2.3841857910156250e-07}, /* L1174 */
{1.0303035974502563e+00, 1.0132789611816406e-05,
	1.1920928955078125e-07, -3.9339065551757812e-06,
	2.0265579223632812e-06}, /* L1175 */
{1.1414912939071655e+00, 1.1295080184936523e-05,
	1.1920928955078125e-07, 7.2717666625976562e-06,
	8.0943107604980469e-05}, /* L1176 */
{1.5194602012634277e+00, 1.5124678611755371e-05,
	1.1920928955078125e-07, 2.6226043701171875e-06,
	-7.7486038208007812e-06}, /* L1177 */
{1.0238080024719238e+00, 1.0251998901367188e-05,
	1.1920928955078125e-07, 2.7418136596679688e-06,
	-3.1590461730957031e-06}, /* L1178 */
{1.1346142292022705e+00, 1.1429190635681152e-05,
	1.1920928955078125e-07, -7.5101852416992188e-06,
	1.6331672668457031e-05}, /* L1179 */
{1.1793857812881470e+00, 1.1950731277465820e-05,
	1.1920928955078125e-07, -1.6629695892333984e-05,
	-1.3232231140136719e-05}, /* L1180 */
{1.6403435468673706e+00, 1.6719102859497070e-05,
	1.1920928955078125e-07, 3.6954879760742188e-06,
	-3.3974647521972656e-06}, /* L1181 */
{1.7790050506591797e+00, 1.8239021301269531e-05,
	1.1920928955078125e-07, -3.5166740417480469e-06,
	-7.7486038208007812e-07}, /* L1182 */
{1.4508632421493530e+00, 1.4960765838623047e-05,
	1.1920928955078125e-07, -7.3909759521484375e-06,
	-4.1723251342773438e-06}, /* L1183 */
{1.5513389110565186e+00, 1.6093254089355469e-05,
	1.1920928955078125e-07, -6.1690807342529297e-05,
	6.1869621276855469e-05}, /* L1184 */
{1.2285547256469727e+00, 1.2814998626708984e-05,
	1.1920928955078125e-07, -1.9431114196777344e-05,
	2.0623207092285156e-05}, /* L1185 */
{1.1248027086257935e+00, 1.1801719665527344e-05,
	1.1920928955078125e-07, 4.4107437133789062e-05,
	-1.8775463104248047e-05}, /* L1186 */
{1.0338598489761353e+00, 1.0907649993896484e-05,
	1.1920928955078125e-07, -2.4080276489257812e-05,
	2.3841857910156250e-07}, /* L1187 */
{8.8742196559906006e-01, 9.4175338745117188e-06,
	1.1920928955078125e-07, -4.1007995605468750e-05,
	-4.6312808990478516e-05}, /* L1188 */
{1.2569568157196045e+00, 1.3411045074462891e-05,
	1.1920928955078125e-07, -8.0466270446777344e-06,
	1.7642974853515625e-05}, /* L1189 */
{1.0193126201629639e+00, 1.0937452316284180e-05,
	1.1920928955078125e-07, -3.6358833312988281e-06,
	5.1140785217285156e-05}, /* L1190 */
{1.2982742786407471e+00, 1.4007091522216797e-05,
	1.1920928955078125e-07, -1.6629695892333984e-05,
	-8.1062316894531250e-06}, /* L1191 */
{1.0288227796554565e+00, 1.1160969734191895e-05,
	1.1920928955078125e-07, 7.0333480834960938e-06,
	1.4305114746093750e-06}, /* L1192 */
{1.3306066989898682e+00, 1.4513731002807617e-05,
	1.1920928955078125e-07, 8.9406967163085938e-06,
	9.5367431640625000e-07}, /* L1193 */
{1.0203016996383667e+00, 1.1190772056579590e-05,
	1.1920928955078125e-07, -1.9669532775878906e-06,
	2.0265579223632812e-05}, /* L1194 */
{1.1182178258895874e+00, 1.2330710887908936e-05,
	1.1920928955078125e-07, -7.9274177551269531e-06,
	-3.2186508178710938e-06}, /* L1195 */
{1.2682054042816162e+00, 1.4066696166992188e-05,
	1.1920928955078125e-07, 1.9752979278564453e-04,
	1.2481212615966797e-04}, /* L1196 */
{1.1684124469757080e+00, 1.3023614883422852e-05,
	1.1920928955078125e-07, -3.2961368560791016e-05,
	-7.0333480834960938e-06}, /* L1197 */
{1.3009834289550781e+00, 1.4580786228179932e-05,
	1.1920928955078125e-07, -3.2722949981689453e-05,
	-5.5491924285888672e-05}, /* L1198 */
{1.6348913908004761e+00, 1.8417835235595703e-05,
	1.1920928955078125e-07, -3.5762786865234375e-06,
	2.9802322387695312e-06}, /* L1199 */
{1.6420391798019409e+00, 1.8596649169921875e-05,
	1.1920928955078125e-07, -2.4318695068359375e-05,
	2.7537345886230469e-05}, /* L1200 */
{9.4108945131301880e-01, 1.0713934898376465e-05,
	1.1920928955078125e-07, 1.5974044799804688e-05,
	1.3232231140136719e-05}, /* L1201 */
{9.9413573741912842e-01, 1.1377036571502686e-05,
	1.1920928955078125e-07, 5.6028366088867188e-06,
	1.9073486328125000e-06}, /* L1202 */
{1.2357484102249146e+00, 1.4215707778930664e-05,
	1.1920928955078125e-07, 6.6757202148437500e-06,
	-2.3841857910156250e-07}, /* L1203 */
{1.6301261186599731e+00, 1.8849968910217285e-05,
	1.1920928955078125e-07, 1.4662742614746094e-05,
	2.6226043701171875e-06}, /* L1204 */
{1.0974243879318237e+00, 1.2755393981933594e-05,
	1.1920928955078125e-07, 4.2915344238281250e-06,
	2.3961067199707031e-05}, /* L1205 */
{1.0510134696960449e+00, 1.2278556823730469e-05,
	1.1920928955078125e-07, 5.4836273193359375e-06,
	2.3841857910156250e-06}, /* L1206 */
{1.4908643960952759e+00, 1.7508864402770996e-05,
	1.1920928955078125e-07, 7.8082084655761719e-05,
	-3.7074089050292969e-05}, /* L1207 */
{1.0176256895065308e+00, 1.2010335922241211e-05,
	1.1920928955078125e-07, 4.4465065002441406e-05,
	-1.7285346984863281e-05}, /* L1208 */
{1.5929344892501831e+00, 1.8894672393798828e-05,
	1.1920928955078125e-07, -3.8385391235351562e-05,
	7.7486038208007812e-06}, /* L1209 */
{1.7058891057968140e+00, 2.0340085029602051e-05,
	1.1920928955078125e-07, 6.0558319091796875e-05,
	2.7537345886230469e-05}, /* L1210 */
{1.1977496147155762e+00, 1.4349818229675293e-05,
	1.1920928955078125e-07, -5.0663948059082031e-06,
	-7.9274177551269531e-06}, /* L1211 */
{1.0519545078277588e+00, 1.2665987014770508e-05,
	1.1920928955078125e-07, -9.4175338745117188e-06,
	-2.5033950805664062e-05}, /* L1212 */
{1.8053981065750122e+00, 2.1845102310180664e-05,
	1.1920928955078125e-07, 5.8412551879882812e-06,
	4.7683715820312500e-07}, /* L1213 */
{1.2401795387268066e+00, 1.5079975128173828e-05,
	1.1920928955078125e-07, 9.1791152954101562e-06,
	-6.3180923461914062e-06}, /* L1214 */
{1.1975620985031128e+00, 1.4707446098327637e-05,
	1.1920928955078125e-07, 3.4335851669311523e-03,
	-5.1164627075195312e-04}, /* L1215 */
{1.5048525333404541e+00, 1.8477439880371094e-05,
	1.1920928955078125e-07, 3.6954879760742188e-06,
	-7.8082084655761719e-06}, /* L1216 */
{1.1292189359664917e+00, 1.3932585716247559e-05,
	1.1920928955078125e-07, 1.3113021850585938e-06,
	1.0848045349121094e-05}, /* L1217 */
{1.1700141429901123e+00, 1.4506280422210693e-05,
	1.1920928955078125e-07, 1.8239021301269531e-05,
	-1.8358230590820312e-05}, /* L1218 */
{1.1943764686584473e+00, 1.4878809452056885e-05,
	1.1920928955078125e-07, 4.7683715820312500e-06,
	-9.2387199401855469e-06}, /* L1219 */
{1.7291518449783325e+00, 2.1643936634063721e-05,
	1.1920928955078125e-07, -2.0265579223632812e-06,
	-1.9729137420654297e-05}, /* L1220 */
{1.6042573451995850e+00, 2.0176172256469727e-05,
	1.1920928955078125e-07, 5.0067901611328125e-06,
	1.6689300537109375e-06}, /* L1221 */
{1.4740267992019653e+00, 1.8626451492309570e-05,
	1.1920928955078125e-07, 8.3446502685546875e-07,
	-3.9339065551757812e-06}, /* L1222 */
{1.4295392036437988e+00, 1.8149614334106445e-05,
	1.1920928955078125e-07, -2.3841857910156250e-07,
	5.7220458984375000e-06}, /* L1223 */
{1.4392251968383789e+00, 1.8358230590820312e-05,
	1.1920928955078125e-07, -1.6987323760986328e-05,
	-2.1576881408691406e-05}, /* L1224 */
{2.1736485958099365e+00, 2.7865171432495117e-05,
	1.1920928955078125e-07, -5.3107738494873047e-05,
	-4.2319297790527344e-05}, /* L1225 */
{1.1919932365417480e+00, 1.5348196029663086e-05,
	1.1920928955078125e-07, -7.0035457611083984e-05,
	8.1062316894531250e-06}, /* L1226 */
{1.6522569656372070e+00, 2.1398067474365234e-05,
	1.1920928955078125e-07, -7.0112943649291992e-04,
	2.2172927856445312e-04}, /* L1227 */
{1.6680214405059814e+00, 2.1681189537048340e-05,
	1.1920928955078125e-07, -8.1539154052734375e-05,
	-7.9333782196044922e-05}, /* L1228 */
{2.1757786273956299e+00, 2.8401613235473633e-05,
	1.1920928955078125e-07, 8.4638595581054688e-06,
	1.0490417480468750e-05}, /* L1229 */
{1.3124855756759644e+00, 1.7210841178894043e-05,
	1.1920928955078125e-07, 7.9870223999023438e-06,
	-1.4483928680419922e-05}, /* L1230 */
{1.5203121900558472e+00, 2.0027160644531250e-05,
	1.1920928955078125e-07, -1.9431114196777344e-05,
	3.5762786865234375e-07}, /* L1231 */
{1.4143544435501099e+00, 1.8715858459472656e-05,
	1.1920928955078125e-07, -2.3245811462402344e-06,
	-9.0003013610839844e-06}, /* L1232 */
{1.4371609687805176e+00, 1.9103288650512695e-05,
	1.1920928955078125e-07, 6.3180923461914062e-06,
	-3.1292438507080078e-05}, /* L1233 */
{1.6026908159255981e+00, 2.1427869796752930e-05,
	1.1920928955078125e-07, -3.3575296401977539e-04,
	-6.3514709472656250e-04}, /* L1234 */
{1.6288132667541504e+00, 2.1845102310180664e-05,
	1.1920928955078125e-07, -4.0888786315917969e-05,
	9.1791152954101562e-06}, /* L1235 */
{1.0187907218933105e+00, 1.3723969459533691e-05,
	1.1920928955078125e-07, 1.3470649719238281e-05,
	2.3841857910156250e-06}, /* L1236 */
{1.2462819814682007e+00, 1.6862526535987854e-05,
	1.1920928955078125e-07, 3.8146972656250000e-06,
	1.1920928955078125e-06}, /* L1237 */
{1.4384590387344360e+00, 1.9550323486328125e-05,
	1.1920928955078125e-07, -3.6537647247314453e-05,
	-3.3259391784667969e-05}, /* L1238 */
{1.3267810344696045e+00, 1.8194317817687988e-05,
	1.1920928955078125e-07, -1.6243457794189453e-03,
	5.1963329315185547e-04}, /* L1239 */
{1.2517757415771484e+00, 1.7166137695312500e-05,
	1.1920928955078125e-07, -3.6954879760742188e-05,
	-4.6491622924804688e-05}, /* L1240 */
{1.6038647890090942e+00, 2.2083520889282227e-05,
	1.1920928955078125e-07, -6.8545341491699219e-06,
	2.6226043701171875e-06}, /* L1241 */
{1.1713200807571411e+00, 1.6197562217712402e-05,
	1.1920928955078125e-07, -4.7683715820312500e-06,
	-5.6028366088867188e-06}, /* L1242 */
{1.8583130836486816e+00, 2.5808811187744141e-05,
	1.1920928955078125e-07, -1.2278556823730469e-05,
	-1.6689300537109375e-05}, /* L1243 */
{1.2964105606079102e+00, 1.8082559108734131e-05,
	1.1920928955078125e-07, -4.8756599426269531e-05,
	-3.9100646972656250e-05}, /* L1244 */
{1.4914346933364868e+00, 2.0891427993774414e-05,
	1.1920928955078125e-07, -2.7477741241455078e-05,
	-1.9073486328125000e-06}, /* L1245 */
{1.2626861333847046e+00, 1.7762184143066406e-05,
	1.1920928955078125e-07, -1.7881393432617188e-07,
	1.1920928955078125e-07}, /* L1246 */
{1.3563674688339233e+00, 1.9162893295288086e-05,
	1.1920928955078125e-07, 2.0980834960937500e-05,
	2.7418136596679688e-05}, /* L1247 */
{1.5367653369903564e+00, 2.1800398826599121e-05,
	1.1920928955078125e-07, 4.0531158447265625e-06,
	-1.1324882507324219e-06}, /* L1248 */
{1.2470778226852417e+00, 1.7765909433364868e-05,
	1.1920928955078125e-07, 3.4332275390625000e-05,
	2.9921531677246094e-05}, /* L1249 */
{1.0934772491455078e+00, 1.5646219253540039e-05,
	1.1920928955078125e-07, 2.8252601623535156e-05,
	3.8146972656250000e-05}, /* L1250 */
{1.9852321147918701e+00, 2.8520822525024414e-05,
	1.1920928955078125e-07, -2.0563602447509766e-05,
	1.2874603271484375e-05}, /* L1251 */
{1.2313609123229980e+00, 1.7762184143066406e-05,
	1.1920928955078125e-07, 7.0333480834960938e-06,
	-8.5234642028808594e-06}, /* L1252 */
{1.2252029180526733e+00, 1.7762184143066406e-05,
	1.1920928955078125e-07, -6.1577558517456055e-04,
	-2.3275613784790039e-04}, /* L1253 */
{1.0384093523025513e+00, 1.5102326869964600e-05,
	1.1920928955078125e-07, -4.2915344238281250e-06,
	-7.1525573730468750e-07}, /* L1254 */
{1.4937413930892944e+00, 2.1815299987792969e-05,
	1.1920928955078125e-07, 4.0650367736816406e-05,
	-1.2755393981933594e-05}, /* L1255 */
{1.2570779323577881e+00, 1.8432736396789551e-05,
	1.1920928955078125e-07, 2.6345252990722656e-05,
	-5.1259994506835938e-06}, /* L1256 */
{1.8190509080886841e+00, 2.6784837245941162e-05,
	1.1920928955078125e-07, -9.2089176177978516e-05,
	-7.8439712524414062e-05}, /* L1257 */
{1.0523401498794556e+00, 1.5556812286376953e-05,
	1.1920928955078125e-07, 4.8518180847167969e-05,
	7.2598457336425781e-05}, /* L1258 */
{1.8098148107528687e+00, 2.6866793632507324e-05,
	1.1920928955078125e-07, -2.8133392333984375e-05,
	-1.0192394256591797e-05}, /* L1259 */
{1.5516481399536133e+00, 2.3126602172851562e-05,
	1.1920928955078125e-07, -1.1730194091796875e-04,
	-5.0246715545654297e-05}, /* L1260 */
{1.7170596122741699e+00, 2.5689601898193359e-05,
	1.1920928955078125e-07, 8.1062316894531250e-06,
	1.6212463378906250e-05}, /* L1261 */
{1.6130100488662720e+00, 2.4229288101196289e-05,
	1.1920928955078125e-07, 2.0265579223632812e-05,
	1.2755393981933594e-05}, /* L1262 */
{1.5766159296035767e+00, 2.3778527975082397e-05,
	1.1920928955078125e-07, -2.6404857635498047e-05,
	-6.1452388763427734e-05}, /* L1263 */
{1.3089818954467773e+00, 1.9818544387817383e-05,
	1.1920928955078125e-07, 6.5565109252929688e-06,
	3.5405158996582031e-05}, /* L1264 */
{2.3881494998931885e+00, 3.6299228668212891e-05,
	1.1920928955078125e-07, 5.2452087402343750e-06,
	-2.7954578399658203e-05}, /* L1265 */
{1.3607747554779053e+00, 2.0766630768775940e-05,
	1.1920928955078125e-07, -2.3841857910156250e-06,
	1.5258789062500000e-05}, /* L1266 */
{1.0377191305160522e+00, 1.5914440155029297e-05,
	1.1920928955078125e-07, -3.7550926208496094e-06,
	-1.6212463378906250e-04}, /* L1267 */
{9.7865903377532959e-01, 1.5050172805786133e-05,
	1.1920928955078125e-07, 1.8000602722167969e-05,
	-1.6272068023681641e-05}, /* L1268 */
{1.3841279745101929e+00, 2.1368265151977539e-05,
	1.1920928955078125e-07, -1.3709068298339844e-06,
	-2.2470951080322266e-05}, /* L1269 */
{8.3651173114776611e-01, 1.2964010238647461e-05,
	1.1920928955078125e-07, 1.1682510375976562e-05,
	-2.2053718566894531e-06}, /* L1270 */
{1.2979427576065063e+00, 2.0192470401525497e-05,
	1.1920928955078125e-07, 6.4373016357421875e-06,
	6.3180923461914062e-06}, /* L1271 */
{1.2060588598251343e+00, 1.8835067749023438e-05,
	1.1920928955078125e-07, 4.1604042053222656e-05,
	1.4305114746093750e-06}, /* L1272 */
{1.0417672395706177e+00, 1.6331672668457031e-05,
	1.1920928955078125e-07, -4.5776367187500000e-05,
	5.2809715270996094e-05}, /* L1273 */
{1.1557486057281494e+00, 1.8186867237091064e-05,
	1.1920928955078125e-07, -1.0728836059570312e-06,
	1.9907951354980469e-05}, /* L1274 */
{1.1678060293197632e+00, 1.8447637557983398e-05,
	1.1920928955078125e-07, -4.3451786041259766e-05,
	-3.6835670471191406e-05}, /* L1275 */
{1.0798661708831787e+00, 1.7121434211730957e-05,
	1.1920928955078125e-07, 7.5101852416992188e-06,
	1.3113021850585938e-05}, /* L1276 */
{1.6089533567428589e+00, 2.5607645511627197e-05,
	1.1920928955078125e-07, 4.4941902160644531e-05,
	2.3841857910156250e-06}, /* L1277 */
{9.2531841993331909e-01, 1.4781951904296875e-05,
	1.1920928955078125e-07, -4.5180320739746094e-05,
	2.0861625671386719e-05}, /* L1278 */
{1.0825912952423096e+00, 1.7359852790832520e-05,
	1.1920928955078125e-07, -4.7683715820312500e-06,
	1.0967254638671875e-05}, /* L1279 */
{1.1458694934844971e+00, 1.8447637557983398e-05,
	1.1920928955078125e-07, 1.3041496276855469e-04,
	5.2809715270996094e-05}, /* L1280 */
{1.2772612571716309e+00, 2.0634382963180542e-05,
	1.1920928955078125e-07, -5.6743621826171875e-05,
	-4.6730041503906250e-05}, /* L1281 */
{9.4301450252532959e-01, 1.5288591384887695e-05,
	1.1920928955078125e-07, -2.3245811462402344e-06,
	2.5033950805664062e-06}, /* L1282 */
{1.3827694654464722e+00, 2.2500753402709961e-05,
	1.1920928955078125e-07, -1.3172626495361328e-05,
	2.1457672119140625e-06}, /* L1283 */
{9.4524723291397095e-01, 1.5437602996826172e-05,
	1.1920928955078125e-07, -4.1723251342773438e-07,
	2.3841857910156250e-07}, /* L1284 */
{1.4381570816040039e+00, 2.3573637008666992e-05,
	1.1920928955078125e-07, 1.8000602722167969e-05,
	1.4305114746093750e-06}, /* L1285 */
{9.2118191719055176e-01, 1.5154480934143066e-05,
	1.1920928955078125e-07, -7.0929527282714844e-06,
	-7.2121620178222656e-06}, /* L1286 */
{1.1705466508865356e+00, 1.9326806068420410e-05,
	1.1920928955078125e-07, 1.7881393432617188e-06,
	-6.7353248596191406e-06}, /* L1287 */
{1.0789124965667725e+00, 1.7881393432617188e-05,
	1.1920928955078125e-07, -3.2961368560791016e-05,
	9.3221664428710938e-05}, /* L1288 */
{1.6003317832946777e+00, 2.6613473892211914e-05,
	1.1920928955078125e-07, 5.8412551879882812e-06,
	-9.7155570983886719e-06}, /* L1289 */
{1.8595010042190552e+00, 3.1039118766784668e-05,
	1.1920928955078125e-07, -1.0073184967041016e-05,
	7.3909759521484375e-06}, /* L1290 */
{9.3055397272109985e-01, 1.5586614608764648e-05,
	1.1920928955078125e-07, 2.1219253540039062e-05,
	-1.3828277587890625e-05}, /* L1291 */
{1.5620447397232056e+00, 2.6255846023559570e-05,
	1.1920928955078125e-07, -7.0333480834960938e-06,
	8.2254409790039062e-06}, /* L1292 */
{1.6129204034805298e+00, 2.7209520339965820e-05,
	1.1920928955078125e-07, 9.7751617431640625e-06,
	-1.7225742340087891e-05}, /* L1293 */
{1.5218948125839233e+00, 2.5764107704162598e-05,
	1.1920928955078125e-07, -2.7179718017578125e-05,
	-7.5697898864746094e-06}, /* L1294 */
{1.9754331111907959e+00, 3.3557415008544922e-05,
	1.1920928955078125e-07, -1.9669532775878906e-06,
	2.6226043701171875e-06}, /* L1295 */
{1.2727109193801880e+00, 2.1696090698242188e-05,
	1.1920928955078125e-07, -1.1682510375976562e-05,
	-3.6358833312988281e-06}, /* L1296 */
{1.7381219863891602e+00, 2.9733870178461075e-05,
	1.1920928955078125e-07, 8.9406967163085938e-06,
	-2.3245811462402344e-06}, /* L1297 */
{9.6112900972366333e-01, 1.6510486602783203e-05,
	1.1920928955078125e-07, -1.1205673217773438e-05,
	-1.2153387069702148e-04}, /* L1298 */
{1.1695462465286255e+00, 2.0146369934082031e-05,
	1.1920928955078125e-07, 4.0531158447265625e-06,
	3.4570693969726562e-06}, /* L1299 */
{1.1542683839797974e+00, 1.9952654838562012e-05,
	1.1920928955078125e-07, -2.8014183044433594e-06,
	-1.2993812561035156e-05}, /* L1300 */
{1.8624702692031860e+00, 3.2305717468261719e-05,
	1.1920928955078125e-07, 7.5101852416992188e-06,
	7.0333480834960938e-06}, /* L1301 */
{8.9964288473129272e-01, 1.5661120414733887e-05,
	1.1920928955078125e-07, 4.3392181396484375e-05,
	-1.3691186904907227e-04}, /* L1302 */
{1.2183562517166138e+00, 2.1278858184814453e-05,
	1.1920928955078125e-07, -3.4034252166748047e-05,
	4.7683715820312500e-07}, /* L1303 */
{8.7741857767105103e-01, 1.5377998352050781e-05,
	1.1920928955078125e-07, 2.3484230041503906e-05,
	-1.2856721878051758e-04}, /* L1304 */
{2.1357288360595703e+00, 3.7610530853271484e-05,
	1.1920928955078125e-07, 1.3327598571777344e-04,
	4.8029422760009766e-04}, /* L1305 */
{1.2161464691162109e+00, 2.1457672119140625e-05,
	1.1920928955078125e-07, -1.2576580047607422e-05,
	6.6161155700683594e-05}, /* L1306 */
{1.2137373685836792e+00, 2.1487474441528320e-05,
	1.1920928955078125e-07, -6.9141387939453125e-06,
	2.0265579223632812e-06}, /* L1307 */
{1.1658335924148560e+00, 2.0712614059448242e-05,
	1.1920928955078125e-07, -2.8371810913085938e-05,
	-1.1879205703735352e-04}, /* L1308 */
{1.5931706428527832e+00, 2.8394162654876709e-05,
	1.1920928955078125e-07, 2.2649765014648438e-05,
	-2.1696090698242188e-05}, /* L1309 */
{1.0907585620880127e+00, 1.9505620002746582e-05,
	1.1920928955078125e-07, 3.1471252441406250e-05,
	-4.2617321014404297e-05}, /* L1310 */
{1.7374719381332397e+00, 3.1173229217529297e-05,
	1.1920928955078125e-07, 2.9087066650390625e-05,
	1.1086463928222656e-05}, /* L1311 */
{1.3886525630950928e+00, 2.5004148483276367e-05,
	1.1920928955078125e-07, 5.1259994506835938e-05,
	-6.4969062805175781e-05}, /* L1312 */
{1.2540564537048340e+00, 2.2649765014648438e-05,
	1.1920928955078125e-07, 2.1815299987792969e-05,
	-2.0980834960937500e-05}, /* L1313 */
{9.9175816774368286e-01, 1.7970800399780273e-05,
	1.1920928955078125e-07, -7.5101852416992188e-06,
	4.8875808715820312e-06}, /* L1314 */
{1.6540836095809937e+00, 3.0070543289184570e-05,
	1.1920928955078125e-07, -9.4175338745117188e-06,
	5.2452087402343750e-06}, /* L1315 */
{1.1118304729461670e+00, 2.0295381546020508e-05,
	1.1920928955078125e-07, 2.0480155944824219e-04,
	3.4022331237792969e-04}, /* L1316 */
{1.3232371807098389e+00, 2.4214386940002441e-05,
	1.1920928955078125e-07, -6.5565109252929688e-06,
	2.3841857910156250e-07}, /* L1317 */
{1.0291864871978760e+00, 1.8894672393798828e-05,
	1.1920928955078125e-07, 1.3351440429687500e-05,
	-2.4378299713134766e-05}, /* L1318 */
{1.3769135475158691e+00, 2.5361776351928711e-05,
	1.1920928955078125e-07, -3.3974647521972656e-05,
	4.1365623474121094e-05}, /* L1319 */
{9.7899967432022095e-01, 1.8090009689331055e-05,
	1.1920928955078125e-07, -1.9192695617675781e-05,
	-9.4771385192871094e-06}, /* L1320 */
{1.4660800695419312e+00, 2.7179718017578125e-05,
	1.1920928955078125e-07, 4.3511390686035156e-05,
	2.3245811462402344e-05}, /* L1321 */
{9.0497338771820068e-01, 1.6830861568450928e-05,
	1.1920928955078125e-07, 4.5299530029296875e-05,
	-4.8875808715820312e-06}, /* L1322 */
{1.5557006597518921e+00, 2.9027462005615234e-05,
	1.1920928955078125e-07, -1.0615587234497070e-04,
	-3.7848949432373047e-05}, /* L1323 */
{1.4645508527755737e+00, 2.7418136596679688e-05,
	1.1920928955078125e-07, -1.2248754501342773e-04,
	-8.8274478912353516e-05}, /* L1324 */
{1.8489490747451782e+00, 3.4719705581665039e-05,
	1.1920928955078125e-07, 5.4359436035156250e-05,
	6.0319900512695312e-05}, /* L1325 */
{1.7372847795486450e+00, 3.2722949981689453e-05,
	1.1920928955078125e-07, -3.4034252166748047e-05,
	9.8943710327148438e-06}, /* L1326 */
{1.8800387382507324e+00, 3.5524368286132812e-05,
	1.1920928955078125e-07, -2.5987625122070312e-05,
	9.5367431640625000e-07}, /* L1327 */
{1.3620268106460571e+00, 2.5816261768341064e-05,
	1.1920928955078125e-07, -5.9008598327636719e-06,
	8.4638595581054688e-06}, /* L1328 */
{1.4184815883636475e+00, 2.6971101760864258e-05,
	1.1920928955078125e-07, -1.2934207916259766e-05,
	8.2254409790039062e-06}, /* L1329 */
{1.2609255313873291e+00, 2.4050474166870117e-05,
	1.1920928955078125e-07, 2.0265579223632812e-06,
	7.8678131103515625e-06}, /* L1330 */
{1.2538588047027588e+00, 2.3990869522094727e-05,
	1.1920928955078125e-07, 4.1723251342773438e-05,
	-2.0742416381835938e-05}, /* L1331 */
{1.2079840898513794e+00, 2.3186206817626953e-05,
	1.1920928955078125e-07, -3.0159950256347656e-05,
	-2.9742717742919922e-05}, /* L1332 */
{1.6592340469360352e+00, 3.1948089599609375e-05,
	1.1920928955078125e-07, 1.2278556823730469e-05,
	4.2915344238281250e-06}, /* L1333 */
{1.2129570245742798e+00, 2.3424625396728516e-05,
	1.1920928955078125e-07, 1.4901161193847656e-05,
	7.8678131103515625e-06}, /* L1334 */
{1.3397462368011475e+00, 2.5957822799682617e-05,
	1.1920928955078125e-07, -2.9981136322021484e-05,
	-2.6106834411621094e-05}, /* L1335 */
{1.3335621356964111e+00, 2.5913119316101074e-05,
	1.1920928955078125e-07, 4.0531158447265625e-06,
	-6.5565109252929688e-07}, /* L1336 */
{1.8132857084274292e+00, 3.5345554351806641e-05,
	1.1920928955078125e-07, 5.1259994506835938e-06,
	8.7022781372070312e-06}, /* L1337 */
{1.0045012235641479e+00, 1.9639730453491211e-05,
	1.1920928955078125e-07, -2.8669834136962891e-05,
	-7.5697898864746094e-05}, /* L1338 */
{1.1465537548065186e+00, 2.2485852241516113e-05,
	1.1920928955078125e-07, -7.8082084655761719e-06,
	7.8678131103515625e-06}, /* L1339 */
{1.3559750318527222e+00, 2.6673078536987305e-05,
	1.1920928955078125e-07, -4.9650669097900391e-05,
	-2.2232532501220703e-05}, /* L1340 */
{1.6374152898788452e+00, 3.2305717468261719e-05,
	1.1920928955078125e-07, -9.5367431640625000e-07,
	-1.4901161193847656e-06}, /* L1341 */
{8.7349468469619751e-01, 1.7285346984863281e-05,
	1.1920928955078125e-07, -7.6293945312500000e-06,
	4.0531158447265625e-06}, /* L1342 */
{1.3870619535446167e+00, 2.7537345886230469e-05,
	1.1920928955078125e-07, -5.0723552703857422e-05,
	-1.3619661331176758e-04}, /* L1343 */
{1.3697391748428345e+00, 2.7269124984741211e-05,
	1.1920928955078125e-07, -1.1205673217773438e-05,
	5.3644180297851562e-06}, /* L1344 */
{1.2577501535415649e+00, 2.5123357772827148e-05,
	1.1920928955078125e-07, 1.1873245239257812e-04,
	4.7564506530761719e-05}, /* L1345 */
{8.5861575603485107e-01, 1.7195940017700195e-05,
	1.1920928955078125e-07, -1.9669532775878906e-06,
	-4.4107437133789062e-06}, /* L1346 */
{1.3351397514343262e+00, 2.6836991310119629e-05,
	1.1920928955078125e-07, 1.3399124145507812e-04,
	-2.2524595260620117e-04}, /* L1347 */
{1.2263201475143433e+00, 2.4706125259399414e-05,
	1.1920928955078125e-07, -8.2850456237792969e-06,
	-1.7881393432617188e-07}, /* L1348 */
{1.4231839179992676e+00, 2.8759241104125977e-05,
	1.1920928955078125e-07, 1.0848045349121094e-05,
	6.0796737670898438e-06}, /* L1349 */
{1.2554723024368286e+00, 2.5451183319091797e-05,
	1.1920928955078125e-07, 5.8650970458984375e-05,
	1.0848045349121094e-04}, /* L1350 */
{1.6113200187683105e+00, 3.2752752304077148e-05,
	1.1920928955078125e-07, -2.0503997802734375e-05,
	-2.0384788513183594e-05}, /* L1351 */
{1.6944191455841064e+00, 3.4540891647338867e-05,
	1.1920928955078125e-07, 2.2888183593750000e-05,
	1.5258789062500000e-05}, /* L1352 */
{1.7725239992141724e+00, 3.6239624023437500e-05,
	1.1920928955078125e-07, -8.8214874267578125e-06,
	-1.6987323760986328e-05}, /* L1353 */
{1.3036923408508301e+00, 2.6732683181762695e-05,
	1.1920928955078125e-07, -3.6478042602539062e-05,
	1.8358230590820312e-05}, /* L1354 */
{2.0716965198516846e+00, 4.2602419853210449e-05,
	1.1920928955078125e-07, 1.3113021850585938e-06,
	9.6559524536132812e-06}, /* L1355 */
{1.7556488513946533e+00, 3.6209821701049805e-05,
	1.1920928955078125e-07, 2.3722648620605469e-05,
	3.1232833862304688e-05}, /* L1356 */
{1.4149175882339478e+00, 2.9265880584716797e-05,
	1.1920928955078125e-07, 1.0251998901367188e-05,
	4.9829483032226562e-05}, /* L1357 */
{1.2239744663238525e+00, 2.5391578674316406e-05,
	1.1920928955078125e-07, -2.2232532501220703e-05,
	4.9352645874023438e-05}, /* L1358 */
{1.8379373550415039e+00, 3.8236379623413086e-05,
	1.1920928955078125e-07, -1.0788440704345703e-05,
	4.6849250793457031e-05}, /* L1359 */
{1.2392036914825439e+00, 2.5853514671325684e-05,
	1.1920928955078125e-07, -9.1791152954101562e-06,
	-1.1205673217773438e-05}, /* L1360 */
{2.0640878677368164e+00, 4.3183565139770508e-05,
	1.1920928955078125e-07, 1.3828277587890625e-05,
	-3.8146972656250000e-06}, /* L1361 */
{1.1540567874908447e+00, 2.4214386940002441e-05,
	1.1920928955078125e-07, -3.8743019104003906e-06,
	3.1232833862304688e-05}, /* L1362 */
{1.4506357908248901e+00, 3.0525028705596924e-05,
	1.1920928955078125e-07, 4.7802925109863281e-05,
	5.4121017456054688e-05}, /* L1363 */
{1.2244940996170044e+00, 2.5838613510131836e-05,
	1.1920928955078125e-07, -1.0192394256591797e-05,
	-7.2121620178222656e-05}, /* L1364 */
{1.7947084903717041e+00, 3.7983059883117676e-05,
	1.1920928955078125e-07, 4.1365623474121094e-05,
	2.0873546600341797e-04}, /* L1365 */
{1.0404492616653442e+00, 2.2083520889282227e-05,
	1.1920928955078125e-07, -1.0049343109130859e-04,
	-1.7166137695312500e-05}, /* L1366 */
{1.6932382583618164e+00, 3.6031007766723633e-05,
	1.1920928955078125e-07, 2.6226043701171875e-06,
	3.8504600524902344e-05}, /* L1367 */
{1.0041375160217285e+00, 2.1427869796752930e-05,
	1.1920928955078125e-07, -1.4364719390869141e-05,
	8.8214874267578125e-06}, /* L1368 */
{1.1350351572036743e+00, 2.4288892745971680e-05,
	1.1920928955078125e-07, -2.1457672119140625e-05,
	-1.6570091247558594e-05}, /* L1369 */
{1.4458054304122925e+00, 3.1024217605590820e-05,
	1.1920928955078125e-07, 7.0333480834960938e-06,
	-6.3776969909667969e-06}, /* L1370 */
{1.7375079393386841e+00, 3.7387013435363770e-05,
	1.1920928955078125e-07, -7.9870223999023438e-06,
	1.2874603271484375e-05}, /* L1371 */
{1.5731759071350098e+00, 3.3944845199584961e-05,
	1.1920928955078125e-07, 1.9073486328125000e-06,
	4.1723251342773438e-06}, /* L1372 */
{1.6914273500442505e+00, 3.6597251892089844e-05,
	1.1920928955078125e-07, -1.3411045074462891e-05,
	-1.8477439880371094e-06}, /* L1373 */
{1.3100943565368652e+00, 2.8431415557861328e-05,
	1.1920928955078125e-07, -3.6180019378662109e-05,
	5.9962272644042969e-05}, /* L1374 */
{1.7335295677185059e+00, 3.7714838981628418e-05,
	1.1920928955078125e-07, -1.4305114746093750e-06,
	-1.6272068023681641e-05}, /* L1375 */
{2.4289181232452393e+00, 5.2988529205322266e-05,
	1.1920928955078125e-07, -1.0311603546142578e-05,
	-8.0466270446777344e-06}, /* L1376 */
{2.0093674659729004e+00, 4.3958425521850586e-05,
	1.1920928955078125e-07, -2.3722648620605469e-05,
	1.5974044799804688e-05}, /* L1377 */
{1.0772960186004639e+00, 2.3633241653442383e-05,
	1.1920928955078125e-07, 1.3828277587890625e-05,
	1.1920928955078125e-07}, /* L1378 */
{1.4037636518478394e+00, 3.0875205993652344e-05,
	1.1920928955078125e-07, -1.6927719116210938e-05,
	-1.4841556549072266e-05}, /* L1379 */
{1.2685499191284180e+00, 2.7976930141448975e-05,
	1.1920928955078125e-07, 1.3351440429687500e-05,
	1.4185905456542969e-05}, /* L1380 */
{1.5781387090682983e+00, 3.4898519515991211e-05,
	1.1920928955078125e-07, -3.5464763641357422e-05,
	7.1525573730468750e-07}, /* L1381 */
{1.2983435392379761e+00, 2.8789043426513672e-05,
	1.1920928955078125e-07, -2.9802322387695312e-06,
	-2.2351741790771484e-05}, /* L1382 */
{1.6043317317962646e+00, 3.5673379898071289e-05,
	1.1920928955078125e-07, -2.7775764465332031e-05,
	-5.3167343139648438e-05}, /* L1383 */
{1.3502142429351807e+00, 3.0130147933959961e-05,
	1.1920928955078125e-07, -5.1420927047729492e-04,
	-5.3250789642333984e-04}, /* L1384 */
{1.6409204006195068e+00, 3.6686658859252930e-05,
	1.1920928955078125e-07, -1.8000602722167969e-05,
	1.1622905731201172e-04}, /* L1385 */
{1.0525113344192505e+00, 2.3588538169860840e-05,
	1.1920928955078125e-07, -1.0013580322265625e-05,
	1.0609626770019531e-05}, /* L1386 */
{1.2797068357467651e+00, 2.8759241104125977e-05,
	1.1920928955078125e-07, 2.0265579223632812e-05,
	1.4901161193847656e-05}, /* L1387 */
{1.6454463005065918e+00, 3.7074089050292969e-05,
	1.1920928955078125e-07, 5.4836273193359375e-06,
	1.4305114746093750e-06}, /* L1388 */
{1.8370115756988525e+00, 4.1499733924865723e-05,
	1.1920928955078125e-07, 4.7683715820312500e-07,
	2.0265579223632812e-06}, /* L1389 */
{1.2052081823348999e+00, 2.7298927307128906e-05,
	1.1920928955078125e-07, 1.0371208190917969e-05,
	-4.7683715820312500e-06}, /* L1390 */
{1.7833750247955322e+00, 4.0501356124877930e-05,
	1.1920928955078125e-07, 1.4781951904296875e-05,
	-1.3470649719238281e-05}, /* L1391 */
{1.2067022323608398e+00, 2.7477741241455078e-05,
	1.1920928955078125e-07, -1.1444091796875000e-05,
	-1.1801719665527344e-05}, /* L1392 */
{1.0259829759597778e+00, 2.3424625396728516e-05,
	1.1920928955078125e-07, 1.9192695617675781e-05,
	1.4305114746093750e-06}, /* L1393 */
{1.1892608404159546e+00, 2.7224421501159668e-05,
	1.1920928955078125e-07, -8.7261199951171875e-05,
	-1.5497207641601562e-06}, /* L1394 */
{1.6310317516326904e+00, 3.7431716918945312e-05,
	1.1920928955078125e-07, -4.2319297790527344e-06,
	-2.7894973754882812e-05}, /* L1395 */
{1.1712638139724731e+00, 2.6956200599670410e-05,
	1.1920928955078125e-07, 8.2492828369140625e-05,
	1.4388561248779297e-04}, /* L1396 */
{1.3191109895706177e+00, 3.0428171157836914e-05,
	1.1920928955078125e-07, -1.4424324035644531e-05,
	-5.8412551879882812e-06}, /* L1397 */
{1.1687425374984741e+00, 2.7030706405639648e-05,
	1.1920928955078125e-07, -1.4185905456542969e-05,
	2.9802322387695312e-05}, /* L1398 */
{1.5179406404495239e+00, 3.5196542739868164e-05,
	1.1920928955078125e-07, 3.5762786865234375e-07,
	-1.4960765838623047e-05}, /* L1399 */
{1.1524952650070190e+00, 2.6792287826538086e-05,
	1.1920928955078125e-07, 1.4662742614746094e-05,
	-2.1994113922119141e-05}, /* L1400 */
{1.6869832277297974e+00, 3.9316713809967041e-05,
	1.1920928955078125e-07, -3.8743019104003906e-06,
	-5.0663948059082031e-06}, /* L1401 */
{1.1122173070907593e+00, 2.5987625122070312e-05,
	1.1920928955078125e-07, -7.2717666625976562e-06,
	2.2411346435546875e-05}, /* L1402 */
{2.0101656913757324e+00, 4.7087669372558594e-05,
	1.1920928955078125e-07, -4.5299530029296875e-06,
	-2.1457672119140625e-06}, /* L1403 */
{1.1953006982803345e+00, 2.8073787689208984e-05,
	1.1920928955078125e-07, -3.3438205718994141e-05,
	2.3722648620605469e-05}, /* L1404 */
{1.9925403594970703e+00, 4.6916306018829346e-05,
	1.1920928955078125e-07, 3.3855438232421875e-05,
	-8.9406967163085938e-06}, /* L1405 */
{1.2078046798706055e+00, 2.8520822525024414e-05,
	1.1920928955078125e-07, -1.5026330947875977e-04,
	1.0275840759277344e-04}, /* L1406 */
{1.7974610328674316e+00, 4.2535364627838135e-05,
	1.1920928955078125e-07, -7.9870223999023438e-06,
	-2.5153160095214844e-05}, /* L1407 */
{1.2951791286468506e+00, 3.0726194381713867e-05,
	1.1920928955078125e-07, 6.7949295043945312e-06,
	-3.8146972656250000e-06}, /* L1408 */
{1.7307336330413818e+00, 4.1201710700988770e-05,
	1.1920928955078125e-07, 4.6491622924804688e-05,
	9.8228454589843750e-05}, /* L1409 */
{1.1131089925765991e+00, 2.6538968086242676e-05,
	1.1920928955078125e-07, -1.7881393432617188e-07,
	6.3180923461914062e-06}, /* L1410 */
{1.2630264759063721e+00, 3.0189752578735352e-05,
	1.1920928955078125e-07, 4.4584274291992188e-05,
	-3.6537647247314453e-05}, /* L1411 */
{2.2866775989532471e+00, 5.4791569709777832e-05,
	1.1920928955078125e-07, -5.9604644775390625e-06,
	-7.0333480834960938e-06}, /* L1412 */
{1.9254223108291626e+00, 4.6253204345703125e-05,
	1.1920928955078125e-07, 2.0861625671386719e-05,
	2.3841857910156250e-06}, /* L1413 */
{1.2598603963851929e+00, 3.0338764190673828e-05,
	1.1920928955078125e-07, -1.7583370208740234e-05,
	1.1920928955078125e-05}, /* L1414 */
{2.0592036247253418e+00, 4.9710273742675781e-05,
	1.1920928955078125e-07, -1.4901161193847656e-06,
	3.5762786865234375e-06}, /* L1415 */
{1.3841522932052612e+00, 3.3497810363769531e-05,
	1.1920928955078125e-07, -3.2186508178710938e-06,
	-2.5570392608642578e-05}, /* L1416 */
{1.2210686206817627e+00, 2.9623508453369141e-05,
	1.1920928955078125e-07, -3.8444995880126953e-05,
	-1.9669532775878906e-05}, /* L1417 */
{1.3291358947753906e+00, 3.2335519790649414e-05,
	1.1920928955078125e-07, 1.2874603271484375e-05,
	8.9764595031738281e-05}, /* L1418 */
{1.6585131883621216e+00, 4.0441751480102539e-05,
	1.1920928955078125e-07, 6.4969062805175781e-05,
	6.7114830017089844e-05}, /* L1419 */
{2.3393919467926025e+00, 5.7190656661987305e-05,
	1.1920928955078125e-07, -6.0796737670898438e-05,
	-2.4616718292236328e-05}, /* L1420 */
{1.9875842332839966e+00, 4.8696994781494141e-05,
	1.1920928955078125e-07, -1.2636184692382812e-05,
	2.1696090698242188e-05}, /* L1421 */
{1.2387638092041016e+00, 3.0420720577239990e-05,
	1.1920928955078125e-07, -1.8477439880371094e-06,
	2.2649765014648438e-06}, /* L1422 */
{1.3376426696777344e+00, 3.2931566238403320e-05,
	1.1920928955078125e-07, -4.5418739318847656e-05,
	3.3497810363769531e-05}, /* L1423 */
{1.5897701978683472e+00, 3.9234757423400879e-05,
	1.1920928955078125e-07, -4.0054321289062500e-05,
	3.0994415283203125e-06}, /* L1424 */
{1.9498820304870605e+00, 4.8235058784484863e-05,
	1.1920928955078125e-07, -1.3053417205810547e-05,
	1.9550323486328125e-05}, /* L1425 */
{1.1309252977371216e+00, 2.8043985366821289e-05,
	1.1920928955078125e-07, 3.8504600524902344e-05,
	-4.1723251342773438e-07}, /* L1426 */
{1.7441880702972412e+00, 4.3362379074096680e-05,
	1.1920928955078125e-07, -8.7559223175048828e-05,
	1.6105175018310547e-04}, /* L1427 */
{1.1221930980682373e+00, 2.7962028980255127e-05,
	1.1920928955078125e-07, -2.7894973754882812e-05,
	-5.0067901611328125e-06}, /* L1428 */
{1.8358938694000244e+00, 4.5850872993469238e-05,
	1.1920928955078125e-07, -1.2040138244628906e-05,
	4.2915344238281250e-06}, /* L1429 */
{1.4915813207626343e+00, 3.7342309951782227e-05,
	1.1920928955078125e-07, 1.2159347534179688e-05,
	-3.9339065551757812e-06}, /* L1430 */
{1.3514995574951172e+00, 3.3915042877197266e-05,
	1.1920928955078125e-07, -1.9609928131103516e-05,
	5.0067901611328125e-06}, /* L1431 */
{1.9424787759780884e+00, 4.8860907554626465e-05,
	1.1920928955078125e-07, -1.4305114746093750e-06,
	1.0132789611816406e-05}, /* L1432 */
{2.2824485301971436e+00, 5.7548284530639648e-05,
	1.1920928955078125e-07, 1.6808509826660156e-05,
	1.0967254638671875e-05}, /* L1433 */
{1.4196853637695312e+00, 3.5881996154785156e-05,
	1.1920928955078125e-07, 8.3565711975097656e-05,
	2.6822090148925781e-05}, /* L1434 */
{2.0587852001190186e+00, 5.2154064178466797e-05,
	1.1920928955078125e-07, -2.0265579223632812e-05,
	1.1086463928222656e-05}, /* L1435 */
{1.5611630678176880e+00, 3.9644539356231689e-05,
	1.1920928955078125e-07, 3.7789344787597656e-05,
	6.9737434387207031e-05}, /* L1436 */
{2.0004017353057861e+00, 5.0917267799377441e-05,
	1.1920928955078125e-07, -1.9073486328125000e-05,
	3.4332275390625000e-05}, /* L1437 */
{1.6173666715621948e+00, 4.1261315345764160e-05,
	1.1920928955078125e-07, -1.1444091796875000e-05,
	1.4901161193847656e-05}, /* L1438 */
{1.7316709756851196e+00, 4.4301152229309082e-05,
	1.1920928955078125e-07, -7.6353549957275391e-05,
	-3.4749507904052734e-05}, /* L1439 */
{1.2825214862823486e+00, 3.2871961593627930e-05,
	1.1920928955078125e-07, 1.1682510375976562e-05,
	-1.0311603546142578e-05}, /* L1440 */
{1.3583186864852905e+00, 3.4898519515991211e-05,
	1.1920928955078125e-07, 4.6014785766601562e-05,
	5.9366226196289062e-05}, /* L1441 */
{1.0954340696334839e+00, 2.8207898139953613e-05,
	1.1920928955078125e-07, -8.7022781372070312e-06,
	6.6757202148437500e-06}, /* L1442 */
{1.8105490207672119e+00, 4.6759843826293945e-05,
	1.1920928955078125e-07, -1.4382600784301758e-04,
	8.7976455688476562e-05}, /* L1443 */
{1.7050383090972900e+00, 4.4107437133789062e-05,
	1.1920928955078125e-07, -1.1205673217773438e-05,
	-9.2983245849609375e-06}, /* L1444 */
{1.9364947080612183e+00, 5.0216913223266602e-05,
	1.1920928955078125e-07, 3.5166740417480469e-05,
	2.8252601623535156e-05}, /* L1445 */
{1.2488127946853638e+00, 3.2454729080200195e-05,
	1.1920928955078125e-07, -1.1682510375976562e-05,
	3.0994415283203125e-06}, /* L1446 */
{1.4114278554916382e+00, 3.6776065826416016e-05,
	1.1920928955078125e-07, 7.9035758972167969e-05,
	-1.0204315185546875e-04}, /* L1447 */
{1.2499012947082520e+00, 3.2633543014526367e-05,
	1.1920928955078125e-07, -3.6060810089111328e-05,
	6.3180923461914062e-06}, /* L1448 */
{1.5762051343917847e+00, 4.1246414184570312e-05,
	1.1920928955078125e-07, -2.9206275939941406e-06,
	4.1007995605468750e-05}, /* L1449 */
{1.2615462541580200e+00, 3.3088028430938721e-05,
	1.1920928955078125e-07, -2.5629997253417969e-05,
	-1.4305114746093750e-06}, /* L1450 */
{1.7548559904098511e+00, 4.6133995056152344e-05,
	1.1920928955078125e-07, 1.1801719665527344e-05,
	6.3061714172363281e-05}, /* L1451 */
{1.3512141704559326e+00, 3.5598874092102051e-05,
	1.1920928955078125e-07, -2.8610229492187500e-06,
	-1.2516975402832031e-06}, /* L1452 */
{1.9481852054595947e+00, 5.1444396376609802e-05,
	1.1920928955078125e-07, -1.4483928680419922e-05,
	-2.7835369110107422e-05}, /* L1453 */
{1.3838692903518677e+00, 3.6627054214477539e-05,
	1.1920928955078125e-07, -1.9133090972900391e-05,
	2.9802322387695312e-06}, /* L1454 */
{1.4002081155776978e+00, 3.7141144275665283e-05,
	1.1920928955078125e-07, 2.9802322387695312e-06,
	-1.8239021301269531e-05}, /* L1455 */
{1.3880631923675537e+00, 3.6900863051414490e-05,
	1.1920928955078125e-07, 4.1723251342773438e-06,
	-9.4175338745117188e-06}, /* L1456 */
{2.1057124137878418e+00, 5.6110322475433350e-05,
	1.1920928955078125e-07, -1.0114908218383789e-04,
	9.7036361694335938e-05}, /* L1457 */
{1.0557851791381836e+00, 2.8192996978759766e-05,
	1.1920928955078125e-07, -2.8610229492187500e-06,
	-3.3378601074218750e-06}, /* L1458 */
{1.4353449344635010e+00, 3.8415193557739258e-05,
	1.1920928955078125e-07, 4.5418739318847656e-05,
	2.6464462280273438e-05}, /* L1459 */
{1.9754149913787842e+00, 5.2988529205322266e-05,
	1.1920928955078125e-07, -1.7285346984863281e-05,
	-3.3855438232421875e-05}, /* L1460 */
{1.6584044694900513e+00, 4.4584274291992188e-05,
	1.1920928955078125e-07, -1.9073486328125000e-06,
	-3.1471252441406250e-05}, /* L1461 */
{1.1271488666534424e+00, 3.0368566513061523e-05,
	1.1920928955078125e-07, -2.9087066650390625e-05,
	2.1696090698242188e-05}, /* L1462 */
{1.5054625272750854e+00, 4.0650367736816406e-05,
	1.1920928955078125e-07, -1.5974044799804688e-05,
	-4.7087669372558594e-06}, /* L1463 */
{1.2962318658828735e+00, 3.5077333450317383e-05,
	1.1920928955078125e-07, 1.5497207641601562e-05,
	2.3841857910156250e-07}, /* L1464 */
{1.5944050550460815e+00, 4.3243169784545898e-05,
	1.1920928955078125e-07, 5.9604644775390625e-06,
	3.1828880310058594e-05}, /* L1465 */
{1.1379826068878174e+00, 3.0934810638427734e-05,
	1.1920928955078125e-07, -2.9325485229492188e-05,
	-3.5881996154785156e-05}, /* L1466 */
{1.4034835100173950e+00, 3.8236379623413086e-05,
	1.1920928955078125e-07, -2.2113323211669922e-05,
	9.2029571533203125e-05}, /* L1467 */
{1.2783238887786865e+00, 3.4898519515991211e-05,
	1.1920928955078125e-07, 1.4066696166992188e-05,
	-1.3351440429687500e-05}, /* L1468 */
{1.8538811206817627e+00, 5.0723552703857422e-05,
	1.1920928955078125e-07, -2.9742717742919922e-05,
	-5.3167343139648438e-05}, /* L1469 */
{1.2802045345306396e+00, 3.5107135772705078e-05,
	1.1920928955078125e-07, 8.9049339294433594e-05,
	-8.8810920715332031e-06}, /* L1470 */
{1.7689334154129028e+00, 4.8622488975524902e-05,
	1.1920928955078125e-07, -2.5033950805664062e-05,
	2.8729438781738281e-05}, /* L1471 */
{1.2634744644165039e+00, 3.4809112548828125e-05,
	1.1920928955078125e-07, 4.8279762268066406e-05,
	1.1134147644042969e-04}, /* L1472 */
{1.8021466732025146e+00, 4.9740076065063477e-05,
	1.1920928955078125e-07, -1.3172626495361328e-05,
	1.3113021850585938e-06}, /* L1473 */
{1.3816223144531250e+00, 3.8225203752517700e-05,
	1.1920928955078125e-07, 1.0883808135986328e-04,
	1.0025501251220703e-04}, /* L1474 */
{1.6515465974807739e+00, 4.5776367187500000e-05,
	1.1920928955078125e-07, -4.2915344238281250e-06,
	-1.3113021850585938e-05}, /* L1475 */
{1.6826131343841553e+00, 4.6737492084503174e-05,
	1.1920928955078125e-07, -7.3313713073730469e-06,
	-9.0003013610839844e-06}, /* L1476 */
{2.1497521400451660e+00, 5.9850513935089111e-05,
	1.1920928955078125e-07, -1.0550022125244141e-04,
	7.2121620178222656e-05}, /* L1477 */
{1.4881008863449097e+00, 4.1529536247253418e-05,
	1.1920928955078125e-07, -7.3134899139404297e-05,
	1.6868114471435547e-04}, /* L1478 */
{1.5448435544967651e+00, 4.3187290430068970e-05,
	1.1920928955078125e-07, -2.5331974029541016e-05,
	-7.7486038208007812e-07}, /* L1479 */
{1.4849699735641479e+00, 4.1604042053222656e-05,
	1.1920928955078125e-07, -2.9683113098144531e-05,
	1.8715858459472656e-05}, /* L1480 */
{2.2235758304595947e+00, 6.2428414821624756e-05,
	1.1920928955078125e-07, 4.5776367187500000e-05,
	-1.0371208190917969e-05}, /* L1481 */
{1.5330740213394165e+00, 4.3131411075592041e-05,
	1.1920928955078125e-07, -2.3245811462402344e-06,
	8.2254409790039062e-06}, /* L1482 */
{1.6582512855529785e+00, 4.6759843826293945e-05,
	1.1920928955078125e-07, 6.7472457885742188e-05,
	-2.4318695068359375e-05}, /* L1483 */
{1.5347341299057007e+00, 4.3362379074096680e-05,
	1.1920928955078125e-07, -2.5570392608642578e-05,
	-4.9471855163574219e-06}, /* L1484 */
{1.9177533388137817e+00, 5.4359436035156250e-05,
	1.1920928955078125e-07, 3.9815902709960938e-05,
	-1.4597177505493164e-04}, /* L1485 */
{1.6128203868865967e+00, 4.5783817768096924e-05,
	1.1920928955078125e-07, 1.1062622070312500e-04,
	-1.9127130508422852e-04}, /* L1486 */
{1.5746463537216187e+00, 4.4770538806915283e-05,
	1.1920928955078125e-07, -4.1723251342773438e-06,
	1.4305114746093750e-06}, /* L1487 */
{1.2361463308334351e+00, 3.5226345062255859e-05,
	1.1920928955078125e-07, 5.7697296142578125e-05,
	-5.0783157348632812e-05}, /* L1488 */
{1.2776293754577637e+00, 3.6478042602539062e-05,
	1.1920928955078125e-07, 1.1920928955078125e-06,
	5.0067901611328125e-06}, /* L1489 */
{1.0395350456237793e+00, 2.9742717742919922e-05,
	1.1920928955078125e-07, -4.7445297241210938e-05,
	4.5895576477050781e-05}, /* L1490 */
{2.0484542846679688e+00, 5.8740377426147461e-05,
	1.1920928955078125e-07, 1.4066696166992188e-04,
	-1.4621019363403320e-04}, /* L1491 */
{1.4003931283950806e+00, 4.0233135223388672e-05,
	1.1920928955078125e-07, -8.4042549133300781e-06,
	4.1723251342773438e-06}, /* L1492 */
{1.9649422168731689e+00, 5.6572258472442627e-05,
	1.1920928955078125e-07, 1.3113021850585938e-06,
	-6.3776969909667969e-06}, /* L1493 */
{1.1796791553497314e+00, 3.4034252166748047e-05,
	1.1920928955078125e-07, -5.1259994506835938e-06,
	-1.0490417480468750e-05}, /* L1494 */
{1.8512749671936035e+00, 5.3524971008300781e-05,
	1.1920928955078125e-07, 5.6028366088867188e-06,
	1.4185905456542969e-05}, /* L1495 */
{1.9978289604187012e+00, 5.7876110076904297e-05,
	1.1920928955078125e-07, -1.6629695892333984e-05,
	6.1988830566406250e-06}, /* L1496 */
{1.6106010675430298e+00, 4.6759843826293945e-05,
	1.1920928955078125e-07, 4.8637390136718750e-05,
	-3.3199787139892578e-05}, /* L1497 */
{1.1299568414688110e+00, 3.2871961593627930e-05,
	1.1920928955078125e-07, 1.0883808135986328e-04,
	-7.4744224548339844e-05}, /* L1498 */
{1.9313563108444214e+00, 5.6296586990356445e-05,
	1.1920928955078125e-07, -3.9637088775634766e-05,
	-3.9339065551757812e-05}, /* L1499 */
{1.3632235527038574e+00, 3.9815902709960938e-05,
	1.1920928955078125e-07, 9.6559524536132812e-06,
	-2.0623207092285156e-05}, /* L1500 */
{1.6506551504135132e+00, 4.8309564590454102e-05,
	1.1920928955078125e-07, -1.0490417480468750e-05,
	2.0980834960937500e-05}, /* L1501 */
{1.5693887472152710e+00, 4.6029686927795410e-05,
	1.1920928955078125e-07, -8.8930130004882812e-05,
	2.0623207092285156e-05}, /* L1502 */
{1.7611865997314453e+00, 5.1754526793956757e-05,
	1.1920928955078125e-07, 2.1457672119140625e-06,
	-1.9907951354980469e-05}, /* L1503 */
{1.9873125553131104e+00, 5.8531761169433594e-05,
	1.1920928955078125e-07, 5.8889389038085938e-05,
	-8.2612037658691406e-05}, /* L1504 */
{1.8383181095123291e+00, 5.4240226745605469e-05,
	1.1920928955078125e-07, 1.2636184692382812e-05,
	1.0371208190917969e-05}, /* L1505 */
{1.1027753353118896e+00, 3.2603740692138672e-05,
	1.1920928955078125e-07, -5.2452087402343750e-06,
	1.0728836059570312e-06}, /* L1506 */
{1.7803213596343994e+00, 5.2742660045623779e-05,
	1.1920928955078125e-07, 1.7881393432617188e-06,
	1.5258789062500000e-05}, /* L1507 */
{1.4907630681991577e+00, 4.4256448745727539e-05,
	1.1920928955078125e-07, -4.9173831939697266e-05,
	-9.0599060058593750e-05}, /* L1508 */
{2.0239846706390381e+00, 6.0200691223144531e-05,
	1.1920928955078125e-07, -1.8477439880371094e-05,
	1.8119812011718750e-05}, /* L1509 */
{1.1144508123397827e+00, 3.3214688301086426e-05,
	1.1920928955078125e-07, 6.9141387939453125e-06,
	-1.4901161193847656e-05}, /* L1510 */
{1.9620109796524048e+00, 5.8606266975402832e-05,
	1.1920928955078125e-07, -1.1438131332397461e-04,
	1.2576580047607422e-04}, /* L1511 */
{1.5394760370254517e+00, 4.6074390411376953e-05,
	1.1920928955078125e-07, -1.8656253814697266e-05,
	-5.3524971008300781e-05}, /* L1512 */
{1.6924753189086914e+00, 5.0827860832214355e-05,
	1.1920928955078125e-07, 9.6690654754638672e-04,
	8.7499618530273438e-05}, /* L1513 */
{1.1616461277008057e+00, 3.4898519515991211e-05,
	1.1920928955078125e-07, 1.0728836059570312e-06,
	4.6491622924804688e-06}, /* L1514 */
{2.3611564636230469e+00, 7.1078538894653320e-05,
	1.1920928955078125e-07, 2.3365020751953125e-05,
	5.2690505981445312e-05}, /* L1515 */
{1.7132921218872070e+00, 5.1677227020263672e-05,
	1.1920928955078125e-07, -6.0558319091796875e-05,
	1.4305114746093750e-06}, /* L1516 */
{1.9700919389724731e+00, 5.9545040130615234e-05,
	1.1920928955078125e-07, 1.2826919555664062e-04,
	5.2452087402343750e-05}, /* L1517 */
{1.4536706209182739e+00, 4.4047832489013672e-05,
	1.1920928955078125e-07, 1.8703937530517578e-04,
	-3.3789873123168945e-04}, /* L1518 */
{2.0969827175140381e+00, 6.3627958297729492e-05,
	1.1920928955078125e-07, -4.3094158172607422e-05,
	2.2411346435546875e-05}, /* L1519 */
{1.4146339893341064e+00, 4.3004751205444336e-05,
	1.1920928955078125e-07, 3.0159950256347656e-05,
	-5.8412551879882812e-06}, /* L1520 */
{2.1186771392822266e+00, 6.4536929130554199e-05,
	1.1920928955078125e-07, 5.9962272644042969e-05,
	4.8875808715820312e-06}, /* L1521 */
{1.7401461601257324e+00, 5.3107738494873047e-05,
	1.1920928955078125e-07, -1.7881393432617188e-06,
	-5.2869319915771484e-05}, /* L1522 */
{1.5861666202545166e+00, 4.8510730266571045e-05,
	1.1920928955078125e-07, -6.2406063079833984e-05,
	1.7404556274414062e-05}, /* L1523 */
{1.9230616092681885e+00, 5.8919191360473633e-05,
	1.1920928955078125e-07, -5.6028366088867188e-06,
	-1.4722347259521484e-05}, /* L1524 */
{1.7132749557495117e+00, 5.2593648433685303e-05,
	1.1920928955078125e-07, 2.5510787963867188e-05,
	-1.8477439880371094e-05}, /* L1525 */
{1.1891524791717529e+00, 3.6582350730895996e-05,
	1.1920928955078125e-07, -2.5570392608642578e-05,
	6.9737434387207031e-05}, /* L1526 */
{1.7972261905670166e+00, 5.5409967899322510e-05,
	1.1920928955078125e-07, -5.0067901611328125e-06,
	-5.6266784667968750e-05}, /* L1527 */
{1.8937269449234009e+00, 5.8472156524658203e-05,
	1.1920928955078125e-07, 1.6570091247558594e-05,
	-1.3291835784912109e-05}, /* L1528 */
{1.9247720241546631e+00, 5.9559941291809082e-05,
	1.1920928955078125e-07, -2.3424625396728516e-05,
	4.8160552978515625e-05}, /* L1529 */
{1.2874305248260498e+00, 3.9905309677124023e-05,
	1.1920928955078125e-07, -2.1457672119140625e-06,
	2.6226043701171875e-05}, /* L1530 */
{2.1404082775115967e+00, 6.6488981246948242e-05,
	1.1920928955078125e-07, -4.4941902160644531e-05,
	4.6849250793457031e-05}, /* L1531 */
{1.6732366085052490e+00, 5.2064657211303711e-05,
	1.1920928955078125e-07, 4.3392181396484375e-05,
	-8.8810920715332031e-06}, /* L1532 */
{2.1306273937225342e+00, 6.6429376602172852e-05,
	1.1920928955078125e-07, -1.2165307998657227e-04,
	-1.2755393981933594e-04}, /* L1533 */
{1.5713833570480347e+00, 4.9084424972534180e-05,
	1.1920928955078125e-07, -3.7610530853271484e-05,
	2.7894973754882812e-05}, /* L1534 */
{2.1737983226776123e+00, 6.8031251430511475e-05,
	1.1920928955078125e-07, -4.6491622924804688e-06,
	-1.7523765563964844e-05}, /* L1535 */
{1.7201981544494629e+00, 5.3938478231430054e-05,
	1.1920928955078125e-07, 7.6293945312500000e-06,
	-4.4107437133789062e-06}, /* L1536 */
{1.5260287523269653e+00, 4.7951936721801758e-05,
	1.1920928955078125e-07, -8.6069107055664062e-05,
	-5.7756900787353516e-05}, /* L1537 */
{1.3840992450714111e+00, 4.3570995330810547e-05,
	1.1920928955078125e-07, -7.3254108428955078e-05,
	-1.1271238327026367e-04}, /* L1538 */
{1.5215897560119629e+00, 4.7981739044189453e-05,
	1.1920928955078125e-07, 3.2782554626464844e-05,
	-6.2108039855957031e-05}, /* L1539 */
{1.6385518312454224e+00, 5.1766633987426758e-05,
	1.1920928955078125e-07, -3.0159950256347656e-05,
	-4.3332576751708984e-05}, /* L1540 */
{2.6145944595336914e+00, 8.2880258560180664e-05,
	1.1920928955078125e-07, 8.7380409240722656e-04,
	6.5803527832031250e-04}, /* L1541 */
{1.4643225669860840e+00, 4.6461820602416992e-05,
	1.1920928955078125e-07, -6.2167644500732422e-05,
	7.0214271545410156e-05}, /* L1542 */
{1.5510369539260864e+00, 4.9471855163574219e-05,
	1.1920928955078125e-07, 2.1610260009765625e-03,
	6.7126750946044922e-04}, /* L1543 */
{1.6978869438171387e+00, 5.4046511650085449e-05,
	1.1920928955078125e-07, -8.3446502685546875e-06,
	4.9710273742675781e-05}, /* L1544 */
{2.9040098190307617e+00, 9.2715024948120117e-05,
	1.1920928955078125e-07, -3.6090612411499023e-04,
	2.8729438781738281e-05}, /* L1545 */
{1.4747371673583984e+00, 4.7117471694946289e-05,
	1.1920928955078125e-07, 1.6689300537109375e-06,
	1.5497207641601562e-05}, /* L1546 */
{2.5894241333007812e+00, 8.2999467849731445e-05,
	1.1920928955078125e-07, -2.7740001678466797e-04,
	3.2389163970947266e-04}, /* L1547 */
{1.4263014793395996e+00, 4.5739114284515381e-05,
	1.1920928955078125e-07, -2.9802322387695312e-07,
	-7.9274177551269531e-06}, /* L1548 */
{2.3825769424438477e+00, 7.6547265052795410e-05,
	1.1920928955078125e-07, -6.4373016357421875e-06,
	8.4638595581054688e-06}, /* L1549 */
{1.0481963157653809e+00, 3.3739954233169556e-05,
	1.1920928955078125e-07, 1.0490417480468750e-05,
	1.7642974853515625e-05}, /* L1550 */
{1.7919580936431885e+00, 5.7786703109741211e-05,
	1.1920928955078125e-07, 2.8610229492187500e-06,
	-1.8477439880371094e-06}, /* L1551 */
{1.4354053735733032e+00, 4.6379864215850830e-05,
	1.1920928955078125e-07, 4.2319297790527344e-05,
	-8.8214874267578125e-06}, /* L1552 */
{2.2453553676605225e+00, 7.3224306106567383e-05,
	1.1920928955078125e-07, -2.3877620697021484e-03,
	2.1587610244750977e-03}, /* L1553 */
{1.5011637210845947e+00, 4.8726797103881836e-05,
	1.1920928955078125e-07, -5.8555603027343750e-04,
	2.6702880859375000e-04}, /* L1554 */
{1.6169064044952393e+00, 5.2530318498611450e-05,
	1.1920928955078125e-07, 7.9870223999023438e-06,
	1.0597705841064453e-04}, /* L1555 */
{1.5450292825698853e+00, 5.0283968448638916e-05,
	1.1920928955078125e-07, 1.7762184143066406e-05,
	-8.7022781372070312e-06}, /* L1556 */
{2.0099329948425293e+00, 6.5542757511138916e-05,
	1.1920928955078125e-07, -4.9233436584472656e-05,
	-4.2319297790527344e-05}, /* L1557 */
{1.2560998201370239e+00, 4.1037797927856445e-05,
	1.1920928955078125e-07, -1.8179416656494141e-05,
	5.8293342590332031e-05}, /* L1558 */
{1.7137652635574341e+00, 5.6087970733642578e-05,
	1.1920928955078125e-07, 4.6014785766601562e-05,
	-6.8128108978271484e-05}, /* L1559 */
{1.6471037864685059e+00, 5.4001808166503906e-05,
	1.1920928955078125e-07, -6.6041946411132812e-05,
	3.2544136047363281e-05}, /* L1560 */
{2.0242938995361328e+00, 6.6488981246948242e-05,
	1.1920928955078125e-07, -7.0929527282714844e-06,
	-6.1333179473876953e-05}, /* L1561 */
{1.3907424211502075e+00, 4.5776367187500000e-05,
	1.1920928955078125e-07, -1.0359287261962891e-04,
	2.0051002502441406e-04}, /* L1562 */
{1.7893331050872803e+00, 5.9008598327636719e-05,
	1.1920928955078125e-07, 5.8770179748535156e-05,
	4.8637390136718750e-05}, /* L1563 */
{1.4569642543792725e+00, 4.8115849494934082e-05,
	1.1920928955078125e-07, -1.8179416656494141e-05,
	-1.7285346984863281e-06}, /* L1564 */
{1.7615898847579956e+00, 5.8293342590332031e-05,
	1.1920928955078125e-07, -1.2439489364624023e-04,
	-2.0325183868408203e-04}, /* L1565 */
{1.4934916496276855e+00, 4.9497932195663452e-05,
	1.1920928955078125e-07, -1.6391277313232422e-05,
	1.8239021301269531e-05}, /* L1566 */
{1.6852548122406006e+00, 5.5953860282897949e-05,
	1.1920928955078125e-07, -1.6689300537109375e-05,
	-2.6106834411621094e-05}, /* L1567 */
{1.9645620584487915e+00, 6.5356492996215820e-05,
	1.1920928955078125e-07, 4.7922134399414062e-05,
	-5.2571296691894531e-05}, /* L1568 */
{2.5756866931915283e+00, 8.5830688476562500e-05,
	1.1920928955078125e-07, -6.6757202148437500e-06,
	-6.2286853790283203e-05}, /* L1569 */
{1.2981446981430054e+00, 4.3332576751708984e-05,
	1.1920928955078125e-07, -1.5437602996826172e-05,
	9.6559524536132812e-06}, /* L1570 */
{1.6806840896606445e+00, 5.6207180023193359e-05,
	1.1920928955078125e-07, -2.0265579223632812e-06,
	-1.2218952178955078e-05}, /* L1571 */
{1.3308761119842529e+00, 4.4584274291992188e-05,
	1.1920928955078125e-07, -3.0398368835449219e-06,
	2.4318695068359375e-05}, /* L1572 */
{2.1907477378845215e+00, 7.3522329330444336e-05,
	1.1920928955078125e-07, -2.8610229492187500e-06,
	1.1682510375976562e-05}, /* L1573 */
{1.2211368083953857e+00, 4.1067600250244141e-05,
	1.1920928955078125e-07, 6.9379806518554688e-05,
	1.7130374908447266e-04}, /* L1574 */
{1.9338735342025757e+00, 6.5132975578308105e-05,
	1.1920928955078125e-07, -9.0003013610839844e-06,
	-5.5611133575439453e-05}, /* L1575 */
{1.5046993494033813e+00, 5.0768256187438965e-05,
	1.1920928955078125e-07, -1.1861324310302734e-05,
	-2.9683113098144531e-05}, /* L1576 */
{2.0874316692352295e+00, 7.0601701736450195e-05,
	1.1920928955078125e-07, -1.6301870346069336e-04,
	9.2267990112304688e-05}, /* L1577 */
{1.3573189973831177e+00, 4.5955181121826172e-05,
	1.1920928955078125e-07, -2.6822090148925781e-06,
	-3.5762786865234375e-06}, /* L1578 */
{2.6554052829742432e+00, 9.0062618255615234e-05,
	1.1920928955078125e-07, 3.5762786865234375e-06,
	2.2649765014648438e-06}, /* L1579 */
{1.5302015542984009e+00, 5.1990151405334473e-05,
	1.1920928955078125e-07, -1.6152858734130859e-05,
	9.4175338745117188e-06}, /* L1580 */
{2.1459891796112061e+00, 7.3045492172241211e-05,
	1.1920928955078125e-07, 2.6106834411621094e-05,
	1.4066696166992188e-05}, /* L1581 */
{1.6581412553787231e+00, 5.6535005569458008e-05,
	1.1920928955078125e-07, 1.1444091796875000e-05,
	5.8412551879882812e-06}, /* L1582 */
{1.6590129137039185e+00, 5.6669116020202637e-05,
	1.1920928955078125e-07, -6.9975852966308594e-05,
	-1.0192394256591797e-05}, /* L1583 */
{2.0739428997039795e+00, 7.0989131927490234e-05,
	1.1920928955078125e-07, -5.2452087402343750e-05,
	-8.0108642578125000e-05}, /* L1584 */
{2.2205832004547119e+00, 7.6107680797576904e-05,
	1.1920928955078125e-07, -1.0907649993896484e-05,
	6.4373016357421875e-06}, /* L1585 */
{1.2821903228759766e+00, 4.4047832489013672e-05,
	1.1920928955078125e-07, -4.5537948608398438e-05,
	-6.0796737670898438e-06}, /* L1586 */
{2.3135478496551514e+00, 7.9602003097534180e-05,
	1.1920928955078125e-07, -1.2749433517456055e-04,
	-1.6570091247558594e-04}, /* L1587 */
{1.6386511325836182e+00, 5.6475400924682617e-05,
	1.1920928955078125e-07, -9.7990036010742188e-05,
	-4.5359134674072266e-05}, /* L1588 */
{1.7943061590194702e+00, 6.1929225921630859e-05,
	1.1920928955078125e-07, -6.3478946685791016e-05,
	-2.4855136871337891e-05}, /* L1589 */
{1.3809245824813843e+00, 4.7743320465087891e-05,
	1.1920928955078125e-07, -1.2099742889404297e-05,
	-3.4332275390625000e-05}, /* L1590 */
{2.4040441513061523e+00, 8.3267688751220703e-05,
	1.1920928955078125e-07, -1.2350082397460938e-04,
	8.3804130554199219e-05}, /* L1591 */
{1.8293954133987427e+00, 6.3464045524597168e-05,
	1.1920928955078125e-07, -1.0907649993896484e-05,
	5.0067901611328125e-06}, /* L1592 */
{2.0455167293548584e+00, 7.1084126830101013e-05,
	1.1920928955078125e-07, 9.8943710327148438e-06,
	-4.8279762268066406e-06}, /* L1593 */
{1.6171967983245850e+00, 5.6326389312744141e-05,
	1.1920928955078125e-07, 1.4758110046386719e-04,
	2.2685527801513672e-04}, /* L1594 */
{2.0097320079803467e+00, 7.0080161094665527e-05,
	1.1920928955078125e-07, 3.6716461181640625e-05,
	-1.9192695617675781e-05}, /* L1595 */
{1.5680779218673706e+00, 5.4776668548583984e-05,
	1.1920928955078125e-07, 5.2213668823242188e-05,
	-2.2053718566894531e-05}, /* L1596 */
{2.9544463157653809e+00, 1.0338425636291504e-04,
	1.1920928955078125e-07, 3.8862228393554688e-05,
	-4.4286251068115234e-05}, /* L1597 */
{1.8332197666168213e+00, 6.4253807067871094e-05,
	1.1920928955078125e-07, 1.3828277587890625e-05,
	2.0265579223632812e-05}, /* L1598 */
{1.9086176156997681e+00, 6.7010521888732910e-05,
	1.1920928955078125e-07, 3.7908554077148438e-05,
	-3.4511089324951172e-05}, /* L1599 */
{1.5753525495529175e+00, 5.5402517318725586e-05,
	1.1920928955078125e-07, -4.1723251342773438e-06,
	-2.5808811187744141e-05}, /* L1600 */
{1.9220883846282959e+00, 6.7710876464843750e-05,
	1.1920928955078125e-07, 7.3909759521484375e-06,
	1.3828277587890625e-05}, /* L1601 */
{1.3358314037322998e+00, 4.7139823436737061e-05,
	1.1920928955078125e-07, -2.8252601623535156e-05,
	1.9669532775878906e-05}, /* L1602 */
{2.1455285549163818e+00, 7.5843185186386108e-05,
	1.1920928955078125e-07, 2.7179718017578125e-05,
	-1.8298625946044922e-05}, /* L1603 */
{1.4477404356002808e+00, 5.1259994506835938e-05,
	1.1920928955078125e-07, -3.1590461730957031e-05,
	-1.1920928955078125e-05}, /* L1604 */
{2.4598176479339600e+00, 8.7320804595947266e-05,
	1.1920928955078125e-07, -4.3809413909912109e-04,
	-4.8255920410156250e-04}, /* L1605 */
{1.4193363189697266e+00, 5.0425529479980469e-05,
	1.1920928955078125e-07, 5.9604644775390625e-07,
	3.6239624023437500e-05}, /* L1606 */
{1.6554319858551025e+00, 5.8919191360473633e-05,
	1.1920928955078125e-07, -1.8656253814697266e-05,
	-5.9962272644042969e-05}, /* L1607 */
{1.6987222433090210e+00, 6.0550868511199951e-05,
	1.1920928955078125e-07, -1.0550022125244141e-05,
	1.0728836059570312e-06}, /* L1608 */
{2.6107833385467529e+00, 9.3219801783561707e-05,
	1.1920928955078125e-07, -1.0728836059570312e-06,
	-3.1828880310058594e-05}, /* L1609 */
{1.4334782361984253e+00, 5.1409006118774414e-05,
	1.1920928955078125e-07, -1.0981559753417969e-03,
	-1.0913610458374023e-04}, /* L1610 */
{2.5392487049102783e+00, 9.0986490249633789e-05,
	1.1920928955078125e-07, 6.1750411987304688e-05,
	1.6331672668457031e-05}, /* L1611 */
{1.4882453680038452e+00, 5.3405761718750000e-05,
	1.1920928955078125e-07, 4.7683715820312500e-07,
	-4.7862529754638672e-05}, /* L1612 */
{1.7979615926742554e+00, 6.4939260482788086e-05,
	1.1920928955078125e-07, 4.2915344238281250e-04,
	-9.5635652542114258e-04}, /* L1613 */
{1.7160894870758057e+00, 6.1810016632080078e-05,
	1.1920928955078125e-07, 1.8751621246337891e-04,
	-1.7344951629638672e-05}, /* L1614 */
{2.0119936466217041e+00, 7.2568655014038086e-05,
	1.1920928955078125e-07, -2.7894973754882812e-05,
	5.8650970458984375e-05}, /* L1615 */
{1.6964043378829956e+00, 6.1303377151489258e-05,
	1.1920928955078125e-07, 1.7869472503662109e-04,
	-1.1575222015380859e-04}, /* L1616 */
{2.3658163547515869e+00, 8.5614621639251709e-05,
	1.1920928955078125e-07, 8.9406967163085938e-06,
	4.0650367736816406e-05}, /* L1617 */
{1.9094018936157227e+00, 6.9200992584228516e-05,
	1.1920928955078125e-07, -1.5377998352050781e-05,
	7.9870223999023438e-06}, /* L1618 */
{2.4481444358825684e+00, 8.8870525360107422e-05,
	1.1920928955078125e-07, 5.0425529479980469e-05,
	7.0333480834960938e-06}, /* L1619 */
{1.8851681947708130e+00, 6.8545341491699219e-05,
	1.1920928955078125e-07, -2.0265579223632812e-06,
	4.0531158447265625e-06}, /* L1620 */
{2.6643478870391846e+00, 9.7036361694335938e-05,
	1.1920928955078125e-07, -7.8678131103515625e-06,
	2.9563903808593750e-05}, /* L1621 */
{2.1620888710021973e+00, 7.8931450843811035e-05,
	1.1920928955078125e-07, -1.8262863159179688e-04,
	-8.1658363342285156e-06}, /* L1622 */
{2.5466248989105225e+00, 9.3065202236175537e-05,
	1.1920928955078125e-07, 1.0585784912109375e-04,
	7.0333480834960938e-06}, /* L1623 */
{1.8539042472839355e+00, 6.7859888076782227e-05,
	1.1920928955078125e-07, -3.1411647796630859e-05,
	-1.5497207641601562e-06}, /* L1624 */
{1.9892973899841309e+00, 7.2926282882690430e-05,
	1.1920928955078125e-07, -3.9339065551757812e-06,
	-1.2695789337158203e-05}, /* L1625 */
{1.2623553276062012e+00, 4.6372413635253906e-05,
	1.1920928955078125e-07, -2.1350383758544922e-04,
	-2.0825862884521484e-04}, /* L1626 */
{1.4568940401077271e+00, 5.3584575653076172e-05,
	1.1920928955078125e-07, 2.8133392333984375e-05,
	1.6689300537109375e-06}, /* L1627 */
{1.7426048517227173e+00, 6.4194202423095703e-05,
	1.1920928955078125e-07, -5.3644180297851562e-06,
	-4.3392181396484375e-05}, /* L1628 */
{2.1693186759948730e+00, 8.0078840255737305e-05,
	1.1920928955078125e-07, 1.6331672668457031e-05,
	7.0452690124511719e-05}, /* L1629 */
{1.7258934974670410e+00, 6.3784420490264893e-05,
	1.1920928955078125e-07, -2.5808811187744141e-05,
	-2.8431415557861328e-05}, /* L1630 */
{2.1555266380310059e+00, 7.9799443483352661e-05,
	1.1920928955078125e-07, -5.4597854614257812e-05,
	-4.8995018005371094e-05}, /* L1631 */
{1.6544167995452881e+00, 6.2882900238037109e-05,
	1.1920928955078125e-07, -6.6698789596557617e-03,
	5.8200359344482422e-03}, /* L1632 */
{2.3437118530273438e+00, 8.7037682533264160e-05,
	1.1920928955078125e-07, -7.3909759521484375e-06,
	3.3378601074218750e-06}, /* L1633 */
{1.5294830799102783e+00, 5.6892633438110352e-05,
	1.1920928955078125e-07, 6.5565109252929688e-06,
	3.5643577575683594e-05}, /* L1634 */
{1.7582176923751831e+00, 6.5505504608154297e-05,
	1.1920928955078125e-07, -1.3053417205810547e-05,
	4.1007995605468750e-05}, /* L1635 */
{1.7990097999572754e+00, 6.7129731178283691e-05,
	1.1920928955078125e-07, 2.6106834411621094e-05,
	-7.0333480834960938e-06}, /* L1636 */
{2.2227990627288818e+00, 8.3133578300476074e-05,
	1.1920928955078125e-07, -5.3405761718750000e-05,
	1.1205673217773438e-05}, /* L1637 */
{1.7688533067703247e+00, 6.6220760345458984e-05,
	1.1920928955078125e-07, 1.9073486328125000e-06,
	-4.5478343963623047e-05}, /* L1638 */
{1.8815815448760986e+00, 7.0706009864807129e-05,
	1.1920928955078125e-07, -1.2922286987304688e-04,
	-4.6312808990478516e-05}, /* L1639 */
{1.6056692600250244e+00, 6.0424208641052246e-05,
	1.1920928955078125e-07, -5.6302547454833984e-04,
	-3.9988756179809570e-04}, /* L1640 */
{2.4445848464965820e+00, 9.1969966888427734e-05,
	1.1920928955078125e-07, -1.5676021575927734e-04,
	-3.7372112274169922e-05}, /* L1641 */
{1.3839454650878906e+00, 5.2139163017272949e-05,
	1.1920928955078125e-07, -6.7174434661865234e-05,
	5.0067901611328125e-06}, /* L1642 */
{2.0602412223815918e+00, 7.7739357948303223e-05,
	1.1920928955078125e-07, 6.9141387939453125e-06,
	8.4638595581054688e-06}, /* L1643 */
{1.8682886362075806e+00, 7.0616602897644043e-05,
	1.1920928955078125e-07, 2.3245811462402344e-05,
	2.0384788513183594e-05}, /* L1644 */
{3.0392105579376221e+00, 1.1503696441650391e-04,
	1.1920928955078125e-07, 1.7881393432617188e-06,
	3.0517578125000000e-05}, /* L1645 */
{1.5671128034591675e+00, 5.9410929679870605e-05,
	1.1920928955078125e-07, -2.5212764739990234e-05,
	-8.1658363342285156e-06}, /* L1646 */
{2.5605208873748779e+00, 9.7230076789855957e-05,
	1.1920928955078125e-07, -4.9471855163574219e-06,
	-4.5120716094970703e-05}, /* L1647 */
{1.5962239503860474e+00, 6.0707330703735352e-05,
	1.1920928955078125e-07, -7.3969364166259766e-05,
	-5.0246715545654297e-05}, /* L1648 */
{2.5346782207489014e+00, 9.6559524536132812e-05,
	1.1920928955078125e-07, -1.8376111984252930e-04,
	5.5193901062011719e-05}, /* L1649 */
{1.4176317453384399e+00, 5.4091215133666992e-05,
	1.1920928955078125e-07, -6.7174434661865234e-05,
	-1.0311603546142578e-05}, /* L1650 */
{2.1029851436614990e+00, 8.0352649092674255e-05,
	1.1920928955078125e-07, -4.8875808715820312e-06,
	2.2292137145996094e-05}, /* L1651 */
{1.9991426467895508e+00, 7.6502561569213867e-05,
	1.1920928955078125e-07, 3.5762786865234375e-07,
	1.5497207641601562e-06}, /* L1652 */
{1.7428052425384521e+00, 6.6801905632019043e-05,
	1.1920928955078125e-07, 1.8119812011718750e-05,
	6.0439109802246094e-05}, /* L1653 */
{1.7064628601074219e+00, 6.5505504608154297e-05,
	1.1920928955078125e-07, -6.5565109252929688e-07,
	2.2649765014648438e-06}, /* L1654 */
{2.1256141662597656e+00, 8.1729143857955933e-05,
	1.1920928955078125e-07, -3.9041042327880859e-05,
	2.1934509277343750e-05}, /* L1655 */
{1.6816952228546143e+00, 6.4760446548461914e-05,
	1.1920928955078125e-07, -2.7298927307128906e-05,
	-1.9848346710205078e-05}, /* L1656 */
{2.0869371891021729e+00, 8.0496072769165039e-05,
	1.1920928955078125e-07, -4.7445297241210938e-05,
	5.9485435485839844e-05}, /* L1657 */
{1.5306817293167114e+00, 5.9127807617187500e-05,
	1.1920928955078125e-07, 2.1219253540039062e-05,
	-7.3015689849853516e-05}, /* L1658 */
{2.3187510967254639e+00, 8.9704990386962891e-05,
	1.1920928955078125e-07, -6.8902969360351562e-05,
	-4.3213367462158203e-05}, /* L1659 */
{1.7622005939483643e+00, 6.8277120590209961e-05,
	1.1920928955078125e-07, 3.1948089599609375e-05,
	9.7751617431640625e-06}, /* L1660 */
{1.9776018857955933e+00, 7.6770782470703125e-05,
	1.1920928955078125e-07, -8.1002712249755859e-05,
	2.0635128021240234e-04}, /* L1661 */
{1.4050763845443726e+00, 5.4612755775451660e-05,
	1.1920928955078125e-07, -7.3790550231933594e-05,
	-2.4676322937011719e-05}, /* L1662 */
{2.3198952674865723e+00, 9.0301036834716797e-05,
	1.1920928955078125e-07, 2.3841857910156250e-07,
	2.6226043701171875e-06}, /* L1663 */
{1.1947917938232422e+00, 4.6581029891967773e-05,
	1.1920928955078125e-07, -3.3915042877197266e-05,
	-3.9041042327880859e-05}, /* L1664 */
{2.1869087219238281e+00, 8.5383653640747070e-05,
	1.1920928955078125e-07, 7.9870223999023438e-06,
	5.0067901611328125e-06}, /* L1665 */
{1.8649330139160156e+00, 7.2926282882690430e-05,
	1.1920928955078125e-07, 2.6702880859375000e-05,
	1.0132789611816406e-05}, /* L1666 */
{2.2221548557281494e+00, 8.7022781372070312e-05,
	1.1920928955078125e-07, 5.4836273193359375e-06,
	-1.6689300537109375e-06}, /* L1667 */
{1.5864865779876709e+00, 6.2227249145507812e-05,
	1.1920928955078125e-07, -2.9146671295166016e-05,
	-1.2278556823730469e-05}, /* L1668 */
{2.3221783638000488e+00, 9.1221183538436890e-05,
	1.1920928955078125e-07, -2.0861625671386719e-05,
	-2.8610229492187500e-06}, /* L1669 */
{1.7372859716415405e+00, 6.8373978137969971e-05,
	1.1920928955078125e-07, -2.1171569824218750e-04,
	1.2695789337158203e-04}, /* L1670 */
{2.5208034515380859e+00, 9.9360942840576172e-05,
	1.1920928955078125e-07, -2.5212764739990234e-05,
	1.1920928955078125e-06}, /* L1671 */
{1.6139509677886963e+00, 6.3687562942504883e-05,
	1.1920928955078125e-07, 2.5391578674316406e-05,
	1.8477439880371094e-05}, /* L1672 */
{2.0792121887207031e+00, 8.2179903984069824e-05,
	1.1920928955078125e-07, -5.9783458709716797e-05,
	-3.7074089050292969e-05}, /* L1673 */
{1.6847186088562012e+00, 6.6684558987617493e-05,
	1.1920928955078125e-07, -2.7477741241455078e-05,
	-4.2378902435302734e-05}, /* L1674 */
{1.8724658489227295e+00, 7.4222683906555176e-05,
	1.1920928955078125e-07, -1.9252300262451172e-05,
	-4.8875808715820312e-06}, /* L1675 */
{1.4882587194442749e+00, 5.9083104133605957e-05,
	1.1920928955078125e-07, -2.0802021026611328e-05,
	-1.9371509552001953e-05}, /* L1676 */
{2.2740080356597900e+00, 9.0420246124267578e-05,
	1.1920928955078125e-07, -8.6903572082519531e-05,
	-4.6372413635253906e-05}, /* L1677 */
{1.8998298645019531e+00, 7.5817108154296875e-05,
	1.1920928955078125e-07, -1.6093254089355469e-06,
	-6.2245130538940430e-04}, /* L1678 */
{2.1470892429351807e+00, 8.5622072219848633e-05,
	1.1920928955078125e-07, -3.1411647796630859e-05,
	1.0609626770019531e-05}, /* L1679 */
{2.1589746475219727e+00, 8.6233019828796387e-05,
	1.1920928955078125e-07, -1.7940998077392578e-05,
	-7.7486038208007812e-05}, /* L1680 */
{2.6408479213714600e+00, 1.0585784912109375e-04,
	1.1920928955078125e-07, -1.2010335922241211e-04,
	5.7911872863769531e-04}, /* L1681 */
{2.2424156665802002e+00, 8.9854001998901367e-05,
	1.1920928955078125e-07, -1.0979175567626953e-04,
	-8.6069107055664062e-05}, /* L1682 */
{2.6493763923645020e+00, 1.0631978511810303e-04,
	1.1920928955078125e-07, 2.0098686218261719e-04,
	-6.5386295318603516e-05}, /* L1683 */
{1.9800323247909546e+00, 7.9557299613952637e-05,
	1.1920928955078125e-07, 8.5592269897460938e-05,
	-1.5676021575927734e-05}, /* L1684 */
{2.6626889705657959e+00, 1.0713934898376465e-04,
	1.1920928955078125e-07, -7.1525573730468750e-07,
	2.2411346435546875e-05}, /* L1685 */
{1.7357704639434814e+00, 6.9946050643920898e-05,
	1.1920928955078125e-07, 2.1457672119140625e-05,
	-2.8610229492187500e-06}, /* L1686 */
{1.8876268863677979e+00, 7.6174736022949219e-05,
	1.1920928955078125e-07, 4.7683715820312500e-07,
	-2.4318695068359375e-05}, /* L1687 */
{1.7651349306106567e+00, 7.1346759796142578e-05,
	1.1920928955078125e-07, -2.9444694519042969e-05,
	6.4253807067871094e-05}, /* L1688 */
{2.3339831829071045e+00, 9.4525516033172607e-05,
	1.1920928955078125e-07, -1.0180473327636719e-04,
	-2.0563602447509766e-04}, /* L1689 */
{2.0596404075622559e+00, 8.3655118942260742e-05,
	1.1920928955078125e-07, 2.8145313262939453e-04,
	1.8250942230224609e-04}, /* L1690 */
{2.4040806293487549e+00, 9.7632408142089844e-05,
	1.1920928955078125e-07, -3.1763315200805664e-04,
	1.4066696166992188e-05}, /* L1691 */
{1.6582144498825073e+00, 6.7412853240966797e-05,
	1.1920928955078125e-07, 1.1563301086425781e-05,
	3.6954879760742188e-05}, /* L1692 */
{2.1082248687744141e+00, 8.5830688476562500e-05,
	1.1920928955078125e-07, -1.3113021850585938e-06,
	-6.7353248596191406e-06}, /* L1693 */
{1.4668284654617310e+00, 5.9828162193298340e-05,
	1.1920928955078125e-07, 3.5762786865234375e-06,
	-1.4495849609375000e-04}, /* L1694 */
{2.2771246433258057e+00, 9.2990696430206299e-05,
	1.1920928955078125e-07, -7.5519084930419922e-05,
	4.1842460632324219e-05}, /* L1695 */
{2.1812453269958496e+00, 8.9198350906372070e-05,
	1.1920928955078125e-07, -1.7046928405761719e-05,
	3.8623809814453125e-05}, /* L1696 */
{1.8539848327636719e+00, 7.5936317443847656e-05,
	1.1920928955078125e-07, -9.1195106506347656e-05,
	5.6028366088867188e-06}, /* L1697 */
{1.6613483428955078e+00, 6.8135559558868408e-05,
	1.1920928955078125e-07, 1.2993812561035156e-05,
	-2.0563602447509766e-05}, /* L1698 */
{2.2887988090515137e+00, 9.4026327133178711e-05,
	1.1920928955078125e-07, 1.0752677917480469e-04,
	2.4557113647460938e-05}, /* L1699 */
{2.0444700717926025e+00, 8.4146857261657715e-05,
	1.1920928955078125e-07, -4.5561790466308594e-04,
	-1.3476610183715820e-04}, /* L1700 */
{3.1926982402801514e+00, 1.3151764869689941e-04,
	1.1920928955078125e-07, -1.0341405868530273e-04,
	-4.1961669921875000e-05}, /* L1701 */
{1.7540787458419800e+00, 7.2360038757324219e-05,
	1.1920928955078125e-07, -1.4305114746093750e-05,
	-3.6776065826416016e-05}, /* L1702 */
{1.9683402776718140e+00, 8.1311911344528198e-05,
	1.1920928955078125e-07, -2.1815299987792969e-05,
	-1.0132789611816406e-05}, /* L1703 */
{1.5366808176040649e+00, 6.3728541135787964e-05,
	1.1920928955078125e-07, 1.4095306396484375e-03,
	8.8453292846679688e-04}, /* L1704 */
{2.3481090068817139e+00, 9.7325071692466736e-05,
	1.1920928955078125e-07, -1.1062622070312500e-04,
	2.0515918731689453e-04}, /* L1705 */
{1.2620661258697510e+00, 5.2362680435180664e-05,
	1.1920928955078125e-07, 1.1765956878662109e-04,
	-1.0788440704345703e-05}, /* L1706 */
{1.8564250469207764e+00, 7.7128410339355469e-05,
	1.1920928955078125e-07, -2.3066997528076172e-05,
	-1.0609626770019531e-05}, /* L1707 */
{1.9809130430221558e+00, 8.2433223724365234e-05,
	1.1920928955078125e-07, 1.2719631195068359e-04,
	1.4805793762207031e-04}, /* L1708 */
{2.1545314788818359e+00, 8.9779496192932129e-05,
	1.1920928955078125e-07, 6.8545341491699219e-05,
	-1.4424324035644531e-05}, /* L1709 */
{1.9002609252929688e+00, 7.9289078712463379e-05,
	1.1920928955078125e-07, -1.6629695892333984e-05,
	-2.0861625671386719e-05}, /* L1710 */
{2.1194939613342285e+00, 8.8572502136230469e-05,
	1.1920928955078125e-07, -6.1452388763427734e-05,
	1.3589859008789062e-05}, /* L1711 */
{1.7199875116348267e+00, 7.1972608566284180e-05,
	1.1920928955078125e-07, -9.8943710327148438e-06,
	-4.2438507080078125e-05}, /* L1712 */
{2.3216865062713623e+00, 9.7289681434631348e-05,
	1.1920928955078125e-07, -1.4841556549072266e-05,
	-8.7618827819824219e-06}, /* L1713 */
{1.7669166326522827e+00, 7.4148178100585938e-05,
	1.1920928955078125e-07, 6.7949295043945312e-06,
	-2.2649765014648438e-05}, /* L1714 */
{1.6694194078445435e+00, 7.0154666900634766e-05,
	1.1920928955078125e-07, 2.0265579223632812e-05,
	0.0000000000000000e+00}, /* L1715 */
{1.6188361644744873e+00, 6.8128108978271484e-05,
	1.1920928955078125e-07, -1.1086463928222656e-05,
	1.1444091796875000e-05}, /* L1716 */
{2.3602023124694824e+00, 9.9480152130126953e-05,
	1.1920928955078125e-07, -4.8875808715820312e-06,
	-1.1706352233886719e-04}, /* L1717 */
{1.4274255037307739e+00, 6.0252845287322998e-05,
	1.1920928955078125e-07, 1.2528896331787109e-04,
	-1.0192394256591797e-05}, /* L1718 */
{2.2988367080688477e+00, 9.7155570983886719e-05,
	1.1920928955078125e-07, 2.7298927307128906e-05,
	2.9206275939941406e-05}, /* L1719 */
{1.5461632013320923e+00, 6.5445899963378906e-05,
	1.1920928955078125e-07, 3.9935111999511719e-05,
	6.6280364990234375e-05}, /* L1720 */
{1.9090785980224609e+00, 8.0959871411323547e-05,
	1.1920928955078125e-07, 1.1324882507324219e-04,
	-3.7992000579833984e-04}, /* L1721 */
{1.5375938415527344e+00, 6.5263360738754272e-05,
	1.1920928955078125e-07, 5.7220458984375000e-06,
	-9.2983245849609375e-06}, /* L1722 */
{2.0910115242004395e+00, 8.8870525360107422e-05,
	1.1920928955078125e-07, -4.2915344238281250e-06,
	6.5207481384277344e-05}, /* L1723 */
{1.7595071792602539e+00, 7.4893236160278320e-05,
	1.1920928955078125e-07, -1.2814998626708984e-05,
	7.4505805969238281e-05}, /* L1724 */
{2.1591715812683105e+00, 9.2029571533203125e-05,
	1.1920928955078125e-07, 1.1086463928222656e-05,
	-1.8179416656494141e-05}, /* L1725 */
{1.6088076829910278e+00, 6.8664550781250000e-05,
	1.1920928955078125e-07, 2.8610229492187500e-06,
	-3.0219554901123047e-05}, /* L1726 */
{2.5671923160552979e+00, 1.0973215103149414e-04,
	1.1920928955078125e-07, 5.8293342590332031e-05,
	-6.3776969909667969e-06}, /* L1727 */
{1.9288637638092041e+00, 8.2552433013916016e-05,
	1.1920928955078125e-07, 1.1920928955078125e-06,
	-1.1801719665527344e-05}, /* L1728 */
{3.1062536239624023e+00, 1.3312697410583496e-04,
	1.1920928955078125e-07, 1.2636184692382812e-05,
	9.5367431640625000e-06}, /* L1729 */
{1.7863671779632568e+00, 7.6666474342346191e-05,
	1.1920928955078125e-07, 2.2649765014648438e-06,
	-1.2338161468505859e-05}, /* L1730 */
{2.3592751026153564e+00, 1.0144710540771484e-04,
	1.1920928955078125e-07, 1.3911724090576172e-04,
	1.4853477478027344e-04}, /* L1731 */
{2.2422988414764404e+00, 9.6499919891357422e-05,
	1.1920928955078125e-07, 4.0531158447265625e-06,
	1.0132789611816406e-05}, /* L1732 */
{2.1561350822448730e+00, 9.2923641204833984e-05,
	1.1920928955078125e-07, -7.0333480834960938e-06,
	-9.0003013610839844e-06}, /* L1733 */
{1.4140819311141968e+00, 6.1035156250000000e-05,
	1.1920928955078125e-07, -9.4473361968994141e-05,
	3.5405158996582031e-05}, /* L1734 */
{2.0418946743011475e+00, 8.8244676589965820e-05,
	1.1920928955078125e-07, 2.3722648620605469e-05,
	1.0251998901367188e-05}, /* L1735 */
{1.7496078014373779e+00, 7.5727701187133789e-05,
	1.1920928955078125e-07, -4.5716762542724609e-05,
	8.7022781372070312e-06}, /* L1736 */
{2.6250491142272949e+00, 1.1377036571502686e-04,
	1.1920928955078125e-07, -2.0861625671386719e-05,
	5.3882598876953125e-05}, /* L1737 */
{1.9813417196273804e+00, 8.5987150669097900e-05,
	1.1920928955078125e-07, 1.1444091796875000e-05,
	4.3392181396484375e-05}, /* L1738 */
{1.9966820478439331e+00, 8.6769461631774902e-05,
	1.1920928955078125e-07, 4.7683715820312500e-06,
	-1.8954277038574219e-05}, /* L1739 */
{2.2731249332427979e+00, 9.8913908004760742e-05,
	1.1920928955078125e-07, 3.5762786865234375e-07,
	-3.2544136047363281e-05}, /* L1740 */
{2.2289917469024658e+00, 9.7140669822692871e-05,
	1.1920928955078125e-07, 1.3172626495361328e-04,
	-9.3936920166015625e-05}, /* L1741 */
{1.7321634292602539e+00, 7.5578689575195312e-05,
	1.1920928955078125e-07, -1.1980533599853516e-05,
	6.4373016357421875e-06}, /* L1742 */
{2.0246231555938721e+00, 8.8483095169067383e-05,
	1.1920928955078125e-07, -4.3988227844238281e-05,
	1.7797946929931641e-04}, /* L1743 */
{1.6644182205200195e+00, 7.2836875915527344e-05,
	1.1920928955078125e-07, 7.3909759521484375e-06,
	-1.5354156494140625e-04}, /* L1744 */
{2.4302031993865967e+00, 1.0648369789123535e-04,
	1.1920928955078125e-07, -3.1471252441406250e-05,
	-3.3199787139892578e-05}, /* L1745 */
{1.4454622268676758e+00, 6.3419342041015625e-05,
	1.1920928955078125e-07, 8.2254409790039062e-06,
	1.2040138244628906e-05}, /* L1746 */
{2.6828982830047607e+00, 1.1789239943027496e-04,
	1.1920928955078125e-07, -8.8095664978027344e-05,
	-4.1723251342773438e-06}, /* L1747 */
{2.0662176609039307e+00, 9.0897083282470703e-05,
	1.1920928955078125e-07, -5.0067901611328125e-06,
	2.8967857360839844e-05}, /* L1748 */
{2.2055304050445557e+00, 9.7155570983886719e-05,
	1.1920928955078125e-07, 3.3378601074218750e-06,
	1.0013580322265625e-05}, /* L1749 */
{1.7370011806488037e+00, 7.6621770858764648e-05,
	1.1920928955078125e-07, -9.0599060058593750e-06,
	1.3113021850585938e-06}, /* L1750 */
{2.3647711277008057e+00, 1.0445713996887207e-04,
	1.1920928955078125e-07, 5.1259994506835938e-06,
	-2.0325183868408203e-05}, /* L1751 */
{1.8752216100692749e+00, 8.2969665527343750e-05,
	1.1920928955078125e-07, -2.1624565124511719e-04,
	-2.8014183044433594e-05}, /* L1752 */
{2.6947195529937744e+00, 1.1956691741943359e-04,
	1.1920928955078125e-07, -1.6885995864868164e-04,
	6.8485736846923828e-04}, /* L1753 */
{1.5535091161727905e+00, 6.8902969360351562e-05,
	1.1920928955078125e-07, 1.0728836059570312e-06,
	6.6161155700683594e-05}, /* L1754 */
{2.1915209293365479e+00, 9.7334384918212891e-05,
	1.1920928955078125e-07, -4.5061111450195312e-05,
	-5.9604644775390625e-06}, /* L1755 */
{1.7833107709884644e+00, 7.9303979873657227e-05,
	1.1920928955078125e-07, -1.1324882507324219e-06,
	2.4080276489257812e-05}, /* L1756 */
{2.2707669734954834e+00, 1.0111927986145020e-04,
	1.1920928955078125e-07, 3.3378601074218750e-05,
	2.6941299438476562e-05}, /* L1757 */
{1.7618168592453003e+00, 7.8558921813964844e-05,
	1.1920928955078125e-07, -1.5437602996826172e-05,
	4.1484832763671875e-05}, /* L1758 */
{2.4681625366210938e+00, 1.1019408702850342e-04,
	1.1920928955078125e-07, 3.4093856811523438e-05,
	2.2172927856445312e-05}, /* L1759 */
{2.0890531539916992e+00, 9.3489885330200195e-05,
	1.1920928955078125e-07, 5.6982040405273438e-05,
	2.6929378509521484e-04}, /* L1760 */
{2.3426351547241211e+00, 1.0506063699722290e-04,
	1.1920928955078125e-07, 1.4781951904296875e-04,
	-7.5107812881469727e-04}, /* L1761 */
{2.2498238086700439e+00, 1.0085105895996094e-04,
	1.1920928955078125e-07, 9.4175338745117188e-06,
	-2.9623508453369141e-05}, /* L1762 */
{2.3314814567565918e+00, 1.0466575622558594e-04,
	1.1920928955078125e-07, -6.3478946685791016e-05,
	1.8239021301269531e-05}, /* L1763 */
{1.9313265085220337e+00, 8.6814165115356445e-05,
	1.1920928955078125e-07, -7.4088573455810547e-05,
	-1.2397766113281250e-05}, /* L1764 */
{2.4335935115814209e+00, 1.0952353477478027e-04,
	1.1920928955078125e-07, -3.3378601074218750e-06,
	2.9683113098144531e-05}, /* L1765 */
{1.9520809650421143e+00, 8.8006258010864258e-05,
	1.1920928955078125e-07, 2.1100044250488281e-05,
	-2.3126602172851562e-04}, /* L1766 */
{2.6704120635986328e+00, 1.2052059173583984e-04,
	1.1920928955078125e-07, 1.0371208190917969e-05,
	-2.0444393157958984e-05}, /* L1767 */
{2.2689750194549561e+00, 1.0254979133605957e-04,
	1.1920928955078125e-07, 6.0796737670898438e-05,
	6.0081481933593750e-05}, /* L1768 */
{2.1498427391052246e+00, 9.7543001174926758e-05,
	1.1920928955078125e-07, 1.1360645294189453e-04,
	-7.7557563781738281e-04}, /* L1769 */
{1.6386512517929077e+00, 7.4237585067749023e-05,
	1.1920928955078125e-07, 1.3709068298339844e-05,
	-1.9431114196777344e-05}, /* L1770 */
{2.2027707099914551e+00, 1.0001659393310547e-04,
	1.1920928955078125e-07, 7.8558921813964844e-05,
	-1.3780593872070312e-04}, /* L1771 */
{1.6518601179122925e+00, 7.5042247772216797e-05,
	1.1920928955078125e-07, -9.8109245300292969e-05,
	-4.5895576477050781e-06}, /* L1772 */
{2.7681057453155518e+00, 1.2591481208801270e-04,
	1.1920928955078125e-07, 2.3126602172851562e-05,
	-1.4662742614746094e-05}, /* L1773 */
{1.5092557668685913e+00, 6.8739056587219238e-05,
	1.1920928955078125e-07, -2.4676322937011719e-05,
	9.1314315795898438e-05}, /* L1774 */
{2.9111638069152832e+00, 1.3326480984687805e-04,
	1.1920928955078125e-07, 1.3482570648193359e-04,
	-4.5239925384521484e-04}, /* L1775 */
{1.8229529857635498e+00, 8.3237886428833008e-05,
	1.1920928955078125e-07, 3.3617019653320312e-05,
	-1.5854835510253906e-05}, /* L1776 */
{2.8705987930297852e+00, 1.3126060366630554e-04,
	1.1920928955078125e-07, -5.2928924560546875e-05,
	-4.9710273742675781e-05}, /* L1777 */
{1.7384099960327148e+00, 7.9587101936340332e-05,
	1.1920928955078125e-07, 3.2186508178710938e-06,
	-3.5226345062255859e-05}, /* L1778 */
{3.0848710536956787e+00, 1.4144182205200195e-04,
	1.1920928955078125e-07, -1.3554096221923828e-04,
	2.1183490753173828e-04}, /* L1779 */
{1.8776628971099854e+00, 8.6203217506408691e-05,
	1.1920928955078125e-07, 5.5551528930664062e-05,
	1.5830993652343750e-04}, /* L1780 */
{2.5466752052307129e+00, 1.1704862117767334e-04,
	1.1920928955078125e-07, 1.2755393981933594e-05,
	-6.7055225372314453e-05}, /* L1781 */
{1.6701420545578003e+00, 7.6856464147567749e-05,
	1.1920928955078125e-07, 1.9192695617675781e-05,
	9.5367431640625000e-06}, /* L1782 */
{1.9069079160690308e+00, 8.7916851043701172e-05,
	1.1920928955078125e-07, 1.9538402557373047e-04,
	-2.2816658020019531e-04}, /* L1783 */
{1.6976265907287598e+00, 7.8350305557250977e-05,
	1.1920928955078125e-07, 2.2172927856445312e-05,
	-6.0200691223144531e-06}, /* L1784 */
{2.4320957660675049e+00, 1.1235475540161133e-04,
	1.1920928955078125e-07, 3.4332275390625000e-05,
	1.2159347534179688e-05}, /* L1785 */
{1.7184666395187378e+00, 7.9512596130371094e-05,
	1.1920928955078125e-07, 1.5294551849365234e-04,
	1.7213821411132812e-04}, /* L1786 */
{2.2211933135986328e+00, 1.0287761688232422e-04,
	1.1920928955078125e-07, -6.5565109252929688e-07,
	-3.8146972656250000e-06}, /* L1787 */
{1.9474271535873413e+00, 9.0315937995910645e-05,
	1.1920928955078125e-07, -3.8444995880126953e-05,
	1.5377998352050781e-05}, /* L1788 */
{3.1050331592559814e+00, 1.4419946819543839e-04,
	1.1920928955078125e-07, 5.5551528930664062e-05,
	-4.5359134674072266e-05}, /* L1789 */
{1.9431529045104980e+00, 9.0345740318298340e-05,
	1.1920928955078125e-07, 1.4901161193847656e-05,
	1.0132789611816406e-05}, /* L1790 */
{2.2056438922882080e+00, 1.0269880294799805e-04,
	1.1920928955078125e-07, 6.1392784118652344e-05,
	-7.2658061981201172e-05}, /* L1791 */
{2.1218938827514648e+00, 9.8913908004760742e-05,
	1.1920928955078125e-07, -1.6689300537109375e-05,
	4.7922134399414062e-05}, /* L1792 */
{2.9662759304046631e+00, 1.3846158981323242e-04,
	1.1920928955078125e-07, 8.4280967712402344e-05,
	-1.3887882232666016e-05}, /* L1793 */
{1.7498950958251953e+00, 8.1777572631835938e-05,
	1.1920928955078125e-07, -1.4185905456542969e-05,
	-1.8239021301269531e-05}, /* L1794 */
{2.3507330417633057e+00, 1.1000037193298340e-04,
	1.1920928955078125e-07, -1.4960765838623047e-05,
	3.3140182495117188e-05}, /* L1795 */
{1.7486015558242798e+00, 8.1926584243774414e-05,
	1.1920928955078125e-07, 9.1791152954101562e-06,
	-4.5299530029296875e-06}, /* L1796 */
{2.3049988746643066e+00, 1.0815262794494629e-04,
	1.1920928955078125e-07, -2.1219253540039062e-05,
	7.3909759521484375e-06}, /* L1797 */
{1.8053104877471924e+00, 8.4817409515380859e-05,
	1.1920928955078125e-07, 8.4877014160156250e-05,
	-1.0639429092407227e-04}, /* L1798 */
{2.3539047241210938e+00, 1.1071562767028809e-04,
	1.1920928955078125e-07, -3.9219856262207031e-05,
	3.0875205993652344e-05}, /* L1799 */
{1.6418801546096802e+00, 7.7322125434875488e-05,
	1.1920928955078125e-07, 6.4134597778320312e-05,
	-1.6093254089355469e-05}, /* L1800 */
{2.2988612651824951e+00, 1.0839104652404785e-04,
	1.1920928955078125e-07, 1.3232231140136719e-05,
	3.5881996154785156e-05}, /* L1801 */
{2.3134348392486572e+00, 1.0941177606582642e-04,
	1.1920928955078125e-07, -4.9430131912231445e-04,
	2.1958351135253906e-04}, /* L1802 */
{2.1120645999908447e+00, 9.9837779998779297e-05,
	1.1920928955078125e-07, 1.3470649719238281e-05,
	-9.8943710327148438e-06}, /* L1803 */
{2.1017658710479736e+00, 9.9480777862481773e-05,
	1.1920928955078125e-07, 1.5616416931152344e-05,
	-1.9729137420654297e-05}, /* L1804 */
{2.8653111457824707e+00, 1.3579800724983215e-04,
	1.1920928955078125e-07, 9.3102455139160156e-05,
	-7.1227550506591797e-05}, /* L1805 */
{1.8221752643585205e+00, 8.6486339569091797e-05,
	1.1920928955078125e-07, -3.4570693969726562e-05,
	5.8770179748535156e-05}, /* L1806 */
{2.8210661411285400e+00, 1.3402104377746582e-04,
	1.1920928955078125e-07, -6.4969062805175781e-06,
	1.4424324035644531e-05}, /* L1807 */
{2.3456311225891113e+00, 1.1157989501953125e-04,
	1.1920928955078125e-07, 1.0728836059570312e-06,
	-2.2053718566894531e-06}, /* L1808 */
{2.7881257534027100e+00, 1.3284385204315186e-04,
	1.1920928955078125e-07, -2.9605627059936523e-04,
	-5.5432319641113281e-05}, /* L1809 */
{1.8128116130828857e+00, 8.6463987827301025e-05,
	1.1920928955078125e-07, 1.3208389282226562e-04,
	-6.4373016357421875e-05}, /* L1810 */
{2.1947944164276123e+00, 1.0484457015991211e-04,
	1.1920928955078125e-07, -1.1676549911499023e-04,
	9.1195106506347656e-05}, /* L1811 */
{2.0533421039581299e+00, 9.8168849945068359e-05,
	1.1920928955078125e-07, 8.7022781372070312e-06,
	-5.0902366638183594e-05}, /* L1812 */
{1.9979074001312256e+00, 9.5635652542114258e-05,
	1.1920928955078125e-07, -1.0967254638671875e-05,
	-5.1677227020263672e-05}, /* L1813 */
{2.0360455513000488e+00, 9.7587704658508301e-05,
	1.1920928955078125e-07, 3.5285949707031250e-05,
	2.7179718017578125e-05}, /* L1814 */
{1.9578819274902344e+00, 9.3963928520679474e-05,
	1.1920928955078125e-07, 2.1934509277343750e-05,
	6.6757202148437500e-06}, /* L1815 */
{2.2573385238647461e+00, 1.0845065116882324e-04,
	1.1920928955078125e-07, 2.4795532226562500e-05,
	2.0265579223632812e-06}, /* L1816 */
{2.5022745132446289e+00, 1.2037158012390137e-04,
	1.1920928955078125e-07, 3.0279159545898438e-05,
	-1.5020370483398438e-05}, /* L1817 */
{1.6966168880462646e+00, 8.1717967987060547e-05,
	1.1920928955078125e-07, -2.5331974029541016e-05,
	4.3392181396484375e-05}, /* L1818 */
{2.3328707218170166e+00, 1.1250376701354980e-04,
	1.1920928955078125e-07, -5.4657459259033203e-05,
	-4.7385692596435547e-05}, /* L1819 */
{3.4232356548309326e+00, 1.6528367996215820e-04,
	1.1920928955078125e-07, -1.7762184143066406e-05,
	2.3722648620605469e-05}, /* L1820 */
{2.4594986438751221e+00, 1.1903047561645508e-04,
	1.1920928955078125e-07, -1.2093782424926758e-04,
	-1.2809038162231445e-04}, /* L1821 */
{2.0857689380645752e+00, 1.0097026824951172e-04,
	1.1920928955078125e-07, -4.5776367187500000e-05,
	1.1920928955078125e-05}, /* L1822 */
{2.0649635791778564e+00, 1.0007619857788086e-04,
	1.1920928955078125e-07, -1.0907649993896484e-05,
	-1.5556812286376953e-05}, /* L1823 */
{2.1299760341644287e+00, 1.0335445404052734e-04,
	1.1920928955078125e-07, 1.0204315185546875e-04,
	-1.8000602722167969e-05}, /* L1824 */
{2.5681340694427490e+00, 1.2478232383728027e-04,
	1.1920928955078125e-07, -3.0994415283203125e-06,
	1.1384487152099609e-04}, /* L1825 */
{1.8315933942794800e+00, 8.9108943939208984e-05,
	1.1920928955078125e-07, 1.4650821685791016e-04,
	-9.8943710327148438e-05}, /* L1826 */
{2.3002212047576904e+00, 1.1202692985534668e-04,
	1.1920928955078125e-07, 1.5497207641601562e-05,
	2.1934509277343750e-05}, /* L1827 */
{2.1280312538146973e+00, 1.0377913713455200e-04,
	1.1920928955078125e-07, 9.8943710327148438e-05,
	1.8239021301269531e-05}, /* L1828 */
{2.4616782665252686e+00, 1.2018531560897827e-04,
	1.1920928955078125e-07, -3.8444995880126953e-05,
	1.0848045349121094e-05}, /* L1829 */
{2.0719974040985107e+00, 1.0128319263458252e-04,
	1.1920928955078125e-07, 7.9035758972167969e-05,
	8.3446502685546875e-07}, /* L1830 */
{2.0984549522399902e+00, 1.0269880294799805e-04,
	1.1920928955078125e-07, -8.1062316894531250e-06,
	-3.5762786865234375e-06}, /* L1831 */
{2.0673472881317139e+00, 1.0129809379577637e-04,
	1.1920928955078125e-07, 4.2915344238281250e-06,
	-4.0709972381591797e-05}, /* L1832 */
{2.0363466739654541e+00, 9.9942088127136230e-05,
	1.1920928955078125e-07, 1.0824203491210938e-04,
	1.8596649169921875e-04}, /* L1833 */
{2.1924707889556885e+00, 1.0769069194793701e-04,
	1.1920928955078125e-07, -1.4305114746093750e-05,
	2.8133392333984375e-05}, /* L1834 */
{2.5006375312805176e+00, 1.2305378913879395e-04,
	1.1920928955078125e-07, 4.5537948608398438e-05,
	3.9339065551757812e-05}, /* L1835 */
{1.8640559911727905e+00, 9.1791152954101562e-05,
	1.1920928955078125e-07, -1.6212463378906250e-05,
	-9.2744827270507812e-05}, /* L1836 */
{2.5396268367767334e+00, 1.2522935867309570e-04,
	1.1920928955078125e-07, 4.4941902160644531e-05,
	1.0871887207031250e-04}, /* L1837 */
{1.9220930337905884e+00, 9.5002353191375732e-05,
	1.1920928955078125e-07, -2.2161006927490234e-04,
	-1.8966197967529297e-04}, /* L1838 */
{2.1667468547821045e+00, 1.0711699724197388e-04,
	1.1920928955078125e-07, -2.0056962966918945e-04,
	2.6929378509521484e-04}, /* L1839 */
{2.7691848278045654e+00, 1.3703107833862305e-04,
	1.1920928955078125e-07, -1.7881393432617188e-06,
	-6.0796737670898438e-06}, /* L1840 */
{2.3119692802429199e+00, 1.1458992958068848e-04,
	1.1920928955078125e-07, -2.3329257965087891e-04,
	-1.9490718841552734e-04}, /* L1841 */
{1.4835515022277832e+00, 7.3593109846115112e-05,
	1.1920928955078125e-07, 6.4849853515625000e-05,
	1.3387203216552734e-04}, /* L1842 */
{2.1553435325622559e+00, 1.0703504085540771e-04,
	1.1920928955078125e-07, 8.3804130554199219e-05,
	-2.7060508728027344e-05}, /* L1843 */
{2.2853090763092041e+00, 1.1369585990905762e-04,
	1.1920928955078125e-07, -1.7964839935302734e-04,
	4.3475627899169922e-04}, /* L1844 */
{2.8922224044799805e+00, 1.4400482177734375e-04,
	1.1920928955078125e-07, -2.4354457855224609e-04,
	1.1134147644042969e-04}, /* L1845 */
{1.6120048761367798e+00, 8.0332159996032715e-05,
	1.1920928955078125e-07, 9.5367431640625000e-07,
	-5.7220458984375000e-06}, /* L1846 */
{1.8666315078735352e+00, 9.3132257461547852e-05,
	1.1920928955078125e-07, 2.8371810913085938e-05,
	-8.2254409790039062e-06}, /* L1847 */
{2.4853396415710449e+00, 1.2415647506713867e-04,
	1.1920928955078125e-07, 2.3007392883300781e-05,
	-2.0742416381835938e-05}, /* L1848 */
{2.4352109432220459e+00, 1.2187659740447998e-04,
	1.1920928955078125e-07, -7.4505805969238281e-05,
	1.6856193542480469e-04}, /* L1849 */
{1.7282103300094604e+00, 8.6545944213867188e-05,
	1.1920928955078125e-07, -1.9967555999755859e-05,
	2.8014183044433594e-05}, /* L1850 */
{2.6603484153747559e+00, 1.3339519500732422e-04,
	1.1920928955078125e-07, -1.8048286437988281e-04,
	1.0716915130615234e-04}, /* L1851 */
{1.6997557878494263e+00, 8.5324048995971680e-05,
	1.1920928955078125e-07, 4.4584274291992188e-05,
	1.6570091247558594e-05}, /* L1852 */
{2.8429338932037354e+00, 1.4299154281616211e-04,
	1.1920928955078125e-07, 4.3642520904541016e-04,
	-5.4985284805297852e-04}, /* L1853 */
{1.6515436172485352e+00, 8.3103775978088379e-05,
	1.1920928955078125e-07, 8.7261199951171875e-05,
	-8.0823898315429688e-05}, /* L1854 */
{2.4816195964813232e+00, 1.2502074241638184e-04,
	1.1920928955078125e-07, 1.4424324035644531e-05,
	-1.3703107833862305e-04}, /* L1855 */
{1.7384079694747925e+00, 8.7663531303405762e-05,
	1.1920928955078125e-07, -1.7166137695312500e-05,
	-2.5212764739990234e-05}, /* L1856 */
{2.6873564720153809e+00, 1.3568997383117676e-04,
	1.1920928955078125e-07, 1.3232231140136719e-05,
	-8.1658363342285156e-06}, /* L1857 */
{1.4985584020614624e+00, 7.5755640864372253e-05,
	1.1920928955078125e-07, 6.7830085754394531e-05,
	2.9563903808593750e-05}, /* L1858 */
{2.7007632255554199e+00, 1.3668090105056763e-04,
	1.1920928955078125e-07, -2.7596950531005859e-05,
	-2.2888183593750000e-05}, /* L1859 */
{1.8015152215957642e+00, 9.1284513473510742e-05,
	1.1920928955078125e-07, 5.6028366088867188e-06,
	3.4570693969726562e-06}, /* L1860 */
{2.7948830127716064e+00, 1.4185905456542969e-04,
	1.1920928955078125e-07, 3.4213066101074219e-04,
	-1.6695261001586914e-04}, /* L1861 */
{1.6055277585983276e+00, 8.1539154052734375e-05,
	1.1920928955078125e-07, 1.5974044799804688e-05,
	7.9870223999023438e-06}, /* L1862 */
{2.0925402641296387e+00, 1.0641291737556458e-04,
	1.1920928955078125e-07, -1.0961294174194336e-04,
	5.2690505981445312e-05}, /* L1863 */
{1.7606729269027710e+00, 8.9645385742187500e-05,
	1.1920928955078125e-07, -1.7881393432617188e-06,
	1.4185905456542969e-05}, /* L1864 */
{2.4618394374847412e+00, 1.2559443712234497e-04,
	1.1920928955078125e-07, -8.3386898040771484e-05,
	-5.7774782180786133e-04}, /* L1865 */
{1.4373915195465088e+00, 7.3343515396118164e-05,
	1.1920928955078125e-07, 8.1062316894531250e-06,
	-1.3828277587890625e-05}, /* L1866 */
{2.2235951423645020e+00, 1.1359155178070068e-04,
	1.1920928955078125e-07, 6.6757202148437500e-06,
	-1.7762184143066406e-05}, /* L1867 */
{1.8781640529632568e+00, 9.6112489700317383e-05,
	1.1920928955078125e-07, -1.3083219528198242e-04,
	-3.3730268478393555e-04}, /* L1868 */
{2.2864773273468018e+00, 1.1712312698364258e-04,
	1.1920928955078125e-07, 5.9366226196289062e-05,
	-1.1742115020751953e-04}, /* L1869 */
{2.1287276744842529e+00, 1.0952353477478027e-04,
	1.1920928955078125e-07, -8.8697671890258789e-04,
	-1.9913911819458008e-04}, /* L1870 */
{2.4328908920288086e+00, 1.2487173080444336e-04,
	1.1920928955078125e-07, -2.9146671295166016e-05,
	-1.3232231140136719e-05}, /* L1871 */
{2.4926898479461670e+00, 1.2809038162231445e-04,
	1.1920928955078125e-07, -3.0219554901123047e-05,
	-5.2571296691894531e-05}, /* L1872 */
{2.2158510684967041e+00, 1.1399388313293457e-04,
	1.1920928955078125e-07, -2.5570392608642578e-05,
	-7.7486038208007812e-06}, /* L1873 */
{1.9853980541229248e+00, 1.0225176811218262e-04,
	1.1920928955078125e-07, -3.9935111999511719e-06,
	1.8239021301269531e-05}, /* L1874 */
{2.8388967514038086e+00, 1.4643371105194092e-04,
	1.1920928955078125e-07, 2.5629997253417969e-05,
	7.2717666625976562e-06}, /* L1875 */
{2.8566086292266846e+00, 1.4749169349670410e-04,
	1.1920928955078125e-07, 7.2360038757324219e-05,
	-7.2836875915527344e-05}, /* L1876 */
{2.5184569358825684e+00, 1.3017654418945312e-04,
	1.1920928955078125e-07, 6.4015388488769531e-05,
	7.3075294494628906e-05}, /* L1877 */
{1.9263958930969238e+00, 9.9688768386840820e-05,
	1.1920928955078125e-07, -4.3511390686035156e-05,
	4.7206878662109375e-05}, /* L1878 */
{2.7452421188354492e+00, 1.4221668243408203e-04,
	1.1920928955078125e-07, -1.4662742614746094e-05,
	-1.7523765563964844e-05}, /* L1879 */
{2.5641698837280273e+00, 1.3311207294464111e-04,
	1.1920928955078125e-07, -1.4489889144897461e-04,
	1.7321109771728516e-04}, /* L1880 */
{3.2108201980590820e+00, 1.6671419143676758e-04,
	1.1920928955078125e-07, 6.9499015808105469e-05,
	5.6385993957519531e-05}, /* L1881 */
{1.6079204082489014e+00, 8.3580613136291504e-05,
	1.1920928955078125e-07, 2.1338462829589844e-05,
	-6.5565109252929688e-07}, /* L1882 */
{2.5309545993804932e+00, 1.3172626495361328e-04,
	1.1920928955078125e-07, 5.1140785217285156e-05,
	2.4795532226562500e-05}, /* L1883 */
{2.4556424617767334e+00, 1.2794137001037598e-04,
	1.1920928955078125e-07, 3.9935111999511719e-05,
	4.5180320739746094e-05}, /* L1884 */
{3.3386497497558594e+00, 1.7437338829040527e-04,
	1.1920928955078125e-07, 2.8991699218750000e-04,
	2.4509429931640625e-04}, /* L1885 */
{1.6634821891784668e+00, 8.6873769760131836e-05,
	1.1920928955078125e-07, 2.9802322387695312e-05,
	1.2159347534179688e-04}, /* L1886 */
{2.3434493541717529e+00, 1.2252479791641235e-04,
	1.1920928955078125e-07, -6.9260597229003906e-05,
	1.6069412231445312e-04}, /* L1887 */
{2.0525343418121338e+00, 1.0743364691734314e-04,
	1.1920928955078125e-07, -4.4703483581542969e-05,
	-8.9704990386962891e-05}, /* L1888 */
{2.4524402618408203e+00, 1.2850761413574219e-04,
	1.1920928955078125e-07, 1.2397766113281250e-05,
	-1.2993812561035156e-05}, /* L1889 */
{1.4443668127059937e+00, 7.5876712799072266e-05,
	1.1920928955078125e-07, -5.4794549942016602e-04,
	-1.8507242202758789e-04}, /* L1890 */
{2.2905726432800293e+00, 1.2062489986419678e-04,
	1.1920928955078125e-07, 3.5476684570312500e-04,
	6.0319900512695312e-05}, /* L1891 */
{1.7725929021835327e+00, 9.3251466751098633e-05,
	1.1920928955078125e-07, 2.3245811462402344e-05,
	1.3601779937744141e-04}, /* L1892 */
{2.2941467761993408e+00, 1.2078881263732910e-04,
	1.1920928955078125e-07, -3.1471252441406250e-05,
	1.6784667968750000e-04}, /* L1893 */
{1.7702763080596924e+00, 9.3281269073486328e-05,
	1.1920928955078125e-07, -3.5762786865234375e-07,
	7.1525573730468750e-06}, /* L1894 */
{3.2860200405120850e+00, 1.7338991165161133e-04,
	1.1920928955078125e-07, 7.8082084655761719e-05,
	1.5020370483398438e-05}, /* L1895 */
{2.0420827865600586e+00, 1.0788440704345703e-04,
	1.1920928955078125e-07, 2.7298927307128906e-05,
	4.7802925109863281e-05}, /* L1896 */
{3.2731742858886719e+00, 1.7306208610534668e-04,
	1.1920928955078125e-07, 1.1444091796875000e-05,
	3.5762786865234375e-06}, /* L1897 */
{1.7687418460845947e+00, 9.3623995780944824e-05,
	1.1920928955078125e-07, -9.0599060058593750e-06,
	-2.0384788513183594e-05}, /* L1898 */
{3.4269099235534668e+00, 1.8161535263061523e-04,
	1.1920928955078125e-07, -3.2961368560791016e-05,
	3.2305717468261719e-05}, /* L1899 */
{1.8056877851486206e+00, 9.5814466476440430e-05,
	1.1920928955078125e-07, -5.0246715545654297e-05,
	5.2571296691894531e-05}, /* L1900 */
{3.3191819190979004e+00, 1.7637014389038086e-04,
	1.1920928955078125e-07, -5.1081180572509766e-05,
	1.8763542175292969e-04}, /* L1901 */
{1.8332746028900146e+00, 9.7483396530151367e-05,
	1.1920928955078125e-07, 5.1259994506835938e-06,
	4.2915344238281250e-06}, /* L1902 */
{2.8806416988372803e+00, 1.5336275100708008e-04,
	1.1920928955078125e-07, -1.3530254364013672e-05,
	-5.7041645050048828e-05}, /* L1903 */
{1.8356271982192993e+00, 9.7870826721191406e-05,
	1.1920928955078125e-07, -6.8008899688720703e-05,
	3.0159950256347656e-04}, /* L1904 */
{3.9514160156250000e+00, 2.1086633205413818e-04,
	1.1920928955078125e-07, 2.4271011352539062e-04,
	-1.0418891906738281e-04}, /* L1905 */
{1.8275932073593140e+00, 9.7610056400299072e-05,
	1.1920928955078125e-07, 2.5629997253417969e-05,
	1.5854835510253906e-05}, /* L1906 */
{2.8603291511535645e+00, 1.5297532081604004e-04,
	1.1920928955078125e-07, 4.1723251342773438e-05,
	1.3470649719238281e-04}, /* L1907 */
{1.7409679889678955e+00, 9.3191862106323242e-05,
	1.1920928955078125e-07, 1.0013580322265625e-05,
	-2.5689601898193359e-05}, /* L1908 */
{2.8995096683502197e+00, 1.5538558363914490e-04,
	1.1920928955078125e-07, -4.3570995330810547e-05,
	-6.4253807067871094e-05}, /* L1909 */
{2.8324661254882812e+00, 1.5196204185485840e-04,
	1.1920928955078125e-07, 2.2292137145996094e-05,
	-3.4868717193603516e-05}, /* L1910 */
{2.8509500026702881e+00, 1.5318393707275391e-04,
	1.1920928955078125e-07, 1.5032291412353516e-04,
	1.3399124145507812e-04}, /* L1911 */
{2.2605297565460205e+00, 1.2156367301940918e-04,
	1.1920928955078125e-07, 5.0067901611328125e-06,
	-4.2378902435302734e-05}, /* L1912 */
{2.9011981487274170e+00, 1.5616416931152344e-04,
	1.1920928955078125e-07, -2.0563602447509766e-05,
	1.3589859008789062e-05}, /* L1913 */
{2.5663242340087891e+00, 1.3829022645950317e-04,
	1.1920928955078125e-07, 1.5139579772949219e-05,
	1.3113021850585938e-05}, /* L1914 */
{2.0113093852996826e+00, 1.0858476161956787e-04,
	1.1920928955078125e-07, -4.3809413909912109e-04,
	-5.3048133850097656e-05}, /* L1915 */
{2.0161223411560059e+00, 1.0888278484344482e-04,
	1.1920928955078125e-07, -8.8810920715332031e-06,
	-1.1563301086425781e-05}, /* L1916 */
{2.6440193653106689e+00, 1.4299154281616211e-04,
	1.1920928955078125e-07, 7.0095062255859375e-05,
	2.8491020202636719e-04}, /* L1917 */
{1.9061421155929565e+00, 1.0319054126739502e-04,
	1.1920928955078125e-07, 4.1961669921875000e-05,
	-4.8875808715820312e-05}, /* L1918 */
{2.4617960453033447e+00, 1.3339519500732422e-04,
	1.1920928955078125e-07, -5.1856040954589844e-06,
	-3.5047531127929688e-05}, /* L1919 */
{1.9810401201248169e+00, 1.0752677917480469e-04,
	1.1920928955078125e-07, 1.4865398406982422e-04,
	1.0263919830322266e-04}, /* L1920 */
{3.1827111244201660e+00, 1.7300248146057129e-04,
	1.1920928955078125e-07, 3.3664703369140625e-04,
	2.4199485778808594e-04}, /* L1921 */
{2.2300319671630859e+00, 1.2132152915000916e-04,
	1.1920928955078125e-07, 3.6871433258056641e-04,
	3.3855438232421875e-05}, /* L1922 */
{2.5846183300018311e+00, 1.4070421457290649e-04,
	1.1920928955078125e-07, -4.1723251342773438e-06,
	2.0492076873779297e-04}, /* L1923 */
{1.9145039319992065e+00, 1.0430812835693359e-04,
	1.1920928955078125e-07, -7.1525573730468750e-06,
	-1.8239021301269531e-05}, /* L1924 */
{2.9107191562652588e+00, 1.5877932310104370e-04,
	1.1920928955078125e-07, -8.4042549133300781e-05,
	-1.3709068298339844e-05}, /* L1925 */
{1.8062936067581177e+00, 9.9033117294311523e-05,
	1.1920928955078125e-07, -1.8262863159179688e-04,
	1.1172294616699219e-03}, /* L1926 */
{2.5536561012268066e+00, 1.3959407806396484e-04,
	1.1920928955078125e-07, -3.8385391235351562e-05,
	4.6849250793457031e-05}, /* L1927 */
{1.8466471433639526e+00, 1.0144710540771484e-04,
	1.1920928955078125e-07, -8.3380937576293945e-04,
	-2.2706985473632812e-03}, /* L1928 */
{3.5425333976745605e+00, 1.9410252571105957e-04,
	1.1920928955078125e-07, 2.7298927307128906e-05,
	-7.5578689575195312e-05}, /* L1929 */
{2.3763818740844727e+00, 1.3034790754318237e-04,
	1.1920928955078125e-07, 5.1259994506835938e-05,
	1.0454654693603516e-04}, /* L1930 */
{2.4987885951995850e+00, 1.3723969459533691e-04,
	1.1920928955078125e-07, 7.9989433288574219e-05,
	-1.3691186904907227e-04}, /* L1931 */
{2.6794495582580566e+00, 1.4726817607879639e-04,
	1.1920928955078125e-07, 4.9114227294921875e-05,
	4.7087669372558594e-05}, /* L1932 */
{3.0614643096923828e+00, 1.6847252845764160e-04,
	1.1920928955078125e-07, 6.6876411437988281e-05,
	1.3005733489990234e-04}, /* L1933 */
{1.6402275562286377e+00, 9.0479850769042969e-05,
	1.1920928955078125e-07, -6.8700313568115234e-04,
	-7.1400403976440430e-04}, /* L1934 */
{2.5690569877624512e+00, 1.4166533946990967e-04,
	1.1920928955078125e-07, -4.3630599975585938e-05,
	-2.5928020477294922e-05}, /* L1935 */
{2.4554016590118408e+00, 1.3554748147726059e-04,
	1.1920928955078125e-07, -4.5895576477050781e-05,
	-7.5817108154296875e-05}, /* L1936 */
{3.0257985591888428e+00, 1.6725063323974609e-04,
	1.1920928955078125e-07, -8.1956386566162109e-05,
	-1.1086463928222656e-05}, /* L1937 */
{1.9632952213287354e+00, 1.0865926742553711e-04,
	1.1920928955078125e-07, -1.8268823623657227e-04,
	1.3363361358642578e-04}, /* L1938 */
{3.0890502929687500e+00, 1.7106533050537109e-04,
	1.1920928955078125e-07, -1.0490417480468750e-05,
	-5.2452087402343750e-06}, /* L1939 */
{2.1422698497772217e+00, 1.1889636516571045e-04,
	1.1920928955078125e-07, 3.7908554077148438e-05,
	-2.7596950531005859e-05}, /* L1940 */
{2.5277142524719238e+00, 1.4027953147888184e-04,
	1.1920928955078125e-07, 3.3497810363769531e-05,
	1.5497207641601562e-05}, /* L1941 */
{2.0290853977203369e+00, 1.1365115642547607e-04,
	1.1920928955078125e-07, 8.6903572082519531e-05,
	-1.2836456298828125e-03}, /* L1942 */
{2.8987660408020020e+00, 1.6123056411743164e-04,
	1.1920928955078125e-07, -2.4557113647460938e-05,
	-2.8192996978759766e-05}, /* L1943 */
{2.0777528285980225e+00, 1.1569261550903320e-04,
	1.1920928955078125e-07, -6.7949295043945312e-05,
	8.2969665527343750e-05}, /* L1944 */
{3.0584731101989746e+00, 1.7046928405761719e-04,
	1.1920928955078125e-07, -1.7464160919189453e-05,
	2.1815299987792969e-05}, /* L1945 */
{2.4689078330993652e+00, 1.3846158981323242e-04,
	1.1920928955078125e-07, -5.6564807891845703e-05,
	1.3842582702636719e-03}, /* L1946 */
{2.8085601329803467e+00, 1.5702843666076660e-04,
	1.1920928955078125e-07, 7.7486038208007812e-05,
	2.4795532226562500e-05}, /* L1947 */
{2.0344049930572510e+00, 1.1381506919860840e-04,
	1.1920928955078125e-07, 1.6880035400390625e-04,
	-2.5749206542968750e-05}, /* L1948 */
{3.2024304866790771e+00, 1.7935037612915039e-04,
	1.1920928955078125e-07, 1.2314319610595703e-04,
	4.3618679046630859e-04}, /* L1949 */
{2.3651342391967773e+00, 1.3273954391479492e-04,
	1.1920928955078125e-07, -3.7831068038940430e-04,
	-3.2556056976318359e-04}, /* L1950 */
{2.8672444820404053e+00, 1.6085803508758545e-04,
	1.1920928955078125e-07, -1.7046928405761719e-04,
	-2.2709369659423828e-05}, /* L1951 */
{2.1778659820556641e+00, 1.2230873107910156e-04,
	1.1920928955078125e-07, -1.1670589447021484e-04,
	-4.8816204071044922e-05}, /* L1952 */
{3.4397442340850830e+00, 1.9359588623046875e-04,
	1.1920928955078125e-07, 1.4424324035644531e-04,
	2.7120113372802734e-04}, /* L1953 */
{2.8241491317749023e+00, 1.5892460942268372e-04,
	1.1920928955078125e-07, 1.3351440429687500e-05,
	-4.4703483581542969e-06}, /* L1954 */
{2.5162622928619385e+00, 1.4173984527587891e-04,
	1.1920928955078125e-07, -1.1503696441650391e-05,
	1.8715858459472656e-05}, /* L1955 */
{2.1169745922088623e+00, 1.1938810348510742e-04,
	1.1920928955078125e-07, -2.1398067474365234e-05,
	1.4305114746093750e-05}, /* L1956 */
{2.7241365909576416e+00, 1.5377998352050781e-04,
	1.1920928955078125e-07, 6.0796737670898438e-05,
	-1.6331672668457031e-05}, /* L1957 */
{1.7056642770767212e+00, 9.6410512924194336e-05,
	1.1920928955078125e-07, 8.0347061157226562e-05,
	6.6399574279785156e-05}, /* L1958 */
{3.1809294223785400e+00, 1.7994642257690430e-04,
	1.1920928955078125e-07, -3.5762786865234375e-06,
	-4.8279762268066406e-06}, /* L1959 */
{2.2413270473480225e+00, 1.2692809104919434e-04,
	1.1920928955078125e-07, 7.9154968261718750e-05,
	-1.1438131332397461e-04}, /* L1960 */
{2.8122732639312744e+00, 1.5943124890327454e-04,
	1.1920928955078125e-07, 6.9141387939453125e-06,
	-4.6074390411376953e-05}, /* L1961 */
{2.1340303421020508e+00, 1.2111663818359375e-04,
	1.1920928955078125e-07, 6.0319900512695312e-05,
	7.6651573181152344e-05}, /* L1962 */
{2.8176293373107910e+00, 1.6009807586669922e-04,
	1.1920928955078125e-07, -7.7486038208007812e-06,
	1.0097026824951172e-04}, /* L1963 */
{1.9855377674102783e+00, 1.1295080184936523e-04,
	1.1920928955078125e-07, 3.9935111999511719e-05,
	-1.1801719665527344e-04}, /* L1964 */
{2.6457307338714600e+00, 1.5062093734741211e-04,
	1.1920928955078125e-07, 2.6226043701171875e-06,
	1.1563301086425781e-04}, /* L1965 */
{1.8793472051620483e+00, 1.0713934898376465e-04,
	1.1920928955078125e-07, -2.2655725479125977e-04,
	9.6440315246582031e-05}, /* L1966 */
{3.2956936359405518e+00, 1.8802285194396973e-04,
	1.1920928955078125e-07, 3.4451484680175781e-05,
	7.5101852416992188e-06}, /* L1967 */
{2.8477327823638916e+00, 1.6269087791442871e-04,
	1.1920928955078125e-07, -1.2516975402832031e-05,
	-1.8274784088134766e-04}, /* L1968 */
{3.2187063694000244e+00, 1.8413364887237549e-04,
	1.1920928955078125e-07, -1.2969970703125000e-04,
	-3.2395124435424805e-04}, /* L1969 */
{2.1435589790344238e+00, 1.2266635894775391e-04,
	1.1920928955078125e-07, -2.9802322387695312e-07,
	1.5735626220703125e-05}, /* L1970 */
{2.9644253253936768e+00, 1.6984343528747559e-04,
	1.1920928955078125e-07, -6.0856342315673828e-05,
	-2.7418136596679688e-05}, /* L1971 */
{2.0189805030822754e+00, 1.1578202247619629e-04,
	1.1920928955078125e-07, 4.8637390136718750e-05,
	3.1709671020507812e-05}, /* L1972 */
{3.2408525943756104e+00, 1.8605589866638184e-04,
	1.1920928955078125e-07, 3.2901763916015625e-05,
	2.5033950805664062e-05}, /* L1973 */
{2.0035963058471680e+00, 1.1513382196426392e-04,
	1.1920928955078125e-07, 6.1988830566406250e-06,
	7.2717666625976562e-06}, /* L1974 */
{2.5991616249084473e+00, 1.4951080083847046e-04,
	1.1920928955078125e-07, -2.2470951080322266e-05,
	3.5166740417480469e-05}, /* L1975 */
{2.3958036899566650e+00, 1.3831257820129395e-04,
	1.1920928955078125e-07, 3.6430358886718750e-04,
	-1.8298625946044922e-05}, /* L1976 */
{2.4136555194854736e+00, 1.3914704322814941e-04,
	1.1920928955078125e-07, -9.2267990112304688e-05,
	-5.2571296691894531e-05}, /* L1977 */
{1.7428263425827026e+00, 1.0064337402582169e-04,
	1.1920928955078125e-07, -2.9265880584716797e-05,
	-5.3644180297851562e-06}, /* L1978 */
{2.9059805870056152e+00, 1.6786158084869385e-04,
	1.1920928955078125e-07, 3.3378601074218750e-05,
	-1.9073486328125000e-05}, /* L1979 */
{2.4391889572143555e+00, 1.4105439186096191e-04,
	1.1920928955078125e-07, -2.0980834960937500e-05,
	-5.3048133850097656e-05}, /* L1980 */
{2.7203071117401123e+00, 1.5753507614135742e-04,
	1.1920928955078125e-07, 1.8715858459472656e-05,
	-2.5969743728637695e-04}, /* L1981 */
{2.3946189880371094e+00, 1.3878196477890015e-04,
	1.1920928955078125e-07, 7.3790550231933594e-05,
	-1.0365247726440430e-04}, /* L1982 */
{2.7591810226440430e+00, 1.6010552644729614e-04,
	1.1920928955078125e-07, 2.5033950805664062e-06,
	-6.5505504608154297e-05}, /* L1983 */
{1.9628891944885254e+00, 1.1396408081054688e-04,
	1.1920928955078125e-07, -5.1259994506835938e-06,
	2.6583671569824219e-05}, /* L1984 */
{2.9665896892547607e+00, 1.7242133617401123e-04,
	1.1920928955078125e-07, 3.1590461730957031e-05,
	-1.5020370483398438e-05}, /* L1985 */
{2.2222132682800293e+00, 1.2928247451782227e-04,
	1.1920928955078125e-07, -2.9802322387695312e-07,
	8.1062316894531250e-06}, /* L1986 */
{3.0559027194976807e+00, 1.7797946929931641e-04,
	1.1920928955078125e-07, -5.0067901611328125e-06,
	5.0902366638183594e-05}, /* L1987 */
{2.2775073051452637e+00, 1.3278424739837646e-04,
	1.1920928955078125e-07, -5.6326389312744141e-05,
	-2.2768974304199219e-05}, /* L1988 */
{3.2548406124114990e+00, 1.8998980522155762e-04,
	1.1920928955078125e-07, -9.1791152954101562e-06,
	2.3043155670166016e-04}, /* L1989 */
{2.2917304039001465e+00, 1.3398379087448120e-04,
	1.1920928955078125e-07, -3.1322240829467773e-04,
	3.6585330963134766e-04}, /* L1990 */
{3.1600151062011719e+00, 1.8480420112609863e-04,
	1.1920928955078125e-07, -1.0609626770019531e-05,
	3.3617019653320312e-05}, /* L1991 */
{2.4353582859039307e+00, 1.4257431030273438e-04,
	1.1920928955078125e-07, 2.9563903808593750e-05,
	-2.1994113922119141e-05}, /* L1992 */
{2.9273936748504639e+00, 1.7154216766357422e-04,
	1.1920928955078125e-07, -6.2525272369384766e-05,
	1.2946128845214844e-04}, /* L1993 */
{1.8083318471908569e+00, 1.0606646537780762e-04,
	1.1920928955078125e-07, -1.6152858734130859e-05,
	5.7220458984375000e-06}, /* L1994 */
{3.1197268962860107e+00, 1.8335878849029541e-04,
	1.1920928955078125e-07, -4.8440694808959961e-04,
	1.3887882232666016e-04}, /* L1995 */
{2.1046981811523438e+00, 1.2370944023132324e-04,
	1.1920928955078125e-07, -7.1525573730468750e-06,
	-1.9729137420654297e-05}, /* L1996 */
{2.5268464088439941e+00, 1.4868378639221191e-04,
	1.1920928955078125e-07, -4.7683715820312500e-06,
	4.7683715820312500e-07}, /* L1997 */
{2.1645905971527100e+00, 1.2749433517456055e-04,
	1.1920928955078125e-07, 1.1086463928222656e-05,
	4.1127204895019531e-05}, /* L1998 */
{2.8154706954956055e+00, 1.6599893569946289e-04,
	1.1920928955078125e-07, -5.4836273193359375e-05,
	9.7393989562988281e-05}, /* L1999 */
{2.4877271652221680e+00, 1.4683604240417480e-04,
	1.1920928955078125e-07, 4.1484832763671875e-05,
	7.0452690124511719e-05}, /* L2000 */
{2.8615453243255615e+00, 1.6911327838897705e-04,
	1.1920928955078125e-07, -7.2240829467773438e-05,
	1.5532970428466797e-04}, /* L2001 */
{2.2114782333374023e+00, 1.3077259063720703e-04,
	1.1920928955078125e-07, -9.8943710327148438e-06,
	2.6226043701171875e-06}, /* L2002 */
{2.9739820957183838e+00, 1.7631053924560547e-04,
	1.1920928955078125e-07, -8.5550546646118164e-04,
	1.8191337585449219e-04}, /* L2003 */
{2.7283720970153809e+00, 1.6182661056518555e-04,
	1.1920928955078125e-07, 2.6714801788330078e-04,
	-1.5407800674438477e-04}, /* L2004 */
{3.0635843276977539e+00, 1.8173456192016602e-04,
	1.1920928955078125e-07, -7.9572200775146484e-05,
	-2.6226043701171875e-05}, /* L2005 */
{1.9393781423568726e+00, 1.1515617370605469e-04,
	1.1920928955078125e-07, -1.3172626495361328e-05,
	1.8358230590820312e-05}, /* L2006 */
{2.5894029140472412e+00, 1.5389174222946167e-04,
	1.1920928955078125e-07, 2.5153160095214844e-05,
	3.6954879760742188e-05}, /* L2007 */
{2.0099897384643555e+00, 1.1957064270973206e-04,
	1.1920928955078125e-07, 2.3841857910156250e-05,
	5.7220458984375000e-06}, /* L2008 */
{2.7748332023620605e+00, 1.6534328460693359e-04,
	1.1920928955078125e-07, -3.9339065551757812e-06,
	4.6014785766601562e-05}, /* L2009 */
{2.0054776668548584e+00, 1.1956691741943359e-04,
	1.1920928955078125e-07, 6.5326690673828125e-05,
	-1.2040138244628906e-05}, /* L2010 */
{3.6920042037963867e+00, 4.4040381908416748e-04,
	1.1920928955078125e-07, 2.8407573699951172e-04,
	-8.6128711700439453e-05}, /* L2011 */
{4.4301600456237793e+00, 7.9256296157836914e-04,
	1.1920928955078125e-07, 1.4102458953857422e-04,
	-7.6711177825927734e-05}, /* L2012 */
{6.0660715103149414e+00, 1.4528632164001465e-03,
	1.1920928955078125e-07, -8.8810920715332031e-06,
	-3.0279159545898438e-05}, /* L2013 */
{7.6663098335266113e+00, 2.2868216037750244e-03,
	1.1920928955078125e-07, -8.6307525634765625e-05,
	-1.0907649993896484e-05}, /* L2014 */
{9.7100963592529297e+00, 3.4745782613754272e-03,
	1.1920928955078125e-07, -9.0360641479492188e-05,
	1.2743473052978516e-04}, /* L2015 */
{1.1466410636901855e+01, 4.8325955867767334e-03,
	1.1920928955078125e-07, -6.0528516769409180e-04,
	-1.0817050933837891e-03}, /* L2016 */
{1.1994355201721191e+01, 5.7648420333862305e-03,
	1.1920928955078125e-07, -1.5127658843994141e-04,
	1.9207000732421875e-03}, /* L2017 */
{1.2910548210144043e+01, 7.8035499900579453e-03,
	1.1920928955078125e-07, -1.2465119361877441e-03,
	2.3229956626892090e-02}, /* L2018 */
{1.4922426223754883e+01, 8.9192017912864685e-03,
	1.1920928955078125e-07, -1.7597675323486328e-03,
	7.2169303894042969e-04}, /* L2019 */
#endif	/* } */

/* Always the last one. Common to both DP and SP */

{, 0.0000000000000000e+00,
	0.0000000000000000e+00, 0.0000000000000000e+00,
	0.0000000000000000e+00, /* L2020 */
};

#endif	/* LAPACK_V9A_SS13 */
