/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2008 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef	_SINGDOUB64V9B_SS12_H
#define	_SINGDOUB64V9B_SS12_H

#pragma ident	"%Z%%M%	%I%	%E% SMI"

#ifdef __cplusplus
extern "C" {
#endif

/* 64-bit golden values for V9B/SS12 Lapack */


static struct LinpVals LinpValsA[] = {

#ifdef DP  /* { */

/* Start of DP golden values */


{0.0000000000000000e+00, 0.0000000000000000e+00,
	0.0000000000000000e+00, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L0 */
{0.0000000000000000e+00, 0.0000000000000000e+00,
	2.2204460492503131e-16, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L1 */
{0.0000000000000000e+00, 0.0000000000000000e+00,
	2.2204460492503131e-16, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L2 */
{0.0000000000000000e+00, 0.0000000000000000e+00,
	2.2204460492503131e-16, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L3 */
{3.8260177822204688e-01, 1.6653345369377348e-16,
	2.2204460492503131e-16, 2.2204460492503131e-16,
	2.2204460492503131e-16}, /* L4 */
{4.0810856343684981e-01, 2.2204460492503131e-16,
	2.2204460492503131e-16, -3.3306690738754696e-16,
	0.0000000000000000e+00}, /* L5 */
{3.4009046953070693e-01, 2.2204460492503131e-16,
	2.2204460492503131e-16, 8.8817841970012523e-16,
	2.6645352591003757e-15}, /* L6 */
{3.6373773558278227e-01, 2.7755575615628914e-16,
	2.2204460492503131e-16, -3.3306690738754696e-16,
	8.8817841970012523e-16}, /* L7 */
{3.2492063115128750e-01, 2.8449465006019636e-16,
	2.2204460492503131e-16, -1.7763568394002505e-15,
	-1.1102230246251565e-16}, /* L8 */
{4.5083838251885799e-01, 4.4408920985006262e-16,
	2.2204460492503131e-16, -1.5543122344752192e-15,
	-4.5519144009631418e-15}, /* L9 */
{4.0575454426697483e-01, 4.4408920985006262e-16,
	2.2204460492503131e-16, -1.1102230246251565e-16,
	-2.2204460492503131e-16}, /* L10 */
{5.9941012221257661e-01, 7.2164496600635175e-16,
	2.2204460492503131e-16, 2.2204460492503131e-16,
	2.2204460492503131e-16}, /* L11 */
{2.9586268852800246e-01, 3.8857805861880479e-16,
	2.2204460492503131e-16, -5.5511151231257827e-16,
	0.0000000000000000e+00}, /* L12 */
{6.2922387221750764e-01, 9.0205620750793969e-16,
	2.2204460492503131e-16, -1.6653345369377348e-15,
	-2.2204460492503131e-16}, /* L13 */
{5.3933474761500677e-01, 8.3266726846886741e-16,
	2.2204460492503131e-16, -4.4408920985006262e-16,
	0.0000000000000000e+00}, /* L14 */
{6.7117213036534140e-01, 1.1102230246251565e-15,
	2.2204460492503131e-16, -6.6613381477509392e-16,
	-1.1102230246251565e-16}, /* L15 */
{7.8652984027188344e-01, 1.3877787807814457e-15,
	2.2204460492503131e-16, -6.6613381477509392e-16,
	0.0000000000000000e+00}, /* L16 */
{6.3662650600829918e-01, 1.1934897514720433e-15,
	2.2204460492503131e-16, -1.1102230246251565e-15,
	-1.3322676295501878e-15}, /* L17 */
{2.9363780703483666e-01, 5.8286708792820718e-16,
	2.2204460492503131e-16, 4.4408920985006262e-16,
	4.4408920985006262e-16}, /* L18 */
{8.0143251092966705e-01, 1.6792123247455493e-15,
	2.2204460492503131e-16, -5.5511151231257827e-16,
	8.8817841970012523e-16}, /* L19 */
{5.9147043988445613e-01, 1.3045120539345589e-15,
	2.2204460492503131e-16, -6.6613381477509392e-16,
	-2.2204460492503131e-16}, /* L20 */
{5.9684867319455459e-01, 1.3877787807814457e-15,
	2.2204460492503131e-16, 2.2204460492503131e-15,
	-1.4432899320127035e-15}, /* L21 */
{4.7856411796145321e-01, 1.1657341758564144e-15,
	2.2204460492503131e-16, -5.5511151231257827e-16,
	-2.3314683517128287e-15}, /* L22 */
{4.5775698239791013e-01, 1.1657341758564144e-15,
	2.2204460492503131e-16, 2.4424906541753444e-15,
	-2.9976021664879227e-15}, /* L23 */
{6.7891536575880340e-01, 1.8041124150158794e-15,
	2.2204460492503131e-16, -1.1546319456101628e-14,
	-2.2204460492503131e-15}, /* L24 */
{5.8156934716077235e-01, 1.6098233857064770e-15,
	2.2204460492503131e-16, 1.5543122344752192e-15,
	3.3306690738754696e-15}, /* L25 */
{6.1704970521036173e-01, 1.7763568394002505e-15,
	2.2204460492503131e-16, -2.9976021664879227e-15,
	-4.2188474935755949e-15}, /* L26 */
{8.9129401863720303e-01, 2.6645352591003757e-15,
	2.2204460492503131e-16, -4.4408920985006262e-16,
	2.4424906541753444e-15}, /* L27 */
{8.9527300979183411e-01, 2.7755575615628914e-15,
	2.2204460492503131e-16, 1.5543122344752192e-15,
	-1.3322676295501878e-15}, /* L28 */
{8.1253743509383025e-01, 2.6090241078691179e-15,
	2.2204460492503131e-16, 0.0000000000000000e+00,
	6.6613381477509392e-16}, /* L29 */
{8.6065578674654963e-01, 2.8588242884097781e-15,
	2.2204460492503131e-16, 8.8817841970012523e-16,
	8.8817841970012523e-16}, /* L30 */
{9.0566972861522066e-01, 3.1086244689504383e-15,
	2.2204460492503131e-16, 1.7763568394002505e-15,
	-1.6653345369377348e-15}, /* L31 */
{7.3636205055376436e-01, 2.6090241078691179e-15,
	2.2204460492503131e-16, -9.9920072216264089e-16,
	2.1760371282653068e-14}, /* L32 */
{8.4318439831303504e-01, 3.0808688933348094e-15,
	2.2204460492503131e-16, 6.6613381477509392e-16,
	1.1102230246251565e-15}, /* L33 */
{9.7321442476194397e-01, 3.6637359812630166e-15,
	2.2204460492503131e-16, -2.6645352591003757e-15,
	2.2204460492503131e-16}, /* L34 */
{1.4583044708110673e+00, 5.6621374255882984e-15,
	2.2204460492503131e-16, -3.9968028886505635e-15,
	-4.4408920985006262e-16}, /* L35 */
{7.3322293824479434e-01, 2.9282132274488504e-15,
	2.2204460492503131e-16, -1.7652546091539989e-14,
	1.4654943925052066e-14}, /* L36 */
{8.4526789345500786e-01, 3.4694469519536142e-15,
	2.2204460492503131e-16, -1.9984014443252818e-15,
	-7.7715611723760958e-16}, /* L37 */
{3.8846732871836481e-01, 1.6375789613221059e-15,
	2.2204460492503131e-16, 1.0658141036401503e-14,
	1.9984014443252818e-15}, /* L38 */
{9.3664352009106877e-01, 4.0523140398818214e-15,
	2.2204460492503131e-16, 2.8865798640254070e-15,
	1.7763568394002505e-15}, /* L39 */
{5.5043845221636245e-01, 2.4424906541753444e-15,
	2.2204460492503131e-16, -9.0261131902025227e-13,
	2.2069013283498862e-12}, /* L40 */
{8.0551968617249903e-01, 3.6637359812630166e-15,
	2.2204460492503131e-16, -2.6312285683616210e-14,
	-2.6645352591003757e-14}, /* L41 */
{1.0454756316476288e+00, 4.8711035205428743e-15,
	2.2204460492503131e-16, 4.6629367034256575e-15,
	-5.2180482157382357e-15}, /* L42 */
{9.7752283269141105e-01, 4.6629367034256575e-15,
	2.2204460492503131e-16, -5.5511151231257827e-16,
	-2.6645352591003757e-15}, /* L43 */
{8.6148166850218699e-01, 4.2049697057677804e-15,
	2.2204460492503131e-16, -3.4416913763379853e-15,
	1.1102230246251565e-15}, /* L44 */
{1.0563970295090952e+00, 5.2735593669694936e-15,
	2.2204460492503131e-16, -2.8865798640254070e-15,
	-1.2101430968414206e-14}, /* L45 */
{1.0211938676275674e+00, 5.2111093218343285e-15,
	2.2204460492503131e-16, -8.7707618945387367e-15,
	-4.1078251911130792e-15}, /* L46 */
{9.6885685013140577e-01, 5.0515147620444623e-15,
	2.2204460492503131e-16, -3.8191672047105385e-14,
	4.4408920985006262e-15}, /* L47 */
{1.1825826121868439e+00, 6.2970462177958098e-15,
	2.2204460492503131e-16, 2.6645352591003757e-15,
	6.6613381477509392e-15}, /* L48 */
{1.5740038790865019e+00, 8.5625950774215198e-15,
	2.2204460492503131e-16, -1.8984813721090177e-14,
	-8.1046280797636427e-15}, /* L49 */
{9.0001388742580246e-01, 4.9960036108132044e-15,
	2.2204460492503131e-16, 8.8817841970012523e-16,
	-3.2196467714129540e-15}, /* L50 */
{8.5295433775635876e-01, 4.8294701571194310e-15,
	2.2204460492503131e-16, -1.2212453270876722e-15,
	3.7969627442180354e-14}, /* L51 */
{1.3605979174225624e+00, 7.8548278992229825e-15,
	2.2204460492503131e-16, 3.5527136788005009e-15,
	3.7747582837255322e-15}, /* L52 */
{8.8680613645728601e-01, 5.2180482157382357e-15,
	2.2204460492503131e-16, -2.4424906541753444e-15,
	-3.8857805861880479e-15}, /* L53 */
{9.6529267247058115e-01, 5.7870375158586285e-15,
	2.2204460492503131e-16, 1.7763568394002505e-15,
	-2.3314683517128287e-15}, /* L54 */
{8.9092283805786343e-01, 5.4400928206632670e-15,
	2.2204460492503131e-16, 2.8865798640254070e-15,
	4.4408920985006262e-15}, /* L55 */
{9.1965704766721101e-01, 5.7176485768195562e-15,
	2.2204460492503131e-16, 1.6209256159527285e-14,
	-1.8873791418627661e-15}, /* L56 */
{1.0000154304731188e+00, 6.3282712403633923e-15,
	2.2204460492503131e-16, -2.3314683517128287e-15,
	7.9936057773011271e-15}, /* L57 */
{1.2586401107668486e+00, 8.1046280797636427e-15,
	2.2204460492503131e-16, 3.8968828164342995e-13,
	2.3470114740575809e-13}, /* L58 */
{8.8242887032215045e-01, 5.7800986219547212e-15,
	2.2204460492503131e-16, -4.5519144009631418e-15,
	-2.3314683517128287e-15}, /* L59 */
{9.7501504471128808e-01, 6.4948046940571658e-15,
	2.2204460492503131e-16, -1.5543122344752192e-15,
	8.8817841970012523e-16}, /* L60 */
{1.3688735810572958e+00, 9.2703622556200571e-15,
	2.2204460492503131e-16, -7.4606987254810520e-14,
	-1.2134737659152961e-13}, /* L61 */
{1.0902385968313253e+00, 7.5044137570756675e-15,
	2.2204460492503131e-16, 4.4408920985006262e-16,
	3.7747582837255322e-15}, /* L62 */
{7.2620168165310051e-01, 5.0792703376600912e-15,
	2.2204460492503131e-16, -4.8849813083506888e-15,
	4.4408920985006262e-16}, /* L63 */
{1.0722821705659045e+00, 7.6189055064901368e-15,
	2.2204460492503131e-16, -1.5543122344752192e-15,
	2.2204460492503131e-16}, /* L64 */
{1.1692488110146999e+00, 8.4376949871511897e-15,
	2.2204460492503131e-16, -8.8817841970012523e-16,
	-2.7755575615628914e-15}, /* L65 */
{1.0378948028395030e+00, 7.6050277186823223e-15,
	2.2204460492503131e-16, -2.0206059048177849e-14,
	7.3274719625260332e-15}, /* L66 */
{1.3750212169004810e+00, 1.0227929614359255e-14,
	2.2204460492503131e-16, -9.7699626167013776e-15,
	6.6613381477509392e-15}, /* L67 */
{7.9780642798774548e-01, 6.0229599085914742e-15,
	2.2204460492503131e-16, -9.7699626167013776e-15,
	-3.8857805861880479e-15}, /* L68 */
{1.2445844216208166e+00, 9.5340402239685318e-15,
	2.2204460492503131e-16, 1.8141044222375058e-13,
	3.5194069880617462e-13}, /* L69 */
{1.0643021367178127e+00, 8.2711615334574162e-15,
	2.2204460492503131e-16, -3.2196467714129540e-15,
	-1.5543122344752192e-15}, /* L70 */
{1.1760744851338045e+00, 9.2703622556200571e-15,
	2.2204460492503131e-16, -3.2751579226442118e-14,
	-2.0539125955565396e-14}, /* L71 */
{1.3402984588979951e+00, 1.0713652187632761e-14,
	2.2204460492503131e-16, -1.9984014443252818e-15,
	-1.9984014443252818e-15}, /* L72 */
{1.0993320314446988e+00, 8.9095397726168812e-15,
	2.2204460492503131e-16, -2.3869795029440866e-14,
	7.3274719625260332e-15}, /* L73 */
{1.4020486609673712e+00, 1.1518563880485999e-14,
	2.2204460492503131e-16, 5.1070259132757201e-15,
	-5.8841820305133297e-15}, /* L74 */
{1.7035809741547945e+00, 1.4184942283279600e-14,
	2.2204460492503131e-16, -9.9920072216264089e-16,
	-5.2180482157382357e-15}, /* L75 */
{1.1513335548210102e+00, 9.7144514654701197e-15,
	2.2204460492503131e-16, -4.5519144009631418e-15,
	-3.2196467714129540e-15}, /* L76 */
{1.1802130161590194e+00, 1.0089151736281110e-14,
	2.2204460492503131e-16, 6.8833827526759706e-15,
	-1.7763568394002505e-15}, /* L77 */
{1.0448879177378469e+00, 9.0483176506950258e-15,
	2.2204460492503131e-16, 8.8817841970012523e-16,
	5.4178883601707639e-14}, /* L78 */
{1.7785084554616846e+00, 1.5598633495983449e-14,
	2.2204460492503131e-16, 1.7763568394002505e-15,
	8.8817841970012523e-16}, /* L79 */
{1.5640866342229285e+00, 1.3891665595622271e-14,
	2.2204460492503131e-16, 4.4830805734363821e-13,
	1.3677947663381929e-13}, /* L80 */
{1.2407598859573825e+00, 1.1157741397482823e-14,
	2.2204460492503131e-16, -4.5519144009631418e-15,
	1.1102230246251565e-15}, /* L81 */
{2.3414995445223701e+00, 2.1316282072803006e-14,
	2.2204460492503131e-16, -5.1070259132757201e-15,
	-3.0087043967341742e-14}, /* L82 */
{1.4909868616993309e+00, 1.3739009929736312e-14,
	2.2204460492503131e-16, 2.5091040356528538e-14,
	-6.5503158452884236e-15}, /* L83 */
{1.1250173592822328e+00, 1.0491607582707729e-14,
	2.2204460492503131e-16, -4.1744385725905886e-14,
	-3.4416913763379853e-15}, /* L84 */
{1.9217208290746031e+00, 1.8134799217861541e-14,
	2.2204460492503131e-16, -3.2196467714129540e-15,
	-2.4424906541753444e-15}, /* L85 */
{1.6860725281232691e+00, 1.6098233857064770e-14,
	2.2204460492503131e-16, 8.2156503822261584e-15,
	-6.6613381477509392e-16}, /* L86 */
{1.0862236572379966e+00, 1.0491607582707729e-14,
	2.2204460492503131e-16, -2.9087843245179101e-14,
	-1.2212453270876722e-14}, /* L87 */
{1.6988898506332140e+00, 1.6597834218146090e-14,
	2.2204460492503131e-16, 6.2172489379008766e-15,
	-1.0436096431476471e-14}, /* L88 */
{1.4101341182513836e+00, 1.3933298959045715e-14,
	2.2204460492503131e-16, 1.1324274851176597e-14,
	-2.8865798640254070e-15}, /* L89 */
{9.4445901766904683e-01, 9.4368957093138306e-15,
	2.2204460492503131e-16, -1.4432899320127035e-15,
	4.2188474935755949e-15}, /* L90 */
{8.8462903464924114e-01, 8.9372953482325102e-15,
	2.2204460492503131e-16, 2.7311486405778851e-14,
	4.3076653355456074e-14}, /* L91 */
{1.4293698816001337e+00, 1.4599432773820809e-14,
	2.2204460492503131e-16, -9.7699626167013776e-15,
	6.8833827526759706e-15}, /* L92 */
{1.4381942346857988e+00, 1.4849232954361469e-14,
	2.2204460492503131e-16, -1.0547118733938987e-14,
	2.8865798640254070e-15}, /* L93 */
{1.4095962184859603e+00, 1.4710455076283324e-14,
	2.2204460492503131e-16, -1.4765966227514582e-14,
	-7.9936057773011271e-15}, /* L94 */
{2.8039906346555035e+00, 2.9573565818452607e-14,
	2.2204460492503131e-16, -1.6431300764452317e-14,
	5.5511151231257827e-15}, /* L95 */
{1.6041914197172078e+00, 1.7097434579227411e-14,
	2.2204460492503131e-16, -1.5987211554602254e-14,
	-2.6645352591003757e-15}, /* L96 */
{1.8170383466070419e+00, 1.9567680809018384e-14,
	2.2204460492503131e-16, -1.5321077739827160e-14,
	5.3290705182007514e-15}, /* L97 */
{1.3439301759339604e+00, 1.4621984179008507e-14,
	2.2204460492503131e-16, 7.3274719625260332e-15,
	-1.3322676295501878e-15}, /* L98 */
{1.9242721162132923e+00, 2.1149748619109232e-14,
	2.2204460492503131e-16, 6.2172489379008766e-15,
	8.8817841970012523e-16}, /* L99 */
{2.9625457127765391e+00, 3.2890357104520263e-14,
	2.2204460492503131e-16, -3.5527136788005009e-15,
	5.5511151231257827e-15}, /* L100 */
{1.2852921095869991e+00, 1.4412082638415313e-14,
	2.2204460492503131e-16, -2.4535928844215960e-14,
	-1.0103029524088925e-14}, /* L101 */
{1.3970803808080099e+00, 1.5820678100908481e-14,
	2.2204460492503131e-16, -7.7715611723760958e-15,
	6.2172489379008766e-15}, /* L102 */
{1.6844920115250395e+00, 1.9262369477246466e-14,
	2.2204460492503131e-16, -2.6756374893466273e-14,
	-6.8833827526759706e-15}, /* L103 */
{1.3750212169004725e+00, 1.5876189252139739e-14,
	2.2204460492503131e-16, -1.0547118733938987e-14,
	1.5765166949677223e-14}, /* L104 */
{1.3047820378553872e+00, 1.5210055437364645e-14,
	2.2204460492503131e-16, -7.5495165674510645e-15,
	9.5479180117763462e-15}, /* L105 */
{1.1226588323233835e+00, 1.3211653993039363e-14,
	2.2204460492503131e-16, 2.3758772726978350e-14,
	-5.9063864910058328e-14}, /* L106 */
{1.4112367289854100e+00, 1.6764367671839864e-14,
	2.2204460492503131e-16, 1.7319479184152442e-14,
	1.2656542480726785e-14}, /* L107 */
{2.4329079107111644e+00, 2.9171109972025988e-14,
	2.2204460492503131e-16, 1.3322676295501878e-15,
	-5.9952043329758453e-15}, /* L108 */
{1.3486446631150799e+00, 1.6320278461989801e-14,
	2.2204460492503131e-16, 3.3084646133829665e-14,
	3.1974423109204508e-14}, /* L109 */
{1.6272978368607867e+00, 1.9872992140790302e-14,
	2.2204460492503131e-16, -8.9928064994637680e-15,
	2.2204460492503131e-16}, /* L110 */
{1.9583635513431428e+00, 2.4133472997789340e-14,
	2.2204460492503131e-16, -3.5527136788005009e-15,
	-2.7755575615628914e-15}, /* L111 */
{1.4910944365089831e+00, 1.8540724511240114e-14,
	2.2204460492503131e-16, 1.5543122344752192e-14,
	-3.1863400806741993e-14}, /* L112 */
{1.6593176390593474e+00, 2.0816681711721685e-14,
	2.2204460492503131e-16, 7.3274719625260332e-15,
	1.0436096431476471e-14}, /* L113 */
{1.4802859990555859e+00, 1.8735013540549517e-14,
	2.2204460492503131e-16, 8.8817841970012523e-16,
	-1.5543122344752192e-15}, /* L114 */
{2.1060107571102940e+00, 2.6888213877640510e-14,
	2.2204460492503131e-16, 3.3528735343679728e-14,
	-1.0325074129013956e-14}, /* L115 */
{1.2823473731281858e+00, 1.6514567491299204e-14,
	2.2204460492503131e-16, -9.4368957093138306e-15,
	-2.2537527399890678e-14}, /* L116 */
{1.6709659543366842e+00, 2.1704860131421810e-14,
	2.2204460492503131e-16, -1.0558220964185239e-13,
	-1.3256062914024369e-13}, /* L117 */
{2.0731252091441892e+00, 2.7158830739892892e-14,
	2.2204460492503131e-16, 2.6645352591003757e-15,
	-2.0341506257182118e-12}, /* L118 */
{1.1575808869552118e+00, 1.5293322164211531e-14,
	2.2204460492503131e-16, -4.4408920985006262e-16,
	-8.4376949871511897e-15}, /* L119 */
{2.4625379975399899e+00, 3.2807090377673376e-14,
	2.2204460492503131e-16, -3.2196467714129540e-14,
	-8.4376949871511897e-15}, /* L120 */
{1.7438285605758650e+00, 2.3425705819590803e-14,
	2.2204460492503131e-16, 1.2456702336294256e-13,
	-5.9396931817445875e-14}, /* L121 */
{2.5451212390319462e+00, 3.4472424914611111e-14,
	2.2204460492503131e-16, -1.6653345369377348e-15,
	4.4408920985006262e-15}, /* L122 */
{1.1016430148704714e+00, 1.5043521983670871e-14,
	2.2204460492503131e-16, -2.9198865547641617e-14,
	-2.6867397195928788e-14}, /* L123 */
{1.4506272222286285e+00, 1.9970136655445003e-14,
	2.2204460492503131e-16, 1.9984014443252818e-15,
	1.2434497875801753e-14}, /* L124 */
{1.5360237012065137e+00, 2.1316282072803006e-14,
	2.2204460492503131e-16, -6.4726002335646626e-14,
	3.2862601528904634e-14}, /* L125 */
{1.6746290145223433e+00, 2.3425705819590803e-14,
	2.2204460492503131e-16, 5.9952043329758453e-15,
	7.7715611723760958e-15}, /* L126 */
{1.3090753174492020e+00, 1.8457457784393227e-14,
	2.2204460492503131e-16, -2.3980817331903381e-14,
	-2.6179058920661191e-13}, /* L127 */
{1.9687803787438483e+00, 2.7977620220553945e-14,
	2.2204460492503131e-16, -2.7755575615628914e-15,
	-9.9920072216264089e-16}, /* L128 */
{1.9070061697393341e+00, 2.7311486405778851e-14,
	2.2204460492503131e-16, 1.7319479184152442e-14,
	3.4638958368304884e-14}, /* L129 */
{2.1846490942642083e+00, 3.1530333899354446e-14,
	2.2204460492503131e-16, -1.4876988529977098e-14,
	7.9936057773011271e-15}, /* L130 */
{2.0649173583425950e+00, 3.0031532816110484e-14,
	2.2204460492503131e-16, -7.0499162063697440e-14,
	1.4876988529977098e-14}, /* L131 */
{1.3409297817707460e+00, 1.9650947535865271e-14,
	2.2204460492503131e-16, 1.7541523789077473e-14,
	-5.8841820305133297e-15}, /* L132 */
{1.5413771672704086e+00, 2.2759572004815709e-14,
	2.2204460492503131e-16, -9.1038288019262836e-15,
	6.8389738316909643e-14}, /* L133 */
{1.8946187866518844e+00, 2.8185787037671162e-14,
	2.2204460492503131e-16, 5.7731597280508140e-15,
	-6.6613381477509392e-15}, /* L134 */
{1.6203953734517988e+00, 2.4286128663675299e-14,
	2.2204460492503131e-16, -4.4408920985006262e-16,
	3.7747582837255322e-15}, /* L135 */
{1.5919363286574972e+00, 2.4036328483134639e-14,
	2.2204460492503131e-16, -1.2878587085651816e-14,
	1.0436096431476471e-14}, /* L136 */
{1.9452854906648289e+00, 2.9587443606260422e-14,
	2.2204460492503131e-16, -5.6621374255882984e-15,
	-1.0325074129013956e-14}, /* L137 */
{2.2323714025370274e+00, 3.4201808052358729e-14,
	2.2204460492503131e-16, -5.9063864910058328e-14,
	-3.9634961979118088e-14}, /* L138 */
{1.8075818482472423e+00, 2.7894353493707058e-14,
	2.2204460492503131e-16, 7.3274719625260332e-15,
	-9.4368957093138306e-15}, /* L139 */
{1.5321664988307440e+00, 2.3814283878209608e-14,
	2.2204460492503131e-16, -2.9942714974140472e-13,
	-3.4139358007223564e-13}, /* L140 */
{2.6347924285160054e+00, 4.1244785364824565e-14,
	2.2204460492503131e-16, 6.6613381477509392e-16,
	-8.4376949871511897e-15}, /* L141 */
{1.8521412550311385e+00, 2.9198865547641617e-14,
	2.2204460492503131e-16, 1.7763568394002505e-15,
	1.0658141036401503e-14}, /* L142 */
{1.8496788906302410e+00, 2.9365399001335390e-14,
	2.2204460492503131e-16, -1.6653345369377348e-15,
	-3.2862601528904634e-14}, /* L143 */
{1.3906464580015256e+00, 2.2232216068118760e-14,
	2.2204460492503131e-16, -1.1213252548714081e-14,
	3.4416913763379853e-14}, /* L144 */
{1.4827815003566338e+00, 2.3869795029440866e-14,
	2.2204460492503131e-16, 4.3964831775156199e-14,
	9.9920072216264089e-15}, /* L145 */
{1.9366737189468126e+00, 3.1391556021276301e-14,
	2.2204460492503131e-16, -2.8532731732866523e-14,
	2.9976021664879227e-14}, /* L146 */
{1.6802980362370283e+00, 2.7422508708241367e-14,
	2.2204460492503131e-16, 7.7493567118835927e-14,
	2.2204460492503131e-16}, /* L147 */
{1.7094858372276440e+00, 2.8088642523016460e-14,
	2.2204460492503131e-16, 2.4424906541753444e-15,
	-1.1324274851176597e-14}, /* L148 */
{3.3616290519342669e+00, 5.5608295745912528e-14,
	2.2204460492503131e-16, 1.5987211554602254e-14,
	1.9761969838327786e-14}, /* L149 */
{2.9133782874447340e+00, 4.8516746176119341e-14,
	2.2204460492503131e-16, -1.6320278461989801e-14,
	1.0658141036401503e-14}, /* L150 */
{1.9205594360078899e+00, 3.2196467714129540e-14,
	2.2204460492503131e-16, 4.5075054799781356e-14,
	2.9976021664879227e-14}, /* L151 */
{1.5723926834412174e+00, 2.6534330288541241e-14,
	2.2204460492503131e-16, -2.1649348980190553e-14,
	1.7763568394002505e-14}, /* L152 */
{2.2484007064231508e+00, 3.8191672047105385e-14,
	2.2204460492503131e-16, -1.1990408665951691e-14,
	-8.4376949871511897e-15}, /* L153 */
{2.2159432834345298e+00, 3.7886360715333467e-14,
	2.2204460492503131e-16, -2.1094237467877974e-15,
	5.7731597280508140e-14}, /* L154 */
{2.4839092950460229e+00, 4.2743586448068527e-14,
	2.2204460492503131e-16, 1.7763568394002505e-15,
	-3.3639757646142243e-14}, /* L155 */
{2.8429925859922287e+00, 4.9238391142125693e-14,
	2.2204460492503131e-16, 9.3702823278363212e-14,
	-4.3298697960381105e-15}, /* L156 */
{1.7985946317186561e+00, 3.1349922657852858e-14,
	2.2204460492503131e-16, 3.9079850466805510e-14,
	-4.3187675657918589e-14}, /* L157 */
{2.2500347185644372e+00, 3.9468428525424315e-14,
	2.2204460492503131e-16, -6.8833827526759706e-15,
	9.3258734068513149e-15}, /* L158 */
{2.5189067918509283e+00, 4.4464432136237519e-14,
	2.2204460492503131e-16, 2.3048229991218250e-13,
	-1.4599432773820809e-13}, /* L159 */
{2.9300256797347366e+00, 5.2046908449732143e-14,
	2.2204460492503131e-16, -1.3766765505351941e-14,
	9.1038288019262836e-15}, /* L160 */
{2.2018973298304485e+00, 3.9357406222961799e-14,
	2.2204460492503131e-16, 2.1538326677728037e-14,
	-2.4535928844215960e-14}, /* L161 */
{2.4784333045366185e+00, 4.4575454438700035e-14,
	2.2204460492503131e-16, -2.8088642523016460e-14,
	2.2204460492503131e-16}, /* L162 */
{2.4478905322621287e+00, 4.4297898682543746e-14,
	2.2204460492503131e-16, 6.3060667798708891e-14,
	8.2156503822261584e-15}, /* L163 */
{1.9390543103075617e+00, 3.5305092183079978e-14,
	2.2204460492503131e-16, -1.0214051826551440e-14,
	2.9753977059954195e-14}, /* L164 */
{2.3926979047394039e+00, 4.3830390705767996e-14,
	2.2204460492503131e-16, -2.9753977059954195e-14,
	3.3306690738754696e-15}, /* L165 */
{1.8870773108172394e+00, 3.4777736246383029e-14,
	2.2204460492503131e-16, -3.0642155479654321e-14,
	-7.2830630415410269e-14}, /* L166 */
{3.0988502111965350e+00, 5.7454041524351851e-14,
	2.2204460492503131e-16, 1.9984014443252818e-15,
	-1.1768364061026659e-14}, /* L167 */
{2.0774130073509189e+00, 3.8746783559417963e-14,
	2.2204460492503131e-16, 1.7963408538435033e-13,
	-9.8254737679326354e-14}, /* L168 */
{1.7840511969681965e+00, 3.3473224192448470e-14,
	2.2204460492503131e-16, 1.2656542480726785e-14,
	2.0428103653102880e-14}, /* L169 */
{1.6103189652471119e+00, 3.0392355299113660e-14,
	2.2204460492503131e-16, -6.4392935428259079e-15,
	3.3306690738754696e-15}, /* L170 */
{1.4590868415381790e+00, 2.7700064464397656e-14,
	2.2204460492503131e-16, -3.4861002973229915e-14,
	1.7541523789077473e-14}, /* L171 */
{2.0625318253507161e+00, 3.9385161798577428e-14,
	2.2204460492503131e-16, 4.4408920985006262e-15,
	5.7731597280508140e-15}, /* L172 */
{2.4509048700612515e+00, 4.7073456244106637e-14,
	2.2204460492503131e-16, 6.8833827526759706e-15,
	-4.3298697960381105e-15}, /* L173 */
{2.7672840791527755e+00, 5.3457238635701287e-14,
	2.2204460492503131e-16, 9.6811447747313650e-14,
	-1.2778667013435552e-13}, /* L174 */
{2.0886036562166272e+00, 4.0578651550049472e-14,
	2.2204460492503131e-16, -2.6867397195928788e-14,
	-9.6589403142388619e-15}, /* L175 */
{2.3238994946785558e+00, 4.5408121707168903e-14,
	2.2204460492503131e-16, 4.7295500849031669e-14,
	-2.7200464103316335e-14}, /* L176 */
{2.8051280295473875e+00, 5.5122573172639022e-14,
	2.2204460492503131e-16, -7.3274719625260332e-15,
	1.1546319456101628e-14}, /* L177 */
{1.9901992485659987e+00, 3.9329650647346170e-14,
	2.2204460492503131e-16, -2.2848389846785722e-13,
	-1.6198153929281034e-13}, /* L178 */
{2.7221090418883036e+00, 5.4095616874860752e-14,
	2.2204460492503131e-16, -5.9952043329758453e-15,
	2.7311486405778851e-14}, /* L179 */
{1.7104430592043798e+00, 3.4180991370647007e-14,
	2.2204460492503131e-16, -7.4384942649885488e-15,
	-1.2945200467129325e-13}, /* L180 */
{1.6882166573145112e+00, 3.3924252296202440e-14,
	2.2204460492503131e-16, -9.8809849191638932e-15,
	-7.3274719625260332e-15}, /* L181 */
{3.0563658417612878e+00, 6.1756155744774333e-14,
	2.2204460492503131e-16, -2.2315482794965646e-14,
	1.5543122344752192e-14}, /* L182 */
{2.9494990633760696e+00, 5.9924287754142824e-14,
	2.2204460492503131e-16, -3.7858605139717838e-14,
	5.5067062021407764e-14}, /* L183 */
{1.8668766324320636e+00, 3.8136160895874127e-14,
	2.2204460492503131e-16, 4.4408920985006262e-15,
	2.2204460492503131e-14}, /* L184 */
{3.3041050371670369e+00, 6.7862382380212694e-14,
	2.2204460492503131e-16, -6.6435745793569367e-13,
	3.2640556923979602e-13}, /* L185 */
{2.2150879427681005e+00, 4.5741188614556449e-14,
	2.2204460492503131e-16, 1.3256062914024369e-13,
	1.8207657603852567e-14}, /* L186 */
{2.5762429605903074e+00, 5.3484994211316916e-14,
	2.2204460492503131e-16, 3.6859404417555197e-14,
	-1.3100631690576847e-14}, /* L187 */
{2.6542962755625545e+00, 5.5400128928795311e-14,
	2.2204460492503131e-16, -1.7685852782278744e-13,
	-1.5509815654013437e-13}, /* L188 */
{2.4524187937789370e+00, 5.1458837191376006e-14,
	2.2204460492503131e-16, -4.8960835385969403e-14,
	-7.4384942649885488e-15}, /* L189 */
{2.1552964146248783e+00, 4.5463632858400160e-14,
	2.2204460492503131e-16, -2.9087843245179101e-14,
	2.4646951146678475e-14}, /* L190 */
{2.2729408311734809e+00, 4.8197557056539608e-14,
	2.2204460492503131e-16, -1.2434497875801753e-14,
	-1.1102230246251565e-16}, /* L191 */
{2.7057709173477096e+00, 5.7676086129276882e-14,
	2.2204460492503131e-16, -2.1205259770340490e-14,
	2.5313084961453569e-14}, /* L192 */
{2.8238777699887536e+00, 6.0507154842071031e-14,
	2.2204460492503131e-16, 1.1768364061026659e-14,
	-5.2180482157382357e-15}, /* L193 */
{2.7062273247337711e+00, 5.8286708792820718e-14,
	2.2204460492503131e-16, 3.2418512319054571e-14,
	1.7319479184152442e-14}, /* L194 */
{1.5974605466275047e+00, 3.4583447217073626e-14,
	2.2204460492503131e-16, -1.5543122344752192e-14,
	3.7969627442180354e-14}, /* L195 */
{3.3776031376180593e+00, 7.3496764230185363e-14,
	2.2204460492503131e-16, 3.1752378504279477e-14,
	3.5749181392930041e-14}, /* L196 */
{2.8191266216130195e+00, 6.1657276506643655e-14,
	2.2204460492503131e-16, 1.6919798895287386e-13,
	-3.7081449022480228e-14}, /* L197 */
{2.3611475441724723e+00, 5.1902926401226068e-14,
	2.2204460492503131e-16, 3.9745984281580604e-14,
	-3.2529534621517087e-14}, /* L198 */
{2.1935011829220654e+00, 4.8461235024888083e-14,
	2.2204460492503131e-16, 5.9507954119908391e-14,
	-1.7208456881689926e-14}, /* L199 */
{2.5250389619438347e+00, 5.6066262743570405e-14,
	2.2204460492503131e-16, -1.3200551762793111e-13,
	-4.2410519540680980e-14}, /* L200 */
{2.3084933320371150e+00, 5.1514348342607263e-14,
	2.2204460492503131e-16, 2.1760371282653068e-14,
	4.8849813083506888e-15}, /* L201 */
{2.1584491469616061e+00, 4.8405723873656825e-14,
	2.2204460492503131e-16, -8.5709217501062085e-14,
	5.5511151231257827e-15}, /* L202 */
{3.3719732126048272e+00, 7.5994766035591965e-14,
	2.2204460492503131e-16, 3.9968028886505635e-15,
	2.4202861936828413e-14}, /* L203 */
{2.5711181043290647e+00, 5.8231197641589461e-14,
	2.2204460492503131e-16, 7.5495165674510645e-15,
	1.4654943925052066e-14}, /* L204 */
{2.2414980014670256e+00, 5.1014747981525943e-14,
	2.2204460492503131e-16, -2.7233770794055090e-12,
	4.0367709175370692e-13}, /* L205 */
{2.6747985543232389e+00, 6.1173288656846125e-14,
	2.2204460492503131e-16, -4.1855408028368402e-14,
	1.9184653865522705e-13}, /* L206 */
{2.4275736899163927e+00, 5.5788706987414116e-14,
	2.2204460492503131e-16, 4.5741188614556449e-14,
	4.7295500849031669e-14}, /* L207 */
{3.4207258595269141e+00, 7.8992368202079888e-14,
	2.2204460492503131e-16, 4.8849813083506888e-15,
	1.0214051826551440e-14}, /* L208 */
{1.9928537167083293e+00, 4.6240788975637770e-14,
	2.2204460492503131e-16, -6.2172489379008766e-15,
	6.8833827526759706e-15}, /* L209 */
{3.3228191290223670e+00, 7.7469280990172251e-14,
	2.2204460492503131e-16, 3.9968028886505635e-14,
	1.1213252548714081e-13}, /* L210 */
{2.3815533356051382e+00, 5.5788706987414116e-14,
	2.2204460492503131e-16, -1.1213252548714081e-14,
	-1.6653345369377348e-15}, /* L211 */
{3.7193970138113874e+00, 8.7541085491693593e-14,
	2.2204460492503131e-16, 3.6193270602780103e-14,
	1.3544720900426910e-14}, /* L212 */
{2.9190591262752417e+00, 6.9028116556069108e-14,
	2.2204460492503131e-16, -2.6645352591003757e-15,
	7.1054273576010019e-15}, /* L213 */
{2.7885944305365191e+00, 6.6252558994506217e-14,
	2.2204460492503131e-16, 6.2172489379008766e-15,
	-8.9928064994637680e-15}, /* L214 */
{3.2233055503148913e+00, 7.6938455606523348e-14,
	2.2204460492503131e-16, 7.1276318180935050e-14,
	8.2156503822261584e-15}, /* L215 */
{2.0960971580864860e+00, 5.0265347439903962e-14,
	2.2204460492503131e-16, -4.8405723873656825e-14,
	1.3100631690576847e-14}, /* L216 */
{3.6682593670737966e+00, 8.8373752760162461e-14,
	2.2204460492503131e-16, -1.0820233597996776e-12,
	3.2818192607919627e-13}, /* L217 */
{2.3555409337051239e+00, 5.7009952314501788e-14,
	2.2204460492503131e-16, -9.0483176506950258e-14,
	-1.0935696792557792e-13}, /* L218 */
{2.7580334246836968e+00, 6.7057470687359455e-14,
	2.2204460492503131e-16, -8.4376949871511897e-15,
	-4.2188474935755949e-15}, /* L219 */
{2.5875399263489585e+00, 6.3199445676787036e-14,
	2.2204460492503131e-16, 4.4408920985006262e-15,
	-9.7699626167013776e-15}, /* L220 */
{2.6776431266172818e+00, 6.5697447482193638e-14,
	2.2204460492503131e-16, -4.1078251911130792e-15,
	-3.0975222387041867e-14}, /* L221 */
{2.9465544750369372e+00, 7.2622463598293052e-14,
	2.2204460492503131e-16, 2.6645352591003757e-15,
	1.8873791418627661e-14}, /* L222 */
{2.9103588088650989e+00, 7.2053474298172659e-14,
	2.2204460492503131e-16, 8.0380146982861334e-14,
	-1.0491607582707729e-13}, /* L223 */
{2.1942302860490086e+00, 5.4567461660326444e-14,
	2.2204460492503131e-16, -1.2543299732215019e-12,
	-2.3796520309815605e-12}, /* L224 */
{2.9328230319262962e+00, 7.3260841837452517e-14,
	2.2204460492503131e-16, 5.5733195836182858e-14,
	3.3306690738754696e-15}, /* L225 */
{2.4845516115510300e+00, 6.2339022832702540e-14,
	2.2204460492503131e-16, -1.7541523789077473e-14,
	-2.4313884239290928e-14}, /* L226 */
{2.8414535359253952e+00, 7.1609385088322597e-14,
	2.2204460492503131e-16, 4.5297099404706387e-14,
	-9.8365759981788869e-14}, /* L227 */
{2.1601210504727981e+00, 5.4678483962788960e-14,
	2.2204460492503131e-16, 3.8413716652030416e-14,
	2.5757174171303632e-14}, /* L228 */
{3.1812717951789433e+00, 8.0879747343942654e-14,
	2.2204460492503131e-16, -1.7047474543119279e-12,
	6.3793414994961495e-13}, /* L229 */
{3.1060261875834261e+00, 7.9311557321659620e-14,
	2.2204460492503131e-16, 3.7303493627405260e-14,
	5.1070259132757201e-14}, /* L230 */
{2.8831613709740678e+00, 7.3940853440035426e-14,
	2.2204460492503131e-16, -2.7533531010703882e-14,
	-1.0769163338864018e-14}, /* L231 */
{2.5205130300389698e+00, 6.4920291364956029e-14,
	2.2204460492503131e-16, 6.3948846218409017e-14,
	2.5757174171303632e-14}, /* L232 */
{4.5757143811716361e+00, 1.1836365221284950e-13,
	2.2204460492503131e-16, -1.8651746813702630e-14,
	1.3766765505351941e-14}, /* L233 */
{2.3782418250352051e+00, 6.1783911320389961e-14,
	2.2204460492503131e-16, 6.4837024638109142e-14,
	-8.7707618945387367e-15}, /* L234 */
{2.6340831977140020e+00, 6.8722805224297190e-14,
	2.2204460492503131e-16, -5.1736392947532295e-14,
	-1.9428902930940239e-14}, /* L235 */
{2.4438936420564654e+00, 6.4032112945255903e-14,
	2.2204460492503131e-16, -4.3298697960381105e-15,
	-1.0769163338864018e-14}, /* L236 */
{3.6435161359218013e+00, 9.5867758176382267e-14,
	2.2204460492503131e-16, 8.8817841970012523e-15,
	2.6645352591003757e-14}, /* L237 */
{3.0378620009741142e+00, 8.0269124680398818e-14,
	2.2204460492503131e-16, 1.9317880628477724e-14,
	-1.4466206010865790e-13}, /* L238 */
{3.6726508121238957e+00, 9.7449825986473115e-14,
	2.2204460492503131e-16, -1.4332979247910771e-13,
	2.7533531010703882e-14}, /* L239 */
{1.8989876351583057e+00, 5.0598414347291509e-14,
	2.2204460492503131e-16, 4.6629367034256575e-15,
	7.3052675020335300e-14}, /* L240 */
{3.4689331945027613e+00, 9.2814644858663087e-14,
	2.2204460492503131e-16, 8.8373752760162461e-14,
	-7.7937656328685989e-14}, /* L241 */
{3.7774343197562574e+00, 1.0148826223854712e-13,
	2.2204460492503131e-16, -1.3256062914024369e-13,
	-2.0405899192610377e-13}, /* L242 */
{2.6003487659619116e+00, 7.0152217368502079e-14,
	2.2204460492503131e-16, -1.6106005418237146e-12,
	-5.1847415249994810e-13}, /* L243 */
{2.8709459387145744e+00, 7.7771122874992216e-14,
	2.2204460492503131e-16, -1.3655743202889425e-14,
	1.1324274851176597e-14}, /* L244 */
{3.5551568977225330e+00, 9.6700425444851135e-14,
	2.2204460492503131e-16, -4.0634162701280729e-14,
	1.0658141036401503e-14}, /* L245 */
{4.1484379951128876e+00, 1.1329825966299722e-13,
	2.2204460492503131e-16, -8.7707618945387367e-15,
	-5.9952043329758453e-15}, /* L246 */
{3.4089594836366168e+00, 9.3480778673438181e-14,
	2.2204460492503131e-16, 7.2830630415410269e-14,
	6.8611782921834674e-14}, /* L247 */
{2.5645557007292012e+00, 7.0610184366159956e-14,
	2.2204460492503131e-16, -4.0634162701280729e-14,
	-7.2053474298172659e-14}, /* L248 */
{3.0582801217071753e+00, 8.4543483325205671e-14,
	2.2204460492503131e-16, -1.6764367671839864e-14,
	-3.0864200084579352e-14}, /* L249 */
{2.9685458053592919e+00, 8.2392426214994430e-14,
	2.2204460492503131e-16, -3.2196467714129540e-14,
	-1.9650947535865271e-14}, /* L250 */
{3.6434825146120655e+00, 1.0152989560197057e-13,
	2.2204460492503131e-16, 1.7097434579227411e-14,
	1.5543122344752192e-14}, /* L251 */
{3.0139353946202108e+00, 8.4321438720280639e-14,
	2.2204460492503131e-16, -2.0539125955565396e-14,
	-1.5543122344752192e-15}, /* L252 */
{2.8508345028798892e+00, 8.0074835651089415e-14,
	2.2204460492503131e-16, 3.7747582837255322e-15,
	1.1168843627729075e-13}, /* L253 */
{3.5039910752784365e+00, 9.8809849191638932e-14,
	2.2204460492503131e-16, 7.1276318180935050e-14,
	2.0805579481475434e-13}, /* L254 */
{3.7103513692402537e+00, 1.0504097591734762e-13,
	2.2204460492503131e-16, -7.5495165674510645e-15,
	-3.1530333899354446e-14}, /* L255 */
{2.7695739851769900e+00, 7.8714812445923599e-14,
	2.2204460492503131e-16, 5.1070259132757201e-15,
	2.5091040356528538e-14}, /* L256 */
{2.7724163198841438e+00, 7.9103390504542404e-14,
	2.2204460492503131e-16, 3.5305092183079978e-14,
	4.8472337255134335e-13}, /* L257 */
{3.4535416610520864e+00, 9.8920871494101448e-14,
	2.2204460492503131e-16, 5.8397731095283234e-14,
	-7.6827433304060833e-14}, /* L258 */
{3.4247632696123702e+00, 9.8476782284251385e-14,
	2.2204460492503131e-16, 2.7533531010703882e-14,
	-1.0436096431476471e-14}, /* L259 */
{3.3260128596208705e+00, 9.6006536054460412e-14,
	2.2204460492503131e-16, 1.7541523789077473e-14,
	-4.4408920985006262e-15}, /* L260 */
{2.8237983611406752e+00, 8.1823436914874037e-14,
	2.2204460492503131e-16, 1.6808776592824870e-13,
	2.5224267119483557e-13}, /* L261 */
{4.2243018231877070e+00, 1.2287393325038920e-13,
	2.2204460492503131e-16, -4.5319303865198890e-13,
	4.6185277824406512e-14}, /* L262 */
{3.7614648843931424e+00, 1.0982881271104361e-13,
	2.2204460492503131e-16, -8.8706819667550008e-14,
	8.9483975784787617e-14}, /* L263 */
{3.6742991195406893e+00, 1.0769163338864018e-13,
	2.2204460492503131e-16, -3.7525538232330291e-14,
	-1.4421797089880783e-13}, /* L264 */
{2.4547548585763428e+00, 7.2220007751866433e-14,
	2.2204460492503131e-16, -3.3417713041217212e-14,
	1.3766765505351941e-14}, /* L265 */
{3.4323837895558738e+00, 1.0136336214827679e-13,
	2.2204460492503131e-16, 4.4408920985006262e-15,
	1.0436096431476471e-14}, /* L266 */
{4.5820873225291354e+00, 1.3582451136029405e-13,
	2.2204460492503131e-16, -3.6604053121891411e-13,
	-1.2834178164666810e-13}, /* L267 */
{3.3554622233318105e+00, 9.9836805489417202e-14,
	2.2204460492503131e-16, 1.3322676295501878e-15,
	-4.6629367034256575e-15}, /* L268 */
{4.7514673683025359e+00, 1.4190038033490282e-13,
	2.2204460492503131e-16, -4.3187675657918589e-14,
	1.9539925233402755e-14}, /* L269 */
{2.7208753170784687e+00, 8.1559758946525562e-14,
	2.2204460492503131e-16, -1.3988810110276972e-13,
	-3.3084646133829665e-14}, /* L270 */
{2.5424746553354858e+00, 7.6494366396673286e-14,
	2.2204460492503131e-16, 8.3266726846886741e-14,
	2.7533531010703882e-14}, /* L271 */
{3.1691665480432216e+00, 9.5701224722688494e-14,
	2.2204460492503131e-16, -6.3282712403633923e-15,
	-5.9952043329758453e-15}, /* L272 */
{2.4157881919303112e+00, 7.3219208474029074e-14,
	2.2204460492503131e-16, -5.5511151231257827e-15,
	4.6629367034256575e-15}, /* L273 */
{2.3774317573231869e+00, 7.2320621713473088e-14,
	2.2204460492503131e-16, 1.3544720900426910e-14,
	-4.2521541843143495e-14}, /* L274 */
{3.5182361053915550e+00, 1.0741407763248390e-13,
	2.2204460492503131e-16, 2.2204460492503131e-15,
	-1.0769163338864018e-14}, /* L275 */
{4.6303930060224348e+00, 1.4188303310014305e-13,
	2.2204460492503131e-16, -5.7953641885433171e-14,
	-3.4416913763379853e-15}, /* L276 */
{2.9801903893660504e+00, 9.1648910682806672e-14,
	2.2204460492503131e-16, 5.2358117841322382e-13,
	-5.2358117841322382e-13}, /* L277 */
{2.8426697623415151e+00, 8.7735374521002996e-14,
	2.2204460492503131e-16, -1.1590728377086634e-13,
	2.3914203950425872e-13}, /* L278 */
{2.7007585192167123e+00, 8.3655304905505545e-14,
	2.2204460492503131e-16, 1.1546319456101628e-14,
	5.9952043329758453e-15}, /* L279 */
{3.6232701936242320e+00, 1.1263212584822213e-13,
	2.2204460492503131e-16, -2.0317081350640365e-14,
	2.6201263381153694e-14}, /* L280 */
{3.9715915317002000e+00, 1.2390088954816747e-13,
	2.2204460492503131e-16, -8.5709217501062085e-14,
	3.8635761256955448e-14}, /* L281 */
{3.1046578346778073e+00, 9.7200025805932455e-14,
	2.2204460492503131e-16, 6.4392935428259079e-15,
	3.8635761256955448e-14}, /* L282 */
{4.2739175376500977e+00, 1.3428147482841268e-13,
	2.2204460492503131e-16, 4.6629367034256575e-14,
	2.5734969710811129e-13}, /* L283 */
{3.0194127874311874e+00, 9.5201624361607173e-14,
	2.2204460492503131e-16, -7.9602990865623724e-14,
	-8.8817841970012523e-14}, /* L284 */
{4.0581766537067780e+00, 1.2840423169180326e-13,
	2.2204460492503131e-16, 5.7731597280508140e-15,
	-2.5868196473766147e-14}, /* L285 */
{3.0044169882305920e+00, 9.5395913390916576e-14,
	2.2204460492503131e-16, 7.9936057773011271e-15,
	-9.5146113210375916e-14}, /* L286 */
{3.3942025257813597e+00, 1.0814916670542907e-13,
	2.2204460492503131e-16, -2.7311486405778851e-14,
	-3.5527136788005009e-15}, /* L287 */
{4.4097902663208837e+00, 1.4099832412739488e-13,
	2.2204460492503131e-16, 3.3084646133829665e-14,
	4.9737991503207013e-14}, /* L288 */
{4.7215261414547980e+00, 1.5148993171010261e-13,
	2.2204460492503131e-16, 6.4392935428259079e-15,
	-4.0856207306205761e-14}, /* L289 */
{3.8884220682309247e+00, 1.2519152381429421e-13,
	2.2204460492503131e-16, -1.2190248810384219e-13,
	-7.7160500211448380e-14}, /* L290 */
{3.6078735397519277e+00, 1.1655953979783362e-13,
	2.2204460492503131e-16, 8.4154905266586866e-14,
	1.0613732115416497e-13}, /* L291 */
{3.9452663558388266e+00, 1.2789769243681803e-13,
	2.2204460492503131e-16, -2.6090241078691179e-14,
	-6.3504757008558954e-14}, /* L292 */
{3.1502192570873455e+00, 1.0247358517290195e-13,
	2.2204460492503131e-16, 2.1982415887578100e-14,
	1.1546319456101628e-14}, /* L293 */
{2.9894168757036095e+00, 9.7574726076743445e-14,
	2.2204460492503131e-16, 4.0412118096355698e-14,
	-1.1257661469699087e-13}, /* L294 */
{3.6522809318134999e+00, 1.1961612256250476e-13,
	2.2204460492503131e-16, -2.6134649999676185e-13,
	-8.1834539145120289e-13}, /* L295 */
{5.0304830269400362e+00, 1.6531220836668581e-13,
	2.2204460492503131e-16, -7.7715611723760958e-15,
	-6.5059069243034173e-14}, /* L296 */
{3.0867479659462744e+00, 1.0177969578251123e-13,
	2.2204460492503131e-16, 2.1094237467877974e-14,
	2.5535129566378600e-14}, /* L297 */
{3.3540785998572855e+00, 1.1096679131128440e-13,
	2.2204460492503131e-16, 4.0412118096355698e-14,
	2.2470914018413168e-13}, /* L298 */
{2.9599118928713040e+00, 9.8254737679326354e-14,
	2.2204460492503131e-16, -6.4392935428259079e-15,
	-7.2608585810485238e-14}, /* L299 */
{3.0029630030907555e+00, 1.0001721673091879e-13,
	2.2204460492503131e-16, 1.1612932837579137e-13,
	-1.6187051699034782e-13}, /* L300 */
{3.4136739362492530e+00, 1.1407541578023483e-13,
	2.2204460492503131e-16, 5.9507954119908391e-14,
	8.4376949871511897e-15}, /* L301 */
{3.9814356066693390e+00, 1.3349044092336726e-13,
	2.2204460492503131e-16, 1.0658141036401503e-13,
	-1.9650947535865271e-13}, /* L302 */
{3.3144075777310089e+00, 1.1149414724798135e-13,
	2.2204460492503131e-16, -5.3290705182007514e-15,
	-1.8873791418627661e-15}, /* L303 */
{3.0263624869579915e+00, 1.0214051826551440e-13,
	2.2204460492503131e-16, -1.5876189252139739e-14,
	1.7097434579227411e-14}, /* L304 */
{3.5578417835804412e+00, 1.2047307595963730e-13,
	2.2204460492503131e-16, -7.2164496600635175e-14,
	-1.0769163338864018e-14}, /* L305 */
{5.4298223455037480e+00, 1.8446355554146976e-13,
	2.2204460492503131e-16, 1.0522693827397234e-12,
	1.7725820811165249e-12}, /* L306 */
{5.3469880427403993e+00, 1.8224310949221945e-13,
	2.2204460492503131e-16, 2.1094237467877974e-14,
	-1.4432899320127035e-15}, /* L307 */
{4.2167858452168305e+00, 1.4419021532319221e-13,
	2.2204460492503131e-16, -7.0721206668622472e-14,
	5.5733195836182858e-14}, /* L308 */
{3.1052259078928750e+00, 1.0652589921278377e-13,
	2.2204460492503131e-16, -4.6518344731794059e-14,
	9.1038288019262836e-15}, /* L309 */
{3.3726326856745681e+00, 1.1607381722456012e-13,
	2.2204460492503131e-16, 1.3766765505351941e-13,
	6.6613381477509392e-15}, /* L310 */
{2.6961830818381491e+00, 9.3092200614819376e-14,
	2.2204460492503131e-16, -5.7731597280508140e-15,
	1.2434497875801753e-14}, /* L311 */
{3.7308267983019232e+00, 1.2922996006636822e-13,
	2.2204460492503131e-16, 2.7489122089718876e-13,
	2.6645352591003757e-14}, /* L312 */
{3.5479780688186380e+00, 1.2329026688462363e-13,
	2.2204460492503131e-16, 1.9984014443252818e-14,
	2.7977620220553945e-14}, /* L313 */
{4.0446483971361076e+00, 1.4099832412739488e-13,
	2.2204460492503131e-16, -4.1522341120980855e-14,
	2.5535129566378600e-14}, /* L314 */
{2.7778206402022638e+00, 9.7144514654701197e-14,
	2.2204460492503131e-16, -5.6066262743570405e-14,
	1.0769163338864018e-13}, /* L315 */
{4.3133576953628561e+00, 1.5132339825640884e-13,
	2.2204460492503131e-16, 1.6209256159527285e-14,
	-8.0713213890248880e-14}, /* L316 */
{4.4038534414522656e+00, 1.5498713423767185e-13,
	2.2204460492503131e-16, 2.3980817331903381e-14,
	1.4432899320127035e-14}, /* L317 */
{2.8145088373375091e+00, 9.9364960703951510e-14,
	2.2204460492503131e-16, 5.9063864910058328e-14,
	-5.9729998724833422e-14}, /* L318 */
{5.7077683229894216e+00, 2.0214385720862538e-13,
	2.2204460492503131e-16, -2.2870594307278225e-14,
	1.0125233984581428e-13}, /* L319 */
{4.0860005479482222e+00, 1.4516166046973922e-13,
	2.2204460492503131e-16, 3.8191672047105385e-14,
	-4.5630166312093934e-14}, /* L320 */
{3.0191275827323305e+00, 1.0759448887398548e-13,
	2.2204460492503131e-16, 1.8829382497642655e-13,
	-6.3171690101171407e-14}, /* L321 */
{3.7190014844450761e+00, 1.3294920719886250e-13,
	2.2204460492503131e-16, -9.2481577951275540e-14,
	-3.7636560534792807e-14}, /* L322 */
{3.3913061986195414e+00, 1.2161105455987808e-13,
	2.2204460492503131e-16, 2.2204460492503131e-16,
	-9.7699626167013776e-15}, /* L323 */
{4.4475994916922552e+00, 1.5998313784848506e-13,
	2.2204460492503131e-16, -4.0323300254385686e-13,
	-7.1720407390785113e-14}, /* L324 */
{4.2662196749257140e+00, 1.5393242236427795e-13,
	2.2204460492503131e-16, -7.5495165674510645e-15,
	4.8849813083506888e-15}, /* L325 */
{3.2316449570651087e+00, 1.1696199564426024e-13,
	2.2204460492503131e-16, 3.7525538232330291e-14,
	-4.5741188614556449e-14}, /* L326 */
{4.6621514487953313e+00, 1.6925350010410511e-13,
	2.2204460492503131e-16, 8.4821039081361960e-14,
	-4.2410519540680980e-14}, /* L327 */
{3.3304629751890991e+00, 1.2127798765249054e-13,
	2.2204460492503131e-16, -4.0378811405616943e-13,
	-1.1607381722456012e-12}, /* L328 */
{2.8967012317313565e+00, 1.0580425424677742e-13,
	2.2204460492503131e-16, -1.4244161405940758e-13,
	1.5476508963274682e-13}, /* L329 */
{4.0894570406766118e+00, 1.4982459717316488e-13,
	2.2204460492503131e-16, 1.1368683772161603e-13,
	-3.3084646133829665e-14}, /* L330 */
{3.2009557359092833e+00, 1.1762812945903534e-13,
	2.2204460492503131e-16, -2.7533531010703882e-14,
	-6.5392136150421720e-14}, /* L331 */
{4.4902801294500705e+00, 1.6550649739599521e-13,
	2.2204460492503131e-16, 1.5254464358349651e-13,
	2.9309887850104133e-14}, /* L332 */
{2.9865325693813820e+00, 1.1041167979897182e-13,
	2.2204460492503131e-16, -3.5083047578154947e-13,
	-8.6930462828149757e-13}, /* L333 */
{4.7130218248238247e+00, 1.7476298186380745e-13,
	2.2204460492503131e-16, 5.4223292522692645e-13,
	1.1146639167236572e-13}, /* L334 */
{3.7381173815213637e+00, 1.3902767825868523e-13,
	2.2204460492503131e-16, -7.2164496600635175e-14,
	-4.1411318818518339e-14}, /* L335 */
{4.5045337917289521e+00, 1.6803225477701744e-13,
	2.2204460492503131e-16, 5.7509552675583109e-14,
	-1.4210854715202004e-14}, /* L336 */
{4.2938348008720153e+00, 1.6064927166326015e-13,
	2.2204460492503131e-16, -1.3689049893628180e-13,
	1.7474910407599964e-13}, /* L337 */
{4.6775869691651835e+00, 1.7552626019323725e-13,
	2.2204460492503131e-16, -3.1752378504279477e-14,
	9.7699626167013776e-15}, /* L338 */
{3.3379939839066104e+00, 1.2562867413024037e-13,
	2.2204460492503131e-16, -2.7755575615628914e-14,
	-1.1057821325266559e-13}, /* L339 */
{5.6964114263622720e+00, 2.1502244429427719e-13,
	2.2204460492503131e-16, 6.1239902038323635e-13,
	9.1771035215515440e-13}, /* L340 */
{3.9256470839204907e+00, 1.4861722963388502e-13,
	2.2204460492503131e-16, -1.8873791418627661e-15,
	3.3528735343679728e-14}, /* L341 */
{5.1769804668198951e+00, 1.9656498650988397e-13,
	2.2204460492503131e-16, 3.9079850466805510e-14,
	1.0458300891968975e-13}, /* L342 */
{3.5292089754715232e+00, 1.3439249713087520e-13,
	2.2204460492503131e-16, 3.6792791036077688e-13,
	1.2612133559741778e-13}, /* L343 */
{3.4157503802486002e+00, 1.3045120539345589e-13,
	2.2204460492503131e-16, -9.1260332624187868e-14,
	9.0816243414337805e-14}, /* L344 */
{4.8696403570859399e+00, 1.8651746813702630e-13,
	2.2204460492503131e-16, 4.8405723873656825e-14,
	-6.9166894434147252e-14}, /* L345 */
{2.8213043715378929e+00, 1.0837511443817505e-13,
	2.2204460492503131e-16, -1.5487611193520934e-13,
	-7.7826634026223473e-14}, /* L346 */
{5.0706834291562828e+00, 1.9534374118279629e-13,
	2.2204460492503131e-16, 1.9761969838327786e-14,
	1.4210854715202004e-14}, /* L347 */
{3.6239783326268262e+00, 1.4001300119304005e-13,
	2.2204460492503131e-16, -7.9825035470548755e-14,
	3.3995029014022293e-13}, /* L348 */
{4.6963475373777479e+00, 1.8196555373606316e-13,
	2.2204460492503131e-16, 6.1950444774083735e-14,
	-1.3156142841808105e-13}, /* L349 */
{5.3715114551115697e+00, 2.0872192862952943e-13,
	2.2204460492503131e-16, 1.1990408665951691e-14,
	1.3811174426336947e-13}, /* L350 */
{3.7322513217085089e+00, 1.4543921622589551e-13,
	2.2204460492503131e-16, -2.8310687127941492e-14,
	-1.3988810110276972e-14}, /* L351 */
{3.5980668826528035e+00, 1.4060974606877608e-13,
	2.2204460492503131e-16, 5.3956838996782608e-14,
	1.7430501486614958e-13}, /* L352 */
{3.8187558081509518e+00, 1.4965806371947110e-13,
	2.2204460492503131e-16, -8.3599793754274287e-14,
	-1.4632739464559563e-13}, /* L353 */
{6.0587093065147410e+00, 2.3811508320648045e-13,
	2.2204460492503131e-16, 3.2862601528904634e-14,
	3.6393110747212631e-13}, /* L354 */
{4.4620406813180411e+00, 1.7585932710062480e-13,
	2.2204460492503131e-16, 1.7652546091539989e-13,
	9.6478380839926103e-13}, /* L355 */
{3.1910604747652753e+00, 1.2612133559741778e-13,
	2.2204460492503131e-16, -3.5682568011452531e-13,
	-1.3866685577568205e-13}, /* L356 */
{4.3530083444119070e+00, 1.7252865802674933e-13,
	2.2204460492503131e-16, 3.1086244689504383e-14,
	-2.9642954757491680e-14}, /* L357 */
{4.7849900346372092e+00, 1.9018120411828932e-13,
	2.2204460492503131e-16, 6.6169292267659330e-14,
	9.2370555648813024e-14}, /* L358 */
{3.7688603828131426e+00, 1.5021317523178368e-13,
	2.2204460492503131e-16, -1.1624035067825389e-13,
	5.3290705182007514e-14}, /* L359 */
{4.6945168819418193e+00, 1.8762769116165146e-13,
	2.2204460492503131e-16, -5.4178883601707639e-14,
	6.1062266354383610e-14}, /* L360 */
{2.6511835676651687e+00, 1.0625528235053139e-13,
	2.2204460492503131e-16, 7.3274719625260332e-15,
	-1.5099033134902129e-14}, /* L361 */
{4.8964843936833926e+00, 1.9678703111480900e-13,
	2.2204460492503131e-16, -5.6621374255882984e-14,
	4.3298697960381105e-14}, /* L362 */
{3.6804975622908485e+00, 1.4832579608992091e-13,
	2.2204460492503131e-16, -1.0225154056797692e-13,
	-1.0691447727140257e-13}, /* L363 */
{5.2308499440104841e+00, 2.1138646388862981e-13,
	2.2204460492503131e-16, 1.6009416015094757e-13,
	-8.4710016778899444e-14}, /* L364 */
{4.2767783204610934e+00, 1.7330581414398694e-13,
	2.2204460492503131e-16, -5.9952043329758453e-15,
	1.6209256159527285e-14}, /* L365 */
{4.2213766122425591e+00, 1.7152945730458669e-13,
	2.2204460492503131e-16, 1.1324274851176597e-14,
	-2.0539125955565396e-14}, /* L366 */
{4.2003372917549333e+00, 1.7114087924596788e-13,
	2.2204460492503131e-16, -3.1086244689504383e-14,
	7.3718808835110394e-14}, /* L367 */
{5.7922089403616104e+00, 2.3664403769885212e-13,
	2.2204460492503131e-16, 3.1308289294429414e-14,
	1.0880185641326534e-14}, /* L368 */
{4.6443806069733284e+00, 1.9026447084513620e-13,
	2.2204460492503131e-16, 1.2878587085651816e-14,
	-3.5638159090467525e-14}, /* L369 */
{5.3000817815062176e+00, 2.1771473512899320e-13,
	2.2204460492503131e-16, -4.8405723873656825e-14,
	3.1752378504279477e-14}, /* L370 */
{4.5650973947024882e+00, 1.8803014700807807e-13,
	2.2204460492503131e-16, -5.6621374255882984e-15,
	5.9063864910058328e-14}, /* L371 */
{4.0864205813108372e+00, 1.6876777753083161e-13,
	2.2204460492503131e-16, 1.9984014443252818e-15,
	8.0380146982861334e-14}, /* L372 */
{4.9116039373335045e+00, 2.0339285811132868e-13,
	2.2204460492503131e-16, -9.5812247025151009e-14,
	-1.9595436384634013e-13}, /* L373 */
{5.2032888441009577e+00, 2.1604940059205546e-13,
	2.2204460492503131e-16, -1.7934542739794779e-12,
	-1.6749934772519737e-12}, /* L374 */
{6.0002592520761446e+00, 2.4980711943456413e-13,
	2.2204460492503131e-16, 2.8643754035329039e-14,
	-1.4832579608992091e-13}, /* L375 */
{4.7633713722794448e+00, 1.9884094371036554e-13,
	2.2204460492503131e-16, -1.5509815654013437e-13,
	-4.1078251911130792e-15}, /* L376 */
{4.9191740472453107e+00, 2.0589085991673528e-13,
	2.2204460492503131e-16, 7.0388139761234925e-14,
	6.5281113847959205e-14}, /* L377 */
{4.3334001987148589e+00, 1.8185453143360064e-13,
	2.2204460492503131e-16, -8.4487972173974413e-14,
	-7.6605388699135801e-15}, /* L378 */
{4.1319898789466052e+00, 1.7386092565629951e-13,
	2.2204460492503131e-16, -1.9317880628477724e-14,
	-3.4527936065842368e-14}, /* L379 */
{4.8658645551173834e+00, 2.0528023725319144e-13,
	2.2204460492503131e-16, 3.4861002973229915e-14,
	-3.3528735343679728e-14}, /* L380 */
{3.1640908174151492e+00, 1.3383738561856262e-13,
	2.2204460492503131e-16, 1.0880185641326534e-14,
	4.7073456244106637e-14}, /* L381 */
{5.2094916111467278e+00, 2.2093438190040615e-13,
	2.2204460492503131e-16, -3.4849900742983664e-13,
	5.9330318435968366e-13}, /* L382 */
{4.8571125680694385e+00, 2.0652923815589475e-13,
	2.2204460492503131e-16, 1.3811174426336947e-13,
	4.1522341120980855e-14}, /* L383 */
{5.5593168536130948e+00, 2.3700486018185529e-13,
	2.2204460492503131e-16, 4.4919623576333834e-13,
	3.2884805989397137e-13}, /* L384 */
{3.7409575826046662e+00, 1.5989987112163817e-13,
	2.2204460492503131e-16, -1.5321077739827160e-14,
	2.5313084961453569e-14}, /* L385 */
{4.5285561101606637e+00, 1.9406698470447736e-13,
	2.2204460492503131e-16, 5.7798210661985649e-13,
	7.5406347832540632e-13}, /* L386 */
{5.4286879397493903e+00, 2.3324397968593757e-13,
	2.2204460492503131e-16, 3.5527136788005009e-14,
	1.0658141036401503e-14}, /* L387 */
{4.4910375959579660e+00, 1.9345636204093353e-13,
	2.2204460492503131e-16, 3.1086244689504383e-15,
	-7.1609385088322597e-14}, /* L388 */
{4.7979413700944722e+00, 2.0720924975847765e-13,
	2.2204460492503131e-16, -4.1189274213593308e-14,
	1.6431300764452317e-14}, /* L389 */
{5.2205804916360297e+00, 2.2604140781368187e-13,
	2.2204460492503131e-16, -3.9968028886505635e-15,
	-3.2196467714129540e-14}, /* L390 */
{4.8414949823386939e+00, 2.1016521856154213e-13,
	2.2204460492503131e-16, 5.9729998724833422e-14,
	-3.3306690738754696e-16}, /* L391 */
{5.4956069504022071e+00, 2.3916979507987435e-13,
	2.2204460492503131e-16, 1.0347278589506459e-13,
	-3.4239278079439828e-13}, /* L392 */
{3.7468679067287445e+00, 1.6348034037605430e-13,
	2.2204460492503131e-16, 9.1038288019262836e-15,
	-1.3655743202889425e-14}, /* L393 */
{3.5317716684731328e+00, 1.5448753387659053e-13,
	2.2204460492503131e-16, -1.2634338020234281e-13,
	2.3536728122053319e-13}, /* L394 */
{4.7608212052214807e+00, 2.0877743978076069e-13,
	2.2204460492503131e-16, -9.4702024000525853e-14,
	1.5765166949677223e-14}, /* L395 */
{4.9634481764545315e+00, 2.1821433549007452e-13,
	2.2204460492503131e-16, 4.4098058538111218e-13,
	-4.6074255521943996e-13}, /* L396 */
{4.8993078391605653e+00, 2.1593837828959295e-13,
	2.2204460492503131e-16, -2.3536728122053319e-14,
	-3.1086244689504383e-15}, /* L397 */
{5.0666485903732950e+00, 2.2387647291566282e-13,
	2.2204460492503131e-16, -2.2204460492503131e-14,
	-2.6645352591003757e-14}, /* L398 */
{4.5288807601759888e+00, 2.0061730054976579e-13,
	2.2204460492503131e-16, -1.7796875084741259e-13,
	-3.1330493754921918e-13}, /* L399 */
{4.9313139215394433e+00, 2.1899149160731213e-13,
	2.2204460492503131e-16, -1.4210854715202004e-13,
	4.4408920985006262e-15}, /* L400 */
{4.1019858398085169e+00, 1.8261780976303044e-13,
	2.2204460492503131e-16, 1.8207657603852567e-14,
	1.4654943925052066e-14}, /* L401 */
{4.0112460251269297e+00, 1.7902346272080649e-13,
	2.2204460492503131e-16, -3.7414515929867775e-14,
	2.2204460492503131e-14}, /* L402 */
{5.1315625948111121e+00, 2.2959412149248237e-13,
	2.2204460492503131e-16, -4.9626969200744497e-14,
	-5.0737192225369654e-14}, /* L403 */
{5.5421320712865736e+00, 2.4857893521357255e-13,
	2.2204460492503131e-16, -2.1427304375265521e-14,
	-5.5511151231257827e-16}, /* L404 */
{4.9951093740107906e+00, 2.2459811788166917e-13,
	2.2204460492503131e-16, -1.5765166949677223e-14,
	-6.4392935428259079e-14}, /* L405 */
{4.3621105733038812e+00, 1.9662049766111522e-13,
	2.2204460492503131e-16, -5.4178883601707639e-14,
	-4.8516746176119341e-14}, /* L406 */
{4.5676111355117310e+00, 2.0639046027781660e-13,
	2.2204460492503131e-16, -5.1625370645069779e-14,
	-4.8738790781044372e-14}, /* L407 */
{4.0674407578674723e+00, 1.8424151093654473e-13,
	2.2204460492503131e-16, -5.6621374255882984e-15,
	-4.9149573300155680e-13}, /* L408 */
{4.2304804500375237e+00, 1.9209633883576771e-13,
	2.2204460492503131e-16, -1.3655743202889425e-13,
	6.7945649107059580e-14}, /* L409 */
{8.2086148828492433e+00, 3.7364555893759643e-13,
	2.2204460492503131e-16, -6.6613381477509392e-16,
	3.6859404417555197e-13}, /* L410 */
{3.8053890955786795e+00, 1.7363888105137448e-13,
	2.2204460492503131e-16, 1.0880185641326534e-14,
	2.7311486405778851e-14}, /* L411 */
{4.2900894645059333e+00, 1.9623191960249642e-13,
	2.2204460492503131e-16, 5.5511151231257827e-15,
	9.0372154204487742e-14}, /* L412 */
{5.8562907267800979e+00, 2.6852131629340192e-13,
	2.2204460492503131e-16, -3.3051339443090910e-13,
	1.7741363933510002e-13}, /* L413 */
{4.0072846000977922e+00, 1.8418599978531347e-13,
	2.2204460492503131e-16, 8.2600593032111647e-13,
	2.2892798767770728e-13}, /* L414 */
{5.2735442773577637e+00, 2.4297230893921551e-13,
	2.2204460492503131e-16, 3.6193270602780103e-14,
	-2.2759572004815709e-14}, /* L415 */
{4.2716753605568636e+00, 1.9728663147589032e-13,
	2.2204460492503131e-16, 2.7355895326763857e-13,
	-2.6090241078691179e-14}, /* L416 */
{3.1846826551209371e+00, 1.4743761767022079e-13,
	2.2204460492503131e-16, 2.0117241206207837e-13,
	-4.8361314952671819e-13}, /* L417 */
{3.3680793750683820e+00, 1.5630205463246227e-13,
	2.2204460492503131e-16, -1.6486811915683575e-13,
	-1.6875389974302379e-14}, /* L418 */
{4.8092642500287308e+00, 2.2371687835587295e-13,
	2.2204460492503131e-16, 4.5075054799781356e-14,
	8.7707618945387367e-14}, /* L419 */
{5.0256431749561346e+00, 2.3434032492275492e-13,
	2.2204460492503131e-16, 6.8167693711984612e-14,
	2.2870594307278225e-14}, /* L420 */
{4.5000429234481318e+00, 2.1033175201523591e-13,
	2.2204460492503131e-16, -6.8833827526759706e-15,
	-5.5511151231257827e-16}, /* L421 */
{4.9899765066075457e+00, 2.3378521341044234e-13,
	2.2204460492503131e-16, -8.1268325402561459e-14,
	4.1966430330830917e-14}, /* L422 */
{3.9233530255546833e+00, 1.8424844983044864e-13,
	2.2204460492503131e-16, 2.0028423364237824e-13,
	7.5273121069585613e-14}, /* L423 */
{3.8915465532951132e+00, 1.8318679906315083e-13,
	2.2204460492503131e-16, 2.5668356329333619e-13,
	1.3211653993039363e-13}, /* L424 */
{4.3556297812639952e+00, 2.0551615964592429e-13,
	2.2204460492503131e-16, 6.8167693711984612e-14,
	-3.6637359812630166e-15}, /* L425 */
{3.5933441340983956e+00, 1.6994738949449584e-13,
	2.2204460492503131e-16, -1.5876189252139739e-13,
	-2.1638246749944301e-13}, /* L426 */
{4.0533173509010618e+00, 1.9215184998699897e-13,
	2.2204460492503131e-16, 4.0634162701280729e-14,
	-9.8143715376863838e-14}, /* L427 */
{4.3081237447046146e+00, 2.0470951322959507e-13,
	2.2204460492503131e-16, 6.9277916736609768e-14,
	1.3322676295501878e-14}, /* L428 */
{5.5653211498038493e+00, 2.6506574712925612e-13,
	2.2204460492503131e-16, -6.8056671409522096e-13,
	-4.4853010194856324e-14}, /* L429 */
{5.4860988405239652e+00, 2.6190161150907443e-13,
	2.2204460492503131e-16, -4.4075854077618715e-14,
	2.5313084961453569e-14}, /* L430 */
{4.5354260915549709e+00, 2.1702084573860247e-13,
	2.2204460492503131e-16, -1.3579137814190290e-12,
	-1.3615775174002920e-12}, /* L431 */
{5.6563039523888659e+00, 2.7128299606715700e-13,
	2.2204460492503131e-16, 7.3718808835110394e-14,
	-1.5321077739827160e-14}, /* L432 */
{5.7564059464679751e+00, 2.7672308888782027e-13,
	2.2204460492503131e-16, 6.5503158452884236e-14,
	6.7501559897209518e-14}, /* L433 */
{5.5311587494793590e+00, 2.6650903706126883e-13,
	2.2204460492503131e-16, 5.1070259132757201e-14,
	3.5282887722587475e-13}, /* L434 */
{4.1632581018463695e+00, 2.0106138975961585e-13,
	2.2204460492503131e-16, -5.1181281435219717e-14,
	-1.9872992140790302e-14}, /* L435 */
{6.2942114131815954e+00, 3.0467295353275858e-13,
	2.2204460492503131e-16, 7.7426953737358417e-13,
	9.0816243414337805e-14}, /* L436 */
{4.8438677133003107e+00, 2.3500645873753001e-13,
	2.2204460492503131e-16, 4.6629367034256575e-15,
	-1.3899992268306960e-13}, /* L437 */
{4.9749332979158005e+00, 2.4191759706582161e-13,
	2.2204460492503131e-16, -5.8508753397745750e-14,
	1.3322676295501878e-15}, /* L438 */
{5.6669105455866235e+00, 2.7619573295112332e-13,
	2.2204460492503131e-16, 2.1982415887578100e-14,
	-8.2045481519799068e-14}, /* L439 */
{6.3009123736801484e+00, 3.0779545578951684e-13,
	2.2204460492503131e-16, -2.9676261448230434e-13,
	5.7509552675583109e-14}, /* L440 */
{5.6049287457955144e+00, 2.7441937611172307e-13,
	2.2204460492503131e-16, -3.8302694349567901e-14,
	-1.5909495942878493e-13}, /* L441 */
{5.2828558201362519e+00, 2.5923707624997405e-13,
	2.2204460492503131e-16, -7.9714013168086240e-14,
	9.3258734068513149e-15}, /* L442 */
{6.6118012153391872e+00, 3.2518432391270835e-13,
	2.2204460492503131e-16, 2.1982415887578100e-14,
	3.6637359812630166e-14}, /* L443 */
{4.9189658382309256e+00, 2.4247270857813419e-13,
	2.2204460492503131e-16, 2.3470114740575809e-13,
	-1.4133139103478243e-13}, /* L444 */
{4.6506061573407163e+00, 2.2976065494617615e-13,
	2.2204460492503131e-16, 5.2402526762307389e-14,
	1.0436096431476471e-14}, /* L445 */
{3.3778349099024871e+00, 1.6725509865977983e-13,
	2.2204460492503131e-16, 9.3258734068513149e-15,
	7.0832228971084987e-14}, /* L446 */
{5.5313726712515736e+00, 2.7450264283856995e-13,
	2.2204460492503131e-16, -4.2699177527083521e-13,
	2.6667557051496260e-13}, /* L447 */
{5.4732664922095164e+00, 2.7222668563808838e-13,
	2.2204460492503131e-16, -2.4091839634365897e-14,
	2.1316282072803006e-14}, /* L448 */
{5.0668634748051398e+00, 2.5257573810222311e-13,
	2.2204460492503131e-16, 5.5067062021407764e-14,
	5.0848214527832170e-14}, /* L449 */
{5.9967238661349125e+00, 2.9959368319509849e-13,
	2.2204460492503131e-16, -3.4972025275692431e-14,
	1.3034018309099338e-13}, /* L450 */
{3.8129521124572943e+00, 1.9091672687210348e-13,
	2.2204460492503131e-16, -1.2212453270876722e-14,
	1.2234657731369225e-13}, /* L451 */
{4.4636764261250086e+00, 2.2399443411202924e-13,
	2.2204460492503131e-16, -9.2481577951275540e-14,
	9.1704421834037930e-14}, /* L452 */
{4.2036824807332192e+00, 2.1141421946424543e-13,
	2.2204460492503131e-16, 2.8865798640254070e-15,
	-4.3853809472693683e-14}, /* L453 */
{6.6718698067170630e+00, 3.3628655415895992e-13,
	2.2204460492503131e-16, 1.0880185641326534e-14,
	2.2426505097428162e-14}, /* L454 */
{4.0637750258624035e+00, 2.0528023725319144e-13,
	2.2204460492503131e-16, 3.4194869158454821e-14,
	3.3750779948604759e-14}, /* L455 */
{3.7884133285779167e+00, 1.9179102750399579e-13,
	2.2204460492503131e-16, 2.8843594179761567e-13,
	3.9124259387790516e-13}, /* L456 */
{4.6225823855009853e+00, 2.3453461395206432e-13,
	2.2204460492503131e-16, -1.8873791418627661e-14,
	8.1046280797636427e-14}, /* L457 */
{5.1900058365034791e+00, 2.6390001295339971e-13,
	2.2204460492503131e-16, -2.6867397195928788e-14,
	-8.8817841970012523e-14}, /* L458 */
{6.9434213493214942e+00, 3.5382807794803739e-13,
	2.2204460492503131e-16, -2.2915003228263231e-13,
	-1.3777867735598193e-13}, /* L459 */
{3.7940579285718989e+00, 1.9376167337270545e-13,
	2.2204460492503131e-16, -3.6837199957062694e-13,
	-2.3603341503530828e-13}, /* L460 */
{4.2332290986304093e+00, 2.1666002325559930e-13,
	2.2204460492503131e-16, -4.1855408028368402e-14,
	-3.1530333899354446e-14}, /* L461 */
{4.6171977205768782e+00, 2.3682444894035370e-13,
	2.2204460492503131e-16, -6.7723604502134549e-15,
	-6.5059069243034173e-14}, /* L462 */
{4.9654901276721048e+00, 2.5524027336132349e-13,
	2.2204460492503131e-16, 6.6613381477509392e-14,
	-9.8809849191638932e-15}, /* L463 */
{4.8906716494417406e+00, 2.5193735986306365e-13,
	2.2204460492503131e-16, -3.0087043967341742e-14,
	6.8167693711984612e-14}, /* L464 */
{4.8204760874113477e+00, 2.4885649096972884e-13,
	2.2204460492503131e-16, 3.4638958368304884e-14,
	-5.5511151231257827e-16}, /* L465 */
{5.2001568975887578e+00, 2.6903479444229106e-13,
	2.2204460492503131e-16, -9.3591800975900696e-14,
	-6.0840221749458578e-14}, /* L466 */
{6.7655891585220527e+00, 3.5077496463031821e-13,
	2.2204460492503131e-16, -2.0428103653102880e-14,
	-5.9618976422370906e-14}, /* L467 */
{5.5897969077581431e+00, 2.9043434324194095e-13,
	2.2204460492503131e-16, 1.0325074129013956e-13,
	-5.5178084323870280e-14}, /* L468 */
{5.7207368697509278e+00, 2.9787283750692950e-13,
	2.2204460492503131e-16, 2.0849988402460440e-13,
	6.4170890823334048e-14}, /* L469 */
{5.2564331169633727e+00, 2.7428059823364492e-13,
	2.2204460492503131e-16, -7.5939254884360707e-14,
	-3.2196467714129540e-15}, /* L470 */
{5.1093905615339485e+00, 2.6717517087604392e-13,
	2.2204460492503131e-16, 3.2935876248529894e-12,
	-1.0899059432745162e-12}, /* L471 */
{5.2701773879834288e+00, 2.7616797737550769e-13,
	2.2204460492503131e-16, -5.5622173533720343e-14,
	-2.5424107263916085e-14}, /* L472 */
{4.9810200270811755e+00, 2.6156854460168688e-13,
	2.2204460492503131e-16, -3.8968828164342995e-14,
	3.9745984281580604e-14}, /* L473 */
{4.8505209500081383e+00, 2.5525415114913130e-13,
	2.2204460492503131e-16, 1.8740564655672642e-13,
	2.0450308113595383e-13}, /* L474 */
{4.2553037468947856e+00, 2.2440382885235977e-13,
	2.2204460492503131e-16, -8.3710816056736803e-14,
	3.6459724128690141e-13}, /* L475 */
{5.1856455764697369e+00, 2.7404120639396012e-13,
	2.2204460492503131e-16, -6.4703797875154123e-13,
	1.1279865930191590e-12}, /* L476 */
{5.5870553883009535e+00, 2.9587443606260422e-13,
	2.2204460492503131e-16, -3.4749980670767400e-14,
	1.0658141036401503e-14}, /* L477 */
{5.1114504289695146e+00, 2.7125524049154137e-13,
	2.2204460492503131e-16, -2.7977620220553945e-14,
	-5.0737192225369654e-14}, /* L478 */
{5.3048522702297776e+00, 2.8210767055725228e-13,
	2.2204460492503131e-16, -4.3631764867768652e-14,
	4.5963233219481481e-14}, /* L479 */
{6.1919861453015788e+00, 3.2997216070640434e-13,
	2.2204460492503131e-16, -6.5947247662734299e-14,
	1.2989609388114332e-13}, /* L480 */
{6.2217329423703367e+00, 3.3224811790688591e-13,
	2.2204460492503131e-16, 1.0644818360106001e-12,
	-1.3207213100940862e-12}, /* L481 */
{5.5176874849739708e+00, 2.9526381339906038e-13,
	2.2204460492503131e-16, 1.2212453270876722e-14,
	-8.9039886574937555e-14}, /* L482 */
{6.3540978753398916e+00, 3.4072744625746054e-13,
	2.2204460492503131e-16, -1.8851586958135158e-13,
	2.5979218776228663e-14}, /* L483 */
{5.9669990646989000e+00, 3.2063240951174521e-13,
	2.2204460492503131e-16, -5.5955240441107890e-14,
	-6.7612582199672033e-14}, /* L484 */
{6.3248025968725594e+00, 3.4056091280376677e-13,
	2.2204460492503131e-16, 9.5701224722688494e-14,
	-8.2933659939499194e-14}, /* L485 */
{9.0124316436680179e+00, 4.8627768478581856e-13,
	2.2204460492503131e-16, 1.1679546219056647e-13,
	-2.6645352591003757e-14}, /* L486 */
{4.4398524109244741e+00, 2.4005103460567057e-13,
	2.2204460492503131e-16, 3.4416913763379853e-14,
	-1.8318679906315083e-14}, /* L487 */
{6.9078527754736454e+00, 3.7425618160114027e-13,
	2.2204460492503131e-16, -2.4724666758402236e-13,
	1.8030021919912542e-13}, /* L488 */
{5.8029694617773471e+00, 3.1503966102519598e-13,
	2.2204460492503131e-16, 3.2374103398069565e-13,
	3.0064839506849239e-13}, /* L489 */
{4.6571872795048552e+00, 2.5335289421946072e-13,
	2.2204460492503131e-16, 2.3314683517128287e-14,
	4.4630965589931293e-14}, /* L490 */
{3.8371038098098209e+00, 2.0916601783937949e-13,
	2.2204460492503131e-16, -4.9960036108132044e-15,
	1.5765166949677223e-13}, /* L491 */
{6.6038485595349039e+00, 3.6071839959461727e-13,
	2.2204460492503131e-16, 6.0558225101203789e-12,
	-2.6111335316159057e-12}, /* L492 */
{4.1075680211209198e+00, 2.2482146352920118e-13,
	2.2204460492503131e-16, -1.2134737659152961e-13,
	1.1546319456101628e-14}, /* L493 */
{4.9261603482680760e+00, 2.7017277304253184e-13,
	2.2204460492503131e-16, 3.1485924978369439e-13,
	-3.6259883984257613e-13}, /* L494 */
{5.5310502324083082e+00, 3.0396171690760809e-13,
	2.2204460492503131e-16, -2.8754776337791554e-14,
	3.2640556923979602e-14}, /* L495 */
{6.5522298368457070e+00, 3.6080860521536806e-13,
	2.2204460492503131e-16, 8.8817841970012523e-15,
	-4.9960036108132044e-15}, /* L496 */
{6.8390994396592744e+00, 3.7736480607009071e-13,
	2.2204460492503131e-16, 1.5876189252139739e-13,
	3.0420110874729289e-14}, /* L497 */
{4.9247457696351562e+00, 2.7228219678931964e-13,
	2.2204460492503131e-16, 5.9063864910058328e-14,
	-6.6169292267659330e-14}, /* L498 */
{4.7209869146754633e+00, 2.6154078902607125e-13,
	2.2204460492503131e-16, -1.3877787807814457e-14,
	1.1590728377086634e-13}, /* L499 */
{5.7892739707168008e+00, 3.2136619754208340e-13,
	2.2204460492503131e-16, 7.0166095156309893e-14,
	-6.2949645496246376e-14}, /* L500 */
{5.5020484890138217e+00, 3.0603297673792440e-13,
	2.2204460492503131e-16, -5.2069459854919842e-14,
	2.4868995751603507e-14}, /* L501 */
{5.8988361462490460e+00, 3.2875785427322057e-13,
	2.2204460492503131e-16, 2.7977620220553945e-14,
	-2.0317081350640365e-14}, /* L502 */
{6.1342533422927366e+00, 3.4255931424809205e-13,
	2.2204460492503131e-16, 8.1912254756844050e-13,
	1.9917401061775308e-13}, /* L503 */
{6.8217416561632671e+00, 3.8170855365393663e-13,
	2.2204460492503131e-16, 2.2204460492503131e-15,
	-2.0761170560490427e-14}, /* L504 */
{6.3060007435503929e+00, 3.5355052219188110e-13,
	2.2204460492503131e-16, 1.1302070390684094e-13,
	-1.4832579608992091e-13}, /* L505 */
{4.9363119069119383e+00, 2.7730595597574847e-13,
	2.2204460492503131e-16, -1.3355982986240633e-13,
	-2.5757174171303632e-14}, /* L506 */
{4.5084256463924355e+00, 2.5376922785369516e-13,
	2.2204460492503131e-16, 1.6995294060961896e-12,
	8.0158102377936302e-13}, /* L507 */
{5.3937522354011946e+00, 3.0420110874729289e-13,
	2.2204460492503131e-16, 2.6842972289387035e-12,
	-4.7740700281906356e-12}, /* L508 */
{4.7888472499031858e+00, 2.7061686225238191e-13,
	2.2204460492503131e-16, -1.4110934642985740e-13,
	-2.5535129566378600e-15}, /* L509 */
{6.3466291644733062e+00, 3.5935143749554754e-13,
	2.2204460492503131e-16, 6.1506355564233672e-14,
	-3.8857805861880479e-15}, /* L510 */
{6.8581867472152114e+00, 3.8907765897988611e-13,
	2.2204460492503131e-16, 7.2386541205560206e-14,
	-1.1801670751765414e-13}, /* L511 */
{5.2642103686724546e+00, 2.9923286071209532e-13,
	2.2204460492503131e-16, -1.3322676295501878e-15,
	-1.7730261703263750e-13}, /* L512 */
{5.4827521020410099e+00, 3.1226410346363309e-13,
	2.2204460492503131e-16, 1.7319479184152442e-14,
	-1.8762769116165146e-14}, /* L513 */
{6.5788565264311503e+00, 3.7542191577699668e-13,
	2.2204460492503131e-16, 1.2145839889399213e-13,
	-9.2259533346350509e-14}, /* L514 */
{4.2888758606957653e+00, 2.4522051056408145e-13,
	2.2204460492503131e-16, -3.8080649744642869e-14,
	-6.4059868520871532e-14}, /* L515 */
{8.3050695275914741e+00, 4.7577219941530302e-13,
	2.2204460492503131e-16, 2.9531932455029164e-14,
	-1.2734258092450546e-13}, /* L516 */
{4.7814388783264699e+00, 2.7444713168733870e-13,
	2.2204460492503131e-16, -1.0025313912365164e-13,
	-2.2826185386293218e-13}, /* L517 */
{4.6327293168117691e+00, 2.6642577033442194e-13,
	2.2204460492503131e-16, -1.4555023852835802e-13,
	-2.9198865547641617e-14}, /* L518 */
{6.8887391921071686e+00, 3.9693248687910909e-13,
	2.2204460492503131e-16, 2.9531932455029164e-14,
	-1.0214051826551440e-13}, /* L519 */
{6.4177985869453060e+00, 3.7050917889303037e-13,
	2.2204460492503131e-16, 5.1736392947532295e-14,
	-2.8310687127941492e-14}, /* L520 */
{5.4712178450037579e+00, 3.1646907316940087e-13,
	2.2204460492503131e-16, -9.5112806519637161e-13,
	3.3328895199247199e-13}, /* L521 */
{7.2289386082106963e+00, 4.1894265834230282e-13,
	2.2204460492503131e-16, 9.3258734068513149e-15,
	1.3633538742396922e-13}, /* L522 */
{6.8948483541495440e+00, 4.0034642267983145e-13,
	2.2204460492503131e-16, 4.7517545453956700e-14,
	2.4713564528155985e-13}, /* L523 */
{8.5105096102962037e+00, 4.9510395783158856e-13,
	2.2204460492503131e-16, -1.6897594434794883e-13,
	2.4846791291111003e-13}, /* L524 */
{5.8285806243610949e+00, 3.3972824553529790e-13,
	2.2204460492503131e-16, 1.5254464358349651e-13,
	1.9917401061775308e-13}, /* L525 */
{6.4334702261777226e+00, 3.7569947153315297e-13,
	2.2204460492503131e-16, -1.0236256287043943e-13,
	-3.2418512319054571e-14}, /* L526 */
{5.7909246961506593e+00, 3.3881925043388605e-13,
	2.2204460492503131e-16, -1.8840484727888906e-13,
	-1.3022916078853086e-13}, /* L527 */
{7.1912992245498684e+00, 4.2155168245017194e-13,
	2.2204460492503131e-16, 1.2345680033831741e-13,
	7.5273121069585613e-14}, /* L528 */
{4.3331826398958366e+00, 2.5449087281970151e-13,
	2.2204460492503131e-16, 6.6613381477509392e-14,
	-5.9729998724833422e-14}, /* L529 */
{5.1434043411865540e+00, 3.0264679651281767e-13,
	2.2204460492503131e-16, 1.2601031329495527e-12,
	2.1544988015875788e-12}, /* L530 */
{6.6958674379409047e+00, 3.9473979640547441e-13,
	2.2204460492503131e-16, 1.1368683772161603e-13,
	1.0258460747536446e-13}, /* L531 */
{7.0921164524366826e+00, 4.1888714719107156e-13,
	2.2204460492503131e-16, -4.1411318818518339e-14,
	4.2632564145606011e-14}, /* L532 */
{4.9690509915795653e+00, 2.9404256807197271e-13,
	2.2204460492503131e-16, 1.0869305455685208e-11,
	3.4430236439675355e-12}, /* L533 */
{5.5978552737227307e+00, 3.3187341763607492e-13,
	2.2204460492503131e-16, -2.6423307986078726e-14,
	1.3677947663381929e-13}, /* L534 */
{5.9266448645163132e+00, 3.5202396553302151e-13,
	2.2204460492503131e-16, 7.7315931434895901e-13,
	-1.5853984791647235e-13}, /* L535 */
{5.8862616188863335e+00, 3.5027883371618884e-13,
	2.2204460492503131e-16, 3.8635761256955448e-14,
	-5.1070259132757201e-15}, /* L536 */
{6.9432139338060024e+00, 4.1394665473148962e-13,
	2.2204460492503131e-16, 2.7722268924890159e-12,
	-3.1881164375135995e-12}, /* L537 */
{5.3345809071128789e+00, 3.1863400806741993e-13,
	2.2204460492503131e-16, 4.4408920985006262e-14,
	-2.0983215165415459e-14}, /* L538 */
{7.4605869097678958e+00, 4.4644843377739107e-13,
	2.2204460492503131e-16, 1.2767564783189300e-13,
	3.2640556923979602e-14}, /* L539 */
{8.4264021832846634e+00, 5.0517923178006185e-13,
	2.2204460492503131e-16, 7.3940853440035426e-14,
	4.8183679268731794e-14}, /* L540 */
{5.1876237113525638e+00, 3.1158409186105018e-13,
	2.2204460492503131e-16, 3.3084646133829665e-14,
	-1.2589929099249275e-13}, /* L541 */
{6.5041615531723531e+00, 3.9138137175598331e-13,
	2.2204460492503131e-16, 9.9920072216264089e-14,
	-1.2434497875801753e-14}, /* L542 */
{5.5815005185295110e+00, 3.3648084318826932e-13,
	2.2204460492503131e-16, 8.2767126485805420e-12,
	-7.7062800585281366e-12}, /* L543 */
{6.3842012488641053e+00, 3.8558045645231687e-13,
	2.2204460492503131e-16, 8.4554585555451922e-13,
	-4.5818904226280210e-13}, /* L544 */
{6.9642311710030746e+00, 4.2138514899647816e-13,
	2.2204460492503131e-16, 2.7755575615628914e-14,
	-1.9551027463649007e-13}, /* L545 */
{4.6730842958359675e+00, 2.8327340473310869e-13,
	2.2204460492503131e-16, -1.4321877017664519e-14,
	-3.1641356201816961e-14}, /* L546 */
{6.2806314812076351e+00, 3.8141712010997253e-13,
	2.2204460492503131e-16, -1.3333778525748130e-13,
	-9.9920072216264089e-14}, /* L547 */
{6.0374182844022162e+00, 3.6731728769723304e-13,
	2.2204460492503131e-16, -1.3611334281904419e-13,
	5.6399329650957952e-14}, /* L548 */
{7.4435454413637387e+00, 4.5369263901307022e-13,
	2.2204460492503131e-16, 2.4069635173873394e-13,
	-3.5371705564557487e-13}, /* L549 */
{7.0254656295820750e+00, 4.2899017671516049e-13,
	2.2204460492503131e-16, -1.6320278461989801e-14,
	-5.0293103015519591e-14}, /* L550 */
{5.0218999376067579e+00, 3.0720564980768472e-13,
	2.2204460492503131e-16, 9.6367358537463588e-14,
	2.0206059048177849e-14}, /* L551 */
{6.2151366172536946e+00, 3.8088976417327558e-13,
	2.2204460492503131e-16, -2.3669954885008337e-13,
	5.0559556541429629e-13}, /* L552 */
{5.9792137733998993e+00, 3.6709524309230801e-13,
	2.2204460492503131e-16, 3.3373304120232206e-13,
	-3.7947422981687851e-13}, /* L553 */
{5.8835832897902849e+00, 3.6187719487656977e-13,
	2.2204460492503131e-16, 1.8540724511240114e-13,
	-9.7255536957163713e-14}, /* L554 */
{4.5477549227678544e+00, 2.8022029141538951e-13,
	2.2204460492503131e-16, 3.3328895199247199e-13,
	6.4881433559094148e-13}, /* L555 */
{5.2581018209224375e+00, 3.2457370124916451e-13,
	2.2204460492503131e-16, -3.1641356201816961e-13,
	3.8991032624835498e-13}, /* L556 */
{7.8831475360419123e+00, 4.8748852177205038e-13,
	2.2204460492503131e-16, -9.1815444136500446e-14,
	5.1292303737682232e-14}, /* L557 */
{6.2535940957303797e+00, 3.8741232444294837e-13,
	2.2204460492503131e-16, -1.2212453270876722e-14,
	2.0428103653102880e-14}, /* L558 */
{7.4561834989150277e+00, 4.6274095666376525e-13,
	2.2204460492503131e-16, -1.2789769243681803e-13,
	-7.8936857050848630e-14}, /* L559 */
{6.9267966427367798e+00, 4.3065551125209822e-13,
	2.2204460492503131e-16, -5.7454041524351851e-13,
	-8.8262730457699945e-14}, /* L560 */
{7.6889604375237930e+00, 4.7889470167206127e-13,
	2.2204460492503131e-16, 1.1102230246251565e-13,
	-7.0832228971084987e-14}, /* L561 */
{6.3067270320175890e+00, 3.9350467329057892e-13,
	2.2204460492503131e-16, 2.1493917756743031e-13,
	-2.9831692671677956e-13}, /* L562 */
{5.9396186072127941e+00, 3.7125857943465235e-13,
	2.2204460492503131e-16, 8.8595797365087492e-14,
	2.9753977059954195e-14}, /* L563 */
{7.4459337333154645e+00, 4.6623815919133449e-13,
	2.2204460492503131e-16, -4.3964831775156199e-14,
	-1.9573231924141510e-13}, /* L564 */
{5.6583606971428217e+00, 3.5493483152571059e-13,
	2.2204460492503131e-16, -2.4757973449140991e-13,
	-1.5842882561400984e-13}, /* L565 */
{5.4938249220385256e+00, 3.4522384950719243e-13,
	2.2204460492503131e-16, -1.2090328738167955e-13,
	-6.8656191842819680e-13}, /* L566 */
{5.5679100190972584e+00, 3.5049740887416192e-13,
	2.2204460492503131e-16, 1.2212453270876722e-14,
	-1.1535217225855376e-13}, /* L567 */
{6.6604418462553188e+00, 4.2001124800350453e-13,
	2.2204460492503131e-16, 3.7525538232330291e-14,
	5.7731597280508140e-15}, /* L568 */
{7.7029998507896273e+00, 4.8661075169320611e-13,
	2.2204460492503131e-16, 2.8976820942716586e-13,
	-1.5165646516379638e-13}, /* L569 */
{6.1710623677078509e+00, 3.9052094891189881e-13,
	2.2204460492503131e-16, 7.4829031859735551e-14,
	-8.3932860661661834e-14}, /* L570 */
{6.6033379137549346e+00, 4.1860959143491527e-13,
	2.2204460492503131e-16, 2.3536728122053319e-14,
	8.9261931179862586e-14}, /* L571 */
{6.4160940388013650e+00, 4.0745185003743245e-13,
	2.2204460492503131e-16, 1.6031620475587260e-13,
	3.4861002973229915e-14}, /* L572 */
{6.4315110196246650e+00, 4.0914494014998581e-13,
	2.2204460492503131e-16, -1.1948220191015935e-12,
	-1.4843681839238343e-13}, /* L573 */
{5.8811068396250015e+00, 3.7478353753783722e-13,
	2.2204460492503131e-16, 1.7519319328584970e-13,
	6.2128080458023760e-13}, /* L574 */
{6.8869673873563189e+00, 4.3964831775156199e-13,
	2.2204460492503131e-16, -5.6621374255882984e-14,
	1.8651746813702630e-14}, /* L575 */
{5.7395923887026035e+00, 3.6703973194107675e-13,
	2.2204460492503131e-16, 1.0125233984581428e-13,
	3.5327296643572481e-13}, /* L576 */
{6.0585017595773589e+00, 3.8810621383333910e-13,
	2.2204460492503131e-16, -3.8746783559417963e-13,
	-5.1936233091964823e-13}, /* L577 */
{7.9628153311243262e+00, 5.1098014708372830e-13,
	2.2204460492503131e-16, 1.2647660696529783e-12,
	8.2200912743246590e-13}, /* L578 */
{7.9179744956943621e+00, 5.0898174563940302e-13,
	2.2204460492503131e-16, 8.6597395920762210e-15,
	2.3692159345500841e-13}, /* L579 */
{5.4155257854927692e+00, 3.4872105203476167e-13,
	2.2204460492503131e-16, -3.5638159090467525e-14,
	-1.0358380819752711e-13}, /* L580 */
{6.5714389392331034e+00, 4.2388315080188477e-13,
	2.2204460492503131e-16, 1.2212453270876722e-14,
	-1.4654943925052066e-13}, /* L581 */
{7.0446846539679573e+00, 4.5519144009631418e-13,
	2.2204460492503131e-16, -1.4055423491754482e-13,
	-1.8096635301390052e-14}, /* L582 */
{8.1685377589147272e+00, 5.2871595990211517e-13,
	2.2204460492503131e-16, -2.5646151868841116e-14,
	1.5853984791647235e-13}, /* L583 */
{5.7825433697022914e+00, 3.7492231541591536e-13,
	2.2204460492503131e-16, -1.2035927809961322e-12,
	-2.0050627824730327e-12}, /* L584 */
{4.4923147798647536e+00, 2.9176661087149114e-13,
	2.2204460492503131e-16, 4.5075054799781356e-14,
	-1.2201351040630470e-13}, /* L585 */
{9.5806465147719351e+00, 6.2330696160017851e-13,
	2.2204460492503131e-16, 2.3092638912203256e-14,
	9.6145313932538556e-14}, /* L586 */
{5.7917467867396280e+00, 3.7744807279693759e-13,
	2.2204460492503131e-16, -2.1416202145019270e-13,
	1.5631940186722204e-13}, /* L587 */
{7.7670190568012538e+00, 5.0703885534630899e-13,
	2.2204460492503131e-16, -1.3988810110276972e-14,
	1.1213252548714081e-13}, /* L588 */
{6.6180070456913258e+00, 4.3276493499888602e-13,
	2.2204460492503131e-16, -4.7517545453956700e-14,
	1.4876988529977098e-14}, /* L589 */
{5.8936533662549415e+00, 3.8605230123778256e-13,
	2.2204460492503131e-16, -1.7674750552032492e-13,
	-7.5495165674510645e-14}, /* L590 */
{6.5023368239275117e+00, 4.2664483057563984e-13,
	2.2204460492503131e-16, -1.3700152123874432e-13,
	4.2410519540680980e-14}, /* L591 */
{7.3657210804103546e+00, 4.8411274988779951e-13,
	2.2204460492503131e-16, -7.1165295878472534e-14,
	5.5955240441107890e-14}, /* L592 */
{5.8473953974839548e+00, 3.8496983378877303e-13,
	2.2204460492503131e-16, -4.4519943287468777e-14,
	-7.4051875742497941e-14}, /* L593 */
{7.5475708304155198e+00, 4.9774073751507331e-13,
	2.2204460492503131e-16, 1.7075230118734908e-13,
	6.9722005946459831e-14}, /* L594 */
{6.8479099636569911e+00, 4.5236037138352003e-13,
	2.2204460492503131e-16, -3.3995029014022293e-13,
	-3.9956926656259384e-13}, /* L595 */
{5.9471570338771382e+00, 3.9351855107838674e-13,
	2.2204460492503131e-16, -1.0325074129013956e-13,
	2.0516921495072893e-13}, /* L596 */
{6.9899607768386414e+00, 4.6329606817607782e-13,
	2.2204460492503131e-16, -1.1151080059335072e-12,
	-4.2288395007972213e-13}, /* L597 */
{7.6521859859511645e+00, 5.0803805606847163e-13,
	2.2204460492503131e-16, 6.4392935428259079e-15,
	-1.0635936575909000e-13}, /* L598 */
{4.8539308634219367e+00, 3.2279734440976426e-13,
	2.2204460492503131e-16, -2.2204460492503131e-15,
	-1.8440804439023850e-13}, /* L599 */
{6.9264692609737128e+00, 4.6139481124640724e-13,
	2.2204460492503131e-16, 1.7873036384230545e-11,
	2.0410340084708878e-12}, /* L600 */
{6.9448944844606597e+00, 4.6339321269073253e-13,
	2.2204460492503131e-16, 6.0174087934683484e-14,
	-7.5273121069585613e-14}, /* L601 */
{6.5984323373027527e+00, 4.4100834095672781e-13,
	2.2204460492503131e-16, 3.5971225997855072e-14,
	-2.1560531138220540e-13}, /* L602 */
{6.5539075206510562e+00, 4.3876013933186186e-13,
	2.2204460492503131e-16, -4.2211789619273077e-12,
	9.6360697199315837e-12}, /* L603 */
{8.5554770741581159e+00, 5.7370774797504964e-13,
	2.2204460492503131e-16, 1.7259527140822684e-12,
	-1.0769163338864018e-13}, /* L604 */
{5.7181908398123387e+00, 3.8408165536907291e-13,
	2.2204460492503131e-16, -7.7715611723760958e-16,
	9.6811447747313650e-14}, /* L605 */
{6.1881285749276334e+00, 4.1633363423443370e-13,
	2.2204460492503131e-16, 5.0581761001922132e-13,
	-3.6792791036077688e-13}, /* L606 */
{7.7701934781960462e+00, 5.2363668956445508e-13,
	2.2204460492503131e-16, -2.0428103653102880e-14,
	-1.0247358517290195e-13}, /* L607 */
{9.2870212311462339e+00, 6.2688743085459464e-13,
	2.2204460492503131e-16, -1.7541523789077473e-14,
	6.4614980033184111e-14}, /* L608 */
{7.0045266504339452e+00, 4.7359338672947615e-13,
	2.2204460492503131e-16, -7.7271522513910895e-14,
	1.4810375148499588e-13}, /* L609 */
{6.8864862746946347e+00, 4.6637693706941263e-13,
	2.2204460492503131e-16, 2.1094237467877974e-14,
	8.3710816056736803e-14}, /* L610 */
{6.5570889049036882e+00, 4.4479697702826115e-13,
	2.2204460492503131e-16, 9.9920072216264089e-15,
	-2.1094237467877974e-15}, /* L611 */
{7.4926588800448579e+00, 5.0909276794186553e-13,
	2.2204460492503131e-16, -5.0626169922907138e-14,
	-2.3314683517128287e-15}, /* L612 */
{8.4049887907799796e+00, 5.7201465786249628e-13,
	2.2204460492503131e-16, 8.6708418223224726e-13,
	8.0380146982861334e-13}, /* L613 */
{6.2223225205847132e+00, 4.2416070655804106e-13,
	2.2204460492503131e-16, 8.2156503822261584e-15,
	-4.1078251911130792e-14}, /* L614 */
{7.6223697494439033e+00, 5.2044479836865776e-13,
	2.2204460492503131e-16, 8.9928064994637680e-14,
	-2.0872192862952943e-14}, /* L615 */
{5.7621844157121007e+00, 3.9407366259069931e-13,
	2.2204460492503131e-16, -3.8891112552619234e-13,
	-2.5746071941057380e-13}, /* L616 */
{6.0932024820087722e+00, 4.1738834610782760e-13,
	2.2204460492503131e-16, -1.8873791418627661e-14,
	-8.2045481519799068e-14}, /* L617 */
{7.5809181093252436e+00, 5.2013948703688584e-13,
	2.2204460492503131e-16, -2.2892798767770728e-13,
	2.7911006839076435e-13}, /* L618 */
{6.6635807876250439e+00, 4.5793924208226144e-13,
	2.2204460492503131e-16, 1.7419399256368706e-12,
	5.2522430848966906e-12}, /* L619 */
{6.7385186959113232e+00, 4.6383730190058259e-13,
	2.2204460492503131e-16, 1.0302869668521453e-12,
	1.1786127629420662e-12}, /* L620 */
{6.5620071323118818e+00, 4.5241588253475129e-13,
	2.2204460492503131e-16, -2.0705659409259169e-13,
	-2.1682655670929307e-13}, /* L621 */
{5.3135132050247753e+00, 3.6692870963861424e-13,
	2.2204460492503131e-16, 6.9314554096422398e-11,
	-6.0600968687651857e-11}, /* L622 */
{5.5999285782249046e+00, 3.8732905771610149e-13,
	2.2204460492503131e-16, -1.7030821197749901e-13,
	7.5495165674510645e-15}, /* L623 */
{4.8902320743279795e+00, 3.3878455596436652e-13,
	2.2204460492503131e-16, 3.2862601528904634e-14,
	1.4099832412739488e-13}, /* L624 */
{6.5156102797240916e+00, 4.5211057120297937e-13,
	2.2204460492503131e-16, -3.8857805861880479e-15,
	1.2234657731369225e-13}, /* L625 */
{8.2180640839079615e+00, 5.7115423501841178e-13,
	2.2204460492503131e-16, -1.7319479184152442e-14,
	3.1308289294429414e-14}, /* L626 */
{7.5602192643054202e+00, 5.2627346924793983e-13,
	2.2204460492503131e-16, -2.7877700148337681e-13,
	3.0841995624086849e-13}, /* L627 */
{7.8909360164571707e+00, 5.5017101985299632e-13,
	2.2204460492503131e-16, 4.7517545453956700e-14,
	5.1803006329009804e-13}, /* L628 */
{7.5056755937200688e+00, 5.2414322881944031e-13,
	2.2204460492503131e-16, 1.7807977314987511e-13,
	1.4654943925052066e-14}, /* L629 */
{7.2567574807621984e+00, 5.0756621128300594e-13,
	2.2204460492503131e-16, 6.3926641757916514e-13,
	5.6643578716375487e-13}, /* L630 */
{8.6093638207654113e+00, 6.0312865812761629e-13,
	2.2204460492503131e-16, -5.4323212594908910e-13,
	-2.6201263381153694e-14}, /* L631 */
{6.8758019872393783e+00, 4.8244741535086177e-13,
	2.2204460492503131e-16, -1.5332179970073412e-13,
	-6.5170091545496689e-14}, /* L632 */
{5.3499294516806719e+00, 3.7597702728930926e-13,
	2.2204460492503131e-16, -3.0531133177191805e-14,
	5.9952043329758453e-15}, /* L633 */
{6.2713032696641440e+00, 4.4142467459096224e-13,
	2.2204460492503131e-16, 3.9590553058133082e-13,
	2.8199664825478976e-13}, /* L634 */
{7.4657598102760137e+00, 5.2632898039917109e-13,
	2.2204460492503131e-16, -5.7176485768195562e-14,
	-3.9013237085328001e-13}, /* L635 */
{8.2287865675178953e+00, 5.8103521993757568e-13,
	2.2204460492503131e-16, 1.4965806371947110e-13,
	-5.6621374255882984e-14}, /* L636 */
{7.8453812945050334e+00, 5.5483395655642198e-13,
	2.2204460492503131e-16, -1.5387691121304670e-13,
	2.8843594179761567e-13}, /* L637 */
{6.7468758483234765e+00, 4.7789550094989863e-13,
	2.2204460492503131e-16, 7.7493567118835927e-13,
	2.9687363678476686e-13}, /* L638 */
{7.0438295794533934e+00, 4.9971138338378296e-13,
	2.2204460492503131e-16, 3.1086244689504383e-15,
	1.2989609388114332e-13}, /* L639 */
{6.9398546990561476e+00, 4.9310555638726328e-13,
	2.2204460492503131e-16, -2.5013324744804777e-13,
	-2.2637447472106942e-13}, /* L640 */
{5.4122550288131555e+00, 3.8516412281808243e-13,
	2.2204460492503131e-16, -8.2933659939499194e-14,
	-2.9976021664879227e-14}, /* L641 */
{8.7332692302498049e+00, 6.2247429433170964e-13,
	2.2204460492503131e-16, 2.1249668691325496e-13,
	4.7739590058881731e-13}, /* L642 */
{7.2620643345425373e+00, 5.1841864134871685e-13,
	2.2204460492503131e-16, 3.8591352335970441e-13,
	-1.5432100042289676e-13}, /* L643 */
{7.3070767458177572e+00, 5.2244319981298304e-13,
	2.2204460492503131e-16, 1.7497114868092467e-13,
	-5.0071058410594560e-14}, /* L644 */
{7.4806319572837952e+00, 5.3568260938163803e-13,
	2.2204460492503131e-16, -3.4039437935007300e-13,
	-2.8643754035329039e-13}, /* L645 */
{6.2929665848035894e+00, 4.5133341508574176e-13,
	2.2204460492503131e-16, -1.6875389974302379e-14,
	-1.6830981053317373e-13}, /* L646 */
{5.9259898363342520e+00, 4.2567165070561686e-13,
	2.2204460492503131e-16, 3.4661162828797387e-13,
	-3.5638159090467525e-13}, /* L647 */
{6.6527882739135373e+00, 4.7861714591590498e-13,
	2.2204460492503131e-16, 1.1945999744966684e-13,
	2.4713564528155985e-13}, /* L648 */
{8.0238955561162797e+00, 5.7814864007355027e-13,
	2.2204460492503131e-16, 4.0589753780295723e-13,
	2.7133850721838826e-13}, /* L649 */
{6.9677033006871492e+00, 5.0282000785273340e-13,
	2.2204460492503131e-16, -1.4488410471358293e-13,
	-1.7985612998927536e-14}, /* L650 */
{6.9262782087305421e+00, 5.0059956180348308e-13,
	2.2204460492503131e-16, -1.8551826741486366e-13,
	9.2570395793245552e-13}, /* L651 */
{8.2139700144438308e+00, 5.9457994083800259e-13,
	2.2204460492503131e-16, 8.0691009429756377e-13,
	5.8175686490358203e-14}, /* L652 */
{5.3422748910258617e+00, 3.8730130214048586e-13,
	2.2204460492503131e-16, 4.9293902293356950e-14,
	3.8191672047105385e-14}, /* L653 */
{6.8058211351445594e+00, 4.9416026826065718e-13,
	2.2204460492503131e-16, 1.3988810110276972e-13,
	1.9562129693895258e-13}, /* L654 */
{7.7958138262283141e+00, 5.6690763194922056e-13,
	2.2204460492503131e-16, 1.2101430968414206e-13,
	3.4416913763379853e-14}, /* L655 */
{8.7503949031183659e+00, 6.3729577171045548e-13,
	2.2204460492503131e-16, 2.3914203950425872e-13,
	-1.1923795284474181e-13}, /* L656 */
{7.7229954418550602e+00, 5.6332716269480443e-13,
	2.2204460492503131e-16, 8.8817841970012523e-16,
	4.8849813083506888e-14}, /* L657 */
{8.6652872275158312e+00, 6.3302141306564863e-13,
	2.2204460492503131e-16, -9.3147711766050634e-14,
	3.2640556923979602e-14}, /* L658 */
{7.9385557720600630e+00, 5.8081317533265064e-13,
	2.2204460492503131e-16, 6.6391336872584361e-14,
	-2.1427304375265521e-14}, /* L659 */
{7.3109963830930464e+00, 5.3571036495725366e-13,
	2.2204460492503131e-16, -2.9043434324194095e-13,
	1.8718360195180139e-13}, /* L660 */
{8.0658221052291790e+00, 5.9191540557890221e-13,
	2.2204460492503131e-16, 9.4368957093138306e-14,
	1.2034817586936697e-13}, /* L661 */
{5.6102807546998825e+00, 4.1233683134578314e-13,
	2.2204460492503131e-16, -2.9842794901924208e-13,
	-1.3267165144270621e-13}, /* L662 */
{8.5460164997008707e+00, 6.2905236575261370e-13,
	2.2204460492503131e-16, -8.6153306710912148e-14,
	-1.7419399256368706e-13}, /* L663 */
{7.0519689572647968e+00, 5.1986193128072955e-13,
	2.2204460492503131e-16, -6.7501559897209518e-14,
	-5.8841820305133297e-14}, /* L664 */
{7.3473800130659486e+00, 5.4245496983185149e-13,
	2.2204460492503131e-16, 8.1490370007486490e-14,
	1.2012613126444194e-13}, /* L665 */
{7.6713709620328210e+00, 5.6722682106880029e-13,
	2.2204460492503131e-16, -1.1224354778960333e-13,
	-2.6512125828048738e-13}, /* L666 */
{6.9837066704182948e+00, 5.1715576265820573e-13,
	2.2204460492503131e-16, -1.1901590823981678e-13,
	-4.1633363423443370e-14}, /* L667 */
{8.3024083082129501e+00, 6.1572968945711182e-13,
	2.2204460492503131e-16, -3.9745984281580604e-13,
	5.7052140789437544e-12}, /* L668 */
{5.3723926315160702e+00, 3.9902803283808908e-13,
	2.2204460492503131e-16, -3.6359804056473877e-13,
	-9.2148511043887993e-15}, /* L669 */
{5.3380681233959875e+00, 3.9707126475718724e-13,
	2.2204460492503131e-16, 1.3566925360919413e-13,
	4.6229686745391518e-13}, /* L670 */
{7.1229620574884223e+00, 5.3063109461959357e-13,
	2.2204460492503131e-16, 3.6615155352137663e-13,
	-3.5784708529718046e-12}, /* L671 */
{6.5625103537142628e+00, 4.8960835385969403e-13,
	2.2204460492503131e-16, 3.9235281690253032e-13,
	1.7386092565629951e-13}, /* L672 */
{9.3764078095649097e+00, 7.0058542300799331e-13,
	2.2204460492503131e-16, -1.2323475573339238e-14,
	-1.4088730182493236e-13}, /* L673 */
{8.3479360192574035e+00, 6.2466698480534433e-13,
	2.2204460492503131e-16, 3.2462921240039577e-13,
	-1.4044321261508230e-13}, /* L674 */
{7.9089013668170383e+00, 5.9269256169613982e-13,
	2.2204460492503131e-16, -7.2386541205560206e-14,
	-1.8895995879120164e-13}, /* L675 */
{6.4567409560717195e+00, 4.8458459467326520e-13,
	2.2204460492503131e-16, 3.0775382242609339e-13,
	1.5987211554602254e-14}, /* L676 */
{5.8618999425987885e+00, 4.4059200732249337e-13,
	2.2204460492503131e-16, -6.8167693711984612e-14,
	-1.2057022047429200e-13}, /* L677 */
{9.6032599888748891e+00, 7.2286621133343942e-13,
	2.2204460492503131e-16, -6.2083671537038754e-13,
	1.8074430840897548e-13}, /* L678 */
{6.9661376473465921e+00, 5.2513549064769904e-13,
	2.2204460492503131e-16, 6.3882232836931507e-13,
	1.2827516826519059e-12}, /* L679 */
{7.2823644305667026e+00, 5.4978244179437752e-13,
	2.2204460492503131e-16, 8.6997076209627267e-13,
	5.2979842735112470e-13}, /* L680 */
{6.2753402971150569e+00, 4.7445380957356065e-13,
	2.2204460492503131e-16, -1.0323963905989331e-12,
	1.5476508963274682e-13}, /* L681 */
{4.6825587073538077e+00, 3.5454972291404374e-13,
	2.2204460492503131e-16, 2.2803980925800715e-13,
	2.2315482794965646e-13}, /* L682 */
{7.6061613414367013e+00, 5.7676086129276882e-13,
	2.2204460492503131e-16, -2.0428103653102880e-14,
	-8.9928064994637680e-15}, /* L683 */
{6.2747266394336467e+00, 4.7649731382826133e-13,
	2.2204460492503131e-16, 1.1235457009206584e-13,
	-1.0631495683810499e-12}, /* L684 */
{6.3967254206221167e+00, 4.8647197381512797e-13,
	2.2204460492503131e-16, -6.3715699383237734e-13,
	2.5091040356528538e-14}, /* L685 */
{9.3039505389499642e+00, 7.0859984546700616e-13,
	2.2204460492503131e-16, 5.5977444901600393e-13,
	-8.9883656073652674e-13}, /* L686 */
{7.0633299211487355e+00, 5.3873572269935721e-13,
	2.2204460492503131e-16, -2.8521629502620272e-13,
	-2.2692958623338200e-13}, /* L687 */
{8.5923100677731608e+00, 6.5630834100716129e-13,
	2.2204460492503131e-16, 1.2878587085651816e-13,
	-1.7363888105137448e-13}, /* L688 */
{7.2465644082783918e+00, 5.5432047840753285e-13,
	2.2204460492503131e-16, -3.5227376571356217e-13,
	-6.5725203057809267e-14}, /* L689 */
{7.3638703136678600e+00, 5.6411125770594595e-13,
	2.2204460492503131e-16, 1.4430678874077785e-12,
	5.1003645751279691e-13}, /* L690 */
{7.6128918951305211e+00, 5.8403282210406360e-13,
	2.2204460492503131e-16, -1.1032286195700181e-12,
	-3.7414515929867775e-13}, /* L691 */
{7.5368616019402781e+00, 5.7903681849325039e-13,
	2.2204460492503131e-16, -9.8587804586713901e-14,
	2.1094237467877974e-14}, /* L692 */
{8.2158318654939286e+00, 6.3211241796423678e-13,
	2.2204460492503131e-16, 1.4543921622589551e-13,
	-1.1102230246251565e-15}, /* L693 */
{9.0925935961520281e+00, 7.0057848411408941e-13,
	2.2204460492503131e-16, -1.1406431354998858e-12,
	-6.1994853695068741e-13}, /* L694 */
{7.8928182079322831e+00, 6.0901284015812962e-13,
	2.2204460492503131e-16, 6.0484950381578528e-13,
	-7.3796524446834155e-13}, /* L695 */
{8.8606461634106850e+00, 6.8467453928633404e-13,
	2.2204460492503131e-16, -5.3301807412253766e-13,
	3.6193270602780103e-14}, /* L696 */
{7.3074003381191019e+00, 5.6546434201720785e-13,
	2.2204460492503131e-16, 1.1057821325266559e-13,
	1.8562928971732617e-13}, /* L697 */
{7.6171323614344733e+00, 5.9027782661758010e-13,
	2.2204460492503131e-16, -4.7217785237307908e-13,
	-7.1731509621031364e-13}, /* L698 */
{7.1344890815968087e+00, 5.5366822238056557e-13,
	2.2204460492503131e-16, 9.1038288019262836e-14,
	-3.2773783686934621e-13}, /* L699 */
{7.0628682859894685e+00, 5.4889426337467739e-13,
	2.2204460492503131e-16, 2.2248869413488137e-13,
	-5.5311311086825299e-13}, /* L700 */
{1.0278903520944912e+01, 7.9997120039365655e-13,
	2.2204460492503131e-16, -1.9717560917342780e-13,
	-1.5210055437364645e-13}, /* L701 */
{5.9750806519976463e+00, 4.6568304767902191e-13,
	2.2204460492503131e-16, -3.6082248300317588e-14,
	4.4630965589931293e-14}, /* L702 */
{7.5551328301684570e+00, 5.8966720395403627e-13,
	2.2204460492503131e-16, -3.2307490016592055e-14,
	-2.1560531138220540e-13}, /* L703 */
{7.8451828319419592e+00, 6.1317617650047396e-13,
	2.2204460492503131e-16, -4.0834002845713258e-13,
	4.0456527017340704e-13}, /* L704 */
{6.4780244048208226e+00, 5.0703885534630899e-13,
	2.2204460492503131e-16, -5.8730798002670781e-14,
	5.5955240441107890e-14}, /* L705 */
{7.1041188569447158e+00, 5.5683235800074726e-13,
	2.2204460492503131e-16, -1.5876189252139739e-14,
	5.4400928206632670e-14}, /* L706 */
{5.4993014627089920e+00, 4.3165471197426086e-13,
	2.2204460492503131e-16, 8.8595797365087492e-14,
	6.4614980033184111e-14}, /* L707 */
{9.1098307568258008e+00, 7.1606609530761034e-13,
	2.2204460492503131e-16, -1.0003109451872660e-13,
	-6.0507154842071031e-14}, /* L708 */
{6.9492352233786265e+00, 5.4700688423281463e-13,
	2.2204460492503131e-16, 2.2204460492503131e-15,
	-1.9317880628477724e-14}, /* L709 */
{7.4306455261971527e+00, 5.8572591221661696e-13,
	2.2204460492503131e-16, -1.1657341758564144e-13,
	-6.9277916736609768e-14}, /* L710 */
{7.5277896544192453e+00, 5.9421911835499941e-13,
	2.2204460492503131e-16, 4.1189274213593308e-13,
	-4.7772896749620486e-13}, /* L711 */
{6.0688297995550533e+00, 4.7972736894053014e-13,
	2.2204460492503131e-16, 1.6209256159527285e-14,
	-1.2989609388114332e-14}, /* L712 */
{7.3275010417146076e+00, 5.8003601921541303e-13,
	2.2204460492503131e-16, 8.6375351315837179e-14,
	-1.9717560917342780e-13}, /* L713 */
{6.8298427082367485e+00, 5.4140025795845759e-13,
	2.2204460492503131e-16, -3.3106850594322168e-13,
	1.0509371151101732e-12}, /* L714 */
{7.5370748283595930e+00, 5.9829918797049686e-13,
	2.2204460492503131e-16, 6.6169292267659330e-14,
	5.1070259132757201e-14}, /* L715 */
{5.3107625687704356e+00, 4.2216230511371577e-13,
	2.2204460492503131e-16, 1.7141843500212417e-13,
	3.1308289294429414e-14}, /* L716 */
{7.1039163682886937e+00, 5.6549209759282348e-13,
	2.2204460492503131e-16, -1.7774670624248756e-13,
	4.4630965589931293e-14}, /* L717 */
{6.9937436246054396e+00, 5.5749849181552236e-13,
	2.2204460492503131e-16, -3.9290792841484290e-13,
	1.8895995879120164e-13}, /* L718 */
{7.9539416171411128e+00, 6.3492266999531921e-13,
	2.2204460492503131e-16, -1.3766765505351941e-14,
	7.7493567118835927e-14}, /* L719 */
{7.4706715087529227e+00, 5.9717508715806389e-13,
	2.2204460492503131e-16, -2.0750068330244176e-13,
	1.4455103780619538e-13}, /* L720 */
{9.1262279907229882e+00, 7.3052675020335300e-13,
	2.2204460492503131e-16, -6.9577676953258560e-13,
	-4.8205883729224297e-13}, /* L721 */
{6.5090130393988090e+00, 5.2174931042259232e-13,
	2.2204460492503131e-16, 2.7311486405778851e-14,
	7.1276318180935050e-14}, /* L722 */
{9.7258106418504031e+00, 7.8068107534079445e-13,
	2.2204460492503131e-16, -3.6970426720017713e-14,
	-1.7374990335383700e-13}, /* L723 */
{6.2507004695059596e+00, 5.0243142979411459e-13,
	2.2204460492503131e-16, 2.7511326550211379e-13,
	-1.4122036873231991e-13}, /* L724 */
{6.8285452562032010e+00, 5.4963672502239547e-13,
	2.2204460492503131e-16, 1.3433698597964394e-13,
	8.3488771451811772e-14}, /* L725 */
{9.7754975165179019e+00, 7.8792528057647360e-13,
	2.2204460492503131e-16, -3.8724579098925460e-13,
	-2.3203661214665772e-13}, /* L726 */
{7.5162601390099084e+00, 6.0666055512470507e-13,
	2.2204460492503131e-16, 1.4210854715202004e-13,
	-1.8535173396116988e-12}, /* L727 */
{7.0333215360811003e+00, 5.6846194418369578e-13,
	2.2204460492503131e-16, 1.3278267374516872e-13,
	1.5254464358349651e-13}, /* L728 */
{8.1183255655418431e+00, 6.5705774154878327e-13,
	2.2204460492503131e-16, 2.0228263508670352e-13,
	-5.7842619582970656e-14}, /* L729 */
{7.1602852694343566e+00, 5.8031357497156932e-13,
	2.2204460492503131e-16, -1.1102230246251565e-15,
	-2.3425705819590803e-13}, /* L730 */
{7.7491572327314513e+00, 6.2889971008672774e-13,
	2.2204460492503131e-16, -7.4695805096780532e-13,
	6.0418337000101019e-13}, /* L731 */
{9.3606705060923083e+00, 7.6072481647315726e-13,
	2.2204460492503131e-16, -1.8929302569858919e-13,
	-9.4591001698063337e-14}, /* L732 */
{7.3291384390825653e+00, 5.9643956440424972e-13,
	2.2204460492503131e-16, -1.7430501486614958e-14,
	2.7133850721838826e-13}, /* L733 */
{9.5042299131400352e+00, 7.7450199031936506e-13,
	2.2204460492503131e-16, 1.6187051699034782e-13,
	-6.4337424277027822e-13}, /* L734 */
{7.8585157997972646e+00, 6.4126481902349042e-13,
	2.2204460492503131e-16, -1.2168044349891716e-13,
	-3.3972824553529790e-14}, /* L735 */
{8.2038172910344347e+00, 6.7035266226866952e-13,
	2.2204460492503131e-16, -4.2388315080188477e-13,
	3.6615155352137663e-13}, /* L736 */
{6.2337276097126253e+00, 5.1006421308841254e-13,
	2.2204460492503131e-16, 1.7388313011679202e-12,
	-6.0618177144533547e-14}, /* L737 */
{7.4573288386491230e+00, 6.1101124160245490e-13,
	2.2204460492503131e-16, -6.1173288656846125e-14,
	1.7208456881689926e-13}, /* L738 */
{6.4492659260648102e+00, 5.2913229353634961e-13,
	2.2204460492503131e-16, 1.2434497875801753e-13,
	1.7763568394002505e-14}, /* L739 */
{1.1235152860900687e+01, 9.2303942267335515e-13,
	2.2204460492503131e-16, 2.3847590568948362e-13,
	4.2099657093785936e-13}, /* L740 */
{9.9743747110003778e+00, 8.2056583750045320e-13,
	2.2204460492503131e-16, 6.5503158452884236e-14,
	4.3076653355456074e-14}, /* L741 */
{8.5293261252393666e+00, 7.0263239670964595e-13,
	2.2204460492503131e-16, -3.9723779821088101e-13,
	1.4210854715202004e-14}, /* L742 */
{7.9360825072763221e+00, 6.5464300647022355e-13,
	2.2204460492503131e-16, 9.7655217246028769e-13,
	-3.9857006584043120e-12}, /* L743 */
{7.4449042189862968e+00, 6.1495253333987421e-13,
	2.2204460492503131e-16, 2.7089441800853820e-13,
	4.9849013805669529e-13}, /* L744 */
{7.5516897667006395e+00, 6.2461147365411307e-13,
	2.2204460492503131e-16, -9.1149310321725352e-14,
	-8.4376949871511897e-14}, /* L745 */
{9.4711945674343347e+00, 7.8442807804890435e-13,
	2.2204460492503131e-16, 5.5067062021407764e-14,
	2.5779378631796135e-13}, /* L746 */
{7.9143364490216470e+00, 6.5636385215839255e-13,
	2.2204460492503131e-16, 1.1901590823981678e-13,
	-1.5543122344752192e-15}, /* L747 */
{1.1739991784277363e+01, 9.7494234907458122e-13,
	2.2204460492503131e-16, -7.0143890695817390e-13,
	2.9687363678476686e-13}, /* L748 */
{1.1184930864165894e+01, 9.3008933887972489e-13,
	2.2204460492503131e-16, 6.5725203057809267e-14,
	-2.2737367544323206e-13}, /* L749 */
{8.6600136629479803e+00, 7.2108985449403917e-13,
	2.2204460492503131e-16, 1.1435297153639112e-13,
	4.3409720262843621e-13}, /* L750 */
{6.6088652869965623e+00, 5.5103144269708082e-13,
	2.2204460492503131e-16, 4.4386716524513758e-13,
	-2.8655966488599915e-12}, /* L751 */
{9.3038710617604785e+00, 7.7676753917899077e-13,
	2.2204460492503131e-16, -1.8429702208777599e-14,
	3.2640556923979602e-14}, /* L752 */
{7.4681392725575098e+00, 6.2433391789795678e-13,
	2.2204460492503131e-16, 1.0937917238607042e-12,
	-1.7652546091539989e-14}, /* L753 */
{8.9111546427288726e+00, 7.4595885024564268e-13,
	2.2204460492503131e-16, 9.9831254374294076e-13,
	-1.0191847366058937e-13}, /* L754 */
{8.5516691211632256e+00, 7.1681549584923232e-13,
	2.2204460492503131e-16, 1.0436096431476471e-14,
	-2.9864999362416711e-14}, /* L755 */
{7.3293766429716447e+00, 6.1517457794479924e-13,
	2.2204460492503131e-16, -1.8296475445822580e-13,
	2.7511326550211379e-13}, /* L756 */
{5.9458482183176145e+00, 4.9971138338378296e-13,
	2.2204460492503131e-16, 1.2057022047429200e-13,
	1.7807977314987511e-13}, /* L757 */
{9.1316107130685378e+00, 7.6846862206991773e-13,
	2.2204460492503131e-16, -1.1735057370287905e-13,
	-1.4799272918253337e-13}, /* L758 */
{7.4170077492763280e+00, 6.2500005171273187e-13,
	2.2204460492503131e-16, 5.4622972811557702e-14,
	-8.3488771451811772e-13}, /* L759 */
{9.8072523150739457e+00, 8.2750473140436043e-13,
	2.2204460492503131e-16, 1.5631940186722204e-13,
	-4.9515946898281982e-14}, /* L760 */
{7.4251102691706894e+00, 6.2733152006444470e-13,
	2.2204460492503131e-16, 1.7497114868092467e-13,
	-2.6689761511988763e-13}, /* L761 */
{9.6083648967151305e+00, 8.1285672637321227e-13,
	2.2204460492503131e-16, -6.3282712403633923e-15,
	7.3496764230185363e-14}, /* L762 */
{7.2632814462225914e+00, 6.1527172245945394e-13,
	2.2204460492503131e-16, 1.7785772854495008e-13,
	-1.2778667013435552e-13}, /* L763 */
{8.1043976031167251e+00, 6.8742234127228130e-13,
	2.2204460492503131e-16, -4.1966430330830917e-14,
	1.6031620475587260e-13}, /* L764 */
{7.3438024360209262e+00, 6.2372329523441294e-13,
	2.2204460492503131e-16, 1.7785772854495008e-13,
	-3.2640556923979602e-13}, /* L765 */
{8.5424416759041826e+00, 7.2647443616347118e-13,
	2.2204460492503131e-16, 4.8849813083506888e-15,
	-9.3036689463588118e-14}, /* L766 */
{7.8826721497020387e+00, 6.7124084068836964e-13,
	2.2204460492503131e-16, -7.0610184366159956e-13,
	-3.9057646006313007e-13}, /* L767 */
{8.1653774659007361e+00, 6.9622085874243567e-13,
	2.2204460492503131e-16, 4.0856207306205761e-14,
	-4.4975134727565091e-13}, /* L768 */
{8.7036873339459344e+00, 7.4308614816942509e-13,
	2.2204460492503131e-16, -2.0461410343841635e-13,
	3.6126657221302594e-13}, /* L769 */
{8.8422217426190866e+00, 7.5589534631603783e-13,
	2.2204460492503131e-16, -3.8202774277351637e-13,
	-1.0831335828243027e-12}, /* L770 */
{1.3264450239997485e+01, 1.1354112094963398e-12,
	2.2204460492503131e-16, 6.4392935428259079e-15,
	1.2900791546144319e-13}, /* L771 */
{7.4546749737271139e+00, 6.3893335067177759e-13,
	2.2204460492503131e-16, 2.9309887850104133e-14,
	-1.2545520178264269e-14}, /* L772 */
{6.6130440686028686e+00, 5.6753213240057221e-13,
	2.2204460492503131e-16, -1.5486500970496309e-12,
	1.5996093338799255e-12}, /* L773 */
{7.9265305935959320e+00, 6.8113570339534135e-13,
	2.2204460492503131e-16, -2.7389202017502612e-13,
	7.8159700933611020e-14}, /* L774 */
{7.2819469726447874e+00, 6.2655436394720709e-13,
	2.2204460492503131e-16, -1.6375789613221059e-13,
	-3.4416913763379853e-14}, /* L775 */
{8.5660573291593227e+00, 7.3799300004395718e-13,
	2.2204460492503131e-16, 1.9162449405030202e-13,
	1.3877787807814457e-13}, /* L776 */
{8.0585712726207515e+00, 6.9516614686904177e-13,
	2.2204460492503131e-16, -1.3311574065255627e-13,
	-4.9960036108132044e-14}, /* L777 */
{6.7254283485375970e+00, 5.8091031984730535e-13,
	2.2204460492503131e-16, -3.2618352463487099e-13,
	1.1812772982011666e-13}, /* L778 */
{6.7597988549638242e+00, 5.8462956697979962e-13,
	2.2204460492503131e-16, 3.3173463975799677e-13,
	-3.8224978737844140e-13}, /* L779 */
{1.0475176783170124e+01, 9.0712160005779197e-13,
	2.2204460492503131e-16, -1.0258460747536446e-13,
	-1.0480505352461478e-13}, /* L780 */
{1.0455522257589028e+01, 9.0658036633328720e-13,
	2.2204460492503131e-16, 4.4408920985006262e-14,
	3.9079850466805510e-13}, /* L781 */
{1.1057881896224410e+01, 9.6003760496898849e-13,
	2.2204460492503131e-16, -2.0761170560490427e-14,
	7.4606987254810520e-14}, /* L782 */
{7.8598463724364906e+00, 6.8325900492993696e-13,
	2.2204460492503131e-16, 3.0353497493251780e-13,
	-5.7509552675583109e-14}, /* L783 */
{7.1938889008693163e+00, 6.2616578588858829e-13,
	2.2204460492503131e-16, -7.9825035470548755e-14,
	-2.1083135237631723e-13}, /* L784 */
{7.7324962760381970e+00, 6.7390537594747002e-13,
	2.2204460492503131e-16, -4.2665870836344766e-13,
	-7.5495165674510645e-14}, /* L785 */
{8.9103194013840081e+00, 7.7754469529622838e-13,
	2.2204460492503131e-16, 5.3290705182007514e-15,
	6.7501559897209518e-14}, /* L786 */
{9.4320352113557639e+00, 8.2411855117925370e-13,
	2.2204460492503131e-16, 1.0769163338864018e-13,
	6.4837024638109142e-14}, /* L787 */
{8.4089599673800119e+00, 7.3566153169224435e-13,
	2.2204460492503131e-16, 7.6827433304060833e-14,
	-2.4380497620768438e-13}, /* L788 */
{9.8251105581557905e+00, 8.6064488868942135e-13,
	2.2204460492503131e-16, 3.5238478801602469e-13,
	-5.2069459854919842e-14}, /* L789 */
{7.5019105699873885e+00, 6.5797367554409902e-13,
	2.2204460492503131e-16, 1.4388490399142029e-13,
	-1.5210055437364645e-14}, /* L790 */
{7.5771295271841250e+00, 6.6541216980908757e-13,
	2.2204460492503131e-16, -4.4741987892393809e-14,
	-4.7295500849031669e-14}, /* L791 */
{9.5221109826427721e+00, 8.3727469402106180e-13,
	2.2204460492503131e-16, -1.2403411631112249e-12,
	1.0578204978628492e-12}, /* L792 */
{8.9615526002406884e+00, 7.8897999244986750e-13,
	2.2204460492503131e-16, -2.3170354523927017e-13,
	-2.0972112935169207e-13}, /* L793 */
{8.9364120839203913e+00, 7.8775874712277982e-13,
	2.2204460492503131e-16, -1.0591527654923993e-13,
	1.5298873279334657e-13}, /* L794 */
{8.9547311090733466e+00, 7.9036777123064894e-13,
	2.2204460492503131e-16, -1.5365486660812167e-13,
	1.1479706074624119e-13}, /* L795 */
{1.0527183694230891e+01, 9.3032526127245774e-13,
	2.2204460492503131e-16, 5.3734794391857577e-14,
	-2.0228263508670352e-13}, /* L796 */
{9.0796881017483191e+00, 8.0341289176999453e-13,
	2.2204460492503131e-16, -3.4638958368304884e-14,
	-1.5309975509580909e-13}, /* L797 */
{9.7844765899198247e+00, 8.6686213762732223e-13,
	2.2204460492503131e-16, 1.1279865930191590e-13,
	-3.0087043967341742e-14}, /* L798 */
{9.4274241352800470e+00, 8.3627549329889916e-13,
	2.2204460492503131e-16, 9.5345953354808444e-13,
	1.4854784069484595e-13}, /* L799 */
{7.8762624264303547e+00, 6.9955152781631114e-13,
	2.2204460492503131e-16, -8.4365847641265646e-13,
	-1.1046719095020308e-13}, /* L800 */
{1.0589592237834299e+01, 9.4171892506267341e-13,
	2.2204460492503131e-16, 7.2053474298172659e-13,
	-4.9893422726654535e-13}, /* L801 */
{9.6063119140477990e+00, 8.5534357374683623e-13,
	2.2204460492503131e-16, -1.7441603716861209e-13,
	-1.6153745008296028e-13}, /* L802 */
{8.4000755193483094e+00, 7.4887318568528372e-13,
	2.2204460492503131e-16, -1.8329782136561334e-13,
	-6.9833028248922346e-14}, /* L803 */
{7.9076617297025287e+00, 7.0585204348105890e-13,
	2.2204460492503131e-16, 2.6401103525586223e-13,
	2.3536728122053319e-13}, /* L804 */
{7.8183353164073290e+00, 6.9874661612345790e-13,
	2.2204460492503131e-16, 8.5709217501062085e-14,
	1.5321077739827160e-14}, /* L805 */
{1.0004338829820590e+01, 8.9522660118301900e-13,
	2.2204460492503131e-16, 2.3558932582545822e-13,
	7.3496764230185363e-14}, /* L806 */
{9.3695934689663307e+00, 8.3946738449469649e-13,
	2.2204460492503131e-16, 7.0832228971084987e-14,
	-4.5297099404706387e-14}, /* L807 */
{9.4678367196462005e+00, 8.4932061383824475e-13,
	2.2204460492503131e-16, -1.8651746813702630e-14,
	-2.3869795029440866e-14}, /* L808 */
{8.9224491820796867e+00, 8.0138673475005362e-13,
	2.2204460492503131e-16, 6.0840221749458578e-14,
	-1.0547118733938987e-13}, /* L809 */
{7.8339629769814980e+00, 7.0449202027589308e-13,
	2.2204460492503131e-16, 1.5387691121304670e-13,
	-5.9396931817445875e-14}, /* L810 */
{6.5175811829452082e+00, 5.8683613524124212e-13,
	2.2204460492503131e-16, 2.5890400934258651e-13,
	1.3145040611561853e-13}, /* L811 */
{7.7537068143488641e+00, 6.9899641630399856e-13,
	2.2204460492503131e-16, 2.0650148258027912e-14,
	-1.7985612998927536e-13}, /* L812 */
{7.5836528011904614e+00, 6.8450800583264026e-13,
	2.2204460492503131e-16, 5.6177285046032921e-14,
	1.2567724638756772e-13}, /* L813 */
{8.3853019273328222e+00, 7.5779660324570841e-13,
	2.2204460492503131e-16, -2.9065638784686598e-13,
	5.7664983899030631e-13}, /* L814 */
{9.6859048520730031e+00, 8.7641005563909857e-13,
	2.2204460492503131e-16, 7.3274719625260332e-14,
	7.7715611723760958e-14}, /* L815 */
{7.0827317627093862e+00, 6.4165339708210922e-13,
	2.2204460492503131e-16, -2.7566837701442637e-13,
	-1.6386891843467311e-13}, /* L816 */
{9.4075270822245933e+00, 8.5331047783299141e-13,
	2.2204460492503131e-16, -7.0721206668622472e-14,
	-1.4099832412739488e-14}, /* L817 */
{7.0130764680034918e+00, 6.3690025475793277e-13,
	2.2204460492503131e-16, -4.5297099404706387e-14,
	1.0658141036401503e-14}, /* L818 */
{8.0940298640150008e+00, 7.3596684302401627e-13,
	2.2204460492503131e-16, 4.6251891205884021e-13,
	-1.5731860258938468e-13}, /* L819 */
{1.0115869618414525e+01, 9.2092999892656735e-13,
	2.2204460492503131e-16, 2.3936408410918375e-13,
	-1.6253665080512292e-13}, /* L820 */
{8.6443498136464267e+00, 7.8792528057647360e-13,
	2.2204460492503131e-16, -2.6867397195928788e-13,
	-7.8825834748386114e-14}, /* L821 */
{7.1800599898252191e+00, 6.5525362913376739e-13,
	2.2204460492503131e-16, -1.7708057242771247e-13,
	2.8399504969911504e-13}, /* L822 */
{9.6500759783270098e+00, 8.8173912615729932e-13,
	2.2204460492503131e-16, 5.6465943032435462e-13,
	4.1744385725905886e-13}, /* L823 */
{9.6310831561897512e+00, 8.8107299234252423e-13,
	2.2204460492503131e-16, -1.5465406733028431e-13,
	2.4824586830618500e-13}, /* L824 */
{9.5163786504205685e+00, 8.7163609663321040e-13,
	2.2204460492503131e-16, 1.4410694859634532e-13,
	-1.2334577803585489e-13}, /* L825 */
{8.8638154372800386e+00, 8.1284978747930836e-13,
	2.2204460492503131e-16, 2.6689761511988763e-13,
	-6.3415939166588942e-13}, /* L826 */
{8.5610775939303263e+00, 7.8603790143461083e-13,
	2.2204460492503131e-16, 8.3710816056736803e-14,
	3.4150460237469815e-13}, /* L827 */
{1.2552103136740794e+01, 1.1538686672807330e-12,
	2.2204460492503131e-16, -1.7842394228750891e-12,
	-1.4739320874923578e-12}, /* L828 */
{8.8564675313609094e+00, 8.1512574467978993e-13,
	2.2204460492503131e-16, 2.7458035845029372e-12,
	-2.9775071297422073e-12}, /* L829 */
{7.0801316522996771e+00, 6.5242256042097324e-13,
	2.2204460492503131e-16, 1.7674750552032492e-13,
	1.4210854715202004e-13}, /* L830 */
{1.1191955082364116e+01, 1.0325629240526268e-12,
	2.2204460492503131e-16, 2.9718449923166190e-12,
	1.7561507803520726e-12}, /* L831 */
{6.8272343290666058e+00, 6.3063443356270454e-13,
	2.2204460492503131e-16, -1.0547118733938987e-13,
	3.6859404417555197e-13}, /* L832 */
{7.1995911907790857e+00, 6.6582850344332201e-13,
	2.2204460492503131e-16, 7.2608585810485238e-14,
	2.3092638912203256e-14}, /* L833 */
{7.6960553075793170e+00, 7.1259664835565673e-13,
	2.2204460492503131e-16, -4.5152770411505116e-13,
	7.6272321791748254e-13}, /* L834 */
{8.1637853351506067e+00, 7.5681128031135358e-13,
	2.2204460492503131e-16, 2.1960211427085596e-13,
	-1.0347278589506459e-13}, /* L835 */
{8.3175968547887891e+00, 7.7199358017310260e-13,
	2.2204460492503131e-16, 5.3734794391857577e-14,
	-1.1457501614131615e-13}, /* L836 */
{7.8757591400936109e+00, 7.3185901783290319e-13,
	2.2204460492503131e-16, 2.2648549702353193e-13,
	9.5479180117763462e-14}, /* L837 */
{8.3454785605139037e+00, 7.7643447227160323e-13,
	2.2204460492503131e-16, 1.4299672557172016e-13,
	-2.1982415887578100e-14}, /* L838 */
{9.1460960746643813e+00, 8.5193657684001778e-13,
	2.2204460492503131e-16, -8.6597395920762210e-15,
	-2.5979218776228663e-13}, /* L839 */
{9.0654904931455711e+00, 8.4543483325205671e-13,
	2.2204460492503131e-16, -7.4662498406041777e-13,
	4.6251891205884021e-13}, /* L840 */
{8.9340212296280370e+00, 8.3416606955211137e-13,
	2.2204460492503131e-16, -4.5952130989235229e-13,
	2.4713564528155985e-13}, /* L841 */
{9.0778052959749775e+00, 8.4859896887223840e-13,
	2.2204460492503131e-16, -2.2670754162845697e-13,
	5.9285909514983359e-14}, /* L842 */
{6.6648978224921169e+00, 6.2377880638564420e-13,
	2.2204460492503131e-16, -4.3964831775156199e-14,
	-1.3311574065255627e-13}, /* L843 */
{9.2218747389898201e+00, 8.6411433564137496e-13,
	2.2204460492503131e-16, -3.0531133177191805e-14,
	3.5971225997855072e-14}, /* L844 */
{7.2414315431981597e+00, 6.7934546876813329e-13,
	2.2204460492503131e-16, 9.7921670771938807e-14,
	-2.8266278206956486e-13}, /* L845 */
{1.0783113939308063e+01, 1.0128009542142991e-12,
	2.2204460492503131e-16, -4.0079051188968151e-14,
	5.4845017416482733e-14}, /* L846 */
{8.0838380195628670e+00, 7.6016970496084468e-13,
	2.2204460492503131e-16, 2.2493118478905672e-13,
	-1.2123635428906709e-13}, /* L847 */
{9.2550263941533704e+00, 8.7133078530143848e-13,
	2.2204460492503131e-16, 9.6744834365836141e-13,
	6.7479355436717015e-13}, /* L848 */
{7.3633802862769686e+00, 6.9405592384441661e-13,
	2.2204460492503131e-16, -3.4861002973229915e-14,
	-1.9761969838327786e-14}, /* L849 */
{8.7670726554007281e+00, 8.2733819795066665e-13,
	2.2204460492503131e-16, -1.1068923555512811e-13,
	3.1086244689504383e-15}, /* L850 */
{8.5053013154579915e+00, 8.0357942522368830e-13,
	2.2204460492503131e-16, 8.3133500083931722e-13,
	-8.3377749149349256e-13}, /* L851 */
{8.7834645619593292e+00, 8.3083540047823590e-13,
	2.2204460492503131e-16, 1.6209256159527285e-13,
	4.6407322429331543e-14}, /* L852 */
{8.5708663945050407e+00, 8.1167711440954804e-13,
	2.2204460492503131e-16, -1.7751355940731628e-12,
	7.4962258622690570e-13}, /* L853 */
{9.3900909272202480e+00, 8.9030172123472084e-13,
	2.2204460492503131e-16, -9.8809849191638932e-15,
	8.4376949871511897e-14}, /* L854 */
{9.2368566782892039e+00, 8.7679863369771738e-13,
	2.2204460492503131e-16, -2.7222668563808838e-13,
	-2.1266322036694874e-12}, /* L855 */
{8.6851772540675203e+00, 8.2539530765757263e-13,
	2.2204460492503131e-16, -7.9936057773011271e-15,
	1.1035616864774056e-13}, /* L856 */
{9.7447644992368634e+00, 9.2717500344008386e-13,
	2.2204460492503131e-16, -4.7961634663806763e-14,
	3.9301895071730542e-14}, /* L857 */
{9.9743747108895935e+00, 9.5012886447420897e-13,
	2.2204460492503131e-16, 1.9604318168831014e-12,
	5.6434856787745957e-12}, /* L858 */
{9.6531002122905321e+00, 9.2059693201917980e-13,
	2.2204460492503131e-16, 4.7961634663806763e-14,
	-7.3607786532647879e-14}, /* L859 */
{8.8901303049971965e+00, 8.4882101347716343e-13,
	2.2204460492503131e-16, -2.6997293289809932e-12,
	-5.0326409706258346e-13}, /* L860 */
{7.4477469419957423e+00, 7.1193051454088163e-13,
	2.2204460492503131e-16, 1.0325074129013956e-13,
	-2.0794477251229182e-13}, /* L861 */
{1.1308602528427313e+01, 1.0822454044046026e-12,
	2.2204460492503131e-16, 4.9560355819266988e-13,
	6.3282712403633923e-14}, /* L862 */
{1.0934837645943642e+01, 1.0476897127631446e-12,
	2.2204460492503131e-16, 1.8585133432225120e-13,
	1.6564527527407336e-13}, /* L863 */
{7.7118177225251010e+00, 7.3974160130774180e-13,
	2.2204460492503131e-16, 3.9968028886505635e-14,
	4.9449333516804472e-13}, /* L864 */
{8.6456783802282420e+00, 8.3028028896592332e-13,
	2.2204460492503131e-16, -2.1471713296250527e-13,
	1.0658141036401503e-13}, /* L865 */
{1.1508101297270503e+01, 1.1064482663414310e-12,
	2.2204460492503131e-16, -2.6356694604601216e-13,
	-3.7392311469375272e-13}, /* L866 */
{8.1707164665384315e+00, 7.8648199064446089e-13,
	2.2204460492503131e-16, 1.5298873279334657e-13,
	3.6215475063272606e-13}, /* L867 */
{9.0049825251942153e+00, 8.6778501051654189e-13,
	2.2204460492503131e-16, -1.1990408665951691e-14,
	2.3936408410918375e-13}, /* L868 */
{7.3601957319086582e+00, 7.1009864655025012e-13,
	2.2204460492503131e-16, -1.8052226380405045e-13,
	-9.5590202420225978e-14}, /* L869 */
{1.1404687533352522e+01, 1.1015702239269842e-12,
	2.2204460492503131e-16, 1.3049561431444090e-12,
	-1.7373880112359075e-12}, /* L870 */
{9.1808411207272815e+00, 8.8778984164150643e-13,
	2.2204460492503131e-16, -8.4043882964124350e-14,
	-1.4932499681208355e-13}, /* L871 */
{7.0450225828563511e+00, 6.8203775960284929e-13,
	2.2204460492503131e-16, -7.4495964952348004e-13,
	-8.9150908877400070e-14}, /* L872 */
{8.4539079540566338e+00, 8.1937234774898116e-13,
	2.2204460492503131e-16, -1.1313172620930345e-13,
	-3.3750779948604759e-14}, /* L873 */
{8.0283307441516811e+00, 7.7901574080385672e-13,
	2.2204460492503131e-16, -7.8370643308289800e-13,
	-7.2830630415410269e-14}, /* L874 */
{8.2551558813548791e+00, 8.0194184626236620e-13,
	2.2204460492503131e-16, -5.4634075041803953e-13,
	-1.1024514634527804e-13}, /* L875 */
{7.8658799899495468e+00, 7.6499917511796411e-13,
	2.2204460492503131e-16, -6.9011463210699731e-13,
	-1.7931212070720903e-12}, /* L876 */
{9.9549757972451545e+00, 9.6928021164899292e-13,
	2.2204460492503131e-16, -1.9195756095768957e-13,
	1.3036238755148588e-12}, /* L877 */
{9.5558237323228443e+00, 9.3147711766050634e-13,
	2.2204460492503131e-16, 2.9642954757491680e-13,
	3.7814196218732832e-13}, /* L878 */
{7.0709013719587910e+00, 6.9003830427405433e-13,
	2.2204460492503131e-16, -3.5527136788005009e-13,
	1.3655743202889425e-13}, /* L879 */
{7.2676251024883580e+00, 7.1004313539901887e-13,
	2.2204460492503131e-16, -3.0219160507272136e-12,
	-1.1097789354153065e-12}, /* L880 */
{7.3008060700919248e+00, 7.1409544943890069e-13,
	2.2204460492503131e-16, 1.3218315331187114e-12,
	2.2692958623338200e-13}, /* L881 */
{1.0780062359229364e+01, 1.0556000518135988e-12,
	2.2204460492503131e-16, 2.3536728122053319e-14,
	-3.9623859748871837e-13}, /* L882 */
{1.1245487730750195e+01, 1.1024237078771648e-12,
	2.2204460492503131e-16, 1.1302070390684094e-13,
	6.4681593414661620e-13}, /* L883 */
{1.1114270928719518e+01, 1.0907941216942163e-12,
	2.2204460492503131e-16, -2.0605739337042905e-13,
	5.0159876252564572e-13}, /* L884 */
{1.0774028297686133e+01, 1.0585976539800868e-12,
	2.2204460492503131e-16, 5.7487348215090606e-13,
	-9.6145313932538556e-14}, /* L885 */
{9.2838746923733702e+00, 9.1321394890542251e-13,
	2.2204460492503131e-16, 1.6253665080512292e-13,
	6.4392935428259079e-14}, /* L886 */
{8.6950531770943673e+00, 8.5625950774215198e-13,
	2.2204460492503131e-16, 1.3544720900426910e-14,
	-1.6264767310758543e-13}, /* L887 */
{8.1500515689797766e+00, 8.0349442377336544e-13,
	2.2204460492503131e-16, 3.0864200084579352e-14,
	-6.0618177144533547e-14}, /* L888 */
{1.0143998006504338e+01, 1.0011991236069662e-12,
	2.2204460492503131e-16, -5.4622972811557702e-14,
	1.4876988529977098e-13}, /* L889 */
{9.9584426777933839e+00, 9.8399066672527624e-13,
	2.2204460492503131e-16, 5.3734794391857577e-14,
	-1.7030821197749901e-13}, /* L890 */
{9.3535501106739005e+00, 9.2525986872260546e-13,
	2.2204460492503131e-16, 4.3365311341858614e-13,
	-1.0377254611171338e-12}, /* L891 */
{8.8413816621151735e+00, 8.7557738837062971e-13,
	2.2204460492503131e-16, 1.1923795284474181e-13,
	-2.8310687127941492e-14}, /* L892 */
{1.1136635711446218e+01, 1.1041167979897182e-12,
	2.2204460492503131e-16, -3.6970426720017713e-14,
	-3.3306690738754696e-15}, /* L893 */
{1.0220374066583396e+01, 1.0144107776000055e-12,
	2.2204460492503131e-16, 2.5845992013273644e-13,
	-7.8970163741587385e-13}, /* L894 */
{1.1497224843139648e+01, 1.1424194923392861e-12,
	2.2204460492503131e-16, 1.5609735726229701e-12,
	-4.8550052866858096e-13}, /* L895 */
{9.4001264377833351e+00, 9.3508534249053810e-13,
	2.2204460492503131e-16, -3.3562042034418482e-13,
	-2.8987923172962837e-13}, /* L896 */
{1.0294330622702056e+01, 1.0251799409388695e-12,
	2.2204460492503131e-16, -1.4876988529977098e-14,
	2.7444713168733870e-13}, /* L897 */
{1.0422622234490978e+01, 1.0391132398979153e-12,
	2.2204460492503131e-16, 3.8635761256955448e-14,
	-7.9602990865623724e-14}, /* L898 */
{8.0931718342821970e+00, 8.0777051714164827e-13,
	2.2204460492503131e-16, -1.2034817586936697e-13,
	2.0428103653102880e-13}, /* L899 */
{7.0200110755208911e+00, 7.0143890695817390e-13,
	2.2204460492503131e-16, -4.7961634663806763e-14,
	-7.9491968563161208e-14}, /* L900 */
{1.1487809467341837e+01, 1.1491363416382683e-12,
	2.2204460492503131e-16, 2.9087843245179101e-13,
	3.4994229736184934e-13}, /* L901 */
{1.1414652155317993e+01, 1.1430856261540612e-12,
	2.2204460492503131e-16, 1.7319479184152442e-13,
	9.4813046302988369e-14}, /* L902 */
{1.2522168150547911e+01, 1.2553846850948958e-12,
	2.2204460492503131e-16, 7.8603790143461083e-14,
	-6.0840221749458578e-14}, /* L903 */
{1.2310860130891697e+01, 1.2355672041053367e-12,
	2.2204460492503131e-16, 3.6948222259525210e-13,
	1.0258460747536446e-13}, /* L904 */
{8.0784657841171139e+00, 8.1168405330345195e-13,
	2.2204460492503131e-16, -6.7279515292284486e-13,
	-1.5210055437364645e-14}, /* L905 */
{9.2185575905365909e+00, 9.2725827016693074e-13,
	2.2204460492503131e-16, -1.1080025785759062e-13,
	1.7763568394002505e-15}, /* L906 */
{1.0620744430059446e+01, 1.0694778396214133e-12,
	2.2204460492503131e-16, 1.0769163338864018e-13,
	1.1817213874110166e-12}, /* L907 */
{1.2152552212688891e+01, 1.2250755965226290e-12,
	2.2204460492503131e-16, -1.0540457395791236e-12,
	3.0646596371752821e-12}, /* L908 */
{9.7362639858235518e+00, 9.8257513236887917e-13,
	2.2204460492503131e-16, 3.0353497493251780e-13,
	2.6378899065093719e-13}, /* L909 */
{1.1767600983396790e+01, 1.1888823259198489e-12,
	2.2204460492503131e-16, 2.3181456754173269e-13,
	1.2434497875801753e-13}, /* L910 */
{8.8117592370897988e+00, 8.9123153301784441e-13,
	2.2204460492503131e-16, 3.3439917501709715e-12,
	2.7022828419376310e-12}, /* L911 */
{7.9884994455750284e+00, 8.0885298459065780e-13,
	2.2204460492503131e-16, -2.2551960299210805e-12,
	-1.5543122344752192e-14}, /* L912 */
{1.0911230248629407e+01, 1.1059972382376770e-12,
	2.2204460492503131e-16, -6.7945649107059580e-14,
	-2.7848834349697427e-12}, /* L913 */
{1.0536668702546489e+01, 1.0692002838652570e-12,
	2.2204460492503131e-16, -5.8841820305133297e-14,
	3.3306690738754696e-15}, /* L914 */
{1.0859579974759525e+01, 1.1031731084187868e-12,
	2.2204460492503131e-16, 2.2470914018413168e-13,
	-1.6475709685437323e-13}, /* L915 */
{1.4791508052074301e+01, 1.5042411760646246e-12,
	2.2204460492503131e-16, 2.1791457527342573e-12,
	-1.3017809052939810e-11}, /* L916 */
{1.0936222270511172e+01, 1.1133871602453382e-12,
	2.2204460492503131e-16, -4.9626969200744497e-14,
	-2.4091839634365897e-13}, /* L917 */
{9.2935876448666566e+00, 9.4718677345895230e-13,
	2.2204460492503131e-16, 5.4794613291164751e-11,
	1.4365686418216228e-10}, /* L918 */
{9.8067347322160501e+00, 1.0005746231556145e-12,
	2.2204460492503131e-16, -2.4735768988648488e-13,
	-3.1075142459258132e-13}, /* L919 */
{9.0054489905626500e+00, 9.1981977590194219e-13,
	2.2204460492503131e-16, 2.0383694732117874e-13,
	5.9063864910058328e-14}, /* L920 */
{9.5496893336698143e+00, 9.7646890573344081e-13,
	2.2204460492503131e-16, -5.7776006201493146e-13,
	1.4077627952246985e-12}, /* L921 */
{9.6090512231675582e+00, 9.8360555811360939e-13,
	2.2204460492503131e-16, -2.9642954757491680e-14,
	-3.5038638657169940e-13}, /* L922 */
{1.0225368245226543e+01, 1.0478284906412227e-12,
	2.2204460492503131e-16, 2.6956215037898801e-12,
	4.2854608750531042e-12}, /* L923 */
{1.0079020230657273e+01, 1.0339507028334083e-12,
	2.2204460492503131e-16, 4.2525982735241996e-12,
	4.3836045904299681e-12}, /* L924 */
{8.9943385147546415e+00, 9.2367780091251461e-13,
	2.2204460492503131e-16, 2.6978419498391304e-13,
	-1.8096635301390052e-14}, /* L925 */
{1.0424422494196664e+01, 1.0716982856706636e-12,
	2.2204460492503131e-16, -1.3022916078853086e-13,
	-1.3700152123874432e-13}, /* L926 */
{1.0250825234278901e+01, 1.0549894291500550e-12,
	2.2204460492503131e-16, 6.8833827526759706e-15,
	-5.3013149425851225e-13}, /* L927 */
{8.6961344095960857e+00, 8.9594998087250133e-13,
	2.2204460492503131e-16, 3.5904612616377563e-13,
	-1.6064927166326015e-13}, /* L928 */
{1.3198083255431015e+01, 1.3612444504929044e-12,
	2.2204460492503131e-16, 3.5083047578154947e-14,
	-1.0746958878371515e-13}, /* L929 */
{9.5479989348851610e+00, 9.8583641250371556e-13,
	2.2204460492503131e-16, -4.9960036108132044e-14,
	4.7073456244106637e-14}, /* L930 */
{1.1345882562131946e+01, 1.1727285809115529e-12,
	2.2204460492503131e-16, 1.8407497748285095e-13,
	-9.1038288019262836e-14}, /* L931 */
{8.8916449296882281e+00, 9.2004182050686723e-13,
	2.2204460492503131e-16, 4.7739590058881731e-14,
	-2.2959412149248237e-13}, /* L932 */
{1.0282438516343662e+01, 1.0650924586741439e-12,
	2.2204460492503131e-16, -3.4749980670767400e-13,
	1.4588330543574557e-13}, /* L933 */
{8.8147890677465277e+00, 9.1404661617389138e-13,
	2.2204460492503131e-16, -4.9205084451386938e-13,
	4.9449333516804472e-13}, /* L934 */
{1.2036382626232148e+01, 1.2494449919131512e-12,
	2.2204460492503131e-16, -1.9773072068574038e-13,
	-1.5254464358349651e-13}, /* L935 */
{9.3368202862963940e+00, 9.7025165679553993e-13,
	2.2204460492503131e-16, 1.4579448759377556e-12,
	-3.9834802123550617e-13}, /* L936 */
{9.6435584377376546e+00, 1.0031975250512914e-12,
	2.2204460492503131e-16, -2.7544633240950134e-13,
	2.8754776337791554e-13}, /* L937 */
{1.1077309587603191e+01, 1.1535772337367689e-12,
	2.2204460492503131e-16, 7.2875039336395275e-13,
	-8.6264329013374663e-14}, /* L938 */
{9.7371692495089679e+00, 1.0150977280964923e-12,
	2.2204460492503131e-16, -3.4250380309686079e-13,
	2.3625545964023331e-13}, /* L939 */
{9.3893765158090154e+00, 9.7988284153416316e-13,
	2.2204460492503131e-16, 7.7271522513910895e-14,
	8.1712414612411521e-14}, /* L940 */
{7.6742947857833341e+00, 8.0174755723305680e-13,
	2.2204460492503131e-16, -9.0849550105076560e-13,
	-1.2045919817182948e-13}, /* L941 */
{1.0620505078740063e+01, 1.1107226249862379e-12,
	2.2204460492503131e-16, 1.5494272531668685e-12,
	3.0020430585864233e-13}, /* L942 */
{9.7386155767581144e+00, 1.0195733146645125e-12,
	2.2204460492503131e-16, -1.6231460620019789e-13,
	-5.5488946770765324e-13}, /* L943 */
{1.0797156865251148e+01, 1.1315948178491908e-12,
	2.2204460492503131e-16, 1.7075230118734908e-13,
	-4.2632564145606011e-14}, /* L944 */
{9.7206502569740287e+00, 1.0198508704206688e-12,
	2.2204460492503131e-16, -1.1390888232654106e-13,
	5.9063864910058328e-14}, /* L945 */
{9.5333000466740430e+00, 1.0012546347581974e-12,
	2.2204460492503131e-16, 3.4439118223872356e-13,
	-2.0083934515469082e-13}, /* L946 */
{1.1052800570584452e+01, 1.1620704398751514e-12,
	2.2204460492503131e-16, -9.0427665355719000e-13,
	-4.2843506520284791e-13}, /* L947 */
{1.1213082461681493e+01, 1.1801670751765414e-12,
	2.2204460492503131e-16, -3.3606450955403488e-13,
	-3.1974423109204508e-13}, /* L948 */
{1.1047288876499129e+01, 1.1639439412292063e-12,
	2.2204460492503131e-16, 2.6045832157706172e-13,
	2.8044233602031454e-13}, /* L949 */
{9.4200019260841117e+00, 9.9353858473705259e-13,
	2.2204460492503131e-16, -9.3330898565113785e-12,
	1.4284129434827264e-11}, /* L950 */
{1.1617247380819979e+01, 1.2265743976058729e-12,
	2.2204460492503131e-16, 9.2592600253738055e-14,
	-3.8191672047105385e-14}, /* L951 */
{1.2258931078197527e+01, 1.2956857808887889e-12,
	2.2204460492503131e-16, 9.5923269327613525e-14,
	4.3343106881366111e-13}, /* L952 */
{1.0657399870776539e+01, 1.1275980149605402e-12,
	2.2204460492503131e-16, 3.5083047578154947e-14,
	7.8426154459521058e-13}, /* L953 */
{8.9608246834312464e+00, 9.4908803038862288e-13,
	2.2204460492503131e-16, 1.2478906796786760e-13,
	-2.3654411762663585e-12}, /* L954 */
{9.2256563367699940e+00, 9.7816199584599417e-13,
	2.2204460492503131e-16, -4.6707082645980336e-13,
	1.1657341758564144e-13}, /* L955 */
{1.0956592198608931e+01, 1.1629031071436202e-12,
	2.2204460492503131e-16, -8.8273832687946197e-13,
	1.8052226380405045e-13}, /* L956 */
{1.1757578161831949e+01, 1.2492229473082261e-12,
	2.2204460492503131e-16, -9.9920072216264089e-14,
	-1.6686652060116103e-13}, /* L957 */
{9.0923818175040498e+00, 9.6705976559974260e-13,
	2.2204460492503131e-16, 8.6375351315837179e-14,
	3.9701575360595598e-13}, /* L958 */
{1.0311524527743922e+01, 1.0978717934762017e-12,
	2.2204460492503131e-16, 2.5446311724408588e-13,
	-3.1874503036988244e-13}, /* L959 */
{1.0988023080223266e+01, 1.1711187575258464e-12,
	2.2204460492503131e-16, 1.0680345496894006e-13,
	5.0937032369802182e-13}, /* L960 */
{1.2233613323657762e+01, 1.3052336989005653e-12,
	2.2204460492503131e-16, -8.3488771451811772e-14,
	2.6911806116913795e-13}, /* L961 */
{1.1268713322990372e+01, 1.2035372698449009e-12,
	2.2204460492503131e-16, -5.9130478291535837e-13,
	-7.0388139761234925e-13}, /* L962 */
{1.0338527555409900e+01, 1.1053380433168059e-12,
	2.2204460492503131e-16, -1.9872992140790302e-14,
	1.1857181902996672e-13}, /* L963 */
{1.1519322894958071e+01, 1.2328610354828129e-12,
	2.2204460492503131e-16, -2.2759572004815709e-14,
	-8.5154105988749507e-14}, /* L964 */
{9.5663231996994273e+00, 1.0249023851827133e-12,
	2.2204460492503131e-16, -7.8159700933611020e-14,
	1.1390888232654106e-13}, /* L965 */
{9.1590339638132416e+00, 9.8228369882491506e-13,
	2.2204460492503131e-16, -3.2914782011062016e-12,
	-1.2412293415309250e-13}, /* L966 */
{1.1094107749449963e+01, 1.1910472608178679e-12,
	2.2204460492503131e-16, -2.4280577548552174e-13,
	-2.0594637106796654e-13}, /* L967 */
{1.1230374197268963e+01, 1.2069234500700077e-12,
	2.2204460492503131e-16, -8.2156503822261584e-15,
	-6.0174087934683484e-14}, /* L968 */
{1.0535089873573991e+01, 1.1333711746885911e-12,
	2.2204460492503131e-16, 5.7953641885433171e-14,
	1.3544720900426910e-14}, /* L969 */
{9.9985845187902402e+00, 1.0767636782205159e-12,
	2.2204460492503131e-16, -2.9232172238380372e-13,
	-9.0594198809412774e-14}, /* L970 */
{1.0023302770502697e+01, 1.0805384365042414e-12,
	2.2204460492503131e-16, -1.1313172620930345e-13,
	4.7983839124299266e-13}, /* L971 */
{9.7507735988025832e+00, 1.0522416271641077e-12,
	2.2204460492503131e-16, -6.2827520963537609e-13,
	9.0616403269905277e-13}, /* L972 */
{1.0147997964123117e+01, 1.0962342145148796e-12,
	2.2204460492503131e-16, -1.2445600106048005e-13,
	-1.0658141036401503e-14}, /* L973 */
{1.1801337115450147e+01, 1.2761458556553862e-12,
	2.2204460492503131e-16, -7.8281825466319788e-13,
	-5.1048054672264698e-13}, /* L974 */
{1.2242310195685720e+01, 1.3251899577682025e-12,
	2.2204460492503131e-16, 1.4876988529977098e-13,
	9.2148511043887993e-14}, /* L975 */
{8.7484649036903601e+00, 9.4796392957618991e-13,
	2.2204460492503131e-16, -2.4424906541753444e-14,
	-9.2925667161125602e-14}, /* L976 */
{1.2780245064760541e+01, 1.3862574282930140e-12,
	2.2204460492503131e-16, -7.1831429693247628e-14,
	7.5939254884360707e-14}, /* L977 */
{9.7106359325139380e+00, 1.0543788064865112e-12,
	2.2204460492503131e-16, -4.3298697960381105e-14,
	3.9968028886505635e-15}, /* L978 */
{9.3411663636554341e+00, 1.0152989560197057e-12,
	2.2204460492503131e-16, -2.7289281945286348e-13,
	-7.7415851507112166e-13}, /* L979 */
{1.0357655179179771e+01, 1.1269318811457651e-12,
	2.2204460492503131e-16, 1.7823520437332263e-12,
	-1.9468870959826745e-12}, /* L980 */
{1.0340471023728368e+01, 1.1262102361797588e-12,
	2.2204460492503131e-16, -2.7677860003905153e-13,
	5.0781601146354660e-13}, /* L981 */
{9.9831995974076477e+00, 1.0884071421912722e-12,
	2.2204460492503131e-16, -2.8532731732866523e-14,
	-7.2153394370388924e-13}, /* L982 */
{1.2744661812610040e+01, 1.3908874052503961e-12,
	2.2204460492503131e-16, -2.5679458559579871e-13,
	4.6584958113271568e-13}, /* L983 */
{8.8424814829468907e+00, 9.6600505372634871e-13,
	2.2204460492503131e-16, -3.1386004906153175e-13,
	4.5674575233078940e-13}, /* L984 */
{1.1044672309025497e+01, 1.2078116284897078e-12,
	2.2204460492503131e-16, -9.3430818637330049e-12,
	2.1056489885040719e-12}, /* L985 */
{9.2139978273366214e+00, 1.0086376178719547e-12,
	2.2204460492503131e-16, 3.1974423109204508e-14,
	1.4654943925052066e-14}, /* L986 */
{1.1280144150592756e+01, 1.2360668044664180e-12,
	2.2204460492503131e-16, -1.1790568521519162e-13,
	3.6992631180510216e-13}, /* L987 */
{1.0898281580743671e+01, 1.1954326417651373e-12,
	2.2204460492503131e-16, -4.4630965589931293e-13,
	-6.2794214272798854e-13}, /* L988 */
{1.2655715429159192e+01, 1.3896106487720772e-12,
	2.2204460492503131e-16, 4.8516746176119341e-13,
	-5.9530158580400894e-13}, /* L989 */
{9.5666686229096189e+00, 1.0514922266224858e-12,
	2.2204460492503131e-16, -9.4479979395600822e-14,
	-7.0188299616802396e-13}, /* L990 */
{8.6873125735991703e+00, 9.5580487968760508e-13,
	2.2204460492503131e-16, 6.3438143627081445e-13,
	1.0291767438275201e-12}, /* L991 */
{1.0459679558191787e+01, 1.1519674103510624e-12,
	2.2204460492503131e-16, 3.7481129311345285e-13,
	5.7731597280508140e-15}, /* L992 */
{1.0820243904390228e+01, 1.1928791288084994e-12,
	2.2204460492503131e-16, -1.8867130080479910e-12,
	6.0906835130936088e-13}, /* L993 */
{1.1555680179871297e+01, 1.2752403300009263e-12,
	2.2204460492503131e-16, -8.5376150593674538e-14,
	-2.6367796834847468e-13}, /* L994 */
{1.0265328732270897e+01, 1.1339817973521349e-12,
	2.2204460492503131e-16, -1.1868284133242923e-13,
	-2.4003021792395884e-13}, /* L995 */
{1.0766442964636441e+01, 1.1905337826689788e-12,
	2.2204460492503131e-16, -1.4654943925052066e-14,
	-1.7119639039719914e-13}, /* L996 */
{9.9951750629243374e+00, 1.1063580607206802e-12,
	2.2204460492503131e-16, 4.0167869030938164e-13,
	-1.7286172493413687e-13}, /* L997 */
{1.1749626651124208e+01, 1.3018613964632664e-12,
	2.2204460492503131e-16, 1.0369483049998962e-13,
	8.0602191587786365e-14}, /* L998 */
{9.7821591574571816e+00, 1.0849515730271264e-12,
	2.2204460492503131e-16, 3.7303493627405260e-14,
	2.0428103653102880e-14}, /* L999 */
{1.1594252370858722e+01, 1.2872203303260221e-12,
	2.2204460492503131e-16, 5.6843418860808015e-14,
	-1.5809575870662229e-13}, /* L1000 */
{2.1983378150633460e+01, 4.8812898167938101e-12,
	2.2204460492503131e-16, -1.4079071242178998e-11,
	6.2747584905764597e-12}, /* L1001 */
{2.2941625007894267e+01, 7.6410960891948321e-12,
	2.2204460492503131e-16, -1.4295231665073516e-11,
	1.3384848784880887e-12}, /* L1002 */
{3.6929718638981434e+01, 1.6465689922640081e-11,
	2.2204460492503131e-16, -4.2110759324032188e-13,
	-9.1197049911784234e-12}, /* L1003 */
{6.2653900022272765e+01, 3.4779901181281048e-11,
	2.2204460492503131e-16, -3.7617686743374179e-12,
	-4.5450310182104658e-12}, /* L1004 */
{5.1859338561015292e+01, 3.4545259014473473e-11,
	2.2204460492503131e-16, 1.0721423748805137e-11,
	7.5734973847829679e-12}, /* L1005 */
{5.2282465988486251e+01, 4.0724510569356553e-11,
	2.2204460492503131e-16, -2.2302715230182457e-11,
	-1.6463164165259059e-11}, /* L1006 */
{6.5067961186568311e+01, 5.8037574746094833e-11,
	2.2204460492503131e-16, 1.3203882431866987e-11,
	3.1252556098593232e-11}, /* L1007 */
{8.2040444122482839e+01, 8.1974871335432908e-11,
	2.2204460492503131e-16, -8.5555562634453963e-11,
	8.4073792372407752e-10}, /* L1008 */
{8.6584150016362685e+01, 9.6127716897598248e-11,
	2.2204460492503131e-16, -5.8477445108451320e-11,
	1.8993251416077328e-11}, /* L1009 */
#else  /* }  { */



/* Start of SP golden values */


{0.0000000000000000e+00, 0.0000000000000000e+00,
	0.0000000000000000e+00, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L0 */
{0.0000000000000000e+00, 0.0000000000000000e+00,
	1.1920928955078125e-07, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L1 */
{0.0000000000000000e+00, 0.0000000000000000e+00,
	1.1920928955078125e-07, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L2 */
{6.8018096685409546e-01, 1.1920928955078125e-07,
	1.1920928955078125e-07, -5.9604644775390625e-08,
	-1.1920928955078125e-07}, /* L3 */
{8.9273703098297119e-01, 2.0861625671386719e-07,
	1.1920928955078125e-07, -1.1920928955078125e-07,
	-2.3841857910156250e-07}, /* L4 */
{7.1418994665145874e-01, 2.0861625671386719e-07,
	1.1920928955078125e-07, -5.9604644775390625e-08,
	1.1920928955078125e-07}, /* L5 */
{3.6134567856788635e-01, 1.2665987014770508e-07,
	1.1920928955078125e-07, 2.3841857910156250e-07,
	7.1525573730468750e-07}, /* L6 */
{4.3648514151573181e-01, 1.7881393432617188e-07,
	1.1920928955078125e-07, -5.9604644775390625e-08,
	3.5762786865234375e-07}, /* L7 */
{4.7549185156822205e-01, 2.2351741790771484e-07,
	1.1920928955078125e-07, 3.6954879760742188e-06,
	-5.9604644775390625e-07}, /* L8 */
{4.2266038060188293e-01, 2.2351741790771484e-07,
	1.1920928955078125e-07, 4.7683715820312500e-07,
	8.3446502685546875e-07}, /* L9 */
{4.0575435757637024e-01, 2.3841857910156250e-07,
	1.1920928955078125e-07, 3.5762786865234375e-07,
	3.5762786865234375e-07}, /* L10 */
{3.2275927066802979e-01, 2.0861625671386719e-07,
	1.1920928955078125e-07, -1.1920928955078125e-07,
	1.1920928955078125e-07}, /* L11 */
{2.9586255550384521e-01, 2.0861625671386719e-07,
	1.1920928955078125e-07, -1.1920928955078125e-07,
	-2.3841857910156250e-07}, /* L12 */
{7.8410917520523071e-01, 6.0349702835083008e-07,
	1.1920928955078125e-07, 7.1525573730468750e-07,
	-7.1525573730468750e-07}, /* L13 */
{3.5955643653869629e-01, 2.9802322387695312e-07,
	1.1920928955078125e-07, -3.5762786865234375e-07,
	-3.5762786865234375e-07}, /* L14 */
{4.0270313620567322e-01, 3.5762786865234375e-07,
	1.1920928955078125e-07, -2.3841857910156250e-07,
	3.5762786865234375e-07}, /* L15 */
{2.9888099431991577e-01, 2.8312206268310547e-07,
	1.1920928955078125e-07, -7.1525573730468750e-07,
	-1.1920928955078125e-07}, /* L16 */
{5.8850812911987305e-01, 5.9232115745544434e-07,
	1.1920928955078125e-07, -1.7285346984863281e-06,
	3.5762786865234375e-07}, /* L17 */
{5.0337857007980347e-01, 5.3644180297851562e-07,
	1.1920928955078125e-07, -4.7683715820312500e-07,
	-4.7683715820312500e-07}, /* L18 */
{4.5867058634757996e-01, 5.1595270633697510e-07,
	1.1920928955078125e-07, 7.1525573730468750e-07,
	-1.2516975402832031e-06}, /* L19 */
{4.7820881009101868e-01, 5.6624412536621094e-07,
	1.1920928955078125e-07, 0.0000000000000000e+00,
	-1.0728836059570312e-06}, /* L20 */
{9.7883027791976929e-01, 1.2218952178955078e-06,
	1.1920928955078125e-07, 8.3446502685546875e-07,
	2.3841857910156250e-07}, /* L21 */
{4.2159116268157959e-01, 5.5134296417236328e-07,
	1.1920928955078125e-07, -2.6822090148925781e-06,
	-8.9406967163085938e-07}, /* L22 */
{5.0135254859924316e-01, 6.8545341491699219e-07,
	1.1920928955078125e-07, 1.1920928955078125e-07,
	-1.7881393432617188e-07}, /* L23 */
{1.0027021169662476e+00, 1.4305114746093750e-06,
	1.1920928955078125e-07, -3.6954879760742188e-06,
	-2.3841857910156250e-07}, /* L24 */
{7.2194659709930420e-01, 1.0728836059570312e-06,
	1.1920928955078125e-07, -5.3644180297851562e-07,
	4.7683715820312500e-07}, /* L25 */
{3.9529633522033691e-01, 6.1094760894775391e-07,
	1.1920928955078125e-07, -1.6093254089355469e-06,
	1.1920928955078125e-07}, /* L26 */
{5.9419322013854980e-01, 9.5367431640625000e-07,
	1.1920928955078125e-07, 2.2649765014648438e-06,
	0.0000000000000000e+00}, /* L27 */
{5.9087789058685303e-01, 9.8347663879394531e-07,
	1.1920928955078125e-07, 2.2649765014648438e-06,
	-2.9802322387695312e-06}, /* L28 */
{6.3101136684417725e-01, 1.0877847671508789e-06,
	1.1920928955078125e-07, 2.3841857910156250e-07,
	1.1920928955078125e-06}, /* L29 */
{1.1363973617553711e+00, 2.0265579223632812e-06,
	1.1920928955078125e-07, -5.9604644775390625e-07,
	2.3841857910156250e-07}, /* L30 */
{5.0943696498870850e-01, 9.3877315521240234e-07,
	1.1920928955078125e-07, 2.8610229492187500e-06,
	-3.1590461730957031e-06}, /* L31 */
{9.7332048416137695e-01, 1.8514692783355713e-06,
	1.1920928955078125e-07, -5.9604644775390625e-07,
	7.2717666625976562e-06}, /* L32 */
{8.8116312026977539e-01, 1.7285346984863281e-06,
	1.1920928955078125e-07, 1.0728836059570312e-06,
	-1.0132789611816406e-06}, /* L33 */
{1.0469392538070679e+00, 2.1159648895263672e-06,
	1.1920928955078125e-07, 0.0000000000000000e+00,
	-1.7285346984863281e-06}, /* L34 */
{6.3979321718215942e-01, 1.3336539268493652e-06,
	1.1920928955078125e-07, -1.1920928955078125e-07,
	1.4305114746093750e-06}, /* L35 */
{1.0980664491653442e+00, 2.3543834686279297e-06,
	1.1920928955078125e-07, 2.6583671569824219e-05,
	-2.1398067474365234e-05}, /* L36 */
{7.8947657346725464e-01, 1.7397105693817139e-06,
	1.1920928955078125e-07, 3.3378601074218750e-06,
	-1.5497207641601562e-06}, /* L37 */
{1.1061322689056396e+00, 2.5033950805664062e-06,
	1.1920928955078125e-07, 3.0994415283203125e-06,
	1.1920928955078125e-07}, /* L38 */
{1.2958996295928955e+00, 3.0100345611572266e-06,
	1.1920928955078125e-07, -5.9604644775390625e-08,
	-1.6689300537109375e-06}, /* L39 */
{6.1920803785324097e-01, 1.4752149581909180e-06,
	1.1920928955078125e-07, -1.9490718841552734e-05,
	4.4703483581542969e-05}, /* L40 */
{9.3974453210830688e-01, 2.2947788238525391e-06,
	1.1920928955078125e-07, -1.4066696166992188e-05,
	-1.3649463653564453e-05}, /* L41 */
{5.5696403980255127e-01, 1.3932585716247559e-06,
	1.1920928955078125e-07, -5.9604644775390625e-06,
	7.5101852416992188e-06}, /* L42 */
{5.8767557144165039e-01, 1.5050172805786133e-06,
	1.1920928955078125e-07, 2.7418136596679688e-06,
	-1.3113021850585938e-06}, /* L43 */
{9.4389802217483521e-01, 2.4735927581787109e-06,
	1.1920928955078125e-07, -1.6808509826660156e-05,
	9.0599060058593750e-06}, /* L44 */
{9.3407374620437622e-01, 2.5033950805664062e-06,
	1.1920928955078125e-07, -7.7486038208007812e-07,
	-6.1392784118652344e-06}, /* L45 */
{1.6670787334442139e+00, 4.5672059059143066e-06,
	1.1920928955078125e-07, -3.7550926208496094e-06,
	-2.0265579223632812e-06}, /* L46 */
{6.6008597612380981e-01, 1.8477439880371094e-06,
	1.1920928955078125e-07, 0.0000000000000000e+00,
	5.9604644775390625e-07}, /* L47 */
{9.2781543731689453e-01, 2.6524066925048828e-06,
	1.1920928955078125e-07, -4.8875808715820312e-06,
	-1.0728836059570312e-06}, /* L48 */
{8.6735057830810547e-01, 2.5331974029541016e-06,
	1.1920928955078125e-07, 6.6757202148437500e-06,
	-1.1324882507324219e-06}, /* L49 */
{8.6625766754150391e-01, 2.5816261768341064e-06,
	1.1920928955078125e-07, -1.7881393432617188e-06,
	-3.2186508178710938e-06}, /* L50 */
{1.0391687154769897e+00, 3.1590461730957031e-06,
	1.1920928955078125e-07, 7.2717666625976562e-06,
	-2.1994113922119141e-05}, /* L51 */
{1.0913528203964233e+00, 3.3825635910034180e-06,
	1.1920928955078125e-07, 4.7683715820312500e-07,
	3.5762786865234375e-07}, /* L52 */
{1.2523679733276367e+00, 3.9562582969665527e-06,
	1.1920928955078125e-07, -5.1856040954589844e-06,
	1.9073486328125000e-06}, /* L53 */
{6.2963581085205078e-01, 2.0265579223632812e-06,
	1.1920928955078125e-07, 9.5367431640625000e-07,
	4.7683715820312500e-07}, /* L54 */
{5.0682407617568970e-01, 1.6614794731140137e-06,
	1.1920928955078125e-07, 4.7683715820312500e-07,
	9.5367431640625000e-07}, /* L55 */
{1.0089418888092041e+00, 3.3676624298095703e-06,
	1.1920928955078125e-07, -5.9604644775390625e-08,
	-1.0132789611816406e-06}, /* L56 */
{1.5701940059661865e+00, 5.3346157073974609e-06,
	1.1920928955078125e-07, 1.4305114746093750e-06,
	-3.3378601074218750e-06}, /* L57 */
{1.4263415336608887e+00, 4.9322843551635742e-06,
	1.1920928955078125e-07, -1.3816356658935547e-04,
	-7.9035758972167969e-05}, /* L58 */
{1.3898396492004395e+00, 4.8875808715820312e-06,
	1.1920928955078125e-07, -8.0466270446777344e-06,
	-4.9471855163574219e-06}, /* L59 */
{9.5001077651977539e-01, 3.3974647521972656e-06,
	1.1920928955078125e-07, 9.5367431640625000e-07,
	1.5497207641601562e-06}, /* L60 */
{1.0409712791442871e+00, 3.7848949432373047e-06,
	1.1920928955078125e-07, 1.4543533325195312e-05,
	2.7179718017578125e-05}, /* L61 */
{1.2903363704681396e+00, 4.7683715820312500e-06,
	1.1920928955078125e-07, -4.7683715820312500e-07,
	-8.3446502685546875e-07}, /* L62 */
{7.7579402923583984e-01, 2.9131770133972168e-06,
	1.1920928955078125e-07, -2.2053718566894531e-06,
	1.9073486328125000e-06}, /* L63 */
{1.9140597581863403e+00, 7.3015689849853516e-06,
	1.1920928955078125e-07, 4.7683715820312500e-06,
	-1.1086463928222656e-05}, /* L64 */
{1.0586640834808350e+00, 4.1015446186065674e-06,
	1.1920928955078125e-07, 1.1920928955078125e-06,
	-4.7683715820312500e-07}, /* L65 */
{1.0454654693603516e+00, 4.1127204895019531e-06,
	1.1920928955078125e-07, -2.4437904357910156e-06,
	1.9073486328125000e-06}, /* L66 */
{9.0949100255966187e-01, 3.6321580410003662e-06,
	1.1920928955078125e-07, 1.0251998901367188e-05,
	-4.5299530029296875e-06}, /* L67 */
{8.6765336990356445e-01, 3.5166740417480469e-06,
	1.1920928955078125e-07, -1.7881393432617188e-07,
	1.1920928955078125e-06}, /* L68 */
{1.6591906547546387e+00, 6.8247318267822266e-06,
	1.1920928955078125e-07, -6.3300132751464844e-05,
	-1.5711784362792969e-04}, /* L69 */
{1.5803515911102295e+00, 6.5937638282775879e-06,
	1.1920928955078125e-07, 6.4373016357421875e-06,
	3.5762786865234375e-07}, /* L70 */
{1.5871639251708984e+00, 6.7166984081268311e-06,
	1.1920928955078125e-07, -8.3446502685546875e-07,
	-1.0728836059570312e-06}, /* L71 */
{1.5208110809326172e+00, 6.5267086029052734e-06,
	1.1920928955078125e-07, -1.9907951354980469e-05,
	-1.5854835510253906e-05}, /* L72 */
{1.4109665155410767e+00, 6.1392784118652344e-06,
	1.1920928955078125e-07, -5.9604644775390625e-07,
	4.7683715820312500e-07}, /* L73 */
{1.6604399681091309e+00, 7.3239207267761230e-06,
	1.1920928955078125e-07, -8.6426734924316406e-06,
	-1.0132789611816406e-05}, /* L74 */
{1.6600131988525391e+00, 7.4207782745361328e-06,
	1.1920928955078125e-07, 1.5497207641601562e-06,
	2.3841857910156250e-07}, /* L75 */
{1.0657552480697632e+00, 4.8279762268066406e-06,
	1.1920928955078125e-07, -2.7596950531005859e-05,
	-2.5689601898193359e-05}, /* L76 */
{9.7807997465133667e-01, 4.4889748096466064e-06,
	1.1920928955078125e-07, -7.7486038208007812e-07,
	-1.1920928955078125e-07}, /* L77 */
{1.1570127010345459e+00, 5.3793191909790039e-06,
	1.1920928955078125e-07, 3.0994415283203125e-06,
	-2.9563903808593750e-05}, /* L78 */
{1.4557089805603027e+00, 6.8545341491699219e-06,
	1.1920928955078125e-07, 3.5762786865234375e-07,
	4.7683715820312500e-07}, /* L79 */
{1.1683254241943359e+00, 5.5730342864990234e-06,
	1.1920928955078125e-07, -1.6516447067260742e-04,
	-4.8935413360595703e-05}, /* L80 */
{1.2592644691467285e+00, 6.0796737670898438e-06,
	1.1920928955078125e-07, -4.1723251342773438e-07,
	7.1525573730468750e-07}, /* L81 */
{1.0975710153579712e+00, 5.3644180297851562e-06,
	1.1920928955078125e-07, -1.6689300537109375e-06,
	-3.7550926208496094e-06}, /* L82 */
{2.2108526229858398e+00, 1.0937452316284180e-05,
	1.1920928955078125e-07, -1.1324882507324219e-06,
	-1.2516975402832031e-06}, /* L83 */
{2.0297622680664062e+00, 1.0162591934204102e-05,
	1.1920928955078125e-07, 1.5139579772949219e-05,
	-4.1723251342773438e-06}, /* L84 */
{1.5676014423370361e+00, 7.9423189163208008e-06,
	1.1920928955078125e-07, 4.8875808715820312e-06,
	1.5497207641601562e-06}, /* L85 */
{1.3372215032577515e+00, 6.8545341491699219e-06,
	1.1920928955078125e-07, -7.7486038208007812e-07,
	4.7683715820312500e-06}, /* L86 */
{1.4568958282470703e+00, 7.5548887252807617e-06,
	1.1920928955078125e-07, 1.9073486328125000e-06,
	3.9339065551757812e-06}, /* L87 */
{1.2471650838851929e+00, 6.5416097640991211e-06,
	1.1920928955078125e-07, -5.3644180297851562e-07,
	-2.9802322387695312e-07}, /* L88 */
{1.0786615610122681e+00, 5.7220458984375000e-06,
	1.1920928955078125e-07, -2.6822090148925781e-06,
	0.0000000000000000e+00}, /* L89 */
{1.4416582584381104e+00, 7.7337026596069336e-06,
	1.1920928955078125e-07, 1.7404556274414062e-05,
	8.8214874267578125e-06}, /* L90 */
{1.2912023067474365e+00, 7.0035457611083984e-06,
	1.1920928955078125e-07, 6.0796737670898438e-06,
	1.4543533325195312e-05}, /* L91 */
{1.4266119003295898e+00, 7.8231096267700195e-06,
	1.1920928955078125e-07, -1.8596649169921875e-05,
	-5.9604644775390625e-08}, /* L92 */
{1.0443524122238159e+00, 5.7891011238098145e-06,
	1.1920928955078125e-07, 9.0599060058593750e-06,
	1.9073486328125000e-06}, /* L93 */
{8.7233221530914307e-01, 4.8875808715820312e-06,
	1.1920928955078125e-07, -6.9737434387207031e-06,
	2.2649765014648438e-06}, /* L94 */
{1.5466986894607544e+00, 8.7581574916839600e-06,
	1.1920928955078125e-07, -1.6450881958007812e-05,
	1.1801719665527344e-05}, /* L95 */
{1.8489117622375488e+00, 1.0579824447631836e-05,
	1.1920928955078125e-07, 1.0013580322265625e-05,
	2.3841857910156250e-07}, /* L96 */
{2.1134092807769775e+00, 1.2218952178955078e-05,
	1.1920928955078125e-07, -1.3113021850585938e-06,
	1.1920928955078125e-06}, /* L97 */
{1.0867348909378052e+00, 6.3478946685791016e-06,
	1.1920928955078125e-07, -1.8477439880371094e-06,
	-7.2717666625976562e-06}, /* L98 */
{1.6565171480178833e+00, 9.7751617431640625e-06,
	1.1920928955078125e-07, -6.5565109252929688e-06,
	7.2717666625976562e-06}, /* L99 */
{1.5700103044509888e+00, 9.3579292297363281e-06,
	1.1920928955078125e-07, -3.7550926208496094e-06,
	1.9073486328125000e-06}, /* L100 */
{9.6533346176147461e-01, 5.8114528656005859e-06,
	1.1920928955078125e-07, -1.9669532775878906e-05,
	-3.8146972656250000e-06}, /* L101 */
{1.4190838336944580e+00, 8.6277723312377930e-06,
	1.1920928955078125e-07, -9.5367431640625000e-07,
	2.2649765014648438e-06}, /* L102 */
{1.1650413274765015e+00, 7.1525573730468750e-06,
	1.1920928955078125e-07, -4.7683715820312500e-07,
	1.3113021850585938e-06}, /* L103 */
{1.6706761121749878e+00, 1.0356307029724121e-05,
	1.1920928955078125e-07, 1.1920928955078125e-06,
	3.3378601074218750e-06}, /* L104 */
{1.8690253496170044e+00, 1.1697411537170410e-05,
	1.1920928955078125e-07, -1.3530254364013672e-05,
	-5.1259994506835938e-06}, /* L105 */
{1.2451384067535400e+00, 7.8678131103515625e-06,
	1.1920928955078125e-07, 1.6689300537109375e-05,
	-3.8266181945800781e-05}, /* L106 */
{1.4018733501434326e+00, 8.9406967163085938e-06,
	1.1920928955078125e-07, -5.0663948059082031e-06,
	0.0000000000000000e+00}, /* L107 */
{2.1110765933990479e+00, 1.3589859008789062e-05,
	1.1920928955078125e-07, -1.6450881958007812e-05,
	-1.9550323486328125e-05}, /* L108 */
{1.7178971767425537e+00, 1.1160969734191895e-05,
	1.1920928955078125e-07, 5.6028366088867188e-06,
	2.2649765014648438e-06}, /* L109 */
{1.3181906938552856e+00, 8.6426734924316406e-06,
	1.1920928955078125e-07, 8.3446502685546875e-07,
	1.3113021850585938e-06}, /* L110 */
{1.2252202033996582e+00, 8.1062316894531250e-06,
	1.1920928955078125e-07, 1.7881393432617188e-06,
	8.5830688476562500e-06}, /* L111 */
{1.6874964237213135e+00, 1.1265277862548828e-05,
	1.1920928955078125e-07, -3.0994415283203125e-06,
	4.7683715820312500e-06}, /* L112 */
{2.1283390522003174e+00, 1.4334917068481445e-05,
	1.1920928955078125e-07, 1.3113021850585938e-06,
	-3.9339065551757812e-06}, /* L113 */
{1.2017642259597778e+00, 8.1658363342285156e-06,
	1.1920928955078125e-07, -1.6689300537109375e-06,
	-2.0265579223632812e-06}, /* L114 */
{1.8911085128784180e+00, 1.2964010238647461e-05,
	1.1920928955078125e-07, -5.1081180572509766e-05,
	1.7404556274414062e-05}, /* L115 */
{1.6616483926773071e+00, 1.1488795280456543e-05,
	1.1920928955078125e-07, -2.9206275939941406e-06,
	-6.9737434387207031e-06}, /* L116 */
{1.4078015089035034e+00, 9.8198652267456055e-06,
	1.1920928955078125e-07, 6.8426132202148438e-05,
	5.9723854064941406e-05}, /* L117 */
{1.5084152221679688e+00, 1.0609626770019531e-05,
	1.1920928955078125e-07, -5.9604644775390625e-07,
	-5.5551528930664062e-05}, /* L118 */
{1.5756088495254517e+00, 1.1175870895385742e-05,
	1.1920928955078125e-07, 8.3446502685546875e-07,
	-3.0398368835449219e-06}, /* L119 */
{2.3708157539367676e+00, 1.6957521438598633e-05,
	1.1920928955078125e-07, -7.7486038208007812e-07,
	2.1457672119140625e-06}, /* L120 */
{1.5120798349380493e+00, 1.0907649993896484e-05,
	1.1920928955078125e-07, -8.5651874542236328e-05,
	2.5272369384765625e-05}, /* L121 */
{2.7950906753540039e+00, 2.0325183868408203e-05,
	1.1920928955078125e-07, -5.1856040954589844e-06,
	-7.4505805969238281e-06}, /* L122 */
{1.3575928211212158e+00, 9.9539756774902344e-06,
	1.1920928955078125e-07, -1.6272068023681641e-05,
	-1.3530254364013672e-05}, /* L123 */
{1.8224974870681763e+00, 1.3470649719238281e-05,
	1.1920928955078125e-07, -2.4855136871337891e-05,
	-2.3782253265380859e-05}, /* L124 */
{1.3239212036132812e+00, 9.8645687103271484e-06,
	1.1920928955078125e-07, 2.0384788513183594e-05,
	-9.1195106506347656e-06}, /* L125 */
{2.3055584430694580e+00, 1.7315149307250977e-05,
	1.1920928955078125e-07, 1.5497207641601562e-06,
	-6.5565109252929688e-07}, /* L126 */
{1.6377103328704834e+00, 1.2397766113281250e-05,
	1.1920928955078125e-07, 2.3841857910156250e-06,
	-3.2424926757812500e-05}, /* L127 */
{2.5683627128601074e+00, 1.9595026969909668e-05,
	1.1920928955078125e-07, 4.4107437133789062e-06,
	-1.2516975402832031e-06}, /* L128 */
{1.9767295122146606e+00, 1.5199184417724609e-05,
	1.1920928955078125e-07, -8.9406967163085938e-06,
	-5.4836273193359375e-06}, /* L129 */
{1.6994286775588989e+00, 1.3168901205062866e-05,
	1.1920928955078125e-07, 1.6450881958007812e-05,
	6.3180923461914062e-06}, /* L130 */
{1.8375978469848633e+00, 1.4349818229675293e-05,
	1.1920928955078125e-07, -1.6570091247558594e-05,
	-2.0921230316162109e-05}, /* L131 */
{1.8105823993682861e+00, 1.4245510101318359e-05,
	1.1920928955078125e-07, 2.0384788513183594e-05,
	1.2159347534179688e-05}, /* L132 */
{2.3307569026947021e+00, 1.8477439880371094e-05,
	1.1920928955078125e-07, -7.3313713073730469e-06,
	-2.1517276763916016e-05}, /* L133 */
{1.3041013479232788e+00, 1.0415911674499512e-05,
	1.1920928955078125e-07, 3.3378601074218750e-06,
	-4.5299530029296875e-06}, /* L134 */
{2.1185142993927002e+00, 1.7046928405761719e-05,
	1.1920928955078125e-07, -1.9073486328125000e-06,
	-5.3644180297851562e-06}, /* L135 */
{1.6652044057846069e+00, 1.3500452041625977e-05,
	1.1920928955078125e-07, -3.2246112823486328e-05,
	-2.2947788238525391e-05}, /* L136 */
{3.0401215553283691e+00, 2.4825334548950195e-05,
	1.1920928955078125e-07, 7.5101852416992188e-06,
	1.0609626770019531e-05}, /* L137 */
{1.8043446540832520e+00, 1.4841556549072266e-05,
	1.1920928955078125e-07, -1.0132789611816406e-05,
	-1.1742115020751953e-05}, /* L138 */
{2.1798567771911621e+00, 1.8060207366943359e-05,
	1.1920928955078125e-07, -5.0067901611328125e-06,
	3.8146972656250000e-06}, /* L139 */
{1.5401673316955566e+00, 1.2852251529693604e-05,
	1.1920928955078125e-07, -5.0663948059082031e-06,
	1.7881393432617188e-06}, /* L140 */
{2.5070142745971680e+00, 2.1070241928100586e-05,
	1.1920928955078125e-07, 1.3828277587890625e-05,
	1.8954277038574219e-05}, /* L141 */
{1.6487674713134766e+00, 1.3954937458038330e-05,
	1.1920928955078125e-07, -9.8347663879394531e-06,
	-5.4240226745605469e-06}, /* L142 */
{1.4859261512756348e+00, 1.2665987014770508e-05,
	1.1920928955078125e-07, 2.9802322387695312e-06,
	3.9935111999511719e-05}, /* L143 */
{1.6457158327102661e+00, 1.4126300811767578e-05,
	1.1920928955078125e-07, -1.6212463378906250e-05,
	1.3589859008789062e-05}, /* L144 */
{1.8611181974411011e+00, 1.6085803508758545e-05,
	1.1920928955078125e-07, -1.1622905731201172e-05,
	-1.1682510375976562e-05}, /* L145 */
{1.8321113586425781e+00, 1.5944242477416992e-05,
	1.1920928955078125e-07, -2.2232532501220703e-05,
	3.1352043151855469e-05}, /* L146 */
{2.2074513435363770e+00, 1.9341707229614258e-05,
	1.1920928955078125e-07, -2.6404857635498047e-05,
	-2.7418136596679688e-06}, /* L147 */
{2.0101280212402344e+00, 1.7732381820678711e-05,
	1.1920928955078125e-07, -3.1590461730957031e-06,
	-6.9141387939453125e-06}, /* L148 */
{3.4258801937103271e+00, 3.0428171157836914e-05,
	1.1920928955078125e-07, -1.4126300811767578e-05,
	-1.9788742065429688e-05}, /* L149 */
{1.8116010427474976e+00, 1.6197562217712402e-05,
	1.1920928955078125e-07, -1.6093254089355469e-06,
	7.6293945312500000e-06}, /* L150 */
{2.0053453445434570e+00, 1.8049031496047974e-05,
	1.1920928955078125e-07, -3.2126903533935547e-05,
	-1.7106533050537109e-05}, /* L151 */
{2.2388551235198975e+00, 2.0284205675125122e-05,
	1.1920928955078125e-07, -4.6491622924804688e-06,
	-1.3589859008789062e-05}, /* L152 */
{1.6697667837142944e+00, 1.5228986740112305e-05,
	1.1920928955078125e-07, -1.5079975128173828e-05,
	-4.3272972106933594e-05}, /* L153 */
{2.2406351566314697e+00, 2.0567327737808228e-05,
	1.1920928955078125e-07, 1.5735626220703125e-05,
	-9.5367431640625000e-06}, /* L154 */
{2.2467515468597412e+00, 2.0757317543029785e-05,
	1.1920928955078125e-07, -1.4305114746093750e-06,
	5.1259994506835938e-06}, /* L155 */
{2.3745467662811279e+00, 2.2079795598983765e-05,
	1.1920928955078125e-07, 3.7431716918945312e-05,
	-3.6358833312988281e-06}, /* L156 */
{2.0955083370208740e+00, 1.9609928131103516e-05,
	1.1920928955078125e-07, 9.5367431640625000e-07,
	-2.7298927307128906e-05}, /* L157 */
{1.7495329380035400e+00, 1.6480684280395508e-05,
	1.1920928955078125e-07, -1.4305114746093750e-05,
	-4.9769878387451172e-05}, /* L158 */
{2.1758046150207520e+00, 2.0623207092285156e-05,
	1.1920928955078125e-07, 6.1154365539550781e-05,
	-3.0517578125000000e-05}, /* L159 */
{2.2445225715637207e+00, 2.1405518054962158e-05,
	1.1920928955078125e-07, -8.4638595581054688e-06,
	-4.5299530029296875e-06}, /* L160 */
{1.6459550857543945e+00, 1.5795230865478516e-05,
	1.1920928955078125e-07, 3.5762786865234375e-07,
	7.0333480834960938e-06}, /* L161 */
{2.4256405830383301e+00, 2.3423694074153900e-05,
	1.1920928955078125e-07, 3.2901763916015625e-05,
	4.0531158447265625e-06}, /* L162 */
{1.8588899374008179e+00, 1.8060207366943359e-05,
	1.1920928955078125e-07, -1.6927719116210938e-05,
	-7.7486038208007812e-07}, /* L163 */
{2.1371707916259766e+00, 2.0891427993774414e-05,
	1.1920928955078125e-07, -5.3644180297851562e-06,
	-1.3709068298339844e-06}, /* L164 */
{2.0060150623321533e+00, 1.9729137420654297e-05,
	1.1920928955078125e-07, -2.3782253265380859e-05,
	1.1920928955078125e-06}, /* L165 */
{2.0059118270874023e+00, 1.9848346710205078e-05,
	1.1920928955078125e-07, -2.8014183044433594e-05,
	-3.5166740417480469e-05}, /* L166 */
{2.0755820274353027e+00, 2.0660459995269775e-05,
	1.1920928955078125e-07, 4.1723251342773438e-06,
	7.1525573730468750e-07}, /* L167 */
{3.0146615505218506e+00, 3.0189752578735352e-05,
	1.1920928955078125e-07, 3.5405158996582031e-05,
	-1.8298625946044922e-05}, /* L168 */
{3.9156386852264404e+00, 3.9443373680114746e-05,
	1.1920928955078125e-07, -2.9802322387695312e-07,
	1.0251998901367188e-05}, /* L169 */
{2.4558520317077637e+00, 2.4884939193725586e-05,
	1.1920928955078125e-07, 8.3446502685546875e-06,
	-5.3048133850097656e-06}, /* L170 */
{2.8026320934295654e+00, 2.8565526008605957e-05,
	1.1920928955078125e-07, -1.9669532775878906e-06,
	-1.0848045349121094e-05}, /* L171 */
{2.3371465206146240e+00, 2.3961067199707031e-05,
	1.1920928955078125e-07, 2.3841857910156250e-07,
	1.9073486328125000e-06}, /* L172 */
{2.1054863929748535e+00, 2.1710991859436035e-05,
	1.1920928955078125e-07, 4.5299530029296875e-06,
	-3.8146972656250000e-06}, /* L173 */
{2.3062880039215088e+00, 2.3931264877319336e-05,
	1.1920928955078125e-07, 1.1324882507324219e-04,
	-1.0037422180175781e-04}, /* L174 */
{2.5199549198150635e+00, 2.6285648345947266e-05,
	1.1920928955078125e-07, -1.6748905181884766e-05,
	2.2053718566894531e-05}, /* L175 */
{1.5906770229339600e+00, 1.6689300537109375e-05,
	1.1920928955078125e-07, 4.4107437133789062e-05,
	-1.6510486602783203e-05}, /* L176 */
{2.2541122436523438e+00, 2.3782253265380859e-05,
	1.1920928955078125e-07, -3.5464763641357422e-05,
	-6.1392784118652344e-06}, /* L177 */
{1.9265031814575195e+00, 2.0444393157958984e-05,
	1.1920928955078125e-07, -3.2544136047363281e-05,
	-4.9293041229248047e-05}, /* L178 */
{2.2580652236938477e+00, 2.4095177650451660e-05,
	1.1920928955078125e-07, 1.0728836059570312e-05,
	-5.9962272644042969e-05}, /* L179 */
{1.8595248460769653e+00, 1.9952654838562012e-05,
	1.1920928955078125e-07, -2.0265579223632812e-06,
	4.0411949157714844e-05}, /* L180 */
{2.6842482089996338e+00, 2.8960406780242920e-05,
	1.1920928955078125e-07, -2.8252601623535156e-05,
	-1.4364719390869141e-05}, /* L181 */
{2.4145283699035645e+00, 2.6196241378784180e-05,
	1.1920928955078125e-07, 6.4373016357421875e-06,
	-1.0728836059570312e-05}, /* L182 */
{2.0791890621185303e+00, 2.2679567337036133e-05,
	1.1920928955078125e-07, -7.5697898864746094e-06,
	1.8835067749023438e-05}, /* L183 */
{2.7559175491333008e+00, 3.0225142836570740e-05,
	1.1920928955078125e-07, -4.2915344238281250e-06,
	-8.3446502685546875e-07}, /* L184 */
{2.5566635131835938e+00, 2.8196722269058228e-05,
	1.1920928955078125e-07, -9.7632408142089844e-05,
	3.1471252441406250e-05}, /* L185 */
{3.8623738288879395e+00, 4.2855739593505859e-05,
	1.1920928955078125e-07, 3.3819675445556641e-04,
	2.2149085998535156e-04}, /* L186 */
{2.4945464134216309e+00, 2.7805566787719727e-05,
	1.1920928955078125e-07, -1.3232231140136719e-05,
	-3.5762786865234375e-07}, /* L187 */
{2.3874394893646240e+00, 2.6755034923553467e-05,
	1.1920928955078125e-07, 2.1457672119140625e-05,
	5.8412551879882812e-06}, /* L188 */
{3.1719310283660889e+00, 3.5732984542846680e-05,
	1.1920928955078125e-07, -5.9604644775390625e-08,
	-5.6624412536621094e-06}, /* L189 */
{2.5210285186767578e+00, 2.8550624847412109e-05,
	1.1920928955078125e-07, -4.7683715820312500e-06,
	1.0490417480468750e-05}, /* L190 */
{3.5811295509338379e+00, 4.0769577026367188e-05,
	1.1920928955078125e-07, 4.7683715820312500e-06,
	1.8119812011718750e-05}, /* L191 */
{2.6432023048400879e+00, 3.0249357223510742e-05,
	1.1920928955078125e-07, 1.9669532775878906e-05,
	7.0333480834960938e-06}, /* L192 */
{2.3445589542388916e+00, 2.6971101760864258e-05,
	1.1920928955078125e-07, 1.2874603271484375e-05,
	-3.3378601074218750e-06}, /* L193 */
{1.9561572074890137e+00, 2.2619962692260742e-05,
	1.1920928955078125e-07, 2.6226043701171875e-06,
	3.5762786865234375e-07}, /* L194 */
{2.0115103721618652e+00, 2.3379921913146973e-05,
	1.1920928955078125e-07, 8.1062316894531250e-06,
	2.4199485778808594e-05}, /* L195 */
{2.6887228488922119e+00, 3.1411647796630859e-05,
	1.1920928955078125e-07, -4.1723251342773438e-07,
	2.1457672119140625e-06}, /* L196 */
{2.2429711818695068e+00, 2.6345252990722656e-05,
	1.1920928955078125e-07, 1.4436244964599609e-04,
	-5.9545040130615234e-05}, /* L197 */
{2.2017180919647217e+00, 2.5987625122070312e-05,
	1.1920928955078125e-07, 8.4519386291503906e-05,
	-2.4557113647460938e-05}, /* L198 */
{2.1833324432373047e+00, 2.5898218154907227e-05,
	1.1920928955078125e-07, -4.7147274017333984e-05,
	1.9073486328125000e-05}, /* L199 */
{2.7066788673400879e+00, 3.2275915145874023e-05,
	1.1920928955078125e-07, 9.6917152404785156e-05,
	3.7431716918945312e-05}, /* L200 */
{2.2679762840270996e+00, 2.7172267436981201e-05,
	1.1920928955078125e-07, -2.0503997802734375e-05,
	-8.4042549133300781e-06}, /* L201 */
{2.2597937583923340e+00, 2.7209520339965820e-05,
	1.1920928955078125e-07, -2.0682811737060547e-05,
	-3.0577182769775391e-05}, /* L202 */
{2.4088115692138672e+00, 2.9146671295166016e-05,
	1.1920928955078125e-07, 1.5497207641601562e-05,
	-4.5895576477050781e-06}, /* L203 */
{2.9950757026672363e+00, 3.6418437957763672e-05,
	1.1920928955078125e-07, -1.2636184692382812e-05,
	-1.7046928405761719e-05}, /* L204 */
{2.5846471786499023e+00, 3.1664967536926270e-05,
	1.1920928955078125e-07, 1.7772912979125977e-03,
	-2.7197599411010742e-04}, /* L205 */
{2.6067717075347900e+00, 3.2007694244384766e-05,
	1.1920928955078125e-07, 1.5258789062500000e-05,
	-6.2584877014160156e-06}, /* L206 */
{2.1771912574768066e+00, 2.6863068342208862e-05,
	1.1920928955078125e-07, -2.2053718566894531e-06,
	1.3709068298339844e-05}, /* L207 */
{3.1068594455718994e+00, 3.8519501686096191e-05,
	1.1920928955078125e-07, 1.5497207641601562e-05,
	-6.7353248596191406e-06}, /* L208 */
{2.5741207599639893e+00, 3.2067298889160156e-05,
	1.1920928955078125e-07, -8.5830688476562500e-06,
	1.5974044799804688e-05}, /* L209 */
{3.2612531185150146e+00, 4.0821731090545654e-05,
	1.1920928955078125e-07, -6.0200691223144531e-06,
	-2.6702880859375000e-05}, /* L210 */
{3.1061952114105225e+00, 3.9067119359970093e-05,
	1.1920928955078125e-07, 1.5139579772949219e-05,
	-3.5762786865234375e-07}, /* L211 */
{3.9090692996978760e+00, 4.9397349357604980e-05,
	1.1920928955078125e-07, -8.5830688476562500e-06,
	-2.5033950805664062e-06}, /* L212 */
{2.9082803726196289e+00, 3.6925077438354492e-05,
	1.1920928955078125e-07, -2.3841857910156250e-07,
	-6.5565109252929688e-07}, /* L213 */
{2.2300553321838379e+00, 2.8446316719055176e-05,
	1.1920928955078125e-07, -1.8239021301269531e-05,
	-3.7372112274169922e-05}, /* L214 */
{3.8737306594848633e+00, 4.9658119678497314e-05,
	1.1920928955078125e-07, -5.2392482757568359e-05,
	-1.5497207641601562e-05}, /* L215 */
{2.3996686935424805e+00, 3.0897557735443115e-05,
	1.1920928955078125e-07, -7.5757503509521484e-05,
	-2.1457672119140625e-05}, /* L216 */
{3.0302970409393311e+00, 3.9309263229370117e-05,
	1.1920928955078125e-07, 1.3022422790527344e-03,
	-4.0930509567260742e-04}, /* L217 */
{2.0802607536315918e+00, 2.7030706405639648e-05,
	1.1920928955078125e-07, 5.4836273193359375e-06,
	5.8412551879882812e-06}, /* L218 */
{3.0661604404449463e+00, 4.0024518966674805e-05,
	1.1920928955078125e-07, 1.5497207641601562e-06,
	8.7022781372070312e-06}, /* L219 */
{2.2863128185272217e+00, 2.9981136322021484e-05,
	1.1920928955078125e-07, 1.6331672668457031e-05,
	-7.5697898864746094e-06}, /* L220 */
{3.1289212703704834e+00, 4.1216611862182617e-05,
	1.1920928955078125e-07, 2.6226043701171875e-06,
	1.0728836059570312e-05}, /* L221 */
{2.9346113204956055e+00, 3.8832426071166992e-05,
	1.1920928955078125e-07, -5.3644180297851562e-06,
	-1.4662742614746094e-05}, /* L222 */
{2.3267719745635986e+00, 3.0927360057830811e-05,
	1.1920928955078125e-07, -1.1086463928222656e-05,
	8.1062316894531250e-06}, /* L223 */
{2.2917885780334473e+00, 3.0666589736938477e-05,
	1.1920928955078125e-07, -5.5700540542602539e-04,
	-1.0199546813964844e-03}, /* L224 */
{2.6463797092437744e+00, 3.5494565963745117e-05,
	1.1920928955078125e-07, -9.2387199401855469e-05,
	2.7060508728027344e-05}, /* L225 */
{3.1678485870361328e+00, 4.2676925659179688e-05,
	1.1920928955078125e-07, -6.3180923461914062e-06,
	-2.4437904357910156e-06}, /* L226 */
{3.2464599609375000e+00, 4.3928623199462891e-05,
	1.1920928955078125e-07, -1.5497207641601562e-05,
	3.7074089050292969e-05}, /* L227 */
{3.2306761741638184e+00, 4.3913722038269043e-05,
	1.1920928955078125e-07, -7.1525573730468750e-06,
	2.9206275939941406e-05}, /* L228 */
{2.3965263366699219e+00, 3.2735988497734070e-05,
	1.1920928955078125e-07, -2.4777650833129883e-04,
	1.2147426605224609e-04}, /* L229 */
{3.2906377315521240e+00, 4.5120716094970703e-05,
	1.1920928955078125e-07, -3.4153461456298828e-05,
	-2.9683113098144531e-05}, /* L230 */
{3.3776614665985107e+00, 4.6506524085998535e-05,
	1.1920928955078125e-07, -3.5166740417480469e-06,
	1.7881393432617188e-06}, /* L231 */
{2.7369720935821533e+00, 3.7848949432373047e-05,
	1.1920928955078125e-07, -1.0728836059570312e-06,
	-1.0132789611816406e-05}, /* L232 */
{4.4909911155700684e+00, 6.2376260757446289e-05,
	1.1920928955078125e-07, 1.1205673217773438e-05,
	-2.4378299713134766e-05}, /* L233 */
{2.6878952980041504e+00, 3.7491321563720703e-05,
	1.1920928955078125e-07, -4.3272972106933594e-05,
	-4.2140483856201172e-05}, /* L234 */
{2.1084623336791992e+00, 2.9534101486206055e-05,
	1.1920928955078125e-07, -1.0192394256591797e-05,
	1.3828277587890625e-05}, /* L235 */
{2.8241481781005859e+00, 3.9726495742797852e-05,
	1.1920928955078125e-07, 2.8610229492187500e-06,
	-3.1590461730957031e-06}, /* L236 */
{3.9472033977508545e+00, 5.5767595767974854e-05,
	1.1920928955078125e-07, 8.8214874267578125e-06,
	4.2200088500976562e-05}, /* L237 */
{2.7856087684631348e+00, 3.9517879486083984e-05,
	1.1920928955078125e-07, 2.7418136596679688e-06,
	-2.5153160095214844e-05}, /* L238 */
{3.1797544956207275e+00, 4.5299530029296875e-05,
	1.1920928955078125e-07, 4.0054321289062500e-05,
	4.0769577026367188e-05}, /* L239 */
{3.2002224922180176e+00, 4.5806169509887695e-05,
	1.1920928955078125e-07, 3.5643577575683594e-05,
	1.0037422180175781e-04}, /* L240 */
{2.9428439140319824e+00, 4.2289495468139648e-05,
	1.1920928955078125e-07, -5.0783157348632812e-05,
	3.9577484130859375e-05}, /* L241 */
{3.3541893959045410e+00, 4.8384070396423340e-05,
	1.1920928955078125e-07, -2.4616718292236328e-05,
	-5.4121017456054688e-05}, /* L242 */
{3.0121967792510986e+00, 4.3645501136779785e-05,
	1.1920928955078125e-07, -2.5999546051025391e-04,
	-1.1211633682250977e-04}, /* L243 */
{2.7211909294128418e+00, 3.9577484130859375e-05,
	1.1920928955078125e-07, -1.9967555999755859e-05,
	1.7881393432617188e-06}, /* L244 */
{2.6671855449676514e+00, 3.8951635360717773e-05,
	1.1920928955078125e-07, 4.1365623474121094e-05,
	9.5367431640625000e-07}, /* L245 */
{3.5121285915374756e+00, 5.1498413085937500e-05,
	1.1920928955078125e-07, 1.6093254089355469e-05,
	3.4570693969726562e-06}, /* L246 */
{2.9267933368682861e+00, 4.3094158172607422e-05,
	1.1920928955078125e-07, -7.1227550506591797e-05,
	-6.4253807067871094e-05}, /* L247 */
{2.5106649398803711e+00, 3.7118792533874512e-05,
	1.1920928955078125e-07, 2.5391578674316406e-05,
	1.5211105346679688e-04}, /* L248 */
{2.4577031135559082e+00, 3.6492943763732910e-05,
	1.1920928955078125e-07, -4.3272972106933594e-05,
	-3.0696392059326172e-05}, /* L249 */
{3.2924635410308838e+00, 4.9069523811340332e-05,
	1.1920928955078125e-07, -6.5565109252929688e-05,
	-1.0550022125244141e-05}, /* L250 */
{3.1647403240203857e+00, 4.7355890274047852e-05,
	1.1920928955078125e-07, 2.5033950805664062e-06,
	5.3405761718750000e-05}, /* L251 */
{2.5652899742126465e+00, 3.8534402847290039e-05,
	1.1920928955078125e-07, 1.5497207641601562e-05,
	-7.1525573730468750e-06}, /* L252 */
{3.0589282512664795e+00, 4.6133995056152344e-05,
	1.1920928955078125e-07, -1.3053417205810547e-05,
	-6.1035156250000000e-05}, /* L253 */
{3.4289965629577637e+00, 5.1915645599365234e-05,
	1.1920928955078125e-07, -3.9935111999511719e-06,
	3.8862228393554688e-05}, /* L254 */
{3.9899127483367920e+00, 6.0647726058959961e-05,
	1.1920928955078125e-07, -2.8550624847412109e-05,
	-3.5762786865234375e-07}, /* L255 */
{2.8133091926574707e+00, 4.2930245399475098e-05,
	1.1920928955078125e-07, 1.9907951354980469e-05,
	-2.7418136596679688e-06}, /* L256 */
{3.9885497093200684e+00, 6.1154365539550781e-05,
	1.1920928955078125e-07, -1.3113021850585938e-05,
	-1.2624263763427734e-04}, /* L257 */
{3.2745540142059326e+00, 5.0365924835205078e-05,
	1.1920928955078125e-07, 4.5299530029296875e-06,
	-7.9214572906494141e-05}, /* L258 */
{3.7721002101898193e+00, 5.8233737945556641e-05,
	1.1920928955078125e-07, -7.3909759521484375e-06,
	-5.7220458984375000e-06}, /* L259 */
{2.6515526771545410e+00, 4.1097402572631836e-05,
	1.1920928955078125e-07, 3.5762786865234375e-05,
	-3.0398368835449219e-06}, /* L260 */
{3.4728057384490967e+00, 5.4038457165006548e-05,
	1.1920928955078125e-07, 3.2305717468261719e-05,
	5.8412551879882812e-05}, /* L261 */
{3.1954014301300049e+00, 4.9918889999389648e-05,
	1.1920928955078125e-07, 2.6404857635498047e-04,
	-4.2200088500976562e-05}, /* L262 */
{2.8266370296478271e+00, 4.4316053390502930e-05,
	1.1920928955078125e-07, 8.2850456237792969e-05,
	-9.8943710327148438e-05}, /* L263 */
{2.8690671920776367e+00, 4.5150518417358398e-05,
	1.1920928955078125e-07, 3.4570693969726562e-06,
	4.6730041503906250e-05}, /* L264 */
{2.6714525222778320e+00, 4.2200088500976562e-05,
	1.1920928955078125e-07, -4.5895576477050781e-05,
	-4.2438507080078125e-05}, /* L265 */
{2.8428514003753662e+00, 4.5076012611389160e-05,
	1.1920928955078125e-07, 2.8848648071289062e-05,
	3.2186508178710938e-05}, /* L266 */
{4.0063519477844238e+00, 6.3806772232055664e-05,
	1.1920928955078125e-07, -1.6617774963378906e-04,
	-6.4373016357421875e-05}, /* L267 */
{3.2946927547454834e+00, 5.2630901336669922e-05,
	1.1920928955078125e-07, 1.0490417480468750e-05,
	-7.8082084655761719e-06}, /* L268 */
{3.0960786342620850e+00, 4.9680471420288086e-05,
	1.1920928955078125e-07, 7.1644783020019531e-05,
	-6.1631202697753906e-05}, /* L269 */
{2.4616773128509521e+00, 3.9622187614440918e-05,
	1.1920928955078125e-07, -7.1704387664794922e-05,
	-3.8206577301025391e-05}, /* L270 */
{3.2490193843841553e+00, 5.2481889724731445e-05,
	1.1920928955078125e-07, -1.0132789611816406e-06,
	-1.1265277862548828e-05}, /* L271 */
{2.6045920848846436e+00, 4.2229890823364258e-05,
	1.1920928955078125e-07, -1.6033649444580078e-05,
	2.0623207092285156e-05}, /* L272 */
{2.3881592750549316e+00, 3.8862228393554688e-05,
	1.1920928955078125e-07, -6.3776969909667969e-06,
	2.3841857910156250e-07}, /* L273 */
{3.6916511058807373e+00, 6.0304999351501465e-05,
	1.1920928955078125e-07, -4.5359134674072266e-05,
	-3.9517879486083984e-05}, /* L274 */
{2.8544161319732666e+00, 4.6789646148681641e-05,
	1.1920928955078125e-07, 9.0599060058593750e-06,
	1.4305114746093750e-05}, /* L275 */
{4.3295445442199707e+00, 7.1227550506591797e-05,
	1.1920928955078125e-07, 2.0265579223632812e-06,
	8.9406967163085938e-06}, /* L276 */
{2.2030730247497559e+00, 3.6388635635375977e-05,
	1.1920928955078125e-07, 1.5389919281005859e-04,
	-1.6170740127563477e-04}, /* L277 */
{4.3234281539916992e+00, 7.1644783020019531e-05,
	1.1920928955078125e-07, -2.2590160369873047e-05,
	-4.7683715820312500e-07}, /* L278 */
{4.7633819580078125e+00, 7.9214572906494141e-05,
	1.1920928955078125e-07, -1.1861324310302734e-05,
	-4.1127204895019531e-06}, /* L279 */
{3.1802918910980225e+00, 5.3096562623977661e-05,
	1.1920928955078125e-07, -1.5914440155029297e-05,
	-1.7881393432617188e-06}, /* L280 */
{3.4567997455596924e+00, 5.7905912399291992e-05,
	1.1920928955078125e-07, 1.6689300537109375e-05,
	5.6743621826171875e-05}, /* L281 */
{3.4324822425842285e+00, 5.7697296142578125e-05,
	1.1920928955078125e-07, -3.5047531127929688e-05,
	1.5497207641601562e-05}, /* L282 */
{5.1921296119689941e+00, 8.7678432464599609e-05,
	1.1920928955078125e-07, 1.6689300537109375e-06,
	-1.8262863159179688e-04}, /* L283 */
{2.6907644271850586e+00, 4.5552849769592285e-05,
	1.1920928955078125e-07, -3.0994415283203125e-06,
	3.6478042602539062e-05}, /* L284 */
{3.4548406600952148e+00, 5.8695673942565918e-05,
	1.1920928955078125e-07, -3.4868717193603516e-05,
	-1.7583370208740234e-05}, /* L285 */
{2.9035649299621582e+00, 4.9501657485961914e-05,
	1.1920928955078125e-07, -9.4711780548095703e-05,
	-1.3232231140136719e-05}, /* L286 */
{3.0586924552917480e+00, 5.2325427532196045e-05,
	1.1920928955078125e-07, 2.7179718017578125e-05,
	9.0599060058593750e-06}, /* L287 */
{3.5607805252075195e+00, 6.1243772506713867e-05,
	1.1920928955078125e-07, -1.4287233352661133e-04,
	2.9850006103515625e-04}, /* L288 */
{5.1356911659240723e+00, 8.8468194007873535e-05,
	1.1920928955078125e-07, 1.7881393432617188e-06,
	4.5299530029296875e-06}, /* L289 */
{3.6223025321960449e+00, 6.2614679336547852e-05,
	1.1920928955078125e-07, -9.1791152954101562e-06,
	-5.1259994506835938e-06}, /* L290 */
{3.7404465675354004e+00, 6.4879655838012695e-05,
	1.1920928955078125e-07, -3.3438205718994141e-05,
	-2.5629997253417969e-05}, /* L291 */
{4.8947043418884277e+00, 8.5204839706420898e-05,
	1.1920928955078125e-07, 6.3300132751464844e-05,
	-9.7453594207763672e-05}, /* L292 */
{3.4655468463897705e+00, 6.0528516769409180e-05,
	1.1920928955078125e-07, 2.0503997802734375e-05,
	-1.1384487152099609e-05}, /* L293 */
{3.5683181285858154e+00, 6.2555074691772461e-05,
	1.1920928955078125e-07, 9.0360641479492188e-05,
	-3.3938884735107422e-04}, /* L294 */
{3.6346430778503418e+00, 6.4045190811157227e-05,
	1.1920928955078125e-07, 2.4902820587158203e-04,
	6.7687034606933594e-04}, /* L295 */
{3.9862954616546631e+00, 7.0333480834960938e-05,
	1.1920928955078125e-07, 5.3644180297851562e-06,
	1.8477439880371094e-05}, /* L296 */
{3.6915864944458008e+00, 6.5356492996215820e-05,
	1.1920928955078125e-07, -2.9802322387695312e-06,
	-1.1265277862548828e-05}, /* L297 */
{4.4570188522338867e+00, 7.9184770584106445e-05,
	1.1920928955078125e-07, 1.5735626220703125e-05,
	6.4134597778320312e-05}, /* L298 */
{3.4038407802581787e+00, 6.0670077800750732e-05,
	1.1920928955078125e-07, 4.5061111450195312e-05,
	-5.6445598602294922e-05}, /* L299 */
{3.7514643669128418e+00, 6.7129731178283691e-05,
	1.1920928955078125e-07, 3.3497810363769531e-04,
	-3.8534402847290039e-04}, /* L300 */
{4.8985590934753418e+00, 8.7898224592208862e-05,
	1.1920928955078125e-07, -8.8691711425781250e-05,
	-1.8298625946044922e-05}, /* L301 */
{3.0060222148895264e+00, 5.4121017456054688e-05,
	1.1920928955078125e-07, -8.8810920715332031e-06,
	2.4318695068359375e-05}, /* L302 */
{3.1448967456817627e+00, 5.6803226470947266e-05,
	1.1920928955078125e-07, 2.2411346435546875e-05,
	-3.7848949432373047e-05}, /* L303 */
{3.0179142951965332e+00, 5.4687261581420898e-05,
	1.1920928955078125e-07, 2.7060508728027344e-05,
	1.6689300537109375e-06}, /* L304 */
{3.2232899665832520e+00, 5.8598816394805908e-05,
	1.1920928955078125e-07, -3.1590461730957031e-06,
	1.0728836059570312e-06}, /* L305 */
{3.7025220394134521e+00, 6.7532062530517578e-05,
	1.1920928955078125e-07, -4.1723251342773438e-06,
	6.4373016357421875e-06}, /* L306 */
{3.7982063293457031e+00, 6.9528818130493164e-05,
	1.1920928955078125e-07, -1.3232231140136719e-05,
	4.0531158447265625e-05}, /* L307 */
{3.4702069759368896e+00, 6.3717365264892578e-05,
	1.1920928955078125e-07, 1.6450881958007812e-05,
	-4.1186809539794922e-05}, /* L308 */
{3.5174129009246826e+00, 6.4797699451446533e-05,
	1.1920928955078125e-07, 3.9219856262207031e-05,
	-5.2630901336669922e-05}, /* L309 */
{3.6881618499755859e+00, 6.8157911300659180e-05,
	1.1920928955078125e-07, -7.0512294769287109e-05,
	3.5166740417480469e-05}, /* L310 */
{3.3597378730773926e+00, 6.2286853790283203e-05,
	1.1920928955078125e-07, -3.7491321563720703e-05,
	3.6954879760742188e-06}, /* L311 */
{4.3004426956176758e+00, 7.9989433288574219e-05,
	1.1920928955078125e-07, -1.6421079635620117e-04,
	-9.7155570983886719e-06}, /* L312 */
{4.0768499374389648e+00, 7.6076015830039978e-05,
	1.1920928955078125e-07, 1.8787384033203125e-04,
	9.6559524536132812e-05}, /* L313 */
{3.7974717617034912e+00, 7.1078538894653320e-05,
	1.1920928955078125e-07, 2.2172927856445312e-05,
	3.3259391784667969e-05}, /* L314 */
{4.2243967056274414e+00, 7.9318881034851074e-05,
	1.1920928955078125e-07, 2.2768974304199219e-05,
	-4.1663646697998047e-05}, /* L315 */
{5.3682155609130859e+00, 1.0111927986145020e-04,
	1.1920928955078125e-07, -2.4855136871337891e-05,
	-3.9458274841308594e-05}, /* L316 */
{4.9082832336425781e+00, 9.2744827270507812e-05,
	1.1920928955078125e-07, 2.5272369384765625e-05,
	-5.5432319641113281e-06}, /* L317 */
{2.9920537471771240e+00, 5.6713819503784180e-05,
	1.1920928955078125e-07, -1.4245510101318359e-05,
	1.5258789062500000e-05}, /* L318 */
{3.3885791301727295e+00, 6.4432621002197266e-05,
	1.1920928955078125e-07, -8.1658363342285156e-06,
	-2.0802021026611328e-05}, /* L319 */
{3.8027205467224121e+00, 7.2538852691650391e-05,
	1.1920928955078125e-07, 5.7220458984375000e-06,
	5.0187110900878906e-05}, /* L320 */
{2.7722573280334473e+00, 5.3077936172485352e-05,
	1.1920928955078125e-07, 6.8318843841552734e-04,
	-2.4962425231933594e-04}, /* L321 */
{3.8224706649780273e+00, 7.3373317718505859e-05,
	1.1920928955078125e-07, -5.0485134124755859e-05,
	-4.8279762268066406e-05}, /* L322 */
{4.5435948371887207e+00, 8.7514519691467285e-05,
	1.1920928955078125e-07, 3.4570693969726562e-05,
	-2.6881694793701172e-05}, /* L323 */
{4.2382225990295410e+00, 8.1922858953475952e-05,
	1.1920928955078125e-07, 1.9788742065429688e-04,
	3.7908554077148438e-05}, /* L324 */
{4.3274693489074707e+00, 8.3833932876586914e-05,
	1.1920928955078125e-07, -6.1988830566406250e-06,
	-1.9073486328125000e-06}, /* L325 */
{4.7026472091674805e+00, 9.1388821601867676e-05,
	1.1920928955078125e-07, 6.4969062805175781e-05,
	-4.4107437133789062e-05}, /* L326 */
{4.4588904380798340e+00, 8.6933374404907227e-05,
	1.1920928955078125e-07, 1.2874603271484375e-05,
	-1.8060207366943359e-05}, /* L327 */
{3.7090687751770020e+00, 7.2531402111053467e-05,
	1.1920928955078125e-07, -6.6876411437988281e-05,
	-3.1006336212158203e-04}, /* L328 */
{3.5113313198089600e+00, 6.8858265876770020e-05,
	1.1920928955078125e-07, 5.1259994506835938e-06,
	-2.4437904357910156e-06}, /* L329 */
{5.0451388359069824e+00, 9.9241733551025391e-05,
	1.1920928955078125e-07, -8.2969665527343750e-05,
	9.4175338745117188e-06}, /* L330 */
{3.4708690643310547e+00, 6.8482011556625366e-05,
	1.1920928955078125e-07, 1.1920928955078125e-06,
	1.2278556823730469e-05}, /* L331 */
{3.8523159027099609e+00, 7.6234340667724609e-05,
	1.1920928955078125e-07, -1.6272068023681641e-05,
	1.9907951354980469e-05}, /* L332 */
{3.5042610168457031e+00, 6.9677829742431641e-05,
	1.1920928955078125e-07, 3.4904479980468750e-04,
	8.2099437713623047e-04}, /* L333 */
{5.5407176017761230e+00, 1.1035799980163574e-04,
	1.1920928955078125e-07, 1.5580654144287109e-04,
	4.5537948608398438e-05}, /* L334 */
{3.9966633319854736e+00, 7.9810619354248047e-05,
	1.1920928955078125e-07, -1.0967254638671875e-05,
	1.1920928955078125e-06}, /* L335 */
{3.8346590995788574e+00, 7.6800584793090820e-05,
	1.1920928955078125e-07, -6.9141387939453125e-06,
	2.1457672119140625e-06}, /* L336 */
{4.8391766548156738e+00, 9.7423791885375977e-05,
	1.1920928955078125e-07, -3.6931037902832031e-04,
	6.6184997558593750e-04}, /* L337 */
{4.3429594039916992e+00, 8.7499618530273438e-05,
	1.1920928955078125e-07, 5.5670738220214844e-05,
	5.7220458984375000e-06}, /* L338 */
{3.3892314434051514e+00, 6.8500638008117676e-05,
	1.1920928955078125e-07, -2.9265880584716797e-05,
	1.8596649169921875e-05}, /* L339 */
{5.5310215950012207e+00, 1.1214986443519592e-04,
	1.1920928955078125e-07, 1.2528896331787109e-04,
	1.8215179443359375e-04}, /* L340 */
{4.4030752182006836e+00, 8.9496374130249023e-05,
	1.1920928955078125e-07, 3.2544136047363281e-05,
	1.7166137695312500e-05}, /* L341 */
{3.3986732959747314e+00, 6.9290399551391602e-05,
	1.1920928955078125e-07, -4.5359134674072266e-05,
	2.4557113647460938e-05}, /* L342 */
{5.0069704055786133e+00, 1.0237097740173340e-04,
	1.1920928955078125e-07, 1.9669532775878906e-05,
	3.8146972656250000e-06}, /* L343 */
{5.0666346549987793e+00, 1.0389089584350586e-04,
	1.1920928955078125e-07, -2.5212764739990234e-05,
	-1.7881393432617188e-05}, /* L344 */
{3.3330473899841309e+00, 6.8545341491699219e-05,
	1.1920928955078125e-07, -1.0430812835693359e-05,
	-3.4391880035400391e-05}, /* L345 */
{4.5079722404479980e+00, 9.2975795269012451e-05,
	1.1920928955078125e-07, 3.7550926208496094e-05,
	3.5881996154785156e-05}, /* L346 */
{3.9093413352966309e+00, 8.0868601799011230e-05,
	1.1920928955078125e-07, 5.4359436035156250e-05,
	3.7908554077148438e-05}, /* L347 */
{3.1478652954101562e+00, 6.5386295318603516e-05,
	1.1920928955078125e-07, 9.7274780273437500e-05,
	-4.7415494918823242e-04}, /* L348 */
{4.0143284797668457e+00, 8.3528459072113037e-05,
	1.1920928955078125e-07, 3.0875205993652344e-05,
	-1.2463331222534180e-04}, /* L349 */
{4.4092125892639160e+00, 9.1999769210815430e-05,
	1.1920928955078125e-07, 2.7179718017578125e-05,
	3.6120414733886719e-05}, /* L350 */
{3.3387920856475830e+00, 6.9856643676757812e-05,
	1.1920928955078125e-07, -2.2053718566894531e-06,
	-3.6299228668212891e-05}, /* L351 */
{3.1700742244720459e+00, 6.6518783569335938e-05,
	1.1920928955078125e-07, -2.4080276489257812e-05,
	-2.1278858184814453e-05}, /* L352 */
{4.5285348892211914e+00, 9.5322728157043457e-05,
	1.1920928955078125e-07, -1.9735097885131836e-04,
	-2.1260976791381836e-04}, /* L353 */
{3.8902375698089600e+00, 8.2105398178100586e-05,
	1.1920928955078125e-07, -3.4987926483154297e-05,
	-2.2774934768676758e-04}, /* L354 */
{5.9693474769592285e+00, 1.2639164924621582e-04,
	1.1920928955078125e-07, 9.7990036010742188e-05,
	6.6554546356201172e-04}, /* L355 */
{3.8052601814270020e+00, 8.0764293670654297e-05,
	1.1920928955078125e-07, 1.0442733764648438e-04,
	2.7894973754882812e-05}, /* L356 */
{5.5374474525451660e+00, 1.1783838272094727e-04,
	1.1920928955078125e-07, -6.9260597229003906e-05,
	-5.9604644775390625e-08}, /* L357 */
{5.7943048477172852e+00, 1.2364983558654785e-04,
	1.1920928955078125e-07, -2.8192996978759766e-05,
	-8.1062316894531250e-06}, /* L358 */
{3.5224900245666504e+00, 7.5377523899078369e-05,
	1.1920928955078125e-07, 1.3113021850585938e-05,
	-2.9325485229492188e-05}, /* L359 */
{4.7852396965026855e+00, 1.0269880294799805e-04,
	1.1920928955078125e-07, -8.2194805145263672e-05,
	3.0994415283203125e-05}, /* L360 */
{3.1999924182891846e+00, 6.8858265876770020e-05,
	1.1920928955078125e-07, 1.5854835510253906e-05,
	-9.0599060058593750e-06}, /* L361 */
{5.3147287368774414e+00, 1.1467933654785156e-04,
	1.1920928955078125e-07, 8.4638595581054688e-06,
	-1.8000602722167969e-05}, /* L362 */
{4.5411243438720703e+00, 9.8258256912231445e-05,
	1.1920928955078125e-07, 6.0796737670898438e-06,
	2.4199485778808594e-05}, /* L363 */
{6.0253739356994629e+00, 1.3077259063720703e-04,
	1.1920928955078125e-07, 4.4703483581542969e-05,
	-7.3552131652832031e-05}, /* L364 */
{4.5652756690979004e+00, 9.9360942840576172e-05,
	1.1920928955078125e-07, -3.6001205444335938e-05,
	1.4925003051757812e-04}, /* L365 */
{3.6036715507507324e+00, 7.8618526458740234e-05,
	1.1920928955078125e-07, 9.1791152954101562e-06,
	1.3589859008789062e-05}, /* L366 */
{3.7273740768432617e+00, 8.1539154052734375e-05,
	1.1920928955078125e-07, -1.6093254089355469e-06,
	3.7431716918945312e-05}, /* L367 */
{4.2446775436401367e+00, 9.3109905719757080e-05,
	1.1920928955078125e-07, 1.1205673217773438e-05,
	1.6689300537109375e-06}, /* L368 */
{4.3426260948181152e+00, 9.5516443252563477e-05,
	1.1920928955078125e-07, -3.6954879760742188e-05,
	-1.2695789337158203e-05}, /* L369 */
{4.3134078979492188e+00, 9.5129013061523438e-05,
	1.1920928955078125e-07, -8.5830688476562500e-06,
	-1.6331672668457031e-05}, /* L370 */
{4.0775294303894043e+00, 9.0181827545166016e-05,
	1.1920928955078125e-07, -5.8531761169433594e-05,
	3.7789344787597656e-05}, /* L371 */
{5.4049725532531738e+00, 1.1985003948211670e-04,
	1.1920928955078125e-07, 1.5616416931152344e-05,
	2.9444694519042969e-05}, /* L372 */
{4.2379403114318848e+00, 9.4234943389892578e-05,
	1.1920928955078125e-07, -2.5629997253417969e-06,
	3.2544136047363281e-05}, /* L373 */
{3.4607408046722412e+00, 7.7545642852783203e-05,
	1.1920928955078125e-07, 2.6226043701171875e-03,
	2.5917291641235352e-03}, /* L374 */
{4.7070565223693848e+00, 1.0529160499572754e-04,
	1.1920928955078125e-07, -5.3703784942626953e-05,
	1.9395351409912109e-04}, /* L375 */
{5.0860800743103027e+00, 1.1402368545532227e-04,
	1.1920928955078125e-07, 3.4677982330322266e-04,
	-1.5020370483398438e-05}, /* L376 */
{3.8089709281921387e+00, 8.5622072219848633e-05,
	1.1920928955078125e-07, 2.7537345886230469e-05,
	2.5868415832519531e-05}, /* L377 */
{4.2515749931335449e+00, 9.5844268798828125e-05,
	1.1920928955078125e-07, 1.3089179992675781e-04,
	-1.6510486602783203e-05}, /* L378 */
{4.0408983230590820e+00, 9.1299414634704590e-05,
	1.1920928955078125e-07, -5.5491924285888672e-05,
	-5.9783458709716797e-05}, /* L379 */
{4.4814028739929199e+00, 1.0150671005249023e-04,
	1.1920928955078125e-07, -1.7225742340087891e-05,
	9.5367431640625000e-06}, /* L380 */
{3.7937805652618408e+00, 8.6158514022827148e-05,
	1.1920928955078125e-07, 5.2452087402343750e-06,
	-1.5735626220703125e-05}, /* L381 */
{4.2195396423339844e+00, 9.6119940280914307e-05,
	1.1920928955078125e-07, -5.3763389587402344e-05,
	1.5914440155029297e-04}, /* L382 */
{3.8781976699829102e+00, 8.8542699813842773e-05,
	1.1920928955078125e-07, -2.1874904632568359e-05,
	2.3245811462402344e-05}, /* L383 */
{5.0740528106689453e+00, 1.1619925498962402e-04,
	1.1920928955078125e-07, -3.2711029052734375e-04,
	1.1205673217773438e-05}, /* L384 */
{4.5497961044311523e+00, 1.0441243648529053e-04,
	1.1920928955078125e-07, -4.3511390686035156e-06,
	9.5367431640625000e-06}, /* L385 */
{4.7555971145629883e+00, 1.0946393013000488e-04,
	1.1920928955078125e-07, 1.3017654418945312e-04,
	1.9943714141845703e-04}, /* L386 */
{3.6250836849212646e+00, 8.3625316619873047e-05,
	1.1920928955078125e-07, -4.7802925109863281e-05,
	-1.9311904907226562e-05}, /* L387 */
{5.8204035758972168e+00, 1.3461709022521973e-04,
	1.1920928955078125e-07, 3.3378601074218750e-06,
	1.4781951904296875e-05}, /* L388 */
{3.6026206016540527e+00, 8.3535909652709961e-05,
	1.1920928955078125e-07, -5.0663948059082031e-06,
	2.4676322937011719e-05}, /* L389 */
{5.6130175590515137e+00, 1.3048946857452393e-04,
	1.1920928955078125e-07, -6.1511993408203125e-05,
	-1.3947486877441406e-05}, /* L390 */
{3.5651161670684814e+00, 8.3088874816894531e-05,
	1.1920928955078125e-07, -1.7583370208740234e-05,
	3.2186508178710938e-06}, /* L391 */
{3.5756576061248779e+00, 8.3686318248510361e-05,
	1.1920928955078125e-07, -2.0819902420043945e-04,
	7.5435638427734375e-04}, /* L392 */
{3.8484609127044678e+00, 9.0166926383972168e-05,
	1.1920928955078125e-07, -1.6689300537109375e-05,
	-2.8729438781738281e-05}, /* L393 */
{3.9579837322235107e+00, 9.2962756752967834e-05,
	1.1920928955078125e-07, -1.8775463104248047e-05,
	1.4185905456542969e-04}, /* L394 */
{5.2872052192687988e+00, 1.2460350990295410e-04,
	1.1920928955078125e-07, -1.8632411956787109e-04,
	1.5187263488769531e-04}, /* L395 */
{3.2937521934509277e+00, 7.7813863754272461e-05,
	1.1920928955078125e-07, -2.1290779113769531e-04,
	2.6929378509521484e-04}, /* L396 */
{5.8030114173889160e+00, 1.3732910156250000e-04,
	1.1920928955078125e-07, 1.0132789611816406e-05,
	-2.7835369110107422e-05}, /* L397 */
{4.1490583419799805e+00, 9.8444521427154541e-05,
	1.1920928955078125e-07, -5.3882598876953125e-05,
	7.8082084655761719e-05}, /* L398 */
{4.5905141830444336e+00, 1.0925531387329102e-04,
	1.1920928955078125e-07, 5.1617622375488281e-05,
	7.3790550231933594e-05}, /* L399 */
{5.8524904251098633e+00, 1.3956427574157715e-04,
	1.1920928955078125e-07, 5.8889389038085938e-05,
	1.6570091247558594e-05}, /* L400 */
{3.6343975067138672e+00, 8.6873769760131836e-05,
	1.1920928955078125e-07, -4.7087669372558594e-05,
	4.1365623474121094e-05}, /* L401 */
{5.1688361167907715e+00, 1.2385845184326172e-04,
	1.1920928955078125e-07, 3.2186508178710938e-06,
	3.4570693969726562e-06}, /* L402 */
{5.5612969398498535e+00, 1.3359449803829193e-04,
	1.1920928955078125e-07, 4.5776367187500000e-05,
	-6.0796737670898438e-06}, /* L403 */
{5.2148928642272949e+00, 1.2558698654174805e-04,
	1.1920928955078125e-07, 6.3180923461914062e-06,
	1.2993812561035156e-05}, /* L404 */
{4.9660286903381348e+00, 1.1989474296569824e-04,
	1.1920928955078125e-07, 1.1086463928222656e-05,
	5.9008598327636719e-05}, /* L405 */
{4.8024926185607910e+00, 1.1622533202171326e-04,
	1.1920928955078125e-07, -3.5703182220458984e-05,
	4.0531158447265625e-06}, /* L406 */
{3.7295167446136475e+00, 9.0479850769042969e-05,
	1.1920928955078125e-07, 1.6689300537109375e-05,
	-8.9406967163085938e-07}, /* L407 */
{5.6095252037048340e+00, 1.3655424118041992e-04,
	1.1920928955078125e-07, 5.2094459533691406e-05,
	1.5461444854736328e-04}, /* L408 */
{5.4967718124389648e+00, 1.3402104377746582e-04,
	1.1920928955078125e-07, -1.4603137969970703e-05,
	-6.9081783294677734e-05}, /* L409 */
{6.3083896636962891e+00, 1.5420466661453247e-04,
	1.1920928955078125e-07, 2.0742416381835938e-05,
	-1.4132261276245117e-04}, /* L410 */
{4.2645049095153809e+00, 1.0448694229125977e-04,
	1.1920928955078125e-07, -3.6954879760742188e-05,
	7.0571899414062500e-05}, /* L411 */
{4.8736329078674316e+00, 1.1968612670898438e-04,
	1.1920928955078125e-07, -1.0550022125244141e-05,
	-3.6358833312988281e-06}, /* L412 */
{5.1146631240844727e+00, 1.2594461441040039e-04,
	1.1920928955078125e-07, -2.3871660232543945e-04,
	7.9512596130371094e-05}, /* L413 */
{4.9308147430419922e+00, 1.2177228927612305e-04,
	1.1920928955078125e-07, -2.5171041488647461e-04,
	-1.0788440704345703e-04}, /* L414 */
{4.9413123130798340e+00, 1.2224912643432617e-04,
	1.1920928955078125e-07, 4.0531158447265625e-06,
	-6.1988830566406250e-06}, /* L415 */
{5.5262899398803711e+00, 1.3706088066101074e-04,
	1.1920928955078125e-07, 1.0371208190917969e-04,
	9.2983245849609375e-06}, /* L416 */
{4.1554741859436035e+00, 1.0332372039556503e-04,
	1.1920928955078125e-07, -1.2522935867309570e-04,
	1.5676021575927734e-04}, /* L417 */
{5.7199134826660156e+00, 1.4266371726989746e-04,
	1.1920928955078125e-07, -2.4569034576416016e-04,
	-1.7821788787841797e-05}, /* L418 */
{4.5091886520385742e+00, 1.1262297630310059e-04,
	1.1920928955078125e-07, -1.9907951354980469e-05,
	-3.6120414733886719e-05}, /* L419 */
{5.7672843933105469e+00, 1.4439225196838379e-04,
	1.1920928955078125e-07, -3.1709671020507812e-05,
	-1.9609928131103516e-05}, /* L420 */
{6.4943995475769043e+00, 1.6298890113830566e-04,
	1.1920928955078125e-07, 7.9631805419921875e-05,
	2.5749206542968750e-05}, /* L421 */
{4.4240193367004395e+00, 1.1128932237625122e-04,
	1.1920928955078125e-07, -4.5657157897949219e-05,
	2.7894973754882812e-05}, /* L422 */
{4.9000020027160645e+00, 1.2357532978057861e-04,
	1.1920928955078125e-07, -1.3840198516845703e-04,
	1.6570091247558594e-05}, /* L423 */
{4.9009256362915039e+00, 1.2388825416564941e-04,
	1.1920928955078125e-07, -1.9699335098266602e-04,
	-4.1902065277099609e-05}, /* L424 */
{4.5620651245117188e+00, 1.1557340621948242e-04,
	1.1920928955078125e-07, 3.6835670471191406e-05,
	-1.3887882232666016e-05}, /* L425 */
{5.4333934783935547e+00, 1.3798475265502930e-04,
	1.1920928955078125e-07, 5.9604644775390625e-05,
	6.0558319091796875e-05}, /* L426 */
{4.8036007881164551e+00, 1.2227147817611694e-04,
	1.1920928955078125e-07, -3.0815601348876953e-05,
	6.1273574829101562e-05}, /* L427 */
{4.7169952392578125e+00, 1.2034177780151367e-04,
	1.1920928955078125e-07, -4.7087669372558594e-06,
	-1.6272068023681641e-05}, /* L428 */
{4.8233399391174316e+00, 1.2341141700744629e-04,
	1.1920928955078125e-07, 7.4386596679687500e-05,
	8.2850456237792969e-05}, /* L429 */
{6.7834086418151855e+00, 1.7386674880981445e-04,
	1.1920928955078125e-07, 3.9458274841308594e-05,
	-8.5830688476562500e-06}, /* L430 */
{4.9041800498962402e+00, 1.2616068124771118e-04,
	1.1920928955078125e-07, -4.3052434921264648e-04,
	-4.0596723556518555e-04}, /* L431 */
{5.5431079864501953e+00, 1.4275312423706055e-04,
	1.1920928955078125e-07, 7.0929527282714844e-05,
	-1.3768672943115234e-05}, /* L432 */
{4.5884084701538086e+00, 1.1861324310302734e-04,
	1.1920928955078125e-07, -3.6764144897460938e-04,
	1.9061565399169922e-04}, /* L433 */
{3.4099633693695068e+00, 8.8214874267578125e-05,
	1.1920928955078125e-07, -3.0398368835449219e-06,
	-8.7618827819824219e-06}, /* L434 */
{5.1639256477355957e+00, 1.3390183448791504e-04,
	1.1920928955078125e-07, -2.8669834136962891e-05,
	6.6757202148437500e-06}, /* L435 */
{4.7931871414184570e+00, 1.2457370758056641e-04,
	1.1920928955078125e-07, 5.4955482482910156e-05,
	7.7486038208007812e-06}, /* L436 */
{4.7301306724548340e+00, 1.2323260307312012e-04,
	1.1920928955078125e-07, 9.5844268798828125e-05,
	-2.6047229766845703e-05}, /* L437 */
{4.8976392745971680e+00, 1.2788176536560059e-04,
	1.1920928955078125e-07, -1.5795230865478516e-04,
	-2.0921230316162109e-05}, /* L438 */
{5.2720355987548828e+00, 1.3796985149383545e-04,
	1.1920928955078125e-07, -4.6670436859130859e-05,
	5.5432319641113281e-05}, /* L439 */
{5.0466547012329102e+00, 1.3238191604614258e-04,
	1.1920928955078125e-07, -5.1319599151611328e-05,
	-2.1278858184814453e-05}, /* L440 */
{4.4025888442993164e+00, 1.1575222015380859e-04,
	1.1920928955078125e-07, 5.2452087402343750e-06,
	-1.2636184692382812e-04}, /* L441 */
{4.4723958969116211e+00, 1.1783838272094727e-04,
	1.1920928955078125e-07, -4.5239925384521484e-05,
	2.5033950805664062e-06}, /* L442 */
{4.7411189079284668e+00, 1.2519955635070801e-04,
	1.1920928955078125e-07, 2.9802322387695312e-06,
	-1.8119812011718750e-05}, /* L443 */
{4.4799847602844238e+00, 1.1861324310302734e-04,
	1.1920928955078125e-07, -1.9311904907226562e-05,
	4.6372413635253906e-05}, /* L444 */
{4.6506352424621582e+00, 1.2337043881416321e-04,
	1.1920928955078125e-07, -5.2392482757568359e-05,
	-2.8610229492187500e-05}, /* L445 */
{5.7173337936401367e+00, 1.5200302004814148e-04,
	1.1920928955078125e-07, -4.5299530029296875e-05,
	-5.4955482482910156e-05}, /* L446 */
{6.7710990905761719e+00, 1.8045306205749512e-04,
	1.1920928955078125e-07, 1.3089179992675781e-04,
	-2.3710727691650391e-04}, /* L447 */
{4.3210639953613281e+00, 1.1539459228515625e-04,
	1.1920928955078125e-07, 5.9604644775390625e-07,
	-1.9669532775878906e-06}, /* L448 */
{4.6492733955383301e+00, 1.2443959712982178e-04,
	1.1920928955078125e-07, 4.6730041503906250e-05,
	4.0769577026367188e-05}, /* L449 */
{6.0502514839172363e+00, 1.6229599714279175e-04,
	1.1920928955078125e-07, 1.9073486328125000e-05,
	7.5697898864746094e-05}, /* L450 */
{3.8663313388824463e+00, 1.0395050048828125e-04,
	1.1920928955078125e-07, 8.0585479736328125e-05,
	1.8835067749023438e-05}, /* L451 */
{6.2990856170654297e+00, 1.6972422599792480e-04,
	1.1920928955078125e-07, 3.1113624572753906e-05,
	9.5367431640625000e-07}, /* L452 */
{4.9766898155212402e+00, 1.3440847396850586e-04,
	1.1920928955078125e-07, -8.7022781372070312e-06,
	1.2159347534179688e-05}, /* L453 */
{5.8987503051757812e+00, 1.5971064567565918e-04,
	1.1920928955078125e-07, -2.3841857910156250e-06,
	-1.7160177230834961e-04}, /* L454 */
{4.6731977462768555e+00, 1.2677907943725586e-04,
	1.1920928955078125e-07, -2.3841857910156250e-05,
	-5.7399272918701172e-05}, /* L455 */
{4.7921600341796875e+00, 1.3029575347900391e-04,
	1.1920928955078125e-07, -6.0081481933593750e-05,
	-5.7935714721679688e-05}, /* L456 */
{4.1910967826843262e+00, 1.1419691145420074e-04,
	1.1920928955078125e-07, -2.5391578674316406e-05,
	-1.8149614334106445e-04}, /* L457 */
{5.1380434036254883e+00, 1.4032423496246338e-04,
	1.1920928955078125e-07, 9.3102455139160156e-05,
	3.3259391784667969e-05}, /* L458 */
{6.5492949485778809e+00, 1.7920136451721191e-04,
	1.1920928955078125e-07, -7.0929527282714844e-05,
	-9.7215175628662109e-05}, /* L459 */
{5.6332507133483887e+00, 1.5452504158020020e-04,
	1.1920928955078125e-07, 3.3998489379882812e-04,
	1.1622905731201172e-04}, /* L460 */
{4.5762581825256348e+00, 1.2581050395965576e-04,
	1.1920928955078125e-07, 5.2452087402343750e-06,
	2.9802322387695312e-06}, /* L461 */
{4.4334683418273926e+00, 1.2210011482238770e-04,
	1.1920928955078125e-07, 7.8678131103515625e-06,
	4.1007995605468750e-05}, /* L462 */
{7.3508515357971191e+00, 2.0290911197662354e-04,
	1.1920928955078125e-07, -3.8623809814453125e-05,
	-1.0907649993896484e-05}, /* L463 */
{3.6928987503051758e+00, 1.0220706462860107e-04,
	1.1920928955078125e-07, -1.9556283950805664e-04,
	-1.4412403106689453e-04}, /* L464 */
{5.9219169616699219e+00, 1.6415119171142578e-04,
	1.1920928955078125e-07, -1.8775463104248047e-05,
	-1.3768672943115234e-05}, /* L465 */
{5.9144444465637207e+00, 1.6430020332336426e-04,
	1.1920928955078125e-07, -1.3589859008789062e-05,
	-1.8477439880371094e-05}, /* L466 */
{6.1911263465881348e+00, 1.7234683036804199e-04,
	1.1920928955078125e-07, -2.5987625122070312e-05,
	9.3936920166015625e-05}, /* L467 */
{6.4790682792663574e+00, 1.8087029457092285e-04,
	1.1920928955078125e-07, -5.5849552154541016e-05,
	2.9158592224121094e-04}, /* L468 */
{7.4850344657897949e+00, 2.0927190780639648e-04,
	1.1920928955078125e-07, 1.1825561523437500e-04,
	3.7193298339843750e-05}, /* L469 */
{4.5422015190124512e+00, 1.2725591659545898e-04,
	1.1920928955078125e-07, 1.7881393432617188e-06,
	-2.6106834411621094e-05}, /* L470 */
{5.7486481666564941e+00, 1.6266107559204102e-04,
	1.1920928955078125e-07, -2.2810697555541992e-03,
	8.3255767822265625e-04}, /* L471 */
{5.3004713058471680e+00, 1.4914572238922119e-04,
	1.1920928955078125e-07, -2.6285648345947266e-05,
	-3.9041042327880859e-05}, /* L472 */
{6.7798418998718262e+00, 1.9121170043945312e-04,
	1.1920928955078125e-07, 1.4996528625488281e-04,
	-5.8710575103759766e-05}, /* L473 */
{5.2309894561767578e+00, 1.4781951904296875e-04,
	1.1920928955078125e-07, -7.1823596954345703e-05,
	-1.1342763900756836e-04}, /* L474 */
{5.3210940361022949e+00, 1.5089660882949829e-04,
	1.1920928955078125e-07, 2.5629997253417969e-05,
	-2.0939111709594727e-04}, /* L475 */
{6.0578145980834961e+00, 1.7203390598297119e-04,
	1.1920928955078125e-07, -2.2065639495849609e-04,
	4.3463706970214844e-04}, /* L476 */
{7.5555233955383301e+00, 2.1488592028617859e-04,
	1.1920928955078125e-07, -1.1295080184936523e-04,
	-2.9385089874267578e-05}, /* L477 */
{5.4848942756652832e+00, 1.5627779066562653e-04,
	1.1920928955078125e-07, -1.3649463653564453e-05,
	2.1219253540039062e-05}, /* L478 */
{4.4020037651062012e+00, 1.2570619583129883e-04,
	1.1920928955078125e-07, -7.9989433288574219e-05,
	3.9696693420410156e-05}, /* L479 */
{6.1365470886230469e+00, 1.7558038234710693e-04,
	1.1920928955078125e-07, -6.8604946136474609e-05,
	-1.6570091247558594e-05}, /* L480 */
{5.6573195457458496e+00, 1.6229599714279175e-04,
	1.1920928955078125e-07, 4.1866302490234375e-04,
	-4.6926736831665039e-04}, /* L481 */
{5.2921171188354492e+00, 1.5211105346679688e-04,
	1.1920928955078125e-07, 5.5789947509765625e-05,
	1.1694431304931641e-04}, /* L482 */
{5.8491892814636230e+00, 1.6862899065017700e-04,
	1.1920928955078125e-07, -3.3354759216308594e-04,
	9.2983245849609375e-05}, /* L483 */
{5.0758614540100098e+00, 1.4644861221313477e-04,
	1.1920928955078125e-07, -3.5881996154785156e-05,
	-1.3470649719238281e-05}, /* L484 */
{6.6731619834899902e+00, 1.9294023513793945e-04,
	1.1920928955078125e-07, -4.8279762268066406e-06,
	-4.9650669097900391e-05}, /* L485 */
{5.5807728767395020e+00, 1.6167759895324707e-04,
	1.1920928955078125e-07, -2.7954578399658203e-05,
	2.1457672119140625e-06}, /* L486 */
{5.3043012619018555e+00, 1.5400350093841553e-04,
	1.1920928955078125e-07, -5.3226947784423828e-05,
	1.5020370483398438e-05}, /* L487 */
{5.2347793579101562e+00, 1.5231966972351074e-04,
	1.1920928955078125e-07, 2.1612644195556641e-04,
	-2.4217367172241211e-04}, /* L488 */
{5.9275188446044922e+00, 1.7279386520385742e-04,
	1.1920928955078125e-07, 1.7166137695312500e-05,
	3.0994415283203125e-05}, /* L489 */
{4.7745151519775391e+00, 1.3950467109680176e-04,
	1.1920928955078125e-07, -1.4477968215942383e-04,
	-1.4668703079223633e-04}, /* L490 */
{3.7013018131256104e+00, 1.0833144187927246e-04,
	1.1920928955078125e-07, 8.5830688476562500e-06,
	1.0132789611816406e-05}, /* L491 */
{5.2267508506774902e+00, 1.5336275100708008e-04,
	1.1920928955078125e-07, -3.8170814514160156e-04,
	1.7035007476806641e-04}, /* L492 */
{7.1574606895446777e+00, 2.1034479141235352e-04,
	1.1920928955078125e-07, 1.0251998901367188e-05,
	4.1246414184570312e-05}, /* L493 */
{5.5949034690856934e+00, 1.6480684280395508e-04,
	1.1920928955078125e-07, 5.3286552429199219e-05,
	-1.4090538024902344e-04}, /* L494 */
{5.0247888565063477e+00, 1.4826655387878418e-04,
	1.1920928955078125e-07, 3.6716461181640625e-05,
	5.1617622375488281e-05}, /* L495 */
{6.5991225242614746e+00, 1.9510835409164429e-04,
	1.1920928955078125e-07, -1.1920928955078125e-07,
	-2.2113323211669922e-05}, /* L496 */
{7.3950409889221191e+00, 2.1910667419433594e-04,
	1.1920928955078125e-07, -1.6152858734130859e-05,
	7.9870223999023438e-06}, /* L497 */
{5.6270971298217773e+00, 1.6705691814422607e-04,
	1.1920928955078125e-07, -4.4226646423339844e-05,
	-7.8916549682617188e-05}, /* L498 */
{5.6410298347473145e+00, 1.6780197620391846e-04,
	1.1920928955078125e-07, -1.4841556549072266e-05,
	4.8875808715820312e-05}, /* L499 */
{5.5280261039733887e+00, 1.6477704048156738e-04,
	1.1920928955078125e-07, 2.0861625671386719e-05,
	-5.4717063903808594e-05}, /* L500 */
{5.6087503433227539e+00, 1.6760826110839844e-04,
	1.1920928955078125e-07, -2.2983551025390625e-04,
	2.3102760314941406e-04}, /* L501 */
{5.4079442024230957e+00, 1.6199052333831787e-04,
	1.1920928955078125e-07, -1.4126300811767578e-05,
	-2.1928548812866211e-04}, /* L502 */
{5.7897634506225586e+00, 1.7395615577697754e-04,
	1.1920928955078125e-07, -9.8377466201782227e-04,
	-1.4424324035644531e-05}, /* L503 */
{5.5397872924804688e+00, 1.6644597053527832e-04,
	1.1920928955078125e-07, 3.9339065551757812e-05,
	7.5101852416992188e-05}, /* L504 */
{5.4679875373840332e+00, 1.6459822654724121e-04,
	1.1920928955078125e-07, 1.8596649169921875e-05,
	-2.0921230316162109e-05}, /* L505 */
{4.4529743194580078e+00, 1.3431906700134277e-04,
	1.1920928955078125e-07, 7.7843666076660156e-05,
	-1.5497207641601562e-06}, /* L506 */
{4.9310393333435059e+00, 1.4905072748661041e-04,
	1.1920928955078125e-07, 1.2123584747314453e-04,
	6.4849853515625000e-05}, /* L507 */
{5.3067121505737305e+00, 1.6096234321594238e-04,
	1.1920928955078125e-07, 5.0497055053710938e-04,
	-8.9317560195922852e-04}, /* L508 */
{5.0945873260498047e+00, 1.5465915203094482e-04,
	1.1920928955078125e-07, -1.2797117233276367e-04,
	6.9022178649902344e-05}, /* L509 */
{6.1207489967346191e+00, 1.8608523532748222e-04,
	1.1920928955078125e-07, -1.0043382644653320e-04,
	-4.2557716369628906e-05}, /* L510 */
{5.9299015998840332e+00, 1.8066167831420898e-04,
	1.1920928955078125e-07, -9.4175338745117188e-06,
	-2.7239322662353516e-05}, /* L511 */
{4.7111682891845703e+00, 1.4379620552062988e-04,
	1.1920928955078125e-07, 3.4809112548828125e-05,
	-7.1942806243896484e-05}, /* L512 */
{6.2758803367614746e+00, 1.9192695617675781e-04,
	1.1920928955078125e-07, -2.7954578399658203e-05,
	-4.1723251342773438e-06}, /* L513 */
{6.1555080413818359e+00, 1.8861889839172363e-04,
	1.1920928955078125e-07, 4.8279762268066406e-05,
	1.6689300537109375e-06}, /* L514 */
{4.9983119964599609e+00, 1.5345215797424316e-04,
	1.1920928955078125e-07, 8.4638595581054688e-06,
	3.8146972656250000e-05}, /* L515 */
{5.9612245559692383e+00, 1.8347799777984619e-04,
	1.1920928955078125e-07, -7.9095363616943359e-05,
	2.0480155944824219e-04}, /* L516 */
{4.9347491264343262e+00, 1.5208125114440918e-04,
	1.1920928955078125e-07, 6.3180923461914062e-06,
	-1.9669532775878906e-06}, /* L517 */
{5.6785922050476074e+00, 1.7534196376800537e-04,
	1.1920928955078125e-07, -8.8214874267578125e-06,
	-1.0311603546142578e-05}, /* L518 */
{6.8157291412353516e+00, 2.1106004714965820e-04,
	1.1920928955078125e-07, -5.3107738494873047e-05,
	9.4532966613769531e-05}, /* L519 */
{5.7248001098632812e+00, 1.7745792865753174e-04,
	1.1920928955078125e-07, 4.5895576477050781e-05,
	-3.0040740966796875e-05}, /* L520 */
{5.8009543418884277e+00, 1.8052756786346436e-04,
	1.1920928955078125e-07, 2.8479099273681641e-04,
	-1.2654066085815430e-04}, /* L521 */
{5.2041826248168945e+00, 1.6194581985473633e-04,
	1.1920928955078125e-07, -6.1213970184326172e-05,
	-1.7583370208740234e-05}, /* L522 */
{6.6662683486938477e+00, 2.0784139633178711e-04,
	1.1920928955078125e-07, -5.3942203521728516e-05,
	-1.1903047561645508e-04}, /* L523 */
{5.3592529296875000e+00, 1.6742944717407227e-04,
	1.1920928955078125e-07, -3.8743019104003906e-05,
	-1.1682510375976562e-05}, /* L524 */
{4.9949140548706055e+00, 1.5634298324584961e-04,
	1.1920928955078125e-07, -6.6936016082763672e-05,
	-4.8577785491943359e-05}, /* L525 */
{6.3913831710815430e+00, 2.0045042037963867e-04,
	1.1920928955078125e-07, 7.1167945861816406e-05,
	7.0691108703613281e-05}, /* L526 */
{7.3903741836547852e+00, 2.3244414478540421e-04,
	1.1920928955078125e-07, -2.9462575912475586e-04,
	-1.5681982040405273e-04}, /* L527 */
{6.2383975982666016e+00, 1.9648671150207520e-04,
	1.1920928955078125e-07, 1.9490718841552734e-04,
	1.7750263214111328e-04}, /* L528 */
{4.9334025382995605e+00, 1.5556812286376953e-04,
	1.1920928955078125e-07, -4.4703483581542969e-05,
	-1.6450881958007812e-05}, /* L529 */
{6.5613160133361816e+00, 2.0769238471984863e-04,
	1.1920928955078125e-07, 8.9991092681884766e-04,
	1.4561414718627930e-03}, /* L530 */
{6.7225046157836914e+00, 2.1310895681381226e-04,
	1.1920928955078125e-07, 9.6750259399414062e-04,
	7.2360038757324219e-04}, /* L531 */
{5.1799497604370117e+00, 1.6433000564575195e-04,
	1.1920928955078125e-07, -5.2392482757568359e-05,
	9.8943710327148438e-06}, /* L532 */
{6.1014223098754883e+00, 1.9398331642150879e-04,
	1.1920928955078125e-07, -3.4421682357788086e-04,
	-6.0796737670898438e-05}, /* L533 */
{6.9196872711181641e+00, 2.2029876708984375e-04,
	1.1920928955078125e-07, -7.1465969085693359e-05,
	-1.0716915130615234e-04}, /* L534 */
{8.4238595962524414e+00, 2.6882067322731018e-04,
	1.1920928955078125e-07, -1.7005205154418945e-04,
	8.2731246948242188e-05}, /* L535 */
{5.3257250785827637e+00, 1.7016381025314331e-04,
	1.1920928955078125e-07, 4.2915344238281250e-06,
	-2.1338462829589844e-05}, /* L536 */
{7.1372866630554199e+00, 2.2916495800018311e-04,
	1.1920928955078125e-07, -6.5898895263671875e-04,
	7.1060657501220703e-04}, /* L537 */
{5.7486639022827148e+00, 1.8435716629028320e-04,
	1.1920928955078125e-07, -2.7596950531005859e-05,
	-3.0636787414550781e-05}, /* L538 */
{6.5129780769348145e+00, 2.0927190780639648e-04,
	1.1920928955078125e-07, 7.7366828918457031e-05,
	4.1007995605468750e-05}, /* L539 */
{7.5873479843139648e+00, 2.4425983428955078e-04,
	1.1920928955078125e-07, 4.0888786315917969e-05,
	-1.4722347259521484e-05}, /* L540 */
{5.3238263130187988e+00, 1.7172098159790039e-04,
	1.1920928955078125e-07, 1.4305114746093750e-06,
	1.0836124420166016e-04}, /* L541 */
{5.0169763565063477e+00, 1.6209483146667480e-04,
	1.1920928955078125e-07, -1.5497207641601562e-06,
	1.7881393432617188e-06}, /* L542 */
{6.2478785514831543e+00, 2.0390748977661133e-04,
	1.1920928955078125e-07, -2.5333762168884277e-03,
	2.4464130401611328e-03}, /* L543 */
{5.4783468246459961e+00, 1.7843395471572876e-04,
	1.1920928955078125e-07, -2.4759769439697266e-03,
	1.1228322982788086e-03}, /* L544 */
{5.5202503204345703e+00, 1.7936527729034424e-04,
	1.1920928955078125e-07, 3.6954879760742188e-06,
	1.9609928131103516e-04}, /* L545 */
{4.1962380409240723e+00, 1.3658404350280762e-04,
	1.1920928955078125e-07, 4.3153762817382812e-05,
	-8.3029270172119141e-05}, /* L546 */
{7.6260900497436523e+00, 2.4867057800292969e-04,
	1.1920928955078125e-07, 3.0279159545898438e-05,
	4.5299530029296875e-06}, /* L547 */
{6.6125106811523438e+00, 2.1600723266601562e-04,
	1.1920928955078125e-07, -1.5914440155029297e-05,
	1.3113021850585938e-05}, /* L548 */
{6.5128808021545410e+00, 2.1316111087799072e-04,
	1.1920928955078125e-07, 6.5445899963378906e-05,
	-1.2439489364624023e-04}, /* L549 */
{6.1242575645446777e+00, 2.0080804824829102e-04,
	1.1920928955078125e-07, -1.9788742065429688e-05,
	-2.6226043701171875e-05}, /* L550 */
{5.4250750541687012e+00, 1.7823278903961182e-04,
	1.1920928955078125e-07, 3.9339065551757812e-05,
	1.5401840209960938e-04}, /* L551 */
{4.9922137260437012e+00, 1.6435235738754272e-04,
	1.1920928955078125e-07, -9.1552734375000000e-05,
	2.3698806762695312e-04}, /* L552 */
{5.5382370948791504e+00, 1.8265843391418457e-04,
	1.1920928955078125e-07, 2.0182132720947266e-04,
	-1.0895729064941406e-04}, /* L553 */
{6.2286615371704102e+00, 2.0572543144226074e-04,
	1.1920928955078125e-07, -7.5221061706542969e-05,
	-5.7101249694824219e-05}, /* L554 */
{5.0290861129760742e+00, 1.6644597053527832e-04,
	1.1920928955078125e-07, -1.9013881683349609e-04,
	-2.6863813400268555e-04}, /* L555 */
{6.9089517593383789e+00, 2.2900104522705078e-04,
	1.1920928955078125e-07, -9.8943710327148438e-06,
	5.9962272644042969e-05}, /* L556 */
{6.5327863693237305e+00, 2.1708011627197266e-04,
	1.1920928955078125e-07, 2.0241737365722656e-04,
	-2.4747848510742188e-04}, /* L557 */
{8.6191844940185547e+00, 2.8681755065917969e-04,
	1.1920928955078125e-07, 1.0633468627929688e-04,
	-8.1896781921386719e-05}, /* L558 */
{5.3397679328918457e+00, 1.7794966697692871e-04,
	1.1920928955078125e-07, -1.0490417480468750e-05,
	1.6331672668457031e-05}, /* L559 */
{6.8938865661621094e+00, 2.3014843463897705e-04,
	1.1920928955078125e-07, -7.7605247497558594e-05,
	-3.7550926208496094e-05}, /* L560 */
{5.0948266983032227e+00, 1.7039477825164795e-04,
	1.1920928955078125e-07, 1.1682510375976562e-05,
	2.7298927307128906e-05}, /* L561 */
{6.1974897384643555e+00, 2.0766258239746094e-04,
	1.1920928955078125e-07, -1.5217065811157227e-04,
	1.7464160919189453e-04}, /* L562 */
{6.3236570358276367e+00, 2.1225214004516602e-04,
	1.1920928955078125e-07, 8.8810920715332031e-05,
	-1.5139579772949219e-05}, /* L563 */
{7.2903270721435547e+00, 2.4533271789550781e-04,
	1.1920928955078125e-07, 1.9717216491699219e-04,
	4.7385692596435547e-04}, /* L564 */
{5.9787135124206543e+00, 2.0138174295425415e-04,
	1.1920928955078125e-07, 3.5166740417480469e-05,
	7.9870223999023438e-05}, /* L565 */
{6.2727866172790527e+00, 2.1171569824218750e-04,
	1.1920928955078125e-07, 1.4662742614746094e-05,
	-2.1100044250488281e-05}, /* L566 */
{5.6863842010498047e+00, 1.9237399101257324e-04,
	1.1920928955078125e-07, -2.4920701980590820e-04,
	1.0371208190917969e-04}, /* L567 */
{6.1569628715515137e+00, 2.0846724510192871e-04,
	1.1920928955078125e-07, 4.4107437133789062e-05,
	4.3988227844238281e-05}, /* L568 */
{7.0370154380798340e+00, 2.3868680000305176e-04,
	1.1920928955078125e-07, 2.9563903808593750e-05,
	-1.0132789611816406e-05}, /* L569 */
{5.4385423660278320e+00, 1.8480420112609863e-04,
	1.1920928955078125e-07, -5.1975250244140625e-05,
	-8.3446502685546875e-07}, /* L570 */
{7.2417812347412109e+00, 2.4649500846862793e-04,
	1.1920928955078125e-07, -2.8550624847412109e-05,
	-5.9247016906738281e-05}, /* L571 */
{8.0656738281250000e+00, 2.7501583099365234e-04,
	1.1920928955078125e-07, 7.1525573730468750e-06,
	7.5101852416992188e-06}, /* L572 */
{6.2234597206115723e+00, 2.1263957023620605e-04,
	1.1920928955078125e-07, 4.1842460632324219e-05,
	7.6293945312500000e-06}, /* L573 */
{6.7974262237548828e+00, 2.3262202739715576e-04,
	1.1920928955078125e-07, 1.7881393432617188e-06,
	-1.2934207916259766e-05}, /* L574 */
{8.5480194091796875e+00, 2.9298663139343262e-04,
	1.1920928955078125e-07, -3.9100646972656250e-05,
	1.4305114746093750e-05}, /* L575 */
{5.9073004722595215e+00, 2.0298361778259277e-04,
	1.1920928955078125e-07, -5.4240226745605469e-05,
	-4.9054622650146484e-05}, /* L576 */
{5.4148898124694824e+00, 1.8626451492309570e-04,
	1.1920928955078125e-07, -4.0650367736816406e-05,
	-5.1558017730712891e-05}, /* L577 */
{6.4574041366577148e+00, 2.2289156913757324e-04,
	1.1920928955078125e-07, -5.9247016906738281e-04,
	-3.5023689270019531e-04}, /* L578 */
{6.5184297561645508e+00, 2.2499263286590576e-04,
	1.1920928955078125e-07, -5.5551528930664062e-05,
	3.3378601074218750e-06}, /* L579 */
{6.2333307266235352e+00, 2.1553039550781250e-04,
	1.1920928955078125e-07, 2.8133392333984375e-05,
	-1.0007619857788086e-04}, /* L580 */
{6.3168416023254395e+00, 2.1889805793762207e-04,
	1.1920928955078125e-07, -7.9393386840820312e-05,
	1.5270709991455078e-04}, /* L581 */
{8.2362346649169922e+00, 2.8589367866516113e-04,
	1.1920928955078125e-07, 3.5595893859863281e-04,
	-5.5193901062011719e-05}, /* L582 */
{6.1915650367736816e+00, 2.1529197692871094e-04,
	1.1920928955078125e-07, 3.0636787414550781e-04,
	1.8393993377685547e-04}, /* L583 */
{5.2736063003540039e+00, 1.8376111984252930e-04,
	1.1920928955078125e-07, -9.4175338745117188e-05,
	-4.1419267654418945e-04}, /* L584 */
{6.4567241668701172e+00, 2.2515654563903809e-04,
	1.1920928955078125e-07, 3.8623809814453125e-05,
	1.4305114746093750e-05}, /* L585 */
{7.7315225601196289e+00, 2.7009844779968262e-04,
	1.1920928955078125e-07, 1.2040138244628906e-04,
	-2.7716159820556641e-05}, /* L586 */
{5.4229846000671387e+00, 1.8998980522155762e-04,
	1.1920928955078125e-07, -3.6185979843139648e-04,
	2.2280216217041016e-04}, /* L587 */
{5.8230943679809570e+00, 2.0414590835571289e-04,
	1.1920928955078125e-07, 7.3552131652832031e-05,
	-5.8948993682861328e-05}, /* L588 */
{5.9573163986206055e+00, 2.0918250083923340e-04,
	1.1920928955078125e-07, 7.8320503234863281e-05,
	9.4532966613769531e-05}, /* L589 */
{7.0638041496276855e+00, 2.4847686290740967e-04,
	1.1920928955078125e-07, -1.8489360809326172e-04,
	7.1525573730468750e-07}, /* L590 */
{5.7252745628356934e+00, 2.0173192024230957e-04,
	1.1920928955078125e-07, 7.3671340942382812e-05,
	-1.4007091522216797e-05}, /* L591 */
{6.2417211532592773e+00, 2.2026896476745605e-04,
	1.1920928955078125e-07, 6.1154365539550781e-05,
	3.4570693969726562e-05}, /* L592 */
{7.4669103622436523e+00, 2.6396103203296661e-04,
	1.1920928955078125e-07, -7.7486038208007812e-06,
	1.4781951904296875e-05}, /* L593 */
{7.0960483551025391e+00, 2.5126338005065918e-04,
	1.1920928955078125e-07, 4.7445297241210938e-05,
	1.9431114196777344e-05}, /* L594 */
{5.6424922943115234e+00, 2.0045042037963867e-04,
	1.1920928955078125e-07, 6.4408779144287109e-04,
	7.5984001159667969e-04}, /* L595 */
{4.8968172073364258e+00, 1.7416477203369141e-04,
	1.1920928955078125e-07, 2.3424625396728516e-04,
	-3.4344196319580078e-04}, /* L596 */
{5.9397454261779785e+00, 2.1214783191680908e-04,
	1.1920928955078125e-07, 1.4681816101074219e-03,
	8.1062316894531250e-04}, /* L597 */
{5.6753072738647461e+00, 2.0232796669006348e-04,
	1.1920928955078125e-07, -5.9604644775390625e-08,
	5.6743621826171875e-05}, /* L598 */
{5.6260824203491211e+00, 2.0089745521545410e-04,
	1.1920928955078125e-07, 1.7523765563964844e-05,
	2.1934509277343750e-05}, /* L599 */
{6.6922821998596191e+00, 2.4655461311340332e-04,
	1.1920928955078125e-07, -1.1625170707702637e-02,
	-1.2531876564025879e-03}, /* L600 */
{6.5053558349609375e+00, 2.3305416107177734e-04,
	1.1920928955078125e-07, 3.1948089599609375e-05,
	7.6293945312500000e-06}, /* L601 */
{7.0569224357604980e+00, 2.5328993797302246e-04,
	1.1920928955078125e-07, -2.3007392883300781e-05,
	2.2864341735839844e-04}, /* L602 */
{4.5371122360229492e+00, 1.6769766807556152e-04,
	1.1920928955078125e-07, 2.3924112319946289e-03,
	-5.4965019226074219e-03}, /* L603 */
{6.7998681068420410e+00, 2.4572014808654785e-04,
	1.1920928955078125e-07, 1.4474391937255859e-03,
	-1.1771917343139648e-04}, /* L604 */
{6.5823335647583008e+00, 2.3740530014038086e-04,
	1.1920928955078125e-07, 1.4424324035644531e-05,
	-2.1219253540039062e-05}, /* L605 */
{7.1935143470764160e+00, 2.6038289070129395e-04,
	1.1920928955078125e-07, 6.0641765594482422e-04,
	-5.4687261581420898e-04}, /* L606 */
{7.8286204338073730e+00, 2.8327107429504395e-04,
	1.1920928955078125e-07, 4.9352645874023438e-05,
	3.5762786865234375e-07}, /* L607 */
{8.0615482330322266e+00, 2.9224157333374023e-04,
	1.1920928955078125e-07, 4.9829483032226562e-05,
	-2.0563602447509766e-05}, /* L608 */
{9.6204042434692383e+00, 3.4928321838378906e-04,
	1.1920928955078125e-07, 7.9035758972167969e-05,
	-1.3411045074462891e-05}, /* L609 */
{7.3300986289978027e+00, 2.6655197143554688e-04,
	1.1920928955078125e-07, 4.0173530578613281e-05,
	2.2649765014648438e-05}, /* L610 */
{7.9403738975524902e+00, 2.8921663761138916e-04,
	1.1920928955078125e-07, -1.4603137969970703e-05,
	2.3841857910156250e-06}, /* L611 */
{7.4271435737609863e+00, 2.7120113372802734e-04,
	1.1920928955078125e-07, 2.7859210968017578e-04,
	3.3378601074218750e-06}, /* L612 */
{6.7500357627868652e+00, 2.4700164794921875e-04,
	1.1920928955078125e-07, -9.3638896942138672e-04,
	-8.2492828369140625e-04}, /* L613 */
{9.8183164596557617e+00, 3.5950541496276855e-04,
	1.1920928955078125e-07, -4.0113925933837891e-05,
	-4.2259693145751953e-05}, /* L614 */
{6.7307910919189453e+00, 2.4677813053131104e-04,
	1.1920928955078125e-07, 2.4437904357910156e-05,
	-2.5987625122070312e-05}, /* L615 */
{4.7555990219116211e+00, 1.7473101615905762e-04,
	1.1920928955078125e-07, -2.5111436843872070e-04,
	-2.6381015777587891e-04}, /* L616 */
{6.3811101913452148e+00, 2.3475289344787598e-04,
	1.1920928955078125e-07, -1.7058849334716797e-04,
	-5.4955482482910156e-05}, /* L617 */
{7.5103497505187988e+00, 2.7687847614288330e-04,
	1.1920928955078125e-07, 1.2290477752685547e-04,
	-8.9824199676513672e-05}, /* L618 */
{8.4518814086914062e+00, 3.1214952468872070e-04,
	1.1920928955078125e-07, 8.5711479187011719e-05,
	2.5045871734619141e-04}, /* L619 */
{5.8187646865844727e+00, 2.1523237228393555e-04,
	1.1920928955078125e-07, 2.2828578948974609e-04,
	2.9480457305908203e-04}, /* L620 */
{7.1660003662109375e+00, 2.6533752679824829e-04,
	1.1920928955078125e-07, -3.8027763366699219e-05,
	-1.2266635894775391e-04}, /* L621 */
{5.5366930961608887e+00, 2.1879374980926514e-04,
	1.1920928955078125e-07, -1.7625570297241211e-02,
	1.5368103981018066e-02}, /* L622 */
{6.2345371246337891e+00, 2.3172795772552490e-04,
	1.1920928955078125e-07, -3.7008523941040039e-04,
	2.0229816436767578e-04}, /* L623 */
{7.3452577590942383e+00, 2.7322769165039062e-04,
	1.1920928955078125e-07, -4.9650669097900391e-05,
	2.1576881408691406e-05}, /* L624 */
{7.4412226676940918e+00, 2.7725100517272949e-04,
	1.1920928955078125e-07, 7.4982643127441406e-05,
	1.7046928405761719e-05}, /* L625 */
{7.0380654335021973e+00, 2.6267766952514648e-04,
	1.1920928955078125e-07, 1.2981891632080078e-04,
	-4.5001506805419922e-05}, /* L626 */
{7.1937332153320312e+00, 2.6947259902954102e-04,
	1.1920928955078125e-07, 1.1336803436279297e-04,
	-1.7517805099487305e-04}, /* L627 */
{6.8750634193420410e+00, 2.5749206542968750e-04,
	1.1920928955078125e-07, 2.1457672119140625e-05,
	-2.2584199905395508e-04}, /* L628 */
{6.8809895515441895e+00, 2.5838613510131836e-04,
	1.1920928955078125e-07, 6.8664550781250000e-05,
	-2.0980834960937500e-05}, /* L629 */
{8.5107498168945312e+00, 3.1990557909011841e-04,
	1.1920928955078125e-07, 2.4259090423583984e-04,
	1.7261505126953125e-04}, /* L630 */
{6.0600571632385254e+00, 2.2795796394348145e-04,
	1.1920928955078125e-07, 1.4185905456542969e-05,
	-3.6120414733886719e-05}, /* L631 */
{6.8029623031616211e+00, 2.5655329227447510e-04,
	1.1920928955078125e-07, 5.6529045104980469e-04,
	-4.7385692596435547e-05}, /* L632 */
{5.2181282043457031e+00, 1.9690394401550293e-04,
	1.1920928955078125e-07, 3.0279159545898438e-05,
	7.0095062255859375e-05}, /* L633 */
{6.1653513908386230e+00, 2.3306161165237427e-04,
	1.1920928955078125e-07, -1.2719631195068359e-04,
	-3.2901763916015625e-05}, /* L634 */
{1.0090007781982422e+01, 3.8199126720428467e-04,
	1.1920928955078125e-07, 3.7312507629394531e-05,
	1.2767314910888672e-04}, /* L635 */
{6.9291019439697266e+00, 2.6278570294380188e-04,
	1.1920928955078125e-07, 5.9485435485839844e-05,
	-1.1008977890014648e-04}, /* L636 */
{7.0602102279663086e+00, 2.6810169219970703e-04,
	1.1920928955078125e-07, -4.6074390411376953e-05,
	-4.3809413909912109e-05}, /* L637 */
{5.7378449440002441e+00, 2.1827220916748047e-04,
	1.1920928955078125e-07, 4.6968460083007812e-05,
	4.3034553527832031e-05}, /* L638 */
{6.3211236000061035e+00, 2.4092197418212891e-04,
	1.1920928955078125e-07, 3.6644935607910156e-04,
	-9.3698501586914062e-05}, /* L639 */
{7.8079681396484375e+00, 2.9809400439262390e-04,
	1.1920928955078125e-07, -6.8843364715576172e-05,
	-1.3387203216552734e-04}, /* L640 */
{6.9819111824035645e+00, 2.6679039001464844e-04,
	1.1920928955078125e-07, 6.3061714172363281e-05,
	-3.5345554351806641e-05}, /* L641 */
{7.8021092414855957e+00, 2.9870867729187012e-04,
	1.1920928955078125e-07, 1.8179416656494141e-04,
	3.9458274841308594e-04}, /* L642 */
{6.1449055671691895e+00, 2.3555848747491837e-04,
	1.1920928955078125e-07, 9.8943710327148438e-06,
	6.9379806518554688e-05}, /* L643 */
{1.0161928176879883e+01, 3.9014220237731934e-04,
	1.1920928955078125e-07, -3.8683414459228516e-05,
	4.2796134948730469e-05}, /* L644 */
{8.9145879745483398e+00, 3.4275650978088379e-04,
	1.1920928955078125e-07, -5.4895877838134766e-05,
	-4.2319297790527344e-05}, /* L645 */
{7.7153244018554688e+00, 2.9712915420532227e-04,
	1.1920928955078125e-07, 4.7326087951660156e-05,
	-6.8068504333496094e-05}, /* L646 */
{6.5894141197204590e+00, 2.5421380996704102e-04,
	1.1920928955078125e-07, 1.1301040649414062e-04,
	-1.0764598846435547e-04}, /* L647 */
{7.0353183746337891e+00, 2.7181208133697510e-04,
	1.1920928955078125e-07, 3.7670135498046875e-05,
	-6.5445899963378906e-05}, /* L648 */
{8.1330633163452148e+00, 3.1466782093048096e-04,
	1.1920928955078125e-07, 2.8848648071289062e-05,
	2.3245811462402344e-05}, /* L649 */
{8.3618154525756836e+00, 3.2401084899902344e-04,
	1.1920928955078125e-07, 3.7431716918945312e-05,
	-8.1777572631835938e-05}, /* L650 */
{6.2441129684448242e+00, 2.4238228797912598e-04,
	1.1920928955078125e-07, 1.8000602722167969e-05,
	-1.7464160919189453e-04}, /* L651 */
{6.4863290786743164e+00, 2.5215744972229004e-04,
	1.1920928955078125e-07, 1.9526481628417969e-04,
	5.4717063903808594e-05}, /* L652 */
{9.9639158248901367e+00, 3.8787722587585449e-04,
	1.1920928955078125e-07, 5.3524971008300781e-05,
	2.5868415832519531e-05}, /* L653 */
{9.3870038986206055e+00, 3.6612153053283691e-04,
	1.1920928955078125e-07, -1.0466575622558594e-04,
	-1.2952089309692383e-04}, /* L654 */
{6.7999768257141113e+00, 2.6577711105346680e-04,
	1.1920928955078125e-07, 2.5451183319091797e-04,
	1.3470649719238281e-04}, /* L655 */
{6.1233639717102051e+00, 2.3949146270751953e-04,
	1.1920928955078125e-07, 1.1324882507324219e-04,
	2.3841857910156250e-06}, /* L656 */
{6.0820579528808594e+00, 2.3822486400604248e-04,
	1.1920928955078125e-07, -4.8398971557617188e-05,
	6.0796737670898438e-06}, /* L657 */
{9.0576658248901367e+00, 3.5536289215087891e-04,
	1.1920928955078125e-07, -7.5221061706542969e-05,
	-1.7285346984863281e-06}, /* L658 */
{7.4212503433227539e+00, 2.9158592224121094e-04,
	1.1920928955078125e-07, -6.3002109527587891e-05,
	-2.9683113098144531e-05}, /* L659 */
{8.0697708129882812e+00, 3.1752884387969971e-04,
	1.1920928955078125e-07, 4.0650367736816406e-05,
	-9.5486640930175781e-05}, /* L660 */
{8.6036615371704102e+00, 3.3923238515853882e-04,
	1.1920928955078125e-07, 1.0752677917480469e-04,
	-2.2768974304199219e-05}, /* L661 */
{7.3175549507141113e+00, 2.8893351554870605e-04,
	1.1920928955078125e-07, -2.6404857635498047e-04,
	-8.4400177001953125e-05}, /* L662 */
{6.9639835357666016e+00, 2.7562677860260010e-04,
	1.1920928955078125e-07, 6.4110755920410156e-04,
	5.0687789916992188e-04}, /* L663 */
{7.1046333312988281e+00, 2.8124451637268066e-04,
	1.1920928955078125e-07, -2.9444694519042969e-05,
	-7.5519084930419922e-05}, /* L664 */
{6.2037110328674316e+00, 2.4593994021415710e-04,
	1.1920928955078125e-07, 4.6372413635253906e-05,
	-7.0929527282714844e-06}, /* L665 */
{6.9838414192199707e+00, 2.7740001678466797e-04,
	1.1920928955078125e-07, 8.9287757873535156e-05,
	3.3235549926757812e-04}, /* L666 */
{7.0547490119934082e+00, 2.8049945831298828e-04,
	1.1920928955078125e-07, 7.6532363891601562e-05,
	3.9935111999511719e-05}, /* L667 */
{7.6021246910095215e+00, 3.0377507209777832e-04,
	1.1920928955078125e-07, 1.5377998352050781e-05,
	1.2140274047851562e-03}, /* L668 */
{6.1794114112854004e+00, 2.4646520614624023e-04,
	1.1920928955078125e-07, 9.8705291748046875e-05,
	3.3259391784667969e-05}, /* L669 */
{6.2242946624755859e+00, 2.4864077568054199e-04,
	1.1920928955078125e-07, 1.7857551574707031e-04,
	1.3840198516845703e-04}, /* L670 */
{5.7655587196350098e+00, 2.3227930068969727e-04,
	1.1920928955078125e-07, 1.0049343109130859e-04,
	-1.5097856521606445e-03}, /* L671 */
{8.8375940322875977e+00, 3.5402178764343262e-04,
	1.1920928955078125e-07, 4.1604042053222656e-05,
	-5.6207180023193359e-05}, /* L672 */
{7.7568073272705078e+00, 3.1130015850067139e-04,
	1.1920928955078125e-07, 1.7762184143066406e-04,
	-1.9609928131103516e-05}, /* L673 */
{9.7576847076416016e+00, 3.9217248558998108e-04,
	1.1920928955078125e-07, -1.4537572860717773e-04,
	3.0040740966796875e-05}, /* L674 */
{8.0025911331176758e+00, 3.2210350036621094e-04,
	1.1920928955078125e-07, -9.9301338195800781e-05,
	1.8465518951416016e-04}, /* L675 */
{6.9895982742309570e+00, 2.8181076049804688e-04,
	1.1920928955078125e-07, 1.7380714416503906e-04,
	-3.7729740142822266e-05}, /* L676 */
{6.7764139175415039e+00, 2.7349218726158142e-04,
	1.1920928955078125e-07, -5.0902366638183594e-05,
	-5.1200389862060547e-05}, /* L677 */
{8.2010126113891602e+00, 3.3193826675415039e-04,
	1.1920928955078125e-07, -4.7045946121215820e-04,
	2.1946430206298828e-04}, /* L678 */
{6.7032175064086914e+00, 2.7168542146682739e-04,
	1.1920928955078125e-07, 2.4592876434326172e-04,
	4.0984153747558594e-04}, /* L679 */
{9.0340356826782227e+00, 3.6758184432983398e-04,
	1.1920928955078125e-07, 4.5371055603027344e-04,
	2.2888183593750000e-04}, /* L680 */
{8.2917566299438477e+00, 3.3694505691528320e-04,
	1.1920928955078125e-07, 5.8507919311523438e-04,
	6.0081481933593750e-05}, /* L681 */
{6.9245390892028809e+00, 2.8151273727416992e-04,
	1.1920928955078125e-07, 6.6757202148437500e-05,
	1.5497207641601562e-05}, /* L682 */
{7.0045652389526367e+00, 2.8522312641143799e-04,
	1.1920928955078125e-07, -7.9989433288574219e-05,
	1.9192695617675781e-05}, /* L683 */
{7.0611886978149414e+00, 2.8792023658752441e-04,
	1.1920928955078125e-07, -4.8160552978515625e-05,
	-1.1920928955078125e-05}, /* L684 */
{7.6420421600341797e+00, 3.1211972236633301e-04,
	1.1920928955078125e-07, -1.7666816711425781e-04,
	-5.8889389038085938e-05}, /* L685 */
{6.6049008369445801e+00, 2.7024745941162109e-04,
	1.1920928955078125e-07, -1.5711784362792969e-04,
	2.9897689819335938e-04}, /* L686 */
{6.9488863945007324e+00, 2.8499960899353027e-04,
	1.1920928955078125e-07, 7.9393386840820312e-04,
	-3.0636787414550781e-05}, /* L687 */
{1.0665770530700684e+01, 4.3746829032897949e-04,
	1.1920928955078125e-07, -5.7220458984375000e-05,
	-1.0079145431518555e-04}, /* L688 */
{7.7958474159240723e+00, 3.2046437263488770e-04,
	1.1920928955078125e-07, 2.7513504028320312e-04,
	6.6280364990234375e-05}, /* L689 */
{7.7893686294555664e+00, 3.2049417495727539e-04,
	1.1920928955078125e-07, 2.3388862609863281e-04,
	1.8620491027832031e-04}, /* L690 */
{9.5045824050903320e+00, 3.9159506559371948e-04,
	1.1920928955078125e-07, 2.5296211242675781e-04,
	6.9856643676757812e-05}, /* L691 */
{9.0786542892456055e+00, 3.7458539009094238e-04,
	1.1920928955078125e-07, -4.6312808990478516e-05,
	1.0275840759277344e-04}, /* L692 */
{7.8684535026550293e+00, 3.2514333724975586e-04,
	1.1920928955078125e-07, 5.7220458984375000e-05,
	2.7656555175781250e-05}, /* L693 */
{6.7370467185974121e+00, 2.7900934219360352e-04,
	1.1920928955078125e-07, -5.7399272918701172e-04,
	-3.8635730743408203e-04}, /* L694 */
{8.5003919601440430e+00, 3.5217404365539551e-04,
	1.1920928955078125e-07, 3.8266181945800781e-05,
	3.5405158996582031e-05}, /* L695 */
{9.9959678649902344e+00, 4.1472911834716797e-04,
	1.1920928955078125e-07, -6.5326690673828125e-05,
	4.1007995605468750e-05}, /* L696 */
{8.0143957138061523e+00, 3.3304840326309204e-04,
	1.1920928955078125e-07, -7.7247619628906250e-05,
	-1.8513202667236328e-04}, /* L697 */
{7.2788882255554199e+00, 3.0304491519927979e-04,
	1.1920928955078125e-07, 2.7251243591308594e-04,
	4.3106079101562500e-04}, /* L698 */
{6.6061153411865234e+00, 2.7544796466827393e-04,
	1.1920928955078125e-07, -4.8518180847167969e-05,
	-3.0374526977539062e-04}, /* L699 */
{8.7822275161743164e+00, 3.6653876304626465e-04,
	1.1920928955078125e-07, -9.5963478088378906e-05,
	9.7274780273437500e-05}, /* L700 */
{8.6333055496215820e+00, 3.6082416772842407e-04,
	1.1920928955078125e-07, 1.4352798461914062e-04,
	8.7141990661621094e-05}, /* L701 */
{8.0853452682495117e+00, 3.3844262361526489e-04,
	1.1920928955078125e-07, 4.9948692321777344e-05,
	2.0492076873779297e-04}, /* L702 */
{8.5849742889404297e+00, 3.5996735095977783e-04,
	1.1920928955078125e-07, -5.4180622100830078e-05,
	2.7418136596679688e-04}, /* L703 */
{6.3390564918518066e+00, 2.6606023311614990e-04,
	1.1920928955078125e-07, -2.1696090698242188e-05,
	5.8770179748535156e-05}, /* L704 */
{5.0792293548583984e+00, 2.1347403526306152e-04,
	1.1920928955078125e-07, -2.3186206817626953e-05,
	-2.5570392608642578e-05}, /* L705 */
{7.0104937553405762e+00, 2.9507279396057129e-04,
	1.1920928955078125e-07, -3.8564205169677734e-05,
	3.5643577575683594e-05}, /* L706 */
{7.3808908462524414e+00, 3.1113624572753906e-04,
	1.1920928955078125e-07, 5.1617622375488281e-05,
	-2.6941299438476562e-05}, /* L707 */
{8.7089757919311523e+00, 3.6770105361938477e-04,
	1.1920928955078125e-07, 1.6057491302490234e-04,
	1.0001659393310547e-04}, /* L708 */
{9.2227993011474609e+00, 3.8978457450866699e-04,
	1.1920928955078125e-07, -1.1324882507324219e-05,
	-6.4373016357421875e-06}, /* L709 */
{6.0974440574645996e+00, 2.5814771652221680e-04,
	1.1920928955078125e-07, 1.6283988952636719e-04,
	1.8727779388427734e-04}, /* L710 */
{6.7104215621948242e+00, 2.8456747531890869e-04,
	1.1920928955078125e-07, 2.9897689819335938e-04,
	-5.5432319641113281e-06}, /* L711 */
{7.5995836257934570e+00, 3.2255426049232483e-04,
	1.1920928955078125e-07, 6.2346458435058594e-05,
	2.9325485229492188e-05}, /* L712 */
{6.2053794860839844e+00, 2.6383996009826660e-04,
	1.1920928955078125e-07, -2.0682811737060547e-05,
	5.5551528930664062e-05}, /* L713 */
{5.9159865379333496e+00, 2.5341659784317017e-04,
	1.1920928955078125e-07, 6.1547756195068359e-04,
	-1.6034841537475586e-03}, /* L714 */
{8.8677330017089844e+00, 3.7811696529388428e-04,
	1.1920928955078125e-07, 5.0663948059082031e-05,
	-5.5730342864990234e-05}, /* L715 */
{8.0554504394531250e+00, 3.4391134977340698e-04,
	1.1920928955078125e-07, -5.4299831390380859e-05,
	-9.4354152679443359e-05}, /* L716 */
{1.0790423393249512e+01, 4.6125054359436035e-04,
	1.1920928955078125e-07, 8.6426734924316406e-05,
	-4.7028064727783203e-05}, /* L717 */
{6.2182388305664062e+00, 2.6617571711540222e-04,
	1.1920928955078125e-07, 3.4451484680175781e-05,
	-1.6212463378906250e-05}, /* L718 */
{7.1343040466308594e+00, 3.0592083930969238e-04,
	1.1920928955078125e-07, 1.0347366333007812e-04,
	7.2956085205078125e-05}, /* L719 */
{8.2860698699951172e+00, 3.5569071769714355e-04,
	1.1920928955078125e-07, -6.4790248870849609e-05,
	-1.8763542175292969e-04}, /* L720 */
{7.1563701629638672e+00, 3.0827522277832031e-04,
	1.1920928955078125e-07, -5.4556131362915039e-04,
	-5.7113170623779297e-04}, /* L721 */
{5.2885499000549316e+00, 2.2763013839721680e-04,
	1.1920928955078125e-07, -4.7683715820312500e-05,
	9.2983245849609375e-06}, /* L722 */
{8.4282093048095703e+00, 3.6332011222839355e-04,
	1.1920928955078125e-07, 1.3232231140136719e-05,
	-1.2278556823730469e-05}, /* L723 */
{6.7335762977600098e+00, 2.9063224792480469e-04,
	1.1920928955078125e-07, -1.6987323760986328e-05,
	2.9802322387695312e-06}, /* L724 */
{6.8393588066101074e+00, 2.9566884040832520e-04,
	1.1920928955078125e-07, -4.4703483581542969e-06,
	1.3363361358642578e-04}, /* L725 */
{8.1916122436523438e+00, 3.5479664802551270e-04,
	1.1920928955078125e-07, -2.8687715530395508e-04,
	-1.0555982589721680e-04}, /* L726 */
{1.0057626724243164e+01, 4.3618679046630859e-04,
	1.1920928955078125e-07, 9.0599060058593750e-05,
	1.3256072998046875e-04}, /* L727 */
{8.2804508209228516e+00, 3.5938620567321777e-04,
	1.1920928955078125e-07, -2.6822090148925781e-06,
	1.3113021850585938e-05}, /* L728 */
{8.9867591857910156e+00, 3.9061903953552246e-04,
	1.1920928955078125e-07, -1.5974044799804688e-04,
	7.6770782470703125e-05}, /* L729 */
{8.9876222610473633e+00, 3.9119273424148560e-04,
	1.1920928955078125e-07, 7.4028968811035156e-05,
	3.7908554077148438e-05}, /* L730 */
{8.2015705108642578e+00, 3.5753846168518066e-04,
	1.1920928955078125e-07, 3.5119056701660156e-04,
	-1.9150972366333008e-04}, /* L731 */
{6.7000770568847656e+00, 2.9262900352478027e-04,
	1.1920928955078125e-07, 2.4139881134033203e-04,
	9.8347663879394531e-05}, /* L732 */
{9.7955179214477539e+00, 4.2808055877685547e-04,
	1.1920928955078125e-07, -1.5318393707275391e-05,
	-1.2934207916259766e-04}, /* L733 */
{5.7265934944152832e+00, 2.5065243244171143e-04,
	1.1920928955078125e-07, -1.1503696441650391e-05,
	3.4308433532714844e-04}, /* L734 */
{7.8785099983215332e+00, 3.4585595130920410e-04,
	1.1920928955078125e-07, 4.4322013854980469e-04,
	5.0961971282958984e-04}, /* L735 */
{8.3072977066040039e+00, 3.6464631557464600e-04,
	1.1920928955078125e-07, -1.1330842971801758e-04,
	7.0571899414062500e-05}, /* L736 */
{9.4814682006835938e+00, 4.1818618774414062e-04,
	1.1920928955078125e-07, -1.0137557983398438e-03,
	1.1575222015380859e-04}, /* L737 */
{1.1035604476928711e+01, 4.8596411943435669e-04,
	1.1920928955078125e-07, 7.9393386840820312e-05,
	-2.3007392883300781e-05}, /* L738 */
{8.7980251312255859e+00, 3.8766860961914062e-04,
	1.1920928955078125e-07, 8.8095664978027344e-05,
	-5.7041645050048828e-05}, /* L739 */
{7.5682830810546875e+00, 3.3408403396606445e-04,
	1.1920928955078125e-07, -1.8030405044555664e-04,
	-2.3674964904785156e-04}, /* L740 */
{8.8847351074218750e+00, 3.9251148700714111e-04,
	1.1920928955078125e-07, 9.1910362243652344e-05,
	7.5340270996093750e-05}, /* L741 */
{7.2990503311157227e+00, 3.2299757003784180e-04,
	1.1920928955078125e-07, -1.4030933380126953e-04,
	-7.5340270996093750e-05}, /* L742 */
{6.4574847221374512e+00, 2.8865039348602295e-04,
	1.1920928955078125e-07, -9.6201896667480469e-04,
	3.2831430435180664e-03}, /* L743 */
{6.7214074134826660e+00, 2.9821693897247314e-04,
	1.1920928955078125e-07, -1.7935037612915039e-04,
	-1.3703107833862305e-04}, /* L744 */
{9.5222377777099609e+00, 4.2298436164855957e-04,
	1.1920928955078125e-07, -1.4030933380126953e-04,
	3.9100646972656250e-05}, /* L745 */
{7.9609889984130859e+00, 3.5411864519119263e-04,
	1.1920928955078125e-07, -5.6684017181396484e-05,
	-1.7893314361572266e-04}, /* L746 */
{6.9838838577270508e+00, 3.1105428934097290e-04,
	1.1920928955078125e-07, -2.4676322937011719e-05,
	-1.9609928131103516e-04}, /* L747 */
{7.3962712287902832e+00, 3.3020973205566406e-04,
	1.1920928955078125e-07, -3.0791759490966797e-04,
	2.6309490203857422e-04}, /* L748 */
{9.0633993148803711e+00, 4.0468573570251465e-04,
	1.1920928955078125e-07, 1.0490417480468750e-05,
	-6.2465667724609375e-05}, /* L749 */
{1.0837558746337891e+01, 4.8499554395675659e-04,
	1.1920928955078125e-07, 1.2314319610595703e-04,
	2.5510787963867188e-04}, /* L750 */
{1.0402518272399902e+01, 4.6579353511333466e-04,
	1.1920928955078125e-07, 1.8239021301269531e-05,
	-1.1014938354492188e-04}, /* L751 */
{7.7388896942138672e+00, 3.4693628549575806e-04,
	1.1920928955078125e-07, -8.3804130554199219e-05,
	-1.8954277038574219e-05}, /* L752 */
{7.5939197540283203e+00, 3.4110248088836670e-04,
	1.1920928955078125e-07, 2.8228759765625000e-04,
	-4.9948692321777344e-05}, /* L753 */
{8.7097263336181641e+00, 3.9178133010864258e-04,
	1.1920928955078125e-07, -5.1170587539672852e-04,
	-1.4674663543701172e-04}, /* L754 */
{9.0702714920043945e+00, 4.0833652019500732e-04,
	1.1920928955078125e-07, 4.9591064453125000e-05,
	1.4781951904296875e-05}, /* L755 */
{8.1227064132690430e+00, 3.6606192588806152e-04,
	1.1920928955078125e-07, -8.7976455688476562e-05,
	1.0490417480468750e-05}, /* L756 */
{7.6730532646179199e+00, 3.4640729427337646e-04,
	1.1920928955078125e-07, 2.8252601623535156e-05,
	-3.6835670471191406e-05}, /* L757 */
{1.0134935379028320e+01, 4.5846402645111084e-04,
	1.1920928955078125e-07, 1.4901161193847656e-04,
	1.9538402557373047e-04}, /* L758 */
{6.9048609733581543e+00, 3.1314790248870850e-04,
	1.1920928955078125e-07, 1.2874603271484375e-04,
	-6.2829256057739258e-04}, /* L759 */
{7.7992930412292480e+00, 3.5336613655090332e-04,
	1.1920928955078125e-07, -3.6776065826416016e-05,
	5.3644180297851562e-06}, /* L760 */
{8.5027685165405273e+00, 3.8606673479080200e-04,
	1.1920928955078125e-07, 1.0454654693603516e-04,
	-1.2439489364624023e-04}, /* L761 */
{7.6791214942932129e+00, 3.4906715154647827e-04,
	1.1920928955078125e-07, -4.1508674621582031e-04,
	6.1392784118652344e-05}, /* L762 */
{6.8766622543334961e+00, 3.1281914561986923e-04,
	1.1920928955078125e-07, -5.1379203796386719e-05,
	2.2649765014648438e-06}, /* L763 */
{8.6156454086303711e+00, 3.9255619049072266e-04,
	1.1920928955078125e-07, -5.2154064178466797e-05,
	6.0558319091796875e-05}, /* L764 */
{8.3844251632690430e+00, 3.8307532668113708e-04,
	1.1920928955078125e-07, -7.1823596954345703e-05,
	2.1934509277343750e-04}, /* L765 */
{6.3979949951171875e+00, 2.9218196868896484e-04,
	1.1920928955078125e-07, -1.1163949966430664e-04,
	5.6862831115722656e-05}, /* L766 */
{9.9218645095825195e+00, 4.5377016067504883e-04,
	1.1920928955078125e-07, -1.6385316848754883e-04,
	-1.5318393707275391e-05}, /* L767 */
{7.8084173202514648e+00, 3.5759806632995605e-04,
	1.1920928955078125e-07, -5.7876110076904297e-05,
	2.4807453155517578e-04}, /* L768 */
{1.1044349670410156e+01, 5.0637871026992798e-04,
	1.1920928955078125e-07, 8.8334083557128906e-05,
	1.5461444854736328e-04}, /* L769 */
{8.1790714263916016e+00, 3.7562102079391479e-04,
	1.1920928955078125e-07, 1.3315677642822266e-04,
	2.4938583374023438e-04}, /* L770 */
{9.6252794265747070e+00, 4.4268369674682617e-04,
	1.1920928955078125e-07, -3.5345554351806641e-04,
	1.5604496002197266e-04}, /* L771 */
{6.8106646537780762e+00, 3.1343102455139160e-04,
	1.1920928955078125e-07, -2.6822090148925781e-05,
	1.6450881958007812e-05}, /* L772 */
{6.2729587554931641e+00, 2.8958916664123535e-04,
	1.1920928955078125e-07, 7.2836875915527344e-04,
	-7.8749656677246094e-04}, /* L773 */
{8.6461124420166016e+00, 3.9894878864288330e-04,
	1.1920928955078125e-07, -2.0742416381835938e-05,
	-6.7949295043945312e-06}, /* L774 */
{9.8674850463867188e+00, 4.5603513717651367e-04,
	1.1920928955078125e-07, 2.5153160095214844e-05,
	-1.0609626770019531e-05}, /* L775 */
{7.4345932006835938e+00, 3.4393370151519775e-04,
	1.1920928955078125e-07, -1.0955333709716797e-04,
	1.7285346984863281e-05}, /* L776 */
{7.0629544258117676e+00, 3.2723508775234222e-04,
	1.1920928955078125e-07, 8.9287757873535156e-05,
	3.0994415283203125e-06}, /* L777 */
{8.3878841400146484e+00, 3.8927793502807617e-04,
	1.1920928955078125e-07, -1.9806623458862305e-04,
	1.0406970977783203e-04}, /* L778 */
{8.5910758972167969e+00, 3.9899349212646484e-04,
	1.1920928955078125e-07, 2.4676322937011719e-05,
	-1.4674663543701172e-04}, /* L779 */
{9.8810768127441406e+00, 4.5949220657348633e-04,
	1.1920928955078125e-07, -6.0796737670898438e-06,
	8.2492828369140625e-05}, /* L780 */
{8.6952352523803711e+00, 4.0529668331146240e-04,
	1.1920928955078125e-07, 4.4715404510498047e-04,
	9.1743469238281250e-04}, /* L781 */
{7.7183184623718262e+00, 3.6001950502395630e-04,
	1.1920928955078125e-07, 2.0325183868408203e-04,
	-3.1840801239013672e-04}, /* L782 */
{7.5804996490478516e+00, 3.5391002893447876e-04,
	1.1920928955078125e-07, 1.0573863983154297e-04,
	-7.9572200775146484e-05}, /* L783 */
{6.8012475967407227e+00, 3.1787157058715820e-04,
	1.1920928955078125e-07, -1.8179416656494141e-05,
	5.2571296691894531e-05}, /* L784 */
{8.8549165725708008e+00, 4.1441619396209717e-04,
	1.1920928955078125e-07, 4.9233436584472656e-05,
	-2.3066997528076172e-05}, /* L785 */
{6.8329825401306152e+00, 3.2022595405578613e-04,
	1.1920928955078125e-07, -5.8650970458984375e-05,
	-4.7564506530761719e-05}, /* L786 */
{7.3620939254760742e+00, 3.4543126821517944e-04,
	1.1920928955078125e-07, -1.4162063598632812e-04,
	-9.9122524261474609e-05}, /* L787 */
{8.0195131301879883e+00, 3.7685036659240723e-04,
	1.1920928955078125e-07, 6.4969062805175781e-05,
	-2.8634071350097656e-04}, /* L788 */
{9.8849315643310547e+00, 4.6503543853759766e-04,
	1.1920928955078125e-07, 3.5762786865234375e-07,
	3.6239624023437500e-05}, /* L789 */
{8.1383466720581055e+00, 3.8349255919456482e-04,
	1.1920928955078125e-07, 2.3734569549560547e-04,
	6.3419342041015625e-05}, /* L790 */
{9.7907018661499023e+00, 4.6168267726898193e-04,
	1.1920928955078125e-07, -4.4107437133789062e-05,
	6.5207481384277344e-05}, /* L791 */
{9.1269817352294922e+00, 4.3196603655815125e-04,
	1.1920928955078125e-07, -6.7645311355590820e-04,
	2.1386146545410156e-04}, /* L792 */
{7.6783223152160645e+00, 3.6326050758361816e-04,
	1.1920928955078125e-07, 1.8489360809326172e-04,
	7.9631805419921875e-05}, /* L793 */
{9.3443641662597656e+00, 4.4241547584533691e-04,
	1.1920928955078125e-07, -5.0187110900878906e-05,
	-1.0228157043457031e-04}, /* L794 */
{9.5055665969848633e+00, 4.5075267553329468e-04,
	1.1920928955078125e-07, -2.6655197143554688e-04,
	4.0817260742187500e-04}, /* L795 */
{8.1196222305297852e+00, 3.8543343544006348e-04,
	1.1920928955078125e-07, -1.6868114471435547e-05,
	-1.0025501251220703e-04}, /* L796 */
{8.9027862548828125e+00, 4.2298436164855957e-04,
	1.1920928955078125e-07, -5.1498413085937500e-05,
	-3.4749507904052734e-05}, /* L797 */
{1.0113772392272949e+01, 4.8115849494934082e-04,
	1.1920928955078125e-07, -7.0333480834960938e-06,
	5.1379203796386719e-05}, /* L798 */
{7.7061901092529297e+00, 3.6761164665222168e-04,
	1.1920928955078125e-07, -5.0371885299682617e-04,
	1.3732910156250000e-04}, /* L799 */
{7.1807823181152344e+00, 3.4257769584655762e-04,
	1.1920928955078125e-07, -3.8337707519531250e-04,
	8.9764595031738281e-05}, /* L800 */
{1.0569493293762207e+01, 5.0705671310424805e-04,
	1.1920928955078125e-07, -1.3415813446044922e-03,
	8.9073181152343750e-04}, /* L801 */
{8.6481199264526367e+00, 4.1349232196807861e-04,
	1.1920928955078125e-07, 4.2915344238281250e-05,
	6.3896179199218750e-05}, /* L802 */
{8.8410148620605469e+00, 4.2328238487243652e-04,
	1.1920928955078125e-07, -1.1116266250610352e-04,
	-1.3625621795654297e-04}, /* L803 */
{7.7730994224548340e+00, 3.7264823913574219e-04,
	1.1920928955078125e-07, -9.4771385192871094e-06,
	6.9260597229003906e-05}, /* L804 */
{9.7848482131958008e+00, 4.6965479850769043e-04,
	1.1920928955078125e-07, -5.4001808166503906e-05,
	-1.9192695617675781e-05}, /* L805 */
{9.9374942779541016e+00, 4.7755241394042969e-04,
	1.1920928955078125e-07, 6.3657760620117188e-05,
	6.7949295043945312e-05}, /* L806 */
{8.1404647827148438e+00, 3.9166212081909180e-04,
	1.1920928955078125e-07, 1.5950202941894531e-04,
	2.5749206542968750e-05}, /* L807 */
{7.8507919311523438e+00, 3.7817656993865967e-04,
	1.1920928955078125e-07, -1.7702579498291016e-05,
	6.0081481933593750e-05}, /* L808 */
{9.3072576522827148e+00, 4.4902600347995758e-04,
	1.1920928955078125e-07, -1.6099214553833008e-04,
	-1.2153387069702148e-04}, /* L809 */
{6.7192497253417969e+00, 3.2445788383483887e-04,
	1.1920928955078125e-07, -4.1246414184570312e-05,
	8.4161758422851562e-05}, /* L810 */
{9.8024320602416992e+00, 4.7415494918823242e-04,
	1.1920928955078125e-07, -3.0577182769775391e-05,
	-1.5139579772949219e-04}, /* L811 */
{8.9261360168457031e+00, 4.3240189552307129e-04,
	1.1920928955078125e-07, 1.4615058898925781e-04,
	-1.3309717178344727e-04}, /* L812 */
{8.1681880950927734e+00, 3.9589405059814453e-04,
	1.1920928955078125e-07, -5.5432319641113281e-06,
	3.1352043151855469e-05}, /* L813 */
{8.4278879165649414e+00, 4.0908157825469971e-04,
	1.1920928955078125e-07, -3.1751394271850586e-04,
	2.5033950805664062e-04}, /* L814 */
{1.0482943534851074e+01, 5.0938129425048828e-04,
	1.1920928955078125e-07, 2.7656555175781250e-05,
	1.0812282562255859e-04}, /* L815 */
{1.0743288040161133e+01, 5.2261352539062500e-04,
	1.1920928955078125e-07, 1.8835067749023438e-05,
	-2.9444694519042969e-05}, /* L816 */
{9.9636878967285156e+00, 4.8533082008361816e-04,
	1.1920928955078125e-07, 1.2624263763427734e-04,
	7.1167945861816406e-05}, /* L817 */
{9.3847723007202148e+00, 4.5779347419738770e-04,
	1.1920928955078125e-07, 2.2530555725097656e-05,
	-7.0571899414062500e-05}, /* L818 */
{9.0247249603271484e+00, 4.4091790914535522e-04,
	1.1920928955078125e-07, -2.9057264328002930e-04,
	8.2492828369140625e-05}, /* L819 */
{8.2970867156982422e+00, 4.0563941001892090e-04,
	1.1920928955078125e-07, -5.1617622375488281e-05,
	3.2305717468261719e-05}, /* L820 */
{9.8112707138061523e+00, 4.8026442527770996e-04,
	1.1920928955078125e-07, 1.1563301086425781e-05,
	4.1723251342773438e-05}, /* L821 */
{1.1379727363586426e+01, 5.5819749832153320e-04,
	1.1920928955078125e-07, 1.4245510101318359e-04,
	2.4235248565673828e-04}, /* L822 */
{8.1640119552612305e+00, 4.0069222450256348e-04,
	1.1920928955078125e-07, 6.2823295593261719e-05,
	2.0790100097656250e-04}, /* L823 */
{8.2890014648437500e+00, 4.0718913078308105e-04,
	1.1920928955078125e-07, 9.0956687927246094e-05,
	1.4376640319824219e-04}, /* L824 */
{1.0220774650573730e+01, 5.0273537635803223e-04,
	1.1920928955078125e-07, 1.8596649169921875e-05,
	1.4305114746093750e-06}, /* L825 */
{6.7883629798889160e+00, 3.3430755138397217e-04,
	1.1920928955078125e-07, -2.7000904083251953e-05,
	1.6987323760986328e-04}, /* L826 */
{1.2203616142272949e+01, 6.0164043679833412e-04,
	1.1920928955078125e-07, -5.3584575653076172e-05,
	1.7166137695312500e-05}, /* L827 */
{1.2532876014709473e+01, 6.1863288283348083e-04,
	1.1920928955078125e-07, -5.5611133575439453e-05,
	-4.5895576477050781e-06}, /* L828 */
{1.0567130088806152e+01, 5.2437186241149902e-04,
	1.1920928955078125e-07, -1.3938546180725098e-03,
	1.8682479858398438e-03}, /* L829 */
{1.0742480278015137e+01, 5.3201615810394287e-04,
	1.1920928955078125e-07, 1.5747547149658203e-04,
	1.2862682342529297e-04}, /* L830 */
{8.5930175781250000e+00, 4.2802095413208008e-04,
	1.1920928955078125e-07, 2.5243759155273438e-03,
	1.8072128295898438e-03}, /* L831 */
{7.2004580497741699e+00, 3.5721063613891602e-04,
	1.1920928955078125e-07, -1.1068582534790039e-04,
	7.2717666625976562e-06}, /* L832 */
{9.2003545761108398e+00, 4.5686960220336914e-04,
	1.1920928955078125e-07, -7.7486038208007812e-07,
	-5.0544738769531250e-05}, /* L833 */
{8.4907684326171875e+00, 4.2299181222915649e-04,
	1.1920928955078125e-07, 6.2716007232666016e-04,
	-9.7042322158813477e-04}, /* L834 */
{9.0714015960693359e+00, 4.5192241668701172e-04,
	1.1920928955078125e-07, 5.6326389312744141e-04,
	-1.3041496276855469e-04}, /* L835 */
{9.4950408935546875e+00, 4.7326087951660156e-04,
	1.1920928955078125e-07, -1.5497207641601562e-06,
	2.5510787963867188e-05}, /* L836 */
{8.6925086975097656e+00, 4.3383240699768066e-04,
	1.1920928955078125e-07, 3.3855438232421875e-05,
	-8.4638595581054688e-06}, /* L837 */
{8.0853195190429688e+00, 4.0407478809356689e-04,
	1.1920928955078125e-07, -1.1140108108520508e-04,
	-1.5455484390258789e-04}, /* L838 */
{7.8630151748657227e+00, 3.9374083280563354e-04,
	1.1920928955078125e-07, 2.0706653594970703e-04,
	-2.6410818099975586e-04}, /* L839 */
{9.0589151382446289e+00, 4.5368075370788574e-04,
	1.1920928955078125e-07, 3.8146972656250000e-05,
	-9.1612339019775391e-05}, /* L840 */
{8.3809690475463867e+00, 4.2021274566650391e-04,
	1.1920928955078125e-07, 7.4505805969238281e-05,
	-2.0444393157958984e-05}, /* L841 */
{1.0540531158447266e+01, 5.2915140986442566e-04,
	1.1920928955078125e-07, -1.6343593597412109e-04,
	3.7431716918945312e-05}, /* L842 */
{7.4543876647949219e+00, 3.7515163421630859e-04,
	1.1920928955078125e-07, 7.1609020233154297e-04,
	-9.0414285659790039e-04}, /* L843 */
{8.5354328155517578e+00, 4.2951107025146484e-04,
	1.1920928955078125e-07, 2.8491020202636719e-05,
	3.6716461181640625e-05}, /* L844 */
{8.4300947189331055e+00, 4.2486935853958130e-04,
	1.1920928955078125e-07, -1.4597177505493164e-04,
	4.0876865386962891e-04}, /* L845 */
{8.2337541580200195e+00, 4.1527301073074341e-04,
	1.1920928955078125e-07, 6.6518783569335938e-05,
	2.8014183044433594e-05}, /* L846 */
{8.3290538787841797e+00, 4.2076408863067627e-04,
	1.1920928955078125e-07, -7.9035758972167969e-05,
	1.8060207366943359e-04}, /* L847 */
{7.5480003356933594e+00, 3.8173794746398926e-04,
	1.1920928955078125e-07, 2.7430057525634766e-04,
	1.4173984527587891e-04}, /* L848 */
{8.8697738647460938e+00, 4.4900178909301758e-04,
	1.1920928955078125e-07, -8.6843967437744141e-05,
	-1.0097026824951172e-04}, /* L849 */
{9.8021516799926758e+00, 4.9680471420288086e-04,
	1.1920928955078125e-07, -5.5015087127685547e-05,
	5.6624412536621094e-05}, /* L850 */
{8.9112596511840820e+00, 4.5216083526611328e-04,
	1.1920928955078125e-07, 2.1719932556152344e-04,
	-2.1177530288696289e-04}, /* L851 */
{9.5952129364013672e+00, 4.8738718032836914e-04,
	1.1920928955078125e-07, 7.0810317993164062e-05,
	7.8797340393066406e-05}, /* L852 */
{7.8903055191040039e+00, 4.0155649185180664e-04,
	1.1920928955078125e-07, 6.2775611877441406e-04,
	-1.9526481628417969e-04}, /* L853 */
{8.9442834854125977e+00, 4.5560300350189209e-04,
	1.1920928955078125e-07, -4.3690204620361328e-05,
	-3.8206577301025391e-05}, /* L854 */
{7.5095682144165039e+00, 3.8337707519531250e-04,
	1.1920928955078125e-07, 1.0418891906738281e-04,
	1.0583400726318359e-03}, /* L855 */
{9.4125051498413086e+00, 4.8041343688964844e-04,
	1.1920928955078125e-07, 1.1074542999267578e-04,
	-4.4405460357666016e-05}, /* L856 */
{1.0305851936340332e+01, 5.2653253078460693e-04,
	1.1920928955078125e-07, 1.1205673217773438e-05,
	-5.3524971008300781e-05}, /* L857 */
{9.9415740966796875e+00, 5.0857663154602051e-04,
	1.1920928955078125e-07, 1.2993812561035156e-05,
	-6.8485736846923828e-05}, /* L858 */
{8.3125524520874023e+00, 4.2659044265747070e-04,
	1.1920928955078125e-07, 5.2773952484130859e-04,
	-7.9172849655151367e-04}, /* L859 */
{1.1204255104064941e+01, 5.8361887931823730e-04,
	1.1920928955078125e-07, 4.1208267211914062e-03,
	8.8322162628173828e-04}, /* L860 */
{9.1590785980224609e+00, 4.7016143798828125e-04,
	1.1920928955078125e-07, -2.2470951080322266e-05,
	-2.3841857910156250e-06}, /* L861 */
{9.8174877166748047e+00, 5.0452351570129395e-04,
	1.1920928955078125e-07, -1.0323524475097656e-04,
	8.6665153503417969e-05}, /* L862 */
{8.4300899505615234e+00, 4.3380272109061480e-04,
	1.1920928955078125e-07, 1.5795230865478516e-04,
	1.1920928955078125e-07}, /* L863 */
{8.6896991729736328e+00, 4.4766068458557129e-04,
	1.1920928955078125e-07, 6.5326690673828125e-05,
	-1.5676021575927734e-05}, /* L864 */
{8.3439798355102539e+00, 4.3044984340667725e-04,
	1.1920928955078125e-07, 9.8943710327148438e-05,
	-1.7166137695312500e-04}, /* L865 */
{9.4180641174316406e+00, 4.8670172691345215e-04,
	1.1920928955078125e-07, -2.0039081573486328e-04,
	-3.4868717193603516e-05}, /* L866 */
{7.7439107894897461e+00, 4.0078163146972656e-04,
	1.1920928955078125e-07, 3.6466121673583984e-04,
	3.9684772491455078e-04}, /* L867 */
{9.9742450714111328e+00, 5.1611661911010742e-04,
	1.1920928955078125e-07, 1.3709068298339844e-04,
	1.7881393432617188e-05}, /* L868 */
{1.0208351135253906e+01, 5.2896142005920410e-04,
	1.1920928955078125e-07, -1.6754865646362305e-04,
	-2.2351741790771484e-05}, /* L869 */
{9.6849508285522461e+00, 5.0308834761381149e-04,
	1.1920928955078125e-07, -3.8903951644897461e-04,
	3.2818317413330078e-04}, /* L870 */
{9.7295532226562500e+00, 5.0532817840576172e-04,
	1.1920928955078125e-07, -3.3974647521972656e-06,
	1.7619132995605469e-04}, /* L871 */
{7.8352098464965820e+00, 4.0777027606964111e-04,
	1.1920928955078125e-07, -2.8657913208007812e-04,
	-3.4213066101074219e-05}, /* L872 */
{8.2493562698364258e+00, 4.2936857789754868e-04,
	1.1920928955078125e-07, 2.8014183044433594e-05,
	1.5735626220703125e-05}, /* L873 */
{9.6728620529174805e+00, 5.0404667854309082e-04,
	1.1920928955078125e-07, 1.8060207366943359e-04,
	7.5936317443847656e-05}, /* L874 */
{1.0594155311584473e+01, 5.5433996021747589e-04,
	1.1920928955078125e-07, 7.1442127227783203e-04,
	4.8708915710449219e-04}, /* L875 */
{7.3986954689025879e+00, 3.8728117942810059e-04,
	1.1920928955078125e-07, -9.8156929016113281e-04,
	-2.1846294403076172e-03}, /* L876 */
{1.2028307914733887e+01, 6.2891095876693726e-04,
	1.1920928955078125e-07, 1.2600421905517578e-04,
	2.1576881408691406e-05}, /* L877 */
{9.0621461868286133e+00, 4.7445297241210938e-04,
	1.1920928955078125e-07, 8.0585479736328125e-05,
	1.2934207916259766e-04}, /* L878 */
{9.4628772735595703e+00, 4.9653649330139160e-04,
	1.1920928955078125e-07, 7.4315071105957031e-04,
	1.8227100372314453e-04}, /* L879 */
{7.7804293632507324e+00, 4.1131675243377686e-04,
	1.1920928955078125e-07, -2.9063820838928223e-03,
	-1.0851025581359863e-03}, /* L880 */
{9.5321464538574219e+00, 5.0139427185058594e-04,
	1.1920928955078125e-07, 2.2983551025390625e-04,
	7.5101852416992188e-05}, /* L881 */
{8.7506217956542969e+00, 4.6022236347198486e-04,
	1.1920928955078125e-07, 1.5556812286376953e-04,
	1.4567375183105469e-04}, /* L882 */
{1.0025440216064453e+01, 5.2818655967712402e-04,
	1.1920928955078125e-07, 5.9843063354492188e-05,
	-4.9531459808349609e-04}, /* L883 */
{9.8794288635253906e+00, 5.2073597908020020e-04,
	1.1920928955078125e-07, 1.1789798736572266e-04,
	-1.8960237503051758e-04}, /* L884 */
{7.8264408111572266e+00, 4.1304528713226318e-04,
	1.1920928955078125e-07, 2.0670890808105469e-04,
	4.1246414184570312e-05}, /* L885 */
{1.0312217712402344e+01, 5.4493546485900879e-04,
	1.1920928955078125e-07, 8.9287757873535156e-05,
	-3.0767917633056641e-04}, /* L886 */
{1.0027723312377930e+01, 5.3027272224426270e-04,
	1.1920928955078125e-07, -1.2570619583129883e-04,
	-5.3346157073974609e-05}, /* L887 */
{8.9498205184936523e+00, 4.7391653060913086e-04,
	1.1920928955078125e-07, -3.0994415283203125e-06,
	-1.1956691741943359e-04}, /* L888 */
{1.0855107307434082e+01, 5.7531148195266724e-04,
	1.1920928955078125e-07, 6.6757202148437500e-05,
	-2.0503997802734375e-05}, /* L889 */
{1.0481481552124023e+01, 5.5629760026931763e-04,
	1.1920928955078125e-07, -6.0617923736572266e-05,
	9.6559524536132812e-05}, /* L890 */
{9.1061229705810547e+00, 4.8390030860900879e-04,
	1.1920928955078125e-07, 2.5272369384765625e-05,
	-1.4942884445190430e-04}, /* L891 */
{1.0204853057861328e+01, 5.4278969764709473e-04,
	1.1920928955078125e-07, -2.7322769165039062e-04,
	4.8160552978515625e-05}, /* L892 */
{8.9950323104858398e+00, 4.7889351844787598e-04,
	1.1920928955078125e-07, 7.6770782470703125e-05,
	5.0067901611328125e-06}, /* L893 */
{8.1319837570190430e+00, 4.3380260467529297e-04,
	1.1920928955078125e-07, -1.2904405593872070e-04,
	6.2978267669677734e-04}, /* L894 */
{1.0173254966735840e+01, 5.4356455802917480e-04,
	1.1920928955078125e-07, 9.0825557708740234e-04,
	-4.1401386260986328e-04}, /* L895 */
{9.9297447204589844e+00, 5.3039193153381348e-04,
	1.1920928955078125e-07, -4.8518180847167969e-05,
	1.1920928955078125e-05}, /* L896 */
{1.0142393112182617e+01, 5.4265558719635010e-04,
	1.1920928955078125e-07, 3.0219554901123047e-04,
	4.2283535003662109e-04}, /* L897 */
{1.0224027633666992e+01, 5.4752826690673828e-04,
	1.1920928955078125e-07, 1.2278556823730469e-05,
	-3.7807226181030273e-04}, /* L898 */
{8.8116769790649414e+00, 4.7311186790466309e-04,
	1.1920928955078125e-07, -3.3962726593017578e-04,
	-2.0164251327514648e-04}, /* L899 */
{1.1354292869567871e+01, 6.0933828353881836e-04,
	1.1920928955078125e-07, -1.9192695617675781e-05,
	-6.9439411163330078e-05}, /* L900 */
{1.0896154403686523e+01, 5.8621913194656372e-04,
	1.1920928955078125e-07, 6.9081783294677734e-04,
	3.3354759216308594e-04}, /* L901 */
{9.5811986923217773e+00, 5.1528215408325195e-04,
	1.1920928955078125e-07, -3.4391880035400391e-05,
	4.5895576477050781e-05}, /* L902 */
{1.1146021842956543e+01, 6.0030817985534668e-04,
	1.1920928955078125e-07, 2.1028518676757812e-04,
	-7.1287155151367188e-05}, /* L903 */
{8.6788101196289062e+00, 4.6783685684204102e-04,
	1.1920928955078125e-07, 2.0515918731689453e-04,
	7.3909759521484375e-05}, /* L904 */
{8.5921926498413086e+00, 4.6461820602416992e-04,
	1.1920928955078125e-07, -1.2883543968200684e-03,
	-1.2427568435668945e-04}, /* L905 */
{8.4939489364624023e+00, 4.5879930257797241e-04,
	1.1920928955078125e-07, 4.1246414184570312e-05,
	-1.2814998626708984e-05}, /* L906 */
{1.1787450790405273e+01, 6.3760578632354736e-04,
	1.1920928955078125e-07, -6.5565109252929688e-07,
	2.2852420806884766e-04}, /* L907 */
{1.3179844856262207e+01, 7.1705877780914307e-04,
	1.1920928955078125e-07, 5.5527687072753906e-04,
	-1.5602707862854004e-03}, /* L908 */
{1.0362262725830078e+01, 5.6158751249313354e-04,
	1.1920928955078125e-07, -1.0615587234497070e-04,
	-4.8696994781494141e-05}, /* L909 */
{1.1510843276977539e+01, 6.2486529350280762e-04,
	1.1920928955078125e-07, 1.3244152069091797e-04,
	1.3911724090576172e-04}, /* L910 */
{9.1452360153198242e+00, 4.9859285354614258e-04,
	1.1920928955078125e-07, -1.3246536254882812e-03,
	-1.1637210845947266e-03}, /* L911 */
{7.6625580787658691e+00, 4.1878223419189453e-04,
	1.1920928955078125e-07, 2.0527839660644531e-03,
	-3.9935111999511719e-05}, /* L912 */
{9.5056152343750000e+00, 5.1741674542427063e-04,
	1.1920928955078125e-07, -1.9371509552001953e-05,
	5.5432319641113281e-05}, /* L913 */
{6.5595908164978027e+00, 3.5750865936279297e-04,
	1.1920928955078125e-07, -5.4836273193359375e-05,
	-1.0627508163452148e-04}, /* L914 */
{1.0059088706970215e+01, 5.4885447025299072e-04,
	1.1920928955078125e-07, 1.4376640319824219e-04,
	-4.2021274566650391e-05}, /* L915 */
{1.0142908096313477e+01, 5.6873634457588196e-04,
	1.1920928955078125e-07, 1.1594295501708984e-03,
	-6.8448781967163086e-03}, /* L916 */
{1.0483978271484375e+01, 5.7320296764373779e-04,
	1.1920928955078125e-07, -5.1259994506835938e-06,
	-1.1259317398071289e-04}, /* L917 */
{6.8637399673461914e+00, 4.2021274566650391e-04,
	1.1920928955078125e-07, -2.5805950164794922e-02,
	-6.7583143711090088e-02}, /* L918 */
{1.2185496330261230e+01, 6.6886097192764282e-04,
	1.1920928955078125e-07, -3.4928321838378906e-05,
	6.4456462860107422e-04}, /* L919 */
{1.2233646392822266e+01, 6.7143142223358154e-04,
	1.1920928955078125e-07, 9.0599060058593750e-06,
	1.2326240539550781e-04}, /* L920 */
{1.3170442581176758e+01, 7.2374939918518066e-04,
	1.1920928955078125e-07, -1.3434886932373047e-04,
	2.6845932006835938e-04}, /* L921 */
{9.4261188507080078e+00, 5.1849335432052612e-04,
	1.1920928955078125e-07, -4.2694807052612305e-04,
	-7.1722269058227539e-04}, /* L922 */
{1.1733778953552246e+01, 6.4602494239807129e-04,
	1.1920928955078125e-07, -2.4253129959106445e-04,
	-3.9511919021606445e-04}, /* L923 */
{9.1030464172363281e+00, 5.0285458564758301e-04,
	1.1920928955078125e-07, 1.2797117233276367e-03,
	1.3979673385620117e-03}, /* L924 */
{1.1392621994018555e+01, 6.2845647335052490e-04,
	1.1920928955078125e-07, 1.1217594146728516e-04,
	-7.0929527282714844e-05}, /* L925 */
{9.3943872451782227e+00, 5.1929056644439697e-04,
	1.1920928955078125e-07, -3.9207935333251953e-04,
	-7.7319145202636719e-04}, /* L926 */
{1.0573058128356934e+01, 5.8455765247344971e-04,
	1.1920928955078125e-07, 1.7619132995605469e-04,
	-3.5047531127929688e-04}, /* L927 */
{8.7874736785888672e+00, 4.8616528511047363e-04,
	1.1920928955078125e-07, 1.5497207641601562e-05,
	4.3392181396484375e-05}, /* L928 */
{1.0296479225158691e+01, 5.7037919759750366e-04,
	1.1920928955078125e-07, 2.7191638946533203e-04,
	-1.5097856521606445e-04}, /* L929 */
{9.0902729034423828e+00, 5.0977617502212524e-04,
	1.1920928955078125e-07, 3.2520294189453125e-04,
	-1.1402368545532227e-04}, /* L930 */
{9.5255393981933594e+00, 5.2882730960845947e-04,
	1.1920928955078125e-07, -8.4638595581054688e-06,
	-1.0293722152709961e-04}, /* L931 */
{7.0039806365966797e+00, 3.9994716644287109e-04,
	1.1920928955078125e-07, -2.5570392608642578e-04,
	3.7807226181030273e-03}, /* L932 */
{1.0187489509582520e+01, 5.6668370962142944e-04,
	1.1920928955078125e-07, 2.9683113098144531e-05,
	5.6385993957519531e-05}, /* L933 */
{7.8153548240661621e+00, 4.3529272079467773e-04,
	1.1920928955078125e-07, -1.5920400619506836e-04,
	1.9586086273193359e-04}, /* L934 */
{9.5917797088623047e+00, 5.3465366363525391e-04,
	1.1920928955078125e-07, -6.1690807342529297e-05,
	-2.5629997253417969e-06}, /* L935 */
{9.4538898468017578e+00, 5.3317472338676453e-04,
	1.1920928955078125e-07, -9.6476078033447266e-04,
	3.0534267425537109e-03}, /* L936 */
{1.3311546325683594e+01, 7.4370950460433960e-04,
	1.1920928955078125e-07, -6.0498714447021484e-05,
	1.6570091247558594e-05}, /* L937 */
{8.9440031051635742e+00, 5.0088763236999512e-04,
	1.1920928955078125e-07, 6.2561035156250000e-04,
	-3.5405158996582031e-05}, /* L938 */
{9.0030832290649414e+00, 5.0456076860427856e-04,
	1.1920928955078125e-07, 2.5403499603271484e-04,
	8.9454650878906250e-04}, /* L939 */
{9.3538589477539062e+00, 5.2461028099060059e-04,
	1.1920928955078125e-07, -3.0106306076049805e-04,
	-1.8739700317382812e-04}, /* L940 */
{9.2046861648559570e+00, 5.1662232726812363e-04,
	1.1920928955078125e-07, 3.2043457031250000e-04,
	-3.6537647247314453e-05}, /* L941 */
{9.8434581756591797e+00, 5.5298209190368652e-04,
	1.1920928955078125e-07, 5.4359436035156250e-05,
	2.2041797637939453e-04}, /* L942 */
{1.0460096359252930e+01, 5.8874487876892090e-04,
	1.1920928955078125e-07, -5.3822994232177734e-05,
	-2.4038553237915039e-04}, /* L943 */
{1.1455904960632324e+01, 6.4471364021301270e-04,
	1.1920928955078125e-07, -2.7477741241455078e-05,
	5.6982040405273438e-05}, /* L944 */
{9.5424175262451172e+00, 5.3769350051879883e-04,
	1.1920928955078125e-07, -1.5932321548461914e-04,
	4.3034553527832031e-05}, /* L945 */
{7.3770170211791992e+00, 4.1612982749938965e-04,
	1.1920928955078125e-07, -5.7637691497802734e-05,
	2.0384788513183594e-05}, /* L946 */
{1.1339417457580566e+01, 6.4063072204589844e-04,
	1.1920928955078125e-07, 3.4356117248535156e-04,
	2.7191638946533203e-04}, /* L947 */
{9.6250896453857422e+00, 5.4407864809036255e-04,
	1.1920928955078125e-07, -9.6559524536132812e-06,
	1.3113021850585938e-05}, /* L948 */
{1.0731884956359863e+01, 6.0723721981048584e-04,
	1.1920928955078125e-07, -7.5578689575195312e-05,
	-1.0544061660766602e-04}, /* L949 */
{9.0658407211303711e+00, 5.1362812519073486e-04,
	1.1920928955078125e-07, -2.1952390670776367e-04,
	4.7123432159423828e-04}, /* L950 */
{9.0061922073364258e+00, 5.1075220108032227e-04,
	1.1920928955078125e-07, -8.0227851867675781e-05,
	-2.7024745941162109e-04}, /* L951 */
{1.0606670379638672e+01, 6.0208141803741455e-04,
	1.1920928955078125e-07, 3.9339065551757812e-06,
	-4.5537948608398438e-05}, /* L952 */
{9.3217401504516602e+00, 5.2991509437561035e-04,
	1.1920928955078125e-07, -5.8531761169433594e-05,
	2.3651123046875000e-04}, /* L953 */
{1.2256339073181152e+01, 6.9776363670825958e-04,
	1.1920928955078125e-07, -1.1241436004638672e-04,
	3.7395954132080078e-04}, /* L954 */
{1.1326392173767090e+01, 6.4510107040405273e-04,
	1.1920928955078125e-07, 3.1828880310058594e-05,
	5.8221817016601562e-04}, /* L955 */
{1.1273021697998047e+01, 6.4358115196228027e-04,
	1.1920928955078125e-07, -8.8590383529663086e-04,
	2.1946430206298828e-04}, /* L956 */
{1.0715250015258789e+01, 6.1142444610595703e-04,
	1.1920928955078125e-07, -1.4001131057739258e-04,
	-3.6835670471191406e-05}, /* L957 */
{1.0085085868835449e+01, 5.7616829872131348e-04,
	1.1920928955078125e-07, -3.0934810638427734e-05,
	9.1075897216796875e-05}, /* L958 */
{9.9763650894165039e+00, 5.7068467140197754e-04,
	1.1920928955078125e-07, 6.8068504333496094e-05,
	3.2162666320800781e-04}, /* L959 */
{1.0381855964660645e+01, 5.9464573860168457e-04,
	1.1920928955078125e-07, -3.9517879486083984e-05,
	5.4037570953369141e-04}, /* L960 */
{1.1508152008056641e+01, 6.5937638282775879e-04,
	1.1920928955078125e-07, -9.1314315795898438e-05,
	2.1016597747802734e-04}, /* L961 */
{9.7341852188110352e+00, 5.5855512619018555e-04,
	1.1920928955078125e-07, -3.2210350036621094e-04,
	-2.7519464492797852e-04}, /* L962 */
{8.9531869888305664e+00, 5.1404535770416260e-04,
	1.1920928955078125e-07, -1.0359287261962891e-04,
	-1.9872188568115234e-04}, /* L963 */
{1.0462536811828613e+01, 6.0136616230010986e-04,
	1.1920928955078125e-07, 4.6133995056152344e-05,
	-3.0398368835449219e-06}, /* L964 */
{9.3554477691650391e+00, 5.3861737251281738e-04,
	1.1920928955078125e-07, -1.5497207641601562e-06,
	-4.9829483032226562e-05}, /* L965 */
{1.1124286651611328e+01, 6.4320862293243408e-04,
	1.1920928955078125e-07, 6.1643123626708984e-04,
	-3.2126903533935547e-05}, /* L966 */
{8.9970512390136719e+00, 5.1872432231903076e-04,
	1.1920928955078125e-07, 4.1365623474121094e-05,
	-2.9563903808593750e-05}, /* L967 */
{1.0323065757751465e+01, 5.9577822685241699e-04,
	1.1920928955078125e-07, 1.0931491851806641e-04,
	1.9907951354980469e-05}, /* L968 */
{9.5731115341186523e+00, 5.5319070816040039e-04,
	1.1920928955078125e-07, 1.1074542999267578e-04,
	2.5033950805664062e-06}, /* L969 */
{1.0784428596496582e+01, 6.2391161918640137e-04,
	1.1920928955078125e-07, 1.0919570922851562e-04,
	2.1529197692871094e-04}, /* L970 */
{1.1896026611328125e+01, 6.8905949592590332e-04,
	1.1920928955078125e-07, -1.2791156768798828e-04,
	-2.2602081298828125e-04}, /* L971 */
{1.2135169982910156e+01, 7.0384144783020020e-04,
	1.1920928955078125e-07, -2.0962953567504883e-04,
	2.0158290863037109e-04}, /* L972 */
{1.0789814949035645e+01, 6.2644481658935547e-04,
	1.1920928955078125e-07, 1.8596649169921875e-04,
	8.6069107055664062e-05}, /* L973 */
{8.9428577423095703e+00, 5.1948428153991699e-04,
	1.1920928955078125e-07, 2.7513504028320312e-04,
	8.3327293395996094e-05}, /* L974 */
{1.1117540359497070e+01, 6.4677000045776367e-04,
	1.1920928955078125e-07, 4.7099590301513672e-04,
	1.8084049224853516e-04}, /* L975 */
{9.4324874877929688e+00, 5.4883956909179688e-04,
	1.1920928955078125e-07, -5.5849552154541016e-05,
	3.6597251892089844e-05}, /* L976 */
{9.9638156890869141e+00, 5.8031082153320312e-04,
	1.1920928955078125e-07, -1.1563301086425781e-05,
	3.0159950256347656e-05}, /* L977 */
{1.1609551429748535e+01, 6.7691504955291748e-04,
	1.1920928955078125e-07, 2.3722648620605469e-05,
	7.9989433288574219e-05}, /* L978 */
{1.0608478546142578e+01, 6.1939656734466553e-04,
	1.1920928955078125e-07, -8.6903572082519531e-05,
	4.2033195495605469e-04}, /* L979 */
{8.4362697601318359e+00, 4.9486756324768066e-04,
	1.1920928955078125e-07, -1.4864802360534668e-03,
	1.7452239990234375e-03}, /* L980 */
{9.7265644073486328e+00, 5.6907534599304199e-04,
	1.1920928955078125e-07, -1.4030933380126953e-04,
	2.5689601898193359e-04}, /* L981 */
{9.4599523544311523e+00, 5.5414438247680664e-04,
	1.1920928955078125e-07, 1.8525123596191406e-04,
	5.2011013031005859e-04}, /* L982 */
{1.2863492012023926e+01, 7.5390934944152832e-04,
	1.1920928955078125e-07, 2.2768974304199219e-05,
	4.0650367736816406e-05}, /* L983 */
{9.7873058319091797e+00, 5.7449936866760254e-04,
	1.1920928955078125e-07, -1.9872188568115234e-04,
	3.0755996704101562e-05}, /* L984 */
{1.0202817916870117e+01, 6.0078501701354980e-04,
	1.1920928955078125e-07, 1.5604496002197266e-03,
	-5.0497055053710938e-04}, /* L985 */
{7.9735250473022461e+00, 4.6873092651367188e-04,
	1.1920928955078125e-07, 6.9737434387207031e-05,
	-4.4763088226318359e-05}, /* L986 */
{8.5263195037841797e+00, 5.0173699855804443e-04,
	1.1920928955078125e-07, 7.5578689575195312e-05,
	-5.8054924011230469e-05}, /* L987 */
{9.1204433441162109e+00, 5.3745508193969727e-04,
	1.1920928955078125e-07, 1.7881393432617188e-06,
	-9.1671943664550781e-05}, /* L988 */
{9.2427177429199219e+00, 5.4496526718139648e-04,
	1.1920928955078125e-07, -7.6770782470703125e-05,
	1.9037723541259766e-04}, /* L989 */
{8.9276609420776367e+00, 5.2729249000549316e-04,
	1.1920928955078125e-07, -2.3061037063598633e-04,
	-8.5198879241943359e-04}, /* L990 */
{8.8264904022216797e+00, 5.2192807197570801e-04,
	1.1920928955078125e-07, -4.0757656097412109e-04,
	-8.2027912139892578e-04}, /* L991 */
{1.0676711082458496e+01, 6.3160806894302368e-04,
	1.1920928955078125e-07, -1.3452768325805664e-04,
	3.0159950256347656e-05}, /* L992 */
{1.1839732170104980e+01, 7.0306658744812012e-04,
	1.1920928955078125e-07, 1.7281770706176758e-03,
	-2.2232532501220703e-04}, /* L993 */
{1.0783862113952637e+01, 6.4065121114253998e-04,
	1.1920928955078125e-07, 6.9916248321533203e-04,
	-4.1025876998901367e-04}, /* L994 */
{1.2578942298889160e+01, 7.4702501296997070e-04,
	1.1920928955078125e-07, -3.4588575363159180e-04,
	-3.4421682357788086e-04}, /* L995 */
{8.6372623443603516e+00, 5.1289796829223633e-04,
	1.1920928955078125e-07, -1.2409687042236328e-04,
	-1.1491775512695312e-04}, /* L996 */
{1.1118403434753418e+01, 6.6128373146057129e-04,
	1.1920928955078125e-07, 7.9751014709472656e-05,
	-1.1217594146728516e-04}, /* L997 */
{1.2720804214477539e+01, 7.5832009315490723e-04,
	1.1920928955078125e-07, 1.3470649719238281e-04,
	3.5548210144042969e-04}, /* L998 */
{1.1835504531860352e+01, 7.0568919181823730e-04,
	1.1920928955078125e-07, -1.2338161468505859e-04,
	2.0146369934082031e-05}, /* L999 */
{9.9209365844726562e+00, 5.9160590171813965e-04,
	1.1920928955078125e-07, 7.9035758972167969e-05,
	-1.1682510375976562e-05}, /* L1000 */
{1.6806556701660156e+01, 2.0261406898498535e-03,
	1.1920928955078125e-07, -3.6427378654479980e-03,
	1.5962123870849609e-03}, /* L1001 */
{2.3323837280273438e+01, 4.2076110839843750e-03,
	1.1920928955078125e-07, 2.6699304580688477e-03,
	4.3749809265136719e-05}, /* L1002 */
{3.6291336059570312e+01, 8.7019801139831543e-03,
	1.1920928955078125e-07, -1.4978647232055664e-04,
	2.6834011077880859e-04}, /* L1003 */
{4.5923114776611328e+01, 1.3769924640655518e-02,
	1.1920928955078125e-07, 1.5914440155029297e-04,
	-6.0558319091796875e-05}, /* L1004 */
{5.3506553649902344e+01, 1.9319653511047363e-02,
	1.1920928955078125e-07, 1.2971162796020508e-03,
	1.5259981155395508e-03}, /* L1005 */
{5.5544055938720703e+01, 2.4212539196014404e-02,
	1.1920928955078125e-07, -4.0019154548645020e-03,
	-4.3381452560424805e-03}, /* L1006 */
{6.1873199462890625e+01, 3.1397029757499695e-02,
	1.1920928955078125e-07, -7.6299905776977539e-04,
	1.0329604148864746e-02}, /* L1007 */
{7.3244987487792969e+01, 4.2697429656982422e-02,
	1.1920928955078125e-07, -1.8775463104248047e-04,
	-1.4420807361602783e-02}, /* L1008 */
{8.1817268371582031e+01, 4.9257040023803711e-02,
	1.1920928955078125e-07, 4.1556358337402344e-03,
	-2.7217864990234375e-03}, /* L1009 */
#endif  /* } */

/* Always the last one. Common to both DP and SP */

{0.0000000000000000e+00, 0.0000000000000000e+00,
	0.0000000000000000e+00, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L1010 */
};

#ifdef __cplusplus
}
#endif

#endif	/* _SINGDOUB64V9B_SS12_H */
