/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 * Copyright 2009 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */


#ifndef	_MMS_SYM_H_
#define	_MMS_SYM_H_

#ifdef	__cplusplus
extern "C" {
#endif

typedef	struct	mms_sym	{
	char	*sym_token;
	int	sym_code;
}	mms_sym_t;

/*
 * These are Numeric Error codes
 * MMS error codes are biased by MMS_ERR_BIAS to avoid conflicting with
 * error codes.
 */

/*
 * If you add a new error code, you must also update the error code table
 * in mms_sym.c.
 */


#define	MMS_ERR_BIAS				0x00ff0000

/*
 * The following are error codes added by MMS for client API
 */

/*
 * The following are class codes
 */
#define	MMS_COMPAT				(MMS_ERR_BIAS + 1)
#define	MMS_CONFIG				(MMS_ERR_BIAS + 2)
#define	MMS_EXIST				(MMS_ERR_BIAS + 3)
#define	MMS_EXPLICIT				(MMS_ERR_BIAS + 4)
#define	MMS_INTERNAL				(MMS_ERR_BIAS + 5)
#define	MMS_INVALID				(MMS_ERR_BIAS + 6)
#define	MMS_PERMPRIV				(MMS_ERR_BIAS + 7)
#define	MMS_RETRY				(MMS_ERR_BIAS + 8)
#define	MMS_SUBOP				(MMS_ERR_BIAS + 9)
#define	MMS_LANGUAGE				(MMS_ERR_BIAS + 10)
#define	MMS_STATE				(MMS_ERR_BIAS + 11)
#define	MMS_DM_C_INVALID			(MMS_ERR_BIAS + 12)
#define	MMS_DM_C_COMMAND			(MMS_ERR_BIAS + 13)
#define	MMS_LM_C_INVALID			(MMS_ERR_BIAS + 14)
#define	MMS_LM_C_COMMAND			(MMS_ERR_BIAS + 15)
#define	MMS_MM_C_INVALID			(MMS_ERR_BIAS + 16)
#define	MMS_MM_C_MANAGEMENT			(MMS_ERR_BIAS + 17)

/*
 * The following are error codes
 */
#define	MMS_UNKNOWN_CODE			(MMS_ERR_BIAS + 50)

#define	MMS_E_NET_IO_ERR			(MMS_ERR_BIAS + 51)
#define	MMS_E_SYNTAX_ERR			(MMS_ERR_BIAS + 52)
#define	MMS_E_INVALID_RESPONSE			(MMS_ERR_BIAS + 53)
#define	MMS_E_UNKNOWN_ERR_STRING		(MMS_ERR_BIAS + 54)
#define	MMS_E_OUTOFMEMORY			(MMS_ERR_BIAS + 55)
#define	MMS_E_CONNECT_ERR			(MMS_ERR_BIAS + 56)

#define	MMS_MALLOC_ERROR			(MMS_ERR_BIAS + 57)
#define	MMS_SELECT_ERROR			(MMS_ERR_BIAS + 58)
#define	MMS_UNACCEPTABLE_RSP			(MMS_ERR_BIAS + 59)
#define	MMS_INVALID_RSP				(MMS_ERR_BIAS + 60)
#define	MMS_INVALID_RSP_CODE			(MMS_ERR_BIAS + 61)
#define	MMS_MISSING_TASKID			(MMS_ERR_BIAS + 62)
#define	MMS_WRONG_TASKID			(MMS_ERR_BIAS + 63)

#define	MMS_TRACE_FAILURE			(MMS_ERR_BIAS + 64)
#define	MMS_WRONG_API_MODE			(MMS_ERR_BIAS + 65)
#define	MMS_ASYNC_API_FAILURE			(MMS_ERR_BIAS + 66)
#define	MMS_API_ERR				(MMS_ERR_BIAS + 67)
#define	MMS_API_NOT_ERR_RSP			(MMS_ERR_BIAS + 68)
#define	MMS_CFG_FILE_ERR			(MMS_ERR_BIAS + 69)
#define	MMS_DUPLICATE_REG			(MMS_ERR_BIAS + 70)
#define	MMS_EV_REG_FAILED			(MMS_ERR_BIAS + 71)
#define	MMS_EV_UNREG_FAILED			(MMS_ERR_BIAS + 72)
#define	MMS_API_SHUTDOWN			(MMS_ERR_BIAS + 73)
#define	MMS_INVALID_REQ				(MMS_ERR_BIAS + 74)

#define	MMS_E_SSL_CERT_CLAUSE			(MMS_ERR_BIAS + 75)
#define	MMS_E_WELCOME_PASSWORD			(MMS_ERR_BIAS + 76)
#define	MMS_E_NO_WELCOME_PASSWORD		(MMS_ERR_BIAS + 77)
#define	MMS_E_SSL_VERIFY			(MMS_ERR_BIAS + 78)

/*
 * The following are error codes defined in the MMS spec.
 */
#define	MMS_DM_E_AGAIN				(MMS_ERR_BIAS + 503)
#define	MMS_DM_E_BADHANDLE			(MMS_ERR_BIAS + 504)
#define	MMS_DM_E_BADVAL				(MMS_ERR_BIAS + 505)
#define	MMS_DM_E_CMDARGS			(MMS_ERR_BIAS + 506)
#define	MMS_DM_E_DEVADMINCLT			(MMS_ERR_BIAS + 507)
#define	MMS_DM_E_DEVCMD				(MMS_ERR_BIAS + 508)
#define	MMS_DM_E_DEVCMDABORT			(MMS_ERR_BIAS + 509)
#define	MMS_DM_E_DEVCMDILLEGAL			(MMS_ERR_BIAS + 510)
#define	MMS_DM_E_DEVCMDTEMEOUT			(MMS_ERR_BIAS + 511)
#define	MMS_DM_E_DEVCOMMERR			(MMS_ERR_BIAS + 512)
#define	MMS_DM_E_DEVDET				(MMS_ERR_BIAS + 513)
#define	MMS_DM_E_DEVEMPTY			(MMS_ERR_BIAS + 514)
#define	MMS_DM_E_DEVFULL			(MMS_ERR_BIAS + 515)
#define	MMS_DM_E_DEVNORESPONSE			(MMS_ERR_BIAS + 516)
#define	MMS_DM_E_DEVOPERATOR			(MMS_ERR_BIAS + 517)
#define	MMS_DM_E_DEVOVERFLOW			(MMS_ERR_BIAS + 518)
#define	MMS_DM_E_DEVPERM			(MMS_ERR_BIAS + 519)
#define	MMS_DM_E_DEVPREV			(MMS_ERR_BIAS + 520)
#define	MMS_DM_E_DEVRESET			(MMS_ERR_BIAS + 521)
#define	MMS_DM_E_DEVSYNCHERR			(MMS_ERR_BIAS + 522)
#define	MMS_DM_E_DRIVE				(MMS_ERR_BIAS + 523)
#define	MMS_DM_E_HANDLEBUSY			(MMS_ERR_BIAS + 524)
#define	MMS_DM_E_HANDLEINUSE			(MMS_ERR_BIAS + 525)
#define	MMS_DM_E_INTERNAL			(MMS_ERR_BIAS + 526)
#define	MMS_DM_E_LIBRARY			(MMS_ERR_BIAS + 527)
#define	MMS_DM_E_MODE				(MMS_ERR_BIAS + 528)
#define	MMS_DM_E_NOCANC				(MMS_ERR_BIAS + 529)
#define	MMS_DM_E_NOCART				(MMS_ERR_BIAS + 530)
#define	MMS_DM_E_NOELT				(MMS_ERR_BIAS + 531)
#define	MMS_DM_E_NOEXISTHANDLE			(MMS_ERR_BIAS + 532)
#define	MMS_DM_E_NOID				(MMS_ERR_BIAS + 533)
#define	MMS_DM_E_NOTASK				(MMS_ERR_BIAS + 534)
#define	MMS_DM_E_READY				(MMS_ERR_BIAS + 535)
#define	MMS_DM_E_UNKNOWN			(MMS_ERR_BIAS + 536)
#define	MMS_EACCHANDLESTILLINUSE		(MMS_ERR_BIAS + 537)
#define	MMS_EAPPACCESSTOCART			(MMS_ERR_BIAS + 538)
#define	MMS_EAPPCARTNOACC			(MMS_ERR_BIAS + 539)
#define	MMS_EAPPDMDIFFHOSTS			(MMS_ERR_BIAS + 540)
#define	MMS_EAPPDRVNOACC			(MMS_ERR_BIAS + 541)
#define	MMS_EAPPHASNOVOLS			(MMS_ERR_BIAS + 542)
#define	MMS_EAPPLIBNOACCESS			(MMS_ERR_BIAS + 543)
#define	MMS_EAPPMOUNTNOTIUSSUED			(MMS_ERR_BIAS + 544)
#define	MMS_EAPPSESS				(MMS_ERR_BIAS + 545)
#define	MMS_EAPPTASKNOTISSUED			(MMS_ERR_BIAS + 546)
#define	MMS_EAUTOCREATEFAILED			(MMS_ERR_BIAS + 547)
#define	MMS_ECANCELLED				(MMS_ERR_BIAS + 548)
#define	MMS_ECANCELNUMRANGEDISALLOWED		(MMS_ERR_BIAS + 549)
#define	MMS_ECANTCANCEL				(MMS_ERR_BIAS + 550)
#define	MMS_ECARTDRVNOTCOMPATIBLE		(MMS_ERR_BIAS + 551)
#define	MMS_ECARTDRVSLOTMISMATCH		(MMS_ERR_BIAS + 552)
#define	MMS_ECARTINSLOT				(MMS_ERR_BIAS + 553)
#define	MMS_ECARTINUSE				(MMS_ERR_BIAS + 554)
#define	MMS_ECARTMOUNTNOTINVOLVED		(MMS_ERR_BIAS + 555)
#define	MMS_ECARTNOACC				(MMS_ERR_BIAS + 556)
#define	MMS_ECARTNOCGA				(MMS_ERR_BIAS + 557)
#define	MMS_ECARTNOFREEPARTS			(MMS_ERR_BIAS + 558)
#define	MMS_ECARTNOTINSLOT			(MMS_ERR_BIAS + 559)
#define	MMS_ECARTNOTLOCATED			(MMS_ERR_BIAS + 560)
#define	MMS_ECARTNOTOWNEDBYAP			(MMS_ERR_BIAS + 561)
#define	MMS_ECARTNOTOWNEDBYAPP			(MMS_ERR_BIAS + 562)
#define	MMS_ECLAUSEMISSING			(MMS_ERR_BIAS + 563)
#define	MMS_ECLAUSEMUTEX			(MMS_ERR_BIAS + 564)
#define	MMS_ECLAUSENEEDSARG			(MMS_ERR_BIAS + 565)
#define	MMS_ECLAUSENOPRIVILEGE			(MMS_ERR_BIAS + 566)
#define	MMS_ECOMMANDBEINGSUBMITTED		(MMS_ERR_BIAS + 567)
#define	MMS_ECOMMANDFAILED			(MMS_ERR_BIAS + 568)
#define	MMS_ECOMMANDNOPRIVILEGE			(MMS_ERR_BIAS + 569)
#define	MMS_ECONNDELETE				(MMS_ERR_BIAS + 570)
#define	MMS_EDMCONFIG				(MMS_ERR_BIAS + 571)
#define	MMS_EDMNOTCONNECTED			(MMS_ERR_BIAS + 572)
#define	MMS_EDMNOTREADY				(MMS_ERR_BIAS + 573)
#define	MMS_EDMPATTACH				(MMS_ERR_BIAS + 574)
#define	MMS_EDMPDETACH				(MMS_ERR_BIAS + 575)
#define	MMS_EDMPLOAD				(MMS_ERR_BIAS + 576)
#define	MMS_EDMPUNLOAD				(MMS_ERR_BIAS + 577)
#define	MMS_EDMRECOVERING			(MMS_ERR_BIAS + 578)
#define	MMS_EDMSTATE				(MMS_ERR_BIAS + 579)
#define	MMS_EDMSTILLBOOTING			(MMS_ERR_BIAS + 580)
#define	MMS_EDRIVEEMPTY				(MMS_ERR_BIAS + 581)
#define	MMS_EDRIVESET				(MMS_ERR_BIAS + 582)
#define	MMS_EDRVBROKEN				(MMS_ERR_BIAS + 583)
#define	MMS_EDRVCARTNOTREADABLE			(MMS_ERR_BIAS + 584)
#define	MMS_EDRVDISABLEDPERM			(MMS_ERR_BIAS + 585)
#define	MMS_EDRVDISABLEDTEMP			(MMS_ERR_BIAS + 586)
#define	MMS_EDRVEJECTING			(MMS_ERR_BIAS + 587)
#define	MMS_EDRVINUSE				(MMS_ERR_BIAS + 588)
#define	MMS_EDRVLOADED				(MMS_ERR_BIAS + 589)
#define	MMS_EDRVMOUNTNOTINVOLVED		(MMS_ERR_BIAS + 590)
#define	MMS_EDRVNODMCONFIGURED			(MMS_ERR_BIAS + 591)
#define	MMS_EDRVNOTINBAY			(MMS_ERR_BIAS + 592)
#define	MMS_EDRVNOTLOADED			(MMS_ERR_BIAS + 593)
#define	MMS_EDRVSESSNOUSE			(MMS_ERR_BIAS + 594)
#define	MMS_EDRVTASKNOTREQUIRED			(MMS_ERR_BIAS + 595)
#define	MMS_EDRVUNKNOWN				(MMS_ERR_BIAS + 596)
#define	MMS_EHANDLEINUSE			(MMS_ERR_BIAS + 597)
#define	MMS_EHANDLENOTDESTROY			(MMS_ERR_BIAS + 598)
#define	MMS_EINVALCLAUSEARG			(MMS_ERR_BIAS + 599)
#define	MMS_ELANGNOTSUPPORTED			(MMS_ERR_BIAS + 600)
#define	MMS_ELIBBROKEN				(MMS_ERR_BIAS + 601)
#define	MMS_ELIBCARTNOCONTAINMENT		(MMS_ERR_BIAS + 602)
#define	MMS_ELIBDISABLEDPERM			(MMS_ERR_BIAS + 603)
#define	MMS_ELIBDISABLEDTEMP			(MMS_ERR_BIAS + 604)
#define	MMS_ELIBDRVNOCONTAINMENT		(MMS_ERR_BIAS + 605)
#define	MMS_ELIBINUSE				(MMS_ERR_BIAS + 606)
#define	MMS_ELIBNOLMCONFIGURED			(MMS_ERR_BIAS + 607)
#define	MMS_ELMADD				(MMS_ERR_BIAS + 608)
#define	MMS_ELMCARTBAYNOTACCESS			(MMS_ERR_BIAS + 609)
#define	MMS_ELMCONFIG				(MMS_ERR_BIAS + 610)
#define	MMS_ELMDMCOMMUNICATION			(MMS_ERR_BIAS + 611)
#define	MMS_ELMDRVBAYNOTACCESS			(MMS_ERR_BIAS + 612)
#define	MMS_ELMDRVNOTACCESS			(MMS_ERR_BIAS + 613)
#define	MMS_ELMNOTCONNECTED			(MMS_ERR_BIAS + 614)
#define	MMS_ELMNOTREADY				(MMS_ERR_BIAS + 615)
#define	MMS_ELMPMOUNT				(MMS_ERR_BIAS + 616)
#define	MMS_ELMPORTNOTREADY			(MMS_ERR_BIAS + 617)
#define	MMS_ELMPUNMOUNT				(MMS_ERR_BIAS + 618)
#define	MMS_ELMSLOTNOTACCESS			(MMS_ERR_BIAS + 619)
#define	MMS_ELMSTATE				(MMS_ERR_BIAS + 620)
#define	MMS_ELMSTILLBOOTING			(MMS_ERR_BIAS + 621)
#define	MMS_EMLOGCREATE				(MMS_ERR_BIAS + 622)
#define	MMS_EMLOGDELETE				(MMS_ERR_BIAS + 623)
#define	MMS_EMNTCARTPRES			(MMS_ERR_BIAS + 624)
#define	MMS_EMOUNTLIBNOTINVOLVED		(MMS_ERR_BIAS + 625)
#define	MMS_EMPCREATE				(MMS_ERR_BIAS + 626)
#define	MMS_EMPHYSDEL				(MMS_ERR_BIAS + 627)
#define	MMS_ENEWVOLEXISTS			(MMS_ERR_BIAS + 628)
#define	MMS_ENEWVOLNAMECOUNT			(MMS_ERR_BIAS + 629)
#define	MMS_ENOALLOCATABLEPARTS			(MMS_ERR_BIAS + 630)
#define	MMS_ENOCANCELLABLETASKS			(MMS_ERR_BIAS + 631)
#define	MMS_ENOCARTRIDGE			(MMS_ERR_BIAS + 632)
#define	MMS_ENOINSTANCE				(MMS_ERR_BIAS + 633)
#define	MMS_ENOMATCH				(MMS_ERR_BIAS + 634)
#define	MMS_ENOMEMORY				(MMS_ERR_BIAS + 635)
#define	MMS_ENOPRIVCHANGE			(MMS_ERR_BIAS + 636)
#define	MMS_ENOSESSION				(MMS_ERR_BIAS + 637)
#define	MMS_ENOSLOT				(MMS_ERR_BIAS + 638)
#define	MMS_ENOSOLUTIONS			(MMS_ERR_BIAS + 639)
#define	MMS_ENOSUCHCART				(MMS_ERR_BIAS + 640)
#define	MMS_ENOSUCHLANG				(MMS_ERR_BIAS + 641)
#define	MMS_ENOSUCHPRIV				(MMS_ERR_BIAS + 642)
#define	MMS_ENOSUCHREQ				(MMS_ERR_BIAS + 643)
#define	MMS_ENOSUCHSIDE				(MMS_ERR_BIAS + 644)
#define	MMS_ENOSUCHSORT				(MMS_ERR_BIAS + 645)
#define	MMS_ENOSUCHVOLUME			(MMS_ERR_BIAS + 646)
#define	MMS_EOBJATTRMODDISALLOWED		(MMS_ERR_BIAS + 647)
#define	MMS_EOBJATTRTOOMANY			(MMS_ERR_BIAS + 648)
#define	MMS_EOBJATTRVALNOTENUM			(MMS_ERR_BIAS + 649)
#define	MMS_EOBJATTRVALNOTNUM			(MMS_ERR_BIAS + 650)
#define	MMS_EOBJATTRVALNULLSTRING		(MMS_ERR_BIAS + 651)
#define	MMS_EOBJCREATEDISALLOWED		(MMS_ERR_BIAS + 652)
#define	MMS_EOBJCREATEINVALREPORT		(MMS_ERR_BIAS + 653)
#define	MMS_EOBJCREATESYSATTRREQUIRED		(MMS_ERR_BIAS + 654)
#define	MMS_EOBJDELDISALLOWED			(MMS_ERR_BIAS + 655)
#define	MMS_EOBJDELNUMRANGEDISALLOWED		(MMS_ERR_BIAS + 656)
#define	MMS_EOBJDEPENDNOEXIST			(MMS_ERR_BIAS + 657)
#define	MMS_EOBJKEYCHANGE			(MMS_ERR_BIAS + 658)
#define	MMS_EOBJKEYNOTUNIQUE			(MMS_ERR_BIAS + 659)
#define	MMS_EOBJNOTVISIBLE			(MMS_ERR_BIAS + 660)
#define	MMS_EOBJREFERENCES			(MMS_ERR_BIAS + 661)
#define	MMS_EOBJSYSATTRCREATEDISALLOWED		(MMS_ERR_BIAS + 662)
#define	MMS_EOBJSYSATTRMODDISALLOWED		(MMS_ERR_BIAS + 663)
#define	MMS_EOBJSYSATTRMODNOPRIV		(MMS_ERR_BIAS + 664)
#define	MMS_EOBJUSRATTRCREATEDISALLOWED		(MMS_ERR_BIAS + 665)
#define	MMS_EOBJUSRATTRCREATENOPRIV		(MMS_ERR_BIAS + 666)
#define	MMS_EPARTNOTALLOCABLE			(MMS_ERR_BIAS + 667)
#define	MMS_EPRIVCHANGEDISALLOWED		(MMS_ERR_BIAS + 668)
#define	MMS_ERENAMEDVOLEXISTS			(MMS_ERR_BIAS + 669)
#define	MMS_EREPLACEFAILED			(MMS_ERR_BIAS + 670)
#define	MMS_EREQACCEPTEDBYDIFFSESS		(MMS_ERR_BIAS + 671)
#define	MMS_EREQSTATECHANGEFAILED		(MMS_ERR_BIAS + 672)
#define	MMS_EREQUESTALREADYACCEPTED		(MMS_ERR_BIAS + 673)
#define	MMS_EREQUESTALREADYSATISFIED		(MMS_ERR_BIAS + 674)
#define	MMS_EREQUESTNOTACCEPTED			(MMS_ERR_BIAS + 675)
#define	MMS_ESESSCARTNOTUSED			(MMS_ERR_BIAS + 676)
#define	MMS_ESESSLIBNOTUSED			(MMS_ERR_BIAS + 677)
#define	MMS_ESESSMNTNOTISSUED			(MMS_ERR_BIAS + 678)
#define	MMS_ESESSTASKNOISSUED			(MMS_ERR_BIAS + 679)
#define	MMS_ESHUTDOWNFAILED			(MMS_ERR_BIAS + 680)
#define	MMS_ESLOTNOTOCCUPIED			(MMS_ERR_BIAS + 681)
#define	MMS_ESLOTOCCUPIED			(MMS_ERR_BIAS + 682)
#define	MMS_ESORTNOTSUPPORTED			(MMS_ERR_BIAS + 683)
#define	MMS_ESYSATTRUNSETDISALLOWED		(MMS_ERR_BIAS + 684)
#define	MMS_ESYSTEM				(MMS_ERR_BIAS + 685)
#define	MMS_ETABLELIMIT				(MMS_ERR_BIAS + 686)
#define	MMS_ETASKCARTNOUSE			(MMS_ERR_BIAS + 687)
#define	MMS_ETASKLIBNOUSE			(MMS_ERR_BIAS + 688)
#define	MMS_ETASKMNTNOUSE			(MMS_ERR_BIAS + 689)
#define	MMS_ETMPUNAVAIL				(MMS_ERR_BIAS + 690)
#define	MMS_ETOOMANY				(MMS_ERR_BIAS + 691)
#define	MMS_ETOOMANYCLAUSES			(MMS_ERR_BIAS + 692)
#define	MMS_ETRANSACTIONFAILED			(MMS_ERR_BIAS + 693)
#define	MMS_EUNKNOWNERROR			(MMS_ERR_BIAS + 694)
#define	MMS_EVOLEXISTS				(MMS_ERR_BIAS + 695)
#define	MMS_EVOLINUSE				(MMS_ERR_BIAS + 696)
#define	MMS_EVOLNAMEREWRITE			(MMS_ERR_BIAS + 697)
#define	MMS_EVOLNOTOWNEDBYAPP			(MMS_ERR_BIAS + 698)
#define	MMS_EWOULDDEADLOCK			(MMS_ERR_BIAS + 699)
#define	MMS_LM_E_ACCESS				(MMS_ERR_BIAS + 702)
#define	MMS_LM_E_AGAIN				(MMS_ERR_BIAS + 703)
#define	MMS_LM_E_BADVAL				(MMS_ERR_BIAS + 704)
#define	MMS_LM_E_CMDARGS			(MMS_ERR_BIAS + 705)
#define	MMS_LM_E_DESTFULL			(MMS_ERR_BIAS + 706)
#define	MMS_LM_E_DEVADMINCLT			(MMS_ERR_BIAS + 707)
#define	MMS_LM_E_DEVCMD				(MMS_ERR_BIAS + 708)
#define	MMS_LM_E_DEVCMDABORT			(MMS_ERR_BIAS + 709)
#define	MMS_LM_E_DEVCMDILLEGAL			(MMS_ERR_BIAS + 710)
#define	MMS_LM_E_DEVCMDTEMEOUT			(MMS_ERR_BIAS + 711)
#define	MMS_LM_E_DEVCOMMERR			(MMS_ERR_BIAS + 712)
#define	MMS_LM_E_DEVEJ				(MMS_ERR_BIAS + 713)
#define	MMS_LM_E_DEVINJ				(MMS_ERR_BIAS + 714)
#define	MMS_LM_E_DEVNORESPONSE			(MMS_ERR_BIAS + 715)
#define	MMS_LM_E_DEVOPERATOR			(MMS_ERR_BIAS + 716)
#define	MMS_LM_E_DEVOVERFLOW			(MMS_ERR_BIAS + 717)
#define	MMS_LM_E_DEVPREM			(MMS_ERR_BIAS + 718)
#define	MMS_LM_E_DEVPREV			(MMS_ERR_BIAS + 719)
#define	MMS_LM_E_DEVRESET			(MMS_ERR_BIAS + 720)
#define	MMS_LM_E_DEVSYNCHERR			(MMS_ERR_BIAS + 721)
#define	MMS_LM_E_DIRECTION			(MMS_ERR_BIAS + 722)
#define	MMS_LM_E_INTERNAL			(MMS_ERR_BIAS + 723)
#define	MMS_LM_E_LIBRARY			(MMS_ERR_BIAS + 724)
#define	MMS_LM_E_MOVE				(MMS_ERR_BIAS + 725)
#define	MMS_LM_E_NOCANC				(MMS_ERR_BIAS + 726)
#define	MMS_LM_E_NODRIVE			(MMS_ERR_BIAS + 727)
#define	MMS_LM_E_NOELT				(MMS_ERR_BIAS + 728)
#define	MMS_LM_E_NOPCL				(MMS_ERR_BIAS + 729)
#define	MMS_LM_E_NOSLOT				(MMS_ERR_BIAS + 730)
#define	MMS_LM_E_NOTASK				(MMS_ERR_BIAS + 731)
#define	MMS_LM_E_PCL				(MMS_ERR_BIAS + 732)
#define	MMS_LM_E_PORT				(MMS_ERR_BIAS + 733)
#define	MMS_LM_E_PORTDIR			(MMS_ERR_BIAS + 734)
#define	MMS_LM_E_READY				(MMS_ERR_BIAS + 735)
#define	MMS_LM_E_SCREMPTY			(MMS_ERR_BIAS + 736)
#define	MMS_LM_E_SHAPE				(MMS_ERR_BIAS + 737)
#define	MMS_LM_E_SLOTGROUP			(MMS_ERR_BIAS + 738)
#define	MMS_LM_E_UNKNOWN			(MMS_ERR_BIAS + 739)
#define	MMS_MM_E_AGAIN				(MMS_ERR_BIAS + 742)
#define	MMS_MM_E_BADVAL				(MMS_ERR_BIAS + 743)
#define	MMS_MM_E_CMDARGS			(MMS_ERR_BIAS + 744)
#define	MMS_MM_E_DEVCMD				(MMS_ERR_BIAS + 745)
#define	MMS_MM_E_DEVCMDABORT			(MMS_ERR_BIAS + 746)
#define	MMS_MM_E_DEVCMDILLEGAL			(MMS_ERR_BIAS + 747)
#define	MMS_MM_E_DEVCMDTEMEOUT			(MMS_ERR_BIAS + 748)
#define	MMS_MM_E_DEVOVERFLOW			(MMS_ERR_BIAS + 749)
#define	MMS_MM_E_DEVPREM			(MMS_ERR_BIAS + 750)
#define	MMS_MM_E_DEVPREV			(MMS_ERR_BIAS + 751)
#define	MMS_MM_E_INTERNAL			(MMS_ERR_BIAS + 752)
#define	MMS_MM_E_NOELT				(MMS_ERR_BIAS + 753)
#define	MMS_SSAI_E_PROTOCOL_ERROR		(MMS_ERR_BIAS + 754)
#define	MMS_SSAI_E_ACCESS_DENIED		(MMS_ERR_BIAS + 755)
#define	MMS_SSAI_E_DUPLICATE_SESSION		(MMS_ERR_BIAS + 756)
#define	MMS_SSAI_E_UNKNOWN_LANGUAGE		(MMS_ERR_BIAS + 757)
#define	MMS_SSAI_E_UNSUPPORTED_LANGUAGE		(MMS_ERR_BIAS + 758)
#define	MMS_LM_E_SUBCMDFAILED			(MMS_ERR_BIAS + 759)
#define	MMS_LM_E_CONFIG				(MMS_ERR_BIAS + 760)
#define	MMS_SSAI_E_SSL				(MMS_ERR_BIAS + 761)

/*
 * Additional DM errors
 */
#define	MMS_DM_E_ENABLED			(MMS_ERR_BIAS + 1000)
#define	MMS_DM_E_VIDMISMATCH			(MMS_ERR_BIAS + 1001)
#define	MMS_DM_E_COMMAND			(MMS_ERR_BIAS + 1002)
#define	MMS_DM_E_UNSUPPORTED			(MMS_ERR_BIAS + 1003)
#define	MMS_DM_E_IO				(MMS_ERR_BIAS + 1004)
#define	MMS_DM_E_COMMUNICATION			(MMS_ERR_BIAS + 1005)
#define	MMS_DM_E_MAKEHANDLE			(MMS_ERR_BIAS + 1006)
#define	MMS_DM_E_USER				(MMS_ERR_BIAS + 1007)
#define	MMS_DM_E_LOAD				(MMS_ERR_BIAS + 1008)
#define	MMS_DM_E_OPERATOR_ABORT			(MMS_ERR_BIAS + 1009)
#define	MMS_DM_E_VOLUME_ID			(MMS_ERR_BIAS + 1010)
#define	MMS_DM_E_DRIVE_SER_NUM			(MMS_ERR_BIAS + 1011)
#define	MMS_DM_E_DENSITY			(MMS_ERR_BIAS + 1012)

/*
 * Additional MM errors
 */
#define	MMS_ENOSUCHPCL				(MMS_ERR_BIAS + 2000)
#define	MMS_ELIBRARYNOEXIST			(MMS_ERR_BIAS + 2001)
#define	MMS_ELMNOEXIST				(MMS_ERR_BIAS + 2002)
#define	MMS_ELIBALREADYONLINE			(MMS_ERR_BIAS + 2003)
#define	MMS_ELIBALREADYOFFLINE			(MMS_ERR_BIAS + 2004)
#define	MMS_EDRIVENOEXIST			(MMS_ERR_BIAS + 2005)
#define	MMS_EDRIVEALREADYONLINE			(MMS_ERR_BIAS + 2006)
#define	MMS_EDRIVEALREADYOFFLINE		(MMS_ERR_BIAS + 2007)
#define	MMS_EDRIVEONLINE			(MMS_ERR_BIAS + 2008)
#define	MMS_EDRIVEOFFLINE			(MMS_ERR_BIAS + 2009)
#define	MMS_ELIBRARYONLINE			(MMS_ERR_BIAS + 2010)
#define	MMS_ELIBRARYOFFLINE			(MMS_ERR_BIAS + 2011)
#define	MMS_EDRVUNLOADING			(MMS_ERR_BIAS + 2012)
#define	MMS_EDMNOMOUNTPOINT			(MMS_ERR_BIAS + 2013)
#define	MMS_ETMPINUSE				(MMS_ERR_BIAS + 2014)

/*
 * Label errors
 */
#define	MMS_E_LABEL_NOT_PROCESSED		(MMS_ERR_BIAS + 3000)
#define	MMS_E_LABEL_MOUNT_SEND			(MMS_ERR_BIAS + 3001)
#define	MMS_E_LABEL_MOUNT_RSP			(MMS_ERR_BIAS + 3002)
#define	MMS_E_LABEL_HANDLE_NULL			(MMS_ERR_BIAS + 3003)
#define	MMS_E_LABEL_HANDLE_OPEN			(MMS_ERR_BIAS + 3004)
#define	MMS_E_LABEL_UNMOUNT_SEND		(MMS_ERR_BIAS + 3005)
#define	MMS_E_LABEL_UNMOUNT_RSP			(MMS_ERR_BIAS + 3006)
#define	MMS_E_LABEL_NO_CARTRIDGES		(MMS_ERR_BIAS + 3007)
#define	MMS_E_LABEL_NO_LIBRARY			(MMS_ERR_BIAS + 3008)
#define	MMS_E_LABEL_COMMANDS			(MMS_ERR_BIAS + 3009)

/*
 * Sun MM System vendor-defined error codes.
 */
#define	MMS_EDATABASE				(MMS_ERR_BIAS + 4009)
#define	MMS_ENOTFOUND				(MMS_ERR_BIAS + 4010)
#define	MMS_ESYNTAX				(MMS_ERR_BIAS + 4011)
#define	MMS_EPRIVNOTSMMSADMIN			(MMS_ERR_BIAS + 4012)
#define	MMS_MM_E_NOTASK				(MMS_ERR_BIAS + 4013)
#define	MMS_MM_E_TOOMANYTASKS			(MMS_ERR_BIAS + 4014)
#define	MMS_ENOTENOUGHPARTITIONS		(MMS_ERR_BIAS + 4015)
#define	MMS_EPARTITIONSTATECHANGE		(MMS_ERR_BIAS + 4016)
#define	MMS_ECARTRIDGESTATECHANGE		(MMS_ERR_BIAS + 4017)
#define	MMS_ESYSTEMCONFIGCHANGE			(MMS_ERR_BIAS + 4018)
#define	MMS_ENOTCONNECTED			(MMS_ERR_BIAS + 4019)
#define	MMS_ECOMMUNICATION			(MMS_ERR_BIAS + 4020)

/*
 * Socket and SSL error codes.
 */
#define	MMS_ERR_NONE				(MMS_ERR_BIAS + 5000)
#define	MMS_ERR_GETADDRINFO			(MMS_ERR_BIAS + 5001)
#define	MMS_ERR_SERVICE_NOT_FOUND		(MMS_ERR_BIAS + 5002)
#define	MMS_ERR_ACCEPT_FAILED			(MMS_ERR_BIAS + 5003)
#define	MMS_ERR_LISTEN				(MMS_ERR_BIAS + 5004)
#define	MMS_ERR_READ				(MMS_ERR_BIAS + 5005)
#define	MMS_ERR_WRITE				(MMS_ERR_BIAS + 5006)
#define	MMS_ERR_RES_NULL			(MMS_ERR_BIAS + 5007)
#define	MMS_ERR_GETHOSTNAME			(MMS_ERR_BIAS + 5008)
#define	MMS_ERR_NOMEM				(MMS_ERR_BIAS + 5009)
#define	MMS_ERR_SSL_CONNECT			(MMS_ERR_BIAS + 5010)
#define	MMS_ERR_SSL_FILE			(MMS_ERR_BIAS + 5011)
#define	MMS_ERR_SSL_CTX				(MMS_ERR_BIAS + 5012)
#define	MMS_ERR_SSL_CERT			(MMS_ERR_BIAS + 5013)
#define	MMS_ERR_SSL_NOCERT			(MMS_ERR_BIAS + 5014)
#define	MMS_ERR_SSL_KEY				(MMS_ERR_BIAS + 5015)
#define	MMS_ERR_SSL_DH				(MMS_ERR_BIAS + 5016)
#define	MMS_ERR_SSL_CIPHER			(MMS_ERR_BIAS + 5017)
#define	MMS_ERR_SSL_OP				(MMS_ERR_BIAS + 5018)
#define	MMS_ERR_SSL_STORE			(MMS_ERR_BIAS + 5019)
#define	MMS_ERR_SSL_VERIFY			(MMS_ERR_BIAS + 5020)
#define	MMS_ERR_NO_SSL				(MMS_ERR_BIAS + 5021)



int	mms_sym_str_to_code(char *errstr);
char	*mms_sym_code_to_str(int code);
void	mms_sort_sym_token(mms_sym_t *tab, int num);
void	mms_sort_sym_code(mms_sym_t *tab, int num);
mms_sym_t	*mms_lookup_sym_token(char *mms_sym, mms_sym_t *tab, int num);
mms_sym_t	*mms_lookup_sym_code(int code, mms_sym_t *tab, int num);
mms_sym_t	*mms_lookup_sym_err_token(char *);

#ifdef	__cplusplus
}
#endif

#endif /* _MMS_SYM_H_ */
