/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"%Z%%M%	%I%	%E% SMI"

/*
 * This file provides a text translation service for NT status codes.
 */

#ifdef _KERNEL
#include <sys/types.h>
#include <sys/sunddi.h>
#else
#include <syslog.h>
#include <stdio.h>
#endif /* _KERNEL */
#include <smbsrv/ntstatus.h>

typedef struct xlate_table {
	DWORD value;
	char *name;
} xlate_table_t;


static xlate_table_t ntx_table[] = {
	{ NT_STATUS_SUCCESS,			"SUCCESS" },
	{ NT_STATUS_UNSUCCESSFUL,		"UNSUCCESSFUL" },
	{ NT_STATUS_NOT_IMPLEMENTED,		"NOT_IMPLEMENTED" },
	{ NT_STATUS_INVALID_INFO_CLASS,		"INVALID_INFO_CLASS" },
	{ NT_STATUS_INFO_LENGTH_MISMATCH,	"INFO_LENGTH_MISMATCH" },
	{ NT_STATUS_BUFFER_OVERFLOW,		"BUFFER_OVERFLOW" },
	/*
	 * There seems to be some overloading of status codes.
	 * NT_STATUS_IN_PAGE_ERROR is NT_STATUS_NO_MORE_FILES
	 */
	{ NT_STATUS_NO_MORE_FILES,		"NO MORE FILES" },
	{ NT_STATUS_PAGEFILE_QUOTA,		"PAGEFILE_QUOTA" },
	{ NT_STATUS_INVALID_HANDLE,		"INVALID_HANDLE" },
	{ NT_STATUS_BAD_INITIAL_STACK,		"BAD_INITIAL_STACK" },
	{ NT_STATUS_BAD_INITIAL_PC,		"BAD_INITIAL_PC" },
	{ NT_STATUS_INVALID_CID,		"INVALID_CID" },
	{ NT_STATUS_TIMER_NOT_CANCELED,		"TIMER_NOT_CANCELED" },
	{ NT_STATUS_INVALID_PARAMETER,		"INVALID_PARAMETER" },
	{ NT_STATUS_NO_SUCH_DEVICE,		"NO_SUCH_DEVICE" },
	{ NT_STATUS_NO_SUCH_FILE,		"NO_SUCH_FILE" },
	{ NT_STATUS_INVALID_DEVICE_REQUEST,	"INVALID_DEVICE_REQUEST" },
	{ NT_STATUS_END_OF_FILE,		"END_OF_FILE" },
	{ NT_STATUS_WRONG_VOLUME,		"WRONG_VOLUME" },
	{ NT_STATUS_NO_MEDIA_IN_DEVICE,		"NO_MEDIA_IN_DEVICE" },
	{ NT_STATUS_UNRECOGNIZED_MEDIA,		"UNRECOGNIZED_MEDIA" },
	{ NT_STATUS_NONEXISTENT_SECTOR,		"NONEXISTENT_SECTOR" },
	{ NT_STATUS_MORE_PROCESSING_REQUIRED,	"MORE_PROCESSING_REQUIRED" },
	{ NT_STATUS_NO_MEMORY,			"NO_MEMORY" },
	{ NT_STATUS_CONFLICTING_ADDRESSES,	"CONFLICTING_ADDRESSES" },
	{ NT_STATUS_NOT_MAPPED_VIEW,		"NOT_MAPPED_VIEW" },

	/*
	 * There seems to be some overloading of status codes.
	 * When we get NT_STATUS_UNABLE_TO_FREE_VM it really
	 * means NT_STATUS_NO_MORE_DATA.
	 */
	{ NT_STATUS_UNABLE_TO_FREE_VM,		"NO_MORE_DATA" },

	{ NT_STATUS_UNABLE_TO_DELETE_SECTION,	"UNABLE_TO_DELETE_SECTION" },
	{ NT_STATUS_INVALID_SYSTEM_SERVICE,	"INVALID_SYSTEM_SERVICE" },
	{ NT_STATUS_ILLEGAL_INSTRUCTION,	"ILLEGAL_INSTRUCTION" },
	{ NT_STATUS_INVALID_LOCK_SEQUENCE,	"INVALID_LOCK_SEQUENCE" },
	{ NT_STATUS_INVALID_VIEW_SIZE,		"INVALID_VIEW_SIZE" },
	{ NT_STATUS_INVALID_FILE_FOR_SECTION,	"INVALID_FILE_FOR_SECTION" },
	{ NT_STATUS_ALREADY_COMMITTED,		"ALREADY_COMMITTED" },
	{ NT_STATUS_ACCESS_DENIED,		"ACCESS_DENIED" },
	{ NT_STATUS_BUFFER_TOO_SMALL,		"BUFFER_TOO_SMALL" },
	{ NT_STATUS_OBJECT_TYPE_MISMATCH,	"OBJECT_TYPE_MISMATCH" },
	{ NT_STATUS_NONCONTINUABLE_EXCEPTION,	"NONCONTINUABLE_EXCEPTION" },
	{ NT_STATUS_INVALID_DISPOSITION,	"INVALID_DISPOSITION" },
	{ NT_STATUS_UNWIND,			"UNWIND" },
	{ NT_STATUS_BAD_STACK,			"BAD_STACK" },
	{ NT_STATUS_INVALID_UNWIND_TARGET,	"INVALID_UNWIND_TARGET" },
	{ NT_STATUS_NOT_LOCKED,			"NOT_LOCKED" },
	{ NT_STATUS_PARITY_ERROR,		"PARITY_ERROR" },
	{ NT_STATUS_UNABLE_TO_DECOMMIT_VM,	"UNABLE_TO_DECOMMIT_VM" },
	{ NT_STATUS_NOT_COMMITTED,		"NOT_COMMITTED" },
	{ NT_STATUS_INVALID_PORT_ATTRIBUTES,	"INVALID_PORT_ATTRIBUTES" },
	{ NT_STATUS_PORT_MESSAGE_TOO_LONG,	"PORT_MESSAGE_TOO_LONG" },
	{ NT_STATUS_INVALID_PARAMETER_MIX,	"INVALID_PARAMETER_MIX" },
	{ NT_STATUS_INVALID_QUOTA_LOWER,	"INVALID_QUOTA_LOWER" },
	{ NT_STATUS_DISK_CORRUPT_ERROR,		"DISK_CORRUPT_ERROR" },
	{ NT_STATUS_OBJECT_NAME_INVALID,	"OBJECT_NAME_INVALID" },
	{ NT_STATUS_OBJECT_NAME_NOT_FOUND,	"OBJECT_NAME_NOT_FOUND" },
	{ NT_STATUS_OBJECT_NAME_COLLISION,	"OBJECT_NAME_COLLISION" },
	{ NT_STATUS_HANDLE_NOT_WAITABLE,	"HANDLE_NOT_WAITABLE" },
	{ NT_STATUS_PORT_DISCONNECTED,		"PORT_DISCONNECTED" },
	{ NT_STATUS_DEVICE_ALREADY_ATTACHED,	"DEVICE_ALREADY_ATTACHED" },
	{ NT_STATUS_OBJECT_PATH_INVALID,	"OBJECT_PATH_INVALID" },
	{ NT_STATUS_OBJECT_PATH_NOT_FOUND,	"OBJECT_PATH_NOT_FOUND" },
	{ NT_STATUS_OBJECT_PATH_SYNTAX_BAD,	"OBJECT_PATH_SYNTAX_BAD" },
	{ NT_STATUS_DATA_OVERRUN,		"DATA_OVERRUN" },
	{ NT_STATUS_DATA_LATE_ERROR,		"DATA_LATE_ERROR" },
	{ NT_STATUS_DATA_ERROR,			"DATA_ERROR" },
	{ NT_STATUS_CRC_ERROR,			"CRC_ERROR" },
	{ NT_STATUS_SECTION_TOO_BIG,		"SECTION_TOO_BIG" },
	{ NT_STATUS_PORT_CONNECTION_REFUSED,	"PORT_CONNECTION_REFUSED" },
	{ NT_STATUS_INVALID_PORT_HANDLE,	"INVALID_PORT_HANDLE" },
	{ NT_STATUS_SHARING_VIOLATION,		"SHARING_VIOLATION" },
	{ NT_STATUS_QUOTA_EXCEEDED,		"QUOTA_EXCEEDED" },
	{ NT_STATUS_INVALID_PAGE_PROTECTION,	"INVALID_PAGE_PROTECTION" },
	{ NT_STATUS_MUTANT_NOT_OWNED,		"MUTANT_NOT_OWNED" },
	{ NT_STATUS_SEMAPHORE_LIMIT_EXCEEDED,	"SEMAPHORE_LIMIT_EXCEEDED" },
	{ NT_STATUS_PORT_ALREADY_SET,		"PORT_ALREADY_SET" },
	{ NT_STATUS_SECTION_NOT_IMAGE,		"SECTION_NOT_IMAGE" },
	{ NT_STATUS_SUSPEND_COUNT_EXCEEDED,	"SUSPEND_COUNT_EXCEEDED" },
	{ NT_STATUS_THREAD_IS_TERMINATING,	"THREAD_IS_TERMINATING" },
	{ NT_STATUS_BAD_WORKING_SET_LIMIT,	"BAD_WORKING_SET_LIMIT" },
	{ NT_STATUS_INCOMPATIBLE_FILE_MAP,	"INCOMPATIBLE_FILE_MAP" },
	{ NT_STATUS_SECTION_PROTECTION,		"SECTION_PROTECTION" },
	{ NT_STATUS_EAS_NOT_SUPPORTED,		"EAS_NOT_SUPPORTED" },
	{ NT_STATUS_EA_TOO_LARGE,		"EA_TOO_LARGE" },
	{ NT_STATUS_NONEXISTENT_EA_ENTRY,	"NONEXISTENT_EA_ENTRY" },
	{ NT_STATUS_NO_EAS_ON_FILE,		"NO_EAS_ON_FILE" },
	{ NT_STATUS_EA_CORRUPT_ERROR,		"EA_CORRUPT_ERROR" },
	{ NT_STATUS_FILE_LOCK_CONFLICT,		"FILE_LOCK_CONFLICT" },
	{ NT_STATUS_LOCK_NOT_GRANTED,		"LOCK_NOT_GRANTED" },
	{ NT_STATUS_DELETE_PENDING,		"DELETE_PENDING" },
	{ NT_STATUS_CTL_FILE_NOT_SUPPORTED,	"CTL_FILE_NOT_SUPPORTED" },
	{ NT_STATUS_UNKNOWN_REVISION,		"UNKNOWN_REVISION" },
	{ NT_STATUS_REVISION_MISMATCH,		"REVISION_MISMATCH" },
	{ NT_STATUS_INVALID_OWNER,		"INVALID_OWNER" },
	{ NT_STATUS_INVALID_PRIMARY_GROUP,	"INVALID_PRIMARY_GROUP" },
	{ NT_STATUS_NO_IMPERSONATION_TOKEN,	"NO_IMPERSONATION_TOKEN" },
	{ NT_STATUS_CANT_DISABLE_MANDATORY,	"CANT_DISABLE_MANDATORY" },
	{ NT_STATUS_NO_LOGON_SERVERS,		"NO_LOGON_SERVERS" },
	{ NT_STATUS_NO_SUCH_LOGON_SESSION,	"NO_SUCH_LOGON_SESSION" },
	{ NT_STATUS_NO_SUCH_PRIVILEGE,		"NO_SUCH_PRIVILEGE" },
	{ NT_STATUS_PRIVILEGE_NOT_HELD,		"PRIVILEGE_NOT_HELD" },
	{ NT_STATUS_INVALID_ACCOUNT_NAME,	"INVALID_ACCOUNT_NAME" },
	{ NT_STATUS_USER_EXISTS,		"USER_EXISTS" },
	{ NT_STATUS_NO_SUCH_USER,		"NO_SUCH_USER" },
	{ NT_STATUS_GROUP_EXISTS,		"GROUP_EXISTS" },
	{ NT_STATUS_NO_SUCH_GROUP,		"NO_SUCH_GROUP" },
	{ NT_STATUS_MEMBER_IN_GROUP,		"MEMBER_IN_GROUP" },
	{ NT_STATUS_MEMBER_NOT_IN_GROUP,	"MEMBER_NOT_IN_GROUP" },
	{ NT_STATUS_LAST_ADMIN,			"LAST_ADMIN" },
	{ NT_STATUS_WRONG_PASSWORD,		"WRONG_PASSWORD" },
	{ NT_STATUS_ILL_FORMED_PASSWORD,	"ILL_FORMED_PASSWORD" },
	{ NT_STATUS_PASSWORD_RESTRICTION,	"PASSWORD_RESTRICTION" },
	{ NT_STATUS_LOGON_FAILURE,		"LOGON_FAILURE" },
	{ NT_STATUS_ACCOUNT_RESTRICTION,	"ACCOUNT_RESTRICTION" },
	{ NT_STATUS_INVALID_LOGON_HOURS,	"INVALID_LOGON_HOURS" },
	{ NT_STATUS_INVALID_WORKSTATION,	"INVALID_WORKSTATION" },
	{ NT_STATUS_PASSWORD_EXPIRED,		"PASSWORD_EXPIRED" },
	{ NT_STATUS_ACCOUNT_DISABLED,		"ACCOUNT_DISABLED" },
	{ NT_STATUS_NONE_MAPPED,		"NONE_MAPPED" },
	{ NT_STATUS_TOO_MANY_LUIDS_REQUESTED,	"TOO_MANY_LUIDS_REQUESTED" },
	{ NT_STATUS_LUIDS_EXHAUSTED,		"LUIDS_EXHAUSTED" },
	{ NT_STATUS_INVALID_SUB_AUTHORITY,	"INVALID_SUB_AUTHORITY" },
	{ NT_STATUS_INVALID_ACL,		"INVALID_ACL" },
	{ NT_STATUS_INVALID_SID,		"INVALID_SID" },
	{ NT_STATUS_INVALID_SECURITY_DESCR,	"INVALID_SECURITY_DESCR" },
	{ NT_STATUS_PROCEDURE_NOT_FOUND,	"PROCEDURE_NOT_FOUND" },
	{ NT_STATUS_INVALID_IMAGE_FORMAT,	"INVALID_IMAGE_FORMAT" },
	{ NT_STATUS_NO_TOKEN,			"NO_TOKEN" },
	{ NT_STATUS_BAD_INHERITANCE_ACL,	"BAD_INHERITANCE_ACL" },
	{ NT_STATUS_RANGE_NOT_LOCKED,		"RANGE_NOT_LOCKED" },
	{ NT_STATUS_DISK_FULL,			"DISK_FULL" },
	{ NT_STATUS_SERVER_DISABLED,		"SERVER_DISABLED" },
	{ NT_STATUS_SERVER_NOT_DISABLED,	"SERVER_NOT_DISABLED" },
	{ NT_STATUS_TOO_MANY_GUIDS_REQUESTED,	"TOO_MANY_GUIDS_REQUESTED" },
	{ NT_STATUS_GUIDS_EXHAUSTED,		"GUIDS_EXHAUSTED" },
	{ NT_STATUS_INVALID_ID_AUTHORITY,	"INVALID_ID_AUTHORITY" },
	{ NT_STATUS_AGENTS_EXHAUSTED,		"AGENTS_EXHAUSTED" },
	{ NT_STATUS_INVALID_VOLUME_LABEL,	"INVALID_VOLUME_LABEL" },
	{ NT_STATUS_SECTION_NOT_EXTENDED,	"SECTION_NOT_EXTENDED" },
	{ NT_STATUS_NOT_MAPPED_DATA,		"NOT_MAPPED_DATA" },
	{ NT_STATUS_RESOURCE_DATA_NOT_FOUND,	"RESOURCE_DATA_NOT_FOUND" },
	{ NT_STATUS_RESOURCE_TYPE_NOT_FOUND,	"RESOURCE_TYPE_NOT_FOUND" },
	{ NT_STATUS_RESOURCE_NAME_NOT_FOUND,	"RESOURCE_NAME_NOT_FOUND" },
	{ NT_STATUS_ARRAY_BOUNDS_EXCEEDED,	"ARRAY_BOUNDS_EXCEEDED" },
	{ NT_STATUS_FLOAT_DENORMAL_OPERAND,	"FLOAT_DENORMAL_OPERAND" },
	{ NT_STATUS_FLOAT_DIVIDE_BY_ZERO,	"FLOAT_DIVIDE_BY_ZERO" },
	{ NT_STATUS_FLOAT_INEXACT_RESULT,	"FLOAT_INEXACT_RESULT" },
	{ NT_STATUS_FLOAT_INVALID_OPERATION,	"FLOAT_INVALID_OPERATION" },
	{ NT_STATUS_FLOAT_OVERFLOW,		"FLOAT_OVERFLOW" },
	{ NT_STATUS_FLOAT_STACK_CHECK,		"FLOAT_STACK_CHECK" },
	{ NT_STATUS_FLOAT_UNDERFLOW,		"FLOAT_UNDERFLOW" },
	{ NT_STATUS_INTEGER_DIVIDE_BY_ZERO,	"INTEGER_DIVIDE_BY_ZERO" },
	{ NT_STATUS_INTEGER_OVERFLOW,		"INTEGER_OVERFLOW" },
	{ NT_STATUS_PRIVILEGED_INSTRUCTION,	"PRIVILEGED_INSTRUCTION" },
	{ NT_STATUS_TOO_MANY_PAGING_FILES,	"TOO_MANY_PAGING_FILES" },
	{ NT_STATUS_FILE_INVALID,		"FILE_INVALID" },
	{ NT_STATUS_ALLOTTED_SPACE_EXCEEDED,	"ALLOTTED_SPACE_EXCEEDED" },
	{ NT_STATUS_INSUFFICIENT_RESOURCES,	"INSUFFICIENT_RESOURCES" },
	{ NT_STATUS_DFS_EXIT_PATH_FOUND,	"DFS_EXIT_PATH_FOUND" },
	{ NT_STATUS_DEVICE_DATA_ERROR,		"DEVICE_DATA_ERROR" },
	{ NT_STATUS_DEVICE_NOT_CONNECTED,	"DEVICE_NOT_CONNECTED" },
	{ NT_STATUS_DEVICE_POWER_FAILURE,	"DEVICE_POWER_FAILURE" },
	{ NT_STATUS_FREE_VM_NOT_AT_BASE,	"FREE_VM_NOT_AT_BASE" },
	{ NT_STATUS_MEMORY_NOT_ALLOCATED,	"MEMORY_NOT_ALLOCATED" },
	{ NT_STATUS_WORKING_SET_QUOTA,		"WORKING_SET_QUOTA" },
	{ NT_STATUS_MEDIA_WRITE_PROTECTED,	"MEDIA_WRITE_PROTECTED" },
	{ NT_STATUS_DEVICE_NOT_READY,		"DEVICE_NOT_READY" },
	{ NT_STATUS_INVALID_GROUP_ATTRIBUTES,	"INVALID_GROUP_ATTRIBUTES" },
	{ NT_STATUS_BAD_IMPERSONATION_LEVEL,	"BAD_IMPERSONATION_LEVEL" },
	{ NT_STATUS_CANT_OPEN_ANONYMOUS,	"CANT_OPEN_ANONYMOUS" },
	{ NT_STATUS_BAD_VALIDATION_CLASS,	"BAD_VALIDATION_CLASS" },
	{ NT_STATUS_BAD_TOKEN_TYPE,		"BAD_TOKEN_TYPE" },
	{ NT_STATUS_BAD_MASTER_BOOT_RECORD,	"BAD_MASTER_BOOT_RECORD" },
	{ NT_STATUS_INSTRUCTION_MISALIGNMENT,	"INSTRUCTION_MISALIGNMENT" },
	{ NT_STATUS_INSTANCE_NOT_AVAILABLE,	"INSTANCE_NOT_AVAILABLE" },
	{ NT_STATUS_PIPE_NOT_AVAILABLE,		"PIPE_NOT_AVAILABLE" },
	{ NT_STATUS_INVALID_PIPE_STATE,		"INVALID_PIPE_STATE" },
	{ NT_STATUS_PIPE_BUSY,			"PIPE_BUSY" },
	{ NT_STATUS_ILLEGAL_FUNCTION,		"ILLEGAL_FUNCTION" },
	{ NT_STATUS_PIPE_DISCONNECTED,		"PIPE_DISCONNECTED" },
	{ NT_STATUS_PIPE_CLOSING,		"PIPE_CLOSING" },
	{ NT_STATUS_PIPE_CONNECTED,		"PIPE_CONNECTED" },
	{ NT_STATUS_PIPE_LISTENING,		"PIPE_LISTENING" },
	{ NT_STATUS_INVALID_READ_MODE,		"INVALID_READ_MODE" },
	{ NT_STATUS_IO_TIMEOUT,			"IO_TIMEOUT" },
	{ NT_STATUS_FILE_FORCED_CLOSED,		"FILE_FORCED_CLOSED" },
	{ NT_STATUS_PROFILING_NOT_STARTED,	"PROFILING_NOT_STARTED" },
	{ NT_STATUS_PROFILING_NOT_STOPPED,	"PROFILING_NOT_STOPPED" },
	{ NT_STATUS_COULD_NOT_INTERPRET,	"COULD_NOT_INTERPRET" },
	{ NT_STATUS_FILE_IS_A_DIRECTORY,	"FILE_IS_A_DIRECTORY" },
	{ NT_STATUS_NOT_SUPPORTED,		"NOT_SUPPORTED" },
	{ NT_STATUS_REMOTE_NOT_LISTENING,	"REMOTE_NOT_LISTENING" },
	{ NT_STATUS_DUPLICATE_NAME,		"DUPLICATE_NAME" },
	{ NT_STATUS_BAD_NETWORK_PATH,		"BAD_NETWORK_PATH" },
	{ NT_STATUS_NETWORK_BUSY,		"NETWORK_BUSY" },
	{ NT_STATUS_DEVICE_DOES_NOT_EXIST,	"DEVICE_DOES_NOT_EXIST" },
	{ NT_STATUS_TOO_MANY_COMMANDS,		"TOO_MANY_COMMANDS" },
	{ NT_STATUS_ADAPTER_HARDWARE_ERROR,	"ADAPTER_HARDWARE_ERROR" },
	{ NT_STATUS_INVALID_NETWORK_RESPONSE,	"INVALID_NETWORK_RESPONSE" },
	{ NT_STATUS_UNEXPECTED_NETWORK_ERROR,	"UNEXPECTED_NETWORK_ERROR" },
	{ NT_STATUS_BAD_REMOTE_ADAPTER,		"BAD_REMOTE_ADAPTER" },
	{ NT_STATUS_PRINT_QUEUE_FULL,		"PRINT_QUEUE_FULL" },
	{ NT_STATUS_NO_SPOOL_SPACE,		"NO_SPOOL_SPACE" },
	{ NT_STATUS_PRINT_CANCELLED,		"PRINT_CANCELLED" },
	{ NT_STATUS_NETWORK_NAME_DELETED,	"NETWORK_NAME_DELETED" },
	{ NT_STATUS_NETWORK_ACCESS_DENIED,	"NETWORK_ACCESS_DENIED" },
	{ NT_STATUS_BAD_DEVICE_TYPE,		"BAD_DEVICE_TYPE" },
	{ NT_STATUS_BAD_NETWORK_NAME,		"BAD_NETWORK_NAME" },
	{ NT_STATUS_TOO_MANY_NAMES,		"TOO_MANY_NAMES" },
	{ NT_STATUS_TOO_MANY_SESSIONS,		"TOO_MANY_SESSIONS" },
	{ NT_STATUS_SHARING_PAUSED,		"SHARING_PAUSED" },
	{ NT_STATUS_REQUEST_NOT_ACCEPTED,	"REQUEST_NOT_ACCEPTED" },
	{ NT_STATUS_REDIRECTOR_PAUSED,		"REDIRECTOR_PAUSED" },
	{ NT_STATUS_NET_WRITE_FAULT,		"NET_WRITE_FAULT" },
	{ NT_STATUS_PROFILING_AT_LIMIT,		"PROFILING_AT_LIMIT" },
	{ NT_STATUS_NOT_SAME_DEVICE,		"NOT_SAME_DEVICE" },
	{ NT_STATUS_FILE_RENAMED,		"FILE_RENAMED" },
	{ NT_STATUS_VIRTUAL_CIRCUIT_CLOSED,	"VIRTUAL_CIRCUIT_CLOSED" },
	{ NT_STATUS_NO_SECURITY_ON_OBJECT,	"NO_SECURITY_ON_OBJECT" },
	{ NT_STATUS_CANT_WAIT,			"CANT_WAIT" },
	{ NT_STATUS_PIPE_EMPTY,			"PIPE_EMPTY" },
	{ NT_STATUS_CANT_ACCESS_DOMAIN_INFO,	"CANT_ACCESS_DOMAIN_INFO" },
	{ NT_STATUS_CANT_TERMINATE_SELF,	"CANT_TERMINATE_SELF" },
	{ NT_STATUS_INVALID_SERVER_STATE,	"INVALID_SERVER_STATE" },
	{ NT_STATUS_INVALID_DOMAIN_STATE,	"INVALID_DOMAIN_STATE" },
	{ NT_STATUS_INVALID_DOMAIN_ROLE,	"INVALID_DOMAIN_ROLE" },
	{ NT_STATUS_NO_SUCH_DOMAIN,		"NO_SUCH_DOMAIN" },
	{ NT_STATUS_DOMAIN_EXISTS,		"DOMAIN_EXISTS" },
	{ NT_STATUS_DOMAIN_LIMIT_EXCEEDED,	"DOMAIN_LIMIT_EXCEEDED" },
	{ NT_STATUS_OPLOCK_NOT_GRANTED,		"OPLOCK_NOT_GRANTED" },
	{ NT_STATUS_INVALID_OPLOCK_PROTOCOL,	"INVALID_OPLOCK_PROTOCOL" },
	{ NT_STATUS_INTERNAL_DB_CORRUPTION,	"INTERNAL_DB_CORRUPTION" },
	{ NT_STATUS_INTERNAL_ERROR,		"INTERNAL_ERROR" },
	{ NT_STATUS_GENERIC_NOT_MAPPED,		"GENERIC_NOT_MAPPED" },
	{ NT_STATUS_BAD_DESCRIPTOR_FORMAT,	"BAD_DESCRIPTOR_FORMAT" },
	{ NT_STATUS_INVALID_USER_BUFFER,	"INVALID_USER_BUFFER" },
	{ NT_STATUS_UNEXPECTED_IO_ERROR,	"UNEXPECTED_IO_ERROR" },
	{ NT_STATUS_UNEXPECTED_MM_CREATE_ERR,	"UNEXPECTED_MM_CREATE_ERR" },
	{ NT_STATUS_UNEXPECTED_MM_MAP_ERROR,	"UNEXPECTED_MM_MAP_ERROR" },
	{ NT_STATUS_UNEXPECTED_MM_EXTEND_ERR,	"UNEXPECTED_MM_EXTEND_ERR" },
	{ NT_STATUS_NOT_LOGON_PROCESS,		"NOT_LOGON_PROCESS" },
	{ NT_STATUS_LOGON_SESSION_EXISTS,	"LOGON_SESSION_EXISTS" },
	{ NT_STATUS_INVALID_PARAMETER_1,	"INVALID_PARAMETER_1" },
	{ NT_STATUS_INVALID_PARAMETER_2,	"INVALID_PARAMETER_2" },
	{ NT_STATUS_INVALID_PARAMETER_3,	"INVALID_PARAMETER_3" },
	{ NT_STATUS_INVALID_PARAMETER_4,	"INVALID_PARAMETER_4" },
	{ NT_STATUS_INVALID_PARAMETER_5,	"INVALID_PARAMETER_5" },
	{ NT_STATUS_INVALID_PARAMETER_6,	"INVALID_PARAMETER_6" },
	{ NT_STATUS_INVALID_PARAMETER_7,	"INVALID_PARAMETER_7" },
	{ NT_STATUS_INVALID_PARAMETER_8,	"INVALID_PARAMETER_8" },
	{ NT_STATUS_INVALID_PARAMETER_9,	"INVALID_PARAMETER_9" },
	{ NT_STATUS_INVALID_PARAMETER_10,	"INVALID_PARAMETER_10" },
	{ NT_STATUS_INVALID_PARAMETER_11,	"INVALID_PARAMETER_11" },
	{ NT_STATUS_INVALID_PARAMETER_12,	"INVALID_PARAMETER_12" },
	{ NT_STATUS_REDIRECTOR_NOT_STARTED,	"REDIRECTOR_NOT_STARTED" },
	{ NT_STATUS_REDIRECTOR_STARTED,		"REDIRECTOR_STARTED" },
	{ NT_STATUS_STACK_OVERFLOW,		"STACK_OVERFLOW" },
	{ NT_STATUS_NO_SUCH_PACKAGE,		"NO_SUCH_PACKAGE" },
	{ NT_STATUS_BAD_FUNCTION_TABLE,		"BAD_FUNCTION_TABLE" },
	{ NT_STATUS_DIRECTORY_NOT_EMPTY,	"DIRECTORY_NOT_EMPTY" },
	{ NT_STATUS_FILE_CORRUPT_ERROR,		"FILE_CORRUPT_ERROR" },
	{ NT_STATUS_NOT_A_DIRECTORY,		"NOT_A_DIRECTORY" },
	{ NT_STATUS_BAD_LOGON_SESSION_STATE,	"BAD_LOGON_SESSION_STATE" },
	{ NT_STATUS_LOGON_SESSION_COLLISION,	"LOGON_SESSION_COLLISION" },
	{ NT_STATUS_NAME_TOO_LONG,		"NAME_TOO_LONG" },
	{ NT_STATUS_FILES_OPEN,			"FILES_OPEN" },
	{ NT_STATUS_CONNECTION_IN_USE,		"CONNECTION_IN_USE" },
	{ NT_STATUS_MESSAGE_NOT_FOUND,		"MESSAGE_NOT_FOUND" },
	{ NT_STATUS_PROCESS_IS_TERMINATING,	"PROCESS_IS_TERMINATING" },
	{ NT_STATUS_INVALID_LOGON_TYPE,		"INVALID_LOGON_TYPE" },
	{ NT_STATUS_NO_GUID_TRANSLATION,	"NO_GUID_TRANSLATION" },
	{ NT_STATUS_CANNOT_IMPERSONATE,		"CANNOT_IMPERSONATE" },
	{ NT_STATUS_IMAGE_ALREADY_LOADED,	"IMAGE_ALREADY_LOADED" },
	{ NT_STATUS_ABIOS_NOT_PRESENT,		"ABIOS_NOT_PRESENT" },
	{ NT_STATUS_ABIOS_LID_NOT_EXIST,	"ABIOS_LID_NOT_EXIST" },
	{ NT_STATUS_ABIOS_LID_ALREADY_OWNED,	"ABIOS_LID_ALREADY_OWNED" },
	{ NT_STATUS_ABIOS_NOT_LID_OWNER,	"ABIOS_NOT_LID_OWNER" },
	{ NT_STATUS_ABIOS_INVALID_COMMAND,	"ABIOS_INVALID_COMMAND" },
	{ NT_STATUS_ABIOS_INVALID_LID,		"ABIOS_INVALID_LID" },
	{ NT_STATUS_ABIOS_SELECTOR_NOT_AVAILABLE,
	    "ABIOS_SELECTOR_NOT_AVAILABLE" },
	{ NT_STATUS_ABIOS_INVALID_SELECTOR,	"ABIOS_INVALID_SELECTOR" },
	{ NT_STATUS_NO_LDT,					"NO_LDT" },
	{ NT_STATUS_INVALID_LDT_SIZE,		"INVALID_LDT_SIZE" },
	{ NT_STATUS_INVALID_LDT_OFFSET,		"INVALID_LDT_OFFSET" },
	{ NT_STATUS_INVALID_LDT_DESCRIPTOR,	"INVALID_LDT_DESCRIPTOR" },
	{ NT_STATUS_INVALID_IMAGE_NE_FORMAT,	"INVALID_IMAGE_NE_FORMAT" },
	{ NT_STATUS_RXACT_INVALID_STATE,	"RXACT_INVALID_STATE" },
	{ NT_STATUS_RXACT_COMMIT_FAILURE,	"RXACT_COMMIT_FAILURE" },
	{ NT_STATUS_MAPPED_FILE_SIZE_ZERO,	"MAPPED_FILE_SIZE_ZERO" },
	{ NT_STATUS_TOO_MANY_OPENED_FILES,	"TOO_MANY_OPENED_FILES" },
	{ NT_STATUS_CANCELLED,			"CANCELLED" },
	{ NT_STATUS_CANNOT_DELETE,		"CANNOT_DELETE" },
	{ NT_STATUS_INVALID_COMPUTER_NAME,	"INVALID_COMPUTER_NAME" },
	{ NT_STATUS_FILE_DELETED,		"FILE_DELETED" },
	{ NT_STATUS_SPECIAL_ACCOUNT,		"SPECIAL_ACCOUNT" },
	{ NT_STATUS_SPECIAL_GROUP,		"SPECIAL_GROUP" },
	{ NT_STATUS_SPECIAL_USER,		"SPECIAL_USER" },
	{ NT_STATUS_MEMBERS_PRIMARY_GROUP,	"MEMBERS_PRIMARY_GROUP" },
	{ NT_STATUS_FILE_CLOSED,		"FILE_CLOSED" },
	{ NT_STATUS_TOO_MANY_THREADS,		"TOO_MANY_THREADS" },
	{ NT_STATUS_THREAD_NOT_IN_PROCESS,	"THREAD_NOT_IN_PROCESS" },
	{ NT_STATUS_TOKEN_ALREADY_IN_USE,	"TOKEN_ALREADY_IN_USE" },
	{ NT_STATUS_PAGEFILE_QUOTA_EXCEEDED,	"PAGEFILE_QUOTA_EXCEEDED" },
	{ NT_STATUS_COMMITMENT_LIMIT,		"COMMITMENT_LIMIT" },
	{ NT_STATUS_INVALID_IMAGE_LE_FORMAT,	"INVALID_IMAGE_LE_FORMAT" },
	{ NT_STATUS_INVALID_IMAGE_NOT_MZ,	"INVALID_IMAGE_NOT_MZ" },
	{ NT_STATUS_INVALID_IMAGE_PROTECT,	"INVALID_IMAGE_PROTECT" },
	{ NT_STATUS_INVALID_IMAGE_WIN_16,	"INVALID_IMAGE_WIN_16" },
	{ NT_STATUS_LOGON_SERVER_CONFLICT,	"LOGON_SERVER_CONFLICT" },
	{ NT_STATUS_TIME_DIFFERENCE_AT_DC,	"TIME_DIFFERENCE_AT_DC" },
	{ NT_STATUS_SYNCHRONIZATION_REQUIRED,	"SYNCHRONIZATION_REQUIRED" },
	{ NT_STATUS_DLL_NOT_FOUND,		"DLL_NOT_FOUND" },
	{ NT_STATUS_OPEN_FAILED,		"OPEN_FAILED" },
	{ NT_STATUS_IO_PRIVILEGE_FAILED,	"IO_PRIVILEGE_FAILED" },
	{ NT_STATUS_ORDINAL_NOT_FOUND,		"ORDINAL_NOT_FOUND" },
	{ NT_STATUS_ENTRYPOINT_NOT_FOUND,	"ENTRYPOINT_NOT_FOUND" },
	{ NT_STATUS_CONTROL_C_EXIT,		"CONTROL_C_EXIT" },
	{ NT_STATUS_LOCAL_DISCONNECT,		"LOCAL_DISCONNECT" },
	{ NT_STATUS_REMOTE_DISCONNECT,		"REMOTE_DISCONNECT" },
	{ NT_STATUS_REMOTE_RESOURCES,		"REMOTE_RESOURCES" },
	{ NT_STATUS_LINK_FAILED,		"LINK_FAILED" },
	{ NT_STATUS_LINK_TIMEOUT,		"LINK_TIMEOUT" },
	{ NT_STATUS_INVALID_CONNECTION,		"INVALID_CONNECTION" },
	{ NT_STATUS_INVALID_ADDRESS,		"INVALID_ADDRESS" },
	{ NT_STATUS_DLL_INIT_FAILED,		"DLL_INIT_FAILED" },
	{ NT_STATUS_MISSING_SYSTEMFILE,		"MISSING_SYSTEMFILE" },
	{ NT_STATUS_UNHANDLED_EXCEPTION,	"UNHANDLED_EXCEPTION" },
	{ NT_STATUS_APP_INIT_FAILURE,		"APP_INIT_FAILURE" },
	{ NT_STATUS_PAGEFILE_CREATE_FAILED,	"PAGEFILE_CREATE_FAILED" },
	{ NT_STATUS_NO_PAGEFILE,		"NO_PAGEFILE" },
	{ NT_STATUS_INVALID_LEVEL,		"INVALID_LEVEL" },
	{ NT_STATUS_WRONG_PASSWORD_CORE,	"WRONG_PASSWORD_CORE" },
	{ NT_STATUS_ILLEGAL_FLOAT_CONTEXT,	"ILLEGAL_FLOAT_CONTEXT" },
	{ NT_STATUS_PIPE_BROKEN,		"PIPE_BROKEN" },
	{ NT_STATUS_REGISTRY_CORRUPT,		"REGISTRY_CORRUPT" },
	{ NT_STATUS_REGISTRY_IO_FAILED,		"REGISTRY_IO_FAILED" },
	{ NT_STATUS_NO_EVENT_PAIR,		"NO_EVENT_PAIR" },
	{ NT_STATUS_UNRECOGNIZED_VOLUME,	"UNRECOGNIZED_VOLUME" },
	{ NT_STATUS_SERIAL_NO_DEVICE_INITED,	"SERIAL_NO_DEVICE_INITED" },
	{ NT_STATUS_NO_SUCH_ALIAS,		"NO SUCH ALIAS" },
	{ NT_STATUS_MEMBER_NOT_IN_ALIAS,	"MEMBER NOT IN ALIAS" },
	{ NT_STATUS_MEMBER_IN_ALIAS,		"MEMBER IN ALIAS" },
	{ NT_STATUS_ALIAS_EXISTS,		"ALIAS EXISTS" },
	{ NT_STATUS_LOGON_NOT_GRANTED,		"LOGON_NOT_GRANTED" },
	{ NT_STATUS_TOO_MANY_SECRETS,		"TOO_MANY_SECRETS" },
	{ NT_STATUS_SECRET_TOO_LONG,		"SECRET_TOO_LONG" },
	{ NT_STATUS_INTERNAL_DB_ERROR,		"INTERNAL_DB_ERROR" },
	{ NT_STATUS_FULLSCREEN_MODE,		"FULLSCREEN_MODE" },
	{ NT_STATUS_TOO_MANY_CONTEXT_IDS,	"TOO_MANY_CONTEXT_IDS" },
	{ NT_STATUS_LOGON_TYPE_NOT_GRANTED,	"LOGON_TYPE_NOT_GRANTED" },
	{ NT_STATUS_NOT_REGISTRY_FILE,		"NOT_REGISTRY_FILE" },
	{ NT_STATUS_NT_CROSS_ENCRYPTION_REQUIRED,
	    "NT_CROSS_ENCRYPTION_REQUIRED" },
	{ NT_STATUS_DOMAIN_CTRLR_CONFIG_ERROR,	"DOMAIN_CTRLR_CONFIG_ERROR" },
	{ NT_STATUS_FT_MISSING_MEMBER,		"FT_MISSING_MEMBER" },
	{ NT_STATUS_ILL_FORMED_SERVICE_ENTRY,	"ILL_FORMED_SERVICE_ENTRY" },
	{ NT_STATUS_ILLEGAL_CHARACTER,		"ILLEGAL_CHARACTER" },
	{ NT_STATUS_UNMAPPABLE_CHARACTER,	"UNMAPPABLE_CHARACTER" },
	{ NT_STATUS_UNDEFINED_CHARACTER,	"UNDEFINED_CHARACTER" },
	{ NT_STATUS_FLOPPY_VOLUME,		"FLOPPY_VOLUME" },
	{ NT_STATUS_FLOPPY_ID_MARK_NOT_FOUND,	"FLOPPY_ID_MARK_NOT_FOUND" },
	{ NT_STATUS_FLOPPY_WRONG_CYLINDER,	"FLOPPY_WRONG_CYLINDER" },
	{ NT_STATUS_FLOPPY_UNKNOWN_ERROR,	"FLOPPY_UNKNOWN_ERROR" },
	{ NT_STATUS_FLOPPY_BAD_REGISTERS,	"FLOPPY_BAD_REGISTERS" },
	{ NT_STATUS_DISK_RECALIBRATE_FAILED,	"DISK_RECALIBRATE_FAILED" },
	{ NT_STATUS_DISK_OPERATION_FAILED,	"DISK_OPERATION_FAILED" },
	{ NT_STATUS_DISK_RESET_FAILED,		"DISK_RESET_FAILED" },
	{ NT_STATUS_SHARED_IRQ_BUSY,		"SHARED_IRQ_BUSY" },
	{ NT_STATUS_FT_ORPHANING,		"FT_ORPHANING" },
	{ NT_STATUS_PARTITION_FAILURE,		"PARTITION_FAILURE" },
	{ NT_STATUS_INVALID_BLOCK_LENGTH,	"INVALID_BLOCK_LENGTH" },
	{ NT_STATUS_DEVICE_NOT_PARTITIONED,	"DEVICE_NOT_PARTITIONED" },
	{ NT_STATUS_UNABLE_TO_LOCK_MEDIA,	"UNABLE_TO_LOCK_MEDIA" },
	{ NT_STATUS_UNABLE_TO_UNLOAD_MEDIA,	"UNABLE_TO_UNLOAD_MEDIA" },
	{ NT_STATUS_EOM_OVERFLOW,		"EOM_OVERFLOW" },
	{ NT_STATUS_NO_MEDIA,			"NO_MEDIA" },
	{ NT_STATUS_NO_SUCH_MEMBER,		"NO SUCH MEMBER" },
	{ NT_STATUS_INVALID_MEMBER,		"INVALID MEMBER" },
	{ NT_STATUS_KEY_DELETED,		"KEY_DELETED" },
	{ NT_STATUS_NO_LOG_SPACE,		"NO_LOG_SPACE" },
	{ NT_STATUS_TOO_MANY_SIDS,		"TOO MANY SIDS" },
	{ NT_STATUS_LM_CROSS_ENCRYPTION_REQUIRED,
	    "LM_CROSS_ENCRYPTION_REQUIRED" },
	{ NT_STATUS_KEY_HAS_CHILDREN,		"KEY_HAS_CHILDREN" },
	{ NT_STATUS_CHILD_MUST_BE_VOLATILE,	"CHILD_MUST_BE_VOLATILE" },
	{ NT_STATUS_DEVICE_CONFIGURATION_ERROR,	"DEVICE_CONFIGURATION_ERROR" },
	{ NT_STATUS_DRIVER_INTERNAL_ERROR,	"DRIVER_INTERNAL_ERROR" },
	{ NT_STATUS_INVALID_DEVICE_STATE,	"INVALID_DEVICE_STATE" },
	{ NT_STATUS_IO_DEVICE_ERROR,		"IO_DEVICE_ERROR" },
	{ NT_STATUS_DEVICE_PROTOCOL_ERROR,	"DEVICE_PROTOCOL_ERROR" },
	{ NT_STATUS_BACKUP_CONTROLLER,		"BACKUP_CONTROLLER" },
	{ NT_STATUS_LOG_FILE_FULL,		"LOG_FILE_FULL" },
	{ NT_STATUS_TOO_LATE,			"TOO_LATE" },
	{ NT_STATUS_NO_TRUST_LSA_SECRET,	"NO_TRUST_LSA_SECRET" },
	{ NT_STATUS_NO_TRUST_SAM_ACCOUNT,	"NO_TRUST_SAM_ACCOUNT" },
	{ NT_STATUS_TRUSTED_DOMAIN_FAILURE,	"TRUSTED_DOMAIN_FAILURE" },
	{ NT_STATUS_TRUSTED_RELATIONSHIP_FAILURE,
	    "TRUSTED_RELATIONSHIP_FAILURE" },
	{ NT_STATUS_EVENTLOG_FILE_CORRUPT,	"EVENTLOG_FILE_CORRUPT" },
	{ NT_STATUS_EVENTLOG_CANT_START,	"EVENTLOG_CANT_START" },
	{ NT_STATUS_TRUST_FAILURE,		"TRUST_FAILURE" },
	{ NT_STATUS_MUTANT_LIMIT_EXCEEDED,	"MUTANT_LIMIT_EXCEEDED" },
	{ NT_STATUS_NETLOGON_NOT_STARTED,	"NETLOGON_NOT_STARTED" },
	{ NT_STATUS_ACCOUNT_EXPIRED,		"ACCOUNT_EXPIRED" },
	{ NT_STATUS_POSSIBLE_DEADLOCK,		"POSSIBLE_DEADLOCK" },
	{ NT_STATUS_NETWORK_CREDENTIAL_CONFLICT,
	    "NETWORK_CREDENTIAL_CONFLICT" },
	{ NT_STATUS_REMOTE_SESSION_LIMIT,	"REMOTE_SESSION_LIMIT" },
	{ NT_STATUS_EVENTLOG_FILE_CHANGED,	"EVENTLOG_FILE_CHANGED" },
	{ NT_STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT,
	    "NOLOGON_INTERDOMAIN_TRUST_ACCOUNT" },
	{ NT_STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT,
	    "NOLOGON_WORKSTATION_TRUST_ACCOUNT" },
	{ NT_STATUS_NOLOGON_SERVER_TRUST_ACCOUNT,
	    "NOLOGON_SERVER_TRUST_ACCOUNT" },
	{ NT_STATUS_DOMAIN_TRUST_INCONSISTENT,	"DOMAIN_TRUST_INCONSISTENT" },
	{ NT_STATUS_FS_DRIVER_REQUIRED,		"FS_DRIVER_REQUIRED" },
	{ NT_STATUS_NO_USER_SESSION_KEY,	"NO_USER_SESSION_KEY" },
	{ NT_STATUS_USER_SESSION_DELETED,	"USER_SESSION_DELETED" },
	{ NT_STATUS_RESOURCE_LANG_NOT_FOUND,	"RESOURCE_LANG_NOT_FOUND" },
	{ NT_STATUS_INSUFF_SERVER_RESOURCES,	"INSUFF_SERVER_RESOURCES" },
	{ NT_STATUS_INVALID_BUFFER_SIZE,	"INVALID_BUFFER_SIZE" },
	{ NT_STATUS_INVALID_ADDRESS_COMPONENT,	"INVALID_ADDRESS_COMPONENT" },
	{ NT_STATUS_INVALID_ADDRESS_WILDCARD,	"INVALID_ADDRESS_WILDCARD" },
	{ NT_STATUS_TOO_MANY_ADDRESSES,		"TOO_MANY_ADDRESSES" },
	{ NT_STATUS_ADDRESS_ALREADY_EXISTS,	"ADDRESS_ALREADY_EXISTS" },
	{ NT_STATUS_ADDRESS_CLOSED,		"ADDRESS_CLOSED" },
	{ NT_STATUS_CONNECTION_DISCONNECTED,	"CONNECTION_DISCONNECTED" },
	{ NT_STATUS_CONNECTION_RESET,		"CONNECTION_RESET" },
	{ NT_STATUS_TOO_MANY_NODES,		"TOO_MANY_NODES" },
	{ NT_STATUS_TRANSACTION_ABORTED,	"TRANSACTION_ABORTED" },
	{ NT_STATUS_TRANSACTION_TIMED_OUT,	"TRANSACTION_TIMED_OUT" },
	{ NT_STATUS_TRANSACTION_NO_RELEASE,	"TRANSACTION_NO_RELEASE" },
	{ NT_STATUS_TRANSACTION_NO_MATCH,	"TRANSACTION_NO_MATCH" },
	{ NT_STATUS_TRANSACTION_RESPONDED,	"TRANSACTION_RESPONDED" },
	{ NT_STATUS_TRANSACTION_INVALID_ID,	"TRANSACTION_INVALID_ID" },
	{ NT_STATUS_TRANSACTION_INVALID_TYPE,	"TRANSACTION_INVALID_TYPE" },
	{ NT_STATUS_NOT_SERVER_SESSION,		"NOT_SERVER_SESSION" },
	{ NT_STATUS_NOT_CLIENT_SESSION,		"NOT_CLIENT_SESSION" },
	{ NT_STATUS_CANNOT_LOAD_REGISTRY_FILE,	"CANNOT_LOAD_REGISTRY_FILE" },
	{ NT_STATUS_DEBUG_ATTACH_FAILED,	"DEBUG_ATTACH_FAILED" },
	{ NT_STATUS_SYSTEM_PROCESS_TERMINATED,	"SYSTEM_PROCESS_TERMINATED" },
	{ NT_STATUS_DATA_NOT_ACCEPTED,		"DATA_NOT_ACCEPTED" },
	{ NT_STATUS_NO_BROWSER_SERVERS_FOUND,	"NO_BROWSER_SERVERS_FOUND" },
	{ NT_STATUS_VDM_HARD_ERROR,		"VDM_HARD_ERROR" },
	{ NT_STATUS_DRIVER_CANCEL_TIMEOUT,	"DRIVER_CANCEL_TIMEOUT" },
	{ NT_STATUS_REPLY_MESSAGE_MISMATCH,	"REPLY_MESSAGE_MISMATCH" },
	{ NT_STATUS_MAPPED_ALIGNMENT,		"MAPPED_ALIGNMENT" },
	{ NT_STATUS_IMAGE_CHECKSUM_MISMATCH,	"IMAGE_CHECKSUM_MISMATCH" },
	{ NT_STATUS_LOST_WRITEBEHIND_DATA,	"LOST_WRITEBEHIND_DATA" },
	{ NT_STATUS_CLIENT_SERVER_PARAMETERS_INVALID,
	    "CLIENT_SERVER_PARAMETERS_INVALID" },
	{ NT_STATUS_PASSWORD_MUST_CHANGE,	"PASSWORD_MUST_CHANGE" },
	{ NT_STATUS_NOT_FOUND,			"NOT_FOUND" },
	{ NT_STATUS_NOT_TINY_STREAM,		"NOT_TINY_STREAM" },
	{ NT_STATUS_RECOVERY_FAILURE,		"RECOVERY_FAILURE" },
	{ NT_STATUS_STACK_OVERFLOW_READ,	"STACK_OVERFLOW_READ" },
	{ NT_STATUS_FAIL_CHECK,			"FAIL_CHECK" },
	{ NT_STATUS_DUPLICATE_OBJECTID,		"DUPLICATE_OBJECTID" },
	{ NT_STATUS_OBJECTID_EXISTS,		"OBJECTID_EXISTS" },
	{ NT_STATUS_CONVERT_TO_LARGE,		"CONVERT_TO_LARGE" },
	{ NT_STATUS_RETRY,			"RETRY" },
	{ NT_STATUS_FOUND_OUT_OF_SCOPE,		"FOUND_OUT_OF_SCOPE" },
	{ NT_STATUS_ALLOCATE_BUCKET,		"ALLOCATE_BUCKET" },
	{ NT_STATUS_PROPSET_NOT_FOUND,		"PROPSET_NOT_FOUND" },
	{ NT_STATUS_MARSHALL_OVERFLOW,		"MARSHALL_OVERFLOW" },
	{ NT_STATUS_INVALID_VARIANT,		"INVALID_VARIANT" },
	{ NT_STATUS_DOMAIN_CONTROLLER_NOT_FOUND,
	    "DOMAIN_CONTROLLER_NOT_FOUND" },
	{ NT_STATUS_ACCOUNT_LOCKED_OUT,		"ACCOUNT_LOCKED_OUT" },
	{ NT_STATUS_HANDLE_NOT_CLOSABLE,	"HANDLE_NOT_CLOSABLE" },
	{ NT_STATUS_CONNECTION_REFUSED,		"CONNECTION_REFUSED" },
	{ NT_STATUS_GRACEFUL_DISCONNECT,	"GRACEFUL_DISCONNECT" },
	{ NT_STATUS_ADDRESS_ALREADY_ASSOCIATED,	"ADDRESS_ALREADY_ASSOCIATED" },
	{ NT_STATUS_ADDRESS_NOT_ASSOCIATED,	"ADDRESS_NOT_ASSOCIATED" },
	{ NT_STATUS_CONNECTION_INVALID,		"CONNECTION_INVALID" },
	{ NT_STATUS_CONNECTION_ACTIVE,		"CONNECTION_ACTIVE" },
	{ NT_STATUS_NETWORK_UNREACHABLE,	"NETWORK_UNREACHABLE" },
	{ NT_STATUS_HOST_UNREACHABLE,		"HOST/PARTNER UNREACHABLE" },
	{ NT_STATUS_PROTOCOL_UNREACHABLE,	"PROTOCOL_UNREACHABLE" },
	{ NT_STATUS_PORT_UNREACHABLE,		"PORT_UNREACHABLE" },
	{ NT_STATUS_REQUEST_ABORTED,		"REQUEST_ABORTED" },
	{ NT_STATUS_CONNECTION_ABORTED,		"CONNECTION_ABORTED" },
	{ NT_STATUS_BAD_COMPRESSION_BUFFER,	"BAD_COMPRESSION_BUFFER" },
	{ NT_STATUS_USER_MAPPED_FILE,		"USER_MAPPED_FILE" },
	{ NT_STATUS_AUDIT_FAILED,		"AUDIT_FAILED" },
	{ NT_STATUS_TIMER_RESOLUTION_NOT_SET,	"TIMER_RESOLUTION_NOT_SET" },
	{ NT_STATUS_CONNECTION_COUNT_LIMIT,	"CONNECTION_COUNT_LIMIT" },
	{ NT_STATUS_LOGIN_TIME_RESTRICTION,	"LOGIN_TIME_RESTRICTION" },
	{ NT_STATUS_LOGIN_WKSTA_RESTRICTION,	"LOGIN_WKSTA_RESTRICTION" },
	{ NT_STATUS_IMAGE_MP_UP_MISMATCH,	"IMAGE_MP_UP_MISMATCH" },
	{ NT_STATUS_INSUFFICIENT_LOGON_INFO,	"INSUFFICIENT_LOGON_INFO" },
	{ NT_STATUS_BAD_DLL_ENTRYPOINT,		"BAD_DLL_ENTRYPOINT" },
	{ NT_STATUS_BAD_SERVICE_ENTRYPOINT,	"BAD_SERVICE_ENTRYPOINT" },
	{ NT_STATUS_LPC_REPLY_LOST,		"LPC_REPLY_LOST" },
	{ NT_STATUS_IP_ADDRESS_CONFLICT1,	"IP_ADDRESS_CONFLICT1" },
	{ NT_STATUS_IP_ADDRESS_CONFLICT2,	"IP_ADDRESS_CONFLICT2" },
	{ NT_STATUS_REGISTRY_QUOTA_LIMIT,	"REGISTRY_QUOTA_LIMIT" },
	{ NT_STATUS_PATH_NOT_COVERED,		"PATH_NOT_COVERED" },
	{ NT_STATUS_NO_CALLBACK_ACTIVE,		"NO_CALLBACK_ACTIVE" },
	{ NT_STATUS_LICENSE_QUOTA_EXCEEDED,	"LICENSE_QUOTA_EXCEEDED" },
	{ NT_STATUS_PWD_TOO_SHORT,		"PWD_TOO_SHORT" },
	{ NT_STATUS_PWD_TOO_RECENT,		"PWD_TOO_RECENT" },
	{ NT_STATUS_PWD_HISTORY_CONFLICT,	"PWD_HISTORY_CONFLICT" },
	{ NT_STATUS_PLUGPLAY_NO_DEVICE,		"PLUGPLAY_NO_DEVICE" },
	{ NT_STATUS_UNSUPPORTED_COMPRESSION,	"UNSUPPORTED_COMPRESSION" },
	{ NT_STATUS_INVALID_HW_PROFILE,		"INVALID_HW_PROFILE" },
	{ NT_STATUS_INVALID_PLUGPLAY_DEVICE_PATH,
	    "INVALID_PLUGPLAY_DEVICE_PATH" },
	{ NT_STATUS_DRIVER_ORDINAL_NOT_FOUND,	"DRIVER_ORDINAL_NOT_FOUND" },
	{ NT_STATUS_DRIVER_ENTRYPOINT_NOT_FOUND,
	    "DRIVER_ENTRYPOINT_NOT_FOUND" },
	{ NT_STATUS_RESOURCE_NOT_OWNED,		"RESOURCE_NOT_OWNED" },
	{ NT_STATUS_TOO_MANY_LINKS,		"TOO_MANY_LINKS" },
	{ NT_STATUS_QUOTA_LIST_INCONSISTENT,	"QUOTA_LIST_INCONSISTENT" },
	{ NT_STATUS_FILE_IS_OFFLINE,		"FILE_IS_OFFLINE" },
};


/*
 * Translate an ntstatus value to a meaningful text string. If there isn't
 * a corresponding text string in the table, the text representation of the
 * status value is returned. This uses a static buffer so there is a
 * possible concurrency issue if the caller hangs on to this pointer for a
 * while but it should be harmless and really remote since the value will
 * almost always be found in the table.
 */
char *
xlate_nt_status(DWORD ntstatus)
{
	static char unknown[16];
	int i;

	for (i = 0; i < sizeof (ntx_table)/sizeof (ntx_table[0]); ++i) {
		if (ntx_table[i].value == NT_SC_VALUE(ntstatus))
			return (ntx_table[i].name);
	}

	(void) sprintf(unknown, "0x%08x", ntstatus);
	return (unknown);
}
