/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _MULDIV_H
#define	_MULDIV_H

#pragma ident	"%Z%%M%	%I%	%E% SMI"

/*
 * Helper routines for Sun and GCC compilers in 32-bit mode,
 * doing 64-bit math.  These routines should not be called directly;
 * they are called by code generated by the compiler.  Their declarations
 * are here for kmdb's hdr2map and map2linktest mechanisms.
 */

#if !defined(__amd64)

#ifdef __cplusplus
extern "C" {
#endif

extern int64_t __mul64(int64_t a, int64_t b);

extern uint64_t __udiv64(uint64_t x, uint64_t y);
extern uint64_t __urem64(uint64_t x, uint64_t y);
extern int64_t __div64(int64_t x, int64_t y);
extern int64_t __rem64(int64_t x, int64_t y);

extern uint64_t __udivdi3(uint64_t a, uint64_t b);
extern uint64_t __umoddi3(uint64_t a, uint64_t b);
extern int64_t __divdi3(int64_t a, int64_t b);
extern int64_t __moddi3(int64_t a, int64_t b);

extern uint64_t __udivrem64(uint64_t x, uint64_t y);
extern int64_t __divrem64(int64_t x, int64_t y);

#ifdef __cplusplus
}
#endif

#endif /* !defined(amd64) */

#endif /* _MULDIV_H */
