
/* : : generated by proto : : */
/***********************************************************************
*                                                                      *
*               This software is part of the ast package               *
*          Copyright (c) 1985-2009 AT&T Intellectual Property          *
*                      and is licensed under the                       *
*                  Common Public License, Version 1.0                  *
*                    by AT&T Intellectual Property                     *
*                                                                      *
*                A copy of the License is available at                 *
*            http://www.opensource.org/licenses/cpl1.0.txt             *
*         (with md5 checksum 059e8cd6165cb4c31e351f2b69388fd9)         *
*                                                                      *
*              Information and Software Systems Research               *
*                            AT&T Research                             *
*                           Florham Park NJ                            *
*                                                                      *
*                 Glenn Fowler <gsf@research.att.com>                  *
*                  David Korn <dgk@research.att.com>                   *
*                   Phong Vo <kpv@research.att.com>                    *
*                                                                      *
***********************************************************************/
                  
/*
 * Advanced Software Technology Library
 * AT&T Research
 *
 * std + posix + ast
 */

#ifndef _AST_H
#if !defined(__PROTO__)
#include <prototyped.h>
#endif
#if !defined(__LINKAGE__)
#define __LINKAGE__		/* 2004-08-11 transition */
#endif

#define _AST_H

#include <ast_version.h>

#ifndef _AST_STD_H
#include <ast_std.h>
#endif

#ifndef _SFIO_H
#include <sfio.h>
#endif

#ifndef	ast
#define ast		_ast_info
#endif

#ifndef PATH_MAX
#define PATH_MAX	1024
#endif

/*
 * workaround botched headers that assume <stdio.h>
 */

#ifndef FILE
#ifndef _SFIO_H
struct _sfio_s;
#endif
#define FILE		struct _sfio_s
#ifndef	__FILE_typedef
#define __FILE_typedef	1
#endif
#ifndef _FILEDEFED
#define _FILEDEFED	1
#endif
#endif

/*
 * exit() support -- this matches shell exit codes
 */

#define EXIT_BITS	8			/* # exit status bits	*/

#define EXIT_USAGE	2			/* usage exit code	*/
#define EXIT_QUIT	((1<<(EXIT_BITS))-1)	/* parent should quit	*/
#define EXIT_NOTFOUND	((1<<(EXIT_BITS-1))-1)	/* command not found	*/
#define EXIT_NOEXEC	((1<<(EXIT_BITS-1))-2)	/* other exec error	*/

#define EXIT_CODE(x)	((x)&((1<<EXIT_BITS)-1))
#define EXIT_CORE(x)	(EXIT_CODE(x)|(1<<EXIT_BITS)|(1<<(EXIT_BITS-1)))
#define EXIT_TERM(x)	(EXIT_CODE(x)|(1<<EXIT_BITS))

/*
 * NOTE: for compatibility the following work for EXIT_BITS={7,8}
 */

#define EXIT_STATUS(x)	(((x)&((1<<(EXIT_BITS-2))-1))?(x):EXIT_CODE((x)>>EXIT_BITS))

#define EXITED_CORE(x)	(((x)&((1<<EXIT_BITS)|(1<<(EXIT_BITS-1))))==((1<<EXIT_BITS)|(1<<(EXIT_BITS-1)))||((x)&((1<<(EXIT_BITS-1))|(1<<(EXIT_BITS-2))))==((1<<(EXIT_BITS-1))|(1<<(EXIT_BITS-2))))
#define EXITED_TERM(x)	((x)&((1<<EXIT_BITS)|(1<<(EXIT_BITS-1))))

/*
 * astconflist() flags
 */

#define ASTCONF_parse		0x0001
#define ASTCONF_write		0x0002
#define ASTCONF_read		0x0004
#define ASTCONF_lower		0x0008
#define ASTCONF_base		0x0010
#define ASTCONF_defined		0x0020
#define ASTCONF_quote		0x0040
#define ASTCONF_table		0x0080
#define ASTCONF_matchcall	0x0100
#define ASTCONF_matchname	0x0200
#define ASTCONF_matchstandard	0x0400
#define ASTCONF_error		0x0800
#define ASTCONF_system		0x1000
#define ASTCONF_AST		0x2000

/*
 * pathcanon() flags
 */

#define PATH_PHYSICAL	01
#define PATH_DOTDOT	02
#define PATH_EXISTS	04
#define PATH_VERIFIED(n) (((n)&01777)<<5)

/*
 * pathaccess() flags
 */

#define PATH_READ	004
#define PATH_WRITE	002
#define PATH_EXECUTE	001
#define	PATH_REGULAR	010
#define PATH_ABSOLUTE	020

/*
 * touch() flags
 */

#define PATH_TOUCH_CREATE	01
#define PATH_TOUCH_VERBATIM	02

/*
 * pathcheck() info
 */

typedef struct
{
	unsigned long	date;
	char*		feature;
	char*		host;
	char*		user;
} Pathcheck_t;

/*
 * strgrpmatch() flags
 */

#define STR_MAXIMAL	01		/* maximal match		*/
#define STR_LEFT	02		/* implicit left anchor		*/
#define STR_RIGHT	04		/* implicit right anchor	*/
#define STR_ICASE	010		/* ignore case			*/
#define STR_GROUP	020		/* (|&) inside [@|&](...) only	*/

/*
 * fmtquote() flags
 */

#define FMT_ALWAYS	0x01		/* always quote			*/
#define FMT_ESCAPED	0x02		/* already escaped		*/
#define FMT_SHELL	0x04		/* escape $ ` too		*/
#define FMT_WIDE	0x08		/* don't escape 8 bit chars	*/
#define FMT_PARAM	0x10		/* disable FMT_SHELL ${$( quote	*/

/*
 * multibyte macros
 */

#define mbmax()		(ast.mb_cur_max)
#define mberr()		(ast.tmp_int<0)

#define mbcoll()	(ast.mb_xfrm!=0)
#define mbwide()	(mbmax()>1)

#define mbchar(p)	(mbwide()?((ast.tmp_int=(*ast.mb_towc)(&ast.tmp_wchar,(char*)(p),mbmax()))>0?((p+=ast.tmp_int),ast.tmp_wchar):(p+=ast.mb_sync+1,ast.tmp_int)):(*(unsigned char*)(p++)))
#define mbinit()	(mbwide()?(*ast.mb_towc)((wchar_t*)0,(char*)0,mbmax()):0)
#define mbsize(p)	(mbwide()?(*ast.mb_len)((char*)(p),mbmax()):((p),1))
#define mbconv(s,w)	(ast.mb_conv?(*ast.mb_conv)(s,w):((*(s)=(w)),1))
#define mbwidth(w)	(ast.mb_width&&((ast.tmp_int=(*ast.mb_width)(w))>=0||(w)>UCHAR_MAX)?ast.tmp_int:1)
#define mbxfrm(t,f,n)	(mbcoll()?(*ast.mb_xfrm)((char*)(t),(char*)(f),n):0)

/*
 * common macros
 */

#define elementsof(x)	(sizeof(x)/sizeof(x[0]))
#define integralof(x)	(((char*)(x))-((char*)0))
#define newof(p,t,n,x)	((p)?(t*)realloc((char*)(p),sizeof(t)*(n)+(x)):(t*)calloc(1,sizeof(t)*(n)+(x)))
#define oldof(p,t,n,x)	((p)?(t*)realloc((char*)(p),sizeof(t)*(n)+(x)):(t*)malloc(sizeof(t)*(n)+(x)))
#define pointerof(x)	((__V_*)((char*)0+(x)))
#define roundof(x,y)	(((x)+(y)-1)&~((y)-1))
#define ssizeof(x)	((int)sizeof(x))

#define streq(a,b)	(*(a)==*(b)&&!strcmp(a,b))
#define strneq(a,b,n)	(*(a)==*(b)&&!strncmp(a,b,n))
#define strsignal(s)	fmtsignal(s)

#if defined(__STDC__) || defined(__cplusplus) || defined(c_plusplus)
#define NiL		0
#define NoP(x)		(void)(x)
#else
#define NiL		((char*)0)
#define NoP(x)		(&x,1)
#endif

#if !defined(NoF)
#if defined(__STDC__) || defined(__STDPP__)
#define NoF(x)		void _DATA_ ## x () {}
#else
#define NoF(x)		void _DATA_/**/x () {}
#endif
#if !defined(_DATA_)
#define _DATA_
#endif
#endif

#if !defined(NoN)
#if defined(__STDC__) || defined(__STDPP__)
#define NoN(x)		void _STUB_ ## x () {}
#else
#define NoN(x)		void _STUB_/**/x () {}
#endif
#if !defined(_STUB_)
#define _STUB_
#endif
#endif

#define NOT_USED(x)	NoP(x)

typedef int (*Error_f) __PROTO__((__V_*, __V_*, int, ...));

typedef int (*Ast_confdisc_f) __PROTO__((const char*, const char*, const char*));
typedef int (*Strcmp_context_f) __PROTO__((const char*, const char*, __V_*));
typedef int (*Strcmp_f) __PROTO__((const char*, const char*));

#if _BLD_ast && defined(__EXPORT__)
#undef __MANGLE__
#define __MANGLE__ __LINKAGE__		__EXPORT__
#endif

extern __MANGLE__ char*		astgetconf __PROTO__((const char*, const char*, const char*, int, Error_f));
extern __MANGLE__ char*		astconf __PROTO__((const char*, const char*, const char*));
extern __MANGLE__ Ast_confdisc_f	astconfdisc __PROTO__((Ast_confdisc_f));
extern __MANGLE__ void		astconflist __PROTO__((Sfio_t*, const char*, int, const char*));
extern __MANGLE__ off_t		astcopy __PROTO__((int, int, off_t));
extern __MANGLE__ int		astlicense __PROTO__((char*, int, char*, char*, int, int, int));
extern __MANGLE__ int		astquery __PROTO__((int, const char*, ...));
extern __MANGLE__ void		astwinsize __PROTO__((int, int*, int*));

extern __MANGLE__ ssize_t		base64encode __PROTO__((const __V_*, size_t, __V_**, __V_*, size_t, __V_**));
extern __MANGLE__ ssize_t		base64decode __PROTO__((const __V_*, size_t, __V_**, __V_*, size_t, __V_**));
extern __MANGLE__ int		chresc __PROTO__((const char*, char**));
extern __MANGLE__ int		chrtoi __PROTO__((const char*));
extern __MANGLE__ int		eaccess __PROTO__((const char*, int));
extern __MANGLE__ char*		fmtbase __PROTO__((long, int, int));
extern __MANGLE__ char*		fmtbasell __PROTO__((intmax_t, int, int));
#define fmtbase(a,b,c)	fmtbasell((intmax_t)(a),b,c) /* until 2003-09-01 */
extern __MANGLE__ char*		fmtbuf __PROTO__((size_t));
extern __MANGLE__ char*		fmtclock __PROTO__((Sfulong_t));
extern __MANGLE__ char*		fmtelapsed __PROTO__((unsigned long, int));
extern __MANGLE__ char*		fmterror __PROTO__((int));
extern __MANGLE__ char*		fmtesc __PROTO__((const char*));
extern __MANGLE__ char*		fmtesq __PROTO__((const char*, const char*));
extern __MANGLE__ char*		fmtident __PROTO__((const char*));
extern __MANGLE__ char*		fmtip4 __PROTO__((uint32_t, int));
extern __MANGLE__ char*		fmtfmt __PROTO__((const char*));
extern __MANGLE__ char*		fmtgid __PROTO__((int));
extern __MANGLE__ char*		fmtmatch __PROTO__((const char*));
extern __MANGLE__ char*		fmtmode __PROTO__((int, int));
extern __MANGLE__ char*		fmtnesq __PROTO__((const char*, const char*, size_t));
extern __MANGLE__ char*		fmtnum __PROTO__((unsigned long, int));
extern __MANGLE__ char*		fmtperm __PROTO__((int));
extern __MANGLE__ char*		fmtquote __PROTO__((const char*, const char*, const char*, size_t, int));
extern __MANGLE__ char*		fmtre __PROTO__((const char*));
extern __MANGLE__ char*		fmtscale __PROTO__((Sfulong_t, int));
extern __MANGLE__ char*		fmtsignal __PROTO__((int));
extern __MANGLE__ char*		fmttime __PROTO__((const char*, time_t));
extern __MANGLE__ char*		fmtuid __PROTO__((int));
extern __MANGLE__ char*		fmtversion __PROTO__((unsigned long));
extern __MANGLE__ __V_*		memdup __PROTO__((const __V_*, size_t));
extern __MANGLE__ void		memfatal __PROTO__((void));
extern __MANGLE__ unsigned int	memhash __PROTO__((const __V_*, int));
extern __MANGLE__ unsigned long	memsum __PROTO__((const __V_*, int, unsigned long));
extern __MANGLE__ char*		pathaccess __PROTO__((char*, const char*, const char*, const char*, int));
extern __MANGLE__ char*		pathbin __PROTO__((void));
extern __MANGLE__ char*		pathcanon __PROTO__((char*, int));
extern __MANGLE__ char*		pathcat __PROTO__((char*, const char*, int, const char*, const char*));
extern __MANGLE__ int		pathcd __PROTO__((const char*, const char*));
extern __MANGLE__ int		pathcheck __PROTO__((const char*, const char*, Pathcheck_t*));
extern __MANGLE__ int		pathexists __PROTO__((char*, int));
extern __MANGLE__ char*		pathfind __PROTO__((const char*, const char*, const char*, char*, size_t));
extern __MANGLE__ int		pathgetlink __PROTO__((const char*, char*, int));
extern __MANGLE__ int		pathinclude __PROTO__((const char*));
extern __MANGLE__ char*		pathkey __PROTO__((char*, char*, const char*, const char*, const char*));
extern __MANGLE__ size_t		pathnative __PROTO__((const char*, char*, size_t));
extern __MANGLE__ char*		pathpath __PROTO__((char*, const char*, const char*, int));
extern __MANGLE__ size_t		pathposix __PROTO__((const char*, char*, size_t));
extern __MANGLE__ char*		pathprobe __PROTO__((char*, char*, const char*, const char*, const char*, int));
extern __MANGLE__ size_t		pathprog __PROTO__((const char*, char*, size_t));
extern __MANGLE__ char*		pathrepl __PROTO__((char*, const char*, const char*));
extern __MANGLE__ int		pathsetlink __PROTO__((const char*, const char*));
extern __MANGLE__ char*		pathshell __PROTO__((void));
extern __MANGLE__ char*		pathtemp __PROTO__((char*, size_t, const char*, const char*, int*));
extern __MANGLE__ char*		pathtmp __PROTO__((char*, const char*, const char*, int*));
extern __MANGLE__ char*		setenviron __PROTO__((const char*));
extern __MANGLE__ int		stracmp __PROTO__((const char*, const char*));
extern __MANGLE__ char*		strcopy __PROTO__((char*, const char*));
extern __MANGLE__ unsigned long	strelapsed __PROTO__((const char*, char**, int));
extern __MANGLE__ int		stresc __PROTO__((char*));
extern __MANGLE__ long		streval __PROTO__((const char*, char**, long(*)(const char*, char**)));
extern __MANGLE__ long		strexpr __PROTO__((const char*, char**, long(*)(const char*, char**, __V_*), __V_*));
extern __MANGLE__ int		strgid __PROTO__((const char*));
extern __MANGLE__ int		strgrpmatch __PROTO__((const char*, const char*, int*, int, int));
extern __MANGLE__ unsigned int	strhash __PROTO__((const char*));
extern __MANGLE__ __V_*		strlook __PROTO__((const __V_*, size_t, const char*));
extern __MANGLE__ int		strmatch __PROTO__((const char*, const char*));
extern __MANGLE__ int		strmode __PROTO__((const char*));
extern __MANGLE__ int		strnacmp __PROTO__((const char*, const char*, size_t));
extern __MANGLE__ char*		strncopy __PROTO__((char*, const char*, size_t));
extern __MANGLE__ int		strnpcmp __PROTO__((const char*, const char*, size_t));
extern __MANGLE__ double		strntod __PROTO__((const char*, size_t, char**));
extern __MANGLE__ _ast_fltmax_t	strntold __PROTO__((const char*, size_t, char**));
extern __MANGLE__ long		strntol __PROTO__((const char*, size_t, char**, int));
extern __MANGLE__ intmax_t		strntoll __PROTO__((const char*, size_t, char**, int));
extern __MANGLE__ long		strnton __PROTO__((const char*, size_t, char**, char*, int));
extern __MANGLE__ unsigned long	strntoul __PROTO__((const char*, size_t, char**, int));
extern __MANGLE__ intmax_t		strntonll __PROTO__((const char*, size_t, char**, char*, int));
extern __MANGLE__ uintmax_t	strntoull __PROTO__((const char*, size_t, char**, int));
extern __MANGLE__ int		strnvcmp __PROTO__((const char*, const char*, size_t));
extern __MANGLE__ int		stropt __PROTO__((const char*, const __V_*, int, int(*)(__V_*, const __V_*, int, const char*), __V_*));
extern __MANGLE__ int		strpcmp __PROTO__((const char*, const char*));
extern __MANGLE__ int		strperm __PROTO__((const char*, char**, int));
extern __MANGLE__ __V_*		strpsearch __PROTO__((const __V_*, size_t, size_t, const char*, char**));
extern __MANGLE__ __V_*		strsearch __PROTO__((const __V_*, size_t, size_t, Strcmp_f, const char*, __V_*));
extern __MANGLE__ void		strsort __PROTO__((char**, int, int(*)(const char*, const char*)));
extern __MANGLE__ char*		strsubmatch __PROTO__((const char*, const char*, int));
extern __MANGLE__ unsigned long	strsum __PROTO__((const char*, unsigned long));
extern __MANGLE__ char*		strtape __PROTO__((const char*, char**));
extern __MANGLE__ int		strtoip4 __PROTO__((const char*, char**, uint32_t*, unsigned char*));
extern __MANGLE__ long		strton __PROTO__((const char*, char**, char*, int));
extern __MANGLE__ intmax_t		strtonll __PROTO__((const char*, char**, char*, int));
extern __MANGLE__ int		struid __PROTO__((const char*));
extern __MANGLE__ int		struniq __PROTO__((char**, int));
extern __MANGLE__ int		strvcmp __PROTO__((const char*, const char*));

#undef __MANGLE__
#define __MANGLE__ __LINKAGE__

/*
 * C library global data symbols not prototyped by <unistd.h>
 */

#if !defined(environ) && defined(__DYNAMIC__)
#define	environ		__DYNAMIC__(environ)
#else
extern __MANGLE__ char**		environ;
#endif

/*
 * really handy malloc()/free() (__FILE__,__LINE__,__FUNCTION__) tracing
 * make with VMDEBUG==1 or debug=1 or CCFLAGS=$(CC.DEBUG)
 * VMDEBUG==0 disables
 * at runtime export VMDEBUG or VMTRACE per vmalloc.3
 * to list originating call locations
 */

#if !_std_malloc && !defined(VMFL) && !defined(_VMHDR_H) && \
	(!defined(VMDEBUG) || VMDEBUG) && (VMDEBUG || _BLD_DEBUG)

#define VMFL	1
#include <vmalloc.h>

#endif

#endif
