#include "FEATURE/standards"
#include "FEATURE/common"
#include <sys/types.h>
#include <limits.h>
#include <unistd.h>
#if !defined(SYS_NMLEN)
#define SYS_NMLEN	9
#endif
#include <sys/systeminfo.h>
#include "FEATURE/param"
#include "conftab.h"

/* : : generated by conf from /home/gisburn/ksh93/ast_ksh_20091014/build_sparc_32bit/src/lib/libast/comp/conf.tab : : */

/*
 * prefix strings -- the first few are indexed by Conf_t.standard
 */

const Prefix_t prefix[] =
{
	"C",	1,	CONF_C,	-1,
	"POSIX",	5,	CONF_POSIX,	-1,
	"SVID",	4,	CONF_SVID,	-1,
	"XOPEN",	5,	CONF_XOPEN,	-1,
	"SUN",	3,	CONF_SUN,	-1,
	"XBS5",	4,	CONF_XBS5,	-1,
	"SCO",	3,	CONF_SCO,	-1,
	"AST",	3,	CONF_AST,	-1,
	"AES",	3,	CONF_AES,	-1,
	"XPG",	3,	CONF_XPG,	-1,
	"GNU",	3,	CONF_GNU,	-1,
	"TRUSTEDBSD",	10,	CONF_TRUSTEDBSD,	-1,
	"XX",		2,	CONF_POSIX,	CONF_nop,
	"CS",		2,	CONF_POSIX,	CONF_confstr,
	"PC",		2,	CONF_POSIX,	CONF_pathconf,
	"SC",		2,	CONF_POSIX,	CONF_sysconf,
	"SI",		2,	CONF_SVID,	CONF_sysinfo,
};

int	prefix_elements = (int)sizeof(prefix) / (int)sizeof(prefix[0]);

/*
 * conf strings sorted in ascending order
 */

const Conf_t conf[] =
{
{ "ABI_AIO_XFER_MAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "ABI_ASYNCHRONOUS_IO", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "ABI_ASYNC_IO", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "ADVISORY_INFO", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_ADVISORY_INFO },
{ "AIO_LISTIO_MAX", { 0ULL, 0 }, { _POSIX_AIO_LISTIO_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, _SC_AIO_LISTIO_MAX },
{ "AIO_MAX", { 0ULL, 0 }, { _POSIX_AIO_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, _SC_AIO_MAX },
{ "AIO_PRIO_DELTA_MAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_sysconf, _SC_AIO_PRIO_DELTA_MAX },
{ "ALLOC_SIZE_MIN", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_UNDERSCORE|CONF_NOUNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_pathconf, _PC_ALLOC_SIZE_MIN },
{ "ARCHITECTURE", { 0, 0 }, { 0, 0 }, CONF_STRING, CONF_SVID, 1, CONF_sysinfo, SI_ARCHITECTURE },
{ "ARG_MAX", { 0ULL, 0 }, { _POSIX_ARG_MAX, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, _SC_ARG_MAX },
{ "ASYNCHRONOUS_IO", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_ASYNCHRONOUS_IO },
{ "ASYNC_IO", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_pathconf, _PC_ASYNC_IO },
{ "ATEXIT_MAX", { 0ULL, 0 }, { 32ULL, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_XOPEN, 1, CONF_sysconf, _SC_ATEXIT_MAX },
{ "AUDIT", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "AVAIL_PROCESSORS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "AVPHYS_PAGES", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SUN, 1, CONF_sysconf, _SC_AVPHYS_PAGES },
{ "BARRIERS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_BARRIERS },
{ "BC_BASE_MAX", { 0ULL, 0 }, { _POSIX2_BC_BASE_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_NOSECTION|CONF_MINMAX_DEF, CONF_POSIX, 2, CONF_sysconf, _SC_BC_BASE_MAX },
{ "BC_DIM_MAX", { 0ULL, 0 }, { _POSIX2_BC_DIM_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_NOSECTION|CONF_MINMAX_DEF, CONF_POSIX, 2, CONF_sysconf, _SC_BC_DIM_MAX },
{ "BC_SCALE_MAX", { 0ULL, 0 }, { _POSIX2_BC_SCALE_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_NOSECTION|CONF_MINMAX_DEF, CONF_POSIX, 2, CONF_sysconf, _SC_BC_SCALE_MAX },
{ "BC_STRING_MAX", { 0ULL, 0 }, { _POSIX2_BC_STRING_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_NOSECTION|CONF_MINMAX_DEF, CONF_POSIX, 2, CONF_sysconf, _SC_BC_STRING_MAX },
{ "BUSTYPES", { 0, 0 }, { 0, 0 }, CONF_STRING, CONF_SVID, 1, CONF_sysinfo, -1 },
{ "CHARCLASS_NAME_MAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT, CONF_XOPEN, 1, CONF_nop, -1 },
{ "CHAR_BIT", { 8ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_LIMIT_DEF, CONF_C, 1, CONF_nop, -1 },
{ "CHAR_MAX", { 127ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_LIMIT_DEF, CONF_C, 1, CONF_nop, -1 },
{ "CHAR_MIN", { -127LL-1LL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_LIMIT_DEF, CONF_C, 1, CONF_nop, -1 },
{ "CHAR_TERM", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 2, CONF_sysconf, _SC_2_CHAR_TERM },
{ "CHILD_MAX", { 0ULL, 0 }, { _POSIX_CHILD_MAX, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, _SC_CHILD_MAX },
{ "CHOWN_RESTRICTED", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_pathconf, _PC_CHOWN_RESTRICTED },
{ "CKPT", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "CLK_TCK", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT, CONF_POSIX, 1, CONF_sysconf, _SC_CLK_TCK },
{ "CLOCKRES_MIN", { 0ULL, 0 }, { _POSIX_CLOCKRES_MIN, 0 }, CONF_MINMAX|CONF_UNDERSCORE|CONF_PREFIX_ONLY|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "CLOCKS_PER_SEC", { 1000000ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_LIMIT|CONF_LIMIT_DEF, CONF_POSIX, 1, CONF_nop, -1 },
{ "CLOCK_SELECTION", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_NOUNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_CLOCK_SELECTION },
{ "COLL_WEIGHTS_MAX", { 0ULL, 0 }, { _POSIX2_COLL_WEIGHTS_MAX, 0 }, CONF_DEFER_MM|CONF_LIMIT|CONF_MINMAX|CONF_NOSECTION|CONF_MINMAX_DEF, CONF_POSIX, 2, CONF_sysconf, _SC_COLL_WEIGHTS_MAX },
{ "CPUTIME", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_CPUTIME },
{ "CPU_KEYBITS1", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "CPU_VERSION", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "CRYPT", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_STANDARD|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_XOPEN, 1, CONF_sysconf, _SC_XOPEN_CRYPT },
{ "C_BIND", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 2, CONF_sysconf, _SC_2_C_BIND },
{ "C_DEV", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 2, CONF_sysconf, _SC_2_C_DEV },
{ "C_VERSION", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 2, CONF_sysconf, _SC_2_C_VERSION },
{ "DATAKEYS_MAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "DELAYTIMER_MAX", { 0ULL, 0 }, { _POSIX_DELAYTIMER_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, _SC_DELAYTIMER_MAX },
{ "ENH_I18N", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_STANDARD|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_XOPEN, 1, CONF_sysconf, _SC_XOPEN_ENH_I18N },
{ "EQUIV_CLASS_MAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "EXEC_INTERPRETER_LENGTH", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "EXPR_NEST_MAX", { 0ULL, 0 }, { _POSIX2_EXPR_NEST_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_NOSECTION|CONF_MINMAX_DEF, CONF_POSIX, 2, CONF_sysconf, _SC_EXPR_NEST_MAX },
{ "FCHR_MAX", { 0ULL, 0 }, { LONG_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_SVID, 1, CONF_sysconf, -1 },
{ "FILESIZEBITS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_pathconf, _PC_FILESIZEBITS },
{ "FILE_LOCKING", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "FORT_DEV", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 2, CONF_sysconf, _SC_2_FORT_DEV },
{ "FORT_RUN", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 2, CONF_sysconf, _SC_2_FORT_RUN },
{ "FSYNC", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_FSYNC },
{ "GETGR_R_SIZE_MAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT, CONF_C, 1, CONF_sysconf, _SC_GETGR_R_SIZE_MAX },
{ "GETPW_R_SIZE_MAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT, CONF_C, 1, CONF_sysconf, _SC_GETPW_R_SIZE_MAX },
{ "HOSTID", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "HOSTNAME", { 0, 0 }, { 0, 0 }, CONF_STRING, CONF_SVID, 1, CONF_sysinfo, SI_HOSTNAME },
{ "HOST_NAME_MAX", { 0ULL, 0 }, { _POSIX_HOST_NAME_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, _SC_HOST_NAME_MAX },
{ "HW_PROVIDER", { 0, 0 }, { 0, 0 }, CONF_STRING, CONF_SVID, 1, CONF_sysinfo, SI_HW_PROVIDER },
{ "HW_SERIAL", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "ILP32_OFF32", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_XBS5, 1, CONF_sysconf, -1 },
{ "ILP32_OFF32_CFLAGS", { 0, 0 }, { 0, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_STRING, CONF_XBS5, 1, CONF_confstr, -1 },
{ "ILP32_OFF32_LDFLAGS", { 0, 0 }, { 0, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_STRING, CONF_XBS5, 1, CONF_confstr, -1 },
{ "ILP32_OFF32_LIBS", { 0, 0 }, { 0, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_STRING, CONF_XBS5, 1, CONF_confstr, -1 },
{ "ILP32_OFF32_LINTFLAGS", { 0, 0 }, { 0, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_STRING, CONF_XBS5, 1, CONF_confstr, -1 },
{ "ILP32_OFFBIG", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_XBS5, 1, CONF_sysconf, -1 },
{ "ILP32_OFFBIG_CFLAGS", { 0, 0 }, { 0, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_STRING, CONF_XBS5, 1, CONF_confstr, -1 },
{ "ILP32_OFFBIG_LDFLAGS", { 0, 0 }, { 0, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_STRING, CONF_XBS5, 1, CONF_confstr, -1 },
{ "ILP32_OFFBIG_LIBS", { 0, 0 }, { 0, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_STRING, CONF_XBS5, 1, CONF_confstr, -1 },
{ "ILP32_OFFBIG_LINTFLAGS", { 0, 0 }, { 0, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_STRING, CONF_XBS5, 1, CONF_confstr, -1 },
{ "INITTAB_NAME", { 0, 0 }, { 0, 0 }, CONF_STRING, CONF_SVID, 1, CONF_sysinfo, -1 },
{ "INT_MAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT, CONF_C, 1, CONF_nop, -1 },
{ "INT_MIN", { -2147483647LL-1LL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_LIMIT_DEF, CONF_C, 1, CONF_nop, -1 },
{ "IOV_MAX", { 0ULL, 0 }, { _XOPEN_IOV_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_XOPEN, 1, CONF_sysconf, _SC_IOV_MAX },
{ "IO_TYPE", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "IPV6", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_IPV6 },
{ "IP_SECOPTS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "JOB_CONTROL", { 0ULL, 0 }, { 1ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_JOB_CONTROL },
{ "KERNEL_CLIST", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SCO, 1, CONF_sysconf, -1 },
{ "KERNEL_CLIST_MAX", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SCO, 1, CONF_sysconf, -1 },
{ "KERNEL_DISK", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SCO, 1, CONF_sysconf, -1 },
{ "KERNEL_DISK_MAX", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SCO, 1, CONF_sysconf, -1 },
{ "KERNEL_DMABUF", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SCO, 1, CONF_sysconf, -1 },
{ "KERNEL_DMABUF_MAX", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SCO, 1, CONF_sysconf, -1 },
{ "KERNEL_FILE", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SCO, 1, CONF_sysconf, -1 },
{ "KERNEL_FILE_MAX", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SCO, 1, CONF_sysconf, -1 },
{ "KERNEL_FLCKREC", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SCO, 1, CONF_sysconf, -1 },
{ "KERNEL_FLCKREC_MAX", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SCO, 1, CONF_sysconf, -1 },
{ "KERNEL_INODE", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SCO, 1, CONF_sysconf, -1 },
{ "KERNEL_INODE_MAX", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SCO, 1, CONF_sysconf, -1 },
{ "KERNEL_MOUNT", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SCO, 1, CONF_sysconf, -1 },
{ "KERNEL_MOUNT_MAX", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SCO, 1, CONF_sysconf, -1 },
{ "KERNEL_PINODE", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SCO, 1, CONF_sysconf, -1 },
{ "KERNEL_PINODE_MAX", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SCO, 1, CONF_sysconf, -1 },
{ "KERNEL_PROC", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SCO, 1, CONF_sysconf, -1 },
{ "KERNEL_PROC_MAX", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SCO, 1, CONF_sysconf, -1 },
{ "KERNEL_REGION", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SCO, 1, CONF_sysconf, -1 },
{ "KERNEL_REGION_MAX", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SCO, 1, CONF_sysconf, -1 },
{ "KERNEL_S5INODE", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SCO, 1, CONF_sysconf, -1 },
{ "KERNEL_S5INODE_MAX", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SCO, 1, CONF_sysconf, -1 },
{ "KERNEL_STAMP", { 0, 0 }, { 0, 0 }, CONF_STRING, CONF_SVID, 1, CONF_sysinfo, -1 },
{ "KERN_POINTERS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "KERN_SIM", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "LEGACY", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_XOPEN, 1, CONF_sysconf, -1 },
{ "LFS64_CFLAGS", { 0, 0 }, { 0, 0 }, CONF_MINMAX|CONF_UNDERSCORE|CONF_STRING, CONF_POSIX, 1, CONF_confstr, _CS_LFS64_CFLAGS },
{ "LFS64_LDFLAGS", { 0, 0 }, { 0, 0 }, CONF_MINMAX|CONF_UNDERSCORE|CONF_STRING, CONF_POSIX, 1, CONF_confstr, _CS_LFS64_LDFLAGS },
{ "LFS64_LIBS", { 0, 0 }, { 0, 0 }, CONF_MINMAX|CONF_UNDERSCORE|CONF_STRING, CONF_POSIX, 1, CONF_confstr, _CS_LFS64_LIBS },
{ "LFS64_LINTFLAGS", { 0, 0 }, { 0, 0 }, CONF_MINMAX|CONF_UNDERSCORE|CONF_STRING, CONF_POSIX, 1, CONF_confstr, _CS_LFS64_LINTFLAGS },
{ "LFS_CFLAGS", { 0, 0 }, { 0, 0 }, CONF_MINMAX|CONF_UNDERSCORE|CONF_STRING, CONF_POSIX, 1, CONF_confstr, _CS_LFS_CFLAGS },
{ "LFS_LDFLAGS", { 0, 0 }, { 0, 0 }, CONF_MINMAX|CONF_UNDERSCORE|CONF_STRING, CONF_POSIX, 1, CONF_confstr, _CS_LFS_LDFLAGS },
{ "LFS_LIBS", { 0, 0 }, { 0, 0 }, CONF_MINMAX|CONF_UNDERSCORE|CONF_STRING, CONF_POSIX, 1, CONF_confstr, _CS_LFS_LIBS },
{ "LFS_LINTFLAGS", { 0, 0 }, { 0, 0 }, CONF_MINMAX|CONF_UNDERSCORE|CONF_STRING, CONF_POSIX, 1, CONF_confstr, _CS_LFS_LINTFLAGS },
{ "LINE_MAX", { 0ULL, 0 }, { _POSIX2_LINE_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_NOSECTION|CONF_MINMAX_DEF, CONF_POSIX, 2, CONF_sysconf, _SC_LINE_MAX },
{ "LINK_MAX", { 0ULL, 0 }, { _POSIX_LINK_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_pathconf, _PC_LINK_MAX },
{ "LLONG_MAX", { 9223372036854775807ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_LIMIT_DEF, CONF_C, 1, CONF_nop, -1 },
{ "LLONG_MIN", { -9223372036854775807LL-1LL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_LIMIT_DEF, CONF_C, 1, CONF_nop, -1 },
{ "LOCALEDEF", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 2, CONF_sysconf, _SC_2_LOCALEDEF },
{ "LOGIN_NAME_MAX", { 0ULL, 0 }, { _POSIX_LOGIN_NAME_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, _SC_LOGIN_NAME_MAX },
{ "LOGNAME_MAX", { 0ULL, 0 }, { 8ULL, 0 }, CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_SVID, 1, CONF_sysconf, _SC_LOGNAME_MAX },
{ "LONG_BIT", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT, CONF_XOPEN, 1, CONF_nop, -1 },
{ "LONG_MAX", { 2147483647ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_LIMIT_DEF, CONF_C, 1, CONF_nop, -1 },
{ "LONG_MIN", { -2147483647LL-1LL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_LIMIT_DEF, CONF_C, 1, CONF_nop, -1 },
{ "LP64_OFF64", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_XBS5, 1, CONF_sysconf, -1 },
{ "LP64_OFF64_CFLAGS", { 0, 0 }, { 0, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_STRING, CONF_XBS5, 1, CONF_confstr, -1 },
{ "LP64_OFF64_LDFLAGS", { 0, 0 }, { 0, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_STRING, CONF_XBS5, 1, CONF_confstr, -1 },
{ "LP64_OFF64_LIBS", { 0, 0 }, { 0, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_STRING, CONF_XBS5, 1, CONF_confstr, -1 },
{ "LP64_OFF64_LINTFLAGS", { 0, 0 }, { 0, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_STRING, CONF_XBS5, 1, CONF_confstr, -1 },
{ "LPBIG_OFFBIG", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_XBS5, 1, CONF_sysconf, -1 },
{ "LPBIG_OFFBIG_CFLAGS", { 0, 0 }, { 0, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_STRING, CONF_XBS5, 1, CONF_confstr, -1 },
{ "LPBIG_OFFBIG_LDFLAGS", { 0, 0 }, { 0, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_STRING, CONF_XBS5, 1, CONF_confstr, -1 },
{ "LPBIG_OFFBIG_LIBS", { 0, 0 }, { 0, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_STRING, CONF_XBS5, 1, CONF_confstr, -1 },
{ "LPBIG_OFFBIG_LINTFLAGS", { 0, 0 }, { 0, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_STRING, CONF_XBS5, 1, CONF_confstr, -1 },
{ "MACHINE", { 0, 0 }, { 0, 0 }, CONF_STRING, CONF_SVID, 1, CONF_sysinfo, SI_MACHINE },
{ "MAPPED_FILES", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_MAPPED_FILES },
{ "MAX_CANON", { 0ULL, 0 }, { _POSIX_MAX_CANON, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_pathconf, _PC_MAX_CANON },
{ "MAX_INPUT", { 0ULL, 0 }, { _POSIX_MAX_INPUT, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_pathconf, _PC_MAX_INPUT },
{ "MB_LEN_MAX", { 5ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_LIMIT_DEF, CONF_C, 1, CONF_nop, -1 },
{ "MCAS_OFFSET", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "MEMLOCK", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_MEMLOCK },
{ "MEMLOCK_RANGE", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_MEMLOCK_RANGE },
{ "MEMORY_PROTECTION", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_MEMORY_PROTECTION },
{ "MESSAGE_PASSING", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_MESSAGE_PASSING },
{ "MMAP_FIXED_ALIGNMENT", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "MONOTONIC_CLOCK", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_MONOTONIC_CLOCK },
{ "MQ_OPEN_MAX", { 0ULL, 0 }, { _POSIX_MQ_OPEN_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, _SC_MQ_OPEN_MAX },
{ "MQ_PRIO_MAX", { 0ULL, 0 }, { _POSIX_MQ_PRIO_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, _SC_MQ_PRIO_MAX },
{ "MSEM_LOCKID", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "MULTI_PROCESS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "NACLS_MAX", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SVID, 1, CONF_sysconf, -1 },
{ "NAME_MAX", { 0ULL, 0 }, { _POSIX_NAME_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_pathconf, _PC_NAME_MAX },
{ "NGROUPS_MAX", { 0ULL, 0 }, { _POSIX_NGROUPS_MAX, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, _SC_NGROUPS_MAX },
{ "NL_ARGMAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT, CONF_XOPEN, 1, CONF_nop, -1 },
{ "NL_LANGMAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT, CONF_XOPEN, 1, CONF_nop, -1 },
{ "NL_MAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "NL_MSGMAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT, CONF_XOPEN, 1, CONF_nop, -1 },
{ "NL_NMAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT, CONF_XOPEN, 1, CONF_nop, -1 },
{ "NL_SETMAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT, CONF_XOPEN, 1, CONF_nop, -1 },
{ "NL_SPECMAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "NL_TEXTMAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT, CONF_XOPEN, 1, CONF_nop, -1 },
{ "NO_TRUNC", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_pathconf, _PC_NO_TRUNC },
{ "NPROCESSORS_CONF", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SVID, 1, CONF_sysconf, _SC_NPROCESSORS_CONF },
{ "NPROCESSORS_MAX", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SVID, 1, CONF_sysconf, _SC_NPROCESSORS_MAX },
{ "NPROCESSORS_ONLN", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SVID, 1, CONF_sysconf, _SC_NPROCESSORS_ONLN },
{ "NPROC_CONF", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "NPROC_ONLN", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "NSS_BUFLEN_GROUP", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "NSS_BUFLEN_PASSWD", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "NUM_PROCESSORS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "NZERO", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT, CONF_XOPEN, 1, CONF_nop, -1 },
{ "OPEN_MAX", { 0ULL, 0 }, { _POSIX_OPEN_MAX, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, _SC_OPEN_MAX },
{ "OPEN_MAX_CEIL", { OPEN_MAX, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_LIMIT_DEF, CONF_AST, 1, CONF_nop, -1 },
{ "OSREL_MAJ", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "OSREL_MIN", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "OSREL_PATCH", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "OS_BASE", { 0, 0 }, { 0, 0 }, CONF_STRING, CONF_SVID, 1, CONF_sysinfo, -1 },
{ "OS_PROVIDER", { 0, 0 }, { 0, 0 }, CONF_STRING, CONF_SVID, 1, CONF_sysinfo, -1 },
{ "OS_VERSION", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_STANDARD|CONF_UNDERSCORE, CONF_AES, 1, CONF_sysconf, -1 },
{ "PAGESIZE", { 0ULL, 0 }, { 4096ULL, 0 }, CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, _SC_PAGESIZE },
{ "PAGE_SIZE", { 0ULL, 0 }, { 0ULL, 0 }, CONF_MINMAX|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_sysconf, _SC_PAGE_SIZE },
{ "PASS_MAX", { 0ULL, 0 }, { 8ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_SVID, 1, CONF_sysconf, _SC_PASS_MAX },
{ "PATH", { 0, 0 }, { 0, "/bin:/usr/bin" }, CONF_DEFER_CALL|CONF_MINMAX|CONF_UNDERSCORE|CONF_STRING|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_confstr, _CS_PATH },
{ "PATH_MAX", { 0ULL, 0 }, { _POSIX_PATH_MAX, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_pathconf, _PC_PATH_MAX },
{ "PBS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 2, CONF_sysconf, _SC_2_PBS },
{ "PBS_ACCOUNTING", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 2, CONF_sysconf, _SC_2_PBS_ACCOUNTING },
{ "PBS_CHECKPOINT", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 2, CONF_sysconf, _SC_2_PBS_CHECKPOINT },
{ "PBS_LOCATE", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 2, CONF_sysconf, _SC_2_PBS_LOCATE },
{ "PBS_MESSAGE", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 2, CONF_sysconf, _SC_2_PBS_MESSAGE },
{ "PBS_TRACK", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 2, CONF_sysconf, _SC_2_PBS_TRACK },
{ "PHYS_PAGES", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SUN, 1, CONF_sysconf, _SC_PHYS_PAGES },
{ "PID_MAX", { 0ULL, 0 }, { 30000ULL, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_SVID, 1, CONF_sysconf, -1 },
{ "PII", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "PII_INTERNET", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "PII_INTERNET_DGRAM", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "PII_INTERNET_STREAM", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "PII_OSI", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "PII_OSI_CLTS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "PII_OSI_COTS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "PII_OSI_M", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "PII_SOCKET", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "PII_XTI", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "PIPE_BUF", { 0ULL, 0 }, { _POSIX_PIPE_BUF, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_pathconf, _PC_PIPE_BUF },
{ "POLL", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "PRIORITIZED_IO", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_PRIORITIZED_IO },
{ "PRIORITY_SCHEDULING", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_PRIORITY_SCHEDULING },
{ "PRIO_IO", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_pathconf, _PC_PRIO_IO },
{ "PROC_RSRC_MGR", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "PTHREAD_DESTRUCTOR_ITERATIONS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "PTHREAD_KEYS_MAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "PTHREAD_STACK_MIN", { 4096ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_LIMIT|CONF_LIMIT_DEF, CONF_POSIX, 1, CONF_nop, -1 },
{ "PTHREAD_THREADS_MAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "PTRDIFF_MAX", { 2147483647ULL, 0 }, { 65535ULL, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_LIMIT_DEF|CONF_MINMAX_DEF, CONF_C, 1, CONF_nop, -1 },
{ "PTRDIFF_MIN", { -2147483647LL-1LL, 0 }, { -65535LL, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_LIMIT_DEF|CONF_MINMAX_DEF, CONF_C, 1, CONF_nop, -1 },
{ "RAW_SOCKETS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_RAW_SOCKETS },
{ "READER_WRITER_LOCKS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_READER_WRITER_LOCKS },
{ "REALTIME", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_XOPEN, 1, CONF_sysconf, -1 },
{ "REALTIME_SIGNALS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_REALTIME_SIGNALS },
{ "REALTIME_THREADS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_XOPEN, 1, CONF_sysconf, -1 },
{ "REC_INCR_XFER_SIZE", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_NOUNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_pathconf, _PC_REC_INCR_XFER_SIZE },
{ "REC_MAX_XFER_SIZE", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_NOUNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_pathconf, _PC_REC_MAX_XFER_SIZE },
{ "REC_MIN_XFER_SIZE", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_NOUNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_pathconf, _PC_REC_MIN_XFER_SIZE },
{ "REC_XFER_ALIGN", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_NOUNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_pathconf, _PC_REC_XFER_ALIGN },
{ "REENTRANT_FUNCTIONS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "REGEXP", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_REGEXP },
{ "REGEX_VERSION", { 0ULL, 0 }, { 20030916ULL, 0 }, CONF_FEATURE, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "RELEASE", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT, CONF_AST, 1, CONF_nop, -1 },
{ "RESOURCE_LIMITS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "RE_DUP_MAX", { 0ULL, 0 }, { _POSIX2_RE_DUP_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_NOSECTION|CONF_MINMAX_DEF, CONF_POSIX, 2, CONF_sysconf, _SC_RE_DUP_MAX },
{ "RTSIG_MAX", { 0ULL, 0 }, { _POSIX_RTSIG_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, _SC_RTSIG_MAX },
{ "SAVED_IDS", { 0ULL, 0 }, { 1ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_SAVED_IDS },
{ "SCHAR_MAX", { 127ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_LIMIT_DEF, CONF_C, 1, CONF_nop, -1 },
{ "SCHAR_MIN", { -127LL-1LL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_LIMIT_DEF, CONF_C, 1, CONF_nop, -1 },
{ "SECURITY_CLASS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "SELECT", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "SEMAPHORES", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_SEMAPHORES },
{ "SEM_NSEMS_MAX", { 0ULL, 0 }, { _POSIX_SEM_NSEMS_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, _SC_SEM_NSEMS_MAX },
{ "SEM_VALUE_MAX", { 0ULL, 0 }, { _POSIX_SEM_VALUE_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, _SC_SEM_VALUE_MAX },
{ "SH", { 0, 0 }, { 0, "/bin/sh" }, CONF_MINMAX|CONF_UNDERSCORE|CONF_STRING|CONF_MINMAX_DEF, CONF_AST, 1, CONF_confstr, -1 },
{ "SHARED_MEMORY_OBJECTS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_SHARED_MEMORY_OBJECTS },
{ "SHELL", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_NOUNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_SHELL },
{ "SHM", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_STANDARD|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_XOPEN, 1, CONF_sysconf, _SC_XOPEN_SHM },
{ "SHRT_MAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT, CONF_C, 1, CONF_nop, -1 },
{ "SHRT_MIN", { -32767LL-1LL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_LIMIT_DEF, CONF_C, 1, CONF_nop, -1 },
{ "SIGQUEUE_MAX", { 0ULL, 0 }, { _POSIX_SIGQUEUE_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, _SC_SIGQUEUE_MAX },
{ "SIGRT_MAX", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SVID, 1, CONF_sysconf, _SC_SIGRT_MAX },
{ "SIGRT_MIN", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_SVID, 1, CONF_sysconf, _SC_SIGRT_MIN },
{ "SIG_ATOMIC_MAX", { 2147483647ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_LIMIT_DEF, CONF_C, 1, CONF_nop, -1 },
{ "SIG_ATOMIC_MIN", { -2147483647LL-1LL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_LIMIT_DEF, CONF_C, 1, CONF_nop, -1 },
{ "SIZE_MAX", { UINT_MAX, 0 }, { 65535ULL, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_LIMIT_DEF|CONF_MINMAX_DEF, CONF_C, 1, CONF_nop, -1 },
{ "SLVM_MAXNODES", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "SOCK_MAXBUF", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "SOFTPOWER", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "SPAWN", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_SPAWN },
{ "SPIN_LOCKS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_SPIN_LOCKS },
{ "SPORADIC_SERVER", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_SPORADIC_SERVER },
{ "SRPC_DOMAIN", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "SSIZE_MAX", { INT_MAX, 0 }, { _POSIX_SSIZE_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_LIMIT_DEF|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_nop, -1 },
{ "SS_REPL_MAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_SS_REPL_MAX },
{ "STD_BLK", { 0ULL, 0 }, { 1024ULL, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_SVID, 1, CONF_sysconf, -1 },
{ "STREAMS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_STANDARD|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_XOPEN, 1, CONF_sysconf, _SC_XOPEN_STREAMS },
{ "STREAM_MAX", { 0ULL, 0 }, { _POSIX_STREAM_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, _SC_STREAM_MAX },
{ "SW_DEV", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 2, CONF_sysconf, _SC_2_SW_DEV },
{ "SYMLINKS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 2, CONF_pathconf, _PC_2_SYMLINKS },
{ "SYMLINK_MAX", { 0ULL, 0 }, { _POSIX_SYMLINK_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_pathconf, _PC_SYMLINK_MAX },
{ "SYMLOOP_MAX", { 0ULL, 0 }, { _POSIX_SYMLOOP_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, _SC_SYMLOOP_MAX },
{ "SYNCHRONIZED_IO", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_SYNCHRONIZED_IO },
{ "SYNC_IO", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_pathconf, _PC_SYNC_IO },
{ "SYSNAME", { 0, 0 }, { 0, 0 }, CONF_STRING, CONF_SVID, 1, CONF_sysinfo, SI_SYSNAME },
{ "SYSPID_MAX", { 0ULL, 0 }, { 2ULL, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_SVID, 1, CONF_sysconf, -1 },
{ "THREADS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_THREADS },
{ "THREADS_PRIO_CEILING", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "THREADS_PRIO_INHERIT", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "THREAD_ATTR_STACKADDR", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_THREAD_ATTR_STACKADDR },
{ "THREAD_ATTR_STACKSIZE", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_THREAD_ATTR_STACKSIZE },
{ "THREAD_CPUTIME", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_THREAD_CPUTIME },
{ "THREAD_DESTRUCTOR_ITERATIONS", { 0ULL, 0 }, { _POSIX_THREAD_DESTRUCTOR_ITERATIONS, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_PREFIX_ONLY|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, _SC_THREAD_DESTRUCTOR_ITERATIONS },
{ "THREAD_KEYS_MAX", { 0ULL, 0 }, { _POSIX_THREAD_KEYS_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_PREFIX_ONLY|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, _SC_THREAD_KEYS_MAX },
{ "THREAD_PRIORITY_SCHEDULING", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_THREAD_PRIORITY_SCHEDULING },
{ "THREAD_PRIO_INHERIT", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_THREAD_PRIO_INHERIT },
{ "THREAD_PRIO_PROTECT", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_THREAD_PRIO_PROTECT },
{ "THREAD_PROCESS_SHARED", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_THREAD_PROCESS_SHARED },
{ "THREAD_SAFE_FUNCTIONS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_THREAD_SAFE_FUNCTIONS },
{ "THREAD_SPORADIC_SERVER", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_THREAD_SPORADIC_SERVER },
{ "THREAD_STACK_MIN", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_THREAD_STACK_MIN },
{ "THREAD_THREADS_MAX", { 0ULL, 0 }, { _POSIX_THREAD_THREADS_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_PREFIX_ONLY|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, _SC_THREAD_THREADS_MAX },
{ "TIMEOUTS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_TIMEOUTS },
{ "TIMERS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_TIMERS },
{ "TIMER_MAX", { 0ULL, 0 }, { _POSIX_TIMER_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, _SC_TIMER_MAX },
{ "TMP", { 0, 0 }, { 0, "/tmp" }, CONF_MINMAX|CONF_UNDERSCORE|CONF_STRING|CONF_MINMAX_DEF, CONF_AST, 1, CONF_confstr, -1 },
{ "TMP_MAX", { 17576ULL, 0 }, { 10000ULL, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_LIMIT_DEF|CONF_MINMAX_DEF, CONF_C, 1, CONF_sysconf, -1 },
{ "TRACE", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_TRACE },
{ "TRACE_EVENT_FILTER", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_TRACE_EVENT_FILTER },
{ "TRACE_EVENT_NAME_MAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_NOUNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_TRACE_EVENT_NAME_MAX },
{ "TRACE_INHERIT", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_TRACE_INHERIT },
{ "TRACE_LOG", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_TRACE_LOG },
{ "TRACE_NAME_MAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_NOUNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_TRACE_NAME_MAX },
{ "TRACE_SYS_MAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_NOUNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_TRACE_SYS_MAX },
{ "TRACE_USER_EVENT_MAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_NOUNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_TRACE_USER_EVENT_MAX },
{ "TTY_NAME_MAX", { 0ULL, 0 }, { _POSIX_TTY_NAME_MAX, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, _SC_TTY_NAME_MAX },
{ "TYPED_MEMORY_OBJECTS", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_TYPED_MEMORY_OBJECTS },
{ "TZNAME_MAX", { 0ULL, 0 }, { _POSIX_TZNAME_MAX, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_POSIX, 1, CONF_sysconf, _SC_TZNAME_MAX },
{ "T_IOV_MAX", { 0ULL, 0 }, { 0ULL, 0 }, 0, CONF_C, 1, CONF_sysconf, _SC_T_IOV_MAX },
{ "UCHAR_MAX", { 255ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_LIMIT_DEF, CONF_C, 1, CONF_nop, -1 },
{ "UCHAR_MIN", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT, CONF_C, 1, CONF_nop, -1 },
{ "UID_MAX", { 0ULL, 0 }, { 60002ULL, 0 }, CONF_LIMIT|CONF_MINMAX|CONF_UNDERSCORE|CONF_MINMAX_DEF, CONF_SVID, 1, CONF_sysconf, -1 },
{ "UINT_MAX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT, CONF_C, 1, CONF_nop, -1 },
{ "UIO_MAXIOV", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_nop, -1 },
{ "ULLONG_MAX", { 18446744073709551615ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_LIMIT_DEF, CONF_C, 1, CONF_nop, -1 },
{ "ULONG_MAX", { 4294967295ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_LIMIT_DEF, CONF_C, 1, CONF_nop, -1 },
{ "UNIX", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_STANDARD|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_XOPEN, 1, CONF_sysconf, _SC_XOPEN_UNIX },
{ "UPE", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 2, CONF_sysconf, _SC_2_UPE },
{ "USER_LIMIT", { 0, 0 }, { 0, 0 }, CONF_STRING, CONF_SVID, 1, CONF_sysinfo, -1 },
{ "USHRT_MAX", { 65535ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_LIMIT_DEF, CONF_C, 1, CONF_nop, -1 },
{ "V6_ILP32_OFF32", { 0ULL, 0 }, { 0ULL, 0 }, CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_V6_ILP32_OFF32 },
{ "V6_ILP32_OFFBIG", { 0ULL, 0 }, { 0ULL, 0 }, CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_V6_ILP32_OFFBIG },
{ "V6_LP64_OFF64", { 0ULL, 0 }, { 0ULL, 0 }, CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_V6_LP64_OFF64 },
{ "V6_LPBIG_OFFBIG", { 0ULL, 0 }, { 0ULL, 0 }, CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_sysconf, _SC_V6_LPBIG_OFFBIG },
{ "VDISABLE", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE|CONF_PREFIX_ONLY, CONF_POSIX, 1, CONF_pathconf, _PC_VDISABLE },
{ "VERSION", { 0, 0 }, { 0, 0 }, CONF_PREFIXED|CONF_STANDARD|CONF_STRING, CONF_SVID, 1, CONF_sysinfo, -1 },
{ "VERSION", { 0ULL, 0 }, { 200112ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_PREFIXED|CONF_STANDARD|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "VERSION", { 0ULL, 0 }, { 200112ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_PREFIXED|CONF_STANDARD|CONF_UNDERSCORE, CONF_POSIX, 2, CONF_sysconf, -1 },
{ "VERSION", { 0ULL, 0 }, { 600ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_PREFIXED|CONF_STANDARD|CONF_UNDERSCORE, CONF_XOPEN, 1, CONF_sysconf, _SC_XOPEN_VERSION },
{ "VERSION", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_MM|CONF_FEATURE|CONF_PREFIXED|CONF_STANDARD|CONF_UNDERSCORE, CONF_XPG, 3, CONF_sysconf, -1 },
{ "VERSION", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_MM|CONF_FEATURE|CONF_PREFIXED|CONF_STANDARD|CONF_UNDERSCORE, CONF_XPG, 4, CONF_sysconf, -1 },
{ "VERSION", { 0ULL, 0 }, { 0ULL, 0 }, CONF_MINMAX|CONF_PREFIXED|CONF_STANDARD, CONF_AST, 1, CONF_nop, -1 },
{ "VERSION", { 0ULL, 0 }, { 0ULL, 0 }, CONF_PREFIXED|CONF_STANDARD, CONF_GNU, 1, CONF_nop, -1 },
{ "VERSION", { 0ULL, 0 }, { 0ULL, 0 }, CONF_PREFIXED|CONF_STANDARD, CONF_TRUSTEDBSD, 1, CONF_nop, -1 },
{ "VERSION_88", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_LIMIT|CONF_STANDARD|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "VERSION_88", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT, CONF_C, 1, CONF_nop, -1 },
{ "VERSION_90", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_LIMIT|CONF_STANDARD|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "VERSION_90", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT, CONF_C, 1, CONF_nop, -1 },
{ "VERSION_93", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_LIMIT|CONF_STANDARD|CONF_UNDERSCORE, CONF_POSIX, 1, CONF_sysconf, -1 },
{ "VERSION_93", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT, CONF_C, 1, CONF_nop, -1 },
{ "WCHAR_MAX", { 2147483647ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_LIMIT_DEF, CONF_C, 1, CONF_nop, -1 },
{ "WCHAR_MIN", { -2147483647LL-1LL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_LIMIT_DEF, CONF_C, 1, CONF_nop, -1 },
{ "WINT_MAX", { 2147483647ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_LIMIT_DEF, CONF_C, 1, CONF_nop, -1 },
{ "WINT_MIN", { -2147483647LL-1LL, 0 }, { 0ULL, 0 }, CONF_LIMIT|CONF_LIMIT_DEF, CONF_C, 1, CONF_nop, -1 },
{ "WORD_BIT", { 0ULL, 0 }, { 0ULL, 0 }, CONF_LIMIT, CONF_XOPEN, 1, CONF_nop, -1 },
{ "XCU_VERSION", { 0ULL, 0 }, { 0ULL, 0 }, CONF_DEFER_CALL|CONF_DEFER_MM|CONF_FEATURE|CONF_STANDARD|CONF_UNDERSCORE, CONF_XOPEN, 1, CONF_sysconf, _SC_XOPEN_XCU_VERSION },
{ "XPG2", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_XOPEN, 1, CONF_nop, -1 },
{ "XPG3", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_XOPEN, 1, CONF_nop, -1 },
{ "XPG4", { 0ULL, 0 }, { 0ULL, 0 }, CONF_FEATURE|CONF_UNDERSCORE, CONF_XOPEN, 1, CONF_nop, -1 },
};

int	conf_elements = (int)sizeof(conf) / (int)sizeof(conf[0]);
