/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
#pragma ident	"%Z%%M%	%I%	%E% SMI" 

/*
 * Copyright (c) 1988 by Sun Microsystems, Inc.
 */

#include "base_conversion.h"

unsigned short  _max_big_powers_ten = 1260;
unsigned short  _big_powers_ten[] = {1,	/* begin powers of 10000 in
						 * base 65536 */
	 /* 10000**90 =  65536**22 *  */ 24832, 26544, 2586, 53761, 57792, 53253, 29499, 56082,
	11839, 41887, 40418, 25010, 56546, 10851, 1212, 37926,
	54683, 24944, 9622, 49891, 30137, 5131, 11297, 7965,
	27232, 47123, 15266, 35282, 32115, 24817, 55263, 50890,
	57131, 1641, 34615, 9400, 1773, 26259, 28395, 6473,
	56175, 37773, 33397, 24180, 39478, 50542, 46897, 13968,
	17093, 51240, 31118, 9390, 3806,	/* * 65536**74 */
	 /* 10000**180 =  65536**45 *  */ 33985, 7059, 50023, 49495, 50123, 42743, 46480, 57582,
	11318, 19673, 45663, 3344, 38612, 23984, 46968, 53347,
	1637, 11314, 39569, 11385, 46514, 18737, 254, 8488,
	51985, 44900, 30372, 57670, 35, 2423, 21277, 52736,
	17783, 36546, 57005, 52994, 11764, 34186, 38967, 29573,
	31609, 52884, 35484, 5862, 37331, 46285, 3552, 17166,
	23884, 16123, 63828, 64220, 40233, 60185, 35113, 44957,
	62568, 31869, 62842, 20359, 37122, 26110, 39645, 20711,
	5066, 62485, 7570, 43880, 25252, 32872, 25424, 17843,
	18779, 28712, 52721, 12061, 37011, 17182, 18688, 41694,
	9744, 49728, 27156, 3092, 40688, 48751, 18433, 52160,
	33601, 24318, 57448, 65020, 26274, 17344, 47654, 41401,
	62950, 31535, 27325, 4701, 11581, 64161, 47399, 3270,
	221,			/* * 65536**149 */
	 /* 10000**270 =  65536**67 *  */ 8448, 53501, 26337, 31473, 40957, 40631, 48909, 53457,
	20735, 15028, 5789, 54161, 14411, 54948, 58612, 16703,
	60933, 37416, 13759, 21647, 15992, 8158, 21322, 49916,
	50899, 10500, 61546, 64808, 24885, 47894, 22543, 7780,
	30293, 45924, 12217, 38801, 56975, 28948, 9918, 42159,
	64774, 9810, 51572, 22988, 21827, 9461, 13137, 48930,
	33891, 51044, 37035, 25332, 1280, 56459, 12584, 48754,
	40019, 43829, 8962, 15530, 62271, 18344, 6657, 19593,
	44745, 58787, 40668, 52192, 32657, 12973, 31749, 56817,
	44085, 36894, 57738, 47056, 63832, 3276, 5478, 58665,
	57346, 40249, 28227, 21581, 12301, 31946, 358, 8638,
	19457, 56089, 7233, 5275, 49953, 53412, 34142, 32827,
	37650, 65359, 31247, 34120, 46664, 57489, 20280, 30130,
	28614, 21249, 30833, 40373, 44196, 8194, 36189, 58466,
	2574, 44938, 8814, 109, 18128, 7521, 47937, 57918,
	37532, 54663, 2577, 9044, 22665, 25537, 10764, 19087,
	7004, 2179, 41422, 5651, 26207, 17993, 50256, 38597,
	3449, 61115, 20807, 44005, 28834, 13215, 7913, 53059,
	4484, 48600, 17162, 35297, 4759, 49174, 43511, 60182,
	5836, 31015, 22479, 40680, 54915, 12,	/* * 65536**224 */
	 /* 10000**360 =  65536**90 *  */ 39297, 28797, 19536, 11545, 64015, 52591, 13876, 58921,
	23682, 1986, 56989, 18252, 21209, 33745, 52547, 51178,
	2782, 19350, 6109, 37173, 53626, 3048, 1461, 55725,
	51369, 18035, 53937, 17798, 33511, 50816, 46721, 45035,
	58118, 27037, 24312, 45764, 42900, 63148, 16576, 11767,
	46031, 6789, 47345, 858, 43692, 25905, 7147, 29400,
	28424, 54349, 52149, 60542, 63221, 7749, 51852, 6952,
	25762, 29494, 20486, 45960, 32833, 26932, 18753, 55669,
	15583, 21202, 32441, 16038, 60580, 44361, 9748, 61294,
	59477, 43384, 56673, 48473, 14732, 25204, 62875, 17232,
	55644, 40058, 18129, 397, 49816, 27626, 60216, 25306,
	38110, 10732, 35472, 39607, 16165, 62410, 7086, 27496,
	50158, 41865, 47027, 43707, 3983, 64460, 53739, 28189,
	875, 42538, 58391, 18282, 8861, 45795, 10907, 36476,
	20935, 50159, 63428, 22377, 35199, 22005, 58273, 27559,
	40171, 2536, 15354, 53038, 32599, 8294, 43881, 6890,
	4104, 39477, 3416, 14231, 63716, 58698, 8871, 28387,
	43094, 28276, 49866, 44118, 58895, 28174, 4918, 14393,
	4723, 25333, 55124, 30906, 58587, 29493, 21770, 496,
	22682, 20698, 63098, 29331, 42083, 17816, 23787, 43214,
	2135, 41163, 59940, 47651, 37571, 35042, 16945, 53313,
	47751, 5968, 61004, 51568, 25849, 56505, 61289, 33232,
	55259, 50253, 35550, 46938, 19022, 14950, 37908, 18484,
	19143, 12648, 11973, 7740, 15947, 57462, 5693, 21228,
	11590, 15884, 57998, 31222, 14304, 59938, 39970, 1254,
	5177, 25824, 46245, 44888, 46972, 27017, 60069, 4030,
	48863,			/* * 65536**298 */
	 /* 10000**450 =  65536**112 *  */ 57600, 1753, 64214, 10939, 52713, 57114, 47498, 12718,
	65226, 52478, 17581, 45728, 40296, 17124, 22976, 7882,
	59829, 9678, 48006, 42769, 33867, 59105, 40007, 33681,
	62758, 12880, 7653, 19018, 42114, 60278, 48185, 24533,
	7865, 16338, 28648, 55791, 6926, 17250, 39828, 40360,
	3146, 9794, 29068, 10091, 31954, 10861, 174, 9952,
	30118, 38130, 10042, 27126, 56412, 40935, 47114, 38430,
	26489, 15830, 50460, 58142, 53729, 28445, 34585, 11908,
	54573, 17947, 9765, 11260, 4075, 58984, 37064, 3346,
	57974, 57633, 26781, 41340, 61062, 3241, 44773, 47277,
	24897, 34071, 18673, 27883, 6091, 16551, 28150, 8364,
	61856, 64804, 11090, 50777, 18722, 53215, 55972, 60192,
	45393, 21503, 15047, 51201, 21232, 3696, 22906, 29678,
	36725, 62961, 55329, 45203, 36089, 61516, 18075, 29511,
	26330, 20863, 5232, 942, 52303, 1329, 7169, 16407,
	23511, 28002, 27861, 39195, 36757, 29288, 52738, 31621,
	59210, 51984, 42640, 5659, 47418, 7854, 11002, 58823,
	59570, 36949, 22019, 59119, 41882, 20539, 877, 50827,
	37562, 38614, 43945, 48560, 55615, 11703, 51736, 56400,
	53305, 18317, 58518, 38512, 29906, 60122, 44314, 46596,
	19166, 62123, 52578, 15091, 61001, 5047, 22701, 14755,
	18755, 47468, 31041, 14196, 42158, 21968, 3373, 44915,
	57195, 47466, 25892, 61074, 29817, 54, 64515, 27653,
	57344, 1463, 29300, 40052, 16841, 42643, 59474, 15330,
	16570, 6014, 44041, 19131, 29244, 50031, 55233, 44818,
	47712, 45727, 952, 34593, 60454, 19073, 4703, 4072,
	20111, 54979, 12176, 32868, 27943, 49668, 5088, 3807,
	49956, 5296, 3481, 21434, 32644, 61933, 14474, 15724,
	10598, 63757, 8203, 57593, 35835, 35825, 54421, 10282,
	58911, 46419, 7408, 59548, 56341, 21421, 19169, 40562,
	34398, 32643, 48732, 2508, 2467, 37998, 64620, 58696,
	45958, 12921, 53097, 62410, 8256, 16357, 3350, 63594,
	35148, 3705, 63330, 36057, 54181, 2837,	/* * 65536**373 */
	 /* 10000**540 =  65536**135 *  */ 15937, 20970, 57308, 46022, 51974, 28228, 49601, 21388,
	40296, 55589, 44307, 42834, 398, 65459, 29106, 36117,
	58627, 55677, 12574, 29537, 16367, 36210, 27724, 17412,
	18304, 13827, 20066, 27247, 827, 4058, 41496, 20247,
	51620, 1082, 40533, 21160, 34685, 20554, 43988, 59273,
	34265, 55478, 129, 12039, 16053, 54781, 10914, 47279,
	59144, 13059, 239, 57141, 24079, 42596, 19598, 19025,
	42888, 9118, 45324, 12662, 14300, 23767, 3983, 64928,
	23773, 48090, 61417, 45026, 31449, 8952, 13451, 50205,
	9133, 1606, 29283, 16751, 52783, 25986, 27202, 64448,
	7976, 36045, 65419, 18289, 6687, 58459, 2696, 64771,
	59103, 11898, 15922, 1849, 13696, 18721, 51962, 60276,
	33088, 13618, 33835, 955, 54730, 30753, 42953, 7375,
	61463, 55489, 54327, 58832, 30130, 14445, 27383, 2532,
	60622, 8764, 27263, 20809, 29172, 10746, 27493, 19018,
	21323, 2715, 51634, 13711, 18305, 64990, 61883, 29593,
	30164, 37070, 50170, 17727, 64571, 25429, 8567, 42658,
	41690, 25244, 38225, 58617, 37108, 46866, 41447, 12452,
	41201, 46696, 36226, 58260, 6808, 60813, 3511, 42132,
	2464, 20759, 17487, 10188, 15270, 14266, 25609, 58137,
	57931, 2205, 6443, 37431, 12405, 58845, 33285, 16573,
	14071, 5820, 16529, 58780, 31569, 52734, 18992, 50695,
	46732, 20912, 5076, 48345, 22472, 23041, 64294, 52141,
	22442, 392, 26740, 43057, 11860, 14356, 63434, 15374,
	14772, 28670, 41433, 1974, 54122, 17046, 50870, 58582,
	5398, 17662, 56622, 53433, 51651, 8826, 50675, 27415,
	59006, 31726, 3039, 15225, 1797, 30657, 62118, 31964,
	11409, 19519, 46289, 51026, 63766, 51506, 6721, 28612,
	43824, 40432, 28241, 27448, 45638, 22197, 9841, 39482,
	9863, 39609, 40744, 38597, 41001, 28616, 32806, 21219,
	8559, 63020, 56887, 1918, 19985, 9540, 10554, 43907,
	50615, 38633, 61885, 47235, 60236, 61683, 13384, 60276,
	39709, 37164, 11604, 48681, 49626, 35185, 43726, 49403,
	29356, 30785, 4575, 1193, 43617, 38640, 17416, 6671,
	7232, 27443, 26406, 41752, 6566, 25930, 62643, 18778,
	54032, 30217, 3010, 58389, 63320, 30362, 35000, 19530,
	13024, 51771, 54380, 9543, 4082, 11961, 11867, 45471,
	30275, 39318, 40920, 8938, 25475, 57521, 52508, 58089,
	24296, 24154, 27196, 31838, 56076, 47056, 45743, 14112,
	53271, 164,		/* * 65536**448 */
	 /* 10000**630 =  65536**157 *  */ 41216, 46406, 59322, 61369, 51512, 20872, 33344, 41848,
	43840, 47477, 17497, 55908, 2232, 55500, 37020, 51781,
	22444, 37436, 7404, 2929, 57789, 15841, 61447, 35446,
	61753, 33940, 20974, 40070, 32303, 24165, 35623, 37205,
	10896, 16123, 6081, 4131, 29524, 1872, 8494, 27926,
	37845, 23806, 62637, 1365, 6521, 39715, 46011, 60077,
	9346, 51026, 41457, 9861, 44621, 22494, 64632, 15645,
	7424, 61517, 4626, 23178, 34013, 8518, 49315, 57860,
	32895, 17307, 57060, 28216, 27297, 61081, 36199, 59774,
	44595, 28382, 55034, 12516, 60988, 3506, 50799, 38145,
	54391, 63230, 20695, 45368, 10226, 3270, 24994, 56899,
	31459, 18314, 32368, 51902, 33323, 63009, 59011, 29737,
	29075, 49025, 4282, 31052, 15197, 60533, 9381, 32019,
	50249, 61190, 24684, 34675, 46264, 42435, 53411, 31868,
	38459, 40070, 61396, 19036, 30012, 23474, 3616, 19739,
	9343, 27372, 23783, 53650, 37433, 59240, 38132, 41049,
	45152, 8725, 51544, 34525, 36550, 16360, 27941, 7440,
	35100, 54826, 64859, 13997, 4890, 53899, 54048, 35700,
	10798, 26647, 1271, 49433, 25744, 53858, 31178, 14919,
	937, 30111, 55552, 58717, 17286, 37081, 34938, 9745,
	24865, 45841, 34340, 43224, 22583, 5991, 64792, 16894,
	50876, 18240, 63281, 5032, 50942, 44113, 38789, 36691,
	51395, 8802, 13454, 56366, 32520, 61447, 35750, 63344,
	37142, 50639, 5722, 37943, 60442, 51591, 43337, 64200,
	64641, 57845, 46520, 36321, 44691, 5976, 53935, 32798,
	18551, 30652, 17368, 30219, 17859, 32537, 43934, 44612,
	43162, 55927, 7118, 44489, 276, 17010, 19651, 59717,
	37728, 13644, 63771, 16530, 51265, 23961, 51401, 39975,
	37696, 39126, 60849, 22425, 21035, 9611, 64833, 55092,
	17850, 19413, 53650, 61853, 22584, 14070, 18779, 41400,
	29164, 23227, 47530, 25123, 4816, 10016, 33069, 3061,
	50950, 15317, 22406, 5087, 51471, 51986, 21623, 53924,
	56665, 20549, 54909, 13520, 40440, 5926, 58434, 18,
	50925, 8063, 35498, 15845, 51871, 7543, 20521, 27848,
	48972, 24508, 61119, 46506, 34938, 10016, 61223, 2437,
	18604, 57378, 59677, 26266, 31802, 20692, 53429, 64574,
	20518, 2425, 41617, 57694, 62360, 47901, 142, 34172,
	5481, 48289, 53305, 12663, 37332, 46869, 144, 52762,
	35315, 13067, 41549, 63950, 10274, 26507, 13044, 60707,
	31640, 20218, 11020, 6092, 31125, 46895, 40706, 13301,
	33249, 14254, 13694, 14182, 44179, 19002, 10953, 42206,
	2912, 61112, 21006, 46700, 45041, 13788, 37984, 61123,
	2920, 53910, 22103, 46791, 35691, 26534, 59183, 6629,
	38284, 40141, 33801, 45081, 40582, 63304, 9780, 38978,
	37040, 33628, 42029, 7586, 6756, 27120, 50939, 17873,
	34198, 43080, 58421, 36335, 22204, 37477, 9,	/* * 65536**523 */
	 /* 10000**720 =  65536**180 *  */ 29441, 9221, 44176, 26692, 60846, 31847, 29090, 25339,
	35930, 20844, 8043, 17725, 25927, 13288, 32521, 8126,
	50775, 44966, 15361, 9307, 64745, 7612, 24764, 29669,
	13555, 50864, 44391, 48083, 58573, 42556, 61204, 64477,
	11986, 42790, 52174, 42952, 53031, 54270, 20286, 8768,
	22341, 61349, 63774, 14080, 60374, 62747, 7402, 25223,
	28052, 46846, 46980, 8609, 9078, 33609, 53505, 34930,
	32968, 30589, 32788, 43651, 14971, 17775, 57203, 12298,
	62205, 17626, 9672, 31691, 63216, 49734, 40541, 6402,
	22005, 30587, 13054, 10329, 31904, 3172, 13622, 45858,
	46301, 10464, 15293, 17945, 17536, 61782, 57231, 38296,
	45404, 38204, 18123, 28934, 2342, 37881, 10854, 32095,
	4987, 56042, 25984, 9019, 45858, 6236, 46121, 45379,
	18810, 26175, 50282, 21223, 50027, 12893, 65320, 5925,
	50383, 43903, 42003, 15205, 5093, 41037, 60929, 42849,
	11522, 14113, 15252, 27792, 31752, 2747, 32751, 24967,
	11946, 51822, 33949, 61093, 54336, 61377, 44704, 51071,
	52508, 36736, 35998, 31965, 32400, 38483, 30039, 39655,
	12271, 53350, 3018, 27056, 52286, 4241, 2469, 12591,
	57208, 5539, 59538, 57279, 51412, 4367, 51194, 63224,
	42879, 57531, 5593, 36875, 3222, 36878, 8834, 58841,
	50736, 22072, 2883, 64310, 30818, 10755, 8048, 27469,
	32380, 287, 25978, 8932, 22638, 42123, 54687, 38020,
	54046, 34026, 2495, 20815, 13295, 60567, 18045, 38166,
	27324, 23540, 61061, 18019, 41556, 19312, 21205, 18355,
	4165, 36131, 36155, 63114, 1178, 4578, 57389, 10680,
	64688, 3879, 48569, 34056, 47861, 11495, 20055, 59999,
	8785, 16819, 48092, 5275, 39435, 62427, 11880, 55745,
	40370, 22261, 23222, 37349, 25595, 44199, 47928, 8827,
	33878, 10592, 29893, 58929, 55559, 62526, 3540, 28795,
	45772, 44601, 30551, 23900, 47810, 48207, 38046, 45993,
	54951, 42424, 37459, 26441, 64051, 39949, 15873, 48249,
	18153, 33377, 31324, 46745, 57720, 38661, 25484, 2856,
	27871, 57992, 32210, 39775, 27415, 49689, 12774, 39695,
	54026, 8851, 64076, 45346, 30440, 4954, 43827, 59588,
	26458, 35245, 6276, 9866, 19606, 17051, 10101, 42987,
	13096, 65041, 11754, 60180, 40909, 8317, 52670, 33992,
	60144, 23815, 64633, 10803, 13953, 41749, 52611, 55862,
	19561, 29527, 2011, 60830, 46093, 11917, 17017, 8948,
	6256, 43842, 30373, 60280, 24957, 58414, 59183, 55358,
	58102, 26713, 8531, 36657, 63486, 13580, 4866, 34860,
	64464, 17306, 43397, 37920, 15862, 59273, 3367, 51941,
	23330, 41718, 46765, 17746, 54707, 19066, 17076, 30414,
	2252, 63321, 11865, 11828, 30996, 63021, 12032, 19445,
	18188, 27359, 23050, 15348, 3491, 46691, 51491, 36848,
	33160, 12581, 63320, 56725, 1821, 43960, 39997, 18740,
	48805, 41842, 24120, 15890, 54968, 55258, 61757, 32921,
	9505, 55385, 18647, 48173, 26532, 22866, 2391, 60301,
	4042, 25640, 2549, 20478, 51618, 41943, 15933, 49899,
	41880, 50809, 7605, 15053, 44692, 26691, 4504, 56850,
	53475, 704, 51873, 61228, 29198, 50857, 6149, 26788,
	1987, 17697, 41116, 7369, 23359, 53572, 17078, 54242,
	56763, 36431,		/* * 65536**597 */
	 /* 10000**810 =  65536**202 *  */ 24832, 34883, 19140, 51974, 19534, 493, 52319, 13085,
	44094, 53939, 13943, 21197, 17741, 12809, 17083, 47879,
	44152, 35922, 40786, 5096, 8680, 9278, 44616, 38504,
	36424, 51297, 47600, 4593, 4526, 149, 59298, 44171,
	44964, 25078, 37864, 13646, 63055, 58238, 37926, 35586,
	10600, 3464, 53122, 28369, 17593, 3852, 29481, 59844,
	27408, 27200, 56105, 64110, 48332, 50180, 19869, 47629,
	55510, 63058, 63565, 15060, 30626, 63856, 56518, 46308,
	39745, 24691, 36420, 55961, 36063, 63197, 60888, 53216,
	16582, 21061, 31362, 31969, 40126, 63351, 10808, 40164,
	30133, 43848, 10633, 38149, 14270, 53620, 35996, 7377,
	31064, 14168, 27656, 8304, 9433, 48523, 18453, 35684,
	59897, 45916, 24972, 15325, 2090, 26144, 25610, 31629,
	32660, 38294, 23250, 17832, 48733, 50586, 41084, 47429,
	31712, 34017, 19793, 62777, 45378, 44102, 8716, 29657,
	11066, 8490, 21653, 65497, 54560, 34995, 45742, 29639,
	47537, 31847, 50867, 52761, 21881, 37741, 50563, 52577,
	19856, 51512, 7692, 58548, 21610, 63516, 13279, 10470,
	25956, 22794, 15559, 37617, 47777, 14198, 59911, 38144,
	48165, 43003, 1866, 15531, 29396, 63328, 5477, 46307,
	7420, 63290, 9773, 16965, 24790, 59750, 55367, 43061,
	40717, 39703, 31857, 13914, 10833, 9318, 46436, 41858,
	33725, 2693, 48237, 15973, 39351, 1385, 60479, 8159,
	36758, 43662, 65499, 30448, 36485, 14023, 16129, 56629,
	11037, 14727, 56695, 61224, 10018, 61924, 17039, 58813,
	51177, 7002, 14025, 34593, 12170, 14808, 16590, 42794,
	54486, 23047, 40628, 57635, 49464, 47344, 56582, 36349,
	43317, 39710, 36166, 49702, 43150, 50620, 52026, 12306,
	14900, 24719, 32561, 23469, 56363, 58169, 29717, 62860,
	5914, 30326, 36935, 6904, 10575, 39528, 43903, 45125,
	45571, 20883, 10642, 49940, 49906, 46725, 33540, 15427,
	54802, 23586, 6422, 34110, 28513, 24672, 55236, 59300,
	18103, 8071, 343, 46748, 44955, 44719, 46329, 45518,
	64515, 53685, 49458, 57239, 26923, 63817, 49998, 82,
	48162, 49280, 36045, 52738, 55278, 52109, 36659, 28664,
	54266, 36879, 7837, 33525, 38888, 43635, 3373, 31635,
	39148, 20248, 61282, 48866, 43029, 19598, 35185, 15499,
	29972, 51650, 46352, 17452, 27329, 41299, 61120, 41483,
	63249, 41810, 38435, 63667, 39939, 54741, 6587, 14314,
	2969, 13087, 5872, 55217, 56115, 62553, 44160, 49781,
	42336, 33771, 30218, 31267, 4033, 42958, 21612, 41303,
	34647, 1810, 28901, 41550, 40209, 11769, 4586, 22182,
	26502, 5719, 30640, 11452, 12437, 21544, 2884, 63001,
	2124, 35767, 51047, 27970, 13456, 60413, 51818, 58535,
	47850, 36522, 31614, 53268, 52691, 2465, 9577, 57821,
	34723, 14832, 5857, 29536, 54171, 49780, 47615, 47261,
	30128, 62107, 57931, 31222, 38520, 25994, 3823, 15723,
	16547, 17305, 49713, 43099, 51610, 41171, 23658, 34248,
	13535, 21991, 43596, 26442, 58160, 23695, 3544, 34778,
	18047, 45877, 18286, 24355, 51158, 26871, 58388, 26582,
	47810, 41235, 7058, 10487, 40836, 51818, 20367, 52775,
	5736, 33296, 60350, 61028, 33129, 22124, 2553, 40846,
	49426, 30198, 41206, 31906, 2268, 23375, 26363, 25951,
	25327, 21358, 4872, 53366, 58360, 57573, 39684, 22204,
	14446, 39744, 2602, 5841, 58903, 33209, 16767, 10211,
	61495, 8426, 33859, 133, 24228, 7746, 3317, 39266,
	40762, 27964, 33156, 57057, 37827, 18835, 48966, 45870,
	59270, 1291, 59568, 53631, 7193, 56246, 21395, 738,
	4375, 22741, 15183, 23729, 51074, 56262, 2115,	/* * 65536**672 */
	 /* 10000**900 =  65536**225 *  */ 14273, 7163, 46567, 51827, 50089, 10023, 55949, 245,
	1159, 17037, 51278, 44226, 51648, 35729, 25509, 4403,
	15277, 58952, 2800, 32557, 39271, 9423, 24984, 39140,
	57089, 23151, 3062, 50830, 59291, 867, 53101, 7095,
	19611, 35795, 41060, 9674, 47969, 12545, 38874, 29165,
	11512, 41264, 63581, 29168, 53103, 21505, 38999, 33701,
	54139, 9676, 37916, 53588, 50017, 6515, 42130, 2532,
	36284, 38864, 44500, 4466, 55531, 50755, 15508, 146,
	28502, 38791, 21688, 26877, 52133, 54811, 29308, 24528,
	20734, 17408, 49222, 26459, 17409, 64821, 4200, 39238,
	64979, 29921, 33627, 35459, 36916, 51567, 33008, 1628,
	6279, 54380, 30133, 5936, 17139, 52719, 46819, 42853,
	41752, 31544, 1462, 57857, 44269, 5290, 12763, 55500,
	39832, 27225, 48368, 61922, 40176, 40270, 5222, 2985,
	26859, 21907, 20962, 63398, 54831, 61348, 11462, 26890,
	43826, 50193, 60034, 50174, 47495, 52289, 11971, 42857,
	8385, 26684, 23657, 10379, 54996, 40463, 25724, 21824,
	57970, 19757, 19307, 26592, 34085, 58605, 6778, 23721,
	51260, 28842, 5296, 13158, 47821, 847, 16832, 60766,
	40427, 3841, 28863, 20200, 1138, 3729, 22912, 46234,
	33780, 41281, 39777, 35382, 6550, 55549, 44803, 54984,
	41452, 20025, 49044, 15289, 39110, 28891, 12771, 9774,
	12295, 20992, 36634, 40705, 61898, 9178, 25519, 22203,
	50236, 10613, 5567, 27529, 13389, 798, 40083, 55933,
	29668, 42166, 48813, 57826, 5693, 61199, 24917, 35398,
	55081, 28044, 10934, 490, 44922, 45359, 60589, 21808,
	6223, 60886, 55947, 15636, 18202, 12652, 47001, 33715,
	1784, 10522, 3250, 23010, 53423, 13029, 14613, 14582,
	65496, 51185, 8470, 26681, 63330, 65425, 32413, 51168,
	32060, 54007, 60139, 17653, 53407, 8189, 34606, 61688,
	13850, 35471, 27651, 37005, 61499, 55526, 56224, 41600,
	60040, 857, 42303, 38156, 38085, 44751, 16609, 54544,
	38471, 14234, 8060, 31105, 63558, 7269, 31069, 36939,
	42433, 13862, 40368, 37119, 25856, 65017, 20549, 36357,
	64397, 17712, 38575, 49805, 59582, 22005, 40440, 19428,
	51467, 17010, 36430, 58855, 2452, 2695, 44580, 46065,
	30873, 60279, 54935, 34216, 22695, 58545, 48440, 15018,
	27887, 23637, 63051, 4534, 13378, 51603, 40257, 52604,
	691, 51699, 15786, 21724, 13278, 55833, 44434, 30861,
	51287, 5897, 10147, 58856, 38101, 14294, 17815, 47872,
	28393, 15890, 20928, 62986, 42962, 56890, 979, 15681,
	47673, 38922, 36092, 57686, 64599, 33633, 28338, 34918,
	57465, 49865, 18528, 54552, 57036, 7276, 11198, 57630,
	22789, 16017, 10059, 23237, 21681, 41524, 46643, 24961,
	44147, 48940, 62394, 7143, 9385, 11046, 65044, 57878,
	57160, 47316, 45445, 2750, 58598, 9603, 42454, 30694,
	52059, 29206, 18204, 40173, 25648, 6014, 61497, 56963,
	26048, 57723, 8838, 62072, 11570, 12733, 36026, 31434,
	3840, 46987, 33053, 832, 52289, 60589, 40187, 10691,
	45021, 57479, 35352, 44144, 11407, 18748, 20537, 37568,
	37950, 36743, 62914, 48316, 55419, 772, 17111, 43564,
	6290, 40888, 38291, 40921, 20680, 48207, 42217, 38503,
	730, 2822, 22255, 43137, 41848, 58326, 23670, 15109,
	5304, 37155, 44928, 50110, 44814, 1337, 31179, 31519,
	53369, 16421, 43531, 23933, 45501, 33542, 14548, 41770,
	5329, 24587, 36163, 13284, 26154, 26979, 58480, 55123,
	27153, 35641, 19702, 30180, 24988, 59627, 49160, 35901,
	53053, 26775, 49062, 44985, 39819, 25504, 32870, 50542,
	63631, 62927, 32094, 334, 21162, 62179, 40136, 13124,
	27741, 9876, 3165, 29681, 27682, 30484, 38671, 4766,
	48626, 12961, 26759, 53270, 6514, 16672, 17944, 11173,
	54309, 18987, 19908, 62166, 55133, 64931, 34429, 19375,
	40200, 22618, 12904, 18863, 56035, 50621, 8647, 4914,
	56531, 52460, 17908, 38068, 9533, 24082, 12137, 56181,
	52161, 1403, 43630, 37617, 47129, 31272, 12184, 10307,
	41534, 57868, 122,	/* * 65536**747 */
	 /* 10000**990 =  65536**247 *  */ 8448, 11216, 5465, 5252, 13691, 62777, 24660, 63602,
	11742, 63994, 26533, 6198, 64453, 64762, 15022, 11560,
	57999, 1346, 43073, 12670, 29299, 41692, 40405, 12003,
	9686, 58196, 51539, 5057, 17555, 47938, 13325, 47771,
	18543, 44041, 7371, 42873, 64950, 38189, 47026, 40574,
	537, 46950, 53263, 23417, 20499, 12622, 63037, 21674,
	48336, 5244, 44671, 30812, 22163, 9040, 9255, 65488,
	41576, 18286, 31279, 38058, 36504, 1777, 41531, 32231,
	45969, 61787, 5163, 19977, 41699, 14970, 29550, 50366,
	57333, 24146, 56484, 10557, 6318, 5085, 19553, 12503,
	43553, 41906, 1510, 18184, 26688, 55056, 6458, 8707,
	11358, 14113, 9658, 9531, 38165, 19586, 46404, 23885,
	31549, 25819, 31379, 53700, 15570, 44506, 9573, 8610,
	37474, 23712, 41571, 42241, 62359, 3173, 48388, 35115,
	13886, 29265, 13202, 39660, 17261, 57603, 53509, 30252,
	3049, 31534, 42061, 10178, 10072, 42133, 19531, 5512,
	22011, 20317, 60832, 45754, 23861, 8803, 8024, 9300,
	8189, 56661, 19449, 40072, 10395, 51816, 45325, 21642,
	40617, 4397, 40831, 53612, 3720, 26816, 21980, 49486,
	19775, 28607, 30907, 20380, 59273, 64398, 56231, 48013,
	32960, 6029, 14723, 17302, 7319, 55312, 16409, 27905,
	10307, 20664, 26193, 33375, 29613, 47129, 6833, 57131,
	38357, 56322, 30287, 21069, 29634, 17545, 54322, 46630,
	59448, 27103, 63182, 30298, 48945, 39899, 34349, 14202,
	9978, 9256, 11625, 18019, 44700, 31588, 9709, 17067,
	2480, 10551, 52262, 59626, 5719, 22611, 2829, 47524,
	4751, 61315, 1190, 28590, 40756, 50116, 968, 39757,
	59488, 152, 10598, 9539, 42089, 34440, 21330, 35753,
	57353, 65382, 61232, 47818, 19428, 4893, 4284, 12072,
	10649, 29127, 34573, 16717, 42170, 60771, 8829, 1181,
	54700, 28796, 64820, 9014, 65265, 31595, 45949, 58747,
	15945, 20377, 21475, 59780, 50806, 49411, 51255, 36905,
	12430, 20303, 34553, 47326, 21884, 63330, 16073, 51001,
	5581, 9735, 30854, 43394, 26578, 29424, 49994, 36100,
	23634, 20809, 64072, 61243, 52060, 29913, 33631, 16296,
	32437, 6349, 52749, 15700, 39620, 46399, 24489, 6483,
	17702, 4372, 49283, 33988, 57337, 23019, 50643, 4364,
	1804, 2490, 53301, 55512, 15361, 57965, 43339, 53049,
	20703, 30461, 65186, 1853, 40917, 13989, 32509, 65014,
	57041, 36741, 42577, 10428, 33201, 2351, 43760, 450,
	18475, 4148, 40810, 1574, 45201, 54811, 9696, 18240,
	4281, 814, 28703, 27646, 50507, 42975, 30223, 13460,
	10852, 61914, 38691, 12727, 45042, 53605, 54025, 59128,
	14779, 11283, 46064, 12505, 43685, 23386, 14520, 29358,
	4627, 44117, 55001, 34108, 6241, 49319, 18776, 49487,
	42437, 35867, 3921, 48818, 61712, 3800, 7816, 56515,
	1495, 29296, 8713, 35840, 43635, 26808, 13132, 16233,
	2497, 3233, 44848, 48144, 53724, 1894, 2759, 63597,
	29964, 63225, 43350, 56438, 29890, 64077, 2120, 45261,
	4371, 14786, 41470, 17466, 55157, 32471, 62494, 38002,
	23407, 2940, 57644, 42903, 4020, 53587, 3318, 47999,
	5161, 32029, 30737, 54071, 2557, 50689, 53234, 36175,
	40961, 32172, 3909, 19016, 61625, 34111, 14144, 24936,
	16896, 62818, 12372, 59457, 1887, 645, 63537, 17392,
	1114, 50039, 2686, 34251, 9674, 21696, 13228, 40036,
	54714, 47286, 2182, 22144, 44868, 31758, 23861, 11525,
	21730, 3665, 26632, 58312, 32064, 33523, 30267, 40799,
	36724, 54784, 38117, 5204, 9016, 64205, 17027, 48311,
	33725, 42192, 59162, 43755, 36462, 12221, 8743, 63827,
	16782, 28240, 33067, 53442, 64633, 16828, 53744, 17998,
	37175, 47644, 57936, 1832, 6528, 14825, 46409, 1977,
	17054, 36191, 14793, 17786, 41401, 29332, 13834, 6240,
	59939, 25580, 16725, 50035, 43728, 33886, 35213, 22229,
	24861, 38719, 3055, 3061, 58000, 6125, 41860, 31265,
	49348, 46603, 9764, 35877, 30160, 49410, 7100, 47807,
	10718, 5537, 45289, 36196, 32331, 64349, 61700, 5981,
	6649, 6342, 2822, 52677, 22254, 39294, 58122, 35925,
	22310, 1603, 14936, 42974, 12624, 31289, 1266, 10913,
	8274, 37729, 49689, 38262, 24455, 55587, 6913, 50313,
	30337, 55817, 64980, 41358, 51940, 10242, 19280, 13531,
	23954, 15839, 46833, 1614, 46746, 42892, 58742, 44714,
	44748, 23250, 2673, 2661, 56547, 21341, 8958, 7,
	/* * 65536**822 */
	 /* 10000**1080 =  65536**270 *  */ 35969, 65527, 20338, 12242, 57030, 27483, 20925, 34866,
	37995, 62473, 1330, 16007, 26899, 34993, 53763, 13986,
	26884, 65400, 55901, 12138, 53839, 8515, 45230, 37130,
	30737, 40433, 16575, 47085, 45034, 5302, 28335, 57005,
	22440, 10619, 59258, 6861, 41500, 62167, 57844, 4133,
	35839, 22712, 27192, 42174, 46754, 26624, 61306, 60061,
	12433, 10121, 6313, 37820, 6007, 61184, 13391, 25383,
	49031, 38668, 43505, 15089, 64994, 4879, 11070, 22631,
	6207, 65503, 28118, 36679, 35922, 20644, 38606, 32825,
	9233, 56150, 1583, 51096, 45352, 60012, 2115, 41832,
	60619, 29484, 25747, 59731, 50215, 33401, 9777, 33356,
	4545, 41181, 60374, 15690, 35095, 63846, 4140, 8324,
	13904, 48649, 35456, 8116, 42157, 50206, 40063, 45872,
	7599, 18962, 48417, 39625, 19385, 7183, 39285, 25477,
	31918, 34075, 2973, 20304, 3869, 40907, 6283, 53285,
	21565, 54800, 3099, 63351, 19428, 2283, 59341, 9996,
	48252, 48814, 54345, 22150, 21613, 40202, 43876, 38944,
	64604, 6563, 30994, 2553, 44916, 42593, 29298, 37038,
	45249, 11025, 48205, 9383, 16918, 37853, 32410, 31440,
	29243, 60387, 34792, 54085, 7280, 64745, 6242, 42678,
	55653, 7950, 56873, 4902, 52836, 43897, 639, 9280,
	60008, 46619, 32011, 25081, 52076, 28983, 47306, 61838,
	19535, 24464, 41653, 25843, 43561, 48725, 41247, 44966,
	53302, 43814, 7367, 9458, 13869, 31476, 12767, 55594,
	30824, 63935, 9696, 6667, 31999, 50893, 55234, 42913,
	19496, 12880, 54616, 37680, 47181, 15774, 42091, 48571,
	41189, 56906, 44069, 19494, 61417, 47627, 49626, 52385,
	19434, 65511, 16820, 2643, 49943, 35149, 43140, 3439,
	65423, 7246, 36543, 9896, 3582, 10149, 23496, 35541,
	2582, 11269, 42535, 44767, 50152, 61980, 39561, 56609,
	37061, 8334, 45130, 14096, 40278, 15114, 49471, 56808,
	15632, 54413, 64099, 46435, 36467, 53419, 10772, 11521,
	43612, 64772, 20299, 52506, 17748, 39569, 60365, 21251,
	34284, 10636, 44072, 26904, 45857, 43639, 24318, 61907,
	7878, 33513, 15616, 62983, 46136, 7313, 21547, 37227,
	46503, 24860, 48549, 21798, 22342, 14131, 22033, 52279,
	61857, 16311, 50989, 36484, 56525, 24361, 51738, 39047,
	44213, 30533, 50080, 52323, 16437, 46793, 4846, 62968,
	35862, 43889, 2791, 18111, 16134, 36985, 43534, 1666,
	2970, 12365, 38432, 6777, 44929, 12920, 34750, 5142,
	239, 43658, 42039, 14776, 35110, 9559, 45088, 53364,
	38362, 42460, 43246, 8437, 16032, 36097, 55193, 24167,
	59792, 8093, 36288, 38140, 6056, 32401, 1144, 16797,
	24474, 23434, 37962, 30049, 52725, 56110, 58340, 36802,
	24828, 48521, 19413, 25682, 45914, 55, 12190, 42713,
	60387, 16852, 63593, 27607, 55260, 27802, 54479, 29187,
	8748, 34352, 5241, 45524, 60050, 405, 46704, 41046,
	26477, 45891, 60022, 51904, 33611, 44204, 30580, 60004,
	18775, 32340, 28622, 45538, 49045, 63367, 23219, 51168,
	42982, 41136, 63410, 31213, 43173, 37726, 19222, 29370,
	44402, 19495, 23168, 12370, 17208, 15786, 47477, 27836,
	19826, 28477, 5719, 24067, 5087, 35305, 16911, 20735,
	54257, 4741, 23273, 14332, 37147, 18175, 45630, 40503,
	24950, 18113, 9135, 9501, 21821, 12582, 11139, 62854,
	464, 12572, 57428, 13531, 28477, 18522, 10541, 26505,
	47692, 53471, 25747, 53782, 13544, 8182, 45875, 48127,
	54948, 29352, 17720, 43079, 19041, 62187, 64838, 33792,
	47137, 49136, 38397, 48247, 2603, 30425, 51397, 24949,
	30697, 22370, 53700, 21914, 65294, 30144, 34466, 24897,
	9592, 158, 24612, 13665, 38859, 58457, 23999, 40845,
	19152, 14012, 21212, 22737, 36399, 8307, 28748, 2060,
	7589, 17249, 362, 41692, 8612, 51819, 58869, 4455,
	53139, 21737, 37335, 5624, 59010, 36579, 36223, 36932,
	17544, 4121, 41032, 28204, 45035, 63366, 26317, 7171,
	33739, 4399, 61606, 57877, 21760, 61384, 19819, 2133,
	21109, 34777, 25708, 22613, 46696, 44052, 51710, 23536,
	17871, 32203, 8966, 41282, 22625, 20237, 16347, 22565,
	3942, 25598, 47178, 3759, 63556, 22918, 62263, 51106,
	11270, 3902, 54133, 5238, 58847, 3357, 60086, 28063,
	40717, 9011, 38024, 1066, 18471, 2339, 9331, 40412,
	1959, 22572, 45730, 53351, 36637, 31458, 11444, 30555,
	52969, 30098, 1350, 49651, 16400, 55522, 61620, 8113,
	3029, 39240, 39252, 23947, 60404, 24211, 16221, 11621,
	54989, 62562, 8457, 57734, 61481, 33303, 53947, 23929,
	10226, 29099, 38390, 60716, 10264, 58142, 33253, 35683,
	32668, 52365, 37839, 21035, 30530, 65294, 20410, 33214,
	33927, 59639, 51510, 55225, 60899, 32713, 55680, 22427,
	18934, 50901, 55499, 18342, 34273, 48413, 15059, 1856,
	23957, 18148, 27163,	/* * 65536**896 */
	 /* 10000**1170 =  65536**292 *  */ 57600, 19436, 30159, 40265, 63827, 34677, 48744, 35442,
	44746, 27137, 10696, 50059, 49688, 55567, 48021, 27347,
	12423, 52843, 52579, 6439, 46139, 58036, 63895, 50521,
	2639, 35617, 15101, 35359, 52213, 33998, 64533, 60211,
	25245, 54062, 27178, 8474, 26829, 10437, 19695, 1050,
	25311, 10258, 7964, 35543, 40907, 25898, 18812, 4362,
	32146, 61326, 31532, 50972, 12327, 46814, 65349, 13080,
	49055, 60452, 4498, 43691, 45804, 4764, 48417, 10341,
	49321, 56403, 59480, 9205, 62814, 39328, 32280, 35768,
	7313, 28486, 27160, 31200, 26934, 46241, 57455, 24222,
	15734, 51453, 37567, 57333, 38064, 48913, 61530, 26786,
	43961, 12101, 40131, 46639, 11918, 42601, 32832, 61279,
	40551, 44553, 26324, 59251, 53986, 50472, 36564, 36026,
	57448, 33095, 56484, 52713, 37122, 10150, 7602, 12809,
	1704, 30364, 65439, 11312, 44484, 9736, 64030, 3053,
	58942, 31227, 6957, 3662, 46800, 22475, 19542, 51939,
	50569, 63911, 48766, 59192, 23248, 58323, 8099, 33672,
	20857, 60081, 54343, 36309, 14110, 31124, 35564, 44710,
	59463, 54102, 32666, 52080, 35270, 27597, 2521, 7800,
	15502, 15199, 31684, 15860, 43249, 35670, 23980, 26978,
	1778, 59009, 47962, 37281, 9450, 60769, 8063, 64424,
	36596, 53977, 5301, 15655, 13812, 53130, 42429, 16208,
	12103, 19916, 37755, 53157, 63374, 6767, 46635, 50715,
	33492, 18514, 53655, 37278, 6138, 29099, 17136, 6795,
	51046, 43083, 31957, 8875, 46491, 32531, 18588, 6232,
	53334, 14070, 5211, 29319, 34016, 52582, 9454, 15404,
	39941, 14707, 54612, 25892, 17481, 984, 48580, 31799,
	30800, 16827, 8558, 16278, 65451, 40259, 46308, 50697,
	39993, 52045, 56233, 47481, 31161, 388, 53391, 37511,
	60369, 8391, 34809, 36357, 458, 53784, 44568, 33556,
	13954, 49150, 5041, 54584, 60304, 21022, 41788, 36261,
	41549, 65179, 40541, 51127, 9883, 21359, 32861, 22699,
	14405, 39846, 25772, 63294, 16861, 39665, 16819, 32781,
	16146, 20361, 49368, 48805, 11794, 18538, 59056, 48282,
	34943, 15871, 28426, 53226, 11855, 45462, 30124, 60860,
	28055, 9267, 43021, 46094, 42638, 38870, 1321, 55408,
	37034, 45963, 41870, 38539, 60271, 41848, 30287, 44532,
	15544, 26752, 39819, 41330, 28662, 32340, 35342, 45264,
	53173, 39672, 13627, 16487, 47378, 56815, 64338, 38261,
	55537, 33663, 9483, 51506, 57269, 63848, 63177, 4795,
	39218, 41025, 28259, 47624, 23486, 30665, 7272, 2830,
	39617, 10425, 47029, 61323, 62933, 44477, 30007, 43020,
	52077, 30725, 38435, 57638, 16462, 27056, 64988, 16566,
	50537, 20493, 9906, 21492, 43895, 374, 44515, 56769,
	8223, 48380, 40760, 14257, 39656, 34630, 41285, 15246,
	62411, 47824, 48336, 36913, 6976, 16512, 57714, 42313,
	13979, 48088, 60, 24912, 62211, 28151, 35752, 36701,
	50052, 24618, 59132, 20255, 12497, 59698, 29577, 51569,
	12798, 42198, 53790, 23570, 19875, 61970, 10800, 48176,
	24589, 6893, 31612, 57636, 10610, 30282, 22215, 44024,
	31263, 34518, 45043, 32436, 12262, 46765, 52624, 16321,
	4114, 59087, 54751, 49164, 37820, 64012, 27438, 25871,
	11204, 15290, 26961, 38400, 20759, 64316, 9621, 64020,
	46909, 20691, 52647, 33348, 11576, 17066, 14015, 49566,
	40538, 63664, 14944, 20687, 39074, 25856, 38268, 47873,
	30505, 1498, 37095, 13677, 9292, 30643, 49306, 2970,
	34675, 26586, 4470, 13882, 62018, 42647, 14650, 32179,
	31724, 63540, 6422, 45588, 48883, 16175, 17479, 7982,
	51335, 3705, 24447, 24326, 21497, 52371, 25062, 24894,
	15989, 3109, 50876, 27200, 8648, 32174, 20005, 8719,
	61318, 38490, 117, 58091, 45689, 24069, 39959, 30543,
	2616, 64752, 62632, 16639, 3681, 44725, 9996, 35120,
	41225, 47680, 31561, 303, 57460, 13392, 15823, 14403,
	48491, 10280, 30164, 63874, 53006, 38217, 29855, 29272,
	24594, 7725, 18809, 57474, 55413, 58819, 52259, 8574,
	28330, 5615, 47921, 11575, 1337, 37725, 18350, 20197,
	59722, 7403, 55547, 56424, 54478, 9683, 30498, 4876,
	11569, 8650, 7196, 1998, 22300, 6472, 53770, 18940,
	8345, 3191, 3892, 35925, 31490, 15746, 63659, 19136,
	40591, 38919, 7939, 18832, 4632, 51547, 58229, 27339,
	25497, 1691, 51106, 275, 61634, 48153, 48098, 6661,
	63928, 58037, 26688, 5855, 11436, 61191, 44893, 42901,
	60804, 42379, 26937, 11543, 23770, 16000, 49890, 22438,
	57970, 3854, 64957, 3519, 40127, 20002, 45185, 39487,
	35298, 55263, 46570, 8685, 55848, 35560, 19389, 27707,
	13058, 28900, 15944, 7688, 37021, 39815, 30190, 44862,
	23598, 35229, 62820, 2996, 20461, 46976, 9001, 27879,
	48268, 46227, 49321, 49454, 63850, 61735, 54794, 42907,
	23571, 26334, 53654, 65360, 25489, 6468, 53678, 42675,
	52954, 59402, 4235, 63352, 24939, 48637, 61250, 26806,
	49629, 9768, 42381, 54045, 9937, 12168, 37664, 4615,
	55658, 1123, 65351, 60196, 45320, 56318, 30654, 20203,
	33201, 41697, 44590, 23892, 65277, 21327, 25805, 61616,
	58532, 8858, 28723, 13551, 44996, 22985, 48164, 17401,
	48762, 63463, 10663, 40820, 44187, 7691, 37052, 1577,
	/* * 65536**971 */
0};				/* end powers of 10000 in base 65536 */

unsigned short  _start_big_powers_ten[] = {
	0, 1, 54, 159, 317, 526, 788, 1102,
	1469, 1887, 2358, 2881, 3457, 4084, 4764,
0};				/* end _start_big_powers_ten */

unsigned short  _leading_zeros_big_powers_ten[] = {
	0, 22, 45, 67, 90, 112, 135, 157,
	180, 202, 225, 247, 270, 292,
0};				/* end _leading_zeros_big_powers_ten */

unsigned short  _max_big_powers_two = 1050;
unsigned short  _big_powers_two[] = {1,	/* begin powers of 65536 in
						 * base 10000 */
	 /* 65536**70 =  */ 4576, 5330, 2659, 2634, 2700, 241, 736, 6118,
	2918, 4420, 4263, 834, 7879, 7750, 4507, 3089,
	9485, 9709, 7384, 3707, 3230, 3352, 7721, 5033,
	2406, 9107, 3228, 6941, 8819, 1325, 5084, 9353,
	9449, 2435, 6704, 9445, 4261, 3162, 5528, 9548,
	4853, 5551, 7153, 8634, 6800, 2062, 51, 2591,
	4400, 2943, 1099, 5223, 667, 7222, 3974, 9347,
	6550, 4000, 3007, 556, 1451, 904, 8812, 7639,
	1900, 4787, 3415, 4511, 6120, 1037, 2997, 97,
	403, 7164, 4093, 5216, 3246, 5134, 8480, 6291,
	8881, 3964, 9238, 2427, 14,	/* * 10000**84 */
	 /* 65536**140 =  */ 9776, 2253, 8946, 6582, 4366, 1230, 5988, 5994,
	4986, 2332, 3133, 9676, 4549, 5629, 4568, 9179,
	3036, 9197, 7169, 3119, 9828, 5638, 3796, 4617,
	6421, 5990, 9499, 523, 5203, 2152, 7290, 6879,
	9813, 4441, 5925, 798, 7236, 4019, 6307, 8398,
	157, 2516, 6143, 8646, 7492, 9583, 9938, 5152,
	6847, 8006, 683, 244, 8006, 1196, 3758, 9532,
	452, 401, 5992, 7450, 1493, 753, 9827, 1126,
	2835, 5738, 7741, 3443, 881, 2236, 1741, 4233,
	5279, 3671, 2940, 5294, 7898, 9852, 7504, 8508,
	3953, 2527, 3546, 2712, 2847, 3048, 7420, 3799,
	6771, 8202, 4354, 7186, 8190, 4570, 6440, 5511,
	8549, 5153, 5490, 7918, 620, 5243, 5543, 3873,
	6356, 9078, 5386, 1591, 7111, 4159, 2320, 8196,
	6569, 6064, 290, 9978, 187, 8976, 8722, 4655,
	482, 8111, 4070, 76, 2883, 9619, 7217, 7027,
	5806, 3289, 7545, 7242, 8353, 2644, 8452, 1680,
	1123, 8161, 4848, 8635, 987, 5726, 9071, 3094,
	2436, 6472, 1303, 2224, 7305, 1464, 2855, 9906,
	1460, 1230, 6481, 9106, 631, 3182, 966, 9732,
	3988, 7802, 5403, 4445, 2222, 2728, 3489, 8571,
	202,			/* * 10000**168 */
	 /* 65536**210 =  */ 4976, 281, 6012, 17, 8847, 4796, 3320, 9840,
	359, 4031, 4266, 8224, 5040, 9010, 6606, 8362,
	3870, 2803, 1299, 2790, 5573, 8496, 7425, 3329,
	7000, 497, 2926, 2886, 5811, 7267, 4596, 9031,
	6264, 3836, 4739, 2863, 3432, 4432, 9069, 2431,
	2863, 4311, 2750, 4609, 1868, 9838, 8459, 363,
	1809, 2581, 5504, 2024, 6298, 5674, 9180, 4725,
	8486, 7668, 2709, 289, 3360, 275, 2585, 2205,
	4105, 2770, 7940, 4706, 8653, 4347, 7154, 3676,
	6577, 340, 6463, 2121, 2672, 6305, 8022, 7840,
	5602, 9571, 4312, 3466, 8020, 1916, 4070, 2988,
	3457, 6416, 9812, 2174, 8930, 9173, 6076, 8312,
	857, 1096, 1180, 620, 4859, 152, 1092, 7491,
	4745, 3889, 3900, 2599, 4401, 3692, 4364, 2736,
	4341, 1761, 6723, 5419, 7347, 3190, 5989, 9396,
	3021, 918, 8083, 7208, 5461, 1098, 6917, 8071,
	5616, 7722, 7108, 9396, 2863, 1362, 9097, 9696,
	5896, 164, 8909, 555, 434, 8445, 4953, 6921,
	2368, 285, 1641, 6713, 6744, 9989, 6930, 9850,
	2475, 71, 4925, 5299, 4396, 8984, 4026, 8373,
	1527, 940, 5824, 5337, 6969, 4236, 2973, 2267,
	2558, 6780, 186, 2173, 5244, 6671, 3833, 9623,
	4375, 6327, 6339, 7965, 6106, 2682, 9003, 9739,
	1314, 50, 4056, 4385, 7946, 1430, 6097, 9714,
	449, 6659, 5844, 1707, 5755, 2108, 2981, 3824,
	2297, 8807, 4920, 5469, 831, 2922, 9193, 2194,
	8297, 6119, 2088, 3045, 6641, 4977, 2769, 7282,
	4848, 6251, 1477, 1725, 9884, 3400, 123, 4489,
	8747, 9422, 2934, 2294, 9954, 3692, 8377, 1570,
	4011, 7220, 3419, 4810, 5449, 2242, 1, 507,
	7969, 5364, 7835, 8911, 8206, 8810, 1515, 9401,
	4940, 3087, 5588, 2520, 2889,	/* * 10000**252 */
	 /* 65536**280 =  */ 176, 213, 2607, 9939, 341, 6807, 5102, 2207,
	8576, 9910, 5541, 1756, 3100, 5881, 2766, 1754,
	7165, 678, 8260, 2609, 5249, 4119, 911, 2853,
	5944, 1955, 7766, 4398, 7425, 6034, 2902, 1670,
	5261, 6752, 8696, 8901, 723, 2061, 1185, 4361,
	1220, 6295, 9342, 3745, 2770, 2245, 9517, 8616,
	519, 326, 4902, 2510, 240, 2817, 6116, 7267,
	5696, 5673, 4758, 400, 7924, 2433, 2768, 7115,
	9889, 8056, 4872, 3379, 6347, 188, 2900, 3628,
	718, 2601, 569, 4493, 9471, 7751, 6734, 4229,
	7350, 4570, 3539, 9964, 7318, 2925, 7285, 5044,
	910, 1170, 6902, 9479, 5846, 4587, 2066, 9718,
	2024, 9598, 9786, 6834, 9788, 878, 8515, 479,
	3827, 7717, 2467, 4862, 6342, 6429, 1755, 8575,
	9653, 7658, 6064, 8500, 3739, 6705, 9709, 8727,
	7188, 3920, 643, 3538, 9196, 2044, 2512, 4030,
	4742, 8858, 2798, 5421, 9449, 4493, 7923, 7811,
	8000, 9466, 893, 2451, 2464, 595, 648, 4712,
	9685, 1069, 6432, 5712, 9366, 2291, 8285, 9673,
	963, 797, 3759, 8730, 9787, 3118, 6175, 6888,
	7340, 5804, 1787, 4499, 9274, 5600, 8623, 2000,
	3012, 7525, 3772, 5832, 8776, 8233, 8819, 4186,
	8839, 1243, 3757, 6603, 38, 8988, 1689, 9475,
	2656, 4308, 2757, 1617, 8483, 7419, 4432, 422,
	3379, 9379, 7941, 4832, 6397, 4864, 132, 4744,
	5018, 2249, 3186, 7947, 8711, 5661, 7136, 1949,
	9827, 4135, 7566, 106, 1785, 6344, 6462, 5900,
	9559, 1743, 8759, 9815, 2766, 2726, 8889, 1178,
	6042, 1337, 2344, 758, 2262, 9853, 9870, 320,
	3981, 2791, 3735, 1192, 7971, 6202, 2032, 4478,
	7712, 7807, 4055, 1262, 7318, 4267, 551, 2405,
	7480, 3657, 1175, 4133, 614, 4983, 3622, 729,
	1553, 3186, 1015, 1134, 6445, 3169, 9873, 4821,
	19, 2947, 3314, 1074, 2191, 3683, 9534, 9977,
	1274, 6156, 5112, 1886, 5073, 7996, 4769, 5584,
	4236, 2031, 7148, 3026, 7816, 3827, 5170, 7265,
	7348, 9775, 6826, 6117, 8322, 5389, 723, 3879,
	7766, 2144, 1642, 5480, 4291, 6302, 1317, 4356,
	5214, 6696, 1438, 768, 8736, 6532, 2848, 9268,
	1403, 1103, 9555, 2274, 4988, 1270, 6107, 5515,
	8883, 2507, 275, 8187, 4670, 975, 165, 6868,
	1973, 902, 9995, 1421, 78, 6534, 7688, 171,
	1151, 4,		/* * 10000**337 */
	 /* 65536**350 =  */ 5376, 2848, 3097, 7478, 9581, 4767, 564, 7416,
	2894, 9542, 726, 2535, 6568, 6434, 5775, 8334,
	6660, 8109, 768, 4381, 7948, 832, 9727, 6736,
	4371, 7686, 8518, 332, 173, 8241, 8498, 4,
	6562, 3493, 3112, 4998, 660, 1524, 6823, 6242,
	6475, 8178, 7929, 8298, 9439, 9161, 2065, 5021,
	3388, 6887, 6511, 6683, 4151, 1208, 8005, 4130,
	3692, 6948, 2189, 805, 1154, 133, 4169, 6639,
	1811, 990, 5508, 8629, 300, 2310, 3518, 5017,
	5358, 5850, 8671, 6573, 49, 5520, 5528, 8064,
	3441, 5935, 5356, 5963, 5632, 5922, 9287, 2478,
	1595, 8827, 1212, 9835, 4848, 2573, 8854, 6317,
	8300, 7144, 3193, 6224, 2297, 6291, 2094, 9274,
	3829, 9250, 3608, 9224, 6286, 3559, 7081, 5126,
	7724, 2849, 7390, 9500, 2307, 2908, 641, 5630,
	1271, 2165, 7588, 4861, 9441, 7062, 2062, 3854,
	259, 5391, 1477, 3176, 5832, 3351, 3779, 3495,
	6085, 9743, 1068, 4149, 3738, 9737, 2761, 6395,
	1575, 6136, 9570, 419, 8912, 4743, 139, 5106,
	9429, 6354, 6639, 2016, 32, 6503, 2688, 253,
	3072, 8438, 1809, 3605, 7429, 6407, 3523, 3194,
	3301, 3415, 8083, 7442, 13, 6376, 3587, 9852,
	3230, 915, 6344, 8098, 9192, 4127, 1359, 3713,
	5754, 6880, 2667, 3981, 1681, 155, 2793, 6465,
	6334, 7863, 2526, 4075, 2560, 5031, 1170, 77,
	6463, 1877, 5427, 7978, 2699, 301, 4894, 2316,
	6716, 9859, 235, 6316, 9834, 5965, 4481, 9083,
	6291, 8558, 9362, 8075, 9932, 6405, 6902, 3829,
	6056, 2529, 691, 6770, 1761, 3187, 8874, 7283,
	6080, 7420, 5693, 4501, 1471, 9833, 6366, 4679,
	4737, 3318, 5819, 5229, 5279, 6659, 9858, 424,
	4410, 35, 645, 8191, 9263, 5668, 2513, 5232,
	5091, 8185, 1986, 8716, 5718, 7585, 3116, 2732,
	2118, 7247, 3777, 6391, 5165, 5421, 8223, 4033,
	3829, 5689, 9637, 4867, 4761, 5856, 4362, 9352,
	5900, 8005, 2560, 3264, 8131, 5834, 2535, 8375,
	3975, 593, 6644, 5831, 1577, 4428, 8434, 1205,
	8880, 3712, 4093, 5790, 74, 5755, 5356, 421,
	1541, 652, 668, 5683, 1879, 3825, 122, 8887,
	6501, 9684, 829, 1335, 1784, 3655, 6775, 3013,
	7584, 8971, 8943, 4562, 3406, 4808, 2970, 4085,
	7148, 5625, 5979, 2961, 1398, 3067, 2645, 2510,
	1070, 2790, 850, 8698, 3506, 1221, 7240, 683,
	2748, 3836, 5782, 3889, 4328, 8462, 5594, 6692,
	2708, 6983, 5135, 6812, 3321, 5822, 1915, 2109,
	500, 5493, 5883, 7103, 3947, 841, 8799, 7661,
	617, 2921, 2247, 125, 6758, 8415, 1893, 2050,
	9160, 7931, 7846, 8933, 827, 3462, 7938, 8842,
	5671, 8291, 2242, 395, 8090, 1762, 8081, 8357,
	6877, 1775, 3990, 2665, 4244, 3538, 9877, 5469,
	4185, 7179, 1956, 8820, 4442, 1034, 950, 5064,
	5290, 45, 4563, 1743, 7448, 4025, 9091, 9971,
	5877, 7819, 3936, 3940, 6105, 58,	/* * 10000**421 */
	 /* 65536**420 =  */ 576, 8988, 664, 3919, 9397, 8633, 7900, 5633,
	778, 481, 1888, 1204, 5101, 7862, 7589, 9191,
	9710, 2689, 4485, 1804, 6343, 4331, 3074, 8357,
	5813, 3262, 9731, 3649, 2080, 2864, 5674, 77,
	9082, 6281, 981, 3039, 4540, 5146, 1654, 4127,
	3199, 1398, 5247, 1783, 9163, 5185, 706, 2750,
	8430, 9896, 2547, 2815, 2509, 3404, 2669, 3713,
	2722, 1799, 138, 926, 9118, 8525, 4454, 8668,
	6336, 9770, 8685, 9548, 997, 5846, 7559, 9483,
	8362, 1665, 2765, 9093, 8253, 1725, 9810, 213,
	7885, 2853, 1411, 2276, 6384, 8329, 4969, 5285,
	2251, 6643, 9833, 2982, 9239, 927, 6645, 1456,
	7982, 8688, 6067, 7858, 2076, 6104, 5217, 644,
	3517, 5939, 7126, 7571, 4858, 4602, 2878, 9362,
	6694, 1240, 50, 8423, 6113, 5386, 9069, 6622,
	2139, 1576, 1299, 3779, 4071, 6783, 4160, 4975,
	1015, 3216, 5541, 4822, 2752, 7525, 532, 1015,
	3436, 6112, 6964, 1057, 5338, 1449, 5575, 127,
	7502, 6613, 7556, 5345, 1136, 4662, 1741, 2461,
	5108, 8880, 4068, 7622, 9910, 1884, 6898, 3514,
	5504, 3849, 4888, 1780, 9861, 1304, 3382, 2005,
	7315, 1614, 7822, 5275, 9537, 1118, 3830, 1889,
	3342, 8466, 6400, 254, 2618, 9653, 6474, 4960,
	397, 2576, 7484, 9275, 8232, 199, 8566, 161,
	6360, 6573, 5545, 1958, 3067, 5263, 559, 4958,
	315, 1554, 8857, 7186, 8622, 3782, 7740, 3278,
	1794, 7268, 2632, 5501, 9618, 8738, 3643, 6277,
	6012, 3610, 288, 4206, 5796, 3475, 7174, 4912,
	8758, 6323, 3905, 9152, 7953, 4361, 4463, 3095,
	3554, 1683, 6030, 1929, 7375, 6258, 2152, 6562,
	5846, 3295, 3906, 621, 3967, 5512, 6962, 5184,
	8037, 2555, 6225, 7071, 7488, 1212, 4898, 2473,
	7328, 3716, 5825, 9672, 9639, 7120, 443, 7612,
	8465, 6114, 8131, 5825, 3200, 7748, 9274, 4311,
	9358, 4668, 7300, 8736, 3949, 584, 9431, 5922,
	6761, 5835, 1402, 9894, 7088, 2458, 2112, 5215,
	1778, 6588, 9991, 9956, 9148, 6733, 5266, 3544,
	6437, 9631, 1618, 5442, 3963, 2241, 6525, 5097,
	6792, 8765, 5631, 4038, 1736, 3256, 8351, 5314,
	9979, 6884, 6015, 1122, 5239, 8501, 5776, 6649,
	5114, 6880, 460, 475, 1329, 2777, 8032, 6562,
	7846, 7018, 9893, 9391, 3793, 9834, 4199, 3843,
	627, 9689, 2149, 160, 1327, 9674, 8560, 9299,
	8965, 7349, 8187, 6017, 7068, 8093, 5757, 7606,
	2423, 135, 372, 6302, 4605, 2027, 9171, 1324,
	5511, 9099, 8850, 8994, 8232, 4470, 7980, 8005,
	7216, 4482, 6124, 297, 1049, 6980, 9621, 311,
	8951, 8883, 5978, 4077, 9581, 2508, 4711, 4428,
	3341, 3531, 523, 9142, 7401, 8003, 950, 3295,
	419, 7685, 2793, 4628, 1466, 9344, 1694, 9744,
	592, 3901, 7624, 5300, 607, 2830, 7331, 3324,
	7412, 9343, 1002, 9334, 400, 485, 9954, 1257,
	52, 7039, 3202, 2626, 5007, 3291, 4237, 9444,
	6860, 5339, 7508, 1175, 9228, 4913, 9145, 1340,
	306, 2129, 9924, 8112, 991, 7118, 5675, 6906,
	6348, 2476, 1269, 8053, 650, 3578, 7757, 1877,
	7566, 604, 1036, 8177, 8169, 1777, 7586, 4055,
	1745, 2700, 8005, 1, 372, 843, 3229, 5851,
	5704, 3752, 2409, 8356, 4838, 930, 4075, 8149,
	2620, 6567, 3302, 6988, 8270, 757, 3275, 3899,
	7832, 488, 7302, 9455, 2508, 8718, 7517, 8654,
	6925, 3559, 8617, 5973, 8089, 9073, 5897, 6014,
	3039, 4038, 3131, 8979, 8916, 7739, 2464, 4424,
	7777, 834,		/* * 10000**505 */
	 /* 65536**490 =  */ 5776, 9431, 507, 3988, 8799, 5719, 9020, 3099,
	7523, 4041, 2773, 7913, 8546, 6090, 6505, 6324,
	678, 5416, 5566, 9267, 5891, 2562, 106, 1954,
	5018, 2963, 9753, 1086, 574, 9248, 8457, 7833,
	5151, 9537, 3506, 9829, 7272, 920, 8588, 5032,
	9739, 9592, 8917, 8333, 8413, 7860, 3589, 8574,
	3040, 7813, 4386, 28, 1593, 4394, 1358, 4985,
	8871, 9096, 7462, 836, 3458, 9265, 9262, 3279,
	912, 290, 1497, 4428, 5919, 4146, 4003, 5874,
	8647, 167, 8364, 2483, 6932, 5005, 6519, 2592,
	536, 2731, 193, 7398, 2945, 7802, 785, 4094,
	4184, 1213, 8852, 1686, 4541, 6405, 3357, 6423,
	1506, 6089, 1213, 1133, 5118, 3415, 1077, 1958,
	6675, 7423, 6153, 7034, 5831, 1338, 1066, 1935,
	583, 96, 8781, 3076, 4800, 7302, 1310, 6858,
	6070, 9182, 3912, 3432, 5149, 677, 7501, 1001,
	3691, 1492, 2816, 7033, 4083, 5163, 3022, 2024,
	5952, 3985, 8572, 2595, 5985, 5333, 212, 4524,
	2671, 5416, 7327, 8839, 2754, 6826, 8335, 6676,
	5653, 9426, 1185, 1908, 1677, 7014, 9493, 6814,
	2015, 4170, 7520, 9097, 2581, 7181, 8159, 8204,
	1452, 6864, 9467, 5347, 9830, 4403, 5856, 3087,
	6043, 7312, 4115, 990, 889, 8356, 7923, 7708,
	3107, 8295, 8873, 4976, 5777, 3831, 4188, 835,
	8231, 3690, 3524, 9390, 7023, 1876, 7236, 4427,
	514, 6350, 5016, 519, 151, 1119, 1920, 7165,
	137, 5736, 9277, 2526, 8000, 4638, 7675, 3197,
	8010, 7236, 9027, 3052, 429, 4251, 621, 4687,
	580, 9670, 8660, 7852, 6291, 8441, 4969, 2407,
	460, 7339, 6761, 6500, 9983, 805, 915, 8696,
	4445, 56, 9303, 6908, 3917, 8292, 6104, 9779,
	3567, 692, 1259, 292, 833, 3190, 9406, 3740,
	275, 1099, 1482, 6853, 1080, 8559, 8139, 1396,
	4902, 2874, 9613, 5810, 236, 8443, 5416, 8393,
	8751, 3616, 102, 6320, 4005, 809, 2349, 7262,
	1060, 927, 6212, 1845, 2309, 6601, 234, 7023,
	1037, 8076, 4278, 8787, 1111, 2785, 5347, 9174,
	4866, 8543, 1979, 9701, 8951, 2955, 1607, 317,
	508, 4607, 9658, 4672, 6840, 1896, 1259, 9832,
	7398, 176, 317, 3185, 5585, 2848, 1431, 545,
	8514, 9260, 9054, 4691, 4722, 2396, 4080, 1438,
	7161, 38, 2373, 2081, 359, 5634, 8412, 7366,
	1617, 1042, 9842, 492, 426, 5456, 9432, 5831,
	6293, 3455, 895, 9218, 307, 3951, 18, 7350,
	1858, 1805, 352, 8085, 3566, 9921, 3839, 8974,
	7501, 3634, 8467, 8370, 4209, 3242, 617, 38,
	5947, 3376, 6638, 1543, 4303, 6258, 2008, 8965,
	5607, 4777, 5725, 4908, 4312, 5484, 6276, 4939,
	2969, 1989, 8160, 2323, 3613, 5872, 6195, 1051,
	2368, 5130, 5114, 4157, 8861, 3505, 8475, 5251,
	1312, 9694, 9803, 6432, 350, 7092, 8507, 6429,
	4896, 4256, 953, 5869, 4820, 6006, 5260, 8523,
	905, 2152, 7727, 2873, 4262, 9943, 2468, 6602,
	299, 1975, 3745, 9332, 4535, 4221, 4273, 7144,
	297, 4009, 8535, 451, 3773, 2948, 5922, 5956,
	4079, 5527, 687, 9259, 9230, 6868, 4982, 8161,
	1559, 5930, 8859, 3745, 9346, 3511, 3694, 1580,
	6169, 323, 5558, 3735, 8840, 8377, 6888, 1528,
	3427, 9648, 7158, 7572, 8821, 3085, 1542, 5127,
	4430, 6826, 7402, 9291, 562, 1246, 8624, 2794,
	6256, 7655, 1083, 8826, 4414, 1460, 2278, 7861,
	8341, 3677, 2984, 4691, 451, 3560, 1580, 7583,
	6509, 4045, 7972, 321, 4512, 1662, 9186, 371,
	7919, 1240, 8982, 997, 1836, 9492, 5360, 5448,
	6025, 4174, 4995, 3474, 7970, 2139, 1951, 7419,
	8942, 6697, 4438, 3559, 2076, 8885, 2256, 6627,
	543, 164, 5853, 4856, 7906, 2129, 1724, 3786,
	8533, 3135, 3539, 2300, 6945, 7244, 4342, 4067,
	890, 7697, 9580, 7680, 61, 6007, 8870, 7700,
	8996, 6715, 3370, 1992, 889, 3860, 6590, 5603,
	2020, 9641, 1761, 2911, 576, 4742, 4317, 2007,
	5876, 2778, 8887, 2860, 2104, 1998, 8765, 3094,
	540, 3195, 9389, 5556, 3538, 4926, 3190, 7472,
	609, 5522, 9966, 9799, 5660, 1889, 1,	/* * 10000**590 */
	 /* 65536**560 =  */ 976, 4979, 3040, 9206, 955, 4391, 2817, 938,
	1112, 5523, 5387, 1306, 5954, 1973, 9036, 8492,
	5961, 9057, 4333, 4301, 583, 4235, 3509, 9051,
	920, 2693, 5406, 961, 5945, 2876, 5973, 8416,
	1345, 265, 9047, 1241, 3361, 9657, 5675, 7186,
	6284, 4664, 9707, 5178, 8714, 3055, 9424, 8160,
	3540, 2285, 3000, 83, 4995, 4114, 2049, 3255,
	8318, 6178, 1394, 1626, 8128, 5450, 1000, 7325,
	954, 3111, 9095, 6175, 1638, 7210, 4996, 5422,
	2210, 9768, 129, 952, 7035, 3095, 2545, 68,
	2121, 5895, 5840, 8038, 6233, 8454, 4819, 41,
	9659, 756, 5166, 4451, 6171, 828, 6973, 381,
	5405, 8524, 5788, 8040, 5624, 9949, 4079, 8021,
	9909, 5434, 9374, 9549, 4519, 3315, 9843, 3053,
	936, 2227, 1563, 8987, 4406, 3206, 3672, 5667,
	4927, 3654, 3143, 8371, 3840, 3751, 6085, 6065,
	7371, 2891, 5391, 340, 2817, 4181, 8243, 2568,
	4276, 5037, 5579, 4087, 9881, 3156, 7618, 738,
	4561, 1917, 5475, 356, 8296, 541, 939, 4009,
	4945, 7654, 9014, 5190, 1958, 8762, 8536, 2515,
	6041, 1430, 8447, 7896, 4976, 5974, 1848, 2061,
	848, 2128, 9096, 8336, 5768, 1268, 2744, 2445,
	1997, 547, 5266, 2066, 2785, 6457, 7035, 5368,
	7618, 1389, 1304, 4119, 899, 4551, 3877, 3140,
	3879, 3564, 3844, 3066, 2279, 7763, 4159, 3714,
	7863, 6139, 516, 4075, 3813, 411, 6837, 7570,
	863, 6397, 2306, 9709, 5957, 1883, 2460, 1164,
	7907, 8462, 6278, 2391, 1205, 9618, 8604, 7140,
	5742, 5884, 9887, 3539, 9756, 6773, 1783, 3234,
	7128, 2285, 7327, 5364, 9023, 4212, 1005, 1827,
	4830, 6992, 6679, 2761, 8465, 8923, 6697, 2139,
	8041, 1978, 8857, 3050, 3862, 4736, 7727, 9356,
	7020, 8064, 840, 7255, 2415, 925, 5770, 8623,
	8843, 1722, 7152, 5061, 1193, 5878, 4483, 8654,
	5757, 9025, 998, 8067, 6265, 832, 4047, 3221,
	6466, 2287, 9674, 5520, 1293, 7456, 3458, 5767,
	755, 3752, 6416, 7411, 6410, 1693, 3423, 9206,
	7864, 5888, 8614, 4425, 4627, 5663, 5784, 6655,
	643, 3172, 1929, 8595, 420, 6586, 6985, 3036,
	6496, 6346, 5234, 1163, 9945, 300, 800, 7684,
	8060, 6753, 6778, 4600, 6518, 2929, 5468, 4077,
	5824, 431, 7782, 841, 2968, 1032, 7716, 9390,
	9987, 2069, 2135, 4678, 113, 7300, 3384, 8798,
	4109, 1841, 6669, 6689, 5687, 795, 4836, 8859,
	9130, 1137, 557, 3551, 4205, 4030, 2660, 5896,
	2006, 6595, 1224, 6297, 2619, 5306, 4522, 550,
	2776, 5836, 9778, 1076, 3355, 6338, 8670, 7630,
	3713, 7476, 1252, 6054, 9540, 5558, 2803, 8396,
	3948, 5582, 105, 3026, 9555, 138, 1654, 7788,
	9819, 9821, 3618, 582, 6614, 1325, 7741, 530,
	2492, 3387, 950, 3424, 4823, 7442, 9865, 9714,
	1796, 5099, 2964, 4613, 3652, 4807, 6659, 7494,
	4223, 8782, 8155, 1636, 2192, 1810, 2642, 3661,
	9096, 8284, 7796, 9482, 9920, 6951, 6355, 8988,
	350, 3480, 1984, 768, 5747, 4435, 2898, 8288,
	967, 1866, 4451, 8747, 7626, 3684, 6476, 4752,
	6604, 558, 2385, 9001, 2462, 5150, 5259, 6616,
	2390, 4184, 9526, 5941, 3138, 3861, 3482, 19,
	6341, 7036, 6369, 227, 5578, 9777, 4200, 538,
	6718, 2752, 1338, 4237, 2048, 5785, 5899, 4648,
	2755, 2819, 9492, 9450, 9570, 1581, 954, 3311,
	3691, 9510, 4695, 9790, 4907, 2502, 6597, 8365,
	4396, 3170, 92, 3169, 9407, 870, 9168, 7108,
	90, 5103, 4276, 5344, 4920, 7045, 1679, 1520,
	7051, 8893, 6973, 6818, 2512, 574, 6179, 5618,
	225, 1644, 2951, 1314, 9901, 1499, 2582, 3814,
	2485, 8706, 3433, 9669, 3891, 469, 6359, 8382,
	5455, 5542, 6754, 4380, 271, 4014, 867, 8095,
	6721, 914, 2408, 2133, 7283, 9336, 5715, 9709,
	2233, 3472, 3873, 9891, 5910, 5471, 6346, 222,
	8177, 9547, 1543, 7347, 1126, 4978, 2536, 6994,
	5877, 8981, 9413, 1542, 9992, 7496, 7307, 6635,
	831, 6332, 3769, 394, 1877, 37, 4545, 2982,
	5374, 7892, 9053, 6562, 2197, 6380, 8510, 2259,
	1952, 2956, 8378, 1486, 6599, 3860, 1054, 381,
	653, 3946, 8672, 8801, 9960, 5721, 3028, 6761,
	5872, 1570, 2165, 2319, 6451, 7788, 265, 5408,
	5369, 67, 8748, 2202, 6405, 5114, 2663, 4433,
	6258, 3883, 9615, 4072, 7588, 4059, 2415, 4238,
	8235, 2561, 9582, 4274, 4141, 5656, 1887, 8922,
	8452, 1792, 498, 6663, 2697, 5907, 6270, 9502,
	7239, 988, 5148, 5593, 9033, 6819, 2688, 7212,
	8656, 4307, 2183, 8071, 4878, 895, 5360, 6555,
	225, 6796, 7011, 1301, 1281, 7342, 1056, 6924,
	6214, 9340, 16,		/* * 10000**674 */
	 /* 65536**630 =  */ 6176, 6430, 7092, 4105, 8720, 5723, 5981, 9910,
	5297, 4110, 3651, 4988, 5821, 4616, 4727, 5734,
	8042, 9496, 1397, 4266, 7433, 391, 738, 3945,
	4598, 4271, 7578, 529, 472, 6685, 9791, 6802,
	3226, 7385, 7662, 6806, 1919, 9525, 6729, 7962,
	5888, 9669, 2636, 7607, 7516, 8780, 6202, 3965,
	112, 1209, 5491, 2643, 2462, 5963, 2515, 1230,
	4121, 4054, 2940, 582, 5240, 8210, 1080, 9217,
	1033, 602, 7441, 2065, 6998, 3379, 489, 658,
	7501, 6167, 3242, 2737, 9556, 1554, 242, 2323,
	3353, 779, 5274, 3089, 6341, 24, 1328, 8441,
	1217, 2901, 9907, 9097, 3783, 3841, 3212, 1283,
	5332, 7926, 4527, 4103, 1597, 7221, 5369, 9156,
	4301, 8902, 3951, 9950, 6527, 2132, 6719, 2566,
	5427, 2526, 4888, 1869, 1785, 3119, 5644, 9918,
	1783, 5055, 2971, 6210, 2536, 6963, 3318, 1938,
	1884, 5924, 8977, 2428, 8311, 3225, 1210, 2846,
	4884, 7409, 5288, 5889, 3103, 3776, 3574, 7832,
	1546, 680, 9682, 9901, 1161, 4236, 893, 9012,
	9788, 3335, 620, 6581, 941, 8694, 462, 3523,
	6654, 1481, 9845, 7439, 7476, 5821, 3819, 9038,
	1144, 6471, 9971, 5535, 9048, 3965, 9361, 1496,
	3009, 6969, 2693, 5755, 2330, 6810, 2352, 1512,
	2523, 9719, 7464, 7771, 8431, 3033, 751, 7904,
	7402, 4660, 2761, 5357, 2617, 5937, 2788, 5153,
	4719, 8910, 4078, 2261, 8892, 8638, 523, 6944,
	2764, 4273, 8230, 3796, 8416, 6433, 7600, 6223,
	3477, 9222, 8330, 8551, 61, 9175, 7442, 4076,
	8823, 9894, 4097, 8187, 9873, 9573, 3391, 4457,
	2092, 2354, 9874, 6178, 6230, 8587, 583, 4119,
	2196, 8390, 9503, 8332, 9211, 1596, 3306, 7433,
	9397, 231, 7884, 9555, 83, 4747, 4305, 5408,
	3811, 4850, 1772, 2406, 1877, 3578, 6173, 7833,
	14, 8328, 2596, 5975, 5184, 5562, 387, 5768,
	3222, 1877, 2477, 8064, 5842, 6208, 4771, 6956,
	5542, 7513, 9381, 7844, 3531, 2747, 5733, 713,
	2053, 2655, 7472, 5000, 4903, 8819, 4211, 9930,
	4030, 1341, 2835, 1622, 12, 8582, 5178, 8384,
	6232, 4624, 9277, 1178, 7232, 4849, 887, 1037,
	4858, 8575, 6772, 5980, 7295, 7449, 9758, 9866,
	709, 3994, 799, 1400, 2397, 7707, 7902, 1208,
	3204, 8039, 8612, 7645, 1835, 8956, 5657, 2088,
	189, 2316, 6271, 218, 6153, 5436, 1, 194,
	2726, 9535, 4441, 3603, 3399, 9412, 4862, 8591,
	9976, 1486, 2073, 3543, 2316, 841, 5016, 4073,
	6014, 6689, 3912, 7333, 9067, 9942, 8796, 7745,
	9452, 8145, 2207, 5872, 3731, 9353, 9948, 9187,
	6536, 8425, 8829, 6688, 6100, 4022, 9374, 4893,
	5752, 13, 5691, 2233, 4334, 5630, 6246, 434,
	1221, 7461, 2426, 5642, 4710, 2812, 1033, 4356,
	3089, 1587, 1993, 6607, 4931, 7635, 1098, 4997,
	23, 2333, 5751, 7215, 2503, 5703, 293, 1194,
	1899, 427, 5631, 1081, 3676, 556, 9765, 5256,
	7616, 7431, 8935, 5493, 652, 6013, 9659, 3691,
	6652, 1760, 4298, 2524, 758, 6723, 9665, 3205,
	9325, 9890, 7705, 8841, 3106, 4116, 3348, 2963,
	7234, 63, 3671, 4198, 1691, 5227, 9985, 6405,
	8748, 830, 6348, 5353, 3024, 5032, 7552, 7653,
	1768, 2704, 6335, 4599, 243, 8332, 3602, 9120,
	9092, 4163, 1618, 9591, 9048, 5124, 6084, 9117,
	6114, 4589, 462, 745, 7286, 6528, 7139, 6347,
	1825, 932, 1067, 293, 443, 6679, 65, 3780,
	4351, 751, 9603, 8711, 5504, 8908, 7748, 8541,
	4250, 7889, 9317, 7250, 2112, 3173, 4267, 5986,
	4804, 1066, 4792, 7231, 1488, 661, 9538, 4177,
	9074, 656, 2338, 5296, 1871, 4347, 8386, 8313,
	2884, 5370, 5220, 7582, 2797, 8578, 8049, 5674,
	3977, 9693, 2366, 545, 869, 6824, 8706, 3830,
	2164, 5089, 2472, 2628, 1004, 2701, 1638, 7113,
	8101, 4748, 929, 8775, 9272, 1560, 8789, 5664,
	8258, 9613, 5486, 4613, 9863, 9005, 5112, 1799,
	4345, 8645, 570, 9967, 6500, 832, 8592, 838,
	9031, 7856, 5907, 381, 2763, 8153, 8398, 995,
	5801, 6346, 1214, 5007, 5316, 6928, 416, 4825,
	5944, 1297, 7549, 1499, 839, 1928, 5878, 5745,
	3272, 2572, 5248, 1460, 3905, 4288, 6818, 2388,
	7859, 9256, 1185, 2181, 3363, 8050, 8380, 9891,
	439, 5568, 8003, 5852, 1229, 9602, 7847, 5969,
	9057, 5525, 970, 1188, 372, 4928, 2344, 9662,
	9190, 1151, 8943, 5226, 1228, 2502, 8609, 9922,
	8201, 8724, 7651, 4046, 9691, 9904, 1535, 8250,
	4015, 5963, 9786, 6581, 8264, 4230, 7914, 2186,
	9235, 6295, 4350, 2794, 3271, 3552, 7515, 6223,
	2140, 4314, 2250, 1975, 627, 4462, 5690, 3413,
	3619, 4409, 8546, 2810, 6451, 8042, 6981, 5847,
	6670, 8620, 6057, 2985, 520, 3854, 5227, 9175,
	7632, 2479, 2790, 9594, 8713, 9800, 6204, 804,
	8244, 513, 650, 8472, 3103, 8833, 3041, 1162,
	1267, 7884, 8114, 5632, 7241, 3921, 9695, 2345,
	756, 9724, 9477, 2820, 7004, 2987, 1515, 6371,
	7318, 7495, 8174, 1492, 1502, 2107, 9841, 9638,
	7642, 9871, 8621, 6991, 2350, 4862, 9372, 1741,
	9751, 3844, 4708, 9941, 942, 865, 2781, 5447,
	15, 528, 3632, 5878, 351, 0, 1393, 8028,
	4688, 8018, 7552, 5798, 3137, 1883, 241,	/* * 10000**758 */
	 /* 65536**700 =  */ 1376, 4586, 3110, 8109, 813, 2413, 7374, 4459,
	7631, 8946, 4454, 2451, 688, 5867, 8242, 3361,
	8832, 4437, 5519, 3061, 364, 4012, 8341, 4231,
	8360, 5724, 6055, 1955, 7486, 8472, 2328, 9617,
	1395, 8211, 2562, 3881, 804, 5684, 1580, 5622,
	253, 2116, 7361, 6279, 8846, 9490, 3076, 6714,
	859, 4921, 470, 1568, 3914, 3534, 5861, 68,
	2260, 9838, 1745, 6725, 9675, 3197, 369, 9299,
	6927, 6882, 1999, 4319, 1994, 6604, 8141, 2440,
	2345, 7443, 449, 202, 4032, 490, 5338, 8768,
	7265, 5012, 8672, 5900, 5541, 4891, 6096, 4383,
	6323, 5870, 1524, 7638, 3400, 6366, 6213, 428,
	1872, 5107, 6186, 2421, 5576, 1881, 8804, 9572,
	7734, 3881, 9595, 2628, 7760, 5058, 7924, 5553,
	5156, 4098, 9186, 269, 8189, 3581, 8233, 6224,
	2891, 7680, 3446, 8138, 7568, 9843, 8204, 1986,
	6126, 3468, 9198, 8388, 1316, 8387, 9313, 3728,
	6889, 9813, 4372, 1967, 8561, 6099, 8106, 4100,
	5281, 3861, 9375, 9097, 9704, 7224, 1961, 2569,
	3683, 6468, 2169, 2345, 5718, 8692, 5385, 7056,
	3147, 1978, 9445, 4762, 5390, 6541, 6663, 8522,
	8775, 8245, 1022, 4, 7451, 1623, 4426, 5431,
	2700, 3478, 216, 8713, 9146, 9152, 9543, 2348,
	201, 5303, 5894, 5551, 3564, 1811, 148, 5018,
	5783, 3415, 2654, 4387, 5930, 7241, 822, 304,
	5280, 4874, 8619, 3871, 6573, 1810, 8121, 6109,
	1252, 8884, 9457, 3422, 7107, 4752, 5692, 3659,
	2111, 406, 6917, 6654, 9902, 5175, 1115, 7073,
	5448, 9436, 637, 3031, 4610, 2213, 8584, 6608,
	8221, 6999, 5789, 9499, 119, 4379, 8719, 2495,
	9433, 5245, 6219, 6585, 1470, 7864, 17, 8133,
	1623, 4331, 9120, 7601, 2788, 4753, 1113, 3304,
	9695, 2285, 9289, 9894, 6930, 3596, 3553, 8327,
	3702, 8520, 952, 6437, 1794, 9348, 2373, 8042,
	9623, 4687, 852, 7710, 2830, 712, 6949, 4962,
	7564, 845, 325, 8598, 5915, 7846, 134, 4092,
	8320, 2594, 3361, 3486, 2148, 3874, 1167, 7721,
	2997, 4766, 7956, 2990, 3706, 6230, 7158, 2270,
	7383, 7156, 220, 461, 4389, 6761, 3391, 7669,
	3533, 4179, 4452, 1983, 96, 4861, 4969, 1955,
	1730, 5804, 2690, 480, 5521, 8307, 9407, 5267,
	5224, 5589, 354, 8171, 1931, 9270, 5338, 6469,
	3134, 2294, 7509, 6092, 7856, 4817, 9694, 9938,
	1734, 183, 3086, 8839, 1378, 1696, 6749, 5189,
	6701, 1425, 6429, 2989, 6291, 4557, 2441, 8383,
	3238, 4712, 9405, 2934, 2351, 5480, 7183, 2544,
	7983, 7358, 4167, 1710, 3735, 3718, 8737, 7750,
	2985, 1040, 7766, 2755, 6766, 6331, 9095, 6047,
	5580, 5501, 6305, 1682, 9474, 461, 3990, 4426,
	8734, 2562, 3942, 9748, 6939, 150, 6359, 7682,
	3379, 1328, 8128, 5972, 6892, 4860, 2107, 3330,
	3704, 1205, 115, 5648, 8256, 3308, 374, 9011,
	8758, 5046, 5154, 5092, 5698, 6810, 7156, 9533,
	3113, 3809, 4000, 4964, 7395, 6816, 1282, 9606,
	9471, 9830, 9937, 3567, 8703, 2376, 6893, 5218,
	7293, 3215, 3398, 8549, 2494, 1587, 3804, 2858,
	9019, 5968, 7835, 5821, 7483, 7121, 544, 9024,
	8399, 7510, 4571, 2094, 3538, 1577, 7130, 5822,
	1996, 1483, 1700, 5527, 570, 791, 2578, 3080,
	4903, 4771, 7320, 1545, 9454, 7539, 4331, 3864,
	9802, 6872, 8528, 3996, 7125, 5732, 9571, 790,
	7470, 9665, 219, 7307, 2199, 2311, 8669, 5264,
	8130, 5497, 6322, 7105, 571, 2920, 8273, 7186,
	9789, 3904, 5074, 2746, 1540, 9054, 395, 3472,
	3313, 2272, 5600, 1972, 5374, 5315, 7487, 3887,
	8919, 1379, 4867, 9911, 159, 1775, 2502, 5278,
	8189, 1751, 649, 4827, 5636, 5922, 8085, 7978,
	3876, 953, 91, 5265, 586, 8369, 1331, 3073,
	5441, 2656, 756, 3750, 5065, 3432, 5601, 2925,
	4324, 3109, 1584, 4244, 9847, 6788, 5544, 6780,
	875, 2974, 1407, 5026, 2485, 3708, 2179, 5846,
	6041, 6243, 9491, 4441, 8586, 1275, 6189, 8674,
	40, 4704, 5642, 9795, 88, 3425, 6010, 8541,
	5143, 7969, 9303, 6803, 2653, 5277, 1220, 2598,
	1511, 617, 5980, 8438, 428, 2439, 9102, 4813,
	534, 1182, 9186, 8299, 9546, 6675, 1047, 6804,
	1680, 2682, 3261, 8008, 6770, 7586, 2977, 4414,
	9460, 434, 7519, 615, 9068, 5178, 7915, 2666,
	3944, 4924, 7855, 2223, 8572, 5298, 1552, 8389,
	4271, 7406, 6363, 7646, 8398, 8160, 2069, 539,
	5033, 7604, 1436, 5275, 482, 4351, 9141, 7999,
	6490, 1856, 3788, 4972, 5139, 4359, 6807, 1250,
	8357, 3359, 3649, 6754, 7053, 8789, 3562, 3793,
	4146, 60, 5998, 7979, 8575, 592, 4584, 4106,
	3404, 7617, 6881, 2697, 3152, 8488, 6329, 3043,
	6970, 9232, 1885, 3130, 4859, 6188, 3885, 1044,
	822, 8498, 6408, 1921, 6737, 8743, 431, 6405,
	7340, 7105, 1238, 6695, 9100, 4467, 5128, 4391,
	4528, 5406, 1064, 8420, 754, 3135, 359, 634,
	5146, 7439, 1807, 1138, 5941, 52, 1554, 8214,
	8509, 3041, 4027, 4222, 1102, 2485, 3258, 3872,
	7554, 6844, 3183, 3660, 6015, 2150, 1179, 4086,
	3006, 5648, 1070, 7839, 9394, 417, 4476, 5914,
	3153, 8151, 8754, 4566, 7354, 2266, 2595, 9675,
	9849, 2561, 3843, 3783, 4417, 1091, 6860, 7239,
	776, 8822, 6599, 1796, 4964, 6626, 1710, 4832,
	1737, 4985, 9724, 500, 8824, 4870, 4557, 3357,
	2631, 1898, 8659, 6055, 6063, 1360, 3880, 6129,
	6219, 2248, 3427, 3819, 9834, 529, 8694, 5071,
	4713, 9682, 7120, 1400, 1385, 3033, 9416, 7959,
	232, 7154, 1288, 5060, 4686, 6550, 9634, 4993,
	3244, 3205, 2668, 4768, 7732, 5099, 1453, 8980,
	281, 144, 5597, 4066, 5746, 2220, 2838, 9818,
	910, 3708, 5565, 8463, 8273, 2742, 3946, 304,
	6406, 1028, 9203, 2140, 3691, 2406, 1882, 426,
	2922, 1953, 3435,	/* * 10000**842 */
	 /* 65536**770 =  */ 6576, 245, 6356, 5875, 2422, 9666, 6333, 951,
	150, 2145, 7477, 5966, 1410, 2763, 307, 9452,
	5802, 5729, 1339, 3258, 2063, 9970, 6176, 1754,
	4757, 3297, 966, 8543, 8894, 117, 6213, 2274,
	4313, 8739, 3420, 691, 5977, 4505, 2536, 2997,
	3881, 3568, 1510, 5728, 6781, 9126, 7767, 1593,
	9017, 7864, 1976, 3746, 7862, 5273, 5257, 3301,
	8551, 2783, 2395, 7645, 315, 6447, 7429, 2440,
	943, 3567, 1927, 4649, 8911, 9014, 7172, 1994,
	6157, 4143, 8757, 2551, 3648, 9689, 5687, 6387,
	9358, 3878, 3632, 3984, 7237, 2547, 9700, 993,
	2278, 5799, 2100, 1748, 7385, 9669, 7791, 8150,
	6319, 2225, 9870, 9690, 884, 2677, 3804, 2903,
	2175, 5452, 7358, 8961, 7445, 515, 9507, 2931,
	7139, 9066, 276, 3657, 4963, 1907, 2044, 603,
	5124, 7175, 7031, 7712, 4449, 9865, 5262, 5849,
	9041, 3705, 6218, 4092, 1255, 2007, 9678, 3624,
	5180, 3538, 8771, 8142, 5087, 8757, 6817, 3082,
	3769, 7244, 4883, 4619, 4167, 1699, 9115, 9182,
	1348, 2906, 6991, 5382, 3461, 8628, 7028, 9325,
	3587, 7188, 4383, 9966, 7798, 105, 2955, 7538,
	2950, 3988, 9142, 6793, 5340, 3555, 1117, 5218,
	6349, 7006, 3785, 9480, 9839, 4795, 7464, 9682,
	7006, 4058, 4110, 4069, 1190, 4288, 2430, 8454,
	3076, 1395, 6594, 9163, 7479, 8065, 4755, 4874,
	647, 6200, 3270, 4761, 1485, 8860, 4861, 2395,
	1448, 8327, 776, 9899, 8277, 9220, 3382, 2782,
	3123, 5194, 3714, 4997, 1538, 2611, 9158, 9311,
	8857, 2483, 4214, 3062, 4880, 7846, 8772, 8092,
	3695, 7541, 9097, 667, 7806, 5727, 2261, 5090,
	5471, 9091, 3406, 422, 3994, 6902, 5228, 1216,
	1965, 375, 2757, 996, 4155, 1371, 5076, 7668,
	940, 2295, 8732, 9059, 8808, 6358, 2737, 8179,
	5344, 4418, 7027, 3631, 7129, 1789, 96, 7192,
	1246, 891, 8740, 2336, 4936, 2213, 1414, 7793,
	3041, 8231, 6528, 7078, 299, 7293, 1683, 8208,
	8097, 1670, 6643, 7366, 5146, 9629, 9972, 2977,
	9684, 1445, 2334, 7490, 1104, 6613, 6778, 2262,
	517, 4530, 4411, 8052, 2891, 5782, 3582, 7797,
	2650, 7112, 9324, 6077, 1036, 217, 980, 5753,
	9082, 1275, 6766, 2989, 6223, 2611, 2289, 9995,
	0, 7007, 3794, 3507, 9401, 7170, 8065, 7505,
	5429, 8108, 57, 4816, 6308, 795, 5172, 9799,
	514, 8369, 6605, 2125, 8482, 4855, 5695, 7116,
	2726, 6596, 5449, 1018, 7187, 8663, 6383, 5434,
	5472, 111, 1133, 7483, 572, 2642, 7374, 3672,
	6578, 1601, 5038, 1935, 8108, 8112, 219, 5137,
	9883, 1208, 4391, 872, 4997, 9658, 6156, 4152,
	247, 7022, 1720, 3435, 3669, 892, 3328, 3906,
	9750, 9679, 3130, 1096, 2598, 8077, 5644, 9251,
	4790, 7079, 4824, 248, 6992, 13, 4271, 385,
	2690, 2875, 7987, 6637, 9248, 6579, 9888, 4147,
	5376, 4578, 8170, 9261, 7266, 9739, 5526, 3243,
	1271, 6280, 134, 2294, 1169, 6079, 629, 2541,
	571, 1074, 4067, 6219, 6141, 4059, 7791, 6269,
	4370, 504, 2106, 4204, 12, 396, 8296, 6851,
	5299, 1980, 2205, 6099, 7526, 8617, 1275, 7304,
	4306, 3079, 7189, 7371, 5846, 1884, 1101, 8229,
	73, 4440, 531, 5649, 4927, 9063, 6529, 6352,
	1199, 4855, 1212, 9365, 1939, 4630, 8322, 1252,
	9242, 2296, 6277, 3508, 6969, 8655, 5338, 8780,
	7263, 603, 9464, 7296, 5563, 9966, 3937, 7009,
	529, 8557, 2752, 5988, 9040, 1872, 541, 8295,
	4144, 2418, 3603, 269, 8858, 9362, 2376, 1882,
	225, 7448, 2381, 1931, 426, 2059, 3337, 7981,
	6221, 8665, 5603, 2085, 651, 6853, 1798, 5910,
	8799, 3888, 1917, 5075, 7299, 2087, 4433, 5613,
	437, 8893, 3374, 5536, 8180, 2413, 3805, 4782,
	5355, 7634, 833, 828, 4318, 6069, 1943, 6953,
	3331, 9719, 1055, 7989, 8882, 7868, 3167, 1941,
	5715, 9354, 8646, 6553, 8643, 2581, 3241, 6665,
	3936, 5677, 776, 8961, 2596, 1404, 8448, 3466,
	8374, 6407, 9540, 3608, 8614, 6021, 573, 949,
	8416, 7147, 8621, 2691, 6429, 8691, 7634, 772,
	89, 2786, 7169, 6823, 9486, 7807, 1554, 1429,
	8278, 3688, 5352, 4658, 8852, 9013, 9163, 5624,
	2363, 8992, 7480, 9099, 5429, 8079, 1235, 1177,
	8441, 9443, 8841, 1526, 899, 4690, 7947, 9598,
	210, 8061, 5363, 8632, 8660, 3791, 7135, 5744,
	3939, 5190, 4819, 8291, 1515, 7886, 3114, 6952,
	2498, 5758, 245, 1104, 6047, 2056, 3379, 7991,
	6993, 7720, 1746, 4440, 7800, 3194, 2512, 4296,
	3072, 8662, 1929, 7680, 4080, 4999, 7253, 6706,
	65, 8144, 5567, 3131, 3500, 8032, 3210, 8721,
	9733, 246, 3335, 8139, 2564, 2307, 5130, 7685,
	6143, 2690, 4963, 9028, 3967, 8385, 6454, 3020,
	3844, 1893, 2889, 5541, 8504, 374, 7689, 2068,
	4199, 6632, 6003, 4161, 7427, 5366, 3837, 7481,
	4184, 4059, 6669, 2982, 6572, 7942, 6892, 3090,
	9143, 4052, 988, 8996, 7508, 2430, 3054, 6349,
	4014, 4949, 6171, 2648, 9933, 1038, 3046, 8955,
	3754, 4123, 3175, 3938, 2682, 3831, 9513, 1213,
	394, 783, 5094, 8043, 4966, 3131, 6018, 9166,
	7031, 7139, 5518, 4981, 5179, 8622, 2757, 9262,
	3635, 2899, 5093, 9238, 8975, 2374, 4244, 8814,
	31, 6851, 2453, 7638, 528, 6045, 3521, 4686,
	5415, 6689, 4342, 4629, 1928, 2182, 968, 3344,
	7654, 6088, 5259, 9531, 2122, 8346, 4173, 735,
	9159, 4533, 7493, 6745, 2635, 6334, 7907, 7916,
	2572, 478, 8063, 2679, 4777, 1168, 5397, 5514,
	1663, 2579, 6615, 1964, 8593, 5498, 6036, 7463,
	8815, 1208, 5069, 5234, 609, 8966, 4552, 1157,
	2099, 44, 1001, 9393, 8254, 196, 1517, 113,
	3557, 5894, 6684, 6020, 2640, 3565, 672, 5834,
	8844, 3245, 3912, 4242, 480, 3940, 3700, 9274,
	4416, 2558, 4846, 4828, 5599, 9101, 6419, 1439,
	5164, 5219, 3056, 2619, 5510, 7513, 2339, 2952,
	7539, 2728, 6880, 2140, 406, 3032, 5314, 2592,
	6889, 4490, 2748, 8871, 3996, 3202, 6519, 2460,
	7927, 8324, 2242, 7373, 9534, 7626, 7641, 4965,
	3972, 5369, 3904, 2053, 8744, 8630, 124, 1431,
	1643, 5368, 7730, 1757, 2613, 7414, 225, 9158,
	7726, 197, 2648, 9531, 7062, 2318, 8972, 433,
	458, 7883, 8832, 2662, 3314, 8091, 6748, 5703,
	5124, 7447, 8008, 9237, 6696, 7880, 28, 8663,
	525, 2906, 7521, 2442, 7245, 7738, 8926, 4,
	/* * 10000**927 */
	 /* 65536**840 =  */ 1776, 4209, 107, 8907, 5829, 8291, 3792, 7140,
	8690, 5729, 1980, 8333, 6343, 4729, 4891, 6613,
	1876, 7120, 2857, 4433, 4445, 5275, 7171, 48,
	9321, 7844, 7123, 2851, 7177, 8795, 9744, 9639,
	2481, 2561, 4398, 8938, 6005, 3603, 9539, 4851,
	6380, 6376, 5478, 9062, 2258, 8093, 4242, 3610,
	6371, 1120, 9049, 432, 8580, 9844, 443, 4598,
	4973, 845, 5958, 5061, 7948, 9512, 9145, 8386,
	7212, 126, 1672, 1176, 9349, 4654, 4602, 814,
	7191, 2008, 4459, 5745, 7526, 646, 5999, 9963,
	8550, 9791, 7786, 277, 6598, 7600, 901, 3352,
	8074, 3157, 3661, 6470, 905, 3657, 4173, 4804,
	6683, 9857, 4353, 1123, 8293, 669, 6879, 594,
	353, 1428, 3387, 5667, 8085, 1175, 4243, 393,
	6238, 449, 5931, 3907, 1424, 3236, 205, 3023,
	6171, 188, 7723, 9095, 1359, 1890, 1791, 8386,
	444, 162, 2509, 3757, 3354, 2757, 231, 6664,
	6929, 6426, 9025, 937, 1175, 7815, 5138, 5412,
	9050, 8921, 9895, 949, 2682, 909, 9622, 5279,
	1797, 7274, 4291, 3764, 3575, 9282, 6469, 2980,
	3245, 4850, 6847, 3690, 5293, 5479, 8362, 264,
	8983, 2738, 1503, 6814, 1557, 2719, 9253, 5235,
	9351, 1013, 8631, 7562, 7326, 2565, 5343, 3416,
	3876, 2749, 5448, 9776, 3548, 2345, 8095, 5557,
	5994, 1001, 201, 6028, 4903, 5273, 4875, 3387,
	9854, 5952, 8239, 532, 4892, 4540, 9787, 1357,
	2935, 7540, 7254, 295, 3020, 4145, 9693, 3272,
	4423, 6528, 7824, 9108, 8383, 6625, 3156, 5428,
	8091, 1867, 6682, 7034, 7554, 883, 4275, 763,
	4093, 692, 7649, 4523, 2587, 8443, 2065, 5289,
	9385, 6198, 7308, 5388, 4113, 3746, 2214, 4397,
	4402, 6210, 4346, 199, 1021, 9899, 5375, 5990,
	9027, 7089, 3338, 5270, 1537, 9622, 1888, 1494,
	9477, 8020, 3438, 4614, 5382, 9984, 8216, 4446,
	3556, 3442, 1354, 3210, 5823, 5800, 6798, 3366,
	2968, 1726, 7017, 5620, 5685, 7769, 1878, 7500,
	6906, 3901, 6414, 5479, 2752, 711, 1004, 8708,
	4338, 9854, 8760, 1031, 3150, 743, 967, 684,
	7982, 5422, 6089, 7801, 1017, 3190, 1700, 5919,
	5483, 6599, 7922, 2498, 3262, 4877, 2088, 1374,
	4022, 8151, 1697, 2456, 6997, 7997, 7193, 4662,
	7068, 6463, 3470, 8660, 3199, 7435, 5453, 1076,
	419, 2619, 1406, 6533, 9911, 5996, 9877, 4978,
	7672, 1304, 822, 4811, 7474, 9591, 1426, 9125,
	9955, 1525, 5834, 5706, 5982, 3518, 5423, 6252,
	1064, 2787, 605, 1021, 4464, 1705, 4838, 9614,
	319, 2323, 8396, 3547, 53, 6057, 9843, 4142,
	9535, 8053, 2223, 5879, 8446, 8236, 5036, 8137,
	9073, 2448, 8498, 6342, 6345, 9231, 4639, 9982,
	1217, 5858, 1892, 9155, 8981, 1331, 5526, 8429,
	7349, 9100, 8885, 3800, 9082, 5906, 8711, 8499,
	5398, 2333, 2499, 1358, 5396, 4550, 5870, 8484,
	5564, 9294, 9792, 6786, 1836, 6702, 1679, 9666,
	135, 7422, 5626, 6295, 7828, 7080, 3345, 185,
	3703, 6082, 2495, 8876, 5184, 3822, 7532, 8564,
	2685, 1624, 5515, 9775, 308, 9383, 8733, 3077,
	7284, 7302, 35, 9581, 4927, 7462, 4845, 3331,
	5693, 4714, 8522, 2192, 964, 8033, 2145, 732,
	5792, 9066, 856, 2601, 577, 8527, 5526, 5967,
	8391, 3060, 4344, 853, 3311, 6918, 8370, 5791,
	6755, 9258, 1964, 3862, 7326, 2755, 1576, 1675,
	119, 386, 2571, 8189, 3370, 701, 3281, 710,
	8885, 6139, 9961, 8922, 8174, 8375, 6138, 9847,
	4854, 5777, 8551, 7930, 7401, 3457, 3143, 1508,
	5753, 3694, 5993, 5228, 5480, 2515, 6763, 8335,
	9088, 4979, 7987, 5760, 3039, 5766, 5868, 1932,
	3435, 8274, 1667, 8305, 9678, 5741, 5193, 9322,
	9946, 2433, 928, 3582, 8437, 5169, 7521, 9860,
	9741, 840, 26, 7364, 2620, 7373, 1114, 7601,
	7048, 5289, 8616, 2816, 9703, 3595, 2060, 5086,
	2673, 3530, 1359, 1861, 4220, 3700, 899, 1352,
	5551, 1020, 5759, 8483, 992, 8250, 9411, 3180,
	6634, 856, 6254, 6194, 3917, 9296, 9035, 2348,
	9174, 7872, 3374, 8845, 3908, 3210, 8206, 3901,
	1083, 2442, 6626, 7538, 1519, 2002, 5375, 1211,
	4597, 1027, 8913, 2970, 5316, 2039, 3828, 9530,
	8672, 1290, 6243, 8398, 7670, 584, 8554, 9782,
	4689, 2322, 3891, 5570, 2441, 3620, 2995, 7453,
	7493, 7524, 9193, 1840, 8562, 7087, 8880, 1692,
	9390, 2120, 6310, 1186, 3800, 4528, 2717, 3715,
	4188, 848, 3877, 973, 8688, 171, 3610, 1814,
	4226, 8168, 4374, 640, 1652, 9149, 1983, 7776,
	5724, 8085, 7642, 4732, 4416, 6266, 5192, 6489,
	4151, 5721, 1778, 2708, 6310, 8698, 8896, 1888,
	8171, 3950, 4756, 4292, 2005, 4487, 6940, 3027,
	8680, 4280, 8169, 7400, 8615, 848, 4686, 4370,
	1307, 1776, 7336, 6208, 5860, 6436, 695, 2444,
	2655, 2326, 4144, 5741, 3920, 5873, 4979, 7768,
	5503, 7203, 2283, 7788, 2037, 9131, 2916, 8724,
	4754, 8308, 2395, 6739, 485, 8073, 7861, 1191,
	981, 1998, 4277, 2306, 5509, 2861, 676, 5039,
	4515, 6900, 2085, 7407, 2948, 4810, 7243, 8107,
	6124, 3955, 3517, 1027, 1467, 8102, 4121, 3754,
	9510, 2956, 3027, 944, 8889, 8388, 2269, 8781,
	8941, 503, 1588, 7452, 9731, 7045, 9086, 8895,
	90, 3144, 5569, 1415, 3996, 8866, 4640, 3533,
	3634, 4686, 8961, 5342, 8259, 8604, 9081, 9368,
	7927, 6117, 7509, 8903, 3256, 7008, 3099, 3508,
	3273, 9709, 9373, 1374, 8944, 3639, 8505, 4042,
	12, 530, 9273, 4801, 761, 4913, 6606, 6739,
	5605, 5637, 719, 6984, 1130, 1078, 8796, 4411,
	7204, 8668, 5225, 1596, 8800, 8083, 5620, 910,
	8022, 8753, 5414, 3163, 9797, 2492, 2109, 9440,
	9737, 3659, 2952, 913, 4297, 3855, 6891, 6867,
	5392, 9757, 9361, 4312, 5415, 3533, 5994, 513,
	3224, 3486, 346, 4150, 2752, 5895, 3247, 2275,
	5137, 5424, 6854, 9918, 2273, 7434, 6655, 2269,
	9720, 3915, 9785, 8604, 3799, 6065, 4070, 2204,
	2145, 4721, 6743, 8533, 4504, 4512, 8547, 8199,
	8506, 3184, 2829, 8578, 5963, 9629, 3319, 1411,
	784, 9160, 3925, 2117, 8216, 8156, 5230, 1021,
	8468, 9979, 199, 6132, 4556, 3388, 4447, 1503,
	9203, 4028, 4633, 4537, 9846, 7104, 966, 9786,
	2402, 6280, 8393, 3514, 3675, 5066, 45, 5484,
	8185, 6376, 6151, 3773, 8101, 8363, 7257, 2164,
	3548, 1215, 4667, 559, 511, 5707, 5787, 7552,
	6589, 8935, 2179, 1088, 2297, 2033, 1133, 574,
	8896, 3265, 2681, 3424, 2090, 7972, 4505, 1357,
	7108, 8543, 9500, 3580, 1116, 5400, 236, 7512,
	4229, 8918, 1198, 544, 6951, 1621, 3290, 8406,
	6135, 1400, 78, 9094, 1289, 9849, 4254, 3557,
	696, 483, 5400, 2399, 2703, 409, 1518, 1043,
	8505, 1877, 6060, 3483, 9219, 914, 4416, 2185,
	6440, 7397, 2019, 4889, 9143, 6834, 3063, 8356,
	3821, 7035, 1972, 8312, 1494, 4774, 9537, 8837,
	5645, 2248, 9105, 2307, 8597, 8588, 1190, 7930,
	8253, 8822, 6853, 69,	/* * 10000**1011 */
	 /* 65536**910 =  */ 6976, 7276, 8858, 1221, 9753, 5084, 4453, 1746,
	2564, 5306, 1580, 9569, 1433, 6440, 9350, 1312,
	163, 2607, 7092, 9083, 4624, 8203, 8919, 7749,
	3440, 6823, 6182, 2031, 7548, 5547, 4636, 5050,
	5758, 7923, 4655, 1010, 9987, 772, 7430, 7397,
	8813, 2398, 8251, 2488, 2603, 118, 1294, 227,
	9376, 9951, 3868, 1075, 5311, 7911, 4461, 8224,
	274, 2903, 9270, 3359, 2746, 3671, 2503, 7591,
	6718, 4357, 8995, 4873, 2301, 2009, 7763, 4513,
	4937, 3992, 1217, 3614, 7118, 5669, 5378, 1265,
	1379, 7102, 7925, 1319, 1768, 3234, 8757, 2335,
	3113, 1722, 6896, 563, 7461, 4313, 9102, 1117,
	9118, 9666, 6719, 1369, 4573, 3534, 3090, 3498,
	7834, 2943, 8466, 9411, 6501, 9251, 2604, 892,
	466, 4658, 6553, 3949, 377, 2602, 284, 99,
	2675, 9445, 2191, 5520, 5423, 3134, 7131, 8653,
	4866, 284, 5986, 9313, 3557, 1286, 1602, 1116,
	2596, 5249, 6799, 8663, 1549, 7218, 8045, 5368,
	8620, 85, 8305, 8144, 6653, 4913, 796, 5668,
	471, 8853, 7640, 5428, 3341, 4658, 7712, 5801,
	3405, 3699, 207, 6821, 3089, 3959, 5917, 1322,
	7214, 438, 7617, 1547, 4391, 183, 4965, 5172,
	8933, 4752, 479, 9733, 950, 7810, 5681, 3581,
	4162, 4049, 3572, 3884, 1211, 7627, 6099, 4410,
	7572, 7868, 229, 3452, 1679, 6516, 782, 9064,
	5097, 4056, 5308, 424, 847, 8447, 1214, 4563,
	763, 7166, 8506, 1912, 4796, 2775, 3847, 35,
	5471, 2069, 3525, 3321, 4709, 8304, 3015, 3633,
	1027, 9475, 4081, 15, 9395, 7495, 5293, 1385,
	707, 4543, 4533, 15, 2282, 6080, 6456, 7843,
	8776, 2104, 5874, 3666, 3846, 6178, 7517, 9013,
	1282, 5177, 3730, 5068, 2562, 1258, 266, 4640,
	9320, 2217, 1078, 8299, 3147, 5444, 2258, 6110,
	5603, 4852, 4268, 8378, 1360, 7766, 3834, 2833,
	2966, 498, 1814, 5324, 8535, 3968, 4782, 6038,
	5348, 5378, 8407, 7004, 3934, 5886, 6509, 4476,
	2518, 942, 387, 7880, 310, 2194, 789, 9524,
	3994, 6498, 4676, 2194, 7029, 1471, 7694, 9214,
	4989, 807, 9958, 2955, 1408, 9697, 9369, 4043,
	690, 8441, 3288, 8437, 1376, 4984, 1291, 8808,
	8585, 9792, 8599, 7985, 2883, 8551, 9600, 8612,
	8145, 8093, 5364, 7581, 6825, 892, 9161, 7353,
	5283, 6962, 4767, 4665, 8637, 8511, 8351, 9611,
	3276, 9081, 4325, 3128, 7232, 9014, 9828, 7083,
	2200, 3406, 4976, 3646, 4736, 5100, 1263, 7919,
	1368, 83, 7397, 8019, 626, 1181, 8554, 9738,
	9409, 5766, 9788, 6858, 6925, 6625, 9783, 5868,
	6651, 3983, 8582, 2528, 9149, 186, 7976, 295,
	4158, 4110, 3783, 1155, 1983, 4097, 2663, 3665,
	5049, 8310, 2361, 5778, 8997, 1458, 2437, 3930,
	1459, 3258, 8915, 5745, 9011, 1080, 8782, 2896,
	4877, 3522, 7368, 8059, 9387, 4871, 3417, 9118,
	6149, 5578, 2863, 325, 4461, 7766, 3619, 6858,
	6849, 1017, 9989, 7450, 1635, 5741, 6046, 8153,
	1705, 7337, 1343, 4508, 2940, 2177, 8291, 3668,
	3988, 7230, 9741, 9276, 1492, 9060, 5831, 1915,
	4323, 3327, 5156, 7634, 5667, 93, 1615, 7146,
	384, 1403, 7450, 648, 397, 3380, 8248, 1488,
	8379, 2229, 9203, 481, 9153, 8241, 705, 9533,
	7505, 3015, 9070, 125, 4603, 8425, 5131, 8879,
	2839, 4140, 6128, 5688, 1555, 2700, 6136, 9704,
	8254, 4678, 981, 264, 9401, 7255, 3538, 8116,
	2324, 280, 7020, 4111, 5298, 9315, 3155, 4012,
	8476, 2668, 2959, 543, 8033, 1389, 3592, 5881,
	3970, 1845, 1091, 1032, 5505, 9360, 7060, 667,
	6498, 9986, 6028, 6059, 2489, 6376, 6771, 8583,
	4217, 3978, 6537, 2508, 9228, 9830, 2933, 2459,
	8427, 1706, 8995, 5630, 4841, 5215, 6392, 6342,
	5770, 4998, 9239, 6236, 9028, 5774, 6114, 3192,
	5621, 2678, 2250, 3881, 2567, 9124, 9573, 1676,
	2312, 1368, 6964, 3234, 4195, 9740, 5063, 9313,
	8299, 611, 4657, 6404, 1343, 7887, 8822, 8197,
	5746, 7804, 5463, 2033, 3102, 6063, 2280, 6637,
	1051, 2474, 4788, 2287, 7937, 9814, 3499, 7309,
	1637, 7193, 6908, 5451, 3257, 2935, 3737, 3206,
	8537, 9857, 2923, 667, 1218, 3142, 9336, 5960,
	8995, 7527, 2049, 7522, 8223, 5862, 1222, 9496,
	2180, 3866, 8448, 6658, 9447, 819, 9613, 5574,
	9317, 1802, 3131, 3030, 8763, 4072, 4076, 7598,
	8667, 3937, 1660, 5038, 187, 5592, 840, 8447,
	9967, 4635, 9237, 7598, 9848, 2653, 3049, 3750,
	5699, 501, 3604, 2456, 8654, 9459, 3750, 2733,
	7222, 5883, 5306, 5175, 8727, 2434, 4666, 8910,
	7732, 2483, 1128, 8416, 8276, 4920, 5230, 732,
	264, 4622, 4744, 4607, 1765, 7218, 6301, 5284,
	5847, 9294, 9827, 7152, 5212, 7979, 7615, 346,
	9431, 9390, 6846, 4592, 3987, 9010, 6105, 7017,
	2309, 1668, 8732, 7920, 4915, 189, 4196, 2592,
	6493, 6397, 7470, 8439, 500, 7208, 5090, 7817,
	3410, 1055, 3293, 8207, 7000, 3912, 627, 465,
	5905, 6474, 2596, 2542, 778, 300, 5879, 416,
	4448, 209, 6162, 8063, 3755, 7192, 5775, 3507,
	2520, 9838, 7927, 343, 7467, 8024, 3848, 1883,
	5174, 5680, 8899, 7719, 4619, 5499, 6810, 6724,
	7123, 6290, 1740, 8554, 5207, 1737, 757, 8732,
	1574, 1745, 1252, 107, 5059, 759, 6479, 2507,
	9607, 6267, 6763, 9485, 1818, 1684, 8360, 6300,
	4553, 7822, 2597, 1854, 1975, 4238, 7314, 8224,
	6705, 8199, 4727, 7715, 2855, 6660, 1739, 3406,
	6535, 43, 1242, 296, 7753, 2009, 5291, 821,
	18, 1348, 6704, 5226, 437, 3221, 1962, 4528,
	1858, 284, 7106, 560, 2332, 416, 6562, 6435,
	2683, 5055, 1485, 3514, 9627, 1215, 6205, 1477,
	6555, 4687, 3258, 3747, 9818, 9762, 1986, 7259,
	28, 2493, 9870, 9052, 1720, 8645, 1800, 5327,
	7511, 658, 2621, 7002, 8181, 8866, 1088, 5519,
	209, 1740, 7793, 3014, 1175, 5203, 4023, 6554,
	2270, 5199, 858, 1103, 1175, 9769, 833, 2917,
	7007, 2643, 2767, 8226, 4073, 6218, 6074, 1207,
	6949, 4017, 6636, 5655, 8096, 9055, 2536, 9186,
	8843, 1363, 5220, 3307, 2440, 6009, 9620, 6050,
	1115, 4676, 3791, 977, 9909, 7363, 8927, 6256,
	62, 559, 5329, 6245, 5692, 5519, 2414, 5324,
	8526, 6190, 9466, 3871, 6430, 5570, 8518, 3076,
	4532, 8548, 1161, 3916, 9511, 356, 1491, 1877,
	5183, 6069, 4894, 9405, 3707, 6403, 8855, 6093,
	6422, 9704, 8695, 3494, 2905, 1988, 3599, 945,
	635, 4691, 3183, 3024, 9662, 835, 6925, 3011,
	3908, 2017, 5279, 8224, 4096, 9738, 901, 1320,
	2166, 1263, 9773, 1622, 5610, 5924, 4911, 7663,
	5610, 524, 6658, 5441, 179, 749, 4203, 4005,
	5667, 9337, 33, 8313, 262, 2359, 9623, 8540,
	7893, 8663, 7047, 8786, 4550, 3678, 3447, 1408,
	7314, 8285, 3199, 1835, 5737, 7556, 7294, 8703,
	8128, 9057, 8403, 4123, 6700, 6751, 1483, 9449,
	473, 4244, 8907, 6359, 5562, 1974, 3050, 8446,
	8917, 251, 6614, 7901, 1243, 9635, 3181, 8615,
	5248, 5140, 9350, 5142, 76, 6633, 8022, 4730,
	1918, 6607, 7956, 7681, 8077, 1116, 271, 5575,
	3878, 500, 2472, 7001, 5866, 7249, 1797, 9779,
	6083, 6938, 6244, 6041, 5725, 4592, 9808, 346,
	7514, 8583, 4325, 4357, 2303, 7553, 2057, 7873,
	731, 3634, 4935, 6612, 993, 341, 4071, 9185,
	9884, 4686, 1924, 487, 2122, 3551, 8157, 4261,
	5804, 9007, 3999, 7058, 2929, 3813, 6266, 9248,
	3732, 7720, 2932, 4846, 9009, 5513, 386, 5866,
	6709, 1187, 3069, 5947, 1009, 1673, 5145, 992,
	/* * 10000**1095 */
	 /* 65536**980 =  */ 2176, 248, 1520, 1891, 317, 4171, 757, 8470,
	652, 7083, 8338, 6493, 4307, 8339, 1485, 8274,
	9486, 5402, 7939, 165, 7113, 9646, 2927, 6165,
	5955, 9620, 9187, 4373, 6839, 1506, 6488, 8229,
	4865, 6749, 5419, 1020, 7004, 8972, 3246, 7404,
	935, 2842, 1856, 9433, 2067, 6350, 9296, 492,
	9336, 8036, 7456, 4970, 3370, 6744, 9291, 1339,
	3023, 9520, 6938, 491, 7452, 8359, 9349, 6900,
	9125, 4234, 4245, 4886, 8311, 2065, 9189, 8952,
	303, 5958, 7274, 6088, 2313, 4527, 7803, 2173,
	3259, 8336, 7826, 2669, 367, 1056, 4270, 5660,
	9691, 4897, 3869, 7976, 41, 1111, 2781, 7089,
	4609, 8652, 164, 7944, 9031, 1555, 5491, 3585,
	2999, 3852, 8420, 7772, 969, 8120, 5102, 4406,
	1136, 1437, 3008, 2149, 599, 7074, 9892, 5579,
	9743, 5835, 8891, 5006, 5570, 2243, 384, 6609,
	1133, 7279, 8904, 2863, 3066, 2014, 8748, 4461,
	2650, 1866, 288, 6998, 5516, 3897, 1166, 9797,
	8531, 8250, 7831, 3696, 870, 7023, 389, 7558,
	1999, 8258, 2046, 7513, 2811, 8238, 1173, 5128,
	122, 4675, 7237, 8182, 9434, 3240, 8220, 7546,
	8358, 9730, 9714, 8782, 2992, 8324, 9009, 9726,
	7008, 9997, 5661, 2033, 1192, 761, 4021, 7857,
	8964, 6300, 3078, 4631, 3885, 8829, 5412, 8533,
	4943, 9925, 503, 4646, 296, 8615, 1814, 2856,
	7475, 6102, 8949, 418, 9540, 2480, 2129, 7414,
	9899, 4415, 2420, 2374, 8697, 8448, 8389, 7107,
	1253, 1244, 5943, 7751, 5903, 2021, 1474, 7634,
	7301, 718, 3185, 8741, 2753, 2589, 7111, 6699,
	2626, 2326, 3628, 9551, 9923, 2100, 4313, 7508,
	9937, 857, 1179, 1855, 629, 1816, 5015, 4599,
	2703, 2364, 5149, 2416, 7588, 8446, 9864, 9747,
	852, 1958, 6390, 9211, 613, 3992, 2800, 79,
	6870, 5815, 7821, 8733, 9913, 4655, 3430, 5757,
	986, 8621, 7406, 8629, 7657, 9176, 9632, 1725,
	1371, 2317, 8136, 3049, 6937, 4684, 9733, 1710,
	5797, 5178, 3269, 189, 2095, 3335, 4981, 5396,
	4385, 4817, 1469, 2289, 4091, 2694, 7790, 8184,
	3667, 4975, 6886, 9264, 718, 8665, 388, 712,
	2259, 1874, 3031, 5644, 9660, 8683, 8488, 5076,
	9643, 9501, 1888, 5081, 1651, 4604, 4374, 8112,
	2414, 6612, 9929, 6241, 5596, 1128, 2103, 4114,
	6934, 3602, 1823, 2207, 5530, 2980, 2658, 5633,
	6674, 7776, 5101, 8530, 1935, 7744, 1424, 8220,
	8128, 4931, 1355, 7845, 6170, 9867, 6584, 6935,
	6795, 5163, 7645, 7867, 4345, 344, 1026, 2615,
	2625, 8149, 5050, 6811, 7299, 8987, 7386, 8553,
	7549, 2918, 4748, 950, 8418, 2389, 7522, 2261,
	255, 8942, 7767, 6011, 820, 8949, 5517, 490,
	5373, 781, 9901, 6177, 3439, 4703, 1761, 5121,
	7534, 7327, 4637, 4787, 4313, 3097, 3202, 1610,
	2764, 3750, 4394, 8205, 1931, 1077, 5151, 1179,
	4549, 5279, 8522, 4711, 3315, 4642, 5964, 6940,
	6983, 6916, 5068, 9367, 1156, 9702, 6608, 670,
	195, 1247, 328, 7188, 4002, 5834, 5307, 684,
	8962, 2762, 7862, 5007, 9687, 9931, 7972, 6337,
	4225, 5619, 4964, 8533, 6248, 7185, 4312, 6265,
	5874, 6340, 5018, 6652, 8458, 5872, 770, 554,
	1302, 4058, 8248, 4358, 4652, 6024, 890, 4875,
	2705, 5584, 7538, 976, 5571, 360, 1820, 3412,
	6038, 6315, 9315, 6561, 4197, 4690, 9422, 9752,
	3733, 7172, 9556, 3042, 4647, 5338, 6505, 5121,
	2219, 6640, 8273, 1078, 8827, 2091, 623, 6853,
	6117, 9542, 8504, 5937, 2070, 8902, 4059, 8539,
	8624, 8109, 4590, 1628, 6268, 9461, 7165, 9491,
	4033, 4220, 8426, 396, 2679, 1851, 8628, 3905,
	1106, 4994, 2277, 6769, 4436, 3506, 5218, 8859,
	7428, 7126, 4193, 6588, 1522, 6658, 2167, 4533,
	2632, 8226, 468, 5175, 8409, 9024, 9564, 1863,
	4504, 9182, 2197, 8657, 8529, 1546, 4264, 9014,
	6824, 106, 5357, 8213, 8963, 3340, 638, 1656,
	9952, 4541, 1058, 8801, 9759, 2222, 2920, 1735,
	5882, 321, 1602, 2695, 8764, 2383, 9357, 6416,
	6598, 2886, 4225, 3840, 2473, 2140, 3062, 7970,
	8073, 9445, 2112, 8917, 2596, 171, 5587, 524,
	8222, 6139, 3895, 9767, 2438, 2422, 2005, 5505,
	4947, 4718, 5294, 2535, 7980, 951, 8984, 1407,
	1440, 3542, 2134, 3317, 4770, 128, 8450, 1947,
	1460, 3424, 5633, 2582, 649, 519, 8207, 6121,
	6139, 9894, 9980, 1710, 9769, 5225, 284, 7703,
	2624, 8299, 8939, 3596, 6656, 2936, 4770, 147,
	2739, 1940, 8867, 4694, 9518, 867, 3069, 9403,
	9348, 2490, 1169, 8508, 853, 8050, 131, 3801,
	3028, 6506, 5448, 2260, 8910, 5919, 670, 1208,
	1218, 228, 6106, 2550, 9642, 6253, 1298, 6945,
	9839, 7653, 3981, 9028, 4597, 4675, 4894, 9260,
	6700, 9025, 5944, 4541, 5170, 3888, 2026, 1647,
	8420, 4215, 2651, 1370, 5805, 7668, 9641, 8292,
	4721, 5231, 8320, 3, 8444, 2102, 1581, 3061,
	1034, 5466, 910, 9717, 9852, 6767, 317, 2826,
	4926, 9635, 1398, 9416, 1139, 6713, 1096, 9345,
	6737, 548, 7124, 4403, 2439, 8806, 9365, 5021,
	9528, 9613, 6181, 4633, 9610, 2617, 9828, 3195,
	3306, 9236, 1650, 1103, 5701, 2131, 2941, 5509,
	5556, 1853, 1247, 2983, 5129, 8837, 2623, 9853,
	8119, 5778, 9731, 5106, 6842, 7995, 301, 6820,
	2110, 7373, 8539, 3599, 6848, 5821, 5314, 3069,
	9753, 5159, 8600, 7729, 5936, 924, 3160, 4973,
	3849, 5006, 3502, 9551, 5341, 1601, 1092, 433,
	1572, 5946, 6038, 3545, 5322, 2411, 9889, 7641,
	8900, 6192, 9858, 1043, 4811, 3308, 7779, 2545,
	7963, 6558, 74, 8987, 5722, 5026, 2881, 4719,
	5084, 9274, 5489, 1330, 1686, 9460, 4437, 8446,
	2075, 4792, 6219, 9685, 612, 5747, 4490, 3931,
	5705, 3583, 4775, 5449, 1695, 6443, 8344, 8509,
	9209, 6503, 2965, 6959, 2726, 1628, 296, 2447,
	1438, 1914, 5386, 8362, 4148, 4979, 9400, 8414,
	9300, 8354, 7531, 9950, 5125, 8849, 2939, 1847,
	7962, 1124, 851, 2943, 9872, 5655, 797, 4552,
	7777, 7723, 8476, 5346, 977, 3644, 9120, 7364,
	4835, 8669, 9157, 9672, 7818, 8654, 9068, 7482,
	1642, 6578, 7998, 1898, 9438, 1015, 8315, 7132,
	1764, 8202, 5622, 1460, 8768, 3457, 111, 8793,
	6904, 8641, 1212, 6691, 5575, 2788, 7815, 646,
	3034, 3167, 1541, 3614, 162, 7023, 3217, 8610,
	4669, 346, 9747, 4128, 7411, 53, 1844, 2454,
	5512, 4377, 5549, 9197, 2988, 5800, 7230, 6270,
	9887, 4439, 1073, 2705, 9696, 4646, 7107, 9250,
	4806, 9598, 6577, 1310, 9339, 8418, 8519, 5917,
	2358, 1093, 9989, 8004, 3372, 6136, 4321, 4657,
	6000, 5693, 2462, 3856, 4089, 2522, 6144, 8267,
	3376, 9923, 9328, 5582, 2740, 8429, 3047, 511,
	9284, 6246, 5686, 7135, 4976, 1175, 4120, 9157,
	8525, 7158, 4119, 8361, 1810, 4566, 666, 6241,
	3896, 4733, 3696, 9610, 5365, 9852, 8767, 1301,
	5871, 8539, 682, 4994, 1086, 7813, 851, 5979,
	2648, 3138, 9995, 4591, 263, 5236, 8753, 7364,
	3999, 461, 2585, 7108, 306, 5152, 2741, 1754,
	4543, 9288, 1672, 2058, 6221, 4785, 1733, 909,
	6084, 7208, 7617, 673, 3060, 8661, 4417, 2233,
	8342, 9571, 6460, 6889, 2706, 3929, 5167, 967,
	6966, 9916, 6571, 6214, 6145, 9200, 1010, 2198,
	9079, 2821, 7049, 6905, 8235, 6461, 4953, 8649,
	905, 407, 9711, 2323, 2666, 2091, 1025, 5391,
	1241, 6737, 9248, 9298, 8450, 9319, 1462, 9150,
	1607, 4170, 6541, 7781, 1467, 8420, 5376, 194,
	6651, 7415, 513, 3578, 2889, 6835, 4776, 4085,
	538, 8155, 3194, 9467, 2105, 8505, 7369, 4793,
	4217, 9718, 8891, 3626, 1771, 8721, 116, 5540,
	7326, 3918, 6894, 8012, 4180, 7138, 5236, 5303,
	2602, 3564, 9007, 5662, 4729, 6969, 4493, 4929,
	1502, 5857, 8687, 97, 3912, 4519, 8216, 5498,
	4214, 8063, 1746, 8592, 9702, 9017, 1531, 1223,
	4247, 820, 4218, 1186, 3587, 9973, 1734, 1297,
	8275, 2024, 9920, 6071, 5908, 4298, 895, 3902,
	2619, 2039, 8559, 2462, 332, 8129, 2696, 7156,
	5009, 5726, 4366, 8780, 2654, 2723, 4871, 244,
	1015, 9987, 1781, 4136, 1,	/* * 10000**1180 */
0};				/* end powers of 65536 in base 10000 */

unsigned short  _start_big_powers_two[] = {
	0, 1, 86, 255, 508, 846, 1268, 1774,
	2365, 3040, 3799, 4642, 5570, 6582, 7678, 8859,

0};				/* end _start_big_powers_two */
