/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2008 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"%Z%%M%	%I%	%E% SMI"

#include "lint.h"
#include <sys/types.h>

/* table of 16 multiples of 10**64 */
const unsigned short __tbl_10_big_digits [] = { 1,
/* 10**64 = */
7937 /* h   64 */, 49002 /* h   80 */, 60772 /* h   96 */, 28216 /* h  112 */,
38893 /* h  128 */, 55975 /* h  144 */, 63988 /* h  160 */, 59711 /* h  176 */,
20227 /* h  192 */, 24 /* h  208 */,
/* 10**128 = */
15873 /* h  128 */, 11925 /* h  144 */, 39177 /* h  160 */, 991 /* h  176 */,
14589 /* h  192 */, 3861 /* h  208 */, 58415 /* h  224 */, 9076 /* h  240 */,
62956 /* h  256 */, 54223 /* h  272 */, 56328 /* h  288 */, 50180 /* h  304 */,
45274 /* h  320 */, 48333 /* h  336 */, 32537 /* h  352 */, 42547 /* h  368 */,
9731 /* h  384 */, 59679 /* h  400 */, 590 /* h  416 */,
/* 10**192 = */
23809 /* h  192 */, 44161 /* h  208 */, 32287 /* h  224 */, 43489 /* h  240 */,
57637 /* h  256 */, 25618 /* h  272 */, 47998 /* h  288 */, 30365 /* h  304 */,
41030 /* h  320 */, 61880 /* h  336 */, 15488 /* h  352 */, 65191 /* h  368 */,
53068 /* h  384 */, 59042 /* h  400 */, 53249 /* h  416 */, 29613 /* h  432 */,
36076 /* h  448 */, 54840 /* h  464 */, 25225 /* h  480 */, 50116 /* h  496 */,
50437 /* h  512 */, 64798 /* h  528 */, 63636 /* h  544 */, 41326 /* h  560 */,
54618 /* h  576 */, 20041 /* h  592 */, 15843 /* h  608 */, 14364 /* h  624 */,

/* 10**256 = */
31745 /* h  256 */, 38958 /* h  272 */, 34651 /* h  288 */, 48851 /* h  304 */,
40818 /* h  320 */, 55513 /* h  336 */, 12167 /* h  352 */, 4629 /* h  368 */,
20678 /* h  384 */, 27614 /* h  400 */, 28272 /* h  416 */, 53066 /* h  432 */,
55311 /* h  448 */, 54677 /* h  464 */, 29038 /* h  480 */, 9906 /* h  496 */,
26288 /* h  512 */, 44486 /* h  528 */, 13860 /* h  544 */, 7445 /* h  560 */,
54106 /* h  576 */, 15426 /* h  592 */, 21518 /* h  608 */, 25599 /* h  624 */,
29632 /* h  640 */, 52309 /* h  656 */, 61207 /* h  672 */, 26105 /* h  688 */,
10482 /* h  704 */, 21948 /* h  720 */, 51191 /* h  736 */, 32988 /* h  752 */,
60892 /* h  768 */, 62574 /* h  784 */, 61390 /* h  800 */, 24540 /* h  816 */,
21495 /* h  832 */, 5 /* h  848 */,
/* 10**320 = */
39681 /* h  320 */, 20636 /* h  336 */, 44529 /* h  352 */, 51164 /* h  368 */,
44332 /* h  384 */, 14397 /* h  400 */, 19767 /* h  416 */, 29638 /* h  432 */,
26576 /* h  448 */, 60013 /* h  464 */, 43014 /* h  480 */, 20891 /* h  496 */,
62200 /* h  512 */, 50179 /* h  528 */, 57762 /* h  544 */, 41042 /* h  560 */,
9018 /* h  576 */, 55056 /* h  592 */, 29609 /* h  608 */, 17541 /* h  624 */,
55738 /* h  640 */, 53010 /* h  656 */, 6147 /* h  672 */, 28807 /* h  688 */,
15003 /* h  704 */, 21212 /* h  720 */, 21224 /* h  736 */, 58802 /* h  752 */,
64334 /* h  768 */, 1815 /* h  784 */, 42543 /* h  800 */, 48717 /* h  816 */,
55265 /* h  832 */, 2731 /* h  848 */, 60751 /* h  864 */, 35938 /* h  880 */,
60539 /* h  896 */, 52921 /* h  912 */, 16417 /* h  928 */, 54374 /* h  944 */,
33536 /* h  960 */, 41237 /* h  976 */, 30182 /* h  992 */, 52451 /* h 1008 */,
10738 /* h 1024 */, 33839 /* h 1040 */, 129 /* h 1056 */,
/* 10**384 = */
47617 /* h  384 */, 13515 /* h  400 */, 39062 /* h  416 */, 24801 /* h  432 */,
56885 /* h  448 */, 58007 /* h  464 */, 63325 /* h  480 */, 13127 /* h  496 */,
43663 /* h  512 */, 2194 /* h  528 */, 15468 /* h  544 */, 19711 /* h  560 */,
38999 /* h  576 */, 2326 /* h  592 */, 56241 /* h  608 */, 25026 /* h  624 */,
38925 /* h  640 */, 39293 /* h  656 */, 59094 /* h  672 */, 13480 /* h  688 */,
28501 /* h  704 */, 47405 /* h  720 */, 14435 /* h  736 */, 9008 /* h  752 */,
7014 /* h  768 */, 38046 /* h  784 */, 6697 /* h  800 */, 28306 /* h  816 */,
30765 /* h  832 */, 34427 /* h  848 */, 13189 /* h  864 */, 64566 /* h  880 */,
9079 /* h  896 */, 61881 /* h  912 */, 39895 /* h  928 */, 59853 /* h  944 */,
44772 /* h  960 */, 44064 /* h  976 */, 13681 /* h  992 */, 52133 /* h 1008 */,
4282 /* h 1024 */, 37408 /* h 1040 */, 19662 /* h 1056 */, 39363 /* h 1072 */,
47057 /* h 1088 */, 42746 /* h 1104 */, 31727 /* h 1120 */, 19985 /* h 1136 */,
20292 /* h 1152 */, 22136 /* h 1168 */, 32767 /* h 1184 */, 28930 /* h 1200 */,
35489 /* h 1216 */, 2799 /* h 1232 */, 24113 /* h 1248 */, 3148 /* h 1264 */,

/* 10**448 = */
55553 /* h  448 */, 41915 /* h  464 */, 14976 /* h  480 */, 19185 /* h  496 */,
19753 /* h  512 */, 62921 /* h  528 */, 56160 /* h  544 */, 26791 /* h  560 */,
16358 /* h  576 */, 5663 /* h  592 */, 8553 /* h  608 */, 3517 /* h  624 */,
21638 /* h  640 */, 13170 /* h  656 */, 65142 /* h  672 */, 46791 /* h  688 */,
56200 /* h  704 */, 7684 /* h  720 */, 15852 /* h  736 */, 1535 /* h  752 */,
43356 /* h  768 */, 37236 /* h  784 */, 7226 /* h  800 */, 47699 /* h  816 */,
53833 /* h  832 */, 44475 /* h  848 */, 54032 /* h  864 */, 2021 /* h  880 */,
49233 /* h  896 */, 38011 /* h  912 */, 18399 /* h  928 */, 58165 /* h  944 */,
22700 /* h  960 */, 13518 /* h  976 */, 45364 /* h  992 */, 26234 /* h 1008 */,
24769 /* h 1024 */, 62570 /* h 1040 */, 44835 /* h 1056 */, 3302 /* h 1072 */,
18302 /* h 1088 */, 29487 /* h 1104 */, 35429 /* h 1120 */, 35415 /* h 1136 */,
57911 /* h 1152 */, 983 /* h 1168 */, 42135 /* h 1184 */, 44917 /* h 1200 */,
7593 /* h 1216 */, 61255 /* h 1232 */, 20409 /* h 1248 */, 59156 /* h 1264 */,
65356 /* h 1280 */, 36869 /* h 1296 */, 6840 /* h 1312 */, 45190 /* h 1328 */,
30755 /* h 1344 */, 10350 /* h 1360 */, 29085 /* h 1376 */, 14608 /* h 1392 */,
20437 /* h 1408 */, 59303 /* h 1424 */, 55279 /* h 1440 */, 38339 /* h 1456 */,
10996 /* h 1472 */, 1 /* h 1488 */,
/* 10**512 = */
63489 /* h  512 */, 64620 /* h  528 */, 29287 /* h  544 */, 30706 /* h  560 */,
18140 /* h  576 */, 36757 /* h  592 */, 38767 /* h  608 */, 23958 /* h  624 */,
35479 /* h  640 */, 47162 /* h  656 */, 6873 /* h  672 */, 49950 /* h  688 */,
1299 /* h  704 */, 18116 /* h  720 */, 22343 /* h  736 */, 38118 /* h  752 */,
30401 /* h  768 */, 51337 /* h  784 */, 46457 /* h  800 */, 17525 /* h  816 */,
29499 /* h  832 */, 10488 /* h  848 */, 41407 /* h  864 */, 43549 /* h  880 */,
54049 /* h  896 */, 28734 /* h  912 */, 53226 /* h  928 */, 7717 /* h  944 */,
12066 /* h  960 */, 45594 /* h  976 */, 64302 /* h  992 */, 48209 /* h 1008 */,
20317 /* h 1024 */, 38625 /* h 1040 */, 60844 /* h 1056 */, 49059 /* h 1072 */,
22446 /* h 1088 */, 12956 /* h 1104 */, 29011 /* h 1120 */, 59388 /* h 1136 */,
1685 /* h 1152 */, 50172 /* h 1168 */, 6436 /* h 1184 */, 34217 /* h 1200 */,
25438 /* h 1216 */, 63839 /* h 1232 */, 36576 /* h 1248 */, 45712 /* h 1264 */,
44516 /* h 1280 */, 37803 /* h 1296 */, 29482 /* h 1312 */, 4966 /* h 1328 */,
30556 /* h 1344 */, 37961 /* h 1360 */, 23310 /* h 1376 */, 27070 /* h 1392 */,
44972 /* h 1408 */, 29507 /* h 1424 */, 48257 /* h 1440 */, 45209 /* h 1456 */,
7494 /* h 1472 */, 17831 /* h 1488 */, 38728 /* h 1504 */, 41577 /* h 1520 */,
29443 /* h 1536 */, 36016 /* h 1552 */, 7955 /* h 1568 */, 35339 /* h 1584 */,
35479 /* h 1600 */, 36011 /* h 1616 */, 14553 /* h 1632 */, 49618 /* h 1648 */,
5588 /* h 1664 */, 25396 /* h 1680 */, 28 /* h 1696 */,
/* 10**576 = */
5889 /* h  576 */, 40415 /* h  592 */, 43396 /* h  608 */, 62098 /* h  624 */,
46788 /* h  640 */, 5527 /* h  656 */, 12608 /* h  672 */, 53499 /* h  688 */,
894 /* h  704 */, 57905 /* h  720 */, 60211 /* h  736 */, 54726 /* h  752 */,
13372 /* h  768 */, 41773 /* h  784 */, 52867 /* h  800 */, 64976 /* h  816 */,
37019 /* h  832 */, 44074 /* h  848 */, 25066 /* h  864 */, 4147 /* h  880 */,
36736 /* h  896 */, 5331 /* h  912 */, 44839 /* h  928 */, 46020 /* h  944 */,
54418 /* h  960 */, 16627 /* h  976 */, 58732 /* h  992 */, 50588 /* h 1008 */,
46341 /* h 1024 */, 59813 /* h 1040 */, 51419 /* h 1056 */, 50158 /* h 1072 */,
52385 /* h 1088 */, 53825 /* h 1104 */, 27502 /* h 1120 */, 42692 /* h 1136 */,
27685 /* h 1152 */, 58683 /* h 1168 */, 30432 /* h 1184 */, 15110 /* h 1200 */,
6136 /* h 1216 */, 14129 /* h 1232 */, 35390 /* h 1248 */, 4163 /* h 1264 */,
52032 /* h 1280 */, 40459 /* h 1296 */, 36572 /* h 1312 */, 46867 /* h 1328 */,
9995 /* h 1344 */, 10048 /* h 1360 */, 482 /* h 1376 */, 18393 /* h 1392 */,
5580 /* h 1408 */, 4411 /* h 1424 */, 59319 /* h 1440 */, 13534 /* h 1456 */,
18490 /* h 1472 */, 57100 /* h 1488 */, 44012 /* h 1504 */, 48676 /* h 1520 */,
42431 /* h 1536 */, 53074 /* h 1552 */, 1227 /* h 1568 */, 28217 /* h 1584 */,
40214 /* h 1600 */, 47009 /* h 1616 */, 1225 /* h 1632 */, 59212 /* h 1648 */,
7171 /* h 1664 */, 18302 /* h 1680 */, 24664 /* h 1696 */, 35113 /* h 1712 */,
52511 /* h 1728 */, 19426 /* h 1744 */, 36902 /* h 1760 */, 5839 /* h 1776 */,
28051 /* h 1792 */, 64536 /* h 1808 */, 44859 /* h 1824 */, 62235 /* h 1840 */,
40535 /* h 1856 */, 9645 /* h 1872 */, 4078 /* h 1888 */, 690 /* h 1904 */,

/* 10**640 = */
13825 /* h  640 */, 59154 /* h  656 */, 29327 /* h  672 */, 33141 /* h  688 */,
45802 /* h  704 */, 17940 /* h  720 */, 59760 /* h  736 */, 36694 /* h  752 */,
22155 /* h  768 */, 60201 /* h  784 */, 11650 /* h  800 */, 46924 /* h  816 */,
36101 /* h  832 */, 18609 /* h  848 */, 49417 /* h  864 */, 9289 /* h  880 */,
50534 /* h  896 */, 22076 /* h  912 */, 23203 /* h  928 */, 55943 /* h  944 */,
28845 /* h  960 */, 58394 /* h  976 */, 10093 /* h  992 */, 30548 /* h 1008 */,
56810 /* h 1024 */, 14154 /* h 1040 */, 16382 /* h 1056 */, 57596 /* h 1072 */,
35836 /* h 1088 */, 15805 /* h 1104 */, 24001 /* h 1120 */, 9608 /* h 1136 */,
2156 /* h 1152 */, 11217 /* h 1168 */, 7141 /* h 1184 */, 24396 /* h 1200 */,
33892 /* h 1216 */, 13615 /* h 1232 */, 128 /* h 1248 */, 60835 /* h 1264 */,
40751 /* h 1280 */, 6911 /* h 1296 */, 61972 /* h 1312 */, 9398 /* h 1328 */,
8583 /* h 1344 */, 38186 /* h 1360 */, 17693 /* h 1376 */, 36309 /* h 1392 */,
45466 /* h 1408 */, 52367 /* h 1424 */, 6140 /* h 1440 */, 58138 /* h 1456 */,
61052 /* h 1472 */, 56185 /* h 1488 */, 19527 /* h 1504 */, 45057 /* h 1520 */,
4543 /* h 1536 */, 52820 /* h 1552 */, 34598 /* h 1568 */, 3638 /* h 1584 */,
62032 /* h 1600 */, 56807 /* h 1616 */, 54436 /* h 1632 */, 31169 /* h 1648 */,
54998 /* h 1664 */, 39220 /* h 1680 */, 49273 /* h 1696 */, 17223 /* h 1712 */,
26688 /* h 1728 */, 5620 /* h 1744 */, 23250 /* h 1760 */, 18495 /* h 1776 */,
31230 /* h 1792 */, 13478 /* h 1808 */, 23808 /* h 1824 */, 52192 /* h 1840 */,
56240 /* h 1856 */, 14736 /* h 1872 */, 3750 /* h 1888 */, 38599 /* h 1904 */,
51304 /* h 1920 */, 42805 /* h 1936 */, 59534 /* h 1952 */, 14995 /* h 1968 */,
38734 /* h 1984 */, 21262 /* h 2000 */, 29048 /* h 2016 */, 22085 /* h 2032 */,
19314 /* h 2048 */, 20110 /* h 2064 */, 62117 /* h 2080 */, 31688 /* h 2096 */,
16774 /* h 2112 */,
/* 10**704 = */
21761 /* h  704 */, 14086 /* h  720 */, 10436 /* h  736 */, 58533 /* h  752 */,
16881 /* h  768 */, 50049 /* h  784 */, 24497 /* h  800 */, 33052 /* h  816 */,
49251 /* h  832 */, 21527 /* h  848 */, 27815 /* h  864 */, 15985 /* h  880 */,
32985 /* h  896 */, 61603 /* h  912 */, 11895 /* h  928 */, 55977 /* h  944 */,
32011 /* h  960 */, 64273 /* h  976 */, 44380 /* h  992 */, 26071 /* h 1008 */,
9318 /* h 1024 */, 47158 /* h 1040 */, 21080 /* h 1056 */, 26244 /* h 1072 */,
36799 /* h 1088 */, 63285 /* h 1104 */, 30063 /* h 1120 */, 7922 /* h 1136 */,
33639 /* h 1152 */, 62662 /* h 1168 */, 29433 /* h 1184 */, 28354 /* h 1200 */,
23922 /* h 1216 */, 13307 /* h 1232 */, 24207 /* h 1248 */, 17417 /* h 1264 */,
24339 /* h 1280 */, 5230 /* h 1296 */, 56720 /* h 1312 */, 48913 /* h 1328 */,
42177 /* h 1344 */, 57677 /* h 1360 */, 51874 /* h 1376 */, 56300 /* h 1392 */,
36516 /* h 1408 */, 44787 /* h 1424 */, 58896 /* h 1440 */, 64122 /* h 1456 */,
25490 /* h 1472 */, 36585 /* h 1488 */, 57754 /* h 1504 */, 10063 /* h 1520 */,
27525 /* h 1536 */, 22667 /* h 1552 */, 12283 /* h 1568 */, 7657 /* h 1584 */,
40560 /* h 1600 */, 7758 /* h 1616 */, 48235 /* h 1632 */, 872 /* h 1648 */,
53438 /* h 1664 */, 29541 /* h 1680 */, 48384 /* h 1696 */, 14886 /* h 1712 */,
46731 /* h 1728 */, 1036 /* h 1744 */, 63540 /* h 1760 */, 47047 /* h 1776 */,
4826 /* h 1792 */, 33122 /* h 1808 */, 51418 /* h 1824 */, 62613 /* h 1840 */,
19196 /* h 1856 */, 1740 /* h 1872 */, 53061 /* h 1888 */, 28453 /* h 1904 */,
50658 /* h 1920 */, 63958 /* h 1936 */, 60703 /* h 1952 */, 52541 /* h 1968 */,
36464 /* h 1984 */, 42250 /* h 2000 */, 33491 /* h 2016 */, 62033 /* h 2032 */,
17072 /* h 2048 */, 39570 /* h 2064 */, 25579 /* h 2080 */, 38658 /* h 2096 */,
31632 /* h 2112 */, 34304 /* h 2128 */, 5250 /* h 2144 */, 59825 /* h 2160 */,
57829 /* h 2176 */, 6980 /* h 2192 */, 4980 /* h 2208 */, 34569 /* h 2224 */,
8081 /* h 2240 */, 60778 /* h 2256 */, 3676 /* h 2272 */, 64632 /* h 2288 */,
6992 /* h 2304 */, 14549 /* h 2320 */, 6 /* h 2336 */,
/* 10**768 = */
29697 /* h  768 */, 60603 /* h  784 */, 36572 /* h  800 */, 35908 /* h  816 */,
4315 /* h  832 */, 40631 /* h  848 */, 47738 /* h  864 */, 52386 /* h  880 */,
34802 /* h  896 */, 8035 /* h  912 */, 58590 /* h  928 */, 31308 /* h  944 */,
10262 /* h  960 */, 45847 /* h  976 */, 40058 /* h  992 */, 29734 /* h 1008 */,
13919 /* h 1024 */, 62655 /* h 1040 */, 50800 /* h 1056 */, 52480 /* h 1072 */,
47081 /* h 1088 */, 27105 /* h 1104 */, 22566 /* h 1120 */, 34521 /* h 1136 */,
63662 /* h 1152 */, 4977 /* h 1168 */, 47523 /* h 1184 */, 7001 /* h 1200 */,
54371 /* h 1216 */, 40532 /* h 1232 */, 1208 /* h 1248 */, 12979 /* h 1264 */,
15526 /* h 1280 */, 53577 /* h 1296 */, 35475 /* h 1312 */, 58205 /* h 1328 */,
32315 /* h 1344 */, 25689 /* h 1360 */, 775 /* h 1376 */, 52263 /* h 1392 */,
59162 /* h 1408 */, 36648 /* h 1424 */, 10052 /* h 1440 */, 7171 /* h 1456 */,
49122 /* h 1472 */, 58185 /* h 1488 */, 50926 /* h 1504 */, 17489 /* h 1520 */,
36154 /* h 1536 */, 64722 /* h 1552 */, 35413 /* h 1568 */, 32749 /* h 1584 */,
33774 /* h 1600 */, 59870 /* h 1616 */, 7238 /* h 1632 */, 24287 /* h 1648 */,
63967 /* h 1664 */, 5253 /* h 1680 */, 40020 /* h 1696 */, 37776 /* h 1712 */,
25019 /* h 1728 */, 53302 /* h 1744 */, 10682 /* h 1760 */, 27678 /* h 1776 */,
38103 /* h 1792 */, 29845 /* h 1808 */, 17250 /* h 1824 */, 22288 /* h 1840 */,
26266 /* h 1856 */, 12663 /* h 1872 */, 2926 /* h 1888 */, 16149 /* h 1904 */,
4317 /* h 1920 */, 61204 /* h 1936 */, 50423 /* h 1952 */, 42274 /* h 1968 */,
20335 /* h 1984 */, 4082 /* h 2000 */, 60420 /* h 2016 */, 21708 /* h 2032 */,
13419 /* h 2048 */, 50219 /* h 2064 */, 11389 /* h 2080 */, 28554 /* h 2096 */,
15137 /* h 2112 */, 45252 /* h 2128 */, 63676 /* h 2144 */, 30462 /* h 2160 */,
13428 /* h 2176 */, 5711 /* h 2192 */, 38461 /* h 2208 */, 33613 /* h 2224 */,
56251 /* h 2240 */, 57018 /* h 2256 */, 2389 /* h 2272 */, 21881 /* h 2288 */,
13937 /* h 2304 */, 56939 /* h 2320 */, 60747 /* h 2336 */, 19836 /* h 2352 */,
30516 /* h 2368 */, 16999 /* h 2384 */, 55226 /* h 2400 */, 59056 /* h 2416 */,
51821 /* h 2432 */, 51714 /* h 2448 */, 36159 /* h 2464 */, 35948 /* h 2480 */,
166 /* h 2496 */, 43213 /* h 2512 */, 16284 /* h 2528 */, 151 /* h 2544 */,

/* 10**832 = */
37633 /* h  832 */, 26417 /* h  848 */, 28182 /* h  864 */, 42881 /* h  880 */,
34830 /* h  896 */, 17669 /* h  912 */, 1859 /* h  928 */, 49155 /* h  944 */,
25928 /* h  960 */, 43417 /* h  976 */, 38411 /* h  992 */, 49191 /* h 1008 */,
31454 /* h 1024 */, 19844 /* h 1040 */, 26492 /* h 1056 */, 38402 /* h 1072 */,
23274 /* h 1088 */, 22057 /* h 1104 */, 11525 /* h 1120 */, 59156 /* h 1136 */,
5342 /* h 1152 */, 42501 /* h 1168 */, 27629 /* h 1184 */, 24460 /* h 1200 */,
4071 /* h 1216 */, 48040 /* h 1232 */, 45530 /* h 1248 */, 1827 /* h 1264 */,
28267 /* h 1280 */, 88 /* h 1296 */, 56314 /* h 1312 */, 36885 /* h 1328 */,
37942 /* h 1344 */, 27415 /* h 1360 */, 42175 /* h 1376 */, 15748 /* h 1392 */,
31794 /* h 1408 */, 3306 /* h 1424 */, 1811 /* h 1440 */, 53186 /* h 1456 */,
10106 /* h 1472 */, 330 /* h 1488 */, 7101 /* h 1504 */, 54306 /* h 1520 */,
28902 /* h 1536 */, 49038 /* h 1552 */, 27976 /* h 1568 */, 63443 /* h 1584 */,
55146 /* h 1600 */, 28043 /* h 1616 */, 44979 /* h 1632 */, 23831 /* h 1648 */,
388 /* h 1664 */, 63522 /* h 1680 */, 54665 /* h 1696 */, 62349 /* h 1712 */,
11029 /* h 1728 */, 4728 /* h 1744 */, 38589 /* h 1760 */, 9888 /* h 1776 */,
10356 /* h 1792 */, 40270 /* h 1808 */, 38880 /* h 1824 */, 10620 /* h 1840 */,
10148 /* h 1856 */, 7709 /* h 1872 */, 28873 /* h 1888 */, 8875 /* h 1904 */,
44248 /* h 1920 */, 11313 /* h 1936 */, 62588 /* h 1952 */, 10140 /* h 1968 */,
8769 /* h 1984 */, 29466 /* h 2000 */, 51169 /* h 2016 */, 38463 /* h 2032 */,
42038 /* h 2048 */, 15184 /* h 2064 */, 40664 /* h 2080 */, 1977 /* h 2096 */,
56951 /* h 2112 */, 32426 /* h 2128 */, 50489 /* h 2144 */, 40259 /* h 2160 */,
48292 /* h 2176 */, 10832 /* h 2192 */, 41177 /* h 2208 */, 62821 /* h 2224 */,
36385 /* h 2240 */, 27474 /* h 2256 */, 1130 /* h 2272 */, 13148 /* h 2288 */,
10506 /* h 2304 */, 60370 /* h 2320 */, 1546 /* h 2336 */, 33638 /* h 2352 */,
29094 /* h 2368 */, 37710 /* h 2384 */, 16719 /* h 2400 */, 7706 /* h 2416 */,
57459 /* h 2432 */, 19434 /* h 2448 */, 22383 /* h 2464 */, 50095 /* h 2480 */,
19445 /* h 2496 */, 27159 /* h 2512 */, 38375 /* h 2528 */, 36889 /* h 2544 */,
21685 /* h 2560 */, 23352 /* h 2576 */, 13748 /* h 2592 */, 4268 /* h 2608 */,
46370 /* h 2624 */, 24787 /* h 2640 */, 23244 /* h 2656 */, 5222 /* h 2672 */,
57905 /* h 2688 */, 14320 /* h 2704 */, 47319 /* h 2720 */, 42400 /* h 2736 */,
3676 /* h 2752 */,
/* 10**896 = */
45569 /* h  896 */, 1384 /* h  912 */, 13614 /* h  928 */, 27336 /* h  944 */,
34890 /* h  960 */, 45699 /* h  976 */, 39403 /* h  992 */, 27973 /* h 1008 */,
59990 /* h 1024 */, 30723 /* h 1040 */, 56520 /* h 1056 */, 54477 /* h 1072 */,
44628 /* h 1088 */, 46659 /* h 1104 */, 21414 /* h 1120 */, 58826 /* h 1136 */,
39152 /* h 1152 */, 42063 /* h 1168 */, 48675 /* h 1184 */, 32981 /* h 1200 */,
51209 /* h 1216 */, 49696 /* h 1232 */, 31667 /* h 1248 */, 29454 /* h 1264 */,
17662 /* h 1280 */, 37441 /* h 1296 */, 54443 /* h 1312 */, 25422 /* h 1328 */,
33957 /* h 1344 */, 16514 /* h 1360 */, 17350 /* h 1376 */, 20473 /* h 1392 */,
63446 /* h 1408 */, 65090 /* h 1424 */, 31814 /* h 1440 */, 15769 /* h 1456 */,
34563 /* h 1472 */, 38451 /* h 1488 */, 60625 /* h 1504 */, 13044 /* h 1520 */,
39269 /* h 1536 */, 25308 /* h 1552 */, 54436 /* h 1568 */, 27284 /* h 1584 */,
63981 /* h 1600 */, 61181 /* h 1616 */, 53471 /* h 1632 */, 3296 /* h 1648 */,
21492 /* h 1664 */, 30269 /* h 1680 */, 54518 /* h 1696 */, 12095 /* h 1712 */,
28255 /* h 1728 */, 36702 /* h 1744 */, 55187 /* h 1760 */, 56302 /* h 1776 */,
58738 /* h 1792 */, 46555 /* h 1808 */, 27326 /* h 1824 */, 40782 /* h 1840 */,
30026 /* h 1856 */, 264 /* h 1872 */, 17400 /* h 1888 */, 53477 /* h 1904 */,
62343 /* h 1920 */, 25984 /* h 1936 */, 26231 /* h 1952 */, 40963 /* h 1968 */,
12177 /* h 1984 */, 25295 /* h 2000 */, 41676 /* h 2016 */, 28205 /* h 2032 */,
12306 /* h 2048 */, 46852 /* h 2064 */, 33094 /* h 2080 */, 64487 /* h 2096 */,
49780 /* h 2112 */, 33442 /* h 2128 */, 52620 /* h 2144 */, 38156 /* h 2160 */,
33401 /* h 2176 */, 63363 /* h 2192 */, 33743 /* h 2208 */, 32756 /* h 2224 */,
38342 /* h 2240 */, 13493 /* h 2256 */, 48148 /* h 2272 */, 40858 /* h 2288 */,
40880 /* h 2304 */, 54265 /* h 2320 */, 54419 /* h 2336 */, 62086 /* h 2352 */,
61359 /* h 2368 */, 44802 /* h 2384 */, 30500 /* h 2400 */, 44394 /* h 2416 */,
51502 /* h 2432 */, 23361 /* h 2448 */, 49850 /* h 2464 */, 21366 /* h 2480 */,
9716 /* h 2496 */, 3416 /* h 2512 */, 60984 /* h 2528 */, 28620 /* h 2544 */,
42260 /* h 2560 */, 23251 /* h 2576 */, 47610 /* h 2592 */, 27257 /* h 2608 */,
23766 /* h 2624 */, 65521 /* h 2640 */, 35422 /* h 2656 */, 9863 /* h 2672 */,
64744 /* h 2688 */, 30377 /* h 2704 */, 56589 /* h 2720 */, 48096 /* h 2736 */,
41582 /* h 2752 */, 59670 /* h 2768 */, 27325 /* h 2784 */, 22010 /* h 2800 */,
54222 /* h 2816 */, 33375 /* h 2832 */, 7786 /* h 2848 */, 18235 /* h 2864 */,
6926 /* h 2880 */, 3605 /* h 2896 */, 47059 /* h 2912 */, 51115 /* h 2928 */,
22105 /* h 2944 */, 23838 /* h 2960 */, 1 /* h 2976 */,
/* 10**960 = */
53505 /* h  960 */, 9824 /* h  976 */, 38754 /* h  992 */, 27704 /* h 1008 */,
4120 /* h 1024 */, 51175 /* h 1040 */, 26594 /* h 1056 */, 17388 /* h 1072 */,
8852 /* h 1088 */, 12631 /* h 1104 */, 13801 /* h 1120 */, 23532 /* h 1136 */,
5443 /* h 1152 */, 7908 /* h 1168 */, 20841 /* h 1184 */, 49240 /* h 1200 */,
37682 /* h 1216 */, 26448 /* h 1232 */, 56779 /* h 1248 */, 35561 /* h 1264 */,
36202 /* h 1280 */, 15289 /* h 1296 */, 24098 /* h 1312 */, 12495 /* h 1328 */,
8115 /* h 1344 */, 61100 /* h 1360 */, 42848 /* h 1376 */, 59026 /* h 1392 */,
32188 /* h 1408 */, 60503 /* h 1424 */, 54494 /* h 1440 */, 47558 /* h 1456 */,
37814 /* h 1472 */, 56229 /* h 1488 */, 44863 /* h 1504 */, 701 /* h 1520 */,
58480 /* h 1536 */, 21172 /* h 1552 */, 11347 /* h 1568 */, 27353 /* h 1584 */,
38080 /* h 1600 */, 65020 /* h 1616 */, 57373 /* h 1632 */, 53384 /* h 1648 */,
56846 /* h 1664 */, 59974 /* h 1680 */, 56905 /* h 1696 */, 12927 /* h 1712 */,
27791 /* h 1728 */, 64932 /* h 1744 */, 32388 /* h 1760 */, 11573 /* h 1776 */,
19250 /* h 1792 */, 48923 /* h 1808 */, 36338 /* h 1824 */, 2930 /* h 1840 */,
29588 /* h 1856 */, 9384 /* h 1872 */, 17784 /* h 1888 */, 3278 /* h 1904 */,
54824 /* h 1920 */, 26535 /* h 1936 */, 6816 /* h 1952 */, 13170 /* h 1968 */,
9182 /* h 1984 */, 60617 /* h 2000 */, 23488 /* h 2016 */, 27938 /* h 2032 */,
10050 /* h 2048 */, 59796 /* h 2064 */, 50605 /* h 2080 */, 12281 /* h 2096 */,
15868 /* h 2112 */, 55187 /* h 2128 */, 45998 /* h 2144 */, 49335 /* h 2160 */,
14067 /* h 2176 */, 26547 /* h 2192 */, 11128 /* h 2208 */, 42771 /* h 2224 */,
20442 /* h 2240 */, 55606 /* h 2256 */, 16112 /* h 2272 */, 785 /* h 2288 */,
13766 /* h 2304 */, 12629 /* h 2320 */, 60992 /* h 2336 */, 25908 /* h 2352 */,
16352 /* h 2368 */, 15867 /* h 2384 */, 57831 /* h 2400 */, 61324 /* h 2416 */,
55736 /* h 2432 */, 12919 /* h 2448 */, 26511 /* h 2464 */, 9531 /* h 2480 */,
34750 /* h 2496 */, 11313 /* h 2512 */, 16742 /* h 2528 */, 30407 /* h 2544 */,
7592 /* h 2560 */, 13539 /* h 2576 */, 60189 /* h 2592 */, 57327 /* h 2608 */,
6268 /* h 2624 */, 11130 /* h 2640 */, 42000 /* h 2656 */, 54163 /* h 2672 */,
35533 /* h 2688 */, 42083 /* h 2704 */, 24815 /* h 2720 */, 1730 /* h 2736 */,
58115 /* h 2752 */, 27710 /* h 2768 */, 29783 /* h 2784 */, 4855 /* h 2800 */,
15169 /* h 2816 */, 18862 /* h 2832 */, 57950 /* h 2848 */, 8297 /* h 2864 */,
8733 /* h 2880 */, 34402 /* h 2896 */, 7850 /* h 2912 */, 2811 /* h 2928 */,
55708 /* h 2944 */, 7835 /* h 2960 */, 40373 /* h 2976 */, 18965 /* h 2992 */,
48209 /* h 3008 */, 46925 /* h 3024 */, 62677 /* h 3040 */, 17198 /* h 3056 */,
40525 /* h 3072 */, 23063 /* h 3088 */, 3241 /* h 3104 */, 62578 /* h 3120 */,
19379 /* h 3136 */, 51843 /* h 3152 */, 9881 /* h 3168 */, 33 /* h 3184 */,

0};

/* table of starting indexes into previous table */
const unsigned short __tbl_10_big_start [] = {
0, 1, 11, 30, 58, 96, 143, 199,
265, 340, 424, 517, 620, 732, 853, 984,
1124, 0};
