/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2008 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"%Z%%M%	%I%	%E% SMI"

#include "lint.h"
#include <sys/types.h>

/* table of 5 multiples of 10**1024 */
const unsigned short __tbl_10_huge_digits [] = { 1,
/* 10**1024 = */
61441 /* h 1024 */, 10521 /* h 1040 */, 11122 /* h 1056 */, 62811 /* h 1072 */,
8539 /* h 1088 */, 28284 /* h 1104 */, 40838 /* h 1120 */,  7874 /* h 1136 */,
20103 /* h 1152 */, 39196 /* h 1168 */,  6792 /* h 1184 */,  5573 /* h 1200 */,
50485 /* h 1216 */,  5130 /* h 1232 */,  7706 /* h 1248 */, 19581 /* h 1264 */,
55321 /* h 1280 */, 52268 /* h 1296 */, 17422 /* h 1312 */,  3793 /* h 1328 */,
13550 /* h 1344 */, 35174 /* h 1360 */, 27899 /* h 1376 */, 32225 /* h 1392 */,
63007 /* h 1408 */,  7747 /* h 1424 */, 33661 /* h 1440 */, 40910 /* h 1456 */,
11164 /* h 1472 */,  8989 /* h 1488 */, 21959 /* h 1504 */,  9022 /* h 1520 */,
24791 /* h 1536 */, 26076 /* h 1552 */,  8587 /* h 1568 */, 62545 /* h 1584 */,
53556 /* h 1600 */,  7260 /* h 1616 */, 22918 /* h 1632 */, 51555 /* h 1648 */,
48031 /* h 1664 */, 37419 /* h 1680 */, 37937 /* h 1696 */, 42984 /* h 1712 */,
10759 /* h 1728 */, 40863 /* h 1744 */, 26970 /* h 1760 */, 25278 /* h 1776 */,
17092 /* h 1792 */, 36368 /* h 1808 */, 31348 /* h 1824 */,  1115 /* h 1840 */,
7651 /* h 1856 */,  6846 /* h 1872 */,  8869 /* h 1888 */, 35544 /* h 1904 */,
50193 /* h 1920 */, 47668 /* h 1936 */, 46341 /* h 1952 */, 55316 /* h 1968 */,
57011 /* h 1984 */, 48959 /* h 2000 */,  6678 /* h 2016 */, 36805 /* h 2032 */,
38588 /* h 2048 */, 45496 /* h 2064 */, 61164 /* h 2080 */, 62829 /* h 2096 */,
27645 /* h 2112 */, 12795 /* h 2128 */, 25931 /* h 2144 */, 46836 /* h 2160 */,
13846 /* h 2176 */,  4122 /* h 2192 */, 38395 /* h 2208 */, 27509 /* h 2224 */,
18430 /* h 2240 */, 56346 /* h 2256 */, 32905 /* h 2272 */, 32985 /* h 2288 */,
42405 /* h 2304 */, 32957 /* h 2320 */, 10370 /* h 2336 */, 39456 /* h 2352 */,
3942 /* h 2368 */, 12779 /* h 2384 */,  8080 /* h 2400 */, 64655 /* h 2416 */,
13072 /* h 2432 */, 38762 /* h 2448 */, 31614 /* h 2464 */, 57962 /* h 2480 */,
13962 /* h 2496 */, 57192 /* h 2512 */, 41144 /* h 2528 */, 15587 /* h 2544 */,
25294 /* h 2560 */, 36418 /* h 2576 */, 20898 /* h 2592 */, 30115 /* h 2608 */,
46793 /* h 2624 */, 27824 /* h 2640 */, 30083 /* h 2656 */, 17497 /* h 2672 */,
25919 /* h 2688 */, 12725 /* h 2704 */, 58250 /* h 2720 */, 50006 /* h 2736 */,
43942 /* h 2752 */, 13818 /* h 2768 */, 64416 /* h 2784 */,   400 /* h 2800 */,
60754 /* h 2816 */, 40900 /* h 2832 */, 18715 /* h 2848 */, 35004 /* h 2864 */,
4426 /* h 2880 */,  5696 /* h 2896 */, 32833 /* h 2912 */,    91 /* h 2928 */,
9054 /* h 2944 */, 62707 /* h 2960 */, 17993 /* h 2976 */,  7821 /* h 2992 */,
56838 /* h 3008 */, 13992 /* h 3024 */, 21321 /* h 3040 */, 29637 /* h 3056 */,
48426 /* h 3072 */, 42982 /* h 3088 */, 38668 /* h 3104 */, 49574 /* h 3120 */,
28820 /* h 3136 */, 18200 /* h 3152 */, 18927 /* h 3168 */, 53979 /* h 3184 */,
16219 /* h 3200 */, 37484 /* h 3216 */,  2516 /* h 3232 */, 44642 /* h 3248 */,
14665 /* h 3264 */, 11587 /* h 3280 */, 41926 /* h 3296 */, 13556 /* h 3312 */,
23956 /* h 3328 */, 54320 /* h 3344 */,  6661 /* h 3360 */, 55766 /* h 3376 */,
805 /* h 3392 */,
/* 10**2048 = */
57345 /* h 2048 */,  4915 /* h 2064 */, 26725 /* h 2080 */, 58121 /* h 2096 */,
19775 /* h 2112 */, 45693 /* h 2128 */, 36303 /* h 2144 */, 18914 /* h 2160 */,
18209 /* h 2176 */, 60462 /* h 2192 */, 58196 /* h 2208 */, 61063 /* h 2224 */,
30084 /* h 2240 */, 46598 /* h 2256 */, 35515 /* h 2272 */, 13963 /* h 2288 */,
41361 /* h 2304 */, 42469 /* h 2320 */, 27989 /* h 2336 */, 11989 /* h 2352 */,
30579 /* h 2368 */, 64898 /* h 2384 */, 53570 /* h 2400 */, 59984 /* h 2416 */,
36274 /* h 2432 */, 20919 /* h 2448 */, 11422 /* h 2464 */, 38964 /* h 2480 */,
55996 /* h 2496 */, 51280 /* h 2512 */, 55025 /* h 2528 */, 34414 /* h 2544 */,
11282 /* h 2560 */,  6452 /* h 2576 */, 18823 /* h 2592 */, 37497 /* h 2608 */,
27074 /* h 2624 */, 54008 /* h 2640 */, 11850 /* h 2656 */, 26257 /* h 2672 */,
64911 /* h 2688 */, 29127 /* h 2704 */, 33837 /* h 2720 */, 22439 /* h 2736 */,
21227 /* h 2752 */,  9045 /* h 2768 */, 60876 /* h 2784 */, 64383 /* h 2800 */,
7392 /* h 2816 */, 62342 /* h 2832 */, 40161 /* h 2848 */, 14368 /* h 2864 */,
46153 /* h 2880 */, 38675 /* h 2896 */,   308 /* h 2912 */, 13505 /* h 2928 */,
21726 /* h 2944 */, 35948 /* h 2960 */, 10396 /* h 2976 */, 42920 /* h 2992 */,
26179 /* h 3008 */, 11707 /* h 3024 */, 25843 /* h 3040 */, 58315 /* h 3056 */,
65281 /* h 3072 */, 32884 /* h 3088 */, 12009 /* h 3104 */, 58249 /* h 3120 */,
32660 /* h 3136 */,  4289 /* h 3152 */, 28562 /* h 3168 */, 43249 /* h 3184 */,
7894 /* h 3200 */, 43048 /* h 3216 */, 48051 /* h 3232 */, 38522 /* h 3248 */,
5184 /* h 3264 */, 23061 /* h 3280 */, 64493 /* h 3296 */, 39250 /* h 3312 */,
7748 /* h 3328 */,  5044 /* h 3344 */,  2499 /* h 3360 */, 45030 /* h 3376 */,
42006 /* h 3392 */, 41660 /* h 3408 */, 33311 /* h 3424 */, 61713 /* h 3440 */,
25780 /* h 3456 */, 64274 /* h 3472 */, 51572 /* h 3488 */, 37306 /* h 3504 */,
54955 /* h 3520 */, 54983 /* h 3536 */, 65333 /* h 3552 */, 36424 /* h 3568 */,
48451 /* h 3584 */, 17433 /* h 3600 */, 22117 /* h 3616 */, 50342 /* h 3632 */,
21776 /* h 3648 */, 26718 /* h 3664 */, 19510 /* h 3680 */, 13141 /* h 3696 */,
34455 /* h 3712 */, 43849 /* h 3728 */,  8702 /* h 3744 */,  3517 /* h 3760 */,
18717 /* h 3776 */, 15614 /* h 3792 */, 42086 /* h 3808 */, 38957 /* h 3824 */,
19623 /* h 3840 */, 52202 /* h 3856 */,  3195 /* h 3872 */, 40465 /* h 3888 */,
27530 /* h 3904 */, 31173 /* h 3920 */, 41031 /* h 3936 */, 24517 /* h 3952 */,
3630 /* h 3968 */, 34008 /* h 3984 */, 62532 /* h 4000 */,  6825 /* h 4016 */,
8252 /* h 4032 */, 29455 /* h 4048 */, 45483 /* h 4064 */, 27223 /* h 4080 */,
63398 /* h 4096 */, 55122 /* h 4112 */, 56418 /* h 4128 */, 34727 /* h 4144 */,
17919 /* h 4160 */, 37957 /* h 4176 */,  1120 /* h 4192 */, 16486 /* h 4208 */,
42031 /* h 4224 */, 30657 /* h 4240 */, 14173 /* h 4256 */, 51628 /* h 4272 */,
55279 /* h 4288 */, 59494 /* h 4304 */, 38384 /* h 4320 */, 29766 /* h 4336 */,
35973 /* h 4352 */, 33090 /* h 4368 */, 27542 /* h 4384 */, 41468 /* h 4400 */,
31867 /* h 4416 */, 55185 /* h 4432 */, 15385 /* h 4448 */, 31728 /* h 4464 */,
60225 /* h 4480 */, 23347 /* h 4496 */, 63377 /* h 4512 */, 22293 /* h 4528 */,
44639 /* h 4544 */, 36716 /* h 4560 */,  2301 /* h 4576 */, 56071 /* h 4592 */,
44174 /* h 4608 */, 45349 /* h 4624 */, 59063 /* h 4640 */, 30812 /* h 4656 */,
33115 /* h 4672 */, 22214 /* h 4688 */, 60123 /* h 4704 */, 28486 /* h 4720 */,
48878 /* h 4736 */, 20206 /* h 4752 */, 21976 /* h 4768 */,  6483 /* h 4784 */,
56892 /* h 4800 */, 41540 /* h 4816 */, 35264 /* h 4832 */, 40307 /* h 4848 */,
6845 /* h 4864 */, 21366 /* h 4880 */, 53273 /* h 4896 */, 53145 /* h 4912 */,
49739 /* h 4928 */, 56990 /* h 4944 */, 52793 /* h 4960 */,  3446 /* h 4976 */,
45441 /* h 4992 */, 28862 /* h 5008 */, 60654 /* h 5024 */, 11861 /* h 5040 */,
24697 /* h 5056 */, 54776 /* h 5072 */, 40267 /* h 5088 */, 62829 /* h 5104 */,
34555 /* h 5120 */, 64392 /* h 5136 */, 23171 /* h 5152 */,  5103 /* h 5168 */,
17349 /* h 5184 */, 16527 /* h 5200 */, 35236 /* h 5216 */, 16179 /* h 5232 */,
31043 /* h 5248 */, 64211 /* h 5264 */, 62556 /* h 5280 */, 22732 /* h 5296 */,
63558 /* h 5312 */, 63533 /* h 5328 */, 32574 /* h 5344 */, 16732 /* h 5360 */,
59416 /* h 5376 */, 10517 /* h 5392 */, 23796 /* h 5408 */, 35645 /* h 5424 */,
24359 /* h 5440 */, 27204 /* h 5456 */, 46458 /* h 5472 */, 63707 /* h 5488 */,
112 /* h 5504 */, 51855 /* h 5520 */,  1004 /* h 5536 */, 35544 /* h 5552 */,
31796 /* h 5568 */, 45800 /* h 5584 */, 37445 /* h 5600 */,   911 /* h 5616 */,
35436 /* h 5632 */, 48861 /* h 5648 */, 57056 /* h 5664 */, 51145 /* h 5680 */,
32086 /* h 5696 */,  3756 /* h 5712 */, 64020 /* h 5728 */, 10963 /* h 5744 */,
2112 /* h 5760 */, 57566 /* h 5776 */, 26492 /* h 5792 */, 63349 /* h 5808 */,
2773 /* h 5824 */, 61885 /* h 5840 */,  8734 /* h 5856 */, 37566 /* h 5872 */,
8121 /* h 5888 */, 34810 /* h 5904 */,  1188 /* h 5920 */, 52893 /* h 5936 */,
28585 /* h 5952 */, 53955 /* h 5968 */, 28708 /* h 5984 */, 16239 /* h 6000 */,
44898 /* h 6016 */, 45096 /* h 6032 */, 21998 /* h 6048 */, 36984 /* h 6064 */,
18902 /* h 6080 */, 55358 /* h 6096 */, 50652 /* h 6112 */, 20218 /* h 6128 */,
6827 /* h 6144 */, 59157 /* h 6160 */, 35947 /* h 6176 */, 30669 /* h 6192 */,
15229 /* h 6208 */,  2677 /* h 6224 */,  2228 /* h 6240 */,  2809 /* h 6256 */,
13859 /* h 6272 */, 35992 /* h 6288 */, 12327 /* h 6304 */, 58639 /* h 6320 */,
10097 /* h 6336 */, 37922 /* h 6352 */, 58070 /* h 6368 */,  7432 /* h 6384 */,
10470 /* h 6400 */, 63465 /* h 6416 */, 23718 /* h 6432 */, 62190 /* h 6448 */,
47420 /* h 6464 */,  7009 /* h 6480 */, 38443 /* h 6496 */,  4587 /* h 6512 */,
45596 /* h 6528 */, 38472 /* h 6544 */, 52129 /* h 6560 */, 52779 /* h 6576 */,
29012 /* h 6592 */, 13559 /* h 6608 */, 48688 /* h 6624 */, 31678 /* h 6640 */,
41753 /* h 6656 */, 58662 /* h 6672 */, 10668 /* h 6688 */, 36067 /* h 6704 */,
29906 /* h 6720 */, 56906 /* h 6736 */, 21461 /* h 6752 */, 46556 /* h 6768 */,
59571 /* h 6784 */,	9 /* h 6800 */,
/* 10**3072 = */
53249 /* h 3072 */, 48717 /* h 3088 */, 17608 /* h 3104 */, 61423 /* h 3120 */,
37156 /* h 3136 */, 59735 /* h 3152 */, 13797 /* h 3168 */, 64388 /* h 3184 */,
38012 /* h 3200 */, 56481 /* h 3216 */,  8683 /* h 3232 */, 16371 /* h 3248 */,
21473 /* h 3264 */, 25132 /* h 3280 */, 57116 /* h 3296 */, 42947 /* h 3312 */,
34115 /* h 3328 */, 61068 /* h 3344 */, 40324 /* h 3360 */, 25169 /* h 3376 */,
44908 /* h 3392 */, 16351 /* h 3408 */, 20047 /* h 3424 */, 40486 /* h 3440 */,
30629 /* h 3456 */, 61631 /* h 3472 */,  1272 /* h 3488 */, 43843 /* h 3504 */,
18111 /* h 3520 */, 48583 /* h 3536 */, 20870 /* h 3552 */, 52333 /* h 3568 */,
13679 /* h 3584 */, 38931 /* h 3600 */, 40254 /* h 3616 */, 18289 /* h 3632 */,
57933 /* h 3648 */, 31555 /* h 3664 */,  3102 /* h 3680 */, 12319 /* h 3696 */,
44125 /* h 3712 */, 44090 /* h 3728 */, 13691 /* h 3744 */, 37952 /* h 3760 */,
46085 /* h 3776 */, 11184 /* h 3792 */,  7615 /* h 3808 */,  1596 /* h 3824 */,
24094 /* h 3840 */, 45230 /* h 3856 */, 20068 /* h 3872 */, 36476 /* h 3888 */,
21354 /* h 3904 */, 52188 /* h 3920 */, 35874 /* h 3936 */, 62969 /* h 3952 */,
5447 /* h 3968 */, 61888 /* h 3984 */, 41957 /* h 4000 */,  1720 /* h 4016 */,
26104 /* h 4032 */, 57954 /* h 4048 */, 41031 /* h 4064 */, 17153 /* h 4080 */,
50280 /* h 4096 */, 41435 /* h 4112 */, 58779 /* h 4128 */, 45198 /* h 4144 */,
20213 /* h 4160 */, 13320 /* h 4176 */,  7776 /* h 4192 */, 35340 /* h 4208 */,
42630 /* h 4224 */,  3112 /* h 4240 */, 55404 /* h 4256 */, 15297 /* h 4272 */,
3656 /* h 4288 */, 13152 /* h 4304 */, 53221 /* h 4320 */, 30247 /* h 4336 */,
16821 /* h 4352 */, 32250 /* h 4368 */, 49219 /* h 4384 */, 57563 /* h 4400 */,
58327 /* h 4416 */, 22823 /* h 4432 */, 13299 /* h 4448 */, 63556 /* h 4464 */,
43620 /* h 4480 */, 24178 /* h 4496 */, 21473 /* h 4512 */,  7153 /* h 4528 */,
63382 /* h 4544 */, 48638 /* h 4560 */, 14788 /* h 4576 */,  3257 /* h 4592 */,
43309 /* h 4608 */, 50938 /* h 4624 */, 63274 /* h 4640 */, 11605 /* h 4656 */,
29389 /* h 4672 */, 40623 /* h 4688 */, 46470 /* h 4704 */, 32629 /* h 4720 */,
43856 /* h 4736 */, 43159 /* h 4752 */, 21238 /* h 4768 */, 42375 /* h 4784 */,
3665 /* h 4800 */, 60719 /* h 4816 */, 58725 /* h 4832 */, 21257 /* h 4848 */,
57151 /* h 4864 */,  3457 /* h 4880 */, 19600 /* h 4896 */,  9228 /* h 4912 */,
34418 /* h 4928 */, 37680 /* h 4944 */, 26576 /* h 4960 */, 53886 /* h 4976 */,
60267 /* h 4992 */, 61332 /* h 5008 */,  1656 /* h 5024 */, 29221 /* h 5040 */,
17994 /* h 5056 */, 33667 /* h 5072 */,  5496 /* h 5088 */, 62761 /* h 5104 */,
8679 /* h 5120 */, 38051 /* h 5136 */, 31157 /* h 5152 */, 38439 /* h 5168 */,
6387 /* h 5184 */, 64900 /* h 5200 */, 40444 /* h 5216 */, 37274 /* h 5232 */,
29896 /* h 5248 */, 49848 /* h 5264 */, 62469 /* h 5280 */, 62351 /* h 5296 */,
23040 /* h 5312 */, 14947 /* h 5328 */, 50664 /* h 5344 */,  7038 /* h 5360 */,
2068 /* h 5376 */, 53065 /* h 5392 */, 30609 /* h 5408 */, 42116 /* h 5424 */,
19423 /* h 5440 */, 27458 /* h 5456 */, 27004 /* h 5472 */, 58149 /* h 5488 */,
16669 /* h 5504 */,  5027 /* h 5520 */, 25366 /* h 5536 */,  4089 /* h 5552 */,
47123 /* h 5568 */, 56420 /* h 5584 */, 45903 /* h 5600 */, 27792 /* h 5616 */,
59019 /* h 5632 */,  5400 /* h 5648 */, 29601 /* h 5664 */, 49200 /* h 5680 */,
50821 /* h 5696 */, 27203 /* h 5712 */, 30648 /* h 5728 */, 58528 /* h 5744 */,
54520 /* h 5760 */, 35965 /* h 5776 */, 57582 /* h 5792 */, 53768 /* h 5808 */,
19141 /* h 5824 */, 26077 /* h 5840 */, 53263 /* h 5856 */,  3396 /* h 5872 */,
29436 /* h 5888 */, 56626 /* h 5904 */, 33959 /* h 5920 */, 18071 /* h 5936 */,
20920 /* h 5952 */, 24746 /* h 5968 */, 27725 /* h 5984 */, 17714 /* h 6000 */,
4965 /* h 6016 */, 50394 /* h 6032 */, 23473 /* h 6048 */, 16915 /* h 6064 */,
43992 /* h 6080 */, 40929 /* h 6096 */, 37688 /* h 6112 */, 42704 /* h 6128 */,
19151 /* h 6144 */, 47014 /* h 6160 */, 33887 /* h 6176 */, 42260 /* h 6192 */,
28967 /* h 6208 */, 13738 /* h 6224 */, 56016 /* h 6240 */, 46108 /* h 6256 */,
30253 /* h 6272 */, 17724 /* h 6288 */, 33913 /* h 6304 */, 32618 /* h 6320 */,
61415 /* h 6336 */, 21227 /* h 6352 */, 39384 /* h 6368 */, 61445 /* h 6384 */,
7090 /* h 6400 */, 61064 /* h 6416 */,  8842 /* h 6432 */, 16916 /* h 6448 */,
12944 /* h 6464 */, 21383 /* h 6480 */, 39164 /* h 6496 */, 35653 /* h 6512 */,
20234 /* h 6528 */,  6706 /* h 6544 */,  8141 /* h 6560 */, 17159 /* h 6576 */,
50317 /* h 6592 */, 33761 /* h 6608 */, 17775 /* h 6624 */, 57301 /* h 6640 */,
63931 /* h 6656 */,  2320 /* h 6672 */, 38549 /* h 6688 */, 22047 /* h 6704 */,
36483 /* h 6720 */, 53205 /* h 6736 */, 43717 /* h 6752 */, 64521 /* h 6768 */,
48063 /* h 6784 */, 19316 /* h 6800 */, 46382 /* h 6816 */, 50140 /* h 6832 */,
50866 /* h 6848 */, 37768 /* h 6864 */, 61022 /* h 6880 */, 62899 /* h 6896 */,
5906 /* h 6912 */, 38760 /* h 6928 */, 56884 /* h 6944 */, 17168 /* h 6960 */,
16793 /* h 6976 */, 10474 /* h 6992 */, 29156 /* h 7008 */, 23427 /* h 7024 */,
62538 /* h 7040 */, 38020 /* h 7056 */,  7389 /* h 7072 */,  8883 /* h 7088 */,
49876 /* h 7104 */, 47057 /* h 7120 */, 12629 /* h 7136 */, 59162 /* h 7152 */,
18189 /* h 7168 */, 25118 /* h 7184 */, 26994 /* h 7200 */,  9139 /* h 7216 */,
36076 /* h 7232 */,   954 /* h 7248 */, 19132 /* h 7264 */, 14452 /* h 7280 */,
41485 /* h 7296 */, 49074 /* h 7312 */,  3728 /* h 7328 */, 10388 /* h 7344 */,
56597 /* h 7360 */,  2410 /* h 7376 */, 27618 /* h 7392 */,  8278 /* h 7408 */,
37251 /* h 7424 */, 33662 /* h 7440 */, 56282 /* h 7456 */, 10471 /* h 7472 */,
43277 /* h 7488 */,  5143 /* h 7504 */, 20040 /* h 7520 */, 40543 /* h 7536 */,
56284 /* h 7552 */, 64974 /* h 7568 */, 35134 /* h 7584 */, 53060 /* h 7600 */,
26482 /* h 7616 */,  1964 /* h 7632 */,  1000 /* h 7648 */, 52095 /* h 7664 */,
3283 /* h 7680 */,  7301 /* h 7696 */, 42748 /* h 7712 */, 38189 /* h 7728 */,
51185 /* h 7744 */, 38883 /* h 7760 */,  9272 /* h 7776 */, 24904 /* h 7792 */,
14793 /* h 7808 */, 12954 /* h 7824 */, 62627 /* h 7840 */, 50079 /* h 7856 */,
47639 /* h 7872 */, 53425 /* h 7888 */, 29026 /* h 7904 */, 18557 /* h 7920 */,
32424 /* h 7936 */, 22351 /* h 7952 */, 43571 /* h 7968 */, 59349 /* h 7984 */,
46543 /* h 8000 */, 41285 /* h 8016 */, 32140 /* h 8032 */, 47229 /* h 8048 */,
26745 /* h 8064 */, 47468 /* h 8080 */,  2384 /* h 8096 */, 25730 /* h 8112 */,
52478 /* h 8128 */, 11584 /* h 8144 */, 20082 /* h 8160 */,  1512 /* h 8176 */,
58127 /* h 8192 */, 47574 /* h 8208 */, 57971 /* h 8224 */, 10321 /* h 8240 */,
33392 /* h 8256 */, 10055 /* h 8272 */, 40995 /* h 8288 */, 51365 /* h 8304 */,
21527 /* h 8320 */, 15535 /* h 8336 */, 31814 /* h 8352 */, 10069 /* h 8368 */,
16001 /* h 8384 */, 38865 /* h 8400 */, 62823 /* h 8416 */, 49977 /* h 8432 */,
8380 /* h 8448 */, 35252 /* h 8464 */, 26966 /* h 8480 */, 28855 /* h 8496 */,
25339 /* h 8512 */, 65416 /* h 8528 */, 49418 /* h 8544 */, 46433 /* h 8560 */,
47634 /* h 8576 */, 21538 /* h 8592 */,  5661 /* h 8608 */, 11831 /* h 8624 */,
22630 /* h 8640 */,  1832 /* h 8656 */, 54532 /* h 8672 */, 29367 /* h 8688 */,
65380 /* h 8704 */, 38947 /* h 8720 */, 14482 /* h 8736 */, 35669 /* h 8752 */,
2414 /* h 8768 */, 47854 /* h 8784 */, 26514 /* h 8800 */, 33215 /* h 8816 */,
58078 /* h 8832 */, 52893 /* h 8848 */, 17002 /* h 8864 */,  7102 /* h 8880 */,
50237 /* h 8896 */,  1576 /* h 8912 */, 31164 /* h 8928 */, 40454 /* h 8944 */,
19603 /* h 8960 */, 50640 /* h 8976 */, 26507 /* h 8992 */, 22578 /* h 9008 */,
35866 /* h 9024 */,  4165 /* h 9040 */, 36266 /* h 9056 */, 62871 /* h 9072 */,
61329 /* h 9088 */, 20421 /* h 9104 */, 43731 /* h 9120 */, 27388 /* h 9136 */,
43537 /* h 9152 */, 42816 /* h 9168 */, 17189 /* h 9184 */, 16527 /* h 9200 */,
8577 /* h 9216 */, 22422 /* h 9232 */, 10927 /* h 9248 */, 34999 /* h 9264 */,
7304 /* h 9280 */,  6829 /* h 9296 */, 21085 /* h 9312 */, 29032 /* h 9328 */,
29169 /* h 9344 */, 63730 /* h 9360 */, 62378 /* h 9376 */, 25955 /* h 9392 */,
633 /* h 9408 */,  3072 /* h 9424 */, 31768 /* h 9440 */, 37505 /* h 9456 */,
30517 /* h 9472 */, 39136 /* h 9488 */, 10500 /* h 9504 */,   213 /* h 9520 */,
11317 /* h 9536 */,   268 /* h 9552 */, 60264 /* h 9568 */, 37549 /* h 9584 */,
27840 /* h 9600 */, 49718 /* h 9616 */, 10689 /* h 9632 */, 55279 /* h 9648 */,
34147 /* h 9664 */,  2845 /* h 9680 */, 15022 /* h 9696 */, 46381 /* h 9712 */,
60977 /* h 9728 */, 23894 /* h 9744 */, 37163 /* h 9760 */, 40449 /* h 9776 */,
6587 /* h 9792 */,  2602 /* h 9808 */, 44169 /* h 9824 */, 26539 /* h 9840 */,
58264 /* h 9856 */, 25654 /* h 9872 */, 25452 /* h 9888 */, 40401 /* h 9904 */,
52755 /* h 9920 */, 12086 /* h 9936 */, 55826 /* h 9952 */,  8022 /* h 9968 */,
27708 /* h 9984 */, 20370 /* h10000 */, 33871 /* h10016 */, 61590 /* h10032 */,
37398 /* h10048 */, 40453 /* h10064 */, 51901 /* h10080 */, 46118 /* h10096 */,
4489 /* h10112 */, 24506 /* h10128 */, 27473 /* h10144 */, 47889 /* h10160 */,
11172 /* h10176 */,  7985 /* h10192 */,
/* 10**4096 = */
49153 /* h 4096 */, 10855 /* h 4112 */, 20109 /* h 4128 */, 54386 /* h 4144 */,
31463 /* h 4160 */, 36606 /* h 4176 */,  7824 /* h 4192 */, 63642 /* h 4208 */,
16663 /* h 4224 */, 61192 /* h 4240 */, 20820 /* h 4256 */, 21728 /* h 4272 */,
47953 /* h 4288 */,  5041 /* h 4304 */, 59433 /* h 4320 */, 20587 /* h 4336 */,
45426 /* h 4352 */, 64297 /* h 4368 */, 22350 /* h 4384 */, 58777 /* h 4400 */,
24902 /* h 4416 */, 61658 /* h 4432 */,  3795 /* h 4448 */, 32876 /* h 4464 */,
58814 /* h 4480 */, 47210 /* h 4496 */, 24211 /* h 4512 */, 17685 /* h 4528 */,
7362 /* h 4544 */, 49241 /* h 4560 */, 31796 /* h 4576 */, 32286 /* h 4592 */,
9178 /* h 4608 */, 31816 /* h 4624 */, 19662 /* h 4640 */,  7455 /* h 4656 */,
41448 /* h 4672 */, 39819 /* h 4688 */, 57205 /* h 4704 */, 54975 /* h 4720 */,
48656 /* h 4736 */, 58177 /* h 4752 */, 44664 /* h 4768 */, 49887 /* h 4784 */,
26546 /* h 4800 */,   363 /* h 4816 */, 32538 /* h 4832 */,  3875 /* h 4848 */,
43981 /* h 4864 */, 15806 /* h 4880 */,  9588 /* h 4896 */, 44906 /* h 4912 */,
59095 /* h 4928 */, 51891 /* h 4944 */,  3712 /* h 4960 */,  5166 /* h 4976 */,
37159 /* h 4992 */, 24981 /* h 5008 */, 18449 /* h 5024 */, 11299 /* h 5040 */,
38657 /* h 5056 */, 34560 /* h 5072 */, 63874 /* h 5088 */, 52043 /* h 5104 */,
40068 /* h 5120 */, 63510 /* h 5136 */, 12172 /* h 5152 */, 34821 /* h 5168 */,
59092 /* h 5184 */, 26845 /* h 5200 */,  5985 /* h 5216 */, 48147 /* h 5232 */,
2309 /* h 5248 */, 65291 /* h 5264 */, 40001 /* h 5280 */, 21675 /* h 5296 */,
45604 /* h 5312 */, 30227 /* h 5328 */, 12366 /* h 5344 */,  6684 /* h 5360 */,
5755 /* h 5376 */, 15358 /* h 5392 */, 11591 /* h 5408 */, 17436 /* h 5424 */,
60060 /* h 5440 */, 20332 /* h 5456 */, 24961 /* h 5472 */, 30960 /* h 5488 */,
40888 /* h 5504 */, 60261 /* h 5520 */, 44609 /* h 5536 */, 12487 /* h 5552 */,
3342 /* h 5568 */, 38014 /* h 5584 */, 51927 /* h 5600 */, 41451 /* h 5616 */,
38230 /* h 5632 */, 55677 /* h 5648 */, 20557 /* h 5664 */,  8496 /* h 5680 */,
2507 /* h 5696 */,  6787 /* h 5712 */, 54535 /* h 5728 */, 62124 /* h 5744 */,
50986 /* h 5760 */, 16270 /* h 5776 */, 14138 /* h 5792 */, 64898 /* h 5808 */,
17084 /* h 5824 */, 38312 /* h 5840 */, 19762 /* h 5856 */, 10255 /* h 5872 */,
35520 /* h 5888 */, 62305 /* h 5904 */, 20228 /* h 5920 */, 33050 /* h 5936 */,
42420 /* h 5952 */, 28099 /* h 5968 */, 31259 /* h 5984 */, 54166 /* h 6000 */,
51352 /* h 6016 */,  5560 /* h 6032 */, 14479 /* h 6048 */, 56574 /* h 6064 */,
45728 /* h 6080 */, 17742 /* h 6096 */, 47369 /* h 6112 */, 34616 /* h 6128 */,
59798 /* h 6144 */,  4292 /* h 6160 */, 52241 /* h 6176 */, 11225 /* h 6192 */,
52492 /* h 6208 */, 12951 /* h 6224 */, 60464 /* h 6240 */, 25951 /* h 6256 */,
9649 /* h 6272 */, 44551 /* h 6288 */,  3816 /* h 6304 */, 62473 /* h 6320 */,
6638 /* h 6336 */,   893 /* h 6352 */, 28653 /* h 6368 */, 14732 /* h 6384 */,
62059 /* h 6400 */, 15258 /* h 6416 */, 42064 /* h 6432 */, 51604 /* h 6448 */,
5955 /* h 6464 */, 46388 /* h 6480 */, 38834 /* h 6496 */, 30118 /* h 6512 */,
47553 /* h 6528 */, 44112 /* h 6544 */, 23442 /* h 6560 */, 15563 /* h 6576 */,
25093 /* h 6592 */, 65504 /* h 6608 */, 38753 /* h 6624 */, 43058 /* h 6640 */,
21058 /* h 6656 */, 57322 /* h 6672 */, 51931 /* h 6688 */, 60291 /* h 6704 */,
44535 /* h 6720 */, 59293 /* h 6736 */, 61033 /* h 6752 */, 15392 /* h 6768 */,
26647 /* h 6784 */,  7690 /* h 6800 */, 47482 /* h 6816 */, 28705 /* h 6832 */,
29946 /* h 6848 */, 29744 /* h 6864 */, 42870 /* h 6880 */,  5996 /* h 6896 */,
35574 /* h 6912 */, 30715 /* h 6928 */, 39915 /* h 6944 */, 60577 /* h 6960 */,
61918 /* h 6976 */, 37562 /* h 6992 */, 46866 /* h 7008 */, 44899 /* h 7024 */,
51339 /* h 7040 */, 56885 /* h 7056 */, 36748 /* h 7072 */, 42219 /* h 7088 */,
54761 /* h 7104 */, 57655 /* h 7120 */, 25760 /* h 7136 */, 16564 /* h 7152 */,
52712 /* h 7168 */, 34769 /* h 7184 */, 15293 /* h 7200 */, 17042 /* h 7216 */,
25343 /* h 7232 */, 52623 /* h 7248 */, 37107 /* h 7264 */, 11814 /* h 7280 */,
56342 /* h 7296 */,  2398 /* h 7312 */, 40731 /* h 7328 */, 22984 /* h 7344 */,
64861 /* h 7360 */,  8104 /* h 7376 */, 30013 /* h 7392 */, 20792 /* h 7408 */,
11049 /* h 7424 */, 14602 /* h 7440 */, 12056 /* h 7456 */, 32789 /* h 7472 */,
55589 /* h 7488 */, 11736 /* h 7504 */, 55358 /* h 7520 */, 63876 /* h 7536 */,
11892 /* h 7552 */, 31367 /* h 7568 */,  8111 /* h 7584 */, 49566 /* h 7600 */,
21549 /* h 7616 */, 60749 /* h 7632 */, 46544 /* h 7648 */, 60665 /* h 7664 */,
60021 /* h 7680 */, 37986 /* h 7696 */,  2783 /* h 7712 */, 50492 /* h 7728 */,
41268 /* h 7744 */,  3246 /* h 7760 */, 54329 /* h 7776 */, 14242 /* h 7792 */,
11914 /* h 7808 */, 51450 /* h 7824 */, 12926 /* h 7840 */,  8577 /* h 7856 */,
47143 /* h 7872 */, 28283 /* h 7888 */,  2080 /* h 7904 */, 11556 /* h 7920 */,
4320 /* h 7936 */, 20670 /* h 7952 */, 54456 /* h 7968 */, 22675 /* h 7984 */,
11193 /* h 8000 */, 43825 /* h 8016 */,  8994 /* h 8032 */,  7979 /* h 8048 */,
16165 /* h 8064 */, 17419 /* h 8080 */, 32478 /* h 8096 */, 48994 /* h 8112 */,
51081 /* h 8128 */, 29402 /* h 8144 */, 47253 /* h 8160 */, 46600 /* h 8176 */,
32298 /* h 8192 */, 30840 /* h 8208 */, 46064 /* h 8224 */, 34526 /* h 8240 */,
31403 /* h 8256 */, 28654 /* h 8272 */, 29684 /* h 8288 */, 48019 /* h 8304 */,
62843 /* h 8320 */, 10220 /* h 8336 */, 46462 /* h 8352 */, 63448 /* h 8368 */,
27295 /* h 8384 */, 64674 /* h 8400 */, 59602 /* h 8416 */, 15620 /* h 8432 */,
5067 /* h 8448 */, 51679 /* h 8464 */, 33386 /* h 8480 */, 12658 /* h 8496 */,
36220 /* h 8512 */, 52638 /* h 8528 */, 55520 /* h 8544 */, 43260 /* h 8560 */,
38039 /* h 8576 */, 45763 /* h 8592 */, 16857 /* h 8608 */, 12406 /* h 8624 */,
14785 /* h 8640 */,  7369 /* h 8656 */, 50383 /* h 8672 */,  9736 /* h 8688 */,
51135 /* h 8704 */, 46801 /* h 8720 */, 27262 /* h 8736 */, 15666 /* h 8752 */,
6630 /* h 8768 */, 61103 /* h 8784 */, 57951 /* h 8800 */, 36371 /* h 8816 */,
12331 /* h 8832 */, 61027 /* h 8848 */, 28055 /* h 8864 */, 11774 /* h 8880 */,
7512 /* h 8896 */,  9623 /* h 8912 */, 15556 /* h 8928 */, 58397 /* h 8944 */,
25212 /* h 8960 */,  2688 /* h 8976 */, 46490 /* h 8992 */, 43917 /* h 9008 */,
14280 /* h 9024 */, 40682 /* h 9040 */, 64375 /* h 9056 */, 59658 /* h 9072 */,
6607 /* h 9088 */, 37066 /* h 9104 */, 13612 /* h 9120 */, 40675 /* h 9136 */,
51280 /* h 9152 */, 13843 /* h 9168 */, 54914 /* h 9184 */, 65144 /* h 9200 */,
28240 /* h 9216 */, 30863 /* h 9232 */,  2308 /* h 9248 */, 23302 /* h 9264 */,
53668 /* h 9280 */, 46875 /* h 9296 */, 46388 /* h 9312 */, 16364 /* h 9328 */,
17676 /* h 9344 */, 45868 /* h 9360 */, 14423 /* h 9376 */,  8387 /* h 9392 */,
53210 /* h 9408 */, 42729 /* h 9424 */, 62670 /* h 9440 */,   569 /* h 9456 */,
29063 /* h 9472 */, 18505 /* h 9488 */, 56213 /* h 9504 */, 41370 /* h 9520 */,
60810 /* h 9536 */, 46226 /* h 9552 */, 42664 /* h 9568 */, 38316 /* h 9584 */,
27865 /* h 9600 */, 19917 /* h 9616 */,  9040 /* h 9632 */, 53019 /* h 9648 */,
45354 /* h 9664 */, 64488 /* h 9680 */, 30604 /* h 9696 */,  6759 /* h 9712 */,
15052 /* h 9728 */, 14571 /* h 9744 */, 41859 /* h 9760 */, 49965 /* h 9776 */,
27313 /* h 9792 */, 64274 /* h 9808 */, 16552 /* h 9824 */, 41023 /* h 9840 */,
62790 /* h 9856 */, 60763 /* h 9872 */, 18212 /* h 9888 */, 59854 /* h 9904 */,
29949 /* h 9920 */, 19530 /* h 9936 */, 12504 /* h 9952 */, 29601 /* h 9968 */,
3629 /* h 9984 */, 55702 /* h10000 */, 54977 /* h10016 */, 41707 /* h10032 */,
28651 /* h10048 */, 38059 /* h10064 */, 15228 /* h10080 */, 28451 /* h10096 */,
24704 /* h10112 */, 18706 /* h10128 */, 39539 /* h10144 */, 36475 /* h10160 */,
37009 /* h10176 */, 19340 /* h10192 */, 63897 /* h10208 */, 53912 /* h10224 */,
14005 /* h10240 */, 13800 /* h10256 */, 57087 /* h10272 */, 43373 /* h10288 */,
39729 /* h10304 */, 38417 /* h10320 */, 55740 /* h10336 */, 27405 /* h10352 */,
16269 /* h10368 */, 50892 /* h10384 */, 26363 /* h10400 */, 10277 /* h10416 */,
33511 /* h10432 */, 29368 /* h10448 */, 40763 /* h10464 */, 54902 /* h10480 */,
13373 /* h10496 */, 42612 /* h10512 */, 20635 /* h10528 */,   252 /* h10544 */,
30601 /* h10560 */, 56511 /* h10576 */, 27199 /* h10592 */, 54822 /* h10608 */,
16893 /* h10624 */, 44694 /* h10640 */, 21531 /* h10656 */, 20105 /* h10672 */,
13319 /* h10688 */,  4501 /* h10704 */,  3331 /* h10720 */, 21312 /* h10736 */,
55130 /* h10752 */, 36365 /* h10768 */, 13125 /* h10784 */, 58805 /* h10800 */,
6573 /* h10816 */,  4239 /* h10832 */, 35260 /* h10848 */,  4235 /* h10864 */,
51540 /* h10880 */, 16804 /* h10896 */, 11107 /* h10912 */, 57403 /* h10928 */,
15743 /* h10944 */, 17275 /* h10960 */, 60814 /* h10976 */, 38828 /* h10992 */,
26224 /* h11008 */, 52182 /* h11024 */,  2242 /* h11040 */, 11349 /* h11056 */,
48233 /* h11072 */, 25870 /* h11088 */, 12016 /* h11104 */, 23631 /* h11120 */,
63167 /* h11136 */, 36943 /* h11152 */, 41695 /* h11168 */, 39301 /* h11184 */,
56734 /* h11200 */, 40877 /* h11216 */, 53817 /* h11232 */, 24280 /* h11248 */,
22578 /* h11264 */,  9560 /* h11280 */,  7353 /* h11296 */, 58341 /* h11312 */,
61908 /* h11328 */,  4084 /* h11344 */, 11674 /* h11360 */, 22208 /* h11376 */,
63492 /* h11392 */, 35918 /* h11408 */, 35347 /* h11424 */, 49568 /* h11440 */,
456 /* h11456 */,  5117 /* h11472 */, 30321 /* h11488 */, 59090 /* h11504 */,
13556 /* h11520 */, 42946 /* h11536 */, 30412 /* h11552 */, 40193 /* h11568 */,
15858 /* h11584 */, 53463 /* h11600 */, 64137 /* h11616 */, 19851 /* h11632 */,
4301 /* h11648 */, 21583 /* h11664 */, 57522 /* h11680 */, 11031 /* h11696 */,
23677 /* h11712 */, 46858 /* h11728 */, 65097 /* h11744 */, 64902 /* h11760 */,
16193 /* h11776 */, 57143 /* h11792 */, 38331 /* h11808 */,  8516 /* h11824 */,
22525 /* h11840 */, 34024 /* h11856 */,  5077 /* h11872 */,   211 /* h11888 */,
64702 /* h11904 */,  1174 /* h11920 */, 18244 /* h11936 */, 42170 /* h11952 */,
51586 /* h11968 */, 59594 /* h11984 */, 40558 /* h12000 */, 44738 /* h12016 */,
28728 /* h12032 */, 34796 /* h12048 */, 42265 /* h12064 */, 28672 /* h12080 */,
13115 /* h12096 */, 44782 /* h12112 */, 58412 /* h12128 */, 65382 /* h12144 */,
27429 /* h12160 */, 35581 /* h12176 */, 63035 /* h12192 */,   948 /* h12208 */,
37340 /* h12224 */, 48505 /* h12240 */, 55751 /* h12256 */, 23224 /* h12272 */,
26702 /* h12288 */, 11988 /* h12304 */,  6764 /* h12320 */, 18548 /* h12336 */,
37901 /* h12352 */, 44806 /* h12368 */, 25417 /* h12384 */, 12252 /* h12400 */,
32461 /* h12416 */, 45117 /* h12432 */, 39279 /* h12448 */, 59764 /* h12464 */,
26617 /* h12480 */, 44152 /* h12496 */, 34593 /* h12512 */, 21228 /* h12528 */,
40266 /* h12544 */, 48349 /* h12560 */, 11520 /* h12576 */, 36573 /* h12592 */,
56838 /* h12608 */, 13655 /* h12624 */, 23032 /* h12640 */, 16839 /* h12656 */,
54457 /* h12672 */, 14678 /* h12688 */,  2546 /* h12704 */, 42836 /* h12720 */,
55457 /* h12736 */,  4668 /* h12752 */,  4011 /* h12768 */, 46608 /* h12784 */,
8674 /* h12800 */, 15995 /* h12816 */, 25147 /* h12832 */, 11917 /* h12848 */,
40354 /* h12864 */, 37525 /* h12880 */, 24439 /* h12896 */, 48291 /* h12912 */,
933 /* h12928 */,  8204 /* h12944 */, 46167 /* h12960 */, 13820 /* h12976 */,
50916 /* h12992 */,  7094 /* h13008 */, 47400 /* h13024 */, 63310 /* h13040 */,
2900 /* h13056 */, 15709 /* h13072 */,  7457 /* h13088 */, 34764 /* h13104 */,
1135 /* h13120 */, 18788 /* h13136 */, 16960 /* h13152 */,  6318 /* h13168 */,
45685 /* h13184 */, 55400 /* h13200 */, 46230 /* h13216 */, 35794 /* h13232 */,
25588 /* h13248 */,  7253 /* h13264 */, 55541 /* h13280 */, 49716 /* h13296 */,
59760 /* h13312 */, 63592 /* h13328 */,  8191 /* h13344 */, 63765 /* h13360 */,
58530 /* h13376 */, 44667 /* h13392 */, 13294 /* h13408 */, 10001 /* h13424 */,
55586 /* h13440 */, 47887 /* h13456 */, 18738 /* h13472 */,  9509 /* h13488 */,
40896 /* h13504 */, 42506 /* h13520 */, 52580 /* h13536 */,  4171 /* h13552 */,
325 /* h13568 */, 12329 /* h13584 */,    98 /* h13600 */,
/* 10**5120 = */
45057 /* h 5120 */, 22401 /* h 5136 */,  5026 /* h 5152 */, 51833 /* h 5168 */,
20426 /* h 5184 */, 63707 /* h 5200 */, 20431 /* h 5216 */, 51620 /* h 5232 */,
12639 /* h 5248 */, 19196 /* h 5264 */, 32291 /* h 5280 */, 11377 /* h 5296 */,
7587 /* h 5312 */,  9247 /* h 5328 */, 13203 /* h 5344 */, 58607 /* h 5360 */,
54976 /* h 5376 */, 38259 /* h 5392 */, 16077 /* h 5408 */, 12484 /* h 5424 */,
34810 /* h 5440 */,  7514 /* h 5456 */, 50302 /* h 5472 */, 30947 /* h 5488 */,
13680 /* h 5504 */, 52451 /* h 5520 */, 29223 /* h 5536 */, 42058 /* h 5552 */,
1519 /* h 5568 */,  1947 /* h 5584 */, 34555 /* h 5600 */, 31030 /* h 5616 */,
35656 /* h 5632 */, 22822 /* h 5648 */,  6651 /* h 5664 */, 58347 /* h 5680 */,
17909 /* h 5696 */, 37456 /* h 5712 */, 29292 /* h 5728 */,  5877 /* h 5744 */,
5879 /* h 5760 */, 33899 /* h 5776 */, 55796 /* h 5792 */, 40048 /* h 5808 */,
45029 /* h 5824 */, 37736 /* h 5840 */, 35278 /* h 5856 */, 12313 /* h 5872 */,
21096 /* h 5888 */, 45040 /* h 5904 */, 65241 /* h 5920 */, 48286 /* h 5936 */,
24052 /* h 5952 */,   503 /* h 5968 */, 45162 /* h 5984 */, 27970 /* h 6000 */,
46548 /* h 6016 */, 60893 /* h 6032 */, 58301 /* h 6048 */, 32437 /* h 6064 */,
11469 /* h 6080 */, 63363 /* h 6096 */, 46853 /* h 6112 */, 46379 /* h 6128 */,
15544 /* h 6144 */, 37910 /* h 6160 */, 64999 /* h 6176 */, 47733 /* h 6192 */,
63355 /* h 6208 */, 15379 /* h 6224 */, 41423 /* h 6240 */, 52362 /* h 6256 */,
7516 /* h 6272 */, 17628 /* h 6288 */, 21531 /* h 6304 */, 43128 /* h 6320 */,
966 /* h 6336 */, 29649 /* h 6352 */, 48451 /* h 6368 */, 47751 /* h 6384 */,
60374 /* h 6400 */, 19716 /* h 6416 */,  4837 /* h 6432 */, 31957 /* h 6448 */,
50023 /* h 6464 */, 18867 /* h 6480 */, 10558 /* h 6496 */, 19852 /* h 6512 */,
35299 /* h 6528 */, 39369 /* h 6544 */,   274 /* h 6560 */, 39754 /* h 6576 */,
8771 /* h 6592 */, 21379 /* h 6608 */, 35020 /* h 6624 */, 45846 /* h 6640 */,
60599 /* h 6656 */,  4066 /* h 6672 */, 56801 /* h 6688 */, 51618 /* h 6704 */,
17607 /* h 6720 */,  2243 /* h 6736 */, 24559 /* h 6752 */, 57297 /* h 6768 */,
2683 /* h 6784 */, 58570 /* h 6800 */, 61036 /* h 6816 */, 43810 /* h 6832 */,
47989 /* h 6848 */,  1894 /* h 6864 */, 58834 /* h 6880 */, 33585 /* h 6896 */,
58050 /* h 6912 */, 33756 /* h 6928 */, 19526 /* h 6944 */, 18194 /* h 6960 */,
12774 /* h 6976 */, 50579 /* h 6992 */, 56298 /* h 7008 */, 56962 /* h 7024 */,
24845 /* h 7040 */, 49812 /* h 7056 */, 10075 /* h 7072 */, 33288 /* h 7088 */,
32362 /* h 7104 */, 34328 /* h 7120 */, 44935 /* h 7136 */,  5924 /* h 7152 */,
7433 /* h 7168 */, 43931 /* h 7184 */, 11190 /* h 7200 */, 50715 /* h 7216 */,
42870 /* h 7232 */, 39471 /* h 7248 */, 57319 /* h 7264 */, 38346 /* h 7280 */,
1492 /* h 7296 */, 65008 /* h 7312 */, 32918 /* h 7328 */, 19738 /* h 7344 */,
64823 /* h 7360 */, 40673 /* h 7376 */,  6020 /* h 7392 */, 31797 /* h 7408 */,
50336 /* h 7424 */,   192 /* h 7440 */, 37498 /* h 7456 */, 12549 /* h 7472 */,
922 /* h 7488 */, 58538 /* h 7504 */,  9706 /* h 7520 */, 32689 /* h 7536 */,
7503 /* h 7552 */, 62940 /* h 7568 */,  1953 /* h 7584 */, 58624 /* h 7600 */,
27065 /* h 7616 */, 39394 /* h 7632 */, 60593 /* h 7648 */, 29956 /* h 7664 */,
42681 /* h 7680 */, 24781 /* h 7696 */, 52809 /* h 7712 */,  7078 /* h 7728 */,
56902 /* h 7744 */, 59101 /* h 7760 */, 45519 /* h 7776 */, 39896 /* h 7792 */,
39062 /* h 7808 */, 18241 /* h 7824 */, 24832 /* h 7840 */,  9036 /* h 7856 */,
12667 /* h 7872 */, 25464 /* h 7888 */, 46371 /* h 7904 */, 13536 /* h 7920 */,
61694 /* h 7936 */, 20061 /* h 7952 */, 60433 /* h 7968 */, 21466 /* h 7984 */,
15420 /* h 8000 */, 35362 /* h 8016 */, 15149 /* h 8032 */, 19998 /* h 8048 */,
22080 /* h 8064 */, 61364 /* h 8080 */,  6103 /* h 8096 */, 62426 /* h 8112 */,
62364 /* h 8128 */, 16587 /* h 8144 */, 58849 /* h 8160 */, 44357 /* h 8176 */,
26844 /* h 8192 */, 15064 /* h 8208 */, 18257 /* h 8224 */, 64378 /* h 8240 */,
59125 /* h 8256 */, 29099 /* h 8272 */,  2159 /* h 8288 */, 42105 /* h 8304 */,
57358 /* h 8320 */, 18518 /* h 8336 */, 11339 /* h 8352 */, 20941 /* h 8368 */,
9492 /* h 8384 */,  1545 /* h 8400 */, 33896 /* h 8416 */, 51987 /* h 8432 */,
30547 /* h 8448 */,  4316 /* h 8464 */, 17221 /* h 8480 */, 56183 /* h 8496 */,
59537 /* h 8512 */, 40345 /* h 8528 */, 31448 /* h 8544 */, 22792 /* h 8560 */,
43506 /* h 8576 */, 14313 /* h 8592 */,  5035 /* h 8608 */, 54822 /* h 8624 */,
1927 /* h 8640 */, 46963 /* h 8656 */,  1684 /* h 8672 */, 49482 /* h 8688 */,
2100 /* h 8704 */, 57643 /* h 8720 */, 21133 /* h 8736 */, 19855 /* h 8752 */,
4181 /* h 8768 */, 47781 /* h 8784 */,  4668 /* h 8800 */, 54926 /* h 8816 */,
57887 /* h 8832 */, 63377 /* h 8848 */, 51771 /* h 8864 */, 16728 /* h 8880 */,
10973 /* h 8896 */, 43648 /* h 8912 */, 32015 /* h 8928 */, 56382 /* h 8944 */,
18284 /* h 8960 */, 40899 /* h 8976 */, 47527 /* h 8992 */,  6377 /* h 9008 */,
65089 /* h 9024 */, 24804 /* h 9040 */,  9483 /* h 9056 */, 24241 /* h 9072 */,
58698 /* h 9088 */, 49554 /* h 9104 */, 57375 /* h 9120 */,  5214 /* h 9136 */,
41643 /* h 9152 */, 24942 /* h 9168 */, 32171 /* h 9184 */, 58648 /* h 9200 */,
51053 /* h 9216 */, 63096 /* h 9232 */, 62010 /* h 9248 */, 21110 /* h 9264 */,
59010 /* h 9280 */, 53495 /* h 9296 */, 51471 /* h 9312 */, 45173 /* h 9328 */,
63883 /* h 9344 */,  9024 /* h 9360 */, 39257 /* h 9376 */, 54846 /* h 9392 */,
31890 /* h 9408 */, 61866 /* h 9424 */,  2603 /* h 9440 */,  4075 /* h 9456 */,
13654 /* h 9472 */, 53114 /* h 9488 */, 21197 /* h 9504 */, 18414 /* h 9520 */,
4839 /* h 9536 */, 52554 /* h 9552 */,  7770 /* h 9568 */, 54285 /* h 9584 */,
24348 /* h 9600 */, 33313 /* h 9616 */, 24343 /* h 9632 */, 34429 /* h 9648 */,
42517 /* h 9664 */, 53485 /* h 9680 */, 30794 /* h 9696 */, 55014 /* h 9712 */,
54664 /* h 9728 */, 52680 /* h 9744 */, 47322 /* h 9760 */, 47307 /* h 9776 */,
15652 /* h 9792 */, 37528 /* h 9808 */, 49672 /* h 9824 */, 62852 /* h 9840 */,
26940 /* h 9856 */, 49027 /* h 9872 */,  9844 /* h 9888 */, 47733 /* h 9904 */,
30192 /* h 9920 */, 64013 /* h 9936 */,  7398 /* h 9952 */, 17339 /* h 9968 */,
436 /* h 9984 */, 43476 /* h10000 */, 56759 /* h10016 */, 49922 /* h10032 */,
48233 /* h10048 */, 15483 /* h10064 */, 39696 /* h10080 */,   549 /* h10096 */,
59417 /* h10112 */, 28875 /* h10128 */,  4764 /* h10144 */, 17516 /* h10160 */,
30784 /* h10176 */,  8336 /* h10192 */, 32199 /* h10208 */, 64253 /* h10224 */,
63713 /* h10240 */, 20398 /* h10256 */, 30319 /* h10272 */, 17460 /* h10288 */,
26538 /* h10304 */, 15794 /* h10320 */, 11216 /* h10336 */, 62512 /* h10352 */,
36132 /* h10368 */, 49776 /* h10384 */, 32293 /* h10400 */, 13267 /* h10416 */,
13295 /* h10432 */,  2130 /* h10448 */, 26491 /* h10464 */, 60911 /* h10480 */,
58965 /* h10496 */, 13139 /* h10512 */, 52993 /* h10528 */,  8354 /* h10544 */,
62820 /* h10560 */, 46181 /* h10576 */, 34547 /* h10592 */, 40048 /* h10608 */,
63377 /* h10624 */, 63645 /* h10640 */,  5460 /* h10656 */, 29556 /* h10672 */,
1928 /* h10688 */, 25692 /* h10704 */, 40701 /* h10720 */, 23782 /* h10736 */,
10051 /* h10752 */, 48024 /* h10768 */, 27177 /* h10784 */, 12472 /* h10800 */,
11019 /* h10816 */, 40058 /* h10832 */, 60778 /* h10848 */, 52278 /* h10864 */,
28741 /* h10880 */,  5736 /* h10896 */,  3073 /* h10912 */,   415 /* h10928 */,
47652 /* h10944 */, 57121 /* h10960 */, 43246 /* h10976 */, 20703 /* h10992 */,
25235 /* h11008 */, 14634 /* h11024 */, 20167 /* h11040 */, 58645 /* h11056 */,
27656 /* h11072 */,  5953 /* h11088 */, 53467 /* h11104 */, 37853 /* h11120 */,
29287 /* h11136 */, 27362 /* h11152 */, 53172 /* h11168 */, 33632 /* h11184 */,
36794 /* h11200 */, 64973 /* h11216 */, 31002 /* h11232 */, 50102 /* h11248 */,
37382 /* h11264 */, 21387 /* h11280 */, 62587 /* h11296 */, 25959 /* h11312 */,
49946 /* h11328 */, 54245 /* h11344 */,  3392 /* h11360 */, 16135 /* h11376 */,
1871 /* h11392 */, 12047 /* h11408 */, 46879 /* h11424 */, 27847 /* h11440 */,
31781 /* h11456 */, 39418 /* h11472 */,   673 /* h11488 */, 30466 /* h11504 */,
58727 /* h11520 */, 52017 /* h11536 */, 56195 /* h11552 */, 22099 /* h11568 */,
55673 /* h11584 */, 37659 /* h11600 */, 12533 /* h11616 */, 48528 /* h11632 */,
60532 /* h11648 */, 62773 /* h11664 */, 23248 /* h11680 */, 63333 /* h11696 */,
41211 /* h11712 */, 57242 /* h11728 */,  4215 /* h11744 */, 60239 /* h11760 */,
13285 /* h11776 */,  3197 /* h11792 */, 17479 /* h11808 */, 30461 /* h11824 */,
18700 /* h11840 */, 44250 /* h11856 */, 26327 /* h11872 */, 48509 /* h11888 */,
41281 /* h11904 */,    93 /* h11920 */, 27537 /* h11936 */, 10198 /* h11952 */,
33409 /* h11968 */, 61822 /* h11984 */, 16326 /* h12000 */, 51862 /* h12016 */,
61229 /* h12032 */, 50529 /* h12048 */, 60609 /* h12064 */, 38584 /* h12080 */,
8034 /* h12096 */,  6994 /* h12112 */, 39256 /* h12128 */, 22933 /* h12144 */,
45978 /* h12160 */,  4612 /* h12176 */, 52235 /* h12192 */, 12478 /* h12208 */,
48580 /* h12224 */, 34572 /* h12240 */,  2001 /* h12256 */, 40035 /* h12272 */,
2806 /* h12288 */, 60649 /* h12304 */, 52142 /* h12320 */, 13513 /* h12336 */,
33083 /* h12352 */, 25081 /* h12368 */, 43168 /* h12384 */, 23105 /* h12400 */,
11291 /* h12416 */,  8335 /* h12432 */, 63811 /* h12448 */, 23821 /* h12464 */,
26521 /* h12480 */,  8577 /* h12496 */, 17064 /* h12512 */, 37798 /* h12528 */,
55713 /* h12544 */, 41600 /* h12560 */, 41300 /* h12576 */,  2308 /* h12592 */,
2580 /* h12608 */,  7548 /* h12624 */, 12932 /* h12640 */,  5840 /* h12656 */,
17606 /* h12672 */, 25082 /* h12688 */, 60364 /* h12704 */, 20693 /* h12720 */,
50278 /* h12736 */, 12405 /* h12752 */, 24276 /* h12768 */, 48338 /* h12784 */,
40845 /* h12800 */, 10073 /* h12816 */, 19148 /* h12832 */, 47127 /* h12848 */,
48936 /* h12864 */, 64482 /* h12880 */, 44101 /* h12896 */, 14780 /* h12912 */,
52931 /* h12928 */, 23067 /* h12944 */,  6261 /* h12960 */, 55297 /* h12976 */,
38357 /* h12992 */, 14168 /* h13008 */,  5078 /* h13024 */, 13110 /* h13040 */,
15103 /* h13056 */, 51281 /* h13072 */,   208 /* h13088 */, 27404 /* h13104 */,
65440 /* h13120 */, 34376 /* h13136 */, 25230 /* h13152 */, 22254 /* h13168 */,
40763 /* h13184 */, 15097 /* h13200 */, 25314 /* h13216 */, 40214 /* h13232 */,
28090 /* h13248 */, 57260 /* h13264 */, 28298 /* h13280 */, 41043 /* h13296 */,
40701 /* h13312 */, 24565 /* h13328 */, 32750 /* h13344 */, 38155 /* h13360 */,
11615 /* h13376 */, 56774 /* h13392 */, 52703 /* h13408 */, 51772 /* h13424 */,
42443 /* h13440 */, 49469 /* h13456 */, 49657 /* h13472 */, 24536 /* h13488 */,
41235 /* h13504 */, 29925 /* h13520 */, 12804 /* h13536 */, 43021 /* h13552 */,
24321 /* h13568 */, 25912 /* h13584 */, 54869 /* h13600 */, 39574 /* h13616 */,
5273 /* h13632 */, 50946 /* h13648 */, 21424 /* h13664 */, 53936 /* h13680 */,
11118 /* h13696 */, 40041 /* h13712 */, 60757 /* h13728 */, 50724 /* h13744 */,
1861 /* h13760 */, 50967 /* h13776 */, 45408 /* h13792 */, 43927 /* h13808 */,
64616 /* h13824 */, 45352 /* h13840 */, 12141 /* h13856 */, 53732 /* h13872 */,
40690 /* h13888 */, 10940 /* h13904 */, 11383 /* h13920 */,  2698 /* h13936 */,
29287 /* h13952 */, 40521 /* h13968 */, 25571 /* h13984 */, 39237 /* h14000 */,
20700 /* h14016 */, 33136 /* h14032 */, 61087 /* h14048 */, 64453 /* h14064 */,
48179 /* h14080 */, 13666 /* h14096 */, 46798 /* h14112 */,  4165 /* h14128 */,
25201 /* h14144 */, 39696 /* h14160 */,  7054 /* h14176 */, 32897 /* h14192 */,
9261 /* h14208 */, 40797 /* h14224 */, 45665 /* h14240 */, 23058 /* h14256 */,
34290 /* h14272 */, 59273 /* h14288 */,  4276 /* h14304 */, 52247 /* h14320 */,
6818 /* h14336 */, 28882 /* h14352 */, 41645 /* h14368 */, 59096 /* h14384 */,
9916 /* h14400 */, 10827 /* h14416 */, 49787 /* h14432 */, 19557 /* h14448 */,
17108 /* h14464 */,   296 /* h14480 */, 51196 /* h14496 */, 11508 /* h14512 */,
62995 /* h14528 */, 37262 /* h14544 */, 54609 /* h14560 */, 59880 /* h14576 */,
31222 /* h14592 */, 44408 /* h14608 */,  7165 /* h14624 */, 10521 /* h14640 */,
26874 /* h14656 */,  6903 /* h14672 */, 44086 /* h14688 */, 57767 /* h14704 */,
23503 /* h14720 */, 24585 /* h14736 */, 23182 /* h14752 */, 22835 /* h14768 */,
5667 /* h14784 */,  9849 /* h14800 */, 46722 /* h14816 */, 50814 /* h14832 */,
23402 /* h14848 */,  4385 /* h14864 */, 59455 /* h14880 */, 12131 /* h14896 */,
21841 /* h14912 */,  3736 /* h14928 */, 18578 /* h14944 */, 62382 /* h14960 */,
18576 /* h14976 */, 64321 /* h14992 */, 61148 /* h15008 */, 43762 /* h15024 */,
43002 /* h15040 */,  2052 /* h15056 */, 12482 /* h15072 */, 20438 /* h15088 */,
622 /* h15104 */,  5507 /* h15120 */, 17020 /* h15136 */,  5715 /* h15152 */,
59157 /* h15168 */, 47845 /* h15184 */, 30919 /* h15200 */, 41647 /* h15216 */,
23628 /* h15232 */, 35366 /* h15248 */, 24682 /* h15264 */, 62937 /* h15280 */,
43443 /* h15296 */, 58728 /* h15312 */, 37920 /* h15328 */,  3353 /* h15344 */,
35500 /* h15360 */, 10118 /* h15376 */,  8887 /* h15392 */,  4755 /* h15408 */,
18844 /* h15424 */, 60049 /* h15440 */, 62859 /* h15456 */, 56352 /* h15472 */,
6070 /* h15488 */, 25278 /* h15504 */,  9477 /* h15520 */, 38519 /* h15536 */,
33272 /* h15552 */, 10164 /* h15568 */, 45613 /* h15584 */, 55007 /* h15600 */,
16966 /* h15616 */, 31458 /* h15632 */, 19625 /* h15648 */, 28605 /* h15664 */,
5359 /* h15680 */, 40578 /* h15696 */, 23217 /* h15712 */, 54556 /* h15728 */,
54036 /* h15744 */,  2470 /* h15760 */, 34179 /* h15776 */, 46656 /* h15792 */,
4585 /* h15808 */,  4275 /* h15824 */, 63849 /* h15840 */, 12700 /* h15856 */,
28602 /* h15872 */, 33792 /* h15888 */, 17764 /* h15904 */, 41321 /* h15920 */,
28671 /* h15936 */, 14833 /* h15952 */, 45778 /* h15968 */, 59069 /* h15984 */,
47889 /* h16000 */, 50787 /* h16016 */, 51019 /* h16032 */, 52956 /* h16048 */,
39572 /* h16064 */, 16318 /* h16080 */, 55619 /* h16096 */, 37345 /* h16112 */,
25197 /* h16128 */, 51580 /* h16144 */, 47735 /* h16160 */, 54722 /* h16176 */,
25341 /* h16192 */, 29603 /* h16208 */, 55474 /* h16224 */, 54356 /* h16240 */,
2017 /* h16256 */, 44777 /* h16272 */, 52212 /* h16288 */, 51969 /* h16304 */,
12906 /* h16320 */, 23652 /* h16336 */, 32829 /* h16352 */, 34295 /* h16368 */,
2750 /* h16384 */, 33307 /* h16400 */,  7103 /* h16416 */, 27171 /* h16432 */,
10024 /* h16448 */, 47917 /* h16464 */, 62757 /* h16480 */, 36760 /* h16496 */,
8581 /* h16512 */, 63343 /* h16528 */, 63874 /* h16544 */, 41096 /* h16560 */,
50480 /* h16576 */,  1717 /* h16592 */, 63649 /* h16608 */, 38115 /* h16624 */,
35515 /* h16640 */, 64824 /* h16656 */, 53586 /* h16672 */, 49454 /* h16688 */,
53089 /* h16704 */,  3340 /* h16720 */, 46398 /* h16736 */, 10822 /* h16752 */,
52167 /* h16768 */, 56049 /* h16784 */, 40788 /* h16800 */, 45231 /* h16816 */,
61456 /* h16832 */,  9791 /* h16848 */, 24514 /* h16864 */, 20866 /* h16880 */,
5247 /* h16896 */, 41435 /* h16912 */, 43275 /* h16928 */, 22085 /* h16944 */,
64935 /* h16960 */, 64993 /* h16976 */, 13588 /* h16992 */,	1 /* h17008 */,
0};

/* table of starting indexes into previous table */
const unsigned short __tbl_10_huge_start [] = {
0, 1, 150, 448, 894, 1489, 2233, 0};
