/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2008 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"%Z%%M%	%I%	%E% SMI"

#include "lint.h"
#include <sys/types.h>

/* table of 6 multiples of 2**2816 */
const unsigned short __tbl_2_huge_digits [] = { 1,
/* 2**2816 = */
3536 /* e   0 */, 1683 /* e   4 */, 7828 /* e   8 */, 3713 /* e  12 */,
8302 /* e  16 */, 4040 /* e  20 */, 1525 /* e  24 */, 6128 /* e  28 */,
3247 /* e  32 */, 8412 /* e  36 */, 1354 /* e  40 */, 7137 /* e  44 */,
488 /* e  48 */, 3415 /* e  52 */, 8366 /* e  56 */, 2888 /* e  60 */,
435 /* e  64 */,   67 /* e  68 */, 4244 /* e  72 */, 9444 /* e  76 */,
3909 /* e  80 */, 1960 /* e  84 */, 9722 /* e  88 */, 6917 /* e  92 */,
7465 /* e  96 */, 5103 /* e 100 */, 5036 /* e 104 */, 4100 /* e 108 */,
8604 /* e 112 */, 3394 /* e 116 */,  724 /* e 120 */, 7061 /* e 124 */,
299 /* e 128 */, 2619 /* e 132 */, 1891 /* e 136 */, 9722 /* e 140 */,
9046 /* e 144 */, 5921 /* e 148 */, 9555 /* e 152 */, 9491 /* e 156 */,
4354 /* e 160 */, 9051 /* e 164 */, 9987 /* e 168 */, 6398 /* e 172 */,
8031 /* e 176 */, 8846 /* e 180 */, 6553 /* e 184 */, 4612 /* e 188 */,
6758 /* e 192 */, 5053 /* e 196 */, 7887 /* e 200 */, 7067 /* e 204 */,
1248 /* e 208 */, 8739 /* e 212 */, 5265 /* e 216 */, 3455 /* e 220 */,
6697 /* e 224 */, 3866 /* e 228 */, 9825 /* e 232 */, 5993 /* e 236 */,
6640 /* e 240 */, 5966 /* e 244 */, 2971 /* e 248 */, 4531 /* e 252 */,
284 /* e 256 */, 8060 /* e 260 */,  244 /* e 264 */, 5281 /* e 268 */,
7874 /* e 272 */, 2770 /* e 276 */, 3800 /* e 280 */,  847 /* e 284 */,
9791 /* e 288 */, 4078 /* e 292 */,  201 /* e 296 */, 3118 /* e 300 */,
6744 /* e 304 */, 9222 /* e 308 */,  619 /* e 312 */, 8564 /* e 316 */,
7653 /* e 320 */,  815 /* e 324 */, 8400 /* e 328 */, 5518 /* e 332 */,
4708 /* e 336 */, 8936 /* e 340 */, 6965 /* e 344 */,  859 /* e 348 */,
190 /* e 352 */, 9092 /* e 356 */, 1985 /* e 360 */, 4080 /* e 364 */,
7393 /* e 368 */, 9453 /* e 372 */, 7288 /* e 376 */, 4553 /* e 380 */,
7790 /* e 384 */, 5429 /* e 388 */, 7229 /* e 392 */, 4134 /* e 396 */,
3027 /* e 400 */,  341 /* e 404 */, 3123 /* e 408 */, 7147 /* e 412 */,
9240 /* e 416 */, 4345 /* e 420 */, 8495 /* e 424 */, 4736 /* e 428 */,
1582 /* e 432 */,   26 /* e 436 */, 3519 /* e 440 */, 7907 /* e 444 */,
1443 /* e 448 */, 5166 /* e 452 */, 7149 /* e 456 */, 4156 /* e 460 */,
410 /* e 464 */, 5693 /* e 468 */, 4930 /* e 472 */, 7778 /* e 476 */,
5531 /* e 480 */, 9083 /* e 484 */, 2412 /* e 488 */, 1383 /* e 492 */,
2982 /* e 496 */, 2953 /* e 500 */, 2318 /* e 504 */, 4813 /* e 508 */,
2483 /* e 512 */, 1682 /* e 516 */,  331 /* e 520 */, 5562 /* e 524 */,
5368 /* e 528 */, 5453 /* e 532 */,  249 /* e 536 */, 3139 /* e 540 */,
3307 /* e 544 */, 8974 /* e 548 */, 2368 /* e 552 */, 6001 /* e 556 */,
3051 /* e 560 */, 4608 /* e 564 */,  119 /* e 568 */, 5889 /* e 572 */,
1678 /* e 576 */, 8451 /* e 580 */, 4807 /* e 584 */, 2991 /* e 588 */,
6659 /* e 592 */, 3797 /* e 596 */, 7908 /* e 600 */, 2288 /* e 604 */,
1417 /* e 608 */, 9696 /* e 612 */, 9044 /* e 616 */, 8737 /* e 620 */,
433 /* e 624 */, 9934 /* e 628 */, 1780 /* e 632 */, 6909 /* e 636 */,
3017 /* e 640 */, 8911 /* e 644 */, 6028 /* e 648 */, 1166 /* e 652 */,
4034 /* e 656 */, 4223 /* e 660 */, 1046 /* e 664 */, 3190 /* e 668 */,
7967 /* e 672 */, 3701 /* e 676 */, 2824 /* e 680 */, 7203 /* e 684 */,
3025 /* e 688 */, 3022 /* e 692 */, 9122 /* e 696 */,  707 /* e 700 */,
7910 /* e 704 */, 3306 /* e 708 */, 2583 /* e 712 */, 2978 /* e 716 */,
9344 /* e 720 */,  900 /* e 724 */,  772 /* e 728 */, 3042 /* e 732 */,
2674 /* e 736 */, 1277 /* e 740 */, 7526 /* e 744 */, 7518 /* e 748 */,
6408 /* e 752 */,  450 /* e 756 */, 8196 /* e 760 */, 3103 /* e 764 */,
7791 /* e 768 */, 3672 /* e 772 */, 5408 /* e 776 */, 7843 /* e 780 */,
5189 /* e 784 */, 7523 /* e 788 */, 4056 /* e 792 */, 2575 /* e 796 */,
9840 /* e 800 */, 5009 /* e 804 */, 8572 /* e 808 */, 8503 /* e 812 */,
5027 /* e 816 */, 6868 /* e 820 */,  109 /* e 824 */, 3476 /* e 828 */,
219 /* e 832 */, 6147 /* e 836 */, 2736 /* e 840 */, 5017 /* e 844 */,

/* 2**5632 =  */
3296 /* e   0 */, 3426 /* e   4 */, 3295 /* e   8 */, 3203 /* e  12 */,
2547 /* e  16 */, 9389 /* e  20 */, 7386 /* e  24 */, 8073 /* e  28 */,
6614 /* e  32 */,  484 /* e  36 */, 9018 /* e  40 */, 9823 /* e  44 */,
5559 /* e  48 */, 5864 /* e  52 */, 8462 /* e  56 */, 4843 /* e  60 */,
5166 /* e  64 */, 9450 /* e  68 */, 8388 /* e  72 */, 5571 /* e  76 */,
6800 /* e  80 */, 8444 /* e  84 */,  853 /* e  88 */, 6313 /* e  92 */,
8561 /* e  96 */, 6611 /* e 100 */, 6953 /* e 104 */, 5544 /* e 108 */,
1000 /* e 112 */, 3566 /* e 116 */, 1388 /* e 120 */, 6341 /* e 124 */,
9360 /* e 128 */, 2675 /* e 132 */, 9064 /* e 136 */, 9281 /* e 140 */,
3688 /* e 144 */, 1621 /* e 148 */, 1992 /* e 152 */, 3276 /* e 156 */,
3238 /* e 160 */, 6133 /* e 164 */, 2364 /* e 168 */, 3047 /* e 172 */,
1389 /* e 176 */, 4717 /* e 180 */, 1217 /* e 184 */, 7465 /* e 188 */,
657 /* e 192 */, 8131 /* e 196 */, 3767 /* e 200 */, 8183 /* e 204 */,
2014 /* e 208 */, 1553 /* e 212 */, 4842 /* e 216 */, 5701 /* e 220 */,
2142 /* e 224 */, 1950 /* e 228 */, 2809 /* e 232 */,   51 /* e 236 */,
8498 /* e 240 */, 4177 /* e 244 */, 9656 /* e 248 */, 5726 /* e 252 */,
901 /* e 256 */, 6778 /* e 260 */, 5940 /* e 264 */, 7698 /* e 268 */,
2650 /* e 272 */, 3415 /* e 276 */, 7695 /* e 280 */, 2741 /* e 284 */,
8167 /* e 288 */,  570 /* e 292 */, 9630 /* e 296 */, 4028 /* e 300 */,
1949 /* e 304 */, 1605 /* e 308 */, 6368 /* e 312 */, 9947 /* e 316 */,
4612 /* e 320 */, 6376 /* e 324 */, 8290 /* e 328 */, 5452 /* e 332 */,
134 /* e 336 */, 8625 /* e 340 */, 9502 /* e 344 */, 9987 /* e 348 */,
8914 /* e 352 */, 5544 /* e 356 */, 8899 /* e 360 */, 5319 /* e 364 */,
3436 /* e 368 */, 5168 /* e 372 */, 2131 /* e 376 */, 3406 /* e 380 */,
7928 /* e 384 */, 6830 /* e 388 */, 7273 /* e 392 */,  229 /* e 396 */,
3726 /* e 400 */,  456 /* e 404 */,  432 /* e 408 */, 9462 /* e 412 */,
9017 /* e 416 */, 9301 /* e 420 */, 3210 /* e 424 */, 9805 /* e 428 */,
5491 /* e 432 */, 9089 /* e 436 */, 1857 /* e 440 */, 8523 /* e 444 */,
8681 /* e 448 */, 9233 /* e 452 */, 5387 /* e 456 */, 5228 /* e 460 */,
8213 /* e 464 */, 3776 /* e 468 */, 2351 /* e 472 */, 8791 /* e 476 */,
7346 /* e 480 */, 7992 /* e 484 */, 7080 /* e 488 */,   31 /* e 492 */,
1050 /* e 496 */, 1787 /* e 500 */, 5765 /* e 504 */, 4391 /* e 508 */,
8652 /* e 512 */, 7925 /* e 516 */, 4201 /* e 520 */,  308 /* e 524 */,
5345 /* e 528 */,  237 /* e 532 */, 5621 /* e 536 */, 1610 /* e 540 */,
9551 /* e 544 */, 2652 /* e 548 */,  128 /* e 552 */, 2096 /* e 556 */,
291 /* e 560 */, 8130 /* e 564 */, 4475 /* e 568 */, 6607 /* e 572 */,
1411 /* e 576 */,  280 /* e 580 */, 2326 /* e 584 */, 4272 /* e 588 */,
2136 /* e 592 */, 7819 /* e 596 */, 9901 /* e 600 */, 7169 /* e 604 */,
275 /* e 608 */, 2749 /* e 612 */, 5358 /* e 616 */,  466 /* e 620 */,
4049 /* e 624 */, 6398 /* e 628 */,  263 /* e 632 */, 2399 /* e 636 */,
1461 /* e 640 */, 8479 /* e 644 */, 3810 /* e 648 */, 4086 /* e 652 */,
5426 /* e 656 */, 1517 /* e 660 */, 8443 /* e 664 */, 5612 /* e 668 */,
7989 /* e 672 */, 1740 /* e 676 */, 6690 /* e 680 */, 5584 /* e 684 */,
6686 /* e 688 */, 2419 /* e 692 */, 2490 /* e 696 */, 8808 /* e 700 */,
1947 /* e 704 */, 3432 /* e 708 */, 4101 /* e 712 */, 9573 /* e 716 */,
1824 /* e 720 */, 2364 /* e 724 */, 3095 /* e 728 */, 3396 /* e 732 */,
927 /* e 736 */,  140 /* e 740 */, 3080 /* e 744 */, 8672 /* e 748 */,
5632 /* e 752 */, 5876 /* e 756 */, 1936 /* e 760 */, 9670 /* e 764 */,
9179 /* e 768 */, 8414 /* e 772 */, 4551 /* e 776 */, 7679 /* e 780 */,
5457 /* e 784 */, 2834 /* e 788 */, 4335 /* e 792 */, 9056 /* e 796 */,
5568 /* e 800 */, 5267 /* e 804 */, 8337 /* e 808 */, 6883 /* e 812 */,
9908 /* e 816 */,  444 /* e 820 */, 1095 /* e 824 */, 7470 /* e 828 */,
4558 /* e 832 */,  792 /* e 836 */, 1277 /* e 840 */, 6737 /* e 844 */,
343 /* e 848 */, 2750 /* e 852 */, 3762 /* e 856 */,  650 /* e 860 */,
414 /* e 864 */, 3225 /* e 868 */, 8399 /* e 872 */, 1172 /* e 876 */,
2095 /* e 880 */, 9257 /* e 884 */,  155 /* e 888 */, 7947 /* e 892 */,
4019 /* e 896 */, 8262 /* e 900 */, 8884 /* e 904 */, 4805 /* e 908 */,
804 /* e 912 */, 6865 /* e 916 */, 6444 /* e 920 */, 7634 /* e 924 */,
5510 /* e 928 */, 9276 /* e 932 */, 3026 /* e 936 */, 2890 /* e 940 */,
1740 /* e 944 */, 4598 /* e 948 */,  876 /* e 952 */, 6495 /* e 956 */,
9809 /* e 960 */, 5124 /* e 964 */, 9045 /* e 968 */, 4780 /* e 972 */,
3921 /* e 976 */, 1908 /* e 980 */, 9444 /* e 984 */, 8288 /* e 988 */,
5399 /* e 992 */, 4190 /* e 996 */, 7715 /* e1000 */, 8448 /* e1004 */,
8262 /* e1008 */, 3737 /* e1012 */,  189 /* e1016 */, 1432 /* e1020 */,
8782 /* e1024 */,  333 /* e1028 */, 9267 /* e1032 */, 4005 /* e1036 */,
7356 /* e1040 */, 6817 /* e1044 */, 2653 /* e1048 */,  279 /* e1052 */,
1857 /* e1056 */, 5537 /* e1060 */,  770 /* e1064 */, 9149 /* e1068 */,
9690 /* e1072 */, 6731 /* e1076 */, 8641 /* e1080 */, 9227 /* e1084 */,
9892 /* e1088 */, 3172 /* e1092 */, 2918 /* e1096 */, 3972 /* e1100 */,
769 /* e1104 */, 8383 /* e1108 */, 2504 /* e1112 */, 8460 /* e1116 */,
7186 /* e1120 */, 6868 /* e1124 */, 2523 /* e1128 */, 9609 /* e1132 */,
1086 /* e1136 */, 2971 /* e1140 */, 8518 /* e1144 */, 8812 /* e1148 */,
5612 /* e1152 */, 5742 /* e1156 */, 6945 /* e1160 */, 4733 /* e1164 */,
6582 /* e1168 */, 3498 /* e1172 */, 3739 /* e1176 */, 7285 /* e1180 */,
4295 /* e1184 */, 5501 /* e1188 */, 5786 /* e1192 */, 3421 /* e1196 */,
1777 /* e1200 */, 9934 /* e1204 */, 4257 /* e1208 */, 3275 /* e1212 */,
1322 /* e1216 */, 9557 /* e1220 */, 1782 /* e1224 */, 4993 /* e1228 */,
7791 /* e1232 */, 5640 /* e1236 */, 5829 /* e1240 */, 2443 /* e1244 */,
3988 /* e1248 */, 4397 /* e1252 */, 3967 /* e1256 */, 8901 /* e1260 */,
9844 /* e1264 */, 6386 /* e1268 */, 7574 /* e1272 */,  179 /* e1276 */,
7510 /* e1280 */, 5049 /* e1284 */, 9032 /* e1288 */, 8938 /* e1292 */,
8393 /* e1296 */, 1003 /* e1300 */, 5702 /* e1304 */, 5963 /* e1308 */,
3529 /* e1312 */, 8085 /* e1316 */, 8909 /* e1320 */, 6024 /* e1324 */,
6444 /* e1328 */,  459 /* e1332 */, 4446 /* e1336 */, 3542 /* e1340 */,
7126 /* e1344 */, 5155 /* e1348 */, 3442 /* e1352 */, 2662 /* e1356 */,
8849 /* e1360 */, 7529 /* e1364 */, 9165 /* e1368 */, 1946 /* e1372 */,
6635 /* e1376 */, 3834 /* e1380 */, 2955 /* e1384 */, 9001 /* e1388 */,
8220 /* e1392 */, 7653 /* e1396 */, 1052 /* e1400 */, 2996 /* e1404 */,
9979 /* e1408 */, 2554 /* e1412 */, 6959 /* e1416 */, 5987 /* e1420 */,
2314 /* e1424 */, 8546 /* e1428 */, 4464 /* e1432 */, 3568 /* e1436 */,
8876 /* e1440 */, 5881 /* e1444 */, 9387 /* e1448 */, 8672 /* e1452 */,
5278 /* e1456 */, 4624 /* e1460 */, 3806 /* e1464 */, 2517 /* e1468 */,
3995 /* e1472 */,  173 /* e1476 */,  592 /* e1480 */, 6610 /* e1484 */,
9979 /* e1488 */,  116 /* e1492 */, 6562 /* e1496 */, 5559 /* e1500 */,
995 /* e1504 */, 2674 /* e1508 */, 6406 /* e1512 */, 7181 /* e1516 */,
5094 /* e1520 */, 6250 /* e1524 */, 8883 /* e1528 */, 4966 /* e1532 */,
6648 /* e1536 */, 6884 /* e1540 */, 8622 /* e1544 */, 9707 /* e1548 */,
2176 /* e1552 */, 1069 /* e1556 */, 9678 /* e1560 */, 1455 /* e1564 */,
5845 /* e1568 */, 8374 /* e1572 */, 3135 /* e1576 */, 2056 /* e1580 */,
4385 /* e1584 */, 1846 /* e1588 */, 4311 /* e1592 */, 2996 /* e1596 */,
5603 /* e1600 */, 6731 /* e1604 */, 7765 /* e1608 */, 4676 /* e1612 */,
4027 /* e1616 */, 7361 /* e1620 */, 1638 /* e1624 */, 3266 /* e1628 */,
8085 /* e1632 */, 3520 /* e1636 */, 6226 /* e1640 */, 2460 /* e1644 */,
9387 /* e1648 */, 2922 /* e1652 */, 2169 /* e1656 */, 6089 /* e1660 */,
955 /* e1664 */, 7994 /* e1668 */, 4442 /* e1672 */, 1216 /* e1676 */,
8278 /* e1680 */, 9940 /* e1684 */, 3034 /* e1688 */, 2517 /* e1692 */,

/* 2**8448 =  */
4656 /* e   0 */, 2669 /* e   4 */, 9932 /* e   8 */, 2390 /* e  12 */,
9824 /* e  16 */,   43 /* e  20 */, 3424 /* e  24 */, 8511 /* e  28 */,
8683 /* e  32 */, 6362 /* e  36 */,  677 /* e  40 */, 3842 /* e  44 */,
4639 /* e  48 */, 6158 /* e  52 */, 5180 /* e  56 */, 5906 /* e  60 */,
9066 /* e  64 */, 3581 /* e  68 */, 5801 /* e  72 */,  593 /* e  76 */,
4337 /* e  80 */, 2060 /* e  84 */, 2389 /* e  88 */, 4690 /* e  92 */,
3040 /* e  96 */, 7127 /* e 100 */, 3946 /* e 104 */, 4248 /* e 108 */,
7964 /* e 112 */, 8210 /* e 116 */, 9001 /* e 120 */, 3997 /* e 124 */,
8886 /* e 128 */, 9528 /* e 132 */, 9522 /* e 136 */, 1864 /* e 140 */,
2924 /* e 144 */, 8867 /* e 148 */, 3786 /* e 152 */, 7284 /* e 156 */,
8608 /* e 160 */, 3267 /* e 164 */, 1704 /* e 168 */, 3605 /* e 172 */,
1254 /* e 176 */, 4423 /* e 180 */, 9188 /* e 184 */, 2956 /* e 188 */,
9472 /* e 192 */, 6269 /* e 196 */, 8946 /* e 200 */,  307 /* e 204 */,
5965 /* e 208 */, 7958 /* e 212 */, 5281 /* e 216 */, 2324 /* e 220 */,
2430 /* e 224 */, 6162 /* e 228 */,  838 /* e 232 */,  721 /* e 236 */,
8332 /* e 240 */, 2256 /* e 244 */, 8237 /* e 248 */, 2129 /* e 252 */,
8923 /* e 256 */, 5855 /* e 260 */, 4690 /* e 264 */, 4197 /* e 268 */,
1285 /* e 272 */, 3935 /* e 276 */, 1677 /* e 280 */,  593 /* e 284 */,
2784 /* e 288 */, 4404 /* e 292 */, 1923 /* e 296 */, 3153 /* e 300 */,
4041 /* e 304 */, 6730 /* e 308 */, 4324 /* e 312 */, 1448 /* e 316 */,
8765 /* e 320 */, 5011 /* e 324 */, 5843 /* e 328 */, 3719 /* e 332 */,
3511 /* e 336 */,  907 /* e 340 */,   77 /* e 344 */, 6985 /* e 348 */,
7914 /* e 352 */, 2608 /* e 356 */, 7706 /* e 360 */, 8280 /* e 364 */,
5478 /* e 368 */, 4621 /* e 372 */, 8641 /* e 376 */, 1422 /* e 380 */,
811 /* e 384 */, 7224 /* e 388 */, 7779 /* e 392 */, 2977 /* e 396 */,
6910 /* e 400 */, 2156 /* e 404 */, 3040 /* e 408 */, 7135 /* e 412 */,
6829 /* e 416 */, 9088 /* e 420 */, 6414 /* e 424 */,  718 /* e 428 */,
3667 /* e 432 */,  448 /* e 436 */, 6457 /* e 440 */, 2629 /* e 444 */,
5804 /* e 448 */, 7761 /* e 452 */,  603 /* e 456 */,  558 /* e 460 */,
795 /* e 464 */, 3780 /* e 468 */, 3145 /* e 472 */, 7411 /* e 476 */,
3418 /* e 480 */, 3228 /* e 484 */, 4748 /* e 488 */, 1389 /* e 492 */,
8477 /* e 496 */, 4826 /* e 500 */, 2662 /* e 504 */, 7173 /* e 508 */,
1885 /* e 512 */, 2180 /* e 516 */, 2743 /* e 520 */,  114 /* e 524 */,
345 /* e 528 */, 9148 /* e 532 */, 7561 /* e 536 */, 5568 /* e 540 */,
5620 /* e 544 */, 9452 /* e 548 */, 7083 /* e 552 */, 5760 /* e 556 */,
4775 /* e 560 */, 9925 /* e 564 */, 3920 /* e 568 */, 6905 /* e 572 */,
4528 /* e 576 */, 5203 /* e 580 */, 7786 /* e 584 */, 8657 /* e 588 */,
9393 /* e 592 */, 9878 /* e 596 */, 9882 /* e 600 */, 7478 /* e 604 */,
9992 /* e 608 */, 9893 /* e 612 */, 6647 /* e 616 */, 2798 /* e 620 */,
5248 /* e 624 */, 7764 /* e 628 */, 5470 /* e 632 */, 5912 /* e 636 */,
154 /* e 640 */, 6571 /* e 644 */, 5188 /* e 648 */, 6804 /* e 652 */,
2756 /* e 656 */, 4641 /* e 660 */,  665 /* e 664 */, 9112 /* e 668 */,
1589 /* e 672 */, 7254 /* e 676 */, 5073 /* e 680 */, 7980 /* e 684 */,
6429 /* e 688 */, 1797 /* e 692 */, 4016 /* e 696 */, 9710 /* e 700 */,
5434 /* e 704 */, 4862 /* e 708 */, 9245 /* e 712 */, 7417 /* e 716 */,
9679 /* e 720 */, 4331 /* e 724 */, 5156 /* e 728 */, 7899 /* e 732 */,
1325 /* e 736 */, 6037 /* e 740 */, 9925 /* e 744 */, 7256 /* e 748 */,
1717 /* e 752 */, 3608 /* e 756 */, 2632 /* e 760 */,  284 /* e 764 */,
4103 /* e 768 */, 2533 /* e 772 */, 8261 /* e 776 */, 1802 /* e 780 */,
4436 /* e 784 */, 7453 /* e 788 */, 4596 /* e 792 */, 4683 /* e 796 */,
786 /* e 800 */, 1878 /* e 804 */, 5042 /* e 808 */, 2290 /* e 812 */,
1379 /* e 816 */, 4479 /* e 820 */, 6532 /* e 824 */, 8482 /* e 828 */,
7856 /* e 832 */, 2267 /* e 836 */, 3951 /* e 840 */, 4081 /* e 844 */,
3193 /* e 848 */, 8290 /* e 852 */,  774 /* e 856 */, 4268 /* e 860 */,
5242 /* e 864 */, 2599 /* e 868 */, 3255 /* e 872 */, 1314 /* e 876 */,
6430 /* e 880 */, 5054 /* e 884 */, 8898 /* e 888 */, 4791 /* e 892 */,
1615 /* e 896 */, 9619 /* e 900 */, 8447 /* e 904 */,  521 /* e 908 */,
6843 /* e 912 */, 9891 /* e 916 */, 2939 /* e 920 */, 3750 /* e 924 */,
8509 /* e 928 */, 8842 /* e 932 */, 4672 /* e 936 */, 2290 /* e 940 */,
5080 /* e 944 */, 3861 /* e 948 */, 4388 /* e 952 */, 1414 /* e 956 */,
4301 /* e 960 */, 2328 /* e 964 */,  926 /* e 968 */, 4674 /* e 972 */,
3679 /* e 976 */, 6446 /* e 980 */, 9940 /* e 984 */, 6160 /* e 988 */,
530 /* e 992 */, 9640 /* e 996 */, 3522 /* e1000 */,  944 /* e1004 */,
1213 /* e1008 */, 6021 /* e1012 */, 5317 /* e1016 */, 7192 /* e1020 */,
7274 /* e1024 */,  890 /* e1028 */, 5669 /* e1032 */,  512 /* e1036 */,
4048 /* e1040 */, 2871 /* e1044 */, 4428 /* e1048 */, 9476 /* e1052 */,
6021 /* e1056 */, 6085 /* e1060 */,  539 /* e1064 */, 6573 /* e1068 */,
7856 /* e1072 */, 8842 /* e1076 */, 8828 /* e1080 */, 5980 /* e1084 */,
7224 /* e1088 */, 4124 /* e1092 */, 9108 /* e1096 */, 2108 /* e1100 */,
7508 /* e1104 */, 4850 /* e1108 */, 5162 /* e1112 */, 8152 /* e1116 */,
2953 /* e1120 */,  243 /* e1124 */, 4721 /* e1128 */, 2207 /* e1132 */,
6437 /* e1136 */, 5462 /* e1140 */, 3197 /* e1144 */, 9243 /* e1148 */,
8599 /* e1152 */, 9732 /* e1156 */,  216 /* e1160 */, 3798 /* e1164 */,
3911 /* e1168 */, 8635 /* e1172 */, 7322 /* e1176 */, 4840 /* e1180 */,
7688 /* e1184 */, 3938 /* e1188 */,  359 /* e1192 */, 8143 /* e1196 */,
4810 /* e1200 */, 5268 /* e1204 */, 5052 /* e1208 */,  574 /* e1212 */,
3775 /* e1216 */, 8812 /* e1220 */, 1266 /* e1224 */, 2057 /* e1228 */,
9649 /* e1232 */, 2634 /* e1236 */, 3673 /* e1240 */, 8430 /* e1244 */,
382 /* e1248 */, 2237 /* e1252 */, 9016 /* e1256 */, 3445 /* e1260 */,
5542 /* e1264 */, 1887 /* e1268 */, 1575 /* e1272 */, 3539 /* e1276 */,
7479 /* e1280 */, 9343 /* e1284 */, 8870 /* e1288 */, 1150 /* e1292 */,
9608 /* e1296 */, 8798 /* e1300 */, 3666 /* e1304 */, 7739 /* e1308 */,
808 /* e1312 */, 4141 /* e1316 */, 8437 /* e1320 */, 3406 /* e1324 */,
5638 /* e1328 */, 7163 /* e1332 */, 3733 /* e1336 */,  705 /* e1340 */,
4421 /* e1344 */, 6488 /* e1348 */, 8720 /* e1352 */,  572 /* e1356 */,
2917 /* e1360 */, 2066 /* e1364 */, 7078 /* e1368 */, 5215 /* e1372 */,
6206 /* e1376 */, 5031 /* e1380 */, 4033 /* e1384 */,   67 /* e1388 */,
9730 /* e1392 */, 3515 /* e1396 */, 9128 /* e1400 */, 1106 /* e1404 */,
9298 /* e1408 */, 2861 /* e1412 */, 2249 /* e1416 */,  809 /* e1420 */,
8870 /* e1424 */, 2384 /* e1428 */, 3349 /* e1432 */, 1056 /* e1436 */,
5988 /* e1440 */, 5562 /* e1444 */, 3981 /* e1448 */, 1532 /* e1452 */,
3835 /* e1456 */, 4555 /* e1460 */, 2878 /* e1464 */, 3066 /* e1468 */,
8924 /* e1472 */,  898 /* e1476 */,  295 /* e1480 */, 8513 /* e1484 */,
1595 /* e1488 */,  900 /* e1492 */, 6810 /* e1496 */, 1625 /* e1500 */,
7669 /* e1504 */, 3462 /* e1508 */, 6294 /* e1512 */, 8487 /* e1516 */,
1178 /* e1520 */, 7383 /* e1524 */, 9846 /* e1528 */, 2257 /* e1532 */,
9401 /* e1536 */, 5224 /* e1540 */, 2503 /* e1544 */, 9447 /* e1548 */,
4289 /* e1552 */, 2180 /* e1556 */, 6595 /* e1560 */, 5480 /* e1564 */,
2303 /* e1568 */, 6381 /* e1572 */, 5283 /* e1576 */, 9261 /* e1580 */,
8554 /* e1584 */, 9674 /* e1588 */, 3371 /* e1592 */, 1706 /* e1596 */,
5981 /* e1600 */, 2503 /* e1604 */, 9640 /* e1608 */,  245 /* e1612 */,
4860 /* e1616 */, 5142 /* e1620 */, 1798 /* e1624 */, 2481 /* e1628 */,
4200 /* e1632 */, 6164 /* e1636 */, 1751 /* e1640 */,  516 /* e1644 */,
6555 /* e1648 */, 6568 /* e1652 */, 7851 /* e1656 */, 4902 /* e1660 */,
5849 /* e1664 */, 8975 /* e1668 */, 2643 /* e1672 */, 8963 /* e1676 */,
3921 /* e1680 */, 9839 /* e1684 */, 2902 /* e1688 */, 9260 /* e1692 */,
8495 /* e1696 */, 5479 /* e1700 */, 9038 /* e1704 */,  692 /* e1708 */,
2687 /* e1712 */, 1111 /* e1716 */, 1562 /* e1720 */, 2918 /* e1724 */,
9797 /* e1728 */, 3614 /* e1732 */, 1477 /* e1736 */, 7338 /* e1740 */,
8747 /* e1744 */,  559 /* e1748 */, 4769 /* e1752 */, 7394 /* e1756 */,
4672 /* e1760 */, 5692 /* e1764 */, 5384 /* e1768 */, 8194 /* e1772 */,
9631 /* e1776 */, 8149 /* e1780 */,  777 /* e1784 */, 5180 /* e1788 */,
9799 /* e1792 */, 2011 /* e1796 */,  628 /* e1800 */, 2428 /* e1804 */,
3855 /* e1808 */, 5696 /* e1812 */, 3294 /* e1816 */, 9277 /* e1820 */,
997 /* e1824 */,  265 /* e1828 */, 6726 /* e1832 */, 9214 /* e1836 */,
7785 /* e1840 */, 3984 /* e1844 */, 3669 /* e1848 */, 6610 /* e1852 */,
3434 /* e1856 */, 4535 /* e1860 */, 8015 /* e1864 */, 4583 /* e1868 */,
8513 /* e1872 */,  756 /* e1876 */,  965 /* e1880 */, 8021 /* e1884 */,
4493 /* e1888 */, 1591 /* e1892 */, 9871 /* e1896 */,   65 /* e1900 */,
5407 /* e1904 */, 8456 /* e1908 */, 3127 /* e1912 */,  781 /* e1916 */,
5133 /* e1920 */, 6371 /* e1924 */, 5349 /* e1928 */, 3341 /* e1932 */,
5890 /* e1936 */, 9120 /* e1940 */, 9089 /* e1944 */, 6656 /* e1948 */,
8160 /* e1952 */, 8636 /* e1956 */, 2317 /* e1960 */, 3531 /* e1964 */,
5940 /* e1968 */, 7242 /* e1972 */, 8974 /* e1976 */, 9626 /* e1980 */,
5756 /* e1984 */, 5218 /* e1988 */, 1148 /* e1992 */, 3382 /* e1996 */,
2785 /* e2000 */, 5106 /* e2004 */, 7385 /* e2008 */, 5796 /* e2012 */,
1694 /* e2016 */, 4909 /* e2020 */, 6728 /* e2024 */, 3590 /* e2028 */,
2003 /* e2032 */, 4482 /* e2036 */, 4543 /* e2040 */, 3485 /* e2044 */,
7653 /* e2048 */,  708 /* e2052 */, 5759 /* e2056 */, 3137 /* e2060 */,
7344 /* e2064 */,  840 /* e2068 */, 4021 /* e2072 */,  574 /* e2076 */,
2634 /* e2080 */, 4125 /* e2084 */, 9290 /* e2088 */, 8361 /* e2092 */,
5551 /* e2096 */, 2631 /* e2100 */, 3788 /* e2104 */, 2663 /* e2108 */,
9056 /* e2112 */, 7092 /* e2116 */, 2151 /* e2120 */, 1648 /* e2124 */,
1035 /* e2128 */, 2486 /* e2132 */, 9651 /* e2136 */,   74 /* e2140 */,
4733 /* e2144 */, 6755 /* e2148 */, 2620 /* e2152 */, 2149 /* e2156 */,
6173 /* e2160 */, 8939 /* e2164 */, 6174 /* e2168 */, 1089 /* e2172 */,
7479 /* e2176 */, 6954 /* e2180 */, 7814 /* e2184 */, 8763 /* e2188 */,
1597 /* e2192 */, 7911 /* e2196 */, 8582 /* e2200 */, 2761 /* e2204 */,
2549 /* e2208 */, 8174 /* e2212 */, 4981 /* e2216 */,  733 /* e2220 */,
7759 /* e2224 */, 7663 /* e2228 */, 2362 /* e2232 */, 2722 /* e2236 */,
6846 /* e2240 */, 8283 /* e2244 */, 8542 /* e2248 */, 1175 /* e2252 */,
4748 /* e2256 */, 6016 /* e2260 */, 9819 /* e2264 */, 7846 /* e2268 */,
1907 /* e2272 */, 6233 /* e2276 */,  993 /* e2280 */, 8212 /* e2284 */,
3651 /* e2288 */, 9192 /* e2292 */, 2572 /* e2296 */, 5541 /* e2300 */,
5864 /* e2304 */, 6448 /* e2308 */,  352 /* e2312 */, 7842 /* e2316 */,
9417 /* e2320 */,  644 /* e2324 */, 6651 /* e2328 */, 9831 /* e2332 */,
443 /* e2336 */, 7438 /* e2340 */, 1652 /* e2344 */, 9135 /* e2348 */,
5848 /* e2352 */, 8723 /* e2356 */, 4647 /* e2360 */, 7898 /* e2364 */,
2757 /* e2368 */, 4168 /* e2372 */,  443 /* e2376 */, 9783 /* e2380 */,
7214 /* e2384 */, 7738 /* e2388 */, 9369 /* e2392 */, 6824 /* e2396 */,
829 /* e2400 */, 1638 /* e2404 */, 8128 /* e2408 */, 4131 /* e2412 */,
7873 /* e2416 */, 9965 /* e2420 */,  862 /* e2424 */, 3790 /* e2428 */,
4783 /* e2432 */, 1057 /* e2436 */, 8500 /* e2440 */, 7927 /* e2444 */,
3204 /* e2448 */, 7359 /* e2452 */, 3439 /* e2456 */, 7717 /* e2460 */,
8715 /* e2464 */, 7686 /* e2468 */, 3960 /* e2472 */, 4546 /* e2476 */,
5531 /* e2480 */, 1549 /* e2484 */, 3019 /* e2488 */, 7261 /* e2492 */,
4138 /* e2496 */, 6857 /* e2500 */, 4811 /* e2504 */, 1690 /* e2508 */,
7506 /* e2512 */, 6125 /* e2516 */, 2948 /* e2520 */, 7714 /* e2524 */,
796 /* e2528 */, 5455 /* e2532 */,    0 /* e2536 */, 1263 /* e2540 */,

/* 2**11264 =  */
3616 /* e   0 */, 5278 /* e   4 */,  374 /* e   8 */, 4862 /* e  12 */,
8174 /* e  16 */, 7061 /* e  20 */, 5924 /* e  24 */, 9687 /* e  28 */,
769 /* e  32 */, 4432 /* e  36 */, 2214 /* e  40 */, 9952 /* e  44 */,
5948 /* e  48 */, 6813 /* e  52 */, 7681 /* e  56 */,  398 /* e  60 */,
5020 /* e  64 */, 1044 /* e  68 */, 8504 /* e  72 */, 3735 /* e  76 */,
6243 /* e  80 */, 4312 /* e  84 */, 4653 /* e  88 */, 3935 /* e  92 */,
8412 /* e  96 */, 7005 /* e 100 */, 5688 /* e 104 */, 8730 /* e 108 */,
3166 /* e 112 */, 7938 /* e 116 */, 7297 /* e 120 */, 2952 /* e 124 */,
1453 /* e 128 */, 9740 /* e 132 */, 4993 /* e 136 */, 9757 /* e 140 */,
5368 /* e 144 */, 9157 /* e 148 */, 6363 /* e 152 */, 5847 /* e 156 */,
526 /* e 160 */, 5977 /* e 164 */, 3799 /* e 168 */, 4804 /* e 172 */,
6555 /* e 176 */, 9926 /* e 180 */,  723 /* e 184 */, 5082 /* e 188 */,
8812 /* e 192 */, 4041 /* e 196 */, 8715 /* e 200 */, 8931 /* e 204 */,
2552 /* e 208 */, 2728 /* e 212 */, 4521 /* e 216 */, 1826 /* e 220 */,
1129 /* e 224 */, 3813 /* e 228 */, 3521 /* e 232 */, 4028 /* e 236 */,
1667 /* e 240 */, 1240 /* e 244 */, 6022 /* e 248 */,  803 /* e 252 */,
7337 /* e 256 */, 9739 /* e 260 */, 4082 /* e 264 */, 1457 /* e 268 */,
3591 /* e 272 */, 7902 /* e 276 */, 9939 /* e 280 */, 1989 /* e 284 */,
7749 /* e 288 */, 2356 /* e 292 */, 7593 /* e 296 */, 8861 /* e 300 */,
1962 /* e 304 */,  378 /* e 308 */, 8141 /* e 312 */, 3729 /* e 316 */,
2073 /* e 320 */, 5994 /* e 324 */, 5221 /* e 328 */, 2669 /* e 332 */,
6276 /* e 336 */, 6725 /* e 340 */, 5053 /* e 344 */, 4818 /* e 348 */,
5469 /* e 352 */, 1294 /* e 356 */, 5550 /* e 360 */, 4535 /* e 364 */,
5655 /* e 368 */, 2314 /* e 372 */,  493 /* e 376 */, 8172 /* e 380 */,
9610 /* e 384 */, 1205 /* e 388 */, 3029 /* e 392 */,  885 /* e 396 */,
8229 /* e 400 */,  122 /* e 404 */, 3468 /* e 408 */, 6124 /* e 412 */,
2293 /* e 416 */,   80 /* e 420 */, 8333 /* e 424 */, 9804 /* e 428 */,
4983 /* e 432 */, 2864 /* e 436 */,   45 /* e 440 */, 4164 /* e 444 */,
3536 /* e 448 */, 2107 /* e 452 */, 7267 /* e 456 */, 6818 /* e 460 */,
701 /* e 464 */, 8481 /* e 468 */, 1127 /* e 472 */, 6500 /* e 476 */,
1905 /* e 480 */, 1183 /* e 484 */, 8300 /* e 488 */, 3277 /* e 492 */,
1612 /* e 496 */, 1145 /* e 500 */, 9095 /* e 504 */, 2498 /* e 508 */,
7613 /* e 512 */, 6386 /* e 516 */, 1170 /* e 520 */, 6064 /* e 524 */,
7645 /* e 528 */, 3592 /* e 532 */, 8011 /* e 536 */, 1914 /* e 540 */,
9722 /* e 544 */, 4893 /* e 548 */, 8910 /* e 552 */, 6344 /* e 556 */,
4205 /* e 560 */, 1140 /* e 564 */, 7421 /* e 568 */, 8981 /* e 572 */,
9880 /* e 576 */, 5385 /* e 580 */, 5238 /* e 584 */, 1431 /* e 588 */,
2390 /* e 592 */, 7183 /* e 596 */, 7211 /* e 600 */, 6577 /* e 604 */,
2569 /* e 608 */, 6593 /* e 612 */, 2076 /* e 616 */, 6553 /* e 620 */,
3980 /* e 624 */, 6304 /* e 628 */, 6281 /* e 632 */, 1650 /* e 636 */,
2201 /* e 640 */, 5089 /* e 644 */, 3428 /* e 648 */, 5484 /* e 652 */,
6856 /* e 656 */, 5748 /* e 660 */, 6658 /* e 664 */, 3774 /* e 668 */,
8214 /* e 672 */, 9763 /* e 676 */,  140 /* e 680 */,  783 /* e 684 */,
1426 /* e 688 */, 6028 /* e 692 */, 8496 /* e 696 */, 8007 /* e 700 */,
3368 /* e 704 */, 7101 /* e 708 */, 3158 /* e 712 */, 8383 /* e 716 */,
8982 /* e 720 */,  848 /* e 724 */, 4808 /* e 728 */, 9359 /* e 732 */,
6399 /* e 736 */, 5178 /* e 740 */, 8583 /* e 744 */, 7570 /* e 748 */,
1002 /* e 752 */, 4305 /* e 756 */, 5816 /* e 760 */, 2085 /* e 764 */,
6380 /* e 768 */,  570 /* e 772 */, 8472 /* e 776 */, 9153 /* e 780 */,
9114 /* e 784 */, 8603 /* e 788 */, 8300 /* e 792 */, 9148 /* e 796 */,
2307 /* e 800 */, 5724 /* e 804 */, 3482 /* e 808 */,  319 /* e 812 */,
2977 /* e 816 */, 5622 /* e 820 */, 3764 /* e 824 */, 4275 /* e 828 */,
6799 /* e 832 */, 4018 /* e 836 */, 1492 /* e 840 */, 5466 /* e 844 */,
9197 /* e 848 */, 6929 /* e 852 */,  682 /* e 856 */, 6754 /* e 860 */,
430 /* e 864 */, 3946 /* e 868 */, 9005 /* e 872 */, 6430 /* e 876 */,
8643 /* e 880 */, 3528 /* e 884 */, 8275 /* e 888 */, 4999 /* e 892 */,
9462 /* e 896 */, 3431 /* e 900 */, 6593 /* e 904 */, 1068 /* e 908 */,
2555 /* e 912 */, 6967 /* e 916 */, 1612 /* e 920 */,  333 /* e 924 */,
3215 /* e 928 */, 7738 /* e 932 */, 9794 /* e 936 */, 2967 /* e 940 */,
489 /* e 944 */, 5634 /* e 948 */, 2338 /* e 952 */, 3890 /* e 956 */,
7159 /* e 960 */, 4442 /* e 964 */, 3736 /* e 968 */, 8494 /* e 972 */,
3196 /* e 976 */, 4537 /* e 980 */, 5116 /* e 984 */, 7801 /* e 988 */,
1909 /* e 992 */, 5361 /* e 996 */, 3392 /* e1000 */, 5022 /* e1004 */,
1892 /* e1008 */, 2038 /* e1012 */, 9447 /* e1016 */, 1303 /* e1020 */,
2298 /* e1024 */, 2621 /* e1028 */, 6128 /* e1032 */, 4267 /* e1036 */,
1065 /* e1040 */, 5799 /* e1044 */, 5948 /* e1048 */,   69 /* e1052 */,
2071 /* e1056 */, 8544 /* e1060 */, 7829 /* e1064 */, 9379 /* e1068 */,
9222 /* e1072 */, 2278 /* e1076 */, 5272 /* e1080 */, 6052 /* e1084 */,
5439 /* e1088 */, 1468 /* e1092 */, 1722 /* e1096 */, 1455 /* e1100 */,
7840 /* e1104 */,  420 /* e1108 */, 4975 /* e1112 */, 9147 /* e1116 */,
8643 /* e1120 */, 6328 /* e1124 */,  569 /* e1128 */, 4371 /* e1132 */,
3450 /* e1136 */, 8433 /* e1140 */, 5882 /* e1144 */, 5681 /* e1148 */,
9249 /* e1152 */, 3155 /* e1156 */, 7083 /* e1160 */, 4825 /* e1164 */,
812 /* e1168 */, 5038 /* e1172 */, 9719 /* e1176 */, 4742 /* e1180 */,
7690 /* e1184 */, 2588 /* e1188 */, 2714 /* e1192 */, 9038 /* e1196 */,
1329 /* e1200 */, 9546 /* e1204 */, 1549 /* e1208 */, 8053 /* e1212 */,
7768 /* e1216 */, 6345 /* e1220 */, 7008 /* e1224 */, 9994 /* e1228 */,
5355 /* e1232 */, 3329 /* e1236 */, 8982 /* e1240 */, 5734 /* e1244 */,
6996 /* e1248 */, 2442 /* e1252 */, 7050 /* e1256 */, 1475 /* e1260 */,
2904 /* e1264 */, 2894 /* e1268 */,  465 /* e1272 */, 4741 /* e1276 */,
6045 /* e1280 */,  997 /* e1284 */, 7721 /* e1288 */, 7669 /* e1292 */,
7451 /* e1296 */, 9732 /* e1300 */, 6143 /* e1304 */, 9700 /* e1308 */,
4233 /* e1312 */,  100 /* e1316 */, 6470 /* e1320 */,  766 /* e1324 */,
6232 /* e1328 */, 5795 /* e1332 */, 3759 /* e1336 */, 1138 /* e1340 */,
9237 /* e1344 */, 9204 /* e1348 */, 1736 /* e1352 */, 7988 /* e1356 */,
2298 /* e1360 */, 1918 /* e1364 */, 4120 /* e1368 */,  318 /* e1372 */,
9033 /* e1376 */, 1529 /* e1380 */, 5661 /* e1384 */, 4727 /* e1388 */,
8862 /* e1392 */, 2242 /* e1396 */, 5622 /* e1400 */,  903 /* e1404 */,
1348 /* e1408 */, 2702 /* e1412 */, 4665 /* e1416 */, 6617 /* e1420 */,
2446 /* e1424 */, 3759 /* e1428 */, 2106 /* e1432 */, 9307 /* e1436 */,
7119 /* e1440 */, 6102 /* e1444 */, 5177 /* e1448 */, 9499 /* e1452 */,
6720 /* e1456 */, 4619 /* e1460 */, 2069 /* e1464 */,  640 /* e1468 */,
9911 /* e1472 */, 2684 /* e1476 */, 4415 /* e1480 */, 9184 /* e1484 */,
9962 /* e1488 */, 3391 /* e1492 */, 3816 /* e1496 */, 4045 /* e1500 */,
906 /* e1504 */, 6448 /* e1508 */, 7631 /* e1512 */, 5342 /* e1516 */,
1229 /* e1520 */, 7706 /* e1524 */, 7692 /* e1528 */, 9611 /* e1532 */,
5331 /* e1536 */, 3866 /* e1540 */, 6112 /* e1544 */, 3523 /* e1548 */,
7501 /* e1552 */, 3939 /* e1556 */, 6631 /* e1560 */,  571 /* e1564 */,
8474 /* e1568 */, 5954 /* e1572 */, 4794 /* e1576 */, 4458 /* e1580 */,
489 /* e1584 */, 8279 /* e1588 */, 7533 /* e1592 */, 8289 /* e1596 */,
8810 /* e1600 */, 9452 /* e1604 */, 2234 /* e1608 */, 3355 /* e1612 */,
3511 /* e1616 */, 4850 /* e1620 */, 6426 /* e1624 */, 4140 /* e1628 */,
208 /* e1632 */, 5879 /* e1636 */, 2402 /* e1640 */, 8415 /* e1644 */,
1111 /* e1648 */, 3742 /* e1652 */, 2407 /* e1656 */, 5133 /* e1660 */,
5632 /* e1664 */, 7598 /* e1668 */, 5458 /* e1672 */, 7986 /* e1676 */,
8557 /* e1680 */, 9559 /* e1684 */, 7922 /* e1688 */, 1849 /* e1692 */,
9855 /* e1696 */, 9368 /* e1700 */, 9789 /* e1704 */,  969 /* e1708 */,
2531 /* e1712 */,  252 /* e1716 */, 9897 /* e1720 */, 1982 /* e1724 */,
5264 /* e1728 */, 2722 /* e1732 */, 8164 /* e1736 */, 4662 /* e1740 */,
2555 /* e1744 */, 2364 /* e1748 */, 1948 /* e1752 */, 3016 /* e1756 */,
9099 /* e1760 */, 9049 /* e1764 */, 4005 /* e1768 */, 1897 /* e1772 */,
7001 /* e1776 */, 6530 /* e1780 */, 5304 /* e1784 */, 2201 /* e1788 */,
3507 /* e1792 */, 7924 /* e1796 */, 1625 /* e1800 */, 6995 /* e1804 */,
3944 /* e1808 */, 6141 /* e1812 */, 7873 /* e1816 */, 6447 /* e1820 */,
2463 /* e1824 */, 6195 /* e1828 */, 4202 /* e1832 */, 5452 /* e1836 */,
9858 /* e1840 */, 3486 /* e1844 */, 1696 /* e1848 */, 5178 /* e1852 */,
4226 /* e1856 */, 9350 /* e1860 */, 1763 /* e1864 */,  700 /* e1868 */,
7866 /* e1872 */, 7570 /* e1876 */, 2440 /* e1880 */, 2680 /* e1884 */,
2424 /* e1888 */, 8812 /* e1892 */, 7638 /* e1896 */, 3451 /* e1900 */,
9910 /* e1904 */,  399 /* e1908 */, 1851 /* e1912 */, 7837 /* e1916 */,
6545 /* e1920 */, 3110 /* e1924 */, 9905 /* e1928 */, 2505 /* e1932 */,
4262 /* e1936 */, 5743 /* e1940 */, 5497 /* e1944 */, 7940 /* e1948 */,
1911 /* e1952 */, 8520 /* e1956 */, 5898 /* e1960 */, 8609 /* e1964 */,
5709 /* e1968 */, 8041 /* e1972 */, 2068 /* e1976 */, 9642 /* e1980 */,
9272 /* e1984 */, 6509 /* e1988 */, 2174 /* e1992 */, 3310 /* e1996 */,
9424 /* e2000 */, 8889 /* e2004 */, 8810 /* e2008 */, 5390 /* e2012 */,
8121 /* e2016 */, 5985 /* e2020 */, 8406 /* e2024 */, 6740 /* e2028 */,
9243 /* e2032 */, 9121 /* e2036 */, 1304 /* e2040 */, 3989 /* e2044 */,
3430 /* e2048 */, 1073 /* e2052 */, 7465 /* e2056 */, 8236 /* e2060 */,
279 /* e2064 */, 4155 /* e2068 */, 6736 /* e2072 */, 1732 /* e2076 */,
2847 /* e2080 */,  956 /* e2084 */, 2667 /* e2088 */, 3426 /* e2092 */,
4440 /* e2096 */, 4482 /* e2100 */, 4641 /* e2104 */, 3180 /* e2108 */,
4842 /* e2112 */, 9823 /* e2116 */, 8270 /* e2120 */, 4858 /* e2124 */,
2601 /* e2128 */, 9642 /* e2132 */, 7257 /* e2136 */, 3971 /* e2140 */,
9192 /* e2144 */, 3839 /* e2148 */, 3812 /* e2152 */, 5945 /* e2156 */,
1509 /* e2160 */, 7237 /* e2164 */, 2170 /* e2168 */,  295 /* e2172 */,
2045 /* e2176 */, 8775 /* e2180 */,  485 /* e2184 */, 3263 /* e2188 */,
3840 /* e2192 */, 7092 /* e2196 */, 8059 /* e2200 */, 2773 /* e2204 */,
9532 /* e2208 */, 5680 /* e2212 */, 5612 /* e2216 */,  990 /* e2220 */,
8254 /* e2224 */, 1620 /* e2228 */, 5307 /* e2232 */, 3284 /* e2236 */,
517 /* e2240 */, 1869 /* e2244 */, 2268 /* e2248 */, 7030 /* e2252 */,
5711 /* e2256 */, 5481 /* e2260 */, 6405 /* e2264 */, 2199 /* e2268 */,
4230 /* e2272 */, 3727 /* e2276 */, 9408 /* e2280 */, 9099 /* e2284 */,
630 /* e2288 */,  279 /* e2292 */, 7345 /* e2296 */, 7042 /* e2300 */,
9483 /* e2304 */, 6052 /* e2308 */, 5056 /* e2312 */, 6649 /* e2316 */,
6218 /* e2320 */, 6124 /* e2324 */, 5175 /* e2328 */,  434 /* e2332 */,
1658 /* e2336 */, 5742 /* e2340 */, 4471 /* e2344 */, 4674 /* e2348 */,
4671 /* e2352 */, 7413 /* e2356 */, 9831 /* e2360 */, 6381 /* e2364 */,
6195 /* e2368 */, 7901 /* e2372 */, 9345 /* e2376 */, 5446 /* e2380 */,
8008 /* e2384 */, 7848 /* e2388 */, 1708 /* e2392 */, 2394 /* e2396 */,
9053 /* e2400 */, 1607 /* e2404 */, 7089 /* e2408 */, 7977 /* e2412 */,
1620 /* e2416 */, 3493 /* e2420 */, 8434 /* e2424 */, 5005 /* e2428 */,
3023 /* e2432 */, 9989 /* e2436 */, 9122 /* e2440 */, 4001 /* e2444 */,
836 /* e2448 */, 8232 /* e2452 */, 9344 /* e2456 */, 8279 /* e2460 */,
8242 /* e2464 */, 2768 /* e2468 */, 9504 /* e2472 */, 7478 /* e2476 */,
1895 /* e2480 */, 3391 /* e2484 */, 8241 /* e2488 */, 6162 /* e2492 */,
2510 /* e2496 */, 2178 /* e2500 */, 5254 /* e2504 */, 2609 /* e2508 */,
9268 /* e2512 */, 6379 /* e2516 */, 9762 /* e2520 */, 6526 /* e2524 */,
1820 /* e2528 */, 2554 /* e2532 */, 4616 /* e2536 */, 1757 /* e2540 */,
1234 /* e2544 */, 8827 /* e2548 */, 1967 /* e2552 */, 4238 /* e2556 */,
7838 /* e2560 */,  267 /* e2564 */, 6619 /* e2568 */, 8470 /* e2572 */,
2140 /* e2576 */, 2105 /* e2580 */, 8388 /* e2584 */, 6184 /* e2588 */,
9538 /* e2592 */, 8166 /* e2596 */, 6754 /* e2600 */, 7228 /* e2604 */,
6218 /* e2608 */, 9022 /* e2612 */, 1098 /* e2616 */, 4999 /* e2620 */,
4389 /* e2624 */,  592 /* e2628 */, 2674 /* e2632 */, 3075 /* e2636 */,
7989 /* e2640 */, 5049 /* e2644 */, 1152 /* e2648 */, 5662 /* e2652 */,
3796 /* e2656 */, 9398 /* e2660 */, 8698 /* e2664 */, 5785 /* e2668 */,
2897 /* e2672 */,  867 /* e2676 */, 9126 /* e2680 */,  312 /* e2684 */,
3650 /* e2688 */, 5419 /* e2692 */, 1498 /* e2696 */, 7181 /* e2700 */,
1295 /* e2704 */, 2708 /* e2708 */, 1777 /* e2712 */, 2849 /* e2716 */,
3763 /* e2720 */,  790 /* e2724 */,  494 /* e2728 */, 4131 /* e2732 */,
455 /* e2736 */, 1946 /* e2740 */, 8112 /* e2744 */, 2686 /* e2748 */,
5335 /* e2752 */, 3906 /* e2756 */, 6698 /* e2760 */, 9034 /* e2764 */,
2818 /* e2768 */, 1791 /* e2772 */,  893 /* e2776 */, 6207 /* e2780 */,
8300 /* e2784 */, 9589 /* e2788 */, 9771 /* e2792 */, 5393 /* e2796 */,
666 /* e2800 */, 2426 /* e2804 */, 7715 /* e2808 */, 7924 /* e2812 */,
4737 /* e2816 */, 3103 /* e2820 */, 4138 /* e2824 */, 5827 /* e2828 */,
7152 /* e2832 */, 1535 /* e2836 */, 9177 /* e2840 */, 5627 /* e2844 */,
1234 /* e2848 */, 8320 /* e2852 */, 7211 /* e2856 */, 2831 /* e2860 */,
1537 /* e2864 */, 7485 /* e2868 */, 9471 /* e2872 */, 2588 /* e2876 */,
1800 /* e2880 */, 3538 /* e2884 */, 6679 /* e2888 */, 8460 /* e2892 */,
8385 /* e2896 */, 9974 /* e2900 */, 3327 /* e2904 */, 1678 /* e2908 */,
9740 /* e2912 */, 5639 /* e2916 */, 2334 /* e2920 */, 7434 /* e2924 */,
4131 /* e2928 */,  198 /* e2932 */, 8662 /* e2936 */, 1565 /* e2940 */,
5672 /* e2944 */, 8578 /* e2948 */, 1134 /* e2952 */, 3205 /* e2956 */,
3281 /* e2960 */,  186 /* e2964 */, 7431 /* e2968 */, 4124 /* e2972 */,
5909 /* e2976 */,  259 /* e2980 */, 7340 /* e2984 */, 2500 /* e2988 */,
6160 /* e2992 */, 5836 /* e2996 */, 1740 /* e3000 */, 4019 /* e3004 */,
8584 /* e3008 */, 9621 /* e3012 */, 2371 /* e3016 */, 1801 /* e3020 */,
5462 /* e3024 */, 3940 /* e3028 */, 5979 /* e3032 */, 2489 /* e3036 */,
1315 /* e3040 */, 1092 /* e3044 */, 7423 /* e3048 */, 6368 /* e3052 */,
408 /* e3056 */,  865 /* e3060 */, 8193 /* e3064 */, 7667 /* e3068 */,
6293 /* e3072 */, 2615 /* e3076 */, 8779 /* e3080 */, 8650 /* e3084 */,
8979 /* e3088 */, 2208 /* e3092 */,  450 /* e3096 */, 1076 /* e3100 */,
8256 /* e3104 */, 2563 /* e3108 */, 2074 /* e3112 */, 1702 /* e3116 */,
8031 /* e3120 */,  629 /* e3124 */, 6862 /* e3128 */, 3360 /* e3132 */,
1338 /* e3136 */, 7458 /* e3140 */, 1247 /* e3144 */, 9953 /* e3148 */,
9370 /* e3152 */, 2806 /* e3156 */, 1113 /* e3160 */, 5499 /* e3164 */,
6988 /* e3168 */, 6223 /* e3172 */, 4620 /* e3176 */,  476 /* e3180 */,
4514 /* e3184 */, 4972 /* e3188 */, 1709 /* e3192 */, 5556 /* e3196 */,
7442 /* e3200 */, 6355 /* e3204 */, 1736 /* e3208 */, 8515 /* e3212 */,
1608 /* e3216 */, 3601 /* e3220 */, 1155 /* e3224 */, 5710 /* e3228 */,
1364 /* e3232 */, 4030 /* e3236 */, 9880 /* e3240 */, 5861 /* e3244 */,
5494 /* e3248 */, 5733 /* e3252 */, 5565 /* e3256 */, 9057 /* e3260 */,
4380 /* e3264 */, 6782 /* e3268 */, 2453 /* e3272 */, 3366 /* e3276 */,
5903 /* e3280 */, 5174 /* e3284 */, 8090 /* e3288 */, 5914 /* e3292 */,
2306 /* e3296 */, 4047 /* e3300 */, 4447 /* e3304 */, 3476 /* e3308 */,
2127 /* e3312 */, 2154 /* e3316 */, 5173 /* e3320 */, 7675 /* e3324 */,
5846 /* e3328 */, 5828 /* e3332 */, 5577 /* e3336 */,  371 /* e3340 */,
2140 /* e3344 */, 4199 /* e3348 */, 9096 /* e3352 */, 1158 /* e3356 */,
1394 /* e3360 */, 2347 /* e3364 */, 5280 /* e3368 */, 2889 /* e3372 */,
3316 /* e3376 */, 9081 /* e3380 */, 6816 /* e3384 */,  633 /* e3388 */,

/* 2**14080 =  */
6176 /* e   0 */,   14 /* e   4 */, 3861 /* e   8 */, 7717 /* e  12 */,
8184 /* e  16 */, 8495 /* e  20 */, 5733 /* e  24 */, 4458 /* e  28 */,
1278 /* e  32 */, 9068 /* e  36 */, 7846 /* e  40 */, 7741 /* e  44 */,
1748 /* e  48 */, 3386 /* e  52 */,  681 /* e  56 */, 1451 /* e  60 */,
2929 /* e  64 */,  775 /* e  68 */,  948 /* e  72 */, 6392 /* e  76 */,
7041 /* e  80 */, 8206 /* e  84 */, 9296 /* e  88 */, 2946 /* e  92 */,
3132 /* e  96 */, 1302 /* e 100 */, 4632 /* e 104 */, 2236 /* e 108 */,
6523 /* e 112 */, 9979 /* e 116 */, 1578 /* e 120 */, 7532 /* e 124 */,
4326 /* e 128 */, 9049 /* e 132 */,  250 /* e 136 */, 4785 /* e 140 */,
8626 /* e 144 */,  678 /* e 148 */, 2735 /* e 152 */, 3095 /* e 156 */,
4359 /* e 160 */, 4319 /* e 164 */, 9393 /* e 168 */, 2408 /* e 172 */,
7128 /* e 176 */, 3699 /* e 180 */,  847 /* e 184 */,  310 /* e 188 */,
3402 /* e 192 */,  691 /* e 196 */, 8905 /* e 200 */, 3292 /* e 204 */,
5748 /* e 208 */, 2141 /* e 212 */, 9499 /* e 216 */, 2654 /* e 220 */,
9508 /* e 224 */, 2701 /* e 228 */, 4489 /* e 232 */, 8525 /* e 236 */,
2733 /* e 240 */, 1595 /* e 244 */, 5940 /* e 248 */, 6571 /* e 252 */,
9231 /* e 256 */,  464 /* e 260 */, 9866 /* e 264 */, 5666 /* e 268 */,
4567 /* e 272 */, 4899 /* e 276 */, 6143 /* e 280 */, 2368 /* e 284 */,
6942 /* e 288 */, 1766 /* e 292 */, 6238 /* e 296 */, 7427 /* e 300 */,
722 /* e 304 */, 5729 /* e 308 */, 1104 /* e 312 */, 9421 /* e 316 */,
6785 /* e 320 */, 4901 /* e 324 */, 2075 /* e 328 */, 1326 /* e 332 */,
836 /* e 336 */, 1473 /* e 340 */,  978 /* e 344 */,  598 /* e 348 */,
5382 /* e 352 */, 2954 /* e 356 */,  819 /* e 360 */,  226 /* e 364 */,
6428 /* e 368 */, 2242 /* e 372 */,  845 /* e 376 */, 7043 /* e 380 */,
8648 /* e 384 */, 9659 /* e 388 */,  547 /* e 392 */, 7528 /* e 396 */,
5327 /* e 400 */, 5487 /* e 404 */, 7640 /* e 408 */, 5154 /* e 412 */,
2551 /* e 416 */, 2877 /* e 420 */,  301 /* e 424 */, 2057 /* e 428 */,
3362 /* e 432 */, 8750 /* e 436 */, 4135 /* e 440 */, 1662 /* e 444 */,
9842 /* e 448 */, 9217 /* e 452 */, 2660 /* e 456 */, 8153 /* e 460 */,
2055 /* e 464 */, 1316 /* e 468 */, 4712 /* e 472 */, 6353 /* e 476 */,
5116 /* e 480 */, 2529 /* e 484 */, 3233 /* e 488 */, 4281 /* e 492 */,
1829 /* e 496 */,   82 /* e 500 */, 9149 /* e 504 */, 5686 /* e 508 */,
9872 /* e 512 */, 1079 /* e 516 */,  984 /* e 520 */,  867 /* e 524 */,
3347 /* e 528 */, 1403 /* e 532 */, 8398 /* e 536 */, 9925 /* e 540 */,
4012 /* e 544 */, 7803 /* e 548 */,  282 /* e 552 */, 4127 /* e 556 */,
546 /* e 560 */, 9839 /* e 564 */, 8975 /* e 568 */, 1000 /* e 572 */,
5183 /* e 576 */, 4415 /* e 580 */, 3928 /* e 584 */, 7934 /* e 588 */,
4356 /* e 592 */, 1792 /* e 596 */, 1225 /* e 600 */, 7552 /* e 604 */,
6405 /* e 608 */, 6462 /* e 612 */, 7824 /* e 616 */, 1631 /* e 620 */,
370 /* e 624 */, 7948 /* e 628 */, 2974 /* e 632 */, 3268 /* e 636 */,
2557 /* e 640 */, 3660 /* e 644 */, 6298 /* e 648 */, 6034 /* e 652 */,
3212 /* e 656 */, 5390 /* e 660 */, 9950 /* e 664 */, 4798 /* e 668 */,
533 /* e 672 */, 3434 /* e 676 */, 1154 /* e 680 */, 6351 /* e 684 */,
3349 /* e 688 */, 8768 /* e 692 */, 8751 /* e 696 */, 9231 /* e 700 */,
9926 /* e 704 */, 5076 /* e 708 */,  819 /* e 712 */, 1086 /* e 716 */,
2204 /* e 720 */, 6542 /* e 724 */, 4887 /* e 728 */, 9428 /* e 732 */,
7480 /* e 736 */, 7424 /* e 740 */, 4161 /* e 744 */, 6002 /* e 748 */,
9683 /* e 752 */, 9330 /* e 756 */, 9820 /* e 760 */, 2223 /* e 764 */,
5534 /* e 768 */,   73 /* e 772 */, 1196 /* e 776 */, 4395 /* e 780 */,
8186 /* e 784 */, 2004 /* e 788 */, 1009 /* e 792 */, 1946 /* e 796 */,
8984 /* e 800 */, 5464 /* e 804 */, 6321 /* e 808 */,  226 /* e 812 */,
1460 /* e 816 */, 7630 /* e 820 */,  923 /* e 824 */, 2623 /* e 828 */,
459 /* e 832 */, 6256 /* e 836 */,  806 /* e 840 */, 7363 /* e 844 */,
4909 /* e 848 */, 6149 /* e 852 */, 9125 /* e 856 */, 4187 /* e 860 */,
7428 /* e 864 */, 4368 /* e 868 */, 9402 /* e 872 */, 4220 /* e 876 */,
4343 /* e 880 */, 6591 /* e 884 */, 3698 /* e 888 */, 4184 /* e 892 */,
2347 /* e 896 */, 5795 /* e 900 */, 1315 /* e 904 */, 3411 /* e 908 */,
3811 /* e 912 */,   78 /* e 916 */, 7269 /* e 920 */, 9256 /* e 924 */,
8002 /* e 928 */,  483 /* e 932 */, 7013 /* e 936 */, 6053 /* e 940 */,
1744 /* e 944 */, 9927 /* e 948 */, 1575 /* e 952 */, 6167 /* e 956 */,
2256 /* e 960 */, 4116 /* e 964 */, 9526 /* e 968 */, 8434 /* e 972 */,
779 /* e 976 */, 1148 /* e 980 */, 2850 /* e 984 */,  475 /* e 988 */,
6639 /* e 992 */, 2940 /* e 996 */, 6508 /* e1000 */, 9263 /* e1004 */,
8673 /* e1008 */, 1258 /* e1012 */, 9756 /* e1016 */,  267 /* e1020 */,
8853 /* e1024 */, 6509 /* e1028 */, 4199 /* e1032 */, 1329 /* e1036 */,
4289 /* e1040 */, 4346 /* e1044 */, 8512 /* e1048 */, 6695 /* e1052 */,
826 /* e1056 */, 5332 /* e1060 */, 6516 /* e1064 */,    2 /* e1068 */,
1170 /* e1072 */, 1873 /* e1076 */, 6094 /* e1080 */,  853 /* e1084 */,
4229 /* e1088 */, 4752 /* e1092 */, 7504 /* e1096 */, 3574 /* e1100 */,
1397 /* e1104 */, 8628 /* e1108 */, 8992 /* e1112 */, 9891 /* e1116 */,
1912 /* e1120 */, 4957 /* e1124 */, 6627 /* e1128 */, 5224 /* e1132 */,
9958 /* e1136 */, 9890 /* e1140 */, 9046 /* e1144 */, 3229 /* e1148 */,
2143 /* e1152 */, 6295 /* e1156 */, 2332 /* e1160 */, 1627 /* e1164 */,
5501 /* e1168 */, 6061 /* e1172 */, 5678 /* e1176 */, 5638 /* e1180 */,
6330 /* e1184 */, 5671 /* e1188 */, 6741 /* e1192 */,  129 /* e1196 */,
3281 /* e1200 */, 8783 /* e1204 */, 6456 /* e1208 */,  532 /* e1212 */,
64 /* e1216 */, 5761 /* e1220 */, 9912 /* e1224 */, 4141 /* e1228 */,
3649 /* e1232 */, 8756 /* e1236 */, 1743 /* e1240 */, 9494 /* e1244 */,
5300 /* e1248 */, 2498 /* e1252 */, 3458 /* e1256 */, 4915 /* e1260 */,
6356 /* e1264 */, 7716 /* e1268 */, 1217 /* e1272 */, 5340 /* e1276 */,
6822 /* e1280 */, 6869 /* e1284 */, 1597 /* e1288 */, 2453 /* e1292 */,
8189 /* e1296 */, 4908 /* e1300 */, 2370 /* e1304 */, 7455 /* e1308 */,
1214 /* e1312 */, 2475 /* e1316 */, 9263 /* e1320 */, 1755 /* e1324 */,
2902 /* e1328 */, 7549 /* e1332 */, 6262 /* e1336 */, 9380 /* e1340 */,
627 /* e1344 */, 5445 /* e1348 */, 9325 /* e1352 */, 6391 /* e1356 */,
8941 /* e1360 */, 5852 /* e1364 */, 4423 /* e1368 */, 4906 /* e1372 */,
3339 /* e1376 */, 4762 /* e1380 */, 2472 /* e1384 */, 2268 /* e1388 */,
4203 /* e1392 */, 7037 /* e1396 */,  458 /* e1400 */,  544 /* e1404 */,
328 /* e1408 */, 8619 /* e1412 */, 7957 /* e1416 */,  912 /* e1420 */,
3352 /* e1424 */, 9591 /* e1428 */, 2280 /* e1432 */, 8717 /* e1436 */,
6109 /* e1440 */, 1506 /* e1444 */, 4219 /* e1448 */, 6575 /* e1452 */,
5169 /* e1456 */, 1476 /* e1460 */, 1090 /* e1464 */, 6629 /* e1468 */,
173 /* e1472 */, 7390 /* e1476 */,  440 /* e1480 */, 9841 /* e1484 */,
4912 /* e1488 */, 2667 /* e1492 */, 7815 /* e1496 */, 8097 /* e1500 */,
9982 /* e1504 */, 7618 /* e1508 */, 2454 /* e1512 */, 5155 /* e1516 */,
9293 /* e1520 */,  851 /* e1524 */, 7501 /* e1528 */, 4453 /* e1532 */,
712 /* e1536 */, 5888 /* e1540 */, 8686 /* e1544 */, 5161 /* e1548 */,
9629 /* e1552 */, 1557 /* e1556 */, 9376 /* e1560 */, 3703 /* e1564 */,
9600 /* e1568 */, 2760 /* e1572 */, 3399 /* e1576 */, 9990 /* e1580 */,
6296 /* e1584 */, 4447 /* e1588 */, 7355 /* e1592 */, 3456 /* e1596 */,
180 /* e1600 */,   45 /* e1604 */,  913 /* e1608 */, 3201 /* e1612 */,
1161 /* e1616 */, 1869 /* e1620 */, 6238 /* e1624 */, 4151 /* e1628 */,
6764 /* e1632 */, 5302 /* e1636 */, 9015 /* e1640 */, 5759 /* e1644 */,
6164 /* e1648 */, 2762 /* e1652 */, 9723 /* e1656 */, 7354 /* e1660 */,
7709 /* e1664 */, 4897 /* e1668 */, 6590 /* e1672 */, 8748 /* e1676 */,
9416 /* e1680 */, 2168 /* e1684 */, 5123 /* e1688 */, 9631 /* e1692 */,
8338 /* e1696 */, 5462 /* e1700 */, 7839 /* e1704 */, 8367 /* e1708 */,
5384 /* e1712 */, 4680 /* e1716 */,  928 /* e1720 */, 4888 /* e1724 */,
923 /* e1728 */, 4262 /* e1732 */, 4678 /* e1736 */, 3608 /* e1740 */,
20 /* e1744 */, 7879 /* e1748 */, 6592 /* e1752 */, 6290 /* e1756 */,
3437 /* e1760 */, 9847 /* e1764 */, 2902 /* e1768 */, 2166 /* e1772 */,
5761 /* e1776 */,  438 /* e1780 */, 7947 /* e1784 */, 8221 /* e1788 */,
7083 /* e1792 */, 7182 /* e1796 */, 2753 /* e1800 */, 8700 /* e1804 */,
7047 /* e1808 */, 1091 /* e1812 */, 1660 /* e1816 */,   58 /* e1820 */,
268 /* e1824 */,  764 /* e1828 */, 7443 /* e1832 */, 8680 /* e1836 */,
4063 /* e1840 */, 4895 /* e1844 */, 8810 /* e1848 */, 9446 /* e1852 */,
1992 /* e1856 */, 4617 /* e1860 */, 8408 /* e1864 */, 4267 /* e1868 */,
2438 /* e1872 */, 7607 /* e1876 */, 7058 /* e1880 */, 3697 /* e1884 */,
3396 /* e1888 */, 2517 /* e1892 */, 2809 /* e1896 */, 8814 /* e1900 */,
1110 /* e1904 */, 9093 /* e1908 */, 1696 /* e1912 */, 9580 /* e1916 */,
7600 /* e1920 */, 4136 /* e1924 */, 6575 /* e1928 */, 8769 /* e1932 */,
5380 /* e1936 */, 7024 /* e1940 */, 2913 /* e1944 */, 3841 /* e1948 */,
901 /* e1952 */, 8925 /* e1956 */, 6494 /* e1960 */, 3000 /* e1964 */,
7083 /* e1968 */, 4692 /* e1972 */, 2855 /* e1976 */, 2149 /* e1980 */,
3785 /* e1984 */, 4633 /* e1988 */, 4231 /* e1992 */, 4430 /* e1996 */,
245 /* e2000 */, 5596 /* e2004 */, 8422 /* e2008 */, 6801 /* e2012 */,
9581 /* e2016 */,  470 /* e2020 */, 4620 /* e2024 */, 1955 /* e2028 */,
9748 /* e2032 */, 5173 /* e2036 */,  743 /* e2040 */, 5821 /* e2044 */,
2549 /* e2048 */, 2064 /* e2052 */, 2380 /* e2056 */, 6023 /* e2060 */,
3096 /* e2064 */,  559 /* e2068 */, 2544 /* e2072 */, 2931 /* e2076 */,
4103 /* e2080 */, 3925 /* e2084 */, 3625 /* e2088 */, 5924 /* e2092 */,
8495 /* e2096 */, 3625 /* e2100 */, 3335 /* e2104 */, 4017 /* e2108 */,
631 /* e2112 */, 2920 /* e2116 */, 7316 /* e2120 */, 5867 /* e2124 */,
2496 /* e2128 */, 2275 /* e2132 */, 9350 /* e2136 */, 6397 /* e2140 */,
4402 /* e2144 */, 9248 /* e2148 */, 2921 /* e2152 */, 7863 /* e2156 */,
89 /* e2160 */,  316 /* e2164 */,  389 /* e2168 */, 3866 /* e2172 */,
9308 /* e2176 */, 3105 /* e2180 */, 9586 /* e2184 */, 5228 /* e2188 */,
405 /* e2192 */, 6313 /* e2196 */,  151 /* e2200 */, 8103 /* e2204 */,
3725 /* e2208 */,  561 /* e2212 */,  732 /* e2216 */, 5087 /* e2220 */,
4645 /* e2224 */, 1499 /* e2228 */, 1900 /* e2232 */, 5818 /* e2236 */,
3089 /* e2240 */, 8979 /* e2244 */, 2065 /* e2248 */, 3519 /* e2252 */,
7819 /* e2256 */, 6905 /* e2260 */, 6044 /* e2264 */, 5347 /* e2268 */,
7785 /* e2272 */, 5304 /* e2276 */, 1332 /* e2280 */, 6811 /* e2284 */,
7552 /* e2288 */, 2402 /* e2292 */, 6384 /* e2296 */, 6230 /* e2300 */,
2287 /* e2304 */, 1286 /* e2308 */, 3285 /* e2312 */, 7295 /* e2316 */,
5851 /* e2320 */, 9892 /* e2324 */, 8971 /* e2328 */, 7160 /* e2332 */,
8405 /* e2336 */, 9325 /* e2340 */, 3714 /* e2344 */, 8714 /* e2348 */,
6701 /* e2352 */, 6183 /* e2356 */, 3109 /* e2360 */, 6177 /* e2364 */,
4112 /* e2368 */, 5873 /* e2372 */, 8895 /* e2376 */, 6676 /* e2380 */,
1422 /* e2384 */,  244 /* e2388 */, 9362 /* e2392 */,  561 /* e2396 */,
9129 /* e2400 */, 8368 /* e2404 */, 5768 /* e2408 */, 1073 /* e2412 */,
3504 /* e2416 */, 3255 /* e2420 */,  669 /* e2424 */, 3958 /* e2428 */,
7382 /* e2432 */,  316 /* e2436 */, 1312 /* e2440 */, 8758 /* e2444 */,
2695 /* e2448 */,  483 /* e2452 */, 3601 /* e2456 */,  207 /* e2460 */,
6445 /* e2464 */, 5117 /* e2468 */, 7221 /* e2472 */, 1398 /* e2476 */,
2926 /* e2480 */, 4306 /* e2484 */, 7873 /* e2488 */, 8636 /* e2492 */,
9627 /* e2496 */, 1908 /* e2500 */, 9557 /* e2504 */, 1036 /* e2508 */,
9198 /* e2512 */, 7904 /* e2516 */,  119 /* e2520 */, 3793 /* e2524 */,
3800 /* e2528 */, 4620 /* e2532 */, 5010 /* e2536 */, 7182 /* e2540 */,
1562 /* e2544 */, 8544 /* e2548 */, 1843 /* e2552 */, 6717 /* e2556 */,
54 /* e2560 */, 8787 /* e2564 */, 4766 /* e2568 */, 5880 /* e2572 */,
648 /* e2576 */, 3331 /* e2580 */, 8034 /* e2584 */, 3383 /* e2588 */,
8374 /* e2592 */, 2510 /* e2596 */,  849 /* e2600 */, 7426 /* e2604 */,
6845 /* e2608 */, 4247 /* e2612 */,  999 /* e2616 */, 3771 /* e2620 */,
8289 /* e2624 */, 6960 /* e2628 */, 4446 /* e2632 */, 1874 /* e2636 */,
7999 /* e2640 */, 9821 /* e2644 */, 7441 /* e2648 */, 5555 /* e2652 */,
1992 /* e2656 */, 9471 /* e2660 */, 7461 /* e2664 */, 2665 /* e2668 */,
8562 /* e2672 */, 5612 /* e2676 */, 5808 /* e2680 */, 6921 /* e2684 */,
5218 /* e2688 */, 4194 /* e2692 */, 6732 /* e2696 */, 1644 /* e2700 */,
2794 /* e2704 */, 3862 /* e2708 */, 7199 /* e2712 */, 3795 /* e2716 */,
6207 /* e2720 */, 9205 /* e2724 */, 9009 /* e2728 */, 7448 /* e2732 */,
6554 /* e2736 */, 1918 /* e2740 */, 8029 /* e2744 */, 1475 /* e2748 */,
9091 /* e2752 */, 4595 /* e2756 */, 9189 /* e2760 */, 8918 /* e2764 */,
6437 /* e2768 */, 7541 /* e2772 */, 9385 /* e2776 */, 4148 /* e2780 */,
4128 /* e2784 */, 7616 /* e2788 */, 2204 /* e2792 */, 7289 /* e2796 */,
2368 /* e2800 */, 9931 /* e2804 */, 1152 /* e2808 */, 7511 /* e2812 */,
3318 /* e2816 */, 3525 /* e2820 */,  978 /* e2824 */, 3044 /* e2828 */,
3427 /* e2832 */, 4866 /* e2836 */, 3592 /* e2840 */, 6455 /* e2844 */,
683 /* e2848 */, 2061 /* e2852 */, 5455 /* e2856 */, 4732 /* e2860 */,
5469 /* e2864 */, 1181 /* e2868 */, 6069 /* e2872 */, 6208 /* e2876 */,
8944 /* e2880 */, 1245 /* e2884 */,  329 /* e2888 */,  302 /* e2892 */,
828 /* e2896 */,  930 /* e2900 */, 6794 /* e2904 */, 1430 /* e2908 */,
4662 /* e2912 */, 5959 /* e2916 */, 7208 /* e2920 */, 7788 /* e2924 */,
995 /* e2928 */, 5894 /* e2932 */, 8616 /* e2936 */, 2471 /* e2940 */,
4056 /* e2944 */, 7757 /* e2948 */,  362 /* e2952 */, 2609 /* e2956 */,
747 /* e2960 */, 5154 /* e2964 */, 3339 /* e2968 */,  725 /* e2972 */,
5694 /* e2976 */, 9337 /* e2980 */, 1952 /* e2984 */, 8738 /* e2988 */,
8667 /* e2992 */,  810 /* e2996 */, 3380 /* e3000 */, 7400 /* e3004 */,
9471 /* e3008 */, 8386 /* e3012 */,  886 /* e3016 */, 6135 /* e3020 */,
7490 /* e3024 */,  231 /* e3028 */, 2459 /* e3032 */,  324 /* e3036 */,
3276 /* e3040 */, 4038 /* e3044 */, 3313 /* e3048 */,  847 /* e3052 */,
5175 /* e3056 */, 8738 /* e3060 */,  574 /* e3064 */, 8686 /* e3068 */,
9717 /* e3072 */, 2629 /* e3076 */, 5276 /* e3080 */, 6947 /* e3084 */,
5278 /* e3088 */, 1420 /* e3092 */, 7098 /* e3096 */, 9071 /* e3100 */,
2854 /* e3104 */,  855 /* e3108 */, 2339 /* e3112 */, 9732 /* e3116 */,
5707 /* e3120 */, 4445 /* e3124 */, 2632 /* e3128 */, 3914 /* e3132 */,
5661 /* e3136 */,  748 /* e3140 */, 2222 /* e3144 */, 5061 /* e3148 */,
9918 /* e3152 */, 9512 /* e3156 */, 2256 /* e3160 */, 4168 /* e3164 */,
6565 /* e3168 */, 4093 /* e3172 */, 1319 /* e3176 */,   14 /* e3180 */,
8900 /* e3184 */, 6524 /* e3188 */,  431 /* e3192 */, 6912 /* e3196 */,
149 /* e3200 */, 7477 /* e3204 */, 8441 /* e3208 */, 7704 /* e3212 */,
3161 /* e3216 */, 8472 /* e3220 */, 3719 /* e3224 */, 6146 /* e3228 */,
2936 /* e3232 */, 7663 /* e3236 */,  563 /* e3240 */, 3344 /* e3244 */,
9811 /* e3248 */, 3109 /* e3252 */, 6319 /* e3256 */, 8906 /* e3260 */,
9472 /* e3264 */, 1499 /* e3268 */, 8108 /* e3272 */, 5625 /* e3276 */,
1919 /* e3280 */, 5516 /* e3284 */, 3587 /* e3288 */, 8068 /* e3292 */,
7859 /* e3296 */, 4097 /* e3300 */, 5349 /* e3304 */, 7738 /* e3308 */,
2861 /* e3312 */,  383 /* e3316 */, 9379 /* e3320 */, 8279 /* e3324 */,
1035 /* e3328 */,  255 /* e3332 */, 2366 /* e3336 */, 2460 /* e3340 */,
783 /* e3344 */, 8832 /* e3348 */, 9436 /* e3352 */, 6887 /* e3356 */,
1077 /* e3360 */, 6080 /* e3364 */, 6255 /* e3368 */, 4204 /* e3372 */,
4921 /* e3376 */, 9086 /* e3380 */, 5018 /* e3384 */, 7755 /* e3388 */,
8776 /* e3392 */, 9688 /* e3396 */, 5093 /* e3400 */, 7260 /* e3404 */,
4139 /* e3408 */, 2374 /* e3412 */, 5357 /* e3416 */, 5824 /* e3420 */,
2839 /* e3424 */, 7791 /* e3428 */, 4931 /* e3432 */, 5468 /* e3436 */,
3870 /* e3440 */, 1522 /* e3444 */, 8144 /* e3448 */, 9185 /* e3452 */,
2300 /* e3456 */, 6332 /* e3460 */, 7758 /* e3464 */, 2058 /* e3468 */,
8158 /* e3472 */, 3714 /* e3476 */, 1712 /* e3480 */, 4015 /* e3484 */,
7244 /* e3488 */, 8907 /* e3492 */, 5207 /* e3496 */, 4947 /* e3500 */,
4694 /* e3504 */, 7323 /* e3508 */, 3624 /* e3512 */, 8079 /* e3516 */,
6936 /* e3520 */, 4531 /* e3524 */, 7561 /* e3528 */, 5731 /* e3532 */,
642 /* e3536 */, 9443 /* e3540 */, 7894 /* e3544 */, 4576 /* e3548 */,
7662 /* e3552 */, 1573 /* e3556 */, 6879 /* e3560 */, 2182 /* e3564 */,
9248 /* e3568 */, 5783 /* e3572 */, 5030 /* e3576 */, 3170 /* e3580 */,
2714 /* e3584 */, 8639 /* e3588 */, 1370 /* e3592 */, 3855 /* e3596 */,
6553 /* e3600 */, 8693 /* e3604 */, 9608 /* e3608 */, 2222 /* e3612 */,
6816 /* e3616 */, 4934 /* e3620 */, 3716 /* e3624 */, 2624 /* e3628 */,
3317 /* e3632 */, 7241 /* e3636 */, 2927 /* e3640 */, 4217 /* e3644 */,
8720 /* e3648 */, 6855 /* e3652 */, 4332 /* e3656 */, 9975 /* e3660 */,
3323 /* e3664 */, 9666 /* e3668 */, 5674 /* e3672 */,  839 /* e3676 */,
1346 /* e3680 */, 2176 /* e3684 */, 5171 /* e3688 */, 6107 /* e3692 */,
1079 /* e3696 */, 5009 /* e3700 */, 2857 /* e3704 */, 8499 /* e3708 */,
7020 /* e3712 */, 5657 /* e3716 */, 6602 /* e3720 */, 1590 /* e3724 */,
4486 /* e3728 */, 6208 /* e3732 */, 9825 /* e3736 */, 3055 /* e3740 */,
9130 /* e3744 */, 1758 /* e3748 */, 6040 /* e3752 */, 2830 /* e3756 */,
1117 /* e3760 */, 5241 /* e3764 */,  630 /* e3768 */, 4424 /* e3772 */,
8729 /* e3776 */, 1834 /* e3780 */, 5204 /* e3784 */, 1580 /* e3788 */,
6077 /* e3792 */, 1739 /* e3796 */, 9031 /* e3800 */, 8660 /* e3804 */,
5416 /* e3808 */, 1540 /* e3812 */, 3180 /* e3816 */, 5129 /* e3820 */,
8907 /* e3824 */, 6798 /* e3828 */, 5265 /* e3832 */, 6654 /* e3836 */,
9041 /* e3840 */, 9672 /* e3844 */,    3 /* e3848 */, 3191 /* e3852 */,
4289 /* e3856 */, 6077 /* e3860 */, 5409 /* e3864 */, 4391 /* e3868 */,
2572 /* e3872 */, 4194 /* e3876 */, 3334 /* e3880 */,  257 /* e3884 */,
7290 /* e3888 */, 3028 /* e3892 */,  105 /* e3896 */, 6159 /* e3900 */,
2295 /* e3904 */, 3936 /* e3908 */, 5581 /* e3912 */, 3006 /* e3916 */,
5066 /* e3920 */,   23 /* e3924 */, 4170 /* e3928 */, 3383 /* e3932 */,
2410 /* e3936 */, 6312 /* e3940 */,  929 /* e3944 */, 4663 /* e3948 */,
9452 /* e3952 */, 7196 /* e3956 */, 2746 /* e3960 */, 2233 /* e3964 */,
4371 /* e3968 */, 6091 /* e3972 */,   16 /* e3976 */, 3085 /* e3980 */,
773 /* e3984 */, 6318 /* e3988 */,  183 /* e3992 */, 5889 /* e3996 */,
5010 /* e4000 */, 5232 /* e4004 */, 7354 /* e4008 */,  858 /* e4012 */,
7503 /* e4016 */, 5657 /* e4020 */, 3147 /* e4024 */, 1786 /* e4028 */,
6075 /* e4032 */, 5546 /* e4036 */, 6059 /* e4040 */, 5911 /* e4044 */,
1925 /* e4048 */, 4290 /* e4052 */, 1399 /* e4056 */, 5483 /* e4060 */,
756 /* e4064 */, 3424 /* e4068 */, 1816 /* e4072 */,  925 /* e4076 */,
5494 /* e4080 */, 6020 /* e4084 */,  462 /* e4088 */, 1097 /* e4092 */,
4109 /* e4096 */, 3695 /* e4100 */, 9985 /* e4104 */, 2319 /* e4108 */,
3068 /* e4112 */, 7202 /* e4116 */, 1222 /* e4120 */, 8895 /* e4124 */,
8360 /* e4128 */, 4308 /* e4132 */, 1666 /* e4136 */, 7831 /* e4140 */,
6913 /* e4144 */, 5400 /* e4148 */, 6107 /* e4152 */, 8104 /* e4156 */,
9653 /* e4160 */, 6384 /* e4164 */, 9736 /* e4168 */, 4641 /* e4172 */,
7651 /* e4176 */, 5778 /* e4180 */, 3792 /* e4184 */, 2268 /* e4188 */,
2690 /* e4192 */, 4757 /* e4196 */, 6184 /* e4200 */, 8329 /* e4204 */,
2712 /* e4208 */, 5805 /* e4212 */, 8661 /* e4216 */, 6875 /* e4220 */,
7356 /* e4224 */, 4570 /* e4228 */, 9354 /* e4232 */,  317 /* e4236 */,

0};

/* table of starting indexes into previous table  */
const unsigned short __tbl_2_huge_start [] = {
0, 1, 213, 637, 1273, 2121, 3181, 0};
