/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 1997 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*	Copyright (c) 1988 AT&T	*/
/*	  All Rights Reserved	*/

/*
 * University Copyright- Copyright (c) 1982, 1986, 1988
 * The Regents of the University of California
 * All Rights Reserved
 *
 * University Acknowledgment- Portions of this document are derived from
 * software developed by the University of California, Berkeley, and its
 * contributors.
 */

#pragma ident	"%Z%%M%	%I%	%E% SMI"

/*LINTLIBRARY*/

#include	<sys/types.h>
#include	"curses_inc.h"

/* Clear the soft labels. */

int
slk_clear(void)
{
	SLK_MAP	*slk;
	int	i;
	char *	spaces = "        ";

	if ((slk = SP->slk) == NULL)
		return (ERR);

	slk->_changed = 2;	/* This means no more soft labels. */
	if (slk->_win) {
		(void) werase(slk->_win);
		(void) wrefresh(slk->_win);
	} else {
		/* send hardware clear sequences */
		for (i = 0; i < slk->_num; i++)
			_PUTS(tparm_p2(plab_norm, i + 1,
			    (long) spaces), 1);
		_PUTS(label_off, 1);
		(void) fflush(SP->term_file);
	}

	for (i = 0; i < slk->_num; ++i)
		slk->_lch[i] = FALSE;

	return (OK);
}
