/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 *
 * ident	"%Z%%M%	%I%	%E% SMI"
 */
package org.opensolaris.os.dtrace;

/**
 * A value generated by the DTrace {@code mod()}, {@code func()}, {@code
 * sym()}, {@code umod()}, {@code ufunc()} or {@code usym()} action used
 * to lookup the symbol associated with an address in probe context.
 *
 * @author Tom Erickson
 */
public interface SymbolValueRecord extends ValueRecord {
    /**
     * Gets the result of the address lookup.
     *
     * @return non-null address lookup in the format defined by the
     * native DTrace library
     */
    public String getSymbol();

    /**
     * Gets the symbol address.
     *
     * @return the symbol address
     */
    public long getAddress();
}
