/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2009 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _SOLARIS_KSH_CMDLIST_H
#define	_SOLARIS_KSH_CMDLIST_H

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * List builtins for Solaris.
 * The list here is partially autogenerated and partially hand-picked
 * based on compatibility with the native Solaris versions of these
 * tools
 */

/* POSIX compatible commands */
#ifdef _NOT_YET
#define	XPG6CMDLIST(f)	\
	{ "/usr/xpg6/bin/" #f, NV_BLTIN|NV_BLTINOPT|NV_NOFREE, bltin(f) },
#define	XPG4CMDLIST(f)	\
	{ "/usr/xpg4/bin/" #f, NV_BLTIN|NV_BLTINOPT|NV_NOFREE, bltin(f) },
#else
#define	XPG6CMDLIST(f)
#define	XPG4CMDLIST(f)
#endif /* NOT_YET */
/*
 * Commands which are 100% compatible with native Solaris versions (/bin is
 * a softlink to ./usr/bin, ksh93 takes care about the lookup)
 */
#define	BINCMDLIST(f)	\
	{ "/bin/"	#f, NV_BLTIN|NV_BLTINOPT|NV_NOFREE, bltin(f) },
#define	USRBINCMDLIST(f)	\
	{ "/usr/bin/"	#f, NV_BLTIN|NV_BLTINOPT|NV_NOFREE, bltin(f) },
#define	SBINCMDLIST(f)	\
	{ "/sbin/"	#f, NV_BLTIN|NV_BLTINOPT|NV_NOFREE, bltin(f) },
#define	SUSRBINCMDLIST(f)	\
	{ "/usr/sbin/"	#f, NV_BLTIN|NV_BLTINOPT|NV_NOFREE, bltin(f) },
/*
 * Make all ksh93 builtins accessible when /usr/ast/bin was added to
 * /usr/xpg6/bin:/usr/xpg4/bin:/usr/ccs/bin:/usr/bin:/bin:/opt/SUNWspro/bin
 */
#define	ASTCMDLIST(f)	\
	{ "/usr/ast/bin/" #f, NV_BLTIN|NV_BLTINOPT|NV_NOFREE, bltin(f) },

/* undo ast_map.h #defines to avoid collision */
#undef basename
#undef dirname
#undef mktemp

/* Generated data, do not edit. */
XPG4CMDLIST(basename)
ASTCMDLIST(basename)
BINCMDLIST(cat)
ASTCMDLIST(cat)
XPG4CMDLIST(chgrp)
ASTCMDLIST(chgrp)
ASTCMDLIST(chmod)
XPG4CMDLIST(chown)
BINCMDLIST(chown)
ASTCMDLIST(chown)
BINCMDLIST(cksum)
ASTCMDLIST(cksum)
BINCMDLIST(cmp)
ASTCMDLIST(cmp)
BINCMDLIST(comm)
ASTCMDLIST(comm)
XPG4CMDLIST(cp)
ASTCMDLIST(cp)
BINCMDLIST(cut)
ASTCMDLIST(cut)
XPG4CMDLIST(date)
ASTCMDLIST(date)
ASTCMDLIST(dirname)
ASTCMDLIST(egrep)
XPG4CMDLIST(expr)
ASTCMDLIST(expr)
ASTCMDLIST(fds)
ASTCMDLIST(fgrep)
ASTCMDLIST(fmt)
BINCMDLIST(fold)
ASTCMDLIST(fold)
ASTCMDLIST(grep)
BINCMDLIST(head)
ASTCMDLIST(head)
XPG4CMDLIST(id)
ASTCMDLIST(id)
BINCMDLIST(join)
ASTCMDLIST(join)
XPG4CMDLIST(ln)
ASTCMDLIST(ln)
BINCMDLIST(logname)
ASTCMDLIST(logname)
ASTCMDLIST(md5sum)
BINCMDLIST(mkdir)
ASTCMDLIST(mkdir)
BINCMDLIST(mkfifo)
ASTCMDLIST(mkfifo)
BINCMDLIST(mktemp)
ASTCMDLIST(mktemp)
XPG4CMDLIST(mv)
ASTCMDLIST(mv)
BINCMDLIST(paste)
ASTCMDLIST(paste)
BINCMDLIST(pathchk)
ASTCMDLIST(pathchk)
ASTCMDLIST(readlink)
BINCMDLIST(rev)
ASTCMDLIST(rev)
XPG4CMDLIST(rm)
ASTCMDLIST(rm)
BINCMDLIST(rmdir)
ASTCMDLIST(rmdir)
XPG4CMDLIST(stty)
ASTCMDLIST(stty)
BINCMDLIST(sum)
ASTCMDLIST(sum)
SUSRBINCMDLIST(sync)
SBINCMDLIST(sync)
BINCMDLIST(sync)
ASTCMDLIST(sync)
XPG4CMDLIST(tail)
BINCMDLIST(tail)
ASTCMDLIST(tail)
BINCMDLIST(tee)
ASTCMDLIST(tee)
BINCMDLIST(tty)
ASTCMDLIST(tty)
ASTCMDLIST(uname)
BINCMDLIST(uniq)
ASTCMDLIST(uniq)
BINCMDLIST(wc)
ASTCMDLIST(wc)
ASTCMDLIST(xgrep)

/* Mandatory for ksh93 test suite and AST scripts */
BINCMDLIST(getconf)

#ifdef	__cplusplus
}
#endif

#endif /* !_SOLARIS_KSH_CMDLIST_H */
