/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 * Copyright 2008 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */



#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <thread.h>
#include <synch.h>
#include <mms_sym.h>


static	mms_sym_t	mms_err_symtab[] = {

	"UNKNOWN_CODE",			MMS_UNKNOWN_CODE,

	/*
	 * Error class
	 */
	"state",			MMS_STATE,
	"compat",			MMS_COMPAT,
	"config",			MMS_CONFIG,
	"exist",			MMS_EXIST,
	"explicit",			MMS_EXPLICIT,
	"internal",			MMS_INTERNAL,
	"invalid",			MMS_INVALID,
	"permpriv",			MMS_PERMPRIV,
	"retry",			MMS_RETRY,
	"subop",			MMS_SUBOP,
	"language",			MMS_LANGUAGE,
	"DM_C_INVALID",			MMS_DM_C_INVALID,
	"DM_C_COMMAND",			MMS_DM_C_COMMAND,
	"LM_C_INVALID",			MMS_LM_C_INVALID,
	"LM_C_COMMAND",			MMS_LM_C_COMMAND,
	"MM_C_INVALID",			MMS_MM_C_INVALID,
	"MM_C_MANAGEMENT",		MMS_MM_C_MANAGEMENT,

	/*
	 * Error codes
	 */

	"E_NET_IO_ERR",			MMS_E_NET_IO_ERR,
	"E_SYNTAX_ERR",			MMS_E_SYNTAX_ERR,
	"E_INVALID_RESPONSE",		MMS_E_INVALID_RESPONSE,
	"E_UNKNOWN_ERR_STRING",		MMS_E_UNKNOWN_ERR_STRING,
	"E_OUTOFMEMORY",		MMS_E_OUTOFMEMORY,
	"E_CONNECT_ERR",		MMS_E_CONNECT_ERR,
	"E_SSL_CERT_CLAUSE",		MMS_E_SSL_CERT_CLAUSE,
	"E_WELCOME_PASSWORD",		MMS_E_WELCOME_PASSWORD,
	"E_NO_WELCOME_PASSWORD",	MMS_E_NO_WELCOME_PASSWORD,
	"E_SSL_VERIFY",			MMS_E_SSL_VERIFY,

	/*
	 * The following are error codes added by MMS for client API
	 */

	"MALLOC_ERROR",			MMS_MALLOC_ERROR,
	"SELECT_ERROR",			MMS_SELECT_ERROR,
	"UNACCEPTABLE_RSP",		MMS_UNACCEPTABLE_RSP,
	"INVALID_RSP",			MMS_INVALID_RSP,
	"INVALID_RSP_CODE",		MMS_INVALID_RSP_CODE,
	"MISSING_TASKID",		MMS_MISSING_TASKID,
	"WRONG_TASKID",			MMS_WRONG_TASKID,

	"TRACE_FAILURE",		MMS_TRACE_FAILURE,
	"WRONG_API_MODE",		MMS_WRONG_API_MODE,
	"ASYNC_API_FAILURE",		MMS_ASYNC_API_FAILURE,
	"API_ERR",			MMS_API_ERR,
	"API_NOT_ERR_RSP",		MMS_API_NOT_ERR_RSP,
	"CFG_FILE_ERR",			MMS_CFG_FILE_ERR,
	"DUPLICATE_REG",		MMS_DUPLICATE_REG,
	"EV_REG_FAILED",		MMS_EV_REG_FAILED,
	"EV_UNREG_FAILED",		MMS_EV_UNREG_FAILED,
	"API_SHUTDOWN",			MMS_API_SHUTDOWN,
	"INVALID_REQ",			MMS_INVALID_REQ,

	/*
	 * The following are error codes defined in the MMS spec.
	 */
	"DM_E_AGAIN",			MMS_DM_E_AGAIN,
	"DM_E_BADHANDLE",		MMS_DM_E_BADHANDLE,
	"DM_E_BADVAL",			MMS_DM_E_BADVAL,
	"DM_E_CMDARGS",			MMS_DM_E_CMDARGS,
	"DM_E_DEVADMINCLT",		MMS_DM_E_DEVADMINCLT,
	"DM_E_DEVCMD",			MMS_DM_E_DEVCMD,
	"DM_E_DEVCMDABORT",		MMS_DM_E_DEVCMDABORT,
	"DM_E_DEVCMDILLEGAL",		MMS_DM_E_DEVCMDILLEGAL,
	"DM_E_DEVCMDTEMEOUT",		MMS_DM_E_DEVCMDTEMEOUT,
	"DM_E_DEVCOMMERR",		MMS_DM_E_DEVCOMMERR,
	"DM_E_DEVDET",			MMS_DM_E_DEVDET,
	"DM_E_DEVEMPTY",		MMS_DM_E_DEVEMPTY,
	"DM_E_DEVFULL",			MMS_DM_E_DEVFULL,
	"DM_E_DEVNORESPONSE",		MMS_DM_E_DEVNORESPONSE,
	"DM_E_DEVOPERATOR",		MMS_DM_E_DEVOPERATOR,
	"DM_E_DEVOVERFLOW",		MMS_DM_E_DEVOVERFLOW,
	"DM_E_DEVPERM",			MMS_DM_E_DEVPERM,
	"DM_E_DEVPREV",			MMS_DM_E_DEVPREV,
	"DM_E_DEVRESET",		MMS_DM_E_DEVRESET,
	"DM_E_DEVSYNCHERR",		MMS_DM_E_DEVSYNCHERR,
	"DM_E_DRIVE",			MMS_DM_E_DRIVE,
	"DM_E_HANDLEBUSY",		MMS_DM_E_HANDLEBUSY,
	"DM_E_HANDLEINUSE",		MMS_DM_E_HANDLEINUSE,
	"DM_E_INTERNAL",		MMS_DM_E_INTERNAL,
	"DM_E_LIBRARY",			MMS_DM_E_LIBRARY,
	"DM_E_MODE",			MMS_DM_E_MODE,
	"DM_E_NOCANC",			MMS_DM_E_NOCANC,
	"DM_E_NOCART",			MMS_DM_E_NOCART,
	"DM_E_NOELT",			MMS_DM_E_NOELT,
	"DM_E_NOEXISTHANDLE",		MMS_DM_E_NOEXISTHANDLE,
	"DM_E_NOID",			MMS_DM_E_NOID,
	"DM_E_NOTASK",			MMS_DM_E_NOTASK,
	"DM_E_READY",			MMS_DM_E_READY,
	"DM_E_UNKNOWN",			MMS_DM_E_UNKNOWN,
	"EACCHANDLESTILLINUSE",		MMS_EACCHANDLESTILLINUSE,
	"EAPPACCESSTOCART",		MMS_EAPPACCESSTOCART,
	"EAPPCARTNOACC",		MMS_EAPPCARTNOACC,
	"EAPPDMDIFFHOSTS",		MMS_EAPPDMDIFFHOSTS,
	"EAPPDRVNOACC",			MMS_EAPPDRVNOACC,
	"EAPPHASNOVOLS",		MMS_EAPPHASNOVOLS,
	"EAPPLIBNOACCESS",		MMS_EAPPLIBNOACCESS,
	"EAPPMOUNTNOTIUSSUED",		MMS_EAPPMOUNTNOTIUSSUED,
	"EAPPSESS",			MMS_EAPPSESS,
	"EAPPTASKNOTISSUED",		MMS_EAPPTASKNOTISSUED,
	"EAUTOCREATEFAILED",		MMS_EAUTOCREATEFAILED,
	"ECANCELLED",			MMS_ECANCELLED,
	"ECANCELNUMRANGEDISALLOWED",	MMS_ECANCELNUMRANGEDISALLOWED,
	"ECANTCANCEL",			MMS_ECANTCANCEL,
	"ECARTDRVNOTCOMPATIBLE",	MMS_ECARTDRVNOTCOMPATIBLE,
	"ECARTDRVSLOTMISMATCH",		MMS_ECARTDRVSLOTMISMATCH,
	"ECARTINSLOT",			MMS_ECARTINSLOT,
	"ECARTINUSE",			MMS_ECARTINUSE,
	"ECARTMOUNTNOTINVOLVED",	MMS_ECARTMOUNTNOTINVOLVED,
	"ECARTNOACC",			MMS_ECARTNOACC,
	"ECARTNOCGA",			MMS_ECARTNOCGA,
	"ECARTNOFREEPARTS",		MMS_ECARTNOFREEPARTS,
	"ECARTNOTINSLOT",		MMS_ECARTNOTINSLOT,
	"ECARTNOTLOCATED",		MMS_ECARTNOTLOCATED,
	"ECARTNOTOWNEDBYAP",		MMS_ECARTNOTOWNEDBYAP,
	"ECARTNOTOWNEDBYAPP",		MMS_ECARTNOTOWNEDBYAPP,
	"ECLAUSEMISSING",		MMS_ECLAUSEMISSING,
	"ECLAUSEMUTEX",			MMS_ECLAUSEMUTEX,
	"ECLAUSENEEDSARG",		MMS_ECLAUSENEEDSARG,
	"ECLAUSENOPRIVILEGE",		MMS_ECLAUSENOPRIVILEGE,
	"ECOMMANDBEINGSUBMITTED",	MMS_ECOMMANDBEINGSUBMITTED,
	"ECOMMANDFAILED",		MMS_ECOMMANDFAILED,
	"ECOMMANDNOPRIVILEGE",		MMS_ECOMMANDNOPRIVILEGE,
	"ECONNDELETE",			MMS_ECONNDELETE,
	"EDMCONFIG",			MMS_EDMCONFIG,
	"EDMNOTCONNECTED",		MMS_EDMNOTCONNECTED,
	"EDMNOTREADY",			MMS_EDMNOTREADY,
	"EDMPATTACH",			MMS_EDMPATTACH,
	"EDMPDETACH",			MMS_EDMPDETACH,
	"EDMPLOAD",			MMS_EDMPLOAD,
	"EDMPUNLOAD",			MMS_EDMPUNLOAD,
	"EDMRECOVERING",		MMS_EDMRECOVERING,
	"EDMSTATE",			MMS_EDMSTATE,
	"EDMSTILLBOOTING",		MMS_EDMSTILLBOOTING,
	"EDRIVEEMPTY",			MMS_EDRIVEEMPTY,
	"EDRIVESET",			MMS_EDRIVESET,
	"EDRVBROKEN",			MMS_EDRVBROKEN,
	"EDRVCARTNOTREADABLE",		MMS_EDRVCARTNOTREADABLE,
	"EDRVDISABLEDPERM",		MMS_EDRVDISABLEDPERM,
	"EDRVDISABLEDTEMP",		MMS_EDRVDISABLEDTEMP,
	"EDRVEJECTING",			MMS_EDRVEJECTING,
	"EDRVINUSE",			MMS_EDRVINUSE,
	"EDRVLOADED",			MMS_EDRVLOADED,
	"EDRVMOUNTNOTINVOLVED",		MMS_EDRVMOUNTNOTINVOLVED,
	"EDRVNODMCONFIGURED",		MMS_EDRVNODMCONFIGURED,
	"EDRVNOTINBAY",			MMS_EDRVNOTINBAY,
	"EDRVNOTLOADED",		MMS_EDRVNOTLOADED,
	"EDRVSESSNOUSE",		MMS_EDRVSESSNOUSE,
	"EDRVTASKNOTREQUIRED",		MMS_EDRVTASKNOTREQUIRED,
	"EDRVUNKNOWN",			MMS_EDRVUNKNOWN,
	"EHANDLEINUSE",			MMS_EHANDLEINUSE,
	"EHANDLENOTDESTROY",		MMS_EHANDLENOTDESTROY,
	"EINVALCLAUSEARG",		MMS_EINVALCLAUSEARG,
	"ELANGNOTSUPPORTED",		MMS_ELANGNOTSUPPORTED,
	"ELIBBROKEN",			MMS_ELIBBROKEN,
	"ELIBCARTNOCONTAINMENT",	MMS_ELIBCARTNOCONTAINMENT,
	"ELIBDISABLEDPERM",		MMS_ELIBDISABLEDPERM,
	"ELIBDISABLEDTEMP",		MMS_ELIBDISABLEDTEMP,
	"ELIBDRVNOCONTAINMENT",		MMS_ELIBDRVNOCONTAINMENT,
	"ELIBINUSE",			MMS_ELIBINUSE,
	"ELIBNOLMCONFIGURED",		MMS_ELIBNOLMCONFIGURED,
	"ELMADD",			MMS_ELMADD,
	"ELMCARTBAYNOTACCESS",		MMS_ELMCARTBAYNOTACCESS,
	"ELMCONFIG",			MMS_ELMCONFIG,
	"ELMDMCOMMUNICATION",		MMS_ELMDMCOMMUNICATION,
	"ELMDRVBAYNOTACCESS",		MMS_ELMDRVBAYNOTACCESS,
	"ELMDRVNOTACCESS",		MMS_ELMDRVNOTACCESS,
	"ELMNOTCONNECTED",		MMS_ELMNOTCONNECTED,
	"ELMNOTREADY",			MMS_ELMNOTREADY,
	"ELMPMOUNT",			MMS_ELMPMOUNT,
	"ELMPORTNOTREADY",		MMS_ELMPORTNOTREADY,
	"ELMPUNMOUNT",			MMS_ELMPUNMOUNT,
	"ELMSLOTNOTACCESS",		MMS_ELMSLOTNOTACCESS,
	"ELMSTATE",			MMS_ELMSTATE,
	"ELMSTILLBOOTING",		MMS_ELMSTILLBOOTING,
	"EMLOGCREATE",			MMS_EMLOGCREATE,
	"EMLOGDELETE",			MMS_EMLOGDELETE,
	"EMNTCARTPRES",			MMS_EMNTCARTPRES,
	"EMOUNTLIBNOTINVOLVED",		MMS_EMOUNTLIBNOTINVOLVED,
	"EMPCREATE",			MMS_EMPCREATE,
	"EMPHYSDEL",			MMS_EMPHYSDEL,
	"ENEWVOLEXISTS",		MMS_ENEWVOLEXISTS,
	"ENEWVOLNAMECOUNT",		MMS_ENEWVOLNAMECOUNT,
	"ENOALLOCATABLEPARTS",		MMS_ENOALLOCATABLEPARTS,
	"ENOCANCELLABLETASKS",		MMS_ENOCANCELLABLETASKS,
	"ENOCARTRIDGE",			MMS_ENOCARTRIDGE,
	"ENOINSTANCE",			MMS_ENOINSTANCE,
	"ENOMATCH",			MMS_ENOMATCH,
	"ENOMEMORY",			MMS_ENOMEMORY,
	"ENOPRIVCHANGE",		MMS_ENOPRIVCHANGE,
	"ENOSESSION",			MMS_ENOSESSION,
	"ENOSLOT",			MMS_ENOSLOT,
	"ENOSOLUTIONS",			MMS_ENOSOLUTIONS,
	"ENOSUCHCART",			MMS_ENOSUCHCART,
	"ENOSUCHLANG",			MMS_ENOSUCHLANG,
	"ENOSUCHPRIV",			MMS_ENOSUCHPRIV,
	"ENOSUCHREQ",			MMS_ENOSUCHREQ,
	"ENOSUCHSIDE",			MMS_ENOSUCHSIDE,
	"ENOSUCHSORT",			MMS_ENOSUCHSORT,
	"ENOSUCHVOLUME",		MMS_ENOSUCHVOLUME,
	"EOBJATTRMODDISALLOWED",	MMS_EOBJATTRMODDISALLOWED,
	"EOBJATTRTOOMANY",		MMS_EOBJATTRTOOMANY,
	"EOBJATTRVALNOTENUM",		MMS_EOBJATTRVALNOTENUM,
	"EOBJATTRVALNOTNUM",		MMS_EOBJATTRVALNOTNUM,
	"EOBJATTRVALNULLSTRING",	MMS_EOBJATTRVALNULLSTRING,
	"EOBJCREATEDISALLOWED",		MMS_EOBJCREATEDISALLOWED,
	"EOBJCREATEINVALREPORT",	MMS_EOBJCREATEINVALREPORT,
	"EOBJCREATESYSATTRREQUIRED",	MMS_EOBJCREATESYSATTRREQUIRED,
	"EOBJDELDISALLOWED",		MMS_EOBJDELDISALLOWED,
	"EOBJDELNUMRANGEDISALLOWED",	MMS_EOBJDELNUMRANGEDISALLOWED,
	"EOBJDEPENDNOEXIST",		MMS_EOBJDEPENDNOEXIST,
	"EOBJKEYCHANGE",		MMS_EOBJKEYCHANGE,
	"EOBJKEYNOTUNIQUE",		MMS_EOBJKEYNOTUNIQUE,
	"EOBJNOTVISIBLE",		MMS_EOBJNOTVISIBLE,
	"EOBJREFERENCES",		MMS_EOBJREFERENCES,
	"EOBJSYSATTRCREATEDISALLOWED",	MMS_EOBJSYSATTRCREATEDISALLOWED,
	"EOBJSYSATTRMODDISALLOWED",	MMS_EOBJSYSATTRMODDISALLOWED,
	"EOBJSYSATTRMODNOPRIV",		MMS_EOBJSYSATTRMODNOPRIV,
	"EOBJUSRATTRCREATEDISALLOWED",	MMS_EOBJUSRATTRCREATEDISALLOWED,
	"EOBJUSRATTRCREATENOPRIV",	MMS_EOBJUSRATTRCREATENOPRIV,
	"EPARTNOTALLOCABLE",		MMS_EPARTNOTALLOCABLE,
	"EPRIVCHANGEDISALLOWED",	MMS_EPRIVCHANGEDISALLOWED,
	"ERENAMEDVOLEXISTS",		MMS_ERENAMEDVOLEXISTS,
	"EREPLACEFAILED",		MMS_EREPLACEFAILED,
	"EREQACCEPTEDBYDIFFSESS",	MMS_EREQACCEPTEDBYDIFFSESS,
	"EREQSTATECHANGEFAILED",	MMS_EREQSTATECHANGEFAILED,
	"EREQUESTALREADYACCEPTED",	MMS_EREQUESTALREADYACCEPTED,
	"EREQUESTALREADYSATISFIED",	MMS_EREQUESTALREADYSATISFIED,
	"EREQUESTNOTACCEPTED",		MMS_EREQUESTNOTACCEPTED,
	"ESESSCARTNOTUSED",		MMS_ESESSCARTNOTUSED,
	"ESESSLIBNOTUSED",		MMS_ESESSLIBNOTUSED,
	"ESESSMNTNOTISSUED",		MMS_ESESSMNTNOTISSUED,
	"ESESSTASKNOISSUED",		MMS_ESESSTASKNOISSUED,
	"ESHUTDOWNFAILED",		MMS_ESHUTDOWNFAILED,
	"ESLOTNOTOCCUPIED",		MMS_ESLOTNOTOCCUPIED,
	"ESLOTOCCUPIED",		MMS_ESLOTOCCUPIED,
	"ESORTNOTSUPPORTED",		MMS_ESORTNOTSUPPORTED,
	"ESYSATTRUNSETDISALLOWED",	MMS_ESYSATTRUNSETDISALLOWED,
	"ESYSTEM",			MMS_ESYSTEM,
	"ETABLELIMIT",			MMS_ETABLELIMIT,
	"ETASKCARTNOUSE",		MMS_ETASKCARTNOUSE,
	"ETASKLIBNOUSE",		MMS_ETASKLIBNOUSE,
	"ETASKMNTNOUSE",		MMS_ETASKMNTNOUSE,
	"ETMPUNAVAIL",			MMS_ETMPUNAVAIL,
	"ETMPINUSE",			MMS_ETMPINUSE,
	"ETOOMANY",			MMS_ETOOMANY,
	"ETOOMANYCLAUSES",		MMS_ETOOMANYCLAUSES,
	"ETRANSACTIONFAILED",		MMS_ETRANSACTIONFAILED,
	"EUNKNOWNERROR",		MMS_EUNKNOWNERROR,
	"EVOLEXISTS",			MMS_EVOLEXISTS,
	"EVOLINUSE",			MMS_EVOLINUSE,
	"EVOLNAMEREWRITE",		MMS_EVOLNAMEREWRITE,
	"EVOLNOTOWNEDBYAPP",		MMS_EVOLNOTOWNEDBYAPP,
	"EWOULDDEADLOCK",		MMS_EWOULDDEADLOCK,
	"LM_E_ACCESS",			MMS_LM_E_ACCESS,
	"LM_E_AGAIN",			MMS_LM_E_AGAIN,
	"LM_E_BADVAL",			MMS_LM_E_BADVAL,
	"LM_E_CMDARGS",			MMS_LM_E_CMDARGS,
	"LM_E_DESTFULL",		MMS_LM_E_DESTFULL,
	"LM_E_DEVADMINCLT",		MMS_LM_E_DEVADMINCLT,
	"LM_E_DEVCMD",			MMS_LM_E_DEVCMD,
	"LM_E_DEVCMDABORT",		MMS_LM_E_DEVCMDABORT,
	"LM_E_DEVCMDILLEGAL",		MMS_LM_E_DEVCMDILLEGAL,
	"LM_E_DEVCMDTEMEOUT",		MMS_LM_E_DEVCMDTEMEOUT,
	"LM_E_DEVCOMMERR",		MMS_LM_E_DEVCOMMERR,
	"LM_E_DEVEJ",			MMS_LM_E_DEVEJ,
	"LM_E_DEVINJ",			MMS_LM_E_DEVINJ,
	"LM_E_DEVNORESPONSE",		MMS_LM_E_DEVNORESPONSE,
	"LM_E_DEVOPERATOR",		MMS_LM_E_DEVOPERATOR,
	"LM_E_DEVOVERFLOW",		MMS_LM_E_DEVOVERFLOW,
	"LM_E_DEVPREM",			MMS_LM_E_DEVPREM,
	"LM_E_DEVPREV",			MMS_LM_E_DEVPREV,
	"LM_E_DEVRESET",		MMS_LM_E_DEVRESET,
	"LM_E_DEVSYNCHERR",		MMS_LM_E_DEVSYNCHERR,
	"LM_E_DIRECTION",		MMS_LM_E_DIRECTION,
	"LM_E_INTERNAL",		MMS_LM_E_INTERNAL,
	"LM_E_LIBRARY",			MMS_LM_E_LIBRARY,
	"LM_E_MOVE",			MMS_LM_E_MOVE,
	"LM_E_NOCANC",			MMS_LM_E_NOCANC,
	"LM_E_NODRIVE",			MMS_LM_E_NODRIVE,
	"LM_E_NOELT",			MMS_LM_E_NOELT,
	"LM_E_NOPCL",			MMS_LM_E_NOPCL,
	"LM_E_NOSLOT",			MMS_LM_E_NOSLOT,
	"LM_E_NOTASK",			MMS_LM_E_NOTASK,
	"LM_E_PCL",			MMS_LM_E_PCL,
	"LM_E_PORT",			MMS_LM_E_PORT,
	"LM_E_PORTDIR",			MMS_LM_E_PORTDIR,
	"LM_E_READY",			MMS_LM_E_READY,
	"LM_E_SCREMPTY",		MMS_LM_E_SCREMPTY,
	"LM_E_SHAPE",			MMS_LM_E_SHAPE,
	"LM_E_SLOTGROUP",		MMS_LM_E_SLOTGROUP,
	"LM_E_UNKNOWN",			MMS_LM_E_UNKNOWN,
	"MM_E_AGAIN",			MMS_MM_E_AGAIN,
	"MM_E_BADVAL",			MMS_MM_E_BADVAL,
	"MM_E_CMDARGS",			MMS_MM_E_CMDARGS,
	"MM_E_DEVCMD",			MMS_MM_E_DEVCMD,
	"MM_E_DEVCMDABORT",		MMS_MM_E_DEVCMDABORT,
	"MM_E_DEVCMDILLEGAL",		MMS_MM_E_DEVCMDILLEGAL,
	"MM_E_DEVCMDTEMEOUT",		MMS_MM_E_DEVCMDTEMEOUT,
	"MM_E_DEVOVERFLOW",		MMS_MM_E_DEVOVERFLOW,
	"MM_E_DEVPREM",			MMS_MM_E_DEVPREM,
	"MM_E_DEVPREV",			MMS_MM_E_DEVPREV,
	"MM_E_INTERNAL",		MMS_MM_E_INTERNAL,
	"MM_E_NOELT",			MMS_MM_E_NOELT,
	"SSAI_E_PROTOCOL_ERROR",	MMS_SSAI_E_PROTOCOL_ERROR,
	"SSAI_E_ACCESS_DENIED",		MMS_SSAI_E_ACCESS_DENIED,
	"SSAI_E_DUPLICATE_SESSION",	MMS_SSAI_E_DUPLICATE_SESSION,
	"SSAI_E_UNKNOWN_LANGUAGE",	MMS_SSAI_E_UNKNOWN_LANGUAGE,
	"SSAI_E_UNSUPPORTED_LANGUAGE",	MMS_SSAI_E_UNSUPPORTED_LANGUAGE,
	"SSAI_E_SSL",			MMS_SSAI_E_SSL,
	"LM_E_SUBCMDFAILED",		MMS_LM_E_SUBCMDFAILED,
	"LM_E_CONFIG",			MMS_LM_E_CONFIG,

	/*
	 * Additional DM errors
	 */
	"DM_E_ENABLED",			MMS_DM_E_ENABLED,
	"DM_E_VIDMISMATCH",		MMS_DM_E_VIDMISMATCH,
	"DM_E_COMMAND",			MMS_DM_E_COMMAND,
	"DM_E_UNSUPPORTED",		MMS_DM_E_UNSUPPORTED,
	"DM_E_IO",			MMS_DM_E_IO,
	"DM_E_COMMUNICATION",		MMS_DM_E_COMMUNICATION,
	"DM_E_MAKEHANDLE",		MMS_DM_E_MAKEHANDLE,
	"DM_E_USER",			MMS_DM_E_USER,
	"DM_E_LOAD",			MMS_DM_E_LOAD,
	"DM_E_OPERATOR_ABORT",		MMS_DM_E_OPERATOR_ABORT,
	"DM_E_VOLUME_ID",		MMS_DM_E_VOLUME_ID,
	"DM_E_DRIVE_SER_NUM",		MMS_DM_E_DRIVE_SER_NUM,
	"DM_E_DENSITY",			MMS_DM_E_DENSITY,

	/*
	 * Additional MM errors
	 */
	"ENOSUCHPCL",			MMS_ENOSUCHPCL,
	"ELIBRARYNOEXIST",		MMS_ELIBRARYNOEXIST,
	"ELMNOEXIST",			MMS_ELMNOEXIST,
	"ELIBALREADYONLINE",		MMS_ELIBALREADYONLINE,
	"ELIBALREADYOFFLINE",		MMS_ELIBALREADYOFFLINE,
	"EDRIVENOEXIST",		MMS_EDRIVENOEXIST,
	"EDRIVEALREADYONLINE",		MMS_EDRIVEALREADYONLINE,
	"EDRIVEALREADYOFFLINE",		MMS_EDRIVEALREADYOFFLINE,
	"EDRIVEONLINE",			MMS_EDRIVEONLINE,
	"EDRIVEOFFLINE",		MMS_EDRIVEOFFLINE,
	"ELIBRARYONLINE",		MMS_ELIBRARYONLINE,
	"ELIBRARYOFFLINE",		MMS_ELIBRARYOFFLINE,
	"EDRVUNLOADING",		MMS_EDRVUNLOADING,
	"EDMNOMOUNTPOINT",		MMS_EDMNOMOUNTPOINT,
	/*
	 * Label errors
	 */
	"E_LABEL_NOT_PROCESSED",	MMS_E_LABEL_NOT_PROCESSED,
	"E_LABEL_MOUNT_SEND",		MMS_E_LABEL_MOUNT_SEND,
	"E_LABEL_MOUNT_RSP",		MMS_E_LABEL_MOUNT_RSP,
	"E_LABEL_HANDLE_NULL",		MMS_E_LABEL_HANDLE_NULL,
	"E_LABEL_HANDLE_OPEN",		MMS_E_LABEL_HANDLE_OPEN,
	"E_LABEL_UNMOUNT_SEND",		MMS_E_LABEL_UNMOUNT_SEND,
	"E_LABEL_UNMOUNT_RSP",		MMS_E_LABEL_UNMOUNT_RSP,
	"E_LABEL_NO_CARTRIDGES",	MMS_E_LABEL_NO_CARTRIDGES,
	"E_LABEL_NO_LIBRARY",		MMS_E_LABEL_NO_LIBRARY,
	"E_LABEL_COMMANDS",		MMS_E_LABEL_COMMANDS,

	/*
	 * Sun MM System vendor-defined error codes.
	 */
	"EDATABASE",			MMS_EDATABASE,
	"ENOTFOUND",			MMS_ENOTFOUND,
	"ESYNTAX",			MMS_ESYNTAX,
	"EPRIVNOTMMSADMIN",		MMS_EPRIVNOTSMMSADMIN,
	"MM_E_NOTASK",			MMS_MM_E_NOTASK,
	"MM_E_TOOMANYTASKS",		MMS_MM_E_TOOMANYTASKS,
	"ENOSUCHPCL",			MMS_ENOSUCHPCL,
	"ENOTENOUGHPARTITIONS",		MMS_ENOTENOUGHPARTITIONS,
	"EPARTITIONSTATECHANGE",	MMS_EPARTITIONSTATECHANGE,
	"ECARTRIDGESTATECHANGE",	MMS_ECARTRIDGESTATECHANGE,
	"ESYSTEMCONFIGCHANGE",		MMS_ESYSTEMCONFIGCHANGE,
	"ENOTCONNECTED",		MMS_ENOTCONNECTED,
	"ECOMMUNICATION",		MMS_ECOMMUNICATION,

	/*
	 * Socket and SSL error codes.
	 */
	"MMS_ERR_NONE",			MMS_ERR_NONE,
	"MMS_ERR_GETADDRINFO",		MMS_ERR_GETADDRINFO,
	"MMS_ERR_SERVICE_NOT_FOUND",	MMS_ERR_SERVICE_NOT_FOUND,
	"MMS_ERR_ACCEPT_FAILED",	MMS_ERR_ACCEPT_FAILED,
	"MMS_ERR_LISTEN",		MMS_ERR_LISTEN,
	"MMS_ERR_READ",			MMS_ERR_READ,
	"MMS_ERR_WRITE",		MMS_ERR_WRITE,
	"MMS_ERR_RES_NULL",		MMS_ERR_RES_NULL,
	"MMS_ERR_GETHOSTNAME",		MMS_ERR_GETHOSTNAME,
	"MMS_ERR_NOMEM",		MMS_ERR_NOMEM,
	"MMS_ERR_SSL_CONNECT",		MMS_ERR_SSL_CONNECT,
	"MMS_ERR_SSL_FILE",		MMS_ERR_SSL_FILE,
	"MMS_ERR_SSL_CTX",		MMS_ERR_SSL_CTX,
	"MMS_ERR_SSL_CERT",		MMS_ERR_SSL_CERT,
	"MMS_ERR_SSL_NOCERT",		MMS_ERR_SSL_NOCERT,
	"MMS_ERR_SSL_KEY",		MMS_ERR_SSL_KEY,
	"MMS_ERR_SSL_DH",		MMS_ERR_SSL_DH,
	"MMS_ERR_SSL_CIPHER",		MMS_ERR_SSL_CIPHER,
	"MMS_ERR_SSL_OP",		MMS_ERR_SSL_OP,
	"MMS_ERR_SSL_STORE",		MMS_ERR_SSL_STORE,
	"MMS_ERR_SSL_VERIFY",		MMS_ERR_SSL_VERIFY,
	"MMS_ERR_NO_SSL",		MMS_ERR_NO_SSL,


};
static	int	mms_num_err_syms = sizeof (mms_err_symtab) / sizeof (mms_sym_t);
static	int	mms_symtab_initialized = 0;
static	mutex_t	mms_symtab_mutex = DEFAULTMUTEX;





#define	MMS_STR_EQ(a, b)	(strcmp(a, b) == 0)
#define	MMS_STR_GT(a, b)	(strcmp(a, b) > 0)
#define	MMS_STR_LT(a, b)	(strcmp(a, b) < 0)
#define	MMS_STR_GE(a, b)	(strcmp(a, b) >= 0)
#define	MMS_STR_LE(a, b)	(strcmp(a, b) <= 0)

void
mms_sym_init_symtab()
{
	(void) mutex_lock(&mms_symtab_mutex);
	if (mms_symtab_initialized == 0) {
		mms_sort_sym_token(mms_err_symtab, mms_num_err_syms);
		mms_symtab_initialized = 1;
	}
	(void) mutex_unlock(&mms_symtab_mutex);
}

int
mms_sym_str_to_code(char *errstr)
{
	mms_sym_t	*mms_sym;

	if (mms_symtab_initialized == 0) {
		mms_sym_init_symtab();
	}

	if ((mms_sym = mms_lookup_sym_token(errstr, mms_err_symtab,
	    mms_num_err_syms)) == NULL) {
		return (MMS_E_UNKNOWN_ERR_STRING);
	} else {
		return (mms_sym->sym_code);
	}
}

char *
mms_sym_code_to_str(int code)
{
	int	i;
	mms_sym_t	*mms_sym;
	int	index = 0;

	if (mms_symtab_initialized == 0) {
		mms_sym_init_symtab();
	}

	for (i = 0; i < mms_num_err_syms; i++) {
		mms_sym = mms_err_symtab + i;
		if (mms_sym->sym_code == code) {
			return (mms_sym->sym_token);
		}
		if (mms_sym->sym_code == MMS_UNKNOWN_CODE) {
			index = i;
		}
	}

	return (mms_err_symtab[index].sym_token);
}

/*
 * Sort symbol table
 */

int
mms_sym_compare(const void *arga, const void *argb)
{
	/*
	 * Compare functions for sort
	 */
	mms_sym_t	*a = (mms_sym_t *)arga;
	mms_sym_t	*b = (mms_sym_t *)argb;

	return (strcmp(a->sym_token, b->sym_token));
}

void
mms_sort_sym_token(mms_sym_t *tab, int num)
{
	qsort(tab, num, sizeof (mms_sym_t), mms_sym_compare);
}

int
mms_code_compare(const void *arga, const void *argb)
{
	/*
	 * Compare functions for sort
	 */
	mms_sym_t	*a = (mms_sym_t *)arga;
	mms_sym_t	*b = (mms_sym_t *)argb;

	return (a->sym_code - b->sym_code);
}

void
mms_sort_sym_code(mms_sym_t *tab, int num)
{
	qsort(tab, num, sizeof (mms_sym_t), mms_code_compare);
}

/*
 * Use binary search to lookup symbol
 */

mms_sym_t	*
mms_lookup_sym_token(char *mms_sym, mms_sym_t *tab, int num)
{
	mms_sym_t	key = { mms_sym };

	return (bsearch(&key, tab, num, sizeof (mms_sym_t), mms_sym_compare));
}

mms_sym_t	*
mms_lookup_sym_code(int code, mms_sym_t *tab, int num)
{
	int	i;

	for (i = 0; i < num; i++) {
		if (tab[i].sym_code == code) {
			return (tab + i);
		}
	}

	return (NULL);
}
