/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2008 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _SYS_KICONV_JA_H
#define	_SYS_KICONV_JA_H

#pragma ident	"%Z%%M%	%I%	%E% SMI"

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/kiconv.h>

/*
 * kiconv_ja specific definition
 */

#define	KICONV_JA_TBLID_EUCJP		(0x00)
#define	KICONV_JA_TBLID_EUCJP_MS	(0x01)
#define	KICONV_JA_TBLID_SJIS		(0x02)
#define	KICONV_JA_TBLID_CP932		(0x03)

#define	KICONV_JA_MAX_MAPPING_TBLID	(0x03)

#define	KICONV_JA_DEF_SINGLE	KICONV_ASCII_REPLACEMENT_CHAR
#define	KICONV_JA_REPLACE	(0xfffd)
#define	KICONV_JA_NODEST	(0xffff)
#define	KICONV_JA_IFHISUR(x)	((0xd800 <= (x)) && ((x) <= 0xdbff))
#define	KICONV_JA_IFLOSUR(x)	((0xdc00 <= (x)) && ((x) <= 0xdfff))

#define	KICONV_JA_RETERROR(no) {\
		*errno = (no);\
		rv = ((size_t)-1);\
		goto ret;\
	}

#define	KICONV_JA_NGET(c) \
	if (ileft == 0) {\
		KICONV_JA_RETERROR(EINVAL)\
	} else {\
		ileft--;\
		(c) = *ip++;\
	}

#define	KICONV_JA_NGET_REP_FR_MB(c) \
	if (ileft == 0) {\
		KICONV_JA_PUTU(KICONV_JA_REPLACE)\
		rv++;\
		goto next;\
	} else {\
		ileft--;\
		(c) = *ip++;\
	}

#define	KICONV_JA_NGET_REP_TO_MB(c) \
	if (ileft == 0) {\
		l = KICONV_JA_DEF_SINGLE;\
		*repnum = 1;\
		goto ret;\
	} else {\
		ileft--;\
		(c) = *ip++;\
	}

#define	KICONV_JA_NPUT(c) \
	if (oleft == 0) {\
		KICONV_JA_RETERROR(E2BIG)\
	} else {\
		oleft--;\
		*op++ = (uint8_t)(c);\
	}

#define	KICONV_JA_GETU(pu32, flag) \
	read_len = read_unicode((pu32), &ip, &ileft, errno, (flag), &rv); \
	switch (read_len) { \
	case (size_t)-1: \
		/* errno has been set in read_unicode() */ \
		rv = (size_t)-1; \
		goto ret; \
	case (size_t)0: \
		/* character read was handled in the read_unicode() */ \
		/* no further evaluation needed in caller side */ \
		goto next; \
	default: \
		break; \
	}

#define	KICONV_JA_PUTU(u32)	\
	if (write_unicode((u32), &op, &oleft, errno) \
			== (size_t)-1) { \
		rv = ((size_t)-1);\
		goto ret; \
	}

#define	KICONV_JA_CHECK_UTF8_BOM(inbuf, inleft) \
	if (((kiconv_state_t)kcd)->bom_processed == 0 && (inleft) >= 3 && \
		*(inbuf) == 0xef && \
		*((inbuf) + 1) == 0xbb && \
		*((inbuf) + 2) == 0xbf) { \
		(inbuf) += 3; \
		(inleft) -= 3; \
	} \
	((kiconv_state_t)kcd)->bom_processed = 1

#define	KICONV_JA_CHECK_UTF8_BOM_WITHOUT_STATE(inbuf, inleft) \
	if ((inleft) >= 3 && *(inbuf) == 0xef && \
		*((inbuf) + 1) == 0xbb && \
		*((inbuf) + 2) == 0xbf) { \
		(inbuf) += 3; \
		(inleft) -= 3; \
	}

#define	KICONV_JA_ERR_RETURN	(-1)		/* result code on error */

/*
 * KICONV_JA_ISXXXX(c) macros below assume (c) is of type ushort_t
 */
/* is a valid code as ascii? */
#define	KICONV_JA_ISASC(c)		((c) <= 0x7f)

/* is a valid code as C1 control? */
#define	KICONV_JA_ISC1CTRL(c)		(((c) >= 0x80) && ((c) <= 0x9f))

/* is a valid code as C1 control allowed in EUC? */
#define	KICONV_JA_ISC1CTRLEUC(c)	((((c) >= 0x80) && ((c) <= 0x8d)) ||\
					(((c) >= 0x90) && ((c) <= 0x9f)))

/* is a valid 1st or 2nd byte of EUC codeset 1? */
#define	KICONV_JA_ISCS1(c)		(((c) >= 0xa1) && ((c) <= 0xfe))

/* is a valid 1st byte of EUC codeset 1 and in range row 1 thru 84? */
#define	KICONV_JA_ISCS1_0208(c)		(((c) >= 0xa1) && ((c) <= 0xf4))

/* is a valid 1st byte of UDC area in EUC codeset 1? */
#define	KICONV_JA_ISCS1_UDC(c)		(((c) >= 0xf5) && ((c) <= 0xfe))

/* is a valid 2nd (1st byte is SS2) byte of EUC codeset 2? */
#define	KICONV_JA_ISCS2(c)		(((c) >= 0xa1) && ((c) <= 0xdf))

/* is a valid 2nd or 3rd (1st byte is SS3) byte of EUC codeset 3? */
#define	KICONV_JA_ISCS3(c)		(((c) >= 0xa1) && ((c) <= 0xfe))

/* is a valid 2nd (1st byte is SS3) byte of UDC area in EUC codeset 3? */
#define	KICONV_JA_ISCS3_UDC(c)		(((c) >= 0xf5) && ((c) <= 0xfe))

/* is a valid hankaku_katakana for SJIS? */
#define	KICONV_JA_ISSJKANA(c)		(((c) >= 0xa1) && ((c) <= 0xdf))

/* is a valid character for the first byte of SJIS multibyte? */
#define	KICONV_JA_ISSJMB_1(c) \
	((((c) >= 0x81) && ((c) <= 0x9f)) || \
	(((c) >= 0xe0) && ((c) <= 0xfc)))

/* is a valid character for the first byte of SJIS kanji? */
#define	KICONV_JA_ISSJKANJI1(c) \
	((((c) >= 0x81) && ((c) <= 0x9f)) || \
	(((c) >= 0xe0) && ((c) <= 0xea)) || \
	(((c) >= 0xf0) && ((c) <= 0xf4)))

/* is a valid character for the first byte of a part of Suppl. SJIS? */
#define	KICONV_JA_ISSJSUPKANJI1(c)	(((c) >= 0xf5) && ((c) <= 0xf9))

/* is a valid character for the first byte of SJIS UDC? */
#define	KICONV_JA_ISSJUDC_1(c)		(((c) >= 0xf0) && ((c) <= 0xf9))

/* is a valid character for the first byte of ibm character set */
#define	KICONV_JA_ISSJIBM(c)		(((c) >= 0xfa) && ((c) <= 0xfc))

/* is a valid character for the first byte of ibm character set */
#define	KICONV_JA_ISSJNECIBM(c)		(((c) >= 0xed) && ((c) <= 0xef))

/* is a valid character for the second byte of SJIS kanji? */
#define	KICONV_JA_ISSJKANJI2(c)	\
	((((c) >= 0x40) && ((c) <= 0x7e)) || \
	(((c) >= 0x80) && ((c) <= 0xfc)))

/* is a valid character for UTF8 UDC ? */
#define	KICONV_JA_ISUTF8UDC(c)	(((c) >= 0xe000) && ((c) <= 0xf8ff))

#define	KICONV_JA_CMASK				0x7f
#define	KICONV_JA_CMSB				0x80

/*
 * Remap NEC/IBM codes to IBM codes
 * if dest == 0xffff, that means the source
 * code point is illegal in the current spec.
 */
#define	KICONV_JA_REMAP_NEC(dest) \
	if ((0xed40 <= (dest)) && \
		((dest) <= 0xed62)) { \
		(dest) += 0xd1c; \
	} else if ((0xed63 <= (dest)) && \
		((dest) <= 0xed7e)) { \
		(dest) += 0xd1d; \
	} else if ((0xed80 <= (dest)) && \
		((dest) <= 0xede0)) { \
		(dest) += 0xd1c; \
	} else if ((0xede1 <= (dest)) && \
		((dest) <= 0xedfc)) { \
		(dest) += 0xd5f; \
	} else if ((0xee40 <= (dest)) && \
		((dest) <= 0xee62)) { \
		(dest) += 0xd1c; \
	} else if ((0xee63 <= (dest)) && \
		((dest) <= 0xee7e)) { \
		(dest) += 0xd1d; \
	} else if ((0xee80 <= (dest)) && \
		((dest) <= 0xeee0)) { \
		(dest) += 0xd1c; \
	} else if ((0xeee1 <= (dest)) && \
		((dest) <= 0xeeec)) { \
		(dest) += 0xd5f; \
	} else if ((0xeeef <= (dest)) && \
		((dest) <= 0xeef8)) { \
		(dest) += 0xb51; \
	} else if ((0xeef9 <= (dest)) && \
		((dest) <= 0xeefc)) { \
		(dest) += 0xb5b; \
	} else { \
		(dest) = 0xffff; \
	}

typedef ushort_t kiconv_ja_euc16_t;
typedef ushort_t kiconv_ja_ucs2_t;

/*
 * The following 6 vectors show JIS and SJIS mapping table.
 */
static const uchar_t kiconv_ja_sjtojis1[] = {
	0xff, 0x21, 0x23, 0x25, 0x27, 0x29, 0x2b, 0x2d,
	0x2f, 0x31, 0x33, 0x35, 0x37, 0x39, 0x3b, 0x3d,
	0x3f, 0x41, 0x43, 0x45, 0x47, 0x49, 0x4b, 0x4d,
	0x4f, 0x51, 0x53, 0x55, 0x57, 0x59, 0x5b, 0x5d,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x5f, 0x61, 0x63, 0x65, 0x67, 0x69, 0x6b, 0x6d,
	0x6f, 0x71, 0x73, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x75, 0x77, 0x79, 0x7b, 0x7d, 0x75, 0x77, 0x79,
	0x7b, 0x7d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
};
static const uchar_t kiconv_ja_sjtojis2[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,
	0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30,
	0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38,
	0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40,
	0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
	0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50,
	0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
	0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0xff,
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
	0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
	0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x21,
	0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29,
	0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31,
	0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40, 0x41,
	0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49,
	0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51,
	0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59,
	0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60, 0x61,
	0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69,
	0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71,
	0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79,
	0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0xff, 0xff, 0xff,
};
static const uchar_t kiconv_ja_jis208tosj1[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0x81, 0x81, 0x82, 0x82, 0x83, 0x83, 0x84,
	0x84, 0x85, 0x85, 0x86, 0x86, 0x87, 0x87, 0x88,
	0x88, 0x89, 0x89, 0x8a, 0x8a, 0x8b, 0x8b, 0x8c,
	0x8c, 0x8d, 0x8d, 0x8e, 0x8e, 0x8f, 0x8f, 0x90,
	0x90, 0x91, 0x91, 0x92, 0x92, 0x93, 0x93, 0x94,
	0x94, 0x95, 0x95, 0x96, 0x96, 0x97, 0x97, 0x98,
	0x98, 0x99, 0x99, 0x9a, 0x9a, 0x9b, 0x9b, 0x9c,
	0x9c, 0x9d, 0x9d, 0x9e, 0x9e, 0x9f, 0x9f, 0xe0,
	0xe0, 0xe1, 0xe1, 0xe2, 0xe2, 0xe3, 0xe3, 0xe4,
	0xe4, 0xe5, 0xe5, 0xe6, 0xe6, 0xe7, 0xe7, 0xe8,
	0xe8, 0xe9, 0xe9, 0xea, 0xea, 0xf0, 0xf0, 0xf1,
	0xf1, 0xf2, 0xf2, 0xf3, 0xf3, 0xf4, 0xf4, 0xff,
};
static const uchar_t kiconv_ja_jis212tosj1[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xf5, 0xf6,
	0xf6, 0xf7, 0xf7, 0xf8, 0xf8, 0xf9, 0xf9, 0xff,
};
static const uchar_t kiconv_ja_jistosj2[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46,
	0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e,
	0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56,
	0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e,
	0x5f, 0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66,
	0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e,
	0x6f, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76,
	0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e,
	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
	0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
	0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0x9f, 0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5,
	0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad,
	0xae, 0xaf, 0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5,
	0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd,
	0xbe, 0xbf, 0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5,
	0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd,
	0xce, 0xcf, 0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5,
	0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd,
	0xde, 0xdf, 0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5,
	0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed,
	0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5,
	0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xff,
};
static const ushort_t kiconv_ja_sjtoibmext[] = {
	0xf3f3, 0xf3f4, 0xf3f5, 0xf3f6, 0xf3f7, 0xf3f8, 0xf3f9, 0xf3fa,
	0xf3fb, 0xf3fc, 0xf3fd, 0xf3fe, 0xf4a1, 0xf4a2, 0xf4a3, 0xf4a4,
	0xf4a5, 0xf4a6, 0xf4a7, 0xf4a8, 0xffff, 0xa2c3, 0xf4a9, 0xf4aa,
	0xf4ab, 0xf4ac, 0xf4ad, 0xffff, 0xd4e3, 0xdcdf, 0xe4e9, 0xe3f8,
	0xd9a1, 0xb1bb, 0xf4ae, 0xc2ad, 0xc3fc, 0xe4d0, 0xc2bf, 0xbcf4,
	0xb0a9, 0xb0c8, 0xf4af, 0xb0d2, 0xb0d4, 0xb0e3, 0xb0ee, 0xb1a7,
	0xb1a3, 0xb1ac, 0xb1a9, 0xb1be, 0xb1df, 0xb1d8, 0xb1c8, 0xb1d7,
	0xb1e3, 0xb1f4, 0xb1e1, 0xb2a3, 0xf4b0, 0xb2bb, 0xb2e6, 0xffff,
	0xb2ed, 0xb2f5, 0xb2fc, 0xf4b1, 0xb3b5, 0xb3d8, 0xb3db, 0xb3e5,
	0xb3ee, 0xb3fb, 0xf4b2, 0xf4b3, 0xb4c0, 0xb4c7, 0xb4d0, 0xb4de,
	0xf4b4, 0xb5aa, 0xf4b5, 0xb5af, 0xb5c4, 0xb5e8, 0xf4b6, 0xb7c2,
	0xb7e4, 0xb7e8, 0xb7e7, 0xf4b7, 0xf4b8, 0xf4b9, 0xb8ce, 0xb8e1,
	0xb8f5, 0xb8f7, 0xb8f8, 0xb8fc, 0xb9af, 0xb9b7, 0xbabe, 0xbadb,
	0xcdaa, 0xbae1, 0xf4ba, 0xbaeb, 0xbbb3, 0xbbb8, 0xf4bb, 0xbbca,
	0xf4bc, 0xf4bd, 0xbbd0, 0xbbde, 0xbbf4, 0xbbf5, 0xbbf9, 0xbce4,
	0xbced, 0xbcfe, 0xf4be, 0xbdc2, 0xbde7, 0xf4bf, 0xbdf0, 0xbeb0,
	0xbeac, 0xf4c0, 0xbeb3, 0xbebd, 0xbecd, 0xbec9, 0xbee4, 0xbfa8,
	0xbfc9, 0xc0c4, 0xc0e4, 0xc0f4, 0xc1a6, 0xf4c1, 0xc1f5, 0xc1fc,
	0xf4c2, 0xc1f8, 0xc2ab, 0xc2a1, 0xc2a5, 0xf4c3, 0xc2b8, 0xc2ba,
	0xf4c4, 0xc2c4, 0xc2d2, 0xc2d7, 0xc2db, 0xc2de, 0xc2ed, 0xc2f0,
	0xf4c5, 0xc3a1, 0xc3b5, 0xc3c9, 0xc3b9, 0xf4c6, 0xc3d8, 0xc3fe,
	0xf4c7, 0xc4cc, 0xf4c8, 0xc4d9, 0xc4ea, 0xc4fd, 0xf4c9, 0xc5a7,
	0xc5b5, 0xc5b6, 0xf4ca, 0xc5d5, 0xc6b8, 0xc6d7, 0xc6e0, 0xc6ea,
	0xc6e3, 0xc7a1, 0xc7ab, 0xc7c7, 0xc7c3, 0xffff, 0xffff, 0xffff,
	0xc7cb, 0xc7cf, 0xc7d9, 0xf4cb, 0xf4cc, 0xc7e6, 0xc7ee, 0xc7fc,
	0xc7eb, 0xc7f0, 0xc8b1, 0xc8e5, 0xc8f8, 0xc9a6, 0xc9ab, 0xc9ad,
	0xf4cd, 0xc9ca, 0xc9d3, 0xc9e9, 0xc9e3, 0xc9fc, 0xc9f4, 0xc9f5,
	0xf4ce, 0xcab3, 0xcabd, 0xcaef, 0xcaf1, 0xcbae, 0xf4cf, 0xcbca,
	0xcbe6, 0xcbea, 0xcbf0, 0xcbf4, 0xcbee, 0xcca5, 0xcbf9, 0xccab,
	0xccae, 0xccad, 0xccb2, 0xccc2, 0xccd0, 0xccd9, 0xf4d0, 0xcdbb,
	0xf4d1, 0xcebb, 0xf4d2, 0xceba, 0xcec3, 0xf4d3, 0xcef2, 0xb3dd,
	0xcfd5, 0xcfe2, 0xcfe9, 0xcfed, 0xf4d4, 0xf4d5, 0xf4d6, 0xffff,
	0xf4d7, 0xd0e5, 0xf4d8, 0xd0e9, 0xd1e8, 0xf4d9, 0xf4da, 0xd1ec,
	0xd2bb, 0xf4db, 0xd3e1, 0xd3e8, 0xd4a7, 0xf4dc, 0xf4dd, 0xd4d4,
	0xd4f2, 0xd5ae, 0xf4de, 0xd7de, 0xf4df, 0xd8a2, 0xd8b7, 0xd8c1,
	0xd8d1, 0xd8f4, 0xd9c6, 0xd9c8, 0xd9d1, 0xf4e0, 0xf4e1, 0xf4e2,
	0xf4e3, 0xf4e4, 0xdcd3, 0xddc8, 0xddd4, 0xddea, 0xddfa, 0xdea4,
	0xdeb0, 0xf4e5, 0xdeb5, 0xdecb, 0xf4e6, 0xdfb9, 0xf4e7, 0xdfc3,
	0xf4e8, 0xf4e9, 0xe0d9, 0xf4ea, 0xf4eb, 0xe1e2, 0xf4ec, 0xf4ed,
	0xf4ee, 0xe2c7, 0xe3a8, 0xe3a6, 0xe3a9, 0xe3af, 0xe3b0, 0xe3aa,
	0xe3ab, 0xe3bc, 0xe3c1, 0xe3bf, 0xe3d5, 0xe3d8, 0xe3d6, 0xe3df,
	0xe3e3, 0xe3e1, 0xe3d4, 0xe3e9, 0xe4a6, 0xe3f1, 0xe3f2, 0xe4cb,
	0xe4c1, 0xe4c3, 0xe4be, 0xf4ef, 0xe4c0, 0xe4c7, 0xe4bf, 0xe4e0,
	0xe4de, 0xe4d1, 0xf4f0, 0xe4dc, 0xe4d2, 0xe4db, 0xe4d4, 0xe4fa,
	0xe4ef, 0xe5b3, 0xe5bf, 0xe5c9, 0xe5d0, 0xe5e2, 0xe5ea, 0xe5eb,
	0xf4f1, 0xf4f2, 0xf4f3, 0xe6e8, 0xe6ef, 0xe7ac, 0xf4f4, 0xe7ae,
	0xf4f5, 0xe7b1, 0xf4f6, 0xe7b2, 0xe8b1, 0xe8b6, 0xf4f7, 0xf4f8,
	0xe8dd, 0xf4f9, 0xf4fa, 0xe9d1, 0xf4fb, 0xffff, 0xffff, 0xffff,
	0xe9ed, 0xeacd, 0xf4fc, 0xeadb, 0xeae6, 0xeaea, 0xeba5, 0xebfb,
	0xebfa, 0xf4fd, 0xecd6, 0xf4fe, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
};

#ifdef __cplusplus
}
#endif

#endif /* _SYS_KICONV_JA_H */
