/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2008 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2006 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation (the
 * "Data Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 *
 * Unicode and the Unicode logo are trademarks of Unicode, Inc., and may be
 * registered in some jurisdictions. All other trademarks and registered
 * trademarks mentioned herein are the property of their respective owners.
 */
/*
 * This file has been modified by Sun Microsystems, Inc.
 */

#ifndef	_SYS_KICONV_JA_JIS_TO_UNICODE_H
#define	_SYS_KICONV_JA_JIS_TO_UNICODE_H

#pragma ident	"%Z%%M%	%I%	%E% SMI"

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/kiconv.h>
#include <sys/kiconv_ja.h>

#ifdef	_KERNEL

#define	NODEST	KICONV_JA_REPLACE

/*
 * JIS to Unicode conversion for kiconv_ja modules
 */
static const kiconv_ja_ucs2_t kiconv_ja_jisx0201roman_to_ucs2[] = {
	/* 00 */
	0x0000,	0x0001,	0x0002,	0x0003,	0x0004,	0x0005,	0x0006,	0x0007,
	/* 08 */
	0x0008,	0x0009,	0x000a,	0x000b,	0x000c,	0x000d,	0x000e,	0x000f,
	/* 10 */
	0x0010,	0x0011,	0x0012,	0x0013,	0x0014,	0x0015,	0x0016,	0x0017,
	/* 18 */
	0x0018,	0x0019,	0x001a,	0x001b,	0x001c,	0x001d,	0x001e,	0x001f,
	/* 20 */
	0x0020,	0x0021,	0x0022,	0x0023,	0x0024,	0x0025,	0x0026,	0x0027,
	/* 28 */
	0x0028,	0x0029,	0x002a,	0x002b,	0x002c,	0x002d,	0x002e,	0x002f,
	/* 30 */
	0x0030,	0x0031,	0x0032,	0x0033,	0x0034,	0x0035,	0x0036,	0x0037,
	/* 38 */
	0x0038,	0x0039,	0x003a,	0x003b,	0x003c,	0x003d,	0x003e,	0x003f,
	/* 40 */
	0x0040,	0x0041,	0x0042,	0x0043,	0x0044,	0x0045,	0x0046,	0x0047,
	/* 48 */
	0x0048,	0x0049,	0x004a,	0x004b,	0x004c,	0x004d,	0x004e,	0x004f,
	/* 50 */
	0x0050,	0x0051,	0x0052,	0x0053,	0x0054,	0x0055,	0x0056,	0x0057,
	/* 58 */
	0x0058,	0x0059,	0x005a,	0x005b,	0x005c,	0x005d,	0x005e,	0x005f,
	/* 60 */
	0x0060,	0x0061,	0x0062,	0x0063,	0x0064,	0x0065,	0x0066,	0x0067,
	/* 68 */
	0x0068,	0x0069,	0x006a,	0x006b,	0x006c,	0x006d,	0x006e,	0x006f,
	/* 70 */
	0x0070,	0x0071,	0x0072,	0x0073,	0x0074,	0x0075,	0x0076,	0x0077,
	/* 78 */
	0x0078,	0x0079,	0x007a,	0x007b,	0x007c,	0x007d,	0x007e,	0x007f,
};

static const kiconv_ja_ucs2_t kiconv_ja_jisx0201kana_to_ucs2[] = {
	/* A1 */
	0xff61,	0xff62,	0xff63,	0xff64,	0xff65,	0xff66,	0xff67,	0xff68,
	/* A9 */
	0xff69,	0xff6a,	0xff6b,	0xff6c,	0xff6d,	0xff6e,	0xff6f,	0xff70,
	/* B1 */
	0xff71,	0xff72,	0xff73,	0xff74,	0xff75,	0xff76,	0xff77,	0xff78,
	/* B9 */
	0xff79,	0xff7a,	0xff7b,	0xff7c,	0xff7d,	0xff7e,	0xff7f,	0xff80,
	/* C1 */
	0xff81,	0xff82,	0xff83,	0xff84,	0xff85,	0xff86,	0xff87,	0xff88,
	/* C9 */
	0xff89,	0xff8a,	0xff8b,	0xff8c,	0xff8d,	0xff8e,	0xff8f,	0xff90,
	/* D1 */
	0xff91,	0xff92,	0xff93,	0xff94,	0xff95,	0xff96,	0xff97,	0xff98,
	/* D9 */
	0xff99,	0xff9a,	0xff9b,	0xff9c,	0xff9d,	0xff9e,	0xff9f,
};
static const kiconv_ja_ucs2_t kiconv_ja_jisx0208_to_ucs2[] = {
	/* 01 01 */
	0x3000,	0x3001,	0x3002,	0xff0c,	0xff0e,	0x30fb,	0xff1a,	0xff1b,
	/* 01 09 */
	0xff1f,	0xff01,	0x309b,	0x309c,	0x00b4,	0xff40,	0x00a8,	0xff3e,
	/* 01 17 */
	0xffe3,	0xff3f,	0x30fd,	0x30fe,	0x309d,	0x309e,	0x3003,	0x4edd,
	/* 01 25 */
	0x3005,	0x3006,	0x3007,	0x30fc,	0x2015,	0x2010,	0xff0f,	0xff3c,
	/* 01 33 */
	0x301c,	0x2016,	0xff5c,	0x2026,	0x2025,	0x2018,	0x2019,	0x201c,
	/* 01 41 */
	0x201d,	0xff08,	0xff09,	0x3014,	0x3015,	0xff3b,	0xff3d,	0xff5b,
	/* 01 49 */
	0xff5d,	0x3008,	0x3009,	0x300a,	0x300b,	0x300c,	0x300d,	0x300e,
	/* 01 57 */
	0x300f,	0x3010,	0x3011,	0xff0b,	0x2212,	0x00b1,	0x00d7,	0x00f7,
	/* 01 65 */
	0xff1d,	0x2260,	0xff1c,	0xff1e,	0x2266,	0x2267,	0x221e,	0x2234,
	/* 01 73 */
	0x2642,	0x2640,	0x00b0,	0x2032,	0x2033,	0x2103,	0xffe5,	0xff04,
	/* 01 81 */
	0x00a2,	0x00a3,	0xff05,	0xff03,	0xff06,	0xff0a,	0xff20,	0x00a7,
	/* 01 89 */
	0x2606,	0x2605,	0x25cb,	0x25cf,	0x25ce,	0x25c7,
	/* 02 01 */
	0x25c6,	0x25a1,	0x25a0,	0x25b3,	0x25b2,	0x25bd,	0x25bc,	0x203b,
	/* 02 09 */
	0x3012,	0x2192,	0x2190,	0x2191,	0x2193,	0x3013,	NODEST,	NODEST,
	/* 02 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 02 25 */
	NODEST,	0x2208,	0x220b,	0x2286,	0x2287,	0x2282,	0x2283,	0x222a,
	/* 02 33 */
	0x2229,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 02 41 */
	NODEST,	0x2227,	0x2228,	0x00ac,	0x21d2,	0x21d4,	0x2200,	0x2203,
	/* 02 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 02 57 */
	NODEST,	NODEST,	NODEST,	0x2220,	0x22a5,	0x2312,	0x2202,	0x2207,
	/* 02 65 */
	0x2261,	0x2252,	0x226a,	0x226b,	0x221a,	0x223d,	0x221d,	0x2235,
	/* 02 73 */
	0x222b,	0x222c,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 02 81 */
	NODEST,	0x212b,	0x2030,	0x266f,	0x266d,	0x266a,	0x2020,	0x2021,
	/* 02 89 */
	0x00b6,	NODEST,	NODEST,	NODEST,	NODEST,	0x25ef,
	/* 03 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 03 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0xff10,
	/* 03 17 */
	0xff11,	0xff12,	0xff13,	0xff14,	0xff15,	0xff16,	0xff17,	0xff18,
	/* 03 25 */
	0xff19,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 03 33 */
	0xff21,	0xff22,	0xff23,	0xff24,	0xff25,	0xff26,	0xff27,	0xff28,
	/* 03 41 */
	0xff29,	0xff2a,	0xff2b,	0xff2c,	0xff2d,	0xff2e,	0xff2f,	0xff30,
	/* 03 49 */
	0xff31,	0xff32,	0xff33,	0xff34,	0xff35,	0xff36,	0xff37,	0xff38,
	/* 03 57 */
	0xff39,	0xff3a,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 03 65 */
	0xff41,	0xff42,	0xff43,	0xff44,	0xff45,	0xff46,	0xff47,	0xff48,
	/* 03 73 */
	0xff49,	0xff4a,	0xff4b,	0xff4c,	0xff4d,	0xff4e,	0xff4f,	0xff50,
	/* 03 81 */
	0xff51,	0xff52,	0xff53,	0xff54,	0xff55,	0xff56,	0xff57,	0xff58,
	/* 03 89 */
	0xff59,	0xff5a,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 04 01 */
	0x3041,	0x3042,	0x3043,	0x3044,	0x3045,	0x3046,	0x3047,	0x3048,
	/* 04 09 */
	0x3049,	0x304a,	0x304b,	0x304c,	0x304d,	0x304e,	0x304f,	0x3050,
	/* 04 17 */
	0x3051,	0x3052,	0x3053,	0x3054,	0x3055,	0x3056,	0x3057,	0x3058,
	/* 04 25 */
	0x3059,	0x305a,	0x305b,	0x305c,	0x305d,	0x305e,	0x305f,	0x3060,
	/* 04 33 */
	0x3061,	0x3062,	0x3063,	0x3064,	0x3065,	0x3066,	0x3067,	0x3068,
	/* 04 41 */
	0x3069,	0x306a,	0x306b,	0x306c,	0x306d,	0x306e,	0x306f,	0x3070,
	/* 04 49 */
	0x3071,	0x3072,	0x3073,	0x3074,	0x3075,	0x3076,	0x3077,	0x3078,
	/* 04 57 */
	0x3079,	0x307a,	0x307b,	0x307c,	0x307d,	0x307e,	0x307f,	0x3080,
	/* 04 65 */
	0x3081,	0x3082,	0x3083,	0x3084,	0x3085,	0x3086,	0x3087,	0x3088,
	/* 04 73 */
	0x3089,	0x308a,	0x308b,	0x308c,	0x308d,	0x308e,	0x308f,	0x3090,
	/* 04 81 */
	0x3091,	0x3092,	0x3093,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 04 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 05 01 */
	0x30a1,	0x30a2,	0x30a3,	0x30a4,	0x30a5,	0x30a6,	0x30a7,	0x30a8,
	/* 05 09 */
	0x30a9,	0x30aa,	0x30ab,	0x30ac,	0x30ad,	0x30ae,	0x30af,	0x30b0,
	/* 05 17 */
	0x30b1,	0x30b2,	0x30b3,	0x30b4,	0x30b5,	0x30b6,	0x30b7,	0x30b8,
	/* 05 25 */
	0x30b9,	0x30ba,	0x30bb,	0x30bc,	0x30bd,	0x30be,	0x30bf,	0x30c0,
	/* 05 33 */
	0x30c1,	0x30c2,	0x30c3,	0x30c4,	0x30c5,	0x30c6,	0x30c7,	0x30c8,
	/* 05 41 */
	0x30c9,	0x30ca,	0x30cb,	0x30cc,	0x30cd,	0x30ce,	0x30cf,	0x30d0,
	/* 05 49 */
	0x30d1,	0x30d2,	0x30d3,	0x30d4,	0x30d5,	0x30d6,	0x30d7,	0x30d8,
	/* 05 57 */
	0x30d9,	0x30da,	0x30db,	0x30dc,	0x30dd,	0x30de,	0x30df,	0x30e0,
	/* 05 65 */
	0x30e1,	0x30e2,	0x30e3,	0x30e4,	0x30e5,	0x30e6,	0x30e7,	0x30e8,
	/* 05 73 */
	0x30e9,	0x30ea,	0x30eb,	0x30ec,	0x30ed,	0x30ee,	0x30ef,	0x30f0,
	/* 05 81 */
	0x30f1,	0x30f2,	0x30f3,	0x30f4,	0x30f5,	0x30f6,	NODEST,	NODEST,
	/* 05 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 06 01 */
	0x0391,	0x0392,	0x0393,	0x0394,	0x0395,	0x0396,	0x0397,	0x0398,
	/* 06 09 */
	0x0399,	0x039a,	0x039b,	0x039c,	0x039d,	0x039e,	0x039f,	0x03a0,
	/* 06 17 */
	0x03a1,	0x03a3,	0x03a4,	0x03a5,	0x03a6,	0x03a7,	0x03a8,	0x03a9,
	/* 06 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 06 33 */
	0x03b1,	0x03b2,	0x03b3,	0x03b4,	0x03b5,	0x03b6,	0x03b7,	0x03b8,
	/* 06 41 */
	0x03b9,	0x03ba,	0x03bb,	0x03bc,	0x03bd,	0x03be,	0x03bf,	0x03c0,
	/* 06 49 */
	0x03c1,	0x03c3,	0x03c4,	0x03c5,	0x03c6,	0x03c7,	0x03c8,	0x03c9,
	/* 06 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 06 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 06 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 06 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 06 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 07 01 */
	0x0410,	0x0411,	0x0412,	0x0413,	0x0414,	0x0415,	0x0401,	0x0416,
	/* 07 09 */
	0x0417,	0x0418,	0x0419,	0x041a,	0x041b,	0x041c,	0x041d,	0x041e,
	/* 07 17 */
	0x041f,	0x0420,	0x0421,	0x0422,	0x0423,	0x0424,	0x0425,	0x0426,
	/* 07 25 */
	0x0427,	0x0428,	0x0429,	0x042a,	0x042b,	0x042c,	0x042d,	0x042e,
	/* 07 33 */
	0x042f,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 07 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 07 49 */
	0x0430,	0x0431,	0x0432,	0x0433,	0x0434,	0x0435,	0x0451,	0x0436,
	/* 07 57 */
	0x0437,	0x0438,	0x0439,	0x043a,	0x043b,	0x043c,	0x043d,	0x043e,
	/* 07 65 */
	0x043f,	0x0440,	0x0441,	0x0442,	0x0443,	0x0444,	0x0445,	0x0446,
	/* 07 73 */
	0x0447,	0x0448,	0x0449,	0x044a,	0x044b,	0x044c,	0x044d,	0x044e,
	/* 07 81 */
	0x044f,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 07 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 01 */
	0x2500,	0x2502,	0x250c,	0x2510,	0x2518,	0x2514,	0x251c,	0x252c,
	/* 08 09 */
	0x2524,	0x2534,	0x253c,	0x2501,	0x2503,	0x250f,	0x2513,	0x251b,
	/* 08 17 */
	0x2517,	0x2523,	0x2533,	0x252b,	0x253b,	0x254b,	0x2520,	0x252f,
	/* 08 25 */
	0x2528,	0x2537,	0x253f,	0x251d,	0x2530,	0x2525,	0x2538,	0x2542,
	/* 08 33 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 09 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 09 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 09 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 09 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 09 33 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 09 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 09 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 09 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 09 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 09 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 09 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 09 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 33 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 11 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 11 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 11 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 11 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 11 33 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 11 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 11 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 11 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 11 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 11 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 11 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 11 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 12 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 12 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 12 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 12 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 12 33 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 12 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 12 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 12 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 12 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 12 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 12 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 12 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 13 01 */
	0x2460,	0x2461,	0x2462,	0x2463,	0x2464,	0x2465,	0x2466,	0x2467,
	/* 13 09 */
	0x2468,	0x2469,	0x246a,	0x246b,	0x246c,	0x246d,	0x246e,	0x246f,
	/* 13 17 */
	0x2470,	0x2471,	0x2472,	0x2473,	0x2160,	0x2161,	0x2162,	0x2163,
	/* 13 25 */
	0x2164,	0x2165,	0x2166,	0x2167,	0x2168,	0x2169,	NODEST,	0x3349,
	/* 13 33 */
	0x3314,	0x3322,	0x334d,	0x3318,	0x3327,	0x3303,	0x3336,	0x3351,
	/* 13 41 */
	0x3357,	0x330d,	0x3326,	0x3323,	0x332b,	0x334a,	0x333b,	0x339c,
	/* 13 49 */
	0x339d,	0x339e,	0x338e,	0x338f,	0x33c4,	0x33a1,	NODEST,	NODEST,
	/* 13 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0x337b,	0x301d,
	/* 13 65 */
	0x301f,	0x2116,	0x33cd,	0x2121,	0x32a4,	0x32a5,	0x32a6,	0x32a7,
	/* 13 73 */
	0x32a8,	0x3231,	0x3232,	0x3239,	0x337e,	0x337d,	0x337c,	0x2252,
	/* 13 81 */
	0x2261,	0x222b,	0x222e,	0x2211,	0x221a,	0x22a5,	0x2220,	0x221f,
	/* 13 89 */
	0x22bf,	0x2235,	0x2229,	0x222a,	NODEST,	NODEST,
	/* 14 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 14 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 14 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 14 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 14 33 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 14 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 14 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 14 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 14 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 14 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 14 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 14 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 15 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 15 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 15 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 15 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 15 33 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 15 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 15 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 15 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 15 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 15 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 15 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 15 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 16 01 */
	0x4e9c,	0x5516,	0x5a03,	0x963f,	0x54c0,	0x611b,	0x6328,	0x59f6,
	/* 16 09 */
	0x9022,	0x8475,	0x831c,	0x7a50,	0x60aa,	0x63e1,	0x6e25,	0x65ed,
	/* 16 17 */
	0x8466,	0x82a6,	0x9bf5,	0x6893,	0x5727,	0x65a1,	0x6271,	0x5b9b,
	/* 16 25 */
	0x59d0,	0x867b,	0x98f4,	0x7d62,	0x7dbe,	0x9b8e,	0x6216,	0x7c9f,
	/* 16 33 */
	0x88b7,	0x5b89,	0x5eb5,	0x6309,	0x6697,	0x6848,	0x95c7,	0x978d,
	/* 16 41 */
	0x674f,	0x4ee5,	0x4f0a,	0x4f4d,	0x4f9d,	0x5049,	0x56f2,	0x5937,
	/* 16 49 */
	0x59d4,	0x5a01,	0x5c09,	0x60df,	0x610f,	0x6170,	0x6613,	0x6905,
	/* 16 57 */
	0x70ba,	0x754f,	0x7570,	0x79fb,	0x7dad,	0x7def,	0x80c3,	0x840e,
	/* 16 65 */
	0x8863,	0x8b02,	0x9055,	0x907a,	0x533b,	0x4e95,	0x4ea5,	0x57df,
	/* 16 73 */
	0x80b2,	0x90c1,	0x78ef,	0x4e00,	0x58f1,	0x6ea2,	0x9038,	0x7a32,
	/* 16 81 */
	0x8328,	0x828b,	0x9c2f,	0x5141,	0x5370,	0x54bd,	0x54e1,	0x56e0,
	/* 16 89 */
	0x59fb,	0x5f15,	0x98f2,	0x6deb,	0x80e4,	0x852d,
	/* 17 01 */
	0x9662,	0x9670,	0x96a0,	0x97fb,	0x540b,	0x53f3,	0x5b87,	0x70cf,
	/* 17 09 */
	0x7fbd,	0x8fc2,	0x96e8,	0x536f,	0x9d5c,	0x7aba,	0x4e11,	0x7893,
	/* 17 17 */
	0x81fc,	0x6e26,	0x5618,	0x5504,	0x6b1d,	0x851a,	0x9c3b,	0x59e5,
	/* 17 25 */
	0x53a9,	0x6d66,	0x74dc,	0x958f,	0x5642,	0x4e91,	0x904b,	0x96f2,
	/* 17 33 */
	0x834f,	0x990c,	0x53e1,	0x55b6,	0x5b30,	0x5f71,	0x6620,	0x66f3,
	/* 17 41 */
	0x6804,	0x6c38,	0x6cf3,	0x6d29,	0x745b,	0x76c8,	0x7a4e,	0x9834,
	/* 17 49 */
	0x82f1,	0x885b,	0x8a60,	0x92ed,	0x6db2,	0x75ab,	0x76ca,	0x99c5,
	/* 17 57 */
	0x60a6,	0x8b01,	0x8d8a,	0x95b2,	0x698e,	0x53ad,	0x5186,	0x5712,
	/* 17 65 */
	0x5830,	0x5944,	0x5bb4,	0x5ef6,	0x6028,	0x63a9,	0x63f4,	0x6cbf,
	/* 17 73 */
	0x6f14,	0x708e,	0x7114,	0x7159,	0x71d5,	0x733f,	0x7e01,	0x8276,
	/* 17 81 */
	0x82d1,	0x8597,	0x9060,	0x925b,	0x9d1b,	0x5869,	0x65bc,	0x6c5a,
	/* 17 89 */
	0x7525,	0x51f9,	0x592e,	0x5965,	0x5f80,	0x5fdc,
	/* 18 01 */
	0x62bc,	0x65fa,	0x6a2a,	0x6b27,	0x6bb4,	0x738b,	0x7fc1,	0x8956,
	/* 18 09 */
	0x9d2c,	0x9d0e,	0x9ec4,	0x5ca1,	0x6c96,	0x837b,	0x5104,	0x5c4b,
	/* 18 17 */
	0x61b6,	0x81c6,	0x6876,	0x7261,	0x4e59,	0x4ffa,	0x5378,	0x6069,
	/* 18 25 */
	0x6e29,	0x7a4f,	0x97f3,	0x4e0b,	0x5316,	0x4eee,	0x4f55,	0x4f3d,
	/* 18 33 */
	0x4fa1,	0x4f73,	0x52a0,	0x53ef,	0x5609,	0x590f,	0x5ac1,	0x5bb6,
	/* 18 41 */
	0x5be1,	0x79d1,	0x6687,	0x679c,	0x67b6,	0x6b4c,	0x6cb3,	0x706b,
	/* 18 49 */
	0x73c2,	0x798d,	0x79be,	0x7a3c,	0x7b87,	0x82b1,	0x82db,	0x8304,
	/* 18 57 */
	0x8377,	0x83ef,	0x83d3,	0x8766,	0x8ab2,	0x5629,	0x8ca8,	0x8fe6,
	/* 18 65 */
	0x904e,	0x971e,	0x868a,	0x4fc4,	0x5ce8,	0x6211,	0x7259,	0x753b,
	/* 18 73 */
	0x81e5,	0x82bd,	0x86fe,	0x8cc0,	0x96c5,	0x9913,	0x99d5,	0x4ecb,
	/* 18 81 */
	0x4f1a,	0x89e3,	0x56de,	0x584a,	0x58ca,	0x5efb,	0x5feb,	0x602a,
	/* 18 89 */
	0x6094,	0x6062,	0x61d0,	0x6212,	0x62d0,	0x6539,
	/* 19 01 */
	0x9b41,	0x6666,	0x68b0,	0x6d77,	0x7070,	0x754c,	0x7686,	0x7d75,
	/* 19 09 */
	0x82a5,	0x87f9,	0x958b,	0x968e,	0x8c9d,	0x51f1,	0x52be,	0x5916,
	/* 19 17 */
	0x54b3,	0x5bb3,	0x5d16,	0x6168,	0x6982,	0x6daf,	0x788d,	0x84cb,
	/* 19 25 */
	0x8857,	0x8a72,	0x93a7,	0x9ab8,	0x6d6c,	0x99a8,	0x86d9,	0x57a3,
	/* 19 33 */
	0x67ff,	0x86ce,	0x920e,	0x5283,	0x5687,	0x5404,	0x5ed3,	0x62e1,
	/* 19 41 */
	0x64b9,	0x683c,	0x6838,	0x6bbb,	0x7372,	0x78ba,	0x7a6b,	0x899a,
	/* 19 49 */
	0x89d2,	0x8d6b,	0x8f03,	0x90ed,	0x95a3,	0x9694,	0x9769,	0x5b66,
	/* 19 57 */
	0x5cb3,	0x697d,	0x984d,	0x984e,	0x639b,	0x7b20,	0x6a2b,	0x6a7f,
	/* 19 65 */
	0x68b6,	0x9c0d,	0x6f5f,	0x5272,	0x559d,	0x6070,	0x62ec,	0x6d3b,
	/* 19 73 */
	0x6e07,	0x6ed1,	0x845b,	0x8910,	0x8f44,	0x4e14,	0x9c39,	0x53f6,
	/* 19 81 */
	0x691b,	0x6a3a,	0x9784,	0x682a,	0x515c,	0x7ac3,	0x84b2,	0x91dc,
	/* 19 89 */
	0x938c,	0x565b,	0x9d28,	0x6822,	0x8305,	0x8431,
	/* 20 01 */
	0x7ca5,	0x5208,	0x82c5,	0x74e6,	0x4e7e,	0x4f83,	0x51a0,	0x5bd2,
	/* 20 09 */
	0x520a,	0x52d8,	0x52e7,	0x5dfb,	0x559a,	0x582a,	0x59e6,	0x5b8c,
	/* 20 17 */
	0x5b98,	0x5bdb,	0x5e72,	0x5e79,	0x60a3,	0x611f,	0x6163,	0x61be,
	/* 20 25 */
	0x63db,	0x6562,	0x67d1,	0x6853,	0x68fa,	0x6b3e,	0x6b53,	0x6c57,
	/* 20 33 */
	0x6f22,	0x6f97,	0x6f45,	0x74b0,	0x7518,	0x76e3,	0x770b,	0x7aff,
	/* 20 41 */
	0x7ba1,	0x7c21,	0x7de9,	0x7f36,	0x7ff0,	0x809d,	0x8266,	0x839e,
	/* 20 49 */
	0x89b3,	0x8acc,	0x8cab,	0x9084,	0x9451,	0x9593,	0x9591,	0x95a2,
	/* 20 57 */
	0x9665,	0x97d3,	0x9928,	0x8218,	0x4e38,	0x542b,	0x5cb8,	0x5dcc,
	/* 20 65 */
	0x73a9,	0x764c,	0x773c,	0x5ca9,	0x7feb,	0x8d0b,	0x96c1,	0x9811,
	/* 20 73 */
	0x9854,	0x9858,	0x4f01,	0x4f0e,	0x5371,	0x559c,	0x5668,	0x57fa,
	/* 20 81 */
	0x5947,	0x5b09,	0x5bc4,	0x5c90,	0x5e0c,	0x5e7e,	0x5fcc,	0x63ee,
	/* 20 89 */
	0x673a,	0x65d7,	0x65e2,	0x671f,	0x68cb,	0x68c4,
	/* 21 01 */
	0x6a5f,	0x5e30,	0x6bc5,	0x6c17,	0x6c7d,	0x757f,	0x7948,	0x5b63,
	/* 21 09 */
	0x7a00,	0x7d00,	0x5fbd,	0x898f,	0x8a18,	0x8cb4,	0x8d77,	0x8ecc,
	/* 21 17 */
	0x8f1d,	0x98e2,	0x9a0e,	0x9b3c,	0x4e80,	0x507d,	0x5100,	0x5993,
	/* 21 25 */
	0x5b9c,	0x622f,	0x6280,	0x64ec,	0x6b3a,	0x72a0,	0x7591,	0x7947,
	/* 21 33 */
	0x7fa9,	0x87fb,	0x8abc,	0x8b70,	0x63ac,	0x83ca,	0x97a0,	0x5409,
	/* 21 41 */
	0x5403,	0x55ab,	0x6854,	0x6a58,	0x8a70,	0x7827,	0x6775,	0x9ecd,
	/* 21 49 */
	0x5374,	0x5ba2,	0x811a,	0x8650,	0x9006,	0x4e18,	0x4e45,	0x4ec7,
	/* 21 57 */
	0x4f11,	0x53ca,	0x5438,	0x5bae,	0x5f13,	0x6025,	0x6551,	0x673d,
	/* 21 65 */
	0x6c42,	0x6c72,	0x6ce3,	0x7078,	0x7403,	0x7a76,	0x7aae,	0x7b08,
	/* 21 73 */
	0x7d1a,	0x7cfe,	0x7d66,	0x65e7,	0x725b,	0x53bb,	0x5c45,	0x5de8,
	/* 21 81 */
	0x62d2,	0x62e0,	0x6319,	0x6e20,	0x865a,	0x8a31,	0x8ddd,	0x92f8,
	/* 21 89 */
	0x6f01,	0x79a6,	0x9b5a,	0x4ea8,	0x4eab,	0x4eac,
	/* 22 01 */
	0x4f9b,	0x4fa0,	0x50d1,	0x5147,	0x7af6,	0x5171,	0x51f6,	0x5354,
	/* 22 09 */
	0x5321,	0x537f,	0x53eb,	0x55ac,	0x5883,	0x5ce1,	0x5f37,	0x5f4a,
	/* 22 17 */
	0x602f,	0x6050,	0x606d,	0x631f,	0x6559,	0x6a4b,	0x6cc1,	0x72c2,
	/* 22 25 */
	0x72ed,	0x77ef,	0x80f8,	0x8105,	0x8208,	0x854e,	0x90f7,	0x93e1,
	/* 22 33 */
	0x97ff,	0x9957,	0x9a5a,	0x4ef0,	0x51dd,	0x5c2d,	0x6681,	0x696d,
	/* 22 41 */
	0x5c40,	0x66f2,	0x6975,	0x7389,	0x6850,	0x7c81,	0x50c5,	0x52e4,
	/* 22 49 */
	0x5747,	0x5dfe,	0x9326,	0x65a4,	0x6b23,	0x6b3d,	0x7434,	0x7981,
	/* 22 57 */
	0x79bd,	0x7b4b,	0x7dca,	0x82b9,	0x83cc,	0x887f,	0x895f,	0x8b39,
	/* 22 65 */
	0x8fd1,	0x91d1,	0x541f,	0x9280,	0x4e5d,	0x5036,	0x53e5,	0x533a,
	/* 22 73 */
	0x72d7,	0x7396,	0x77e9,	0x82e6,	0x8eaf,	0x99c6,	0x99c8,	0x99d2,
	/* 22 81 */
	0x5177,	0x611a,	0x865e,	0x55b0,	0x7a7a,	0x5076,	0x5bd3,	0x9047,
	/* 22 89 */
	0x9685,	0x4e32,	0x6adb,	0x91e7,	0x5c51,	0x5c48,
	/* 23 01 */
	0x6398,	0x7a9f,	0x6c93,	0x9774,	0x8f61,	0x7aaa,	0x718a,	0x9688,
	/* 23 09 */
	0x7c82,	0x6817,	0x7e70,	0x6851,	0x936c,	0x52f2,	0x541b,	0x85ab,
	/* 23 17 */
	0x8a13,	0x7fa4,	0x8ecd,	0x90e1,	0x5366,	0x8888,	0x7941,	0x4fc2,
	/* 23 25 */
	0x50be,	0x5211,	0x5144,	0x5553,	0x572d,	0x73ea,	0x578b,	0x5951,
	/* 23 33 */
	0x5f62,	0x5f84,	0x6075,	0x6176,	0x6167,	0x61a9,	0x63b2,	0x643a,
	/* 23 41 */
	0x656c,	0x666f,	0x6842,	0x6e13,	0x7566,	0x7a3d,	0x7cfb,	0x7d4c,
	/* 23 49 */
	0x7d99,	0x7e4b,	0x7f6b,	0x830e,	0x834a,	0x86cd,	0x8a08,	0x8a63,
	/* 23 57 */
	0x8b66,	0x8efd,	0x981a,	0x9d8f,	0x82b8,	0x8fce,	0x9be8,	0x5287,
	/* 23 65 */
	0x621f,	0x6483,	0x6fc0,	0x9699,	0x6841,	0x5091,	0x6b20,	0x6c7a,
	/* 23 73 */
	0x6f54,	0x7a74,	0x7d50,	0x8840,	0x8a23,	0x6708,	0x4ef6,	0x5039,
	/* 23 81 */
	0x5026,	0x5065,	0x517c,	0x5238,	0x5263,	0x55a7,	0x570f,	0x5805,
	/* 23 89 */
	0x5acc,	0x5efa,	0x61b2,	0x61f8,	0x62f3,	0x6372,
	/* 24 01 */
	0x691c,	0x6a29,	0x727d,	0x72ac,	0x732e,	0x7814,	0x786f,	0x7d79,
	/* 24 09 */
	0x770c,	0x80a9,	0x898b,	0x8b19,	0x8ce2,	0x8ed2,	0x9063,	0x9375,
	/* 24 17 */
	0x967a,	0x9855,	0x9a13,	0x9e78,	0x5143,	0x539f,	0x53b3,	0x5e7b,
	/* 24 25 */
	0x5f26,	0x6e1b,	0x6e90,	0x7384,	0x73fe,	0x7d43,	0x8237,	0x8a00,
	/* 24 33 */
	0x8afa,	0x9650,	0x4e4e,	0x500b,	0x53e4,	0x547c,	0x56fa,	0x59d1,
	/* 24 41 */
	0x5b64,	0x5df1,	0x5eab,	0x5f27,	0x6238,	0x6545,	0x67af,	0x6e56,
	/* 24 49 */
	0x72d0,	0x7cca,	0x88b4,	0x80a1,	0x80e1,	0x83f0,	0x864e,	0x8a87,
	/* 24 57 */
	0x8de8,	0x9237,	0x96c7,	0x9867,	0x9f13,	0x4e94,	0x4e92,	0x4f0d,
	/* 24 65 */
	0x5348,	0x5449,	0x543e,	0x5a2f,	0x5f8c,	0x5fa1,	0x609f,	0x68a7,
	/* 24 73 */
	0x6a8e,	0x745a,	0x7881,	0x8a9e,	0x8aa4,	0x8b77,	0x9190,	0x4e5e,
	/* 24 81 */
	0x9bc9,	0x4ea4,	0x4f7c,	0x4faf,	0x5019,	0x5016,	0x5149,	0x516c,
	/* 24 89 */
	0x529f,	0x52b9,	0x52fe,	0x539a,	0x53e3,	0x5411,
	/* 25 01 */
	0x540e,	0x5589,	0x5751,	0x57a2,	0x597d,	0x5b54,	0x5b5d,	0x5b8f,
	/* 25 09 */
	0x5de5,	0x5de7,	0x5df7,	0x5e78,	0x5e83,	0x5e9a,	0x5eb7,	0x5f18,
	/* 25 17 */
	0x6052,	0x614c,	0x6297,	0x62d8,	0x63a7,	0x653b,	0x6602,	0x6643,
	/* 25 25 */
	0x66f4,	0x676d,	0x6821,	0x6897,	0x69cb,	0x6c5f,	0x6d2a,	0x6d69,
	/* 25 33 */
	0x6e2f,	0x6e9d,	0x7532,	0x7687,	0x786c,	0x7a3f,	0x7ce0,	0x7d05,
	/* 25 41 */
	0x7d18,	0x7d5e,	0x7db1,	0x8015,	0x8003,	0x80af,	0x80b1,	0x8154,
	/* 25 49 */
	0x818f,	0x822a,	0x8352,	0x884c,	0x8861,	0x8b1b,	0x8ca2,	0x8cfc,
	/* 25 57 */
	0x90ca,	0x9175,	0x9271,	0x783f,	0x92fc,	0x95a4,	0x964d,	0x9805,
	/* 25 65 */
	0x9999,	0x9ad8,	0x9d3b,	0x525b,	0x52ab,	0x53f7,	0x5408,	0x58d5,
	/* 25 73 */
	0x62f7,	0x6fe0,	0x8c6a,	0x8f5f,	0x9eb9,	0x514b,	0x523b,	0x544a,
	/* 25 81 */
	0x56fd,	0x7a40,	0x9177,	0x9d60,	0x9ed2,	0x7344,	0x6f09,	0x8170,
	/* 25 89 */
	0x7511,	0x5ffd,	0x60da,	0x9aa8,	0x72db,	0x8fbc,
	/* 26 01 */
	0x6b64,	0x9803,	0x4eca,	0x56f0,	0x5764,	0x58be,	0x5a5a,	0x6068,
	/* 26 09 */
	0x61c7,	0x660f,	0x6606,	0x6839,	0x68b1,	0x6df7,	0x75d5,	0x7d3a,
	/* 26 17 */
	0x826e,	0x9b42,	0x4e9b,	0x4f50,	0x53c9,	0x5506,	0x5d6f,	0x5de6,
	/* 26 25 */
	0x5dee,	0x67fb,	0x6c99,	0x7473,	0x7802,	0x8a50,	0x9396,	0x88df,
	/* 26 33 */
	0x5750,	0x5ea7,	0x632b,	0x50b5,	0x50ac,	0x518d,	0x6700,	0x54c9,
	/* 26 41 */
	0x585e,	0x59bb,	0x5bb0,	0x5f69,	0x624d,	0x63a1,	0x683d,	0x6b73,
	/* 26 49 */
	0x6e08,	0x707d,	0x91c7,	0x7280,	0x7815,	0x7826,	0x796d,	0x658e,
	/* 26 57 */
	0x7d30,	0x83dc,	0x88c1,	0x8f09,	0x969b,	0x5264,	0x5728,	0x6750,
	/* 26 65 */
	0x7f6a,	0x8ca1,	0x51b4,	0x5742,	0x962a,	0x583a,	0x698a,	0x80b4,
	/* 26 73 */
	0x54b2,	0x5d0e,	0x57fc,	0x7895,	0x9dfa,	0x4f5c,	0x524a,	0x548b,
	/* 26 81 */
	0x643e,	0x6628,	0x6714,	0x67f5,	0x7a84,	0x7b56,	0x7d22,	0x932f,
	/* 26 89 */
	0x685c,	0x9bad,	0x7b39,	0x5319,	0x518a,	0x5237,
	/* 27 01 */
	0x5bdf,	0x62f6,	0x64ae,	0x64e6,	0x672d,	0x6bba,	0x85a9,	0x96d1,
	/* 27 09 */
	0x7690,	0x9bd6,	0x634c,	0x9306,	0x9bab,	0x76bf,	0x6652,	0x4e09,
	/* 27 17 */
	0x5098,	0x53c2,	0x5c71,	0x60e8,	0x6492,	0x6563,	0x685f,	0x71e6,
	/* 27 25 */
	0x73ca,	0x7523,	0x7b97,	0x7e82,	0x8695,	0x8b83,	0x8cdb,	0x9178,
	/* 27 33 */
	0x9910,	0x65ac,	0x66ab,	0x6b8b,	0x4ed5,	0x4ed4,	0x4f3a,	0x4f7f,
	/* 27 41 */
	0x523a,	0x53f8,	0x53f2,	0x55e3,	0x56db,	0x58eb,	0x59cb,	0x59c9,
	/* 27 49 */
	0x59ff,	0x5b50,	0x5c4d,	0x5e02,	0x5e2b,	0x5fd7,	0x601d,	0x6307,
	/* 27 57 */
	0x652f,	0x5b5c,	0x65af,	0x65bd,	0x65e8,	0x679d,	0x6b62,	0x6b7b,
	/* 27 65 */
	0x6c0f,	0x7345,	0x7949,	0x79c1,	0x7cf8,	0x7d19,	0x7d2b,	0x80a2,
	/* 27 73 */
	0x8102,	0x81f3,	0x8996,	0x8a5e,	0x8a69,	0x8a66,	0x8a8c,	0x8aee,
	/* 27 81 */
	0x8cc7,	0x8cdc,	0x96cc,	0x98fc,	0x6b6f,	0x4e8b,	0x4f3c,	0x4f8d,
	/* 27 89 */
	0x5150,	0x5b57,	0x5bfa,	0x6148,	0x6301,	0x6642,
	/* 28 01 */
	0x6b21,	0x6ecb,	0x6cbb,	0x723e,	0x74bd,	0x75d4,	0x78c1,	0x793a,
	/* 28 09 */
	0x800c,	0x8033,	0x81ea,	0x8494,	0x8f9e,	0x6c50,	0x9e7f,	0x5f0f,
	/* 28 17 */
	0x8b58,	0x9d2b,	0x7afa,	0x8ef8,	0x5b8d,	0x96eb,	0x4e03,	0x53f1,
	/* 28 25 */
	0x57f7,	0x5931,	0x5ac9,	0x5ba4,	0x6089,	0x6e7f,	0x6f06,	0x75be,
	/* 28 33 */
	0x8cea,	0x5b9f,	0x8500,	0x7be0,	0x5072,	0x67f4,	0x829d,	0x5c61,
	/* 28 41 */
	0x854a,	0x7e1e,	0x820e,	0x5199,	0x5c04,	0x6368,	0x8d66,	0x659c,
	/* 28 49 */
	0x716e,	0x793e,	0x7d17,	0x8005,	0x8b1d,	0x8eca,	0x906e,	0x86c7,
	/* 28 57 */
	0x90aa,	0x501f,	0x52fa,	0x5c3a,	0x6753,	0x707c,	0x7235,	0x914c,
	/* 28 65 */
	0x91c8,	0x932b,	0x82e5,	0x5bc2,	0x5f31,	0x60f9,	0x4e3b,	0x53d6,
	/* 28 73 */
	0x5b88,	0x624b,	0x6731,	0x6b8a,	0x72e9,	0x73e0,	0x7a2e,	0x816b,
	/* 28 81 */
	0x8da3,	0x9152,	0x9996,	0x5112,	0x53d7,	0x546a,	0x5bff,	0x6388,
	/* 28 89 */
	0x6a39,	0x7dac,	0x9700,	0x56da,	0x53ce,	0x5468,
	/* 29 01 */
	0x5b97,	0x5c31,	0x5dde,	0x4fee,	0x6101,	0x62fe,	0x6d32,	0x79c0,
	/* 29 09 */
	0x79cb,	0x7d42,	0x7e4d,	0x7fd2,	0x81ed,	0x821f,	0x8490,	0x8846,
	/* 29 17 */
	0x8972,	0x8b90,	0x8e74,	0x8f2f,	0x9031,	0x914b,	0x916c,	0x96c6,
	/* 29 25 */
	0x919c,	0x4ec0,	0x4f4f,	0x5145,	0x5341,	0x5f93,	0x620e,	0x67d4,
	/* 29 33 */
	0x6c41,	0x6e0b,	0x7363,	0x7e26,	0x91cd,	0x9283,	0x53d4,	0x5919,
	/* 29 41 */
	0x5bbf,	0x6dd1,	0x795d,	0x7e2e,	0x7c9b,	0x587e,	0x719f,	0x51fa,
	/* 29 49 */
	0x8853,	0x8ff0,	0x4fca,	0x5cfb,	0x6625,	0x77ac,	0x7ae3,	0x821c,
	/* 29 57 */
	0x99ff,	0x51c6,	0x5faa,	0x65ec,	0x696f,	0x6b89,	0x6df3,	0x6e96,
	/* 29 65 */
	0x6f64,	0x76fe,	0x7d14,	0x5de1,	0x9075,	0x9187,	0x9806,	0x51e6,
	/* 29 73 */
	0x521d,	0x6240,	0x6691,	0x66d9,	0x6e1a,	0x5eb6,	0x7dd2,	0x7f72,
	/* 29 81 */
	0x66f8,	0x85af,	0x85f7,	0x8af8,	0x52a9,	0x53d9,	0x5973,	0x5e8f,
	/* 29 89 */
	0x5f90,	0x6055,	0x92e4,	0x9664,	0x50b7,	0x511f,
	/* 30 01 */
	0x52dd,	0x5320,	0x5347,	0x53ec,	0x54e8,	0x5546,	0x5531,	0x5617,
	/* 30 09 */
	0x5968,	0x59be,	0x5a3c,	0x5bb5,	0x5c06,	0x5c0f,	0x5c11,	0x5c1a,
	/* 30 17 */
	0x5e84,	0x5e8a,	0x5ee0,	0x5f70,	0x627f,	0x6284,	0x62db,	0x638c,
	/* 30 25 */
	0x6377,	0x6607,	0x660c,	0x662d,	0x6676,	0x677e,	0x68a2,	0x6a1f,
	/* 30 33 */
	0x6a35,	0x6cbc,	0x6d88,	0x6e09,	0x6e58,	0x713c,	0x7126,	0x7167,
	/* 30 41 */
	0x75c7,	0x7701,	0x785d,	0x7901,	0x7965,	0x79f0,	0x7ae0,	0x7b11,
	/* 30 49 */
	0x7ca7,	0x7d39,	0x8096,	0x83d6,	0x848b,	0x8549,	0x885d,	0x88f3,
	/* 30 57 */
	0x8a1f,	0x8a3c,	0x8a54,	0x8a73,	0x8c61,	0x8cde,	0x91a4,	0x9266,
	/* 30 65 */
	0x937e,	0x9418,	0x969c,	0x9798,	0x4e0a,	0x4e08,	0x4e1e,	0x4e57,
	/* 30 73 */
	0x5197,	0x5270,	0x57ce,	0x5834,	0x58cc,	0x5b22,	0x5e38,	0x60c5,
	/* 30 81 */
	0x64fe,	0x6761,	0x6756,	0x6d44,	0x72b6,	0x7573,	0x7a63,	0x84b8,
	/* 30 89 */
	0x8b72,	0x91b8,	0x9320,	0x5631,	0x57f4,	0x98fe,
	/* 31 01 */
	0x62ed,	0x690d,	0x6b96,	0x71ed,	0x7e54,	0x8077,	0x8272,	0x89e6,
	/* 31 09 */
	0x98df,	0x8755,	0x8fb1,	0x5c3b,	0x4f38,	0x4fe1,	0x4fb5,	0x5507,
	/* 31 17 */
	0x5a20,	0x5bdd,	0x5be9,	0x5fc3,	0x614e,	0x632f,	0x65b0,	0x664b,
	/* 31 25 */
	0x68ee,	0x699b,	0x6d78,	0x6df1,	0x7533,	0x75b9,	0x771f,	0x795e,
	/* 31 33 */
	0x79e6,	0x7d33,	0x81e3,	0x82af,	0x85aa,	0x89aa,	0x8a3a,	0x8eab,
	/* 31 41 */
	0x8f9b,	0x9032,	0x91dd,	0x9707,	0x4eba,	0x4ec1,	0x5203,	0x5875,
	/* 31 49 */
	0x58ec,	0x5c0b,	0x751a,	0x5c3d,	0x814e,	0x8a0a,	0x8fc5,	0x9663,
	/* 31 57 */
	0x976d,	0x7b25,	0x8acf,	0x9808,	0x9162,	0x56f3,	0x53a8,	0x9017,
	/* 31 65 */
	0x5439,	0x5782,	0x5e25,	0x63a8,	0x6c34,	0x708a,	0x7761,	0x7c8b,
	/* 31 73 */
	0x7fe0,	0x8870,	0x9042,	0x9154,	0x9310,	0x9318,	0x968f,	0x745e,
	/* 31 81 */
	0x9ac4,	0x5d07,	0x5d69,	0x6570,	0x67a2,	0x8da8,	0x96db,	0x636e,
	/* 31 89 */
	0x6749,	0x6919,	0x83c5,	0x9817,	0x96c0,	0x88fe,
	/* 32 01 */
	0x6f84,	0x647a,	0x5bf8,	0x4e16,	0x702c,	0x755d,	0x662f,	0x51c4,
	/* 32 09 */
	0x5236,	0x52e2,	0x59d3,	0x5f81,	0x6027,	0x6210,	0x653f,	0x6574,
	/* 32 17 */
	0x661f,	0x6674,	0x68f2,	0x6816,	0x6b63,	0x6e05,	0x7272,	0x751f,
	/* 32 25 */
	0x76db,	0x7cbe,	0x8056,	0x58f0,	0x88fd,	0x897f,	0x8aa0,	0x8a93,
	/* 32 33 */
	0x8acb,	0x901d,	0x9192,	0x9752,	0x9759,	0x6589,	0x7a0e,	0x8106,
	/* 32 41 */
	0x96bb,	0x5e2d,	0x60dc,	0x621a,	0x65a5,	0x6614,	0x6790,	0x77f3,
	/* 32 49 */
	0x7a4d,	0x7c4d,	0x7e3e,	0x810a,	0x8cac,	0x8d64,	0x8de1,	0x8e5f,
	/* 32 57 */
	0x78a9,	0x5207,	0x62d9,	0x63a5,	0x6442,	0x6298,	0x8a2d,	0x7a83,
	/* 32 65 */
	0x7bc0,	0x8aac,	0x96ea,	0x7d76,	0x820c,	0x8749,	0x4ed9,	0x5148,
	/* 32 73 */
	0x5343,	0x5360,	0x5ba3,	0x5c02,	0x5c16,	0x5ddd,	0x6226,	0x6247,
	/* 32 81 */
	0x64b0,	0x6813,	0x6834,	0x6cc9,	0x6d45,	0x6d17,	0x67d3,	0x6f5c,
	/* 32 89 */
	0x714e,	0x717d,	0x65cb,	0x7a7f,	0x7bad,	0x7dda,
	/* 33 01 */
	0x7e4a,	0x7fa8,	0x817a,	0x821b,	0x8239,	0x85a6,	0x8a6e,	0x8cce,
	/* 33 09 */
	0x8df5,	0x9078,	0x9077,	0x92ad,	0x9291,	0x9583,	0x9bae,	0x524d,
	/* 33 17 */
	0x5584,	0x6f38,	0x7136,	0x5168,	0x7985,	0x7e55,	0x81b3,	0x7cce,
	/* 33 25 */
	0x564c,	0x5851,	0x5ca8,	0x63aa,	0x66fe,	0x66fd,	0x695a,	0x72d9,
	/* 33 33 */
	0x758f,	0x758e,	0x790e,	0x7956,	0x79df,	0x7c97,	0x7d20,	0x7d44,
	/* 33 41 */
	0x8607,	0x8a34,	0x963b,	0x9061,	0x9f20,	0x50e7,	0x5275,	0x53cc,
	/* 33 49 */
	0x53e2,	0x5009,	0x55aa,	0x58ee,	0x594f,	0x723d,	0x5b8b,	0x5c64,
	/* 33 57 */
	0x531d,	0x60e3,	0x60f3,	0x635c,	0x6383,	0x633f,	0x63bb,	0x64cd,
	/* 33 65 */
	0x65e9,	0x66f9,	0x5de3,	0x69cd,	0x69fd,	0x6f15,	0x71e5,	0x4e89,
	/* 33 73 */
	0x75e9,	0x76f8,	0x7a93,	0x7cdf,	0x7dcf,	0x7d9c,	0x8061,	0x8349,
	/* 33 81 */
	0x8358,	0x846c,	0x84bc,	0x85fb,	0x88c5,	0x8d70,	0x9001,	0x906d,
	/* 33 89 */
	0x9397,	0x971c,	0x9a12,	0x50cf,	0x5897,	0x618e,
	/* 34 01 */
	0x81d3,	0x8535,	0x8d08,	0x9020,	0x4fc3,	0x5074,	0x5247,	0x5373,
	/* 34 09 */
	0x606f,	0x6349,	0x675f,	0x6e2c,	0x8db3,	0x901f,	0x4fd7,	0x5c5e,
	/* 34 17 */
	0x8cca,	0x65cf,	0x7d9a,	0x5352,	0x8896,	0x5176,	0x63c3,	0x5b58,
	/* 34 25 */
	0x5b6b,	0x5c0a,	0x640d,	0x6751,	0x905c,	0x4ed6,	0x591a,	0x592a,
	/* 34 33 */
	0x6c70,	0x8a51,	0x553e,	0x5815,	0x59a5,	0x60f0,	0x6253,	0x67c1,
	/* 34 41 */
	0x8235,	0x6955,	0x9640,	0x99c4,	0x9a28,	0x4f53,	0x5806,	0x5bfe,
	/* 34 49 */
	0x8010,	0x5cb1,	0x5e2f,	0x5f85,	0x6020,	0x614b,	0x6234,	0x66ff,
	/* 34 57 */
	0x6cf0,	0x6ede,	0x80ce,	0x817f,	0x82d4,	0x888b,	0x8cb8,	0x9000,
	/* 34 65 */
	0x902e,	0x968a,	0x9edb,	0x9bdb,	0x4ee3,	0x53f0,	0x5927,	0x7b2c,
	/* 34 73 */
	0x918d,	0x984c,	0x9df9,	0x6edd,	0x7027,	0x5353,	0x5544,	0x5b85,
	/* 34 81 */
	0x6258,	0x629e,	0x62d3,	0x6ca2,	0x6fef,	0x7422,	0x8a17,	0x9438,
	/* 34 89 */
	0x6fc1,	0x8afe,	0x8338,	0x51e7,	0x86f8,	0x53ea,
	/* 35 01 */
	0x53e9,	0x4f46,	0x9054,	0x8fb0,	0x596a,	0x8131,	0x5dfd,	0x7aea,
	/* 35 09 */
	0x8fbf,	0x68da,	0x8c37,	0x72f8,	0x9c48,	0x6a3d,	0x8ab0,	0x4e39,
	/* 35 17 */
	0x5358,	0x5606,	0x5766,	0x62c5,	0x63a2,	0x65e6,	0x6b4e,	0x6de1,
	/* 35 25 */
	0x6e5b,	0x70ad,	0x77ed,	0x7aef,	0x7baa,	0x7dbb,	0x803d,	0x80c6,
	/* 35 33 */
	0x86cb,	0x8a95,	0x935b,	0x56e3,	0x58c7,	0x5f3e,	0x65ad,	0x6696,
	/* 35 41 */
	0x6a80,	0x6bb5,	0x7537,	0x8ac7,	0x5024,	0x77e5,	0x5730,	0x5f1b,
	/* 35 49 */
	0x6065,	0x667a,	0x6c60,	0x75f4,	0x7a1a,	0x7f6e,	0x81f4,	0x8718,
	/* 35 57 */
	0x9045,	0x99b3,	0x7bc9,	0x755c,	0x7af9,	0x7b51,	0x84c4,	0x9010,
	/* 35 65 */
	0x79e9,	0x7a92,	0x8336,	0x5ae1,	0x7740,	0x4e2d,	0x4ef2,	0x5b99,
	/* 35 73 */
	0x5fe0,	0x62bd,	0x663c,	0x67f1,	0x6ce8,	0x866b,	0x8877,	0x8a3b,
	/* 35 81 */
	0x914e,	0x92f3,	0x99d0,	0x6a17,	0x7026,	0x732a,	0x82e7,	0x8457,
	/* 35 89 */
	0x8caf,	0x4e01,	0x5146,	0x51cb,	0x558b,	0x5bf5,
	/* 36 01 */
	0x5e16,	0x5e33,	0x5e81,	0x5f14,	0x5f35,	0x5f6b,	0x5fb4,	0x61f2,
	/* 36 09 */
	0x6311,	0x66a2,	0x671d,	0x6f6e,	0x7252,	0x753a,	0x773a,	0x8074,
	/* 36 17 */
	0x8139,	0x8178,	0x8776,	0x8abf,	0x8adc,	0x8d85,	0x8df3,	0x929a,
	/* 36 25 */
	0x9577,	0x9802,	0x9ce5,	0x52c5,	0x6357,	0x76f4,	0x6715,	0x6c88,
	/* 36 33 */
	0x73cd,	0x8cc3,	0x93ae,	0x9673,	0x6d25,	0x589c,	0x690e,	0x69cc,
	/* 36 41 */
	0x8ffd,	0x939a,	0x75db,	0x901a,	0x585a,	0x6802,	0x63b4,	0x69fb,
	/* 36 49 */
	0x4f43,	0x6f2c,	0x67d8,	0x8fbb,	0x8526,	0x7db4,	0x9354,	0x693f,
	/* 36 57 */
	0x6f70,	0x576a,	0x58f7,	0x5b2c,	0x7d2c,	0x722a,	0x540a,	0x91e3,
	/* 36 65 */
	0x9db4,	0x4ead,	0x4f4e,	0x505c,	0x5075,	0x5243,	0x8c9e,	0x5448,
	/* 36 73 */
	0x5824,	0x5b9a,	0x5e1d,	0x5e95,	0x5ead,	0x5ef7,	0x5f1f,	0x608c,
	/* 36 81 */
	0x62b5,	0x633a,	0x63d0,	0x68af,	0x6c40,	0x7887,	0x798e,	0x7a0b,
	/* 36 89 */
	0x7de0,	0x8247,	0x8a02,	0x8ae6,	0x8e44,	0x9013,
	/* 37 01 */
	0x90b8,	0x912d,	0x91d8,	0x9f0e,	0x6ce5,	0x6458,	0x64e2,	0x6575,
	/* 37 09 */
	0x6ef4,	0x7684,	0x7b1b,	0x9069,	0x93d1,	0x6eba,	0x54f2,	0x5fb9,
	/* 37 17 */
	0x64a4,	0x8f4d,	0x8fed,	0x9244,	0x5178,	0x586b,	0x5929,	0x5c55,
	/* 37 25 */
	0x5e97,	0x6dfb,	0x7e8f,	0x751c,	0x8cbc,	0x8ee2,	0x985b,	0x70b9,
	/* 37 33 */
	0x4f1d,	0x6bbf,	0x6fb1,	0x7530,	0x96fb,	0x514e,	0x5410,	0x5835,
	/* 37 41 */
	0x5857,	0x59ac,	0x5c60,	0x5f92,	0x6597,	0x675c,	0x6e21,	0x767b,
	/* 37 49 */
	0x83df,	0x8ced,	0x9014,	0x90fd,	0x934d,	0x7825,	0x783a,	0x52aa,
	/* 37 57 */
	0x5ea6,	0x571f,	0x5974,	0x6012,	0x5012,	0x515a,	0x51ac,	0x51cd,
	/* 37 65 */
	0x5200,	0x5510,	0x5854,	0x5858,	0x5957,	0x5b95,	0x5cf6,	0x5d8b,
	/* 37 73 */
	0x60bc,	0x6295,	0x642d,	0x6771,	0x6843,	0x68bc,	0x68df,	0x76d7,
	/* 37 81 */
	0x6dd8,	0x6e6f,	0x6d9b,	0x706f,	0x71c8,	0x5f53,	0x75d8,	0x7977,
	/* 37 89 */
	0x7b49,	0x7b54,	0x7b52,	0x7cd6,	0x7d71,	0x5230,
	/* 38 01 */
	0x8463,	0x8569,	0x85e4,	0x8a0e,	0x8b04,	0x8c46,	0x8e0f,	0x9003,
	/* 38 09 */
	0x900f,	0x9419,	0x9676,	0x982d,	0x9a30,	0x95d8,	0x50cd,	0x52d5,
	/* 38 17 */
	0x540c,	0x5802,	0x5c0e,	0x61a7,	0x649e,	0x6d1e,	0x77b3,	0x7ae5,
	/* 38 25 */
	0x80f4,	0x8404,	0x9053,	0x9285,	0x5ce0,	0x9d07,	0x533f,	0x5f97,
	/* 38 33 */
	0x5fb3,	0x6d9c,	0x7279,	0x7763,	0x79bf,	0x7be4,	0x6bd2,	0x72ec,
	/* 38 41 */
	0x8aad,	0x6803,	0x6a61,	0x51f8,	0x7a81,	0x6934,	0x5c4a,	0x9cf6,
	/* 38 49 */
	0x82eb,	0x5bc5,	0x9149,	0x701e,	0x5678,	0x5c6f,	0x60c7,	0x6566,
	/* 38 57 */
	0x6c8c,	0x8c5a,	0x9041,	0x9813,	0x5451,	0x66c7,	0x920d,	0x5948,
	/* 38 65 */
	0x90a3,	0x5185,	0x4e4d,	0x51ea,	0x8599,	0x8b0e,	0x7058,	0x637a,
	/* 38 73 */
	0x934b,	0x6962,	0x99b4,	0x7e04,	0x7577,	0x5357,	0x6960,	0x8edf,
	/* 38 81 */
	0x96e3,	0x6c5d,	0x4e8c,	0x5c3c,	0x5f10,	0x8fe9,	0x5302,	0x8cd1,
	/* 38 89 */
	0x8089,	0x8679,	0x5eff,	0x65e5,	0x4e73,	0x5165,
	/* 39 01 */
	0x5982,	0x5c3f,	0x97ee,	0x4efb,	0x598a,	0x5fcd,	0x8a8d,	0x6fe1,
	/* 39 09 */
	0x79b0,	0x7962,	0x5be7,	0x8471,	0x732b,	0x71b1,	0x5e74,	0x5ff5,
	/* 39 17 */
	0x637b,	0x649a,	0x71c3,	0x7c98,	0x4e43,	0x5efc,	0x4e4b,	0x57dc,
	/* 39 25 */
	0x56a2,	0x60a9,	0x6fc3,	0x7d0d,	0x80fd,	0x8133,	0x81bf,	0x8fb2,
	/* 39 33 */
	0x8997,	0x86a4,	0x5df4,	0x628a,	0x64ad,	0x8987,	0x6777,	0x6ce2,
	/* 39 41 */
	0x6d3e,	0x7436,	0x7834,	0x5a46,	0x7f75,	0x82ad,	0x99ac,	0x4ff3,
	/* 39 49 */
	0x5ec3,	0x62dd,	0x6392,	0x6557,	0x676f,	0x76c3,	0x724c,	0x80cc,
	/* 39 57 */
	0x80ba,	0x8f29,	0x914d,	0x500d,	0x57f9,	0x5a92,	0x6885,	0x6973,
	/* 39 65 */
	0x7164,	0x72fd,	0x8cb7,	0x58f2,	0x8ce0,	0x966a,	0x9019,	0x877f,
	/* 39 73 */
	0x79e4,	0x77e7,	0x8429,	0x4f2f,	0x5265,	0x535a,	0x62cd,	0x67cf,
	/* 39 81 */
	0x6cca,	0x767d,	0x7b94,	0x7c95,	0x8236,	0x8584,	0x8feb,	0x66dd,
	/* 39 89 */
	0x6f20,	0x7206,	0x7e1b,	0x83ab,	0x99c1,	0x9ea6,
	/* 40 01 */
	0x51fd,	0x7bb1,	0x7872,	0x7bb8,	0x8087,	0x7b48,	0x6ae8,	0x5e61,
	/* 40 09 */
	0x808c,	0x7551,	0x7560,	0x516b,	0x9262,	0x6e8c,	0x767a,	0x9197,
	/* 40 17 */
	0x9aea,	0x4f10,	0x7f70,	0x629c,	0x7b4f,	0x95a5,	0x9ce9,	0x567a,
	/* 40 25 */
	0x5859,	0x86e4,	0x96bc,	0x4f34,	0x5224,	0x534a,	0x53cd,	0x53db,
	/* 40 33 */
	0x5e06,	0x642c,	0x6591,	0x677f,	0x6c3e,	0x6c4e,	0x7248,	0x72af,
	/* 40 41 */
	0x73ed,	0x7554,	0x7e41,	0x822c,	0x85e9,	0x8ca9,	0x7bc4,	0x91c6,
	/* 40 49 */
	0x7169,	0x9812,	0x98ef,	0x633d,	0x6669,	0x756a,	0x76e4,	0x78d0,
	/* 40 57 */
	0x8543,	0x86ee,	0x532a,	0x5351,	0x5426,	0x5983,	0x5e87,	0x5f7c,
	/* 40 65 */
	0x60b2,	0x6249,	0x6279,	0x62ab,	0x6590,	0x6bd4,	0x6ccc,	0x75b2,
	/* 40 73 */
	0x76ae,	0x7891,	0x79d8,	0x7dcb,	0x7f77,	0x80a5,	0x88ab,	0x8ab9,
	/* 40 81 */
	0x8cbb,	0x907f,	0x975e,	0x98db,	0x6a0b,	0x7c38,	0x5099,	0x5c3e,
	/* 40 89 */
	0x5fae,	0x6787,	0x6bd8,	0x7435,	0x7709,	0x7f8e,
	/* 41 01 */
	0x9f3b,	0x67ca,	0x7a17,	0x5339,	0x758b,	0x9aed,	0x5f66,	0x819d,
	/* 41 09 */
	0x83f1,	0x8098,	0x5f3c,	0x5fc5,	0x7562,	0x7b46,	0x903c,	0x6867,
	/* 41 17 */
	0x59eb,	0x5a9b,	0x7d10,	0x767e,	0x8b2c,	0x4ff5,	0x5f6a,	0x6a19,
	/* 41 25 */
	0x6c37,	0x6f02,	0x74e2,	0x7968,	0x8868,	0x8a55,	0x8c79,	0x5edf,
	/* 41 33 */
	0x63cf,	0x75c5,	0x79d2,	0x82d7,	0x9328,	0x92f2,	0x849c,	0x86ed,
	/* 41 41 */
	0x9c2d,	0x54c1,	0x5f6c,	0x658c,	0x6d5c,	0x7015,	0x8ca7,	0x8cd3,
	/* 41 49 */
	0x983b,	0x654f,	0x74f6,	0x4e0d,	0x4ed8,	0x57e0,	0x592b,	0x5a66,
	/* 41 57 */
	0x5bcc,	0x51a8,	0x5e03,	0x5e9c,	0x6016,	0x6276,	0x6577,	0x65a7,
	/* 41 65 */
	0x666e,	0x6d6e,	0x7236,	0x7b26,	0x8150,	0x819a,	0x8299,	0x8b5c,
	/* 41 73 */
	0x8ca0,	0x8ce6,	0x8d74,	0x961c,	0x9644,	0x4fae,	0x64ab,	0x6b66,
	/* 41 81 */
	0x821e,	0x8461,	0x856a,	0x90e8,	0x5c01,	0x6953,	0x98a8,	0x847a,
	/* 41 89 */
	0x8557,	0x4f0f,	0x526f,	0x5fa9,	0x5e45,	0x670d,
	/* 42 01 */
	0x798f,	0x8179,	0x8907,	0x8986,	0x6df5,	0x5f17,	0x6255,	0x6cb8,
	/* 42 09 */
	0x4ecf,	0x7269,	0x9b92,	0x5206,	0x543b,	0x5674,	0x58b3,	0x61a4,
	/* 42 17 */
	0x626e,	0x711a,	0x596e,	0x7c89,	0x7cde,	0x7d1b,	0x96f0,	0x6587,
	/* 42 25 */
	0x805e,	0x4e19,	0x4f75,	0x5175,	0x5840,	0x5e63,	0x5e73,	0x5f0a,
	/* 42 33 */
	0x67c4,	0x4e26,	0x853d,	0x9589,	0x965b,	0x7c73,	0x9801,	0x50fb,
	/* 42 41 */
	0x58c1,	0x7656,	0x78a7,	0x5225,	0x77a5,	0x8511,	0x7b86,	0x504f,
	/* 42 49 */
	0x5909,	0x7247,	0x7bc7,	0x7de8,	0x8fba,	0x8fd4,	0x904d,	0x4fbf,
	/* 42 57 */
	0x52c9,	0x5a29,	0x5f01,	0x97ad,	0x4fdd,	0x8217,	0x92ea,	0x5703,
	/* 42 65 */
	0x6355,	0x6b69,	0x752b,	0x88dc,	0x8f14,	0x7a42,	0x52df,	0x5893,
	/* 42 73 */
	0x6155,	0x620a,	0x66ae,	0x6bcd,	0x7c3f,	0x83e9,	0x5023,	0x4ff8,
	/* 42 81 */
	0x5305,	0x5446,	0x5831,	0x5949,	0x5b9d,	0x5cf0,	0x5cef,	0x5d29,
	/* 42 89 */
	0x5e96,	0x62b1,	0x6367,	0x653e,	0x65b9,	0x670b,
	/* 43 01 */
	0x6cd5,	0x6ce1,	0x70f9,	0x7832,	0x7e2b,	0x80de,	0x82b3,	0x840c,
	/* 43 09 */
	0x84ec,	0x8702,	0x8912,	0x8a2a,	0x8c4a,	0x90a6,	0x92d2,	0x98fd,
	/* 43 17 */
	0x9cf3,	0x9d6c,	0x4e4f,	0x4ea1,	0x508d,	0x5256,	0x574a,	0x59a8,
	/* 43 25 */
	0x5e3d,	0x5fd8,	0x5fd9,	0x623f,	0x66b4,	0x671b,	0x67d0,	0x68d2,
	/* 43 33 */
	0x5192,	0x7d21,	0x80aa,	0x81a8,	0x8b00,	0x8c8c,	0x8cbf,	0x927e,
	/* 43 41 */
	0x9632,	0x5420,	0x982c,	0x5317,	0x50d5,	0x535c,	0x58a8,	0x64b2,
	/* 43 49 */
	0x6734,	0x7267,	0x7766,	0x7a46,	0x91e6,	0x52c3,	0x6ca1,	0x6b86,
	/* 43 57 */
	0x5800,	0x5e4c,	0x5954,	0x672c,	0x7ffb,	0x51e1,	0x76c6,	0x6469,
	/* 43 65 */
	0x78e8,	0x9b54,	0x9ebb,	0x57cb,	0x59b9,	0x6627,	0x679a,	0x6bce,
	/* 43 73 */
	0x54e9,	0x69d9,	0x5e55,	0x819c,	0x6795,	0x9baa,	0x67fe,	0x9c52,
	/* 43 81 */
	0x685d,	0x4ea6,	0x4fe3,	0x53c8,	0x62b9,	0x672b,	0x6cab,	0x8fc4,
	/* 43 89 */
	0x4fad,	0x7e6d,	0x9ebf,	0x4e07,	0x6162,	0x6e80,
	/* 44 01 */
	0x6f2b,	0x8513,	0x5473,	0x672a,	0x9b45,	0x5df3,	0x7b95,	0x5cac,
	/* 44 09 */
	0x5bc6,	0x871c,	0x6e4a,	0x84d1,	0x7a14,	0x8108,	0x5999,	0x7c8d,
	/* 44 17 */
	0x6c11,	0x7720,	0x52d9,	0x5922,	0x7121,	0x725f,	0x77db,	0x9727,
	/* 44 25 */
	0x9d61,	0x690b,	0x5a7f,	0x5a18,	0x51a5,	0x540d,	0x547d,	0x660e,
	/* 44 33 */
	0x76df,	0x8ff7,	0x9298,	0x9cf4,	0x59ea,	0x725d,	0x6ec5,	0x514d,
	/* 44 41 */
	0x68c9,	0x7dbf,	0x7dec,	0x9762,	0x9eba,	0x6478,	0x6a21,	0x8302,
	/* 44 49 */
	0x5984,	0x5b5f,	0x6bdb,	0x731b,	0x76f2,	0x7db2,	0x8017,	0x8499,
	/* 44 57 */
	0x5132,	0x6728,	0x9ed9,	0x76ee,	0x6762,	0x52ff,	0x9905,	0x5c24,
	/* 44 65 */
	0x623b,	0x7c7e,	0x8cb0,	0x554f,	0x60b6,	0x7d0b,	0x9580,	0x5301,
	/* 44 73 */
	0x4e5f,	0x51b6,	0x591c,	0x723a,	0x8036,	0x91ce,	0x5f25,	0x77e2,
	/* 44 81 */
	0x5384,	0x5f79,	0x7d04,	0x85ac,	0x8a33,	0x8e8d,	0x9756,	0x67f3,
	/* 44 89 */
	0x85ae,	0x9453,	0x6109,	0x6108,	0x6cb9,	0x7652,
	/* 45 01 */
	0x8aed,	0x8f38,	0x552f,	0x4f51,	0x512a,	0x52c7,	0x53cb,	0x5ba5,
	/* 45 09 */
	0x5e7d,	0x60a0,	0x6182,	0x63d6,	0x6709,	0x67da,	0x6e67,	0x6d8c,
	/* 45 17 */
	0x7336,	0x7337,	0x7531,	0x7950,	0x88d5,	0x8a98,	0x904a,	0x9091,
	/* 45 25 */
	0x90f5,	0x96c4,	0x878d,	0x5915,	0x4e88,	0x4f59,	0x4e0e,	0x8a89,
	/* 45 33 */
	0x8f3f,	0x9810,	0x50ad,	0x5e7c,	0x5996,	0x5bb9,	0x5eb8,	0x63da,
	/* 45 41 */
	0x63fa,	0x64c1,	0x66dc,	0x694a,	0x69d8,	0x6d0b,	0x6eb6,	0x7194,
	/* 45 49 */
	0x7528,	0x7aaf,	0x7f8a,	0x8000,	0x8449,	0x84c9,	0x8981,	0x8b21,
	/* 45 57 */
	0x8e0a,	0x9065,	0x967d,	0x990a,	0x617e,	0x6291,	0x6b32,	0x6c83,
	/* 45 65 */
	0x6d74,	0x7fcc,	0x7ffc,	0x6dc0,	0x7f85,	0x87ba,	0x88f8,	0x6765,
	/* 45 73 */
	0x83b1,	0x983c,	0x96f7,	0x6d1b,	0x7d61,	0x843d,	0x916a,	0x4e71,
	/* 45 81 */
	0x5375,	0x5d50,	0x6b04,	0x6feb,	0x85cd,	0x862d,	0x89a7,	0x5229,
	/* 45 89 */
	0x540f,	0x5c65,	0x674e,	0x68a8,	0x7406,	0x7483,
	/* 46 01 */
	0x75e2,	0x88cf,	0x88e1,	0x91cc,	0x96e2,	0x9678,	0x5f8b,	0x7387,
	/* 46 09 */
	0x7acb,	0x844e,	0x63a0,	0x7565,	0x5289,	0x6d41,	0x6e9c,	0x7409,
	/* 46 17 */
	0x7559,	0x786b,	0x7c92,	0x9686,	0x7adc,	0x9f8d,	0x4fb6,	0x616e,
	/* 46 25 */
	0x65c5,	0x865c,	0x4e86,	0x4eae,	0x50da,	0x4e21,	0x51cc,	0x5bee,
	/* 46 33 */
	0x6599,	0x6881,	0x6dbc,	0x731f,	0x7642,	0x77ad,	0x7a1c,	0x7ce7,
	/* 46 41 */
	0x826f,	0x8ad2,	0x907c,	0x91cf,	0x9675,	0x9818,	0x529b,	0x7dd1,
	/* 46 49 */
	0x502b,	0x5398,	0x6797,	0x6dcb,	0x71d0,	0x7433,	0x81e8,	0x8f2a,
	/* 46 57 */
	0x96a3,	0x9c57,	0x9e9f,	0x7460,	0x5841,	0x6d99,	0x7d2f,	0x985e,
	/* 46 65 */
	0x4ee4,	0x4f36,	0x4f8b,	0x51b7,	0x52b1,	0x5dba,	0x601c,	0x73b2,
	/* 46 73 */
	0x793c,	0x82d3,	0x9234,	0x96b7,	0x96f6,	0x970a,	0x9e97,	0x9f62,
	/* 46 81 */
	0x66a6,	0x6b74,	0x5217,	0x52a3,	0x70c8,	0x88c2,	0x5ec9,	0x604b,
	/* 46 89 */
	0x6190,	0x6f23,	0x7149,	0x7c3e,	0x7df4,	0x806f,
	/* 47 01 */
	0x84ee,	0x9023,	0x932c,	0x5442,	0x9b6f,	0x6ad3,	0x7089,	0x8cc2,
	/* 47 09 */
	0x8def,	0x9732,	0x52b4,	0x5a41,	0x5eca,	0x5f04,	0x6717,	0x697c,
	/* 47 17 */
	0x6994,	0x6d6a,	0x6f0f,	0x7262,	0x72fc,	0x7bed,	0x8001,	0x807e,
	/* 47 25 */
	0x874b,	0x90ce,	0x516d,	0x9e93,	0x7984,	0x808b,	0x9332,	0x8ad6,
	/* 47 33 */
	0x502d,	0x548c,	0x8a71,	0x6b6a,	0x8cc4,	0x8107,	0x60d1,	0x67a0,
	/* 47 41 */
	0x9df2,	0x4e99,	0x4e98,	0x9c10,	0x8a6b,	0x85c1,	0x8568,	0x6900,
	/* 47 49 */
	0x6e7e,	0x7897,	0x8155,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 47 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 47 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 47 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 47 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 47 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 48 01 */
	0x5f0c,	0x4e10,	0x4e15,	0x4e2a,	0x4e31,	0x4e36,	0x4e3c,	0x4e3f,
	/* 48 09 */
	0x4e42,	0x4e56,	0x4e58,	0x4e82,	0x4e85,	0x8c6b,	0x4e8a,	0x8212,
	/* 48 17 */
	0x5f0d,	0x4e8e,	0x4e9e,	0x4e9f,	0x4ea0,	0x4ea2,	0x4eb0,	0x4eb3,
	/* 48 25 */
	0x4eb6,	0x4ece,	0x4ecd,	0x4ec4,	0x4ec6,	0x4ec2,	0x4ed7,	0x4ede,
	/* 48 33 */
	0x4eed,	0x4edf,	0x4ef7,	0x4f09,	0x4f5a,	0x4f30,	0x4f5b,	0x4f5d,
	/* 48 41 */
	0x4f57,	0x4f47,	0x4f76,	0x4f88,	0x4f8f,	0x4f98,	0x4f7b,	0x4f69,
	/* 48 49 */
	0x4f70,	0x4f91,	0x4f6f,	0x4f86,	0x4f96,	0x5118,	0x4fd4,	0x4fdf,
	/* 48 57 */
	0x4fce,	0x4fd8,	0x4fdb,	0x4fd1,	0x4fda,	0x4fd0,	0x4fe4,	0x4fe5,
	/* 48 65 */
	0x501a,	0x5028,	0x5014,	0x502a,	0x5025,	0x5005,	0x4f1c,	0x4ff6,
	/* 48 73 */
	0x5021,	0x5029,	0x502c,	0x4ffe,	0x4fef,	0x5011,	0x5006,	0x5043,
	/* 48 81 */
	0x5047,	0x6703,	0x5055,	0x5050,	0x5048,	0x505a,	0x5056,	0x506c,
	/* 48 89 */
	0x5078,	0x5080,	0x509a,	0x5085,	0x50b4,	0x50b2,
	/* 49 01 */
	0x50c9,	0x50ca,	0x50b3,	0x50c2,	0x50d6,	0x50de,	0x50e5,	0x50ed,
	/* 49 09 */
	0x50e3,	0x50ee,	0x50f9,	0x50f5,	0x5109,	0x5101,	0x5102,	0x5116,
	/* 49 17 */
	0x5115,	0x5114,	0x511a,	0x5121,	0x513a,	0x5137,	0x513c,	0x513b,
	/* 49 25 */
	0x513f,	0x5140,	0x5152,	0x514c,	0x5154,	0x5162,	0x7af8,	0x5169,
	/* 49 33 */
	0x516a,	0x516e,	0x5180,	0x5182,	0x56d8,	0x518c,	0x5189,	0x518f,
	/* 49 41 */
	0x5191,	0x5193,	0x5195,	0x5196,	0x51a4,	0x51a6,	0x51a2,	0x51a9,
	/* 49 49 */
	0x51aa,	0x51ab,	0x51b3,	0x51b1,	0x51b2,	0x51b0,	0x51b5,	0x51bd,
	/* 49 57 */
	0x51c5,	0x51c9,	0x51db,	0x51e0,	0x8655,	0x51e9,	0x51ed,	0x51f0,
	/* 49 65 */
	0x51f5,	0x51fe,	0x5204,	0x520b,	0x5214,	0x520e,	0x5227,	0x522a,
	/* 49 73 */
	0x522e,	0x5233,	0x5239,	0x524f,	0x5244,	0x524b,	0x524c,	0x525e,
	/* 49 81 */
	0x5254,	0x526a,	0x5274,	0x5269,	0x5273,	0x527f,	0x527d,	0x528d,
	/* 49 89 */
	0x5294,	0x5292,	0x5271,	0x5288,	0x5291,	0x8fa8,
	/* 50 01 */
	0x8fa7,	0x52ac,	0x52ad,	0x52bc,	0x52b5,	0x52c1,	0x52cd,	0x52d7,
	/* 50 09 */
	0x52de,	0x52e3,	0x52e6,	0x98ed,	0x52e0,	0x52f3,	0x52f5,	0x52f8,
	/* 50 17 */
	0x52f9,	0x5306,	0x5308,	0x7538,	0x530d,	0x5310,	0x530f,	0x5315,
	/* 50 25 */
	0x531a,	0x5323,	0x532f,	0x5331,	0x5333,	0x5338,	0x5340,	0x5346,
	/* 50 33 */
	0x5345,	0x4e17,	0x5349,	0x534d,	0x51d6,	0x535e,	0x5369,	0x536e,
	/* 50 41 */
	0x5918,	0x537b,	0x5377,	0x5382,	0x5396,	0x53a0,	0x53a6,	0x53a5,
	/* 50 49 */
	0x53ae,	0x53b0,	0x53b6,	0x53c3,	0x7c12,	0x96d9,	0x53df,	0x66fc,
	/* 50 57 */
	0x71ee,	0x53ee,	0x53e8,	0x53ed,	0x53fa,	0x5401,	0x543d,	0x5440,
	/* 50 65 */
	0x542c,	0x542d,	0x543c,	0x542e,	0x5436,	0x5429,	0x541d,	0x544e,
	/* 50 73 */
	0x548f,	0x5475,	0x548e,	0x545f,	0x5471,	0x5477,	0x5470,	0x5492,
	/* 50 81 */
	0x547b,	0x5480,	0x5476,	0x5484,	0x5490,	0x5486,	0x54c7,	0x54a2,
	/* 50 89 */
	0x54b8,	0x54a5,	0x54ac,	0x54c4,	0x54c8,	0x54a8,
	/* 51 01 */
	0x54ab,	0x54c2,	0x54a4,	0x54be,	0x54bc,	0x54d8,	0x54e5,	0x54e6,
	/* 51 09 */
	0x550f,	0x5514,	0x54fd,	0x54ee,	0x54ed,	0x54fa,	0x54e2,	0x5539,
	/* 51 17 */
	0x5540,	0x5563,	0x554c,	0x552e,	0x555c,	0x5545,	0x5556,	0x5557,
	/* 51 25 */
	0x5538,	0x5533,	0x555d,	0x5599,	0x5580,	0x54af,	0x558a,	0x559f,
	/* 51 33 */
	0x557b,	0x557e,	0x5598,	0x559e,	0x55ae,	0x557c,	0x5583,	0x55a9,
	/* 51 41 */
	0x5587,	0x55a8,	0x55da,	0x55c5,	0x55df,	0x55c4,	0x55dc,	0x55e4,
	/* 51 49 */
	0x55d4,	0x5614,	0x55f7,	0x5616,	0x55fe,	0x55fd,	0x561b,	0x55f9,
	/* 51 57 */
	0x564e,	0x5650,	0x71df,	0x5634,	0x5636,	0x5632,	0x5638,	0x566b,
	/* 51 65 */
	0x5664,	0x562f,	0x566c,	0x566a,	0x5686,	0x5680,	0x568a,	0x56a0,
	/* 51 73 */
	0x5694,	0x568f,	0x56a5,	0x56ae,	0x56b6,	0x56b4,	0x56c2,	0x56bc,
	/* 51 81 */
	0x56c1,	0x56c3,	0x56c0,	0x56c8,	0x56ce,	0x56d1,	0x56d3,	0x56d7,
	/* 51 89 */
	0x56ee,	0x56f9,	0x5700,	0x56ff,	0x5704,	0x5709,
	/* 52 01 */
	0x5708,	0x570b,	0x570d,	0x5713,	0x5718,	0x5716,	0x55c7,	0x571c,
	/* 52 09 */
	0x5726,	0x5737,	0x5738,	0x574e,	0x573b,	0x5740,	0x574f,	0x5769,
	/* 52 17 */
	0x57c0,	0x5788,	0x5761,	0x577f,	0x5789,	0x5793,	0x57a0,	0x57b3,
	/* 52 25 */
	0x57a4,	0x57aa,	0x57b0,	0x57c3,	0x57c6,	0x57d4,	0x57d2,	0x57d3,
	/* 52 33 */
	0x580a,	0x57d6,	0x57e3,	0x580b,	0x5819,	0x581d,	0x5872,	0x5821,
	/* 52 41 */
	0x5862,	0x584b,	0x5870,	0x6bc0,	0x5852,	0x583d,	0x5879,	0x5885,
	/* 52 49 */
	0x58b9,	0x589f,	0x58ab,	0x58ba,	0x58de,	0x58bb,	0x58b8,	0x58ae,
	/* 52 57 */
	0x58c5,	0x58d3,	0x58d1,	0x58d7,	0x58d9,	0x58d8,	0x58e5,	0x58dc,
	/* 52 65 */
	0x58e4,	0x58df,	0x58ef,	0x58fa,	0x58f9,	0x58fb,	0x58fc,	0x58fd,
	/* 52 73 */
	0x5902,	0x590a,	0x5910,	0x591b,	0x68a6,	0x5925,	0x592c,	0x592d,
	/* 52 81 */
	0x5932,	0x5938,	0x593e,	0x7ad2,	0x5955,	0x5950,	0x594e,	0x595a,
	/* 52 89 */
	0x5958,	0x5962,	0x5960,	0x5967,	0x596c,	0x5969,
	/* 53 01 */
	0x5978,	0x5981,	0x599d,	0x4f5e,	0x4fab,	0x59a3,	0x59b2,	0x59c6,
	/* 53 09 */
	0x59e8,	0x59dc,	0x598d,	0x59d9,	0x59da,	0x5a25,	0x5a1f,	0x5a11,
	/* 53 17 */
	0x5a1c,	0x5a09,	0x5a1a,	0x5a40,	0x5a6c,	0x5a49,	0x5a35,	0x5a36,
	/* 53 25 */
	0x5a62,	0x5a6a,	0x5a9a,	0x5abc,	0x5abe,	0x5acb,	0x5ac2,	0x5abd,
	/* 53 33 */
	0x5ae3,	0x5ad7,	0x5ae6,	0x5ae9,	0x5ad6,	0x5afa,	0x5afb,	0x5b0c,
	/* 53 41 */
	0x5b0b,	0x5b16,	0x5b32,	0x5ad0,	0x5b2a,	0x5b36,	0x5b3e,	0x5b43,
	/* 53 49 */
	0x5b45,	0x5b40,	0x5b51,	0x5b55,	0x5b5a,	0x5b5b,	0x5b65,	0x5b69,
	/* 53 57 */
	0x5b70,	0x5b73,	0x5b75,	0x5b78,	0x6588,	0x5b7a,	0x5b80,	0x5b83,
	/* 53 65 */
	0x5ba6,	0x5bb8,	0x5bc3,	0x5bc7,	0x5bc9,	0x5bd4,	0x5bd0,	0x5be4,
	/* 53 73 */
	0x5be6,	0x5be2,	0x5bde,	0x5be5,	0x5beb,	0x5bf0,	0x5bf6,	0x5bf3,
	/* 53 81 */
	0x5c05,	0x5c07,	0x5c08,	0x5c0d,	0x5c13,	0x5c20,	0x5c22,	0x5c28,
	/* 53 89 */
	0x5c38,	0x5c39,	0x5c41,	0x5c46,	0x5c4e,	0x5c53,
	/* 54 01 */
	0x5c50,	0x5c4f,	0x5b71,	0x5c6c,	0x5c6e,	0x4e62,	0x5c76,	0x5c79,
	/* 54 09 */
	0x5c8c,	0x5c91,	0x5c94,	0x599b,	0x5cab,	0x5cbb,	0x5cb6,	0x5cbc,
	/* 54 17 */
	0x5cb7,	0x5cc5,	0x5cbe,	0x5cc7,	0x5cd9,	0x5ce9,	0x5cfd,	0x5cfa,
	/* 54 25 */
	0x5ced,	0x5d8c,	0x5cea,	0x5d0b,	0x5d15,	0x5d17,	0x5d5c,	0x5d1f,
	/* 54 33 */
	0x5d1b,	0x5d11,	0x5d14,	0x5d22,	0x5d1a,	0x5d19,	0x5d18,	0x5d4c,
	/* 54 41 */
	0x5d52,	0x5d4e,	0x5d4b,	0x5d6c,	0x5d73,	0x5d76,	0x5d87,	0x5d84,
	/* 54 49 */
	0x5d82,	0x5da2,	0x5d9d,	0x5dac,	0x5dae,	0x5dbd,	0x5d90,	0x5db7,
	/* 54 57 */
	0x5dbc,	0x5dc9,	0x5dcd,	0x5dd3,	0x5dd2,	0x5dd6,	0x5ddb,	0x5deb,
	/* 54 65 */
	0x5df2,	0x5df5,	0x5e0b,	0x5e1a,	0x5e19,	0x5e11,	0x5e1b,	0x5e36,
	/* 54 73 */
	0x5e37,	0x5e44,	0x5e43,	0x5e40,	0x5e4e,	0x5e57,	0x5e54,	0x5e5f,
	/* 54 81 */
	0x5e62,	0x5e64,	0x5e47,	0x5e75,	0x5e76,	0x5e7a,	0x9ebc,	0x5e7f,
	/* 54 89 */
	0x5ea0,	0x5ec1,	0x5ec2,	0x5ec8,	0x5ed0,	0x5ecf,
	/* 55 01 */
	0x5ed6,	0x5ee3,	0x5edd,	0x5eda,	0x5edb,	0x5ee2,	0x5ee1,	0x5ee8,
	/* 55 09 */
	0x5ee9,	0x5eec,	0x5ef1,	0x5ef3,	0x5ef0,	0x5ef4,	0x5ef8,	0x5efe,
	/* 55 17 */
	0x5f03,	0x5f09,	0x5f5d,	0x5f5c,	0x5f0b,	0x5f11,	0x5f16,	0x5f29,
	/* 55 25 */
	0x5f2d,	0x5f38,	0x5f41,	0x5f48,	0x5f4c,	0x5f4e,	0x5f2f,	0x5f51,
	/* 55 33 */
	0x5f56,	0x5f57,	0x5f59,	0x5f61,	0x5f6d,	0x5f73,	0x5f77,	0x5f83,
	/* 55 41 */
	0x5f82,	0x5f7f,	0x5f8a,	0x5f88,	0x5f91,	0x5f87,	0x5f9e,	0x5f99,
	/* 55 49 */
	0x5f98,	0x5fa0,	0x5fa8,	0x5fad,	0x5fbc,	0x5fd6,	0x5ffb,	0x5fe4,
	/* 55 57 */
	0x5ff8,	0x5ff1,	0x5fdd,	0x60b3,	0x5fff,	0x6021,	0x6060,	0x6019,
	/* 55 65 */
	0x6010,	0x6029,	0x600e,	0x6031,	0x601b,	0x6015,	0x602b,	0x6026,
	/* 55 73 */
	0x600f,	0x603a,	0x605a,	0x6041,	0x606a,	0x6077,	0x605f,	0x604a,
	/* 55 81 */
	0x6046,	0x604d,	0x6063,	0x6043,	0x6064,	0x6042,	0x606c,	0x606b,
	/* 55 89 */
	0x6059,	0x6081,	0x608d,	0x60e7,	0x6083,	0x609a,
	/* 56 01 */
	0x6084,	0x609b,	0x6096,	0x6097,	0x6092,	0x60a7,	0x608b,	0x60e1,
	/* 56 09 */
	0x60b8,	0x60e0,	0x60d3,	0x60b4,	0x5ff0,	0x60bd,	0x60c6,	0x60b5,
	/* 56 17 */
	0x60d8,	0x614d,	0x6115,	0x6106,	0x60f6,	0x60f7,	0x6100,	0x60f4,
	/* 56 25 */
	0x60fa,	0x6103,	0x6121,	0x60fb,	0x60f1,	0x610d,	0x610e,	0x6147,
	/* 56 33 */
	0x613e,	0x6128,	0x6127,	0x614a,	0x613f,	0x613c,	0x612c,	0x6134,
	/* 56 41 */
	0x613d,	0x6142,	0x6144,	0x6173,	0x6177,	0x6158,	0x6159,	0x615a,
	/* 56 49 */
	0x616b,	0x6174,	0x616f,	0x6165,	0x6171,	0x615f,	0x615d,	0x6153,
	/* 56 57 */
	0x6175,	0x6199,	0x6196,	0x6187,	0x61ac,	0x6194,	0x619a,	0x618a,
	/* 56 65 */
	0x6191,	0x61ab,	0x61ae,	0x61cc,	0x61ca,	0x61c9,	0x61f7,	0x61c8,
	/* 56 73 */
	0x61c3,	0x61c6,	0x61ba,	0x61cb,	0x7f79,	0x61cd,	0x61e6,	0x61e3,
	/* 56 81 */
	0x61f6,	0x61fa,	0x61f4,	0x61ff,	0x61fd,	0x61fc,	0x61fe,	0x6200,
	/* 56 89 */
	0x6208,	0x6209,	0x620d,	0x620c,	0x6214,	0x621b,
	/* 57 01 */
	0x621e,	0x6221,	0x622a,	0x622e,	0x6230,	0x6232,	0x6233,	0x6241,
	/* 57 09 */
	0x624e,	0x625e,	0x6263,	0x625b,	0x6260,	0x6268,	0x627c,	0x6282,
	/* 57 17 */
	0x6289,	0x627e,	0x6292,	0x6293,	0x6296,	0x62d4,	0x6283,	0x6294,
	/* 57 25 */
	0x62d7,	0x62d1,	0x62bb,	0x62cf,	0x62ff,	0x62c6,	0x64d4,	0x62c8,
	/* 57 33 */
	0x62dc,	0x62cc,	0x62ca,	0x62c2,	0x62c7,	0x629b,	0x62c9,	0x630c,
	/* 57 41 */
	0x62ee,	0x62f1,	0x6327,	0x6302,	0x6308,	0x62ef,	0x62f5,	0x6350,
	/* 57 49 */
	0x633e,	0x634d,	0x641c,	0x634f,	0x6396,	0x638e,	0x6380,	0x63ab,
	/* 57 57 */
	0x6376,	0x63a3,	0x638f,	0x6389,	0x639f,	0x63b5,	0x636b,	0x6369,
	/* 57 65 */
	0x63be,	0x63e9,	0x63c0,	0x63c6,	0x63e3,	0x63c9,	0x63d2,	0x63f6,
	/* 57 73 */
	0x63c4,	0x6416,	0x6434,	0x6406,	0x6413,	0x6426,	0x6436,	0x651d,
	/* 57 81 */
	0x6417,	0x6428,	0x640f,	0x6467,	0x646f,	0x6476,	0x644e,	0x652a,
	/* 57 89 */
	0x6495,	0x6493,	0x64a5,	0x64a9,	0x6488,	0x64bc,
	/* 58 01 */
	0x64da,	0x64d2,	0x64c5,	0x64c7,	0x64bb,	0x64d8,	0x64c2,	0x64f1,
	/* 58 09 */
	0x64e7,	0x8209,	0x64e0,	0x64e1,	0x62ac,	0x64e3,	0x64ef,	0x652c,
	/* 58 17 */
	0x64f6,	0x64f4,	0x64f2,	0x64fa,	0x6500,	0x64fd,	0x6518,	0x651c,
	/* 58 25 */
	0x6505,	0x6524,	0x6523,	0x652b,	0x6534,	0x6535,	0x6537,	0x6536,
	/* 58 33 */
	0x6538,	0x754b,	0x6548,	0x6556,	0x6555,	0x654d,	0x6558,	0x655e,
	/* 58 41 */
	0x655d,	0x6572,	0x6578,	0x6582,	0x6583,	0x8b8a,	0x659b,	0x659f,
	/* 58 49 */
	0x65ab,	0x65b7,	0x65c3,	0x65c6,	0x65c1,	0x65c4,	0x65cc,	0x65d2,
	/* 58 57 */
	0x65db,	0x65d9,	0x65e0,	0x65e1,	0x65f1,	0x6772,	0x660a,	0x6603,
	/* 58 65 */
	0x65fb,	0x6773,	0x6635,	0x6636,	0x6634,	0x661c,	0x664f,	0x6644,
	/* 58 73 */
	0x6649,	0x6641,	0x665e,	0x665d,	0x6664,	0x6667,	0x6668,	0x665f,
	/* 58 81 */
	0x6662,	0x6670,	0x6683,	0x6688,	0x668e,	0x6689,	0x6684,	0x6698,
	/* 58 89 */
	0x669d,	0x66c1,	0x66b9,	0x66c9,	0x66be,	0x66bc,
	/* 59 01 */
	0x66c4,	0x66b8,	0x66d6,	0x66da,	0x66e0,	0x663f,	0x66e6,	0x66e9,
	/* 59 09 */
	0x66f0,	0x66f5,	0x66f7,	0x670f,	0x6716,	0x671e,	0x6726,	0x6727,
	/* 59 17 */
	0x9738,	0x672e,	0x673f,	0x6736,	0x6741,	0x6738,	0x6737,	0x6746,
	/* 59 25 */
	0x675e,	0x6760,	0x6759,	0x6763,	0x6764,	0x6789,	0x6770,	0x67a9,
	/* 59 33 */
	0x677c,	0x676a,	0x678c,	0x678b,	0x67a6,	0x67a1,	0x6785,	0x67b7,
	/* 59 41 */
	0x67ef,	0x67b4,	0x67ec,	0x67b3,	0x67e9,	0x67b8,	0x67e4,	0x67de,
	/* 59 49 */
	0x67dd,	0x67e2,	0x67ee,	0x67b9,	0x67ce,	0x67c6,	0x67e7,	0x6a9c,
	/* 59 57 */
	0x681e,	0x6846,	0x6829,	0x6840,	0x684d,	0x6832,	0x684e,	0x68b3,
	/* 59 65 */
	0x682b,	0x6859,	0x6863,	0x6877,	0x687f,	0x689f,	0x688f,	0x68ad,
	/* 59 73 */
	0x6894,	0x689d,	0x689b,	0x6883,	0x6aae,	0x68b9,	0x6874,	0x68b5,
	/* 59 81 */
	0x68a0,	0x68ba,	0x690f,	0x688d,	0x687e,	0x6901,	0x68ca,	0x6908,
	/* 59 89 */
	0x68d8,	0x6922,	0x6926,	0x68e1,	0x690c,	0x68cd,
	/* 60 01 */
	0x68d4,	0x68e7,	0x68d5,	0x6936,	0x6912,	0x6904,	0x68d7,	0x68e3,
	/* 60 09 */
	0x6925,	0x68f9,	0x68e0,	0x68ef,	0x6928,	0x692a,	0x691a,	0x6923,
	/* 60 17 */
	0x6921,	0x68c6,	0x6979,	0x6977,	0x695c,	0x6978,	0x696b,	0x6954,
	/* 60 25 */
	0x697e,	0x696e,	0x6939,	0x6974,	0x693d,	0x6959,	0x6930,	0x6961,
	/* 60 33 */
	0x695e,	0x695d,	0x6981,	0x696a,	0x69b2,	0x69ae,	0x69d0,	0x69bf,
	/* 60 41 */
	0x69c1,	0x69d3,	0x69be,	0x69ce,	0x5be8,	0x69ca,	0x69dd,	0x69bb,
	/* 60 49 */
	0x69c3,	0x69a7,	0x6a2e,	0x6991,	0x69a0,	0x699c,	0x6995,	0x69b4,
	/* 60 57 */
	0x69de,	0x69e8,	0x6a02,	0x6a1b,	0x69ff,	0x6b0a,	0x69f9,	0x69f2,
	/* 60 65 */
	0x69e7,	0x6a05,	0x69b1,	0x6a1e,	0x69ed,	0x6a14,	0x69eb,	0x6a0a,
	/* 60 73 */
	0x6a12,	0x6ac1,	0x6a23,	0x6a13,	0x6a44,	0x6a0c,	0x6a72,	0x6a36,
	/* 60 81 */
	0x6a78,	0x6a47,	0x6a62,	0x6a59,	0x6a66,	0x6a48,	0x6a38,	0x6a22,
	/* 60 89 */
	0x6a90,	0x6a8d,	0x6aa0,	0x6a84,	0x6aa2,	0x6aa3,
	/* 61 01 */
	0x6a97,	0x8617,	0x6abb,	0x6ac3,	0x6ac2,	0x6ab8,	0x6ab3,	0x6aac,
	/* 61 09 */
	0x6ade,	0x6ad1,	0x6adf,	0x6aaa,	0x6ada,	0x6aea,	0x6afb,	0x6b05,
	/* 61 17 */
	0x8616,	0x6afa,	0x6b12,	0x6b16,	0x9b31,	0x6b1f,	0x6b38,	0x6b37,
	/* 61 25 */
	0x76dc,	0x6b39,	0x98ee,	0x6b47,	0x6b43,	0x6b49,	0x6b50,	0x6b59,
	/* 61 33 */
	0x6b54,	0x6b5b,	0x6b5f,	0x6b61,	0x6b78,	0x6b79,	0x6b7f,	0x6b80,
	/* 61 41 */
	0x6b84,	0x6b83,	0x6b8d,	0x6b98,	0x6b95,	0x6b9e,	0x6ba4,	0x6baa,
	/* 61 49 */
	0x6bab,	0x6baf,	0x6bb2,	0x6bb1,	0x6bb3,	0x6bb7,	0x6bbc,	0x6bc6,
	/* 61 57 */
	0x6bcb,	0x6bd3,	0x6bdf,	0x6bec,	0x6beb,	0x6bf3,	0x6bef,	0x9ebe,
	/* 61 65 */
	0x6c08,	0x6c13,	0x6c14,	0x6c1b,	0x6c24,	0x6c23,	0x6c5e,	0x6c55,
	/* 61 73 */
	0x6c62,	0x6c6a,	0x6c82,	0x6c8d,	0x6c9a,	0x6c81,	0x6c9b,	0x6c7e,
	/* 61 81 */
	0x6c68,	0x6c73,	0x6c92,	0x6c90,	0x6cc4,	0x6cf1,	0x6cd3,	0x6cbd,
	/* 61 89 */
	0x6cd7,	0x6cc5,	0x6cdd,	0x6cae,	0x6cb1,	0x6cbe,
	/* 62 01 */
	0x6cba,	0x6cdb,	0x6cef,	0x6cd9,	0x6cea,	0x6d1f,	0x884d,	0x6d36,
	/* 62 09 */
	0x6d2b,	0x6d3d,	0x6d38,	0x6d19,	0x6d35,	0x6d33,	0x6d12,	0x6d0c,
	/* 62 17 */
	0x6d63,	0x6d93,	0x6d64,	0x6d5a,	0x6d79,	0x6d59,	0x6d8e,	0x6d95,
	/* 62 25 */
	0x6fe4,	0x6d85,	0x6df9,	0x6e15,	0x6e0a,	0x6db5,	0x6dc7,	0x6de6,
	/* 62 33 */
	0x6db8,	0x6dc6,	0x6dec,	0x6dde,	0x6dcc,	0x6de8,	0x6dd2,	0x6dc5,
	/* 62 41 */
	0x6dfa,	0x6dd9,	0x6de4,	0x6dd5,	0x6dea,	0x6dee,	0x6e2d,	0x6e6e,
	/* 62 49 */
	0x6e2e,	0x6e19,	0x6e72,	0x6e5f,	0x6e3e,	0x6e23,	0x6e6b,	0x6e2b,
	/* 62 57 */
	0x6e76,	0x6e4d,	0x6e1f,	0x6e43,	0x6e3a,	0x6e4e,	0x6e24,	0x6eff,
	/* 62 65 */
	0x6e1d,	0x6e38,	0x6e82,	0x6eaa,	0x6e98,	0x6ec9,	0x6eb7,	0x6ed3,
	/* 62 73 */
	0x6ebd,	0x6eaf,	0x6ec4,	0x6eb2,	0x6ed4,	0x6ed5,	0x6e8f,	0x6ea5,
	/* 62 81 */
	0x6ec2,	0x6e9f,	0x6f41,	0x6f11,	0x704c,	0x6eec,	0x6ef8,	0x6efe,
	/* 62 89 */
	0x6f3f,	0x6ef2,	0x6f31,	0x6eef,	0x6f32,	0x6ecc,
	/* 63 01 */
	0x6f3e,	0x6f13,	0x6ef7,	0x6f86,	0x6f7a,	0x6f78,	0x6f81,	0x6f80,
	/* 63 09 */
	0x6f6f,	0x6f5b,	0x6ff3,	0x6f6d,	0x6f82,	0x6f7c,	0x6f58,	0x6f8e,
	/* 63 17 */
	0x6f91,	0x6fc2,	0x6f66,	0x6fb3,	0x6fa3,	0x6fa1,	0x6fa4,	0x6fb9,
	/* 63 25 */
	0x6fc6,	0x6faa,	0x6fdf,	0x6fd5,	0x6fec,	0x6fd4,	0x6fd8,	0x6ff1,
	/* 63 33 */
	0x6fee,	0x6fdb,	0x7009,	0x700b,	0x6ffa,	0x7011,	0x7001,	0x700f,
	/* 63 41 */
	0x6ffe,	0x701b,	0x701a,	0x6f74,	0x701d,	0x7018,	0x701f,	0x7030,
	/* 63 49 */
	0x703e,	0x7032,	0x7051,	0x7063,	0x7099,	0x7092,	0x70af,	0x70f1,
	/* 63 57 */
	0x70ac,	0x70b8,	0x70b3,	0x70ae,	0x70df,	0x70cb,	0x70dd,	0x70d9,
	/* 63 65 */
	0x7109,	0x70fd,	0x711c,	0x7119,	0x7165,	0x7155,	0x7188,	0x7166,
	/* 63 73 */
	0x7162,	0x714c,	0x7156,	0x716c,	0x718f,	0x71fb,	0x7184,	0x7195,
	/* 63 81 */
	0x71a8,	0x71ac,	0x71d7,	0x71b9,	0x71be,	0x71d2,	0x71c9,	0x71d4,
	/* 63 89 */
	0x71ce,	0x71e0,	0x71ec,	0x71e7,	0x71f5,	0x71fc,
	/* 64 01 */
	0x71f9,	0x71ff,	0x720d,	0x7210,	0x721b,	0x7228,	0x722d,	0x722c,
	/* 64 09 */
	0x7230,	0x7232,	0x723b,	0x723c,	0x723f,	0x7240,	0x7246,	0x724b,
	/* 64 17 */
	0x7258,	0x7274,	0x727e,	0x7282,	0x7281,	0x7287,	0x7292,	0x7296,
	/* 64 25 */
	0x72a2,	0x72a7,	0x72b9,	0x72b2,	0x72c3,	0x72c6,	0x72c4,	0x72ce,
	/* 64 33 */
	0x72d2,	0x72e2,	0x72e0,	0x72e1,	0x72f9,	0x72f7,	0x500f,	0x7317,
	/* 64 41 */
	0x730a,	0x731c,	0x7316,	0x731d,	0x7334,	0x732f,	0x7329,	0x7325,
	/* 64 49 */
	0x733e,	0x734e,	0x734f,	0x9ed8,	0x7357,	0x736a,	0x7368,	0x7370,
	/* 64 57 */
	0x7378,	0x7375,	0x737b,	0x737a,	0x73c8,	0x73b3,	0x73ce,	0x73bb,
	/* 64 65 */
	0x73c0,	0x73e5,	0x73ee,	0x73de,	0x74a2,	0x7405,	0x746f,	0x7425,
	/* 64 73 */
	0x73f8,	0x7432,	0x743a,	0x7455,	0x743f,	0x745f,	0x7459,	0x7441,
	/* 64 81 */
	0x745c,	0x7469,	0x7470,	0x7463,	0x746a,	0x7476,	0x747e,	0x748b,
	/* 64 89 */
	0x749e,	0x74a7,	0x74ca,	0x74cf,	0x74d4,	0x73f1,
	/* 65 01 */
	0x74e0,	0x74e3,	0x74e7,	0x74e9,	0x74ee,	0x74f2,	0x74f0,	0x74f1,
	/* 65 09 */
	0x74f8,	0x74f7,	0x7504,	0x7503,	0x7505,	0x750c,	0x750e,	0x750d,
	/* 65 17 */
	0x7515,	0x7513,	0x751e,	0x7526,	0x752c,	0x753c,	0x7544,	0x754d,
	/* 65 25 */
	0x754a,	0x7549,	0x755b,	0x7546,	0x755a,	0x7569,	0x7564,	0x7567,
	/* 65 33 */
	0x756b,	0x756d,	0x7578,	0x7576,	0x7586,	0x7587,	0x7574,	0x758a,
	/* 65 41 */
	0x7589,	0x7582,	0x7594,	0x759a,	0x759d,	0x75a5,	0x75a3,	0x75c2,
	/* 65 49 */
	0x75b3,	0x75c3,	0x75b5,	0x75bd,	0x75b8,	0x75bc,	0x75b1,	0x75cd,
	/* 65 57 */
	0x75ca,	0x75d2,	0x75d9,	0x75e3,	0x75de,	0x75fe,	0x75ff,	0x75fc,
	/* 65 65 */
	0x7601,	0x75f0,	0x75fa,	0x75f2,	0x75f3,	0x760b,	0x760d,	0x7609,
	/* 65 73 */
	0x761f,	0x7627,	0x7620,	0x7621,	0x7622,	0x7624,	0x7634,	0x7630,
	/* 65 81 */
	0x763b,	0x7647,	0x7648,	0x7646,	0x765c,	0x7658,	0x7661,	0x7662,
	/* 65 89 */
	0x7668,	0x7669,	0x766a,	0x7667,	0x766c,	0x7670,
	/* 66 01 */
	0x7672,	0x7676,	0x7678,	0x767c,	0x7680,	0x7683,	0x7688,	0x768b,
	/* 66 09 */
	0x768e,	0x7696,	0x7693,	0x7699,	0x769a,	0x76b0,	0x76b4,	0x76b8,
	/* 66 17 */
	0x76b9,	0x76ba,	0x76c2,	0x76cd,	0x76d6,	0x76d2,	0x76de,	0x76e1,
	/* 66 25 */
	0x76e5,	0x76e7,	0x76ea,	0x862f,	0x76fb,	0x7708,	0x7707,	0x7704,
	/* 66 33 */
	0x7729,	0x7724,	0x771e,	0x7725,	0x7726,	0x771b,	0x7737,	0x7738,
	/* 66 41 */
	0x7747,	0x775a,	0x7768,	0x776b,	0x775b,	0x7765,	0x777f,	0x777e,
	/* 66 49 */
	0x7779,	0x778e,	0x778b,	0x7791,	0x77a0,	0x779e,	0x77b0,	0x77b6,
	/* 66 57 */
	0x77b9,	0x77bf,	0x77bc,	0x77bd,	0x77bb,	0x77c7,	0x77cd,	0x77d7,
	/* 66 65 */
	0x77da,	0x77dc,	0x77e3,	0x77ee,	0x77fc,	0x780c,	0x7812,	0x7926,
	/* 66 73 */
	0x7820,	0x792a,	0x7845,	0x788e,	0x7874,	0x7886,	0x787c,	0x789a,
	/* 66 81 */
	0x788c,	0x78a3,	0x78b5,	0x78aa,	0x78af,	0x78d1,	0x78c6,	0x78cb,
	/* 66 89 */
	0x78d4,	0x78be,	0x78bc,	0x78c5,	0x78ca,	0x78ec,
	/* 67 01 */
	0x78e7,	0x78da,	0x78fd,	0x78f4,	0x7907,	0x7912,	0x7911,	0x7919,
	/* 67 09 */
	0x792c,	0x792b,	0x7940,	0x7960,	0x7957,	0x795f,	0x795a,	0x7955,
	/* 67 17 */
	0x7953,	0x797a,	0x797f,	0x798a,	0x799d,	0x79a7,	0x9f4b,	0x79aa,
	/* 67 25 */
	0x79ae,	0x79b3,	0x79b9,	0x79ba,	0x79c9,	0x79d5,	0x79e7,	0x79ec,
	/* 67 33 */
	0x79e1,	0x79e3,	0x7a08,	0x7a0d,	0x7a18,	0x7a19,	0x7a20,	0x7a1f,
	/* 67 41 */
	0x7980,	0x7a31,	0x7a3b,	0x7a3e,	0x7a37,	0x7a43,	0x7a57,	0x7a49,
	/* 67 49 */
	0x7a61,	0x7a62,	0x7a69,	0x9f9d,	0x7a70,	0x7a79,	0x7a7d,	0x7a88,
	/* 67 57 */
	0x7a97,	0x7a95,	0x7a98,	0x7a96,	0x7aa9,	0x7ac8,	0x7ab0,	0x7ab6,
	/* 67 65 */
	0x7ac5,	0x7ac4,	0x7abf,	0x9083,	0x7ac7,	0x7aca,	0x7acd,	0x7acf,
	/* 67 73 */
	0x7ad5,	0x7ad3,	0x7ad9,	0x7ada,	0x7add,	0x7ae1,	0x7ae2,	0x7ae6,
	/* 67 81 */
	0x7aed,	0x7af0,	0x7b02,	0x7b0f,	0x7b0a,	0x7b06,	0x7b33,	0x7b18,
	/* 67 89 */
	0x7b19,	0x7b1e,	0x7b35,	0x7b28,	0x7b36,	0x7b50,
	/* 68 01 */
	0x7b7a,	0x7b04,	0x7b4d,	0x7b0b,	0x7b4c,	0x7b45,	0x7b75,	0x7b65,
	/* 68 09 */
	0x7b74,	0x7b67,	0x7b70,	0x7b71,	0x7b6c,	0x7b6e,	0x7b9d,	0x7b98,
	/* 68 17 */
	0x7b9f,	0x7b8d,	0x7b9c,	0x7b9a,	0x7b8b,	0x7b92,	0x7b8f,	0x7b5d,
	/* 68 25 */
	0x7b99,	0x7bcb,	0x7bc1,	0x7bcc,	0x7bcf,	0x7bb4,	0x7bc6,	0x7bdd,
	/* 68 33 */
	0x7be9,	0x7c11,	0x7c14,	0x7be6,	0x7be5,	0x7c60,	0x7c00,	0x7c07,
	/* 68 41 */
	0x7c13,	0x7bf3,	0x7bf7,	0x7c17,	0x7c0d,	0x7bf6,	0x7c23,	0x7c27,
	/* 68 49 */
	0x7c2a,	0x7c1f,	0x7c37,	0x7c2b,	0x7c3d,	0x7c4c,	0x7c43,	0x7c54,
	/* 68 57 */
	0x7c4f,	0x7c40,	0x7c50,	0x7c58,	0x7c5f,	0x7c64,	0x7c56,	0x7c65,
	/* 68 65 */
	0x7c6c,	0x7c75,	0x7c83,	0x7c90,	0x7ca4,	0x7cad,	0x7ca2,	0x7cab,
	/* 68 73 */
	0x7ca1,	0x7ca8,	0x7cb3,	0x7cb2,	0x7cb1,	0x7cae,	0x7cb9,	0x7cbd,
	/* 68 81 */
	0x7cc0,	0x7cc5,	0x7cc2,	0x7cd8,	0x7cd2,	0x7cdc,	0x7ce2,	0x9b3b,
	/* 68 89 */
	0x7cef,	0x7cf2,	0x7cf4,	0x7cf6,	0x7cfa,	0x7d06,
	/* 69 01 */
	0x7d02,	0x7d1c,	0x7d15,	0x7d0a,	0x7d45,	0x7d4b,	0x7d2e,	0x7d32,
	/* 69 09 */
	0x7d3f,	0x7d35,	0x7d46,	0x7d73,	0x7d56,	0x7d4e,	0x7d72,	0x7d68,
	/* 69 17 */
	0x7d6e,	0x7d4f,	0x7d63,	0x7d93,	0x7d89,	0x7d5b,	0x7d8f,	0x7d7d,
	/* 69 25 */
	0x7d9b,	0x7dba,	0x7dae,	0x7da3,	0x7db5,	0x7dc7,	0x7dbd,	0x7dab,
	/* 69 33 */
	0x7e3d,	0x7da2,	0x7daf,	0x7ddc,	0x7db8,	0x7d9f,	0x7db0,	0x7dd8,
	/* 69 41 */
	0x7ddd,	0x7de4,	0x7dde,	0x7dfb,	0x7df2,	0x7de1,	0x7e05,	0x7e0a,
	/* 69 49 */
	0x7e23,	0x7e21,	0x7e12,	0x7e31,	0x7e1f,	0x7e09,	0x7e0b,	0x7e22,
	/* 69 57 */
	0x7e46,	0x7e66,	0x7e3b,	0x7e35,	0x7e39,	0x7e43,	0x7e37,	0x7e32,
	/* 69 65 */
	0x7e3a,	0x7e67,	0x7e5d,	0x7e56,	0x7e5e,	0x7e59,	0x7e5a,	0x7e79,
	/* 69 73 */
	0x7e6a,	0x7e69,	0x7e7c,	0x7e7b,	0x7e83,	0x7dd5,	0x7e7d,	0x8fae,
	/* 69 81 */
	0x7e7f,	0x7e88,	0x7e89,	0x7e8c,	0x7e92,	0x7e90,	0x7e93,	0x7e94,
	/* 69 89 */
	0x7e96,	0x7e8e,	0x7e9b,	0x7e9c,	0x7f38,	0x7f3a,
	/* 70 01 */
	0x7f45,	0x7f4c,	0x7f4d,	0x7f4e,	0x7f50,	0x7f51,	0x7f55,	0x7f54,
	/* 70 09 */
	0x7f58,	0x7f5f,	0x7f60,	0x7f68,	0x7f69,	0x7f67,	0x7f78,	0x7f82,
	/* 70 17 */
	0x7f86,	0x7f83,	0x7f88,	0x7f87,	0x7f8c,	0x7f94,	0x7f9e,	0x7f9d,
	/* 70 25 */
	0x7f9a,	0x7fa3,	0x7faf,	0x7fb2,	0x7fb9,	0x7fae,	0x7fb6,	0x7fb8,
	/* 70 33 */
	0x8b71,	0x7fc5,	0x7fc6,	0x7fca,	0x7fd5,	0x7fd4,	0x7fe1,	0x7fe6,
	/* 70 41 */
	0x7fe9,	0x7ff3,	0x7ff9,	0x98dc,	0x8006,	0x8004,	0x800b,	0x8012,
	/* 70 49 */
	0x8018,	0x8019,	0x801c,	0x8021,	0x8028,	0x803f,	0x803b,	0x804a,
	/* 70 57 */
	0x8046,	0x8052,	0x8058,	0x805a,	0x805f,	0x8062,	0x8068,	0x8073,
	/* 70 65 */
	0x8072,	0x8070,	0x8076,	0x8079,	0x807d,	0x807f,	0x8084,	0x8086,
	/* 70 73 */
	0x8085,	0x809b,	0x8093,	0x809a,	0x80ad,	0x5190,	0x80ac,	0x80db,
	/* 70 81 */
	0x80e5,	0x80d9,	0x80dd,	0x80c4,	0x80da,	0x80d6,	0x8109,	0x80ef,
	/* 70 89 */
	0x80f1,	0x811b,	0x8129,	0x8123,	0x812f,	0x814b,
	/* 71 01 */
	0x968b,	0x8146,	0x813e,	0x8153,	0x8151,	0x80fc,	0x8171,	0x816e,
	/* 71 09 */
	0x8165,	0x8166,	0x8174,	0x8183,	0x8188,	0x818a,	0x8180,	0x8182,
	/* 71 17 */
	0x81a0,	0x8195,	0x81a4,	0x81a3,	0x815f,	0x8193,	0x81a9,	0x81b0,
	/* 71 25 */
	0x81b5,	0x81be,	0x81b8,	0x81bd,	0x81c0,	0x81c2,	0x81ba,	0x81c9,
	/* 71 33 */
	0x81cd,	0x81d1,	0x81d9,	0x81d8,	0x81c8,	0x81da,	0x81df,	0x81e0,
	/* 71 41 */
	0x81e7,	0x81fa,	0x81fb,	0x81fe,	0x8201,	0x8202,	0x8205,	0x8207,
	/* 71 49 */
	0x820a,	0x820d,	0x8210,	0x8216,	0x8229,	0x822b,	0x8238,	0x8233,
	/* 71 57 */
	0x8240,	0x8259,	0x8258,	0x825d,	0x825a,	0x825f,	0x8264,	0x8262,
	/* 71 65 */
	0x8268,	0x826a,	0x826b,	0x822e,	0x8271,	0x8277,	0x8278,	0x827e,
	/* 71 73 */
	0x828d,	0x8292,	0x82ab,	0x829f,	0x82bb,	0x82ac,	0x82e1,	0x82e3,
	/* 71 81 */
	0x82df,	0x82d2,	0x82f4,	0x82f3,	0x82fa,	0x8393,	0x8303,	0x82fb,
	/* 71 89 */
	0x82f9,	0x82de,	0x8306,	0x82dc,	0x8309,	0x82d9,
	/* 72 01 */
	0x8335,	0x8334,	0x8316,	0x8332,	0x8331,	0x8340,	0x8339,	0x8350,
	/* 72 09 */
	0x8345,	0x832f,	0x832b,	0x8317,	0x8318,	0x8385,	0x839a,	0x83aa,
	/* 72 17 */
	0x839f,	0x83a2,	0x8396,	0x8323,	0x838e,	0x8387,	0x838a,	0x837c,
	/* 72 25 */
	0x83b5,	0x8373,	0x8375,	0x83a0,	0x8389,	0x83a8,	0x83f4,	0x8413,
	/* 72 33 */
	0x83eb,	0x83ce,	0x83fd,	0x8403,	0x83d8,	0x840b,	0x83c1,	0x83f7,
	/* 72 41 */
	0x8407,	0x83e0,	0x83f2,	0x840d,	0x8422,	0x8420,	0x83bd,	0x8438,
	/* 72 49 */
	0x8506,	0x83fb,	0x846d,	0x842a,	0x843c,	0x855a,	0x8484,	0x8477,
	/* 72 57 */
	0x846b,	0x84ad,	0x846e,	0x8482,	0x8469,	0x8446,	0x842c,	0x846f,
	/* 72 65 */
	0x8479,	0x8435,	0x84ca,	0x8462,	0x84b9,	0x84bf,	0x849f,	0x84d9,
	/* 72 73 */
	0x84cd,	0x84bb,	0x84da,	0x84d0,	0x84c1,	0x84c6,	0x84d6,	0x84a1,
	/* 72 81 */
	0x8521,	0x84ff,	0x84f4,	0x8517,	0x8518,	0x852c,	0x851f,	0x8515,
	/* 72 89 */
	0x8514,	0x84fc,	0x8540,	0x8563,	0x8558,	0x8548,
	/* 73 01 */
	0x8541,	0x8602,	0x854b,	0x8555,	0x8580,	0x85a4,	0x8588,	0x8591,
	/* 73 09 */
	0x858a,	0x85a8,	0x856d,	0x8594,	0x859b,	0x85ea,	0x8587,	0x859c,
	/* 73 17 */
	0x8577,	0x857e,	0x8590,	0x85c9,	0x85ba,	0x85cf,	0x85b9,	0x85d0,
	/* 73 25 */
	0x85d5,	0x85dd,	0x85e5,	0x85dc,	0x85f9,	0x860a,	0x8613,	0x860b,
	/* 73 33 */
	0x85fe,	0x85fa,	0x8606,	0x8622,	0x861a,	0x8630,	0x863f,	0x864d,
	/* 73 41 */
	0x4e55,	0x8654,	0x865f,	0x8667,	0x8671,	0x8693,	0x86a3,	0x86a9,
	/* 73 49 */
	0x86aa,	0x868b,	0x868c,	0x86b6,	0x86af,	0x86c4,	0x86c6,	0x86b0,
	/* 73 57 */
	0x86c9,	0x8823,	0x86ab,	0x86d4,	0x86de,	0x86e9,	0x86ec,	0x86df,
	/* 73 65 */
	0x86db,	0x86ef,	0x8712,	0x8706,	0x8708,	0x8700,	0x8703,	0x86fb,
	/* 73 73 */
	0x8711,	0x8709,	0x870d,	0x86f9,	0x870a,	0x8734,	0x873f,	0x8737,
	/* 73 81 */
	0x873b,	0x8725,	0x8729,	0x871a,	0x8760,	0x875f,	0x8778,	0x874c,
	/* 73 89 */
	0x874e,	0x8774,	0x8757,	0x8768,	0x876e,	0x8759,
	/* 74 01 */
	0x8753,	0x8763,	0x876a,	0x8805,	0x87a2,	0x879f,	0x8782,	0x87af,
	/* 74 09 */
	0x87cb,	0x87bd,	0x87c0,	0x87d0,	0x96d6,	0x87ab,	0x87c4,	0x87b3,
	/* 74 17 */
	0x87c7,	0x87c6,	0x87bb,	0x87ef,	0x87f2,	0x87e0,	0x880f,	0x880d,
	/* 74 25 */
	0x87fe,	0x87f6,	0x87f7,	0x880e,	0x87d2,	0x8811,	0x8816,	0x8815,
	/* 74 33 */
	0x8822,	0x8821,	0x8831,	0x8836,	0x8839,	0x8827,	0x883b,	0x8844,
	/* 74 41 */
	0x8842,	0x8852,	0x8859,	0x885e,	0x8862,	0x886b,	0x8881,	0x887e,
	/* 74 49 */
	0x889e,	0x8875,	0x887d,	0x88b5,	0x8872,	0x8882,	0x8897,	0x8892,
	/* 74 57 */
	0x88ae,	0x8899,	0x88a2,	0x888d,	0x88a4,	0x88b0,	0x88bf,	0x88b1,
	/* 74 65 */
	0x88c3,	0x88c4,	0x88d4,	0x88d8,	0x88d9,	0x88dd,	0x88f9,	0x8902,
	/* 74 73 */
	0x88fc,	0x88f4,	0x88e8,	0x88f2,	0x8904,	0x890c,	0x890a,	0x8913,
	/* 74 81 */
	0x8943,	0x891e,	0x8925,	0x892a,	0x892b,	0x8941,	0x8944,	0x893b,
	/* 74 89 */
	0x8936,	0x8938,	0x894c,	0x891d,	0x8960,	0x895e,
	/* 75 01 */
	0x8966,	0x8964,	0x896d,	0x896a,	0x896f,	0x8974,	0x8977,	0x897e,
	/* 75 09 */
	0x8983,	0x8988,	0x898a,	0x8993,	0x8998,	0x89a1,	0x89a9,	0x89a6,
	/* 75 17 */
	0x89ac,	0x89af,	0x89b2,	0x89ba,	0x89bd,	0x89bf,	0x89c0,	0x89da,
	/* 75 25 */
	0x89dc,	0x89dd,	0x89e7,	0x89f4,	0x89f8,	0x8a03,	0x8a16,	0x8a10,
	/* 75 33 */
	0x8a0c,	0x8a1b,	0x8a1d,	0x8a25,	0x8a36,	0x8a41,	0x8a5b,	0x8a52,
	/* 75 41 */
	0x8a46,	0x8a48,	0x8a7c,	0x8a6d,	0x8a6c,	0x8a62,	0x8a85,	0x8a82,
	/* 75 49 */
	0x8a84,	0x8aa8,	0x8aa1,	0x8a91,	0x8aa5,	0x8aa6,	0x8a9a,	0x8aa3,
	/* 75 57 */
	0x8ac4,	0x8acd,	0x8ac2,	0x8ada,	0x8aeb,	0x8af3,	0x8ae7,	0x8ae4,
	/* 75 65 */
	0x8af1,	0x8b14,	0x8ae0,	0x8ae2,	0x8af7,	0x8ade,	0x8adb,	0x8b0c,
	/* 75 73 */
	0x8b07,	0x8b1a,	0x8ae1,	0x8b16,	0x8b10,	0x8b17,	0x8b20,	0x8b33,
	/* 75 81 */
	0x97ab,	0x8b26,	0x8b2b,	0x8b3e,	0x8b28,	0x8b41,	0x8b4c,	0x8b4f,
	/* 75 89 */
	0x8b4e,	0x8b49,	0x8b56,	0x8b5b,	0x8b5a,	0x8b6b,
	/* 76 01 */
	0x8b5f,	0x8b6c,	0x8b6f,	0x8b74,	0x8b7d,	0x8b80,	0x8b8c,	0x8b8e,
	/* 76 09 */
	0x8b92,	0x8b93,	0x8b96,	0x8b99,	0x8b9a,	0x8c3a,	0x8c41,	0x8c3f,
	/* 76 17 */
	0x8c48,	0x8c4c,	0x8c4e,	0x8c50,	0x8c55,	0x8c62,	0x8c6c,	0x8c78,
	/* 76 25 */
	0x8c7a,	0x8c82,	0x8c89,	0x8c85,	0x8c8a,	0x8c8d,	0x8c8e,	0x8c94,
	/* 76 33 */
	0x8c7c,	0x8c98,	0x621d,	0x8cad,	0x8caa,	0x8cbd,	0x8cb2,	0x8cb3,
	/* 76 41 */
	0x8cae,	0x8cb6,	0x8cc8,	0x8cc1,	0x8ce4,	0x8ce3,	0x8cda,	0x8cfd,
	/* 76 49 */
	0x8cfa,	0x8cfb,	0x8d04,	0x8d05,	0x8d0a,	0x8d07,	0x8d0f,	0x8d0d,
	/* 76 57 */
	0x8d10,	0x9f4e,	0x8d13,	0x8ccd,	0x8d14,	0x8d16,	0x8d67,	0x8d6d,
	/* 76 65 */
	0x8d71,	0x8d73,	0x8d81,	0x8d99,	0x8dc2,	0x8dbe,	0x8dba,	0x8dcf,
	/* 76 73 */
	0x8dda,	0x8dd6,	0x8dcc,	0x8ddb,	0x8dcb,	0x8dea,	0x8deb,	0x8ddf,
	/* 76 81 */
	0x8de3,	0x8dfc,	0x8e08,	0x8e09,	0x8dff,	0x8e1d,	0x8e1e,	0x8e10,
	/* 76 89 */
	0x8e1f,	0x8e42,	0x8e35,	0x8e30,	0x8e34,	0x8e4a,
	/* 77 01 */
	0x8e47,	0x8e49,	0x8e4c,	0x8e50,	0x8e48,	0x8e59,	0x8e64,	0x8e60,
	/* 77 09 */
	0x8e2a,	0x8e63,	0x8e55,	0x8e76,	0x8e72,	0x8e7c,	0x8e81,	0x8e87,
	/* 77 17 */
	0x8e85,	0x8e84,	0x8e8b,	0x8e8a,	0x8e93,	0x8e91,	0x8e94,	0x8e99,
	/* 77 25 */
	0x8eaa,	0x8ea1,	0x8eac,	0x8eb0,	0x8ec6,	0x8eb1,	0x8ebe,	0x8ec5,
	/* 77 33 */
	0x8ec8,	0x8ecb,	0x8edb,	0x8ee3,	0x8efc,	0x8efb,	0x8eeb,	0x8efe,
	/* 77 41 */
	0x8f0a,	0x8f05,	0x8f15,	0x8f12,	0x8f19,	0x8f13,	0x8f1c,	0x8f1f,
	/* 77 49 */
	0x8f1b,	0x8f0c,	0x8f26,	0x8f33,	0x8f3b,	0x8f39,	0x8f45,	0x8f42,
	/* 77 57 */
	0x8f3e,	0x8f4c,	0x8f49,	0x8f46,	0x8f4e,	0x8f57,	0x8f5c,	0x8f62,
	/* 77 65 */
	0x8f63,	0x8f64,	0x8f9c,	0x8f9f,	0x8fa3,	0x8fad,	0x8faf,	0x8fb7,
	/* 77 73 */
	0x8fda,	0x8fe5,	0x8fe2,	0x8fea,	0x8fef,	0x9087,	0x8ff4,	0x9005,
	/* 77 81 */
	0x8ff9,	0x8ffa,	0x9011,	0x9015,	0x9021,	0x900d,	0x901e,	0x9016,
	/* 77 89 */
	0x900b,	0x9027,	0x9036,	0x9035,	0x9039,	0x8ff8,
	/* 78 01 */
	0x904f,	0x9050,	0x9051,	0x9052,	0x900e,	0x9049,	0x903e,	0x9056,
	/* 78 09 */
	0x9058,	0x905e,	0x9068,	0x906f,	0x9076,	0x96a8,	0x9072,	0x9082,
	/* 78 17 */
	0x907d,	0x9081,	0x9080,	0x908a,	0x9089,	0x908f,	0x90a8,	0x90af,
	/* 78 25 */
	0x90b1,	0x90b5,	0x90e2,	0x90e4,	0x6248,	0x90db,	0x9102,	0x9112,
	/* 78 33 */
	0x9119,	0x9132,	0x9130,	0x914a,	0x9156,	0x9158,	0x9163,	0x9165,
	/* 78 41 */
	0x9169,	0x9173,	0x9172,	0x918b,	0x9189,	0x9182,	0x91a2,	0x91ab,
	/* 78 49 */
	0x91af,	0x91aa,	0x91b5,	0x91b4,	0x91ba,	0x91c0,	0x91c1,	0x91c9,
	/* 78 57 */
	0x91cb,	0x91d0,	0x91d6,	0x91df,	0x91e1,	0x91db,	0x91fc,	0x91f5,
	/* 78 65 */
	0x91f6,	0x921e,	0x91ff,	0x9214,	0x922c,	0x9215,	0x9211,	0x925e,
	/* 78 73 */
	0x9257,	0x9245,	0x9249,	0x9264,	0x9248,	0x9295,	0x923f,	0x924b,
	/* 78 81 */
	0x9250,	0x929c,	0x9296,	0x9293,	0x929b,	0x925a,	0x92cf,	0x92b9,
	/* 78 89 */
	0x92b7,	0x92e9,	0x930f,	0x92fa,	0x9344,	0x932e,
	/* 79 01 */
	0x9319,	0x9322,	0x931a,	0x9323,	0x933a,	0x9335,	0x933b,	0x935c,
	/* 79 09 */
	0x9360,	0x937c,	0x936e,	0x9356,	0x93b0,	0x93ac,	0x93ad,	0x9394,
	/* 79 17 */
	0x93b9,	0x93d6,	0x93d7,	0x93e8,	0x93e5,	0x93d8,	0x93c3,	0x93dd,
	/* 79 25 */
	0x93d0,	0x93c8,	0x93e4,	0x941a,	0x9414,	0x9413,	0x9403,	0x9407,
	/* 79 33 */
	0x9410,	0x9436,	0x942b,	0x9435,	0x9421,	0x943a,	0x9441,	0x9452,
	/* 79 41 */
	0x9444,	0x945b,	0x9460,	0x9462,	0x945e,	0x946a,	0x9229,	0x9470,
	/* 79 49 */
	0x9475,	0x9477,	0x947d,	0x945a,	0x947c,	0x947e,	0x9481,	0x947f,
	/* 79 57 */
	0x9582,	0x9587,	0x958a,	0x9594,	0x9596,	0x9598,	0x9599,	0x95a0,
	/* 79 65 */
	0x95a8,	0x95a7,	0x95ad,	0x95bc,	0x95bb,	0x95b9,	0x95be,	0x95ca,
	/* 79 73 */
	0x6ff6,	0x95c3,	0x95cd,	0x95cc,	0x95d5,	0x95d4,	0x95d6,	0x95dc,
	/* 79 81 */
	0x95e1,	0x95e5,	0x95e2,	0x9621,	0x9628,	0x962e,	0x962f,	0x9642,
	/* 79 89 */
	0x964c,	0x964f,	0x964b,	0x9677,	0x965c,	0x965e,
	/* 80 01 */
	0x965d,	0x965f,	0x9666,	0x9672,	0x966c,	0x968d,	0x9698,	0x9695,
	/* 80 09 */
	0x9697,	0x96aa,	0x96a7,	0x96b1,	0x96b2,	0x96b0,	0x96b4,	0x96b6,
	/* 80 17 */
	0x96b8,	0x96b9,	0x96ce,	0x96cb,	0x96c9,	0x96cd,	0x894d,	0x96dc,
	/* 80 25 */
	0x970d,	0x96d5,	0x96f9,	0x9704,	0x9706,	0x9708,	0x9713,	0x970e,
	/* 80 33 */
	0x9711,	0x970f,	0x9716,	0x9719,	0x9724,	0x972a,	0x9730,	0x9739,
	/* 80 41 */
	0x973d,	0x973e,	0x9744,	0x9746,	0x9748,	0x9742,	0x9749,	0x975c,
	/* 80 49 */
	0x9760,	0x9764,	0x9766,	0x9768,	0x52d2,	0x976b,	0x9771,	0x9779,
	/* 80 57 */
	0x9785,	0x977c,	0x9781,	0x977a,	0x9786,	0x978b,	0x978f,	0x9790,
	/* 80 65 */
	0x979c,	0x97a8,	0x97a6,	0x97a3,	0x97b3,	0x97b4,	0x97c3,	0x97c6,
	/* 80 73 */
	0x97c8,	0x97cb,	0x97dc,	0x97ed,	0x9f4f,	0x97f2,	0x7adf,	0x97f6,
	/* 80 81 */
	0x97f5,	0x980f,	0x980c,	0x9838,	0x9824,	0x9821,	0x9837,	0x983d,
	/* 80 89 */
	0x9846,	0x984f,	0x984b,	0x986b,	0x986f,	0x9870,
	/* 81 01 */
	0x9871,	0x9874,	0x9873,	0x98aa,	0x98af,	0x98b1,	0x98b6,	0x98c4,
	/* 81 09 */
	0x98c3,	0x98c6,	0x98e9,	0x98eb,	0x9903,	0x9909,	0x9912,	0x9914,
	/* 81 17 */
	0x9918,	0x9921,	0x991d,	0x991e,	0x9924,	0x9920,	0x992c,	0x992e,
	/* 81 25 */
	0x993d,	0x993e,	0x9942,	0x9949,	0x9945,	0x9950,	0x994b,	0x9951,
	/* 81 33 */
	0x9952,	0x994c,	0x9955,	0x9997,	0x9998,	0x99a5,	0x99ad,	0x99ae,
	/* 81 41 */
	0x99bc,	0x99df,	0x99db,	0x99dd,	0x99d8,	0x99d1,	0x99ed,	0x99ee,
	/* 81 49 */
	0x99f1,	0x99f2,	0x99fb,	0x99f8,	0x9a01,	0x9a0f,	0x9a05,	0x99e2,
	/* 81 57 */
	0x9a19,	0x9a2b,	0x9a37,	0x9a45,	0x9a42,	0x9a40,	0x9a43,	0x9a3e,
	/* 81 65 */
	0x9a55,	0x9a4d,	0x9a5b,	0x9a57,	0x9a5f,	0x9a62,	0x9a65,	0x9a64,
	/* 81 73 */
	0x9a69,	0x9a6b,	0x9a6a,	0x9aad,	0x9ab0,	0x9abc,	0x9ac0,	0x9acf,
	/* 81 81 */
	0x9ad1,	0x9ad3,	0x9ad4,	0x9ade,	0x9adf,	0x9ae2,	0x9ae3,	0x9ae6,
	/* 81 89 */
	0x9aef,	0x9aeb,	0x9aee,	0x9af4,	0x9af1,	0x9af7,
	/* 82 01 */
	0x9afb,	0x9b06,	0x9b18,	0x9b1a,	0x9b1f,	0x9b22,	0x9b23,	0x9b25,
	/* 82 09 */
	0x9b27,	0x9b28,	0x9b29,	0x9b2a,	0x9b2e,	0x9b2f,	0x9b32,	0x9b44,
	/* 82 17 */
	0x9b43,	0x9b4f,	0x9b4d,	0x9b4e,	0x9b51,	0x9b58,	0x9b74,	0x9b93,
	/* 82 25 */
	0x9b83,	0x9b91,	0x9b96,	0x9b97,	0x9b9f,	0x9ba0,	0x9ba8,	0x9bb4,
	/* 82 33 */
	0x9bc0,	0x9bca,	0x9bb9,	0x9bc6,	0x9bcf,	0x9bd1,	0x9bd2,	0x9be3,
	/* 82 41 */
	0x9be2,	0x9be4,	0x9bd4,	0x9be1,	0x9c3a,	0x9bf2,	0x9bf1,	0x9bf0,
	/* 82 49 */
	0x9c15,	0x9c14,	0x9c09,	0x9c13,	0x9c0c,	0x9c06,	0x9c08,	0x9c12,
	/* 82 57 */
	0x9c0a,	0x9c04,	0x9c2e,	0x9c1b,	0x9c25,	0x9c24,	0x9c21,	0x9c30,
	/* 82 65 */
	0x9c47,	0x9c32,	0x9c46,	0x9c3e,	0x9c5a,	0x9c60,	0x9c67,	0x9c76,
	/* 82 73 */
	0x9c78,	0x9ce7,	0x9cec,	0x9cf0,	0x9d09,	0x9d08,	0x9ceb,	0x9d03,
	/* 82 81 */
	0x9d06,	0x9d2a,	0x9d26,	0x9daf,	0x9d23,	0x9d1f,	0x9d44,	0x9d15,
	/* 82 89 */
	0x9d12,	0x9d41,	0x9d3f,	0x9d3e,	0x9d46,	0x9d48,
	/* 83 01 */
	0x9d5d,	0x9d5e,	0x9d64,	0x9d51,	0x9d50,	0x9d59,	0x9d72,	0x9d89,
	/* 83 09 */
	0x9d87,	0x9dab,	0x9d6f,	0x9d7a,	0x9d9a,	0x9da4,	0x9da9,	0x9db2,
	/* 83 17 */
	0x9dc4,	0x9dc1,	0x9dbb,	0x9db8,	0x9dba,	0x9dc6,	0x9dcf,	0x9dc2,
	/* 83 25 */
	0x9dd9,	0x9dd3,	0x9df8,	0x9de6,	0x9ded,	0x9def,	0x9dfd,	0x9e1a,
	/* 83 33 */
	0x9e1b,	0x9e1e,	0x9e75,	0x9e79,	0x9e7d,	0x9e81,	0x9e88,	0x9e8b,
	/* 83 41 */
	0x9e8c,	0x9e92,	0x9e95,	0x9e91,	0x9e9d,	0x9ea5,	0x9ea9,	0x9eb8,
	/* 83 49 */
	0x9eaa,	0x9ead,	0x9761,	0x9ecc,	0x9ece,	0x9ecf,	0x9ed0,	0x9ed4,
	/* 83 57 */
	0x9edc,	0x9ede,	0x9edd,	0x9ee0,	0x9ee5,	0x9ee8,	0x9eef,	0x9ef4,
	/* 83 65 */
	0x9ef6,	0x9ef7,	0x9ef9,	0x9efb,	0x9efc,	0x9efd,	0x9f07,	0x9f08,
	/* 83 73 */
	0x76b7,	0x9f15,	0x9f21,	0x9f2c,	0x9f3e,	0x9f4a,	0x9f52,	0x9f54,
	/* 83 81 */
	0x9f63,	0x9f5f,	0x9f60,	0x9f61,	0x9f66,	0x9f67,	0x9f6c,	0x9f6a,
	/* 83 89 */
	0x9f77,	0x9f72,	0x9f76,	0x9f95,	0x9f9c,	0x9fa0,
	/* 84 01 */
	0x582f,	0x69c7,	0x9059,	0x7464,	0x51dc,	0x7199,	NODEST,	NODEST,
	/* 84 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 84 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 84 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 84 33 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 84 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 84 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 84 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 84 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 84 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 84 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 84 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 85 01 */
	0xe000,	0xe001,	0xe002,	0xe003,	0xe004,	0xe005,	0xe006,	0xe007,
	/* 85 09 */
	0xe008,	0xe009,	0xe00a,	0xe00b,	0xe00c,	0xe00d,	0xe00e,	0xe00f,
	/* 85 17 */
	0xe010,	0xe011,	0xe012,	0xe013,	0xe014,	0xe015,	0xe016,	0xe017,
	/* 85 25 */
	0xe018,	0xe019,	0xe01a,	0xe01b,	0xe01c,	0xe01d,	0xe01e,	0xe01f,
	/* 85 33 */
	0xe020,	0xe021,	0xe022,	0xe023,	0xe024,	0xe025,	0xe026,	0xe027,
	/* 85 41 */
	0xe028,	0xe029,	0xe02a,	0xe02b,	0xe02c,	0xe02d,	0xe02e,	0xe02f,
	/* 85 49 */
	0xe030,	0xe031,	0xe032,	0xe033,	0xe034,	0xe035,	0xe036,	0xe037,
	/* 85 57 */
	0xe038,	0xe039,	0xe03a,	0xe03b,	0xe03c,	0xe03d,	0xe03e,	0xe03f,
	/* 85 65 */
	0xe040,	0xe041,	0xe042,	0xe043,	0xe044,	0xe045,	0xe046,	0xe047,
	/* 85 73 */
	0xe048,	0xe049,	0xe04a,	0xe04b,	0xe04c,	0xe04d,	0xe04e,	0xe04f,
	/* 85 81 */
	0xe050,	0xe051,	0xe052,	0xe053,	0xe054,	0xe055,	0xe056,	0xe057,
	/* 85 89 */
	0xe058,	0xe059,	0xe05a,	0xe05b,	0xe05c,	0xe05d,
	/* 86 01 */
	0xe05e,	0xe05f,	0xe060,	0xe061,	0xe062,	0xe063,	0xe064,	0xe065,
	/* 86 09 */
	0xe066,	0xe067,	0xe068,	0xe069,	0xe06a,	0xe06b,	0xe06c,	0xe06d,
	/* 86 17 */
	0xe06e,	0xe06f,	0xe070,	0xe071,	0xe072,	0xe073,	0xe074,	0xe075,
	/* 86 25 */
	0xe076,	0xe077,	0xe078,	0xe079,	0xe07a,	0xe07b,	0xe07c,	0xe07d,
	/* 86 33 */
	0xe07e,	0xe07f,	0xe080,	0xe081,	0xe082,	0xe083,	0xe084,	0xe085,
	/* 86 41 */
	0xe086,	0xe087,	0xe088,	0xe089,	0xe08a,	0xe08b,	0xe08c,	0xe08d,
	/* 86 49 */
	0xe08e,	0xe08f,	0xe090,	0xe091,	0xe092,	0xe093,	0xe094,	0xe095,
	/* 86 57 */
	0xe096,	0xe097,	0xe098,	0xe099,	0xe09a,	0xe09b,	0xe09c,	0xe09d,
	/* 86 65 */
	0xe09e,	0xe09f,	0xe0a0,	0xe0a1,	0xe0a2,	0xe0a3,	0xe0a4,	0xe0a5,
	/* 86 73 */
	0xe0a6,	0xe0a7,	0xe0a8,	0xe0a9,	0xe0aa,	0xe0ab,	0xe0ac,	0xe0ad,
	/* 86 81 */
	0xe0ae,	0xe0af,	0xe0b0,	0xe0b1,	0xe0b2,	0xe0b3,	0xe0b4,	0xe0b5,
	/* 86 89 */
	0xe0b6,	0xe0b7,	0xe0b8,	0xe0b9,	0xe0ba,	0xe0bb,
	/* 87 01 */
	0xe0bc,	0xe0bd,	0xe0be,	0xe0bf,	0xe0c0,	0xe0c1,	0xe0c2,	0xe0c3,
	/* 87 09 */
	0xe0c4,	0xe0c5,	0xe0c6,	0xe0c7,	0xe0c8,	0xe0c9,	0xe0ca,	0xe0cb,
	/* 87 17 */
	0xe0cc,	0xe0cd,	0xe0ce,	0xe0cf,	0xe0d0,	0xe0d1,	0xe0d2,	0xe0d3,
	/* 87 25 */
	0xe0d4,	0xe0d5,	0xe0d6,	0xe0d7,	0xe0d8,	0xe0d9,	0xe0da,	0xe0db,
	/* 87 33 */
	0xe0dc,	0xe0dd,	0xe0de,	0xe0df,	0xe0e0,	0xe0e1,	0xe0e2,	0xe0e3,
	/* 87 41 */
	0xe0e4,	0xe0e5,	0xe0e6,	0xe0e7,	0xe0e8,	0xe0e9,	0xe0ea,	0xe0eb,
	/* 87 49 */
	0xe0ec,	0xe0ed,	0xe0ee,	0xe0ef,	0xe0f0,	0xe0f1,	0xe0f2,	0xe0f3,
	/* 87 57 */
	0xe0f4,	0xe0f5,	0xe0f6,	0xe0f7,	0xe0f8,	0xe0f9,	0xe0fa,	0xe0fb,
	/* 87 65 */
	0xe0fc,	0xe0fd,	0xe0fe,	0xe0ff,	0xe100,	0xe101,	0xe102,	0xe103,
	/* 87 73 */
	0xe104,	0xe105,	0xe106,	0xe107,	0xe108,	0xe109,	0xe10a,	0xe10b,
	/* 87 81 */
	0xe10c,	0xe10d,	0xe10e,	0xe10f,	0xe110,	0xe111,	0xe112,	0xe113,
	/* 87 89 */
	0xe114,	0xe115,	0xe116,	0xe117,	0xe118,	0xe119,
	/* 88 01 */
	0xe11a,	0xe11b,	0xe11c,	0xe11d,	0xe11e,	0xe11f,	0xe120,	0xe121,
	/* 88 09 */
	0xe122,	0xe123,	0xe124,	0xe125,	0xe126,	0xe127,	0xe128,	0xe129,
	/* 88 17 */
	0xe12a,	0xe12b,	0xe12c,	0xe12d,	0xe12e,	0xe12f,	0xe130,	0xe131,
	/* 88 25 */
	0xe132,	0xe133,	0xe134,	0xe135,	0xe136,	0xe137,	0xe138,	0xe139,
	/* 88 33 */
	0xe13a,	0xe13b,	0xe13c,	0xe13d,	0xe13e,	0xe13f,	0xe140,	0xe141,
	/* 88 41 */
	0xe142,	0xe143,	0xe144,	0xe145,	0xe146,	0xe147,	0xe148,	0xe149,
	/* 88 49 */
	0xe14a,	0xe14b,	0xe14c,	0xe14d,	0xe14e,	0xe14f,	0xe150,	0xe151,
	/* 88 57 */
	0xe152,	0xe153,	0xe154,	0xe155,	0xe156,	0xe157,	0xe158,	0xe159,
	/* 88 65 */
	0xe15a,	0xe15b,	0xe15c,	0xe15d,	0xe15e,	0xe15f,	0xe160,	0xe161,
	/* 88 73 */
	0xe162,	0xe163,	0xe164,	0xe165,	0xe166,	0xe167,	0xe168,	0xe169,
	/* 88 81 */
	0xe16a,	0xe16b,	0xe16c,	0xe16d,	0xe16e,	0xe16f,	0xe170,	0xe171,
	/* 88 89 */
	0xe172,	0xe173,	0xe174,	0xe175,	0xe176,	0xe177,
	/* 89 01 */
	0xe178,	0xe179,	0xe17a,	0xe17b,	0xe17c,	0xe17d,	0xe17e,	0xe17f,
	/* 89 09 */
	0xe180,	0xe181,	0xe182,	0xe183,	0xe184,	0xe185,	0xe186,	0xe187,
	/* 89 17 */
	0xe188,	0xe189,	0xe18a,	0xe18b,	0xe18c,	0xe18d,	0xe18e,	0xe18f,
	/* 89 25 */
	0xe190,	0xe191,	0xe192,	0xe193,	0xe194,	0xe195,	0xe196,	0xe197,
	/* 89 33 */
	0xe198,	0xe199,	0xe19a,	0xe19b,	0xe19c,	0xe19d,	0xe19e,	0xe19f,
	/* 89 41 */
	0xe1a0,	0xe1a1,	0xe1a2,	0xe1a3,	0xe1a4,	0xe1a5,	0xe1a6,	0xe1a7,
	/* 89 49 */
	0xe1a8,	0xe1a9,	0xe1aa,	0xe1ab,	0xe1ac,	0xe1ad,	0xe1ae,	0xe1af,
	/* 89 57 */
	0xe1b0,	0xe1b1,	0xe1b2,	0xe1b3,	0xe1b4,	0xe1b5,	0xe1b6,	0xe1b7,
	/* 89 65 */
	0xe1b8,	0xe1b9,	0xe1ba,	0xe1bb,	0xe1bc,	0xe1bd,	0xe1be,	0xe1bf,
	/* 89 73 */
	0xe1c0,	0xe1c1,	0xe1c2,	0xe1c3,	0xe1c4,	0xe1c5,	0xe1c6,	0xe1c7,
	/* 89 81 */
	0xe1c8,	0xe1c9,	0xe1ca,	0xe1cb,	0xe1cc,	0xe1cd,	0xe1ce,	0xe1cf,
	/* 89 89 */
	0xe1d0,	0xe1d1,	0xe1d2,	0xe1d3,	0xe1d4,	0xe1d5,
	/* 90 01 */
	0xe1d6,	0xe1d7,	0xe1d8,	0xe1d9,	0xe1da,	0xe1db,	0xe1dc,	0xe1dd,
	/* 90 09 */
	0xe1de,	0xe1df,	0xe1e0,	0xe1e1,	0xe1e2,	0xe1e3,	0xe1e4,	0xe1e5,
	/* 90 17 */
	0xe1e6,	0xe1e7,	0xe1e8,	0xe1e9,	0xe1ea,	0xe1eb,	0xe1ec,	0xe1ed,
	/* 90 25 */
	0xe1ee,	0xe1ef,	0xe1f0,	0xe1f1,	0xe1f2,	0xe1f3,	0xe1f4,	0xe1f5,
	/* 90 33 */
	0xe1f6,	0xe1f7,	0xe1f8,	0xe1f9,	0xe1fa,	0xe1fb,	0xe1fc,	0xe1fd,
	/* 90 41 */
	0xe1fe,	0xe1ff,	0xe200,	0xe201,	0xe202,	0xe203,	0xe204,	0xe205,
	/* 90 49 */
	0xe206,	0xe207,	0xe208,	0xe209,	0xe20a,	0xe20b,	0xe20c,	0xe20d,
	/* 90 57 */
	0xe20e,	0xe20f,	0xe210,	0xe211,	0xe212,	0xe213,	0xe214,	0xe215,
	/* 90 65 */
	0xe216,	0xe217,	0xe218,	0xe219,	0xe21a,	0xe21b,	0xe21c,	0xe21d,
	/* 90 73 */
	0xe21e,	0xe21f,	0xe220,	0xe221,	0xe222,	0xe223,	0xe224,	0xe225,
	/* 90 81 */
	0xe226,	0xe227,	0xe228,	0xe229,	0xe22a,	0xe22b,	0xe22c,	0xe22d,
	/* 90 89 */
	0xe22e,	0xe22f,	0xe230,	0xe231,	0xe232,	0xe233,
	/* 91 01 */
	0xe234,	0xe235,	0xe236,	0xe237,	0xe238,	0xe239,	0xe23a,	0xe23b,
	/* 91 09 */
	0xe23c,	0xe23d,	0xe23e,	0xe23f,	0xe240,	0xe241,	0xe242,	0xe243,
	/* 91 17 */
	0xe244,	0xe245,	0xe246,	0xe247,	0xe248,	0xe249,	0xe24a,	0xe24b,
	/* 91 25 */
	0xe24c,	0xe24d,	0xe24e,	0xe24f,	0xe250,	0xe251,	0xe252,	0xe253,
	/* 91 33 */
	0xe254,	0xe255,	0xe256,	0xe257,	0xe258,	0xe259,	0xe25a,	0xe25b,
	/* 91 41 */
	0xe25c,	0xe25d,	0xe25e,	0xe25f,	0xe260,	0xe261,	0xe262,	0xe263,
	/* 91 49 */
	0xe264,	0xe265,	0xe266,	0xe267,	0xe268,	0xe269,	0xe26a,	0xe26b,
	/* 91 57 */
	0xe26c,	0xe26d,	0xe26e,	0xe26f,	0xe270,	0xe271,	0xe272,	0xe273,
	/* 91 65 */
	0xe274,	0xe275,	0xe276,	0xe277,	0xe278,	0xe279,	0xe27a,	0xe27b,
	/* 91 73 */
	0xe27c,	0xe27d,	0xe27e,	0xe27f,	0xe280,	0xe281,	0xe282,	0xe283,
	/* 91 81 */
	0xe284,	0xe285,	0xe286,	0xe287,	0xe288,	0xe289,	0xe28a,	0xe28b,
	/* 91 89 */
	0xe28c,	0xe28d,	0xe28e,	0xe28f,	0xe290,	0xe291,
	/* 92 01 */
	0xe292,	0xe293,	0xe294,	0xe295,	0xe296,	0xe297,	0xe298,	0xe299,
	/* 92 09 */
	0xe29a,	0xe29b,	0xe29c,	0xe29d,	0xe29e,	0xe29f,	0xe2a0,	0xe2a1,
	/* 92 17 */
	0xe2a2,	0xe2a3,	0xe2a4,	0xe2a5,	0xe2a6,	0xe2a7,	0xe2a8,	0xe2a9,
	/* 92 25 */
	0xe2aa,	0xe2ab,	0xe2ac,	0xe2ad,	0xe2ae,	0xe2af,	0xe2b0,	0xe2b1,
	/* 92 33 */
	0xe2b2,	0xe2b3,	0xe2b4,	0xe2b5,	0xe2b6,	0xe2b7,	0xe2b8,	0xe2b9,
	/* 92 41 */
	0xe2ba,	0xe2bb,	0xe2bc,	0xe2bd,	0xe2be,	0xe2bf,	0xe2c0,	0xe2c1,
	/* 92 49 */
	0xe2c2,	0xe2c3,	0xe2c4,	0xe2c5,	0xe2c6,	0xe2c7,	0xe2c8,	0xe2c9,
	/* 92 57 */
	0xe2ca,	0xe2cb,	0xe2cc,	0xe2cd,	0xe2ce,	0xe2cf,	0xe2d0,	0xe2d1,
	/* 92 65 */
	0xe2d2,	0xe2d3,	0xe2d4,	0xe2d5,	0xe2d6,	0xe2d7,	0xe2d8,	0xe2d9,
	/* 92 73 */
	0xe2da,	0xe2db,	0xe2dc,	0xe2dd,	0xe2de,	0xe2df,	0xe2e0,	0xe2e1,
	/* 92 81 */
	0xe2e2,	0xe2e3,	0xe2e4,	0xe2e5,	0xe2e6,	0xe2e7,	0xe2e8,	0xe2e9,
	/* 92 89 */
	0xe2ea,	0xe2eb,	0xe2ec,	0xe2ed,	0xe2ee,	0xe2ef,
	/* 93 01 */
	0xe2f0,	0xe2f1,	0xe2f2,	0xe2f3,	0xe2f4,	0xe2f5,	0xe2f6,	0xe2f7,
	/* 93 09 */
	0xe2f8,	0xe2f9,	0xe2fa,	0xe2fb,	0xe2fc,	0xe2fd,	0xe2fe,	0xe2ff,
	/* 93 17 */
	0xe300,	0xe301,	0xe302,	0xe303,	0xe304,	0xe305,	0xe306,	0xe307,
	/* 93 25 */
	0xe308,	0xe309,	0xe30a,	0xe30b,	0xe30c,	0xe30d,	0xe30e,	0xe30f,
	/* 93 33 */
	0xe310,	0xe311,	0xe312,	0xe313,	0xe314,	0xe315,	0xe316,	0xe317,
	/* 93 41 */
	0xe318,	0xe319,	0xe31a,	0xe31b,	0xe31c,	0xe31d,	0xe31e,	0xe31f,
	/* 93 49 */
	0xe320,	0xe321,	0xe322,	0xe323,	0xe324,	0xe325,	0xe326,	0xe327,
	/* 93 57 */
	0xe328,	0xe329,	0xe32a,	0xe32b,	0xe32c,	0xe32d,	0xe32e,	0xe32f,
	/* 93 65 */
	0xe330,	0xe331,	0xe332,	0xe333,	0xe334,	0xe335,	0xe336,	0xe337,
	/* 93 73 */
	0xe338,	0xe339,	0xe33a,	0xe33b,	0xe33c,	0xe33d,	0xe33e,	0xe33f,
	/* 93 81 */
	0xe340,	0xe341,	0xe342,	0xe343,	0xe344,	0xe345,	0xe346,	0xe347,
	/* 93 89 */
	0xe348,	0xe349,	0xe34a,	0xe34b,	0xe34c,	0xe34d,
	/* 94 01 */
	0xe34e,	0xe34f,	0xe350,	0xe351,	0xe352,	0xe353,	0xe354,	0xe355,
	/* 94 09 */
	0xe356,	0xe357,	0xe358,	0xe359,	0xe35a,	0xe35b,	0xe35c,	0xe35d,
	/* 94 17 */
	0xe35e,	0xe35f,	0xe360,	0xe361,	0xe362,	0xe363,	0xe364,	0xe365,
	/* 94 25 */
	0xe366,	0xe367,	0xe368,	0xe369,	0xe36a,	0xe36b,	0xe36c,	0xe36d,
	/* 94 33 */
	0xe36e,	0xe36f,	0xe370,	0xe371,	0xe372,	0xe373,	0xe374,	0xe375,
	/* 94 41 */
	0xe376,	0xe377,	0xe378,	0xe379,	0xe37a,	0xe37b,	0xe37c,	0xe37d,
	/* 94 49 */
	0xe37e,	0xe37f,	0xe380,	0xe381,	0xe382,	0xe383,	0xe384,	0xe385,
	/* 94 57 */
	0xe386,	0xe387,	0xe388,	0xe389,	0xe38a,	0xe38b,	0xe38c,	0xe38d,
	/* 94 65 */
	0xe38e,	0xe38f,	0xe390,	0xe391,	0xe392,	0xe393,	0xe394,	0xe395,
	/* 94 73 */
	0xe396,	0xe397,	0xe398,	0xe399,	0xe39a,	0xe39b,	0xe39c,	0xe39d,
	/* 94 81 */
	0xe39e,	0xe39f,	0xe3a0,	0xe3a1,	0xe3a2,	0xe3a3,	0xe3a4,	0xe3a5,
	/* 94 89 */
	0xe3a6,	0xe3a7,	0xe3a8,	0xe3a9,	0xe3aa,	0xe3ab,
};
static const kiconv_ja_ucs2_t kiconv_ja_jisx0212_to_ucs2[] = {
	/* 01 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 01 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 01 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 01 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 01 33 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 01 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 01 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 01 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 01 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 01 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 01 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 01 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 02 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 02 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	0x02d8,	0x02c7,
	/* 02 17 */
	0x00b8,	0x02d9,	0x02dd,	0x00af,	0x02db,	0x02da,	0xff5e,	0x0384,
	/* 02 25 */
	0x0385,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 02 33 */
	NODEST,	0x00a1,	0x00a6,	0x00bf,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 02 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 02 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 02 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 02 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 02 73 */
	NODEST,	NODEST,	0x00ba,	0x00aa,	0x00a9,	0x00ae,	0x2122,	0x00a4,
	/* 02 81 */
	0x2116,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 02 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 03 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 03 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 03 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 03 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 03 33 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 03 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 03 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 03 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 03 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 03 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 03 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 03 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 04 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 04 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 04 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 04 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 04 33 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 04 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 04 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 04 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 04 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 04 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 04 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 04 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 05 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 05 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 05 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 05 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 05 33 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 05 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 05 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 05 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 05 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 05 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 05 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 05 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 06 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 06 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 06 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 06 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 06 33 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 06 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 06 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 06 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 06 65 */
	0x0386,	0x0388,	0x0389,	0x038a,	0x03aa,	NODEST,	0x038c,	NODEST,
	/* 06 73 */
	0x038e,	0x03ab,	NODEST,	0x038f,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 06 81 */
	0x03ac,	0x03ad,	0x03ae,	0x03af,	0x03ca,	0x0390,	0x03cc,	0x03c2,
	/* 06 89 */
	0x03cd,	0x03cb,	0x03b0,	0x03ce,	NODEST,	NODEST,
	/* 07 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 07 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 07 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 07 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 07 33 */
	NODEST,	0x0402,	0x0403,	0x0404,	0x0405,	0x0406,	0x0407,	0x0408,
	/* 07 41 */
	0x0409,	0x040a,	0x040b,	0x040c,	0x040e,	0x040f,	NODEST,	NODEST,
	/* 07 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 07 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 07 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 07 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 07 81 */
	NODEST,	0x0452,	0x0453,	0x0454,	0x0455,	0x0456,	0x0457,	0x0458,
	/* 07 89 */
	0x0459,	0x045a,	0x045b,	0x045c,	0x045e,	0x045f,
	/* 08 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 33 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 08 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 09 01 */
	0x00c6,	0x0110,	NODEST,	0x0126,	NODEST,	0x0132,	NODEST,	0x0141,
	/* 09 09 */
	0x013f,	NODEST,	0x014a,	0x00d8,	0x0152,	NODEST,	0x0166,	0x00de,
	/* 09 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 09 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 09 33 */
	0x00e6,	0x0111,	0x00f0,	0x0127,	0x0131,	0x0133,	0x0138,	0x0142,
	/* 09 41 */
	0x0140,	0x0149,	0x014b,	0x00f8,	0x0153,	0x00df,	0x0167,	0x00fe,
	/* 09 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 09 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 09 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 09 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 09 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 09 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 10 01 */
	0x00c1,	0x00c0,	0x00c4,	0x00c2,	0x0102,	0x01cd,	0x0100,	0x0104,
	/* 10 09 */
	0x00c5,	0x00c3,	0x0106,	0x0108,	0x010c,	0x00c7,	0x010a,	0x010e,
	/* 10 17 */
	0x00c9,	0x00c8,	0x00cb,	0x00ca,	0x011a,	0x0116,	0x0112,	0x0118,
	/* 10 25 */
	NODEST,	0x011c,	0x011e,	0x0122,	0x0120,	0x0124,	0x00cd,	0x00cc,
	/* 10 33 */
	0x00cf,	0x00ce,	0x01cf,	0x0130,	0x012a,	0x012e,	0x0128,	0x0134,
	/* 10 41 */
	0x0136,	0x0139,	0x013d,	0x013b,	0x0143,	0x0147,	0x0145,	0x00d1,
	/* 10 49 */
	0x00d3,	0x00d2,	0x00d6,	0x00d4,	0x01d1,	0x0150,	0x014c,	0x00d5,
	/* 10 57 */
	0x0154,	0x0158,	0x0156,	0x015a,	0x015c,	0x0160,	0x015e,	0x0164,
	/* 10 65 */
	0x0162,	0x00da,	0x00d9,	0x00dc,	0x00db,	0x016c,	0x01d3,	0x0170,
	/* 10 73 */
	0x016a,	0x0172,	0x016e,	0x0168,	0x01d7,	0x01db,	0x01d9,	0x01d5,
	/* 10 81 */
	0x0174,	0x00dd,	0x0178,	0x0176,	0x0179,	0x017d,	0x017b,	NODEST,
	/* 10 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 11 01 */
	0x00e1,	0x00e0,	0x00e4,	0x00e2,	0x0103,	0x01ce,	0x0101,	0x0105,
	/* 11 09 */
	0x00e5,	0x00e3,	0x0107,	0x0109,	0x010d,	0x00e7,	0x010b,	0x010f,
	/* 11 17 */
	0x00e9,	0x00e8,	0x00eb,	0x00ea,	0x011b,	0x0117,	0x0113,	0x0119,
	/* 11 25 */
	0x01f5,	0x011d,	0x011f,	NODEST,	0x0121,	0x0125,	0x00ed,	0x00ec,
	/* 11 33 */
	0x00ef,	0x00ee,	0x01d0,	NODEST,	0x012b,	0x012f,	0x0129,	0x0135,
	/* 11 41 */
	0x0137,	0x013a,	0x013e,	0x013c,	0x0144,	0x0148,	0x0146,	0x00f1,
	/* 11 49 */
	0x00f3,	0x00f2,	0x00f6,	0x00f4,	0x01d2,	0x0151,	0x014d,	0x00f5,
	/* 11 57 */
	0x0155,	0x0159,	0x0157,	0x015b,	0x015d,	0x0161,	0x015f,	0x0165,
	/* 11 65 */
	0x0163,	0x00fa,	0x00f9,	0x00fc,	0x00fb,	0x016d,	0x01d4,	0x0171,
	/* 11 73 */
	0x016b,	0x0173,	0x016f,	0x0169,	0x01d8,	0x01dc,	0x01da,	0x01d6,
	/* 11 81 */
	0x0175,	0x00fd,	0x00ff,	0x0177,	0x017a,	0x017e,	0x017c,	NODEST,
	/* 11 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 12 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 12 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 12 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 12 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 12 33 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 12 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 12 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 12 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 12 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 12 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 12 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 12 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 13 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 13 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 13 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 13 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 13 33 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 13 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 13 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 13 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 13 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 13 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 13 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 13 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 14 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 14 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 14 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 14 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 14 33 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 14 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 14 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 14 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 14 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 14 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 14 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 14 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 15 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 15 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 15 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 15 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 15 33 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 15 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 15 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 15 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 15 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 15 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 15 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 15 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 16 01 */
	0x4e02,	0x4e04,	0x4e05,	0x4e0c,	0x4e12,	0x4e1f,	0x4e23,	0x4e24,
	/* 16 09 */
	0x4e28,	0x4e2b,	0x4e2e,	0x4e2f,	0x4e30,	0x4e35,	0x4e40,	0x4e41,
	/* 16 17 */
	0x4e44,	0x4e47,	0x4e51,	0x4e5a,	0x4e5c,	0x4e63,	0x4e68,	0x4e69,
	/* 16 25 */
	0x4e74,	0x4e75,	0x4e79,	0x4e7f,	0x4e8d,	0x4e96,	0x4e97,	0x4e9d,
	/* 16 33 */
	0x4eaf,	0x4eb9,	0x4ec3,	0x4ed0,	0x4eda,	0x4edb,	0x4ee0,	0x4ee1,
	/* 16 41 */
	0x4ee2,	0x4ee8,	0x4eef,	0x4ef1,	0x4ef3,	0x4ef5,	0x4efd,	0x4efe,
	/* 16 49 */
	0x4eff,	0x4f00,	0x4f02,	0x4f03,	0x4f08,	0x4f0b,	0x4f0c,	0x4f12,
	/* 16 57 */
	0x4f15,	0x4f16,	0x4f17,	0x4f19,	0x4f2e,	0x4f31,	0x4f60,	0x4f33,
	/* 16 65 */
	0x4f35,	0x4f37,	0x4f39,	0x4f3b,	0x4f3e,	0x4f40,	0x4f42,	0x4f48,
	/* 16 73 */
	0x4f49,	0x4f4b,	0x4f4c,	0x4f52,	0x4f54,	0x4f56,	0x4f58,	0x4f5f,
	/* 16 81 */
	0x4f63,	0x4f6a,	0x4f6c,	0x4f6e,	0x4f71,	0x4f77,	0x4f78,	0x4f79,
	/* 16 89 */
	0x4f7a,	0x4f7d,	0x4f7e,	0x4f81,	0x4f82,	0x4f84,
	/* 17 01 */
	0x4f85,	0x4f89,	0x4f8a,	0x4f8c,	0x4f8e,	0x4f90,	0x4f92,	0x4f93,
	/* 17 09 */
	0x4f94,	0x4f97,	0x4f99,	0x4f9a,	0x4f9e,	0x4f9f,	0x4fb2,	0x4fb7,
	/* 17 17 */
	0x4fb9,	0x4fbb,	0x4fbc,	0x4fbd,	0x4fbe,	0x4fc0,	0x4fc1,	0x4fc5,
	/* 17 25 */
	0x4fc6,	0x4fc8,	0x4fc9,	0x4fcb,	0x4fcc,	0x4fcd,	0x4fcf,	0x4fd2,
	/* 17 33 */
	0x4fdc,	0x4fe0,	0x4fe2,	0x4ff0,	0x4ff2,	0x4ffc,	0x4ffd,	0x4fff,
	/* 17 41 */
	0x5000,	0x5001,	0x5004,	0x5007,	0x500a,	0x500c,	0x500e,	0x5010,
	/* 17 49 */
	0x5013,	0x5017,	0x5018,	0x501b,	0x501c,	0x501d,	0x501e,	0x5022,
	/* 17 57 */
	0x5027,	0x502e,	0x5030,	0x5032,	0x5033,	0x5035,	0x5040,	0x5041,
	/* 17 65 */
	0x5042,	0x5045,	0x5046,	0x504a,	0x504c,	0x504e,	0x5051,	0x5052,
	/* 17 73 */
	0x5053,	0x5057,	0x5059,	0x505f,	0x5060,	0x5062,	0x5063,	0x5066,
	/* 17 81 */
	0x5067,	0x506a,	0x506d,	0x5070,	0x5071,	0x503b,	0x5081,	0x5083,
	/* 17 89 */
	0x5084,	0x5086,	0x508a,	0x508e,	0x508f,	0x5090,
	/* 18 01 */
	0x5092,	0x5093,	0x5094,	0x5096,	0x509b,	0x509c,	0x509e,	0x509f,
	/* 18 09 */
	0x50a0,	0x50a1,	0x50a2,	0x50aa,	0x50af,	0x50b0,	0x50b9,	0x50ba,
	/* 18 17 */
	0x50bd,	0x50c0,	0x50c3,	0x50c4,	0x50c7,	0x50cc,	0x50ce,	0x50d0,
	/* 18 25 */
	0x50d3,	0x50d4,	0x50d8,	0x50dc,	0x50dd,	0x50df,	0x50e2,	0x50e4,
	/* 18 33 */
	0x50e6,	0x50e8,	0x50e9,	0x50ef,	0x50f1,	0x50f6,	0x50fa,	0x50fe,
	/* 18 41 */
	0x5103,	0x5106,	0x5107,	0x5108,	0x510b,	0x510c,	0x510d,	0x510e,
	/* 18 49 */
	0x50f2,	0x5110,	0x5117,	0x5119,	0x511b,	0x511c,	0x511d,	0x511e,
	/* 18 57 */
	0x5123,	0x5127,	0x5128,	0x512c,	0x512d,	0x512f,	0x5131,	0x5133,
	/* 18 65 */
	0x5134,	0x5135,	0x5138,	0x5139,	0x5142,	0x514a,	0x514f,	0x5153,
	/* 18 73 */
	0x5155,	0x5157,	0x5158,	0x515f,	0x5164,	0x5166,	0x517e,	0x5183,
	/* 18 81 */
	0x5184,	0x518b,	0x518e,	0x5198,	0x519d,	0x51a1,	0x51a3,	0x51ad,
	/* 18 89 */
	0x51b8,	0x51ba,	0x51bc,	0x51be,	0x51bf,	0x51c2,
	/* 19 01 */
	0x51c8,	0x51cf,	0x51d1,	0x51d2,	0x51d3,	0x51d5,	0x51d8,	0x51de,
	/* 19 09 */
	0x51e2,	0x51e5,	0x51ee,	0x51f2,	0x51f3,	0x51f4,	0x51f7,	0x5201,
	/* 19 17 */
	0x5202,	0x5205,	0x5212,	0x5213,	0x5215,	0x5216,	0x5218,	0x5222,
	/* 19 25 */
	0x5228,	0x5231,	0x5232,	0x5235,	0x523c,	0x5245,	0x5249,	0x5255,
	/* 19 33 */
	0x5257,	0x5258,	0x525a,	0x525c,	0x525f,	0x5260,	0x5261,	0x5266,
	/* 19 41 */
	0x526e,	0x5277,	0x5278,	0x5279,	0x5280,	0x5282,	0x5285,	0x528a,
	/* 19 49 */
	0x528c,	0x5293,	0x5295,	0x5296,	0x5297,	0x5298,	0x529a,	0x529c,
	/* 19 57 */
	0x52a4,	0x52a5,	0x52a6,	0x52a7,	0x52af,	0x52b0,	0x52b6,	0x52b7,
	/* 19 65 */
	0x52b8,	0x52ba,	0x52bb,	0x52bd,	0x52c0,	0x52c4,	0x52c6,	0x52c8,
	/* 19 73 */
	0x52cc,	0x52cf,	0x52d1,	0x52d4,	0x52d6,	0x52db,	0x52dc,	0x52e1,
	/* 19 81 */
	0x52e5,	0x52e8,	0x52e9,	0x52ea,	0x52ec,	0x52f0,	0x52f1,	0x52f4,
	/* 19 89 */
	0x52f6,	0x52f7,	0x5300,	0x5303,	0x530a,	0x530b,
	/* 20 01 */
	0x530c,	0x5311,	0x5313,	0x5318,	0x531b,	0x531c,	0x531e,	0x531f,
	/* 20 09 */
	0x5325,	0x5327,	0x5328,	0x5329,	0x532b,	0x532c,	0x532d,	0x5330,
	/* 20 17 */
	0x5332,	0x5335,	0x533c,	0x533d,	0x533e,	0x5342,	0x534c,	0x534b,
	/* 20 25 */
	0x5359,	0x535b,	0x5361,	0x5363,	0x5365,	0x536c,	0x536d,	0x5372,
	/* 20 33 */
	0x5379,	0x537e,	0x5383,	0x5387,	0x5388,	0x538e,	0x5393,	0x5394,
	/* 20 41 */
	0x5399,	0x539d,	0x53a1,	0x53a4,	0x53aa,	0x53ab,	0x53af,	0x53b2,
	/* 20 49 */
	0x53b4,	0x53b5,	0x53b7,	0x53b8,	0x53ba,	0x53bd,	0x53c0,	0x53c5,
	/* 20 57 */
	0x53cf,	0x53d2,	0x53d3,	0x53d5,	0x53da,	0x53dd,	0x53de,	0x53e0,
	/* 20 65 */
	0x53e6,	0x53e7,	0x53f5,	0x5402,	0x5413,	0x541a,	0x5421,	0x5427,
	/* 20 73 */
	0x5428,	0x542a,	0x542f,	0x5431,	0x5434,	0x5435,	0x5443,	0x5444,
	/* 20 81 */
	0x5447,	0x544d,	0x544f,	0x545e,	0x5462,	0x5464,	0x5466,	0x5467,
	/* 20 89 */
	0x5469,	0x546b,	0x546d,	0x546e,	0x5474,	0x547f,
	/* 21 01 */
	0x5481,	0x5483,	0x5485,	0x5488,	0x5489,	0x548d,	0x5491,	0x5495,
	/* 21 09 */
	0x5496,	0x549c,	0x549f,	0x54a1,	0x54a6,	0x54a7,	0x54a9,	0x54aa,
	/* 21 17 */
	0x54ad,	0x54ae,	0x54b1,	0x54b7,	0x54b9,	0x54ba,	0x54bb,	0x54bf,
	/* 21 25 */
	0x54c6,	0x54ca,	0x54cd,	0x54ce,	0x54e0,	0x54ea,	0x54ec,	0x54ef,
	/* 21 33 */
	0x54f6,	0x54fc,	0x54fe,	0x54ff,	0x5500,	0x5501,	0x5505,	0x5508,
	/* 21 41 */
	0x5509,	0x550c,	0x550d,	0x550e,	0x5515,	0x552a,	0x552b,	0x5532,
	/* 21 49 */
	0x5535,	0x5536,	0x553b,	0x553c,	0x553d,	0x5541,	0x5547,	0x5549,
	/* 21 57 */
	0x554a,	0x554d,	0x5550,	0x5551,	0x5558,	0x555a,	0x555b,	0x555e,
	/* 21 65 */
	0x5560,	0x5561,	0x5564,	0x5566,	0x557f,	0x5581,	0x5582,	0x5586,
	/* 21 73 */
	0x5588,	0x558e,	0x558f,	0x5591,	0x5592,	0x5593,	0x5594,	0x5597,
	/* 21 81 */
	0x55a3,	0x55a4,	0x55ad,	0x55b2,	0x55bf,	0x55c1,	0x55c3,	0x55c6,
	/* 21 89 */
	0x55c9,	0x55cb,	0x55cc,	0x55ce,	0x55d1,	0x55d2,
	/* 22 01 */
	0x55d3,	0x55d7,	0x55d8,	0x55db,	0x55de,	0x55e2,	0x55e9,	0x55f6,
	/* 22 09 */
	0x55ff,	0x5605,	0x5608,	0x560a,	0x560d,	0x560e,	0x560f,	0x5610,
	/* 22 17 */
	0x5611,	0x5612,	0x5619,	0x562c,	0x5630,	0x5633,	0x5635,	0x5637,
	/* 22 25 */
	0x5639,	0x563b,	0x563c,	0x563d,	0x563f,	0x5640,	0x5641,	0x5643,
	/* 22 33 */
	0x5644,	0x5646,	0x5649,	0x564b,	0x564d,	0x564f,	0x5654,	0x565e,
	/* 22 41 */
	0x5660,	0x5661,	0x5662,	0x5663,	0x5666,	0x5669,	0x566d,	0x566f,
	/* 22 49 */
	0x5671,	0x5672,	0x5675,	0x5684,	0x5685,	0x5688,	0x568b,	0x568c,
	/* 22 57 */
	0x5695,	0x5699,	0x569a,	0x569d,	0x569e,	0x569f,	0x56a6,	0x56a7,
	/* 22 65 */
	0x56a8,	0x56a9,	0x56ab,	0x56ac,	0x56ad,	0x56b1,	0x56b3,	0x56b7,
	/* 22 73 */
	0x56be,	0x56c5,	0x56c9,	0x56ca,	0x56cb,	0x56cf,	0x56d0,	0x56cc,
	/* 22 81 */
	0x56cd,	0x56d9,	0x56dc,	0x56dd,	0x56df,	0x56e1,	0x56e4,	0x56e5,
	/* 22 89 */
	0x56e6,	0x56e7,	0x56e8,	0x56f1,	0x56eb,	0x56ed,
	/* 23 01 */
	0x56f6,	0x56f7,	0x5701,	0x5702,	0x5707,	0x570a,	0x570c,	0x5711,
	/* 23 09 */
	0x5715,	0x571a,	0x571b,	0x571d,	0x5720,	0x5722,	0x5723,	0x5724,
	/* 23 17 */
	0x5725,	0x5729,	0x572a,	0x572c,	0x572e,	0x572f,	0x5733,	0x5734,
	/* 23 25 */
	0x573d,	0x573e,	0x573f,	0x5745,	0x5746,	0x574c,	0x574d,	0x5752,
	/* 23 33 */
	0x5762,	0x5765,	0x5767,	0x5768,	0x576b,	0x576d,	0x576e,	0x576f,
	/* 23 41 */
	0x5770,	0x5771,	0x5773,	0x5774,	0x5775,	0x5777,	0x5779,	0x577a,
	/* 23 49 */
	0x577b,	0x577c,	0x577e,	0x5781,	0x5783,	0x578c,	0x5794,	0x5797,
	/* 23 57 */
	0x5799,	0x579a,	0x579c,	0x579d,	0x579e,	0x579f,	0x57a1,	0x5795,
	/* 23 65 */
	0x57a7,	0x57a8,	0x57a9,	0x57ac,	0x57b8,	0x57bd,	0x57c7,	0x57c8,
	/* 23 73 */
	0x57cc,	0x57cf,	0x57d5,	0x57dd,	0x57de,	0x57e4,	0x57e6,	0x57e7,
	/* 23 81 */
	0x57e9,	0x57ed,	0x57f0,	0x57f5,	0x57f6,	0x57f8,	0x57fd,	0x57fe,
	/* 23 89 */
	0x57ff,	0x5803,	0x5804,	0x5808,	0x5809,	0x57e1,
	/* 24 01 */
	0x580c,	0x580d,	0x581b,	0x581e,	0x581f,	0x5820,	0x5826,	0x5827,
	/* 24 09 */
	0x582d,	0x5832,	0x5839,	0x583f,	0x5849,	0x584c,	0x584d,	0x584f,
	/* 24 17 */
	0x5850,	0x5855,	0x585f,	0x5861,	0x5864,	0x5867,	0x5868,	0x5878,
	/* 24 25 */
	0x587c,	0x587f,	0x5880,	0x5881,	0x5887,	0x5888,	0x5889,	0x588a,
	/* 24 33 */
	0x588c,	0x588d,	0x588f,	0x5890,	0x5894,	0x5896,	0x589d,	0x58a0,
	/* 24 41 */
	0x58a1,	0x58a2,	0x58a6,	0x58a9,	0x58b1,	0x58b2,	0x58c4,	0x58bc,
	/* 24 49 */
	0x58c2,	0x58c8,	0x58cd,	0x58ce,	0x58d0,	0x58d2,	0x58d4,	0x58d6,
	/* 24 57 */
	0x58da,	0x58dd,	0x58e1,	0x58e2,	0x58e9,	0x58f3,	0x5905,	0x5906,
	/* 24 65 */
	0x590b,	0x590c,	0x5912,	0x5913,	0x5914,	0x8641,	0x591d,	0x5921,
	/* 24 73 */
	0x5923,	0x5924,	0x5928,	0x592f,	0x5930,	0x5933,	0x5935,	0x5936,
	/* 24 81 */
	0x593f,	0x5943,	0x5946,	0x5952,	0x5953,	0x5959,	0x595b,	0x595d,
	/* 24 89 */
	0x595e,	0x595f,	0x5961,	0x5963,	0x596b,	0x596d,
	/* 25 01 */
	0x596f,	0x5972,	0x5975,	0x5976,	0x5979,	0x597b,	0x597c,	0x598b,
	/* 25 09 */
	0x598c,	0x598e,	0x5992,	0x5995,	0x5997,	0x599f,	0x59a4,	0x59a7,
	/* 25 17 */
	0x59ad,	0x59ae,	0x59af,	0x59b0,	0x59b3,	0x59b7,	0x59ba,	0x59bc,
	/* 25 25 */
	0x59c1,	0x59c3,	0x59c4,	0x59c8,	0x59ca,	0x59cd,	0x59d2,	0x59dd,
	/* 25 33 */
	0x59de,	0x59df,	0x59e3,	0x59e4,	0x59e7,	0x59ee,	0x59ef,	0x59f1,
	/* 25 41 */
	0x59f2,	0x59f4,	0x59f7,	0x5a00,	0x5a04,	0x5a0c,	0x5a0d,	0x5a0e,
	/* 25 49 */
	0x5a12,	0x5a13,	0x5a1e,	0x5a23,	0x5a24,	0x5a27,	0x5a28,	0x5a2a,
	/* 25 57 */
	0x5a2d,	0x5a30,	0x5a44,	0x5a45,	0x5a47,	0x5a48,	0x5a4c,	0x5a50,
	/* 25 65 */
	0x5a55,	0x5a5e,	0x5a63,	0x5a65,	0x5a67,	0x5a6d,	0x5a77,	0x5a7a,
	/* 25 73 */
	0x5a7b,	0x5a7e,	0x5a8b,	0x5a90,	0x5a93,	0x5a96,	0x5a99,	0x5a9c,
	/* 25 81 */
	0x5a9e,	0x5a9f,	0x5aa0,	0x5aa2,	0x5aa7,	0x5aac,	0x5ab1,	0x5ab2,
	/* 25 89 */
	0x5ab3,	0x5ab5,	0x5ab8,	0x5aba,	0x5abb,	0x5abf,
	/* 26 01 */
	0x5ac4,	0x5ac6,	0x5ac8,	0x5acf,	0x5ada,	0x5adc,	0x5ae0,	0x5ae5,
	/* 26 09 */
	0x5aea,	0x5aee,	0x5af5,	0x5af6,	0x5afd,	0x5b00,	0x5b01,	0x5b08,
	/* 26 17 */
	0x5b17,	0x5b34,	0x5b19,	0x5b1b,	0x5b1d,	0x5b21,	0x5b25,	0x5b2d,
	/* 26 25 */
	0x5b38,	0x5b41,	0x5b4b,	0x5b4c,	0x5b52,	0x5b56,	0x5b5e,	0x5b68,
	/* 26 33 */
	0x5b6e,	0x5b6f,	0x5b7c,	0x5b7d,	0x5b7e,	0x5b7f,	0x5b81,	0x5b84,
	/* 26 41 */
	0x5b86,	0x5b8a,	0x5b8e,	0x5b90,	0x5b91,	0x5b93,	0x5b94,	0x5b96,
	/* 26 49 */
	0x5ba8,	0x5ba9,	0x5bac,	0x5bad,	0x5baf,	0x5bb1,	0x5bb2,	0x5bb7,
	/* 26 57 */
	0x5bba,	0x5bbc,	0x5bc0,	0x5bc1,	0x5bcd,	0x5bcf,	0x5bd6,	0x5bd7,
	/* 26 65 */
	0x5bd8,	0x5bd9,	0x5bda,	0x5be0,	0x5bef,	0x5bf1,	0x5bf4,	0x5bfd,
	/* 26 73 */
	0x5c0c,	0x5c17,	0x5c1e,	0x5c1f,	0x5c23,	0x5c26,	0x5c29,	0x5c2b,
	/* 26 81 */
	0x5c2c,	0x5c2e,	0x5c30,	0x5c32,	0x5c35,	0x5c36,	0x5c59,	0x5c5a,
	/* 26 89 */
	0x5c5c,	0x5c62,	0x5c63,	0x5c67,	0x5c68,	0x5c69,
	/* 27 01 */
	0x5c6d,	0x5c70,	0x5c74,	0x5c75,	0x5c7a,	0x5c7b,	0x5c7c,	0x5c7d,
	/* 27 09 */
	0x5c87,	0x5c88,	0x5c8a,	0x5c8f,	0x5c92,	0x5c9d,	0x5c9f,	0x5ca0,
	/* 27 17 */
	0x5ca2,	0x5ca3,	0x5ca6,	0x5caa,	0x5cb2,	0x5cb4,	0x5cb5,	0x5cba,
	/* 27 25 */
	0x5cc9,	0x5ccb,	0x5cd2,	0x5cdd,	0x5cd7,	0x5cee,	0x5cf1,	0x5cf2,
	/* 27 33 */
	0x5cf4,	0x5d01,	0x5d06,	0x5d0d,	0x5d12,	0x5d2b,	0x5d23,	0x5d24,
	/* 27 41 */
	0x5d26,	0x5d27,	0x5d31,	0x5d34,	0x5d39,	0x5d3d,	0x5d3f,	0x5d42,
	/* 27 49 */
	0x5d43,	0x5d46,	0x5d48,	0x5d55,	0x5d51,	0x5d59,	0x5d4a,	0x5d5f,
	/* 27 57 */
	0x5d60,	0x5d61,	0x5d62,	0x5d64,	0x5d6a,	0x5d6d,	0x5d70,	0x5d79,
	/* 27 65 */
	0x5d7a,	0x5d7e,	0x5d7f,	0x5d81,	0x5d83,	0x5d88,	0x5d8a,	0x5d92,
	/* 27 73 */
	0x5d93,	0x5d94,	0x5d95,	0x5d99,	0x5d9b,	0x5d9f,	0x5da0,	0x5da7,
	/* 27 81 */
	0x5dab,	0x5db0,	0x5db4,	0x5db8,	0x5db9,	0x5dc3,	0x5dc7,	0x5dcb,
	/* 27 89 */
	0x5dd0,	0x5dce,	0x5dd8,	0x5dd9,	0x5de0,	0x5de4,
	/* 28 01 */
	0x5de9,	0x5df8,	0x5df9,	0x5e00,	0x5e07,	0x5e0d,	0x5e12,	0x5e14,
	/* 28 09 */
	0x5e15,	0x5e18,	0x5e1f,	0x5e20,	0x5e2e,	0x5e28,	0x5e32,	0x5e35,
	/* 28 17 */
	0x5e3e,	0x5e4b,	0x5e50,	0x5e49,	0x5e51,	0x5e56,	0x5e58,	0x5e5b,
	/* 28 25 */
	0x5e5c,	0x5e5e,	0x5e68,	0x5e6a,	0x5e6b,	0x5e6c,	0x5e6d,	0x5e6e,
	/* 28 33 */
	0x5e70,	0x5e80,	0x5e8b,	0x5e8e,	0x5ea2,	0x5ea4,	0x5ea5,	0x5ea8,
	/* 28 41 */
	0x5eaa,	0x5eac,	0x5eb1,	0x5eb3,	0x5ebd,	0x5ebe,	0x5ebf,	0x5ec6,
	/* 28 49 */
	0x5ecc,	0x5ecb,	0x5ece,	0x5ed1,	0x5ed2,	0x5ed4,	0x5ed5,	0x5edc,
	/* 28 57 */
	0x5ede,	0x5ee5,	0x5eeb,	0x5f02,	0x5f06,	0x5f07,	0x5f08,	0x5f0e,
	/* 28 65 */
	0x5f19,	0x5f1c,	0x5f1d,	0x5f21,	0x5f22,	0x5f23,	0x5f24,	0x5f28,
	/* 28 73 */
	0x5f2b,	0x5f2c,	0x5f2e,	0x5f30,	0x5f34,	0x5f36,	0x5f3b,	0x5f3d,
	/* 28 81 */
	0x5f3f,	0x5f40,	0x5f44,	0x5f45,	0x5f47,	0x5f4d,	0x5f50,	0x5f54,
	/* 28 89 */
	0x5f58,	0x5f5b,	0x5f60,	0x5f63,	0x5f64,	0x5f67,
	/* 29 01 */
	0x5f6f,	0x5f72,	0x5f74,	0x5f75,	0x5f78,	0x5f7a,	0x5f7d,	0x5f7e,
	/* 29 09 */
	0x5f89,	0x5f8d,	0x5f8f,	0x5f96,	0x5f9c,	0x5f9d,	0x5fa2,	0x5fa7,
	/* 29 17 */
	0x5fab,	0x5fa4,	0x5fac,	0x5faf,	0x5fb0,	0x5fb1,	0x5fb8,	0x5fc4,
	/* 29 25 */
	0x5fc7,	0x5fc8,	0x5fc9,	0x5fcb,	0x5fd0,	0x5fd1,	0x5fd2,	0x5fd3,
	/* 29 33 */
	0x5fd4,	0x5fde,	0x5fe1,	0x5fe2,	0x5fe8,	0x5fe9,	0x5fea,	0x5fec,
	/* 29 41 */
	0x5fed,	0x5fee,	0x5fef,	0x5ff2,	0x5ff3,	0x5ff6,	0x5ffa,	0x5ffc,
	/* 29 49 */
	0x6007,	0x600a,	0x600d,	0x6013,	0x6014,	0x6017,	0x6018,	0x601a,
	/* 29 57 */
	0x601f,	0x6024,	0x602d,	0x6033,	0x6035,	0x6040,	0x6047,	0x6048,
	/* 29 65 */
	0x6049,	0x604c,	0x6051,	0x6054,	0x6056,	0x6057,	0x605d,	0x6061,
	/* 29 73 */
	0x6067,	0x6071,	0x607e,	0x607f,	0x6082,	0x6086,	0x6088,	0x608a,
	/* 29 81 */
	0x608e,	0x6091,	0x6093,	0x6095,	0x6098,	0x609d,	0x609e,	0x60a2,
	/* 29 89 */
	0x60a4,	0x60a5,	0x60a8,	0x60b0,	0x60b1,	0x60b7,
	/* 30 01 */
	0x60bb,	0x60be,	0x60c2,	0x60c4,	0x60c8,	0x60c9,	0x60ca,	0x60cb,
	/* 30 09 */
	0x60ce,	0x60cf,	0x60d4,	0x60d5,	0x60d9,	0x60db,	0x60dd,	0x60de,
	/* 30 17 */
	0x60e2,	0x60e5,	0x60f2,	0x60f5,	0x60f8,	0x60fc,	0x60fd,	0x6102,
	/* 30 25 */
	0x6107,	0x610a,	0x610c,	0x6110,	0x6111,	0x6112,	0x6113,	0x6114,
	/* 30 33 */
	0x6116,	0x6117,	0x6119,	0x611c,	0x611e,	0x6122,	0x612a,	0x612b,
	/* 30 41 */
	0x6130,	0x6131,	0x6135,	0x6136,	0x6137,	0x6139,	0x6141,	0x6145,
	/* 30 49 */
	0x6146,	0x6149,	0x615e,	0x6160,	0x616c,	0x6172,	0x6178,	0x617b,
	/* 30 57 */
	0x617c,	0x617f,	0x6180,	0x6181,	0x6183,	0x6184,	0x618b,	0x618d,
	/* 30 65 */
	0x6192,	0x6193,	0x6197,	0x6198,	0x619c,	0x619d,	0x619f,	0x61a0,
	/* 30 73 */
	0x61a5,	0x61a8,	0x61aa,	0x61ad,	0x61b8,	0x61b9,	0x61bc,	0x61c0,
	/* 30 81 */
	0x61c1,	0x61c2,	0x61ce,	0x61cf,	0x61d5,	0x61dc,	0x61dd,	0x61de,
	/* 30 89 */
	0x61df,	0x61e1,	0x61e2,	0x61e7,	0x61e9,	0x61e5,
	/* 31 01 */
	0x61ec,	0x61ed,	0x61ef,	0x6201,	0x6203,	0x6204,	0x6207,	0x6213,
	/* 31 09 */
	0x6215,	0x621c,	0x6220,	0x6222,	0x6223,	0x6227,	0x6229,	0x622b,
	/* 31 17 */
	0x6239,	0x623d,	0x6242,	0x6243,	0x6244,	0x6246,	0x624c,	0x6250,
	/* 31 25 */
	0x6251,	0x6252,	0x6254,	0x6256,	0x625a,	0x625c,	0x6264,	0x626d,
	/* 31 33 */
	0x626f,	0x6273,	0x627a,	0x627d,	0x628d,	0x628e,	0x628f,	0x6290,
	/* 31 41 */
	0x62a6,	0x62a8,	0x62b3,	0x62b6,	0x62b7,	0x62ba,	0x62be,	0x62bf,
	/* 31 49 */
	0x62c4,	0x62ce,	0x62d5,	0x62d6,	0x62da,	0x62ea,	0x62f2,	0x62f4,
	/* 31 57 */
	0x62fc,	0x62fd,	0x6303,	0x6304,	0x630a,	0x630b,	0x630d,	0x6310,
	/* 31 65 */
	0x6313,	0x6316,	0x6318,	0x6329,	0x632a,	0x632d,	0x6335,	0x6336,
	/* 31 73 */
	0x6339,	0x633c,	0x6341,	0x6342,	0x6343,	0x6344,	0x6346,	0x634a,
	/* 31 81 */
	0x634b,	0x634e,	0x6352,	0x6353,	0x6354,	0x6358,	0x635b,	0x6365,
	/* 31 89 */
	0x6366,	0x636c,	0x636d,	0x6371,	0x6374,	0x6375,
	/* 32 01 */
	0x6378,	0x637c,	0x637d,	0x637f,	0x6382,	0x6384,	0x6387,	0x638a,
	/* 32 09 */
	0x6390,	0x6394,	0x6395,	0x6399,	0x639a,	0x639e,	0x63a4,	0x63a6,
	/* 32 17 */
	0x63ad,	0x63ae,	0x63af,	0x63bd,	0x63c1,	0x63c5,	0x63c8,	0x63ce,
	/* 32 25 */
	0x63d1,	0x63d3,	0x63d4,	0x63d5,	0x63dc,	0x63e0,	0x63e5,	0x63ea,
	/* 32 33 */
	0x63ec,	0x63f2,	0x63f3,	0x63f5,	0x63f8,	0x63f9,	0x6409,	0x640a,
	/* 32 41 */
	0x6410,	0x6412,	0x6414,	0x6418,	0x641e,	0x6420,	0x6422,	0x6424,
	/* 32 49 */
	0x6425,	0x6429,	0x642a,	0x642f,	0x6430,	0x6435,	0x643d,	0x643f,
	/* 32 57 */
	0x644b,	0x644f,	0x6451,	0x6452,	0x6453,	0x6454,	0x645a,	0x645b,
	/* 32 65 */
	0x645c,	0x645d,	0x645f,	0x6460,	0x6461,	0x6463,	0x646d,	0x6473,
	/* 32 73 */
	0x6474,	0x647b,	0x647d,	0x6485,	0x6487,	0x648f,	0x6490,	0x6491,
	/* 32 81 */
	0x6498,	0x6499,	0x649b,	0x649d,	0x649f,	0x64a1,	0x64a3,	0x64a6,
	/* 32 89 */
	0x64a8,	0x64ac,	0x64b3,	0x64bd,	0x64be,	0x64bf,
	/* 33 01 */
	0x64c4,	0x64c9,	0x64ca,	0x64cb,	0x64cc,	0x64ce,	0x64d0,	0x64d1,
	/* 33 09 */
	0x64d5,	0x64d7,	0x64e4,	0x64e5,	0x64e9,	0x64ea,	0x64ed,	0x64f0,
	/* 33 17 */
	0x64f5,	0x64f7,	0x64fb,	0x64ff,	0x6501,	0x6504,	0x6508,	0x6509,
	/* 33 25 */
	0x650a,	0x650f,	0x6513,	0x6514,	0x6516,	0x6519,	0x651b,	0x651e,
	/* 33 33 */
	0x651f,	0x6522,	0x6526,	0x6529,	0x652e,	0x6531,	0x653a,	0x653c,
	/* 33 41 */
	0x653d,	0x6543,	0x6547,	0x6549,	0x6550,	0x6552,	0x6554,	0x655f,
	/* 33 49 */
	0x6560,	0x6567,	0x656b,	0x657a,	0x657d,	0x6581,	0x6585,	0x658a,
	/* 33 57 */
	0x6592,	0x6595,	0x6598,	0x659d,	0x65a0,	0x65a3,	0x65a6,	0x65ae,
	/* 33 65 */
	0x65b2,	0x65b3,	0x65b4,	0x65bf,	0x65c2,	0x65c8,	0x65c9,	0x65ce,
	/* 33 73 */
	0x65d0,	0x65d4,	0x65d6,	0x65d8,	0x65df,	0x65f0,	0x65f2,	0x65f4,
	/* 33 81 */
	0x65f5,	0x65f9,	0x65fe,	0x65ff,	0x6600,	0x6604,	0x6608,	0x6609,
	/* 33 89 */
	0x660d,	0x6611,	0x6612,	0x6615,	0x6616,	0x661d,
	/* 34 01 */
	0x661e,	0x6621,	0x6622,	0x6623,	0x6624,	0x6626,	0x6629,	0x662a,
	/* 34 09 */
	0x662b,	0x662c,	0x662e,	0x6630,	0x6631,	0x6633,	0x6639,	0x6637,
	/* 34 17 */
	0x6640,	0x6645,	0x6646,	0x664a,	0x664c,	0x6651,	0x664e,	0x6657,
	/* 34 25 */
	0x6658,	0x6659,	0x665b,	0x665c,	0x6660,	0x6661,	0x66fb,	0x666a,
	/* 34 33 */
	0x666b,	0x666c,	0x667e,	0x6673,	0x6675,	0x667f,	0x6677,	0x6678,
	/* 34 41 */
	0x6679,	0x667b,	0x6680,	0x667c,	0x668b,	0x668c,	0x668d,	0x6690,
	/* 34 49 */
	0x6692,	0x6699,	0x669a,	0x669b,	0x669c,	0x669f,	0x66a0,	0x66a4,
	/* 34 57 */
	0x66ad,	0x66b1,	0x66b2,	0x66b5,	0x66bb,	0x66bf,	0x66c0,	0x66c2,
	/* 34 65 */
	0x66c3,	0x66c8,	0x66cc,	0x66ce,	0x66cf,	0x66d4,	0x66db,	0x66df,
	/* 34 73 */
	0x66e8,	0x66eb,	0x66ec,	0x66ee,	0x66fa,	0x6705,	0x6707,	0x670e,
	/* 34 81 */
	0x6713,	0x6719,	0x671c,	0x6720,	0x6722,	0x6733,	0x673e,	0x6745,
	/* 34 89 */
	0x6747,	0x6748,	0x674c,	0x6754,	0x6755,	0x675d,
	/* 35 01 */
	0x6766,	0x676c,	0x676e,	0x6774,	0x6776,	0x677b,	0x6781,	0x6784,
	/* 35 09 */
	0x678e,	0x678f,	0x6791,	0x6793,	0x6796,	0x6798,	0x6799,	0x679b,
	/* 35 17 */
	0x67b0,	0x67b1,	0x67b2,	0x67b5,	0x67bb,	0x67bc,	0x67bd,	0x67f9,
	/* 35 25 */
	0x67c0,	0x67c2,	0x67c3,	0x67c5,	0x67c8,	0x67c9,	0x67d2,	0x67d7,
	/* 35 33 */
	0x67d9,	0x67dc,	0x67e1,	0x67e6,	0x67f0,	0x67f2,	0x67f6,	0x67f7,
	/* 35 41 */
	0x6852,	0x6814,	0x6819,	0x681d,	0x681f,	0x6828,	0x6827,	0x682c,
	/* 35 49 */
	0x682d,	0x682f,	0x6830,	0x6831,	0x6833,	0x683b,	0x683f,	0x6844,
	/* 35 57 */
	0x6845,	0x684a,	0x684c,	0x6855,	0x6857,	0x6858,	0x685b,	0x686b,
	/* 35 65 */
	0x686e,	0x686f,	0x6870,	0x6871,	0x6872,	0x6875,	0x6879,	0x687a,
	/* 35 73 */
	0x687b,	0x687c,	0x6882,	0x6884,	0x6886,	0x6888,	0x6896,	0x6898,
	/* 35 81 */
	0x689a,	0x689c,	0x68a1,	0x68a3,	0x68a5,	0x68a9,	0x68aa,	0x68ae,
	/* 35 89 */
	0x68b2,	0x68bb,	0x68c5,	0x68c8,	0x68cc,	0x68cf,
	/* 36 01 */
	0x68d0,	0x68d1,	0x68d3,	0x68d6,	0x68d9,	0x68dc,	0x68dd,	0x68e5,
	/* 36 09 */
	0x68e8,	0x68ea,	0x68eb,	0x68ec,	0x68ed,	0x68f0,	0x68f1,	0x68f5,
	/* 36 17 */
	0x68f6,	0x68fb,	0x68fc,	0x68fd,	0x6906,	0x6909,	0x690a,	0x6910,
	/* 36 25 */
	0x6911,	0x6913,	0x6916,	0x6917,	0x6931,	0x6933,	0x6935,	0x6938,
	/* 36 33 */
	0x693b,	0x6942,	0x6945,	0x6949,	0x694e,	0x6957,	0x695b,	0x6963,
	/* 36 41 */
	0x6964,	0x6965,	0x6966,	0x6968,	0x6969,	0x696c,	0x6970,	0x6971,
	/* 36 49 */
	0x6972,	0x697a,	0x697b,	0x697f,	0x6980,	0x698d,	0x6992,	0x6996,
	/* 36 57 */
	0x6998,	0x69a1,	0x69a5,	0x69a6,	0x69a8,	0x69ab,	0x69ad,	0x69af,
	/* 36 65 */
	0x69b7,	0x69b8,	0x69ba,	0x69bc,	0x69c5,	0x69c8,	0x69d1,	0x69d6,
	/* 36 73 */
	0x69d7,	0x69e2,	0x69e5,	0x69ee,	0x69ef,	0x69f1,	0x69f3,	0x69f5,
	/* 36 81 */
	0x69fe,	0x6a00,	0x6a01,	0x6a03,	0x6a0f,	0x6a11,	0x6a15,	0x6a1a,
	/* 36 89 */
	0x6a1d,	0x6a20,	0x6a24,	0x6a28,	0x6a30,	0x6a32,
	/* 37 01 */
	0x6a34,	0x6a37,	0x6a3b,	0x6a3e,	0x6a3f,	0x6a45,	0x6a46,	0x6a49,
	/* 37 09 */
	0x6a4a,	0x6a4e,	0x6a50,	0x6a51,	0x6a52,	0x6a55,	0x6a56,	0x6a5b,
	/* 37 17 */
	0x6a64,	0x6a67,	0x6a6a,	0x6a71,	0x6a73,	0x6a7e,	0x6a81,	0x6a83,
	/* 37 25 */
	0x6a86,	0x6a87,	0x6a89,	0x6a8b,	0x6a91,	0x6a9b,	0x6a9d,	0x6a9e,
	/* 37 33 */
	0x6a9f,	0x6aa5,	0x6aab,	0x6aaf,	0x6ab0,	0x6ab1,	0x6ab4,	0x6abd,
	/* 37 41 */
	0x6abe,	0x6abf,	0x6ac6,	0x6ac9,	0x6ac8,	0x6acc,	0x6ad0,	0x6ad4,
	/* 37 49 */
	0x6ad5,	0x6ad6,	0x6adc,	0x6add,	0x6ae4,	0x6ae7,	0x6aec,	0x6af0,
	/* 37 57 */
	0x6af1,	0x6af2,	0x6afc,	0x6afd,	0x6b02,	0x6b03,	0x6b06,	0x6b07,
	/* 37 65 */
	0x6b09,	0x6b0f,	0x6b10,	0x6b11,	0x6b17,	0x6b1b,	0x6b1e,	0x6b24,
	/* 37 73 */
	0x6b28,	0x6b2b,	0x6b2c,	0x6b2f,	0x6b35,	0x6b36,	0x6b3b,	0x6b3f,
	/* 37 81 */
	0x6b46,	0x6b4a,	0x6b4d,	0x6b52,	0x6b56,	0x6b58,	0x6b5d,	0x6b60,
	/* 37 89 */
	0x6b67,	0x6b6b,	0x6b6e,	0x6b70,	0x6b75,	0x6b7d,
	/* 38 01 */
	0x6b7e,	0x6b82,	0x6b85,	0x6b97,	0x6b9b,	0x6b9f,	0x6ba0,	0x6ba2,
	/* 38 09 */
	0x6ba3,	0x6ba8,	0x6ba9,	0x6bac,	0x6bad,	0x6bae,	0x6bb0,	0x6bb8,
	/* 38 17 */
	0x6bb9,	0x6bbd,	0x6bbe,	0x6bc3,	0x6bc4,	0x6bc9,	0x6bcc,	0x6bd6,
	/* 38 25 */
	0x6bda,	0x6be1,	0x6be3,	0x6be6,	0x6be7,	0x6bee,	0x6bf1,	0x6bf7,
	/* 38 33 */
	0x6bf9,	0x6bff,	0x6c02,	0x6c04,	0x6c05,	0x6c09,	0x6c0d,	0x6c0e,
	/* 38 41 */
	0x6c10,	0x6c12,	0x6c19,	0x6c1f,	0x6c26,	0x6c27,	0x6c28,	0x6c2c,
	/* 38 49 */
	0x6c2e,	0x6c33,	0x6c35,	0x6c36,	0x6c3a,	0x6c3b,	0x6c3f,	0x6c4a,
	/* 38 57 */
	0x6c4b,	0x6c4d,	0x6c4f,	0x6c52,	0x6c54,	0x6c59,	0x6c5b,	0x6c5c,
	/* 38 65 */
	0x6c6b,	0x6c6d,	0x6c6f,	0x6c74,	0x6c76,	0x6c78,	0x6c79,	0x6c7b,
	/* 38 73 */
	0x6c85,	0x6c86,	0x6c87,	0x6c89,	0x6c94,	0x6c95,	0x6c97,	0x6c98,
	/* 38 81 */
	0x6c9c,	0x6c9f,	0x6cb0,	0x6cb2,	0x6cb4,	0x6cc2,	0x6cc6,	0x6ccd,
	/* 38 89 */
	0x6ccf,	0x6cd0,	0x6cd1,	0x6cd2,	0x6cd4,	0x6cd6,
	/* 39 01 */
	0x6cda,	0x6cdc,	0x6ce0,	0x6ce7,	0x6ce9,	0x6ceb,	0x6cec,	0x6cee,
	/* 39 09 */
	0x6cf2,	0x6cf4,	0x6d04,	0x6d07,	0x6d0a,	0x6d0e,	0x6d0f,	0x6d11,
	/* 39 17 */
	0x6d13,	0x6d1a,	0x6d26,	0x6d27,	0x6d28,	0x6c67,	0x6d2e,	0x6d2f,
	/* 39 25 */
	0x6d31,	0x6d39,	0x6d3c,	0x6d3f,	0x6d57,	0x6d5e,	0x6d5f,	0x6d61,
	/* 39 33 */
	0x6d65,	0x6d67,	0x6d6f,	0x6d70,	0x6d7c,	0x6d82,	0x6d87,	0x6d91,
	/* 39 41 */
	0x6d92,	0x6d94,	0x6d96,	0x6d97,	0x6d98,	0x6daa,	0x6dac,	0x6db4,
	/* 39 49 */
	0x6db7,	0x6db9,	0x6dbd,	0x6dbf,	0x6dc4,	0x6dc8,	0x6dca,	0x6dce,
	/* 39 57 */
	0x6dcf,	0x6dd6,	0x6ddb,	0x6ddd,	0x6ddf,	0x6de0,	0x6de2,	0x6de5,
	/* 39 65 */
	0x6de9,	0x6def,	0x6df0,	0x6df4,	0x6df6,	0x6dfc,	0x6e00,	0x6e04,
	/* 39 73 */
	0x6e1e,	0x6e22,	0x6e27,	0x6e32,	0x6e36,	0x6e39,	0x6e3b,	0x6e3c,
	/* 39 81 */
	0x6e44,	0x6e45,	0x6e48,	0x6e49,	0x6e4b,	0x6e4f,	0x6e51,	0x6e52,
	/* 39 89 */
	0x6e53,	0x6e54,	0x6e57,	0x6e5c,	0x6e5d,	0x6e5e,
	/* 40 01 */
	0x6e62,	0x6e63,	0x6e68,	0x6e73,	0x6e7b,	0x6e7d,	0x6e8d,	0x6e93,
	/* 40 09 */
	0x6e99,	0x6ea0,	0x6ea7,	0x6ead,	0x6eae,	0x6eb1,	0x6eb3,	0x6ebb,
	/* 40 17 */
	0x6ebf,	0x6ec0,	0x6ec1,	0x6ec3,	0x6ec7,	0x6ec8,	0x6eca,	0x6ecd,
	/* 40 25 */
	0x6ece,	0x6ecf,	0x6eeb,	0x6eed,	0x6eee,	0x6ef9,	0x6efb,	0x6efd,
	/* 40 33 */
	0x6f04,	0x6f08,	0x6f0a,	0x6f0c,	0x6f0d,	0x6f16,	0x6f18,	0x6f1a,
	/* 40 41 */
	0x6f1b,	0x6f26,	0x6f29,	0x6f2a,	0x6f2f,	0x6f30,	0x6f33,	0x6f36,
	/* 40 49 */
	0x6f3b,	0x6f3c,	0x6f2d,	0x6f4f,	0x6f51,	0x6f52,	0x6f53,	0x6f57,
	/* 40 57 */
	0x6f59,	0x6f5a,	0x6f5d,	0x6f5e,	0x6f61,	0x6f62,	0x6f68,	0x6f6c,
	/* 40 65 */
	0x6f7d,	0x6f7e,	0x6f83,	0x6f87,	0x6f88,	0x6f8b,	0x6f8c,	0x6f8d,
	/* 40 73 */
	0x6f90,	0x6f92,	0x6f93,	0x6f94,	0x6f96,	0x6f9a,	0x6f9f,	0x6fa0,
	/* 40 81 */
	0x6fa5,	0x6fa6,	0x6fa7,	0x6fa8,	0x6fae,	0x6faf,	0x6fb0,	0x6fb5,
	/* 40 89 */
	0x6fb6,	0x6fbc,	0x6fc5,	0x6fc7,	0x6fc8,	0x6fca,
	/* 41 01 */
	0x6fda,	0x6fde,	0x6fe8,	0x6fe9,	0x6ff0,	0x6ff5,	0x6ff9,	0x6ffc,
	/* 41 09 */
	0x6ffd,	0x7000,	0x7005,	0x7006,	0x7007,	0x700d,	0x7017,	0x7020,
	/* 41 17 */
	0x7023,	0x702f,	0x7034,	0x7037,	0x7039,	0x703c,	0x7043,	0x7044,
	/* 41 25 */
	0x7048,	0x7049,	0x704a,	0x704b,	0x7054,	0x7055,	0x705d,	0x705e,
	/* 41 33 */
	0x704e,	0x7064,	0x7065,	0x706c,	0x706e,	0x7075,	0x7076,	0x707e,
	/* 41 41 */
	0x7081,	0x7085,	0x7086,	0x7094,	0x7095,	0x7096,	0x7097,	0x7098,
	/* 41 49 */
	0x709b,	0x70a4,	0x70ab,	0x70b0,	0x70b1,	0x70b4,	0x70b7,	0x70ca,
	/* 41 57 */
	0x70d1,	0x70d3,	0x70d4,	0x70d5,	0x70d6,	0x70d8,	0x70dc,	0x70e4,
	/* 41 65 */
	0x70fa,	0x7103,	0x7104,	0x7105,	0x7106,	0x7107,	0x710b,	0x710c,
	/* 41 73 */
	0x710f,	0x711e,	0x7120,	0x712b,	0x712d,	0x712f,	0x7130,	0x7131,
	/* 41 81 */
	0x7138,	0x7141,	0x7145,	0x7146,	0x7147,	0x714a,	0x714b,	0x7150,
	/* 41 89 */
	0x7152,	0x7157,	0x715a,	0x715c,	0x715e,	0x7160,
	/* 42 01 */
	0x7168,	0x7179,	0x7180,	0x7185,	0x7187,	0x718c,	0x7192,	0x719a,
	/* 42 09 */
	0x719b,	0x71a0,	0x71a2,	0x71af,	0x71b0,	0x71b2,	0x71b3,	0x71ba,
	/* 42 17 */
	0x71bf,	0x71c0,	0x71c1,	0x71c4,	0x71cb,	0x71cc,	0x71d3,	0x71d6,
	/* 42 25 */
	0x71d9,	0x71da,	0x71dc,	0x71f8,	0x71fe,	0x7200,	0x7207,	0x7208,
	/* 42 33 */
	0x7209,	0x7213,	0x7217,	0x721a,	0x721d,	0x721f,	0x7224,	0x722b,
	/* 42 41 */
	0x722f,	0x7234,	0x7238,	0x7239,	0x7241,	0x7242,	0x7243,	0x7245,
	/* 42 49 */
	0x724e,	0x724f,	0x7250,	0x7253,	0x7255,	0x7256,	0x725a,	0x725c,
	/* 42 57 */
	0x725e,	0x7260,	0x7263,	0x7268,	0x726b,	0x726e,	0x726f,	0x7271,
	/* 42 65 */
	0x7277,	0x7278,	0x727b,	0x727c,	0x727f,	0x7284,	0x7289,	0x728d,
	/* 42 73 */
	0x728e,	0x7293,	0x729b,	0x72a8,	0x72ad,	0x72ae,	0x72b1,	0x72b4,
	/* 42 81 */
	0x72be,	0x72c1,	0x72c7,	0x72c9,	0x72cc,	0x72d5,	0x72d6,	0x72d8,
	/* 42 89 */
	0x72df,	0x72e5,	0x72f3,	0x72f4,	0x72fa,	0x72fb,
	/* 43 01 */
	0x72fe,	0x7302,	0x7304,	0x7305,	0x7307,	0x730b,	0x730d,	0x7312,
	/* 43 09 */
	0x7313,	0x7318,	0x7319,	0x731e,	0x7322,	0x7324,	0x7327,	0x7328,
	/* 43 17 */
	0x732c,	0x7331,	0x7332,	0x7335,	0x733a,	0x733b,	0x733d,	0x7343,
	/* 43 25 */
	0x734d,	0x7350,	0x7352,	0x7356,	0x7358,	0x735d,	0x735e,	0x735f,
	/* 43 33 */
	0x7360,	0x7366,	0x7367,	0x7369,	0x736b,	0x736c,	0x736e,	0x736f,
	/* 43 41 */
	0x7371,	0x7377,	0x7379,	0x737c,	0x7380,	0x7381,	0x7383,	0x7385,
	/* 43 49 */
	0x7386,	0x738e,	0x7390,	0x7393,	0x7395,	0x7397,	0x7398,	0x739c,
	/* 43 57 */
	0x739e,	0x739f,	0x73a0,	0x73a2,	0x73a5,	0x73a6,	0x73aa,	0x73ab,
	/* 43 65 */
	0x73ad,	0x73b5,	0x73b7,	0x73b9,	0x73bc,	0x73bd,	0x73bf,	0x73c5,
	/* 43 73 */
	0x73c6,	0x73c9,	0x73cb,	0x73cc,	0x73cf,	0x73d2,	0x73d3,	0x73d6,
	/* 43 81 */
	0x73d9,	0x73dd,	0x73e1,	0x73e3,	0x73e6,	0x73e7,	0x73e9,	0x73f4,
	/* 43 89 */
	0x73f5,	0x73f7,	0x73f9,	0x73fa,	0x73fb,	0x73fd,
	/* 44 01 */
	0x73ff,	0x7400,	0x7401,	0x7404,	0x7407,	0x740a,	0x7411,	0x741a,
	/* 44 09 */
	0x741b,	0x7424,	0x7426,	0x7428,	0x7429,	0x742a,	0x742b,	0x742c,
	/* 44 17 */
	0x742d,	0x742e,	0x742f,	0x7430,	0x7431,	0x7439,	0x7440,	0x7443,
	/* 44 25 */
	0x7444,	0x7446,	0x7447,	0x744b,	0x744d,	0x7451,	0x7452,	0x7457,
	/* 44 33 */
	0x745d,	0x7462,	0x7466,	0x7467,	0x7468,	0x746b,	0x746d,	0x746e,
	/* 44 41 */
	0x7471,	0x7472,	0x7480,	0x7481,	0x7485,	0x7486,	0x7487,	0x7489,
	/* 44 49 */
	0x748f,	0x7490,	0x7491,	0x7492,	0x7498,	0x7499,	0x749a,	0x749c,
	/* 44 57 */
	0x749f,	0x74a0,	0x74a1,	0x74a3,	0x74a6,	0x74a8,	0x74a9,	0x74aa,
	/* 44 65 */
	0x74ab,	0x74ae,	0x74af,	0x74b1,	0x74b2,	0x74b5,	0x74b9,	0x74bb,
	/* 44 73 */
	0x74bf,	0x74c8,	0x74c9,	0x74cc,	0x74d0,	0x74d3,	0x74d8,	0x74da,
	/* 44 81 */
	0x74db,	0x74de,	0x74df,	0x74e4,	0x74e8,	0x74ea,	0x74eb,	0x74ef,
	/* 44 89 */
	0x74f4,	0x74fa,	0x74fb,	0x74fc,	0x74ff,	0x7506,
	/* 45 01 */
	0x7512,	0x7516,	0x7517,	0x7520,	0x7521,	0x7524,	0x7527,	0x7529,
	/* 45 09 */
	0x752a,	0x752f,	0x7536,	0x7539,	0x753d,	0x753e,	0x753f,	0x7540,
	/* 45 17 */
	0x7543,	0x7547,	0x7548,	0x754e,	0x7550,	0x7552,	0x7557,	0x755e,
	/* 45 25 */
	0x755f,	0x7561,	0x756f,	0x7571,	0x7579,	0x757a,	0x757b,	0x757c,
	/* 45 33 */
	0x757d,	0x757e,	0x7581,	0x7585,	0x7590,	0x7592,	0x7593,	0x7595,
	/* 45 41 */
	0x7599,	0x759c,	0x75a2,	0x75a4,	0x75b4,	0x75ba,	0x75bf,	0x75c0,
	/* 45 49 */
	0x75c1,	0x75c4,	0x75c6,	0x75cc,	0x75ce,	0x75cf,	0x75d7,	0x75dc,
	/* 45 57 */
	0x75df,	0x75e0,	0x75e1,	0x75e4,	0x75e7,	0x75ec,	0x75ee,	0x75ef,
	/* 45 65 */
	0x75f1,	0x75f9,	0x7600,	0x7602,	0x7603,	0x7604,	0x7607,	0x7608,
	/* 45 73 */
	0x760a,	0x760c,	0x760f,	0x7612,	0x7613,	0x7615,	0x7616,	0x7619,
	/* 45 81 */
	0x761b,	0x761c,	0x761d,	0x761e,	0x7623,	0x7625,	0x7626,	0x7629,
	/* 45 89 */
	0x762d,	0x7632,	0x7633,	0x7635,	0x7638,	0x7639,
	/* 46 01 */
	0x763a,	0x763c,	0x764a,	0x7640,	0x7641,	0x7643,	0x7644,	0x7645,
	/* 46 09 */
	0x7649,	0x764b,	0x7655,	0x7659,	0x765f,	0x7664,	0x7665,	0x766d,
	/* 46 17 */
	0x766e,	0x766f,	0x7671,	0x7674,	0x7681,	0x7685,	0x768c,	0x768d,
	/* 46 25 */
	0x7695,	0x769b,	0x769c,	0x769d,	0x769f,	0x76a0,	0x76a2,	0x76a3,
	/* 46 33 */
	0x76a4,	0x76a5,	0x76a6,	0x76a7,	0x76a8,	0x76aa,	0x76ad,	0x76bd,
	/* 46 41 */
	0x76c1,	0x76c5,	0x76c9,	0x76cb,	0x76cc,	0x76ce,	0x76d4,	0x76d9,
	/* 46 49 */
	0x76e0,	0x76e6,	0x76e8,	0x76ec,	0x76f0,	0x76f1,	0x76f6,	0x76f9,
	/* 46 57 */
	0x76fc,	0x7700,	0x7706,	0x770a,	0x770e,	0x7712,	0x7714,	0x7715,
	/* 46 65 */
	0x7717,	0x7719,	0x771a,	0x771c,	0x7722,	0x7728,	0x772d,	0x772e,
	/* 46 73 */
	0x772f,	0x7734,	0x7735,	0x7736,	0x7739,	0x773d,	0x773e,	0x7742,
	/* 46 81 */
	0x7745,	0x7746,	0x774a,	0x774d,	0x774e,	0x774f,	0x7752,	0x7756,
	/* 46 89 */
	0x7757,	0x775c,	0x775e,	0x775f,	0x7760,	0x7762,
	/* 47 01 */
	0x7764,	0x7767,	0x776a,	0x776c,	0x7770,	0x7772,	0x7773,	0x7774,
	/* 47 09 */
	0x777a,	0x777d,	0x7780,	0x7784,	0x778c,	0x778d,	0x7794,	0x7795,
	/* 47 17 */
	0x7796,	0x779a,	0x779f,	0x77a2,	0x77a7,	0x77aa,	0x77ae,	0x77af,
	/* 47 25 */
	0x77b1,	0x77b5,	0x77be,	0x77c3,	0x77c9,	0x77d1,	0x77d2,	0x77d5,
	/* 47 33 */
	0x77d9,	0x77de,	0x77df,	0x77e0,	0x77e4,	0x77e6,	0x77ea,	0x77ec,
	/* 47 41 */
	0x77f0,	0x77f1,	0x77f4,	0x77f8,	0x77fb,	0x7805,	0x7806,	0x7809,
	/* 47 49 */
	0x780d,	0x780e,	0x7811,	0x781d,	0x7821,	0x7822,	0x7823,	0x782d,
	/* 47 57 */
	0x782e,	0x7830,	0x7835,	0x7837,	0x7843,	0x7844,	0x7847,	0x7848,
	/* 47 65 */
	0x784c,	0x784e,	0x7852,	0x785c,	0x785e,	0x7860,	0x7861,	0x7863,
	/* 47 73 */
	0x7864,	0x7868,	0x786a,	0x786e,	0x787a,	0x787e,	0x788a,	0x788f,
	/* 47 81 */
	0x7894,	0x7898,	0x78a1,	0x789d,	0x789e,	0x789f,	0x78a4,	0x78a8,
	/* 47 89 */
	0x78ac,	0x78ad,	0x78b0,	0x78b1,	0x78b2,	0x78b3,
	/* 48 01 */
	0x78bb,	0x78bd,	0x78bf,	0x78c7,	0x78c8,	0x78c9,	0x78cc,	0x78ce,
	/* 48 09 */
	0x78d2,	0x78d3,	0x78d5,	0x78d6,	0x78e4,	0x78db,	0x78df,	0x78e0,
	/* 48 17 */
	0x78e1,	0x78e6,	0x78ea,	0x78f2,	0x78f3,	0x7900,	0x78f6,	0x78f7,
	/* 48 25 */
	0x78fa,	0x78fb,	0x78ff,	0x7906,	0x790c,	0x7910,	0x791a,	0x791c,
	/* 48 33 */
	0x791e,	0x791f,	0x7920,	0x7925,	0x7927,	0x7929,	0x792d,	0x7931,
	/* 48 41 */
	0x7934,	0x7935,	0x793b,	0x793d,	0x793f,	0x7944,	0x7945,	0x7946,
	/* 48 49 */
	0x794a,	0x794b,	0x794f,	0x7951,	0x7954,	0x7958,	0x795b,	0x795c,
	/* 48 57 */
	0x7967,	0x7969,	0x796b,	0x7972,	0x7979,	0x797b,	0x797c,	0x797e,
	/* 48 65 */
	0x798b,	0x798c,	0x7991,	0x7993,	0x7994,	0x7995,	0x7996,	0x7998,
	/* 48 73 */
	0x799b,	0x799c,	0x79a1,	0x79a8,	0x79a9,	0x79ab,	0x79af,	0x79b1,
	/* 48 81 */
	0x79b4,	0x79b8,	0x79bb,	0x79c2,	0x79c4,	0x79c7,	0x79c8,	0x79ca,
	/* 48 89 */
	0x79cf,	0x79d4,	0x79d6,	0x79da,	0x79dd,	0x79de,
	/* 49 01 */
	0x79e0,	0x79e2,	0x79e5,	0x79ea,	0x79eb,	0x79ed,	0x79f1,	0x79f8,
	/* 49 09 */
	0x79fc,	0x7a02,	0x7a03,	0x7a07,	0x7a09,	0x7a0a,	0x7a0c,	0x7a11,
	/* 49 17 */
	0x7a15,	0x7a1b,	0x7a1e,	0x7a21,	0x7a27,	0x7a2b,	0x7a2d,	0x7a2f,
	/* 49 25 */
	0x7a30,	0x7a34,	0x7a35,	0x7a38,	0x7a39,	0x7a3a,	0x7a44,	0x7a45,
	/* 49 33 */
	0x7a47,	0x7a48,	0x7a4c,	0x7a55,	0x7a56,	0x7a59,	0x7a5c,	0x7a5d,
	/* 49 41 */
	0x7a5f,	0x7a60,	0x7a65,	0x7a67,	0x7a6a,	0x7a6d,	0x7a75,	0x7a78,
	/* 49 49 */
	0x7a7e,	0x7a80,	0x7a82,	0x7a85,	0x7a86,	0x7a8a,	0x7a8b,	0x7a90,
	/* 49 57 */
	0x7a91,	0x7a94,	0x7a9e,	0x7aa0,	0x7aa3,	0x7aac,	0x7ab3,	0x7ab5,
	/* 49 65 */
	0x7ab9,	0x7abb,	0x7abc,	0x7ac6,	0x7ac9,	0x7acc,	0x7ace,	0x7ad1,
	/* 49 73 */
	0x7adb,	0x7ae8,	0x7ae9,	0x7aeb,	0x7aec,	0x7af1,	0x7af4,	0x7afb,
	/* 49 81 */
	0x7afd,	0x7afe,	0x7b07,	0x7b14,	0x7b1f,	0x7b23,	0x7b27,	0x7b29,
	/* 49 89 */
	0x7b2a,	0x7b2b,	0x7b2d,	0x7b2e,	0x7b2f,	0x7b30,
	/* 50 01 */
	0x7b31,	0x7b34,	0x7b3d,	0x7b3f,	0x7b40,	0x7b41,	0x7b47,	0x7b4e,
	/* 50 09 */
	0x7b55,	0x7b60,	0x7b64,	0x7b66,	0x7b69,	0x7b6a,	0x7b6d,	0x7b6f,
	/* 50 17 */
	0x7b72,	0x7b73,	0x7b77,	0x7b84,	0x7b89,	0x7b8e,	0x7b90,	0x7b91,
	/* 50 25 */
	0x7b96,	0x7b9b,	0x7b9e,	0x7ba0,	0x7ba5,	0x7bac,	0x7baf,	0x7bb0,
	/* 50 33 */
	0x7bb2,	0x7bb5,	0x7bb6,	0x7bba,	0x7bbb,	0x7bbc,	0x7bbd,	0x7bc2,
	/* 50 41 */
	0x7bc5,	0x7bc8,	0x7bca,	0x7bd4,	0x7bd6,	0x7bd7,	0x7bd9,	0x7bda,
	/* 50 49 */
	0x7bdb,	0x7be8,	0x7bea,	0x7bf2,	0x7bf4,	0x7bf5,	0x7bf8,	0x7bf9,
	/* 50 57 */
	0x7bfa,	0x7bfc,	0x7bfe,	0x7c01,	0x7c02,	0x7c03,	0x7c04,	0x7c06,
	/* 50 65 */
	0x7c09,	0x7c0b,	0x7c0c,	0x7c0e,	0x7c0f,	0x7c19,	0x7c1b,	0x7c20,
	/* 50 73 */
	0x7c25,	0x7c26,	0x7c28,	0x7c2c,	0x7c31,	0x7c33,	0x7c34,	0x7c36,
	/* 50 81 */
	0x7c39,	0x7c3a,	0x7c46,	0x7c4a,	0x7c55,	0x7c51,	0x7c52,	0x7c53,
	/* 50 89 */
	0x7c59,	0x7c5a,	0x7c5b,	0x7c5c,	0x7c5d,	0x7c5e,
	/* 51 01 */
	0x7c61,	0x7c63,	0x7c67,	0x7c69,	0x7c6d,	0x7c6e,	0x7c70,	0x7c72,
	/* 51 09 */
	0x7c79,	0x7c7c,	0x7c7d,	0x7c86,	0x7c87,	0x7c8f,	0x7c94,	0x7c9e,
	/* 51 17 */
	0x7ca0,	0x7ca6,	0x7cb0,	0x7cb6,	0x7cb7,	0x7cba,	0x7cbb,	0x7cbc,
	/* 51 25 */
	0x7cbf,	0x7cc4,	0x7cc7,	0x7cc8,	0x7cc9,	0x7ccd,	0x7ccf,	0x7cd3,
	/* 51 33 */
	0x7cd4,	0x7cd5,	0x7cd7,	0x7cd9,	0x7cda,	0x7cdd,	0x7ce6,	0x7ce9,
	/* 51 41 */
	0x7ceb,	0x7cf5,	0x7d03,	0x7d07,	0x7d08,	0x7d09,	0x7d0f,	0x7d11,
	/* 51 49 */
	0x7d12,	0x7d13,	0x7d16,	0x7d1d,	0x7d1e,	0x7d23,	0x7d26,	0x7d2a,
	/* 51 57 */
	0x7d2d,	0x7d31,	0x7d3c,	0x7d3d,	0x7d3e,	0x7d40,	0x7d41,	0x7d47,
	/* 51 65 */
	0x7d48,	0x7d4d,	0x7d51,	0x7d53,	0x7d57,	0x7d59,	0x7d5a,	0x7d5c,
	/* 51 73 */
	0x7d5d,	0x7d65,	0x7d67,	0x7d6a,	0x7d70,	0x7d78,	0x7d7a,	0x7d7b,
	/* 51 81 */
	0x7d7f,	0x7d81,	0x7d82,	0x7d83,	0x7d85,	0x7d86,	0x7d88,	0x7d8b,
	/* 51 89 */
	0x7d8c,	0x7d8d,	0x7d91,	0x7d96,	0x7d97,	0x7d9d,
	/* 52 01 */
	0x7d9e,	0x7da6,	0x7da7,	0x7daa,	0x7db3,	0x7db6,	0x7db7,	0x7db9,
	/* 52 09 */
	0x7dc2,	0x7dc3,	0x7dc4,	0x7dc5,	0x7dc6,	0x7dcc,	0x7dcd,	0x7dce,
	/* 52 17 */
	0x7dd7,	0x7dd9,	0x7e00,	0x7de2,	0x7de5,	0x7de6,	0x7dea,	0x7deb,
	/* 52 25 */
	0x7ded,	0x7df1,	0x7df5,	0x7df6,	0x7df9,	0x7dfa,	0x7e08,	0x7e10,
	/* 52 33 */
	0x7e11,	0x7e15,	0x7e17,	0x7e1c,	0x7e1d,	0x7e20,	0x7e27,	0x7e28,
	/* 52 41 */
	0x7e2c,	0x7e2d,	0x7e2f,	0x7e33,	0x7e36,	0x7e3f,	0x7e44,	0x7e45,
	/* 52 49 */
	0x7e47,	0x7e4e,	0x7e50,	0x7e52,	0x7e58,	0x7e5f,	0x7e61,	0x7e62,
	/* 52 57 */
	0x7e65,	0x7e6b,	0x7e6e,	0x7e6f,	0x7e73,	0x7e78,	0x7e7e,	0x7e81,
	/* 52 65 */
	0x7e86,	0x7e87,	0x7e8a,	0x7e8d,	0x7e91,	0x7e95,	0x7e98,	0x7e9a,
	/* 52 73 */
	0x7e9d,	0x7e9e,	0x7f3c,	0x7f3b,	0x7f3d,	0x7f3e,	0x7f3f,	0x7f43,
	/* 52 81 */
	0x7f44,	0x7f47,	0x7f4f,	0x7f52,	0x7f53,	0x7f5b,	0x7f5c,	0x7f5d,
	/* 52 89 */
	0x7f61,	0x7f63,	0x7f64,	0x7f65,	0x7f66,	0x7f6d,
	/* 53 01 */
	0x7f71,	0x7f7d,	0x7f7e,	0x7f7f,	0x7f80,	0x7f8b,	0x7f8d,	0x7f8f,
	/* 53 09 */
	0x7f90,	0x7f91,	0x7f96,	0x7f97,	0x7f9c,	0x7fa1,	0x7fa2,	0x7fa6,
	/* 53 17 */
	0x7faa,	0x7fad,	0x7fb4,	0x7fbc,	0x7fbf,	0x7fc0,	0x7fc3,	0x7fc8,
	/* 53 25 */
	0x7fce,	0x7fcf,	0x7fdb,	0x7fdf,	0x7fe3,	0x7fe5,	0x7fe8,	0x7fec,
	/* 53 33 */
	0x7fee,	0x7fef,	0x7ff2,	0x7ffa,	0x7ffd,	0x7ffe,	0x7fff,	0x8007,
	/* 53 41 */
	0x8008,	0x800a,	0x800d,	0x800e,	0x800f,	0x8011,	0x8013,	0x8014,
	/* 53 49 */
	0x8016,	0x801d,	0x801e,	0x801f,	0x8020,	0x8024,	0x8026,	0x802c,
	/* 53 57 */
	0x802e,	0x8030,	0x8034,	0x8035,	0x8037,	0x8039,	0x803a,	0x803c,
	/* 53 65 */
	0x803e,	0x8040,	0x8044,	0x8060,	0x8064,	0x8066,	0x806d,	0x8071,
	/* 53 73 */
	0x8075,	0x8081,	0x8088,	0x808e,	0x809c,	0x809e,	0x80a6,	0x80a7,
	/* 53 81 */
	0x80ab,	0x80b8,	0x80b9,	0x80c8,	0x80cd,	0x80cf,	0x80d2,	0x80d4,
	/* 53 89 */
	0x80d5,	0x80d7,	0x80d8,	0x80e0,	0x80ed,	0x80ee,
	/* 54 01 */
	0x80f0,	0x80f2,	0x80f3,	0x80f6,	0x80f9,	0x80fa,	0x80fe,	0x8103,
	/* 54 09 */
	0x810b,	0x8116,	0x8117,	0x8118,	0x811c,	0x811e,	0x8120,	0x8124,
	/* 54 17 */
	0x8127,	0x812c,	0x8130,	0x8135,	0x813a,	0x813c,	0x8145,	0x8147,
	/* 54 25 */
	0x814a,	0x814c,	0x8152,	0x8157,	0x8160,	0x8161,	0x8167,	0x8168,
	/* 54 33 */
	0x8169,	0x816d,	0x816f,	0x8177,	0x8181,	0x8190,	0x8184,	0x8185,
	/* 54 41 */
	0x8186,	0x818b,	0x818e,	0x8196,	0x8198,	0x819b,	0x819e,	0x81a2,
	/* 54 49 */
	0x81ae,	0x81b2,	0x81b4,	0x81bb,	0x81cb,	0x81c3,	0x81c5,	0x81ca,
	/* 54 57 */
	0x81ce,	0x81cf,	0x81d5,	0x81d7,	0x81db,	0x81dd,	0x81de,	0x81e1,
	/* 54 65 */
	0x81e4,	0x81eb,	0x81ec,	0x81f0,	0x81f1,	0x81f2,	0x81f5,	0x81f6,
	/* 54 73 */
	0x81f8,	0x81f9,	0x81fd,	0x81ff,	0x8200,	0x8203,	0x820f,	0x8213,
	/* 54 81 */
	0x8214,	0x8219,	0x821a,	0x821d,	0x8221,	0x8222,	0x8228,	0x8232,
	/* 54 89 */
	0x8234,	0x823a,	0x8243,	0x8244,	0x8245,	0x8246,
	/* 55 01 */
	0x824b,	0x824e,	0x824f,	0x8251,	0x8256,	0x825c,	0x8260,	0x8263,
	/* 55 09 */
	0x8267,	0x826d,	0x8274,	0x827b,	0x827d,	0x827f,	0x8280,	0x8281,
	/* 55 17 */
	0x8283,	0x8284,	0x8287,	0x8289,	0x828a,	0x828e,	0x8291,	0x8294,
	/* 55 25 */
	0x8296,	0x8298,	0x829a,	0x829b,	0x82a0,	0x82a1,	0x82a3,	0x82a4,
	/* 55 33 */
	0x82a7,	0x82a8,	0x82a9,	0x82aa,	0x82ae,	0x82b0,	0x82b2,	0x82b4,
	/* 55 41 */
	0x82b7,	0x82ba,	0x82bc,	0x82be,	0x82bf,	0x82c6,	0x82d0,	0x82d5,
	/* 55 49 */
	0x82da,	0x82e0,	0x82e2,	0x82e4,	0x82e8,	0x82ea,	0x82ed,	0x82ef,
	/* 55 57 */
	0x82f6,	0x82f7,	0x82fd,	0x82fe,	0x8300,	0x8301,	0x8307,	0x8308,
	/* 55 65 */
	0x830a,	0x830b,	0x8354,	0x831b,	0x831d,	0x831e,	0x831f,	0x8321,
	/* 55 73 */
	0x8322,	0x832c,	0x832d,	0x832e,	0x8330,	0x8333,	0x8337,	0x833a,
	/* 55 81 */
	0x833c,	0x833d,	0x8342,	0x8343,	0x8344,	0x8347,	0x834d,	0x834e,
	/* 55 89 */
	0x8351,	0x8355,	0x8356,	0x8357,	0x8370,	0x8378,
	/* 56 01 */
	0x837d,	0x837f,	0x8380,	0x8382,	0x8384,	0x8386,	0x838d,	0x8392,
	/* 56 09 */
	0x8394,	0x8395,	0x8398,	0x8399,	0x839b,	0x839c,	0x839d,	0x83a6,
	/* 56 17 */
	0x83a7,	0x83a9,	0x83ac,	0x83be,	0x83bf,	0x83c0,	0x83c7,	0x83c9,
	/* 56 25 */
	0x83cf,	0x83d0,	0x83d1,	0x83d4,	0x83dd,	0x8353,	0x83e8,	0x83ea,
	/* 56 33 */
	0x83f6,	0x83f8,	0x83f9,	0x83fc,	0x8401,	0x8406,	0x840a,	0x840f,
	/* 56 41 */
	0x8411,	0x8415,	0x8419,	0x83ad,	0x842f,	0x8439,	0x8445,	0x8447,
	/* 56 49 */
	0x8448,	0x844a,	0x844d,	0x844f,	0x8451,	0x8452,	0x8456,	0x8458,
	/* 56 57 */
	0x8459,	0x845a,	0x845c,	0x8460,	0x8464,	0x8465,	0x8467,	0x846a,
	/* 56 65 */
	0x8470,	0x8473,	0x8474,	0x8476,	0x8478,	0x847c,	0x847d,	0x8481,
	/* 56 73 */
	0x8485,	0x8492,	0x8493,	0x8495,	0x849e,	0x84a6,	0x84a8,	0x84a9,
	/* 56 81 */
	0x84aa,	0x84af,	0x84b1,	0x84b4,	0x84ba,	0x84bd,	0x84be,	0x84c0,
	/* 56 89 */
	0x84c2,	0x84c7,	0x84c8,	0x84cc,	0x84cf,	0x84d3,
	/* 57 01 */
	0x84dc,	0x84e7,	0x84ea,	0x84ef,	0x84f0,	0x84f1,	0x84f2,	0x84f7,
	/* 57 09 */
	0x8532,	0x84fa,	0x84fb,	0x84fd,	0x8502,	0x8503,	0x8507,	0x850c,
	/* 57 17 */
	0x850e,	0x8510,	0x851c,	0x851e,	0x8522,	0x8523,	0x8524,	0x8525,
	/* 57 25 */
	0x8527,	0x852a,	0x852b,	0x852f,	0x8533,	0x8534,	0x8536,	0x853f,
	/* 57 33 */
	0x8546,	0x854f,	0x8550,	0x8551,	0x8552,	0x8553,	0x8556,	0x8559,
	/* 57 41 */
	0x855c,	0x855d,	0x855e,	0x855f,	0x8560,	0x8561,	0x8562,	0x8564,
	/* 57 49 */
	0x856b,	0x856f,	0x8579,	0x857a,	0x857b,	0x857d,	0x857f,	0x8581,
	/* 57 57 */
	0x8585,	0x8586,	0x8589,	0x858b,	0x858c,	0x858f,	0x8593,	0x8598,
	/* 57 65 */
	0x859d,	0x859f,	0x85a0,	0x85a2,	0x85a5,	0x85a7,	0x85b4,	0x85b6,
	/* 57 73 */
	0x85b7,	0x85b8,	0x85bc,	0x85bd,	0x85be,	0x85bf,	0x85c2,	0x85c7,
	/* 57 81 */
	0x85ca,	0x85cb,	0x85ce,	0x85ad,	0x85d8,	0x85da,	0x85df,	0x85e0,
	/* 57 89 */
	0x85e6,	0x85e8,	0x85ed,	0x85f3,	0x85f6,	0x85fc,
	/* 58 01 */
	0x85ff,	0x8600,	0x8604,	0x8605,	0x860d,	0x860e,	0x8610,	0x8611,
	/* 58 09 */
	0x8612,	0x8618,	0x8619,	0x861b,	0x861e,	0x8621,	0x8627,	0x8629,
	/* 58 17 */
	0x8636,	0x8638,	0x863a,	0x863c,	0x863d,	0x8640,	0x8642,	0x8646,
	/* 58 25 */
	0x8652,	0x8653,	0x8656,	0x8657,	0x8658,	0x8659,	0x865d,	0x8660,
	/* 58 33 */
	0x8661,	0x8662,	0x8663,	0x8664,	0x8669,	0x866c,	0x866f,	0x8675,
	/* 58 41 */
	0x8676,	0x8677,	0x867a,	0x868d,	0x8691,	0x8696,	0x8698,	0x869a,
	/* 58 49 */
	0x869c,	0x86a1,	0x86a6,	0x86a7,	0x86a8,	0x86ad,	0x86b1,	0x86b3,
	/* 58 57 */
	0x86b4,	0x86b5,	0x86b7,	0x86b8,	0x86b9,	0x86bf,	0x86c0,	0x86c1,
	/* 58 65 */
	0x86c3,	0x86c5,	0x86d1,	0x86d2,	0x86d5,	0x86d7,	0x86da,	0x86dc,
	/* 58 73 */
	0x86e0,	0x86e3,	0x86e5,	0x86e7,	0x8688,	0x86fa,	0x86fc,	0x86fd,
	/* 58 81 */
	0x8704,	0x8705,	0x8707,	0x870b,	0x870e,	0x870f,	0x8710,	0x8713,
	/* 58 89 */
	0x8714,	0x8719,	0x871e,	0x871f,	0x8721,	0x8723,
	/* 59 01 */
	0x8728,	0x872e,	0x872f,	0x8731,	0x8732,	0x8739,	0x873a,	0x873c,
	/* 59 09 */
	0x873d,	0x873e,	0x8740,	0x8743,	0x8745,	0x874d,	0x8758,	0x875d,
	/* 59 17 */
	0x8761,	0x8764,	0x8765,	0x876f,	0x8771,	0x8772,	0x877b,	0x8783,
	/* 59 25 */
	0x8784,	0x8785,	0x8786,	0x8787,	0x8788,	0x8789,	0x878b,	0x878c,
	/* 59 33 */
	0x8790,	0x8793,	0x8795,	0x8797,	0x8798,	0x8799,	0x879e,	0x87a0,
	/* 59 41 */
	0x87a3,	0x87a7,	0x87ac,	0x87ad,	0x87ae,	0x87b1,	0x87b5,	0x87be,
	/* 59 49 */
	0x87bf,	0x87c1,	0x87c8,	0x87c9,	0x87ca,	0x87ce,	0x87d5,	0x87d6,
	/* 59 57 */
	0x87d9,	0x87da,	0x87dc,	0x87df,	0x87e2,	0x87e3,	0x87e4,	0x87ea,
	/* 59 65 */
	0x87eb,	0x87ed,	0x87f1,	0x87f3,	0x87f8,	0x87fa,	0x87ff,	0x8801,
	/* 59 73 */
	0x8803,	0x8806,	0x8809,	0x880a,	0x880b,	0x8810,	0x8819,	0x8812,
	/* 59 81 */
	0x8813,	0x8814,	0x8818,	0x881a,	0x881b,	0x881c,	0x881e,	0x881f,
	/* 59 89 */
	0x8828,	0x882d,	0x882e,	0x8830,	0x8832,	0x8835,
	/* 60 01 */
	0x883a,	0x883c,	0x8841,	0x8843,	0x8845,	0x8848,	0x8849,	0x884a,
	/* 60 09 */
	0x884b,	0x884e,	0x8851,	0x8855,	0x8856,	0x8858,	0x885a,	0x885c,
	/* 60 17 */
	0x885f,	0x8860,	0x8864,	0x8869,	0x8871,	0x8879,	0x887b,	0x8880,
	/* 60 25 */
	0x8898,	0x889a,	0x889b,	0x889c,	0x889f,	0x88a0,	0x88a8,	0x88aa,
	/* 60 33 */
	0x88ba,	0x88bd,	0x88be,	0x88c0,	0x88ca,	0x88cb,	0x88cc,	0x88cd,
	/* 60 41 */
	0x88ce,	0x88d1,	0x88d2,	0x88d3,	0x88db,	0x88de,	0x88e7,	0x88ef,
	/* 60 49 */
	0x88f0,	0x88f1,	0x88f5,	0x88f7,	0x8901,	0x8906,	0x890d,	0x890e,
	/* 60 57 */
	0x890f,	0x8915,	0x8916,	0x8918,	0x8919,	0x891a,	0x891c,	0x8920,
	/* 60 65 */
	0x8926,	0x8927,	0x8928,	0x8930,	0x8931,	0x8932,	0x8935,	0x8939,
	/* 60 73 */
	0x893a,	0x893e,	0x8940,	0x8942,	0x8945,	0x8946,	0x8949,	0x894f,
	/* 60 81 */
	0x8952,	0x8957,	0x895a,	0x895b,	0x895c,	0x8961,	0x8962,	0x8963,
	/* 60 89 */
	0x896b,	0x896e,	0x8970,	0x8973,	0x8975,	0x897a,
	/* 61 01 */
	0x897b,	0x897c,	0x897d,	0x8989,	0x898d,	0x8990,	0x8994,	0x8995,
	/* 61 09 */
	0x899b,	0x899c,	0x899f,	0x89a0,	0x89a5,	0x89b0,	0x89b4,	0x89b5,
	/* 61 17 */
	0x89b6,	0x89b7,	0x89bc,	0x89d4,	0x89d5,	0x89d6,	0x89d7,	0x89d8,
	/* 61 25 */
	0x89e5,	0x89e9,	0x89eb,	0x89ed,	0x89f1,	0x89f3,	0x89f6,	0x89f9,
	/* 61 33 */
	0x89fd,	0x89ff,	0x8a04,	0x8a05,	0x8a07,	0x8a0f,	0x8a11,	0x8a12,
	/* 61 41 */
	0x8a14,	0x8a15,	0x8a1e,	0x8a20,	0x8a22,	0x8a24,	0x8a26,	0x8a2b,
	/* 61 49 */
	0x8a2c,	0x8a2f,	0x8a35,	0x8a37,	0x8a3d,	0x8a3e,	0x8a40,	0x8a43,
	/* 61 57 */
	0x8a45,	0x8a47,	0x8a49,	0x8a4d,	0x8a4e,	0x8a53,	0x8a56,	0x8a57,
	/* 61 65 */
	0x8a58,	0x8a5c,	0x8a5d,	0x8a61,	0x8a65,	0x8a67,	0x8a75,	0x8a76,
	/* 61 73 */
	0x8a77,	0x8a79,	0x8a7a,	0x8a7b,	0x8a7e,	0x8a7f,	0x8a80,	0x8a83,
	/* 61 81 */
	0x8a86,	0x8a8b,	0x8a8f,	0x8a90,	0x8a92,	0x8a96,	0x8a97,	0x8a99,
	/* 61 89 */
	0x8a9f,	0x8aa7,	0x8aa9,	0x8aae,	0x8aaf,	0x8ab3,
	/* 62 01 */
	0x8ab6,	0x8ab7,	0x8abb,	0x8abe,	0x8ac3,	0x8ac6,	0x8ac8,	0x8ac9,
	/* 62 09 */
	0x8aca,	0x8ad1,	0x8ad3,	0x8ad4,	0x8ad5,	0x8ad7,	0x8add,	0x8adf,
	/* 62 17 */
	0x8aec,	0x8af0,	0x8af4,	0x8af5,	0x8af6,	0x8afc,	0x8aff,	0x8b05,
	/* 62 25 */
	0x8b06,	0x8b0b,	0x8b11,	0x8b1c,	0x8b1e,	0x8b1f,	0x8b0a,	0x8b2d,
	/* 62 33 */
	0x8b30,	0x8b37,	0x8b3c,	0x8b42,	0x8b43,	0x8b44,	0x8b45,	0x8b46,
	/* 62 41 */
	0x8b48,	0x8b52,	0x8b53,	0x8b54,	0x8b59,	0x8b4d,	0x8b5e,	0x8b63,
	/* 62 49 */
	0x8b6d,	0x8b76,	0x8b78,	0x8b79,	0x8b7c,	0x8b7e,	0x8b81,	0x8b84,
	/* 62 57 */
	0x8b85,	0x8b8b,	0x8b8d,	0x8b8f,	0x8b94,	0x8b95,	0x8b9c,	0x8b9e,
	/* 62 65 */
	0x8b9f,	0x8c38,	0x8c39,	0x8c3d,	0x8c3e,	0x8c45,	0x8c47,	0x8c49,
	/* 62 73 */
	0x8c4b,	0x8c4f,	0x8c51,	0x8c53,	0x8c54,	0x8c57,	0x8c58,	0x8c5b,
	/* 62 81 */
	0x8c5d,	0x8c59,	0x8c63,	0x8c64,	0x8c66,	0x8c68,	0x8c69,	0x8c6d,
	/* 62 89 */
	0x8c73,	0x8c75,	0x8c76,	0x8c7b,	0x8c7e,	0x8c86,
	/* 63 01 */
	0x8c87,	0x8c8b,	0x8c90,	0x8c92,	0x8c93,	0x8c99,	0x8c9b,	0x8c9c,
	/* 63 09 */
	0x8ca4,	0x8cb9,	0x8cba,	0x8cc5,	0x8cc6,	0x8cc9,	0x8ccb,	0x8ccf,
	/* 63 17 */
	0x8cd6,	0x8cd5,	0x8cd9,	0x8cdd,	0x8ce1,	0x8ce8,	0x8cec,	0x8cef,
	/* 63 25 */
	0x8cf0,	0x8cf2,	0x8cf5,	0x8cf7,	0x8cf8,	0x8cfe,	0x8cff,	0x8d01,
	/* 63 33 */
	0x8d03,	0x8d09,	0x8d12,	0x8d17,	0x8d1b,	0x8d65,	0x8d69,	0x8d6c,
	/* 63 41 */
	0x8d6e,	0x8d7f,	0x8d82,	0x8d84,	0x8d88,	0x8d8d,	0x8d90,	0x8d91,
	/* 63 49 */
	0x8d95,	0x8d9e,	0x8d9f,	0x8da0,	0x8da6,	0x8dab,	0x8dac,	0x8daf,
	/* 63 57 */
	0x8db2,	0x8db5,	0x8db7,	0x8db9,	0x8dbb,	0x8dc0,	0x8dc5,	0x8dc6,
	/* 63 65 */
	0x8dc7,	0x8dc8,	0x8dca,	0x8dce,	0x8dd1,	0x8dd4,	0x8dd5,	0x8dd7,
	/* 63 73 */
	0x8dd9,	0x8de4,	0x8de5,	0x8de7,	0x8dec,	0x8df0,	0x8dbc,	0x8df1,
	/* 63 81 */
	0x8df2,	0x8df4,	0x8dfd,	0x8e01,	0x8e04,	0x8e05,	0x8e06,	0x8e0b,
	/* 63 89 */
	0x8e11,	0x8e14,	0x8e16,	0x8e20,	0x8e21,	0x8e22,
	/* 64 01 */
	0x8e23,	0x8e26,	0x8e27,	0x8e31,	0x8e33,	0x8e36,	0x8e37,	0x8e38,
	/* 64 09 */
	0x8e39,	0x8e3d,	0x8e40,	0x8e41,	0x8e4b,	0x8e4d,	0x8e4e,	0x8e4f,
	/* 64 17 */
	0x8e54,	0x8e5b,	0x8e5c,	0x8e5d,	0x8e5e,	0x8e61,	0x8e62,	0x8e69,
	/* 64 25 */
	0x8e6c,	0x8e6d,	0x8e6f,	0x8e70,	0x8e71,	0x8e79,	0x8e7a,	0x8e7b,
	/* 64 33 */
	0x8e82,	0x8e83,	0x8e89,	0x8e90,	0x8e92,	0x8e95,	0x8e9a,	0x8e9b,
	/* 64 41 */
	0x8e9d,	0x8e9e,	0x8ea2,	0x8ea7,	0x8ea9,	0x8ead,	0x8eae,	0x8eb3,
	/* 64 49 */
	0x8eb5,	0x8eba,	0x8ebb,	0x8ec0,	0x8ec1,	0x8ec3,	0x8ec4,	0x8ec7,
	/* 64 57 */
	0x8ecf,	0x8ed1,	0x8ed4,	0x8edc,	0x8ee8,	0x8eee,	0x8ef0,	0x8ef1,
	/* 64 65 */
	0x8ef7,	0x8ef9,	0x8efa,	0x8eed,	0x8f00,	0x8f02,	0x8f07,	0x8f08,
	/* 64 73 */
	0x8f0f,	0x8f10,	0x8f16,	0x8f17,	0x8f18,	0x8f1e,	0x8f20,	0x8f21,
	/* 64 81 */
	0x8f23,	0x8f25,	0x8f27,	0x8f28,	0x8f2c,	0x8f2d,	0x8f2e,	0x8f34,
	/* 64 89 */
	0x8f35,	0x8f36,	0x8f37,	0x8f3a,	0x8f40,	0x8f41,
	/* 65 01 */
	0x8f43,	0x8f47,	0x8f4f,	0x8f51,	0x8f52,	0x8f53,	0x8f54,	0x8f55,
	/* 65 09 */
	0x8f58,	0x8f5d,	0x8f5e,	0x8f65,	0x8f9d,	0x8fa0,	0x8fa1,	0x8fa4,
	/* 65 17 */
	0x8fa5,	0x8fa6,	0x8fb5,	0x8fb6,	0x8fb8,	0x8fbe,	0x8fc0,	0x8fc1,
	/* 65 25 */
	0x8fc6,	0x8fca,	0x8fcb,	0x8fcd,	0x8fd0,	0x8fd2,	0x8fd3,	0x8fd5,
	/* 65 33 */
	0x8fe0,	0x8fe3,	0x8fe4,	0x8fe8,	0x8fee,	0x8ff1,	0x8ff5,	0x8ff6,
	/* 65 41 */
	0x8ffb,	0x8ffe,	0x9002,	0x9004,	0x9008,	0x900c,	0x9018,	0x901b,
	/* 65 49 */
	0x9028,	0x9029,	0x902f,	0x902a,	0x902c,	0x902d,	0x9033,	0x9034,
	/* 65 57 */
	0x9037,	0x903f,	0x9043,	0x9044,	0x904c,	0x905b,	0x905d,	0x9062,
	/* 65 65 */
	0x9066,	0x9067,	0x906c,	0x9070,	0x9074,	0x9079,	0x9085,	0x9088,
	/* 65 73 */
	0x908b,	0x908c,	0x908e,	0x9090,	0x9095,	0x9097,	0x9098,	0x9099,
	/* 65 81 */
	0x909b,	0x90a0,	0x90a1,	0x90a2,	0x90a5,	0x90b0,	0x90b2,	0x90b3,
	/* 65 89 */
	0x90b4,	0x90b6,	0x90bd,	0x90cc,	0x90be,	0x90c3,
	/* 66 01 */
	0x90c4,	0x90c5,	0x90c7,	0x90c8,	0x90d5,	0x90d7,	0x90d8,	0x90d9,
	/* 66 09 */
	0x90dc,	0x90dd,	0x90df,	0x90e5,	0x90d2,	0x90f6,	0x90eb,	0x90ef,
	/* 66 17 */
	0x90f0,	0x90f4,	0x90fe,	0x90ff,	0x9100,	0x9104,	0x9105,	0x9106,
	/* 66 25 */
	0x9108,	0x910d,	0x9110,	0x9114,	0x9116,	0x9117,	0x9118,	0x911a,
	/* 66 33 */
	0x911c,	0x911e,	0x9120,	0x9125,	0x9122,	0x9123,	0x9127,	0x9129,
	/* 66 41 */
	0x912e,	0x912f,	0x9131,	0x9134,	0x9136,	0x9137,	0x9139,	0x913a,
	/* 66 49 */
	0x913c,	0x913d,	0x9143,	0x9147,	0x9148,	0x914f,	0x9153,	0x9157,
	/* 66 57 */
	0x9159,	0x915a,	0x915b,	0x9161,	0x9164,	0x9167,	0x916d,	0x9174,
	/* 66 65 */
	0x9179,	0x917a,	0x917b,	0x9181,	0x9183,	0x9185,	0x9186,	0x918a,
	/* 66 73 */
	0x918e,	0x9191,	0x9193,	0x9194,	0x9195,	0x9198,	0x919e,	0x91a1,
	/* 66 81 */
	0x91a6,	0x91a8,	0x91ac,	0x91ad,	0x91ae,	0x91b0,	0x91b1,	0x91b2,
	/* 66 89 */
	0x91b3,	0x91b6,	0x91bb,	0x91bc,	0x91bd,	0x91bf,
	/* 67 01 */
	0x91c2,	0x91c3,	0x91c5,	0x91d3,	0x91d4,	0x91d7,	0x91d9,	0x91da,
	/* 67 09 */
	0x91de,	0x91e4,	0x91e5,	0x91e9,	0x91ea,	0x91ec,	0x91ed,	0x91ee,
	/* 67 17 */
	0x91ef,	0x91f0,	0x91f1,	0x91f7,	0x91f9,	0x91fb,	0x91fd,	0x9200,
	/* 67 25 */
	0x9201,	0x9204,	0x9205,	0x9206,	0x9207,	0x9209,	0x920a,	0x920c,
	/* 67 33 */
	0x9210,	0x9212,	0x9213,	0x9216,	0x9218,	0x921c,	0x921d,	0x9223,
	/* 67 41 */
	0x9224,	0x9225,	0x9226,	0x9228,	0x922e,	0x922f,	0x9230,	0x9233,
	/* 67 49 */
	0x9235,	0x9236,	0x9238,	0x9239,	0x923a,	0x923c,	0x923e,	0x9240,
	/* 67 57 */
	0x9242,	0x9243,	0x9246,	0x9247,	0x924a,	0x924d,	0x924e,	0x924f,
	/* 67 65 */
	0x9251,	0x9258,	0x9259,	0x925c,	0x925d,	0x9260,	0x9261,	0x9265,
	/* 67 73 */
	0x9267,	0x9268,	0x9269,	0x926e,	0x926f,	0x9270,	0x9275,	0x9276,
	/* 67 81 */
	0x9277,	0x9278,	0x9279,	0x927b,	0x927c,	0x927d,	0x927f,	0x9288,
	/* 67 89 */
	0x9289,	0x928a,	0x928d,	0x928e,	0x9292,	0x9297,
	/* 68 01 */
	0x9299,	0x929f,	0x92a0,	0x92a4,	0x92a5,	0x92a7,	0x92a8,	0x92ab,
	/* 68 09 */
	0x92af,	0x92b2,	0x92b6,	0x92b8,	0x92ba,	0x92bb,	0x92bc,	0x92bd,
	/* 68 17 */
	0x92bf,	0x92c0,	0x92c1,	0x92c2,	0x92c3,	0x92c5,	0x92c6,	0x92c7,
	/* 68 25 */
	0x92c8,	0x92cb,	0x92cc,	0x92cd,	0x92ce,	0x92d0,	0x92d3,	0x92d5,
	/* 68 33 */
	0x92d7,	0x92d8,	0x92d9,	0x92dc,	0x92dd,	0x92df,	0x92e0,	0x92e1,
	/* 68 41 */
	0x92e3,	0x92e5,	0x92e7,	0x92e8,	0x92ec,	0x92ee,	0x92f0,	0x92f9,
	/* 68 49 */
	0x92fb,	0x92ff,	0x9300,	0x9302,	0x9308,	0x930d,	0x9311,	0x9314,
	/* 68 57 */
	0x9315,	0x931c,	0x931d,	0x931e,	0x931f,	0x9321,	0x9324,	0x9325,
	/* 68 65 */
	0x9327,	0x9329,	0x932a,	0x9333,	0x9334,	0x9336,	0x9337,	0x9347,
	/* 68 73 */
	0x9348,	0x9349,	0x9350,	0x9351,	0x9352,	0x9355,	0x9357,	0x9358,
	/* 68 81 */
	0x935a,	0x935e,	0x9364,	0x9365,	0x9367,	0x9369,	0x936a,	0x936d,
	/* 68 89 */
	0x936f,	0x9370,	0x9371,	0x9373,	0x9374,	0x9376,
	/* 69 01 */
	0x937a,	0x937d,	0x937f,	0x9380,	0x9381,	0x9382,	0x9388,	0x938a,
	/* 69 09 */
	0x938b,	0x938d,	0x938f,	0x9392,	0x9395,	0x9398,	0x939b,	0x939e,
	/* 69 17 */
	0x93a1,	0x93a3,	0x93a4,	0x93a6,	0x93a8,	0x93ab,	0x93b4,	0x93b5,
	/* 69 25 */
	0x93b6,	0x93ba,	0x93a9,	0x93c1,	0x93c4,	0x93c5,	0x93c6,	0x93c7,
	/* 69 33 */
	0x93c9,	0x93ca,	0x93cb,	0x93cc,	0x93cd,	0x93d3,	0x93d9,	0x93dc,
	/* 69 41 */
	0x93de,	0x93df,	0x93e2,	0x93e6,	0x93e7,	0x93f9,	0x93f7,	0x93f8,
	/* 69 49 */
	0x93fa,	0x93fb,	0x93fd,	0x9401,	0x9402,	0x9404,	0x9408,	0x9409,
	/* 69 57 */
	0x940d,	0x940e,	0x940f,	0x9415,	0x9416,	0x9417,	0x941f,	0x942e,
	/* 69 65 */
	0x942f,	0x9431,	0x9432,	0x9433,	0x9434,	0x943b,	0x943f,	0x943d,
	/* 69 73 */
	0x9443,	0x9445,	0x9448,	0x944a,	0x944c,	0x9455,	0x9459,	0x945c,
	/* 69 81 */
	0x945f,	0x9461,	0x9463,	0x9468,	0x946b,	0x946d,	0x946e,	0x946f,
	/* 69 89 */
	0x9471,	0x9472,	0x9484,	0x9483,	0x9578,	0x9579,
	/* 70 01 */
	0x957e,	0x9584,	0x9588,	0x958c,	0x958d,	0x958e,	0x959d,	0x959e,
	/* 70 09 */
	0x959f,	0x95a1,	0x95a6,	0x95a9,	0x95ab,	0x95ac,	0x95b4,	0x95b6,
	/* 70 17 */
	0x95ba,	0x95bd,	0x95bf,	0x95c6,	0x95c8,	0x95c9,	0x95cb,	0x95d0,
	/* 70 25 */
	0x95d1,	0x95d2,	0x95d3,	0x95d9,	0x95da,	0x95dd,	0x95de,	0x95df,
	/* 70 33 */
	0x95e0,	0x95e4,	0x95e6,	0x961d,	0x961e,	0x9622,	0x9624,	0x9625,
	/* 70 41 */
	0x9626,	0x962c,	0x9631,	0x9633,	0x9637,	0x9638,	0x9639,	0x963a,
	/* 70 49 */
	0x963c,	0x963d,	0x9641,	0x9652,	0x9654,	0x9656,	0x9657,	0x9658,
	/* 70 57 */
	0x9661,	0x966e,	0x9674,	0x967b,	0x967c,	0x967e,	0x967f,	0x9681,
	/* 70 65 */
	0x9682,	0x9683,	0x9684,	0x9689,	0x9691,	0x9696,	0x969a,	0x969d,
	/* 70 73 */
	0x969f,	0x96a4,	0x96a5,	0x96a6,	0x96a9,	0x96ae,	0x96af,	0x96b3,
	/* 70 81 */
	0x96ba,	0x96ca,	0x96d2,	0x5db2,	0x96d8,	0x96da,	0x96dd,	0x96de,
	/* 70 89 */
	0x96df,	0x96e9,	0x96ef,	0x96f1,	0x96fa,	0x9702,
	/* 71 01 */
	0x9703,	0x9705,	0x9709,	0x971a,	0x971b,	0x971d,	0x9721,	0x9722,
	/* 71 09 */
	0x9723,	0x9728,	0x9731,	0x9733,	0x9741,	0x9743,	0x974a,	0x974e,
	/* 71 17 */
	0x974f,	0x9755,	0x9757,	0x9758,	0x975a,	0x975b,	0x9763,	0x9767,
	/* 71 25 */
	0x976a,	0x976e,	0x9773,	0x9776,	0x9777,	0x9778,	0x977b,	0x977d,
	/* 71 33 */
	0x977f,	0x9780,	0x9789,	0x9795,	0x9796,	0x9797,	0x9799,	0x979a,
	/* 71 41 */
	0x979e,	0x979f,	0x97a2,	0x97ac,	0x97ae,	0x97b1,	0x97b2,	0x97b5,
	/* 71 49 */
	0x97b6,	0x97b8,	0x97b9,	0x97ba,	0x97bc,	0x97be,	0x97bf,	0x97c1,
	/* 71 57 */
	0x97c4,	0x97c5,	0x97c7,	0x97c9,	0x97ca,	0x97cc,	0x97cd,	0x97ce,
	/* 71 65 */
	0x97d0,	0x97d1,	0x97d4,	0x97d7,	0x97d8,	0x97d9,	0x97dd,	0x97de,
	/* 71 73 */
	0x97e0,	0x97db,	0x97e1,	0x97e4,	0x97ef,	0x97f1,	0x97f4,	0x97f7,
	/* 71 81 */
	0x97f8,	0x97fa,	0x9807,	0x980a,	0x9819,	0x980d,	0x980e,	0x9814,
	/* 71 89 */
	0x9816,	0x981c,	0x981e,	0x9820,	0x9823,	0x9826,
	/* 72 01 */
	0x982b,	0x982e,	0x982f,	0x9830,	0x9832,	0x9833,	0x9835,	0x9825,
	/* 72 09 */
	0x983e,	0x9844,	0x9847,	0x984a,	0x9851,	0x9852,	0x9853,	0x9856,
	/* 72 17 */
	0x9857,	0x9859,	0x985a,	0x9862,	0x9863,	0x9865,	0x9866,	0x986a,
	/* 72 25 */
	0x986c,	0x98ab,	0x98ad,	0x98ae,	0x98b0,	0x98b4,	0x98b7,	0x98b8,
	/* 72 33 */
	0x98ba,	0x98bb,	0x98bf,	0x98c2,	0x98c5,	0x98c8,	0x98cc,	0x98e1,
	/* 72 41 */
	0x98e3,	0x98e5,	0x98e6,	0x98e7,	0x98ea,	0x98f3,	0x98f6,	0x9902,
	/* 72 49 */
	0x9907,	0x9908,	0x9911,	0x9915,	0x9916,	0x9917,	0x991a,	0x991b,
	/* 72 57 */
	0x991c,	0x991f,	0x9922,	0x9926,	0x9927,	0x992b,	0x9931,	0x9932,
	/* 72 65 */
	0x9933,	0x9934,	0x9935,	0x9939,	0x993a,	0x993b,	0x993c,	0x9940,
	/* 72 73 */
	0x9941,	0x9946,	0x9947,	0x9948,	0x994d,	0x994e,	0x9954,	0x9958,
	/* 72 81 */
	0x9959,	0x995b,	0x995c,	0x995e,	0x995f,	0x9960,	0x999b,	0x999d,
	/* 72 89 */
	0x999f,	0x99a6,	0x99b0,	0x99b1,	0x99b2,	0x99b5,
	/* 73 01 */
	0x99b9,	0x99ba,	0x99bd,	0x99bf,	0x99c3,	0x99c9,	0x99d3,	0x99d4,
	/* 73 09 */
	0x99d9,	0x99da,	0x99dc,	0x99de,	0x99e7,	0x99ea,	0x99eb,	0x99ec,
	/* 73 17 */
	0x99f0,	0x99f4,	0x99f5,	0x99f9,	0x99fd,	0x99fe,	0x9a02,	0x9a03,
	/* 73 25 */
	0x9a04,	0x9a0b,	0x9a0c,	0x9a10,	0x9a11,	0x9a16,	0x9a1e,	0x9a20,
	/* 73 33 */
	0x9a22,	0x9a23,	0x9a24,	0x9a27,	0x9a2d,	0x9a2e,	0x9a33,	0x9a35,
	/* 73 41 */
	0x9a36,	0x9a38,	0x9a47,	0x9a41,	0x9a44,	0x9a4a,	0x9a4b,	0x9a4c,
	/* 73 49 */
	0x9a4e,	0x9a51,	0x9a54,	0x9a56,	0x9a5d,	0x9aaa,	0x9aac,	0x9aae,
	/* 73 57 */
	0x9aaf,	0x9ab2,	0x9ab4,	0x9ab5,	0x9ab6,	0x9ab9,	0x9abb,	0x9abe,
	/* 73 65 */
	0x9abf,	0x9ac1,	0x9ac3,	0x9ac6,	0x9ac8,	0x9ace,	0x9ad0,	0x9ad2,
	/* 73 73 */
	0x9ad5,	0x9ad6,	0x9ad7,	0x9adb,	0x9adc,	0x9ae0,	0x9ae4,	0x9ae5,
	/* 73 81 */
	0x9ae7,	0x9ae9,	0x9aec,	0x9af2,	0x9af3,	0x9af5,	0x9af9,	0x9afa,
	/* 73 89 */
	0x9afd,	0x9aff,	0x9b00,	0x9b01,	0x9b02,	0x9b03,
	/* 74 01 */
	0x9b04,	0x9b05,	0x9b08,	0x9b09,	0x9b0b,	0x9b0c,	0x9b0d,	0x9b0e,
	/* 74 09 */
	0x9b10,	0x9b12,	0x9b16,	0x9b19,	0x9b1b,	0x9b1c,	0x9b20,	0x9b26,
	/* 74 17 */
	0x9b2b,	0x9b2d,	0x9b33,	0x9b34,	0x9b35,	0x9b37,	0x9b39,	0x9b3a,
	/* 74 25 */
	0x9b3d,	0x9b48,	0x9b4b,	0x9b4c,	0x9b55,	0x9b56,	0x9b57,	0x9b5b,
	/* 74 33 */
	0x9b5e,	0x9b61,	0x9b63,	0x9b65,	0x9b66,	0x9b68,	0x9b6a,	0x9b6b,
	/* 74 41 */
	0x9b6c,	0x9b6d,	0x9b6e,	0x9b73,	0x9b75,	0x9b77,	0x9b78,	0x9b79,
	/* 74 49 */
	0x9b7f,	0x9b80,	0x9b84,	0x9b85,	0x9b86,	0x9b87,	0x9b89,	0x9b8a,
	/* 74 57 */
	0x9b8b,	0x9b8d,	0x9b8f,	0x9b90,	0x9b94,	0x9b9a,	0x9b9d,	0x9b9e,
	/* 74 65 */
	0x9ba6,	0x9ba7,	0x9ba9,	0x9bac,	0x9bb0,	0x9bb1,	0x9bb2,	0x9bb7,
	/* 74 73 */
	0x9bb8,	0x9bbb,	0x9bbc,	0x9bbe,	0x9bbf,	0x9bc1,	0x9bc7,	0x9bc8,
	/* 74 81 */
	0x9bce,	0x9bd0,	0x9bd7,	0x9bd8,	0x9bdd,	0x9bdf,	0x9be5,	0x9be7,
	/* 74 89 */
	0x9bea,	0x9beb,	0x9bef,	0x9bf3,	0x9bf7,	0x9bf8,
	/* 75 01 */
	0x9bf9,	0x9bfa,	0x9bfd,	0x9bff,	0x9c00,	0x9c02,	0x9c0b,	0x9c0f,
	/* 75 09 */
	0x9c11,	0x9c16,	0x9c18,	0x9c19,	0x9c1a,	0x9c1c,	0x9c1e,	0x9c22,
	/* 75 17 */
	0x9c23,	0x9c26,	0x9c27,	0x9c28,	0x9c29,	0x9c2a,	0x9c31,	0x9c35,
	/* 75 25 */
	0x9c36,	0x9c37,	0x9c3d,	0x9c41,	0x9c43,	0x9c44,	0x9c45,	0x9c49,
	/* 75 33 */
	0x9c4a,	0x9c4e,	0x9c4f,	0x9c50,	0x9c53,	0x9c54,	0x9c56,	0x9c58,
	/* 75 41 */
	0x9c5b,	0x9c5d,	0x9c5e,	0x9c5f,	0x9c63,	0x9c69,	0x9c6a,	0x9c5c,
	/* 75 49 */
	0x9c6b,	0x9c68,	0x9c6e,	0x9c70,	0x9c72,	0x9c75,	0x9c77,	0x9c7b,
	/* 75 57 */
	0x9ce6,	0x9cf2,	0x9cf7,	0x9cf9,	0x9d0b,	0x9d02,	0x9d11,	0x9d17,
	/* 75 65 */
	0x9d18,	0x9d1c,	0x9d1d,	0x9d1e,	0x9d2f,	0x9d30,	0x9d32,	0x9d33,
	/* 75 73 */
	0x9d34,	0x9d3a,	0x9d3c,	0x9d45,	0x9d3d,	0x9d42,	0x9d43,	0x9d47,
	/* 75 81 */
	0x9d4a,	0x9d53,	0x9d54,	0x9d5f,	0x9d63,	0x9d62,	0x9d65,	0x9d69,
	/* 75 89 */
	0x9d6a,	0x9d6b,	0x9d70,	0x9d76,	0x9d77,	0x9d7b,
	/* 76 01 */
	0x9d7c,	0x9d7e,	0x9d83,	0x9d84,	0x9d86,	0x9d8a,	0x9d8d,	0x9d8e,
	/* 76 09 */
	0x9d92,	0x9d93,	0x9d95,	0x9d96,	0x9d97,	0x9d98,	0x9da1,	0x9daa,
	/* 76 17 */
	0x9dac,	0x9dae,	0x9db1,	0x9db5,	0x9db9,	0x9dbc,	0x9dbf,	0x9dc3,
	/* 76 25 */
	0x9dc7,	0x9dc9,	0x9dca,	0x9dd4,	0x9dd5,	0x9dd6,	0x9dd7,	0x9dda,
	/* 76 33 */
	0x9dde,	0x9ddf,	0x9de0,	0x9de5,	0x9de7,	0x9de9,	0x9deb,	0x9dee,
	/* 76 41 */
	0x9df0,	0x9df3,	0x9df4,	0x9dfe,	0x9e0a,	0x9e02,	0x9e07,	0x9e0e,
	/* 76 49 */
	0x9e10,	0x9e11,	0x9e12,	0x9e15,	0x9e16,	0x9e19,	0x9e1c,	0x9e1d,
	/* 76 57 */
	0x9e7a,	0x9e7b,	0x9e7c,	0x9e80,	0x9e82,	0x9e83,	0x9e84,	0x9e85,
	/* 76 65 */
	0x9e87,	0x9e8e,	0x9e8f,	0x9e96,	0x9e98,	0x9e9b,	0x9e9e,	0x9ea4,
	/* 76 73 */
	0x9ea8,	0x9eac,	0x9eae,	0x9eaf,	0x9eb0,	0x9eb3,	0x9eb4,	0x9eb5,
	/* 76 81 */
	0x9ec6,	0x9ec8,	0x9ecb,	0x9ed5,	0x9edf,	0x9ee4,	0x9ee7,	0x9eec,
	/* 76 89 */
	0x9eed,	0x9eee,	0x9ef0,	0x9ef1,	0x9ef2,	0x9ef5,
	/* 77 01 */
	0x9ef8,	0x9eff,	0x9f02,	0x9f03,	0x9f09,	0x9f0f,	0x9f10,	0x9f11,
	/* 77 09 */
	0x9f12,	0x9f14,	0x9f16,	0x9f17,	0x9f19,	0x9f1a,	0x9f1b,	0x9f1f,
	/* 77 17 */
	0x9f22,	0x9f26,	0x9f2a,	0x9f2b,	0x9f2f,	0x9f31,	0x9f32,	0x9f34,
	/* 77 25 */
	0x9f37,	0x9f39,	0x9f3a,	0x9f3c,	0x9f3d,	0x9f3f,	0x9f41,	0x9f43,
	/* 77 33 */
	0x9f44,	0x9f45,	0x9f46,	0x9f47,	0x9f53,	0x9f55,	0x9f56,	0x9f57,
	/* 77 41 */
	0x9f58,	0x9f5a,	0x9f5d,	0x9f5e,	0x9f68,	0x9f69,	0x9f6d,	0x9f6e,
	/* 77 49 */
	0x9f6f,	0x9f70,	0x9f71,	0x9f73,	0x9f75,	0x9f7a,	0x9f7d,	0x9f8f,
	/* 77 57 */
	0x9f90,	0x9f91,	0x9f92,	0x9f94,	0x9f96,	0x9f97,	0x9f9e,	0x9fa1,
	/* 77 65 */
	0x9fa2,	0x9fa3,	0x9fa5,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 77 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 77 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 77 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 33 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 78 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 79 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 79 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 79 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 79 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 79 33 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 79 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 79 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 79 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 79 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 79 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 79 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 79 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 33 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 80 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 81 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 81 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 81 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 81 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 81 33 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 81 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 81 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 81 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 81 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 81 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 81 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 81 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 82 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 82 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 82 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 82 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 82 33 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 82 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 82 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 82 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 82 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 82 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 82 81 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 82 89 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 83 01 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 83 09 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 83 17 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 83 25 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 83 33 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 83 41 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 83 49 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 83 57 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 83 65 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 83 73 */
	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,	NODEST,
	/* 83 81 */
	NODEST,	NODEST,	0x2170,	0x2171,	0x2172,	0x2173,	0x2174,	0x2175,
	/* 83 89 */
	0x2176,	0x2177,	0x2178,	0x2179,	0x2160,	0x2161,
	/* 84 01 */
	0x2162,	0x2163,	0x2164,	0x2165,	0x2166,	0x2167,	0x2168,	0x2169,
	/* 84 09 */
	0xff07,	0xff02,	0x3231,	0x2116,	0x2121,	0x70bb,	0x4efc,	0x50f4,
	/* 84 17 */
	0x51ec,	0x5307,	0x5324,	0xfa0e,	0x548a,	0x5759,	0xfa0f,	0xfa10,
	/* 84 25 */
	0x589e,	0x5bec,	0x5cf5,	0x5d53,	0xfa11,	0x5fb7,	0x6085,	0x6120,
	/* 84 33 */
	0x654e,	0x663b,	0x6665,	0xfa12,	0xf929,	0x6801,	0xfa13,	0xfa14,
	/* 84 41 */
	0x6a6b,	0x6ae2,	0x6df8,	0x6df2,	0x7028,	0xfa15,	0xfa16,	0x7501,
	/* 84 49 */
	0x7682,	0x769e,	0xfa17,	0x7930,	0xfa18,	0xfa19,	0xfa1a,	0xfa1b,
	/* 84 57 */
	0x7ae7,	0xfa1c,	0xfa1d,	0x7da0,	0x7dd6,	0xfa1e,	0x8362,	0xfa1f,
	/* 84 65 */
	0x85b0,	0xfa20,	0xfa21,	0x8807,	0xfa22,	0x8b7f,	0x8cf4,	0x8d76,
	/* 84 73 */
	0xfa23,	0xfa24,	0xfa25,	0x90de,	0xfa26,	0x9115,	0xfa27,	0xfa28,
	/* 84 81 */
	0x9592,	0xf9dc,	0xfa29,	0x973b,	0x974d,	0x9751,	0xfa2a,	0xfa2b,
	/* 84 89 */
	0xfa2c,	0x999e,	0x9ad9,	0x9b72,	0xfa2d,	0x9ed1,
	/* 85 01 */
	0xe3ac,	0xe3ad,	0xe3ae,	0xe3af,	0xe3b0,	0xe3b1,	0xe3b2,	0xe3b3,
	/* 85 09 */
	0xe3b4,	0xe3b5,	0xe3b6,	0xe3b7,	0xe3b8,	0xe3b9,	0xe3ba,	0xe3bb,
	/* 85 17 */
	0xe3bc,	0xe3bd,	0xe3be,	0xe3bf,	0xe3c0,	0xe3c1,	0xe3c2,	0xe3c3,
	/* 85 25 */
	0xe3c4,	0xe3c5,	0xe3c6,	0xe3c7,	0xe3c8,	0xe3c9,	0xe3ca,	0xe3cb,
	/* 85 33 */
	0xe3cc,	0xe3cd,	0xe3ce,	0xe3cf,	0xe3d0,	0xe3d1,	0xe3d2,	0xe3d3,
	/* 85 41 */
	0xe3d4,	0xe3d5,	0xe3d6,	0xe3d7,	0xe3d8,	0xe3d9,	0xe3da,	0xe3db,
	/* 85 49 */
	0xe3dc,	0xe3dd,	0xe3de,	0xe3df,	0xe3e0,	0xe3e1,	0xe3e2,	0xe3e3,
	/* 85 57 */
	0xe3e4,	0xe3e5,	0xe3e6,	0xe3e7,	0xe3e8,	0xe3e9,	0xe3ea,	0xe3eb,
	/* 85 65 */
	0xe3ec,	0xe3ed,	0xe3ee,	0xe3ef,	0xe3f0,	0xe3f1,	0xe3f2,	0xe3f3,
	/* 85 73 */
	0xe3f4,	0xe3f5,	0xe3f6,	0xe3f7,	0xe3f8,	0xe3f9,	0xe3fa,	0xe3fb,
	/* 85 81 */
	0xe3fc,	0xe3fd,	0xe3fe,	0xe3ff,	0xe400,	0xe401,	0xe402,	0xe403,
	/* 85 89 */
	0xe404,	0xe405,	0xe406,	0xe407,	0xe408,	0xe409,
	/* 86 01 */
	0xe40a,	0xe40b,	0xe40c,	0xe40d,	0xe40e,	0xe40f,	0xe410,	0xe411,
	/* 86 09 */
	0xe412,	0xe413,	0xe414,	0xe415,	0xe416,	0xe417,	0xe418,	0xe419,
	/* 86 17 */
	0xe41a,	0xe41b,	0xe41c,	0xe41d,	0xe41e,	0xe41f,	0xe420,	0xe421,
	/* 86 25 */
	0xe422,	0xe423,	0xe424,	0xe425,	0xe426,	0xe427,	0xe428,	0xe429,
	/* 86 33 */
	0xe42a,	0xe42b,	0xe42c,	0xe42d,	0xe42e,	0xe42f,	0xe430,	0xe431,
	/* 86 41 */
	0xe432,	0xe433,	0xe434,	0xe435,	0xe436,	0xe437,	0xe438,	0xe439,
	/* 86 49 */
	0xe43a,	0xe43b,	0xe43c,	0xe43d,	0xe43e,	0xe43f,	0xe440,	0xe441,
	/* 86 57 */
	0xe442,	0xe443,	0xe444,	0xe445,	0xe446,	0xe447,	0xe448,	0xe449,
	/* 86 65 */
	0xe44a,	0xe44b,	0xe44c,	0xe44d,	0xe44e,	0xe44f,	0xe450,	0xe451,
	/* 86 73 */
	0xe452,	0xe453,	0xe454,	0xe455,	0xe456,	0xe457,	0xe458,	0xe459,
	/* 86 81 */
	0xe45a,	0xe45b,	0xe45c,	0xe45d,	0xe45e,	0xe45f,	0xe460,	0xe461,
	/* 86 89 */
	0xe462,	0xe463,	0xe464,	0xe465,	0xe466,	0xe467,
	/* 87 01 */
	0xe468,	0xe469,	0xe46a,	0xe46b,	0xe46c,	0xe46d,	0xe46e,	0xe46f,
	/* 87 09 */
	0xe470,	0xe471,	0xe472,	0xe473,	0xe474,	0xe475,	0xe476,	0xe477,
	/* 87 17 */
	0xe478,	0xe479,	0xe47a,	0xe47b,	0xe47c,	0xe47d,	0xe47e,	0xe47f,
	/* 87 25 */
	0xe480,	0xe481,	0xe482,	0xe483,	0xe484,	0xe485,	0xe486,	0xe487,
	/* 87 33 */
	0xe488,	0xe489,	0xe48a,	0xe48b,	0xe48c,	0xe48d,	0xe48e,	0xe48f,
	/* 87 41 */
	0xe490,	0xe491,	0xe492,	0xe493,	0xe494,	0xe495,	0xe496,	0xe497,
	/* 87 49 */
	0xe498,	0xe499,	0xe49a,	0xe49b,	0xe49c,	0xe49d,	0xe49e,	0xe49f,
	/* 87 57 */
	0xe4a0,	0xe4a1,	0xe4a2,	0xe4a3,	0xe4a4,	0xe4a5,	0xe4a6,	0xe4a7,
	/* 87 65 */
	0xe4a8,	0xe4a9,	0xe4aa,	0xe4ab,	0xe4ac,	0xe4ad,	0xe4ae,	0xe4af,
	/* 87 73 */
	0xe4b0,	0xe4b1,	0xe4b2,	0xe4b3,	0xe4b4,	0xe4b5,	0xe4b6,	0xe4b7,
	/* 87 81 */
	0xe4b8,	0xe4b9,	0xe4ba,	0xe4bb,	0xe4bc,	0xe4bd,	0xe4be,	0xe4bf,
	/* 87 89 */
	0xe4c0,	0xe4c1,	0xe4c2,	0xe4c3,	0xe4c4,	0xe4c5,
	/* 88 01 */
	0xe4c6,	0xe4c7,	0xe4c8,	0xe4c9,	0xe4ca,	0xe4cb,	0xe4cc,	0xe4cd,
	/* 88 09 */
	0xe4ce,	0xe4cf,	0xe4d0,	0xe4d1,	0xe4d2,	0xe4d3,	0xe4d4,	0xe4d5,
	/* 88 17 */
	0xe4d6,	0xe4d7,	0xe4d8,	0xe4d9,	0xe4da,	0xe4db,	0xe4dc,	0xe4dd,
	/* 88 25 */
	0xe4de,	0xe4df,	0xe4e0,	0xe4e1,	0xe4e2,	0xe4e3,	0xe4e4,	0xe4e5,
	/* 88 33 */
	0xe4e6,	0xe4e7,	0xe4e8,	0xe4e9,	0xe4ea,	0xe4eb,	0xe4ec,	0xe4ed,
	/* 88 41 */
	0xe4ee,	0xe4ef,	0xe4f0,	0xe4f1,	0xe4f2,	0xe4f3,	0xe4f4,	0xe4f5,
	/* 88 49 */
	0xe4f6,	0xe4f7,	0xe4f8,	0xe4f9,	0xe4fa,	0xe4fb,	0xe4fc,	0xe4fd,
	/* 88 57 */
	0xe4fe,	0xe4ff,	0xe500,	0xe501,	0xe502,	0xe503,	0xe504,	0xe505,
	/* 88 65 */
	0xe506,	0xe507,	0xe508,	0xe509,	0xe50a,	0xe50b,	0xe50c,	0xe50d,
	/* 88 73 */
	0xe50e,	0xe50f,	0xe510,	0xe511,	0xe512,	0xe513,	0xe514,	0xe515,
	/* 88 81 */
	0xe516,	0xe517,	0xe518,	0xe519,	0xe51a,	0xe51b,	0xe51c,	0xe51d,
	/* 88 89 */
	0xe51e,	0xe51f,	0xe520,	0xe521,	0xe522,	0xe523,
	/* 89 01 */
	0xe524,	0xe525,	0xe526,	0xe527,	0xe528,	0xe529,	0xe52a,	0xe52b,
	/* 89 09 */
	0xe52c,	0xe52d,	0xe52e,	0xe52f,	0xe530,	0xe531,	0xe532,	0xe533,
	/* 89 17 */
	0xe534,	0xe535,	0xe536,	0xe537,	0xe538,	0xe539,	0xe53a,	0xe53b,
	/* 89 25 */
	0xe53c,	0xe53d,	0xe53e,	0xe53f,	0xe540,	0xe541,	0xe542,	0xe543,
	/* 89 33 */
	0xe544,	0xe545,	0xe546,	0xe547,	0xe548,	0xe549,	0xe54a,	0xe54b,
	/* 89 41 */
	0xe54c,	0xe54d,	0xe54e,	0xe54f,	0xe550,	0xe551,	0xe552,	0xe553,
	/* 89 49 */
	0xe554,	0xe555,	0xe556,	0xe557,	0xe558,	0xe559,	0xe55a,	0xe55b,
	/* 89 57 */
	0xe55c,	0xe55d,	0xe55e,	0xe55f,	0xe560,	0xe561,	0xe562,	0xe563,
	/* 89 65 */
	0xe564,	0xe565,	0xe566,	0xe567,	0xe568,	0xe569,	0xe56a,	0xe56b,
	/* 89 73 */
	0xe56c,	0xe56d,	0xe56e,	0xe56f,	0xe570,	0xe571,	0xe572,	0xe573,
	/* 89 81 */
	0xe574,	0xe575,	0xe576,	0xe577,	0xe578,	0xe579,	0xe57a,	0xe57b,
	/* 89 89 */
	0xe57c,	0xe57d,	0xe57e,	0xe57f,	0xe580,	0xe581,
	/* 90 01 */
	0xe582,	0xe583,	0xe584,	0xe585,	0xe586,	0xe587,	0xe588,	0xe589,
	/* 90 09 */
	0xe58a,	0xe58b,	0xe58c,	0xe58d,	0xe58e,	0xe58f,	0xe590,	0xe591,
	/* 90 17 */
	0xe592,	0xe593,	0xe594,	0xe595,	0xe596,	0xe597,	0xe598,	0xe599,
	/* 90 25 */
	0xe59a,	0xe59b,	0xe59c,	0xe59d,	0xe59e,	0xe59f,	0xe5a0,	0xe5a1,
	/* 90 33 */
	0xe5a2,	0xe5a3,	0xe5a4,	0xe5a5,	0xe5a6,	0xe5a7,	0xe5a8,	0xe5a9,
	/* 90 41 */
	0xe5aa,	0xe5ab,	0xe5ac,	0xe5ad,	0xe5ae,	0xe5af,	0xe5b0,	0xe5b1,
	/* 90 49 */
	0xe5b2,	0xe5b3,	0xe5b4,	0xe5b5,	0xe5b6,	0xe5b7,	0xe5b8,	0xe5b9,
	/* 90 57 */
	0xe5ba,	0xe5bb,	0xe5bc,	0xe5bd,	0xe5be,	0xe5bf,	0xe5c0,	0xe5c1,
	/* 90 65 */
	0xe5c2,	0xe5c3,	0xe5c4,	0xe5c5,	0xe5c6,	0xe5c7,	0xe5c8,	0xe5c9,
	/* 90 73 */
	0xe5ca,	0xe5cb,	0xe5cc,	0xe5cd,	0xe5ce,	0xe5cf,	0xe5d0,	0xe5d1,
	/* 90 81 */
	0xe5d2,	0xe5d3,	0xe5d4,	0xe5d5,	0xe5d6,	0xe5d7,	0xe5d8,	0xe5d9,
	/* 90 89 */
	0xe5da,	0xe5db,	0xe5dc,	0xe5dd,	0xe5de,	0xe5df,
	/* 91 01 */
	0xe5e0,	0xe5e1,	0xe5e2,	0xe5e3,	0xe5e4,	0xe5e5,	0xe5e6,	0xe5e7,
	/* 91 09 */
	0xe5e8,	0xe5e9,	0xe5ea,	0xe5eb,	0xe5ec,	0xe5ed,	0xe5ee,	0xe5ef,
	/* 91 17 */
	0xe5f0,	0xe5f1,	0xe5f2,	0xe5f3,	0xe5f4,	0xe5f5,	0xe5f6,	0xe5f7,
	/* 91 25 */
	0xe5f8,	0xe5f9,	0xe5fa,	0xe5fb,	0xe5fc,	0xe5fd,	0xe5fe,	0xe5ff,
	/* 91 33 */
	0xe600,	0xe601,	0xe602,	0xe603,	0xe604,	0xe605,	0xe606,	0xe607,
	/* 91 41 */
	0xe608,	0xe609,	0xe60a,	0xe60b,	0xe60c,	0xe60d,	0xe60e,	0xe60f,
	/* 91 49 */
	0xe610,	0xe611,	0xe612,	0xe613,	0xe614,	0xe615,	0xe616,	0xe617,
	/* 91 57 */
	0xe618,	0xe619,	0xe61a,	0xe61b,	0xe61c,	0xe61d,	0xe61e,	0xe61f,
	/* 91 65 */
	0xe620,	0xe621,	0xe622,	0xe623,	0xe624,	0xe625,	0xe626,	0xe627,
	/* 91 73 */
	0xe628,	0xe629,	0xe62a,	0xe62b,	0xe62c,	0xe62d,	0xe62e,	0xe62f,
	/* 91 81 */
	0xe630,	0xe631,	0xe632,	0xe633,	0xe634,	0xe635,	0xe636,	0xe637,
	/* 91 89 */
	0xe638,	0xe639,	0xe63a,	0xe63b,	0xe63c,	0xe63d,
	/* 92 01 */
	0xe63e,	0xe63f,	0xe640,	0xe641,	0xe642,	0xe643,	0xe644,	0xe645,
	/* 92 09 */
	0xe646,	0xe647,	0xe648,	0xe649,	0xe64a,	0xe64b,	0xe64c,	0xe64d,
	/* 92 17 */
	0xe64e,	0xe64f,	0xe650,	0xe651,	0xe652,	0xe653,	0xe654,	0xe655,
	/* 92 25 */
	0xe656,	0xe657,	0xe658,	0xe659,	0xe65a,	0xe65b,	0xe65c,	0xe65d,
	/* 92 33 */
	0xe65e,	0xe65f,	0xe660,	0xe661,	0xe662,	0xe663,	0xe664,	0xe665,
	/* 92 41 */
	0xe666,	0xe667,	0xe668,	0xe669,	0xe66a,	0xe66b,	0xe66c,	0xe66d,
	/* 92 49 */
	0xe66e,	0xe66f,	0xe670,	0xe671,	0xe672,	0xe673,	0xe674,	0xe675,
	/* 92 57 */
	0xe676,	0xe677,	0xe678,	0xe679,	0xe67a,	0xe67b,	0xe67c,	0xe67d,
	/* 92 65 */
	0xe67e,	0xe67f,	0xe680,	0xe681,	0xe682,	0xe683,	0xe684,	0xe685,
	/* 92 73 */
	0xe686,	0xe687,	0xe688,	0xe689,	0xe68a,	0xe68b,	0xe68c,	0xe68d,
	/* 92 81 */
	0xe68e,	0xe68f,	0xe690,	0xe691,	0xe692,	0xe693,	0xe694,	0xe695,
	/* 92 89 */
	0xe696,	0xe697,	0xe698,	0xe699,	0xe69a,	0xe69b,
	/* 93 01 */
	0xe69c,	0xe69d,	0xe69e,	0xe69f,	0xe6a0,	0xe6a1,	0xe6a2,	0xe6a3,
	/* 93 09 */
	0xe6a4,	0xe6a5,	0xe6a6,	0xe6a7,	0xe6a8,	0xe6a9,	0xe6aa,	0xe6ab,
	/* 93 17 */
	0xe6ac,	0xe6ad,	0xe6ae,	0xe6af,	0xe6b0,	0xe6b1,	0xe6b2,	0xe6b3,
	/* 93 25 */
	0xe6b4,	0xe6b5,	0xe6b6,	0xe6b7,	0xe6b8,	0xe6b9,	0xe6ba,	0xe6bb,
	/* 93 33 */
	0xe6bc,	0xe6bd,	0xe6be,	0xe6bf,	0xe6c0,	0xe6c1,	0xe6c2,	0xe6c3,
	/* 93 41 */
	0xe6c4,	0xe6c5,	0xe6c6,	0xe6c7,	0xe6c8,	0xe6c9,	0xe6ca,	0xe6cb,
	/* 93 49 */
	0xe6cc,	0xe6cd,	0xe6ce,	0xe6cf,	0xe6d0,	0xe6d1,	0xe6d2,	0xe6d3,
	/* 93 57 */
	0xe6d4,	0xe6d5,	0xe6d6,	0xe6d7,	0xe6d8,	0xe6d9,	0xe6da,	0xe6db,
	/* 93 65 */
	0xe6dc,	0xe6dd,	0xe6de,	0xe6df,	0xe6e0,	0xe6e1,	0xe6e2,	0xe6e3,
	/* 93 73 */
	0xe6e4,	0xe6e5,	0xe6e6,	0xe6e7,	0xe6e8,	0xe6e9,	0xe6ea,	0xe6eb,
	/* 93 81 */
	0xe6ec,	0xe6ed,	0xe6ee,	0xe6ef,	0xe6f0,	0xe6f1,	0xe6f2,	0xe6f3,
	/* 93 89 */
	0xe6f4,	0xe6f5,	0xe6f6,	0xe6f7,	0xe6f8,	0xe6f9,
	/* 94 01 */
	0xe6fa,	0xe6fb,	0xe6fc,	0xe6fd,	0xe6fe,	0xe6ff,	0xe700,	0xe701,
	/* 94 09 */
	0xe702,	0xe703,	0xe704,	0xe705,	0xe706,	0xe707,	0xe708,	0xe709,
	/* 94 17 */
	0xe70a,	0xe70b,	0xe70c,	0xe70d,	0xe70e,	0xe70f,	0xe710,	0xe711,
	/* 94 25 */
	0xe712,	0xe713,	0xe714,	0xe715,	0xe716,	0xe717,	0xe718,	0xe719,
	/* 94 33 */
	0xe71a,	0xe71b,	0xe71c,	0xe71d,	0xe71e,	0xe71f,	0xe720,	0xe721,
	/* 94 41 */
	0xe722,	0xe723,	0xe724,	0xe725,	0xe726,	0xe727,	0xe728,	0xe729,
	/* 94 49 */
	0xe72a,	0xe72b,	0xe72c,	0xe72d,	0xe72e,	0xe72f,	0xe730,	0xe731,
	/* 94 57 */
	0xe732,	0xe733,	0xe734,	0xe735,	0xe736,	0xe737,	0xe738,	0xe739,
	/* 94 65 */
	0xe73a,	0xe73b,	0xe73c,	0xe73d,	0xe73e,	0xe73f,	0xe740,	0xe741,
	/* 94 73 */
	0xe742,	0xe743,	0xe744,	0xe745,	0xe746,	0xe747,	0xe748,	0xe749,
	/* 94 81 */
	0xe74a,	0xe74b,	0xe74c,	0xe74d,	0xe74e,	0xe74f,	0xe750,	0xe751,
	/* 94 89 */
	0xe752,	0xe753,	0xe754,	0xe755,	0xe756,	0xe757,
};

#define	KICONV_JA_CNV_JISMS_TO_U2(id, u, c1, c2) \
	(u) = KICONV_JA_NODEST; \
	if ((id) == KICONV_JA_TBLID_EUCJP_MS || \
	    (id) == KICONV_JA_TBLID_CP932) { \
		if ((c1) == 0x21) { \
			if ((c2) == 0x41) { \
				(u) = 0xff5e; \
			} else if ((c2) == 0x42) { \
				(u) = 0x2225; \
			} else if ((c2) == 0x5d) { \
				(u) = 0xff0d; \
			} else if ((c2) == 0x71) { \
				(u) = 0xffe0; \
			} else if ((c2) == 0x72) { \
				(u) = 0xffe1; \
			} \
		} else if ((c1) == 0x22 && (c2) == 0x4c) { \
			(u) = 0xffe2; \
		} \
	}

#define	KICONV_JA_CNV_JIS0212MS_TO_U2(id, u, c1, c2) \
	(u) = KICONV_JA_NODEST; \
	if ((id) == KICONV_JA_TBLID_EUCJP_MS || \
	    (id) == KICONV_JA_TBLID_CP932) { \
		if ((c1) == 0x22) { \
			if ((c2) == 0x43) { \
				(u) = 0xffe4; \
			} \
		} \
	}

#undef	NODEST

#endif	/* _KERNEL */

#ifdef __cplusplus
}
#endif

#endif	/* _SYS_KICONV_JA_JIS_TO_UNICODE_H */
