/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2008 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2006 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation (the
 * "Data Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 *
 * Unicode and the Unicode logo are trademarks of Unicode, Inc., and may be
 * registered in some jurisdictions. All other trademarks and registered
 * trademarks mentioned herein are the property of their respective owners.
 */
/*
 * This file has been modified by Sun Microsystems, Inc.
 */

#ifndef _SYS_KICONV_UHC_UTF8_H
#define	_SYS_KICONV_UHC_UTF8_H

#pragma ident	"%Z%%M%	%I%	%E% SMI"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef	_KERNEL

/* Maximum mapping number from UHC to UTF-8. */
#define	KICONV_UHC_UTF8_MAX			(17047)

static kiconv_table_array_t kiconv_uhc_utf8[] = {
	0x0000,	{ 0xEF, 0xBF, 0xBD },	/* Hold entry for non-identical conv */
	0x8141, { 0xEA, 0xB0, 0x82 },
	0x8142, { 0xEA, 0xB0, 0x83 },
	0x8143, { 0xEA, 0xB0, 0x85 },
	0x8144, { 0xEA, 0xB0, 0x86 },
	0x8145, { 0xEA, 0xB0, 0x8B },
	0x8146, { 0xEA, 0xB0, 0x8C },
	0x8147, { 0xEA, 0xB0, 0x8D },
	0x8148, { 0xEA, 0xB0, 0x8E },
	0x8149, { 0xEA, 0xB0, 0x8F },
	0x814A, { 0xEA, 0xB0, 0x98 },
	0x814B, { 0xEA, 0xB0, 0x9E },
	0x814C, { 0xEA, 0xB0, 0x9F },
	0x814D, { 0xEA, 0xB0, 0xA1 },
	0x814E, { 0xEA, 0xB0, 0xA2 },
	0x814F, { 0xEA, 0xB0, 0xA3 },
	0x8150, { 0xEA, 0xB0, 0xA5 },
	0x8151, { 0xEA, 0xB0, 0xA6 },
	0x8152, { 0xEA, 0xB0, 0xA7 },
	0x8153, { 0xEA, 0xB0, 0xA8 },
	0x8154, { 0xEA, 0xB0, 0xA9 },
	0x8155, { 0xEA, 0xB0, 0xAA },
	0x8156, { 0xEA, 0xB0, 0xAB },
	0x8157, { 0xEA, 0xB0, 0xAE },
	0x8158, { 0xEA, 0xB0, 0xB2 },
	0x8159, { 0xEA, 0xB0, 0xB3 },
	0x815A, { 0xEA, 0xB0, 0xB4 },
	0x8161, { 0xEA, 0xB0, 0xB5 },
	0x8162, { 0xEA, 0xB0, 0xB6 },
	0x8163, { 0xEA, 0xB0, 0xB7 },
	0x8164, { 0xEA, 0xB0, 0xBA },
	0x8165, { 0xEA, 0xB0, 0xBB },
	0x8166, { 0xEA, 0xB0, 0xBD },
	0x8167, { 0xEA, 0xB0, 0xBE },
	0x8168, { 0xEA, 0xB0, 0xBF },
	0x8169, { 0xEA, 0xB1, 0x81 },
	0x816A, { 0xEA, 0xB1, 0x82 },
	0x816B, { 0xEA, 0xB1, 0x83 },
	0x816C, { 0xEA, 0xB1, 0x84 },
	0x816D, { 0xEA, 0xB1, 0x85 },
	0x816E, { 0xEA, 0xB1, 0x86 },
	0x816F, { 0xEA, 0xB1, 0x87 },
	0x8170, { 0xEA, 0xB1, 0x88 },
	0x8171, { 0xEA, 0xB1, 0x89 },
	0x8172, { 0xEA, 0xB1, 0x8A },
	0x8173, { 0xEA, 0xB1, 0x8C },
	0x8174, { 0xEA, 0xB1, 0x8E },
	0x8175, { 0xEA, 0xB1, 0x8F },
	0x8176, { 0xEA, 0xB1, 0x90 },
	0x8177, { 0xEA, 0xB1, 0x91 },
	0x8178, { 0xEA, 0xB1, 0x92 },
	0x8179, { 0xEA, 0xB1, 0x93 },
	0x817A, { 0xEA, 0xB1, 0x95 },
	0x8181, { 0xEA, 0xB1, 0x96 },
	0x8182, { 0xEA, 0xB1, 0x97 },
	0x8183, { 0xEA, 0xB1, 0x99 },
	0x8184, { 0xEA, 0xB1, 0x9A },
	0x8185, { 0xEA, 0xB1, 0x9B },
	0x8186, { 0xEA, 0xB1, 0x9D },
	0x8187, { 0xEA, 0xB1, 0x9E },
	0x8188, { 0xEA, 0xB1, 0x9F },
	0x8189, { 0xEA, 0xB1, 0xA0 },
	0x818A, { 0xEA, 0xB1, 0xA1 },
	0x818B, { 0xEA, 0xB1, 0xA2 },
	0x818C, { 0xEA, 0xB1, 0xA3 },
	0x818D, { 0xEA, 0xB1, 0xA4 },
	0x818E, { 0xEA, 0xB1, 0xA5 },
	0x818F, { 0xEA, 0xB1, 0xA6 },
	0x8190, { 0xEA, 0xB1, 0xA7 },
	0x8191, { 0xEA, 0xB1, 0xA8 },
	0x8192, { 0xEA, 0xB1, 0xA9 },
	0x8193, { 0xEA, 0xB1, 0xAA },
	0x8194, { 0xEA, 0xB1, 0xAB },
	0x8195, { 0xEA, 0xB1, 0xAC },
	0x8196, { 0xEA, 0xB1, 0xAD },
	0x8197, { 0xEA, 0xB1, 0xAE },
	0x8198, { 0xEA, 0xB1, 0xAF },
	0x8199, { 0xEA, 0xB1, 0xB2 },
	0x819A, { 0xEA, 0xB1, 0xB3 },
	0x819B, { 0xEA, 0xB1, 0xB5 },
	0x819C, { 0xEA, 0xB1, 0xB6 },
	0x819D, { 0xEA, 0xB1, 0xB9 },
	0x819E, { 0xEA, 0xB1, 0xBB },
	0x819F, { 0xEA, 0xB1, 0xBC },
	0x81A0, { 0xEA, 0xB1, 0xBD },
	0x81A1, { 0xEA, 0xB1, 0xBE },
	0x81A2, { 0xEA, 0xB1, 0xBF },
	0x81A3, { 0xEA, 0xB2, 0x82 },
	0x81A4, { 0xEA, 0xB2, 0x87 },
	0x81A5, { 0xEA, 0xB2, 0x88 },
	0x81A6, { 0xEA, 0xB2, 0x8D },
	0x81A7, { 0xEA, 0xB2, 0x8E },
	0x81A8, { 0xEA, 0xB2, 0x8F },
	0x81A9, { 0xEA, 0xB2, 0x91 },
	0x81AA, { 0xEA, 0xB2, 0x92 },
	0x81AB, { 0xEA, 0xB2, 0x93 },
	0x81AC, { 0xEA, 0xB2, 0x95 },
	0x81AD, { 0xEA, 0xB2, 0x96 },
	0x81AE, { 0xEA, 0xB2, 0x97 },
	0x81AF, { 0xEA, 0xB2, 0x98 },
	0x81B0, { 0xEA, 0xB2, 0x99 },
	0x81B1, { 0xEA, 0xB2, 0x9A },
	0x81B2, { 0xEA, 0xB2, 0x9B },
	0x81B3, { 0xEA, 0xB2, 0x9E },
	0x81B4, { 0xEA, 0xB2, 0xA2 },
	0x81B5, { 0xEA, 0xB2, 0xA3 },
	0x81B6, { 0xEA, 0xB2, 0xA4 },
	0x81B7, { 0xEA, 0xB2, 0xA5 },
	0x81B8, { 0xEA, 0xB2, 0xA6 },
	0x81B9, { 0xEA, 0xB2, 0xA7 },
	0x81BA, { 0xEA, 0xB2, 0xAB },
	0x81BB, { 0xEA, 0xB2, 0xAD },
	0x81BC, { 0xEA, 0xB2, 0xAE },
	0x81BD, { 0xEA, 0xB2, 0xB1 },
	0x81BE, { 0xEA, 0xB2, 0xB2 },
	0x81BF, { 0xEA, 0xB2, 0xB3 },
	0x81C0, { 0xEA, 0xB2, 0xB4 },
	0x81C1, { 0xEA, 0xB2, 0xB5 },
	0x81C2, { 0xEA, 0xB2, 0xB6 },
	0x81C3, { 0xEA, 0xB2, 0xB7 },
	0x81C4, { 0xEA, 0xB2, 0xBA },
	0x81C5, { 0xEA, 0xB2, 0xBE },
	0x81C6, { 0xEA, 0xB2, 0xBF },
	0x81C7, { 0xEA, 0xB3, 0x80 },
	0x81C8, { 0xEA, 0xB3, 0x82 },
	0x81C9, { 0xEA, 0xB3, 0x83 },
	0x81CA, { 0xEA, 0xB3, 0x85 },
	0x81CB, { 0xEA, 0xB3, 0x86 },
	0x81CC, { 0xEA, 0xB3, 0x87 },
	0x81CD, { 0xEA, 0xB3, 0x89 },
	0x81CE, { 0xEA, 0xB3, 0x8A },
	0x81CF, { 0xEA, 0xB3, 0x8B },
	0x81D0, { 0xEA, 0xB3, 0x8D },
	0x81D1, { 0xEA, 0xB3, 0x8E },
	0x81D2, { 0xEA, 0xB3, 0x8F },
	0x81D3, { 0xEA, 0xB3, 0x90 },
	0x81D4, { 0xEA, 0xB3, 0x91 },
	0x81D5, { 0xEA, 0xB3, 0x92 },
	0x81D6, { 0xEA, 0xB3, 0x93 },
	0x81D7, { 0xEA, 0xB3, 0x94 },
	0x81D8, { 0xEA, 0xB3, 0x96 },
	0x81D9, { 0xEA, 0xB3, 0x98 },
	0x81DA, { 0xEA, 0xB3, 0x99 },
	0x81DB, { 0xEA, 0xB3, 0x9A },
	0x81DC, { 0xEA, 0xB3, 0x9B },
	0x81DD, { 0xEA, 0xB3, 0x9C },
	0x81DE, { 0xEA, 0xB3, 0x9D },
	0x81DF, { 0xEA, 0xB3, 0x9E },
	0x81E0, { 0xEA, 0xB3, 0x9F },
	0x81E1, { 0xEA, 0xB3, 0xA2 },
	0x81E2, { 0xEA, 0xB3, 0xA3 },
	0x81E3, { 0xEA, 0xB3, 0xA5 },
	0x81E4, { 0xEA, 0xB3, 0xA6 },
	0x81E5, { 0xEA, 0xB3, 0xA9 },
	0x81E6, { 0xEA, 0xB3, 0xAB },
	0x81E7, { 0xEA, 0xB3, 0xAD },
	0x81E8, { 0xEA, 0xB3, 0xAE },
	0x81E9, { 0xEA, 0xB3, 0xB2 },
	0x81EA, { 0xEA, 0xB3, 0xB4 },
	0x81EB, { 0xEA, 0xB3, 0xB7 },
	0x81EC, { 0xEA, 0xB3, 0xB8 },
	0x81ED, { 0xEA, 0xB3, 0xB9 },
	0x81EE, { 0xEA, 0xB3, 0xBA },
	0x81EF, { 0xEA, 0xB3, 0xBB },
	0x81F0, { 0xEA, 0xB3, 0xBE },
	0x81F1, { 0xEA, 0xB3, 0xBF },
	0x81F2, { 0xEA, 0xB4, 0x81 },
	0x81F3, { 0xEA, 0xB4, 0x82 },
	0x81F4, { 0xEA, 0xB4, 0x83 },
	0x81F5, { 0xEA, 0xB4, 0x85 },
	0x81F6, { 0xEA, 0xB4, 0x87 },
	0x81F7, { 0xEA, 0xB4, 0x88 },
	0x81F8, { 0xEA, 0xB4, 0x89 },
	0x81F9, { 0xEA, 0xB4, 0x8A },
	0x81FA, { 0xEA, 0xB4, 0x8B },
	0x81FB, { 0xEA, 0xB4, 0x8E },
	0x81FC, { 0xEA, 0xB4, 0x90 },
	0x81FD, { 0xEA, 0xB4, 0x92 },
	0x81FE, { 0xEA, 0xB4, 0x93 },
	0x8241, { 0xEA, 0xB4, 0x94 },
	0x8242, { 0xEA, 0xB4, 0x95 },
	0x8243, { 0xEA, 0xB4, 0x96 },
	0x8244, { 0xEA, 0xB4, 0x97 },
	0x8245, { 0xEA, 0xB4, 0x99 },
	0x8246, { 0xEA, 0xB4, 0x9A },
	0x8247, { 0xEA, 0xB4, 0x9B },
	0x8248, { 0xEA, 0xB4, 0x9D },
	0x8249, { 0xEA, 0xB4, 0x9E },
	0x824A, { 0xEA, 0xB4, 0x9F },
	0x824B, { 0xEA, 0xB4, 0xA1 },
	0x824C, { 0xEA, 0xB4, 0xA2 },
	0x824D, { 0xEA, 0xB4, 0xA3 },
	0x824E, { 0xEA, 0xB4, 0xA4 },
	0x824F, { 0xEA, 0xB4, 0xA5 },
	0x8250, { 0xEA, 0xB4, 0xA6 },
	0x8251, { 0xEA, 0xB4, 0xA7 },
	0x8252, { 0xEA, 0xB4, 0xA8 },
	0x8253, { 0xEA, 0xB4, 0xAA },
	0x8254, { 0xEA, 0xB4, 0xAB },
	0x8255, { 0xEA, 0xB4, 0xAE },
	0x8256, { 0xEA, 0xB4, 0xAF },
	0x8257, { 0xEA, 0xB4, 0xB0 },
	0x8258, { 0xEA, 0xB4, 0xB1 },
	0x8259, { 0xEA, 0xB4, 0xB2 },
	0x825A, { 0xEA, 0xB4, 0xB3 },
	0x8261, { 0xEA, 0xB4, 0xB6 },
	0x8262, { 0xEA, 0xB4, 0xB7 },
	0x8263, { 0xEA, 0xB4, 0xB9 },
	0x8264, { 0xEA, 0xB4, 0xBA },
	0x8265, { 0xEA, 0xB4, 0xBB },
	0x8266, { 0xEA, 0xB4, 0xBD },
	0x8267, { 0xEA, 0xB4, 0xBE },
	0x8268, { 0xEA, 0xB4, 0xBF },
	0x8269, { 0xEA, 0xB5, 0x80 },
	0x826A, { 0xEA, 0xB5, 0x81 },
	0x826B, { 0xEA, 0xB5, 0x82 },
	0x826C, { 0xEA, 0xB5, 0x83 },
	0x826D, { 0xEA, 0xB5, 0x86 },
	0x826E, { 0xEA, 0xB5, 0x88 },
	0x826F, { 0xEA, 0xB5, 0x8A },
	0x8270, { 0xEA, 0xB5, 0x8B },
	0x8271, { 0xEA, 0xB5, 0x8C },
	0x8272, { 0xEA, 0xB5, 0x8D },
	0x8273, { 0xEA, 0xB5, 0x8E },
	0x8274, { 0xEA, 0xB5, 0x8F },
	0x8275, { 0xEA, 0xB5, 0x91 },
	0x8276, { 0xEA, 0xB5, 0x92 },
	0x8277, { 0xEA, 0xB5, 0x93 },
	0x8278, { 0xEA, 0xB5, 0x95 },
	0x8279, { 0xEA, 0xB5, 0x96 },
	0x827A, { 0xEA, 0xB5, 0x97 },
	0x8281, { 0xEA, 0xB5, 0x99 },
	0x8282, { 0xEA, 0xB5, 0x9A },
	0x8283, { 0xEA, 0xB5, 0x9B },
	0x8284, { 0xEA, 0xB5, 0x9C },
	0x8285, { 0xEA, 0xB5, 0x9D },
	0x8286, { 0xEA, 0xB5, 0x9E },
	0x8287, { 0xEA, 0xB5, 0x9F },
	0x8288, { 0xEA, 0xB5, 0xA0 },
	0x8289, { 0xEA, 0xB5, 0xA2 },
	0x828A, { 0xEA, 0xB5, 0xA4 },
	0x828B, { 0xEA, 0xB5, 0xA5 },
	0x828C, { 0xEA, 0xB5, 0xA6 },
	0x828D, { 0xEA, 0xB5, 0xA7 },
	0x828E, { 0xEA, 0xB5, 0xA8 },
	0x828F, { 0xEA, 0xB5, 0xA9 },
	0x8290, { 0xEA, 0xB5, 0xAA },
	0x8291, { 0xEA, 0xB5, 0xAB },
	0x8292, { 0xEA, 0xB5, 0xAE },
	0x8293, { 0xEA, 0xB5, 0xAF },
	0x8294, { 0xEA, 0xB5, 0xB1 },
	0x8295, { 0xEA, 0xB5, 0xB2 },
	0x8296, { 0xEA, 0xB5, 0xB7 },
	0x8297, { 0xEA, 0xB5, 0xB8 },
	0x8298, { 0xEA, 0xB5, 0xB9 },
	0x8299, { 0xEA, 0xB5, 0xBA },
	0x829A, { 0xEA, 0xB5, 0xBE },
	0x829B, { 0xEA, 0xB6, 0x80 },
	0x829C, { 0xEA, 0xB6, 0x83 },
	0x829D, { 0xEA, 0xB6, 0x84 },
	0x829E, { 0xEA, 0xB6, 0x85 },
	0x829F, { 0xEA, 0xB6, 0x86 },
	0x82A0, { 0xEA, 0xB6, 0x87 },
	0x82A1, { 0xEA, 0xB6, 0x8A },
	0x82A2, { 0xEA, 0xB6, 0x8B },
	0x82A3, { 0xEA, 0xB6, 0x8D },
	0x82A4, { 0xEA, 0xB6, 0x8E },
	0x82A5, { 0xEA, 0xB6, 0x8F },
	0x82A6, { 0xEA, 0xB6, 0x91 },
	0x82A7, { 0xEA, 0xB6, 0x92 },
	0x82A8, { 0xEA, 0xB6, 0x93 },
	0x82A9, { 0xEA, 0xB6, 0x94 },
	0x82AA, { 0xEA, 0xB6, 0x95 },
	0x82AB, { 0xEA, 0xB6, 0x96 },
	0x82AC, { 0xEA, 0xB6, 0x97 },
	0x82AD, { 0xEA, 0xB6, 0x98 },
	0x82AE, { 0xEA, 0xB6, 0x99 },
	0x82AF, { 0xEA, 0xB6, 0x9A },
	0x82B0, { 0xEA, 0xB6, 0x9B },
	0x82B1, { 0xEA, 0xB6, 0x9E },
	0x82B2, { 0xEA, 0xB6, 0x9F },
	0x82B3, { 0xEA, 0xB6, 0xA0 },
	0x82B4, { 0xEA, 0xB6, 0xA1 },
	0x82B5, { 0xEA, 0xB6, 0xA2 },
	0x82B6, { 0xEA, 0xB6, 0xA3 },
	0x82B7, { 0xEA, 0xB6, 0xA5 },
	0x82B8, { 0xEA, 0xB6, 0xA6 },
	0x82B9, { 0xEA, 0xB6, 0xA7 },
	0x82BA, { 0xEA, 0xB6, 0xA8 },
	0x82BB, { 0xEA, 0xB6, 0xA9 },
	0x82BC, { 0xEA, 0xB6, 0xAA },
	0x82BD, { 0xEA, 0xB6, 0xAB },
	0x82BE, { 0xEA, 0xB6, 0xAC },
	0x82BF, { 0xEA, 0xB6, 0xAD },
	0x82C0, { 0xEA, 0xB6, 0xAE },
	0x82C1, { 0xEA, 0xB6, 0xAF },
	0x82C2, { 0xEA, 0xB6, 0xB0 },
	0x82C3, { 0xEA, 0xB6, 0xB1 },
	0x82C4, { 0xEA, 0xB6, 0xB2 },
	0x82C5, { 0xEA, 0xB6, 0xB3 },
	0x82C6, { 0xEA, 0xB6, 0xB4 },
	0x82C7, { 0xEA, 0xB6, 0xB5 },
	0x82C8, { 0xEA, 0xB6, 0xB6 },
	0x82C9, { 0xEA, 0xB6, 0xB8 },
	0x82CA, { 0xEA, 0xB6, 0xB9 },
	0x82CB, { 0xEA, 0xB6, 0xBA },
	0x82CC, { 0xEA, 0xB6, 0xBB },
	0x82CD, { 0xEA, 0xB6, 0xBC },
	0x82CE, { 0xEA, 0xB6, 0xBD },
	0x82CF, { 0xEA, 0xB6, 0xBE },
	0x82D0, { 0xEA, 0xB6, 0xBF },
	0x82D1, { 0xEA, 0xB7, 0x82 },
	0x82D2, { 0xEA, 0xB7, 0x83 },
	0x82D3, { 0xEA, 0xB7, 0x85 },
	0x82D4, { 0xEA, 0xB7, 0x86 },
	0x82D5, { 0xEA, 0xB7, 0x87 },
	0x82D6, { 0xEA, 0xB7, 0x89 },
	0x82D7, { 0xEA, 0xB7, 0x8A },
	0x82D8, { 0xEA, 0xB7, 0x8B },
	0x82D9, { 0xEA, 0xB7, 0x8C },
	0x82DA, { 0xEA, 0xB7, 0x8D },
	0x82DB, { 0xEA, 0xB7, 0x8E },
	0x82DC, { 0xEA, 0xB7, 0x8F },
	0x82DD, { 0xEA, 0xB7, 0x92 },
	0x82DE, { 0xEA, 0xB7, 0x94 },
	0x82DF, { 0xEA, 0xB7, 0x95 },
	0x82E0, { 0xEA, 0xB7, 0x96 },
	0x82E1, { 0xEA, 0xB7, 0x97 },
	0x82E2, { 0xEA, 0xB7, 0x98 },
	0x82E3, { 0xEA, 0xB7, 0x99 },
	0x82E4, { 0xEA, 0xB7, 0x9A },
	0x82E5, { 0xEA, 0xB7, 0x9B },
	0x82E6, { 0xEA, 0xB7, 0x9D },
	0x82E7, { 0xEA, 0xB7, 0x9E },
	0x82E8, { 0xEA, 0xB7, 0x9F },
	0x82E9, { 0xEA, 0xB7, 0xA1 },
	0x82EA, { 0xEA, 0xB7, 0xA2 },
	0x82EB, { 0xEA, 0xB7, 0xA3 },
	0x82EC, { 0xEA, 0xB7, 0xA5 },
	0x82ED, { 0xEA, 0xB7, 0xA6 },
	0x82EE, { 0xEA, 0xB7, 0xA7 },
	0x82EF, { 0xEA, 0xB7, 0xA8 },
	0x82F0, { 0xEA, 0xB7, 0xA9 },
	0x82F1, { 0xEA, 0xB7, 0xAA },
	0x82F2, { 0xEA, 0xB7, 0xAB },
	0x82F3, { 0xEA, 0xB7, 0xAC },
	0x82F4, { 0xEA, 0xB7, 0xAD },
	0x82F5, { 0xEA, 0xB7, 0xAE },
	0x82F6, { 0xEA, 0xB7, 0xAF },
	0x82F7, { 0xEA, 0xB7, 0xB0 },
	0x82F8, { 0xEA, 0xB7, 0xB1 },
	0x82F9, { 0xEA, 0xB7, 0xB2 },
	0x82FA, { 0xEA, 0xB7, 0xB3 },
	0x82FB, { 0xEA, 0xB7, 0xB4 },
	0x82FC, { 0xEA, 0xB7, 0xB5 },
	0x82FD, { 0xEA, 0xB7, 0xB6 },
	0x82FE, { 0xEA, 0xB7, 0xB7 },
	0x8341, { 0xEA, 0xB7, 0xBA },
	0x8342, { 0xEA, 0xB7, 0xBB },
	0x8343, { 0xEA, 0xB7, 0xBD },
	0x8344, { 0xEA, 0xB7, 0xBE },
	0x8345, { 0xEA, 0xB8, 0x82 },
	0x8346, { 0xEA, 0xB8, 0x83 },
	0x8347, { 0xEA, 0xB8, 0x84 },
	0x8348, { 0xEA, 0xB8, 0x85 },
	0x8349, { 0xEA, 0xB8, 0x86 },
	0x834A, { 0xEA, 0xB8, 0x87 },
	0x834B, { 0xEA, 0xB8, 0x8A },
	0x834C, { 0xEA, 0xB8, 0x8C },
	0x834D, { 0xEA, 0xB8, 0x8E },
	0x834E, { 0xEA, 0xB8, 0x8F },
	0x834F, { 0xEA, 0xB8, 0x90 },
	0x8350, { 0xEA, 0xB8, 0x91 },
	0x8351, { 0xEA, 0xB8, 0x92 },
	0x8352, { 0xEA, 0xB8, 0x93 },
	0x8353, { 0xEA, 0xB8, 0x95 },
	0x8354, { 0xEA, 0xB8, 0x96 },
	0x8355, { 0xEA, 0xB8, 0x97 },
	0x8356, { 0xEA, 0xB8, 0x98 },
	0x8357, { 0xEA, 0xB8, 0x99 },
	0x8358, { 0xEA, 0xB8, 0x9A },
	0x8359, { 0xEA, 0xB8, 0x9B },
	0x835A, { 0xEA, 0xB8, 0x9C },
	0x8361, { 0xEA, 0xB8, 0x9D },
	0x8362, { 0xEA, 0xB8, 0x9E },
	0x8363, { 0xEA, 0xB8, 0x9F },
	0x8364, { 0xEA, 0xB8, 0xA0 },
	0x8365, { 0xEA, 0xB8, 0xA1 },
	0x8366, { 0xEA, 0xB8, 0xA2 },
	0x8367, { 0xEA, 0xB8, 0xA3 },
	0x8368, { 0xEA, 0xB8, 0xA4 },
	0x8369, { 0xEA, 0xB8, 0xA5 },
	0x836A, { 0xEA, 0xB8, 0xA6 },
	0x836B, { 0xEA, 0xB8, 0xA7 },
	0x836C, { 0xEA, 0xB8, 0xA8 },
	0x836D, { 0xEA, 0xB8, 0xA9 },
	0x836E, { 0xEA, 0xB8, 0xAA },
	0x836F, { 0xEA, 0xB8, 0xAB },
	0x8370, { 0xEA, 0xB8, 0xAC },
	0x8371, { 0xEA, 0xB8, 0xAD },
	0x8372, { 0xEA, 0xB8, 0xAE },
	0x8373, { 0xEA, 0xB8, 0xAF },
	0x8374, { 0xEA, 0xB8, 0xB2 },
	0x8375, { 0xEA, 0xB8, 0xB3 },
	0x8376, { 0xEA, 0xB8, 0xB5 },
	0x8377, { 0xEA, 0xB8, 0xB6 },
	0x8378, { 0xEA, 0xB8, 0xB9 },
	0x8379, { 0xEA, 0xB8, 0xBB },
	0x837A, { 0xEA, 0xB8, 0xBC },
	0x8381, { 0xEA, 0xB8, 0xBD },
	0x8382, { 0xEA, 0xB8, 0xBE },
	0x8383, { 0xEA, 0xB8, 0xBF },
	0x8384, { 0xEA, 0xB9, 0x82 },
	0x8385, { 0xEA, 0xB9, 0x84 },
	0x8386, { 0xEA, 0xB9, 0x87 },
	0x8387, { 0xEA, 0xB9, 0x88 },
	0x8388, { 0xEA, 0xB9, 0x89 },
	0x8389, { 0xEA, 0xB9, 0x8B },
	0x838A, { 0xEA, 0xB9, 0x8F },
	0x838B, { 0xEA, 0xB9, 0x91 },
	0x838C, { 0xEA, 0xB9, 0x92 },
	0x838D, { 0xEA, 0xB9, 0x93 },
	0x838E, { 0xEA, 0xB9, 0x95 },
	0x838F, { 0xEA, 0xB9, 0x97 },
	0x8390, { 0xEA, 0xB9, 0x98 },
	0x8391, { 0xEA, 0xB9, 0x99 },
	0x8392, { 0xEA, 0xB9, 0x9A },
	0x8393, { 0xEA, 0xB9, 0x9B },
	0x8394, { 0xEA, 0xB9, 0x9E },
	0x8395, { 0xEA, 0xB9, 0xA2 },
	0x8396, { 0xEA, 0xB9, 0xA3 },
	0x8397, { 0xEA, 0xB9, 0xA4 },
	0x8398, { 0xEA, 0xB9, 0xA6 },
	0x8399, { 0xEA, 0xB9, 0xA7 },
	0x839A, { 0xEA, 0xB9, 0xAA },
	0x839B, { 0xEA, 0xB9, 0xAB },
	0x839C, { 0xEA, 0xB9, 0xAD },
	0x839D, { 0xEA, 0xB9, 0xAE },
	0x839E, { 0xEA, 0xB9, 0xAF },
	0x839F, { 0xEA, 0xB9, 0xB1 },
	0x83A0, { 0xEA, 0xB9, 0xB2 },
	0x83A1, { 0xEA, 0xB9, 0xB3 },
	0x83A2, { 0xEA, 0xB9, 0xB4 },
	0x83A3, { 0xEA, 0xB9, 0xB5 },
	0x83A4, { 0xEA, 0xB9, 0xB6 },
	0x83A5, { 0xEA, 0xB9, 0xB7 },
	0x83A6, { 0xEA, 0xB9, 0xBA },
	0x83A7, { 0xEA, 0xB9, 0xBE },
	0x83A8, { 0xEA, 0xB9, 0xBF },
	0x83A9, { 0xEA, 0xBA, 0x80 },
	0x83AA, { 0xEA, 0xBA, 0x81 },
	0x83AB, { 0xEA, 0xBA, 0x82 },
	0x83AC, { 0xEA, 0xBA, 0x83 },
	0x83AD, { 0xEA, 0xBA, 0x86 },
	0x83AE, { 0xEA, 0xBA, 0x87 },
	0x83AF, { 0xEA, 0xBA, 0x88 },
	0x83B0, { 0xEA, 0xBA, 0x89 },
	0x83B1, { 0xEA, 0xBA, 0x8A },
	0x83B2, { 0xEA, 0xBA, 0x8B },
	0x83B3, { 0xEA, 0xBA, 0x8D },
	0x83B4, { 0xEA, 0xBA, 0x8E },
	0x83B5, { 0xEA, 0xBA, 0x8F },
	0x83B6, { 0xEA, 0xBA, 0x90 },
	0x83B7, { 0xEA, 0xBA, 0x91 },
	0x83B8, { 0xEA, 0xBA, 0x92 },
	0x83B9, { 0xEA, 0xBA, 0x93 },
	0x83BA, { 0xEA, 0xBA, 0x94 },
	0x83BB, { 0xEA, 0xBA, 0x95 },
	0x83BC, { 0xEA, 0xBA, 0x96 },
	0x83BD, { 0xEA, 0xBA, 0x97 },
	0x83BE, { 0xEA, 0xBA, 0x98 },
	0x83BF, { 0xEA, 0xBA, 0x99 },
	0x83C0, { 0xEA, 0xBA, 0x9A },
	0x83C1, { 0xEA, 0xBA, 0x9B },
	0x83C2, { 0xEA, 0xBA, 0x9C },
	0x83C3, { 0xEA, 0xBA, 0x9D },
	0x83C4, { 0xEA, 0xBA, 0x9E },
	0x83C5, { 0xEA, 0xBA, 0x9F },
	0x83C6, { 0xEA, 0xBA, 0xA0 },
	0x83C7, { 0xEA, 0xBA, 0xA1 },
	0x83C8, { 0xEA, 0xBA, 0xA2 },
	0x83C9, { 0xEA, 0xBA, 0xA3 },
	0x83CA, { 0xEA, 0xBA, 0xA4 },
	0x83CB, { 0xEA, 0xBA, 0xA5 },
	0x83CC, { 0xEA, 0xBA, 0xA6 },
	0x83CD, { 0xEA, 0xBA, 0xA7 },
	0x83CE, { 0xEA, 0xBA, 0xA8 },
	0x83CF, { 0xEA, 0xBA, 0xA9 },
	0x83D0, { 0xEA, 0xBA, 0xAA },
	0x83D1, { 0xEA, 0xBA, 0xAB },
	0x83D2, { 0xEA, 0xBA, 0xAC },
	0x83D3, { 0xEA, 0xBA, 0xAD },
	0x83D4, { 0xEA, 0xBA, 0xAE },
	0x83D5, { 0xEA, 0xBA, 0xAF },
	0x83D6, { 0xEA, 0xBA, 0xB0 },
	0x83D7, { 0xEA, 0xBA, 0xB1 },
	0x83D8, { 0xEA, 0xBA, 0xB2 },
	0x83D9, { 0xEA, 0xBA, 0xB3 },
	0x83DA, { 0xEA, 0xBA, 0xB4 },
	0x83DB, { 0xEA, 0xBA, 0xB5 },
	0x83DC, { 0xEA, 0xBA, 0xB6 },
	0x83DD, { 0xEA, 0xBA, 0xB7 },
	0x83DE, { 0xEA, 0xBA, 0xB8 },
	0x83DF, { 0xEA, 0xBA, 0xB9 },
	0x83E0, { 0xEA, 0xBA, 0xBA },
	0x83E1, { 0xEA, 0xBA, 0xBB },
	0x83E2, { 0xEA, 0xBA, 0xBF },
	0x83E3, { 0xEA, 0xBB, 0x81 },
	0x83E4, { 0xEA, 0xBB, 0x82 },
	0x83E5, { 0xEA, 0xBB, 0x83 },
	0x83E6, { 0xEA, 0xBB, 0x85 },
	0x83E7, { 0xEA, 0xBB, 0x86 },
	0x83E8, { 0xEA, 0xBB, 0x87 },
	0x83E9, { 0xEA, 0xBB, 0x88 },
	0x83EA, { 0xEA, 0xBB, 0x89 },
	0x83EB, { 0xEA, 0xBB, 0x8A },
	0x83EC, { 0xEA, 0xBB, 0x8B },
	0x83ED, { 0xEA, 0xBB, 0x8E },
	0x83EE, { 0xEA, 0xBB, 0x92 },
	0x83EF, { 0xEA, 0xBB, 0x93 },
	0x83F0, { 0xEA, 0xBB, 0x94 },
	0x83F1, { 0xEA, 0xBB, 0x95 },
	0x83F2, { 0xEA, 0xBB, 0x96 },
	0x83F3, { 0xEA, 0xBB, 0x97 },
	0x83F4, { 0xEA, 0xBB, 0x9A },
	0x83F5, { 0xEA, 0xBB, 0x9B },
	0x83F6, { 0xEA, 0xBB, 0x9D },
	0x83F7, { 0xEA, 0xBB, 0x9E },
	0x83F8, { 0xEA, 0xBB, 0x9F },
	0x83F9, { 0xEA, 0xBB, 0xA0 },
	0x83FA, { 0xEA, 0xBB, 0xA1 },
	0x83FB, { 0xEA, 0xBB, 0xA2 },
	0x83FC, { 0xEA, 0xBB, 0xA3 },
	0x83FD, { 0xEA, 0xBB, 0xA4 },
	0x83FE, { 0xEA, 0xBB, 0xA5 },
	0x8441, { 0xEA, 0xBB, 0xA6 },
	0x8442, { 0xEA, 0xBB, 0xA7 },
	0x8443, { 0xEA, 0xBB, 0xA9 },
	0x8444, { 0xEA, 0xBB, 0xAA },
	0x8445, { 0xEA, 0xBB, 0xAC },
	0x8446, { 0xEA, 0xBB, 0xAE },
	0x8447, { 0xEA, 0xBB, 0xAF },
	0x8448, { 0xEA, 0xBB, 0xB0 },
	0x8449, { 0xEA, 0xBB, 0xB1 },
	0x844A, { 0xEA, 0xBB, 0xB2 },
	0x844B, { 0xEA, 0xBB, 0xB3 },
	0x844C, { 0xEA, 0xBB, 0xB5 },
	0x844D, { 0xEA, 0xBB, 0xB6 },
	0x844E, { 0xEA, 0xBB, 0xB7 },
	0x844F, { 0xEA, 0xBB, 0xB9 },
	0x8450, { 0xEA, 0xBB, 0xBA },
	0x8451, { 0xEA, 0xBB, 0xBB },
	0x8452, { 0xEA, 0xBB, 0xBD },
	0x8453, { 0xEA, 0xBB, 0xBE },
	0x8454, { 0xEA, 0xBB, 0xBF },
	0x8455, { 0xEA, 0xBC, 0x80 },
	0x8456, { 0xEA, 0xBC, 0x81 },
	0x8457, { 0xEA, 0xBC, 0x82 },
	0x8458, { 0xEA, 0xBC, 0x83 },
	0x8459, { 0xEA, 0xBC, 0x84 },
	0x845A, { 0xEA, 0xBC, 0x85 },
	0x8461, { 0xEA, 0xBC, 0x86 },
	0x8462, { 0xEA, 0xBC, 0x89 },
	0x8463, { 0xEA, 0xBC, 0x8A },
	0x8464, { 0xEA, 0xBC, 0x8B },
	0x8465, { 0xEA, 0xBC, 0x8C },
	0x8466, { 0xEA, 0xBC, 0x8E },
	0x8467, { 0xEA, 0xBC, 0x8F },
	0x8468, { 0xEA, 0xBC, 0x91 },
	0x8469, { 0xEA, 0xBC, 0x92 },
	0x846A, { 0xEA, 0xBC, 0x93 },
	0x846B, { 0xEA, 0xBC, 0x94 },
	0x846C, { 0xEA, 0xBC, 0x95 },
	0x846D, { 0xEA, 0xBC, 0x96 },
	0x846E, { 0xEA, 0xBC, 0x97 },
	0x846F, { 0xEA, 0xBC, 0x98 },
	0x8470, { 0xEA, 0xBC, 0x99 },
	0x8471, { 0xEA, 0xBC, 0x9A },
	0x8472, { 0xEA, 0xBC, 0x9B },
	0x8473, { 0xEA, 0xBC, 0x9C },
	0x8474, { 0xEA, 0xBC, 0x9D },
	0x8475, { 0xEA, 0xBC, 0x9E },
	0x8476, { 0xEA, 0xBC, 0x9F },
	0x8477, { 0xEA, 0xBC, 0xA0 },
	0x8478, { 0xEA, 0xBC, 0xA1 },
	0x8479, { 0xEA, 0xBC, 0xA2 },
	0x847A, { 0xEA, 0xBC, 0xA3 },
	0x8481, { 0xEA, 0xBC, 0xA4 },
	0x8482, { 0xEA, 0xBC, 0xA5 },
	0x8483, { 0xEA, 0xBC, 0xA6 },
	0x8484, { 0xEA, 0xBC, 0xA7 },
	0x8485, { 0xEA, 0xBC, 0xA8 },
	0x8486, { 0xEA, 0xBC, 0xA9 },
	0x8487, { 0xEA, 0xBC, 0xAA },
	0x8488, { 0xEA, 0xBC, 0xAB },
	0x8489, { 0xEA, 0xBC, 0xAE },
	0x848A, { 0xEA, 0xBC, 0xAF },
	0x848B, { 0xEA, 0xBC, 0xB1 },
	0x848C, { 0xEA, 0xBC, 0xB3 },
	0x848D, { 0xEA, 0xBC, 0xB5 },
	0x848E, { 0xEA, 0xBC, 0xB6 },
	0x848F, { 0xEA, 0xBC, 0xB7 },
	0x8490, { 0xEA, 0xBC, 0xB8 },
	0x8491, { 0xEA, 0xBC, 0xB9 },
	0x8492, { 0xEA, 0xBC, 0xBA },
	0x8493, { 0xEA, 0xBC, 0xBB },
	0x8494, { 0xEA, 0xBC, 0xBE },
	0x8495, { 0xEA, 0xBD, 0x80 },
	0x8496, { 0xEA, 0xBD, 0x84 },
	0x8497, { 0xEA, 0xBD, 0x85 },
	0x8498, { 0xEA, 0xBD, 0x86 },
	0x8499, { 0xEA, 0xBD, 0x87 },
	0x849A, { 0xEA, 0xBD, 0x8A },
	0x849B, { 0xEA, 0xBD, 0x8B },
	0x849C, { 0xEA, 0xBD, 0x8C },
	0x849D, { 0xEA, 0xBD, 0x8D },
	0x849E, { 0xEA, 0xBD, 0x8E },
	0x849F, { 0xEA, 0xBD, 0x8F },
	0x84A0, { 0xEA, 0xBD, 0x91 },
	0x84A1, { 0xEA, 0xBD, 0x92 },
	0x84A2, { 0xEA, 0xBD, 0x93 },
	0x84A3, { 0xEA, 0xBD, 0x94 },
	0x84A4, { 0xEA, 0xBD, 0x95 },
	0x84A5, { 0xEA, 0xBD, 0x96 },
	0x84A6, { 0xEA, 0xBD, 0x97 },
	0x84A7, { 0xEA, 0xBD, 0x98 },
	0x84A8, { 0xEA, 0xBD, 0x99 },
	0x84A9, { 0xEA, 0xBD, 0x9A },
	0x84AA, { 0xEA, 0xBD, 0x9B },
	0x84AB, { 0xEA, 0xBD, 0x9E },
	0x84AC, { 0xEA, 0xBD, 0x9F },
	0x84AD, { 0xEA, 0xBD, 0xA0 },
	0x84AE, { 0xEA, 0xBD, 0xA1 },
	0x84AF, { 0xEA, 0xBD, 0xA2 },
	0x84B0, { 0xEA, 0xBD, 0xA3 },
	0x84B1, { 0xEA, 0xBD, 0xA6 },
	0x84B2, { 0xEA, 0xBD, 0xA7 },
	0x84B3, { 0xEA, 0xBD, 0xA8 },
	0x84B4, { 0xEA, 0xBD, 0xA9 },
	0x84B5, { 0xEA, 0xBD, 0xAA },
	0x84B6, { 0xEA, 0xBD, 0xAB },
	0x84B7, { 0xEA, 0xBD, 0xAC },
	0x84B8, { 0xEA, 0xBD, 0xAD },
	0x84B9, { 0xEA, 0xBD, 0xAE },
	0x84BA, { 0xEA, 0xBD, 0xAF },
	0x84BB, { 0xEA, 0xBD, 0xB0 },
	0x84BC, { 0xEA, 0xBD, 0xB1 },
	0x84BD, { 0xEA, 0xBD, 0xB2 },
	0x84BE, { 0xEA, 0xBD, 0xB3 },
	0x84BF, { 0xEA, 0xBD, 0xB4 },
	0x84C0, { 0xEA, 0xBD, 0xB5 },
	0x84C1, { 0xEA, 0xBD, 0xB6 },
	0x84C2, { 0xEA, 0xBD, 0xB7 },
	0x84C3, { 0xEA, 0xBD, 0xB8 },
	0x84C4, { 0xEA, 0xBD, 0xBA },
	0x84C5, { 0xEA, 0xBD, 0xBB },
	0x84C6, { 0xEA, 0xBD, 0xBC },
	0x84C7, { 0xEA, 0xBD, 0xBD },
	0x84C8, { 0xEA, 0xBD, 0xBE },
	0x84C9, { 0xEA, 0xBD, 0xBF },
	0x84CA, { 0xEA, 0xBE, 0x81 },
	0x84CB, { 0xEA, 0xBE, 0x82 },
	0x84CC, { 0xEA, 0xBE, 0x83 },
	0x84CD, { 0xEA, 0xBE, 0x85 },
	0x84CE, { 0xEA, 0xBE, 0x86 },
	0x84CF, { 0xEA, 0xBE, 0x87 },
	0x84D0, { 0xEA, 0xBE, 0x89 },
	0x84D1, { 0xEA, 0xBE, 0x8A },
	0x84D2, { 0xEA, 0xBE, 0x8B },
	0x84D3, { 0xEA, 0xBE, 0x8C },
	0x84D4, { 0xEA, 0xBE, 0x8D },
	0x84D5, { 0xEA, 0xBE, 0x8E },
	0x84D6, { 0xEA, 0xBE, 0x8F },
	0x84D7, { 0xEA, 0xBE, 0x92 },
	0x84D8, { 0xEA, 0xBE, 0x93 },
	0x84D9, { 0xEA, 0xBE, 0x94 },
	0x84DA, { 0xEA, 0xBE, 0x96 },
	0x84DB, { 0xEA, 0xBE, 0x97 },
	0x84DC, { 0xEA, 0xBE, 0x98 },
	0x84DD, { 0xEA, 0xBE, 0x99 },
	0x84DE, { 0xEA, 0xBE, 0x9A },
	0x84DF, { 0xEA, 0xBE, 0x9B },
	0x84E0, { 0xEA, 0xBE, 0x9D },
	0x84E1, { 0xEA, 0xBE, 0x9E },
	0x84E2, { 0xEA, 0xBE, 0x9F },
	0x84E3, { 0xEA, 0xBE, 0xA0 },
	0x84E4, { 0xEA, 0xBE, 0xA1 },
	0x84E5, { 0xEA, 0xBE, 0xA2 },
	0x84E6, { 0xEA, 0xBE, 0xA3 },
	0x84E7, { 0xEA, 0xBE, 0xA4 },
	0x84E8, { 0xEA, 0xBE, 0xA5 },
	0x84E9, { 0xEA, 0xBE, 0xA6 },
	0x84EA, { 0xEA, 0xBE, 0xA7 },
	0x84EB, { 0xEA, 0xBE, 0xA8 },
	0x84EC, { 0xEA, 0xBE, 0xA9 },
	0x84ED, { 0xEA, 0xBE, 0xAA },
	0x84EE, { 0xEA, 0xBE, 0xAB },
	0x84EF, { 0xEA, 0xBE, 0xAC },
	0x84F0, { 0xEA, 0xBE, 0xAD },
	0x84F1, { 0xEA, 0xBE, 0xAE },
	0x84F2, { 0xEA, 0xBE, 0xAF },
	0x84F3, { 0xEA, 0xBE, 0xB0 },
	0x84F4, { 0xEA, 0xBE, 0xB1 },
	0x84F5, { 0xEA, 0xBE, 0xB2 },
	0x84F6, { 0xEA, 0xBE, 0xB3 },
	0x84F7, { 0xEA, 0xBE, 0xB4 },
	0x84F8, { 0xEA, 0xBE, 0xB5 },
	0x84F9, { 0xEA, 0xBE, 0xB6 },
	0x84FA, { 0xEA, 0xBE, 0xB7 },
	0x84FB, { 0xEA, 0xBE, 0xBA },
	0x84FC, { 0xEA, 0xBE, 0xBB },
	0x84FD, { 0xEA, 0xBE, 0xBD },
	0x84FE, { 0xEA, 0xBE, 0xBE },
	0x8541, { 0xEA, 0xBE, 0xBF },
	0x8542, { 0xEA, 0xBF, 0x81 },
	0x8543, { 0xEA, 0xBF, 0x82 },
	0x8544, { 0xEA, 0xBF, 0x83 },
	0x8545, { 0xEA, 0xBF, 0x84 },
	0x8546, { 0xEA, 0xBF, 0x85 },
	0x8547, { 0xEA, 0xBF, 0x86 },
	0x8548, { 0xEA, 0xBF, 0x8A },
	0x8549, { 0xEA, 0xBF, 0x8C },
	0x854A, { 0xEA, 0xBF, 0x8F },
	0x854B, { 0xEA, 0xBF, 0x90 },
	0x854C, { 0xEA, 0xBF, 0x91 },
	0x854D, { 0xEA, 0xBF, 0x92 },
	0x854E, { 0xEA, 0xBF, 0x93 },
	0x854F, { 0xEA, 0xBF, 0x95 },
	0x8550, { 0xEA, 0xBF, 0x96 },
	0x8551, { 0xEA, 0xBF, 0x97 },
	0x8552, { 0xEA, 0xBF, 0x98 },
	0x8553, { 0xEA, 0xBF, 0x99 },
	0x8554, { 0xEA, 0xBF, 0x9A },
	0x8555, { 0xEA, 0xBF, 0x9B },
	0x8556, { 0xEA, 0xBF, 0x9D },
	0x8557, { 0xEA, 0xBF, 0x9E },
	0x8558, { 0xEA, 0xBF, 0x9F },
	0x8559, { 0xEA, 0xBF, 0xA0 },
	0x855A, { 0xEA, 0xBF, 0xA1 },
	0x8561, { 0xEA, 0xBF, 0xA2 },
	0x8562, { 0xEA, 0xBF, 0xA3 },
	0x8563, { 0xEA, 0xBF, 0xA4 },
	0x8564, { 0xEA, 0xBF, 0xA5 },
	0x8565, { 0xEA, 0xBF, 0xA6 },
	0x8566, { 0xEA, 0xBF, 0xA7 },
	0x8567, { 0xEA, 0xBF, 0xAA },
	0x8568, { 0xEA, 0xBF, 0xAB },
	0x8569, { 0xEA, 0xBF, 0xAC },
	0x856A, { 0xEA, 0xBF, 0xAD },
	0x856B, { 0xEA, 0xBF, 0xAE },
	0x856C, { 0xEA, 0xBF, 0xAF },
	0x856D, { 0xEA, 0xBF, 0xB2 },
	0x856E, { 0xEA, 0xBF, 0xB3 },
	0x856F, { 0xEA, 0xBF, 0xB5 },
	0x8570, { 0xEA, 0xBF, 0xB6 },
	0x8571, { 0xEA, 0xBF, 0xB7 },
	0x8572, { 0xEA, 0xBF, 0xB9 },
	0x8573, { 0xEA, 0xBF, 0xBA },
	0x8574, { 0xEA, 0xBF, 0xBB },
	0x8575, { 0xEA, 0xBF, 0xBC },
	0x8576, { 0xEA, 0xBF, 0xBD },
	0x8577, { 0xEA, 0xBF, 0xBE },
	0x8578, { 0xEA, 0xBF, 0xBF },
	0x8579, { 0xEB, 0x80, 0x82 },
	0x857A, { 0xEB, 0x80, 0x83 },
	0x8581, { 0xEB, 0x80, 0x85 },
	0x8582, { 0xEB, 0x80, 0x86 },
	0x8583, { 0xEB, 0x80, 0x87 },
	0x8584, { 0xEB, 0x80, 0x88 },
	0x8585, { 0xEB, 0x80, 0x89 },
	0x8586, { 0xEB, 0x80, 0x8A },
	0x8587, { 0xEB, 0x80, 0x8B },
	0x8588, { 0xEB, 0x80, 0x8D },
	0x8589, { 0xEB, 0x80, 0x8E },
	0x858A, { 0xEB, 0x80, 0x8F },
	0x858B, { 0xEB, 0x80, 0x91 },
	0x858C, { 0xEB, 0x80, 0x92 },
	0x858D, { 0xEB, 0x80, 0x93 },
	0x858E, { 0xEB, 0x80, 0x95 },
	0x858F, { 0xEB, 0x80, 0x96 },
	0x8590, { 0xEB, 0x80, 0x97 },
	0x8591, { 0xEB, 0x80, 0x98 },
	0x8592, { 0xEB, 0x80, 0x99 },
	0x8593, { 0xEB, 0x80, 0x9A },
	0x8594, { 0xEB, 0x80, 0x9B },
	0x8595, { 0xEB, 0x80, 0x9E },
	0x8596, { 0xEB, 0x80, 0x9F },
	0x8597, { 0xEB, 0x80, 0xA0 },
	0x8598, { 0xEB, 0x80, 0xA1 },
	0x8599, { 0xEB, 0x80, 0xA2 },
	0x859A, { 0xEB, 0x80, 0xA3 },
	0x859B, { 0xEB, 0x80, 0xA4 },
	0x859C, { 0xEB, 0x80, 0xA5 },
	0x859D, { 0xEB, 0x80, 0xA6 },
	0x859E, { 0xEB, 0x80, 0xA7 },
	0x859F, { 0xEB, 0x80, 0xA9 },
	0x85A0, { 0xEB, 0x80, 0xAA },
	0x85A1, { 0xEB, 0x80, 0xAB },
	0x85A2, { 0xEB, 0x80, 0xAC },
	0x85A3, { 0xEB, 0x80, 0xAD },
	0x85A4, { 0xEB, 0x80, 0xAE },
	0x85A5, { 0xEB, 0x80, 0xAF },
	0x85A6, { 0xEB, 0x80, 0xB0 },
	0x85A7, { 0xEB, 0x80, 0xB1 },
	0x85A8, { 0xEB, 0x80, 0xB2 },
	0x85A9, { 0xEB, 0x80, 0xB3 },
	0x85AA, { 0xEB, 0x80, 0xB4 },
	0x85AB, { 0xEB, 0x80, 0xB5 },
	0x85AC, { 0xEB, 0x80, 0xB6 },
	0x85AD, { 0xEB, 0x80, 0xB7 },
	0x85AE, { 0xEB, 0x80, 0xB8 },
	0x85AF, { 0xEB, 0x80, 0xB9 },
	0x85B0, { 0xEB, 0x80, 0xBA },
	0x85B1, { 0xEB, 0x80, 0xBB },
	0x85B2, { 0xEB, 0x80, 0xBC },
	0x85B3, { 0xEB, 0x80, 0xBD },
	0x85B4, { 0xEB, 0x80, 0xBE },
	0x85B5, { 0xEB, 0x80, 0xBF },
	0x85B6, { 0xEB, 0x81, 0x80 },
	0x85B7, { 0xEB, 0x81, 0x81 },
	0x85B8, { 0xEB, 0x81, 0x82 },
	0x85B9, { 0xEB, 0x81, 0x83 },
	0x85BA, { 0xEB, 0x81, 0x86 },
	0x85BB, { 0xEB, 0x81, 0x87 },
	0x85BC, { 0xEB, 0x81, 0x89 },
	0x85BD, { 0xEB, 0x81, 0x8B },
	0x85BE, { 0xEB, 0x81, 0x8D },
	0x85BF, { 0xEB, 0x81, 0x8F },
	0x85C0, { 0xEB, 0x81, 0x90 },
	0x85C1, { 0xEB, 0x81, 0x91 },
	0x85C2, { 0xEB, 0x81, 0x92 },
	0x85C3, { 0xEB, 0x81, 0x96 },
	0x85C4, { 0xEB, 0x81, 0x98 },
	0x85C5, { 0xEB, 0x81, 0x9A },
	0x85C6, { 0xEB, 0x81, 0x9B },
	0x85C7, { 0xEB, 0x81, 0x9C },
	0x85C8, { 0xEB, 0x81, 0x9E },
	0x85C9, { 0xEB, 0x81, 0x9F },
	0x85CA, { 0xEB, 0x81, 0xA0 },
	0x85CB, { 0xEB, 0x81, 0xA1 },
	0x85CC, { 0xEB, 0x81, 0xA2 },
	0x85CD, { 0xEB, 0x81, 0xA3 },
	0x85CE, { 0xEB, 0x81, 0xA4 },
	0x85CF, { 0xEB, 0x81, 0xA5 },
	0x85D0, { 0xEB, 0x81, 0xA6 },
	0x85D1, { 0xEB, 0x81, 0xA7 },
	0x85D2, { 0xEB, 0x81, 0xA8 },
	0x85D3, { 0xEB, 0x81, 0xA9 },
	0x85D4, { 0xEB, 0x81, 0xAA },
	0x85D5, { 0xEB, 0x81, 0xAB },
	0x85D6, { 0xEB, 0x81, 0xAC },
	0x85D7, { 0xEB, 0x81, 0xAD },
	0x85D8, { 0xEB, 0x81, 0xAE },
	0x85D9, { 0xEB, 0x81, 0xAF },
	0x85DA, { 0xEB, 0x81, 0xB0 },
	0x85DB, { 0xEB, 0x81, 0xB1 },
	0x85DC, { 0xEB, 0x81, 0xB2 },
	0x85DD, { 0xEB, 0x81, 0xB3 },
	0x85DE, { 0xEB, 0x81, 0xB4 },
	0x85DF, { 0xEB, 0x81, 0xB5 },
	0x85E0, { 0xEB, 0x81, 0xB6 },
	0x85E1, { 0xEB, 0x81, 0xB7 },
	0x85E2, { 0xEB, 0x81, 0xB8 },
	0x85E3, { 0xEB, 0x81, 0xB9 },
	0x85E4, { 0xEB, 0x81, 0xBA },
	0x85E5, { 0xEB, 0x81, 0xBB },
	0x85E6, { 0xEB, 0x81, 0xBE },
	0x85E7, { 0xEB, 0x81, 0xBF },
	0x85E8, { 0xEB, 0x82, 0x81 },
	0x85E9, { 0xEB, 0x82, 0x82 },
	0x85EA, { 0xEB, 0x82, 0x83 },
	0x85EB, { 0xEB, 0x82, 0x85 },
	0x85EC, { 0xEB, 0x82, 0x86 },
	0x85ED, { 0xEB, 0x82, 0x87 },
	0x85EE, { 0xEB, 0x82, 0x88 },
	0x85EF, { 0xEB, 0x82, 0x89 },
	0x85F0, { 0xEB, 0x82, 0x8A },
	0x85F1, { 0xEB, 0x82, 0x8B },
	0x85F2, { 0xEB, 0x82, 0x8E },
	0x85F3, { 0xEB, 0x82, 0x90 },
	0x85F4, { 0xEB, 0x82, 0x92 },
	0x85F5, { 0xEB, 0x82, 0x93 },
	0x85F6, { 0xEB, 0x82, 0x94 },
	0x85F7, { 0xEB, 0x82, 0x95 },
	0x85F8, { 0xEB, 0x82, 0x96 },
	0x85F9, { 0xEB, 0x82, 0x97 },
	0x85FA, { 0xEB, 0x82, 0x9B },
	0x85FB, { 0xEB, 0x82, 0x9D },
	0x85FC, { 0xEB, 0x82, 0x9E },
	0x85FD, { 0xEB, 0x82, 0xA3 },
	0x85FE, { 0xEB, 0x82, 0xA4 },
	0x8641, { 0xEB, 0x82, 0xA5 },
	0x8642, { 0xEB, 0x82, 0xA6 },
	0x8643, { 0xEB, 0x82, 0xA7 },
	0x8644, { 0xEB, 0x82, 0xAA },
	0x8645, { 0xEB, 0x82, 0xB0 },
	0x8646, { 0xEB, 0x82, 0xB2 },
	0x8647, { 0xEB, 0x82, 0xB6 },
	0x8648, { 0xEB, 0x82, 0xB7 },
	0x8649, { 0xEB, 0x82, 0xB9 },
	0x864A, { 0xEB, 0x82, 0xBA },
	0x864B, { 0xEB, 0x82, 0xBB },
	0x864C, { 0xEB, 0x82, 0xBD },
	0x864D, { 0xEB, 0x82, 0xBE },
	0x864E, { 0xEB, 0x82, 0xBF },
	0x864F, { 0xEB, 0x83, 0x80 },
	0x8650, { 0xEB, 0x83, 0x81 },
	0x8651, { 0xEB, 0x83, 0x82 },
	0x8652, { 0xEB, 0x83, 0x83 },
	0x8653, { 0xEB, 0x83, 0x86 },
	0x8654, { 0xEB, 0x83, 0x8A },
	0x8655, { 0xEB, 0x83, 0x8B },
	0x8656, { 0xEB, 0x83, 0x8C },
	0x8657, { 0xEB, 0x83, 0x8D },
	0x8658, { 0xEB, 0x83, 0x8E },
	0x8659, { 0xEB, 0x83, 0x8F },
	0x865A, { 0xEB, 0x83, 0x92 },
	0x8661, { 0xEB, 0x83, 0x93 },
	0x8662, { 0xEB, 0x83, 0x95 },
	0x8663, { 0xEB, 0x83, 0x96 },
	0x8664, { 0xEB, 0x83, 0x97 },
	0x8665, { 0xEB, 0x83, 0x99 },
	0x8666, { 0xEB, 0x83, 0x9A },
	0x8667, { 0xEB, 0x83, 0x9B },
	0x8668, { 0xEB, 0x83, 0x9C },
	0x8669, { 0xEB, 0x83, 0x9D },
	0x866A, { 0xEB, 0x83, 0x9E },
	0x866B, { 0xEB, 0x83, 0x9F },
	0x866C, { 0xEB, 0x83, 0xA1 },
	0x866D, { 0xEB, 0x83, 0xA2 },
	0x866E, { 0xEB, 0x83, 0xA3 },
	0x866F, { 0xEB, 0x83, 0xA4 },
	0x8670, { 0xEB, 0x83, 0xA6 },
	0x8671, { 0xEB, 0x83, 0xA7 },
	0x8672, { 0xEB, 0x83, 0xA8 },
	0x8673, { 0xEB, 0x83, 0xA9 },
	0x8674, { 0xEB, 0x83, 0xAA },
	0x8675, { 0xEB, 0x83, 0xAB },
	0x8676, { 0xEB, 0x83, 0xAC },
	0x8677, { 0xEB, 0x83, 0xAD },
	0x8678, { 0xEB, 0x83, 0xAE },
	0x8679, { 0xEB, 0x83, 0xAF },
	0x867A, { 0xEB, 0x83, 0xB0 },
	0x8681, { 0xEB, 0x83, 0xB1 },
	0x8682, { 0xEB, 0x83, 0xB2 },
	0x8683, { 0xEB, 0x83, 0xB3 },
	0x8684, { 0xEB, 0x83, 0xB4 },
	0x8685, { 0xEB, 0x83, 0xB5 },
	0x8686, { 0xEB, 0x83, 0xB6 },
	0x8687, { 0xEB, 0x83, 0xB7 },
	0x8688, { 0xEB, 0x83, 0xB8 },
	0x8689, { 0xEB, 0x83, 0xB9 },
	0x868A, { 0xEB, 0x83, 0xBA },
	0x868B, { 0xEB, 0x83, 0xBB },
	0x868C, { 0xEB, 0x83, 0xBC },
	0x868D, { 0xEB, 0x83, 0xBD },
	0x868E, { 0xEB, 0x83, 0xBE },
	0x868F, { 0xEB, 0x83, 0xBF },
	0x8690, { 0xEB, 0x84, 0x80 },
	0x8691, { 0xEB, 0x84, 0x81 },
	0x8692, { 0xEB, 0x84, 0x82 },
	0x8693, { 0xEB, 0x84, 0x83 },
	0x8694, { 0xEB, 0x84, 0x84 },
	0x8695, { 0xEB, 0x84, 0x85 },
	0x8696, { 0xEB, 0x84, 0x86 },
	0x8697, { 0xEB, 0x84, 0x87 },
	0x8698, { 0xEB, 0x84, 0x8A },
	0x8699, { 0xEB, 0x84, 0x8D },
	0x869A, { 0xEB, 0x84, 0x8E },
	0x869B, { 0xEB, 0x84, 0x8F },
	0x869C, { 0xEB, 0x84, 0x91 },
	0x869D, { 0xEB, 0x84, 0x94 },
	0x869E, { 0xEB, 0x84, 0x95 },
	0x869F, { 0xEB, 0x84, 0x96 },
	0x86A0, { 0xEB, 0x84, 0x97 },
	0x86A1, { 0xEB, 0x84, 0x9A },
	0x86A2, { 0xEB, 0x84, 0x9E },
	0x86A3, { 0xEB, 0x84, 0x9F },
	0x86A4, { 0xEB, 0x84, 0xA0 },
	0x86A5, { 0xEB, 0x84, 0xA1 },
	0x86A6, { 0xEB, 0x84, 0xA2 },
	0x86A7, { 0xEB, 0x84, 0xA6 },
	0x86A8, { 0xEB, 0x84, 0xA7 },
	0x86A9, { 0xEB, 0x84, 0xA9 },
	0x86AA, { 0xEB, 0x84, 0xAA },
	0x86AB, { 0xEB, 0x84, 0xAB },
	0x86AC, { 0xEB, 0x84, 0xAD },
	0x86AD, { 0xEB, 0x84, 0xAE },
	0x86AE, { 0xEB, 0x84, 0xAF },
	0x86AF, { 0xEB, 0x84, 0xB0 },
	0x86B0, { 0xEB, 0x84, 0xB1 },
	0x86B1, { 0xEB, 0x84, 0xB2 },
	0x86B2, { 0xEB, 0x84, 0xB3 },
	0x86B3, { 0xEB, 0x84, 0xB6 },
	0x86B4, { 0xEB, 0x84, 0xBA },
	0x86B5, { 0xEB, 0x84, 0xBB },
	0x86B6, { 0xEB, 0x84, 0xBC },
	0x86B7, { 0xEB, 0x84, 0xBD },
	0x86B8, { 0xEB, 0x84, 0xBE },
	0x86B9, { 0xEB, 0x84, 0xBF },
	0x86BA, { 0xEB, 0x85, 0x82 },
	0x86BB, { 0xEB, 0x85, 0x83 },
	0x86BC, { 0xEB, 0x85, 0x85 },
	0x86BD, { 0xEB, 0x85, 0x86 },
	0x86BE, { 0xEB, 0x85, 0x87 },
	0x86BF, { 0xEB, 0x85, 0x89 },
	0x86C0, { 0xEB, 0x85, 0x8A },
	0x86C1, { 0xEB, 0x85, 0x8B },
	0x86C2, { 0xEB, 0x85, 0x8C },
	0x86C3, { 0xEB, 0x85, 0x8D },
	0x86C4, { 0xEB, 0x85, 0x8E },
	0x86C5, { 0xEB, 0x85, 0x8F },
	0x86C6, { 0xEB, 0x85, 0x92 },
	0x86C7, { 0xEB, 0x85, 0x93 },
	0x86C8, { 0xEB, 0x85, 0x96 },
	0x86C9, { 0xEB, 0x85, 0x97 },
	0x86CA, { 0xEB, 0x85, 0x99 },
	0x86CB, { 0xEB, 0x85, 0x9A },
	0x86CC, { 0xEB, 0x85, 0x9B },
	0x86CD, { 0xEB, 0x85, 0x9D },
	0x86CE, { 0xEB, 0x85, 0x9E },
	0x86CF, { 0xEB, 0x85, 0x9F },
	0x86D0, { 0xEB, 0x85, 0xA1 },
	0x86D1, { 0xEB, 0x85, 0xA2 },
	0x86D2, { 0xEB, 0x85, 0xA3 },
	0x86D3, { 0xEB, 0x85, 0xA4 },
	0x86D4, { 0xEB, 0x85, 0xA5 },
	0x86D5, { 0xEB, 0x85, 0xA6 },
	0x86D6, { 0xEB, 0x85, 0xA7 },
	0x86D7, { 0xEB, 0x85, 0xA8 },
	0x86D8, { 0xEB, 0x85, 0xA9 },
	0x86D9, { 0xEB, 0x85, 0xAA },
	0x86DA, { 0xEB, 0x85, 0xAB },
	0x86DB, { 0xEB, 0x85, 0xAC },
	0x86DC, { 0xEB, 0x85, 0xAD },
	0x86DD, { 0xEB, 0x85, 0xAE },
	0x86DE, { 0xEB, 0x85, 0xAF },
	0x86DF, { 0xEB, 0x85, 0xB0 },
	0x86E0, { 0xEB, 0x85, 0xB1 },
	0x86E1, { 0xEB, 0x85, 0xB2 },
	0x86E2, { 0xEB, 0x85, 0xB3 },
	0x86E3, { 0xEB, 0x85, 0xB4 },
	0x86E4, { 0xEB, 0x85, 0xB5 },
	0x86E5, { 0xEB, 0x85, 0xB6 },
	0x86E6, { 0xEB, 0x85, 0xB7 },
	0x86E7, { 0xEB, 0x85, 0xBA },
	0x86E8, { 0xEB, 0x85, 0xBB },
	0x86E9, { 0xEB, 0x85, 0xBD },
	0x86EA, { 0xEB, 0x85, 0xBE },
	0x86EB, { 0xEB, 0x85, 0xBF },
	0x86EC, { 0xEB, 0x86, 0x81 },
	0x86ED, { 0xEB, 0x86, 0x83 },
	0x86EE, { 0xEB, 0x86, 0x84 },
	0x86EF, { 0xEB, 0x86, 0x85 },
	0x86F0, { 0xEB, 0x86, 0x86 },
	0x86F1, { 0xEB, 0x86, 0x87 },
	0x86F2, { 0xEB, 0x86, 0x8A },
	0x86F3, { 0xEB, 0x86, 0x8C },
	0x86F4, { 0xEB, 0x86, 0x8E },
	0x86F5, { 0xEB, 0x86, 0x8F },
	0x86F6, { 0xEB, 0x86, 0x90 },
	0x86F7, { 0xEB, 0x86, 0x91 },
	0x86F8, { 0xEB, 0x86, 0x95 },
	0x86F9, { 0xEB, 0x86, 0x96 },
	0x86FA, { 0xEB, 0x86, 0x97 },
	0x86FB, { 0xEB, 0x86, 0x99 },
	0x86FC, { 0xEB, 0x86, 0x9A },
	0x86FD, { 0xEB, 0x86, 0x9B },
	0x86FE, { 0xEB, 0x86, 0x9D },
	0x8741, { 0xEB, 0x86, 0x9E },
	0x8742, { 0xEB, 0x86, 0x9F },
	0x8743, { 0xEB, 0x86, 0xA0 },
	0x8744, { 0xEB, 0x86, 0xA1 },
	0x8745, { 0xEB, 0x86, 0xA2 },
	0x8746, { 0xEB, 0x86, 0xA3 },
	0x8747, { 0xEB, 0x86, 0xA4 },
	0x8748, { 0xEB, 0x86, 0xA5 },
	0x8749, { 0xEB, 0x86, 0xA6 },
	0x874A, { 0xEB, 0x86, 0xA7 },
	0x874B, { 0xEB, 0x86, 0xA9 },
	0x874C, { 0xEB, 0x86, 0xAA },
	0x874D, { 0xEB, 0x86, 0xAB },
	0x874E, { 0xEB, 0x86, 0xAC },
	0x874F, { 0xEB, 0x86, 0xAD },
	0x8750, { 0xEB, 0x86, 0xAE },
	0x8751, { 0xEB, 0x86, 0xAF },
	0x8752, { 0xEB, 0x86, 0xB0 },
	0x8753, { 0xEB, 0x86, 0xB1 },
	0x8754, { 0xEB, 0x86, 0xB2 },
	0x8755, { 0xEB, 0x86, 0xB3 },
	0x8756, { 0xEB, 0x86, 0xB4 },
	0x8757, { 0xEB, 0x86, 0xB5 },
	0x8758, { 0xEB, 0x86, 0xB6 },
	0x8759, { 0xEB, 0x86, 0xB7 },
	0x875A, { 0xEB, 0x86, 0xB8 },
	0x8761, { 0xEB, 0x86, 0xB9 },
	0x8762, { 0xEB, 0x86, 0xBA },
	0x8763, { 0xEB, 0x86, 0xBB },
	0x8764, { 0xEB, 0x86, 0xBC },
	0x8765, { 0xEB, 0x86, 0xBD },
	0x8766, { 0xEB, 0x86, 0xBE },
	0x8767, { 0xEB, 0x86, 0xBF },
	0x8768, { 0xEB, 0x87, 0x80 },
	0x8769, { 0xEB, 0x87, 0x81 },
	0x876A, { 0xEB, 0x87, 0x82 },
	0x876B, { 0xEB, 0x87, 0x83 },
	0x876C, { 0xEB, 0x87, 0x84 },
	0x876D, { 0xEB, 0x87, 0x85 },
	0x876E, { 0xEB, 0x87, 0x86 },
	0x876F, { 0xEB, 0x87, 0x87 },
	0x8770, { 0xEB, 0x87, 0x88 },
	0x8771, { 0xEB, 0x87, 0x89 },
	0x8772, { 0xEB, 0x87, 0x8A },
	0x8773, { 0xEB, 0x87, 0x8B },
	0x8774, { 0xEB, 0x87, 0x8D },
	0x8775, { 0xEB, 0x87, 0x8E },
	0x8776, { 0xEB, 0x87, 0x8F },
	0x8777, { 0xEB, 0x87, 0x91 },
	0x8778, { 0xEB, 0x87, 0x92 },
	0x8779, { 0xEB, 0x87, 0x93 },
	0x877A, { 0xEB, 0x87, 0x95 },
	0x8781, { 0xEB, 0x87, 0x96 },
	0x8782, { 0xEB, 0x87, 0x97 },
	0x8783, { 0xEB, 0x87, 0x98 },
	0x8784, { 0xEB, 0x87, 0x99 },
	0x8785, { 0xEB, 0x87, 0x9A },
	0x8786, { 0xEB, 0x87, 0x9B },
	0x8787, { 0xEB, 0x87, 0x9E },
	0x8788, { 0xEB, 0x87, 0xA0 },
	0x8789, { 0xEB, 0x87, 0xA1 },
	0x878A, { 0xEB, 0x87, 0xA2 },
	0x878B, { 0xEB, 0x87, 0xA3 },
	0x878C, { 0xEB, 0x87, 0xA4 },
	0x878D, { 0xEB, 0x87, 0xA5 },
	0x878E, { 0xEB, 0x87, 0xA6 },
	0x878F, { 0xEB, 0x87, 0xA7 },
	0x8790, { 0xEB, 0x87, 0xAA },
	0x8791, { 0xEB, 0x87, 0xAB },
	0x8792, { 0xEB, 0x87, 0xAD },
	0x8793, { 0xEB, 0x87, 0xAE },
	0x8794, { 0xEB, 0x87, 0xAF },
	0x8795, { 0xEB, 0x87, 0xB1 },
	0x8796, { 0xEB, 0x87, 0xB2 },
	0x8797, { 0xEB, 0x87, 0xB3 },
	0x8798, { 0xEB, 0x87, 0xB4 },
	0x8799, { 0xEB, 0x87, 0xB5 },
	0x879A, { 0xEB, 0x87, 0xB6 },
	0x879B, { 0xEB, 0x87, 0xB7 },
	0x879C, { 0xEB, 0x87, 0xB8 },
	0x879D, { 0xEB, 0x87, 0xBA },
	0x879E, { 0xEB, 0x87, 0xBC },
	0x879F, { 0xEB, 0x87, 0xBE },
	0x87A0, { 0xEB, 0x87, 0xBF },
	0x87A1, { 0xEB, 0x88, 0x80 },
	0x87A2, { 0xEB, 0x88, 0x81 },
	0x87A3, { 0xEB, 0x88, 0x82 },
	0x87A4, { 0xEB, 0x88, 0x83 },
	0x87A5, { 0xEB, 0x88, 0x86 },
	0x87A6, { 0xEB, 0x88, 0x87 },
	0x87A7, { 0xEB, 0x88, 0x89 },
	0x87A8, { 0xEB, 0x88, 0x8A },
	0x87A9, { 0xEB, 0x88, 0x8D },
	0x87AA, { 0xEB, 0x88, 0x8E },
	0x87AB, { 0xEB, 0x88, 0x8F },
	0x87AC, { 0xEB, 0x88, 0x90 },
	0x87AD, { 0xEB, 0x88, 0x91 },
	0x87AE, { 0xEB, 0x88, 0x92 },
	0x87AF, { 0xEB, 0x88, 0x93 },
	0x87B0, { 0xEB, 0x88, 0x96 },
	0x87B1, { 0xEB, 0x88, 0x98 },
	0x87B2, { 0xEB, 0x88, 0x9A },
	0x87B3, { 0xEB, 0x88, 0x9B },
	0x87B4, { 0xEB, 0x88, 0x9C },
	0x87B5, { 0xEB, 0x88, 0x9D },
	0x87B6, { 0xEB, 0x88, 0x9E },
	0x87B7, { 0xEB, 0x88, 0x9F },
	0x87B8, { 0xEB, 0x88, 0xA1 },
	0x87B9, { 0xEB, 0x88, 0xA2 },
	0x87BA, { 0xEB, 0x88, 0xA3 },
	0x87BB, { 0xEB, 0x88, 0xA4 },
	0x87BC, { 0xEB, 0x88, 0xA5 },
	0x87BD, { 0xEB, 0x88, 0xA6 },
	0x87BE, { 0xEB, 0x88, 0xA7 },
	0x87BF, { 0xEB, 0x88, 0xA8 },
	0x87C0, { 0xEB, 0x88, 0xA9 },
	0x87C1, { 0xEB, 0x88, 0xAA },
	0x87C2, { 0xEB, 0x88, 0xAB },
	0x87C3, { 0xEB, 0x88, 0xAC },
	0x87C4, { 0xEB, 0x88, 0xAD },
	0x87C5, { 0xEB, 0x88, 0xAE },
	0x87C6, { 0xEB, 0x88, 0xAF },
	0x87C7, { 0xEB, 0x88, 0xB0 },
	0x87C8, { 0xEB, 0x88, 0xB1 },
	0x87C9, { 0xEB, 0x88, 0xB2 },
	0x87CA, { 0xEB, 0x88, 0xB3 },
	0x87CB, { 0xEB, 0x88, 0xB5 },
	0x87CC, { 0xEB, 0x88, 0xB6 },
	0x87CD, { 0xEB, 0x88, 0xB7 },
	0x87CE, { 0xEB, 0x88, 0xB8 },
	0x87CF, { 0xEB, 0x88, 0xB9 },
	0x87D0, { 0xEB, 0x88, 0xBA },
	0x87D1, { 0xEB, 0x88, 0xBB },
	0x87D2, { 0xEB, 0x88, 0xBD },
	0x87D3, { 0xEB, 0x88, 0xBE },
	0x87D4, { 0xEB, 0x88, 0xBF },
	0x87D5, { 0xEB, 0x89, 0x80 },
	0x87D6, { 0xEB, 0x89, 0x81 },
	0x87D7, { 0xEB, 0x89, 0x82 },
	0x87D8, { 0xEB, 0x89, 0x83 },
	0x87D9, { 0xEB, 0x89, 0x84 },
	0x87DA, { 0xEB, 0x89, 0x85 },
	0x87DB, { 0xEB, 0x89, 0x86 },
	0x87DC, { 0xEB, 0x89, 0x87 },
	0x87DD, { 0xEB, 0x89, 0x88 },
	0x87DE, { 0xEB, 0x89, 0x89 },
	0x87DF, { 0xEB, 0x89, 0x8A },
	0x87E0, { 0xEB, 0x89, 0x8B },
	0x87E1, { 0xEB, 0x89, 0x8C },
	0x87E2, { 0xEB, 0x89, 0x8D },
	0x87E3, { 0xEB, 0x89, 0x8E },
	0x87E4, { 0xEB, 0x89, 0x8F },
	0x87E5, { 0xEB, 0x89, 0x90 },
	0x87E6, { 0xEB, 0x89, 0x91 },
	0x87E7, { 0xEB, 0x89, 0x92 },
	0x87E8, { 0xEB, 0x89, 0x93 },
	0x87E9, { 0xEB, 0x89, 0x94 },
	0x87EA, { 0xEB, 0x89, 0x95 },
	0x87EB, { 0xEB, 0x89, 0x96 },
	0x87EC, { 0xEB, 0x89, 0x97 },
	0x87ED, { 0xEB, 0x89, 0x99 },
	0x87EE, { 0xEB, 0x89, 0x9A },
	0x87EF, { 0xEB, 0x89, 0x9B },
	0x87F0, { 0xEB, 0x89, 0x9D },
	0x87F1, { 0xEB, 0x89, 0x9E },
	0x87F2, { 0xEB, 0x89, 0x9F },
	0x87F3, { 0xEB, 0x89, 0xA1 },
	0x87F4, { 0xEB, 0x89, 0xA2 },
	0x87F5, { 0xEB, 0x89, 0xA3 },
	0x87F6, { 0xEB, 0x89, 0xA4 },
	0x87F7, { 0xEB, 0x89, 0xA5 },
	0x87F8, { 0xEB, 0x89, 0xA6 },
	0x87F9, { 0xEB, 0x89, 0xA7 },
	0x87FA, { 0xEB, 0x89, 0xAA },
	0x87FB, { 0xEB, 0x89, 0xAB },
	0x87FC, { 0xEB, 0x89, 0xAC },
	0x87FD, { 0xEB, 0x89, 0xAD },
	0x87FE, { 0xEB, 0x89, 0xAE },
	0x8841, { 0xEB, 0x89, 0xAF },
	0x8842, { 0xEB, 0x89, 0xB0 },
	0x8843, { 0xEB, 0x89, 0xB1 },
	0x8844, { 0xEB, 0x89, 0xB2 },
	0x8845, { 0xEB, 0x89, 0xB3 },
	0x8846, { 0xEB, 0x89, 0xB6 },
	0x8847, { 0xEB, 0x89, 0xB7 },
	0x8848, { 0xEB, 0x89, 0xB8 },
	0x8849, { 0xEB, 0x89, 0xB9 },
	0x884A, { 0xEB, 0x89, 0xBA },
	0x884B, { 0xEB, 0x89, 0xBB },
	0x884C, { 0xEB, 0x89, 0xBD },
	0x884D, { 0xEB, 0x89, 0xBE },
	0x884E, { 0xEB, 0x89, 0xBF },
	0x884F, { 0xEB, 0x8A, 0x80 },
	0x8850, { 0xEB, 0x8A, 0x81 },
	0x8851, { 0xEB, 0x8A, 0x82 },
	0x8852, { 0xEB, 0x8A, 0x83 },
	0x8853, { 0xEB, 0x8A, 0x86 },
	0x8854, { 0xEB, 0x8A, 0x87 },
	0x8855, { 0xEB, 0x8A, 0x88 },
	0x8856, { 0xEB, 0x8A, 0x8A },
	0x8857, { 0xEB, 0x8A, 0x8B },
	0x8858, { 0xEB, 0x8A, 0x8C },
	0x8859, { 0xEB, 0x8A, 0x8D },
	0x885A, { 0xEB, 0x8A, 0x8E },
	0x8861, { 0xEB, 0x8A, 0x8F },
	0x8862, { 0xEB, 0x8A, 0x92 },
	0x8863, { 0xEB, 0x8A, 0x93 },
	0x8864, { 0xEB, 0x8A, 0x95 },
	0x8865, { 0xEB, 0x8A, 0x96 },
	0x8866, { 0xEB, 0x8A, 0x97 },
	0x8867, { 0xEB, 0x8A, 0x9B },
	0x8868, { 0xEB, 0x8A, 0x9C },
	0x8869, { 0xEB, 0x8A, 0x9D },
	0x886A, { 0xEB, 0x8A, 0x9E },
	0x886B, { 0xEB, 0x8A, 0x9F },
	0x886C, { 0xEB, 0x8A, 0xA2 },
	0x886D, { 0xEB, 0x8A, 0xA4 },
	0x886E, { 0xEB, 0x8A, 0xA7 },
	0x886F, { 0xEB, 0x8A, 0xA8 },
	0x8870, { 0xEB, 0x8A, 0xA9 },
	0x8871, { 0xEB, 0x8A, 0xAB },
	0x8872, { 0xEB, 0x8A, 0xAD },
	0x8873, { 0xEB, 0x8A, 0xAE },
	0x8874, { 0xEB, 0x8A, 0xAF },
	0x8875, { 0xEB, 0x8A, 0xB1 },
	0x8876, { 0xEB, 0x8A, 0xB2 },
	0x8877, { 0xEB, 0x8A, 0xB3 },
	0x8878, { 0xEB, 0x8A, 0xB5 },
	0x8879, { 0xEB, 0x8A, 0xB6 },
	0x887A, { 0xEB, 0x8A, 0xB7 },
	0x8881, { 0xEB, 0x8A, 0xB8 },
	0x8882, { 0xEB, 0x8A, 0xB9 },
	0x8883, { 0xEB, 0x8A, 0xBA },
	0x8884, { 0xEB, 0x8A, 0xBB },
	0x8885, { 0xEB, 0x8A, 0xBC },
	0x8886, { 0xEB, 0x8A, 0xBD },
	0x8887, { 0xEB, 0x8A, 0xBE },
	0x8888, { 0xEB, 0x8A, 0xBF },
	0x8889, { 0xEB, 0x8B, 0x80 },
	0x888A, { 0xEB, 0x8B, 0x81 },
	0x888B, { 0xEB, 0x8B, 0x82 },
	0x888C, { 0xEB, 0x8B, 0x83 },
	0x888D, { 0xEB, 0x8B, 0x84 },
	0x888E, { 0xEB, 0x8B, 0x85 },
	0x888F, { 0xEB, 0x8B, 0x86 },
	0x8890, { 0xEB, 0x8B, 0x87 },
	0x8891, { 0xEB, 0x8B, 0x8A },
	0x8892, { 0xEB, 0x8B, 0x8B },
	0x8893, { 0xEB, 0x8B, 0x8D },
	0x8894, { 0xEB, 0x8B, 0x8E },
	0x8895, { 0xEB, 0x8B, 0x8F },
	0x8896, { 0xEB, 0x8B, 0x91 },
	0x8897, { 0xEB, 0x8B, 0x93 },
	0x8898, { 0xEB, 0x8B, 0x94 },
	0x8899, { 0xEB, 0x8B, 0x95 },
	0x889A, { 0xEB, 0x8B, 0x96 },
	0x889B, { 0xEB, 0x8B, 0x97 },
	0x889C, { 0xEB, 0x8B, 0x9A },
	0x889D, { 0xEB, 0x8B, 0x9C },
	0x889E, { 0xEB, 0x8B, 0x9E },
	0x889F, { 0xEB, 0x8B, 0x9F },
	0x88A0, { 0xEB, 0x8B, 0xA0 },
	0x88A1, { 0xEB, 0x8B, 0xA1 },
	0x88A2, { 0xEB, 0x8B, 0xA3 },
	0x88A3, { 0xEB, 0x8B, 0xA7 },
	0x88A4, { 0xEB, 0x8B, 0xA9 },
	0x88A5, { 0xEB, 0x8B, 0xAA },
	0x88A6, { 0xEB, 0x8B, 0xB0 },
	0x88A7, { 0xEB, 0x8B, 0xB1 },
	0x88A8, { 0xEB, 0x8B, 0xB2 },
	0x88A9, { 0xEB, 0x8B, 0xB6 },
	0x88AA, { 0xEB, 0x8B, 0xBC },
	0x88AB, { 0xEB, 0x8B, 0xBD },
	0x88AC, { 0xEB, 0x8B, 0xBE },
	0x88AD, { 0xEB, 0x8C, 0x82 },
	0x88AE, { 0xEB, 0x8C, 0x83 },
	0x88AF, { 0xEB, 0x8C, 0x85 },
	0x88B0, { 0xEB, 0x8C, 0x86 },
	0x88B1, { 0xEB, 0x8C, 0x87 },
	0x88B2, { 0xEB, 0x8C, 0x89 },
	0x88B3, { 0xEB, 0x8C, 0x8A },
	0x88B4, { 0xEB, 0x8C, 0x8B },
	0x88B5, { 0xEB, 0x8C, 0x8C },
	0x88B6, { 0xEB, 0x8C, 0x8D },
	0x88B7, { 0xEB, 0x8C, 0x8E },
	0x88B8, { 0xEB, 0x8C, 0x8F },
	0x88B9, { 0xEB, 0x8C, 0x92 },
	0x88BA, { 0xEB, 0x8C, 0x96 },
	0x88BB, { 0xEB, 0x8C, 0x97 },
	0x88BC, { 0xEB, 0x8C, 0x98 },
	0x88BD, { 0xEB, 0x8C, 0x99 },
	0x88BE, { 0xEB, 0x8C, 0x9A },
	0x88BF, { 0xEB, 0x8C, 0x9B },
	0x88C0, { 0xEB, 0x8C, 0x9D },
	0x88C1, { 0xEB, 0x8C, 0x9E },
	0x88C2, { 0xEB, 0x8C, 0x9F },
	0x88C3, { 0xEB, 0x8C, 0xA0 },
	0x88C4, { 0xEB, 0x8C, 0xA1 },
	0x88C5, { 0xEB, 0x8C, 0xA2 },
	0x88C6, { 0xEB, 0x8C, 0xA3 },
	0x88C7, { 0xEB, 0x8C, 0xA4 },
	0x88C8, { 0xEB, 0x8C, 0xA5 },
	0x88C9, { 0xEB, 0x8C, 0xA6 },
	0x88CA, { 0xEB, 0x8C, 0xA7 },
	0x88CB, { 0xEB, 0x8C, 0xA8 },
	0x88CC, { 0xEB, 0x8C, 0xA9 },
	0x88CD, { 0xEB, 0x8C, 0xAA },
	0x88CE, { 0xEB, 0x8C, 0xAB },
	0x88CF, { 0xEB, 0x8C, 0xAC },
	0x88D0, { 0xEB, 0x8C, 0xAD },
	0x88D1, { 0xEB, 0x8C, 0xAE },
	0x88D2, { 0xEB, 0x8C, 0xAF },
	0x88D3, { 0xEB, 0x8C, 0xB0 },
	0x88D4, { 0xEB, 0x8C, 0xB1 },
	0x88D5, { 0xEB, 0x8C, 0xB2 },
	0x88D6, { 0xEB, 0x8C, 0xB3 },
	0x88D7, { 0xEB, 0x8C, 0xB4 },
	0x88D8, { 0xEB, 0x8C, 0xB5 },
	0x88D9, { 0xEB, 0x8C, 0xB6 },
	0x88DA, { 0xEB, 0x8C, 0xB7 },
	0x88DB, { 0xEB, 0x8C, 0xB8 },
	0x88DC, { 0xEB, 0x8C, 0xB9 },
	0x88DD, { 0xEB, 0x8C, 0xBA },
	0x88DE, { 0xEB, 0x8C, 0xBB },
	0x88DF, { 0xEB, 0x8C, 0xBC },
	0x88E0, { 0xEB, 0x8C, 0xBD },
	0x88E1, { 0xEB, 0x8C, 0xBE },
	0x88E2, { 0xEB, 0x8C, 0xBF },
	0x88E3, { 0xEB, 0x8D, 0x80 },
	0x88E4, { 0xEB, 0x8D, 0x81 },
	0x88E5, { 0xEB, 0x8D, 0x82 },
	0x88E6, { 0xEB, 0x8D, 0x83 },
	0x88E7, { 0xEB, 0x8D, 0x84 },
	0x88E8, { 0xEB, 0x8D, 0x85 },
	0x88E9, { 0xEB, 0x8D, 0x86 },
	0x88EA, { 0xEB, 0x8D, 0x87 },
	0x88EB, { 0xEB, 0x8D, 0x88 },
	0x88EC, { 0xEB, 0x8D, 0x89 },
	0x88ED, { 0xEB, 0x8D, 0x8A },
	0x88EE, { 0xEB, 0x8D, 0x8B },
	0x88EF, { 0xEB, 0x8D, 0x8C },
	0x88F0, { 0xEB, 0x8D, 0x8D },
	0x88F1, { 0xEB, 0x8D, 0x8E },
	0x88F2, { 0xEB, 0x8D, 0x8F },
	0x88F3, { 0xEB, 0x8D, 0x90 },
	0x88F4, { 0xEB, 0x8D, 0x91 },
	0x88F5, { 0xEB, 0x8D, 0x92 },
	0x88F6, { 0xEB, 0x8D, 0x93 },
	0x88F7, { 0xEB, 0x8D, 0x97 },
	0x88F8, { 0xEB, 0x8D, 0x99 },
	0x88F9, { 0xEB, 0x8D, 0x9A },
	0x88FA, { 0xEB, 0x8D, 0x9D },
	0x88FB, { 0xEB, 0x8D, 0xA0 },
	0x88FC, { 0xEB, 0x8D, 0xA1 },
	0x88FD, { 0xEB, 0x8D, 0xA2 },
	0x88FE, { 0xEB, 0x8D, 0xA3 },
	0x8941, { 0xEB, 0x8D, 0xA6 },
	0x8942, { 0xEB, 0x8D, 0xA8 },
	0x8943, { 0xEB, 0x8D, 0xAA },
	0x8944, { 0xEB, 0x8D, 0xAC },
	0x8945, { 0xEB, 0x8D, 0xAD },
	0x8946, { 0xEB, 0x8D, 0xAF },
	0x8947, { 0xEB, 0x8D, 0xB2 },
	0x8948, { 0xEB, 0x8D, 0xB3 },
	0x8949, { 0xEB, 0x8D, 0xB5 },
	0x894A, { 0xEB, 0x8D, 0xB6 },
	0x894B, { 0xEB, 0x8D, 0xB7 },
	0x894C, { 0xEB, 0x8D, 0xB9 },
	0x894D, { 0xEB, 0x8D, 0xBA },
	0x894E, { 0xEB, 0x8D, 0xBB },
	0x894F, { 0xEB, 0x8D, 0xBC },
	0x8950, { 0xEB, 0x8D, 0xBD },
	0x8951, { 0xEB, 0x8D, 0xBE },
	0x8952, { 0xEB, 0x8D, 0xBF },
	0x8953, { 0xEB, 0x8E, 0x82 },
	0x8954, { 0xEB, 0x8E, 0x86 },
	0x8955, { 0xEB, 0x8E, 0x87 },
	0x8956, { 0xEB, 0x8E, 0x88 },
	0x8957, { 0xEB, 0x8E, 0x89 },
	0x8958, { 0xEB, 0x8E, 0x8A },
	0x8959, { 0xEB, 0x8E, 0x8B },
	0x895A, { 0xEB, 0x8E, 0x8D },
	0x8961, { 0xEB, 0x8E, 0x8E },
	0x8962, { 0xEB, 0x8E, 0x8F },
	0x8963, { 0xEB, 0x8E, 0x91 },
	0x8964, { 0xEB, 0x8E, 0x92 },
	0x8965, { 0xEB, 0x8E, 0x93 },
	0x8966, { 0xEB, 0x8E, 0x95 },
	0x8967, { 0xEB, 0x8E, 0x96 },
	0x8968, { 0xEB, 0x8E, 0x97 },
	0x8969, { 0xEB, 0x8E, 0x98 },
	0x896A, { 0xEB, 0x8E, 0x99 },
	0x896B, { 0xEB, 0x8E, 0x9A },
	0x896C, { 0xEB, 0x8E, 0x9B },
	0x896D, { 0xEB, 0x8E, 0x9C },
	0x896E, { 0xEB, 0x8E, 0x9D },
	0x896F, { 0xEB, 0x8E, 0x9E },
	0x8970, { 0xEB, 0x8E, 0x9F },
	0x8971, { 0xEB, 0x8E, 0xA2 },
	0x8972, { 0xEB, 0x8E, 0xA3 },
	0x8973, { 0xEB, 0x8E, 0xA4 },
	0x8974, { 0xEB, 0x8E, 0xA5 },
	0x8975, { 0xEB, 0x8E, 0xA6 },
	0x8976, { 0xEB, 0x8E, 0xA7 },
	0x8977, { 0xEB, 0x8E, 0xA9 },
	0x8978, { 0xEB, 0x8E, 0xAA },
	0x8979, { 0xEB, 0x8E, 0xAB },
	0x897A, { 0xEB, 0x8E, 0xAD },
	0x8981, { 0xEB, 0x8E, 0xAE },
	0x8982, { 0xEB, 0x8E, 0xAF },
	0x8983, { 0xEB, 0x8E, 0xB0 },
	0x8984, { 0xEB, 0x8E, 0xB1 },
	0x8985, { 0xEB, 0x8E, 0xB2 },
	0x8986, { 0xEB, 0x8E, 0xB3 },
	0x8987, { 0xEB, 0x8E, 0xB4 },
	0x8988, { 0xEB, 0x8E, 0xB5 },
	0x8989, { 0xEB, 0x8E, 0xB6 },
	0x898A, { 0xEB, 0x8E, 0xB7 },
	0x898B, { 0xEB, 0x8E, 0xB8 },
	0x898C, { 0xEB, 0x8E, 0xB9 },
	0x898D, { 0xEB, 0x8E, 0xBA },
	0x898E, { 0xEB, 0x8E, 0xBB },
	0x898F, { 0xEB, 0x8E, 0xBC },
	0x8990, { 0xEB, 0x8E, 0xBD },
	0x8991, { 0xEB, 0x8E, 0xBE },
	0x8992, { 0xEB, 0x8E, 0xBF },
	0x8993, { 0xEB, 0x8F, 0x80 },
	0x8994, { 0xEB, 0x8F, 0x81 },
	0x8995, { 0xEB, 0x8F, 0x82 },
	0x8996, { 0xEB, 0x8F, 0x83 },
	0x8997, { 0xEB, 0x8F, 0x86 },
	0x8998, { 0xEB, 0x8F, 0x87 },
	0x8999, { 0xEB, 0x8F, 0x89 },
	0x899A, { 0xEB, 0x8F, 0x8A },
	0x899B, { 0xEB, 0x8F, 0x8D },
	0x899C, { 0xEB, 0x8F, 0x8F },
	0x899D, { 0xEB, 0x8F, 0x91 },
	0x899E, { 0xEB, 0x8F, 0x92 },
	0x899F, { 0xEB, 0x8F, 0x93 },
	0x89A0, { 0xEB, 0x8F, 0x96 },
	0x89A1, { 0xEB, 0x8F, 0x98 },
	0x89A2, { 0xEB, 0x8F, 0x9A },
	0x89A3, { 0xEB, 0x8F, 0x9C },
	0x89A4, { 0xEB, 0x8F, 0x9E },
	0x89A5, { 0xEB, 0x8F, 0x9F },
	0x89A6, { 0xEB, 0x8F, 0xA1 },
	0x89A7, { 0xEB, 0x8F, 0xA2 },
	0x89A8, { 0xEB, 0x8F, 0xA3 },
	0x89A9, { 0xEB, 0x8F, 0xA5 },
	0x89AA, { 0xEB, 0x8F, 0xA6 },
	0x89AB, { 0xEB, 0x8F, 0xA7 },
	0x89AC, { 0xEB, 0x8F, 0xA9 },
	0x89AD, { 0xEB, 0x8F, 0xAA },
	0x89AE, { 0xEB, 0x8F, 0xAB },
	0x89AF, { 0xEB, 0x8F, 0xAC },
	0x89B0, { 0xEB, 0x8F, 0xAD },
	0x89B1, { 0xEB, 0x8F, 0xAE },
	0x89B2, { 0xEB, 0x8F, 0xAF },
	0x89B3, { 0xEB, 0x8F, 0xB0 },
	0x89B4, { 0xEB, 0x8F, 0xB1 },
	0x89B5, { 0xEB, 0x8F, 0xB2 },
	0x89B6, { 0xEB, 0x8F, 0xB3 },
	0x89B7, { 0xEB, 0x8F, 0xB4 },
	0x89B8, { 0xEB, 0x8F, 0xB5 },
	0x89B9, { 0xEB, 0x8F, 0xB6 },
	0x89BA, { 0xEB, 0x8F, 0xB7 },
	0x89BB, { 0xEB, 0x8F, 0xB8 },
	0x89BC, { 0xEB, 0x8F, 0xB9 },
	0x89BD, { 0xEB, 0x8F, 0xBA },
	0x89BE, { 0xEB, 0x8F, 0xBB },
	0x89BF, { 0xEB, 0x8F, 0xBD },
	0x89C0, { 0xEB, 0x8F, 0xBE },
	0x89C1, { 0xEB, 0x8F, 0xBF },
	0x89C2, { 0xEB, 0x90, 0x80 },
	0x89C3, { 0xEB, 0x90, 0x81 },
	0x89C4, { 0xEB, 0x90, 0x82 },
	0x89C5, { 0xEB, 0x90, 0x83 },
	0x89C6, { 0xEB, 0x90, 0x84 },
	0x89C7, { 0xEB, 0x90, 0x85 },
	0x89C8, { 0xEB, 0x90, 0x86 },
	0x89C9, { 0xEB, 0x90, 0x87 },
	0x89CA, { 0xEB, 0x90, 0x88 },
	0x89CB, { 0xEB, 0x90, 0x89 },
	0x89CC, { 0xEB, 0x90, 0x8A },
	0x89CD, { 0xEB, 0x90, 0x8B },
	0x89CE, { 0xEB, 0x90, 0x8C },
	0x89CF, { 0xEB, 0x90, 0x8D },
	0x89D0, { 0xEB, 0x90, 0x8E },
	0x89D1, { 0xEB, 0x90, 0x8F },
	0x89D2, { 0xEB, 0x90, 0x91 },
	0x89D3, { 0xEB, 0x90, 0x92 },
	0x89D4, { 0xEB, 0x90, 0x93 },
	0x89D5, { 0xEB, 0x90, 0x94 },
	0x89D6, { 0xEB, 0x90, 0x95 },
	0x89D7, { 0xEB, 0x90, 0x96 },
	0x89D8, { 0xEB, 0x90, 0x97 },
	0x89D9, { 0xEB, 0x90, 0x99 },
	0x89DA, { 0xEB, 0x90, 0x9A },
	0x89DB, { 0xEB, 0x90, 0x9B },
	0x89DC, { 0xEB, 0x90, 0x9D },
	0x89DD, { 0xEB, 0x90, 0x9E },
	0x89DE, { 0xEB, 0x90, 0x9F },
	0x89DF, { 0xEB, 0x90, 0xA1 },
	0x89E0, { 0xEB, 0x90, 0xA2 },
	0x89E1, { 0xEB, 0x90, 0xA3 },
	0x89E2, { 0xEB, 0x90, 0xA4 },
	0x89E3, { 0xEB, 0x90, 0xA5 },
	0x89E4, { 0xEB, 0x90, 0xA6 },
	0x89E5, { 0xEB, 0x90, 0xA7 },
	0x89E6, { 0xEB, 0x90, 0xAA },
	0x89E7, { 0xEB, 0x90, 0xAC },
	0x89E8, { 0xEB, 0x90, 0xAD },
	0x89E9, { 0xEB, 0x90, 0xAE },
	0x89EA, { 0xEB, 0x90, 0xAF },
	0x89EB, { 0xEB, 0x90, 0xB0 },
	0x89EC, { 0xEB, 0x90, 0xB1 },
	0x89ED, { 0xEB, 0x90, 0xB2 },
	0x89EE, { 0xEB, 0x90, 0xB3 },
	0x89EF, { 0xEB, 0x90, 0xB5 },
	0x89F0, { 0xEB, 0x90, 0xB6 },
	0x89F1, { 0xEB, 0x90, 0xB7 },
	0x89F2, { 0xEB, 0x90, 0xB8 },
	0x89F3, { 0xEB, 0x90, 0xB9 },
	0x89F4, { 0xEB, 0x90, 0xBA },
	0x89F5, { 0xEB, 0x90, 0xBB },
	0x89F6, { 0xEB, 0x90, 0xBC },
	0x89F7, { 0xEB, 0x90, 0xBD },
	0x89F8, { 0xEB, 0x90, 0xBE },
	0x89F9, { 0xEB, 0x90, 0xBF },
	0x89FA, { 0xEB, 0x91, 0x80 },
	0x89FB, { 0xEB, 0x91, 0x81 },
	0x89FC, { 0xEB, 0x91, 0x82 },
	0x89FD, { 0xEB, 0x91, 0x83 },
	0x89FE, { 0xEB, 0x91, 0x84 },
	0x8A41, { 0xEB, 0x91, 0x85 },
	0x8A42, { 0xEB, 0x91, 0x86 },
	0x8A43, { 0xEB, 0x91, 0x87 },
	0x8A44, { 0xEB, 0x91, 0x88 },
	0x8A45, { 0xEB, 0x91, 0x89 },
	0x8A46, { 0xEB, 0x91, 0x8A },
	0x8A47, { 0xEB, 0x91, 0x8B },
	0x8A48, { 0xEB, 0x91, 0x8C },
	0x8A49, { 0xEB, 0x91, 0x8D },
	0x8A4A, { 0xEB, 0x91, 0x8E },
	0x8A4B, { 0xEB, 0x91, 0x8F },
	0x8A4C, { 0xEB, 0x91, 0x92 },
	0x8A4D, { 0xEB, 0x91, 0x93 },
	0x8A4E, { 0xEB, 0x91, 0x95 },
	0x8A4F, { 0xEB, 0x91, 0x96 },
	0x8A50, { 0xEB, 0x91, 0x97 },
	0x8A51, { 0xEB, 0x91, 0x99 },
	0x8A52, { 0xEB, 0x91, 0x9A },
	0x8A53, { 0xEB, 0x91, 0x9B },
	0x8A54, { 0xEB, 0x91, 0x9C },
	0x8A55, { 0xEB, 0x91, 0x9D },
	0x8A56, { 0xEB, 0x91, 0x9E },
	0x8A57, { 0xEB, 0x91, 0x9F },
	0x8A58, { 0xEB, 0x91, 0xA2 },
	0x8A59, { 0xEB, 0x91, 0xA4 },
	0x8A5A, { 0xEB, 0x91, 0xA6 },
	0x8A61, { 0xEB, 0x91, 0xA7 },
	0x8A62, { 0xEB, 0x91, 0xA8 },
	0x8A63, { 0xEB, 0x91, 0xA9 },
	0x8A64, { 0xEB, 0x91, 0xAA },
	0x8A65, { 0xEB, 0x91, 0xAB },
	0x8A66, { 0xEB, 0x91, 0xAD },
	0x8A67, { 0xEB, 0x91, 0xAE },
	0x8A68, { 0xEB, 0x91, 0xAF },
	0x8A69, { 0xEB, 0x91, 0xB0 },
	0x8A6A, { 0xEB, 0x91, 0xB1 },
	0x8A6B, { 0xEB, 0x91, 0xB2 },
	0x8A6C, { 0xEB, 0x91, 0xB3 },
	0x8A6D, { 0xEB, 0x91, 0xB4 },
	0x8A6E, { 0xEB, 0x91, 0xB5 },
	0x8A6F, { 0xEB, 0x91, 0xB6 },
	0x8A70, { 0xEB, 0x91, 0xB7 },
	0x8A71, { 0xEB, 0x91, 0xB8 },
	0x8A72, { 0xEB, 0x91, 0xB9 },
	0x8A73, { 0xEB, 0x91, 0xBA },
	0x8A74, { 0xEB, 0x91, 0xBB },
	0x8A75, { 0xEB, 0x91, 0xBC },
	0x8A76, { 0xEB, 0x91, 0xBD },
	0x8A77, { 0xEB, 0x91, 0xBE },
	0x8A78, { 0xEB, 0x91, 0xBF },
	0x8A79, { 0xEB, 0x92, 0x81 },
	0x8A7A, { 0xEB, 0x92, 0x82 },
	0x8A81, { 0xEB, 0x92, 0x83 },
	0x8A82, { 0xEB, 0x92, 0x84 },
	0x8A83, { 0xEB, 0x92, 0x85 },
	0x8A84, { 0xEB, 0x92, 0x86 },
	0x8A85, { 0xEB, 0x92, 0x87 },
	0x8A86, { 0xEB, 0x92, 0x89 },
	0x8A87, { 0xEB, 0x92, 0x8A },
	0x8A88, { 0xEB, 0x92, 0x8B },
	0x8A89, { 0xEB, 0x92, 0x8C },
	0x8A8A, { 0xEB, 0x92, 0x8D },
	0x8A8B, { 0xEB, 0x92, 0x8E },
	0x8A8C, { 0xEB, 0x92, 0x8F },
	0x8A8D, { 0xEB, 0x92, 0x90 },
	0x8A8E, { 0xEB, 0x92, 0x91 },
	0x8A8F, { 0xEB, 0x92, 0x92 },
	0x8A90, { 0xEB, 0x92, 0x93 },
	0x8A91, { 0xEB, 0x92, 0x94 },
	0x8A92, { 0xEB, 0x92, 0x95 },
	0x8A93, { 0xEB, 0x92, 0x96 },
	0x8A94, { 0xEB, 0x92, 0x97 },
	0x8A95, { 0xEB, 0x92, 0x98 },
	0x8A96, { 0xEB, 0x92, 0x99 },
	0x8A97, { 0xEB, 0x92, 0x9A },
	0x8A98, { 0xEB, 0x92, 0x9B },
	0x8A99, { 0xEB, 0x92, 0x9C },
	0x8A9A, { 0xEB, 0x92, 0x9E },
	0x8A9B, { 0xEB, 0x92, 0x9F },
	0x8A9C, { 0xEB, 0x92, 0xA0 },
	0x8A9D, { 0xEB, 0x92, 0xA1 },
	0x8A9E, { 0xEB, 0x92, 0xA2 },
	0x8A9F, { 0xEB, 0x92, 0xA3 },
	0x8AA0, { 0xEB, 0x92, 0xA5 },
	0x8AA1, { 0xEB, 0x92, 0xA6 },
	0x8AA2, { 0xEB, 0x92, 0xA7 },
	0x8AA3, { 0xEB, 0x92, 0xA9 },
	0x8AA4, { 0xEB, 0x92, 0xAA },
	0x8AA5, { 0xEB, 0x92, 0xAB },
	0x8AA6, { 0xEB, 0x92, 0xAD },
	0x8AA7, { 0xEB, 0x92, 0xAE },
	0x8AA8, { 0xEB, 0x92, 0xAF },
	0x8AA9, { 0xEB, 0x92, 0xB0 },
	0x8AAA, { 0xEB, 0x92, 0xB1 },
	0x8AAB, { 0xEB, 0x92, 0xB2 },
	0x8AAC, { 0xEB, 0x92, 0xB3 },
	0x8AAD, { 0xEB, 0x92, 0xB4 },
	0x8AAE, { 0xEB, 0x92, 0xB6 },
	0x8AAF, { 0xEB, 0x92, 0xB8 },
	0x8AB0, { 0xEB, 0x92, 0xBA },
	0x8AB1, { 0xEB, 0x92, 0xBB },
	0x8AB2, { 0xEB, 0x92, 0xBC },
	0x8AB3, { 0xEB, 0x92, 0xBD },
	0x8AB4, { 0xEB, 0x92, 0xBE },
	0x8AB5, { 0xEB, 0x92, 0xBF },
	0x8AB6, { 0xEB, 0x93, 0x81 },
	0x8AB7, { 0xEB, 0x93, 0x82 },
	0x8AB8, { 0xEB, 0x93, 0x83 },
	0x8AB9, { 0xEB, 0x93, 0x85 },
	0x8ABA, { 0xEB, 0x93, 0x86 },
	0x8ABB, { 0xEB, 0x93, 0x87 },
	0x8ABC, { 0xEB, 0x93, 0x89 },
	0x8ABD, { 0xEB, 0x93, 0x8A },
	0x8ABE, { 0xEB, 0x93, 0x8B },
	0x8ABF, { 0xEB, 0x93, 0x8C },
	0x8AC0, { 0xEB, 0x93, 0x8D },
	0x8AC1, { 0xEB, 0x93, 0x8E },
	0x8AC2, { 0xEB, 0x93, 0x8F },
	0x8AC3, { 0xEB, 0x93, 0x91 },
	0x8AC4, { 0xEB, 0x93, 0x92 },
	0x8AC5, { 0xEB, 0x93, 0x93 },
	0x8AC6, { 0xEB, 0x93, 0x94 },
	0x8AC7, { 0xEB, 0x93, 0x96 },
	0x8AC8, { 0xEB, 0x93, 0x97 },
	0x8AC9, { 0xEB, 0x93, 0x98 },
	0x8ACA, { 0xEB, 0x93, 0x99 },
	0x8ACB, { 0xEB, 0x93, 0x9A },
	0x8ACC, { 0xEB, 0x93, 0x9B },
	0x8ACD, { 0xEB, 0x93, 0x9E },
	0x8ACE, { 0xEB, 0x93, 0x9F },
	0x8ACF, { 0xEB, 0x93, 0xA1 },
	0x8AD0, { 0xEB, 0x93, 0xA2 },
	0x8AD1, { 0xEB, 0x93, 0xA5 },
	0x8AD2, { 0xEB, 0x93, 0xA7 },
	0x8AD3, { 0xEB, 0x93, 0xA8 },
	0x8AD4, { 0xEB, 0x93, 0xA9 },
	0x8AD5, { 0xEB, 0x93, 0xAA },
	0x8AD6, { 0xEB, 0x93, 0xAB },
	0x8AD7, { 0xEB, 0x93, 0xAE },
	0x8AD8, { 0xEB, 0x93, 0xB0 },
	0x8AD9, { 0xEB, 0x93, 0xB2 },
	0x8ADA, { 0xEB, 0x93, 0xB3 },
	0x8ADB, { 0xEB, 0x93, 0xB4 },
	0x8ADC, { 0xEB, 0x93, 0xB5 },
	0x8ADD, { 0xEB, 0x93, 0xB6 },
	0x8ADE, { 0xEB, 0x93, 0xB7 },
	0x8ADF, { 0xEB, 0x93, 0xB9 },
	0x8AE0, { 0xEB, 0x93, 0xBA },
	0x8AE1, { 0xEB, 0x93, 0xBB },
	0x8AE2, { 0xEB, 0x93, 0xBC },
	0x8AE3, { 0xEB, 0x93, 0xBD },
	0x8AE4, { 0xEB, 0x93, 0xBE },
	0x8AE5, { 0xEB, 0x93, 0xBF },
	0x8AE6, { 0xEB, 0x94, 0x80 },
	0x8AE7, { 0xEB, 0x94, 0x81 },
	0x8AE8, { 0xEB, 0x94, 0x82 },
	0x8AE9, { 0xEB, 0x94, 0x83 },
	0x8AEA, { 0xEB, 0x94, 0x84 },
	0x8AEB, { 0xEB, 0x94, 0x85 },
	0x8AEC, { 0xEB, 0x94, 0x86 },
	0x8AED, { 0xEB, 0x94, 0x87 },
	0x8AEE, { 0xEB, 0x94, 0x88 },
	0x8AEF, { 0xEB, 0x94, 0x89 },
	0x8AF0, { 0xEB, 0x94, 0x8A },
	0x8AF1, { 0xEB, 0x94, 0x8B },
	0x8AF2, { 0xEB, 0x94, 0x8C },
	0x8AF3, { 0xEB, 0x94, 0x8D },
	0x8AF4, { 0xEB, 0x94, 0x8E },
	0x8AF5, { 0xEB, 0x94, 0x8F },
	0x8AF6, { 0xEB, 0x94, 0x90 },
	0x8AF7, { 0xEB, 0x94, 0x91 },
	0x8AF8, { 0xEB, 0x94, 0x92 },
	0x8AF9, { 0xEB, 0x94, 0x93 },
	0x8AFA, { 0xEB, 0x94, 0x96 },
	0x8AFB, { 0xEB, 0x94, 0x97 },
	0x8AFC, { 0xEB, 0x94, 0x99 },
	0x8AFD, { 0xEB, 0x94, 0x9A },
	0x8AFE, { 0xEB, 0x94, 0x9D },
	0x8B41, { 0xEB, 0x94, 0x9E },
	0x8B42, { 0xEB, 0x94, 0x9F },
	0x8B43, { 0xEB, 0x94, 0xA0 },
	0x8B44, { 0xEB, 0x94, 0xA1 },
	0x8B45, { 0xEB, 0x94, 0xA2 },
	0x8B46, { 0xEB, 0x94, 0xA3 },
	0x8B47, { 0xEB, 0x94, 0xA6 },
	0x8B48, { 0xEB, 0x94, 0xAB },
	0x8B49, { 0xEB, 0x94, 0xAC },
	0x8B4A, { 0xEB, 0x94, 0xAD },
	0x8B4B, { 0xEB, 0x94, 0xAE },
	0x8B4C, { 0xEB, 0x94, 0xAF },
	0x8B4D, { 0xEB, 0x94, 0xB2 },
	0x8B4E, { 0xEB, 0x94, 0xB3 },
	0x8B4F, { 0xEB, 0x94, 0xB5 },
	0x8B50, { 0xEB, 0x94, 0xB6 },
	0x8B51, { 0xEB, 0x94, 0xB7 },
	0x8B52, { 0xEB, 0x94, 0xB9 },
	0x8B53, { 0xEB, 0x94, 0xBA },
	0x8B54, { 0xEB, 0x94, 0xBB },
	0x8B55, { 0xEB, 0x94, 0xBC },
	0x8B56, { 0xEB, 0x94, 0xBD },
	0x8B57, { 0xEB, 0x94, 0xBE },
	0x8B58, { 0xEB, 0x94, 0xBF },
	0x8B59, { 0xEB, 0x95, 0x82 },
	0x8B5A, { 0xEB, 0x95, 0x86 },
	0x8B61, { 0xEB, 0x95, 0x87 },
	0x8B62, { 0xEB, 0x95, 0x88 },
	0x8B63, { 0xEB, 0x95, 0x89 },
	0x8B64, { 0xEB, 0x95, 0x8A },
	0x8B65, { 0xEB, 0x95, 0x8E },
	0x8B66, { 0xEB, 0x95, 0x8F },
	0x8B67, { 0xEB, 0x95, 0x91 },
	0x8B68, { 0xEB, 0x95, 0x92 },
	0x8B69, { 0xEB, 0x95, 0x93 },
	0x8B6A, { 0xEB, 0x95, 0x95 },
	0x8B6B, { 0xEB, 0x95, 0x96 },
	0x8B6C, { 0xEB, 0x95, 0x97 },
	0x8B6D, { 0xEB, 0x95, 0x98 },
	0x8B6E, { 0xEB, 0x95, 0x99 },
	0x8B6F, { 0xEB, 0x95, 0x9A },
	0x8B70, { 0xEB, 0x95, 0x9B },
	0x8B71, { 0xEB, 0x95, 0x9E },
	0x8B72, { 0xEB, 0x95, 0xA2 },
	0x8B73, { 0xEB, 0x95, 0xA3 },
	0x8B74, { 0xEB, 0x95, 0xA4 },
	0x8B75, { 0xEB, 0x95, 0xA5 },
	0x8B76, { 0xEB, 0x95, 0xA6 },
	0x8B77, { 0xEB, 0x95, 0xA7 },
	0x8B78, { 0xEB, 0x95, 0xA8 },
	0x8B79, { 0xEB, 0x95, 0xA9 },
	0x8B7A, { 0xEB, 0x95, 0xAA },
	0x8B81, { 0xEB, 0x95, 0xAB },
	0x8B82, { 0xEB, 0x95, 0xAC },
	0x8B83, { 0xEB, 0x95, 0xAD },
	0x8B84, { 0xEB, 0x95, 0xAE },
	0x8B85, { 0xEB, 0x95, 0xAF },
	0x8B86, { 0xEB, 0x95, 0xB0 },
	0x8B87, { 0xEB, 0x95, 0xB1 },
	0x8B88, { 0xEB, 0x95, 0xB2 },
	0x8B89, { 0xEB, 0x95, 0xB3 },
	0x8B8A, { 0xEB, 0x95, 0xB4 },
	0x8B8B, { 0xEB, 0x95, 0xB5 },
	0x8B8C, { 0xEB, 0x95, 0xB6 },
	0x8B8D, { 0xEB, 0x95, 0xB7 },
	0x8B8E, { 0xEB, 0x95, 0xB8 },
	0x8B8F, { 0xEB, 0x95, 0xB9 },
	0x8B90, { 0xEB, 0x95, 0xBA },
	0x8B91, { 0xEB, 0x95, 0xBB },
	0x8B92, { 0xEB, 0x95, 0xBC },
	0x8B93, { 0xEB, 0x95, 0xBD },
	0x8B94, { 0xEB, 0x95, 0xBE },
	0x8B95, { 0xEB, 0x95, 0xBF },
	0x8B96, { 0xEB, 0x96, 0x80 },
	0x8B97, { 0xEB, 0x96, 0x81 },
	0x8B98, { 0xEB, 0x96, 0x82 },
	0x8B99, { 0xEB, 0x96, 0x83 },
	0x8B9A, { 0xEB, 0x96, 0x84 },
	0x8B9B, { 0xEB, 0x96, 0x85 },
	0x8B9C, { 0xEB, 0x96, 0x86 },
	0x8B9D, { 0xEB, 0x96, 0x87 },
	0x8B9E, { 0xEB, 0x96, 0x88 },
	0x8B9F, { 0xEB, 0x96, 0x89 },
	0x8BA0, { 0xEB, 0x96, 0x8A },
	0x8BA1, { 0xEB, 0x96, 0x8B },
	0x8BA2, { 0xEB, 0x96, 0x8C },
	0x8BA3, { 0xEB, 0x96, 0x8D },
	0x8BA4, { 0xEB, 0x96, 0x8E },
	0x8BA5, { 0xEB, 0x96, 0x8F },
	0x8BA6, { 0xEB, 0x96, 0x90 },
	0x8BA7, { 0xEB, 0x96, 0x91 },
	0x8BA8, { 0xEB, 0x96, 0x92 },
	0x8BA9, { 0xEB, 0x96, 0x93 },
	0x8BAA, { 0xEB, 0x96, 0x94 },
	0x8BAB, { 0xEB, 0x96, 0x95 },
	0x8BAC, { 0xEB, 0x96, 0x96 },
	0x8BAD, { 0xEB, 0x96, 0x97 },
	0x8BAE, { 0xEB, 0x96, 0x98 },
	0x8BAF, { 0xEB, 0x96, 0x99 },
	0x8BB0, { 0xEB, 0x96, 0x9A },
	0x8BB1, { 0xEB, 0x96, 0x9B },
	0x8BB2, { 0xEB, 0x96, 0x9C },
	0x8BB3, { 0xEB, 0x96, 0x9D },
	0x8BB4, { 0xEB, 0x96, 0x9E },
	0x8BB5, { 0xEB, 0x96, 0x9F },
	0x8BB6, { 0xEB, 0x96, 0xA2 },
	0x8BB7, { 0xEB, 0x96, 0xA3 },
	0x8BB8, { 0xEB, 0x96, 0xA5 },
	0x8BB9, { 0xEB, 0x96, 0xA6 },
	0x8BBA, { 0xEB, 0x96, 0xA7 },
	0x8BBB, { 0xEB, 0x96, 0xA9 },
	0x8BBC, { 0xEB, 0x96, 0xAC },
	0x8BBD, { 0xEB, 0x96, 0xAD },
	0x8BBE, { 0xEB, 0x96, 0xAE },
	0x8BBF, { 0xEB, 0x96, 0xAF },
	0x8BC0, { 0xEB, 0x96, 0xB2 },
	0x8BC1, { 0xEB, 0x96, 0xB6 },
	0x8BC2, { 0xEB, 0x96, 0xB7 },
	0x8BC3, { 0xEB, 0x96, 0xB8 },
	0x8BC4, { 0xEB, 0x96, 0xB9 },
	0x8BC5, { 0xEB, 0x96, 0xBA },
	0x8BC6, { 0xEB, 0x96, 0xBE },
	0x8BC7, { 0xEB, 0x96, 0xBF },
	0x8BC8, { 0xEB, 0x97, 0x81 },
	0x8BC9, { 0xEB, 0x97, 0x82 },
	0x8BCA, { 0xEB, 0x97, 0x83 },
	0x8BCB, { 0xEB, 0x97, 0x85 },
	0x8BCC, { 0xEB, 0x97, 0x86 },
	0x8BCD, { 0xEB, 0x97, 0x87 },
	0x8BCE, { 0xEB, 0x97, 0x88 },
	0x8BCF, { 0xEB, 0x97, 0x89 },
	0x8BD0, { 0xEB, 0x97, 0x8A },
	0x8BD1, { 0xEB, 0x97, 0x8B },
	0x8BD2, { 0xEB, 0x97, 0x8E },
	0x8BD3, { 0xEB, 0x97, 0x92 },
	0x8BD4, { 0xEB, 0x97, 0x93 },
	0x8BD5, { 0xEB, 0x97, 0x94 },
	0x8BD6, { 0xEB, 0x97, 0x95 },
	0x8BD7, { 0xEB, 0x97, 0x96 },
	0x8BD8, { 0xEB, 0x97, 0x97 },
	0x8BD9, { 0xEB, 0x97, 0x99 },
	0x8BDA, { 0xEB, 0x97, 0x9A },
	0x8BDB, { 0xEB, 0x97, 0x9B },
	0x8BDC, { 0xEB, 0x97, 0x9C },
	0x8BDD, { 0xEB, 0x97, 0x9D },
	0x8BDE, { 0xEB, 0x97, 0x9E },
	0x8BDF, { 0xEB, 0x97, 0x9F },
	0x8BE0, { 0xEB, 0x97, 0xA0 },
	0x8BE1, { 0xEB, 0x97, 0xA1 },
	0x8BE2, { 0xEB, 0x97, 0xA2 },
	0x8BE3, { 0xEB, 0x97, 0xA3 },
	0x8BE4, { 0xEB, 0x97, 0xA4 },
	0x8BE5, { 0xEB, 0x97, 0xA5 },
	0x8BE6, { 0xEB, 0x97, 0xA6 },
	0x8BE7, { 0xEB, 0x97, 0xA7 },
	0x8BE8, { 0xEB, 0x97, 0xA8 },
	0x8BE9, { 0xEB, 0x97, 0xA9 },
	0x8BEA, { 0xEB, 0x97, 0xAA },
	0x8BEB, { 0xEB, 0x97, 0xAB },
	0x8BEC, { 0xEB, 0x97, 0xAD },
	0x8BED, { 0xEB, 0x97, 0xAE },
	0x8BEE, { 0xEB, 0x97, 0xAF },
	0x8BEF, { 0xEB, 0x97, 0xB0 },
	0x8BF0, { 0xEB, 0x97, 0xB1 },
	0x8BF1, { 0xEB, 0x97, 0xB2 },
	0x8BF2, { 0xEB, 0x97, 0xB3 },
	0x8BF3, { 0xEB, 0x97, 0xB4 },
	0x8BF4, { 0xEB, 0x97, 0xB5 },
	0x8BF5, { 0xEB, 0x97, 0xB6 },
	0x8BF6, { 0xEB, 0x97, 0xB7 },
	0x8BF7, { 0xEB, 0x97, 0xB8 },
	0x8BF8, { 0xEB, 0x97, 0xB9 },
	0x8BF9, { 0xEB, 0x97, 0xBA },
	0x8BFA, { 0xEB, 0x97, 0xBB },
	0x8BFB, { 0xEB, 0x97, 0xBC },
	0x8BFC, { 0xEB, 0x97, 0xBD },
	0x8BFD, { 0xEB, 0x97, 0xBE },
	0x8BFE, { 0xEB, 0x97, 0xBF },
	0x8C41, { 0xEB, 0x98, 0x80 },
	0x8C42, { 0xEB, 0x98, 0x81 },
	0x8C43, { 0xEB, 0x98, 0x82 },
	0x8C44, { 0xEB, 0x98, 0x83 },
	0x8C45, { 0xEB, 0x98, 0x84 },
	0x8C46, { 0xEB, 0x98, 0x85 },
	0x8C47, { 0xEB, 0x98, 0x86 },
	0x8C48, { 0xEB, 0x98, 0x87 },
	0x8C49, { 0xEB, 0x98, 0x88 },
	0x8C4A, { 0xEB, 0x98, 0x89 },
	0x8C4B, { 0xEB, 0x98, 0x8A },
	0x8C4C, { 0xEB, 0x98, 0x8B },
	0x8C4D, { 0xEB, 0x98, 0x8C },
	0x8C4E, { 0xEB, 0x98, 0x8D },
	0x8C4F, { 0xEB, 0x98, 0x8E },
	0x8C50, { 0xEB, 0x98, 0x8F },
	0x8C51, { 0xEB, 0x98, 0x92 },
	0x8C52, { 0xEB, 0x98, 0x93 },
	0x8C53, { 0xEB, 0x98, 0x95 },
	0x8C54, { 0xEB, 0x98, 0x96 },
	0x8C55, { 0xEB, 0x98, 0x97 },
	0x8C56, { 0xEB, 0x98, 0x99 },
	0x8C57, { 0xEB, 0x98, 0x9A },
	0x8C58, { 0xEB, 0x98, 0x9B },
	0x8C59, { 0xEB, 0x98, 0x9C },
	0x8C5A, { 0xEB, 0x98, 0x9D },
	0x8C61, { 0xEB, 0x98, 0x9E },
	0x8C62, { 0xEB, 0x98, 0x9F },
	0x8C63, { 0xEB, 0x98, 0xA0 },
	0x8C64, { 0xEB, 0x98, 0xA1 },
	0x8C65, { 0xEB, 0x98, 0xA2 },
	0x8C66, { 0xEB, 0x98, 0xA3 },
	0x8C67, { 0xEB, 0x98, 0xA4 },
	0x8C68, { 0xEB, 0x98, 0xA6 },
	0x8C69, { 0xEB, 0x98, 0xA7 },
	0x8C6A, { 0xEB, 0x98, 0xA8 },
	0x8C6B, { 0xEB, 0x98, 0xA9 },
	0x8C6C, { 0xEB, 0x98, 0xAA },
	0x8C6D, { 0xEB, 0x98, 0xAB },
	0x8C6E, { 0xEB, 0x98, 0xAD },
	0x8C6F, { 0xEB, 0x98, 0xAE },
	0x8C70, { 0xEB, 0x98, 0xAF },
	0x8C71, { 0xEB, 0x98, 0xB0 },
	0x8C72, { 0xEB, 0x98, 0xB1 },
	0x8C73, { 0xEB, 0x98, 0xB2 },
	0x8C74, { 0xEB, 0x98, 0xB3 },
	0x8C75, { 0xEB, 0x98, 0xB5 },
	0x8C76, { 0xEB, 0x98, 0xB6 },
	0x8C77, { 0xEB, 0x98, 0xB7 },
	0x8C78, { 0xEB, 0x98, 0xB8 },
	0x8C79, { 0xEB, 0x98, 0xB9 },
	0x8C7A, { 0xEB, 0x98, 0xBA },
	0x8C81, { 0xEB, 0x98, 0xBB },
	0x8C82, { 0xEB, 0x98, 0xBC },
	0x8C83, { 0xEB, 0x98, 0xBD },
	0x8C84, { 0xEB, 0x98, 0xBE },
	0x8C85, { 0xEB, 0x98, 0xBF },
	0x8C86, { 0xEB, 0x99, 0x80 },
	0x8C87, { 0xEB, 0x99, 0x81 },
	0x8C88, { 0xEB, 0x99, 0x82 },
	0x8C89, { 0xEB, 0x99, 0x83 },
	0x8C8A, { 0xEB, 0x99, 0x84 },
	0x8C8B, { 0xEB, 0x99, 0x85 },
	0x8C8C, { 0xEB, 0x99, 0x86 },
	0x8C8D, { 0xEB, 0x99, 0x87 },
	0x8C8E, { 0xEB, 0x99, 0x89 },
	0x8C8F, { 0xEB, 0x99, 0x8A },
	0x8C90, { 0xEB, 0x99, 0x8B },
	0x8C91, { 0xEB, 0x99, 0x8C },
	0x8C92, { 0xEB, 0x99, 0x8D },
	0x8C93, { 0xEB, 0x99, 0x8E },
	0x8C94, { 0xEB, 0x99, 0x8F },
	0x8C95, { 0xEB, 0x99, 0x90 },
	0x8C96, { 0xEB, 0x99, 0x91 },
	0x8C97, { 0xEB, 0x99, 0x92 },
	0x8C98, { 0xEB, 0x99, 0x93 },
	0x8C99, { 0xEB, 0x99, 0x94 },
	0x8C9A, { 0xEB, 0x99, 0x95 },
	0x8C9B, { 0xEB, 0x99, 0x96 },
	0x8C9C, { 0xEB, 0x99, 0x97 },
	0x8C9D, { 0xEB, 0x99, 0x98 },
	0x8C9E, { 0xEB, 0x99, 0x99 },
	0x8C9F, { 0xEB, 0x99, 0x9A },
	0x8CA0, { 0xEB, 0x99, 0x9B },
	0x8CA1, { 0xEB, 0x99, 0x9C },
	0x8CA2, { 0xEB, 0x99, 0x9D },
	0x8CA3, { 0xEB, 0x99, 0x9E },
	0x8CA4, { 0xEB, 0x99, 0x9F },
	0x8CA5, { 0xEB, 0x99, 0xA0 },
	0x8CA6, { 0xEB, 0x99, 0xA1 },
	0x8CA7, { 0xEB, 0x99, 0xA2 },
	0x8CA8, { 0xEB, 0x99, 0xA3 },
	0x8CA9, { 0xEB, 0x99, 0xA5 },
	0x8CAA, { 0xEB, 0x99, 0xA6 },
	0x8CAB, { 0xEB, 0x99, 0xA7 },
	0x8CAC, { 0xEB, 0x99, 0xA9 },
	0x8CAD, { 0xEB, 0x99, 0xAA },
	0x8CAE, { 0xEB, 0x99, 0xAB },
	0x8CAF, { 0xEB, 0x99, 0xAC },
	0x8CB0, { 0xEB, 0x99, 0xAD },
	0x8CB1, { 0xEB, 0x99, 0xAE },
	0x8CB2, { 0xEB, 0x99, 0xAF },
	0x8CB3, { 0xEB, 0x99, 0xB0 },
	0x8CB4, { 0xEB, 0x99, 0xB1 },
	0x8CB5, { 0xEB, 0x99, 0xB2 },
	0x8CB6, { 0xEB, 0x99, 0xB3 },
	0x8CB7, { 0xEB, 0x99, 0xB4 },
	0x8CB8, { 0xEB, 0x99, 0xB5 },
	0x8CB9, { 0xEB, 0x99, 0xB6 },
	0x8CBA, { 0xEB, 0x99, 0xB7 },
	0x8CBB, { 0xEB, 0x99, 0xB8 },
	0x8CBC, { 0xEB, 0x99, 0xB9 },
	0x8CBD, { 0xEB, 0x99, 0xBA },
	0x8CBE, { 0xEB, 0x99, 0xBB },
	0x8CBF, { 0xEB, 0x99, 0xBC },
	0x8CC0, { 0xEB, 0x99, 0xBD },
	0x8CC1, { 0xEB, 0x99, 0xBE },
	0x8CC2, { 0xEB, 0x99, 0xBF },
	0x8CC3, { 0xEB, 0x9A, 0x80 },
	0x8CC4, { 0xEB, 0x9A, 0x81 },
	0x8CC5, { 0xEB, 0x9A, 0x82 },
	0x8CC6, { 0xEB, 0x9A, 0x83 },
	0x8CC7, { 0xEB, 0x9A, 0x84 },
	0x8CC8, { 0xEB, 0x9A, 0x85 },
	0x8CC9, { 0xEB, 0x9A, 0x86 },
	0x8CCA, { 0xEB, 0x9A, 0x87 },
	0x8CCB, { 0xEB, 0x9A, 0x88 },
	0x8CCC, { 0xEB, 0x9A, 0x89 },
	0x8CCD, { 0xEB, 0x9A, 0x8A },
	0x8CCE, { 0xEB, 0x9A, 0x8B },
	0x8CCF, { 0xEB, 0x9A, 0x8C },
	0x8CD0, { 0xEB, 0x9A, 0x8D },
	0x8CD1, { 0xEB, 0x9A, 0x8E },
	0x8CD2, { 0xEB, 0x9A, 0x8F },
	0x8CD3, { 0xEB, 0x9A, 0x90 },
	0x8CD4, { 0xEB, 0x9A, 0x91 },
	0x8CD5, { 0xEB, 0x9A, 0x92 },
	0x8CD6, { 0xEB, 0x9A, 0x93 },
	0x8CD7, { 0xEB, 0x9A, 0x94 },
	0x8CD8, { 0xEB, 0x9A, 0x95 },
	0x8CD9, { 0xEB, 0x9A, 0x96 },
	0x8CDA, { 0xEB, 0x9A, 0x97 },
	0x8CDB, { 0xEB, 0x9A, 0x98 },
	0x8CDC, { 0xEB, 0x9A, 0x99 },
	0x8CDD, { 0xEB, 0x9A, 0x9A },
	0x8CDE, { 0xEB, 0x9A, 0x9B },
	0x8CDF, { 0xEB, 0x9A, 0x9E },
	0x8CE0, { 0xEB, 0x9A, 0x9F },
	0x8CE1, { 0xEB, 0x9A, 0xA1 },
	0x8CE2, { 0xEB, 0x9A, 0xA2 },
	0x8CE3, { 0xEB, 0x9A, 0xA3 },
	0x8CE4, { 0xEB, 0x9A, 0xA5 },
	0x8CE5, { 0xEB, 0x9A, 0xA6 },
	0x8CE6, { 0xEB, 0x9A, 0xA7 },
	0x8CE7, { 0xEB, 0x9A, 0xA8 },
	0x8CE8, { 0xEB, 0x9A, 0xA9 },
	0x8CE9, { 0xEB, 0x9A, 0xAA },
	0x8CEA, { 0xEB, 0x9A, 0xAD },
	0x8CEB, { 0xEB, 0x9A, 0xAE },
	0x8CEC, { 0xEB, 0x9A, 0xAF },
	0x8CED, { 0xEB, 0x9A, 0xB0 },
	0x8CEE, { 0xEB, 0x9A, 0xB2 },
	0x8CEF, { 0xEB, 0x9A, 0xB3 },
	0x8CF0, { 0xEB, 0x9A, 0xB4 },
	0x8CF1, { 0xEB, 0x9A, 0xB5 },
	0x8CF2, { 0xEB, 0x9A, 0xB6 },
	0x8CF3, { 0xEB, 0x9A, 0xB7 },
	0x8CF4, { 0xEB, 0x9A, 0xB8 },
	0x8CF5, { 0xEB, 0x9A, 0xB9 },
	0x8CF6, { 0xEB, 0x9A, 0xBA },
	0x8CF7, { 0xEB, 0x9A, 0xBB },
	0x8CF8, { 0xEB, 0x9A, 0xBC },
	0x8CF9, { 0xEB, 0x9A, 0xBD },
	0x8CFA, { 0xEB, 0x9A, 0xBE },
	0x8CFB, { 0xEB, 0x9A, 0xBF },
	0x8CFC, { 0xEB, 0x9B, 0x80 },
	0x8CFD, { 0xEB, 0x9B, 0x81 },
	0x8CFE, { 0xEB, 0x9B, 0x82 },
	0x8D41, { 0xEB, 0x9B, 0x83 },
	0x8D42, { 0xEB, 0x9B, 0x84 },
	0x8D43, { 0xEB, 0x9B, 0x85 },
	0x8D44, { 0xEB, 0x9B, 0x86 },
	0x8D45, { 0xEB, 0x9B, 0x87 },
	0x8D46, { 0xEB, 0x9B, 0x88 },
	0x8D47, { 0xEB, 0x9B, 0x89 },
	0x8D48, { 0xEB, 0x9B, 0x8A },
	0x8D49, { 0xEB, 0x9B, 0x8B },
	0x8D4A, { 0xEB, 0x9B, 0x8C },
	0x8D4B, { 0xEB, 0x9B, 0x8D },
	0x8D4C, { 0xEB, 0x9B, 0x8E },
	0x8D4D, { 0xEB, 0x9B, 0x8F },
	0x8D4E, { 0xEB, 0x9B, 0x90 },
	0x8D4F, { 0xEB, 0x9B, 0x91 },
	0x8D50, { 0xEB, 0x9B, 0x92 },
	0x8D51, { 0xEB, 0x9B, 0x93 },
	0x8D52, { 0xEB, 0x9B, 0x95 },
	0x8D53, { 0xEB, 0x9B, 0x96 },
	0x8D54, { 0xEB, 0x9B, 0x97 },
	0x8D55, { 0xEB, 0x9B, 0x98 },
	0x8D56, { 0xEB, 0x9B, 0x99 },
	0x8D57, { 0xEB, 0x9B, 0x9A },
	0x8D58, { 0xEB, 0x9B, 0x9B },
	0x8D59, { 0xEB, 0x9B, 0x9C },
	0x8D5A, { 0xEB, 0x9B, 0x9D },
	0x8D61, { 0xEB, 0x9B, 0x9E },
	0x8D62, { 0xEB, 0x9B, 0x9F },
	0x8D63, { 0xEB, 0x9B, 0xA0 },
	0x8D64, { 0xEB, 0x9B, 0xA1 },
	0x8D65, { 0xEB, 0x9B, 0xA2 },
	0x8D66, { 0xEB, 0x9B, 0xA3 },
	0x8D67, { 0xEB, 0x9B, 0xA4 },
	0x8D68, { 0xEB, 0x9B, 0xA5 },
	0x8D69, { 0xEB, 0x9B, 0xA6 },
	0x8D6A, { 0xEB, 0x9B, 0xA7 },
	0x8D6B, { 0xEB, 0x9B, 0xA8 },
	0x8D6C, { 0xEB, 0x9B, 0xA9 },
	0x8D6D, { 0xEB, 0x9B, 0xAA },
	0x8D6E, { 0xEB, 0x9B, 0xAB },
	0x8D6F, { 0xEB, 0x9B, 0xAC },
	0x8D70, { 0xEB, 0x9B, 0xAD },
	0x8D71, { 0xEB, 0x9B, 0xAE },
	0x8D72, { 0xEB, 0x9B, 0xAF },
	0x8D73, { 0xEB, 0x9B, 0xB1 },
	0x8D74, { 0xEB, 0x9B, 0xB2 },
	0x8D75, { 0xEB, 0x9B, 0xB3 },
	0x8D76, { 0xEB, 0x9B, 0xB5 },
	0x8D77, { 0xEB, 0x9B, 0xB6 },
	0x8D78, { 0xEB, 0x9B, 0xB7 },
	0x8D79, { 0xEB, 0x9B, 0xB9 },
	0x8D7A, { 0xEB, 0x9B, 0xBA },
	0x8D81, { 0xEB, 0x9B, 0xBB },
	0x8D82, { 0xEB, 0x9B, 0xBC },
	0x8D83, { 0xEB, 0x9B, 0xBD },
	0x8D84, { 0xEB, 0x9B, 0xBE },
	0x8D85, { 0xEB, 0x9B, 0xBF },
	0x8D86, { 0xEB, 0x9C, 0x82 },
	0x8D87, { 0xEB, 0x9C, 0x83 },
	0x8D88, { 0xEB, 0x9C, 0x84 },
	0x8D89, { 0xEB, 0x9C, 0x86 },
	0x8D8A, { 0xEB, 0x9C, 0x87 },
	0x8D8B, { 0xEB, 0x9C, 0x88 },
	0x8D8C, { 0xEB, 0x9C, 0x89 },
	0x8D8D, { 0xEB, 0x9C, 0x8A },
	0x8D8E, { 0xEB, 0x9C, 0x8B },
	0x8D8F, { 0xEB, 0x9C, 0x8C },
	0x8D90, { 0xEB, 0x9C, 0x8D },
	0x8D91, { 0xEB, 0x9C, 0x8E },
	0x8D92, { 0xEB, 0x9C, 0x8F },
	0x8D93, { 0xEB, 0x9C, 0x90 },
	0x8D94, { 0xEB, 0x9C, 0x91 },
	0x8D95, { 0xEB, 0x9C, 0x92 },
	0x8D96, { 0xEB, 0x9C, 0x93 },
	0x8D97, { 0xEB, 0x9C, 0x94 },
	0x8D98, { 0xEB, 0x9C, 0x95 },
	0x8D99, { 0xEB, 0x9C, 0x96 },
	0x8D9A, { 0xEB, 0x9C, 0x97 },
	0x8D9B, { 0xEB, 0x9C, 0x98 },
	0x8D9C, { 0xEB, 0x9C, 0x99 },
	0x8D9D, { 0xEB, 0x9C, 0x9A },
	0x8D9E, { 0xEB, 0x9C, 0x9B },
	0x8D9F, { 0xEB, 0x9C, 0x9C },
	0x8DA0, { 0xEB, 0x9C, 0x9D },
	0x8DA1, { 0xEB, 0x9C, 0x9E },
	0x8DA2, { 0xEB, 0x9C, 0x9F },
	0x8DA3, { 0xEB, 0x9C, 0xA0 },
	0x8DA4, { 0xEB, 0x9C, 0xA1 },
	0x8DA5, { 0xEB, 0x9C, 0xA2 },
	0x8DA6, { 0xEB, 0x9C, 0xA3 },
	0x8DA7, { 0xEB, 0x9C, 0xA4 },
	0x8DA8, { 0xEB, 0x9C, 0xA5 },
	0x8DA9, { 0xEB, 0x9C, 0xA6 },
	0x8DAA, { 0xEB, 0x9C, 0xA7 },
	0x8DAB, { 0xEB, 0x9C, 0xAA },
	0x8DAC, { 0xEB, 0x9C, 0xAB },
	0x8DAD, { 0xEB, 0x9C, 0xAD },
	0x8DAE, { 0xEB, 0x9C, 0xAE },
	0x8DAF, { 0xEB, 0x9C, 0xB1 },
	0x8DB0, { 0xEB, 0x9C, 0xB2 },
	0x8DB1, { 0xEB, 0x9C, 0xB3 },
	0x8DB2, { 0xEB, 0x9C, 0xB4 },
	0x8DB3, { 0xEB, 0x9C, 0xB5 },
	0x8DB4, { 0xEB, 0x9C, 0xB6 },
	0x8DB5, { 0xEB, 0x9C, 0xB7 },
	0x8DB6, { 0xEB, 0x9C, 0xBA },
	0x8DB7, { 0xEB, 0x9C, 0xBC },
	0x8DB8, { 0xEB, 0x9C, 0xBD },
	0x8DB9, { 0xEB, 0x9C, 0xBE },
	0x8DBA, { 0xEB, 0x9C, 0xBF },
	0x8DBB, { 0xEB, 0x9D, 0x80 },
	0x8DBC, { 0xEB, 0x9D, 0x81 },
	0x8DBD, { 0xEB, 0x9D, 0x82 },
	0x8DBE, { 0xEB, 0x9D, 0x83 },
	0x8DBF, { 0xEB, 0x9D, 0x85 },
	0x8DC0, { 0xEB, 0x9D, 0x86 },
	0x8DC1, { 0xEB, 0x9D, 0x87 },
	0x8DC2, { 0xEB, 0x9D, 0x89 },
	0x8DC3, { 0xEB, 0x9D, 0x8A },
	0x8DC4, { 0xEB, 0x9D, 0x8B },
	0x8DC5, { 0xEB, 0x9D, 0x8D },
	0x8DC6, { 0xEB, 0x9D, 0x8E },
	0x8DC7, { 0xEB, 0x9D, 0x8F },
	0x8DC8, { 0xEB, 0x9D, 0x90 },
	0x8DC9, { 0xEB, 0x9D, 0x91 },
	0x8DCA, { 0xEB, 0x9D, 0x92 },
	0x8DCB, { 0xEB, 0x9D, 0x93 },
	0x8DCC, { 0xEB, 0x9D, 0x96 },
	0x8DCD, { 0xEB, 0x9D, 0x97 },
	0x8DCE, { 0xEB, 0x9D, 0x98 },
	0x8DCF, { 0xEB, 0x9D, 0x99 },
	0x8DD0, { 0xEB, 0x9D, 0x9A },
	0x8DD1, { 0xEB, 0x9D, 0x9B },
	0x8DD2, { 0xEB, 0x9D, 0x9C },
	0x8DD3, { 0xEB, 0x9D, 0x9D },
	0x8DD4, { 0xEB, 0x9D, 0x9E },
	0x8DD5, { 0xEB, 0x9D, 0x9F },
	0x8DD6, { 0xEB, 0x9D, 0xA1 },
	0x8DD7, { 0xEB, 0x9D, 0xA2 },
	0x8DD8, { 0xEB, 0x9D, 0xA3 },
	0x8DD9, { 0xEB, 0x9D, 0xA5 },
	0x8DDA, { 0xEB, 0x9D, 0xA6 },
	0x8DDB, { 0xEB, 0x9D, 0xA7 },
	0x8DDC, { 0xEB, 0x9D, 0xA9 },
	0x8DDD, { 0xEB, 0x9D, 0xAA },
	0x8DDE, { 0xEB, 0x9D, 0xAB },
	0x8DDF, { 0xEB, 0x9D, 0xAC },
	0x8DE0, { 0xEB, 0x9D, 0xAD },
	0x8DE1, { 0xEB, 0x9D, 0xAE },
	0x8DE2, { 0xEB, 0x9D, 0xAF },
	0x8DE3, { 0xEB, 0x9D, 0xB2 },
	0x8DE4, { 0xEB, 0x9D, 0xB4 },
	0x8DE5, { 0xEB, 0x9D, 0xB6 },
	0x8DE6, { 0xEB, 0x9D, 0xB7 },
	0x8DE7, { 0xEB, 0x9D, 0xB8 },
	0x8DE8, { 0xEB, 0x9D, 0xB9 },
	0x8DE9, { 0xEB, 0x9D, 0xBA },
	0x8DEA, { 0xEB, 0x9D, 0xBB },
	0x8DEB, { 0xEB, 0x9D, 0xBE },
	0x8DEC, { 0xEB, 0x9D, 0xBF },
	0x8DED, { 0xEB, 0x9E, 0x81 },
	0x8DEE, { 0xEB, 0x9E, 0x82 },
	0x8DEF, { 0xEB, 0x9E, 0x83 },
	0x8DF0, { 0xEB, 0x9E, 0x85 },
	0x8DF1, { 0xEB, 0x9E, 0x86 },
	0x8DF2, { 0xEB, 0x9E, 0x87 },
	0x8DF3, { 0xEB, 0x9E, 0x88 },
	0x8DF4, { 0xEB, 0x9E, 0x89 },
	0x8DF5, { 0xEB, 0x9E, 0x8A },
	0x8DF6, { 0xEB, 0x9E, 0x8B },
	0x8DF7, { 0xEB, 0x9E, 0x8E },
	0x8DF8, { 0xEB, 0x9E, 0x93 },
	0x8DF9, { 0xEB, 0x9E, 0x94 },
	0x8DFA, { 0xEB, 0x9E, 0x95 },
	0x8DFB, { 0xEB, 0x9E, 0x9A },
	0x8DFC, { 0xEB, 0x9E, 0x9B },
	0x8DFD, { 0xEB, 0x9E, 0x9D },
	0x8DFE, { 0xEB, 0x9E, 0x9E },
	0x8E41, { 0xEB, 0x9E, 0x9F },
	0x8E42, { 0xEB, 0x9E, 0xA1 },
	0x8E43, { 0xEB, 0x9E, 0xA2 },
	0x8E44, { 0xEB, 0x9E, 0xA3 },
	0x8E45, { 0xEB, 0x9E, 0xA4 },
	0x8E46, { 0xEB, 0x9E, 0xA5 },
	0x8E47, { 0xEB, 0x9E, 0xA6 },
	0x8E48, { 0xEB, 0x9E, 0xA7 },
	0x8E49, { 0xEB, 0x9E, 0xAA },
	0x8E4A, { 0xEB, 0x9E, 0xAE },
	0x8E4B, { 0xEB, 0x9E, 0xAF },
	0x8E4C, { 0xEB, 0x9E, 0xB0 },
	0x8E4D, { 0xEB, 0x9E, 0xB1 },
	0x8E4E, { 0xEB, 0x9E, 0xB2 },
	0x8E4F, { 0xEB, 0x9E, 0xB3 },
	0x8E50, { 0xEB, 0x9E, 0xB6 },
	0x8E51, { 0xEB, 0x9E, 0xB7 },
	0x8E52, { 0xEB, 0x9E, 0xB9 },
	0x8E53, { 0xEB, 0x9E, 0xBA },
	0x8E54, { 0xEB, 0x9E, 0xBB },
	0x8E55, { 0xEB, 0x9E, 0xBC },
	0x8E56, { 0xEB, 0x9E, 0xBD },
	0x8E57, { 0xEB, 0x9E, 0xBE },
	0x8E58, { 0xEB, 0x9E, 0xBF },
	0x8E59, { 0xEB, 0x9F, 0x80 },
	0x8E5A, { 0xEB, 0x9F, 0x81 },
	0x8E61, { 0xEB, 0x9F, 0x82 },
	0x8E62, { 0xEB, 0x9F, 0x83 },
	0x8E63, { 0xEB, 0x9F, 0x84 },
	0x8E64, { 0xEB, 0x9F, 0x85 },
	0x8E65, { 0xEB, 0x9F, 0x86 },
	0x8E66, { 0xEB, 0x9F, 0x88 },
	0x8E67, { 0xEB, 0x9F, 0x8A },
	0x8E68, { 0xEB, 0x9F, 0x8B },
	0x8E69, { 0xEB, 0x9F, 0x8C },
	0x8E6A, { 0xEB, 0x9F, 0x8D },
	0x8E6B, { 0xEB, 0x9F, 0x8E },
	0x8E6C, { 0xEB, 0x9F, 0x8F },
	0x8E6D, { 0xEB, 0x9F, 0x90 },
	0x8E6E, { 0xEB, 0x9F, 0x91 },
	0x8E6F, { 0xEB, 0x9F, 0x92 },
	0x8E70, { 0xEB, 0x9F, 0x93 },
	0x8E71, { 0xEB, 0x9F, 0x94 },
	0x8E72, { 0xEB, 0x9F, 0x95 },
	0x8E73, { 0xEB, 0x9F, 0x96 },
	0x8E74, { 0xEB, 0x9F, 0x97 },
	0x8E75, { 0xEB, 0x9F, 0x98 },
	0x8E76, { 0xEB, 0x9F, 0x99 },
	0x8E77, { 0xEB, 0x9F, 0x9A },
	0x8E78, { 0xEB, 0x9F, 0x9B },
	0x8E79, { 0xEB, 0x9F, 0x9C },
	0x8E7A, { 0xEB, 0x9F, 0x9D },
	0x8E81, { 0xEB, 0x9F, 0x9E },
	0x8E82, { 0xEB, 0x9F, 0x9F },
	0x8E83, { 0xEB, 0x9F, 0xA0 },
	0x8E84, { 0xEB, 0x9F, 0xA1 },
	0x8E85, { 0xEB, 0x9F, 0xA2 },
	0x8E86, { 0xEB, 0x9F, 0xA3 },
	0x8E87, { 0xEB, 0x9F, 0xA4 },
	0x8E88, { 0xEB, 0x9F, 0xA5 },
	0x8E89, { 0xEB, 0x9F, 0xA6 },
	0x8E8A, { 0xEB, 0x9F, 0xA7 },
	0x8E8B, { 0xEB, 0x9F, 0xA8 },
	0x8E8C, { 0xEB, 0x9F, 0xA9 },
	0x8E8D, { 0xEB, 0x9F, 0xAA },
	0x8E8E, { 0xEB, 0x9F, 0xAB },
	0x8E8F, { 0xEB, 0x9F, 0xAE },
	0x8E90, { 0xEB, 0x9F, 0xAF },
	0x8E91, { 0xEB, 0x9F, 0xB1 },
	0x8E92, { 0xEB, 0x9F, 0xB2 },
	0x8E93, { 0xEB, 0x9F, 0xB3 },
	0x8E94, { 0xEB, 0x9F, 0xB5 },
	0x8E95, { 0xEB, 0x9F, 0xB6 },
	0x8E96, { 0xEB, 0x9F, 0xB7 },
	0x8E97, { 0xEB, 0x9F, 0xB8 },
	0x8E98, { 0xEB, 0x9F, 0xB9 },
	0x8E99, { 0xEB, 0x9F, 0xBA },
	0x8E9A, { 0xEB, 0x9F, 0xBB },
	0x8E9B, { 0xEB, 0x9F, 0xBE },
	0x8E9C, { 0xEB, 0xA0, 0x82 },
	0x8E9D, { 0xEB, 0xA0, 0x83 },
	0x8E9E, { 0xEB, 0xA0, 0x84 },
	0x8E9F, { 0xEB, 0xA0, 0x85 },
	0x8EA0, { 0xEB, 0xA0, 0x86 },
	0x8EA1, { 0xEB, 0xA0, 0x8A },
	0x8EA2, { 0xEB, 0xA0, 0x8B },
	0x8EA3, { 0xEB, 0xA0, 0x8D },
	0x8EA4, { 0xEB, 0xA0, 0x8E },
	0x8EA5, { 0xEB, 0xA0, 0x8F },
	0x8EA6, { 0xEB, 0xA0, 0x91 },
	0x8EA7, { 0xEB, 0xA0, 0x92 },
	0x8EA8, { 0xEB, 0xA0, 0x93 },
	0x8EA9, { 0xEB, 0xA0, 0x94 },
	0x8EAA, { 0xEB, 0xA0, 0x95 },
	0x8EAB, { 0xEB, 0xA0, 0x96 },
	0x8EAC, { 0xEB, 0xA0, 0x97 },
	0x8EAD, { 0xEB, 0xA0, 0x9A },
	0x8EAE, { 0xEB, 0xA0, 0x9C },
	0x8EAF, { 0xEB, 0xA0, 0x9E },
	0x8EB0, { 0xEB, 0xA0, 0x9F },
	0x8EB1, { 0xEB, 0xA0, 0xA0 },
	0x8EB2, { 0xEB, 0xA0, 0xA1 },
	0x8EB3, { 0xEB, 0xA0, 0xA2 },
	0x8EB4, { 0xEB, 0xA0, 0xA3 },
	0x8EB5, { 0xEB, 0xA0, 0xA6 },
	0x8EB6, { 0xEB, 0xA0, 0xA7 },
	0x8EB7, { 0xEB, 0xA0, 0xA9 },
	0x8EB8, { 0xEB, 0xA0, 0xAA },
	0x8EB9, { 0xEB, 0xA0, 0xAB },
	0x8EBA, { 0xEB, 0xA0, 0xAD },
	0x8EBB, { 0xEB, 0xA0, 0xAE },
	0x8EBC, { 0xEB, 0xA0, 0xAF },
	0x8EBD, { 0xEB, 0xA0, 0xB0 },
	0x8EBE, { 0xEB, 0xA0, 0xB1 },
	0x8EBF, { 0xEB, 0xA0, 0xB2 },
	0x8EC0, { 0xEB, 0xA0, 0xB3 },
	0x8EC1, { 0xEB, 0xA0, 0xB6 },
	0x8EC2, { 0xEB, 0xA0, 0xBA },
	0x8EC3, { 0xEB, 0xA0, 0xBB },
	0x8EC4, { 0xEB, 0xA0, 0xBC },
	0x8EC5, { 0xEB, 0xA0, 0xBD },
	0x8EC6, { 0xEB, 0xA0, 0xBE },
	0x8EC7, { 0xEB, 0xA0, 0xBF },
	0x8EC8, { 0xEB, 0xA1, 0x81 },
	0x8EC9, { 0xEB, 0xA1, 0x82 },
	0x8ECA, { 0xEB, 0xA1, 0x83 },
	0x8ECB, { 0xEB, 0xA1, 0x85 },
	0x8ECC, { 0xEB, 0xA1, 0x86 },
	0x8ECD, { 0xEB, 0xA1, 0x87 },
	0x8ECE, { 0xEB, 0xA1, 0x88 },
	0x8ECF, { 0xEB, 0xA1, 0x89 },
	0x8ED0, { 0xEB, 0xA1, 0x8A },
	0x8ED1, { 0xEB, 0xA1, 0x8B },
	0x8ED2, { 0xEB, 0xA1, 0x8C },
	0x8ED3, { 0xEB, 0xA1, 0x8D },
	0x8ED4, { 0xEB, 0xA1, 0x8E },
	0x8ED5, { 0xEB, 0xA1, 0x8F },
	0x8ED6, { 0xEB, 0xA1, 0x90 },
	0x8ED7, { 0xEB, 0xA1, 0x92 },
	0x8ED8, { 0xEB, 0xA1, 0x94 },
	0x8ED9, { 0xEB, 0xA1, 0x95 },
	0x8EDA, { 0xEB, 0xA1, 0x96 },
	0x8EDB, { 0xEB, 0xA1, 0x97 },
	0x8EDC, { 0xEB, 0xA1, 0x98 },
	0x8EDD, { 0xEB, 0xA1, 0x99 },
	0x8EDE, { 0xEB, 0xA1, 0x9A },
	0x8EDF, { 0xEB, 0xA1, 0x9B },
	0x8EE0, { 0xEB, 0xA1, 0x9E },
	0x8EE1, { 0xEB, 0xA1, 0x9F },
	0x8EE2, { 0xEB, 0xA1, 0xA1 },
	0x8EE3, { 0xEB, 0xA1, 0xA2 },
	0x8EE4, { 0xEB, 0xA1, 0xA3 },
	0x8EE5, { 0xEB, 0xA1, 0xA5 },
	0x8EE6, { 0xEB, 0xA1, 0xA6 },
	0x8EE7, { 0xEB, 0xA1, 0xA7 },
	0x8EE8, { 0xEB, 0xA1, 0xA8 },
	0x8EE9, { 0xEB, 0xA1, 0xA9 },
	0x8EEA, { 0xEB, 0xA1, 0xAA },
	0x8EEB, { 0xEB, 0xA1, 0xAB },
	0x8EEC, { 0xEB, 0xA1, 0xAE },
	0x8EED, { 0xEB, 0xA1, 0xB0 },
	0x8EEE, { 0xEB, 0xA1, 0xB2 },
	0x8EEF, { 0xEB, 0xA1, 0xB3 },
	0x8EF0, { 0xEB, 0xA1, 0xB4 },
	0x8EF1, { 0xEB, 0xA1, 0xB5 },
	0x8EF2, { 0xEB, 0xA1, 0xB6 },
	0x8EF3, { 0xEB, 0xA1, 0xB7 },
	0x8EF4, { 0xEB, 0xA1, 0xB9 },
	0x8EF5, { 0xEB, 0xA1, 0xBA },
	0x8EF6, { 0xEB, 0xA1, 0xBB },
	0x8EF7, { 0xEB, 0xA1, 0xBD },
	0x8EF8, { 0xEB, 0xA1, 0xBE },
	0x8EF9, { 0xEB, 0xA1, 0xBF },
	0x8EFA, { 0xEB, 0xA2, 0x80 },
	0x8EFB, { 0xEB, 0xA2, 0x81 },
	0x8EFC, { 0xEB, 0xA2, 0x82 },
	0x8EFD, { 0xEB, 0xA2, 0x83 },
	0x8EFE, { 0xEB, 0xA2, 0x84 },
	0x8F41, { 0xEB, 0xA2, 0x85 },
	0x8F42, { 0xEB, 0xA2, 0x86 },
	0x8F43, { 0xEB, 0xA2, 0x87 },
	0x8F44, { 0xEB, 0xA2, 0x88 },
	0x8F45, { 0xEB, 0xA2, 0x89 },
	0x8F46, { 0xEB, 0xA2, 0x8A },
	0x8F47, { 0xEB, 0xA2, 0x8B },
	0x8F48, { 0xEB, 0xA2, 0x8C },
	0x8F49, { 0xEB, 0xA2, 0x8E },
	0x8F4A, { 0xEB, 0xA2, 0x8F },
	0x8F4B, { 0xEB, 0xA2, 0x90 },
	0x8F4C, { 0xEB, 0xA2, 0x91 },
	0x8F4D, { 0xEB, 0xA2, 0x92 },
	0x8F4E, { 0xEB, 0xA2, 0x93 },
	0x8F4F, { 0xEB, 0xA2, 0x94 },
	0x8F50, { 0xEB, 0xA2, 0x95 },
	0x8F51, { 0xEB, 0xA2, 0x96 },
	0x8F52, { 0xEB, 0xA2, 0x97 },
	0x8F53, { 0xEB, 0xA2, 0x98 },
	0x8F54, { 0xEB, 0xA2, 0x99 },
	0x8F55, { 0xEB, 0xA2, 0x9A },
	0x8F56, { 0xEB, 0xA2, 0x9B },
	0x8F57, { 0xEB, 0xA2, 0x9C },
	0x8F58, { 0xEB, 0xA2, 0x9D },
	0x8F59, { 0xEB, 0xA2, 0x9E },
	0x8F5A, { 0xEB, 0xA2, 0x9F },
	0x8F61, { 0xEB, 0xA2, 0xA0 },
	0x8F62, { 0xEB, 0xA2, 0xA1 },
	0x8F63, { 0xEB, 0xA2, 0xA2 },
	0x8F64, { 0xEB, 0xA2, 0xA3 },
	0x8F65, { 0xEB, 0xA2, 0xA4 },
	0x8F66, { 0xEB, 0xA2, 0xA5 },
	0x8F67, { 0xEB, 0xA2, 0xA6 },
	0x8F68, { 0xEB, 0xA2, 0xA7 },
	0x8F69, { 0xEB, 0xA2, 0xA9 },
	0x8F6A, { 0xEB, 0xA2, 0xAA },
	0x8F6B, { 0xEB, 0xA2, 0xAB },
	0x8F6C, { 0xEB, 0xA2, 0xAC },
	0x8F6D, { 0xEB, 0xA2, 0xAD },
	0x8F6E, { 0xEB, 0xA2, 0xAE },
	0x8F6F, { 0xEB, 0xA2, 0xAF },
	0x8F70, { 0xEB, 0xA2, 0xB1 },
	0x8F71, { 0xEB, 0xA2, 0xB2 },
	0x8F72, { 0xEB, 0xA2, 0xB3 },
	0x8F73, { 0xEB, 0xA2, 0xB5 },
	0x8F74, { 0xEB, 0xA2, 0xB6 },
	0x8F75, { 0xEB, 0xA2, 0xB7 },
	0x8F76, { 0xEB, 0xA2, 0xB9 },
	0x8F77, { 0xEB, 0xA2, 0xBA },
	0x8F78, { 0xEB, 0xA2, 0xBB },
	0x8F79, { 0xEB, 0xA2, 0xBC },
	0x8F7A, { 0xEB, 0xA2, 0xBD },
	0x8F81, { 0xEB, 0xA2, 0xBE },
	0x8F82, { 0xEB, 0xA2, 0xBF },
	0x8F83, { 0xEB, 0xA3, 0x82 },
	0x8F84, { 0xEB, 0xA3, 0x84 },
	0x8F85, { 0xEB, 0xA3, 0x86 },
	0x8F86, { 0xEB, 0xA3, 0x87 },
	0x8F87, { 0xEB, 0xA3, 0x88 },
	0x8F88, { 0xEB, 0xA3, 0x89 },
	0x8F89, { 0xEB, 0xA3, 0x8A },
	0x8F8A, { 0xEB, 0xA3, 0x8B },
	0x8F8B, { 0xEB, 0xA3, 0x8D },
	0x8F8C, { 0xEB, 0xA3, 0x8E },
	0x8F8D, { 0xEB, 0xA3, 0x8F },
	0x8F8E, { 0xEB, 0xA3, 0x91 },
	0x8F8F, { 0xEB, 0xA3, 0x92 },
	0x8F90, { 0xEB, 0xA3, 0x93 },
	0x8F91, { 0xEB, 0xA3, 0x95 },
	0x8F92, { 0xEB, 0xA3, 0x96 },
	0x8F93, { 0xEB, 0xA3, 0x97 },
	0x8F94, { 0xEB, 0xA3, 0x98 },
	0x8F95, { 0xEB, 0xA3, 0x99 },
	0x8F96, { 0xEB, 0xA3, 0x9A },
	0x8F97, { 0xEB, 0xA3, 0x9B },
	0x8F98, { 0xEB, 0xA3, 0x9C },
	0x8F99, { 0xEB, 0xA3, 0x9E },
	0x8F9A, { 0xEB, 0xA3, 0xA0 },
	0x8F9B, { 0xEB, 0xA3, 0xA2 },
	0x8F9C, { 0xEB, 0xA3, 0xA3 },
	0x8F9D, { 0xEB, 0xA3, 0xA4 },
	0x8F9E, { 0xEB, 0xA3, 0xA5 },
	0x8F9F, { 0xEB, 0xA3, 0xA6 },
	0x8FA0, { 0xEB, 0xA3, 0xA7 },
	0x8FA1, { 0xEB, 0xA3, 0xAA },
	0x8FA2, { 0xEB, 0xA3, 0xAB },
	0x8FA3, { 0xEB, 0xA3, 0xAD },
	0x8FA4, { 0xEB, 0xA3, 0xAE },
	0x8FA5, { 0xEB, 0xA3, 0xAF },
	0x8FA6, { 0xEB, 0xA3, 0xB1 },
	0x8FA7, { 0xEB, 0xA3, 0xB2 },
	0x8FA8, { 0xEB, 0xA3, 0xB3 },
	0x8FA9, { 0xEB, 0xA3, 0xB4 },
	0x8FAA, { 0xEB, 0xA3, 0xB5 },
	0x8FAB, { 0xEB, 0xA3, 0xB6 },
	0x8FAC, { 0xEB, 0xA3, 0xB7 },
	0x8FAD, { 0xEB, 0xA3, 0xBA },
	0x8FAE, { 0xEB, 0xA3, 0xBC },
	0x8FAF, { 0xEB, 0xA3, 0xBE },
	0x8FB0, { 0xEB, 0xA3, 0xBF },
	0x8FB1, { 0xEB, 0xA4, 0x80 },
	0x8FB2, { 0xEB, 0xA4, 0x81 },
	0x8FB3, { 0xEB, 0xA4, 0x82 },
	0x8FB4, { 0xEB, 0xA4, 0x83 },
	0x8FB5, { 0xEB, 0xA4, 0x85 },
	0x8FB6, { 0xEB, 0xA4, 0x86 },
	0x8FB7, { 0xEB, 0xA4, 0x87 },
	0x8FB8, { 0xEB, 0xA4, 0x88 },
	0x8FB9, { 0xEB, 0xA4, 0x89 },
	0x8FBA, { 0xEB, 0xA4, 0x8A },
	0x8FBB, { 0xEB, 0xA4, 0x8B },
	0x8FBC, { 0xEB, 0xA4, 0x8C },
	0x8FBD, { 0xEB, 0xA4, 0x8D },
	0x8FBE, { 0xEB, 0xA4, 0x8E },
	0x8FBF, { 0xEB, 0xA4, 0x8F },
	0x8FC0, { 0xEB, 0xA4, 0x90 },
	0x8FC1, { 0xEB, 0xA4, 0x91 },
	0x8FC2, { 0xEB, 0xA4, 0x92 },
	0x8FC3, { 0xEB, 0xA4, 0x93 },
	0x8FC4, { 0xEB, 0xA4, 0x94 },
	0x8FC5, { 0xEB, 0xA4, 0x95 },
	0x8FC6, { 0xEB, 0xA4, 0x96 },
	0x8FC7, { 0xEB, 0xA4, 0x97 },
	0x8FC8, { 0xEB, 0xA4, 0x99 },
	0x8FC9, { 0xEB, 0xA4, 0x9A },
	0x8FCA, { 0xEB, 0xA4, 0x9B },
	0x8FCB, { 0xEB, 0xA4, 0x9C },
	0x8FCC, { 0xEB, 0xA4, 0x9D },
	0x8FCD, { 0xEB, 0xA4, 0x9E },
	0x8FCE, { 0xEB, 0xA4, 0x9F },
	0x8FCF, { 0xEB, 0xA4, 0xA1 },
	0x8FD0, { 0xEB, 0xA4, 0xA2 },
	0x8FD1, { 0xEB, 0xA4, 0xA3 },
	0x8FD2, { 0xEB, 0xA4, 0xA4 },
	0x8FD3, { 0xEB, 0xA4, 0xA5 },
	0x8FD4, { 0xEB, 0xA4, 0xA6 },
	0x8FD5, { 0xEB, 0xA4, 0xA7 },
	0x8FD6, { 0xEB, 0xA4, 0xA8 },
	0x8FD7, { 0xEB, 0xA4, 0xA9 },
	0x8FD8, { 0xEB, 0xA4, 0xAA },
	0x8FD9, { 0xEB, 0xA4, 0xAB },
	0x8FDA, { 0xEB, 0xA4, 0xAC },
	0x8FDB, { 0xEB, 0xA4, 0xAD },
	0x8FDC, { 0xEB, 0xA4, 0xAE },
	0x8FDD, { 0xEB, 0xA4, 0xAF },
	0x8FDE, { 0xEB, 0xA4, 0xB0 },
	0x8FDF, { 0xEB, 0xA4, 0xB1 },
	0x8FE0, { 0xEB, 0xA4, 0xB2 },
	0x8FE1, { 0xEB, 0xA4, 0xB3 },
	0x8FE2, { 0xEB, 0xA4, 0xB4 },
	0x8FE3, { 0xEB, 0xA4, 0xB5 },
	0x8FE4, { 0xEB, 0xA4, 0xB6 },
	0x8FE5, { 0xEB, 0xA4, 0xB7 },
	0x8FE6, { 0xEB, 0xA4, 0xB8 },
	0x8FE7, { 0xEB, 0xA4, 0xB9 },
	0x8FE8, { 0xEB, 0xA4, 0xBA },
	0x8FE9, { 0xEB, 0xA4, 0xBB },
	0x8FEA, { 0xEB, 0xA4, 0xBE },
	0x8FEB, { 0xEB, 0xA4, 0xBF },
	0x8FEC, { 0xEB, 0xA5, 0x81 },
	0x8FED, { 0xEB, 0xA5, 0x82 },
	0x8FEE, { 0xEB, 0xA5, 0x83 },
	0x8FEF, { 0xEB, 0xA5, 0x85 },
	0x8FF0, { 0xEB, 0xA5, 0x86 },
	0x8FF1, { 0xEB, 0xA5, 0x87 },
	0x8FF2, { 0xEB, 0xA5, 0x88 },
	0x8FF3, { 0xEB, 0xA5, 0x89 },
	0x8FF4, { 0xEB, 0xA5, 0x8A },
	0x8FF5, { 0xEB, 0xA5, 0x8B },
	0x8FF6, { 0xEB, 0xA5, 0x8D },
	0x8FF7, { 0xEB, 0xA5, 0x8E },
	0x8FF8, { 0xEB, 0xA5, 0x90 },
	0x8FF9, { 0xEB, 0xA5, 0x92 },
	0x8FFA, { 0xEB, 0xA5, 0x93 },
	0x8FFB, { 0xEB, 0xA5, 0x94 },
	0x8FFC, { 0xEB, 0xA5, 0x95 },
	0x8FFD, { 0xEB, 0xA5, 0x96 },
	0x8FFE, { 0xEB, 0xA5, 0x97 },
	0x9041, { 0xEB, 0xA5, 0x9A },
	0x9042, { 0xEB, 0xA5, 0x9B },
	0x9043, { 0xEB, 0xA5, 0x9D },
	0x9044, { 0xEB, 0xA5, 0x9E },
	0x9045, { 0xEB, 0xA5, 0x9F },
	0x9046, { 0xEB, 0xA5, 0xA1 },
	0x9047, { 0xEB, 0xA5, 0xA2 },
	0x9048, { 0xEB, 0xA5, 0xA3 },
	0x9049, { 0xEB, 0xA5, 0xA4 },
	0x904A, { 0xEB, 0xA5, 0xA5 },
	0x904B, { 0xEB, 0xA5, 0xA6 },
	0x904C, { 0xEB, 0xA5, 0xA7 },
	0x904D, { 0xEB, 0xA5, 0xAA },
	0x904E, { 0xEB, 0xA5, 0xAC },
	0x904F, { 0xEB, 0xA5, 0xAE },
	0x9050, { 0xEB, 0xA5, 0xAF },
	0x9051, { 0xEB, 0xA5, 0xB0 },
	0x9052, { 0xEB, 0xA5, 0xB1 },
	0x9053, { 0xEB, 0xA5, 0xB2 },
	0x9054, { 0xEB, 0xA5, 0xB3 },
	0x9055, { 0xEB, 0xA5, 0xB6 },
	0x9056, { 0xEB, 0xA5, 0xB7 },
	0x9057, { 0xEB, 0xA5, 0xB9 },
	0x9058, { 0xEB, 0xA5, 0xBA },
	0x9059, { 0xEB, 0xA5, 0xBB },
	0x905A, { 0xEB, 0xA5, 0xBD },
	0x9061, { 0xEB, 0xA5, 0xBE },
	0x9062, { 0xEB, 0xA5, 0xBF },
	0x9063, { 0xEB, 0xA6, 0x80 },
	0x9064, { 0xEB, 0xA6, 0x81 },
	0x9065, { 0xEB, 0xA6, 0x82 },
	0x9066, { 0xEB, 0xA6, 0x83 },
	0x9067, { 0xEB, 0xA6, 0x86 },
	0x9068, { 0xEB, 0xA6, 0x88 },
	0x9069, { 0xEB, 0xA6, 0x8B },
	0x906A, { 0xEB, 0xA6, 0x8C },
	0x906B, { 0xEB, 0xA6, 0x8F },
	0x906C, { 0xEB, 0xA6, 0x90 },
	0x906D, { 0xEB, 0xA6, 0x91 },
	0x906E, { 0xEB, 0xA6, 0x92 },
	0x906F, { 0xEB, 0xA6, 0x93 },
	0x9070, { 0xEB, 0xA6, 0x94 },
	0x9071, { 0xEB, 0xA6, 0x95 },
	0x9072, { 0xEB, 0xA6, 0x96 },
	0x9073, { 0xEB, 0xA6, 0x97 },
	0x9074, { 0xEB, 0xA6, 0x98 },
	0x9075, { 0xEB, 0xA6, 0x99 },
	0x9076, { 0xEB, 0xA6, 0x9A },
	0x9077, { 0xEB, 0xA6, 0x9B },
	0x9078, { 0xEB, 0xA6, 0x9C },
	0x9079, { 0xEB, 0xA6, 0x9D },
	0x907A, { 0xEB, 0xA6, 0x9E },
	0x9081, { 0xEB, 0xA6, 0x9F },
	0x9082, { 0xEB, 0xA6, 0xA0 },
	0x9083, { 0xEB, 0xA6, 0xA1 },
	0x9084, { 0xEB, 0xA6, 0xA2 },
	0x9085, { 0xEB, 0xA6, 0xA3 },
	0x9086, { 0xEB, 0xA6, 0xA4 },
	0x9087, { 0xEB, 0xA6, 0xA5 },
	0x9088, { 0xEB, 0xA6, 0xA6 },
	0x9089, { 0xEB, 0xA6, 0xA7 },
	0x908A, { 0xEB, 0xA6, 0xA8 },
	0x908B, { 0xEB, 0xA6, 0xA9 },
	0x908C, { 0xEB, 0xA6, 0xAA },
	0x908D, { 0xEB, 0xA6, 0xAB },
	0x908E, { 0xEB, 0xA6, 0xAE },
	0x908F, { 0xEB, 0xA6, 0xAF },
	0x9090, { 0xEB, 0xA6, 0xB1 },
	0x9091, { 0xEB, 0xA6, 0xB2 },
	0x9092, { 0xEB, 0xA6, 0xB3 },
	0x9093, { 0xEB, 0xA6, 0xB5 },
	0x9094, { 0xEB, 0xA6, 0xB6 },
	0x9095, { 0xEB, 0xA6, 0xB7 },
	0x9096, { 0xEB, 0xA6, 0xB8 },
	0x9097, { 0xEB, 0xA6, 0xB9 },
	0x9098, { 0xEB, 0xA6, 0xBA },
	0x9099, { 0xEB, 0xA6, 0xBB },
	0x909A, { 0xEB, 0xA6, 0xBE },
	0x909B, { 0xEB, 0xA7, 0x80 },
	0x909C, { 0xEB, 0xA7, 0x82 },
	0x909D, { 0xEB, 0xA7, 0x83 },
	0x909E, { 0xEB, 0xA7, 0x84 },
	0x909F, { 0xEB, 0xA7, 0x85 },
	0x90A0, { 0xEB, 0xA7, 0x86 },
	0x90A1, { 0xEB, 0xA7, 0x87 },
	0x90A2, { 0xEB, 0xA7, 0x8A },
	0x90A3, { 0xEB, 0xA7, 0x8B },
	0x90A4, { 0xEB, 0xA7, 0x8D },
	0x90A5, { 0xEB, 0xA7, 0x93 },
	0x90A6, { 0xEB, 0xA7, 0x94 },
	0x90A7, { 0xEB, 0xA7, 0x95 },
	0x90A8, { 0xEB, 0xA7, 0x96 },
	0x90A9, { 0xEB, 0xA7, 0x97 },
	0x90AA, { 0xEB, 0xA7, 0x9A },
	0x90AB, { 0xEB, 0xA7, 0x9C },
	0x90AC, { 0xEB, 0xA7, 0x9F },
	0x90AD, { 0xEB, 0xA7, 0xA0 },
	0x90AE, { 0xEB, 0xA7, 0xA2 },
	0x90AF, { 0xEB, 0xA7, 0xA6 },
	0x90B0, { 0xEB, 0xA7, 0xA7 },
	0x90B1, { 0xEB, 0xA7, 0xA9 },
	0x90B2, { 0xEB, 0xA7, 0xAA },
	0x90B3, { 0xEB, 0xA7, 0xAB },
	0x90B4, { 0xEB, 0xA7, 0xAD },
	0x90B5, { 0xEB, 0xA7, 0xAE },
	0x90B6, { 0xEB, 0xA7, 0xAF },
	0x90B7, { 0xEB, 0xA7, 0xB0 },
	0x90B8, { 0xEB, 0xA7, 0xB1 },
	0x90B9, { 0xEB, 0xA7, 0xB2 },
	0x90BA, { 0xEB, 0xA7, 0xB3 },
	0x90BB, { 0xEB, 0xA7, 0xB6 },
	0x90BC, { 0xEB, 0xA7, 0xBB },
	0x90BD, { 0xEB, 0xA7, 0xBC },
	0x90BE, { 0xEB, 0xA7, 0xBD },
	0x90BF, { 0xEB, 0xA7, 0xBE },
	0x90C0, { 0xEB, 0xA7, 0xBF },
	0x90C1, { 0xEB, 0xA8, 0x82 },
	0x90C2, { 0xEB, 0xA8, 0x83 },
	0x90C3, { 0xEB, 0xA8, 0x84 },
	0x90C4, { 0xEB, 0xA8, 0x85 },
	0x90C5, { 0xEB, 0xA8, 0x86 },
	0x90C6, { 0xEB, 0xA8, 0x87 },
	0x90C7, { 0xEB, 0xA8, 0x89 },
	0x90C8, { 0xEB, 0xA8, 0x8A },
	0x90C9, { 0xEB, 0xA8, 0x8B },
	0x90CA, { 0xEB, 0xA8, 0x8C },
	0x90CB, { 0xEB, 0xA8, 0x8D },
	0x90CC, { 0xEB, 0xA8, 0x8E },
	0x90CD, { 0xEB, 0xA8, 0x8F },
	0x90CE, { 0xEB, 0xA8, 0x90 },
	0x90CF, { 0xEB, 0xA8, 0x91 },
	0x90D0, { 0xEB, 0xA8, 0x92 },
	0x90D1, { 0xEB, 0xA8, 0x93 },
	0x90D2, { 0xEB, 0xA8, 0x94 },
	0x90D3, { 0xEB, 0xA8, 0x96 },
	0x90D4, { 0xEB, 0xA8, 0x97 },
	0x90D5, { 0xEB, 0xA8, 0x98 },
	0x90D6, { 0xEB, 0xA8, 0x99 },
	0x90D7, { 0xEB, 0xA8, 0x9A },
	0x90D8, { 0xEB, 0xA8, 0x9B },
	0x90D9, { 0xEB, 0xA8, 0x9C },
	0x90DA, { 0xEB, 0xA8, 0x9D },
	0x90DB, { 0xEB, 0xA8, 0x9E },
	0x90DC, { 0xEB, 0xA8, 0x9F },
	0x90DD, { 0xEB, 0xA8, 0xA0 },
	0x90DE, { 0xEB, 0xA8, 0xA1 },
	0x90DF, { 0xEB, 0xA8, 0xA2 },
	0x90E0, { 0xEB, 0xA8, 0xA3 },
	0x90E1, { 0xEB, 0xA8, 0xA4 },
	0x90E2, { 0xEB, 0xA8, 0xA5 },
	0x90E3, { 0xEB, 0xA8, 0xA6 },
	0x90E4, { 0xEB, 0xA8, 0xA7 },
	0x90E5, { 0xEB, 0xA8, 0xA8 },
	0x90E6, { 0xEB, 0xA8, 0xA9 },
	0x90E7, { 0xEB, 0xA8, 0xAA },
	0x90E8, { 0xEB, 0xA8, 0xAB },
	0x90E9, { 0xEB, 0xA8, 0xAC },
	0x90EA, { 0xEB, 0xA8, 0xAD },
	0x90EB, { 0xEB, 0xA8, 0xAE },
	0x90EC, { 0xEB, 0xA8, 0xAF },
	0x90ED, { 0xEB, 0xA8, 0xB0 },
	0x90EE, { 0xEB, 0xA8, 0xB1 },
	0x90EF, { 0xEB, 0xA8, 0xB2 },
	0x90F0, { 0xEB, 0xA8, 0xB3 },
	0x90F1, { 0xEB, 0xA8, 0xB4 },
	0x90F2, { 0xEB, 0xA8, 0xB5 },
	0x90F3, { 0xEB, 0xA8, 0xB6 },
	0x90F4, { 0xEB, 0xA8, 0xB7 },
	0x90F5, { 0xEB, 0xA8, 0xBA },
	0x90F6, { 0xEB, 0xA8, 0xBB },
	0x90F7, { 0xEB, 0xA8, 0xBD },
	0x90F8, { 0xEB, 0xA8, 0xBE },
	0x90F9, { 0xEB, 0xA8, 0xBF },
	0x90FA, { 0xEB, 0xA9, 0x81 },
	0x90FB, { 0xEB, 0xA9, 0x83 },
	0x90FC, { 0xEB, 0xA9, 0x84 },
	0x90FD, { 0xEB, 0xA9, 0x85 },
	0x90FE, { 0xEB, 0xA9, 0x86 },
	0x9141, { 0xEB, 0xA9, 0x87 },
	0x9142, { 0xEB, 0xA9, 0x8A },
	0x9143, { 0xEB, 0xA9, 0x8C },
	0x9144, { 0xEB, 0xA9, 0x8F },
	0x9145, { 0xEB, 0xA9, 0x90 },
	0x9146, { 0xEB, 0xA9, 0x91 },
	0x9147, { 0xEB, 0xA9, 0x92 },
	0x9148, { 0xEB, 0xA9, 0x96 },
	0x9149, { 0xEB, 0xA9, 0x97 },
	0x914A, { 0xEB, 0xA9, 0x99 },
	0x914B, { 0xEB, 0xA9, 0x9A },
	0x914C, { 0xEB, 0xA9, 0x9B },
	0x914D, { 0xEB, 0xA9, 0x9D },
	0x914E, { 0xEB, 0xA9, 0x9E },
	0x914F, { 0xEB, 0xA9, 0x9F },
	0x9150, { 0xEB, 0xA9, 0xA0 },
	0x9151, { 0xEB, 0xA9, 0xA1 },
	0x9152, { 0xEB, 0xA9, 0xA2 },
	0x9153, { 0xEB, 0xA9, 0xA3 },
	0x9154, { 0xEB, 0xA9, 0xA6 },
	0x9155, { 0xEB, 0xA9, 0xAA },
	0x9156, { 0xEB, 0xA9, 0xAB },
	0x9157, { 0xEB, 0xA9, 0xAC },
	0x9158, { 0xEB, 0xA9, 0xAD },
	0x9159, { 0xEB, 0xA9, 0xAE },
	0x915A, { 0xEB, 0xA9, 0xAF },
	0x9161, { 0xEB, 0xA9, 0xB2 },
	0x9162, { 0xEB, 0xA9, 0xB3 },
	0x9163, { 0xEB, 0xA9, 0xB5 },
	0x9164, { 0xEB, 0xA9, 0xB6 },
	0x9165, { 0xEB, 0xA9, 0xB7 },
	0x9166, { 0xEB, 0xA9, 0xB9 },
	0x9167, { 0xEB, 0xA9, 0xBA },
	0x9168, { 0xEB, 0xA9, 0xBB },
	0x9169, { 0xEB, 0xA9, 0xBC },
	0x916A, { 0xEB, 0xA9, 0xBD },
	0x916B, { 0xEB, 0xA9, 0xBE },
	0x916C, { 0xEB, 0xA9, 0xBF },
	0x916D, { 0xEB, 0xAA, 0x80 },
	0x916E, { 0xEB, 0xAA, 0x81 },
	0x916F, { 0xEB, 0xAA, 0x82 },
	0x9170, { 0xEB, 0xAA, 0x86 },
	0x9171, { 0xEB, 0xAA, 0x88 },
	0x9172, { 0xEB, 0xAA, 0x89 },
	0x9173, { 0xEB, 0xAA, 0x8A },
	0x9174, { 0xEB, 0xAA, 0x8B },
	0x9175, { 0xEB, 0xAA, 0x8D },
	0x9176, { 0xEB, 0xAA, 0x8E },
	0x9177, { 0xEB, 0xAA, 0x8F },
	0x9178, { 0xEB, 0xAA, 0x90 },
	0x9179, { 0xEB, 0xAA, 0x91 },
	0x917A, { 0xEB, 0xAA, 0x92 },
	0x9181, { 0xEB, 0xAA, 0x93 },
	0x9182, { 0xEB, 0xAA, 0x94 },
	0x9183, { 0xEB, 0xAA, 0x95 },
	0x9184, { 0xEB, 0xAA, 0x96 },
	0x9185, { 0xEB, 0xAA, 0x97 },
	0x9186, { 0xEB, 0xAA, 0x98 },
	0x9187, { 0xEB, 0xAA, 0x99 },
	0x9188, { 0xEB, 0xAA, 0x9A },
	0x9189, { 0xEB, 0xAA, 0x9B },
	0x918A, { 0xEB, 0xAA, 0x9C },
	0x918B, { 0xEB, 0xAA, 0x9D },
	0x918C, { 0xEB, 0xAA, 0x9E },
	0x918D, { 0xEB, 0xAA, 0x9F },
	0x918E, { 0xEB, 0xAA, 0xA0 },
	0x918F, { 0xEB, 0xAA, 0xA1 },
	0x9190, { 0xEB, 0xAA, 0xA2 },
	0x9191, { 0xEB, 0xAA, 0xA3 },
	0x9192, { 0xEB, 0xAA, 0xA4 },
	0x9193, { 0xEB, 0xAA, 0xA5 },
	0x9194, { 0xEB, 0xAA, 0xA6 },
	0x9195, { 0xEB, 0xAA, 0xA7 },
	0x9196, { 0xEB, 0xAA, 0xAA },
	0x9197, { 0xEB, 0xAA, 0xAD },
	0x9198, { 0xEB, 0xAA, 0xAE },
	0x9199, { 0xEB, 0xAA, 0xAF },
	0x919A, { 0xEB, 0xAA, 0xB1 },
	0x919B, { 0xEB, 0xAA, 0xB3 },
	0x919C, { 0xEB, 0xAA, 0xB4 },
	0x919D, { 0xEB, 0xAA, 0xB5 },
	0x919E, { 0xEB, 0xAA, 0xB6 },
	0x919F, { 0xEB, 0xAA, 0xB7 },
	0x91A0, { 0xEB, 0xAA, 0xBA },
	0x91A1, { 0xEB, 0xAA, 0xBC },
	0x91A2, { 0xEB, 0xAA, 0xBE },
	0x91A3, { 0xEB, 0xAA, 0xBF },
	0x91A4, { 0xEB, 0xAB, 0x80 },
	0x91A5, { 0xEB, 0xAB, 0x81 },
	0x91A6, { 0xEB, 0xAB, 0x82 },
	0x91A7, { 0xEB, 0xAB, 0x83 },
	0x91A8, { 0xEB, 0xAB, 0x85 },
	0x91A9, { 0xEB, 0xAB, 0x86 },
	0x91AA, { 0xEB, 0xAB, 0x87 },
	0x91AB, { 0xEB, 0xAB, 0x89 },
	0x91AC, { 0xEB, 0xAB, 0x8A },
	0x91AD, { 0xEB, 0xAB, 0x8B },
	0x91AE, { 0xEB, 0xAB, 0x8C },
	0x91AF, { 0xEB, 0xAB, 0x8D },
	0x91B0, { 0xEB, 0xAB, 0x8E },
	0x91B1, { 0xEB, 0xAB, 0x8F },
	0x91B2, { 0xEB, 0xAB, 0x90 },
	0x91B3, { 0xEB, 0xAB, 0x91 },
	0x91B4, { 0xEB, 0xAB, 0x92 },
	0x91B5, { 0xEB, 0xAB, 0x93 },
	0x91B6, { 0xEB, 0xAB, 0x94 },
	0x91B7, { 0xEB, 0xAB, 0x95 },
	0x91B8, { 0xEB, 0xAB, 0x96 },
	0x91B9, { 0xEB, 0xAB, 0x97 },
	0x91BA, { 0xEB, 0xAB, 0x9A },
	0x91BB, { 0xEB, 0xAB, 0x9B },
	0x91BC, { 0xEB, 0xAB, 0x9C },
	0x91BD, { 0xEB, 0xAB, 0x9D },
	0x91BE, { 0xEB, 0xAB, 0x9E },
	0x91BF, { 0xEB, 0xAB, 0x9F },
	0x91C0, { 0xEB, 0xAB, 0xA0 },
	0x91C1, { 0xEB, 0xAB, 0xA1 },
	0x91C2, { 0xEB, 0xAB, 0xA2 },
	0x91C3, { 0xEB, 0xAB, 0xA3 },
	0x91C4, { 0xEB, 0xAB, 0xA4 },
	0x91C5, { 0xEB, 0xAB, 0xA5 },
	0x91C6, { 0xEB, 0xAB, 0xA6 },
	0x91C7, { 0xEB, 0xAB, 0xA7 },
	0x91C8, { 0xEB, 0xAB, 0xA8 },
	0x91C9, { 0xEB, 0xAB, 0xA9 },
	0x91CA, { 0xEB, 0xAB, 0xAA },
	0x91CB, { 0xEB, 0xAB, 0xAB },
	0x91CC, { 0xEB, 0xAB, 0xAC },
	0x91CD, { 0xEB, 0xAB, 0xAD },
	0x91CE, { 0xEB, 0xAB, 0xAE },
	0x91CF, { 0xEB, 0xAB, 0xAF },
	0x91D0, { 0xEB, 0xAB, 0xB0 },
	0x91D1, { 0xEB, 0xAB, 0xB1 },
	0x91D2, { 0xEB, 0xAB, 0xB2 },
	0x91D3, { 0xEB, 0xAB, 0xB3 },
	0x91D4, { 0xEB, 0xAB, 0xB4 },
	0x91D5, { 0xEB, 0xAB, 0xB5 },
	0x91D6, { 0xEB, 0xAB, 0xB6 },
	0x91D7, { 0xEB, 0xAB, 0xB7 },
	0x91D8, { 0xEB, 0xAB, 0xB8 },
	0x91D9, { 0xEB, 0xAB, 0xB9 },
	0x91DA, { 0xEB, 0xAB, 0xBA },
	0x91DB, { 0xEB, 0xAB, 0xBB },
	0x91DC, { 0xEB, 0xAB, 0xBD },
	0x91DD, { 0xEB, 0xAB, 0xBE },
	0x91DE, { 0xEB, 0xAB, 0xBF },
	0x91DF, { 0xEB, 0xAC, 0x81 },
	0x91E0, { 0xEB, 0xAC, 0x82 },
	0x91E1, { 0xEB, 0xAC, 0x83 },
	0x91E2, { 0xEB, 0xAC, 0x85 },
	0x91E3, { 0xEB, 0xAC, 0x86 },
	0x91E4, { 0xEB, 0xAC, 0x87 },
	0x91E5, { 0xEB, 0xAC, 0x88 },
	0x91E6, { 0xEB, 0xAC, 0x89 },
	0x91E7, { 0xEB, 0xAC, 0x8A },
	0x91E8, { 0xEB, 0xAC, 0x8B },
	0x91E9, { 0xEB, 0xAC, 0x8C },
	0x91EA, { 0xEB, 0xAC, 0x8E },
	0x91EB, { 0xEB, 0xAC, 0x90 },
	0x91EC, { 0xEB, 0xAC, 0x92 },
	0x91ED, { 0xEB, 0xAC, 0x93 },
	0x91EE, { 0xEB, 0xAC, 0x94 },
	0x91EF, { 0xEB, 0xAC, 0x95 },
	0x91F0, { 0xEB, 0xAC, 0x96 },
	0x91F1, { 0xEB, 0xAC, 0x97 },
	0x91F2, { 0xEB, 0xAC, 0x99 },
	0x91F3, { 0xEB, 0xAC, 0x9A },
	0x91F4, { 0xEB, 0xAC, 0x9B },
	0x91F5, { 0xEB, 0xAC, 0x9D },
	0x91F6, { 0xEB, 0xAC, 0x9E },
	0x91F7, { 0xEB, 0xAC, 0x9F },
	0x91F8, { 0xEB, 0xAC, 0xA1 },
	0x91F9, { 0xEB, 0xAC, 0xA2 },
	0x91FA, { 0xEB, 0xAC, 0xA3 },
	0x91FB, { 0xEB, 0xAC, 0xA4 },
	0x91FC, { 0xEB, 0xAC, 0xA5 },
	0x91FD, { 0xEB, 0xAC, 0xA6 },
	0x91FE, { 0xEB, 0xAC, 0xA7 },
	0x9241, { 0xEB, 0xAC, 0xA8 },
	0x9242, { 0xEB, 0xAC, 0xAA },
	0x9243, { 0xEB, 0xAC, 0xAC },
	0x9244, { 0xEB, 0xAC, 0xAD },
	0x9245, { 0xEB, 0xAC, 0xAE },
	0x9246, { 0xEB, 0xAC, 0xAF },
	0x9247, { 0xEB, 0xAC, 0xB0 },
	0x9248, { 0xEB, 0xAC, 0xB1 },
	0x9249, { 0xEB, 0xAC, 0xB2 },
	0x924A, { 0xEB, 0xAC, 0xB3 },
	0x924B, { 0xEB, 0xAC, 0xB7 },
	0x924C, { 0xEB, 0xAC, 0xB9 },
	0x924D, { 0xEB, 0xAC, 0xBA },
	0x924E, { 0xEB, 0xAC, 0xBF },
	0x924F, { 0xEB, 0xAD, 0x80 },
	0x9250, { 0xEB, 0xAD, 0x81 },
	0x9251, { 0xEB, 0xAD, 0x82 },
	0x9252, { 0xEB, 0xAD, 0x83 },
	0x9253, { 0xEB, 0xAD, 0x86 },
	0x9254, { 0xEB, 0xAD, 0x88 },
	0x9255, { 0xEB, 0xAD, 0x8A },
	0x9256, { 0xEB, 0xAD, 0x8B },
	0x9257, { 0xEB, 0xAD, 0x8C },
	0x9258, { 0xEB, 0xAD, 0x8E },
	0x9259, { 0xEB, 0xAD, 0x91 },
	0x925A, { 0xEB, 0xAD, 0x92 },
	0x9261, { 0xEB, 0xAD, 0x93 },
	0x9262, { 0xEB, 0xAD, 0x95 },
	0x9263, { 0xEB, 0xAD, 0x96 },
	0x9264, { 0xEB, 0xAD, 0x97 },
	0x9265, { 0xEB, 0xAD, 0x99 },
	0x9266, { 0xEB, 0xAD, 0x9A },
	0x9267, { 0xEB, 0xAD, 0x9B },
	0x9268, { 0xEB, 0xAD, 0x9C },
	0x9269, { 0xEB, 0xAD, 0x9D },
	0x926A, { 0xEB, 0xAD, 0x9E },
	0x926B, { 0xEB, 0xAD, 0x9F },
	0x926C, { 0xEB, 0xAD, 0xA0 },
	0x926D, { 0xEB, 0xAD, 0xA2 },
	0x926E, { 0xEB, 0xAD, 0xA4 },
	0x926F, { 0xEB, 0xAD, 0xA5 },
	0x9270, { 0xEB, 0xAD, 0xA6 },
	0x9271, { 0xEB, 0xAD, 0xA7 },
	0x9272, { 0xEB, 0xAD, 0xA8 },
	0x9273, { 0xEB, 0xAD, 0xA9 },
	0x9274, { 0xEB, 0xAD, 0xAA },
	0x9275, { 0xEB, 0xAD, 0xAB },
	0x9276, { 0xEB, 0xAD, 0xAD },
	0x9277, { 0xEB, 0xAD, 0xAE },
	0x9278, { 0xEB, 0xAD, 0xAF },
	0x9279, { 0xEB, 0xAD, 0xB0 },
	0x927A, { 0xEB, 0xAD, 0xB1 },
	0x9281, { 0xEB, 0xAD, 0xB2 },
	0x9282, { 0xEB, 0xAD, 0xB3 },
	0x9283, { 0xEB, 0xAD, 0xB4 },
	0x9284, { 0xEB, 0xAD, 0xB5 },
	0x9285, { 0xEB, 0xAD, 0xB6 },
	0x9286, { 0xEB, 0xAD, 0xB7 },
	0x9287, { 0xEB, 0xAD, 0xB8 },
	0x9288, { 0xEB, 0xAD, 0xB9 },
	0x9289, { 0xEB, 0xAD, 0xBA },
	0x928A, { 0xEB, 0xAD, 0xBB },
	0x928B, { 0xEB, 0xAD, 0xBC },
	0x928C, { 0xEB, 0xAD, 0xBD },
	0x928D, { 0xEB, 0xAD, 0xBE },
	0x928E, { 0xEB, 0xAD, 0xBF },
	0x928F, { 0xEB, 0xAE, 0x80 },
	0x9290, { 0xEB, 0xAE, 0x81 },
	0x9291, { 0xEB, 0xAE, 0x82 },
	0x9292, { 0xEB, 0xAE, 0x83 },
	0x9293, { 0xEB, 0xAE, 0x84 },
	0x9294, { 0xEB, 0xAE, 0x85 },
	0x9295, { 0xEB, 0xAE, 0x86 },
	0x9296, { 0xEB, 0xAE, 0x87 },
	0x9297, { 0xEB, 0xAE, 0x89 },
	0x9298, { 0xEB, 0xAE, 0x8A },
	0x9299, { 0xEB, 0xAE, 0x8B },
	0x929A, { 0xEB, 0xAE, 0x8D },
	0x929B, { 0xEB, 0xAE, 0x8E },
	0x929C, { 0xEB, 0xAE, 0x8F },
	0x929D, { 0xEB, 0xAE, 0x91 },
	0x929E, { 0xEB, 0xAE, 0x92 },
	0x929F, { 0xEB, 0xAE, 0x93 },
	0x92A0, { 0xEB, 0xAE, 0x94 },
	0x92A1, { 0xEB, 0xAE, 0x95 },
	0x92A2, { 0xEB, 0xAE, 0x96 },
	0x92A3, { 0xEB, 0xAE, 0x97 },
	0x92A4, { 0xEB, 0xAE, 0x98 },
	0x92A5, { 0xEB, 0xAE, 0x99 },
	0x92A6, { 0xEB, 0xAE, 0x9A },
	0x92A7, { 0xEB, 0xAE, 0x9B },
	0x92A8, { 0xEB, 0xAE, 0x9C },
	0x92A9, { 0xEB, 0xAE, 0x9D },
	0x92AA, { 0xEB, 0xAE, 0x9E },
	0x92AB, { 0xEB, 0xAE, 0x9F },
	0x92AC, { 0xEB, 0xAE, 0xA0 },
	0x92AD, { 0xEB, 0xAE, 0xA1 },
	0x92AE, { 0xEB, 0xAE, 0xA2 },
	0x92AF, { 0xEB, 0xAE, 0xA3 },
	0x92B0, { 0xEB, 0xAE, 0xA5 },
	0x92B1, { 0xEB, 0xAE, 0xA6 },
	0x92B2, { 0xEB, 0xAE, 0xA7 },
	0x92B3, { 0xEB, 0xAE, 0xA9 },
	0x92B4, { 0xEB, 0xAE, 0xAA },
	0x92B5, { 0xEB, 0xAE, 0xAB },
	0x92B6, { 0xEB, 0xAE, 0xAD },
	0x92B7, { 0xEB, 0xAE, 0xAE },
	0x92B8, { 0xEB, 0xAE, 0xAF },
	0x92B9, { 0xEB, 0xAE, 0xB0 },
	0x92BA, { 0xEB, 0xAE, 0xB1 },
	0x92BB, { 0xEB, 0xAE, 0xB2 },
	0x92BC, { 0xEB, 0xAE, 0xB3 },
	0x92BD, { 0xEB, 0xAE, 0xB5 },
	0x92BE, { 0xEB, 0xAE, 0xB6 },
	0x92BF, { 0xEB, 0xAE, 0xB8 },
	0x92C0, { 0xEB, 0xAE, 0xB9 },
	0x92C1, { 0xEB, 0xAE, 0xBA },
	0x92C2, { 0xEB, 0xAE, 0xBB },
	0x92C3, { 0xEB, 0xAE, 0xBC },
	0x92C4, { 0xEB, 0xAE, 0xBD },
	0x92C5, { 0xEB, 0xAE, 0xBE },
	0x92C6, { 0xEB, 0xAE, 0xBF },
	0x92C7, { 0xEB, 0xAF, 0x81 },
	0x92C8, { 0xEB, 0xAF, 0x82 },
	0x92C9, { 0xEB, 0xAF, 0x83 },
	0x92CA, { 0xEB, 0xAF, 0x85 },
	0x92CB, { 0xEB, 0xAF, 0x86 },
	0x92CC, { 0xEB, 0xAF, 0x87 },
	0x92CD, { 0xEB, 0xAF, 0x89 },
	0x92CE, { 0xEB, 0xAF, 0x8A },
	0x92CF, { 0xEB, 0xAF, 0x8B },
	0x92D0, { 0xEB, 0xAF, 0x8C },
	0x92D1, { 0xEB, 0xAF, 0x8D },
	0x92D2, { 0xEB, 0xAF, 0x8E },
	0x92D3, { 0xEB, 0xAF, 0x8F },
	0x92D4, { 0xEB, 0xAF, 0x91 },
	0x92D5, { 0xEB, 0xAF, 0x92 },
	0x92D6, { 0xEB, 0xAF, 0x94 },
	0x92D7, { 0xEB, 0xAF, 0x95 },
	0x92D8, { 0xEB, 0xAF, 0x96 },
	0x92D9, { 0xEB, 0xAF, 0x97 },
	0x92DA, { 0xEB, 0xAF, 0x98 },
	0x92DB, { 0xEB, 0xAF, 0x99 },
	0x92DC, { 0xEB, 0xAF, 0x9A },
	0x92DD, { 0xEB, 0xAF, 0x9B },
	0x92DE, { 0xEB, 0xAF, 0x9C },
	0x92DF, { 0xEB, 0xAF, 0x9D },
	0x92E0, { 0xEB, 0xAF, 0x9E },
	0x92E1, { 0xEB, 0xAF, 0x9F },
	0x92E2, { 0xEB, 0xAF, 0xA0 },
	0x92E3, { 0xEB, 0xAF, 0xA1 },
	0x92E4, { 0xEB, 0xAF, 0xA2 },
	0x92E5, { 0xEB, 0xAF, 0xA3 },
	0x92E6, { 0xEB, 0xAF, 0xA4 },
	0x92E7, { 0xEB, 0xAF, 0xA5 },
	0x92E8, { 0xEB, 0xAF, 0xA6 },
	0x92E9, { 0xEB, 0xAF, 0xA7 },
	0x92EA, { 0xEB, 0xAF, 0xA8 },
	0x92EB, { 0xEB, 0xAF, 0xA9 },
	0x92EC, { 0xEB, 0xAF, 0xAA },
	0x92ED, { 0xEB, 0xAF, 0xAB },
	0x92EE, { 0xEB, 0xAF, 0xAC },
	0x92EF, { 0xEB, 0xAF, 0xAD },
	0x92F0, { 0xEB, 0xAF, 0xAE },
	0x92F1, { 0xEB, 0xAF, 0xAF },
	0x92F2, { 0xEB, 0xAF, 0xB0 },
	0x92F3, { 0xEB, 0xAF, 0xB1 },
	0x92F4, { 0xEB, 0xAF, 0xB2 },
	0x92F5, { 0xEB, 0xAF, 0xB3 },
	0x92F6, { 0xEB, 0xAF, 0xB4 },
	0x92F7, { 0xEB, 0xAF, 0xB5 },
	0x92F8, { 0xEB, 0xAF, 0xB6 },
	0x92F9, { 0xEB, 0xAF, 0xB7 },
	0x92FA, { 0xEB, 0xAF, 0xBA },
	0x92FB, { 0xEB, 0xAF, 0xBB },
	0x92FC, { 0xEB, 0xAF, 0xBD },
	0x92FD, { 0xEB, 0xAF, 0xBE },
	0x92FE, { 0xEB, 0xB0, 0x81 },
	0x9341, { 0xEB, 0xB0, 0x83 },
	0x9342, { 0xEB, 0xB0, 0x84 },
	0x9343, { 0xEB, 0xB0, 0x85 },
	0x9344, { 0xEB, 0xB0, 0x86 },
	0x9345, { 0xEB, 0xB0, 0x87 },
	0x9346, { 0xEB, 0xB0, 0x8A },
	0x9347, { 0xEB, 0xB0, 0x8E },
	0x9348, { 0xEB, 0xB0, 0x90 },
	0x9349, { 0xEB, 0xB0, 0x92 },
	0x934A, { 0xEB, 0xB0, 0x93 },
	0x934B, { 0xEB, 0xB0, 0x99 },
	0x934C, { 0xEB, 0xB0, 0x9A },
	0x934D, { 0xEB, 0xB0, 0xA0 },
	0x934E, { 0xEB, 0xB0, 0xA1 },
	0x934F, { 0xEB, 0xB0, 0xA2 },
	0x9350, { 0xEB, 0xB0, 0xA3 },
	0x9351, { 0xEB, 0xB0, 0xA6 },
	0x9352, { 0xEB, 0xB0, 0xA8 },
	0x9353, { 0xEB, 0xB0, 0xAA },
	0x9354, { 0xEB, 0xB0, 0xAB },
	0x9355, { 0xEB, 0xB0, 0xAC },
	0x9356, { 0xEB, 0xB0, 0xAE },
	0x9357, { 0xEB, 0xB0, 0xAF },
	0x9358, { 0xEB, 0xB0, 0xB2 },
	0x9359, { 0xEB, 0xB0, 0xB3 },
	0x935A, { 0xEB, 0xB0, 0xB5 },
	0x9361, { 0xEB, 0xB0, 0xB6 },
	0x9362, { 0xEB, 0xB0, 0xB7 },
	0x9363, { 0xEB, 0xB0, 0xB9 },
	0x9364, { 0xEB, 0xB0, 0xBA },
	0x9365, { 0xEB, 0xB0, 0xBB },
	0x9366, { 0xEB, 0xB0, 0xBC },
	0x9367, { 0xEB, 0xB0, 0xBD },
	0x9368, { 0xEB, 0xB0, 0xBE },
	0x9369, { 0xEB, 0xB0, 0xBF },
	0x936A, { 0xEB, 0xB1, 0x82 },
	0x936B, { 0xEB, 0xB1, 0x86 },
	0x936C, { 0xEB, 0xB1, 0x87 },
	0x936D, { 0xEB, 0xB1, 0x88 },
	0x936E, { 0xEB, 0xB1, 0x8A },
	0x936F, { 0xEB, 0xB1, 0x8B },
	0x9370, { 0xEB, 0xB1, 0x8E },
	0x9371, { 0xEB, 0xB1, 0x8F },
	0x9372, { 0xEB, 0xB1, 0x91 },
	0x9373, { 0xEB, 0xB1, 0x92 },
	0x9374, { 0xEB, 0xB1, 0x93 },
	0x9375, { 0xEB, 0xB1, 0x94 },
	0x9376, { 0xEB, 0xB1, 0x95 },
	0x9377, { 0xEB, 0xB1, 0x96 },
	0x9378, { 0xEB, 0xB1, 0x97 },
	0x9379, { 0xEB, 0xB1, 0x98 },
	0x937A, { 0xEB, 0xB1, 0x99 },
	0x9381, { 0xEB, 0xB1, 0x9A },
	0x9382, { 0xEB, 0xB1, 0x9B },
	0x9383, { 0xEB, 0xB1, 0x9C },
	0x9384, { 0xEB, 0xB1, 0x9E },
	0x9385, { 0xEB, 0xB1, 0x9F },
	0x9386, { 0xEB, 0xB1, 0xA0 },
	0x9387, { 0xEB, 0xB1, 0xA1 },
	0x9388, { 0xEB, 0xB1, 0xA2 },
	0x9389, { 0xEB, 0xB1, 0xA3 },
	0x938A, { 0xEB, 0xB1, 0xA4 },
	0x938B, { 0xEB, 0xB1, 0xA5 },
	0x938C, { 0xEB, 0xB1, 0xA6 },
	0x938D, { 0xEB, 0xB1, 0xA7 },
	0x938E, { 0xEB, 0xB1, 0xA8 },
	0x938F, { 0xEB, 0xB1, 0xA9 },
	0x9390, { 0xEB, 0xB1, 0xAA },
	0x9391, { 0xEB, 0xB1, 0xAB },
	0x9392, { 0xEB, 0xB1, 0xAC },
	0x9393, { 0xEB, 0xB1, 0xAD },
	0x9394, { 0xEB, 0xB1, 0xAE },
	0x9395, { 0xEB, 0xB1, 0xAF },
	0x9396, { 0xEB, 0xB1, 0xB0 },
	0x9397, { 0xEB, 0xB1, 0xB1 },
	0x9398, { 0xEB, 0xB1, 0xB2 },
	0x9399, { 0xEB, 0xB1, 0xB3 },
	0x939A, { 0xEB, 0xB1, 0xB4 },
	0x939B, { 0xEB, 0xB1, 0xB5 },
	0x939C, { 0xEB, 0xB1, 0xB6 },
	0x939D, { 0xEB, 0xB1, 0xB7 },
	0x939E, { 0xEB, 0xB1, 0xB8 },
	0x939F, { 0xEB, 0xB1, 0xB9 },
	0x93A0, { 0xEB, 0xB1, 0xBA },
	0x93A1, { 0xEB, 0xB1, 0xBB },
	0x93A2, { 0xEB, 0xB1, 0xBC },
	0x93A3, { 0xEB, 0xB1, 0xBD },
	0x93A4, { 0xEB, 0xB1, 0xBE },
	0x93A5, { 0xEB, 0xB1, 0xBF },
	0x93A6, { 0xEB, 0xB2, 0x80 },
	0x93A7, { 0xEB, 0xB2, 0x81 },
	0x93A8, { 0xEB, 0xB2, 0x82 },
	0x93A9, { 0xEB, 0xB2, 0x83 },
	0x93AA, { 0xEB, 0xB2, 0x86 },
	0x93AB, { 0xEB, 0xB2, 0x87 },
	0x93AC, { 0xEB, 0xB2, 0x89 },
	0x93AD, { 0xEB, 0xB2, 0x8A },
	0x93AE, { 0xEB, 0xB2, 0x8D },
	0x93AF, { 0xEB, 0xB2, 0x8F },
	0x93B0, { 0xEB, 0xB2, 0x90 },
	0x93B1, { 0xEB, 0xB2, 0x91 },
	0x93B2, { 0xEB, 0xB2, 0x92 },
	0x93B3, { 0xEB, 0xB2, 0x93 },
	0x93B4, { 0xEB, 0xB2, 0x96 },
	0x93B5, { 0xEB, 0xB2, 0x98 },
	0x93B6, { 0xEB, 0xB2, 0x9B },
	0x93B7, { 0xEB, 0xB2, 0x9C },
	0x93B8, { 0xEB, 0xB2, 0x9D },
	0x93B9, { 0xEB, 0xB2, 0x9E },
	0x93BA, { 0xEB, 0xB2, 0x9F },
	0x93BB, { 0xEB, 0xB2, 0xA2 },
	0x93BC, { 0xEB, 0xB2, 0xA3 },
	0x93BD, { 0xEB, 0xB2, 0xA5 },
	0x93BE, { 0xEB, 0xB2, 0xA6 },
	0x93BF, { 0xEB, 0xB2, 0xA9 },
	0x93C0, { 0xEB, 0xB2, 0xAA },
	0x93C1, { 0xEB, 0xB2, 0xAB },
	0x93C2, { 0xEB, 0xB2, 0xAC },
	0x93C3, { 0xEB, 0xB2, 0xAD },
	0x93C4, { 0xEB, 0xB2, 0xAE },
	0x93C5, { 0xEB, 0xB2, 0xAF },
	0x93C6, { 0xEB, 0xB2, 0xB2 },
	0x93C7, { 0xEB, 0xB2, 0xB6 },
	0x93C8, { 0xEB, 0xB2, 0xB7 },
	0x93C9, { 0xEB, 0xB2, 0xB8 },
	0x93CA, { 0xEB, 0xB2, 0xB9 },
	0x93CB, { 0xEB, 0xB2, 0xBA },
	0x93CC, { 0xEB, 0xB2, 0xBB },
	0x93CD, { 0xEB, 0xB2, 0xBE },
	0x93CE, { 0xEB, 0xB2, 0xBF },
	0x93CF, { 0xEB, 0xB3, 0x81 },
	0x93D0, { 0xEB, 0xB3, 0x82 },
	0x93D1, { 0xEB, 0xB3, 0x83 },
	0x93D2, { 0xEB, 0xB3, 0x85 },
	0x93D3, { 0xEB, 0xB3, 0x86 },
	0x93D4, { 0xEB, 0xB3, 0x87 },
	0x93D5, { 0xEB, 0xB3, 0x88 },
	0x93D6, { 0xEB, 0xB3, 0x89 },
	0x93D7, { 0xEB, 0xB3, 0x8A },
	0x93D8, { 0xEB, 0xB3, 0x8B },
	0x93D9, { 0xEB, 0xB3, 0x8C },
	0x93DA, { 0xEB, 0xB3, 0x8E },
	0x93DB, { 0xEB, 0xB3, 0x92 },
	0x93DC, { 0xEB, 0xB3, 0x93 },
	0x93DD, { 0xEB, 0xB3, 0x94 },
	0x93DE, { 0xEB, 0xB3, 0x96 },
	0x93DF, { 0xEB, 0xB3, 0x97 },
	0x93E0, { 0xEB, 0xB3, 0x99 },
	0x93E1, { 0xEB, 0xB3, 0x9A },
	0x93E2, { 0xEB, 0xB3, 0x9B },
	0x93E3, { 0xEB, 0xB3, 0x9D },
	0x93E4, { 0xEB, 0xB3, 0x9E },
	0x93E5, { 0xEB, 0xB3, 0x9F },
	0x93E6, { 0xEB, 0xB3, 0xA0 },
	0x93E7, { 0xEB, 0xB3, 0xA1 },
	0x93E8, { 0xEB, 0xB3, 0xA2 },
	0x93E9, { 0xEB, 0xB3, 0xA3 },
	0x93EA, { 0xEB, 0xB3, 0xA4 },
	0x93EB, { 0xEB, 0xB3, 0xA5 },
	0x93EC, { 0xEB, 0xB3, 0xA6 },
	0x93ED, { 0xEB, 0xB3, 0xA7 },
	0x93EE, { 0xEB, 0xB3, 0xA8 },
	0x93EF, { 0xEB, 0xB3, 0xA9 },
	0x93F0, { 0xEB, 0xB3, 0xAA },
	0x93F1, { 0xEB, 0xB3, 0xAB },
	0x93F2, { 0xEB, 0xB3, 0xAC },
	0x93F3, { 0xEB, 0xB3, 0xAD },
	0x93F4, { 0xEB, 0xB3, 0xAE },
	0x93F5, { 0xEB, 0xB3, 0xAF },
	0x93F6, { 0xEB, 0xB3, 0xB0 },
	0x93F7, { 0xEB, 0xB3, 0xB1 },
	0x93F8, { 0xEB, 0xB3, 0xB2 },
	0x93F9, { 0xEB, 0xB3, 0xB3 },
	0x93FA, { 0xEB, 0xB3, 0xB7 },
	0x93FB, { 0xEB, 0xB3, 0xB9 },
	0x93FC, { 0xEB, 0xB3, 0xBA },
	0x93FD, { 0xEB, 0xB3, 0xBB },
	0x93FE, { 0xEB, 0xB3, 0xBD },
	0x9441, { 0xEB, 0xB3, 0xBE },
	0x9442, { 0xEB, 0xB3, 0xBF },
	0x9443, { 0xEB, 0xB4, 0x80 },
	0x9444, { 0xEB, 0xB4, 0x81 },
	0x9445, { 0xEB, 0xB4, 0x82 },
	0x9446, { 0xEB, 0xB4, 0x83 },
	0x9447, { 0xEB, 0xB4, 0x86 },
	0x9448, { 0xEB, 0xB4, 0x88 },
	0x9449, { 0xEB, 0xB4, 0x8A },
	0x944A, { 0xEB, 0xB4, 0x8B },
	0x944B, { 0xEB, 0xB4, 0x8C },
	0x944C, { 0xEB, 0xB4, 0x8D },
	0x944D, { 0xEB, 0xB4, 0x8E },
	0x944E, { 0xEB, 0xB4, 0x8F },
	0x944F, { 0xEB, 0xB4, 0x91 },
	0x9450, { 0xEB, 0xB4, 0x92 },
	0x9451, { 0xEB, 0xB4, 0x93 },
	0x9452, { 0xEB, 0xB4, 0x95 },
	0x9453, { 0xEB, 0xB4, 0x96 },
	0x9454, { 0xEB, 0xB4, 0x97 },
	0x9455, { 0xEB, 0xB4, 0x98 },
	0x9456, { 0xEB, 0xB4, 0x99 },
	0x9457, { 0xEB, 0xB4, 0x9A },
	0x9458, { 0xEB, 0xB4, 0x9B },
	0x9459, { 0xEB, 0xB4, 0x9C },
	0x945A, { 0xEB, 0xB4, 0x9D },
	0x9461, { 0xEB, 0xB4, 0x9E },
	0x9462, { 0xEB, 0xB4, 0x9F },
	0x9463, { 0xEB, 0xB4, 0xA0 },
	0x9464, { 0xEB, 0xB4, 0xA1 },
	0x9465, { 0xEB, 0xB4, 0xA2 },
	0x9466, { 0xEB, 0xB4, 0xA3 },
	0x9467, { 0xEB, 0xB4, 0xA5 },
	0x9468, { 0xEB, 0xB4, 0xA6 },
	0x9469, { 0xEB, 0xB4, 0xA7 },
	0x946A, { 0xEB, 0xB4, 0xA8 },
	0x946B, { 0xEB, 0xB4, 0xA9 },
	0x946C, { 0xEB, 0xB4, 0xAA },
	0x946D, { 0xEB, 0xB4, 0xAB },
	0x946E, { 0xEB, 0xB4, 0xAD },
	0x946F, { 0xEB, 0xB4, 0xAE },
	0x9470, { 0xEB, 0xB4, 0xAF },
	0x9471, { 0xEB, 0xB4, 0xB0 },
	0x9472, { 0xEB, 0xB4, 0xB1 },
	0x9473, { 0xEB, 0xB4, 0xB2 },
	0x9474, { 0xEB, 0xB4, 0xB3 },
	0x9475, { 0xEB, 0xB4, 0xB4 },
	0x9476, { 0xEB, 0xB4, 0xB5 },
	0x9477, { 0xEB, 0xB4, 0xB6 },
	0x9478, { 0xEB, 0xB4, 0xB7 },
	0x9479, { 0xEB, 0xB4, 0xB8 },
	0x947A, { 0xEB, 0xB4, 0xB9 },
	0x9481, { 0xEB, 0xB4, 0xBA },
	0x9482, { 0xEB, 0xB4, 0xBB },
	0x9483, { 0xEB, 0xB4, 0xBC },
	0x9484, { 0xEB, 0xB4, 0xBD },
	0x9485, { 0xEB, 0xB4, 0xBE },
	0x9486, { 0xEB, 0xB4, 0xBF },
	0x9487, { 0xEB, 0xB5, 0x81 },
	0x9488, { 0xEB, 0xB5, 0x82 },
	0x9489, { 0xEB, 0xB5, 0x83 },
	0x948A, { 0xEB, 0xB5, 0x84 },
	0x948B, { 0xEB, 0xB5, 0x85 },
	0x948C, { 0xEB, 0xB5, 0x86 },
	0x948D, { 0xEB, 0xB5, 0x87 },
	0x948E, { 0xEB, 0xB5, 0x8A },
	0x948F, { 0xEB, 0xB5, 0x8B },
	0x9490, { 0xEB, 0xB5, 0x8D },
	0x9491, { 0xEB, 0xB5, 0x8E },
	0x9492, { 0xEB, 0xB5, 0x8F },
	0x9493, { 0xEB, 0xB5, 0x91 },
	0x9494, { 0xEB, 0xB5, 0x92 },
	0x9495, { 0xEB, 0xB5, 0x93 },
	0x9496, { 0xEB, 0xB5, 0x94 },
	0x9497, { 0xEB, 0xB5, 0x95 },
	0x9498, { 0xEB, 0xB5, 0x96 },
	0x9499, { 0xEB, 0xB5, 0x97 },
	0x949A, { 0xEB, 0xB5, 0x9A },
	0x949B, { 0xEB, 0xB5, 0x9B },
	0x949C, { 0xEB, 0xB5, 0x9C },
	0x949D, { 0xEB, 0xB5, 0x9D },
	0x949E, { 0xEB, 0xB5, 0x9E },
	0x949F, { 0xEB, 0xB5, 0x9F },
	0x94A0, { 0xEB, 0xB5, 0xA0 },
	0x94A1, { 0xEB, 0xB5, 0xA1 },
	0x94A2, { 0xEB, 0xB5, 0xA2 },
	0x94A3, { 0xEB, 0xB5, 0xA3 },
	0x94A4, { 0xEB, 0xB5, 0xA5 },
	0x94A5, { 0xEB, 0xB5, 0xA6 },
	0x94A6, { 0xEB, 0xB5, 0xA7 },
	0x94A7, { 0xEB, 0xB5, 0xA9 },
	0x94A8, { 0xEB, 0xB5, 0xAA },
	0x94A9, { 0xEB, 0xB5, 0xAB },
	0x94AA, { 0xEB, 0xB5, 0xAC },
	0x94AB, { 0xEB, 0xB5, 0xAD },
	0x94AC, { 0xEB, 0xB5, 0xAE },
	0x94AD, { 0xEB, 0xB5, 0xAF },
	0x94AE, { 0xEB, 0xB5, 0xB0 },
	0x94AF, { 0xEB, 0xB5, 0xB1 },
	0x94B0, { 0xEB, 0xB5, 0xB2 },
	0x94B1, { 0xEB, 0xB5, 0xB3 },
	0x94B2, { 0xEB, 0xB5, 0xB4 },
	0x94B3, { 0xEB, 0xB5, 0xB5 },
	0x94B4, { 0xEB, 0xB5, 0xB6 },
	0x94B5, { 0xEB, 0xB5, 0xB7 },
	0x94B6, { 0xEB, 0xB5, 0xB8 },
	0x94B7, { 0xEB, 0xB5, 0xB9 },
	0x94B8, { 0xEB, 0xB5, 0xBA },
	0x94B9, { 0xEB, 0xB5, 0xBB },
	0x94BA, { 0xEB, 0xB5, 0xBC },
	0x94BB, { 0xEB, 0xB5, 0xBD },
	0x94BC, { 0xEB, 0xB5, 0xBE },
	0x94BD, { 0xEB, 0xB5, 0xBF },
	0x94BE, { 0xEB, 0xB6, 0x82 },
	0x94BF, { 0xEB, 0xB6, 0x83 },
	0x94C0, { 0xEB, 0xB6, 0x85 },
	0x94C1, { 0xEB, 0xB6, 0x86 },
	0x94C2, { 0xEB, 0xB6, 0x8B },
	0x94C3, { 0xEB, 0xB6, 0x8C },
	0x94C4, { 0xEB, 0xB6, 0x8D },
	0x94C5, { 0xEB, 0xB6, 0x8E },
	0x94C6, { 0xEB, 0xB6, 0x8F },
	0x94C7, { 0xEB, 0xB6, 0x92 },
	0x94C8, { 0xEB, 0xB6, 0x94 },
	0x94C9, { 0xEB, 0xB6, 0x96 },
	0x94CA, { 0xEB, 0xB6, 0x97 },
	0x94CB, { 0xEB, 0xB6, 0x98 },
	0x94CC, { 0xEB, 0xB6, 0x9B },
	0x94CD, { 0xEB, 0xB6, 0x9D },
	0x94CE, { 0xEB, 0xB6, 0x9E },
	0x94CF, { 0xEB, 0xB6, 0x9F },
	0x94D0, { 0xEB, 0xB6, 0xA0 },
	0x94D1, { 0xEB, 0xB6, 0xA1 },
	0x94D2, { 0xEB, 0xB6, 0xA2 },
	0x94D3, { 0xEB, 0xB6, 0xA3 },
	0x94D4, { 0xEB, 0xB6, 0xA5 },
	0x94D5, { 0xEB, 0xB6, 0xA6 },
	0x94D6, { 0xEB, 0xB6, 0xA7 },
	0x94D7, { 0xEB, 0xB6, 0xA8 },
	0x94D8, { 0xEB, 0xB6, 0xA9 },
	0x94D9, { 0xEB, 0xB6, 0xAA },
	0x94DA, { 0xEB, 0xB6, 0xAB },
	0x94DB, { 0xEB, 0xB6, 0xAC },
	0x94DC, { 0xEB, 0xB6, 0xAD },
	0x94DD, { 0xEB, 0xB6, 0xAE },
	0x94DE, { 0xEB, 0xB6, 0xAF },
	0x94DF, { 0xEB, 0xB6, 0xB1 },
	0x94E0, { 0xEB, 0xB6, 0xB2 },
	0x94E1, { 0xEB, 0xB6, 0xB3 },
	0x94E2, { 0xEB, 0xB6, 0xB4 },
	0x94E3, { 0xEB, 0xB6, 0xB5 },
	0x94E4, { 0xEB, 0xB6, 0xB6 },
	0x94E5, { 0xEB, 0xB6, 0xB7 },
	0x94E6, { 0xEB, 0xB6, 0xB9 },
	0x94E7, { 0xEB, 0xB6, 0xBA },
	0x94E8, { 0xEB, 0xB6, 0xBB },
	0x94E9, { 0xEB, 0xB6, 0xBC },
	0x94EA, { 0xEB, 0xB6, 0xBD },
	0x94EB, { 0xEB, 0xB6, 0xBE },
	0x94EC, { 0xEB, 0xB6, 0xBF },
	0x94ED, { 0xEB, 0xB7, 0x80 },
	0x94EE, { 0xEB, 0xB7, 0x81 },
	0x94EF, { 0xEB, 0xB7, 0x82 },
	0x94F0, { 0xEB, 0xB7, 0x83 },
	0x94F1, { 0xEB, 0xB7, 0x84 },
	0x94F2, { 0xEB, 0xB7, 0x85 },
	0x94F3, { 0xEB, 0xB7, 0x86 },
	0x94F4, { 0xEB, 0xB7, 0x87 },
	0x94F5, { 0xEB, 0xB7, 0x88 },
	0x94F6, { 0xEB, 0xB7, 0x89 },
	0x94F7, { 0xEB, 0xB7, 0x8A },
	0x94F8, { 0xEB, 0xB7, 0x8B },
	0x94F9, { 0xEB, 0xB7, 0x8C },
	0x94FA, { 0xEB, 0xB7, 0x8D },
	0x94FB, { 0xEB, 0xB7, 0x8E },
	0x94FC, { 0xEB, 0xB7, 0x8F },
	0x94FD, { 0xEB, 0xB7, 0x90 },
	0x94FE, { 0xEB, 0xB7, 0x91 },
	0x9541, { 0xEB, 0xB7, 0x92 },
	0x9542, { 0xEB, 0xB7, 0x93 },
	0x9543, { 0xEB, 0xB7, 0x96 },
	0x9544, { 0xEB, 0xB7, 0x97 },
	0x9545, { 0xEB, 0xB7, 0x99 },
	0x9546, { 0xEB, 0xB7, 0x9A },
	0x9547, { 0xEB, 0xB7, 0x9B },
	0x9548, { 0xEB, 0xB7, 0x9D },
	0x9549, { 0xEB, 0xB7, 0x9E },
	0x954A, { 0xEB, 0xB7, 0x9F },
	0x954B, { 0xEB, 0xB7, 0xA0 },
	0x954C, { 0xEB, 0xB7, 0xA1 },
	0x954D, { 0xEB, 0xB7, 0xA2 },
	0x954E, { 0xEB, 0xB7, 0xA3 },
	0x954F, { 0xEB, 0xB7, 0xA4 },
	0x9550, { 0xEB, 0xB7, 0xA5 },
	0x9551, { 0xEB, 0xB7, 0xA6 },
	0x9552, { 0xEB, 0xB7, 0xA7 },
	0x9553, { 0xEB, 0xB7, 0xA8 },
	0x9554, { 0xEB, 0xB7, 0xAA },
	0x9555, { 0xEB, 0xB7, 0xAB },
	0x9556, { 0xEB, 0xB7, 0xAC },
	0x9557, { 0xEB, 0xB7, 0xAD },
	0x9558, { 0xEB, 0xB7, 0xAE },
	0x9559, { 0xEB, 0xB7, 0xAF },
	0x955A, { 0xEB, 0xB7, 0xB1 },
	0x9561, { 0xEB, 0xB7, 0xB2 },
	0x9562, { 0xEB, 0xB7, 0xB3 },
	0x9563, { 0xEB, 0xB7, 0xB5 },
	0x9564, { 0xEB, 0xB7, 0xB6 },
	0x9565, { 0xEB, 0xB7, 0xB7 },
	0x9566, { 0xEB, 0xB7, 0xB9 },
	0x9567, { 0xEB, 0xB7, 0xBA },
	0x9568, { 0xEB, 0xB7, 0xBB },
	0x9569, { 0xEB, 0xB7, 0xBC },
	0x956A, { 0xEB, 0xB7, 0xBD },
	0x956B, { 0xEB, 0xB7, 0xBE },
	0x956C, { 0xEB, 0xB7, 0xBF },
	0x956D, { 0xEB, 0xB8, 0x81 },
	0x956E, { 0xEB, 0xB8, 0x82 },
	0x956F, { 0xEB, 0xB8, 0x84 },
	0x9570, { 0xEB, 0xB8, 0x86 },
	0x9571, { 0xEB, 0xB8, 0x87 },
	0x9572, { 0xEB, 0xB8, 0x88 },
	0x9573, { 0xEB, 0xB8, 0x89 },
	0x9574, { 0xEB, 0xB8, 0x8A },
	0x9575, { 0xEB, 0xB8, 0x8B },
	0x9576, { 0xEB, 0xB8, 0x8E },
	0x9577, { 0xEB, 0xB8, 0x8F },
	0x9578, { 0xEB, 0xB8, 0x91 },
	0x9579, { 0xEB, 0xB8, 0x92 },
	0x957A, { 0xEB, 0xB8, 0x93 },
	0x9581, { 0xEB, 0xB8, 0x95 },
	0x9582, { 0xEB, 0xB8, 0x96 },
	0x9583, { 0xEB, 0xB8, 0x97 },
	0x9584, { 0xEB, 0xB8, 0x98 },
	0x9585, { 0xEB, 0xB8, 0x99 },
	0x9586, { 0xEB, 0xB8, 0x9A },
	0x9587, { 0xEB, 0xB8, 0x9B },
	0x9588, { 0xEB, 0xB8, 0x9E },
	0x9589, { 0xEB, 0xB8, 0xA0 },
	0x958A, { 0xEB, 0xB8, 0xA1 },
	0x958B, { 0xEB, 0xB8, 0xA2 },
	0x958C, { 0xEB, 0xB8, 0xA3 },
	0x958D, { 0xEB, 0xB8, 0xA4 },
	0x958E, { 0xEB, 0xB8, 0xA5 },
	0x958F, { 0xEB, 0xB8, 0xA6 },
	0x9590, { 0xEB, 0xB8, 0xA7 },
	0x9591, { 0xEB, 0xB8, 0xA8 },
	0x9592, { 0xEB, 0xB8, 0xA9 },
	0x9593, { 0xEB, 0xB8, 0xAA },
	0x9594, { 0xEB, 0xB8, 0xAB },
	0x9595, { 0xEB, 0xB8, 0xAC },
	0x9596, { 0xEB, 0xB8, 0xAD },
	0x9597, { 0xEB, 0xB8, 0xAE },
	0x9598, { 0xEB, 0xB8, 0xAF },
	0x9599, { 0xEB, 0xB8, 0xB0 },
	0x959A, { 0xEB, 0xB8, 0xB1 },
	0x959B, { 0xEB, 0xB8, 0xB2 },
	0x959C, { 0xEB, 0xB8, 0xB3 },
	0x959D, { 0xEB, 0xB8, 0xB4 },
	0x959E, { 0xEB, 0xB8, 0xB5 },
	0x959F, { 0xEB, 0xB8, 0xB6 },
	0x95A0, { 0xEB, 0xB8, 0xB7 },
	0x95A1, { 0xEB, 0xB8, 0xB8 },
	0x95A2, { 0xEB, 0xB8, 0xB9 },
	0x95A3, { 0xEB, 0xB8, 0xBA },
	0x95A4, { 0xEB, 0xB8, 0xBB },
	0x95A5, { 0xEB, 0xB8, 0xBC },
	0x95A6, { 0xEB, 0xB8, 0xBD },
	0x95A7, { 0xEB, 0xB8, 0xBE },
	0x95A8, { 0xEB, 0xB8, 0xBF },
	0x95A9, { 0xEB, 0xB9, 0x80 },
	0x95AA, { 0xEB, 0xB9, 0x81 },
	0x95AB, { 0xEB, 0xB9, 0x82 },
	0x95AC, { 0xEB, 0xB9, 0x83 },
	0x95AD, { 0xEB, 0xB9, 0x86 },
	0x95AE, { 0xEB, 0xB9, 0x87 },
	0x95AF, { 0xEB, 0xB9, 0x89 },
	0x95B0, { 0xEB, 0xB9, 0x8A },
	0x95B1, { 0xEB, 0xB9, 0x8B },
	0x95B2, { 0xEB, 0xB9, 0x8D },
	0x95B3, { 0xEB, 0xB9, 0x8F },
	0x95B4, { 0xEB, 0xB9, 0x90 },
	0x95B5, { 0xEB, 0xB9, 0x91 },
	0x95B6, { 0xEB, 0xB9, 0x92 },
	0x95B7, { 0xEB, 0xB9, 0x93 },
	0x95B8, { 0xEB, 0xB9, 0x96 },
	0x95B9, { 0xEB, 0xB9, 0x98 },
	0x95BA, { 0xEB, 0xB9, 0x9C },
	0x95BB, { 0xEB, 0xB9, 0x9D },
	0x95BC, { 0xEB, 0xB9, 0x9E },
	0x95BD, { 0xEB, 0xB9, 0x9F },
	0x95BE, { 0xEB, 0xB9, 0xA2 },
	0x95BF, { 0xEB, 0xB9, 0xA3 },
	0x95C0, { 0xEB, 0xB9, 0xA5 },
	0x95C1, { 0xEB, 0xB9, 0xA6 },
	0x95C2, { 0xEB, 0xB9, 0xA7 },
	0x95C3, { 0xEB, 0xB9, 0xA9 },
	0x95C4, { 0xEB, 0xB9, 0xAB },
	0x95C5, { 0xEB, 0xB9, 0xAC },
	0x95C6, { 0xEB, 0xB9, 0xAD },
	0x95C7, { 0xEB, 0xB9, 0xAE },
	0x95C8, { 0xEB, 0xB9, 0xAF },
	0x95C9, { 0xEB, 0xB9, 0xB2 },
	0x95CA, { 0xEB, 0xB9, 0xB6 },
	0x95CB, { 0xEB, 0xB9, 0xB7 },
	0x95CC, { 0xEB, 0xB9, 0xB8 },
	0x95CD, { 0xEB, 0xB9, 0xB9 },
	0x95CE, { 0xEB, 0xB9, 0xBA },
	0x95CF, { 0xEB, 0xB9, 0xBE },
	0x95D0, { 0xEB, 0xB9, 0xBF },
	0x95D1, { 0xEB, 0xBA, 0x81 },
	0x95D2, { 0xEB, 0xBA, 0x82 },
	0x95D3, { 0xEB, 0xBA, 0x83 },
	0x95D4, { 0xEB, 0xBA, 0x85 },
	0x95D5, { 0xEB, 0xBA, 0x86 },
	0x95D6, { 0xEB, 0xBA, 0x87 },
	0x95D7, { 0xEB, 0xBA, 0x88 },
	0x95D8, { 0xEB, 0xBA, 0x89 },
	0x95D9, { 0xEB, 0xBA, 0x8A },
	0x95DA, { 0xEB, 0xBA, 0x8B },
	0x95DB, { 0xEB, 0xBA, 0x8E },
	0x95DC, { 0xEB, 0xBA, 0x92 },
	0x95DD, { 0xEB, 0xBA, 0x93 },
	0x95DE, { 0xEB, 0xBA, 0x94 },
	0x95DF, { 0xEB, 0xBA, 0x95 },
	0x95E0, { 0xEB, 0xBA, 0x96 },
	0x95E1, { 0xEB, 0xBA, 0x97 },
	0x95E2, { 0xEB, 0xBA, 0x9A },
	0x95E3, { 0xEB, 0xBA, 0x9B },
	0x95E4, { 0xEB, 0xBA, 0x9C },
	0x95E5, { 0xEB, 0xBA, 0x9D },
	0x95E6, { 0xEB, 0xBA, 0x9E },
	0x95E7, { 0xEB, 0xBA, 0x9F },
	0x95E8, { 0xEB, 0xBA, 0xA0 },
	0x95E9, { 0xEB, 0xBA, 0xA1 },
	0x95EA, { 0xEB, 0xBA, 0xA2 },
	0x95EB, { 0xEB, 0xBA, 0xA3 },
	0x95EC, { 0xEB, 0xBA, 0xA4 },
	0x95ED, { 0xEB, 0xBA, 0xA5 },
	0x95EE, { 0xEB, 0xBA, 0xA6 },
	0x95EF, { 0xEB, 0xBA, 0xA7 },
	0x95F0, { 0xEB, 0xBA, 0xA9 },
	0x95F1, { 0xEB, 0xBA, 0xAA },
	0x95F2, { 0xEB, 0xBA, 0xAB },
	0x95F3, { 0xEB, 0xBA, 0xAC },
	0x95F4, { 0xEB, 0xBA, 0xAD },
	0x95F5, { 0xEB, 0xBA, 0xAE },
	0x95F6, { 0xEB, 0xBA, 0xAF },
	0x95F7, { 0xEB, 0xBA, 0xB0 },
	0x95F8, { 0xEB, 0xBA, 0xB1 },
	0x95F9, { 0xEB, 0xBA, 0xB2 },
	0x95FA, { 0xEB, 0xBA, 0xB3 },
	0x95FB, { 0xEB, 0xBA, 0xB4 },
	0x95FC, { 0xEB, 0xBA, 0xB5 },
	0x95FD, { 0xEB, 0xBA, 0xB6 },
	0x95FE, { 0xEB, 0xBA, 0xB7 },
	0x9641, { 0xEB, 0xBA, 0xB8 },
	0x9642, { 0xEB, 0xBA, 0xB9 },
	0x9643, { 0xEB, 0xBA, 0xBA },
	0x9644, { 0xEB, 0xBA, 0xBB },
	0x9645, { 0xEB, 0xBA, 0xBC },
	0x9646, { 0xEB, 0xBA, 0xBD },
	0x9647, { 0xEB, 0xBA, 0xBE },
	0x9648, { 0xEB, 0xBA, 0xBF },
	0x9649, { 0xEB, 0xBB, 0x80 },
	0x964A, { 0xEB, 0xBB, 0x81 },
	0x964B, { 0xEB, 0xBB, 0x82 },
	0x964C, { 0xEB, 0xBB, 0x83 },
	0x964D, { 0xEB, 0xBB, 0x84 },
	0x964E, { 0xEB, 0xBB, 0x85 },
	0x964F, { 0xEB, 0xBB, 0x86 },
	0x9650, { 0xEB, 0xBB, 0x87 },
	0x9651, { 0xEB, 0xBB, 0x88 },
	0x9652, { 0xEB, 0xBB, 0x89 },
	0x9653, { 0xEB, 0xBB, 0x8A },
	0x9654, { 0xEB, 0xBB, 0x8B },
	0x9655, { 0xEB, 0xBB, 0x8C },
	0x9656, { 0xEB, 0xBB, 0x8D },
	0x9657, { 0xEB, 0xBB, 0x8E },
	0x9658, { 0xEB, 0xBB, 0x8F },
	0x9659, { 0xEB, 0xBB, 0x92 },
	0x965A, { 0xEB, 0xBB, 0x93 },
	0x9661, { 0xEB, 0xBB, 0x95 },
	0x9662, { 0xEB, 0xBB, 0x96 },
	0x9663, { 0xEB, 0xBB, 0x99 },
	0x9664, { 0xEB, 0xBB, 0x9A },
	0x9665, { 0xEB, 0xBB, 0x9B },
	0x9666, { 0xEB, 0xBB, 0x9C },
	0x9667, { 0xEB, 0xBB, 0x9D },
	0x9668, { 0xEB, 0xBB, 0x9E },
	0x9669, { 0xEB, 0xBB, 0x9F },
	0x966A, { 0xEB, 0xBB, 0xA1 },
	0x966B, { 0xEB, 0xBB, 0xA2 },
	0x966C, { 0xEB, 0xBB, 0xA6 },
	0x966D, { 0xEB, 0xBB, 0xA7 },
	0x966E, { 0xEB, 0xBB, 0xA8 },
	0x966F, { 0xEB, 0xBB, 0xA9 },
	0x9670, { 0xEB, 0xBB, 0xAA },
	0x9671, { 0xEB, 0xBB, 0xAB },
	0x9672, { 0xEB, 0xBB, 0xAD },
	0x9673, { 0xEB, 0xBB, 0xAE },
	0x9674, { 0xEB, 0xBB, 0xAF },
	0x9675, { 0xEB, 0xBB, 0xB0 },
	0x9676, { 0xEB, 0xBB, 0xB1 },
	0x9677, { 0xEB, 0xBB, 0xB2 },
	0x9678, { 0xEB, 0xBB, 0xB3 },
	0x9679, { 0xEB, 0xBB, 0xB4 },
	0x967A, { 0xEB, 0xBB, 0xB5 },
	0x9681, { 0xEB, 0xBB, 0xB6 },
	0x9682, { 0xEB, 0xBB, 0xB7 },
	0x9683, { 0xEB, 0xBB, 0xB8 },
	0x9684, { 0xEB, 0xBB, 0xB9 },
	0x9685, { 0xEB, 0xBB, 0xBA },
	0x9686, { 0xEB, 0xBB, 0xBB },
	0x9687, { 0xEB, 0xBB, 0xBC },
	0x9688, { 0xEB, 0xBB, 0xBD },
	0x9689, { 0xEB, 0xBB, 0xBE },
	0x968A, { 0xEB, 0xBB, 0xBF },
	0x968B, { 0xEB, 0xBC, 0x80 },
	0x968C, { 0xEB, 0xBC, 0x82 },
	0x968D, { 0xEB, 0xBC, 0x83 },
	0x968E, { 0xEB, 0xBC, 0x84 },
	0x968F, { 0xEB, 0xBC, 0x85 },
	0x9690, { 0xEB, 0xBC, 0x86 },
	0x9691, { 0xEB, 0xBC, 0x87 },
	0x9692, { 0xEB, 0xBC, 0x8A },
	0x9693, { 0xEB, 0xBC, 0x8B },
	0x9694, { 0xEB, 0xBC, 0x8C },
	0x9695, { 0xEB, 0xBC, 0x8D },
	0x9696, { 0xEB, 0xBC, 0x8E },
	0x9697, { 0xEB, 0xBC, 0x8F },
	0x9698, { 0xEB, 0xBC, 0x90 },
	0x9699, { 0xEB, 0xBC, 0x91 },
	0x969A, { 0xEB, 0xBC, 0x92 },
	0x969B, { 0xEB, 0xBC, 0x93 },
	0x969C, { 0xEB, 0xBC, 0x94 },
	0x969D, { 0xEB, 0xBC, 0x95 },
	0x969E, { 0xEB, 0xBC, 0x96 },
	0x969F, { 0xEB, 0xBC, 0x97 },
	0x96A0, { 0xEB, 0xBC, 0x9A },
	0x96A1, { 0xEB, 0xBC, 0x9E },
	0x96A2, { 0xEB, 0xBC, 0x9F },
	0x96A3, { 0xEB, 0xBC, 0xA0 },
	0x96A4, { 0xEB, 0xBC, 0xA1 },
	0x96A5, { 0xEB, 0xBC, 0xA2 },
	0x96A6, { 0xEB, 0xBC, 0xA3 },
	0x96A7, { 0xEB, 0xBC, 0xA4 },
	0x96A8, { 0xEB, 0xBC, 0xA5 },
	0x96A9, { 0xEB, 0xBC, 0xA6 },
	0x96AA, { 0xEB, 0xBC, 0xA7 },
	0x96AB, { 0xEB, 0xBC, 0xA8 },
	0x96AC, { 0xEB, 0xBC, 0xA9 },
	0x96AD, { 0xEB, 0xBC, 0xAA },
	0x96AE, { 0xEB, 0xBC, 0xAB },
	0x96AF, { 0xEB, 0xBC, 0xAC },
	0x96B0, { 0xEB, 0xBC, 0xAD },
	0x96B1, { 0xEB, 0xBC, 0xAE },
	0x96B2, { 0xEB, 0xBC, 0xAF },
	0x96B3, { 0xEB, 0xBC, 0xB0 },
	0x96B4, { 0xEB, 0xBC, 0xB1 },
	0x96B5, { 0xEB, 0xBC, 0xB2 },
	0x96B6, { 0xEB, 0xBC, 0xB3 },
	0x96B7, { 0xEB, 0xBC, 0xB4 },
	0x96B8, { 0xEB, 0xBC, 0xB5 },
	0x96B9, { 0xEB, 0xBC, 0xB6 },
	0x96BA, { 0xEB, 0xBC, 0xB7 },
	0x96BB, { 0xEB, 0xBC, 0xB8 },
	0x96BC, { 0xEB, 0xBC, 0xB9 },
	0x96BD, { 0xEB, 0xBC, 0xBA },
	0x96BE, { 0xEB, 0xBC, 0xBB },
	0x96BF, { 0xEB, 0xBC, 0xBC },
	0x96C0, { 0xEB, 0xBC, 0xBD },
	0x96C1, { 0xEB, 0xBC, 0xBE },
	0x96C2, { 0xEB, 0xBC, 0xBF },
	0x96C3, { 0xEB, 0xBD, 0x82 },
	0x96C4, { 0xEB, 0xBD, 0x83 },
	0x96C5, { 0xEB, 0xBD, 0x85 },
	0x96C6, { 0xEB, 0xBD, 0x86 },
	0x96C7, { 0xEB, 0xBD, 0x87 },
	0x96C8, { 0xEB, 0xBD, 0x89 },
	0x96C9, { 0xEB, 0xBD, 0x8A },
	0x96CA, { 0xEB, 0xBD, 0x8B },
	0x96CB, { 0xEB, 0xBD, 0x8C },
	0x96CC, { 0xEB, 0xBD, 0x8D },
	0x96CD, { 0xEB, 0xBD, 0x8E },
	0x96CE, { 0xEB, 0xBD, 0x8F },
	0x96CF, { 0xEB, 0xBD, 0x92 },
	0x96D0, { 0xEB, 0xBD, 0x93 },
	0x96D1, { 0xEB, 0xBD, 0x94 },
	0x96D2, { 0xEB, 0xBD, 0x96 },
	0x96D3, { 0xEB, 0xBD, 0x97 },
	0x96D4, { 0xEB, 0xBD, 0x98 },
	0x96D5, { 0xEB, 0xBD, 0x99 },
	0x96D6, { 0xEB, 0xBD, 0x9A },
	0x96D7, { 0xEB, 0xBD, 0x9B },
	0x96D8, { 0xEB, 0xBD, 0x9C },
	0x96D9, { 0xEB, 0xBD, 0x9D },
	0x96DA, { 0xEB, 0xBD, 0x9E },
	0x96DB, { 0xEB, 0xBD, 0x9F },
	0x96DC, { 0xEB, 0xBD, 0xA0 },
	0x96DD, { 0xEB, 0xBD, 0xA1 },
	0x96DE, { 0xEB, 0xBD, 0xA2 },
	0x96DF, { 0xEB, 0xBD, 0xA3 },
	0x96E0, { 0xEB, 0xBD, 0xA4 },
	0x96E1, { 0xEB, 0xBD, 0xA5 },
	0x96E2, { 0xEB, 0xBD, 0xA6 },
	0x96E3, { 0xEB, 0xBD, 0xA7 },
	0x96E4, { 0xEB, 0xBD, 0xA8 },
	0x96E5, { 0xEB, 0xBD, 0xA9 },
	0x96E6, { 0xEB, 0xBD, 0xAA },
	0x96E7, { 0xEB, 0xBD, 0xAB },
	0x96E8, { 0xEB, 0xBD, 0xAC },
	0x96E9, { 0xEB, 0xBD, 0xAD },
	0x96EA, { 0xEB, 0xBD, 0xAE },
	0x96EB, { 0xEB, 0xBD, 0xAF },
	0x96EC, { 0xEB, 0xBD, 0xB0 },
	0x96ED, { 0xEB, 0xBD, 0xB1 },
	0x96EE, { 0xEB, 0xBD, 0xB2 },
	0x96EF, { 0xEB, 0xBD, 0xB3 },
	0x96F0, { 0xEB, 0xBD, 0xB4 },
	0x96F1, { 0xEB, 0xBD, 0xB5 },
	0x96F2, { 0xEB, 0xBD, 0xB6 },
	0x96F3, { 0xEB, 0xBD, 0xB7 },
	0x96F4, { 0xEB, 0xBD, 0xB8 },
	0x96F5, { 0xEB, 0xBD, 0xB9 },
	0x96F6, { 0xEB, 0xBD, 0xBA },
	0x96F7, { 0xEB, 0xBD, 0xBB },
	0x96F8, { 0xEB, 0xBD, 0xBC },
	0x96F9, { 0xEB, 0xBD, 0xBD },
	0x96FA, { 0xEB, 0xBD, 0xBE },
	0x96FB, { 0xEB, 0xBD, 0xBF },
	0x96FC, { 0xEB, 0xBE, 0x80 },
	0x96FD, { 0xEB, 0xBE, 0x81 },
	0x96FE, { 0xEB, 0xBE, 0x82 },
	0x9741, { 0xEB, 0xBE, 0x83 },
	0x9742, { 0xEB, 0xBE, 0x84 },
	0x9743, { 0xEB, 0xBE, 0x85 },
	0x9744, { 0xEB, 0xBE, 0x86 },
	0x9745, { 0xEB, 0xBE, 0x87 },
	0x9746, { 0xEB, 0xBE, 0x88 },
	0x9747, { 0xEB, 0xBE, 0x89 },
	0x9748, { 0xEB, 0xBE, 0x8A },
	0x9749, { 0xEB, 0xBE, 0x8B },
	0x974A, { 0xEB, 0xBE, 0x8C },
	0x974B, { 0xEB, 0xBE, 0x8D },
	0x974C, { 0xEB, 0xBE, 0x8E },
	0x974D, { 0xEB, 0xBE, 0x8F },
	0x974E, { 0xEB, 0xBE, 0x90 },
	0x974F, { 0xEB, 0xBE, 0x91 },
	0x9750, { 0xEB, 0xBE, 0x92 },
	0x9751, { 0xEB, 0xBE, 0x93 },
	0x9752, { 0xEB, 0xBE, 0x95 },
	0x9753, { 0xEB, 0xBE, 0x96 },
	0x9754, { 0xEB, 0xBE, 0x97 },
	0x9755, { 0xEB, 0xBE, 0x98 },
	0x9756, { 0xEB, 0xBE, 0x99 },
	0x9757, { 0xEB, 0xBE, 0x9A },
	0x9758, { 0xEB, 0xBE, 0x9B },
	0x9759, { 0xEB, 0xBE, 0x9C },
	0x975A, { 0xEB, 0xBE, 0x9D },
	0x9761, { 0xEB, 0xBE, 0x9E },
	0x9762, { 0xEB, 0xBE, 0x9F },
	0x9763, { 0xEB, 0xBE, 0xA0 },
	0x9764, { 0xEB, 0xBE, 0xA1 },
	0x9765, { 0xEB, 0xBE, 0xA2 },
	0x9766, { 0xEB, 0xBE, 0xA3 },
	0x9767, { 0xEB, 0xBE, 0xA4 },
	0x9768, { 0xEB, 0xBE, 0xA5 },
	0x9769, { 0xEB, 0xBE, 0xA6 },
	0x976A, { 0xEB, 0xBE, 0xA7 },
	0x976B, { 0xEB, 0xBE, 0xA8 },
	0x976C, { 0xEB, 0xBE, 0xA9 },
	0x976D, { 0xEB, 0xBE, 0xAA },
	0x976E, { 0xEB, 0xBE, 0xAB },
	0x976F, { 0xEB, 0xBE, 0xAC },
	0x9770, { 0xEB, 0xBE, 0xAD },
	0x9771, { 0xEB, 0xBE, 0xAE },
	0x9772, { 0xEB, 0xBE, 0xAF },
	0x9773, { 0xEB, 0xBE, 0xB1 },
	0x9774, { 0xEB, 0xBE, 0xB2 },
	0x9775, { 0xEB, 0xBE, 0xB3 },
	0x9776, { 0xEB, 0xBE, 0xB4 },
	0x9777, { 0xEB, 0xBE, 0xB5 },
	0x9778, { 0xEB, 0xBE, 0xB6 },
	0x9779, { 0xEB, 0xBE, 0xB7 },
	0x977A, { 0xEB, 0xBE, 0xB8 },
	0x9781, { 0xEB, 0xBE, 0xB9 },
	0x9782, { 0xEB, 0xBE, 0xBA },
	0x9783, { 0xEB, 0xBE, 0xBB },
	0x9784, { 0xEB, 0xBE, 0xBC },
	0x9785, { 0xEB, 0xBE, 0xBD },
	0x9786, { 0xEB, 0xBE, 0xBE },
	0x9787, { 0xEB, 0xBE, 0xBF },
	0x9788, { 0xEB, 0xBF, 0x80 },
	0x9789, { 0xEB, 0xBF, 0x81 },
	0x978A, { 0xEB, 0xBF, 0x82 },
	0x978B, { 0xEB, 0xBF, 0x83 },
	0x978C, { 0xEB, 0xBF, 0x84 },
	0x978D, { 0xEB, 0xBF, 0x86 },
	0x978E, { 0xEB, 0xBF, 0x87 },
	0x978F, { 0xEB, 0xBF, 0x88 },
	0x9790, { 0xEB, 0xBF, 0x89 },
	0x9791, { 0xEB, 0xBF, 0x8A },
	0x9792, { 0xEB, 0xBF, 0x8B },
	0x9793, { 0xEB, 0xBF, 0x8E },
	0x9794, { 0xEB, 0xBF, 0x8F },
	0x9795, { 0xEB, 0xBF, 0x91 },
	0x9796, { 0xEB, 0xBF, 0x92 },
	0x9797, { 0xEB, 0xBF, 0x93 },
	0x9798, { 0xEB, 0xBF, 0x95 },
	0x9799, { 0xEB, 0xBF, 0x96 },
	0x979A, { 0xEB, 0xBF, 0x97 },
	0x979B, { 0xEB, 0xBF, 0x98 },
	0x979C, { 0xEB, 0xBF, 0x99 },
	0x979D, { 0xEB, 0xBF, 0x9A },
	0x979E, { 0xEB, 0xBF, 0x9B },
	0x979F, { 0xEB, 0xBF, 0x9D },
	0x97A0, { 0xEB, 0xBF, 0x9E },
	0x97A1, { 0xEB, 0xBF, 0xA0 },
	0x97A2, { 0xEB, 0xBF, 0xA2 },
	0x97A3, { 0xEB, 0xBF, 0xA3 },
	0x97A4, { 0xEB, 0xBF, 0xA4 },
	0x97A5, { 0xEB, 0xBF, 0xA5 },
	0x97A6, { 0xEB, 0xBF, 0xA6 },
	0x97A7, { 0xEB, 0xBF, 0xA7 },
	0x97A8, { 0xEB, 0xBF, 0xA8 },
	0x97A9, { 0xEB, 0xBF, 0xA9 },
	0x97AA, { 0xEB, 0xBF, 0xAA },
	0x97AB, { 0xEB, 0xBF, 0xAB },
	0x97AC, { 0xEB, 0xBF, 0xAC },
	0x97AD, { 0xEB, 0xBF, 0xAD },
	0x97AE, { 0xEB, 0xBF, 0xAE },
	0x97AF, { 0xEB, 0xBF, 0xAF },
	0x97B0, { 0xEB, 0xBF, 0xB0 },
	0x97B1, { 0xEB, 0xBF, 0xB1 },
	0x97B2, { 0xEB, 0xBF, 0xB2 },
	0x97B3, { 0xEB, 0xBF, 0xB3 },
	0x97B4, { 0xEB, 0xBF, 0xB4 },
	0x97B5, { 0xEB, 0xBF, 0xB5 },
	0x97B6, { 0xEB, 0xBF, 0xB6 },
	0x97B7, { 0xEB, 0xBF, 0xB7 },
	0x97B8, { 0xEB, 0xBF, 0xB8 },
	0x97B9, { 0xEB, 0xBF, 0xB9 },
	0x97BA, { 0xEB, 0xBF, 0xBA },
	0x97BB, { 0xEB, 0xBF, 0xBB },
	0x97BC, { 0xEB, 0xBF, 0xBC },
	0x97BD, { 0xEB, 0xBF, 0xBD },
	0x97BE, { 0xEB, 0xBF, 0xBE },
	0x97BF, { 0xEB, 0xBF, 0xBF },
	0x97C0, { 0xEC, 0x80, 0x80 },
	0x97C1, { 0xEC, 0x80, 0x81 },
	0x97C2, { 0xEC, 0x80, 0x82 },
	0x97C3, { 0xEC, 0x80, 0x83 },
	0x97C4, { 0xEC, 0x80, 0x84 },
	0x97C5, { 0xEC, 0x80, 0x85 },
	0x97C6, { 0xEC, 0x80, 0x86 },
	0x97C7, { 0xEC, 0x80, 0x87 },
	0x97C8, { 0xEC, 0x80, 0x88 },
	0x97C9, { 0xEC, 0x80, 0x89 },
	0x97CA, { 0xEC, 0x80, 0x8A },
	0x97CB, { 0xEC, 0x80, 0x8B },
	0x97CC, { 0xEC, 0x80, 0x8C },
	0x97CD, { 0xEC, 0x80, 0x8D },
	0x97CE, { 0xEC, 0x80, 0x8E },
	0x97CF, { 0xEC, 0x80, 0x8F },
	0x97D0, { 0xEC, 0x80, 0x90 },
	0x97D1, { 0xEC, 0x80, 0x91 },
	0x97D2, { 0xEC, 0x80, 0x92 },
	0x97D3, { 0xEC, 0x80, 0x93 },
	0x97D4, { 0xEC, 0x80, 0x94 },
	0x97D5, { 0xEC, 0x80, 0x95 },
	0x97D6, { 0xEC, 0x80, 0x96 },
	0x97D7, { 0xEC, 0x80, 0x97 },
	0x97D8, { 0xEC, 0x80, 0x98 },
	0x97D9, { 0xEC, 0x80, 0x99 },
	0x97DA, { 0xEC, 0x80, 0x9A },
	0x97DB, { 0xEC, 0x80, 0x9B },
	0x97DC, { 0xEC, 0x80, 0x9C },
	0x97DD, { 0xEC, 0x80, 0x9D },
	0x97DE, { 0xEC, 0x80, 0x9E },
	0x97DF, { 0xEC, 0x80, 0x9F },
	0x97E0, { 0xEC, 0x80, 0xA0 },
	0x97E1, { 0xEC, 0x80, 0xA1 },
	0x97E2, { 0xEC, 0x80, 0xA2 },
	0x97E3, { 0xEC, 0x80, 0xA3 },
	0x97E4, { 0xEC, 0x80, 0xA4 },
	0x97E5, { 0xEC, 0x80, 0xA5 },
	0x97E6, { 0xEC, 0x80, 0xA6 },
	0x97E7, { 0xEC, 0x80, 0xA7 },
	0x97E8, { 0xEC, 0x80, 0xA8 },
	0x97E9, { 0xEC, 0x80, 0xA9 },
	0x97EA, { 0xEC, 0x80, 0xAA },
	0x97EB, { 0xEC, 0x80, 0xAB },
	0x97EC, { 0xEC, 0x80, 0xAC },
	0x97ED, { 0xEC, 0x80, 0xAD },
	0x97EE, { 0xEC, 0x80, 0xAE },
	0x97EF, { 0xEC, 0x80, 0xAF },
	0x97F0, { 0xEC, 0x80, 0xB0 },
	0x97F1, { 0xEC, 0x80, 0xB1 },
	0x97F2, { 0xEC, 0x80, 0xB2 },
	0x97F3, { 0xEC, 0x80, 0xB3 },
	0x97F4, { 0xEC, 0x80, 0xB4 },
	0x97F5, { 0xEC, 0x80, 0xB5 },
	0x97F6, { 0xEC, 0x80, 0xB6 },
	0x97F7, { 0xEC, 0x80, 0xB7 },
	0x97F8, { 0xEC, 0x80, 0xB8 },
	0x97F9, { 0xEC, 0x80, 0xB9 },
	0x97FA, { 0xEC, 0x80, 0xBA },
	0x97FB, { 0xEC, 0x80, 0xBB },
	0x97FC, { 0xEC, 0x80, 0xBD },
	0x97FD, { 0xEC, 0x80, 0xBE },
	0x97FE, { 0xEC, 0x80, 0xBF },
	0x9841, { 0xEC, 0x81, 0x80 },
	0x9842, { 0xEC, 0x81, 0x81 },
	0x9843, { 0xEC, 0x81, 0x82 },
	0x9844, { 0xEC, 0x81, 0x83 },
	0x9845, { 0xEC, 0x81, 0x84 },
	0x9846, { 0xEC, 0x81, 0x85 },
	0x9847, { 0xEC, 0x81, 0x86 },
	0x9848, { 0xEC, 0x81, 0x87 },
	0x9849, { 0xEC, 0x81, 0x88 },
	0x984A, { 0xEC, 0x81, 0x89 },
	0x984B, { 0xEC, 0x81, 0x8A },
	0x984C, { 0xEC, 0x81, 0x8B },
	0x984D, { 0xEC, 0x81, 0x8C },
	0x984E, { 0xEC, 0x81, 0x8D },
	0x984F, { 0xEC, 0x81, 0x8E },
	0x9850, { 0xEC, 0x81, 0x8F },
	0x9851, { 0xEC, 0x81, 0x90 },
	0x9852, { 0xEC, 0x81, 0x92 },
	0x9853, { 0xEC, 0x81, 0x93 },
	0x9854, { 0xEC, 0x81, 0x94 },
	0x9855, { 0xEC, 0x81, 0x95 },
	0x9856, { 0xEC, 0x81, 0x96 },
	0x9857, { 0xEC, 0x81, 0x97 },
	0x9858, { 0xEC, 0x81, 0x99 },
	0x9859, { 0xEC, 0x81, 0x9A },
	0x985A, { 0xEC, 0x81, 0x9B },
	0x9861, { 0xEC, 0x81, 0x9D },
	0x9862, { 0xEC, 0x81, 0x9E },
	0x9863, { 0xEC, 0x81, 0x9F },
	0x9864, { 0xEC, 0x81, 0xA1 },
	0x9865, { 0xEC, 0x81, 0xA2 },
	0x9866, { 0xEC, 0x81, 0xA3 },
	0x9867, { 0xEC, 0x81, 0xA4 },
	0x9868, { 0xEC, 0x81, 0xA5 },
	0x9869, { 0xEC, 0x81, 0xA6 },
	0x986A, { 0xEC, 0x81, 0xA7 },
	0x986B, { 0xEC, 0x81, 0xAA },
	0x986C, { 0xEC, 0x81, 0xAB },
	0x986D, { 0xEC, 0x81, 0xAC },
	0x986E, { 0xEC, 0x81, 0xAD },
	0x986F, { 0xEC, 0x81, 0xAE },
	0x9870, { 0xEC, 0x81, 0xAF },
	0x9871, { 0xEC, 0x81, 0xB0 },
	0x9872, { 0xEC, 0x81, 0xB1 },
	0x9873, { 0xEC, 0x81, 0xB2 },
	0x9874, { 0xEC, 0x81, 0xB3 },
	0x9875, { 0xEC, 0x81, 0xB4 },
	0x9876, { 0xEC, 0x81, 0xB5 },
	0x9877, { 0xEC, 0x81, 0xB6 },
	0x9878, { 0xEC, 0x81, 0xB7 },
	0x9879, { 0xEC, 0x81, 0xB8 },
	0x987A, { 0xEC, 0x81, 0xB9 },
	0x9881, { 0xEC, 0x81, 0xBA },
	0x9882, { 0xEC, 0x81, 0xBB },
	0x9883, { 0xEC, 0x81, 0xBC },
	0x9884, { 0xEC, 0x81, 0xBD },
	0x9885, { 0xEC, 0x81, 0xBE },
	0x9886, { 0xEC, 0x81, 0xBF },
	0x9887, { 0xEC, 0x82, 0x80 },
	0x9888, { 0xEC, 0x82, 0x81 },
	0x9889, { 0xEC, 0x82, 0x82 },
	0x988A, { 0xEC, 0x82, 0x83 },
	0x988B, { 0xEC, 0x82, 0x84 },
	0x988C, { 0xEC, 0x82, 0x85 },
	0x988D, { 0xEC, 0x82, 0x86 },
	0x988E, { 0xEC, 0x82, 0x87 },
	0x988F, { 0xEC, 0x82, 0x88 },
	0x9890, { 0xEC, 0x82, 0x89 },
	0x9891, { 0xEC, 0x82, 0x8A },
	0x9892, { 0xEC, 0x82, 0x8B },
	0x9893, { 0xEC, 0x82, 0x8C },
	0x9894, { 0xEC, 0x82, 0x8D },
	0x9895, { 0xEC, 0x82, 0x8E },
	0x9896, { 0xEC, 0x82, 0x8F },
	0x9897, { 0xEC, 0x82, 0x92 },
	0x9898, { 0xEC, 0x82, 0x93 },
	0x9899, { 0xEC, 0x82, 0x95 },
	0x989A, { 0xEC, 0x82, 0x96 },
	0x989B, { 0xEC, 0x82, 0x97 },
	0x989C, { 0xEC, 0x82, 0x99 },
	0x989D, { 0xEC, 0x82, 0x9A },
	0x989E, { 0xEC, 0x82, 0x9B },
	0x989F, { 0xEC, 0x82, 0x9C },
	0x98A0, { 0xEC, 0x82, 0x9D },
	0x98A1, { 0xEC, 0x82, 0x9E },
	0x98A2, { 0xEC, 0x82, 0x9F },
	0x98A3, { 0xEC, 0x82, 0xA2 },
	0x98A4, { 0xEC, 0x82, 0xA4 },
	0x98A5, { 0xEC, 0x82, 0xA6 },
	0x98A6, { 0xEC, 0x82, 0xA7 },
	0x98A7, { 0xEC, 0x82, 0xA8 },
	0x98A8, { 0xEC, 0x82, 0xA9 },
	0x98A9, { 0xEC, 0x82, 0xAA },
	0x98AA, { 0xEC, 0x82, 0xAB },
	0x98AB, { 0xEC, 0x82, 0xAE },
	0x98AC, { 0xEC, 0x82, 0xB1 },
	0x98AD, { 0xEC, 0x82, 0xB2 },
	0x98AE, { 0xEC, 0x82, 0xB7 },
	0x98AF, { 0xEC, 0x82, 0xB8 },
	0x98B0, { 0xEC, 0x82, 0xB9 },
	0x98B1, { 0xEC, 0x82, 0xBA },
	0x98B2, { 0xEC, 0x82, 0xBB },
	0x98B3, { 0xEC, 0x82, 0xBE },
	0x98B4, { 0xEC, 0x83, 0x82 },
	0x98B5, { 0xEC, 0x83, 0x83 },
	0x98B6, { 0xEC, 0x83, 0x84 },
	0x98B7, { 0xEC, 0x83, 0x86 },
	0x98B8, { 0xEC, 0x83, 0x87 },
	0x98B9, { 0xEC, 0x83, 0x8A },
	0x98BA, { 0xEC, 0x83, 0x8B },
	0x98BB, { 0xEC, 0x83, 0x8D },
	0x98BC, { 0xEC, 0x83, 0x8E },
	0x98BD, { 0xEC, 0x83, 0x8F },
	0x98BE, { 0xEC, 0x83, 0x91 },
	0x98BF, { 0xEC, 0x83, 0x92 },
	0x98C0, { 0xEC, 0x83, 0x93 },
	0x98C1, { 0xEC, 0x83, 0x94 },
	0x98C2, { 0xEC, 0x83, 0x95 },
	0x98C3, { 0xEC, 0x83, 0x96 },
	0x98C4, { 0xEC, 0x83, 0x97 },
	0x98C5, { 0xEC, 0x83, 0x9A },
	0x98C6, { 0xEC, 0x83, 0x9E },
	0x98C7, { 0xEC, 0x83, 0x9F },
	0x98C8, { 0xEC, 0x83, 0xA0 },
	0x98C9, { 0xEC, 0x83, 0xA1 },
	0x98CA, { 0xEC, 0x83, 0xA2 },
	0x98CB, { 0xEC, 0x83, 0xA3 },
	0x98CC, { 0xEC, 0x83, 0xA6 },
	0x98CD, { 0xEC, 0x83, 0xA7 },
	0x98CE, { 0xEC, 0x83, 0xA9 },
	0x98CF, { 0xEC, 0x83, 0xAA },
	0x98D0, { 0xEC, 0x83, 0xAB },
	0x98D1, { 0xEC, 0x83, 0xAD },
	0x98D2, { 0xEC, 0x83, 0xAE },
	0x98D3, { 0xEC, 0x83, 0xAF },
	0x98D4, { 0xEC, 0x83, 0xB0 },
	0x98D5, { 0xEC, 0x83, 0xB1 },
	0x98D6, { 0xEC, 0x83, 0xB2 },
	0x98D7, { 0xEC, 0x83, 0xB3 },
	0x98D8, { 0xEC, 0x83, 0xB6 },
	0x98D9, { 0xEC, 0x83, 0xB8 },
	0x98DA, { 0xEC, 0x83, 0xBA },
	0x98DB, { 0xEC, 0x83, 0xBB },
	0x98DC, { 0xEC, 0x83, 0xBC },
	0x98DD, { 0xEC, 0x83, 0xBD },
	0x98DE, { 0xEC, 0x83, 0xBE },
	0x98DF, { 0xEC, 0x83, 0xBF },
	0x98E0, { 0xEC, 0x84, 0x81 },
	0x98E1, { 0xEC, 0x84, 0x82 },
	0x98E2, { 0xEC, 0x84, 0x83 },
	0x98E3, { 0xEC, 0x84, 0x85 },
	0x98E4, { 0xEC, 0x84, 0x86 },
	0x98E5, { 0xEC, 0x84, 0x87 },
	0x98E6, { 0xEC, 0x84, 0x89 },
	0x98E7, { 0xEC, 0x84, 0x8A },
	0x98E8, { 0xEC, 0x84, 0x8B },
	0x98E9, { 0xEC, 0x84, 0x8C },
	0x98EA, { 0xEC, 0x84, 0x8D },
	0x98EB, { 0xEC, 0x84, 0x8E },
	0x98EC, { 0xEC, 0x84, 0x8F },
	0x98ED, { 0xEC, 0x84, 0x91 },
	0x98EE, { 0xEC, 0x84, 0x92 },
	0x98EF, { 0xEC, 0x84, 0x93 },
	0x98F0, { 0xEC, 0x84, 0x94 },
	0x98F1, { 0xEC, 0x84, 0x96 },
	0x98F2, { 0xEC, 0x84, 0x97 },
	0x98F3, { 0xEC, 0x84, 0x98 },
	0x98F4, { 0xEC, 0x84, 0x99 },
	0x98F5, { 0xEC, 0x84, 0x9A },
	0x98F6, { 0xEC, 0x84, 0x9B },
	0x98F7, { 0xEC, 0x84, 0xA1 },
	0x98F8, { 0xEC, 0x84, 0xA2 },
	0x98F9, { 0xEC, 0x84, 0xA5 },
	0x98FA, { 0xEC, 0x84, 0xA8 },
	0x98FB, { 0xEC, 0x84, 0xA9 },
	0x98FC, { 0xEC, 0x84, 0xAA },
	0x98FD, { 0xEC, 0x84, 0xAB },
	0x98FE, { 0xEC, 0x84, 0xAE },
	0x9941, { 0xEC, 0x84, 0xB2 },
	0x9942, { 0xEC, 0x84, 0xB3 },
	0x9943, { 0xEC, 0x84, 0xB4 },
	0x9944, { 0xEC, 0x84, 0xB5 },
	0x9945, { 0xEC, 0x84, 0xB7 },
	0x9946, { 0xEC, 0x84, 0xBA },
	0x9947, { 0xEC, 0x84, 0xBB },
	0x9948, { 0xEC, 0x84, 0xBD },
	0x9949, { 0xEC, 0x84, 0xBE },
	0x994A, { 0xEC, 0x84, 0xBF },
	0x994B, { 0xEC, 0x85, 0x81 },
	0x994C, { 0xEC, 0x85, 0x82 },
	0x994D, { 0xEC, 0x85, 0x83 },
	0x994E, { 0xEC, 0x85, 0x84 },
	0x994F, { 0xEC, 0x85, 0x85 },
	0x9950, { 0xEC, 0x85, 0x86 },
	0x9951, { 0xEC, 0x85, 0x87 },
	0x9952, { 0xEC, 0x85, 0x8A },
	0x9953, { 0xEC, 0x85, 0x8E },
	0x9954, { 0xEC, 0x85, 0x8F },
	0x9955, { 0xEC, 0x85, 0x90 },
	0x9956, { 0xEC, 0x85, 0x91 },
	0x9957, { 0xEC, 0x85, 0x92 },
	0x9958, { 0xEC, 0x85, 0x93 },
	0x9959, { 0xEC, 0x85, 0x96 },
	0x995A, { 0xEC, 0x85, 0x97 },
	0x9961, { 0xEC, 0x85, 0x99 },
	0x9962, { 0xEC, 0x85, 0x9A },
	0x9963, { 0xEC, 0x85, 0x9B },
	0x9964, { 0xEC, 0x85, 0x9D },
	0x9965, { 0xEC, 0x85, 0x9E },
	0x9966, { 0xEC, 0x85, 0x9F },
	0x9967, { 0xEC, 0x85, 0xA0 },
	0x9968, { 0xEC, 0x85, 0xA1 },
	0x9969, { 0xEC, 0x85, 0xA2 },
	0x996A, { 0xEC, 0x85, 0xA3 },
	0x996B, { 0xEC, 0x85, 0xA6 },
	0x996C, { 0xEC, 0x85, 0xAA },
	0x996D, { 0xEC, 0x85, 0xAB },
	0x996E, { 0xEC, 0x85, 0xAC },
	0x996F, { 0xEC, 0x85, 0xAD },
	0x9970, { 0xEC, 0x85, 0xAE },
	0x9971, { 0xEC, 0x85, 0xAF },
	0x9972, { 0xEC, 0x85, 0xB1 },
	0x9973, { 0xEC, 0x85, 0xB2 },
	0x9974, { 0xEC, 0x85, 0xB3 },
	0x9975, { 0xEC, 0x85, 0xB5 },
	0x9976, { 0xEC, 0x85, 0xB6 },
	0x9977, { 0xEC, 0x85, 0xB7 },
	0x9978, { 0xEC, 0x85, 0xB9 },
	0x9979, { 0xEC, 0x85, 0xBA },
	0x997A, { 0xEC, 0x85, 0xBB },
	0x9981, { 0xEC, 0x85, 0xBC },
	0x9982, { 0xEC, 0x85, 0xBD },
	0x9983, { 0xEC, 0x85, 0xBE },
	0x9984, { 0xEC, 0x85, 0xBF },
	0x9985, { 0xEC, 0x86, 0x80 },
	0x9986, { 0xEC, 0x86, 0x81 },
	0x9987, { 0xEC, 0x86, 0x82 },
	0x9988, { 0xEC, 0x86, 0x83 },
	0x9989, { 0xEC, 0x86, 0x84 },
	0x998A, { 0xEC, 0x86, 0x86 },
	0x998B, { 0xEC, 0x86, 0x87 },
	0x998C, { 0xEC, 0x86, 0x88 },
	0x998D, { 0xEC, 0x86, 0x89 },
	0x998E, { 0xEC, 0x86, 0x8A },
	0x998F, { 0xEC, 0x86, 0x8B },
	0x9990, { 0xEC, 0x86, 0x8F },
	0x9991, { 0xEC, 0x86, 0x91 },
	0x9992, { 0xEC, 0x86, 0x92 },
	0x9993, { 0xEC, 0x86, 0x93 },
	0x9994, { 0xEC, 0x86, 0x95 },
	0x9995, { 0xEC, 0x86, 0x97 },
	0x9996, { 0xEC, 0x86, 0x98 },
	0x9997, { 0xEC, 0x86, 0x99 },
	0x9998, { 0xEC, 0x86, 0x9A },
	0x9999, { 0xEC, 0x86, 0x9B },
	0x999A, { 0xEC, 0x86, 0x9E },
	0x999B, { 0xEC, 0x86, 0xA0 },
	0x999C, { 0xEC, 0x86, 0xA2 },
	0x999D, { 0xEC, 0x86, 0xA3 },
	0x999E, { 0xEC, 0x86, 0xA4 },
	0x999F, { 0xEC, 0x86, 0xA6 },
	0x99A0, { 0xEC, 0x86, 0xA7 },
	0x99A1, { 0xEC, 0x86, 0xAA },
	0x99A2, { 0xEC, 0x86, 0xAB },
	0x99A3, { 0xEC, 0x86, 0xAD },
	0x99A4, { 0xEC, 0x86, 0xAE },
	0x99A5, { 0xEC, 0x86, 0xAF },
	0x99A6, { 0xEC, 0x86, 0xB1 },
	0x99A7, { 0xEC, 0x86, 0xB2 },
	0x99A8, { 0xEC, 0x86, 0xB3 },
	0x99A9, { 0xEC, 0x86, 0xB4 },
	0x99AA, { 0xEC, 0x86, 0xB5 },
	0x99AB, { 0xEC, 0x86, 0xB6 },
	0x99AC, { 0xEC, 0x86, 0xB7 },
	0x99AD, { 0xEC, 0x86, 0xB8 },
	0x99AE, { 0xEC, 0x86, 0xB9 },
	0x99AF, { 0xEC, 0x86, 0xBA },
	0x99B0, { 0xEC, 0x86, 0xBB },
	0x99B1, { 0xEC, 0x86, 0xBC },
	0x99B2, { 0xEC, 0x86, 0xBE },
	0x99B3, { 0xEC, 0x86, 0xBF },
	0x99B4, { 0xEC, 0x87, 0x80 },
	0x99B5, { 0xEC, 0x87, 0x81 },
	0x99B6, { 0xEC, 0x87, 0x82 },
	0x99B7, { 0xEC, 0x87, 0x83 },
	0x99B8, { 0xEC, 0x87, 0x85 },
	0x99B9, { 0xEC, 0x87, 0x86 },
	0x99BA, { 0xEC, 0x87, 0x87 },
	0x99BB, { 0xEC, 0x87, 0x89 },
	0x99BC, { 0xEC, 0x87, 0x8A },
	0x99BD, { 0xEC, 0x87, 0x8B },
	0x99BE, { 0xEC, 0x87, 0x8D },
	0x99BF, { 0xEC, 0x87, 0x8E },
	0x99C0, { 0xEC, 0x87, 0x8F },
	0x99C1, { 0xEC, 0x87, 0x90 },
	0x99C2, { 0xEC, 0x87, 0x91 },
	0x99C3, { 0xEC, 0x87, 0x92 },
	0x99C4, { 0xEC, 0x87, 0x93 },
	0x99C5, { 0xEC, 0x87, 0x95 },
	0x99C6, { 0xEC, 0x87, 0x96 },
	0x99C7, { 0xEC, 0x87, 0x99 },
	0x99C8, { 0xEC, 0x87, 0x9A },
	0x99C9, { 0xEC, 0x87, 0x9B },
	0x99CA, { 0xEC, 0x87, 0x9C },
	0x99CB, { 0xEC, 0x87, 0x9D },
	0x99CC, { 0xEC, 0x87, 0x9E },
	0x99CD, { 0xEC, 0x87, 0x9F },
	0x99CE, { 0xEC, 0x87, 0xA1 },
	0x99CF, { 0xEC, 0x87, 0xA2 },
	0x99D0, { 0xEC, 0x87, 0xA3 },
	0x99D1, { 0xEC, 0x87, 0xA5 },
	0x99D2, { 0xEC, 0x87, 0xA6 },
	0x99D3, { 0xEC, 0x87, 0xA7 },
	0x99D4, { 0xEC, 0x87, 0xA9 },
	0x99D5, { 0xEC, 0x87, 0xAA },
	0x99D6, { 0xEC, 0x87, 0xAB },
	0x99D7, { 0xEC, 0x87, 0xAC },
	0x99D8, { 0xEC, 0x87, 0xAD },
	0x99D9, { 0xEC, 0x87, 0xAE },
	0x99DA, { 0xEC, 0x87, 0xAF },
	0x99DB, { 0xEC, 0x87, 0xB2 },
	0x99DC, { 0xEC, 0x87, 0xB4 },
	0x99DD, { 0xEC, 0x87, 0xB5 },
	0x99DE, { 0xEC, 0x87, 0xB6 },
	0x99DF, { 0xEC, 0x87, 0xB7 },
	0x99E0, { 0xEC, 0x87, 0xB8 },
	0x99E1, { 0xEC, 0x87, 0xB9 },
	0x99E2, { 0xEC, 0x87, 0xBA },
	0x99E3, { 0xEC, 0x87, 0xBB },
	0x99E4, { 0xEC, 0x87, 0xBE },
	0x99E5, { 0xEC, 0x87, 0xBF },
	0x99E6, { 0xEC, 0x88, 0x81 },
	0x99E7, { 0xEC, 0x88, 0x82 },
	0x99E8, { 0xEC, 0x88, 0x83 },
	0x99E9, { 0xEC, 0x88, 0x85 },
	0x99EA, { 0xEC, 0x88, 0x86 },
	0x99EB, { 0xEC, 0x88, 0x87 },
	0x99EC, { 0xEC, 0x88, 0x88 },
	0x99ED, { 0xEC, 0x88, 0x89 },
	0x99EE, { 0xEC, 0x88, 0x8A },
	0x99EF, { 0xEC, 0x88, 0x8B },
	0x99F0, { 0xEC, 0x88, 0x8E },
	0x99F1, { 0xEC, 0x88, 0x90 },
	0x99F2, { 0xEC, 0x88, 0x92 },
	0x99F3, { 0xEC, 0x88, 0x93 },
	0x99F4, { 0xEC, 0x88, 0x94 },
	0x99F5, { 0xEC, 0x88, 0x95 },
	0x99F6, { 0xEC, 0x88, 0x96 },
	0x99F7, { 0xEC, 0x88, 0x97 },
	0x99F8, { 0xEC, 0x88, 0x9A },
	0x99F9, { 0xEC, 0x88, 0x9B },
	0x99FA, { 0xEC, 0x88, 0x9D },
	0x99FB, { 0xEC, 0x88, 0x9E },
	0x99FC, { 0xEC, 0x88, 0xA1 },
	0x99FD, { 0xEC, 0x88, 0xA2 },
	0x99FE, { 0xEC, 0x88, 0xA3 },
	0x9A41, { 0xEC, 0x88, 0xA4 },
	0x9A42, { 0xEC, 0x88, 0xA5 },
	0x9A43, { 0xEC, 0x88, 0xA6 },
	0x9A44, { 0xEC, 0x88, 0xA7 },
	0x9A45, { 0xEC, 0x88, 0xAA },
	0x9A46, { 0xEC, 0x88, 0xAC },
	0x9A47, { 0xEC, 0x88, 0xAE },
	0x9A48, { 0xEC, 0x88, 0xB0 },
	0x9A49, { 0xEC, 0x88, 0xB3 },
	0x9A4A, { 0xEC, 0x88, 0xB5 },
	0x9A4B, { 0xEC, 0x88, 0xB6 },
	0x9A4C, { 0xEC, 0x88, 0xB7 },
	0x9A4D, { 0xEC, 0x88, 0xB8 },
	0x9A4E, { 0xEC, 0x88, 0xB9 },
	0x9A4F, { 0xEC, 0x88, 0xBA },
	0x9A50, { 0xEC, 0x88, 0xBB },
	0x9A51, { 0xEC, 0x88, 0xBC },
	0x9A52, { 0xEC, 0x88, 0xBD },
	0x9A53, { 0xEC, 0x88, 0xBE },
	0x9A54, { 0xEC, 0x88, 0xBF },
	0x9A55, { 0xEC, 0x89, 0x80 },
	0x9A56, { 0xEC, 0x89, 0x81 },
	0x9A57, { 0xEC, 0x89, 0x82 },
	0x9A58, { 0xEC, 0x89, 0x83 },
	0x9A59, { 0xEC, 0x89, 0x84 },
	0x9A5A, { 0xEC, 0x89, 0x85 },
	0x9A61, { 0xEC, 0x89, 0x86 },
	0x9A62, { 0xEC, 0x89, 0x87 },
	0x9A63, { 0xEC, 0x89, 0x89 },
	0x9A64, { 0xEC, 0x89, 0x8A },
	0x9A65, { 0xEC, 0x89, 0x8B },
	0x9A66, { 0xEC, 0x89, 0x8C },
	0x9A67, { 0xEC, 0x89, 0x8D },
	0x9A68, { 0xEC, 0x89, 0x8E },
	0x9A69, { 0xEC, 0x89, 0x8F },
	0x9A6A, { 0xEC, 0x89, 0x92 },
	0x9A6B, { 0xEC, 0x89, 0x93 },
	0x9A6C, { 0xEC, 0x89, 0x95 },
	0x9A6D, { 0xEC, 0x89, 0x96 },
	0x9A6E, { 0xEC, 0x89, 0x97 },
	0x9A6F, { 0xEC, 0x89, 0x99 },
	0x9A70, { 0xEC, 0x89, 0x9A },
	0x9A71, { 0xEC, 0x89, 0x9B },
	0x9A72, { 0xEC, 0x89, 0x9C },
	0x9A73, { 0xEC, 0x89, 0x9D },
	0x9A74, { 0xEC, 0x89, 0x9E },
	0x9A75, { 0xEC, 0x89, 0x9F },
	0x9A76, { 0xEC, 0x89, 0xA1 },
	0x9A77, { 0xEC, 0x89, 0xA2 },
	0x9A78, { 0xEC, 0x89, 0xA3 },
	0x9A79, { 0xEC, 0x89, 0xA4 },
	0x9A7A, { 0xEC, 0x89, 0xA6 },
	0x9A81, { 0xEC, 0x89, 0xA7 },
	0x9A82, { 0xEC, 0x89, 0xA8 },
	0x9A83, { 0xEC, 0x89, 0xA9 },
	0x9A84, { 0xEC, 0x89, 0xAA },
	0x9A85, { 0xEC, 0x89, 0xAB },
	0x9A86, { 0xEC, 0x89, 0xAE },
	0x9A87, { 0xEC, 0x89, 0xAF },
	0x9A88, { 0xEC, 0x89, 0xB1 },
	0x9A89, { 0xEC, 0x89, 0xB2 },
	0x9A8A, { 0xEC, 0x89, 0xB3 },
	0x9A8B, { 0xEC, 0x89, 0xB5 },
	0x9A8C, { 0xEC, 0x89, 0xB6 },
	0x9A8D, { 0xEC, 0x89, 0xB7 },
	0x9A8E, { 0xEC, 0x89, 0xB8 },
	0x9A8F, { 0xEC, 0x89, 0xB9 },
	0x9A90, { 0xEC, 0x89, 0xBA },
	0x9A91, { 0xEC, 0x89, 0xBB },
	0x9A92, { 0xEC, 0x89, 0xBE },
	0x9A93, { 0xEC, 0x8A, 0x80 },
	0x9A94, { 0xEC, 0x8A, 0x82 },
	0x9A95, { 0xEC, 0x8A, 0x83 },
	0x9A96, { 0xEC, 0x8A, 0x84 },
	0x9A97, { 0xEC, 0x8A, 0x85 },
	0x9A98, { 0xEC, 0x8A, 0x86 },
	0x9A99, { 0xEC, 0x8A, 0x87 },
	0x9A9A, { 0xEC, 0x8A, 0x8A },
	0x9A9B, { 0xEC, 0x8A, 0x8B },
	0x9A9C, { 0xEC, 0x8A, 0x8C },
	0x9A9D, { 0xEC, 0x8A, 0x8D },
	0x9A9E, { 0xEC, 0x8A, 0x8E },
	0x9A9F, { 0xEC, 0x8A, 0x8F },
	0x9AA0, { 0xEC, 0x8A, 0x91 },
	0x9AA1, { 0xEC, 0x8A, 0x92 },
	0x9AA2, { 0xEC, 0x8A, 0x93 },
	0x9AA3, { 0xEC, 0x8A, 0x94 },
	0x9AA4, { 0xEC, 0x8A, 0x95 },
	0x9AA5, { 0xEC, 0x8A, 0x96 },
	0x9AA6, { 0xEC, 0x8A, 0x97 },
	0x9AA7, { 0xEC, 0x8A, 0x99 },
	0x9AA8, { 0xEC, 0x8A, 0x9A },
	0x9AA9, { 0xEC, 0x8A, 0x9C },
	0x9AAA, { 0xEC, 0x8A, 0x9E },
	0x9AAB, { 0xEC, 0x8A, 0x9F },
	0x9AAC, { 0xEC, 0x8A, 0xA0 },
	0x9AAD, { 0xEC, 0x8A, 0xA1 },
	0x9AAE, { 0xEC, 0x8A, 0xA2 },
	0x9AAF, { 0xEC, 0x8A, 0xA3 },
	0x9AB0, { 0xEC, 0x8A, 0xA6 },
	0x9AB1, { 0xEC, 0x8A, 0xA7 },
	0x9AB2, { 0xEC, 0x8A, 0xA9 },
	0x9AB3, { 0xEC, 0x8A, 0xAA },
	0x9AB4, { 0xEC, 0x8A, 0xAB },
	0x9AB5, { 0xEC, 0x8A, 0xAE },
	0x9AB6, { 0xEC, 0x8A, 0xAF },
	0x9AB7, { 0xEC, 0x8A, 0xB0 },
	0x9AB8, { 0xEC, 0x8A, 0xB1 },
	0x9AB9, { 0xEC, 0x8A, 0xB2 },
	0x9ABA, { 0xEC, 0x8A, 0xB3 },
	0x9ABB, { 0xEC, 0x8A, 0xB6 },
	0x9ABC, { 0xEC, 0x8A, 0xB8 },
	0x9ABD, { 0xEC, 0x8A, 0xBA },
	0x9ABE, { 0xEC, 0x8A, 0xBB },
	0x9ABF, { 0xEC, 0x8A, 0xBC },
	0x9AC0, { 0xEC, 0x8A, 0xBD },
	0x9AC1, { 0xEC, 0x8A, 0xBE },
	0x9AC2, { 0xEC, 0x8A, 0xBF },
	0x9AC3, { 0xEC, 0x8B, 0x80 },
	0x9AC4, { 0xEC, 0x8B, 0x81 },
	0x9AC5, { 0xEC, 0x8B, 0x82 },
	0x9AC6, { 0xEC, 0x8B, 0x83 },
	0x9AC7, { 0xEC, 0x8B, 0x84 },
	0x9AC8, { 0xEC, 0x8B, 0x85 },
	0x9AC9, { 0xEC, 0x8B, 0x86 },
	0x9ACA, { 0xEC, 0x8B, 0x87 },
	0x9ACB, { 0xEC, 0x8B, 0x88 },
	0x9ACC, { 0xEC, 0x8B, 0x89 },
	0x9ACD, { 0xEC, 0x8B, 0x8A },
	0x9ACE, { 0xEC, 0x8B, 0x8B },
	0x9ACF, { 0xEC, 0x8B, 0x8C },
	0x9AD0, { 0xEC, 0x8B, 0x8D },
	0x9AD1, { 0xEC, 0x8B, 0x8E },
	0x9AD2, { 0xEC, 0x8B, 0x8F },
	0x9AD3, { 0xEC, 0x8B, 0x90 },
	0x9AD4, { 0xEC, 0x8B, 0x91 },
	0x9AD5, { 0xEC, 0x8B, 0x92 },
	0x9AD6, { 0xEC, 0x8B, 0x93 },
	0x9AD7, { 0xEC, 0x8B, 0x94 },
	0x9AD8, { 0xEC, 0x8B, 0x95 },
	0x9AD9, { 0xEC, 0x8B, 0x96 },
	0x9ADA, { 0xEC, 0x8B, 0x97 },
	0x9ADB, { 0xEC, 0x8B, 0x98 },
	0x9ADC, { 0xEC, 0x8B, 0x99 },
	0x9ADD, { 0xEC, 0x8B, 0x9A },
	0x9ADE, { 0xEC, 0x8B, 0x9B },
	0x9ADF, { 0xEC, 0x8B, 0x9E },
	0x9AE0, { 0xEC, 0x8B, 0x9F },
	0x9AE1, { 0xEC, 0x8B, 0xA1 },
	0x9AE2, { 0xEC, 0x8B, 0xA2 },
	0x9AE3, { 0xEC, 0x8B, 0xA5 },
	0x9AE4, { 0xEC, 0x8B, 0xA6 },
	0x9AE5, { 0xEC, 0x8B, 0xA7 },
	0x9AE6, { 0xEC, 0x8B, 0xA8 },
	0x9AE7, { 0xEC, 0x8B, 0xA9 },
	0x9AE8, { 0xEC, 0x8B, 0xAA },
	0x9AE9, { 0xEC, 0x8B, 0xAE },
	0x9AEA, { 0xEC, 0x8B, 0xB0 },
	0x9AEB, { 0xEC, 0x8B, 0xB2 },
	0x9AEC, { 0xEC, 0x8B, 0xB3 },
	0x9AED, { 0xEC, 0x8B, 0xB4 },
	0x9AEE, { 0xEC, 0x8B, 0xB5 },
	0x9AEF, { 0xEC, 0x8B, 0xB7 },
	0x9AF0, { 0xEC, 0x8B, 0xBA },
	0x9AF1, { 0xEC, 0x8B, 0xBD },
	0x9AF2, { 0xEC, 0x8B, 0xBE },
	0x9AF3, { 0xEC, 0x8B, 0xBF },
	0x9AF4, { 0xEC, 0x8C, 0x81 },
	0x9AF5, { 0xEC, 0x8C, 0x82 },
	0x9AF6, { 0xEC, 0x8C, 0x83 },
	0x9AF7, { 0xEC, 0x8C, 0x84 },
	0x9AF8, { 0xEC, 0x8C, 0x85 },
	0x9AF9, { 0xEC, 0x8C, 0x86 },
	0x9AFA, { 0xEC, 0x8C, 0x87 },
	0x9AFB, { 0xEC, 0x8C, 0x8A },
	0x9AFC, { 0xEC, 0x8C, 0x8B },
	0x9AFD, { 0xEC, 0x8C, 0x8E },
	0x9AFE, { 0xEC, 0x8C, 0x8F },
	0x9B41, { 0xEC, 0x8C, 0x90 },
	0x9B42, { 0xEC, 0x8C, 0x91 },
	0x9B43, { 0xEC, 0x8C, 0x92 },
	0x9B44, { 0xEC, 0x8C, 0x96 },
	0x9B45, { 0xEC, 0x8C, 0x97 },
	0x9B46, { 0xEC, 0x8C, 0x99 },
	0x9B47, { 0xEC, 0x8C, 0x9A },
	0x9B48, { 0xEC, 0x8C, 0x9B },
	0x9B49, { 0xEC, 0x8C, 0x9D },
	0x9B4A, { 0xEC, 0x8C, 0x9E },
	0x9B4B, { 0xEC, 0x8C, 0x9F },
	0x9B4C, { 0xEC, 0x8C, 0xA0 },
	0x9B4D, { 0xEC, 0x8C, 0xA1 },
	0x9B4E, { 0xEC, 0x8C, 0xA2 },
	0x9B4F, { 0xEC, 0x8C, 0xA3 },
	0x9B50, { 0xEC, 0x8C, 0xA6 },
	0x9B51, { 0xEC, 0x8C, 0xA7 },
	0x9B52, { 0xEC, 0x8C, 0xAA },
	0x9B53, { 0xEC, 0x8C, 0xAB },
	0x9B54, { 0xEC, 0x8C, 0xAC },
	0x9B55, { 0xEC, 0x8C, 0xAD },
	0x9B56, { 0xEC, 0x8C, 0xAE },
	0x9B57, { 0xEC, 0x8C, 0xAF },
	0x9B58, { 0xEC, 0x8C, 0xB0 },
	0x9B59, { 0xEC, 0x8C, 0xB1 },
	0x9B5A, { 0xEC, 0x8C, 0xB2 },
	0x9B61, { 0xEC, 0x8C, 0xB3 },
	0x9B62, { 0xEC, 0x8C, 0xB4 },
	0x9B63, { 0xEC, 0x8C, 0xB5 },
	0x9B64, { 0xEC, 0x8C, 0xB6 },
	0x9B65, { 0xEC, 0x8C, 0xB7 },
	0x9B66, { 0xEC, 0x8C, 0xB8 },
	0x9B67, { 0xEC, 0x8C, 0xB9 },
	0x9B68, { 0xEC, 0x8C, 0xBA },
	0x9B69, { 0xEC, 0x8C, 0xBB },
	0x9B6A, { 0xEC, 0x8C, 0xBC },
	0x9B6B, { 0xEC, 0x8C, 0xBD },
	0x9B6C, { 0xEC, 0x8C, 0xBE },
	0x9B6D, { 0xEC, 0x8C, 0xBF },
	0x9B6E, { 0xEC, 0x8D, 0x80 },
	0x9B6F, { 0xEC, 0x8D, 0x81 },
	0x9B70, { 0xEC, 0x8D, 0x82 },
	0x9B71, { 0xEC, 0x8D, 0x83 },
	0x9B72, { 0xEC, 0x8D, 0x84 },
	0x9B73, { 0xEC, 0x8D, 0x86 },
	0x9B74, { 0xEC, 0x8D, 0x87 },
	0x9B75, { 0xEC, 0x8D, 0x88 },
	0x9B76, { 0xEC, 0x8D, 0x89 },
	0x9B77, { 0xEC, 0x8D, 0x8A },
	0x9B78, { 0xEC, 0x8D, 0x8B },
	0x9B79, { 0xEC, 0x8D, 0x8C },
	0x9B7A, { 0xEC, 0x8D, 0x8D },
	0x9B81, { 0xEC, 0x8D, 0x8E },
	0x9B82, { 0xEC, 0x8D, 0x8F },
	0x9B83, { 0xEC, 0x8D, 0x90 },
	0x9B84, { 0xEC, 0x8D, 0x91 },
	0x9B85, { 0xEC, 0x8D, 0x92 },
	0x9B86, { 0xEC, 0x8D, 0x93 },
	0x9B87, { 0xEC, 0x8D, 0x94 },
	0x9B88, { 0xEC, 0x8D, 0x95 },
	0x9B89, { 0xEC, 0x8D, 0x96 },
	0x9B8A, { 0xEC, 0x8D, 0x97 },
	0x9B8B, { 0xEC, 0x8D, 0x98 },
	0x9B8C, { 0xEC, 0x8D, 0x99 },
	0x9B8D, { 0xEC, 0x8D, 0x9A },
	0x9B8E, { 0xEC, 0x8D, 0x9B },
	0x9B8F, { 0xEC, 0x8D, 0x9C },
	0x9B90, { 0xEC, 0x8D, 0x9D },
	0x9B91, { 0xEC, 0x8D, 0x9E },
	0x9B92, { 0xEC, 0x8D, 0x9F },
	0x9B93, { 0xEC, 0x8D, 0xA0 },
	0x9B94, { 0xEC, 0x8D, 0xA1 },
	0x9B95, { 0xEC, 0x8D, 0xA2 },
	0x9B96, { 0xEC, 0x8D, 0xA3 },
	0x9B97, { 0xEC, 0x8D, 0xA4 },
	0x9B98, { 0xEC, 0x8D, 0xA5 },
	0x9B99, { 0xEC, 0x8D, 0xA6 },
	0x9B9A, { 0xEC, 0x8D, 0xA7 },
	0x9B9B, { 0xEC, 0x8D, 0xAA },
	0x9B9C, { 0xEC, 0x8D, 0xAB },
	0x9B9D, { 0xEC, 0x8D, 0xAD },
	0x9B9E, { 0xEC, 0x8D, 0xAE },
	0x9B9F, { 0xEC, 0x8D, 0xAF },
	0x9BA0, { 0xEC, 0x8D, 0xB1 },
	0x9BA1, { 0xEC, 0x8D, 0xB3 },
	0x9BA2, { 0xEC, 0x8D, 0xB4 },
	0x9BA3, { 0xEC, 0x8D, 0xB5 },
	0x9BA4, { 0xEC, 0x8D, 0xB6 },
	0x9BA5, { 0xEC, 0x8D, 0xB7 },
	0x9BA6, { 0xEC, 0x8D, 0xBA },
	0x9BA7, { 0xEC, 0x8D, 0xBB },
	0x9BA8, { 0xEC, 0x8D, 0xBE },
	0x9BA9, { 0xEC, 0x8D, 0xBF },
	0x9BAA, { 0xEC, 0x8E, 0x80 },
	0x9BAB, { 0xEC, 0x8E, 0x81 },
	0x9BAC, { 0xEC, 0x8E, 0x82 },
	0x9BAD, { 0xEC, 0x8E, 0x83 },
	0x9BAE, { 0xEC, 0x8E, 0x85 },
	0x9BAF, { 0xEC, 0x8E, 0x86 },
	0x9BB0, { 0xEC, 0x8E, 0x87 },
	0x9BB1, { 0xEC, 0x8E, 0x89 },
	0x9BB2, { 0xEC, 0x8E, 0x8A },
	0x9BB3, { 0xEC, 0x8E, 0x8B },
	0x9BB4, { 0xEC, 0x8E, 0x8D },
	0x9BB5, { 0xEC, 0x8E, 0x8E },
	0x9BB6, { 0xEC, 0x8E, 0x8F },
	0x9BB7, { 0xEC, 0x8E, 0x90 },
	0x9BB8, { 0xEC, 0x8E, 0x91 },
	0x9BB9, { 0xEC, 0x8E, 0x92 },
	0x9BBA, { 0xEC, 0x8E, 0x93 },
	0x9BBB, { 0xEC, 0x8E, 0x94 },
	0x9BBC, { 0xEC, 0x8E, 0x95 },
	0x9BBD, { 0xEC, 0x8E, 0x96 },
	0x9BBE, { 0xEC, 0x8E, 0x97 },
	0x9BBF, { 0xEC, 0x8E, 0x98 },
	0x9BC0, { 0xEC, 0x8E, 0x99 },
	0x9BC1, { 0xEC, 0x8E, 0x9A },
	0x9BC2, { 0xEC, 0x8E, 0x9B },
	0x9BC3, { 0xEC, 0x8E, 0x9C },
	0x9BC4, { 0xEC, 0x8E, 0x9D },
	0x9BC5, { 0xEC, 0x8E, 0x9E },
	0x9BC6, { 0xEC, 0x8E, 0x9F },
	0x9BC7, { 0xEC, 0x8E, 0xA0 },
	0x9BC8, { 0xEC, 0x8E, 0xA1 },
	0x9BC9, { 0xEC, 0x8E, 0xA2 },
	0x9BCA, { 0xEC, 0x8E, 0xA3 },
	0x9BCB, { 0xEC, 0x8E, 0xA4 },
	0x9BCC, { 0xEC, 0x8E, 0xA5 },
	0x9BCD, { 0xEC, 0x8E, 0xA6 },
	0x9BCE, { 0xEC, 0x8E, 0xA7 },
	0x9BCF, { 0xEC, 0x8E, 0xA8 },
	0x9BD0, { 0xEC, 0x8E, 0xA9 },
	0x9BD1, { 0xEC, 0x8E, 0xAA },
	0x9BD2, { 0xEC, 0x8E, 0xAB },
	0x9BD3, { 0xEC, 0x8E, 0xAC },
	0x9BD4, { 0xEC, 0x8E, 0xAD },
	0x9BD5, { 0xEC, 0x8E, 0xAE },
	0x9BD6, { 0xEC, 0x8E, 0xAF },
	0x9BD7, { 0xEC, 0x8E, 0xB0 },
	0x9BD8, { 0xEC, 0x8E, 0xB1 },
	0x9BD9, { 0xEC, 0x8E, 0xB2 },
	0x9BDA, { 0xEC, 0x8E, 0xB3 },
	0x9BDB, { 0xEC, 0x8E, 0xB4 },
	0x9BDC, { 0xEC, 0x8E, 0xB5 },
	0x9BDD, { 0xEC, 0x8E, 0xB6 },
	0x9BDE, { 0xEC, 0x8E, 0xB7 },
	0x9BDF, { 0xEC, 0x8E, 0xB8 },
	0x9BE0, { 0xEC, 0x8E, 0xB9 },
	0x9BE1, { 0xEC, 0x8E, 0xBA },
	0x9BE2, { 0xEC, 0x8E, 0xBB },
	0x9BE3, { 0xEC, 0x8E, 0xBC },
	0x9BE4, { 0xEC, 0x8E, 0xBD },
	0x9BE5, { 0xEC, 0x8E, 0xBE },
	0x9BE6, { 0xEC, 0x8E, 0xBF },
	0x9BE7, { 0xEC, 0x8F, 0x81 },
	0x9BE8, { 0xEC, 0x8F, 0x82 },
	0x9BE9, { 0xEC, 0x8F, 0x83 },
	0x9BEA, { 0xEC, 0x8F, 0x84 },
	0x9BEB, { 0xEC, 0x8F, 0x85 },
	0x9BEC, { 0xEC, 0x8F, 0x86 },
	0x9BED, { 0xEC, 0x8F, 0x87 },
	0x9BEE, { 0xEC, 0x8F, 0x88 },
	0x9BEF, { 0xEC, 0x8F, 0x89 },
	0x9BF0, { 0xEC, 0x8F, 0x8A },
	0x9BF1, { 0xEC, 0x8F, 0x8B },
	0x9BF2, { 0xEC, 0x8F, 0x8C },
	0x9BF3, { 0xEC, 0x8F, 0x8D },
	0x9BF4, { 0xEC, 0x8F, 0x8E },
	0x9BF5, { 0xEC, 0x8F, 0x8F },
	0x9BF6, { 0xEC, 0x8F, 0x90 },
	0x9BF7, { 0xEC, 0x8F, 0x91 },
	0x9BF8, { 0xEC, 0x8F, 0x92 },
	0x9BF9, { 0xEC, 0x8F, 0x93 },
	0x9BFA, { 0xEC, 0x8F, 0x94 },
	0x9BFB, { 0xEC, 0x8F, 0x95 },
	0x9BFC, { 0xEC, 0x8F, 0x96 },
	0x9BFD, { 0xEC, 0x8F, 0x97 },
	0x9BFE, { 0xEC, 0x8F, 0x9A },
	0x9C41, { 0xEC, 0x8F, 0x9B },
	0x9C42, { 0xEC, 0x8F, 0x9D },
	0x9C43, { 0xEC, 0x8F, 0x9E },
	0x9C44, { 0xEC, 0x8F, 0xA1 },
	0x9C45, { 0xEC, 0x8F, 0xA3 },
	0x9C46, { 0xEC, 0x8F, 0xA4 },
	0x9C47, { 0xEC, 0x8F, 0xA5 },
	0x9C48, { 0xEC, 0x8F, 0xA6 },
	0x9C49, { 0xEC, 0x8F, 0xA7 },
	0x9C4A, { 0xEC, 0x8F, 0xAA },
	0x9C4B, { 0xEC, 0x8F, 0xAB },
	0x9C4C, { 0xEC, 0x8F, 0xAC },
	0x9C4D, { 0xEC, 0x8F, 0xAE },
	0x9C4E, { 0xEC, 0x8F, 0xAF },
	0x9C4F, { 0xEC, 0x8F, 0xB0 },
	0x9C50, { 0xEC, 0x8F, 0xB1 },
	0x9C51, { 0xEC, 0x8F, 0xB2 },
	0x9C52, { 0xEC, 0x8F, 0xB3 },
	0x9C53, { 0xEC, 0x8F, 0xB6 },
	0x9C54, { 0xEC, 0x8F, 0xB7 },
	0x9C55, { 0xEC, 0x8F, 0xB9 },
	0x9C56, { 0xEC, 0x8F, 0xBA },
	0x9C57, { 0xEC, 0x8F, 0xBB },
	0x9C58, { 0xEC, 0x8F, 0xBC },
	0x9C59, { 0xEC, 0x8F, 0xBD },
	0x9C5A, { 0xEC, 0x8F, 0xBE },
	0x9C61, { 0xEC, 0x8F, 0xBF },
	0x9C62, { 0xEC, 0x90, 0x80 },
	0x9C63, { 0xEC, 0x90, 0x81 },
	0x9C64, { 0xEC, 0x90, 0x82 },
	0x9C65, { 0xEC, 0x90, 0x83 },
	0x9C66, { 0xEC, 0x90, 0x84 },
	0x9C67, { 0xEC, 0x90, 0x85 },
	0x9C68, { 0xEC, 0x90, 0x86 },
	0x9C69, { 0xEC, 0x90, 0x87 },
	0x9C6A, { 0xEC, 0x90, 0x89 },
	0x9C6B, { 0xEC, 0x90, 0x8A },
	0x9C6C, { 0xEC, 0x90, 0x8B },
	0x9C6D, { 0xEC, 0x90, 0x8C },
	0x9C6E, { 0xEC, 0x90, 0x8D },
	0x9C6F, { 0xEC, 0x90, 0x8E },
	0x9C70, { 0xEC, 0x90, 0x8F },
	0x9C71, { 0xEC, 0x90, 0x91 },
	0x9C72, { 0xEC, 0x90, 0x92 },
	0x9C73, { 0xEC, 0x90, 0x93 },
	0x9C74, { 0xEC, 0x90, 0x94 },
	0x9C75, { 0xEC, 0x90, 0x95 },
	0x9C76, { 0xEC, 0x90, 0x96 },
	0x9C77, { 0xEC, 0x90, 0x97 },
	0x9C78, { 0xEC, 0x90, 0x98 },
	0x9C79, { 0xEC, 0x90, 0x99 },
	0x9C7A, { 0xEC, 0x90, 0x9A },
	0x9C81, { 0xEC, 0x90, 0x9B },
	0x9C82, { 0xEC, 0x90, 0x9C },
	0x9C83, { 0xEC, 0x90, 0x9D },
	0x9C84, { 0xEC, 0x90, 0x9E },
	0x9C85, { 0xEC, 0x90, 0x9F },
	0x9C86, { 0xEC, 0x90, 0xA0 },
	0x9C87, { 0xEC, 0x90, 0xA1 },
	0x9C88, { 0xEC, 0x90, 0xA2 },
	0x9C89, { 0xEC, 0x90, 0xA3 },
	0x9C8A, { 0xEC, 0x90, 0xA5 },
	0x9C8B, { 0xEC, 0x90, 0xA6 },
	0x9C8C, { 0xEC, 0x90, 0xA7 },
	0x9C8D, { 0xEC, 0x90, 0xA8 },
	0x9C8E, { 0xEC, 0x90, 0xA9 },
	0x9C8F, { 0xEC, 0x90, 0xAA },
	0x9C90, { 0xEC, 0x90, 0xAB },
	0x9C91, { 0xEC, 0x90, 0xAD },
	0x9C92, { 0xEC, 0x90, 0xAE },
	0x9C93, { 0xEC, 0x90, 0xAF },
	0x9C94, { 0xEC, 0x90, 0xB1 },
	0x9C95, { 0xEC, 0x90, 0xB2 },
	0x9C96, { 0xEC, 0x90, 0xB3 },
	0x9C97, { 0xEC, 0x90, 0xB5 },
	0x9C98, { 0xEC, 0x90, 0xB6 },
	0x9C99, { 0xEC, 0x90, 0xB7 },
	0x9C9A, { 0xEC, 0x90, 0xB8 },
	0x9C9B, { 0xEC, 0x90, 0xB9 },
	0x9C9C, { 0xEC, 0x90, 0xBA },
	0x9C9D, { 0xEC, 0x90, 0xBB },
	0x9C9E, { 0xEC, 0x90, 0xBE },
	0x9C9F, { 0xEC, 0x90, 0xBF },
	0x9CA0, { 0xEC, 0x91, 0x80 },
	0x9CA1, { 0xEC, 0x91, 0x81 },
	0x9CA2, { 0xEC, 0x91, 0x82 },
	0x9CA3, { 0xEC, 0x91, 0x83 },
	0x9CA4, { 0xEC, 0x91, 0x84 },
	0x9CA5, { 0xEC, 0x91, 0x85 },
	0x9CA6, { 0xEC, 0x91, 0x86 },
	0x9CA7, { 0xEC, 0x91, 0x87 },
	0x9CA8, { 0xEC, 0x91, 0x89 },
	0x9CA9, { 0xEC, 0x91, 0x8A },
	0x9CAA, { 0xEC, 0x91, 0x8B },
	0x9CAB, { 0xEC, 0x91, 0x8C },
	0x9CAC, { 0xEC, 0x91, 0x8D },
	0x9CAD, { 0xEC, 0x91, 0x8E },
	0x9CAE, { 0xEC, 0x91, 0x8F },
	0x9CAF, { 0xEC, 0x91, 0x90 },
	0x9CB0, { 0xEC, 0x91, 0x91 },
	0x9CB1, { 0xEC, 0x91, 0x92 },
	0x9CB2, { 0xEC, 0x91, 0x93 },
	0x9CB3, { 0xEC, 0x91, 0x94 },
	0x9CB4, { 0xEC, 0x91, 0x95 },
	0x9CB5, { 0xEC, 0x91, 0x96 },
	0x9CB6, { 0xEC, 0x91, 0x97 },
	0x9CB7, { 0xEC, 0x91, 0x98 },
	0x9CB8, { 0xEC, 0x91, 0x99 },
	0x9CB9, { 0xEC, 0x91, 0x9A },
	0x9CBA, { 0xEC, 0x91, 0x9B },
	0x9CBB, { 0xEC, 0x91, 0x9C },
	0x9CBC, { 0xEC, 0x91, 0x9D },
	0x9CBD, { 0xEC, 0x91, 0x9E },
	0x9CBE, { 0xEC, 0x91, 0x9F },
	0x9CBF, { 0xEC, 0x91, 0xA0 },
	0x9CC0, { 0xEC, 0x91, 0xA1 },
	0x9CC1, { 0xEC, 0x91, 0xA2 },
	0x9CC2, { 0xEC, 0x91, 0xA3 },
	0x9CC3, { 0xEC, 0x91, 0xA6 },
	0x9CC4, { 0xEC, 0x91, 0xA7 },
	0x9CC5, { 0xEC, 0x91, 0xA9 },
	0x9CC6, { 0xEC, 0x91, 0xAA },
	0x9CC7, { 0xEC, 0x91, 0xAB },
	0x9CC8, { 0xEC, 0x91, 0xAD },
	0x9CC9, { 0xEC, 0x91, 0xAE },
	0x9CCA, { 0xEC, 0x91, 0xAF },
	0x9CCB, { 0xEC, 0x91, 0xB0 },
	0x9CCC, { 0xEC, 0x91, 0xB1 },
	0x9CCD, { 0xEC, 0x91, 0xB2 },
	0x9CCE, { 0xEC, 0x91, 0xB3 },
	0x9CCF, { 0xEC, 0x91, 0xB6 },
	0x9CD0, { 0xEC, 0x91, 0xB7 },
	0x9CD1, { 0xEC, 0x91, 0xB8 },
	0x9CD2, { 0xEC, 0x91, 0xBA },
	0x9CD3, { 0xEC, 0x91, 0xBB },
	0x9CD4, { 0xEC, 0x91, 0xBC },
	0x9CD5, { 0xEC, 0x91, 0xBD },
	0x9CD6, { 0xEC, 0x91, 0xBE },
	0x9CD7, { 0xEC, 0x91, 0xBF },
	0x9CD8, { 0xEC, 0x92, 0x81 },
	0x9CD9, { 0xEC, 0x92, 0x82 },
	0x9CDA, { 0xEC, 0x92, 0x83 },
	0x9CDB, { 0xEC, 0x92, 0x84 },
	0x9CDC, { 0xEC, 0x92, 0x85 },
	0x9CDD, { 0xEC, 0x92, 0x86 },
	0x9CDE, { 0xEC, 0x92, 0x87 },
	0x9CDF, { 0xEC, 0x92, 0x88 },
	0x9CE0, { 0xEC, 0x92, 0x89 },
	0x9CE1, { 0xEC, 0x92, 0x8A },
	0x9CE2, { 0xEC, 0x92, 0x8B },
	0x9CE3, { 0xEC, 0x92, 0x8C },
	0x9CE4, { 0xEC, 0x92, 0x8D },
	0x9CE5, { 0xEC, 0x92, 0x8E },
	0x9CE6, { 0xEC, 0x92, 0x8F },
	0x9CE7, { 0xEC, 0x92, 0x90 },
	0x9CE8, { 0xEC, 0x92, 0x91 },
	0x9CE9, { 0xEC, 0x92, 0x92 },
	0x9CEA, { 0xEC, 0x92, 0x93 },
	0x9CEB, { 0xEC, 0x92, 0x95 },
	0x9CEC, { 0xEC, 0x92, 0x96 },
	0x9CED, { 0xEC, 0x92, 0x97 },
	0x9CEE, { 0xEC, 0x92, 0x98 },
	0x9CEF, { 0xEC, 0x92, 0x99 },
	0x9CF0, { 0xEC, 0x92, 0x9A },
	0x9CF1, { 0xEC, 0x92, 0x9B },
	0x9CF2, { 0xEC, 0x92, 0x9D },
	0x9CF3, { 0xEC, 0x92, 0x9E },
	0x9CF4, { 0xEC, 0x92, 0x9F },
	0x9CF5, { 0xEC, 0x92, 0xA0 },
	0x9CF6, { 0xEC, 0x92, 0xA1 },
	0x9CF7, { 0xEC, 0x92, 0xA2 },
	0x9CF8, { 0xEC, 0x92, 0xA3 },
	0x9CF9, { 0xEC, 0x92, 0xA4 },
	0x9CFA, { 0xEC, 0x92, 0xA5 },
	0x9CFB, { 0xEC, 0x92, 0xA6 },
	0x9CFC, { 0xEC, 0x92, 0xA7 },
	0x9CFD, { 0xEC, 0x92, 0xA8 },
	0x9CFE, { 0xEC, 0x92, 0xA9 },
	0x9D41, { 0xEC, 0x92, 0xAA },
	0x9D42, { 0xEC, 0x92, 0xAB },
	0x9D43, { 0xEC, 0x92, 0xAC },
	0x9D44, { 0xEC, 0x92, 0xAD },
	0x9D45, { 0xEC, 0x92, 0xAE },
	0x9D46, { 0xEC, 0x92, 0xAF },
	0x9D47, { 0xEC, 0x92, 0xB0 },
	0x9D48, { 0xEC, 0x92, 0xB1 },
	0x9D49, { 0xEC, 0x92, 0xB2 },
	0x9D4A, { 0xEC, 0x92, 0xB3 },
	0x9D4B, { 0xEC, 0x92, 0xB4 },
	0x9D4C, { 0xEC, 0x92, 0xB5 },
	0x9D4D, { 0xEC, 0x92, 0xB6 },
	0x9D4E, { 0xEC, 0x92, 0xB7 },
	0x9D4F, { 0xEC, 0x92, 0xB9 },
	0x9D50, { 0xEC, 0x92, 0xBA },
	0x9D51, { 0xEC, 0x92, 0xBB },
	0x9D52, { 0xEC, 0x92, 0xBD },
	0x9D53, { 0xEC, 0x92, 0xBE },
	0x9D54, { 0xEC, 0x92, 0xBF },
	0x9D55, { 0xEC, 0x93, 0x80 },
	0x9D56, { 0xEC, 0x93, 0x81 },
	0x9D57, { 0xEC, 0x93, 0x82 },
	0x9D58, { 0xEC, 0x93, 0x83 },
	0x9D59, { 0xEC, 0x93, 0x84 },
	0x9D5A, { 0xEC, 0x93, 0x85 },
	0x9D61, { 0xEC, 0x93, 0x86 },
	0x9D62, { 0xEC, 0x93, 0x87 },
	0x9D63, { 0xEC, 0x93, 0x88 },
	0x9D64, { 0xEC, 0x93, 0x89 },
	0x9D65, { 0xEC, 0x93, 0x8A },
	0x9D66, { 0xEC, 0x93, 0x8B },
	0x9D67, { 0xEC, 0x93, 0x8C },
	0x9D68, { 0xEC, 0x93, 0x8D },
	0x9D69, { 0xEC, 0x93, 0x8E },
	0x9D6A, { 0xEC, 0x93, 0x8F },
	0x9D6B, { 0xEC, 0x93, 0x90 },
	0x9D6C, { 0xEC, 0x93, 0x91 },
	0x9D6D, { 0xEC, 0x93, 0x92 },
	0x9D6E, { 0xEC, 0x93, 0x93 },
	0x9D6F, { 0xEC, 0x93, 0x94 },
	0x9D70, { 0xEC, 0x93, 0x95 },
	0x9D71, { 0xEC, 0x93, 0x96 },
	0x9D72, { 0xEC, 0x93, 0x97 },
	0x9D73, { 0xEC, 0x93, 0x98 },
	0x9D74, { 0xEC, 0x93, 0x99 },
	0x9D75, { 0xEC, 0x93, 0x9A },
	0x9D76, { 0xEC, 0x93, 0x9B },
	0x9D77, { 0xEC, 0x93, 0x9C },
	0x9D78, { 0xEC, 0x93, 0x9D },
	0x9D79, { 0xEC, 0x93, 0x9E },
	0x9D7A, { 0xEC, 0x93, 0x9F },
	0x9D81, { 0xEC, 0x93, 0xA0 },
	0x9D82, { 0xEC, 0x93, 0xA1 },
	0x9D83, { 0xEC, 0x93, 0xA2 },
	0x9D84, { 0xEC, 0x93, 0xA3 },
	0x9D85, { 0xEC, 0x93, 0xA4 },
	0x9D86, { 0xEC, 0x93, 0xA5 },
	0x9D87, { 0xEC, 0x93, 0xA6 },
	0x9D88, { 0xEC, 0x93, 0xA7 },
	0x9D89, { 0xEC, 0x93, 0xA8 },
	0x9D8A, { 0xEC, 0x93, 0xAA },
	0x9D8B, { 0xEC, 0x93, 0xAB },
	0x9D8C, { 0xEC, 0x93, 0xAC },
	0x9D8D, { 0xEC, 0x93, 0xAD },
	0x9D8E, { 0xEC, 0x93, 0xAE },
	0x9D8F, { 0xEC, 0x93, 0xAF },
	0x9D90, { 0xEC, 0x93, 0xB2 },
	0x9D91, { 0xEC, 0x93, 0xB3 },
	0x9D92, { 0xEC, 0x93, 0xB5 },
	0x9D93, { 0xEC, 0x93, 0xB6 },
	0x9D94, { 0xEC, 0x93, 0xB7 },
	0x9D95, { 0xEC, 0x93, 0xB9 },
	0x9D96, { 0xEC, 0x93, 0xBB },
	0x9D97, { 0xEC, 0x93, 0xBC },
	0x9D98, { 0xEC, 0x93, 0xBD },
	0x9D99, { 0xEC, 0x93, 0xBE },
	0x9D9A, { 0xEC, 0x94, 0x82 },
	0x9D9B, { 0xEC, 0x94, 0x83 },
	0x9D9C, { 0xEC, 0x94, 0x84 },
	0x9D9D, { 0xEC, 0x94, 0x85 },
	0x9D9E, { 0xEC, 0x94, 0x86 },
	0x9D9F, { 0xEC, 0x94, 0x87 },
	0x9DA0, { 0xEC, 0x94, 0x88 },
	0x9DA1, { 0xEC, 0x94, 0x89 },
	0x9DA2, { 0xEC, 0x94, 0x8A },
	0x9DA3, { 0xEC, 0x94, 0x8B },
	0x9DA4, { 0xEC, 0x94, 0x8D },
	0x9DA5, { 0xEC, 0x94, 0x8E },
	0x9DA6, { 0xEC, 0x94, 0x8F },
	0x9DA7, { 0xEC, 0x94, 0x91 },
	0x9DA8, { 0xEC, 0x94, 0x92 },
	0x9DA9, { 0xEC, 0x94, 0x93 },
	0x9DAA, { 0xEC, 0x94, 0x95 },
	0x9DAB, { 0xEC, 0x94, 0x96 },
	0x9DAC, { 0xEC, 0x94, 0x97 },
	0x9DAD, { 0xEC, 0x94, 0x98 },
	0x9DAE, { 0xEC, 0x94, 0x99 },
	0x9DAF, { 0xEC, 0x94, 0x9A },
	0x9DB0, { 0xEC, 0x94, 0x9B },
	0x9DB1, { 0xEC, 0x94, 0x9D },
	0x9DB2, { 0xEC, 0x94, 0x9E },
	0x9DB3, { 0xEC, 0x94, 0x9F },
	0x9DB4, { 0xEC, 0x94, 0xA0 },
	0x9DB5, { 0xEC, 0x94, 0xA1 },
	0x9DB6, { 0xEC, 0x94, 0xA2 },
	0x9DB7, { 0xEC, 0x94, 0xA3 },
	0x9DB8, { 0xEC, 0x94, 0xA4 },
	0x9DB9, { 0xEC, 0x94, 0xA5 },
	0x9DBA, { 0xEC, 0x94, 0xA6 },
	0x9DBB, { 0xEC, 0x94, 0xA7 },
	0x9DBC, { 0xEC, 0x94, 0xAA },
	0x9DBD, { 0xEC, 0x94, 0xAB },
	0x9DBE, { 0xEC, 0x94, 0xAD },
	0x9DBF, { 0xEC, 0x94, 0xAE },
	0x9DC0, { 0xEC, 0x94, 0xAF },
	0x9DC1, { 0xEC, 0x94, 0xB1 },
	0x9DC2, { 0xEC, 0x94, 0xB2 },
	0x9DC3, { 0xEC, 0x94, 0xB3 },
	0x9DC4, { 0xEC, 0x94, 0xB4 },
	0x9DC5, { 0xEC, 0x94, 0xB5 },
	0x9DC6, { 0xEC, 0x94, 0xB6 },
	0x9DC7, { 0xEC, 0x94, 0xB7 },
	0x9DC8, { 0xEC, 0x94, 0xBA },
	0x9DC9, { 0xEC, 0x94, 0xBC },
	0x9DCA, { 0xEC, 0x94, 0xBE },
	0x9DCB, { 0xEC, 0x94, 0xBF },
	0x9DCC, { 0xEC, 0x95, 0x80 },
	0x9DCD, { 0xEC, 0x95, 0x81 },
	0x9DCE, { 0xEC, 0x95, 0x82 },
	0x9DCF, { 0xEC, 0x95, 0x83 },
	0x9DD0, { 0xEC, 0x95, 0x86 },
	0x9DD1, { 0xEC, 0x95, 0x87 },
	0x9DD2, { 0xEC, 0x95, 0x8B },
	0x9DD3, { 0xEC, 0x95, 0x8F },
	0x9DD4, { 0xEC, 0x95, 0x90 },
	0x9DD5, { 0xEC, 0x95, 0x91 },
	0x9DD6, { 0xEC, 0x95, 0x92 },
	0x9DD7, { 0xEC, 0x95, 0x96 },
	0x9DD8, { 0xEC, 0x95, 0x9A },
	0x9DD9, { 0xEC, 0x95, 0x9B },
	0x9DDA, { 0xEC, 0x95, 0x9C },
	0x9DDB, { 0xEC, 0x95, 0x9F },
	0x9DDC, { 0xEC, 0x95, 0xA2 },
	0x9DDD, { 0xEC, 0x95, 0xA3 },
	0x9DDE, { 0xEC, 0x95, 0xA5 },
	0x9DDF, { 0xEC, 0x95, 0xA6 },
	0x9DE0, { 0xEC, 0x95, 0xA7 },
	0x9DE1, { 0xEC, 0x95, 0xA9 },
	0x9DE2, { 0xEC, 0x95, 0xAA },
	0x9DE3, { 0xEC, 0x95, 0xAB },
	0x9DE4, { 0xEC, 0x95, 0xAC },
	0x9DE5, { 0xEC, 0x95, 0xAD },
	0x9DE6, { 0xEC, 0x95, 0xAE },
	0x9DE7, { 0xEC, 0x95, 0xAF },
	0x9DE8, { 0xEC, 0x95, 0xB2 },
	0x9DE9, { 0xEC, 0x95, 0xB6 },
	0x9DEA, { 0xEC, 0x95, 0xB7 },
	0x9DEB, { 0xEC, 0x95, 0xB8 },
	0x9DEC, { 0xEC, 0x95, 0xB9 },
	0x9DED, { 0xEC, 0x95, 0xBA },
	0x9DEE, { 0xEC, 0x95, 0xBB },
	0x9DEF, { 0xEC, 0x95, 0xBE },
	0x9DF0, { 0xEC, 0x95, 0xBF },
	0x9DF1, { 0xEC, 0x96, 0x81 },
	0x9DF2, { 0xEC, 0x96, 0x82 },
	0x9DF3, { 0xEC, 0x96, 0x83 },
	0x9DF4, { 0xEC, 0x96, 0x85 },
	0x9DF5, { 0xEC, 0x96, 0x86 },
	0x9DF6, { 0xEC, 0x96, 0x88 },
	0x9DF7, { 0xEC, 0x96, 0x89 },
	0x9DF8, { 0xEC, 0x96, 0x8A },
	0x9DF9, { 0xEC, 0x96, 0x8B },
	0x9DFA, { 0xEC, 0x96, 0x8E },
	0x9DFB, { 0xEC, 0x96, 0x90 },
	0x9DFC, { 0xEC, 0x96, 0x92 },
	0x9DFD, { 0xEC, 0x96, 0x93 },
	0x9DFE, { 0xEC, 0x96, 0x94 },
	0x9E41, { 0xEC, 0x96, 0x96 },
	0x9E42, { 0xEC, 0x96, 0x99 },
	0x9E43, { 0xEC, 0x96, 0x9A },
	0x9E44, { 0xEC, 0x96, 0x9B },
	0x9E45, { 0xEC, 0x96, 0x9D },
	0x9E46, { 0xEC, 0x96, 0x9E },
	0x9E47, { 0xEC, 0x96, 0x9F },
	0x9E48, { 0xEC, 0x96, 0xA1 },
	0x9E49, { 0xEC, 0x96, 0xA2 },
	0x9E4A, { 0xEC, 0x96, 0xA3 },
	0x9E4B, { 0xEC, 0x96, 0xA4 },
	0x9E4C, { 0xEC, 0x96, 0xA5 },
	0x9E4D, { 0xEC, 0x96, 0xA6 },
	0x9E4E, { 0xEC, 0x96, 0xA7 },
	0x9E4F, { 0xEC, 0x96, 0xA8 },
	0x9E50, { 0xEC, 0x96, 0xAA },
	0x9E51, { 0xEC, 0x96, 0xAB },
	0x9E52, { 0xEC, 0x96, 0xAC },
	0x9E53, { 0xEC, 0x96, 0xAD },
	0x9E54, { 0xEC, 0x96, 0xAE },
	0x9E55, { 0xEC, 0x96, 0xAF },
	0x9E56, { 0xEC, 0x96, 0xB0 },
	0x9E57, { 0xEC, 0x96, 0xB1 },
	0x9E58, { 0xEC, 0x96, 0xB2 },
	0x9E59, { 0xEC, 0x96, 0xB3 },
	0x9E5A, { 0xEC, 0x96, 0xB6 },
	0x9E61, { 0xEC, 0x96, 0xB7 },
	0x9E62, { 0xEC, 0x96, 0xBA },
	0x9E63, { 0xEC, 0x96, 0xBF },
	0x9E64, { 0xEC, 0x97, 0x80 },
	0x9E65, { 0xEC, 0x97, 0x81 },
	0x9E66, { 0xEC, 0x97, 0x82 },
	0x9E67, { 0xEC, 0x97, 0x83 },
	0x9E68, { 0xEC, 0x97, 0x8B },
	0x9E69, { 0xEC, 0x97, 0x8D },
	0x9E6A, { 0xEC, 0x97, 0x8F },
	0x9E6B, { 0xEC, 0x97, 0x92 },
	0x9E6C, { 0xEC, 0x97, 0x93 },
	0x9E6D, { 0xEC, 0x97, 0x95 },
	0x9E6E, { 0xEC, 0x97, 0x96 },
	0x9E6F, { 0xEC, 0x97, 0x97 },
	0x9E70, { 0xEC, 0x97, 0x99 },
	0x9E71, { 0xEC, 0x97, 0x9A },
	0x9E72, { 0xEC, 0x97, 0x9B },
	0x9E73, { 0xEC, 0x97, 0x9C },
	0x9E74, { 0xEC, 0x97, 0x9D },
	0x9E75, { 0xEC, 0x97, 0x9E },
	0x9E76, { 0xEC, 0x97, 0x9F },
	0x9E77, { 0xEC, 0x97, 0xA2 },
	0x9E78, { 0xEC, 0x97, 0xA4 },
	0x9E79, { 0xEC, 0x97, 0xA6 },
	0x9E7A, { 0xEC, 0x97, 0xA7 },
	0x9E81, { 0xEC, 0x97, 0xA8 },
	0x9E82, { 0xEC, 0x97, 0xA9 },
	0x9E83, { 0xEC, 0x97, 0xAA },
	0x9E84, { 0xEC, 0x97, 0xAB },
	0x9E85, { 0xEC, 0x97, 0xAF },
	0x9E86, { 0xEC, 0x97, 0xB1 },
	0x9E87, { 0xEC, 0x97, 0xB2 },
	0x9E88, { 0xEC, 0x97, 0xB3 },
	0x9E89, { 0xEC, 0x97, 0xB5 },
	0x9E8A, { 0xEC, 0x97, 0xB8 },
	0x9E8B, { 0xEC, 0x97, 0xB9 },
	0x9E8C, { 0xEC, 0x97, 0xBA },
	0x9E8D, { 0xEC, 0x97, 0xBB },
	0x9E8E, { 0xEC, 0x98, 0x82 },
	0x9E8F, { 0xEC, 0x98, 0x83 },
	0x9E90, { 0xEC, 0x98, 0x84 },
	0x9E91, { 0xEC, 0x98, 0x89 },
	0x9E92, { 0xEC, 0x98, 0x8A },
	0x9E93, { 0xEC, 0x98, 0x8B },
	0x9E94, { 0xEC, 0x98, 0x8D },
	0x9E95, { 0xEC, 0x98, 0x8E },
	0x9E96, { 0xEC, 0x98, 0x8F },
	0x9E97, { 0xEC, 0x98, 0x91 },
	0x9E98, { 0xEC, 0x98, 0x92 },
	0x9E99, { 0xEC, 0x98, 0x93 },
	0x9E9A, { 0xEC, 0x98, 0x94 },
	0x9E9B, { 0xEC, 0x98, 0x95 },
	0x9E9C, { 0xEC, 0x98, 0x96 },
	0x9E9D, { 0xEC, 0x98, 0x97 },
	0x9E9E, { 0xEC, 0x98, 0x9A },
	0x9E9F, { 0xEC, 0x98, 0x9D },
	0x9EA0, { 0xEC, 0x98, 0x9E },
	0x9EA1, { 0xEC, 0x98, 0x9F },
	0x9EA2, { 0xEC, 0x98, 0xA0 },
	0x9EA3, { 0xEC, 0x98, 0xA1 },
	0x9EA4, { 0xEC, 0x98, 0xA2 },
	0x9EA5, { 0xEC, 0x98, 0xA3 },
	0x9EA6, { 0xEC, 0x98, 0xA6 },
	0x9EA7, { 0xEC, 0x98, 0xA7 },
	0x9EA8, { 0xEC, 0x98, 0xA9 },
	0x9EA9, { 0xEC, 0x98, 0xAA },
	0x9EAA, { 0xEC, 0x98, 0xAB },
	0x9EAB, { 0xEC, 0x98, 0xAF },
	0x9EAC, { 0xEC, 0x98, 0xB1 },
	0x9EAD, { 0xEC, 0x98, 0xB2 },
	0x9EAE, { 0xEC, 0x98, 0xB6 },
	0x9EAF, { 0xEC, 0x98, 0xB8 },
	0x9EB0, { 0xEC, 0x98, 0xBA },
	0x9EB1, { 0xEC, 0x98, 0xBC },
	0x9EB2, { 0xEC, 0x98, 0xBD },
	0x9EB3, { 0xEC, 0x98, 0xBE },
	0x9EB4, { 0xEC, 0x98, 0xBF },
	0x9EB5, { 0xEC, 0x99, 0x82 },
	0x9EB6, { 0xEC, 0x99, 0x83 },
	0x9EB7, { 0xEC, 0x99, 0x85 },
	0x9EB8, { 0xEC, 0x99, 0x86 },
	0x9EB9, { 0xEC, 0x99, 0x87 },
	0x9EBA, { 0xEC, 0x99, 0x89 },
	0x9EBB, { 0xEC, 0x99, 0x8A },
	0x9EBC, { 0xEC, 0x99, 0x8B },
	0x9EBD, { 0xEC, 0x99, 0x8C },
	0x9EBE, { 0xEC, 0x99, 0x8D },
	0x9EBF, { 0xEC, 0x99, 0x8E },
	0x9EC0, { 0xEC, 0x99, 0x8F },
	0x9EC1, { 0xEC, 0x99, 0x92 },
	0x9EC2, { 0xEC, 0x99, 0x96 },
	0x9EC3, { 0xEC, 0x99, 0x97 },
	0x9EC4, { 0xEC, 0x99, 0x98 },
	0x9EC5, { 0xEC, 0x99, 0x99 },
	0x9EC6, { 0xEC, 0x99, 0x9A },
	0x9EC7, { 0xEC, 0x99, 0x9B },
	0x9EC8, { 0xEC, 0x99, 0x9E },
	0x9EC9, { 0xEC, 0x99, 0x9F },
	0x9ECA, { 0xEC, 0x99, 0xA1 },
	0x9ECB, { 0xEC, 0x99, 0xA2 },
	0x9ECC, { 0xEC, 0x99, 0xA3 },
	0x9ECD, { 0xEC, 0x99, 0xA4 },
	0x9ECE, { 0xEC, 0x99, 0xA5 },
	0x9ECF, { 0xEC, 0x99, 0xA6 },
	0x9ED0, { 0xEC, 0x99, 0xA7 },
	0x9ED1, { 0xEC, 0x99, 0xA8 },
	0x9ED2, { 0xEC, 0x99, 0xA9 },
	0x9ED3, { 0xEC, 0x99, 0xAA },
	0x9ED4, { 0xEC, 0x99, 0xAB },
	0x9ED5, { 0xEC, 0x99, 0xAD },
	0x9ED6, { 0xEC, 0x99, 0xAE },
	0x9ED7, { 0xEC, 0x99, 0xB0 },
	0x9ED8, { 0xEC, 0x99, 0xB2 },
	0x9ED9, { 0xEC, 0x99, 0xB3 },
	0x9EDA, { 0xEC, 0x99, 0xB4 },
	0x9EDB, { 0xEC, 0x99, 0xB5 },
	0x9EDC, { 0xEC, 0x99, 0xB6 },
	0x9EDD, { 0xEC, 0x99, 0xB7 },
	0x9EDE, { 0xEC, 0x99, 0xBA },
	0x9EDF, { 0xEC, 0x99, 0xBB },
	0x9EE0, { 0xEC, 0x99, 0xBD },
	0x9EE1, { 0xEC, 0x99, 0xBE },
	0x9EE2, { 0xEC, 0x99, 0xBF },
	0x9EE3, { 0xEC, 0x9A, 0x81 },
	0x9EE4, { 0xEC, 0x9A, 0x82 },
	0x9EE5, { 0xEC, 0x9A, 0x83 },
	0x9EE6, { 0xEC, 0x9A, 0x84 },
	0x9EE7, { 0xEC, 0x9A, 0x85 },
	0x9EE8, { 0xEC, 0x9A, 0x86 },
	0x9EE9, { 0xEC, 0x9A, 0x87 },
	0x9EEA, { 0xEC, 0x9A, 0x8A },
	0x9EEB, { 0xEC, 0x9A, 0x8C },
	0x9EEC, { 0xEC, 0x9A, 0x8E },
	0x9EED, { 0xEC, 0x9A, 0x8F },
	0x9EEE, { 0xEC, 0x9A, 0x90 },
	0x9EEF, { 0xEC, 0x9A, 0x91 },
	0x9EF0, { 0xEC, 0x9A, 0x92 },
	0x9EF1, { 0xEC, 0x9A, 0x93 },
	0x9EF2, { 0xEC, 0x9A, 0x96 },
	0x9EF3, { 0xEC, 0x9A, 0x97 },
	0x9EF4, { 0xEC, 0x9A, 0x99 },
	0x9EF5, { 0xEC, 0x9A, 0x9A },
	0x9EF6, { 0xEC, 0x9A, 0x9B },
	0x9EF7, { 0xEC, 0x9A, 0x9D },
	0x9EF8, { 0xEC, 0x9A, 0x9E },
	0x9EF9, { 0xEC, 0x9A, 0x9F },
	0x9EFA, { 0xEC, 0x9A, 0xA0 },
	0x9EFB, { 0xEC, 0x9A, 0xA1 },
	0x9EFC, { 0xEC, 0x9A, 0xA2 },
	0x9EFD, { 0xEC, 0x9A, 0xA3 },
	0x9EFE, { 0xEC, 0x9A, 0xA6 },
	0x9F41, { 0xEC, 0x9A, 0xA8 },
	0x9F42, { 0xEC, 0x9A, 0xAA },
	0x9F43, { 0xEC, 0x9A, 0xAB },
	0x9F44, { 0xEC, 0x9A, 0xAC },
	0x9F45, { 0xEC, 0x9A, 0xAD },
	0x9F46, { 0xEC, 0x9A, 0xAE },
	0x9F47, { 0xEC, 0x9A, 0xAF },
	0x9F48, { 0xEC, 0x9A, 0xB2 },
	0x9F49, { 0xEC, 0x9A, 0xB3 },
	0x9F4A, { 0xEC, 0x9A, 0xB5 },
	0x9F4B, { 0xEC, 0x9A, 0xB6 },
	0x9F4C, { 0xEC, 0x9A, 0xB7 },
	0x9F4D, { 0xEC, 0x9A, 0xBB },
	0x9F4E, { 0xEC, 0x9A, 0xBC },
	0x9F4F, { 0xEC, 0x9A, 0xBD },
	0x9F50, { 0xEC, 0x9A, 0xBE },
	0x9F51, { 0xEC, 0x9A, 0xBF },
	0x9F52, { 0xEC, 0x9B, 0x82 },
	0x9F53, { 0xEC, 0x9B, 0x84 },
	0x9F54, { 0xEC, 0x9B, 0x86 },
	0x9F55, { 0xEC, 0x9B, 0x87 },
	0x9F56, { 0xEC, 0x9B, 0x88 },
	0x9F57, { 0xEC, 0x9B, 0x89 },
	0x9F58, { 0xEC, 0x9B, 0x8A },
	0x9F59, { 0xEC, 0x9B, 0x8B },
	0x9F5A, { 0xEC, 0x9B, 0x8E },
	0x9F61, { 0xEC, 0x9B, 0x8F },
	0x9F62, { 0xEC, 0x9B, 0x91 },
	0x9F63, { 0xEC, 0x9B, 0x92 },
	0x9F64, { 0xEC, 0x9B, 0x93 },
	0x9F65, { 0xEC, 0x9B, 0x95 },
	0x9F66, { 0xEC, 0x9B, 0x96 },
	0x9F67, { 0xEC, 0x9B, 0x97 },
	0x9F68, { 0xEC, 0x9B, 0x98 },
	0x9F69, { 0xEC, 0x9B, 0x99 },
	0x9F6A, { 0xEC, 0x9B, 0x9A },
	0x9F6B, { 0xEC, 0x9B, 0x9B },
	0x9F6C, { 0xEC, 0x9B, 0x9E },
	0x9F6D, { 0xEC, 0x9B, 0x9F },
	0x9F6E, { 0xEC, 0x9B, 0xA2 },
	0x9F6F, { 0xEC, 0x9B, 0xA3 },
	0x9F70, { 0xEC, 0x9B, 0xA4 },
	0x9F71, { 0xEC, 0x9B, 0xA5 },
	0x9F72, { 0xEC, 0x9B, 0xA6 },
	0x9F73, { 0xEC, 0x9B, 0xA7 },
	0x9F74, { 0xEC, 0x9B, 0xAA },
	0x9F75, { 0xEC, 0x9B, 0xAB },
	0x9F76, { 0xEC, 0x9B, 0xAD },
	0x9F77, { 0xEC, 0x9B, 0xAE },
	0x9F78, { 0xEC, 0x9B, 0xAF },
	0x9F79, { 0xEC, 0x9B, 0xB1 },
	0x9F7A, { 0xEC, 0x9B, 0xB2 },
	0x9F81, { 0xEC, 0x9B, 0xB3 },
	0x9F82, { 0xEC, 0x9B, 0xB4 },
	0x9F83, { 0xEC, 0x9B, 0xB5 },
	0x9F84, { 0xEC, 0x9B, 0xB6 },
	0x9F85, { 0xEC, 0x9B, 0xB7 },
	0x9F86, { 0xEC, 0x9B, 0xBA },
	0x9F87, { 0xEC, 0x9B, 0xBB },
	0x9F88, { 0xEC, 0x9B, 0xBC },
	0x9F89, { 0xEC, 0x9B, 0xBE },
	0x9F8A, { 0xEC, 0x9B, 0xBF },
	0x9F8B, { 0xEC, 0x9C, 0x80 },
	0x9F8C, { 0xEC, 0x9C, 0x81 },
	0x9F8D, { 0xEC, 0x9C, 0x82 },
	0x9F8E, { 0xEC, 0x9C, 0x83 },
	0x9F8F, { 0xEC, 0x9C, 0x86 },
	0x9F90, { 0xEC, 0x9C, 0x87 },
	0x9F91, { 0xEC, 0x9C, 0x89 },
	0x9F92, { 0xEC, 0x9C, 0x8A },
	0x9F93, { 0xEC, 0x9C, 0x8B },
	0x9F94, { 0xEC, 0x9C, 0x8D },
	0x9F95, { 0xEC, 0x9C, 0x8E },
	0x9F96, { 0xEC, 0x9C, 0x8F },
	0x9F97, { 0xEC, 0x9C, 0x90 },
	0x9F98, { 0xEC, 0x9C, 0x91 },
	0x9F99, { 0xEC, 0x9C, 0x92 },
	0x9F9A, { 0xEC, 0x9C, 0x93 },
	0x9F9B, { 0xEC, 0x9C, 0x96 },
	0x9F9C, { 0xEC, 0x9C, 0x98 },
	0x9F9D, { 0xEC, 0x9C, 0x9A },
	0x9F9E, { 0xEC, 0x9C, 0x9B },
	0x9F9F, { 0xEC, 0x9C, 0x9C },
	0x9FA0, { 0xEC, 0x9C, 0x9D },
	0x9FA1, { 0xEC, 0x9C, 0x9E },
	0x9FA2, { 0xEC, 0x9C, 0x9F },
	0x9FA3, { 0xEC, 0x9C, 0xA2 },
	0x9FA4, { 0xEC, 0x9C, 0xA3 },
	0x9FA5, { 0xEC, 0x9C, 0xA5 },
	0x9FA6, { 0xEC, 0x9C, 0xA6 },
	0x9FA7, { 0xEC, 0x9C, 0xA7 },
	0x9FA8, { 0xEC, 0x9C, 0xA9 },
	0x9FA9, { 0xEC, 0x9C, 0xAA },
	0x9FAA, { 0xEC, 0x9C, 0xAB },
	0x9FAB, { 0xEC, 0x9C, 0xAC },
	0x9FAC, { 0xEC, 0x9C, 0xAD },
	0x9FAD, { 0xEC, 0x9C, 0xAE },
	0x9FAE, { 0xEC, 0x9C, 0xAF },
	0x9FAF, { 0xEC, 0x9C, 0xB2 },
	0x9FB0, { 0xEC, 0x9C, 0xB4 },
	0x9FB1, { 0xEC, 0x9C, 0xB6 },
	0x9FB2, { 0xEC, 0x9C, 0xB8 },
	0x9FB3, { 0xEC, 0x9C, 0xB9 },
	0x9FB4, { 0xEC, 0x9C, 0xBA },
	0x9FB5, { 0xEC, 0x9C, 0xBB },
	0x9FB6, { 0xEC, 0x9C, 0xBE },
	0x9FB7, { 0xEC, 0x9C, 0xBF },
	0x9FB8, { 0xEC, 0x9D, 0x81 },
	0x9FB9, { 0xEC, 0x9D, 0x82 },
	0x9FBA, { 0xEC, 0x9D, 0x83 },
	0x9FBB, { 0xEC, 0x9D, 0x85 },
	0x9FBC, { 0xEC, 0x9D, 0x86 },
	0x9FBD, { 0xEC, 0x9D, 0x87 },
	0x9FBE, { 0xEC, 0x9D, 0x88 },
	0x9FBF, { 0xEC, 0x9D, 0x89 },
	0x9FC0, { 0xEC, 0x9D, 0x8B },
	0x9FC1, { 0xEC, 0x9D, 0x8E },
	0x9FC2, { 0xEC, 0x9D, 0x90 },
	0x9FC3, { 0xEC, 0x9D, 0x99 },
	0x9FC4, { 0xEC, 0x9D, 0x9A },
	0x9FC5, { 0xEC, 0x9D, 0x9B },
	0x9FC6, { 0xEC, 0x9D, 0x9D },
	0x9FC7, { 0xEC, 0x9D, 0x9E },
	0x9FC8, { 0xEC, 0x9D, 0x9F },
	0x9FC9, { 0xEC, 0x9D, 0xA1 },
	0x9FCA, { 0xEC, 0x9D, 0xA2 },
	0x9FCB, { 0xEC, 0x9D, 0xA3 },
	0x9FCC, { 0xEC, 0x9D, 0xA4 },
	0x9FCD, { 0xEC, 0x9D, 0xA5 },
	0x9FCE, { 0xEC, 0x9D, 0xA6 },
	0x9FCF, { 0xEC, 0x9D, 0xA7 },
	0x9FD0, { 0xEC, 0x9D, 0xA9 },
	0x9FD1, { 0xEC, 0x9D, 0xAA },
	0x9FD2, { 0xEC, 0x9D, 0xAC },
	0x9FD3, { 0xEC, 0x9D, 0xAD },
	0x9FD4, { 0xEC, 0x9D, 0xAE },
	0x9FD5, { 0xEC, 0x9D, 0xAF },
	0x9FD6, { 0xEC, 0x9D, 0xB0 },
	0x9FD7, { 0xEC, 0x9D, 0xB1 },
	0x9FD8, { 0xEC, 0x9D, 0xB2 },
	0x9FD9, { 0xEC, 0x9D, 0xB3 },
	0x9FDA, { 0xEC, 0x9D, 0xB6 },
	0x9FDB, { 0xEC, 0x9D, 0xB7 },
	0x9FDC, { 0xEC, 0x9D, 0xB9 },
	0x9FDD, { 0xEC, 0x9D, 0xBA },
	0x9FDE, { 0xEC, 0x9D, 0xBB },
	0x9FDF, { 0xEC, 0x9D, 0xBF },
	0x9FE0, { 0xEC, 0x9E, 0x80 },
	0x9FE1, { 0xEC, 0x9E, 0x81 },
	0x9FE2, { 0xEC, 0x9E, 0x82 },
	0x9FE3, { 0xEC, 0x9E, 0x86 },
	0x9FE4, { 0xEC, 0x9E, 0x8B },
	0x9FE5, { 0xEC, 0x9E, 0x8C },
	0x9FE6, { 0xEC, 0x9E, 0x8D },
	0x9FE7, { 0xEC, 0x9E, 0x8F },
	0x9FE8, { 0xEC, 0x9E, 0x92 },
	0x9FE9, { 0xEC, 0x9E, 0x93 },
	0x9FEA, { 0xEC, 0x9E, 0x95 },
	0x9FEB, { 0xEC, 0x9E, 0x99 },
	0x9FEC, { 0xEC, 0x9E, 0x9B },
	0x9FED, { 0xEC, 0x9E, 0x9C },
	0x9FEE, { 0xEC, 0x9E, 0x9D },
	0x9FEF, { 0xEC, 0x9E, 0x9E },
	0x9FF0, { 0xEC, 0x9E, 0x9F },
	0x9FF1, { 0xEC, 0x9E, 0xA2 },
	0x9FF2, { 0xEC, 0x9E, 0xA7 },
	0x9FF3, { 0xEC, 0x9E, 0xA8 },
	0x9FF4, { 0xEC, 0x9E, 0xA9 },
	0x9FF5, { 0xEC, 0x9E, 0xAA },
	0x9FF6, { 0xEC, 0x9E, 0xAB },
	0x9FF7, { 0xEC, 0x9E, 0xAE },
	0x9FF8, { 0xEC, 0x9E, 0xAF },
	0x9FF9, { 0xEC, 0x9E, 0xB1 },
	0x9FFA, { 0xEC, 0x9E, 0xB2 },
	0x9FFB, { 0xEC, 0x9E, 0xB3 },
	0x9FFC, { 0xEC, 0x9E, 0xB5 },
	0x9FFD, { 0xEC, 0x9E, 0xB6 },
	0x9FFE, { 0xEC, 0x9E, 0xB7 },
	0xA041, { 0xEC, 0x9E, 0xB8 },
	0xA042, { 0xEC, 0x9E, 0xB9 },
	0xA043, { 0xEC, 0x9E, 0xBA },
	0xA044, { 0xEC, 0x9E, 0xBB },
	0xA045, { 0xEC, 0x9E, 0xBE },
	0xA046, { 0xEC, 0x9F, 0x82 },
	0xA047, { 0xEC, 0x9F, 0x83 },
	0xA048, { 0xEC, 0x9F, 0x84 },
	0xA049, { 0xEC, 0x9F, 0x85 },
	0xA04A, { 0xEC, 0x9F, 0x86 },
	0xA04B, { 0xEC, 0x9F, 0x87 },
	0xA04C, { 0xEC, 0x9F, 0x8A },
	0xA04D, { 0xEC, 0x9F, 0x8B },
	0xA04E, { 0xEC, 0x9F, 0x8D },
	0xA04F, { 0xEC, 0x9F, 0x8F },
	0xA050, { 0xEC, 0x9F, 0x91 },
	0xA051, { 0xEC, 0x9F, 0x92 },
	0xA052, { 0xEC, 0x9F, 0x93 },
	0xA053, { 0xEC, 0x9F, 0x94 },
	0xA054, { 0xEC, 0x9F, 0x95 },
	0xA055, { 0xEC, 0x9F, 0x96 },
	0xA056, { 0xEC, 0x9F, 0x97 },
	0xA057, { 0xEC, 0x9F, 0x99 },
	0xA058, { 0xEC, 0x9F, 0x9A },
	0xA059, { 0xEC, 0x9F, 0x9B },
	0xA05A, { 0xEC, 0x9F, 0x9C },
	0xA061, { 0xEC, 0x9F, 0x9E },
	0xA062, { 0xEC, 0x9F, 0x9F },
	0xA063, { 0xEC, 0x9F, 0xA0 },
	0xA064, { 0xEC, 0x9F, 0xA1 },
	0xA065, { 0xEC, 0x9F, 0xA2 },
	0xA066, { 0xEC, 0x9F, 0xA3 },
	0xA067, { 0xEC, 0x9F, 0xA5 },
	0xA068, { 0xEC, 0x9F, 0xA6 },
	0xA069, { 0xEC, 0x9F, 0xA7 },
	0xA06A, { 0xEC, 0x9F, 0xA9 },
	0xA06B, { 0xEC, 0x9F, 0xAA },
	0xA06C, { 0xEC, 0x9F, 0xAB },
	0xA06D, { 0xEC, 0x9F, 0xAD },
	0xA06E, { 0xEC, 0x9F, 0xAE },
	0xA06F, { 0xEC, 0x9F, 0xAF },
	0xA070, { 0xEC, 0x9F, 0xB0 },
	0xA071, { 0xEC, 0x9F, 0xB1 },
	0xA072, { 0xEC, 0x9F, 0xB2 },
	0xA073, { 0xEC, 0x9F, 0xB3 },
	0xA074, { 0xEC, 0x9F, 0xB4 },
	0xA075, { 0xEC, 0x9F, 0xB5 },
	0xA076, { 0xEC, 0x9F, 0xB6 },
	0xA077, { 0xEC, 0x9F, 0xB7 },
	0xA078, { 0xEC, 0x9F, 0xB8 },
	0xA079, { 0xEC, 0x9F, 0xB9 },
	0xA07A, { 0xEC, 0x9F, 0xBA },
	0xA081, { 0xEC, 0x9F, 0xBB },
	0xA082, { 0xEC, 0x9F, 0xBC },
	0xA083, { 0xEC, 0x9F, 0xBD },
	0xA084, { 0xEC, 0x9F, 0xBE },
	0xA085, { 0xEC, 0x9F, 0xBF },
	0xA086, { 0xEC, 0xA0, 0x82 },
	0xA087, { 0xEC, 0xA0, 0x83 },
	0xA088, { 0xEC, 0xA0, 0x85 },
	0xA089, { 0xEC, 0xA0, 0x86 },
	0xA08A, { 0xEC, 0xA0, 0x87 },
	0xA08B, { 0xEC, 0xA0, 0x89 },
	0xA08C, { 0xEC, 0xA0, 0x8B },
	0xA08D, { 0xEC, 0xA0, 0x8C },
	0xA08E, { 0xEC, 0xA0, 0x8D },
	0xA08F, { 0xEC, 0xA0, 0x8E },
	0xA090, { 0xEC, 0xA0, 0x8F },
	0xA091, { 0xEC, 0xA0, 0x92 },
	0xA092, { 0xEC, 0xA0, 0x94 },
	0xA093, { 0xEC, 0xA0, 0x97 },
	0xA094, { 0xEC, 0xA0, 0x98 },
	0xA095, { 0xEC, 0xA0, 0x99 },
	0xA096, { 0xEC, 0xA0, 0x9A },
	0xA097, { 0xEC, 0xA0, 0x9B },
	0xA098, { 0xEC, 0xA0, 0x9E },
	0xA099, { 0xEC, 0xA0, 0x9F },
	0xA09A, { 0xEC, 0xA0, 0xA1 },
	0xA09B, { 0xEC, 0xA0, 0xA2 },
	0xA09C, { 0xEC, 0xA0, 0xA3 },
	0xA09D, { 0xEC, 0xA0, 0xA5 },
	0xA09E, { 0xEC, 0xA0, 0xA6 },
	0xA09F, { 0xEC, 0xA0, 0xA7 },
	0xA0A0, { 0xEC, 0xA0, 0xA8 },
	0xA0A1, { 0xEC, 0xA0, 0xA9 },
	0xA0A2, { 0xEC, 0xA0, 0xAA },
	0xA0A3, { 0xEC, 0xA0, 0xAB },
	0xA0A4, { 0xEC, 0xA0, 0xAE },
	0xA0A5, { 0xEC, 0xA0, 0xB0 },
	0xA0A6, { 0xEC, 0xA0, 0xB2 },
	0xA0A7, { 0xEC, 0xA0, 0xB3 },
	0xA0A8, { 0xEC, 0xA0, 0xB4 },
	0xA0A9, { 0xEC, 0xA0, 0xB5 },
	0xA0AA, { 0xEC, 0xA0, 0xB6 },
	0xA0AB, { 0xEC, 0xA0, 0xB7 },
	0xA0AC, { 0xEC, 0xA0, 0xB9 },
	0xA0AD, { 0xEC, 0xA0, 0xBA },
	0xA0AE, { 0xEC, 0xA0, 0xBB },
	0xA0AF, { 0xEC, 0xA0, 0xBD },
	0xA0B0, { 0xEC, 0xA0, 0xBE },
	0xA0B1, { 0xEC, 0xA0, 0xBF },
	0xA0B2, { 0xEC, 0xA1, 0x81 },
	0xA0B3, { 0xEC, 0xA1, 0x82 },
	0xA0B4, { 0xEC, 0xA1, 0x83 },
	0xA0B5, { 0xEC, 0xA1, 0x84 },
	0xA0B6, { 0xEC, 0xA1, 0x85 },
	0xA0B7, { 0xEC, 0xA1, 0x86 },
	0xA0B8, { 0xEC, 0xA1, 0x87 },
	0xA0B9, { 0xEC, 0xA1, 0x8A },
	0xA0BA, { 0xEC, 0xA1, 0x8B },
	0xA0BB, { 0xEC, 0xA1, 0x8E },
	0xA0BC, { 0xEC, 0xA1, 0x8F },
	0xA0BD, { 0xEC, 0xA1, 0x90 },
	0xA0BE, { 0xEC, 0xA1, 0x91 },
	0xA0BF, { 0xEC, 0xA1, 0x92 },
	0xA0C0, { 0xEC, 0xA1, 0x93 },
	0xA0C1, { 0xEC, 0xA1, 0x95 },
	0xA0C2, { 0xEC, 0xA1, 0x96 },
	0xA0C3, { 0xEC, 0xA1, 0x97 },
	0xA0C4, { 0xEC, 0xA1, 0x98 },
	0xA0C5, { 0xEC, 0xA1, 0x99 },
	0xA0C6, { 0xEC, 0xA1, 0x9A },
	0xA0C7, { 0xEC, 0xA1, 0x9B },
	0xA0C8, { 0xEC, 0xA1, 0x9C },
	0xA0C9, { 0xEC, 0xA1, 0x9D },
	0xA0CA, { 0xEC, 0xA1, 0x9E },
	0xA0CB, { 0xEC, 0xA1, 0x9F },
	0xA0CC, { 0xEC, 0xA1, 0xA0 },
	0xA0CD, { 0xEC, 0xA1, 0xA1 },
	0xA0CE, { 0xEC, 0xA1, 0xA2 },
	0xA0CF, { 0xEC, 0xA1, 0xA3 },
	0xA0D0, { 0xEC, 0xA1, 0xA4 },
	0xA0D1, { 0xEC, 0xA1, 0xA5 },
	0xA0D2, { 0xEC, 0xA1, 0xA6 },
	0xA0D3, { 0xEC, 0xA1, 0xA7 },
	0xA0D4, { 0xEC, 0xA1, 0xA8 },
	0xA0D5, { 0xEC, 0xA1, 0xA9 },
	0xA0D6, { 0xEC, 0xA1, 0xAA },
	0xA0D7, { 0xEC, 0xA1, 0xAB },
	0xA0D8, { 0xEC, 0xA1, 0xAC },
	0xA0D9, { 0xEC, 0xA1, 0xAD },
	0xA0DA, { 0xEC, 0xA1, 0xAE },
	0xA0DB, { 0xEC, 0xA1, 0xAF },
	0xA0DC, { 0xEC, 0xA1, 0xB2 },
	0xA0DD, { 0xEC, 0xA1, 0xB3 },
	0xA0DE, { 0xEC, 0xA1, 0xB5 },
	0xA0DF, { 0xEC, 0xA1, 0xB6 },
	0xA0E0, { 0xEC, 0xA1, 0xB7 },
	0xA0E1, { 0xEC, 0xA1, 0xB9 },
	0xA0E2, { 0xEC, 0xA1, 0xBB },
	0xA0E3, { 0xEC, 0xA1, 0xBC },
	0xA0E4, { 0xEC, 0xA1, 0xBD },
	0xA0E5, { 0xEC, 0xA1, 0xBE },
	0xA0E6, { 0xEC, 0xA1, 0xBF },
	0xA0E7, { 0xEC, 0xA2, 0x82 },
	0xA0E8, { 0xEC, 0xA2, 0x84 },
	0xA0E9, { 0xEC, 0xA2, 0x88 },
	0xA0EA, { 0xEC, 0xA2, 0x89 },
	0xA0EB, { 0xEC, 0xA2, 0x8A },
	0xA0EC, { 0xEC, 0xA2, 0x8E },
	0xA0ED, { 0xEC, 0xA2, 0x8F },
	0xA0EE, { 0xEC, 0xA2, 0x90 },
	0xA0EF, { 0xEC, 0xA2, 0x91 },
	0xA0F0, { 0xEC, 0xA2, 0x92 },
	0xA0F1, { 0xEC, 0xA2, 0x93 },
	0xA0F2, { 0xEC, 0xA2, 0x95 },
	0xA0F3, { 0xEC, 0xA2, 0x96 },
	0xA0F4, { 0xEC, 0xA2, 0x97 },
	0xA0F5, { 0xEC, 0xA2, 0x98 },
	0xA0F6, { 0xEC, 0xA2, 0x99 },
	0xA0F7, { 0xEC, 0xA2, 0x9A },
	0xA0F8, { 0xEC, 0xA2, 0x9B },
	0xA0F9, { 0xEC, 0xA2, 0x9C },
	0xA0FA, { 0xEC, 0xA2, 0x9E },
	0xA0FB, { 0xEC, 0xA2, 0xA0 },
	0xA0FC, { 0xEC, 0xA2, 0xA2 },
	0xA0FD, { 0xEC, 0xA2, 0xA3 },
	0xA0FE, { 0xEC, 0xA2, 0xA4 },
	0xA141, { 0xEC, 0xA2, 0xA5 },
	0xA142, { 0xEC, 0xA2, 0xA6 },
	0xA143, { 0xEC, 0xA2, 0xA7 },
	0xA144, { 0xEC, 0xA2, 0xA9 },
	0xA145, { 0xEC, 0xA2, 0xAA },
	0xA146, { 0xEC, 0xA2, 0xAB },
	0xA147, { 0xEC, 0xA2, 0xAC },
	0xA148, { 0xEC, 0xA2, 0xAD },
	0xA149, { 0xEC, 0xA2, 0xAE },
	0xA14A, { 0xEC, 0xA2, 0xAF },
	0xA14B, { 0xEC, 0xA2, 0xB0 },
	0xA14C, { 0xEC, 0xA2, 0xB1 },
	0xA14D, { 0xEC, 0xA2, 0xB2 },
	0xA14E, { 0xEC, 0xA2, 0xB3 },
	0xA14F, { 0xEC, 0xA2, 0xB4 },
	0xA150, { 0xEC, 0xA2, 0xB5 },
	0xA151, { 0xEC, 0xA2, 0xB6 },
	0xA152, { 0xEC, 0xA2, 0xB7 },
	0xA153, { 0xEC, 0xA2, 0xB8 },
	0xA154, { 0xEC, 0xA2, 0xB9 },
	0xA155, { 0xEC, 0xA2, 0xBA },
	0xA156, { 0xEC, 0xA2, 0xBB },
	0xA157, { 0xEC, 0xA2, 0xBE },
	0xA158, { 0xEC, 0xA2, 0xBF },
	0xA159, { 0xEC, 0xA3, 0x80 },
	0xA15A, { 0xEC, 0xA3, 0x81 },
	0xA161, { 0xEC, 0xA3, 0x82 },
	0xA162, { 0xEC, 0xA3, 0x83 },
	0xA163, { 0xEC, 0xA3, 0x85 },
	0xA164, { 0xEC, 0xA3, 0x86 },
	0xA165, { 0xEC, 0xA3, 0x87 },
	0xA166, { 0xEC, 0xA3, 0x89 },
	0xA167, { 0xEC, 0xA3, 0x8A },
	0xA168, { 0xEC, 0xA3, 0x8B },
	0xA169, { 0xEC, 0xA3, 0x8D },
	0xA16A, { 0xEC, 0xA3, 0x8E },
	0xA16B, { 0xEC, 0xA3, 0x8F },
	0xA16C, { 0xEC, 0xA3, 0x90 },
	0xA16D, { 0xEC, 0xA3, 0x91 },
	0xA16E, { 0xEC, 0xA3, 0x92 },
	0xA16F, { 0xEC, 0xA3, 0x93 },
	0xA170, { 0xEC, 0xA3, 0x96 },
	0xA171, { 0xEC, 0xA3, 0x98 },
	0xA172, { 0xEC, 0xA3, 0x9A },
	0xA173, { 0xEC, 0xA3, 0x9B },
	0xA174, { 0xEC, 0xA3, 0x9C },
	0xA175, { 0xEC, 0xA3, 0x9D },
	0xA176, { 0xEC, 0xA3, 0x9E },
	0xA177, { 0xEC, 0xA3, 0x9F },
	0xA178, { 0xEC, 0xA3, 0xA2 },
	0xA179, { 0xEC, 0xA3, 0xA3 },
	0xA17A, { 0xEC, 0xA3, 0xA5 },
	0xA181, { 0xEC, 0xA3, 0xA6 },
	0xA182, { 0xEC, 0xA3, 0xA7 },
	0xA183, { 0xEC, 0xA3, 0xA8 },
	0xA184, { 0xEC, 0xA3, 0xA9 },
	0xA185, { 0xEC, 0xA3, 0xAA },
	0xA186, { 0xEC, 0xA3, 0xAB },
	0xA187, { 0xEC, 0xA3, 0xAC },
	0xA188, { 0xEC, 0xA3, 0xAD },
	0xA189, { 0xEC, 0xA3, 0xAE },
	0xA18A, { 0xEC, 0xA3, 0xAF },
	0xA18B, { 0xEC, 0xA3, 0xB0 },
	0xA18C, { 0xEC, 0xA3, 0xB1 },
	0xA18D, { 0xEC, 0xA3, 0xB2 },
	0xA18E, { 0xEC, 0xA3, 0xB3 },
	0xA18F, { 0xEC, 0xA3, 0xB4 },
	0xA190, { 0xEC, 0xA3, 0xB6 },
	0xA191, { 0xEC, 0xA3, 0xB7 },
	0xA192, { 0xEC, 0xA3, 0xB8 },
	0xA193, { 0xEC, 0xA3, 0xB9 },
	0xA194, { 0xEC, 0xA3, 0xBA },
	0xA195, { 0xEC, 0xA3, 0xBB },
	0xA196, { 0xEC, 0xA3, 0xBE },
	0xA197, { 0xEC, 0xA3, 0xBF },
	0xA198, { 0xEC, 0xA4, 0x81 },
	0xA199, { 0xEC, 0xA4, 0x82 },
	0xA19A, { 0xEC, 0xA4, 0x83 },
	0xA19B, { 0xEC, 0xA4, 0x87 },
	0xA19C, { 0xEC, 0xA4, 0x88 },
	0xA19D, { 0xEC, 0xA4, 0x89 },
	0xA19E, { 0xEC, 0xA4, 0x8A },
	0xA19F, { 0xEC, 0xA4, 0x8B },
	0xA1A0, { 0xEC, 0xA4, 0x8E },
	0xA1A1, { 0xE3, 0x80, 0x80 },
	0xA1A2, { 0xE3, 0x80, 0x81 },
	0xA1A3, { 0xE3, 0x80, 0x82 },
	0xA1A4, { 0xC2, 0xB7 },
	0xA1A5, { 0xE2, 0x80, 0xA5 },
	0xA1A6, { 0xE2, 0x80, 0xA6 },
	0xA1A7, { 0xC2, 0xA8 },
	0xA1A8, { 0xE3, 0x80, 0x83 },
	0xA1A9, { 0xC2, 0xAD },
	0xA1AA, { 0xE2, 0x80, 0x95 },
	0xA1AB, { 0xE2, 0x88, 0xA5 },
	0xA1AC, { 0xEF, 0xBC, 0xBC },
	0xA1AD, { 0xE2, 0x88, 0xBC },
	0xA1AE, { 0xE2, 0x80, 0x98 },
	0xA1AF, { 0xE2, 0x80, 0x99 },
	0xA1B0, { 0xE2, 0x80, 0x9C },
	0xA1B1, { 0xE2, 0x80, 0x9D },
	0xA1B2, { 0xE3, 0x80, 0x94 },
	0xA1B3, { 0xE3, 0x80, 0x95 },
	0xA1B4, { 0xE3, 0x80, 0x88 },
	0xA1B5, { 0xE3, 0x80, 0x89 },
	0xA1B6, { 0xE3, 0x80, 0x8A },
	0xA1B7, { 0xE3, 0x80, 0x8B },
	0xA1B8, { 0xE3, 0x80, 0x8C },
	0xA1B9, { 0xE3, 0x80, 0x8D },
	0xA1BA, { 0xE3, 0x80, 0x8E },
	0xA1BB, { 0xE3, 0x80, 0x8F },
	0xA1BC, { 0xE3, 0x80, 0x90 },
	0xA1BD, { 0xE3, 0x80, 0x91 },
	0xA1BE, { 0xC2, 0xB1 },
	0xA1BF, { 0xC3, 0x97 },
	0xA1C0, { 0xC3, 0xB7 },
	0xA1C1, { 0xE2, 0x89, 0xA0 },
	0xA1C2, { 0xE2, 0x89, 0xA4 },
	0xA1C3, { 0xE2, 0x89, 0xA5 },
	0xA1C4, { 0xE2, 0x88, 0x9E },
	0xA1C5, { 0xE2, 0x88, 0xB4 },
	0xA1C6, { 0xC2, 0xB0 },
	0xA1C7, { 0xE2, 0x80, 0xB2 },
	0xA1C8, { 0xE2, 0x80, 0xB3 },
	0xA1C9, { 0xE2, 0x84, 0x83 },
	0xA1CA, { 0xE2, 0x84, 0xAB },
	0xA1CB, { 0xEF, 0xBF, 0xA0 },
	0xA1CC, { 0xEF, 0xBF, 0xA1 },
	0xA1CD, { 0xEF, 0xBF, 0xA5 },
	0xA1CE, { 0xE2, 0x99, 0x82 },
	0xA1CF, { 0xE2, 0x99, 0x80 },
	0xA1D0, { 0xE2, 0x88, 0xA0 },
	0xA1D1, { 0xE2, 0x8A, 0xA5 },
	0xA1D2, { 0xE2, 0x8C, 0x92 },
	0xA1D3, { 0xE2, 0x88, 0x82 },
	0xA1D4, { 0xE2, 0x88, 0x87 },
	0xA1D5, { 0xE2, 0x89, 0xA1 },
	0xA1D6, { 0xE2, 0x89, 0x92 },
	0xA1D7, { 0xC2, 0xA7 },
	0xA1D8, { 0xE2, 0x80, 0xBB },
	0xA1D9, { 0xE2, 0x98, 0x86 },
	0xA1DA, { 0xE2, 0x98, 0x85 },
	0xA1DB, { 0xE2, 0x97, 0x8B },
	0xA1DC, { 0xE2, 0x97, 0x8F },
	0xA1DD, { 0xE2, 0x97, 0x8E },
	0xA1DE, { 0xE2, 0x97, 0x87 },
	0xA1DF, { 0xE2, 0x97, 0x86 },
	0xA1E0, { 0xE2, 0x96, 0xA1 },
	0xA1E1, { 0xE2, 0x96, 0xA0 },
	0xA1E2, { 0xE2, 0x96, 0xB3 },
	0xA1E3, { 0xE2, 0x96, 0xB2 },
	0xA1E4, { 0xE2, 0x96, 0xBD },
	0xA1E5, { 0xE2, 0x96, 0xBC },
	0xA1E6, { 0xE2, 0x86, 0x92 },
	0xA1E7, { 0xE2, 0x86, 0x90 },
	0xA1E8, { 0xE2, 0x86, 0x91 },
	0xA1E9, { 0xE2, 0x86, 0x93 },
	0xA1EA, { 0xE2, 0x86, 0x94 },
	0xA1EB, { 0xE3, 0x80, 0x93 },
	0xA1EC, { 0xE2, 0x89, 0xAA },
	0xA1ED, { 0xE2, 0x89, 0xAB },
	0xA1EE, { 0xE2, 0x88, 0x9A },
	0xA1EF, { 0xE2, 0x88, 0xBD },
	0xA1F0, { 0xE2, 0x88, 0x9D },
	0xA1F1, { 0xE2, 0x88, 0xB5 },
	0xA1F2, { 0xE2, 0x88, 0xAB },
	0xA1F3, { 0xE2, 0x88, 0xAC },
	0xA1F4, { 0xE2, 0x88, 0x88 },
	0xA1F5, { 0xE2, 0x88, 0x8B },
	0xA1F6, { 0xE2, 0x8A, 0x86 },
	0xA1F7, { 0xE2, 0x8A, 0x87 },
	0xA1F8, { 0xE2, 0x8A, 0x82 },
	0xA1F9, { 0xE2, 0x8A, 0x83 },
	0xA1FA, { 0xE2, 0x88, 0xAA },
	0xA1FB, { 0xE2, 0x88, 0xA9 },
	0xA1FC, { 0xE2, 0x88, 0xA7 },
	0xA1FD, { 0xE2, 0x88, 0xA8 },
	0xA1FE, { 0xEF, 0xBF, 0xA2 },
	0xA241, { 0xEC, 0xA4, 0x90 },
	0xA242, { 0xEC, 0xA4, 0x92 },
	0xA243, { 0xEC, 0xA4, 0x93 },
	0xA244, { 0xEC, 0xA4, 0x94 },
	0xA245, { 0xEC, 0xA4, 0x95 },
	0xA246, { 0xEC, 0xA4, 0x96 },
	0xA247, { 0xEC, 0xA4, 0x97 },
	0xA248, { 0xEC, 0xA4, 0x99 },
	0xA249, { 0xEC, 0xA4, 0x9A },
	0xA24A, { 0xEC, 0xA4, 0x9B },
	0xA24B, { 0xEC, 0xA4, 0x9C },
	0xA24C, { 0xEC, 0xA4, 0x9D },
	0xA24D, { 0xEC, 0xA4, 0x9E },
	0xA24E, { 0xEC, 0xA4, 0x9F },
	0xA24F, { 0xEC, 0xA4, 0xA0 },
	0xA250, { 0xEC, 0xA4, 0xA1 },
	0xA251, { 0xEC, 0xA4, 0xA2 },
	0xA252, { 0xEC, 0xA4, 0xA3 },
	0xA253, { 0xEC, 0xA4, 0xA4 },
	0xA254, { 0xEC, 0xA4, 0xA5 },
	0xA255, { 0xEC, 0xA4, 0xA6 },
	0xA256, { 0xEC, 0xA4, 0xA7 },
	0xA257, { 0xEC, 0xA4, 0xA8 },
	0xA258, { 0xEC, 0xA4, 0xA9 },
	0xA259, { 0xEC, 0xA4, 0xAA },
	0xA25A, { 0xEC, 0xA4, 0xAB },
	0xA261, { 0xEC, 0xA4, 0xAD },
	0xA262, { 0xEC, 0xA4, 0xAE },
	0xA263, { 0xEC, 0xA4, 0xAF },
	0xA264, { 0xEC, 0xA4, 0xB0 },
	0xA265, { 0xEC, 0xA4, 0xB1 },
	0xA266, { 0xEC, 0xA4, 0xB2 },
	0xA267, { 0xEC, 0xA4, 0xB3 },
	0xA268, { 0xEC, 0xA4, 0xB5 },
	0xA269, { 0xEC, 0xA4, 0xB6 },
	0xA26A, { 0xEC, 0xA4, 0xB7 },
	0xA26B, { 0xEC, 0xA4, 0xB8 },
	0xA26C, { 0xEC, 0xA4, 0xB9 },
	0xA26D, { 0xEC, 0xA4, 0xBA },
	0xA26E, { 0xEC, 0xA4, 0xBB },
	0xA26F, { 0xEC, 0xA4, 0xBC },
	0xA270, { 0xEC, 0xA4, 0xBD },
	0xA271, { 0xEC, 0xA4, 0xBE },
	0xA272, { 0xEC, 0xA4, 0xBF },
	0xA273, { 0xEC, 0xA5, 0x80 },
	0xA274, { 0xEC, 0xA5, 0x81 },
	0xA275, { 0xEC, 0xA5, 0x82 },
	0xA276, { 0xEC, 0xA5, 0x83 },
	0xA277, { 0xEC, 0xA5, 0x84 },
	0xA278, { 0xEC, 0xA5, 0x85 },
	0xA279, { 0xEC, 0xA5, 0x86 },
	0xA27A, { 0xEC, 0xA5, 0x87 },
	0xA281, { 0xEC, 0xA5, 0x88 },
	0xA282, { 0xEC, 0xA5, 0x89 },
	0xA283, { 0xEC, 0xA5, 0x8A },
	0xA284, { 0xEC, 0xA5, 0x8B },
	0xA285, { 0xEC, 0xA5, 0x8C },
	0xA286, { 0xEC, 0xA5, 0x8D },
	0xA287, { 0xEC, 0xA5, 0x8E },
	0xA288, { 0xEC, 0xA5, 0x8F },
	0xA289, { 0xEC, 0xA5, 0x92 },
	0xA28A, { 0xEC, 0xA5, 0x93 },
	0xA28B, { 0xEC, 0xA5, 0x95 },
	0xA28C, { 0xEC, 0xA5, 0x96 },
	0xA28D, { 0xEC, 0xA5, 0x97 },
	0xA28E, { 0xEC, 0xA5, 0x99 },
	0xA28F, { 0xEC, 0xA5, 0x9A },
	0xA290, { 0xEC, 0xA5, 0x9B },
	0xA291, { 0xEC, 0xA5, 0x9C },
	0xA292, { 0xEC, 0xA5, 0x9D },
	0xA293, { 0xEC, 0xA5, 0x9E },
	0xA294, { 0xEC, 0xA5, 0x9F },
	0xA295, { 0xEC, 0xA5, 0xA2 },
	0xA296, { 0xEC, 0xA5, 0xA4 },
	0xA297, { 0xEC, 0xA5, 0xA5 },
	0xA298, { 0xEC, 0xA5, 0xA6 },
	0xA299, { 0xEC, 0xA5, 0xA7 },
	0xA29A, { 0xEC, 0xA5, 0xA8 },
	0xA29B, { 0xEC, 0xA5, 0xA9 },
	0xA29C, { 0xEC, 0xA5, 0xAA },
	0xA29D, { 0xEC, 0xA5, 0xAB },
	0xA29E, { 0xEC, 0xA5, 0xAD },
	0xA29F, { 0xEC, 0xA5, 0xAE },
	0xA2A0, { 0xEC, 0xA5, 0xAF },
	0xA2A1, { 0xE2, 0x87, 0x92 },
	0xA2A2, { 0xE2, 0x87, 0x94 },
	0xA2A3, { 0xE2, 0x88, 0x80 },
	0xA2A4, { 0xE2, 0x88, 0x83 },
	0xA2A5, { 0xC2, 0xB4 },
	0xA2A6, { 0xEF, 0xBD, 0x9E },
	0xA2A7, { 0xCB, 0x87 },
	0xA2A8, { 0xCB, 0x98 },
	0xA2A9, { 0xCB, 0x9D },
	0xA2AA, { 0xCB, 0x9A },
	0xA2AB, { 0xCB, 0x99 },
	0xA2AC, { 0xC2, 0xB8 },
	0xA2AD, { 0xCB, 0x9B },
	0xA2AE, { 0xC2, 0xA1 },
	0xA2AF, { 0xC2, 0xBF },
	0xA2B0, { 0xCB, 0x90 },
	0xA2B1, { 0xE2, 0x88, 0xAE },
	0xA2B2, { 0xE2, 0x88, 0x91 },
	0xA2B3, { 0xE2, 0x88, 0x8F },
	0xA2B4, { 0xC2, 0xA4 },
	0xA2B5, { 0xE2, 0x84, 0x89 },
	0xA2B6, { 0xE2, 0x80, 0xB0 },
	0xA2B7, { 0xE2, 0x97, 0x81 },
	0xA2B8, { 0xE2, 0x97, 0x80 },
	0xA2B9, { 0xE2, 0x96, 0xB7 },
	0xA2BA, { 0xE2, 0x96, 0xB6 },
	0xA2BB, { 0xE2, 0x99, 0xA4 },
	0xA2BC, { 0xE2, 0x99, 0xA0 },
	0xA2BD, { 0xE2, 0x99, 0xA1 },
	0xA2BE, { 0xE2, 0x99, 0xA5 },
	0xA2BF, { 0xE2, 0x99, 0xA7 },
	0xA2C0, { 0xE2, 0x99, 0xA3 },
	0xA2C1, { 0xE2, 0x8A, 0x99 },
	0xA2C2, { 0xE2, 0x97, 0x88 },
	0xA2C3, { 0xE2, 0x96, 0xA3 },
	0xA2C4, { 0xE2, 0x97, 0x90 },
	0xA2C5, { 0xE2, 0x97, 0x91 },
	0xA2C6, { 0xE2, 0x96, 0x92 },
	0xA2C7, { 0xE2, 0x96, 0xA4 },
	0xA2C8, { 0xE2, 0x96, 0xA5 },
	0xA2C9, { 0xE2, 0x96, 0xA8 },
	0xA2CA, { 0xE2, 0x96, 0xA7 },
	0xA2CB, { 0xE2, 0x96, 0xA6 },
	0xA2CC, { 0xE2, 0x96, 0xA9 },
	0xA2CD, { 0xE2, 0x99, 0xA8 },
	0xA2CE, { 0xE2, 0x98, 0x8F },
	0xA2CF, { 0xE2, 0x98, 0x8E },
	0xA2D0, { 0xE2, 0x98, 0x9C },
	0xA2D1, { 0xE2, 0x98, 0x9E },
	0xA2D2, { 0xC2, 0xB6 },
	0xA2D3, { 0xE2, 0x80, 0xA0 },
	0xA2D4, { 0xE2, 0x80, 0xA1 },
	0xA2D5, { 0xE2, 0x86, 0x95 },
	0xA2D6, { 0xE2, 0x86, 0x97 },
	0xA2D7, { 0xE2, 0x86, 0x99 },
	0xA2D8, { 0xE2, 0x86, 0x96 },
	0xA2D9, { 0xE2, 0x86, 0x98 },
	0xA2DA, { 0xE2, 0x99, 0xAD },
	0xA2DB, { 0xE2, 0x99, 0xA9 },
	0xA2DC, { 0xE2, 0x99, 0xAA },
	0xA2DD, { 0xE2, 0x99, 0xAC },
	0xA2DE, { 0xE3, 0x89, 0xBF },
	0xA2DF, { 0xE3, 0x88, 0x9C },
	0xA2E0, { 0xE2, 0x84, 0x96 },
	0xA2E1, { 0xE3, 0x8F, 0x87 },
	0xA2E2, { 0xE2, 0x84, 0xA2 },
	0xA2E3, { 0xE3, 0x8F, 0x82 },
	0xA2E4, { 0xE3, 0x8F, 0x98 },
	0xA2E5, { 0xE2, 0x84, 0xA1 },
	0xA341, { 0xEC, 0xA5, 0xB1 },
	0xA342, { 0xEC, 0xA5, 0xB2 },
	0xA343, { 0xEC, 0xA5, 0xB3 },
	0xA344, { 0xEC, 0xA5, 0xB5 },
	0xA345, { 0xEC, 0xA5, 0xB6 },
	0xA346, { 0xEC, 0xA5, 0xB7 },
	0xA347, { 0xEC, 0xA5, 0xB8 },
	0xA348, { 0xEC, 0xA5, 0xB9 },
	0xA349, { 0xEC, 0xA5, 0xBA },
	0xA34A, { 0xEC, 0xA5, 0xBB },
	0xA34B, { 0xEC, 0xA5, 0xBD },
	0xA34C, { 0xEC, 0xA5, 0xBE },
	0xA34D, { 0xEC, 0xA5, 0xBF },
	0xA34E, { 0xEC, 0xA6, 0x80 },
	0xA34F, { 0xEC, 0xA6, 0x81 },
	0xA350, { 0xEC, 0xA6, 0x82 },
	0xA351, { 0xEC, 0xA6, 0x83 },
	0xA352, { 0xEC, 0xA6, 0x84 },
	0xA353, { 0xEC, 0xA6, 0x85 },
	0xA354, { 0xEC, 0xA6, 0x86 },
	0xA355, { 0xEC, 0xA6, 0x87 },
	0xA356, { 0xEC, 0xA6, 0x8A },
	0xA357, { 0xEC, 0xA6, 0x8B },
	0xA358, { 0xEC, 0xA6, 0x8D },
	0xA359, { 0xEC, 0xA6, 0x8E },
	0xA35A, { 0xEC, 0xA6, 0x8F },
	0xA361, { 0xEC, 0xA6, 0x91 },
	0xA362, { 0xEC, 0xA6, 0x92 },
	0xA363, { 0xEC, 0xA6, 0x93 },
	0xA364, { 0xEC, 0xA6, 0x94 },
	0xA365, { 0xEC, 0xA6, 0x95 },
	0xA366, { 0xEC, 0xA6, 0x96 },
	0xA367, { 0xEC, 0xA6, 0x97 },
	0xA368, { 0xEC, 0xA6, 0x9A },
	0xA369, { 0xEC, 0xA6, 0x9C },
	0xA36A, { 0xEC, 0xA6, 0x9E },
	0xA36B, { 0xEC, 0xA6, 0x9F },
	0xA36C, { 0xEC, 0xA6, 0xA0 },
	0xA36D, { 0xEC, 0xA6, 0xA1 },
	0xA36E, { 0xEC, 0xA6, 0xA2 },
	0xA36F, { 0xEC, 0xA6, 0xA3 },
	0xA370, { 0xEC, 0xA6, 0xA4 },
	0xA371, { 0xEC, 0xA6, 0xA5 },
	0xA372, { 0xEC, 0xA6, 0xA6 },
	0xA373, { 0xEC, 0xA6, 0xA7 },
	0xA374, { 0xEC, 0xA6, 0xA8 },
	0xA375, { 0xEC, 0xA6, 0xA9 },
	0xA376, { 0xEC, 0xA6, 0xAA },
	0xA377, { 0xEC, 0xA6, 0xAB },
	0xA378, { 0xEC, 0xA6, 0xAC },
	0xA379, { 0xEC, 0xA6, 0xAD },
	0xA37A, { 0xEC, 0xA6, 0xAE },
	0xA381, { 0xEC, 0xA6, 0xAF },
	0xA382, { 0xEC, 0xA6, 0xB0 },
	0xA383, { 0xEC, 0xA6, 0xB1 },
	0xA384, { 0xEC, 0xA6, 0xB2 },
	0xA385, { 0xEC, 0xA6, 0xB3 },
	0xA386, { 0xEC, 0xA6, 0xB4 },
	0xA387, { 0xEC, 0xA6, 0xB5 },
	0xA388, { 0xEC, 0xA6, 0xB6 },
	0xA389, { 0xEC, 0xA6, 0xB7 },
	0xA38A, { 0xEC, 0xA6, 0xB8 },
	0xA38B, { 0xEC, 0xA6, 0xB9 },
	0xA38C, { 0xEC, 0xA6, 0xBA },
	0xA38D, { 0xEC, 0xA6, 0xBB },
	0xA38E, { 0xEC, 0xA6, 0xBC },
	0xA38F, { 0xEC, 0xA6, 0xBD },
	0xA390, { 0xEC, 0xA6, 0xBE },
	0xA391, { 0xEC, 0xA6, 0xBF },
	0xA392, { 0xEC, 0xA7, 0x82 },
	0xA393, { 0xEC, 0xA7, 0x83 },
	0xA394, { 0xEC, 0xA7, 0x85 },
	0xA395, { 0xEC, 0xA7, 0x86 },
	0xA396, { 0xEC, 0xA7, 0x89 },
	0xA397, { 0xEC, 0xA7, 0x8B },
	0xA398, { 0xEC, 0xA7, 0x8C },
	0xA399, { 0xEC, 0xA7, 0x8D },
	0xA39A, { 0xEC, 0xA7, 0x8E },
	0xA39B, { 0xEC, 0xA7, 0x8F },
	0xA39C, { 0xEC, 0xA7, 0x92 },
	0xA39D, { 0xEC, 0xA7, 0x94 },
	0xA39E, { 0xEC, 0xA7, 0x97 },
	0xA39F, { 0xEC, 0xA7, 0x98 },
	0xA3A0, { 0xEC, 0xA7, 0x9B },
	0xA3A1, { 0xEF, 0xBC, 0x81 },
	0xA3A2, { 0xEF, 0xBC, 0x82 },
	0xA3A3, { 0xEF, 0xBC, 0x83 },
	0xA3A4, { 0xEF, 0xBC, 0x84 },
	0xA3A5, { 0xEF, 0xBC, 0x85 },
	0xA3A6, { 0xEF, 0xBC, 0x86 },
	0xA3A7, { 0xEF, 0xBC, 0x87 },
	0xA3A8, { 0xEF, 0xBC, 0x88 },
	0xA3A9, { 0xEF, 0xBC, 0x89 },
	0xA3AA, { 0xEF, 0xBC, 0x8A },
	0xA3AB, { 0xEF, 0xBC, 0x8B },
	0xA3AC, { 0xEF, 0xBC, 0x8C },
	0xA3AD, { 0xEF, 0xBC, 0x8D },
	0xA3AE, { 0xEF, 0xBC, 0x8E },
	0xA3AF, { 0xEF, 0xBC, 0x8F },
	0xA3B0, { 0xEF, 0xBC, 0x90 },
	0xA3B1, { 0xEF, 0xBC, 0x91 },
	0xA3B2, { 0xEF, 0xBC, 0x92 },
	0xA3B3, { 0xEF, 0xBC, 0x93 },
	0xA3B4, { 0xEF, 0xBC, 0x94 },
	0xA3B5, { 0xEF, 0xBC, 0x95 },
	0xA3B6, { 0xEF, 0xBC, 0x96 },
	0xA3B7, { 0xEF, 0xBC, 0x97 },
	0xA3B8, { 0xEF, 0xBC, 0x98 },
	0xA3B9, { 0xEF, 0xBC, 0x99 },
	0xA3BA, { 0xEF, 0xBC, 0x9A },
	0xA3BB, { 0xEF, 0xBC, 0x9B },
	0xA3BC, { 0xEF, 0xBC, 0x9C },
	0xA3BD, { 0xEF, 0xBC, 0x9D },
	0xA3BE, { 0xEF, 0xBC, 0x9E },
	0xA3BF, { 0xEF, 0xBC, 0x9F },
	0xA3C0, { 0xEF, 0xBC, 0xA0 },
	0xA3C1, { 0xEF, 0xBC, 0xA1 },
	0xA3C2, { 0xEF, 0xBC, 0xA2 },
	0xA3C3, { 0xEF, 0xBC, 0xA3 },
	0xA3C4, { 0xEF, 0xBC, 0xA4 },
	0xA3C5, { 0xEF, 0xBC, 0xA5 },
	0xA3C6, { 0xEF, 0xBC, 0xA6 },
	0xA3C7, { 0xEF, 0xBC, 0xA7 },
	0xA3C8, { 0xEF, 0xBC, 0xA8 },
	0xA3C9, { 0xEF, 0xBC, 0xA9 },
	0xA3CA, { 0xEF, 0xBC, 0xAA },
	0xA3CB, { 0xEF, 0xBC, 0xAB },
	0xA3CC, { 0xEF, 0xBC, 0xAC },
	0xA3CD, { 0xEF, 0xBC, 0xAD },
	0xA3CE, { 0xEF, 0xBC, 0xAE },
	0xA3CF, { 0xEF, 0xBC, 0xAF },
	0xA3D0, { 0xEF, 0xBC, 0xB0 },
	0xA3D1, { 0xEF, 0xBC, 0xB1 },
	0xA3D2, { 0xEF, 0xBC, 0xB2 },
	0xA3D3, { 0xEF, 0xBC, 0xB3 },
	0xA3D4, { 0xEF, 0xBC, 0xB4 },
	0xA3D5, { 0xEF, 0xBC, 0xB5 },
	0xA3D6, { 0xEF, 0xBC, 0xB6 },
	0xA3D7, { 0xEF, 0xBC, 0xB7 },
	0xA3D8, { 0xEF, 0xBC, 0xB8 },
	0xA3D9, { 0xEF, 0xBC, 0xB9 },
	0xA3DA, { 0xEF, 0xBC, 0xBA },
	0xA3DB, { 0xEF, 0xBC, 0xBB },
	0xA3DC, { 0xEF, 0xBF, 0xA6 },
	0xA3DD, { 0xEF, 0xBC, 0xBD },
	0xA3DE, { 0xEF, 0xBC, 0xBE },
	0xA3DF, { 0xEF, 0xBC, 0xBF },
	0xA3E0, { 0xEF, 0xBD, 0x80 },
	0xA3E1, { 0xEF, 0xBD, 0x81 },
	0xA3E2, { 0xEF, 0xBD, 0x82 },
	0xA3E3, { 0xEF, 0xBD, 0x83 },
	0xA3E4, { 0xEF, 0xBD, 0x84 },
	0xA3E5, { 0xEF, 0xBD, 0x85 },
	0xA3E6, { 0xEF, 0xBD, 0x86 },
	0xA3E7, { 0xEF, 0xBD, 0x87 },
	0xA3E8, { 0xEF, 0xBD, 0x88 },
	0xA3E9, { 0xEF, 0xBD, 0x89 },
	0xA3EA, { 0xEF, 0xBD, 0x8A },
	0xA3EB, { 0xEF, 0xBD, 0x8B },
	0xA3EC, { 0xEF, 0xBD, 0x8C },
	0xA3ED, { 0xEF, 0xBD, 0x8D },
	0xA3EE, { 0xEF, 0xBD, 0x8E },
	0xA3EF, { 0xEF, 0xBD, 0x8F },
	0xA3F0, { 0xEF, 0xBD, 0x90 },
	0xA3F1, { 0xEF, 0xBD, 0x91 },
	0xA3F2, { 0xEF, 0xBD, 0x92 },
	0xA3F3, { 0xEF, 0xBD, 0x93 },
	0xA3F4, { 0xEF, 0xBD, 0x94 },
	0xA3F5, { 0xEF, 0xBD, 0x95 },
	0xA3F6, { 0xEF, 0xBD, 0x96 },
	0xA3F7, { 0xEF, 0xBD, 0x97 },
	0xA3F8, { 0xEF, 0xBD, 0x98 },
	0xA3F9, { 0xEF, 0xBD, 0x99 },
	0xA3FA, { 0xEF, 0xBD, 0x9A },
	0xA3FB, { 0xEF, 0xBD, 0x9B },
	0xA3FC, { 0xEF, 0xBD, 0x9C },
	0xA3FD, { 0xEF, 0xBD, 0x9D },
	0xA3FE, { 0xEF, 0xBF, 0xA3 },
	0xA441, { 0xEC, 0xA7, 0x9E },
	0xA442, { 0xEC, 0xA7, 0x9F },
	0xA443, { 0xEC, 0xA7, 0xA1 },
	0xA444, { 0xEC, 0xA7, 0xA3 },
	0xA445, { 0xEC, 0xA7, 0xA5 },
	0xA446, { 0xEC, 0xA7, 0xA6 },
	0xA447, { 0xEC, 0xA7, 0xA8 },
	0xA448, { 0xEC, 0xA7, 0xA9 },
	0xA449, { 0xEC, 0xA7, 0xAA },
	0xA44A, { 0xEC, 0xA7, 0xAB },
	0xA44B, { 0xEC, 0xA7, 0xAE },
	0xA44C, { 0xEC, 0xA7, 0xB2 },
	0xA44D, { 0xEC, 0xA7, 0xB3 },
	0xA44E, { 0xEC, 0xA7, 0xB4 },
	0xA44F, { 0xEC, 0xA7, 0xB5 },
	0xA450, { 0xEC, 0xA7, 0xB6 },
	0xA451, { 0xEC, 0xA7, 0xB7 },
	0xA452, { 0xEC, 0xA7, 0xBA },
	0xA453, { 0xEC, 0xA7, 0xBB },
	0xA454, { 0xEC, 0xA7, 0xBD },
	0xA455, { 0xEC, 0xA7, 0xBE },
	0xA456, { 0xEC, 0xA7, 0xBF },
	0xA457, { 0xEC, 0xA8, 0x81 },
	0xA458, { 0xEC, 0xA8, 0x82 },
	0xA459, { 0xEC, 0xA8, 0x83 },
	0xA45A, { 0xEC, 0xA8, 0x84 },
	0xA461, { 0xEC, 0xA8, 0x85 },
	0xA462, { 0xEC, 0xA8, 0x86 },
	0xA463, { 0xEC, 0xA8, 0x87 },
	0xA464, { 0xEC, 0xA8, 0x8A },
	0xA465, { 0xEC, 0xA8, 0x8E },
	0xA466, { 0xEC, 0xA8, 0x8F },
	0xA467, { 0xEC, 0xA8, 0x90 },
	0xA468, { 0xEC, 0xA8, 0x91 },
	0xA469, { 0xEC, 0xA8, 0x92 },
	0xA46A, { 0xEC, 0xA8, 0x93 },
	0xA46B, { 0xEC, 0xA8, 0x95 },
	0xA46C, { 0xEC, 0xA8, 0x96 },
	0xA46D, { 0xEC, 0xA8, 0x97 },
	0xA46E, { 0xEC, 0xA8, 0x99 },
	0xA46F, { 0xEC, 0xA8, 0x9A },
	0xA470, { 0xEC, 0xA8, 0x9B },
	0xA471, { 0xEC, 0xA8, 0x9C },
	0xA472, { 0xEC, 0xA8, 0x9D },
	0xA473, { 0xEC, 0xA8, 0x9E },
	0xA474, { 0xEC, 0xA8, 0x9F },
	0xA475, { 0xEC, 0xA8, 0xA0 },
	0xA476, { 0xEC, 0xA8, 0xA1 },
	0xA477, { 0xEC, 0xA8, 0xA2 },
	0xA478, { 0xEC, 0xA8, 0xA3 },
	0xA479, { 0xEC, 0xA8, 0xA4 },
	0xA47A, { 0xEC, 0xA8, 0xA5 },
	0xA481, { 0xEC, 0xA8, 0xA6 },
	0xA482, { 0xEC, 0xA8, 0xA7 },
	0xA483, { 0xEC, 0xA8, 0xA8 },
	0xA484, { 0xEC, 0xA8, 0xAA },
	0xA485, { 0xEC, 0xA8, 0xAB },
	0xA486, { 0xEC, 0xA8, 0xAC },
	0xA487, { 0xEC, 0xA8, 0xAD },
	0xA488, { 0xEC, 0xA8, 0xAE },
	0xA489, { 0xEC, 0xA8, 0xAF },
	0xA48A, { 0xEC, 0xA8, 0xB0 },
	0xA48B, { 0xEC, 0xA8, 0xB1 },
	0xA48C, { 0xEC, 0xA8, 0xB2 },
	0xA48D, { 0xEC, 0xA8, 0xB3 },
	0xA48E, { 0xEC, 0xA8, 0xB4 },
	0xA48F, { 0xEC, 0xA8, 0xB5 },
	0xA490, { 0xEC, 0xA8, 0xB6 },
	0xA491, { 0xEC, 0xA8, 0xB7 },
	0xA492, { 0xEC, 0xA8, 0xB8 },
	0xA493, { 0xEC, 0xA8, 0xB9 },
	0xA494, { 0xEC, 0xA8, 0xBA },
	0xA495, { 0xEC, 0xA8, 0xBB },
	0xA496, { 0xEC, 0xA8, 0xBC },
	0xA497, { 0xEC, 0xA8, 0xBD },
	0xA498, { 0xEC, 0xA8, 0xBE },
	0xA499, { 0xEC, 0xA8, 0xBF },
	0xA49A, { 0xEC, 0xA9, 0x80 },
	0xA49B, { 0xEC, 0xA9, 0x81 },
	0xA49C, { 0xEC, 0xA9, 0x82 },
	0xA49D, { 0xEC, 0xA9, 0x83 },
	0xA49E, { 0xEC, 0xA9, 0x84 },
	0xA49F, { 0xEC, 0xA9, 0x85 },
	0xA4A0, { 0xEC, 0xA9, 0x86 },
	0xA4A1, { 0xE3, 0x84, 0xB1 },
	0xA4A2, { 0xE3, 0x84, 0xB2 },
	0xA4A3, { 0xE3, 0x84, 0xB3 },
	0xA4A4, { 0xE3, 0x84, 0xB4 },
	0xA4A5, { 0xE3, 0x84, 0xB5 },
	0xA4A6, { 0xE3, 0x84, 0xB6 },
	0xA4A7, { 0xE3, 0x84, 0xB7 },
	0xA4A8, { 0xE3, 0x84, 0xB8 },
	0xA4A9, { 0xE3, 0x84, 0xB9 },
	0xA4AA, { 0xE3, 0x84, 0xBA },
	0xA4AB, { 0xE3, 0x84, 0xBB },
	0xA4AC, { 0xE3, 0x84, 0xBC },
	0xA4AD, { 0xE3, 0x84, 0xBD },
	0xA4AE, { 0xE3, 0x84, 0xBE },
	0xA4AF, { 0xE3, 0x84, 0xBF },
	0xA4B0, { 0xE3, 0x85, 0x80 },
	0xA4B1, { 0xE3, 0x85, 0x81 },
	0xA4B2, { 0xE3, 0x85, 0x82 },
	0xA4B3, { 0xE3, 0x85, 0x83 },
	0xA4B4, { 0xE3, 0x85, 0x84 },
	0xA4B5, { 0xE3, 0x85, 0x85 },
	0xA4B6, { 0xE3, 0x85, 0x86 },
	0xA4B7, { 0xE3, 0x85, 0x87 },
	0xA4B8, { 0xE3, 0x85, 0x88 },
	0xA4B9, { 0xE3, 0x85, 0x89 },
	0xA4BA, { 0xE3, 0x85, 0x8A },
	0xA4BB, { 0xE3, 0x85, 0x8B },
	0xA4BC, { 0xE3, 0x85, 0x8C },
	0xA4BD, { 0xE3, 0x85, 0x8D },
	0xA4BE, { 0xE3, 0x85, 0x8E },
	0xA4BF, { 0xE3, 0x85, 0x8F },
	0xA4C0, { 0xE3, 0x85, 0x90 },
	0xA4C1, { 0xE3, 0x85, 0x91 },
	0xA4C2, { 0xE3, 0x85, 0x92 },
	0xA4C3, { 0xE3, 0x85, 0x93 },
	0xA4C4, { 0xE3, 0x85, 0x94 },
	0xA4C5, { 0xE3, 0x85, 0x95 },
	0xA4C6, { 0xE3, 0x85, 0x96 },
	0xA4C7, { 0xE3, 0x85, 0x97 },
	0xA4C8, { 0xE3, 0x85, 0x98 },
	0xA4C9, { 0xE3, 0x85, 0x99 },
	0xA4CA, { 0xE3, 0x85, 0x9A },
	0xA4CB, { 0xE3, 0x85, 0x9B },
	0xA4CC, { 0xE3, 0x85, 0x9C },
	0xA4CD, { 0xE3, 0x85, 0x9D },
	0xA4CE, { 0xE3, 0x85, 0x9E },
	0xA4CF, { 0xE3, 0x85, 0x9F },
	0xA4D0, { 0xE3, 0x85, 0xA0 },
	0xA4D1, { 0xE3, 0x85, 0xA1 },
	0xA4D2, { 0xE3, 0x85, 0xA2 },
	0xA4D3, { 0xE3, 0x85, 0xA3 },
	0xA4D4, { 0xE3, 0x85, 0xA4 },
	0xA4D5, { 0xE3, 0x85, 0xA5 },
	0xA4D6, { 0xE3, 0x85, 0xA6 },
	0xA4D7, { 0xE3, 0x85, 0xA7 },
	0xA4D8, { 0xE3, 0x85, 0xA8 },
	0xA4D9, { 0xE3, 0x85, 0xA9 },
	0xA4DA, { 0xE3, 0x85, 0xAA },
	0xA4DB, { 0xE3, 0x85, 0xAB },
	0xA4DC, { 0xE3, 0x85, 0xAC },
	0xA4DD, { 0xE3, 0x85, 0xAD },
	0xA4DE, { 0xE3, 0x85, 0xAE },
	0xA4DF, { 0xE3, 0x85, 0xAF },
	0xA4E0, { 0xE3, 0x85, 0xB0 },
	0xA4E1, { 0xE3, 0x85, 0xB1 },
	0xA4E2, { 0xE3, 0x85, 0xB2 },
	0xA4E3, { 0xE3, 0x85, 0xB3 },
	0xA4E4, { 0xE3, 0x85, 0xB4 },
	0xA4E5, { 0xE3, 0x85, 0xB5 },
	0xA4E6, { 0xE3, 0x85, 0xB6 },
	0xA4E7, { 0xE3, 0x85, 0xB7 },
	0xA4E8, { 0xE3, 0x85, 0xB8 },
	0xA4E9, { 0xE3, 0x85, 0xB9 },
	0xA4EA, { 0xE3, 0x85, 0xBA },
	0xA4EB, { 0xE3, 0x85, 0xBB },
	0xA4EC, { 0xE3, 0x85, 0xBC },
	0xA4ED, { 0xE3, 0x85, 0xBD },
	0xA4EE, { 0xE3, 0x85, 0xBE },
	0xA4EF, { 0xE3, 0x85, 0xBF },
	0xA4F0, { 0xE3, 0x86, 0x80 },
	0xA4F1, { 0xE3, 0x86, 0x81 },
	0xA4F2, { 0xE3, 0x86, 0x82 },
	0xA4F3, { 0xE3, 0x86, 0x83 },
	0xA4F4, { 0xE3, 0x86, 0x84 },
	0xA4F5, { 0xE3, 0x86, 0x85 },
	0xA4F6, { 0xE3, 0x86, 0x86 },
	0xA4F7, { 0xE3, 0x86, 0x87 },
	0xA4F8, { 0xE3, 0x86, 0x88 },
	0xA4F9, { 0xE3, 0x86, 0x89 },
	0xA4FA, { 0xE3, 0x86, 0x8A },
	0xA4FB, { 0xE3, 0x86, 0x8B },
	0xA4FC, { 0xE3, 0x86, 0x8C },
	0xA4FD, { 0xE3, 0x86, 0x8D },
	0xA4FE, { 0xE3, 0x86, 0x8E },
	0xA541, { 0xEC, 0xA9, 0x87 },
	0xA542, { 0xEC, 0xA9, 0x88 },
	0xA543, { 0xEC, 0xA9, 0x89 },
	0xA544, { 0xEC, 0xA9, 0x8A },
	0xA545, { 0xEC, 0xA9, 0x8B },
	0xA546, { 0xEC, 0xA9, 0x8E },
	0xA547, { 0xEC, 0xA9, 0x8F },
	0xA548, { 0xEC, 0xA9, 0x91 },
	0xA549, { 0xEC, 0xA9, 0x92 },
	0xA54A, { 0xEC, 0xA9, 0x93 },
	0xA54B, { 0xEC, 0xA9, 0x95 },
	0xA54C, { 0xEC, 0xA9, 0x96 },
	0xA54D, { 0xEC, 0xA9, 0x97 },
	0xA54E, { 0xEC, 0xA9, 0x98 },
	0xA54F, { 0xEC, 0xA9, 0x99 },
	0xA550, { 0xEC, 0xA9, 0x9A },
	0xA551, { 0xEC, 0xA9, 0x9B },
	0xA552, { 0xEC, 0xA9, 0x9E },
	0xA553, { 0xEC, 0xA9, 0xA2 },
	0xA554, { 0xEC, 0xA9, 0xA3 },
	0xA555, { 0xEC, 0xA9, 0xA4 },
	0xA556, { 0xEC, 0xA9, 0xA5 },
	0xA557, { 0xEC, 0xA9, 0xA6 },
	0xA558, { 0xEC, 0xA9, 0xA7 },
	0xA559, { 0xEC, 0xA9, 0xA9 },
	0xA55A, { 0xEC, 0xA9, 0xAA },
	0xA561, { 0xEC, 0xA9, 0xAB },
	0xA562, { 0xEC, 0xA9, 0xAC },
	0xA563, { 0xEC, 0xA9, 0xAD },
	0xA564, { 0xEC, 0xA9, 0xAE },
	0xA565, { 0xEC, 0xA9, 0xAF },
	0xA566, { 0xEC, 0xA9, 0xB0 },
	0xA567, { 0xEC, 0xA9, 0xB1 },
	0xA568, { 0xEC, 0xA9, 0xB2 },
	0xA569, { 0xEC, 0xA9, 0xB3 },
	0xA56A, { 0xEC, 0xA9, 0xB4 },
	0xA56B, { 0xEC, 0xA9, 0xB5 },
	0xA56C, { 0xEC, 0xA9, 0xB6 },
	0xA56D, { 0xEC, 0xA9, 0xB7 },
	0xA56E, { 0xEC, 0xA9, 0xB8 },
	0xA56F, { 0xEC, 0xA9, 0xB9 },
	0xA570, { 0xEC, 0xA9, 0xBA },
	0xA571, { 0xEC, 0xA9, 0xBB },
	0xA572, { 0xEC, 0xA9, 0xBC },
	0xA573, { 0xEC, 0xA9, 0xBE },
	0xA574, { 0xEC, 0xA9, 0xBF },
	0xA575, { 0xEC, 0xAA, 0x80 },
	0xA576, { 0xEC, 0xAA, 0x81 },
	0xA577, { 0xEC, 0xAA, 0x82 },
	0xA578, { 0xEC, 0xAA, 0x83 },
	0xA579, { 0xEC, 0xAA, 0x85 },
	0xA57A, { 0xEC, 0xAA, 0x86 },
	0xA581, { 0xEC, 0xAA, 0x87 },
	0xA582, { 0xEC, 0xAA, 0x88 },
	0xA583, { 0xEC, 0xAA, 0x89 },
	0xA584, { 0xEC, 0xAA, 0x8A },
	0xA585, { 0xEC, 0xAA, 0x8B },
	0xA586, { 0xEC, 0xAA, 0x8C },
	0xA587, { 0xEC, 0xAA, 0x8D },
	0xA588, { 0xEC, 0xAA, 0x8E },
	0xA589, { 0xEC, 0xAA, 0x8F },
	0xA58A, { 0xEC, 0xAA, 0x90 },
	0xA58B, { 0xEC, 0xAA, 0x91 },
	0xA58C, { 0xEC, 0xAA, 0x92 },
	0xA58D, { 0xEC, 0xAA, 0x93 },
	0xA58E, { 0xEC, 0xAA, 0x94 },
	0xA58F, { 0xEC, 0xAA, 0x95 },
	0xA590, { 0xEC, 0xAA, 0x96 },
	0xA591, { 0xEC, 0xAA, 0x97 },
	0xA592, { 0xEC, 0xAA, 0x99 },
	0xA593, { 0xEC, 0xAA, 0x9A },
	0xA594, { 0xEC, 0xAA, 0x9B },
	0xA595, { 0xEC, 0xAA, 0x9C },
	0xA596, { 0xEC, 0xAA, 0x9D },
	0xA597, { 0xEC, 0xAA, 0x9E },
	0xA598, { 0xEC, 0xAA, 0x9F },
	0xA599, { 0xEC, 0xAA, 0xA0 },
	0xA59A, { 0xEC, 0xAA, 0xA1 },
	0xA59B, { 0xEC, 0xAA, 0xA2 },
	0xA59C, { 0xEC, 0xAA, 0xA3 },
	0xA59D, { 0xEC, 0xAA, 0xA4 },
	0xA59E, { 0xEC, 0xAA, 0xA5 },
	0xA59F, { 0xEC, 0xAA, 0xA6 },
	0xA5A0, { 0xEC, 0xAA, 0xA7 },
	0xA5A1, { 0xE2, 0x85, 0xB0 },
	0xA5A2, { 0xE2, 0x85, 0xB1 },
	0xA5A3, { 0xE2, 0x85, 0xB2 },
	0xA5A4, { 0xE2, 0x85, 0xB3 },
	0xA5A5, { 0xE2, 0x85, 0xB4 },
	0xA5A6, { 0xE2, 0x85, 0xB5 },
	0xA5A7, { 0xE2, 0x85, 0xB6 },
	0xA5A8, { 0xE2, 0x85, 0xB7 },
	0xA5A9, { 0xE2, 0x85, 0xB8 },
	0xA5AA, { 0xE2, 0x85, 0xB9 },
	0xA5B0, { 0xE2, 0x85, 0xA0 },
	0xA5B1, { 0xE2, 0x85, 0xA1 },
	0xA5B2, { 0xE2, 0x85, 0xA2 },
	0xA5B3, { 0xE2, 0x85, 0xA3 },
	0xA5B4, { 0xE2, 0x85, 0xA4 },
	0xA5B5, { 0xE2, 0x85, 0xA5 },
	0xA5B6, { 0xE2, 0x85, 0xA6 },
	0xA5B7, { 0xE2, 0x85, 0xA7 },
	0xA5B8, { 0xE2, 0x85, 0xA8 },
	0xA5B9, { 0xE2, 0x85, 0xA9 },
	0xA5C1, { 0xCE, 0x91 },
	0xA5C2, { 0xCE, 0x92 },
	0xA5C3, { 0xCE, 0x93 },
	0xA5C4, { 0xCE, 0x94 },
	0xA5C5, { 0xCE, 0x95 },
	0xA5C6, { 0xCE, 0x96 },
	0xA5C7, { 0xCE, 0x97 },
	0xA5C8, { 0xCE, 0x98 },
	0xA5C9, { 0xCE, 0x99 },
	0xA5CA, { 0xCE, 0x9A },
	0xA5CB, { 0xCE, 0x9B },
	0xA5CC, { 0xCE, 0x9C },
	0xA5CD, { 0xCE, 0x9D },
	0xA5CE, { 0xCE, 0x9E },
	0xA5CF, { 0xCE, 0x9F },
	0xA5D0, { 0xCE, 0xA0 },
	0xA5D1, { 0xCE, 0xA1 },
	0xA5D2, { 0xCE, 0xA3 },
	0xA5D3, { 0xCE, 0xA4 },
	0xA5D4, { 0xCE, 0xA5 },
	0xA5D5, { 0xCE, 0xA6 },
	0xA5D6, { 0xCE, 0xA7 },
	0xA5D7, { 0xCE, 0xA8 },
	0xA5D8, { 0xCE, 0xA9 },
	0xA5E1, { 0xCE, 0xB1 },
	0xA5E2, { 0xCE, 0xB2 },
	0xA5E3, { 0xCE, 0xB3 },
	0xA5E4, { 0xCE, 0xB4 },
	0xA5E5, { 0xCE, 0xB5 },
	0xA5E6, { 0xCE, 0xB6 },
	0xA5E7, { 0xCE, 0xB7 },
	0xA5E8, { 0xCE, 0xB8 },
	0xA5E9, { 0xCE, 0xB9 },
	0xA5EA, { 0xCE, 0xBA },
	0xA5EB, { 0xCE, 0xBB },
	0xA5EC, { 0xCE, 0xBC },
	0xA5ED, { 0xCE, 0xBD },
	0xA5EE, { 0xCE, 0xBE },
	0xA5EF, { 0xCE, 0xBF },
	0xA5F0, { 0xCF, 0x80 },
	0xA5F1, { 0xCF, 0x81 },
	0xA5F2, { 0xCF, 0x83 },
	0xA5F3, { 0xCF, 0x84 },
	0xA5F4, { 0xCF, 0x85 },
	0xA5F5, { 0xCF, 0x86 },
	0xA5F6, { 0xCF, 0x87 },
	0xA5F7, { 0xCF, 0x88 },
	0xA5F8, { 0xCF, 0x89 },
	0xA641, { 0xEC, 0xAA, 0xA8 },
	0xA642, { 0xEC, 0xAA, 0xA9 },
	0xA643, { 0xEC, 0xAA, 0xAA },
	0xA644, { 0xEC, 0xAA, 0xAB },
	0xA645, { 0xEC, 0xAA, 0xAC },
	0xA646, { 0xEC, 0xAA, 0xAD },
	0xA647, { 0xEC, 0xAA, 0xAE },
	0xA648, { 0xEC, 0xAA, 0xAF },
	0xA649, { 0xEC, 0xAA, 0xB0 },
	0xA64A, { 0xEC, 0xAA, 0xB1 },
	0xA64B, { 0xEC, 0xAA, 0xB2 },
	0xA64C, { 0xEC, 0xAA, 0xB3 },
	0xA64D, { 0xEC, 0xAA, 0xB4 },
	0xA64E, { 0xEC, 0xAA, 0xB5 },
	0xA64F, { 0xEC, 0xAA, 0xB6 },
	0xA650, { 0xEC, 0xAA, 0xB7 },
	0xA651, { 0xEC, 0xAA, 0xB8 },
	0xA652, { 0xEC, 0xAA, 0xB9 },
	0xA653, { 0xEC, 0xAA, 0xBA },
	0xA654, { 0xEC, 0xAA, 0xBB },
	0xA655, { 0xEC, 0xAA, 0xBE },
	0xA656, { 0xEC, 0xAA, 0xBF },
	0xA657, { 0xEC, 0xAB, 0x81 },
	0xA658, { 0xEC, 0xAB, 0x82 },
	0xA659, { 0xEC, 0xAB, 0x83 },
	0xA65A, { 0xEC, 0xAB, 0x85 },
	0xA661, { 0xEC, 0xAB, 0x86 },
	0xA662, { 0xEC, 0xAB, 0x87 },
	0xA663, { 0xEC, 0xAB, 0x88 },
	0xA664, { 0xEC, 0xAB, 0x89 },
	0xA665, { 0xEC, 0xAB, 0x8A },
	0xA666, { 0xEC, 0xAB, 0x8B },
	0xA667, { 0xEC, 0xAB, 0x8E },
	0xA668, { 0xEC, 0xAB, 0x90 },
	0xA669, { 0xEC, 0xAB, 0x92 },
	0xA66A, { 0xEC, 0xAB, 0x94 },
	0xA66B, { 0xEC, 0xAB, 0x95 },
	0xA66C, { 0xEC, 0xAB, 0x96 },
	0xA66D, { 0xEC, 0xAB, 0x97 },
	0xA66E, { 0xEC, 0xAB, 0x9A },
	0xA66F, { 0xEC, 0xAB, 0x9B },
	0xA670, { 0xEC, 0xAB, 0x9C },
	0xA671, { 0xEC, 0xAB, 0x9D },
	0xA672, { 0xEC, 0xAB, 0x9E },
	0xA673, { 0xEC, 0xAB, 0x9F },
	0xA674, { 0xEC, 0xAB, 0xA1 },
	0xA675, { 0xEC, 0xAB, 0xA2 },
	0xA676, { 0xEC, 0xAB, 0xA3 },
	0xA677, { 0xEC, 0xAB, 0xA4 },
	0xA678, { 0xEC, 0xAB, 0xA5 },
	0xA679, { 0xEC, 0xAB, 0xA6 },
	0xA67A, { 0xEC, 0xAB, 0xA7 },
	0xA681, { 0xEC, 0xAB, 0xA8 },
	0xA682, { 0xEC, 0xAB, 0xA9 },
	0xA683, { 0xEC, 0xAB, 0xAA },
	0xA684, { 0xEC, 0xAB, 0xAB },
	0xA685, { 0xEC, 0xAB, 0xAD },
	0xA686, { 0xEC, 0xAB, 0xAE },
	0xA687, { 0xEC, 0xAB, 0xAF },
	0xA688, { 0xEC, 0xAB, 0xB0 },
	0xA689, { 0xEC, 0xAB, 0xB1 },
	0xA68A, { 0xEC, 0xAB, 0xB2 },
	0xA68B, { 0xEC, 0xAB, 0xB3 },
	0xA68C, { 0xEC, 0xAB, 0xB5 },
	0xA68D, { 0xEC, 0xAB, 0xB6 },
	0xA68E, { 0xEC, 0xAB, 0xB7 },
	0xA68F, { 0xEC, 0xAB, 0xB8 },
	0xA690, { 0xEC, 0xAB, 0xB9 },
	0xA691, { 0xEC, 0xAB, 0xBA },
	0xA692, { 0xEC, 0xAB, 0xBB },
	0xA693, { 0xEC, 0xAB, 0xBC },
	0xA694, { 0xEC, 0xAB, 0xBD },
	0xA695, { 0xEC, 0xAB, 0xBE },
	0xA696, { 0xEC, 0xAB, 0xBF },
	0xA697, { 0xEC, 0xAC, 0x80 },
	0xA698, { 0xEC, 0xAC, 0x81 },
	0xA699, { 0xEC, 0xAC, 0x82 },
	0xA69A, { 0xEC, 0xAC, 0x83 },
	0xA69B, { 0xEC, 0xAC, 0x84 },
	0xA69C, { 0xEC, 0xAC, 0x85 },
	0xA69D, { 0xEC, 0xAC, 0x86 },
	0xA69E, { 0xEC, 0xAC, 0x87 },
	0xA69F, { 0xEC, 0xAC, 0x89 },
	0xA6A0, { 0xEC, 0xAC, 0x8A },
	0xA6A1, { 0xE2, 0x94, 0x80 },
	0xA6A2, { 0xE2, 0x94, 0x82 },
	0xA6A3, { 0xE2, 0x94, 0x8C },
	0xA6A4, { 0xE2, 0x94, 0x90 },
	0xA6A5, { 0xE2, 0x94, 0x98 },
	0xA6A6, { 0xE2, 0x94, 0x94 },
	0xA6A7, { 0xE2, 0x94, 0x9C },
	0xA6A8, { 0xE2, 0x94, 0xAC },
	0xA6A9, { 0xE2, 0x94, 0xA4 },
	0xA6AA, { 0xE2, 0x94, 0xB4 },
	0xA6AB, { 0xE2, 0x94, 0xBC },
	0xA6AC, { 0xE2, 0x94, 0x81 },
	0xA6AD, { 0xE2, 0x94, 0x83 },
	0xA6AE, { 0xE2, 0x94, 0x8F },
	0xA6AF, { 0xE2, 0x94, 0x93 },
	0xA6B0, { 0xE2, 0x94, 0x9B },
	0xA6B1, { 0xE2, 0x94, 0x97 },
	0xA6B2, { 0xE2, 0x94, 0xA3 },
	0xA6B3, { 0xE2, 0x94, 0xB3 },
	0xA6B4, { 0xE2, 0x94, 0xAB },
	0xA6B5, { 0xE2, 0x94, 0xBB },
	0xA6B6, { 0xE2, 0x95, 0x8B },
	0xA6B7, { 0xE2, 0x94, 0xA0 },
	0xA6B8, { 0xE2, 0x94, 0xAF },
	0xA6B9, { 0xE2, 0x94, 0xA8 },
	0xA6BA, { 0xE2, 0x94, 0xB7 },
	0xA6BB, { 0xE2, 0x94, 0xBF },
	0xA6BC, { 0xE2, 0x94, 0x9D },
	0xA6BD, { 0xE2, 0x94, 0xB0 },
	0xA6BE, { 0xE2, 0x94, 0xA5 },
	0xA6BF, { 0xE2, 0x94, 0xB8 },
	0xA6C0, { 0xE2, 0x95, 0x82 },
	0xA6C1, { 0xE2, 0x94, 0x92 },
	0xA6C2, { 0xE2, 0x94, 0x91 },
	0xA6C3, { 0xE2, 0x94, 0x9A },
	0xA6C4, { 0xE2, 0x94, 0x99 },
	0xA6C5, { 0xE2, 0x94, 0x96 },
	0xA6C6, { 0xE2, 0x94, 0x95 },
	0xA6C7, { 0xE2, 0x94, 0x8E },
	0xA6C8, { 0xE2, 0x94, 0x8D },
	0xA6C9, { 0xE2, 0x94, 0x9E },
	0xA6CA, { 0xE2, 0x94, 0x9F },
	0xA6CB, { 0xE2, 0x94, 0xA1 },
	0xA6CC, { 0xE2, 0x94, 0xA2 },
	0xA6CD, { 0xE2, 0x94, 0xA6 },
	0xA6CE, { 0xE2, 0x94, 0xA7 },
	0xA6CF, { 0xE2, 0x94, 0xA9 },
	0xA6D0, { 0xE2, 0x94, 0xAA },
	0xA6D1, { 0xE2, 0x94, 0xAD },
	0xA6D2, { 0xE2, 0x94, 0xAE },
	0xA6D3, { 0xE2, 0x94, 0xB1 },
	0xA6D4, { 0xE2, 0x94, 0xB2 },
	0xA6D5, { 0xE2, 0x94, 0xB5 },
	0xA6D6, { 0xE2, 0x94, 0xB6 },
	0xA6D7, { 0xE2, 0x94, 0xB9 },
	0xA6D8, { 0xE2, 0x94, 0xBA },
	0xA6D9, { 0xE2, 0x94, 0xBD },
	0xA6DA, { 0xE2, 0x94, 0xBE },
	0xA6DB, { 0xE2, 0x95, 0x80 },
	0xA6DC, { 0xE2, 0x95, 0x81 },
	0xA6DD, { 0xE2, 0x95, 0x83 },
	0xA6DE, { 0xE2, 0x95, 0x84 },
	0xA6DF, { 0xE2, 0x95, 0x85 },
	0xA6E0, { 0xE2, 0x95, 0x86 },
	0xA6E1, { 0xE2, 0x95, 0x87 },
	0xA6E2, { 0xE2, 0x95, 0x88 },
	0xA6E3, { 0xE2, 0x95, 0x89 },
	0xA6E4, { 0xE2, 0x95, 0x8A },
	0xA741, { 0xEC, 0xAC, 0x8B },
	0xA742, { 0xEC, 0xAC, 0x8C },
	0xA743, { 0xEC, 0xAC, 0x8D },
	0xA744, { 0xEC, 0xAC, 0x8E },
	0xA745, { 0xEC, 0xAC, 0x8F },
	0xA746, { 0xEC, 0xAC, 0x91 },
	0xA747, { 0xEC, 0xAC, 0x92 },
	0xA748, { 0xEC, 0xAC, 0x93 },
	0xA749, { 0xEC, 0xAC, 0x95 },
	0xA74A, { 0xEC, 0xAC, 0x96 },
	0xA74B, { 0xEC, 0xAC, 0x97 },
	0xA74C, { 0xEC, 0xAC, 0x99 },
	0xA74D, { 0xEC, 0xAC, 0x9A },
	0xA74E, { 0xEC, 0xAC, 0x9B },
	0xA74F, { 0xEC, 0xAC, 0x9C },
	0xA750, { 0xEC, 0xAC, 0x9D },
	0xA751, { 0xEC, 0xAC, 0x9E },
	0xA752, { 0xEC, 0xAC, 0x9F },
	0xA753, { 0xEC, 0xAC, 0xA2 },
	0xA754, { 0xEC, 0xAC, 0xA3 },
	0xA755, { 0xEC, 0xAC, 0xA4 },
	0xA756, { 0xEC, 0xAC, 0xA5 },
	0xA757, { 0xEC, 0xAC, 0xA6 },
	0xA758, { 0xEC, 0xAC, 0xA7 },
	0xA759, { 0xEC, 0xAC, 0xA8 },
	0xA75A, { 0xEC, 0xAC, 0xA9 },
	0xA761, { 0xEC, 0xAC, 0xAA },
	0xA762, { 0xEC, 0xAC, 0xAB },
	0xA763, { 0xEC, 0xAC, 0xAC },
	0xA764, { 0xEC, 0xAC, 0xAD },
	0xA765, { 0xEC, 0xAC, 0xAE },
	0xA766, { 0xEC, 0xAC, 0xAF },
	0xA767, { 0xEC, 0xAC, 0xB0 },
	0xA768, { 0xEC, 0xAC, 0xB1 },
	0xA769, { 0xEC, 0xAC, 0xB2 },
	0xA76A, { 0xEC, 0xAC, 0xB3 },
	0xA76B, { 0xEC, 0xAC, 0xB4 },
	0xA76C, { 0xEC, 0xAC, 0xB5 },
	0xA76D, { 0xEC, 0xAC, 0xB6 },
	0xA76E, { 0xEC, 0xAC, 0xB7 },
	0xA76F, { 0xEC, 0xAC, 0xB8 },
	0xA770, { 0xEC, 0xAC, 0xB9 },
	0xA771, { 0xEC, 0xAC, 0xBA },
	0xA772, { 0xEC, 0xAC, 0xBB },
	0xA773, { 0xEC, 0xAC, 0xBC },
	0xA774, { 0xEC, 0xAC, 0xBD },
	0xA775, { 0xEC, 0xAC, 0xBE },
	0xA776, { 0xEC, 0xAC, 0xBF },
	0xA777, { 0xEC, 0xAD, 0x80 },
	0xA778, { 0xEC, 0xAD, 0x82 },
	0xA779, { 0xEC, 0xAD, 0x83 },
	0xA77A, { 0xEC, 0xAD, 0x84 },
	0xA781, { 0xEC, 0xAD, 0x85 },
	0xA782, { 0xEC, 0xAD, 0x86 },
	0xA783, { 0xEC, 0xAD, 0x87 },
	0xA784, { 0xEC, 0xAD, 0x8A },
	0xA785, { 0xEC, 0xAD, 0x8B },
	0xA786, { 0xEC, 0xAD, 0x8D },
	0xA787, { 0xEC, 0xAD, 0x8E },
	0xA788, { 0xEC, 0xAD, 0x8F },
	0xA789, { 0xEC, 0xAD, 0x91 },
	0xA78A, { 0xEC, 0xAD, 0x92 },
	0xA78B, { 0xEC, 0xAD, 0x93 },
	0xA78C, { 0xEC, 0xAD, 0x94 },
	0xA78D, { 0xEC, 0xAD, 0x95 },
	0xA78E, { 0xEC, 0xAD, 0x96 },
	0xA78F, { 0xEC, 0xAD, 0x97 },
	0xA790, { 0xEC, 0xAD, 0x9A },
	0xA791, { 0xEC, 0xAD, 0x9B },
	0xA792, { 0xEC, 0xAD, 0x9C },
	0xA793, { 0xEC, 0xAD, 0x9E },
	0xA794, { 0xEC, 0xAD, 0x9F },
	0xA795, { 0xEC, 0xAD, 0xA0 },
	0xA796, { 0xEC, 0xAD, 0xA1 },
	0xA797, { 0xEC, 0xAD, 0xA2 },
	0xA798, { 0xEC, 0xAD, 0xA3 },
	0xA799, { 0xEC, 0xAD, 0xA5 },
	0xA79A, { 0xEC, 0xAD, 0xA6 },
	0xA79B, { 0xEC, 0xAD, 0xA7 },
	0xA79C, { 0xEC, 0xAD, 0xA8 },
	0xA79D, { 0xEC, 0xAD, 0xA9 },
	0xA79E, { 0xEC, 0xAD, 0xAA },
	0xA79F, { 0xEC, 0xAD, 0xAB },
	0xA7A0, { 0xEC, 0xAD, 0xAC },
	0xA7A1, { 0xE3, 0x8E, 0x95 },
	0xA7A2, { 0xE3, 0x8E, 0x96 },
	0xA7A3, { 0xE3, 0x8E, 0x97 },
	0xA7A4, { 0xE2, 0x84, 0x93 },
	0xA7A5, { 0xE3, 0x8E, 0x98 },
	0xA7A6, { 0xE3, 0x8F, 0x84 },
	0xA7A7, { 0xE3, 0x8E, 0xA3 },
	0xA7A8, { 0xE3, 0x8E, 0xA4 },
	0xA7A9, { 0xE3, 0x8E, 0xA5 },
	0xA7AA, { 0xE3, 0x8E, 0xA6 },
	0xA7AB, { 0xE3, 0x8E, 0x99 },
	0xA7AC, { 0xE3, 0x8E, 0x9A },
	0xA7AD, { 0xE3, 0x8E, 0x9B },
	0xA7AE, { 0xE3, 0x8E, 0x9C },
	0xA7AF, { 0xE3, 0x8E, 0x9D },
	0xA7B0, { 0xE3, 0x8E, 0x9E },
	0xA7B1, { 0xE3, 0x8E, 0x9F },
	0xA7B2, { 0xE3, 0x8E, 0xA0 },
	0xA7B3, { 0xE3, 0x8E, 0xA1 },
	0xA7B4, { 0xE3, 0x8E, 0xA2 },
	0xA7B5, { 0xE3, 0x8F, 0x8A },
	0xA7B6, { 0xE3, 0x8E, 0x8D },
	0xA7B7, { 0xE3, 0x8E, 0x8E },
	0xA7B8, { 0xE3, 0x8E, 0x8F },
	0xA7B9, { 0xE3, 0x8F, 0x8F },
	0xA7BA, { 0xE3, 0x8E, 0x88 },
	0xA7BB, { 0xE3, 0x8E, 0x89 },
	0xA7BC, { 0xE3, 0x8F, 0x88 },
	0xA7BD, { 0xE3, 0x8E, 0xA7 },
	0xA7BE, { 0xE3, 0x8E, 0xA8 },
	0xA7BF, { 0xE3, 0x8E, 0xB0 },
	0xA7C0, { 0xE3, 0x8E, 0xB1 },
	0xA7C1, { 0xE3, 0x8E, 0xB2 },
	0xA7C2, { 0xE3, 0x8E, 0xB3 },
	0xA7C3, { 0xE3, 0x8E, 0xB4 },
	0xA7C4, { 0xE3, 0x8E, 0xB5 },
	0xA7C5, { 0xE3, 0x8E, 0xB6 },
	0xA7C6, { 0xE3, 0x8E, 0xB7 },
	0xA7C7, { 0xE3, 0x8E, 0xB8 },
	0xA7C8, { 0xE3, 0x8E, 0xB9 },
	0xA7C9, { 0xE3, 0x8E, 0x80 },
	0xA7CA, { 0xE3, 0x8E, 0x81 },
	0xA7CB, { 0xE3, 0x8E, 0x82 },
	0xA7CC, { 0xE3, 0x8E, 0x83 },
	0xA7CD, { 0xE3, 0x8E, 0x84 },
	0xA7CE, { 0xE3, 0x8E, 0xBA },
	0xA7CF, { 0xE3, 0x8E, 0xBB },
	0xA7D0, { 0xE3, 0x8E, 0xBC },
	0xA7D1, { 0xE3, 0x8E, 0xBD },
	0xA7D2, { 0xE3, 0x8E, 0xBE },
	0xA7D3, { 0xE3, 0x8E, 0xBF },
	0xA7D4, { 0xE3, 0x8E, 0x90 },
	0xA7D5, { 0xE3, 0x8E, 0x91 },
	0xA7D6, { 0xE3, 0x8E, 0x92 },
	0xA7D7, { 0xE3, 0x8E, 0x93 },
	0xA7D8, { 0xE3, 0x8E, 0x94 },
	0xA7D9, { 0xE2, 0x84, 0xA6 },
	0xA7DA, { 0xE3, 0x8F, 0x80 },
	0xA7DB, { 0xE3, 0x8F, 0x81 },
	0xA7DC, { 0xE3, 0x8E, 0x8A },
	0xA7DD, { 0xE3, 0x8E, 0x8B },
	0xA7DE, { 0xE3, 0x8E, 0x8C },
	0xA7DF, { 0xE3, 0x8F, 0x96 },
	0xA7E0, { 0xE3, 0x8F, 0x85 },
	0xA7E1, { 0xE3, 0x8E, 0xAD },
	0xA7E2, { 0xE3, 0x8E, 0xAE },
	0xA7E3, { 0xE3, 0x8E, 0xAF },
	0xA7E4, { 0xE3, 0x8F, 0x9B },
	0xA7E5, { 0xE3, 0x8E, 0xA9 },
	0xA7E6, { 0xE3, 0x8E, 0xAA },
	0xA7E7, { 0xE3, 0x8E, 0xAB },
	0xA7E8, { 0xE3, 0x8E, 0xAC },
	0xA7E9, { 0xE3, 0x8F, 0x9D },
	0xA7EA, { 0xE3, 0x8F, 0x90 },
	0xA7EB, { 0xE3, 0x8F, 0x93 },
	0xA7EC, { 0xE3, 0x8F, 0x83 },
	0xA7ED, { 0xE3, 0x8F, 0x89 },
	0xA7EE, { 0xE3, 0x8F, 0x9C },
	0xA7EF, { 0xE3, 0x8F, 0x86 },
	0xA841, { 0xEC, 0xAD, 0xAD },
	0xA842, { 0xEC, 0xAD, 0xAE },
	0xA843, { 0xEC, 0xAD, 0xAF },
	0xA844, { 0xEC, 0xAD, 0xB0 },
	0xA845, { 0xEC, 0xAD, 0xB1 },
	0xA846, { 0xEC, 0xAD, 0xB2 },
	0xA847, { 0xEC, 0xAD, 0xB3 },
	0xA848, { 0xEC, 0xAD, 0xB4 },
	0xA849, { 0xEC, 0xAD, 0xB5 },
	0xA84A, { 0xEC, 0xAD, 0xB6 },
	0xA84B, { 0xEC, 0xAD, 0xB7 },
	0xA84C, { 0xEC, 0xAD, 0xBA },
	0xA84D, { 0xEC, 0xAD, 0xBB },
	0xA84E, { 0xEC, 0xAD, 0xBC },
	0xA84F, { 0xEC, 0xAD, 0xBD },
	0xA850, { 0xEC, 0xAD, 0xBE },
	0xA851, { 0xEC, 0xAD, 0xBF },
	0xA852, { 0xEC, 0xAE, 0x80 },
	0xA853, { 0xEC, 0xAE, 0x81 },
	0xA854, { 0xEC, 0xAE, 0x82 },
	0xA855, { 0xEC, 0xAE, 0x83 },
	0xA856, { 0xEC, 0xAE, 0x84 },
	0xA857, { 0xEC, 0xAE, 0x85 },
	0xA858, { 0xEC, 0xAE, 0x86 },
	0xA859, { 0xEC, 0xAE, 0x87 },
	0xA85A, { 0xEC, 0xAE, 0x88 },
	0xA861, { 0xEC, 0xAE, 0x89 },
	0xA862, { 0xEC, 0xAE, 0x8A },
	0xA863, { 0xEC, 0xAE, 0x8B },
	0xA864, { 0xEC, 0xAE, 0x8C },
	0xA865, { 0xEC, 0xAE, 0x8D },
	0xA866, { 0xEC, 0xAE, 0x8E },
	0xA867, { 0xEC, 0xAE, 0x8F },
	0xA868, { 0xEC, 0xAE, 0x90 },
	0xA869, { 0xEC, 0xAE, 0x91 },
	0xA86A, { 0xEC, 0xAE, 0x92 },
	0xA86B, { 0xEC, 0xAE, 0x93 },
	0xA86C, { 0xEC, 0xAE, 0x94 },
	0xA86D, { 0xEC, 0xAE, 0x95 },
	0xA86E, { 0xEC, 0xAE, 0x96 },
	0xA86F, { 0xEC, 0xAE, 0x97 },
	0xA870, { 0xEC, 0xAE, 0x98 },
	0xA871, { 0xEC, 0xAE, 0x99 },
	0xA872, { 0xEC, 0xAE, 0x9A },
	0xA873, { 0xEC, 0xAE, 0x9B },
	0xA874, { 0xEC, 0xAE, 0x9D },
	0xA875, { 0xEC, 0xAE, 0x9E },
	0xA876, { 0xEC, 0xAE, 0x9F },
	0xA877, { 0xEC, 0xAE, 0xA0 },
	0xA878, { 0xEC, 0xAE, 0xA1 },
	0xA879, { 0xEC, 0xAE, 0xA2 },
	0xA87A, { 0xEC, 0xAE, 0xA3 },
	0xA881, { 0xEC, 0xAE, 0xA4 },
	0xA882, { 0xEC, 0xAE, 0xA5 },
	0xA883, { 0xEC, 0xAE, 0xA6 },
	0xA884, { 0xEC, 0xAE, 0xA7 },
	0xA885, { 0xEC, 0xAE, 0xA8 },
	0xA886, { 0xEC, 0xAE, 0xA9 },
	0xA887, { 0xEC, 0xAE, 0xAA },
	0xA888, { 0xEC, 0xAE, 0xAB },
	0xA889, { 0xEC, 0xAE, 0xAC },
	0xA88A, { 0xEC, 0xAE, 0xAD },
	0xA88B, { 0xEC, 0xAE, 0xAE },
	0xA88C, { 0xEC, 0xAE, 0xAF },
	0xA88D, { 0xEC, 0xAE, 0xB0 },
	0xA88E, { 0xEC, 0xAE, 0xB1 },
	0xA88F, { 0xEC, 0xAE, 0xB2 },
	0xA890, { 0xEC, 0xAE, 0xB3 },
	0xA891, { 0xEC, 0xAE, 0xB4 },
	0xA892, { 0xEC, 0xAE, 0xB5 },
	0xA893, { 0xEC, 0xAE, 0xB6 },
	0xA894, { 0xEC, 0xAE, 0xB7 },
	0xA895, { 0xEC, 0xAE, 0xB9 },
	0xA896, { 0xEC, 0xAE, 0xBA },
	0xA897, { 0xEC, 0xAE, 0xBB },
	0xA898, { 0xEC, 0xAE, 0xBC },
	0xA899, { 0xEC, 0xAE, 0xBD },
	0xA89A, { 0xEC, 0xAE, 0xBE },
	0xA89B, { 0xEC, 0xAE, 0xBF },
	0xA89C, { 0xEC, 0xAF, 0x80 },
	0xA89D, { 0xEC, 0xAF, 0x81 },
	0xA89E, { 0xEC, 0xAF, 0x82 },
	0xA89F, { 0xEC, 0xAF, 0x83 },
	0xA8A0, { 0xEC, 0xAF, 0x84 },
	0xA8A1, { 0xC3, 0x86 },
	0xA8A2, { 0xC3, 0x90 },
	0xA8A3, { 0xC2, 0xAA },
	0xA8A4, { 0xC4, 0xA6 },
	0xA8A6, { 0xC4, 0xB2 },
	0xA8A8, { 0xC4, 0xBF },
	0xA8A9, { 0xC5, 0x81 },
	0xA8AA, { 0xC3, 0x98 },
	0xA8AB, { 0xC5, 0x92 },
	0xA8AC, { 0xC2, 0xBA },
	0xA8AD, { 0xC3, 0x9E },
	0xA8AE, { 0xC5, 0xA6 },
	0xA8AF, { 0xC5, 0x8A },
	0xA8B1, { 0xE3, 0x89, 0xA0 },
	0xA8B2, { 0xE3, 0x89, 0xA1 },
	0xA8B3, { 0xE3, 0x89, 0xA2 },
	0xA8B4, { 0xE3, 0x89, 0xA3 },
	0xA8B5, { 0xE3, 0x89, 0xA4 },
	0xA8B6, { 0xE3, 0x89, 0xA5 },
	0xA8B7, { 0xE3, 0x89, 0xA6 },
	0xA8B8, { 0xE3, 0x89, 0xA7 },
	0xA8B9, { 0xE3, 0x89, 0xA8 },
	0xA8BA, { 0xE3, 0x89, 0xA9 },
	0xA8BB, { 0xE3, 0x89, 0xAA },
	0xA8BC, { 0xE3, 0x89, 0xAB },
	0xA8BD, { 0xE3, 0x89, 0xAC },
	0xA8BE, { 0xE3, 0x89, 0xAD },
	0xA8BF, { 0xE3, 0x89, 0xAE },
	0xA8C0, { 0xE3, 0x89, 0xAF },
	0xA8C1, { 0xE3, 0x89, 0xB0 },
	0xA8C2, { 0xE3, 0x89, 0xB1 },
	0xA8C3, { 0xE3, 0x89, 0xB2 },
	0xA8C4, { 0xE3, 0x89, 0xB3 },
	0xA8C5, { 0xE3, 0x89, 0xB4 },
	0xA8C6, { 0xE3, 0x89, 0xB5 },
	0xA8C7, { 0xE3, 0x89, 0xB6 },
	0xA8C8, { 0xE3, 0x89, 0xB7 },
	0xA8C9, { 0xE3, 0x89, 0xB8 },
	0xA8CA, { 0xE3, 0x89, 0xB9 },
	0xA8CB, { 0xE3, 0x89, 0xBA },
	0xA8CC, { 0xE3, 0x89, 0xBB },
	0xA8CD, { 0xE2, 0x93, 0x90 },
	0xA8CE, { 0xE2, 0x93, 0x91 },
	0xA8CF, { 0xE2, 0x93, 0x92 },
	0xA8D0, { 0xE2, 0x93, 0x93 },
	0xA8D1, { 0xE2, 0x93, 0x94 },
	0xA8D2, { 0xE2, 0x93, 0x95 },
	0xA8D3, { 0xE2, 0x93, 0x96 },
	0xA8D4, { 0xE2, 0x93, 0x97 },
	0xA8D5, { 0xE2, 0x93, 0x98 },
	0xA8D6, { 0xE2, 0x93, 0x99 },
	0xA8D7, { 0xE2, 0x93, 0x9A },
	0xA8D8, { 0xE2, 0x93, 0x9B },
	0xA8D9, { 0xE2, 0x93, 0x9C },
	0xA8DA, { 0xE2, 0x93, 0x9D },
	0xA8DB, { 0xE2, 0x93, 0x9E },
	0xA8DC, { 0xE2, 0x93, 0x9F },
	0xA8DD, { 0xE2, 0x93, 0xA0 },
	0xA8DE, { 0xE2, 0x93, 0xA1 },
	0xA8DF, { 0xE2, 0x93, 0xA2 },
	0xA8E0, { 0xE2, 0x93, 0xA3 },
	0xA8E1, { 0xE2, 0x93, 0xA4 },
	0xA8E2, { 0xE2, 0x93, 0xA5 },
	0xA8E3, { 0xE2, 0x93, 0xA6 },
	0xA8E4, { 0xE2, 0x93, 0xA7 },
	0xA8E5, { 0xE2, 0x93, 0xA8 },
	0xA8E6, { 0xE2, 0x93, 0xA9 },
	0xA8E7, { 0xE2, 0x91, 0xA0 },
	0xA8E8, { 0xE2, 0x91, 0xA1 },
	0xA8E9, { 0xE2, 0x91, 0xA2 },
	0xA8EA, { 0xE2, 0x91, 0xA3 },
	0xA8EB, { 0xE2, 0x91, 0xA4 },
	0xA8EC, { 0xE2, 0x91, 0xA5 },
	0xA8ED, { 0xE2, 0x91, 0xA6 },
	0xA8EE, { 0xE2, 0x91, 0xA7 },
	0xA8EF, { 0xE2, 0x91, 0xA8 },
	0xA8F0, { 0xE2, 0x91, 0xA9 },
	0xA8F1, { 0xE2, 0x91, 0xAA },
	0xA8F2, { 0xE2, 0x91, 0xAB },
	0xA8F3, { 0xE2, 0x91, 0xAC },
	0xA8F4, { 0xE2, 0x91, 0xAD },
	0xA8F5, { 0xE2, 0x91, 0xAE },
	0xA8F6, { 0xC2, 0xBD },
	0xA8F7, { 0xE2, 0x85, 0x93 },
	0xA8F8, { 0xE2, 0x85, 0x94 },
	0xA8F9, { 0xC2, 0xBC },
	0xA8FA, { 0xC2, 0xBE },
	0xA8FB, { 0xE2, 0x85, 0x9B },
	0xA8FC, { 0xE2, 0x85, 0x9C },
	0xA8FD, { 0xE2, 0x85, 0x9D },
	0xA8FE, { 0xE2, 0x85, 0x9E },
	0xA941, { 0xEC, 0xAF, 0x85 },
	0xA942, { 0xEC, 0xAF, 0x86 },
	0xA943, { 0xEC, 0xAF, 0x87 },
	0xA944, { 0xEC, 0xAF, 0x88 },
	0xA945, { 0xEC, 0xAF, 0x89 },
	0xA946, { 0xEC, 0xAF, 0x8A },
	0xA947, { 0xEC, 0xAF, 0x8B },
	0xA948, { 0xEC, 0xAF, 0x8C },
	0xA949, { 0xEC, 0xAF, 0x8D },
	0xA94A, { 0xEC, 0xAF, 0x8E },
	0xA94B, { 0xEC, 0xAF, 0x8F },
	0xA94C, { 0xEC, 0xAF, 0x90 },
	0xA94D, { 0xEC, 0xAF, 0x91 },
	0xA94E, { 0xEC, 0xAF, 0x92 },
	0xA94F, { 0xEC, 0xAF, 0x93 },
	0xA950, { 0xEC, 0xAF, 0x95 },
	0xA951, { 0xEC, 0xAF, 0x96 },
	0xA952, { 0xEC, 0xAF, 0x97 },
	0xA953, { 0xEC, 0xAF, 0x98 },
	0xA954, { 0xEC, 0xAF, 0x99 },
	0xA955, { 0xEC, 0xAF, 0x9A },
	0xA956, { 0xEC, 0xAF, 0x9B },
	0xA957, { 0xEC, 0xAF, 0x9C },
	0xA958, { 0xEC, 0xAF, 0x9D },
	0xA959, { 0xEC, 0xAF, 0x9E },
	0xA95A, { 0xEC, 0xAF, 0x9F },
	0xA961, { 0xEC, 0xAF, 0xA0 },
	0xA962, { 0xEC, 0xAF, 0xA1 },
	0xA963, { 0xEC, 0xAF, 0xA2 },
	0xA964, { 0xEC, 0xAF, 0xA3 },
	0xA965, { 0xEC, 0xAF, 0xA5 },
	0xA966, { 0xEC, 0xAF, 0xA6 },
	0xA967, { 0xEC, 0xAF, 0xA8 },
	0xA968, { 0xEC, 0xAF, 0xAA },
	0xA969, { 0xEC, 0xAF, 0xAB },
	0xA96A, { 0xEC, 0xAF, 0xAC },
	0xA96B, { 0xEC, 0xAF, 0xAD },
	0xA96C, { 0xEC, 0xAF, 0xAE },
	0xA96D, { 0xEC, 0xAF, 0xAF },
	0xA96E, { 0xEC, 0xAF, 0xB0 },
	0xA96F, { 0xEC, 0xAF, 0xB1 },
	0xA970, { 0xEC, 0xAF, 0xB2 },
	0xA971, { 0xEC, 0xAF, 0xB3 },
	0xA972, { 0xEC, 0xAF, 0xB4 },
	0xA973, { 0xEC, 0xAF, 0xB5 },
	0xA974, { 0xEC, 0xAF, 0xB6 },
	0xA975, { 0xEC, 0xAF, 0xB7 },
	0xA976, { 0xEC, 0xAF, 0xB8 },
	0xA977, { 0xEC, 0xAF, 0xB9 },
	0xA978, { 0xEC, 0xAF, 0xBA },
	0xA979, { 0xEC, 0xAF, 0xBB },
	0xA97A, { 0xEC, 0xAF, 0xBC },
	0xA981, { 0xEC, 0xAF, 0xBD },
	0xA982, { 0xEC, 0xAF, 0xBE },
	0xA983, { 0xEC, 0xAF, 0xBF },
	0xA984, { 0xEC, 0xB0, 0x80 },
	0xA985, { 0xEC, 0xB0, 0x81 },
	0xA986, { 0xEC, 0xB0, 0x82 },
	0xA987, { 0xEC, 0xB0, 0x83 },
	0xA988, { 0xEC, 0xB0, 0x84 },
	0xA989, { 0xEC, 0xB0, 0x85 },
	0xA98A, { 0xEC, 0xB0, 0x86 },
	0xA98B, { 0xEC, 0xB0, 0x87 },
	0xA98C, { 0xEC, 0xB0, 0x88 },
	0xA98D, { 0xEC, 0xB0, 0x89 },
	0xA98E, { 0xEC, 0xB0, 0x8A },
	0xA98F, { 0xEC, 0xB0, 0x8B },
	0xA990, { 0xEC, 0xB0, 0x8E },
	0xA991, { 0xEC, 0xB0, 0x8F },
	0xA992, { 0xEC, 0xB0, 0x91 },
	0xA993, { 0xEC, 0xB0, 0x92 },
	0xA994, { 0xEC, 0xB0, 0x93 },
	0xA995, { 0xEC, 0xB0, 0x95 },
	0xA996, { 0xEC, 0xB0, 0x96 },
	0xA997, { 0xEC, 0xB0, 0x97 },
	0xA998, { 0xEC, 0xB0, 0x98 },
	0xA999, { 0xEC, 0xB0, 0x99 },
	0xA99A, { 0xEC, 0xB0, 0x9A },
	0xA99B, { 0xEC, 0xB0, 0x9B },
	0xA99C, { 0xEC, 0xB0, 0x9E },
	0xA99D, { 0xEC, 0xB0, 0x9F },
	0xA99E, { 0xEC, 0xB0, 0xA0 },
	0xA99F, { 0xEC, 0xB0, 0xA3 },
	0xA9A0, { 0xEC, 0xB0, 0xA4 },
	0xA9A1, { 0xC3, 0xA6 },
	0xA9A2, { 0xC4, 0x91 },
	0xA9A3, { 0xC3, 0xB0 },
	0xA9A4, { 0xC4, 0xA7 },
	0xA9A5, { 0xC4, 0xB1 },
	0xA9A6, { 0xC4, 0xB3 },
	0xA9A7, { 0xC4, 0xB8 },
	0xA9A8, { 0xC5, 0x80 },
	0xA9A9, { 0xC5, 0x82 },
	0xA9AA, { 0xC3, 0xB8 },
	0xA9AB, { 0xC5, 0x93 },
	0xA9AC, { 0xC3, 0x9F },
	0xA9AD, { 0xC3, 0xBE },
	0xA9AE, { 0xC5, 0xA7 },
	0xA9AF, { 0xC5, 0x8B },
	0xA9B0, { 0xC5, 0x89 },
	0xA9B1, { 0xE3, 0x88, 0x80 },
	0xA9B2, { 0xE3, 0x88, 0x81 },
	0xA9B3, { 0xE3, 0x88, 0x82 },
	0xA9B4, { 0xE3, 0x88, 0x83 },
	0xA9B5, { 0xE3, 0x88, 0x84 },
	0xA9B6, { 0xE3, 0x88, 0x85 },
	0xA9B7, { 0xE3, 0x88, 0x86 },
	0xA9B8, { 0xE3, 0x88, 0x87 },
	0xA9B9, { 0xE3, 0x88, 0x88 },
	0xA9BA, { 0xE3, 0x88, 0x89 },
	0xA9BB, { 0xE3, 0x88, 0x8A },
	0xA9BC, { 0xE3, 0x88, 0x8B },
	0xA9BD, { 0xE3, 0x88, 0x8C },
	0xA9BE, { 0xE3, 0x88, 0x8D },
	0xA9BF, { 0xE3, 0x88, 0x8E },
	0xA9C0, { 0xE3, 0x88, 0x8F },
	0xA9C1, { 0xE3, 0x88, 0x90 },
	0xA9C2, { 0xE3, 0x88, 0x91 },
	0xA9C3, { 0xE3, 0x88, 0x92 },
	0xA9C4, { 0xE3, 0x88, 0x93 },
	0xA9C5, { 0xE3, 0x88, 0x94 },
	0xA9C6, { 0xE3, 0x88, 0x95 },
	0xA9C7, { 0xE3, 0x88, 0x96 },
	0xA9C8, { 0xE3, 0x88, 0x97 },
	0xA9C9, { 0xE3, 0x88, 0x98 },
	0xA9CA, { 0xE3, 0x88, 0x99 },
	0xA9CB, { 0xE3, 0x88, 0x9A },
	0xA9CC, { 0xE3, 0x88, 0x9B },
	0xA9CD, { 0xE2, 0x92, 0x9C },
	0xA9CE, { 0xE2, 0x92, 0x9D },
	0xA9CF, { 0xE2, 0x92, 0x9E },
	0xA9D0, { 0xE2, 0x92, 0x9F },
	0xA9D1, { 0xE2, 0x92, 0xA0 },
	0xA9D2, { 0xE2, 0x92, 0xA1 },
	0xA9D3, { 0xE2, 0x92, 0xA2 },
	0xA9D4, { 0xE2, 0x92, 0xA3 },
	0xA9D5, { 0xE2, 0x92, 0xA4 },
	0xA9D6, { 0xE2, 0x92, 0xA5 },
	0xA9D7, { 0xE2, 0x92, 0xA6 },
	0xA9D8, { 0xE2, 0x92, 0xA7 },
	0xA9D9, { 0xE2, 0x92, 0xA8 },
	0xA9DA, { 0xE2, 0x92, 0xA9 },
	0xA9DB, { 0xE2, 0x92, 0xAA },
	0xA9DC, { 0xE2, 0x92, 0xAB },
	0xA9DD, { 0xE2, 0x92, 0xAC },
	0xA9DE, { 0xE2, 0x92, 0xAD },
	0xA9DF, { 0xE2, 0x92, 0xAE },
	0xA9E0, { 0xE2, 0x92, 0xAF },
	0xA9E1, { 0xE2, 0x92, 0xB0 },
	0xA9E2, { 0xE2, 0x92, 0xB1 },
	0xA9E3, { 0xE2, 0x92, 0xB2 },
	0xA9E4, { 0xE2, 0x92, 0xB3 },
	0xA9E5, { 0xE2, 0x92, 0xB4 },
	0xA9E6, { 0xE2, 0x92, 0xB5 },
	0xA9E7, { 0xE2, 0x91, 0xB4 },
	0xA9E8, { 0xE2, 0x91, 0xB5 },
	0xA9E9, { 0xE2, 0x91, 0xB6 },
	0xA9EA, { 0xE2, 0x91, 0xB7 },
	0xA9EB, { 0xE2, 0x91, 0xB8 },
	0xA9EC, { 0xE2, 0x91, 0xB9 },
	0xA9ED, { 0xE2, 0x91, 0xBA },
	0xA9EE, { 0xE2, 0x91, 0xBB },
	0xA9EF, { 0xE2, 0x91, 0xBC },
	0xA9F0, { 0xE2, 0x91, 0xBD },
	0xA9F1, { 0xE2, 0x91, 0xBE },
	0xA9F2, { 0xE2, 0x91, 0xBF },
	0xA9F3, { 0xE2, 0x92, 0x80 },
	0xA9F4, { 0xE2, 0x92, 0x81 },
	0xA9F5, { 0xE2, 0x92, 0x82 },
	0xA9F6, { 0xC2, 0xB9 },
	0xA9F7, { 0xC2, 0xB2 },
	0xA9F8, { 0xC2, 0xB3 },
	0xA9F9, { 0xE2, 0x81, 0xB4 },
	0xA9FA, { 0xE2, 0x81, 0xBF },
	0xA9FB, { 0xE2, 0x82, 0x81 },
	0xA9FC, { 0xE2, 0x82, 0x82 },
	0xA9FD, { 0xE2, 0x82, 0x83 },
	0xA9FE, { 0xE2, 0x82, 0x84 },
	0xAA41, { 0xEC, 0xB0, 0xA5 },
	0xAA42, { 0xEC, 0xB0, 0xA6 },
	0xAA43, { 0xEC, 0xB0, 0xAA },
	0xAA44, { 0xEC, 0xB0, 0xAB },
	0xAA45, { 0xEC, 0xB0, 0xAD },
	0xAA46, { 0xEC, 0xB0, 0xAF },
	0xAA47, { 0xEC, 0xB0, 0xB1 },
	0xAA48, { 0xEC, 0xB0, 0xB2 },
	0xAA49, { 0xEC, 0xB0, 0xB3 },
	0xAA4A, { 0xEC, 0xB0, 0xB4 },
	0xAA4B, { 0xEC, 0xB0, 0xB5 },
	0xAA4C, { 0xEC, 0xB0, 0xB6 },
	0xAA4D, { 0xEC, 0xB0, 0xB7 },
	0xAA4E, { 0xEC, 0xB0, 0xBA },
	0xAA4F, { 0xEC, 0xB0, 0xBF },
	0xAA50, { 0xEC, 0xB1, 0x80 },
	0xAA51, { 0xEC, 0xB1, 0x81 },
	0xAA52, { 0xEC, 0xB1, 0x82 },
	0xAA53, { 0xEC, 0xB1, 0x83 },
	0xAA54, { 0xEC, 0xB1, 0x86 },
	0xAA55, { 0xEC, 0xB1, 0x87 },
	0xAA56, { 0xEC, 0xB1, 0x89 },
	0xAA57, { 0xEC, 0xB1, 0x8A },
	0xAA58, { 0xEC, 0xB1, 0x8B },
	0xAA59, { 0xEC, 0xB1, 0x8D },
	0xAA5A, { 0xEC, 0xB1, 0x8E },
	0xAA61, { 0xEC, 0xB1, 0x8F },
	0xAA62, { 0xEC, 0xB1, 0x90 },
	0xAA63, { 0xEC, 0xB1, 0x91 },
	0xAA64, { 0xEC, 0xB1, 0x92 },
	0xAA65, { 0xEC, 0xB1, 0x93 },
	0xAA66, { 0xEC, 0xB1, 0x96 },
	0xAA67, { 0xEC, 0xB1, 0x9A },
	0xAA68, { 0xEC, 0xB1, 0x9B },
	0xAA69, { 0xEC, 0xB1, 0x9C },
	0xAA6A, { 0xEC, 0xB1, 0x9D },
	0xAA6B, { 0xEC, 0xB1, 0x9E },
	0xAA6C, { 0xEC, 0xB1, 0x9F },
	0xAA6D, { 0xEC, 0xB1, 0xA1 },
	0xAA6E, { 0xEC, 0xB1, 0xA2 },
	0xAA6F, { 0xEC, 0xB1, 0xA3 },
	0xAA70, { 0xEC, 0xB1, 0xA5 },
	0xAA71, { 0xEC, 0xB1, 0xA7 },
	0xAA72, { 0xEC, 0xB1, 0xA9 },
	0xAA73, { 0xEC, 0xB1, 0xAA },
	0xAA74, { 0xEC, 0xB1, 0xAB },
	0xAA75, { 0xEC, 0xB1, 0xAC },
	0xAA76, { 0xEC, 0xB1, 0xAD },
	0xAA77, { 0xEC, 0xB1, 0xAE },
	0xAA78, { 0xEC, 0xB1, 0xAF },
	0xAA79, { 0xEC, 0xB1, 0xB1 },
	0xAA7A, { 0xEC, 0xB1, 0xB2 },
	0xAA81, { 0xEC, 0xB1, 0xB3 },
	0xAA82, { 0xEC, 0xB1, 0xB4 },
	0xAA83, { 0xEC, 0xB1, 0xB6 },
	0xAA84, { 0xEC, 0xB1, 0xB7 },
	0xAA85, { 0xEC, 0xB1, 0xB8 },
	0xAA86, { 0xEC, 0xB1, 0xB9 },
	0xAA87, { 0xEC, 0xB1, 0xBA },
	0xAA88, { 0xEC, 0xB1, 0xBB },
	0xAA89, { 0xEC, 0xB1, 0xBC },
	0xAA8A, { 0xEC, 0xB1, 0xBD },
	0xAA8B, { 0xEC, 0xB1, 0xBE },
	0xAA8C, { 0xEC, 0xB1, 0xBF },
	0xAA8D, { 0xEC, 0xB2, 0x80 },
	0xAA8E, { 0xEC, 0xB2, 0x81 },
	0xAA8F, { 0xEC, 0xB2, 0x82 },
	0xAA90, { 0xEC, 0xB2, 0x83 },
	0xAA91, { 0xEC, 0xB2, 0x84 },
	0xAA92, { 0xEC, 0xB2, 0x85 },
	0xAA93, { 0xEC, 0xB2, 0x86 },
	0xAA94, { 0xEC, 0xB2, 0x87 },
	0xAA95, { 0xEC, 0xB2, 0x88 },
	0xAA96, { 0xEC, 0xB2, 0x89 },
	0xAA97, { 0xEC, 0xB2, 0x8A },
	0xAA98, { 0xEC, 0xB2, 0x8B },
	0xAA99, { 0xEC, 0xB2, 0x8C },
	0xAA9A, { 0xEC, 0xB2, 0x8D },
	0xAA9B, { 0xEC, 0xB2, 0x8E },
	0xAA9C, { 0xEC, 0xB2, 0x8F },
	0xAA9D, { 0xEC, 0xB2, 0x90 },
	0xAA9E, { 0xEC, 0xB2, 0x91 },
	0xAA9F, { 0xEC, 0xB2, 0x92 },
	0xAAA0, { 0xEC, 0xB2, 0x93 },
	0xAAA1, { 0xE3, 0x81, 0x81 },
	0xAAA2, { 0xE3, 0x81, 0x82 },
	0xAAA3, { 0xE3, 0x81, 0x83 },
	0xAAA4, { 0xE3, 0x81, 0x84 },
	0xAAA5, { 0xE3, 0x81, 0x85 },
	0xAAA6, { 0xE3, 0x81, 0x86 },
	0xAAA7, { 0xE3, 0x81, 0x87 },
	0xAAA8, { 0xE3, 0x81, 0x88 },
	0xAAA9, { 0xE3, 0x81, 0x89 },
	0xAAAA, { 0xE3, 0x81, 0x8A },
	0xAAAB, { 0xE3, 0x81, 0x8B },
	0xAAAC, { 0xE3, 0x81, 0x8C },
	0xAAAD, { 0xE3, 0x81, 0x8D },
	0xAAAE, { 0xE3, 0x81, 0x8E },
	0xAAAF, { 0xE3, 0x81, 0x8F },
	0xAAB0, { 0xE3, 0x81, 0x90 },
	0xAAB1, { 0xE3, 0x81, 0x91 },
	0xAAB2, { 0xE3, 0x81, 0x92 },
	0xAAB3, { 0xE3, 0x81, 0x93 },
	0xAAB4, { 0xE3, 0x81, 0x94 },
	0xAAB5, { 0xE3, 0x81, 0x95 },
	0xAAB6, { 0xE3, 0x81, 0x96 },
	0xAAB7, { 0xE3, 0x81, 0x97 },
	0xAAB8, { 0xE3, 0x81, 0x98 },
	0xAAB9, { 0xE3, 0x81, 0x99 },
	0xAABA, { 0xE3, 0x81, 0x9A },
	0xAABB, { 0xE3, 0x81, 0x9B },
	0xAABC, { 0xE3, 0x81, 0x9C },
	0xAABD, { 0xE3, 0x81, 0x9D },
	0xAABE, { 0xE3, 0x81, 0x9E },
	0xAABF, { 0xE3, 0x81, 0x9F },
	0xAAC0, { 0xE3, 0x81, 0xA0 },
	0xAAC1, { 0xE3, 0x81, 0xA1 },
	0xAAC2, { 0xE3, 0x81, 0xA2 },
	0xAAC3, { 0xE3, 0x81, 0xA3 },
	0xAAC4, { 0xE3, 0x81, 0xA4 },
	0xAAC5, { 0xE3, 0x81, 0xA5 },
	0xAAC6, { 0xE3, 0x81, 0xA6 },
	0xAAC7, { 0xE3, 0x81, 0xA7 },
	0xAAC8, { 0xE3, 0x81, 0xA8 },
	0xAAC9, { 0xE3, 0x81, 0xA9 },
	0xAACA, { 0xE3, 0x81, 0xAA },
	0xAACB, { 0xE3, 0x81, 0xAB },
	0xAACC, { 0xE3, 0x81, 0xAC },
	0xAACD, { 0xE3, 0x81, 0xAD },
	0xAACE, { 0xE3, 0x81, 0xAE },
	0xAACF, { 0xE3, 0x81, 0xAF },
	0xAAD0, { 0xE3, 0x81, 0xB0 },
	0xAAD1, { 0xE3, 0x81, 0xB1 },
	0xAAD2, { 0xE3, 0x81, 0xB2 },
	0xAAD3, { 0xE3, 0x81, 0xB3 },
	0xAAD4, { 0xE3, 0x81, 0xB4 },
	0xAAD5, { 0xE3, 0x81, 0xB5 },
	0xAAD6, { 0xE3, 0x81, 0xB6 },
	0xAAD7, { 0xE3, 0x81, 0xB7 },
	0xAAD8, { 0xE3, 0x81, 0xB8 },
	0xAAD9, { 0xE3, 0x81, 0xB9 },
	0xAADA, { 0xE3, 0x81, 0xBA },
	0xAADB, { 0xE3, 0x81, 0xBB },
	0xAADC, { 0xE3, 0x81, 0xBC },
	0xAADD, { 0xE3, 0x81, 0xBD },
	0xAADE, { 0xE3, 0x81, 0xBE },
	0xAADF, { 0xE3, 0x81, 0xBF },
	0xAAE0, { 0xE3, 0x82, 0x80 },
	0xAAE1, { 0xE3, 0x82, 0x81 },
	0xAAE2, { 0xE3, 0x82, 0x82 },
	0xAAE3, { 0xE3, 0x82, 0x83 },
	0xAAE4, { 0xE3, 0x82, 0x84 },
	0xAAE5, { 0xE3, 0x82, 0x85 },
	0xAAE6, { 0xE3, 0x82, 0x86 },
	0xAAE7, { 0xE3, 0x82, 0x87 },
	0xAAE8, { 0xE3, 0x82, 0x88 },
	0xAAE9, { 0xE3, 0x82, 0x89 },
	0xAAEA, { 0xE3, 0x82, 0x8A },
	0xAAEB, { 0xE3, 0x82, 0x8B },
	0xAAEC, { 0xE3, 0x82, 0x8C },
	0xAAED, { 0xE3, 0x82, 0x8D },
	0xAAEE, { 0xE3, 0x82, 0x8E },
	0xAAEF, { 0xE3, 0x82, 0x8F },
	0xAAF0, { 0xE3, 0x82, 0x90 },
	0xAAF1, { 0xE3, 0x82, 0x91 },
	0xAAF2, { 0xE3, 0x82, 0x92 },
	0xAAF3, { 0xE3, 0x82, 0x93 },
	0xAB41, { 0xEC, 0xB2, 0x94 },
	0xAB42, { 0xEC, 0xB2, 0x95 },
	0xAB43, { 0xEC, 0xB2, 0x96 },
	0xAB44, { 0xEC, 0xB2, 0x97 },
	0xAB45, { 0xEC, 0xB2, 0x9A },
	0xAB46, { 0xEC, 0xB2, 0x9B },
	0xAB47, { 0xEC, 0xB2, 0x9D },
	0xAB48, { 0xEC, 0xB2, 0x9E },
	0xAB49, { 0xEC, 0xB2, 0x9F },
	0xAB4A, { 0xEC, 0xB2, 0xA1 },
	0xAB4B, { 0xEC, 0xB2, 0xA2 },
	0xAB4C, { 0xEC, 0xB2, 0xA3 },
	0xAB4D, { 0xEC, 0xB2, 0xA4 },
	0xAB4E, { 0xEC, 0xB2, 0xA5 },
	0xAB4F, { 0xEC, 0xB2, 0xA6 },
	0xAB50, { 0xEC, 0xB2, 0xA7 },
	0xAB51, { 0xEC, 0xB2, 0xAA },
	0xAB52, { 0xEC, 0xB2, 0xAE },
	0xAB53, { 0xEC, 0xB2, 0xAF },
	0xAB54, { 0xEC, 0xB2, 0xB0 },
	0xAB55, { 0xEC, 0xB2, 0xB1 },
	0xAB56, { 0xEC, 0xB2, 0xB2 },
	0xAB57, { 0xEC, 0xB2, 0xB3 },
	0xAB58, { 0xEC, 0xB2, 0xB6 },
	0xAB59, { 0xEC, 0xB2, 0xB7 },
	0xAB5A, { 0xEC, 0xB2, 0xB9 },
	0xAB61, { 0xEC, 0xB2, 0xBA },
	0xAB62, { 0xEC, 0xB2, 0xBB },
	0xAB63, { 0xEC, 0xB2, 0xBD },
	0xAB64, { 0xEC, 0xB2, 0xBE },
	0xAB65, { 0xEC, 0xB2, 0xBF },
	0xAB66, { 0xEC, 0xB3, 0x80 },
	0xAB67, { 0xEC, 0xB3, 0x81 },
	0xAB68, { 0xEC, 0xB3, 0x82 },
	0xAB69, { 0xEC, 0xB3, 0x83 },
	0xAB6A, { 0xEC, 0xB3, 0x86 },
	0xAB6B, { 0xEC, 0xB3, 0x88 },
	0xAB6C, { 0xEC, 0xB3, 0x8A },
	0xAB6D, { 0xEC, 0xB3, 0x8B },
	0xAB6E, { 0xEC, 0xB3, 0x8C },
	0xAB6F, { 0xEC, 0xB3, 0x8D },
	0xAB70, { 0xEC, 0xB3, 0x8E },
	0xAB71, { 0xEC, 0xB3, 0x8F },
	0xAB72, { 0xEC, 0xB3, 0x91 },
	0xAB73, { 0xEC, 0xB3, 0x92 },
	0xAB74, { 0xEC, 0xB3, 0x93 },
	0xAB75, { 0xEC, 0xB3, 0x95 },
	0xAB76, { 0xEC, 0xB3, 0x96 },
	0xAB77, { 0xEC, 0xB3, 0x97 },
	0xAB78, { 0xEC, 0xB3, 0x98 },
	0xAB79, { 0xEC, 0xB3, 0x99 },
	0xAB7A, { 0xEC, 0xB3, 0x9A },
	0xAB81, { 0xEC, 0xB3, 0x9B },
	0xAB82, { 0xEC, 0xB3, 0x9C },
	0xAB83, { 0xEC, 0xB3, 0x9D },
	0xAB84, { 0xEC, 0xB3, 0x9E },
	0xAB85, { 0xEC, 0xB3, 0x9F },
	0xAB86, { 0xEC, 0xB3, 0xA0 },
	0xAB87, { 0xEC, 0xB3, 0xA1 },
	0xAB88, { 0xEC, 0xB3, 0xA2 },
	0xAB89, { 0xEC, 0xB3, 0xA3 },
	0xAB8A, { 0xEC, 0xB3, 0xA5 },
	0xAB8B, { 0xEC, 0xB3, 0xA6 },
	0xAB8C, { 0xEC, 0xB3, 0xA7 },
	0xAB8D, { 0xEC, 0xB3, 0xA8 },
	0xAB8E, { 0xEC, 0xB3, 0xA9 },
	0xAB8F, { 0xEC, 0xB3, 0xAA },
	0xAB90, { 0xEC, 0xB3, 0xAB },
	0xAB91, { 0xEC, 0xB3, 0xAD },
	0xAB92, { 0xEC, 0xB3, 0xAE },
	0xAB93, { 0xEC, 0xB3, 0xAF },
	0xAB94, { 0xEC, 0xB3, 0xB1 },
	0xAB95, { 0xEC, 0xB3, 0xB2 },
	0xAB96, { 0xEC, 0xB3, 0xB3 },
	0xAB97, { 0xEC, 0xB3, 0xB4 },
	0xAB98, { 0xEC, 0xB3, 0xB5 },
	0xAB99, { 0xEC, 0xB3, 0xB6 },
	0xAB9A, { 0xEC, 0xB3, 0xB7 },
	0xAB9B, { 0xEC, 0xB3, 0xB8 },
	0xAB9C, { 0xEC, 0xB3, 0xB9 },
	0xAB9D, { 0xEC, 0xB3, 0xBA },
	0xAB9E, { 0xEC, 0xB3, 0xBB },
	0xAB9F, { 0xEC, 0xB3, 0xBC },
	0xABA0, { 0xEC, 0xB3, 0xBD },
	0xABA1, { 0xE3, 0x82, 0xA1 },
	0xABA2, { 0xE3, 0x82, 0xA2 },
	0xABA3, { 0xE3, 0x82, 0xA3 },
	0xABA4, { 0xE3, 0x82, 0xA4 },
	0xABA5, { 0xE3, 0x82, 0xA5 },
	0xABA6, { 0xE3, 0x82, 0xA6 },
	0xABA7, { 0xE3, 0x82, 0xA7 },
	0xABA8, { 0xE3, 0x82, 0xA8 },
	0xABA9, { 0xE3, 0x82, 0xA9 },
	0xABAA, { 0xE3, 0x82, 0xAA },
	0xABAB, { 0xE3, 0x82, 0xAB },
	0xABAC, { 0xE3, 0x82, 0xAC },
	0xABAD, { 0xE3, 0x82, 0xAD },
	0xABAE, { 0xE3, 0x82, 0xAE },
	0xABAF, { 0xE3, 0x82, 0xAF },
	0xABB0, { 0xE3, 0x82, 0xB0 },
	0xABB1, { 0xE3, 0x82, 0xB1 },
	0xABB2, { 0xE3, 0x82, 0xB2 },
	0xABB3, { 0xE3, 0x82, 0xB3 },
	0xABB4, { 0xE3, 0x82, 0xB4 },
	0xABB5, { 0xE3, 0x82, 0xB5 },
	0xABB6, { 0xE3, 0x82, 0xB6 },
	0xABB7, { 0xE3, 0x82, 0xB7 },
	0xABB8, { 0xE3, 0x82, 0xB8 },
	0xABB9, { 0xE3, 0x82, 0xB9 },
	0xABBA, { 0xE3, 0x82, 0xBA },
	0xABBB, { 0xE3, 0x82, 0xBB },
	0xABBC, { 0xE3, 0x82, 0xBC },
	0xABBD, { 0xE3, 0x82, 0xBD },
	0xABBE, { 0xE3, 0x82, 0xBE },
	0xABBF, { 0xE3, 0x82, 0xBF },
	0xABC0, { 0xE3, 0x83, 0x80 },
	0xABC1, { 0xE3, 0x83, 0x81 },
	0xABC2, { 0xE3, 0x83, 0x82 },
	0xABC3, { 0xE3, 0x83, 0x83 },
	0xABC4, { 0xE3, 0x83, 0x84 },
	0xABC5, { 0xE3, 0x83, 0x85 },
	0xABC6, { 0xE3, 0x83, 0x86 },
	0xABC7, { 0xE3, 0x83, 0x87 },
	0xABC8, { 0xE3, 0x83, 0x88 },
	0xABC9, { 0xE3, 0x83, 0x89 },
	0xABCA, { 0xE3, 0x83, 0x8A },
	0xABCB, { 0xE3, 0x83, 0x8B },
	0xABCC, { 0xE3, 0x83, 0x8C },
	0xABCD, { 0xE3, 0x83, 0x8D },
	0xABCE, { 0xE3, 0x83, 0x8E },
	0xABCF, { 0xE3, 0x83, 0x8F },
	0xABD0, { 0xE3, 0x83, 0x90 },
	0xABD1, { 0xE3, 0x83, 0x91 },
	0xABD2, { 0xE3, 0x83, 0x92 },
	0xABD3, { 0xE3, 0x83, 0x93 },
	0xABD4, { 0xE3, 0x83, 0x94 },
	0xABD5, { 0xE3, 0x83, 0x95 },
	0xABD6, { 0xE3, 0x83, 0x96 },
	0xABD7, { 0xE3, 0x83, 0x97 },
	0xABD8, { 0xE3, 0x83, 0x98 },
	0xABD9, { 0xE3, 0x83, 0x99 },
	0xABDA, { 0xE3, 0x83, 0x9A },
	0xABDB, { 0xE3, 0x83, 0x9B },
	0xABDC, { 0xE3, 0x83, 0x9C },
	0xABDD, { 0xE3, 0x83, 0x9D },
	0xABDE, { 0xE3, 0x83, 0x9E },
	0xABDF, { 0xE3, 0x83, 0x9F },
	0xABE0, { 0xE3, 0x83, 0xA0 },
	0xABE1, { 0xE3, 0x83, 0xA1 },
	0xABE2, { 0xE3, 0x83, 0xA2 },
	0xABE3, { 0xE3, 0x83, 0xA3 },
	0xABE4, { 0xE3, 0x83, 0xA4 },
	0xABE5, { 0xE3, 0x83, 0xA5 },
	0xABE6, { 0xE3, 0x83, 0xA6 },
	0xABE7, { 0xE3, 0x83, 0xA7 },
	0xABE8, { 0xE3, 0x83, 0xA8 },
	0xABE9, { 0xE3, 0x83, 0xA9 },
	0xABEA, { 0xE3, 0x83, 0xAA },
	0xABEB, { 0xE3, 0x83, 0xAB },
	0xABEC, { 0xE3, 0x83, 0xAC },
	0xABED, { 0xE3, 0x83, 0xAD },
	0xABEE, { 0xE3, 0x83, 0xAE },
	0xABEF, { 0xE3, 0x83, 0xAF },
	0xABF0, { 0xE3, 0x83, 0xB0 },
	0xABF1, { 0xE3, 0x83, 0xB1 },
	0xABF2, { 0xE3, 0x83, 0xB2 },
	0xABF3, { 0xE3, 0x83, 0xB3 },
	0xABF4, { 0xE3, 0x83, 0xB4 },
	0xABF5, { 0xE3, 0x83, 0xB5 },
	0xABF6, { 0xE3, 0x83, 0xB6 },
	0xAC41, { 0xEC, 0xB3, 0xBE },
	0xAC42, { 0xEC, 0xB3, 0xBF },
	0xAC43, { 0xEC, 0xB4, 0x80 },
	0xAC44, { 0xEC, 0xB4, 0x82 },
	0xAC45, { 0xEC, 0xB4, 0x83 },
	0xAC46, { 0xEC, 0xB4, 0x84 },
	0xAC47, { 0xEC, 0xB4, 0x85 },
	0xAC48, { 0xEC, 0xB4, 0x86 },
	0xAC49, { 0xEC, 0xB4, 0x87 },
	0xAC4A, { 0xEC, 0xB4, 0x8A },
	0xAC4B, { 0xEC, 0xB4, 0x8B },
	0xAC4C, { 0xEC, 0xB4, 0x8D },
	0xAC4D, { 0xEC, 0xB4, 0x8E },
	0xAC4E, { 0xEC, 0xB4, 0x8F },
	0xAC4F, { 0xEC, 0xB4, 0x91 },
	0xAC50, { 0xEC, 0xB4, 0x92 },
	0xAC51, { 0xEC, 0xB4, 0x93 },
	0xAC52, { 0xEC, 0xB4, 0x94 },
	0xAC53, { 0xEC, 0xB4, 0x95 },
	0xAC54, { 0xEC, 0xB4, 0x96 },
	0xAC55, { 0xEC, 0xB4, 0x97 },
	0xAC56, { 0xEC, 0xB4, 0x9A },
	0xAC57, { 0xEC, 0xB4, 0x9C },
	0xAC58, { 0xEC, 0xB4, 0x9E },
	0xAC59, { 0xEC, 0xB4, 0x9F },
	0xAC5A, { 0xEC, 0xB4, 0xA0 },
	0xAC61, { 0xEC, 0xB4, 0xA1 },
	0xAC62, { 0xEC, 0xB4, 0xA2 },
	0xAC63, { 0xEC, 0xB4, 0xA3 },
	0xAC64, { 0xEC, 0xB4, 0xA5 },
	0xAC65, { 0xEC, 0xB4, 0xA6 },
	0xAC66, { 0xEC, 0xB4, 0xA7 },
	0xAC67, { 0xEC, 0xB4, 0xA9 },
	0xAC68, { 0xEC, 0xB4, 0xAA },
	0xAC69, { 0xEC, 0xB4, 0xAB },
	0xAC6A, { 0xEC, 0xB4, 0xAD },
	0xAC6B, { 0xEC, 0xB4, 0xAE },
	0xAC6C, { 0xEC, 0xB4, 0xAF },
	0xAC6D, { 0xEC, 0xB4, 0xB0 },
	0xAC6E, { 0xEC, 0xB4, 0xB1 },
	0xAC6F, { 0xEC, 0xB4, 0xB2 },
	0xAC70, { 0xEC, 0xB4, 0xB3 },
	0xAC71, { 0xEC, 0xB4, 0xB4 },
	0xAC72, { 0xEC, 0xB4, 0xB5 },
	0xAC73, { 0xEC, 0xB4, 0xB6 },
	0xAC74, { 0xEC, 0xB4, 0xB7 },
	0xAC75, { 0xEC, 0xB4, 0xB8 },
	0xAC76, { 0xEC, 0xB4, 0xBA },
	0xAC77, { 0xEC, 0xB4, 0xBB },
	0xAC78, { 0xEC, 0xB4, 0xBC },
	0xAC79, { 0xEC, 0xB4, 0xBD },
	0xAC7A, { 0xEC, 0xB4, 0xBE },
	0xAC81, { 0xEC, 0xB4, 0xBF },
	0xAC82, { 0xEC, 0xB5, 0x80 },
	0xAC83, { 0xEC, 0xB5, 0x81 },
	0xAC84, { 0xEC, 0xB5, 0x82 },
	0xAC85, { 0xEC, 0xB5, 0x83 },
	0xAC86, { 0xEC, 0xB5, 0x84 },
	0xAC87, { 0xEC, 0xB5, 0x85 },
	0xAC88, { 0xEC, 0xB5, 0x86 },
	0xAC89, { 0xEC, 0xB5, 0x87 },
	0xAC8A, { 0xEC, 0xB5, 0x88 },
	0xAC8B, { 0xEC, 0xB5, 0x89 },
	0xAC8C, { 0xEC, 0xB5, 0x8A },
	0xAC8D, { 0xEC, 0xB5, 0x8B },
	0xAC8E, { 0xEC, 0xB5, 0x8C },
	0xAC8F, { 0xEC, 0xB5, 0x8D },
	0xAC90, { 0xEC, 0xB5, 0x8E },
	0xAC91, { 0xEC, 0xB5, 0x8F },
	0xAC92, { 0xEC, 0xB5, 0x90 },
	0xAC93, { 0xEC, 0xB5, 0x91 },
	0xAC94, { 0xEC, 0xB5, 0x92 },
	0xAC95, { 0xEC, 0xB5, 0x93 },
	0xAC96, { 0xEC, 0xB5, 0x94 },
	0xAC97, { 0xEC, 0xB5, 0x95 },
	0xAC98, { 0xEC, 0xB5, 0x96 },
	0xAC99, { 0xEC, 0xB5, 0x97 },
	0xAC9A, { 0xEC, 0xB5, 0x98 },
	0xAC9B, { 0xEC, 0xB5, 0x99 },
	0xAC9C, { 0xEC, 0xB5, 0x9A },
	0xAC9D, { 0xEC, 0xB5, 0x9B },
	0xAC9E, { 0xEC, 0xB5, 0x9D },
	0xAC9F, { 0xEC, 0xB5, 0x9E },
	0xACA0, { 0xEC, 0xB5, 0x9F },
	0xACA1, { 0xD0, 0x90 },
	0xACA2, { 0xD0, 0x91 },
	0xACA3, { 0xD0, 0x92 },
	0xACA4, { 0xD0, 0x93 },
	0xACA5, { 0xD0, 0x94 },
	0xACA6, { 0xD0, 0x95 },
	0xACA7, { 0xD0, 0x81 },
	0xACA8, { 0xD0, 0x96 },
	0xACA9, { 0xD0, 0x97 },
	0xACAA, { 0xD0, 0x98 },
	0xACAB, { 0xD0, 0x99 },
	0xACAC, { 0xD0, 0x9A },
	0xACAD, { 0xD0, 0x9B },
	0xACAE, { 0xD0, 0x9C },
	0xACAF, { 0xD0, 0x9D },
	0xACB0, { 0xD0, 0x9E },
	0xACB1, { 0xD0, 0x9F },
	0xACB2, { 0xD0, 0xA0 },
	0xACB3, { 0xD0, 0xA1 },
	0xACB4, { 0xD0, 0xA2 },
	0xACB5, { 0xD0, 0xA3 },
	0xACB6, { 0xD0, 0xA4 },
	0xACB7, { 0xD0, 0xA5 },
	0xACB8, { 0xD0, 0xA6 },
	0xACB9, { 0xD0, 0xA7 },
	0xACBA, { 0xD0, 0xA8 },
	0xACBB, { 0xD0, 0xA9 },
	0xACBC, { 0xD0, 0xAA },
	0xACBD, { 0xD0, 0xAB },
	0xACBE, { 0xD0, 0xAC },
	0xACBF, { 0xD0, 0xAD },
	0xACC0, { 0xD0, 0xAE },
	0xACC1, { 0xD0, 0xAF },
	0xACD1, { 0xD0, 0xB0 },
	0xACD2, { 0xD0, 0xB1 },
	0xACD3, { 0xD0, 0xB2 },
	0xACD4, { 0xD0, 0xB3 },
	0xACD5, { 0xD0, 0xB4 },
	0xACD6, { 0xD0, 0xB5 },
	0xACD7, { 0xD1, 0x91 },
	0xACD8, { 0xD0, 0xB6 },
	0xACD9, { 0xD0, 0xB7 },
	0xACDA, { 0xD0, 0xB8 },
	0xACDB, { 0xD0, 0xB9 },
	0xACDC, { 0xD0, 0xBA },
	0xACDD, { 0xD0, 0xBB },
	0xACDE, { 0xD0, 0xBC },
	0xACDF, { 0xD0, 0xBD },
	0xACE0, { 0xD0, 0xBE },
	0xACE1, { 0xD0, 0xBF },
	0xACE2, { 0xD1, 0x80 },
	0xACE3, { 0xD1, 0x81 },
	0xACE4, { 0xD1, 0x82 },
	0xACE5, { 0xD1, 0x83 },
	0xACE6, { 0xD1, 0x84 },
	0xACE7, { 0xD1, 0x85 },
	0xACE8, { 0xD1, 0x86 },
	0xACE9, { 0xD1, 0x87 },
	0xACEA, { 0xD1, 0x88 },
	0xACEB, { 0xD1, 0x89 },
	0xACEC, { 0xD1, 0x8A },
	0xACED, { 0xD1, 0x8B },
	0xACEE, { 0xD1, 0x8C },
	0xACEF, { 0xD1, 0x8D },
	0xACF0, { 0xD1, 0x8E },
	0xACF1, { 0xD1, 0x8F },
	0xAD41, { 0xEC, 0xB5, 0xA1 },
	0xAD42, { 0xEC, 0xB5, 0xA2 },
	0xAD43, { 0xEC, 0xB5, 0xA3 },
	0xAD44, { 0xEC, 0xB5, 0xA5 },
	0xAD45, { 0xEC, 0xB5, 0xA6 },
	0xAD46, { 0xEC, 0xB5, 0xA7 },
	0xAD47, { 0xEC, 0xB5, 0xA8 },
	0xAD48, { 0xEC, 0xB5, 0xA9 },
	0xAD49, { 0xEC, 0xB5, 0xAA },
	0xAD4A, { 0xEC, 0xB5, 0xAB },
	0xAD4B, { 0xEC, 0xB5, 0xAE },
	0xAD4C, { 0xEC, 0xB5, 0xB0 },
	0xAD4D, { 0xEC, 0xB5, 0xB2 },
	0xAD4E, { 0xEC, 0xB5, 0xB3 },
	0xAD4F, { 0xEC, 0xB5, 0xB4 },
	0xAD50, { 0xEC, 0xB5, 0xB5 },
	0xAD51, { 0xEC, 0xB5, 0xB6 },
	0xAD52, { 0xEC, 0xB5, 0xB7 },
	0xAD53, { 0xEC, 0xB5, 0xB9 },
	0xAD54, { 0xEC, 0xB5, 0xBA },
	0xAD55, { 0xEC, 0xB5, 0xBB },
	0xAD56, { 0xEC, 0xB5, 0xBC },
	0xAD57, { 0xEC, 0xB5, 0xBD },
	0xAD58, { 0xEC, 0xB5, 0xBE },
	0xAD59, { 0xEC, 0xB5, 0xBF },
	0xAD5A, { 0xEC, 0xB6, 0x80 },
	0xAD61, { 0xEC, 0xB6, 0x81 },
	0xAD62, { 0xEC, 0xB6, 0x82 },
	0xAD63, { 0xEC, 0xB6, 0x83 },
	0xAD64, { 0xEC, 0xB6, 0x84 },
	0xAD65, { 0xEC, 0xB6, 0x85 },
	0xAD66, { 0xEC, 0xB6, 0x86 },
	0xAD67, { 0xEC, 0xB6, 0x87 },
	0xAD68, { 0xEC, 0xB6, 0x89 },
	0xAD69, { 0xEC, 0xB6, 0x8A },
	0xAD6A, { 0xEC, 0xB6, 0x8B },
	0xAD6B, { 0xEC, 0xB6, 0x8C },
	0xAD6C, { 0xEC, 0xB6, 0x8D },
	0xAD6D, { 0xEC, 0xB6, 0x8E },
	0xAD6E, { 0xEC, 0xB6, 0x8F },
	0xAD6F, { 0xEC, 0xB6, 0x90 },
	0xAD70, { 0xEC, 0xB6, 0x91 },
	0xAD71, { 0xEC, 0xB6, 0x92 },
	0xAD72, { 0xEC, 0xB6, 0x93 },
	0xAD73, { 0xEC, 0xB6, 0x96 },
	0xAD74, { 0xEC, 0xB6, 0x97 },
	0xAD75, { 0xEC, 0xB6, 0x99 },
	0xAD76, { 0xEC, 0xB6, 0x9A },
	0xAD77, { 0xEC, 0xB6, 0x9B },
	0xAD78, { 0xEC, 0xB6, 0x9D },
	0xAD79, { 0xEC, 0xB6, 0x9E },
	0xAD7A, { 0xEC, 0xB6, 0x9F },
	0xAD81, { 0xEC, 0xB6, 0xA0 },
	0xAD82, { 0xEC, 0xB6, 0xA1 },
	0xAD83, { 0xEC, 0xB6, 0xA2 },
	0xAD84, { 0xEC, 0xB6, 0xA3 },
	0xAD85, { 0xEC, 0xB6, 0xA6 },
	0xAD86, { 0xEC, 0xB6, 0xA8 },
	0xAD87, { 0xEC, 0xB6, 0xAA },
	0xAD88, { 0xEC, 0xB6, 0xAB },
	0xAD89, { 0xEC, 0xB6, 0xAC },
	0xAD8A, { 0xEC, 0xB6, 0xAD },
	0xAD8B, { 0xEC, 0xB6, 0xAE },
	0xAD8C, { 0xEC, 0xB6, 0xAF },
	0xAD8D, { 0xEC, 0xB6, 0xB1 },
	0xAD8E, { 0xEC, 0xB6, 0xB2 },
	0xAD8F, { 0xEC, 0xB6, 0xB3 },
	0xAD90, { 0xEC, 0xB6, 0xB4 },
	0xAD91, { 0xEC, 0xB6, 0xB5 },
	0xAD92, { 0xEC, 0xB6, 0xB6 },
	0xAD93, { 0xEC, 0xB6, 0xB7 },
	0xAD94, { 0xEC, 0xB6, 0xB8 },
	0xAD95, { 0xEC, 0xB6, 0xB9 },
	0xAD96, { 0xEC, 0xB6, 0xBA },
	0xAD97, { 0xEC, 0xB6, 0xBB },
	0xAD98, { 0xEC, 0xB6, 0xBC },
	0xAD99, { 0xEC, 0xB6, 0xBD },
	0xAD9A, { 0xEC, 0xB6, 0xBE },
	0xAD9B, { 0xEC, 0xB6, 0xBF },
	0xAD9C, { 0xEC, 0xB7, 0x80 },
	0xAD9D, { 0xEC, 0xB7, 0x81 },
	0xAD9E, { 0xEC, 0xB7, 0x82 },
	0xAD9F, { 0xEC, 0xB7, 0x83 },
	0xADA0, { 0xEC, 0xB7, 0x85 },
	0xAE41, { 0xEC, 0xB7, 0x86 },
	0xAE42, { 0xEC, 0xB7, 0x87 },
	0xAE43, { 0xEC, 0xB7, 0x88 },
	0xAE44, { 0xEC, 0xB7, 0x89 },
	0xAE45, { 0xEC, 0xB7, 0x8A },
	0xAE46, { 0xEC, 0xB7, 0x8B },
	0xAE47, { 0xEC, 0xB7, 0x8D },
	0xAE48, { 0xEC, 0xB7, 0x8E },
	0xAE49, { 0xEC, 0xB7, 0x8F },
	0xAE4A, { 0xEC, 0xB7, 0x91 },
	0xAE4B, { 0xEC, 0xB7, 0x92 },
	0xAE4C, { 0xEC, 0xB7, 0x93 },
	0xAE4D, { 0xEC, 0xB7, 0x94 },
	0xAE4E, { 0xEC, 0xB7, 0x95 },
	0xAE4F, { 0xEC, 0xB7, 0x96 },
	0xAE50, { 0xEC, 0xB7, 0x97 },
	0xAE51, { 0xEC, 0xB7, 0x98 },
	0xAE52, { 0xEC, 0xB7, 0x99 },
	0xAE53, { 0xEC, 0xB7, 0x9A },
	0xAE54, { 0xEC, 0xB7, 0x9B },
	0xAE55, { 0xEC, 0xB7, 0x9C },
	0xAE56, { 0xEC, 0xB7, 0x9D },
	0xAE57, { 0xEC, 0xB7, 0x9E },
	0xAE58, { 0xEC, 0xB7, 0x9F },
	0xAE59, { 0xEC, 0xB7, 0xA0 },
	0xAE5A, { 0xEC, 0xB7, 0xA1 },
	0xAE61, { 0xEC, 0xB7, 0xA2 },
	0xAE62, { 0xEC, 0xB7, 0xA3 },
	0xAE63, { 0xEC, 0xB7, 0xA4 },
	0xAE64, { 0xEC, 0xB7, 0xA5 },
	0xAE65, { 0xEC, 0xB7, 0xA6 },
	0xAE66, { 0xEC, 0xB7, 0xA7 },
	0xAE67, { 0xEC, 0xB7, 0xA9 },
	0xAE68, { 0xEC, 0xB7, 0xAA },
	0xAE69, { 0xEC, 0xB7, 0xAB },
	0xAE6A, { 0xEC, 0xB7, 0xAD },
	0xAE6B, { 0xEC, 0xB7, 0xAE },
	0xAE6C, { 0xEC, 0xB7, 0xAF },
	0xAE6D, { 0xEC, 0xB7, 0xB1 },
	0xAE6E, { 0xEC, 0xB7, 0xB2 },
	0xAE6F, { 0xEC, 0xB7, 0xB3 },
	0xAE70, { 0xEC, 0xB7, 0xB4 },
	0xAE71, { 0xEC, 0xB7, 0xB5 },
	0xAE72, { 0xEC, 0xB7, 0xB6 },
	0xAE73, { 0xEC, 0xB7, 0xB7 },
	0xAE74, { 0xEC, 0xB7, 0xBA },
	0xAE75, { 0xEC, 0xB7, 0xBC },
	0xAE76, { 0xEC, 0xB7, 0xBE },
	0xAE77, { 0xEC, 0xB7, 0xBF },
	0xAE78, { 0xEC, 0xB8, 0x80 },
	0xAE79, { 0xEC, 0xB8, 0x81 },
	0xAE7A, { 0xEC, 0xB8, 0x82 },
	0xAE81, { 0xEC, 0xB8, 0x83 },
	0xAE82, { 0xEC, 0xB8, 0x85 },
	0xAE83, { 0xEC, 0xB8, 0x86 },
	0xAE84, { 0xEC, 0xB8, 0x87 },
	0xAE85, { 0xEC, 0xB8, 0x89 },
	0xAE86, { 0xEC, 0xB8, 0x8A },
	0xAE87, { 0xEC, 0xB8, 0x8B },
	0xAE88, { 0xEC, 0xB8, 0x8D },
	0xAE89, { 0xEC, 0xB8, 0x8E },
	0xAE8A, { 0xEC, 0xB8, 0x8F },
	0xAE8B, { 0xEC, 0xB8, 0x90 },
	0xAE8C, { 0xEC, 0xB8, 0x91 },
	0xAE8D, { 0xEC, 0xB8, 0x92 },
	0xAE8E, { 0xEC, 0xB8, 0x93 },
	0xAE8F, { 0xEC, 0xB8, 0x95 },
	0xAE90, { 0xEC, 0xB8, 0x96 },
	0xAE91, { 0xEC, 0xB8, 0x97 },
	0xAE92, { 0xEC, 0xB8, 0x98 },
	0xAE93, { 0xEC, 0xB8, 0x9A },
	0xAE94, { 0xEC, 0xB8, 0x9B },
	0xAE95, { 0xEC, 0xB8, 0x9C },
	0xAE96, { 0xEC, 0xB8, 0x9D },
	0xAE97, { 0xEC, 0xB8, 0x9E },
	0xAE98, { 0xEC, 0xB8, 0x9F },
	0xAE99, { 0xEC, 0xB8, 0xA2 },
	0xAE9A, { 0xEC, 0xB8, 0xA3 },
	0xAE9B, { 0xEC, 0xB8, 0xA5 },
	0xAE9C, { 0xEC, 0xB8, 0xA6 },
	0xAE9D, { 0xEC, 0xB8, 0xA7 },
	0xAE9E, { 0xEC, 0xB8, 0xA9 },
	0xAE9F, { 0xEC, 0xB8, 0xAA },
	0xAEA0, { 0xEC, 0xB8, 0xAB },
	0xAF41, { 0xEC, 0xB8, 0xAC },
	0xAF42, { 0xEC, 0xB8, 0xAD },
	0xAF43, { 0xEC, 0xB8, 0xAE },
	0xAF44, { 0xEC, 0xB8, 0xAF },
	0xAF45, { 0xEC, 0xB8, 0xB2 },
	0xAF46, { 0xEC, 0xB8, 0xB4 },
	0xAF47, { 0xEC, 0xB8, 0xB6 },
	0xAF48, { 0xEC, 0xB8, 0xB7 },
	0xAF49, { 0xEC, 0xB8, 0xB8 },
	0xAF4A, { 0xEC, 0xB8, 0xB9 },
	0xAF4B, { 0xEC, 0xB8, 0xBA },
	0xAF4C, { 0xEC, 0xB8, 0xBB },
	0xAF4D, { 0xEC, 0xB8, 0xBC },
	0xAF4E, { 0xEC, 0xB8, 0xBD },
	0xAF4F, { 0xEC, 0xB8, 0xBE },
	0xAF50, { 0xEC, 0xB8, 0xBF },
	0xAF51, { 0xEC, 0xB9, 0x80 },
	0xAF52, { 0xEC, 0xB9, 0x81 },
	0xAF53, { 0xEC, 0xB9, 0x82 },
	0xAF54, { 0xEC, 0xB9, 0x83 },
	0xAF55, { 0xEC, 0xB9, 0x84 },
	0xAF56, { 0xEC, 0xB9, 0x85 },
	0xAF57, { 0xEC, 0xB9, 0x86 },
	0xAF58, { 0xEC, 0xB9, 0x87 },
	0xAF59, { 0xEC, 0xB9, 0x88 },
	0xAF5A, { 0xEC, 0xB9, 0x89 },
	0xAF61, { 0xEC, 0xB9, 0x8A },
	0xAF62, { 0xEC, 0xB9, 0x8B },
	0xAF63, { 0xEC, 0xB9, 0x8C },
	0xAF64, { 0xEC, 0xB9, 0x8D },
	0xAF65, { 0xEC, 0xB9, 0x8E },
	0xAF66, { 0xEC, 0xB9, 0x8F },
	0xAF67, { 0xEC, 0xB9, 0x90 },
	0xAF68, { 0xEC, 0xB9, 0x91 },
	0xAF69, { 0xEC, 0xB9, 0x92 },
	0xAF6A, { 0xEC, 0xB9, 0x93 },
	0xAF6B, { 0xEC, 0xB9, 0x94 },
	0xAF6C, { 0xEC, 0xB9, 0x95 },
	0xAF6D, { 0xEC, 0xB9, 0x96 },
	0xAF6E, { 0xEC, 0xB9, 0x97 },
	0xAF6F, { 0xEC, 0xB9, 0x9A },
	0xAF70, { 0xEC, 0xB9, 0x9B },
	0xAF71, { 0xEC, 0xB9, 0x9D },
	0xAF72, { 0xEC, 0xB9, 0x9E },
	0xAF73, { 0xEC, 0xB9, 0xA2 },
	0xAF74, { 0xEC, 0xB9, 0xA3 },
	0xAF75, { 0xEC, 0xB9, 0xA4 },
	0xAF76, { 0xEC, 0xB9, 0xA5 },
	0xAF77, { 0xEC, 0xB9, 0xA6 },
	0xAF78, { 0xEC, 0xB9, 0xA7 },
	0xAF79, { 0xEC, 0xB9, 0xAA },
	0xAF7A, { 0xEC, 0xB9, 0xAC },
	0xAF81, { 0xEC, 0xB9, 0xAE },
	0xAF82, { 0xEC, 0xB9, 0xAF },
	0xAF83, { 0xEC, 0xB9, 0xB0 },
	0xAF84, { 0xEC, 0xB9, 0xB1 },
	0xAF85, { 0xEC, 0xB9, 0xB2 },
	0xAF86, { 0xEC, 0xB9, 0xB3 },
	0xAF87, { 0xEC, 0xB9, 0xB6 },
	0xAF88, { 0xEC, 0xB9, 0xB7 },
	0xAF89, { 0xEC, 0xB9, 0xB9 },
	0xAF8A, { 0xEC, 0xB9, 0xBA },
	0xAF8B, { 0xEC, 0xB9, 0xBB },
	0xAF8C, { 0xEC, 0xB9, 0xBD },
	0xAF8D, { 0xEC, 0xB9, 0xBE },
	0xAF8E, { 0xEC, 0xB9, 0xBF },
	0xAF8F, { 0xEC, 0xBA, 0x80 },
	0xAF90, { 0xEC, 0xBA, 0x81 },
	0xAF91, { 0xEC, 0xBA, 0x82 },
	0xAF92, { 0xEC, 0xBA, 0x83 },
	0xAF93, { 0xEC, 0xBA, 0x86 },
	0xAF94, { 0xEC, 0xBA, 0x88 },
	0xAF95, { 0xEC, 0xBA, 0x8A },
	0xAF96, { 0xEC, 0xBA, 0x8B },
	0xAF97, { 0xEC, 0xBA, 0x8C },
	0xAF98, { 0xEC, 0xBA, 0x8D },
	0xAF99, { 0xEC, 0xBA, 0x8E },
	0xAF9A, { 0xEC, 0xBA, 0x8F },
	0xAF9B, { 0xEC, 0xBA, 0x92 },
	0xAF9C, { 0xEC, 0xBA, 0x93 },
	0xAF9D, { 0xEC, 0xBA, 0x95 },
	0xAF9E, { 0xEC, 0xBA, 0x96 },
	0xAF9F, { 0xEC, 0xBA, 0x97 },
	0xAFA0, { 0xEC, 0xBA, 0x99 },
	0xB041, { 0xEC, 0xBA, 0x9A },
	0xB042, { 0xEC, 0xBA, 0x9B },
	0xB043, { 0xEC, 0xBA, 0x9C },
	0xB044, { 0xEC, 0xBA, 0x9D },
	0xB045, { 0xEC, 0xBA, 0x9E },
	0xB046, { 0xEC, 0xBA, 0x9F },
	0xB047, { 0xEC, 0xBA, 0xA2 },
	0xB048, { 0xEC, 0xBA, 0xA6 },
	0xB049, { 0xEC, 0xBA, 0xA7 },
	0xB04A, { 0xEC, 0xBA, 0xA8 },
	0xB04B, { 0xEC, 0xBA, 0xA9 },
	0xB04C, { 0xEC, 0xBA, 0xAA },
	0xB04D, { 0xEC, 0xBA, 0xAB },
	0xB04E, { 0xEC, 0xBA, 0xAE },
	0xB04F, { 0xEC, 0xBA, 0xAF },
	0xB050, { 0xEC, 0xBA, 0xB0 },
	0xB051, { 0xEC, 0xBA, 0xB1 },
	0xB052, { 0xEC, 0xBA, 0xB2 },
	0xB053, { 0xEC, 0xBA, 0xB3 },
	0xB054, { 0xEC, 0xBA, 0xB4 },
	0xB055, { 0xEC, 0xBA, 0xB5 },
	0xB056, { 0xEC, 0xBA, 0xB6 },
	0xB057, { 0xEC, 0xBA, 0xB7 },
	0xB058, { 0xEC, 0xBA, 0xB8 },
	0xB059, { 0xEC, 0xBA, 0xB9 },
	0xB05A, { 0xEC, 0xBA, 0xBA },
	0xB061, { 0xEC, 0xBA, 0xBB },
	0xB062, { 0xEC, 0xBA, 0xBC },
	0xB063, { 0xEC, 0xBA, 0xBD },
	0xB064, { 0xEC, 0xBA, 0xBE },
	0xB065, { 0xEC, 0xBA, 0xBF },
	0xB066, { 0xEC, 0xBB, 0x80 },
	0xB067, { 0xEC, 0xBB, 0x82 },
	0xB068, { 0xEC, 0xBB, 0x83 },
	0xB069, { 0xEC, 0xBB, 0x84 },
	0xB06A, { 0xEC, 0xBB, 0x85 },
	0xB06B, { 0xEC, 0xBB, 0x86 },
	0xB06C, { 0xEC, 0xBB, 0x87 },
	0xB06D, { 0xEC, 0xBB, 0x88 },
	0xB06E, { 0xEC, 0xBB, 0x89 },
	0xB06F, { 0xEC, 0xBB, 0x8A },
	0xB070, { 0xEC, 0xBB, 0x8B },
	0xB071, { 0xEC, 0xBB, 0x8C },
	0xB072, { 0xEC, 0xBB, 0x8D },
	0xB073, { 0xEC, 0xBB, 0x8E },
	0xB074, { 0xEC, 0xBB, 0x8F },
	0xB075, { 0xEC, 0xBB, 0x90 },
	0xB076, { 0xEC, 0xBB, 0x91 },
	0xB077, { 0xEC, 0xBB, 0x92 },
	0xB078, { 0xEC, 0xBB, 0x93 },
	0xB079, { 0xEC, 0xBB, 0x94 },
	0xB07A, { 0xEC, 0xBB, 0x95 },
	0xB081, { 0xEC, 0xBB, 0x96 },
	0xB082, { 0xEC, 0xBB, 0x97 },
	0xB083, { 0xEC, 0xBB, 0x98 },
	0xB084, { 0xEC, 0xBB, 0x99 },
	0xB085, { 0xEC, 0xBB, 0x9A },
	0xB086, { 0xEC, 0xBB, 0x9B },
	0xB087, { 0xEC, 0xBB, 0x9C },
	0xB088, { 0xEC, 0xBB, 0x9D },
	0xB089, { 0xEC, 0xBB, 0x9E },
	0xB08A, { 0xEC, 0xBB, 0x9F },
	0xB08B, { 0xEC, 0xBB, 0xA0 },
	0xB08C, { 0xEC, 0xBB, 0xA1 },
	0xB08D, { 0xEC, 0xBB, 0xA2 },
	0xB08E, { 0xEC, 0xBB, 0xA3 },
	0xB08F, { 0xEC, 0xBB, 0xA6 },
	0xB090, { 0xEC, 0xBB, 0xA7 },
	0xB091, { 0xEC, 0xBB, 0xA9 },
	0xB092, { 0xEC, 0xBB, 0xAA },
	0xB093, { 0xEC, 0xBB, 0xAD },
	0xB094, { 0xEC, 0xBB, 0xAE },
	0xB095, { 0xEC, 0xBB, 0xAF },
	0xB096, { 0xEC, 0xBB, 0xB0 },
	0xB097, { 0xEC, 0xBB, 0xB1 },
	0xB098, { 0xEC, 0xBB, 0xB2 },
	0xB099, { 0xEC, 0xBB, 0xB3 },
	0xB09A, { 0xEC, 0xBB, 0xB6 },
	0xB09B, { 0xEC, 0xBB, 0xBA },
	0xB09C, { 0xEC, 0xBB, 0xBB },
	0xB09D, { 0xEC, 0xBB, 0xBC },
	0xB09E, { 0xEC, 0xBB, 0xBD },
	0xB09F, { 0xEC, 0xBB, 0xBE },
	0xB0A0, { 0xEC, 0xBB, 0xBF },
	0xB0A1, { 0xEA, 0xB0, 0x80 },
	0xB0A2, { 0xEA, 0xB0, 0x81 },
	0xB0A3, { 0xEA, 0xB0, 0x84 },
	0xB0A4, { 0xEA, 0xB0, 0x87 },
	0xB0A5, { 0xEA, 0xB0, 0x88 },
	0xB0A6, { 0xEA, 0xB0, 0x89 },
	0xB0A7, { 0xEA, 0xB0, 0x8A },
	0xB0A8, { 0xEA, 0xB0, 0x90 },
	0xB0A9, { 0xEA, 0xB0, 0x91 },
	0xB0AA, { 0xEA, 0xB0, 0x92 },
	0xB0AB, { 0xEA, 0xB0, 0x93 },
	0xB0AC, { 0xEA, 0xB0, 0x94 },
	0xB0AD, { 0xEA, 0xB0, 0x95 },
	0xB0AE, { 0xEA, 0xB0, 0x96 },
	0xB0AF, { 0xEA, 0xB0, 0x97 },
	0xB0B0, { 0xEA, 0xB0, 0x99 },
	0xB0B1, { 0xEA, 0xB0, 0x9A },
	0xB0B2, { 0xEA, 0xB0, 0x9B },
	0xB0B3, { 0xEA, 0xB0, 0x9C },
	0xB0B4, { 0xEA, 0xB0, 0x9D },
	0xB0B5, { 0xEA, 0xB0, 0xA0 },
	0xB0B6, { 0xEA, 0xB0, 0xA4 },
	0xB0B7, { 0xEA, 0xB0, 0xAC },
	0xB0B8, { 0xEA, 0xB0, 0xAD },
	0xB0B9, { 0xEA, 0xB0, 0xAF },
	0xB0BA, { 0xEA, 0xB0, 0xB0 },
	0xB0BB, { 0xEA, 0xB0, 0xB1 },
	0xB0BC, { 0xEA, 0xB0, 0xB8 },
	0xB0BD, { 0xEA, 0xB0, 0xB9 },
	0xB0BE, { 0xEA, 0xB0, 0xBC },
	0xB0BF, { 0xEA, 0xB1, 0x80 },
	0xB0C0, { 0xEA, 0xB1, 0x8B },
	0xB0C1, { 0xEA, 0xB1, 0x8D },
	0xB0C2, { 0xEA, 0xB1, 0x94 },
	0xB0C3, { 0xEA, 0xB1, 0x98 },
	0xB0C4, { 0xEA, 0xB1, 0x9C },
	0xB0C5, { 0xEA, 0xB1, 0xB0 },
	0xB0C6, { 0xEA, 0xB1, 0xB1 },
	0xB0C7, { 0xEA, 0xB1, 0xB4 },
	0xB0C8, { 0xEA, 0xB1, 0xB7 },
	0xB0C9, { 0xEA, 0xB1, 0xB8 },
	0xB0CA, { 0xEA, 0xB1, 0xBA },
	0xB0CB, { 0xEA, 0xB2, 0x80 },
	0xB0CC, { 0xEA, 0xB2, 0x81 },
	0xB0CD, { 0xEA, 0xB2, 0x83 },
	0xB0CE, { 0xEA, 0xB2, 0x84 },
	0xB0CF, { 0xEA, 0xB2, 0x85 },
	0xB0D0, { 0xEA, 0xB2, 0x86 },
	0xB0D1, { 0xEA, 0xB2, 0x89 },
	0xB0D2, { 0xEA, 0xB2, 0x8A },
	0xB0D3, { 0xEA, 0xB2, 0x8B },
	0xB0D4, { 0xEA, 0xB2, 0x8C },
	0xB0D5, { 0xEA, 0xB2, 0x90 },
	0xB0D6, { 0xEA, 0xB2, 0x94 },
	0xB0D7, { 0xEA, 0xB2, 0x9C },
	0xB0D8, { 0xEA, 0xB2, 0x9D },
	0xB0D9, { 0xEA, 0xB2, 0x9F },
	0xB0DA, { 0xEA, 0xB2, 0xA0 },
	0xB0DB, { 0xEA, 0xB2, 0xA1 },
	0xB0DC, { 0xEA, 0xB2, 0xA8 },
	0xB0DD, { 0xEA, 0xB2, 0xA9 },
	0xB0DE, { 0xEA, 0xB2, 0xAA },
	0xB0DF, { 0xEA, 0xB2, 0xAC },
	0xB0E0, { 0xEA, 0xB2, 0xAF },
	0xB0E1, { 0xEA, 0xB2, 0xB0 },
	0xB0E2, { 0xEA, 0xB2, 0xB8 },
	0xB0E3, { 0xEA, 0xB2, 0xB9 },
	0xB0E4, { 0xEA, 0xB2, 0xBB },
	0xB0E5, { 0xEA, 0xB2, 0xBC },
	0xB0E6, { 0xEA, 0xB2, 0xBD },
	0xB0E7, { 0xEA, 0xB3, 0x81 },
	0xB0E8, { 0xEA, 0xB3, 0x84 },
	0xB0E9, { 0xEA, 0xB3, 0x88 },
	0xB0EA, { 0xEA, 0xB3, 0x8C },
	0xB0EB, { 0xEA, 0xB3, 0x95 },
	0xB0EC, { 0xEA, 0xB3, 0x97 },
	0xB0ED, { 0xEA, 0xB3, 0xA0 },
	0xB0EE, { 0xEA, 0xB3, 0xA1 },
	0xB0EF, { 0xEA, 0xB3, 0xA4 },
	0xB0F0, { 0xEA, 0xB3, 0xA7 },
	0xB0F1, { 0xEA, 0xB3, 0xA8 },
	0xB0F2, { 0xEA, 0xB3, 0xAA },
	0xB0F3, { 0xEA, 0xB3, 0xAC },
	0xB0F4, { 0xEA, 0xB3, 0xAF },
	0xB0F5, { 0xEA, 0xB3, 0xB0 },
	0xB0F6, { 0xEA, 0xB3, 0xB1 },
	0xB0F7, { 0xEA, 0xB3, 0xB3 },
	0xB0F8, { 0xEA, 0xB3, 0xB5 },
	0xB0F9, { 0xEA, 0xB3, 0xB6 },
	0xB0FA, { 0xEA, 0xB3, 0xBC },
	0xB0FB, { 0xEA, 0xB3, 0xBD },
	0xB0FC, { 0xEA, 0xB4, 0x80 },
	0xB0FD, { 0xEA, 0xB4, 0x84 },
	0xB0FE, { 0xEA, 0xB4, 0x86 },
	0xB141, { 0xEC, 0xBC, 0x82 },
	0xB142, { 0xEC, 0xBC, 0x83 },
	0xB143, { 0xEC, 0xBC, 0x85 },
	0xB144, { 0xEC, 0xBC, 0x86 },
	0xB145, { 0xEC, 0xBC, 0x87 },
	0xB146, { 0xEC, 0xBC, 0x89 },
	0xB147, { 0xEC, 0xBC, 0x8A },
	0xB148, { 0xEC, 0xBC, 0x8B },
	0xB149, { 0xEC, 0xBC, 0x8C },
	0xB14A, { 0xEC, 0xBC, 0x8D },
	0xB14B, { 0xEC, 0xBC, 0x8E },
	0xB14C, { 0xEC, 0xBC, 0x8F },
	0xB14D, { 0xEC, 0xBC, 0x92 },
	0xB14E, { 0xEC, 0xBC, 0x94 },
	0xB14F, { 0xEC, 0xBC, 0x96 },
	0xB150, { 0xEC, 0xBC, 0x97 },
	0xB151, { 0xEC, 0xBC, 0x98 },
	0xB152, { 0xEC, 0xBC, 0x99 },
	0xB153, { 0xEC, 0xBC, 0x9A },
	0xB154, { 0xEC, 0xBC, 0x9B },
	0xB155, { 0xEC, 0xBC, 0x9D },
	0xB156, { 0xEC, 0xBC, 0x9E },
	0xB157, { 0xEC, 0xBC, 0x9F },
	0xB158, { 0xEC, 0xBC, 0xA1 },
	0xB159, { 0xEC, 0xBC, 0xA2 },
	0xB15A, { 0xEC, 0xBC, 0xA3 },
	0xB161, { 0xEC, 0xBC, 0xA5 },
	0xB162, { 0xEC, 0xBC, 0xA6 },
	0xB163, { 0xEC, 0xBC, 0xA7 },
	0xB164, { 0xEC, 0xBC, 0xA8 },
	0xB165, { 0xEC, 0xBC, 0xA9 },
	0xB166, { 0xEC, 0xBC, 0xAA },
	0xB167, { 0xEC, 0xBC, 0xAB },
	0xB168, { 0xEC, 0xBC, 0xAE },
	0xB169, { 0xEC, 0xBC, 0xB2 },
	0xB16A, { 0xEC, 0xBC, 0xB3 },
	0xB16B, { 0xEC, 0xBC, 0xB4 },
	0xB16C, { 0xEC, 0xBC, 0xB5 },
	0xB16D, { 0xEC, 0xBC, 0xB6 },
	0xB16E, { 0xEC, 0xBC, 0xB7 },
	0xB16F, { 0xEC, 0xBC, 0xB9 },
	0xB170, { 0xEC, 0xBC, 0xBA },
	0xB171, { 0xEC, 0xBC, 0xBB },
	0xB172, { 0xEC, 0xBC, 0xBC },
	0xB173, { 0xEC, 0xBC, 0xBD },
	0xB174, { 0xEC, 0xBC, 0xBE },
	0xB175, { 0xEC, 0xBC, 0xBF },
	0xB176, { 0xEC, 0xBD, 0x80 },
	0xB177, { 0xEC, 0xBD, 0x81 },
	0xB178, { 0xEC, 0xBD, 0x82 },
	0xB179, { 0xEC, 0xBD, 0x83 },
	0xB17A, { 0xEC, 0xBD, 0x84 },
	0xB181, { 0xEC, 0xBD, 0x85 },
	0xB182, { 0xEC, 0xBD, 0x86 },
	0xB183, { 0xEC, 0xBD, 0x87 },
	0xB184, { 0xEC, 0xBD, 0x88 },
	0xB185, { 0xEC, 0xBD, 0x89 },
	0xB186, { 0xEC, 0xBD, 0x8A },
	0xB187, { 0xEC, 0xBD, 0x8B },
	0xB188, { 0xEC, 0xBD, 0x8C },
	0xB189, { 0xEC, 0xBD, 0x8D },
	0xB18A, { 0xEC, 0xBD, 0x8E },
	0xB18B, { 0xEC, 0xBD, 0x8F },
	0xB18C, { 0xEC, 0xBD, 0x90 },
	0xB18D, { 0xEC, 0xBD, 0x91 },
	0xB18E, { 0xEC, 0xBD, 0x92 },
	0xB18F, { 0xEC, 0xBD, 0x93 },
	0xB190, { 0xEC, 0xBD, 0x96 },
	0xB191, { 0xEC, 0xBD, 0x97 },
	0xB192, { 0xEC, 0xBD, 0x99 },
	0xB193, { 0xEC, 0xBD, 0x9A },
	0xB194, { 0xEC, 0xBD, 0x9B },
	0xB195, { 0xEC, 0xBD, 0x9D },
	0xB196, { 0xEC, 0xBD, 0x9E },
	0xB197, { 0xEC, 0xBD, 0x9F },
	0xB198, { 0xEC, 0xBD, 0xA0 },
	0xB199, { 0xEC, 0xBD, 0xA1 },
	0xB19A, { 0xEC, 0xBD, 0xA2 },
	0xB19B, { 0xEC, 0xBD, 0xA3 },
	0xB19C, { 0xEC, 0xBD, 0xA6 },
	0xB19D, { 0xEC, 0xBD, 0xA8 },
	0xB19E, { 0xEC, 0xBD, 0xAA },
	0xB19F, { 0xEC, 0xBD, 0xAB },
	0xB1A0, { 0xEC, 0xBD, 0xAC },
	0xB1A1, { 0xEA, 0xB4, 0x8C },
	0xB1A2, { 0xEA, 0xB4, 0x8D },
	0xB1A3, { 0xEA, 0xB4, 0x8F },
	0xB1A4, { 0xEA, 0xB4, 0x91 },
	0xB1A5, { 0xEA, 0xB4, 0x98 },
	0xB1A6, { 0xEA, 0xB4, 0x9C },
	0xB1A7, { 0xEA, 0xB4, 0xA0 },
	0xB1A8, { 0xEA, 0xB4, 0xA9 },
	0xB1A9, { 0xEA, 0xB4, 0xAC },
	0xB1AA, { 0xEA, 0xB4, 0xAD },
	0xB1AB, { 0xEA, 0xB4, 0xB4 },
	0xB1AC, { 0xEA, 0xB4, 0xB5 },
	0xB1AD, { 0xEA, 0xB4, 0xB8 },
	0xB1AE, { 0xEA, 0xB4, 0xBC },
	0xB1AF, { 0xEA, 0xB5, 0x84 },
	0xB1B0, { 0xEA, 0xB5, 0x85 },
	0xB1B1, { 0xEA, 0xB5, 0x87 },
	0xB1B2, { 0xEA, 0xB5, 0x89 },
	0xB1B3, { 0xEA, 0xB5, 0x90 },
	0xB1B4, { 0xEA, 0xB5, 0x94 },
	0xB1B5, { 0xEA, 0xB5, 0x98 },
	0xB1B6, { 0xEA, 0xB5, 0xA1 },
	0xB1B7, { 0xEA, 0xB5, 0xA3 },
	0xB1B8, { 0xEA, 0xB5, 0xAC },
	0xB1B9, { 0xEA, 0xB5, 0xAD },
	0xB1BA, { 0xEA, 0xB5, 0xB0 },
	0xB1BB, { 0xEA, 0xB5, 0xB3 },
	0xB1BC, { 0xEA, 0xB5, 0xB4 },
	0xB1BD, { 0xEA, 0xB5, 0xB5 },
	0xB1BE, { 0xEA, 0xB5, 0xB6 },
	0xB1BF, { 0xEA, 0xB5, 0xBB },
	0xB1C0, { 0xEA, 0xB5, 0xBC },
	0xB1C1, { 0xEA, 0xB5, 0xBD },
	0xB1C2, { 0xEA, 0xB5, 0xBF },
	0xB1C3, { 0xEA, 0xB6, 0x81 },
	0xB1C4, { 0xEA, 0xB6, 0x82 },
	0xB1C5, { 0xEA, 0xB6, 0x88 },
	0xB1C6, { 0xEA, 0xB6, 0x89 },
	0xB1C7, { 0xEA, 0xB6, 0x8C },
	0xB1C8, { 0xEA, 0xB6, 0x90 },
	0xB1C9, { 0xEA, 0xB6, 0x9C },
	0xB1CA, { 0xEA, 0xB6, 0x9D },
	0xB1CB, { 0xEA, 0xB6, 0xA4 },
	0xB1CC, { 0xEA, 0xB6, 0xB7 },
	0xB1CD, { 0xEA, 0xB7, 0x80 },
	0xB1CE, { 0xEA, 0xB7, 0x81 },
	0xB1CF, { 0xEA, 0xB7, 0x84 },
	0xB1D0, { 0xEA, 0xB7, 0x88 },
	0xB1D1, { 0xEA, 0xB7, 0x90 },
	0xB1D2, { 0xEA, 0xB7, 0x91 },
	0xB1D3, { 0xEA, 0xB7, 0x93 },
	0xB1D4, { 0xEA, 0xB7, 0x9C },
	0xB1D5, { 0xEA, 0xB7, 0xA0 },
	0xB1D6, { 0xEA, 0xB7, 0xA4 },
	0xB1D7, { 0xEA, 0xB7, 0xB8 },
	0xB1D8, { 0xEA, 0xB7, 0xB9 },
	0xB1D9, { 0xEA, 0xB7, 0xBC },
	0xB1DA, { 0xEA, 0xB7, 0xBF },
	0xB1DB, { 0xEA, 0xB8, 0x80 },
	0xB1DC, { 0xEA, 0xB8, 0x81 },
	0xB1DD, { 0xEA, 0xB8, 0x88 },
	0xB1DE, { 0xEA, 0xB8, 0x89 },
	0xB1DF, { 0xEA, 0xB8, 0x8B },
	0xB1E0, { 0xEA, 0xB8, 0x8D },
	0xB1E1, { 0xEA, 0xB8, 0x94 },
	0xB1E2, { 0xEA, 0xB8, 0xB0 },
	0xB1E3, { 0xEA, 0xB8, 0xB1 },
	0xB1E4, { 0xEA, 0xB8, 0xB4 },
	0xB1E5, { 0xEA, 0xB8, 0xB7 },
	0xB1E6, { 0xEA, 0xB8, 0xB8 },
	0xB1E7, { 0xEA, 0xB8, 0xBA },
	0xB1E8, { 0xEA, 0xB9, 0x80 },
	0xB1E9, { 0xEA, 0xB9, 0x81 },
	0xB1EA, { 0xEA, 0xB9, 0x83 },
	0xB1EB, { 0xEA, 0xB9, 0x85 },
	0xB1EC, { 0xEA, 0xB9, 0x86 },
	0xB1ED, { 0xEA, 0xB9, 0x8A },
	0xB1EE, { 0xEA, 0xB9, 0x8C },
	0xB1EF, { 0xEA, 0xB9, 0x8D },
	0xB1F0, { 0xEA, 0xB9, 0x8E },
	0xB1F1, { 0xEA, 0xB9, 0x90 },
	0xB1F2, { 0xEA, 0xB9, 0x94 },
	0xB1F3, { 0xEA, 0xB9, 0x96 },
	0xB1F4, { 0xEA, 0xB9, 0x9C },
	0xB1F5, { 0xEA, 0xB9, 0x9D },
	0xB1F6, { 0xEA, 0xB9, 0x9F },
	0xB1F7, { 0xEA, 0xB9, 0xA0 },
	0xB1F8, { 0xEA, 0xB9, 0xA1 },
	0xB1F9, { 0xEA, 0xB9, 0xA5 },
	0xB1FA, { 0xEA, 0xB9, 0xA8 },
	0xB1FB, { 0xEA, 0xB9, 0xA9 },
	0xB1FC, { 0xEA, 0xB9, 0xAC },
	0xB1FD, { 0xEA, 0xB9, 0xB0 },
	0xB1FE, { 0xEA, 0xB9, 0xB8 },
	0xB241, { 0xEC, 0xBD, 0xAD },
	0xB242, { 0xEC, 0xBD, 0xAE },
	0xB243, { 0xEC, 0xBD, 0xAF },
	0xB244, { 0xEC, 0xBD, 0xB2 },
	0xB245, { 0xEC, 0xBD, 0xB3 },
	0xB246, { 0xEC, 0xBD, 0xB5 },
	0xB247, { 0xEC, 0xBD, 0xB6 },
	0xB248, { 0xEC, 0xBD, 0xB7 },
	0xB249, { 0xEC, 0xBD, 0xB9 },
	0xB24A, { 0xEC, 0xBD, 0xBA },
	0xB24B, { 0xEC, 0xBD, 0xBB },
	0xB24C, { 0xEC, 0xBD, 0xBC },
	0xB24D, { 0xEC, 0xBD, 0xBD },
	0xB24E, { 0xEC, 0xBD, 0xBE },
	0xB24F, { 0xEC, 0xBD, 0xBF },
	0xB250, { 0xEC, 0xBE, 0x81 },
	0xB251, { 0xEC, 0xBE, 0x82 },
	0xB252, { 0xEC, 0xBE, 0x83 },
	0xB253, { 0xEC, 0xBE, 0x84 },
	0xB254, { 0xEC, 0xBE, 0x86 },
	0xB255, { 0xEC, 0xBE, 0x87 },
	0xB256, { 0xEC, 0xBE, 0x88 },
	0xB257, { 0xEC, 0xBE, 0x89 },
	0xB258, { 0xEC, 0xBE, 0x8A },
	0xB259, { 0xEC, 0xBE, 0x8B },
	0xB25A, { 0xEC, 0xBE, 0x8D },
	0xB261, { 0xEC, 0xBE, 0x8E },
	0xB262, { 0xEC, 0xBE, 0x8F },
	0xB263, { 0xEC, 0xBE, 0x90 },
	0xB264, { 0xEC, 0xBE, 0x91 },
	0xB265, { 0xEC, 0xBE, 0x92 },
	0xB266, { 0xEC, 0xBE, 0x93 },
	0xB267, { 0xEC, 0xBE, 0x94 },
	0xB268, { 0xEC, 0xBE, 0x95 },
	0xB269, { 0xEC, 0xBE, 0x96 },
	0xB26A, { 0xEC, 0xBE, 0x97 },
	0xB26B, { 0xEC, 0xBE, 0x98 },
	0xB26C, { 0xEC, 0xBE, 0x99 },
	0xB26D, { 0xEC, 0xBE, 0x9A },
	0xB26E, { 0xEC, 0xBE, 0x9B },
	0xB26F, { 0xEC, 0xBE, 0x9C },
	0xB270, { 0xEC, 0xBE, 0x9D },
	0xB271, { 0xEC, 0xBE, 0x9E },
	0xB272, { 0xEC, 0xBE, 0x9F },
	0xB273, { 0xEC, 0xBE, 0xA0 },
	0xB274, { 0xEC, 0xBE, 0xA2 },
	0xB275, { 0xEC, 0xBE, 0xA3 },
	0xB276, { 0xEC, 0xBE, 0xA4 },
	0xB277, { 0xEC, 0xBE, 0xA5 },
	0xB278, { 0xEC, 0xBE, 0xA6 },
	0xB279, { 0xEC, 0xBE, 0xA7 },
	0xB27A, { 0xEC, 0xBE, 0xA9 },
	0xB281, { 0xEC, 0xBE, 0xAA },
	0xB282, { 0xEC, 0xBE, 0xAB },
	0xB283, { 0xEC, 0xBE, 0xAC },
	0xB284, { 0xEC, 0xBE, 0xAD },
	0xB285, { 0xEC, 0xBE, 0xAE },
	0xB286, { 0xEC, 0xBE, 0xAF },
	0xB287, { 0xEC, 0xBE, 0xB1 },
	0xB288, { 0xEC, 0xBE, 0xB2 },
	0xB289, { 0xEC, 0xBE, 0xB3 },
	0xB28A, { 0xEC, 0xBE, 0xB4 },
	0xB28B, { 0xEC, 0xBE, 0xB5 },
	0xB28C, { 0xEC, 0xBE, 0xB6 },
	0xB28D, { 0xEC, 0xBE, 0xB7 },
	0xB28E, { 0xEC, 0xBE, 0xB8 },
	0xB28F, { 0xEC, 0xBE, 0xB9 },
	0xB290, { 0xEC, 0xBE, 0xBA },
	0xB291, { 0xEC, 0xBE, 0xBB },
	0xB292, { 0xEC, 0xBE, 0xBC },
	0xB293, { 0xEC, 0xBE, 0xBD },
	0xB294, { 0xEC, 0xBE, 0xBE },
	0xB295, { 0xEC, 0xBE, 0xBF },
	0xB296, { 0xEC, 0xBF, 0x80 },
	0xB297, { 0xEC, 0xBF, 0x81 },
	0xB298, { 0xEC, 0xBF, 0x82 },
	0xB299, { 0xEC, 0xBF, 0x83 },
	0xB29A, { 0xEC, 0xBF, 0x85 },
	0xB29B, { 0xEC, 0xBF, 0x86 },
	0xB29C, { 0xEC, 0xBF, 0x87 },
	0xB29D, { 0xEC, 0xBF, 0x88 },
	0xB29E, { 0xEC, 0xBF, 0x89 },
	0xB29F, { 0xEC, 0xBF, 0x8A },
	0xB2A0, { 0xEC, 0xBF, 0x8B },
	0xB2A1, { 0xEA, 0xB9, 0xB9 },
	0xB2A2, { 0xEA, 0xB9, 0xBB },
	0xB2A3, { 0xEA, 0xB9, 0xBC },
	0xB2A4, { 0xEA, 0xB9, 0xBD },
	0xB2A5, { 0xEA, 0xBA, 0x84 },
	0xB2A6, { 0xEA, 0xBA, 0x85 },
	0xB2A7, { 0xEA, 0xBA, 0x8C },
	0xB2A8, { 0xEA, 0xBA, 0xBC },
	0xB2A9, { 0xEA, 0xBA, 0xBD },
	0xB2AA, { 0xEA, 0xBA, 0xBE },
	0xB2AB, { 0xEA, 0xBB, 0x80 },
	0xB2AC, { 0xEA, 0xBB, 0x84 },
	0xB2AD, { 0xEA, 0xBB, 0x8C },
	0xB2AE, { 0xEA, 0xBB, 0x8D },
	0xB2AF, { 0xEA, 0xBB, 0x8F },
	0xB2B0, { 0xEA, 0xBB, 0x90 },
	0xB2B1, { 0xEA, 0xBB, 0x91 },
	0xB2B2, { 0xEA, 0xBB, 0x98 },
	0xB2B3, { 0xEA, 0xBB, 0x99 },
	0xB2B4, { 0xEA, 0xBB, 0x9C },
	0xB2B5, { 0xEA, 0xBB, 0xA8 },
	0xB2B6, { 0xEA, 0xBB, 0xAB },
	0xB2B7, { 0xEA, 0xBB, 0xAD },
	0xB2B8, { 0xEA, 0xBB, 0xB4 },
	0xB2B9, { 0xEA, 0xBB, 0xB8 },
	0xB2BA, { 0xEA, 0xBB, 0xBC },
	0xB2BB, { 0xEA, 0xBC, 0x87 },
	0xB2BC, { 0xEA, 0xBC, 0x88 },
	0xB2BD, { 0xEA, 0xBC, 0x8D },
	0xB2BE, { 0xEA, 0xBC, 0x90 },
	0xB2BF, { 0xEA, 0xBC, 0xAC },
	0xB2C0, { 0xEA, 0xBC, 0xAD },
	0xB2C1, { 0xEA, 0xBC, 0xB0 },
	0xB2C2, { 0xEA, 0xBC, 0xB2 },
	0xB2C3, { 0xEA, 0xBC, 0xB4 },
	0xB2C4, { 0xEA, 0xBC, 0xBC },
	0xB2C5, { 0xEA, 0xBC, 0xBD },
	0xB2C6, { 0xEA, 0xBC, 0xBF },
	0xB2C7, { 0xEA, 0xBD, 0x81 },
	0xB2C8, { 0xEA, 0xBD, 0x82 },
	0xB2C9, { 0xEA, 0xBD, 0x83 },
	0xB2CA, { 0xEA, 0xBD, 0x88 },
	0xB2CB, { 0xEA, 0xBD, 0x89 },
	0xB2CC, { 0xEA, 0xBD, 0x90 },
	0xB2CD, { 0xEA, 0xBD, 0x9C },
	0xB2CE, { 0xEA, 0xBD, 0x9D },
	0xB2CF, { 0xEA, 0xBD, 0xA4 },
	0xB2D0, { 0xEA, 0xBD, 0xA5 },
	0xB2D1, { 0xEA, 0xBD, 0xB9 },
	0xB2D2, { 0xEA, 0xBE, 0x80 },
	0xB2D3, { 0xEA, 0xBE, 0x84 },
	0xB2D4, { 0xEA, 0xBE, 0x88 },
	0xB2D5, { 0xEA, 0xBE, 0x90 },
	0xB2D6, { 0xEA, 0xBE, 0x91 },
	0xB2D7, { 0xEA, 0xBE, 0x95 },
	0xB2D8, { 0xEA, 0xBE, 0x9C },
	0xB2D9, { 0xEA, 0xBE, 0xB8 },
	0xB2DA, { 0xEA, 0xBE, 0xB9 },
	0xB2DB, { 0xEA, 0xBE, 0xBC },
	0xB2DC, { 0xEA, 0xBF, 0x80 },
	0xB2DD, { 0xEA, 0xBF, 0x87 },
	0xB2DE, { 0xEA, 0xBF, 0x88 },
	0xB2DF, { 0xEA, 0xBF, 0x89 },
	0xB2E0, { 0xEA, 0xBF, 0x8B },
	0xB2E1, { 0xEA, 0xBF, 0x8D },
	0xB2E2, { 0xEA, 0xBF, 0x8E },
	0xB2E3, { 0xEA, 0xBF, 0x94 },
	0xB2E4, { 0xEA, 0xBF, 0x9C },
	0xB2E5, { 0xEA, 0xBF, 0xA8 },
	0xB2E6, { 0xEA, 0xBF, 0xA9 },
	0xB2E7, { 0xEA, 0xBF, 0xB0 },
	0xB2E8, { 0xEA, 0xBF, 0xB1 },
	0xB2E9, { 0xEA, 0xBF, 0xB4 },
	0xB2EA, { 0xEA, 0xBF, 0xB8 },
	0xB2EB, { 0xEB, 0x80, 0x80 },
	0xB2EC, { 0xEB, 0x80, 0x81 },
	0xB2ED, { 0xEB, 0x80, 0x84 },
	0xB2EE, { 0xEB, 0x80, 0x8C },
	0xB2EF, { 0xEB, 0x80, 0x90 },
	0xB2F0, { 0xEB, 0x80, 0x94 },
	0xB2F1, { 0xEB, 0x80, 0x9C },
	0xB2F2, { 0xEB, 0x80, 0x9D },
	0xB2F3, { 0xEB, 0x80, 0xA8 },
	0xB2F4, { 0xEB, 0x81, 0x84 },
	0xB2F5, { 0xEB, 0x81, 0x85 },
	0xB2F6, { 0xEB, 0x81, 0x88 },
	0xB2F7, { 0xEB, 0x81, 0x8A },
	0xB2F8, { 0xEB, 0x81, 0x8C },
	0xB2F9, { 0xEB, 0x81, 0x8E },
	0xB2FA, { 0xEB, 0x81, 0x93 },
	0xB2FB, { 0xEB, 0x81, 0x94 },
	0xB2FC, { 0xEB, 0x81, 0x95 },
	0xB2FD, { 0xEB, 0x81, 0x97 },
	0xB2FE, { 0xEB, 0x81, 0x99 },
	0xB341, { 0xEC, 0xBF, 0x8C },
	0xB342, { 0xEC, 0xBF, 0x8D },
	0xB343, { 0xEC, 0xBF, 0x8E },
	0xB344, { 0xEC, 0xBF, 0x8F },
	0xB345, { 0xEC, 0xBF, 0x90 },
	0xB346, { 0xEC, 0xBF, 0x91 },
	0xB347, { 0xEC, 0xBF, 0x92 },
	0xB348, { 0xEC, 0xBF, 0x93 },
	0xB349, { 0xEC, 0xBF, 0x94 },
	0xB34A, { 0xEC, 0xBF, 0x95 },
	0xB34B, { 0xEC, 0xBF, 0x96 },
	0xB34C, { 0xEC, 0xBF, 0x97 },
	0xB34D, { 0xEC, 0xBF, 0x98 },
	0xB34E, { 0xEC, 0xBF, 0x99 },
	0xB34F, { 0xEC, 0xBF, 0x9A },
	0xB350, { 0xEC, 0xBF, 0x9B },
	0xB351, { 0xEC, 0xBF, 0x9C },
	0xB352, { 0xEC, 0xBF, 0x9D },
	0xB353, { 0xEC, 0xBF, 0x9E },
	0xB354, { 0xEC, 0xBF, 0x9F },
	0xB355, { 0xEC, 0xBF, 0xA2 },
	0xB356, { 0xEC, 0xBF, 0xA3 },
	0xB357, { 0xEC, 0xBF, 0xA5 },
	0xB358, { 0xEC, 0xBF, 0xA6 },
	0xB359, { 0xEC, 0xBF, 0xA7 },
	0xB35A, { 0xEC, 0xBF, 0xA9 },
	0xB361, { 0xEC, 0xBF, 0xAA },
	0xB362, { 0xEC, 0xBF, 0xAB },
	0xB363, { 0xEC, 0xBF, 0xAC },
	0xB364, { 0xEC, 0xBF, 0xAD },
	0xB365, { 0xEC, 0xBF, 0xAE },
	0xB366, { 0xEC, 0xBF, 0xAF },
	0xB367, { 0xEC, 0xBF, 0xB2 },
	0xB368, { 0xEC, 0xBF, 0xB4 },
	0xB369, { 0xEC, 0xBF, 0xB6 },
	0xB36A, { 0xEC, 0xBF, 0xB7 },
	0xB36B, { 0xEC, 0xBF, 0xB8 },
	0xB36C, { 0xEC, 0xBF, 0xB9 },
	0xB36D, { 0xEC, 0xBF, 0xBA },
	0xB36E, { 0xEC, 0xBF, 0xBB },
	0xB36F, { 0xEC, 0xBF, 0xBD },
	0xB370, { 0xEC, 0xBF, 0xBE },
	0xB371, { 0xEC, 0xBF, 0xBF },
	0xB372, { 0xED, 0x80, 0x81 },
	0xB373, { 0xED, 0x80, 0x82 },
	0xB374, { 0xED, 0x80, 0x83 },
	0xB375, { 0xED, 0x80, 0x85 },
	0xB376, { 0xED, 0x80, 0x86 },
	0xB377, { 0xED, 0x80, 0x87 },
	0xB378, { 0xED, 0x80, 0x88 },
	0xB379, { 0xED, 0x80, 0x89 },
	0xB37A, { 0xED, 0x80, 0x8A },
	0xB381, { 0xED, 0x80, 0x8B },
	0xB382, { 0xED, 0x80, 0x8C },
	0xB383, { 0xED, 0x80, 0x8D },
	0xB384, { 0xED, 0x80, 0x8E },
	0xB385, { 0xED, 0x80, 0x8F },
	0xB386, { 0xED, 0x80, 0x90 },
	0xB387, { 0xED, 0x80, 0x92 },
	0xB388, { 0xED, 0x80, 0x93 },
	0xB389, { 0xED, 0x80, 0x94 },
	0xB38A, { 0xED, 0x80, 0x95 },
	0xB38B, { 0xED, 0x80, 0x96 },
	0xB38C, { 0xED, 0x80, 0x97 },
	0xB38D, { 0xED, 0x80, 0x99 },
	0xB38E, { 0xED, 0x80, 0x9A },
	0xB38F, { 0xED, 0x80, 0x9B },
	0xB390, { 0xED, 0x80, 0x9C },
	0xB391, { 0xED, 0x80, 0x9D },
	0xB392, { 0xED, 0x80, 0x9E },
	0xB393, { 0xED, 0x80, 0x9F },
	0xB394, { 0xED, 0x80, 0xA0 },
	0xB395, { 0xED, 0x80, 0xA1 },
	0xB396, { 0xED, 0x80, 0xA2 },
	0xB397, { 0xED, 0x80, 0xA3 },
	0xB398, { 0xED, 0x80, 0xA4 },
	0xB399, { 0xED, 0x80, 0xA5 },
	0xB39A, { 0xED, 0x80, 0xA6 },
	0xB39B, { 0xED, 0x80, 0xA7 },
	0xB39C, { 0xED, 0x80, 0xA8 },
	0xB39D, { 0xED, 0x80, 0xA9 },
	0xB39E, { 0xED, 0x80, 0xAA },
	0xB39F, { 0xED, 0x80, 0xAB },
	0xB3A0, { 0xED, 0x80, 0xAC },
	0xB3A1, { 0xEB, 0x81, 0x9D },
	0xB3A2, { 0xEB, 0x81, 0xBC },
	0xB3A3, { 0xEB, 0x81, 0xBD },
	0xB3A4, { 0xEB, 0x82, 0x80 },
	0xB3A5, { 0xEB, 0x82, 0x84 },
	0xB3A6, { 0xEB, 0x82, 0x8C },
	0xB3A7, { 0xEB, 0x82, 0x8D },
	0xB3A8, { 0xEB, 0x82, 0x8F },
	0xB3A9, { 0xEB, 0x82, 0x91 },
	0xB3AA, { 0xEB, 0x82, 0x98 },
	0xB3AB, { 0xEB, 0x82, 0x99 },
	0xB3AC, { 0xEB, 0x82, 0x9A },
	0xB3AD, { 0xEB, 0x82, 0x9C },
	0xB3AE, { 0xEB, 0x82, 0x9F },
	0xB3AF, { 0xEB, 0x82, 0xA0 },
	0xB3B0, { 0xEB, 0x82, 0xA1 },
	0xB3B1, { 0xEB, 0x82, 0xA2 },
	0xB3B2, { 0xEB, 0x82, 0xA8 },
	0xB3B3, { 0xEB, 0x82, 0xA9 },
	0xB3B4, { 0xEB, 0x82, 0xAB },
	0xB3B5, { 0xEB, 0x82, 0xAC },
	0xB3B6, { 0xEB, 0x82, 0xAD },
	0xB3B7, { 0xEB, 0x82, 0xAE },
	0xB3B8, { 0xEB, 0x82, 0xAF },
	0xB3B9, { 0xEB, 0x82, 0xB1 },
	0xB3BA, { 0xEB, 0x82, 0xB3 },
	0xB3BB, { 0xEB, 0x82, 0xB4 },
	0xB3BC, { 0xEB, 0x82, 0xB5 },
	0xB3BD, { 0xEB, 0x82, 0xB8 },
	0xB3BE, { 0xEB, 0x82, 0xBC },
	0xB3BF, { 0xEB, 0x83, 0x84 },
	0xB3C0, { 0xEB, 0x83, 0x85 },
	0xB3C1, { 0xEB, 0x83, 0x87 },
	0xB3C2, { 0xEB, 0x83, 0x88 },
	0xB3C3, { 0xEB, 0x83, 0x89 },
	0xB3C4, { 0xEB, 0x83, 0x90 },
	0xB3C5, { 0xEB, 0x83, 0x91 },
	0xB3C6, { 0xEB, 0x83, 0x94 },
	0xB3C7, { 0xEB, 0x83, 0x98 },
	0xB3C8, { 0xEB, 0x83, 0xA0 },
	0xB3C9, { 0xEB, 0x83, 0xA5 },
	0xB3CA, { 0xEB, 0x84, 0x88 },
	0xB3CB, { 0xEB, 0x84, 0x89 },
	0xB3CC, { 0xEB, 0x84, 0x8B },
	0xB3CD, { 0xEB, 0x84, 0x8C },
	0xB3CE, { 0xEB, 0x84, 0x90 },
	0xB3CF, { 0xEB, 0x84, 0x92 },
	0xB3D0, { 0xEB, 0x84, 0x93 },
	0xB3D1, { 0xEB, 0x84, 0x98 },
	0xB3D2, { 0xEB, 0x84, 0x99 },
	0xB3D3, { 0xEB, 0x84, 0x9B },
	0xB3D4, { 0xEB, 0x84, 0x9C },
	0xB3D5, { 0xEB, 0x84, 0x9D },
	0xB3D6, { 0xEB, 0x84, 0xA3 },
	0xB3D7, { 0xEB, 0x84, 0xA4 },
	0xB3D8, { 0xEB, 0x84, 0xA5 },
	0xB3D9, { 0xEB, 0x84, 0xA8 },
	0xB3DA, { 0xEB, 0x84, 0xAC },
	0xB3DB, { 0xEB, 0x84, 0xB4 },
	0xB3DC, { 0xEB, 0x84, 0xB5 },
	0xB3DD, { 0xEB, 0x84, 0xB7 },
	0xB3DE, { 0xEB, 0x84, 0xB8 },
	0xB3DF, { 0xEB, 0x84, 0xB9 },
	0xB3E0, { 0xEB, 0x85, 0x80 },
	0xB3E1, { 0xEB, 0x85, 0x81 },
	0xB3E2, { 0xEB, 0x85, 0x84 },
	0xB3E3, { 0xEB, 0x85, 0x88 },
	0xB3E4, { 0xEB, 0x85, 0x90 },
	0xB3E5, { 0xEB, 0x85, 0x91 },
	0xB3E6, { 0xEB, 0x85, 0x94 },
	0xB3E7, { 0xEB, 0x85, 0x95 },
	0xB3E8, { 0xEB, 0x85, 0x98 },
	0xB3E9, { 0xEB, 0x85, 0x9C },
	0xB3EA, { 0xEB, 0x85, 0xA0 },
	0xB3EB, { 0xEB, 0x85, 0xB8 },
	0xB3EC, { 0xEB, 0x85, 0xB9 },
	0xB3ED, { 0xEB, 0x85, 0xBC },
	0xB3EE, { 0xEB, 0x86, 0x80 },
	0xB3EF, { 0xEB, 0x86, 0x82 },
	0xB3F0, { 0xEB, 0x86, 0x88 },
	0xB3F1, { 0xEB, 0x86, 0x89 },
	0xB3F2, { 0xEB, 0x86, 0x8B },
	0xB3F3, { 0xEB, 0x86, 0x8D },
	0xB3F4, { 0xEB, 0x86, 0x92 },
	0xB3F5, { 0xEB, 0x86, 0x93 },
	0xB3F6, { 0xEB, 0x86, 0x94 },
	0xB3F7, { 0xEB, 0x86, 0x98 },
	0xB3F8, { 0xEB, 0x86, 0x9C },
	0xB3F9, { 0xEB, 0x86, 0xA8 },
	0xB3FA, { 0xEB, 0x87, 0x8C },
	0xB3FB, { 0xEB, 0x87, 0x90 },
	0xB3FC, { 0xEB, 0x87, 0x94 },
	0xB3FD, { 0xEB, 0x87, 0x9C },
	0xB3FE, { 0xEB, 0x87, 0x9D },
	0xB441, { 0xED, 0x80, 0xAE },
	0xB442, { 0xED, 0x80, 0xAF },
	0xB443, { 0xED, 0x80, 0xB0 },
	0xB444, { 0xED, 0x80, 0xB1 },
	0xB445, { 0xED, 0x80, 0xB2 },
	0xB446, { 0xED, 0x80, 0xB3 },
	0xB447, { 0xED, 0x80, 0xB6 },
	0xB448, { 0xED, 0x80, 0xB7 },
	0xB449, { 0xED, 0x80, 0xB9 },
	0xB44A, { 0xED, 0x80, 0xBA },
	0xB44B, { 0xED, 0x80, 0xBB },
	0xB44C, { 0xED, 0x80, 0xBD },
	0xB44D, { 0xED, 0x80, 0xBE },
	0xB44E, { 0xED, 0x80, 0xBF },
	0xB44F, { 0xED, 0x81, 0x80 },
	0xB450, { 0xED, 0x81, 0x81 },
	0xB451, { 0xED, 0x81, 0x82 },
	0xB452, { 0xED, 0x81, 0x83 },
	0xB453, { 0xED, 0x81, 0x86 },
	0xB454, { 0xED, 0x81, 0x88 },
	0xB455, { 0xED, 0x81, 0x8A },
	0xB456, { 0xED, 0x81, 0x8B },
	0xB457, { 0xED, 0x81, 0x8C },
	0xB458, { 0xED, 0x81, 0x8D },
	0xB459, { 0xED, 0x81, 0x8E },
	0xB45A, { 0xED, 0x81, 0x8F },
	0xB461, { 0xED, 0x81, 0x91 },
	0xB462, { 0xED, 0x81, 0x92 },
	0xB463, { 0xED, 0x81, 0x93 },
	0xB464, { 0xED, 0x81, 0x95 },
	0xB465, { 0xED, 0x81, 0x96 },
	0xB466, { 0xED, 0x81, 0x97 },
	0xB467, { 0xED, 0x81, 0x99 },
	0xB468, { 0xED, 0x81, 0x9A },
	0xB469, { 0xED, 0x81, 0x9B },
	0xB46A, { 0xED, 0x81, 0x9C },
	0xB46B, { 0xED, 0x81, 0x9D },
	0xB46C, { 0xED, 0x81, 0x9E },
	0xB46D, { 0xED, 0x81, 0x9F },
	0xB46E, { 0xED, 0x81, 0xA1 },
	0xB46F, { 0xED, 0x81, 0xA2 },
	0xB470, { 0xED, 0x81, 0xA3 },
	0xB471, { 0xED, 0x81, 0xA4 },
	0xB472, { 0xED, 0x81, 0xA5 },
	0xB473, { 0xED, 0x81, 0xA6 },
	0xB474, { 0xED, 0x81, 0xA7 },
	0xB475, { 0xED, 0x81, 0xA8 },
	0xB476, { 0xED, 0x81, 0xA9 },
	0xB477, { 0xED, 0x81, 0xAA },
	0xB478, { 0xED, 0x81, 0xAB },
	0xB479, { 0xED, 0x81, 0xAE },
	0xB47A, { 0xED, 0x81, 0xAF },
	0xB481, { 0xED, 0x81, 0xB1 },
	0xB482, { 0xED, 0x81, 0xB2 },
	0xB483, { 0xED, 0x81, 0xB3 },
	0xB484, { 0xED, 0x81, 0xB5 },
	0xB485, { 0xED, 0x81, 0xB6 },
	0xB486, { 0xED, 0x81, 0xB7 },
	0xB487, { 0xED, 0x81, 0xB8 },
	0xB488, { 0xED, 0x81, 0xB9 },
	0xB489, { 0xED, 0x81, 0xBA },
	0xB48A, { 0xED, 0x81, 0xBB },
	0xB48B, { 0xED, 0x81, 0xBE },
	0xB48C, { 0xED, 0x81, 0xBF },
	0xB48D, { 0xED, 0x82, 0x80 },
	0xB48E, { 0xED, 0x82, 0x82 },
	0xB48F, { 0xED, 0x82, 0x83 },
	0xB490, { 0xED, 0x82, 0x84 },
	0xB491, { 0xED, 0x82, 0x85 },
	0xB492, { 0xED, 0x82, 0x86 },
	0xB493, { 0xED, 0x82, 0x87 },
	0xB494, { 0xED, 0x82, 0x88 },
	0xB495, { 0xED, 0x82, 0x89 },
	0xB496, { 0xED, 0x82, 0x8A },
	0xB497, { 0xED, 0x82, 0x8B },
	0xB498, { 0xED, 0x82, 0x8C },
	0xB499, { 0xED, 0x82, 0x8D },
	0xB49A, { 0xED, 0x82, 0x8E },
	0xB49B, { 0xED, 0x82, 0x8F },
	0xB49C, { 0xED, 0x82, 0x90 },
	0xB49D, { 0xED, 0x82, 0x91 },
	0xB49E, { 0xED, 0x82, 0x92 },
	0xB49F, { 0xED, 0x82, 0x93 },
	0xB4A0, { 0xED, 0x82, 0x94 },
	0xB4A1, { 0xEB, 0x87, 0x9F },
	0xB4A2, { 0xEB, 0x87, 0xA8 },
	0xB4A3, { 0xEB, 0x87, 0xA9 },
	0xB4A4, { 0xEB, 0x87, 0xAC },
	0xB4A5, { 0xEB, 0x87, 0xB0 },
	0xB4A6, { 0xEB, 0x87, 0xB9 },
	0xB4A7, { 0xEB, 0x87, 0xBB },
	0xB4A8, { 0xEB, 0x87, 0xBD },
	0xB4A9, { 0xEB, 0x88, 0x84 },
	0xB4AA, { 0xEB, 0x88, 0x85 },
	0xB4AB, { 0xEB, 0x88, 0x88 },
	0xB4AC, { 0xEB, 0x88, 0x8B },
	0xB4AD, { 0xEB, 0x88, 0x8C },
	0xB4AE, { 0xEB, 0x88, 0x94 },
	0xB4AF, { 0xEB, 0x88, 0x95 },
	0xB4B0, { 0xEB, 0x88, 0x97 },
	0xB4B1, { 0xEB, 0x88, 0x99 },
	0xB4B2, { 0xEB, 0x88, 0xA0 },
	0xB4B3, { 0xEB, 0x88, 0xB4 },
	0xB4B4, { 0xEB, 0x88, 0xBC },
	0xB4B5, { 0xEB, 0x89, 0x98 },
	0xB4B6, { 0xEB, 0x89, 0x9C },
	0xB4B7, { 0xEB, 0x89, 0xA0 },
	0xB4B8, { 0xEB, 0x89, 0xA8 },
	0xB4B9, { 0xEB, 0x89, 0xA9 },
	0xB4BA, { 0xEB, 0x89, 0xB4 },
	0xB4BB, { 0xEB, 0x89, 0xB5 },
	0xB4BC, { 0xEB, 0x89, 0xBC },
	0xB4BD, { 0xEB, 0x8A, 0x84 },
	0xB4BE, { 0xEB, 0x8A, 0x85 },
	0xB4BF, { 0xEB, 0x8A, 0x89 },
	0xB4C0, { 0xEB, 0x8A, 0x90 },
	0xB4C1, { 0xEB, 0x8A, 0x91 },
	0xB4C2, { 0xEB, 0x8A, 0x94 },
	0xB4C3, { 0xEB, 0x8A, 0x98 },
	0xB4C4, { 0xEB, 0x8A, 0x99 },
	0xB4C5, { 0xEB, 0x8A, 0x9A },
	0xB4C6, { 0xEB, 0x8A, 0xA0 },
	0xB4C7, { 0xEB, 0x8A, 0xA1 },
	0xB4C8, { 0xEB, 0x8A, 0xA3 },
	0xB4C9, { 0xEB, 0x8A, 0xA5 },
	0xB4CA, { 0xEB, 0x8A, 0xA6 },
	0xB4CB, { 0xEB, 0x8A, 0xAA },
	0xB4CC, { 0xEB, 0x8A, 0xAC },
	0xB4CD, { 0xEB, 0x8A, 0xB0 },
	0xB4CE, { 0xEB, 0x8A, 0xB4 },
	0xB4CF, { 0xEB, 0x8B, 0x88 },
	0xB4D0, { 0xEB, 0x8B, 0x89 },
	0xB4D1, { 0xEB, 0x8B, 0x8C },
	0xB4D2, { 0xEB, 0x8B, 0x90 },
	0xB4D3, { 0xEB, 0x8B, 0x92 },
	0xB4D4, { 0xEB, 0x8B, 0x98 },
	0xB4D5, { 0xEB, 0x8B, 0x99 },
	0xB4D6, { 0xEB, 0x8B, 0x9B },
	0xB4D7, { 0xEB, 0x8B, 0x9D },
	0xB4D8, { 0xEB, 0x8B, 0xA2 },
	0xB4D9, { 0xEB, 0x8B, 0xA4 },
	0xB4DA, { 0xEB, 0x8B, 0xA5 },
	0xB4DB, { 0xEB, 0x8B, 0xA6 },
	0xB4DC, { 0xEB, 0x8B, 0xA8 },
	0xB4DD, { 0xEB, 0x8B, 0xAB },
	0xB4DE, { 0xEB, 0x8B, 0xAC },
	0xB4DF, { 0xEB, 0x8B, 0xAD },
	0xB4E0, { 0xEB, 0x8B, 0xAE },
	0xB4E1, { 0xEB, 0x8B, 0xAF },
	0xB4E2, { 0xEB, 0x8B, 0xB3 },
	0xB4E3, { 0xEB, 0x8B, 0xB4 },
	0xB4E4, { 0xEB, 0x8B, 0xB5 },
	0xB4E5, { 0xEB, 0x8B, 0xB7 },
	0xB4E6, { 0xEB, 0x8B, 0xB8 },
	0xB4E7, { 0xEB, 0x8B, 0xB9 },
	0xB4E8, { 0xEB, 0x8B, 0xBA },
	0xB4E9, { 0xEB, 0x8B, 0xBB },
	0xB4EA, { 0xEB, 0x8B, 0xBF },
	0xB4EB, { 0xEB, 0x8C, 0x80 },
	0xB4EC, { 0xEB, 0x8C, 0x81 },
	0xB4ED, { 0xEB, 0x8C, 0x84 },
	0xB4EE, { 0xEB, 0x8C, 0x88 },
	0xB4EF, { 0xEB, 0x8C, 0x90 },
	0xB4F0, { 0xEB, 0x8C, 0x91 },
	0xB4F1, { 0xEB, 0x8C, 0x93 },
	0xB4F2, { 0xEB, 0x8C, 0x94 },
	0xB4F3, { 0xEB, 0x8C, 0x95 },
	0xB4F4, { 0xEB, 0x8C, 0x9C },
	0xB4F5, { 0xEB, 0x8D, 0x94 },
	0xB4F6, { 0xEB, 0x8D, 0x95 },
	0xB4F7, { 0xEB, 0x8D, 0x96 },
	0xB4F8, { 0xEB, 0x8D, 0x98 },
	0xB4F9, { 0xEB, 0x8D, 0x9B },
	0xB4FA, { 0xEB, 0x8D, 0x9C },
	0xB4FB, { 0xEB, 0x8D, 0x9E },
	0xB4FC, { 0xEB, 0x8D, 0x9F },
	0xB4FD, { 0xEB, 0x8D, 0xA4 },
	0xB4FE, { 0xEB, 0x8D, 0xA5 },
	0xB541, { 0xED, 0x82, 0x95 },
	0xB542, { 0xED, 0x82, 0x96 },
	0xB543, { 0xED, 0x82, 0x97 },
	0xB544, { 0xED, 0x82, 0x98 },
	0xB545, { 0xED, 0x82, 0x99 },
	0xB546, { 0xED, 0x82, 0x9A },
	0xB547, { 0xED, 0x82, 0x9B },
	0xB548, { 0xED, 0x82, 0x9C },
	0xB549, { 0xED, 0x82, 0x9D },
	0xB54A, { 0xED, 0x82, 0x9E },
	0xB54B, { 0xED, 0x82, 0x9F },
	0xB54C, { 0xED, 0x82, 0xA0 },
	0xB54D, { 0xED, 0x82, 0xA1 },
	0xB54E, { 0xED, 0x82, 0xA2 },
	0xB54F, { 0xED, 0x82, 0xA3 },
	0xB550, { 0xED, 0x82, 0xA6 },
	0xB551, { 0xED, 0x82, 0xA7 },
	0xB552, { 0xED, 0x82, 0xA9 },
	0xB553, { 0xED, 0x82, 0xAA },
	0xB554, { 0xED, 0x82, 0xAB },
	0xB555, { 0xED, 0x82, 0xAD },
	0xB556, { 0xED, 0x82, 0xAE },
	0xB557, { 0xED, 0x82, 0xAF },
	0xB558, { 0xED, 0x82, 0xB0 },
	0xB559, { 0xED, 0x82, 0xB1 },
	0xB55A, { 0xED, 0x82, 0xB2 },
	0xB561, { 0xED, 0x82, 0xB3 },
	0xB562, { 0xED, 0x82, 0xB6 },
	0xB563, { 0xED, 0x82, 0xB8 },
	0xB564, { 0xED, 0x82, 0xBA },
	0xB565, { 0xED, 0x82, 0xBB },
	0xB566, { 0xED, 0x82, 0xBC },
	0xB567, { 0xED, 0x82, 0xBD },
	0xB568, { 0xED, 0x82, 0xBE },
	0xB569, { 0xED, 0x82, 0xBF },
	0xB56A, { 0xED, 0x83, 0x82 },
	0xB56B, { 0xED, 0x83, 0x83 },
	0xB56C, { 0xED, 0x83, 0x85 },
	0xB56D, { 0xED, 0x83, 0x86 },
	0xB56E, { 0xED, 0x83, 0x87 },
	0xB56F, { 0xED, 0x83, 0x8A },
	0xB570, { 0xED, 0x83, 0x8B },
	0xB571, { 0xED, 0x83, 0x8C },
	0xB572, { 0xED, 0x83, 0x8D },
	0xB573, { 0xED, 0x83, 0x8E },
	0xB574, { 0xED, 0x83, 0x8F },
	0xB575, { 0xED, 0x83, 0x92 },
	0xB576, { 0xED, 0x83, 0x96 },
	0xB577, { 0xED, 0x83, 0x97 },
	0xB578, { 0xED, 0x83, 0x98 },
	0xB579, { 0xED, 0x83, 0x99 },
	0xB57A, { 0xED, 0x83, 0x9A },
	0xB581, { 0xED, 0x83, 0x9B },
	0xB582, { 0xED, 0x83, 0x9E },
	0xB583, { 0xED, 0x83, 0x9F },
	0xB584, { 0xED, 0x83, 0xA1 },
	0xB585, { 0xED, 0x83, 0xA2 },
	0xB586, { 0xED, 0x83, 0xA3 },
	0xB587, { 0xED, 0x83, 0xA5 },
	0xB588, { 0xED, 0x83, 0xA6 },
	0xB589, { 0xED, 0x83, 0xA7 },
	0xB58A, { 0xED, 0x83, 0xA8 },
	0xB58B, { 0xED, 0x83, 0xA9 },
	0xB58C, { 0xED, 0x83, 0xAA },
	0xB58D, { 0xED, 0x83, 0xAB },
	0xB58E, { 0xED, 0x83, 0xAE },
	0xB58F, { 0xED, 0x83, 0xB2 },
	0xB590, { 0xED, 0x83, 0xB3 },
	0xB591, { 0xED, 0x83, 0xB4 },
	0xB592, { 0xED, 0x83, 0xB5 },
	0xB593, { 0xED, 0x83, 0xB6 },
	0xB594, { 0xED, 0x83, 0xB7 },
	0xB595, { 0xED, 0x83, 0xB9 },
	0xB596, { 0xED, 0x83, 0xBA },
	0xB597, { 0xED, 0x83, 0xBB },
	0xB598, { 0xED, 0x83, 0xBC },
	0xB599, { 0xED, 0x83, 0xBD },
	0xB59A, { 0xED, 0x83, 0xBE },
	0xB59B, { 0xED, 0x83, 0xBF },
	0xB59C, { 0xED, 0x84, 0x80 },
	0xB59D, { 0xED, 0x84, 0x81 },
	0xB59E, { 0xED, 0x84, 0x82 },
	0xB59F, { 0xED, 0x84, 0x83 },
	0xB5A0, { 0xED, 0x84, 0x84 },
	0xB5A1, { 0xEB, 0x8D, 0xA7 },
	0xB5A2, { 0xEB, 0x8D, 0xA9 },
	0xB5A3, { 0xEB, 0x8D, 0xAB },
	0xB5A4, { 0xEB, 0x8D, 0xAE },
	0xB5A5, { 0xEB, 0x8D, 0xB0 },
	0xB5A6, { 0xEB, 0x8D, 0xB1 },
	0xB5A7, { 0xEB, 0x8D, 0xB4 },
	0xB5A8, { 0xEB, 0x8D, 0xB8 },
	0xB5A9, { 0xEB, 0x8E, 0x80 },
	0xB5AA, { 0xEB, 0x8E, 0x81 },
	0xB5AB, { 0xEB, 0x8E, 0x83 },
	0xB5AC, { 0xEB, 0x8E, 0x84 },
	0xB5AD, { 0xEB, 0x8E, 0x85 },
	0xB5AE, { 0xEB, 0x8E, 0x8C },
	0xB5AF, { 0xEB, 0x8E, 0x90 },
	0xB5B0, { 0xEB, 0x8E, 0x94 },
	0xB5B1, { 0xEB, 0x8E, 0xA0 },
	0xB5B2, { 0xEB, 0x8E, 0xA1 },
	0xB5B3, { 0xEB, 0x8E, 0xA8 },
	0xB5B4, { 0xEB, 0x8E, 0xAC },
	0xB5B5, { 0xEB, 0x8F, 0x84 },
	0xB5B6, { 0xEB, 0x8F, 0x85 },
	0xB5B7, { 0xEB, 0x8F, 0x88 },
	0xB5B8, { 0xEB, 0x8F, 0x8B },
	0xB5B9, { 0xEB, 0x8F, 0x8C },
	0xB5BA, { 0xEB, 0x8F, 0x8E },
	0xB5BB, { 0xEB, 0x8F, 0x90 },
	0xB5BC, { 0xEB, 0x8F, 0x94 },
	0xB5BD, { 0xEB, 0x8F, 0x95 },
	0xB5BE, { 0xEB, 0x8F, 0x97 },
	0xB5BF, { 0xEB, 0x8F, 0x99 },
	0xB5C0, { 0xEB, 0x8F, 0x9B },
	0xB5C1, { 0xEB, 0x8F, 0x9D },
	0xB5C2, { 0xEB, 0x8F, 0xA0 },
	0xB5C3, { 0xEB, 0x8F, 0xA4 },
	0xB5C4, { 0xEB, 0x8F, 0xA8 },
	0xB5C5, { 0xEB, 0x8F, 0xBC },
	0xB5C6, { 0xEB, 0x90, 0x90 },
	0xB5C7, { 0xEB, 0x90, 0x98 },
	0xB5C8, { 0xEB, 0x90, 0x9C },
	0xB5C9, { 0xEB, 0x90, 0xA0 },
	0xB5CA, { 0xEB, 0x90, 0xA8 },
	0xB5CB, { 0xEB, 0x90, 0xA9 },
	0xB5CC, { 0xEB, 0x90, 0xAB },
	0xB5CD, { 0xEB, 0x90, 0xB4 },
	0xB5CE, { 0xEB, 0x91, 0x90 },
	0xB5CF, { 0xEB, 0x91, 0x91 },
	0xB5D0, { 0xEB, 0x91, 0x94 },
	0xB5D1, { 0xEB, 0x91, 0x98 },
	0xB5D2, { 0xEB, 0x91, 0xA0 },
	0xB5D3, { 0xEB, 0x91, 0xA1 },
	0xB5D4, { 0xEB, 0x91, 0xA3 },
	0xB5D5, { 0xEB, 0x91, 0xA5 },
	0xB5D6, { 0xEB, 0x91, 0xAC },
	0xB5D7, { 0xEB, 0x92, 0x80 },
	0xB5D8, { 0xEB, 0x92, 0x88 },
	0xB5D9, { 0xEB, 0x92, 0x9D },
	0xB5DA, { 0xEB, 0x92, 0xA4 },
	0xB5DB, { 0xEB, 0x92, 0xA8 },
	0xB5DC, { 0xEB, 0x92, 0xAC },
	0xB5DD, { 0xEB, 0x92, 0xB5 },
	0xB5DE, { 0xEB, 0x92, 0xB7 },
	0xB5DF, { 0xEB, 0x92, 0xB9 },
	0xB5E0, { 0xEB, 0x93, 0x80 },
	0xB5E1, { 0xEB, 0x93, 0x84 },
	0xB5E2, { 0xEB, 0x93, 0x88 },
	0xB5E3, { 0xEB, 0x93, 0x90 },
	0xB5E4, { 0xEB, 0x93, 0x95 },
	0xB5E5, { 0xEB, 0x93, 0x9C },
	0xB5E6, { 0xEB, 0x93, 0x9D },
	0xB5E7, { 0xEB, 0x93, 0xA0 },
	0xB5E8, { 0xEB, 0x93, 0xA3 },
	0xB5E9, { 0xEB, 0x93, 0xA4 },
	0xB5EA, { 0xEB, 0x93, 0xA6 },
	0xB5EB, { 0xEB, 0x93, 0xAC },
	0xB5EC, { 0xEB, 0x93, 0xAD },
	0xB5ED, { 0xEB, 0x93, 0xAF },
	0xB5EE, { 0xEB, 0x93, 0xB1 },
	0xB5EF, { 0xEB, 0x93, 0xB8 },
	0xB5F0, { 0xEB, 0x94, 0x94 },
	0xB5F1, { 0xEB, 0x94, 0x95 },
	0xB5F2, { 0xEB, 0x94, 0x98 },
	0xB5F3, { 0xEB, 0x94, 0x9B },
	0xB5F4, { 0xEB, 0x94, 0x9C },
	0xB5F5, { 0xEB, 0x94, 0xA4 },
	0xB5F6, { 0xEB, 0x94, 0xA5 },
	0xB5F7, { 0xEB, 0x94, 0xA7 },
	0xB5F8, { 0xEB, 0x94, 0xA8 },
	0xB5F9, { 0xEB, 0x94, 0xA9 },
	0xB5FA, { 0xEB, 0x94, 0xAA },
	0xB5FB, { 0xEB, 0x94, 0xB0 },
	0xB5FC, { 0xEB, 0x94, 0xB1 },
	0xB5FD, { 0xEB, 0x94, 0xB4 },
	0xB5FE, { 0xEB, 0x94, 0xB8 },
	0xB641, { 0xED, 0x84, 0x85 },
	0xB642, { 0xED, 0x84, 0x86 },
	0xB643, { 0xED, 0x84, 0x87 },
	0xB644, { 0xED, 0x84, 0x88 },
	0xB645, { 0xED, 0x84, 0x89 },
	0xB646, { 0xED, 0x84, 0x8A },
	0xB647, { 0xED, 0x84, 0x8B },
	0xB648, { 0xED, 0x84, 0x8C },
	0xB649, { 0xED, 0x84, 0x8E },
	0xB64A, { 0xED, 0x84, 0x8F },
	0xB64B, { 0xED, 0x84, 0x90 },
	0xB64C, { 0xED, 0x84, 0x91 },
	0xB64D, { 0xED, 0x84, 0x92 },
	0xB64E, { 0xED, 0x84, 0x93 },
	0xB64F, { 0xED, 0x84, 0x94 },
	0xB650, { 0xED, 0x84, 0x95 },
	0xB651, { 0xED, 0x84, 0x96 },
	0xB652, { 0xED, 0x84, 0x97 },
	0xB653, { 0xED, 0x84, 0x98 },
	0xB654, { 0xED, 0x84, 0x99 },
	0xB655, { 0xED, 0x84, 0x9A },
	0xB656, { 0xED, 0x84, 0x9B },
	0xB657, { 0xED, 0x84, 0x9C },
	0xB658, { 0xED, 0x84, 0x9D },
	0xB659, { 0xED, 0x84, 0x9E },
	0xB65A, { 0xED, 0x84, 0x9F },
	0xB661, { 0xED, 0x84, 0xA0 },
	0xB662, { 0xED, 0x84, 0xA1 },
	0xB663, { 0xED, 0x84, 0xA2 },
	0xB664, { 0xED, 0x84, 0xA3 },
	0xB665, { 0xED, 0x84, 0xA4 },
	0xB666, { 0xED, 0x84, 0xA5 },
	0xB667, { 0xED, 0x84, 0xA6 },
	0xB668, { 0xED, 0x84, 0xA7 },
	0xB669, { 0xED, 0x84, 0xA8 },
	0xB66A, { 0xED, 0x84, 0xA9 },
	0xB66B, { 0xED, 0x84, 0xAA },
	0xB66C, { 0xED, 0x84, 0xAB },
	0xB66D, { 0xED, 0x84, 0xAC },
	0xB66E, { 0xED, 0x84, 0xAD },
	0xB66F, { 0xED, 0x84, 0xAE },
	0xB670, { 0xED, 0x84, 0xAF },
	0xB671, { 0xED, 0x84, 0xB2 },
	0xB672, { 0xED, 0x84, 0xB3 },
	0xB673, { 0xED, 0x84, 0xB5 },
	0xB674, { 0xED, 0x84, 0xB6 },
	0xB675, { 0xED, 0x84, 0xB7 },
	0xB676, { 0xED, 0x84, 0xB9 },
	0xB677, { 0xED, 0x84, 0xBB },
	0xB678, { 0xED, 0x84, 0xBC },
	0xB679, { 0xED, 0x84, 0xBD },
	0xB67A, { 0xED, 0x84, 0xBE },
	0xB681, { 0xED, 0x84, 0xBF },
	0xB682, { 0xED, 0x85, 0x82 },
	0xB683, { 0xED, 0x85, 0x86 },
	0xB684, { 0xED, 0x85, 0x87 },
	0xB685, { 0xED, 0x85, 0x88 },
	0xB686, { 0xED, 0x85, 0x89 },
	0xB687, { 0xED, 0x85, 0x8A },
	0xB688, { 0xED, 0x85, 0x8B },
	0xB689, { 0xED, 0x85, 0x8E },
	0xB68A, { 0xED, 0x85, 0x8F },
	0xB68B, { 0xED, 0x85, 0x91 },
	0xB68C, { 0xED, 0x85, 0x92 },
	0xB68D, { 0xED, 0x85, 0x93 },
	0xB68E, { 0xED, 0x85, 0x95 },
	0xB68F, { 0xED, 0x85, 0x96 },
	0xB690, { 0xED, 0x85, 0x97 },
	0xB691, { 0xED, 0x85, 0x98 },
	0xB692, { 0xED, 0x85, 0x99 },
	0xB693, { 0xED, 0x85, 0x9A },
	0xB694, { 0xED, 0x85, 0x9B },
	0xB695, { 0xED, 0x85, 0x9E },
	0xB696, { 0xED, 0x85, 0xA0 },
	0xB697, { 0xED, 0x85, 0xA2 },
	0xB698, { 0xED, 0x85, 0xA3 },
	0xB699, { 0xED, 0x85, 0xA4 },
	0xB69A, { 0xED, 0x85, 0xA5 },
	0xB69B, { 0xED, 0x85, 0xA6 },
	0xB69C, { 0xED, 0x85, 0xA7 },
	0xB69D, { 0xED, 0x85, 0xA9 },
	0xB69E, { 0xED, 0x85, 0xAA },
	0xB69F, { 0xED, 0x85, 0xAB },
	0xB6A0, { 0xED, 0x85, 0xAD },
	0xB6A1, { 0xEB, 0x95, 0x80 },
	0xB6A2, { 0xEB, 0x95, 0x81 },
	0xB6A3, { 0xEB, 0x95, 0x83 },
	0xB6A4, { 0xEB, 0x95, 0x84 },
	0xB6A5, { 0xEB, 0x95, 0x85 },
	0xB6A6, { 0xEB, 0x95, 0x8B },
	0xB6A7, { 0xEB, 0x95, 0x8C },
	0xB6A8, { 0xEB, 0x95, 0x8D },
	0xB6A9, { 0xEB, 0x95, 0x90 },
	0xB6AA, { 0xEB, 0x95, 0x94 },
	0xB6AB, { 0xEB, 0x95, 0x9C },
	0xB6AC, { 0xEB, 0x95, 0x9D },
	0xB6AD, { 0xEB, 0x95, 0x9F },
	0xB6AE, { 0xEB, 0x95, 0xA0 },
	0xB6AF, { 0xEB, 0x95, 0xA1 },
	0xB6B0, { 0xEB, 0x96, 0xA0 },
	0xB6B1, { 0xEB, 0x96, 0xA1 },
	0xB6B2, { 0xEB, 0x96, 0xA4 },
	0xB6B3, { 0xEB, 0x96, 0xA8 },
	0xB6B4, { 0xEB, 0x96, 0xAA },
	0xB6B5, { 0xEB, 0x96, 0xAB },
	0xB6B6, { 0xEB, 0x96, 0xB0 },
	0xB6B7, { 0xEB, 0x96, 0xB1 },
	0xB6B8, { 0xEB, 0x96, 0xB3 },
	0xB6B9, { 0xEB, 0x96, 0xB4 },
	0xB6BA, { 0xEB, 0x96, 0xB5 },
	0xB6BB, { 0xEB, 0x96, 0xBB },
	0xB6BC, { 0xEB, 0x96, 0xBC },
	0xB6BD, { 0xEB, 0x96, 0xBD },
	0xB6BE, { 0xEB, 0x97, 0x80 },
	0xB6BF, { 0xEB, 0x97, 0x84 },
	0xB6C0, { 0xEB, 0x97, 0x8C },
	0xB6C1, { 0xEB, 0x97, 0x8D },
	0xB6C2, { 0xEB, 0x97, 0x8F },
	0xB6C3, { 0xEB, 0x97, 0x90 },
	0xB6C4, { 0xEB, 0x97, 0x91 },
	0xB6C5, { 0xEB, 0x97, 0x98 },
	0xB6C6, { 0xEB, 0x97, 0xAC },
	0xB6C7, { 0xEB, 0x98, 0x90 },
	0xB6C8, { 0xEB, 0x98, 0x91 },
	0xB6C9, { 0xEB, 0x98, 0x94 },
	0xB6CA, { 0xEB, 0x98, 0x98 },
	0xB6CB, { 0xEB, 0x98, 0xA5 },
	0xB6CC, { 0xEB, 0x98, 0xAC },
	0xB6CD, { 0xEB, 0x98, 0xB4 },
	0xB6CE, { 0xEB, 0x99, 0x88 },
	0xB6CF, { 0xEB, 0x99, 0xA4 },
	0xB6D0, { 0xEB, 0x99, 0xA8 },
	0xB6D1, { 0xEB, 0x9A, 0x9C },
	0xB6D2, { 0xEB, 0x9A, 0x9D },
	0xB6D3, { 0xEB, 0x9A, 0xA0 },
	0xB6D4, { 0xEB, 0x9A, 0xA4 },
	0xB6D5, { 0xEB, 0x9A, 0xAB },
	0xB6D6, { 0xEB, 0x9A, 0xAC },
	0xB6D7, { 0xEB, 0x9A, 0xB1 },
	0xB6D8, { 0xEB, 0x9B, 0x94 },
	0xB6D9, { 0xEB, 0x9B, 0xB0 },
	0xB6DA, { 0xEB, 0x9B, 0xB4 },
	0xB6DB, { 0xEB, 0x9B, 0xB8 },
	0xB6DC, { 0xEB, 0x9C, 0x80 },
	0xB6DD, { 0xEB, 0x9C, 0x81 },
	0xB6DE, { 0xEB, 0x9C, 0x85 },
	0xB6DF, { 0xEB, 0x9C, 0xA8 },
	0xB6E0, { 0xEB, 0x9C, 0xA9 },
	0xB6E1, { 0xEB, 0x9C, 0xAC },
	0xB6E2, { 0xEB, 0x9C, 0xAF },
	0xB6E3, { 0xEB, 0x9C, 0xB0 },
	0xB6E4, { 0xEB, 0x9C, 0xB8 },
	0xB6E5, { 0xEB, 0x9C, 0xB9 },
	0xB6E6, { 0xEB, 0x9C, 0xBB },
	0xB6E7, { 0xEB, 0x9D, 0x84 },
	0xB6E8, { 0xEB, 0x9D, 0x88 },
	0xB6E9, { 0xEB, 0x9D, 0x8C },
	0xB6EA, { 0xEB, 0x9D, 0x94 },
	0xB6EB, { 0xEB, 0x9D, 0x95 },
	0xB6EC, { 0xEB, 0x9D, 0xA0 },
	0xB6ED, { 0xEB, 0x9D, 0xA4 },
	0xB6EE, { 0xEB, 0x9D, 0xA8 },
	0xB6EF, { 0xEB, 0x9D, 0xB0 },
	0xB6F0, { 0xEB, 0x9D, 0xB1 },
	0xB6F1, { 0xEB, 0x9D, 0xB3 },
	0xB6F2, { 0xEB, 0x9D, 0xB5 },
	0xB6F3, { 0xEB, 0x9D, 0xBC },
	0xB6F4, { 0xEB, 0x9D, 0xBD },
	0xB6F5, { 0xEB, 0x9E, 0x80 },
	0xB6F6, { 0xEB, 0x9E, 0x84 },
	0xB6F7, { 0xEB, 0x9E, 0x8C },
	0xB6F8, { 0xEB, 0x9E, 0x8D },
	0xB6F9, { 0xEB, 0x9E, 0x8F },
	0xB6FA, { 0xEB, 0x9E, 0x90 },
	0xB6FB, { 0xEB, 0x9E, 0x91 },
	0xB6FC, { 0xEB, 0x9E, 0x92 },
	0xB6FD, { 0xEB, 0x9E, 0x96 },
	0xB6FE, { 0xEB, 0x9E, 0x97 },
	0xB741, { 0xED, 0x85, 0xAE },
	0xB742, { 0xED, 0x85, 0xAF },
	0xB743, { 0xED, 0x85, 0xB0 },
	0xB744, { 0xED, 0x85, 0xB1 },
	0xB745, { 0xED, 0x85, 0xB2 },
	0xB746, { 0xED, 0x85, 0xB3 },
	0xB747, { 0xED, 0x85, 0xB4 },
	0xB748, { 0xED, 0x85, 0xB5 },
	0xB749, { 0xED, 0x85, 0xB6 },
	0xB74A, { 0xED, 0x85, 0xB7 },
	0xB74B, { 0xED, 0x85, 0xB8 },
	0xB74C, { 0xED, 0x85, 0xB9 },
	0xB74D, { 0xED, 0x85, 0xBA },
	0xB74E, { 0xED, 0x85, 0xBB },
	0xB74F, { 0xED, 0x85, 0xBD },
	0xB750, { 0xED, 0x85, 0xBE },
	0xB751, { 0xED, 0x85, 0xBF },
	0xB752, { 0xED, 0x86, 0x80 },
	0xB753, { 0xED, 0x86, 0x81 },
	0xB754, { 0xED, 0x86, 0x82 },
	0xB755, { 0xED, 0x86, 0x83 },
	0xB756, { 0xED, 0x86, 0x85 },
	0xB757, { 0xED, 0x86, 0x86 },
	0xB758, { 0xED, 0x86, 0x87 },
	0xB759, { 0xED, 0x86, 0x89 },
	0xB75A, { 0xED, 0x86, 0x8A },
	0xB761, { 0xED, 0x86, 0x8B },
	0xB762, { 0xED, 0x86, 0x8C },
	0xB763, { 0xED, 0x86, 0x8D },
	0xB764, { 0xED, 0x86, 0x8E },
	0xB765, { 0xED, 0x86, 0x8F },
	0xB766, { 0xED, 0x86, 0x90 },
	0xB767, { 0xED, 0x86, 0x91 },
	0xB768, { 0xED, 0x86, 0x92 },
	0xB769, { 0xED, 0x86, 0x93 },
	0xB76A, { 0xED, 0x86, 0x94 },
	0xB76B, { 0xED, 0x86, 0x95 },
	0xB76C, { 0xED, 0x86, 0x96 },
	0xB76D, { 0xED, 0x86, 0x97 },
	0xB76E, { 0xED, 0x86, 0x98 },
	0xB76F, { 0xED, 0x86, 0x99 },
	0xB770, { 0xED, 0x86, 0x9A },
	0xB771, { 0xED, 0x86, 0x9B },
	0xB772, { 0xED, 0x86, 0x9C },
	0xB773, { 0xED, 0x86, 0x9D },
	0xB774, { 0xED, 0x86, 0x9E },
	0xB775, { 0xED, 0x86, 0x9F },
	0xB776, { 0xED, 0x86, 0xA2 },
	0xB777, { 0xED, 0x86, 0xA3 },
	0xB778, { 0xED, 0x86, 0xA5 },
	0xB779, { 0xED, 0x86, 0xA6 },
	0xB77A, { 0xED, 0x86, 0xA7 },
	0xB781, { 0xED, 0x86, 0xA9 },
	0xB782, { 0xED, 0x86, 0xAA },
	0xB783, { 0xED, 0x86, 0xAB },
	0xB784, { 0xED, 0x86, 0xAC },
	0xB785, { 0xED, 0x86, 0xAD },
	0xB786, { 0xED, 0x86, 0xAE },
	0xB787, { 0xED, 0x86, 0xAF },
	0xB788, { 0xED, 0x86, 0xB2 },
	0xB789, { 0xED, 0x86, 0xB4 },
	0xB78A, { 0xED, 0x86, 0xB6 },
	0xB78B, { 0xED, 0x86, 0xB7 },
	0xB78C, { 0xED, 0x86, 0xB8 },
	0xB78D, { 0xED, 0x86, 0xB9 },
	0xB78E, { 0xED, 0x86, 0xBB },
	0xB78F, { 0xED, 0x86, 0xBD },
	0xB790, { 0xED, 0x86, 0xBE },
	0xB791, { 0xED, 0x86, 0xBF },
	0xB792, { 0xED, 0x87, 0x81 },
	0xB793, { 0xED, 0x87, 0x82 },
	0xB794, { 0xED, 0x87, 0x83 },
	0xB795, { 0xED, 0x87, 0x84 },
	0xB796, { 0xED, 0x87, 0x85 },
	0xB797, { 0xED, 0x87, 0x86 },
	0xB798, { 0xED, 0x87, 0x87 },
	0xB799, { 0xED, 0x87, 0x88 },
	0xB79A, { 0xED, 0x87, 0x89 },
	0xB79B, { 0xED, 0x87, 0x8A },
	0xB79C, { 0xED, 0x87, 0x8B },
	0xB79D, { 0xED, 0x87, 0x8C },
	0xB79E, { 0xED, 0x87, 0x8D },
	0xB79F, { 0xED, 0x87, 0x8E },
	0xB7A0, { 0xED, 0x87, 0x8F },
	0xB7A1, { 0xEB, 0x9E, 0x98 },
	0xB7A2, { 0xEB, 0x9E, 0x99 },
	0xB7A3, { 0xEB, 0x9E, 0x9C },
	0xB7A4, { 0xEB, 0x9E, 0xA0 },
	0xB7A5, { 0xEB, 0x9E, 0xA8 },
	0xB7A6, { 0xEB, 0x9E, 0xA9 },
	0xB7A7, { 0xEB, 0x9E, 0xAB },
	0xB7A8, { 0xEB, 0x9E, 0xAC },
	0xB7A9, { 0xEB, 0x9E, 0xAD },
	0xB7AA, { 0xEB, 0x9E, 0xB4 },
	0xB7AB, { 0xEB, 0x9E, 0xB5 },
	0xB7AC, { 0xEB, 0x9E, 0xB8 },
	0xB7AD, { 0xEB, 0x9F, 0x87 },
	0xB7AE, { 0xEB, 0x9F, 0x89 },
	0xB7AF, { 0xEB, 0x9F, 0xAC },
	0xB7B0, { 0xEB, 0x9F, 0xAD },
	0xB7B1, { 0xEB, 0x9F, 0xB0 },
	0xB7B2, { 0xEB, 0x9F, 0xB4 },
	0xB7B3, { 0xEB, 0x9F, 0xBC },
	0xB7B4, { 0xEB, 0x9F, 0xBD },
	0xB7B5, { 0xEB, 0x9F, 0xBF },
	0xB7B6, { 0xEB, 0xA0, 0x80 },
	0xB7B7, { 0xEB, 0xA0, 0x81 },
	0xB7B8, { 0xEB, 0xA0, 0x87 },
	0xB7B9, { 0xEB, 0xA0, 0x88 },
	0xB7BA, { 0xEB, 0xA0, 0x89 },
	0xB7BB, { 0xEB, 0xA0, 0x8C },
	0xB7BC, { 0xEB, 0xA0, 0x90 },
	0xB7BD, { 0xEB, 0xA0, 0x98 },
	0xB7BE, { 0xEB, 0xA0, 0x99 },
	0xB7BF, { 0xEB, 0xA0, 0x9B },
	0xB7C0, { 0xEB, 0xA0, 0x9D },
	0xB7C1, { 0xEB, 0xA0, 0xA4 },
	0xB7C2, { 0xEB, 0xA0, 0xA5 },
	0xB7C3, { 0xEB, 0xA0, 0xA8 },
	0xB7C4, { 0xEB, 0xA0, 0xAC },
	0xB7C5, { 0xEB, 0xA0, 0xB4 },
	0xB7C6, { 0xEB, 0xA0, 0xB5 },
	0xB7C7, { 0xEB, 0xA0, 0xB7 },
	0xB7C8, { 0xEB, 0xA0, 0xB8 },
	0xB7C9, { 0xEB, 0xA0, 0xB9 },
	0xB7CA, { 0xEB, 0xA1, 0x80 },
	0xB7CB, { 0xEB, 0xA1, 0x84 },
	0xB7CC, { 0xEB, 0xA1, 0x91 },
	0xB7CD, { 0xEB, 0xA1, 0x93 },
	0xB7CE, { 0xEB, 0xA1, 0x9C },
	0xB7CF, { 0xEB, 0xA1, 0x9D },
	0xB7D0, { 0xEB, 0xA1, 0xA0 },
	0xB7D1, { 0xEB, 0xA1, 0xA4 },
	0xB7D2, { 0xEB, 0xA1, 0xAC },
	0xB7D3, { 0xEB, 0xA1, 0xAD },
	0xB7D4, { 0xEB, 0xA1, 0xAF },
	0xB7D5, { 0xEB, 0xA1, 0xB1 },
	0xB7D6, { 0xEB, 0xA1, 0xB8 },
	0xB7D7, { 0xEB, 0xA1, 0xBC },
	0xB7D8, { 0xEB, 0xA2, 0x8D },
	0xB7D9, { 0xEB, 0xA2, 0xA8 },
	0xB7DA, { 0xEB, 0xA2, 0xB0 },
	0xB7DB, { 0xEB, 0xA2, 0xB4 },
	0xB7DC, { 0xEB, 0xA2, 0xB8 },
	0xB7DD, { 0xEB, 0xA3, 0x80 },
	0xB7DE, { 0xEB, 0xA3, 0x81 },
	0xB7DF, { 0xEB, 0xA3, 0x83 },
	0xB7E0, { 0xEB, 0xA3, 0x85 },
	0xB7E1, { 0xEB, 0xA3, 0x8C },
	0xB7E2, { 0xEB, 0xA3, 0x90 },
	0xB7E3, { 0xEB, 0xA3, 0x94 },
	0xB7E4, { 0xEB, 0xA3, 0x9D },
	0xB7E5, { 0xEB, 0xA3, 0x9F },
	0xB7E6, { 0xEB, 0xA3, 0xA1 },
	0xB7E7, { 0xEB, 0xA3, 0xA8 },
	0xB7E8, { 0xEB, 0xA3, 0xA9 },
	0xB7E9, { 0xEB, 0xA3, 0xAC },
	0xB7EA, { 0xEB, 0xA3, 0xB0 },
	0xB7EB, { 0xEB, 0xA3, 0xB8 },
	0xB7EC, { 0xEB, 0xA3, 0xB9 },
	0xB7ED, { 0xEB, 0xA3, 0xBB },
	0xB7EE, { 0xEB, 0xA3, 0xBD },
	0xB7EF, { 0xEB, 0xA4, 0x84 },
	0xB7F0, { 0xEB, 0xA4, 0x98 },
	0xB7F1, { 0xEB, 0xA4, 0xA0 },
	0xB7F2, { 0xEB, 0xA4, 0xBC },
	0xB7F3, { 0xEB, 0xA4, 0xBD },
	0xB7F4, { 0xEB, 0xA5, 0x80 },
	0xB7F5, { 0xEB, 0xA5, 0x84 },
	0xB7F6, { 0xEB, 0xA5, 0x8C },
	0xB7F7, { 0xEB, 0xA5, 0x8F },
	0xB7F8, { 0xEB, 0xA5, 0x91 },
	0xB7F9, { 0xEB, 0xA5, 0x98 },
	0xB7FA, { 0xEB, 0xA5, 0x99 },
	0xB7FB, { 0xEB, 0xA5, 0x9C },
	0xB7FC, { 0xEB, 0xA5, 0xA0 },
	0xB7FD, { 0xEB, 0xA5, 0xA8 },
	0xB7FE, { 0xEB, 0xA5, 0xA9 },
	0xB841, { 0xED, 0x87, 0x90 },
	0xB842, { 0xED, 0x87, 0x91 },
	0xB843, { 0xED, 0x87, 0x92 },
	0xB844, { 0xED, 0x87, 0x93 },
	0xB845, { 0xED, 0x87, 0x94 },
	0xB846, { 0xED, 0x87, 0x95 },
	0xB847, { 0xED, 0x87, 0x96 },
	0xB848, { 0xED, 0x87, 0x97 },
	0xB849, { 0xED, 0x87, 0x99 },
	0xB84A, { 0xED, 0x87, 0x9A },
	0xB84B, { 0xED, 0x87, 0x9B },
	0xB84C, { 0xED, 0x87, 0x9C },
	0xB84D, { 0xED, 0x87, 0x9D },
	0xB84E, { 0xED, 0x87, 0x9E },
	0xB84F, { 0xED, 0x87, 0x9F },
	0xB850, { 0xED, 0x87, 0xA0 },
	0xB851, { 0xED, 0x87, 0xA1 },
	0xB852, { 0xED, 0x87, 0xA2 },
	0xB853, { 0xED, 0x87, 0xA3 },
	0xB854, { 0xED, 0x87, 0xA4 },
	0xB855, { 0xED, 0x87, 0xA5 },
	0xB856, { 0xED, 0x87, 0xA6 },
	0xB857, { 0xED, 0x87, 0xA7 },
	0xB858, { 0xED, 0x87, 0xA8 },
	0xB859, { 0xED, 0x87, 0xA9 },
	0xB85A, { 0xED, 0x87, 0xAA },
	0xB861, { 0xED, 0x87, 0xAB },
	0xB862, { 0xED, 0x87, 0xAC },
	0xB863, { 0xED, 0x87, 0xAD },
	0xB864, { 0xED, 0x87, 0xAE },
	0xB865, { 0xED, 0x87, 0xAF },
	0xB866, { 0xED, 0x87, 0xB0 },
	0xB867, { 0xED, 0x87, 0xB1 },
	0xB868, { 0xED, 0x87, 0xB2 },
	0xB869, { 0xED, 0x87, 0xB3 },
	0xB86A, { 0xED, 0x87, 0xB5 },
	0xB86B, { 0xED, 0x87, 0xB6 },
	0xB86C, { 0xED, 0x87, 0xB7 },
	0xB86D, { 0xED, 0x87, 0xB9 },
	0xB86E, { 0xED, 0x87, 0xBA },
	0xB86F, { 0xED, 0x87, 0xBB },
	0xB870, { 0xED, 0x87, 0xBC },
	0xB871, { 0xED, 0x87, 0xBD },
	0xB872, { 0xED, 0x87, 0xBE },
	0xB873, { 0xED, 0x87, 0xBF },
	0xB874, { 0xED, 0x88, 0x80 },
	0xB875, { 0xED, 0x88, 0x81 },
	0xB876, { 0xED, 0x88, 0x82 },
	0xB877, { 0xED, 0x88, 0x83 },
	0xB878, { 0xED, 0x88, 0x84 },
	0xB879, { 0xED, 0x88, 0x85 },
	0xB87A, { 0xED, 0x88, 0x86 },
	0xB881, { 0xED, 0x88, 0x88 },
	0xB882, { 0xED, 0x88, 0x8A },
	0xB883, { 0xED, 0x88, 0x8B },
	0xB884, { 0xED, 0x88, 0x8C },
	0xB885, { 0xED, 0x88, 0x8D },
	0xB886, { 0xED, 0x88, 0x8E },
	0xB887, { 0xED, 0x88, 0x8F },
	0xB888, { 0xED, 0x88, 0x91 },
	0xB889, { 0xED, 0x88, 0x92 },
	0xB88A, { 0xED, 0x88, 0x93 },
	0xB88B, { 0xED, 0x88, 0x94 },
	0xB88C, { 0xED, 0x88, 0x95 },
	0xB88D, { 0xED, 0x88, 0x96 },
	0xB88E, { 0xED, 0x88, 0x97 },
	0xB88F, { 0xED, 0x88, 0x98 },
	0xB890, { 0xED, 0x88, 0x99 },
	0xB891, { 0xED, 0x88, 0x9A },
	0xB892, { 0xED, 0x88, 0x9B },
	0xB893, { 0xED, 0x88, 0x9C },
	0xB894, { 0xED, 0x88, 0x9D },
	0xB895, { 0xED, 0x88, 0x9E },
	0xB896, { 0xED, 0x88, 0x9F },
	0xB897, { 0xED, 0x88, 0xA0 },
	0xB898, { 0xED, 0x88, 0xA1 },
	0xB899, { 0xED, 0x88, 0xA2 },
	0xB89A, { 0xED, 0x88, 0xA3 },
	0xB89B, { 0xED, 0x88, 0xA4 },
	0xB89C, { 0xED, 0x88, 0xA5 },
	0xB89D, { 0xED, 0x88, 0xA6 },
	0xB89E, { 0xED, 0x88, 0xA7 },
	0xB89F, { 0xED, 0x88, 0xA8 },
	0xB8A0, { 0xED, 0x88, 0xA9 },
	0xB8A1, { 0xEB, 0xA5, 0xAB },
	0xB8A2, { 0xEB, 0xA5, 0xAD },
	0xB8A3, { 0xEB, 0xA5, 0xB4 },
	0xB8A4, { 0xEB, 0xA5, 0xB5 },
	0xB8A5, { 0xEB, 0xA5, 0xB8 },
	0xB8A6, { 0xEB, 0xA5, 0xBC },
	0xB8A7, { 0xEB, 0xA6, 0x84 },
	0xB8A8, { 0xEB, 0xA6, 0x85 },
	0xB8A9, { 0xEB, 0xA6, 0x87 },
	0xB8AA, { 0xEB, 0xA6, 0x89 },
	0xB8AB, { 0xEB, 0xA6, 0x8A },
	0xB8AC, { 0xEB, 0xA6, 0x8D },
	0xB8AD, { 0xEB, 0xA6, 0x8E },
	0xB8AE, { 0xEB, 0xA6, 0xAC },
	0xB8AF, { 0xEB, 0xA6, 0xAD },
	0xB8B0, { 0xEB, 0xA6, 0xB0 },
	0xB8B1, { 0xEB, 0xA6, 0xB4 },
	0xB8B2, { 0xEB, 0xA6, 0xBC },
	0xB8B3, { 0xEB, 0xA6, 0xBD },
	0xB8B4, { 0xEB, 0xA6, 0xBF },
	0xB8B5, { 0xEB, 0xA7, 0x81 },
	0xB8B6, { 0xEB, 0xA7, 0x88 },
	0xB8B7, { 0xEB, 0xA7, 0x89 },
	0xB8B8, { 0xEB, 0xA7, 0x8C },
	0xB8B9, { 0xEB, 0xA7, 0x8E },
	0xB8BA, { 0xEB, 0xA7, 0x8F },
	0xB8BB, { 0xEB, 0xA7, 0x90 },
	0xB8BC, { 0xEB, 0xA7, 0x91 },
	0xB8BD, { 0xEB, 0xA7, 0x92 },
	0xB8BE, { 0xEB, 0xA7, 0x98 },
	0xB8BF, { 0xEB, 0xA7, 0x99 },
	0xB8C0, { 0xEB, 0xA7, 0x9B },
	0xB8C1, { 0xEB, 0xA7, 0x9D },
	0xB8C2, { 0xEB, 0xA7, 0x9E },
	0xB8C3, { 0xEB, 0xA7, 0xA1 },
	0xB8C4, { 0xEB, 0xA7, 0xA3 },
	0xB8C5, { 0xEB, 0xA7, 0xA4 },
	0xB8C6, { 0xEB, 0xA7, 0xA5 },
	0xB8C7, { 0xEB, 0xA7, 0xA8 },
	0xB8C8, { 0xEB, 0xA7, 0xAC },
	0xB8C9, { 0xEB, 0xA7, 0xB4 },
	0xB8CA, { 0xEB, 0xA7, 0xB5 },
	0xB8CB, { 0xEB, 0xA7, 0xB7 },
	0xB8CC, { 0xEB, 0xA7, 0xB8 },
	0xB8CD, { 0xEB, 0xA7, 0xB9 },
	0xB8CE, { 0xEB, 0xA7, 0xBA },
	0xB8CF, { 0xEB, 0xA8, 0x80 },
	0xB8D0, { 0xEB, 0xA8, 0x81 },
	0xB8D1, { 0xEB, 0xA8, 0x88 },
	0xB8D2, { 0xEB, 0xA8, 0x95 },
	0xB8D3, { 0xEB, 0xA8, 0xB8 },
	0xB8D4, { 0xEB, 0xA8, 0xB9 },
	0xB8D5, { 0xEB, 0xA8, 0xBC },
	0xB8D6, { 0xEB, 0xA9, 0x80 },
	0xB8D7, { 0xEB, 0xA9, 0x82 },
	0xB8D8, { 0xEB, 0xA9, 0x88 },
	0xB8D9, { 0xEB, 0xA9, 0x89 },
	0xB8DA, { 0xEB, 0xA9, 0x8B },
	0xB8DB, { 0xEB, 0xA9, 0x8D },
	0xB8DC, { 0xEB, 0xA9, 0x8E },
	0xB8DD, { 0xEB, 0xA9, 0x93 },
	0xB8DE, { 0xEB, 0xA9, 0x94 },
	0xB8DF, { 0xEB, 0xA9, 0x95 },
	0xB8E0, { 0xEB, 0xA9, 0x98 },
	0xB8E1, { 0xEB, 0xA9, 0x9C },
	0xB8E2, { 0xEB, 0xA9, 0xA4 },
	0xB8E3, { 0xEB, 0xA9, 0xA5 },
	0xB8E4, { 0xEB, 0xA9, 0xA7 },
	0xB8E5, { 0xEB, 0xA9, 0xA8 },
	0xB8E6, { 0xEB, 0xA9, 0xA9 },
	0xB8E7, { 0xEB, 0xA9, 0xB0 },
	0xB8E8, { 0xEB, 0xA9, 0xB1 },
	0xB8E9, { 0xEB, 0xA9, 0xB4 },
	0xB8EA, { 0xEB, 0xA9, 0xB8 },
	0xB8EB, { 0xEB, 0xAA, 0x83 },
	0xB8EC, { 0xEB, 0xAA, 0x84 },
	0xB8ED, { 0xEB, 0xAA, 0x85 },
	0xB8EE, { 0xEB, 0xAA, 0x87 },
	0xB8EF, { 0xEB, 0xAA, 0x8C },
	0xB8F0, { 0xEB, 0xAA, 0xA8 },
	0xB8F1, { 0xEB, 0xAA, 0xA9 },
	0xB8F2, { 0xEB, 0xAA, 0xAB },
	0xB8F3, { 0xEB, 0xAA, 0xAC },
	0xB8F4, { 0xEB, 0xAA, 0xB0 },
	0xB8F5, { 0xEB, 0xAA, 0xB2 },
	0xB8F6, { 0xEB, 0xAA, 0xB8 },
	0xB8F7, { 0xEB, 0xAA, 0xB9 },
	0xB8F8, { 0xEB, 0xAA, 0xBB },
	0xB8F9, { 0xEB, 0xAA, 0xBD },
	0xB8FA, { 0xEB, 0xAB, 0x84 },
	0xB8FB, { 0xEB, 0xAB, 0x88 },
	0xB8FC, { 0xEB, 0xAB, 0x98 },
	0xB8FD, { 0xEB, 0xAB, 0x99 },
	0xB8FE, { 0xEB, 0xAB, 0xBC },
	0xB941, { 0xED, 0x88, 0xAA },
	0xB942, { 0xED, 0x88, 0xAB },
	0xB943, { 0xED, 0x88, 0xAE },
	0xB944, { 0xED, 0x88, 0xAF },
	0xB945, { 0xED, 0x88, 0xB1 },
	0xB946, { 0xED, 0x88, 0xB2 },
	0xB947, { 0xED, 0x88, 0xB3 },
	0xB948, { 0xED, 0x88, 0xB5 },
	0xB949, { 0xED, 0x88, 0xB6 },
	0xB94A, { 0xED, 0x88, 0xB7 },
	0xB94B, { 0xED, 0x88, 0xB8 },
	0xB94C, { 0xED, 0x88, 0xB9 },
	0xB94D, { 0xED, 0x88, 0xBA },
	0xB94E, { 0xED, 0x88, 0xBB },
	0xB94F, { 0xED, 0x88, 0xBE },
	0xB950, { 0xED, 0x89, 0x80 },
	0xB951, { 0xED, 0x89, 0x82 },
	0xB952, { 0xED, 0x89, 0x83 },
	0xB953, { 0xED, 0x89, 0x84 },
	0xB954, { 0xED, 0x89, 0x85 },
	0xB955, { 0xED, 0x89, 0x86 },
	0xB956, { 0xED, 0x89, 0x87 },
	0xB957, { 0xED, 0x89, 0x89 },
	0xB958, { 0xED, 0x89, 0x8A },
	0xB959, { 0xED, 0x89, 0x8B },
	0xB95A, { 0xED, 0x89, 0x8C },
	0xB961, { 0xED, 0x89, 0x8D },
	0xB962, { 0xED, 0x89, 0x8E },
	0xB963, { 0xED, 0x89, 0x8F },
	0xB964, { 0xED, 0x89, 0x90 },
	0xB965, { 0xED, 0x89, 0x91 },
	0xB966, { 0xED, 0x89, 0x92 },
	0xB967, { 0xED, 0x89, 0x93 },
	0xB968, { 0xED, 0x89, 0x94 },
	0xB969, { 0xED, 0x89, 0x95 },
	0xB96A, { 0xED, 0x89, 0x96 },
	0xB96B, { 0xED, 0x89, 0x97 },
	0xB96C, { 0xED, 0x89, 0x98 },
	0xB96D, { 0xED, 0x89, 0x99 },
	0xB96E, { 0xED, 0x89, 0x9A },
	0xB96F, { 0xED, 0x89, 0x9B },
	0xB970, { 0xED, 0x89, 0x9D },
	0xB971, { 0xED, 0x89, 0x9E },
	0xB972, { 0xED, 0x89, 0x9F },
	0xB973, { 0xED, 0x89, 0xA0 },
	0xB974, { 0xED, 0x89, 0xA1 },
	0xB975, { 0xED, 0x89, 0xA2 },
	0xB976, { 0xED, 0x89, 0xA3 },
	0xB977, { 0xED, 0x89, 0xA5 },
	0xB978, { 0xED, 0x89, 0xA6 },
	0xB979, { 0xED, 0x89, 0xA7 },
	0xB97A, { 0xED, 0x89, 0xA8 },
	0xB981, { 0xED, 0x89, 0xA9 },
	0xB982, { 0xED, 0x89, 0xAA },
	0xB983, { 0xED, 0x89, 0xAB },
	0xB984, { 0xED, 0x89, 0xAC },
	0xB985, { 0xED, 0x89, 0xAD },
	0xB986, { 0xED, 0x89, 0xAE },
	0xB987, { 0xED, 0x89, 0xAF },
	0xB988, { 0xED, 0x89, 0xB0 },
	0xB989, { 0xED, 0x89, 0xB1 },
	0xB98A, { 0xED, 0x89, 0xB2 },
	0xB98B, { 0xED, 0x89, 0xB3 },
	0xB98C, { 0xED, 0x89, 0xB4 },
	0xB98D, { 0xED, 0x89, 0xB5 },
	0xB98E, { 0xED, 0x89, 0xB6 },
	0xB98F, { 0xED, 0x89, 0xB7 },
	0xB990, { 0xED, 0x89, 0xB8 },
	0xB991, { 0xED, 0x89, 0xB9 },
	0xB992, { 0xED, 0x89, 0xBA },
	0xB993, { 0xED, 0x89, 0xBB },
	0xB994, { 0xED, 0x89, 0xBC },
	0xB995, { 0xED, 0x89, 0xBD },
	0xB996, { 0xED, 0x89, 0xBE },
	0xB997, { 0xED, 0x89, 0xBF },
	0xB998, { 0xED, 0x8A, 0x82 },
	0xB999, { 0xED, 0x8A, 0x83 },
	0xB99A, { 0xED, 0x8A, 0x85 },
	0xB99B, { 0xED, 0x8A, 0x86 },
	0xB99C, { 0xED, 0x8A, 0x87 },
	0xB99D, { 0xED, 0x8A, 0x89 },
	0xB99E, { 0xED, 0x8A, 0x8A },
	0xB99F, { 0xED, 0x8A, 0x8B },
	0xB9A0, { 0xED, 0x8A, 0x8C },
	0xB9A1, { 0xEB, 0xAC, 0x80 },
	0xB9A2, { 0xEB, 0xAC, 0x84 },
	0xB9A3, { 0xEB, 0xAC, 0x8D },
	0xB9A4, { 0xEB, 0xAC, 0x8F },
	0xB9A5, { 0xEB, 0xAC, 0x91 },
	0xB9A6, { 0xEB, 0xAC, 0x98 },
	0xB9A7, { 0xEB, 0xAC, 0x9C },
	0xB9A8, { 0xEB, 0xAC, 0xA0 },
	0xB9A9, { 0xEB, 0xAC, 0xA9 },
	0xB9AA, { 0xEB, 0xAC, 0xAB },
	0xB9AB, { 0xEB, 0xAC, 0xB4 },
	0xB9AC, { 0xEB, 0xAC, 0xB5 },
	0xB9AD, { 0xEB, 0xAC, 0xB6 },
	0xB9AE, { 0xEB, 0xAC, 0xB8 },
	0xB9AF, { 0xEB, 0xAC, 0xBB },
	0xB9B0, { 0xEB, 0xAC, 0xBC },
	0xB9B1, { 0xEB, 0xAC, 0xBD },
	0xB9B2, { 0xEB, 0xAC, 0xBE },
	0xB9B3, { 0xEB, 0xAD, 0x84 },
	0xB9B4, { 0xEB, 0xAD, 0x85 },
	0xB9B5, { 0xEB, 0xAD, 0x87 },
	0xB9B6, { 0xEB, 0xAD, 0x89 },
	0xB9B7, { 0xEB, 0xAD, 0x8D },
	0xB9B8, { 0xEB, 0xAD, 0x8F },
	0xB9B9, { 0xEB, 0xAD, 0x90 },
	0xB9BA, { 0xEB, 0xAD, 0x94 },
	0xB9BB, { 0xEB, 0xAD, 0x98 },
	0xB9BC, { 0xEB, 0xAD, 0xA1 },
	0xB9BD, { 0xEB, 0xAD, 0xA3 },
	0xB9BE, { 0xEB, 0xAD, 0xAC },
	0xB9BF, { 0xEB, 0xAE, 0x88 },
	0xB9C0, { 0xEB, 0xAE, 0x8C },
	0xB9C1, { 0xEB, 0xAE, 0x90 },
	0xB9C2, { 0xEB, 0xAE, 0xA4 },
	0xB9C3, { 0xEB, 0xAE, 0xA8 },
	0xB9C4, { 0xEB, 0xAE, 0xAC },
	0xB9C5, { 0xEB, 0xAE, 0xB4 },
	0xB9C6, { 0xEB, 0xAE, 0xB7 },
	0xB9C7, { 0xEB, 0xAF, 0x80 },
	0xB9C8, { 0xEB, 0xAF, 0x84 },
	0xB9C9, { 0xEB, 0xAF, 0x88 },
	0xB9CA, { 0xEB, 0xAF, 0x90 },
	0xB9CB, { 0xEB, 0xAF, 0x93 },
	0xB9CC, { 0xEB, 0xAF, 0xB8 },
	0xB9CD, { 0xEB, 0xAF, 0xB9 },
	0xB9CE, { 0xEB, 0xAF, 0xBC },
	0xB9CF, { 0xEB, 0xAF, 0xBF },
	0xB9D0, { 0xEB, 0xB0, 0x80 },
	0xB9D1, { 0xEB, 0xB0, 0x82 },
	0xB9D2, { 0xEB, 0xB0, 0x88 },
	0xB9D3, { 0xEB, 0xB0, 0x89 },
	0xB9D4, { 0xEB, 0xB0, 0x8B },
	0xB9D5, { 0xEB, 0xB0, 0x8C },
	0xB9D6, { 0xEB, 0xB0, 0x8D },
	0xB9D7, { 0xEB, 0xB0, 0x8F },
	0xB9D8, { 0xEB, 0xB0, 0x91 },
	0xB9D9, { 0xEB, 0xB0, 0x94 },
	0xB9DA, { 0xEB, 0xB0, 0x95 },
	0xB9DB, { 0xEB, 0xB0, 0x96 },
	0xB9DC, { 0xEB, 0xB0, 0x97 },
	0xB9DD, { 0xEB, 0xB0, 0x98 },
	0xB9DE, { 0xEB, 0xB0, 0x9B },
	0xB9DF, { 0xEB, 0xB0, 0x9C },
	0xB9E0, { 0xEB, 0xB0, 0x9D },
	0xB9E1, { 0xEB, 0xB0, 0x9E },
	0xB9E2, { 0xEB, 0xB0, 0x9F },
	0xB9E3, { 0xEB, 0xB0, 0xA4 },
	0xB9E4, { 0xEB, 0xB0, 0xA5 },
	0xB9E5, { 0xEB, 0xB0, 0xA7 },
	0xB9E6, { 0xEB, 0xB0, 0xA9 },
	0xB9E7, { 0xEB, 0xB0, 0xAD },
	0xB9E8, { 0xEB, 0xB0, 0xB0 },
	0xB9E9, { 0xEB, 0xB0, 0xB1 },
	0xB9EA, { 0xEB, 0xB0, 0xB4 },
	0xB9EB, { 0xEB, 0xB0, 0xB8 },
	0xB9EC, { 0xEB, 0xB1, 0x80 },
	0xB9ED, { 0xEB, 0xB1, 0x81 },
	0xB9EE, { 0xEB, 0xB1, 0x83 },
	0xB9EF, { 0xEB, 0xB1, 0x84 },
	0xB9F0, { 0xEB, 0xB1, 0x85 },
	0xB9F1, { 0xEB, 0xB1, 0x89 },
	0xB9F2, { 0xEB, 0xB1, 0x8C },
	0xB9F3, { 0xEB, 0xB1, 0x8D },
	0xB9F4, { 0xEB, 0xB1, 0x90 },
	0xB9F5, { 0xEB, 0xB1, 0x9D },
	0xB9F6, { 0xEB, 0xB2, 0x84 },
	0xB9F7, { 0xEB, 0xB2, 0x85 },
	0xB9F8, { 0xEB, 0xB2, 0x88 },
	0xB9F9, { 0xEB, 0xB2, 0x8B },
	0xB9FA, { 0xEB, 0xB2, 0x8C },
	0xB9FB, { 0xEB, 0xB2, 0x8E },
	0xB9FC, { 0xEB, 0xB2, 0x94 },
	0xB9FD, { 0xEB, 0xB2, 0x95 },
	0xB9FE, { 0xEB, 0xB2, 0x97 },
	0xBA41, { 0xED, 0x8A, 0x8D },
	0xBA42, { 0xED, 0x8A, 0x8E },
	0xBA43, { 0xED, 0x8A, 0x8F },
	0xBA44, { 0xED, 0x8A, 0x92 },
	0xBA45, { 0xED, 0x8A, 0x93 },
	0xBA46, { 0xED, 0x8A, 0x94 },
	0xBA47, { 0xED, 0x8A, 0x96 },
	0xBA48, { 0xED, 0x8A, 0x97 },
	0xBA49, { 0xED, 0x8A, 0x98 },
	0xBA4A, { 0xED, 0x8A, 0x99 },
	0xBA4B, { 0xED, 0x8A, 0x9A },
	0xBA4C, { 0xED, 0x8A, 0x9B },
	0xBA4D, { 0xED, 0x8A, 0x9D },
	0xBA4E, { 0xED, 0x8A, 0x9E },
	0xBA4F, { 0xED, 0x8A, 0x9F },
	0xBA50, { 0xED, 0x8A, 0xA1 },
	0xBA51, { 0xED, 0x8A, 0xA2 },
	0xBA52, { 0xED, 0x8A, 0xA3 },
	0xBA53, { 0xED, 0x8A, 0xA5 },
	0xBA54, { 0xED, 0x8A, 0xA6 },
	0xBA55, { 0xED, 0x8A, 0xA7 },
	0xBA56, { 0xED, 0x8A, 0xA8 },
	0xBA57, { 0xED, 0x8A, 0xA9 },
	0xBA58, { 0xED, 0x8A, 0xAA },
	0xBA59, { 0xED, 0x8A, 0xAB },
	0xBA5A, { 0xED, 0x8A, 0xAD },
	0xBA61, { 0xED, 0x8A, 0xAE },
	0xBA62, { 0xED, 0x8A, 0xAF },
	0xBA63, { 0xED, 0x8A, 0xB0 },
	0xBA64, { 0xED, 0x8A, 0xB2 },
	0xBA65, { 0xED, 0x8A, 0xB3 },
	0xBA66, { 0xED, 0x8A, 0xB4 },
	0xBA67, { 0xED, 0x8A, 0xB5 },
	0xBA68, { 0xED, 0x8A, 0xB6 },
	0xBA69, { 0xED, 0x8A, 0xB7 },
	0xBA6A, { 0xED, 0x8A, 0xBA },
	0xBA6B, { 0xED, 0x8A, 0xBB },
	0xBA6C, { 0xED, 0x8A, 0xBD },
	0xBA6D, { 0xED, 0x8A, 0xBE },
	0xBA6E, { 0xED, 0x8B, 0x81 },
	0xBA6F, { 0xED, 0x8B, 0x83 },
	0xBA70, { 0xED, 0x8B, 0x84 },
	0xBA71, { 0xED, 0x8B, 0x85 },
	0xBA72, { 0xED, 0x8B, 0x86 },
	0xBA73, { 0xED, 0x8B, 0x87 },
	0xBA74, { 0xED, 0x8B, 0x8A },
	0xBA75, { 0xED, 0x8B, 0x8C },
	0xBA76, { 0xED, 0x8B, 0x8D },
	0xBA77, { 0xED, 0x8B, 0x8E },
	0xBA78, { 0xED, 0x8B, 0x8F },
	0xBA79, { 0xED, 0x8B, 0x90 },
	0xBA7A, { 0xED, 0x8B, 0x91 },
	0xBA81, { 0xED, 0x8B, 0x92 },
	0xBA82, { 0xED, 0x8B, 0x93 },
	0xBA83, { 0xED, 0x8B, 0x95 },
	0xBA84, { 0xED, 0x8B, 0x96 },
	0xBA85, { 0xED, 0x8B, 0x97 },
	0xBA86, { 0xED, 0x8B, 0x99 },
	0xBA87, { 0xED, 0x8B, 0x9A },
	0xBA88, { 0xED, 0x8B, 0x9B },
	0xBA89, { 0xED, 0x8B, 0x9D },
	0xBA8A, { 0xED, 0x8B, 0x9E },
	0xBA8B, { 0xED, 0x8B, 0x9F },
	0xBA8C, { 0xED, 0x8B, 0xA0 },
	0xBA8D, { 0xED, 0x8B, 0xA1 },
	0xBA8E, { 0xED, 0x8B, 0xA2 },
	0xBA8F, { 0xED, 0x8B, 0xA3 },
	0xBA90, { 0xED, 0x8B, 0xA6 },
	0xBA91, { 0xED, 0x8B, 0xA7 },
	0xBA92, { 0xED, 0x8B, 0xA8 },
	0xBA93, { 0xED, 0x8B, 0xA9 },
	0xBA94, { 0xED, 0x8B, 0xAA },
	0xBA95, { 0xED, 0x8B, 0xAB },
	0xBA96, { 0xED, 0x8B, 0xAC },
	0xBA97, { 0xED, 0x8B, 0xAD },
	0xBA98, { 0xED, 0x8B, 0xAE },
	0xBA99, { 0xED, 0x8B, 0xAF },
	0xBA9A, { 0xED, 0x8B, 0xB2 },
	0xBA9B, { 0xED, 0x8B, 0xB3 },
	0xBA9C, { 0xED, 0x8B, 0xB5 },
	0xBA9D, { 0xED, 0x8B, 0xB6 },
	0xBA9E, { 0xED, 0x8B, 0xB7 },
	0xBA9F, { 0xED, 0x8B, 0xB9 },
	0xBAA0, { 0xED, 0x8B, 0xBA },
	0xBAA1, { 0xEB, 0xB2, 0x99 },
	0xBAA2, { 0xEB, 0xB2, 0x9A },
	0xBAA3, { 0xEB, 0xB2, 0xA0 },
	0xBAA4, { 0xEB, 0xB2, 0xA1 },
	0xBAA5, { 0xEB, 0xB2, 0xA4 },
	0xBAA6, { 0xEB, 0xB2, 0xA7 },
	0xBAA7, { 0xEB, 0xB2, 0xA8 },
	0xBAA8, { 0xEB, 0xB2, 0xB0 },
	0xBAA9, { 0xEB, 0xB2, 0xB1 },
	0xBAAA, { 0xEB, 0xB2, 0xB3 },
	0xBAAB, { 0xEB, 0xB2, 0xB4 },
	0xBAAC, { 0xEB, 0xB2, 0xB5 },
	0xBAAD, { 0xEB, 0xB2, 0xBC },
	0xBAAE, { 0xEB, 0xB2, 0xBD },
	0xBAAF, { 0xEB, 0xB3, 0x80 },
	0xBAB0, { 0xEB, 0xB3, 0x84 },
	0xBAB1, { 0xEB, 0xB3, 0x8D },
	0xBAB2, { 0xEB, 0xB3, 0x8F },
	0xBAB3, { 0xEB, 0xB3, 0x90 },
	0xBAB4, { 0xEB, 0xB3, 0x91 },
	0xBAB5, { 0xEB, 0xB3, 0x95 },
	0xBAB6, { 0xEB, 0xB3, 0x98 },
	0xBAB7, { 0xEB, 0xB3, 0x9C },
	0xBAB8, { 0xEB, 0xB3, 0xB4 },
	0xBAB9, { 0xEB, 0xB3, 0xB5 },
	0xBABA, { 0xEB, 0xB3, 0xB6 },
	0xBABB, { 0xEB, 0xB3, 0xB8 },
	0xBABC, { 0xEB, 0xB3, 0xBC },
	0xBABD, { 0xEB, 0xB4, 0x84 },
	0xBABE, { 0xEB, 0xB4, 0x85 },
	0xBABF, { 0xEB, 0xB4, 0x87 },
	0xBAC0, { 0xEB, 0xB4, 0x89 },
	0xBAC1, { 0xEB, 0xB4, 0x90 },
	0xBAC2, { 0xEB, 0xB4, 0x94 },
	0xBAC3, { 0xEB, 0xB4, 0xA4 },
	0xBAC4, { 0xEB, 0xB4, 0xAC },
	0xBAC5, { 0xEB, 0xB5, 0x80 },
	0xBAC6, { 0xEB, 0xB5, 0x88 },
	0xBAC7, { 0xEB, 0xB5, 0x89 },
	0xBAC8, { 0xEB, 0xB5, 0x8C },
	0xBAC9, { 0xEB, 0xB5, 0x90 },
	0xBACA, { 0xEB, 0xB5, 0x98 },
	0xBACB, { 0xEB, 0xB5, 0x99 },
	0xBACC, { 0xEB, 0xB5, 0xA4 },
	0xBACD, { 0xEB, 0xB5, 0xA8 },
	0xBACE, { 0xEB, 0xB6, 0x80 },
	0xBACF, { 0xEB, 0xB6, 0x81 },
	0xBAD0, { 0xEB, 0xB6, 0x84 },
	0xBAD1, { 0xEB, 0xB6, 0x87 },
	0xBAD2, { 0xEB, 0xB6, 0x88 },
	0xBAD3, { 0xEB, 0xB6, 0x89 },
	0xBAD4, { 0xEB, 0xB6, 0x8A },
	0xBAD5, { 0xEB, 0xB6, 0x90 },
	0xBAD6, { 0xEB, 0xB6, 0x91 },
	0xBAD7, { 0xEB, 0xB6, 0x93 },
	0xBAD8, { 0xEB, 0xB6, 0x95 },
	0xBAD9, { 0xEB, 0xB6, 0x99 },
	0xBADA, { 0xEB, 0xB6, 0x9A },
	0xBADB, { 0xEB, 0xB6, 0x9C },
	0xBADC, { 0xEB, 0xB6, 0xA4 },
	0xBADD, { 0xEB, 0xB6, 0xB0 },
	0xBADE, { 0xEB, 0xB6, 0xB8 },
	0xBADF, { 0xEB, 0xB7, 0x94 },
	0xBAE0, { 0xEB, 0xB7, 0x95 },
	0xBAE1, { 0xEB, 0xB7, 0x98 },
	0xBAE2, { 0xEB, 0xB7, 0x9C },
	0xBAE3, { 0xEB, 0xB7, 0xA9 },
	0xBAE4, { 0xEB, 0xB7, 0xB0 },
	0xBAE5, { 0xEB, 0xB7, 0xB4 },
	0xBAE6, { 0xEB, 0xB7, 0xB8 },
	0xBAE7, { 0xEB, 0xB8, 0x80 },
	0xBAE8, { 0xEB, 0xB8, 0x83 },
	0xBAE9, { 0xEB, 0xB8, 0x85 },
	0xBAEA, { 0xEB, 0xB8, 0x8C },
	0xBAEB, { 0xEB, 0xB8, 0x8D },
	0xBAEC, { 0xEB, 0xB8, 0x90 },
	0xBAED, { 0xEB, 0xB8, 0x94 },
	0xBAEE, { 0xEB, 0xB8, 0x9C },
	0xBAEF, { 0xEB, 0xB8, 0x9D },
	0xBAF0, { 0xEB, 0xB8, 0x9F },
	0xBAF1, { 0xEB, 0xB9, 0x84 },
	0xBAF2, { 0xEB, 0xB9, 0x85 },
	0xBAF3, { 0xEB, 0xB9, 0x88 },
	0xBAF4, { 0xEB, 0xB9, 0x8C },
	0xBAF5, { 0xEB, 0xB9, 0x8E },
	0xBAF6, { 0xEB, 0xB9, 0x94 },
	0xBAF7, { 0xEB, 0xB9, 0x95 },
	0xBAF8, { 0xEB, 0xB9, 0x97 },
	0xBAF9, { 0xEB, 0xB9, 0x99 },
	0xBAFA, { 0xEB, 0xB9, 0x9A },
	0xBAFB, { 0xEB, 0xB9, 0x9B },
	0xBAFC, { 0xEB, 0xB9, 0xA0 },
	0xBAFD, { 0xEB, 0xB9, 0xA1 },
	0xBAFE, { 0xEB, 0xB9, 0xA4 },
	0xBB41, { 0xED, 0x8B, 0xBB },
	0xBB42, { 0xED, 0x8B, 0xBC },
	0xBB43, { 0xED, 0x8B, 0xBD },
	0xBB44, { 0xED, 0x8B, 0xBE },
	0xBB45, { 0xED, 0x8B, 0xBF },
	0xBB46, { 0xED, 0x8C, 0x82 },
	0xBB47, { 0xED, 0x8C, 0x84 },
	0xBB48, { 0xED, 0x8C, 0x86 },
	0xBB49, { 0xED, 0x8C, 0x87 },
	0xBB4A, { 0xED, 0x8C, 0x88 },
	0xBB4B, { 0xED, 0x8C, 0x89 },
	0xBB4C, { 0xED, 0x8C, 0x8A },
	0xBB4D, { 0xED, 0x8C, 0x8B },
	0xBB4E, { 0xED, 0x8C, 0x8F },
	0xBB4F, { 0xED, 0x8C, 0x91 },
	0xBB50, { 0xED, 0x8C, 0x92 },
	0xBB51, { 0xED, 0x8C, 0x93 },
	0xBB52, { 0xED, 0x8C, 0x95 },
	0xBB53, { 0xED, 0x8C, 0x97 },
	0xBB54, { 0xED, 0x8C, 0x98 },
	0xBB55, { 0xED, 0x8C, 0x99 },
	0xBB56, { 0xED, 0x8C, 0x9A },
	0xBB57, { 0xED, 0x8C, 0x9B },
	0xBB58, { 0xED, 0x8C, 0x9E },
	0xBB59, { 0xED, 0x8C, 0xA2 },
	0xBB5A, { 0xED, 0x8C, 0xA3 },
	0xBB61, { 0xED, 0x8C, 0xA4 },
	0xBB62, { 0xED, 0x8C, 0xA6 },
	0xBB63, { 0xED, 0x8C, 0xA7 },
	0xBB64, { 0xED, 0x8C, 0xAA },
	0xBB65, { 0xED, 0x8C, 0xAB },
	0xBB66, { 0xED, 0x8C, 0xAD },
	0xBB67, { 0xED, 0x8C, 0xAE },
	0xBB68, { 0xED, 0x8C, 0xAF },
	0xBB69, { 0xED, 0x8C, 0xB1 },
	0xBB6A, { 0xED, 0x8C, 0xB2 },
	0xBB6B, { 0xED, 0x8C, 0xB3 },
	0xBB6C, { 0xED, 0x8C, 0xB4 },
	0xBB6D, { 0xED, 0x8C, 0xB5 },
	0xBB6E, { 0xED, 0x8C, 0xB6 },
	0xBB6F, { 0xED, 0x8C, 0xB7 },
	0xBB70, { 0xED, 0x8C, 0xBA },
	0xBB71, { 0xED, 0x8C, 0xBE },
	0xBB72, { 0xED, 0x8C, 0xBF },
	0xBB73, { 0xED, 0x8D, 0x80 },
	0xBB74, { 0xED, 0x8D, 0x81 },
	0xBB75, { 0xED, 0x8D, 0x82 },
	0xBB76, { 0xED, 0x8D, 0x83 },
	0xBB77, { 0xED, 0x8D, 0x86 },
	0xBB78, { 0xED, 0x8D, 0x87 },
	0xBB79, { 0xED, 0x8D, 0x88 },
	0xBB7A, { 0xED, 0x8D, 0x89 },
	0xBB81, { 0xED, 0x8D, 0x8A },
	0xBB82, { 0xED, 0x8D, 0x8B },
	0xBB83, { 0xED, 0x8D, 0x8C },
	0xBB84, { 0xED, 0x8D, 0x8D },
	0xBB85, { 0xED, 0x8D, 0x8E },
	0xBB86, { 0xED, 0x8D, 0x8F },
	0xBB87, { 0xED, 0x8D, 0x90 },
	0xBB88, { 0xED, 0x8D, 0x91 },
	0xBB89, { 0xED, 0x8D, 0x92 },
	0xBB8A, { 0xED, 0x8D, 0x93 },
	0xBB8B, { 0xED, 0x8D, 0x94 },
	0xBB8C, { 0xED, 0x8D, 0x95 },
	0xBB8D, { 0xED, 0x8D, 0x96 },
	0xBB8E, { 0xED, 0x8D, 0x97 },
	0xBB8F, { 0xED, 0x8D, 0x98 },
	0xBB90, { 0xED, 0x8D, 0x99 },
	0xBB91, { 0xED, 0x8D, 0x9A },
	0xBB92, { 0xED, 0x8D, 0x9B },
	0xBB93, { 0xED, 0x8D, 0x9C },
	0xBB94, { 0xED, 0x8D, 0x9D },
	0xBB95, { 0xED, 0x8D, 0x9E },
	0xBB96, { 0xED, 0x8D, 0x9F },
	0xBB97, { 0xED, 0x8D, 0xA0 },
	0xBB98, { 0xED, 0x8D, 0xA1 },
	0xBB99, { 0xED, 0x8D, 0xA2 },
	0xBB9A, { 0xED, 0x8D, 0xA3 },
	0xBB9B, { 0xED, 0x8D, 0xA4 },
	0xBB9C, { 0xED, 0x8D, 0xA5 },
	0xBB9D, { 0xED, 0x8D, 0xA6 },
	0xBB9E, { 0xED, 0x8D, 0xA7 },
	0xBB9F, { 0xED, 0x8D, 0xA8 },
	0xBBA0, { 0xED, 0x8D, 0xA9 },
	0xBBA1, { 0xEB, 0xB9, 0xA8 },
	0xBBA2, { 0xEB, 0xB9, 0xAA },
	0xBBA3, { 0xEB, 0xB9, 0xB0 },
	0xBBA4, { 0xEB, 0xB9, 0xB1 },
	0xBBA5, { 0xEB, 0xB9, 0xB3 },
	0xBBA6, { 0xEB, 0xB9, 0xB4 },
	0xBBA7, { 0xEB, 0xB9, 0xB5 },
	0xBBA8, { 0xEB, 0xB9, 0xBB },
	0xBBA9, { 0xEB, 0xB9, 0xBC },
	0xBBAA, { 0xEB, 0xB9, 0xBD },
	0xBBAB, { 0xEB, 0xBA, 0x80 },
	0xBBAC, { 0xEB, 0xBA, 0x84 },
	0xBBAD, { 0xEB, 0xBA, 0x8C },
	0xBBAE, { 0xEB, 0xBA, 0x8D },
	0xBBAF, { 0xEB, 0xBA, 0x8F },
	0xBBB0, { 0xEB, 0xBA, 0x90 },
	0xBBB1, { 0xEB, 0xBA, 0x91 },
	0xBBB2, { 0xEB, 0xBA, 0x98 },
	0xBBB3, { 0xEB, 0xBA, 0x99 },
	0xBBB4, { 0xEB, 0xBA, 0xA8 },
	0xBBB5, { 0xEB, 0xBB, 0x90 },
	0xBBB6, { 0xEB, 0xBB, 0x91 },
	0xBBB7, { 0xEB, 0xBB, 0x94 },
	0xBBB8, { 0xEB, 0xBB, 0x97 },
	0xBBB9, { 0xEB, 0xBB, 0x98 },
	0xBBBA, { 0xEB, 0xBB, 0xA0 },
	0xBBBB, { 0xEB, 0xBB, 0xA3 },
	0xBBBC, { 0xEB, 0xBB, 0xA4 },
	0xBBBD, { 0xEB, 0xBB, 0xA5 },
	0xBBBE, { 0xEB, 0xBB, 0xAC },
	0xBBBF, { 0xEB, 0xBC, 0x81 },
	0xBBC0, { 0xEB, 0xBC, 0x88 },
	0xBBC1, { 0xEB, 0xBC, 0x89 },
	0xBBC2, { 0xEB, 0xBC, 0x98 },
	0xBBC3, { 0xEB, 0xBC, 0x99 },
	0xBBC4, { 0xEB, 0xBC, 0x9B },
	0xBBC5, { 0xEB, 0xBC, 0x9C },
	0xBBC6, { 0xEB, 0xBC, 0x9D },
	0xBBC7, { 0xEB, 0xBD, 0x80 },
	0xBBC8, { 0xEB, 0xBD, 0x81 },
	0xBBC9, { 0xEB, 0xBD, 0x84 },
	0xBBCA, { 0xEB, 0xBD, 0x88 },
	0xBBCB, { 0xEB, 0xBD, 0x90 },
	0xBBCC, { 0xEB, 0xBD, 0x91 },
	0xBBCD, { 0xEB, 0xBD, 0x95 },
	0xBBCE, { 0xEB, 0xBE, 0x94 },
	0xBBCF, { 0xEB, 0xBE, 0xB0 },
	0xBBD0, { 0xEB, 0xBF, 0x85 },
	0xBBD1, { 0xEB, 0xBF, 0x8C },
	0xBBD2, { 0xEB, 0xBF, 0x8D },
	0xBBD3, { 0xEB, 0xBF, 0x90 },
	0xBBD4, { 0xEB, 0xBF, 0x94 },
	0xBBD5, { 0xEB, 0xBF, 0x9C },
	0xBBD6, { 0xEB, 0xBF, 0x9F },
	0xBBD7, { 0xEB, 0xBF, 0xA1 },
	0xBBD8, { 0xEC, 0x80, 0xBC },
	0xBBD9, { 0xEC, 0x81, 0x91 },
	0xBBDA, { 0xEC, 0x81, 0x98 },
	0xBBDB, { 0xEC, 0x81, 0x9C },
	0xBBDC, { 0xEC, 0x81, 0xA0 },
	0xBBDD, { 0xEC, 0x81, 0xA8 },
	0xBBDE, { 0xEC, 0x81, 0xA9 },
	0xBBDF, { 0xEC, 0x82, 0x90 },
	0xBBE0, { 0xEC, 0x82, 0x91 },
	0xBBE1, { 0xEC, 0x82, 0x94 },
	0xBBE2, { 0xEC, 0x82, 0x98 },
	0xBBE3, { 0xEC, 0x82, 0xA0 },
	0xBBE4, { 0xEC, 0x82, 0xA1 },
	0xBBE5, { 0xEC, 0x82, 0xA3 },
	0xBBE6, { 0xEC, 0x82, 0xA5 },
	0xBBE7, { 0xEC, 0x82, 0xAC },
	0xBBE8, { 0xEC, 0x82, 0xAD },
	0xBBE9, { 0xEC, 0x82, 0xAF },
	0xBBEA, { 0xEC, 0x82, 0xB0 },
	0xBBEB, { 0xEC, 0x82, 0xB3 },
	0xBBEC, { 0xEC, 0x82, 0xB4 },
	0xBBED, { 0xEC, 0x82, 0xB5 },
	0xBBEE, { 0xEC, 0x82, 0xB6 },
	0xBBEF, { 0xEC, 0x82, 0xBC },
	0xBBF0, { 0xEC, 0x82, 0xBD },
	0xBBF1, { 0xEC, 0x82, 0xBF },
	0xBBF2, { 0xEC, 0x83, 0x80 },
	0xBBF3, { 0xEC, 0x83, 0x81 },
	0xBBF4, { 0xEC, 0x83, 0x85 },
	0xBBF5, { 0xEC, 0x83, 0x88 },
	0xBBF6, { 0xEC, 0x83, 0x89 },
	0xBBF7, { 0xEC, 0x83, 0x8C },
	0xBBF8, { 0xEC, 0x83, 0x90 },
	0xBBF9, { 0xEC, 0x83, 0x98 },
	0xBBFA, { 0xEC, 0x83, 0x99 },
	0xBBFB, { 0xEC, 0x83, 0x9B },
	0xBBFC, { 0xEC, 0x83, 0x9C },
	0xBBFD, { 0xEC, 0x83, 0x9D },
	0xBBFE, { 0xEC, 0x83, 0xA4 },
	0xBC41, { 0xED, 0x8D, 0xAA },
	0xBC42, { 0xED, 0x8D, 0xAB },
	0xBC43, { 0xED, 0x8D, 0xAC },
	0xBC44, { 0xED, 0x8D, 0xAD },
	0xBC45, { 0xED, 0x8D, 0xAE },
	0xBC46, { 0xED, 0x8D, 0xAF },
	0xBC47, { 0xED, 0x8D, 0xB0 },
	0xBC48, { 0xED, 0x8D, 0xB1 },
	0xBC49, { 0xED, 0x8D, 0xB2 },
	0xBC4A, { 0xED, 0x8D, 0xB3 },
	0xBC4B, { 0xED, 0x8D, 0xB4 },
	0xBC4C, { 0xED, 0x8D, 0xB5 },
	0xBC4D, { 0xED, 0x8D, 0xB6 },
	0xBC4E, { 0xED, 0x8D, 0xB7 },
	0xBC4F, { 0xED, 0x8D, 0xB8 },
	0xBC50, { 0xED, 0x8D, 0xB9 },
	0xBC51, { 0xED, 0x8D, 0xBA },
	0xBC52, { 0xED, 0x8D, 0xBB },
	0xBC53, { 0xED, 0x8D, 0xBE },
	0xBC54, { 0xED, 0x8D, 0xBF },
	0xBC55, { 0xED, 0x8E, 0x81 },
	0xBC56, { 0xED, 0x8E, 0x82 },
	0xBC57, { 0xED, 0x8E, 0x83 },
	0xBC58, { 0xED, 0x8E, 0x85 },
	0xBC59, { 0xED, 0x8E, 0x86 },
	0xBC5A, { 0xED, 0x8E, 0x87 },
	0xBC61, { 0xED, 0x8E, 0x88 },
	0xBC62, { 0xED, 0x8E, 0x89 },
	0xBC63, { 0xED, 0x8E, 0x8A },
	0xBC64, { 0xED, 0x8E, 0x8B },
	0xBC65, { 0xED, 0x8E, 0x8E },
	0xBC66, { 0xED, 0x8E, 0x92 },
	0xBC67, { 0xED, 0x8E, 0x93 },
	0xBC68, { 0xED, 0x8E, 0x94 },
	0xBC69, { 0xED, 0x8E, 0x95 },
	0xBC6A, { 0xED, 0x8E, 0x96 },
	0xBC6B, { 0xED, 0x8E, 0x97 },
	0xBC6C, { 0xED, 0x8E, 0x9A },
	0xBC6D, { 0xED, 0x8E, 0x9B },
	0xBC6E, { 0xED, 0x8E, 0x9D },
	0xBC6F, { 0xED, 0x8E, 0x9E },
	0xBC70, { 0xED, 0x8E, 0x9F },
	0xBC71, { 0xED, 0x8E, 0xA1 },
	0xBC72, { 0xED, 0x8E, 0xA2 },
	0xBC73, { 0xED, 0x8E, 0xA3 },
	0xBC74, { 0xED, 0x8E, 0xA4 },
	0xBC75, { 0xED, 0x8E, 0xA5 },
	0xBC76, { 0xED, 0x8E, 0xA6 },
	0xBC77, { 0xED, 0x8E, 0xA7 },
	0xBC78, { 0xED, 0x8E, 0xAA },
	0xBC79, { 0xED, 0x8E, 0xAC },
	0xBC7A, { 0xED, 0x8E, 0xAE },
	0xBC81, { 0xED, 0x8E, 0xAF },
	0xBC82, { 0xED, 0x8E, 0xB0 },
	0xBC83, { 0xED, 0x8E, 0xB1 },
	0xBC84, { 0xED, 0x8E, 0xB2 },
	0xBC85, { 0xED, 0x8E, 0xB3 },
	0xBC86, { 0xED, 0x8E, 0xB5 },
	0xBC87, { 0xED, 0x8E, 0xB6 },
	0xBC88, { 0xED, 0x8E, 0xB7 },
	0xBC89, { 0xED, 0x8E, 0xB9 },
	0xBC8A, { 0xED, 0x8E, 0xBA },
	0xBC8B, { 0xED, 0x8E, 0xBB },
	0xBC8C, { 0xED, 0x8E, 0xBD },
	0xBC8D, { 0xED, 0x8E, 0xBE },
	0xBC8E, { 0xED, 0x8E, 0xBF },
	0xBC8F, { 0xED, 0x8F, 0x80 },
	0xBC90, { 0xED, 0x8F, 0x81 },
	0xBC91, { 0xED, 0x8F, 0x82 },
	0xBC92, { 0xED, 0x8F, 0x83 },
	0xBC93, { 0xED, 0x8F, 0x86 },
	0xBC94, { 0xED, 0x8F, 0x87 },
	0xBC95, { 0xED, 0x8F, 0x8A },
	0xBC96, { 0xED, 0x8F, 0x8B },
	0xBC97, { 0xED, 0x8F, 0x8C },
	0xBC98, { 0xED, 0x8F, 0x8D },
	0xBC99, { 0xED, 0x8F, 0x8E },
	0xBC9A, { 0xED, 0x8F, 0x8F },
	0xBC9B, { 0xED, 0x8F, 0x91 },
	0xBC9C, { 0xED, 0x8F, 0x92 },
	0xBC9D, { 0xED, 0x8F, 0x93 },
	0xBC9E, { 0xED, 0x8F, 0x94 },
	0xBC9F, { 0xED, 0x8F, 0x95 },
	0xBCA0, { 0xED, 0x8F, 0x96 },
	0xBCA1, { 0xEC, 0x83, 0xA5 },
	0xBCA2, { 0xEC, 0x83, 0xA8 },
	0xBCA3, { 0xEC, 0x83, 0xAC },
	0xBCA4, { 0xEC, 0x83, 0xB4 },
	0xBCA5, { 0xEC, 0x83, 0xB5 },
	0xBCA6, { 0xEC, 0x83, 0xB7 },
	0xBCA7, { 0xEC, 0x83, 0xB9 },
	0xBCA8, { 0xEC, 0x84, 0x80 },
	0xBCA9, { 0xEC, 0x84, 0x84 },
	0xBCAA, { 0xEC, 0x84, 0x88 },
	0xBCAB, { 0xEC, 0x84, 0x90 },
	0xBCAC, { 0xEC, 0x84, 0x95 },
	0xBCAD, { 0xEC, 0x84, 0x9C },
	0xBCAE, { 0xEC, 0x84, 0x9D },
	0xBCAF, { 0xEC, 0x84, 0x9E },
	0xBCB0, { 0xEC, 0x84, 0x9F },
	0xBCB1, { 0xEC, 0x84, 0xA0 },
	0xBCB2, { 0xEC, 0x84, 0xA3 },
	0xBCB3, { 0xEC, 0x84, 0xA4 },
	0xBCB4, { 0xEC, 0x84, 0xA6 },
	0xBCB5, { 0xEC, 0x84, 0xA7 },
	0xBCB6, { 0xEC, 0x84, 0xAC },
	0xBCB7, { 0xEC, 0x84, 0xAD },
	0xBCB8, { 0xEC, 0x84, 0xAF },
	0xBCB9, { 0xEC, 0x84, 0xB0 },
	0xBCBA, { 0xEC, 0x84, 0xB1 },
	0xBCBB, { 0xEC, 0x84, 0xB6 },
	0xBCBC, { 0xEC, 0x84, 0xB8 },
	0xBCBD, { 0xEC, 0x84, 0xB9 },
	0xBCBE, { 0xEC, 0x84, 0xBC },
	0xBCBF, { 0xEC, 0x85, 0x80 },
	0xBCC0, { 0xEC, 0x85, 0x88 },
	0xBCC1, { 0xEC, 0x85, 0x89 },
	0xBCC2, { 0xEC, 0x85, 0x8B },
	0xBCC3, { 0xEC, 0x85, 0x8C },
	0xBCC4, { 0xEC, 0x85, 0x8D },
	0xBCC5, { 0xEC, 0x85, 0x94 },
	0xBCC6, { 0xEC, 0x85, 0x95 },
	0xBCC7, { 0xEC, 0x85, 0x98 },
	0xBCC8, { 0xEC, 0x85, 0x9C },
	0xBCC9, { 0xEC, 0x85, 0xA4 },
	0xBCCA, { 0xEC, 0x85, 0xA5 },
	0xBCCB, { 0xEC, 0x85, 0xA7 },
	0xBCCC, { 0xEC, 0x85, 0xA8 },
	0xBCCD, { 0xEC, 0x85, 0xA9 },
	0xBCCE, { 0xEC, 0x85, 0xB0 },
	0xBCCF, { 0xEC, 0x85, 0xB4 },
	0xBCD0, { 0xEC, 0x85, 0xB8 },
	0xBCD1, { 0xEC, 0x86, 0x85 },
	0xBCD2, { 0xEC, 0x86, 0x8C },
	0xBCD3, { 0xEC, 0x86, 0x8D },
	0xBCD4, { 0xEC, 0x86, 0x8E },
	0xBCD5, { 0xEC, 0x86, 0x90 },
	0xBCD6, { 0xEC, 0x86, 0x94 },
	0xBCD7, { 0xEC, 0x86, 0x96 },
	0xBCD8, { 0xEC, 0x86, 0x9C },
	0xBCD9, { 0xEC, 0x86, 0x9D },
	0xBCDA, { 0xEC, 0x86, 0x9F },
	0xBCDB, { 0xEC, 0x86, 0xA1 },
	0xBCDC, { 0xEC, 0x86, 0xA5 },
	0xBCDD, { 0xEC, 0x86, 0xA8 },
	0xBCDE, { 0xEC, 0x86, 0xA9 },
	0xBCDF, { 0xEC, 0x86, 0xAC },
	0xBCE0, { 0xEC, 0x86, 0xB0 },
	0xBCE1, { 0xEC, 0x86, 0xBD },
	0xBCE2, { 0xEC, 0x87, 0x84 },
	0xBCE3, { 0xEC, 0x87, 0x88 },
	0xBCE4, { 0xEC, 0x87, 0x8C },
	0xBCE5, { 0xEC, 0x87, 0x94 },
	0xBCE6, { 0xEC, 0x87, 0x97 },
	0xBCE7, { 0xEC, 0x87, 0x98 },
	0xBCE8, { 0xEC, 0x87, 0xA0 },
	0xBCE9, { 0xEC, 0x87, 0xA4 },
	0xBCEA, { 0xEC, 0x87, 0xA8 },
	0xBCEB, { 0xEC, 0x87, 0xB0 },
	0xBCEC, { 0xEC, 0x87, 0xB1 },
	0xBCED, { 0xEC, 0x87, 0xB3 },
	0xBCEE, { 0xEC, 0x87, 0xBC },
	0xBCEF, { 0xEC, 0x87, 0xBD },
	0xBCF0, { 0xEC, 0x88, 0x80 },
	0xBCF1, { 0xEC, 0x88, 0x84 },
	0xBCF2, { 0xEC, 0x88, 0x8C },
	0xBCF3, { 0xEC, 0x88, 0x8D },
	0xBCF4, { 0xEC, 0x88, 0x8F },
	0xBCF5, { 0xEC, 0x88, 0x91 },
	0xBCF6, { 0xEC, 0x88, 0x98 },
	0xBCF7, { 0xEC, 0x88, 0x99 },
	0xBCF8, { 0xEC, 0x88, 0x9C },
	0xBCF9, { 0xEC, 0x88, 0x9F },
	0xBCFA, { 0xEC, 0x88, 0xA0 },
	0xBCFB, { 0xEC, 0x88, 0xA8 },
	0xBCFC, { 0xEC, 0x88, 0xA9 },
	0xBCFD, { 0xEC, 0x88, 0xAB },
	0xBCFE, { 0xEC, 0x88, 0xAD },
	0xBD41, { 0xED, 0x8F, 0x97 },
	0xBD42, { 0xED, 0x8F, 0x99 },
	0xBD43, { 0xED, 0x8F, 0x9A },
	0xBD44, { 0xED, 0x8F, 0x9B },
	0xBD45, { 0xED, 0x8F, 0x9C },
	0xBD46, { 0xED, 0x8F, 0x9D },
	0xBD47, { 0xED, 0x8F, 0x9E },
	0xBD48, { 0xED, 0x8F, 0x9F },
	0xBD49, { 0xED, 0x8F, 0xA0 },
	0xBD4A, { 0xED, 0x8F, 0xA2 },
	0xBD4B, { 0xED, 0x8F, 0xA4 },
	0xBD4C, { 0xED, 0x8F, 0xA5 },
	0xBD4D, { 0xED, 0x8F, 0xA6 },
	0xBD4E, { 0xED, 0x8F, 0xA7 },
	0xBD4F, { 0xED, 0x8F, 0xA8 },
	0xBD50, { 0xED, 0x8F, 0xA9 },
	0xBD51, { 0xED, 0x8F, 0xAA },
	0xBD52, { 0xED, 0x8F, 0xAB },
	0xBD53, { 0xED, 0x8F, 0xAE },
	0xBD54, { 0xED, 0x8F, 0xAF },
	0xBD55, { 0xED, 0x8F, 0xB1 },
	0xBD56, { 0xED, 0x8F, 0xB2 },
	0xBD57, { 0xED, 0x8F, 0xB3 },
	0xBD58, { 0xED, 0x8F, 0xB5 },
	0xBD59, { 0xED, 0x8F, 0xB6 },
	0xBD5A, { 0xED, 0x8F, 0xB7 },
	0xBD61, { 0xED, 0x8F, 0xB8 },
	0xBD62, { 0xED, 0x8F, 0xB9 },
	0xBD63, { 0xED, 0x8F, 0xBA },
	0xBD64, { 0xED, 0x8F, 0xBB },
	0xBD65, { 0xED, 0x8F, 0xBE },
	0xBD66, { 0xED, 0x90, 0x80 },
	0xBD67, { 0xED, 0x90, 0x82 },
	0xBD68, { 0xED, 0x90, 0x83 },
	0xBD69, { 0xED, 0x90, 0x84 },
	0xBD6A, { 0xED, 0x90, 0x85 },
	0xBD6B, { 0xED, 0x90, 0x86 },
	0xBD6C, { 0xED, 0x90, 0x87 },
	0xBD6D, { 0xED, 0x90, 0x89 },
	0xBD6E, { 0xED, 0x90, 0x8A },
	0xBD6F, { 0xED, 0x90, 0x8B },
	0xBD70, { 0xED, 0x90, 0x8C },
	0xBD71, { 0xED, 0x90, 0x8D },
	0xBD72, { 0xED, 0x90, 0x8E },
	0xBD73, { 0xED, 0x90, 0x8F },
	0xBD74, { 0xED, 0x90, 0x90 },
	0xBD75, { 0xED, 0x90, 0x91 },
	0xBD76, { 0xED, 0x90, 0x92 },
	0xBD77, { 0xED, 0x90, 0x93 },
	0xBD78, { 0xED, 0x90, 0x94 },
	0xBD79, { 0xED, 0x90, 0x95 },
	0xBD7A, { 0xED, 0x90, 0x96 },
	0xBD81, { 0xED, 0x90, 0x97 },
	0xBD82, { 0xED, 0x90, 0x98 },
	0xBD83, { 0xED, 0x90, 0x99 },
	0xBD84, { 0xED, 0x90, 0x9A },
	0xBD85, { 0xED, 0x90, 0x9B },
	0xBD86, { 0xED, 0x90, 0x9C },
	0xBD87, { 0xED, 0x90, 0x9E },
	0xBD88, { 0xED, 0x90, 0x9F },
	0xBD89, { 0xED, 0x90, 0xA0 },
	0xBD8A, { 0xED, 0x90, 0xA1 },
	0xBD8B, { 0xED, 0x90, 0xA2 },
	0xBD8C, { 0xED, 0x90, 0xA3 },
	0xBD8D, { 0xED, 0x90, 0xA4 },
	0xBD8E, { 0xED, 0x90, 0xA5 },
	0xBD8F, { 0xED, 0x90, 0xA6 },
	0xBD90, { 0xED, 0x90, 0xA7 },
	0xBD91, { 0xED, 0x90, 0xA8 },
	0xBD92, { 0xED, 0x90, 0xA9 },
	0xBD93, { 0xED, 0x90, 0xAA },
	0xBD94, { 0xED, 0x90, 0xAB },
	0xBD95, { 0xED, 0x90, 0xAC },
	0xBD96, { 0xED, 0x90, 0xAD },
	0xBD97, { 0xED, 0x90, 0xAE },
	0xBD98, { 0xED, 0x90, 0xAF },
	0xBD99, { 0xED, 0x90, 0xB0 },
	0xBD9A, { 0xED, 0x90, 0xB1 },
	0xBD9B, { 0xED, 0x90, 0xB2 },
	0xBD9C, { 0xED, 0x90, 0xB3 },
	0xBD9D, { 0xED, 0x90, 0xB4 },
	0xBD9E, { 0xED, 0x90, 0xB5 },
	0xBD9F, { 0xED, 0x90, 0xB6 },
	0xBDA0, { 0xED, 0x90, 0xB7 },
	0xBDA1, { 0xEC, 0x88, 0xAF },
	0xBDA2, { 0xEC, 0x88, 0xB1 },
	0xBDA3, { 0xEC, 0x88, 0xB2 },
	0xBDA4, { 0xEC, 0x88, 0xB4 },
	0xBDA5, { 0xEC, 0x89, 0x88 },
	0xBDA6, { 0xEC, 0x89, 0x90 },
	0xBDA7, { 0xEC, 0x89, 0x91 },
	0xBDA8, { 0xEC, 0x89, 0x94 },
	0xBDA9, { 0xEC, 0x89, 0x98 },
	0xBDAA, { 0xEC, 0x89, 0xA0 },
	0xBDAB, { 0xEC, 0x89, 0xA5 },
	0xBDAC, { 0xEC, 0x89, 0xAC },
	0xBDAD, { 0xEC, 0x89, 0xAD },
	0xBDAE, { 0xEC, 0x89, 0xB0 },
	0xBDAF, { 0xEC, 0x89, 0xB4 },
	0xBDB0, { 0xEC, 0x89, 0xBC },
	0xBDB1, { 0xEC, 0x89, 0xBD },
	0xBDB2, { 0xEC, 0x89, 0xBF },
	0xBDB3, { 0xEC, 0x8A, 0x81 },
	0xBDB4, { 0xEC, 0x8A, 0x88 },
	0xBDB5, { 0xEC, 0x8A, 0x89 },
	0xBDB6, { 0xEC, 0x8A, 0x90 },
	0xBDB7, { 0xEC, 0x8A, 0x98 },
	0xBDB8, { 0xEC, 0x8A, 0x9B },
	0xBDB9, { 0xEC, 0x8A, 0x9D },
	0xBDBA, { 0xEC, 0x8A, 0xA4 },
	0xBDBB, { 0xEC, 0x8A, 0xA5 },
	0xBDBC, { 0xEC, 0x8A, 0xA8 },
	0xBDBD, { 0xEC, 0x8A, 0xAC },
	0xBDBE, { 0xEC, 0x8A, 0xAD },
	0xBDBF, { 0xEC, 0x8A, 0xB4 },
	0xBDC0, { 0xEC, 0x8A, 0xB5 },
	0xBDC1, { 0xEC, 0x8A, 0xB7 },
	0xBDC2, { 0xEC, 0x8A, 0xB9 },
	0xBDC3, { 0xEC, 0x8B, 0x9C },
	0xBDC4, { 0xEC, 0x8B, 0x9D },
	0xBDC5, { 0xEC, 0x8B, 0xA0 },
	0xBDC6, { 0xEC, 0x8B, 0xA3 },
	0xBDC7, { 0xEC, 0x8B, 0xA4 },
	0xBDC8, { 0xEC, 0x8B, 0xAB },
	0xBDC9, { 0xEC, 0x8B, 0xAC },
	0xBDCA, { 0xEC, 0x8B, 0xAD },
	0xBDCB, { 0xEC, 0x8B, 0xAF },
	0xBDCC, { 0xEC, 0x8B, 0xB1 },
	0xBDCD, { 0xEC, 0x8B, 0xB6 },
	0xBDCE, { 0xEC, 0x8B, 0xB8 },
	0xBDCF, { 0xEC, 0x8B, 0xB9 },
	0xBDD0, { 0xEC, 0x8B, 0xBB },
	0xBDD1, { 0xEC, 0x8B, 0xBC },
	0xBDD2, { 0xEC, 0x8C, 0x80 },
	0xBDD3, { 0xEC, 0x8C, 0x88 },
	0xBDD4, { 0xEC, 0x8C, 0x89 },
	0xBDD5, { 0xEC, 0x8C, 0x8C },
	0xBDD6, { 0xEC, 0x8C, 0x8D },
	0xBDD7, { 0xEC, 0x8C, 0x93 },
	0xBDD8, { 0xEC, 0x8C, 0x94 },
	0xBDD9, { 0xEC, 0x8C, 0x95 },
	0xBDDA, { 0xEC, 0x8C, 0x98 },
	0xBDDB, { 0xEC, 0x8C, 0x9C },
	0xBDDC, { 0xEC, 0x8C, 0xA4 },
	0xBDDD, { 0xEC, 0x8C, 0xA5 },
	0xBDDE, { 0xEC, 0x8C, 0xA8 },
	0xBDDF, { 0xEC, 0x8C, 0xA9 },
	0xBDE0, { 0xEC, 0x8D, 0x85 },
	0xBDE1, { 0xEC, 0x8D, 0xA8 },
	0xBDE2, { 0xEC, 0x8D, 0xA9 },
	0xBDE3, { 0xEC, 0x8D, 0xAC },
	0xBDE4, { 0xEC, 0x8D, 0xB0 },
	0xBDE5, { 0xEC, 0x8D, 0xB2 },
	0xBDE6, { 0xEC, 0x8D, 0xB8 },
	0xBDE7, { 0xEC, 0x8D, 0xB9 },
	0xBDE8, { 0xEC, 0x8D, 0xBC },
	0xBDE9, { 0xEC, 0x8D, 0xBD },
	0xBDEA, { 0xEC, 0x8E, 0x84 },
	0xBDEB, { 0xEC, 0x8E, 0x88 },
	0xBDEC, { 0xEC, 0x8E, 0x8C },
	0xBDED, { 0xEC, 0x8F, 0x80 },
	0xBDEE, { 0xEC, 0x8F, 0x98 },
	0xBDEF, { 0xEC, 0x8F, 0x99 },
	0xBDF0, { 0xEC, 0x8F, 0x9C },
	0xBDF1, { 0xEC, 0x8F, 0x9F },
	0xBDF2, { 0xEC, 0x8F, 0xA0 },
	0xBDF3, { 0xEC, 0x8F, 0xA2 },
	0xBDF4, { 0xEC, 0x8F, 0xA8 },
	0xBDF5, { 0xEC, 0x8F, 0xA9 },
	0xBDF6, { 0xEC, 0x8F, 0xAD },
	0xBDF7, { 0xEC, 0x8F, 0xB4 },
	0xBDF8, { 0xEC, 0x8F, 0xB5 },
	0xBDF9, { 0xEC, 0x8F, 0xB8 },
	0xBDFA, { 0xEC, 0x90, 0x88 },
	0xBDFB, { 0xEC, 0x90, 0x90 },
	0xBDFC, { 0xEC, 0x90, 0xA4 },
	0xBDFD, { 0xEC, 0x90, 0xAC },
	0xBDFE, { 0xEC, 0x90, 0xB0 },
	0xBE41, { 0xED, 0x90, 0xB8 },
	0xBE42, { 0xED, 0x90, 0xB9 },
	0xBE43, { 0xED, 0x90, 0xBA },
	0xBE44, { 0xED, 0x90, 0xBB },
	0xBE45, { 0xED, 0x90, 0xBC },
	0xBE46, { 0xED, 0x90, 0xBD },
	0xBE47, { 0xED, 0x90, 0xBE },
	0xBE48, { 0xED, 0x90, 0xBF },
	0xBE49, { 0xED, 0x91, 0x81 },
	0xBE4A, { 0xED, 0x91, 0x82 },
	0xBE4B, { 0xED, 0x91, 0x83 },
	0xBE4C, { 0xED, 0x91, 0x85 },
	0xBE4D, { 0xED, 0x91, 0x86 },
	0xBE4E, { 0xED, 0x91, 0x87 },
	0xBE4F, { 0xED, 0x91, 0x88 },
	0xBE50, { 0xED, 0x91, 0x89 },
	0xBE51, { 0xED, 0x91, 0x8A },
	0xBE52, { 0xED, 0x91, 0x8B },
	0xBE53, { 0xED, 0x91, 0x8C },
	0xBE54, { 0xED, 0x91, 0x8D },
	0xBE55, { 0xED, 0x91, 0x8E },
	0xBE56, { 0xED, 0x91, 0x8F },
	0xBE57, { 0xED, 0x91, 0x90 },
	0xBE58, { 0xED, 0x91, 0x91 },
	0xBE59, { 0xED, 0x91, 0x92 },
	0xBE5A, { 0xED, 0x91, 0x93 },
	0xBE61, { 0xED, 0x91, 0x94 },
	0xBE62, { 0xED, 0x91, 0x95 },
	0xBE63, { 0xED, 0x91, 0x96 },
	0xBE64, { 0xED, 0x91, 0x97 },
	0xBE65, { 0xED, 0x91, 0x98 },
	0xBE66, { 0xED, 0x91, 0x99 },
	0xBE67, { 0xED, 0x91, 0x9A },
	0xBE68, { 0xED, 0x91, 0x9B },
	0xBE69, { 0xED, 0x91, 0x9D },
	0xBE6A, { 0xED, 0x91, 0x9E },
	0xBE6B, { 0xED, 0x91, 0x9F },
	0xBE6C, { 0xED, 0x91, 0xA1 },
	0xBE6D, { 0xED, 0x91, 0xA2 },
	0xBE6E, { 0xED, 0x91, 0xA3 },
	0xBE6F, { 0xED, 0x91, 0xA5 },
	0xBE70, { 0xED, 0x91, 0xA6 },
	0xBE71, { 0xED, 0x91, 0xA7 },
	0xBE72, { 0xED, 0x91, 0xA8 },
	0xBE73, { 0xED, 0x91, 0xA9 },
	0xBE74, { 0xED, 0x91, 0xAA },
	0xBE75, { 0xED, 0x91, 0xAB },
	0xBE76, { 0xED, 0x91, 0xAC },
	0xBE77, { 0xED, 0x91, 0xAE },
	0xBE78, { 0xED, 0x91, 0xB0 },
	0xBE79, { 0xED, 0x91, 0xB1 },
	0xBE7A, { 0xED, 0x91, 0xB2 },
	0xBE81, { 0xED, 0x91, 0xB3 },
	0xBE82, { 0xED, 0x91, 0xB4 },
	0xBE83, { 0xED, 0x91, 0xB5 },
	0xBE84, { 0xED, 0x91, 0xB6 },
	0xBE85, { 0xED, 0x91, 0xB7 },
	0xBE86, { 0xED, 0x91, 0xBA },
	0xBE87, { 0xED, 0x91, 0xBB },
	0xBE88, { 0xED, 0x91, 0xBD },
	0xBE89, { 0xED, 0x91, 0xBE },
	0xBE8A, { 0xED, 0x92, 0x81 },
	0xBE8B, { 0xED, 0x92, 0x83 },
	0xBE8C, { 0xED, 0x92, 0x84 },
	0xBE8D, { 0xED, 0x92, 0x85 },
	0xBE8E, { 0xED, 0x92, 0x86 },
	0xBE8F, { 0xED, 0x92, 0x87 },
	0xBE90, { 0xED, 0x92, 0x8A },
	0xBE91, { 0xED, 0x92, 0x8C },
	0xBE92, { 0xED, 0x92, 0x8E },
	0xBE93, { 0xED, 0x92, 0x8F },
	0xBE94, { 0xED, 0x92, 0x90 },
	0xBE95, { 0xED, 0x92, 0x91 },
	0xBE96, { 0xED, 0x92, 0x92 },
	0xBE97, { 0xED, 0x92, 0x93 },
	0xBE98, { 0xED, 0x92, 0x95 },
	0xBE99, { 0xED, 0x92, 0x96 },
	0xBE9A, { 0xED, 0x92, 0x97 },
	0xBE9B, { 0xED, 0x92, 0x98 },
	0xBE9C, { 0xED, 0x92, 0x99 },
	0xBE9D, { 0xED, 0x92, 0x9A },
	0xBE9E, { 0xED, 0x92, 0x9B },
	0xBE9F, { 0xED, 0x92, 0x9C },
	0xBEA0, { 0xED, 0x92, 0x9D },
	0xBEA1, { 0xEC, 0x90, 0xB4 },
	0xBEA2, { 0xEC, 0x90, 0xBC },
	0xBEA3, { 0xEC, 0x90, 0xBD },
	0xBEA4, { 0xEC, 0x91, 0x88 },
	0xBEA5, { 0xEC, 0x91, 0xA4 },
	0xBEA6, { 0xEC, 0x91, 0xA5 },
	0xBEA7, { 0xEC, 0x91, 0xA8 },
	0xBEA8, { 0xEC, 0x91, 0xAC },
	0xBEA9, { 0xEC, 0x91, 0xB4 },
	0xBEAA, { 0xEC, 0x91, 0xB5 },
	0xBEAB, { 0xEC, 0x91, 0xB9 },
	0xBEAC, { 0xEC, 0x92, 0x80 },
	0xBEAD, { 0xEC, 0x92, 0x94 },
	0xBEAE, { 0xEC, 0x92, 0x9C },
	0xBEAF, { 0xEC, 0x92, 0xB8 },
	0xBEB0, { 0xEC, 0x92, 0xBC },
	0xBEB1, { 0xEC, 0x93, 0xA9 },
	0xBEB2, { 0xEC, 0x93, 0xB0 },
	0xBEB3, { 0xEC, 0x93, 0xB1 },
	0xBEB4, { 0xEC, 0x93, 0xB4 },
	0xBEB5, { 0xEC, 0x93, 0xB8 },
	0xBEB6, { 0xEC, 0x93, 0xBA },
	0xBEB7, { 0xEC, 0x93, 0xBF },
	0xBEB8, { 0xEC, 0x94, 0x80 },
	0xBEB9, { 0xEC, 0x94, 0x81 },
	0xBEBA, { 0xEC, 0x94, 0x8C },
	0xBEBB, { 0xEC, 0x94, 0x90 },
	0xBEBC, { 0xEC, 0x94, 0x94 },
	0xBEBD, { 0xEC, 0x94, 0x9C },
	0xBEBE, { 0xEC, 0x94, 0xA8 },
	0xBEBF, { 0xEC, 0x94, 0xA9 },
	0xBEC0, { 0xEC, 0x94, 0xAC },
	0xBEC1, { 0xEC, 0x94, 0xB0 },
	0xBEC2, { 0xEC, 0x94, 0xB8 },
	0xBEC3, { 0xEC, 0x94, 0xB9 },
	0xBEC4, { 0xEC, 0x94, 0xBB },
	0xBEC5, { 0xEC, 0x94, 0xBD },
	0xBEC6, { 0xEC, 0x95, 0x84 },
	0xBEC7, { 0xEC, 0x95, 0x85 },
	0xBEC8, { 0xEC, 0x95, 0x88 },
	0xBEC9, { 0xEC, 0x95, 0x89 },
	0xBECA, { 0xEC, 0x95, 0x8A },
	0xBECB, { 0xEC, 0x95, 0x8C },
	0xBECC, { 0xEC, 0x95, 0x8D },
	0xBECD, { 0xEC, 0x95, 0x8E },
	0xBECE, { 0xEC, 0x95, 0x93 },
	0xBECF, { 0xEC, 0x95, 0x94 },
	0xBED0, { 0xEC, 0x95, 0x95 },
	0xBED1, { 0xEC, 0x95, 0x97 },
	0xBED2, { 0xEC, 0x95, 0x98 },
	0xBED3, { 0xEC, 0x95, 0x99 },
	0xBED4, { 0xEC, 0x95, 0x9D },
	0xBED5, { 0xEC, 0x95, 0x9E },
	0xBED6, { 0xEC, 0x95, 0xA0 },
	0xBED7, { 0xEC, 0x95, 0xA1 },
	0xBED8, { 0xEC, 0x95, 0xA4 },
	0xBED9, { 0xEC, 0x95, 0xA8 },
	0xBEDA, { 0xEC, 0x95, 0xB0 },
	0xBEDB, { 0xEC, 0x95, 0xB1 },
	0xBEDC, { 0xEC, 0x95, 0xB3 },
	0xBEDD, { 0xEC, 0x95, 0xB4 },
	0xBEDE, { 0xEC, 0x95, 0xB5 },
	0xBEDF, { 0xEC, 0x95, 0xBC },
	0xBEE0, { 0xEC, 0x95, 0xBD },
	0xBEE1, { 0xEC, 0x96, 0x80 },
	0xBEE2, { 0xEC, 0x96, 0x84 },
	0xBEE3, { 0xEC, 0x96, 0x87 },
	0xBEE4, { 0xEC, 0x96, 0x8C },
	0xBEE5, { 0xEC, 0x96, 0x8D },
	0xBEE6, { 0xEC, 0x96, 0x8F },
	0xBEE7, { 0xEC, 0x96, 0x91 },
	0xBEE8, { 0xEC, 0x96, 0x95 },
	0xBEE9, { 0xEC, 0x96, 0x97 },
	0xBEEA, { 0xEC, 0x96, 0x98 },
	0xBEEB, { 0xEC, 0x96, 0x9C },
	0xBEEC, { 0xEC, 0x96, 0xA0 },
	0xBEED, { 0xEC, 0x96, 0xA9 },
	0xBEEE, { 0xEC, 0x96, 0xB4 },
	0xBEEF, { 0xEC, 0x96, 0xB5 },
	0xBEF0, { 0xEC, 0x96, 0xB8 },
	0xBEF1, { 0xEC, 0x96, 0xB9 },
	0xBEF2, { 0xEC, 0x96, 0xBB },
	0xBEF3, { 0xEC, 0x96, 0xBC },
	0xBEF4, { 0xEC, 0x96, 0xBD },
	0xBEF5, { 0xEC, 0x96, 0xBE },
	0xBEF6, { 0xEC, 0x97, 0x84 },
	0xBEF7, { 0xEC, 0x97, 0x85 },
	0xBEF8, { 0xEC, 0x97, 0x86 },
	0xBEF9, { 0xEC, 0x97, 0x87 },
	0xBEFA, { 0xEC, 0x97, 0x88 },
	0xBEFB, { 0xEC, 0x97, 0x89 },
	0xBEFC, { 0xEC, 0x97, 0x8A },
	0xBEFD, { 0xEC, 0x97, 0x8C },
	0xBEFE, { 0xEC, 0x97, 0x8E },
	0xBF41, { 0xED, 0x92, 0x9E },
	0xBF42, { 0xED, 0x92, 0x9F },
	0xBF43, { 0xED, 0x92, 0xA0 },
	0xBF44, { 0xED, 0x92, 0xA1 },
	0xBF45, { 0xED, 0x92, 0xA2 },
	0xBF46, { 0xED, 0x92, 0xA3 },
	0xBF47, { 0xED, 0x92, 0xA4 },
	0xBF48, { 0xED, 0x92, 0xA5 },
	0xBF49, { 0xED, 0x92, 0xA6 },
	0xBF4A, { 0xED, 0x92, 0xA7 },
	0xBF4B, { 0xED, 0x92, 0xA8 },
	0xBF4C, { 0xED, 0x92, 0xAA },
	0xBF4D, { 0xED, 0x92, 0xAB },
	0xBF4E, { 0xED, 0x92, 0xAC },
	0xBF4F, { 0xED, 0x92, 0xAD },
	0xBF50, { 0xED, 0x92, 0xAE },
	0xBF51, { 0xED, 0x92, 0xAF },
	0xBF52, { 0xED, 0x92, 0xB0 },
	0xBF53, { 0xED, 0x92, 0xB1 },
	0xBF54, { 0xED, 0x92, 0xB2 },
	0xBF55, { 0xED, 0x92, 0xB3 },
	0xBF56, { 0xED, 0x92, 0xB4 },
	0xBF57, { 0xED, 0x92, 0xB5 },
	0xBF58, { 0xED, 0x92, 0xB6 },
	0xBF59, { 0xED, 0x92, 0xB7 },
	0xBF5A, { 0xED, 0x92, 0xB8 },
	0xBF61, { 0xED, 0x92, 0xB9 },
	0xBF62, { 0xED, 0x92, 0xBA },
	0xBF63, { 0xED, 0x92, 0xBB },
	0xBF64, { 0xED, 0x92, 0xBC },
	0xBF65, { 0xED, 0x92, 0xBD },
	0xBF66, { 0xED, 0x92, 0xBE },
	0xBF67, { 0xED, 0x92, 0xBF },
	0xBF68, { 0xED, 0x93, 0x80 },
	0xBF69, { 0xED, 0x93, 0x81 },
	0xBF6A, { 0xED, 0x93, 0x82 },
	0xBF6B, { 0xED, 0x93, 0x83 },
	0xBF6C, { 0xED, 0x93, 0x84 },
	0xBF6D, { 0xED, 0x93, 0x85 },
	0xBF6E, { 0xED, 0x93, 0x86 },
	0xBF6F, { 0xED, 0x93, 0x87 },
	0xBF70, { 0xED, 0x93, 0x88 },
	0xBF71, { 0xED, 0x93, 0x89 },
	0xBF72, { 0xED, 0x93, 0x8A },
	0xBF73, { 0xED, 0x93, 0x8B },
	0xBF74, { 0xED, 0x93, 0x8D },
	0xBF75, { 0xED, 0x93, 0x8E },
	0xBF76, { 0xED, 0x93, 0x8F },
	0xBF77, { 0xED, 0x93, 0x91 },
	0xBF78, { 0xED, 0x93, 0x92 },
	0xBF79, { 0xED, 0x93, 0x93 },
	0xBF7A, { 0xED, 0x93, 0x95 },
	0xBF81, { 0xED, 0x93, 0x96 },
	0xBF82, { 0xED, 0x93, 0x97 },
	0xBF83, { 0xED, 0x93, 0x98 },
	0xBF84, { 0xED, 0x93, 0x99 },
	0xBF85, { 0xED, 0x93, 0x9A },
	0xBF86, { 0xED, 0x93, 0x9B },
	0xBF87, { 0xED, 0x93, 0x9D },
	0xBF88, { 0xED, 0x93, 0x9E },
	0xBF89, { 0xED, 0x93, 0xA0 },
	0xBF8A, { 0xED, 0x93, 0xA1 },
	0xBF8B, { 0xED, 0x93, 0xA2 },
	0xBF8C, { 0xED, 0x93, 0xA3 },
	0xBF8D, { 0xED, 0x93, 0xA4 },
	0xBF8E, { 0xED, 0x93, 0xA5 },
	0xBF8F, { 0xED, 0x93, 0xA6 },
	0xBF90, { 0xED, 0x93, 0xA7 },
	0xBF91, { 0xED, 0x93, 0xA9 },
	0xBF92, { 0xED, 0x93, 0xAA },
	0xBF93, { 0xED, 0x93, 0xAB },
	0xBF94, { 0xED, 0x93, 0xAD },
	0xBF95, { 0xED, 0x93, 0xAE },
	0xBF96, { 0xED, 0x93, 0xAF },
	0xBF97, { 0xED, 0x93, 0xB1 },
	0xBF98, { 0xED, 0x93, 0xB2 },
	0xBF99, { 0xED, 0x93, 0xB3 },
	0xBF9A, { 0xED, 0x93, 0xB4 },
	0xBF9B, { 0xED, 0x93, 0xB5 },
	0xBF9C, { 0xED, 0x93, 0xB6 },
	0xBF9D, { 0xED, 0x93, 0xB7 },
	0xBF9E, { 0xED, 0x93, 0xB9 },
	0xBF9F, { 0xED, 0x93, 0xBA },
	0xBFA0, { 0xED, 0x93, 0xBC },
	0xBFA1, { 0xEC, 0x97, 0x90 },
	0xBFA2, { 0xEC, 0x97, 0x91 },
	0xBFA3, { 0xEC, 0x97, 0x94 },
	0xBFA4, { 0xEC, 0x97, 0x98 },
	0xBFA5, { 0xEC, 0x97, 0xA0 },
	0xBFA6, { 0xEC, 0x97, 0xA1 },
	0xBFA7, { 0xEC, 0x97, 0xA3 },
	0xBFA8, { 0xEC, 0x97, 0xA5 },
	0xBFA9, { 0xEC, 0x97, 0xAC },
	0xBFAA, { 0xEC, 0x97, 0xAD },
	0xBFAB, { 0xEC, 0x97, 0xAE },
	0xBFAC, { 0xEC, 0x97, 0xB0 },
	0xBFAD, { 0xEC, 0x97, 0xB4 },
	0xBFAE, { 0xEC, 0x97, 0xB6 },
	0xBFAF, { 0xEC, 0x97, 0xB7 },
	0xBFB0, { 0xEC, 0x97, 0xBC },
	0xBFB1, { 0xEC, 0x97, 0xBD },
	0xBFB2, { 0xEC, 0x97, 0xBE },
	0xBFB3, { 0xEC, 0x97, 0xBF },
	0xBFB4, { 0xEC, 0x98, 0x80 },
	0xBFB5, { 0xEC, 0x98, 0x81 },
	0xBFB6, { 0xEC, 0x98, 0x85 },
	0xBFB7, { 0xEC, 0x98, 0x86 },
	0xBFB8, { 0xEC, 0x98, 0x87 },
	0xBFB9, { 0xEC, 0x98, 0x88 },
	0xBFBA, { 0xEC, 0x98, 0x8C },
	0xBFBB, { 0xEC, 0x98, 0x90 },
	0xBFBC, { 0xEC, 0x98, 0x98 },
	0xBFBD, { 0xEC, 0x98, 0x99 },
	0xBFBE, { 0xEC, 0x98, 0x9B },
	0xBFBF, { 0xEC, 0x98, 0x9C },
	0xBFC0, { 0xEC, 0x98, 0xA4 },
	0xBFC1, { 0xEC, 0x98, 0xA5 },
	0xBFC2, { 0xEC, 0x98, 0xA8 },
	0xBFC3, { 0xEC, 0x98, 0xAC },
	0xBFC4, { 0xEC, 0x98, 0xAD },
	0xBFC5, { 0xEC, 0x98, 0xAE },
	0xBFC6, { 0xEC, 0x98, 0xB0 },
	0xBFC7, { 0xEC, 0x98, 0xB3 },
	0xBFC8, { 0xEC, 0x98, 0xB4 },
	0xBFC9, { 0xEC, 0x98, 0xB5 },
	0xBFCA, { 0xEC, 0x98, 0xB7 },
	0xBFCB, { 0xEC, 0x98, 0xB9 },
	0xBFCC, { 0xEC, 0x98, 0xBB },
	0xBFCD, { 0xEC, 0x99, 0x80 },
	0xBFCE, { 0xEC, 0x99, 0x81 },
	0xBFCF, { 0xEC, 0x99, 0x84 },
	0xBFD0, { 0xEC, 0x99, 0x88 },
	0xBFD1, { 0xEC, 0x99, 0x90 },
	0xBFD2, { 0xEC, 0x99, 0x91 },
	0xBFD3, { 0xEC, 0x99, 0x93 },
	0xBFD4, { 0xEC, 0x99, 0x94 },
	0xBFD5, { 0xEC, 0x99, 0x95 },
	0xBFD6, { 0xEC, 0x99, 0x9C },
	0xBFD7, { 0xEC, 0x99, 0x9D },
	0xBFD8, { 0xEC, 0x99, 0xA0 },
	0xBFD9, { 0xEC, 0x99, 0xAC },
	0xBFDA, { 0xEC, 0x99, 0xAF },
	0xBFDB, { 0xEC, 0x99, 0xB1 },
	0xBFDC, { 0xEC, 0x99, 0xB8 },
	0xBFDD, { 0xEC, 0x99, 0xB9 },
	0xBFDE, { 0xEC, 0x99, 0xBC },
	0xBFDF, { 0xEC, 0x9A, 0x80 },
	0xBFE0, { 0xEC, 0x9A, 0x88 },
	0xBFE1, { 0xEC, 0x9A, 0x89 },
	0xBFE2, { 0xEC, 0x9A, 0x8B },
	0xBFE3, { 0xEC, 0x9A, 0x8D },
	0xBFE4, { 0xEC, 0x9A, 0x94 },
	0xBFE5, { 0xEC, 0x9A, 0x95 },
	0xBFE6, { 0xEC, 0x9A, 0x98 },
	0xBFE7, { 0xEC, 0x9A, 0x9C },
	0xBFE8, { 0xEC, 0x9A, 0xA4 },
	0xBFE9, { 0xEC, 0x9A, 0xA5 },
	0xBFEA, { 0xEC, 0x9A, 0xA7 },
	0xBFEB, { 0xEC, 0x9A, 0xA9 },
	0xBFEC, { 0xEC, 0x9A, 0xB0 },
	0xBFED, { 0xEC, 0x9A, 0xB1 },
	0xBFEE, { 0xEC, 0x9A, 0xB4 },
	0xBFEF, { 0xEC, 0x9A, 0xB8 },
	0xBFF0, { 0xEC, 0x9A, 0xB9 },
	0xBFF1, { 0xEC, 0x9A, 0xBA },
	0xBFF2, { 0xEC, 0x9B, 0x80 },
	0xBFF3, { 0xEC, 0x9B, 0x81 },
	0xBFF4, { 0xEC, 0x9B, 0x83 },
	0xBFF5, { 0xEC, 0x9B, 0x85 },
	0xBFF6, { 0xEC, 0x9B, 0x8C },
	0xBFF7, { 0xEC, 0x9B, 0x8D },
	0xBFF8, { 0xEC, 0x9B, 0x90 },
	0xBFF9, { 0xEC, 0x9B, 0x94 },
	0xBFFA, { 0xEC, 0x9B, 0x9C },
	0xBFFB, { 0xEC, 0x9B, 0x9D },
	0xBFFC, { 0xEC, 0x9B, 0xA0 },
	0xBFFD, { 0xEC, 0x9B, 0xA1 },
	0xBFFE, { 0xEC, 0x9B, 0xA8 },
	0xC041, { 0xED, 0x93, 0xBE },
	0xC042, { 0xED, 0x93, 0xBF },
	0xC043, { 0xED, 0x94, 0x80 },
	0xC044, { 0xED, 0x94, 0x81 },
	0xC045, { 0xED, 0x94, 0x82 },
	0xC046, { 0xED, 0x94, 0x83 },
	0xC047, { 0xED, 0x94, 0x85 },
	0xC048, { 0xED, 0x94, 0x86 },
	0xC049, { 0xED, 0x94, 0x87 },
	0xC04A, { 0xED, 0x94, 0x89 },
	0xC04B, { 0xED, 0x94, 0x8A },
	0xC04C, { 0xED, 0x94, 0x8B },
	0xC04D, { 0xED, 0x94, 0x8D },
	0xC04E, { 0xED, 0x94, 0x8E },
	0xC04F, { 0xED, 0x94, 0x8F },
	0xC050, { 0xED, 0x94, 0x90 },
	0xC051, { 0xED, 0x94, 0x91 },
	0xC052, { 0xED, 0x94, 0x92 },
	0xC053, { 0xED, 0x94, 0x93 },
	0xC054, { 0xED, 0x94, 0x96 },
	0xC055, { 0xED, 0x94, 0x98 },
	0xC056, { 0xED, 0x94, 0x99 },
	0xC057, { 0xED, 0x94, 0x9A },
	0xC058, { 0xED, 0x94, 0x9B },
	0xC059, { 0xED, 0x94, 0x9C },
	0xC05A, { 0xED, 0x94, 0x9D },
	0xC061, { 0xED, 0x94, 0x9E },
	0xC062, { 0xED, 0x94, 0x9F },
	0xC063, { 0xED, 0x94, 0xA0 },
	0xC064, { 0xED, 0x94, 0xA1 },
	0xC065, { 0xED, 0x94, 0xA2 },
	0xC066, { 0xED, 0x94, 0xA3 },
	0xC067, { 0xED, 0x94, 0xA4 },
	0xC068, { 0xED, 0x94, 0xA5 },
	0xC069, { 0xED, 0x94, 0xA6 },
	0xC06A, { 0xED, 0x94, 0xA7 },
	0xC06B, { 0xED, 0x94, 0xA8 },
	0xC06C, { 0xED, 0x94, 0xA9 },
	0xC06D, { 0xED, 0x94, 0xAA },
	0xC06E, { 0xED, 0x94, 0xAB },
	0xC06F, { 0xED, 0x94, 0xAC },
	0xC070, { 0xED, 0x94, 0xAD },
	0xC071, { 0xED, 0x94, 0xAE },
	0xC072, { 0xED, 0x94, 0xAF },
	0xC073, { 0xED, 0x94, 0xB0 },
	0xC074, { 0xED, 0x94, 0xB1 },
	0xC075, { 0xED, 0x94, 0xB2 },
	0xC076, { 0xED, 0x94, 0xB3 },
	0xC077, { 0xED, 0x94, 0xB4 },
	0xC078, { 0xED, 0x94, 0xB5 },
	0xC079, { 0xED, 0x94, 0xB6 },
	0xC07A, { 0xED, 0x94, 0xB7 },
	0xC081, { 0xED, 0x94, 0xB8 },
	0xC082, { 0xED, 0x94, 0xB9 },
	0xC083, { 0xED, 0x94, 0xBA },
	0xC084, { 0xED, 0x94, 0xBB },
	0xC085, { 0xED, 0x94, 0xBE },
	0xC086, { 0xED, 0x94, 0xBF },
	0xC087, { 0xED, 0x95, 0x81 },
	0xC088, { 0xED, 0x95, 0x82 },
	0xC089, { 0xED, 0x95, 0x83 },
	0xC08A, { 0xED, 0x95, 0x85 },
	0xC08B, { 0xED, 0x95, 0x86 },
	0xC08C, { 0xED, 0x95, 0x87 },
	0xC08D, { 0xED, 0x95, 0x88 },
	0xC08E, { 0xED, 0x95, 0x89 },
	0xC08F, { 0xED, 0x95, 0x8A },
	0xC090, { 0xED, 0x95, 0x8B },
	0xC091, { 0xED, 0x95, 0x8E },
	0xC092, { 0xED, 0x95, 0x90 },
	0xC093, { 0xED, 0x95, 0x92 },
	0xC094, { 0xED, 0x95, 0x93 },
	0xC095, { 0xED, 0x95, 0x94 },
	0xC096, { 0xED, 0x95, 0x95 },
	0xC097, { 0xED, 0x95, 0x96 },
	0xC098, { 0xED, 0x95, 0x97 },
	0xC099, { 0xED, 0x95, 0x9A },
	0xC09A, { 0xED, 0x95, 0x9B },
	0xC09B, { 0xED, 0x95, 0x9D },
	0xC09C, { 0xED, 0x95, 0x9E },
	0xC09D, { 0xED, 0x95, 0x9F },
	0xC09E, { 0xED, 0x95, 0xA1 },
	0xC09F, { 0xED, 0x95, 0xA2 },
	0xC0A0, { 0xED, 0x95, 0xA3 },
	0xC0A1, { 0xEC, 0x9B, 0xA9 },
	0xC0A2, { 0xEC, 0x9B, 0xAC },
	0xC0A3, { 0xEC, 0x9B, 0xB0 },
	0xC0A4, { 0xEC, 0x9B, 0xB8 },
	0xC0A5, { 0xEC, 0x9B, 0xB9 },
	0xC0A6, { 0xEC, 0x9B, 0xBD },
	0xC0A7, { 0xEC, 0x9C, 0x84 },
	0xC0A8, { 0xEC, 0x9C, 0x85 },
	0xC0A9, { 0xEC, 0x9C, 0x88 },
	0xC0AA, { 0xEC, 0x9C, 0x8C },
	0xC0AB, { 0xEC, 0x9C, 0x94 },
	0xC0AC, { 0xEC, 0x9C, 0x95 },
	0xC0AD, { 0xEC, 0x9C, 0x97 },
	0xC0AE, { 0xEC, 0x9C, 0x99 },
	0xC0AF, { 0xEC, 0x9C, 0xA0 },
	0xC0B0, { 0xEC, 0x9C, 0xA1 },
	0xC0B1, { 0xEC, 0x9C, 0xA4 },
	0xC0B2, { 0xEC, 0x9C, 0xA8 },
	0xC0B3, { 0xEC, 0x9C, 0xB0 },
	0xC0B4, { 0xEC, 0x9C, 0xB1 },
	0xC0B5, { 0xEC, 0x9C, 0xB3 },
	0xC0B6, { 0xEC, 0x9C, 0xB5 },
	0xC0B7, { 0xEC, 0x9C, 0xB7 },
	0xC0B8, { 0xEC, 0x9C, 0xBC },
	0xC0B9, { 0xEC, 0x9C, 0xBD },
	0xC0BA, { 0xEC, 0x9D, 0x80 },
	0xC0BB, { 0xEC, 0x9D, 0x84 },
	0xC0BC, { 0xEC, 0x9D, 0x8A },
	0xC0BD, { 0xEC, 0x9D, 0x8C },
	0xC0BE, { 0xEC, 0x9D, 0x8D },
	0xC0BF, { 0xEC, 0x9D, 0x8F },
	0xC0C0, { 0xEC, 0x9D, 0x91 },
	0xC0C1, { 0xEC, 0x9D, 0x92 },
	0xC0C2, { 0xEC, 0x9D, 0x93 },
	0xC0C3, { 0xEC, 0x9D, 0x94 },
	0xC0C4, { 0xEC, 0x9D, 0x95 },
	0xC0C5, { 0xEC, 0x9D, 0x96 },
	0xC0C6, { 0xEC, 0x9D, 0x97 },
	0xC0C7, { 0xEC, 0x9D, 0x98 },
	0xC0C8, { 0xEC, 0x9D, 0x9C },
	0xC0C9, { 0xEC, 0x9D, 0xA0 },
	0xC0CA, { 0xEC, 0x9D, 0xA8 },
	0xC0CB, { 0xEC, 0x9D, 0xAB },
	0xC0CC, { 0xEC, 0x9D, 0xB4 },
	0xC0CD, { 0xEC, 0x9D, 0xB5 },
	0xC0CE, { 0xEC, 0x9D, 0xB8 },
	0xC0CF, { 0xEC, 0x9D, 0xBC },
	0xC0D0, { 0xEC, 0x9D, 0xBD },
	0xC0D1, { 0xEC, 0x9D, 0xBE },
	0xC0D2, { 0xEC, 0x9E, 0x83 },
	0xC0D3, { 0xEC, 0x9E, 0x84 },
	0xC0D4, { 0xEC, 0x9E, 0x85 },
	0xC0D5, { 0xEC, 0x9E, 0x87 },
	0xC0D6, { 0xEC, 0x9E, 0x88 },
	0xC0D7, { 0xEC, 0x9E, 0x89 },
	0xC0D8, { 0xEC, 0x9E, 0x8A },
	0xC0D9, { 0xEC, 0x9E, 0x8E },
	0xC0DA, { 0xEC, 0x9E, 0x90 },
	0xC0DB, { 0xEC, 0x9E, 0x91 },
	0xC0DC, { 0xEC, 0x9E, 0x94 },
	0xC0DD, { 0xEC, 0x9E, 0x96 },
	0xC0DE, { 0xEC, 0x9E, 0x97 },
	0xC0DF, { 0xEC, 0x9E, 0x98 },
	0xC0E0, { 0xEC, 0x9E, 0x9A },
	0xC0E1, { 0xEC, 0x9E, 0xA0 },
	0xC0E2, { 0xEC, 0x9E, 0xA1 },
	0xC0E3, { 0xEC, 0x9E, 0xA3 },
	0xC0E4, { 0xEC, 0x9E, 0xA4 },
	0xC0E5, { 0xEC, 0x9E, 0xA5 },
	0xC0E6, { 0xEC, 0x9E, 0xA6 },
	0xC0E7, { 0xEC, 0x9E, 0xAC },
	0xC0E8, { 0xEC, 0x9E, 0xAD },
	0xC0E9, { 0xEC, 0x9E, 0xB0 },
	0xC0EA, { 0xEC, 0x9E, 0xB4 },
	0xC0EB, { 0xEC, 0x9E, 0xBC },
	0xC0EC, { 0xEC, 0x9E, 0xBD },
	0xC0ED, { 0xEC, 0x9E, 0xBF },
	0xC0EE, { 0xEC, 0x9F, 0x80 },
	0xC0EF, { 0xEC, 0x9F, 0x81 },
	0xC0F0, { 0xEC, 0x9F, 0x88 },
	0xC0F1, { 0xEC, 0x9F, 0x89 },
	0xC0F2, { 0xEC, 0x9F, 0x8C },
	0xC0F3, { 0xEC, 0x9F, 0x8E },
	0xC0F4, { 0xEC, 0x9F, 0x90 },
	0xC0F5, { 0xEC, 0x9F, 0x98 },
	0xC0F6, { 0xEC, 0x9F, 0x9D },
	0xC0F7, { 0xEC, 0x9F, 0xA4 },
	0xC0F8, { 0xEC, 0x9F, 0xA8 },
	0xC0F9, { 0xEC, 0x9F, 0xAC },
	0xC0FA, { 0xEC, 0xA0, 0x80 },
	0xC0FB, { 0xEC, 0xA0, 0x81 },
	0xC0FC, { 0xEC, 0xA0, 0x84 },
	0xC0FD, { 0xEC, 0xA0, 0x88 },
	0xC0FE, { 0xEC, 0xA0, 0x8A },
	0xC141, { 0xED, 0x95, 0xA4 },
	0xC142, { 0xED, 0x95, 0xA6 },
	0xC143, { 0xED, 0x95, 0xA7 },
	0xC144, { 0xED, 0x95, 0xAA },
	0xC145, { 0xED, 0x95, 0xAC },
	0xC146, { 0xED, 0x95, 0xAE },
	0xC147, { 0xED, 0x95, 0xAF },
	0xC148, { 0xED, 0x95, 0xB0 },
	0xC149, { 0xED, 0x95, 0xB1 },
	0xC14A, { 0xED, 0x95, 0xB2 },
	0xC14B, { 0xED, 0x95, 0xB3 },
	0xC14C, { 0xED, 0x95, 0xB6 },
	0xC14D, { 0xED, 0x95, 0xB7 },
	0xC14E, { 0xED, 0x95, 0xB9 },
	0xC14F, { 0xED, 0x95, 0xBA },
	0xC150, { 0xED, 0x95, 0xBB },
	0xC151, { 0xED, 0x95, 0xBD },
	0xC152, { 0xED, 0x95, 0xBE },
	0xC153, { 0xED, 0x95, 0xBF },
	0xC154, { 0xED, 0x96, 0x80 },
	0xC155, { 0xED, 0x96, 0x81 },
	0xC156, { 0xED, 0x96, 0x82 },
	0xC157, { 0xED, 0x96, 0x83 },
	0xC158, { 0xED, 0x96, 0x86 },
	0xC159, { 0xED, 0x96, 0x8A },
	0xC15A, { 0xED, 0x96, 0x8B },
	0xC161, { 0xED, 0x96, 0x8C },
	0xC162, { 0xED, 0x96, 0x8D },
	0xC163, { 0xED, 0x96, 0x8E },
	0xC164, { 0xED, 0x96, 0x8F },
	0xC165, { 0xED, 0x96, 0x91 },
	0xC166, { 0xED, 0x96, 0x92 },
	0xC167, { 0xED, 0x96, 0x93 },
	0xC168, { 0xED, 0x96, 0x94 },
	0xC169, { 0xED, 0x96, 0x95 },
	0xC16A, { 0xED, 0x96, 0x96 },
	0xC16B, { 0xED, 0x96, 0x97 },
	0xC16C, { 0xED, 0x96, 0x98 },
	0xC16D, { 0xED, 0x96, 0x99 },
	0xC16E, { 0xED, 0x96, 0x9A },
	0xC16F, { 0xED, 0x96, 0x9B },
	0xC170, { 0xED, 0x96, 0x9C },
	0xC171, { 0xED, 0x96, 0x9D },
	0xC172, { 0xED, 0x96, 0x9E },
	0xC173, { 0xED, 0x96, 0x9F },
	0xC174, { 0xED, 0x96, 0xA0 },
	0xC175, { 0xED, 0x96, 0xA1 },
	0xC176, { 0xED, 0x96, 0xA2 },
	0xC177, { 0xED, 0x96, 0xA3 },
	0xC178, { 0xED, 0x96, 0xA4 },
	0xC179, { 0xED, 0x96, 0xA6 },
	0xC17A, { 0xED, 0x96, 0xA7 },
	0xC181, { 0xED, 0x96, 0xA8 },
	0xC182, { 0xED, 0x96, 0xA9 },
	0xC183, { 0xED, 0x96, 0xAA },
	0xC184, { 0xED, 0x96, 0xAB },
	0xC185, { 0xED, 0x96, 0xAC },
	0xC186, { 0xED, 0x96, 0xAD },
	0xC187, { 0xED, 0x96, 0xAE },
	0xC188, { 0xED, 0x96, 0xAF },
	0xC189, { 0xED, 0x96, 0xB0 },
	0xC18A, { 0xED, 0x96, 0xB1 },
	0xC18B, { 0xED, 0x96, 0xB2 },
	0xC18C, { 0xED, 0x96, 0xB3 },
	0xC18D, { 0xED, 0x96, 0xB4 },
	0xC18E, { 0xED, 0x96, 0xB5 },
	0xC18F, { 0xED, 0x96, 0xB6 },
	0xC190, { 0xED, 0x96, 0xB7 },
	0xC191, { 0xED, 0x96, 0xB8 },
	0xC192, { 0xED, 0x96, 0xB9 },
	0xC193, { 0xED, 0x96, 0xBA },
	0xC194, { 0xED, 0x96, 0xBB },
	0xC195, { 0xED, 0x96, 0xBC },
	0xC196, { 0xED, 0x96, 0xBD },
	0xC197, { 0xED, 0x96, 0xBE },
	0xC198, { 0xED, 0x96, 0xBF },
	0xC199, { 0xED, 0x97, 0x80 },
	0xC19A, { 0xED, 0x97, 0x81 },
	0xC19B, { 0xED, 0x97, 0x82 },
	0xC19C, { 0xED, 0x97, 0x83 },
	0xC19D, { 0xED, 0x97, 0x84 },
	0xC19E, { 0xED, 0x97, 0x85 },
	0xC19F, { 0xED, 0x97, 0x86 },
	0xC1A0, { 0xED, 0x97, 0x87 },
	0xC1A1, { 0xEC, 0xA0, 0x90 },
	0xC1A2, { 0xEC, 0xA0, 0x91 },
	0xC1A3, { 0xEC, 0xA0, 0x93 },
	0xC1A4, { 0xEC, 0xA0, 0x95 },
	0xC1A5, { 0xEC, 0xA0, 0x96 },
	0xC1A6, { 0xEC, 0xA0, 0x9C },
	0xC1A7, { 0xEC, 0xA0, 0x9D },
	0xC1A8, { 0xEC, 0xA0, 0xA0 },
	0xC1A9, { 0xEC, 0xA0, 0xA4 },
	0xC1AA, { 0xEC, 0xA0, 0xAC },
	0xC1AB, { 0xEC, 0xA0, 0xAD },
	0xC1AC, { 0xEC, 0xA0, 0xAF },
	0xC1AD, { 0xEC, 0xA0, 0xB1 },
	0xC1AE, { 0xEC, 0xA0, 0xB8 },
	0xC1AF, { 0xEC, 0xA0, 0xBC },
	0xC1B0, { 0xEC, 0xA1, 0x80 },
	0xC1B1, { 0xEC, 0xA1, 0x88 },
	0xC1B2, { 0xEC, 0xA1, 0x89 },
	0xC1B3, { 0xEC, 0xA1, 0x8C },
	0xC1B4, { 0xEC, 0xA1, 0x8D },
	0xC1B5, { 0xEC, 0xA1, 0x94 },
	0xC1B6, { 0xEC, 0xA1, 0xB0 },
	0xC1B7, { 0xEC, 0xA1, 0xB1 },
	0xC1B8, { 0xEC, 0xA1, 0xB4 },
	0xC1B9, { 0xEC, 0xA1, 0xB8 },
	0xC1BA, { 0xEC, 0xA1, 0xBA },
	0xC1BB, { 0xEC, 0xA2, 0x80 },
	0xC1BC, { 0xEC, 0xA2, 0x81 },
	0xC1BD, { 0xEC, 0xA2, 0x83 },
	0xC1BE, { 0xEC, 0xA2, 0x85 },
	0xC1BF, { 0xEC, 0xA2, 0x86 },
	0xC1C0, { 0xEC, 0xA2, 0x87 },
	0xC1C1, { 0xEC, 0xA2, 0x8B },
	0xC1C2, { 0xEC, 0xA2, 0x8C },
	0xC1C3, { 0xEC, 0xA2, 0x8D },
	0xC1C4, { 0xEC, 0xA2, 0x94 },
	0xC1C5, { 0xEC, 0xA2, 0x9D },
	0xC1C6, { 0xEC, 0xA2, 0x9F },
	0xC1C7, { 0xEC, 0xA2, 0xA1 },
	0xC1C8, { 0xEC, 0xA2, 0xA8 },
	0xC1C9, { 0xEC, 0xA2, 0xBC },
	0xC1CA, { 0xEC, 0xA2, 0xBD },
	0xC1CB, { 0xEC, 0xA3, 0x84 },
	0xC1CC, { 0xEC, 0xA3, 0x88 },
	0xC1CD, { 0xEC, 0xA3, 0x8C },
	0xC1CE, { 0xEC, 0xA3, 0x94 },
	0xC1CF, { 0xEC, 0xA3, 0x95 },
	0xC1D0, { 0xEC, 0xA3, 0x97 },
	0xC1D1, { 0xEC, 0xA3, 0x99 },
	0xC1D2, { 0xEC, 0xA3, 0xA0 },
	0xC1D3, { 0xEC, 0xA3, 0xA1 },
	0xC1D4, { 0xEC, 0xA3, 0xA4 },
	0xC1D5, { 0xEC, 0xA3, 0xB5 },
	0xC1D6, { 0xEC, 0xA3, 0xBC },
	0xC1D7, { 0xEC, 0xA3, 0xBD },
	0xC1D8, { 0xEC, 0xA4, 0x80 },
	0xC1D9, { 0xEC, 0xA4, 0x84 },
	0xC1DA, { 0xEC, 0xA4, 0x85 },
	0xC1DB, { 0xEC, 0xA4, 0x86 },
	0xC1DC, { 0xEC, 0xA4, 0x8C },
	0xC1DD, { 0xEC, 0xA4, 0x8D },
	0xC1DE, { 0xEC, 0xA4, 0x8F },
	0xC1DF, { 0xEC, 0xA4, 0x91 },
	0xC1E0, { 0xEC, 0xA4, 0x98 },
	0xC1E1, { 0xEC, 0xA4, 0xAC },
	0xC1E2, { 0xEC, 0xA4, 0xB4 },
	0xC1E3, { 0xEC, 0xA5, 0x90 },
	0xC1E4, { 0xEC, 0xA5, 0x91 },
	0xC1E5, { 0xEC, 0xA5, 0x94 },
	0xC1E6, { 0xEC, 0xA5, 0x98 },
	0xC1E7, { 0xEC, 0xA5, 0xA0 },
	0xC1E8, { 0xEC, 0xA5, 0xA1 },
	0xC1E9, { 0xEC, 0xA5, 0xA3 },
	0xC1EA, { 0xEC, 0xA5, 0xAC },
	0xC1EB, { 0xEC, 0xA5, 0xB0 },
	0xC1EC, { 0xEC, 0xA5, 0xB4 },
	0xC1ED, { 0xEC, 0xA5, 0xBC },
	0xC1EE, { 0xEC, 0xA6, 0x88 },
	0xC1EF, { 0xEC, 0xA6, 0x89 },
	0xC1F0, { 0xEC, 0xA6, 0x8C },
	0xC1F1, { 0xEC, 0xA6, 0x90 },
	0xC1F2, { 0xEC, 0xA6, 0x98 },
	0xC1F3, { 0xEC, 0xA6, 0x99 },
	0xC1F4, { 0xEC, 0xA6, 0x9B },
	0xC1F5, { 0xEC, 0xA6, 0x9D },
	0xC1F6, { 0xEC, 0xA7, 0x80 },
	0xC1F7, { 0xEC, 0xA7, 0x81 },
	0xC1F8, { 0xEC, 0xA7, 0x84 },
	0xC1F9, { 0xEC, 0xA7, 0x87 },
	0xC1FA, { 0xEC, 0xA7, 0x88 },
	0xC1FB, { 0xEC, 0xA7, 0x8A },
	0xC1FC, { 0xEC, 0xA7, 0x90 },
	0xC1FD, { 0xEC, 0xA7, 0x91 },
	0xC1FE, { 0xEC, 0xA7, 0x93 },
	0xC241, { 0xED, 0x97, 0x8A },
	0xC242, { 0xED, 0x97, 0x8B },
	0xC243, { 0xED, 0x97, 0x8D },
	0xC244, { 0xED, 0x97, 0x8E },
	0xC245, { 0xED, 0x97, 0x8F },
	0xC246, { 0xED, 0x97, 0x91 },
	0xC247, { 0xED, 0x97, 0x93 },
	0xC248, { 0xED, 0x97, 0x94 },
	0xC249, { 0xED, 0x97, 0x95 },
	0xC24A, { 0xED, 0x97, 0x96 },
	0xC24B, { 0xED, 0x97, 0x97 },
	0xC24C, { 0xED, 0x97, 0x9A },
	0xC24D, { 0xED, 0x97, 0x9C },
	0xC24E, { 0xED, 0x97, 0x9E },
	0xC24F, { 0xED, 0x97, 0x9F },
	0xC250, { 0xED, 0x97, 0xA0 },
	0xC251, { 0xED, 0x97, 0xA1 },
	0xC252, { 0xED, 0x97, 0xA2 },
	0xC253, { 0xED, 0x97, 0xA3 },
	0xC254, { 0xED, 0x97, 0xA6 },
	0xC255, { 0xED, 0x97, 0xA7 },
	0xC256, { 0xED, 0x97, 0xA9 },
	0xC257, { 0xED, 0x97, 0xAA },
	0xC258, { 0xED, 0x97, 0xAB },
	0xC259, { 0xED, 0x97, 0xAD },
	0xC25A, { 0xED, 0x97, 0xAE },
	0xC261, { 0xED, 0x97, 0xAF },
	0xC262, { 0xED, 0x97, 0xB0 },
	0xC263, { 0xED, 0x97, 0xB1 },
	0xC264, { 0xED, 0x97, 0xB2 },
	0xC265, { 0xED, 0x97, 0xB3 },
	0xC266, { 0xED, 0x97, 0xB6 },
	0xC267, { 0xED, 0x97, 0xB8 },
	0xC268, { 0xED, 0x97, 0xBA },
	0xC269, { 0xED, 0x97, 0xBB },
	0xC26A, { 0xED, 0x97, 0xBC },
	0xC26B, { 0xED, 0x97, 0xBD },
	0xC26C, { 0xED, 0x97, 0xBE },
	0xC26D, { 0xED, 0x97, 0xBF },
	0xC26E, { 0xED, 0x98, 0x82 },
	0xC26F, { 0xED, 0x98, 0x83 },
	0xC270, { 0xED, 0x98, 0x85 },
	0xC271, { 0xED, 0x98, 0x86 },
	0xC272, { 0xED, 0x98, 0x87 },
	0xC273, { 0xED, 0x98, 0x89 },
	0xC274, { 0xED, 0x98, 0x8A },
	0xC275, { 0xED, 0x98, 0x8B },
	0xC276, { 0xED, 0x98, 0x8C },
	0xC277, { 0xED, 0x98, 0x8D },
	0xC278, { 0xED, 0x98, 0x8E },
	0xC279, { 0xED, 0x98, 0x8F },
	0xC27A, { 0xED, 0x98, 0x92 },
	0xC281, { 0xED, 0x98, 0x96 },
	0xC282, { 0xED, 0x98, 0x97 },
	0xC283, { 0xED, 0x98, 0x98 },
	0xC284, { 0xED, 0x98, 0x99 },
	0xC285, { 0xED, 0x98, 0x9A },
	0xC286, { 0xED, 0x98, 0x9B },
	0xC287, { 0xED, 0x98, 0x9D },
	0xC288, { 0xED, 0x98, 0x9E },
	0xC289, { 0xED, 0x98, 0x9F },
	0xC28A, { 0xED, 0x98, 0xA1 },
	0xC28B, { 0xED, 0x98, 0xA2 },
	0xC28C, { 0xED, 0x98, 0xA3 },
	0xC28D, { 0xED, 0x98, 0xA5 },
	0xC28E, { 0xED, 0x98, 0xA6 },
	0xC28F, { 0xED, 0x98, 0xA7 },
	0xC290, { 0xED, 0x98, 0xA8 },
	0xC291, { 0xED, 0x98, 0xA9 },
	0xC292, { 0xED, 0x98, 0xAA },
	0xC293, { 0xED, 0x98, 0xAB },
	0xC294, { 0xED, 0x98, 0xAC },
	0xC295, { 0xED, 0x98, 0xAE },
	0xC296, { 0xED, 0x98, 0xAF },
	0xC297, { 0xED, 0x98, 0xB0 },
	0xC298, { 0xED, 0x98, 0xB1 },
	0xC299, { 0xED, 0x98, 0xB2 },
	0xC29A, { 0xED, 0x98, 0xB3 },
	0xC29B, { 0xED, 0x98, 0xB4 },
	0xC29C, { 0xED, 0x98, 0xB5 },
	0xC29D, { 0xED, 0x98, 0xB6 },
	0xC29E, { 0xED, 0x98, 0xB7 },
	0xC29F, { 0xED, 0x98, 0xBA },
	0xC2A0, { 0xED, 0x98, 0xBB },
	0xC2A1, { 0xEC, 0xA7, 0x95 },
	0xC2A2, { 0xEC, 0xA7, 0x96 },
	0xC2A3, { 0xEC, 0xA7, 0x99 },
	0xC2A4, { 0xEC, 0xA7, 0x9A },
	0xC2A5, { 0xEC, 0xA7, 0x9C },
	0xC2A6, { 0xEC, 0xA7, 0x9D },
	0xC2A7, { 0xEC, 0xA7, 0xA0 },
	0xC2A8, { 0xEC, 0xA7, 0xA2 },
	0xC2A9, { 0xEC, 0xA7, 0xA4 },
	0xC2AA, { 0xEC, 0xA7, 0xA7 },
	0xC2AB, { 0xEC, 0xA7, 0xAC },
	0xC2AC, { 0xEC, 0xA7, 0xAD },
	0xC2AD, { 0xEC, 0xA7, 0xAF },
	0xC2AE, { 0xEC, 0xA7, 0xB0 },
	0xC2AF, { 0xEC, 0xA7, 0xB1 },
	0xC2B0, { 0xEC, 0xA7, 0xB8 },
	0xC2B1, { 0xEC, 0xA7, 0xB9 },
	0xC2B2, { 0xEC, 0xA7, 0xBC },
	0xC2B3, { 0xEC, 0xA8, 0x80 },
	0xC2B4, { 0xEC, 0xA8, 0x88 },
	0xC2B5, { 0xEC, 0xA8, 0x89 },
	0xC2B6, { 0xEC, 0xA8, 0x8B },
	0xC2B7, { 0xEC, 0xA8, 0x8C },
	0xC2B8, { 0xEC, 0xA8, 0x8D },
	0xC2B9, { 0xEC, 0xA8, 0x94 },
	0xC2BA, { 0xEC, 0xA8, 0x98 },
	0xC2BB, { 0xEC, 0xA8, 0xA9 },
	0xC2BC, { 0xEC, 0xA9, 0x8C },
	0xC2BD, { 0xEC, 0xA9, 0x8D },
	0xC2BE, { 0xEC, 0xA9, 0x90 },
	0xC2BF, { 0xEC, 0xA9, 0x94 },
	0xC2C0, { 0xEC, 0xA9, 0x9C },
	0xC2C1, { 0xEC, 0xA9, 0x9D },
	0xC2C2, { 0xEC, 0xA9, 0x9F },
	0xC2C3, { 0xEC, 0xA9, 0xA0 },
	0xC2C4, { 0xEC, 0xA9, 0xA1 },
	0xC2C5, { 0xEC, 0xA9, 0xA8 },
	0xC2C6, { 0xEC, 0xA9, 0xBD },
	0xC2C7, { 0xEC, 0xAA, 0x84 },
	0xC2C8, { 0xEC, 0xAA, 0x98 },
	0xC2C9, { 0xEC, 0xAA, 0xBC },
	0xC2CA, { 0xEC, 0xAA, 0xBD },
	0xC2CB, { 0xEC, 0xAB, 0x80 },
	0xC2CC, { 0xEC, 0xAB, 0x84 },
	0xC2CD, { 0xEC, 0xAB, 0x8C },
	0xC2CE, { 0xEC, 0xAB, 0x8D },
	0xC2CF, { 0xEC, 0xAB, 0x8F },
	0xC2D0, { 0xEC, 0xAB, 0x91 },
	0xC2D1, { 0xEC, 0xAB, 0x93 },
	0xC2D2, { 0xEC, 0xAB, 0x98 },
	0xC2D3, { 0xEC, 0xAB, 0x99 },
	0xC2D4, { 0xEC, 0xAB, 0xA0 },
	0xC2D5, { 0xEC, 0xAB, 0xAC },
	0xC2D6, { 0xEC, 0xAB, 0xB4 },
	0xC2D7, { 0xEC, 0xAC, 0x88 },
	0xC2D8, { 0xEC, 0xAC, 0x90 },
	0xC2D9, { 0xEC, 0xAC, 0x94 },
	0xC2DA, { 0xEC, 0xAC, 0x98 },
	0xC2DB, { 0xEC, 0xAC, 0xA0 },
	0xC2DC, { 0xEC, 0xAC, 0xA1 },
	0xC2DD, { 0xEC, 0xAD, 0x81 },
	0xC2DE, { 0xEC, 0xAD, 0x88 },
	0xC2DF, { 0xEC, 0xAD, 0x89 },
	0xC2E0, { 0xEC, 0xAD, 0x8C },
	0xC2E1, { 0xEC, 0xAD, 0x90 },
	0xC2E2, { 0xEC, 0xAD, 0x98 },
	0xC2E3, { 0xEC, 0xAD, 0x99 },
	0xC2E4, { 0xEC, 0xAD, 0x9D },
	0xC2E5, { 0xEC, 0xAD, 0xA4 },
	0xC2E6, { 0xEC, 0xAD, 0xB8 },
	0xC2E7, { 0xEC, 0xAD, 0xB9 },
	0xC2E8, { 0xEC, 0xAE, 0x9C },
	0xC2E9, { 0xEC, 0xAE, 0xB8 },
	0xC2EA, { 0xEC, 0xAF, 0x94 },
	0xC2EB, { 0xEC, 0xAF, 0xA4 },
	0xC2EC, { 0xEC, 0xAF, 0xA7 },
	0xC2ED, { 0xEC, 0xAF, 0xA9 },
	0xC2EE, { 0xEC, 0xB0, 0x8C },
	0xC2EF, { 0xEC, 0xB0, 0x8D },
	0xC2F0, { 0xEC, 0xB0, 0x90 },
	0xC2F1, { 0xEC, 0xB0, 0x94 },
	0xC2F2, { 0xEC, 0xB0, 0x9C },
	0xC2F3, { 0xEC, 0xB0, 0x9D },
	0xC2F4, { 0xEC, 0xB0, 0xA1 },
	0xC2F5, { 0xEC, 0xB0, 0xA2 },
	0xC2F6, { 0xEC, 0xB0, 0xA7 },
	0xC2F7, { 0xEC, 0xB0, 0xA8 },
	0xC2F8, { 0xEC, 0xB0, 0xA9 },
	0xC2F9, { 0xEC, 0xB0, 0xAC },
	0xC2FA, { 0xEC, 0xB0, 0xAE },
	0xC2FB, { 0xEC, 0xB0, 0xB0 },
	0xC2FC, { 0xEC, 0xB0, 0xB8 },
	0xC2FD, { 0xEC, 0xB0, 0xB9 },
	0xC2FE, { 0xEC, 0xB0, 0xBB },
	0xC341, { 0xED, 0x98, 0xBD },
	0xC342, { 0xED, 0x98, 0xBE },
	0xC343, { 0xED, 0x98, 0xBF },
	0xC344, { 0xED, 0x99, 0x81 },
	0xC345, { 0xED, 0x99, 0x82 },
	0xC346, { 0xED, 0x99, 0x83 },
	0xC347, { 0xED, 0x99, 0x84 },
	0xC348, { 0xED, 0x99, 0x86 },
	0xC349, { 0xED, 0x99, 0x87 },
	0xC34A, { 0xED, 0x99, 0x8A },
	0xC34B, { 0xED, 0x99, 0x8C },
	0xC34C, { 0xED, 0x99, 0x8E },
	0xC34D, { 0xED, 0x99, 0x8F },
	0xC34E, { 0xED, 0x99, 0x90 },
	0xC34F, { 0xED, 0x99, 0x92 },
	0xC350, { 0xED, 0x99, 0x93 },
	0xC351, { 0xED, 0x99, 0x96 },
	0xC352, { 0xED, 0x99, 0x97 },
	0xC353, { 0xED, 0x99, 0x99 },
	0xC354, { 0xED, 0x99, 0x9A },
	0xC355, { 0xED, 0x99, 0x9B },
	0xC356, { 0xED, 0x99, 0x9D },
	0xC357, { 0xED, 0x99, 0x9E },
	0xC358, { 0xED, 0x99, 0x9F },
	0xC359, { 0xED, 0x99, 0xA0 },
	0xC35A, { 0xED, 0x99, 0xA1 },
	0xC361, { 0xED, 0x99, 0xA2 },
	0xC362, { 0xED, 0x99, 0xA3 },
	0xC363, { 0xED, 0x99, 0xA4 },
	0xC364, { 0xED, 0x99, 0xA5 },
	0xC365, { 0xED, 0x99, 0xA6 },
	0xC366, { 0xED, 0x99, 0xA8 },
	0xC367, { 0xED, 0x99, 0xAA },
	0xC368, { 0xED, 0x99, 0xAB },
	0xC369, { 0xED, 0x99, 0xAC },
	0xC36A, { 0xED, 0x99, 0xAD },
	0xC36B, { 0xED, 0x99, 0xAE },
	0xC36C, { 0xED, 0x99, 0xAF },
	0xC36D, { 0xED, 0x99, 0xB2 },
	0xC36E, { 0xED, 0x99, 0xB3 },
	0xC36F, { 0xED, 0x99, 0xB5 },
	0xC370, { 0xED, 0x99, 0xB6 },
	0xC371, { 0xED, 0x99, 0xB7 },
	0xC372, { 0xED, 0x99, 0xB8 },
	0xC373, { 0xED, 0x99, 0xB9 },
	0xC374, { 0xED, 0x99, 0xBA },
	0xC375, { 0xED, 0x99, 0xBB },
	0xC376, { 0xED, 0x99, 0xBC },
	0xC377, { 0xED, 0x99, 0xBD },
	0xC378, { 0xED, 0x99, 0xBE },
	0xC379, { 0xED, 0x99, 0xBF },
	0xC37A, { 0xED, 0x9A, 0x80 },
	0xC381, { 0xED, 0x9A, 0x81 },
	0xC382, { 0xED, 0x9A, 0x82 },
	0xC383, { 0xED, 0x9A, 0x84 },
	0xC384, { 0xED, 0x9A, 0x86 },
	0xC385, { 0xED, 0x9A, 0x87 },
	0xC386, { 0xED, 0x9A, 0x88 },
	0xC387, { 0xED, 0x9A, 0x89 },
	0xC388, { 0xED, 0x9A, 0x8A },
	0xC389, { 0xED, 0x9A, 0x8B },
	0xC38A, { 0xED, 0x9A, 0x8E },
	0xC38B, { 0xED, 0x9A, 0x8F },
	0xC38C, { 0xED, 0x9A, 0x91 },
	0xC38D, { 0xED, 0x9A, 0x92 },
	0xC38E, { 0xED, 0x9A, 0x93 },
	0xC38F, { 0xED, 0x9A, 0x95 },
	0xC390, { 0xED, 0x9A, 0x96 },
	0xC391, { 0xED, 0x9A, 0x97 },
	0xC392, { 0xED, 0x9A, 0x98 },
	0xC393, { 0xED, 0x9A, 0x99 },
	0xC394, { 0xED, 0x9A, 0x9A },
	0xC395, { 0xED, 0x9A, 0x9B },
	0xC396, { 0xED, 0x9A, 0x9C },
	0xC397, { 0xED, 0x9A, 0x9E },
	0xC398, { 0xED, 0x9A, 0xA0 },
	0xC399, { 0xED, 0x9A, 0xA2 },
	0xC39A, { 0xED, 0x9A, 0xA3 },
	0xC39B, { 0xED, 0x9A, 0xA4 },
	0xC39C, { 0xED, 0x9A, 0xA5 },
	0xC39D, { 0xED, 0x9A, 0xA6 },
	0xC39E, { 0xED, 0x9A, 0xA7 },
	0xC39F, { 0xED, 0x9A, 0xA9 },
	0xC3A0, { 0xED, 0x9A, 0xAA },
	0xC3A1, { 0xEC, 0xB0, 0xBC },
	0xC3A2, { 0xEC, 0xB0, 0xBD },
	0xC3A3, { 0xEC, 0xB0, 0xBE },
	0xC3A4, { 0xEC, 0xB1, 0x84 },
	0xC3A5, { 0xEC, 0xB1, 0x85 },
	0xC3A6, { 0xEC, 0xB1, 0x88 },
	0xC3A7, { 0xEC, 0xB1, 0x8C },
	0xC3A8, { 0xEC, 0xB1, 0x94 },
	0xC3A9, { 0xEC, 0xB1, 0x95 },
	0xC3AA, { 0xEC, 0xB1, 0x97 },
	0xC3AB, { 0xEC, 0xB1, 0x98 },
	0xC3AC, { 0xEC, 0xB1, 0x99 },
	0xC3AD, { 0xEC, 0xB1, 0xA0 },
	0xC3AE, { 0xEC, 0xB1, 0xA4 },
	0xC3AF, { 0xEC, 0xB1, 0xA6 },
	0xC3B0, { 0xEC, 0xB1, 0xA8 },
	0xC3B1, { 0xEC, 0xB1, 0xB0 },
	0xC3B2, { 0xEC, 0xB1, 0xB5 },
	0xC3B3, { 0xEC, 0xB2, 0x98 },
	0xC3B4, { 0xEC, 0xB2, 0x99 },
	0xC3B5, { 0xEC, 0xB2, 0x9C },
	0xC3B6, { 0xEC, 0xB2, 0xA0 },
	0xC3B7, { 0xEC, 0xB2, 0xA8 },
	0xC3B8, { 0xEC, 0xB2, 0xA9 },
	0xC3B9, { 0xEC, 0xB2, 0xAB },
	0xC3BA, { 0xEC, 0xB2, 0xAC },
	0xC3BB, { 0xEC, 0xB2, 0xAD },
	0xC3BC, { 0xEC, 0xB2, 0xB4 },
	0xC3BD, { 0xEC, 0xB2, 0xB5 },
	0xC3BE, { 0xEC, 0xB2, 0xB8 },
	0xC3BF, { 0xEC, 0xB2, 0xBC },
	0xC3C0, { 0xEC, 0xB3, 0x84 },
	0xC3C1, { 0xEC, 0xB3, 0x85 },
	0xC3C2, { 0xEC, 0xB3, 0x87 },
	0xC3C3, { 0xEC, 0xB3, 0x89 },
	0xC3C4, { 0xEC, 0xB3, 0x90 },
	0xC3C5, { 0xEC, 0xB3, 0x94 },
	0xC3C6, { 0xEC, 0xB3, 0xA4 },
	0xC3C7, { 0xEC, 0xB3, 0xAC },
	0xC3C8, { 0xEC, 0xB3, 0xB0 },
	0xC3C9, { 0xEC, 0xB4, 0x81 },
	0xC3CA, { 0xEC, 0xB4, 0x88 },
	0xC3CB, { 0xEC, 0xB4, 0x89 },
	0xC3CC, { 0xEC, 0xB4, 0x8C },
	0xC3CD, { 0xEC, 0xB4, 0x90 },
	0xC3CE, { 0xEC, 0xB4, 0x98 },
	0xC3CF, { 0xEC, 0xB4, 0x99 },
	0xC3D0, { 0xEC, 0xB4, 0x9B },
	0xC3D1, { 0xEC, 0xB4, 0x9D },
	0xC3D2, { 0xEC, 0xB4, 0xA4 },
	0xC3D3, { 0xEC, 0xB4, 0xA8 },
	0xC3D4, { 0xEC, 0xB4, 0xAC },
	0xC3D5, { 0xEC, 0xB4, 0xB9 },
	0xC3D6, { 0xEC, 0xB5, 0x9C },
	0xC3D7, { 0xEC, 0xB5, 0xA0 },
	0xC3D8, { 0xEC, 0xB5, 0xA4 },
	0xC3D9, { 0xEC, 0xB5, 0xAC },
	0xC3DA, { 0xEC, 0xB5, 0xAD },
	0xC3DB, { 0xEC, 0xB5, 0xAF },
	0xC3DC, { 0xEC, 0xB5, 0xB1 },
	0xC3DD, { 0xEC, 0xB5, 0xB8 },
	0xC3DE, { 0xEC, 0xB6, 0x88 },
	0xC3DF, { 0xEC, 0xB6, 0x94 },
	0xC3E0, { 0xEC, 0xB6, 0x95 },
	0xC3E1, { 0xEC, 0xB6, 0x98 },
	0xC3E2, { 0xEC, 0xB6, 0x9C },
	0xC3E3, { 0xEC, 0xB6, 0xA4 },
	0xC3E4, { 0xEC, 0xB6, 0xA5 },
	0xC3E5, { 0xEC, 0xB6, 0xA7 },
	0xC3E6, { 0xEC, 0xB6, 0xA9 },
	0xC3E7, { 0xEC, 0xB6, 0xB0 },
	0xC3E8, { 0xEC, 0xB7, 0x84 },
	0xC3E9, { 0xEC, 0xB7, 0x8C },
	0xC3EA, { 0xEC, 0xB7, 0x90 },
	0xC3EB, { 0xEC, 0xB7, 0xA8 },
	0xC3EC, { 0xEC, 0xB7, 0xAC },
	0xC3ED, { 0xEC, 0xB7, 0xB0 },
	0xC3EE, { 0xEC, 0xB7, 0xB8 },
	0xC3EF, { 0xEC, 0xB7, 0xB9 },
	0xC3F0, { 0xEC, 0xB7, 0xBB },
	0xC3F1, { 0xEC, 0xB7, 0xBD },
	0xC3F2, { 0xEC, 0xB8, 0x84 },
	0xC3F3, { 0xEC, 0xB8, 0x88 },
	0xC3F4, { 0xEC, 0xB8, 0x8C },
	0xC3F5, { 0xEC, 0xB8, 0x94 },
	0xC3F6, { 0xEC, 0xB8, 0x99 },
	0xC3F7, { 0xEC, 0xB8, 0xA0 },
	0xC3F8, { 0xEC, 0xB8, 0xA1 },
	0xC3F9, { 0xEC, 0xB8, 0xA4 },
	0xC3FA, { 0xEC, 0xB8, 0xA8 },
	0xC3FB, { 0xEC, 0xB8, 0xB0 },
	0xC3FC, { 0xEC, 0xB8, 0xB1 },
	0xC3FD, { 0xEC, 0xB8, 0xB3 },
	0xC3FE, { 0xEC, 0xB8, 0xB5 },
	0xC441, { 0xED, 0x9A, 0xAB },
	0xC442, { 0xED, 0x9A, 0xAD },
	0xC443, { 0xED, 0x9A, 0xAE },
	0xC444, { 0xED, 0x9A, 0xAF },
	0xC445, { 0xED, 0x9A, 0xB1 },
	0xC446, { 0xED, 0x9A, 0xB2 },
	0xC447, { 0xED, 0x9A, 0xB3 },
	0xC448, { 0xED, 0x9A, 0xB4 },
	0xC449, { 0xED, 0x9A, 0xB5 },
	0xC44A, { 0xED, 0x9A, 0xB6 },
	0xC44B, { 0xED, 0x9A, 0xB7 },
	0xC44C, { 0xED, 0x9A, 0xB8 },
	0xC44D, { 0xED, 0x9A, 0xBA },
	0xC44E, { 0xED, 0x9A, 0xBC },
	0xC44F, { 0xED, 0x9A, 0xBD },
	0xC450, { 0xED, 0x9A, 0xBE },
	0xC451, { 0xED, 0x9A, 0xBF },
	0xC452, { 0xED, 0x9B, 0x80 },
	0xC453, { 0xED, 0x9B, 0x81 },
	0xC454, { 0xED, 0x9B, 0x82 },
	0xC455, { 0xED, 0x9B, 0x83 },
	0xC456, { 0xED, 0x9B, 0x86 },
	0xC457, { 0xED, 0x9B, 0x87 },
	0xC458, { 0xED, 0x9B, 0x89 },
	0xC459, { 0xED, 0x9B, 0x8A },
	0xC45A, { 0xED, 0x9B, 0x8B },
	0xC461, { 0xED, 0x9B, 0x8D },
	0xC462, { 0xED, 0x9B, 0x8E },
	0xC463, { 0xED, 0x9B, 0x8F },
	0xC464, { 0xED, 0x9B, 0x90 },
	0xC465, { 0xED, 0x9B, 0x92 },
	0xC466, { 0xED, 0x9B, 0x93 },
	0xC467, { 0xED, 0x9B, 0x95 },
	0xC468, { 0xED, 0x9B, 0x96 },
	0xC469, { 0xED, 0x9B, 0x98 },
	0xC46A, { 0xED, 0x9B, 0x9A },
	0xC46B, { 0xED, 0x9B, 0x9B },
	0xC46C, { 0xED, 0x9B, 0x9C },
	0xC46D, { 0xED, 0x9B, 0x9D },
	0xC46E, { 0xED, 0x9B, 0x9E },
	0xC46F, { 0xED, 0x9B, 0x9F },
	0xC470, { 0xED, 0x9B, 0xA1 },
	0xC471, { 0xED, 0x9B, 0xA2 },
	0xC472, { 0xED, 0x9B, 0xA3 },
	0xC473, { 0xED, 0x9B, 0xA5 },
	0xC474, { 0xED, 0x9B, 0xA6 },
	0xC475, { 0xED, 0x9B, 0xA7 },
	0xC476, { 0xED, 0x9B, 0xA9 },
	0xC477, { 0xED, 0x9B, 0xAA },
	0xC478, { 0xED, 0x9B, 0xAB },
	0xC479, { 0xED, 0x9B, 0xAC },
	0xC47A, { 0xED, 0x9B, 0xAD },
	0xC481, { 0xED, 0x9B, 0xAE },
	0xC482, { 0xED, 0x9B, 0xAF },
	0xC483, { 0xED, 0x9B, 0xB1 },
	0xC484, { 0xED, 0x9B, 0xB2 },
	0xC485, { 0xED, 0x9B, 0xB3 },
	0xC486, { 0xED, 0x9B, 0xB4 },
	0xC487, { 0xED, 0x9B, 0xB6 },
	0xC488, { 0xED, 0x9B, 0xB7 },
	0xC489, { 0xED, 0x9B, 0xB8 },
	0xC48A, { 0xED, 0x9B, 0xB9 },
	0xC48B, { 0xED, 0x9B, 0xBA },
	0xC48C, { 0xED, 0x9B, 0xBB },
	0xC48D, { 0xED, 0x9B, 0xBE },
	0xC48E, { 0xED, 0x9B, 0xBF },
	0xC48F, { 0xED, 0x9C, 0x81 },
	0xC490, { 0xED, 0x9C, 0x82 },
	0xC491, { 0xED, 0x9C, 0x83 },
	0xC492, { 0xED, 0x9C, 0x85 },
	0xC493, { 0xED, 0x9C, 0x86 },
	0xC494, { 0xED, 0x9C, 0x87 },
	0xC495, { 0xED, 0x9C, 0x88 },
	0xC496, { 0xED, 0x9C, 0x89 },
	0xC497, { 0xED, 0x9C, 0x8A },
	0xC498, { 0xED, 0x9C, 0x8B },
	0xC499, { 0xED, 0x9C, 0x8C },
	0xC49A, { 0xED, 0x9C, 0x8D },
	0xC49B, { 0xED, 0x9C, 0x8E },
	0xC49C, { 0xED, 0x9C, 0x8F },
	0xC49D, { 0xED, 0x9C, 0x90 },
	0xC49E, { 0xED, 0x9C, 0x92 },
	0xC49F, { 0xED, 0x9C, 0x93 },
	0xC4A0, { 0xED, 0x9C, 0x94 },
	0xC4A1, { 0xEC, 0xB9, 0x98 },
	0xC4A2, { 0xEC, 0xB9, 0x99 },
	0xC4A3, { 0xEC, 0xB9, 0x9C },
	0xC4A4, { 0xEC, 0xB9, 0x9F },
	0xC4A5, { 0xEC, 0xB9, 0xA0 },
	0xC4A6, { 0xEC, 0xB9, 0xA1 },
	0xC4A7, { 0xEC, 0xB9, 0xA8 },
	0xC4A8, { 0xEC, 0xB9, 0xA9 },
	0xC4A9, { 0xEC, 0xB9, 0xAB },
	0xC4AA, { 0xEC, 0xB9, 0xAD },
	0xC4AB, { 0xEC, 0xB9, 0xB4 },
	0xC4AC, { 0xEC, 0xB9, 0xB5 },
	0xC4AD, { 0xEC, 0xB9, 0xB8 },
	0xC4AE, { 0xEC, 0xB9, 0xBC },
	0xC4AF, { 0xEC, 0xBA, 0x84 },
	0xC4B0, { 0xEC, 0xBA, 0x85 },
	0xC4B1, { 0xEC, 0xBA, 0x87 },
	0xC4B2, { 0xEC, 0xBA, 0x89 },
	0xC4B3, { 0xEC, 0xBA, 0x90 },
	0xC4B4, { 0xEC, 0xBA, 0x91 },
	0xC4B5, { 0xEC, 0xBA, 0x94 },
	0xC4B6, { 0xEC, 0xBA, 0x98 },
	0xC4B7, { 0xEC, 0xBA, 0xA0 },
	0xC4B8, { 0xEC, 0xBA, 0xA1 },
	0xC4B9, { 0xEC, 0xBA, 0xA3 },
	0xC4BA, { 0xEC, 0xBA, 0xA4 },
	0xC4BB, { 0xEC, 0xBA, 0xA5 },
	0xC4BC, { 0xEC, 0xBA, 0xAC },
	0xC4BD, { 0xEC, 0xBA, 0xAD },
	0xC4BE, { 0xEC, 0xBB, 0x81 },
	0xC4BF, { 0xEC, 0xBB, 0xA4 },
	0xC4C0, { 0xEC, 0xBB, 0xA5 },
	0xC4C1, { 0xEC, 0xBB, 0xA8 },
	0xC4C2, { 0xEC, 0xBB, 0xAB },
	0xC4C3, { 0xEC, 0xBB, 0xAC },
	0xC4C4, { 0xEC, 0xBB, 0xB4 },
	0xC4C5, { 0xEC, 0xBB, 0xB5 },
	0xC4C6, { 0xEC, 0xBB, 0xB7 },
	0xC4C7, { 0xEC, 0xBB, 0xB8 },
	0xC4C8, { 0xEC, 0xBB, 0xB9 },
	0xC4C9, { 0xEC, 0xBC, 0x80 },
	0xC4CA, { 0xEC, 0xBC, 0x81 },
	0xC4CB, { 0xEC, 0xBC, 0x84 },
	0xC4CC, { 0xEC, 0xBC, 0x88 },
	0xC4CD, { 0xEC, 0xBC, 0x90 },
	0xC4CE, { 0xEC, 0xBC, 0x91 },
	0xC4CF, { 0xEC, 0xBC, 0x93 },
	0xC4D0, { 0xEC, 0xBC, 0x95 },
	0xC4D1, { 0xEC, 0xBC, 0x9C },
	0xC4D2, { 0xEC, 0xBC, 0xA0 },
	0xC4D3, { 0xEC, 0xBC, 0xA4 },
	0xC4D4, { 0xEC, 0xBC, 0xAC },
	0xC4D5, { 0xEC, 0xBC, 0xAD },
	0xC4D6, { 0xEC, 0xBC, 0xAF },
	0xC4D7, { 0xEC, 0xBC, 0xB0 },
	0xC4D8, { 0xEC, 0xBC, 0xB1 },
	0xC4D9, { 0xEC, 0xBC, 0xB8 },
	0xC4DA, { 0xEC, 0xBD, 0x94 },
	0xC4DB, { 0xEC, 0xBD, 0x95 },
	0xC4DC, { 0xEC, 0xBD, 0x98 },
	0xC4DD, { 0xEC, 0xBD, 0x9C },
	0xC4DE, { 0xEC, 0xBD, 0xA4 },
	0xC4DF, { 0xEC, 0xBD, 0xA5 },
	0xC4E0, { 0xEC, 0xBD, 0xA7 },
	0xC4E1, { 0xEC, 0xBD, 0xA9 },
	0xC4E2, { 0xEC, 0xBD, 0xB0 },
	0xC4E3, { 0xEC, 0xBD, 0xB1 },
	0xC4E4, { 0xEC, 0xBD, 0xB4 },
	0xC4E5, { 0xEC, 0xBD, 0xB8 },
	0xC4E6, { 0xEC, 0xBE, 0x80 },
	0xC4E7, { 0xEC, 0xBE, 0x85 },
	0xC4E8, { 0xEC, 0xBE, 0x8C },
	0xC4E9, { 0xEC, 0xBE, 0xA1 },
	0xC4EA, { 0xEC, 0xBE, 0xA8 },
	0xC4EB, { 0xEC, 0xBE, 0xB0 },
	0xC4EC, { 0xEC, 0xBF, 0x84 },
	0xC4ED, { 0xEC, 0xBF, 0xA0 },
	0xC4EE, { 0xEC, 0xBF, 0xA1 },
	0xC4EF, { 0xEC, 0xBF, 0xA4 },
	0xC4F0, { 0xEC, 0xBF, 0xA8 },
	0xC4F1, { 0xEC, 0xBF, 0xB0 },
	0xC4F2, { 0xEC, 0xBF, 0xB1 },
	0xC4F3, { 0xEC, 0xBF, 0xB3 },
	0xC4F4, { 0xEC, 0xBF, 0xB5 },
	0xC4F5, { 0xEC, 0xBF, 0xBC },
	0xC4F6, { 0xED, 0x80, 0x80 },
	0xC4F7, { 0xED, 0x80, 0x84 },
	0xC4F8, { 0xED, 0x80, 0x91 },
	0xC4F9, { 0xED, 0x80, 0x98 },
	0xC4FA, { 0xED, 0x80, 0xAD },
	0xC4FB, { 0xED, 0x80, 0xB4 },
	0xC4FC, { 0xED, 0x80, 0xB5 },
	0xC4FD, { 0xED, 0x80, 0xB8 },
	0xC4FE, { 0xED, 0x80, 0xBC },
	0xC541, { 0xED, 0x9C, 0x95 },
	0xC542, { 0xED, 0x9C, 0x96 },
	0xC543, { 0xED, 0x9C, 0x97 },
	0xC544, { 0xED, 0x9C, 0x9A },
	0xC545, { 0xED, 0x9C, 0x9B },
	0xC546, { 0xED, 0x9C, 0x9D },
	0xC547, { 0xED, 0x9C, 0x9E },
	0xC548, { 0xED, 0x9C, 0x9F },
	0xC549, { 0xED, 0x9C, 0xA1 },
	0xC54A, { 0xED, 0x9C, 0xA2 },
	0xC54B, { 0xED, 0x9C, 0xA3 },
	0xC54C, { 0xED, 0x9C, 0xA4 },
	0xC54D, { 0xED, 0x9C, 0xA5 },
	0xC54E, { 0xED, 0x9C, 0xA6 },
	0xC54F, { 0xED, 0x9C, 0xA7 },
	0xC550, { 0xED, 0x9C, 0xAA },
	0xC551, { 0xED, 0x9C, 0xAC },
	0xC552, { 0xED, 0x9C, 0xAE },
	0xC553, { 0xED, 0x9C, 0xAF },
	0xC554, { 0xED, 0x9C, 0xB0 },
	0xC555, { 0xED, 0x9C, 0xB1 },
	0xC556, { 0xED, 0x9C, 0xB2 },
	0xC557, { 0xED, 0x9C, 0xB3 },
	0xC558, { 0xED, 0x9C, 0xB6 },
	0xC559, { 0xED, 0x9C, 0xB7 },
	0xC55A, { 0xED, 0x9C, 0xB9 },
	0xC561, { 0xED, 0x9C, 0xBA },
	0xC562, { 0xED, 0x9C, 0xBB },
	0xC563, { 0xED, 0x9C, 0xBD },
	0xC564, { 0xED, 0x9C, 0xBE },
	0xC565, { 0xED, 0x9C, 0xBF },
	0xC566, { 0xED, 0x9D, 0x80 },
	0xC567, { 0xED, 0x9D, 0x81 },
	0xC568, { 0xED, 0x9D, 0x82 },
	0xC569, { 0xED, 0x9D, 0x83 },
	0xC56A, { 0xED, 0x9D, 0x85 },
	0xC56B, { 0xED, 0x9D, 0x86 },
	0xC56C, { 0xED, 0x9D, 0x88 },
	0xC56D, { 0xED, 0x9D, 0x8A },
	0xC56E, { 0xED, 0x9D, 0x8B },
	0xC56F, { 0xED, 0x9D, 0x8C },
	0xC570, { 0xED, 0x9D, 0x8D },
	0xC571, { 0xED, 0x9D, 0x8E },
	0xC572, { 0xED, 0x9D, 0x8F },
	0xC573, { 0xED, 0x9D, 0x92 },
	0xC574, { 0xED, 0x9D, 0x93 },
	0xC575, { 0xED, 0x9D, 0x95 },
	0xC576, { 0xED, 0x9D, 0x9A },
	0xC577, { 0xED, 0x9D, 0x9B },
	0xC578, { 0xED, 0x9D, 0x9C },
	0xC579, { 0xED, 0x9D, 0x9D },
	0xC57A, { 0xED, 0x9D, 0x9E },
	0xC581, { 0xED, 0x9D, 0x9F },
	0xC582, { 0xED, 0x9D, 0xA2 },
	0xC583, { 0xED, 0x9D, 0xA4 },
	0xC584, { 0xED, 0x9D, 0xA6 },
	0xC585, { 0xED, 0x9D, 0xA7 },
	0xC586, { 0xED, 0x9D, 0xA8 },
	0xC587, { 0xED, 0x9D, 0xAA },
	0xC588, { 0xED, 0x9D, 0xAB },
	0xC589, { 0xED, 0x9D, 0xAD },
	0xC58A, { 0xED, 0x9D, 0xAE },
	0xC58B, { 0xED, 0x9D, 0xAF },
	0xC58C, { 0xED, 0x9D, 0xB1 },
	0xC58D, { 0xED, 0x9D, 0xB2 },
	0xC58E, { 0xED, 0x9D, 0xB3 },
	0xC58F, { 0xED, 0x9D, 0xB5 },
	0xC590, { 0xED, 0x9D, 0xB6 },
	0xC591, { 0xED, 0x9D, 0xB7 },
	0xC592, { 0xED, 0x9D, 0xB8 },
	0xC593, { 0xED, 0x9D, 0xB9 },
	0xC594, { 0xED, 0x9D, 0xBA },
	0xC595, { 0xED, 0x9D, 0xBB },
	0xC596, { 0xED, 0x9D, 0xBE },
	0xC597, { 0xED, 0x9D, 0xBF },
	0xC598, { 0xED, 0x9E, 0x80 },
	0xC599, { 0xED, 0x9E, 0x82 },
	0xC59A, { 0xED, 0x9E, 0x83 },
	0xC59B, { 0xED, 0x9E, 0x84 },
	0xC59C, { 0xED, 0x9E, 0x85 },
	0xC59D, { 0xED, 0x9E, 0x86 },
	0xC59E, { 0xED, 0x9E, 0x87 },
	0xC59F, { 0xED, 0x9E, 0x8A },
	0xC5A0, { 0xED, 0x9E, 0x8B },
	0xC5A1, { 0xED, 0x81, 0x84 },
	0xC5A2, { 0xED, 0x81, 0x85 },
	0xC5A3, { 0xED, 0x81, 0x87 },
	0xC5A4, { 0xED, 0x81, 0x89 },
	0xC5A5, { 0xED, 0x81, 0x90 },
	0xC5A6, { 0xED, 0x81, 0x94 },
	0xC5A7, { 0xED, 0x81, 0x98 },
	0xC5A8, { 0xED, 0x81, 0xA0 },
	0xC5A9, { 0xED, 0x81, 0xAC },
	0xC5AA, { 0xED, 0x81, 0xAD },
	0xC5AB, { 0xED, 0x81, 0xB0 },
	0xC5AC, { 0xED, 0x81, 0xB4 },
	0xC5AD, { 0xED, 0x81, 0xBC },
	0xC5AE, { 0xED, 0x81, 0xBD },
	0xC5AF, { 0xED, 0x82, 0x81 },
	0xC5B0, { 0xED, 0x82, 0xA4 },
	0xC5B1, { 0xED, 0x82, 0xA5 },
	0xC5B2, { 0xED, 0x82, 0xA8 },
	0xC5B3, { 0xED, 0x82, 0xAC },
	0xC5B4, { 0xED, 0x82, 0xB4 },
	0xC5B5, { 0xED, 0x82, 0xB5 },
	0xC5B6, { 0xED, 0x82, 0xB7 },
	0xC5B7, { 0xED, 0x82, 0xB9 },
	0xC5B8, { 0xED, 0x83, 0x80 },
	0xC5B9, { 0xED, 0x83, 0x81 },
	0xC5BA, { 0xED, 0x83, 0x84 },
	0xC5BB, { 0xED, 0x83, 0x88 },
	0xC5BC, { 0xED, 0x83, 0x89 },
	0xC5BD, { 0xED, 0x83, 0x90 },
	0xC5BE, { 0xED, 0x83, 0x91 },
	0xC5BF, { 0xED, 0x83, 0x93 },
	0xC5C0, { 0xED, 0x83, 0x94 },
	0xC5C1, { 0xED, 0x83, 0x95 },
	0xC5C2, { 0xED, 0x83, 0x9C },
	0xC5C3, { 0xED, 0x83, 0x9D },
	0xC5C4, { 0xED, 0x83, 0xA0 },
	0xC5C5, { 0xED, 0x83, 0xA4 },
	0xC5C6, { 0xED, 0x83, 0xAC },
	0xC5C7, { 0xED, 0x83, 0xAD },
	0xC5C8, { 0xED, 0x83, 0xAF },
	0xC5C9, { 0xED, 0x83, 0xB0 },
	0xC5CA, { 0xED, 0x83, 0xB1 },
	0xC5CB, { 0xED, 0x83, 0xB8 },
	0xC5CC, { 0xED, 0x84, 0x8D },
	0xC5CD, { 0xED, 0x84, 0xB0 },
	0xC5CE, { 0xED, 0x84, 0xB1 },
	0xC5CF, { 0xED, 0x84, 0xB4 },
	0xC5D0, { 0xED, 0x84, 0xB8 },
	0xC5D1, { 0xED, 0x84, 0xBA },
	0xC5D2, { 0xED, 0x85, 0x80 },
	0xC5D3, { 0xED, 0x85, 0x81 },
	0xC5D4, { 0xED, 0x85, 0x83 },
	0xC5D5, { 0xED, 0x85, 0x84 },
	0xC5D6, { 0xED, 0x85, 0x85 },
	0xC5D7, { 0xED, 0x85, 0x8C },
	0xC5D8, { 0xED, 0x85, 0x8D },
	0xC5D9, { 0xED, 0x85, 0x90 },
	0xC5DA, { 0xED, 0x85, 0x94 },
	0xC5DB, { 0xED, 0x85, 0x9C },
	0xC5DC, { 0xED, 0x85, 0x9D },
	0xC5DD, { 0xED, 0x85, 0x9F },
	0xC5DE, { 0xED, 0x85, 0xA1 },
	0xC5DF, { 0xED, 0x85, 0xA8 },
	0xC5E0, { 0xED, 0x85, 0xAC },
	0xC5E1, { 0xED, 0x85, 0xBC },
	0xC5E2, { 0xED, 0x86, 0x84 },
	0xC5E3, { 0xED, 0x86, 0x88 },
	0xC5E4, { 0xED, 0x86, 0xA0 },
	0xC5E5, { 0xED, 0x86, 0xA1 },
	0xC5E6, { 0xED, 0x86, 0xA4 },
	0xC5E7, { 0xED, 0x86, 0xA8 },
	0xC5E8, { 0xED, 0x86, 0xB0 },
	0xC5E9, { 0xED, 0x86, 0xB1 },
	0xC5EA, { 0xED, 0x86, 0xB3 },
	0xC5EB, { 0xED, 0x86, 0xB5 },
	0xC5EC, { 0xED, 0x86, 0xBA },
	0xC5ED, { 0xED, 0x86, 0xBC },
	0xC5EE, { 0xED, 0x87, 0x80 },
	0xC5EF, { 0xED, 0x87, 0x98 },
	0xC5F0, { 0xED, 0x87, 0xB4 },
	0xC5F1, { 0xED, 0x87, 0xB8 },
	0xC5F2, { 0xED, 0x88, 0x87 },
	0xC5F3, { 0xED, 0x88, 0x89 },
	0xC5F4, { 0xED, 0x88, 0x90 },
	0xC5F5, { 0xED, 0x88, 0xAC },
	0xC5F6, { 0xED, 0x88, 0xAD },
	0xC5F7, { 0xED, 0x88, 0xB0 },
	0xC5F8, { 0xED, 0x88, 0xB4 },
	0xC5F9, { 0xED, 0x88, 0xBC },
	0xC5FA, { 0xED, 0x88, 0xBD },
	0xC5FB, { 0xED, 0x88, 0xBF },
	0xC5FC, { 0xED, 0x89, 0x81 },
	0xC5FD, { 0xED, 0x89, 0x88 },
	0xC5FE, { 0xED, 0x89, 0x9C },
	0xC641, { 0xED, 0x9E, 0x8D },
	0xC642, { 0xED, 0x9E, 0x8E },
	0xC643, { 0xED, 0x9E, 0x8F },
	0xC644, { 0xED, 0x9E, 0x91 },
	0xC645, { 0xED, 0x9E, 0x92 },
	0xC646, { 0xED, 0x9E, 0x93 },
	0xC647, { 0xED, 0x9E, 0x94 },
	0xC648, { 0xED, 0x9E, 0x95 },
	0xC649, { 0xED, 0x9E, 0x96 },
	0xC64A, { 0xED, 0x9E, 0x97 },
	0xC64B, { 0xED, 0x9E, 0x9A },
	0xC64C, { 0xED, 0x9E, 0x9C },
	0xC64D, { 0xED, 0x9E, 0x9E },
	0xC64E, { 0xED, 0x9E, 0x9F },
	0xC64F, { 0xED, 0x9E, 0xA0 },
	0xC650, { 0xED, 0x9E, 0xA1 },
	0xC651, { 0xED, 0x9E, 0xA2 },
	0xC652, { 0xED, 0x9E, 0xA3 },
	0xC6A1, { 0xED, 0x89, 0xA4 },
	0xC6A2, { 0xED, 0x8A, 0x80 },
	0xC6A3, { 0xED, 0x8A, 0x81 },
	0xC6A4, { 0xED, 0x8A, 0x84 },
	0xC6A5, { 0xED, 0x8A, 0x88 },
	0xC6A6, { 0xED, 0x8A, 0x90 },
	0xC6A7, { 0xED, 0x8A, 0x91 },
	0xC6A8, { 0xED, 0x8A, 0x95 },
	0xC6A9, { 0xED, 0x8A, 0x9C },
	0xC6AA, { 0xED, 0x8A, 0xA0 },
	0xC6AB, { 0xED, 0x8A, 0xA4 },
	0xC6AC, { 0xED, 0x8A, 0xAC },
	0xC6AD, { 0xED, 0x8A, 0xB1 },
	0xC6AE, { 0xED, 0x8A, 0xB8 },
	0xC6AF, { 0xED, 0x8A, 0xB9 },
	0xC6B0, { 0xED, 0x8A, 0xBC },
	0xC6B1, { 0xED, 0x8A, 0xBF },
	0xC6B2, { 0xED, 0x8B, 0x80 },
	0xC6B3, { 0xED, 0x8B, 0x82 },
	0xC6B4, { 0xED, 0x8B, 0x88 },
	0xC6B5, { 0xED, 0x8B, 0x89 },
	0xC6B6, { 0xED, 0x8B, 0x8B },
	0xC6B7, { 0xED, 0x8B, 0x94 },
	0xC6B8, { 0xED, 0x8B, 0x98 },
	0xC6B9, { 0xED, 0x8B, 0x9C },
	0xC6BA, { 0xED, 0x8B, 0xA4 },
	0xC6BB, { 0xED, 0x8B, 0xA5 },
	0xC6BC, { 0xED, 0x8B, 0xB0 },
	0xC6BD, { 0xED, 0x8B, 0xB1 },
	0xC6BE, { 0xED, 0x8B, 0xB4 },
	0xC6BF, { 0xED, 0x8B, 0xB8 },
	0xC6C0, { 0xED, 0x8C, 0x80 },
	0xC6C1, { 0xED, 0x8C, 0x81 },
	0xC6C2, { 0xED, 0x8C, 0x83 },
	0xC6C3, { 0xED, 0x8C, 0x85 },
	0xC6C4, { 0xED, 0x8C, 0x8C },
	0xC6C5, { 0xED, 0x8C, 0x8D },
	0xC6C6, { 0xED, 0x8C, 0x8E },
	0xC6C7, { 0xED, 0x8C, 0x90 },
	0xC6C8, { 0xED, 0x8C, 0x94 },
	0xC6C9, { 0xED, 0x8C, 0x96 },
	0xC6CA, { 0xED, 0x8C, 0x9C },
	0xC6CB, { 0xED, 0x8C, 0x9D },
	0xC6CC, { 0xED, 0x8C, 0x9F },
	0xC6CD, { 0xED, 0x8C, 0xA0 },
	0xC6CE, { 0xED, 0x8C, 0xA1 },
	0xC6CF, { 0xED, 0x8C, 0xA5 },
	0xC6D0, { 0xED, 0x8C, 0xA8 },
	0xC6D1, { 0xED, 0x8C, 0xA9 },
	0xC6D2, { 0xED, 0x8C, 0xAC },
	0xC6D3, { 0xED, 0x8C, 0xB0 },
	0xC6D4, { 0xED, 0x8C, 0xB8 },
	0xC6D5, { 0xED, 0x8C, 0xB9 },
	0xC6D6, { 0xED, 0x8C, 0xBB },
	0xC6D7, { 0xED, 0x8C, 0xBC },
	0xC6D8, { 0xED, 0x8C, 0xBD },
	0xC6D9, { 0xED, 0x8D, 0x84 },
	0xC6DA, { 0xED, 0x8D, 0x85 },
	0xC6DB, { 0xED, 0x8D, 0xBC },
	0xC6DC, { 0xED, 0x8D, 0xBD },
	0xC6DD, { 0xED, 0x8E, 0x80 },
	0xC6DE, { 0xED, 0x8E, 0x84 },
	0xC6DF, { 0xED, 0x8E, 0x8C },
	0xC6E0, { 0xED, 0x8E, 0x8D },
	0xC6E1, { 0xED, 0x8E, 0x8F },
	0xC6E2, { 0xED, 0x8E, 0x90 },
	0xC6E3, { 0xED, 0x8E, 0x91 },
	0xC6E4, { 0xED, 0x8E, 0x98 },
	0xC6E5, { 0xED, 0x8E, 0x99 },
	0xC6E6, { 0xED, 0x8E, 0x9C },
	0xC6E7, { 0xED, 0x8E, 0xA0 },
	0xC6E8, { 0xED, 0x8E, 0xA8 },
	0xC6E9, { 0xED, 0x8E, 0xA9 },
	0xC6EA, { 0xED, 0x8E, 0xAB },
	0xC6EB, { 0xED, 0x8E, 0xAD },
	0xC6EC, { 0xED, 0x8E, 0xB4 },
	0xC6ED, { 0xED, 0x8E, 0xB8 },
	0xC6EE, { 0xED, 0x8E, 0xBC },
	0xC6EF, { 0xED, 0x8F, 0x84 },
	0xC6F0, { 0xED, 0x8F, 0x85 },
	0xC6F1, { 0xED, 0x8F, 0x88 },
	0xC6F2, { 0xED, 0x8F, 0x89 },
	0xC6F3, { 0xED, 0x8F, 0x90 },
	0xC6F4, { 0xED, 0x8F, 0x98 },
	0xC6F5, { 0xED, 0x8F, 0xA1 },
	0xC6F6, { 0xED, 0x8F, 0xA3 },
	0xC6F7, { 0xED, 0x8F, 0xAC },
	0xC6F8, { 0xED, 0x8F, 0xAD },
	0xC6F9, { 0xED, 0x8F, 0xB0 },
	0xC6FA, { 0xED, 0x8F, 0xB4 },
	0xC6FB, { 0xED, 0x8F, 0xBC },
	0xC6FC, { 0xED, 0x8F, 0xBD },
	0xC6FD, { 0xED, 0x8F, 0xBF },
	0xC6FE, { 0xED, 0x90, 0x81 },
	0xC7A1, { 0xED, 0x90, 0x88 },
	0xC7A2, { 0xED, 0x90, 0x9D },
	0xC7A3, { 0xED, 0x91, 0x80 },
	0xC7A4, { 0xED, 0x91, 0x84 },
	0xC7A5, { 0xED, 0x91, 0x9C },
	0xC7A6, { 0xED, 0x91, 0xA0 },
	0xC7A7, { 0xED, 0x91, 0xA4 },
	0xC7A8, { 0xED, 0x91, 0xAD },
	0xC7A9, { 0xED, 0x91, 0xAF },
	0xC7AA, { 0xED, 0x91, 0xB8 },
	0xC7AB, { 0xED, 0x91, 0xB9 },
	0xC7AC, { 0xED, 0x91, 0xBC },
	0xC7AD, { 0xED, 0x91, 0xBF },
	0xC7AE, { 0xED, 0x92, 0x80 },
	0xC7AF, { 0xED, 0x92, 0x82 },
	0xC7B0, { 0xED, 0x92, 0x88 },
	0xC7B1, { 0xED, 0x92, 0x89 },
	0xC7B2, { 0xED, 0x92, 0x8B },
	0xC7B3, { 0xED, 0x92, 0x8D },
	0xC7B4, { 0xED, 0x92, 0x94 },
	0xC7B5, { 0xED, 0x92, 0xA9 },
	0xC7B6, { 0xED, 0x93, 0x8C },
	0xC7B7, { 0xED, 0x93, 0x90 },
	0xC7B8, { 0xED, 0x93, 0x94 },
	0xC7B9, { 0xED, 0x93, 0x9C },
	0xC7BA, { 0xED, 0x93, 0x9F },
	0xC7BB, { 0xED, 0x93, 0xA8 },
	0xC7BC, { 0xED, 0x93, 0xAC },
	0xC7BD, { 0xED, 0x93, 0xB0 },
	0xC7BE, { 0xED, 0x93, 0xB8 },
	0xC7BF, { 0xED, 0x93, 0xBB },
	0xC7C0, { 0xED, 0x93, 0xBD },
	0xC7C1, { 0xED, 0x94, 0x84 },
	0xC7C2, { 0xED, 0x94, 0x88 },
	0xC7C3, { 0xED, 0x94, 0x8C },
	0xC7C4, { 0xED, 0x94, 0x94 },
	0xC7C5, { 0xED, 0x94, 0x95 },
	0xC7C6, { 0xED, 0x94, 0x97 },
	0xC7C7, { 0xED, 0x94, 0xBC },
	0xC7C8, { 0xED, 0x94, 0xBD },
	0xC7C9, { 0xED, 0x95, 0x80 },
	0xC7CA, { 0xED, 0x95, 0x84 },
	0xC7CB, { 0xED, 0x95, 0x8C },
	0xC7CC, { 0xED, 0x95, 0x8D },
	0xC7CD, { 0xED, 0x95, 0x8F },
	0xC7CE, { 0xED, 0x95, 0x91 },
	0xC7CF, { 0xED, 0x95, 0x98 },
	0xC7D0, { 0xED, 0x95, 0x99 },
	0xC7D1, { 0xED, 0x95, 0x9C },
	0xC7D2, { 0xED, 0x95, 0xA0 },
	0xC7D3, { 0xED, 0x95, 0xA5 },
	0xC7D4, { 0xED, 0x95, 0xA8 },
	0xC7D5, { 0xED, 0x95, 0xA9 },
	0xC7D6, { 0xED, 0x95, 0xAB },
	0xC7D7, { 0xED, 0x95, 0xAD },
	0xC7D8, { 0xED, 0x95, 0xB4 },
	0xC7D9, { 0xED, 0x95, 0xB5 },
	0xC7DA, { 0xED, 0x95, 0xB8 },
	0xC7DB, { 0xED, 0x95, 0xBC },
	0xC7DC, { 0xED, 0x96, 0x84 },
	0xC7DD, { 0xED, 0x96, 0x85 },
	0xC7DE, { 0xED, 0x96, 0x87 },
	0xC7DF, { 0xED, 0x96, 0x88 },
	0xC7E0, { 0xED, 0x96, 0x89 },
	0xC7E1, { 0xED, 0x96, 0x90 },
	0xC7E2, { 0xED, 0x96, 0xA5 },
	0xC7E3, { 0xED, 0x97, 0x88 },
	0xC7E4, { 0xED, 0x97, 0x89 },
	0xC7E5, { 0xED, 0x97, 0x8C },
	0xC7E6, { 0xED, 0x97, 0x90 },
	0xC7E7, { 0xED, 0x97, 0x92 },
	0xC7E8, { 0xED, 0x97, 0x98 },
	0xC7E9, { 0xED, 0x97, 0x99 },
	0xC7EA, { 0xED, 0x97, 0x9B },
	0xC7EB, { 0xED, 0x97, 0x9D },
	0xC7EC, { 0xED, 0x97, 0xA4 },
	0xC7ED, { 0xED, 0x97, 0xA5 },
	0xC7EE, { 0xED, 0x97, 0xA8 },
	0xC7EF, { 0xED, 0x97, 0xAC },
	0xC7F0, { 0xED, 0x97, 0xB4 },
	0xC7F1, { 0xED, 0x97, 0xB5 },
	0xC7F2, { 0xED, 0x97, 0xB7 },
	0xC7F3, { 0xED, 0x97, 0xB9 },
	0xC7F4, { 0xED, 0x98, 0x80 },
	0xC7F5, { 0xED, 0x98, 0x81 },
	0xC7F6, { 0xED, 0x98, 0x84 },
	0xC7F7, { 0xED, 0x98, 0x88 },
	0xC7F8, { 0xED, 0x98, 0x90 },
	0xC7F9, { 0xED, 0x98, 0x91 },
	0xC7FA, { 0xED, 0x98, 0x93 },
	0xC7FB, { 0xED, 0x98, 0x94 },
	0xC7FC, { 0xED, 0x98, 0x95 },
	0xC7FD, { 0xED, 0x98, 0x9C },
	0xC7FE, { 0xED, 0x98, 0xA0 },
	0xC8A1, { 0xED, 0x98, 0xA4 },
	0xC8A2, { 0xED, 0x98, 0xAD },
	0xC8A3, { 0xED, 0x98, 0xB8 },
	0xC8A4, { 0xED, 0x98, 0xB9 },
	0xC8A5, { 0xED, 0x98, 0xBC },
	0xC8A6, { 0xED, 0x99, 0x80 },
	0xC8A7, { 0xED, 0x99, 0x85 },
	0xC8A8, { 0xED, 0x99, 0x88 },
	0xC8A9, { 0xED, 0x99, 0x89 },
	0xC8AA, { 0xED, 0x99, 0x8B },
	0xC8AB, { 0xED, 0x99, 0x8D },
	0xC8AC, { 0xED, 0x99, 0x91 },
	0xC8AD, { 0xED, 0x99, 0x94 },
	0xC8AE, { 0xED, 0x99, 0x95 },
	0xC8AF, { 0xED, 0x99, 0x98 },
	0xC8B0, { 0xED, 0x99, 0x9C },
	0xC8B1, { 0xED, 0x99, 0xA7 },
	0xC8B2, { 0xED, 0x99, 0xA9 },
	0xC8B3, { 0xED, 0x99, 0xB0 },
	0xC8B4, { 0xED, 0x99, 0xB1 },
	0xC8B5, { 0xED, 0x99, 0xB4 },
	0xC8B6, { 0xED, 0x9A, 0x83 },
	0xC8B7, { 0xED, 0x9A, 0x85 },
	0xC8B8, { 0xED, 0x9A, 0x8C },
	0xC8B9, { 0xED, 0x9A, 0x8D },
	0xC8BA, { 0xED, 0x9A, 0x90 },
	0xC8BB, { 0xED, 0x9A, 0x94 },
	0xC8BC, { 0xED, 0x9A, 0x9D },
	0xC8BD, { 0xED, 0x9A, 0x9F },
	0xC8BE, { 0xED, 0x9A, 0xA1 },
	0xC8BF, { 0xED, 0x9A, 0xA8 },
	0xC8C0, { 0xED, 0x9A, 0xAC },
	0xC8C1, { 0xED, 0x9A, 0xB0 },
	0xC8C2, { 0xED, 0x9A, 0xB9 },
	0xC8C3, { 0xED, 0x9A, 0xBB },
	0xC8C4, { 0xED, 0x9B, 0x84 },
	0xC8C5, { 0xED, 0x9B, 0x85 },
	0xC8C6, { 0xED, 0x9B, 0x88 },
	0xC8C7, { 0xED, 0x9B, 0x8C },
	0xC8C8, { 0xED, 0x9B, 0x91 },
	0xC8C9, { 0xED, 0x9B, 0x94 },
	0xC8CA, { 0xED, 0x9B, 0x97 },
	0xC8CB, { 0xED, 0x9B, 0x99 },
	0xC8CC, { 0xED, 0x9B, 0xA0 },
	0xC8CD, { 0xED, 0x9B, 0xA4 },
	0xC8CE, { 0xED, 0x9B, 0xA8 },
	0xC8CF, { 0xED, 0x9B, 0xB0 },
	0xC8D0, { 0xED, 0x9B, 0xB5 },
	0xC8D1, { 0xED, 0x9B, 0xBC },
	0xC8D2, { 0xED, 0x9B, 0xBD },
	0xC8D3, { 0xED, 0x9C, 0x80 },
	0xC8D4, { 0xED, 0x9C, 0x84 },
	0xC8D5, { 0xED, 0x9C, 0x91 },
	0xC8D6, { 0xED, 0x9C, 0x98 },
	0xC8D7, { 0xED, 0x9C, 0x99 },
	0xC8D8, { 0xED, 0x9C, 0x9C },
	0xC8D9, { 0xED, 0x9C, 0xA0 },
	0xC8DA, { 0xED, 0x9C, 0xA8 },
	0xC8DB, { 0xED, 0x9C, 0xA9 },
	0xC8DC, { 0xED, 0x9C, 0xAB },
	0xC8DD, { 0xED, 0x9C, 0xAD },
	0xC8DE, { 0xED, 0x9C, 0xB4 },
	0xC8DF, { 0xED, 0x9C, 0xB5 },
	0xC8E0, { 0xED, 0x9C, 0xB8 },
	0xC8E1, { 0xED, 0x9C, 0xBC },
	0xC8E2, { 0xED, 0x9D, 0x84 },
	0xC8E3, { 0xED, 0x9D, 0x87 },
	0xC8E4, { 0xED, 0x9D, 0x89 },
	0xC8E5, { 0xED, 0x9D, 0x90 },
	0xC8E6, { 0xED, 0x9D, 0x91 },
	0xC8E7, { 0xED, 0x9D, 0x94 },
	0xC8E8, { 0xED, 0x9D, 0x96 },
	0xC8E9, { 0xED, 0x9D, 0x97 },
	0xC8EA, { 0xED, 0x9D, 0x98 },
	0xC8EB, { 0xED, 0x9D, 0x99 },
	0xC8EC, { 0xED, 0x9D, 0xA0 },
	0xC8ED, { 0xED, 0x9D, 0xA1 },
	0xC8EE, { 0xED, 0x9D, 0xA3 },
	0xC8EF, { 0xED, 0x9D, 0xA5 },
	0xC8F0, { 0xED, 0x9D, 0xA9 },
	0xC8F1, { 0xED, 0x9D, 0xAC },
	0xC8F2, { 0xED, 0x9D, 0xB0 },
	0xC8F3, { 0xED, 0x9D, 0xB4 },
	0xC8F4, { 0xED, 0x9D, 0xBC },
	0xC8F5, { 0xED, 0x9D, 0xBD },
	0xC8F6, { 0xED, 0x9E, 0x81 },
	0xC8F7, { 0xED, 0x9E, 0x88 },
	0xC8F8, { 0xED, 0x9E, 0x89 },
	0xC8F9, { 0xED, 0x9E, 0x8C },
	0xC8FA, { 0xED, 0x9E, 0x90 },
	0xC8FB, { 0xED, 0x9E, 0x98 },
	0xC8FC, { 0xED, 0x9E, 0x99 },
	0xC8FD, { 0xED, 0x9E, 0x9B },
	0xC8FE, { 0xED, 0x9E, 0x9D },
	0xCAA1, { 0xE4, 0xBC, 0xBD },
	0xCAA2, { 0xE4, 0xBD, 0xB3 },
	0xCAA3, { 0xE5, 0x81, 0x87 },
	0xCAA4, { 0xE5, 0x83, 0xB9 },
	0xCAA5, { 0xE5, 0x8A, 0xA0 },
	0xCAA6, { 0xE5, 0x8F, 0xAF },
	0xCAA7, { 0xE5, 0x91, 0xB5 },
	0xCAA8, { 0xE5, 0x93, 0xA5 },
	0xCAA9, { 0xE5, 0x98, 0x89 },
	0xCAAA, { 0xE5, 0xAB, 0x81 },
	0xCAAB, { 0xE5, 0xAE, 0xB6 },
	0xCAAC, { 0xE6, 0x9A, 0x87 },
	0xCAAD, { 0xE6, 0x9E, 0xB6 },
	0xCAAE, { 0xE6, 0x9E, 0xB7 },
	0xCAAF, { 0xE6, 0x9F, 0xAF },
	0xCAB0, { 0xE6, 0xAD, 0x8C },
	0xCAB1, { 0xE7, 0x8F, 0x82 },
	0xCAB2, { 0xE7, 0x97, 0x82 },
	0xCAB3, { 0xE7, 0xA8, 0xBC },
	0xCAB4, { 0xE8, 0x8B, 0x9B },
	0xCAB5, { 0xE8, 0x8C, 0x84 },
	0xCAB6, { 0xE8, 0xA1, 0x97 },
	0xCAB7, { 0xE8, 0xA2, 0x88 },
	0xCAB8, { 0xE8, 0xA8, 0xB6 },
	0xCAB9, { 0xE8, 0xB3, 0x88 },
	0xCABA, { 0xE8, 0xB7, 0x8F },
	0xCABB, { 0xE8, 0xBB, 0xBB },
	0xCABC, { 0xE8, 0xBF, 0xA6 },
	0xCABD, { 0xE9, 0xA7, 0x95 },
	0xCABE, { 0xE5, 0x88, 0xBB },
	0xCABF, { 0xE5, 0x8D, 0xB4 },
	0xCAC0, { 0xE5, 0x90, 0x84 },
	0xCAC1, { 0xE6, 0x81, 0xAA },
	0xCAC2, { 0xE6, 0x85, 0xA4 },
	0xCAC3, { 0xE6, 0xAE, 0xBC },
	0xCAC4, { 0xE7, 0x8F, 0x8F },
	0xCAC5, { 0xE8, 0x84, 0x9A },
	0xCAC6, { 0xE8, 0xA6, 0xBA },
	0xCAC7, { 0xE8, 0xA7, 0x92 },
	0xCAC8, { 0xE9, 0x96, 0xA3 },
	0xCAC9, { 0xE4, 0xBE, 0x83 },
	0xCACA, { 0xE5, 0x88, 0x8A },
	0xCACB, { 0xE5, 0xA2, 0xBE },
	0xCACC, { 0xE5, 0xA5, 0xB8 },
	0xCACD, { 0xE5, 0xA7, 0xA6 },
	0xCACE, { 0xE5, 0xB9, 0xB2 },
	0xCACF, { 0xE5, 0xB9, 0xB9 },
	0xCAD0, { 0xE6, 0x87, 0x87 },
	0xCAD1, { 0xE6, 0x8F, 0x80 },
	0xCAD2, { 0xE6, 0x9D, 0x86 },
	0xCAD3, { 0xE6, 0x9F, 0xAC },
	0xCAD4, { 0xE6, 0xA1, 0xBF },
	0xCAD5, { 0xE6, 0xBE, 0x97 },
	0xCAD6, { 0xE7, 0x99, 0x8E },
	0xCAD7, { 0xE7, 0x9C, 0x8B },
	0xCAD8, { 0xE7, 0xA3, 0xB5 },
	0xCAD9, { 0xE7, 0xA8, 0x88 },
	0xCADA, { 0xE7, 0xAB, 0xBF },
	0xCADB, { 0xE7, 0xB0, 0xA1 },
	0xCADC, { 0xE8, 0x82, 0x9D },
	0xCADD, { 0xE8, 0x89, 0xAE },
	0xCADE, { 0xE8, 0x89, 0xB1 },
	0xCADF, { 0xE8, 0xAB, 0xAB },
	0xCAE0, { 0xE9, 0x96, 0x93 },
	0xCAE1, { 0xE4, 0xB9, 0xAB },
	0xCAE2, { 0xE5, 0x96, 0x9D },
	0xCAE3, { 0xE6, 0x9B, 0xB7 },
	0xCAE4, { 0xE6, 0xB8, 0xB4 },
	0xCAE5, { 0xE7, 0xA2, 0xA3 },
	0xCAE6, { 0xE7, 0xAB, 0xAD },
	0xCAE7, { 0xE8, 0x91, 0x9B },
	0xCAE8, { 0xE8, 0xA4, 0x90 },
	0xCAE9, { 0xE8, 0x9D, 0x8E },
	0xCAEA, { 0xE9, 0x9E, 0xA8 },
	0xCAEB, { 0xE5, 0x8B, 0x98 },
	0xCAEC, { 0xE5, 0x9D, 0x8E },
	0xCAED, { 0xE5, 0xA0, 0xAA },
	0xCAEE, { 0xE5, 0xB5, 0x8C },
	0xCAEF, { 0xE6, 0x84, 0x9F },
	0xCAF0, { 0xE6, 0x86, 0xBE },
	0xCAF1, { 0xE6, 0x88, 0xA1 },
	0xCAF2, { 0xE6, 0x95, 0xA2 },
	0xCAF3, { 0xE6, 0x9F, 0x91 },
	0xCAF4, { 0xE6, 0xA9, 0x84 },
	0xCAF5, { 0xE6, 0xB8, 0x9B },
	0xCAF6, { 0xE7, 0x94, 0x98 },
	0xCAF7, { 0xE7, 0x96, 0xB3 },
	0xCAF8, { 0xE7, 0x9B, 0xA3 },
	0xCAF9, { 0xE7, 0x9E, 0xB0 },
	0xCAFA, { 0xE7, 0xB4, 0xBA },
	0xCAFB, { 0xE9, 0x82, 0xAF },
	0xCAFC, { 0xE9, 0x91, 0x91 },
	0xCAFD, { 0xE9, 0x91, 0x92 },
	0xCAFE, { 0xE9, 0xBE, 0x95 },
	0xCBA1, { 0xE5, 0x8C, 0xA3 },
	0xCBA2, { 0xE5, 0xB2, 0xAC },
	0xCBA3, { 0xE7, 0x94, 0xB2 },
	0xCBA4, { 0xE8, 0x83, 0x9B },
	0xCBA5, { 0xE9, 0x89, 0x80 },
	0xCBA6, { 0xE9, 0x96, 0x98 },
	0xCBA7, { 0xE5, 0x89, 0x9B },
	0xCBA8, { 0xE5, 0xA0, 0x88 },
	0xCBA9, { 0xE5, 0xA7, 0x9C },
	0xCBAA, { 0xE5, 0xB2, 0xA1 },
	0xCBAB, { 0xE5, 0xB4, 0x97 },
	0xCBAC, { 0xE5, 0xBA, 0xB7 },
	0xCBAD, { 0xE5, 0xBC, 0xBA },
	0xCBAE, { 0xE5, 0xBD, 0x8A },
	0xCBAF, { 0xE6, 0x85, 0xB7 },
	0xCBB0, { 0xE6, 0xB1, 0x9F },
	0xCBB1, { 0xE7, 0x95, 0xBA },
	0xCBB2, { 0xE7, 0x96, 0x86 },
	0xCBB3, { 0xE7, 0xB3, 0xA0 },
	0xCBB4, { 0xE7, 0xB5, 0xB3 },
	0xCBB5, { 0xE7, 0xB6, 0xB1 },
	0xCBB6, { 0xE7, 0xBE, 0x8C },
	0xCBB7, { 0xE8, 0x85, 0x94 },
	0xCBB8, { 0xE8, 0x88, 0xA1 },
	0xCBB9, { 0xE8, 0x96, 0x91 },
	0xCBBA, { 0xE8, 0xA5, 0x81 },
	0xCBBB, { 0xE8, 0xAC, 0x9B },
	0xCBBC, { 0xE9, 0x8B, 0xBC },
	0xCBBD, { 0xE9, 0x99, 0x8D },
	0xCBBE, { 0xE9, 0xB1, 0x87 },
	0xCBBF, { 0xE4, 0xBB, 0x8B },
	0xCBC0, { 0xE4, 0xBB, 0xB7 },
	0xCBC1, { 0xE5, 0x80, 0x8B },
	0xCBC2, { 0xE5, 0x87, 0xB1 },
	0xCBC3, { 0xE5, 0xA1, 0x8F },
	0xCBC4, { 0xE6, 0x84, 0xB7 },
	0xCBC5, { 0xE6, 0x84, 0xBE },
	0xCBC6, { 0xE6, 0x85, 0xA8 },
	0xCBC7, { 0xE6, 0x94, 0xB9 },
	0xCBC8, { 0xE6, 0xA7, 0xAA },
	0xCBC9, { 0xE6, 0xBC, 0x91 },
	0xCBCA, { 0xE7, 0x96, 0xA5 },
	0xCBCB, { 0xE7, 0x9A, 0x86 },
	0xCBCC, { 0xE7, 0x9B, 0x96 },
	0xCBCD, { 0xE7, 0xAE, 0x87 },
	0xCBCE, { 0xE8, 0x8A, 0xA5 },
	0xCBCF, { 0xE8, 0x93, 0x8B },
	0xCBD0, { 0xEF, 0xA4, 0x80 },
	0xCBD1, { 0xE9, 0x8E, 0xA7 },
	0xCBD2, { 0xE9, 0x96, 0x8B },
	0xCBD3, { 0xE5, 0x96, 0x80 },
	0xCBD4, { 0xE5, 0xAE, 0xA2 },
	0xCBD5, { 0xE5, 0x9D, 0x91 },
	0xCBD6, { 0xEF, 0xA4, 0x81 },
	0xCBD7, { 0xE7, 0xB2, 0xB3 },
	0xCBD8, { 0xE7, 0xBE, 0xB9 },
	0xCBD9, { 0xE9, 0x86, 0xB5 },
	0xCBDA, { 0xE5, 0x80, 0xA8 },
	0xCBDB, { 0xE5, 0x8E, 0xBB },
	0xCBDC, { 0xE5, 0xB1, 0x85 },
	0xCBDD, { 0xE5, 0xB7, 0xA8 },
	0xCBDE, { 0xE6, 0x8B, 0x92 },
	0xCBDF, { 0xE6, 0x8D, 0xAE },
	0xCBE0, { 0xE6, 0x93, 0x9A },
	0xCBE1, { 0xE6, 0x93, 0xA7 },
	0xCBE2, { 0xE6, 0xB8, 0xA0 },
	0xCBE3, { 0xE7, 0x82, 0xAC },
	0xCBE4, { 0xE7, 0xA5, 0x9B },
	0xCBE5, { 0xE8, 0xB7, 0x9D },
	0xCBE6, { 0xE8, 0xB8, 0x9E },
	0xCBE7, { 0xEF, 0xA4, 0x82 },
	0xCBE8, { 0xE9, 0x81, 0xBD },
	0xCBE9, { 0xE9, 0x89, 0x85 },
	0xCBEA, { 0xE9, 0x8B, 0xB8 },
	0xCBEB, { 0xE4, 0xB9, 0xBE },
	0xCBEC, { 0xE4, 0xBB, 0xB6 },
	0xCBED, { 0xE5, 0x81, 0xA5 },
	0xCBEE, { 0xE5, 0xB7, 0xBE },
	0xCBEF, { 0xE5, 0xBB, 0xBA },
	0xCBF0, { 0xE6, 0x84, 0x86 },
	0xCBF1, { 0xE6, 0xA5, 0x97 },
	0xCBF2, { 0xE8, 0x85, 0xB1 },
	0xCBF3, { 0xE8, 0x99, 0x94 },
	0xCBF4, { 0xE8, 0xB9, 0x87 },
	0xCBF5, { 0xE9, 0x8D, 0xB5 },
	0xCBF6, { 0xE9, 0xA8, 0xAB },
	0xCBF7, { 0xE4, 0xB9, 0x9E },
	0xCBF8, { 0xE5, 0x82, 0x91 },
	0xCBF9, { 0xE6, 0x9D, 0xB0 },
	0xCBFA, { 0xE6, 0xA1, 0x80 },
	0xCBFB, { 0xE5, 0x84, 0x89 },
	0xCBFC, { 0xE5, 0x8A, 0x8D },
	0xCBFD, { 0xE5, 0x8A, 0x92 },
	0xCBFE, { 0xE6, 0xAA, 0xA2 },
	0xCCA1, { 0xE7, 0x9E, 0xBC },
	0xCCA2, { 0xE9, 0x88, 0x90 },
	0xCCA3, { 0xE9, 0xBB, 0x94 },
	0xCCA4, { 0xE5, 0x8A, 0xAB },
	0xCCA5, { 0xE6, 0x80, 0xAF },
	0xCCA6, { 0xE8, 0xBF, 0xB2 },
	0xCCA7, { 0xE5, 0x81, 0x88 },
	0xCCA8, { 0xE6, 0x86, 0xA9 },
	0xCCA9, { 0xE6, 0x8F, 0xAD },
	0xCCAA, { 0xE6, 0x93, 0x8A },
	0xCCAB, { 0xE6, 0xA0, 0xBC },
	0xCCAC, { 0xE6, 0xAA, 0x84 },
	0xCCAD, { 0xE6, 0xBF, 0x80 },
	0xCCAE, { 0xE8, 0x86, 0x88 },
	0xCCAF, { 0xE8, 0xA6, 0xA1 },
	0xCCB0, { 0xE9, 0x9A, 0x94 },
	0xCCB1, { 0xE5, 0xA0, 0x85 },
	0xCCB2, { 0xE7, 0x89, 0xBD },
	0xCCB3, { 0xE7, 0x8A, 0xAC },
	0xCCB4, { 0xE7, 0x94, 0x84 },
	0xCCB5, { 0xE7, 0xB5, 0xB9 },
	0xCCB6, { 0xE7, 0xB9, 0xAD },
	0xCCB7, { 0xE8, 0x82, 0xA9 },
	0xCCB8, { 0xE8, 0xA6, 0x8B },
	0xCCB9, { 0xE8, 0xAD, 0xB4 },
	0xCCBA, { 0xE9, 0x81, 0xA3 },
	0xCCBB, { 0xE9, 0xB5, 0x91 },
	0xCCBC, { 0xE6, 0x8A, 0x89 },
	0xCCBD, { 0xE6, 0xB1, 0xBA },
	0xCCBE, { 0xE6, 0xBD, 0x94 },
	0xCCBF, { 0xE7, 0xB5, 0x90 },
	0xCCC0, { 0xE7, 0xBC, 0xBA },
	0xCCC1, { 0xE8, 0xA8, 0xA3 },
	0xCCC2, { 0xE5, 0x85, 0xBC },
	0xCCC3, { 0xE6, 0x85, 0x8A },
	0xCCC4, { 0xE7, 0xAE, 0x9D },
	0xCCC5, { 0xE8, 0xAC, 0x99 },
	0xCCC6, { 0xE9, 0x89, 0x97 },
	0xCCC7, { 0xE9, 0x8E, 0x8C },
	0xCCC8, { 0xE4, 0xBA, 0xAC },
	0xCCC9, { 0xE4, 0xBF, 0x93 },
	0xCCCA, { 0xE5, 0x80, 0x9E },
	0xCCCB, { 0xE5, 0x82, 0xBE },
	0xCCCC, { 0xE5, 0x84, 0x86 },
	0xCCCD, { 0xE5, 0x8B, 0x81 },
	0xCCCE, { 0xE5, 0x8B, 0x8D },
	0xCCCF, { 0xE5, 0x8D, 0xBF },
	0xCCD0, { 0xE5, 0x9D, 0xB0 },
	0xCCD1, { 0xE5, 0xA2, 0x83 },
	0xCCD2, { 0xE5, 0xBA, 0x9A },
	0xCCD3, { 0xE5, 0xBE, 0x91 },
	0xCCD4, { 0xE6, 0x85, 0xB6 },
	0xCCD5, { 0xE6, 0x86, 0xAC },
	0xCCD6, { 0xE6, 0x93, 0x8E },
	0xCCD7, { 0xE6, 0x95, 0xAC },
	0xCCD8, { 0xE6, 0x99, 0xAF },
	0xCCD9, { 0xE6, 0x9A, 0xBB },
	0xCCDA, { 0xE6, 0x9B, 0xB4 },
	0xCCDB, { 0xE6, 0xA2, 0x97 },
	0xCCDC, { 0xE6, 0xB6, 0x87 },
	0xCCDD, { 0xE7, 0x82, 0x85 },
	0xCCDE, { 0xE7, 0x83, 0xB1 },
	0xCCDF, { 0xE7, 0x92, 0x9F },
	0xCCE0, { 0xE7, 0x92, 0xA5 },
	0xCCE1, { 0xE7, 0x93, 0x8A },
	0xCCE2, { 0xE7, 0x97, 0x99 },
	0xCCE3, { 0xE7, 0xA1, 0xAC },
	0xCCE4, { 0xE7, 0xA3, 0xAC },
	0xCCE5, { 0xE7, 0xAB, 0x9F },
	0xCCE6, { 0xE7, 0xAB, 0xB6 },
	0xCCE7, { 0xE7, 0xB5, 0x85 },
	0xCCE8, { 0xE7, 0xB6, 0x93 },
	0xCCE9, { 0xE8, 0x80, 0x95 },
	0xCCEA, { 0xE8, 0x80, 0xBF },
	0xCCEB, { 0xE8, 0x84, 0x9B },
	0xCCEC, { 0xE8, 0x8E, 0x96 },
	0xCCED, { 0xE8, 0xAD, 0xA6 },
	0xCCEE, { 0xE8, 0xBC, 0x95 },
	0xCCEF, { 0xE9, 0x80, 0x95 },
	0xCCF0, { 0xE9, 0x8F, 0xA1 },
	0xCCF1, { 0xE9, 0xA0, 0x83 },
	0xCCF2, { 0xE9, 0xA0, 0xB8 },
	0xCCF3, { 0xE9, 0xA9, 0x9A },
	0xCCF4, { 0xE9, 0xAF, 0xA8 },
	0xCCF5, { 0xE4, 0xBF, 0x82 },
	0xCCF6, { 0xE5, 0x95, 0x93 },
	0xCCF7, { 0xE5, 0xA0, 0xBA },
	0xCCF8, { 0xE5, 0xA5, 0x91 },
	0xCCF9, { 0xE5, 0xAD, 0xA3 },
	0xCCFA, { 0xE5, 0xB1, 0x86 },
	0xCCFB, { 0xE6, 0x82, 0xB8 },
	0xCCFC, { 0xE6, 0x88, 0x92 },
	0xCCFD, { 0xE6, 0xA1, 0x82 },
	0xCCFE, { 0xE6, 0xA2, 0xB0 },
	0xCDA1, { 0xE6, 0xA3, 0xA8 },
	0xCDA2, { 0xE6, 0xBA, 0xAA },
	0xCDA3, { 0xE7, 0x95, 0x8C },
	0xCDA4, { 0xE7, 0x99, 0xB8 },
	0xCDA5, { 0xE7, 0xA3, 0x8E },
	0xCDA6, { 0xE7, 0xA8, 0xBD },
	0xCDA7, { 0xE7, 0xB3, 0xBB },
	0xCDA8, { 0xE7, 0xB9, 0xAB },
	0xCDA9, { 0xE7, 0xB9, 0xBC },
	0xCDAA, { 0xE8, 0xA8, 0x88 },
	0xCDAB, { 0xE8, 0xAA, 0xA1 },
	0xCDAC, { 0xE8, 0xB0, 0xBF },
	0xCDAD, { 0xE9, 0x9A, 0x8E },
	0xCDAE, { 0xE9, 0xB7, 0x84 },
	0xCDAF, { 0xE5, 0x8F, 0xA4 },
	0xCDB0, { 0xE5, 0x8F, 0xA9 },
	0xCDB1, { 0xE5, 0x91, 0x8A },
	0xCDB2, { 0xE5, 0x91, 0xB1 },
	0xCDB3, { 0xE5, 0x9B, 0xBA },
	0xCDB4, { 0xE5, 0xA7, 0x91 },
	0xCDB5, { 0xE5, 0xAD, 0xA4 },
	0xCDB6, { 0xE5, 0xB0, 0xBB },
	0xCDB7, { 0xE5, 0xBA, 0xAB },
	0xCDB8, { 0xE6, 0x8B, 0xB7 },
	0xCDB9, { 0xE6, 0x94, 0xB7 },
	0xCDBA, { 0xE6, 0x95, 0x85 },
	0xCDBB, { 0xE6, 0x95, 0xB2 },
	0xCDBC, { 0xE6, 0x9A, 0xA0 },
	0xCDBD, { 0xE6, 0x9E, 0xAF },
	0xCDBE, { 0xE6, 0xA7, 0x81 },
	0xCDBF, { 0xE6, 0xB2, 0xBD },
	0xCDC0, { 0xE7, 0x97, 0xBC },
	0xCDC1, { 0xE7, 0x9A, 0x90 },
	0xCDC2, { 0xE7, 0x9D, 0xBE },
	0xCDC3, { 0xE7, 0xA8, 0xBF },
	0xCDC4, { 0xE7, 0xBE, 0x94 },
	0xCDC5, { 0xE8, 0x80, 0x83 },
	0xCDC6, { 0xE8, 0x82, 0xA1 },
	0xCDC7, { 0xE8, 0x86, 0x8F },
	0xCDC8, { 0xE8, 0x8B, 0xA6 },
	0xCDC9, { 0xE8, 0x8B, 0xBD },
	0xCDCA, { 0xE8, 0x8F, 0xB0 },
	0xCDCB, { 0xE8, 0x97, 0x81 },
	0xCDCC, { 0xE8, 0xA0, 0xB1 },
	0xCDCD, { 0xE8, 0xA2, 0xB4 },
	0xCDCE, { 0xE8, 0xAA, 0xA5 },
	0xCDCF, { 0xEF, 0xA4, 0x83 },
	0xCDD0, { 0xE8, 0xBE, 0x9C },
	0xCDD1, { 0xE9, 0x8C, 0xAE },
	0xCDD2, { 0xE9, 0x9B, 0x87 },
	0xCDD3, { 0xE9, 0xA1, 0xA7 },
	0xCDD4, { 0xE9, 0xAB, 0x98 },
	0xCDD5, { 0xE9, 0xBC, 0x93 },
	0xCDD6, { 0xE5, 0x93, 0xAD },
	0xCDD7, { 0xE6, 0x96, 0x9B },
	0xCDD8, { 0xE6, 0x9B, 0xB2 },
	0xCDD9, { 0xE6, 0xA2, 0x8F },
	0xCDDA, { 0xE7, 0xA9, 0x80 },
	0xCDDB, { 0xE8, 0xB0, 0xB7 },
	0xCDDC, { 0xE9, 0xB5, 0xA0 },
	0xCDDD, { 0xE5, 0x9B, 0xB0 },
	0xCDDE, { 0xE5, 0x9D, 0xA4 },
	0xCDDF, { 0xE5, 0xB4, 0x91 },
	0xCDE0, { 0xE6, 0x98, 0x86 },
	0xCDE1, { 0xE6, 0xA2, 0xB1 },
	0xCDE2, { 0xE6, 0xA3, 0x8D },
	0xCDE3, { 0xE6, 0xBB, 0xBE },
	0xCDE4, { 0xE7, 0x90, 0xA8 },
	0xCDE5, { 0xE8, 0xA2, 0x9E },
	0xCDE6, { 0xE9, 0xAF, 0xA4 },
	0xCDE7, { 0xE6, 0xB1, 0xA8 },
	0xCDE8, { 0xEF, 0xA4, 0x84 },
	0xCDE9, { 0xE9, 0xAA, 0xA8 },
	0xCDEA, { 0xE4, 0xBE, 0x9B },
	0xCDEB, { 0xE5, 0x85, 0xAC },
	0xCDEC, { 0xE5, 0x85, 0xB1 },
	0xCDED, { 0xE5, 0x8A, 0x9F },
	0xCDEE, { 0xE5, 0xAD, 0x94 },
	0xCDEF, { 0xE5, 0xB7, 0xA5 },
	0xCDF0, { 0xE6, 0x81, 0x90 },
	0xCDF1, { 0xE6, 0x81, 0xAD },
	0xCDF2, { 0xE6, 0x8B, 0xB1 },
	0xCDF3, { 0xE6, 0x8E, 0xA7 },
	0xCDF4, { 0xE6, 0x94, 0xBB },
	0xCDF5, { 0xE7, 0x8F, 0x99 },
	0xCDF6, { 0xE7, 0xA9, 0xBA },
	0xCDF7, { 0xE8, 0x9A, 0xA3 },
	0xCDF8, { 0xE8, 0xB2, 0xA2 },
	0xCDF9, { 0xE9, 0x9E, 0x8F },
	0xCDFA, { 0xE4, 0xB8, 0xB2 },
	0xCDFB, { 0xE5, 0xAF, 0xA1 },
	0xCDFC, { 0xE6, 0x88, 0x88 },
	0xCDFD, { 0xE6, 0x9E, 0x9C },
	0xCDFE, { 0xE7, 0x93, 0x9C },
	0xCEA1, { 0xE7, 0xA7, 0x91 },
	0xCEA2, { 0xE8, 0x8F, 0x93 },
	0xCEA3, { 0xE8, 0xAA, 0x87 },
	0xCEA4, { 0xE8, 0xAA, 0xB2 },
	0xCEA5, { 0xE8, 0xB7, 0xA8 },
	0xCEA6, { 0xE9, 0x81, 0x8E },
	0xCEA7, { 0xE9, 0x8D, 0x8B },
	0xCEA8, { 0xE9, 0xA1, 0x86 },
	0xCEA9, { 0xE5, 0xBB, 0x93 },
	0xCEAA, { 0xE6, 0xA7, 0xA8 },
	0xCEAB, { 0xE8, 0x97, 0xBF },
	0xCEAC, { 0xE9, 0x83, 0xAD },
	0xCEAD, { 0xEF, 0xA4, 0x85 },
	0xCEAE, { 0xE5, 0x86, 0xA0 },
	0xCEAF, { 0xE5, 0xAE, 0x98 },
	0xCEB0, { 0xE5, 0xAF, 0xAC },
	0xCEB1, { 0xE6, 0x85, 0xA3 },
	0xCEB2, { 0xE6, 0xA3, 0xBA },
	0xCEB3, { 0xE6, 0xAC, 0xBE },
	0xCEB4, { 0xE7, 0x81, 0x8C },
	0xCEB5, { 0xE7, 0x90, 0xAF },
	0xCEB6, { 0xE7, 0x93, 0x98 },
	0xCEB7, { 0xE7, 0xAE, 0xA1 },
	0xCEB8, { 0xE7, 0xBD, 0x90 },
	0xCEB9, { 0xE8, 0x8F, 0x85 },
	0xCEBA, { 0xE8, 0xA7, 0x80 },
	0xCEBB, { 0xE8, 0xB2, 0xAB },
	0xCEBC, { 0xE9, 0x97, 0x9C },
	0xCEBD, { 0xE9, 0xA4, 0xA8 },
	0xCEBE, { 0xE5, 0x88, 0xAE },
	0xCEBF, { 0xE6, 0x81, 0x9D },
	0xCEC0, { 0xE6, 0x8B, 0xAC },
	0xCEC1, { 0xE9, 0x80, 0x82 },
	0xCEC2, { 0xE4, 0xBE, 0x8A },
	0xCEC3, { 0xE5, 0x85, 0x89 },
	0xCEC4, { 0xE5, 0x8C, 0xA1 },
	0xCEC5, { 0xE5, 0xA3, 0x99 },
	0xCEC6, { 0xE5, 0xBB, 0xA3 },
	0xCEC7, { 0xE6, 0x9B, 0xA0 },
	0xCEC8, { 0xE6, 0xB4, 0xB8 },
	0xCEC9, { 0xE7, 0x82, 0x9A },
	0xCECA, { 0xE7, 0x8B, 0x82 },
	0xCECB, { 0xE7, 0x8F, 0x96 },
	0xCECC, { 0xE7, 0xAD, 0x90 },
	0xCECD, { 0xE8, 0x83, 0xB1 },
	0xCECE, { 0xE9, 0x91, 0x9B },
	0xCECF, { 0xE5, 0x8D, 0xA6 },
	0xCED0, { 0xE6, 0x8E, 0x9B },
	0xCED1, { 0xE7, 0xBD, 0xAB },
	0xCED2, { 0xE4, 0xB9, 0x96 },
	0xCED3, { 0xE5, 0x82, 0x80 },
	0xCED4, { 0xE5, 0xA1, 0x8A },
	0xCED5, { 0xE5, 0xA3, 0x9E },
	0xCED6, { 0xE6, 0x80, 0xAA },
	0xCED7, { 0xE6, 0x84, 0xA7 },
	0xCED8, { 0xE6, 0x8B, 0x90 },
	0xCED9, { 0xE6, 0xA7, 0x90 },
	0xCEDA, { 0xE9, 0xAD, 0x81 },
	0xCEDB, { 0xE5, 0xAE, 0x8F },
	0xCEDC, { 0xE7, 0xB4, 0x98 },
	0xCEDD, { 0xE8, 0x82, 0xB1 },
	0xCEDE, { 0xE8, 0xBD, 0x9F },
	0xCEDF, { 0xE4, 0xBA, 0xA4 },
	0xCEE0, { 0xE5, 0x83, 0x91 },
	0xCEE1, { 0xE5, 0x92, 0xAC },
	0xCEE2, { 0xE5, 0x96, 0xAC },
	0xCEE3, { 0xE5, 0xAC, 0x8C },
	0xCEE4, { 0xE5, 0xB6, 0xA0 },
	0xCEE5, { 0xE5, 0xB7, 0xA7 },
	0xCEE6, { 0xE6, 0x94, 0xAA },
	0xCEE7, { 0xE6, 0x95, 0x8E },
	0xCEE8, { 0xE6, 0xA0, 0xA1 },
	0xCEE9, { 0xE6, 0xA9, 0x8B },
	0xCEEA, { 0xE7, 0x8B, 0xA1 },
	0xCEEB, { 0xE7, 0x9A, 0x8E },
	0xCEEC, { 0xE7, 0x9F, 0xAF },
	0xCEED, { 0xE7, 0xB5, 0x9E },
	0xCEEE, { 0xE7, 0xBF, 0xB9 },
	0xCEEF, { 0xE8, 0x86, 0xA0 },
	0xCEF0, { 0xE8, 0x95, 0x8E },
	0xCEF1, { 0xE8, 0x9B, 0x9F },
	0xCEF2, { 0xE8, 0xBC, 0x83 },
	0xCEF3, { 0xE8, 0xBD, 0x8E },
	0xCEF4, { 0xE9, 0x83, 0x8A },
	0xCEF5, { 0xE9, 0xA4, 0x83 },
	0xCEF6, { 0xE9, 0xA9, 0x95 },
	0xCEF7, { 0xE9, 0xAE, 0xAB },
	0xCEF8, { 0xE4, 0xB8, 0x98 },
	0xCEF9, { 0xE4, 0xB9, 0x85 },
	0xCEFA, { 0xE4, 0xB9, 0x9D },
	0xCEFB, { 0xE4, 0xBB, 0x87 },
	0xCEFC, { 0xE4, 0xBF, 0xB1 },
	0xCEFD, { 0xE5, 0x85, 0xB7 },
	0xCEFE, { 0xE5, 0x8B, 0xBE },
	0xCFA1, { 0xE5, 0x8D, 0x80 },
	0xCFA2, { 0xE5, 0x8F, 0xA3 },
	0xCFA3, { 0xE5, 0x8F, 0xA5 },
	0xCFA4, { 0xE5, 0x92, 0x8E },
	0xCFA5, { 0xE5, 0x98, 0x94 },
	0xCFA6, { 0xE5, 0x9D, 0xB5 },
	0xCFA7, { 0xE5, 0x9E, 0xA2 },
	0xCFA8, { 0xE5, 0xAF, 0x87 },
	0xCFA9, { 0xE5, 0xB6, 0x87 },
	0xCFAA, { 0xE5, 0xBB, 0x90 },
	0xCFAB, { 0xE6, 0x87, 0xBC },
	0xCFAC, { 0xE6, 0x8B, 0x98 },
	0xCFAD, { 0xE6, 0x95, 0x91 },
	0xCFAE, { 0xE6, 0x9E, 0xB8 },
	0xCFAF, { 0xE6, 0x9F, 0xA9 },
	0xCFB0, { 0xE6, 0xA7, 0x8B },
	0xCFB1, { 0xE6, 0xAD, 0x90 },
	0xCFB2, { 0xE6, 0xAF, 0x86 },
	0xCFB3, { 0xE6, 0xAF, 0xAC },
	0xCFB4, { 0xE6, 0xB1, 0x82 },
	0xCFB5, { 0xE6, 0xBA, 0x9D },
	0xCFB6, { 0xE7, 0x81, 0xB8 },
	0xCFB7, { 0xE7, 0x8B, 0x97 },
	0xCFB8, { 0xE7, 0x8E, 0x96 },
	0xCFB9, { 0xE7, 0x90, 0x83 },
	0xCFBA, { 0xE7, 0x9E, 0xBF },
	0xCFBB, { 0xE7, 0x9F, 0xA9 },
	0xCFBC, { 0xE7, 0xA9, 0xB6 },
	0xCFBD, { 0xE7, 0xB5, 0xBF },
	0xCFBE, { 0xE8, 0x80, 0x89 },
	0xCFBF, { 0xE8, 0x87, 0xBC },
	0xCFC0, { 0xE8, 0x88, 0x85 },
	0xCFC1, { 0xE8, 0x88, 0x8A },
	0xCFC2, { 0xE8, 0x8B, 0x9F },
	0xCFC3, { 0xE8, 0xA1, 0xA2 },
	0xCFC4, { 0xE8, 0xAC, 0xB3 },
	0xCFC5, { 0xE8, 0xB3, 0xBC },
	0xCFC6, { 0xE8, 0xBB, 0x80 },
	0xCFC7, { 0xE9, 0x80, 0x91 },
	0xCFC8, { 0xE9, 0x82, 0xB1 },
	0xCFC9, { 0xE9, 0x89, 0xA4 },
	0xCFCA, { 0xE9, 0x8A, 0xB6 },
	0xCFCB, { 0xE9, 0xA7, 0x92 },
	0xCFCC, { 0xE9, 0xA9, 0x85 },
	0xCFCD, { 0xE9, 0xB3, 0xA9 },
	0xCFCE, { 0xE9, 0xB7, 0x97 },
	0xCFCF, { 0xE9, 0xBE, 0x9C },
	0xCFD0, { 0xE5, 0x9C, 0x8B },
	0xCFD1, { 0xE5, 0xB1, 0x80 },
	0xCFD2, { 0xE8, 0x8F, 0x8A },
	0xCFD3, { 0xE9, 0x9E, 0xA0 },
	0xCFD4, { 0xE9, 0x9E, 0xAB },
	0xCFD5, { 0xE9, 0xBA, 0xB4 },
	0xCFD6, { 0xE5, 0x90, 0x9B },
	0xCFD7, { 0xE7, 0xAA, 0x98 },
	0xCFD8, { 0xE7, 0xBE, 0xA4 },
	0xCFD9, { 0xE8, 0xA3, 0x99 },
	0xCFDA, { 0xE8, 0xBB, 0x8D },
	0xCFDB, { 0xE9, 0x83, 0xA1 },
	0xCFDC, { 0xE5, 0xA0, 0x80 },
	0xCFDD, { 0xE5, 0xB1, 0x88 },
	0xCFDE, { 0xE6, 0x8E, 0x98 },
	0xCFDF, { 0xE7, 0xAA, 0x9F },
	0xCFE0, { 0xE5, 0xAE, 0xAE },
	0xCFE1, { 0xE5, 0xBC, 0x93 },
	0xCFE2, { 0xE7, 0xA9, 0xB9 },
	0xCFE3, { 0xE7, 0xAA, 0xAE },
	0xCFE4, { 0xE8, 0x8A, 0x8E },
	0xCFE5, { 0xE8, 0xBA, 0xAC },
	0xCFE6, { 0xE5, 0x80, 0xA6 },
	0xCFE7, { 0xE5, 0x88, 0xB8 },
	0xCFE8, { 0xE5, 0x8B, 0xB8 },
	0xCFE9, { 0xE5, 0x8D, 0xB7 },
	0xCFEA, { 0xE5, 0x9C, 0x88 },
	0xCFEB, { 0xE6, 0x8B, 0xB3 },
	0xCFEC, { 0xE6, 0x8D, 0xB2 },
	0xCFED, { 0xE6, 0xAC, 0x8A },
	0xCFEE, { 0xE6, 0xB7, 0x83 },
	0xCFEF, { 0xE7, 0x9C, 0xB7 },
	0xCFF0, { 0xE5, 0x8E, 0xA5 },
	0xCFF1, { 0xE7, 0x8D, 0x97 },
	0xCFF2, { 0xE8, 0x95, 0xA8 },
	0xCFF3, { 0xE8, 0xB9, 0xB6 },
	0xCFF4, { 0xE9, 0x97, 0x95 },
	0xCFF5, { 0xE6, 0x9C, 0xBA },
	0xCFF6, { 0xE6, 0xAB, 0x83 },
	0xCFF7, { 0xE6, 0xBD, 0xB0 },
	0xCFF8, { 0xE8, 0xA9, 0xAD },
	0xCFF9, { 0xE8, 0xBB, 0x8C },
	0xCFFA, { 0xE9, 0xA5, 0x8B },
	0xCFFB, { 0xEF, 0xA4, 0x86 },
	0xCFFC, { 0xE6, 0x99, 0xB7 },
	0xCFFD, { 0xE6, 0xAD, 0xB8 },
	0xCFFE, { 0xE8, 0xB2, 0xB4 },
	0xD0A1, { 0xE9, 0xAC, 0xBC },
	0xD0A2, { 0xEF, 0xA4, 0x87 },
	0xD0A3, { 0xE5, 0x8F, 0xAB },
	0xD0A4, { 0xE5, 0x9C, 0xAD },
	0xD0A5, { 0xE5, 0xA5, 0x8E },
	0xD0A6, { 0xE6, 0x8F, 0x86 },
	0xD0A7, { 0xE6, 0xA7, 0xBB },
	0xD0A8, { 0xE7, 0x8F, 0xAA },
	0xD0A9, { 0xE7, 0xA1, 0x85 },
	0xD0AA, { 0xE7, 0xAA, 0xBA },
	0xD0AB, { 0xE7, 0xAB, 0x85 },
	0xD0AC, { 0xE7, 0xB3, 0xBE },
	0xD0AD, { 0xE8, 0x91, 0xB5 },
	0xD0AE, { 0xE8, 0xA6, 0x8F },
	0xD0AF, { 0xE8, 0xB5, 0xB3 },
	0xD0B0, { 0xE9, 0x80, 0xB5 },
	0xD0B1, { 0xE9, 0x96, 0xA8 },
	0xD0B2, { 0xE5, 0x8B, 0xBB },
	0xD0B3, { 0xE5, 0x9D, 0x87 },
	0xD0B4, { 0xE7, 0x95, 0x87 },
	0xD0B5, { 0xE7, 0xAD, 0xA0 },
	0xD0B6, { 0xE8, 0x8F, 0x8C },
	0xD0B7, { 0xE9, 0x88, 0x9E },
	0xD0B8, { 0xEF, 0xA4, 0x88 },
	0xD0B9, { 0xE6, 0xA9, 0x98 },
	0xD0BA, { 0xE5, 0x85, 0x8B },
	0xD0BB, { 0xE5, 0x89, 0x8B },
	0xD0BC, { 0xE5, 0x8A, 0x87 },
	0xD0BD, { 0xE6, 0x88, 0x9F },
	0xD0BE, { 0xE6, 0xA3, 0x98 },
	0xD0BF, { 0xE6, 0xA5, 0xB5 },
	0xD0C0, { 0xE9, 0x9A, 0x99 },
	0xD0C1, { 0xE5, 0x83, 0x85 },
	0xD0C2, { 0xE5, 0x8A, 0xA4 },
	0xD0C3, { 0xE5, 0x8B, 0xA4 },
	0xD0C4, { 0xE6, 0x87, 0x83 },
	0xD0C5, { 0xE6, 0x96, 0xA4 },
	0xD0C6, { 0xE6, 0xA0, 0xB9 },
	0xD0C7, { 0xE6, 0xA7, 0xBF },
	0xD0C8, { 0xE7, 0x91, 0xBE },
	0xD0C9, { 0xE7, 0xAD, 0x8B },
	0xD0CA, { 0xE8, 0x8A, 0xB9 },
	0xD0CB, { 0xE8, 0x8F, 0xAB },
	0xD0CC, { 0xE8, 0xA6, 0xB2 },
	0xD0CD, { 0xE8, 0xAC, 0xB9 },
	0xD0CE, { 0xE8, 0xBF, 0x91 },
	0xD0CF, { 0xE9, 0xA5, 0x89 },
	0xD0D0, { 0xEF, 0xA4, 0x89 },
	0xD0D1, { 0xE4, 0xBB, 0x8A },
	0xD0D2, { 0xE5, 0xA6, 0x97 },
	0xD0D3, { 0xE6, 0x93, 0x92 },
	0xD0D4, { 0xE6, 0x98, 0x91 },
	0xD0D5, { 0xE6, 0xAA, 0x8E },
	0xD0D6, { 0xE7, 0x90, 0xB4 },
	0xD0D7, { 0xE7, 0xA6, 0x81 },
	0xD0D8, { 0xE7, 0xA6, 0xBD },
	0xD0D9, { 0xE8, 0x8A, 0xA9 },
	0xD0DA, { 0xE8, 0xA1, 0xBE },
	0xD0DB, { 0xE8, 0xA1, 0xBF },
	0xD0DC, { 0xE8, 0xA5, 0x9F },
	0xD0DD, { 0xEF, 0xA4, 0x8A },
	0xD0DE, { 0xE9, 0x8C, 0xA6 },
	0xD0DF, { 0xE4, 0xBC, 0x8B },
	0xD0E0, { 0xE5, 0x8F, 0x8A },
	0xD0E1, { 0xE6, 0x80, 0xA5 },
	0xD0E2, { 0xE6, 0x89, 0xB1 },
	0xD0E3, { 0xE6, 0xB1, 0xB2 },
	0xD0E4, { 0xE7, 0xB4, 0x9A },
	0xD0E5, { 0xE7, 0xB5, 0xA6 },
	0xD0E6, { 0xE4, 0xBA, 0x98 },
	0xD0E7, { 0xE5, 0x85, 0xA2 },
	0xD0E8, { 0xE7, 0x9F, 0x9C },
	0xD0E9, { 0xE8, 0x82, 0xAF },
	0xD0EA, { 0xE4, 0xBC, 0x81 },
	0xD0EB, { 0xE4, 0xBC, 0x8E },
	0xD0EC, { 0xE5, 0x85, 0xB6 },
	0xD0ED, { 0xE5, 0x86, 0x80 },
	0xD0EE, { 0xE5, 0x97, 0x9C },
	0xD0EF, { 0xE5, 0x99, 0xA8 },
	0xD0F0, { 0xE5, 0x9C, 0xBB },
	0xD0F1, { 0xE5, 0x9F, 0xBA },
	0xD0F2, { 0xE5, 0x9F, 0xBC },
	0xD0F3, { 0xE5, 0xA4, 0x94 },
	0xD0F4, { 0xE5, 0xA5, 0x87 },
	0xD0F5, { 0xE5, 0xA6, 0x93 },
	0xD0F6, { 0xE5, 0xAF, 0x84 },
	0xD0F7, { 0xE5, 0xB2, 0x90 },
	0xD0F8, { 0xE5, 0xB4, 0x8E },
	0xD0F9, { 0xE5, 0xB7, 0xB1 },
	0xD0FA, { 0xE5, 0xB9, 0xBE },
	0xD0FB, { 0xE5, 0xBF, 0x8C },
	0xD0FC, { 0xE6, 0x8A, 0x80 },
	0xD0FD, { 0xE6, 0x97, 0x97 },
	0xD0FE, { 0xE6, 0x97, 0xA3 },
	0xD1A1, { 0xE6, 0x9C, 0x9E },
	0xD1A2, { 0xE6, 0x9C, 0x9F },
	0xD1A3, { 0xE6, 0x9D, 0x9E },
	0xD1A4, { 0xE6, 0xA3, 0x8B },
	0xD1A5, { 0xE6, 0xA3, 0x84 },
	0xD1A6, { 0xE6, 0xA9, 0x9F },
	0xD1A7, { 0xE6, 0xAC, 0xBA },
	0xD1A8, { 0xE6, 0xB0, 0xA3 },
	0xD1A9, { 0xE6, 0xB1, 0xBD },
	0xD1AA, { 0xE6, 0xB2, 0x82 },
	0xD1AB, { 0xE6, 0xB7, 0x87 },
	0xD1AC, { 0xE7, 0x8E, 0x98 },
	0xD1AD, { 0xE7, 0x90, 0xA6 },
	0xD1AE, { 0xE7, 0x90, 0xAA },
	0xD1AF, { 0xE7, 0x92, 0x82 },
	0xD1B0, { 0xE7, 0x92, 0xA3 },
	0xD1B1, { 0xE7, 0x95, 0xB8 },
	0xD1B2, { 0xE7, 0x95, 0xBF },
	0xD1B3, { 0xE7, 0xA2, 0x81 },
	0xD1B4, { 0xE7, 0xA3, 0xAF },
	0xD1B5, { 0xE7, 0xA5, 0x81 },
	0xD1B6, { 0xE7, 0xA5, 0x87 },
	0xD1B7, { 0xE7, 0xA5, 0x88 },
	0xD1B8, { 0xE7, 0xA5, 0xBA },
	0xD1B9, { 0xE7, 0xAE, 0x95 },
	0xD1BA, { 0xE7, 0xB4, 0x80 },
	0xD1BB, { 0xE7, 0xB6, 0xBA },
	0xD1BC, { 0xE7, 0xBE, 0x88 },
	0xD1BD, { 0xE8, 0x80, 0x86 },
	0xD1BE, { 0xE8, 0x80, 0xAD },
	0xD1BF, { 0xE8, 0x82, 0x8C },
	0xD1C0, { 0xE8, 0xA8, 0x98 },
	0xD1C1, { 0xE8, 0xAD, 0x8F },
	0xD1C2, { 0xE8, 0xB1, 0x88 },
	0xD1C3, { 0xE8, 0xB5, 0xB7 },
	0xD1C4, { 0xE9, 0x8C, 0xA1 },
	0xD1C5, { 0xE9, 0x8C, 0xA4 },
	0xD1C6, { 0xE9, 0xA3, 0xA2 },
	0xD1C7, { 0xE9, 0xA5, 0x91 },
	0xD1C8, { 0xE9, 0xA8, 0x8E },
	0xD1C9, { 0xE9, 0xA8, 0x8F },
	0xD1CA, { 0xE9, 0xA9, 0xA5 },
	0xD1CB, { 0xE9, 0xBA, 0x92 },
	0xD1CC, { 0xE7, 0xB7, 0x8A },
	0xD1CD, { 0xE4, 0xBD, 0xB6 },
	0xD1CE, { 0xE5, 0x90, 0x89 },
	0xD1CF, { 0xE6, 0x8B, 0xAE },
	0xD1D0, { 0xE6, 0xA1, 0x94 },
	0xD1D1, { 0xE9, 0x87, 0x91 },
	0xD1D2, { 0xE5, 0x96, 0xAB },
	0xD1D3, { 0xE5, 0x84, 0xBA },
	0xD1D4, { 0xEF, 0xA4, 0x8B },
	0xD1D5, { 0xEF, 0xA4, 0x8C },
	0xD1D6, { 0xE5, 0xA8, 0x9C },
	0xD1D7, { 0xE6, 0x87, 0xA6 },
	0xD1D8, { 0xEF, 0xA4, 0x8D },
	0xD1D9, { 0xE6, 0x8B, 0x8F },
	0xD1DA, { 0xE6, 0x8B, 0xBF },
	0xD1DB, { 0xEF, 0xA4, 0x8E },
	0xD1DC, { 0xEF, 0xA4, 0x8F },
	0xD1DD, { 0xEF, 0xA4, 0x90 },
	0xD1DE, { 0xEF, 0xA4, 0x91 },
	0xD1DF, { 0xEF, 0xA4, 0x92 },
	0xD1E0, { 0xEF, 0xA4, 0x93 },
	0xD1E1, { 0xE9, 0x82, 0xA3 },
	0xD1E2, { 0xEF, 0xA4, 0x94 },
	0xD1E3, { 0xEF, 0xA4, 0x95 },
	0xD1E4, { 0xEF, 0xA4, 0x96 },
	0xD1E5, { 0xEF, 0xA4, 0x97 },
	0xD1E6, { 0xEF, 0xA4, 0x98 },
	0xD1E7, { 0xE8, 0xAB, 0xBE },
	0xD1E8, { 0xEF, 0xA4, 0x99 },
	0xD1E9, { 0xEF, 0xA4, 0x9A },
	0xD1EA, { 0xEF, 0xA4, 0x9B },
	0xD1EB, { 0xEF, 0xA4, 0x9C },
	0xD1EC, { 0xE6, 0x9A, 0x96 },
	0xD1ED, { 0xEF, 0xA4, 0x9D },
	0xD1EE, { 0xE7, 0x85, 0x96 },
	0xD1EF, { 0xEF, 0xA4, 0x9E },
	0xD1F0, { 0xEF, 0xA4, 0x9F },
	0xD1F1, { 0xE9, 0x9B, 0xA3 },
	0xD1F2, { 0xEF, 0xA4, 0xA0 },
	0xD1F3, { 0xE6, 0x8D, 0x8F },
	0xD1F4, { 0xE6, 0x8D, 0xBA },
	0xD1F5, { 0xE5, 0x8D, 0x97 },
	0xD1F6, { 0xEF, 0xA4, 0xA1 },
	0xD1F7, { 0xE6, 0x9E, 0x8F },
	0xD1F8, { 0xE6, 0xA5, 0xA0 },
	0xD1F9, { 0xE6, 0xB9, 0xB3 },
	0xD1FA, { 0xEF, 0xA4, 0xA2 },
	0xD1FB, { 0xE7, 0x94, 0xB7 },
	0xD1FC, { 0xEF, 0xA4, 0xA3 },
	0xD1FD, { 0xEF, 0xA4, 0xA4 },
	0xD1FE, { 0xEF, 0xA4, 0xA5 },
	0xD2A1, { 0xE7, 0xB4, 0x8D },
	0xD2A2, { 0xEF, 0xA4, 0xA6 },
	0xD2A3, { 0xEF, 0xA4, 0xA7 },
	0xD2A4, { 0xE8, 0xA1, 0xB2 },
	0xD2A5, { 0xE5, 0x9B, 0x8A },
	0xD2A6, { 0xE5, 0xA8, 0x98 },
	0xD2A7, { 0xEF, 0xA4, 0xA8 },
	0xD2A8, { 0xEF, 0xA4, 0xA9 },
	0xD2A9, { 0xEF, 0xA4, 0xAA },
	0xD2AA, { 0xEF, 0xA4, 0xAB },
	0xD2AB, { 0xEF, 0xA4, 0xAC },
	0xD2AC, { 0xE4, 0xB9, 0x83 },
	0xD2AD, { 0xEF, 0xA4, 0xAD },
	0xD2AE, { 0xE5, 0x85, 0xA7 },
	0xD2AF, { 0xE5, 0xA5, 0x88 },
	0xD2B0, { 0xE6, 0x9F, 0xB0 },
	0xD2B1, { 0xE8, 0x80, 0x90 },
	0xD2B2, { 0xEF, 0xA4, 0xAE },
	0xD2B3, { 0xE5, 0xA5, 0xB3 },
	0xD2B4, { 0xE5, 0xB9, 0xB4 },
	0xD2B5, { 0xE6, 0x92, 0x9A },
	0xD2B6, { 0xE7, 0xA7, 0x8A },
	0xD2B7, { 0xE5, 0xBF, 0xB5 },
	0xD2B8, { 0xE6, 0x81, 0xAC },
	0xD2B9, { 0xE6, 0x8B, 0x88 },
	0xD2BA, { 0xE6, 0x8D, 0xBB },
	0xD2BB, { 0xE5, 0xAF, 0xA7 },
	0xD2BC, { 0xE5, 0xAF, 0x97 },
	0xD2BD, { 0xE5, 0x8A, 0xAA },
	0xD2BE, { 0xEF, 0xA4, 0xAF },
	0xD2BF, { 0xE5, 0xA5, 0xB4 },
	0xD2C0, { 0xE5, 0xBC, 0xA9 },
	0xD2C1, { 0xE6, 0x80, 0x92 },
	0xD2C2, { 0xEF, 0xA4, 0xB0 },
	0xD2C3, { 0xEF, 0xA4, 0xB1 },
	0xD2C4, { 0xEF, 0xA4, 0xB2 },
	0xD2C5, { 0xE7, 0x91, 0x99 },
	0xD2C6, { 0xEF, 0xA4, 0xB3 },
	0xD2C7, { 0xEF, 0xA4, 0xB4 },
	0xD2C8, { 0xEF, 0xA4, 0xB5 },
	0xD2C9, { 0xEF, 0xA4, 0xB6 },
	0xD2CA, { 0xEF, 0xA4, 0xB7 },
	0xD2CB, { 0xEF, 0xA4, 0xB8 },
	0xD2CC, { 0xE9, 0xA7, 0x91 },
	0xD2CD, { 0xEF, 0xA4, 0xB9 },
	0xD2CE, { 0xEF, 0xA4, 0xBA },
	0xD2CF, { 0xEF, 0xA4, 0xBB },
	0xD2D0, { 0xEF, 0xA4, 0xBC },
	0xD2D1, { 0xEF, 0xA4, 0xBD },
	0xD2D2, { 0xEF, 0xA4, 0xBE },
	0xD2D3, { 0xEF, 0xA4, 0xBF },
	0xD2D4, { 0xEF, 0xA5, 0x80 },
	0xD2D5, { 0xEF, 0xA5, 0x81 },
	0xD2D6, { 0xEF, 0xA5, 0x82 },
	0xD2D7, { 0xEF, 0xA5, 0x83 },
	0xD2D8, { 0xE6, 0xBF, 0x83 },
	0xD2D9, { 0xEF, 0xA5, 0x84 },
	0xD2DA, { 0xEF, 0xA5, 0x85 },
	0xD2DB, { 0xE8, 0x86, 0xBF },
	0xD2DC, { 0xE8, 0xBE, 0xB2 },
	0xD2DD, { 0xE6, 0x83, 0xB1 },
	0xD2DE, { 0xEF, 0xA5, 0x86 },
	0xD2DF, { 0xEF, 0xA5, 0x87 },
	0xD2E0, { 0xE8, 0x85, 0xA6 },
	0xD2E1, { 0xEF, 0xA5, 0x88 },
	0xD2E2, { 0xEF, 0xA5, 0x89 },
	0xD2E3, { 0xE5, 0xB0, 0xBF },
	0xD2E4, { 0xEF, 0xA5, 0x8A },
	0xD2E5, { 0xEF, 0xA5, 0x8B },
	0xD2E6, { 0xEF, 0xA5, 0x8C },
	0xD2E7, { 0xEF, 0xA5, 0x8D },
	0xD2E8, { 0xEF, 0xA5, 0x8E },
	0xD2E9, { 0xEF, 0xA5, 0x8F },
	0xD2EA, { 0xEF, 0xA5, 0x90 },
	0xD2EB, { 0xEF, 0xA5, 0x91 },
	0xD2EC, { 0xE5, 0xAB, 0xA9 },
	0xD2ED, { 0xE8, 0xA8, 0xA5 },
	0xD2EE, { 0xE6, 0x9D, 0xBB },
	0xD2EF, { 0xE7, 0xB4, 0x90 },
	0xD2F0, { 0xEF, 0xA5, 0x92 },
	0xD2F1, { 0xEF, 0xA5, 0x93 },
	0xD2F2, { 0xEF, 0xA5, 0x94 },
	0xD2F3, { 0xEF, 0xA5, 0x95 },
	0xD2F4, { 0xEF, 0xA5, 0x96 },
	0xD2F5, { 0xEF, 0xA5, 0x97 },
	0xD2F6, { 0xE8, 0x83, 0xBD },
	0xD2F7, { 0xEF, 0xA5, 0x98 },
	0xD2F8, { 0xEF, 0xA5, 0x99 },
	0xD2F9, { 0xE5, 0xB0, 0xBC },
	0xD2FA, { 0xE6, 0xB3, 0xA5 },
	0xD2FB, { 0xE5, 0x8C, 0xBF },
	0xD2FC, { 0xE6, 0xBA, 0xBA },
	0xD2FD, { 0xE5, 0xA4, 0x9A },
	0xD2FE, { 0xE8, 0x8C, 0xB6 },
	0xD3A1, { 0xE4, 0xB8, 0xB9 },
	0xD3A2, { 0xE4, 0xBA, 0xB6 },
	0xD3A3, { 0xE4, 0xBD, 0x86 },
	0xD3A4, { 0xE5, 0x96, 0xAE },
	0xD3A5, { 0xE5, 0x9C, 0x98 },
	0xD3A6, { 0xE5, 0xA3, 0x87 },
	0xD3A7, { 0xE5, 0xBD, 0x96 },
	0xD3A8, { 0xE6, 0x96, 0xB7 },
	0xD3A9, { 0xE6, 0x97, 0xA6 },
	0xD3AA, { 0xE6, 0xAA, 0x80 },
	0xD3AB, { 0xE6, 0xAE, 0xB5 },
	0xD3AC, { 0xE6, 0xB9, 0x8D },
	0xD3AD, { 0xE7, 0x9F, 0xAD },
	0xD3AE, { 0xE7, 0xAB, 0xAF },
	0xD3AF, { 0xE7, 0xB0, 0x9E },
	0xD3B0, { 0xE7, 0xB7, 0x9E },
	0xD3B1, { 0xE8, 0x9B, 0x8B },
	0xD3B2, { 0xE8, 0xA2, 0x92 },
	0xD3B3, { 0xE9, 0x84, 0xB2 },
	0xD3B4, { 0xE9, 0x8D, 0x9B },
	0xD3B5, { 0xE6, 0x92, 0xBB },
	0xD3B6, { 0xE6, 0xBE, 0xBE },
	0xD3B7, { 0xE7, 0x8D, 0xBA },
	0xD3B8, { 0xE7, 0x96, 0xB8 },
	0xD3B9, { 0xE9, 0x81, 0x94 },
	0xD3BA, { 0xE5, 0x95, 0x96 },
	0xD3BB, { 0xE5, 0x9D, 0x8D },
	0xD3BC, { 0xE6, 0x86, 0xBA },
	0xD3BD, { 0xE6, 0x93, 0x94 },
	0xD3BE, { 0xE6, 0x9B, 0x87 },
	0xD3BF, { 0xE6, 0xB7, 0xA1 },
	0xD3C0, { 0xE6, 0xB9, 0x9B },
	0xD3C1, { 0xE6, 0xBD, 0xAD },
	0xD3C2, { 0xE6, 0xBE, 0xB9 },
	0xD3C3, { 0xE7, 0x97, 0xB0 },
	0xD3C4, { 0xE8, 0x81, 0x83 },
	0xD3C5, { 0xE8, 0x86, 0xBD },
	0xD3C6, { 0xE8, 0x95, 0x81 },
	0xD3C7, { 0xE8, 0xA6, 0x83 },
	0xD3C8, { 0xE8, 0xAB, 0x87 },
	0xD3C9, { 0xE8, 0xAD, 0x9A },
	0xD3CA, { 0xE9, 0x8C, 0x9F },
	0xD3CB, { 0xE6, 0xB2, 0x93 },
	0xD3CC, { 0xE7, 0x95, 0x93 },
	0xD3CD, { 0xE7, 0xAD, 0x94 },
	0xD3CE, { 0xE8, 0xB8, 0x8F },
	0xD3CF, { 0xE9, 0x81, 0x9D },
	0xD3D0, { 0xE5, 0x94, 0x90 },
	0xD3D1, { 0xE5, 0xA0, 0x82 },
	0xD3D2, { 0xE5, 0xA1, 0x98 },
	0xD3D3, { 0xE5, 0xB9, 0xA2 },
	0xD3D4, { 0xE6, 0x88, 0x87 },
	0xD3D5, { 0xE6, 0x92, 0x9E },
	0xD3D6, { 0xE6, 0xA3, 0xA0 },
	0xD3D7, { 0xE7, 0x95, 0xB6 },
	0xD3D8, { 0xE7, 0xB3, 0x96 },
	0xD3D9, { 0xE8, 0x9E, 0xB3 },
	0xD3DA, { 0xE9, 0xBB, 0xA8 },
	0xD3DB, { 0xE4, 0xBB, 0xA3 },
	0xD3DC, { 0xE5, 0x9E, 0x88 },
	0xD3DD, { 0xE5, 0x9D, 0xAE },
	0xD3DE, { 0xE5, 0xA4, 0xA7 },
	0xD3DF, { 0xE5, 0xB0, 0x8D },
	0xD3E0, { 0xE5, 0xB2, 0xB1 },
	0xD3E1, { 0xE5, 0xB8, 0xB6 },
	0xD3E2, { 0xE5, 0xBE, 0x85 },
	0xD3E3, { 0xE6, 0x88, 0xB4 },
	0xD3E4, { 0xE6, 0x93, 0xA1 },
	0xD3E5, { 0xE7, 0x8E, 0xB3 },
	0xD3E6, { 0xE8, 0x87, 0xBA },
	0xD3E7, { 0xE8, 0xA2, 0x8B },
	0xD3E8, { 0xE8, 0xB2, 0xB8 },
	0xD3E9, { 0xE9, 0x9A, 0x8A },
	0xD3EA, { 0xE9, 0xBB, 0x9B },
	0xD3EB, { 0xE5, 0xAE, 0x85 },
	0xD3EC, { 0xE5, 0xBE, 0xB7 },
	0xD3ED, { 0xE6, 0x82, 0xB3 },
	0xD3EE, { 0xE5, 0x80, 0x92 },
	0xD3EF, { 0xE5, 0x88, 0x80 },
	0xD3F0, { 0xE5, 0x88, 0xB0 },
	0xD3F1, { 0xE5, 0x9C, 0x96 },
	0xD3F2, { 0xE5, 0xA0, 0xB5 },
	0xD3F3, { 0xE5, 0xA1, 0x97 },
	0xD3F4, { 0xE5, 0xB0, 0x8E },
	0xD3F5, { 0xE5, 0xB1, 0xA0 },
	0xD3F6, { 0xE5, 0xB3, 0xB6 },
	0xD3F7, { 0xE5, 0xB6, 0x8B },
	0xD3F8, { 0xE5, 0xBA, 0xA6 },
	0xD3F9, { 0xE5, 0xBE, 0x92 },
	0xD3FA, { 0xE6, 0x82, 0xBC },
	0xD3FB, { 0xE6, 0x8C, 0x91 },
	0xD3FC, { 0xE6, 0x8E, 0x89 },
	0xD3FD, { 0xE6, 0x90, 0x97 },
	0xD3FE, { 0xE6, 0xA1, 0x83 },
	0xD4A1, { 0xE6, 0xA3, 0xB9 },
	0xD4A2, { 0xE6, 0xAB, 0x82 },
	0xD4A3, { 0xE6, 0xB7, 0x98 },
	0xD4A4, { 0xE6, 0xB8, 0xA1 },
	0xD4A5, { 0xE6, 0xBB, 0x94 },
	0xD4A6, { 0xE6, 0xBF, 0xA4 },
	0xD4A7, { 0xE7, 0x87, 0xBE },
	0xD4A8, { 0xE7, 0x9B, 0x9C },
	0xD4A9, { 0xE7, 0x9D, 0xB9 },
	0xD4AA, { 0xE7, 0xA6, 0xB1 },
	0xD4AB, { 0xE7, 0xA8, 0xBB },
	0xD4AC, { 0xE8, 0x90, 0x84 },
	0xD4AD, { 0xE8, 0xA6, 0xA9 },
	0xD4AE, { 0xE8, 0xB3, 0xAD },
	0xD4AF, { 0xE8, 0xB7, 0xB3 },
	0xD4B0, { 0xE8, 0xB9, 0x88 },
	0xD4B1, { 0xE9, 0x80, 0x83 },
	0xD4B2, { 0xE9, 0x80, 0x94 },
	0xD4B3, { 0xE9, 0x81, 0x93 },
	0xD4B4, { 0xE9, 0x83, 0xBD },
	0xD4B5, { 0xE9, 0x8D, 0x8D },
	0xD4B6, { 0xE9, 0x99, 0xB6 },
	0xD4B7, { 0xE9, 0x9F, 0x9C },
	0xD4B8, { 0xE6, 0xAF, 0x92 },
	0xD4B9, { 0xE7, 0x80, 0x86 },
	0xD4BA, { 0xE7, 0x89, 0x98 },
	0xD4BB, { 0xE7, 0x8A, 0xA2 },
	0xD4BC, { 0xE7, 0x8D, 0xA8 },
	0xD4BD, { 0xE7, 0x9D, 0xA3 },
	0xD4BE, { 0xE7, 0xA6, 0xBF },
	0xD4BF, { 0xE7, 0xAF, 0xA4 },
	0xD4C0, { 0xE7, 0xBA, 0x9B },
	0xD4C1, { 0xE8, 0xAE, 0x80 },
	0xD4C2, { 0xE5, 0xA2, 0xA9 },
	0xD4C3, { 0xE6, 0x83, 0x87 },
	0xD4C4, { 0xE6, 0x95, 0xA6 },
	0xD4C5, { 0xE6, 0x97, 0xBD },
	0xD4C6, { 0xE6, 0x9A, 0xBE },
	0xD4C7, { 0xE6, 0xB2, 0x8C },
	0xD4C8, { 0xE7, 0x84, 0x9E },
	0xD4C9, { 0xE7, 0x87, 0x89 },
	0xD4CA, { 0xE8, 0xB1, 0x9A },
	0xD4CB, { 0xE9, 0xA0, 0x93 },
	0xD4CC, { 0xE4, 0xB9, 0xAD },
	0xD4CD, { 0xE7, 0xAA, 0x81 },
	0xD4CE, { 0xE4, 0xBB, 0x9D },
	0xD4CF, { 0xE5, 0x86, 0xAC },
	0xD4D0, { 0xE5, 0x87, 0x8D },
	0xD4D1, { 0xE5, 0x8B, 0x95 },
	0xD4D2, { 0xE5, 0x90, 0x8C },
	0xD4D3, { 0xE6, 0x86, 0xA7 },
	0xD4D4, { 0xE6, 0x9D, 0xB1 },
	0xD4D5, { 0xE6, 0xA1, 0x90 },
	0xD4D6, { 0xE6, 0xA3, 0x9F },
	0xD4D7, { 0xE6, 0xB4, 0x9E },
	0xD4D8, { 0xE6, 0xBD, 0xBC },
	0xD4D9, { 0xE7, 0x96, 0xBC },
	0xD4DA, { 0xE7, 0x9E, 0xB3 },
	0xD4DB, { 0xE7, 0xAB, 0xA5 },
	0xD4DC, { 0xE8, 0x83, 0xB4 },
	0xD4DD, { 0xE8, 0x91, 0xA3 },
	0xD4DE, { 0xE9, 0x8A, 0x85 },
	0xD4DF, { 0xE5, 0x85, 0x9C },
	0xD4E0, { 0xE6, 0x96, 0x97 },
	0xD4E1, { 0xE6, 0x9D, 0x9C },
	0xD4E2, { 0xE6, 0x9E, 0x93 },
	0xD4E3, { 0xE7, 0x97, 0x98 },
	0xD4E4, { 0xE7, 0xAB, 0x87 },
	0xD4E5, { 0xE8, 0x8D, 0xB3 },
	0xD4E6, { 0xEF, 0xA5, 0x9A },
	0xD4E7, { 0xE8, 0xB1, 0x86 },
	0xD4E8, { 0xE9, 0x80, 0x97 },
	0xD4E9, { 0xE9, 0xA0, 0xAD },
	0xD4EA, { 0xE5, 0xB1, 0xAF },
	0xD4EB, { 0xE8, 0x87, 0x80 },
	0xD4EC, { 0xE8, 0x8A, 0x9A },
	0xD4ED, { 0xE9, 0x81, 0x81 },
	0xD4EE, { 0xE9, 0x81, 0xAF },
	0xD4EF, { 0xE9, 0x88, 0x8D },
	0xD4F0, { 0xE5, 0xBE, 0x97 },
	0xD4F1, { 0xE5, 0xB6, 0x9D },
	0xD4F2, { 0xE6, 0xA9, 0x99 },
	0xD4F3, { 0xE7, 0x87, 0x88 },
	0xD4F4, { 0xE7, 0x99, 0xBB },
	0xD4F5, { 0xE7, 0xAD, 0x89 },
	0xD4F6, { 0xE8, 0x97, 0xA4 },
	0xD4F7, { 0xE8, 0xAC, 0x84 },
	0xD4F8, { 0xE9, 0x84, 0xA7 },
	0xD4F9, { 0xE9, 0xA8, 0xB0 },
	0xD4FA, { 0xE5, 0x96, 0x87 },
	0xD4FB, { 0xE6, 0x87, 0xB6 },
	0xD4FC, { 0xEF, 0xA5, 0x9B },
	0xD4FD, { 0xE7, 0x99, 0xA9 },
	0xD4FE, { 0xE7, 0xBE, 0x85 },
	0xD5A1, { 0xE8, 0x98, 0xBF },
	0xD5A2, { 0xE8, 0x9E, 0xBA },
	0xD5A3, { 0xE8, 0xA3, 0xB8 },
	0xD5A4, { 0xE9, 0x82, 0x8F },
	0xD5A5, { 0xEF, 0xA5, 0x9C },
	0xD5A6, { 0xE6, 0xB4, 0x9B },
	0xD5A7, { 0xE7, 0x83, 0x99 },
	0xD5A8, { 0xE7, 0x8F, 0x9E },
	0xD5A9, { 0xE7, 0xB5, 0xA1 },
	0xD5AA, { 0xE8, 0x90, 0xBD },
	0xD5AB, { 0xEF, 0xA5, 0x9D },
	0xD5AC, { 0xE9, 0x85, 0xAA },
	0xD5AD, { 0xE9, 0xA7, 0xB1 },
	0xD5AE, { 0xEF, 0xA5, 0x9E },
	0xD5AF, { 0xE4, 0xBA, 0x82 },
	0xD5B0, { 0xE5, 0x8D, 0xB5 },
	0xD5B1, { 0xE6, 0xAC, 0x84 },
	0xD5B2, { 0xE6, 0xAC, 0x92 },
	0xD5B3, { 0xE7, 0x80, 0xBE },
	0xD5B4, { 0xE7, 0x88, 0x9B },
	0xD5B5, { 0xE8, 0x98, 0xAD },
	0xD5B6, { 0xE9, 0xB8, 0x9E },
	0xD5B7, { 0xE5, 0x89, 0x8C },
	0xD5B8, { 0xE8, 0xBE, 0xA3 },
	0xD5B9, { 0xE5, 0xB5, 0x90 },
	0xD5BA, { 0xE6, 0x93, 0xA5 },
	0xD5BB, { 0xE6, 0x94, 0xAC },
	0xD5BC, { 0xE6, 0xAC, 0x96 },
	0xD5BD, { 0xE6, 0xBF, 0xAB },
	0xD5BE, { 0xE7, 0xB1, 0x83 },
	0xD5BF, { 0xE7, 0xBA, 0x9C },
	0xD5C0, { 0xE8, 0x97, 0x8D },
	0xD5C1, { 0xE8, 0xA5, 0xA4 },
	0xD5C2, { 0xE8, 0xA6, 0xBD },
	0xD5C3, { 0xE6, 0x8B, 0x89 },
	0xD5C4, { 0xE8, 0x87, 0x98 },
	0xD5C5, { 0xE8, 0xA0, 0x9F },
	0xD5C6, { 0xE5, 0xBB, 0x8A },
	0xD5C7, { 0xE6, 0x9C, 0x97 },
	0xD5C8, { 0xE6, 0xB5, 0xAA },
	0xD5C9, { 0xE7, 0x8B, 0xBC },
	0xD5CA, { 0xE7, 0x90, 0x85 },
	0xD5CB, { 0xE7, 0x91, 0xAF },
	0xD5CC, { 0xE8, 0x9E, 0x82 },
	0xD5CD, { 0xE9, 0x83, 0x9E },
	0xD5CE, { 0xE4, 0xBE, 0x86 },
	0xD5CF, { 0xE5, 0xB4, 0x8D },
	0xD5D0, { 0xE5, 0xBE, 0xA0 },
	0xD5D1, { 0xE8, 0x90, 0x8A },
	0xD5D2, { 0xE5, 0x86, 0xB7 },
	0xD5D3, { 0xE6, 0x8E, 0xA0 },
	0xD5D4, { 0xE7, 0x95, 0xA5 },
	0xD5D5, { 0xE4, 0xBA, 0xAE },
	0xD5D6, { 0xE5, 0x80, 0x86 },
	0xD5D7, { 0xE5, 0x85, 0xA9 },
	0xD5D8, { 0xE5, 0x87, 0x89 },
	0xD5D9, { 0xE6, 0xA2, 0x81 },
	0xD5DA, { 0xE6, 0xA8, 0x91 },
	0xD5DB, { 0xE7, 0xB2, 0xAE },
	0xD5DC, { 0xE7, 0xB2, 0xB1 },
	0xD5DD, { 0xE7, 0xB3, 0xA7 },
	0xD5DE, { 0xE8, 0x89, 0xAF },
	0xD5DF, { 0xE8, 0xAB, 0x92 },
	0xD5E0, { 0xE8, 0xBC, 0x9B },
	0xD5E1, { 0xE9, 0x87, 0x8F },
	0xD5E2, { 0xE4, 0xBE, 0xB6 },
	0xD5E3, { 0xE5, 0x84, 0xB7 },
	0xD5E4, { 0xE5, 0x8B, 0xB5 },
	0xD5E5, { 0xE5, 0x91, 0x82 },
	0xD5E6, { 0xE5, 0xBB, 0xAC },
	0xD5E7, { 0xE6, 0x85, 0xAE },
	0xD5E8, { 0xE6, 0x88, 0xBE },
	0xD5E9, { 0xE6, 0x97, 0x85 },
	0xD5EA, { 0xE6, 0xAB, 0x9A },
	0xD5EB, { 0xE6, 0xBF, 0xBE },
	0xD5EC, { 0xE7, 0xA4, 0xAA },
	0xD5ED, { 0xE8, 0x97, 0x9C },
	0xD5EE, { 0xE8, 0xA0, 0xA3 },
	0xD5EF, { 0xE9, 0x96, 0xAD },
	0xD5F0, { 0xE9, 0xA9, 0xA2 },
	0xD5F1, { 0xE9, 0xA9, 0xAA },
	0xD5F2, { 0xE9, 0xBA, 0x97 },
	0xD5F3, { 0xE9, 0xBB, 0x8E },
	0xD5F4, { 0xE5, 0x8A, 0x9B },
	0xD5F5, { 0xE6, 0x9B, 0x86 },
	0xD5F6, { 0xE6, 0xAD, 0xB7 },
	0xD5F7, { 0xE7, 0x80, 0x9D },
	0xD5F8, { 0xE7, 0xA4, 0xAB },
	0xD5F9, { 0xE8, 0xBD, 0xA2 },
	0xD5FA, { 0xE9, 0x9D, 0x82 },
	0xD5FB, { 0xE6, 0x86, 0x90 },
	0xD5FC, { 0xE6, 0x88, 0x80 },
	0xD5FD, { 0xE6, 0x94, 0xA3 },
	0xD5FE, { 0xE6, 0xBC, 0xA3 },
	0xD6A1, { 0xE7, 0x85, 0x89 },
	0xD6A2, { 0xE7, 0x92, 0x89 },
	0xD6A3, { 0xE7, 0xB7, 0xB4 },
	0xD6A4, { 0xE8, 0x81, 0xAF },
	0xD6A5, { 0xE8, 0x93, 0xAE },
	0xD6A6, { 0xE8, 0xBC, 0xA6 },
	0xD6A7, { 0xE9, 0x80, 0xA3 },
	0xD6A8, { 0xE9, 0x8D, 0x8A },
	0xD6A9, { 0xE5, 0x86, 0xBD },
	0xD6AA, { 0xE5, 0x88, 0x97 },
	0xD6AB, { 0xE5, 0x8A, 0xA3 },
	0xD6AC, { 0xE6, 0xB4, 0x8C },
	0xD6AD, { 0xE7, 0x83, 0x88 },
	0xD6AE, { 0xE8, 0xA3, 0x82 },
	0xD6AF, { 0xE5, 0xBB, 0x89 },
	0xD6B0, { 0xE6, 0x96, 0x82 },
	0xD6B1, { 0xE6, 0xAE, 0xAE },
	0xD6B2, { 0xE6, 0xBF, 0x82 },
	0xD6B3, { 0xE7, 0xB0, 0xBE },
	0xD6B4, { 0xE7, 0x8D, 0xB5 },
	0xD6B5, { 0xE4, 0xBB, 0xA4 },
	0xD6B6, { 0xE4, 0xBC, 0xB6 },
	0xD6B7, { 0xE5, 0x9B, 0xB9 },
	0xD6B8, { 0xEF, 0xA5, 0x9F },
	0xD6B9, { 0xE5, 0xB2, 0xBA },
	0xD6BA, { 0xE5, 0xB6, 0xBA },
	0xD6BB, { 0xE6, 0x80, 0x9C },
	0xD6BC, { 0xE7, 0x8E, 0xB2 },
	0xD6BD, { 0xE7, 0xAC, 0xAD },
	0xD6BE, { 0xE7, 0xBE, 0x9A },
	0xD6BF, { 0xE7, 0xBF, 0x8E },
	0xD6C0, { 0xE8, 0x81, 0x86 },
	0xD6C1, { 0xE9, 0x80, 0x9E },
	0xD6C2, { 0xE9, 0x88, 0xB4 },
	0xD6C3, { 0xE9, 0x9B, 0xB6 },
	0xD6C4, { 0xE9, 0x9D, 0x88 },
	0xD6C5, { 0xE9, 0xA0, 0x98 },
	0xD6C6, { 0xE9, 0xBD, 0xA1 },
	0xD6C7, { 0xE4, 0xBE, 0x8B },
	0xD6C8, { 0xE6, 0xBE, 0xA7 },
	0xD6C9, { 0xE7, 0xA6, 0xAE },
	0xD6CA, { 0xE9, 0x86, 0xB4 },
	0xD6CB, { 0xE9, 0x9A, 0xB7 },
	0xD6CC, { 0xE5, 0x8B, 0x9E },
	0xD6CD, { 0xEF, 0xA5, 0xA0 },
	0xD6CE, { 0xE6, 0x92, 0x88 },
	0xD6CF, { 0xE6, 0x93, 0x84 },
	0xD6D0, { 0xE6, 0xAB, 0x93 },
	0xD6D1, { 0xE6, 0xBD, 0x9E },
	0xD6D2, { 0xE7, 0x80, 0x98 },
	0xD6D3, { 0xE7, 0x88, 0x90 },
	0xD6D4, { 0xE7, 0x9B, 0xA7 },
	0xD6D5, { 0xE8, 0x80, 0x81 },
	0xD6D6, { 0xE8, 0x98, 0x86 },
	0xD6D7, { 0xE8, 0x99, 0x9C },
	0xD6D8, { 0xE8, 0xB7, 0xAF },
	0xD6D9, { 0xE8, 0xBC, 0x85 },
	0xD6DA, { 0xE9, 0x9C, 0xB2 },
	0xD6DB, { 0xE9, 0xAD, 0xAF },
	0xD6DC, { 0xE9, 0xB7, 0xBA },
	0xD6DD, { 0xE9, 0xB9, 0xB5 },
	0xD6DE, { 0xE7, 0xA2, 0x8C },
	0xD6DF, { 0xE7, 0xA5, 0xBF },
	0xD6E0, { 0xE7, 0xB6, 0xA0 },
	0xD6E1, { 0xE8, 0x8F, 0x89 },
	0xD6E2, { 0xE9, 0x8C, 0x84 },
	0xD6E3, { 0xE9, 0xB9, 0xBF },
	0xD6E4, { 0xE9, 0xBA, 0x93 },
	0xD6E5, { 0xE8, 0xAB, 0x96 },
	0xD6E6, { 0xE5, 0xA3, 0x9F },
	0xD6E7, { 0xE5, 0xBC, 0x84 },
	0xD6E8, { 0xE6, 0x9C, 0xA7 },
	0xD6E9, { 0xE7, 0x80, 0xA7 },
	0xD6EA, { 0xE7, 0x93, 0x8F },
	0xD6EB, { 0xE7, 0xB1, 0xA0 },
	0xD6EC, { 0xE8, 0x81, 0xBE },
	0xD6ED, { 0xE5, 0x84, 0xA1 },
	0xD6EE, { 0xE7, 0x80, 0xA8 },
	0xD6EF, { 0xE7, 0x89, 0xA2 },
	0xD6F0, { 0xE7, 0xA3, 0x8A },
	0xD6F1, { 0xE8, 0xB3, 0x82 },
	0xD6F2, { 0xE8, 0xB3, 0x9A },
	0xD6F3, { 0xE8, 0xB3, 0xB4 },
	0xD6F4, { 0xE9, 0x9B, 0xB7 },
	0xD6F5, { 0xE4, 0xBA, 0x86 },
	0xD6F6, { 0xE5, 0x83, 0x9A },
	0xD6F7, { 0xE5, 0xAF, 0xAE },
	0xD6F8, { 0xE5, 0xBB, 0x96 },
	0xD6F9, { 0xE6, 0x96, 0x99 },
	0xD6FA, { 0xE7, 0x87, 0x8E },
	0xD6FB, { 0xE7, 0x99, 0x82 },
	0xD6FC, { 0xE7, 0x9E, 0xAD },
	0xD6FD, { 0xE8, 0x81, 0x8A },
	0xD6FE, { 0xE8, 0x93, 0xBC },
	0xD7A1, { 0xE9, 0x81, 0xBC },
	0xD7A2, { 0xE9, 0xAC, 0xA7 },
	0xD7A3, { 0xE9, 0xBE, 0x8D },
	0xD7A4, { 0xE5, 0xA3, 0x98 },
	0xD7A5, { 0xE5, 0xA9, 0x81 },
	0xD7A6, { 0xE5, 0xB1, 0xA2 },
	0xD7A7, { 0xE6, 0xA8, 0x93 },
	0xD7A8, { 0xE6, 0xB7, 0x9A },
	0xD7A9, { 0xE6, 0xBC, 0x8F },
	0xD7AA, { 0xE7, 0x98, 0xBB },
	0xD7AB, { 0xE7, 0xB4, 0xAF },
	0xD7AC, { 0xE7, 0xB8, 0xB7 },
	0xD7AD, { 0xE8, 0x94, 0x9E },
	0xD7AE, { 0xE8, 0xA4, 0xB8 },
	0xD7AF, { 0xE9, 0x8F, 0xA4 },
	0xD7B0, { 0xE9, 0x99, 0x8B },
	0xD7B1, { 0xE5, 0x8A, 0x89 },
	0xD7B2, { 0xE6, 0x97, 0x92 },
	0xD7B3, { 0xE6, 0x9F, 0xB3 },
	0xD7B4, { 0xE6, 0xA6, 0xB4 },
	0xD7B5, { 0xE6, 0xB5, 0x81 },
	0xD7B6, { 0xE6, 0xBA, 0x9C },
	0xD7B7, { 0xE7, 0x80, 0x8F },
	0xD7B8, { 0xE7, 0x90, 0x89 },
	0xD7B9, { 0xE7, 0x91, 0xA0 },
	0xD7BA, { 0xE7, 0x95, 0x99 },
	0xD7BB, { 0xE7, 0x98, 0xA4 },
	0xD7BC, { 0xE7, 0xA1, 0xAB },
	0xD7BD, { 0xE8, 0xAC, 0xAC },
	0xD7BE, { 0xE9, 0xA1, 0x9E },
	0xD7BF, { 0xE5, 0x85, 0xAD },
	0xD7C0, { 0xE6, 0x88, 0xAE },
	0xD7C1, { 0xE9, 0x99, 0xB8 },
	0xD7C2, { 0xE4, 0xBE, 0x96 },
	0xD7C3, { 0xE5, 0x80, 0xAB },
	0xD7C4, { 0xE5, 0xB4, 0x99 },
	0xD7C5, { 0xE6, 0xB7, 0xAA },
	0xD7C6, { 0xE7, 0xB6, 0xB8 },
	0xD7C7, { 0xE8, 0xBC, 0xAA },
	0xD7C8, { 0xE5, 0xBE, 0x8B },
	0xD7C9, { 0xE6, 0x85, 0x84 },
	0xD7CA, { 0xE6, 0xA0, 0x97 },
	0xD7CB, { 0xEF, 0xA5, 0xA1 },
	0xD7CC, { 0xE9, 0x9A, 0x86 },
	0xD7CD, { 0xE5, 0x8B, 0x92 },
	0xD7CE, { 0xE8, 0x82, 0x8B },
	0xD7CF, { 0xE5, 0x87, 0x9C },
	0xD7D0, { 0xE5, 0x87, 0x8C },
	0xD7D1, { 0xE6, 0xA5, 0x9E },
	0xD7D2, { 0xE7, 0xA8, 0x9C },
	0xD7D3, { 0xE7, 0xB6, 0xBE },
	0xD7D4, { 0xE8, 0x8F, 0xB1 },
	0xD7D5, { 0xE9, 0x99, 0xB5 },
	0xD7D6, { 0xE4, 0xBF, 0x9A },
	0xD7D7, { 0xE5, 0x88, 0xA9 },
	0xD7D8, { 0xE5, 0x8E, 0x98 },
	0xD7D9, { 0xE5, 0x90, 0x8F },
	0xD7DA, { 0xE5, 0x94, 0x8E },
	0xD7DB, { 0xE5, 0xB1, 0xA5 },
	0xD7DC, { 0xE6, 0x82, 0xA7 },
	0xD7DD, { 0xE6, 0x9D, 0x8E },
	0xD7DE, { 0xE6, 0xA2, 0xA8 },
	0xD7DF, { 0xE6, 0xB5, 0xAC },
	0xD7E0, { 0xE7, 0x8A, 0x81 },
	0xD7E1, { 0xE7, 0x8B, 0xB8 },
	0xD7E2, { 0xE7, 0x90, 0x86 },
	0xD7E3, { 0xE7, 0x92, 0x83 },
	0xD7E4, { 0xEF, 0xA5, 0xA2 },
	0xD7E5, { 0xE7, 0x97, 0xA2 },
	0xD7E6, { 0xE7, 0xB1, 0xAC },
	0xD7E7, { 0xE7, 0xBD, 0xB9 },
	0xD7E8, { 0xE7, 0xBE, 0xB8 },
	0xD7E9, { 0xE8, 0x8E, 0x89 },
	0xD7EA, { 0xE8, 0xA3, 0x8F },
	0xD7EB, { 0xE8, 0xA3, 0xA1 },
	0xD7EC, { 0xE9, 0x87, 0x8C },
	0xD7ED, { 0xE9, 0x87, 0x90 },
	0xD7EE, { 0xE9, 0x9B, 0xA2 },
	0xD7EF, { 0xE9, 0xAF, 0x89 },
	0xD7F0, { 0xE5, 0x90, 0x9D },
	0xD7F1, { 0xE6, 0xBD, 0xBE },
	0xD7F2, { 0xE7, 0x87, 0x90 },
	0xD7F3, { 0xE7, 0x92, 0x98 },
	0xD7F4, { 0xE8, 0x97, 0xBA },
	0xD7F5, { 0xE8, 0xBA, 0xAA },
	0xD7F6, { 0xE9, 0x9A, 0xA3 },
	0xD7F7, { 0xE9, 0xB1, 0x97 },
	0xD7F8, { 0xE9, 0xBA, 0x9F },
	0xD7F9, { 0xE6, 0x9E, 0x97 },
	0xD7FA, { 0xE6, 0xB7, 0x8B },
	0xD7FB, { 0xE7, 0x90, 0xB3 },
	0xD7FC, { 0xE8, 0x87, 0xA8 },
	0xD7FD, { 0xE9, 0x9C, 0x96 },
	0xD7FE, { 0xE7, 0xA0, 0xAC },
	0xD8A1, { 0xE7, 0xAB, 0x8B },
	0xD8A2, { 0xE7, 0xAC, 0xA0 },
	0xD8A3, { 0xE7, 0xB2, 0x92 },
	0xD8A4, { 0xE6, 0x91, 0xA9 },
	0xD8A5, { 0xE7, 0x91, 0xAA },
	0xD8A6, { 0xE7, 0x97, 0xB2 },
	0xD8A7, { 0xE7, 0xA2, 0xBC },
	0xD8A8, { 0xE7, 0xA3, 0xA8 },
	0xD8A9, { 0xE9, 0xA6, 0xAC },
	0xD8AA, { 0xE9, 0xAD, 0x94 },
	0xD8AB, { 0xE9, 0xBA, 0xBB },
	0xD8AC, { 0xE5, 0xAF, 0x9E },
	0xD8AD, { 0xE5, 0xB9, 0x95 },
	0xD8AE, { 0xE6, 0xBC, 0xA0 },
	0xD8AF, { 0xE8, 0x86, 0x9C },
	0xD8B0, { 0xE8, 0x8E, 0xAB },
	0xD8B1, { 0xE9, 0x82, 0x88 },
	0xD8B2, { 0xE4, 0xB8, 0x87 },
	0xD8B3, { 0xE5, 0x8D, 0x8D },
	0xD8B4, { 0xE5, 0xA8, 0xA9 },
	0xD8B5, { 0xE5, 0xB7, 0x92 },
	0xD8B6, { 0xE5, 0xBD, 0x8E },
	0xD8B7, { 0xE6, 0x85, 0xA2 },
	0xD8B8, { 0xE6, 0x8C, 0xBD },
	0xD8B9, { 0xE6, 0x99, 0xA9 },
	0xD8BA, { 0xE6, 0x9B, 0xBC },
	0xD8BB, { 0xE6, 0xBB, 0xBF },
	0xD8BC, { 0xE6, 0xBC, 0xAB },
	0xD8BD, { 0xE7, 0x81, 0xA3 },
	0xD8BE, { 0xE7, 0x9E, 0x9E },
	0xD8BF, { 0xE8, 0x90, 0xAC },
	0xD8C0, { 0xE8, 0x94, 0x93 },
	0xD8C1, { 0xE8, 0xA0, 0xBB },
	0xD8C2, { 0xE8, 0xBC, 0x93 },
	0xD8C3, { 0xE9, 0xA5, 0x85 },
	0xD8C4, { 0xE9, 0xB0, 0xBB },
	0xD8C5, { 0xE5, 0x94, 0x9C },
	0xD8C6, { 0xE6, 0x8A, 0xB9 },
	0xD8C7, { 0xE6, 0x9C, 0xAB },
	0xD8C8, { 0xE6, 0xB2, 0xAB },
	0xD8C9, { 0xE8, 0x8C, 0x89 },
	0xD8CA, { 0xE8, 0xA5, 0xAA },
	0xD8CB, { 0xE9, 0x9D, 0xBA },
	0xD8CC, { 0xE4, 0xBA, 0xA1 },
	0xD8CD, { 0xE5, 0xA6, 0x84 },
	0xD8CE, { 0xE5, 0xBF, 0x98 },
	0xD8CF, { 0xE5, 0xBF, 0x99 },
	0xD8D0, { 0xE6, 0x9C, 0x9B },
	0xD8D1, { 0xE7, 0xB6, 0xB2 },
	0xD8D2, { 0xE7, 0xBD, 0x94 },
	0xD8D3, { 0xE8, 0x8A, 0x92 },
	0xD8D4, { 0xE8, 0x8C, 0xAB },
	0xD8D5, { 0xE8, 0x8E, 0xBD },
	0xD8D6, { 0xE8, 0xBC, 0x9E },
	0xD8D7, { 0xE9, 0x82, 0x99 },
	0xD8D8, { 0xE5, 0x9F, 0x8B },
	0xD8D9, { 0xE5, 0xA6, 0xB9 },
	0xD8DA, { 0xE5, 0xAA, 0x92 },
	0xD8DB, { 0xE5, 0xAF, 0x90 },
	0xD8DC, { 0xE6, 0x98, 0xA7 },
	0xD8DD, { 0xE6, 0x9E, 0x9A },
	0xD8DE, { 0xE6, 0xA2, 0x85 },
	0xD8DF, { 0xE6, 0xAF, 0x8F },
	0xD8E0, { 0xE7, 0x85, 0xA4 },
	0xD8E1, { 0xE7, 0xBD, 0xB5 },
	0xD8E2, { 0xE8, 0xB2, 0xB7 },
	0xD8E3, { 0xE8, 0xB3, 0xA3 },
	0xD8E4, { 0xE9, 0x82, 0x81 },
	0xD8E5, { 0xE9, 0xAD, 0x85 },
	0xD8E6, { 0xE8, 0x84, 0x88 },
	0xD8E7, { 0xE8, 0xB2, 0x8A },
	0xD8E8, { 0xE9, 0x99, 0x8C },
	0xD8E9, { 0xE9, 0xA9, 0x80 },
	0xD8EA, { 0xE9, 0xBA, 0xA5 },
	0xD8EB, { 0xE5, 0xAD, 0x9F },
	0xD8EC, { 0xE6, 0xB0, 0x93 },
	0xD8ED, { 0xE7, 0x8C, 0x9B },
	0xD8EE, { 0xE7, 0x9B, 0xB2 },
	0xD8EF, { 0xE7, 0x9B, 0x9F },
	0xD8F0, { 0xE8, 0x90, 0x8C },
	0xD8F1, { 0xE5, 0x86, 0xAA },
	0xD8F2, { 0xE8, 0xA6, 0x93 },
	0xD8F3, { 0xE5, 0x85, 0x8D },
	0xD8F4, { 0xE5, 0x86, 0x95 },
	0xD8F5, { 0xE5, 0x8B, 0x89 },
	0xD8F6, { 0xE6, 0xA3, 0x89 },
	0xD8F7, { 0xE6, 0xB2, 0x94 },
	0xD8F8, { 0xE7, 0x9C, 0x84 },
	0xD8F9, { 0xE7, 0x9C, 0xA0 },
	0xD8FA, { 0xE7, 0xB6, 0xBF },
	0xD8FB, { 0xE7, 0xB7, 0xAC },
	0xD8FC, { 0xE9, 0x9D, 0xA2 },
	0xD8FD, { 0xE9, 0xBA, 0xB5 },
	0xD8FE, { 0xE6, 0xBB, 0x85 },
	0xD9A1, { 0xE8, 0x94, 0x91 },
	0xD9A2, { 0xE5, 0x86, 0xA5 },
	0xD9A3, { 0xE5, 0x90, 0x8D },
	0xD9A4, { 0xE5, 0x91, 0xBD },
	0xD9A5, { 0xE6, 0x98, 0x8E },
	0xD9A6, { 0xE6, 0x9A, 0x9D },
	0xD9A7, { 0xE6, 0xA4, 0xA7 },
	0xD9A8, { 0xE6, 0xBA, 0x9F },
	0xD9A9, { 0xE7, 0x9A, 0xBF },
	0xD9AA, { 0xE7, 0x9E, 0x91 },
	0xD9AB, { 0xE8, 0x8C, 0x97 },
	0xD9AC, { 0xE8, 0x93, 0x82 },
	0xD9AD, { 0xE8, 0x9E, 0x9F },
	0xD9AE, { 0xE9, 0x85, 0xA9 },
	0xD9AF, { 0xE9, 0x8A, 0x98 },
	0xD9B0, { 0xE9, 0xB3, 0xB4 },
	0xD9B1, { 0xE8, 0xA2, 0x82 },
	0xD9B2, { 0xE4, 0xBE, 0xAE },
	0xD9B3, { 0xE5, 0x86, 0x92 },
	0xD9B4, { 0xE5, 0x8B, 0x9F },
	0xD9B5, { 0xE5, 0xA7, 0x86 },
	0xD9B6, { 0xE5, 0xB8, 0xBD },
	0xD9B7, { 0xE6, 0x85, 0x95 },
	0xD9B8, { 0xE6, 0x91, 0xB8 },
	0xD9B9, { 0xE6, 0x91, 0xB9 },
	0xD9BA, { 0xE6, 0x9A, 0xAE },
	0xD9BB, { 0xE6, 0x9F, 0x90 },
	0xD9BC, { 0xE6, 0xA8, 0xA1 },
	0xD9BD, { 0xE6, 0xAF, 0x8D },
	0xD9BE, { 0xE6, 0xAF, 0x9B },
	0xD9BF, { 0xE7, 0x89, 0x9F },
	0xD9C0, { 0xE7, 0x89, 0xA1 },
	0xD9C1, { 0xE7, 0x91, 0x81 },
	0xD9C2, { 0xE7, 0x9C, 0xB8 },
	0xD9C3, { 0xE7, 0x9F, 0x9B },
	0xD9C4, { 0xE8, 0x80, 0x97 },
	0xD9C5, { 0xE8, 0x8A, 0xBC },
	0xD9C6, { 0xE8, 0x8C, 0x85 },
	0xD9C7, { 0xE8, 0xAC, 0x80 },
	0xD9C8, { 0xE8, 0xAC, 0xA8 },
	0xD9C9, { 0xE8, 0xB2, 0x8C },
	0xD9CA, { 0xE6, 0x9C, 0xA8 },
	0xD9CB, { 0xE6, 0xB2, 0x90 },
	0xD9CC, { 0xE7, 0x89, 0xA7 },
	0xD9CD, { 0xE7, 0x9B, 0xAE },
	0xD9CE, { 0xE7, 0x9D, 0xA6 },
	0xD9CF, { 0xE7, 0xA9, 0x86 },
	0xD9D0, { 0xE9, 0xB6, 0xA9 },
	0xD9D1, { 0xE6, 0xAD, 0xBF },
	0xD9D2, { 0xE6, 0xB2, 0x92 },
	0xD9D3, { 0xE5, 0xA4, 0xA2 },
	0xD9D4, { 0xE6, 0x9C, 0xA6 },
	0xD9D5, { 0xE8, 0x92, 0x99 },
	0xD9D6, { 0xE5, 0x8D, 0xAF },
	0xD9D7, { 0xE5, 0xA2, 0x93 },
	0xD9D8, { 0xE5, 0xA6, 0x99 },
	0xD9D9, { 0xE5, 0xBB, 0x9F },
	0xD9DA, { 0xE6, 0x8F, 0x8F },
	0xD9DB, { 0xE6, 0x98, 0xB4 },
	0xD9DC, { 0xE6, 0x9D, 0xB3 },
	0xD9DD, { 0xE6, 0xB8, 0xBA },
	0xD9DE, { 0xE7, 0x8C, 0xAB },
	0xD9DF, { 0xE7, 0xAB, 0x97 },
	0xD9E0, { 0xE8, 0x8B, 0x97 },
	0xD9E1, { 0xE9, 0x8C, 0xA8 },
	0xD9E2, { 0xE5, 0x8B, 0x99 },
	0xD9E3, { 0xE5, 0xB7, 0xAB },
	0xD9E4, { 0xE6, 0x86, 0xAE },
	0xD9E5, { 0xE6, 0x87, 0x8B },
	0xD9E6, { 0xE6, 0x88, 0x8A },
	0xD9E7, { 0xE6, 0x8B, 0x87 },
	0xD9E8, { 0xE6, 0x92, 0xAB },
	0xD9E9, { 0xE6, 0x97, 0xA0 },
	0xD9EA, { 0xE6, 0xA5, 0x99 },
	0xD9EB, { 0xE6, 0xAD, 0xA6 },
	0xD9EC, { 0xE6, 0xAF, 0x8B },
	0xD9ED, { 0xE7, 0x84, 0xA1 },
	0xD9EE, { 0xE7, 0x8F, 0xB7 },
	0xD9EF, { 0xE7, 0x95, 0x9D },
	0xD9F0, { 0xE7, 0xB9, 0x86 },
	0xD9F1, { 0xE8, 0x88, 0x9E },
	0xD9F2, { 0xE8, 0x8C, 0x82 },
	0xD9F3, { 0xE8, 0x95, 0xAA },
	0xD9F4, { 0xE8, 0xAA, 0xA3 },
	0xD9F5, { 0xE8, 0xB2, 0xBF },
	0xD9F6, { 0xE9, 0x9C, 0xA7 },
	0xD9F7, { 0xE9, 0xB5, 0xA1 },
	0xD9F8, { 0xE5, 0xA2, 0xA8 },
	0xD9F9, { 0xE9, 0xBB, 0x98 },
	0xD9FA, { 0xE5, 0x80, 0x91 },
	0xD9FB, { 0xE5, 0x88, 0x8E },
	0xD9FC, { 0xE5, 0x90, 0xBB },
	0xD9FD, { 0xE5, 0x95, 0x8F },
	0xD9FE, { 0xE6, 0x96, 0x87 },
	0xDAA1, { 0xE6, 0xB1, 0xB6 },
	0xDAA2, { 0xE7, 0xB4, 0x8A },
	0xDAA3, { 0xE7, 0xB4, 0x8B },
	0xDAA4, { 0xE8, 0x81, 0x9E },
	0xDAA5, { 0xE8, 0x9A, 0x8A },
	0xDAA6, { 0xE9, 0x96, 0x80 },
	0xDAA7, { 0xE9, 0x9B, 0xAF },
	0xDAA8, { 0xE5, 0x8B, 0xBF },
	0xDAA9, { 0xE6, 0xB2, 0x95 },
	0xDAAA, { 0xE7, 0x89, 0xA9 },
	0xDAAB, { 0xE5, 0x91, 0xB3 },
	0xDAAC, { 0xE5, 0xAA, 0x9A },
	0xDAAD, { 0xE5, 0xB0, 0xBE },
	0xDAAE, { 0xE5, 0xB5, 0x8B },
	0xDAAF, { 0xE5, 0xBD, 0x8C },
	0xDAB0, { 0xE5, 0xBE, 0xAE },
	0xDAB1, { 0xE6, 0x9C, 0xAA },
	0xDAB2, { 0xE6, 0xA2, 0xB6 },
	0xDAB3, { 0xE6, 0xA5, 0xA3 },
	0xDAB4, { 0xE6, 0xB8, 0xBC },
	0xDAB5, { 0xE6, 0xB9, 0x84 },
	0xDAB6, { 0xE7, 0x9C, 0x89 },
	0xDAB7, { 0xE7, 0xB1, 0xB3 },
	0xDAB8, { 0xE7, 0xBE, 0x8E },
	0xDAB9, { 0xE8, 0x96, 0x87 },
	0xDABA, { 0xE8, 0xAC, 0x8E },
	0xDABB, { 0xE8, 0xBF, 0xB7 },
	0xDABC, { 0xE9, 0x9D, 0xA1 },
	0xDABD, { 0xE9, 0xBB, 0xB4 },
	0xDABE, { 0xE5, 0xB2, 0xB7 },
	0xDABF, { 0xE6, 0x82, 0xB6 },
	0xDAC0, { 0xE6, 0x84, 0x8D },
	0xDAC1, { 0xE6, 0x86, 0xAB },
	0xDAC2, { 0xE6, 0x95, 0x8F },
	0xDAC3, { 0xE6, 0x97, 0xBB },
	0xDAC4, { 0xE6, 0x97, 0xBC },
	0xDAC5, { 0xE6, 0xB0, 0x91 },
	0xDAC6, { 0xE6, 0xB3, 0xAF },
	0xDAC7, { 0xE7, 0x8E, 0x9F },
	0xDAC8, { 0xE7, 0x8F, 0x89 },
	0xDAC9, { 0xE7, 0xB7, 0xA1 },
	0xDACA, { 0xE9, 0x96, 0x94 },
	0xDACB, { 0xE5, 0xAF, 0x86 },
	0xDACC, { 0xE8, 0x9C, 0x9C },
	0xDACD, { 0xE8, 0xAC, 0x90 },
	0xDACE, { 0xE5, 0x89, 0x9D },
	0xDACF, { 0xE5, 0x8D, 0x9A },
	0xDAD0, { 0xE6, 0x8B, 0x8D },
	0xDAD1, { 0xE6, 0x90, 0x8F },
	0xDAD2, { 0xE6, 0x92, 0xB2 },
	0xDAD3, { 0xE6, 0x9C, 0xB4 },
	0xDAD4, { 0xE6, 0xA8, 0xB8 },
	0xDAD5, { 0xE6, 0xB3, 0x8A },
	0xDAD6, { 0xE7, 0x8F, 0x80 },
	0xDAD7, { 0xE7, 0x92, 0x9E },
	0xDAD8, { 0xE7, 0xAE, 0x94 },
	0xDAD9, { 0xE7, 0xB2, 0x95 },
	0xDADA, { 0xE7, 0xB8, 0x9B },
	0xDADB, { 0xE8, 0x86, 0x8A },
	0xDADC, { 0xE8, 0x88, 0xB6 },
	0xDADD, { 0xE8, 0x96, 0x84 },
	0xDADE, { 0xE8, 0xBF, 0xAB },
	0xDADF, { 0xE9, 0x9B, 0xB9 },
	0xDAE0, { 0xE9, 0xA7, 0x81 },
	0xDAE1, { 0xE4, 0xBC, 0xB4 },
	0xDAE2, { 0xE5, 0x8D, 0x8A },
	0xDAE3, { 0xE5, 0x8F, 0x8D },
	0xDAE4, { 0xE5, 0x8F, 0x9B },
	0xDAE5, { 0xE6, 0x8B, 0x8C },
	0xDAE6, { 0xE6, 0x90, 0xAC },
	0xDAE7, { 0xE6, 0x94, 0x80 },
	0xDAE8, { 0xE6, 0x96, 0x91 },
	0xDAE9, { 0xE6, 0xA7, 0x83 },
	0xDAEA, { 0xE6, 0xB3, 0xAE },
	0xDAEB, { 0xE6, 0xBD, 0x98 },
	0xDAEC, { 0xE7, 0x8F, 0xAD },
	0xDAED, { 0xE7, 0x95, 0x94 },
	0xDAEE, { 0xE7, 0x98, 0xA2 },
	0xDAEF, { 0xE7, 0x9B, 0xA4 },
	0xDAF0, { 0xE7, 0x9B, 0xBC },
	0xDAF1, { 0xE7, 0xA3, 0x90 },
	0xDAF2, { 0xE7, 0xA3, 0xBB },
	0xDAF3, { 0xE7, 0xA4, 0xAC },
	0xDAF4, { 0xE7, 0xB5, 0x86 },
	0xDAF5, { 0xE8, 0x88, 0xAC },
	0xDAF6, { 0xE8, 0x9F, 0xA0 },
	0xDAF7, { 0xE8, 0xBF, 0x94 },
	0xDAF8, { 0xE9, 0xA0, 0x92 },
	0xDAF9, { 0xE9, 0xA3, 0xAF },
	0xDAFA, { 0xE5, 0x8B, 0x83 },
	0xDAFB, { 0xE6, 0x8B, 0x94 },
	0xDAFC, { 0xE6, 0x92, 0xA5 },
	0xDAFD, { 0xE6, 0xB8, 0xA4 },
	0xDAFE, { 0xE6, 0xBD, 0x91 },
	0xDBA1, { 0xE7, 0x99, 0xBC },
	0xDBA2, { 0xE8, 0xB7, 0x8B },
	0xDBA3, { 0xE9, 0x86, 0xB1 },
	0xDBA4, { 0xE9, 0x89, 0xA2 },
	0xDBA5, { 0xE9, 0xAB, 0xAE },
	0xDBA6, { 0xE9, 0xAD, 0x83 },
	0xDBA7, { 0xE5, 0x80, 0xA3 },
	0xDBA8, { 0xE5, 0x82, 0x8D },
	0xDBA9, { 0xE5, 0x9D, 0x8A },
	0xDBAA, { 0xE5, 0xA6, 0xA8 },
	0xDBAB, { 0xE5, 0xB0, 0xA8 },
	0xDBAC, { 0xE5, 0xB9, 0x87 },
	0xDBAD, { 0xE5, 0xBD, 0xB7 },
	0xDBAE, { 0xE6, 0x88, 0xBF },
	0xDBAF, { 0xE6, 0x94, 0xBE },
	0xDBB0, { 0xE6, 0x96, 0xB9 },
	0xDBB1, { 0xE6, 0x97, 0x81 },
	0xDBB2, { 0xE6, 0x98, 0x89 },
	0xDBB3, { 0xE6, 0x9E, 0x8B },
	0xDBB4, { 0xE6, 0xA6, 0x9C },
	0xDBB5, { 0xE6, 0xBB, 0x82 },
	0xDBB6, { 0xE7, 0xA3, 0x85 },
	0xDBB7, { 0xE7, 0xB4, 0xA1 },
	0xDBB8, { 0xE8, 0x82, 0xAA },
	0xDBB9, { 0xE8, 0x86, 0x80 },
	0xDBBA, { 0xE8, 0x88, 0xAB },
	0xDBBB, { 0xE8, 0x8A, 0xB3 },
	0xDBBC, { 0xE8, 0x92, 0xA1 },
	0xDBBD, { 0xE8, 0x9A, 0x8C },
	0xDBBE, { 0xE8, 0xA8, 0xAA },
	0xDBBF, { 0xE8, 0xAC, 0x97 },
	0xDBC0, { 0xE9, 0x82, 0xA6 },
	0xDBC1, { 0xE9, 0x98, 0xB2 },
	0xDBC2, { 0xE9, 0xBE, 0x90 },
	0xDBC3, { 0xE5, 0x80, 0x8D },
	0xDBC4, { 0xE4, 0xBF, 0xB3 },
	0xDBC5, { 0xEF, 0xA5, 0xA3 },
	0xDBC6, { 0xE5, 0x9F, 0xB9 },
	0xDBC7, { 0xE5, 0xBE, 0x98 },
	0xDBC8, { 0xE6, 0x8B, 0x9C },
	0xDBC9, { 0xE6, 0x8E, 0x92 },
	0xDBCA, { 0xE6, 0x9D, 0xAF },
	0xDBCB, { 0xE6, 0xB9, 0x83 },
	0xDBCC, { 0xE7, 0x84, 0x99 },
	0xDBCD, { 0xE7, 0x9B, 0x83 },
	0xDBCE, { 0xE8, 0x83, 0x8C },
	0xDBCF, { 0xE8, 0x83, 0x9A },
	0xDBD0, { 0xE8, 0xA3, 0xB4 },
	0xDBD1, { 0xE8, 0xA3, 0xB5 },
	0xDBD2, { 0xE8, 0xA4, 0x99 },
	0xDBD3, { 0xE8, 0xB3, 0xA0 },
	0xDBD4, { 0xE8, 0xBC, 0xA9 },
	0xDBD5, { 0xE9, 0x85, 0x8D },
	0xDBD6, { 0xE9, 0x99, 0xAA },
	0xDBD7, { 0xE4, 0xBC, 0xAF },
	0xDBD8, { 0xE4, 0xBD, 0xB0 },
	0xDBD9, { 0xE5, 0xB8, 0x9B },
	0xDBDA, { 0xE6, 0x9F, 0x8F },
	0xDBDB, { 0xE6, 0xA0, 0xA2 },
	0xDBDC, { 0xE7, 0x99, 0xBD },
	0xDBDD, { 0xE7, 0x99, 0xBE },
	0xDBDE, { 0xE9, 0xAD, 0x84 },
	0xDBDF, { 0xE5, 0xB9, 0xA1 },
	0xDBE0, { 0xE6, 0xA8, 0x8A },
	0xDBE1, { 0xE7, 0x85, 0xA9 },
	0xDBE2, { 0xE7, 0x87, 0x94 },
	0xDBE3, { 0xE7, 0x95, 0xAA },
	0xDBE4, { 0xEF, 0xA5, 0xA4 },
	0xDBE5, { 0xE7, 0xB9, 0x81 },
	0xDBE6, { 0xE8, 0x95, 0x83 },
	0xDBE7, { 0xE8, 0x97, 0xA9 },
	0xDBE8, { 0xE9, 0xA3, 0x9C },
	0xDBE9, { 0xE4, 0xBC, 0x90 },
	0xDBEA, { 0xE7, 0xAD, 0x8F },
	0xDBEB, { 0xE7, 0xBD, 0xB0 },
	0xDBEC, { 0xE9, 0x96, 0xA5 },
	0xDBED, { 0xE5, 0x87, 0xA1 },
	0xDBEE, { 0xE5, 0xB8, 0x86 },
	0xDBEF, { 0xE6, 0xA2, 0xB5 },
	0xDBF0, { 0xE6, 0xB0, 0xBE },
	0xDBF1, { 0xE6, 0xB1, 0x8E },
	0xDBF2, { 0xE6, 0xB3, 0x9B },
	0xDBF3, { 0xE7, 0x8A, 0xAF },
	0xDBF4, { 0xE7, 0xAF, 0x84 },
	0xDBF5, { 0xE8, 0x8C, 0x83 },
	0xDBF6, { 0xE6, 0xB3, 0x95 },
	0xDBF7, { 0xE7, 0x90, 0xBA },
	0xDBF8, { 0xE5, 0x83, 0xBB },
	0xDBF9, { 0xE5, 0x8A, 0x88 },
	0xDBFA, { 0xE5, 0xA3, 0x81 },
	0xDBFB, { 0xE6, 0x93, 0x98 },
	0xDBFC, { 0xE6, 0xAA, 0x97 },
	0xDBFD, { 0xE7, 0x92, 0xA7 },
	0xDBFE, { 0xE7, 0x99, 0x96 },
	0xDCA1, { 0xE7, 0xA2, 0xA7 },
	0xDCA2, { 0xE8, 0x98, 0x97 },
	0xDCA3, { 0xE9, 0x97, 0xA2 },
	0xDCA4, { 0xE9, 0x9C, 0xB9 },
	0xDCA5, { 0xEF, 0xA5, 0xA5 },
	0xDCA6, { 0xE5, 0x8D, 0x9E },
	0xDCA7, { 0xE5, 0xBC, 0x81 },
	0xDCA8, { 0xE8, 0xAE, 0x8A },
	0xDCA9, { 0xE8, 0xBE, 0xA8 },
	0xDCAA, { 0xE8, 0xBE, 0xAF },
	0xDCAB, { 0xE9, 0x82, 0x8A },
	0xDCAC, { 0xE5, 0x88, 0xA5 },
	0xDCAD, { 0xE7, 0x9E, 0xA5 },
	0xDCAE, { 0xE9, 0xB1, 0x89 },
	0xDCAF, { 0xE9, 0xBC, 0x88 },
	0xDCB0, { 0xE4, 0xB8, 0x99 },
	0xDCB1, { 0xE5, 0x80, 0x82 },
	0xDCB2, { 0xE5, 0x85, 0xB5 },
	0xDCB3, { 0xE5, 0xB1, 0x9B },
	0xDCB4, { 0xE5, 0xB9, 0xB7 },
	0xDCB5, { 0xE6, 0x98, 0x9E },
	0xDCB6, { 0xE6, 0x98, 0xBA },
	0xDCB7, { 0xE6, 0x9F, 0x84 },
	0xDCB8, { 0xE6, 0xA3, 0x85 },
	0xDCB9, { 0xE7, 0x82, 0xB3 },
	0xDCBA, { 0xE7, 0x94, 0x81 },
	0xDCBB, { 0xE7, 0x97, 0x85 },
	0xDCBC, { 0xE7, 0xA7, 0x89 },
	0xDCBD, { 0xE7, 0xAB, 0x9D },
	0xDCBE, { 0xE8, 0xBC, 0xA7 },
	0xDCBF, { 0xE9, 0xA4, 0xA0 },
	0xDCC0, { 0xE9, 0xA8, 0x88 },
	0xDCC1, { 0xE4, 0xBF, 0x9D },
	0xDCC2, { 0xE5, 0xA0, 0xA1 },
	0xDCC3, { 0xE5, 0xA0, 0xB1 },
	0xDCC4, { 0xE5, 0xAF, 0xB6 },
	0xDCC5, { 0xE6, 0x99, 0xAE },
	0xDCC6, { 0xE6, 0xAD, 0xA5 },
	0xDCC7, { 0xE6, 0xB4, 0x91 },
	0xDCC8, { 0xE6, 0xB9, 0xBA },
	0xDCC9, { 0xE6, 0xBD, 0xBD },
	0xDCCA, { 0xE7, 0x8F, 0xA4 },
	0xDCCB, { 0xE7, 0x94, 0xAB },
	0xDCCC, { 0xE8, 0x8F, 0xA9 },
	0xDCCD, { 0xE8, 0xA3, 0x9C },
	0xDCCE, { 0xE8, 0xA4, 0x93 },
	0xDCCF, { 0xE8, 0xAD, 0x9C },
	0xDCD0, { 0xE8, 0xBC, 0x94 },
	0xDCD1, { 0xE4, 0xBC, 0x8F },
	0xDCD2, { 0xE5, 0x83, 0x95 },
	0xDCD3, { 0xE5, 0x8C, 0x90 },
	0xDCD4, { 0xE5, 0x8D, 0x9C },
	0xDCD5, { 0xE5, 0xAE, 0x93 },
	0xDCD6, { 0xE5, 0xBE, 0xA9 },
	0xDCD7, { 0xE6, 0x9C, 0x8D },
	0xDCD8, { 0xE7, 0xA6, 0x8F },
	0xDCD9, { 0xE8, 0x85, 0xB9 },
	0xDCDA, { 0xE8, 0x8C, 0xAF },
	0xDCDB, { 0xE8, 0x94, 0x94 },
	0xDCDC, { 0xE8, 0xA4, 0x87 },
	0xDCDD, { 0xE8, 0xA6, 0x86 },
	0xDCDE, { 0xE8, 0xBC, 0xB9 },
	0xDCDF, { 0xE8, 0xBC, 0xBB },
	0xDCE0, { 0xE9, 0xA6, 0xA5 },
	0xDCE1, { 0xE9, 0xB0, 0x92 },
	0xDCE2, { 0xE6, 0x9C, 0xAC },
	0xDCE3, { 0xE4, 0xB9, 0xB6 },
	0xDCE4, { 0xE4, 0xBF, 0xB8 },
	0xDCE5, { 0xE5, 0xA5, 0x89 },
	0xDCE6, { 0xE5, 0xB0, 0x81 },
	0xDCE7, { 0xE5, 0xB3, 0xAF },
	0xDCE8, { 0xE5, 0xB3, 0xB0 },
	0xDCE9, { 0xE6, 0x8D, 0xA7 },
	0xDCEA, { 0xE6, 0xA3, 0x92 },
	0xDCEB, { 0xE7, 0x83, 0xBD },
	0xDCEC, { 0xE7, 0x86, 0xA2 },
	0xDCED, { 0xE7, 0x90, 0xAB },
	0xDCEE, { 0xE7, 0xB8, 0xAB },
	0xDCEF, { 0xE8, 0x93, 0xAC },
	0xDCF0, { 0xE8, 0x9C, 0x82 },
	0xDCF1, { 0xE9, 0x80, 0xA2 },
	0xDCF2, { 0xE9, 0x8B, 0x92 },
	0xDCF3, { 0xE9, 0xB3, 0xB3 },
	0xDCF4, { 0xE4, 0xB8, 0x8D },
	0xDCF5, { 0xE4, 0xBB, 0x98 },
	0xDCF6, { 0xE4, 0xBF, 0xAF },
	0xDCF7, { 0xE5, 0x82, 0x85 },
	0xDCF8, { 0xE5, 0x89, 0x96 },
	0xDCF9, { 0xE5, 0x89, 0xAF },
	0xDCFA, { 0xE5, 0x90, 0xA6 },
	0xDCFB, { 0xE5, 0x92, 0x90 },
	0xDCFC, { 0xE5, 0x9F, 0xA0 },
	0xDCFD, { 0xE5, 0xA4, 0xAB },
	0xDCFE, { 0xE5, 0xA9, 0xA6 },
	0xDDA1, { 0xE5, 0xAD, 0x9A },
	0xDDA2, { 0xE5, 0xAD, 0xB5 },
	0xDDA3, { 0xE5, 0xAF, 0x8C },
	0xDDA4, { 0xE5, 0xBA, 0x9C },
	0xDDA5, { 0xEF, 0xA5, 0xA6 },
	0xDDA6, { 0xE6, 0x89, 0xB6 },
	0xDDA7, { 0xE6, 0x95, 0xB7 },
	0xDDA8, { 0xE6, 0x96, 0xA7 },
	0xDDA9, { 0xE6, 0xB5, 0xAE },
	0xDDAA, { 0xE6, 0xBA, 0xA5 },
	0xDDAB, { 0xE7, 0x88, 0xB6 },
	0xDDAC, { 0xE7, 0xAC, 0xA6 },
	0xDDAD, { 0xE7, 0xB0, 0xBF },
	0xDDAE, { 0xE7, 0xBC, 0xB6 },
	0xDDAF, { 0xE8, 0x85, 0x90 },
	0xDDB0, { 0xE8, 0x85, 0x91 },
	0xDDB1, { 0xE8, 0x86, 0x9A },
	0xDDB2, { 0xE8, 0x89, 0x80 },
	0xDDB3, { 0xE8, 0x8A, 0x99 },
	0xDDB4, { 0xE8, 0x8E, 0xA9 },
	0xDDB5, { 0xE8, 0xA8, 0x83 },
	0xDDB6, { 0xE8, 0xB2, 0xA0 },
	0xDDB7, { 0xE8, 0xB3, 0xA6 },
	0xDDB8, { 0xE8, 0xB3, 0xBB },
	0xDDB9, { 0xE8, 0xB5, 0xB4 },
	0xDDBA, { 0xE8, 0xB6, 0xBA },
	0xDDBB, { 0xE9, 0x83, 0xA8 },
	0xDDBC, { 0xE9, 0x87, 0x9C },
	0xDDBD, { 0xE9, 0x98, 0x9C },
	0xDDBE, { 0xE9, 0x99, 0x84 },
	0xDDBF, { 0xE9, 0xA7, 0x99 },
	0xDDC0, { 0xE9, 0xB3, 0xA7 },
	0xDDC1, { 0xE5, 0x8C, 0x97 },
	0xDDC2, { 0xE5, 0x88, 0x86 },
	0xDDC3, { 0xE5, 0x90, 0xA9 },
	0xDDC4, { 0xE5, 0x99, 0xB4 },
	0xDDC5, { 0xE5, 0xA2, 0xB3 },
	0xDDC6, { 0xE5, 0xA5, 0x94 },
	0xDDC7, { 0xE5, 0xA5, 0xAE },
	0xDDC8, { 0xE5, 0xBF, 0xBF },
	0xDDC9, { 0xE6, 0x86, 0xA4 },
	0xDDCA, { 0xE6, 0x89, 0xAE },
	0xDDCB, { 0xE6, 0x98, 0x90 },
	0xDDCC, { 0xE6, 0xB1, 0xBE },
	0xDDCD, { 0xE7, 0x84, 0x9A },
	0xDDCE, { 0xE7, 0x9B, 0x86 },
	0xDDCF, { 0xE7, 0xB2, 0x89 },
	0xDDD0, { 0xE7, 0xB3, 0x9E },
	0xDDD1, { 0xE7, 0xB4, 0x9B },
	0xDDD2, { 0xE8, 0x8A, 0xAC },
	0xDDD3, { 0xE8, 0xB3, 0x81 },
	0xDDD4, { 0xE9, 0x9B, 0xB0 },
	0xDDD5, { 0xEF, 0xA5, 0xA7 },
	0xDDD6, { 0xE4, 0xBD, 0x9B },
	0xDDD7, { 0xE5, 0xBC, 0x97 },
	0xDDD8, { 0xE5, 0xBD, 0xBF },
	0xDDD9, { 0xE6, 0x8B, 0x82 },
	0xDDDA, { 0xE5, 0xB4, 0xA9 },
	0xDDDB, { 0xE6, 0x9C, 0x8B },
	0xDDDC, { 0xE6, 0xA3, 0x9A },
	0xDDDD, { 0xE7, 0xA1, 0xBC },
	0xDDDE, { 0xE7, 0xB9, 0x83 },
	0xDDDF, { 0xE9, 0xB5, 0xAC },
	0xDDE0, { 0xE4, 0xB8, 0x95 },
	0xDDE1, { 0xE5, 0x82, 0x99 },
	0xDDE2, { 0xE5, 0x8C, 0x95 },
	0xDDE3, { 0xE5, 0x8C, 0xAA },
	0xDDE4, { 0xE5, 0x8D, 0x91 },
	0xDDE5, { 0xE5, 0xA6, 0x83 },
	0xDDE6, { 0xE5, 0xA9, 0xA2 },
	0xDDE7, { 0xE5, 0xBA, 0x87 },
	0xDDE8, { 0xE6, 0x82, 0xB2 },
	0xDDE9, { 0xE6, 0x86, 0x8A },
	0xDDEA, { 0xE6, 0x89, 0x89 },
	0xDDEB, { 0xE6, 0x89, 0xB9 },
	0xDDEC, { 0xE6, 0x96, 0x90 },
	0xDDED, { 0xE6, 0x9E, 0x87 },
	0xDDEE, { 0xE6, 0xA6, 0xA7 },
	0xDDEF, { 0xE6, 0xAF, 0x94 },
	0xDDF0, { 0xE6, 0xAF, 0x96 },
	0xDDF1, { 0xE6, 0xAF, 0x97 },
	0xDDF2, { 0xE6, 0xAF, 0x98 },
	0xDDF3, { 0xE6, 0xB2, 0xB8 },
	0xDDF4, { 0xEF, 0xA5, 0xA8 },
	0xDDF5, { 0xE7, 0x90, 0xB5 },
	0xDDF6, { 0xE7, 0x97, 0xBA },
	0xDDF7, { 0xE7, 0xA0, 0x92 },
	0xDDF8, { 0xE7, 0xA2, 0x91 },
	0xDDF9, { 0xE7, 0xA7, 0x95 },
	0xDDFA, { 0xE7, 0xA7, 0x98 },
	0xDDFB, { 0xE7, 0xB2, 0x83 },
	0xDDFC, { 0xE7, 0xB7, 0x8B },
	0xDDFD, { 0xE7, 0xBF, 0xA1 },
	0xDDFE, { 0xE8, 0x82, 0xA5 },
	0xDEA1, { 0xE8, 0x84, 0xBE },
	0xDEA2, { 0xE8, 0x87, 0x82 },
	0xDEA3, { 0xE8, 0x8F, 0xB2 },
	0xDEA4, { 0xE8, 0x9C, 0x9A },
	0xDEA5, { 0xE8, 0xA3, 0xA8 },
	0xDEA6, { 0xE8, 0xAA, 0xB9 },
	0xDEA7, { 0xE8, 0xAD, 0xAC },
	0xDEA8, { 0xE8, 0xB2, 0xBB },
	0xDEA9, { 0xE9, 0x84, 0x99 },
	0xDEAA, { 0xE9, 0x9D, 0x9E },
	0xDEAB, { 0xE9, 0xA3, 0x9B },
	0xDEAC, { 0xE9, 0xBC, 0xBB },
	0xDEAD, { 0xE5, 0x9A, 0xAC },
	0xDEAE, { 0xE5, 0xAC, 0xAA },
	0xDEAF, { 0xE5, 0xBD, 0xAC },
	0xDEB0, { 0xE6, 0x96, 0x8C },
	0xDEB1, { 0xE6, 0xAA, 0xB3 },
	0xDEB2, { 0xE6, 0xAE, 0xAF },
	0xDEB3, { 0xE6, 0xB5, 0x9C },
	0xDEB4, { 0xE6, 0xBF, 0xB1 },
	0xDEB5, { 0xE7, 0x80, 0x95 },
	0xDEB6, { 0xE7, 0x89, 0x9D },
	0xDEB7, { 0xE7, 0x8E, 0xAD },
	0xDEB8, { 0xE8, 0xB2, 0xA7 },
	0xDEB9, { 0xE8, 0xB3, 0x93 },
	0xDEBA, { 0xE9, 0xA0, 0xBB },
	0xDEBB, { 0xE6, 0x86, 0x91 },
	0xDEBC, { 0xE6, 0xB0, 0xB7 },
	0xDEBD, { 0xE8, 0x81, 0x98 },
	0xDEBE, { 0xE9, 0xA8, 0x81 },
	0xDEBF, { 0xE4, 0xB9, 0x8D },
	0xDEC0, { 0xE4, 0xBA, 0x8B },
	0xDEC1, { 0xE4, 0xBA, 0x9B },
	0xDEC2, { 0xE4, 0xBB, 0x95 },
	0xDEC3, { 0xE4, 0xBC, 0xBA },
	0xDEC4, { 0xE4, 0xBC, 0xBC },
	0xDEC5, { 0xE4, 0xBD, 0xBF },
	0xDEC6, { 0xE4, 0xBF, 0x9F },
	0xDEC7, { 0xE5, 0x83, 0xBF },
	0xDEC8, { 0xE5, 0x8F, 0xB2 },
	0xDEC9, { 0xE5, 0x8F, 0xB8 },
	0xDECA, { 0xE5, 0x94, 0x86 },
	0xDECB, { 0xE5, 0x97, 0xA3 },
	0xDECC, { 0xE5, 0x9B, 0x9B },
	0xDECD, { 0xE5, 0xA3, 0xAB },
	0xDECE, { 0xE5, 0xA5, 0xA2 },
	0xDECF, { 0xE5, 0xA8, 0x91 },
	0xDED0, { 0xE5, 0xAF, 0xAB },
	0xDED1, { 0xE5, 0xAF, 0xBA },
	0xDED2, { 0xE5, 0xB0, 0x84 },
	0xDED3, { 0xE5, 0xB7, 0xB3 },
	0xDED4, { 0xE5, 0xB8, 0xAB },
	0xDED5, { 0xE5, 0xBE, 0x99 },
	0xDED6, { 0xE6, 0x80, 0x9D },
	0xDED7, { 0xE6, 0x8D, 0xA8 },
	0xDED8, { 0xE6, 0x96, 0x9C },
	0xDED9, { 0xE6, 0x96, 0xAF },
	0xDEDA, { 0xE6, 0x9F, 0xB6 },
	0xDEDB, { 0xE6, 0x9F, 0xBB },
	0xDEDC, { 0xE6, 0xA2, 0xAD },
	0xDEDD, { 0xE6, 0xAD, 0xBB },
	0xDEDE, { 0xE6, 0xB2, 0x99 },
	0xDEDF, { 0xE6, 0xB3, 0x97 },
	0xDEE0, { 0xE6, 0xB8, 0xA3 },
	0xDEE1, { 0xE7, 0x80, 0x89 },
	0xDEE2, { 0xE7, 0x8D, 0x85 },
	0xDEE3, { 0xE7, 0xA0, 0x82 },
	0xDEE4, { 0xE7, 0xA4, 0xBE },
	0xDEE5, { 0xE7, 0xA5, 0x80 },
	0xDEE6, { 0xE7, 0xA5, 0xA0 },
	0xDEE7, { 0xE7, 0xA7, 0x81 },
	0xDEE8, { 0xE7, 0xAF, 0xA9 },
	0xDEE9, { 0xE7, 0xB4, 0x97 },
	0xDEEA, { 0xE7, 0xB5, 0xB2 },
	0xDEEB, { 0xE8, 0x82, 0x86 },
	0xDEEC, { 0xE8, 0x88, 0x8D },
	0xDEED, { 0xE8, 0x8E, 0x8E },
	0xDEEE, { 0xE8, 0x93, 0x91 },
	0xDEEF, { 0xE8, 0x9B, 0x87 },
	0xDEF0, { 0xE8, 0xA3, 0x9F },
	0xDEF1, { 0xE8, 0xA9, 0x90 },
	0xDEF2, { 0xE8, 0xA9, 0x9E },
	0xDEF3, { 0xE8, 0xAC, 0x9D },
	0xDEF4, { 0xE8, 0xB3, 0x9C },
	0xDEF5, { 0xE8, 0xB5, 0xA6 },
	0xDEF6, { 0xE8, 0xBE, 0xAD },
	0xDEF7, { 0xE9, 0x82, 0xAA },
	0xDEF8, { 0xE9, 0xA3, 0xBC },
	0xDEF9, { 0xE9, 0xA7, 0x9F },
	0xDEFA, { 0xE9, 0xBA, 0x9D },
	0xDEFB, { 0xE5, 0x89, 0x8A },
	0xDEFC, { 0xEF, 0xA5, 0xA9 },
	0xDEFD, { 0xE6, 0x9C, 0x94 },
	0xDEFE, { 0xEF, 0xA5, 0xAA },
	0xDFA1, { 0xE5, 0x82, 0x98 },
	0xDFA2, { 0xE5, 0x88, 0xAA },
	0xDFA3, { 0xE5, 0xB1, 0xB1 },
	0xDFA4, { 0xE6, 0x95, 0xA3 },
	0xDFA5, { 0xE6, 0xB1, 0x95 },
	0xDFA6, { 0xE7, 0x8F, 0x8A },
	0xDFA7, { 0xE7, 0x94, 0xA3 },
	0xDFA8, { 0xE7, 0x96, 0x9D },
	0xDFA9, { 0xE7, 0xAE, 0x97 },
	0xDFAA, { 0xE8, 0x92, 0x9C },
	0xDFAB, { 0xE9, 0x85, 0xB8 },
	0xDFAC, { 0xE9, 0x9C, 0xB0 },
	0xDFAD, { 0xE4, 0xB9, 0xB7 },
	0xDFAE, { 0xE6, 0x92, 0x92 },
	0xDFAF, { 0xE6, 0xAE, 0xBA },
	0xDFB0, { 0xE7, 0x85, 0x9E },
	0xDFB1, { 0xE8, 0x96, 0xA9 },
	0xDFB2, { 0xE4, 0xB8, 0x89 },
	0xDFB3, { 0xEF, 0xA5, 0xAB },
	0xDFB4, { 0xE6, 0x9D, 0x89 },
	0xDFB5, { 0xE6, 0xA3, 0xAE },
	0xDFB6, { 0xE6, 0xB8, 0x97 },
	0xDFB7, { 0xE8, 0x8A, 0x9F },
	0xDFB8, { 0xE8, 0x94, 0x98 },
	0xDFB9, { 0xE8, 0xA1, 0xAB },
	0xDFBA, { 0xE6, 0x8F, 0xB7 },
	0xDFBB, { 0xE6, 0xBE, 0x81 },
	0xDFBC, { 0xE9, 0x88, 0x92 },
	0xDFBD, { 0xE9, 0xA2, 0xAF },
	0xDFBE, { 0xE4, 0xB8, 0x8A },
	0xDFBF, { 0xE5, 0x82, 0xB7 },
	0xDFC0, { 0xE5, 0x83, 0x8F },
	0xDFC1, { 0xE5, 0x84, 0x9F },
	0xDFC2, { 0xE5, 0x95, 0x86 },
	0xDFC3, { 0xE5, 0x96, 0xAA },
	0xDFC4, { 0xE5, 0x98, 0x97 },
	0xDFC5, { 0xE5, 0xAD, 0x80 },
	0xDFC6, { 0xE5, 0xB0, 0x99 },
	0xDFC7, { 0xE5, 0xB3, 0xA0 },
	0xDFC8, { 0xE5, 0xB8, 0xB8 },
	0xDFC9, { 0xE5, 0xBA, 0x8A },
	0xDFCA, { 0xE5, 0xBA, 0xA0 },
	0xDFCB, { 0xE5, 0xBB, 0x82 },
	0xDFCC, { 0xE6, 0x83, 0xB3 },
	0xDFCD, { 0xE6, 0xA1, 0x91 },
	0xDFCE, { 0xE6, 0xA9, 0xA1 },
	0xDFCF, { 0xE6, 0xB9, 0x98 },
	0xDFD0, { 0xE7, 0x88, 0xBD },
	0xDFD1, { 0xE7, 0x89, 0x80 },
	0xDFD2, { 0xE7, 0x8B, 0x80 },
	0xDFD3, { 0xE7, 0x9B, 0xB8 },
	0xDFD4, { 0xE7, 0xA5, 0xA5 },
	0xDFD5, { 0xE7, 0xAE, 0xB1 },
	0xDFD6, { 0xE7, 0xBF, 0x94 },
	0xDFD7, { 0xE8, 0xA3, 0xB3 },
	0xDFD8, { 0xE8, 0xA7, 0xB4 },
	0xDFD9, { 0xE8, 0xA9, 0xB3 },
	0xDFDA, { 0xE8, 0xB1, 0xA1 },
	0xDFDB, { 0xE8, 0xB3, 0x9E },
	0xDFDC, { 0xE9, 0x9C, 0x9C },
	0xDFDD, { 0xE5, 0xA1, 0x9E },
	0xDFDE, { 0xE7, 0x92, 0xBD },
	0xDFDF, { 0xE8, 0xB3, 0xBD },
	0xDFE0, { 0xE5, 0x97, 0x87 },
	0xDFE1, { 0xEF, 0xA5, 0xAC },
	0xDFE2, { 0xE7, 0xA9, 0xA1 },
	0xDFE3, { 0xE7, 0xB4, 0xA2 },
	0xDFE4, { 0xE8, 0x89, 0xB2 },
	0xDFE5, { 0xE7, 0x89, 0xB2 },
	0xDFE6, { 0xE7, 0x94, 0x9F },
	0xDFE7, { 0xE7, 0x94, 0xA5 },
	0xDFE8, { 0xEF, 0xA5, 0xAD },
	0xDFE9, { 0xE7, 0xAC, 0x99 },
	0xDFEA, { 0xE5, 0xA2, 0x85 },
	0xDFEB, { 0xE5, 0xA3, 0xBB },
	0xDFEC, { 0xE5, 0xB6, 0xBC },
	0xDFED, { 0xE5, 0xBA, 0x8F },
	0xDFEE, { 0xE5, 0xBA, 0xB6 },
	0xDFEF, { 0xE5, 0xBE, 0x90 },
	0xDFF0, { 0xE6, 0x81, 0x95 },
	0xDFF1, { 0xE6, 0x8A, 0x92 },
	0xDFF2, { 0xE6, 0x8D, 0xBF },
	0xDFF3, { 0xE6, 0x95, 0x8D },
	0xDFF4, { 0xE6, 0x9A, 0x91 },
	0xDFF5, { 0xE6, 0x9B, 0x99 },
	0xDFF6, { 0xE6, 0x9B, 0xB8 },
	0xDFF7, { 0xE6, 0xA0, 0x96 },
	0xDFF8, { 0xE6, 0xA3, 0xB2 },
	0xDFF9, { 0xE7, 0x8A, 0x80 },
	0xDFFA, { 0xE7, 0x91, 0x9E },
	0xDFFB, { 0xE7, 0xAD, 0xAE },
	0xDFFC, { 0xE7, 0xB5, 0xAE },
	0xDFFD, { 0xE7, 0xB7, 0x96 },
	0xDFFE, { 0xE7, 0xBD, 0xB2 },
	0xE0A1, { 0xE8, 0x83, 0xA5 },
	0xE0A2, { 0xE8, 0x88, 0x92 },
	0xE0A3, { 0xE8, 0x96, 0xAF },
	0xE0A4, { 0xE8, 0xA5, 0xBF },
	0xE0A5, { 0xE8, 0xAA, 0x93 },
	0xE0A6, { 0xE9, 0x80, 0x9D },
	0xE0A7, { 0xE9, 0x8B, 0xA4 },
	0xE0A8, { 0xE9, 0xBB, 0x8D },
	0xE0A9, { 0xE9, 0xBC, 0xA0 },
	0xE0AA, { 0xE5, 0xA4, 0x95 },
	0xE0AB, { 0xE5, 0xA5, 0xAD },
	0xE0AC, { 0xE5, 0xB8, 0xAD },
	0xE0AD, { 0xE6, 0x83, 0x9C },
	0xE0AE, { 0xE6, 0x98, 0x94 },
	0xE0AF, { 0xE6, 0x99, 0xB3 },
	0xE0B0, { 0xE6, 0x9E, 0x90 },
	0xE0B1, { 0xE6, 0xB1, 0x90 },
	0xE0B2, { 0xE6, 0xB7, 0x85 },
	0xE0B3, { 0xE6, 0xBD, 0x9F },
	0xE0B4, { 0xE7, 0x9F, 0xB3 },
	0xE0B5, { 0xE7, 0xA2, 0xA9 },
	0xE0B6, { 0xE8, 0x93, 0x86 },
	0xE0B7, { 0xE9, 0x87, 0x8B },
	0xE0B8, { 0xE9, 0x8C, 0xAB },
	0xE0B9, { 0xE4, 0xBB, 0x99 },
	0xE0BA, { 0xE5, 0x83, 0x8A },
	0xE0BB, { 0xE5, 0x85, 0x88 },
	0xE0BC, { 0xE5, 0x96, 0x84 },
	0xE0BD, { 0xE5, 0xAC, 0x8B },
	0xE0BE, { 0xE5, 0xAE, 0xA3 },
	0xE0BF, { 0xE6, 0x89, 0x87 },
	0xE0C0, { 0xE6, 0x95, 0xBE },
	0xE0C1, { 0xE6, 0x97, 0x8B },
	0xE0C2, { 0xE6, 0xB8, 0xB2 },
	0xE0C3, { 0xE7, 0x85, 0xBD },
	0xE0C4, { 0xE7, 0x90, 0x81 },
	0xE0C5, { 0xE7, 0x91, 0x84 },
	0xE0C6, { 0xE7, 0x92, 0x87 },
	0xE0C7, { 0xE7, 0x92, 0xBF },
	0xE0C8, { 0xE7, 0x99, 0xAC },
	0xE0C9, { 0xE7, 0xA6, 0xAA },
	0xE0CA, { 0xE7, 0xB7, 0x9A },
	0xE0CB, { 0xE7, 0xB9, 0x95 },
	0xE0CC, { 0xE7, 0xBE, 0xA8 },
	0xE0CD, { 0xE8, 0x85, 0xBA },
	0xE0CE, { 0xE8, 0x86, 0xB3 },
	0xE0CF, { 0xE8, 0x88, 0xB9 },
	0xE0D0, { 0xE8, 0x98, 0x9A },
	0xE0D1, { 0xE8, 0x9F, 0xAC },
	0xE0D2, { 0xE8, 0xA9, 0xB5 },
	0xE0D3, { 0xE8, 0xB7, 0xA3 },
	0xE0D4, { 0xE9, 0x81, 0xB8 },
	0xE0D5, { 0xE9, 0x8A, 0x91 },
	0xE0D6, { 0xE9, 0x90, 0xA5 },
	0xE0D7, { 0xE9, 0xA5, 0x8D },
	0xE0D8, { 0xE9, 0xAE, 0xAE },
	0xE0D9, { 0xE5, 0x8D, 0xA8 },
	0xE0DA, { 0xE5, 0xB1, 0x91 },
	0xE0DB, { 0xE6, 0xA5, 0x94 },
	0xE0DC, { 0xE6, 0xB3, 0x84 },
	0xE0DD, { 0xE6, 0xB4, 0xA9 },
	0xE0DE, { 0xE6, 0xB8, 0xAB },
	0xE0DF, { 0xE8, 0x88, 0x8C },
	0xE0E0, { 0xE8, 0x96, 0x9B },
	0xE0E1, { 0xE8, 0xA4, 0xBB },
	0xE0E2, { 0xE8, 0xA8, 0xAD },
	0xE0E3, { 0xE8, 0xAA, 0xAA },
	0xE0E4, { 0xE9, 0x9B, 0xAA },
	0xE0E5, { 0xE9, 0xBD, 0xA7 },
	0xE0E6, { 0xE5, 0x89, 0xA1 },
	0xE0E7, { 0xE6, 0x9A, 0xB9 },
	0xE0E8, { 0xE6, 0xAE, 0xB2 },
	0xE0E9, { 0xE7, 0xBA, 0x96 },
	0xE0EA, { 0xE8, 0x9F, 0xBE },
	0xE0EB, { 0xE8, 0xB4, 0x8D },
	0xE0EC, { 0xE9, 0x96, 0x83 },
	0xE0ED, { 0xE9, 0x99, 0x9D },
	0xE0EE, { 0xE6, 0x94, 0x9D },
	0xE0EF, { 0xE6, 0xB6, 0x89 },
	0xE0F0, { 0xE7, 0x87, 0xAE },
	0xE0F1, { 0xEF, 0xA5, 0xAE },
	0xE0F2, { 0xE5, 0x9F, 0x8E },
	0xE0F3, { 0xE5, 0xA7, 0x93 },
	0xE0F4, { 0xE5, 0xAE, 0xAC },
	0xE0F5, { 0xE6, 0x80, 0xA7 },
	0xE0F6, { 0xE6, 0x83, 0xBA },
	0xE0F7, { 0xE6, 0x88, 0x90 },
	0xE0F8, { 0xE6, 0x98, 0x9F },
	0xE0F9, { 0xE6, 0x99, 0x9F },
	0xE0FA, { 0xE7, 0x8C, 0xA9 },
	0xE0FB, { 0xE7, 0x8F, 0xB9 },
	0xE0FC, { 0xE7, 0x9B, 0x9B },
	0xE0FD, { 0xE7, 0x9C, 0x81 },
	0xE0FE, { 0xE7, 0xAD, 0xAC },
	0xE1A1, { 0xE8, 0x81, 0x96 },
	0xE1A2, { 0xE8, 0x81, 0xB2 },
	0xE1A3, { 0xE8, 0x85, 0xA5 },
	0xE1A4, { 0xE8, 0xAA, 0xA0 },
	0xE1A5, { 0xE9, 0x86, 0x92 },
	0xE1A6, { 0xE4, 0xB8, 0x96 },
	0xE1A7, { 0xE5, 0x8B, 0xA2 },
	0xE1A8, { 0xE6, 0xAD, 0xB2 },
	0xE1A9, { 0xE6, 0xB4, 0x97 },
	0xE1AA, { 0xE7, 0xA8, 0x85 },
	0xE1AB, { 0xE7, 0xAC, 0xB9 },
	0xE1AC, { 0xE7, 0xB4, 0xB0 },
	0xE1AD, { 0xEF, 0xA5, 0xAF },
	0xE1AE, { 0xE8, 0xB2, 0xB0 },
	0xE1AF, { 0xE5, 0x8F, 0xAC },
	0xE1B0, { 0xE5, 0x98, 0xAF },
	0xE1B1, { 0xE5, 0xA1, 0x91 },
	0xE1B2, { 0xE5, 0xAE, 0xB5 },
	0xE1B3, { 0xE5, 0xB0, 0x8F },
	0xE1B4, { 0xE5, 0xB0, 0x91 },
	0xE1B5, { 0xE5, 0xB7, 0xA2 },
	0xE1B6, { 0xE6, 0x89, 0x80 },
	0xE1B7, { 0xE6, 0x8E, 0x83 },
	0xE1B8, { 0xE6, 0x90, 0x94 },
	0xE1B9, { 0xE6, 0x98, 0xAD },
	0xE1BA, { 0xE6, 0xA2, 0xB3 },
	0xE1BB, { 0xE6, 0xB2, 0xBC },
	0xE1BC, { 0xE6, 0xB6, 0x88 },
	0xE1BD, { 0xE6, 0xBA, 0xAF },
	0xE1BE, { 0xE7, 0x80, 0x9F },
	0xE1BF, { 0xE7, 0x82, 0xA4 },
	0xE1C0, { 0xE7, 0x87, 0x92 },
	0xE1C1, { 0xE7, 0x94, 0xA6 },
	0xE1C2, { 0xE7, 0x96, 0x8F },
	0xE1C3, { 0xE7, 0x96, 0x8E },
	0xE1C4, { 0xE7, 0x98, 0x99 },
	0xE1C5, { 0xE7, 0xAC, 0x91 },
	0xE1C6, { 0xE7, 0xAF, 0xA0 },
	0xE1C7, { 0xE7, 0xB0, 0xAB },
	0xE1C8, { 0xE7, 0xB4, 0xA0 },
	0xE1C9, { 0xE7, 0xB4, 0xB9 },
	0xE1CA, { 0xE8, 0x94, 0xAC },
	0xE1CB, { 0xE8, 0x95, 0xAD },
	0xE1CC, { 0xE8, 0x98, 0x87 },
	0xE1CD, { 0xE8, 0xA8, 0xB4 },
	0xE1CE, { 0xE9, 0x80, 0x8D },
	0xE1CF, { 0xE9, 0x81, 0xA1 },
	0xE1D0, { 0xE9, 0x82, 0xB5 },
	0xE1D1, { 0xE9, 0x8A, 0xB7 },
	0xE1D2, { 0xE9, 0x9F, 0xB6 },
	0xE1D3, { 0xE9, 0xA8, 0xB7 },
	0xE1D4, { 0xE4, 0xBF, 0x97 },
	0xE1D5, { 0xE5, 0xB1, 0xAC },
	0xE1D6, { 0xE6, 0x9D, 0x9F },
	0xE1D7, { 0xE6, 0xB6, 0x91 },
	0xE1D8, { 0xE7, 0xB2, 0x9F },
	0xE1D9, { 0xE7, 0xBA, 0x8C },
	0xE1DA, { 0xE8, 0xAC, 0x96 },
	0xE1DB, { 0xE8, 0xB4, 0x96 },
	0xE1DC, { 0xE9, 0x80, 0x9F },
	0xE1DD, { 0xE5, 0xAD, 0xAB },
	0xE1DE, { 0xE5, 0xB7, 0xBD },
	0xE1DF, { 0xE6, 0x90, 0x8D },
	0xE1E0, { 0xE8, 0x93, 0x80 },
	0xE1E1, { 0xE9, 0x81, 0x9C },
	0xE1E2, { 0xE9, 0xA3, 0xA1 },
	0xE1E3, { 0xE7, 0x8E, 0x87 },
	0xE1E4, { 0xE5, 0xAE, 0x8B },
	0xE1E5, { 0xE6, 0x82, 0x9A },
	0xE1E6, { 0xE6, 0x9D, 0xBE },
	0xE1E7, { 0xE6, 0xB7, 0x9E },
	0xE1E8, { 0xE8, 0xA8, 0x9F },
	0xE1E9, { 0xE8, 0xAA, 0xA6 },
	0xE1EA, { 0xE9, 0x80, 0x81 },
	0xE1EB, { 0xE9, 0xA0, 0x8C },
	0xE1EC, { 0xE5, 0x88, 0xB7 },
	0xE1ED, { 0xEF, 0xA5, 0xB0 },
	0xE1EE, { 0xE7, 0x81, 0x91 },
	0xE1EF, { 0xE7, 0xA2, 0x8E },
	0xE1F0, { 0xE9, 0x8E, 0x96 },
	0xE1F1, { 0xE8, 0xA1, 0xB0 },
	0xE1F2, { 0xE9, 0x87, 0x97 },
	0xE1F3, { 0xE4, 0xBF, 0xAE },
	0xE1F4, { 0xE5, 0x8F, 0x97 },
	0xE1F5, { 0xE5, 0x97, 0xBD },
	0xE1F6, { 0xE5, 0x9B, 0x9A },
	0xE1F7, { 0xE5, 0x9E, 0x82 },
	0xE1F8, { 0xE5, 0xA3, 0xBD },
	0xE1F9, { 0xE5, 0xAB, 0x82 },
	0xE1FA, { 0xE5, 0xAE, 0x88 },
	0xE1FB, { 0xE5, 0xB2, 0xAB },
	0xE1FC, { 0xE5, 0xB3, 0x80 },
	0xE1FD, { 0xE5, 0xB8, 0xA5 },
	0xE1FE, { 0xE6, 0x84, 0x81 },
	0xE2A1, { 0xE6, 0x88, 0x8D },
	0xE2A2, { 0xE6, 0x89, 0x8B },
	0xE2A3, { 0xE6, 0x8E, 0x88 },
	0xE2A4, { 0xE6, 0x90, 0x9C },
	0xE2A5, { 0xE6, 0x94, 0xB6 },
	0xE2A6, { 0xE6, 0x95, 0xB8 },
	0xE2A7, { 0xE6, 0xA8, 0xB9 },
	0xE2A8, { 0xE6, 0xAE, 0x8A },
	0xE2A9, { 0xE6, 0xB0, 0xB4 },
	0xE2AA, { 0xE6, 0xB4, 0x99 },
	0xE2AB, { 0xE6, 0xBC, 0xB1 },
	0xE2AC, { 0xE7, 0x87, 0xA7 },
	0xE2AD, { 0xE7, 0x8B, 0xA9 },
	0xE2AE, { 0xE7, 0x8D, 0xB8 },
	0xE2AF, { 0xE7, 0x90, 0x87 },
	0xE2B0, { 0xE7, 0x92, 0xB2 },
	0xE2B1, { 0xE7, 0x98, 0xA6 },
	0xE2B2, { 0xE7, 0x9D, 0xA1 },
	0xE2B3, { 0xE7, 0xA7, 0x80 },
	0xE2B4, { 0xE7, 0xA9, 0x97 },
	0xE2B5, { 0xE7, 0xAB, 0xAA },
	0xE2B6, { 0xE7, 0xB2, 0xB9 },
	0xE2B7, { 0xE7, 0xB6, 0x8F },
	0xE2B8, { 0xE7, 0xB6, 0xAC },
	0xE2B9, { 0xE7, 0xB9, 0xA1 },
	0xE2BA, { 0xE7, 0xBE, 0x9E },
	0xE2BB, { 0xE8, 0x84, 0xA9 },
	0xE2BC, { 0xE8, 0x8C, 0xB1 },
	0xE2BD, { 0xE8, 0x92, 0x90 },
	0xE2BE, { 0xE8, 0x93, 0x9A },
	0xE2BF, { 0xE8, 0x97, 0xAA },
	0xE2C0, { 0xE8, 0xA2, 0x96 },
	0xE2C1, { 0xE8, 0xAA, 0xB0 },
	0xE2C2, { 0xE8, 0xAE, 0x90 },
	0xE2C3, { 0xE8, 0xBC, 0xB8 },
	0xE2C4, { 0xE9, 0x81, 0x82 },
	0xE2C5, { 0xE9, 0x82, 0x83 },
	0xE2C6, { 0xE9, 0x85, 0xAC },
	0xE2C7, { 0xE9, 0x8A, 0x96 },
	0xE2C8, { 0xE9, 0x8A, 0xB9 },
	0xE2C9, { 0xE9, 0x9A, 0x8B },
	0xE2CA, { 0xE9, 0x9A, 0xA7 },
	0xE2CB, { 0xE9, 0x9A, 0xA8 },
	0xE2CC, { 0xE9, 0x9B, 0x96 },
	0xE2CD, { 0xE9, 0x9C, 0x80 },
	0xE2CE, { 0xE9, 0xA0, 0x88 },
	0xE2CF, { 0xE9, 0xA6, 0x96 },
	0xE2D0, { 0xE9, 0xAB, 0x93 },
	0xE2D1, { 0xE9, 0xAC, 0x9A },
	0xE2D2, { 0xE5, 0x8F, 0x94 },
	0xE2D3, { 0xE5, 0xA1, 0xBE },
	0xE2D4, { 0xE5, 0xA4, 0x99 },
	0xE2D5, { 0xE5, 0xAD, 0xB0 },
	0xE2D6, { 0xE5, 0xAE, 0xBF },
	0xE2D7, { 0xE6, 0xB7, 0x91 },
	0xE2D8, { 0xE6, 0xBD, 0x9A },
	0xE2D9, { 0xE7, 0x86, 0x9F },
	0xE2DA, { 0xE7, 0x90, 0xA1 },
	0xE2DB, { 0xE7, 0x92, 0xB9 },
	0xE2DC, { 0xE8, 0x82, 0x85 },
	0xE2DD, { 0xE8, 0x8F, 0xBD },
	0xE2DE, { 0xE5, 0xB7, 0xA1 },
	0xE2DF, { 0xE5, 0xBE, 0x87 },
	0xE2E0, { 0xE5, 0xBE, 0xAA },
	0xE2E1, { 0xE6, 0x81, 0x82 },
	0xE2E2, { 0xE6, 0x97, 0xAC },
	0xE2E3, { 0xE6, 0xA0, 0x92 },
	0xE2E4, { 0xE6, 0xA5, 0xAF },
	0xE2E5, { 0xE6, 0xA9, 0x93 },
	0xE2E6, { 0xE6, 0xAE, 0x89 },
	0xE2E7, { 0xE6, 0xB4, 0xB5 },
	0xE2E8, { 0xE6, 0xB7, 0xB3 },
	0xE2E9, { 0xE7, 0x8F, 0xA3 },
	0xE2EA, { 0xE7, 0x9B, 0xBE },
	0xE2EB, { 0xE7, 0x9E, 0xAC },
	0xE2EC, { 0xE7, 0xAD, 0x8D },
	0xE2ED, { 0xE7, 0xB4, 0x94 },
	0xE2EE, { 0xE8, 0x84, 0xA3 },
	0xE2EF, { 0xE8, 0x88, 0x9C },
	0xE2F0, { 0xE8, 0x8D, 0x80 },
	0xE2F1, { 0xE8, 0x93, 0xB4 },
	0xE2F2, { 0xE8, 0x95, 0xA3 },
	0xE2F3, { 0xE8, 0xA9, 0xA2 },
	0xE2F4, { 0xE8, 0xAB, 0x84 },
	0xE2F5, { 0xE9, 0x86, 0x87 },
	0xE2F6, { 0xE9, 0x8C, 0x9E },
	0xE2F7, { 0xE9, 0xA0, 0x86 },
	0xE2F8, { 0xE9, 0xA6, 0xB4 },
	0xE2F9, { 0xE6, 0x88, 0x8C },
	0xE2FA, { 0xE8, 0xA1, 0x93 },
	0xE2FB, { 0xE8, 0xBF, 0xB0 },
	0xE2FC, { 0xE9, 0x89, 0xA5 },
	0xE2FD, { 0xE5, 0xB4, 0x87 },
	0xE2FE, { 0xE5, 0xB4, 0xA7 },
	0xE3A1, { 0xE5, 0xB5, 0xA9 },
	0xE3A2, { 0xE7, 0x91, 0x9F },
	0xE3A3, { 0xE8, 0x86, 0x9D },
	0xE3A4, { 0xE8, 0x9D, 0xA8 },
	0xE3A5, { 0xE6, 0xBF, 0x95 },
	0xE3A6, { 0xE6, 0x8B, 0xBE },
	0xE3A7, { 0xE7, 0xBF, 0x92 },
	0xE3A8, { 0xE8, 0xA4, 0xB6 },
	0xE3A9, { 0xE8, 0xA5, 0xB2 },
	0xE3AA, { 0xE4, 0xB8, 0x9E },
	0xE3AB, { 0xE4, 0xB9, 0x98 },
	0xE3AC, { 0xE5, 0x83, 0xA7 },
	0xE3AD, { 0xE5, 0x8B, 0x9D },
	0xE3AE, { 0xE5, 0x8D, 0x87 },
	0xE3AF, { 0xE6, 0x89, 0xBF },
	0xE3B0, { 0xE6, 0x98, 0x87 },
	0xE3B1, { 0xE7, 0xB9, 0xA9 },
	0xE3B2, { 0xE8, 0xA0, 0x85 },
	0xE3B3, { 0xE9, 0x99, 0x9E },
	0xE3B4, { 0xE4, 0xBE, 0x8D },
	0xE3B5, { 0xE5, 0x8C, 0x99 },
	0xE3B6, { 0xE5, 0x98, 0xB6 },
	0xE3B7, { 0xE5, 0xA7, 0x8B },
	0xE3B8, { 0xE5, 0xAA, 0xA4 },
	0xE3B9, { 0xE5, 0xB0, 0xB8 },
	0xE3BA, { 0xE5, 0xB1, 0x8E },
	0xE3BB, { 0xE5, 0xB1, 0x8D },
	0xE3BC, { 0xE5, 0xB8, 0x82 },
	0xE3BD, { 0xE5, 0xBC, 0x91 },
	0xE3BE, { 0xE6, 0x81, 0x83 },
	0xE3BF, { 0xE6, 0x96, 0xBD },
	0xE3C0, { 0xE6, 0x98, 0xAF },
	0xE3C1, { 0xE6, 0x99, 0x82 },
	0xE3C2, { 0xE6, 0x9E, 0xBE },
	0xE3C3, { 0xE6, 0x9F, 0xB4 },
	0xE3C4, { 0xE7, 0x8C, 0x9C },
	0xE3C5, { 0xE7, 0x9F, 0xA2 },
	0xE3C6, { 0xE7, 0xA4, 0xBA },
	0xE3C7, { 0xE7, 0xBF, 0x85 },
	0xE3C8, { 0xE8, 0x92, 0x94 },
	0xE3C9, { 0xE8, 0x93, 0x8D },
	0xE3CA, { 0xE8, 0xA6, 0x96 },
	0xE3CB, { 0xE8, 0xA9, 0xA6 },
	0xE3CC, { 0xE8, 0xA9, 0xA9 },
	0xE3CD, { 0xE8, 0xAB, 0xA1 },
	0xE3CE, { 0xE8, 0xB1, 0x95 },
	0xE3CF, { 0xE8, 0xB1, 0xBA },
	0xE3D0, { 0xE5, 0x9F, 0xB4 },
	0xE3D1, { 0xE5, 0xAF, 0x94 },
	0xE3D2, { 0xE5, 0xBC, 0x8F },
	0xE3D3, { 0xE6, 0x81, 0xAF },
	0xE3D4, { 0xE6, 0x8B, 0xAD },
	0xE3D5, { 0xE6, 0xA4, 0x8D },
	0xE3D6, { 0xE6, 0xAE, 0x96 },
	0xE3D7, { 0xE6, 0xB9, 0x9C },
	0xE3D8, { 0xE7, 0x86, 0x84 },
	0xE3D9, { 0xE7, 0xAF, 0x92 },
	0xE3DA, { 0xE8, 0x9D, 0x95 },
	0xE3DB, { 0xE8, 0xAD, 0x98 },
	0xE3DC, { 0xE8, 0xBB, 0xBE },
	0xE3DD, { 0xE9, 0xA3, 0x9F },
	0xE3DE, { 0xE9, 0xA3, 0xBE },
	0xE3DF, { 0xE4, 0xBC, 0xB8 },
	0xE3E0, { 0xE4, 0xBE, 0x81 },
	0xE3E1, { 0xE4, 0xBF, 0xA1 },
	0xE3E2, { 0xE5, 0x91, 0xBB },
	0xE3E3, { 0xE5, 0xA8, 0xA0 },
	0xE3E4, { 0xE5, 0xAE, 0xB8 },
	0xE3E5, { 0xE6, 0x84, 0xBC },
	0xE3E6, { 0xE6, 0x96, 0xB0 },
	0xE3E7, { 0xE6, 0x99, 0xA8 },
	0xE3E8, { 0xE7, 0x87, 0xBC },
	0xE3E9, { 0xE7, 0x94, 0xB3 },
	0xE3EA, { 0xE7, 0xA5, 0x9E },
	0xE3EB, { 0xE7, 0xB4, 0xB3 },
	0xE3EC, { 0xE8, 0x85, 0x8E },
	0xE3ED, { 0xE8, 0x87, 0xA3 },
	0xE3EE, { 0xE8, 0x8E, 0x98 },
	0xE3EF, { 0xE8, 0x96, 0xAA },
	0xE3F0, { 0xE8, 0x97, 0x8E },
	0xE3F1, { 0xE8, 0x9C, 0x83 },
	0xE3F2, { 0xE8, 0xA8, 0x8A },
	0xE3F3, { 0xE8, 0xBA, 0xAB },
	0xE3F4, { 0xE8, 0xBE, 0x9B },
	0xE3F5, { 0xEF, 0xA5, 0xB1 },
	0xE3F6, { 0xE8, 0xBF, 0x85 },
	0xE3F7, { 0xE5, 0xA4, 0xB1 },
	0xE3F8, { 0xE5, 0xAE, 0xA4 },
	0xE3F9, { 0xE5, 0xAF, 0xA6 },
	0xE3FA, { 0xE6, 0x82, 0x89 },
	0xE3FB, { 0xE5, 0xAF, 0xA9 },
	0xE3FC, { 0xE5, 0xB0, 0x8B },
	0xE3FD, { 0xE5, 0xBF, 0x83 },
	0xE3FE, { 0xE6, 0xB2, 0x81 },
	0xE4A1, { 0xEF, 0xA5, 0xB2 },
	0xE4A2, { 0xE6, 0xB7, 0xB1 },
	0xE4A3, { 0xE7, 0x80, 0x8B },
	0xE4A4, { 0xE7, 0x94, 0x9A },
	0xE4A5, { 0xE8, 0x8A, 0xAF },
	0xE4A6, { 0xE8, 0xAB, 0xB6 },
	0xE4A7, { 0xE4, 0xBB, 0x80 },
	0xE4A8, { 0xE5, 0x8D, 0x81 },
	0xE4A9, { 0xEF, 0xA5, 0xB3 },
	0xE4AA, { 0xE9, 0x9B, 0x99 },
	0xE4AB, { 0xE6, 0xB0, 0x8F },
	0xE4AC, { 0xE4, 0xBA, 0x9E },
	0xE4AD, { 0xE4, 0xBF, 0x84 },
	0xE4AE, { 0xE5, 0x85, 0x92 },
	0xE4AF, { 0xE5, 0x95, 0x9E },
	0xE4B0, { 0xE5, 0xA8, 0xA5 },
	0xE4B1, { 0xE5, 0xB3, 0xA8 },
	0xE4B2, { 0xE6, 0x88, 0x91 },
	0xE4B3, { 0xE7, 0x89, 0x99 },
	0xE4B4, { 0xE8, 0x8A, 0xBD },
	0xE4B5, { 0xE8, 0x8E, 0xAA },
	0xE4B6, { 0xE8, 0x9B, 0xBE },
	0xE4B7, { 0xE8, 0xA1, 0x99 },
	0xE4B8, { 0xE8, 0xA8, 0x9D },
	0xE4B9, { 0xE9, 0x98, 0xBF },
	0xE4BA, { 0xE9, 0x9B, 0x85 },
	0xE4BB, { 0xE9, 0xA4, 0x93 },
	0xE4BC, { 0xE9, 0xB4, 0x89 },
	0xE4BD, { 0xE9, 0xB5, 0x9D },
	0xE4BE, { 0xE5, 0xA0, 0x8A },
	0xE4BF, { 0xE5, 0xB2, 0xB3 },
	0xE4C0, { 0xE5, 0xB6, 0xBD },
	0xE4C1, { 0xE5, 0xB9, 0x84 },
	0xE4C2, { 0xE6, 0x83, 0xA1 },
	0xE4C3, { 0xE6, 0x84, 0x95 },
	0xE4C4, { 0xE6, 0x8F, 0xA1 },
	0xE4C5, { 0xE6, 0xA8, 0x82 },
	0xE4C6, { 0xE6, 0xB8, 0xA5 },
	0xE4C7, { 0xE9, 0x84, 0x82 },
	0xE4C8, { 0xE9, 0x8D, 0x94 },
	0xE4C9, { 0xE9, 0xA1, 0x8E },
	0xE4CA, { 0xE9, 0xB0, 0x90 },
	0xE4CB, { 0xE9, 0xBD, 0xB7 },
	0xE4CC, { 0xE5, 0xAE, 0x89 },
	0xE4CD, { 0xE5, 0xB2, 0xB8 },
	0xE4CE, { 0xE6, 0x8C, 0x89 },
	0xE4CF, { 0xE6, 0x99, 0x8F },
	0xE4D0, { 0xE6, 0xA1, 0x88 },
	0xE4D1, { 0xE7, 0x9C, 0xBC },
	0xE4D2, { 0xE9, 0x9B, 0x81 },
	0xE4D3, { 0xE9, 0x9E, 0x8D },
	0xE4D4, { 0xE9, 0xA1, 0x94 },
	0xE4D5, { 0xE9, 0xAE, 0x9F },
	0xE4D6, { 0xE6, 0x96, 0xA1 },
	0xE4D7, { 0xE8, 0xAC, 0x81 },
	0xE4D8, { 0xE8, 0xBB, 0x8B },
	0xE4D9, { 0xE9, 0x96, 0xBC },
	0xE4DA, { 0xE5, 0x94, 0xB5 },
	0xE4DB, { 0xE5, 0xB2, 0xA9 },
	0xE4DC, { 0xE5, 0xB7, 0x96 },
	0xE4DD, { 0xE5, 0xBA, 0xB5 },
	0xE4DE, { 0xE6, 0x9A, 0x97 },
	0xE4DF, { 0xE7, 0x99, 0x8C },
	0xE4E0, { 0xE8, 0x8F, 0xB4 },
	0xE4E1, { 0xE9, 0x97, 0x87 },
	0xE4E2, { 0xE5, 0xA3, 0x93 },
	0xE4E3, { 0xE6, 0x8A, 0xBC },
	0xE4E4, { 0xE7, 0x8B, 0x8E },
	0xE4E5, { 0xE9, 0xB4, 0xA8 },
	0xE4E6, { 0xE4, 0xBB, 0xB0 },
	0xE4E7, { 0xE5, 0xA4, 0xAE },
	0xE4E8, { 0xE6, 0x80, 0x8F },
	0xE4E9, { 0xE6, 0x98, 0xBB },
	0xE4EA, { 0xE6, 0xAE, 0x83 },
	0xE4EB, { 0xE7, 0xA7, 0xA7 },
	0xE4EC, { 0xE9, 0xB4, 0xA6 },
	0xE4ED, { 0xE5, 0x8E, 0x93 },
	0xE4EE, { 0xE5, 0x93, 0x80 },
	0xE4EF, { 0xE5, 0x9F, 0x83 },
	0xE4F0, { 0xE5, 0xB4, 0x96 },
	0xE4F1, { 0xE6, 0x84, 0x9B },
	0xE4F2, { 0xE6, 0x9B, 0x96 },
	0xE4F3, { 0xE6, 0xB6, 0xAF },
	0xE4F4, { 0xE7, 0xA2, 0x8D },
	0xE4F5, { 0xE8, 0x89, 0xBE },
	0xE4F6, { 0xE9, 0x9A, 0x98 },
	0xE4F7, { 0xE9, 0x9D, 0x84 },
	0xE4F8, { 0xE5, 0x8E, 0x84 },
	0xE4F9, { 0xE6, 0x89, 0xBC },
	0xE4FA, { 0xE6, 0x8E, 0x96 },
	0xE4FB, { 0xE6, 0xB6, 0xB2 },
	0xE4FC, { 0xE7, 0xB8, 0x8A },
	0xE4FD, { 0xE8, 0x85, 0x8B },
	0xE4FE, { 0xE9, 0xA1, 0x8D },
	0xE5A1, { 0xE6, 0xAB, 0xBB },
	0xE5A2, { 0xE7, 0xBD, 0x8C },
	0xE5A3, { 0xE9, 0xB6, 0xAF },
	0xE5A4, { 0xE9, 0xB8, 0x9A },
	0xE5A5, { 0xE4, 0xB9, 0x9F },
	0xE5A6, { 0xE5, 0x80, 0xBB },
	0xE5A7, { 0xE5, 0x86, 0xB6 },
	0xE5A8, { 0xE5, 0xA4, 0x9C },
	0xE5A9, { 0xE6, 0x83, 0xB9 },
	0xE5AA, { 0xE6, 0x8F, 0xB6 },
	0xE5AB, { 0xE6, 0xA4, 0xB0 },
	0xE5AC, { 0xE7, 0x88, 0xBA },
	0xE5AD, { 0xE8, 0x80, 0xB6 },
	0xE5AE, { 0xEF, 0xA5, 0xB4 },
	0xE5AF, { 0xE9, 0x87, 0x8E },
	0xE5B0, { 0xE5, 0xBC, 0xB1 },
	0xE5B1, { 0xEF, 0xA5, 0xB5 },
	0xE5B2, { 0xEF, 0xA5, 0xB6 },
	0xE5B3, { 0xE7, 0xB4, 0x84 },
	0xE5B4, { 0xE8, 0x8B, 0xA5 },
	0xE5B5, { 0xE8, 0x91, 0xAF },
	0xE5B6, { 0xE8, 0x92, 0xBB },
	0xE5B7, { 0xE8, 0x97, 0xA5 },
	0xE5B8, { 0xE8, 0xBA, 0x8D },
	0xE5B9, { 0xEF, 0xA5, 0xB7 },
	0xE5BA, { 0xE4, 0xBD, 0xAF },
	0xE5BB, { 0xEF, 0xA5, 0xB8 },
	0xE5BC, { 0xEF, 0xA5, 0xB9 },
	0xE5BD, { 0xE5, 0xA3, 0xA4 },
	0xE5BE, { 0xE5, 0xAD, 0x83 },
	0xE5BF, { 0xE6, 0x81, 0x99 },
	0xE5C0, { 0xE6, 0x8F, 0x9A },
	0xE5C1, { 0xE6, 0x94, 0x98 },
	0xE5C2, { 0xE6, 0x95, 0xAD },
	0xE5C3, { 0xE6, 0x9A, 0x98 },
	0xE5C4, { 0xEF, 0xA5, 0xBA },
	0xE5C5, { 0xE6, 0xA5, 0x8A },
	0xE5C6, { 0xE6, 0xA8, 0xA3 },
	0xE5C7, { 0xE6, 0xB4, 0x8B },
	0xE5C8, { 0xE7, 0x80, 0x81 },
	0xE5C9, { 0xE7, 0x85, 0xAC },
	0xE5CA, { 0xE7, 0x97, 0x92 },
	0xE5CB, { 0xE7, 0x98, 0x8D },
	0xE5CC, { 0xE7, 0xA6, 0xB3 },
	0xE5CD, { 0xE7, 0xA9, 0xB0 },
	0xE5CE, { 0xEF, 0xA5, 0xBB },
	0xE5CF, { 0xE7, 0xBE, 0x8A },
	0xE5D0, { 0xEF, 0xA5, 0xBC },
	0xE5D1, { 0xE8, 0xA5, 0x84 },
	0xE5D2, { 0xEF, 0xA5, 0xBD },
	0xE5D3, { 0xE8, 0xAE, 0x93 },
	0xE5D4, { 0xE9, 0x87, 0x80 },
	0xE5D5, { 0xE9, 0x99, 0xBD },
	0xE5D6, { 0xEF, 0xA5, 0xBE },
	0xE5D7, { 0xE9, 0xA4, 0x8A },
	0xE5D8, { 0xE5, 0x9C, 0x84 },
	0xE5D9, { 0xE5, 0xBE, 0xA1 },
	0xE5DA, { 0xE6, 0x96, 0xBC },
	0xE5DB, { 0xE6, 0xBC, 0x81 },
	0xE5DC, { 0xE7, 0x98, 0x80 },
	0xE5DD, { 0xE7, 0xA6, 0xA6 },
	0xE5DE, { 0xE8, 0xAA, 0x9E },
	0xE5DF, { 0xE9, 0xA6, 0xAD },
	0xE5E0, { 0xE9, 0xAD, 0x9A },
	0xE5E1, { 0xE9, 0xBD, 0xAC },
	0xE5E2, { 0xE5, 0x84, 0x84 },
	0xE5E3, { 0xE6, 0x86, 0xB6 },
	0xE5E4, { 0xE6, 0x8A, 0x91 },
	0xE5E5, { 0xE6, 0xAA, 0x8D },
	0xE5E6, { 0xE8, 0x87, 0x86 },
	0xE5E7, { 0xE5, 0x81, 0x83 },
	0xE5E8, { 0xE5, 0xA0, 0xB0 },
	0xE5E9, { 0xE5, 0xBD, 0xA6 },
	0xE5EA, { 0xE7, 0x84, 0x89 },
	0xE5EB, { 0xE8, 0xA8, 0x80 },
	0xE5EC, { 0xE8, 0xAB, 0xBA },
	0xE5ED, { 0xE5, 0xAD, 0xBC },
	0xE5EE, { 0xE8, 0x98, 0x96 },
	0xE5EF, { 0xE4, 0xBF, 0xBA },
	0xE5F0, { 0xE5, 0x84, 0xBC },
	0xE5F1, { 0xE5, 0x9A, 0xB4 },
	0xE5F2, { 0xE5, 0xA5, 0x84 },
	0xE5F3, { 0xE6, 0x8E, 0xA9 },
	0xE5F4, { 0xE6, 0xB7, 0xB9 },
	0xE5F5, { 0xE5, 0xB6, 0xAA },
	0xE5F6, { 0xE6, 0xA5, 0xAD },
	0xE5F7, { 0xE5, 0x86, 0x86 },
	0xE5F8, { 0xE4, 0xBA, 0x88 },
	0xE5F9, { 0xE4, 0xBD, 0x99 },
	0xE5FA, { 0xEF, 0xA5, 0xBF },
	0xE5FB, { 0xEF, 0xA6, 0x80 },
	0xE5FC, { 0xEF, 0xA6, 0x81 },
	0xE5FD, { 0xE5, 0xA6, 0x82 },
	0xE5FE, { 0xEF, 0xA6, 0x82 },
	0xE6A1, { 0xEF, 0xA6, 0x83 },
	0xE6A2, { 0xE6, 0xAD, 0x9F },
	0xE6A3, { 0xE6, 0xB1, 0x9D },
	0xE6A4, { 0xEF, 0xA6, 0x84 },
	0xE6A5, { 0xE7, 0x92, 0xB5 },
	0xE6A6, { 0xE7, 0xA4, 0x96 },
	0xE6A7, { 0xEF, 0xA6, 0x85 },
	0xE6A8, { 0xE8, 0x88, 0x87 },
	0xE6A9, { 0xE8, 0x89, 0x85 },
	0xE6AA, { 0xE8, 0x8C, 0xB9 },
	0xE6AB, { 0xE8, 0xBC, 0xBF },
	0xE6AC, { 0xE8, 0xBD, 0x9D },
	0xE6AD, { 0xEF, 0xA6, 0x86 },
	0xE6AE, { 0xE9, 0xA4, 0x98 },
	0xE6AF, { 0xEF, 0xA6, 0x87 },
	0xE6B0, { 0xEF, 0xA6, 0x88 },
	0xE6B1, { 0xEF, 0xA6, 0x89 },
	0xE6B2, { 0xE4, 0xBA, 0xA6 },
	0xE6B3, { 0xEF, 0xA6, 0x8A },
	0xE6B4, { 0xE5, 0x9F, 0x9F },
	0xE6B5, { 0xE5, 0xBD, 0xB9 },
	0xE6B6, { 0xE6, 0x98, 0x93 },
	0xE6B7, { 0xEF, 0xA6, 0x8B },
	0xE6B8, { 0xEF, 0xA6, 0x8C },
	0xE6B9, { 0xE7, 0x96, 0xAB },
	0xE6BA, { 0xE7, 0xB9, 0xB9 },
	0xE6BB, { 0xE8, 0xAD, 0xAF },
	0xE6BC, { 0xEF, 0xA6, 0x8D },
	0xE6BD, { 0xE9, 0x80, 0x86 },
	0xE6BE, { 0xE9, 0xA9, 0x9B },
	0xE6BF, { 0xE5, 0x9A, 0xA5 },
	0xE6C0, { 0xE5, 0xA0, 0xA7 },
	0xE6C1, { 0xE5, 0xA7, 0xB8 },
	0xE6C2, { 0xE5, 0xA8, 0x9F },
	0xE6C3, { 0xE5, 0xAE, 0xB4 },
	0xE6C4, { 0xEF, 0xA6, 0x8E },
	0xE6C5, { 0xE5, 0xBB, 0xB6 },
	0xE6C6, { 0xEF, 0xA6, 0x8F },
	0xE6C7, { 0xEF, 0xA6, 0x90 },
	0xE6C8, { 0xE6, 0x8D, 0x90 },
	0xE6C9, { 0xE6, 0x8C, 0xBB },
	0xE6CA, { 0xEF, 0xA6, 0x91 },
	0xE6CB, { 0xE6, 0xA4, 0xBD },
	0xE6CC, { 0xE6, 0xB2, 0x87 },
	0xE6CD, { 0xE6, 0xB2, 0xBF },
	0xE6CE, { 0xE6, 0xB6, 0x8E },
	0xE6CF, { 0xE6, 0xB6, 0x93 },
	0xE6D0, { 0xE6, 0xB7, 0xB5 },
	0xE6D1, { 0xE6, 0xBC, 0x94 },
	0xE6D2, { 0xEF, 0xA6, 0x92 },
	0xE6D3, { 0xE7, 0x83, 0x9F },
	0xE6D4, { 0xE7, 0x84, 0xB6 },
	0xE6D5, { 0xE7, 0x85, 0x99 },
	0xE6D6, { 0xEF, 0xA6, 0x93 },
	0xE6D7, { 0xE7, 0x87, 0x83 },
	0xE6D8, { 0xE7, 0x87, 0x95 },
	0xE6D9, { 0xEF, 0xA6, 0x94 },
	0xE6DA, { 0xE7, 0xA1, 0x8F },
	0xE6DB, { 0xE7, 0xA1, 0xAF },
	0xE6DC, { 0xEF, 0xA6, 0x95 },
	0xE6DD, { 0xE7, 0xAD, 0xB5 },
	0xE6DE, { 0xE7, 0xB7, 0xA3 },
	0xE6DF, { 0xEF, 0xA6, 0x96 },
	0xE6E0, { 0xE7, 0xB8, 0xAF },
	0xE6E1, { 0xEF, 0xA6, 0x97 },
	0xE6E2, { 0xE8, 0xA1, 0x8D },
	0xE6E3, { 0xE8, 0xBB, 0x9F },
	0xE6E4, { 0xEF, 0xA6, 0x98 },
	0xE6E5, { 0xEF, 0xA6, 0x99 },
	0xE6E6, { 0xEF, 0xA6, 0x9A },
	0xE6E7, { 0xE9, 0x89, 0x9B },
	0xE6E8, { 0xEF, 0xA6, 0x9B },
	0xE6E9, { 0xE9, 0xB3, 0xB6 },
	0xE6EA, { 0xEF, 0xA6, 0x9C },
	0xE6EB, { 0xEF, 0xA6, 0x9D },
	0xE6EC, { 0xEF, 0xA6, 0x9E },
	0xE6ED, { 0xE6, 0x82, 0x85 },
	0xE6EE, { 0xE6, 0xB6, 0x85 },
	0xE6EF, { 0xEF, 0xA6, 0x9F },
	0xE6F0, { 0xE7, 0x86, 0xB1 },
	0xE6F1, { 0xEF, 0xA6, 0xA0 },
	0xE6F2, { 0xEF, 0xA6, 0xA1 },
	0xE6F3, { 0xE9, 0x96, 0xB1 },
	0xE6F4, { 0xE5, 0x8E, 0xAD },
	0xE6F5, { 0xEF, 0xA6, 0xA2 },
	0xE6F6, { 0xEF, 0xA6, 0xA3 },
	0xE6F7, { 0xEF, 0xA6, 0xA4 },
	0xE6F8, { 0xE6, 0x9F, 0x93 },
	0xE6F9, { 0xEF, 0xA6, 0xA5 },
	0xE6FA, { 0xE7, 0x82, 0x8E },
	0xE6FB, { 0xE7, 0x84, 0xB0 },
	0xE6FC, { 0xE7, 0x90, 0xB0 },
	0xE6FD, { 0xE8, 0x89, 0xB6 },
	0xE6FE, { 0xE8, 0x8B, 0x92 },
	0xE7A1, { 0xEF, 0xA6, 0xA6 },
	0xE7A2, { 0xE9, 0x96, 0xBB },
	0xE7A3, { 0xE9, 0xAB, 0xA5 },
	0xE7A4, { 0xE9, 0xB9, 0xBD },
	0xE7A5, { 0xE6, 0x9B, 0x84 },
	0xE7A6, { 0xEF, 0xA6, 0xA7 },
	0xE7A7, { 0xE7, 0x87, 0x81 },
	0xE7A8, { 0xE8, 0x91, 0x89 },
	0xE7A9, { 0xEF, 0xA6, 0xA8 },
	0xE7AA, { 0xEF, 0xA6, 0xA9 },
	0xE7AB, { 0xE5, 0xA1, 0x8B },
	0xE7AC, { 0xEF, 0xA6, 0xAA },
	0xE7AD, { 0xEF, 0xA6, 0xAB },
	0xE7AE, { 0xE5, 0xB6, 0xB8 },
	0xE7AF, { 0xE5, 0xBD, 0xB1 },
	0xE7B0, { 0xEF, 0xA6, 0xAC },
	0xE7B1, { 0xE6, 0x98, 0xA0 },
	0xE7B2, { 0xE6, 0x9A, 0x8E },
	0xE7B3, { 0xE6, 0xA5, 0xB9 },
	0xE7B4, { 0xE6, 0xA6, 0xAE },
	0xE7B5, { 0xE6, 0xB0, 0xB8 },
	0xE7B6, { 0xE6, 0xB3, 0xB3 },
	0xE7B7, { 0xE6, 0xB8, 0xB6 },
	0xE7B8, { 0xE6, 0xBD, 0x81 },
	0xE7B9, { 0xE6, 0xBF, 0x9A },
	0xE7BA, { 0xE7, 0x80, 0x9B },
	0xE7BB, { 0xE7, 0x80, 0xAF },
	0xE7BC, { 0xE7, 0x85, 0x90 },
	0xE7BD, { 0xE7, 0x87, 0x9F },
	0xE7BE, { 0xE7, 0x8D, 0xB0 },
	0xE7BF, { 0xEF, 0xA6, 0xAD },
	0xE7C0, { 0xE7, 0x91, 0x9B },
	0xE7C1, { 0xEF, 0xA6, 0xAE },
	0xE7C2, { 0xE7, 0x93, 0x94 },
	0xE7C3, { 0xE7, 0x9B, 0x88 },
	0xE7C4, { 0xE7, 0xA9, 0x8E },
	0xE7C5, { 0xE7, 0xBA, 0x93 },
	0xE7C6, { 0xEF, 0xA6, 0xAF },
	0xE7C7, { 0xEF, 0xA6, 0xB0 },
	0xE7C8, { 0xE8, 0x8B, 0xB1 },
	0xE7C9, { 0xE8, 0xA9, 0xA0 },
	0xE7CA, { 0xE8, 0xBF, 0x8E },
	0xE7CB, { 0xEF, 0xA6, 0xB1 },
	0xE7CC, { 0xE9, 0x8D, 0x88 },
	0xE7CD, { 0xEF, 0xA6, 0xB2 },
	0xE7CE, { 0xE9, 0x9C, 0x99 },
	0xE7CF, { 0xEF, 0xA6, 0xB3 },
	0xE7D0, { 0xEF, 0xA6, 0xB4 },
	0xE7D1, { 0xE4, 0xB9, 0x82 },
	0xE7D2, { 0xE5, 0x80, 0xAA },
	0xE7D3, { 0xEF, 0xA6, 0xB5 },
	0xE7D4, { 0xE5, 0x88, 0x88 },
	0xE7D5, { 0xE5, 0x8F, 0xA1 },
	0xE7D6, { 0xE6, 0x9B, 0xB3 },
	0xE7D7, { 0xE6, 0xB1, 0xAD },
	0xE7D8, { 0xE6, 0xBF, 0x8A },
	0xE7D9, { 0xE7, 0x8C, 0x8A },
	0xE7DA, { 0xE7, 0x9D, 0xBF },
	0xE7DB, { 0xE7, 0xA9, 0xA2 },
	0xE7DC, { 0xE8, 0x8A, 0xAE },
	0xE7DD, { 0xE8, 0x97, 0x9D },
	0xE7DE, { 0xE8, 0x98, 0x82 },
	0xE7DF, { 0xEF, 0xA6, 0xB6 },
	0xE7E0, { 0xE8, 0xA3, 0x94 },
	0xE7E1, { 0xE8, 0xA9, 0xA3 },
	0xE7E2, { 0xE8, 0xAD, 0xBD },
	0xE7E3, { 0xE8, 0xB1, 0xAB },
	0xE7E4, { 0xEF, 0xA6, 0xB7 },
	0xE7E5, { 0xE9, 0x8A, 0xB3 },
	0xE7E6, { 0xEF, 0xA6, 0xB8 },
	0xE7E7, { 0xE9, 0x9C, 0x93 },
	0xE7E8, { 0xE9, 0xA0, 0x90 },
	0xE7E9, { 0xE4, 0xBA, 0x94 },
	0xE7EA, { 0xE4, 0xBC, 0x8D },
	0xE7EB, { 0xE4, 0xBF, 0x89 },
	0xE7EC, { 0xE5, 0x82, 0xB2 },
	0xE7ED, { 0xE5, 0x8D, 0x88 },
	0xE7EE, { 0xE5, 0x90, 0xBE },
	0xE7EF, { 0xE5, 0x90, 0xB3 },
	0xE7F0, { 0xE5, 0x97, 0x9A },
	0xE7F1, { 0xE5, 0xA1, 0xA2 },
	0xE7F2, { 0xE5, 0xA2, 0xBA },
	0xE7F3, { 0xE5, 0xA5, 0xA7 },
	0xE7F4, { 0xE5, 0xA8, 0x9B },
	0xE7F5, { 0xE5, 0xAF, 0xA4 },
	0xE7F6, { 0xE6, 0x82, 0x9F },
	0xE7F7, { 0xEF, 0xA6, 0xB9 },
	0xE7F8, { 0xE6, 0x87, 0x8A },
	0xE7F9, { 0xE6, 0x95, 0x96 },
	0xE7FA, { 0xE6, 0x97, 0xBF },
	0xE7FB, { 0xE6, 0x99, 0xA4 },
	0xE7FC, { 0xE6, 0xA2, 0xA7 },
	0xE7FD, { 0xE6, 0xB1, 0x9A },
	0xE7FE, { 0xE6, 0xBE, 0xB3 },
	0xE8A1, { 0xE7, 0x83, 0x8F },
	0xE8A2, { 0xE7, 0x86, 0xAC },
	0xE8A3, { 0xE7, 0x8D, 0x92 },
	0xE8A4, { 0xE7, 0xAD, 0xBD },
	0xE8A5, { 0xE8, 0x9C, 0x88 },
	0xE8A6, { 0xE8, 0xAA, 0xA4 },
	0xE8A7, { 0xE9, 0xB0, 0xB2 },
	0xE8A8, { 0xE9, 0xBC, 0x87 },
	0xE8A9, { 0xE5, 0xB1, 0x8B },
	0xE8AA, { 0xE6, 0xB2, 0x83 },
	0xE8AB, { 0xE7, 0x8D, 0x84 },
	0xE8AC, { 0xE7, 0x8E, 0x89 },
	0xE8AD, { 0xE9, 0x88, 0xBA },
	0xE8AE, { 0xE6, 0xBA, 0xAB },
	0xE8AF, { 0xE7, 0x91, 0xA5 },
	0xE8B0, { 0xE7, 0x98, 0x9F },
	0xE8B1, { 0xE7, 0xA9, 0xA9 },
	0xE8B2, { 0xE7, 0xB8, 0x95 },
	0xE8B3, { 0xE8, 0x98, 0x8A },
	0xE8B4, { 0xE5, 0x85, 0x80 },
	0xE8B5, { 0xE5, 0xA3, 0x85 },
	0xE8B6, { 0xE6, 0x93, 0x81 },
	0xE8B7, { 0xE7, 0x93, 0xAE },
	0xE8B8, { 0xE7, 0x94, 0x95 },
	0xE8B9, { 0xE7, 0x99, 0xB0 },
	0xE8BA, { 0xE7, 0xBF, 0x81 },
	0xE8BB, { 0xE9, 0x82, 0x95 },
	0xE8BC, { 0xE9, 0x9B, 0x8D },
	0xE8BD, { 0xE9, 0xA5, 0x94 },
	0xE8BE, { 0xE6, 0xB8, 0xA6 },
	0xE8BF, { 0xE7, 0x93, 0xA6 },
	0xE8C0, { 0xE7, 0xAA, 0xA9 },
	0xE8C1, { 0xE7, 0xAA, 0xAA },
	0xE8C2, { 0xE8, 0x87, 0xA5 },
	0xE8C3, { 0xE8, 0x9B, 0x99 },
	0xE8C4, { 0xE8, 0x9D, 0xB8 },
	0xE8C5, { 0xE8, 0xA8, 0x9B },
	0xE8C6, { 0xE5, 0xA9, 0x89 },
	0xE8C7, { 0xE5, 0xAE, 0x8C },
	0xE8C8, { 0xE5, 0xAE, 0x9B },
	0xE8C9, { 0xE6, 0xA2, 0xA1 },
	0xE8CA, { 0xE6, 0xA4, 0x80 },
	0xE8CB, { 0xE6, 0xB5, 0xA3 },
	0xE8CC, { 0xE7, 0x8E, 0xA9 },
	0xE8CD, { 0xE7, 0x90, 0x93 },
	0xE8CE, { 0xE7, 0x90, 0xAC },
	0xE8CF, { 0xE7, 0xA2, 0x97 },
	0xE8D0, { 0xE7, 0xB7, 0xA9 },
	0xE8D1, { 0xE7, 0xBF, 0xAB },
	0xE8D2, { 0xE8, 0x84, 0x98 },
	0xE8D3, { 0xE8, 0x85, 0x95 },
	0xE8D4, { 0xE8, 0x8E, 0x9E },
	0xE8D5, { 0xE8, 0xB1, 0x8C },
	0xE8D6, { 0xE9, 0x98, 0xAE },
	0xE8D7, { 0xE9, 0xA0, 0x91 },
	0xE8D8, { 0xE6, 0x9B, 0xB0 },
	0xE8D9, { 0xE5, 0xBE, 0x80 },
	0xE8DA, { 0xE6, 0x97, 0xBA },
	0xE8DB, { 0xE6, 0x9E, 0x89 },
	0xE8DC, { 0xE6, 0xB1, 0xAA },
	0xE8DD, { 0xE7, 0x8E, 0x8B },
	0xE8DE, { 0xE5, 0x80, 0xAD },
	0xE8DF, { 0xE5, 0xA8, 0x83 },
	0xE8E0, { 0xE6, 0xAD, 0xAA },
	0xE8E1, { 0xE7, 0x9F, 0xAE },
	0xE8E2, { 0xE5, 0xA4, 0x96 },
	0xE8E3, { 0xE5, 0xB5, 0xAC },
	0xE8E4, { 0xE5, 0xB7, 0x8D },
	0xE8E5, { 0xE7, 0x8C, 0xA5 },
	0xE8E6, { 0xE7, 0x95, 0x8F },
	0xE8E7, { 0xEF, 0xA6, 0xBA },
	0xE8E8, { 0xEF, 0xA6, 0xBB },
	0xE8E9, { 0xE5, 0x83, 0xA5 },
	0xE8EA, { 0xE5, 0x87, 0xB9 },
	0xE8EB, { 0xE5, 0xA0, 0xAF },
	0xE8EC, { 0xE5, 0xA4, 0xAD },
	0xE8ED, { 0xE5, 0xA6, 0x96 },
	0xE8EE, { 0xE5, 0xA7, 0x9A },
	0xE8EF, { 0xE5, 0xAF, 0xA5 },
	0xE8F0, { 0xEF, 0xA6, 0xBC },
	0xE8F1, { 0xEF, 0xA6, 0xBD },
	0xE8F2, { 0xE5, 0xB6, 0xA2 },
	0xE8F3, { 0xE6, 0x8B, 0x97 },
	0xE8F4, { 0xE6, 0x90, 0x96 },
	0xE8F5, { 0xE6, 0x92, 0x93 },
	0xE8F6, { 0xE6, 0x93, 0xBE },
	0xE8F7, { 0xEF, 0xA6, 0xBE },
	0xE8F8, { 0xE6, 0x9B, 0x9C },
	0xE8F9, { 0xEF, 0xA6, 0xBF },
	0xE8FA, { 0xE6, 0xA9, 0x88 },
	0xE8FB, { 0xEF, 0xA7, 0x80 },
	0xE8FC, { 0xE7, 0x87, 0xBF },
	0xE8FD, { 0xE7, 0x91, 0xA4 },
	0xE8FE, { 0xEF, 0xA7, 0x81 },
	0xE9A1, { 0xE7, 0xAA, 0x88 },
	0xE9A2, { 0xE7, 0xAA, 0xAF },
	0xE9A3, { 0xE7, 0xB9, 0x87 },
	0xE9A4, { 0xE7, 0xB9, 0x9E },
	0xE9A5, { 0xE8, 0x80, 0x80 },
	0xE9A6, { 0xE8, 0x85, 0xB0 },
	0xE9A7, { 0xEF, 0xA7, 0x82 },
	0xE9A8, { 0xE8, 0x9F, 0xAF },
	0xE9A9, { 0xE8, 0xA6, 0x81 },
	0xE9AA, { 0xE8, 0xAC, 0xA0 },
	0xE9AB, { 0xE9, 0x81, 0x99 },
	0xE9AC, { 0xEF, 0xA7, 0x83 },
	0xE9AD, { 0xE9, 0x82, 0x80 },
	0xE9AE, { 0xE9, 0xA5, 0x92 },
	0xE9AF, { 0xE6, 0x85, 0xBE },
	0xE9B0, { 0xE6, 0xAC, 0xB2 },
	0xE9B1, { 0xE6, 0xB5, 0xB4 },
	0xE9B2, { 0xE7, 0xB8, 0x9F },
	0xE9B3, { 0xE8, 0xA4, 0xA5 },
	0xE9B4, { 0xE8, 0xBE, 0xB1 },
	0xE9B5, { 0xE4, 0xBF, 0x91 },
	0xE9B6, { 0xE5, 0x82, 0xAD },
	0xE9B7, { 0xE5, 0x86, 0x97 },
	0xE9B8, { 0xE5, 0x8B, 0x87 },
	0xE9B9, { 0xE5, 0x9F, 0x87 },
	0xE9BA, { 0xE5, 0xA2, 0x89 },
	0xE9BB, { 0xE5, 0xAE, 0xB9 },
	0xE9BC, { 0xE5, 0xBA, 0xB8 },
	0xE9BD, { 0xE6, 0x85, 0x82 },
	0xE9BE, { 0xE6, 0xA6, 0x95 },
	0xE9BF, { 0xE6, 0xB6, 0x8C },
	0xE9C0, { 0xE6, 0xB9, 0xA7 },
	0xE9C1, { 0xE6, 0xBA, 0xB6 },
	0xE9C2, { 0xE7, 0x86, 0x94 },
	0xE9C3, { 0xE7, 0x91, 0xA2 },
	0xE9C4, { 0xE7, 0x94, 0xA8 },
	0xE9C5, { 0xE7, 0x94, 0xAC },
	0xE9C6, { 0xE8, 0x81, 0xB3 },
	0xE9C7, { 0xE8, 0x8C, 0xB8 },
	0xE9C8, { 0xE8, 0x93, 0x89 },
	0xE9C9, { 0xE8, 0xB8, 0x8A },
	0xE9CA, { 0xE9, 0x8E, 0x94 },
	0xE9CB, { 0xE9, 0x8F, 0x9E },
	0xE9CC, { 0xEF, 0xA7, 0x84 },
	0xE9CD, { 0xE4, 0xBA, 0x8E },
	0xE9CE, { 0xE4, 0xBD, 0x91 },
	0xE9CF, { 0xE5, 0x81, 0xB6 },
	0xE9D0, { 0xE5, 0x84, 0xAA },
	0xE9D1, { 0xE5, 0x8F, 0x88 },
	0xE9D2, { 0xE5, 0x8F, 0x8B },
	0xE9D3, { 0xE5, 0x8F, 0xB3 },
	0xE9D4, { 0xE5, 0xAE, 0x87 },
	0xE9D5, { 0xE5, 0xAF, 0x93 },
	0xE9D6, { 0xE5, 0xB0, 0xA4 },
	0xE9D7, { 0xE6, 0x84, 0x9A },
	0xE9D8, { 0xE6, 0x86, 0x82 },
	0xE9D9, { 0xE6, 0x97, 0xB4 },
	0xE9DA, { 0xE7, 0x89, 0x9B },
	0xE9DB, { 0xE7, 0x8E, 0x97 },
	0xE9DC, { 0xE7, 0x91, 0x80 },
	0xE9DD, { 0xE7, 0x9B, 0x82 },
	0xE9DE, { 0xE7, 0xA5, 0x90 },
	0xE9DF, { 0xE7, 0xA6, 0x91 },
	0xE9E0, { 0xE7, 0xA6, 0xB9 },
	0xE9E1, { 0xE7, 0xB4, 0x86 },
	0xE9E2, { 0xE7, 0xBE, 0xBD },
	0xE9E3, { 0xE8, 0x8A, 0x8B },
	0xE9E4, { 0xE8, 0x97, 0x95 },
	0xE9E5, { 0xE8, 0x99, 0x9E },
	0xE9E6, { 0xE8, 0xBF, 0x82 },
	0xE9E7, { 0xE9, 0x81, 0x87 },
	0xE9E8, { 0xE9, 0x83, 0xB5 },
	0xE9E9, { 0xE9, 0x87, 0xAA },
	0xE9EA, { 0xE9, 0x9A, 0x85 },
	0xE9EB, { 0xE9, 0x9B, 0xA8 },
	0xE9EC, { 0xE9, 0x9B, 0xA9 },
	0xE9ED, { 0xE5, 0x8B, 0x96 },
	0xE9EE, { 0xE5, 0xBD, 0xA7 },
	0xE9EF, { 0xE6, 0x97, 0xAD },
	0xE9F0, { 0xE6, 0x98, 0xB1 },
	0xE9F1, { 0xE6, 0xA0, 0xAF },
	0xE9F2, { 0xE7, 0x85, 0x9C },
	0xE9F3, { 0xE7, 0xA8, 0xB6 },
	0xE9F4, { 0xE9, 0x83, 0x81 },
	0xE9F5, { 0xE9, 0xA0, 0x8A },
	0xE9F6, { 0xE4, 0xBA, 0x91 },
	0xE9F7, { 0xEF, 0xA7, 0x85 },
	0xE9F8, { 0xE6, 0xA9, 0x92 },
	0xE9F9, { 0xE6, 0xAE, 0x9E },
	0xE9FA, { 0xE6, 0xBE, 0x90 },
	0xE9FB, { 0xE7, 0x86, 0x89 },
	0xE9FC, { 0xE8, 0x80, 0x98 },
	0xE9FD, { 0xE8, 0x8A, 0xB8 },
	0xE9FE, { 0xE8, 0x95, 0x93 },
	0xEAA1, { 0xE9, 0x81, 0x8B },
	0xEAA2, { 0xE9, 0x9A, 0x95 },
	0xEAA3, { 0xE9, 0x9B, 0xB2 },
	0xEAA4, { 0xE9, 0x9F, 0xBB },
	0xEAA5, { 0xE8, 0x94, 0x9A },
	0xEAA6, { 0xE9, 0xAC, 0xB1 },
	0xEAA7, { 0xE4, 0xBA, 0x90 },
	0xEAA8, { 0xE7, 0x86, 0x8A },
	0xEAA9, { 0xE9, 0x9B, 0x84 },
	0xEAAA, { 0xE5, 0x85, 0x83 },
	0xEAAB, { 0xE5, 0x8E, 0x9F },
	0xEAAC, { 0xE5, 0x93, 0xA1 },
	0xEAAD, { 0xE5, 0x9C, 0x93 },
	0xEAAE, { 0xE5, 0x9C, 0x92 },
	0xEAAF, { 0xE5, 0x9E, 0xA3 },
	0xEAB0, { 0xE5, 0xAA, 0x9B },
	0xEAB1, { 0xE5, 0xAB, 0x84 },
	0xEAB2, { 0xE5, 0xAF, 0x83 },
	0xEAB3, { 0xE6, 0x80, 0xA8 },
	0xEAB4, { 0xE6, 0x84, 0xBF },
	0xEAB5, { 0xE6, 0x8F, 0xB4 },
	0xEAB6, { 0xE6, 0xB2, 0x85 },
	0xEAB7, { 0xE6, 0xB4, 0xB9 },
	0xEAB8, { 0xE6, 0xB9, 0xB2 },
	0xEAB9, { 0xE6, 0xBA, 0x90 },
	0xEABA, { 0xE7, 0x88, 0xB0 },
	0xEABB, { 0xE7, 0x8C, 0xBF },
	0xEABC, { 0xE7, 0x91, 0x97 },
	0xEABD, { 0xE8, 0x8B, 0x91 },
	0xEABE, { 0xE8, 0xA2, 0x81 },
	0xEABF, { 0xE8, 0xBD, 0x85 },
	0xEAC0, { 0xE9, 0x81, 0xA0 },
	0xEAC1, { 0xEF, 0xA7, 0x86 },
	0xEAC2, { 0xE9, 0x99, 0xA2 },
	0xEAC3, { 0xE9, 0xA1, 0x98 },
	0xEAC4, { 0xE9, 0xB4, 0x9B },
	0xEAC5, { 0xE6, 0x9C, 0x88 },
	0xEAC6, { 0xE8, 0xB6, 0x8A },
	0xEAC7, { 0xE9, 0x89, 0x9E },
	0xEAC8, { 0xE4, 0xBD, 0x8D },
	0xEAC9, { 0xE5, 0x81, 0x89 },
	0xEACA, { 0xE5, 0x83, 0x9E },
	0xEACB, { 0xE5, 0x8D, 0xB1 },
	0xEACC, { 0xE5, 0x9C, 0x8D },
	0xEACD, { 0xE5, 0xA7, 0x94 },
	0xEACE, { 0xE5, 0xA8, 0x81 },
	0xEACF, { 0xE5, 0xB0, 0x89 },
	0xEAD0, { 0xE6, 0x85, 0xB0 },
	0xEAD1, { 0xE6, 0x9A, 0x90 },
	0xEAD2, { 0xE6, 0xB8, 0xAD },
	0xEAD3, { 0xE7, 0x88, 0xB2 },
	0xEAD4, { 0xE7, 0x91, 0x8B },
	0xEAD5, { 0xE7, 0xB7, 0xAF },
	0xEAD6, { 0xE8, 0x83, 0x83 },
	0xEAD7, { 0xE8, 0x90, 0x8E },
	0xEAD8, { 0xE8, 0x91, 0xA6 },
	0xEAD9, { 0xE8, 0x94, 0xBF },
	0xEADA, { 0xE8, 0x9D, 0x9F },
	0xEADB, { 0xE8, 0xA1, 0x9B },
	0xEADC, { 0xE8, 0xA4, 0x98 },
	0xEADD, { 0xE8, 0xAC, 0x82 },
	0xEADE, { 0xE9, 0x81, 0x95 },
	0xEADF, { 0xE9, 0x9F, 0x8B },
	0xEAE0, { 0xE9, 0xAD, 0x8F },
	0xEAE1, { 0xE4, 0xB9, 0xB3 },
	0xEAE2, { 0xE4, 0xBE, 0x91 },
	0xEAE3, { 0xE5, 0x84, 0x92 },
	0xEAE4, { 0xE5, 0x85, 0xAA },
	0xEAE5, { 0xEF, 0xA7, 0x87 },
	0xEAE6, { 0xE5, 0x94, 0xAF },
	0xEAE7, { 0xE5, 0x96, 0xA9 },
	0xEAE8, { 0xE5, 0xAD, 0xBA },
	0xEAE9, { 0xE5, 0xAE, 0xA5 },
	0xEAEA, { 0xE5, 0xB9, 0xBC },
	0xEAEB, { 0xE5, 0xB9, 0xBD },
	0xEAEC, { 0xE5, 0xBA, 0xBE },
	0xEAED, { 0xE6, 0x82, 0xA0 },
	0xEAEE, { 0xE6, 0x83, 0x9F },
	0xEAEF, { 0xE6, 0x84, 0x88 },
	0xEAF0, { 0xE6, 0x84, 0x89 },
	0xEAF1, { 0xE6, 0x8F, 0x84 },
	0xEAF2, { 0xE6, 0x94, 0xB8 },
	0xEAF3, { 0xE6, 0x9C, 0x89 },
	0xEAF4, { 0xEF, 0xA7, 0x88 },
	0xEAF5, { 0xE6, 0x9F, 0x94 },
	0xEAF6, { 0xE6, 0x9F, 0x9A },
	0xEAF7, { 0xEF, 0xA7, 0x89 },
	0xEAF8, { 0xE6, 0xA5, 0xA1 },
	0xEAF9, { 0xE6, 0xA5, 0xA2 },
	0xEAFA, { 0xE6, 0xB2, 0xB9 },
	0xEAFB, { 0xE6, 0xB4, 0xA7 },
	0xEAFC, { 0xEF, 0xA7, 0x8A },
	0xEAFD, { 0xE6, 0xB8, 0xB8 },
	0xEAFE, { 0xEF, 0xA7, 0x8B },
	0xEBA1, { 0xE6, 0xBF, 0xA1 },
	0xEBA2, { 0xE7, 0x8C, 0xB6 },
	0xEBA3, { 0xE7, 0x8C, 0xB7 },
	0xEBA4, { 0xEF, 0xA7, 0x8C },
	0xEBA5, { 0xE7, 0x91, 0x9C },
	0xEBA6, { 0xE7, 0x94, 0xB1 },
	0xEBA7, { 0xEF, 0xA7, 0x8D },
	0xEBA8, { 0xE7, 0x99, 0x92 },
	0xEBA9, { 0xEF, 0xA7, 0x8E },
	0xEBAA, { 0xEF, 0xA7, 0x8F },
	0xEBAB, { 0xE7, 0xB6, 0xAD },
	0xEBAC, { 0xE8, 0x87, 0xBE },
	0xEBAD, { 0xE8, 0x90, 0xB8 },
	0xEBAE, { 0xE8, 0xA3, 0x95 },
	0xEBAF, { 0xE8, 0xAA, 0x98 },
	0xEBB0, { 0xE8, 0xAB, 0x9B },
	0xEBB1, { 0xE8, 0xAB, 0xAD },
	0xEBB2, { 0xE8, 0xB8, 0xB0 },
	0xEBB3, { 0xE8, 0xB9, 0x82 },
	0xEBB4, { 0xE9, 0x81, 0x8A },
	0xEBB5, { 0xE9, 0x80, 0xBE },
	0xEBB6, { 0xE9, 0x81, 0xBA },
	0xEBB7, { 0xE9, 0x85, 0x89 },
	0xEBB8, { 0xE9, 0x87, 0x89 },
	0xEBB9, { 0xE9, 0x8D, 0xAE },
	0xEBBA, { 0xEF, 0xA7, 0x90 },
	0xEBBB, { 0xEF, 0xA7, 0x91 },
	0xEBBC, { 0xE5, 0xA0, 0x89 },
	0xEBBD, { 0xEF, 0xA7, 0x92 },
	0xEBBE, { 0xE6, 0xAF, 0x93 },
	0xEBBF, { 0xE8, 0x82, 0x89 },
	0xEBC0, { 0xE8, 0x82, 0xB2 },
	0xEBC1, { 0xEF, 0xA7, 0x93 },
	0xEBC2, { 0xEF, 0xA7, 0x94 },
	0xEBC3, { 0xE5, 0x85, 0x81 },
	0xEBC4, { 0xE5, 0xA5, 0xAB },
	0xEBC5, { 0xE5, 0xB0, 0xB9 },
	0xEBC6, { 0xEF, 0xA7, 0x95 },
	0xEBC7, { 0xEF, 0xA7, 0x96 },
	0xEBC8, { 0xE6, 0xBD, 0xA4 },
	0xEBC9, { 0xE7, 0x8E, 0xA7 },
	0xEBCA, { 0xE8, 0x83, 0xA4 },
	0xEBCB, { 0xE8, 0xB4, 0x87 },
	0xEBCC, { 0xEF, 0xA7, 0x97 },
	0xEBCD, { 0xE9, 0x88, 0x97 },
	0xEBCE, { 0xE9, 0x96, 0x8F },
	0xEBCF, { 0xEF, 0xA7, 0x98 },
	0xEBD0, { 0xEF, 0xA7, 0x99 },
	0xEBD1, { 0xEF, 0xA7, 0x9A },
	0xEBD2, { 0xEF, 0xA7, 0x9B },
	0xEBD3, { 0xE8, 0x81, 0xBF },
	0xEBD4, { 0xE6, 0x88, 0x8E },
	0xEBD5, { 0xE7, 0x80, 0x9C },
	0xEBD6, { 0xE7, 0xB5, 0xA8 },
	0xEBD7, { 0xE8, 0x9E, 0x8D },
	0xEBD8, { 0xEF, 0xA7, 0x9C },
	0xEBD9, { 0xE5, 0x9E, 0xA0 },
	0xEBDA, { 0xE6, 0x81, 0xA9 },
	0xEBDB, { 0xE6, 0x85, 0x87 },
	0xEBDC, { 0xE6, 0xAE, 0xB7 },
	0xEBDD, { 0xE8, 0xAA, 0xBE },
	0xEBDE, { 0xE9, 0x8A, 0x80 },
	0xEBDF, { 0xE9, 0x9A, 0xB1 },
	0xEBE0, { 0xE4, 0xB9, 0x99 },
	0xEBE1, { 0xE5, 0x90, 0x9F },
	0xEBE2, { 0xE6, 0xB7, 0xAB },
	0xEBE3, { 0xE8, 0x94, 0xAD },
	0xEBE4, { 0xE9, 0x99, 0xB0 },
	0xEBE5, { 0xE9, 0x9F, 0xB3 },
	0xEBE6, { 0xE9, 0xA3, 0xAE },
	0xEBE7, { 0xE6, 0x8F, 0x96 },
	0xEBE8, { 0xE6, 0xB3, 0xA3 },
	0xEBE9, { 0xE9, 0x82, 0x91 },
	0xEBEA, { 0xE5, 0x87, 0x9D },
	0xEBEB, { 0xE6, 0x87, 0x89 },
	0xEBEC, { 0xE8, 0x86, 0xBA },
	0xEBED, { 0xE9, 0xB7, 0xB9 },
	0xEBEE, { 0xE4, 0xBE, 0x9D },
	0xEBEF, { 0xE5, 0x80, 0x9A },
	0xEBF0, { 0xE5, 0x84, 0x80 },
	0xEBF1, { 0xE5, 0xAE, 0x9C },
	0xEBF2, { 0xE6, 0x84, 0x8F },
	0xEBF3, { 0xE6, 0x87, 0xBF },
	0xEBF4, { 0xE6, 0x93, 0xAC },
	0xEBF5, { 0xE6, 0xA4, 0x85 },
	0xEBF6, { 0xE6, 0xAF, 0x85 },
	0xEBF7, { 0xE7, 0x96, 0x91 },
	0xEBF8, { 0xE7, 0x9F, 0xA3 },
	0xEBF9, { 0xE7, 0xBE, 0xA9 },
	0xEBFA, { 0xE8, 0x89, 0xA4 },
	0xEBFB, { 0xE8, 0x96, 0x8F },
	0xEBFC, { 0xE8, 0x9F, 0xBB },
	0xEBFD, { 0xE8, 0xA1, 0xA3 },
	0xEBFE, { 0xE8, 0xAA, 0xBC },
	0xECA1, { 0xE8, 0xAD, 0xB0 },
	0xECA2, { 0xE9, 0x86, 0xAB },
	0xECA3, { 0xE4, 0xBA, 0x8C },
	0xECA4, { 0xE4, 0xBB, 0xA5 },
	0xECA5, { 0xE4, 0xBC, 0x8A },
	0xECA6, { 0xEF, 0xA7, 0x9D },
	0xECA7, { 0xEF, 0xA7, 0x9E },
	0xECA8, { 0xE5, 0xA4, 0xB7 },
	0xECA9, { 0xE5, 0xA7, 0xA8 },
	0xECAA, { 0xEF, 0xA7, 0x9F },
	0xECAB, { 0xE5, 0xB7, 0xB2 },
	0xECAC, { 0xE5, 0xBC, 0x9B },
	0xECAD, { 0xE5, 0xBD, 0x9B },
	0xECAE, { 0xE6, 0x80, 0xA1 },
	0xECAF, { 0xEF, 0xA7, 0xA0 },
	0xECB0, { 0xEF, 0xA7, 0xA1 },
	0xECB1, { 0xEF, 0xA7, 0xA2 },
	0xECB2, { 0xEF, 0xA7, 0xA3 },
	0xECB3, { 0xE7, 0x88, 0xBE },
	0xECB4, { 0xE7, 0x8F, 0xA5 },
	0xECB5, { 0xEF, 0xA7, 0xA4 },
	0xECB6, { 0xE7, 0x95, 0xB0 },
	0xECB7, { 0xE7, 0x97, 0x8D },
	0xECB8, { 0xEF, 0xA7, 0xA5 },
	0xECB9, { 0xE7, 0xA7, 0xBB },
	0xECBA, { 0xEF, 0xA7, 0xA6 },
	0xECBB, { 0xE8, 0x80, 0x8C },
	0xECBC, { 0xE8, 0x80, 0xB3 },
	0xECBD, { 0xE8, 0x82, 0x84 },
	0xECBE, { 0xE8, 0x8B, 0xA1 },
	0xECBF, { 0xE8, 0x8D, 0x91 },
	0xECC0, { 0xEF, 0xA7, 0xA7 },
	0xECC1, { 0xEF, 0xA7, 0xA8 },
	0xECC2, { 0xE8, 0xB2, 0xBD },
	0xECC3, { 0xE8, 0xB2, 0xB3 },
	0xECC4, { 0xE9, 0x82, 0x87 },
	0xECC5, { 0xEF, 0xA7, 0xA9 },
	0xECC6, { 0xEF, 0xA7, 0xAA },
	0xECC7, { 0xE9, 0xA3, 0xB4 },
	0xECC8, { 0xE9, 0xA4, 0x8C },
	0xECC9, { 0xEF, 0xA7, 0xAB },
	0xECCA, { 0xEF, 0xA7, 0xAC },
	0xECCB, { 0xE7, 0x80, 0xB7 },
	0xECCC, { 0xE7, 0x9B, 0x8A },
	0xECCD, { 0xE7, 0xBF, 0x8A },
	0xECCE, { 0xE7, 0xBF, 0x8C },
	0xECCF, { 0xE7, 0xBF, 0xBC },
	0xECD0, { 0xE8, 0xAC, 0x9A },
	0xECD1, { 0xE4, 0xBA, 0xBA },
	0xECD2, { 0xE4, 0xBB, 0x81 },
	0xECD3, { 0xE5, 0x88, 0x83 },
	0xECD4, { 0xE5, 0x8D, 0xB0 },
	0xECD5, { 0xEF, 0xA7, 0xAD },
	0xECD6, { 0xE5, 0x92, 0xBD },
	0xECD7, { 0xE5, 0x9B, 0xA0 },
	0xECD8, { 0xE5, 0xA7, 0xBB },
	0xECD9, { 0xE5, 0xAF, 0x85 },
	0xECDA, { 0xE5, 0xBC, 0x95 },
	0xECDB, { 0xE5, 0xBF, 0x8D },
	0xECDC, { 0xE6, 0xB9, 0xAE },
	0xECDD, { 0xEF, 0xA7, 0xAE },
	0xECDE, { 0xEF, 0xA7, 0xAF },
	0xECDF, { 0xE7, 0xB5, 0xAA },
	0xECE0, { 0xE8, 0x8C, 0xB5 },
	0xECE1, { 0xEF, 0xA7, 0xB0 },
	0xECE2, { 0xE8, 0x9A, 0x93 },
	0xECE3, { 0xE8, 0xAA, 0x8D },
	0xECE4, { 0xEF, 0xA7, 0xB1 },
	0xECE5, { 0xE9, 0x9D, 0xAD },
	0xECE6, { 0xE9, 0x9D, 0xB7 },
	0xECE7, { 0xEF, 0xA7, 0xB2 },
	0xECE8, { 0xEF, 0xA7, 0xB3 },
	0xECE9, { 0xE4, 0xB8, 0x80 },
	0xECEA, { 0xE4, 0xBD, 0x9A },
	0xECEB, { 0xE4, 0xBD, 0xBE },
	0xECEC, { 0xE5, 0xA3, 0xB9 },
	0xECED, { 0xE6, 0x97, 0xA5 },
	0xECEE, { 0xE6, 0xBA, 0xA2 },
	0xECEF, { 0xE9, 0x80, 0xB8 },
	0xECF0, { 0xE9, 0x8E, 0xB0 },
	0xECF1, { 0xE9, 0xA6, 0xB9 },
	0xECF2, { 0xE4, 0xBB, 0xBB },
	0xECF3, { 0xE5, 0xA3, 0xAC },
	0xECF4, { 0xE5, 0xA6, 0x8A },
	0xECF5, { 0xE5, 0xA7, 0x99 },
	0xECF6, { 0xE6, 0x81, 0x81 },
	0xECF7, { 0xEF, 0xA7, 0xB4 },
	0xECF8, { 0xEF, 0xA7, 0xB5 },
	0xECF9, { 0xE7, 0xA8, 0x94 },
	0xECFA, { 0xEF, 0xA7, 0xB6 },
	0xECFB, { 0xE8, 0x8D, 0x8F },
	0xECFC, { 0xE8, 0xB3, 0x83 },
	0xECFD, { 0xE5, 0x85, 0xA5 },
	0xECFE, { 0xE5, 0x8D, 0x84 },
	0xEDA1, { 0xEF, 0xA7, 0xB7 },
	0xEDA2, { 0xEF, 0xA7, 0xB8 },
	0xEDA3, { 0xEF, 0xA7, 0xB9 },
	0xEDA4, { 0xE4, 0xBB, 0x8D },
	0xEDA5, { 0xE5, 0x89, 0xA9 },
	0xEDA6, { 0xE5, 0xAD, 0x95 },
	0xEDA7, { 0xE8, 0x8A, 0xBF },
	0xEDA8, { 0xE4, 0xBB, 0x94 },
	0xEDA9, { 0xE5, 0x88, 0xBA },
	0xEDAA, { 0xE5, 0x92, 0xA8 },
	0xEDAB, { 0xE5, 0xA7, 0x89 },
	0xEDAC, { 0xE5, 0xA7, 0xBF },
	0xEDAD, { 0xE5, 0xAD, 0x90 },
	0xEDAE, { 0xE5, 0xAD, 0x97 },
	0xEDAF, { 0xE5, 0xAD, 0x9C },
	0xEDB0, { 0xE6, 0x81, 0xA3 },
	0xEDB1, { 0xE6, 0x85, 0x88 },
	0xEDB2, { 0xE6, 0xBB, 0x8B },
	0xEDB3, { 0xE7, 0x82, 0x99 },
	0xEDB4, { 0xE7, 0x85, 0xAE },
	0xEDB5, { 0xE7, 0x8E, 0x86 },
	0xEDB6, { 0xE7, 0x93, 0xB7 },
	0xEDB7, { 0xE7, 0x96, 0xB5 },
	0xEDB8, { 0xE7, 0xA3, 0x81 },
	0xEDB9, { 0xE7, 0xB4, 0xAB },
	0xEDBA, { 0xE8, 0x80, 0x85 },
	0xEDBB, { 0xE8, 0x87, 0xAA },
	0xEDBC, { 0xE8, 0x8C, 0xA8 },
	0xEDBD, { 0xE8, 0x94, 0x97 },
	0xEDBE, { 0xE8, 0x97, 0x89 },
	0xEDBF, { 0xE8, 0xAB, 0xAE },
	0xEDC0, { 0xE8, 0xB3, 0x87 },
	0xEDC1, { 0xE9, 0x9B, 0x8C },
	0xEDC2, { 0xE4, 0xBD, 0x9C },
	0xEDC3, { 0xE5, 0x8B, 0xBA },
	0xEDC4, { 0xE5, 0x9A, 0xBC },
	0xEDC5, { 0xE6, 0x96, 0xAB },
	0xEDC6, { 0xE6, 0x98, 0xA8 },
	0xEDC7, { 0xE7, 0x81, 0xBC },
	0xEDC8, { 0xE7, 0x82, 0xB8 },
	0xEDC9, { 0xE7, 0x88, 0xB5 },
	0xEDCA, { 0xE7, 0xB6, 0xBD },
	0xEDCB, { 0xE8, 0x8A, 0x8D },
	0xEDCC, { 0xE9, 0x85, 0x8C },
	0xEDCD, { 0xE9, 0x9B, 0x80 },
	0xEDCE, { 0xE9, 0xB5, 0xB2 },
	0xEDCF, { 0xE5, 0xAD, 0xB1 },
	0xEDD0, { 0xE6, 0xA3, 0xA7 },
	0xEDD1, { 0xE6, 0xAE, 0x98 },
	0xEDD2, { 0xE6, 0xBD, 0xBA },
	0xEDD3, { 0xE7, 0x9B, 0x9E },
	0xEDD4, { 0xE5, 0xB2, 0x91 },
	0xEDD5, { 0xE6, 0x9A, 0xAB },
	0xEDD6, { 0xE6, 0xBD, 0x9B },
	0xEDD7, { 0xE7, 0xAE, 0xB4 },
	0xEDD8, { 0xE7, 0xB0, 0xAA },
	0xEDD9, { 0xE8, 0xA0, 0xB6 },
	0xEDDA, { 0xE9, 0x9B, 0x9C },
	0xEDDB, { 0xE4, 0xB8, 0x88 },
	0xEDDC, { 0xE4, 0xBB, 0x97 },
	0xEDDD, { 0xE5, 0x8C, 0xA0 },
	0xEDDE, { 0xE5, 0xA0, 0xB4 },
	0xEDDF, { 0xE5, 0xA2, 0xBB },
	0xEDE0, { 0xE5, 0xA3, 0xAF },
	0xEDE1, { 0xE5, 0xA5, 0xAC },
	0xEDE2, { 0xE5, 0xB0, 0x87 },
	0xEDE3, { 0xE5, 0xB8, 0xB3 },
	0xEDE4, { 0xE5, 0xBA, 0x84 },
	0xEDE5, { 0xE5, 0xBC, 0xB5 },
	0xEDE6, { 0xE6, 0x8E, 0x8C },
	0xEDE7, { 0xE6, 0x9A, 0xB2 },
	0xEDE8, { 0xE6, 0x9D, 0x96 },
	0xEDE9, { 0xE6, 0xA8, 0x9F },
	0xEDEA, { 0xE6, 0xAA, 0xA3 },
	0xEDEB, { 0xE6, 0xAC, 0x8C },
	0xEDEC, { 0xE6, 0xBC, 0xBF },
	0xEDED, { 0xE7, 0x89, 0x86 },
	0xEDEE, { 0xEF, 0xA7, 0xBA },
	0xEDEF, { 0xE7, 0x8D, 0x90 },
	0xEDF0, { 0xE7, 0x92, 0x8B },
	0xEDF1, { 0xE7, 0xAB, 0xA0 },
	0xEDF2, { 0xE7, 0xB2, 0xA7 },
	0xEDF3, { 0xE8, 0x85, 0xB8 },
	0xEDF4, { 0xE8, 0x87, 0x9F },
	0xEDF5, { 0xE8, 0x87, 0xA7 },
	0xEDF6, { 0xE8, 0x8E, 0x8A },
	0xEDF7, { 0xE8, 0x91, 0xAC },
	0xEDF8, { 0xE8, 0x94, 0xA3 },
	0xEDF9, { 0xE8, 0x96, 0x94 },
	0xEDFA, { 0xE8, 0x97, 0x8F },
	0xEDFB, { 0xE8, 0xA3, 0x9D },
	0xEDFC, { 0xE8, 0xB4, 0x93 },
	0xEDFD, { 0xE9, 0x86, 0xAC },
	0xEDFE, { 0xE9, 0x95, 0xB7 },
	0xEEA1, { 0xE9, 0x9A, 0x9C },
	0xEEA2, { 0xE5, 0x86, 0x8D },
	0xEEA3, { 0xE5, 0x93, 0x89 },
	0xEEA4, { 0xE5, 0x9C, 0xA8 },
	0xEEA5, { 0xE5, 0xAE, 0xB0 },
	0xEEA6, { 0xE6, 0x89, 0x8D },
	0xEEA7, { 0xE6, 0x9D, 0x90 },
	0xEEA8, { 0xE6, 0xA0, 0xBD },
	0xEEA9, { 0xE6, 0xA2, 0x93 },
	0xEEAA, { 0xE6, 0xB8, 0xBD },
	0xEEAB, { 0xE6, 0xBB, 0x93 },
	0xEEAC, { 0xE7, 0x81, 0xBD },
	0xEEAD, { 0xE7, 0xB8, 0xA1 },
	0xEEAE, { 0xE8, 0xA3, 0x81 },
	0xEEAF, { 0xE8, 0xB2, 0xA1 },
	0xEEB0, { 0xE8, 0xBC, 0x89 },
	0xEEB1, { 0xE9, 0xBD, 0x8B },
	0xEEB2, { 0xE9, 0xBD, 0x8E },
	0xEEB3, { 0xE7, 0x88, 0xAD },
	0xEEB4, { 0xE7, 0xAE, 0x8F },
	0xEEB5, { 0xE8, 0xAB, 0x8D },
	0xEEB6, { 0xE9, 0x8C, 0x9A },
	0xEEB7, { 0xE4, 0xBD, 0x87 },
	0xEEB8, { 0xE4, 0xBD, 0x8E },
	0xEEB9, { 0xE5, 0x84, 0xB2 },
	0xEEBA, { 0xE5, 0x92, 0x80 },
	0xEEBB, { 0xE5, 0xA7, 0x90 },
	0xEEBC, { 0xE5, 0xBA, 0x95 },
	0xEEBD, { 0xE6, 0x8A, 0xB5 },
	0xEEBE, { 0xE6, 0x9D, 0xB5 },
	0xEEBF, { 0xE6, 0xA5, 0xAE },
	0xEEC0, { 0xE6, 0xA8, 0x97 },
	0xEEC1, { 0xE6, 0xB2, 0xAE },
	0xEEC2, { 0xE6, 0xB8, 0x9A },
	0xEEC3, { 0xE7, 0x8B, 0x99 },
	0xEEC4, { 0xE7, 0x8C, 0xAA },
	0xEEC5, { 0xE7, 0x96, 0xBD },
	0xEEC6, { 0xE7, 0xAE, 0xB8 },
	0xEEC7, { 0xE7, 0xB4, 0xB5 },
	0xEEC8, { 0xE8, 0x8B, 0xA7 },
	0xEEC9, { 0xE8, 0x8F, 0xB9 },
	0xEECA, { 0xE8, 0x91, 0x97 },
	0xEECB, { 0xE8, 0x97, 0xB7 },
	0xEECC, { 0xE8, 0xA9, 0x9B },
	0xEECD, { 0xE8, 0xB2, 0xAF },
	0xEECE, { 0xE8, 0xBA, 0x87 },
	0xEECF, { 0xE9, 0x80, 0x99 },
	0xEED0, { 0xE9, 0x82, 0xB8 },
	0xEED1, { 0xE9, 0x9B, 0x8E },
	0xEED2, { 0xE9, 0xBD, 0x9F },
	0xEED3, { 0xE5, 0x8B, 0xA3 },
	0xEED4, { 0xE5, 0x90, 0x8A },
	0xEED5, { 0xE5, 0xAB, 0xA1 },
	0xEED6, { 0xE5, 0xAF, 0x82 },
	0xEED7, { 0xE6, 0x91, 0x98 },
	0xEED8, { 0xE6, 0x95, 0xB5 },
	0xEED9, { 0xE6, 0xBB, 0xB4 },
	0xEEDA, { 0xE7, 0x8B, 0x84 },
	0xEEDB, { 0xEF, 0xA7, 0xBB },
	0xEEDC, { 0xE7, 0x9A, 0x84 },
	0xEEDD, { 0xE7, 0xA9, 0x8D },
	0xEEDE, { 0xE7, 0xAC, 0x9B },
	0xEEDF, { 0xE7, 0xB1, 0x8D },
	0xEEE0, { 0xE7, 0xB8, 0xBE },
	0xEEE1, { 0xE7, 0xBF, 0x9F },
	0xEEE2, { 0xE8, 0x8D, 0xBB },
	0xEEE3, { 0xE8, 0xAC, 0xAB },
	0xEEE4, { 0xE8, 0xB3, 0x8A },
	0xEEE5, { 0xE8, 0xB5, 0xA4 },
	0xEEE6, { 0xE8, 0xB7, 0xA1 },
	0xEEE7, { 0xE8, 0xB9, 0x9F },
	0xEEE8, { 0xE8, 0xBF, 0xAA },
	0xEEE9, { 0xE8, 0xBF, 0xB9 },
	0xEEEA, { 0xE9, 0x81, 0xA9 },
	0xEEEB, { 0xE9, 0x8F, 0x91 },
	0xEEEC, { 0xE4, 0xBD, 0x83 },
	0xEEED, { 0xE4, 0xBD, 0xBA },
	0xEEEE, { 0xE5, 0x82, 0xB3 },
	0xEEEF, { 0xE5, 0x85, 0xA8 },
	0xEEF0, { 0xE5, 0x85, 0xB8 },
	0xEEF1, { 0xE5, 0x89, 0x8D },
	0xEEF2, { 0xE5, 0x89, 0xAA },
	0xEEF3, { 0xE5, 0xA1, 0xA1 },
	0xEEF4, { 0xE5, 0xA1, 0xBC },
	0xEEF5, { 0xE5, 0xA5, 0xA0 },
	0xEEF6, { 0xE5, 0xB0, 0x88 },
	0xEEF7, { 0xE5, 0xB1, 0x95 },
	0xEEF8, { 0xE5, 0xBB, 0x9B },
	0xEEF9, { 0xE6, 0x82, 0x9B },
	0xEEFA, { 0xE6, 0x88, 0xB0 },
	0xEEFB, { 0xE6, 0xA0, 0x93 },
	0xEEFC, { 0xE6, 0xAE, 0xBF },
	0xEEFD, { 0xE6, 0xB0, 0x88 },
	0xEEFE, { 0xE6, 0xBE, 0xB1 },
	0xEFA1, { 0xE7, 0x85, 0x8E },
	0xEFA2, { 0xE7, 0x90, 0xA0 },
	0xEFA3, { 0xE7, 0x94, 0xB0 },
	0xEFA4, { 0xE7, 0x94, 0xB8 },
	0xEFA5, { 0xE7, 0x95, 0x91 },
	0xEFA6, { 0xE7, 0x99, 0xB2 },
	0xEFA7, { 0xE7, 0xAD, 0x8C },
	0xEFA8, { 0xE7, 0xAE, 0x8B },
	0xEFA9, { 0xE7, 0xAE, 0xAD },
	0xEFAA, { 0xE7, 0xAF, 0x86 },
	0xEFAB, { 0xE7, 0xBA, 0x8F },
	0xEFAC, { 0xE8, 0xA9, 0xAE },
	0xEFAD, { 0xE8, 0xBC, 0xBE },
	0xEFAE, { 0xE8, 0xBD, 0x89 },
	0xEFAF, { 0xE9, 0x88, 0xBF },
	0xEFB0, { 0xE9, 0x8A, 0x93 },
	0xEFB1, { 0xE9, 0x8C, 0xA2 },
	0xEFB2, { 0xE9, 0x90, 0xAB },
	0xEFB3, { 0xE9, 0x9B, 0xBB },
	0xEFB4, { 0xE9, 0xA1, 0x9A },
	0xEFB5, { 0xE9, 0xA1, 0xAB },
	0xEFB6, { 0xE9, 0xA4, 0x9E },
	0xEFB7, { 0xE5, 0x88, 0x87 },
	0xEFB8, { 0xE6, 0x88, 0xAA },
	0xEFB9, { 0xE6, 0x8A, 0x98 },
	0xEFBA, { 0xE6, 0xB5, 0x99 },
	0xEFBB, { 0xE7, 0x99, 0xA4 },
	0xEFBC, { 0xE7, 0xAB, 0x8A },
	0xEFBD, { 0xE7, 0xAF, 0x80 },
	0xEFBE, { 0xE7, 0xB5, 0xB6 },
	0xEFBF, { 0xE5, 0x8D, 0xA0 },
	0xEFC0, { 0xE5, 0xB2, 0xBE },
	0xEFC1, { 0xE5, 0xBA, 0x97 },
	0xEFC2, { 0xE6, 0xBC, 0xB8 },
	0xEFC3, { 0xE7, 0x82, 0xB9 },
	0xEFC4, { 0xE7, 0xB2, 0x98 },
	0xEFC5, { 0xE9, 0x9C, 0x91 },
	0xEFC6, { 0xE9, 0xAE, 0x8E },
	0xEFC7, { 0xE9, 0xBB, 0x9E },
	0xEFC8, { 0xE6, 0x8E, 0xA5 },
	0xEFC9, { 0xE6, 0x91, 0xBA },
	0xEFCA, { 0xE8, 0x9D, 0xB6 },
	0xEFCB, { 0xE4, 0xB8, 0x81 },
	0xEFCC, { 0xE4, 0xBA, 0x95 },
	0xEFCD, { 0xE4, 0xBA, 0xAD },
	0xEFCE, { 0xE5, 0x81, 0x9C },
	0xEFCF, { 0xE5, 0x81, 0xB5 },
	0xEFD0, { 0xE5, 0x91, 0x88 },
	0xEFD1, { 0xE5, 0xA7, 0x83 },
	0xEFD2, { 0xE5, 0xAE, 0x9A },
	0xEFD3, { 0xE5, 0xB9, 0x80 },
	0xEFD4, { 0xE5, 0xBA, 0xAD },
	0xEFD5, { 0xE5, 0xBB, 0xB7 },
	0xEFD6, { 0xE5, 0xBE, 0x81 },
	0xEFD7, { 0xE6, 0x83, 0x85 },
	0xEFD8, { 0xE6, 0x8C, 0xBA },
	0xEFD9, { 0xE6, 0x94, 0xBF },
	0xEFDA, { 0xE6, 0x95, 0xB4 },
	0xEFDB, { 0xE6, 0x97, 0x8C },
	0xEFDC, { 0xE6, 0x99, 0xB6 },
	0xEFDD, { 0xE6, 0x99, 0xB8 },
	0xEFDE, { 0xE6, 0x9F, 0xBE },
	0xEFDF, { 0xE6, 0xA5, 0xA8 },
	0xEFE0, { 0xE6, 0xAA, 0x89 },
	0xEFE1, { 0xE6, 0xAD, 0xA3 },
	0xEFE2, { 0xE6, 0xB1, 0x80 },
	0xEFE3, { 0xE6, 0xB7, 0x80 },
	0xEFE4, { 0xE6, 0xB7, 0xA8 },
	0xEFE5, { 0xE6, 0xB8, 0x9F },
	0xEFE6, { 0xE6, 0xB9, 0x9E },
	0xEFE7, { 0xE7, 0x80, 0x9E },
	0xEFE8, { 0xE7, 0x82, 0xA1 },
	0xEFE9, { 0xE7, 0x8E, 0x8E },
	0xEFEA, { 0xE7, 0x8F, 0xBD },
	0xEFEB, { 0xE7, 0x94, 0xBA },
	0xEFEC, { 0xE7, 0x9D, 0x9B },
	0xEFED, { 0xE7, 0xA2, 0x87 },
	0xEFEE, { 0xE7, 0xA6, 0x8E },
	0xEFEF, { 0xE7, 0xA8, 0x8B },
	0xEFF0, { 0xE7, 0xA9, 0xBD },
	0xEFF1, { 0xE7, 0xB2, 0xBE },
	0xEFF2, { 0xE7, 0xB6, 0x8E },
	0xEFF3, { 0xE8, 0x89, 0x87 },
	0xEFF4, { 0xE8, 0xA8, 0x82 },
	0xEFF5, { 0xE8, 0xAB, 0xAA },
	0xEFF6, { 0xE8, 0xB2, 0x9E },
	0xEFF7, { 0xE9, 0x84, 0xAD },
	0xEFF8, { 0xE9, 0x85, 0x8A },
	0xEFF9, { 0xE9, 0x87, 0x98 },
	0xEFFA, { 0xE9, 0x89, 0xA6 },
	0xEFFB, { 0xE9, 0x8B, 0x8C },
	0xEFFC, { 0xE9, 0x8C, 0xA0 },
	0xEFFD, { 0xE9, 0x9C, 0x86 },
	0xEFFE, { 0xE9, 0x9D, 0x96 },
	0xF0A1, { 0xE9, 0x9D, 0x9C },
	0xF0A2, { 0xE9, 0xA0, 0x82 },
	0xF0A3, { 0xE9, 0xBC, 0x8E },
	0xF0A4, { 0xE5, 0x88, 0xB6 },
	0xF0A5, { 0xE5, 0x8A, 0x91 },
	0xF0A6, { 0xE5, 0x95, 0xBC },
	0xF0A7, { 0xE5, 0xA0, 0xA4 },
	0xF0A8, { 0xE5, 0xB8, 0x9D },
	0xF0A9, { 0xE5, 0xBC, 0x9F },
	0xF0AA, { 0xE6, 0x82, 0x8C },
	0xF0AB, { 0xE6, 0x8F, 0x90 },
	0xF0AC, { 0xE6, 0xA2, 0xAF },
	0xF0AD, { 0xE6, 0xBF, 0x9F },
	0xF0AE, { 0xE7, 0xA5, 0xAD },
	0xF0AF, { 0xE7, 0xAC, 0xAC },
	0xF0B0, { 0xE8, 0x87, 0x8D },
	0xF0B1, { 0xE8, 0x96, 0xBA },
	0xF0B2, { 0xE8, 0xA3, 0xBD },
	0xF0B3, { 0xE8, 0xAB, 0xB8 },
	0xF0B4, { 0xE8, 0xB9, 0x84 },
	0xF0B5, { 0xE9, 0x86, 0x8D },
	0xF0B6, { 0xE9, 0x99, 0xA4 },
	0xF0B7, { 0xE9, 0x9A, 0x9B },
	0xF0B8, { 0xE9, 0x9C, 0xBD },
	0xF0B9, { 0xE9, 0xA1, 0x8C },
	0xF0BA, { 0xE9, 0xBD, 0x8A },
	0xF0BB, { 0xE4, 0xBF, 0x8E },
	0xF0BC, { 0xE5, 0x85, 0x86 },
	0xF0BD, { 0xE5, 0x87, 0x8B },
	0xF0BE, { 0xE5, 0x8A, 0xA9 },
	0xF0BF, { 0xE5, 0x98, 0xB2 },
	0xF0C0, { 0xE5, 0xBC, 0x94 },
	0xF0C1, { 0xE5, 0xBD, 0xAB },
	0xF0C2, { 0xE6, 0x8E, 0xAA },
	0xF0C3, { 0xE6, 0x93, 0x8D },
	0xF0C4, { 0xE6, 0x97, 0xA9 },
	0xF0C5, { 0xE6, 0x99, 0x81 },
	0xF0C6, { 0xE6, 0x9B, 0xBA },
	0xF0C7, { 0xE6, 0x9B, 0xB9 },
	0xF0C8, { 0xE6, 0x9C, 0x9D },
	0xF0C9, { 0xE6, 0xA2, 0x9D },
	0xF0CA, { 0xE6, 0xA3, 0x97 },
	0xF0CB, { 0xE6, 0xA7, 0xBD },
	0xF0CC, { 0xE6, 0xBC, 0x95 },
	0xF0CD, { 0xE6, 0xBD, 0xAE },
	0xF0CE, { 0xE7, 0x85, 0xA7 },
	0xF0CF, { 0xE7, 0x87, 0xA5 },
	0xF0D0, { 0xE7, 0x88, 0xAA },
	0xF0D1, { 0xE7, 0x92, 0xAA },
	0xF0D2, { 0xE7, 0x9C, 0xBA },
	0xF0D3, { 0xE7, 0xA5, 0x96 },
	0xF0D4, { 0xE7, 0xA5, 0x9A },
	0xF0D5, { 0xE7, 0xA7, 0x9F },
	0xF0D6, { 0xE7, 0xA8, 0xA0 },
	0xF0D7, { 0xE7, 0xAA, 0x95 },
	0xF0D8, { 0xE7, 0xB2, 0x97 },
	0xF0D9, { 0xE7, 0xB3, 0x9F },
	0xF0DA, { 0xE7, 0xB5, 0x84 },
	0xF0DB, { 0xE7, 0xB9, 0xB0 },
	0xF0DC, { 0xE8, 0x82, 0x87 },
	0xF0DD, { 0xE8, 0x97, 0xBB },
	0xF0DE, { 0xE8, 0x9A, 0xA4 },
	0xF0DF, { 0xE8, 0xA9, 0x94 },
	0xF0E0, { 0xE8, 0xAA, 0xBF },
	0xF0E1, { 0xE8, 0xB6, 0x99 },
	0xF0E2, { 0xE8, 0xBA, 0x81 },
	0xF0E3, { 0xE9, 0x80, 0xA0 },
	0xF0E4, { 0xE9, 0x81, 0xAD },
	0xF0E5, { 0xE9, 0x87, 0xA3 },
	0xF0E6, { 0xE9, 0x98, 0xBB },
	0xF0E7, { 0xE9, 0x9B, 0x95 },
	0xF0E8, { 0xE9, 0xB3, 0xA5 },
	0xF0E9, { 0xE6, 0x97, 0x8F },
	0xF0EA, { 0xE7, 0xB0, 0x87 },
	0xF0EB, { 0xE8, 0xB6, 0xB3 },
	0xF0EC, { 0xE9, 0x8F, 0x83 },
	0xF0ED, { 0xE5, 0xAD, 0x98 },
	0xF0EE, { 0xE5, 0xB0, 0x8A },
	0xF0EF, { 0xE5, 0x8D, 0x92 },
	0xF0F0, { 0xE6, 0x8B, 0x99 },
	0xF0F1, { 0xE7, 0x8C, 0x9D },
	0xF0F2, { 0xE5, 0x80, 0xA7 },
	0xF0F3, { 0xE5, 0xAE, 0x97 },
	0xF0F4, { 0xE5, 0xBE, 0x9E },
	0xF0F5, { 0xE6, 0x82, 0xB0 },
	0xF0F6, { 0xE6, 0x85, 0xAB },
	0xF0F7, { 0xE6, 0xA3, 0x95 },
	0xF0F8, { 0xE6, 0xB7, 0x99 },
	0xF0F9, { 0xE7, 0x90, 0xAE },
	0xF0FA, { 0xE7, 0xA8, 0xAE },
	0xF0FB, { 0xE7, 0xB5, 0x82 },
	0xF0FC, { 0xE7, 0xB6, 0x9C },
	0xF0FD, { 0xE7, 0xB8, 0xB1 },
	0xF0FE, { 0xE8, 0x85, 0xAB },
	0xF1A1, { 0xE8, 0xB8, 0xAA },
	0xF1A2, { 0xE8, 0xB8, 0xB5 },
	0xF1A3, { 0xE9, 0x8D, 0xBE },
	0xF1A4, { 0xE9, 0x90, 0x98 },
	0xF1A5, { 0xE4, 0xBD, 0x90 },
	0xF1A6, { 0xE5, 0x9D, 0x90 },
	0xF1A7, { 0xE5, 0xB7, 0xA6 },
	0xF1A8, { 0xE5, 0xBA, 0xA7 },
	0xF1A9, { 0xE6, 0x8C, 0xAB },
	0xF1AA, { 0xE7, 0xBD, 0xAA },
	0xF1AB, { 0xE4, 0xB8, 0xBB },
	0xF1AC, { 0xE4, 0xBD, 0x8F },
	0xF1AD, { 0xE4, 0xBE, 0x8F },
	0xF1AE, { 0xE5, 0x81, 0x9A },
	0xF1AF, { 0xE5, 0xA7, 0x9D },
	0xF1B0, { 0xE8, 0x83, 0x84 },
	0xF1B1, { 0xE5, 0x91, 0xAA },
	0xF1B2, { 0xE5, 0x91, 0xA8 },
	0xF1B3, { 0xE5, 0x97, 0xBE },
	0xF1B4, { 0xE5, 0xA5, 0x8F },
	0xF1B5, { 0xE5, 0xAE, 0x99 },
	0xF1B6, { 0xE5, 0xB7, 0x9E },
	0xF1B7, { 0xE5, 0xBB, 0x9A },
	0xF1B8, { 0xE6, 0x99, 0x9D },
	0xF1B9, { 0xE6, 0x9C, 0xB1 },
	0xF1BA, { 0xE6, 0x9F, 0xB1 },
	0xF1BB, { 0xE6, 0xA0, 0xAA },
	0xF1BC, { 0xE6, 0xB3, 0xA8 },
	0xF1BD, { 0xE6, 0xB4, 0xB2 },
	0xF1BE, { 0xE6, 0xB9, 0x8A },
	0xF1BF, { 0xE6, 0xBE, 0x8D },
	0xF1C0, { 0xE7, 0x82, 0xB7 },
	0xF1C1, { 0xE7, 0x8F, 0xA0 },
	0xF1C2, { 0xE7, 0x96, 0x87 },
	0xF1C3, { 0xE7, 0xB1, 0x8C },
	0xF1C4, { 0xE7, 0xB4, 0x82 },
	0xF1C5, { 0xE7, 0xB4, 0xAC },
	0xF1C6, { 0xE7, 0xB6, 0xA2 },
	0xF1C7, { 0xE8, 0x88, 0x9F },
	0xF1C8, { 0xE8, 0x9B, 0x9B },
	0xF1C9, { 0xE8, 0xA8, 0xBB },
	0xF1CA, { 0xE8, 0xAA, 0x85 },
	0xF1CB, { 0xE8, 0xB5, 0xB0 },
	0xF1CC, { 0xE8, 0xBA, 0x8A },
	0xF1CD, { 0xE8, 0xBC, 0xB3 },
	0xF1CE, { 0xE9, 0x80, 0xB1 },
	0xF1CF, { 0xE9, 0x85, 0x8E },
	0xF1D0, { 0xE9, 0x85, 0x92 },
	0xF1D1, { 0xE9, 0x91, 0x84 },
	0xF1D2, { 0xE9, 0xA7, 0x90 },
	0xF1D3, { 0xE7, 0xAB, 0xB9 },
	0xF1D4, { 0xE7, 0xB2, 0xA5 },
	0xF1D5, { 0xE4, 0xBF, 0x8A },
	0xF1D6, { 0xE5, 0x84, 0x81 },
	0xF1D7, { 0xE5, 0x87, 0x86 },
	0xF1D8, { 0xE5, 0x9F, 0x88 },
	0xF1D9, { 0xE5, 0xAF, 0xAF },
	0xF1DA, { 0xE5, 0xB3, 0xBB },
	0xF1DB, { 0xE6, 0x99, 0x99 },
	0xF1DC, { 0xE6, 0xA8, 0xBD },
	0xF1DD, { 0xE6, 0xB5, 0x9A },
	0xF1DE, { 0xE6, 0xBA, 0x96 },
	0xF1DF, { 0xE6, 0xBF, 0xAC },
	0xF1E0, { 0xE7, 0x84, 0x8C },
	0xF1E1, { 0xE7, 0x95, 0xAF },
	0xF1E2, { 0xE7, 0xAB, 0xA3 },
	0xF1E3, { 0xE8, 0xA0, 0xA2 },
	0xF1E4, { 0xE9, 0x80, 0xA1 },
	0xF1E5, { 0xE9, 0x81, 0xB5 },
	0xF1E6, { 0xE9, 0x9B, 0x8B },
	0xF1E7, { 0xE9, 0xA7, 0xBF },
	0xF1E8, { 0xE8, 0x8C, 0x81 },
	0xF1E9, { 0xE4, 0xB8, 0xAD },
	0xF1EA, { 0xE4, 0xBB, 0xB2 },
	0xF1EB, { 0xE8, 0xA1, 0x86 },
	0xF1EC, { 0xE9, 0x87, 0x8D },
	0xF1ED, { 0xE5, 0x8D, 0xBD },
	0xF1EE, { 0xE6, 0xAB, 0x9B },
	0xF1EF, { 0xE6, 0xA5, 0xAB },
	0xF1F0, { 0xE6, 0xB1, 0x81 },
	0xF1F1, { 0xE8, 0x91, 0xBA },
	0xF1F2, { 0xE5, 0xA2, 0x9E },
	0xF1F3, { 0xE6, 0x86, 0x8E },
	0xF1F4, { 0xE6, 0x9B, 0xBE },
	0xF1F5, { 0xE6, 0x8B, 0xAF },
	0xF1F6, { 0xE7, 0x83, 0x9D },
	0xF1F7, { 0xE7, 0x94, 0x91 },
	0xF1F8, { 0xE7, 0x97, 0x87 },
	0xF1F9, { 0xE7, 0xB9, 0x92 },
	0xF1FA, { 0xE8, 0x92, 0xB8 },
	0xF1FB, { 0xE8, 0xAD, 0x89 },
	0xF1FC, { 0xE8, 0xB4, 0x88 },
	0xF1FD, { 0xE4, 0xB9, 0x8B },
	0xF1FE, { 0xE5, 0x8F, 0xAA },
	0xF2A1, { 0xE5, 0x92, 0xAB },
	0xF2A2, { 0xE5, 0x9C, 0xB0 },
	0xF2A3, { 0xE5, 0x9D, 0x80 },
	0xF2A4, { 0xE5, 0xBF, 0x97 },
	0xF2A5, { 0xE6, 0x8C, 0x81 },
	0xF2A6, { 0xE6, 0x8C, 0x87 },
	0xF2A7, { 0xE6, 0x91, 0xAF },
	0xF2A8, { 0xE6, 0x94, 0xAF },
	0xF2A9, { 0xE6, 0x97, 0xA8 },
	0xF2AA, { 0xE6, 0x99, 0xBA },
	0xF2AB, { 0xE6, 0x9E, 0x9D },
	0xF2AC, { 0xE6, 0x9E, 0xB3 },
	0xF2AD, { 0xE6, 0xAD, 0xA2 },
	0xF2AE, { 0xE6, 0xB1, 0xA0 },
	0xF2AF, { 0xE6, 0xB2, 0x9A },
	0xF2B0, { 0xE6, 0xBC, 0xAC },
	0xF2B1, { 0xE7, 0x9F, 0xA5 },
	0xF2B2, { 0xE7, 0xA0, 0xA5 },
	0xF2B3, { 0xE7, 0xA5, 0x89 },
	0xF2B4, { 0xE7, 0xA5, 0x97 },
	0xF2B5, { 0xE7, 0xB4, 0x99 },
	0xF2B6, { 0xE8, 0x82, 0xA2 },
	0xF2B7, { 0xE8, 0x84, 0x82 },
	0xF2B8, { 0xE8, 0x87, 0xB3 },
	0xF2B9, { 0xE8, 0x8A, 0x9D },
	0xF2BA, { 0xE8, 0x8A, 0xB7 },
	0xF2BB, { 0xE8, 0x9C, 0x98 },
	0xF2BC, { 0xE8, 0xAA, 0x8C },
	0xF2BD, { 0xEF, 0xA7, 0xBC },
	0xF2BE, { 0xE8, 0xB4, 0x84 },
	0xF2BF, { 0xE8, 0xB6, 0xBE },
	0xF2C0, { 0xE9, 0x81, 0xB2 },
	0xF2C1, { 0xE7, 0x9B, 0xB4 },
	0xF2C2, { 0xE7, 0xA8, 0x99 },
	0xF2C3, { 0xE7, 0xA8, 0xB7 },
	0xF2C4, { 0xE7, 0xB9, 0x94 },
	0xF2C5, { 0xE8, 0x81, 0xB7 },
	0xF2C6, { 0xE5, 0x94, 0x87 },
	0xF2C7, { 0xE5, 0x97, 0x94 },
	0xF2C8, { 0xE5, 0xA1, 0xB5 },
	0xF2C9, { 0xE6, 0x8C, 0xAF },
	0xF2CA, { 0xE6, 0x90, 0xA2 },
	0xF2CB, { 0xE6, 0x99, 0x89 },
	0xF2CC, { 0xE6, 0x99, 0x8B },
	0xF2CD, { 0xE6, 0xA1, 0xAD },
	0xF2CE, { 0xE6, 0xA6, 0x9B },
	0xF2CF, { 0xE6, 0xAE, 0x84 },
	0xF2D0, { 0xE6, 0xB4, 0xA5 },
	0xF2D1, { 0xE6, 0xBA, 0xB1 },
	0xF2D2, { 0xE7, 0x8F, 0x8D },
	0xF2D3, { 0xE7, 0x91, 0xA8 },
	0xF2D4, { 0xE7, 0x92, 0xA1 },
	0xF2D5, { 0xE7, 0x95, 0x9B },
	0xF2D6, { 0xE7, 0x96, 0xB9 },
	0xF2D7, { 0xE7, 0x9B, 0xA1 },
	0xF2D8, { 0xE7, 0x9C, 0x9E },
	0xF2D9, { 0xE7, 0x9E, 0x8B },
	0xF2DA, { 0xE7, 0xA7, 0xA6 },
	0xF2DB, { 0xE7, 0xB8, 0x89 },
	0xF2DC, { 0xE7, 0xB8, 0x9D },
	0xF2DD, { 0xE8, 0x87, 0xBB },
	0xF2DE, { 0xE8, 0x94, 0xAF },
	0xF2DF, { 0xE8, 0xA2, 0x97 },
	0xF2E0, { 0xE8, 0xA8, 0xBA },
	0xF2E1, { 0xE8, 0xB3, 0x91 },
	0xF2E2, { 0xE8, 0xBB, 0xAB },
	0xF2E3, { 0xE8, 0xBE, 0xB0 },
	0xF2E4, { 0xE9, 0x80, 0xB2 },
	0xF2E5, { 0xE9, 0x8E, 0xAD },
	0xF2E6, { 0xE9, 0x99, 0xA3 },
	0xF2E7, { 0xE9, 0x99, 0xB3 },
	0xF2E8, { 0xE9, 0x9C, 0x87 },
	0xF2E9, { 0xE4, 0xBE, 0x84 },
	0xF2EA, { 0xE5, 0x8F, 0xB1 },
	0xF2EB, { 0xE5, 0xA7, 0xAA },
	0xF2EC, { 0xE5, 0xAB, 0x89 },
	0xF2ED, { 0xE5, 0xB8, 0x99 },
	0xF2EE, { 0xE6, 0xA1, 0x8E },
	0xF2EF, { 0xE7, 0x93, 0x86 },
	0xF2F0, { 0xE7, 0x96, 0xBE },
	0xF2F1, { 0xE7, 0xA7, 0xA9 },
	0xF2F2, { 0xE7, 0xAA, 0x92 },
	0xF2F3, { 0xE8, 0x86, 0xA3 },
	0xF2F4, { 0xE8, 0x9B, 0xAD },
	0xF2F5, { 0xE8, 0xB3, 0xAA },
	0xF2F6, { 0xE8, 0xB7, 0x8C },
	0xF2F7, { 0xE8, 0xBF, 0xAD },
	0xF2F8, { 0xE6, 0x96, 0x9F },
	0xF2F9, { 0xE6, 0x9C, 0x95 },
	0xF2FA, { 0xEF, 0xA7, 0xBD },
	0xF2FB, { 0xE5, 0x9F, 0xB7 },
	0xF2FC, { 0xE6, 0xBD, 0x97 },
	0xF2FD, { 0xE7, 0xB7, 0x9D },
	0xF2FE, { 0xE8, 0xBC, 0xAF },
	0xF3A1, { 0xE9, 0x8F, 0xB6 },
	0xF3A2, { 0xE9, 0x9B, 0x86 },
	0xF3A3, { 0xE5, 0xBE, 0xB5 },
	0xF3A4, { 0xE6, 0x87, 0xB2 },
	0xF3A5, { 0xE6, 0xBE, 0x84 },
	0xF3A6, { 0xE4, 0xB8, 0x94 },
	0xF3A7, { 0xE4, 0xBE, 0x98 },
	0xF3A8, { 0xE5, 0x80, 0x9F },
	0xF3A9, { 0xE5, 0x8F, 0x89 },
	0xF3AA, { 0xE5, 0x97, 0x9F },
	0xF3AB, { 0xE5, 0xB5, 0xAF },
	0xF3AC, { 0xE5, 0xB7, 0xAE },
	0xF3AD, { 0xE6, 0xAC, 0xA1 },
	0xF3AE, { 0xE6, 0xAD, 0xA4 },
	0xF3AF, { 0xE7, 0xA3, 0x8B },
	0xF3B0, { 0xE7, 0xAE, 0x9A },
	0xF3B1, { 0xEF, 0xA7, 0xBE },
	0xF3B2, { 0xE8, 0xB9, 0x89 },
	0xF3B3, { 0xE8, 0xBB, 0x8A },
	0xF3B4, { 0xE9, 0x81, 0xAE },
	0xF3B5, { 0xE6, 0x8D, 0x89 },
	0xF3B6, { 0xE6, 0x90, 0xBE },
	0xF3B7, { 0xE7, 0x9D, 0x80 },
	0xF3B8, { 0xE7, 0xAA, 0x84 },
	0xF3B9, { 0xE9, 0x8C, 0xAF },
	0xF3BA, { 0xE9, 0x91, 0xBF },
	0xF3BB, { 0xE9, 0xBD, 0xAA },
	0xF3BC, { 0xE6, 0x92, 0xB0 },
	0xF3BD, { 0xE6, 0xBE, 0xAF },
	0xF3BE, { 0xE7, 0x87, 0xA6 },
	0xF3BF, { 0xE7, 0x92, 0xA8 },
	0xF3C0, { 0xE7, 0x93, 0x9A },
	0xF3C1, { 0xE7, 0xAB, 0x84 },
	0xF3C2, { 0xE7, 0xB0, 0x92 },
	0xF3C3, { 0xE7, 0xBA, 0x82 },
	0xF3C4, { 0xE7, 0xB2, 0xB2 },
	0xF3C5, { 0xE7, 0xBA, 0x98 },
	0xF3C6, { 0xE8, 0xAE, 0x9A },
	0xF3C7, { 0xE8, 0xB4, 0x8A },
	0xF3C8, { 0xE9, 0x91, 0xBD },
	0xF3C9, { 0xE9, 0xA4, 0x90 },
	0xF3CA, { 0xE9, 0xA5, 0x8C },
	0xF3CB, { 0xE5, 0x88, 0xB9 },
	0xF3CC, { 0xE5, 0xAF, 0x9F },
	0xF3CD, { 0xE6, 0x93, 0xA6 },
	0xF3CE, { 0xE6, 0x9C, 0xAD },
	0xF3CF, { 0xE7, 0xB4, 0xAE },
	0xF3D0, { 0xE5, 0x83, 0xAD },
	0xF3D1, { 0xE5, 0x8F, 0x83 },
	0xF3D2, { 0xE5, 0xA1, 0xB9 },
	0xF3D3, { 0xE6, 0x85, 0x98 },
	0xF3D4, { 0xE6, 0x85, 0x99 },
	0xF3D5, { 0xE6, 0x87, 0xBA },
	0xF3D6, { 0xE6, 0x96, 0xAC },
	0xF3D7, { 0xE7, 0xAB, 0x99 },
	0xF3D8, { 0xE8, 0xAE, 0x92 },
	0xF3D9, { 0xE8, 0xAE, 0x96 },
	0xF3DA, { 0xE5, 0x80, 0x89 },
	0xF3DB, { 0xE5, 0x80, 0xA1 },
	0xF3DC, { 0xE5, 0x89, 0xB5 },
	0xF3DD, { 0xE5, 0x94, 0xB1 },
	0xF3DE, { 0xE5, 0xA8, 0xBC },
	0xF3DF, { 0xE5, 0xBB, 0xA0 },
	0xF3E0, { 0xE5, 0xBD, 0xB0 },
	0xF3E1, { 0xE6, 0x84, 0xB4 },
	0xF3E2, { 0xE6, 0x95, 0x9E },
	0xF3E3, { 0xE6, 0x98, 0x8C },
	0xF3E4, { 0xE6, 0x98, 0xB6 },
	0xF3E5, { 0xE6, 0x9A, 0xA2 },
	0xF3E6, { 0xE6, 0xA7, 0x8D },
	0xF3E7, { 0xE6, 0xBB, 0x84 },
	0xF3E8, { 0xE6, 0xBC, 0xB2 },
	0xF3E9, { 0xE7, 0x8C, 0x96 },
	0xF3EA, { 0xE7, 0x98, 0xA1 },
	0xF3EB, { 0xE7, 0xAA, 0x93 },
	0xF3EC, { 0xE8, 0x84, 0xB9 },
	0xF3ED, { 0xE8, 0x89, 0x99 },
	0xF3EE, { 0xE8, 0x8F, 0x96 },
	0xF3EF, { 0xE8, 0x92, 0xBC },
	0xF3F0, { 0xE5, 0x82, 0xB5 },
	0xF3F1, { 0xE5, 0x9F, 0xB0 },
	0xF3F2, { 0xE5, 0xAF, 0x80 },
	0xF3F3, { 0xE5, 0xAF, 0xA8 },
	0xF3F4, { 0xE5, 0xBD, 0xA9 },
	0xF3F5, { 0xE6, 0x8E, 0xA1 },
	0xF3F6, { 0xE7, 0xA0, 0xA6 },
	0xF3F7, { 0xE7, 0xB6, 0xB5 },
	0xF3F8, { 0xE8, 0x8F, 0x9C },
	0xF3F9, { 0xE8, 0x94, 0xA1 },
	0xF3FA, { 0xE9, 0x87, 0x87 },
	0xF3FB, { 0xE9, 0x87, 0xB5 },
	0xF3FC, { 0xE5, 0x86, 0x8A },
	0xF3FD, { 0xE6, 0x9F, 0xB5 },
	0xF3FE, { 0xE7, 0xAD, 0x96 },
	0xF4A1, { 0xE8, 0xB2, 0xAC },
	0xF4A2, { 0xE5, 0x87, 0x84 },
	0xF4A3, { 0xE5, 0xA6, 0xBB },
	0xF4A4, { 0xE6, 0x82, 0xBD },
	0xF4A5, { 0xE8, 0x99, 0x95 },
	0xF4A6, { 0xE5, 0x80, 0x9C },
	0xF4A7, { 0xEF, 0xA7, 0xBF },
	0xF4A8, { 0xE5, 0x89, 0x94 },
	0xF4A9, { 0xE5, 0xB0, 0xBA },
	0xF4AA, { 0xE6, 0x85, 0xBD },
	0xF4AB, { 0xE6, 0x88, 0x9A },
	0xF4AC, { 0xE6, 0x8B, 0x93 },
	0xF4AD, { 0xE6, 0x93, 0xB2 },
	0xF4AE, { 0xE6, 0x96, 0xA5 },
	0xF4AF, { 0xE6, 0xBB, 0x8C },
	0xF4B0, { 0xE7, 0x98, 0xA0 },
	0xF4B1, { 0xE8, 0x84, 0x8A },
	0xF4B2, { 0xE8, 0xB9, 0xA0 },
	0xF4B3, { 0xE9, 0x99, 0x9F },
	0xF4B4, { 0xE9, 0x9A, 0xBB },
	0xF4B5, { 0xE4, 0xBB, 0x9F },
	0xF4B6, { 0xE5, 0x8D, 0x83 },
	0xF4B7, { 0xE5, 0x96, 0x98 },
	0xF4B8, { 0xE5, 0xA4, 0xA9 },
	0xF4B9, { 0xE5, 0xB7, 0x9D },
	0xF4BA, { 0xE6, 0x93, 0x85 },
	0xF4BB, { 0xE6, 0xB3, 0x89 },
	0xF4BC, { 0xE6, 0xB7, 0xBA },
	0xF4BD, { 0xE7, 0x8E, 0x94 },
	0xF4BE, { 0xE7, 0xA9, 0xBF },
	0xF4BF, { 0xE8, 0x88, 0x9B },
	0xF4C0, { 0xE8, 0x96, 0xA6 },
	0xF4C1, { 0xE8, 0xB3, 0xA4 },
	0xF4C2, { 0xE8, 0xB8, 0x90 },
	0xF4C3, { 0xE9, 0x81, 0xB7 },
	0xF4C4, { 0xE9, 0x87, 0xA7 },
	0xF4C5, { 0xE9, 0x97, 0xA1 },
	0xF4C6, { 0xE9, 0x98, 0xA1 },
	0xF4C7, { 0xE9, 0x9F, 0x86 },
	0xF4C8, { 0xE5, 0x87, 0xB8 },
	0xF4C9, { 0xE5, 0x93, 0xB2 },
	0xF4CA, { 0xE5, 0x96, 0x86 },
	0xF4CB, { 0xE5, 0xBE, 0xB9 },
	0xF4CC, { 0xE6, 0x92, 0xA4 },
	0xF4CD, { 0xE6, 0xBE, 0x88 },
	0xF4CE, { 0xE7, 0xB6, 0xB4 },
	0xF4CF, { 0xE8, 0xBC, 0x9F },
	0xF4D0, { 0xE8, 0xBD, 0x8D },
	0xF4D1, { 0xE9, 0x90, 0xB5 },
	0xF4D2, { 0xE5, 0x83, 0x89 },
	0xF4D3, { 0xE5, 0xB0, 0x96 },
	0xF4D4, { 0xE6, 0xB2, 0xBE },
	0xF4D5, { 0xE6, 0xB7, 0xBB },
	0xF4D6, { 0xE7, 0x94, 0x9B },
	0xF4D7, { 0xE7, 0x9E, 0xBB },
	0xF4D8, { 0xE7, 0xB0, 0xBD },
	0xF4D9, { 0xE7, 0xB1, 0xA4 },
	0xF4DA, { 0xE8, 0xA9, 0xB9 },
	0xF4DB, { 0xE8, 0xAB, 0x82 },
	0xF4DC, { 0xE5, 0xA0, 0x9E },
	0xF4DD, { 0xE5, 0xA6, 0xBE },
	0xF4DE, { 0xE5, 0xB8, 0x96 },
	0xF4DF, { 0xE6, 0x8D, 0xB7 },
	0xF4E0, { 0xE7, 0x89, 0x92 },
	0xF4E1, { 0xE7, 0x96, 0x8A },
	0xF4E2, { 0xE7, 0x9D, 0xAB },
	0xF4E3, { 0xE8, 0xAB, 0x9C },
	0xF4E4, { 0xE8, 0xB2, 0xBC },
	0xF4E5, { 0xE8, 0xBC, 0x92 },
	0xF4E6, { 0xE5, 0xBB, 0xB3 },
	0xF4E7, { 0xE6, 0x99, 0xB4 },
	0xF4E8, { 0xE6, 0xB7, 0xB8 },
	0xF4E9, { 0xE8, 0x81, 0xBD },
	0xF4EA, { 0xE8, 0x8F, 0x81 },
	0xF4EB, { 0xE8, 0xAB, 0x8B },
	0xF4EC, { 0xE9, 0x9D, 0x91 },
	0xF4ED, { 0xE9, 0xAF, 0x96 },
	0xF4EE, { 0xEF, 0xA8, 0x80 },
	0xF4EF, { 0xE5, 0x89, 0x83 },
	0xF4F0, { 0xE6, 0x9B, 0xBF },
	0xF4F1, { 0xE6, 0xB6, 0x95 },
	0xF4F2, { 0xE6, 0xBB, 0xAF },
	0xF4F3, { 0xE7, 0xB7, 0xA0 },
	0xF4F4, { 0xE8, 0xAB, 0xA6 },
	0xF4F5, { 0xE9, 0x80, 0xAE },
	0xF4F6, { 0xE9, 0x81, 0x9E },
	0xF4F7, { 0xE9, 0xAB, 0x94 },
	0xF4F8, { 0xE5, 0x88, 0x9D },
	0xF4F9, { 0xE5, 0x89, 0xBF },
	0xF4FA, { 0xE5, 0x93, 0xA8 },
	0xF4FB, { 0xE6, 0x86, 0x94 },
	0xF4FC, { 0xE6, 0x8A, 0x84 },
	0xF4FD, { 0xE6, 0x8B, 0x9B },
	0xF4FE, { 0xE6, 0xA2, 0xA2 },
	0xF5A1, { 0xE6, 0xA4, 0x92 },
	0xF5A2, { 0xE6, 0xA5, 0x9A },
	0xF5A3, { 0xE6, 0xA8, 0xB5 },
	0xF5A4, { 0xE7, 0x82, 0x92 },
	0xF5A5, { 0xE7, 0x84, 0xA6 },
	0xF5A6, { 0xE7, 0xA1, 0x9D },
	0xF5A7, { 0xE7, 0xA4, 0x81 },
	0xF5A8, { 0xE7, 0xA4, 0x8E },
	0xF5A9, { 0xE7, 0xA7, 0x92 },
	0xF5AA, { 0xE7, 0xA8, 0x8D },
	0xF5AB, { 0xE8, 0x82, 0x96 },
	0xF5AC, { 0xE8, 0x89, 0xB8 },
	0xF5AD, { 0xE8, 0x8B, 0x95 },
	0xF5AE, { 0xE8, 0x8D, 0x89 },
	0xF5AF, { 0xE8, 0x95, 0x89 },
	0xF5B0, { 0xE8, 0xB2, 0x82 },
	0xF5B1, { 0xE8, 0xB6, 0x85 },
	0xF5B2, { 0xE9, 0x85, 0xA2 },
	0xF5B3, { 0xE9, 0x86, 0x8B },
	0xF5B4, { 0xE9, 0x86, 0xAE },
	0xF5B5, { 0xE4, 0xBF, 0x83 },
	0xF5B6, { 0xE5, 0x9B, 0x91 },
	0xF5B7, { 0xE7, 0x87, 0xAD },
	0xF5B8, { 0xE7, 0x9F, 0x97 },
	0xF5B9, { 0xE8, 0x9C, 0x80 },
	0xF5BA, { 0xE8, 0xA7, 0xB8 },
	0xF5BB, { 0xE5, 0xAF, 0xB8 },
	0xF5BC, { 0xE5, 0xBF, 0x96 },
	0xF5BD, { 0xE6, 0x9D, 0x91 },
	0xF5BE, { 0xE9, 0x82, 0xA8 },
	0xF5BF, { 0xE5, 0x8F, 0xA2 },
	0xF5C0, { 0xE5, 0xA1, 0x9A },
	0xF5C1, { 0xE5, 0xAF, 0xB5 },
	0xF5C2, { 0xE6, 0x82, 0xA4 },
	0xF5C3, { 0xE6, 0x86, 0x81 },
	0xF5C4, { 0xE6, 0x91, 0xA0 },
	0xF5C5, { 0xE7, 0xB8, 0xBD },
	0xF5C6, { 0xE8, 0x81, 0xB0 },
	0xF5C7, { 0xE8, 0x94, 0xA5 },
	0xF5C8, { 0xE9, 0x8A, 0x83 },
	0xF5C9, { 0xE6, 0x92, 0xAE },
	0xF5CA, { 0xE5, 0x82, 0xAC },
	0xF5CB, { 0xE5, 0xB4, 0x94 },
	0xF5CC, { 0xE6, 0x9C, 0x80 },
	0xF5CD, { 0xE5, 0xA2, 0x9C },
	0xF5CE, { 0xE6, 0x8A, 0xBD },
	0xF5CF, { 0xE6, 0x8E, 0xA8 },
	0xF5D0, { 0xE6, 0xA4, 0x8E },
	0xF5D1, { 0xE6, 0xA5, 0xB8 },
	0xF5D2, { 0xE6, 0xA8, 0x9E },
	0xF5D3, { 0xE6, 0xB9, 0xAB },
	0xF5D4, { 0xE7, 0x9A, 0xBA },
	0xF5D5, { 0xE7, 0xA7, 0x8B },
	0xF5D6, { 0xE8, 0x8A, 0xBB },
	0xF5D7, { 0xE8, 0x90, 0xA9 },
	0xF5D8, { 0xE8, 0xAB, 0x8F },
	0xF5D9, { 0xE8, 0xB6, 0xA8 },
	0xF5DA, { 0xE8, 0xBF, 0xBD },
	0xF5DB, { 0xE9, 0x84, 0x92 },
	0xF5DC, { 0xE9, 0x85, 0x8B },
	0xF5DD, { 0xE9, 0x86, 0x9C },
	0xF5DE, { 0xE9, 0x8C, 0x90 },
	0xF5DF, { 0xE9, 0x8C, 0x98 },
	0xF5E0, { 0xE9, 0x8E, 0x9A },
	0xF5E1, { 0xE9, 0x9B, 0x9B },
	0xF5E2, { 0xE9, 0xA8, 0xB6 },
	0xF5E3, { 0xE9, 0xB0, 0x8D },
	0xF5E4, { 0xE4, 0xB8, 0x91 },
	0xF5E5, { 0xE7, 0x95, 0x9C },
	0xF5E6, { 0xE7, 0xA5, 0x9D },
	0xF5E7, { 0xE7, 0xAB, 0xBA },
	0xF5E8, { 0xE7, 0xAD, 0x91 },
	0xF5E9, { 0xE7, 0xAF, 0x89 },
	0xF5EA, { 0xE7, 0xB8, 0xAE },
	0xF5EB, { 0xE8, 0x93, 0x84 },
	0xF5EC, { 0xE8, 0xB9, 0x99 },
	0xF5ED, { 0xE8, 0xB9, 0xB4 },
	0xF5EE, { 0xE8, 0xBB, 0xB8 },
	0xF5EF, { 0xE9, 0x80, 0x90 },
	0xF5F0, { 0xE6, 0x98, 0xA5 },
	0xF5F1, { 0xE6, 0xA4, 0xBF },
	0xF5F2, { 0xE7, 0x91, 0x83 },
	0xF5F3, { 0xE5, 0x87, 0xBA },
	0xF5F4, { 0xE6, 0x9C, 0xAE },
	0xF5F5, { 0xE9, 0xBB, 0x9C },
	0xF5F6, { 0xE5, 0x85, 0x85 },
	0xF5F7, { 0xE5, 0xBF, 0xA0 },
	0xF5F8, { 0xE6, 0xB2, 0x96 },
	0xF5F9, { 0xE8, 0x9F, 0xB2 },
	0xF5FA, { 0xE8, 0xA1, 0x9D },
	0xF5FB, { 0xE8, 0xA1, 0xB7 },
	0xF5FC, { 0xE6, 0x82, 0xB4 },
	0xF5FD, { 0xE8, 0x86, 0xB5 },
	0xF5FE, { 0xE8, 0x90, 0x83 },
	0xF6A1, { 0xE8, 0xB4, 0x85 },
	0xF6A2, { 0xE5, 0x8F, 0x96 },
	0xF6A3, { 0xE5, 0x90, 0xB9 },
	0xF6A4, { 0xE5, 0x98, 0xB4 },
	0xF6A5, { 0xE5, 0xA8, 0xB6 },
	0xF6A6, { 0xE5, 0xB0, 0xB1 },
	0xF6A7, { 0xE7, 0x82, 0x8A },
	0xF6A8, { 0xE7, 0xBF, 0xA0 },
	0xF6A9, { 0xE8, 0x81, 0x9A },
	0xF6AA, { 0xE8, 0x84, 0x86 },
	0xF6AB, { 0xE8, 0x87, 0xAD },
	0xF6AC, { 0xE8, 0xB6, 0xA3 },
	0xF6AD, { 0xE9, 0x86, 0x89 },
	0xF6AE, { 0xE9, 0xA9, 0x9F },
	0xF6AF, { 0xE9, 0xB7, 0xB2 },
	0xF6B0, { 0xE5, 0x81, 0xB4 },
	0xF6B1, { 0xE4, 0xBB, 0x84 },
	0xF6B2, { 0xE5, 0x8E, 0xA0 },
	0xF6B3, { 0xE6, 0x83, 0xBB },
	0xF6B4, { 0xE6, 0xB8, 0xAC },
	0xF6B5, { 0xE5, 0xB1, 0xA4 },
	0xF6B6, { 0xE4, 0xBE, 0x88 },
	0xF6B7, { 0xE5, 0x80, 0xA4 },
	0xF6B8, { 0xE5, 0x97, 0xA4 },
	0xF6B9, { 0xE5, 0xB3, 0x99 },
	0xF6BA, { 0xE5, 0xB9, 0x9F },
	0xF6BB, { 0xE6, 0x81, 0xA5 },
	0xF6BC, { 0xE6, 0xA2, 0x94 },
	0xF6BD, { 0xE6, 0xB2, 0xBB },
	0xF6BE, { 0xE6, 0xB7, 0x84 },
	0xF6BF, { 0xE7, 0x86, 0xBE },
	0xF6C0, { 0xE7, 0x97, 0x94 },
	0xF6C1, { 0xE7, 0x97, 0xB4 },
	0xF6C2, { 0xE7, 0x99, 0xA1 },
	0xF6C3, { 0xE7, 0xA8, 0x9A },
	0xF6C4, { 0xE7, 0xA9, 0x89 },
	0xF6C5, { 0xE7, 0xB7, 0x87 },
	0xF6C6, { 0xE7, 0xB7, 0xBB },
	0xF6C7, { 0xE7, 0xBD, 0xAE },
	0xF6C8, { 0xE8, 0x87, 0xB4 },
	0xF6C9, { 0xE8, 0x9A, 0xA9 },
	0xF6CA, { 0xE8, 0xBC, 0x9C },
	0xF6CB, { 0xE9, 0x9B, 0x89 },
	0xF6CC, { 0xE9, 0xA6, 0xB3 },
	0xF6CD, { 0xE9, 0xBD, 0x92 },
	0xF6CE, { 0xE5, 0x89, 0x87 },
	0xF6CF, { 0xE5, 0x8B, 0x85 },
	0xF6D0, { 0xE9, 0xA3, 0xAD },
	0xF6D1, { 0xE8, 0xA6, 0xAA },
	0xF6D2, { 0xE4, 0xB8, 0x83 },
	0xF6D3, { 0xE6, 0x9F, 0x92 },
	0xF6D4, { 0xE6, 0xBC, 0x86 },
	0xF6D5, { 0xE4, 0xBE, 0xB5 },
	0xF6D6, { 0xE5, 0xAF, 0xA2 },
	0xF6D7, { 0xE6, 0x9E, 0x95 },
	0xF6D8, { 0xE6, 0xB2, 0x88 },
	0xF6D9, { 0xE6, 0xB5, 0xB8 },
	0xF6DA, { 0xE7, 0x90, 0x9B },
	0xF6DB, { 0xE7, 0xA0, 0xA7 },
	0xF6DC, { 0xE9, 0x87, 0x9D },
	0xF6DD, { 0xE9, 0x8D, 0xBC },
	0xF6DE, { 0xE8, 0x9F, 0x84 },
	0xF6DF, { 0xE7, 0xA7, 0xA4 },
	0xF6E0, { 0xE7, 0xA8, 0xB1 },
	0xF6E1, { 0xE5, 0xBF, 0xAB },
	0xF6E2, { 0xE4, 0xBB, 0x96 },
	0xF6E3, { 0xE5, 0x92, 0xA4 },
	0xF6E4, { 0xE5, 0x94, 0xBE },
	0xF6E5, { 0xE5, 0xA2, 0xAE },
	0xF6E6, { 0xE5, 0xA6, 0xA5 },
	0xF6E7, { 0xE6, 0x83, 0xB0 },
	0xF6E8, { 0xE6, 0x89, 0x93 },
	0xF6E9, { 0xE6, 0x8B, 0x96 },
	0xF6EA, { 0xE6, 0x9C, 0xB6 },
	0xF6EB, { 0xE6, 0xA5, 0x95 },
	0xF6EC, { 0xE8, 0x88, 0xB5 },
	0xF6ED, { 0xE9, 0x99, 0x80 },
	0xF6EE, { 0xE9, 0xA6, 0xB1 },
	0xF6EF, { 0xE9, 0xA7, 0x9D },
	0xF6F0, { 0xE5, 0x80, 0xAC },
	0xF6F1, { 0xE5, 0x8D, 0x93 },
	0xF6F2, { 0xE5, 0x95, 0x84 },
	0xF6F3, { 0xE5, 0x9D, 0xBC },
	0xF6F4, { 0xEF, 0xA8, 0x81 },
	0xF6F5, { 0xE6, 0x89, 0x98 },
	0xF6F6, { 0xEF, 0xA8, 0x82 },
	0xF6F7, { 0xE6, 0x93, 0xA2 },
	0xF6F8, { 0xE6, 0x99, 0xAB },
	0xF6F9, { 0xE6, 0x9F, 0x9D },
	0xF6FA, { 0xE6, 0xBF, 0x81 },
	0xF6FB, { 0xE6, 0xBF, 0xAF },
	0xF6FC, { 0xE7, 0x90, 0xA2 },
	0xF6FD, { 0xE7, 0x90, 0xB8 },
	0xF6FE, { 0xE8, 0xA8, 0x97 },
	0xF7A1, { 0xE9, 0x90, 0xB8 },
	0xF7A2, { 0xE5, 0x91, 0x91 },
	0xF7A3, { 0xE5, 0x98, 0x86 },
	0xF7A4, { 0xE5, 0x9D, 0xA6 },
	0xF7A5, { 0xE5, 0xBD, 0x88 },
	0xF7A6, { 0xE6, 0x86, 0x9A },
	0xF7A7, { 0xE6, 0xAD, 0x8E },
	0xF7A8, { 0xE7, 0x81, 0x98 },
	0xF7A9, { 0xE7, 0x82, 0xAD },
	0xF7AA, { 0xE7, 0xB6, 0xBB },
	0xF7AB, { 0xE8, 0xAA, 0x95 },
	0xF7AC, { 0xE5, 0xA5, 0xAA },
	0xF7AD, { 0xE8, 0x84, 0xAB },
	0xF7AE, { 0xE6, 0x8E, 0xA2 },
	0xF7AF, { 0xE7, 0x9C, 0x88 },
	0xF7B0, { 0xE8, 0x80, 0xBD },
	0xF7B1, { 0xE8, 0xB2, 0xAA },
	0xF7B2, { 0xE5, 0xA1, 0x94 },
	0xF7B3, { 0xE6, 0x90, 0xAD },
	0xF7B4, { 0xE6, 0xA6, 0xBB },
	0xF7B5, { 0xE5, 0xAE, 0x95 },
	0xF7B6, { 0xE5, 0xB8, 0x91 },
	0xF7B7, { 0xE6, 0xB9, 0xAF },
	0xF7B8, { 0xEF, 0xA8, 0x83 },
	0xF7B9, { 0xE8, 0x95, 0xA9 },
	0xF7BA, { 0xE5, 0x85, 0x8C },
	0xF7BB, { 0xE5, 0x8F, 0xB0 },
	0xF7BC, { 0xE5, 0xA4, 0xAA },
	0xF7BD, { 0xE6, 0x80, 0xA0 },
	0xF7BE, { 0xE6, 0x85, 0x8B },
	0xF7BF, { 0xE6, 0xAE, 0x86 },
	0xF7C0, { 0xE6, 0xB1, 0xB0 },
	0xF7C1, { 0xE6, 0xB3, 0xB0 },
	0xF7C2, { 0xE7, 0xAC, 0x9E },
	0xF7C3, { 0xE8, 0x83, 0x8E },
	0xF7C4, { 0xE8, 0x8B, 0x94 },
	0xF7C5, { 0xE8, 0xB7, 0x86 },
	0xF7C6, { 0xE9, 0x82, 0xB0 },
	0xF7C7, { 0xE9, 0xA2, 0xB1 },
	0xF7C8, { 0xEF, 0xA8, 0x84 },
	0xF7C9, { 0xE6, 0x93, 0x87 },
	0xF7CA, { 0xE6, 0xBE, 0xA4 },
	0xF7CB, { 0xE6, 0x92, 0x91 },
	0xF7CC, { 0xE6, 0x94, 0x84 },
	0xF7CD, { 0xE5, 0x85, 0x8E },
	0xF7CE, { 0xE5, 0x90, 0x90 },
	0xF7CF, { 0xE5, 0x9C, 0x9F },
	0xF7D0, { 0xE8, 0xA8, 0x8E },
	0xF7D1, { 0xE6, 0x85, 0x9F },
	0xF7D2, { 0xE6, 0xA1, 0xB6 },
	0xF7D3, { 0xEF, 0xA8, 0x85 },
	0xF7D4, { 0xE7, 0x97, 0x9B },
	0xF7D5, { 0xE7, 0xAD, 0x92 },
	0xF7D6, { 0xE7, 0xB5, 0xB1 },
	0xF7D7, { 0xE9, 0x80, 0x9A },
	0xF7D8, { 0xE5, 0xA0, 0x86 },
	0xF7D9, { 0xE6, 0xA7, 0x8C },
	0xF7DA, { 0xE8, 0x85, 0xBF },
	0xF7DB, { 0xE8, 0xA4, 0xAA },
	0xF7DC, { 0xE9, 0x80, 0x80 },
	0xF7DD, { 0xE9, 0xA0, 0xB9 },
	0xF7DE, { 0xE5, 0x81, 0xB8 },
	0xF7DF, { 0xE5, 0xA5, 0x97 },
	0xF7E0, { 0xE5, 0xA6, 0xAC },
	0xF7E1, { 0xE6, 0x8A, 0x95 },
	0xF7E2, { 0xE9, 0x80, 0x8F },
	0xF7E3, { 0xE9, 0xAC, 0xAA },
	0xF7E4, { 0xE6, 0x85, 0x9D },
	0xF7E5, { 0xE7, 0x89, 0xB9 },
	0xF7E6, { 0xE9, 0x97, 0x96 },
	0xF7E7, { 0xE5, 0x9D, 0xA1 },
	0xF7E8, { 0xE5, 0xA9, 0x86 },
	0xF7E9, { 0xE5, 0xB7, 0xB4 },
	0xF7EA, { 0xE6, 0x8A, 0x8A },
	0xF7EB, { 0xE6, 0x92, 0xAD },
	0xF7EC, { 0xE6, 0x93, 0xBA },
	0xF7ED, { 0xE6, 0x9D, 0xB7 },
	0xF7EE, { 0xE6, 0xB3, 0xA2 },
	0xF7EF, { 0xE6, 0xB4, 0xBE },
	0xF7F0, { 0xE7, 0x88, 0xAC },
	0xF7F1, { 0xE7, 0x90, 0xB6 },
	0xF7F2, { 0xE7, 0xA0, 0xB4 },
	0xF7F3, { 0xE7, 0xBD, 0xB7 },
	0xF7F4, { 0xE8, 0x8A, 0xAD },
	0xF7F5, { 0xE8, 0xB7, 0x9B },
	0xF7F6, { 0xE9, 0xA0, 0x97 },
	0xF7F7, { 0xE5, 0x88, 0xA4 },
	0xF7F8, { 0xE5, 0x9D, 0x82 },
	0xF7F9, { 0xE6, 0x9D, 0xBF },
	0xF7FA, { 0xE7, 0x89, 0x88 },
	0xF7FB, { 0xE7, 0x93, 0xA3 },
	0xF7FC, { 0xE8, 0xB2, 0xA9 },
	0xF7FD, { 0xE8, 0xBE, 0xA6 },
	0xF7FE, { 0xE9, 0x88, 0x91 },
	0xF8A1, { 0xE9, 0x98, 0xAA },
	0xF8A2, { 0xE5, 0x85, 0xAB },
	0xF8A3, { 0xE5, 0x8F, 0xAD },
	0xF8A4, { 0xE6, 0x8D, 0x8C },
	0xF8A5, { 0xE4, 0xBD, 0xA9 },
	0xF8A6, { 0xE5, 0x94, 0x84 },
	0xF8A7, { 0xE6, 0x82, 0x96 },
	0xF8A8, { 0xE6, 0x95, 0x97 },
	0xF8A9, { 0xE6, 0xB2, 0x9B },
	0xF8AA, { 0xE6, 0xB5, 0xBF },
	0xF8AB, { 0xE7, 0x89, 0x8C },
	0xF8AC, { 0xE7, 0x8B, 0xBD },
	0xF8AD, { 0xE7, 0xA8, 0x97 },
	0xF8AE, { 0xE8, 0xA6, 0x87 },
	0xF8AF, { 0xE8, 0xB2, 0x9D },
	0xF8B0, { 0xE5, 0xBD, 0xAD },
	0xF8B1, { 0xE6, 0xBE, 0x8E },
	0xF8B2, { 0xE7, 0x83, 0xB9 },
	0xF8B3, { 0xE8, 0x86, 0xA8 },
	0xF8B4, { 0xE6, 0x84, 0x8E },
	0xF8B5, { 0xE4, 0xBE, 0xBF },
	0xF8B6, { 0xE5, 0x81, 0x8F },
	0xF8B7, { 0xE6, 0x89, 0x81 },
	0xF8B8, { 0xE7, 0x89, 0x87 },
	0xF8B9, { 0xE7, 0xAF, 0x87 },
	0xF8BA, { 0xE7, 0xB7, 0xA8 },
	0xF8BB, { 0xE7, 0xBF, 0xA9 },
	0xF8BC, { 0xE9, 0x81, 0x8D },
	0xF8BD, { 0xE9, 0x9E, 0xAD },
	0xF8BE, { 0xE9, 0xA8, 0x99 },
	0xF8BF, { 0xE8, 0xB2, 0xB6 },
	0xF8C0, { 0xE5, 0x9D, 0xAA },
	0xF8C1, { 0xE5, 0xB9, 0xB3 },
	0xF8C2, { 0xE6, 0x9E, 0xB0 },
	0xF8C3, { 0xE8, 0x90, 0x8D },
	0xF8C4, { 0xE8, 0xA9, 0x95 },
	0xF8C5, { 0xE5, 0x90, 0xA0 },
	0xF8C6, { 0xE5, 0xAC, 0x96 },
	0xF8C7, { 0xE5, 0xB9, 0xA3 },
	0xF8C8, { 0xE5, 0xBB, 0xA2 },
	0xF8C9, { 0xE5, 0xBC, 0x8A },
	0xF8CA, { 0xE6, 0x96, 0x83 },
	0xF8CB, { 0xE8, 0x82, 0xBA },
	0xF8CC, { 0xE8, 0x94, 0xBD },
	0xF8CD, { 0xE9, 0x96, 0x89 },
	0xF8CE, { 0xE9, 0x99, 0x9B },
	0xF8CF, { 0xE4, 0xBD, 0x88 },
	0xF8D0, { 0xE5, 0x8C, 0x85 },
	0xF8D1, { 0xE5, 0x8C, 0x8D },
	0xF8D2, { 0xE5, 0x8C, 0x8F },
	0xF8D3, { 0xE5, 0x92, 0x86 },
	0xF8D4, { 0xE5, 0x93, 0xBA },
	0xF8D5, { 0xE5, 0x9C, 0x83 },
	0xF8D6, { 0xE5, 0xB8, 0x83 },
	0xF8D7, { 0xE6, 0x80, 0x96 },
	0xF8D8, { 0xE6, 0x8A, 0x9B },
	0xF8D9, { 0xE6, 0x8A, 0xB1 },
	0xF8DA, { 0xE6, 0x8D, 0x95 },
	0xF8DB, { 0xEF, 0xA8, 0x86 },
	0xF8DC, { 0xE6, 0xB3, 0xA1 },
	0xF8DD, { 0xE6, 0xB5, 0xA6 },
	0xF8DE, { 0xE7, 0x96, 0xB1 },
	0xF8DF, { 0xE7, 0xA0, 0xB2 },
	0xF8E0, { 0xE8, 0x83, 0x9E },
	0xF8E1, { 0xE8, 0x84, 0xAF },
	0xF8E2, { 0xE8, 0x8B, 0x9E },
	0xF8E3, { 0xE8, 0x91, 0xA1 },
	0xF8E4, { 0xE8, 0x92, 0xB2 },
	0xF8E5, { 0xE8, 0xA2, 0x8D },
	0xF8E6, { 0xE8, 0xA4, 0x92 },
	0xF8E7, { 0xE9, 0x80, 0x8B },
	0xF8E8, { 0xE9, 0x8B, 0xAA },
	0xF8E9, { 0xE9, 0xA3, 0xBD },
	0xF8EA, { 0xE9, 0xAE, 0x91 },
	0xF8EB, { 0xE5, 0xB9, 0x85 },
	0xF8EC, { 0xE6, 0x9A, 0xB4 },
	0xF8ED, { 0xE6, 0x9B, 0x9D },
	0xF8EE, { 0xE7, 0x80, 0x91 },
	0xF8EF, { 0xE7, 0x88, 0x86 },
	0xF8F0, { 0xEF, 0xA8, 0x87 },
	0xF8F1, { 0xE4, 0xBF, 0xB5 },
	0xF8F2, { 0xE5, 0x89, 0xBD },
	0xF8F3, { 0xE5, 0xBD, 0xAA },
	0xF8F4, { 0xE6, 0x85, 0x93 },
	0xF8F5, { 0xE6, 0x9D, 0x93 },
	0xF8F6, { 0xE6, 0xA8, 0x99 },
	0xF8F7, { 0xE6, 0xBC, 0x82 },
	0xF8F8, { 0xE7, 0x93, 0xA2 },
	0xF8F9, { 0xE7, 0xA5, 0xA8 },
	0xF8FA, { 0xE8, 0xA1, 0xA8 },
	0xF8FB, { 0xE8, 0xB1, 0xB9 },
	0xF8FC, { 0xE9, 0xA3, 0x87 },
	0xF8FD, { 0xE9, 0xA3, 0x84 },
	0xF8FE, { 0xE9, 0xA9, 0x83 },
	0xF9A1, { 0xE5, 0x93, 0x81 },
	0xF9A2, { 0xE7, 0xA8, 0x9F },
	0xF9A3, { 0xE6, 0xA5, 0x93 },
	0xF9A4, { 0xE8, 0xAB, 0xB7 },
	0xF9A5, { 0xE8, 0xB1, 0x8A },
	0xF9A6, { 0xE9, 0xA2, 0xA8 },
	0xF9A7, { 0xE9, 0xA6, 0xAE },
	0xF9A8, { 0xE5, 0xBD, 0xBC },
	0xF9A9, { 0xE6, 0x8A, 0xAB },
	0xF9AA, { 0xE7, 0x96, 0xB2 },
	0xF9AB, { 0xE7, 0x9A, 0xAE },
	0xF9AC, { 0xE8, 0xA2, 0xAB },
	0xF9AD, { 0xE9, 0x81, 0xBF },
	0xF9AE, { 0xE9, 0x99, 0x82 },
	0xF9AF, { 0xE5, 0x8C, 0xB9 },
	0xF9B0, { 0xE5, 0xBC, 0xBC },
	0xF9B1, { 0xE5, 0xBF, 0x85 },
	0xF9B2, { 0xE6, 0xB3, 0x8C },
	0xF9B3, { 0xE7, 0x8F, 0x8C },
	0xF9B4, { 0xE7, 0x95, 0xA2 },
	0xF9B5, { 0xE7, 0x96, 0x8B },
	0xF9B6, { 0xE7, 0xAD, 0x86 },
	0xF9B7, { 0xE8, 0x8B, 0xBE },
	0xF9B8, { 0xE9, 0xA6, 0x9D },
	0xF9B9, { 0xE4, 0xB9, 0x8F },
	0xF9BA, { 0xE9, 0x80, 0xBC },
	0xF9BB, { 0xE4, 0xB8, 0x8B },
	0xF9BC, { 0xE4, 0xBD, 0x95 },
	0xF9BD, { 0xE5, 0x8E, 0xA6 },
	0xF9BE, { 0xE5, 0xA4, 0x8F },
	0xF9BF, { 0xE5, 0xBB, 0x88 },
	0xF9C0, { 0xE6, 0x98, 0xB0 },
	0xF9C1, { 0xE6, 0xB2, 0xB3 },
	0xF9C2, { 0xE7, 0x91, 0x95 },
	0xF9C3, { 0xE8, 0x8D, 0xB7 },
	0xF9C4, { 0xE8, 0x9D, 0xA6 },
	0xF9C5, { 0xE8, 0xB3, 0x80 },
	0xF9C6, { 0xE9, 0x81, 0x90 },
	0xF9C7, { 0xE9, 0x9C, 0x9E },
	0xF9C8, { 0xE9, 0xB0, 0x95 },
	0xF9C9, { 0xE5, 0xA3, 0x91 },
	0xF9CA, { 0xE5, 0xAD, 0xB8 },
	0xF9CB, { 0xE8, 0x99, 0x90 },
	0xF9CC, { 0xE8, 0xAC, 0x94 },
	0xF9CD, { 0xE9, 0xB6, 0xB4 },
	0xF9CE, { 0xE5, 0xAF, 0x92 },
	0xF9CF, { 0xE6, 0x81, 0xA8 },
	0xF9D0, { 0xE6, 0x82, 0x8D },
	0xF9D1, { 0xE6, 0x97, 0xB1 },
	0xF9D2, { 0xE6, 0xB1, 0x97 },
	0xF9D3, { 0xE6, 0xBC, 0xA2 },
	0xF9D4, { 0xE6, 0xBE, 0xA3 },
	0xF9D5, { 0xE7, 0x80, 0x9A },
	0xF9D6, { 0xE7, 0xBD, 0x95 },
	0xF9D7, { 0xE7, 0xBF, 0xB0 },
	0xF9D8, { 0xE9, 0x96, 0x91 },
	0xF9D9, { 0xE9, 0x96, 0x92 },
	0xF9DA, { 0xE9, 0x99, 0x90 },
	0xF9DB, { 0xE9, 0x9F, 0x93 },
	0xF9DC, { 0xE5, 0x89, 0xB2 },
	0xF9DD, { 0xE8, 0xBD, 0x84 },
	0xF9DE, { 0xE5, 0x87, 0xBD },
	0xF9DF, { 0xE5, 0x90, 0xAB },
	0xF9E0, { 0xE5, 0x92, 0xB8 },
	0xF9E1, { 0xE5, 0x95, 0xA3 },
	0xF9E2, { 0xE5, 0x96, 0x8A },
	0xF9E3, { 0xE6, 0xAA, 0xBB },
	0xF9E4, { 0xE6, 0xB6, 0xB5 },
	0xF9E5, { 0xE7, 0xB7, 0x98 },
	0xF9E6, { 0xE8, 0x89, 0xA6 },
	0xF9E7, { 0xE9, 0x8A, 0x9C },
	0xF9E8, { 0xE9, 0x99, 0xB7 },
	0xF9E9, { 0xE9, 0xB9, 0xB9 },
	0xF9EA, { 0xE5, 0x90, 0x88 },
	0xF9EB, { 0xE5, 0x93, 0x88 },
	0xF9EC, { 0xE7, 0x9B, 0x92 },
	0xF9ED, { 0xE8, 0x9B, 0xA4 },
	0xF9EE, { 0xE9, 0x96, 0xA4 },
	0xF9EF, { 0xE9, 0x97, 0x94 },
	0xF9F0, { 0xE9, 0x99, 0x9C },
	0xF9F1, { 0xE4, 0xBA, 0xA2 },
	0xF9F2, { 0xE4, 0xBC, 0x89 },
	0xF9F3, { 0xE5, 0xA7, 0xAE },
	0xF9F4, { 0xE5, 0xAB, 0xA6 },
	0xF9F5, { 0xE5, 0xB7, 0xB7 },
	0xF9F6, { 0xE6, 0x81, 0x92 },
	0xF9F7, { 0xE6, 0x8A, 0x97 },
	0xF9F8, { 0xE6, 0x9D, 0xAD },
	0xF9F9, { 0xE6, 0xA1, 0x81 },
	0xF9FA, { 0xE6, 0xB2, 0x86 },
	0xF9FB, { 0xE6, 0xB8, 0xAF },
	0xF9FC, { 0xE7, 0xBC, 0xB8 },
	0xF9FD, { 0xE8, 0x82, 0x9B },
	0xF9FE, { 0xE8, 0x88, 0xAA },
	0xFAA1, { 0xEF, 0xA8, 0x88 },
	0xFAA2, { 0xEF, 0xA8, 0x89 },
	0xFAA3, { 0xE9, 0xA0, 0x85 },
	0xFAA4, { 0xE4, 0xBA, 0xA5 },
	0xFAA5, { 0xE5, 0x81, 0x95 },
	0xFAA6, { 0xE5, 0x92, 0xB3 },
	0xFAA7, { 0xE5, 0x9E, 0x93 },
	0xFAA8, { 0xE5, 0xA5, 0x9A },
	0xFAA9, { 0xE5, 0xAD, 0xA9 },
	0xFAAA, { 0xE5, 0xAE, 0xB3 },
	0xFAAB, { 0xE6, 0x87, 0x88 },
	0xFAAC, { 0xE6, 0xA5, 0xB7 },
	0xFAAD, { 0xE6, 0xB5, 0xB7 },
	0xFAAE, { 0xE7, 0x80, 0xA3 },
	0xFAAF, { 0xE8, 0x9F, 0xB9 },
	0xFAB0, { 0xE8, 0xA7, 0xA3 },
	0xFAB1, { 0xE8, 0xA9, 0xB2 },
	0xFAB2, { 0xE8, 0xAB, 0xA7 },
	0xFAB3, { 0xE9, 0x82, 0x82 },
	0xFAB4, { 0xE9, 0xA7, 0xAD },
	0xFAB5, { 0xE9, 0xAA, 0xB8 },
	0xFAB6, { 0xE5, 0x8A, 0xBE },
	0xFAB7, { 0xE6, 0xA0, 0xB8 },
	0xFAB8, { 0xE5, 0x80, 0x96 },
	0xFAB9, { 0xE5, 0xB9, 0xB8 },
	0xFABA, { 0xE6, 0x9D, 0x8F },
	0xFABB, { 0xE8, 0x8D, 0x87 },
	0xFABC, { 0xE8, 0xA1, 0x8C },
	0xFABD, { 0xE4, 0xBA, 0xAB },
	0xFABE, { 0xE5, 0x90, 0x91 },
	0xFABF, { 0xE5, 0x9A, 0xAE },
	0xFAC0, { 0xE7, 0x8F, 0xA6 },
	0xFAC1, { 0xE9, 0x84, 0x95 },
	0xFAC2, { 0xE9, 0x9F, 0xBF },
	0xFAC3, { 0xE9, 0xA4, 0x89 },
	0xFAC4, { 0xE9, 0xA5, 0x97 },
	0xFAC5, { 0xE9, 0xA6, 0x99 },
	0xFAC6, { 0xE5, 0x99, 0x93 },
	0xFAC7, { 0xE5, 0xA2, 0x9F },
	0xFAC8, { 0xE8, 0x99, 0x9B },
	0xFAC9, { 0xE8, 0xA8, 0xB1 },
	0xFACA, { 0xE6, 0x86, 0xB2 },
	0xFACB, { 0xE6, 0xAB, 0xB6 },
	0xFACC, { 0xE7, 0x8D, 0xBB },
	0xFACD, { 0xE8, 0xBB, 0x92 },
	0xFACE, { 0xE6, 0xAD, 0x87 },
	0xFACF, { 0xE9, 0x9A, 0xAA },
	0xFAD0, { 0xE9, 0xA9, 0x97 },
	0xFAD1, { 0xE5, 0xA5, 0x95 },
	0xFAD2, { 0xE7, 0x88, 0x80 },
	0xFAD3, { 0xE8, 0xB5, 0xAB },
	0xFAD4, { 0xE9, 0x9D, 0xA9 },
	0xFAD5, { 0xE4, 0xBF, 0x94 },
	0xFAD6, { 0xE5, 0xB3, 0xB4 },
	0xFAD7, { 0xE5, 0xBC, 0xA6 },
	0xFAD8, { 0xE6, 0x87, 0xB8 },
	0xFAD9, { 0xE6, 0x99, 0x9B },
	0xFADA, { 0xE6, 0xB3, 0xAB },
	0xFADB, { 0xE7, 0x82, 0xAB },
	0xFADC, { 0xE7, 0x8E, 0x84 },
	0xFADD, { 0xE7, 0x8E, 0xB9 },
	0xFADE, { 0xE7, 0x8F, 0xBE },
	0xFADF, { 0xE7, 0x9C, 0xA9 },
	0xFAE0, { 0xE7, 0x9D, 0x8D },
	0xFAE1, { 0xE7, 0xB5, 0x83 },
	0xFAE2, { 0xE7, 0xB5, 0xA2 },
	0xFAE3, { 0xE7, 0xB8, 0xA3 },
	0xFAE4, { 0xE8, 0x88, 0xB7 },
	0xFAE5, { 0xE8, 0xA1, 0x92 },
	0xFAE6, { 0xEF, 0xA8, 0x8A },
	0xFAE7, { 0xE8, 0xB3, 0xA2 },
	0xFAE8, { 0xE9, 0x89, 0x89 },
	0xFAE9, { 0xE9, 0xA1, 0xAF },
	0xFAEA, { 0xE5, 0xAD, 0x91 },
	0xFAEB, { 0xE7, 0xA9, 0xB4 },
	0xFAEC, { 0xE8, 0xA1, 0x80 },
	0xFAED, { 0xE9, 0xA0, 0x81 },
	0xFAEE, { 0xE5, 0xAB, 0x8C },
	0xFAEF, { 0xE4, 0xBF, 0xA0 },
	0xFAF0, { 0xE5, 0x8D, 0x94 },
	0xFAF1, { 0xE5, 0xA4, 0xBE },
	0xFAF2, { 0xE5, 0xB3, 0xBD },
	0xFAF3, { 0xE6, 0x8C, 0xBE },
	0xFAF4, { 0xE6, 0xB5, 0xB9 },
	0xFAF5, { 0xE7, 0x8B, 0xB9 },
	0xFAF6, { 0xE8, 0x84, 0x85 },
	0xFAF7, { 0xE8, 0x84, 0x87 },
	0xFAF8, { 0xE8, 0x8E, 0xA2 },
	0xFAF9, { 0xE9, 0x8B, 0x8F },
	0xFAFA, { 0xE9, 0xA0, 0xB0 },
	0xFAFB, { 0xE4, 0xBA, 0xA8 },
	0xFAFC, { 0xE5, 0x85, 0x84 },
	0xFAFD, { 0xE5, 0x88, 0x91 },
	0xFAFE, { 0xE5, 0x9E, 0x8B },
	0xFBA1, { 0xE5, 0xBD, 0xA2 },
	0xFBA2, { 0xE6, 0xB3, 0x82 },
	0xFBA3, { 0xE6, 0xBB, 0x8E },
	0xFBA4, { 0xE7, 0x80, 0x85 },
	0xFBA5, { 0xE7, 0x81, 0x90 },
	0xFBA6, { 0xE7, 0x82, 0xAF },
	0xFBA7, { 0xE7, 0x86, 0x92 },
	0xFBA8, { 0xE7, 0x8F, 0xA9 },
	0xFBA9, { 0xE7, 0x91, 0xA9 },
	0xFBAA, { 0xE8, 0x8D, 0x8A },
	0xFBAB, { 0xE8, 0x9E, 0xA2 },
	0xFBAC, { 0xE8, 0xA1, 0xA1 },
	0xFBAD, { 0xE9, 0x80, 0x88 },
	0xFBAE, { 0xE9, 0x82, 0xA2 },
	0xFBAF, { 0xE9, 0x8E, 0xA3 },
	0xFBB0, { 0xE9, 0xA6, 0xA8 },
	0xFBB1, { 0xE5, 0x85, 0xAE },
	0xFBB2, { 0xE5, 0xBD, 0x97 },
	0xFBB3, { 0xE6, 0x83, 0xA0 },
	0xFBB4, { 0xE6, 0x85, 0xA7 },
	0xFBB5, { 0xE6, 0x9A, 0xB3 },
	0xFBB6, { 0xE8, 0x95, 0x99 },
	0xFBB7, { 0xE8, 0xB9, 0x8A },
	0xFBB8, { 0xE9, 0x86, 0xAF },
	0xFBB9, { 0xE9, 0x9E, 0x8B },
	0xFBBA, { 0xE4, 0xB9, 0x8E },
	0xFBBB, { 0xE4, 0xBA, 0x92 },
	0xFBBC, { 0xE5, 0x91, 0xBC },
	0xFBBD, { 0xE5, 0xA3, 0x95 },
	0xFBBE, { 0xE5, 0xA3, 0xBA },
	0xFBBF, { 0xE5, 0xA5, 0xBD },
	0xFBC0, { 0xE5, 0xB2, 0xB5 },
	0xFBC1, { 0xE5, 0xBC, 0xA7 },
	0xFBC2, { 0xE6, 0x88, 0xB6 },
	0xFBC3, { 0xE6, 0x89, 0x88 },
	0xFBC4, { 0xE6, 0x98, 0x8A },
	0xFBC5, { 0xE6, 0x99, 0xA7 },
	0xFBC6, { 0xE6, 0xAF, 0xAB },
	0xFBC7, { 0xE6, 0xB5, 0xA9 },
	0xFBC8, { 0xE6, 0xB7, 0x8F },
	0xFBC9, { 0xE6, 0xB9, 0x96 },
	0xFBCA, { 0xE6, 0xBB, 0xB8 },
	0xFBCB, { 0xE6, 0xBE, 0x94 },
	0xFBCC, { 0xE6, 0xBF, 0xA0 },
	0xFBCD, { 0xE6, 0xBF, 0xA9 },
	0xFBCE, { 0xE7, 0x81, 0x9D },
	0xFBCF, { 0xE7, 0x8B, 0x90 },
	0xFBD0, { 0xE7, 0x90, 0xA5 },
	0xFBD1, { 0xE7, 0x91, 0x9A },
	0xFBD2, { 0xE7, 0x93, 0xA0 },
	0xFBD3, { 0xE7, 0x9A, 0x93 },
	0xFBD4, { 0xE7, 0xA5, 0x9C },
	0xFBD5, { 0xE7, 0xB3, 0x8A },
	0xFBD6, { 0xE7, 0xB8, 0x9E },
	0xFBD7, { 0xE8, 0x83, 0xA1 },
	0xFBD8, { 0xE8, 0x8A, 0xA6 },
	0xFBD9, { 0xE8, 0x91, 0xAB },
	0xFBDA, { 0xE8, 0x92, 0xBF },
	0xFBDB, { 0xE8, 0x99, 0x8E },
	0xFBDC, { 0xE8, 0x99, 0x9F },
	0xFBDD, { 0xE8, 0x9D, 0xB4 },
	0xFBDE, { 0xE8, 0xAD, 0xB7 },
	0xFBDF, { 0xE8, 0xB1, 0xAA },
	0xFBE0, { 0xE9, 0x8E, 0xAC },
	0xFBE1, { 0xE9, 0xA0, 0x80 },
	0xFBE2, { 0xE9, 0xA1, 0xA5 },
	0xFBE3, { 0xE6, 0x83, 0x91 },
	0xFBE4, { 0xE6, 0x88, 0x96 },
	0xFBE5, { 0xE9, 0x85, 0xB7 },
	0xFBE6, { 0xE5, 0xA9, 0x9A },
	0xFBE7, { 0xE6, 0x98, 0x8F },
	0xFBE8, { 0xE6, 0xB7, 0xB7 },
	0xFBE9, { 0xE6, 0xB8, 0xBE },
	0xFBEA, { 0xE7, 0x90, 0xBF },
	0xFBEB, { 0xE9, 0xAD, 0x82 },
	0xFBEC, { 0xE5, 0xBF, 0xBD },
	0xFBED, { 0xE6, 0x83, 0x9A },
	0xFBEE, { 0xE7, 0xAC, 0x8F },
	0xFBEF, { 0xE5, 0x93, 0x84 },
	0xFBF0, { 0xE5, 0xBC, 0x98 },
	0xFBF1, { 0xE6, 0xB1, 0x9E },
	0xFBF2, { 0xE6, 0xB3, 0x93 },
	0xFBF3, { 0xE6, 0xB4, 0xAA },
	0xFBF4, { 0xE7, 0x83, 0x98 },
	0xFBF5, { 0xE7, 0xB4, 0x85 },
	0xFBF6, { 0xE8, 0x99, 0xB9 },
	0xFBF7, { 0xE8, 0xA8, 0x8C },
	0xFBF8, { 0xE9, 0xB4, 0xBB },
	0xFBF9, { 0xE5, 0x8C, 0x96 },
	0xFBFA, { 0xE5, 0x92, 0x8C },
	0xFBFB, { 0xE5, 0xAC, 0x85 },
	0xFBFC, { 0xE6, 0xA8, 0xBA },
	0xFBFD, { 0xE7, 0x81, 0xAB },
	0xFBFE, { 0xE7, 0x95, 0xB5 },
	0xFCA1, { 0xE7, 0xA6, 0x8D },
	0xFCA2, { 0xE7, 0xA6, 0xBE },
	0xFCA3, { 0xE8, 0x8A, 0xB1 },
	0xFCA4, { 0xE8, 0x8F, 0xAF },
	0xFCA5, { 0xE8, 0xA9, 0xB1 },
	0xFCA6, { 0xE8, 0xAD, 0x81 },
	0xFCA7, { 0xE8, 0xB2, 0xA8 },
	0xFCA8, { 0xE9, 0x9D, 0xB4 },
	0xFCA9, { 0xEF, 0xA8, 0x8B },
	0xFCAA, { 0xE6, 0x93, 0xB4 },
	0xFCAB, { 0xE6, 0x94, 0xAB },
	0xFCAC, { 0xE7, 0xA2, 0xBA },
	0xFCAD, { 0xE7, 0xA2, 0xBB },
	0xFCAE, { 0xE7, 0xA9, 0xAB },
	0xFCAF, { 0xE4, 0xB8, 0xB8 },
	0xFCB0, { 0xE5, 0x96, 0x9A },
	0xFCB1, { 0xE5, 0xA5, 0x90 },
	0xFCB2, { 0xE5, 0xAE, 0xA6 },
	0xFCB3, { 0xE5, 0xB9, 0xBB },
	0xFCB4, { 0xE6, 0x82, 0xA3 },
	0xFCB5, { 0xE6, 0x8F, 0x9B },
	0xFCB6, { 0xE6, 0xAD, 0xA1 },
	0xFCB7, { 0xE6, 0x99, 0xA5 },
	0xFCB8, { 0xE6, 0xA1, 0x93 },
	0xFCB9, { 0xE6, 0xB8, 0x99 },
	0xFCBA, { 0xE7, 0x85, 0xA5 },
	0xFCBB, { 0xE7, 0x92, 0xB0 },
	0xFCBC, { 0xE7, 0xB4, 0x88 },
	0xFCBD, { 0xE9, 0x82, 0x84 },
	0xFCBE, { 0xE9, 0xA9, 0xA9 },
	0xFCBF, { 0xE9, 0xB0, 0xA5 },
	0xFCC0, { 0xE6, 0xB4, 0xBB },
	0xFCC1, { 0xE6, 0xBB, 0x91 },
	0xFCC2, { 0xE7, 0x8C, 0xBE },
	0xFCC3, { 0xE8, 0xB1, 0x81 },
	0xFCC4, { 0xE9, 0x97, 0x8A },
	0xFCC5, { 0xE5, 0x87, 0xB0 },
	0xFCC6, { 0xE5, 0xB9, 0x8C },
	0xFCC7, { 0xE5, 0xBE, 0xA8 },
	0xFCC8, { 0xE6, 0x81, 0x8D },
	0xFCC9, { 0xE6, 0x83, 0xB6 },
	0xFCCA, { 0xE6, 0x84, 0xB0 },
	0xFCCB, { 0xE6, 0x85, 0x8C },
	0xFCCC, { 0xE6, 0x99, 0x83 },
	0xFCCD, { 0xE6, 0x99, 0x84 },
	0xFCCE, { 0xE6, 0xA6, 0xA5 },
	0xFCCF, { 0xE6, 0xB3, 0x81 },
	0xFCD0, { 0xE6, 0xB9, 0x9F },
	0xFCD1, { 0xE6, 0xBB, 0x89 },
	0xFCD2, { 0xE6, 0xBD, 0xA2 },
	0xFCD3, { 0xE7, 0x85, 0x8C },
	0xFCD4, { 0xE7, 0x92, 0x9C },
	0xFCD5, { 0xE7, 0x9A, 0x87 },
	0xFCD6, { 0xE7, 0xAF, 0x81 },
	0xFCD7, { 0xE7, 0xB0, 0xA7 },
	0xFCD8, { 0xE8, 0x8D, 0x92 },
	0xFCD9, { 0xE8, 0x9D, 0x97 },
	0xFCDA, { 0xE9, 0x81, 0x91 },
	0xFCDB, { 0xE9, 0x9A, 0x8D },
	0xFCDC, { 0xE9, 0xBB, 0x83 },
	0xFCDD, { 0xE5, 0x8C, 0xAF },
	0xFCDE, { 0xE5, 0x9B, 0x9E },
	0xFCDF, { 0xE5, 0xBB, 0xBB },
	0xFCE0, { 0xE5, 0xBE, 0x8A },
	0xFCE1, { 0xE6, 0x81, 0xA2 },
	0xFCE2, { 0xE6, 0x82, 0x94 },
	0xFCE3, { 0xE6, 0x87, 0xB7 },
	0xFCE4, { 0xE6, 0x99, 0xA6 },
	0xFCE5, { 0xE6, 0x9C, 0x83 },
	0xFCE6, { 0xE6, 0xAA, 0x9C },
	0xFCE7, { 0xE6, 0xB7, 0xAE },
	0xFCE8, { 0xE6, 0xBE, 0xAE },
	0xFCE9, { 0xE7, 0x81, 0xB0 },
	0xFCEA, { 0xE7, 0x8D, 0xAA },
	0xFCEB, { 0xE7, 0xB9, 0xAA },
	0xFCEC, { 0xE8, 0x86, 0xBE },
	0xFCED, { 0xE8, 0x8C, 0xB4 },
	0xFCEE, { 0xE8, 0x9B, 0x94 },
	0xFCEF, { 0xE8, 0xAA, 0xA8 },
	0xFCF0, { 0xE8, 0xB3, 0x84 },
	0xFCF1, { 0xE5, 0x8A, 0x83 },
	0xFCF2, { 0xE7, 0x8D, 0xB2 },
	0xFCF3, { 0xE5, 0xAE, 0x96 },
	0xFCF4, { 0xE6, 0xA9, 0xAB },
	0xFCF5, { 0xE9, 0x90, 0x84 },
	0xFCF6, { 0xE5, 0x93, 0xAE },
	0xFCF7, { 0xE5, 0x9A, 0x86 },
	0xFCF8, { 0xE5, 0xAD, 0x9D },
	0xFCF9, { 0xE6, 0x95, 0x88 },
	0xFCFA, { 0xE6, 0x96, 0x85 },
	0xFCFB, { 0xE6, 0x9B, 0x89 },
	0xFCFC, { 0xE6, 0xA2, 0x9F },
	0xFCFD, { 0xE6, 0xB6, 0x8D },
	0xFCFE, { 0xE6, 0xB7, 0x86 },
	0xFDA1, { 0xE7, 0x88, 0xBB },
	0xFDA2, { 0xE8, 0x82, 0xB4 },
	0xFDA3, { 0xE9, 0x85, 0xB5 },
	0xFDA4, { 0xE9, 0xA9, 0x8D },
	0xFDA5, { 0xE4, 0xBE, 0xAF },
	0xFDA6, { 0xE5, 0x80, 0x99 },
	0xFDA7, { 0xE5, 0x8E, 0x9A },
	0xFDA8, { 0xE5, 0x90, 0x8E },
	0xFDA9, { 0xE5, 0x90, 0xBC },
	0xFDAA, { 0xE5, 0x96, 0x89 },
	0xFDAB, { 0xE5, 0x97, 0x85 },
	0xFDAC, { 0xE5, 0xB8, 0xBF },
	0xFDAD, { 0xE5, 0xBE, 0x8C },
	0xFDAE, { 0xE6, 0x9C, 0xBD },
	0xFDAF, { 0xE7, 0x85, 0xA6 },
	0xFDB0, { 0xE7, 0x8F, 0x9D },
	0xFDB1, { 0xE9, 0x80, 0x85 },
	0xFDB2, { 0xE5, 0x8B, 0x9B },
	0xFDB3, { 0xE5, 0x8B, 0xB3 },
	0xFDB4, { 0xE5, 0xA1, 0xA4 },
	0xFDB5, { 0xE5, 0xA3, 0x8E },
	0xFDB6, { 0xE7, 0x84, 0x84 },
	0xFDB7, { 0xE7, 0x86, 0x8F },
	0xFDB8, { 0xE7, 0x87, 0xBB },
	0xFDB9, { 0xE8, 0x96, 0xB0 },
	0xFDBA, { 0xE8, 0xA8, 0x93 },
	0xFDBB, { 0xE6, 0x9A, 0x88 },
	0xFDBC, { 0xE8, 0x96, 0xA8 },
	0xFDBD, { 0xE5, 0x96, 0xA7 },
	0xFDBE, { 0xE6, 0x9A, 0x84 },
	0xFDBF, { 0xE7, 0x85, 0x8A },
	0xFDC0, { 0xE8, 0x90, 0xB1 },
	0xFDC1, { 0xE5, 0x8D, 0x89 },
	0xFDC2, { 0xE5, 0x96, 0x99 },
	0xFDC3, { 0xE6, 0xAF, 0x81 },
	0xFDC4, { 0xE5, 0xBD, 0x99 },
	0xFDC5, { 0xE5, 0xBE, 0xBD },
	0xFDC6, { 0xE6, 0x8F, 0xAE },
	0xFDC7, { 0xE6, 0x9A, 0x89 },
	0xFDC8, { 0xE7, 0x85, 0x87 },
	0xFDC9, { 0xE8, 0xAB, 0xB1 },
	0xFDCA, { 0xE8, 0xBC, 0x9D },
	0xFDCB, { 0xE9, 0xBA, 0xBE },
	0xFDCC, { 0xE4, 0xBC, 0x91 },
	0xFDCD, { 0xE6, 0x90, 0xBA },
	0xFDCE, { 0xE7, 0x83, 0x8B },
	0xFDCF, { 0xE7, 0x95, 0xA6 },
	0xFDD0, { 0xE8, 0x99, 0xA7 },
	0xFDD1, { 0xE6, 0x81, 0xA4 },
	0xFDD2, { 0xE8, 0xAD, 0x8E },
	0xFDD3, { 0xE9, 0xB7, 0xB8 },
	0xFDD4, { 0xE5, 0x85, 0x87 },
	0xFDD5, { 0xE5, 0x87, 0xB6 },
	0xFDD6, { 0xE5, 0x8C, 0x88 },
	0xFDD7, { 0xE6, 0xB4, 0xB6 },
	0xFDD8, { 0xE8, 0x83, 0xB8 },
	0xFDD9, { 0xE9, 0xBB, 0x91 },
	0xFDDA, { 0xE6, 0x98, 0x95 },
	0xFDDB, { 0xE6, 0xAC, 0xA3 },
	0xFDDC, { 0xE7, 0x82, 0x98 },
	0xFDDD, { 0xE7, 0x97, 0x95 },
	0xFDDE, { 0xE5, 0x90, 0x83 },
	0xFDDF, { 0xE5, 0xB1, 0xB9 },
	0xFDE0, { 0xE7, 0xB4, 0x87 },
	0xFDE1, { 0xE8, 0xA8, 0x96 },
	0xFDE2, { 0xE6, 0xAC, 0xA0 },
	0xFDE3, { 0xE6, 0xAC, 0xBD },
	0xFDE4, { 0xE6, 0xAD, 0x86 },
	0xFDE5, { 0xE5, 0x90, 0xB8 },
	0xFDE6, { 0xE6, 0x81, 0xB0 },
	0xFDE7, { 0xE6, 0xB4, 0xBD },
	0xFDE8, { 0xE7, 0xBF, 0x95 },
	0xFDE9, { 0xE8, 0x88, 0x88 },
	0xFDEA, { 0xE5, 0x83, 0x96 },
	0xFDEB, { 0xE5, 0x87, 0x9E },
	0xFDEC, { 0xE5, 0x96, 0x9C },
	0xFDED, { 0xE5, 0x99, 0xAB },
	0xFDEE, { 0xE5, 0x9B, 0x8D },
	0xFDEF, { 0xE5, 0xA7, 0xAC },
	0xFDF0, { 0xE5, 0xAC, 0x89 },
	0xFDF1, { 0xE5, 0xB8, 0x8C },
	0xFDF2, { 0xE6, 0x86, 0x99 },
	0xFDF3, { 0xE6, 0x86, 0x98 },
	0xFDF4, { 0xE6, 0x88, 0xB1 },
	0xFDF5, { 0xE6, 0x99, 0x9E },
	0xFDF6, { 0xE6, 0x9B, 0xA6 },
	0xFDF7, { 0xE7, 0x86, 0x99 },
	0xFDF8, { 0xE7, 0x86, 0xB9 },
	0xFDF9, { 0xE7, 0x86, 0xBA },
	0xFDFA, { 0xE7, 0x8A, 0xA7 },
	0xFDFB, { 0xE7, 0xA6, 0xA7 },
	0xFDFC, { 0xE7, 0xA8, 0x80 },
	0xFDFD, { 0xE7, 0xBE, 0xB2 },
	0xFDFE, { 0xE8, 0xA9, 0xB0 }
};

#endif	/* _KERNEL */

#ifdef __cplusplus
}
#endif

#endif	/* _SYS_KICONV_UHC_UTF8_H */
