/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2009 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef	_SYS_FM_CPU_GMCA_H
#define	_SYS_FM_CPU_GMCA_H

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Generic x86 cpu ereports.
 *
 * On a machine-check exception, or on a periodic poll for error status
 * of a cpu, we read through all the MCA banks of the processor and
 * log an ereport for each MCA bank that contains valid error telemetry.
 * These ereports will all share the same detector FMRI and ENA.
 *
 * Since we have no model-specific knowledge of the cpu we cannot
 * decode all details of the error, so we'll stick to the "architectural"
 * bits.  Similarly since we have no associated memory-controller driver
 * or detailed topology information we cannot produce "resource" ereport
 * FMRIs.
 */

/* Ereport class subcategory for generic x86 processors */
#define	FM_EREPORT_CPU_GENERIC	"generic-x86"

/*
 * Simple error code ereport leaf classes
 */
#define	FM_EREPORT_CPU_GENERIC_UNCLASSIFIED	"unclassified"
#define	FM_EREPORT_CPU_GENERIC_MC_CODE_PARITY	"microcode_rom_parity"
#define	FM_EREPORT_CPU_GENERIC_EXTERNAL		"external"
#define	FM_EREPORT_CPU_GENERIC_FRC		"frc"
#define	FM_EREPORT_CPU_GENERIC_INTERNAL_PARITY	"internal_parity"
#define	FM_EREPORT_CPU_GENERIC_INTERNAL_TIMER	"internal_timer"
#define	FM_EREPORT_CPU_GENERIC_INTERNAL_UNCLASS	"internal_unclassified"

/*
 * Leaf class to be used when we can match no simple or compound class
 */
#define	FM_EREPORT_CPU_GENERIC_UNKNOWN		"unknown"

/*
 * Compound error code ereport leaf classes.  The arguments for snprintf
 * will appear in the following order:
 *
 *	1 - TT interpretation
 *	2 - LL interpretation
 *	3 - RRRR interpretation
 *	4 - PP interpretation
 *	5 - II interpretation
 *	6 - T interpretation
 *	7 - "_uc" if this is a compound error with MCi_STATUS.UC set, else ""
 *	8 - CCCC interpretation
 *	9 - MMM interpretation
 *
 * They can be selected in the format string using the %n$s specifier form.
 *
 * The set of interpretations that we expand to will not be exactly the
 * same as the set of mnemonics described in Vol 3A (see the
 * FM_EREPORT_PAYLOAD_NAME_COMPOUND_ERR ereport payload member for that).
 * Instead we wish to compress the possible ereport classes that can
 * be generated by pushing things such as "LG" for generic cache level
 * down to "".
 *
 *
 * "Memory Hierarchy" in compound errors actually refers to CPU cache
 * memory.
 */
#define	FM_EREPORT_CPU_GENERIC_GENMEMHIER	"%2$s" "cache" "%7$s"
#define	FM_EREPORT_CPU_GENERIC_TLB		"%2$s" "%1$s" "tlb" "%7$s"
#define	FM_EREPORT_CPU_GENERIC_MEMHIER		"%2$s" "%1$s" "cache" "%7$s"
#define	FM_EREPORT_CPU_GENERIC_BUS_INTERCONNECT	"bus_interconnect" "%5$s" "%7$s"
#define	FM_EREPORT_CPU_GENERIC_MEMORY_CONTROLLER "mc"

/*
 * The "interpretation" expansions for the above ereport leaf subclasses.
 */
#define	FM_EREPORT_CPU_GENERIC_TT_INSTR		"i"
#define	FM_EREPORT_CPU_GENERIC_TT_DATA		"d"
#define	FM_EREPORT_CPU_GENERIC_TT_GEN		""

#define	FM_EREPORT_CPU_GENERIC_LL_L0		"l0"
#define	FM_EREPORT_CPU_GENERIC_LL_L1		"l1"
#define	FM_EREPORT_CPU_GENERIC_LL_L2		"l2"
#define	FM_EREPORT_CPU_GENERIC_LL_LG		""

#define	FM_EREPORT_CPU_GENERIC_RRRR_ERR		""
#define	FM_EREPORT_CPU_GENERIC_RRRR_RD		""
#define	FM_EREPORT_CPU_GENERIC_RRRR_WR		""
#define	FM_EREPORT_CPU_GENERIC_RRRR_DRD		""
#define	FM_EREPORT_CPU_GENERIC_RRRR_DWR		""
#define	FM_EREPORT_CPU_GENERIC_RRRR_IRD		""
#define	FM_EREPORT_CPU_GENERIC_RRRR_PREFETCH	""
#define	FM_EREPORT_CPU_GENERIC_RRRR_EVICT	""
#define	FM_EREPORT_CPU_GENERIC_RRRR_SNOOP	""

#define	FM_EREPORT_CPU_GENERIC_PP_SRC		""
#define	FM_EREPORT_CPU_GENERIC_PP_RES		""
#define	FM_EREPORT_CPU_GENERIC_PP_OBS		""
#define	FM_EREPORT_CPU_GENERIC_PP_GEN		""

#define	FM_EREPORT_CPU_GENERIC_II_MEM		"_memory"
#define	FM_EREPORT_CPU_GENERIC_II_IO		"_io"
#define	FM_EREPORT_CPU_GENERIC_II_GEN		""

#define	FM_EREPORT_CPU_GENERIC_T_NOTIMEOUT	""
#define	FM_EREPORT_CPU_GENERIC_T_TIMEOUT	""

#define	FM_EREPORT_CPU_GENERIC_CCCC		""

#define	FM_EREPORT_CPU_GENERIC_MMM_ERR		""
#define	FM_EREPORT_CPU_GENERIC_MMM_RD		""
#define	FM_EREPORT_CPU_GENERIC_MMM_WR		""
#define	FM_EREPORT_CPU_GENERIC_MMM_ADRCMD	""
#define	FM_EREPORT_CPU_GENERIC_MMM_SCRUB	""

/*
 * Ereport payload member names together with bitmask values to select
 * their inclusion in ereports.
 */

#define	_FM_EREPORT_FLAG(n) (1ULL << (n))

#define	FM_EREPORT_PAYLOAD_FLAG_COMPOUND_ERR _FM_EREPORT_FLAG(1)
#define	FM_EREPORT_PAYLOAD_NAME_COMPOUND_ERR	"compound_errorname"

#define	FM_EREPORT_PAYLOAD_FLAG_MCG_STATUS _FM_EREPORT_FLAG(2)
#define	FM_EREPORT_PAYLOAD_NAME_MCG_STATUS	"IA32_MCG_STATUS"
#define	FM_EREPORT_PAYLOAD_NAME_MCG_STATUS_MCIP	"machine_check_in_progress"

#define	FM_EREPORT_PAYLOAD_FLAG_IP _FM_EREPORT_FLAG(3)
#define	FM_EREPORT_PAYLOAD_NAME_IP		"ip"

#define	FM_EREPORT_PAYLOAD_FLAG_PRIV _FM_EREPORT_FLAG(4)
#define	FM_EREPORT_PAYLOAD_NAME_PRIV		"privileged"

#define	FM_EREPORT_PAYLOAD_FLAG_BANK_NUM _FM_EREPORT_FLAG(5)
#define	FM_EREPORT_PAYLOAD_NAME_BANK_NUM	"bank_number"
#define	FM_EREPORT_PAYLOAD_NAME_BANK_MSR_OFFSET	"bank_msr_offset"

#define	FM_EREPORT_PAYLOAD_FLAG_MC_STATUS _FM_EREPORT_FLAG(6)
#define	FM_EREPORT_PAYLOAD_NAME_MC_STATUS	"IA32_MCi_STATUS"
#define	FM_EREPORT_PAYLOAD_NAME_MC_STATUS_OVER	"overflow"
#define	FM_EREPORT_PAYLOAD_NAME_MC_STATUS_UC	"error_uncorrected"
#define	FM_EREPORT_PAYLOAD_NAME_MC_STATUS_EN	"error_enabled"
#define	FM_EREPORT_PAYLOAD_NAME_MC_STATUS_PCC	"processor_context_corrupt"
#define	FM_EREPORT_PAYLOAD_NAME_MC_STATUS_TES	"threshold_based_error_status"
#define	FM_EREPORT_PAYLOAD_NAME_MC_STATUS_ERRCODE "error_code"
#define	FM_EREPORT_PAYLOAD_NAME_MC_STATUS_EXTERRCODE "model_specific_error_code"

#define	FM_EREPORT_PAYLOAD_FLAG_MC_ADDR _FM_EREPORT_FLAG(7)
#define	FM_EREPORT_PAYLOAD_NAME_MC_ADDR		"IA32_MCi_ADDR"

#define	FM_EREPORT_PAYLOAD_FLAG_MC_MISC _FM_EREPORT_FLAG(8)
#define	FM_EREPORT_PAYLOAD_NAME_MC_MISC		"IA32_MCi_MISC"

#define	FM_EREPORT_PAYLOAD_FLAG_DISP	_FM_EREPORT_FLAG(9)
#define	FM_EREPORT_PAYLOAD_NAME_DISP		"disp"

/*
 * Common combinations of payload members
 */
#define	FM_EREPORT_PAYLOAD_FLAGS_GLOBAL \
	(FM_EREPORT_PAYLOAD_FLAG_MCG_STATUS | \
	FM_EREPORT_PAYLOAD_FLAG_IP | \
	FM_EREPORT_PAYLOAD_FLAG_PRIV)

#define	FM_EREPORT_PAYLOAD_FLAGS_BANK \
	(FM_EREPORT_PAYLOAD_FLAG_BANK_NUM | \
	FM_EREPORT_PAYLOAD_FLAG_MC_STATUS | \
	FM_EREPORT_PAYLOAD_FLAG_MC_ADDR | \
	FM_EREPORT_PAYLOAD_FLAG_MC_MISC | \
	FM_EREPORT_PAYLOAD_FLAG_DISP)

#define	FM_EREPORT_PAYLOAD_FLAGS_COMMON \
	(FM_EREPORT_PAYLOAD_FLAGS_GLOBAL | FM_EREPORT_PAYLOAD_FLAGS_BANK)

#define	FM_EREPORT_PAYLOAD_FLAGS_COMPOUND_ERR \
	(FM_EREPORT_PAYLOAD_FLAGS_COMMON | FM_EREPORT_PAYLOAD_FLAG_COMPOUND_ERR)

#ifdef __cplusplus
}
#endif

#endif /* _SYS_FM_CPU_GMCA_H */
