/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2009 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */


#ifndef _SYS_PX_REGS_H
#define	_SYS_PX_REGS_H


#ifdef	__cplusplus
extern "C" {
#endif

/* Register tools history */
#pragma ident	"@(#)hdgen	1.3	03/11/10"
#pragma	ident	"@(#)firedefiner.pl	1.7	03/11/19"

/* jcs.csr  JCS module defines */

#define	JCS_CSR_BASE	0x000000
#define	JBUS_DEVICE_ID	0x0
#define	JBUS_DEVICE_ID_COOKIE	56
#define	JBUS_DEVICE_ID_COOKIE_MASK	0xff
#define	JBUS_DEVICE_ID_JVPORT	27
#define	JBUS_DEVICE_ID_JVPORT_MASK	0x7f
#define	JBUS_DEVICE_ID_JPID_4	  21
#define	JBUS_DEVICE_ID_JPID_3_0	17
#define	JBUS_DEVICE_ID_JPID_3_0_MASK	0xf
#define	JBUS_DEVICE_ID_M_S	  16
#define	JBUS_DEVICE_ID_MID	10
#define	JBUS_DEVICE_ID_MID_MASK	0x3f
#define	JBUS_DEVICE_ID_MT	4
#define	JBUS_DEVICE_ID_MT_MASK	0x3f
#define	JBUS_DEVICE_ID_MR	0
#define	JBUS_DEVICE_ID_MR_MASK	0xf
#define	EBUS_OFFSET_BASE	0x400020
#define	EBUS_OFFSET_BASE_V	  63
#define	EBUS_OFFSET_BASE_BASE	24
#define	EBUS_OFFSET_BASE_BASE_MASK	0xfff
#define	EBUS_OFFSET_MASK	0x400028
#define	EBUS_OFFSET_MASK_MASK_HI	36
#define	EBUS_OFFSET_MASK_MASK_HI_MASK	0x7f
#define	EBUS_OFFSET_MASK_MASK	24
#define	EBUS_OFFSET_MASK_MASK_MASK	0xfff
#define	PCIE_A_MEM32_OFFSET_BASE	0x400040
#define	PCIE_A_MEM32_OFFSET_BASE_V	  63
#define	PCIE_A_MEM32_OFFSET_BASE_BASE	24
#define	PCIE_A_MEM32_OFFSET_BASE_BASE_MASK	0xfff
#define	PCIE_A_MEM32_OFFSET_MASK	0x400048
#define	PCIE_A_MEM32_OFFSET_MASK_MASK_HI	36
#define	PCIE_A_MEM32_OFFSET_MASK_MASK_HI_MASK	0x7f
#define	PCIE_A_MEM32_OFFSET_MASK_MASK	24
#define	PCIE_A_MEM32_OFFSET_MASK_MASK_MASK	0xfff
#define	PCIE_A_CFG_IO_OFFSET_BASE	0x400050
#define	PCIE_A_CFG_IO_OFFSET_BASE_V	  63
#define	PCIE_A_CFG_IO_OFFSET_BASE_BASE	24
#define	PCIE_A_CFG_IO_OFFSET_BASE_BASE_MASK	0xfff
#define	PCIE_A_CFG_IO_OFFSET_MASK	0x400058
#define	PCIE_A_CFG_IO_OFFSET_MASK_MASK_HI	36
#define	PCIE_A_CFG_IO_OFFSET_MASK_MASK_HI_MASK	0x7f
#define	PCIE_A_CFG_IO_OFFSET_MASK_MASK	24
#define	PCIE_A_CFG_IO_OFFSET_MASK_MASK_MASK	0xfff
#define	PCIE_B_MEM32_OFFSET_BASE	0x400060
#define	PCIE_B_MEM32_OFFSET_BASE_V	  63
#define	PCIE_B_MEM32_OFFSET_BASE_BASE	24
#define	PCIE_B_MEM32_OFFSET_BASE_BASE_MASK	0xfff
#define	PCIE_B_MEM32_OFFSET_MASK	0x400068
#define	PCIE_B_MEM32_OFFSET_MASK_MASK_HI	36
#define	PCIE_B_MEM32_OFFSET_MASK_MASK_HI_MASK	0x7f
#define	PCIE_B_MEM32_OFFSET_MASK_MASK	24
#define	PCIE_B_MEM32_OFFSET_MASK_MASK_MASK	0xfff
#define	PCIE_B_CFG_IO_OFFSET_BASE	0x400070
#define	PCIE_B_CFG_IO_OFFSET_BASE_V	  63
#define	PCIE_B_CFG_IO_OFFSET_BASE_BASE	24
#define	PCIE_B_CFG_IO_OFFSET_BASE_BASE_MASK	0xfff
#define	PCIE_B_CFG_IO_OFFSET_MASK	0x400078
#define	PCIE_B_CFG_IO_OFFSET_MASK_MASK_HI	36
#define	PCIE_B_CFG_IO_OFFSET_MASK_MASK_HI_MASK	0x7f
#define	PCIE_B_CFG_IO_OFFSET_MASK_MASK	24
#define	PCIE_B_CFG_IO_OFFSET_MASK_MASK_MASK	0xfff
#define	PCIE_A_MEM64_OFFSET_BASE	0x400080
#define	PCIE_A_MEM64_OFFSET_BASE_V	  63
#define	PCIE_A_MEM64_OFFSET_BASE_BASE	24
#define	PCIE_A_MEM64_OFFSET_BASE_BASE_MASK	0xfff
#define	PCIE_A_MEM64_OFFSET_MASK	0x400088
#define	PCIE_A_MEM64_OFFSET_MASK_MASK_HI	36
#define	PCIE_A_MEM64_OFFSET_MASK_MASK_HI_MASK	0x7f
#define	PCIE_A_MEM64_OFFSET_MASK_MASK	24
#define	PCIE_A_MEM64_OFFSET_MASK_MASK_MASK	0xfff
#define	PCIE_B_MEM64_OFFSET_BASE	0x400090
#define	PCIE_B_MEM64_OFFSET_BASE_V	  63
#define	PCIE_B_MEM64_OFFSET_BASE_BASE	24
#define	PCIE_B_MEM64_OFFSET_BASE_BASE_MASK	0xfff
#define	PCIE_B_MEM64_OFFSET_MASK	0x400098
#define	PCIE_B_MEM64_OFFSET_MASK_MASK_HI	36
#define	PCIE_B_MEM64_OFFSET_MASK_MASK_HI_MASK	0x7f
#define	PCIE_B_MEM64_OFFSET_MASK_MASK	24
#define	PCIE_B_MEM64_OFFSET_MASK_MASK_MASK	0xfff
#define	FIRE_CONTROL_STATUS	0x410000
#define	FIRE_CONTROL_STATUS_SPARE_CONTROL_LOAD_4	  63
#define	FIRE_CONTROL_STATUS_SPARE_CONTROL_LOAD_3	  62
#define	FIRE_CONTROL_STATUS_SPARE_CONTROL_LOAD_2	  61
#define	FIRE_CONTROL_STATUS_SPARE_CONTROL_LOAD_1	  60
#define	FIRE_CONTROL_STATUS_SPARE_CONTROL_LOAD_0	  59
#define	FIRE_CONTROL_STATUS_SPARE_CONTROL	54
#define	FIRE_CONTROL_STATUS_SPARE_CONTROL_MASK	0x1f
#define	FIRE_CONTROL_STATUS_SPARE_STATUS	49
#define	FIRE_CONTROL_STATUS_SPARE_STATUS_MASK	0x1f
#define	FIRE_CONTROL_STATUS_PAR_DELAY	  44
#define	FIRE_CONTROL_STATUS_PAR_EN	  43
#define	FIRE_CONTROL_STATUS_JPACK_DELAY	36
#define	FIRE_CONTROL_STATUS_JPACK_DELAY_MASK	0x7f
#define	FIRE_CONTROL_STATUS_DTL_MODE	34
#define	FIRE_CONTROL_STATUS_DTL_MODE_MASK	0x3
#define	FIRE_CONTROL_STATUS_JTO	32
#define	FIRE_CONTROL_STATUS_JTO_MASK	0x3
#define	FIRE_CONTROL_STATUS_ARB_MODE	27
#define	FIRE_CONTROL_STATUS_ARB_MODE_MASK	0x3
#define	FIRE_CONTROL_STATUS_UE_PROP_MODE	  26
#define	FIRE_CONTROL_STATUS_JPID_4	  25
#define	FIRE_CONTROL_STATUS_JPID_3_0	21
#define	FIRE_CONTROL_STATUS_JPID_3_0_MASK	0xf
#define	FIRE_CONTROL_STATUS_AOK_THRESH	17
#define	FIRE_CONTROL_STATUS_AOK_THRESH_MASK	0xf
#define	FIRE_CONTROL_STATUS_DOK_THRESH	13
#define	FIRE_CONTROL_STATUS_DOK_THRESH_MASK	0xf
#define	FIRE_CONTROL_STATUS_NIAGARA_MODE	  12
#define	FIRE_CONTROL_STATUS_PDQ	10
#define	FIRE_CONTROL_STATUS_PDQ_MASK	0x3
#define	FIRE_CONTROL_STATUS_J_AD4_DIAG	  9
#define	FIRE_CONTROL_STATUS_LPDQ	0
#define	FIRE_CONTROL_STATUS_LPDQ_MASK	0x1ff
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL	0x410050
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_EP_50	55
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_EP_50_MASK	0x1f
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_EP_25	50
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_EP_25_MASK	0x1f
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_EN_50	45
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_EN_50_MASK	0x1f
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_EN_25	40
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_EN_25_MASK	0x1f
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_DTL_TST2_SCHEME	  39
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_EP_50_O	32
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_EP_50_O_MASK	0x7f
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_EP_25_O	24
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_EP_25_O_MASK	0x7f
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_EN_50_O	16
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_EN_50_O_MASK	0x7f
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_EN_25_O	8
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_EN_25_O_MASK	0x7f
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_DTL_TST2_MODE	6
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_DTL_TST2_MODE_MASK	0x3
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_PLL_LOCK	  5
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_DTL_CHAR	  4
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_JITLMT	2
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_JITLMT_MASK	0x3
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_CNTLMT	0
#define	JBUS_PLL_CONTROL_AND_DTL_CONTROL_CNTLMT_MASK	0x3
#define	JBUS_ENERGY_STAR_CONTROL	0x410058
#define	JBUS_ENERGY_STAR_CONTROL_S1_32	  5
#define	JBUS_ENERGY_STAR_CONTROL_S1_2	  1
#define	JBUS_ENERGY_STAR_CONTROL_FULL	  0
#define	JBUS_CHANGE_INITIATION_CONTROL	0x410060
#define	JBUS_CHANGE_INITIATION_CONTROL_CINIT	3
#define	JBUS_CHANGE_INITIATION_CONTROL_CINIT_MASK	0x3
#define	JBUS_CHANGE_INITIATION_CONTROL_CDELAY	0
#define	JBUS_CHANGE_INITIATION_CONTROL_CDELAY_MASK	0x7
#define	RESET_GENERATION	0x417010
#define	RESET_GENERATION_PU_RST	  2
#define	RESET_GENERATION_XIR	  1
#define	RESET_GENERATION_PO_RST	  0
#define	RESET_SOURCE	0x417018
#define	RESET_SOURCE_FATAL	  6
#define	RESET_SOURCE_PB_XIR	  5
#define	RESET_SOURCE_PB_RST	  4
#define	RESET_SOURCE_PU	  3
#define	RESET_SOURCE_PU_RST	  2
#define	RESET_SOURCE_XIR	  1
#define	RESET_SOURCE_PO_RST	  0
#define	GPIO_PORT_0_PIN_0_DATA	0x460000
#define	GPIO_PORT_0_PIN_0_DATA_DATA	  0
#define	GPIO_PORT_0_PIN_1_DATA	0x460008
#define	GPIO_PORT_0_PIN_1_DATA_DATA	  0
#define	GPIO_PORT_0_PIN_2_DATA	0x460010
#define	GPIO_PORT_0_PIN_2_DATA_DATA	  0
#define	GPIO_PORT_0_PIN_3_DATA	0x460018
#define	GPIO_PORT_0_PIN_3_DATA_DATA	  0
#define	GPIO_PORT_0_DATA	0x460020
#define	GPIO_PORT_0_DATA_DATA_3	  3
#define	GPIO_PORT_0_DATA_DATA_2	  2
#define	GPIO_PORT_0_DATA_DATA_1	  1
#define	GPIO_PORT_0_DATA_DATA_0	  0
#define	GPIO_PORT_0_CONTROL	0x460028
#define	GPIO_PORT_0_CONTROL_DIR_3	  3
#define	GPIO_PORT_0_CONTROL_DIR_2	  2
#define	GPIO_PORT_0_CONTROL_DIR_1	  1
#define	GPIO_PORT_0_CONTROL_DIR_0	  0
#define	GPIO_PORT_1_PIN_0_DATA	0x462000
#define	GPIO_PORT_1_PIN_0_DATA_DATA	  0
#define	GPIO_PORT_1_PIN_1_DATA	0x462008
#define	GPIO_PORT_1_PIN_1_DATA_DATA	  0
#define	GPIO_PORT_1_PIN_2_DATA	0x462010
#define	GPIO_PORT_1_PIN_2_DATA_DATA	  0
#define	GPIO_PORT_1_PIN_3_DATA	0x462018
#define	GPIO_PORT_1_PIN_3_DATA_DATA	  0
#define	GPIO_PORT_1_DATA	0x462020
#define	GPIO_PORT_1_DATA_DATA_3	  3
#define	GPIO_PORT_1_DATA_DATA_2	  2
#define	GPIO_PORT_1_DATA_DATA_1	  1
#define	GPIO_PORT_1_DATA_DATA_0	  0
#define	GPIO_PORT_1_CONTROL	0x462028
#define	GPIO_PORT_1_CONTROL_DIR_3	  3
#define	GPIO_PORT_1_CONTROL_DIR_2	  2
#define	GPIO_PORT_1_CONTROL_DIR_1	  1
#define	GPIO_PORT_1_CONTROL_DIR_0	  0
#define	EBUS_EPROM_TIMING_CONTROL	0x464000
#define	EBUS_EPROM_TIMING_CONTROL_ENABLE	  61
#define	EBUS_EPROM_TIMING_CONTROL_READY_COUNT	40
#define	EBUS_EPROM_TIMING_CONTROL_READY_COUNT_MASK	0x1fffff
#define	EBUS_EPROM_TIMING_CONTROL_PROTOCOL_COUNT	32
#define	EBUS_EPROM_TIMING_CONTROL_PROTOCOL_COUNT_MASK	0xff
#define	EBUS_EPROM_TIMING_CONTROL_STROBE_COUNT	24
#define	EBUS_EPROM_TIMING_CONTROL_STROBE_COUNT_MASK	0xff
#define	EBUS_EPROM_TIMING_CONTROL_RECOVERY_COUNT	16
#define	EBUS_EPROM_TIMING_CONTROL_RECOVERY_COUNT_MASK	0xff
#define	EBUS_EPROM_TIMING_CONTROL_HOLD_COUNT	8
#define	EBUS_EPROM_TIMING_CONTROL_HOLD_COUNT_MASK	0xff
#define	EBUS_EPROM_TIMING_CONTROL_SETUP_COUNT	0
#define	EBUS_EPROM_TIMING_CONTROL_SETUP_COUNT_MASK	0xff
#define	EBUS_CHIP_SELECT_1_TIMING_CONTROL	0x464008
#define	EBUS_CHIP_SELECT_1_TIMING_CONTROL_READY_COUNT	40
#define	EBUS_CHIP_SELECT_1_TIMING_CONTROL_READY_COUNT_MASK	0x1fffff
#define	EBUS_CHIP_SELECT_1_TIMING_CONTROL_PROTOCOL_COUNT	32
#define	EBUS_CHIP_SELECT_1_TIMING_CONTROL_PROTOCOL_COUNT_MASK	0xff
#define	EBUS_CHIP_SELECT_1_TIMING_CONTROL_STROBE_COUNT	24
#define	EBUS_CHIP_SELECT_1_TIMING_CONTROL_STROBE_COUNT_MASK	0xff
#define	EBUS_CHIP_SELECT_1_TIMING_CONTROL_RECOVERY_COUNT	16
#define	EBUS_CHIP_SELECT_1_TIMING_CONTROL_RECOVERY_COUNT_MASK	0xff
#define	EBUS_CHIP_SELECT_1_TIMING_CONTROL_HOLD_COUNT	8
#define	EBUS_CHIP_SELECT_1_TIMING_CONTROL_HOLD_COUNT_MASK	0xff
#define	EBUS_CHIP_SELECT_1_TIMING_CONTROL_SETUP_COUNT	0
#define	EBUS_CHIP_SELECT_1_TIMING_CONTROL_SETUP_COUNT_MASK	0xff
#define	EBUS_CHIP_SELECT_2_TIMING_CONTROL	0x464010
#define	EBUS_CHIP_SELECT_2_TIMING_CONTROL_READY_COUNT	40
#define	EBUS_CHIP_SELECT_2_TIMING_CONTROL_READY_COUNT_MASK	0x1fffff
#define	EBUS_CHIP_SELECT_2_TIMING_CONTROL_PROTOCOL_COUNT	32
#define	EBUS_CHIP_SELECT_2_TIMING_CONTROL_PROTOCOL_COUNT_MASK	0xff
#define	EBUS_CHIP_SELECT_2_TIMING_CONTROL_STROBE_COUNT	24
#define	EBUS_CHIP_SELECT_2_TIMING_CONTROL_STROBE_COUNT_MASK	0xff
#define	EBUS_CHIP_SELECT_2_TIMING_CONTROL_RECOVERY_COUNT	16
#define	EBUS_CHIP_SELECT_2_TIMING_CONTROL_RECOVERY_COUNT_MASK	0xff
#define	EBUS_CHIP_SELECT_2_TIMING_CONTROL_HOLD_COUNT	8
#define	EBUS_CHIP_SELECT_2_TIMING_CONTROL_HOLD_COUNT_MASK	0xff
#define	EBUS_CHIP_SELECT_2_TIMING_CONTROL_SETUP_COUNT	0
#define	EBUS_CHIP_SELECT_2_TIMING_CONTROL_SETUP_COUNT_MASK	0xff
#define	EBUS_CHIP_SELECT_3_TIMING_CONTROL	0x464018
#define	EBUS_CHIP_SELECT_3_TIMING_CONTROL_READY_COUNT	40
#define	EBUS_CHIP_SELECT_3_TIMING_CONTROL_READY_COUNT_MASK	0x1fffff
#define	EBUS_CHIP_SELECT_3_TIMING_CONTROL_PROTOCOL_COUNT	32
#define	EBUS_CHIP_SELECT_3_TIMING_CONTROL_PROTOCOL_COUNT_MASK	0xff
#define	EBUS_CHIP_SELECT_3_TIMING_CONTROL_STROBE_COUNT	24
#define	EBUS_CHIP_SELECT_3_TIMING_CONTROL_STROBE_COUNT_MASK	0xff
#define	EBUS_CHIP_SELECT_3_TIMING_CONTROL_RECOVERY_COUNT	16
#define	EBUS_CHIP_SELECT_3_TIMING_CONTROL_RECOVERY_COUNT_MASK	0xff
#define	EBUS_CHIP_SELECT_3_TIMING_CONTROL_HOLD_COUNT	8
#define	EBUS_CHIP_SELECT_3_TIMING_CONTROL_HOLD_COUNT_MASK	0xff
#define	EBUS_CHIP_SELECT_3_TIMING_CONTROL_SETUP_COUNT	0
#define	EBUS_CHIP_SELECT_3_TIMING_CONTROL_SETUP_COUNT_MASK	0xff
#define	I2C_0_INPUT_MONITOR	0x466000
#define	I2C_0_INPUT_MONITOR_SDC	  1
#define	I2C_0_INPUT_MONITOR_SDA	  0
#define	I2C_0_DATA_DRIVE	0x466008
#define	I2C_0_DATA_DRIVE_SDA	  0
#define	I2C_0_CLOCK_DRIVE	0x466010
#define	I2C_0_CLOCK_DRIVE_SCL	  0
#define	I2C_1_INPUT_MONITOR	0x468000
#define	I2C_1_INPUT_MONITOR_SDC	  1
#define	I2C_1_INPUT_MONITOR_SDA	  0
#define	I2C_1_DATA_DRIVE	0x468008
#define	I2C_1_DATA_DRIVE_SDA	  0
#define	I2C_1_CLOCK_DRIVE	0x468010
#define	I2C_1_CLOCK_DRIVE_SCL	  0
#define	PCIE_A_LEAF_CSR_RING_SLOW_ONLY_ACCESS	0x470000
#define	PCIE_A_LEAF_CSR_RING_SLOW_ONLY_ACCESS_SLOW_ONLY	  0
#define	PCIE_B_LEAF_CSR_RING_SLOW_ONLY_ACCESS	0x470008
#define	PCIE_B_LEAF_CSR_RING_SLOW_ONLY_ACCESS_SLOW_ONLY	  0
#define	JBUS_PARITY_CONTROL	0x470010
#define	JBUS_PARITY_CONTROL_P_EN	  63
#define	JBUS_PARITY_CONTROL_INVERT_PAR	2
#define	JBUS_PARITY_CONTROL_INVERT_PAR_MASK	0xf
#define	JBUS_PARITY_CONTROL_NEXT_DATA	  1
#define	JBUS_PARITY_CONTROL_NEXT_ADDR	  0
#define	JBUS_SCRATCH_1	0x470018
#define	JBUS_SCRATCH_1_DATA	0
#define	JBUS_SCRATCH_1_DATA_MASK	0xffffffffffffffff
#define	JBUS_SCRATCH_2	0x470020
#define	JBUS_SCRATCH_2_DATA	0
#define	JBUS_SCRATCH_2_DATA_MASK	0xffffffffffffffff
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR	0x470028
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_SPARE_S_INT_EN	61
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_SPARE_S_INT_EN_MASK	0x7
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_PIO_UNMAP_RD_S_INT_EN	  60
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_ILL_ACC_RD_S_INT_EN	  59
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_EBUS_TO_S_LOG_EN	  58
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_MB_PEA_S_INT_EN	  57
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_MB_PER_S_INT_EN	  56
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_MB_PEW_S_INT_EN	  55
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_UE_ASYN_S_INT_EN	  54
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_CE_ASYN_S_INT_EN	  53
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_JTE_S_INT_EN	  52
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_JBE_S_INT_EN	  51
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_JUE_S_INT_EN	  50
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_IJP_S_INT_EN	  49
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_ICISE_S_INT_EN	  48
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_CPE_S_INT_EN	  47
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_APE_S_INT_EN	  46
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_WR_DPE_S_INT_EN	  45
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_RD_DPE_S_INT_EN	  44
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_ILL_BMW_S_INT_EN	  43
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_ILL_BMR_S_INT_EN	  42
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_BJC_S_INT_EN	  41
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_PIO_UNMAP_S_INT_EN	  40
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_PIO_DPE_S_INT_EN	  39
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_PIO_CPE_S_INT_EN	  38
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_ILL_ACC_S_INT_EN	  37
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_UNSOL_RD_S_INT_EN	  36
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_UNSOL_INTR_S_INT_EN	  35
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_JTCEEW_S_INT_EN	  34
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_JTCEEI_S_INT_EN	  33
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_JTCEER_S_INT_EN	  32
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_SPARE_P_INT_EN	29
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_SPARE_P_INT_EN_MASK	0x7
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_PIO_UNMAP_RD_P_INT_EN	  28
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_ILL_ACC_RD_P_INT_EN	  27
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_EBUS_TO_P_LOG_EN	  26
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_MB_PEA_P_INT_EN	  25
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_MB_PER_P_INT_EN	  24
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_MB_PEW_P_INT_EN	  23
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_UE_ASYN_P_INT_EN	  22
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_CE_ASYN_P_INT_EN	  21
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_JTE_P_INT_EN	  20
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_JBE_P_INT_EN	  19
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_JUE_P_INT_EN	  18
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_IJP_P_INT_EN	  17
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_ICISE_P_INT_EN	  16
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_CPE_P_INT_EN	  15
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_APE_P_INT_EN	  14
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_WR_DPE_P_INT_EN	  13
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_RD_DPE_P_INT_EN	  12
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_ILL_BMW_P_INT_EN	  11
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_ILL_BMR_P_INT_EN	  10
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_BJC_P_INT_EN	  9
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_PIO_UNMAP_P_INT_EN	  8
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_PIO_DPE_P_INT_EN	  7
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_PIO_CPE_P_INT_EN	  6
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_ILL_ACC_P_INT_EN	  5
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_UNSOL_RD_P_INT_EN	  4
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_UNSOL_INTR_P_INT_EN	  3
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_JTCEEW_P_INT_EN	  2
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_JTCEEI_P_INT_EN	  1
#define	JBC_ERR_LG_ANLYZ_TRIG_ENB_FOR_J_ERR_JTCEER_P_INT_EN	  0
#define	JBUS_SCRATCH_PERSISTENT	0x470030
#define	JBUS_SCRATCH_PERSISTENT_DATA	0
#define	JBUS_SCRATCH_PERSISTENT_DATA_MASK	0xffffffffffffffff
#define	JBC_ERROR_LOG_ENABLE	0x471000
#define	JBC_ERROR_LOG_ENABLE_SPARE_LOG_EN	29
#define	JBC_ERROR_LOG_ENABLE_SPARE_LOG_EN_MASK	0x7
#define	JBC_ERROR_LOG_ENABLE_PIO_UNMAP_RD_LOG_EN	  28
#define	JBC_ERROR_LOG_ENABLE_ILL_ACC_RD_LOG_EN	  27
#define	JBC_ERROR_LOG_ENABLE_EBUS_TO_LOG_EN	  26
#define	JBC_ERROR_LOG_ENABLE_MB_PEA_LOG_EN	  25
#define	JBC_ERROR_LOG_ENABLE_MB_PER_LOG_EN	  24
#define	JBC_ERROR_LOG_ENABLE_MB_PEW_LOG_EN	  23
#define	JBC_ERROR_LOG_ENABLE_UE_ASYN_LOG_EN	  22
#define	JBC_ERROR_LOG_ENABLE_CE_ASYN_LOG_EN	  21
#define	JBC_ERROR_LOG_ENABLE_JTE_LOG_EN	  20
#define	JBC_ERROR_LOG_ENABLE_JBE_LOG_EN	  19
#define	JBC_ERROR_LOG_ENABLE_JUE_LOG_EN	  18
#define	JBC_ERROR_LOG_ENABLE_IJP_LOG_EN	  17
#define	JBC_ERROR_LOG_ENABLE_ICISE_LOG_EN	  16
#define	JBC_ERROR_LOG_ENABLE_CPE_LOG_EN	  15
#define	JBC_ERROR_LOG_ENABLE_APE_LOG_EN	  14
#define	JBC_ERROR_LOG_ENABLE_WR_DPE_LOG_EN	  13
#define	JBC_ERROR_LOG_ENABLE_RD_DPE_LOG_EN	  12
#define	JBC_ERROR_LOG_ENABLE_ILL_BMW_LOG_EN	  11
#define	JBC_ERROR_LOG_ENABLE_ILL_BMR_LOG_EN	  10
#define	JBC_ERROR_LOG_ENABLE_BJC_LOG_EN	  9
#define	JBC_ERROR_LOG_ENABLE_PIO_UNMAP_LOG_EN	  8
#define	JBC_ERROR_LOG_ENABLE_PIO_DPE_LOG_EN	  7
#define	JBC_ERROR_LOG_ENABLE_PIO_CPE_LOG_EN	  6
#define	JBC_ERROR_LOG_ENABLE_ILL_ACC_LOG_EN	  5
#define	JBC_ERROR_LOG_ENABLE_UNSOL_RD_LOG_EN	  4
#define	JBC_ERROR_LOG_ENABLE_UNSOL_INTR_LOG_EN	  3
#define	JBC_ERROR_LOG_ENABLE_JTCEEW_LOG_EN	  2
#define	JBC_ERROR_LOG_ENABLE_JTCEEI_LOG_EN	  1
#define	JBC_ERROR_LOG_ENABLE_JTCEER_LOG_EN	  0
#define	JBC_INTERRUPT_ENABLE	0x471008
#define	JBC_INTERRUPT_ENABLE_SPARE_S_INT_EN	61
#define	JBC_INTERRUPT_ENABLE_SPARE_S_INT_EN_MASK	0x7
#define	JBC_INTERRUPT_ENABLE_PIO_UNMAP_RD_S_INT_EN	  60
#define	JBC_INTERRUPT_ENABLE_ILL_ACC_RD_S_INT_EN	  59
#define	JBC_INTERRUPT_ENABLE_EBUS_TO_S_LOG_EN	  58
#define	JBC_INTERRUPT_ENABLE_MB_PEA_S_INT_EN	  57
#define	JBC_INTERRUPT_ENABLE_MB_PER_S_INT_EN	  56
#define	JBC_INTERRUPT_ENABLE_MB_PEW_S_INT_EN	  55
#define	JBC_INTERRUPT_ENABLE_UE_ASYN_S_INT_EN	  54
#define	JBC_INTERRUPT_ENABLE_CE_ASYN_S_INT_EN	  53
#define	JBC_INTERRUPT_ENABLE_JTE_S_INT_EN	  52
#define	JBC_INTERRUPT_ENABLE_JBE_S_INT_EN	  51
#define	JBC_INTERRUPT_ENABLE_JUE_S_INT_EN	  50
#define	JBC_INTERRUPT_ENABLE_IJP_S_INT_EN	  49
#define	JBC_INTERRUPT_ENABLE_ICISE_S_INT_EN	  48
#define	JBC_INTERRUPT_ENABLE_CPE_S_INT_EN	  47
#define	JBC_INTERRUPT_ENABLE_APE_S_INT_EN	  46
#define	JBC_INTERRUPT_ENABLE_WR_DPE_S_INT_EN	  45
#define	JBC_INTERRUPT_ENABLE_RD_DPE_S_INT_EN	  44
#define	JBC_INTERRUPT_ENABLE_ILL_BMW_S_INT_EN	  43
#define	JBC_INTERRUPT_ENABLE_ILL_BMR_S_INT_EN	  42
#define	JBC_INTERRUPT_ENABLE_BJC_S_INT_EN	  41
#define	JBC_INTERRUPT_ENABLE_PIO_UNMAP_S_INT_EN	  40
#define	JBC_INTERRUPT_ENABLE_PIO_DPE_S_INT_EN	  39
#define	JBC_INTERRUPT_ENABLE_PIO_CPE_S_INT_EN	  38
#define	JBC_INTERRUPT_ENABLE_ILL_ACC_S_INT_EN	  37
#define	JBC_INTERRUPT_ENABLE_UNSOL_RD_S_INT_EN	  36
#define	JBC_INTERRUPT_ENABLE_UNSOL_INTR_S_INT_EN	  35
#define	JBC_INTERRUPT_ENABLE_JTCEEW_S_INT_EN	  34
#define	JBC_INTERRUPT_ENABLE_JTCEEI_S_INT_EN	  33
#define	JBC_INTERRUPT_ENABLE_JTCEER_S_INT_EN	  32
#define	JBC_INTERRUPT_ENABLE_SPARE_P_INT_EN	29
#define	JBC_INTERRUPT_ENABLE_SPARE_P_INT_EN_MASK	0x7
#define	JBC_INTERRUPT_ENABLE_PIO_UNMAP_RD_P_INT_EN	  28
#define	JBC_INTERRUPT_ENABLE_ILL_ACC_RD_P_INT_EN	  27
#define	JBC_INTERRUPT_ENABLE_EBUS_TO_P_LOG_EN	  26
#define	JBC_INTERRUPT_ENABLE_MB_PEA_P_INT_EN	  25
#define	JBC_INTERRUPT_ENABLE_MB_PER_P_INT_EN	  24
#define	JBC_INTERRUPT_ENABLE_MB_PEW_P_INT_EN	  23
#define	JBC_INTERRUPT_ENABLE_UE_ASYN_P_INT_EN	  22
#define	JBC_INTERRUPT_ENABLE_CE_ASYN_P_INT_EN	  21
#define	JBC_INTERRUPT_ENABLE_JTE_P_INT_EN	  20
#define	JBC_INTERRUPT_ENABLE_JBE_P_INT_EN	  19
#define	JBC_INTERRUPT_ENABLE_JUE_P_INT_EN	  18
#define	JBC_INTERRUPT_ENABLE_IJP_P_INT_EN	  17
#define	JBC_INTERRUPT_ENABLE_ICISE_P_INT_EN	  16
#define	JBC_INTERRUPT_ENABLE_CPE_P_INT_EN	  15
#define	JBC_INTERRUPT_ENABLE_APE_P_INT_EN	  14
#define	JBC_INTERRUPT_ENABLE_WR_DPE_P_INT_EN	  13
#define	JBC_INTERRUPT_ENABLE_RD_DPE_P_INT_EN	  12
#define	JBC_INTERRUPT_ENABLE_ILL_BMW_P_INT_EN	  11
#define	JBC_INTERRUPT_ENABLE_ILL_BMR_P_INT_EN	  10
#define	JBC_INTERRUPT_ENABLE_BJC_P_INT_EN	  9
#define	JBC_INTERRUPT_ENABLE_PIO_UNMAP_P_INT_EN	  8
#define	JBC_INTERRUPT_ENABLE_PIO_DPE_P_INT_EN	  7
#define	JBC_INTERRUPT_ENABLE_PIO_CPE_P_INT_EN	  6
#define	JBC_INTERRUPT_ENABLE_ILL_ACC_P_INT_EN	  5
#define	JBC_INTERRUPT_ENABLE_UNSOL_RD_P_INT_EN	  4
#define	JBC_INTERRUPT_ENABLE_UNSOL_INTR_P_INT_EN	  3
#define	JBC_INTERRUPT_ENABLE_JTCEEW_P_INT_EN	  2
#define	JBC_INTERRUPT_ENABLE_JTCEEI_P_INT_EN	  1
#define	JBC_INTERRUPT_ENABLE_JTCEER_P_INT_EN	  0
#define	JBC_INTERRUPT_STATUS	0x471010
#define	JBC_INTERRUPT_STATUS_SPARE_S	61
#define	JBC_INTERRUPT_STATUS_SPARE_S_MASK	0x7
#define	JBC_INTERRUPT_STATUS_PIO_UNMAP_RD_S	  60
#define	JBC_INTERRUPT_STATUS_ILL_ACC_RD_S	  59
#define	JBC_INTERRUPT_STATUS_EBUS_TO_S	  58
#define	JBC_INTERRUPT_STATUS_MB_PEA_S	  57
#define	JBC_INTERRUPT_STATUS_MB_PER_S	  56
#define	JBC_INTERRUPT_STATUS_MB_PEW_S	  55
#define	JBC_INTERRUPT_STATUS_UE_ASYN_S	  54
#define	JBC_INTERRUPT_STATUS_CE_ASYN_S	  53
#define	JBC_INTERRUPT_STATUS_JTE_S	  52
#define	JBC_INTERRUPT_STATUS_JBE_S	  51
#define	JBC_INTERRUPT_STATUS_JUE_S	  50
#define	JBC_INTERRUPT_STATUS_IJP_S	  49
#define	JBC_INTERRUPT_STATUS_ICISE_S	  48
#define	JBC_INTERRUPT_STATUS_CPE_S	  47
#define	JBC_INTERRUPT_STATUS_APE_S	  46
#define	JBC_INTERRUPT_STATUS_WR_DPE_S	  45
#define	JBC_INTERRUPT_STATUS_RD_DPE_S	  44
#define	JBC_INTERRUPT_STATUS_ILL_BMW_S	  43
#define	JBC_INTERRUPT_STATUS_ILL_BMR_S	  42
#define	JBC_INTERRUPT_STATUS_BJC_S	  41
#define	JBC_INTERRUPT_STATUS_PIO_UNMAP_S	  40
#define	JBC_INTERRUPT_STATUS_PIO_DPE_S	  39
#define	JBC_INTERRUPT_STATUS_PIO_CPE_S	  38
#define	JBC_INTERRUPT_STATUS_ILL_ACC_S	  37
#define	JBC_INTERRUPT_STATUS_UNSOL_RD_S	  36
#define	JBC_INTERRUPT_STATUS_UNSOL_INTR_S	  35
#define	JBC_INTERRUPT_STATUS_JTCEEW_S	  34
#define	JBC_INTERRUPT_STATUS_JTCEEI_S	  33
#define	JBC_INTERRUPT_STATUS_JTCEER_S	  32
#define	JBC_INTERRUPT_STATUS_SPARE_P	29
#define	JBC_INTERRUPT_STATUS_SPARE_P_MASK	0x7
#define	JBC_INTERRUPT_STATUS_PIO_UNMAP_RD_P	  28
#define	JBC_INTERRUPT_STATUS_ILL_ACC_RD_P	  27
#define	JBC_INTERRUPT_STATUS_EBUS_TO_P	  26
#define	JBC_INTERRUPT_STATUS_MB_PEA_P	  25
#define	JBC_INTERRUPT_STATUS_MB_PER_P	  24
#define	JBC_INTERRUPT_STATUS_MB_PEW_P	  23
#define	JBC_INTERRUPT_STATUS_UE_ASYN_P	  22
#define	JBC_INTERRUPT_STATUS_CE_ASYN_P	  21
#define	JBC_INTERRUPT_STATUS_JTE_P	  20
#define	JBC_INTERRUPT_STATUS_JBE_P	  19
#define	JBC_INTERRUPT_STATUS_JUE_P	  18
#define	JBC_INTERRUPT_STATUS_IJP_P	  17
#define	JBC_INTERRUPT_STATUS_ICISE_P	  16
#define	JBC_INTERRUPT_STATUS_CPE_P	  15
#define	JBC_INTERRUPT_STATUS_APE_P	  14
#define	JBC_INTERRUPT_STATUS_WR_DPE_P	  13
#define	JBC_INTERRUPT_STATUS_RD_DPE_P	  12
#define	JBC_INTERRUPT_STATUS_ILL_BMW_P	  11
#define	JBC_INTERRUPT_STATUS_ILL_BMR_P	  10
#define	JBC_INTERRUPT_STATUS_BJC_P	  9
#define	JBC_INTERRUPT_STATUS_PIO_UNMAP_P	  8
#define	JBC_INTERRUPT_STATUS_PIO_DPE_P	  7
#define	JBC_INTERRUPT_STATUS_PIO_CPE_P	  6
#define	JBC_INTERRUPT_STATUS_ILL_ACC_P	  5
#define	JBC_INTERRUPT_STATUS_UNSOL_RD_P	  4
#define	JBC_INTERRUPT_STATUS_UNSOL_INTR_P	  3
#define	JBC_INTERRUPT_STATUS_JTCEEW_P	  2
#define	JBC_INTERRUPT_STATUS_JTCEEI_P	  1
#define	JBC_INTERRUPT_STATUS_JTCEER_P	  0
#define	JBC_ERROR_STATUS_CLEAR	0x471018
#define	JBC_ERROR_STATUS_CLEAR_SPARE_S	61
#define	JBC_ERROR_STATUS_CLEAR_SPARE_S_MASK	0x7
#define	JBC_ERROR_STATUS_CLEAR_PIO_UNMAP_RD_S	  60
#define	JBC_ERROR_STATUS_CLEAR_ILL_ACC_RD_S	  59
#define	JBC_ERROR_STATUS_CLEAR_EBUS_TO_S	  58
#define	JBC_ERROR_STATUS_CLEAR_MB_PEA_S	  57
#define	JBC_ERROR_STATUS_CLEAR_MB_PER_S	  56
#define	JBC_ERROR_STATUS_CLEAR_MB_PEW_S	  55
#define	JBC_ERROR_STATUS_CLEAR_UE_ASYN_S	  54
#define	JBC_ERROR_STATUS_CLEAR_CE_ASYN_S	  53
#define	JBC_ERROR_STATUS_CLEAR_JTE_S	  52
#define	JBC_ERROR_STATUS_CLEAR_JBE_S	  51
#define	JBC_ERROR_STATUS_CLEAR_JUE_S	  50
#define	JBC_ERROR_STATUS_CLEAR_IJP_S	  49
#define	JBC_ERROR_STATUS_CLEAR_ICISE_S	  48
#define	JBC_ERROR_STATUS_CLEAR_CPE_S	  47
#define	JBC_ERROR_STATUS_CLEAR_APE_S	  46
#define	JBC_ERROR_STATUS_CLEAR_WR_DPE_S	  45
#define	JBC_ERROR_STATUS_CLEAR_RD_DPE_S	  44
#define	JBC_ERROR_STATUS_CLEAR_ILL_BMW_S	  43
#define	JBC_ERROR_STATUS_CLEAR_ILL_BMR_S	  42
#define	JBC_ERROR_STATUS_CLEAR_BJC_S	  41
#define	JBC_ERROR_STATUS_CLEAR_PIO_UNMAP_S	  40
#define	JBC_ERROR_STATUS_CLEAR_PIO_DPE_S	  39
#define	JBC_ERROR_STATUS_CLEAR_PIO_CPE_S	  38
#define	JBC_ERROR_STATUS_CLEAR_ILL_ACC_S	  37
#define	JBC_ERROR_STATUS_CLEAR_UNSOL_RD_S	  36
#define	JBC_ERROR_STATUS_CLEAR_UNSOL_INTR_S	  35
#define	JBC_ERROR_STATUS_CLEAR_JTCEEW_S	  34
#define	JBC_ERROR_STATUS_CLEAR_JTCEEI_S	  33
#define	JBC_ERROR_STATUS_CLEAR_JTCEER_S	  32
#define	JBC_ERROR_STATUS_CLEAR_SPARE_P	29
#define	JBC_ERROR_STATUS_CLEAR_SPARE_P_MASK	0x7
#define	JBC_ERROR_STATUS_CLEAR_PIO_UNMAP_RD_P	  28
#define	JBC_ERROR_STATUS_CLEAR_ILL_ACC_RD_P	  27
#define	JBC_ERROR_STATUS_CLEAR_EBUS_TO_P	  26
#define	JBC_ERROR_STATUS_CLEAR_MB_PEA_P	  25
#define	JBC_ERROR_STATUS_CLEAR_MB_PER_P	  24
#define	JBC_ERROR_STATUS_CLEAR_MB_PEW_P	  23
#define	JBC_ERROR_STATUS_CLEAR_UE_ASYN_P	  22
#define	JBC_ERROR_STATUS_CLEAR_CE_ASYN_P	  21
#define	JBC_ERROR_STATUS_CLEAR_JTE_P	  20
#define	JBC_ERROR_STATUS_CLEAR_JBE_P	  19
#define	JBC_ERROR_STATUS_CLEAR_JUE_P	  18
#define	JBC_ERROR_STATUS_CLEAR_IJP_P	  17
#define	JBC_ERROR_STATUS_CLEAR_ICISE_P	  16
#define	JBC_ERROR_STATUS_CLEAR_CPE_P	  15
#define	JBC_ERROR_STATUS_CLEAR_APE_P	  14
#define	JBC_ERROR_STATUS_CLEAR_WR_DPE_P	  13
#define	JBC_ERROR_STATUS_CLEAR_RD_DPE_P	  12
#define	JBC_ERROR_STATUS_CLEAR_ILL_BMW_P	  11
#define	JBC_ERROR_STATUS_CLEAR_ILL_BMR_P	  10
#define	JBC_ERROR_STATUS_CLEAR_BJC_P	  9
#define	JBC_ERROR_STATUS_CLEAR_PIO_UNMAP_P	  8
#define	JBC_ERROR_STATUS_CLEAR_PIO_DPE_P	  7
#define	JBC_ERROR_STATUS_CLEAR_PIO_CPE_P	  6
#define	JBC_ERROR_STATUS_CLEAR_ILL_ACC_P	  5
#define	JBC_ERROR_STATUS_CLEAR_UNSOL_RD_P	  4
#define	JBC_ERROR_STATUS_CLEAR_UNSOL_INTR_P	  3
#define	JBC_ERROR_STATUS_CLEAR_JTCEEW_P	  2
#define	JBC_ERROR_STATUS_CLEAR_JTCEEI_P	  1
#define	JBC_ERROR_STATUS_CLEAR_JTCEER_P	  0
#define	JBC_ERROR_STATUS_SET	0x471020
#define	JBC_ERROR_STATUS_SET_SPARE_S	61
#define	JBC_ERROR_STATUS_SET_SPARE_S_MASK	0xfc
#define	JBC_ERROR_STATUS_SET_PIO_UNMAP_RD_S	  60
#define	JBC_ERROR_STATUS_SET_ILL_ACC_RD_S	  59
#define	JBC_ERROR_STATUS_SET_EBUS_TO_S	  58
#define	JBC_ERROR_STATUS_SET_MB_PEA_S	  57
#define	JBC_ERROR_STATUS_SET_MB_PER_S	  56
#define	JBC_ERROR_STATUS_SET_MB_PEW_S	  55
#define	JBC_ERROR_STATUS_SET_UE_ASYN_S	  54
#define	JBC_ERROR_STATUS_SET_CE_ASYN_S	  53
#define	JBC_ERROR_STATUS_SET_JTE_S	  52
#define	JBC_ERROR_STATUS_SET_JBE_S	  51
#define	JBC_ERROR_STATUS_SET_JUE_S	  50
#define	JBC_ERROR_STATUS_SET_IJP_S	  49
#define	JBC_ERROR_STATUS_SET_ICISE_S	  48
#define	JBC_ERROR_STATUS_SET_CPE_S	  47
#define	JBC_ERROR_STATUS_SET_APE_S	  46
#define	JBC_ERROR_STATUS_SET_WR_DPE_S	  45
#define	JBC_ERROR_STATUS_SET_RD_DPE_S	  44
#define	JBC_ERROR_STATUS_SET_ILL_BMW_S	  43
#define	JBC_ERROR_STATUS_SET_ILL_BMR_S	  42
#define	JBC_ERROR_STATUS_SET_BJC_S	  41
#define	JBC_ERROR_STATUS_SET_PIO_UNMAP_S	  40
#define	JBC_ERROR_STATUS_SET_PIO_DPE_S	  39
#define	JBC_ERROR_STATUS_SET_PIO_CPE_S	  38
#define	JBC_ERROR_STATUS_SET_ILL_ACC_S	  37
#define	JBC_ERROR_STATUS_SET_UNSOL_RD_S	  36
#define	JBC_ERROR_STATUS_SET_UNSOL_INTR_S	  35
#define	JBC_ERROR_STATUS_SET_JTCEEW_S	  34
#define	JBC_ERROR_STATUS_SET_JTCEEI_S	  33
#define	JBC_ERROR_STATUS_SET_JTCEER_S	  32
#define	JBC_ERROR_STATUS_SET_SPARE_P	29
#define	JBC_ERROR_STATUS_SET_SPARE_P_MASK	0xfc
#define	JBC_ERROR_STATUS_SET_PIO_UNMAP_RD_P	  28
#define	JBC_ERROR_STATUS_SET_ILL_ACC_RD_P	  27
#define	JBC_ERROR_STATUS_SET_EBUS_TO_P	  26
#define	JBC_ERROR_STATUS_SET_MB_PEA_P	  25
#define	JBC_ERROR_STATUS_SET_MB_PER_P	  24
#define	JBC_ERROR_STATUS_SET_MB_PEW_P	  23
#define	JBC_ERROR_STATUS_SET_UE_ASYN_P	  22
#define	JBC_ERROR_STATUS_SET_CE_ASYN_P	  21
#define	JBC_ERROR_STATUS_SET_JTE_P	  20
#define	JBC_ERROR_STATUS_SET_JBE_P	  19
#define	JBC_ERROR_STATUS_SET_JUE_P	  18
#define	JBC_ERROR_STATUS_SET_IJP_P	  17
#define	JBC_ERROR_STATUS_SET_ICISE_P	  16
#define	JBC_ERROR_STATUS_SET_CPE_P	  15
#define	JBC_ERROR_STATUS_SET_APE_P	  14
#define	JBC_ERROR_STATUS_SET_WR_DPE_P	  13
#define	JBC_ERROR_STATUS_SET_RD_DPE_P	  12
#define	JBC_ERROR_STATUS_SET_ILL_BMW_P	  11
#define	JBC_ERROR_STATUS_SET_ILL_BMR_P	  10
#define	JBC_ERROR_STATUS_SET_BJC_P	  9
#define	JBC_ERROR_STATUS_SET_PIO_UNMAP_P	  8
#define	JBC_ERROR_STATUS_SET_PIO_DPE_P	  7
#define	JBC_ERROR_STATUS_SET_PIO_CPE_P	  6
#define	JBC_ERROR_STATUS_SET_ILL_ACC_P	  5
#define	JBC_ERROR_STATUS_SET_UNSOL_RD_P	  4
#define	JBC_ERROR_STATUS_SET_UNSOL_INTR_P	  3
#define	JBC_ERROR_STATUS_SET_JTCEEW_P	  2
#define	JBC_ERROR_STATUS_SET_JTCEEI_P	  1
#define	JBC_ERROR_STATUS_SET_JTCEER_P	  0
#define	JBC_FATAL_RESET_ENABLE	0x471028
#define	JBC_FATAL_RESET_ENABLE_SPARE_P_INT_EN	26
#define	JBC_FATAL_RESET_ENABLE_SPARE_P_INT_EN_MASK	0x3
#define	JBC_FATAL_RESET_ENABLE_MB_PEA_P_INT_EN	  25
#define	JBC_FATAL_RESET_ENABLE_CPE_P_INT_EN	  15
#define	JBC_FATAL_RESET_ENABLE_APE_P_INT_EN	  14
#define	JBC_FATAL_RESET_ENABLE_PIO_CPE_INT_EN	  6
#define	JBC_FATAL_RESET_ENABLE_JTCEEW_P_INT_EN	  2
#define	JBC_FATAL_RESET_ENABLE_JTCEEI_P_INT_EN	  1
#define	JBC_FATAL_RESET_ENABLE_JTCEER_P_INT_EN	  0
#define	JBCINT_IN_TRANSACTION_ERROR_LOG	0x471030
#define	JBCINT_IN_TRANSACTION_ERROR_LOG_Q_WORD	54
#define	JBCINT_IN_TRANSACTION_ERROR_LOG_Q_WORD_MASK	0x3
#define	JBCINT_IN_TRANSACTION_ERROR_LOG_TRANSID	48
#define	JBCINT_IN_TRANSACTION_ERROR_LOG_TRANSID_MASK	0x3f
#define	JBCINT_IN_TRANSACTION_ERROR_LOG_ADDRESS	0
#define	JBCINT_IN_TRANSACTION_ERROR_LOG_ADDRESS_MASK	0x7ffffffffff
#define	JBCINT_IN_TRANSACTION_ERROR_LOG_2	0x471038
#define	JBCINT_IN_TRANSACTION_ERROR_LOG_2_ARB_WIN	28
#define	JBCINT_IN_TRANSACTION_ERROR_LOG_2_ARB_WIN_MASK	0xffffff
#define	JBCINT_IN_TRANSACTION_ERROR_LOG_2_J_REQ	21
#define	JBCINT_IN_TRANSACTION_ERROR_LOG_2_J_REQ_MASK	0x7f
#define	JBCINT_IN_TRANSACTION_ERROR_LOG_2_J_PACK	0
#define	JBCINT_IN_TRANSACTION_ERROR_LOG_2_J_PACK_MASK	0x1fffff
#define	JBCINT_OUT_TRANSACTION_ERROR_LOG	0x471040
#define	JBCINT_OUT_TRANSACTION_ERROR_LOG_TRANSID	48
#define	JBCINT_OUT_TRANSACTION_ERROR_LOG_TRANSID_MASK	0x3f
#define	JBCINT_OUT_TRANSACTION_ERROR_LOG_ADDRESS	0
#define	JBCINT_OUT_TRANSACTION_ERROR_LOG_ADDRESS_MASK	0x7ffffffffff
#define	JBCINT_OUT_TRANSACTION_ERROR_LOG_2	0x471048
#define	JBCINT_OUT_TRANSACTION_ERROR_LOG_2_ARB_WIN	28
#define	JBCINT_OUT_TRANSACTION_ERROR_LOG_2_ARB_WIN_MASK	0xffffff
#define	JBCINT_OUT_TRANSACTION_ERROR_LOG_2_J_REQ	21
#define	JBCINT_OUT_TRANSACTION_ERROR_LOG_2_J_REQ_MASK	0x7f
#define	JBCINT_OUT_TRANSACTION_ERROR_LOG_2_J_PACK	0
#define	JBCINT_OUT_TRANSACTION_ERROR_LOG_2_J_PACK_MASK	0x1fffff
#define	FATAL_ERROR_LOG_1	0x471050
#define	FATAL_ERROR_LOG_1_DATA	0
#define	FATAL_ERROR_LOG_1_DATA_MASK	0xffffffffffffffff
#define	FATAL_ERROR_LOG_2	0x471058
#define	FATAL_ERROR_LOG_2_ARB_WIN	28
#define	FATAL_ERROR_LOG_2_ARB_WIN_MASK	0xffffff
#define	FATAL_ERROR_LOG_2_J_REQ	21
#define	FATAL_ERROR_LOG_2_J_REQ_MASK	0x7f
#define	FATAL_ERROR_LOG_2_J_PACK	0
#define	FATAL_ERROR_LOG_2_J_PACK_MASK	0x1fffff
#define	MERGE_TRANSACTION_ERROR_LOG	0x471060
#define	MERGE_TRANSACTION_ERROR_LOG_Q_WORD	54
#define	MERGE_TRANSACTION_ERROR_LOG_Q_WORD_MASK	0x3
#define	MERGE_TRANSACTION_ERROR_LOG_TRANSID	48
#define	MERGE_TRANSACTION_ERROR_LOG_TRANSID_MASK	0x3f
#define	MERGE_TRANSACTION_ERROR_LOG_JBC_TAG	43
#define	MERGE_TRANSACTION_ERROR_LOG_JBC_TAG_MASK	0x1f
#define	MERGE_TRANSACTION_ERROR_LOG_ADDRESS	0
#define	MERGE_TRANSACTION_ERROR_LOG_ADDRESS_MASK	0x7ffffffffff
#define	DMCINT_ODCD_ERROR_LOG	0x471068
#define	DMCINT_ODCD_ERROR_LOG_TRANS_ID	52
#define	DMCINT_ODCD_ERROR_LOG_TRANS_ID_MASK	0x3
#define	DMCINT_ODCD_ERROR_LOG_AID	48
#define	DMCINT_ODCD_ERROR_LOG_AID_MASK	0xf
#define	DMCINT_ODCD_ERROR_LOG_TRANS_TYPE	43
#define	DMCINT_ODCD_ERROR_LOG_TRANS_TYPE_MASK	0x1f
#define	DMCINT_ODCD_ERROR_LOG_ADDRESS	0
#define	DMCINT_ODCD_ERROR_LOG_ADDRESS_MASK	0x7ffffffffff
#define	DMCINT_IDC_ERROR_LOG	0x471070
#define	DMCINT_IDC_ERROR_LOG_DMC_CTAG	16
#define	DMCINT_IDC_ERROR_LOG_DMC_CTAG_MASK	0xfff
#define	DMCINT_IDC_ERROR_LOG_TRANSID	14
#define	DMCINT_IDC_ERROR_LOG_TRANSID_MASK	0x3
#define	DMCINT_IDC_ERROR_LOG_AGNTID	10
#define	DMCINT_IDC_ERROR_LOG_AGNTID_MASK	0xf
#define	DMCINT_IDC_ERROR_LOG_SRCID	5
#define	DMCINT_IDC_ERROR_LOG_SRCID_MASK	0x1f
#define	DMCINT_IDC_ERROR_LOG_TARGID	0
#define	DMCINT_IDC_ERROR_LOG_TARGID_MASK	0x1f
#define	CSR_ERROR_LOG	0x471078
#define	CSR_ERROR_LOG_WRITE	  42
#define	CSR_ERROR_LOG_BMASK	26
#define	CSR_ERROR_LOG_BMASK_MASK	0xffff
#define	CSR_ERROR_LOG_ADDRESS	0
#define	CSR_ERROR_LOG_ADDRESS_MASK	0x3ffffff
#define	JBC_CORE_AND_BLOCK_INTERRUPT_ENABLE	0x471800
#define	JBC_CORE_AND_BLOCK_INTERRUPT_ENABLE_JBC	  63
#define	JBC_CORE_AND_BLOCK_INTERRUPT_ENABLE_CSR	  3
#define	JBC_CORE_AND_BLOCK_INTERRUPT_ENABLE_MERGE	  2
#define	JBC_CORE_AND_BLOCK_INTERRUPT_ENABLE_JBCINT	  1
#define	JBC_CORE_AND_BLOCK_INTERRUPT_ENABLE_DMCINT	  0
#define	JBC_CORE_AND_BLOCK_ERROR_STATUS	0x471808
#define	JBC_CORE_AND_BLOCK_ERROR_STATUS_CSR	  3
#define	JBC_CORE_AND_BLOCK_ERROR_STATUS_MERGE	  2
#define	JBC_CORE_AND_BLOCK_ERROR_STATUS_JBCINT	  1
#define	JBC_CORE_AND_BLOCK_ERROR_STATUS_DMCINT	  0
#define	JBC_PERFORMANCE_COUNTER_SELECT	0x472000
#define	JBC_PERFORMANCE_COUNTER_SELECT_SEL1	8
#define	JBC_PERFORMANCE_COUNTER_SELECT_SEL1_MASK	0xff
#define	JBC_PERFORMANCE_COUNTER_SELECT_SEL0	0
#define	JBC_PERFORMANCE_COUNTER_SELECT_SEL0_MASK	0xff
#define	JBC_PERFORMANCE_COUNTER_ZERO	0x472008
#define	JBC_PERFORMANCE_COUNTER_ZERO_CNT	0
#define	JBC_PERFORMANCE_COUNTER_ZERO_CNT_MASK	0xffffffffffffffff
#define	JBC_PERFORMANCE_COUNTER_ONE	0x472010
#define	JBC_PERFORMANCE_COUNTER_ONE_CNT	0
#define	JBC_PERFORMANCE_COUNTER_ONE_CNT_MASK	0xffffffffffffffff
#define	FIRE_AND_JBC_DEBUG_SELECT_A	0x473000
#define	FIRE_AND_JBC_DEBUG_SELECT_A_CORE_SEL	10
#define	FIRE_AND_JBC_DEBUG_SELECT_A_CORE_SEL_MASK	0x3
#define	FIRE_AND_JBC_DEBUG_SELECT_A_BLOCK_SEL	6
#define	FIRE_AND_JBC_DEBUG_SELECT_A_BLOCK_SEL_MASK	0x7
#define	FIRE_AND_JBC_DEBUG_SELECT_A_SUB_SEL	3
#define	FIRE_AND_JBC_DEBUG_SELECT_A_SUB_SEL_MASK	0x7
#define	FIRE_AND_JBC_DEBUG_SELECT_A_SIGNAL_SEL	0
#define	FIRE_AND_JBC_DEBUG_SELECT_A_SIGNAL_SEL_MASK	0x7
#define	FIRE_AND_JBC_DEBUG_SELECT_B	0x473008
#define	FIRE_AND_JBC_DEBUG_SELECT_B_CORE_SEL	10
#define	FIRE_AND_JBC_DEBUG_SELECT_B_CORE_SEL_MASK	0x3
#define	FIRE_AND_JBC_DEBUG_SELECT_B_BLOCK_SEL	6
#define	FIRE_AND_JBC_DEBUG_SELECT_B_BLOCK_SEL_MASK	0x7
#define	FIRE_AND_JBC_DEBUG_SELECT_B_SUB_SEL	3
#define	FIRE_AND_JBC_DEBUG_SELECT_B_SUB_SEL_MASK	0x7
#define	FIRE_AND_JBC_DEBUG_SELECT_B_SIGNAL_SEL	0
#define	FIRE_AND_JBC_DEBUG_SELECT_B_SIGNAL_SEL_MASK	0x7

/* iss.csr  ISS module defines */

#define	ISS_CSR_BASE	0x600000
#define	INTERRUPT_MAPPING	0x1000
#define	INTERRUPT_MAPPING_ENTRIES	64
#define	INTERRUPT_MAPPING_ENTRIES_MDO_MODE	  63
#define	INTERRUPT_MAPPING_ENTRIES_V	  31
#define	INTERRUPT_MAPPING_ENTRIES_T_JPID	26
#define	INTERRUPT_MAPPING_ENTRIES_T_JPID_MASK	0x1f
#define	INTERRUPT_MAPPING_ENTRIES_INT_CNTRL_NUM	6
#define	INTERRUPT_MAPPING_ENTRIES_INT_CNTRL_NUM_MASK	0xf

/* Reserved 0x1200 - 0x13f8 */

#define	INTERRUPT_CLEAR	0x1400
#define	INTERRUPT_CLEAR_ENTRIES	64
#define	INTERRUPT_CLEAR_ENTRIES_INT_STATE	0
#define	INTERRUPT_CLEAR_ENTRIES_INT_STATE_MASK	0x3

/* Reserved 0x1600 - 0x17f8 */


/* Reserved 0x1808 - 0x19f8 */

#define	INTERRUPT_RETRY_TIMER	0x1a00
#define	INTERRUPT_RETRY_TIMER_LIMIT	0
#define	INTERRUPT_RETRY_TIMER_LIMIT_MASK	0x1ffffff

/* Reserved 0x1a08 - 0x1a08 */

#define	INTERRUPT_STATE_STATUS_1	0x1a10
#define	INTERRUPT_STATE_STATUS_1_STATE	0
#define	INTERRUPT_STATE_STATUS_1_STATE_MASK	0xffffffffffffffff
#define	INTERRUPT_STATE_STATUS_2	0x1a18
#define	INTERRUPT_STATE_STATUS_2_STATE	0
#define	INTERRUPT_STATE_STATUS_2_STATE_MASK	0xffffffffffffffff

/* intx.csr  INTX module defines */

#define	INTX_CSR_BASE	0x600000
#define	INTX_STATUS	0xb000
#define	INTX_STATUS_INT_A	  3
#define	INTX_STATUS_INT_B	  2
#define	INTX_STATUS_INT_C	  1
#define	INTX_STATUS_INT_D	  0
#define	INT_A_CLEAR	0xb008
#define	INT_A_CLEAR_CLR	  0
#define	INT_B_CLEAR	0xb010
#define	INT_B_CLEAR_CLR	  0
#define	INT_C_CLEAR	0xb018
#define	INT_C_CLEAR_CLR	  0
#define	INT_D_CLEAR	0xb020
#define	INT_D_CLEAR_CLR	  0

/* eqs.csr  EQS module defines */

#define	EQS_CSR_BASE	0x600000
#define	EVENT_QUEUE_BASE_ADDRESS	0x10000
#define	EVENT_QUEUE_BASE_ADDRESS_ADDRESS	19
#define	EVENT_QUEUE_BASE_ADDRESS_ADDRESS_MASK	0x1fffffffffff

/* Reserved 0x10008 - 0x10ff8 */

#define	EVENT_QUEUE_CONTROL_SET	0x11000
#define	EVENT_QUEUE_CONTROL_SET_ENTRIES	36
#define	EVENT_QUEUE_CONTROL_SET_ENTRIES_ENOVERR	  57
#define	EVENT_QUEUE_CONTROL_SET_ENTRIES_EN	  44

/* Reserved 0x11120 - 0x111f8 */

#define	EVENT_QUEUE_CONTROL_CLEAR	0x11200
#define	EVENT_QUEUE_CONTROL_CLEAR_ENTRIES	36
#define	EVENT_QUEUE_CONTROL_CLEAR_ENTRIES_COVERR	  57
#define	EVENT_QUEUE_CONTROL_CLEAR_ENTRIES_E2I	  47
#define	EVENT_QUEUE_CONTROL_CLEAR_ENTRIES_DIS	  44

/* Reserved 0x11320 - 0x113f8 */

#define	EVENT_QUEUE_STATE	0x11400
#define	EVENT_QUEUE_STATE_ENTRIES	36
#define	EVENT_QUEUE_STATE_ENTRIES_STATE	0
#define	EVENT_QUEUE_STATE_ENTRIES_STATE_MASK	0x7

/* Reserved 0x11520 - 0x115f8 */

#define	EVENT_QUEUE_TAIL	0x11600
#define	EVENT_QUEUE_TAIL_ENTRIES	36
#define	EVENT_QUEUE_TAIL_ENTRIES_OVERR	  57
#define	EVENT_QUEUE_TAIL_ENTRIES_TAIL	0
#define	EVENT_QUEUE_TAIL_ENTRIES_TAIL_MASK	0x7f

/* Reserved 0x11720 - 0x117f8 */

#define	EVENT_QUEUE_HEAD	0x11800
#define	EVENT_QUEUE_HEAD_ENTRIES	36
#define	EVENT_QUEUE_HEAD_ENTRIES_HEAD	0
#define	EVENT_QUEUE_HEAD_ENTRIES_HEAD_MASK	0x7f

/* msi.csr  MSI module defines */

#define	MSI_CSR_BASE	0x600000
#define	MSI_MAPPING	0x20000
#define	MSI_MAPPING_ENTRIES	256
#define	MSI_MAPPING_ENTRIES_V	  63
#define	MSI_MAPPING_ENTRIES_EQWR_N	  62
#define	MSI_MAPPING_ENTRIES_EQNUM	0
#define	MSI_MAPPING_ENTRIES_EQNUM_MASK	0x3f

/* Reserved 0x20800 - 0x27ff8 */

#define	MSI_CLEAR	0x28000
#define	MSI_CLEAR_ENTRIES	256
#define	MSI_CLEAR_ENTRIES_EQWR_N	  62

/* Reserved 0x28800 - 0x2bff8 */

#define	INTERRUPT_MONDO_DATA_0	0x2c000
#define	INTERRUPT_MONDO_DATA_0_DATA	6
#define	INTERRUPT_MONDO_DATA_0_DATA_MASK	0x3ffffffffffffff
#define	INTERRUPT_MONDO_DATA_1	0x2c008
#define	INTERRUPT_MONDO_DATA_1_DATA	0
#define	INTERRUPT_MONDO_DATA_1_DATA_MASK	0xffffffffffffffff

/* mess.csr  MESS module defines */

#define	MESS_CSR_BASE	0x600000
#define	ERR_COR_MAPPING	0x30000
#define	ERR_COR_MAPPING_V	  63
#define	ERR_COR_MAPPING_EQNUM	0
#define	ERR_COR_MAPPING_EQNUM_MASK	0x3f
#define	ERR_NONFATAL_MAPPING	0x30008
#define	ERR_NONFATAL_MAPPING_V	  63
#define	ERR_NONFATAL_MAPPING_EQNUM	0
#define	ERR_NONFATAL_MAPPING_EQNUM_MASK	0x3f
#define	ERR_FATAL_MAPPING	0x30010
#define	ERR_FATAL_MAPPING_V	  63
#define	ERR_FATAL_MAPPING_EQNUM	0
#define	ERR_FATAL_MAPPING_EQNUM_MASK	0x3f
#define	PM_PME_MAPPING	0x30018
#define	PM_PME_MAPPING_V	  63
#define	PM_PME_MAPPING_EQNUM	0
#define	PM_PME_MAPPING_EQNUM_MASK	0x3f
#define	PME_TO_ACK_MAPPING	0x30020
#define	PME_TO_ACK_MAPPING_V	  63
#define	PME_TO_ACK_MAPPING_EQNUM	0
#define	PME_TO_ACK_MAPPING_EQNUM_MASK	0x3f

/* ics.csr  ICS module defines */

#define	ICS_CSR_BASE	0x600000
#define	IMU_ERROR_LOG_ENABLE	0x31000
#define	IMU_ERROR_LOG_ENABLE_SPARE_LOG_EN	10
#define	IMU_ERROR_LOG_ENABLE_SPARE_LOG_EN_MASK	0x1f
#define	IMU_ERROR_LOG_ENABLE_EQ_OVER_LOG_EN	  9
#define	IMU_ERROR_LOG_ENABLE_EQ_NOT_EN_LOG_EN	  8
#define	IMU_ERROR_LOG_ENABLE_MSI_MAL_ERR_LOG_EN	  7
#define	IMU_ERROR_LOG_ENABLE_MSI_PAR_ERR_LOG_EN	  6
#define	IMU_ERROR_LOG_ENABLE_PMEACK_MES_NOT_EN_LOG_EN	  5
#define	IMU_ERROR_LOG_ENABLE_PMPME_MES_NOT_EN_LOG_EN	  4
#define	IMU_ERROR_LOG_ENABLE_FATAL_MES_NOT_EN_LOG_EN	  3
#define	IMU_ERROR_LOG_ENABLE_NONFATAL_MES_NOT_EN_LOG_EN	  2
#define	IMU_ERROR_LOG_ENABLE_COR_MES_NOT_EN_LOG_EN	  1
#define	IMU_ERROR_LOG_ENABLE_MSI_NOT_EN_LOG_EN	  0
#define	IMU_INTERRUPT_ENABLE	0x31008
#define	IMU_INTERRUPT_ENABLE_SPARE_S_INT_EN	42
#define	IMU_INTERRUPT_ENABLE_SPARE_S_INT_EN_MASK	0x1f
#define	IMU_INTERRUPT_ENABLE_EQ_OVER_S_INT_EN	  41
#define	IMU_INTERRUPT_ENABLE_EQ_NOT_EN_S_INT_EN	  40
#define	IMU_INTERRUPT_ENABLE_MSI_MAL_ERR_S_INT_EN	  39
#define	IMU_INTERRUPT_ENABLE_MSI_PAR_ERR_S_INT_EN	  38
#define	IMU_INTERRUPT_ENABLE_PMEACK_MES_NOT_EN_S_INT_EN	  37
#define	IMU_INTERRUPT_ENABLE_PMPME_MES_NOT_EN_S_INT_EN	  36
#define	IMU_INTERRUPT_ENABLE_FATAL_MES_NOT_EN_S_INT_EN	  35
#define	IMU_INTERRUPT_ENABLE_NONFATAL_MES_NOT_EN_S_INT_EN	  34
#define	IMU_INTERRUPT_ENABLE_COR_MES_NOT_EN_S_INT_EN	  33
#define	IMU_INTERRUPT_ENABLE_MSI_NOT_EN_S_INT_EN	  32
#define	IMU_INTERRUPT_ENABLE_SPARE_P_INT_EN	10
#define	IMU_INTERRUPT_ENABLE_SPARE_P_INT_EN_MASK	0x1f
#define	IMU_INTERRUPT_ENABLE_EQ_OVER_P_INT_EN	  9
#define	IMU_INTERRUPT_ENABLE_EQ_NOT_EN_P_INT_EN	  8
#define	IMU_INTERRUPT_ENABLE_MSI_MAL_ERR_P_INT_EN	  7
#define	IMU_INTERRUPT_ENABLE_MSI_PAR_ERR_P_INT_EN	  6
#define	IMU_INTERRUPT_ENABLE_PMEACK_MES_NOT_EN_P_INT_EN	  5
#define	IMU_INTERRUPT_ENABLE_PMPME_MES_NOT_EN_P_INT_EN	  4
#define	IMU_INTERRUPT_ENABLE_FATAL_MES_NOT_EN_P_INT_EN	  3
#define	IMU_INTERRUPT_ENABLE_NONFATAL_MES_NOT_EN_P_INT_EN	  2
#define	IMU_INTERRUPT_ENABLE_COR_MES_NOT_EN_P_INT_EN	  1
#define	IMU_INTERRUPT_ENABLE_MSI_NOT_EN_P_INT_EN	  0
#define	IMU_INTERRUPT_STATUS	0x31010
#define	IMU_INTERRUPT_STATUS_SPARE_S	42
#define	IMU_INTERRUPT_STATUS_SPARE_S_MASK	0x1f
#define	IMU_INTERRUPT_STATUS_EQ_OVER_S	  41
#define	IMU_INTERRUPT_STATUS_EQ_NOT_EN_S	  40
#define	IMU_INTERRUPT_STATUS_MSI_MAL_ERR_S	  39
#define	IMU_INTERRUPT_STATUS_MSI_PAR_ERR_S	  38
#define	IMU_INTERRUPT_STATUS_PMEACK_MES_NOT_EN_S	  37
#define	IMU_INTERRUPT_STATUS_PMPME_MES_NOT_EN_S	  36
#define	IMU_INTERRUPT_STATUS_FATAL_MES_NOT_EN_S	  35
#define	IMU_INTERRUPT_STATUS_NONFATAL_MES_NOT_EN_S	  34
#define	IMU_INTERRUPT_STATUS_COR_MES_NOT_EN_S	  33
#define	IMU_INTERRUPT_STATUS_MSI_NOT_EN_S	  32
#define	IMU_INTERRUPT_STATUS_SPARE_P	10
#define	IMU_INTERRUPT_STATUS_SPARE_P_MASK	0x1f
#define	IMU_INTERRUPT_STATUS_EQ_OVER_P	  9
#define	IMU_INTERRUPT_STATUS_EQ_NOT_EN_P	  8
#define	IMU_INTERRUPT_STATUS_MSI_MAL_ERR_P	  7
#define	IMU_INTERRUPT_STATUS_MSI_PAR_ERR_P	  6
#define	IMU_INTERRUPT_STATUS_PMEACK_MES_NOT_EN_P	  5
#define	IMU_INTERRUPT_STATUS_PMPME_MES_NOT_EN_P	  4
#define	IMU_INTERRUPT_STATUS_FATAL_MES_NOT_EN_P	  3
#define	IMU_INTERRUPT_STATUS_NONFATAL_MES_NOT_EN_P	  2
#define	IMU_INTERRUPT_STATUS_COR_MES_NOT_EN_P	  1
#define	IMU_INTERRUPT_STATUS_MSI_NOT_EN_P	  0
#define	IMU_ERROR_STATUS_CLEAR	0x31018
#define	IMU_ERROR_STATUS_CLEAR_SPARE_S	42
#define	IMU_ERROR_STATUS_CLEAR_SPARE_S_MASK	0x1f
#define	IMU_ERROR_STATUS_CLEAR_EQ_OVER_S	  41
#define	IMU_ERROR_STATUS_CLEAR_EQ_NOT_EN_S	  40
#define	IMU_ERROR_STATUS_CLEAR_MSI_MAL_ERR_S	  39
#define	IMU_ERROR_STATUS_CLEAR_MSI_PAR_ERR_S	  38
#define	IMU_ERROR_STATUS_CLEAR_PMEACK_MES_NOT_EN_S	  37
#define	IMU_ERROR_STATUS_CLEAR_PMPME_MES_NOT_EN_S	  36
#define	IMU_ERROR_STATUS_CLEAR_FATAL_MES_NOT_EN_S	  35
#define	IMU_ERROR_STATUS_CLEAR_NONFATAL_MES_NOT_EN_S	  34
#define	IMU_ERROR_STATUS_CLEAR_COR_MES_NOT_EN_S	  33
#define	IMU_ERROR_STATUS_CLEAR_MSI_NOT_EN_S	  32
#define	IMU_ERROR_STATUS_CLEAR_SPARE_P	10
#define	IMU_ERROR_STATUS_CLEAR_SPARE_P_MASK	0x1f
#define	IMU_ERROR_STATUS_CLEAR_EQ_OVER_P	  9
#define	IMU_ERROR_STATUS_CLEAR_EQ_NOT_EN_P	  8
#define	IMU_ERROR_STATUS_CLEAR_MSI_MAL_ERR_P	  7
#define	IMU_ERROR_STATUS_CLEAR_MSI_PAR_ERR_P	  6
#define	IMU_ERROR_STATUS_CLEAR_PMEACK_MES_NOT_EN_P	  5
#define	IMU_ERROR_STATUS_CLEAR_PMPME_MES_NOT_EN_P	  4
#define	IMU_ERROR_STATUS_CLEAR_FATAL_MES_NOT_EN_P	  3
#define	IMU_ERROR_STATUS_CLEAR_NONFATAL_MES_NOT_EN_P	  2
#define	IMU_ERROR_STATUS_CLEAR_COR_MES_NOT_EN_P	  1
#define	IMU_ERROR_STATUS_CLEAR_MSI_NOT_EN_P	  0
#define	IMU_ERROR_STATUS_SET	0x31020
#define	IMU_ERROR_STATUS_SET_SPARE_S	42
#define	IMU_ERROR_STATUS_SET_SPARE_S_MASK	0xfa
#define	IMU_ERROR_STATUS_SET_EQ_OVER_S	  41
#define	IMU_ERROR_STATUS_SET_EQ_NOT_EN_S	  40
#define	IMU_ERROR_STATUS_SET_MSI_MAL_ERR_S	  39
#define	IMU_ERROR_STATUS_SET_MSI_PAR_ERR_S	  38
#define	IMU_ERROR_STATUS_SET_PMEACK_MES_NOT_EN_S	  37
#define	IMU_ERROR_STATUS_SET_PMPME_MES_NOT_EN_S	  36
#define	IMU_ERROR_STATUS_SET_FATAL_MES_NOT_EN_S	  35
#define	IMU_ERROR_STATUS_SET_NONFATAL_MES_NOT_EN_S	  34
#define	IMU_ERROR_STATUS_SET_COR_MES_NOT_EN_S	  33
#define	IMU_ERROR_STATUS_SET_MSI_NOT_EN_S	  32
#define	IMU_ERROR_STATUS_SET_SPARE_P	10
#define	IMU_ERROR_STATUS_SET_SPARE_P_MASK	0xfa
#define	IMU_ERROR_STATUS_SET_EQ_OVER_P	  9
#define	IMU_ERROR_STATUS_SET_EQ_NOT_EN_P	  8
#define	IMU_ERROR_STATUS_SET_MSI_MAL_ERR_P	  7
#define	IMU_ERROR_STATUS_SET_MSI_PAR_ERR_P	  6
#define	IMU_ERROR_STATUS_SET_PMEACK_MES_NOT_EN_P	  5
#define	IMU_ERROR_STATUS_SET_PMPME_MES_NOT_EN_P	  4
#define	IMU_ERROR_STATUS_SET_FATAL_MES_NOT_EN_P	  3
#define	IMU_ERROR_STATUS_SET_NONFATAL_MES_NOT_EN_P	  2
#define	IMU_ERROR_STATUS_SET_COR_MES_NOT_EN_P	  1
#define	IMU_ERROR_STATUS_SET_MSI_NOT_EN_P	  0
#define	IMU_RDS_ERROR_LOG	0x31028
#define	IMU_RDS_ERROR_LOG_TYPE	58
#define	IMU_RDS_ERROR_LOG_TYPE_MASK	0x3f
#define	IMU_RDS_ERROR_LOG_LENGTH	48
#define	IMU_RDS_ERROR_LOG_LENGTH_MASK	0x3ff
#define	IMU_RDS_ERROR_LOG_REQ_ID	32
#define	IMU_RDS_ERROR_LOG_REQ_ID_MASK	0xffff
#define	IMU_RDS_ERROR_LOG_TLP_TAG	24
#define	IMU_RDS_ERROR_LOG_TLP_TAG_MASK	0xff
#define	IMU_RDS_ERROR_LOG_BE_MESS_CODE	16
#define	IMU_RDS_ERROR_LOG_BE_MESS_CODE_MASK	0xff
#define	IMU_RDS_ERROR_LOG_MSI_DATA	0
#define	IMU_RDS_ERROR_LOG_MSI_DATA_MASK	0xffff
#define	IMU_SCS_ERROR_LOG	0x31030
#define	IMU_SCS_ERROR_LOG_TYPE	58
#define	IMU_SCS_ERROR_LOG_TYPE_MASK	0x3f
#define	IMU_SCS_ERROR_LOG_LENGTH	48
#define	IMU_SCS_ERROR_LOG_LENGTH_MASK	0x3ff
#define	IMU_SCS_ERROR_LOG_REQ_ID	32
#define	IMU_SCS_ERROR_LOG_REQ_ID_MASK	0xffff
#define	IMU_SCS_ERROR_LOG_TLP_TAG	24
#define	IMU_SCS_ERROR_LOG_TLP_TAG_MASK	0xff
#define	IMU_SCS_ERROR_LOG_BE_MESS_CODE	16
#define	IMU_SCS_ERROR_LOG_BE_MESS_CODE_MASK	0xff
#define	IMU_SCS_ERROR_LOG_EQ_NUM	0
#define	IMU_SCS_ERROR_LOG_EQ_NUM_MASK	0x3f
#define	IMU_EQS_ERROR_LOG	0x31038
#define	IMU_EQS_ERROR_LOG_EQ_NUM	0
#define	IMU_EQS_ERROR_LOG_EQ_NUM_MASK	0x3f

/* Reserved 0x31040 - 0x317f8 */

#define	DMC_CORE_AND_BLOCK_INTERRUPT_ENABLE	0x31800
#define	DMC_CORE_AND_BLOCK_INTERRUPT_ENABLE_DMC	  63
#define	DMC_CORE_AND_BLOCK_INTERRUPT_ENABLE_MMU	  1
#define	DMC_CORE_AND_BLOCK_INTERRUPT_ENABLE_IMU	  0
#define	DMC_CORE_AND_BLOCK_ERROR_STATUS	0x31808
#define	DMC_CORE_AND_BLOCK_ERROR_STATUS_MMU	  1
#define	DMC_CORE_AND_BLOCK_ERROR_STATUS_IMU	  0
#define	MULTI_CORE_ERROR_STATUS	0x31810
#define	MULTI_CORE_ERROR_STATUS_PEC	  1
#define	MULTI_CORE_ERROR_STATUS_DMC	  0

/* Reserved 0x31818 - 0x31ff8 */

#define	IMU_PERFORMANCE_COUNTER_SELECT	0x32000
#define	IMU_PERFORMANCE_COUNTER_SELECT_SEL1	8
#define	IMU_PERFORMANCE_COUNTER_SELECT_SEL1_MASK	0xff
#define	IMU_PERFORMANCE_COUNTER_SELECT_SEL0	0
#define	IMU_PERFORMANCE_COUNTER_SELECT_SEL0_MASK	0xff
#define	IMU_PERFORMANCE_COUNTER_ZERO	0x32008
#define	IMU_PERFORMANCE_COUNTER_ZERO_CNT	0
#define	IMU_PERFORMANCE_COUNTER_ZERO_CNT_MASK	0xffffffffffffffff
#define	IMU_PERFORMANCE_COUNTER_ONE	0x32010
#define	IMU_PERFORMANCE_COUNTER_ONE_CNT	0
#define	IMU_PERFORMANCE_COUNTER_ONE_CNT_MASK	0xffffffffffffffff

/* Reserved 0x32018 - 0x33ff8 */

#define	MSI_32_BIT_ADDRESS	0x34000
#define	MSI_32_BIT_ADDRESS_ADDR	16
#define	MSI_32_BIT_ADDRESS_ADDR_MASK	0xffff
#define	MSI_64_BIT_ADDRESS	0x34008
#define	MSI_64_BIT_ADDRESS_ADDR	16
#define	MSI_64_BIT_ADDRESS_ADDR_MASK	0xffffffffffff

/* Reserved 0x34010 - 0x34010 */

#define	MEM_64_PCIE_OFFSET	0x34018
#define	MEM_64_PCIE_OFFSET_ADDR	24
#define	MEM_64_PCIE_OFFSET_ADDR_MASK	0xffffffffff
#define	MEM_64_PCIE_OFFSET_SPARE_CONTROL_LOAD_7	  23
#define	MEM_64_PCIE_OFFSET_SPARE_CONTROL_LOAD_6	  22
#define	MEM_64_PCIE_OFFSET_SPARE_CONTROL_LOAD_5	  21
#define	MEM_64_PCIE_OFFSET_SPARE_CONTROL_LOAD_4	  20
#define	MEM_64_PCIE_OFFSET_SPARE_CONTROL_LOAD_3	  19
#define	MEM_64_PCIE_OFFSET_SPARE_CONTROL_LOAD_2	  18
#define	MEM_64_PCIE_OFFSET_SPARE_CONTROL_LOAD_1	  17
#define	MEM_64_PCIE_OFFSET_SPARE_CONTROL_LOAD_0	  16
#define	MEM_64_PCIE_OFFSET_SPARE_CONTROL	8
#define	MEM_64_PCIE_OFFSET_SPARE_CONTROL_MASK	0xff
#define	MEM_64_PCIE_OFFSET_SPARE_STATUS	0
#define	MEM_64_PCIE_OFFSET_SPARE_STATUS_MASK	0xff

/* csr.csr  CSR module defines */

#define	CSR_CSR_BASE	0x600000
#define	MMU_CONTROL_AND_STATUS	0x40000
#define	MMU_CONTROL_AND_STATUS_SPARES	48
#define	MMU_CONTROL_AND_STATUS_SPARES_MASK	0xf
#define	MMU_CONTROL_AND_STATUS_PAQ	  45
#define	MMU_CONTROL_AND_STATUS_VAQ	  44
#define	MMU_CONTROL_AND_STATUS_TPL	  43
#define	MMU_CONTROL_AND_STATUS_TIP	  42
#define	MMU_CONTROL_AND_STATUS_TCM	40
#define	MMU_CONTROL_AND_STATUS_TCM_MASK	0x3
#define	MMU_CONTROL_AND_STATUS_ROE	16
#define	MMU_CONTROL_AND_STATUS_ROE_MASK	0x7
#define	MMU_CONTROL_AND_STATUS_ROE_BIT63_ENABLE	(1 << 2)
#define	MMU_CONTROL_AND_STATUS_ROE_BIT43_ENABLE	(1 << 1)
#define	MMU_CONTROL_AND_STATUS_ROE_BIT35_ENABLE	(1 << 0)
#define	MMU_CONTROL_AND_STATUS_PD	  12
#define	MMU_CONTROL_AND_STATUS_SE	  10
#define	MMU_CONTROL_AND_STATUS_CM	8
#define	MMU_CONTROL_AND_STATUS_CM_MASK	0x3
#define	MMU_CONTROL_AND_STATUS_BE	  1
#define	MMU_CONTROL_AND_STATUS_TE	  0
#define	MMU_TSB_CONTROL	0x40008
#define	MMU_TSB_CONTROL_TB	13
#define	MMU_TSB_CONTROL_TB_MASK	0x3fffffff
#define	MMU_TSB_CONTROL_PS	  8
#define	MMU_TSB_CONTROL_TS	0
#define	MMU_TSB_CONTROL_TS_MASK	0xf

/* Reserved 0x40010 - 0x400f8 */

#define	MMU_TTE_CACHE_FLUSH_ADDRESS	0x40100
#define	MMU_TTE_CACHE_FLUSH_ADDRESS_FLSH_ADDR	6
#define	MMU_TTE_CACHE_FLUSH_ADDRESS_FLSH_ADDR_MASK	0x1fffffffff
#define	MMU_TTE_CACHE_INVALIDATE	0x40108
#define	MMU_TTE_CACHE_INVALIDATE_FLSH_TTE	0
#define	MMU_TTE_CACHE_INVALIDATE_FLSH_TTE_MASK	0xffffffffffffffff

/* Reserved 0x40110 - 0x40ff8 */

#define	MMU_ERROR_LOG_ENABLE	0x41000
#define	MMU_ERROR_LOG_ENABLE_EN	0
#define	MMU_ERROR_LOG_ENABLE_EN_MASK	0xffff
#define	MMU_INTERRUPT_ENABLE	0x41008
#define	MMU_INTERRUPT_ENABLE_EN_S	32
#define	MMU_INTERRUPT_ENABLE_EN_S_MASK	0xffff
#define	MMU_INTERRUPT_ENABLE_EN_P	0
#define	MMU_INTERRUPT_ENABLE_EN_P_MASK	0xffff
#define	MMU_INTERRUPT_STATUS	0x41010
#define	MMU_INTERRUPT_STATUS_ERR_S	32
#define	MMU_INTERRUPT_STATUS_ERR_S_MASK	0xffff
#define	MMU_INTERRUPT_STATUS_ERR_P	0
#define	MMU_INTERRUPT_STATUS_ERR_P_MASK	0xffff
#define	MMU_INTERRUPT_STATUS_TBW_DPE_S	  47
#define	MMU_INTERRUPT_STATUS_TBW_ERR_S	  46
#define	MMU_INTERRUPT_STATUS_TBW_UDE_S	  45
#define	MMU_INTERRUPT_STATUS_TBW_DME_S	  44
#define	MMU_INTERRUPT_STATUS_SPARE3_S	  43
#define	MMU_INTERRUPT_STATUS_SPARE2_S	  42
#define	MMU_INTERRUPT_STATUS_TTC_CAE_S	  41
#define	MMU_INTERRUPT_STATUS_TTC_DPE_S	  40
#define	MMU_INTERRUPT_STATUS_TTE_PRT_S	  39
#define	MMU_INTERRUPT_STATUS_TTE_INV_S	  38
#define	MMU_INTERRUPT_STATUS_TRN_OOR_S	  37
#define	MMU_INTERRUPT_STATUS_TRN_ERR_S	  36
#define	MMU_INTERRUPT_STATUS_SPARE1_S	  35
#define	MMU_INTERRUPT_STATUS_SPARE0_S	  34
#define	MMU_INTERRUPT_STATUS_BYP_OOR_S	  33
#define	MMU_INTERRUPT_STATUS_BYP_ERR_S	  32
#define	MMU_INTERRUPT_STATUS_TBW_DPE_P	  15
#define	MMU_INTERRUPT_STATUS_TBW_ERR_P	  14
#define	MMU_INTERRUPT_STATUS_TBW_UDE_P	  13
#define	MMU_INTERRUPT_STATUS_TBW_DME_P	  12
#define	MMU_INTERRUPT_STATUS_SPARE3_P	  11
#define	MMU_INTERRUPT_STATUS_SPARE2_P	  10
#define	MMU_INTERRUPT_STATUS_TTC_CAE_P	  9
#define	MMU_INTERRUPT_STATUS_TTC_DPE_P	  8
#define	MMU_INTERRUPT_STATUS_TTE_PRT_P	  7
#define	MMU_INTERRUPT_STATUS_TTE_INV_P	  6
#define	MMU_INTERRUPT_STATUS_TRN_OOR_P	  5
#define	MMU_INTERRUPT_STATUS_TRN_ERR_P	  4
#define	MMU_INTERRUPT_STATUS_SPARE1_P	  3
#define	MMU_INTERRUPT_STATUS_SPARE0_P	  2
#define	MMU_INTERRUPT_STATUS_BYP_OOR_P	  1
#define	MMU_INTERRUPT_STATUS_BYP_ERR_P	  0
#define	MMU_ERROR_STATUS_CLEAR	0x41018
#define	MMU_ERROR_STATUS_CLEAR_TBW_DPE_S	  47
#define	MMU_ERROR_STATUS_CLEAR_TBW_ERR_S	  46
#define	MMU_ERROR_STATUS_CLEAR_TBW_UDE_S	  45
#define	MMU_ERROR_STATUS_CLEAR_TBW_DME_S	  44
#define	MMU_ERROR_STATUS_CLEAR_SPARE3_S	  43
#define	MMU_ERROR_STATUS_CLEAR_SPARE2_S	  42
#define	MMU_ERROR_STATUS_CLEAR_TTC_CAE_S	  41
#define	MMU_ERROR_STATUS_CLEAR_TTC_DPE_S	  40
#define	MMU_ERROR_STATUS_CLEAR_TTE_PRT_S	  39
#define	MMU_ERROR_STATUS_CLEAR_TTE_INV_S	  38
#define	MMU_ERROR_STATUS_CLEAR_TRN_OOR_S	  37
#define	MMU_ERROR_STATUS_CLEAR_TRN_ERR_S	  36
#define	MMU_ERROR_STATUS_CLEAR_SPARE1_S	  35
#define	MMU_ERROR_STATUS_CLEAR_SPARE0_S	  34
#define	MMU_ERROR_STATUS_CLEAR_BYP_OOR_S	  33
#define	MMU_ERROR_STATUS_CLEAR_BYP_ERR_S	  32
#define	MMU_ERROR_STATUS_CLEAR_TBW_DPE_P	  15
#define	MMU_ERROR_STATUS_CLEAR_TBW_ERR_P	  14
#define	MMU_ERROR_STATUS_CLEAR_TBW_UDE_P	  13
#define	MMU_ERROR_STATUS_CLEAR_TBW_DME_P	  12
#define	MMU_ERROR_STATUS_CLEAR_SPARE3_P	  11
#define	MMU_ERROR_STATUS_CLEAR_SPARE2_P	  10
#define	MMU_ERROR_STATUS_CLEAR_TTC_CAE_P	  9
#define	MMU_ERROR_STATUS_CLEAR_TTC_DPE_P	  8
#define	MMU_ERROR_STATUS_CLEAR_TTE_PRT_P	  7
#define	MMU_ERROR_STATUS_CLEAR_TTE_INV_P	  6
#define	MMU_ERROR_STATUS_CLEAR_TRN_OOR_P	  5
#define	MMU_ERROR_STATUS_CLEAR_TRN_ERR_P	  4
#define	MMU_ERROR_STATUS_CLEAR_SPARE1_P	  3
#define	MMU_ERROR_STATUS_CLEAR_SPARE0_P	  2
#define	MMU_ERROR_STATUS_CLEAR_BYP_OOR_P	  1
#define	MMU_ERROR_STATUS_CLEAR_BYP_ERR_P	  0
#define	MMU_ERROR_STATUS_SET	0x41020
#define	MMU_ERROR_STATUS_SET_TBW_DPE_S	  47
#define	MMU_ERROR_STATUS_SET_TBW_ERR_S	  46
#define	MMU_ERROR_STATUS_SET_TBW_UDE_S	  45
#define	MMU_ERROR_STATUS_SET_TBW_DME_S	  44
#define	MMU_ERROR_STATUS_SET_SPARE3_S	  43
#define	MMU_ERROR_STATUS_SET_SPARE2_S	  42
#define	MMU_ERROR_STATUS_SET_TTC_CAE_S	  41
#define	MMU_ERROR_STATUS_SET_TTC_DPE_S	  40
#define	MMU_ERROR_STATUS_SET_TTE_PRT_S	  39
#define	MMU_ERROR_STATUS_SET_TTE_INV_S	  38
#define	MMU_ERROR_STATUS_SET_TRN_OOR_S	  37
#define	MMU_ERROR_STATUS_SET_TRN_ERR_S	  36
#define	MMU_ERROR_STATUS_SET_SPARE1_S	  35
#define	MMU_ERROR_STATUS_SET_SPARE0_S	  34
#define	MMU_ERROR_STATUS_SET_BYP_OOR_S	  33
#define	MMU_ERROR_STATUS_SET_BYP_ERR_S	  32
#define	MMU_ERROR_STATUS_SET_TBW_DPE_P	  15
#define	MMU_ERROR_STATUS_SET_TBW_ERR_P	  14
#define	MMU_ERROR_STATUS_SET_TBW_UDE_P	  13
#define	MMU_ERROR_STATUS_SET_TBW_DME_P	  12
#define	MMU_ERROR_STATUS_SET_SPARE3_P	  11
#define	MMU_ERROR_STATUS_SET_SPARE2_P	  10
#define	MMU_ERROR_STATUS_SET_TTC_CAE_P	  9
#define	MMU_ERROR_STATUS_SET_TTC_DPE_P	  8
#define	MMU_ERROR_STATUS_SET_TTE_PRT_P	  7
#define	MMU_ERROR_STATUS_SET_TTE_INV_P	  6
#define	MMU_ERROR_STATUS_SET_TRN_OOR_P	  5
#define	MMU_ERROR_STATUS_SET_TRN_ERR_P	  4
#define	MMU_ERROR_STATUS_SET_SPARE1_P	  3
#define	MMU_ERROR_STATUS_SET_SPARE0_P	  2
#define	MMU_ERROR_STATUS_SET_BYP_OOR_P	  1
#define	MMU_ERROR_STATUS_SET_BYP_ERR_P	  0
#define	MMU_TRANSLATION_FAULT_ADDRESS	0x41028
#define	MMU_TRANSLATION_FAULT_ADDRESS_VA	2
#define	MMU_TRANSLATION_FAULT_ADDRESS_VA_MASK	0x3fffffffffffffff
#define	MMU_TRANSLATION_FAULT_STATUS	0x41030
#define	MMU_TRANSLATION_FAULT_STATUS_ENTRY	32
#define	MMU_TRANSLATION_FAULT_STATUS_ENTRY_MASK	0x1ff
#define	MMU_TRANSLATION_FAULT_STATUS_TYPE	16
#define	MMU_TRANSLATION_FAULT_STATUS_TYPE_MASK	0x7f
#define	MMU_TRANSLATION_FAULT_STATUS_ID	0
#define	MMU_TRANSLATION_FAULT_STATUS_ID_MASK	0xffff

/* Reserved 0x41038 - 0x41ff8 */

#define	MMU_PERFORMANCE_COUNTER_SELECT	0x42000
#define	MMU_PERFORMANCE_COUNTER_SELECT_SEL1	8
#define	MMU_PERFORMANCE_COUNTER_SELECT_SEL1_MASK	0xff
#define	MMU_PERFORMANCE_COUNTER_SELECT_SEL0	0
#define	MMU_PERFORMANCE_COUNTER_SELECT_SEL0_MASK	0xff
#define	MMU_PERFORMANCE_COUNTER_ZERO	0x42008
#define	MMU_PERFORMANCE_COUNTER_ZERO_CNT	0
#define	MMU_PERFORMANCE_COUNTER_ZERO_CNT_MASK	0xffffffffffffffff
#define	MMU_PERFORMANCE_COUNTER_ONE	0x42010
#define	MMU_PERFORMANCE_COUNTER_ONE_CNT	0
#define	MMU_PERFORMANCE_COUNTER_ONE_CNT_MASK	0xffffffffffffffff

/* Reserved 0x42018 - 0x43ff8 */


/* Reserved 0x44008 - 0x45ff8 */

#define	MMU_TTE_CACHE_VIRTUAL_TAG	0x46000
#define	MMU_TTE_CACHE_VIRTUAL_TAG_ENTRIES	64
#define	MMU_TTE_CACHE_VIRTUAL_TAG_ENTRIES_CNT	32
#define	MMU_TTE_CACHE_VIRTUAL_TAG_ENTRIES_CNT_MASK	0xfff
#define	MMU_TTE_CACHE_VIRTUAL_TAG_ENTRIES_TAG	16
#define	MMU_TTE_CACHE_VIRTUAL_TAG_ENTRIES_TAG_MASK	0xffff
#define	MMU_TTE_CACHE_VIRTUAL_TAG_ENTRIES_VLD	  0

/* Reserved 0x46200 - 0x46ff8 */

#define	MMU_TTE_CACHE_PHYSICAL_TAG	0x47000
#define	MMU_TTE_CACHE_PHYSICAL_TAG_ENTRIES	64
#define	MMU_TTE_CACHE_PHYSICAL_TAG_ENTRIES_TAG	6
#define	MMU_TTE_CACHE_PHYSICAL_TAG_ENTRIES_TAG_MASK	0x1fffffffff
#define	MMU_TTE_CACHE_PHYSICAL_TAG_ENTRIES_VLD	  0

/* Reserved 0x47200 - 0x47ff8 */

#define	MMU_TTE_CACHE_DATA	0x48000
#define	MMU_TTE_CACHE_DATA_ENTRIES	512
#define	MMU_TTE_CACHE_DATA_ENTRIES_PAR	60
#define	MMU_TTE_CACHE_DATA_ENTRIES_PAR_MASK	0xf
#define	MMU_TTE_CACHE_DATA_ENTRIES_PPN	13
#define	MMU_TTE_CACHE_DATA_ENTRIES_PPN_MASK	0x3fffffff
#define	MMU_TTE_CACHE_DATA_ENTRIES_WRT	  1
#define	MMU_TTE_CACHE_DATA_ENTRIES_VLD	  0

/* cib.csr  CIB module defines */

#define	CIB_CSR_BASE	0x600000

/* Reserved 0x50008 - 0x50ff8 */

#define	ILU_ERROR_LOG_ENABLE	0x51000
#define	ILU_ERROR_LOG_ENABLE_SPARE3	  7
#define	ILU_ERROR_LOG_ENABLE_SPARE2	  6
#define	ILU_ERROR_LOG_ENABLE_SPARE1	  5
#define	ILU_ERROR_LOG_ENABLE_IHB_PE	  4
#define	ILU_INTERRUPT_ENABLE	0x51008
#define	ILU_INTERRUPT_ENABLE_SPARE3_S	  39
#define	ILU_INTERRUPT_ENABLE_SPARE2_S	  38
#define	ILU_INTERRUPT_ENABLE_SPARE1_S	  37
#define	ILU_INTERRUPT_ENABLE_IHB_PE_S	  36
#define	ILU_INTERRUPT_ENABLE_SPARE3_P	  7
#define	ILU_INTERRUPT_ENABLE_SPARE2_P	  6
#define	ILU_INTERRUPT_ENABLE_SPARE1_P	  5
#define	ILU_INTERRUPT_ENABLE_IHB_PE_P	  4
#define	ILU_INTERRUPT_STATUS	0x51010
#define	ILU_INTERRUPT_STATUS_SPARE3_S	  39
#define	ILU_INTERRUPT_STATUS_SPARE2_S	  38
#define	ILU_INTERRUPT_STATUS_SPARE1_S	  37
#define	ILU_INTERRUPT_STATUS_IHB_PE_S	  36
#define	ILU_INTERRUPT_STATUS_SPARE3_P	  7
#define	ILU_INTERRUPT_STATUS_SPARE2_P	  6
#define	ILU_INTERRUPT_STATUS_SPARE1_P	  5
#define	ILU_INTERRUPT_STATUS_IHB_PE_P	  4
#define	ILU_ERROR_STATUS_CLEAR	0x51018
#define	ILU_ERROR_STATUS_CLEAR_SPARE3_S	  39
#define	ILU_ERROR_STATUS_CLEAR_SPARE2_S	  38
#define	ILU_ERROR_STATUS_CLEAR_SPARE1_S	  37
#define	ILU_ERROR_STATUS_CLEAR_IHB_PE_S	  36
#define	ILU_ERROR_STATUS_CLEAR_SPARE3_P	  7
#define	ILU_ERROR_STATUS_CLEAR_SPARE2_P	  6
#define	ILU_ERROR_STATUS_CLEAR_SPARE1_P	  5
#define	ILU_ERROR_STATUS_CLEAR_IHB_PE_P	  4
#define	ILU_ERROR_STATUS_SET	0x51020
#define	ILU_ERROR_STATUS_SET_SPARE3_S	  39
#define	ILU_ERROR_STATUS_SET_SPARE2_S	  38
#define	ILU_ERROR_STATUS_SET_SPARE1_S	  37
#define	ILU_ERROR_STATUS_SET_IHB_PE_S	  36
#define	ILU_ERROR_STATUS_SET_SPARE3_P	  7
#define	ILU_ERROR_STATUS_SET_SPARE2_P	  6
#define	ILU_ERROR_STATUS_SET_SPARE1_P	  5
#define	ILU_ERROR_STATUS_SET_IHB_PE_P	  4

/* Reserved 0x51028 - 0x517f8 */

#define	PEC_CORE_AND_BLOCK_INTERRUPT_ENABLE	0x51800
#define	PEC_CORE_AND_BLOCK_INTERRUPT_ENABLE_PEC	  63
#define	PEC_CORE_AND_BLOCK_INTERRUPT_ENABLE_PEC_ILU	  3
#define	PEC_CORE_AND_BLOCK_INTERRUPT_ENABLE_PEC_UE	  2
#define	PEC_CORE_AND_BLOCK_INTERRUPT_ENABLE_PEC_CE	  1
#define	PEC_CORE_AND_BLOCK_INTERRUPT_ENABLE_PEC_OE	  0
#define	PEC_CORE_AND_BLOCK_INTERRUPT_STATUS	0x51808
#define	PEC_CORE_AND_BLOCK_INTERRUPT_STATUS_ILU	  3
#define	PEC_CORE_AND_BLOCK_INTERRUPT_STATUS_UE	  2
#define	PEC_CORE_AND_BLOCK_INTERRUPT_STATUS_CE	  1
#define	PEC_CORE_AND_BLOCK_INTERRUPT_STATUS_OE	  0

/* Reserved 0x51810 - 0x51ff8 */

#define	ILU_DEVICE_CAPABILITIES	0x52000
#define	ILU_DEVICE_CAPABILITIES_ESTAR	  0

/* cru.csr  CRU module defines */

#define	CRU_CSR_BASE	0x600000
#define	DMC_DEBUG_SELECT_FOR_PORT_A	0x53000
#define	DMC_DEBUG_SELECT_FOR_PORT_A_BLOCK_SEL	6
#define	DMC_DEBUG_SELECT_FOR_PORT_A_BLOCK_SEL_MASK	0xf
#define	DMC_DEBUG_SELECT_FOR_PORT_A_SUB_SEL	3
#define	DMC_DEBUG_SELECT_FOR_PORT_A_SUB_SEL_MASK	0x7
#define	DMC_DEBUG_SELECT_FOR_PORT_A_SIGNAL_SEL	0
#define	DMC_DEBUG_SELECT_FOR_PORT_A_SIGNAL_SEL_MASK	0x7
#define	DMC_DEBUG_SELECT_FOR_PORT_B	0x53008
#define	DMC_DEBUG_SELECT_FOR_PORT_B_BLOCK_SEL	6
#define	DMC_DEBUG_SELECT_FOR_PORT_B_BLOCK_SEL_MASK	0xf
#define	DMC_DEBUG_SELECT_FOR_PORT_B_SUB_SEL	3
#define	DMC_DEBUG_SELECT_FOR_PORT_B_SUB_SEL_MASK	0x7
#define	DMC_DEBUG_SELECT_FOR_PORT_B_SIGNAL_SEL	0
#define	DMC_DEBUG_SELECT_FOR_PORT_B_SIGNAL_SEL_MASK	0x7

/* Reserved 0x53010 - 0x530f8 */

#define	DMC_PCI_EXPRESS_CONFIGURATION	0x53100
#define	DMC_PCI_EXPRESS_CONFIGURATION_BUS_NUM	24
#define	DMC_PCI_EXPRESS_CONFIGURATION_BUS_NUM_MASK	0xff
#define	DMC_PCI_EXPRESS_CONFIGURATION_REQ_ID	0
#define	DMC_PCI_EXPRESS_CONFIGURATION_REQ_ID_MASK	0xffff

/* psb.csr  PSB module defines */

#define	PSB_CSR_BASE	0x600000
#define	PACKET_SCOREBOARD_DMA_SET	0x60000
#define	PACKET_SCOREBOARD_DMA_SET_ENTRIES	32
#define	PACKET_SCOREBOARD_DMA_SET_ENTRIES_ENTRY	0
#define	PACKET_SCOREBOARD_DMA_SET_ENTRIES_ENTRY_MASK	0x1ffffffffff

/* Reserved 0x60100 - 0x63ff8 */

#define	PACKET_SCOREBOARD_PIO_SET	0x64000
#define	PACKET_SCOREBOARD_PIO_SET_ENTRIES	16
#define	PACKET_SCOREBOARD_PIO_SET_ENTRIES_ENTRY	0
#define	PACKET_SCOREBOARD_PIO_SET_ENTRIES_ENTRY_MASK	0x3f

/* tsb.csr  TSB module defines */

#define	TSB_CSR_BASE	0x600000
#define	TRANSACTION_SCOREBOARD_SET	0x70000
#define	TRANSACTION_SCOREBOARD_SET_ENTRIES	32
#define	TRANSACTION_SCOREBOARD_SET_ENTRIES_ENTRY	0
#define	TRANSACTION_SCOREBOARD_SET_ENTRIES_ENTRY_MASK	0xffffffffffff
#define	TRANSACTION_SCOREBOARD_STATUS	0x70100
#define	TRANSACTION_SCOREBOARD_STATUS_FULL	  7
#define	TRANSACTION_SCOREBOARD_STATUS_NUM_PND_DMA	1
#define	TRANSACTION_SCOREBOARD_STATUS_NUM_PND_DMA_MASK	0x3f
#define	TRANSACTION_SCOREBOARD_STATUS_EMPTY	  0

/* tlr.csr  TLR module defines */

#define	TLR_CSR_BASE	0x600000
#define	TLU_CONTROL	0x80000
#define	TLU_CONTROL_L0S_TIM	24
#define	TLU_CONTROL_L0S_TIM_MASK	0xff
#define	TLU_CONTROL_NPWR_EN	  20
#define	TLU_CONTROL_CTO_SEL	16
#define	TLU_CONTROL_CTO_SEL_MASK	0x7
#define	TLU_CONTROL_CONFIG	0
#define	TLU_CONTROL_CONFIG_MASK	0xffff
#define	TLU_STATUS	0x80008
#define	TLU_STATUS_DRAIN	  8
#define	TLU_STATUS_STATUS	0
#define	TLU_STATUS_STATUS_MASK	0xff
#define	TLU_PME_TURN_OFF_GENERATE	0x80010
#define	TLU_PME_TURN_OFF_GENERATE_PTO	  0
#define	TLU_INGRESS_CREDITS_INITIAL	0x80018
#define	TLU_INGRESS_CREDITS_INITIAL_CHC	52
#define	TLU_INGRESS_CREDITS_INITIAL_CHC_MASK	0xff
#define	TLU_INGRESS_CREDITS_INITIAL_CDC	40
#define	TLU_INGRESS_CREDITS_INITIAL_CDC_MASK	0xfff
#define	TLU_INGRESS_CREDITS_INITIAL_NHC	32
#define	TLU_INGRESS_CREDITS_INITIAL_NHC_MASK	0xff
#define	TLU_INGRESS_CREDITS_INITIAL_NDC	20
#define	TLU_INGRESS_CREDITS_INITIAL_NDC_MASK	0xfff
#define	TLU_INGRESS_CREDITS_INITIAL_PHC	12
#define	TLU_INGRESS_CREDITS_INITIAL_PHC_MASK	0xff
#define	TLU_INGRESS_CREDITS_INITIAL_PDC	0
#define	TLU_INGRESS_CREDITS_INITIAL_PDC_MASK	0xfff

/* Reserved 0x80020 - 0x800f8 */

#define	TLU_DIAGNOSTIC	0x80100
#define	TLU_DIAGNOSTIC_LNK_MAX	48
#define	TLU_DIAGNOSTIC_LNK_MAX_MASK	0x3f
#define	TLU_DIAGNOSTIC_CHK_DIS	32
#define	TLU_DIAGNOSTIC_CHK_DIS_MASK	0xffff
#define	TLU_DIAGNOSTIC_EPI_PAR	16
#define	TLU_DIAGNOSTIC_EPI_PAR_MASK	0xff
#define	TLU_DIAGNOSTIC_IDI_PAR	12
#define	TLU_DIAGNOSTIC_IDI_PAR_MASK	0xf
#define	TLU_DIAGNOSTIC_IHI_PAR	8
#define	TLU_DIAGNOSTIC_IHI_PAR_MASK	0xf
#define	TLU_DIAGNOSTIC_EPI_TRG	  7
#define	TLU_DIAGNOSTIC_IDI_TRG	  6
#define	TLU_DIAGNOSTIC_IHI_TRG	  5
#define	TLU_DIAGNOSTIC_MRC_TRG	  4
#define	TLU_DIAGNOSTIC_EPP_DIS	  1
#define	TLU_DIAGNOSTIC_IFC_DIS	  0

/* Reserved 0x80108 - 0x801f8 */

#define	TLU_EGRESS_CREDITS_CONSUMED	0x80200
#define	TLU_EGRESS_CREDITS_CONSUMED_CHI	  62
#define	TLU_EGRESS_CREDITS_CONSUMED_NHI	  61
#define	TLU_EGRESS_CREDITS_CONSUMED_PHI	  60
#define	TLU_EGRESS_CREDITS_CONSUMED_CHC	52
#define	TLU_EGRESS_CREDITS_CONSUMED_CHC_MASK	0xff
#define	TLU_EGRESS_CREDITS_CONSUMED_CDC	40
#define	TLU_EGRESS_CREDITS_CONSUMED_CDC_MASK	0xfff
#define	TLU_EGRESS_CREDITS_CONSUMED_NHC	32
#define	TLU_EGRESS_CREDITS_CONSUMED_NHC_MASK	0xff
#define	TLU_EGRESS_CREDITS_CONSUMED_NDC	20
#define	TLU_EGRESS_CREDITS_CONSUMED_NDC_MASK	0xfff
#define	TLU_EGRESS_CREDITS_CONSUMED_PHC	12
#define	TLU_EGRESS_CREDITS_CONSUMED_PHC_MASK	0xff
#define	TLU_EGRESS_CREDITS_CONSUMED_PDC	0
#define	TLU_EGRESS_CREDITS_CONSUMED_PDC_MASK	0xfff
#define	TLU_EGRESS_CREDIT_LIMIT	0x80208
#define	TLU_EGRESS_CREDIT_LIMIT_CDI	  62
#define	TLU_EGRESS_CREDIT_LIMIT_NDI	  61
#define	TLU_EGRESS_CREDIT_LIMIT_PDI	  60
#define	TLU_EGRESS_CREDIT_LIMIT_CHC	52
#define	TLU_EGRESS_CREDIT_LIMIT_CHC_MASK	0xff
#define	TLU_EGRESS_CREDIT_LIMIT_CDC	40
#define	TLU_EGRESS_CREDIT_LIMIT_CDC_MASK	0xfff
#define	TLU_EGRESS_CREDIT_LIMIT_NHC	32
#define	TLU_EGRESS_CREDIT_LIMIT_NHC_MASK	0xff
#define	TLU_EGRESS_CREDIT_LIMIT_NDC	20
#define	TLU_EGRESS_CREDIT_LIMIT_NDC_MASK	0xfff
#define	TLU_EGRESS_CREDIT_LIMIT_PHC	12
#define	TLU_EGRESS_CREDIT_LIMIT_PHC_MASK	0xff
#define	TLU_EGRESS_CREDIT_LIMIT_PDC	0
#define	TLU_EGRESS_CREDIT_LIMIT_PDC_MASK	0xfff
#define	TLU_EGRESS_RETRY_BUFFER	0x80210
#define	TLU_EGRESS_RETRY_BUFFER_CC	32
#define	TLU_EGRESS_RETRY_BUFFER_CC_MASK	0xffff
#define	TLU_EGRESS_RETRY_BUFFER_CL	0
#define	TLU_EGRESS_RETRY_BUFFER_CL_MASK	0xffff
#define	TLU_INGRESS_CREDITS_ALLOCATED	0x80218
#define	TLU_INGRESS_CREDITS_ALLOCATED_CHC	52
#define	TLU_INGRESS_CREDITS_ALLOCATED_CHC_MASK	0xff
#define	TLU_INGRESS_CREDITS_ALLOCATED_CDC	40
#define	TLU_INGRESS_CREDITS_ALLOCATED_CDC_MASK	0xfff
#define	TLU_INGRESS_CREDITS_ALLOCATED_NHC	32
#define	TLU_INGRESS_CREDITS_ALLOCATED_NHC_MASK	0xff
#define	TLU_INGRESS_CREDITS_ALLOCATED_NDC	20
#define	TLU_INGRESS_CREDITS_ALLOCATED_NDC_MASK	0xfff
#define	TLU_INGRESS_CREDITS_ALLOCATED_PHC	12
#define	TLU_INGRESS_CREDITS_ALLOCATED_PHC_MASK	0xff
#define	TLU_INGRESS_CREDITS_ALLOCATED_PDC	0
#define	TLU_INGRESS_CREDITS_ALLOCATED_PDC_MASK	0xfff
#define	TLU_INGRESS_CREDITS_RECEIVED	0x80220
#define	TLU_INGRESS_CREDITS_RECEIVED_CHC	52
#define	TLU_INGRESS_CREDITS_RECEIVED_CHC_MASK	0xff
#define	TLU_INGRESS_CREDITS_RECEIVED_CDC	40
#define	TLU_INGRESS_CREDITS_RECEIVED_CDC_MASK	0xfff
#define	TLU_INGRESS_CREDITS_RECEIVED_NHC	32
#define	TLU_INGRESS_CREDITS_RECEIVED_NHC_MASK	0xff
#define	TLU_INGRESS_CREDITS_RECEIVED_NDC	20
#define	TLU_INGRESS_CREDITS_RECEIVED_NDC_MASK	0xfff
#define	TLU_INGRESS_CREDITS_RECEIVED_PHC	12
#define	TLU_INGRESS_CREDITS_RECEIVED_PHC_MASK	0xff
#define	TLU_INGRESS_CREDITS_RECEIVED_PDC	0
#define	TLU_INGRESS_CREDITS_RECEIVED_PDC_MASK	0xfff

/* Reserved 0x80228 - 0x80ff8 */

#define	TLU_OTHER_EVENT_LOG_ENABLE	0x81000
#define	TLU_OTHER_EVENT_LOG_ENABLE_EN	0
#define	TLU_OTHER_EVENT_LOG_ENABLE_EN_MASK	0xffffff
#define	TLU_OTHER_EVENT_INTERRUPT_ENABLE	0x81008
#define	TLU_OTHER_EVENT_INTERRUPT_ENABLE_EN_S	32
#define	TLU_OTHER_EVENT_INTERRUPT_ENABLE_EN_S_MASK	0xffffff
#define	TLU_OTHER_EVENT_INTERRUPT_ENABLE_EN_P	0
#define	TLU_OTHER_EVENT_INTERRUPT_ENABLE_EN_P_MASK	0xffffff
#define	TLU_OTHER_EVENT_INTERRUPT_STATUS	0x81010
#define	TLU_OTHER_EVENT_INTERRUPT_STATUS_ERR_S	32
#define	TLU_OTHER_EVENT_INTERRUPT_STATUS_ERR_S_MASK	0xffffff
#define	TLU_OTHER_EVENT_INTERRUPT_STATUS_ERR_P	0
#define	TLU_OTHER_EVENT_INTERRUPT_STATUS_ERR_P_MASK	0xffffff
#define	TLU_OTHER_EVENT_STATUS_CLEAR	0x81018
#define	TLU_OTHER_EVENT_STATUS_CLEAR_SPARE_S	  55
#define	TLU_OTHER_EVENT_STATUS_CLEAR_MFC_S	  54
#define	TLU_OTHER_EVENT_STATUS_CLEAR_CTO_S	  53
#define	TLU_OTHER_EVENT_STATUS_CLEAR_NFP_S	  52
#define	TLU_OTHER_EVENT_STATUS_CLEAR_LWC_S	  51
#define	TLU_OTHER_EVENT_STATUS_CLEAR_MRC_S	  50
#define	TLU_OTHER_EVENT_STATUS_CLEAR_WUC_S	  49
#define	TLU_OTHER_EVENT_STATUS_CLEAR_RUC_S	  48
#define	TLU_OTHER_EVENT_STATUS_CLEAR_CRS_S	  47
#define	TLU_OTHER_EVENT_STATUS_CLEAR_IIP_S	  46
#define	TLU_OTHER_EVENT_STATUS_CLEAR_EDP_S	  45
#define	TLU_OTHER_EVENT_STATUS_CLEAR_EHP_S	  44
#define	TLU_OTHER_EVENT_STATUS_CLEAR_LIN_S	  43
#define	TLU_OTHER_EVENT_STATUS_CLEAR_LRS_S	  42
#define	TLU_OTHER_EVENT_STATUS_CLEAR_LDN_S	  41
#define	TLU_OTHER_EVENT_STATUS_CLEAR_LUP_S	  40
#define	TLU_OTHER_EVENT_STATUS_CLEAR_LPU_S	38
#define	TLU_OTHER_EVENT_STATUS_CLEAR_LPU_S_MASK	0x3
#define	TLU_OTHER_EVENT_STATUS_CLEAR_ERU_S	  37
#define	TLU_OTHER_EVENT_STATUS_CLEAR_ERO_S	  36
#define	TLU_OTHER_EVENT_STATUS_CLEAR_EMP_S	  35
#define	TLU_OTHER_EVENT_STATUS_CLEAR_EPE_S	  34
#define	TLU_OTHER_EVENT_STATUS_CLEAR_ERP_S	  33
#define	TLU_OTHER_EVENT_STATUS_CLEAR_EIP_S	  32
#define	TLU_OTHER_EVENT_STATUS_CLEAR_SPARE_P	  23
#define	TLU_OTHER_EVENT_STATUS_CLEAR_MFC_P	  22
#define	TLU_OTHER_EVENT_STATUS_CLEAR_CTO_P	  21
#define	TLU_OTHER_EVENT_STATUS_CLEAR_NFP_P	  20
#define	TLU_OTHER_EVENT_STATUS_CLEAR_LWC_P	  19
#define	TLU_OTHER_EVENT_STATUS_CLEAR_MRC_P	  18
#define	TLU_OTHER_EVENT_STATUS_CLEAR_WUC_P	  17
#define	TLU_OTHER_EVENT_STATUS_CLEAR_RUC_P	  16
#define	TLU_OTHER_EVENT_STATUS_CLEAR_CRS_P	  15
#define	TLU_OTHER_EVENT_STATUS_CLEAR_IIP_P	  14
#define	TLU_OTHER_EVENT_STATUS_CLEAR_EDP_P	  13
#define	TLU_OTHER_EVENT_STATUS_CLEAR_EHP_P	  12
#define	TLU_OTHER_EVENT_STATUS_CLEAR_LIN_P	  11
#define	TLU_OTHER_EVENT_STATUS_CLEAR_LRS_P	  10
#define	TLU_OTHER_EVENT_STATUS_CLEAR_LDN_P	  9
#define	TLU_OTHER_EVENT_STATUS_CLEAR_LUP_P	  8
#define	TLU_OTHER_EVENT_STATUS_CLEAR_LPU_P	6
#define	TLU_OTHER_EVENT_STATUS_CLEAR_LPU_P_MASK	0x3
#define	TLU_OTHER_EVENT_STATUS_CLEAR_ERU_P	  5
#define	TLU_OTHER_EVENT_STATUS_CLEAR_ERO_P	  4
#define	TLU_OTHER_EVENT_STATUS_CLEAR_EMP_P	  3
#define	TLU_OTHER_EVENT_STATUS_CLEAR_EPE_P	  2
#define	TLU_OTHER_EVENT_STATUS_CLEAR_ERP_P	  1
#define	TLU_OTHER_EVENT_STATUS_CLEAR_EIP_P	  0
#define	TLU_OTHER_EVENT_STATUS_SET	0x81020
#define	TLU_OTHER_EVENT_STATUS_SET_SPARE_S	  55
#define	TLU_OTHER_EVENT_STATUS_SET_MFC_S	  54
#define	TLU_OTHER_EVENT_STATUS_SET_CTO_S	  53
#define	TLU_OTHER_EVENT_STATUS_SET_NFP_S	  52
#define	TLU_OTHER_EVENT_STATUS_SET_LWC_S	  51
#define	TLU_OTHER_EVENT_STATUS_SET_MRC_S	  50
#define	TLU_OTHER_EVENT_STATUS_SET_WUC_S	  49
#define	TLU_OTHER_EVENT_STATUS_SET_RUC_S	  48
#define	TLU_OTHER_EVENT_STATUS_SET_CRS_S	  47
#define	TLU_OTHER_EVENT_STATUS_SET_IIP_S	  46
#define	TLU_OTHER_EVENT_STATUS_SET_EDP_S	  45
#define	TLU_OTHER_EVENT_STATUS_SET_EHP_S	  44
#define	TLU_OTHER_EVENT_STATUS_SET_LIN_S	  43
#define	TLU_OTHER_EVENT_STATUS_SET_LRS_S	  42
#define	TLU_OTHER_EVENT_STATUS_SET_LDN_S	  41
#define	TLU_OTHER_EVENT_STATUS_SET_LUP_S	  40
#define	TLU_OTHER_EVENT_STATUS_SET_LPU_S	38
#define	TLU_OTHER_EVENT_STATUS_SET_LPU_S_MASK	0xfd
#define	TLU_OTHER_EVENT_STATUS_SET_ERU_S	  37
#define	TLU_OTHER_EVENT_STATUS_SET_ERO_S	  36
#define	TLU_OTHER_EVENT_STATUS_SET_EMP_S	  35
#define	TLU_OTHER_EVENT_STATUS_SET_EPE_S	  34
#define	TLU_OTHER_EVENT_STATUS_SET_ERP_S	  33
#define	TLU_OTHER_EVENT_STATUS_SET_EIP_S	  32
#define	TLU_OTHER_EVENT_STATUS_SET_SPARE_P	  23
#define	TLU_OTHER_EVENT_STATUS_SET_MFC_P	  22
#define	TLU_OTHER_EVENT_STATUS_SET_CTO_P	  21
#define	TLU_OTHER_EVENT_STATUS_SET_NFP_P	  20
#define	TLU_OTHER_EVENT_STATUS_SET_LWC_P	  19
#define	TLU_OTHER_EVENT_STATUS_SET_MRC_P	  18
#define	TLU_OTHER_EVENT_STATUS_SET_WUC_P	  17
#define	TLU_OTHER_EVENT_STATUS_SET_RUC_P	  16
#define	TLU_OTHER_EVENT_STATUS_SET_CRS_P	  15
#define	TLU_OTHER_EVENT_STATUS_SET_IIP_P	  14
#define	TLU_OTHER_EVENT_STATUS_SET_EDP_P	  13
#define	TLU_OTHER_EVENT_STATUS_SET_EHP_P	  12
#define	TLU_OTHER_EVENT_STATUS_SET_LIN_P	  11
#define	TLU_OTHER_EVENT_STATUS_SET_LRS_P	  10
#define	TLU_OTHER_EVENT_STATUS_SET_LDN_P	  9
#define	TLU_OTHER_EVENT_STATUS_SET_LUP_P	  8
#define	TLU_OTHER_EVENT_STATUS_SET_LPU_P	6
#define	TLU_OTHER_EVENT_STATUS_SET_LPU_P_MASK	0xfd
#define	TLU_OTHER_EVENT_STATUS_SET_ERU_P	  5
#define	TLU_OTHER_EVENT_STATUS_SET_ERO_P	  4
#define	TLU_OTHER_EVENT_STATUS_SET_EMP_P	  3
#define	TLU_OTHER_EVENT_STATUS_SET_EPE_P	  2
#define	TLU_OTHER_EVENT_STATUS_SET_ERP_P	  1
#define	TLU_OTHER_EVENT_STATUS_SET_EIP_P	  0
#define	TLU_RECEIVE_OTHER_EVENT_HEADER1_LOG	0x81028
#define	TLU_RECEIVE_OTHER_EVENT_HEADER1_LOG_HDR	0
#define	TLU_RECEIVE_OTHER_EVENT_HEADER1_LOG_HDR_MASK	0xffffffffffffffff
#define	TLU_RECEIVE_OTHER_EVENT_HEADER2_LOG	0x81030
#define	TLU_RECEIVE_OTHER_EVENT_HEADER2_LOG_HDR	0
#define	TLU_RECEIVE_OTHER_EVENT_HEADER2_LOG_HDR_MASK	0xffffffffffffffff
#define	TLU_TRANSMIT_OTHER_EVENT_HEADER1_LOG	0x81038
#define	TLU_TRANSMIT_OTHER_EVENT_HEADER1_LOG_HDR	0
#define	TLU_TRANSMIT_OTHER_EVENT_HEADER1_LOG_HDR_MASK	0xffffffffffffffff
#define	TLU_TRANSMIT_OTHER_EVENT_HEADER2_LOG	0x81040
#define	TLU_TRANSMIT_OTHER_EVENT_HEADER2_LOG_HDR	0
#define	TLU_TRANSMIT_OTHER_EVENT_HEADER2_LOG_HDR_MASK	0xffffffffffffffff

/* Reserved 0x81048 - 0x81ff8 */

#define	TLU_PERFORMANCE_COUNTER_SELECT	0x82000
#define	TLU_PERFORMANCE_COUNTER_SELECT_SEL2	16
#define	TLU_PERFORMANCE_COUNTER_SELECT_SEL2_MASK	0x3
#define	TLU_PERFORMANCE_COUNTER_SELECT_SEL1	8
#define	TLU_PERFORMANCE_COUNTER_SELECT_SEL1_MASK	0xff
#define	TLU_PERFORMANCE_COUNTER_SELECT_SEL0	0
#define	TLU_PERFORMANCE_COUNTER_SELECT_SEL0_MASK	0xff
#define	TLU_PERFORMANCE_COUNTER_ZERO	0x82008
#define	TLU_PERFORMANCE_COUNTER_ZERO_CNT	0
#define	TLU_PERFORMANCE_COUNTER_ZERO_CNT_MASK	0xffffffffffffffff
#define	TLU_PERFORMANCE_COUNTER_ONE	0x82010
#define	TLU_PERFORMANCE_COUNTER_ONE_CNT	0
#define	TLU_PERFORMANCE_COUNTER_ONE_CNT_MASK	0xffffffffffffffff
#define	TLU_PERFORMANCE_COUNTER_TWO	0x82018
#define	TLU_PERFORMANCE_COUNTER_TWO_CNT	0
#define	TLU_PERFORMANCE_COUNTER_TWO_CNT_MASK	0xffffffff

/* Reserved 0x82020 - 0x82ff8 */

#define	TLU_DEBUG_SELECT_A	0x83000
#define	TLU_DEBUG_SELECT_A_BLOCK	6
#define	TLU_DEBUG_SELECT_A_BLOCK_MASK	0x7
#define	TLU_DEBUG_SELECT_A_MODULE	3
#define	TLU_DEBUG_SELECT_A_MODULE_MASK	0x7
#define	TLU_DEBUG_SELECT_A_SIGNAL	0
#define	TLU_DEBUG_SELECT_A_SIGNAL_MASK	0x7
#define	TLU_DEBUG_SELECT_B	0x83008
#define	TLU_DEBUG_SELECT_B_BLOCK	6
#define	TLU_DEBUG_SELECT_B_BLOCK_MASK	0x7
#define	TLU_DEBUG_SELECT_B_MODULE	3
#define	TLU_DEBUG_SELECT_B_MODULE_MASK	0x7
#define	TLU_DEBUG_SELECT_B_SIGNAL	0
#define	TLU_DEBUG_SELECT_B_SIGNAL_MASK	0x7

/* Reserved 0x83010 - 0x8fff8 */

#define	TLU_DEVICE_CAPABILITIES	0x90000
#define	TLU_DEVICE_CAPABILITIES_L1	9
#define	TLU_DEVICE_CAPABILITIES_L1_MASK	0x7
#define	TLU_DEVICE_CAPABILITIES_L0S	6
#define	TLU_DEVICE_CAPABILITIES_L0S_MASK	0x7
#define	TLU_DEVICE_CAPABILITIES_MPS	0
#define	TLU_DEVICE_CAPABILITIES_MPS_MASK	0x7
#define	TLU_DEVICE_CONTROL	0x90008
#define	TLU_DEVICE_CONTROL_MRRS	12
#define	TLU_DEVICE_CONTROL_MRRS_MASK	0x7
#define	TLU_DEVICE_CONTROL_MPS	5
#define	TLU_DEVICE_CONTROL_MPS_MASK	0x7
#define	TLU_DEVICE_STATUS	0x90010
#define	TLU_DEVICE_STATUS_TP	  5
#define	TLU_LINK_CAPABILITIES	0x90018
#define	TLU_LINK_CAPABILITIES_PORT	24
#define	TLU_LINK_CAPABILITIES_PORT_MASK	0xff
#define	TLU_LINK_CAPABILITIES_L1	15
#define	TLU_LINK_CAPABILITIES_L1_MASK	0x7
#define	TLU_LINK_CAPABILITIES_L0S	12
#define	TLU_LINK_CAPABILITIES_L0S_MASK	0x7
#define	TLU_LINK_CAPABILITIES_ASPM	10
#define	TLU_LINK_CAPABILITIES_ASPM_MASK	0x3
#define	TLU_LINK_CAPABILITIES_WIDTH	4
#define	TLU_LINK_CAPABILITIES_WIDTH_MASK	0x3f
#define	TLU_LINK_CAPABILITIES_SPEED	0
#define	TLU_LINK_CAPABILITIES_SPEED_MASK	0xf
#define	TLU_LINK_CONTROL	0x90020
#define	TLU_LINK_CONTROL_EXTSYNC	  7
#define	TLU_LINK_CONTROL_CLOCK	  6
#define	TLU_LINK_CONTROL_RETRAIN	  5
#define	TLU_LINK_CONTROL_DISABLE	  4
#define	TLU_LINK_CONTROL_RCB	  3
#define	TLU_LINK_CONTROL_ASPM	0
#define	TLU_LINK_CONTROL_ASPM_MASK	0x3
#define	TLU_LINK_STATUS	0x90028
#define	TLU_LINK_STATUS_CLOCK	  12
#define	TLU_LINK_STATUS_TRAIN	  11
#define	TLU_LINK_STATUS_ERROR	  10
#define	TLU_LINK_STATUS_WIDTH	4
#define	TLU_LINK_STATUS_WIDTH_MASK	0x3f
#define	TLU_LINK_STATUS_SPEED	0
#define	TLU_LINK_STATUS_SPEED_MASK	0xf
#define	TLU_SLOT_CAPABILITIES	0x90030
#define	TLU_SLOT_CAPABILITIES_SPLS	15
#define	TLU_SLOT_CAPABILITIES_SPLS_MASK	0x3
#define	TLU_SLOT_CAPABILITIES_SPLV	7
#define	TLU_SLOT_CAPABILITIES_SPLV_MASK	0xff

/* Reserved 0x90038 - 0x90ff8 */

#define	TLU_UNCORRECTABLE_ERROR_LOG_ENABLE	0x91000
#define	TLU_UNCORRECTABLE_ERROR_LOG_ENABLE_EN	0
#define	TLU_UNCORRECTABLE_ERROR_LOG_ENABLE_EN_MASK	0x1fffff
#define	TLU_UNCORRECTABLE_ERROR_INTERRUPT_ENABLE	0x91008
#define	TLU_UNCORRECTABLE_ERROR_INTERRUPT_ENABLE_EN_S	32
#define	TLU_UNCORRECTABLE_ERROR_INTERRUPT_ENABLE_EN_S_MASK	0x1fffff
#define	TLU_UNCORRECTABLE_ERROR_INTERRUPT_ENABLE_EN_P	0
#define	TLU_UNCORRECTABLE_ERROR_INTERRUPT_ENABLE_EN_P_MASK	0x1fffff
#define	TLU_UNCORRECTABLE_ERROR_INTERRUPT_STATUS	0x91010
#define	TLU_UNCORRECTABLE_ERROR_INTERRUPT_STATUS_ERR_S	32
#define	TLU_UNCORRECTABLE_ERROR_INTERRUPT_STATUS_ERR_S_MASK	0x1fffff
#define	TLU_UNCORRECTABLE_ERROR_INTERRUPT_STATUS_ERR_P	0
#define	TLU_UNCORRECTABLE_ERROR_INTERRUPT_STATUS_ERR_P_MASK	0x1fffff
#define	TLU_UNCORRECTABLE_INTERRUPT_STATUS_UR_S		  52
#define	TLU_UNCORRECTABLE_INTERRUPT_STATUS_MFP_S	  50
#define	TLU_UNCORRECTABLE_INTERRUPT_STATUS_ROF_S	  49
#define	TLU_UNCORRECTABLE_INTERRUPT_STATUS_UC_S		  48
#define	TLU_UNCORRECTABLE_INTERRUPT_STATUS_CA_S		  47
#define	TLU_UNCORRECTABLE_INTERRUPT_STATUS_CTO_S	  46
#define	TLU_UNCORRECTABLE_INTERRUPT_STATUS_FCP_S	  45
#define	TLU_UNCORRECTABLE_INTERRUPT_STATUS_PP_S		  44
#define	TLU_UNCORRECTABLE_INTERRUPT_STATUS_DLP_S	  36
#define	TLU_UNCORRECTABLE_INTERRUPT_STATUS_TE_S		  32
#define	TLU_UNCORRECTABLE_INTERRUPT_STATUS_UR_P		  20
#define	TLU_UNCORRECTABLE_INTERRUPT_STATUS_MFP_P	  18
#define	TLU_UNCORRECTABLE_INTERRUPT_STATUS_ROF_P	  17
#define	TLU_UNCORRECTABLE_INTERRUPT_STATUS_UC_P		  16
#define	TLU_UNCORRECTABLE_INTERRUPT_STATUS_CA_P		  15
#define	TLU_UNCORRECTABLE_INTERRUPT_STATUS_CTO_P	  14
#define	TLU_UNCORRECTABLE_INTERRUPT_STATUS_FCP_P	  13
#define	TLU_UNCORRECTABLE_INTERRUPT_STATUS_PP_P		  12
#define	TLU_UNCORRECTABLE_INTERRUPT_STATUS_DLP_P	  4
#define	TLU_UNCORRECTABLE_INTERRUPT_STATUS_TE_P		  0
#define	TLU_UNCORRECTABLE_ERROR_STATUS_CLEAR	0x91018
#define	TLU_UNCORRECTABLE_ERROR_STATUS_CLEAR_UR_S	  52
#define	TLU_UNCORRECTABLE_ERROR_STATUS_CLEAR_MFP_S	  50
#define	TLU_UNCORRECTABLE_ERROR_STATUS_CLEAR_ROF_S	  49
#define	TLU_UNCORRECTABLE_ERROR_STATUS_CLEAR_UC_S	  48
#define	TLU_UNCORRECTABLE_ERROR_STATUS_CLEAR_CA_S	  47
#define	TLU_UNCORRECTABLE_ERROR_STATUS_CLEAR_CTO_S	  46
#define	TLU_UNCORRECTABLE_ERROR_STATUS_CLEAR_FCP_S	  45
#define	TLU_UNCORRECTABLE_ERROR_STATUS_CLEAR_PP_S	  44
#define	TLU_UNCORRECTABLE_ERROR_STATUS_CLEAR_DLP_S	  36
#define	TLU_UNCORRECTABLE_ERROR_STATUS_CLEAR_TE_S	  32
#define	TLU_UNCORRECTABLE_ERROR_STATUS_CLEAR_UR_P	  20
#define	TLU_UNCORRECTABLE_ERROR_STATUS_CLEAR_MFP_P	  18
#define	TLU_UNCORRECTABLE_ERROR_STATUS_CLEAR_ROF_P	  17
#define	TLU_UNCORRECTABLE_ERROR_STATUS_CLEAR_UC_P	  16
#define	TLU_UNCORRECTABLE_ERROR_STATUS_CLEAR_CA_P	  15
#define	TLU_UNCORRECTABLE_ERROR_STATUS_CLEAR_CTO_P	  14
#define	TLU_UNCORRECTABLE_ERROR_STATUS_CLEAR_FCP_P	  13
#define	TLU_UNCORRECTABLE_ERROR_STATUS_CLEAR_PP_P	  12
#define	TLU_UNCORRECTABLE_ERROR_STATUS_CLEAR_DLP_P	  4
#define	TLU_UNCORRECTABLE_ERROR_STATUS_CLEAR_TE_P	  0
#define	TLU_UNCORRECTABLE_ERROR_STATUS_SET	0x91020
#define	TLU_UNCORRECTABLE_ERROR_STATUS_SET_UR_S	  52
#define	TLU_UNCORRECTABLE_ERROR_STATUS_SET_MFP_S	  50
#define	TLU_UNCORRECTABLE_ERROR_STATUS_SET_ROF_S	  49
#define	TLU_UNCORRECTABLE_ERROR_STATUS_SET_UC_S	  48
#define	TLU_UNCORRECTABLE_ERROR_STATUS_SET_CA_S	  47
#define	TLU_UNCORRECTABLE_ERROR_STATUS_SET_CTO_S	  46
#define	TLU_UNCORRECTABLE_ERROR_STATUS_SET_FCP_S	  45
#define	TLU_UNCORRECTABLE_ERROR_STATUS_SET_PP_S	  44
#define	TLU_UNCORRECTABLE_ERROR_STATUS_SET_DLP_S	  36
#define	TLU_UNCORRECTABLE_ERROR_STATUS_SET_TE_S	  32
#define	TLU_UNCORRECTABLE_ERROR_STATUS_SET_UR_P	  20
#define	TLU_UNCORRECTABLE_ERROR_STATUS_SET_MFP_P	  18
#define	TLU_UNCORRECTABLE_ERROR_STATUS_SET_ROF_P	  17
#define	TLU_UNCORRECTABLE_ERROR_STATUS_SET_UC_P	  16
#define	TLU_UNCORRECTABLE_ERROR_STATUS_SET_CA_P	  15
#define	TLU_UNCORRECTABLE_ERROR_STATUS_SET_CTO_P	  14
#define	TLU_UNCORRECTABLE_ERROR_STATUS_SET_FCP_P	  13
#define	TLU_UNCORRECTABLE_ERROR_STATUS_SET_PP_P	  12
#define	TLU_UNCORRECTABLE_ERROR_STATUS_SET_DLP_P	  4
#define	TLU_UNCORRECTABLE_ERROR_STATUS_SET_TE_P	  0
#define	TLU_RECEIVE_UNCORRECTABLE_ERROR_HEADER1_LOG	0x91028
#define	TLU_RECEIVE_UNCORRECTABLE_ERROR_HEADER1_LOG_HDR	0
#define	TLU_RECEIVE_UNCORRECTABLE_ERROR_HEADER1_LOG_HDR_MASK \
	0xffffffffffffffff
#define	TLU_RECEIVE_UNCORRECTABLE_ERROR_HEADER2_LOG	0x91030
#define	TLU_RECEIVE_UNCORRECTABLE_ERROR_HEADER2_LOG_HDR	0
#define	TLU_RECEIVE_UNCORRECTABLE_ERROR_HEADER2_LOG_HDR_MASK \
	0xffffffffffffffff
#define	TLU_TRANSMIT_UNCORRECTABLE_ERROR_HEADER1_LOG	0x91038
#define	TLU_TRANSMIT_UNCORRECTABLE_ERROR_HEADER1_LOG_HDR	0
#define	TLU_TRANSMIT_UNCORRECTABLE_ERROR_HEADER1_LOG_HDR_MASK \
	0xffffffffffffffff
#define	TLU_TRANSMIT_UNCORRECTABLE_ERROR_HEADER2_LOG	0x91040
#define	TLU_TRANSMIT_UNCORRECTABLE_ERROR_HEADER2_LOG_HDR	0
#define	TLU_TRANSMIT_UNCORRECTABLE_ERROR_HEADER2_LOG_HDR_MASK \
	0xffffffffffffffff

/* Reserved 0x91048 - 0x9fff8 */


/* Reserved 0xa0008 - 0xa0ff8 */

#define	TLU_CORRECTABLE_ERROR_LOG_ENABLE	0xa1000
#define	TLU_CORRECTABLE_ERROR_LOG_ENABLE_EN	0
#define	TLU_CORRECTABLE_ERROR_LOG_ENABLE_EN_MASK	0x1fff
#define	TLU_CORRECTABLE_ERROR_INTERRUPT_ENABLE	0xa1008
#define	TLU_CORRECTABLE_ERROR_INTERRUPT_ENABLE_EN_S	32
#define	TLU_CORRECTABLE_ERROR_INTERRUPT_ENABLE_EN_S_MASK	0x1fff
#define	TLU_CORRECTABLE_ERROR_INTERRUPT_ENABLE_EN_P	0
#define	TLU_CORRECTABLE_ERROR_INTERRUPT_ENABLE_EN_P_MASK	0x1fff
#define	TLU_CORRECTABLE_ERROR_INTERRUPT_STATUS	0xa1010
#define	TLU_CORRECTABLE_ERROR_INTERRUPT_STATUS_ERR_S	32
#define	TLU_CORRECTABLE_ERROR_INTERRUPT_STATUS_ERR_S_MASK	0x1fff
#define	TLU_CORRECTABLE_ERROR_INTERRUPT_STATUS_ERR_P	0
#define	TLU_CORRECTABLE_ERROR_INTERRUPT_STATUS_ERR_P_MASK	0x1fff
#define	TLU_CORRECTABLE_ERROR_STATUS_CLEAR	0xa1018
#define	TLU_CORRECTABLE_ERROR_STATUS_CLEAR_RTO_S	  44
#define	TLU_CORRECTABLE_ERROR_STATUS_CLEAR_RNR_S	  40
#define	TLU_CORRECTABLE_ERROR_STATUS_CLEAR_BDP_S	  39
#define	TLU_CORRECTABLE_ERROR_STATUS_CLEAR_BTP_S	  38
#define	TLU_CORRECTABLE_ERROR_STATUS_CLEAR_RE_S	  32
#define	TLU_CORRECTABLE_ERROR_STATUS_CLEAR_RTO_P	  12
#define	TLU_CORRECTABLE_ERROR_STATUS_CLEAR_RNR_P	  8
#define	TLU_CORRECTABLE_ERROR_STATUS_CLEAR_BDP_P	  7
#define	TLU_CORRECTABLE_ERROR_STATUS_CLEAR_BTP_P	  6
#define	TLU_CORRECTABLE_ERROR_STATUS_CLEAR_RE_P	  0
#define	TLU_CORRECTABLE_ERROR_STATUS_SET	0xa1020
#define	TLU_CORRECTABLE_ERROR_STATUS_SET_RTO_S	  44
#define	TLU_CORRECTABLE_ERROR_STATUS_SET_RNR_S	  40
#define	TLU_CORRECTABLE_ERROR_STATUS_SET_BDP_S	  39
#define	TLU_CORRECTABLE_ERROR_STATUS_SET_BTP_S	  38
#define	TLU_CORRECTABLE_ERROR_STATUS_SET_RE_S	  32
#define	TLU_CORRECTABLE_ERROR_STATUS_SET_RTO_P	  12
#define	TLU_CORRECTABLE_ERROR_STATUS_SET_RNR_P	  8
#define	TLU_CORRECTABLE_ERROR_STATUS_SET_BDP_P	  7
#define	TLU_CORRECTABLE_ERROR_STATUS_SET_BTP_P	  6
#define	TLU_CORRECTABLE_ERROR_STATUS_SET_RE_P	  0

/* lpr.csr  LPR module defines */

#define	LPR_CSR_BASE	0x600000

/* Reserved 0xe0008 - 0xe1ff8 */

#define	LPU_ID	0xe2000
#define	LPU_ID_LTBWDTH	20
#define	LPU_ID_LTBWDTH_MASK	0xf
#define	LPU_ID_PTLWDTH	16
#define	LPU_ID_PTLWDTH_MASK	0xf
#define	LPU_ID_TRID	12
#define	LPU_ID_TRID_MASK	0xf
#define	LPU_ID_LNKID	8
#define	LPU_ID_LNKID_MASK	0xf
#define	LPU_ID_PHYID	4
#define	LPU_ID_PHYID_MASK	0xf
#define	LPU_ID_GBID	0
#define	LPU_ID_GBID_MASK	0xf
#define	LPU_RESET	0xe2008
#define	LPU_RESET_RSTWE	  31
#define	LPU_RESET_RSTUNUSED	9
#define	LPU_RESET_RSTUNUSED_MASK	0x7
#define	LPU_RESET_RSTERROR	  8
#define	LPU_RESET_RSTTXLINK	  7
#define	LPU_RESET_RSTRXLINK	  6
#define	LPU_RESET_RSTSMLINK	  5
#define	LPU_RESET_RSTLTSSM	  4
#define	LPU_RESET_RSTTXPHY	  3
#define	LPU_RESET_RSTRXPHY	  2
#define	LPU_RESET_RSTTXPCS	  1
#define	LPU_RESET_RSTRXPCS	  0
#define	LPU_DEBUG_STATUS	0xe2010
#define	LPU_DEBUG_STATUS_DEBUGB	8
#define	LPU_DEBUG_STATUS_DEBUGB_MASK	0xff
#define	LPU_DEBUG_STATUS_DEBUGA	0
#define	LPU_DEBUG_STATUS_DEBUGA_MASK	0xff
#define	LPU_DEBUG_CONFIG	0xe2018
#define	LPU_DEBUG_CONFIG_DBUGB_BLK_SEL	24
#define	LPU_DEBUG_CONFIG_DBUGB_BLK_SEL_MASK	0xff
#define	LPU_DEBUG_CONFIG_DBUGB_SIG_SEL	16
#define	LPU_DEBUG_CONFIG_DBUGB_SIG_SEL_MASK	0xff
#define	LPU_DEBUG_CONFIG_DBUGA_BLK_SEL	8
#define	LPU_DEBUG_CONFIG_DBUGA_BLK_SEL_MASK	0xff
#define	LPU_DEBUG_CONFIG_DBUGA_SIG_SEL	0
#define	LPU_DEBUG_CONFIG_DBUGA_SIG_SEL_MASK	0xff
#define	LPU_LTSSM_CONTROL	0xe2020
#define	LPU_LTSSM_CONTROL_WR_ENABLE	  31
#define	LPU_LTSSM_CONTROL_RCOVER_TO_CONFIG	  11
#define	LPU_LTSSM_CONTROL_L0_TO_RECOVER	  10
#define	LPU_LTSSM_CONTROL_UNUSED_0	  9
#define	LPU_LTSSM_CONTROL_GO_TO_DETECT	  8
#define	LPU_LTSSM_CONTROL_UNUSED_1	4
#define	LPU_LTSSM_CONTROL_UNUSED_1_MASK	0xf
#define	LPU_LTSSM_CONTROL_DISABLE_SCRAMBLING	  3
#define	LPU_LTSSM_CONTROL_LINK_LOOPBK_REQ	  2
#define	LPU_LTSSM_CONTROL_LINK_DISABLE_REQ	  1
#define	LPU_LTSSM_CONTROL_HOT_RESET	  0
#define	LPU_LINK_STATUS	0xe2028
#define	LPU_LINK_STATUS_SLOT_CLK_CONFG_PIN	  12
#define	LPU_LINK_STATUS_LINK_TRAINING	  11
#define	LPU_LINK_STATUS_LINK_TRAINING_ERR	  10
#define	LPU_LINK_STATUS_NEGOTIATED_WIDTH	4
#define	LPU_LINK_STATUS_NEGOTIATED_WIDTH_MASK	0x3f
#define	LPU_LINK_STATUS_LINK_SPEED	0
#define	LPU_LINK_STATUS_LINK_SPEED_MASK	0xf

/* Reserved 0xe2030 - 0xe2038 */

#define	LPU_INTERRUPT_STATUS	0xe2040
#define	LPU_INTERRUPT_STATUS_INTERRUPT	  31
#define	LPU_INTERRUPT_STATUS_INT_PERF_CNTR_2_OVFLW	  7
#define	LPU_INTERRUPT_STATUS_INT_PERF_CNTR_1_OVFLW	  6
#define	LPU_INTERRUPT_STATUS_INT_LINK_LAYER	  5
#define	LPU_INTERRUPT_STATUS_INT_PHY_ERROR	  4
#define	LPU_INTERRUPT_STATUS_INT_LTSSM	  3
#define	LPU_INTERRUPT_STATUS_INT_PHY_TX	  2
#define	LPU_INTERRUPT_STATUS_INT_PHY_RX	  1
#define	LPU_INTERRUPT_STATUS_INT_PHY_GB	  0
#define	LPU_INTERRUPT_MASK	0xe2048
#define	LPU_INTERRUPT_MASK_MSK_INTERRUPT_EN	  31
#define	LPU_INTERRUPT_MASK_MSK_PERF_CNTR_2_OVFLW	  7
#define	LPU_INTERRUPT_MASK_MSK_PERF_CNTR_1_OVFLW	  6
#define	LPU_INTERRUPT_MASK_MSK_LINK_LAYER	  5
#define	LPU_INTERRUPT_MASK_MSK_PHY_ERROR	  4
#define	LPU_INTERRUPT_MASK_MSK_LTSSM	  3
#define	LPU_INTERRUPT_MASK_MSK_PHY_TX	  2
#define	LPU_INTERRUPT_MASK_MSK_PHY_RX	  1
#define	LPU_INTERRUPT_MASK_MSK_PHY_GB	  0

/* Reserved 0xe2050 - 0xe20f8 */

#define	LPU_LINK_PERFORMANCE_COUNTER_SELECT	0xe2100
#define	LPU_LINK_PERFORMANCE_COUNTER_SELECT_PERF_CNTR2_SELECT	16
#define	LPU_LINK_PERFORMANCE_COUNTER_SELECT_PERF_CNTR2_SELECT_MASK	0xffff
#define	LPU_LINK_PERFORMANCE_COUNTER_SELECT_PERF_CNTR1_SELECT	0
#define	LPU_LINK_PERFORMANCE_COUNTER_SELECT_PERF_CNTR1_SELECT_MASK	0xffff

/* Reserved 0xe2108 - 0xe2108 */

#define	LPU_LINK_PERFORMANCE_COUNTER_CONTROL	0xe2110
#define	LPU_LINK_PERFORMANCE_COUNTER_CONTROL_SET_PERF_CNTR2_OVERFLOW	  6
#define	LPU_LINK_PERFORMANCE_COUNTER_CONTROL_SET_PERF_CNTR1_OVERFLOW	  5
#define	LPU_LINK_PERFORMANCE_COUNTER_CONTROL_RST_PERF_CNTR2_OVERFLOW	  3
#define	LPU_LINK_PERFORMANCE_COUNTER_CONTROL_RST_PERF_CNTR2	  2
#define	LPU_LINK_PERFORMANCE_COUNTER_CONTROL_RST_PERF_CNTR1_OVERFLOW	  1
#define	LPU_LINK_PERFORMANCE_COUNTER_CONTROL_RST_PERF_CNTR1	  0

/* Reserved 0xe2118 - 0xe2118 */

#define	LPU_LINK_PERFORMANCE_COUNTER1	0xe2120
#define	LPU_LINK_PERFORMANCE_COUNTER1_PERF_CNTR1	0
#define	LPU_LINK_PERFORMANCE_COUNTER1_PERF_CNTR1_MASK	0xffffffff
#define	LPU_LINK_PERFORMANCE_COUNTER1_TEST	0xe2128
#define	LPU_LINK_PERFORMANCE_COUNTER1_TEST_PERF_CNTR1_TEST	0
#define	LPU_LINK_PERFORMANCE_COUNTER1_TEST_PERF_CNTR1_TEST_MASK	0xffffffff
#define	LPU_LINK_PERFORMANCE_COUNTER2	0xe2130
#define	LPU_LINK_PERFORMANCE_COUNTER2_PERF_CNTR2	0
#define	LPU_LINK_PERFORMANCE_COUNTER2_PERF_CNTR2_MASK	0xffffffff
#define	LPU_LINK_PERFORMANCE_COUNTER2_TEST	0xe2138
#define	LPU_LINK_PERFORMANCE_COUNTER2_TEST_PERF_CNTR2_TEST	0
#define	LPU_LINK_PERFORMANCE_COUNTER2_TEST_PERF_CNTR2_TEST_MASK	0xffffffff

/* Reserved 0xe2140 - 0xe21f8 */

#define	LPU_LINK_LAYER_CONFIG	0xe2200
#define	LPU_LINK_LAYER_CONFIG_AUTO_UPDATE_DIS	  19
#define	LPU_LINK_LAYER_CONFIG_FREQ_NAK_EN	  18
#define	LPU_LINK_LAYER_CONFIG_REPLAY_AFTER_REC	  17
#define	LPU_LINK_LAYER_CONFIG_LAT_THRES_WR_EN	  16
#define	LPU_LINK_LAYER_CONFIG_VC0_EN	  8
#define	LPU_LINK_LAYER_CONFIG_UNUSED	5
#define	LPU_LINK_LAYER_CONFIG_UNUSED_MASK	0x7
#define	LPU_LINK_LAYER_CONFIG_L0S_ADJ_FAC_EN	  4
#define	LPU_LINK_LAYER_CONFIG_TLP_XMIT_FC_EN	  3
#define	LPU_LINK_LAYER_CONFIG_FREQ_ACK_ENABLE	  2
#define	LPU_LINK_LAYER_CONFIG_RETRY_DISABLE	  1
#define	LPU_LINK_LAYER_STATUS	0xe2208
#define	LPU_LINK_LAYER_STATUS_INIT_FC_SM_WE	  9
#define	LPU_LINK_LAYER_STATUS_LNK_ST_DLUP_WE	  8
#define	LPU_LINK_LAYER_STATUS_INIT_FC_SM_STS	4
#define	LPU_LINK_LAYER_STATUS_INIT_FC_SM_STS_MASK	0x3
#define	LPU_LINK_LAYER_STATUS_DLUP_STS	  3
#define	LPU_LINK_LAYER_STATUS_LNK_STATE_MACH_STS	0
#define	LPU_LINK_LAYER_STATUS_LNK_STATE_MACH_STS_MASK	0x7
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS	0xe2210
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_INT_LINK_ERR_ACT	  31
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_INT_UNSPRTD_DLLP	  22
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_INT_DLLP_RCV_ERR	  21
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_INT_BAD_DLLP	  20
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_INT_TLP_RCV_ERR	  18
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_INT_SRC_ERR_TLP	  17
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_INT_BAD_TLP	  16
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_INT_RTRY_BUF_UDF_ERR	  9
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_INT_RTRY_BUF_OVF_ERR	  8
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_INT_EG_TLP_MIN_ERR	  7
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_INT_EG_TRNC_FRM_ERR	  6
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_INT_RTRY_BUF_PE	  5
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_INT_EGRESS_PE	  4
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_INT_RPLAY_TMR_TO	  2
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_INT_RPLAY_NUM_RO	  1
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_INT_DLNK_PES	  0
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_TEST	0xe2218
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_TEST_TST_UNSPRTD_DLLP	  22
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_TEST_TST_DLLP_RCV_ERR	  21
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_TEST_TST_BAD_DLLP	  20
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_TEST_TST_TLP_RCV_ERR	  18
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_TEST_TST_SRC_ERR_TLP	  17
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_TEST_TST_BAD_TLP	  16
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_TEST_TST_RTRY_BUF_UDF_ERR	  9
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_TEST_TST_RTRY_BUF_OVF	  8
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_TEST_TST_EG_TLP_MIN_ERR	  7
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_TEST_TST_EG_TRNC_FRM_ERR	  6
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_TEST_TST_RTRY_BUF_PE	  5
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_TEST_TST_EGRESS_PE	  4
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_TEST_TST_RPLAY_TMR_TO	  2
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_TEST_TST_RPLAY_NUM_RO	  1
#define	LPU_LINK_LAYER_INTERRUPT_AND_STATUS_TEST_TST_DLNK_PES	  0
#define	LPU_LINK_LAYER_INTERRUPT_MASK	0xe2220
#define	LPU_LINK_LAYER_INTERRUPT_MASK_MSK_LINK_ERR_ACT	  31
#define	LPU_LINK_LAYER_INTERRUPT_MASK_MSK_UNSPRTD_DLLP	  22
#define	LPU_LINK_LAYER_INTERRUPT_MASK_MSK_DLLP_RCV_ERR	  21
#define	LPU_LINK_LAYER_INTERRUPT_MASK_MSK_BAD_DLLP	  20
#define	LPU_LINK_LAYER_INTERRUPT_MASK_MSK_UNUSED_2	  19
#define	LPU_LINK_LAYER_INTERRUPT_MASK_MSK_TLP_RCV_ERR	  18
#define	LPU_LINK_LAYER_INTERRUPT_MASK_MSK_SRC_ERR_TLP	  17
#define	LPU_LINK_LAYER_INTERRUPT_MASK_MSK_BAD_TLP	  16
#define	LPU_LINK_LAYER_INTERRUPT_MASK_MSK_UNUSED_1	10
#define	LPU_LINK_LAYER_INTERRUPT_MASK_MSK_UNUSED_1_MASK	0x3f
#define	LPU_LINK_LAYER_INTERRUPT_MASK_MSK_RTRY_UNF_OVF	  9
#define	LPU_LINK_LAYER_INTERRUPT_MASK_MSK_RTRY_BUF_OVF	  8
#define	LPU_LINK_LAYER_INTERRUPT_MASK_MSK_EG_TLP_MIN_ERR	  7
#define	LPU_LINK_LAYER_INTERRUPT_MASK_MSK_EG_TRNC_FRM_ERR	  6
#define	LPU_LINK_LAYER_INTERRUPT_MASK_MSK_RTRY_BUF_PE	  5
#define	LPU_LINK_LAYER_INTERRUPT_MASK_MSK_EGRESS_PE	  4
#define	LPU_LINK_LAYER_INTERRUPT_MASK_MSK_UNUSED_0	  3
#define	LPU_LINK_LAYER_INTERRUPT_MASK_MSK_RPLAY_TMR_TO	  2
#define	LPU_LINK_LAYER_INTERRUPT_MASK_MSK_RPLAY_NUM_RO	  1
#define	LPU_LINK_LAYER_INTERRUPT_MASK_MSK_DLNK_PES	  0

/* Reserved 0xe2228 - 0xe2238 */

#define	LPU_FLOW_CONTROL_UPDATE_CONTROL	0xe2240
#define	LPU_FLOW_CONTROL_UPDATE_CONTROL_FC0_U_C_EN	  2
#define	LPU_FLOW_CONTROL_UPDATE_CONTROL_FC0_U_NP_EN	  1
#define	LPU_FLOW_CONTROL_UPDATE_CONTROL_FC0_U_P_EN	  0

/* Reserved 0xe2248 - 0xe2258 */

#define	LPU_LINK_LAYER_FLOW_CONTROL_UPDATE_TIMEOUT_VALUE	0xe2260
#define	LPU_LINK_LAYER_FLOW_CONTROL_UPDATE_TIMEOUT_VALUE_FC_UPDATE_TO	0
#define	LPU_LINK_LAYER_FLOW_CONTROL_UPDATE_TIMEOUT_VALUE_FC_UPDATE_TO_MASK \
	0x7fff
#define	LPU_LINK_LAYER_VC0_FLOW_CONTROL_UPDATE_TIMER0	0xe2268
#define	LPU_LINK_LAYER_VC0_FLOW_CONTROL_UPDATE_TIMER0_VC0_FC_UP_TMR_NP	16
#define	LPU_LINK_LAYER_VC0_FLOW_CONTROL_UPDATE_TIMER0_VC0_FC_UP_TMR_NP_MASK \
	0x7fff
#define	LPU_LINK_LAYER_VC0_FLOW_CONTROL_UPDATE_TIMER0_VC0_FC_UP_TMR_P	0
#define	LPU_LINK_LAYER_VC0_FLOW_CONTROL_UPDATE_TIMER0_VC0_FC_UP_TMR_P_MASK \
	0x7fff
#define	LPU_LINK_LAYER_VC0_FLOW_CONTROL_UPDATE_TIMER1	0xe2270
#define	LPU_LINK_LAYER_VC0_FLOW_CONTROL_UPDATE_TIMER1_VC0_FC_UP_TMR_CPL	0
#define	LPU_LINK_LAYER_VC0_FLOW_CONTROL_UPDATE_TIMER1_VC0_FC_UP_TMR_CPL_MASK \
	0x7fff

/* Reserved 0xe2278 - 0xe23f8 */

#define	LPU_TXLINK_FREQUENT_NAK_LATENCY_TIMER_THRESHOLD	0xe2400
#define	LPU_TXLINK_FREQUENT_NAK_LATENCY_TIMER_THRESHOLD_ACK_NAK_THR	0
#define	LPU_TXLINK_FREQUENT_NAK_LATENCY_TIMER_THRESHOLD_ACK_NAK_THR_MASK \
	0xffff
#define	LPU_TXLINK_ACKNAK_LATENCY_TIMER	0xe2408
#define	LPU_TXLINK_ACKNAK_LATENCY_TIMER_ACK_NAK_TMR	0
#define	LPU_TXLINK_ACKNAK_LATENCY_TIMER_ACK_NAK_TMR_MASK	0xffff
#define	LPU_TXLINK_REPLAY_TIMER_THRESHOLD	0xe2410
#define	LPU_TXLINK_REPLAY_TIMER_THRESHOLD_RPLAY_TMR_THR	0
#define	LPU_TXLINK_REPLAY_TIMER_THRESHOLD_RPLAY_TMR_THR_MASK	0xfffff
#define	LPU_TXLINK_REPLAY_TIMER	0xe2418
#define	LPU_TXLINK_REPLAY_TIMER_RPLAY_TMR	0
#define	LPU_TXLINK_REPLAY_TIMER_RPLAY_TMR_MASK	0xfffff
#define	LPU_TXLINK_REPLAY_NUMBER_STATUS	0xe2420
#define	LPU_TXLINK_REPLAY_NUMBER_STATUS_WE	  31
#define	LPU_TXLINK_REPLAY_NUMBER_STATUS_RPLAY_NUM_CNTR	0
#define	LPU_TXLINK_REPLAY_NUMBER_STATUS_RPLAY_NUM_CNTR_MASK	0x3
#define	LPU_REPLAY_BUFFER_MAX_ADDRESS	0xe2428
#define	LPU_REPLAY_BUFFER_MAX_ADDRESS_RTRY_BUFF_MAX_ADDR	0
#define	LPU_REPLAY_BUFFER_MAX_ADDRESS_RTRY_BUFF_MAX_ADDR_MASK	0xffff
#define	LPU_TXLINK_RETRY_FIFO_POINTER	0xe2430
#define	LPU_TXLINK_RETRY_FIFO_POINTER_RTRY_FIFO_TLPTR	16
#define	LPU_TXLINK_RETRY_FIFO_POINTER_RTRY_FIFO_TLPTR_MASK	0xffff
#define	LPU_TXLINK_RETRY_FIFO_POINTER_RTRY_FIFO_HDPTR	0
#define	LPU_TXLINK_RETRY_FIFO_POINTER_RTRY_FIFO_HDPTR_MASK	0xffff
#define	LPU_TXLINK_RETRY_FIFO_R_W_POINTER	0xe2438
#define	LPU_TXLINK_RETRY_FIFO_R_W_POINTER_RTRY_BFFR_WRPTR	16
#define	LPU_TXLINK_RETRY_FIFO_R_W_POINTER_RTRY_BFFR_WRPTR_MASK	0xffff
#define	LPU_TXLINK_RETRY_FIFO_R_W_POINTER_RTRY_BFFR_RDPTR	0
#define	LPU_TXLINK_RETRY_FIFO_R_W_POINTER_RTRY_BFFR_RDPTR_MASK	0xffff
#define	LPU_TXLINK_RETRY_FIFO_CREDIT	0xe2440
#define	LPU_TXLINK_RETRY_FIFO_CREDIT_RTRY_FIFO_CRDT	0
#define	LPU_TXLINK_RETRY_FIFO_CREDIT_RTRY_FIFO_CRDT_MASK	0xffff
#define	LPU_TXLINK_SEQUENCE_COUNTER	0xe2448
#define	LPU_TXLINK_SEQUENCE_COUNTER_WE	  31
#define	LPU_TXLINK_SEQUENCE_COUNTER_ACK_SEQ_WE	  30
#define	LPU_TXLINK_SEQUENCE_COUNTER_ACK_SEQ_CNTR	16
#define	LPU_TXLINK_SEQUENCE_COUNTER_ACK_SEQ_CNTR_MASK	0xfff
#define	LPU_TXLINK_SEQUENCE_COUNTER_NXT_TX_SEQ_CNTR	0
#define	LPU_TXLINK_SEQUENCE_COUNTER_NXT_TX_SEQ_CNTR_MASK	0xfff
#define	LPU_TXLINK_ACK_SENT_SEQUENCE_NUMBER	0xe2450
#define	LPU_TXLINK_ACK_SENT_SEQUENCE_NUMBER_SEQ_NUM	0
#define	LPU_TXLINK_ACK_SENT_SEQUENCE_NUMBER_SEQ_NUM_MASK	0xfff
#define	LPU_TXLINK_SEQUENCE_COUNT_FIFO_MAX_ADDR	0xe2458
#define	LPU_TXLINK_SEQUENCE_COUNT_FIFO_MAX_ADDR_SEQ_CNT_MAX_ADDR	0
#define	LPU_TXLINK_SEQUENCE_COUNT_FIFO_MAX_ADDR_SEQ_CNT_MAX_ADDR_MASK	0xfff
#define	LPU_TXLINK_SEQUENCE_COUNT_FIFO_POINTERS	0xe2460
#define	LPU_TXLINK_SEQUENCE_COUNT_FIFO_POINTERS_SEQ_CNT_TLPTR	16
#define	LPU_TXLINK_SEQUENCE_COUNT_FIFO_POINTERS_SEQ_CNT_TLPTR_MASK	0xfff
#define	LPU_TXLINK_SEQUENCE_COUNT_FIFO_POINTERS_SEQ_CNT_HDPTR	0
#define	LPU_TXLINK_SEQUENCE_COUNT_FIFO_POINTERS_SEQ_CNT_HDPTR_MASK	0xfff
#define	LPU_TXLINK_SEQUENCE_COUNT_R_W_POINTERS	0xe2468
#define	LPU_TXLINK_SEQUENCE_COUNT_R_W_POINTERS_SEQ_CNT_WRPTR	16
#define	LPU_TXLINK_SEQUENCE_COUNT_R_W_POINTERS_SEQ_CNT_WRPTR_MASK	0xfff
#define	LPU_TXLINK_SEQUENCE_COUNT_R_W_POINTERS_SEQ_CNT_RDPTR	0
#define	LPU_TXLINK_SEQUENCE_COUNT_R_W_POINTERS_SEQ_CNT_RDPTR_MASK	0xfff
#define	LPU_TXLINK_TEST_CONTROL	0xe2470
#define	LPU_TXLINK_TEST_CONTROL_DIS_ACK	  3
#define	LPU_TXLINK_TEST_CONTROL_FORCE_NAK	  2
#define	LPU_TXLINK_TEST_CONTROL_FORCE_BAD_TLP_CRC	  1
#define	LPU_TXLINK_TEST_CONTROL_FORCE_RTX_TLP	  0

/* Reserved 0xe2478 - 0xe2478 */

#define	LPU_TXLINK_MEMORY_ADDRESS_CONTROL	0xe2480
#define	LPU_TXLINK_MEMORY_ADDRESS_CONTROL_DONE	  31
#define	LPU_TXLINK_MEMORY_ADDRESS_CONTROL_GO_BIT	  30
#define	LPU_TXLINK_MEMORY_ADDRESS_CONTROL_RD_WR_SEL	  29
#define	LPU_TXLINK_MEMORY_ADDRESS_CONTROL_FIFO_SEL	  28
#define	LPU_TXLINK_MEMORY_ADDRESS_CONTROL_MEM_ADDR	0
#define	LPU_TXLINK_MEMORY_ADDRESS_CONTROL_MEM_ADDR_MASK	0xffff
#define	LPU_TXLINK_MEMORY_DATA_LOAD0	0xe2488
#define	LPU_TXLINK_MEMORY_DATA_LOAD0_MEM_RD_WR_DATA0	0
#define	LPU_TXLINK_MEMORY_DATA_LOAD0_MEM_RD_WR_DATA0_MASK	0xffffffff
#define	LPU_TXLINK_MEMORY_DATA_LOAD1	0xe2490
#define	LPU_TXLINK_MEMORY_DATA_LOAD1_MEM_RD_WR_DATA1	0
#define	LPU_TXLINK_MEMORY_DATA_LOAD1_MEM_RD_WR_DATA1_MASK	0xffffffff
#define	LPU_TXLINK_MEMORY_DATA_LOAD2	0xe2498
#define	LPU_TXLINK_MEMORY_DATA_LOAD3	0xe24a0
#define	LPU_TXLINK_MEMORY_DATA_LOAD4	0xe24a8
#define	LPU_TXLINK_MEMORY_DATA_LOAD4_MEM_RD_WR_DATA4	0
#define	LPU_TXLINK_MEMORY_DATA_LOAD4_MEM_RD_WR_DATA4_MASK	0xff

/* Reserved 0xe24b0 - 0xe24b8 */

#define	LPU_TXLINK_RETRY_DATA_COUNT	0xe24c0
#define	LPU_TXLINK_RETRY_DATA_COUNT_RTRY_DATA_CNT	0
#define	LPU_TXLINK_RETRY_DATA_COUNT_RTRY_DATA_CNT_MASK	0xffff
#define	LPU_TXLINK_SEQUENCE_BUFFER_COUNT	0xe24c8
#define	LPU_TXLINK_SEQUENCE_BUFFER_COUNT_SEQ_BUFF_CNT	0
#define	LPU_TXLINK_SEQUENCE_BUFFER_COUNT_SEQ_BUFF_CNT_MASK	0xfff
#define	LPU_TXLINK_SEQUENCE_BUFFER_BOTTOM_DATA	0xe24d0
#define	LPU_TXLINK_SEQUENCE_BUFFER_BOTTOM_DATA_SBUF_BDATA_PAR	  30
#define	LPU_TXLINK_SEQUENCE_BUFFER_BOTTOM_DATA_SBDATA_SEQ_NUM	18
#define	LPU_TXLINK_SEQUENCE_BUFFER_BOTTOM_DATA_SBDATA_SEQ_NUM_MASK	0xfff
#define	LPU_TXLINK_SEQUENCE_BUFFER_BOTTOM_DATA_SBDATA_RTRY_PTR	2
#define	LPU_TXLINK_SEQUENCE_BUFFER_BOTTOM_DATA_SBDATA_RTRY_PTR_MASK	0xffff
#define	LPU_TXLINK_SEQUENCE_BUFFER_BOTTOM_DATA_SBDATA_EOP_POS	0
#define	LPU_TXLINK_SEQUENCE_BUFFER_BOTTOM_DATA_SBDATA_EOP_POS_MASK	0x3

/* Reserved 0xe24d8 - 0xe24d8 */

#define	LPU_TXLINK_ACK_LATENCY_TIMER_THRESHOLD	0xe24e0
#define	LPU_TXLINK_ACK_LATENCY_TIMER_THRESHOLD_ACK_LAT_THHOLD	0
#define	LPU_TXLINK_ACK_LATENCY_TIMER_THRESHOLD_ACK_LAT_THHOLD_MASK	0xffff

/* Reserved 0xe24e8 - 0xe24f8 */

#define	LPU_RXLINK_NEXT_RECEIVE_SEQUENCE_1_COUNTER	0xe2500
#define	LPU_RXLINK_NEXT_RECEIVE_SEQUENCE_1_COUNTER_NXT_RX_SEQ_CNTR	0
#define	LPU_RXLINK_NEXT_RECEIVE_SEQUENCE_1_COUNTER_NXT_RX_SEQ_CNTR_MASK \
	0xfff
#define	LPU_RXLINK_UNSUPPORTED_DLLP_RECEIVED	0xe2508
#define	LPU_RXLINK_UNSUPPORTED_DLLP_RECEIVED_BYTE3	24
#define	LPU_RXLINK_UNSUPPORTED_DLLP_RECEIVED_BYTE3_MASK	0xff
#define	LPU_RXLINK_UNSUPPORTED_DLLP_RECEIVED_BYTE2	16
#define	LPU_RXLINK_UNSUPPORTED_DLLP_RECEIVED_BYTE2_MASK	0xff
#define	LPU_RXLINK_UNSUPPORTED_DLLP_RECEIVED_BYTE1	8
#define	LPU_RXLINK_UNSUPPORTED_DLLP_RECEIVED_BYTE1_MASK	0xff
#define	LPU_RXLINK_UNSUPPORTED_DLLP_RECEIVED_BYTE0	0
#define	LPU_RXLINK_UNSUPPORTED_DLLP_RECEIVED_BYTE0_MASK	0xff
#define	LPU_RXLINK_TEST_CONTROL	0xe2510
#define	LPU_RXLINK_TEST_CONTROL_FORCE_SEND_INIT_FC_DLLP	  1
#define	LPU_RXLINK_TEST_CONTROL_FORCE_PAR_ERR_DLLP	  0

/* Reserved 0xe2518 - 0xe25f8 */

#define	LPU_PHYSICAL_LAYER_CONFIGURATION	0xe2600
#define	LPU_PHYSICAL_LAYER_CONFIGURATION_PHY_TST_EN	  31
#define	LPU_PHYSICAL_LAYER_CONFIGURATION_FAST_SIM	  30
#define	LPU_PHYSICAL_LAYER_CONFIGURATION_UNUSED	  29
#define	LPU_PHYSICAL_LAYER_CONFIGURATION_FRCE_EXTEN_SYNC	  28
#define	LPU_PHYSICAL_LAYER_CONFIGURATION_TX_EIDLE_POST_EN	  11
#define	LPU_PHYSICAL_LAYER_CONFIGURATION_TX_OS_POST_VAL	8
#define	LPU_PHYSICAL_LAYER_CONFIGURATION_TX_OS_POST_VAL_MASK	0x7
#define	LPU_PHYSICAL_LAYER_CONFIGURATION_TX_OS_BYTE_SEL	  7
#define	LPU_PHYSICAL_LAYER_CONFIGURATION_TX_OS_PREAM_VAL	4
#define	LPU_PHYSICAL_LAYER_CONFIGURATION_TX_OS_PREAM_VAL_MASK	0x7
#define	LPU_PHYSICAL_LAYER_CONFIGURATION_TX_RDET_BYP_MODE	  3
#define	LPU_PHYSICAL_LAYER_CONFIGURATION_TX_RDET_SAFE_MODE	  2
#define	LPU_PHYSICAL_LAYER_CONFIGURATION_TX_UNUSED	  1
#define	LPU_PHYSICAL_LAYER_CONFIGURATION_TX_PAR_ERR	  0
#define	LPU_PHY_LAYER_STATUS	0xe2608
#define	LPU_PHY_LAYER_INTERRUPT_AND_STATUS	0xe2610
#define	LPU_PHY_LAYER_INTERRUPT_AND_STATUS_INT_PHY_LAYER_ERR	  31
#define	LPU_PHY_LAYER_INTERRUPT_AND_STATUS_INT_KCHAR_DLLP_ERR	  11
#define	LPU_PHY_LAYER_INTERRUPT_AND_STATUS_INT_ILL_END_POS_ERR	  10
#define	LPU_PHY_LAYER_INTERRUPT_AND_STATUS_INT_LNK_ERR	  9
#define	LPU_PHY_LAYER_INTERRUPT_AND_STATUS_INT_TRN_ERR	  8
#define	LPU_PHY_LAYER_INTERRUPT_AND_STATUS_INT_EDB_DET	  7
#define	LPU_PHY_LAYER_INTERRUPT_AND_STATUS_INT_SDP_END	  6
#define	LPU_PHY_LAYER_INTERRUPT_AND_STATUS_INT_STP_END_EDB	  5
#define	LPU_PHY_LAYER_INTERRUPT_AND_STATUS_INT_INVLD_CHAR_ERR	  4
#define	LPU_PHY_LAYER_INTERRUPT_AND_STATUS_INT_MULTI_SDP	  3
#define	LPU_PHY_LAYER_INTERRUPT_AND_STATUS_INT_MULTI_STP	  2
#define	LPU_PHY_LAYER_INTERRUPT_AND_STATUS_INT_ILL_SDP_POS	  1
#define	LPU_PHY_LAYER_INTERRUPT_AND_STATUS_INT_ILL_STP_POS	  0
#define	LPU_PHY_INTERRUPT_AND_STATUS_TEST	0xe2618
#define	LPU_PHY_INTERRUPT_AND_STATUS_TEST_TST_KCHAR_DLLP_ERR	  11
#define	LPU_PHY_INTERRUPT_AND_STATUS_TEST_TST_ILL_END_POS_ERR	  10
#define	LPU_PHY_INTERRUPT_AND_STATUS_TEST_TST_LNK_ERR	  9
#define	LPU_PHY_INTERRUPT_AND_STATUS_TEST_TST_TRN_ERR	  8
#define	LPU_PHY_INTERRUPT_AND_STATUS_TEST_TST_EDB_DET	  7
#define	LPU_PHY_INTERRUPT_AND_STATUS_TEST_TST_SDP_END	  6
#define	LPU_PHY_INTERRUPT_AND_STATUS_TEST_TST_STP_END_EDB	  5
#define	LPU_PHY_INTERRUPT_AND_STATUS_TEST_TST_INVLD_CHAR_ERR	  4
#define	LPU_PHY_INTERRUPT_AND_STATUS_TEST_TST_MULTI_SDP	  3
#define	LPU_PHY_INTERRUPT_AND_STATUS_TEST_TST_MULTI_STP	  2
#define	LPU_PHY_INTERRUPT_AND_STATUS_TEST_TST_ILL_SDP_POS	  1
#define	LPU_PHY_INTERRUPT_AND_STATUS_TEST_TST_ILL_STP_POS	  0
#define	LPU_PHY_INTERRUPT_MASK	0xe2620
#define	LPU_PHY_INTERRUPT_MASK_MSK_PHY_LAYER_ERR	  31
#define	LPU_PHY_INTERRUPT_MASK_MSK_KCHAR_DLLP_ERR	  11
#define	LPU_PHY_INTERRUPT_MASK_MSK_ILL_END_POS_ERR	  10
#define	LPU_PHY_INTERRUPT_MASK_MSK_LNK_ERR	  9
#define	LPU_PHY_INTERRUPT_MASK_MSK_TRN_ERR	  8
#define	LPU_PHY_INTERRUPT_MASK_MSK_EDB_DET	  7
#define	LPU_PHY_INTERRUPT_MASK_MSK_SDP_END	  6
#define	LPU_PHY_INTERRUPT_MASK_MSK_STP_END_EDB	  5
#define	LPU_PHY_INTERRUPT_MASK_MSK_INVLD_CHAR_ERR	  4
#define	LPU_PHY_INTERRUPT_MASK_MSK_MULTI_SDP	  3
#define	LPU_PHY_INTERRUPT_MASK_MSK_MULTI_STP	  2
#define	LPU_PHY_INTERRUPT_MASK_MSK_ILL_SDP_POS	  1
#define	LPU_PHY_INTERRUPT_MASK_MSK_ILL_STP_POS	  0

/* Reserved 0xe2628 - 0xe2678 */

#define	LPU_RECEIVE_PHY_CONFIG	0xe2680
#define	LPU_RECEIVE_PHY_CONFIG_RX_PHY_TST	  31
#define	LPU_RECEIVE_PHY_CONFIG_UNUSED_0	18
#define	LPU_RECEIVE_PHY_CONFIG_UNUSED_0_MASK	0x1fff
#define	LPU_RECEIVE_PHY_CONFIG_WM_SEL_FIFO	16
#define	LPU_RECEIVE_PHY_CONFIG_WM_SEL_FIFO_MASK	0x3
#define	LPU_RECEIVE_PHY_CONFIG_UNUSED_1	8
#define	LPU_RECEIVE_PHY_CONFIG_UNUSED_1_MASK	0xff
#define	LPU_RECEIVE_PHY_CONFIG_RST_RCV_LANE	0
#define	LPU_RECEIVE_PHY_CONFIG_RST_RCV_LANE_MASK	0xff
#define	LPU_RECEIVE_PHY_STATUS1	0xe2688
#define	LPU_RECEIVE_PHY_STATUS1_ALIGN_STS	  16
#define	LPU_RECEIVE_PHY_STATUS1_RX_PHY_STS	0
#define	LPU_RECEIVE_PHY_STATUS1_RX_PHY_STS_MASK	0xffff
#define	LPU_RECEIVE_PHY_STATUS2	0xe2690
#define	LPU_RECEIVE_PHY_STATUS2_RCV_DIS_SCRAM	  27
#define	LPU_RECEIVE_PHY_STATUS2_RCV_EN_LOOPBACK	  26
#define	LPU_RECEIVE_PHY_STATUS2_RCV_DIS_LINK	  25
#define	LPU_RECEIVE_PHY_STATUS2_RCV_HOT_RST	  24
#define	LPU_RECEIVE_PHY_STATUS2_RCV_DATA_RATE	16
#define	LPU_RECEIVE_PHY_STATUS2_RCV_DATA_RATE_MASK	0xff
#define	LPU_RECEIVE_PHY_STATUS2_RCV_FTS_NUM	8
#define	LPU_RECEIVE_PHY_STATUS2_RCV_FTS_NUM_MASK	0xff
#define	LPU_RECEIVE_PHY_STATUS2_RCV_LINK_NUM	0
#define	LPU_RECEIVE_PHY_STATUS2_RCV_LINK_NUM_MASK	0xff
#define	LPU_RECEIVE_PHY_STATUS3	0xe2698
#define	LPU_RECEIVE_PHY_STATUS3_POL_REV_STS	16
#define	LPU_RECEIVE_PHY_STATUS3_POL_REV_STS_MASK	0xff
#define	LPU_RECEIVE_PHY_STATUS3_BYTE_SYNC_STS	0
#define	LPU_RECEIVE_PHY_STATUS3_BYTE_SYNC_STS_MASK	0xff
#define	LPU_RECEIVE_PHY_INTERRUPT_AND_STATUS	0xe26a0
#define	LPU_RECEIVE_PHY_INTERRUPT_AND_STATUS_INT_RCV_PHY	  31
#define	LPU_RECEIVE_PHY_INTERRUPT_AND_STATUS_INT_UNUSED	3
#define	LPU_RECEIVE_PHY_INTERRUPT_AND_STATUS_INT_UNUSED_MASK	0x1ff
#define	LPU_RECEIVE_PHY_INTERRUPT_AND_STATUS_INT_ALIGN_ERR	  2
#define	LPU_RECEIVE_PHY_INTERRUPT_AND_STATUS_INT_ELSTC_FIFO_OVRFLW	  1
#define	LPU_RECEIVE_PHY_INTERRUPT_AND_STATUS_INT_ELSTC_FIFO_UNDRFLW	  0
#define	LPU_RECEIVE_PHY_INTERRUPT_AND_STATUS_TEST	0xe26a8
#define	LPU_RECEIVE_PHY_INTERRUPT_AND_STATUS_TEST_TST_UNUSED	3
#define	LPU_RECEIVE_PHY_INTERRUPT_AND_STATUS_TEST_TST_UNUSED_MASK	0x1ff
#define	LPU_RECEIVE_PHY_INTERRUPT_AND_STATUS_TEST_TST_ALIGN_ERR	  2
#define	LPU_RECEIVE_PHY_INTERRUPT_AND_STATUS_TEST_TST_ELSTC_FIFO_OVRFLW	  1
#define	LPU_RECEIVE_PHY_INTERRUPT_AND_STATUS_TEST_TST_ELSTC_FIFO_UNDRFLW  0
#define	LPU_RECEIVE_PHY_INTERRUPT_MASK	0xe26b0
#define	LPU_RECEIVE_PHY_INTERRUPT_MASK_MSK_RCV_PHY_INT	  31
#define	LPU_RECEIVE_PHY_INTERRUPT_MASK_MSK_UNUSED	3
#define	LPU_RECEIVE_PHY_INTERRUPT_MASK_MSK_UNUSED_MASK	0x1ff
#define	LPU_RECEIVE_PHY_INTERRUPT_MASK_MSK_ALIGN_ERR	  2
#define	LPU_RECEIVE_PHY_INTERRUPT_MASK_MSK_ELSTC_FIFO_OVRFLW	  1
#define	LPU_RECEIVE_PHY_INTERRUPT_MASK_MSK_ELSTC_FIFO_UNDRFLW	  0

/* Reserved 0xe26b8 - 0xe26f8 */

#define	LPU_TRANSMIT_PHY_CONFIG	0xe2700
#define	LPU_TRANSMIT_PHY_CONFIG_FRCE_RCVR_DET	16
#define	LPU_TRANSMIT_PHY_CONFIG_FRCE_RCVR_DET_MASK	0xffff
#define	LPU_TRANSMIT_PHY_CONFIG_FRCE_ELEC_IDLE	0
#define	LPU_TRANSMIT_PHY_CONFIG_FRCE_ELEC_IDLE_MASK	0xffff
#define	LPU_TRANSMIT_PHY_STATUS	0xe2708
#define	LPU_TRANSMIT_PHY_STATUS_NEG_LANE_WDTH	28
#define	LPU_TRANSMIT_PHY_STATUS_NEG_LANE_WDTH_MASK	0xf
#define	LPU_TRANSMIT_PHY_STATUS_TXPHY_SCRAM_EN	  27
#define	LPU_TRANSMIT_PHY_STATUS_TX_LANE_REV	  26
#define	LPU_TRANSMIT_PHY_STATUS_TX_LANE_PAD	  25
#define	LPU_TRANSMIT_PHY_STATUS_TX_LINK_PAD	  24
#define	LPU_TRANSMIT_PHY_STATUS_TX_PHY_SMS	0
#define	LPU_TRANSMIT_PHY_STATUS_TX_PHY_SMS_MASK	0x7fffff
#define	LPU_TRANSMIT_PHY_INTERRUPT_AND_STATUS	0xe2710
#define	LPU_TRANSMIT_PHY_INTERRUPT_AND_STATUS_INT_UNMSK	  31
#define	LPU_TRANSMIT_PHY_INTERRUPT_AND_STATUS_INT_RCV_IDLE	  11
#define	LPU_TRANSMIT_PHY_INTERRUPT_AND_STATUS_INT_RCV_TS2	  10
#define	LPU_TRANSMIT_PHY_INTERRUPT_AND_STATUS_INT_RCV_TS1	  9
#define	LPU_TRANSMIT_PHY_INTERRUPT_AND_STATUS_INT_SKP_ERR	  8
#define	LPU_TRANSMIT_PHY_INTERRUPT_AND_STATUS_INT_SKP_DONE_BK2BK	  7
#define	LPU_TRANSMIT_PHY_INTERRUPT_AND_STATUS_INT_SKP_ACK_DECR	  6
#define	LPU_TRANSMIT_PHY_INTERRUPT_AND_STATUS_INT_SKP_DONE_DECR	  5
#define	LPU_TRANSMIT_PHY_INTERRUPT_AND_STATUS_INT_SKP_TRIG	  4
#define	LPU_TRANSMIT_PHY_INTERRUPT_AND_STATUS_INT_UNUSED_2	2
#define	LPU_TRANSMIT_PHY_INTERRUPT_AND_STATUS_INT_UNUSED_2_MASK	0x3
#define	LPU_TRANSMIT_PHY_INTERRUPT_AND_STATUS_INT_RCVR_DET_VALID	  1
#define	LPU_TRANSMIT_PHY_INTERRUPT_AND_STATUS_INT_TX_PAR_ERR	  0
#define	LPU_TRANSMIT_PHY_INTERRUPT_AND_STATUS_TEST	0xe2718
#define	LPU_TRANSMIT_PHY_INTERRUPT_AND_STATUS_TEST_TST_TX_PHY_INT	0
#define	LPU_TRANSMIT_PHY_INTERRUPT_AND_STATUS_TEST_TST_TX_PHY_INT_MASK	0xfff
#define	LPU_TRANSMIT_PHY_INTERRUPT_MASK	0xe2720
#define	LPU_TRANSMIT_PHY_INTERRUPT_MASK_MSK_GLOBL_INT	  31
#define	LPU_TRANSMIT_PHY_INTERRUPT_MASK_MSK_IMPLEM_INT	0
#define	LPU_TRANSMIT_PHY_INTERRUPT_MASK_MSK_IMPLEM_INT_MASK	0xfff
#define	LPU_TRANSMIT_PHY_STATUS_2	0xe2728
#define	LPU_TRANSMIT_PHY_STATUS_2_RECV_DET_STS	16
#define	LPU_TRANSMIT_PHY_STATUS_2_RECV_DET_STS_MASK	0xffff
#define	LPU_TRANSMIT_PHY_STATUS_2_RECV_DET_RAW_STS	0
#define	LPU_TRANSMIT_PHY_STATUS_2_RECV_DET_RAW_STS_MASK	0xffff

/* Reserved 0xe2730 - 0xe2778 */

#define	LPU_LTSSM_CONFIG1	0xe2780
#define	LPU_LTSSM_CONFIG1_LTSSM_TST	  31
#define	LPU_LTSSM_CONFIG1_CFG_UNUSED	18
#define	LPU_LTSSM_CONFIG1_CFG_UNUSED_MASK	0x1fff
#define	LPU_LTSSM_CONFIG1_LPBK_MSTR	  17
#define	LPU_LTSSM_CONFIG1_HI_DATA_SUP	  16
#define	LPU_LTSSM_CONFIG1_LTSSM_8_TO	8
#define	LPU_LTSSM_CONFIG1_LTSSM_8_TO_MASK	0xff
#define	LPU_LTSSM_CONFIG1_LTSSM_20_TO	0
#define	LPU_LTSSM_CONFIG1_LTSSM_20_TO_MASK	0xff
#define	LPU_LTSSM_CONFIG2	0xe2788
#define	LPU_LTSSM_CONFIG2_LTSSM_12_TO	0
#define	LPU_LTSSM_CONFIG2_LTSSM_12_TO_MASK	0xffffffff
#define	LPU_LTSSM_CONFIG3	0xe2790
#define	LPU_LTSSM_CONFIG3_LTSSM_2_TO	0
#define	LPU_LTSSM_CONFIG3_LTSSM_2_TO_MASK	0xffffffff
#define	LPU_LTSSM_CONFIG4	0xe2798
#define	LPU_LTSSM_CONFIG4_TRN_CNTRL	24
#define	LPU_LTSSM_CONFIG4_TRN_CNTRL_MASK	0xff
#define	LPU_LTSSM_CONFIG4_DATA_RATE	16
#define	LPU_LTSSM_CONFIG4_DATA_RATE_MASK	0xff
#define	LPU_LTSSM_CONFIG4_N_FTS	8
#define	LPU_LTSSM_CONFIG4_N_FTS_MASK	0xff
#define	LPU_LTSSM_CONFIG4_LNK_NUM	0
#define	LPU_LTSSM_CONFIG4_LNK_NUM_MASK	0xff
#define	LPU_LTSSM_CONFIG5	0xe27a0
#define	LPU_LTSSM_CONFIG5_CFG_UNUSED_0	13
#define	LPU_LTSSM_CONFIG5_CFG_UNUSED_0_MASK	0x7ffff
#define	LPU_LTSSM_CONFIG5_RCV_DET_TST_MODE	  12
#define	LPU_LTSSM_CONFIG5_POLL_CMPLNC_DIS	  11
#define	LPU_LTSSM_CONFIG5_TX_IDLE_TX_FTS	  10
#define	LPU_LTSSM_CONFIG5_RX_FTS_RVR_LK	  9
#define	LPU_LTSSM_CONFIG5_CFG_UNUSED_1	7
#define	LPU_LTSSM_CONFIG5_CFG_UNUSED_1_MASK	0x3
#define	LPU_LTSSM_CONFIG5_LPBK_ENTRY_ACTIVE	  6
#define	LPU_LTSSM_CONFIG5_LPBK_ENTRY_EXIT	  5
#define	LPU_LTSSM_CONFIG5_LPBK_ACTIVE_EXIT	  4
#define	LPU_LTSSM_CONFIG5_L1_IDLE_RCVRY_LK	  3
#define	LPU_LTSSM_CONFIG5_L0_TRN_CNTRL_RST	  2
#define	LPU_LTSSM_CONFIG5_L0_LPBK	  1
#define	LPU_LTSSM_CONFIG5_CFG_UNUSED_2	  0
#define	LPU_LTSSM_STATUS1	0xe27a8
#define	LPU_LTSSM_STATUS1_RX_LN_EN_MSK	16
#define	LPU_LTSSM_STATUS1_RX_LN_EN_MSK_MASK	0xffff
#define	LPU_LTSSM_STATUS1_RX_ALGN_CMD	  15
#define	LPU_LTSSM_STATUS1_MSTR_LN_SEL	  14
#define	LPU_LTSSM_STATUS1_LNK_OT_RX	  13
#define	LPU_LTSSM_STATUS1_LNK_OT_TX	  12
#define	LPU_LTSSM_STATUS1_LN_RVRSD	  11
#define	LPU_LTSSM_STATUS1_LNK_UP_DWN_STS	  10
#define	LPU_LTSSM_STATUS1_LTSSM_STATE	4
#define	LPU_LTSSM_STATUS1_LTSSM_STATE_MASK	0x3f
#define	LPU_LTSSM_STATUS1_CNFG_LNK_WDTH	0
#define	LPU_LTSSM_STATUS1_CNFG_LNK_WDTH_MASK	0xf
#define	LPU_LTSSM_STATUS2	0xe27b0
#define	LPU_LTSSM_STATUS2_TX_CMD_TX_PHY	16
#define	LPU_LTSSM_STATUS2_TX_CMD_TX_PHY_MASK	0xffff
#define	LPU_LTSSM_STATUS2_RX_CMD_RX_PHY	0
#define	LPU_LTSSM_STATUS2_RX_CMD_RX_PHY_MASK	0xffff
#define	LPU_LTSSM_INTERRUPT_AND_STATUS	0xe27b8
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_INT_ANY	  31
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_INT_SKIP_OS	  15
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_INT_FTS	  14
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_INT_TS2_RECOV	  13
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_INT_8IDLE_DATA	  12
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_INT_IDLE_DATA	  11
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_INT_TSX_POLL	  10
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_INT_TSX_INV	  9
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_INT_EIDLE_EXIT	  8
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_INT_TSX_COMP	  7
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_INT_TSX_LB	  6
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_INT_TSX_DIS	  5
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_INT_TSX_RST	  4
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_INT_EIDLE	  3
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_INT_TS2	  2
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_INT_TS1	  1
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_INT_NONE	  0
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_TEST	0xe27c0
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_TEST_TST_SKIP_OS	  15
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_TEST_TST_FTS	  14
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_TEST_TST_TS2_RECOV	  13
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_TEST_TST_8IDLE_DATA	  12
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_TEST_TST_IDLE_DATA	  11
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_TEST_TST_TSX_POLL	  10
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_TEST_TST_TSX_INV	  9
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_TEST_TST_EIDLE_EXIT	  8
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_TEST_TST_TSX_COMP	  7
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_TEST_TST_TSX_LB	  6
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_TEST_TST_TSX_DIS	  5
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_TEST_TST_TSX_RST	  4
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_TEST_TST_EIDLE	  3
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_TEST_TST_TS2	  2
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_TEST_TST_TS1	  1
#define	LPU_LTSSM_INTERRUPT_AND_STATUS_TEST_TST_NONE	  0
#define	LPU_LTSSM_INTERRUPT_MASK	0xe27c8
#define	LPU_LTSSM_INTERRUPT_MASK_MSK_GLB	  31
#define	LPU_LTSSM_INTERRUPT_MASK_MSK_SKIP_OS	  15
#define	LPU_LTSSM_INTERRUPT_MASK_MSK_FTS	  14
#define	LPU_LTSSM_INTERRUPT_MASK_MSK_TS2_RECOV	  13
#define	LPU_LTSSM_INTERRUPT_MASK_MSK_8IDLE_DATA	  12
#define	LPU_LTSSM_INTERRUPT_MASK_MSK_IDLE_DATA	  11
#define	LPU_LTSSM_INTERRUPT_MASK_MSK_TSX_POLL	  10
#define	LPU_LTSSM_INTERRUPT_MASK_MSK_TSX_INV	  9
#define	LPU_LTSSM_INTERRUPT_MASK_MSK_EIDLE_EXIT	  8
#define	LPU_LTSSM_INTERRUPT_MASK_MSK_TSX_COMP	  7
#define	LPU_LTSSM_INTERRUPT_MASK_MSK_TSX_LB	  6
#define	LPU_LTSSM_INTERRUPT_MASK_MSK_TSX_DIS	  5
#define	LPU_LTSSM_INTERRUPT_MASK_MSK_TSX_RST	  4
#define	LPU_LTSSM_INTERRUPT_MASK_MSK_EIDLE	  3
#define	LPU_LTSSM_INTERRUPT_MASK_MSK_TS2	  2
#define	LPU_LTSSM_INTERRUPT_MASK_MSK_TS1	  1
#define	LPU_LTSSM_INTERRUPT_MASK_MSK_NONE	  0
#define	LPU_LTSSM_STATUS_WRITE_ENABLE	0xe27d0
#define	LPU_LTSSM_STATUS_WRITE_ENABLE_WE_UNUSED	11
#define	LPU_LTSSM_STATUS_WRITE_ENABLE_WE_UNUSED_MASK	0x1fffff
#define	LPU_LTSSM_STATUS_WRITE_ENABLE_WE1_LTSSM_STS2	  10
#define	LPU_LTSSM_STATUS_WRITE_ENABLE_WE2_LTSSM_STS2	  9
#define	LPU_LTSSM_STATUS_WRITE_ENABLE_WE1_LTSSM_STS1	  8
#define	LPU_LTSSM_STATUS_WRITE_ENABLE_WE2_LTSSM_STS1	  7
#define	LPU_LTSSM_STATUS_WRITE_ENABLE_WE3_LTSSM_STS1	  6
#define	LPU_LTSSM_STATUS_WRITE_ENABLE_WE4_LTSSM_STS1	  5
#define	LPU_LTSSM_STATUS_WRITE_ENABLE_WE5_LTSSM_STS1	  4
#define	LPU_LTSSM_STATUS_WRITE_ENABLE_WE6_LTSSM_STS1	  3
#define	LPU_LTSSM_STATUS_WRITE_ENABLE_WE7_LTSSM_STS1	  2
#define	LPU_LTSSM_STATUS_WRITE_ENABLE_WE8_LTSSM_STS1	  1
#define	LPU_LTSSM_STATUS_WRITE_ENABLE_WE9_LTSSM_STS1	  0

/* Reserved 0xe27d8 - 0xe27f8 */

#define	LPU_GIGABLAZE_GLUE_CONFIG1	0xe2800
#define	LPU_GIGABLAZE_GLUE_CONFIG1_UNUSED_CNTL1	28
#define	LPU_GIGABLAZE_GLUE_CONFIG1_UNUSED_CNTL1_MASK	0xf
#define	LPU_GIGABLAZE_GLUE_CONFIG1_STM_SEL	24
#define	LPU_GIGABLAZE_GLUE_CONFIG1_STM_SEL_MASK	0xf
#define	LPU_GIGABLAZE_GLUE_CONFIG1_UNUSED_CNTL2	22
#define	LPU_GIGABLAZE_GLUE_CONFIG1_UNUSED_CNTL2_MASK	0x3
#define	LPU_GIGABLAZE_GLUE_CONFIG1_REV_LPBK_SEL	20
#define	LPU_GIGABLAZE_GLUE_CONFIG1_REV_LPBK_SEL_MASK	0x3
#define	LPU_GIGABLAZE_GLUE_CONFIG1_REV_LPBK_MODE	  19
#define	LPU_GIGABLAZE_GLUE_CONFIG1_LPBK_ENB	  18
#define	LPU_GIGABLAZE_GLUE_CONFIG1_LPBK_MODE_SEL	16
#define	LPU_GIGABLAZE_GLUE_CONFIG1_LPBK_MODE_SEL_MASK	0x3
#define	LPU_GIGABLAZE_GLUE_CONFIG1_RXLOS_FLTR_EN	  15
#define	LPU_GIGABLAZE_GLUE_CONFIG1_RXLOS_ADJUST	12
#define	LPU_GIGABLAZE_GLUE_CONFIG1_RXLOS_ADJUST_MASK	0x7
#define	LPU_GIGABLAZE_GLUE_CONFIG1_RXLOS_SMPL_RT	8
#define	LPU_GIGABLAZE_GLUE_CONFIG1_RXLOS_SMPL_RT_MASK	0xf
#define	LPU_GIGABLAZE_GLUE_CONFIG1_RXLOS_THRSH_CN	0
#define	LPU_GIGABLAZE_GLUE_CONFIG1_RXLOS_THRSH_CN_MASK	0xff
#define	LPU_GIGABLAZE_GLUE_CONFIG2	0xe2808
#define	LPU_GIGABLAZE_GLUE_CONFIG2_TX_VPULSE_CTL	30
#define	LPU_GIGABLAZE_GLUE_CONFIG2_TX_VPULSE_CTL_MASK	0x3
#define	LPU_GIGABLAZE_GLUE_CONFIG2_TX_VMUX_CTL	28
#define	LPU_GIGABLAZE_GLUE_CONFIG2_TX_VMUX_CTL_MASK	0x3
#define	LPU_GIGABLAZE_GLUE_CONFIG2_TX_RISE_FALL	25
#define	LPU_GIGABLAZE_GLUE_CONFIG2_TX_RISE_FALL_MASK	0x7
#define	LPU_GIGABLAZE_GLUE_CONFIG2_TX_PRE_EMPH	22
#define	LPU_GIGABLAZE_GLUE_CONFIG2_TX_PRE_EMPH_MASK	0x7
#define	LPU_GIGABLAZE_GLUE_CONFIG2_TX_VSWNG_CTL	18
#define	LPU_GIGABLAZE_GLUE_CONFIG2_TX_VSWNG_CTL_MASK	0xf
#define	LPU_GIGABLAZE_GLUE_CONFIG2_TX_PLL_ZERO_CTL	16
#define	LPU_GIGABLAZE_GLUE_CONFIG2_TX_PLL_ZERO_CTL_MASK	0x3
#define	LPU_GIGABLAZE_GLUE_CONFIG2_TX_PLL_POLE_CTL	14
#define	LPU_GIGABLAZE_GLUE_CONFIG2_TX_PLL_POLE_CTL_MASK	0x3
#define	LPU_GIGABLAZE_GLUE_CONFIG2_RX_PLL_ZERO_CTL	12
#define	LPU_GIGABLAZE_GLUE_CONFIG2_RX_PLL_ZERO_CTL_MASK	0x3
#define	LPU_GIGABLAZE_GLUE_CONFIG2_RX_PLL_POLE_CTL	10
#define	LPU_GIGABLAZE_GLUE_CONFIG2_RX_PLL_POLE_CTL_MASK	0x3
#define	LPU_GIGABLAZE_GLUE_CONFIG2_RX_EQLIZR_CTL	6
#define	LPU_GIGABLAZE_GLUE_CONFIG2_RX_EQLIZR_CTL_MASK	0xf
#define	LPU_GIGABLAZE_GLUE_CONFIG2_OHM_SEL	  5
#define	LPU_GIGABLAZE_GLUE_CONFIG2_RTRIMEN	  4
#define	LPU_GIGABLAZE_GLUE_CONFIG2_TX_TERM	2
#define	LPU_GIGABLAZE_GLUE_CONFIG2_TX_TERM_MASK	0x3
#define	LPU_GIGABLAZE_GLUE_CONFIG2_RX_TERM	0
#define	LPU_GIGABLAZE_GLUE_CONFIG2_RX_TERM_MASK	0x3
#define	LPU_GIGABLAZE_GLUE_CONFIG3	0xe2810
#define	LPU_GIGABLAZE_GLUE_CONFIG3_UNUSED_CNTL3	27
#define	LPU_GIGABLAZE_GLUE_CONFIG3_UNUSED_CNTL3_MASK	0x1f
#define	LPU_GIGABLAZE_GLUE_CONFIG3_OUT_BIAS_CTL	  26
#define	LPU_GIGABLAZE_GLUE_CONFIG3_TX_RCV_DET	24
#define	LPU_GIGABLAZE_GLUE_CONFIG3_TX_RCV_DET_MASK	0x3
#define	LPU_GIGABLAZE_GLUE_CONFIG3_TX_PLL_HLF_RT_CTL	  23
#define	LPU_GIGABLAZE_GLUE_CONFIG3_TX_PLL_FDBK_DIV	20
#define	LPU_GIGABLAZE_GLUE_CONFIG3_TX_PLL_FDBK_DIV_MASK	0x7
#define	LPU_GIGABLAZE_GLUE_CONFIG3_RX_PLL_HLF_RT_CTL	  19
#define	LPU_GIGABLAZE_GLUE_CONFIG3_RX_PLL_FDBK_DIV	16
#define	LPU_GIGABLAZE_GLUE_CONFIG3_RX_PLL_FDBK_DIV_MASK	0x7
#define	LPU_GIGABLAZE_GLUE_CONFIG3_BIT_LCK_TM	0
#define	LPU_GIGABLAZE_GLUE_CONFIG3_BIT_LCK_TM_MASK	0xffff
#define	LPU_GIGABLAZE_GLUE_CONFIG4	0xe2818
#define	LPU_GIGABLAZE_GLUE_CONFIG4_CFG_UNUSED	20
#define	LPU_GIGABLAZE_GLUE_CONFIG4_CFG_UNUSED_MASK	0xfff
#define	LPU_GIGABLAZE_GLUE_CONFIG4_INIT_TIME	0
#define	LPU_GIGABLAZE_GLUE_CONFIG4_INIT_TIME_MASK	0xfffff
#define	LPU_GIGABLAZE_GLUE_STATUS	0xe2820
#define	LPU_GIGABLAZE_GLUE_STATUS_RCV_ELECT_IDLE	16
#define	LPU_GIGABLAZE_GLUE_STATUS_RCV_ELECT_IDLE_MASK	0xffff
#define	LPU_GIGABLAZE_GLUE_STATUS_BIT_SYNC_DN	0
#define	LPU_GIGABLAZE_GLUE_STATUS_BIT_SYNC_DN_MASK	0xffff
#define	LPU_GIGABLAZE_GLUE_INTERRUPT_AND_STATUS	0xe2828
#define	LPU_GIGABLAZE_GLUE_INTERRUPT_AND_STATUS_INT_GLOBL_UNMSK	  31
#define	LPU_GIGABLAZE_GLUE_INTERRUPT_AND_STATUS_INT_UNUSED	16
#define	LPU_GIGABLAZE_GLUE_INTERRUPT_AND_STATUS_INT_UNUSED_MASK	0xff
#define	LPU_GIGABLAZE_GLUE_INTERRUPT_AND_STATUS_INT_BYTE_SYNC_STS	0
#define	LPU_GIGABLAZE_GLUE_INTERRUPT_AND_STATUS_INT_BYTE_SYNC_STS_MASK	0xffff
#define	LPU_GIGABLAZE_GLUE_INTERRUPT_AND_STATUS_TEST	0xe2830
#define	LPU_GIGABLAZE_GLUE_INTERRUPT_AND_STATUS_TEST_TST_W1S_INT	16
#define	LPU_GIGABLAZE_GLUE_INTERRUPT_AND_STATUS_TEST_TST_W1S_INT_MASK	0xff
#define	LPU_GIGABLAZE_GLUE_INTERRUPT_AND_STATUS_TEST_TST_BSSS_INT	0
#define	LPU_GIGABLAZE_GLUE_INTERRUPT_AND_STATUS_TEST_TST_BSSS_INT_MASK	0xffff
#define	LPU_GIGABLAZE_GLUE_INTERRUPT_MASK	0xe2838
#define	LPU_GIGABLAZE_GLUE_INTERRUPT_MASK_MSK_GLOBL_INT	  31
#define	LPU_GIGABLAZE_GLUE_INTERRUPT_MASK_MSK_INT	0
#define	LPU_GIGABLAZE_GLUE_INTERRUPT_MASK_MSK_INT_MASK	0xffffff
#define	LPU_GIGABLAZE_GLUE_POWER_DOWN1	0xe2840
#define	LPU_GIGABLAZE_GLUE_POWER_DOWN1_TX_PWR_DN	16
#define	LPU_GIGABLAZE_GLUE_POWER_DOWN1_TX_PWR_DN_MASK	0xffff
#define	LPU_GIGABLAZE_GLUE_POWER_DOWN1_THE	0
#define	LPU_GIGABLAZE_GLUE_POWER_DOWN1_THE_MASK	0x1
#define	LPU_GIGABLAZE_GLUE_POWER_DOWN1_RX_PWR_DN	0
#define	LPU_GIGABLAZE_GLUE_POWER_DOWN1_RX_PWR_DN_MASK	0xffff
#define	LPU_GIGABLAZE_GLUE_POWER_DOWN2	0xe2848
#define	LPU_GIGABLAZE_GLUE_POWER_DOWN2_PD_UNUSED	22
#define	LPU_GIGABLAZE_GLUE_POWER_DOWN2_PD_UNUSED_MASK	0x3ff
#define	LPU_GIGABLAZE_GLUE_POWER_DOWN2_PWR_DN_CLK_BUF	  21
#define	LPU_GIGABLAZE_GLUE_POWER_DOWN2_PWR_DN_RES_TRIM	  20
#define	LPU_GIGABLAZE_GLUE_POWER_DOWN2_TX_PLL_PWR_D	16
#define	LPU_GIGABLAZE_GLUE_POWER_DOWN2_TX_PLL_PWR_D_MASK	0xf
#define	LPU_GIGABLAZE_GLUE_POWER_DOWN2_RXLOS_PWR_DN	0
#define	LPU_GIGABLAZE_GLUE_POWER_DOWN2_RXLOS_PWR_DN_MASK	0xffff
#define	LPU_GIGABLAZE_GLUE_CONFIG5	0xe2850

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_PX_REGS_H */
