/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _SYS_SMC_COMMANDS_H
#define	_SYS_SMC_COMMANDS_H

#pragma ident	"%Z%%M%	%I%	%E% SMI"

#ifdef	__cplusplus
extern "C" {
#endif

/* Address of BMC on IPMB */
#define	BMC_IPMB_ADDR	0x20
#define	SMC_CPCI_SLOT0_ADDR	0xB0
#define	SMC_CPCI_SLOT_ADDR(X)	(SMC_CPCI_SLOT0_ADDR + \
		2 * ((X) - 1))

typedef struct ctsmc_code_ent {
	uint8_t code;
	char	*name;
} ctsmc_code_ent_t;

/*
 * Definition of Network Function Codes
 */
typedef enum {
	SMC_NETFN_CHASSIS_REQ = 0x0,
	SMC_NETFN_CHASSIS_RSP = 0x1,
	SMC_NETFN_BRIDGE_REQ = 0x2,
	SMC_NETFN_BRIDGE_RSP = 0x3,
	SMC_NETFN_SENSOR_REQ = 0x4,
	SMC_NETFN_SENSOR_RSP = 0x5,
	SMC_NETFN_APP_REQ = 0x6,
	SMC_NETFN_APP_RSP = 0x7,
	SMC_NETFN_FIRMWARE_REQ = 0x8,
	SMC_NETFN_FIRMWARE_RSP = 0x9,
	SMC_NETFN_STORAGE_REQ = 0xA,
	SMC_NETFN_STORAGE_RSP = 0xB
} smc_netfn_t;

/*
 * Definition of Completion codes
 */
typedef enum {
	SMC_CC_SUCCESS	 = 0x00,
	SMC_CC_NODE_BUSY = 0xC0,
	SMC_CC_INVALID_COMMAND = 0xC1,
	SMC_CC_INVALID_COMMAND_ON_LUN = 0xC2,
	SMC_CC_TIMEOUT = 0xC3,
	SMC_CC_RESOURCE_NOTAVAIL = 0xC4,
	SMC_CC_RESERVATION = 0xC5,
	SMC_CC_REQ_TRUNC = 0xC6,
	SMC_CC_REQLEN_NOTVALID = 0xC7,
	SMC_CC_REQLEN_EXCEED = 0xC8,
	SMC_CC_PARAM_OUT_OF_RANGE = 0xC9,
	SMC_CC_REQUEST_BYTES_FAILED = 0xCA,
	SMC_CC_NOT_PRESENT = 0xCB,
	SMC_CC_INVALID_FIELD = 0xCC,
	SMC_CC_ILLEGAL_COMMAND = 0xCD,
	SMC_CC_RESPONSE_FAILED = 0xCE,
	SMC_CC_DUPLICATE_REQUEST = 0xCF,
	SMC_CC_SDR_UPDATE_MODE = 0xD0,
	SMC_CC_FIRMWARE_UPDATE_MODE = 0xD1,
	SMC_CC_INIT_IN_PROGRESS = 0xD2,
	SMC_CC_UNSPECIFIED_ERROR = 0xFF
} smc_cc_t;

typedef enum {
	SMC_BMC_LUN,
	SMC_OEM1_LUN,
	SMC_SMS_LUN,
	SMC_OEM2_LUN
} smc_lun_t;

/*
 * App command codes for commands/event notifications etc.
 */
typedef enum {
	SMC_GET_DEVICE_ID = 0x01,
	SMC_COLD_RESET = 0x02,
	SMC_WARM_RESET = 0x03,
	SMC_GET_SELFTEST_RESULTS = 0x04,
	SMC_MANUFACTURING_TEST_ON = 0x05,
	SMC_SET_ACPI_POWER_STATE = 0x06,
	SMC_GET_ACPI_POWER_STATE = 0x07,
	SMC_GET_DEVICE_GUID = 0x08,
	SMC_RESET_WATCHDOG_TIMER = 0x22,
	SMC_EXPIRED_WATCHDOG_NOTIF = 0x23,	/* Sent by driver */
	SMC_SET_WATCHDOG_TIMER = 0x24,
	SMC_GET_WATCHDOG_TIMER = 0x25,
	SMC_SET_GLOBAL_ENABLES = 0x2E,
	SMC_GET_GLOBAL_ENABLES = 0x2F,
	SMC_CLEAR_MESSAGE_FLAGS = 0x30,
	SMC_GET_MESSAGE_FLAGS = 0x31,
	SMC_ENABLE_MESSAGE_CHANNEL_RECEIVE = 0x32,
	SMC_GET_MESSAGE = 0x33,
	SMC_SEND_MESSAGE = 0x34,
	SMC_READ_EVENT_MSG_BUFFER = 0x35,
	SMC_SEND_TO_EVENT_MSG_BUFFER = 0x36,	/* Changed from IPMI */
	SMC_MASTER_WR_RD_I2C = 0x52,
	SMC_GET_GEOGRAPHICAL_ADDRESS = 0x55,
	SMC_GET_BACKPLANE_TYPE = 0x57,
	SMC_SELECT_MEMORY_DEVICE = 0x60,
	SMC_READ_SELECTED_MEMORY_DEVICE = 0x61,
	SMC_READ_MEMORY_DEVICE = 0x62,
	SMC_WRITE_SELECTED_MEMORY_DEVICE = 0x63,
	SMC_WRITE_MEMORY_DEVICE = 0x64,
	SMC_ERASE_SELECTED_MEMORY_DEVICE = 0x65,
	SMC_LOCK_UNLOCK_SELECTED_MEMORY = 0x66,
	SMC_COMPUTE_CRC16_OF_SELECTED_MEMORY_DEVICE = 0x67,
	SMC_COMPUTE_CRC16_OF_MEMORY_DEVICE = 0x68,
	SMC_FILL_MEMORY_DEVICE = 0x6a,
	SMC_QUERY_FIRMWARE_VERSION = 0x6f,
	SMC_RESET_DEVICE = 0x70,
	SMC_GET_ROLE_INFO = 0x71,
	SMC_GET_FLASH_AND_BOOT_VERSION = 0x72,
	SMC_GET_LOCAL_HA_SIGNAL_STATUS = 0x73,
	SMC_SELECT_HA_HOTSWAP_MODE = 0x80,
	SMC_GET_HA_HOTSWAP_SIGNAL_STATE = 0x81,
	SMC_SET_HA_HOTSWAP_SIGNAL_STATE = 0x82,
	SMC_NOTIFY_SMC_OF_HOST_HEALTH = 0x83,
	SMC_TURN_ON_OFF_BLUE_LED = 0x84,
	SMC_GET_EXECUTION_STATE = 0x85,
	SMC_GET_SMC_UPTIME = 0x86,
	SMC_ENUM_NOTIF = 0x87,
	SMC_IPMI_RESPONSE_NOTIF = 0x88,
	SMC_SET_INTERFACE_TIMEOUT = 0x89,
	SMC_GET_INTERFACE_TIMEOUT = 0x8A,
	SMC_SMC_LOCAL_EVENT_NOTIF = 0x8B,
	SMC_GET_DEVICE_TABLE_DATA = 0x8C,
	SMC_IPMI_MASTER_WR_RD_I2C = 0x90,
	SMC_GET_SMC_SELF_TEST_RESULT = 0xA0,
	SMC_READ_SMC_PLD_REGISTER = 0xA1,
	SMC_WRITE_SMC_PLD_REGISTER = 0xA2,
	SMC_SET_ROLE = 0xC0,
	SMC_SET_CPCI_INTMASK = 0xC1,
	SMC_GET_CPCI_INTMASK = 0xC2,
	SMC_EEPROM_WRITE = 0xC3,
	SMC_EEPROM_READ = 0xC4,
	SMC_SET_STATE = 0xDE,
	SMC_GET_STATE = 0xDF,
	SMC_SET_DHCP_CLIENT_ID = 0xE1,
	SMC_GET_DHCP_CLIENT_ID = 0xE2,
	SMC_DEV_SDR_REPOSITORY_RESERVE = 0xE3,
	SMC_FRU_INVENTORY_AREA_INFO_GET = 0xE4,
	SMC_SET_BANNER = 0xE5,
	SMC_GET_BANNER = 0xE6,
	SMC_SEND_ASYNC_SEL_CMD_TO_HOST = 0xE7,
	SMC_MASTER_WR_RD_I2C_2 = 0xE9,
	SMC_GET_BUFFER_BLOCK_ALLOC_TABLE = 0xEA,
	SMC_GET_BUFFER_ALLOC_TABLE = 0xEB,
	SMC_GET_SFRS = 0xEC,
	SMC_GET_PORT_VALUE = 0xED,
	SMC_GET_BUFFER_DATA = 0xEE,
	SMC_GET_PCB_DATA = 0xEF,
	SMC_GET_PCB_BLOCK_ALLOC_TABLE = 0xF0,
	SMC_GET_PCB_TABLE = 0xF1,
	SMC_DEVICE_SDR_INFO_GET = 0xF2,
	SMC_DEVICE_SDR_GET = 0xF3,
	SMC_SENSOR_EVENT_ENABLE_GET = 0xF4,
	SMC_SENSOR_EVENT_ENABLE_SET = 0xF5,
	SMC_GET_CONFIG_BLOCK = 0xF8,
	SMC_SET_CONFIG_BLOCK = 0xF9,
	SMC_SET_VOLTAGE = 0xFB,
	SMC_SENSOR_READING_GET = 0xFC,
	SMC_SENSOR_THRESHOLD_GET = 0xFD,
	SMC_SENSOR_THRESHOLD_SET = 0xFE,
	SMC_CND_OF_CMD_MARKER = 0xFF
} smc_app_command_t;

typedef enum {
	SMC_GET_CHASSIS_STATUS = 0x01,
	SMC_CHASSIS_CONTROL = 0x02,
	SMC_GET_POH_COUNTER = 0x0F
} smc_chassis_command_t;

typedef enum {
	SMC_SET_EVENT_RECEIVER = 0x00,
	SMC_GET_EVENT_RECEIVER = 0x01,
	SMC_PLATFORM_EVENT_MESSAGE = 0x02
} smc_event_command_t;

typedef enum {
	SMC_GET_SEL_INFO = 0x40,
	SMC_GET_SEL_ALLOCATION_INFO = 0x41,
	SMC_RESERVE_SEL = 0x42,
	SMC_GET_SEL_ENTRY = 0x43,
	SMC_ADD_SEL_ENTRY = 0x44,
	SMC_PARTIAL_ADD_SEL_ENTRY = 0x45,
	SMC_DELETE_SEL_ENTRY = 0x46,
	SMC_CLEAR_SEL = 0x47,
	SMC_GET_SEL_TIME = 0x48,
	SMC_SET_SEL_TIME = 0x49
} smc_sel_command_t;

typedef enum {
	SMC_GET_SDR_REPOSITORY_INFO = 0x20,
	SMC_GET_SDR_REPOSITORY_ALLOCATION_INFO = 0x21,
	SMC_RESERVE_SDR_REPOSITORY = 0x22,
	SMC_GET_SDR = 0x23,
	SMC_ADD_SDR = 0x24,
	SMC_PARTIAL_ADD_SDR = 0x25,
	SMC_DELETE_SDR = 0x26,
	SMC_CLEAR_SDR_REPOSITORY = 0x27,
	SMC_GET_SDR_REPOSITORY_TIME = 0x28,
	SMC_SET_SDR_REPOSITORY_TIME = 0x29,
	SMC_ENTER_SDR_REPOSITORY_UPDATE_MODE = 0x2A,
	SMC_EXIT_SDR_REPOSITORY_UPDATE_MODE = 0x2B,
	SMC_RUN_INITIALIZATION_AGENT = 0x2C
} smc_sdr_repository_command_t;

typedef enum {
	SMC_GET_FRU_INVENTORY_AREA_INFO = 0x10,
	SMC_READ_FRU_INVENTORY_DATA = 0x11,
	SMC_WRITE_FRU_INVENTORY_DATA = 0x12
} smc_fru_inventory_device_command_t;

typedef enum {
	SMC_GET_DEVICE_SDR_INFO = 0x20,
	SMC_GET_DEVICE_SDR = 0x21,
	SMC_RESERVE_DEVICE_SDR_REPOSITORY = 0x22,
	SMC_GET_SENSOR_READING_FACTORS = 0x23,
	SMC_SET_SENSOR_HYSTERESIS = 0x24,
	SMC_GET_SENSOR_HYSTERESIS = 0x25,
	SMC_SET_SENSOR_THRESHOLD = 0x26,
	SMC_GET_SENSOR_THRESHOLD = 0x27,
	SMC_SET_SENSOR_EVENT_ENABLE = 0x28,
	SMC_GET_SENSOR_EVENT_ENABLE = 0x29,
	SMC_REARM_SENSOR_EVENTS = 0x2A,
	SMC_GET_SENSOR_EVENT_STATUS = 0x2B,
	/* RESERVED */
	SMC_GET_SENSOR_READING = 0x2D,
	SMC_SET_SENSOR_TYPE = 0x2E,
	SMC_GET_SENSOR_TYPE = 0x2F
} smc_sensor_device_command_t;

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_SMC_COMMANDS_H */
