/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * ident	"%Z%%M%	%I%	%E% SMI"
 *
 * Copyright 2002 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
package com.sun.dhcpmgr.ui;

import javax.swing.AbstractAction;

/**
 * MnemonicAction is an extended version of AbstractAction which
 * allows the name and mnemonic for the action to be specified using
 * the & syntax in a resource string.
 */
public abstract class MnemonicAction extends AbstractAction {
    private Mnemonic m;

    public MnemonicAction(String s) {
	m = new Mnemonic(s);
	putValue(NAME, m.getString());
	putValue(MNEMONIC_KEY, new Integer(m.getMnemonic()));
    }
}
