/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2008 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _SINGDOUB64_SS12_H
#define	_SINGDOUB64_SS12_H

#pragma ident	"%Z%%M%	%I%	%E% SMI"

#ifdef __cplusplus
extern "C" {
#endif

/* 64-bit golden values for V9A/SS12 Lapack */


static struct LinpVals LinpValsA[] = {

#ifdef DP  /* { */

/* Start of DP golden values */


{0.0000000000000000e+00, 0.0000000000000000e+00,
	0.0000000000000000e+00, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L0 */
{0.0000000000000000e+00, 0.0000000000000000e+00,
	2.2204460492503131e-16, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L1 */
{0.0000000000000000e+00, 0.0000000000000000e+00,
	2.2204460492503131e-16, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L2 */
{0.0000000000000000e+00, 0.0000000000000000e+00,
	2.2204460492503131e-16, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L3 */
{3.8260177822204688e-01, 1.6653345369377348e-16,
	2.2204460492503131e-16, 2.2204460492503131e-16,
	2.2204460492503131e-16}, /* L4 */
{4.0810856343684981e-01, 2.2204460492503131e-16,
	2.2204460492503131e-16, -3.3306690738754696e-16,
	0.0000000000000000e+00}, /* L5 */
{3.4009046953070693e-01, 2.2204460492503131e-16,
	2.2204460492503131e-16, 8.8817841970012523e-16,
	2.6645352591003757e-15}, /* L6 */
{3.6373773558278227e-01, 2.7755575615628914e-16,
	2.2204460492503131e-16, -3.3306690738754696e-16,
	8.8817841970012523e-16}, /* L7 */
{3.2492063115128750e-01, 2.8449465006019636e-16,
	2.2204460492503131e-16, -1.7763568394002505e-15,
	-1.1102230246251565e-16}, /* L8 */
{4.5083838251885799e-01, 4.4408920985006262e-16,
	2.2204460492503131e-16, -1.5543122344752192e-15,
	-4.5519144009631418e-15}, /* L9 */
{4.0575454426697483e-01, 4.4408920985006262e-16,
	2.2204460492503131e-16, -1.1102230246251565e-16,
	-2.2204460492503131e-16}, /* L10 */
{5.9941012221257661e-01, 7.2164496600635175e-16,
	2.2204460492503131e-16, 2.2204460492503131e-16,
	2.2204460492503131e-16}, /* L11 */
{2.9586268852800246e-01, 3.8857805861880479e-16,
	2.2204460492503131e-16, -5.5511151231257827e-16,
	0.0000000000000000e+00}, /* L12 */
{6.2922387221750764e-01, 9.0205620750793969e-16,
	2.2204460492503131e-16, -1.6653345369377348e-15,
	-2.2204460492503131e-16}, /* L13 */
{5.3933474761500677e-01, 8.3266726846886741e-16,
	2.2204460492503131e-16, -4.4408920985006262e-16,
	0.0000000000000000e+00}, /* L14 */
{6.7117213036534140e-01, 1.1102230246251565e-15,
	2.2204460492503131e-16, -6.6613381477509392e-16,
	-1.1102230246251565e-16}, /* L15 */
{7.8652984027188344e-01, 1.3877787807814457e-15,
	2.2204460492503131e-16, -6.6613381477509392e-16,
	0.0000000000000000e+00}, /* L16 */
{6.3662650600829918e-01, 1.1934897514720433e-15,
	2.2204460492503131e-16, -1.1102230246251565e-15,
	-1.3322676295501878e-15}, /* L17 */
{2.9363780703483666e-01, 5.8286708792820718e-16,
	2.2204460492503131e-16, 4.4408920985006262e-16,
	4.4408920985006262e-16}, /* L18 */
{8.0143251092966705e-01, 1.6792123247455493e-15,
	2.2204460492503131e-16, -5.5511151231257827e-16,
	8.8817841970012523e-16}, /* L19 */
{5.9147043988445613e-01, 1.3045120539345589e-15,
	2.2204460492503131e-16, -6.6613381477509392e-16,
	-2.2204460492503131e-16}, /* L20 */
{5.9684867319455459e-01, 1.3877787807814457e-15,
	2.2204460492503131e-16, 2.2204460492503131e-15,
	-1.4432899320127035e-15}, /* L21 */
{4.7856411796145321e-01, 1.1657341758564144e-15,
	2.2204460492503131e-16, -5.5511151231257827e-16,
	-2.3314683517128287e-15}, /* L22 */
{4.5775698239791013e-01, 1.1657341758564144e-15,
	2.2204460492503131e-16, 2.4424906541753444e-15,
	-2.9976021664879227e-15}, /* L23 */
{6.7891536575880340e-01, 1.8041124150158794e-15,
	2.2204460492503131e-16, -1.1546319456101628e-14,
	-2.2204460492503131e-15}, /* L24 */
{5.8156934716077235e-01, 1.6098233857064770e-15,
	2.2204460492503131e-16, 1.5543122344752192e-15,
	3.3306690738754696e-15}, /* L25 */
{6.1704970521036173e-01, 1.7763568394002505e-15,
	2.2204460492503131e-16, -2.9976021664879227e-15,
	-4.2188474935755949e-15}, /* L26 */
{8.9129401863720303e-01, 2.6645352591003757e-15,
	2.2204460492503131e-16, -4.4408920985006262e-16,
	2.4424906541753444e-15}, /* L27 */
{8.9527300979183411e-01, 2.7755575615628914e-15,
	2.2204460492503131e-16, 1.5543122344752192e-15,
	-1.3322676295501878e-15}, /* L28 */
{8.1253743509383025e-01, 2.6090241078691179e-15,
	2.2204460492503131e-16, 0.0000000000000000e+00,
	6.6613381477509392e-16}, /* L29 */
{8.6065578674654963e-01, 2.8588242884097781e-15,
	2.2204460492503131e-16, 8.8817841970012523e-16,
	8.8817841970012523e-16}, /* L30 */
{9.0566972861522066e-01, 3.1086244689504383e-15,
	2.2204460492503131e-16, 1.7763568394002505e-15,
	-1.6653345369377348e-15}, /* L31 */
{7.3636205055376436e-01, 2.6090241078691179e-15,
	2.2204460492503131e-16, -9.9920072216264089e-16,
	2.1760371282653068e-14}, /* L32 */
{8.4318439831303504e-01, 3.0808688933348094e-15,
	2.2204460492503131e-16, 6.6613381477509392e-16,
	1.1102230246251565e-15}, /* L33 */
{9.7321442476194397e-01, 3.6637359812630166e-15,
	2.2204460492503131e-16, -2.6645352591003757e-15,
	2.2204460492503131e-16}, /* L34 */
{1.4583044708110673e+00, 5.6621374255882984e-15,
	2.2204460492503131e-16, -3.9968028886505635e-15,
	-4.4408920985006262e-16}, /* L35 */
{8.0446023793208044e-01, 3.2127078775090467e-15,
	2.2204460492503131e-16, -2.4091839634365897e-14,
	1.9984014443252818e-14}, /* L36 */
{5.3420930866356575e-01, 2.1926904736346842e-15,
	2.2204460492503131e-16, -2.2204460492503131e-15,
	-5.5511151231257827e-16}, /* L37 */
{4.6747763286447808e-01, 1.9706458687096529e-15,
	2.2204460492503131e-16, 7.1054273576010019e-15,
	1.5543122344752192e-15}, /* L38 */
{9.8796645269880079e-01, 4.2743586448068527e-15,
	2.2204460492503131e-16, 8.8817841970012523e-16,
	1.3322676295501878e-15}, /* L39 */
{6.1611576753753372e-01, 2.7339241981394480e-15,
	2.2204460492503131e-16, -9.5390362275793450e-13,
	2.3319124409226788e-12}, /* L40 */
{6.2244703022421788e-01, 2.8310687127941492e-15,
	2.2204460492503131e-16, 2.3536728122053319e-14,
	2.1982415887578100e-14}, /* L41 */
{8.7271897456624437e-01, 4.0661918276896358e-15,
	2.2204460492503131e-16, 7.9936057773011271e-15,
	-9.8809849191638932e-15}, /* L42 */
{6.8659341819991870e-01, 3.2751579226442118e-15,
	2.2204460492503131e-16, -2.2204460492503131e-16,
	-2.9976021664879227e-15}, /* L43 */
{7.2500932497707793e-01, 3.5388358909926865e-15,
	2.2204460492503131e-16, -1.1657341758564144e-14,
	4.2188474935755949e-15}, /* L44 */
{8.8403751416813714e-01, 4.4131365228849972e-15,
	2.2204460492503131e-16, -4.5519144009631418e-15,
	-1.2101430968414206e-14}, /* L45 */
{6.3093735629719305e-01, 3.2196467714129540e-15,
	2.2204460492503131e-16, -7.9936057773011271e-15,
	-3.3306690738754696e-15}, /* L46 */
{9.2094634655374696e-01, 4.8017145815038020e-15,
	2.2204460492503131e-16, -1.9872992140790302e-14,
	1.3322676295501878e-15}, /* L47 */
{7.9229777213175645e-01, 4.2188474935755949e-15,
	2.2204460492503131e-16, 2.1538326677728037e-14,
	1.2212453270876722e-14}, /* L48 */
{6.0205010610116116e-01, 3.2751579226442118e-15,
	2.2204460492503131e-16, -4.4408920985006262e-16,
	1.3322676295501878e-15}, /* L49 */
{1.3500208311387045e+00, 7.4940054162198066e-15,
	2.2204460492503131e-16, 4.4408920985006262e-16,
	-1.9984014443252818e-15}, /* L50 */
{1.1666846688849217e+00, 6.6058269965196814e-15,
	2.2204460492503131e-16, -1.2212453270876722e-14,
	9.3702823278363212e-14}, /* L51 */
{1.0480930953997019e+00, 6.0507154842071031e-15,
	2.2204460492503131e-16, 1.1102230246251565e-15,
	9.9920072216264089e-15}, /* L52 */
{8.8208908253996454e-01, 5.1902926401226068e-15,
	2.2204460492503131e-16, 1.5543122344752192e-15,
	-2.4424906541753444e-15}, /* L53 */
{8.2408678992692186e-01, 4.9404924595819466e-15,
	2.2204460492503131e-16, 1.7763568394002505e-15,
	-6.8833827526759706e-15}, /* L54 */
{8.6364968995405822e-01, 5.2735593669694936e-15,
	2.2204460492503131e-16, 3.1086244689504383e-15,
	-6.6613381477509392e-16}, /* L55 */
{7.5001157285481435e-01, 4.6629367034256575e-15,
	2.2204460492503131e-16, 2.2204460492503131e-14,
	8.8817841970012523e-16}, /* L56 */
{1.2017729296036601e+00, 7.6050277186823223e-15,
	2.2204460492503131e-16, 1.9984014443252818e-15,
	5.5511151231257827e-15}, /* L57 */
{1.0194122814946389e+00, 6.5641936330962380e-15,
	2.2204460492503131e-16, 2.6534330288541241e-13,
	1.6364687382974807e-13}, /* L58 */
{9.9577807695415899e-01, 6.5225602696727947e-15,
	2.2204460492503131e-16, 3.3306690738754696e-15,
	3.7747582837255322e-15}, /* L59 */
{8.5001311590214701e-01, 5.6621374255882984e-15,
	2.2204460492503131e-16, -6.5503158452884236e-15,
	1.5543122344752192e-15}, /* L60 */
{9.2624380035615839e-01, 6.2727600891321345e-15,
	2.2204460492503131e-16, -5.4067861299245124e-14,
	-9.2481577951275540e-14}, /* L61 */
{1.5242170674146556e+00, 1.0491607582707729e-14,
	2.2204460492503131e-16, 6.8833827526759706e-15,
	3.9968028886505635e-15}, /* L62 */
{8.9981547166579190e-01, 6.2935767708438561e-15,
	2.2204460492503131e-16, 3.7747582837255322e-15,
	4.4408920985006262e-16}, /* L63 */
{7.6563681395596928e-01, 5.4400928206632670e-15,
	2.2204460492503131e-16, -5.5511151231257827e-15,
	1.6875389974302379e-14}, /* L64 */
{9.1155252700817435e-01, 6.5780714209040525e-15,
	2.2204460492503131e-16, -5.8841820305133297e-15,
	-1.3322676295501878e-15}, /* L65 */
{8.6364968995405356e-01, 6.3282712403633923e-15,
	2.2204460492503131e-16, 3.7747582837255322e-15,
	-1.3322676295501878e-15}, /* L66 */
{1.0447922407927950e+00, 7.7715611723760958e-15,
	2.2204460492503131e-16, -6.7723604502134549e-15,
	4.8849813083506888e-15}, /* L67 */
{7.8677684603399289e-01, 5.9396931817445875e-15,
	2.2204460492503131e-16, -6.8833827526759706e-15,
	-2.9976021664879227e-15}, /* L68 */
{1.2246565778977070e+00, 9.3813845580825728e-15,
	2.2204460492503131e-16, 1.5032419753424620e-13,
	3.1863400806741993e-13}, /* L69 */
{1.6214535908385190e+00, 1.2601031329495527e-14,
	2.2204460492503131e-16, 2.2204460492503131e-15,
	-1.2212453270876722e-15}, /* L70 */
{9.7184598172736347e-01, 7.6605388699135801e-15,
	2.2204460492503131e-16, -1.9206858326015208e-14,
	-1.0325074129013956e-14}, /* L71 */
{8.4723529526194563e-01, 6.7723604502134549e-15,
	2.2204460492503131e-16, -1.4432899320127035e-15,
	4.2188474935755949e-15}, /* L72 */
{1.3493358890629930e+00, 1.0935696792557792e-14,
	2.2204460492503131e-16, -1.8318679906315083e-14,
	5.1070259132757201e-15}, /* L73 */
{1.1790722474159370e+00, 9.6866958898544908e-15,
	2.2204460492503131e-16, 2.8865798640254070e-15,
	-7.1054273576010019e-15}, /* L74 */
{1.0000154304731115e+00, 8.3266726846886741e-15,
	2.2204460492503131e-16, 1.7763568394002505e-15,
	-5.3290705182007514e-15}, /* L75 */
{9.9672590603067746e-01, 8.4099394115355608e-15,
	2.2204460492503131e-16, -5.6510351953420468e-14,
	-4.3631764867768652e-14}, /* L76 */
{1.8831459405013156e+00, 1.6098233857064770e-14,
	2.2204460492503131e-16, -1.2212453270876722e-15,
	-1.9984014443252818e-15}, /* L77 */
{1.1538639582381141e+00, 9.9920072216264089e-15,
	2.2204460492503131e-16, -3.3306690738754696e-16,
	4.2410519540680980e-14}, /* L78 */
{9.2090028565720605e-01, 8.0768725041480138e-15,
	2.2204460492503131e-16, 1.7763568394002505e-15,
	-6.4392935428259079e-15}, /* L79 */
{1.0812666841987244e+00, 9.6034291630076041e-15,
	2.2204460492503131e-16, 1.5609735726229701e-13,
	4.5519144009631418e-14}, /* L80 */
{9.4445901766904117e-01, 8.4932061383824475e-15,
	2.2204460492503131e-16, -6.5503158452884236e-15,
	1.1768364061026659e-14}, /* L81 */
{1.1158708766864638e+00, 1.0158540675320182e-14,
	2.2204460492503131e-16, -2.2204460492503131e-15,
	-1.7763568394002505e-15}, /* L82 */
{1.3976119269262395e+00, 1.2878587085651816e-14,
	2.2204460492503131e-16, 1.6209256159527285e-14,
	-9.8809849191638932e-15}, /* L83 */
{1.1964470328874373e+00, 1.1157741397482823e-14,
	2.2204460492503131e-16, 4.5075054799781356e-14,
	-7.4384942649885488e-15}, /* L84 */
{1.5279647533258061e+00, 1.4419021532319221e-14,
	2.2204460492503131e-16, 1.3322676295501878e-15,
	1.3322676295501878e-15}, /* L85 */
{1.0581558624773642e+00, 1.0103029524088925e-14,
	2.2204460492503131e-16, -2.5535129566378600e-15,
	2.2204460492503131e-15}, /* L86 */
{1.3391011224150913e+00, 1.2934098236883074e-14,
	2.2204460492503131e-16, -3.1752378504279477e-14,
	-1.2878587085651816e-14}, /* L87 */
{1.1306992651372059e+00, 1.1046719095020308e-14,
	2.2204460492503131e-16, 3.3306690738754696e-15,
	-1.8873791418627661e-15}, /* L88 */
{1.2584463844155744e+00, 1.2434497875801753e-14,
	2.2204460492503131e-16, 6.6613381477509392e-15,
	8.8817841970012523e-16}, /* L89 */
{1.4757172151078655e+00, 1.4745149545802860e-14,
	2.2204460492503131e-16, 3.2196467714129540e-14,
	2.1094237467877974e-14}, /* L90 */
{9.5880600339315103e-01, 9.6866958898544908e-15,
	2.2204460492503131e-16, 1.2434497875801753e-14,
	2.6645352591003757e-14}, /* L91 */
{1.0407769289978044e+00, 1.0630385460785874e-14,
	2.2204460492503131e-16, 2.8421709430404007e-14,
	-2.7755575615628914e-15}, /* L92 */
{1.3226010532063741e+00, 1.3655743202889425e-14,
	2.2204460492503131e-16, -5.6621374255882984e-15,
	1.9984014443252818e-15}, /* L93 */
{9.5480196686123875e-01, 9.9642516460107800e-15,
	2.2204460492503131e-16, -1.8873791418627661e-15,
	-1.5543122344752192e-15}, /* L94 */
{1.3822581706736938e+00, 1.4578616092109087e-14,
	2.2204460492503131e-16, 8.4376949871511897e-15,
	-5.1070259132757201e-15}, /* L95 */
{1.9166962417400433e+00, 2.0428103653102880e-14,
	2.2204460492503131e-16, -3.7747582837255322e-15,
	-3.1086244689504383e-15}, /* L96 */
{1.2371324913069346e+00, 1.3322676295501878e-14,
	2.2204460492503131e-16, -8.8817841970012523e-16,
	6.6613381477509392e-15}, /* L97 */
{8.9797303960849595e-01, 9.7699626167013776e-15,
	2.2204460492503131e-16, 6.4392935428259079e-15,
	-1.1102230246251565e-15}, /* L98 */
{1.4040620690480938e+00, 1.5432100042289676e-14,
	2.2204460492503131e-16, 6.2172489379008766e-15,
	1.3322676295501878e-15}, /* L99 */
{1.2800197510055726e+00, 1.4210854715202004e-14,
	2.2204460492503131e-16, 9.9920072216264089e-15,
	5.7731597280508140e-15}, /* L100 */
{1.5198254314615605e+00, 1.7041923427996153e-14,
	2.2204460492503131e-16, -1.7097434579227411e-14,
	2.8865798640254070e-15}, /* L101 */
{1.0593760277936337e+00, 1.1996480198117609e-14,
	2.2204460492503131e-16, -6.1062266354383610e-15,
	-1.5543122344752192e-15}, /* L102 */
{9.8059765512410590e-01, 1.1213252548714081e-14,
	2.2204460492503131e-16, -1.2989609388114332e-14,
	3.3306690738754696e-15}, /* L103 */
{1.1184066803548092e+00, 1.2913281555171352e-14,
	2.2204460492503131e-16, -9.6589403142388619e-15,
	1.1546319456101628e-14}, /* L104 */
{1.4190695156236912e+00, 1.6542323066914832e-14,
	2.2204460492503131e-16, -3.1641356201816961e-14,
	-6.1062266354383610e-15}, /* L105 */
{9.9529837655541686e-01, 1.1712852909795402e-14,
	2.2204460492503131e-16, 4.6851411639181606e-14,
	-1.0380585280245214e-13}, /* L106 */
{1.7804013037862301e+00, 2.1149748619109232e-14,
	2.2204460492503131e-16, 7.1054273576010019e-15,
	7.3274719625260332e-15}, /* L107 */
{1.2916865976944309e+00, 1.5487611193520934e-14,
	2.2204460492503131e-16, 7.7715611723760958e-15,
	1.4654943925052066e-14}, /* L108 */
{1.0527685380438851e+00, 1.2739809207573671e-14,
	2.2204460492503131e-16, -1.4321877017664519e-14,
	-5.3290705182007514e-15}, /* L109 */
{1.0727438254166126e+00, 1.3100631690576847e-14,
	2.2204460492503131e-16, 4.8849813083506888e-15,
	-2.2204460492503131e-15}, /* L110 */
{1.6441695140661536e+00, 2.0261570199409107e-14,
	2.2204460492503131e-16, 1.1102230246251565e-15,
	-5.6621374255882984e-15}, /* L111 */
{1.4509152451060254e+00, 1.8041124150158794e-14,
	2.2204460492503131e-16, 1.7097434579227411e-14,
	-2.2426505097428162e-14}, /* L112 */
{1.1725844649352746e+00, 1.4710455076283324e-14,
	2.2204460492503131e-16, 5.3290705182007514e-15,
	8.6597395920762210e-15}, /* L113 */
{1.0033049549154456e+00, 1.2698175844150228e-14,
	2.2204460492503131e-16, -5.5511151231257827e-15,
	3.9968028886505635e-15}, /* L114 */
{1.5000231457096496e+00, 1.9151347174783950e-14,
	2.2204460492503131e-16, 5.9952043329758453e-15,
	-1.4432899320127035e-15}, /* L115 */
{8.9279394843423010e-01, 1.1497747198774277e-14,
	2.2204460492503131e-16, -4.9960036108132044e-15,
	-1.1990408665951691e-14}, /* L116 */
{1.5042967159233618e+00, 1.9539925233402755e-14,
	2.2204460492503131e-16, -2.7056135110115065e-13,
	-2.5757174171303632e-13}, /* L117 */
{1.3474784190248486e+00, 1.7652546091539989e-14,
	2.2204460492503131e-16, 3.9968028886505635e-15,
	-1.9443335830260366e-12}, /* L118 */
{9.4119099338644763e-01, 1.2434497875801753e-14,
	2.2204460492503131e-16, -4.6629367034256575e-15,
	-2.1094237467877974e-15}, /* L119 */
{1.7194275728381851e+00, 2.2907023500273738e-14,
	2.2204460492503131e-16, -1.4099832412739488e-14,
	-7.5495165674510645e-15}, /* L120 */
{1.1518772778689883e+00, 1.5473733405713119e-14,
	2.2204460492503131e-16, 5.4178883601707639e-14,
	-3.8413716652030416e-14}, /* L121 */
{1.3360861898943925e+00, 1.8096635301390052e-14,
	2.2204460492503131e-16, 1.8429702208777599e-14,
	-3.4416913763379853e-15}, /* L122 */
{1.1829450823886922e+00, 1.6153745008296028e-14,
	2.2204460492503131e-16, -1.7763568394002505e-14,
	-1.9317880628477724e-14}, /* L123 */
{1.5010312257805758e+00, 2.0664026045835726e-14,
	2.2204460492503131e-16, 4.3298697960381105e-14,
	5.4845017416482733e-14}, /* L124 */
{1.1720180845143169e+00, 1.6264767310758543e-14,
	2.2204460492503131e-16, -4.9960036108132044e-14,
	3.3750779948604759e-14}, /* L125 */
{1.6666923841217633e+00, 2.3314683517128287e-14,
	2.2204460492503131e-16, 4.3520742565306136e-14,
	-6.3282712403633923e-15}, /* L126 */
{1.4389985820389368e+00, 2.0289325775024736e-14,
	2.2204460492503131e-16, 4.4408920985006262e-15,
	-4.0301095793893182e-14}, /* L127 */
{1.2754103048807188e+00, 1.8124390877005681e-14,
	2.2204460492503131e-16, -4.9960036108132044e-15,
	6.6613381477509392e-16}, /* L128 */
{1.4728909441076405e+00, 2.1094237467877974e-14,
	2.2204460492503131e-16, 2.6645352591003757e-14,
	3.0864200084579352e-14}, /* L129 */
{1.8423361199869592e+00, 2.6589841439772499e-14,
	2.2204460492503131e-16, -2.1649348980190553e-14,
	-1.7652546091539989e-14}, /* L130 */
{1.7175837546289456e+00, 2.4980018054066022e-14,
	2.2204460492503131e-16, -6.5059069243034173e-14,
	-1.1546319456101628e-14}, /* L131 */
{1.5094929888012547e+00, 2.2121193765656244e-14,
	2.2204460492503131e-16, 1.4432899320127035e-14,
	-5.5511151231257827e-16}, /* L132 */
{1.4812258631818391e+00, 2.1871393585115584e-14,
	2.2204460492503131e-16, -1.3655743202889425e-14,
	5.4400928206632670e-14}, /* L133 */
{2.1977951065248100e+00, 3.2696068075210860e-14,
	2.2204460492503131e-16, 1.1102230246251565e-15,
	-8.4376949871511897e-15}, /* L134 */
{1.1889072340069056e+00, 1.7819079545233762e-14,
	2.2204460492503131e-16, -3.3306690738754696e-15,
	-4.1078251911130792e-15}, /* L135 */
{1.7610565852814140e+00, 2.6589841439772499e-14,
	2.2204460492503131e-16, -7.6272321791748254e-14,
	-3.0642155479654321e-14}, /* L136 */
{1.7591512317081397e+00, 2.6756374893466273e-14,
	2.2204460492503131e-16, 4.8849813083506888e-15,
	2.6645352591003757e-15}, /* L137 */
{2.3614494811986848e+00, 3.6179392814972289e-14,
	2.2204460492503131e-16, -3.4749980670767400e-14,
	-1.0991207943789050e-14}, /* L138 */
{1.6259243689706477e+00, 2.5091040356528538e-14,
	2.2204460492503131e-16, 1.0658141036401503e-14,
	-9.3258734068513149e-15}, /* L139 */
{1.2660909646518197e+00, 1.9678703111480900e-14,
	2.2204460492503131e-16, -2.0439205883349132e-13,
	-2.3725466036239595e-13}, /* L140 */
{1.5895635344310999e+00, 2.4882873539411321e-14,
	2.2204460492503131e-16, -1.3211653993039363e-14,
	5.1070259132757201e-15}, /* L141 */
{1.1056508632695603e+00, 1.7430501486614958e-14,
	2.2204460492503131e-16, 2.6645352591003757e-15,
	7.7715611723760958e-15}, /* L142 */
{1.5489749499983407e+00, 2.4591439995447217e-14,
	2.2204460492503131e-16, 3.3306690738754696e-15,
	-8.8151708155237429e-14}, /* L143 */
{1.3066607870829714e+00, 2.0889540097712711e-14,
	2.2204460492503131e-16, -1.4543921622589551e-14,
	-4.2188474935755949e-15}, /* L144 */
{1.1310519351557555e+00, 1.8207657603852567e-14,
	2.2204460492503131e-16, 2.0206059048177849e-14,
	3.0198066269804258e-14}, /* L145 */
{1.5753667740327297e+00, 2.5535129566378600e-14,
	2.2204460492503131e-16, 5.9952043329758453e-15,
	2.0206059048177849e-14}, /* L146 */
{1.4864174935942889e+00, 2.4258373088059670e-14,
	2.2204460492503131e-16, -6.9610983643997315e-14,
	-4.4408920985006262e-15}, /* L147 */
{1.3116756448688298e+00, 2.1552204465535851e-14,
	2.2204460492503131e-16, 1.0658141036401503e-14,
	-5.1070259132757201e-15}, /* L148 */
{1.7114358038296786e+00, 2.8310687127941492e-14,
	2.2204460492503131e-16, 3.0642155479654321e-14,
	4.5297099404706387e-14}, /* L149 */
{2.0364897568488090e+00, 3.3913843955346579e-14,
	2.2204460492503131e-16, -4.6185277824406512e-14,
	-2.0539125955565396e-14}, /* L150 */
{1.2980332739915474e+00, 2.1760371282653068e-14,
	2.2204460492503131e-16, 4.1078251911130792e-14,
	2.3536728122053319e-14}, /* L151 */
{1.5806164945471264e+00, 2.6673108166619386e-14,
	2.2204460492503131e-16, 5.7731597280508140e-15,
	8.8817841970012523e-16}, /* L152 */
{1.5425074613829926e+00, 2.6201263381153694e-14,
	2.2204460492503131e-16, -4.6962433941644122e-14,
	-6.8056671409522096e-14}, /* L153 */
{1.6688569196855765e+00, 2.8532731732866523e-14,
	2.2204460492503131e-16, 3.1086244689504383e-15,
	1.0436096431476471e-14}, /* L154 */
{1.8822871086485009e+00, 3.2390756743438942e-14,
	2.2204460492503131e-16, 2.8865798640254070e-15,
	-2.5424107263916085e-14}, /* L155 */
{1.8654133991516275e+00, 3.2307490016592055e-14,
	2.2204460492503131e-16, 8.9483975784787617e-14,
	-5.5511151231257827e-15}, /* L156 */
{1.5637183960582457e+00, 2.7255975254547593e-14,
	2.2204460492503131e-16, 9.9920072216264089e-15,
	3.2862601528904634e-14}, /* L157 */
{1.7595208207058148e+00, 3.0864200084579352e-14,
	2.2204460492503131e-16, 3.9968028886505635e-15,
	1.7097434579227411e-14}, /* L158 */
{1.6069430345020865e+00, 2.8366198279172750e-14,
	2.2204460492503131e-16, 9.9920072216264089e-14,
	-5.9285909514983359e-14}, /* L159 */
{1.5562740136737514e+00, 2.7644553313166398e-14,
	2.2204460492503131e-16, -4.2188474935755949e-15,
	9.1038288019262836e-15}, /* L160 */
{1.7942823445832710e+00, 3.2071567623859210e-14,
	2.2204460492503131e-16, 2.5091040356528538e-14,
	-3.3306690738754696e-15}, /* L161 */
{1.7515702370168520e+00, 3.1502578323738817e-14,
	2.2204460492503131e-16, -1.4988010832439613e-14,
	8.4376949871511897e-15}, /* L162 */
{1.7753341422891886e+00, 3.2127078775090467e-14,
	2.2204460492503131e-16, 1.7097434579227411e-14,
	1.5099033134902129e-14}, /* L163 */
{1.8529249325305224e+00, 3.3736902160796944e-14,
	2.2204460492503131e-16, 1.3544720900426910e-14,
	-1.0769163338864018e-14}, /* L164 */
{1.1894122923051262e+00, 2.1788126858268697e-14,
	2.2204460492503131e-16, -1.4210854715202004e-14,
	-3.3306690738754696e-15}, /* L165 */
{1.7620753820078119e+00, 3.2474023470285829e-14,
	2.2204460492503131e-16, 9.4368957093138306e-14,
	2.8954616482224083e-13}, /* L166 */
{2.1242842752113966e+00, 3.9385161798577428e-14,
	2.2204460492503131e-16, -1.9984014443252818e-15,
	-3.2196467714129540e-14}, /* L167 */
{2.2321773001623937e+00, 4.1633363423443370e-14,
	2.2204460492503131e-16, 1.3367085216486885e-13,
	-8.4710016778899444e-14}, /* L168 */
{1.4674782648362414e+00, 2.7533531010703882e-14,
	2.2204460492503131e-16, 1.1990408665951691e-14,
	1.3100631690576847e-14}, /* L169 */
{1.3264910563040142e+00, 2.5035529205297280e-14,
	2.2204460492503131e-16, 5.7731597280508140e-15,
	1.7541523789077473e-14}, /* L170 */
{2.4971145544562403e+00, 4.7406523151494184e-14,
	2.2204460492503131e-16, -1.0991207943789050e-14,
	-8.3266726846886741e-15}, /* L171 */
{1.0436207544762772e+00, 1.9928503292021560e-14,
	2.2204460492503131e-16, 1.7763568394002505e-15,
	-4.3298697960381105e-15}, /* L172 */
{1.6792166621527975e+00, 3.2251978865360797e-14,
	2.2204460492503131e-16, -7.1054273576010019e-15,
	5.3290705182007514e-15}, /* L173 */
{1.6322090934143754e+00, 3.1530333899354446e-14,
	2.2204460492503131e-16, 2.0317081350640365e-13,
	-2.2049029269055609e-13}, /* L174 */
{2.5086101370152787e+00, 4.8738790781044372e-14,
	2.2204460492503131e-16, -8.5487172896137054e-15,
	-2.8088642523016460e-14}, /* L175 */
{1.6988898506325165e+00, 3.3195668436292181e-14,
	2.2204460492503131e-16, -9.6589403142388619e-14,
	4.7073456244106637e-14}, /* L176 */
{1.7683888685765838e+00, 3.4749980670767400e-14,
	2.2204460492503131e-16, 6.1284310959308641e-14,
	2.8421709430404007e-14}, /* L177 */
{1.5955302373829998e+00, 3.1530333899354446e-14,
	2.2204460492503131e-16, -1.1901590823981678e-13,
	-1.3200551762793111e-13}, /* L178 */
{1.7758653908470168e+00, 3.5291214395272164e-14,
	2.2204460492503131e-16, -1.6764367671839864e-14,
	5.8397731095283234e-14}, /* L179 */
{1.1736292204852639e+00, 2.3453461395206432e-14,
	2.2204460492503131e-16, -8.8817841970012523e-16,
	-1.6053824936079764e-13}, /* L180 */
{2.2514159553467405e+00, 4.5241588253475129e-14,
	2.2204460492503131e-16, -3.6859404417555197e-14,
	-3.8302694349567901e-14}, /* L181 */
{1.9890416803911044e+00, 4.0190073491430667e-14,
	2.2204460492503131e-16, -3.1530333899354446e-14,
	1.2212453270876722e-14}, /* L182 */
{1.8494137827908461e+00, 3.7574110489657642e-14,
	2.2204460492503131e-16, -4.8183679268731794e-14,
	4.4630965589931293e-14}, /* L183 */
{2.5000385761827033e+00, 5.1070259132757201e-14,
	2.2204460492503131e-16, 7.1054273576010019e-15,
	1.8429702208777599e-14}, /* L184 */
{2.2189531578855655e+00, 4.5574655160862676e-14,
	2.2204460492503131e-16, -4.9027448767446913e-13,
	2.4358293160275934e-13}, /* L185 */
{2.3306811242462593e+00, 4.8128168117500536e-14,
	2.2204460492503131e-16, 2.9753977059954195e-13,
	1.7630341631047486e-13}, /* L186 */
{2.3422821312684450e+00, 4.8627768478581856e-14,
	2.2204460492503131e-16, -3.3306690738754696e-15,
	-7.6605388699135801e-15}, /* L187 */
{1.7260904637671115e+00, 3.6026737149086330e-14,
	2.2204460492503131e-16, 1.6564527527407336e-13,
	2.0938806244430452e-13}, /* L188 */
{1.8733754674700820e+00, 3.9308833965634449e-14,
	2.2204460492503131e-16, -3.0420110874729289e-14,
	-2.8865798640254070e-15}, /* L189 */
{1.5184444825867374e+00, 3.2029934260435766e-14,
	2.2204460492503131e-16, -3.0309088572266774e-14,
	2.0650148258027912e-14}, /* L190 */
{1.8900815204229877e+00, 4.0079051188968151e-14,
	2.2204460492503131e-16, -7.1054273576010019e-15,
	-1.3100631690576847e-14}, /* L191 */
{1.4349179744548259e+00, 3.0586644328423063e-14,
	2.2204460492503131e-16, -2.3314683517128287e-15,
	-5.1070259132757201e-15}, /* L192 */
{2.2979629192475857e+00, 4.9238391142125693e-14,
	2.2204460492503131e-16, 7.5495165674510645e-15,
	-3.6082248300317588e-14}, /* L193 */
{1.5876533638438366e+00, 3.4194869158454821e-14,
	2.2204460492503131e-16, 3.1308289294429414e-14,
	2.2204460492503131e-14}, /* L194 */
{1.7923353484632876e+00, 3.8802294710649221e-14,
	2.2204460492503131e-16, 9.7699626167013776e-15,
	4.7961634663806763e-14}, /* L195 */
{1.8922884459041780e+00, 4.1176263787523482e-14,
	2.2204460492503131e-16, 4.3964831775156199e-14,
	4.8405723873656825e-14}, /* L196 */
{2.3109493640753707e+00, 5.0542903196060252e-14,
	2.2204460492503131e-16, 6.6613381477509392e-14,
	-1.7541523789077473e-14}, /* L197 */
{2.2374082611088202e+00, 4.9182879990894435e-14,
	2.2204460492503131e-16, -6.1284310959308641e-14,
	1.9761969838327786e-14}, /* L198 */
{1.9786737474811122e+00, 4.3715031594615539e-14,
	2.2204460492503131e-16, 1.3100631690576847e-13,
	-2.2315482794965646e-14}, /* L199 */
{2.8323874544038095e+00, 6.2890664898063164e-14,
	2.2204460492503131e-16, 1.6875389974302379e-14,
	2.0872192862952943e-14}, /* L200 */
{2.4428237629964049e+00, 5.4511950509095186e-14,
	2.2204460492503131e-16, 2.2648549702353193e-14,
	1.1324274851176597e-14}, /* L201 */
{1.4604185742056859e+00, 3.2751579226442118e-14,
	2.2204460492503131e-16, -7.4829031859735551e-14,
	3.4194869158454821e-14}, /* L202 */
{2.0000308609461306e+00, 4.5075054799781356e-14,
	2.2204460492503131e-16, 1.2212453270876722e-14,
	1.4654943925052066e-14}, /* L203 */
{1.8284595861100834e+00, 4.1411318818518339e-14,
	2.2204460492503131e-16, 2.0206059048177849e-14,
	9.9920072216264089e-15}, /* L204 */
{2.1146667761305893e+00, 4.8128168117500536e-14,
	2.2204460492503131e-16, 5.1856297034191812e-12,
	-7.4718009557273035e-13}, /* L205 */
{1.6650742361758482e+00, 3.8080649744642869e-14,
	2.2204460492503131e-16, -7.4051875742497941e-14,
	1.6853185513809876e-13}, /* L206 */
{1.9770836469618631e+00, 4.5435877282784531e-14,
	2.2204460492503131e-16, 7.3274719625260332e-15,
	3.4194869158454821e-14}, /* L207 */
{2.9327375605219776e+00, 6.7723604502134549e-14,
	2.2204460492503131e-16, 1.1990408665951691e-14,
	-7.6605388699135801e-15}, /* L208 */
{1.7512231940341563e+00, 4.0634162701280729e-14,
	2.2204460492503131e-16, -2.6645352591003757e-15,
	6.5503158452884236e-14}, /* L209 */
{2.1286042734352204e+00, 4.9626969200744497e-14,
	2.2204460492503131e-16, 2.6867397195928788e-14,
	1.1679546219056647e-13}, /* L210 */
{2.0885985782776806e+00, 4.8926140916449867e-14,
	2.2204460492503131e-16, 6.6613381477509392e-15,
	5.7731597280508140e-15}, /* L211 */
{2.4599436178854401e+00, 5.7898130734201914e-14,
	2.2204460492503131e-16, 1.3100631690576847e-14,
	-4.1078251911130792e-15}, /* L212 */
{2.1353029012769920e+00, 5.0494330938732901e-14,
	2.2204460492503131e-16, 1.0214051826551440e-14,
	1.3544720900426910e-14}, /* L213 */
{1.7967566963405959e+00, 4.2688075296837269e-14,
	2.2204460492503131e-16, -2.2093438190040615e-14,
	-5.1736392947532295e-14}, /* L214 */
{2.7514959446009066e+00, 6.5676630800481917e-14,
	2.2204460492503131e-16, 1.3544720900426910e-14,
	-5.2180482157382357e-15}, /* L215 */
{1.8773437826704427e+00, 4.5019543648550098e-14,
	2.2204460492503131e-16, 2.3758772726978350e-14,
	5.3512749786932545e-14}, /* L216 */
{1.5345858910015440e+00, 3.6970426720017713e-14,
	2.2204460492503131e-16, -3.7159164634203989e-13,
	9.9698027611339057e-14}, /* L217 */
{1.7683759103089505e+00, 4.2799097599299785e-14,
	2.2204460492503131e-16, -2.2648549702353193e-14,
	-2.0095036745715333e-14}, /* L218 */
{2.2546009990687268e+00, 5.4817261840867104e-14,
	2.2204460492503131e-16, 4.0856207306205761e-14,
	1.6875389974302379e-14}, /* L219 */
{2.4454922799750403e+00, 5.9729998724833422e-14,
	2.2204460492503131e-16, -2.9976021664879227e-15,
	3.3306690738754696e-15}, /* L220 */
{1.5588475827962787e+00, 3.8247183198336643e-14,
	2.2204460492503131e-16, -1.1768364061026659e-14,
	-1.5099033134902129e-14}, /* L221 */
{1.9651204123596644e+00, 4.8433479449272454e-14,
	2.2204460492503131e-16, 4.4408920985006262e-16,
	3.4861002973229915e-14}, /* L222 */
{2.5762729363532069e+00, 6.3782312764715243e-14,
	2.2204460492503131e-16, -4.3409720262843621e-14,
	1.1102230246251565e-14}, /* L223 */
{2.6339692141866542e+00, 6.5503158452884236e-14,
	2.2204460492503131e-16, -5.6299409578741688e-13,
	-1.0330625244137082e-12}, /* L224 */
{2.3311470812579520e+00, 5.8231197641589461e-14,
	2.2204460492503131e-16, 2.2093438190040615e-13,
	-3.2973623831367149e-14}, /* L225 */
{1.3761274286598091e+00, 3.4527936065842368e-14,
	2.2204460492503131e-16, 1.3100631690576847e-14,
	1.8429702208777599e-14}, /* L226 */
{2.2401226713460232e+00, 5.6454840802189210e-14,
	2.2204460492503131e-16, 1.2656542480726785e-14,
	-4.9404924595819466e-14}, /* L227 */
{4.3926116386781411e+00, 1.1118883591620943e-13,
	2.2204460492503131e-16, 3.0198066269804258e-14,
	1.5099033134902129e-14}, /* L228 */
{2.3013455539520424e+00, 5.8508753397745750e-14,
	2.2204460492503131e-16, -2.8419488984354757e-12,
	9.1238128163695364e-13}, /* L229 */
{1.7543748965038315e+00, 4.4797499043625066e-14,
	2.2204460492503131e-16, 2.6201263381153694e-14,
	3.3972824553529790e-14}, /* L230 */
{1.9348242270864668e+00, 4.9620030306840590e-14,
	2.2204460492503131e-16, 7.5495165674510645e-15,
	-1.5543122344752192e-15}, /* L231 */
{3.2349637093533472e+00, 8.3322237998117998e-14,
	2.2204460492503131e-16, 3.8191672047105385e-14,
	2.7755575615628914e-14}, /* L232 */
{2.3412378425880735e+00, 6.0562665993302289e-14,
	2.2204460492503131e-16, -5.0404125317982107e-14,
	3.0198066269804258e-14}, /* L233 */
{2.1773840248973513e+00, 5.6565863104651726e-14,
	2.2204460492503131e-16, 1.0125233984581428e-13,
	-9.7699626167013776e-15}, /* L234 */
{1.8787523938461115e+00, 4.9016346537200661e-14,
	2.2204460492503131e-16, -3.6637359812630166e-14,
	-2.1538326677728037e-14}, /* L235 */
{2.1292701432741032e+00, 5.5788706987414116e-14,
	2.2204460492503131e-16, 1.3544720900426910e-14,
	-2.3425705819590803e-14}, /* L236 */
{2.5422333200845082e+00, 6.6890937233665682e-14,
	2.2204460492503131e-16, -8.7707618945387367e-15,
	9.5479180117763462e-15}, /* L237 */
{1.7195643484079930e+00, 4.5435877282784531e-14,
	2.2204460492503131e-16, 1.9984014443252818e-15,
	1.6653345369377348e-14}, /* L238 */
{2.6799576703675378e+00, 7.1109784727241276e-14,
	2.2204460492503131e-16, -2.0827783941967937e-13,
	-2.3203661214665772e-14}, /* L239 */
{2.6667078145948717e+00, 7.1054273576010019e-14,
	2.2204460492503131e-16, -2.5091040356528538e-14,
	-1.2101430968414206e-14}, /* L240 */
{2.8563718753176426e+00, 7.6424977457634213e-14,
	2.2204460492503131e-16, 8.0380146982861334e-14,
	-7.8381745538536052e-14}, /* L241 */
{2.0961067235843580e+00, 5.6316062924111066e-14,
	2.2204460492503131e-16, 7.0388139761234925e-14,
	5.6399329650957952e-14}, /* L242 */
{1.7572287605426158e+00, 4.7406523151494184e-14,
	2.2204460492503131e-16, 3.1152858070981893e-13,
	1.0946799022804043e-13}, /* L243 */
{2.0896838836574534e+00, 5.6607496468075169e-14,
	2.2204460492503131e-16, -1.6764367671839864e-14,
	1.7541523789077473e-14}, /* L244 */
{2.0265618825707352e+00, 5.5122573172639022e-14,
	2.2204460492503131e-16, 1.3988810110276972e-14,
	5.4400928206632670e-14}, /* L245 */
{1.9146636900521390e+00, 5.2291504459844873e-14,
	2.2204460492503131e-16, -1.4321877017664519e-14,
	7.1054273576010019e-15}, /* L246 */
{2.9433652548737679e+00, 8.0713213890248880e-14,
	2.2204460492503131e-16, 1.0835776720341528e-13,
	6.5725203057809267e-14}, /* L247 */
{2.1814852737334989e+00, 6.0063065632220969e-14,
	2.2204460492503131e-16, -9.3258734068513149e-14,
	-1.6431300764452317e-14}, /* L248 */
{2.6255425207666603e+00, 7.2580830234869609e-14,
	2.2204460492503131e-16, -7.2830630415410269e-14,
	-1.2911893776390571e-13}, /* L249 */
{2.7360422177743606e+00, 7.5939254884360707e-14,
	2.2204460492503131e-16, 4.8849813083506888e-15,
	-1.8429702208777599e-14}, /* L250 */
{1.8685547286517161e+00, 5.2069459854919842e-14,
	2.2204460492503131e-16, -3.3528735343679728e-14,
	-8.8040685852774914e-14}, /* L251 */
{2.0397140129490610e+00, 5.7065463465733046e-14,
	2.2204460492503131e-16, -1.8873791418627661e-15,
	-1.3433698597964394e-14}, /* L252 */
{1.9461762750161948e+00, 5.4664606174981145e-14,
	2.2204460492503131e-16, 3.5749181392930041e-14,
	9.3480778673438181e-14}, /* L253 */
{2.2825155347116022e+00, 6.4365179852643450e-14,
	2.2204460492503131e-16, 2.9531932455029164e-14,
	4.7517545453956700e-14}, /* L254 */
{2.7804350596286973e+00, 7.8714812445923599e-14,
	2.2204460492503131e-16, 2.0428103653102880e-14,
	-9.3369756370975665e-14}, /* L255 */
{2.5801179368259426e+00, 7.3330230776491589e-14,
	2.2204460492503131e-16, -4.7739590058881731e-14,
	5.0626169922907138e-14}, /* L256 */
{1.7938019978472670e+00, 5.1181281435219717e-14,
	2.2204460492503131e-16, -2.3425705819590803e-14,
	-4.4841907964610073e-13}, /* L257 */
{1.9244482993405780e+00, 5.5122573172639022e-14,
	2.2204460492503131e-16, -3.0087043967341742e-14,
	3.5527136788005009e-14}, /* L258 */
{2.0157164311633022e+00, 5.7960580779337079e-14,
	2.2204460492503131e-16, -1.7208456881689926e-14,
	3.3750779948604759e-14}, /* L259 */
{2.9615841594774968e+00, 8.5487172896137054e-14,
	2.2204460492503131e-16, -2.8754776337791554e-14,
	6.2172489379008766e-15}, /* L260 */
{1.8314458841606844e+00, 5.3068660577082483e-14,
	2.2204460492503131e-16, 6.1062266354383610e-14,
	7.3940853440035426e-14}, /* L261 */
{2.1221701501634431e+00, 6.1728400169158704e-14,
	2.2204460492503131e-16, -2.2526425169644426e-13,
	1.8673951274195133e-13}, /* L262 */
{2.0798800017822452e+00, 6.0729199446996063e-14,
	2.2204460492503131e-16, 6.9722005946459831e-14,
	-6.6169292267659330e-14}, /* L263 */
{2.2905182977808596e+00, 6.7133798520302435e-14,
	2.2204460492503131e-16, -1.2545520178264269e-14,
	-6.3282712403633923e-14}, /* L264 */
{2.1453161215985608e+00, 6.3116178949940149e-14,
	2.2204460492503131e-16, -3.0464519795714295e-13,
	-2.1627144519698049e-13}, /* L265 */
{2.1673266754424811e+00, 6.4004357369640275e-14,
	2.2204460492503131e-16, -2.5757174171303632e-14,
	-4.0634162701280729e-14}, /* L266 */
{3.0609086537597978e+00, 9.0732976687490918e-14,
	2.2204460492503131e-16, -1.3944401189291966e-13,
	-7.1276318180935050e-14}, /* L267 */
{1.7780125097773152e+00, 5.2902127123388709e-14,
	2.2204460492503131e-16, -1.6719958750854857e-13,
	6.4170890823334048e-14}, /* L268 */
{2.7316871319862757e+00, 8.1580575628237284e-14,
	2.2204460492503131e-16, -3.8857805861880479e-15,
	4.9515946898281982e-14}, /* L269 */
{1.9296594047276290e+00, 5.7842619582970656e-14,
	2.2204460492503131e-16, 9.9920072216264089e-15,
	1.7319479184152442e-14}, /* L270 */
{2.1930688949186039e+00, 6.5981942132253835e-14,
	2.2204460492503131e-16, 1.0125233984581428e-13,
	6.2394533983933798e-14}, /* L271 */
{2.5055533671591936e+00, 7.5661699128204418e-14,
	2.2204460492503131e-16, -4.7850612361344247e-14,
	-5.4622972811557702e-14}, /* L272 */
{2.2724709621967931e+00, 6.8875460890183149e-14,
	2.2204460492503131e-16, 1.6431300764452317e-14,
	-1.2545520178264269e-14}, /* L273 */
{2.3212036999299999e+00, 7.0610184366159956e-14,
	2.2204460492503131e-16, -6.6613381477509392e-15,
	-8.9928064994637680e-15}, /* L274 */
{2.9454999952114438e+00, 8.9928064994637680e-14,
	2.2204460492503131e-16, -2.2981616609740740e-14,
	-3.3306690738754696e-16}, /* L275 */
{2.4710526216759376e+00, 7.5717210279435676e-14,
	2.2204460492503131e-16, 1.1546319456101628e-14,
	-1.4432899320127035e-14}, /* L276 */
{1.9842363934045806e+00, 6.1020632990960166e-14,
	2.2204460492503131e-16, -5.5710991375690355e-13,
	5.3890225615305098e-13}, /* L277 */
{2.6205440327309701e+00, 8.0879747343942654e-14,
	2.2204460492503131e-16, 7.0166095156309893e-14,
	-1.6964207816272392e-13}, /* L278 */
{2.4158078858022733e+00, 7.4829031859735551e-14,
	2.2204460492503131e-16, -9.5479180117763462e-15,
	1.3100631690576847e-14}, /* L279 */
{2.6000401192288352e+00, 8.0824236192711396e-14,
	2.2204460492503131e-16, -5.7953641885433171e-14,
	2.2426505097428162e-14}, /* L280 */
{2.6850948124265153e+00, 8.3766327207968061e-14,
	2.2204460492503131e-16, 1.1546319456101628e-14,
	1.2434497875801753e-14}, /* L281 */
{3.0532386015507078e+00, 9.5590202420225978e-14,
	2.2204460492503131e-16, -2.4424906541753444e-15,
	1.2434497875801753e-14}, /* L282 */
{2.7809616387984333e+00, 8.7374552037999820e-14,
	2.2204460492503131e-16, 5.6621374255882984e-14,
	4.3920422854171193e-13}, /* L283 */
{2.8415931422244336e+00, 8.9594998087250133e-14,
	2.2204460492503131e-16, 2.6645352591003757e-14,
	-1.0880185641326534e-14}, /* L284 */
{1.9627495839325932e+00, 6.2103100439969694e-14,
	2.2204460492503131e-16, 5.2846615972157451e-14,
	5.7287508070658077e-14}, /* L285 */
{1.9458342204834207e+00, 6.1783911320389961e-14,
	2.2204460492503131e-16, -2.8088642523016460e-14,
	5.5511151231257827e-15}, /* L286 */
{2.8158099991321901e+00, 8.9719898177520463e-14,
	2.2204460492503131e-16, 2.5091040356528538e-14,
	9.5479180117763462e-15}, /* L287 */
{2.6523846769162907e+00, 8.4807161293554145e-14,
	2.2204460492503131e-16, 4.7739590058881731e-14,
	-1.7608137170554983e-13}, /* L288 */
{1.9169845968237798e+00, 6.1506355564233672e-14,
	2.2204460492503131e-16, 7.1942451995710144e-14,
	2.1538326677728037e-14}, /* L289 */
{2.6259025872590103e+00, 8.4543483325205671e-14,
	2.2204460492503131e-16, 9.1038288019262836e-15,
	1.3322676295501878e-14}, /* L290 */
{2.4605190660434584e+00, 7.9491968563161208e-14,
	2.2204460492503131e-16, -9.0816243414337805e-14,
	-1.0602629885170245e-13}, /* L291 */
{2.3493513195358955e+00, 7.6161299489285739e-14,
	2.2204460492503131e-16, 2.7755575615628914e-14,
	-8.3710816056736803e-14}, /* L292 */
{3.4693368091324741e+00, 1.1285417045314716e-13,
	2.2204460492503131e-16, -1.0991207943789050e-14,
	4.1966430330830917e-14}, /* L293 */
{2.5255491738981735e+00, 8.2434059578417873e-14,
	2.2204460492503131e-16, -1.1468603844377867e-13,
	2.5757174171303632e-13}, /* L294 */
{3.3985693898665876e+00, 1.1130679711257585e-13,
	2.2204460492503131e-16, 1.9517720772910252e-13,
	8.5997875487464626e-13}, /* L295 */
{2.5253768049952692e+00, 8.2989171090730451e-14,
	2.2204460492503131e-16, 7.9936057773011271e-15,
	5.9063864910058328e-14}, /* L296 */
{2.3350528654304981e+00, 7.6993966757754606e-14,
	2.2204460492503131e-16, 9.1482377229112899e-14,
	6.0618177144533547e-14}, /* L297 */
{2.3095993960500225e+00, 7.6411099669826399e-14,
	2.2204460492503131e-16, 2.8865798640254070e-14,
	-1.2023715356690445e-13}, /* L298 */
{2.0669215251912787e+00, 6.8611782921834674e-14,
	2.2204460492503131e-16, -1.0458300891968975e-13,
	1.2900791546144319e-13}, /* L299 */
{2.3400361073059397e+00, 7.7937656328685989e-14,
	2.2204460492503131e-16, 2.4669155607170978e-13,
	-3.1974423109204508e-13}, /* L300 */
{2.6943937345963627e+00, 9.0039087297100195e-14,
	2.2204460492503131e-16, 1.2501111257279263e-13,
	6.1284310959308641e-14}, /* L301 */
{3.0679281335515061e+00, 1.0286216323152075e-13,
	2.2204460492503131e-16, -1.7430501486614958e-13,
	1.6942003355779889e-13}, /* L302 */
{2.4290803855714351e+00, 8.1712414612411521e-14,
	2.2204460492503131e-16, -2.3425705819590803e-14,
	4.7073456244106637e-14}, /* L303 */
{2.5691185894716448e+00, 8.6708418223224726e-14,
	2.2204460492503131e-16, 3.1530333899354446e-14,
	-3.7414515929867775e-14}, /* L304 */
{2.8229943791384753e+00, 9.5590202420225978e-14,
	2.2204460492503131e-16, -6.2172489379008766e-15,
	1.4210854715202004e-14}, /* L305 */
{3.2320760154770487e+00, 1.0980105713542798e-13,
	2.2204460492503131e-16, 4.7339909770016675e-13,
	8.0424555903846340e-13}, /* L306 */
{1.9723431373000739e+00, 6.7224004141053229e-14,
	2.2204460492503131e-16, 5.7731597280508140e-14,
	-5.5511151231257827e-15}, /* L307 */
{3.2955053958770213e+00, 1.1268763699945339e-13,
	2.2204460492503131e-16, 3.7747582837255322e-14,
	6.6613381477509392e-14}, /* L308 */
{2.7346700283157066e+00, 9.3813845580825728e-14,
	2.2204460492503131e-16, -4.1078251911130792e-14,
	-4.6962433941644122e-14}, /* L309 */
{2.7766557476760005e+00, 9.5562446844610349e-14,
	2.2204460492503131e-16, 6.4392935428259079e-15,
	8.6819440525687241e-14}, /* L310 */
{2.7862166254175262e+00, 9.6200825083769814e-14,
	2.2204460492503131e-16, -6.4059868520871532e-14,
	-5.1070259132757201e-15}, /* L311 */
{3.2378304092011843e+00, 1.1215334216885253e-13,
	2.2204460492503131e-16, 1.7652546091539989e-13,
	-4.4408920985006262e-15}, /* L312 */
{2.1677650785174678e+00, 7.5328632220816871e-14,
	2.2204460492503131e-16, -7.1942451995710144e-14,
	-3.4416913763379853e-14}, /* L313 */
{3.1465453672185322e+00, 1.0969003483296547e-13,
	2.2204460492503131e-16, -2.8588242884097781e-13,
	-3.3117952824568420e-13}, /* L314 */
{2.3857510984137869e+00, 8.3433260300580514e-14,
	2.2204460492503131e-16, -7.2497563508022722e-14,
	-4.9960036108132044e-14}, /* L315 */
{3.0429662574816128e+00, 1.0675488271161271e-13,
	2.2204460492503131e-16, 8.2822637637036678e-14,
	-2.6090241078691179e-14}, /* L316 */
{2.6498831596128105e+00, 9.3258734068513149e-14,
	2.2204460492503131e-16, -8.5820239803524601e-14,
	1.2656542480726785e-14}, /* L317 */
{2.1368254245485918e+00, 7.5439654523279387e-14,
	2.2204460492503131e-16, 1.6653345369377348e-14,
	-2.4424906541753444e-14}, /* L318 */
{2.3954131373359160e+00, 8.4834916869169774e-14,
	2.2204460492503131e-16, -1.4099832412739488e-14,
	9.3258734068513149e-14}, /* L319 */
{2.8328562116367904e+00, 1.0064171718227044e-13,
	2.2204460492503131e-16, -4.7184478546569153e-14,
	-4.2965631052993558e-14}, /* L320 */
{2.2691160098776333e+00, 8.0865869556134840e-14,
	2.2204460492503131e-16, -1.9406698470447736e-13,
	8.8817841970012523e-14}, /* L321 */
{2.6071830865900192e+00, 9.3203222917281892e-14,
	2.2204460492503131e-16, -3.5305092183079978e-14,
	-1.1546319456101628e-13}, /* L322 */
{2.9597979923575788e+00, 1.0613732115416497e-13,
	2.2204460492503131e-16, -1.6275869541004795e-13,
	2.2204460492503131e-14}, /* L323 */
{2.7114615915716738e+00, 9.7533092713320002e-14,
	2.2204460492503131e-16, -3.1452618287630685e-13,
	-8.4598994476436928e-14}, /* L324 */
{3.0262005411386559e+00, 1.0919043447188415e-13,
	2.2204460492503131e-16, 4.2188474935755949e-15,
	-1.3433698597964394e-14}, /* L325 */
{2.6403781649677458e+00, 9.5562446844610349e-14,
	2.2204460492503131e-16, -6.1173288656846125e-14,
	8.1046280797636427e-14}, /* L326 */
{2.5000385761814878e+00, 9.0760732263106547e-14,
	2.2204460492503131e-16, 1.2878587085651816e-14,
	-2.4868995751603507e-14}, /* L327 */
{2.3811343024345368e+00, 8.6708418223224726e-14,
	2.2204460492503131e-16, 3.2818192607919627e-13,
	1.2407852523210749e-12}, /* L328 */
{2.9719303560569861e+00, 1.0855205623272468e-13,
	2.2204460492503131e-16, -2.3836488338702111e-13,
	2.5157653738006047e-13}, /* L329 */
{3.1045933591502362e+00, 1.1374234887284729e-13,
	2.2204460492503131e-16, -1.0114131754335176e-13,
	-4.0745185003743245e-14}, /* L330 */
{2.5831214291674045e+00, 9.4924068605450884e-14,
	2.2204460492503131e-16, -2.8532731732866523e-14,
	-5.5622173533720343e-14}, /* L331 */
{2.5734583837660527e+00, 9.4854679666411812e-14,
	2.2204460492503131e-16, 3.1752378504279477e-14,
	-3.2640556923979602e-14}, /* L332 */
{2.0706025204486238e+00, 7.6549877547904543e-14,
	2.2204460492503131e-16, -5.9374727356953372e-13,
	-1.5376588891058418e-12}, /* L333 */
{2.6946523575597614e+00, 9.9920072216264089e-14,
	2.2204460492503131e-16, 3.3772984409097262e-13,
	6.6835426082434424e-14}, /* L334 */
{3.4447243282785323e+00, 1.2811583391392212e-13,
	2.2204460492503131e-16, 6.9722005946459831e-14,
	1.5321077739827160e-14}, /* L335 */
{2.7664117340012329e+00, 1.0319523013890830e-13,
	2.2204460492503131e-16, 1.9761969838327786e-14,
	-4.6518344731794059e-14}, /* L336 */
{2.7926988783496549e+00, 1.0448586440503504e-13,
	2.2204460492503131e-16, -5.2513549064769904e-14,
	3.8857805861880479e-14}, /* L337 */
{3.5059712577234485e+00, 1.3156142841808105e-13,
	2.2204460492503131e-16, -7.7937656328685989e-14,
	-6.1062266354383610e-15}, /* L338 */
{2.7865474218586845e+00, 1.0487444246365385e-13,
	2.2204460492503131e-16, -7.7715611723760958e-15,
	-1.2800871473928055e-13}, /* L339 */
{3.1441661622755182e+00, 1.1868284133242923e-13,
	2.2204460492503131e-16, -3.9046543776066756e-13,
	-5.3890225615305098e-13}, /* L340 */
{2.8988717097436001e+00, 1.0974554598419672e-13,
	2.2204460492503131e-16, 5.2180482157382357e-14,
	6.7723604502134549e-14}, /* L341 */
{2.0939650589106340e+00, 7.9505846350969023e-14,
	2.2204460492503131e-16, 1.0302869668521453e-13,
	6.8833827526759706e-15}, /* L342 */
{2.9599582092910155e+00, 1.1271539257506902e-13,
	2.2204460492503131e-16, -4.7839510131097995e-13,
	-1.8662849043948881e-13}, /* L343 */
{3.1846421630322994e+00, 1.2162493234768590e-13,
	2.2204460492503131e-16, -1.1912693054227930e-13,
	5.1514348342607263e-14}, /* L344 */
{3.5884611679003666e+00, 1.3744561044859438e-13,
	2.2204460492503131e-16, 1.9984014443252818e-15,
	2.3980817331903381e-14}, /* L345 */
{2.4761942776235482e+00, 9.5118357634760287e-14,
	2.2204460492503131e-16, -3.3972824553529790e-14,
	-1.9539925233402755e-14}, /* L346 */
{3.6427075046615269e+00, 1.4033219031261979e-13,
	2.2204460492503131e-16, -5.9063864910058328e-14,
	-3.1752378504279477e-14}, /* L347 */
{2.3351653424946766e+00, 9.0219498538601783e-14,
	2.2204460492503131e-16, 1.7319479184152442e-14,
	5.4622972811557702e-14}, /* L348 */
{3.1060651192915576e+00, 1.2034817586936697e-13,
	2.2204460492503131e-16, 1.8429702208777599e-14,
	3.5527136788005009e-15}, /* L349 */
{3.8836313539154999e+00, 1.5090706462217440e-13,
	2.2204460492503131e-16, 6.0618177144533547e-14,
	-2.5202062658991053e-14}, /* L350 */
{2.8120092019283662e+00, 1.0957901253050295e-13,
	2.2204460492503131e-16, -4.9849013805669529e-14,
	8.8817841970012523e-15}, /* L351 */
{3.5341454417838407e+00, 1.3811174426336947e-13,
	2.2204460492503131e-16, 5.5511151231257827e-14,
	2.7533531010703882e-14}, /* L352 */
{2.4033656963940748e+00, 9.4188545851636718e-14,
	2.2204460492503131e-16, -2.8899105330992825e-13,
	-2.7433610938487618e-13}, /* L353 */
{3.2274509302690846e+00, 1.2684298056342413e-13,
	2.2204460492503131e-16, -7.4273920347422973e-14,
	-2.2337687255458150e-13}, /* L354 */
{2.8521566855039198e+00, 1.1241008124329710e-13,
	2.2204460492503131e-16, 4.0190073491430667e-14,
	1.1679546219056647e-13}, /* L355 */
{3.6638556914563796e+00, 1.4480777688063995e-13,
	2.2204460492503131e-16, -1.2334577803585489e-13,
	-8.7485574340462335e-14}, /* L356 */
{3.3431888410911332e+00, 1.3250511798901243e-13,
	2.2204460492503131e-16, 7.6383344094210770e-14,
	2.2870594307278225e-14}, /* L357 */
{2.4120483916577506e+00, 9.5867758176382267e-14,
	2.2204460492503131e-16, 1.0658141036401503e-14,
	-3.1086244689504383e-15}, /* L358 */
{2.8524117014049244e+00, 1.1368683772161603e-13,
	2.2204460492503131e-16, 3.3306690738754696e-14,
	-8.8817841970012523e-16}, /* L359 */
{3.4507476902917014e+00, 1.3791745523406007e-13,
	2.2204460492503131e-16, -9.6811447747313650e-14,
	1.1768364061026659e-14}, /* L360 */
{2.6371598055687859e+00, 1.0569323194431490e-13,
	2.2204460492503131e-16, -1.5432100042289676e-14,
	-4.0523140398818214e-14}, /* L361 */
{3.4070363420895400e+00, 1.3692692812927731e-13,
	2.2204460492503131e-16, -2.8532731732866523e-14,
	-1.3433698597964394e-14}, /* L362 */
{2.7769023523877987e+00, 1.1191048088221578e-13,
	2.2204460492503131e-16, -5.5400128928795311e-14,
	5.1514348342607263e-14}, /* L363 */
{2.6976721202175087e+00, 1.0901696212428647e-13,
	2.2204460492503131e-16, -3.0575542098176811e-13,
	2.9642954757491680e-13}, /* L364 */
{3.4781358602324226e+00, 1.4094281297616362e-13,
	2.2204460492503131e-16, -5.8508753397745750e-14,
	2.2737367544323206e-13}, /* L365 */
{2.8207402459961144e+00, 1.1461664950473960e-13,
	2.2204460492503131e-16, 4.8849813083506888e-15,
	5.3290705182007514e-15}, /* L366 */
{2.0916535281111921e+00, 8.5223494927788579e-14,
	2.2204460492503131e-16, 2.5979218776228663e-14,
	3.5083047578154947e-14}, /* L367 */
{2.1032933238739719e+00, 8.5931262105987116e-14,
	2.2204460492503131e-16, 2.9309887850104133e-14,
	-7.3163697322797816e-14}, /* L368 */
{2.7344595375261558e+00, 1.1202150318467829e-13,
	2.2204460492503131e-16, -3.4083846855992306e-14,
	-7.5606187976973160e-14}, /* L369 */
{2.6074726663480474e+00, 1.0710876630071198e-13,
	2.2204460492503131e-16, -2.0872192862952943e-14,
	0.0000000000000000e+00}, /* L370 */
{2.8100164050353245e+00, 1.1574075031717257e-13,
	2.2204460492503131e-16, 4.6851411639181606e-14,
	-1.3655743202889425e-14}, /* L371 */
{2.8863012567365454e+00, 1.1920325837522228e-13,
	2.2204460492503131e-16, -9.1038288019262836e-15,
	-2.1871393585115584e-14}, /* L372 */
{2.7936087896842063e+00, 1.1568523916594131e-13,
	2.2204460492503131e-16, -1.5065726444163374e-13,
	-2.9021229863701592e-13}, /* L373 */
{2.8516482796471734e+00, 1.1840528557627295e-13,
	2.2204460492503131e-16, 5.2204907063924111e-12,
	5.4363180623795415e-12}, /* L374 */
{3.6147224426809568e+00, 1.5049073098793997e-13,
	2.2204460492503131e-16, 5.5067062021407764e-14,
	-2.3103741142449508e-13}, /* L375 */
{3.0652068713280611e+00, 1.2795320358804929e-13,
	2.2204460492503131e-16, 8.0491169285323849e-13,
	-1.0191847366058937e-13}, /* L376 */
{2.7805468832700586e+00, 1.1637912855633203e-13,
	2.2204460492503131e-16, -9.2259533346350509e-14,
	-6.9277916736609768e-14}, /* L377 */
{3.1270323778277214e+00, 1.3122836151069350e-13,
	2.2204460492503131e-16, 5.4400928206632670e-14,
	-1.8429702208777599e-14}, /* L378 */
{2.4789300710531541e+00, 1.0430545316353346e-13,
	2.2204460492503131e-16, 1.6919798895287386e-13,
	7.3496764230185363e-14}, /* L379 */
{3.4263686591469731e+00, 1.4455103780619538e-13,
	2.2204460492503131e-16, -2.7644553313166398e-14,
	-2.4980018054066022e-14}, /* L380 */
{2.5559777595471700e+00, 1.0811490591677853e-13,
	2.2204460492503131e-16, -1.4765966227514582e-14,
	-4.0190073491430667e-14}, /* L381 */
{3.0929720294367438e+00, 1.3117285035946225e-13,
	2.2204460492503131e-16, 3.0198066269804258e-14,
	4.9293902293356950e-14}, /* L382 */
{3.0594391354041188e+00, 1.3009038291045272e-13,
	2.2204460492503131e-16, -8.7374552037999820e-14,
	-2.6867397195928788e-14}, /* L383 */
{3.1471762115440272e+00, 1.3417045252595017e-13,
	2.2204460492503131e-16, -2.9176661087149114e-13,
	1.4410694859634532e-13}, /* L384 */
{3.3714722737166531e+00, 1.4410694859634532e-13,
	2.2204460492503131e-16, -2.0650148258027912e-14,
	-9.6700425444851135e-14}, /* L385 */
{2.2720501765522236e+00, 9.7366559259626229e-14,
	2.2204460492503131e-16, 3.5527136788005009e-13,
	5.7553961596568115e-13}, /* L386 */
{2.7041694193839056e+00, 1.1618483952702263e-13,
	2.2204460492503131e-16, -6.1395333261771157e-14,
	-2.7311486405778851e-14}, /* L387 */
{2.3428138735867621e+00, 1.0091927293842673e-13,
	2.2204460492503131e-16, -6.0729199446996063e-14,
	5.3290705182007514e-14}, /* L388 */
{2.8155891959524748e+00, 1.2159717677207027e-13,
	2.2204460492503131e-16, -2.7089441800853820e-14,
	-6.1062266354383610e-15}, /* L389 */
{5.2707413982511087e+00, 2.2821328160560483e-13,
	2.2204460492503131e-16, -3.9523939676655573e-14,
	3.0642155479654321e-14}, /* L390 */
{3.1110537537560141e+00, 1.3504822260479443e-13,
	2.2204460492503131e-16, -2.2204460492503131e-14,
	9.0816243414337805e-14}, /* L391 */
{3.4356013734763642e+00, 1.4951798479878597e-13,
	2.2204460492503131e-16, -1.0769163338864018e-14,
	2.1516122217235534e-13}, /* L392 */
{3.1857919315618197e+00, 1.3899992268306960e-13,
	2.2204460492503131e-16, -3.2418512319054571e-14,
	-3.1419311596891930e-14}, /* L393 */
{2.9023218849441110e+00, 1.2695400286588665e-13,
	2.2204460492503131e-16, 1.4099832412739488e-13,
	-8.4710016778899444e-14}, /* L394 */
{3.4620701931082229e+00, 1.5182299861749016e-13,
	2.2204460492503131e-16, -1.6986412276764895e-14,
	-8.5487172896137054e-15}, /* L395 */
{2.5404369704987446e+00, 1.1168843627729075e-13,
	2.2204460492503131e-16, -3.9890313274781874e-13,
	2.1183055309847987e-13}, /* L396 */
{2.9446225521739193e+00, 1.2978507157868080e-13,
	2.2204460492503131e-16, -3.5860203695392556e-14,
	-6.9055872131684737e-14}, /* L397 */
{2.7324474793107654e+00, 1.2073675392798577e-13,
	2.2204460492503131e-16, -1.1468603844377867e-13,
	7.9491968563161208e-14}, /* L398 */
{3.1082796390534502e+00, 1.3768847173523113e-13,
	2.2204460492503131e-16, 7.7271522513910895e-14,
	1.7208456881689926e-13}, /* L399 */
{3.1037902324932563e+00, 1.3783418850721318e-13,
	2.2204460492503131e-16, 7.3274719625260332e-15,
	1.0658141036401503e-14}, /* L400 */
{3.0424334521268257e+00, 1.3544720900426910e-13,
	2.2204460492503131e-16, -3.1419311596891930e-14,
	1.2878587085651816e-14}, /* L401 */
{3.1878522674110688e+00, 1.4227508060571381e-13,
	2.2204460492503131e-16, 2.5535129566378600e-14,
	8.8817841970012523e-15}, /* L402 */
{3.7556189493457066e+00, 1.6803225477701744e-13,
	2.2204460492503131e-16, -3.9523939676655573e-14,
	-1.1635137298071641e-13}, /* L403 */
{2.7840612091019641e+00, 1.2487233469471448e-13,
	2.2204460492503131e-16, -1.6764367671839864e-14,
	1.3833378886829450e-13}, /* L404 */
{2.5827406847331718e+00, 1.1612932837579137e-13,
	2.2204460492503131e-16, -5.0293103015519591e-14,
	-8.4376949871511897e-15}, /* L405 */
{3.1822963640366568e+00, 1.4344081478157023e-13,
	2.2204460492503131e-16, -9.0150109599562711e-14,
	2.2870594307278225e-14}, /* L406 */
{2.9373744553543091e+00, 1.3272716259393746e-13,
	2.2204460492503131e-16, 1.1834977442504169e-13,
	5.2402526762307389e-14}, /* L407 */
{3.5331219358110206e+00, 1.6003864899971632e-13,
	2.2204460492503131e-16, 1.1324274851176597e-14,
	-3.5527136788005009e-14}, /* L408 */
{2.8019827168002664e+00, 1.2723155862204294e-13,
	2.2204460492503131e-16, 1.9539925233402755e-14,
	7.1054273576010019e-14}, /* L409 */
{3.1399689748354178e+00, 1.4292733663268109e-13,
	2.2204460492503131e-16, -1.3478107518949400e-13,
	1.1324274851176597e-13}, /* L410 */
{4.0280189563495084e+00, 1.8379742172669467e-13,
	2.2204460492503131e-16, 3.7969627442180354e-14,
	-2.9309887850104133e-14}, /* L411 */
{3.2342541507519655e+00, 1.4793721803130211e-13,
	2.2204460492503131e-16, -8.3155704544424225e-14,
	8.6153306710912148e-14}, /* L412 */
{2.9691566504589075e+00, 1.3614109839465982e-13,
	2.2204460492503131e-16, 1.3322676295501878e-14,
	1.7541523789077473e-14}, /* L413 */
{3.1461652752491771e+00, 1.4460654895742664e-13,
	2.2204460492503131e-16, -1.9217960556261460e-13,
	-1.1024514634527804e-13}, /* L414 */
{3.1144875387178690e+00, 1.4349632593280148e-13,
	2.2204460492503131e-16, -3.8635761256955448e-14,
	9.6589403142388619e-14}, /* L415 */
{2.7470213946415964e+00, 1.2687073613903976e-13,
	2.2204460492503131e-16, -6.2394533983933798e-14,
	-2.5424107263916085e-14}, /* L416 */
{2.9346802704870956e+00, 1.3586354263850353e-13,
	2.2204460492503131e-16, -1.2390088954816747e-13,
	-1.3511414209688155e-13}, /* L417 */
{3.1985951029465016e+00, 1.4843681839238343e-13,
	2.2204460492503131e-16, 3.9346303992715548e-13,
	4.2632564145606011e-14}, /* L418 */
{4.7685419045607631e+00, 2.2182256032010628e-13,
	2.2204460492503131e-16, -1.3322676295501878e-15,
	-1.5210055437364645e-14}, /* L419 */
{4.1205750181967931e+00, 1.9213797219919115e-13,
	2.2204460492503131e-16, 6.1728400169158704e-14,
	4.0190073491430667e-14}, /* L420 */
{2.9436147758682765e+00, 1.3758438832667252e-13,
	2.2204460492503131e-16, -4.5741188614556449e-14,
	-1.8096635301390052e-14}, /* L421 */
{4.1813195041718201e+00, 1.9589885269510887e-13,
	2.2204460492503131e-16, 1.3322676295501878e-13,
	-9.4924068605450884e-14}, /* L422 */
{3.1111407865801382e+00, 1.4610535004067060e-13,
	2.2204460492503131e-16, -1.9206858326015208e-13,
	3.9079850466805510e-14}, /* L423 */
{3.1321053471373599e+00, 1.4743761767022079e-13,
	2.2204460492503131e-16, -2.0161650127192843e-13,
	-1.0125233984581428e-13}, /* L424 */
{3.3941500219990770e+00, 1.6014967130217883e-13,
	2.2204460492503131e-16, -3.6637359812630166e-15,
	-2.2204460492503131e-15}, /* L425 */
{2.9882914144749360e+00, 1.4133139103478243e-13,
	2.2204460492503131e-16, -1.7208456881689926e-14,
	-1.5765166949677223e-14}, /* L426 */
{2.9859769593525933e+00, 1.4155343563970746e-13,
	2.2204460492503131e-16, 1.3100631690576847e-14,
	-8.3932860661661834e-14}, /* L427 */
{3.7219981189256077e+00, 1.7685852782278744e-13,
	2.2204460492503131e-16, 5.3290705182007514e-15,
	-1.6397994073713562e-13}, /* L428 */
{3.4335991847722838e+00, 1.6353585152728556e-13,
	2.2204460492503131e-16, -9.7188923575686204e-13,
	-1.4088730182493236e-13}, /* L429 */
{3.1325880195781148e+00, 1.4954704141700859e-13,
	2.2204460492503131e-16, -2.2648549702353193e-14,
	7.9047879353311146e-14}, /* L430 */
{4.7506253599854524e+00, 2.2731816429200080e-13,
	2.2204460492503131e-16, 2.7375879341207110e-12,
	2.7580160377738139e-12}, /* L431 */
{3.4016528168757301e+00, 1.6314727346866675e-13,
	2.2204460492503131e-16, 4.0190073491430667e-14,
	-1.1435297153639112e-14}, /* L432 */
{3.5646991287298322e+00, 1.7136292385089291e-13,
	2.2204460492503131e-16, 3.5571545708990016e-13,
	-2.4280577548552174e-13}, /* L433 */
{3.4965771307382760e+00, 1.6847634398686751e-13,
	2.2204460492503131e-16, -3.6859404417555197e-14,
	-1.6875389974302379e-14}, /* L434 */
{3.2655483896583037e+00, 1.5770718064800349e-13,
	2.2204460492503131e-16, 1.0502709812953981e-13,
	-5.8286708792820718e-14}, /* L435 */
{3.7787057677774731e+00, 1.8290924330699454e-13,
	2.2204460492503131e-16, -1.4244161405940758e-13,
	-1.6431300764452317e-14}, /* L436 */
{3.3089560474476141e+00, 1.6053824936079764e-13,
	2.2204460492503131e-16, 4.5741188614556449e-14,
	1.1990408665951691e-14}, /* L437 */
{4.9405437004839232e+00, 2.4024532363497997e-13,
	2.2204460492503131e-16, 3.2440716779547074e-13,
	1.1857181902996672e-13}, /* L438 */
{4.6424133019418701e+00, 2.2626345241860690e-13,
	2.2204460492503131e-16, 1.9984014443252818e-15,
	2.6645352591003757e-14}, /* L439 */
{3.5079880062308026e+00, 1.7136292385089291e-13,
	2.2204460492503131e-16, 3.4261482539932331e-13,
	-6.2172489379008766e-15}, /* L440 */
{3.3866536186288458e+00, 1.6581180872776713e-13,
	2.2204460492503131e-16, -5.6177285046032921e-14,
	1.0813572259849025e-13}, /* L441 */
{3.5011646174138167e+00, 1.7180701306074297e-13,
	2.2204460492503131e-16, -2.8754776337791554e-14,
	1.7541523789077473e-14}, /* L442 */
{4.1208068004785252e+00, 2.0267121314532233e-13,
	2.2204460492503131e-16, 2.9309887850104133e-14,
	-5.1847415249994810e-14}, /* L443 */
{2.9069815569300879e+00, 1.4329509800958817e-13,
	2.2204460492503131e-16, -3.6082248300317588e-14,
	1.3788969965844444e-13}, /* L444 */
{3.2306487929196930e+00, 1.5960843757767407e-13,
	2.2204460492503131e-16, 1.1102230246251565e-14,
	-5.8952842607595812e-14}, /* L445 */
{3.9905089152995954e+00, 1.9759194280766224e-13,
	2.2204460492503131e-16, -1.3988810110276972e-14,
	-8.4821039081361960e-14}, /* L446 */
{2.9905206949624068e+00, 1.4840906281676780e-13,
	2.2204460492503131e-16, 3.4150460237469815e-13,
	-3.7725378376762819e-13}, /* L447 */
{3.0669935400880073e+00, 1.5254464358349651e-13,
	2.2204460492503131e-16, -2.0095036745715333e-14,
	2.5535129566378600e-14}, /* L448 */
{3.5106125504006176e+00, 1.7499890425654030e-13,
	2.2204460492503131e-16, 7.7715611723760958e-14,
	1.2145839889399213e-13}, /* L449 */
{3.1144741517098504e+00, 1.5559775690121569e-13,
	2.2204460492503131e-16, 4.2410519540680980e-14,
	7.6605388699135801e-14}, /* L450 */
{3.1352848946810261e+00, 1.5698553568199713e-13,
	2.2204460492503131e-16, -6.7945649107059580e-14,
	8.8817841970012523e-16}, /* L451 */
{3.2686982137223382e+00, 1.6402851299446297e-13,
	2.2204460492503131e-16, -6.3171690101171407e-14,
	7.3496764230185363e-14}, /* L452 */
{3.3984871624467381e+00, 1.7091883464104285e-13,
	2.2204460492503131e-16, 3.7525538232330291e-14,
	-1.3655743202889425e-14}, /* L453 */
{2.9780019738138681e+00, 1.5010215292932116e-13,
	2.2204460492503131e-16, 1.6875389974302379e-14,
	-4.1633363423443370e-14}, /* L454 */
{2.8725548722572074e+00, 1.4510614931850796e-13,
	2.2204460492503131e-16, 1.8651746813702630e-14,
	-8.2711615334574162e-14}, /* L455 */
{2.9528790430907952e+00, 1.4949153026577733e-13,
	2.2204460492503131e-16, -7.2719608112947753e-14,
	-5.9396931817445875e-14}, /* L456 */
{3.6641487358686016e+00, 1.8590684547348246e-13,
	2.2204460492503131e-16, 5.1070259132757201e-14,
	4.1522341120980855e-14}, /* L457 */
{3.5275991500191326e+00, 1.7937040741600185e-13,
	2.2204460492503131e-16, -1.3178347302300608e-13,
	-1.4221956945448255e-13}, /* L458 */
{3.7015603616257113e+00, 1.8862689188381410e-13,
	2.2204460492503131e-16, -2.5646151868841116e-14,
	5.8397731095283234e-14}, /* L459 */
{4.4978689896627992e+00, 2.2970514379494489e-13,
	2.2204460492503131e-16, -3.0420110874729289e-13,
	5.8086868648388190e-13}, /* L460 */
{3.0857127301056124e+00, 1.5792922525292852e-13,
	2.2204460492503131e-16, 4.2188474935755949e-14,
	2.7311486405778851e-14}, /* L461 */
{3.1731904404857927e+00, 1.6275869541004795e-13,
	2.2204460492503131e-16, -8.1823436914874037e-14,
	-2.4646951146678475e-13}, /* L462 */
{4.1874049521625407e+00, 2.1524448889920222e-13,
	2.2204460492503131e-16, 8.4821039081361960e-14,
	8.6597395920762210e-15}, /* L463 */
{2.6984362992440358e+00, 1.3900686157697351e-13,
	2.2204460492503131e-16, -9.1393559387142886e-13,
	-8.1934459217336553e-13}, /* L464 */
{3.2739559596580055e+00, 1.6901757771137227e-13,
	2.2204460492503131e-16, 6.8833827526759706e-15,
	1.4654943925052066e-14}, /* L465 */
{3.2487903768459687e+00, 1.6807909231086882e-13,
	2.2204460492503131e-16, 8.6597395920762210e-15,
	2.4202861936828413e-14}, /* L466 */
{4.3734357200933989e+00, 2.2674917499188041e-13,
	2.2204460492503131e-16, 8.4821039081361960e-14,
	-5.7065463465733046e-14}, /* L467 */
{4.0983296900140092e+00, 2.1294077612310502e-13,
	2.2204460492503131e-16, -1.8496315590255108e-13,
	1.6742163211347361e-13}, /* L468 */
{3.8699729476698028e+00, 2.0150547896946591e-13,
	2.2204460492503131e-16, 1.1080025785759062e-13,
	3.0864200084579352e-14}, /* L469 */
{2.8485644049395891e+00, 1.4863804631559674e-13,
	2.2204460492503131e-16, -4.9182879990894435e-14,
	1.4765966227514582e-13}, /* L470 */
{5.1231911178213458e+00, 2.6789681584205027e-13,
	2.2204460492503131e-16, 1.7112977701572163e-12,
	-7.4551476103579262e-13}, /* L471 */
{3.3652333703068122e+00, 1.7634504967389830e-13,
	2.2204460492503131e-16, -2.0983215165415459e-14,
	-9.9920072216264089e-16}, /* L472 */
{3.8515166529392406e+00, 2.0225487951108789e-13,
	2.2204460492503131e-16, -4.6906922790412864e-13,
	2.8044233602031454e-13}, /* L473 */
{3.6044647607645821e+00, 1.8968160375720799e-13,
	2.2204460492503131e-16, 6.4614980033184111e-14,
	2.7755575615628914e-14}, /* L474 */
{3.4518750308105548e+00, 1.8203494267510223e-13,
	2.2204460492503131e-16, -1.1601830607332886e-13,
	-1.0846878950587779e-13}, /* L475 */
{3.2379510530979623e+00, 1.7111312367035225e-13,
	2.2204460492503131e-16, 7.8581585682968580e-13,
	-1.4657164371101317e-12}, /* L476 */
{3.2719127603488558e+00, 1.7327111967446740e-13,
	2.2204460492503131e-16, 1.8651746813702630e-14,
	5.1070259132757201e-14}, /* L477 */
{3.2267567196899516e+00, 1.7123802376062258e-13,
	2.2204460492503131e-16, -1.9539925233402755e-14,
	-1.6209256159527285e-14}, /* L478 */
{3.3956482556193550e+00, 1.8057777495528171e-13,
	2.2204460492503131e-16, -6.3948846218409017e-14,
	-5.4733995114020217e-14}, /* L479 */
{3.2906563877714197e+00, 1.7535972673954348e-13,
	2.2204460492503131e-16, -2.6090241078691179e-14,
	4.2188474935755949e-14}, /* L480 */
{3.8815339053249240e+00, 2.0727863869751673e-13,
	2.2204460492503131e-16, 1.7741363933510002e-13,
	-2.0228263508670352e-13}, /* L481 */
{4.0934000405518303e+00, 2.1904700275854339e-13,
	2.2204460492503131e-16, -1.8862689188381410e-13,
	-2.3303581286882036e-13}, /* L482 */
{3.3124021956069130e+00, 1.7762180615221723e-13,
	2.2204460492503131e-16, -3.2862601528904634e-14,
	-1.1879386363489175e-14}, /* L483 */
{4.2218894438472043e+00, 2.2686019729434292e-13,
	2.2204460492503131e-16, -9.9698027611339057e-14,
	-6.6280314570121845e-14}, /* L484 */
{3.7526131137104168e+00, 2.0206059048177849e-13,
	2.2204460492503131e-16, -4.5519144009631418e-15,
	5.2180482157382357e-14}, /* L485 */
{5.4336938043416456e+00, 2.9318214522788821e-13,
	2.2204460492503131e-16, -1.9650947535865271e-14,
	4.6629367034256575e-15}, /* L486 */
{3.7556826406506372e+00, 2.0305979120394113e-13,
	2.2204460492503131e-16, 4.1744385725905886e-14,
	2.5979218776228663e-14}, /* L487 */
{3.5481895819436158e+00, 1.9223511671384585e-13,
	2.2204460492503131e-16, 2.0228263508670352e-13,
	-2.6578739209526248e-13}, /* L488 */
{4.5680394820489401e+00, 2.4799606812564434e-13,
	2.2204460492503131e-16, 1.9118040484045196e-13,
	2.8688162956314045e-13}, /* L489 */
{3.0081919588019024e+00, 1.6364687382974807e-13,
	2.2204460492503131e-16, 3.2684965844964609e-13,
	3.7725378376762819e-13}, /* L490 */
{3.1665271487801463e+00, 1.7261192475359621e-13,
	2.2204460492503131e-16, 1.9317880628477724e-14,
	-4.3187675657918589e-14}, /* L491 */
{3.5584689016346811e+00, 1.9437229603624928e-13,
	2.2204460492503131e-16, 5.7531757136075612e-13,
	-2.8688162956314045e-13}, /* L492 */
{2.8009109709215947e+00, 1.5330358510423636e-13,
	2.2204460492503131e-16, -5.4067861299245124e-14,
	4.6851411639181606e-14}, /* L493 */
{3.9150171002892113e+00, 2.1471713296250527e-13,
	2.2204460492503131e-16, -2.0194956817931597e-13,
	1.4566126083082054e-13}, /* L494 */
{3.2209271873081864e+00, 1.7700771404172144e-13,
	2.2204460492503131e-16, 9.0594198809412774e-14,
	-6.5725203057809267e-14}, /* L495 */
{3.7994314019880351e+00, 2.0922152899061075e-13,
	2.2204460492503131e-16, 1.1990408665951691e-14,
	3.5305092183079978e-14}, /* L496 */
{4.1479268887490894e+00, 2.2887247652647602e-13,
	2.2204460492503131e-16, -7.0832228971084987e-14,
	1.3322676295501878e-15}, /* L497 */
{4.9528584875869806e+00, 2.7383650902379486e-13,
	2.2204460492503131e-16, -1.1468603844377867e-13,
	1.7097434579227411e-14}, /* L498 */
{4.0170723847892811e+00, 2.2254420528611263e-13,
	2.2204460492503131e-16, 1.1768364061026659e-14,
	1.6431300764452317e-14}, /* L499 */
{3.6490348061458717e+00, 2.0256019084285981e-13,
	2.2204460492503131e-16, -1.2634338020234281e-13,
	9.2814644858663087e-14}, /* L500 */
{3.3273770474102928e+00, 1.8507417820501360e-13,
	2.2204460492503131e-16, -1.8129941992128806e-13,
	1.0369483049998962e-13}, /* L501 */
{3.5747352926596978e+00, 1.9922952176898434e-13,
	2.2204460492503131e-16, 5.6399329650957952e-14,
	3.8924419243357988e-13}, /* L502 */
{4.7893100961193813e+00, 2.6745272663220021e-13,
	2.2204460492503131e-16, -7.4329431498654230e-13,
	-2.6645352591003757e-14}, /* L503 */
{3.1032042029420688e+00, 1.7363888105137448e-13,
	2.2204460492503131e-16, 2.8865798640254070e-15,
	1.9984014443252818e-14}, /* L504 */
{4.1059797587543878e+00, 2.3020474415602621e-13,
	2.2204460492503131e-16, 6.6613381477509392e-15,
	7.2164496600635175e-14}, /* L505 */
{3.6270108806561168e+00, 2.0375368059433185e-13,
	2.2204460492503131e-16, -4.6307402357115279e-13,
	-2.5202062658991053e-14}, /* L506 */
{4.1911149274393784e+00, 2.3590851494503795e-13,
	2.2204460492503131e-16, 6.2727600891321345e-13,
	2.9332092310596636e-13}, /* L507 */
{4.3248444019275958e+00, 2.4391599851014689e-13,
	2.2204460492503131e-16, 1.1368683772161603e-13,
	-4.7928327973068008e-13}, /* L508 */
{4.2662489448867884e+00, 2.4108492979735274e-13,
	2.2204460492503131e-16, 9.3258734068513149e-14,
	-1.7730261703263750e-13}, /* L509 */
{3.9372924576381125e+00, 2.2293278334473143e-13,
	2.2204460492503131e-16, 2.5313084961453569e-13,
	1.9095836023552692e-14}, /* L510 */
{3.5445543575103229e+00, 2.0108914533523148e-13,
	2.2204460492503131e-16, -1.8762769116165146e-14,
	3.0864200084579352e-14}, /* L511 */
{3.4482750787088032e+00, 1.9600987499757139e-13,
	2.2204460492503131e-16, -1.0569323194431490e-13,
	3.0486724256206799e-13}, /* L512 */
{4.0295218662033907e+00, 2.2949697697782767e-13,
	2.2204460492503131e-16, 1.0236256287043943e-13,
	-6.6280314570121845e-14}, /* L513 */
{5.3633780065780829e+00, 3.0606073231354003e-13,
	2.2204460492503131e-16, 8.6597395920762210e-15,
	-6.5281113847959205e-14}, /* L514 */
{4.3903331391219869e+00, 2.5102142586774789e-13,
	2.2204460492503131e-16, 2.5091040356528538e-14,
	-2.2204460492503131e-14}, /* L515 */
{4.7948616270350248e+00, 2.7468305408007154e-13,
	2.2204460492503131e-16, -5.1958437552457326e-14,
	-2.2204460492503131e-16}, /* L516 */
{4.7214774684487626e+00, 2.7100544031100071e-13,
	2.2204460492503131e-16, 6.8833827526759706e-15,
	6.7057470687359455e-14}, /* L517 */
{3.6164391033646619e+00, 2.0797946698181136e-13,
	2.2204460492503131e-16, 2.1960211427085596e-13,
	1.1546319456101628e-14}, /* L518 */
{3.7957670676072151e+00, 2.1871393585115584e-13,
	2.2204460492503131e-16, 3.5971225997855072e-14,
	1.3544720900426910e-14}, /* L519 */
{4.2031316313108409e+00, 2.4265311981963578e-13,
	2.2204460492503131e-16, 2.1094237467877974e-14,
	1.0014211682118912e-13}, /* L520 */
{4.6353240118240606e+00, 2.6811886044697530e-13,
	2.2204460492503131e-16, -6.3116178949940149e-13,
	2.4247270857813419e-13}, /* L521 */
{3.1321888497193999e+00, 1.8152146452621309e-13,
	2.2204460492503131e-16, -3.2096547641913276e-13,
	-2.6745272663220021e-13}, /* L522 */
{3.7103309016163597e+00, 2.1543877792851163e-13,
	2.2204460492503131e-16, 2.1183055309847987e-13,
	3.1952218648712005e-13}, /* L523 */
{4.2576403050934264e+00, 2.4769075679387242e-13,
	2.2204460492503131e-16, 2.5801583092288638e-13,
	-1.1635137298071641e-13}, /* L524 */
{4.0990540861510167e+00, 2.3891999489933369e-13,
	2.2204460492503131e-16, -2.9420910152566648e-13,
	-2.6245672302138701e-13}, /* L525 */
{3.0855561989014482e+00, 1.8018919689666291e-13,
	2.2204460492503131e-16, -6.5947247662734299e-14,
	-1.7430501486614958e-14}, /* L526 */
{3.4114143006087718e+00, 1.9959728314589142e-13,
	2.2204460492503131e-16, -6.3515859238805206e-13,
	-3.7814196218732832e-13}, /* L527 */
{2.6875042400933435e+00, 1.5754064719430971e-13,
	2.2204460492503131e-16, -1.3000711618360583e-13,
	-1.3233858453531866e-13}, /* L528 */
{3.8490136340529224e+00, 2.2605528560148969e-13,
	2.2204460492503131e-16, 1.7763568394002505e-14,
	1.6764367671839864e-13}, /* L529 */
{4.0792517188821025e+00, 2.4003021792395884e-13,
	2.2204460492503131e-16, 1.6742163211347361e-13,
	3.6037839379332581e-13}, /* L530 */
{4.9030209181907445e+00, 2.8904656446115951e-13,
	2.2204460492503131e-16, 2.0934365352331952e-12,
	1.5420997812043424e-12}, /* L531 */
{4.4924882908376471e+00, 2.6534330288541241e-13,
	2.2204460492503131e-16, 2.8865798640254070e-14,
	-2.1316282072803006e-14}, /* L532 */
{3.9348092098497522e+00, 2.3284152383951096e-13,
	2.2204460492503131e-16, -4.3076653355456074e-13,
	-1.0158540675320182e-13}, /* L533 */
{5.1854014394723213e+00, 3.0742075551870585e-13,
	2.2204460492503131e-16, 4.4630965589931293e-14,
	-9.7255536957163713e-14}, /* L534 */
{5.1682324530193897e+00, 3.0697666630885578e-13,
	2.2204460492503131e-16, 3.0420110874729289e-13,
	5.8175686490358203e-14}, /* L535 */
{3.3936620706212892e+00, 2.0194956817931597e-13,
	2.2204460492503131e-16, 5.3290705182007514e-15,
	-2.0095036745715333e-14}, /* L536 */
{4.5987037172271430e+00, 2.7416957593118241e-13,
	2.2204460492503131e-16, -4.0101255649460654e-13,
	5.1780801868517301e-13}, /* L537 */
{3.3894105519583237e+00, 2.0244916854039730e-13,
	2.2204460492503131e-16, 1.5543122344752192e-15,
	-6.8167693711984612e-14}, /* L538 */
{3.8534383616006620e+00, 2.3059332221464501e-13,
	2.2204460492503131e-16, 2.8865798640254070e-14,
	-4.0079051188968151e-14}, /* L539 */
{2.8611156251133827e+00, 1.7152945730458669e-13,
	2.2204460492503131e-16, 7.2164496600635175e-14,
	2.8643754035329039e-14}, /* L540 */
{3.6001674175331910e+00, 2.1623675072746096e-13,
	2.2204460492503131e-16, -1.4988010832439613e-14,
	8.8817841970012523e-16}, /* L541 */
{4.2396284601093761e+00, 2.5511537327105316e-13,
	2.2204460492503131e-16, -1.9984014443252818e-14,
	-2.0317081350640365e-14}, /* L542 */
{4.5414436291452542e+00, 2.7378099787256360e-13,
	2.2204460492503131e-16, 7.9403150721191196e-13,
	-8.6741724913963481e-13}, /* L543 */
{4.6378749642641965e+00, 2.8010926911292700e-13,
	2.2204460492503131e-16, 5.8997251528580819e-13,
	-3.4339198151656092e-13}, /* L544 */
{3.4000053642130124e+00, 2.0572432646304151e-13,
	2.2204460492503131e-16, 1.3544720900426910e-14,
	4.7961634663806763e-14}, /* L545 */
{4.5547519204972300e+00, 2.7610032315994459e-13,
	2.2204460492503131e-16, 1.3100631690576847e-14,
	4.1078251911130792e-14}, /* L546 */
{3.9186533488457549e+00, 2.3797630532840230e-13,
	2.2204460492503131e-16, 4.3076653355456074e-13,
	1.1013412404281553e-13}, /* L547 */
{3.7408818144226443e+00, 2.2759572004815709e-13,
	2.2204460492503131e-16, -1.2267964422107980e-13,
	3.4283687000424834e-13}, /* L548 */
{4.2714092891225537e+00, 2.6034729927459921e-13,
	2.2204460492503131e-16, 1.5587531265737198e-13,
	-1.9650947535865271e-13}, /* L549 */
{3.7254604231398849e+00, 2.2748469774569458e-13,
	2.2204460492503131e-16, 8.6819440525687241e-14,
	1.2234657731369225e-13}, /* L550 */
{3.7477373102907725e+00, 2.2926105458509483e-13,
	2.2204460492503131e-16, -7.5606187976973160e-14,
	4.9737991503207013e-14}, /* L551 */
{4.2056225772699012e+00, 2.5773827516673009e-13,
	2.2204460492503131e-16, -4.9849013805669529e-14,
	5.9952043329758453e-14}, /* L552 */
{4.2109017610969071e+00, 2.5852930907177551e-13,
	2.2204460492503131e-16, -4.4897419115841330e-13,
	-5.0937032369802182e-13}, /* L553 */
{4.5859729392923407e+00, 2.8206603719382883e-13,
	2.2204460492503131e-16, -8.8817841970012523e-16,
	-5.9618976422370906e-14}, /* L554 */
{4.9828907444255996e+00, 3.0703217746008704e-13,
	2.2204460492503131e-16, -6.5170091545496689e-14,
	-6.2616578588858829e-14}, /* L555 */
{4.3682622875204240e+00, 2.6964541710583489e-13,
	2.2204460492503131e-16, 4.7073456244106637e-14,
	-6.9722005946459831e-14}, /* L556 */
{3.8451586697605085e+00, 2.3778201629909290e-13,
	2.2204460492503131e-16, 3.0930813466056861e-13,
	-4.5152770411505116e-13}, /* L557 */
{4.6998282034770931e+00, 2.9115598820794730e-13,
	2.2204460492503131e-16, 2.6489921367556235e-13,
	-2.7267077484793845e-13}, /* L558 */
{4.3085935597741667e+00, 2.6739721548096895e-13,
	2.2204460492503131e-16, 5.0404125317982107e-14,
	-3.6748382115092681e-14}, /* L559 */
{3.5267912785288869e+00, 2.1926904736346842e-13,
	2.2204460492503131e-16, -2.1027624086400465e-13,
	-2.7866597918091429e-14}, /* L560 */
{4.6479574222408822e+00, 2.8949065367100957e-13,
	2.2204460492503131e-16, 9.3702823278363212e-14,
	-1.5687451337953462e-13}, /* L561 */
{3.6961802087141127e+00, 2.3062107779026064e-13,
	2.2204460492503131e-16, -9.8365759981788869e-14,
	1.6808776592824870e-13}, /* L562 */
{4.1749621818932114e+00, 2.6095792193814304e-13,
	2.2204460492503131e-16, 2.3314683517128287e-14,
	-8.8817841970012523e-15}, /* L563 */
{4.5077365001846319e+00, 2.8225859149966226e-13,
	2.2204460492503131e-16, -1.2645440250480533e-13,
	-1.5198953207118393e-13}, /* L564 */
{5.9814253661344789e+00, 3.7519987117207165e-13,
	2.2204460492503131e-16, -1.9162449405030202e-13,
	-3.4550140526334872e-13}, /* L565 */
{3.6025896060697105e+00, 2.2638141361497333e-13,
	2.2204460492503131e-16, -1.5420997812043424e-13,
	-6.6624483707755644e-13}, /* L566 */
{4.1922464730435296e+00, 2.6390001295339971e-13,
	2.2204460492503131e-16, 1.3322676295501878e-15,
	3.5083047578154947e-14}, /* L567 */
{3.3292306046620355e+00, 2.0994317395661710e-13,
	2.2204460492503131e-16, 1.2767564783189300e-13,
	1.7719159473017498e-13}, /* L568 */
{4.7407807660296557e+00, 2.9948266089263598e-13,
	2.2204460492503131e-16, -1.6431300764452317e-13,
	7.7271522513910895e-14}, /* L569 */
{3.9631641474479795e+00, 2.5079938126282286e-13,
	2.2204460492503131e-16, -2.0428103653102880e-13,
	-3.2196467714129540e-15}, /* L570 */
{4.2070994571847882e+00, 2.6670332609057823e-13,
	2.2204460492503131e-16, -1.8329782136561334e-13,
	-1.7019718967503650e-13}, /* L571 */
{4.3138179947530322e+00, 2.7394753132625738e-13,
	2.2204460492503131e-16, 1.3322676295501878e-14,
	5.2846615972157451e-14}, /* L572 */
{3.3616981484431459e+00, 2.1385671011842078e-13,
	2.2204460492503131e-16, 1.2305712004945235e-12,
	2.5091040356528538e-13}, /* L573 */
{3.6642043873055727e+00, 2.3350765765428605e-13,
	2.2204460492503131e-16, -6.6058269965196814e-14,
	-4.4653170050423796e-13}, /* L574 */
{3.0108743154955673e+00, 1.9220736113823023e-13,
	2.2204460492503131e-16, 8.1712414612411521e-14,
	2.5979218776228663e-14}, /* L575 */
{4.9314313914632564e+00, 3.1535885014477572e-13,
	2.2204460492503131e-16, -2.9420910152566648e-14,
	-6.5503158452884236e-15}, /* L576 */
{3.5476659091354010e+00, 2.2726265314076954e-13,
	2.2204460492503131e-16, -1.3267165144270621e-13,
	-2.2271073873980640e-13}, /* L577 */
{4.5527753489953691e+00, 2.9215518893010994e-13,
	2.2204460492503131e-16, 2.6265656316581953e-12,
	1.4621637234313312e-12}, /* L578 */
{4.9948265332223292e+00, 3.2107649872159527e-13,
	2.2204460492503131e-16, -3.2196467714129540e-14,
	-1.1179945857975326e-13}, /* L579 */
{3.4931089593791089e+00, 2.2493118478905672e-13,
	2.2204460492503131e-16, 1.2168044349891716e-13,
	-1.8984813721090177e-14}, /* L580 */
{4.5356676550899948e+00, 2.9256805311739242e-13,
	2.2204460492503131e-16, 2.2870594307278225e-13,
	-3.7303493627405260e-13}, /* L581 */
{4.7491483862364792e+00, 3.0686564400639327e-13,
	2.2204460492503131e-16, -4.9626969200744497e-14,
	-4.4408920985006262e-16}, /* L582 */
{3.8937936647021116e+00, 2.5202930020729042e-13,
	2.2204460492503131e-16, -6.2561067437627571e-13,
	-4.5219383792982626e-13}, /* L583 */
{4.4422159126112470e+00, 2.8801960816338124e-13,
	2.2204460492503131e-16, 7.9625195326116227e-13,
	1.3131717935266352e-12}, /* L584 */
{4.2555622695859086e+00, 2.7639002198043272e-13,
	2.2204460492503131e-16, -6.6058269965196814e-14,
	9.7699626167013776e-14}, /* L585 */
{4.1894264049095300e+00, 2.7255975254547593e-13,
	2.2204460492503131e-16, 1.5898393712632242e-13,
	-2.1316282072803006e-14}, /* L586 */
{4.4531586441777051e+00, 2.9021229863701592e-13,
	2.2204460492503131e-16, -7.8381745538536052e-14,
	7.0388139761234925e-14}, /* L587 */
{4.8469464225722128e+00, 3.1641356201816961e-13,
	2.2204460492503131e-16, 2.7755575615628914e-14,
	2.4202861936828413e-14}, /* L588 */
{3.6426203480057162e+00, 2.3819834993332734e-13,
	2.2204460492503131e-16, 3.4439118223872356e-13,
	-4.0967229608668276e-14}, /* L589 */
{5.8610261961358470e+00, 3.8391512191537913e-13,
	2.2204460492503131e-16, -7.8381745538536052e-14,
	1.3544720900426910e-14}, /* L590 */
{4.7216656558360253e+00, 3.0980773502164993e-13,
	2.2204460492503131e-16, 5.9729998724833422e-14,
	-2.2981616609740740e-14}, /* L591 */
{5.3674071168447686e+00, 3.5277336607464349e-13,
	2.2204460492503131e-16, 1.2878587085651816e-14,
	5.5733195836182858e-14}, /* L592 */
{5.6664296819543987e+00, 3.7305575295576432e-13,
	2.2204460492503131e-16, -1.0447198661722723e-13,
	6.7723604502134549e-14}, /* L593 */
{3.7803089945237085e+00, 2.4930058017957890e-13,
	2.2204460492503131e-16, -7.1720407390785113e-14,
	-8.7707618945387367e-15}, /* L594 */
{3.8424430370379552e+00, 2.5382473900492641e-13,
	2.2204460492503131e-16, 2.2692958623338200e-13,
	2.8577140653851529e-13}, /* L595 */
{5.3028607153457576e+00, 3.5088598693278072e-13,
	2.2204460492503131e-16, 3.6237679523765109e-13,
	-6.1373128801278654e-13}, /* L596 */
{4.7529388220176276e+00, 3.1502578323738817e-13,
	2.2204460492503131e-16, 1.1639578190170141e-12,
	5.2757798130187439e-13}, /* L597 */
{5.9414809458223976e+00, 3.9446224064931812e-13,
	2.2204460492503131e-16, -6.3837823915946501e-14,
	1.9229062786507711e-13}, /* L598 */
{4.2437462613310597e+00, 2.8221869285971479e-13,
	2.2204460492503131e-16, -4.3409720262843621e-14,
	2.2137847111025621e-13}, /* L599 */
{4.7225074506925866e+00, 3.1458169402753811e-13,
	2.2204460492503131e-16, 3.7112535267169733e-12,
	4.2388315080188477e-13}, /* L600 */
{5.1414390601010656e+00, 3.4305891460917337e-13,
	2.2204460492503131e-16, -1.2534417948018017e-13,
	3.1752378504279477e-14}, /* L601 */
{5.5282479246115317e+00, 3.6948222259525210e-13,
	2.2204460492503131e-16, 5.8619775700208265e-14,
	-4.8061554736023027e-13}, /* L602 */
{3.8026593989637387e+00, 2.5457413954654839e-13,
	2.2204460492503131e-16, 4.2454928461665986e-12,
	-9.5611296657693856e-12}, /* L603 */
{3.9147412756285060e+00, 2.6251223417261826e-13,
	2.2204460492503131e-16, 2.5721647034515627e-12,
	-1.8585133432225120e-13}, /* L604 */
{4.6305858181053470e+00, 3.1102898034873760e-13,
	2.2204460492503131e-16, -8.1046280797636427e-15,
	-7.0610184366159956e-14}, /* L605 */
{4.0532242165449244e+00, 2.7269853042355408e-13,
	2.2204460492503131e-16, -3.3212321781661558e-12,
	2.5228708011582057e-12}, /* L606 */
{4.0401628816070625e+00, 2.7226831900151183e-13,
	2.2204460492503131e-16, -8.8817841970012523e-16,
	9.9920072216264089e-15}, /* L607 */
{4.1801052791859110e+00, 2.8216318170848353e-13,
	2.2204460492503131e-16, 9.3258734068513149e-14,
	-1.9706458687096529e-13}, /* L608 */
{4.7077249971980910e+00, 3.1830094116003238e-13,
	2.2204460492503131e-16, 2.5757174171303632e-14,
	8.7485574340462335e-14}, /* L609 */
{3.7877108939317075e+00, 2.5651702983964242e-13,
	2.2204460492503131e-16, 6.5725203057809267e-14,
	4.7295500849031669e-14}, /* L610 */
{4.1546710393060637e+00, 2.8183011480109599e-13,
	2.2204460492503131e-16, -9.9920072216264089e-15,
	-1.0680345496894006e-13}, /* L611 */
{3.3041310299420852e+00, 2.2450097336701447e-13,
	2.2204460492503131e-16, -3.5094149808401198e-13,
	-4.4964032497318840e-14}, /* L612 */
{4.7732538603103807e+00, 3.2485125700532080e-13,
	2.2204460492503131e-16, -1.7827961329430764e-12,
	-1.6014967130217883e-12}, /* L613 */
{6.4568505778986003e+00, 4.4014791811264331e-13,
	2.2204460492503131e-16, -1.3167245072054357e-13,
	8.9706020389712648e-14}, /* L614 */
{4.9455362578909794e+00, 3.3767433293974136e-13,
	2.2204460492503131e-16, 2.8976820942716586e-13,
	-1.4355183708403274e-13}, /* L615 */
{4.6903483090863878e+00, 3.2077118738982335e-13,
	2.2204460492503131e-16, -1.9961809982760315e-13,
	-1.4588330543574557e-13}, /* L616 */
{3.6788955935217831e+00, 2.5200674880210272e-13,
	2.2204460492503131e-16, 3.7925218521195347e-13,
	9.2592600253738055e-14}, /* L617 */
{4.7815609419599179e+00, 3.2807090377673376e-13,
	2.2204460492503131e-16, 9.7699626167013776e-15,
	-2.5135449277513544e-13}, /* L618 */
{4.1219774241109510e+00, 2.8327340473310869e-13,
	2.2204460492503131e-16, -2.4313884239290928e-13,
	-2.4680257837417230e-13}, /* L619 */
{4.2258131187057746e+00, 2.9087843245179101e-13,
	2.2204460492503131e-16, 3.5638159090467525e-13,
	5.8286708792820718e-13}, /* L620 */
{4.9766584153114550e+00, 3.4311442576040463e-13,
	2.2204460492503131e-16, 4.6540549192286562e-13,
	4.2654768606098514e-13}, /* L621 */
{4.6993643258338178e+00, 3.2451819009793326e-13,
	2.2204460492503131e-16, 9.5334407035352342e-11,
	-8.3143381068850886e-11}, /* L622 */
{4.9153368079141577e+00, 3.3997804571583856e-13,
	2.2204460492503131e-16, 1.7077450564784158e-12,
	-8.9972473915622686e-13}, /* L623 */
{5.1935178092343115e+00, 3.5979552670539761e-13,
	2.2204460492503131e-16, -4.7961634663806763e-14,
	-1.6853185513809876e-13}, /* L624 */
{3.8295310418782900e+00, 2.6572667677360329e-13,
	2.2204460492503131e-16, -2.8199664825478976e-14,
	-6.1173288656846125e-14}, /* L625 */
{4.1034409788201964e+00, 2.8518853945058709e-13,
	2.2204460492503131e-16, -2.4868995751603507e-14,
	9.5479180117763462e-15}, /* L626 */
{5.6379674277378848e+00, 3.9246383920499284e-13,
	2.2204460492503131e-16, 2.5224267119483557e-13,
	-3.1641356201816961e-14}, /* L627 */
{3.8051413537108512e+00, 2.6530166952198897e-13,
	2.2204460492503131e-16, -2.6756374893466273e-14,
	6.6791017161449417e-13}, /* L628 */
{5.3020751377705739e+00, 3.7025937871248971e-13,
	2.2204460492503131e-16, -1.5709655798445965e-13,
	5.0848214527832170e-14}, /* L629 */
{4.5643921218871437e+00, 3.1925156962486767e-13,
	2.2204460492503131e-16, 1.2820855488371308e-12,
	9.0438767585965252e-13}, /* L630 */
{5.2892317996922458e+00, 3.7053693446864600e-13,
	2.2204460492503131e-16, -2.6090241078691179e-14,
	-6.7945649107059580e-14}, /* L631 */
{5.2257796055009651e+00, 3.6667197056416967e-13,
	2.2204460492503131e-16, -9.1382457156896635e-13,
	7.5939254884360707e-14}, /* L632 */
{4.5884748538039162e+00, 3.2246427750237672e-13,
	2.2204460492503131e-16, -4.0745185003743245e-14,
	3.5527136788005009e-15}, /* L633 */
{4.3848649621901075e+00, 3.0864200084579352e-13,
	2.2204460492503131e-16, 2.2692958623338200e-13,
	2.1627144519698049e-13}, /* L634 */
{4.7543382096139064e+00, 3.3517633113433476e-13,
	2.2204460492503131e-16, 4.9293902293356950e-14,
	-2.2859492077031973e-13}, /* L635 */
{4.5522870563855422e+00, 3.2143732120459845e-13,
	2.2204460492503131e-16, -3.0486724256206799e-13,
	1.7519319328584970e-13}, /* L636 */
{6.2276393387310875e+00, 4.4042547386879960e-13,
	2.2204460492503131e-16, 2.5757174171303632e-14,
	4.2721381987576024e-13}, /* L637 */
{3.9870752559488638e+00, 2.8241298188902419e-13,
	2.2204460492503131e-16, 2.9842794901924208e-13,
	2.4846791291111003e-13}, /* L638 */
{5.3294293785436286e+00, 3.7808645103609706e-13,
	2.2204460492503131e-16, 4.7117865165091644e-13,
	-2.1238566461079245e-13}, /* L639 */
{5.5650478425127439e+00, 3.9541980800805732e-13,
	2.2204460492503131e-16, -4.4264591991804991e-13,
	-3.1874503036988244e-13}, /* L640 */
{5.2702891262050811e+00, 3.7506109329399351e-13,
	2.2204460492503131e-16, -2.5535129566378600e-14,
	-1.8207657603852567e-14}, /* L641 */
{6.3638145573669265e+00, 4.5358855560451161e-13,
	2.2204460492503131e-16, 1.2034817586936697e-13,
	-1.7374990335383700e-13}, /* L642 */
{5.2084063510864560e+00, 3.7181369094696493e-13,
	2.2204460492503131e-16, -9.1038288019262836e-14,
	-5.1958437552457326e-14}, /* L643 */
{4.8757840900745046e+00, 3.4861002973229915e-13,
	2.2204460492503131e-16, 4.6629367034256575e-15,
	-5.9396931817445875e-14}, /* L644 */
{4.8945813656211525e+00, 3.5049740887416192e-13,
	2.2204460492503131e-16, 7.1276318180935050e-14,
	-1.2423395645555502e-13}, /* L645 */
{4.4133196564247070e+00, 3.1652458432063213e-13,
	2.2204460492503131e-16, 7.1720407390785113e-14,
	-6.1950444774083735e-14}, /* L646 */
{4.0626030092875505e+00, 2.9182212202272240e-13,
	2.2204460492503131e-16, 1.8429702208777599e-13,
	-1.9162449405030202e-13}, /* L647 */
{5.4020146956345565e+00, 3.8863356977003605e-13,
	2.2204460492503131e-16, -8.4932061383824475e-14,
	1.0103029524088925e-13}, /* L648 */
{5.5054015980784934e+00, 3.9668268669856843e-13,
	2.2204460492503131e-16, 7.3852035598065413e-13,
	3.9190872769268026e-13}, /* L649 */
{5.0880849505849701e+00, 3.6717850981915490e-13,
	2.2204460492503131e-16, -1.2756462552943049e-13,
	-4.2632564145606011e-14}, /* L650 */
{4.3256596664057803e+00, 3.1263880373444408e-13,
	2.2204460492503131e-16, 2.7755575615628914e-14,
	2.0206059048177849e-13}, /* L651 */
{3.5874289727938069e+00, 2.5968116545982411e-13,
	2.2204460492503131e-16, -6.1251004268569886e-13,
	-9.8809849191638932e-14}, /* L652 */
{4.6225187784319832e+00, 3.3512081998310350e-13,
	2.2204460492503131e-16, 6.5281113847959205e-14,
	-4.5297099404706387e-14}, /* L653 */
{4.0850599618472829e+00, 2.9660995881641838e-13,
	2.2204460492503131e-16, -3.2973623831367149e-14,
	-4.9626969200744497e-14}, /* L654 */
{4.2358845455806096e+00, 3.0803137818224968e-13,
	2.2204460492503131e-16, 1.1990408665951691e-14,
	-5.4400928206632670e-15}, /* L655 */
{4.7033229692459528e+00, 3.4254543646028424e-13,
	2.2204460492503131e-16, 4.7961634663806763e-14,
	1.7141843500212417e-13}, /* L656 */
{4.9421691367170686e+00, 3.6048941609578833e-13,
	2.2204460492503131e-16, 2.2426505097428162e-14,
	7.5939254884360707e-14}, /* L657 */
{5.8110843961520589e+00, 4.2451459014714032e-13,
	2.2204460492503131e-16, -1.2478906796786760e-13,
	6.8833827526759706e-15}, /* L658 */
{4.7881572128829744e+00, 3.5031873235613631e-13,
	2.2204460492503131e-16, -8.7485574340462335e-14,
	-3.7081449022480228e-14}, /* L659 */
{5.0192314037204078e+00, 3.6778219358879483e-13,
	2.2204460492503131e-16, 6.4859229098601645e-13,
	-2.9609648066752925e-13}, /* L660 */
{5.3494316622270413e+00, 3.9257139206050340e-13,
	2.2204460492503131e-16, -1.8873791418627661e-14,
	-6.8944849829222221e-14}, /* L661 */
{4.1148101173356100e+00, 3.0242475190789264e-13,
	2.2204460492503131e-16, -7.3641093223386633e-13,
	-2.4902302442342261e-13}, /* L662 */
{6.2224834220815088e+00, 4.5802250880910833e-13,
	2.2204460492503131e-16, 1.7741363933510002e-13,
	9.9475983006414026e-14}, /* L663 */
{4.2213922022854637e+00, 3.1119551380243138e-13,
	2.2204460492503131e-16, -2.7755575615628914e-13,
	-2.6789681584205027e-13}, /* L664 */
{5.0146695658141676e+00, 3.7023162313687408e-13,
	2.2204460492503131e-16, -4.2854608750531042e-14,
	-7.6050277186823223e-14}, /* L665 */
{4.5165236422650565e+00, 3.3395508580724709e-13,
	2.2204460492503131e-16, -3.4416913763379853e-15,
	4.6140868903421506e-13}, /* L666 */
{4.0292417392711082e+00, 2.9837243786801082e-13,
	2.2204460492503131e-16, 3.2995828291859652e-13,
	1.6675549829869851e-13}, /* L667 */
{5.2133315784024230e+00, 3.8663516832571077e-13,
	2.2204460492503131e-16, -1.0602629885170245e-13,
	4.7739590058881731e-14}, /* L668 */
{5.1341635561109529e+00, 3.8133385338312564e-13,
	2.2204460492503131e-16, -6.4503957730721595e-14,
	7.7715611723760958e-14}, /* L669 */
{4.8231419378625251e+00, 3.5876857040761934e-13,
	2.2204460492503131e-16, 6.1506355564233672e-14,
	-9.8920871494101448e-14}, /* L670 */
{5.1944940373073525e+00, 3.8696823523309831e-13,
	2.2204460492503131e-16, -4.1400216588272087e-13,
	5.7784887985690148e-12}, /* L671 */
{4.7715849091128026e+00, 3.5599301284605644e-13,
	2.2204460492503131e-16, -2.6090241078691179e-13,
	-2.8210767055725228e-13}, /* L672 */
{4.3774214679534467e+00, 3.2707170305457112e-13,
	2.2204460492503131e-16, -5.6510351953420468e-14,
	2.3092638912203256e-14}, /* L673 */
{5.5467446561795288e+00, 4.1505687775611477e-13,
	2.2204460492503131e-16, -3.9301895071730542e-14,
	6.7501559897209518e-14}, /* L674 */
{5.0581561284373775e+00, 3.7905789618264407e-13,
	2.2204460492503131e-16, 6.0396132539608516e-14,
	7.7715611723760958e-15}, /* L675 */
{4.7108062488399876e+00, 3.5355052219188110e-13,
	2.2204460492503131e-16, -1.6875389974302379e-13,
	1.0524914273446484e-13}, /* L676 */
{5.5169954102592733e+00, 4.1466829969749597e-13,
	2.2204460492503131e-16, -5.4067861299245124e-14,
	-1.0469403122215226e-13}, /* L677 */
{4.3677474883579750e+00, 3.2877346678450436e-13,
	2.2204460492503131e-16, -9.6345154076971085e-13,
	5.8930638147103309e-13}, /* L678 */
{4.3678272151421620e+00, 3.2926439352820580e-13,
	2.2204460492503131e-16, 5.7887028503955662e-13,
	1.3018475186754586e-12}, /* L679 */
{4.6167352249966322e+00, 3.4854064079326008e-13,
	2.2204460492503131e-16, -1.4002132786572474e-12,
	-7.6849637764553336e-13}, /* L680 */
{4.9959582309097179e+00, 3.7772476119135590e-13,
	2.2204460492503131e-16, 2.6223467841646197e-13,
	8.9706020389712648e-14}, /* L681 */
{5.1759612453303490e+00, 3.9190872769268026e-13,
	2.2204460492503131e-16, 1.5987211554602254e-14,
	8.3044682241961709e-14}, /* L682 */
{4.3077941317234414e+00, 3.2665189997338473e-13,
	2.2204460492503131e-16, -4.6962433941644122e-14,
	-4.2188474935755949e-15}, /* L683 */
{4.0570239446551604e+00, 3.0808688933348094e-13,
	2.2204460492503131e-16, -6.1506355564233672e-14,
	-1.5221157667610896e-13}, /* L684 */
{4.6985475589146226e+00, 3.5732528047560663e-13,
	2.2204460492503131e-16, 4.1189274213593308e-13,
	-2.0561330416057899e-13}, /* L685 */
{3.9599187840351564e+00, 3.0159208463942377e-13,
	2.2204460492503131e-16, -5.4845017416482733e-14,
	9.7477581562088744e-14}, /* L686 */
{4.6157278062813782e+00, 3.5205172110863714e-13,
	2.2204460492503131e-16, -1.1268763699945339e-13,
	-4.0523140398818214e-14}, /* L687 */
{4.8343099527041407e+00, 3.6926017799032707e-13,
	2.2204460492503131e-16, -1.0014211682118912e-13,
	-4.4386716524513758e-13}, /* L688 */
{6.0232315638530389e+00, 4.6074255521943996e-13,
	2.2204460492503131e-16, 1.0214051826551440e-13,
	-4.7295500849031669e-14}, /* L689 */
{5.4351535026003761e+00, 4.1636138981004933e-13,
	2.2204460492503131e-16, 2.0654589150126412e-12,
	7.4251715886930469e-13}, /* L690 */
{5.7158194375655240e+00, 4.3849646136351339e-13,
	2.2204460492503131e-16, 6.2594374128366326e-13,
	5.9952043329758453e-14}, /* L691 */
{6.4544899520722341e+00, 4.9588111394882617e-13,
	2.2204460492503131e-16, -3.3673064336880998e-13,
	4.5363712786183896e-13}, /* L692 */
{4.9278577025656229e+00, 3.7914116290949096e-13,
	2.2204460492503131e-16, -8.3266726846886741e-14,
	1.9761969838327786e-14}, /* L693 */
{6.3519552663816929e+00, 4.8941406483038463e-13,
	2.2204460492503131e-16, 8.7465590326019083e-12,
	5.5693227807296353e-12}, /* L694 */
{5.0841806832130079e+00, 3.9229730575129906e-13,
	2.2204460492503131e-16, 2.0738966099997924e-13,
	-4.2410519540680980e-13}, /* L695 */
{5.1544621552201750e+00, 3.9829251008427491e-13,
	2.2204460492503131e-16, 1.9850787680297799e-13,
	1.0214051826551440e-14}, /* L696 */
{5.2324329324346737e+00, 4.0489833708079459e-13,
	2.2204460492503131e-16, -1.2656542480726785e-14,
	7.4829031859735551e-14}, /* L697 */
{5.1830310999366036e+00, 4.0165093473376601e-13,
	2.2204460492503131e-16, -2.2115642650533118e-13,
	-5.7898130734201914e-13}, /* L698 */
{4.9399219568407764e+00, 3.8336001040306655e-13,
	2.2204460492503131e-16, -8.0158102377936302e-14,
	-3.2085445411667024e-14}, /* L699 */
{4.7735789598809486e+00, 3.7098102367849606e-13,
	2.2204460492503131e-16, -7.5384143372048129e-14,
	6.4837024638109142e-14}, /* L700 */
{4.9397367520882138e+00, 3.8444247785207608e-13,
	2.2204460492503131e-16, -9.3702823278363212e-14,
	4.5519144009631418e-14}, /* L701 */
{4.8098366483426922e+00, 3.7486680426468411e-13,
	2.2204460492503131e-16, 4.3742787170231168e-14,
	1.6853185513809876e-13}, /* L702 */
{4.8968782805974929e+00, 3.8219427622721014e-13,
	2.2204460492503131e-16, 1.6608936448392342e-13,
	-8.6475271388053443e-13}, /* L703 */
{3.8313270674372735e+00, 2.9945490531702035e-13,
	2.2204460492503131e-16, -3.3473224192448470e-13,
	4.1144865292608301e-13}, /* L704 */
{4.2883046380294312e+00, 3.3564817591980045e-13,
	2.2204460492503131e-16, 2.8199664825478976e-14,
	1.1124434706744069e-13}, /* L705 */
{5.0134640004284989e+00, 3.9296343956607416e-13,
	2.2204460492503131e-16, 7.9936057773011271e-15,
	1.2212453270876722e-14}, /* L706 */
{5.9489132045927313e+00, 4.6694592636953303e-13,
	2.2204460492503131e-16, 3.9501735216163070e-13,
	5.1403326040144748e-13}, /* L707 */
{5.2118726295850646e+00, 4.0967229608668276e-13,
	2.2204460492503131e-16, 2.9398705692074145e-13,
	9.8809849191638932e-14}, /* L708 */
{5.5599523544873568e+00, 4.3764991630723671e-13,
	2.2204460492503131e-16, -5.4733995114020217e-14,
	-4.5519144009631418e-15}, /* L709 */
{4.8014160259314247e+00, 3.7847502909471586e-13,
	2.2204460492503131e-16, 2.0028423364237824e-13,
	2.6045832157706172e-13}, /* L710 */
{5.2435033500683117e+00, 4.1390502136806617e-13,
	2.2204460492503131e-16, -1.3533618670180658e-13,
	-1.1723955140041653e-13}, /* L711 */
{4.5674229363923331e+00, 3.6104452760810091e-13,
	2.2204460492503131e-16, 4.5519144009631418e-14,
	3.1086244689504383e-15}, /* L712 */
{4.8288996241991464e+00, 3.8224978737844140e-13,
	2.2204460492503131e-16, 4.9515946898281982e-14,
	-2.9942714974140472e-13}, /* L713 */
{5.8702823708008474e+00, 4.6533610298382655e-13,
	2.2204460492503131e-16, 2.7355895326763857e-13,
	-1.0741407763248390e-12}, /* L714 */
{4.7476910568967554e+00, 3.7687561404986525e-13,
	2.2204460492503131e-16, 9.8587804586713901e-14,
	-2.7311486405778851e-14}, /* L715 */
{5.4015448349052813e+00, 4.2937875477377929e-13,
	2.2204460492503131e-16, 1.9761969838327786e-14,
	-1.3244960683778118e-13}, /* L716 */
{4.9463118484617477e+00, 3.9374059568331177e-13,
	2.2204460492503131e-16, 1.9095836023552692e-14,
	-1.2212453270876722e-14}, /* L717 */
{4.6970826195298452e+00, 3.7442271505483404e-13,
	2.2204460492503131e-16, -6.1706195708666201e-13,
	3.4972025275692431e-13}, /* L718 */
{4.8588393765343305e+00, 3.8785641365279844e-13,
	2.2204460492503131e-16, -1.7585932710062480e-13,
	4.7073456244106637e-14}, /* L719 */
{4.7618130683010955e+00, 3.8063996399273492e-13,
	2.2204460492503131e-16, -1.5765166949677223e-14,
	1.8030021919912542e-13}, /* L720 */
{5.1213673033048188e+00, 4.0994985184283905e-13,
	2.2204460492503131e-16, 6.5014660322049167e-13,
	5.9818816566803434e-13}, /* L721 */
{5.0121270212414260e+00, 4.0176195703622852e-13,
	2.2204460492503131e-16, -6.7279515292284486e-14,
	2.6645352591003757e-14}, /* L722 */
{4.4652560075209058e+00, 3.5842162571242397e-13,
	2.2204460492503131e-16, 6.8833827526759706e-15,
	-1.3178347302300608e-13}, /* L723 */
{5.3266658624814962e+00, 4.2815750944669162e-13,
	2.2204460492503131e-16, 1.2390088954816747e-13,
	3.9079850466805510e-14}, /* L724 */
{5.2069047666948487e+00, 4.1910919179599659e-13,
	2.2204460492503131e-16, -1.2212453270876722e-14,
	8.4376949871511897e-14}, /* L725 */
{6.0721084092094193e+00, 4.8942447317124049e-13,
	2.2204460492503131e-16, 7.7937656328685989e-14,
	-4.2188474935755949e-14}, /* L726 */
{6.1079876283618040e+00, 4.9299453408480076e-13,
	2.2204460492503131e-16, -2.8643754035329039e-14,
	1.5543122344752192e-14}, /* L727 */
{5.4828383206431903e+00, 4.4314552027913123e-13,
	2.2204460492503131e-16, 3.0198066269804258e-14,
	-6.8722805224297190e-14}, /* L728 */
{5.5171554808615264e+00, 4.4653170050423796e-13,
	2.2204460492503131e-16, -1.2800871473928055e-13,
	5.3290705182007514e-15}, /* L729 */
{4.5318564650100708e+00, 3.6728953212161741e-13,
	2.2204460492503131e-16, -5.6510351953420468e-14,
	1.3766765505351941e-14}, /* L730 */
{4.2243568699950700e+00, 3.4283687000424834e-13,
	2.2204460492503131e-16, -2.4402702081260941e-13,
	2.3114843372695759e-13}, /* L731 */
{5.0747230422844911e+00, 4.1241359285959511e-13,
	2.2204460492503131e-16, 1.2723155862204294e-13,
	7.4384942649885488e-14}, /* L732 */
{5.3386850940954931e+00, 4.3445802511143938e-13,
	2.2204460492503131e-16, 6.3504757008558954e-14,
	-6.8389738316909643e-14}, /* L733 */
{4.9795718890026182e+00, 4.0578651550049472e-13,
	2.2204460492503131e-16, 2.3758772726978350e-14,
	3.9834802123550617e-13}, /* L734 */
{5.0486474210580292e+00, 4.1197600886277996e-13,
	2.2204460492503131e-16, 4.6318504587361531e-13,
	5.6044058283077902e-13}, /* L735 */
{5.0954564086903238e+00, 4.1636138981004933e-13,
	2.2204460492503131e-16, 7.3430150848707854e-13,
	-3.8147263126120379e-13}, /* L736 */
{5.8493986451558717e+00, 4.7861714591590498e-13,
	2.2204460492503131e-16, -1.6551204851111834e-12,
	1.9984014443252818e-13}, /* L737 */
{4.6924193273823711e+00, 3.8447023342769171e-13,
	2.2204460492503131e-16, 2.7311486405778851e-14,
	2.5779378631796135e-13}, /* L738 */
{4.3095467180101430e+00, 3.5357827776749673e-13,
	2.2204460492503131e-16, -1.1179945857975326e-13,
	-9.6589403142388619e-15}, /* L739 */
{6.1905503074137398e+00, 5.0859316758078421e-13,
	2.2204460492503131e-16, -1.1246559239452836e-13,
	-2.0738966099997924e-13}, /* L740 */
{5.5512908095930245e+00, 4.5669024117955814e-13,
	2.2204460492503131e-16, -7.8381745538536052e-14,
	5.6399329650957952e-14}, /* L741 */
{4.4632819743648717e+00, 3.6767811018023622e-13,
	2.2204460492503131e-16, -1.7208456881689926e-13,
	1.5099033134902129e-14}, /* L742 */
{5.3353886329874900e+00, 4.4011322364312377e-13,
	2.2204460492503131e-16, 6.9277916736609768e-13,
	-2.8745894553594553e-12}, /* L743 */
{5.1660027740936192e+00, 4.2671421951467892e-13,
	2.2204460492503131e-16, -5.1292303737682232e-14,
	2.4558133304708463e-13}, /* L744 */
{5.3493372987469883e+00, 4.4245163088874051e-13,
	2.2204460492503131e-16, -7.1165295878472534e-14,
	-2.2171153801764376e-13}, /* L745 */
{5.0768344172633766e+00, 4.2047615389506632e-13,
	2.2204460492503131e-16, 1.5987211554602254e-14,
	3.5749181392930041e-14}, /* L746 */
{5.0833413533573530e+00, 4.2157943802578757e-13,
	2.2204460492503131e-16, 3.7303493627405260e-14,
	1.6098233857064770e-13}, /* L747 */
{6.4737735827010674e+00, 5.3761162188692424e-13,
	2.2204460492503131e-16, 2.0827783941967937e-13,
	1.7896795156957523e-13}, /* L748 */
{5.7977394542109755e+00, 4.8211434844347423e-13,
	2.2204460492503131e-16, -8.6597395920762210e-15,
	4.4408920985006262e-16}, /* L749 */
{5.9083426549549891e+00, 4.9196757778702249e-13,
	2.2204460492503131e-16, 1.0857981180834031e-13,
	6.1239902038323635e-13}, /* L750 */
{5.4524054065550729e+00, 4.5460857300838597e-13,
	2.2204460492503131e-16, 1.2545520178264269e-13,
	-4.7828407900851744e-13}, /* L751 */
{5.9521370503034259e+00, 4.9693582582222007e-13,
	2.2204460492503131e-16, 2.0428103653102880e-14,
	-1.7297274723659939e-13}, /* L752 */
{4.4077094773133005e+00, 3.6848302187308946e-13,
	2.2204460492503131e-16, -2.5379698342931079e-13,
	6.7057470687359455e-14}, /* L753 */
{4.8919175323276605e+00, 4.0950576263298899e-13,
	2.2204460492503131e-16, -4.2943426592501055e-13,
	-2.5501822875639846e-13}, /* L754 */
{5.7076248990002449e+00, 4.7842285688659558e-13,
	2.2204460492503131e-16, -2.7311486405778851e-14,
	4.3298697960381105e-14}, /* L755 */
{4.9604079583435956e+00, 4.1634057312833761e-13,
	2.2204460492503131e-16, -2.2037927038809357e-13,
	-1.3766765505351941e-14}, /* L756 */
{4.8877223745374927e+00, 4.1078251911130792e-13,
	2.2204460492503131e-16, 6.7723604502134549e-14,
	-7.1609385088322597e-14}, /* L757 */
{5.7645209680763907e+00, 4.8511195060996215e-13,
	2.2204460492503131e-16, 3.5749181392930041e-14,
	5.9063864910058328e-14}, /* L758 */
{4.8623265119067423e+00, 4.0972780723791402e-13,
	2.2204460492503131e-16, -6.0285110237146000e-14,
	-1.3866685577568205e-13}, /* L759 */
{6.0394832127454210e+00, 5.0959236830294685e-13,
	2.2204460492503131e-16, 1.4410694859634532e-13,
	7.9936057773011271e-15}, /* L760 */
{4.8304938234636792e+00, 4.0811798385220754e-13,
	2.2204460492503131e-16, 2.3536728122053319e-14,
	-1.9484414082171497e-13}, /* L761 */
{4.7983999589190889e+00, 4.0593917116638067e-13,
	2.2204460492503131e-16, 3.7392311469375272e-13,
	-3.6637359812630166e-15}, /* L762 */
{5.9030237300169430e+00, 5.0004445029117051e-13,
	2.2204460492503131e-16, -2.5757174171303632e-14,
	-6.9610983643997315e-14}, /* L763 */
{6.7755342500098648e+00, 5.7470694869721228e-13,
	2.2204460492503131e-16, 1.8252066524837574e-13,
	-3.1241675912951905e-13}, /* L764 */
{5.5673290449827393e+00, 4.7284398618785417e-13,
	2.2204460492503131e-16, -5.5411231159041563e-13,
	1.8514079158649110e-12}, /* L765 */
{5.9685554349095993e+00, 5.0758355851776571e-13,
	2.2204460492503131e-16, -6.5059069243034173e-14,
	8.8817841970012523e-15}, /* L766 */
{5.8387478037452416e+00, 4.9719256489666463e-13,
	2.2204460492503131e-16, 5.7420734833613096e-13,
	2.6556534749033744e-13}, /* L767 */
{5.7496835504787178e+00, 4.9024673209885350e-13,
	2.2204460492503131e-16, -9.6256336235001072e-14,
	4.0811798385220754e-13}, /* L768 */
{5.8266001387022452e+00, 4.9745190605632317e-13,
	2.2204460492503131e-16, 8.4376949871511897e-14,
	-1.7563728249569976e-13}, /* L769 */
{6.2052045951827610e+00, 5.3046456116589980e-13,
	2.2204460492503131e-16, -8.2711615334574162e-14,
	-4.4075854077618715e-13}, /* L770 */
{5.3923561080757043e+00, 4.6157522248790883e-13,
	2.2204460492503131e-16, -1.1668443988810395e-13,
	-2.2759572004815709e-14}, /* L771 */
{5.4776640825639777e+00, 4.6948556153836307e-13,
	2.2204460492503131e-16, 1.1679546219056647e-13,
	4.2410519540680980e-14}, /* L772 */
{6.3467111775282090e+00, 5.4467541588110180e-13,
	2.2204460492503131e-16, -1.0056400157054668e-12,
	8.9883656073652674e-13}, /* L773 */
{5.2017200930915255e+00, 4.4698966750189584e-13,
	2.2204460492503131e-16, -9.2148511043887993e-14,
	-5.3290705182007514e-14}, /* L774 */
{5.8645253815355041e+00, 5.0459636469213365e-13,
	2.2204460492503131e-16, -1.4743761767022079e-13,
	-3.2196467714129540e-14}, /* L775 */
{5.5992356380756574e+00, 4.8239190419963052e-13,
	2.2204460492503131e-16, 3.1130653610489389e-13,
	3.5282887722587475e-13}, /* L776 */
{6.1065089907819461e+00, 5.2677306960902115e-13,
	2.2204460492503131e-16, -3.7192471324942744e-14,
	-1.0402789740737717e-13}, /* L777 */
{5.6587492877443317e+00, 4.8877568659122517e-13,
	2.2204460492503131e-16, -1.7075230118734908e-13,
	3.3306690738754696e-15}, /* L778 */
{6.0950031976423800e+00, 5.2713389209202433e-13,
	2.2204460492503131e-16, 9.4591001698063337e-14,
	-9.7921670771938807e-14}, /* L779 */
{4.2705195581422490e+00, 3.6981528950263964e-13,
	2.2204460492503131e-16, -7.5051076464660582e-14,
	6.8833827526759706e-14}, /* L780 */
{6.2842608750193412e+00, 5.4489746048602683e-13,
	2.2204460492503131e-16, -5.6521454183666719e-13,
	-1.3282708266615373e-12}, /* L781 */
{4.8481534290174508e+00, 4.2091330421101247e-13,
	2.2204460492503131e-16, 1.5543122344752192e-14,
	-4.6518344731794059e-14}, /* L782 */
{4.5756976724947460e+00, 3.9776688887105394e-13,
	2.2204460492503131e-16, -6.6391336872584361e-14,
	-1.4654943925052066e-14}, /* L783 */
{4.7464998355253565e+00, 4.1314174303863638e-13,
	2.2204460492503131e-16, 6.2394533983933798e-14,
	7.1720407390785113e-14}, /* L784 */
{5.8566971382328585e+00, 5.1042503557141572e-13,
	2.2204460492503131e-16, 5.1358917119159742e-13,
	2.2870594307278225e-14}, /* L785 */
{5.5356321432753823e+00, 4.8305803801440561e-13,
	2.2204460492503131e-16, 3.1308289294429414e-14,
	1.7985612998927536e-14}, /* L786 */
{5.5203390779653203e+00, 4.8233639304839926e-13,
	2.2204460492503131e-16, 5.6843418860808015e-14,
	-4.3742787170231168e-14}, /* L787 */
{5.5780544858105578e+00, 4.8799853047398756e-13,
	2.2204460492503131e-16, -3.7614356074300304e-13,
	5.6021853822585399e-13}, /* L788 */
{7.0095167623594357e+00, 6.1400884376894282e-13,
	2.2204460492503131e-16, -3.9224179460006781e-13,
	3.1086244689504383e-14}, /* L789 */
{6.2753263563234212e+00, 5.5039306445792135e-13,
	2.2204460492503131e-16, -3.1197266991966899e-14,
	2.0206059048177849e-14}, /* L790 */
{6.5107561633421813e+00, 5.7176485768195562e-13,
	2.2204460492503131e-16, 1.8562928971732617e-13,
	6.0618177144533547e-14}, /* L791 */
{7.4968552621604037e+00, 6.5919492087118670e-13,
	2.2204460492503131e-16, 1.0678125050844756e-12,
	-4.5585757391108928e-13}, /* L792 */
{6.4965424060061920e+00, 5.7195914671126502e-13,
	2.2204460492503131e-16, -1.1124434706744069e-13,
	6.5947247662734299e-14}, /* L793 */
{5.7830695773901368e+00, 5.0978665733225625e-13,
	2.2204460492503131e-16, 3.9079850466805510e-14,
	1.6719958750854857e-13}, /* L794 */
{6.2003242476933940e+00, 5.4725668441335529e-13,
	2.2204460492503131e-16, 1.1335377081422848e-12,
	-9.2892360470386848e-13}, /* L795 */
{5.6677225098294119e+00, 5.0087711755963937e-13,
	2.2204460492503131e-16, -1.2045919817182948e-13,
	3.2107649872159527e-13}, /* L796 */
{6.6041509463901598e+00, 5.8436588901145115e-13,
	2.2204460492503131e-16, 1.6431300764452317e-14,
	6.2172489379008766e-15}, /* L797 */
{6.1729420699215547e+00, 5.4689586193035211e-13,
	2.2204460492503131e-16, 4.6629367034256575e-15,
	-8.2267526124724100e-14}, /* L798 */
{6.2140273258094378e+00, 5.5122573172639022e-13,
	2.2204460492503131e-16, 6.1239902038323635e-13,
	-1.5598633495983449e-13}, /* L799 */
{5.1640706473886384e+00, 4.5866088704826780e-13,
	2.2204460492503131e-16, 4.2010839251815923e-13,
	-2.7089441800853820e-14}, /* L800 */
{5.3662693902416185e+00, 4.7721548934731572e-13,
	2.2204460492503131e-16, -3.4328095921409840e-13,
	2.0095036745715333e-13}, /* L801 */
{5.6764428709713037e+00, 5.0542903196060252e-13,
	2.2204460492503131e-16, 7.0166095156309893e-14,
	9.9698027611339057e-14}, /* L802 */
{5.4651393820397143e+00, 4.8722137435674995e-13,
	2.2204460492503131e-16, -9.5479180117763462e-15,
	-1.0536016503692736e-13}, /* L803 */
{5.0876945940554847e+00, 4.5413672822292028e-13,
	2.2204460492503131e-16, 1.3988810110276972e-14,
	-2.9420910152566648e-14}, /* L804 */
{6.2478359442095970e+00, 5.5838667023522248e-13,
	2.2204460492503131e-16, 3.3084646133829665e-14,
	4.0190073491430667e-14}, /* L805 */
{5.9686818734065330e+00, 5.3410054157154718e-13,
	2.2204460492503131e-16, -1.1868284133242923e-13,
	-5.9396931817445875e-14}, /* L806 */
{6.2786629999092876e+00, 5.6253591194932451e-13,
	2.2204460492503131e-16, 2.3270274596143281e-13,
	1.2967404927621828e-13}, /* L807 */
{5.3459242758868228e+00, 4.7956083548683637e-13,
	2.2204460492503131e-16, -7.3052675020335300e-14,
	4.8849813083506888e-15}, /* L808 */
{8.6094078970912360e+00, 7.7327033665142153e-13,
	2.2204460492503131e-16, -1.4810375148499588e-13,
	-7.7493567118835927e-14}, /* L809 */
{4.2793277391799380e+00, 3.8483105591069489e-13,
	2.2204460492503131e-16, -7.4051875742497941e-14,
	8.9483975784787617e-14}, /* L810 */
{5.0394654107250147e+00, 4.5374815016430148e-13,
	2.2204460492503131e-16, -7.2719608112947753e-14,
	1.8651746813702630e-14}, /* L811 */
{4.9039486236889385e+00, 4.4209080840573733e-13,
	2.2204460492503131e-16, 5.7953641885433171e-14,
	-2.8221869285971479e-13}, /* L812 */
{5.7191049640321117e+00, 5.1621207308727435e-13,
	2.2204460492503131e-16, 1.0902390101819037e-13,
	-9.2703622556200571e-14}, /* L813 */
{4.7143809022858729e+00, 4.2604808569990382e-13,
	2.2204460492503131e-16, -8.0158102377936302e-14,
	-4.4408920985006262e-15}, /* L814 */
{4.5938722784586270e+00, 4.1566750041965861e-13,
	2.2204460492503131e-16, 1.6431300764452317e-14,
	1.1324274851176597e-14}, /* L815 */
{4.9963314121564366e+00, 4.5263792713967632e-13,
	2.2204460492503131e-16, 2.8066438062523957e-13,
	-9.9809049913801573e-14}, /* L816 */
{7.0710025880389846e+00, 6.4137584132595293e-13,
	2.2204460492503131e-16, -5.9952043329758453e-15,
	9.8143715376863838e-14}, /* L817 */
{5.3398617254701852e+00, 4.8494541715626838e-13,
	2.2204460492503131e-16, 1.2145839889399213e-13,
	-1.7752466163756253e-13}, /* L818 */
{5.2106309314706731e+00, 4.7378767575878555e-13,
	2.2204460492503131e-16, -1.1379786002407855e-13,
	1.1346479311669100e-13}, /* L819 */
{7.7658659107967294e+00, 7.0699002208129968e-13,
	2.2204460492503131e-16, -1.6586731987899839e-13,
	-2.8610447344590284e-13}, /* L820 */
{5.9707767770184210e+00, 5.4423132667125174e-13,
	2.2204460492503131e-16, -1.9662049766111522e-13,
	-3.9523939676655573e-14}, /* L821 */
{5.2487917360427163e+00, 4.7900572397452379e-13,
	2.2204460492503131e-16, 9.9920072216264089e-15,
	4.0234482412415673e-13}, /* L822 */
{5.4125237277037135e+00, 4.9454884631927598e-13,
	2.2204460492503131e-16, 8.1179507560591446e-13,
	5.6887827781793021e-13}, /* L823 */
{6.2803497143765901e+00, 5.7454041524351851e-13,
	2.2204460492503131e-16, 1.0880185641326534e-14,
	-8.9372953482325102e-14}, /* L824 */
{6.7254651562663037e+00, 6.1600724521326811e-13,
	2.2204460492503131e-16, 7.7715611723760958e-14,
	5.2402526762307389e-14}, /* L825 */
{4.8114482690209952e+00, 4.4123038556165284e-13,
	2.2204460492503131e-16, -4.5297099404706387e-14,
	2.7200464103316335e-13}, /* L826 */
{5.5169373619097337e+00, 5.0653925498522767e-13,
	2.2204460492503131e-16, 5.1070259132757201e-14,
	1.7696955012524995e-13}, /* L827 */
{6.7110613127196102e+00, 6.1692317920858386e-13,
	2.2204460492503131e-16, 3.9479530755670567e-13,
	2.1938006966593093e-13}, /* L828 */
{4.9318533781096772e+00, 4.5391468361799525e-13,
	2.2204460492503131e-16, 1.3382628338831637e-12,
	-1.7723600365115999e-12}, /* L829 */
{7.0957943276075541e+00, 6.5386585035298594e-13,
	2.2204460492503131e-16, 2.3936408410918375e-13,
	-2.1760371282653068e-14}, /* L830 */
{6.1868328656989169e+00, 5.7079341253540861e-13,
	2.2204460492503131e-16, 3.1330493754921918e-13,
	1.6764367671839864e-13}, /* L831 */
{5.6953590457039507e+00, 5.2608264966558238e-13,
	2.2204460492503131e-16, 1.4166445794216997e-13,
	8.8817841970012523e-14}, /* L832 */
{6.1380649061527537e+00, 5.6765703249084254e-13,
	2.2204460492503131e-16, -5.7776006201493146e-13,
	-1.3389289676979388e-13}, /* L833 */
{5.4451524757264069e+00, 5.0418003105789921e-13,
	2.2204460492503131e-16, 1.1428635815491361e-12,
	-2.0310420012492614e-12}, /* L834 */
{5.1000080463185959e+00, 4.7278847503662291e-13,
	2.2204460492503131e-16, 2.9753977059954195e-14,
	-1.7730261703263750e-13}, /* L835 */
{6.5557818742044169e+00, 6.0847160643362486e-13,
	2.2204460492503131e-16, 4.0634162701280729e-14,
	-4.9737991503207013e-14}, /* L836 */
{4.8470805265992407e+00, 4.5041748109042601e-13,
	2.2204460492503131e-16, -3.5305092183079978e-13,
	-1.0147438445073931e-13}, /* L837 */
{4.7416542589833197e+00, 4.4114711883480595e-13,
	2.2204460492503131e-16, 4.3076653355456074e-14,
	-8.2156503822261584e-15}, /* L838 */
{5.6830393594974247e+00, 5.2936127703517855e-13,
	2.2204460492503131e-16, 9.0372154204487742e-14,
	4.4853010194856324e-14}, /* L839 */
{4.9940554981994092e+00, 4.6573855883025317e-13,
	2.2204460492503131e-16, 1.5321077739827160e-14,
	-5.6066262743570405e-14}, /* L840 */
{6.3252180649539564e+00, 5.9058313794935202e-13,
	2.2204460492503131e-16, 1.1368683772161603e-13,
	5.1736392947532295e-14}, /* L841 */
{7.6437175227231364e+00, 7.1453953864875075e-13,
	2.2204460492503131e-16, -1.7263968032921184e-13,
	1.4832579608992091e-13}, /* L842 */
{5.9208278466507434e+00, 5.5414006716603126e-13,
	2.2204460492503131e-16, -1.5056844659966373e-12,
	2.1820323325982827e-12}, /* L843 */
{5.6466321314715486e+00, 5.2910453796073398e-13,
	2.2204460492503131e-16, -8.4021678503631847e-13,
	9.3547392054915690e-13}, /* L844 */
{5.9603644332938392e+00, 5.5916382635246009e-13,
	2.2204460492503131e-16, -5.0293103015519591e-14,
	2.7333690866271354e-13}, /* L845 */
{4.8883055846546570e+00, 4.5913273183373349e-13,
	2.2204460492503131e-16, 5.2180482157382357e-14,
	-5.2069459854919842e-14}, /* L846 */
{4.8733843121492511e+00, 4.5827230898964899e-13,
	2.2204460492503131e-16, 1.6719958750854857e-13,
	2.2426505097428162e-14}, /* L847 */
{5.3661641266103519e+00, 5.0520698735567748e-13,
	2.2204460492503131e-16, -2.5424107263916085e-13,
	-2.2359891715950653e-13}, /* L848 */
{5.9634958633023061e+00, 5.6210591736771676e-13,
	2.2204460492503131e-16, 6.6613381477509392e-15,
	-4.4408920985006262e-16}, /* L849 */
{6.7764812795381681e+00, 6.3948846218409017e-13,
	2.2204460492503131e-16, -4.7739590058881731e-14,
	1.7763568394002505e-15}, /* L850 */
{6.2679299829287256e+00, 5.9219296133505850e-13,
	2.2204460492503131e-16, -2.9796165534889951e-12,
	1.8427481762728348e-12}, /* L851 */
{5.9629825592457770e+00, 5.6404360349038285e-13,
	2.2204460492503131e-16, -1.0946799022804043e-13,
	-1.4777068457760834e-13}, /* L852 */
{4.2268530931108366e+00, 4.0029091152860019e-13,
	2.2204460492503131e-16, -1.2930767567809198e-12,
	6.4948046940571658e-13}, /* L853 */
{5.7582058060667052e+00, 5.4595217235942073e-13,
	2.2204460492503131e-16, 6.6613381477509392e-16,
	9.7033492352238682e-14}, /* L854 */
{7.0141923528353711e+00, 6.6581462565551419e-13,
	2.2204460492503131e-16, 3.8280489889075398e-13,
	4.4420023215252513e-12}, /* L855 */
{5.9497757421420419e+00, 5.6543658644159223e-13,
	2.2204460492503131e-16, 1.2900791546144319e-13,
	1.5099033134902129e-14}, /* L856 */
{7.1053204283170386e+00, 6.7604255526987345e-13,
	2.2204460492503131e-16, -1.0758061108617767e-13,
	6.4392935428259079e-15}, /* L857 */
{5.0920826258418206e+00, 4.8505643945873089e-13,
	2.2204460492503131e-16, 1.9320101074526974e-12,
	4.5958792327382980e-12}, /* L858 */
{4.2008215286996027e+00, 4.0062397843598774e-13,
	2.2204460492503131e-16, 7.7760020644745964e-13,
	-1.1314282843954970e-12}, /* L859 */
{6.9174527740754632e+00, 6.6047167734950563e-13,
	2.2204460492503131e-16, -3.7346792325365641e-12,
	-7.3641093223386633e-13}, /* L860 */
{5.7305549180195285e+00, 5.4778404035005224e-13,
	2.2204460492503131e-16, -1.6653345369377348e-15,
	7.3940853440035426e-14}, /* L861 */
{7.9808710601531505e+00, 7.6377792979087644e-13,
	2.2204460492503131e-16, 5.5511151231257827e-14,
	-9.1149310321725352e-14}, /* L862 */
{5.7507332908169095e+00, 5.5098980933365738e-13,
	2.2204460492503131e-16, 3.6859404417555197e-14,
	1.6497914145929826e-13}, /* L863 */
{6.5356729271103298e+00, 6.2692212532411418e-13,
	2.2204460492503131e-16, -1.9484414082171497e-13,
	-3.0264679651281767e-13}, /* L864 */
{6.4185072363470708e+00, 6.1639582327188691e-13,
	2.2204460492503131e-16, -1.2267964422107980e-13,
	3.4972025275692431e-13}, /* L865 */
{5.4076297787670571e+00, 5.1991744243196081e-13,
	2.2204460492503131e-16, -1.5953904863863499e-13,
	2.7200464103316335e-13}, /* L866 */
{6.1355344782250452e+00, 5.9058313794935202e-13,
	2.2204460492503131e-16, 5.8841820305133297e-14,
	2.7311486405778851e-13}, /* L867 */
{6.7753563116450861e+00, 6.5292216078205456e-13,
	2.2204460492503131e-16, -2.4824586830618500e-13,
	-1.2900791546144319e-13}, /* L868 */
{5.0374072571016804e+00, 4.8600012902966228e-13,
	2.2204460492503131e-16, -6.0618177144533547e-14,
	-2.1871393585115584e-14}, /* L869 */
{5.5025948883733582e+00, 5.3149151746367806e-13,
	2.2204460492503131e-16, 3.3217872896784684e-13,
	-1.8784973576657649e-13}, /* L870 */
{5.0183776075375430e+00, 4.8527848406365592e-13,
	2.2204460492503131e-16, -2.4702462297909733e-13,
	-5.1658677335808534e-13}, /* L871 */
{5.4753526751941850e+00, 5.3007598310728099e-13,
	2.2204460492503131e-16, -3.5804692544161298e-13,
	-1.1535217225855376e-13}, /* L872 */
{6.0968022879236550e+00, 5.9091620485673957e-13,
	2.2204460492503131e-16, -3.6848302187308946e-13,
	-1.7064127888488656e-13}, /* L873 */
{5.0520674672500006e+00, 4.9021897652323787e-13,
	2.2204460492503131e-16, 1.4566126083082054e-13,
	5.1070259132757201e-14}, /* L874 */
{6.6548676422855584e+00, 6.4648286723922865e-13,
	2.2204460492503131e-16, -1.8096635301390052e-14,
	-4.0745185003743245e-14}, /* L875 */
{6.1301466578670061e+00, 5.9618976422370906e-13,
	2.2204460492503131e-16, 7.1409544943890069e-13,
	1.9251267247000214e-12}, /* L876 */
{5.4925970351436639e+00, 5.3479443096193791e-13,
	2.2204460492503131e-16, -3.2085445411667024e-13,
	1.4632739464559563e-12}, /* L877 */
{6.4874817615396578e+00, 6.3238303482648917e-13,
	2.2204460492503131e-16, 3.0198066269804258e-14,
	1.9229062786507711e-13}, /* L878 */
{6.3219667432584989e+00, 6.1695093478419949e-13,
	2.2204460492503131e-16, 1.6942003355779889e-13,
	4.4431125445498765e-13}, /* L879 */
{6.5198966501069764e+00, 6.3699046037868357e-13,
	2.2204460492503131e-16, -9.1993079820440471e-13,
	-2.1993518117824351e-13}, /* L880 */
{7.3104542125073992e+00, 7.1503913900983207e-13,
	2.2204460492503131e-16, 3.1263880373444408e-13,
	1.7053025658242404e-13}, /* L881 */
{6.2443409174818978e+00, 6.1145533081230496e-13,
	2.2204460492503131e-16, 2.6201263381153694e-14,
	5.2913229353634961e-13}, /* L882 */
{5.9634154107848127e+00, 5.8460875029808790e-13,
	2.2204460492503131e-16, -6.1617377866696188e-14,
	2.3336887977620790e-13}, /* L883 */
{5.7030632964053680e+00, 5.5971893786477267e-13,
	2.2204460492503131e-16, 8.8595797365087492e-14,
	9.7699626167013776e-15}, /* L884 */
{6.9318612189290265e+00, 6.8108713113801400e-13,
	2.2204460492503131e-16, -3.5171865420124959e-13,
	2.1760371282653068e-13}, /* L885 */
{6.3665803041881350e+00, 6.2625252206238713e-13,
	2.2204460492503131e-16, 5.1070259132757201e-15,
	-2.3414603589344551e-13}, /* L886 */
{5.6065477406402371e+00, 5.5211391014609035e-13,
	2.2204460492503131e-16, 4.9737991503207013e-14,
	-2.1638246749944301e-13}, /* L887 */
{5.8378470482479052e+00, 5.7553961596568115e-13,
	2.2204460492503131e-16, -1.6220358389773537e-13,
	2.6578739209526248e-13}, /* L888 */
{7.6957376759261065e+00, 7.5955908229730085e-13,
	2.2204460492503131e-16, 1.6897594434794883e-13,
	1.7874590696465020e-13}, /* L889 */
{6.7526089682461441e+00, 6.6722322111800736e-13,
	2.2204460492503131e-16, -2.4424906541753444e-14,
	6.9277916736609768e-14}, /* L890 */
{6.5410018321168515e+00, 6.4704058083675520e-13,
	2.2204460492503131e-16, 2.3114843372695759e-13,
	-9.5412566736285953e-13}, /* L891 */
{5.7140995420799570e+00, 5.6587720620449034e-13,
	2.2204460492503131e-16, -3.1863400806741993e-13,
	9.3480778673438181e-14}, /* L892 */
{5.8169184719059235e+00, 5.7670535014153756e-13,
	2.2204460492503131e-16, -2.7866597918091429e-14,
	1.3322676295501878e-15}, /* L893 */
{6.2186899007512162e+00, 6.1722849054035578e-13,
	2.2204460492503131e-16, -1.4588330543574557e-13,
	7.8737016906416102e-13}, /* L894 */
{7.3469389656127406e+00, 7.3002714984227168e-13,
	2.2204460492503131e-16, -8.7230223044798549e-13,
	3.9235281690253032e-13}, /* L895 */
{6.9894083486650374e+00, 6.9527716917150428e-13,
	2.2204460492503131e-16, -3.1763480734525729e-13,
	-1.7030821197749901e-13}, /* L896 */
{5.4559729334525704e+00, 5.4334314825155161e-13,
	2.2204460492503131e-16, -9.6367358537463588e-14,
	-3.6115554991056342e-13}, /* L897 */
{6.2516802419381792e+00, 6.2327920602456288e-13,
	2.2204460492503131e-16, -1.0635936575909000e-13,
	1.4166445794216997e-13}, /* L898 */
{6.5289313240726177e+00, 6.5164540430373563e-13,
	2.2204460492503131e-16, 9.9475983006414026e-13,
	6.1373128801278654e-13}, /* L899 */
{6.6433438145839370e+00, 6.6380234642338110e-13,
	2.2204460492503131e-16, -4.0523140398818214e-14,
	7.4384942649885488e-14}, /* L900 */
{7.6905642977033422e+00, 7.6929435044448269e-13,
	2.2204460492503131e-16, -6.5336624999190462e-13,
	-7.7338135895388405e-13}, /* L901 */
{6.5299437834815359e+00, 6.5392136150421720e-13,
	2.2204460492503131e-16, 2.7666757773658901e-13,
	-1.8129941992128806e-13}, /* L902 */
{5.6498566436073245e+00, 5.6641497048204315e-13,
	2.2204460492503131e-16, 2.2870594307278225e-13,
	-8.2711615334574162e-14}, /* L903 */
{6.6161608808319823e+00, 6.6402439102830613e-13,
	2.2204460492503131e-16, 7.0898842352562497e-13,
	2.3647750424515834e-13}, /* L904 */
{6.5620269274986978e+00, 6.5931982096145703e-13,
	2.2204460492503131e-16, 3.0713209753230331e-12,
	4.4098058538111218e-13}, /* L905 */
{5.3918407363253227e+00, 5.4234394752938897e-13,
	2.2204460492503131e-16, -5.6288307348495437e-14,
	5.0626169922907138e-14}, /* L906 */
{6.4586650961645065e+00, 6.5036864782541670e-13,
	2.2204460492503131e-16, 1.3877787807814457e-13,
	1.2745360322696797e-13}, /* L907 */
{5.9894092292604926e+00, 6.0378091415458357e-13,
	2.2204460492503131e-16, 1.6608936448392342e-13,
	-5.2413628992553640e-13}, /* L908 */
{6.0110105837217995e+00, 6.0662586065518553e-13,
	2.2204460492503131e-16, 5.9952043329758453e-15,
	0.0000000000000000e+00}, /* L909 */
{7.4802315818335163e+00, 7.5572881286234406e-13,
	2.2204460492503131e-16, 9.1038288019262836e-15,
	-5.5844218138645374e-14}, /* L910 */
{5.7409530750861135e+00, 5.8064664187895687e-13,
	2.2204460492503131e-16, 1.0773604230962519e-12,
	6.7301719752776989e-13}, /* L911 */
{5.4082330733706163e+00, 5.4759538917203976e-13,
	2.2204460492503131e-16, 6.2074789752841752e-12,
	2.5446311724408588e-13}, /* L912 */
{6.0695605069769449e+00, 6.1523008909603050e-13,
	2.2204460492503131e-16, 7.8159700933611020e-14,
	8.8173912615729932e-13}, /* L913 */
{5.3424591946982369e+00, 5.4212190292446394e-13,
	2.2204460492503131e-16, 5.7509552675583109e-14,
	1.4432899320127035e-14}, /* L914 */
{6.4967998675248886e+00, 6.5997901588232821e-13,
	2.2204460492503131e-16, 4.6007642140466487e-13,
	-1.1679546219056647e-13}, /* L915 */
{8.3286157600311341e+00, 8.4698914548653192e-13,
	2.2204460492503131e-16, -1.0836886943366153e-12,
	5.4738436006118718e-12}, /* L916 */
{5.7050253585466058e+00, 5.8081317533265064e-13,
	2.2204460492503131e-16, 5.9063864910058328e-14,
	-5.2957638274619967e-14}, /* L917 */
{6.2497375289061452e+00, 6.3696270480306794e-13,
	2.2204460492503131e-16, 6.4828142853912141e-12,
	1.7120971307349464e-11}, /* L918 */
{6.8438628106442314e+00, 6.9827477133799221e-13,
	2.2204460492503131e-16, -4.1255887595070817e-13,
	-1.2259082637910979e-12}, /* L919 */
{4.3652242783491957e+00, 4.4586556668946287e-13,
	2.2204460492503131e-16, -3.4305891460917337e-14,
	-6.0951244051921094e-14}, /* L920 */
{5.4169466570949103e+00, 5.5389026698549060e-13,
	2.2204460492503131e-16, 1.2545520178264269e-13,
	-3.2462921240039577e-13}, /* L921 */
{7.2790244993458266e+00, 7.4509842740155818e-13,
	2.2204460492503131e-16, -5.8553162318730756e-13,
	-9.1049390249509088e-13}, /* L922 */
{7.4723844869470630e+00, 7.6572082008397047e-13,
	2.2204460492503131e-16, -6.0473848151332277e-13,
	-9.7155616884947449e-13}, /* L923 */
{5.7401335151183037e+00, 5.8884841447337521e-13,
	2.2204460492503131e-16, 5.9752203185325925e-13,
	4.7628567756419216e-13}, /* L924 */
{6.8702811095482161e+00, 7.0554673214928698e-13,
	2.2204460492503131e-16, 1.3373746554634636e-12,
	-5.6343818499726694e-13}, /* L925 */
{7.1352704366279394e+00, 7.3355210794545656e-13,
	2.2204460492503131e-16, -1.5898393712632242e-13,
	-5.3135273958559992e-13}, /* L926 */
{6.8615264673284395e+00, 7.0617123260063863e-13,
	2.2204460492503131e-16, 3.8724579098925460e-13,
	-1.9695356456850277e-13}, /* L927 */
{8.3223124297326248e+00, 8.5743565025886426e-13,
	2.2204460492503131e-16, -1.8762769116165146e-14,
	-2.0916601783937949e-13}, /* L928 */
{6.1076522625589762e+00, 6.2994054417231382e-13,
	2.2204460492503131e-16, -1.0922374116262290e-12,
	3.9745984281580604e-13}, /* L929 */
{5.7371058256590963e+00, 5.9235949478875227e-13,
	2.2204460492503131e-16, 1.9051427102567686e-13,
	-9.2148511043887993e-15}, /* L930 */
{5.7754018347697622e+00, 5.9695477727661483e-13,
	2.2204460492503131e-16, 1.3011813848606835e-13,
	6.4170890823334048e-14}, /* L931 */
{5.0944286380281163e+00, 5.2713389209202433e-13,
	2.2204460492503131e-16, 7.9602990865623724e-13,
	-1.0729306332279975e-11}, /* L932 */
{6.8419186187562095e+00, 7.0871086776946868e-13,
	2.2204460492503131e-16, 3.6703973194107675e-13,
	-2.0605739337042905e-13}, /* L933 */
{5.2251153100776309e+00, 5.4181659159269202e-13,
	2.2204460492503131e-16, 5.7420734833613096e-13,
	2.2071233729548112e-13}, /* L934 */
{7.2866425122241756e+00, 7.5639494667711915e-13,
	2.2204460492503131e-16, -1.1513012765362873e-13,
	-1.4210854715202004e-13}, /* L935 */
{6.4204161123026866e+00, 6.6718852664848782e-13,
	2.2204460492503131e-16, -1.6613377340490842e-12,
	6.1659566341631944e-12}, /* L936 */
{6.6739699746026320e+00, 6.9427796844934164e-13,
	2.2204460492503131e-16, -1.3078427230084344e-13,
	4.5075054799781356e-14}, /* L937 */
{1.2145808075096838e+01, 1.2648493363798252e-12,
	2.2204460492503131e-16, 3.6592950891645160e-13,
	-5.6510351953420468e-14}, /* L938 */
{5.7412896757451124e+00, 5.9852817146932580e-13,
	2.2204460492503131e-16, 2.3891999489933369e-13,
	8.8551388444102486e-13}, /* L939 */
{7.2005432752390668e+00, 7.5145445421753720e-13,
	2.2204460492503131e-16, 1.1635137298071641e-13,
	-1.0236256287043943e-13}, /* L940 */
{5.7771079456143672e+00, 6.0354499176185072e-13,
	2.2204460492503131e-16, -6.0063065632220969e-14,
	-9.2148511043887993e-15}, /* L941 */
{6.3935875818928034e+00, 6.6865957215611616e-13,
	2.2204460492503131e-16, 6.7101879608344461e-13,
	1.4632739464559563e-13}, /* L942 */
{7.9660783157471782e+00, 8.3399953609841759e-13,
	2.2204460492503131e-16, -1.2623235789988030e-13,
	-1.3000711618360583e-13}, /* L943 */
{8.0042499164981002e+00, 8.3888451740676828e-13,
	2.2204460492503131e-16, 9.6811447747313650e-14,
	1.1080025785759062e-13}, /* L944 */
{5.5423367865117710e+00, 5.8147930914742574e-13,
	2.2204460492503131e-16, -9.3258734068513149e-15,
	8.9706020389712648e-14}, /* L945 */
{4.9785950983894214e+00, 5.2288728902283310e-13,
	2.2204460492503131e-16, -9.9031893796563963e-14,
	3.1530333899354446e-14}, /* L946 */
{5.9493148385068846e+00, 6.2549965207381319e-13,
	2.2204460492503131e-16, 2.9665159217984183e-13,
	6.9411143499564787e-13}, /* L947 */
{5.5200433228603947e+00, 5.8097970878634442e-13,
	2.2204460492503131e-16, 1.6053824936079764e-13,
	2.1138646388862981e-13}, /* L948 */
{9.1543748961749980e+00, 9.6450625264310474e-13,
	2.2204460492503131e-16, -1.2656542480726785e-14,
	-1.4288570326925765e-13}, /* L949 */
{7.9917779498801425e+00, 8.4290213697713057e-13,
	2.2204460492503131e-16, -7.1322947547969306e-12,
	1.0939693595446442e-11}, /* L950 */
{5.7429033825442684e+00, 6.0634830489902924e-13,
	2.2204460492503131e-16, -4.7295500849031669e-14,
	-2.9531932455029164e-14}, /* L951 */
{9.0120816747706520e+00, 9.5251584397715305e-13,
	2.2204460492503131e-16, 2.0716761639505421e-13,
	3.2818192607919627e-13}, /* L952 */
{5.5419738509783443e+00, 5.8636429045577643e-13,
	2.2204460492503131e-16, 1.1430856261540612e-12,
	1.9073631563060189e-13}, /* L953 */
{6.6457036650126691e+00, 7.0388139761234925e-13,
	2.2204460492503131e-16, -4.4741987892393809e-14,
	9.6989083431253675e-13}, /* L954 */
{6.7844254710858785e+00, 7.1932737544244674e-13,
	2.2204460492503131e-16, 8.2378548427186615e-14,
	7.4895645241213060e-13}, /* L955 */
{5.8969677330262291e+00, 6.2588823013243200e-13,
	2.2204460492503131e-16, 1.5756285165480222e-12,
	-6.2350125062948791e-13}, /* L956 */
{6.2560096387215491e+00, 6.6469052484308122e-13,
	2.2204460492503131e-16, -1.8529622280993863e-13,
	-1.6375789613221059e-13}, /* L957 */
{6.3230701864951318e+00, 6.7251759716668857e-13,
	2.2204460492503131e-16, -5.6066262743570405e-14,
	6.9122485513162246e-13}, /* L958 */
{7.8183019115466514e+00, 8.3241746828832675e-13,
	2.2204460492503131e-16, 1.6298074001497298e-13,
	8.6197715631897154e-13}, /* L959 */
{6.1161470839986061e+00, 6.5186744890866066e-13,
	2.2204460492503131e-16, 6.1728400169158704e-14,
	-6.3837823915946501e-14}, /* L960 */
{7.2702278133979918e+00, 7.7567813283607734e-13,
	2.2204460492503131e-16, 2.4646951146678475e-14,
	-1.3233858453531866e-13}, /* L961 */
{7.6190244270021266e+00, 8.1373796589900849e-13,
	2.2204460492503131e-16, -2.5546231796624852e-13,
	-1.8451906669270102e-13}, /* L962 */
{6.2887473918772070e+00, 6.7235800260689871e-13,
	2.2204460492503131e-16, -1.9761969838327786e-14,
	4.3898218393678690e-13}, /* L963 */
{5.2842334456957394e+00, 5.6554760874405474e-13,
	2.2204460492503131e-16, -2.0439205883349132e-13,
	-1.0547118733938987e-13}, /* L964 */
{5.4717627769255186e+00, 5.8622551257769828e-13,
	2.2204460492503131e-16, -9.8365759981788869e-14,
	2.7600144392181392e-13}, /* L965 */
{5.9075330726337585e+00, 6.3356828464145032e-13,
	2.2204460492503131e-16, -4.6063153291697745e-13,
	-3.7414515929867775e-14}, /* L966 */
{5.1013454071626922e+00, 5.4767301804758972e-13,
	2.2204460492503131e-16, 1.6964207816272392e-13,
	2.2404300636935659e-13}, /* L967 */
{6.4925116581854301e+00, 6.9774741540129526e-13,
	2.2204460492503131e-16, -4.2765790908561030e-13,
	1.6875389974302379e-13}, /* L968 */
{7.4649138071625760e+00, 8.0307982486260698e-13,
	2.2204460492503131e-16, -4.5652370772586437e-13,
	-4.0734082773496993e-13}, /* L969 */
{5.5734547479374452e+00, 6.0021432268797525e-13,
	2.2204460492503131e-16, 2.1760371282653068e-14,
	2.5512925105886097e-13}, /* L970 */
{6.3352227166676425e+00, 6.8295369359816505e-13,
	2.2204460492503131e-16, 3.5282887722587475e-13,
	-9.1426866077881641e-13}, /* L971 */
{5.8868324794816296e+00, 6.3526961469051457e-13,
	2.2204460492503131e-16, 7.2875039336395275e-13,
	-1.0487166690609229e-12}, /* L972 */
{8.2368978816519807e+00, 8.8978824308583171e-13,
	2.2204460492503131e-16, -2.4846791291111003e-13,
	-1.8229862064345070e-13}, /* L973 */
{6.6881430513937419e+00, 7.2322703381644260e-13,
	2.2204460492503131e-16, -7.8315132157058542e-13,
	-8.0135897917443799e-13}, /* L974 */
{6.1676935688946646e+00, 6.6763261585833789e-13,
	2.2204460492503131e-16, -5.6099569434309160e-13,
	-1.8873791418627661e-15}, /* L975 */
{5.5701855652531194e+00, 6.0357274733746635e-13,
	2.2204460492503131e-16, -1.5420997812043424e-13,
	5.4400928206632670e-14}, /* L976 */
{7.8779442926050924e+00, 8.5451090647836736e-13,
	2.2204460492503131e-16, 6.3504757008558954e-14,
	2.4646951146678475e-14}, /* L977 */
{5.5820563561720062e+00, 6.0609850471848858e-13,
	2.2204460492503131e-16, -1.6908696665041134e-13,
	-1.6475709685437323e-13}, /* L978 */
{5.5985711141799230e+00, 6.0851323979704830e-13,
	2.2204460492503131e-16, 1.8962609260597674e-13,
	9.3325347449990659e-13}, /* L979 */
{5.6237256397473212e+00, 6.1187166444653940e-13,
	2.2204460492503131e-16, -1.4513945600924671e-12,
	1.7341683644644945e-12}, /* L980 */
{6.8784417735103931e+00, 7.4915074144144000e-13,
	2.2204460492503131e-16, -1.5032419753424620e-13,
	4.3742787170231168e-14}, /* L981 */
{5.4032597606835173e+00, 5.8908433686610806e-13,
	2.2204460492503131e-16, 2.6467716907063732e-13,
	1.0744738432322265e-12}, /* L982 */
{9.4165838177238648e+00, 1.0276779427442762e-12,
	2.2204460492503131e-16, -1.4566126083082054e-13,
	1.1857181902996672e-13}, /* L983 */
{6.6580298167526362e+00, 7.2736261458317131e-13,
	2.2204460492503131e-16, -2.4358293160275934e-13,
	-3.3195668436292181e-14}, /* L984 */
{7.8031741843907518e+00, 8.5333129451470313e-13,
	2.2204460492503131e-16, -4.9372728128105337e-12,
	1.1686207557204398e-12}, /* L985 */
{4.6729218480402608e+00, 5.1153525859604088e-13,
	2.2204460492503131e-16, -3.6404212977458883e-13,
	-9.8698826889176416e-14}, /* L986 */
{5.8839930978234314e+00, 6.4476202155105966e-13,
	2.2204460492503131e-16, -9.3147711766050634e-14,
	1.6409096303959814e-13}, /* L987 */
{6.5222685401886586e+00, 7.1542771706845087e-13,
	2.2204460492503131e-16, 1.2811973704174306e-13,
	3.2640556923979602e-14}, /* L988 */
{7.8667862395848669e+00, 8.6378126873398742e-13,
	2.2204460492503131e-16, -4.2255088317233458e-13,
	5.0737192225369654e-13}, /* L989 */
{7.8873753502293731e+00, 8.6691764877855348e-13,
	2.2204460492503131e-16, 2.2892798767770728e-13,
	3.3972824553529790e-13}, /* L990 */
{5.7462171185053030e+00, 6.3221650137279539e-13,
	2.2204460492503131e-16, -2.5346391652192324e-13,
	5.8308913253313222e-13}, /* L991 */
{6.6491949080503927e+00, 7.3230310704275325e-13,
	2.2204460492503131e-16, 3.1996627569697011e-13,
	1.2234657731369225e-13}, /* L992 */
{7.7170207119571588e+00, 8.5076390377025746e-13,
	2.2204460492503131e-16, 3.8480330033507926e-13,
	1.1279865930191590e-13}, /* L993 */
{8.8531205225593030e+00, 9.7699626167013776e-13,
	2.2204460492503131e-16, -1.5994983115774630e-12,
	4.8849813083506888e-14}, /* L994 */
{7.1907049879862042e+00, 7.9433681854368388e-13,
	2.2204460492503131e-16, -2.2981616609740740e-14,
	7.4162898044960457e-14}, /* L995 */
{5.9713867632325286e+00, 6.6030514389581185e-13,
	2.2204460492503131e-16, -9.8809849191638932e-15,
	1.8718360195180139e-13}, /* L996 */
{6.4869622091298975e+00, 7.1803674117631999e-13,
	2.2204460492503131e-16, -1.0980105713542798e-13,
	1.8007817459420039e-13}, /* L997 */
{6.1465443430530451e+00, 6.8103855888068665e-13,
	2.2204460492503131e-16, 4.6629367034256575e-14,
	-1.4377388168895777e-13}, /* L998 */
{6.9334348512168074e+00, 7.6899597800661468e-13,
	2.2204460492503131e-16, 5.1292303737682232e-14,
	-3.9412917374193057e-14}, /* L999 */
{7.2375014799653465e+00, 8.0352391407245705e-13,
	2.2204460492503131e-16, -3.5860203695392556e-14,
	-1.8474111129762605e-13}, /* L1000 */
{1.0704751534462535e+01, 2.3769319845712289e-12,
	2.2204460492503131e-16, -5.1324500205396362e-12,
	2.5088819910479288e-12}, /* L1001 */
{1.9969666668716467e+01, 6.6512351182268503e-12,
	2.2204460492503131e-16, -7.0245698147175517e-11,
	9.7082342165322189e-12}, /* L1002 */
{2.5142056782565259e+01, 1.1209977390791437e-11,
	2.2204460492503131e-16, 5.4001247917767614e-13,
	-5.6191717945353048e-12}, /* L1003 */
{2.8323200010548174e+01, 1.5722534385531617e-11,
	2.2204460492503131e-16, -3.7680969455777813e-12,
	-3.6082248300317588e-12}, /* L1004 */
{3.2321791678561532e+01, 2.1530638383282508e-11,
	2.2204460492503131e-16, 1.4333201292515696e-11,
	6.5796257331385277e-12}, /* L1005 */
{3.7391747446514401e+01, 2.9125646339167588e-11,
	2.2204460492503131e-16, -2.7823965353945823e-11,
	-1.8096635301390052e-11}, /* L1006 */
{3.7803989307095556e+01, 3.3719388392583483e-11,
	2.2204460492503131e-16, 1.4442225193533886e-11,
	1.2765566381744975e-11}, /* L1007 */
{4.6061583130257695e+01, 4.6024767330621330e-11,
	2.2204460492503131e-16, -8.7482243671388460e-11,
	9.2451313271624258e-10}, /* L1008 */
{6.2174100014595624e+01, 6.9027117355346945e-11,
	2.2204460492503131e-16, -4.0004777268620728e-11,
	1.7784218542260533e-11}, /* L1009 */
#else  /* }  { */


/* Start of SP golden values */


{0.0000000000000000e+00, 0.0000000000000000e+00,
	0.0000000000000000e+00, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L0 */
{0.0000000000000000e+00, 0.0000000000000000e+00,
	1.1920928955078125e-07, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L1 */
{0.0000000000000000e+00, 0.0000000000000000e+00,
	1.1920928955078125e-07, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L2 */
{6.8018096685409546e-01, 1.1920928955078125e-07,
	1.1920928955078125e-07, -5.9604644775390625e-08,
	-1.1920928955078125e-07}, /* L3 */
{8.9273703098297119e-01, 2.0861625671386719e-07,
	1.1920928955078125e-07, -1.1920928955078125e-07,
	-2.3841857910156250e-07}, /* L4 */
{7.1418994665145874e-01, 2.0861625671386719e-07,
	1.1920928955078125e-07, -5.9604644775390625e-08,
	1.1920928955078125e-07}, /* L5 */
{3.6134567856788635e-01, 1.2665987014770508e-07,
	1.1920928955078125e-07, 2.3841857910156250e-07,
	7.1525573730468750e-07}, /* L6 */
{4.3648514151573181e-01, 1.7881393432617188e-07,
	1.1920928955078125e-07, -5.9604644775390625e-08,
	3.5762786865234375e-07}, /* L7 */
{4.7549185156822205e-01, 2.2351741790771484e-07,
	1.1920928955078125e-07, 3.6954879760742188e-06,
	-5.9604644775390625e-07}, /* L8 */
{4.2266038060188293e-01, 2.2351741790771484e-07,
	1.1920928955078125e-07, 4.7683715820312500e-07,
	8.3446502685546875e-07}, /* L9 */
{4.0575435757637024e-01, 2.3841857910156250e-07,
	1.1920928955078125e-07, 3.5762786865234375e-07,
	3.5762786865234375e-07}, /* L10 */
{3.2275927066802979e-01, 2.0861625671386719e-07,
	1.1920928955078125e-07, -1.1920928955078125e-07,
	1.1920928955078125e-07}, /* L11 */
{2.9586255550384521e-01, 2.0861625671386719e-07,
	1.1920928955078125e-07, -1.1920928955078125e-07,
	-2.3841857910156250e-07}, /* L12 */
{7.8410917520523071e-01, 6.0349702835083008e-07,
	1.1920928955078125e-07, 7.1525573730468750e-07,
	-7.1525573730468750e-07}, /* L13 */
{3.5955643653869629e-01, 2.9802322387695312e-07,
	1.1920928955078125e-07, -3.5762786865234375e-07,
	-3.5762786865234375e-07}, /* L14 */
{4.0270313620567322e-01, 3.5762786865234375e-07,
	1.1920928955078125e-07, -2.3841857910156250e-07,
	3.5762786865234375e-07}, /* L15 */
{2.9888099431991577e-01, 2.8312206268310547e-07,
	1.1920928955078125e-07, -7.1525573730468750e-07,
	-1.1920928955078125e-07}, /* L16 */
{5.8850812911987305e-01, 5.9232115745544434e-07,
	1.1920928955078125e-07, -1.7285346984863281e-06,
	3.5762786865234375e-07}, /* L17 */
{5.0337857007980347e-01, 5.3644180297851562e-07,
	1.1920928955078125e-07, -4.7683715820312500e-07,
	-4.7683715820312500e-07}, /* L18 */
{4.5867058634757996e-01, 5.1595270633697510e-07,
	1.1920928955078125e-07, 7.1525573730468750e-07,
	-1.2516975402832031e-06}, /* L19 */
{4.7820881009101868e-01, 5.6624412536621094e-07,
	1.1920928955078125e-07, 0.0000000000000000e+00,
	-1.0728836059570312e-06}, /* L20 */
{9.7883027791976929e-01, 1.2218952178955078e-06,
	1.1920928955078125e-07, 8.3446502685546875e-07,
	2.3841857910156250e-07}, /* L21 */
{4.2159116268157959e-01, 5.5134296417236328e-07,
	1.1920928955078125e-07, -2.6822090148925781e-06,
	-8.9406967163085938e-07}, /* L22 */
{5.0135254859924316e-01, 6.8545341491699219e-07,
	1.1920928955078125e-07, 1.1920928955078125e-07,
	-1.7881393432617188e-07}, /* L23 */
{1.0027021169662476e+00, 1.4305114746093750e-06,
	1.1920928955078125e-07, -3.6954879760742188e-06,
	-2.3841857910156250e-07}, /* L24 */
{7.2194659709930420e-01, 1.0728836059570312e-06,
	1.1920928955078125e-07, -5.3644180297851562e-07,
	4.7683715820312500e-07}, /* L25 */
{3.9529633522033691e-01, 6.1094760894775391e-07,
	1.1920928955078125e-07, -1.6093254089355469e-06,
	1.1920928955078125e-07}, /* L26 */
{5.9419322013854980e-01, 9.5367431640625000e-07,
	1.1920928955078125e-07, 2.2649765014648438e-06,
	0.0000000000000000e+00}, /* L27 */
{5.9087789058685303e-01, 9.8347663879394531e-07,
	1.1920928955078125e-07, 2.2649765014648438e-06,
	-2.9802322387695312e-06}, /* L28 */
{6.3101136684417725e-01, 1.0877847671508789e-06,
	1.1920928955078125e-07, 2.3841857910156250e-07,
	1.1920928955078125e-06}, /* L29 */
{1.1363973617553711e+00, 2.0265579223632812e-06,
	1.1920928955078125e-07, -5.9604644775390625e-07,
	2.3841857910156250e-07}, /* L30 */
{5.0943696498870850e-01, 9.3877315521240234e-07,
	1.1920928955078125e-07, 2.8610229492187500e-06,
	-3.1590461730957031e-06}, /* L31 */
{9.7332048416137695e-01, 1.8514692783355713e-06,
	1.1920928955078125e-07, -5.9604644775390625e-07,
	7.2717666625976562e-06}, /* L32 */
{8.8116312026977539e-01, 1.7285346984863281e-06,
	1.1920928955078125e-07, 1.0728836059570312e-06,
	-1.0132789611816406e-06}, /* L33 */
{1.0469392538070679e+00, 2.1159648895263672e-06,
	1.1920928955078125e-07, 0.0000000000000000e+00,
	-1.7285346984863281e-06}, /* L34 */
{6.3979321718215942e-01, 1.3336539268493652e-06,
	1.1920928955078125e-07, -1.1920928955078125e-07,
	1.4305114746093750e-06}, /* L35 */
{9.8686885833740234e-01, 2.1159648895263672e-06,
	1.1920928955078125e-07, 2.7179718017578125e-05,
	-2.1398067474365234e-05}, /* L36 */
{5.1392030715942383e-01, 1.1324882507324219e-06,
	1.1920928955078125e-07, 3.0994415283203125e-06,
	-1.0728836059570312e-06}, /* L37 */
{5.0039225816726685e-01, 1.1324882507324219e-06,
	1.1920928955078125e-07, 4.2915344238281250e-06,
	1.1920928955078125e-07}, /* L38 */
{8.0833417177200317e-01, 1.8775463104248047e-06,
	1.1920928955078125e-07, 9.5367431640625000e-07,
	-4.7683715820312500e-07}, /* L39 */
{6.4095199108123779e-01, 1.5273690223693848e-06,
	1.1920928955078125e-07, -9.3042850494384766e-05,
	2.2375583648681641e-04}, /* L40 */
{1.0251988172531128e+00, 2.5033950805664062e-06,
	1.1920928955078125e-07, -2.5629997253417969e-06,
	-2.5629997253417969e-06}, /* L41 */
{7.3866742849349976e-01, 1.8477439880371094e-06,
	1.1920928955078125e-07, -3.5762786865234375e-07,
	1.0728836059570312e-06}, /* L42 */
{1.1637136936187744e+00, 2.9802322387695312e-06,
	1.1920928955078125e-07, 1.9073486328125000e-06,
	-9.5367431640625000e-07}, /* L43 */
{6.5105575323104858e-01, 1.7061829566955566e-06,
	1.1920928955078125e-07, -1.5676021575927734e-05,
	1.1682510375976562e-05}, /* L44 */
{8.4511369466781616e-01, 2.2649765014648438e-06,
	1.1920928955078125e-07, -4.7683715820312500e-07,
	-6.1392784118652344e-06}, /* L45 */
{1.0660614967346191e+00, 2.9206275939941406e-06,
	1.1920928955078125e-07, -5.5432319641113281e-06,
	-1.7881393432617188e-06}, /* L46 */
{1.0486901998519897e+00, 2.9355287551879883e-06,
	1.1920928955078125e-07, 1.1920928955078125e-07,
	-6.5565109252929688e-07}, /* L47 */
{8.1313973665237427e-01, 2.3245811462402344e-06,
	1.1920928955078125e-07, 2.2649765014648438e-06,
	7.1525573730468750e-07}, /* L48 */
{1.0204066038131714e+00, 2.9802322387695312e-06,
	1.1920928955078125e-07, 1.0013580322265625e-05,
	-3.5762786865234375e-07}, /* L49 */
{8.1000715494155884e-01, 2.4139881134033203e-06,
	1.1920928955078125e-07, -1.7881393432617188e-06,
	-3.0398368835449219e-06}, /* L50 */
{9.7052782773971558e-01, 2.9504299163818359e-06,
	1.1920928955078125e-07, 6.0796737670898438e-06,
	-2.6702880859375000e-05}, /* L51 */
{6.6346895694732666e-01, 2.0563602447509766e-06,
	1.1920928955078125e-07, -1.0728836059570312e-06,
	-1.1324882507324219e-06}, /* L52 */
{8.2547765970230103e-01, 2.6077032089233398e-06,
	1.1920928955078125e-07, 7.1525573730468750e-07,
	7.1525573730468750e-07}, /* L53 */
{1.0555671453475952e+00, 3.3974647521972656e-06,
	1.1920928955078125e-07, 3.5762786865234375e-07,
	-7.1525573730468750e-07}, /* L54 */
{6.0000658035278320e-01, 1.9669532775878906e-06,
	1.1920928955078125e-07, -1.0132789611816406e-06,
	-5.9604644775390625e-08}, /* L55 */
{6.0714846849441528e-01, 2.0265579223632812e-06,
	1.1920928955078125e-07, -5.8412551879882812e-06,
	-1.4305114746093750e-06}, /* L56 */
{6.2719875574111938e-01, 2.1308660507202148e-06,
	1.1920928955078125e-07, -3.4570693969726562e-06,
	-8.3446502685546875e-07}, /* L57 */
{7.5642675161361694e-01, 2.6151537895202637e-06,
	1.1920928955078125e-07, -3.0875205993652344e-05,
	-1.6927719116210938e-05}, /* L58 */
{7.1186864376068115e-01, 2.5033950805664062e-06,
	1.1920928955078125e-07, -4.4107437133789062e-06,
	-4.2319297790527344e-06}, /* L59 */
{5.5729919672012329e-01, 1.9930303096771240e-06,
	1.1920928955078125e-07, 5.9604644775390625e-07,
	1.0728836059570312e-06}, /* L60 */
{9.2214035987854004e-01, 3.3527612686157227e-06,
	1.1920928955078125e-07, -2.3841857910156250e-07,
	2.3841857910156250e-06}, /* L61 */
{1.1209777593612671e+00, 4.1425228118896484e-06,
	1.1920928955078125e-07, -8.3446502685546875e-07,
	-3.3378601074218750e-06}, /* L62 */
{8.2143312692642212e-01, 3.0845403671264648e-06,
	1.1920928955078125e-07, 2.0265579223632812e-06,
	1.4305114746093750e-06}, /* L63 */
{9.1016262769699097e-01, 3.4719705581665039e-06,
	1.1920928955078125e-07, 4.7683715820312500e-07,
	-7.2121620178222656e-06}, /* L64 */
{8.4808546304702759e-01, 3.2857060432434082e-06,
	1.1920928955078125e-07, 3.8146972656250000e-06,
	-1.7285346984863281e-06}, /* L65 */
{7.8788590431213379e-01, 3.0994415283203125e-06,
	1.1920928955078125e-07, -4.7087669372558594e-06,
	2.0265579223632812e-06}, /* L66 */
{8.2463252544403076e-01, 3.2931566238403320e-06,
	1.1920928955078125e-07, -2.3841857910156250e-07,
	-1.9073486328125000e-06}, /* L67 */
{8.6029779911041260e-01, 3.4868717193603516e-06,
	1.1920928955078125e-07, 1.5497207641601562e-06,
	1.9073486328125000e-06}, /* L68 */
{8.8033676147460938e-01, 3.6209821701049805e-06,
	1.1920928955078125e-07, -5.0604343414306641e-05,
	-1.2701749801635742e-04}, /* L69 */
{1.2535502910614014e+00, 5.2303075790405273e-06,
	1.1920928955078125e-07, 8.4638595581054688e-06,
	1.1920928955078125e-06}, /* L70 */
{9.0141552686691284e-01, 3.8146972656250000e-06,
	1.1920928955078125e-07, 2.2649765014648438e-06,
	3.3378601074218750e-06}, /* L71 */
{7.7777242660522461e-01, 3.3378601074218750e-06,
	1.1920928955078125e-07, -9.0599060058593750e-06,
	-1.4185905456542969e-05}, /* L72 */
{1.0034232139587402e+00, 4.3660402297973633e-06,
	1.1920928955078125e-07, -1.0013580322265625e-05,
	2.9802322387695312e-06}, /* L73 */
{8.9863836765289307e-01, 3.9637088775634766e-06,
	1.1920928955078125e-07, -7.4505805969238281e-06,
	-6.9737434387207031e-06}, /* L74 */
{1.0266774892807007e+00, 4.5895576477050781e-06,
	1.1920928955078125e-07, 1.6689300537109375e-06,
	-7.7486038208007812e-07}, /* L75 */
{6.6445106267929077e-01, 3.0100345611572266e-06,
	1.1920928955078125e-07, -2.8014183044433594e-05,
	-2.6226043701171875e-05}, /* L76 */
{1.2500019073486328e+00, 5.7369470596313477e-06,
	1.1920928955078125e-07, 1.0728836059570312e-06,
	-2.9802322387695312e-07}, /* L77 */
{1.0576709508895874e+00, 4.9173831939697266e-06,
	1.1920928955078125e-07, 4.7683715820312500e-07,
	1.9669532775878906e-05}, /* L78 */
{8.0380576848983765e-01, 3.7848949432373047e-06,
	1.1920928955078125e-07, -2.9802322387695312e-07,
	1.3113021850585938e-06}, /* L79 */
{6.3124734163284302e-01, 3.0100345611572266e-06,
	1.1920928955078125e-07, -7.3313713073730469e-06,
	-4.0531158447265625e-06}, /* L80 */
{1.2044825553894043e+00, 5.8151781558990479e-06,
	1.1920928955078125e-07, 2.8610229492187500e-06,
	-4.4107437133789062e-06}, /* L81 */
{8.1098091602325439e-01, 3.9637088775634766e-06,
	1.1920928955078125e-07, 2.6226043701171875e-06,
	-5.0067901611328125e-06}, /* L82 */
{1.2168718576431274e+00, 6.0200691223144531e-06,
	1.1920928955078125e-07, 1.4305114746093750e-06,
	-1.4901161193847656e-06}, /* L83 */
{5.6548178195953369e-01, 2.8312206268310547e-06,
	1.1920928955078125e-07, 5.1259994506835938e-06,
	-1.6689300537109375e-06}, /* L84 */
{1.3882204294204712e+00, 7.0333480834960938e-06,
	1.1920928955078125e-07, 2.8610229492187500e-06,
	1.5497207641601562e-06}, /* L85 */
{1.7107630968093872e+00, 8.7693333625793457e-06,
	1.1920928955078125e-07, 6.7949295043945312e-06,
	3.0994415283203125e-06}, /* L86 */
{8.1896400451660156e-01, 4.2468309402465820e-06,
	1.1920928955078125e-07, 5.2452087402343750e-06,
	5.4836273193359375e-06}, /* L87 */
{7.6276636123657227e-01, 4.0009617805480957e-06,
	1.1920928955078125e-07, 1.5497207641601562e-06,
	2.9802322387695312e-06}, /* L88 */
{8.0899810791015625e-01, 4.2915344238281250e-06,
	1.1920928955078125e-07, -2.2053718566894531e-06,
	1.1920928955078125e-07}, /* L89 */
{8.7223005294799805e-01, 4.6789646148681641e-06,
	1.1920928955078125e-07, -2.2649765014648438e-06,
	-1.1920928955078125e-06}, /* L90 */
{8.2417380809783936e-01, 4.4703483581542969e-06,
	1.1920928955078125e-07, 8.5830688476562500e-06,
	1.2516975402832031e-05}, /* L91 */
{7.5204324722290039e-01, 4.1238963603973389e-06,
	1.1920928955078125e-07, 1.3113021850585938e-06,
	-5.0663948059082031e-06}, /* L92 */
{1.4193508625030518e+00, 7.8678131103515625e-06,
	1.1920928955078125e-07, 9.6559524536132812e-06,
	0.0000000000000000e+00}, /* L93 */
{9.6275132894515991e-01, 5.3942203521728516e-06,
	1.1920928955078125e-07, -6.2584877014160156e-06,
	-3.3974647521972656e-06}, /* L94 */
{9.3683904409408569e-01, 5.3048133850097656e-06,
	1.1920928955078125e-07, -5.9008598327636719e-06,
	5.3644180297851562e-06}, /* L95 */
{1.0781044960021973e+00, 6.1690807342529297e-06,
	1.1920928955078125e-07, 7.1525573730468750e-06,
	1.6689300537109375e-06}, /* L96 */
{1.0644396543502808e+00, 6.1541795730590820e-06,
	1.1920928955078125e-07, -1.3113021850585938e-06,
	3.4570693969726562e-06}, /* L97 */
{9.8469865322113037e-01, 5.7518482208251953e-06,
	1.1920928955078125e-07, 2.2649765014648438e-06,
	-5.4240226745605469e-06}, /* L98 */
{1.1337554454803467e+00, 6.6906213760375977e-06,
	1.1920928955078125e-07, -6.7949295043945312e-06,
	9.0599060058593750e-06}, /* L99 */
{9.7000402212142944e-01, 5.7816505432128906e-06,
	1.1920928955078125e-07, -2.0265579223632812e-06,
	1.0728836059570312e-06}, /* L100 */
{9.5541024208068848e-01, 5.7518482208251953e-06,
	1.1920928955078125e-07, -3.1709671020507812e-05,
	-8.5830688476562500e-06}, /* L101 */
{8.3822196722030640e-01, 5.0961971282958984e-06,
	1.1920928955078125e-07, -6.6757202148437500e-06,
	1.7881393432617188e-06}, /* L102 */
{1.9174509048461914e+00, 1.1771917343139648e-05,
	1.1920928955078125e-07, -5.0663948059082031e-06,
	-2.3245811462402344e-06}, /* L103 */
{1.0769299268722534e+00, 6.6757202148437500e-06,
	1.1920928955078125e-07, -2.4437904357910156e-06,
	2.8610229492187500e-06}, /* L104 */
{1.1833299398422241e+00, 7.4058771133422852e-06,
	1.1920928955078125e-07, -8.3446502685546875e-06,
	-1.7285346984863281e-06}, /* L105 */
{8.6897367238998413e-01, 5.4910778999328613e-06,
	1.1920928955078125e-07, 2.3961067199707031e-05,
	-4.7624111175537109e-05}, /* L106 */
{1.0105159282684326e+00, 6.4447522163391113e-06,
	1.1920928955078125e-07, -5.5432319641113281e-06,
	-1.4901161193847656e-06}, /* L107 */
{1.2222226858139038e+00, 7.8678131103515625e-06,
	1.1920928955078125e-07, -9.9539756774902344e-06,
	-1.0073184967041016e-05}, /* L108 */
{9.9771076440811157e-01, 6.4820051193237305e-06,
	1.1920928955078125e-07, 6.6757202148437500e-06,
	3.8146972656250000e-06}, /* L109 */
{8.5909843444824219e-01, 5.6326389312744141e-06,
	1.1920928955078125e-07, 1.7881393432617188e-06,
	-1.6689300537109375e-06}, /* L110 */
{1.0945979356765747e+00, 7.2419643402099609e-06,
	1.1920928955078125e-07, 1.7881393432617188e-06,
	4.7683715820312500e-06}, /* L111 */
{9.4642227888107300e-01, 6.3180923461914062e-06,
	1.1920928955078125e-07, -9.1791152954101562e-06,
	7.2717666625976562e-06}, /* L112 */
{9.4248169660568237e-01, 6.3478946685791016e-06,
	1.1920928955078125e-07, -1.5497207641601562e-06,
	-7.8678131103515625e-06}, /* L113 */
{1.0350898504257202e+00, 7.0333480834960938e-06,
	1.1920928955078125e-07, 1.4305114746093750e-06,
	-6.0200691223144531e-06}, /* L114 */
{1.2651975154876709e+00, 8.6724758148193359e-06,
	1.1920928955078125e-07, -1.4424324035644531e-05,
	1.0013580322265625e-05}, /* L115 */
{9.2753994464874268e-01, 6.4130872488021851e-06,
	1.1920928955078125e-07, -2.0265579223632812e-06,
	-4.7683715820312500e-06}, /* L116 */
{1.3073544502258301e+00, 9.1195106506347656e-06,
	1.1920928955078125e-07, 7.1644783020019531e-05,
	6.3896179199218750e-05}, /* L117 */
{9.6987730264663696e-01, 6.8247318267822266e-06,
	1.1920928955078125e-07, 3.6954879760742188e-06,
	-5.2165985107421875e-04}, /* L118 */
{9.7899848222732544e-01, 6.9439411163330078e-06,
	1.1920928955078125e-07, 2.0265579223632812e-06,
	-5.4836273193359375e-06}, /* L119 */
{8.6979395151138306e-01, 6.2212347984313965e-06,
	1.1920928955078125e-07, 1.4305114746093750e-06,
	-1.5497207641601562e-06}, /* L120 */
{9.7924292087554932e-01, 7.0631504058837891e-06,
	1.1920928955078125e-07, -4.1127204895019531e-05,
	1.7762184143066406e-05}, /* L121 */
{9.7541624307632446e-01, 7.0929527282714844e-06,
	1.1920928955078125e-07, -7.6293945312500000e-06,
	-1.0728836059570312e-06}, /* L122 */
{1.6664739847183228e+00, 1.2218952178955078e-05,
	1.1920928955078125e-07, -1.9609928131103516e-05,
	-1.3291835784912109e-05}, /* L123 */
{8.2053667306900024e-01, 6.0647726058959961e-06,
	1.1920928955078125e-07, -1.8298625946044922e-05,
	-2.4974346160888672e-05}, /* L124 */
{1.2599431276321411e+00, 9.3877315521240234e-06,
	1.1920928955078125e-07, 1.0609626770019531e-05,
	3.5762786865234375e-07}, /* L125 */
{1.3730195760726929e+00, 1.0311603546142578e-05,
	1.1920928955078125e-07, -1.5497207641601562e-06,
	-1.9669532775878906e-06}, /* L126 */
{1.4950799942016602e+00, 1.1317431926727295e-05,
	1.1920928955078125e-07, -1.1920928955078125e-07,
	-2.9802322387695312e-06}, /* L127 */
{8.7696063518524170e-01, 6.6906213760375977e-06,
	1.1920928955078125e-07, 3.9339065551757812e-06,
	0.0000000000000000e+00}, /* L128 */
{9.5106983184814453e-01, 7.3127448558807373e-06,
	1.1920928955078125e-07, -5.5432319641113281e-06,
	-6.6161155700683594e-06}, /* L129 */
{9.4996523857116699e-01, 7.3611736297607422e-06,
	1.1920928955078125e-07, 9.1791152954101562e-06,
	-3.5166740417480469e-06}, /* L130 */
{1.2995917797088623e+00, 1.0147690773010254e-05,
	1.1920928955078125e-07, 1.2397766113281250e-05,
	-2.5868415832519531e-05}, /* L131 */
{7.4620795249938965e-01, 5.8710575103759766e-06,
	1.1920928955078125e-07, 9.5367431640625000e-07,
	-2.0861625671386719e-06}, /* L132 */
{1.1202967166900635e+00, 8.8810920715332031e-06,
	1.1920928955078125e-07, -2.9802322387695312e-07,
	-8.5234642028808594e-06}, /* L133 */
{1.3694064617156982e+00, 1.0937452316284180e-05,
	1.1920928955078125e-07, 5.0067901611328125e-06,
	-6.6161155700683594e-06}, /* L134 */
{1.0537055730819702e+00, 8.4787607192993164e-06,
	1.1920928955078125e-07, -2.8610229492187500e-06,
	-4.7087669372558594e-06}, /* L135 */
{1.2646913528442383e+00, 1.0251998901367188e-05,
	1.1920928955078125e-07, -1.2874603271484375e-05,
	-3.1590461730957031e-06}, /* L136 */
{1.2353997230529785e+00, 1.0088086128234863e-05,
	1.1920928955078125e-07, 2.9802322387695312e-06,
	0.0000000000000000e+00}, /* L137 */
{1.0905735492706299e+00, 8.9704990386962891e-06,
	1.1920928955078125e-07, -1.7642974853515625e-05,
	-1.9550323486328125e-05}, /* L138 */
{1.2841809988021851e+00, 1.0639429092407227e-05,
	1.1920928955078125e-07, -2.2053718566894531e-06,
	-3.3378601074218750e-06}, /* L139 */
{1.1500061750411987e+00, 9.5963478088378906e-06,
	1.1920928955078125e-07, 5.1259994506835938e-06,
	-4.1723251342773438e-07}, /* L140 */
{1.3510324954986572e+00, 1.1354684829711914e-05,
	1.1920928955078125e-07, 1.2159347534179688e-05,
	1.5377998352050781e-05}, /* L141 */
{9.4499003887176514e-01, 7.9981982707977295e-06,
	1.1920928955078125e-07, -8.1062316894531250e-06,
	-1.0132789611816406e-06}, /* L142 */
{1.3810083866119385e+00, 1.1771917343139648e-05,
	1.1920928955078125e-07, 2.1457672119140625e-06,
	4.3511390686035156e-05}, /* L143 */
{1.1562519073486328e+00, 9.9241733551025391e-06,
	1.1920928955078125e-07, 2.3841857910156250e-07,
	9.2983245849609375e-06}, /* L144 */
{1.0793009996414185e+00, 9.3281269073486328e-06,
	1.1920928955078125e-07, -1.0728836059570312e-05,
	-1.5497207641601562e-06}, /* L145 */
{1.6061439514160156e+00, 1.3977289199829102e-05,
	1.1920928955078125e-07, 8.8214874267578125e-06,
	2.2649765014648438e-06}, /* L146 */
{1.0843659639358521e+00, 9.5013529062271118e-06,
	1.1920928955078125e-07, -4.5716762542724609e-05,
	-7.1525573730468750e-06}, /* L147 */
{1.2195807695388794e+00, 1.0758638381958008e-05,
	1.1920928955078125e-07, 1.1086463928222656e-05,
	-5.5432319641113281e-06}, /* L148 */
{1.0805189609527588e+00, 9.5963478088378906e-06,
	1.1920928955078125e-07, -5.7816505432128906e-06,
	-5.5432319641113281e-06}, /* L149 */
{1.2214741706848145e+00, 1.0922551155090332e-05,
	1.1920928955078125e-07, 4.6491622924804688e-06,
	3.4809112548828125e-05}, /* L150 */
{9.9667584896087646e-01, 8.9704990386962891e-06,
	1.1920928955078125e-07, -2.3365020751953125e-05,
	-1.6868114471435547e-05}, /* L151 */
{1.1175954341888428e+00, 1.0125339031219482e-05,
	1.1920928955078125e-07, 1.0728836059570312e-06,
	-2.3841857910156250e-06}, /* L152 */
{1.5759546756744385e+00, 1.4372169971466064e-05,
	1.1920928955078125e-07, -7.0333480834960938e-06,
	-1.6748905181884766e-05}, /* L153 */
{1.2970726490020752e+00, 1.1906027793884277e-05,
	1.1920928955078125e-07, 8.2254409790039062e-06,
	1.3113021850585938e-06}, /* L154 */
{1.3951190710067749e+00, 1.2889504432678223e-05,
	1.1920928955078125e-07, 2.3841857910156250e-07,
	3.2186508178710938e-05}, /* L155 */
{1.2964704036712646e+00, 1.2055039405822754e-05,
	1.1920928955078125e-07, 1.5139579772949219e-05,
	-1.1920928955078125e-06}, /* L156 */
{1.0063484907150269e+00, 9.4175338745117188e-06,
	1.1920928955078125e-07, -6.7949295043945312e-06,
	-2.3782253265380859e-05}, /* L157 */
{9.6187907457351685e-01, 9.0599060058593750e-06,
	1.1920928955078125e-07, -7.9274177551269531e-06,
	-2.8252601623535156e-05}, /* L158 */
{1.5304667949676514e+00, 1.4506280422210693e-05,
	1.1920928955078125e-07, 6.9260597229003906e-05,
	-3.3318996429443359e-05}, /* L159 */
{1.2531182765960693e+00, 1.1950731277465820e-05,
	1.1920928955078125e-07, -4.2319297790527344e-06,
	-8.0466270446777344e-06}, /* L160 */
{1.0869301557540894e+00, 1.0430812835693359e-05,
	1.1920928955078125e-07, -4.5299530029296875e-06,
	1.6331672668457031e-05}, /* L161 */
{9.2123973369598389e-01, 8.8959932327270508e-06,
	1.1920928955078125e-07, 2.6345252990722656e-05,
	1.5497207641601562e-06}, /* L162 */
{1.2883348464965820e+00, 1.2516975402832031e-05,
	1.1920928955078125e-07, -1.9252300262451172e-05,
	-8.9406967163085938e-07}, /* L163 */
{7.4848139286041260e-01, 7.3164701461791992e-06,
	1.1920928955078125e-07, -2.7418136596679688e-06,
	2.3841857910156250e-07}, /* L164 */
{1.0303035974502563e+00, 1.0132789611816406e-05,
	1.1920928955078125e-07, -3.9339065551757812e-06,
	2.0265579223632812e-06}, /* L165 */
{1.1414912939071655e+00, 1.1295080184936523e-05,
	1.1920928955078125e-07, 7.2717666625976562e-06,
	8.0943107604980469e-05}, /* L166 */
{1.5194602012634277e+00, 1.5124678611755371e-05,
	1.1920928955078125e-07, 2.6226043701171875e-06,
	-7.7486038208007812e-06}, /* L167 */
{1.0238080024719238e+00, 1.0251998901367188e-05,
	1.1920928955078125e-07, 2.7418136596679688e-06,
	-3.1590461730957031e-06}, /* L168 */
{1.1346142292022705e+00, 1.1429190635681152e-05,
	1.1920928955078125e-07, -7.5101852416992188e-06,
	1.6331672668457031e-05}, /* L169 */
{1.1793857812881470e+00, 1.1950731277465820e-05,
	1.1920928955078125e-07, -1.6629695892333984e-05,
	-1.3232231140136719e-05}, /* L170 */
{1.6403435468673706e+00, 1.6719102859497070e-05,
	1.1920928955078125e-07, 3.6954879760742188e-06,
	-3.3974647521972656e-06}, /* L171 */
{1.7790050506591797e+00, 1.8239021301269531e-05,
	1.1920928955078125e-07, -3.5166740417480469e-06,
	-7.7486038208007812e-07}, /* L172 */
{1.4508632421493530e+00, 1.4960765838623047e-05,
	1.1920928955078125e-07, -7.3909759521484375e-06,
	-4.1723251342773438e-06}, /* L173 */
{1.5513389110565186e+00, 1.6093254089355469e-05,
	1.1920928955078125e-07, -6.1690807342529297e-05,
	6.1869621276855469e-05}, /* L174 */
{1.2285547256469727e+00, 1.2814998626708984e-05,
	1.1920928955078125e-07, -1.9431114196777344e-05,
	2.0623207092285156e-05}, /* L175 */
{1.1248027086257935e+00, 1.1801719665527344e-05,
	1.1920928955078125e-07, 4.4107437133789062e-05,
	-1.8775463104248047e-05}, /* L176 */
{1.0338598489761353e+00, 1.0907649993896484e-05,
	1.1920928955078125e-07, -2.4080276489257812e-05,
	2.3841857910156250e-07}, /* L177 */
{8.8742196559906006e-01, 9.4175338745117188e-06,
	1.1920928955078125e-07, -4.1007995605468750e-05,
	-4.6312808990478516e-05}, /* L178 */
{1.2569568157196045e+00, 1.3411045074462891e-05,
	1.1920928955078125e-07, -8.0466270446777344e-06,
	1.7642974853515625e-05}, /* L179 */
{1.0193126201629639e+00, 1.0937452316284180e-05,
	1.1920928955078125e-07, -3.6358833312988281e-06,
	5.1140785217285156e-05}, /* L180 */
{1.2982742786407471e+00, 1.4007091522216797e-05,
	1.1920928955078125e-07, -1.6629695892333984e-05,
	-8.1062316894531250e-06}, /* L181 */
{1.0288227796554565e+00, 1.1160969734191895e-05,
	1.1920928955078125e-07, 7.0333480834960938e-06,
	1.4305114746093750e-06}, /* L182 */
{1.3306066989898682e+00, 1.4513731002807617e-05,
	1.1920928955078125e-07, 8.9406967163085938e-06,
	9.5367431640625000e-07}, /* L183 */
{1.0203016996383667e+00, 1.1190772056579590e-05,
	1.1920928955078125e-07, -1.9669532775878906e-06,
	2.0265579223632812e-05}, /* L184 */
{1.1182178258895874e+00, 1.2330710887908936e-05,
	1.1920928955078125e-07, -7.9274177551269531e-06,
	-3.2186508178710938e-06}, /* L185 */
{1.2682054042816162e+00, 1.4066696166992188e-05,
	1.1920928955078125e-07, 1.9752979278564453e-04,
	1.2481212615966797e-04}, /* L186 */
{1.1684124469757080e+00, 1.3023614883422852e-05,
	1.1920928955078125e-07, -3.2961368560791016e-05,
	-7.0333480834960938e-06}, /* L187 */
{1.3009834289550781e+00, 1.4580786228179932e-05,
	1.1920928955078125e-07, -3.2722949981689453e-05,
	-5.5491924285888672e-05}, /* L188 */
{1.6348913908004761e+00, 1.8417835235595703e-05,
	1.1920928955078125e-07, -3.5762786865234375e-06,
	2.9802322387695312e-06}, /* L189 */
{1.6420391798019409e+00, 1.8596649169921875e-05,
	1.1920928955078125e-07, -2.4318695068359375e-05,
	2.7537345886230469e-05}, /* L190 */
{9.4108945131301880e-01, 1.0713934898376465e-05,
	1.1920928955078125e-07, 1.5974044799804688e-05,
	1.3232231140136719e-05}, /* L191 */
{9.9413573741912842e-01, 1.1377036571502686e-05,
	1.1920928955078125e-07, 5.6028366088867188e-06,
	1.9073486328125000e-06}, /* L192 */
{1.2357484102249146e+00, 1.4215707778930664e-05,
	1.1920928955078125e-07, 6.6757202148437500e-06,
	-2.3841857910156250e-07}, /* L193 */
{1.6301261186599731e+00, 1.8849968910217285e-05,
	1.1920928955078125e-07, 1.4662742614746094e-05,
	2.6226043701171875e-06}, /* L194 */
{1.0974243879318237e+00, 1.2755393981933594e-05,
	1.1920928955078125e-07, 4.2915344238281250e-06,
	2.3961067199707031e-05}, /* L195 */
{1.0510134696960449e+00, 1.2278556823730469e-05,
	1.1920928955078125e-07, 5.4836273193359375e-06,
	2.3841857910156250e-06}, /* L196 */
{1.4908643960952759e+00, 1.7508864402770996e-05,
	1.1920928955078125e-07, 7.8082084655761719e-05,
	-3.7074089050292969e-05}, /* L197 */
{1.0176256895065308e+00, 1.2010335922241211e-05,
	1.1920928955078125e-07, 4.4465065002441406e-05,
	-1.7285346984863281e-05}, /* L198 */
{1.5929344892501831e+00, 1.8894672393798828e-05,
	1.1920928955078125e-07, -3.8385391235351562e-05,
	7.7486038208007812e-06}, /* L199 */
{1.7058891057968140e+00, 2.0340085029602051e-05,
	1.1920928955078125e-07, 6.0558319091796875e-05,
	2.7537345886230469e-05}, /* L200 */
{1.1977496147155762e+00, 1.4349818229675293e-05,
	1.1920928955078125e-07, -5.0663948059082031e-06,
	-7.9274177551269531e-06}, /* L201 */
{1.0519545078277588e+00, 1.2665987014770508e-05,
	1.1920928955078125e-07, -9.4175338745117188e-06,
	-2.5033950805664062e-05}, /* L202 */
{1.8053981065750122e+00, 2.1845102310180664e-05,
	1.1920928955078125e-07, 5.8412551879882812e-06,
	4.7683715820312500e-07}, /* L203 */
{1.2401795387268066e+00, 1.5079975128173828e-05,
	1.1920928955078125e-07, 9.1791152954101562e-06,
	-6.3180923461914062e-06}, /* L204 */
{1.1975620985031128e+00, 1.4707446098327637e-05,
	1.1920928955078125e-07, 3.4335851669311523e-03,
	-5.1164627075195312e-04}, /* L205 */
{1.5048525333404541e+00, 1.8477439880371094e-05,
	1.1920928955078125e-07, 3.6954879760742188e-06,
	-7.8082084655761719e-06}, /* L206 */
{1.1292189359664917e+00, 1.3932585716247559e-05,
	1.1920928955078125e-07, 1.3113021850585938e-06,
	1.0848045349121094e-05}, /* L207 */
{1.1700141429901123e+00, 1.4506280422210693e-05,
	1.1920928955078125e-07, 1.8239021301269531e-05,
	-1.8358230590820312e-05}, /* L208 */
{1.1943764686584473e+00, 1.4878809452056885e-05,
	1.1920928955078125e-07, 4.7683715820312500e-06,
	-9.2387199401855469e-06}, /* L209 */
{1.7291518449783325e+00, 2.1643936634063721e-05,
	1.1920928955078125e-07, -2.0265579223632812e-06,
	-1.9729137420654297e-05}, /* L210 */
{1.6042573451995850e+00, 2.0176172256469727e-05,
	1.1920928955078125e-07, 5.0067901611328125e-06,
	1.6689300537109375e-06}, /* L211 */
{1.4740267992019653e+00, 1.8626451492309570e-05,
	1.1920928955078125e-07, 8.3446502685546875e-07,
	-3.9339065551757812e-06}, /* L212 */
{1.4295392036437988e+00, 1.8149614334106445e-05,
	1.1920928955078125e-07, -2.3841857910156250e-07,
	5.7220458984375000e-06}, /* L213 */
{1.4392251968383789e+00, 1.8358230590820312e-05,
	1.1920928955078125e-07, -1.6987323760986328e-05,
	-2.1576881408691406e-05}, /* L214 */
{2.1736485958099365e+00, 2.7865171432495117e-05,
	1.1920928955078125e-07, -5.3107738494873047e-05,
	-4.2319297790527344e-05}, /* L215 */
{1.1919932365417480e+00, 1.5348196029663086e-05,
	1.1920928955078125e-07, -7.0035457611083984e-05,
	8.1062316894531250e-06}, /* L216 */
{1.6522569656372070e+00, 2.1398067474365234e-05,
	1.1920928955078125e-07, -7.0112943649291992e-04,
	2.2172927856445312e-04}, /* L217 */
{1.6680214405059814e+00, 2.1681189537048340e-05,
	1.1920928955078125e-07, -8.1539154052734375e-05,
	-7.9333782196044922e-05}, /* L218 */
{2.1757786273956299e+00, 2.8401613235473633e-05,
	1.1920928955078125e-07, 8.4638595581054688e-06,
	1.0490417480468750e-05}, /* L219 */
{1.3124855756759644e+00, 1.7210841178894043e-05,
	1.1920928955078125e-07, 7.9870223999023438e-06,
	-1.4483928680419922e-05}, /* L220 */
{1.5203121900558472e+00, 2.0027160644531250e-05,
	1.1920928955078125e-07, -1.9431114196777344e-05,
	3.5762786865234375e-07}, /* L221 */
{1.4143544435501099e+00, 1.8715858459472656e-05,
	1.1920928955078125e-07, -2.3245811462402344e-06,
	-9.0003013610839844e-06}, /* L222 */
{1.4371609687805176e+00, 1.9103288650512695e-05,
	1.1920928955078125e-07, 6.3180923461914062e-06,
	-3.1292438507080078e-05}, /* L223 */
{1.6026908159255981e+00, 2.1427869796752930e-05,
	1.1920928955078125e-07, -3.3575296401977539e-04,
	-6.3514709472656250e-04}, /* L224 */
{1.6288132667541504e+00, 2.1845102310180664e-05,
	1.1920928955078125e-07, -4.0888786315917969e-05,
	9.1791152954101562e-06}, /* L225 */
{1.0187907218933105e+00, 1.3723969459533691e-05,
	1.1920928955078125e-07, 1.3470649719238281e-05,
	2.3841857910156250e-06}, /* L226 */
{1.2462819814682007e+00, 1.6862526535987854e-05,
	1.1920928955078125e-07, 3.8146972656250000e-06,
	1.1920928955078125e-06}, /* L227 */
{1.4384590387344360e+00, 1.9550323486328125e-05,
	1.1920928955078125e-07, -3.6537647247314453e-05,
	-3.3259391784667969e-05}, /* L228 */
{1.3267810344696045e+00, 1.8194317817687988e-05,
	1.1920928955078125e-07, -1.6243457794189453e-03,
	5.1963329315185547e-04}, /* L229 */
{1.2517757415771484e+00, 1.7166137695312500e-05,
	1.1920928955078125e-07, -3.6954879760742188e-05,
	-4.6491622924804688e-05}, /* L230 */
{1.6038647890090942e+00, 2.2083520889282227e-05,
	1.1920928955078125e-07, -6.8545341491699219e-06,
	2.6226043701171875e-06}, /* L231 */
{1.1713200807571411e+00, 1.6197562217712402e-05,
	1.1920928955078125e-07, -4.7683715820312500e-06,
	-5.6028366088867188e-06}, /* L232 */
{1.8583130836486816e+00, 2.5808811187744141e-05,
	1.1920928955078125e-07, -1.2278556823730469e-05,
	-1.6689300537109375e-05}, /* L233 */
{1.2964105606079102e+00, 1.8082559108734131e-05,
	1.1920928955078125e-07, -4.8756599426269531e-05,
	-3.9100646972656250e-05}, /* L234 */
{1.4914346933364868e+00, 2.0891427993774414e-05,
	1.1920928955078125e-07, -2.7477741241455078e-05,
	-1.9073486328125000e-06}, /* L235 */
{1.2626861333847046e+00, 1.7762184143066406e-05,
	1.1920928955078125e-07, -1.7881393432617188e-07,
	1.1920928955078125e-07}, /* L236 */
{1.3563674688339233e+00, 1.9162893295288086e-05,
	1.1920928955078125e-07, 2.0980834960937500e-05,
	2.7418136596679688e-05}, /* L237 */
{1.5367653369903564e+00, 2.1800398826599121e-05,
	1.1920928955078125e-07, 4.0531158447265625e-06,
	-1.1324882507324219e-06}, /* L238 */
{1.2470778226852417e+00, 1.7765909433364868e-05,
	1.1920928955078125e-07, 3.4332275390625000e-05,
	2.9921531677246094e-05}, /* L239 */
{1.0934772491455078e+00, 1.5646219253540039e-05,
	1.1920928955078125e-07, 2.8252601623535156e-05,
	3.8146972656250000e-05}, /* L240 */
{1.9852321147918701e+00, 2.8520822525024414e-05,
	1.1920928955078125e-07, -2.0563602447509766e-05,
	1.2874603271484375e-05}, /* L241 */
{1.2313609123229980e+00, 1.7762184143066406e-05,
	1.1920928955078125e-07, 7.0333480834960938e-06,
	-8.5234642028808594e-06}, /* L242 */
{1.2252029180526733e+00, 1.7762184143066406e-05,
	1.1920928955078125e-07, -6.1577558517456055e-04,
	-2.3275613784790039e-04}, /* L243 */
{1.0384093523025513e+00, 1.5102326869964600e-05,
	1.1920928955078125e-07, -4.2915344238281250e-06,
	-7.1525573730468750e-07}, /* L244 */
{1.4937413930892944e+00, 2.1815299987792969e-05,
	1.1920928955078125e-07, 4.0650367736816406e-05,
	-1.2755393981933594e-05}, /* L245 */
{1.2570779323577881e+00, 1.8432736396789551e-05,
	1.1920928955078125e-07, 2.6345252990722656e-05,
	-5.1259994506835938e-06}, /* L246 */
{1.8190509080886841e+00, 2.6784837245941162e-05,
	1.1920928955078125e-07, -9.2089176177978516e-05,
	-7.8439712524414062e-05}, /* L247 */
{1.0523401498794556e+00, 1.5556812286376953e-05,
	1.1920928955078125e-07, 4.8518180847167969e-05,
	7.2598457336425781e-05}, /* L248 */
{1.8098148107528687e+00, 2.6866793632507324e-05,
	1.1920928955078125e-07, -2.8133392333984375e-05,
	-1.0192394256591797e-05}, /* L249 */
{1.5516481399536133e+00, 2.3126602172851562e-05,
	1.1920928955078125e-07, -1.1730194091796875e-04,
	-5.0246715545654297e-05}, /* L250 */
{1.7170596122741699e+00, 2.5689601898193359e-05,
	1.1920928955078125e-07, 8.1062316894531250e-06,
	1.6212463378906250e-05}, /* L251 */
{1.6130100488662720e+00, 2.4229288101196289e-05,
	1.1920928955078125e-07, 2.0265579223632812e-05,
	1.2755393981933594e-05}, /* L252 */
{1.5766159296035767e+00, 2.3778527975082397e-05,
	1.1920928955078125e-07, -2.6404857635498047e-05,
	-6.1452388763427734e-05}, /* L253 */
{1.3089818954467773e+00, 1.9818544387817383e-05,
	1.1920928955078125e-07, 6.5565109252929688e-06,
	3.5405158996582031e-05}, /* L254 */
{2.3881494998931885e+00, 3.6299228668212891e-05,
	1.1920928955078125e-07, 5.2452087402343750e-06,
	-2.7954578399658203e-05}, /* L255 */
{1.3607747554779053e+00, 2.0766630768775940e-05,
	1.1920928955078125e-07, -2.3841857910156250e-06,
	1.5258789062500000e-05}, /* L256 */
{1.0377191305160522e+00, 1.5914440155029297e-05,
	1.1920928955078125e-07, -3.7550926208496094e-06,
	-1.6212463378906250e-04}, /* L257 */
{1.4650620222091675e+00, 2.2530555725097656e-05,
	1.1920928955078125e-07, 1.3589859008789062e-05,
	-1.9133090972900391e-05}, /* L258 */
{1.1872253417968750e+00, 1.8328428268432617e-05,
	1.1920928955078125e-07, -2.6822090148925781e-06,
	-1.9490718841552734e-05}, /* L259 */
{8.4802746772766113e-01, 1.3142824172973633e-05,
	1.1920928955078125e-07, 1.6212463378906250e-05,
	-1.4305114746093750e-06}, /* L260 */
{1.5229669809341431e+00, 2.3692846298217773e-05,
	1.1920928955078125e-07, 2.2649765014648438e-06,
	4.1723251342773438e-06}, /* L261 */
{1.6334742307662964e+00, 2.5510787963867188e-05,
	1.1920928955078125e-07, 5.8174133300781250e-05,
	4.4107437133789062e-06}, /* L262 */
{1.4466638565063477e+00, 2.2679567337036133e-05,
	1.1920928955078125e-07, -6.2823295593261719e-05,
	6.6280364990234375e-05}, /* L263 */
{1.2745931148529053e+00, 2.0056962966918945e-05,
	1.1920928955078125e-07, -5.9604644775390625e-07,
	1.9073486328125000e-05}, /* L264 */
{1.0961362123489380e+00, 1.7315149307250977e-05,
	1.1920928955078125e-07, -3.5881996154785156e-05,
	-3.2484531402587891e-05}, /* L265 */
{1.1973472833633423e+00, 1.8984079360961914e-05,
	1.1920928955078125e-07, 7.0333480834960938e-06,
	1.1205673217773438e-05}, /* L266 */
{1.3094604015350342e+00, 2.0842649973928928e-05,
	1.1920928955078125e-07, -3.2782554626464844e-05,
	-2.9444694519042969e-05}, /* L267 */
{8.5768884420394897e-01, 1.3701617717742920e-05,
	1.1920928955078125e-07, -5.1617622375488281e-05,
	2.4318695068359375e-05}, /* L268 */
{1.1077049970626831e+00, 1.7762184143066406e-05,
	1.1920928955078125e-07, 2.5033950805664062e-06,
	1.1205673217773438e-05}, /* L269 */
{9.1811978816986084e-01, 1.4780089259147644e-05,
	1.1920928955078125e-07, 1.1253356933593750e-04,
	4.3272972106933594e-05}, /* L270 */
{1.4978722333908081e+00, 2.4199485778808594e-05,
	1.1920928955078125e-07, -6.8962574005126953e-05,
	-5.4895877838134766e-05}, /* L271 */
{9.2462468147277832e-01, 1.4990568161010742e-05,
	1.1920928955078125e-07, -3.0994415283203125e-06,
	-2.2053718566894531e-06}, /* L272 */
{1.1950411796569824e+00, 1.9446015357971191e-05,
	1.1920928955078125e-07, -1.4424324035644531e-05,
	1.4305114746093750e-06}, /* L273 */
{1.0889482498168945e+00, 1.7784535884857178e-05,
	1.1920928955078125e-07, 2.5033950805664062e-06,
	3.5762786865234375e-07}, /* L274 */
{1.1054261922836304e+00, 1.8119812011718750e-05,
	1.1920928955078125e-07, 1.8358230590820312e-05,
	2.2649765014648438e-06}, /* L275 */
{1.5407308340072632e+00, 2.5346875190734863e-05,
	1.1920928955078125e-07, -8.5830688476562500e-06,
	-7.9274177551269531e-06}, /* L276 */
{1.5179319381713867e+00, 2.5063753128051758e-05,
	1.1920928955078125e-07, -1.5676021575927734e-05,
	1.3470649719238281e-05}, /* L277 */
{1.5787384510040283e+00, 2.6159919798374176e-05,
	1.1920928955078125e-07, -1.1920928955078125e-06,
	-6.1988830566406250e-06}, /* L278 */
{1.3440673351287842e+00, 2.2351741790771484e-05,
	1.1920928955078125e-07, 1.0728836059570312e-05,
	-5.6028366088867188e-06}, /* L279 */
{1.0749133825302124e+00, 1.7940998077392578e-05,
	1.1920928955078125e-07, -2.4437904357910156e-06,
	1.9073486328125000e-06}, /* L280 */
{1.4367295503616333e+00, 2.4065375328063965e-05,
	1.1920928955078125e-07, 3.6358833312988281e-05,
	-1.4066696166992188e-05}, /* L281 */
{1.0292458534240723e+00, 1.7300248146057129e-05,
	1.1920928955078125e-07, 8.9406967163085938e-06,
	1.0371208190917969e-05}, /* L282 */
{1.6615095138549805e+00, 2.8029084205627441e-05,
	1.1920928955078125e-07, 9.1791152954101562e-06,
	-9.1195106506347656e-06}, /* L283 */
{1.3608455657958984e+00, 2.3037195205688477e-05,
	1.1920928955078125e-07, -1.3947486877441406e-05,
	-6.5565109252929688e-06}, /* L284 */
{1.5477976799011230e+00, 2.6293098926544189e-05,
	1.1920928955078125e-07, -9.1791152954101562e-06,
	-8.3446502685546875e-07}, /* L285 */
{1.4318006038665771e+00, 2.4408102035522461e-05,
	1.1920928955078125e-07, -5.0067901611328125e-06,
	-2.5033950805664062e-06}, /* L286 */
{1.3153171539306641e+00, 2.2500753402709961e-05,
	1.1920928955078125e-07, 3.3378601074218750e-06,
	4.7683715820312500e-07}, /* L287 */
{1.0099321603775024e+00, 1.7344951629638672e-05,
	1.1920928955078125e-07, -1.7881393432617188e-05,
	-8.7022781372070312e-05}, /* L288 */
{1.0847744941711426e+00, 1.8686056137084961e-05,
	1.1920928955078125e-07, 6.9141387939453125e-06,
	4.5299530029296875e-06}, /* L289 */
{9.5685625076293945e-01, 1.6540288925170898e-05,
	1.1920928955078125e-07, -2.3245811462402344e-06,
	-1.8477439880371094e-05}, /* L290 */
{2.1030154228210449e+00, 3.6478042602539062e-05,
	1.1920928955078125e-07, 2.0980834960937500e-05,
	1.7046928405761719e-05}, /* L291 */
{1.1778017282485962e+00, 2.0503997802734375e-05,
	1.1920928955078125e-07, 4.5776367187500000e-05,
	-1.5264749526977539e-04}, /* L292 */
{1.4986901283264160e+00, 2.6173889636993408e-05,
	1.1920928955078125e-07, -1.4841556549072266e-05,
	2.9802322387695312e-06}, /* L293 */
{1.5219157934188843e+00, 2.6673078536987305e-05,
	1.1920928955078125e-07, 1.1682510375976562e-05,
	-1.0520219802856445e-04}, /* L294 */
{1.6414111852645874e+00, 2.8908252716064453e-05,
	1.1920928955078125e-07, 1.4889240264892578e-04,
	5.1343441009521484e-04}, /* L295 */
{1.2212220430374146e+00, 2.1547079086303711e-05,
	1.1920928955078125e-07, -1.7344951629638672e-05,
	5.7935714721679688e-05}, /* L296 */
{1.0117542743682861e+00, 1.7911195755004883e-05,
	1.1920928955078125e-07, 1.4305114746093750e-06,
	-5.9008598327636719e-06}, /* L297 */
{1.4981784820556641e+00, 2.6613473892211914e-05,
	1.1920928955078125e-07, -1.2099742889404297e-05,
	-6.0677528381347656e-05}, /* L298 */
{1.1771926879882812e+00, 2.0980834960937500e-05,
	1.1920928955078125e-07, 3.6120414733886719e-05,
	-2.9444694519042969e-05}, /* L299 */
{1.3216271400451660e+00, 2.3633241653442383e-05,
	1.1920928955078125e-07, -2.2053718566894531e-05,
	2.3245811462402344e-05}, /* L300 */
{1.3039731979370117e+00, 2.3394823074340820e-05,
	1.1920928955078125e-07, 4.5299530029296875e-06,
	2.7418136596679688e-06}, /* L301 */
{1.4548612833023071e+00, 2.6196241378784180e-05,
	1.1920928955078125e-07, 4.3988227844238281e-05,
	-6.5326690673828125e-05}, /* L302 */
{1.6806248426437378e+00, 3.0353665351867676e-05,
	1.1920928955078125e-07, 1.8954277038574219e-05,
	-1.0073184967041016e-05}, /* L303 */
{1.0229992866516113e+00, 1.8537044525146484e-05,
	1.1920928955078125e-07, -6.6757202148437500e-06,
	9.7751617431640625e-06}, /* L304 */
{1.3204678297042847e+00, 2.4005770683288574e-05,
	1.1920928955078125e-07, -1.9311904907226562e-05,
	-1.4901161193847656e-06}, /* L305 */
{1.0975986719131470e+00, 2.0042061805725098e-05,
	1.1920928955078125e-07, 2.8443336486816406e-04,
	4.7993659973144531e-04}, /* L306 */
{1.3951439857482910e+00, 2.5533139705657959e-05,
	1.1920928955078125e-07, -2.3424625396728516e-05,
	1.8835067749023438e-05}, /* L307 */
{1.6752896308898926e+00, 3.0755996704101562e-05,
	1.1920928955078125e-07, 1.5735626220703125e-05,
	-1.7583370208740234e-05}, /* L308 */
{1.3081562519073486e+00, 2.4095177650451660e-05,
	1.1920928955078125e-07, -2.8908252716064453e-05,
	3.4570693969726562e-05}, /* L309 */
{9.1597378253936768e-01, 1.6927719116210938e-05,
	1.1920928955078125e-07, -7.1227550506591797e-05,
	-4.4345855712890625e-05}, /* L310 */
{1.2459009885787964e+00, 2.3096799850463867e-05,
	1.1920928955078125e-07, 2.4795532226562500e-05,
	7.2717666625976562e-06}, /* L311 */
{1.3829603195190430e+00, 2.5719404220581055e-05,
	1.1920928955078125e-07, 9.2983245849609375e-06,
	-2.3841857910156250e-07}, /* L312 */
{1.1420305967330933e+00, 2.1308660507202148e-05,
	1.1920928955078125e-07, -1.0436773300170898e-04,
	-3.5941600799560547e-05}, /* L313 */
{1.0840096473693848e+00, 2.0295381546020508e-05,
	1.1920928955078125e-07, -1.5139579772949219e-04,
	-1.0305643081665039e-04}, /* L314 */
{1.7044900655746460e+00, 3.2007694244384766e-05,
	1.1920928955078125e-07, 5.0425529479980469e-05,
	7.3313713073730469e-05}, /* L315 */
{1.7000733613967896e+00, 3.2022595405578613e-05,
	1.1920928955078125e-07, -3.6895275115966797e-05,
	1.7523765563964844e-05}, /* L316 */
{1.7034292221069336e+00, 3.2186508178710938e-05,
	1.1920928955078125e-07, -2.0027160644531250e-05,
	-3.2186508178710938e-06}, /* L317 */
{1.3089668750762939e+00, 2.4810433387756348e-05,
	1.1920928955078125e-07, -1.4901161193847656e-06,
	1.3113021850585938e-06}, /* L318 */
{1.2805606126785278e+00, 2.4348497390747070e-05,
	1.1920928955078125e-07, -5.0067901611328125e-06,
	-1.7285346984863281e-06}, /* L319 */
{9.6873760223388672e-01, 1.8477439880371094e-05,
	1.1920928955078125e-07, -5.3644180297851562e-06,
	5.4836273193359375e-06}, /* L320 */
{9.8751413822174072e-01, 1.8894672393798828e-05,
	1.1920928955078125e-07, -1.3887882232666016e-05,
	-5.9604644775390625e-07}, /* L321 */
{1.1660006046295166e+00, 2.2381544113159180e-05,
	1.1920928955078125e-07, -5.3107738494873047e-05,
	-4.3451786041259766e-05}, /* L322 */
{1.8482679128646851e+00, 3.5583972930908203e-05,
	1.1920928955078125e-07, 6.7949295043945312e-06,
	2.1457672119140625e-05}, /* L323 */
{1.2221440076828003e+00, 2.3603439331054688e-05,
	1.1920928955078125e-07, 2.7418136596679688e-06,
	1.2040138244628906e-05}, /* L324 */
{1.4494453668594360e+00, 2.8081238269805908e-05,
	1.1920928955078125e-07, -2.4676322937011719e-05,
	-1.9192695617675781e-05}, /* L325 */
{8.9722484350204468e-01, 1.7434358596801758e-05,
	1.1920928955078125e-07, 7.2717666625976562e-06,
	-1.0669231414794922e-05}, /* L326 */
{1.6314949989318848e+00, 3.1799077987670898e-05,
	1.1920928955078125e-07, 1.1324882507324219e-05,
	2.2649765014648438e-06}, /* L327 */
{1.5377434492111206e+00, 3.0070543289184570e-05,
	1.1920928955078125e-07, -8.9704990386962891e-05,
	-3.0171871185302734e-04}, /* L328 */
{1.7914935350418091e+00, 3.5136938095092773e-05,
	1.1920928955078125e-07, -1.8537044525146484e-05,
	1.6927719116210938e-05}, /* L329 */
{1.6029061079025269e+00, 3.1530857086181641e-05,
	1.1920928955078125e-07, -5.2988529205322266e-05,
	-3.4034252166748047e-05}, /* L330 */
{1.3054974079132080e+00, 2.5756657123565674e-05,
	1.1920928955078125e-07, -3.2186508178710938e-06,
	9.5367431640625000e-07}, /* L331 */
{1.2891563177108765e+00, 2.5510787963867188e-05,
	1.1920928955078125e-07, 3.0994415283203125e-06,
	3.8146972656250000e-06}, /* L332 */
{1.9777437448501587e+00, 3.9257109165191650e-05,
	1.1920928955078125e-07, 1.9073486328125000e-05,
	3.5405158996582031e-05}, /* L333 */
{1.0754090547561646e+00, 2.1412968635559082e-05,
	1.1920928955078125e-07, -7.0691108703613281e-05,
	-1.1682510375976562e-05}, /* L334 */
{1.6380463838577271e+00, 3.2722949981689453e-05,
	1.1920928955078125e-07, 1.6009807586669922e-04,
	6.4611434936523438e-05}, /* L335 */
{1.0237989425659180e+00, 2.0503997802734375e-05,
	1.1920928955078125e-07, -1.9669532775878906e-06,
	-2.5629997253417969e-06}, /* L336 */
{1.3438527584075928e+00, 2.7000904083251953e-05,
	1.1920928955078125e-07, 5.6266784667968750e-05,
	-9.5903873443603516e-05}, /* L337 */
{1.1893464326858521e+00, 2.3961067199707031e-05,
	1.1920928955078125e-07, -7.2717666625976562e-06,
	-1.7881393432617188e-06}, /* L338 */
{1.6865068674087524e+00, 3.4078955650329590e-05,
	1.1920928955078125e-07, 8.9406967163085938e-06,
	1.7762184143066406e-05}, /* L339 */
{1.4202225208282471e+00, 2.8789043426513672e-05,
	1.1920928955078125e-07, 4.4941902160644531e-05,
	8.6188316345214844e-05}, /* L340 */
{1.1685823202133179e+00, 2.3752450942993164e-05,
	1.1920928955078125e-07, 5.7220458984375000e-06,
	3.6954879760742188e-06}, /* L341 */
{1.1899894475936890e+00, 2.4259090423583984e-05,
	1.1920928955078125e-07, 2.8610229492187500e-05,
	-1.7881393432617188e-07}, /* L342 */
{1.4269918203353882e+00, 2.9174610972404480e-05,
	1.1920928955078125e-07, 0.0000000000000000e+00,
	-1.6450881958007812e-05}, /* L343 */
{1.2600743770599365e+00, 2.5838613510131836e-05,
	1.1920928955078125e-07, -4.8279762268066406e-05,
	1.4662742614746094e-05}, /* L344 */
{1.6849216222763062e+00, 3.4648925065994263e-05,
	1.1920928955078125e-07, -3.9339065551757812e-06,
	7.6293945312500000e-06}, /* L345 */
{1.2492109537124634e+00, 2.5764107704162598e-05,
	1.1920928955078125e-07, 7.1525573730468750e-07,
	3.9339065551757812e-05}, /* L346 */
{1.3007651567459106e+00, 2.6911497116088867e-05,
	1.1920928955078125e-07, -3.7968158721923828e-05,
	2.9802322387695312e-05}, /* L347 */
{1.2252357006072998e+00, 2.5421380996704102e-05,
	1.1920928955078125e-07, 1.3709068298339844e-05,
	-9.1791152954101562e-05}, /* L348 */
{1.4884828329086304e+00, 3.0964612960815430e-05,
	1.1920928955078125e-07, 3.4570693969726562e-06,
	2.2888183593750000e-05}, /* L349 */
{1.5442473888397217e+00, 3.2216310501098633e-05,
	1.1920928955078125e-07, -8.8214874267578125e-06,
	2.1815299987792969e-05}, /* L350 */
{1.1410002708435059e+00, 2.3871660232543945e-05,
	1.1920928955078125e-07, 6.1988830566406250e-06,
	1.1920928955078125e-06}, /* L351 */
{9.5584797859191895e-01, 2.0056962966918945e-05,
	1.1920928955078125e-07, -1.0251998901367188e-05,
	4.6610832214355469e-05}, /* L352 */
{1.3552874326705933e+00, 2.8520822525024414e-05,
	1.1920928955078125e-07, 7.5459480285644531e-05,
	9.7632408142089844e-05}, /* L353 */
{1.2881040573120117e+00, 2.7179718017578125e-05,
	1.1920928955078125e-07, -3.5762786865234375e-07,
	-1.7225742340087891e-05}, /* L354 */
{1.3254534006118774e+00, 2.8058886528015137e-05,
	1.1920928955078125e-07, 6.2465667724609375e-05,
	4.4846534729003906e-04}, /* L355 */
{1.0923426151275635e+00, 2.3186206817626953e-05,
	1.1920928955078125e-07, -1.2391805648803711e-04,
	-3.4809112548828125e-05}, /* L356 */
{1.5097956657409668e+00, 3.2126903533935547e-05,
	1.1920928955078125e-07, 5.9604644775390625e-07,
	2.0861625671386719e-05}, /* L357 */
{1.3979942798614502e+00, 2.9832124710083008e-05,
	1.1920928955078125e-07, -1.1742115020751953e-05,
	-1.2516975402832031e-06}, /* L358 */
{1.3272609710693359e+00, 2.8401613235473633e-05,
	1.1920928955078125e-07, -1.8000602722167969e-05,
	-1.2636184692382812e-05}, /* L359 */
{1.2999900579452515e+00, 2.7894973754882812e-05,
	1.1920928955078125e-07, -1.6093254089355469e-06,
	-4.8279762268066406e-06}, /* L360 */
{1.3176841735839844e+00, 2.8353184461593628e-05,
	1.1920928955078125e-07, -5.7220458984375000e-06,
	9.6559524536132812e-06}, /* L361 */
{1.3704626560211182e+00, 2.9571354389190674e-05,
	1.1920928955078125e-07, 1.5497207641601562e-06,
	-1.2397766113281250e-05}, /* L362 */
{1.4283615350723267e+00, 3.0905008316040039e-05,
	1.1920928955078125e-07, 1.1801719665527344e-05,
	8.4638595581054688e-06}, /* L363 */
{1.2640043497085571e+00, 2.7425587177276611e-05,
	1.1920928955078125e-07, -1.7821788787841797e-05,
	2.1576881408691406e-05}, /* L364 */
{1.6780076026916504e+00, 3.6507844924926758e-05,
	1.1920928955078125e-07, 1.7404556274414062e-05,
	1.3589859008789062e-05}, /* L365 */
{1.2062554359436035e+00, 2.6315450668334961e-05,
	1.1920928955078125e-07, -7.8082084655761719e-06,
	-8.7022781372070312e-06}, /* L366 */
{1.9282305240631104e+00, 4.2181462049484253e-05,
	1.1920928955078125e-07, 1.0728836059570312e-06,
	3.6001205444335938e-05}, /* L367 */
{1.2560775279998779e+00, 2.7552247047424316e-05,
	1.1920928955078125e-07, 4.6491622924804688e-06,
	1.0848045349121094e-05}, /* L368 */
{1.9742250442504883e+00, 4.3421983718872070e-05,
	1.1920928955078125e-07, 7.2717666625976562e-06,
	1.5735626220703125e-05}, /* L369 */
{1.4162014722824097e+00, 3.1232833862304688e-05,
	1.1920928955078125e-07, 3.6954879760742188e-06,
	-1.1324882507324219e-06}, /* L370 */
{1.5022866725921631e+00, 3.3222138881683350e-05,
	1.1920928955078125e-07, -2.6583671569824219e-05,
	2.5629997253417969e-05}, /* L371 */
{1.1968847513198853e+00, 2.6538968086242676e-05,
	1.1920928955078125e-07, -1.1324882507324219e-05,
	-1.9490718841552734e-05}, /* L372 */
{1.5100426673889160e+00, 3.3576041460037231e-05,
	1.1920928955078125e-07, -2.6404857635498047e-05,
	-3.8921833038330078e-05}, /* L373 */
{1.2461898326873779e+00, 2.7835369110107422e-05,
	1.1920928955078125e-07, 1.0279417037963867e-03,
	9.9289417266845703e-04}, /* L374 */
{1.7959520816802979e+00, 4.0143728256225586e-05,
	1.1920928955078125e-07, 5.7220458984375000e-06,
	3.0875205993652344e-05}, /* L375 */
{1.2488454580307007e+00, 2.7989735826849937e-05,
	1.1920928955078125e-07, 6.6399574279785156e-05,
	1.0132789611816406e-05}, /* L376 */
{1.7625216245651245e+00, 3.9607286453247070e-05,
	1.1920928955078125e-07, -3.0398368835449219e-06,
	-3.1590461730957031e-06}, /* L377 */
{1.6728717088699341e+00, 3.7699937820434570e-05,
	1.1920928955078125e-07, 6.4492225646972656e-05,
	-1.3709068298339844e-05}, /* L378 */
{1.2689545154571533e+00, 2.8669834136962891e-05,
	1.1920928955078125e-07, 5.3644180297851562e-05,
	4.1127204895019531e-05}, /* L379 */
{1.1420682668685913e+00, 2.5868415832519531e-05,
	1.1920928955078125e-07, 6.5565109252929688e-06,
	7.7486038208007812e-06}, /* L380 */
{1.4067704677581787e+00, 3.1948089599609375e-05,
	1.1920928955078125e-07, 8.5830688476562500e-06,
	-9.4771385192871094e-06}, /* L381 */
{1.6318453550338745e+00, 3.7163496017456055e-05,
	1.1920928955078125e-07, 1.5854835510253906e-05,
	-5.3465366363525391e-05}, /* L382 */
{1.5560289621353149e+00, 3.5524368286132812e-05,
	1.1920928955078125e-07, 1.9669532775878906e-05,
	-6.6757202148437500e-06}, /* L383 */
{1.5168067216873169e+00, 3.4719705581665039e-05,
	1.1920928955078125e-07, -4.8160552978515625e-05,
	9.1791152954101562e-06}, /* L384 */
{1.6538457870483398e+00, 3.7953257560729980e-05,
	1.1920928955078125e-07, -6.3180923461914062e-06,
	1.2040138244628906e-05}, /* L385 */
{1.3364614248275757e+00, 3.0755996704101562e-05,
	1.1920928955078125e-07, 5.9604644775390625e-05,
	1.0728836059570312e-04}, /* L386 */
{1.4924982786178589e+00, 3.4429132938385010e-05,
	1.1920928955078125e-07, -3.3378601074218750e-05,
	-5.6028366088867188e-06}, /* L387 */
{1.1835141181945801e+00, 2.7373433113098145e-05,
	1.1920928955078125e-07, -2.3663043975830078e-05,
	4.7445297241210938e-05}, /* L388 */
{1.4318392276763916e+00, 3.3199787139892578e-05,
	1.1920928955078125e-07, 5.4836273193359375e-06,
	-1.1503696441650391e-05}, /* L389 */
{1.4627364873886108e+00, 3.4004449844360352e-05,
	1.1920928955078125e-07, -5.6028366088867188e-06,
	-1.5676021575927734e-05}, /* L390 */
{2.0462808609008789e+00, 4.7691166400909424e-05,
	1.1920928955078125e-07, 7.1525573730468750e-06,
	4.5299530029296875e-06}, /* L391 */
{1.2629046440124512e+00, 2.9511749744415283e-05,
	1.1920928955078125e-07, -3.3020973205566406e-05,
	7.3909759521484375e-05}, /* L392 */
{1.7976472377777100e+00, 4.2110681533813477e-05,
	1.1920928955078125e-07, -9.4175338745117188e-06,
	-8.3446502685546875e-07}, /* L393 */
{1.5386162996292114e+00, 3.6135315895080566e-05,
	1.1920928955078125e-07, -8.5830688476562500e-06,
	-4.2557716369628906e-05}, /* L394 */
{2.2664372920989990e+00, 5.3405761718750000e-05,
	1.1920928955078125e-07, -1.4364719390869141e-04,
	9.9301338195800781e-05}, /* L395 */
{1.2558653354644775e+00, 2.9653310775756836e-05,
	1.1920928955078125e-07, -1.0561943054199219e-04,
	9.0837478637695312e-05}, /* L396 */
{1.5204144716262817e+00, 3.5978853702545166e-05,
	1.1920928955078125e-07, -2.0861625671386719e-06,
	-2.8610229492187500e-05}, /* L397 */
{1.1984574794769287e+00, 2.8431415557861328e-05,
	1.1920928955078125e-07, -8.2850456237792969e-06,
	4.1723251342773438e-06}, /* L398 */
{2.2954206466674805e+00, 5.4597854614257812e-05,
	1.1920928955078125e-07, 1.6093254089355469e-05,
	1.9073486328125000e-05}, /* L399 */
{1.2571635246276855e+00, 2.9973685741424561e-05,
	1.1920928955078125e-07, 5.2452087402343750e-06,
	-7.5697898864746094e-06}, /* L400 */
{1.3275840282440186e+00, 3.1732022762298584e-05,
	1.1920928955078125e-07, 2.8848648071289062e-05,
	-1.9133090972900391e-05}, /* L401 */
{1.1007200479507446e+00, 2.6375055313110352e-05,
	1.1920928955078125e-07, -1.5795230865478516e-05,
	-1.4662742614746094e-05}, /* L402 */
{1.9524987936019897e+00, 4.6901404857635498e-05,
	1.1920928955078125e-07, -1.8477439880371094e-06,
	3.3378601074218750e-06}, /* L403 */
{2.2134304046630859e+00, 5.3301453590393066e-05,
	1.1920928955078125e-07, -2.9206275939941406e-06,
	6.7949295043945312e-06}, /* L404 */
{1.8413017988204956e+00, 4.4450163841247559e-05,
	1.1920928955078125e-07, -2.6822090148925781e-06,
	-2.1457672119140625e-05}, /* L405 */
{1.7917413711547852e+00, 4.3361207644920796e-05,
	1.1920928955078125e-07, -1.0132789611816406e-06,
	-1.9788742065429688e-05}, /* L406 */
{1.6129521131515503e+00, 3.9130449295043945e-05,
	1.1920928955078125e-07, -2.6524066925048828e-05,
	-1.5437602996826172e-05}, /* L407 */
{1.2504223585128784e+00, 3.0413269996643066e-05,
	1.1920928955078125e-07, 1.2636184692382812e-05,
	-8.0466270446777344e-06}, /* L408 */
{1.6595177650451660e+00, 4.0471553802490234e-05,
	1.1920928955078125e-07, 1.1837482452392578e-04,
	9.8586082458496094e-05}, /* L409 */
{1.7162094116210938e+00, 4.1961669921875000e-05,
	1.1920928955078125e-07, -9.0301036834716797e-05,
	5.9604644775390625e-06}, /* L410 */
{1.8794951438903809e+00, 4.6044588088989258e-05,
	1.1920928955078125e-07, 2.7418136596679688e-06,
	1.3947486877441406e-05}, /* L411 */
{1.3858747482299805e+00, 3.4034252166748047e-05,
	1.1920928955078125e-07, -7.7486038208007812e-06,
	2.6106834411621094e-05}, /* L412 */
{1.4287726879119873e+00, 3.5174190998077393e-05,
	1.1920928955078125e-07, -3.4511089324951172e-05,
	3.4093856811523438e-05}, /* L413 */
{1.5603183507919312e+00, 3.8504600524902344e-05,
	1.1920928955078125e-07, -1.8298625946044922e-05,
	-1.1920928955078125e-06}, /* L414 */
{1.2563947439193726e+00, 3.1083822250366211e-05,
	1.1920928955078125e-07, -8.8214874267578125e-06,
	1.9192695617675781e-05}, /* L415 */
{1.3610508441925049e+00, 3.3751130104064941e-05,
	1.1920928955078125e-07, 5.1021575927734375e-05,
	-6.9141387939453125e-06}, /* L416 */
{1.4827507734298706e+00, 3.6858022212982178e-05,
	1.1920928955078125e-07, 6.5565109252929688e-06,
	-6.6936016082763672e-05}, /* L417 */
{1.5067100524902344e+00, 3.7580728530883789e-05,
	1.1920928955078125e-07, -2.8544664382934570e-04,
	-3.0338764190673828e-05}, /* L418 */
{1.7887336015701294e+00, 4.4673681259155273e-05,
	1.1920928955078125e-07, -9.5367431640625000e-06,
	3.1232833862304688e-05}, /* L419 */
{1.0475878715515137e+00, 2.6226043701171875e-05,
	1.1920928955078125e-07, -6.6757202148437500e-06,
	2.5033950805664062e-06}, /* L420 */
{1.3490215539932251e+00, 3.3855438232421875e-05,
	1.1920928955078125e-07, -6.7770481109619141e-05,
	-1.8417835235595703e-05}, /* L421 */
{1.3222026824951172e+00, 3.3259391784667969e-05,
	1.1920928955078125e-07, 3.3378601074218750e-05,
	-1.9133090972900391e-05}, /* L422 */
{1.7717125415802002e+00, 4.4673681259155273e-05,
	1.1920928955078125e-07, -4.5180320739746094e-05,
	6.9141387939453125e-06}, /* L423 */
{1.3890916109085083e+00, 3.5107135772705078e-05,
	1.1920928955078125e-07, 3.2544136047363281e-05,
	1.4901161193847656e-05}, /* L424 */
{1.6599396467208862e+00, 4.2051076889038086e-05,
	1.1920928955078125e-07, -2.9802322387695312e-05,
	2.2888183593750000e-05}, /* L425 */
{1.4423512220382690e+00, 3.6627054214477539e-05,
	1.1920928955078125e-07, -5.0902366638183594e-05,
	-6.2346458435058594e-05}, /* L426 */
{1.8418909311294556e+00, 4.6879053115844727e-05,
	1.1920928955078125e-07, -9.5963478088378906e-06,
	-3.5762786865234375e-07}, /* L427 */
{1.5969265699386597e+00, 4.0739774703979492e-05,
	1.1920928955078125e-07, -1.1920928955078125e-07,
	4.0531158447265625e-06}, /* L428 */
{1.5325897932052612e+00, 3.9249658584594727e-05,
	1.1920928955078125e-07, -2.7889013290405273e-04,
	-5.0425529479980469e-05}, /* L429 */
{1.4892181158065796e+00, 3.8169324398040771e-05,
	1.1920928955078125e-07, 8.3446502685546875e-06,
	-9.9539756774902344e-06}, /* L430 */
{1.6298453807830811e+00, 4.1872262954711914e-05,
	1.1920928955078125e-07, -1.1205673217773438e-05,
	1.0609626770019531e-05}, /* L431 */
{1.2001925706863403e+00, 3.0905008316040039e-05,
	1.1920928955078125e-07, 1.3113021850585938e-06,
	2.0265579223632812e-06}, /* L432 */
{1.6309007406234741e+00, 4.2110681533813477e-05,
	1.1920928955078125e-07, -8.5413455963134766e-05,
	5.2213668823242188e-05}, /* L433 */
{1.5586800575256348e+00, 4.0322542190551758e-05,
	1.1920928955078125e-07, -1.0192394256591797e-05,
	-3.7848949432373047e-05}, /* L434 */
{1.7262604236602783e+00, 4.4763088226318359e-05,
	1.1920928955078125e-07, 3.6120414733886719e-05,
	2.1100044250488281e-05}, /* L435 */
{1.1300497055053711e+00, 2.9370188713073730e-05,
	1.1920928955078125e-07, -3.9458274841308594e-05,
	-4.2319297790527344e-06}, /* L436 */
{1.6024870872497559e+00, 4.1753053665161133e-05,
	1.1920928955078125e-07, 6.6399574279785156e-05,
	-7.4267387390136719e-05}, /* L437 */
{1.1399281024932861e+00, 2.9761344194412231e-05,
	1.1920928955078125e-07, 5.5313110351562500e-05,
	1.7046928405761719e-05}, /* L438 */
{1.8358709812164307e+00, 4.8041343688964844e-05,
	1.1920928955078125e-07, -1.0907649993896484e-05,
	2.1457672119140625e-05}, /* L439 */
{1.0305653810501099e+00, 2.7030706405639648e-05,
	1.1920928955078125e-07, -1.3709068298339844e-05,
	-6.5565109252929688e-07}, /* L440 */
{1.7417738437652588e+00, 4.5790802687406540e-05,
	1.1920928955078125e-07, -2.8014183044433594e-06,
	5.5551528930664062e-05}, /* L441 */
{1.0972405672073364e+00, 2.8908252716064453e-05,
	1.1920928955078125e-07, -1.5139579772949219e-05,
	5.9604644775390625e-07}, /* L442 */
{1.4807647466659546e+00, 3.9100646972656250e-05,
	1.1920928955078125e-07, 3.4570693969726562e-06,
	-1.4841556549072266e-05}, /* L443 */
{1.4193629026412964e+00, 3.7565827369689941e-05,
	1.1920928955078125e-07, -1.0311603546142578e-05,
	-1.2874603271484375e-05}, /* L444 */
{1.4696013927459717e+00, 3.8981437683105469e-05,
	1.1920928955078125e-07, 4.2915344238281250e-06,
	-4.6491622924804688e-06}, /* L445 */
{1.1602810621261597e+00, 3.0845403671264648e-05,
	1.1920928955078125e-07, -4.8279762268066406e-06,
	-1.5139579772949219e-05}, /* L446 */
{1.7470524311065674e+00, 4.6551227569580078e-05,
	1.1920928955078125e-07, 6.4373016357421875e-05,
	-2.1517276763916016e-05}, /* L447 */
{1.2574751377105713e+00, 3.3579766750335693e-05,
	1.1920928955078125e-07, -1.2695789337158203e-05,
	-1.0132789611816406e-06}, /* L448 */
{1.6156847476959229e+00, 4.3243169784545898e-05,
	1.1920928955078125e-07, 4.9352645874023438e-05,
	3.6716461181640625e-05}, /* L449 */
{1.4549411535263062e+00, 3.9026141166687012e-05,
	1.1920928955078125e-07, -1.9013881683349609e-05,
	-6.4373016357421875e-06}, /* L450 */
{1.8678801059722900e+00, 5.0216913223266602e-05,
	1.1920928955078125e-07, 1.1920928955078125e-06,
	-3.2782554626464844e-05}, /* L451 */
{1.4219750165939331e+00, 3.8310885429382324e-05,
	1.1920928955078125e-07, -1.2218952178955078e-05,
	1.6093254089355469e-05}, /* L452 */
{1.5992830991744995e+00, 4.3183565139770508e-05,
	1.1920928955078125e-07, -8.2850456237792969e-06,
	-3.9935111999511719e-06}, /* L453 */
{1.6199494600296021e+00, 4.3839216232299805e-05,
	1.1920928955078125e-07, 5.3644180297851562e-06,
	-1.2874603271484375e-05}, /* L454 */
{1.5745905637741089e+00, 4.2706727981567383e-05,
	1.1920928955078125e-07, 1.5974044799804688e-05,
	1.8000602722167969e-05}, /* L455 */
{1.1753010749816895e+00, 3.1948089599609375e-05,
	1.1920928955078125e-07, -8.1062316894531250e-06,
	-1.5377998352050781e-05}, /* L456 */
{1.7690252065658569e+00, 4.8190355300903320e-05,
	1.1920928955078125e-07, -1.4483928680419922e-05,
	5.3644180297851562e-05}, /* L457 */
{1.5956801176071167e+00, 4.3570995330810547e-05,
	1.1920928955078125e-07, 3.9815902709960938e-05,
	3.9339065551757812e-05}, /* L458 */
{1.8886152505874634e+00, 5.1677227020263672e-05,
	1.1920928955078125e-07, -7.2300434112548828e-05,
	-5.1081180572509766e-05}, /* L459 */
{1.3969876766204834e+00, 3.8318336009979248e-05,
	1.1920928955078125e-07, -1.8531084060668945e-04,
	4.0888786315917969e-05}, /* L460 */
{1.3370511531829834e+00, 3.6744400858879089e-05,
	1.1920928955078125e-07, 6.0796737670898438e-06,
	1.6212463378906250e-05}, /* L461 */
{1.4320607185363770e+00, 3.9443373680114746e-05,
	1.1920928955078125e-07, 3.8862228393554688e-05,
	6.6637992858886719e-05}, /* L462 */
{2.2921895980834961e+00, 6.3270330429077148e-05,
	1.1920928955078125e-07, -7.0929527282714844e-06,
	8.3446502685546875e-07}, /* L463 */
{1.1130424737930298e+00, 3.0785799026489258e-05,
	1.1920928955078125e-07, 3.3617019653320312e-05,
	1.5497207641601562e-05}, /* L464 */
{1.4278841018676758e+00, 3.9577484130859375e-05,
	1.1920928955078125e-07, -4.2915344238281250e-06,
	-2.6226043701171875e-06}, /* L465 */
{1.7343291044235229e+00, 4.8175454139709473e-05,
	1.1920928955078125e-07, 2.5391578674316406e-05,
	3.4093856811523438e-05}, /* L466 */
{2.4806241989135742e+00, 6.9051980972290039e-05,
	1.1920928955078125e-07, -2.1874904632568359e-05,
	2.0265579223632812e-06}, /* L467 */
{1.6438926458358765e+00, 4.5888125896453857e-05,
	1.1920928955078125e-07, -1.3399124145507812e-04,
	2.3162364959716797e-04}, /* L468 */
{1.5724657773971558e+00, 4.3958425521850586e-05,
	1.1920928955078125e-07, -4.4107437133789062e-06,
	1.1920928955078125e-06}, /* L469 */
{1.3914444446563721e+00, 3.8981437683105469e-05,
	1.1920928955078125e-07, -2.7477741241455078e-05,
	-5.9008598327636719e-06}, /* L470 */
{2.3901672363281250e+00, 6.7353248596191406e-05,
	1.1920928955078125e-07, -1.0963082313537598e-03,
	3.8480758666992188e-04}, /* L471 */
{1.3177707195281982e+00, 3.7074089050292969e-05,
	1.1920928955078125e-07, 7.1525573730468750e-07,
	-6.5565109252929688e-07}, /* L472 */
{1.8872016668319702e+00, 5.3226947784423828e-05,
	1.1920928955078125e-07, 1.2218952178955078e-04,
	-8.6605548858642578e-05}, /* L473 */
{1.6083530187606812e+00, 4.5448541641235352e-05,
	1.1920928955078125e-07, -4.8160552978515625e-05,
	-5.7876110076904297e-05}, /* L474 */
{2.2076330184936523e+00, 6.2549486756324768e-05,
	1.1920928955078125e-07, 3.2305717468261719e-05,
	-8.5949897766113281e-05}, /* L475 */
{1.8506500720977783e+00, 5.2511692047119141e-05,
	1.1920928955078125e-07, -1.7583370208740234e-05,
	4.9829483032226562e-05}, /* L476 */
{1.5563946962356567e+00, 4.4254586100578308e-05,
	1.1920928955078125e-07, 7.5101852416992188e-06,
	2.2292137145996094e-05}, /* L477 */
{1.4549467563629150e+00, 4.1455030441284180e-05,
	1.1920928955078125e-07, -1.4364719390869141e-05,
	9.6559524536132812e-06}, /* L478 */
{1.6001528501510620e+00, 4.5686960220336914e-05,
	1.1920928955078125e-07, -1.2993812561035156e-05,
	7.9870223999023438e-06}, /* L479 */
{1.2010136842727661e+00, 3.4362077713012695e-05,
	1.1920928955078125e-07, -9.2983245849609375e-06,
	2.8133392333984375e-05}, /* L480 */
{2.1443805694580078e+00, 6.1499886214733124e-05,
	1.1920928955078125e-07, 2.1731853485107422e-04,
	-2.4747848510742188e-04}, /* L481 */
{1.4334194660186768e+00, 4.1186809539794922e-05,
	1.1920928955078125e-07, -2.3424625396728516e-05,
	-3.8385391235351562e-05}, /* L482 */
{2.8533124923706055e+00, 8.2150101661682129e-05,
	1.1920928955078125e-07, -3.6358833312988281e-06,
	-1.9669532775878906e-05}, /* L483 */
{1.6138882637023926e+00, 4.6559609472751617e-05,
	1.1920928955078125e-07, 7.2717666625976562e-06,
	5.7220458984375000e-06}, /* L484 */
{1.7997946739196777e+00, 5.2034854888916016e-05,
	1.1920928955078125e-07, 1.5497207641601562e-06,
	2.8610229492187500e-06}, /* L485 */
{1.7252374887466431e+00, 4.9978494644165039e-05,
	1.1920928955078125e-07, -1.5437602996826172e-05,
	-8.3446502685546875e-07}, /* L486 */
{1.7646968364715576e+00, 5.1230192184448242e-05,
	1.1920928955078125e-07, -1.3649463653564453e-05,
	5.0067901611328125e-06}, /* L487 */
{1.2334110736846924e+00, 3.5881996154785156e-05,
	1.1920928955078125e-07, 1.3983249664306641e-04,
	-1.0550022125244141e-04}, /* L488 */
{1.6880025863647461e+00, 4.9203634262084961e-05,
	1.1920928955078125e-07, -4.3094158172607422e-05,
	-4.7862529754638672e-05}, /* L489 */
{1.4370882511138916e+00, 4.1976571083068848e-05,
	1.1920928955078125e-07, 4.5657157897949219e-05,
	4.4226646423339844e-05}, /* L490 */
{1.9714584350585938e+00, 5.7697296142578125e-05,
	1.1920928955078125e-07, -1.1086463928222656e-05,
	1.3113021850585938e-06}, /* L491 */
{1.2537192106246948e+00, 3.6790966987609863e-05,
	1.1920928955078125e-07, -4.5514106750488281e-04,
	1.9037723541259766e-04}, /* L492 */
{1.8851481676101685e+00, 5.5402517318725586e-05,
	1.1920928955078125e-07, 2.5749206542968750e-05,
	-4.3511390686035156e-06}, /* L493 */
{1.2934750318527222e+00, 3.8087368011474609e-05,
	1.1920928955078125e-07, 1.5854835510253906e-05,
	-1.2993812561035156e-05}, /* L494 */
{1.4321814775466919e+00, 4.2259693145751953e-05,
	1.1920928955078125e-07, 1.3828277587890625e-05,
	-3.3974647521972656e-06}, /* L495 */
{1.6027979850769043e+00, 4.7385692596435547e-05,
	1.1920928955078125e-07, 4.2915344238281250e-06,
	-8.7618827819824219e-06}, /* L496 */
{3.0003693103790283e+00, 8.8885426521301270e-05,
	1.1920928955078125e-07, 1.7762184143066406e-05,
	2.3841857910156250e-06}, /* L497 */
{1.5569820404052734e+00, 4.6223402023315430e-05,
	1.1920928955078125e-07, -2.3782253265380859e-05,
	-7.6353549957275391e-05}, /* L498 */
{1.8373512029647827e+00, 5.4657459259033203e-05,
	1.1920928955078125e-07, -1.0550022125244141e-05,
	9.4175338745117188e-06}, /* L499 */
{1.4299178123474121e+00, 4.2617321014404297e-05,
	1.1920928955078125e-07, 2.0503997802734375e-05,
	-4.6491622924804688e-06}, /* L500 */
{1.9237428903579712e+00, 5.7458877563476562e-05,
	1.1920928955078125e-07, -1.2332201004028320e-04,
	8.7618827819824219e-05}, /* L501 */
{1.8328363895416260e+00, 5.4866075515747070e-05,
	1.1920928955078125e-07, -3.3974647521972656e-06,
	1.0097026824951172e-04}, /* L502 */
{1.6703130006790161e+00, 5.0157308578491211e-05,
	1.1920928955078125e-07, 9.1195106506347656e-04,
	9.8586082458496094e-05}, /* L503 */
{1.5158171653747559e+00, 4.5537948608398438e-05,
	1.1920928955078125e-07, -1.5616416931152344e-05,
	-9.5963478088378906e-06}, /* L504 */
{1.6176810264587402e+00, 4.8696994781494141e-05,
	1.1920928955078125e-07, 7.2717666625976562e-06,
	5.4597854614257812e-05}, /* L505 */
{1.8684779405593872e+00, 5.6356191635131836e-05,
	1.1920928955078125e-07, 2.7656555175781250e-05,
	-3.4570693969726562e-06}, /* L506 */
{1.5661144256591797e+00, 4.7355890274047852e-05,
	1.1920928955078125e-07, 3.8778781890869141e-04,
	1.7845630645751953e-04}, /* L507 */
{1.3048337697982788e+00, 3.9517879486083984e-05,
	1.1920928955078125e-07, -1.2242794036865234e-04,
	1.6045570373535156e-04}, /* L508 */
{1.8189114332199097e+00, 5.5193901062011719e-05,
	1.1920928955078125e-07, -7.2300434112548828e-05,
	1.2993812561035156e-05}, /* L509 */
{1.5116339921951294e+00, 4.5955181121826172e-05,
	1.1920928955078125e-07, 2.0265579223632812e-05,
	-1.3053417205810547e-05}, /* L510 */
{1.8814285993576050e+00, 5.7306140661239624e-05,
	1.1920928955078125e-07, -2.0265579223632812e-06,
	2.0265579223632812e-06}, /* L511 */
{1.1708426475524902e+00, 3.5732984542846680e-05,
	1.1920928955078125e-07, -2.4139881134033203e-05,
	-4.3511390686035156e-06}, /* L512 */
{2.1120026111602783e+00, 6.4596533775329590e-05,
	1.1920928955078125e-07, -8.6009502410888672e-05,
	1.8239021301269531e-05}, /* L513 */
{1.4439603090286255e+00, 4.4241547584533691e-05,
	1.1920928955078125e-07, 6.4373016357421875e-06,
	2.5033950805664062e-06}, /* L514 */
{1.5979857444763184e+00, 4.9054622650146484e-05,
	1.1920928955078125e-07, -2.4437904357910156e-06,
	-1.5735626220703125e-05}, /* L515 */
{1.2933988571166992e+00, 3.9786100387573242e-05,
	1.1920928955078125e-07, -1.3291835784912109e-05,
	4.7206878662109375e-05}, /* L516 */
{1.7539733648300171e+00, 5.4076313972473145e-05,
	1.1920928955078125e-07, -3.2663345336914062e-05,
	-1.1920928955078125e-06}, /* L517 */
{1.6794239282608032e+00, 5.1856040954589844e-05,
	1.1920928955078125e-07, 5.4597854614257812e-05,
	-4.0531158447265625e-06}, /* L518 */
{2.3837478160858154e+00, 7.3775649070739746e-05,
	1.1920928955078125e-07, -4.6193599700927734e-05,
	7.4863433837890625e-05}, /* L519 */
{1.7228910923004150e+00, 5.3405761718750000e-05,
	1.1920928955078125e-07, 2.3245811462402344e-05,
	-1.6391277313232422e-05}, /* L520 */
{1.7798842191696167e+00, 5.5283308029174805e-05,
	1.1920928955078125e-07, 3.2067298889160156e-05,
	4.7683715820312500e-06}, /* L521 */
{1.5915207862854004e+00, 4.9531459808349609e-05,
	1.1920928955078125e-07, -5.1856040954589844e-05,
	-7.9512596130371094e-05}, /* L522 */
{1.5825732946395874e+00, 4.9337744712829590e-05,
	1.1920928955078125e-07, -4.2319297790527344e-05,
	-2.8729438781738281e-05}, /* L523 */
{1.7380429506301880e+00, 5.4299831390380859e-05,
	1.1920928955078125e-07, 1.1587142944335938e-04,
	-3.6716461181640625e-05}, /* L524 */
{1.9938094615936279e+00, 6.2409788370132446e-05,
	1.1920928955078125e-07, 6.9856643676757812e-05,
	9.8228454589843750e-05}, /* L525 */
{1.4180817604064941e+00, 4.4465065002441406e-05,
	1.1920928955078125e-07, -1.3649463653564453e-05,
	-1.7881393432617188e-05}, /* L526 */
{2.1375603675842285e+00, 6.7159533500671387e-05,
	1.1920928955078125e-07, 3.6358833312988281e-05,
	3.9577484130859375e-05}, /* L527 */
{1.1469631195068359e+00, 3.6105513572692871e-05,
	1.1920928955078125e-07, -6.1571598052978516e-05,
	-9.8764896392822266e-05}, /* L528 */
{1.9883217811584473e+00, 6.2696635723114014e-05,
	1.1920928955078125e-07, 2.0980834960937500e-05,
	-3.1352043151855469e-05}, /* L529 */
{1.3770192861557007e+00, 4.3541193008422852e-05,
	1.1920928955078125e-07, 3.8874149322509766e-04,
	6.5863132476806641e-04}, /* L530 */
{2.2058985233306885e+00, 6.9886445999145508e-05,
	1.1920928955078125e-07, 5.4121017456054688e-04,
	4.1151046752929688e-04}, /* L531 */
{1.5841102600097656e+00, 5.0246715545654297e-05,
	1.1920928955078125e-07, -4.6610832214355469e-05,
	2.3126602172851562e-05}, /* L532 */
{2.0857522487640381e+00, 6.6280364990234375e-05,
	1.1920928955078125e-07, -1.8715858459472656e-04,
	-6.5505504608154297e-05}, /* L533 */
{1.6262593269348145e+00, 5.1766633987426758e-05,
	1.1920928955078125e-07, -7.1525573730468750e-06,
	-1.8477439880371094e-06}, /* L534 */
{2.2844505310058594e+00, 7.2896480560302734e-05,
	1.1920928955078125e-07, -2.1517276763916016e-04,
	-4.7028064727783203e-05}, /* L535 */
{1.3622577190399170e+00, 4.3522566556930542e-05,
	1.1920928955078125e-07, 2.0265579223632812e-06,
	1.5497207641601562e-06}, /* L536 */
{2.4697813987731934e+00, 7.9214572906494141e-05,
	1.1920928955078125e-07, -4.0233135223388672e-04,
	4.6169757843017578e-04}, /* L537 */
{1.7712352275848389e+00, 5.6803226470947266e-05,
	1.1920928955078125e-07, -2.3365020751953125e-05,
	1.8239021301269531e-05}, /* L538 */
{2.0681781768798828e+00, 6.6451728343963623e-05,
	1.1920928955078125e-07, -4.3928623199462891e-05,
	2.8014183044433594e-05}, /* L539 */
{1.2740193605422974e+00, 4.1007995605468750e-05,
	1.1920928955078125e-07, -1.0609626770019531e-05,
	5.3644180297851562e-06}, /* L540 */
{1.8242794275283813e+00, 5.8829784393310547e-05,
	1.1920928955078125e-07, 8.7022781372070312e-06,
	2.5391578674316406e-05}, /* L541 */
{1.8801038265228271e+00, 6.0742720961570740e-05,
	1.1920928955078125e-07, 2.3245811462402344e-05,
	-2.3841857910156250e-07}, /* L542 */
{2.4890363216400146e+00, 8.0674886703491211e-05,
	1.1920928955078125e-07, -4.7230720520019531e-04,
	4.3690204620361328e-04}, /* L543 */
{1.1174294948577881e+00, 3.6299228668212891e-05,
	1.1920928955078125e-07, -1.0230541229248047e-03,
	4.7206878662109375e-04}, /* L544 */
{1.5127042531967163e+00, 4.9144029617309570e-05,
	1.1920928955078125e-07, -8.1062316894531250e-06,
	6.7353248596191406e-05}, /* L545 */
{1.6661460399627686e+00, 5.4225325584411621e-05,
	1.1920928955078125e-07, 5.2452087402343750e-06,
	-1.8477439880371094e-06}, /* L546 */
{2.5797529220581055e+00, 8.4117054939270020e-05,
	1.1920928955078125e-07, -2.6524066925048828e-05,
	-6.4969062805175781e-06}, /* L547 */
{1.3775646686553955e+00, 4.5001506805419922e-05,
	1.1920928955078125e-07, -9.6559524536132812e-06,
	1.4662742614746094e-05}, /* L548 */
{1.7886276245117188e+00, 5.8531761169433594e-05,
	1.1920928955078125e-07, 7.0333480834960938e-06,
	3.0994415283203125e-06}, /* L549 */
{1.4162484407424927e+00, 4.6432018280029297e-05,
	1.1920928955078125e-07, -4.0888786315917969e-05,
	-3.1590461730957031e-06}, /* L550 */
{1.8445827960968018e+00, 6.0588121414184570e-05,
	1.1920928955078125e-07, 4.1961669921875000e-05,
	-8.1956386566162109e-05}, /* L551 */
{1.3449997901916504e+00, 4.4263899326324463e-05,
	1.1920928955078125e-07, -5.9127807617187500e-05,
	1.3303756713867188e-04}, /* L552 */
{2.3620522022247314e+00, 7.7892094850540161e-05,
	1.1920928955078125e-07, 1.3196468353271484e-04,
	7.8916549682617188e-05}, /* L553 */
{2.5797550678253174e+00, 8.5189938545227051e-05,
	1.1920928955078125e-07, -1.9371509552001953e-05,
	-2.2232532501220703e-05}, /* L554 */
{1.7089160680770874e+00, 5.6564807891845703e-05,
	1.1920928955078125e-07, -2.0903348922729492e-04,
	-3.6537647247314453e-04}, /* L555 */
{1.8557699918746948e+00, 6.1511993408203125e-05,
	1.1920928955078125e-07, -5.6624412536621094e-06,
	8.7022781372070312e-06}, /* L556 */
{1.9441162347793579e+00, 6.4555555582046509e-05,
	1.1920928955078125e-07, -7.8499317169189453e-05,
	-5.3644180297851562e-07}, /* L557 */
{1.5616192817687988e+00, 5.1952898502349854e-05,
	1.1920928955078125e-07, 6.0558319091796875e-05,
	-4.9710273742675781e-05}, /* L558 */
{1.9501540660858154e+00, 6.4983963966369629e-05,
	1.1920928955078125e-07, 1.2278556823730469e-05,
	8.2254409790039062e-06}, /* L559 */
{1.3543711900711060e+00, 4.5210123062133789e-05,
	1.1920928955078125e-07, 6.6041946411132812e-05,
	5.4240226745605469e-05}, /* L560 */
{1.4063452482223511e+00, 4.7028064727783203e-05,
	1.1920928955078125e-07, 1.7881393432617188e-06,
	1.6689300537109375e-06}, /* L561 */
{1.8284765481948853e+00, 6.1258673667907715e-05,
	1.1920928955078125e-07, -2.7716159820556641e-05,
	8.4400177001953125e-05}, /* L562 */
{1.9891018867492676e+00, 6.6757202148437500e-05,
	1.1920928955078125e-07, 7.9870223999023438e-06,
	2.0503997802734375e-05}, /* L563 */
{1.2601511478424072e+00, 4.2386353015899658e-05,
	1.1920928955078125e-07, 6.8187713623046875e-05,
	2.0551681518554688e-04}, /* L564 */
{2.6328744888305664e+00, 8.8691711425781250e-05,
	1.1920928955078125e-07, -1.8954277038574219e-05,
	1.1801719665527344e-05}, /* L565 */
{1.2064138650894165e+00, 4.0724873542785645e-05,
	1.1920928955078125e-07, -4.4703483581542969e-05,
	-1.0871887207031250e-04}, /* L566 */
{1.9801102876663208e+00, 6.6939741373062134e-05,
	1.1920928955078125e-07, -1.5854835510253906e-05,
	-9.4771385192871094e-06}, /* L567 */
{1.6323660612106323e+00, 5.5268406867980957e-05,
	1.1920928955078125e-07, 2.6226043701171875e-06,
	1.9311904907226562e-05}, /* L568 */
{2.1949086189270020e+00, 7.4453651905059814e-05,
	1.1920928955078125e-07, -3.3736228942871094e-05,
	3.7312507629394531e-05}, /* L569 */
{1.5454908609390259e+00, 5.2511692047119141e-05,
	1.1920928955078125e-07, -2.8610229492187500e-05,
	-4.9471855163574219e-06}, /* L570 */
{1.8847308158874512e+00, 6.4156949520111084e-05,
	1.1920928955078125e-07, 2.3365020751953125e-05,
	3.7670135498046875e-05}, /* L571 */
{1.4583042860031128e+00, 4.9725174903869629e-05,
	1.1920928955078125e-07, 1.1324882507324219e-05,
	-1.6212463378906250e-05}, /* L572 */
{1.6519047021865845e+00, 5.6430697441101074e-05,
	1.1920928955078125e-07, -3.3736228942871094e-05,
	2.3841857910156250e-06}, /* L573 */
{2.0911381244659424e+00, 7.1555376052856445e-05,
	1.1920928955078125e-07, 5.8531761169433594e-05,
	-3.8683414459228516e-05}, /* L574 */
{1.9214581251144409e+00, 6.5855681896209717e-05,
	1.1920928955078125e-07, 9.5367431640625000e-07,
	1.1682510375976562e-05}, /* L575 */
{1.5375909805297852e+00, 5.2809715270996094e-05,
	1.1920928955078125e-07, -1.0848045349121094e-05,
	-1.8298625946044922e-05}, /* L576 */
{2.2455751895904541e+00, 7.7247619628906250e-05,
	1.1920928955078125e-07, -7.0989131927490234e-05,
	-7.2538852691650391e-05}, /* L577 */
{1.9759218692779541e+00, 6.8128108978271484e-05,
	1.1920928955078125e-07, 2.5439262390136719e-04,
	1.5568733215332031e-04}, /* L578 */
{1.8755239248275757e+00, 6.4730644226074219e-05,
	1.1920928955078125e-07, -2.7358531951904297e-05,
	1.9192695617675781e-05}, /* L579 */
{1.4489516019821167e+00, 5.0097703933715820e-05,
	1.1920928955078125e-07, -6.0796737670898438e-06,
	-9.2148780822753906e-05}, /* L580 */
{1.9765557050704956e+00, 6.8455934524536133e-05,
	1.1920928955078125e-07, 4.8518180847167969e-05,
	2.4676322937011719e-05}, /* L581 */
{1.7823493480682373e+00, 6.1838421970605850e-05,
	1.1920928955078125e-07, 7.0452690124511719e-05,
	-3.9577484130859375e-05}, /* L582 */
{1.9847927093505859e+00, 6.8992376327514648e-05,
	1.1920928955078125e-07, -1.4102458953857422e-04,
	-1.1551380157470703e-04}, /* L583 */
{1.6148413419723511e+00, 5.6236982345581055e-05,
	1.1920928955078125e-07, 1.1193752288818359e-04,
	1.9228458404541016e-04}, /* L584 */
{1.6655808687210083e+00, 5.8084726333618164e-05,
	1.1920928955078125e-07, 3.0279159545898438e-05,
	6.9737434387207031e-05}, /* L585 */
{1.5255374908447266e+00, 5.3286552429199219e-05,
	1.1920928955078125e-07, -1.9073486328125000e-06,
	1.1920928955078125e-06}, /* L586 */
{2.1680901050567627e+00, 7.5906515121459961e-05,
	1.1920928955078125e-07, 1.7738342285156250e-04,
	-1.2791156768798828e-04}, /* L587 */
{1.6040347814559937e+00, 5.6222081184387207e-05,
	1.1920928955078125e-07, -8.2850456237792969e-06,
	2.8014183044433594e-05}, /* L588 */
{1.8398293256759644e+00, 6.4596533775329590e-05,
	1.1920928955078125e-07, 4.6253204345703125e-05,
	-1.0728836059570312e-05}, /* L589 */
{1.7839291095733643e+00, 6.2739476561546326e-05,
	1.1920928955078125e-07, 1.1920928955078125e-05,
	-2.4378299713134766e-05}, /* L590 */
{2.0794355869293213e+00, 7.3254108428955078e-05,
	1.1920928955078125e-07, 3.2186508178710938e-06,
	-6.3180923461914062e-06}, /* L591 */
{1.3141304254531860e+00, 4.6372413635253906e-05,
	1.1920928955078125e-07, -2.0563602447509766e-05,
	-3.0398368835449219e-06}, /* L592 */
{2.3994657993316650e+00, 8.4817409515380859e-05,
	1.1920928955078125e-07, -8.2254409790039062e-06,
	-8.2850456237792969e-06}, /* L593 */
{1.4220618009567261e+00, 5.0351023674011230e-05,
	1.1920928955078125e-07, 2.4318695068359375e-05,
	3.5762786865234375e-06}, /* L594 */
{2.5241303443908691e+00, 8.9526176452636719e-05,
	1.1920928955078125e-07, -2.0861625671386719e-05,
	-2.7000904083251953e-05}, /* L595 */
{1.3361352682113647e+00, 4.7475099563598633e-05,
	1.1920928955078125e-07, -4.3749809265136719e-05,
	8.8810920715332031e-05}, /* L596 */
{2.0933060646057129e+00, 7.4543058872222900e-05,
	1.1920928955078125e-07, -2.2786855697631836e-04,
	-1.5568733215332031e-04}, /* L597 */
{1.5026714801788330e+00, 5.3562223911285400e-05,
	1.1920928955078125e-07, -2.0623207092285156e-05,
	1.1801719665527344e-05}, /* L598 */
{2.3488039970397949e+00, 8.3871185779571533e-05,
	1.1920928955078125e-07, -2.0921230316162109e-05,
	-1.3828277587890625e-05}, /* L599 */
{1.5045223236083984e+00, 5.4046511650085449e-05,
	1.1920928955078125e-07, -1.7131567001342773e-03,
	-1.7565488815307617e-04}, /* L600 */
{2.3155241012573242e+00, 8.2954764366149902e-05,
	1.1920928955078125e-07, 3.3736228942871094e-05,
	3.4332275390625000e-05}, /* L601 */
{1.6143763065338135e+00, 5.7935714721679688e-05,
	1.1920928955078125e-07, -1.4126300811767578e-05,
	1.0251998901367188e-04}, /* L602 */
{1.9007269144058228e+00, 6.9916248321533203e-05,
	1.1920928955078125e-07, 1.9938945770263672e-03,
	-4.5305490493774414e-03}, /* L603 */
{1.7690852880477905e+00, 6.3866376876831055e-05,
	1.1920928955078125e-07, 1.0811090469360352e-03,
	-9.1552734375000000e-05}, /* L604 */
{1.5756504535675049e+00, 5.6833028793334961e-05,
	1.1920928955078125e-07, -3.8564205169677734e-05,
	5.1021575927734375e-05}, /* L605 */
{1.8765380382537842e+00, 6.7844986915588379e-05,
	1.1920928955078125e-07, 3.2866001129150391e-04,
	-2.3740530014038086e-04}, /* L606 */
{1.8488636016845703e+00, 6.6906213760375977e-05,
	1.1920928955078125e-07, 1.3947486877441406e-05,
	-2.1874904632568359e-05}, /* L607 */
{1.4143947362899780e+00, 5.1259994506835938e-05,
	1.1920928955078125e-07, -1.3709068298339844e-06,
	2.6226043701171875e-06}, /* L608 */
{2.0909426212310791e+00, 7.5902789831161499e-05,
	1.1920928955078125e-07, 1.7762184143066406e-05,
	2.6583671569824219e-05}, /* L609 */
{1.3745304346084595e+00, 4.9978494644165039e-05,
	1.1920928955078125e-07, 4.6491622924804688e-06,
	1.8239021301269531e-05}, /* L610 */
{2.4753224849700928e+00, 9.0152025222778320e-05,
	1.1920928955078125e-07, 1.1444091796875000e-05,
	5.0067901611328125e-06}, /* L611 */
{1.6272025108337402e+00, 5.9366226196289062e-05,
	1.1920928955078125e-07, 5.0663948059082031e-05,
	-2.9206275939941406e-05}, /* L612 */
{3.0513265132904053e+00, 1.1150538921356201e-04,
	1.1920928955078125e-07, 1.2254714965820312e-04,
	4.8518180847167969e-05}, /* L613 */
{1.8124324083328247e+00, 6.6339969635009766e-05,
	1.1920928955078125e-07, -3.0875205993652344e-05,
	-2.6702880859375000e-05}, /* L614 */
{2.3179955482482910e+00, 8.4973871707916260e-05,
	1.1920928955078125e-07, 7.1525573730468750e-07,
	-7.3909759521484375e-06}, /* L615 */
{1.4465979337692261e+00, 5.3122639656066895e-05,
	1.1920928955078125e-07, -6.5624713897705078e-05,
	-7.2598457336425781e-05}, /* L616 */
{1.9851582050323486e+00, 7.3015689849853516e-05,
	1.1920928955078125e-07, -3.6537647247314453e-05,
	-3.4689903259277344e-05}, /* L617 */
{1.6008641719818115e+00, 5.8978796005249023e-05,
	1.1920928955078125e-07, -2.8789043426513672e-05,
	3.9935111999511719e-05}, /* L618 */
{2.4319202899932861e+00, 9.0032815933227539e-05,
	1.1920928955078125e-07, 1.8596649169921875e-04,
	5.7005882263183594e-04}, /* L619 */
{1.2795324325561523e+00, 4.7303736209869385e-05,
	1.1920928955078125e-07, -1.3625621795654297e-04,
	-2.0462274551391602e-04}, /* L620 */
{1.9249027967453003e+00, 7.1257352828979492e-05,
	1.1920928955078125e-07, -2.3066997528076172e-05,
	-4.9173831939697266e-05}, /* L621 */
{1.5663186311721802e+00, 6.0141086578369141e-05,
	1.1920928955078125e-07, 1.0178685188293457e-02,
	-8.8712573051452637e-03}, /* L622 */
{2.0397434234619141e+00, 7.5757503509521484e-05,
	1.1920928955078125e-07, -7.9989433288574219e-05,
	5.7697296142578125e-05}, /* L623 */
{1.7867767810821533e+00, 6.6459178924560547e-05,
	1.1920928955078125e-07, -1.3113021850585938e-05,
	1.0967254638671875e-05}, /* L624 */
{2.2703139781951904e+00, 8.4578990936279297e-05,
	1.1920928955078125e-07, -3.2782554626464844e-06,
	1.0967254638671875e-05}, /* L625 */
{1.4727154970169067e+00, 5.4955482482910156e-05,
	1.1920928955078125e-07, 3.9815902709960938e-05,
	-2.0027160644531250e-05}, /* L626 */
{2.3553121089935303e+00, 8.8065862655639648e-05,
	1.1920928955078125e-07, -2.2053718566894531e-06,
	-4.1127204895019531e-05}, /* L627 */
{1.9906022548675537e+00, 7.4528157711029053e-05,
	1.1920928955078125e-07, 1.1920928955078125e-07,
	-9.1552734375000000e-05}, /* L628 */
{2.0324523448944092e+00, 7.6442956924438477e-05,
	1.1920928955078125e-07, -9.3936920166015625e-05,
	-7.6889991760253906e-06}, /* L629 */
{1.5852142572402954e+00, 5.9545040130615234e-05,
	1.1920928955078125e-07, 8.2731246948242188e-05,
	6.2942504882812500e-05}, /* L630 */
{2.0764775276184082e+00, 7.8111886978149414e-05,
	1.1920928955078125e-07, -9.2387199401855469e-05,
	-1.1205673217773438e-05}, /* L631 */
{1.4855570793151855e+00, 5.5968761444091797e-05,
	1.1920928955078125e-07, 3.6835670471191406e-05,
	1.4781951904296875e-05}, /* L632 */
{1.9674001932144165e+00, 7.4237585067749023e-05,
	1.1920928955078125e-07, -4.2378902435302734e-05,
	-4.1365623474121094e-05}, /* L633 */
{1.6323432922363281e+00, 6.1690807342529297e-05,
	1.1920928955078125e-07, -1.5139579772949219e-05,
	-1.7702579498291016e-05}, /* L634 */
{2.1113648414611816e+00, 7.9929828643798828e-05,
	1.1920928955078125e-07, 5.0425529479980469e-05,
	1.1193752288818359e-04}, /* L635 */
{1.2945275306701660e+00, 4.9090012907981873e-05,
	1.1920928955078125e-07, -6.0021877288818359e-05,
	3.5047531127929688e-05}, /* L636 */
{2.1913280487060547e+00, 8.3208084106445312e-05,
	1.1920928955078125e-07, -2.4199485778808594e-05,
	4.5299530029296875e-06}, /* L637 */
{1.6423569917678833e+00, 6.2465667724609375e-05,
	1.1920928955078125e-07, -4.9352645874023438e-05,
	-1.7881393432617188e-05}, /* L638 */
{2.6317546367645264e+00, 1.0025501251220703e-04,
	1.1920928955078125e-07, -9.5188617706298828e-05,
	5.5551528930664062e-05}, /* L639 */
{1.5197391510009766e+00, 5.7980418205261230e-05,
	1.1920928955078125e-07, -3.1471252441406250e-05,
	-7.5697898864746094e-06}, /* L640 */
{2.0298442840576172e+00, 7.7560544013977051e-05,
	1.1920928955078125e-07, 1.7881393432617188e-06,
	2.4199485778808594e-05}, /* L641 */
{1.7032957077026367e+00, 6.5207481384277344e-05,
	1.1920928955078125e-07, 1.6272068023681641e-04,
	3.2114982604980469e-04}, /* L642 */
{2.6641292572021484e+00, 1.0213255882263184e-04,
	1.1920928955078125e-07, -3.7610530853271484e-05,
	3.7908554077148438e-05}, /* L643 */
{1.5146787166595459e+00, 5.8144330978393555e-05,
	1.1920928955078125e-07, 4.7683715820312500e-07,
	2.5510787963867188e-05}, /* L644 */
{2.3670682907104492e+00, 9.1016292572021484e-05,
	1.1920928955078125e-07, -5.7995319366455078e-05,
	-9.5963478088378906e-06}, /* L645 */
{1.4300638437271118e+00, 5.5074691772460938e-05,
	1.1920928955078125e-07, -1.0967254638671875e-05,
	-4.3749809265136719e-05}, /* L646 */
{2.1134412288665771e+00, 8.1509351730346680e-05,
	1.1920928955078125e-07, -1.1444091796875000e-05,
	1.5854835510253906e-05}, /* L647 */
{1.5568636655807495e+00, 6.0141086578369141e-05,
	1.1920928955078125e-07, -1.3113021850585938e-06,
	-5.8114528656005859e-05}, /* L648 */
{2.3709924221038818e+00, 9.1731548309326172e-05,
	1.1920928955078125e-07, -9.0479850769042969e-05,
	-4.3332576751708984e-05}, /* L649 */
{2.1227021217346191e+00, 8.2246959209442139e-05,
	1.1920928955078125e-07, 4.0054321289062500e-05,
	-1.8060207366943359e-05}, /* L650 */
{2.1325259208679199e+00, 8.2761049270629883e-05,
	1.1920928955078125e-07, -4.0650367736816406e-05,
	5.8889389038085938e-05}, /* L651 */
{1.6527670621871948e+00, 6.4238905906677246e-05,
	1.1920928955078125e-07, -7.7605247497558594e-05,
	-1.2874603271484375e-05}, /* L652 */
{2.0956957340240479e+00, 8.1576406955718994e-05,
	1.1920928955078125e-07, 2.8610229492187500e-05,
	3.5762786865234375e-05}, /* L653 */
{1.7779228687286377e+00, 6.9320201873779297e-05,
	1.1920928955078125e-07, -2.3186206817626953e-05,
	-7.4148178100585938e-05}, /* L654 */
{2.0511028766632080e+00, 8.0108642578125000e-05,
	1.1920928955078125e-07, 7.6770782470703125e-05,
	5.1021575927734375e-05}, /* L655 */
{1.3253511190414429e+00, 5.1826238632202148e-05,
	1.1920928955078125e-07, 1.6689300537109375e-05,
	4.7564506530761719e-05}, /* L656 */
{2.5021166801452637e+00, 9.7990036010742188e-05,
	1.1920928955078125e-07, 1.6808509826660156e-05,
	2.0980834960937500e-05}, /* L657 */
{1.9000769853591919e+00, 7.4535608291625977e-05,
	1.1920928955078125e-07, -5.1021575927734375e-05,
	-2.1040439605712891e-05}, /* L658 */
{2.0332217216491699e+00, 7.9870223999023438e-05,
	1.1920928955078125e-07, 1.6450881958007812e-05,
	-2.0802021026611328e-05}, /* L659 */
{1.9172517061233521e+00, 7.5459480285644531e-05,
	1.1920928955078125e-07, -2.4586915969848633e-04,
	1.3577938079833984e-04}, /* L660 */
{2.0582592487335205e+00, 8.1121921539306641e-05,
	1.1920928955078125e-07, -3.2007694244384766e-05,
	1.4424324035644531e-05}, /* L661 */
{1.8238137960433960e+00, 7.1972608566284180e-05,
	1.1920928955078125e-07, 3.6239624023437500e-05,
	-7.1525573730468750e-07}, /* L662 */
{2.4307048320770264e+00, 9.6090137958526611e-05,
	1.1920928955078125e-07, 1.1634826660156250e-04,
	1.5175342559814453e-04}, /* L663 */
{2.2247557640075684e+00, 8.8065862655639648e-05,
	1.1920928955078125e-07, -3.6895275115966797e-05,
	-5.4836273193359375e-05}, /* L664 */
{2.1818363666534424e+00, 8.6486339569091797e-05,
	1.1920928955078125e-07, -1.6689300537109375e-05,
	7.5101852416992188e-06}, /* L665 */
{1.5005662441253662e+00, 5.9574842453002930e-05,
	1.1920928955078125e-07, 1.5497207641601562e-05,
	7.1525573730468750e-05}, /* L666 */
{1.7042199373245239e+00, 6.7770481109619141e-05,
	1.1920928955078125e-07, -1.4209747314453125e-04,
	-7.4684619903564453e-05}, /* L667 */
{1.7735772132873535e+00, 7.0720911026000977e-05,
	1.1920928955078125e-07, -4.5776367187500000e-05,
	-4.1878223419189453e-04}, /* L668 */
{2.4194667339324951e+00, 9.6499919891357422e-05,
	1.1920928955078125e-07, -6.6697597503662109e-05,
	-4.6670436859130859e-05}, /* L669 */
{1.8383078575134277e+00, 7.3418021202087402e-05,
	1.1920928955078125e-07, 1.7881393432617188e-05,
	3.0994415283203125e-05}, /* L670 */
{2.0879681110382080e+00, 8.4072351455688477e-05,
	1.1920928955078125e-07, 8.7618827819824219e-05,
	-1.3321638107299805e-03}, /* L671 */
{1.5840317010879517e+00, 6.3461717218160629e-05,
	1.1920928955078125e-07, 5.3405761718750000e-05,
	1.0895729064941406e-04}, /* L672 */
{2.1310641765594482e+00, 8.5526145994663239e-05,
	1.1920928955078125e-07, 1.9943714141845703e-04,
	-4.7683715820312500e-05}, /* L673 */
{1.7927044630050659e+00, 7.2032213211059570e-05,
	1.1920928955078125e-07, 3.8743019104003906e-05,
	-5.7756900787353516e-05}, /* L674 */
{2.6735394001007080e+00, 1.0758638381958008e-04,
	1.1920928955078125e-07, -1.0967254638671875e-05,
	4.9829483032226562e-05}, /* L675 */
{1.4583964347839355e+00, 5.8770179748535156e-05,
	1.1920928955078125e-07, -3.9994716644287109e-05,
	1.7642974853515625e-05}, /* L676 */
{2.1142892837524414e+00, 8.5324048995971680e-05,
	1.1920928955078125e-07, -1.3530254364013672e-05,
	-3.7550926208496094e-05}, /* L677 */
{2.0122616291046143e+00, 8.1360340118408203e-05,
	1.1920928955078125e-07, -1.4501810073852539e-04,
	9.1910362243652344e-05}, /* L678 */
{2.5132310390472412e+00, 1.0180473327636719e-04,
	1.1920928955078125e-07, -1.3697147369384766e-04,
	-2.7519464492797852e-04}, /* L679 */
{1.6729816198348999e+00, 6.7904591560363770e-05,
	1.1920928955078125e-07, 1.9395351409912109e-04,
	1.2373924255371094e-04}, /* L680 */
{1.9207093715667725e+00, 7.7992677688598633e-05,
	1.1920928955078125e-07, -2.2923946380615234e-04,
	4.4345855712890625e-05}, /* L681 */
{1.6612211465835571e+00, 6.7532062530517578e-05,
	1.1920928955078125e-07, 1.8715858459472656e-05,
	-1.9073486328125000e-06}, /* L682 */
{2.1305842399597168e+00, 8.6741521954536438e-05,
	1.1920928955078125e-07, 3.4928321838378906e-05,
	-1.2695789337158203e-05}, /* L683 */
{1.5932800769805908e+00, 6.4969062805175781e-05,
	1.1920928955078125e-07, 3.3020973205566406e-05,
	-7.5817108154296875e-05}, /* L684 */
{2.7835290431976318e+00, 1.1366605758666992e-04,
	1.1920928955078125e-07, -7.8141689300537109e-05,
	6.0796737670898438e-06}, /* L685 */
{1.6650556325912476e+00, 6.8090856075286865e-05,
	1.1920928955078125e-07, 6.2704086303710938e-05,
	-6.9200992584228516e-05}, /* L686 */
{2.4516501426696777e+00, 1.0042637586593628e-04,
	1.1920928955078125e-07, 1.4770030975341797e-04,
	-6.3180923461914062e-06}, /* L687 */
{1.5984659194946289e+00, 6.5565109252929688e-05,
	1.1920928955078125e-07, 8.9645385742187500e-05,
	1.8858909606933594e-04}, /* L688 */
{2.3781969547271729e+00, 9.7721815109252930e-05,
	1.1920928955078125e-07, 1.8191337585449219e-04,
	1.3828277587890625e-05}, /* L689 */
{1.8992320299148560e+00, 7.8186392784118652e-05,
	1.1920928955078125e-07, 6.3717365264892578e-04,
	1.4519691467285156e-04}, /* L690 */
{3.2192499637603760e+00, 1.3259798288345337e-04,
	1.1920928955078125e-07, 3.9339065551757812e-06,
	-1.2934207916259766e-05}, /* L691 */
{2.1815905570983887e+00, 9.0003013610839844e-05,
	1.1920928955078125e-07, -4.1842460632324219e-05,
	5.6266784667968750e-05}, /* L692 */
{2.3006222248077393e+00, 9.5039606094360352e-05,
	1.1920928955078125e-07, 1.9550323486328125e-05,
	-3.8146972656250000e-06}, /* L693 */
{1.7378700971603394e+00, 7.1972608566284180e-05,
	1.1920928955078125e-07, 6.6399574279785156e-04,
	4.0578842163085938e-04}, /* L694 */
{2.1271150112152100e+00, 8.8129192590713501e-05,
	1.1920928955078125e-07, 2.4676322937011719e-05,
	-2.6464462280273438e-05}, /* L695 */
{1.5232470035552979e+00, 6.3210725784301758e-05,
	1.1920928955078125e-07, 3.0350685119628906e-04,
	-8.5234642028808594e-06}, /* L696 */
{2.3591012954711914e+00, 9.8019838333129883e-05,
	1.1920928955078125e-07, -1.2516975402832031e-06,
	-3.7431716918945312e-05}, /* L697 */
{1.4241330623626709e+00, 5.9261918067932129e-05,
	1.1920928955078125e-07, 5.4597854614257812e-05,
	1.1086463928222656e-04}, /* L698 */
{2.5482177734375000e+00, 1.0618567466735840e-04,
	1.1920928955078125e-07, 1.3709068298339844e-05,
	-5.0663948059082031e-05}, /* L699 */
{2.2483475208282471e+00, 9.3825161457061768e-05,
	1.1920928955078125e-07, 2.3126602172851562e-05,
	-1.0019540786743164e-04}, /* L700 */
{2.0393238067626953e+00, 8.5219740867614746e-05,
	1.1920928955078125e-07, -1.6272068023681641e-05,
	-4.4226646423339844e-05}, /* L701 */
{1.5482857227325439e+00, 6.4790248870849609e-05,
	1.1920928955078125e-07, 1.2993812561035156e-05,
	3.5285949707031250e-05}, /* L702 */
{2.4991180896759033e+00, 1.0472536087036133e-04,
	1.1920928955078125e-07, 1.0728836059570312e-06,
	-3.5881996154785156e-05}, /* L703 */
{1.5704832077026367e+00, 6.5907835960388184e-05,
	1.1920928955078125e-07, -5.0365924835205078e-05,
	5.8889389038085938e-05}, /* L704 */
{1.8420673608779907e+00, 7.7411532402038574e-05,
	1.1920928955078125e-07, -2.8610229492187500e-06,
	1.2516975402832031e-05}, /* L705 */
{1.9447143077850342e+00, 8.1844627857208252e-05,
	1.1920928955078125e-07, -2.5033950805664062e-06,
	1.4662742614746094e-05}, /* L706 */
{1.8109430074691772e+00, 7.6323747634887695e-05,
	1.1920928955078125e-07, -2.8431415557861328e-05,
	-1.1086463928222656e-05}, /* L707 */
{1.7746196985244751e+00, 7.4893236160278320e-05,
	1.1920928955078125e-07, 1.7523765563964844e-05,
	-1.4901161193847656e-05}, /* L708 */
{2.2037153244018555e+00, 9.3132257461547852e-05,
	1.1920928955078125e-07, -2.4020671844482422e-05,
	-8.4042549133300781e-06}, /* L709 */
{1.8982046842575073e+00, 8.0347061157226562e-05,
	1.1920928955078125e-07, 7.6889991760253906e-05,
	9.2625617980957031e-05}, /* L710 */
{2.3009641170501709e+00, 9.7535550594329834e-05,
	1.1920928955078125e-07, 9.4056129455566406e-05,
	-7.5995922088623047e-05}, /* L711 */
{1.8467736244201660e+00, 7.8380107879638672e-05,
	1.1920928955078125e-07, 9.2983245849609375e-06,
	-1.4722347259521484e-05}, /* L712 */
{2.3193156719207764e+00, 9.8586082458496094e-05,
	1.1920928955078125e-07, -3.8385391235351562e-05,
	1.3148784637451172e-04}, /* L713 */
{1.5044926404953003e+00, 6.4060091972351074e-05,
	1.1920928955078125e-07, 2.5391578674316406e-05,
	-1.0287761688232422e-04}, /* L714 */
{2.4640564918518066e+00, 1.0502105578780174e-04,
	1.1920928955078125e-07, 1.1563301086425781e-05,
	-2.5212764739990234e-05}, /* L715 */
{1.4508104324340820e+00, 6.1929225921630859e-05,
	1.1920928955078125e-07, 3.4451484680175781e-05,
	5.0783157348632812e-05}, /* L716 */
{2.8503692150115967e+00, 1.2182514183223248e-04,
	1.1920928955078125e-07, -2.4557113647460938e-05,
	-3.2007694244384766e-05}, /* L717 */
{1.6732673645019531e+00, 7.1629881858825684e-05,
	1.1920928955078125e-07, -1.2427568435668945e-04,
	5.6982040405273438e-05}, /* L718 */
{2.6061861515045166e+00, 1.1169910430908203e-04,
	1.1920928955078125e-07, 1.6808509826660156e-05,
	5.0067901611328125e-06}, /* L719 */
{1.6390521526336670e+00, 7.0348381996154785e-05,
	1.1920928955078125e-07, 2.1219253540039062e-05,
	3.0755996704101562e-05}, /* L720 */
{2.1678194999694824e+00, 9.3311071395874023e-05,
	1.1920928955078125e-07, 3.7372112274169922e-04,
	3.8850307464599609e-04}, /* L721 */
{2.6578068733215332e+00, 1.1439993977546692e-04,
	1.1920928955078125e-07, 4.7445297241210938e-05,
	-3.8743019104003906e-06}, /* L722 */
{2.1623153686523438e+00, 9.3191862106323242e-05,
	1.1920928955078125e-07, -3.2484531402587891e-05,
	4.0531158447265625e-06}, /* L723 */
{1.8753557205200195e+00, 8.0950558185577393e-05,
	1.1920928955078125e-07, -1.2433528900146484e-04,
	9.3340873718261719e-05}, /* L724 */
{2.0813694000244141e+00, 8.9973211288452148e-05,
	1.1920928955078125e-07, -8.0466270446777344e-06,
	9.7393989562988281e-05}, /* L725 */
{1.8653182983398438e+00, 8.0749392509460449e-05,
	1.1920928955078125e-07, -7.1704387664794922e-05,
	-3.1232833862304688e-05}, /* L726 */
{2.4434025287628174e+00, 1.0606646537780762e-04,
	1.1920928955078125e-07, 6.6399574279785156e-05,
	-5.0604343414306641e-04}, /* L727 */
{2.0144994258880615e+00, 8.7417662143707275e-05,
	1.1920928955078125e-07, 1.3113021850585938e-06,
	1.7046928405761719e-05}, /* L728 */
{2.3468518257141113e+00, 1.0198354721069336e-04,
	1.1920928955078125e-07, -6.9141387939453125e-06,
	-1.9252300262451172e-05}, /* L729 */
{2.1878738403320312e+00, 9.5205381512641907e-05,
	1.1920928955078125e-07, 2.3126602172851562e-05,
	-4.0829181671142578e-05}, /* L730 */
{2.0849571228027344e+00, 9.0867280960083008e-05,
	1.1920928955078125e-07, 1.6140937805175781e-04,
	-1.1962652206420898e-04}, /* L731 */
{1.8179992437362671e+00, 7.9438090324401855e-05,
	1.1920928955078125e-07, -2.4360418319702148e-04,
	-8.9824199676513672e-05}, /* L732 */
{2.5820033550262451e+00, 1.1283159255981445e-04,
	1.1920928955078125e-07, -3.1709671020507812e-05,
	1.1861324310302734e-04}, /* L733 */
{1.8074448108673096e+00, 7.9087913036346436e-05,
	1.1920928955078125e-07, 8.4638595581054688e-06,
	5.7697296142578125e-05}, /* L734 */
{2.4708244800567627e+00, 1.0840594768524170e-04,
	1.1920928955078125e-07, -2.1648406982421875e-04,
	-2.2238492965698242e-04}, /* L735 */
{1.6010068655014038e+00, 7.0244073867797852e-05,
	1.1920928955078125e-07, -4.9352645874023438e-05,
	2.8252601623535156e-05}, /* L736 */
{2.3253154754638672e+00, 1.0219216346740723e-04,
	1.1920928955078125e-07, 1.1670589447021484e-04,
	-3.5166740417480469e-05}, /* L737 */
{2.0730040073394775e+00, 9.1198366135358810e-05,
	1.1920928955078125e-07, -1.1384487152099609e-05,
	2.1815299987792969e-05}, /* L738 */
{1.9021102190017700e+00, 8.3804130554199219e-05,
	1.1920928955078125e-07, 4.6849250793457031e-05,
	4.0531158447265625e-05}, /* L739 */
{2.0837171077728271e+00, 9.1917812824249268e-05,
	1.1920928955078125e-07, 5.7220458984375000e-06,
	-1.3589859008789062e-05}, /* L740 */
{2.2527699470520020e+00, 9.9506229162216187e-05,
	1.1920928955078125e-07, -1.7881393432617188e-07,
	-2.6881694793701172e-05}, /* L741 */
{2.2909371852874756e+00, 1.0132789611816406e-04,
	1.1920928955078125e-07, -1.1861324310302734e-05,
	-1.1980533599853516e-05}, /* L742 */
{2.2969572544097900e+00, 1.0174512863159180e-04,
	1.1920928955078125e-07, 2.8491020202636719e-05,
	8.4280967712402344e-05}, /* L743 */
{1.9732756614685059e+00, 8.7529420852661133e-05,
	1.1920928955078125e-07, 6.8426132202148438e-05,
	7.2002410888671875e-05}, /* L744 */
{2.4999938011169434e+00, 1.1104345321655273e-04,
	1.1920928955078125e-07, -4.2736530303955078e-05,
	-7.4505805969238281e-06}, /* L745 */
{1.5474489927291870e+00, 6.8813562393188477e-05,
	1.1920928955078125e-07, -1.5616416931152344e-05,
	6.2465667724609375e-05}, /* L746 */
{2.2551591396331787e+00, 1.0041892528533936e-04,
	1.1920928955078125e-07, 3.8743019104003906e-05,
	7.2836875915527344e-05}, /* L747 */
{1.7177096605300903e+00, 7.6591968536376953e-05,
	1.1920928955078125e-07, -2.5033950805664062e-06,
	4.0531158447265625e-06}, /* L748 */
{2.5548388957977295e+00, 1.1406838893890381e-04,
	1.1920928955078125e-07, -1.8775463104248047e-05,
	4.7326087951660156e-05}, /* L749 */
{1.9981343746185303e+00, 8.9406967163085938e-05,
	1.1920928955078125e-07, 2.9921531677246094e-05,
	2.2137165069580078e-04}, /* L750 */
{1.9038611650466919e+00, 8.5271894931793213e-05,
	1.1920928955078125e-07, -4.2915344238281250e-06,
	-2.1803379058837891e-04}, /* L751 */
{1.4420906305313110e+00, 6.4641237258911133e-05,
	1.1920928955078125e-07, -1.3411045074462891e-05,
	2.3365020751953125e-05}, /* L752 */
{1.7621377706527710e+00, 7.9095363616943359e-05,
	1.1920928955078125e-07, 1.3947486877441406e-05,
	8.2254409790039062e-06}, /* L753 */
{1.8378251791000366e+00, 8.2623213529586792e-05,
	1.1920928955078125e-07, -1.2505054473876953e-04,
	-1.2516975402832031e-06}, /* L754 */
{2.3051035404205322e+00, 1.0374188423156738e-04,
	1.1920928955078125e-07, 1.0728836059570312e-05,
	1.9431114196777344e-05}, /* L755 */
{1.5710618495941162e+00, 7.0810317993164062e-05,
	1.1920928955078125e-07, 1.0728836059570312e-06,
	-1.0699033737182617e-04}, /* L756 */
{2.3700528144836426e+00, 1.0696798563003540e-04,
	1.1920928955078125e-07, 5.1140785217285156e-05,
	-5.9604644775390625e-07}, /* L757 */
{1.8858487606048584e+00, 8.5234642028808594e-05,
	1.1920928955078125e-07, 4.8875808715820312e-05,
	6.4730644226074219e-05}, /* L758 */
{2.0922472476959229e+00, 9.4793736934661865e-05,
	1.1920928955078125e-07, 1.7046928405761719e-04,
	-3.9041042327880859e-04}, /* L759 */
{1.9188117980957031e+00, 8.6933374404907227e-05,
	1.1920928955078125e-07, 2.1219253540039062e-05,
	2.8252601623535156e-05}, /* L760 */
{2.2874414920806885e+00, 1.0380148887634277e-04,
	1.1920928955078125e-07, 6.4611434936523438e-05,
	-6.1929225921630859e-05}, /* L761 */
{1.8115466833114624e+00, 8.2284212112426758e-05,
	1.1920928955078125e-07, 1.8358230590820312e-05,
	-1.3649463653564453e-05}, /* L762 */
{2.9575283527374268e+00, 1.3455748558044434e-04,
	1.1920928955078125e-07, -3.0279159545898438e-05,
	7.7009201049804688e-05}, /* L763 */
{1.5774569511413574e+00, 7.1842223405838013e-05,
	1.1920928955078125e-07, -3.5881996154785156e-05,
	9.4532966613769531e-05}, /* L764 */
{2.9342877864837646e+00, 1.3425946235656738e-04,
	1.1920928955078125e-07, 1.4758110046386719e-04,
	-3.3640861511230469e-04}, /* L765 */
{2.0155229568481445e+00, 9.2029571533203125e-05,
	1.1920928955078125e-07, -8.2254409790039062e-06,
	5.6028366088867188e-06}, /* L766 */
{2.4166848659515381e+00, 1.1050701141357422e-04,
	1.1920928955078125e-07, 8.7857246398925781e-05,
	4.2080879211425781e-05}, /* L767 */
{1.6560200452804565e+00, 7.5820833444595337e-05,
	1.1920928955078125e-07, 1.5139579772949219e-05,
	-6.5386295318603516e-05}, /* L768 */
{2.6929414272308350e+00, 1.2344121932983398e-04,
	1.1920928955078125e-07, 1.8119812011718750e-05,
	-5.2392482757568359e-05}, /* L769 */
{2.0127694606781006e+00, 9.2387199401855469e-05,
	1.1920928955078125e-07, 1.1682510375976562e-05,
	7.8678131103515625e-06}, /* L770 */
{2.4180676937103271e+00, 1.1112913489341736e-04,
	1.1920928955078125e-07, 6.9141387939453125e-06,
	3.5762786865234375e-05}, /* L771 */
{1.6045144796371460e+00, 7.3835253715515137e-05,
	1.1920928955078125e-07, 6.1988830566406250e-06,
	-3.5762786865234375e-06}, /* L772 */
{2.2108206748962402e+00, 1.0189414024353027e-04,
	1.1920928955078125e-07, 4.7802925109863281e-05,
	1.5139579772949219e-05}, /* L773 */
{1.5052748918533325e+00, 6.9454312324523926e-05,
	1.1920928955078125e-07, 4.5537948608398438e-05,
	-1.9848346710205078e-05}, /* L774 */
{2.6995556354522705e+00, 1.2472271919250488e-04,
	1.1920928955078125e-07, 1.5258789062500000e-05,
	-1.9371509552001953e-05}, /* L775 */
{1.6755343675613403e+00, 7.7523291110992432e-05,
	1.1920928955078125e-07, 1.1408329010009766e-04,
	1.2254714965820312e-04}, /* L776 */
{2.0190923213958740e+00, 9.3534588813781738e-05,
	1.1920928955078125e-07, -2.6464462280273438e-05,
	2.6702880859375000e-05}, /* L777 */
{1.8375761508941650e+00, 8.5234642028808594e-05,
	1.1920928955078125e-07, -8.3565711975097656e-05,
	4.1604042053222656e-05}, /* L778 */
{1.9806352853775024e+00, 9.1969966888427734e-05,
	1.1920928955078125e-07, 1.5735626220703125e-05,
	2.5868415832519531e-05}, /* L779 */
{2.0876910686492920e+00, 9.7066164016723633e-05,
	1.1920928955078125e-07, 9.1791152954101562e-06,
	1.4781951904296875e-05}, /* L780 */
{2.0573351383209229e+00, 9.5803290605545044e-05,
	1.1920928955078125e-07, 1.2302398681640625e-04,
	1.9228458404541016e-04}, /* L781 */
{1.9701143503189087e+00, 9.1835856437683105e-05,
	1.1920928955078125e-07, 9.5367431640625000e-07,
	-1.0967254638671875e-05}, /* L782 */
{2.4811666011810303e+00, 1.1580251157283783e-04,
	1.1920928955078125e-07, -3.0994415283203125e-06,
	-7.9274177551269531e-06}, /* L783 */
{1.6350264549255371e+00, 7.6413154602050781e-05,
	1.1920928955078125e-07, -5.0067901611328125e-06,
	-8.3804130554199219e-05}, /* L784 */
{2.4119286537170410e+00, 1.1287629604339600e-04,
	1.1920928955078125e-07, 3.8743019104003906e-05,
	-1.0132789611816406e-05}, /* L785 */
{2.7476739883422852e+00, 1.2874603271484375e-04,
	1.1920928955078125e-07, -2.8908252716064453e-05,
	-2.4199485778808594e-05}, /* L786 */
{2.5886390209197998e+00, 1.2144446372985840e-04,
	1.1920928955078125e-07, -5.5432319641113281e-06,
	-1.5079975128173828e-05}, /* L787 */
{1.8609656095504761e+00, 8.7425112724304199e-05,
	1.1920928955078125e-07, -6.6161155700683594e-06,
	6.2346458435058594e-05}, /* L788 */
{2.9474508762359619e+00, 1.3881921768188477e-04,
	1.1920928955078125e-07, 1.5580654144287109e-04,
	-7.8320503234863281e-05}, /* L789 */
{2.0901196002960205e+00, 9.8437070846557617e-05,
	1.1920928955078125e-07, 3.0279159545898438e-05,
	1.6689300537109375e-06}, /* L790 */
{2.1623034477233887e+00, 1.0199099779129028e-04,
	1.1920928955078125e-07, -2.0450353622436523e-04,
	4.4941902160644531e-05}, /* L791 */
{2.0843939781188965e+00, 9.8451972007751465e-05,
	1.1920928955078125e-07, -4.2557716369628906e-05,
	-1.1819601058959961e-04}, /* L792 */
{2.6955015659332275e+00, 1.2741982936859131e-04,
	1.1920928955078125e-07, 1.8119812011718750e-05,
	7.1525573730468750e-06}, /* L793 */
{2.0605497360229492e+00, 9.7543001174926758e-05,
	1.1920928955078125e-07, 8.9526176452636719e-05,
	-1.3273954391479492e-04}, /* L794 */
{3.0367584228515625e+00, 1.4397501945495605e-04,
	1.1920928955078125e-07, -2.0968914031982422e-04,
	3.1256675720214844e-04}, /* L795 */
{1.6623297929763794e+00, 7.8886747360229492e-05,
	1.1920928955078125e-07, 3.8146972656250000e-06,
	-1.1384487152099609e-05}, /* L796 */
{2.7017025947570801e+00, 1.2835860252380371e-04,
	1.1920928955078125e-07, 1.4066696166992188e-05,
	1.5377998352050781e-05}, /* L797 */
{2.3365538120269775e+00, 1.1116266250610352e-04,
	1.1920928955078125e-07, 3.7193298339843750e-05,
	3.0994415283203125e-05}, /* L798 */
{3.0320093631744385e+00, 1.4477968215942383e-04,
	1.1920928955078125e-07, 1.7352104187011719e-03,
	1.1062622070312500e-04}, /* L799 */
{1.8190797567367554e+00, 8.6754560470581055e-05,
	1.1920928955078125e-07, -1.6629695892333984e-05,
	-9.3579292297363281e-05}, /* L800 */
{2.2781453132629395e+00, 1.0886788368225098e-04,
	1.1920928955078125e-07, -2.1445751190185547e-04,
	1.8942356109619141e-04}, /* L801 */
{2.4532883167266846e+00, 1.1730194091796875e-04,
	1.1920928955078125e-07, 7.6293945312500000e-06,
	-4.7683715820312500e-06}, /* L802 */
{2.3627038002014160e+00, 1.1312961578369141e-04,
	1.1920928955078125e-07, 9.4413757324218750e-05,
	6.1869621276855469e-05}, /* L803 */
{2.0669724941253662e+00, 9.9062919616699219e-05,
	1.1920928955078125e-07, -4.3392181396484375e-05,
	2.9206275939941406e-05}, /* L804 */
{3.2593657970428467e+00, 1.5642121434211731e-04,
	1.1920928955078125e-07, 9.4175338745117188e-06,
	-8.3446502685546875e-06}, /* L805 */
{2.0802903175354004e+00, 9.9956989288330078e-05,
	1.1920928955078125e-07, -2.8610229492187500e-06,
	-1.5437602996826172e-05}, /* L806 */
{2.4246323108673096e+00, 1.1664349585771561e-04,
	1.1920928955078125e-07, 6.4015388488769531e-05,
	-3.5762786865234375e-06}, /* L807 */
{1.6409955024719238e+00, 7.9035758972167969e-05,
	1.1920928955078125e-07, 3.5762786865234375e-07,
	2.4795532226562500e-05}, /* L808 */
{2.6194143295288086e+00, 1.2633204460144043e-04,
	1.1920928955078125e-07, -3.2782554626464844e-05,
	-5.5193901062011719e-05}, /* L809 */
{1.6979091167449951e+00, 8.1986188888549805e-05,
	1.1920928955078125e-07, -1.4305114746093750e-06,
	-2.8848648071289062e-05}, /* L810 */
{2.5250537395477295e+00, 1.2215971946716309e-04,
	1.1920928955078125e-07, 7.6651573181152344e-05,
	-3.8921833038330078e-05}, /* L811 */
{1.9332687854766846e+00, 9.3579292297363281e-05,
	1.1920928955078125e-07, 9.6559524536132812e-06,
	9.4175338745117188e-06}, /* L812 */
{2.3601243495941162e+00, 1.1438131332397461e-04,
	1.1920928955078125e-07, -5.3703784942626953e-05,
	5.5432319641113281e-05}, /* L813 */
{2.0159647464752197e+00, 9.7826123237609863e-05,
	1.1920928955078125e-07, -5.1438808441162109e-05,
	6.6518783569335938e-05}, /* L814 */
{3.8087463378906250e+00, 1.8504261970520020e-04,
	1.1920928955078125e-07, -3.3378601074218750e-06,
	-3.9875507354736328e-05}, /* L815 */
{1.5736019611358643e+00, 7.6562166213989258e-05,
	1.1920928955078125e-07, 1.8548965454101562e-04,
	-1.0663270950317383e-04}, /* L816 */
{2.4758057594299316e+00, 1.2058019638061523e-04,
	1.1920928955078125e-07, 8.2254409790039062e-06,
	-2.3424625396728516e-05}, /* L817 */
{1.7238401174545288e+00, 8.4057450294494629e-05,
	1.1920928955078125e-07, -1.3470649719238281e-05,
	2.5868415832519531e-05}, /* L818 */
{2.5203421115875244e+00, 1.2306869029998779e-04,
	1.1920928955078125e-07, -1.0204315185546875e-04,
	3.4213066101074219e-05}, /* L819 */
{1.8332705497741699e+00, 8.9623034000396729e-05,
	1.1920928955078125e-07, 1.5556812286376953e-04,
	3.3259391784667969e-05}, /* L820 */
{3.3448114395141602e+00, 1.6370415687561035e-04,
	1.1920928955078125e-07, 2.2530555725097656e-05,
	-8.7618827819824219e-06}, /* L821 */
{2.2392404079437256e+00, 1.0976195335388184e-04,
	1.1920928955078125e-07, 3.7789344787597656e-05,
	1.0073184967041016e-04}, /* L822 */
{2.7445497512817383e+00, 1.3464689254760742e-04,
	1.1920928955078125e-07, -3.5941600799560547e-05,
	-3.0875205993652344e-05}, /* L823 */
{1.7886660099029541e+00, 8.7857246398925781e-05,
	1.1920928955078125e-07, -3.9041042327880859e-05,
	2.5510787963867188e-05}, /* L824 */
{2.9540355205535889e+00, 1.4527887105941772e-04,
	1.1920928955078125e-07, -1.2874603271484375e-05,
	1.4901161193847656e-05}, /* L825 */
{2.2219920158386230e+00, 1.0940432548522949e-04,
	1.1920928955078125e-07, -4.2974948883056641e-05,
	8.7022781372070312e-06}, /* L826 */
{2.5561661720275879e+00, 1.2606382369995117e-04,
	1.1920928955078125e-07, 5.0783157348632812e-05,
	1.4710426330566406e-04}, /* L827 */
{2.1620378494262695e+00, 1.0672211647033691e-04,
	1.1920928955078125e-07, 5.6743621826171875e-05,
	1.4305114746093750e-05}, /* L828 */
{2.5518054962158203e+00, 1.2668967247009277e-04,
	1.1920928955078125e-07, -1.5921592712402344e-03,
	2.1111965179443359e-03}, /* L829 */
{1.5416529178619385e+00, 7.6293945312500000e-05,
	1.1920928955078125e-07, 1.7046928405761719e-05,
	-2.3841857910156250e-06}, /* L830 */
{2.4532825946807861e+00, 1.2227892875671387e-04,
	1.1920928955078125e-07, 2.9630661010742188e-03,
	2.0295381546020508e-03}, /* L831 */
{2.4252719879150391e+00, 1.2028217315673828e-04,
	1.1920928955078125e-07, -2.3841857910156250e-07,
	2.2411346435546875e-05}, /* L832 */
{1.9761401414871216e+00, 9.8138116300106049e-05,
	1.1920928955078125e-07, 8.6426734924316406e-05,
	-2.0086765289306641e-05}, /* L833 */
{1.6813796758651733e+00, 8.3588063716888428e-05,
	1.1920928955078125e-07, -1.6629695892333984e-05,
	-2.6643276214599609e-05}, /* L834 */
{2.5926082134246826e+00, 1.2907385826110840e-04,
	1.1920928955078125e-07, -1.6713142395019531e-04,
	1.0561943054199219e-04}, /* L835 */
{1.7444106340408325e+00, 8.6933374404907227e-05,
	1.1920928955078125e-07, -1.6152858734130859e-05,
	-1.3828277587890625e-05}, /* L836 */
{3.4351832866668701e+00, 1.7139315605163574e-04,
	1.1920928955078125e-07, -1.9967555999755859e-05,
	-1.3113021850585938e-06}, /* L837 */
{1.8989329338073730e+00, 9.4860792160034180e-05,
	1.1920928955078125e-07, -1.7702579498291016e-05,
	-1.1801719665527344e-05}, /* L838 */
{2.0314595699310303e+00, 1.0173022747039795e-04,
	1.1920928955078125e-07, 1.4519691467285156e-04,
	-2.8294324874877930e-04}, /* L839 */
{1.9752336740493774e+00, 9.8913908004760742e-05,
	1.1920928955078125e-07, -1.0532140731811523e-04,
	8.8334083557128906e-05}, /* L840 */
{2.8525748252868652e+00, 1.4302134513854980e-04,
	1.1920928955078125e-07, -3.2007694244384766e-05,
	1.2159347534179688e-05}, /* L841 */
{2.2028794288635254e+00, 1.1059641838073730e-04,
	1.1920928955078125e-07, 1.0573863983154297e-04,
	-3.6239624023437500e-05}, /* L842 */
{2.4849731922149658e+00, 1.2490153312683105e-04,
	1.1920928955078125e-07, -1.6605854034423828e-04,
	2.3484230041503906e-04}, /* L843 */
{1.9515322446823120e+00, 9.8183751106262207e-05,
	1.1920928955078125e-07, 2.5391578674316406e-05,
	-3.7550926208496094e-06}, /* L844 */
{2.1957097053527832e+00, 1.1059641838073730e-04,
	1.1920928955078125e-07, -1.3411045074462891e-05,
	-3.5524368286132812e-05}, /* L845 */
{1.7676129341125488e+00, 8.9138746261596680e-05,
	1.1920928955078125e-07, -3.1352043151855469e-05,
	-3.5762786865234375e-07}, /* L846 */
{2.7801711559295654e+00, 1.4037266373634338e-04,
	1.1920928955078125e-07, 4.1007995605468750e-05,
	-2.7418136596679688e-06}, /* L847 */
{1.9843856096267700e+00, 1.0034441947937012e-04,
	1.1920928955078125e-07, 1.7380714416503906e-04,
	1.2445449829101562e-04}, /* L848 */
{2.1663439273834229e+00, 1.0964274406433105e-04,
	1.1920928955078125e-07, -9.6321105957031250e-05,
	-7.6413154602050781e-05}, /* L849 */
{2.1957120895385742e+00, 1.1125020682811737e-04,
	1.1920928955078125e-07, 6.2346458435058594e-05,
	-9.5367431640625000e-07}, /* L850 */
{3.4541883468627930e+00, 1.7526745796203613e-04,
	1.1920928955078125e-07, -1.4895200729370117e-04,
	1.0967254638671875e-04}, /* L851 */
{1.7881503105163574e+00, 9.0815126895904541e-05,
	1.1920928955078125e-07, -3.4511089324951172e-05,
	-4.5716762542724609e-05}, /* L852 */
{2.3159422874450684e+00, 1.1781975626945496e-04,
	1.1920928955078125e-07, -2.9128789901733398e-04,
	1.3506412506103516e-04}, /* L853 */
{2.0708556175231934e+00, 1.0542571544647217e-04,
	1.1920928955078125e-07, 2.7060508728027344e-05,
	-2.4855136871337891e-05}, /* L854 */
{2.5726499557495117e+00, 1.3148784637451172e-04,
	1.1920928955078125e-07, -3.0738115310668945e-04,
	-1.6230344772338867e-03}, /* L855 */
{1.7246465682983398e+00, 8.8006258010864258e-05,
	1.1920928955078125e-07, -2.0682811737060547e-05,
	1.4901161193847656e-05}, /* L856 */
{2.6936030387878418e+00, 1.3761222362518311e-04,
	1.1920928955078125e-07, -3.8981437683105469e-05,
	-1.0430812835693359e-05}, /* L857 */
{2.1526682376861572e+00, 1.1011958122253418e-04,
	1.1920928955078125e-07, -5.9127807617187500e-05,
	-1.1038780212402344e-04}, /* L858 */
{2.1822087764739990e+00, 1.1174008250236511e-04,
	1.1920928955078125e-07, -4.7087669372558594e-05,
	7.4028968811035156e-05}, /* L859 */
{1.7160212993621826e+00, 8.8006258010864258e-05,
	1.1920928955078125e-07, 1.0442733764648438e-04,
	3.6954879760742188e-05}, /* L860 */
{2.9644734859466553e+00, 1.5217065811157227e-04,
	1.1920928955078125e-07, 2.8610229492187500e-05,
	-4.9471855163574219e-06}, /* L861 */
{2.2799644470214844e+00, 1.1716037988662720e-04,
	1.1920928955078125e-07, -5.9008598327636719e-05,
	-9.8347663879394531e-06}, /* L862 */
{3.0331907272338867e+00, 1.5604496002197266e-04,
	1.1920928955078125e-07, 1.9073486328125000e-05,
	1.0013580322265625e-05}, /* L863 */
{1.6403298377990723e+00, 8.4549188613891602e-05,
	1.1920928955078125e-07, -6.2465667724609375e-05,
	1.3589859008789062e-04}, /* L864 */
{2.6141827106475830e+00, 1.3482570648193359e-04,
	1.1920928955078125e-07, 4.7206878662109375e-05,
	-8.0704689025878906e-05}, /* L865 */
{2.0187323093414307e+00, 1.0421872138977051e-04,
	1.1920928955078125e-07, 1.6927719116210938e-05,
	-6.0439109802246094e-05}, /* L866 */
{2.5755372047424316e+00, 1.3311207294464111e-04,
	1.1920928955078125e-07, -3.1709671020507812e-05,
	-1.6629695892333984e-05}, /* L867 */
{1.8259007930755615e+00, 9.4473361968994141e-05,
	1.1920928955078125e-07, 5.0425529479980469e-05,
	-1.0251998901367188e-05}, /* L868 */
{2.9165534973144531e+00, 1.5108287334442139e-04,
	1.1920928955078125e-07, 3.6954879760742188e-06,
	6.9141387939453125e-06}, /* L869 */
{2.7422730922698975e+00, 1.4226883649826050e-04,
	1.1920928955078125e-07, -3.2067298889160156e-05,
	4.1365623474121094e-05}, /* L870 */
{3.0768077373504639e+00, 1.5977025032043457e-04,
	1.1920928955078125e-07, -8.5234642028808594e-06,
	-6.9320201873779297e-05}, /* L871 */
{2.2269895076751709e+00, 1.1579692363739014e-04,
	1.1920928955078125e-07, -1.2117624282836914e-04,
	2.8371810913085938e-05}, /* L872 */
{2.3807578086853027e+00, 1.2390315532684326e-04,
	1.1920928955078125e-07, 7.0691108703613281e-05,
	5.6028366088867188e-06}, /* L873 */
{2.3030762672424316e+00, 1.1999253183603287e-04,
	1.1920928955078125e-07, -4.7743320465087891e-05,
	1.0728836059570312e-05}, /* L874 */
{3.5347509384155273e+00, 1.8436275422573090e-04,
	1.1920928955078125e-07, 7.9870223999023438e-06,
	-1.3113021850585938e-06}, /* L875 */
{2.3561933040618896e+00, 1.2320280075073242e-04,
	1.1920928955078125e-07, -5.1897764205932617e-04,
	-1.2090206146240234e-03}, /* L876 */
{2.1131026744842529e+00, 1.1048390297219157e-04,
	1.1920928955078125e-07, 2.2172927856445312e-05,
	-9.6201896667480469e-05}, /* L877 */
{1.8844668865203857e+00, 9.8630785942077637e-05,
	1.1920928955078125e-07, 1.3589859008789062e-05,
	8.8214874267578125e-06}, /* L878 */
{2.3148846626281738e+00, 1.2132525444030762e-04,
	1.1920928955078125e-07, 1.1003017425537109e-04,
	-8.2015991210937500e-05}, /* L879 */
{1.5947893857955933e+00, 8.3848834037780762e-05,
	1.1920928955078125e-07, 9.9349021911621094e-04,
	3.4677982330322266e-04}, /* L880 */
{2.1570847034454346e+00, 1.1342763900756836e-04,
	1.1920928955078125e-07, 1.7213821411132812e-04,
	4.6372413635253906e-05}, /* L881 */
{1.6580779552459717e+00, 8.7261199951171875e-05,
	1.1920928955078125e-07, -1.3893842697143555e-04,
	-2.7960538864135742e-04}, /* L882 */
{3.6699147224426270e+00, 1.9323825836181641e-04,
	1.1920928955078125e-07, 9.8586082458496094e-05,
	2.2971630096435547e-04}, /* L883 */
{2.3332619667053223e+00, 1.2296438217163086e-04,
	1.1920928955078125e-07, 8.2254409790039062e-06,
	8.8214874267578125e-05}, /* L884 */
{3.4162259101867676e+00, 1.8027424812316895e-04,
	1.1920928955078125e-07, 1.2671947479248047e-04,
	4.0411949157714844e-05}, /* L885 */
{2.4479737281799316e+00, 1.2931227684020996e-04,
	1.1920928955078125e-07, -4.1127204895019531e-05,
	3.4093856811523438e-05}, /* L886 */
{2.4849040508270264e+00, 1.3139843940734863e-04,
	1.1920928955078125e-07, -4.8875808715820312e-05,
	2.8371810913085938e-05}, /* L887 */
{1.9196724891662598e+00, 1.0161101818084717e-04,
	1.1920928955078125e-07, 8.4638595581054688e-06,
	-1.6033649444580078e-05}, /* L888 */
{2.1283452510833740e+00, 1.1280179023742676e-04,
	1.1920928955078125e-07, -3.3497810363769531e-05,
	-1.0728836059570312e-05}, /* L889 */
{2.1093358993530273e+00, 1.1190772056579590e-04,
	1.1920928955078125e-07, 1.6689300537109375e-05,
	-2.3245811462402344e-06}, /* L890 */
{2.6136631965637207e+00, 1.3895332813262939e-04,
	1.1920928955078125e-07, -1.3351440429687500e-04,
	4.3225288391113281e-04}, /* L891 */
{1.9454886913299561e+00, 1.0344572365283966e-04,
	1.1920928955078125e-07, -1.7225742340087891e-05,
	1.3470649719238281e-05}, /* L892 */
{2.4386856555938721e+00, 1.2981891632080078e-04,
	1.1920928955078125e-07, -3.6597251892089844e-05,
	-2.5629997253417969e-06}, /* L893 */
{1.8367061614990234e+00, 9.7960233688354492e-05,
	1.1920928955078125e-07, -1.4472007751464844e-04,
	5.4943561553955078e-04}, /* L894 */
{3.2065422534942627e+00, 1.7115473747253418e-04,
	1.1920928955078125e-07, 3.7109851837158203e-04,
	-1.1157989501953125e-04}, /* L895 */
{2.1621901988983154e+00, 1.1548399925231934e-04,
	1.1920928955078125e-07, 2.6822090148925781e-05,
	1.2516975402832031e-05}, /* L896 */
{2.5777149200439453e+00, 1.3786554336547852e-04,
	1.1920928955078125e-07, 7.2002410888671875e-05,
	1.9145011901855469e-04}, /* L897 */
{1.7790298461914062e+00, 9.5248222351074219e-05,
	1.1920928955078125e-07, 2.3484230041503906e-05,
	-1.6278028488159180e-04}, /* L898 */
{2.7658085823059082e+00, 1.4826655387878418e-04,
	1.1920928955078125e-07, -7.3015689849853516e-05,
	-7.0929527282714844e-06}, /* L899 */
{1.9058766365051270e+00, 1.0225176811218262e-04,
	1.1920928955078125e-07, -6.5565109252929688e-06,
	-2.4735927581787109e-05}, /* L900 */
{2.7180824279785156e+00, 1.4628330245614052e-04,
	1.1920928955078125e-07, 7.4625015258789062e-04,
	5.4001808166503906e-04}, /* L901 */
{1.8777757883071899e+00, 1.0100007057189941e-04,
	1.1920928955078125e-07, 3.0517578125000000e-05,
	-9.2148780822753906e-05}, /* L902 */
{2.5312402248382568e+00, 1.3625621795654297e-04,
	1.1920928955078125e-07, -6.4373016357421875e-06,
	3.1471252441406250e-05}, /* L903 */
{2.4145874977111816e+00, 1.3023614883422852e-04,
	1.1920928955078125e-07, 4.1317939758300781e-04,
	2.0754337310791016e-04}, /* L904 */
{2.5403666496276855e+00, 1.3712048530578613e-04,
	1.1920928955078125e-07, -3.3980607986450195e-04,
	2.2649765014648438e-05}, /* L905 */
{2.3182437419891357e+00, 1.2519955635070801e-04,
	1.1920928955078125e-07, 1.4901161193847656e-05,
	-4.7206878662109375e-05}, /* L906 */
{2.7781753540039062e+00, 1.5020370483398438e-04,
	1.1920928955078125e-07, -3.5166740417480469e-06,
	-7.6293945312500000e-06}, /* L907 */
{2.3972797393798828e+00, 1.2980401515960693e-04,
	1.1920928955078125e-07, -6.5565109252929688e-06,
	1.2600421905517578e-04}, /* L908 */
{2.6933176517486572e+00, 1.4597550034523010e-04,
	1.1920928955078125e-07, -5.3763389587402344e-05,
	-1.1980533599853516e-05}, /* L909 */
{2.5247848033905029e+00, 1.3698637485504150e-04,
	1.1920928955078125e-07, 6.0677528381347656e-05,
	8.0704689025878906e-05}, /* L910 */
{2.9228701591491699e+00, 1.5911459922790527e-04,
	1.1920928955078125e-07, -8.2874298095703125e-04,
	-6.9284439086914062e-04}, /* L911 */
{1.9770034551620483e+00, 1.0761618614196777e-04,
	1.1920928955078125e-07, 6.1035156250000000e-04,
	1.9669532775878906e-05}, /* L912 */
{2.6018774509429932e+00, 1.4162063598632812e-04,
	1.1920928955078125e-07, -4.6074390411376953e-05,
	7.4982643127441406e-05}, /* L913 */
{1.8861083984375000e+00, 1.0276585817337036e-04,
	1.1920928955078125e-07, -1.0073184967041016e-05,
	-8.4638595581054688e-06}, /* L914 */
{3.0955219268798828e+00, 1.6891956329345703e-04,
	1.1920928955078125e-07, -1.4477968215942383e-04,
	1.2278556823730469e-05}, /* L915 */
{1.8754351139068604e+00, 1.0281801223754883e-04,
	1.1920928955078125e-07, 2.1791458129882812e-04,
	-1.0464787483215332e-03}, /* L916 */
{2.5912709236145020e+00, 1.4165043830871582e-04,
	1.1920928955078125e-07, -6.4373016357421875e-05,
	3.8981437683105469e-05}, /* L917 */
{1.7696588039398193e+00, 9.7244977951049805e-05,
	1.1920928955078125e-07, 8.7010860443115234e-04,
	2.3247003555297852e-03}, /* L918 */
{2.6782662868499756e+00, 1.4686584472656250e-04,
	1.1920928955078125e-07, -6.0856342315673828e-05,
	-3.0356645584106445e-04}, /* L919 */
{1.5951299667358398e+00, 8.7499618530273438e-05,
	1.1920928955078125e-07, 3.7550926208496094e-05,
	1.5819072723388672e-04}, /* L920 */
{3.9940190315246582e+00, 2.1934509277343750e-04,
	1.1920928955078125e-07, 4.7087669372558594e-05,
	-1.5890598297119141e-04}, /* L921 */
{2.2927627563476562e+00, 1.2604519724845886e-04,
	1.1920928955078125e-07, 1.6617774963378906e-04,
	3.1387805938720703e-04}, /* L922 */
{3.0911669731140137e+00, 1.7027184367179871e-04,
	1.1920928955078125e-07, -4.3702125549316406e-04,
	-6.8551301956176758e-04}, /* L923 */
{1.7874430418014526e+00, 9.8586082458496094e-05,
	1.1920928955078125e-07, 6.4289569854736328e-04,
	6.5529346466064453e-04}, /* L924 */
{2.1385571956634521e+00, 1.1792406439781189e-04,
	1.1920928955078125e-07, -2.4020671844482422e-05,
	3.9339065551757812e-06}, /* L925 */
{2.5630443096160889e+00, 1.4149397611618042e-04,
	1.1920928955078125e-07, 5.8770179748535156e-05,
	1.2612342834472656e-04}, /* L926 */
{2.2913172245025635e+00, 1.2665987014770508e-04,
	1.1920928955078125e-07, 9.0718269348144531e-05,
	-3.2186508178710938e-05}, /* L927 */
{2.3807313442230225e+00, 1.3181567192077637e-04,
	1.1920928955078125e-07, -2.6363134384155273e-04,
	1.2636184692382812e-04}, /* L928 */
{2.9552285671234131e+00, 1.6370415687561035e-04,
	1.1920928955078125e-07, 1.8596649169921875e-04,
	-1.0895729064941406e-04}, /* L929 */
{1.6572691202163696e+00, 9.1969966888427734e-05,
	1.1920928955078125e-07, 6.7710876464843750e-05,
	-1.9013881683349609e-05}, /* L930 */
{3.1323144435882568e+00, 1.7383694648742676e-04,
	1.1920928955078125e-07, 4.2915344238281250e-06,
	2.8610229492187500e-06}, /* L931 */
{1.6867069005966187e+00, 9.3773007392883301e-05,
	1.1920928955078125e-07, 2.8133392333984375e-05,
	1.1885166168212891e-04}, /* L932 */
{2.9133865833282471e+00, 1.6203522682189941e-04,
	1.1920928955078125e-07, 1.3828277587890625e-05,
	5.3644180297851562e-05}, /* L933 */
{2.3112335205078125e+00, 1.2868642807006836e-04,
	1.1920928955078125e-07, -3.6597251892089844e-05,
	-8.7141990661621094e-05}, /* L934 */
{2.5138881206512451e+00, 1.4011561870574951e-04,
	1.1920928955078125e-07, 9.2983245849609375e-06,
	3.1232833862304688e-05}, /* L935 */
{1.9361759424209595e+00, 1.0851025581359863e-04,
	1.1920928955078125e-07, 3.1638145446777344e-04,
	-1.0213255882263184e-03}, /* L936 */
{3.1475715637207031e+00, 1.7592310905456543e-04,
	1.1920928955078125e-07, 9.0003013610839844e-05,
	5.9604644775390625e-05}, /* L937 */
{2.6926772594451904e+00, 1.5056878328323364e-04,
	1.1920928955078125e-07, -6.8783760070800781e-05,
	7.9870223999023438e-06}, /* L938 */
{2.5313024520874023e+00, 1.4168024063110352e-04,
	1.1920928955078125e-07, 1.2397766113281250e-05,
	1.5974044799804688e-05}, /* L939 */
{1.9376578330993652e+00, 1.0867789387702942e-04,
	1.1920928955078125e-07, -2.1380186080932617e-04,
	-2.0164251327514648e-04}, /* L940 */
{2.4387421607971191e+00, 1.3679265975952148e-04,
	1.1920928955078125e-07, -5.8472156524658203e-05,
	7.3909759521484375e-06}, /* L941 */
{2.0019938945770264e+00, 1.1241436004638672e-04,
	1.1920928955078125e-07, -4.6849250793457031e-05,
	1.2516975402832031e-05}, /* L942 */
{2.6084067821502686e+00, 1.4693289995193481e-04,
	1.1920928955078125e-07, 2.1600723266601562e-04,
	4.0256977081298828e-04}, /* L943 */
{2.0215182304382324e+00, 1.1375546455383301e-04,
	1.1920928955078125e-07, 7.7486038208007812e-06,
	9.2983245849609375e-06}, /* L944 */
{2.6222875118255615e+00, 1.4773011207580566e-04,
	1.1920928955078125e-07, -4.4882297515869141e-05,
	-1.3113021850585938e-06}, /* L945 */
{2.0794596672058105e+00, 1.1727213859558105e-04,
	1.1920928955078125e-07, -1.4603137969970703e-05,
	-1.4007091522216797e-05}, /* L946 */
{3.2652111053466797e+00, 1.8432736396789551e-04,
	1.1920928955078125e-07, -3.3676624298095703e-05,
	-2.4557113647460938e-05}, /* L947 */
{1.5788738727569580e+00, 8.9228153228759766e-05,
	1.1920928955078125e-07, 6.6399574279785156e-05,
	5.1259994506835938e-05}, /* L948 */
{2.6564276218414307e+00, 1.5027821063995361e-04,
	1.1920928955078125e-07, -2.0682811737060547e-05,
	3.3855438232421875e-05}, /* L949 */
{1.9548366069793701e+00, 1.1070072650909424e-04,
	1.1920928955078125e-07, -2.3782253265380859e-05,
	3.0994415283203125e-06}, /* L950 */
{3.4939458370208740e+00, 1.9806623458862305e-04,
	1.1920928955078125e-07, 6.8068504333496094e-05,
	-1.0251998901367188e-05}, /* L951 */
{1.8456555604934692e+00, 1.0474771261215210e-04,
	1.1920928955078125e-07, 3.3378601074218750e-05,
	1.1086463928222656e-05}, /* L952 */
{2.4174377918243408e+00, 1.3734400272369385e-04,
	1.1920928955078125e-07, 4.9471855163574219e-05,
	5.4240226745605469e-05}, /* L953 */
{1.5730842351913452e+00, 8.9496374130249023e-05,
	1.1920928955078125e-07, -3.7789344787597656e-05,
	1.5401840209960938e-04}, /* L954 */
{3.2439517974853516e+00, 1.8468499183654785e-04,
	1.1920928955078125e-07, -4.6491622924804688e-06,
	1.6999244689941406e-04}, /* L955 */
{1.9464484453201294e+00, 1.1101365089416504e-04,
	1.1920928955078125e-07, -4.4035911560058594e-04,
	1.5354156494140625e-04}, /* L956 */
{3.0315759181976318e+00, 1.7297267913818359e-04,
	1.1920928955078125e-07, -1.0710954666137695e-04,
	-1.2099742889404297e-04}, /* L957 */
{2.3561677932739258e+00, 1.3455958105623722e-04,
	1.1920928955078125e-07, 1.7642974853515625e-05,
	4.4584274291992188e-05}, /* L958 */
{3.2325105667114258e+00, 1.8478929996490479e-04,
	1.1920928955078125e-07, 7.7486038208007812e-06,
	-2.5629997253417969e-06}, /* L959 */
{2.2093036174774170e+00, 1.2645125389099121e-04,
	1.1920928955078125e-07, -6.8545341491699219e-06,
	1.5437602996826172e-04}, /* L960 */
{2.5724461078643799e+00, 1.4737248420715332e-04,
	1.1920928955078125e-07, -4.4286251068115234e-05,
	-3.7610530853271484e-05}, /* L961 */
{2.0313313007354736e+00, 1.1648237705230713e-04,
	1.1920928955078125e-07, -1.3530254364013672e-05,
	-1.2755393981933594e-05}, /* L962 */
{2.5995750427246094e+00, 1.4925003051757812e-04,
	1.1920928955078125e-07, 3.7789344787597656e-05,
	9.7274780273437500e-05}, /* L963 */
{1.8704653978347778e+00, 1.0748207569122314e-04,
	1.1920928955078125e-07, 4.5776367187500000e-05,
	-1.1861324310302734e-05}, /* L964 */
{2.7288212776184082e+00, 1.5701353549957275e-04,
	1.1920928955078125e-07, -3.1352043151855469e-05,
	1.1920928955078125e-06}, /* L965 */
{2.2122416496276855e+00, 1.2764334678649902e-04,
	1.1920928955078125e-07, 2.7871131896972656e-04,
	3.5881996154785156e-05}, /* L966 */
{3.1099154949188232e+00, 1.7926096916198730e-04,
	1.1920928955078125e-07, -1.3947486877441406e-05,
	1.2755393981933594e-05}, /* L967 */
{2.4467654228210449e+00, 1.4130026102066040e-04,
	1.1920928955078125e-07, -2.6881694793701172e-05,
	4.6968460083007812e-05}, /* L968 */
{3.0829267501831055e+00, 1.7812848091125488e-04,
	1.1920928955078125e-07, -1.1247396469116211e-04,
	-9.1314315795898438e-05}, /* L969 */
{1.9841572046279907e+00, 1.1475384235382080e-04,
	1.1920928955078125e-07, -3.7729740142822266e-05,
	-7.2240829467773438e-05}, /* L970 */
{2.5353126525878906e+00, 1.4686584472656250e-04,
	1.1920928955078125e-07, 7.3432922363281250e-05,
	-3.5423040390014648e-04}, /* L971 */
{1.8345459699630737e+00, 1.0631233453750610e-04,
	1.1920928955078125e-07, 3.4093856811523438e-05,
	-5.1379203796386719e-05}, /* L972 */
{2.7593464851379395e+00, 1.6006827354431152e-04,
	1.1920928955078125e-07, 1.2874603271484375e-05,
	-1.9609928131103516e-05}, /* L973 */
{1.9935692548751831e+00, 1.1575222015380859e-04,
	1.1920928955078125e-07, -3.3259391784667969e-05,
	-1.6093254089355469e-05}, /* L974 */
{2.9771120548248291e+00, 1.7304718494415283e-04,
	1.1920928955078125e-07, 7.8916549682617188e-05,
	5.3644180297851562e-06}, /* L975 */
{1.8943487405776978e+00, 1.1020898818969727e-04,
	1.1920928955078125e-07, 1.7881393432617188e-05,
	9.8943710327148438e-06}, /* L976 */
{2.7762711048126221e+00, 1.6170740127563477e-04,
	1.1920928955078125e-07, 4.4822692871093750e-05,
	-4.4107437133789062e-05}, /* L977 */
{2.4248688220977783e+00, 1.4136731624603271e-04,
	1.1920928955078125e-07, 1.2516975402832031e-05,
	-1.0550022125244141e-05}, /* L978 */
{3.3294036388397217e+00, 1.9431114196777344e-04,
	1.1920928955078125e-07, 9.8943710327148438e-06,
	8.5592269897460938e-05}, /* L979 */
{1.7285628318786621e+00, 1.0100007057189941e-04,
	1.1920928955078125e-07, -9.2029571533203125e-05,
	1.1610984802246094e-04}, /* L980 */
{3.7977769374847412e+00, 2.2211670875549316e-04,
	1.1920928955078125e-07, 8.6307525634765625e-05,
	-6.2823295593261719e-05}, /* L981 */
{1.7289311885833740e+00, 1.0120868682861328e-04,
	1.1920928955078125e-07, -5.1259994506835938e-06,
	2.9206275939941406e-05}, /* L982 */
{2.7724754810333252e+00, 1.6245245933532715e-04,
	1.1920928955078125e-07, -1.6570091247558594e-05,
	2.6106834411621094e-05}, /* L983 */
{1.6386578083038330e+00, 9.6127390861511230e-05,
	1.1920928955078125e-07, -1.9550323486328125e-05,
	6.7472457885742188e-05}, /* L984 */
{3.0459799766540527e+00, 1.7888844013214111e-04,
	1.1920928955078125e-07, -1.8090009689331055e-04,
	7.7486038208007812e-06}, /* L985 */
{1.9777216911315918e+00, 1.1625885963439941e-04,
	1.1920928955078125e-07, 1.1491775512695312e-04,
	3.0040740966796875e-05}, /* L986 */
{2.6481158733367920e+00, 1.5583634376525879e-04,
	1.1920928955078125e-07, -1.6689300537109375e-06,
	-1.3631582260131836e-04}, /* L987 */
{2.8040018081665039e+00, 1.6513466835021973e-04,
	1.1920928955078125e-07, 3.8385391235351562e-05,
	3.3855438232421875e-05}, /* L988 */
{3.0401632785797119e+00, 1.7924606800079346e-04,
	1.1920928955078125e-07, -9.1135501861572266e-05,
	1.1801719665527344e-04}, /* L989 */
{2.3593602180480957e+00, 1.3924203813076019e-04,
	1.1920928955078125e-07, -1.7881393432617188e-06,
	-1.0722875595092773e-04}, /* L990 */
{2.7796792984008789e+00, 1.6427040100097656e-04,
	1.1920928955078125e-07, -9.3460083007812500e-05,
	-4.1961669921875000e-05}, /* L991 */
{2.2286057472229004e+00, 1.3178586959838867e-04,
	1.1920928955078125e-07, -3.1173229217529297e-05,
	-1.5139579772949219e-05}, /* L992 */
{2.4796242713928223e+00, 1.4684163033962250e-04,
	1.1920928955078125e-07, -3.2067298889160156e-04,
	1.9073486328125000e-05}, /* L993 */
{2.3759257793426514e+00, 1.4081597328186035e-04,
	1.1920928955078125e-07, 8.8214874267578125e-05,
	-1.1223554611206055e-04}, /* L994 */
{3.2865273952484131e+00, 1.9497796893119812e-04,
	1.1920928955078125e-07, -8.9526176452636719e-05,
	-1.5199184417724609e-04}, /* L995 */
{2.0007770061492920e+00, 1.1879205703735352e-04,
	1.1920928955078125e-07, -2.5331974029541016e-05,
	2.1576881408691406e-05}, /* L996 */
{2.7103550434112549e+00, 1.6108155250549316e-04,
	1.1920928955078125e-07, -3.9339065551757812e-06,
	-7.1525573730468750e-07}, /* L997 */
{2.8120162487030029e+00, 1.6736239194869995e-04,
	1.1920928955078125e-07, 2.8967857360839844e-05,
	1.2373924255371094e-04}, /* L998 */
{2.9577646255493164e+00, 1.7623230814933777e-04,
	1.1920928955078125e-07, 2.0265579223632812e-06,
	5.9604644775390625e-07}, /* L999 */
{1.9483228921890259e+00, 1.1613965034484863e-04,
	1.1920928955078125e-07, 2.4437904357910156e-05,
	-3.2722949981689453e-05}, /* L1000 */
{3.8359737396240234e+00, 4.5746564865112305e-04,
	1.1920928955078125e-07, -1.3399124145507812e-04,
	8.0108642578125000e-05}, /* L1001 */
{5.8567981719970703e+00, 1.0477304458618164e-03,
	1.1920928955078125e-07, -3.1220912933349609e-04,
	-1.6033649444580078e-05}, /* L1002 */
{5.4170632362365723e+00, 1.3025403022766113e-03,
	1.1920928955078125e-07, -2.4390220642089844e-04,
	-6.3204765319824219e-04}, /* L1003 */
{9.3633270263671875e+00, 2.7925223112106323e-03,
	1.1920928955078125e-07, -7.6413154602050781e-05,
	-7.6889991760253906e-06}, /* L1004 */
{9.4667501449584961e+00, 3.3883601427078247e-03,
	1.1920928955078125e-07, -2.5510787963867188e-05,
	-6.3002109527587891e-05}, /* L1005 */
{1.2134570121765137e+01, 5.1215887069702148e-03,
	1.1920928955078125e-07, 1.6582012176513672e-04,
	1.0722875595092773e-03}, /* L1006 */
{1.0536856651306152e+01, 5.0501525402069092e-03,
	1.1920928955078125e-07, -1.5735626220703125e-04,
	5.2344799041748047e-04}, /* L1007 */
{1.2359709739685059e+01, 7.2830915451049805e-03,
	1.1920928955078125e-07, -1.6933679580688477e-03,
	1.7970919609069824e-02}, /* L1008 */
{1.4585222244262695e+01, 8.7253600358963013e-03,
	1.1920928955078125e-07, -1.4744997024536133e-03,
	4.3809413909912109e-04}, /* L1009 */
#endif  /* } */

/* Always the last one. Common to both DP and SP */

{0.0000000000000000e+00, 0.0000000000000000e+00,
	0.0000000000000000e+00, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L1010 */
};

#ifdef __cplusplus
}
#endif

#endif /* _SINGDOUB64_SS12_H */
