/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2009 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef	LAPACK_V9B_SS13
#define	LAPACK_V9B_SS13

/* 64-bit golden values for V9B/SS13 Lapack */


static struct LinpVals LinpValsA[] = {

#ifdef DP  /* { */

/* Start of DP golden values */


{0.0000000000000000e+00, 0.0000000000000000e+00,
	0.0000000000000000e+00, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L0 */
{0.0000000000000000e+00, 0.0000000000000000e+00,
	2.2204460492503131e-16, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L1 */
{0.0000000000000000e+00, 0.0000000000000000e+00,
	2.2204460492503131e-16, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L2 */
{0.0000000000000000e+00, 0.0000000000000000e+00,
	2.2204460492503131e-16, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L3 */
{3.8260177822204688e-01, 1.6653345369377348e-16,
	2.2204460492503131e-16, 2.2204460492503131e-16,
	2.2204460492503131e-16}, /* L4 */
{4.0810856343684981e-01, 2.2204460492503131e-16,
	2.2204460492503131e-16, -3.3306690738754696e-16,
	0.0000000000000000e+00}, /* L5 */
{3.4009046953070693e-01, 2.2204460492503131e-16,
	2.2204460492503131e-16, 8.8817841970012523e-16,
	2.6645352591003757e-15}, /* L6 */
{3.6373773558278227e-01, 2.7755575615628914e-16,
	2.2204460492503131e-16, -3.3306690738754696e-16,
	8.8817841970012523e-16}, /* L7 */
{3.2492063115128750e-01, 2.8449465006019636e-16,
	2.2204460492503131e-16, -1.7763568394002505e-15,
	-1.1102230246251565e-16}, /* L8 */
{4.5083838251885799e-01, 4.4408920985006262e-16,
	2.2204460492503131e-16, -1.5543122344752192e-15,
	-4.5519144009631418e-15}, /* L9 */
{4.0575454426697483e-01, 4.4408920985006262e-16,
	2.2204460492503131e-16, -1.1102230246251565e-16,
	-2.2204460492503131e-16}, /* L10 */
{5.9941012221257661e-01, 7.2164496600635175e-16,
	2.2204460492503131e-16, 2.2204460492503131e-16,
	2.2204460492503131e-16}, /* L11 */
{2.9586268852800246e-01, 3.8857805861880479e-16,
	2.2204460492503131e-16, -5.5511151231257827e-16,
	0.0000000000000000e+00}, /* L12 */
{6.2922387221750764e-01, 9.0205620750793969e-16,
	2.2204460492503131e-16, -1.6653345369377348e-15,
	-2.2204460492503131e-16}, /* L13 */
{5.3933474761500677e-01, 8.3266726846886741e-16,
	2.2204460492503131e-16, -4.4408920985006262e-16,
	0.0000000000000000e+00}, /* L14 */
{6.7117213036534140e-01, 1.1102230246251565e-15,
	2.2204460492503131e-16, -6.6613381477509392e-16,
	-1.1102230246251565e-16}, /* L15 */
{7.8652984027188344e-01, 1.3877787807814457e-15,
	2.2204460492503131e-16, -6.6613381477509392e-16,
	0.0000000000000000e+00}, /* L16 */
{6.3662650600829918e-01, 1.1934897514720433e-15,
	2.2204460492503131e-16, -1.1102230246251565e-15,
	-1.3322676295501878e-15}, /* L17 */
{2.9363780703483666e-01, 5.8286708792820718e-16,
	2.2204460492503131e-16, 4.4408920985006262e-16,
	4.4408920985006262e-16}, /* L18 */
{8.0143251092966705e-01, 1.6792123247455493e-15,
	2.2204460492503131e-16, -5.5511151231257827e-16,
	8.8817841970012523e-16}, /* L19 */
{5.9147043988445613e-01, 1.3045120539345589e-15,
	2.2204460492503131e-16, -6.6613381477509392e-16,
	-2.2204460492503131e-16}, /* L20 */
{5.9684867319455459e-01, 1.3877787807814457e-15,
	2.2204460492503131e-16, 2.2204460492503131e-15,
	-1.4432899320127035e-15}, /* L21 */
{4.7856411796145321e-01, 1.1657341758564144e-15,
	2.2204460492503131e-16, -5.5511151231257827e-16,
	-2.3314683517128287e-15}, /* L22 */
{4.5775698239791013e-01, 1.1657341758564144e-15,
	2.2204460492503131e-16, 2.4424906541753444e-15,
	-2.9976021664879227e-15}, /* L23 */
{6.7891536575880340e-01, 1.8041124150158794e-15,
	2.2204460492503131e-16, -1.1546319456101628e-14,
	-2.2204460492503131e-15}, /* L24 */
{5.8156934716077235e-01, 1.6098233857064770e-15,
	2.2204460492503131e-16, 1.5543122344752192e-15,
	3.3306690738754696e-15}, /* L25 */
{6.1704970521036173e-01, 1.7763568394002505e-15,
	2.2204460492503131e-16, -2.9976021664879227e-15,
	-4.2188474935755949e-15}, /* L26 */
{8.9129401863720303e-01, 2.6645352591003757e-15,
	2.2204460492503131e-16, -4.4408920985006262e-16,
	2.4424906541753444e-15}, /* L27 */
{8.9527300979183411e-01, 2.7755575615628914e-15,
	2.2204460492503131e-16, 1.5543122344752192e-15,
	-1.3322676295501878e-15}, /* L28 */
{8.1253743509383025e-01, 2.6090241078691179e-15,
	2.2204460492503131e-16, 0.0000000000000000e+00,
	6.6613381477509392e-16}, /* L29 */
{8.6065578674654963e-01, 2.8588242884097781e-15,
	2.2204460492503131e-16, 8.8817841970012523e-16,
	8.8817841970012523e-16}, /* L30 */
{9.0566972861522066e-01, 3.1086244689504383e-15,
	2.2204460492503131e-16, 1.7763568394002505e-15,
	-1.6653345369377348e-15}, /* L31 */
{7.3636205055376436e-01, 2.6090241078691179e-15,
	2.2204460492503131e-16, -9.9920072216264089e-16,
	2.1760371282653068e-14}, /* L32 */
{8.4318439831303504e-01, 3.0808688933348094e-15,
	2.2204460492503131e-16, 6.6613381477509392e-16,
	1.1102230246251565e-15}, /* L33 */
{9.7321442476194397e-01, 3.6637359812630166e-15,
	2.2204460492503131e-16, -2.6645352591003757e-15,
	2.2204460492503131e-16}, /* L34 */
{1.4583044708110673e+00, 5.6621374255882984e-15,
	2.2204460492503131e-16, -3.9968028886505635e-15,
	-4.4408920985006262e-16}, /* L35 */
{7.3322293824479434e-01, 2.9282132274488504e-15,
	2.2204460492503131e-16, -1.7652546091539989e-14,
	1.4654943925052066e-14}, /* L36 */
{8.4526789345500786e-01, 3.4694469519536142e-15,
	2.2204460492503131e-16, -1.9984014443252818e-15,
	-7.7715611723760958e-16}, /* L37 */
{3.8846732871836481e-01, 1.6375789613221059e-15,
	2.2204460492503131e-16, 1.0658141036401503e-14,
	1.9984014443252818e-15}, /* L38 */
{9.3664352009106877e-01, 4.0523140398818214e-15,
	2.2204460492503131e-16, 2.8865798640254070e-15,
	1.7763568394002505e-15}, /* L39 */
{5.5043845221636245e-01, 2.4424906541753444e-15,
	2.2204460492503131e-16, -9.0261131902025227e-13,
	2.2069013283498862e-12}, /* L40 */
{8.0551968617249903e-01, 3.6637359812630166e-15,
	2.2204460492503131e-16, -2.6312285683616210e-14,
	-2.6645352591003757e-14}, /* L41 */
{1.0454756316476288e+00, 4.8711035205428743e-15,
	2.2204460492503131e-16, 4.6629367034256575e-15,
	-5.2180482157382357e-15}, /* L42 */
{9.7752283269141105e-01, 4.6629367034256575e-15,
	2.2204460492503131e-16, -5.5511151231257827e-16,
	-2.6645352591003757e-15}, /* L43 */
{8.6148166850218699e-01, 4.2049697057677804e-15,
	2.2204460492503131e-16, -3.4416913763379853e-15,
	1.1102230246251565e-15}, /* L44 */
{1.0563970295090952e+00, 5.2735593669694936e-15,
	2.2204460492503131e-16, -2.8865798640254070e-15,
	-1.2101430968414206e-14}, /* L45 */
{1.0211938676275674e+00, 5.2111093218343285e-15,
	2.2204460492503131e-16, -8.7707618945387367e-15,
	-4.1078251911130792e-15}, /* L46 */
{9.6885685013140577e-01, 5.0515147620444623e-15,
	2.2204460492503131e-16, -3.8191672047105385e-14,
	4.4408920985006262e-15}, /* L47 */
{1.1825826121868439e+00, 6.2970462177958098e-15,
	2.2204460492503131e-16, 2.6645352591003757e-15,
	6.6613381477509392e-15}, /* L48 */
{1.5740038790865019e+00, 8.5625950774215198e-15,
	2.2204460492503131e-16, -1.8984813721090177e-14,
	-8.1046280797636427e-15}, /* L49 */
{9.0001388742580246e-01, 4.9960036108132044e-15,
	2.2204460492503131e-16, 8.8817841970012523e-16,
	-3.2196467714129540e-15}, /* L50 */
{8.5295433775635876e-01, 4.8294701571194310e-15,
	2.2204460492503131e-16, -1.2212453270876722e-15,
	3.7969627442180354e-14}, /* L51 */
{1.3605979174225624e+00, 7.8548278992229825e-15,
	2.2204460492503131e-16, 3.5527136788005009e-15,
	3.7747582837255322e-15}, /* L52 */
{8.8680613645728601e-01, 5.2180482157382357e-15,
	2.2204460492503131e-16, -2.4424906541753444e-15,
	-3.8857805861880479e-15}, /* L53 */
{9.6529267247058115e-01, 5.7870375158586285e-15,
	2.2204460492503131e-16, 1.7763568394002505e-15,
	-2.3314683517128287e-15}, /* L54 */
{8.9092283805786343e-01, 5.4400928206632670e-15,
	2.2204460492503131e-16, 2.8865798640254070e-15,
	4.4408920985006262e-15}, /* L55 */
{9.1965704766721101e-01, 5.7176485768195562e-15,
	2.2204460492503131e-16, 1.6209256159527285e-14,
	-1.8873791418627661e-15}, /* L56 */
{1.0000154304731188e+00, 6.3282712403633923e-15,
	2.2204460492503131e-16, -2.3314683517128287e-15,
	7.9936057773011271e-15}, /* L57 */
{1.2586401107668486e+00, 8.1046280797636427e-15,
	2.2204460492503131e-16, 3.8968828164342995e-13,
	2.3470114740575809e-13}, /* L58 */
{8.8242887032215045e-01, 5.7800986219547212e-15,
	2.2204460492503131e-16, -4.5519144009631418e-15,
	-2.3314683517128287e-15}, /* L59 */
{9.7501504471128808e-01, 6.4948046940571658e-15,
	2.2204460492503131e-16, -1.5543122344752192e-15,
	8.8817841970012523e-16}, /* L60 */
{1.3688735810572958e+00, 9.2703622556200571e-15,
	2.2204460492503131e-16, -7.4606987254810520e-14,
	-1.2134737659152961e-13}, /* L61 */
{1.0902385968313253e+00, 7.5044137570756675e-15,
	2.2204460492503131e-16, 4.4408920985006262e-16,
	3.7747582837255322e-15}, /* L62 */
{7.2620168165310051e-01, 5.0792703376600912e-15,
	2.2204460492503131e-16, -4.8849813083506888e-15,
	4.4408920985006262e-16}, /* L63 */
{1.0722821705659045e+00, 7.6189055064901368e-15,
	2.2204460492503131e-16, -1.5543122344752192e-15,
	2.2204460492503131e-16}, /* L64 */
{1.1692488110146999e+00, 8.4376949871511897e-15,
	2.2204460492503131e-16, -8.8817841970012523e-16,
	-2.7755575615628914e-15}, /* L65 */
{1.0378948028395030e+00, 7.6050277186823223e-15,
	2.2204460492503131e-16, -2.0206059048177849e-14,
	7.3274719625260332e-15}, /* L66 */
{1.3750212169004810e+00, 1.0227929614359255e-14,
	2.2204460492503131e-16, -9.7699626167013776e-15,
	6.6613381477509392e-15}, /* L67 */
{7.9780642798774548e-01, 6.0229599085914742e-15,
	2.2204460492503131e-16, -9.7699626167013776e-15,
	-3.8857805861880479e-15}, /* L68 */
{1.2445844216208166e+00, 9.5340402239685318e-15,
	2.2204460492503131e-16, 1.8141044222375058e-13,
	3.5194069880617462e-13}, /* L69 */
{1.0643021367178127e+00, 8.2711615334574162e-15,
	2.2204460492503131e-16, -3.2196467714129540e-15,
	-1.5543122344752192e-15}, /* L70 */
{1.1760744851338045e+00, 9.2703622556200571e-15,
	2.2204460492503131e-16, -3.2751579226442118e-14,
	-2.0539125955565396e-14}, /* L71 */
{1.3402984588979951e+00, 1.0713652187632761e-14,
	2.2204460492503131e-16, -1.9984014443252818e-15,
	-1.9984014443252818e-15}, /* L72 */
{1.0993320314446988e+00, 8.9095397726168812e-15,
	2.2204460492503131e-16, -2.3869795029440866e-14,
	7.3274719625260332e-15}, /* L73 */
{1.4020486609673712e+00, 1.1518563880485999e-14,
	2.2204460492503131e-16, 5.1070259132757201e-15,
	-5.8841820305133297e-15}, /* L74 */
{1.7035809741547945e+00, 1.4184942283279600e-14,
	2.2204460492503131e-16, -9.9920072216264089e-16,
	-5.2180482157382357e-15}, /* L75 */
{1.1513335548210102e+00, 9.7144514654701197e-15,
	2.2204460492503131e-16, -4.5519144009631418e-15,
	-3.2196467714129540e-15}, /* L76 */
{1.1802130161590194e+00, 1.0089151736281110e-14,
	2.2204460492503131e-16, 6.8833827526759706e-15,
	-1.7763568394002505e-15}, /* L77 */
{1.0448879177378469e+00, 9.0483176506950258e-15,
	2.2204460492503131e-16, 8.8817841970012523e-16,
	5.4178883601707639e-14}, /* L78 */
{1.7785084554616846e+00, 1.5598633495983449e-14,
	2.2204460492503131e-16, 1.7763568394002505e-15,
	8.8817841970012523e-16}, /* L79 */
{1.5640866342229285e+00, 1.3891665595622271e-14,
	2.2204460492503131e-16, 4.4830805734363821e-13,
	1.3677947663381929e-13}, /* L80 */
{1.2407598859573825e+00, 1.1157741397482823e-14,
	2.2204460492503131e-16, -4.5519144009631418e-15,
	1.1102230246251565e-15}, /* L81 */
{2.3414995445223701e+00, 2.1316282072803006e-14,
	2.2204460492503131e-16, -5.1070259132757201e-15,
	-3.0087043967341742e-14}, /* L82 */
{1.4909868616993309e+00, 1.3739009929736312e-14,
	2.2204460492503131e-16, 2.5091040356528538e-14,
	-6.5503158452884236e-15}, /* L83 */
{1.1250173592822328e+00, 1.0491607582707729e-14,
	2.2204460492503131e-16, -4.1744385725905886e-14,
	-3.4416913763379853e-15}, /* L84 */
{1.9217208290746031e+00, 1.8134799217861541e-14,
	2.2204460492503131e-16, -3.2196467714129540e-15,
	-2.4424906541753444e-15}, /* L85 */
{1.6860725281232691e+00, 1.6098233857064770e-14,
	2.2204460492503131e-16, 8.2156503822261584e-15,
	-6.6613381477509392e-16}, /* L86 */
{1.0862236572379966e+00, 1.0491607582707729e-14,
	2.2204460492503131e-16, -2.9087843245179101e-14,
	-1.2212453270876722e-14}, /* L87 */
{1.6988898506332140e+00, 1.6597834218146090e-14,
	2.2204460492503131e-16, 6.2172489379008766e-15,
	-1.0436096431476471e-14}, /* L88 */
{1.4101341182513836e+00, 1.3933298959045715e-14,
	2.2204460492503131e-16, 1.1324274851176597e-14,
	-2.8865798640254070e-15}, /* L89 */
{9.4445901766904683e-01, 9.4368957093138306e-15,
	2.2204460492503131e-16, -1.4432899320127035e-15,
	4.2188474935755949e-15}, /* L90 */
{8.8462903464924114e-01, 8.9372953482325102e-15,
	2.2204460492503131e-16, 2.7311486405778851e-14,
	4.3076653355456074e-14}, /* L91 */
{1.4293698816001337e+00, 1.4599432773820809e-14,
	2.2204460492503131e-16, -9.7699626167013776e-15,
	6.8833827526759706e-15}, /* L92 */
{1.4381942346857988e+00, 1.4849232954361469e-14,
	2.2204460492503131e-16, -1.0547118733938987e-14,
	2.8865798640254070e-15}, /* L93 */
{1.4095962184859603e+00, 1.4710455076283324e-14,
	2.2204460492503131e-16, -1.4765966227514582e-14,
	-7.9936057773011271e-15}, /* L94 */
{2.8039906346555035e+00, 2.9573565818452607e-14,
	2.2204460492503131e-16, -1.6431300764452317e-14,
	5.5511151231257827e-15}, /* L95 */
{1.6041914197172078e+00, 1.7097434579227411e-14,
	2.2204460492503131e-16, -1.5987211554602254e-14,
	-2.6645352591003757e-15}, /* L96 */
{1.8170383466070419e+00, 1.9567680809018384e-14,
	2.2204460492503131e-16, -1.5321077739827160e-14,
	5.3290705182007514e-15}, /* L97 */
{1.3439301759339604e+00, 1.4621984179008507e-14,
	2.2204460492503131e-16, 7.3274719625260332e-15,
	-1.3322676295501878e-15}, /* L98 */
{1.9242721162132923e+00, 2.1149748619109232e-14,
	2.2204460492503131e-16, 6.2172489379008766e-15,
	8.8817841970012523e-16}, /* L99 */
{2.9625457127765391e+00, 3.2890357104520263e-14,
	2.2204460492503131e-16, -3.5527136788005009e-15,
	5.5511151231257827e-15}, /* L100 */
{1.2852921095869991e+00, 1.4412082638415313e-14,
	2.2204460492503131e-16, -2.4535928844215960e-14,
	-1.0103029524088925e-14}, /* L101 */
{1.3970803808080099e+00, 1.5820678100908481e-14,
	2.2204460492503131e-16, -7.7715611723760958e-15,
	6.2172489379008766e-15}, /* L102 */
{1.6844920115250395e+00, 1.9262369477246466e-14,
	2.2204460492503131e-16, -2.6756374893466273e-14,
	-6.8833827526759706e-15}, /* L103 */
{1.3750212169004725e+00, 1.5876189252139739e-14,
	2.2204460492503131e-16, -1.0547118733938987e-14,
	1.5765166949677223e-14}, /* L104 */
{1.3047820378553872e+00, 1.5210055437364645e-14,
	2.2204460492503131e-16, -7.5495165674510645e-15,
	9.5479180117763462e-15}, /* L105 */
{1.1226588323233835e+00, 1.3211653993039363e-14,
	2.2204460492503131e-16, 2.3758772726978350e-14,
	-5.9063864910058328e-14}, /* L106 */
{1.4112367289854100e+00, 1.6764367671839864e-14,
	2.2204460492503131e-16, 1.7319479184152442e-14,
	1.2656542480726785e-14}, /* L107 */
{2.4329079107111644e+00, 2.9171109972025988e-14,
	2.2204460492503131e-16, 1.3322676295501878e-15,
	-5.9952043329758453e-15}, /* L108 */
{1.3486446631150799e+00, 1.6320278461989801e-14,
	2.2204460492503131e-16, 3.3084646133829665e-14,
	3.1974423109204508e-14}, /* L109 */
{1.6272978368607867e+00, 1.9872992140790302e-14,
	2.2204460492503131e-16, -8.9928064994637680e-15,
	2.2204460492503131e-16}, /* L110 */
{1.9583635513431428e+00, 2.4133472997789340e-14,
	2.2204460492503131e-16, -3.5527136788005009e-15,
	-2.7755575615628914e-15}, /* L111 */
{1.4910944365089831e+00, 1.8540724511240114e-14,
	2.2204460492503131e-16, 1.5543122344752192e-14,
	-3.1863400806741993e-14}, /* L112 */
{1.6593176390593474e+00, 2.0816681711721685e-14,
	2.2204460492503131e-16, 7.3274719625260332e-15,
	1.0436096431476471e-14}, /* L113 */
{1.4802859990555859e+00, 1.8735013540549517e-14,
	2.2204460492503131e-16, 8.8817841970012523e-16,
	-1.5543122344752192e-15}, /* L114 */
{2.1060107571102940e+00, 2.6888213877640510e-14,
	2.2204460492503131e-16, 3.3528735343679728e-14,
	-1.0325074129013956e-14}, /* L115 */
{1.2823473731281858e+00, 1.6514567491299204e-14,
	2.2204460492503131e-16, -9.4368957093138306e-15,
	-2.2537527399890678e-14}, /* L116 */
{1.6709659543366842e+00, 2.1704860131421810e-14,
	2.2204460492503131e-16, -1.0558220964185239e-13,
	-1.3256062914024369e-13}, /* L117 */
{2.0731252091441892e+00, 2.7158830739892892e-14,
	2.2204460492503131e-16, 2.6645352591003757e-15,
	-2.0341506257182118e-12}, /* L118 */
{1.1575808869552118e+00, 1.5293322164211531e-14,
	2.2204460492503131e-16, -4.4408920985006262e-16,
	-8.4376949871511897e-15}, /* L119 */
{2.4625379975399899e+00, 3.2807090377673376e-14,
	2.2204460492503131e-16, -3.2196467714129540e-14,
	-8.4376949871511897e-15}, /* L120 */
{1.7438285605758650e+00, 2.3425705819590803e-14,
	2.2204460492503131e-16, 1.2456702336294256e-13,
	-5.9396931817445875e-14}, /* L121 */
{2.5451212390319462e+00, 3.4472424914611111e-14,
	2.2204460492503131e-16, -1.6653345369377348e-15,
	4.4408920985006262e-15}, /* L122 */
{1.1016430148704714e+00, 1.5043521983670871e-14,
	2.2204460492503131e-16, -2.9198865547641617e-14,
	-2.6867397195928788e-14}, /* L123 */
{1.4506272222286285e+00, 1.9970136655445003e-14,
	2.2204460492503131e-16, 1.9984014443252818e-15,
	1.2434497875801753e-14}, /* L124 */
{1.5360237012065137e+00, 2.1316282072803006e-14,
	2.2204460492503131e-16, -6.4726002335646626e-14,
	3.2862601528904634e-14}, /* L125 */
{1.6746290145223433e+00, 2.3425705819590803e-14,
	2.2204460492503131e-16, 5.9952043329758453e-15,
	7.7715611723760958e-15}, /* L126 */
{1.3090753174492020e+00, 1.8457457784393227e-14,
	2.2204460492503131e-16, -2.3980817331903381e-14,
	-2.6179058920661191e-13}, /* L127 */
{1.9687803787438483e+00, 2.7977620220553945e-14,
	2.2204460492503131e-16, -2.7755575615628914e-15,
	-9.9920072216264089e-16}, /* L128 */
{1.9070061697393341e+00, 2.7311486405778851e-14,
	2.2204460492503131e-16, 1.7319479184152442e-14,
	3.4638958368304884e-14}, /* L129 */
{2.1846490942642083e+00, 3.1530333899354446e-14,
	2.2204460492503131e-16, -1.4876988529977098e-14,
	7.9936057773011271e-15}, /* L130 */
{2.0649173583425950e+00, 3.0031532816110484e-14,
	2.2204460492503131e-16, -7.0499162063697440e-14,
	1.4876988529977098e-14}, /* L131 */
{1.3409297817707460e+00, 1.9650947535865271e-14,
	2.2204460492503131e-16, 1.7541523789077473e-14,
	-5.8841820305133297e-15}, /* L132 */
{1.5413771672704086e+00, 2.2759572004815709e-14,
	2.2204460492503131e-16, -9.1038288019262836e-15,
	6.8389738316909643e-14}, /* L133 */
{1.8946187866518844e+00, 2.8185787037671162e-14,
	2.2204460492503131e-16, 5.7731597280508140e-15,
	-6.6613381477509392e-15}, /* L134 */
{1.6203953734517988e+00, 2.4286128663675299e-14,
	2.2204460492503131e-16, -4.4408920985006262e-16,
	3.7747582837255322e-15}, /* L135 */
{1.5919363286574972e+00, 2.4036328483134639e-14,
	2.2204460492503131e-16, -1.2878587085651816e-14,
	1.0436096431476471e-14}, /* L136 */
{1.9452854906648289e+00, 2.9587443606260422e-14,
	2.2204460492503131e-16, -5.6621374255882984e-15,
	-1.0325074129013956e-14}, /* L137 */
{2.2323714025370274e+00, 3.4201808052358729e-14,
	2.2204460492503131e-16, -5.9063864910058328e-14,
	-3.9634961979118088e-14}, /* L138 */
{1.8075818482472423e+00, 2.7894353493707058e-14,
	2.2204460492503131e-16, 7.3274719625260332e-15,
	-9.4368957093138306e-15}, /* L139 */
{1.5321664988307440e+00, 2.3814283878209608e-14,
	2.2204460492503131e-16, -2.9942714974140472e-13,
	-3.4139358007223564e-13}, /* L140 */
{2.6347924285160054e+00, 4.1244785364824565e-14,
	2.2204460492503131e-16, 6.6613381477509392e-16,
	-8.4376949871511897e-15}, /* L141 */
{1.8521412550311385e+00, 2.9198865547641617e-14,
	2.2204460492503131e-16, 1.7763568394002505e-15,
	1.0658141036401503e-14}, /* L142 */
{1.8496788906302410e+00, 2.9365399001335390e-14,
	2.2204460492503131e-16, -1.6653345369377348e-15,
	-3.2862601528904634e-14}, /* L143 */
{1.3906464580015256e+00, 2.2232216068118760e-14,
	2.2204460492503131e-16, -1.1213252548714081e-14,
	3.4416913763379853e-14}, /* L144 */
{1.4827815003566338e+00, 2.3869795029440866e-14,
	2.2204460492503131e-16, 4.3964831775156199e-14,
	9.9920072216264089e-15}, /* L145 */
{1.9366737189468126e+00, 3.1391556021276301e-14,
	2.2204460492503131e-16, -2.8532731732866523e-14,
	2.9976021664879227e-14}, /* L146 */
{1.6802980362370283e+00, 2.7422508708241367e-14,
	2.2204460492503131e-16, 7.7493567118835927e-14,
	2.2204460492503131e-16}, /* L147 */
{1.7094858372276440e+00, 2.8088642523016460e-14,
	2.2204460492503131e-16, 2.4424906541753444e-15,
	-1.1324274851176597e-14}, /* L148 */
{3.3616290519342669e+00, 5.5608295745912528e-14,
	2.2204460492503131e-16, 1.5987211554602254e-14,
	1.9761969838327786e-14}, /* L149 */
{2.9133782874447340e+00, 4.8516746176119341e-14,
	2.2204460492503131e-16, -1.6320278461989801e-14,
	1.0658141036401503e-14}, /* L150 */
{1.9205594360078899e+00, 3.2196467714129540e-14,
	2.2204460492503131e-16, 4.5075054799781356e-14,
	2.9976021664879227e-14}, /* L151 */
{1.5723926834412174e+00, 2.6534330288541241e-14,
	2.2204460492503131e-16, -2.1649348980190553e-14,
	1.7763568394002505e-14}, /* L152 */
{2.2484007064231508e+00, 3.8191672047105385e-14,
	2.2204460492503131e-16, -1.1990408665951691e-14,
	-8.4376949871511897e-15}, /* L153 */
{2.2159432834345298e+00, 3.7886360715333467e-14,
	2.2204460492503131e-16, -2.1094237467877974e-15,
	5.7731597280508140e-14}, /* L154 */
{2.4839092950460229e+00, 4.2743586448068527e-14,
	2.2204460492503131e-16, 1.7763568394002505e-15,
	-3.3639757646142243e-14}, /* L155 */
{2.8429925859922287e+00, 4.9238391142125693e-14,
	2.2204460492503131e-16, 9.3702823278363212e-14,
	-4.3298697960381105e-15}, /* L156 */
{1.7985946317186561e+00, 3.1349922657852858e-14,
	2.2204460492503131e-16, 3.9079850466805510e-14,
	-4.3187675657918589e-14}, /* L157 */
{2.2500347185644372e+00, 3.9468428525424315e-14,
	2.2204460492503131e-16, -6.8833827526759706e-15,
	9.3258734068513149e-15}, /* L158 */
{2.5189067918509283e+00, 4.4464432136237519e-14,
	2.2204460492503131e-16, 2.3048229991218250e-13,
	-1.4599432773820809e-13}, /* L159 */
{2.9300256797347366e+00, 5.2046908449732143e-14,
	2.2204460492503131e-16, -1.3766765505351941e-14,
	9.1038288019262836e-15}, /* L160 */
{2.2018973298304485e+00, 3.9357406222961799e-14,
	2.2204460492503131e-16, 2.1538326677728037e-14,
	-2.4535928844215960e-14}, /* L161 */
{2.4784333045366185e+00, 4.4575454438700035e-14,
	2.2204460492503131e-16, -2.8088642523016460e-14,
	2.2204460492503131e-16}, /* L162 */
{2.4478905322621287e+00, 4.4297898682543746e-14,
	2.2204460492503131e-16, 6.3060667798708891e-14,
	8.2156503822261584e-15}, /* L163 */
{1.9390543103075617e+00, 3.5305092183079978e-14,
	2.2204460492503131e-16, -1.0214051826551440e-14,
	2.9753977059954195e-14}, /* L164 */
{2.3926979047394039e+00, 4.3830390705767996e-14,
	2.2204460492503131e-16, -2.9753977059954195e-14,
	3.3306690738754696e-15}, /* L165 */
{1.8870773108172394e+00, 3.4777736246383029e-14,
	2.2204460492503131e-16, -3.0642155479654321e-14,
	-7.2830630415410269e-14}, /* L166 */
{3.0988502111965350e+00, 5.7454041524351851e-14,
	2.2204460492503131e-16, 1.9984014443252818e-15,
	-1.1768364061026659e-14}, /* L167 */
{2.0774130073509189e+00, 3.8746783559417963e-14,
	2.2204460492503131e-16, 1.7963408538435033e-13,
	-9.8254737679326354e-14}, /* L168 */
{1.7840511969681965e+00, 3.3473224192448470e-14,
	2.2204460492503131e-16, 1.2656542480726785e-14,
	2.0428103653102880e-14}, /* L169 */
{1.6103189652471119e+00, 3.0392355299113660e-14,
	2.2204460492503131e-16, -6.4392935428259079e-15,
	3.3306690738754696e-15}, /* L170 */
{1.4590868415381790e+00, 2.7700064464397656e-14,
	2.2204460492503131e-16, -3.4861002973229915e-14,
	1.7541523789077473e-14}, /* L171 */
{2.0625318253507161e+00, 3.9385161798577428e-14,
	2.2204460492503131e-16, 4.4408920985006262e-15,
	5.7731597280508140e-15}, /* L172 */
{2.4509048700612515e+00, 4.7073456244106637e-14,
	2.2204460492503131e-16, 6.8833827526759706e-15,
	-4.3298697960381105e-15}, /* L173 */
{2.7672840791527755e+00, 5.3457238635701287e-14,
	2.2204460492503131e-16, 9.6811447747313650e-14,
	-1.2778667013435552e-13}, /* L174 */
{2.0886036562166272e+00, 4.0578651550049472e-14,
	2.2204460492503131e-16, -2.6867397195928788e-14,
	-9.6589403142388619e-15}, /* L175 */
{2.3238994946785558e+00, 4.5408121707168903e-14,
	2.2204460492503131e-16, 4.7295500849031669e-14,
	-2.7200464103316335e-14}, /* L176 */
{2.8051280295473875e+00, 5.5122573172639022e-14,
	2.2204460492503131e-16, -7.3274719625260332e-15,
	1.1546319456101628e-14}, /* L177 */
{1.9901992485659987e+00, 3.9329650647346170e-14,
	2.2204460492503131e-16, -2.2848389846785722e-13,
	-1.6198153929281034e-13}, /* L178 */
{2.7221090418883036e+00, 5.4095616874860752e-14,
	2.2204460492503131e-16, -5.9952043329758453e-15,
	2.7311486405778851e-14}, /* L179 */
{1.7104430592043798e+00, 3.4180991370647007e-14,
	2.2204460492503131e-16, -7.4384942649885488e-15,
	-1.2945200467129325e-13}, /* L180 */
{1.6882166573145112e+00, 3.3924252296202440e-14,
	2.2204460492503131e-16, -9.8809849191638932e-15,
	-7.3274719625260332e-15}, /* L181 */
{3.0563658417612878e+00, 6.1756155744774333e-14,
	2.2204460492503131e-16, -2.2315482794965646e-14,
	1.5543122344752192e-14}, /* L182 */
{2.9494990633760696e+00, 5.9924287754142824e-14,
	2.2204460492503131e-16, -3.7858605139717838e-14,
	5.5067062021407764e-14}, /* L183 */
{1.8668766324320636e+00, 3.8136160895874127e-14,
	2.2204460492503131e-16, 4.4408920985006262e-15,
	2.2204460492503131e-14}, /* L184 */
{3.3041050371670369e+00, 6.7862382380212694e-14,
	2.2204460492503131e-16, -6.6435745793569367e-13,
	3.2640556923979602e-13}, /* L185 */
{2.2150879427681005e+00, 4.5741188614556449e-14,
	2.2204460492503131e-16, 1.3256062914024369e-13,
	1.8207657603852567e-14}, /* L186 */
{2.5762429605903074e+00, 5.3484994211316916e-14,
	2.2204460492503131e-16, 3.6859404417555197e-14,
	-1.3100631690576847e-14}, /* L187 */
{2.6542962755625545e+00, 5.5400128928795311e-14,
	2.2204460492503131e-16, -1.7685852782278744e-13,
	-1.5509815654013437e-13}, /* L188 */
{2.4524187937789370e+00, 5.1458837191376006e-14,
	2.2204460492503131e-16, -4.8960835385969403e-14,
	-7.4384942649885488e-15}, /* L189 */
{2.1552964146248783e+00, 4.5463632858400160e-14,
	2.2204460492503131e-16, -2.9087843245179101e-14,
	2.4646951146678475e-14}, /* L190 */
{2.2729408311734809e+00, 4.8197557056539608e-14,
	2.2204460492503131e-16, -1.2434497875801753e-14,
	-1.1102230246251565e-16}, /* L191 */
{2.7057709173477096e+00, 5.7676086129276882e-14,
	2.2204460492503131e-16, -2.1205259770340490e-14,
	2.5313084961453569e-14}, /* L192 */
{2.8238777699887536e+00, 6.0507154842071031e-14,
	2.2204460492503131e-16, 1.1768364061026659e-14,
	-5.2180482157382357e-15}, /* L193 */
{2.7062273247337711e+00, 5.8286708792820718e-14,
	2.2204460492503131e-16, 3.2418512319054571e-14,
	1.7319479184152442e-14}, /* L194 */
{1.5974605466275047e+00, 3.4583447217073626e-14,
	2.2204460492503131e-16, -1.5543122344752192e-14,
	3.7969627442180354e-14}, /* L195 */
{3.3776031376180593e+00, 7.3496764230185363e-14,
	2.2204460492503131e-16, 3.1752378504279477e-14,
	3.5749181392930041e-14}, /* L196 */
{2.8191266216130195e+00, 6.1657276506643655e-14,
	2.2204460492503131e-16, 1.6919798895287386e-13,
	-3.7081449022480228e-14}, /* L197 */
{2.3611475441724723e+00, 5.1902926401226068e-14,
	2.2204460492503131e-16, 3.9745984281580604e-14,
	-3.2529534621517087e-14}, /* L198 */
{2.1935011829220654e+00, 4.8461235024888083e-14,
	2.2204460492503131e-16, 5.9507954119908391e-14,
	-1.7208456881689926e-14}, /* L199 */
{2.5250389619438347e+00, 5.6066262743570405e-14,
	2.2204460492503131e-16, -1.3200551762793111e-13,
	-4.2410519540680980e-14}, /* L200 */
{2.3084933320371150e+00, 5.1514348342607263e-14,
	2.2204460492503131e-16, 2.1760371282653068e-14,
	4.8849813083506888e-15}, /* L201 */
{2.1584491469616061e+00, 4.8405723873656825e-14,
	2.2204460492503131e-16, -8.5709217501062085e-14,
	5.5511151231257827e-15}, /* L202 */
{3.3719732126048272e+00, 7.5994766035591965e-14,
	2.2204460492503131e-16, 3.9968028886505635e-15,
	2.4202861936828413e-14}, /* L203 */
{2.5711181043290647e+00, 5.8231197641589461e-14,
	2.2204460492503131e-16, 7.5495165674510645e-15,
	1.4654943925052066e-14}, /* L204 */
{2.2414980014670256e+00, 5.1014747981525943e-14,
	2.2204460492503131e-16, -2.7233770794055090e-12,
	4.0367709175370692e-13}, /* L205 */
{2.6747985543232389e+00, 6.1173288656846125e-14,
	2.2204460492503131e-16, -4.1855408028368402e-14,
	1.9184653865522705e-13}, /* L206 */
{2.4275736899163927e+00, 5.5788706987414116e-14,
	2.2204460492503131e-16, 4.5741188614556449e-14,
	4.7295500849031669e-14}, /* L207 */
{3.4207258595269141e+00, 7.8992368202079888e-14,
	2.2204460492503131e-16, 4.8849813083506888e-15,
	1.0214051826551440e-14}, /* L208 */
{1.9928537167083293e+00, 4.6240788975637770e-14,
	2.2204460492503131e-16, -6.2172489379008766e-15,
	6.8833827526759706e-15}, /* L209 */
{3.3228191290223670e+00, 7.7469280990172251e-14,
	2.2204460492503131e-16, 3.9968028886505635e-14,
	1.1213252548714081e-13}, /* L210 */
{2.3815533356051382e+00, 5.5788706987414116e-14,
	2.2204460492503131e-16, -1.1213252548714081e-14,
	-1.6653345369377348e-15}, /* L211 */
{3.7193970138113874e+00, 8.7541085491693593e-14,
	2.2204460492503131e-16, 3.6193270602780103e-14,
	1.3544720900426910e-14}, /* L212 */
{2.9190591262752417e+00, 6.9028116556069108e-14,
	2.2204460492503131e-16, -2.6645352591003757e-15,
	7.1054273576010019e-15}, /* L213 */
{2.7885944305365191e+00, 6.6252558994506217e-14,
	2.2204460492503131e-16, 6.2172489379008766e-15,
	-8.9928064994637680e-15}, /* L214 */
{3.2233055503148913e+00, 7.6938455606523348e-14,
	2.2204460492503131e-16, 7.1276318180935050e-14,
	8.2156503822261584e-15}, /* L215 */
{2.0960971580864860e+00, 5.0265347439903962e-14,
	2.2204460492503131e-16, -4.8405723873656825e-14,
	1.3100631690576847e-14}, /* L216 */
{3.6682593670737966e+00, 8.8373752760162461e-14,
	2.2204460492503131e-16, -1.0820233597996776e-12,
	3.2818192607919627e-13}, /* L217 */
{2.3555409337051239e+00, 5.7009952314501788e-14,
	2.2204460492503131e-16, -9.0483176506950258e-14,
	-1.0935696792557792e-13}, /* L218 */
{2.7580334246836968e+00, 6.7057470687359455e-14,
	2.2204460492503131e-16, -8.4376949871511897e-15,
	-4.2188474935755949e-15}, /* L219 */
{2.5875399263489585e+00, 6.3199445676787036e-14,
	2.2204460492503131e-16, 4.4408920985006262e-15,
	-9.7699626167013776e-15}, /* L220 */
{2.6776431266172818e+00, 6.5697447482193638e-14,
	2.2204460492503131e-16, -4.1078251911130792e-15,
	-3.0975222387041867e-14}, /* L221 */
{2.9465544750369372e+00, 7.2622463598293052e-14,
	2.2204460492503131e-16, 2.6645352591003757e-15,
	1.8873791418627661e-14}, /* L222 */
{2.9103588088650989e+00, 7.2053474298172659e-14,
	2.2204460492503131e-16, 8.0380146982861334e-14,
	-1.0491607582707729e-13}, /* L223 */
{2.1942302860490086e+00, 5.4567461660326444e-14,
	2.2204460492503131e-16, -1.2543299732215019e-12,
	-2.3796520309815605e-12}, /* L224 */
{2.9328230319262962e+00, 7.3260841837452517e-14,
	2.2204460492503131e-16, 5.5733195836182858e-14,
	3.3306690738754696e-15}, /* L225 */
{2.4845516115510300e+00, 6.2339022832702540e-14,
	2.2204460492503131e-16, -1.7541523789077473e-14,
	-2.4313884239290928e-14}, /* L226 */
{2.8414535359253952e+00, 7.1609385088322597e-14,
	2.2204460492503131e-16, 4.5297099404706387e-14,
	-9.8365759981788869e-14}, /* L227 */
{2.1601210504727981e+00, 5.4678483962788960e-14,
	2.2204460492503131e-16, 3.8413716652030416e-14,
	2.5757174171303632e-14}, /* L228 */
{3.1812717951789433e+00, 8.0879747343942654e-14,
	2.2204460492503131e-16, -1.7047474543119279e-12,
	6.3793414994961495e-13}, /* L229 */
{3.1060261875834261e+00, 7.9311557321659620e-14,
	2.2204460492503131e-16, 3.7303493627405260e-14,
	5.1070259132757201e-14}, /* L230 */
{2.8831613709740678e+00, 7.3940853440035426e-14,
	2.2204460492503131e-16, -2.7533531010703882e-14,
	-1.0769163338864018e-14}, /* L231 */
{2.5205130300389698e+00, 6.4920291364956029e-14,
	2.2204460492503131e-16, 6.3948846218409017e-14,
	2.5757174171303632e-14}, /* L232 */
{4.5757143811716361e+00, 1.1836365221284950e-13,
	2.2204460492503131e-16, -1.8651746813702630e-14,
	1.3766765505351941e-14}, /* L233 */
{2.3782418250352051e+00, 6.1783911320389961e-14,
	2.2204460492503131e-16, 6.4837024638109142e-14,
	-8.7707618945387367e-15}, /* L234 */
{2.6340831977140020e+00, 6.8722805224297190e-14,
	2.2204460492503131e-16, -5.1736392947532295e-14,
	-1.9428902930940239e-14}, /* L235 */
{2.4438936420564654e+00, 6.4032112945255903e-14,
	2.2204460492503131e-16, -4.3298697960381105e-15,
	-1.0769163338864018e-14}, /* L236 */
{3.6435161359218013e+00, 9.5867758176382267e-14,
	2.2204460492503131e-16, 8.8817841970012523e-15,
	2.6645352591003757e-14}, /* L237 */
{3.0378620009741142e+00, 8.0269124680398818e-14,
	2.2204460492503131e-16, 1.9317880628477724e-14,
	-1.4466206010865790e-13}, /* L238 */
{3.6726508121238957e+00, 9.7449825986473115e-14,
	2.2204460492503131e-16, -1.4332979247910771e-13,
	2.7533531010703882e-14}, /* L239 */
{1.8989876351583057e+00, 5.0598414347291509e-14,
	2.2204460492503131e-16, 4.6629367034256575e-15,
	7.3052675020335300e-14}, /* L240 */
{3.4689331945027613e+00, 9.2814644858663087e-14,
	2.2204460492503131e-16, 8.8373752760162461e-14,
	-7.7937656328685989e-14}, /* L241 */
{3.7774343197562574e+00, 1.0148826223854712e-13,
	2.2204460492503131e-16, -1.3256062914024369e-13,
	-2.0405899192610377e-13}, /* L242 */
{2.6003487659619116e+00, 7.0152217368502079e-14,
	2.2204460492503131e-16, -1.6106005418237146e-12,
	-5.1847415249994810e-13}, /* L243 */
{2.8709459387145744e+00, 7.7771122874992216e-14,
	2.2204460492503131e-16, -1.3655743202889425e-14,
	1.1324274851176597e-14}, /* L244 */
{3.5551568977225330e+00, 9.6700425444851135e-14,
	2.2204460492503131e-16, -4.0634162701280729e-14,
	1.0658141036401503e-14}, /* L245 */
{4.1484379951128876e+00, 1.1329825966299722e-13,
	2.2204460492503131e-16, -8.7707618945387367e-15,
	-5.9952043329758453e-15}, /* L246 */
{3.4089594836366168e+00, 9.3480778673438181e-14,
	2.2204460492503131e-16, 7.2830630415410269e-14,
	6.8611782921834674e-14}, /* L247 */
{2.5645557007292012e+00, 7.0610184366159956e-14,
	2.2204460492503131e-16, -4.0634162701280729e-14,
	-7.2053474298172659e-14}, /* L248 */
{3.0582801217071753e+00, 8.4543483325205671e-14,
	2.2204460492503131e-16, -1.6764367671839864e-14,
	-3.0864200084579352e-14}, /* L249 */
{2.9685458053592919e+00, 8.2392426214994430e-14,
	2.2204460492503131e-16, -3.2196467714129540e-14,
	-1.9650947535865271e-14}, /* L250 */
{3.6434825146120655e+00, 1.0152989560197057e-13,
	2.2204460492503131e-16, 1.7097434579227411e-14,
	1.5543122344752192e-14}, /* L251 */
{3.0139353946202108e+00, 8.4321438720280639e-14,
	2.2204460492503131e-16, -2.0539125955565396e-14,
	-1.5543122344752192e-15}, /* L252 */
{2.8508345028798892e+00, 8.0074835651089415e-14,
	2.2204460492503131e-16, 3.7747582837255322e-15,
	1.1168843627729075e-13}, /* L253 */
{3.5039910752784365e+00, 9.8809849191638932e-14,
	2.2204460492503131e-16, 7.1276318180935050e-14,
	2.0805579481475434e-13}, /* L254 */
{3.7103513692402537e+00, 1.0504097591734762e-13,
	2.2204460492503131e-16, -7.5495165674510645e-15,
	-3.1530333899354446e-14}, /* L255 */
{2.7695739851769900e+00, 7.8714812445923599e-14,
	2.2204460492503131e-16, 5.1070259132757201e-15,
	2.5091040356528538e-14}, /* L256 */
{2.7724163198841438e+00, 7.9103390504542404e-14,
	2.2204460492503131e-16, 3.5305092183079978e-14,
	4.8472337255134335e-13}, /* L257 */
{3.7132355906710761e+00, 1.0635936575909000e-13,
	2.2204460492503131e-16, 5.7287508070658077e-14,
	-7.7049477908985864e-14}, /* L258 */
{3.0791980919006119e+00, 8.8540286213856234e-14,
	2.2204460492503131e-16, 1.7985612998927536e-14,
	-9.6589403142388619e-15}, /* L259 */
{2.0783974547759732e+00, 5.9993676693181897e-14,
	2.2204460492503131e-16, 2.9531932455029164e-14,
	-4.1078251911130792e-15}, /* L260 */
{3.8851174195338651e+00, 1.1257661469699087e-13,
	2.2204460492503131e-16, 1.6875389974302379e-13,
	2.6711965972481266e-13}, /* L261 */
{4.3186496530423506e+00, 1.2561826578938451e-13,
	2.2204460492503131e-16, -5.1136872514234710e-13,
	5.1736392947532295e-14}, /* L262 */
{3.7909330197018480e+00, 1.1068923555512811e-13,
	2.2204460492503131e-16, -7.8492767840998567e-14,
	6.5503158452884236e-14}, /* L263 */
{3.9299848830139119e+00, 1.1518563880485999e-13,
	2.2204460492503131e-16, -5.8841820305133297e-15,
	-1.4155343563970746e-13}, /* L264 */
{4.1774229491837191e+00, 1.2290168882600483e-13,
	2.2204460492503131e-16, -1.5987211554602254e-14,
	4.0412118096355698e-14}, /* L265 */
{2.7744789010868378e+00, 8.1934459217336553e-14,
	2.2204460492503131e-16, 3.9968028886505635e-15,
	6.4392935428259079e-15}, /* L266 */
{3.7355445317129057e+00, 1.1073086891855155e-13,
	2.2204460492503131e-16, -3.0464519795714295e-13,
	-9.8920871494101448e-14}, /* L267 */
{2.3022743306039679e+00, 6.8500760619372159e-14,
	2.2204460492503131e-16, -6.5614180755346752e-14,
	2.1094237467877974e-14}, /* L268 */
{2.5474370770692856e+00, 7.6078032762438852e-14,
	2.2204460492503131e-16, -9.7699626167013776e-15,
	2.1094237467877974e-14}, /* L269 */
{2.9259710743468554e+00, 8.7707618945387367e-14,
	2.2204460492503131e-16, -9.2925667161125602e-14,
	-1.9428902930940239e-14}, /* L270 */
{4.1684222533137527e+00, 1.2541356841921925e-13,
	2.2204460492503131e-16, 8.5043083686286991e-14,
	3.7525538232330291e-14}, /* L271 */
{3.7500578642739915e+00, 1.1324274851176597e-13,
	2.2204460492503131e-16, -5.9729998724833422e-14,
	-7.8825834748386114e-15}, /* L272 */
{2.7784311502337311e+00, 8.4210416417818124e-14,
	2.2204460492503131e-16, -1.0880185641326534e-14,
	1.4876988529977098e-14}, /* L273 */
{4.3778047768327930e+00, 1.3317125180378753e-13,
	2.2204460492503131e-16, -6.0063065632220969e-14,
	-5.9952043329758453e-14}, /* L274 */
{2.9973189766086441e+00, 9.1510132804728528e-14,
	2.2204460492503131e-16, -1.7985612998927536e-14,
	-1.6431300764452317e-14}, /* L275 */
{4.1993401591234125e+00, 1.2867484855405564e-13,
	2.2204460492503131e-16, -6.5392136150421720e-14,
	-3.1086244689504383e-15}, /* L276 */
{2.8780058252709164e+00, 8.8506459106074686e-14,
	2.2204460492503131e-16, 3.7059244561987725e-13,
	-3.6881608878047700e-13}, /* L277 */
{3.5000540066536838e+00, 1.0802470029602773e-13,
	2.2204460492503131e-16, -8.5043083686286991e-14,
	2.6556534749033744e-13}, /* L278 */
{2.8208320565674430e+00, 8.7374552037999820e-14,
	2.2204460492503131e-16, -1.4210854715202004e-14,
	1.3322676295501878e-15}, /* L279 */
{4.0357765586935717e+00, 1.2545520178264269e-13,
	2.2204460492503131e-16, 1.3322676295501878e-14,
	3.7969627442180354e-14}, /* L280 */
{4.5320984010938821e+00, 1.4138690218601369e-13,
	2.2204460492503131e-16, -6.4392935428259079e-15,
	-5.5511151231257827e-16}, /* L281 */
{2.7855039738885403e+00, 8.7208018584306046e-14,
	2.2204460492503131e-16, -8.9928064994637680e-15,
	2.0206059048177849e-14}, /* L282 */
{4.0201592051375776e+00, 1.2630868573282328e-13,
	2.2204460492503131e-16, 1.8429702208777599e-14,
	2.8954616482224083e-13}, /* L283 */
{3.5405475892265676e+00, 1.1163292512605949e-13,
	2.2204460492503131e-16, -1.2068124277675452e-13,
	-1.0058620603103918e-13}, /* L284 */
{3.1482941929541530e+00, 9.9614760884492171e-14,
	2.2204460492503131e-16, 3.3306690738754696e-14,
	-2.2648549702353193e-14}, /* L285 */
{3.7041655477529858e+00, 1.1761425167122752e-13,
	2.2204460492503131e-16, 2.5535129566378600e-14,
	-9.8365759981788869e-14}, /* L286 */
{4.0584249917889874e+00, 1.2931322679321511e-13,
	2.2204460492503131e-16, -3.3750779948604759e-14,
	-1.7541523789077473e-14}, /* L287 */
{4.7561497773972219e+00, 1.5207279879803082e-13,
	2.2204460492503131e-16, 2.6645352591003757e-14,
	9.9920072216264089e-15}, /* L288 */
{3.6280836638441429e+00, 1.1640688413194766e-13,
	2.2204460492503131e-16, -4.1633363423443370e-14,
	-5.1847415249994810e-14}, /* L289 */
{3.9892856935458521e+00, 1.2843892616132280e-13,
	2.2204460492503131e-16, -7.3718808835110394e-14,
	-9.9253938401488995e-14}, /* L290 */
{2.6392159814544351e+00, 8.5265128291212022e-14,
	2.2204460492503131e-16, 9.2814644858663087e-14,
	1.2034817586936697e-13}, /* L291 */
{3.6918377878422501e+00, 1.1968204205459188e-13,
	2.2204460492503131e-16, -1.0547118733938987e-14,
	-4.8294701571194310e-14}, /* L292 */
{3.4659237871852957e+00, 1.1274314815068465e-13,
	2.2204460492503131e-16, -3.3750779948604759e-14,
	-1.6653345369377348e-14}, /* L293 */
{3.9949596023480041e+00, 1.3039569424222464e-13,
	2.2204460492503131e-16, 7.5273121069585613e-14,
	-1.9073631563060189e-13}, /* L294 */
{4.0949784407116701e+00, 1.3411494137471891e-13,
	2.2204460492503131e-16, -1.3822276656583199e-13,
	-3.7403413699621524e-13}, /* L295 */
{3.5878931998724704e+00, 1.1790568521519162e-13,
	2.2204460492503131e-16, 2.2870594307278225e-14,
	-5.0626169922907138e-14}, /* L296 */
{2.8889334658101604e+00, 9.5257135512838431e-14,
	2.2204460492503131e-16, 8.0158102377936302e-14,
	4.9515946898281982e-14}, /* L297 */
{2.8020566592086511e+00, 9.2703622556200571e-14,
	2.2204460492503131e-16, 9.7255536957163713e-14,
	5.1403326040144748e-13}, /* L298 */
{3.2726257482199399e+00, 1.0863532295957157e-13,
	2.2204460492503131e-16, 8.4376949871511897e-15,
	-6.0174087934683484e-14}, /* L299 */
{3.3617185387731494e+00, 1.1196599203344704e-13,
	2.2204460492503131e-16, 1.1501910535116622e-13,
	-1.1157741397482823e-13}, /* L300 */
{3.8219028266783948e+00, 1.2771728119531645e-13,
	2.2204460492503131e-16, 9.0594198809412774e-14,
	3.4194869158454821e-14}, /* L301 */
{3.8543641095037744e+00, 1.2922996006636822e-13,
	2.2204460492503131e-16, 7.5495165674510645e-14,
	-1.4221956945448255e-13}, /* L302 */
{3.3602003635324427e+00, 1.1303458169464875e-13,
	2.2204460492503131e-16, 4.3742787170231168e-14,
	-9.4368957093138306e-15}, /* L303 */
{3.6595959421092354e+00, 1.2351231148954867e-13,
	2.2204460492503131e-16, -5.3179682879544998e-14,
	5.1514348342607263e-14}, /* L304 */
{3.1943115840600873e+00, 1.0816347817410588e-13,
	2.2204460492503131e-16, -5.7509552675583109e-14,
	-1.5543122344752192e-14}, /* L305 */
{4.4710657216009277e+00, 1.5189238755652923e-13,
	2.2204460492503131e-16, 1.1262102361797588e-12,
	1.9320101074526974e-12}, /* L306 */
{4.0896396513316224e+00, 1.3938850074168840e-13,
	2.2204460492503131e-16, -1.5210055437364645e-14,
	-7.9269923958236177e-14}, /* L307 */
{5.9612324052940657e+00, 2.0384041676813069e-13,
	2.2204460492503131e-16, -6.3282712403633923e-14,
	6.0396132539608516e-14}, /* L308 */
{3.6327421382070098e+00, 1.2462253451417382e-13,
	2.2204460492503131e-16, 1.1102230246251565e-15,
	-1.8873791418627661e-14}, /* L309 */
{4.3702287239778652e+00, 1.5040746426109308e-13,
	2.2204460492503131e-16, 2.6423307986078726e-14,
	2.2204460492503131e-16}, /* L310 */
{2.6972884043591026e+00, 9.3130364531290866e-14,
	2.2204460492503131e-16, -9.2148511043887993e-14,
	-1.6875389974302379e-14}, /* L311 */
{3.8542261382814735e+00, 1.3350431871117507e-13,
	2.2204460492503131e-16, 7.7493567118835927e-14,
	-1.4432899320127035e-14}, /* L312 */
{3.3275273828674061e+00, 1.1562972801471005e-13,
	2.2204460492503131e-16, -8.3266726846886741e-14,
	-3.7081449022480228e-14}, /* L313 */
{4.9347895207576640e+00, 1.7202905766566801e-13,
	2.2204460492503131e-16, -3.5749181392930041e-14,
	2.3980817331903381e-14}, /* L314 */
{4.1857788732647982e+00, 1.4638290579682689e-13,
	2.2204460492503131e-16, -7.4051875742497941e-14,
	1.0813572259849025e-13}, /* L315 */
{4.4225365952081974e+00, 1.5515366769136563e-13,
	2.2204460492503131e-16, 2.1316282072803006e-14,
	-1.4188650254709501e-13}, /* L316 */
{4.0276646714714666e+00, 1.4174772466901686e-13,
	2.2204460492503131e-16, -2.0761170560490427e-14,
	1.1990408665951691e-14}, /* L317 */
{4.0723898819578377e+00, 1.4377388168895777e-13,
	2.2204460492503131e-16, 5.9952043329758453e-15,
	1.0436096431476471e-14}, /* L318 */
{3.4828123613023654e+00, 1.2334577803585489e-13,
	2.2204460492503131e-16, 4.4408920985006262e-15,
	1.0524914273446484e-13}, /* L319 */
{4.0625626862965687e+00, 1.4432899320127035e-13,
	2.2204460492503131e-16, 1.3544720900426910e-14,
	-6.6946448384896939e-14}, /* L320 */
{3.4922657244865749e+00, 1.2445600106048005e-13,
	2.2204460492503131e-16, 1.2634338020234281e-13,
	-6.0951244051921094e-14}, /* L321 */
{4.3649741848750399e+00, 1.5604184611106575e-13,
	2.2204460492503131e-16, 9.5479180117763462e-15,
	8.8151708155237429e-14}, /* L322 */
{3.6169288750767836e+00, 1.2970180485183391e-13,
	2.2204460492503131e-16, -7.7715611723760958e-16,
	-1.7097434579227411e-14}, /* L323 */
{4.6875723303391226e+00, 1.6861512186494565e-13,
	2.2204460492503131e-16, -1.5620837956475953e-13,
	-2.1538326677728037e-14}, /* L324 */
{3.7169804308043264e+00, 1.3411494137471891e-13,
	2.2204460492503131e-16, 4.4408920985006262e-16,
	1.7985612998927536e-14}, /* L325 */
{4.1664753326374369e+00, 1.5079604231971189e-13,
	2.2204460492503131e-16, 6.1506355564233672e-14,
	-5.0293103015519591e-14}, /* L326 */
{4.0153524777097829e+00, 1.4577228313328305e-13,
	2.2204460492503131e-16, 6.8389738316909643e-14,
	-2.2426505097428162e-14}, /* L327 */
{3.8826818619100782e+00, 1.4138690218601369e-13,
	2.2204460492503131e-16, -3.0353497493251780e-13,
	-9.7710728397260027e-13}, /* L328 */
{4.2158705229913114e+00, 1.5398793351550921e-13,
	2.2204460492503131e-16, -1.5054624213917123e-13,
	1.6342482922482304e-13}, /* L329 */
{4.9803798787347473e+00, 1.8246515409714448e-13,
	2.2204460492503131e-16, -3.5527136788005009e-15,
	-3.7747582837255322e-15}, /* L330 */
{3.8622197158024405e+00, 1.4192813591051845e-13,
	2.2204460492503131e-16, -2.5313084961453569e-14,
	-6.9499961341534799e-14}, /* L331 */
{2.6434895848459301e+00, 9.7435948198665301e-14,
	2.2204460492503131e-16, 1.1746159600534156e-13,
	2.1094237467877974e-14}, /* L332 */
{3.5977469555222945e+00, 1.3300818779704571e-13,
	2.2204460492503131e-16, -5.4289905904170155e-14,
	-3.2196467714129540e-14}, /* L333 */
{3.8743112785364828e+00, 1.4366285938649526e-13,
	2.2204460492503131e-16, 2.7311486405778851e-13,
	5.0404125317982107e-14}, /* L334 */
{4.4806661526545577e+00, 1.6664447599623600e-13,
	2.2204460492503131e-16, -2.6212365611399946e-13,
	-1.4832579608992091e-13}, /* L335 */
{4.1518497783032586e+00, 1.5487611193520934e-13,
	2.2204460492503131e-16, -1.2101430968414206e-14,
	-1.3544720900426910e-14}, /* L336 */
{2.8116160841917153e+00, 1.0519363158323358e-13,
	2.2204460492503131e-16, 1.0591527654923993e-13,
	-2.5746071941057380e-13}, /* L337 */
{4.6420834627579532e+00, 1.7419399256368706e-13,
	2.2204460492503131e-16, 2.2204460492503131e-16,
	3.0642155479654321e-14}, /* L338 */
{3.0693688950053040e+00, 1.1551870571224754e-13,
	2.2204460492503131e-16, -3.1419311596891930e-14,
	-1.1979306435705439e-13}, /* L339 */
{5.8192074387900297e+00, 2.1965762542208722e-13,
	2.2204460492503131e-16, 2.6290081223123707e-13,
	3.9501735216163070e-13}, /* L340 */
{4.9590208003801601e+00, 1.8773871346411397e-13,
	2.2204460492503131e-16, 4.8627768478581856e-14,
	9.1926466438962962e-14}, /* L341 */
{4.1871991123897319e+00, 1.5898393712632242e-13,
	2.2204460492503131e-16, 8.0380146982861334e-14,
	9.1482377229112899e-14}, /* L342 */
{2.9242433724901558e+00, 1.1135536936990320e-13,
	2.2204460492503131e-16, -1.3455903058456897e-13,
	-5.2846615972157451e-14}, /* L343 */
{3.0750837864740705e+00, 1.1744077932362984e-13,
	2.2204460492503131e-16, -6.0840221749458578e-14,
	6.3948846218409017e-14}, /* L344 */
{3.3029495160113536e+00, 1.2650991365603659e-13,
	2.2204460492503131e-16, 1.2878587085651816e-14,
	-1.6653345369377348e-14}, /* L345 */
{3.6113273999264486e+00, 1.3872236692691331e-13,
	2.2204460492503131e-16, -3.1874503036988244e-13,
	-1.4965806371947110e-13}, /* L346 */
{4.6801874901676896e+00, 1.8030021919912542e-13,
	2.2204460492503131e-16, 1.4432899320127035e-14,
	-5.6621374255882984e-15}, /* L347 */
{3.8678757741819410e+00, 1.4943601911454607e-13,
	2.2204460492503131e-16, -6.6835426082434424e-14,
	4.1167069753100805e-13}, /* L348 */
{4.1304362264359300e+00, 1.6003864899971632e-13,
	2.2204460492503131e-16, 1.0969003483296547e-13,
	-2.3714363805993344e-13}, /* L349 */
{5.2586525708158405e+00, 2.0433654768226006e-13,
	2.2204460492503131e-16, -4.0634162701280729e-14,
	2.8643754035329039e-14}, /* L350 */
{3.5620207747832455e+00, 1.3880563365376020e-13,
	2.2204460492503131e-16, 2.2204460492503131e-16,
	-3.5971225997855072e-14}, /* L351 */
{4.3773757825724546e+00, 1.7106455141302490e-13,
	2.2204460492503131e-16, 1.3389289676979388e-13,
	1.0613732115416497e-13}, /* L352 */
{2.7580099788377992e+00, 1.0808715034116290e-13,
	2.2204460492503131e-16, 1.3367085216486885e-13,
	1.7541523789077473e-14}, /* L353 */
{4.2133418490128216e+00, 1.6558976412284210e-13,
	2.2204460492503131e-16, -1.5210055437364645e-14,
	3.3972824553529790e-14}, /* L354 */
{3.5732945733826411e+00, 1.4083179067370111e-13,
	2.2204460492503131e-16, 4.3876013933186186e-13,
	3.2955860262973147e-12}, /* L355 */
{3.2921856306561907e+00, 1.3011813848606835e-13,
	2.2204460492503131e-16, 2.9753977059954195e-13,
	5.5733195836182858e-14}, /* L356 */
{5.3040034106458469e+00, 2.1022072971277339e-13,
	2.2204460492503131e-16, 1.1546319456101628e-14,
	1.7985612998927536e-14}, /* L357 */
{3.5915358651695191e+00, 1.4274692539117950e-13,
	2.2204460492503131e-16, 1.4210854715202004e-14,
	1.3766765505351941e-14}, /* L358 */
{3.5947629889288719e+00, 1.4327428132787645e-13,
	2.2204460492503131e-16, -7.4718009557273035e-14,
	4.2188474935755949e-14}, /* L359 */
{5.9612030938742242e+00, 2.3825386108455859e-13,
	2.2204460492503131e-16, -6.5614180755346752e-14,
	5.5067062021407764e-14}, /* L360 */
{4.4187835568296707e+00, 1.7709791966247224e-13,
	2.2204460492503131e-16, 6.2172489379008766e-14,
	2.7089441800853820e-14}, /* L361 */
{3.6879022090647569e+00, 1.4821477378745840e-13,
	2.2204460492503131e-16, -2.0539125955565396e-14,
	3.9745984281580604e-14}, /* L362 */
{3.6047388175569290e+00, 1.4527268277220173e-13,
	2.2204460492503131e-16, -1.2290168882600483e-13,
	-2.1049828546892968e-13}, /* L363 */
{5.5007716913857783e+00, 2.2229440510557197e-13,
	2.2204460492503131e-16, -5.0293103015519591e-14,
	4.5519144009631418e-14}, /* L364 */
{4.6014408643245703e+00, 1.8646195698579504e-13,
	2.2204460492503131e-16, -9.8143715376863838e-14,
	2.1427304375265521e-13}, /* L365 */
{3.8129003640029775e+00, 1.5493162308644060e-13,
	2.2204460492503131e-16, 9.0372154204487742e-14,
	5.9952043329758453e-14}, /* L366 */
{3.7275779533709077e+00, 1.5187850976872141e-13,
	2.2204460492503131e-16, -2.9976021664879227e-15,
	3.1308289294429414e-14}, /* L367 */
{3.9334846076349184e+00, 1.6070478281449141e-13,
	2.2204460492503131e-16, 2.4646951146678475e-14,
	-2.7644553313166398e-14}, /* L368 */
{4.5000694371284702e+00, 1.8435253323900724e-13,
	2.2204460492503131e-16, -5.9174887212520844e-14,
	-1.1779466291272911e-13}, /* L369 */
{4.5852058859376799e+00, 1.8834933612765781e-13,
	2.2204460492503131e-16, -5.4067861299245124e-14,
	-1.1990408665951691e-14}, /* L370 */
{3.9731071280783361e+00, 1.6364687382974807e-13,
	2.2204460492503131e-16, 5.7953641885433171e-14,
	-5.6732396558345499e-14}, /* L371 */
{6.1761705685796437e+00, 2.5507373990762972e-13,
	2.2204460492503131e-16, -1.4432899320127035e-15,
	6.0396132539608516e-14}, /* L372 */
{4.7078474421172833e+00, 1.9495516312417749e-13,
	2.2204460492503131e-16, -8.7707618945387367e-14,
	-1.4865886299730846e-13}, /* L373 */
{4.6130390947152637e+00, 1.9154122732345513e-13,
	2.2204460492503131e-16, -1.1246559239452836e-13,
	-5.5955240441107890e-14}, /* L374 */
{4.7907405889179788e+00, 1.9945156637390937e-13,
	2.2204460492503131e-16, 3.6415315207705135e-14,
	-1.6231460620019789e-13}, /* L375 */
{4.7088492543932405e+00, 1.9656498650988397e-13,
	2.2204460492503131e-16, -4.2588155224621005e-13,
	1.3100631690576847e-14}, /* L376 */
{4.7865460060700720e+00, 2.0033974479360950e-13,
	2.2204460492503131e-16, 2.2870594307278225e-14,
	1.9761969838327786e-14}, /* L377 */
{4.4749367741899171e+00, 1.8779422461534523e-13,
	2.2204460492503131e-16, 2.3425705819590803e-13,
	-5.8064664187895687e-14}, /* L378 */
{4.5066658449812271e+00, 1.8962609260597674e-13,
	2.2204460492503131e-16, -5.1736392947532295e-14,
	-3.9857006584043120e-14}, /* L379 */
{5.6527188017265582e+00, 2.3847590568948362e-13,
	2.2204460492503131e-16, 5.1514348342607263e-14,
	3.3972824553529790e-14}, /* L380 */
{3.5282696651269934e+00, 1.4924173008523667e-13,
	2.2204460492503131e-16, 1.3988810110276972e-14,
	1.9539925233402755e-14}, /* L381 */
{5.2762464031563292e+00, 2.2376545061320030e-13,
	2.2204460492503131e-16, -1.8762769116165146e-14,
	5.4400928206632670e-14}, /* L382 */
{3.7735476086558344e+00, 1.6045498263395075e-13,
	2.2204460492503131e-16, 1.6697754290362354e-13,
	7.6827433304060833e-14}, /* L383 */
{4.2383361889014060e+00, 1.8068879725774423e-13,
	2.2204460492503131e-16, 2.8976820942716586e-13,
	-4.3964831775156199e-14}, /* L384 */
{3.3558876561183313e+00, 1.4344081478157023e-13,
	2.2204460492503131e-16, -2.5535129566378600e-14,
	2.0206059048177849e-14}, /* L385 */
{5.9320717123774740e+00, 2.5421331706354522e-13,
	2.2204460492503131e-16, 6.5503158452884236e-13,
	9.5856655946136016e-13}, /* L386 */
{3.2041759006555273e+00, 1.3766765505351941e-13,
	2.2204460492503131e-16, 6.0618177144533547e-14,
	4.8849813083506888e-15}, /* L387 */
{2.9961728581354108e+00, 1.2906342661267445e-13,
	2.2204460492503131e-16, 1.4210854715202004e-14,
	-6.7168492989821971e-14}, /* L388 */
{3.8149594766426693e+00, 1.6475709685437323e-13,
	2.2204460492503131e-16, -6.7612582199672033e-14,
	-6.2505556286396313e-14}, /* L389 */
{5.6949456148934239e+00, 2.4658053376924727e-13,
	2.2204460492503131e-16, 7.6605388699135801e-14,
	6.8389738316909643e-14}, /* L390 */
{3.3619361617984511e+00, 1.4593881658697683e-13,
	2.2204460492503131e-16, 3.5083047578154947e-14,
	5.5955240441107890e-14}, /* L391 */
{4.5823298060348492e+00, 1.9942381079829374e-13,
	2.2204460492503131e-16, 2.0539125955565396e-13,
	-7.7415851507112166e-13}, /* L392 */
{4.3569267051264031e+00, 1.9009793739144243e-13,
	2.2204460492503131e-16, -2.1094237467877974e-15,
	7.3274719625260332e-15}, /* L393 */
{3.5114668367467901e+00, 1.5359935545689041e-13,
	2.2204460492503131e-16, -1.3355982986240633e-13,
	3.0420110874729289e-14}, /* L394 */
{5.8239678975141347e+00, 2.5539986792111335e-13,
	2.2204460492503131e-16, 2.0339285811132868e-13,
	-1.4233059175694507e-13}, /* L395 */
{3.5300725889300715e+00, 1.5519703577826505e-13,
	2.2204460492503131e-16, 2.7999824681046448e-13,
	-3.7436720390360279e-13}, /* L396 */
{5.3006039729013956e+00, 2.3362561885065247e-13,
	2.2204460492503131e-16, -2.6645352591003757e-14,
	-1.0214051826551440e-14}, /* L397 */
{4.0634948836006606e+00, 1.7955081865750344e-13,
	2.2204460492503131e-16, -6.3282712403633923e-14,
	4.0190073491430667e-14}, /* L398 */
{4.9250716726849681e+00, 2.1816749795622314e-13,
	2.2204460492503131e-16, -1.7252865802674933e-13,
	-4.8994142076708158e-13}, /* L399 */
{4.0388023524696903e+00, 1.7935652962819404e-13,
	2.2204460492503131e-16, -1.3622436512150671e-13,
	-2.2204460492503131e-14}, /* L400 */
{4.0948161708129209e+00, 1.8229862064345070e-13,
	2.2204460492503131e-16, -4.4408920985006262e-15,
	1.6209256159527285e-14}, /* L401 */
{3.4204423470072500e+00, 1.5265566588595902e-13,
	2.2204460492503131e-16, -1.4865886299730846e-13,
	-3.8635761256955448e-14}, /* L402 */
{4.2047547470537951e+00, 1.8812729152273278e-13,
	2.2204460492503131e-16, -5.6843418860808015e-14,
	-1.7985612998927536e-14}, /* L403 */
{4.9356906432090160e+00, 2.2137847111025621e-13,
	2.2204460492503131e-16, 2.2648549702353193e-14,
	-4.0523140398818214e-14}, /* L404 */
{3.6728745397139617e+00, 1.6514567491299204e-13,
	2.2204460492503131e-16, -1.5210055437364645e-14,
	-9.0705221111875289e-14}, /* L405 */
{5.7106456037293754e+00, 2.5740520825934254e-13,
	2.2204460492503131e-16, -2.2759572004815709e-14,
	-7.5273121069585613e-14}, /* L406 */
{4.5406606327450438e+00, 2.0517268439768088e-13,
	2.2204460492503131e-16, 1.0569323194431490e-13,
	-4.3742787170231168e-14}, /* L407 */
{6.8180797398126272e+00, 3.0883628987510292e-13,
	2.2204460492503131e-16, 6.6835426082434424e-14,
	-2.0572432646304151e-13}, /* L408 */
{4.5782832785419769e+00, 2.0788926136106056e-13,
	2.2204460492503131e-16, -1.5654144647214707e-14,
	-6.2283511681471282e-14}, /* L409 */
{6.5378672391802688e+00, 2.9759528175077321e-13,
	2.2204460492503131e-16, 1.8762769116165146e-13,
	3.4949820815199928e-13}, /* L410 */
{6.8796276647996475e+00, 3.1391556021276301e-13,
	2.2204460492503131e-16, 9.7699626167013776e-15,
	7.3496764230185363e-14}, /* L411 */
{4.7991962623446414e+00, 2.1951884754400908e-13,
	2.2204460492503131e-16, 5.5733195836182858e-14,
	4.5963233219481481e-14}, /* L412 */
{4.9649383989915412e+00, 2.2765123119938835e-13,
	2.2204460492503131e-16, -2.1482815526496779e-13,
	3.9523939676655573e-14}, /* L413 */
{6.1099616612194732e+00, 2.8083091407893335e-13,
	2.2204460492503131e-16, 3.4594549447319878e-13,
	1.5609735726229701e-13}, /* L414 */
{6.7193412005537780e+00, 3.0958569041672490e-13,
	2.2204460492503131e-16, -2.7422508708241367e-14,
	3.7081449022480228e-14}, /* L415 */
{3.5348894866075398e+00, 1.6325829577112927e-13,
	2.2204460492503131e-16, 1.1679546219056647e-13,
	6.6613381477509392e-15}, /* L416 */
{5.6703178750180285e+00, 2.6251223417261826e-13,
	2.2204460492503131e-16, 6.8900440908237215e-13,
	-8.1257223172315207e-13}, /* L417 */
{4.6029147180674830e+00, 2.1360690993788012e-13,
	2.2204460492503131e-16, -9.6223029544262317e-13,
	-1.2267964422107980e-13}, /* L418 */
{4.7816685214150239e+00, 2.2243318298365011e-13,
	2.2204460492503131e-16, 4.6629367034256575e-14,
	-4.3298697960381105e-14}, /* L419 */
{4.9369518527870602e+00, 2.3020474415602621e-13,
	2.2204460492503131e-16, 1.8096635301390052e-13,
	3.5971225997855072e-14}, /* L420 */
{5.8682269951850978e+00, 2.7428059823364492e-13,
	2.2204460492503131e-16, 1.6209256159527285e-14,
	3.5749181392930041e-14}, /* L421 */
{5.6795565438470428e+00, 2.6609270342703439e-13,
	2.2204460492503131e-16, -1.9684254226604025e-13,
	1.4521717162097048e-13}, /* L422 */
{3.9988561098035849e+00, 1.8779422461534523e-13,
	2.2204460492503131e-16, 2.2715163083830703e-13,
	1.5099033134902129e-14}, /* L423 */
{4.7016957903000263e+00, 2.2132295995902496e-13,
	2.2204460492503131e-16, 6.8389738316909643e-14,
	5.1514348342607263e-14}, /* L424 */
{4.9633561662689969e+00, 2.3419113870382091e-13,
	2.2204460492503131e-16, 3.7747582837255322e-15,
	-1.5543122344752192e-14}, /* L425 */
{3.8627129006434746e+00, 1.8268719870206951e-13,
	2.2204460492503131e-16, -2.7866597918091429e-14,
	-4.6740389336719090e-14}, /* L426 */
{4.6888620547007314e+00, 2.2228052731776415e-13,
	2.2204460492503131e-16, -3.5527136788005009e-15,
	-2.4424906541753444e-14}, /* L427 */
{4.2652275995602578e+00, 2.0267121314532233e-13,
	2.2204460492503131e-16, 4.6407322429331543e-14,
	-8.1046280797636427e-14}, /* L428 */
{5.0105373032567080e+00, 2.3864243914317740e-13,
	2.2204460492503131e-16, -3.8802294710649221e-13,
	3.9745984281580604e-14}, /* L429 */
{4.1128299277090949e+00, 1.9634294190495893e-13,
	2.2204460492503131e-16, -6.5281113847959205e-14,
	1.1102230246251565e-13}, /* L430 */
{4.6961004779885007e+00, 2.2470914018413168e-13,
	2.2204460492503131e-16, -5.2069459854919842e-14,
	-6.9166894434147252e-14}, /* L431 */
{3.9988807357282870e+00, 1.9179102750399579e-13,
	2.2204460492503131e-16, 1.1102230246251565e-14,
	-1.6875389974302379e-14}, /* L432 */
{5.4902822331073837e+00, 2.6392993693336031e-13,
	2.2204460492503131e-16, -4.7462034302725442e-13,
	3.5860203695392556e-13}, /* L433 */
{5.2051187732038846e+00, 2.5079938126282286e-13,
	2.2204460492503131e-16, 2.9976021664879227e-14,
	2.2826185386293218e-13}, /* L434 */
{5.8701709348763282e+00, 2.8349544933803372e-13,
	2.2204460492503131e-16, -1.0291767438275201e-13,
	-6.2394533983933798e-14}, /* L435 */
{5.7400203472427505e+00, 2.7784718970025324e-13,
	2.2204460492503131e-16, 3.8635761256955448e-13,
	6.0174087934683484e-14}, /* L436 */
{6.3956559703342561e+00, 3.1029345759492344e-13,
	2.2204460492503131e-16, 1.8873791418627661e-13,
	-1.8141044222375058e-13}, /* L437 */
{5.9812214351582371e+00, 2.9085067687617538e-13,
	2.2204460492503131e-16, -3.6481928589182644e-13,
	-7.7604589421298442e-14}, /* L438 */
{5.4658835711519105e+00, 2.6639801475880631e-13,
	2.2204460492503131e-16, -3.2751579226442118e-14,
	-8.8817841970012523e-14}, /* L439 */
{3.7221945948830260e+00, 1.8182677585798501e-13,
	2.2204460492503131e-16, -4.2488235152404741e-13,
	2.4424906541753444e-14}, /* L440 */
{4.9609316733542528e+00, 2.4288904221236862e-13,
	2.2204460492503131e-16, -2.5202062658991053e-14,
	-1.5043521983670871e-13}, /* L441 */
{5.5639670987881980e+00, 2.7303159733094162e-13,
	2.2204460492503131e-16, 2.0206059048177849e-14,
	2.0428103653102880e-14}, /* L442 */
{5.2077246172031204e+00, 2.5612845178102361e-13,
	2.2204460492503131e-16, -1.3544720900426910e-14,
	3.8635761256955448e-14}, /* L443 */
{5.0495977148891908e+00, 2.4891200212096010e-13,
	2.2204460492503131e-16, 1.3278267374516872e-13,
	-8.1601392309949006e-14}, /* L444 */
{4.8742037957345268e+00, 2.4080737404119645e-13,
	2.2204460492503131e-16, 2.6201263381153694e-14,
	-5.8841820305133297e-15}, /* L445 */
{5.2870459459341737e+00, 2.6179058920661191e-13,
	2.2204460492503131e-16, -1.9984014443252818e-15,
	8.9039886574937555e-14}, /* L446 */
{4.4846624635429873e+00, 2.2255808307392044e-13,
	2.2204460492503131e-16, -9.2703622556200571e-14,
	3.9968028886505635e-14}, /* L447 */
{4.1663343832417468e+00, 2.0722312754628547e-13,
	2.2204460492503131e-16, 1.0214051826551440e-14,
	1.9984014443252818e-14}, /* L448 */
{4.0807738908624955e+00, 2.0342061368694431e-13,
	2.2204460492503131e-16, -5.3623772089395061e-14,
	-6.3726801613483985e-14}, /* L449 */
{5.8922784254429397e+00, 2.9437563497936026e-13,
	2.2204460492503131e-16, 1.5765166949677223e-14,
	1.0746958878371515e-13}, /* L450 */
{4.2101288499112783e+00, 2.1080359680070160e-13,
	2.2204460492503131e-16, -5.2291504459844873e-14,
	8.8151708155237429e-14}, /* L451 */
{4.9170822995881238e+00, 2.4674706722294104e-13,
	2.2204460492503131e-16, -5.0071058410594560e-14,
	-3.0642155479654321e-14}, /* L452 */
{5.6992817353981957e+00, 2.8663182938259979e-13,
	2.2204460492503131e-16, -4.2188474935755949e-15,
	-1.4765966227514582e-14}, /* L453 */
{4.3998217031750340e+00, 2.2176704916887502e-13,
	2.2204460492503131e-16, -6.8833827526759706e-15,
	1.3988810110276972e-14}, /* L454 */
{3.9555322351529418e+00, 1.9981238885691255e-13,
	2.2204460492503131e-16, -6.6613381477509392e-16,
	-3.9968028886505635e-15}, /* L455 */
{4.4364458255968806e+00, 2.2459811788166917e-13,
	2.2204460492503131e-16, 2.1516122217235534e-13,
	2.0428103653102880e-13}, /* L456 */
{5.7637311258744965e+00, 2.9243274468626623e-13,
	2.2204460492503131e-16, 5.5067062021407764e-14,
	-8.4932061383824475e-14}, /* L457 */
{6.2183999252689537e+00, 3.1619151741324458e-13,
	2.2204460492503131e-16, -5.6621374255882984e-14,
	-3.8857805861880479e-15}, /* L458 */
{6.4918919879658779e+00, 3.3081870576268102e-13,
	2.2204460492503131e-16, 4.3964831775156199e-14,
	5.3068660577082483e-14}, /* L459 */
{5.5163569653182405e+00, 2.8171909249863347e-13,
	2.2204460492503131e-16, -1.4741541320972829e-12,
	6.4370730967766576e-13}, /* L460 */
{4.6958148558768267e+00, 2.4033552925573076e-13,
	2.2204460492503131e-16, 3.0420110874729289e-14,
	-1.1768364061026659e-14}, /* L461 */
{5.5422606567947605e+00, 2.8427260545527133e-13,
	2.2204460492503131e-16, -7.5828232581898192e-14,
	3.0064839506849239e-13}, /* L462 */
{7.9186770438068130e+00, 4.0704245529710192e-13,
	2.2204460492503131e-16, 4.1744385725905886e-14,
	2.0206059048177849e-14}, /* L463 */
{4.3330154681851196e+00, 2.2321033910088772e-13,
	2.2204460492503131e-16, 6.5769611978794273e-13,
	7.6827433304060833e-13}, /* L464 */
{5.0817689023215564e+00, 2.6234570071892449e-13,
	2.2204460492503131e-16, 6.6613381477509392e-16,
	-1.8873791418627661e-15}, /* L465 */
{6.1062814204428140e+00, 3.1591396165708829e-13,
	2.2204460492503131e-16, -1.8873791418627661e-15,
	-7.3940853440035426e-14}, /* L466 */
{4.8565773734848285e+00, 2.5179858198498550e-13,
	2.2204460492503131e-16, -1.0536016503692736e-13,
	8.7485574340462335e-14}, /* L467 */
{5.9017656954216529e+00, 3.0664359940146824e-13,
	2.2204460492503131e-16, 1.5698553568199713e-13,
	-1.9739765377835283e-13}, /* L468 */
{5.5426967919935635e+00, 2.8860247525130944e-13,
	2.2204460492503131e-16, -2.5979218776228663e-14,
	-3.2196467714129540e-15}, /* L469 */
{4.7149385902403589e+00, 2.4602542225693469e-13,
	2.2204460492503131e-16, -1.0735856648125264e-13,
	9.5257135512838431e-14}, /* L470 */
{6.9780389588025447e+00, 3.6488867483086551e-13,
	2.2204460492503131e-16, 2.1691537455126308e-12,
	-6.7290617522530738e-13}, /* L471 */
{7.1300997897814780e+00, 3.7363168114978862e-13,
	2.2204460492503131e-16, 6.8389738316909643e-14,
	5.9285909514983359e-14}, /* L472 */
{6.0666540609903699e+00, 3.1857849691618867e-13,
	2.2204460492503131e-16, -4.2454928461665986e-13,
	3.1685765122801968e-13}, /* L473 */
{7.3562806105741236e+00, 3.8711742145203232e-13,
	2.2204460492503131e-16, -5.7398530373120593e-14,
	-1.0669243266647754e-13}, /* L474 */
{5.9968993063800600e+00, 3.1624702856447584e-13,
	2.2204460492503131e-16, -1.9728663147589032e-13,
	3.7059244561987725e-13}, /* L475 */
{6.5032132910670697e+00, 3.4366953727271721e-13,
	2.2204460492503131e-16, -1.1952661083114435e-12,
	2.2630786133959191e-12}, /* L476 */
{6.7832801108031822e+00, 3.5922306795832526e-13,
	2.2204460492503131e-16, -8.9483975784787617e-14,
	5.5511151231257827e-14}, /* L477 */
{5.2803850947349824e+00, 2.8022029141538951e-13,
	2.2204460492503131e-16, 1.9473311851925246e-13,
	-2.0772272790736679e-13}, /* L478 */
{4.8758293888716402e+00, 2.5929258740120531e-13,
	2.2204460492503131e-16, -2.2093438190040615e-14,
	1.2878587085651816e-14}, /* L479 */
{4.8417128491172807e+00, 2.5801583092288638e-13,
	2.2204460492503131e-16, -2.1094237467877974e-15,
	7.4162898044960457e-14}, /* L480 */
{6.1196009910661093e+00, 3.2679414729841483e-13,
	2.2204460492503131e-16, 4.0478731477833207e-13,
	-4.1344705437040830e-13}, /* L481 */
{4.9346943722537233e+00, 2.6406654640709348e-13,
	2.2204460492503131e-16, -1.1435297153639112e-14,
	-5.5955240441107890e-14}, /* L482 */
{5.8427058338898181e+00, 3.1330493754921918e-13,
	2.2204460492503131e-16, -2.2593038551121936e-13,
	5.1070259132757201e-14}, /* L483 */
{5.6539795500515018e+00, 3.0381253068867409e-13,
	2.2204460492503131e-16, 7.7937656328685989e-14,
	-2.4424906541753444e-14}, /* L484 */
{6.3052147811699006e+00, 3.3950620093037287e-13,
	2.2204460492503131e-16, 2.4424906541753444e-15,
	-4.6629367034256575e-14}, /* L485 */
{5.9905406795849077e+00, 3.2322755583180651e-13,
	2.2204460492503131e-16, 5.7731597280508140e-15,
	-2.2759572004815709e-14}, /* L486 */
{4.2125658487098612e+00, 2.2776225350185086e-13,
	2.2204460492503131e-16, 1.7386092565629951e-13,
	-1.0047518372857667e-13}, /* L487 */
{5.4908310625573691e+00, 2.9748425944831070e-13,
	2.2204460492503131e-16, 2.5024426975051028e-13,
	-3.2562841312255841e-13}, /* L488 */
{5.1012756521416138e+00, 2.7694513349274530e-13,
	2.2204460492503131e-16, 1.9251267247000214e-13,
	1.7963408538435033e-13}, /* L489 */
{4.9888230958546691e+00, 2.7139401836961952e-13,
	2.2204460492503131e-16, -3.0497826486453050e-13,
	-3.2107649872159527e-13}, /* L490 */
{4.3951539392620198e+00, 2.3958612871410878e-13,
	2.2204460492503131e-16, 4.2188474935755949e-15,
	1.3922196728799463e-13}, /* L491 */
{6.6284931036044803e+00, 3.6206454501197527e-13,
	2.2204460492503131e-16, -1.3917755836700962e-12,
	6.5702998597316764e-13}, /* L492 */
{5.9371763069329377e+00, 3.2496227930778332e-13,
	2.2204460492503131e-16, -4.5408121707168903e-14,
	4.7961634663806763e-14}, /* L493 */
{5.0091570913409829e+00, 2.7472468744349499e-13,
	2.2204460492503131e-16, 5.2269299999352370e-13,
	-7.3174799553044068e-13}, /* L494 */
{3.8909462045156582e+00, 2.1382895454280515e-13,
	2.2204460492503131e-16, -9.0816243414337805e-14,
	8.5709217501062085e-14}, /* L495 */
{4.6049456377668729e+00, 2.5357840827133771e-13,
	2.2204460492503131e-16, -3.2973623831367149e-14,
	-5.1403326040144748e-14}, /* L496 */
{7.3793460414674348e+00, 4.0717429428127616e-13,
	2.2204460492503131e-16, 8.9928064994637680e-14,
	2.4424906541753444e-15}, /* L497 */
{7.2026289428969541e+00, 3.9822312114523584e-13,
	2.2204460492503131e-16, -1.1524114995609125e-13,
	-3.3628655415895992e-13}, /* L498 */
{4.7064577179742040e+00, 2.6073587733321801e-13,
	2.2204460492503131e-16, 4.6629367034256575e-15,
	7.7715611723760958e-15}, /* L499 */
{5.8175554904793847e+00, 3.2293612228784241e-13,
	2.2204460492503131e-16, -1.3322676295501878e-13,
	9.4368957093138306e-14}, /* L500 */
{4.3124163832796452e+00, 2.3986368447026507e-13,
	2.2204460492503131e-16, 3.5682568011452531e-13,
	-2.3003821070233244e-13}, /* L501 */
{6.2236649418112178e+00, 3.4686142846851453e-13,
	2.2204460492503131e-16, 1.1546319456101628e-13,
	7.6161299489285739e-13}, /* L502 */
{4.5849716659338560e+00, 2.5604171560722477e-13,
	2.2204460492503131e-16, -1.0007550343971161e-12,
	1.9961809982760315e-13}, /* L503 */
{5.3819957803580101e+00, 3.0114799542957371e-13,
	2.2204460492503131e-16, -8.1823436914874037e-14,
	-3.8746783559417963e-14}, /* L504 */
{4.9626710985811560e+00, 2.7823576775887204e-13,
	2.2204460492503131e-16, -1.6542323066914832e-14,
	-2.3980817331903381e-14}, /* L505 */
{4.9852254169498611e+00, 2.8005375796169574e-13,
	2.2204460492503131e-16, 2.3403501359098300e-13,
	-1.7541523789077473e-14}, /* L506 */
{4.6546301967872390e+00, 2.6199875602372913e-13,
	2.2204460492503131e-16, 1.5165646516379638e-13,
	6.6835426082434424e-14}, /* L507 */
{5.2569399068437530e+00, 2.9648505872614805e-13,
	2.2204460492503131e-16, 6.6568972556524386e-13,
	-1.0703660180411134e-12}, /* L508 */
{5.0599696788202966e+00, 2.8593793999220907e-13,
	2.2204460492503131e-16, -6.9055872131684737e-14,
	7.7493567118835927e-14}, /* L509 */
{5.4588755986386763e+00, 3.0908609005564358e-13,
	2.2204460492503131e-16, -2.5890400934258651e-13,
	5.0182080713057076e-14}, /* L510 */
{7.5137702998815419e+00, 4.2627013030482885e-13,
	2.2204460492503131e-16, 3.1752378504279477e-14,
	-8.5598195198599569e-14}, /* L511 */
{5.7515197043496258e+00, 3.2693292517649297e-13,
	2.2204460492503131e-16, 8.8817841970012523e-16,
	1.2390088954816747e-13}, /* L512 */
{5.3109668377417059e+00, 3.0248026305912390e-13,
	2.2204460492503131e-16, -1.3078427230084344e-13,
	1.3100631690576847e-14}, /* L513 */
{8.3347098504314516e+00, 4.7561954374941706e-13,
	2.2204460492503131e-16, -1.9928503292021560e-13,
	2.0428103653102880e-14}, /* L514 */
{4.9697075974963569e+00, 2.8414770536500100e-13,
	2.2204460492503131e-16, -3.0753177782116836e-14,
	2.2204460492503131e-15}, /* L515 */
{6.7558783941152347e+00, 3.8702374638432957e-13,
	2.2204460492503131e-16, 1.4743761767022079e-13,
	-1.5343282200319663e-13}, /* L516 */
{5.1697978082638567e+00, 2.9673832835364067e-13,
	2.2204460492503131e-16, 2.4424906541753444e-14,
	-2.3181456754173269e-13}, /* L517 */
{5.8330207858098602e+00, 3.3545388689049105e-13,
	2.2204460492503131e-16, -3.6970426720017713e-14,
	8.4376949871511897e-15}, /* L518 */
{6.9951940806813111e+00, 4.0306646909016308e-13,
	2.2204460492503131e-16, -2.3536728122053319e-14,
	-1.3766765505351941e-14}, /* L519 */
{4.8105845127706477e+00, 2.7772228960998291e-13,
	2.2204460492503131e-16, 1.2878587085651816e-14,
	-5.4733995114020217e-14}, /* L520 */
{6.0983781434855482e+00, 3.5274561049902786e-13,
	2.2204460492503131e-16, -1.2988499165089706e-12,
	5.2136073236397351e-13}, /* L521 */
{4.9166744237375424e+00, 2.8493873927004643e-13,
	2.2204460492503131e-16, 7.2386541205560206e-14,
	1.4677148385544569e-13}, /* L522 */
{6.0353823710121270e+00, 3.5044189772293066e-13,
	2.2204460492503131e-16, -4.3742787170231168e-13,
	-5.0726089995123402e-13}, /* L523 */
{7.6040196304893746e+00, 4.4236836416189362e-13,
	2.2204460492503131e-16, -8.2345241736447861e-13,
	3.0286884111774270e-13}, /* L524 */
{5.7352471437763413e+00, 3.3428815271463463e-13,
	2.2204460492503131e-16, 1.3966605649784469e-13,
	1.2123635428906709e-13}, /* L525 */
{5.6330887352735486e+00, 3.2895908219643388e-13,
	2.2204460492503131e-16, 1.5543122344752192e-14,
	5.3512749786932545e-14}, /* L526 */
{5.0047517290455383e+00, 2.9282132274488504e-13,
	2.2204460492503131e-16, -1.3278267374516872e-13,
	-1.3633538742396922e-13}, /* L527 */
{6.4479268396057261e+00, 3.7797542873363454e-13,
	2.2204460492503131e-16, -7.9269923958236177e-14,
	-3.7303493627405260e-14}, /* L528 */
{4.7554422853043672e+00, 2.7929047963226594e-13,
	2.2204460492503131e-16, 1.2545520178264269e-13,
	6.7279515292284486e-14}, /* L529 */
{7.0207657936939389e+00, 4.1311398746302075e-13,
	2.2204460492503131e-16, -8.5487172896137054e-14,
	-1.0047518372857667e-13}, /* L530 */
{5.2208180297221620e+00, 3.0778157800170902e-13,
	2.2204460492503131e-16, 4.8021586707136521e-12,
	3.5007552412480436e-12}, /* L531 */
{7.2932445893095963e+00, 4.3076653355456074e-13,
	2.2204460492503131e-16, -1.9317880628477724e-14,
	-1.3555823130673161e-13}, /* L532 */
{4.4953166607724802e+00, 2.6600943670018751e-13,
	2.2204460492503131e-16, 4.3032244434471068e-13,
	2.0916601783937949e-13}, /* L533 */
{7.3173102337090583e+00, 4.3381270797837601e-13,
	2.2204460492503131e-16, -1.1046719095020308e-13,
	-2.4791280139879746e-13}, /* L534 */
{6.7958051143131240e+00, 4.0364933617809129e-13,
	2.2204460492503131e-16, -1.1546319456101628e-14,
	7.5051076464660582e-14}, /* L535 */
{6.8348988431670623e+00, 4.0673020507142610e-13,
	2.2204460492503131e-16, -5.2069459854919842e-14,
	-6.3504757008558954e-14}, /* L536 */
{7.1326928175160100e+00, 4.2524317400705058e-13,
	2.2204460492503131e-16, 1.2607692667643278e-12,
	-1.5206724768290769e-12}, /* L537 */
{5.8020537636069527e+00, 3.4655611713674261e-13,
	2.2204460492503131e-16, 1.1590728377086634e-13,
	7.3274719625260332e-14}, /* L538 */
{5.5904540891157524e+00, 3.3453795289517529e-13,
	2.2204460492503131e-16, 6.0396132539608516e-14,
	7.2608585810485238e-14}, /* L539 */
{5.5375087365670526e+00, 3.3198443993853743e-13,
	2.2204460492503131e-16, -2.5535129566378600e-14,
	3.3084646133829665e-14}, /* L540 */
{5.5785670268502638e+00, 3.3506530883187224e-13,
	2.2204460492503131e-16, -1.4321877017664519e-14,
	-3.2784885917180873e-13}, /* L541 */
{4.4271287559290471e+00, 2.6639801475880631e-13,
	2.2204460492503131e-16, 3.3306690738754696e-15,
	-9.6145313932538556e-14}, /* L542 */
{4.3361026053221225e+00, 2.6140201114799311e-13,
	2.2204460492503131e-16, 3.4952041261249178e-12,
	-3.2902569557791139e-12}, /* L543 */
{6.7867754133880798e+00, 4.0989434069160779e-13,
	2.2204460492503131e-16, -3.1863400806741993e-12,
	1.3513634655737405e-12}, /* L544 */
{4.8403746091693245e+00, 2.9287683389611630e-13,
	2.2204460492503131e-16, -9.5479180117763462e-15,
	-3.2895908219643388e-13}, /* L545 */
{5.1694220752481739e+00, 3.1336044870045043e-13,
	2.2204460492503131e-16, -4.2299497238218464e-14,
	9.3480778673438181e-14}, /* L546 */
{7.8501037928372215e+00, 4.7672976677404222e-13,
	2.2204460492503131e-16, 1.6675549829869851e-13,
	1.4166445794216997e-13}, /* L547 */
{5.9124180871872989e+00, 3.5971225997855072e-13,
	2.2204460492503131e-16, 3.6859404417555197e-14,
	1.0946799022804043e-13}, /* L548 */
{6.2488998862544776e+00, 3.8087762110894374e-13,
	2.2204460492503131e-16, 5.2402526762307389e-14,
	-8.5043083686286991e-14}, /* L549 */
{4.9372805168553153e+00, 3.0148106233696126e-13,
	2.2204460492503131e-16, -9.0039087297100195e-14,
	-3.9079850466805510e-14}, /* L550 */
{7.0245119900629867e+00, 4.2971182168116684e-13,
	2.2204460492503131e-16, 9.1260332624187868e-14,
	9.3036689463588118e-14}, /* L551 */
{4.8342467574573700e+00, 2.9626301412122302e-13,
	2.2204460492503131e-16, -1.1912693054227930e-13,
	3.9368508453208051e-13}, /* L552 */
{7.7079687612789165e+00, 4.7323256424647298e-13,
	2.2204460492503131e-16, -6.6835426082434424e-14,
	-9.5035090907913400e-14}, /* L553 */
{5.6173373823674746e+00, 3.4550140526334872e-13,
	2.2204460492503131e-16, -9.2814644858663087e-14,
	5.4178883601707639e-14}, /* L554 */
{5.8234326110914427e+00, 3.5882408155885059e-13,
	2.2204460492503131e-16, -3.4749980670767400e-13,
	-4.7417625381740436e-13}, /* L555 */
{8.7814886747606220e+00, 5.4206639177323268e-13,
	2.2204460492503131e-16, -6.9944050551384862e-15,
	2.1249668691325496e-13}, /* L556 */
{6.0781065374043051e+00, 3.7586600498684675e-13,
	2.2204460492503131e-16, -2.9254376698872875e-13,
	6.1062266354383610e-14}, /* L557 */
{5.1926605222452942e+00, 3.2168712138513911e-13,
	2.2204460492503131e-16, -1.7852386235972517e-13,
	2.5179858198498550e-13}, /* L558 */
{5.3902142286877179e+00, 3.3452407510736748e-13,
	2.2204460492503131e-16, 2.9976021664879227e-14,
	-4.9182879990894435e-14}, /* L559 */
{6.3218849740797296e+00, 3.9304670629292104e-13,
	2.2204460492503131e-16, -3.8002934132919108e-13,
	-8.4821039081361960e-14}, /* L560 */
{6.2923450433403856e+00, 3.9190872769268026e-13,
	2.2204460492503131e-16, 1.1701750679549150e-13,
	-1.8096635301390052e-13}, /* L561 */
{5.3211827724904852e+00, 3.3201219551415306e-13,
	2.2204460492503131e-16, 1.7763568394002505e-13,
	-2.8821389719269064e-13}, /* L562 */
{5.1563136413664887e+00, 3.2229774404868294e-13,
	2.2204460492503131e-16, -2.3969715101657130e-13,
	2.5557334026871104e-13}, /* L563 */
{6.9164005397024022e+00, 4.3308065467151380e-13,
	2.2204460492503131e-16, -2.9487523534044158e-13,
	-6.8389738316909643e-13}, /* L564 */
{6.5474660821762898e+00, 4.1070619127836494e-13,
	2.2204460492503131e-16, -2.0550228185811648e-13,
	-4.0178971261184415e-13}, /* L565 */
{5.9209457372623602e+00, 3.7206349112750559e-13,
	2.2204460492503131e-16, -1.7541523789077473e-14,
	6.8167693711984612e-14}, /* L566 */
{6.5926029937818518e+00, 4.1500136660488351e-13,
	2.2204460492503131e-16, 2.9487523534044158e-13,
	-8.3488771451811772e-14}, /* L567 */
{8.6569238693572377e+00, 5.4591053899599729e-13,
	2.2204460492503131e-16, -3.1419311596891930e-14,
	-1.0769163338864018e-13}, /* L568 */
{8.2205753598151468e+00, 5.1930681976841697e-13,
	2.2204460492503131e-16, 2.6956215037898801e-13,
	-1.9251267247000214e-13}, /* L569 */
{5.4280787393564784e+00, 3.4350300381902343e-13,
	2.2204460492503131e-16, 1.1746159600534156e-13,
	-1.1324274851176597e-13}, /* L570 */
{6.3888016733530666e+00, 4.0500935938325711e-13,
	2.2204460492503131e-16, -1.7097434579227411e-14,
	1.2367884494324244e-13}, /* L571 */
{6.7701155763631542e+00, 4.2993386628609187e-13,
	2.2204460492503131e-16, 1.0325074129013956e-13,
	3.6859404417555197e-14}, /* L572 */
{4.7793487271334687e+00, 3.0404151418750303e-13,
	2.2204460492503131e-16, -1.5620837956475953e-12,
	-3.9357406222961799e-13}, /* L573 */
{6.7238782041244392e+00, 4.2849057635407917e-13,
	2.2204460492503131e-16, 1.8673951274195133e-13,
	1.7585932710062480e-13}, /* L574 */
{5.6508784806491095e+00, 3.6073921627632899e-13,
	2.2204460492503131e-16, 4.2410519540680980e-14,
	8.6597395920762210e-15}, /* L575 */
{9.2014034059440135e+00, 5.8841820305133297e-13,
	2.2204460492503131e-16, 2.5512925105886097e-13,
	3.0087043967341742e-13}, /* L576 */
{5.0520010381648124e+00, 3.2363001167823313e-13,
	2.2204460492503131e-16, -2.8343993818680246e-13,
	-4.0045744498229396e-13}, /* L577 */
{7.3666854978796872e+00, 4.7272602499148775e-13,
	2.2204460492503131e-16, -1.2102541191438831e-12,
	-6.1606275636449936e-13}, /* L578 */
{5.7046722127352201e+00, 3.6670666503368921e-13,
	2.2204460492503131e-16, 3.6193270602780103e-14,
	1.1945999744966684e-13}, /* L579 */
{6.1241475931459428e+00, 3.9435121834685560e-13,
	2.2204460492503131e-16, -4.4408920985006262e-14,
	-1.2967404927621828e-13}, /* L580 */
{7.0361556793020208e+00, 4.5385917246676399e-13,
	2.2204460492503131e-16, -1.2023715356690445e-13,
	-3.4749980670767400e-14}, /* L581 */
{6.5438985868107347e+00, 4.2283320941804980e-13,
	2.2204460492503131e-16, 9.7921670771938807e-14,
	-1.3222756223285614e-13}, /* L582 */
{7.4942228013883874e+00, 4.8507031724653871e-13,
	2.2204460492503131e-16, 1.7608137170554983e-13,
	2.2803980925800715e-13}, /* L583 */
{7.4533508002780744e+00, 4.8325232704371501e-13,
	2.2204460492503131e-16, 8.5087492607271997e-13,
	1.3287149158713873e-12}, /* L584 */
{7.5396486474910454e+00, 4.8968468169263701e-13,
	2.2204460492503131e-16, -1.8807178037150152e-13,
	4.2144066014770942e-13}, /* L585 */
{7.5891757960216486e+00, 4.9374393462642274e-13,
	2.2204460492503131e-16, 1.3322676295501878e-15,
	1.3211653993039363e-13}, /* L586 */
{8.6499284681761086e+00, 5.6371574075342323e-13,
	2.2204460492503131e-16, -4.0301095793893182e-14,
	1.3122836151069350e-13}, /* L587 */
{7.0263716297740473e+00, 4.5868864262388342e-13,
	2.2204460492503131e-16, 5.3734794391857577e-14,
	-2.6645352591003757e-15}, /* L588 */
{7.1697905987563058e+00, 4.6884718329920361e-13,
	2.2204460492503131e-16, -1.7164047960704920e-13,
	5.9952043329758453e-14}, /* L589 */
{6.7330614702568390e+00, 4.4103609653234344e-13,
	2.2204460492503131e-16, -9.8587804586713901e-14,
	-7.9047879353311146e-14}, /* L590 */
{5.0772076719376891e+00, 3.3313629632658603e-13,
	2.2204460492503131e-16, -9.0705221111875289e-14,
	9.5701224722688494e-14}, /* L591 */
{5.2973056548945658e+00, 3.4816594052244909e-13,
	2.2204460492503131e-16, 2.9976021664879227e-14,
	4.4408920985006262e-15}, /* L592 */
{7.9696584422515322e+00, 5.2469140143784898e-13,
	2.2204460492503131e-16, 5.5511151231257827e-15,
	-6.7057470687359455e-14}, /* L593 */
{7.2693717383005367e+00, 4.7939430203314259e-13,
	2.2204460492503131e-16, 1.6653345369377348e-14,
	5.9507954119908391e-14}, /* L594 */
{6.6260608741476643e+00, 4.3770542745846797e-13,
	2.2204460492503131e-16, -4.3232084578903596e-13,
	-3.9113157157544265e-13}, /* L595 */
{7.4924614853196800e+00, 4.9577009164636365e-13,
	2.2204460492503131e-16, 7.1653794009307603e-13,
	-7.7438055967604669e-13}, /* L596 */
{8.3073832908340481e+00, 5.5061510906284639e-13,
	2.2204460492503131e-16, -1.7337242752546445e-12,
	-9.2392760109305527e-13}, /* L597 */
{6.8474188299759522e+00, 4.5460857300838597e-13,
	2.2204460492503131e-16, 9.2592600253738055e-14,
	7.1276318180935050e-14}, /* L598 */
{6.6068551649127851e+00, 4.3937076199540570e-13,
	2.2204460492503131e-16, 1.7452705947107461e-13,
	-2.6623148130511254e-13}, /* L599 */
{5.7943841415440849e+00, 3.8598291229874349e-13,
	2.2204460492503131e-16, 2.1194379584699163e-11,
	2.3312463071079037e-12}, /* L600 */
{7.3793793629617079e+00, 4.9238391142125693e-13,
	2.2204460492503131e-16, -7.4829031859735551e-14,
	1.4033219031261979e-13}, /* L601 */
{5.6079822696747463e+00, 3.7481129311345285e-13,
	2.2204460492503131e-16, -7.5495165674510645e-15,
	9.7277741417656216e-13}, /* L602 */
{5.6011696992360323e+00, 3.7497782656714662e-13,
	2.2204460492503131e-16, 1.9650947535865271e-12,
	-4.3345327327415362e-12}, /* L603 */
{8.2901620860081202e+00, 5.5591642400543151e-13,
	2.2204460492503131e-16, 2.9327651418498135e-12,
	-1.3200551762793111e-13}, /* L604 */
{5.8450505440887328e+00, 3.9260261708307098e-13,
	2.2204460492503131e-16, 2.3581137043038325e-13,
	-3.1175062531474396e-13}, /* L605 */
{7.0618923296561054e+00, 4.7511994338833574e-13,
	2.2204460492503131e-16, 3.1068481121110381e-12,
	-2.1924684290297591e-12}, /* L606 */
{6.5856776060858495e+00, 4.4381165409390633e-13,
	2.2204460492503131e-16, 1.5920598173124745e-13,
	4.7739590058881731e-14}, /* L607 */
{7.4070840546171866e+00, 4.9998893913993925e-13,
	2.2204460492503131e-16, -3.1086244689504383e-14,
	-4.9071857688431919e-14}, /* L608 */
{6.1239833892743363e+00, 4.1405767703395213e-13,
	2.2204460492503131e-16, -1.5232259897857148e-13,
	3.8635761256955448e-14}, /* L609 */
{6.5303381718135123e+00, 4.4225734185943111e-13,
	2.2204460492503131e-16, 3.0864200084579352e-14,
	2.2204460492503131e-14}, /* L610 */
{5.9310650039648740e+00, 4.0233094633634892e-13,
	2.2204460492503131e-16, 1.8696155734687636e-13,
	-6.5281113847959205e-14}, /* L611 */
{5.6560546752283836e+00, 3.8430369997399794e-13,
	2.2204460492503131e-16, -1.9440005161186491e-13,
	-1.7763568394002505e-15}, /* L612 */
{1.0236557748975780e+01, 6.9666494795228573e-13,
	2.2204460492503131e-16, 5.7331916991643084e-13,
	7.2897243796887778e-13}, /* L613 */
{8.6482221134177912e+00, 5.8952842607595812e-13,
	2.2204460492503131e-16, -1.6320278461989801e-14,
	3.8191672047105385e-14}, /* L614 */
{7.8032643437780260e+00, 5.3279602951761262e-13,
	2.2204460492503131e-16, 5.1603166184577276e-13,
	-2.9565239145767919e-13}, /* L615 */
{7.1018780877954510e+00, 4.8569481769789036e-13,
	2.2204460492503131e-16, 5.5333515547317802e-13,
	4.7761794519374234e-13}, /* L616 */
{7.7779701319708030e+00, 5.3279602951761262e-13,
	2.2204460492503131e-16, -4.3098857815948577e-13,
	-1.9484414082171497e-13}, /* L617 */
{6.7707428828944307e+00, 4.6455200797268503e-13,
	2.2204460492503131e-16, -2.3869795029440866e-14,
	1.3655743202889425e-13}, /* L618 */
{6.0416088856672232e+00, 4.1519565563419292e-13,
	2.2204460492503131e-16, 3.0397906414236786e-13,
	6.6080474425689317e-13}, /* L619 */
{6.4225907781135954e+00, 4.4209080840573733e-13,
	2.2204460492503131e-16, 8.5642604119584576e-13,
	1.2507772595427014e-12}, /* L620 */
{6.5773050630469632e+00, 4.5347059440814519e-13,
	2.2204460492503131e-16, -3.7014835641002719e-13,
	-2.8765878568037806e-13}, /* L621 */
{6.6953481831277335e+00, 4.6235237860514644e-13,
	2.2204460492503131e-16, -3.0169977627281241e-11,
	2.6100455130517730e-11}, /* L622 */
{5.1911448273359717e+00, 3.5905479978115551e-13,
	2.2204460492503131e-16, 8.7108098512089782e-13,
	-5.3523852017178797e-13}, /* L623 */
{6.1614680543235520e+00, 4.2685299739275706e-13,
	2.2204460492503131e-16, -6.6613381477509392e-15,
	1.7874590696465020e-13}, /* L624 */
{5.7187090224479169e+00, 3.9681452568274267e-13,
	2.2204460492503131e-16, -1.6653345369377348e-13,
	-2.0539125955565396e-14}, /* L625 */
{7.5676037924973532e+00, 5.2594734123445619e-13,
	2.2204460492503131e-16, -1.3411494137471891e-13,
	1.0147438445073931e-13}, /* L626 */
{6.4609352333051344e+00, 4.4975134727565091e-13,
	2.2204460492503131e-16, -3.9923619965520629e-13,
	2.3669954885008337e-13}, /* L627 */
{5.8503277014394026e+00, 4.0789593924728251e-13,
	2.2204460492503131e-16, 6.8833827526759706e-15,
	-1.2956302697375577e-13}, /* L628 */
{7.2327220628888975e+00, 5.0508208726540715e-13,
	2.2204460492503131e-16, -1.8729462425426391e-13,
	6.3060667798708891e-14}, /* L629 */
{6.8861219753515543e+00, 4.8164250365800854e-13,
	2.2204460492503131e-16, 1.6937562463681388e-12,
	1.2156942119645464e-12}, /* L630 */
{6.1283773391454526e+00, 4.2932324362254803e-13,
	2.2204460492503131e-16, -4.1833203567875898e-13,
	-4.9182879990894435e-14}, /* L631 */
{7.7291953431401188e+00, 5.4232660029462920e-13,
	2.2204460492503131e-16, -1.3478107518949400e-13,
	6.0174087934683484e-14}, /* L632 */
{5.7866402512666113e+00, 4.0666775502629093e-13,
	2.2204460492503131e-16, -1.7985612998927536e-14,
	-3.2862601528904634e-14}, /* L633 */
{1.0499030759977416e+01, 7.3900607855392764e-13,
	2.2204460492503131e-16, 1.9984014443252818e-13,
	7.6827433304060833e-14}, /* L634 */
{8.4905645767254967e+00, 5.9857674372665315e-13,
	2.2204460492503131e-16, 1.5987211554602254e-14,
	-2.5368596112684827e-13}, /* L635 */
{9.0853130761015439e+00, 6.4151461920403108e-13,
	2.2204460492503131e-16, 7.9047879353311146e-14,
	-6.8389738316909643e-14}, /* L636 */
{7.2260710552487275e+00, 5.1103565823495956e-13,
	2.2204460492503131e-16, -1.2645440250480533e-13,
	4.6784798257704097e-13}, /* L637 */
{6.0995394038308097e+00, 4.3204329003287967e-13,
	2.2204460492503131e-16, 6.1994853695068741e-13,
	2.3780977187470853e-13}, /* L638 */
{6.5750299352832959e+00, 4.6645326490235561e-13,
	2.2204460492503131e-16, 4.3098857815948577e-13,
	-9.7699626167013776e-15}, /* L639 */
{6.5437359100296488e+00, 4.6495966798953958e-13,
	2.2204460492503131e-16, -8.9817042692175164e-14,
	-6.1062266354383610e-14}, /* L640 */
{6.0606569878389926e+00, 4.3130776727906550e-13,
	2.2204460492503131e-16, -4.1078251911130792e-15,
	2.7533531010703882e-14}, /* L641 */
{8.4517267299685273e+00, 6.0240701316160994e-13,
	2.2204460492503131e-16, 9.7055696812731185e-13,
	1.7643664307342988e-12}, /* L642 */
{6.2900565801635153e+00, 4.4902970230964456e-13,
	2.2204460492503131e-16, 1.6253665080512292e-13,
	-2.9753977059954195e-14}, /* L643 */
{6.0773581907758221e+00, 4.3452047515657455e-13,
	2.2204460492503131e-16, 1.7097434579227411e-13,
	-7.5384143372048129e-14}, /* L644 */
{7.7069889035575114e+00, 5.5189186554116532e-13,
	2.2204460492503131e-16, -9.6811447747313650e-14,
	-2.9976021664879227e-15}, /* L645 */
{6.7335632551656612e+00, 4.8293313792413528e-13,
	2.2204460492503131e-16, 2.2204460492503131e-16,
	1.7230661342182430e-13}, /* L646 */
{9.4259229084370713e+00, 6.7707645046155562e-13,
	2.2204460492503131e-16, 3.7947422981687851e-13,
	-2.3803181647963356e-13}, /* L647 */
{6.6983130371100614e+00, 4.8189230383854920e-13,
	2.2204460492503131e-16, -2.8532731732866523e-14,
	3.1086244689504383e-15}, /* L648 */
{7.7958520530350359e+00, 5.6171733930909795e-13,
	2.2204460492503131e-16, 1.8496315590255108e-13,
	1.0214051826551440e-13}, /* L649 */
{7.0023187399134255e+00, 5.0531800965814000e-13,
	2.2204460492503131e-16, -1.9417800700693988e-13,
	-4.2144066014770942e-13}, /* L650 */
{5.9005469437386679e+00, 4.2646441933413826e-13,
	2.2204460492503131e-16, -6.4837024638109142e-14,
	4.5563552930616424e-13}, /* L651 */
{8.8922686306168384e+00, 6.4367955410205013e-13,
	2.2204460492503131e-16, 4.5119463720766362e-13,
	1.2922996006636822e-13}, /* L652 */
{6.9984796479817293e+00, 5.0737192225369654e-13,
	2.2204460492503131e-16, 1.5054624213917123e-13,
	-3.9857006584043120e-14}, /* L653 */
{5.8084954026368036e+00, 4.2174597147948134e-13,
	2.2204460492503131e-16, -8.2156503822261584e-15,
	8.9928064994637680e-14}, /* L654 */
{5.8606962693522844e+00, 4.2618686357798197e-13,
	2.2204460492503131e-16, -4.9649173661237000e-13,
	-2.3547830352299570e-13}, /* L655 */
{5.5228745671368511e+00, 4.0223380182169421e-13,
	2.2204460492503131e-16, 1.0902390101819037e-13,
	-9.7699626167013776e-14}, /* L656 */
{7.4376068637415207e+00, 5.4251048098308274e-13,
	2.2204460492503131e-16, 6.2172489379008766e-14,
	6.0618177144533547e-14}, /* L657 */
{6.6117125590043040e+00, 4.8300252686317435e-13,
	2.2204460492503131e-16, 1.4432899320127035e-13,
	8.2822637637036678e-14}, /* L658 */
{6.9233796635805414e+00, 5.0653925498522767e-13,
	2.2204460492503131e-16, -9.3036689463588118e-14,
	-1.3877787807814457e-14}, /* L659 */
{7.8170577875722520e+00, 5.7279181397973389e-13,
	2.2204460492503131e-16, -2.1660451210436804e-13,
	1.0902390101819037e-13}, /* L660 */
{8.5446428304138173e+00, 6.2705396430828841e-13,
	2.2204460492503131e-16, -8.9706020389712648e-14,
	-9.5923269327613525e-14}, /* L661 */
{6.1004627969488165e+00, 4.4836356849486947e-13,
	2.2204460492503131e-16, -1.4943601911454607e-13,
	-1.5543122344752192e-14}, /* L662 */
{8.4215819142241255e+00, 6.1989302579945615e-13,
	2.2204460492503131e-16, 8.4754425699884450e-13,
	7.0743411129114975e-13}, /* L663 */
{6.2628110856984094e+00, 4.6168624479037135e-13,
	2.2204460492503131e-16, -9.2148511043887993e-15,
	4.0190073491430667e-14}, /* L664 */
{7.3422108319780888e+00, 5.4207333066713659e-13,
	2.2204460492503131e-16, 9.4813046302988369e-14,
	6.0174087934683484e-14}, /* L665 */
{6.2239212309291796e+00, 4.6020132149493520e-13,
	2.2204460492503131e-16, -1.4954704141700859e-13,
	-5.6454840802189210e-13}, /* L666 */
{7.1293215928052787e+00, 5.2793880378487756e-13,
	2.2204460492503131e-16, 4.9604764740251994e-13,
	1.8962609260597674e-13}, /* L667 */
{7.9007422554708429e+00, 5.8594101792763809e-13,
	2.2204460492503131e-16, 1.8096635301390052e-13,
	-2.2015722578316854e-13}, /* L668 */
{5.5744202297784016e+00, 4.1403339090528846e-13,
	2.2204460492503131e-16, -2.1860291354869332e-13,
	-8.6264329013374663e-14}, /* L669 */
{5.5298594707635198e+00, 4.1133763062362050e-13,
	2.2204460492503131e-16, -7.6938455606523348e-14,
	-3.7359004778636518e-13}, /* L670 */
{8.0108174076235912e+00, 5.9677263131163727e-13,
	2.2204460492503131e-16, 2.3581137043038325e-13,
	-2.5732749264761878e-12}, /* L671 */
{7.0269828127116059e+00, 5.2426119001580673e-13,
	2.2204460492503131e-16, 7.7049477908985864e-14,
	-1.0302869668521453e-13}, /* L672 */
{8.6129407803702200e+00, 6.4354077622397199e-13,
	2.2204460492503131e-16, 3.6415315207705135e-13,
	-1.3722356584366935e-13}, /* L673 */
{8.5460075483744991e+00, 6.3948846218409017e-13,
	2.2204460492503131e-16, 1.4144241333724494e-13,
	-7.3496764230185363e-14}, /* L674 */
{6.7000105706516360e+00, 5.0209836288672705e-13,
	2.2204460492503131e-16, 6.9277916736609768e-14,
	1.0724754417879012e-13}, /* L675 */
{7.0488276890308095e+00, 5.2902127123388709e-13,
	2.2204460492503131e-16, 2.5091040356528538e-14,
	-2.6700863742235015e-13}, /* L676 */
{6.9328026661452666e+00, 5.2108317660781722e-13,
	2.2204460492503131e-16, 8.8151708155237429e-14,
	-8.7485574340462335e-14}, /* L677 */
{7.0951439374143641e+00, 5.3407278599593155e-13,
	2.2204460492503131e-16, 4.4408920985006262e-13,
	-5.5511151231257827e-14}, /* L678 */
{8.4204845663392245e+00, 6.3477001432943325e-13,
	2.2204460492503131e-16, -4.1189274213593308e-13,
	-5.7376325912628090e-13}, /* L679 */
{9.6331034335098256e+00, 7.2725159228070879e-13,
	2.2204460492503131e-16, -5.6732396558345499e-14,
	1.8207657603852567e-14}, /* L680 */
{8.9434796021111094e+00, 6.7618133314795159e-13,
	2.2204460492503131e-16, -3.4439118223872356e-13,
	6.1062266354383610e-14}, /* L681 */
{8.1081506221971527e+00, 6.1392557704209594e-13,
	2.2204460492503131e-16, 3.0087043967341742e-13,
	3.1175062531474396e-13}, /* L682 */
{6.9915922898306571e+00, 5.3015924983412788e-13,
	2.2204460492503131e-16, -3.4094949086238557e-13,
	1.7763568394002505e-14}, /* L683 */
{7.8587477789173938e+00, 5.9678650909944508e-13,
	2.2204460492503131e-16, 2.9198865547641617e-13,
	-1.3200551762793111e-13}, /* L684 */
{5.4576728441824622e+00, 4.1505687775611477e-13,
	2.2204460492503131e-16, 3.1130653610489389e-13,
	-1.6409096303959814e-13}, /* L685 */
{6.9690343187097543e+00, 5.3076987249767171e-13,
	2.2204460492503131e-16, -1.2079226507921703e-13,
	1.4233059175694507e-13}, /* L686 */
{6.4126738727756809e+00, 4.8910875349861271e-13,
	2.2204460492503131e-16, -1.3078427230084344e-13,
	1.7985612998927536e-14}, /* L687 */
{7.7438348919166877e+00, 5.9149907194466778e-13,
	2.2204460492503131e-16, -1.6853185513809876e-13,
	-5.0837112297585918e-13}, /* L688 */
{8.7460225069273996e+00, 6.6902039463911933e-13,
	2.2204460492503131e-16, -4.1144865292608301e-13,
	-2.3758772726978350e-14}, /* L689 */
{8.7283652200259443e+00, 6.6863875547440443e-13,
	2.2204460492503131e-16, 4.5428105721612155e-12,
	1.1601830607332886e-12}, /* L690 */
{9.2050615561653295e+00, 7.0617817149454254e-13,
	2.2204460492503131e-16, 9.2770235937678081e-13,
	3.4305891460917337e-13}, /* L691 */
{8.2188081258286392e+00, 6.3142893691470192e-13,
	2.2204460492503131e-16, -4.8516746176119341e-14,
	1.6475709685437323e-13}, /* L692 */
{7.9924368521490514e+00, 6.1492477776425858e-13,
	2.2204460492503131e-16, -1.3322676295501878e-14,
	7.3274719625260332e-14}, /* L693 */
{7.7374041381322156e+00, 5.9616200864809343e-13,
	2.2204460492503131e-16, 4.5901060730102472e-12,
	2.7537971902802383e-12}, /* L694 */
{7.7777101126509907e+00, 6.0013105596112837e-13,
	2.2204460492503131e-16, 6.8767214145282196e-13,
	-9.3591800975900696e-13}, /* L695 */
{6.9978558681507224e+00, 5.4073412414368249e-13,
	2.2204460492503131e-16, -8.3877349510430577e-13,
	9.5479180117763462e-14}, /* L696 */
{6.1832952647551380e+00, 4.7847836803782684e-13,
	2.2204460492503131e-16, 2.5979218776228663e-14,
	3.1086244689504383e-15}, /* L697 */
{6.2944225382050609e+00, 4.8777648586906253e-13,
	2.2204460492503131e-16, 7.2386541205560206e-14,
	3.1974423109204508e-14}, /* L698 */
{6.2618124544072487e+00, 4.8594461787843102e-13,
	2.2204460492503131e-16, 3.0953017926549364e-13,
	-4.4653170050423796e-13}, /* L699 */
{8.5525134933600828e+00, 6.6466276926746559e-13,
	2.2204460492503131e-16, -1.0214051826551440e-13,
	2.6534330288541241e-13}, /* L700 */
{1.0350943577539496e+01, 8.0557782666801359e-13,
	2.2204460492503131e-16, -3.3240077357277187e-13,
	-9.1260332624187868e-14}, /* L701 */
{5.5078434475941354e+00, 4.2926773247131678e-13,
	2.2204460492503131e-16, 8.0824236192711396e-14,
	5.2868820432649954e-13}, /* L702 */
{7.8349163441299137e+00, 6.1150390306963232e-13,
	2.2204460492503131e-16, 7.9714013168086240e-14,
	-3.5804692544161298e-13}, /* L703 */
{7.4936197772816788e+00, 5.8569815664100133e-13,
	2.2204460492503131e-16, 1.5076828674409626e-13,
	-1.4310774787418268e-13}, /* L704 */
{6.7546205858901578e+00, 5.2868820432649954e-13,
	2.2204460492503131e-16, -1.2312373343092986e-13,
	1.5387691121304670e-13}, /* L705 */
{7.5389637356321009e+00, 5.9091620485673957e-13,
	2.2204460492503131e-16, 3.1752378504279477e-14,
	-7.2608585810485238e-14}, /* L706 */
{8.6004378971111883e+00, 6.7507111012332643e-13,
	2.2204460492503131e-16, 1.8163248682867561e-13,
	7.9958262233503774e-13}, /* L707 */
{8.1666795512948696e+00, 6.4193095283826551e-13,
	2.2204460492503131e-16, 9.1038288019262836e-15,
	-6.5170091545496689e-14}, /* L708 */
{7.0249581919299278e+00, 5.5296739409627094e-13,
	2.2204460492503131e-16, -2.2204460492503131e-16,
	4.1966430330830917e-14}, /* L709 */
{6.2838127309141720e+00, 4.9532600243651359e-13,
	2.2204460492503131e-16, -3.6026737149086330e-13,
	-3.6848302187308946e-13}, /* L710 */
{7.7493089912493005e+00, 6.1170513099284562e-13,
	2.2204460492503131e-16, -6.9610983643997315e-14,
	-1.1876055694415300e-12}, /* L711 */
{7.7356161371159704e+00, 6.1148308638792059e-13,
	2.2204460492503131e-16, 1.1723955140041653e-13,
	-4.7262194158292914e-13}, /* L712 */
{8.2843749216477036e+00, 6.5578098507046434e-13,
	2.2204460492503131e-16, 1.2012613126444194e-13,
	-7.7826634026223473e-14}, /* L713 */
{5.5336221757895148e+00, 4.3864911702939935e-13,
	2.2204460492503131e-16, -4.8250292650209303e-13,
	1.2008172234345693e-12}, /* L714 */
{7.6115504703326300e+00, 6.0421112557662582e-13,
	2.2204460492503131e-16, -9.9920072216264089e-14,
	1.3744561044859438e-13}, /* L715 */
{8.4057395187759969e+00, 6.6818772737065046e-13,
	2.2204460492503131e-16, 8.0824236192711396e-14,
	8.3044682241961709e-14}, /* L716 */
{7.3961065084995274e+00, 5.8875126995872051e-13,
	2.2204460492503131e-16, 7.5051076464660582e-14,
	1.9095836023552692e-14}, /* L717 */
{6.5821830867037550e+00, 5.2469140143784898e-13,
	2.2204460492503131e-16, -3.1108449149996886e-13,
	2.2959412149248237e-13}, /* L718 */
{8.7976494851194857e+00, 7.0227157422664277e-13,
	2.2204460492503131e-16, -8.1379347705023974e-14,
	9.6811447747313650e-14}, /* L719 */
{8.4708466978478913e+00, 6.7712502271888297e-13,
	2.2204460492503131e-16, 3.1086244689504383e-14,
	3.3661962106634746e-13}, /* L720 */
{1.1503225499560960e+01, 9.2079815994239311e-13,
	2.2204460492503131e-16, 1.2334577803585489e-12,
	1.3737899706711687e-12}, /* L721 */
{5.4653825839906460e+00, 4.3809400551708677e-13,
	2.2204460492503131e-16, 8.4376949871511897e-14,
	7.1498362785860081e-14}, /* L722 */
{6.5083090233911456e+00, 5.2241544423736741e-13,
	2.2204460492503131e-16, 5.9952043329758453e-15,
	-1.5420997812043424e-13}, /* L723 */
{5.8280478689837913e+00, 4.6845860524058480e-13,
	2.2204460492503131e-16, -1.8507417820501360e-13,
	3.1086244689504383e-13}, /* L724 */
{7.3427702054282129e+00, 5.9102722715920208e-13,
	2.2204460492503131e-16, 1.8651746813702630e-14,
	6.5503158452884236e-14}, /* L725 */
{7.6088274314888045e+00, 6.1328719880293647e-13,
	2.2204460492503131e-16, -3.3750779948604759e-13,
	-8.3377749149349256e-14}, /* L726 */
{7.1224321449377488e+00, 5.7487348215090606e-13,
	2.2204460492503131e-16, -2.1094237467877974e-15,
	4.9116266609416925e-13}, /* L727 */
{8.0061939501100916e+00, 6.4709348990277249e-13,
	2.2204460492503131e-16, -1.9073631563060189e-13,
	2.3137047833188262e-13}, /* L728 */
{8.7458985721268974e+00, 7.0785044492538418e-13,
	2.2204460492503131e-16, 1.9340085088970227e-13,
	-9.1482377229112899e-14}, /* L729 */
{7.2287785281826453e+00, 5.8586469009469511e-13,
	2.2204460492503131e-16, 9.1926466438962962e-14,
	-1.0791367799356522e-13}, /* L730 */
{8.8379072404787671e+00, 7.1725958505908238e-13,
	2.2204460492503131e-16, 5.3557158707917552e-13,
	-2.9864999362416711e-13}, /* L731 */
{6.0538005347254558e+00, 4.9198145557483031e-13,
	2.2204460492503131e-16, 3.4749980670767400e-13,
	2.0650148258027912e-14}, /* L732 */
{6.8258549028931919e+00, 5.5548274313643731e-13,
	2.2204460492503131e-16, -5.9396931817445875e-14,
	-3.7159164634203989e-13}, /* L733 */
{6.4216722568547180e+00, 5.2330362265706754e-13,
	2.2204460492503131e-16, 1.1635137298071641e-13,
	-4.7462034302725442e-13}, /* L734 */
{1.0262601225346939e+01, 8.3744122747475558e-13,
	2.2204460492503131e-16, -6.0595972684041044e-13,
	-7.5539574595495651e-13}, /* L735 */
{1.0395226998437057e+01, 8.4941775835289945e-13,
	2.2204460492503131e-16, -3.6270986214503864e-13,
	2.5268676040468563e-13}, /* L736 */
{7.5413958872491786e+00, 6.1706195708666201e-13,
	2.2204460492503131e-16, 2.7533531010703882e-13,
	1.5099033134902129e-14}, /* L737 */
{7.2007227427401128e+00, 5.8998639307361600e-13,
	2.2204460492503131e-16, -1.5365486660812167e-13,
	-1.1457501614131615e-13}, /* L738 */
{9.0822200124200876e+00, 7.4515393855278944e-13,
	2.2204460492503131e-16, 2.4047430713380891e-13,
	4.6074255521943996e-13}, /* L739 */
{8.6040676287455984e+00, 7.0687899977883717e-13,
	2.2204460492503131e-16, 2.1938006966593093e-13,
	4.1722181265413383e-13}, /* L740 */
{6.9959624545842134e+00, 5.7553961596568115e-13,
	2.2204460492503131e-16, -4.9960036108132044e-15,
	5.4400928206632670e-14}, /* L741 */
{8.6270351742669185e+00, 7.1068151363817833e-13,
	2.2204460492503131e-16, 2.9776181520446698e-13,
	1.1879386363489175e-13}, /* L742 */
{7.6675760271790914e+00, 6.3249405712895168e-13,
	2.2204460492503131e-16, -8.4354745411019394e-13,
	1.2543299732215019e-12}, /* L743 */
{9.0858835804938423e+00, 7.5049818790140499e-13,
	2.2204460492503131e-16, -7.2164496600635175e-14,
	1.6076029396572267e-13}, /* L744 */
{9.7399482526783014e+00, 8.0560558224362921e-13,
	2.2204460492503131e-16, 1.7030821197749901e-13,
	-2.4980018054066022e-14}, /* L745 */
{8.5598325397587587e+00, 7.0894679016220152e-13,
	2.2204460492503131e-16, -4.9071857688431919e-14,
	9.1926466438962962e-14}, /* L746 */
{1.1687434771339559e+01, 9.6928021164899292e-13,
	2.2204460492503131e-16, 1.5543122344752192e-15,
	-4.3176573427672338e-13}, /* L747 */
{6.8028182194832372e+00, 5.6493698608051091e-13,
	2.2204460492503131e-16, 2.6201263381153694e-14,
	-1.7363888105137448e-13}, /* L748 */
{7.7927359261637479e+00, 6.4800942389808824e-13,
	2.2204460492503131e-16, -5.9507954119908391e-14,
	-4.6740389336719090e-14}, /* L749 */
{7.2618447903933889e+00, 6.0466909257428370e-13,
	2.2204460492503131e-16, -1.0158540675320182e-13,
	-2.3170354523927017e-13}, /* L750 */
{7.0465324222738541e+00, 5.8752308573772893e-13,
	2.2204460492503131e-16, -1.5143442055887135e-13,
	1.0103029524088925e-12}, /* L751 */
{7.4288681035552342e+00, 6.2022609270684370e-13,
	2.2204460492503131e-16, -2.6978419498391304e-14,
	-4.0523140398818214e-14}, /* L752 */
{6.0969551703366998e+00, 5.0970339060540937e-13,
	2.2204460492503131e-16, -1.4999113062685865e-13,
	1.7874590696465020e-13}, /* L753 */
{9.0424960303177233e+00, 7.5695352763638368e-13,
	2.2204460492503131e-16, -5.3479443096193791e-13,
	-3.5726976932437537e-13}, /* L754 */
{7.9940523473722598e+00, 6.7007510651251323e-13,
	2.2204460492503131e-16, 8.1934459217336553e-14,
	4.0412118096355698e-14}, /* L755 */
{6.6620475477928052e+00, 5.5916382635246009e-13,
	2.2204460492503131e-16, -7.5717210279435676e-14,
	4.7406523151494184e-13}, /* L756 */
{7.7549659999264753e+00, 6.5175642660619815e-13,
	2.2204460492503131e-16, -7.7715611723760958e-15,
	-4.7184478546569153e-14}, /* L757 */
{9.0560828894288310e+00, 7.6211259525393871e-13,
	2.2204460492503131e-16, -1.3322676295501878e-15,
	1.0680345496894006e-13}, /* L758 */
{6.3583763030377494e+00, 5.3579363168410055e-13,
	2.2204460492503131e-16, 1.7319479184152442e-13,
	-1.2244649738590851e-12}, /* L759 */
{8.3960658781100452e+00, 7.0843331201331239e-13,
	2.2204460492503131e-16, -1.8562928971732617e-13,
	1.8718360195180139e-13}, /* L760 */
{8.7283317733465964e+00, 7.3743788853164460e-13,
	2.2204460492503131e-16, 3.0087043967341742e-13,
	-6.1606275636449936e-13}, /* L761 */
{6.8687772411105019e+00, 5.8109073108880693e-13,
	2.2204460492503131e-16, -6.5214500466481695e-13,
	2.3758772726978350e-13}, /* L762 */
{8.3381520804556502e+00, 7.0632388826652459e-13,
	2.2204460492503131e-16, -4.9182879990894435e-14,
	-7.6161299489285739e-14}, /* L763 */
{7.9737118602828865e+00, 6.7633745826078950e-13,
	2.2204460492503131e-16, -1.6209256159527285e-13,
	1.8229862064345070e-13}, /* L764 */
{7.5882472660224449e+00, 6.4448446579490337e-13,
	2.2204460492503131e-16, 3.7614356074300304e-13,
	-1.7479351299698465e-12}, /* L765 */
{7.5969033042218879e+00, 6.4606306415804227e-13,
	2.2204460492503131e-16, 6.1373128801278654e-13,
	-2.4225066397320916e-13}, /* L766 */
{9.1678762634182505e+00, 7.8068107534079445e-13,
	2.2204460492503131e-16, -8.4598994476436928e-13,
	-5.0270898555027088e-13}, /* L767 */
{7.6718871039843828e+00, 6.5414340610914223e-13,
	2.2204460492503131e-16, 2.6867397195928788e-13,
	-6.4526162191214098e-13}, /* L768 */
{9.2566791036726297e+00, 7.9029838229160987e-13,
	2.2204460492503131e-16, -3.4727776210274897e-13,
	5.2402526762307389e-13}, /* L769 */
{8.4545587933612047e+00, 7.2275518903097691e-13,
	2.2204460492503131e-16, -1.2689849171465539e-13,
	-1.9506618542664000e-13}, /* L770 */
{7.7814649357450358e+00, 6.6607830362386267e-13,
	2.2204460492503131e-16, -9.6611607602881122e-13,
	4.4453329905991268e-13}, /* L771 */
{6.6179670474313426e+00, 5.6721988217489638e-13,
	2.2204460492503131e-16, 6.1062266354383610e-14,
	-8.8817841970012523e-15}, /* L772 */
{6.3903318802437727e+00, 5.4841894914225975e-13,
	2.2204460492503131e-16, -1.2414513861358500e-12,
	1.2274625760255731e-12}, /* L773 */
{7.0969104216449486e+00, 6.0984550742659849e-13,
	2.2204460492503131e-16, -1.0824674490095276e-13,
	5.5289106626332796e-14}, /* L774 */
{7.4942053720480040e+00, 6.4481753270229092e-13,
	2.2204460492503131e-16, 7.9047879353311146e-14,
	2.6867397195928788e-14}, /* L775 */
{7.1404751830966342e+00, 6.1517457794479924e-13,
	2.2204460492503131e-16, -7.1465056095121327e-13,
	-6.4170890823334048e-13}, /* L776 */
{6.7709244534465682e+00, 5.8408833325529486e-13,
	2.2204460492503131e-16, 2.9976021664879227e-14,
	-1.2334577803585489e-13}, /* L777 */
{6.9003964909081583e+00, 5.9602323077001529e-13,
	2.2204460492503131e-16, -5.9752203185325925e-13,
	1.5232259897857148e-13}, /* L778 */
{9.0038652966024024e+00, 7.7871042947208480e-13,
	2.2204460492503131e-16, 1.2856382625159313e-13,
	-9.4924068605450884e-14}, /* L779 */
{9.8480924604817446e+00, 8.5281781636581400e-13,
	2.2204460492503131e-16, 2.6756374893466273e-13,
	-7.6050277186823223e-14}, /* L780 */
{9.6677489276500168e+00, 8.3827389474322445e-13,
	2.2204460492503131e-16, -1.2589929099249275e-13,
	-2.5879298704012399e-13}, /* L781 */
{7.6934264602151936e+00, 6.6793792719010980e-13,
	2.2204460492503131e-16, -3.9168668308775523e-13,
	6.2416738444426301e-13}, /* L782 */
{8.2496937307983238e+00, 7.1714856275661987e-13,
	2.2204460492503131e-16, -1.3544720900426910e-14,
	-7.9714013168086240e-14}, /* L783 */
{7.9387880352840954e+00, 6.9100281052669743e-13,
	2.2204460492503131e-16, 3.8635761256955448e-14,
	-1.0214051826551440e-14}, /* L784 */
{9.0694410605034239e+00, 7.9042328238188020e-13,
	2.2204460492503131e-16, -4.3753889400477419e-13,
	8.7929663550312398e-14}, /* L785 */
{8.0280024877199399e+00, 7.0055072853847378e-13,
	2.2204460492503131e-16, 1.0369483049998962e-13,
	8.7929663550312398e-14}, /* L786 */
{7.5162126207708928e+00, 6.5672467464139572e-13,
	2.2204460492503131e-16, -3.2085445411667024e-14,
	-3.3195668436292181e-14}, /* L787 */
{7.6900105462848316e+00, 6.7276392790027728e-13,
	2.2204460492503131e-16, 3.2462921240039577e-13,
	-3.3506530883187224e-13}, /* L788 */
{8.9271370248006132e+00, 7.8198558739472901e-13,
	2.2204460492503131e-16, -7.0077277314339881e-13,
	1.9717560917342780e-13}, /* L789 */
{8.6107730789452379e+00, 7.5522921250126274e-13,
	2.2204460492503131e-16, -6.2283511681471282e-14,
	1.7541523789077473e-14}, /* L790 */
{9.3672714159779389e+00, 8.2261975009600974e-13,
	2.2204460492503131e-16, -1.9950707752514063e-13,
	-1.0680345496894006e-13}, /* L791 */
{1.1636381995105930e+01, 1.0231815394945443e-12,
	2.2204460492503131e-16, 7.9758422089071246e-13,
	-8.6264329013374663e-13}, /* L792 */
{8.6513377350153711e+00, 7.6166850604408864e-13,
	2.2204460492503131e-16, -3.4383607072641098e-13,
	-1.8651746813702630e-13}, /* L793 */
{8.4949756191999839e+00, 7.4884543010966809e-13,
	2.2204460492503131e-16, -2.1405099914773018e-13,
	4.6473935810809053e-13}, /* L794 */
{9.3371216494801264e+00, 8.2411855117925370e-13,
	2.2204460492503131e-16, -7.5495165674510645e-14,
	2.6512125828048738e-13}, /* L795 */
{7.7054141669061869e+00, 6.8095529215383976e-13,
	2.2204460492503131e-16, -2.8965718712470334e-13,
	4.5186077102243871e-13}, /* L796 */
{9.8544697507287324e+00, 8.7196916354059795e-13,
	2.2204460492503131e-16, -3.0864200084579352e-14,
	-1.2934098236883074e-13}, /* L797 */
{1.0341181728889325e+01, 9.1618379549629481e-13,
	2.2204460492503131e-16, -1.5987211554602254e-14,
	-1.4721557306529576e-13}, /* L798 */
{1.1460124463608130e+01, 1.0165895902858324e-12,
	2.2204460492503131e-16, -4.7056802898737260e-12,
	-4.7528647684202951e-13}, /* L799 */
{8.3106381117514339e+00, 7.3813177792203533e-13,
	2.2204460492503131e-16, -1.1424194923392861e-13,
	-1.5698553568199713e-13}, /* L800 */
{1.1316341199668525e+01, 1.0063477828836653e-12,
	2.2204460492503131e-16, -7.4940054162198066e-13,
	4.8161474808239291e-13}, /* L801 */
{1.0457934205284054e+01, 9.3117180632873442e-13,
	2.2204460492503131e-16, -8.7263529735537304e-14,
	1.2745360322696797e-13}, /* L802 */
{7.4234239162229985e+00, 6.6180394497905581e-13,
	2.2204460492503131e-16, -1.6986412276764895e-14,
	-7.0166095156309893e-14}, /* L803 */
{9.3289948179225330e+00, 8.3272277962009866e-13,
	2.2204460492503131e-16, 6.1062266354383610e-14,
	2.3758772726978350e-14}, /* L804 */
{9.4795180614745913e+00, 8.4721119009145696e-13,
	2.2204460492503131e-16, -7.8825834748386114e-14,
	-5.5622173533720343e-14}, /* L805 */
{1.1582369390209212e+01, 1.0364348268510071e-12,
	2.2204460492503131e-16, -7.2608585810485238e-14,
	1.5765166949677223e-14}, /* L806 */
{8.1790711445648014e+00, 7.3280270740383457e-13,
	2.2204460492503131e-16, 6.7412742055239505e-13,
	-8.4598994476436928e-14}, /* L807 */
{8.6791597327766912e+00, 7.7857165159400665e-13,
	2.2204460492503131e-16, -1.0658141036401503e-14,
	5.1070259132757201e-14}, /* L808 */
{1.1482249265191783e+01, 1.0313000453621157e-12,
	2.2204460492503131e-16, 1.3211653993039363e-13,
	3.1086244689504383e-15}, /* L809 */
{6.6429117151353250e+00, 5.9738325397518111e-13,
	2.2204460492503131e-16, 1.9984014443252818e-14,
	-3.8669067947694202e-13}, /* L810 */
{9.4815192747112285e+00, 8.5370599478551412e-13,
	2.2204460492503131e-16, 1.8118839761882555e-13,
	2.8244073746463982e-13}, /* L811 */
{8.2974268840057537e+00, 7.4801276284119922e-13,
	2.2204460492503131e-16, -9.5257135512838431e-14,
	2.9420910152566648e-13}, /* L812 */
{9.2247993018775283e+00, 8.3263951289325178e-13,
	2.2204460492503131e-16, 3.3972824553529790e-14,
	-3.4305891460917337e-14}, /* L813 */
{9.1501987115111945e+00, 8.2692186431643222e-13,
	2.2204460492503131e-16, 4.8316906031686813e-13,
	-4.2266190547479709e-13}, /* L814 */
{1.0571182322398188e+01, 9.5651264686580362e-13,
	2.2204460492503131e-16, 1.4321877017664519e-13,
	-3.4916514124461173e-13}, /* L815 */
{8.0995838572011785e+00, 7.3377415255038159e-13,
	2.2204460492503131e-16, 2.5845992013273644e-13,
	-8.0380146982861334e-14}, /* L816 */
{1.2937596911125187e+01, 1.1735057370287905e-12,
	2.2204460492503131e-16, -8.3488771451811772e-14,
	1.4876988529977098e-14}, /* L817 */
{9.3747091670684828e+00, 8.5137452643380129e-13,
	2.2204460492503131e-16, -1.6731060981101109e-13,
	1.6497914145929826e-13}, /* L818 */
{1.0133105120159168e+01, 9.2137408813641741e-13,
	2.2204460492503131e-16, -2.7977620220553945e-14,
	8.5487172896137054e-14}, /* L819 */
{9.6176981007353373e+00, 8.7557738837062971e-13,
	2.2204460492503131e-16, 2.6600943670018751e-13,
	-1.1779466291272911e-13}, /* L820 */
{7.5706574984819293e+00, 6.9005912095576605e-13,
	2.2204460492503131e-16, -1.0769163338864018e-14,
	5.0182080713057076e-14}, /* L821 */
{7.8771413815912839e+00, 7.1886940844478886e-13,
	2.2204460492503131e-16, 2.4336088699783431e-13,
	2.2515322939398175e-13}, /* L822 */
{8.9735864541618575e+00, 8.1992745926129373e-13,
	2.2204460492503131e-16, 4.9849013805669529e-13,
	2.6934010577406298e-13}, /* L823 */
{9.6201608088612041e+00, 8.8007379162036159e-13,
	2.2204460492503131e-16, 2.1249668691325496e-13,
	1.4144241333724494e-13}, /* L824 */
{7.5872846977823265e+00, 6.9494410226411674e-13,
	2.2204460492503131e-16, 3.1308289294429414e-14,
	-1.7885692926711272e-13}, /* L825 */
{8.7701409553574123e+00, 8.0425943682627121e-13,
	2.2204460492503131e-16, -8.9817042692175164e-14,
	-1.1102230246251565e-14}, /* L826 */
{9.0553961262370191e+00, 8.3142390541746103e-13,
	2.2204460492503131e-16, 7.7715611723760958e-14,
	-3.0953017926549364e-13}, /* L827 */
{9.3656548728269193e+00, 8.6095020002119327e-13,
	2.2204460492503131e-16, -6.0862426209951082e-13,
	-5.3068660577082483e-13}, /* L828 */
{8.7724052757155917e+00, 8.0738887797693337e-13,
	2.2204460492503131e-16, 1.8489654252107357e-12,
	-2.0968782266095332e-12}, /* L829 */
{8.3819409350819853e+00, 7.7238215823172141e-13,
	2.2204460492503131e-16, -7.1831429693247628e-14,
	1.1857181902996672e-13}, /* L830 */
{9.6928552443259086e+00, 8.9425689075994796e-13,
	2.2204460492503131e-16, 1.6131540547803525e-12,
	9.0438767585965252e-13}, /* L831 */
{6.9979076752612190e+00, 6.4639960051238177e-13,
	2.2204460492503131e-16, 2.6134649999676185e-13,
	2.1516122217235534e-13}, /* L832 */
{7.5765425658090262e+00, 7.0068950641655192e-13,
	2.2204460492503131e-16, 1.6231460620019789e-13,
	2.3558932582545822e-13}, /* L833 */
{9.3100416668638211e+00, 8.6203960636410670e-13,
	2.2204460492503131e-16, -2.0347057372305244e-12,
	4.3063330679160572e-12}, /* L834 */
{1.2552115611940454e+01, 1.1636247521096266e-12,
	2.2204460492503131e-16, 2.5579538487363607e-13,
	-1.7341683644644945e-13}, /* L835 */
{7.3474996304779925e+00, 6.8195449287600240e-13,
	2.2204460492503131e-16, 2.3536728122053319e-14,
	6.7945649107059580e-14}, /* L836 */
{1.3074692073667933e+01, 1.2149725669985401e-12,
	2.2204460492503131e-16, 9.6811447747313650e-14,
	1.8385293287792592e-13}, /* L837 */
{6.9516816121039309e+00, 6.4676042299538494e-13,
	2.2204460492503131e-16, -3.5749181392930041e-14,
	-5.8730798002670781e-14}, /* L838 */
{9.6113083700242505e+00, 8.9526996926991842e-13,
	2.2204460492503131e-16, -8.0491169285323849e-14,
	-1.2811973704174306e-13}, /* L839 */
{1.1201208148413031e+01, 1.0446088438698098e-12,
	2.2204460492503131e-16, -4.7672976677404222e-13,
	2.1938006966593093e-13}, /* L840 */
{9.3466259234016533e+00, 8.7269080850660430e-13,
	2.2204460492503131e-16, -6.1417537722263660e-13,
	4.3010039973978564e-13}, /* L841 */
{8.6829115613024843e+00, 8.1168405330345195e-13,
	2.2204460492503131e-16, 1.5476508963274682e-13,
	-5.0293103015519591e-14}, /* L842 */
{7.8339388127985128e+00, 7.3319128546245338e-13,
	2.2204460492503131e-16, 3.7014835641002719e-13,
	-5.4756199574512721e-13}, /* L843 */
{8.0438515534001027e+00, 7.5373041141801878e-13,
	2.2204460492503131e-16, 2.3092638912203256e-13,
	-3.2196467714129540e-14}, /* L844 */
{7.7745684790091882e+00, 7.2936101602749659e-13,
	2.2204460492503131e-16, 3.8857805861880479e-14,
	-1.1968204205459188e-13}, /* L845 */
{9.1867757233528238e+00, 8.6286533473867166e-13,
	2.2204460492503131e-16, 1.3256062914024369e-13,
	3.9968028886505635e-15}, /* L846 */
{7.3208498028103328e+00, 6.8842154199444394e-13,
	2.2204460492503131e-16, 2.1316282072803006e-14,
	4.7961634663806763e-14}, /* L847 */
{9.3156102161628223e+00, 8.7703455609045022e-13,
	2.2204460492503131e-16, -5.5067062021407764e-13,
	-4.8749893011290624e-13}, /* L848 */
{8.6384117443105168e+00, 8.1423756626008981e-13,
	2.2204460492503131e-16, -1.1979306435705439e-13,
	-1.9528823003156504e-13}, /* L849 */
{8.6311900880780392e+00, 8.1451512201624610e-13,
	2.2204460492503131e-16, -7.6494366396673286e-14,
	-7.2386541205560206e-14}, /* L850 */
{9.4524238437647128e+00, 8.9306340100847592e-13,
	2.2204460492503131e-16, 3.5345060211966484e-12,
	-2.3018253969553371e-12}, /* L851 */
{1.0380884922594200e+01, 9.8193675412971970e-13,
	2.2204460492503131e-16, -3.0919711235810610e-13,
	-1.5487611193520934e-13}, /* L852 */
{7.7922162797596206e+00, 7.3793748889272592e-13,
	2.2204460492503131e-16, 8.5331741672689532e-13,
	-4.5508041779385167e-13}, /* L853 */
{7.9159960956777988e+00, 7.5053852022222145e-13,
	2.2204460492503131e-16, -2.1360690993788012e-13,
	-4.1855408028368402e-14}, /* L854 */
{9.3924124791664294e+00, 8.9156459992523196e-13,
	2.2204460492503131e-16, 1.0347278589506459e-12,
	6.9380057254875283e-12}, /* L855 */
{1.0174081472279928e+01, 9.6689323214604883e-13,
	2.2204460492503131e-16, 1.2545520178264269e-13,
	-8.8040685852774914e-14}, /* L856 */
{9.4755108655652815e+00, 9.0155660714685837e-13,
	2.2204460492503131e-16, -1.2656542480726785e-14,
	5.1514348342607263e-14}, /* L857 */
{1.0995646718379708e+01, 1.0474121570069883e-12,
	2.2204460492503131e-16, 2.8359536941024999e-12,
	7.0328187717905166e-12}, /* L858 */
{7.0884861544324318e+00, 6.7601479969425782e-13,
	2.2204460492503131e-16, 3.2063240951174521e-13,
	-4.4664272280670048e-13}, /* L859 */
{1.1190715329791459e+01, 1.0684786388992507e-12,
	2.2204460492503131e-16, -6.4894756235389650e-12,
	-1.3474776849875525e-12}, /* L860 */
{9.2468206282597958e+00, 8.8390406105531838e-13,
	2.2204460492503131e-16, -8.8928864272475039e-14,
	9.0150109599562711e-14}, /* L861 */
{1.0117185335504043e+01, 9.6822549977559902e-13,
	2.2204460492503131e-16, 7.9491968563161208e-14,
	9.3924867883288243e-14}, /* L862 */
{1.0208011470247856e+01, 9.7805097354353165e-13,
	2.2204460492503131e-16, -1.3422596367718143e-13,
	-1.6153745008296028e-13}, /* L863 */
{9.9809185247304129e+00, 9.5740082528550374e-13,
	2.2204460492503131e-16, 2.0472512574087887e-13,
	-3.3184566206045929e-13}, /* L864 */
{8.9398984976029592e+00, 8.5853546494263355e-13,
	2.2204460492503131e-16, 3.1086244689504383e-14,
	-1.6853185513809876e-13}, /* L865 */
{9.7477059101764763e+00, 9.3719476623732589e-13,
	2.2204460492503131e-16, -2.5213164889237305e-13,
	-8.4265927569049381e-13}, /* L866 */
{9.3483423152636096e+00, 8.9983576145868938e-13,
	2.2204460492503131e-16, 1.9095836023552692e-13,
	-2.3092638912203256e-14}, /* L867 */
{7.4683297551855281e+00, 7.1970207571325773e-13,
	2.2204460492503131e-16, 1.5321077739827160e-13,
	-1.4310774787418268e-13}, /* L868 */
{8.6553646337650854e+00, 8.3505424797181149e-13,
	2.2204460492503131e-16, 6.2172489379008766e-14,
	3.3750779948604759e-14}, /* L869 */
{8.3734327509362476e+00, 8.0878359565161873e-13,
	2.2204460492503131e-16, 1.7088552795030409e-12,
	-2.3353541322990168e-12}, /* L870 */
{1.1551395951467281e+01, 1.1170231406509856e-12,
	2.2204460492503131e-16, -5.6177285046032921e-14,
	-1.8285373215576328e-13}, /* L871 */
{6.8655498226503484e+00, 6.6466276926746559e-13,
	2.2204460492503131e-16, 2.9976021664879227e-13,
	4.5963233219481481e-14}, /* L872 */
{1.0369432167485062e+01, 1.0050293930419230e-12,
	2.2204460492503131e-16, -1.8984813721090177e-14,
	-5.1181281435219717e-14}, /* L873 */
{8.6479684494530975e+00, 8.3914125648121285e-13,
	2.2204460492503131e-16, -1.1690648449302898e-13,
	-2.8643754035329039e-14}, /* L874 */
{9.3988719714651765e+00, 9.1304741545172874e-13,
	2.2204460492503131e-16, 1.7013057629355899e-12,
	1.4468426456915040e-12}, /* L875 */
{8.4763261585318315e+00, 8.2436835135979436e-13,
	2.2204460492503131e-16, 8.4021678503631847e-13,
	2.2051249715104859e-12}, /* L876 */
{9.3814287121972892e+00, 9.1343599351034754e-13,
	2.2204460492503131e-16, -1.6531220836668581e-13,
	7.0987660194532509e-13}, /* L877 */
{8.5948313277667729e+00, 8.3780204995775875e-13,
	2.2204460492503131e-16, -7.0443650912466182e-13,
	-1.0113021531310551e-12}, /* L878 */
{1.0610084998985544e+01, 1.0354217483410366e-12,
	2.2204460492503131e-16, -2.3880897259687117e-13,
	4.3298697960381105e-14}, /* L879 */
{1.0010527157235810e+01, 9.7802321796791603e-13,
	2.2204460492503131e-16, -3.0967450825869491e-12,
	-1.2501111257279263e-12}, /* L880 */
{7.6895694530491729e+00, 7.5212058803231230e-13,
	2.2204460492503131e-16, -7.1220807029703792e-13,
	-2.2426505097428162e-13}, /* L881 */
{8.3095369195311957e+00, 8.1368245474777723e-13,
	2.2204460492503131e-16, 8.7929663550312398e-14,
	2.4691360067663481e-13}, /* L882 */
{9.8895965768349257e+00, 9.6950225625391795e-13,
	2.2204460492503131e-16, -6.0729199446996063e-14,
	-2.6789681584205027e-13}, /* L883 */
{8.6442444073142859e+00, 8.4837692426731337e-13,
	2.2204460492503131e-16, 7.5495165674510645e-14,
	3.7081449022480228e-13}, /* L884 */
{9.6960604952784930e+00, 9.5268237743084683e-13,
	2.2204460492503131e-16, -5.0504045390198371e-13,
	9.7699626167013776e-14}, /* L885 */
{1.1052006714471835e+01, 1.0871373246068572e-12,
	2.2204460492503131e-16, -1.3411494137471891e-13,
	2.4225066397320916e-13}, /* L886 */
{1.0251425418372760e+01, 1.0095257962916548e-12,
	2.2204460492503131e-16, 1.0167422459517184e-12,
	2.0472512574087887e-13}, /* L887 */
{1.1583351608466337e+01, 1.1419754031294360e-12,
	2.2204460492503131e-16, 2.0516921495072893e-13,
	-2.3103741142449508e-13}, /* L888 */
{1.1014640549975708e+01, 1.0871303857129533e-12,
	2.2204460492503131e-16, -6.7945649107059580e-14,
	-1.5387691121304670e-13}, /* L889 */
{9.7702401336730880e+00, 9.6539443106280487e-13,
	2.2204460492503131e-16, 1.8829382497642655e-13,
	-2.0106138975961585e-13}, /* L890 */
{1.0715785705451658e+01, 1.0600131883364838e-12,
	2.2204460492503131e-16, -2.9620750296999176e-13,
	9.5101704289390909e-13}, /* L891 */
{7.6076353210017702e+00, 7.5339734451063123e-13,
	2.2204460492503131e-16, 3.8569147875477938e-13,
	-1.8440804439023850e-13}, /* L892 */
{8.3379190898436502e+00, 8.2664430856027593e-13,
	2.2204460492503131e-16, -7.1609385088322597e-14,
	3.1086244689504383e-15}, /* L893 */
{8.7883597826723321e+00, 8.7227794431932182e-13,
	2.2204460492503131e-16, 3.1530333899354446e-13,
	-1.1468603844377867e-12}, /* L894 */
{7.8765487397153047e+00, 7.8265172120950410e-13,
	2.2204460492503131e-16, -2.1834756225302954e-12,
	9.0549789888427767e-13}, /* L895 */
{7.3091633174309161e+00, 7.2708505882701502e-13,
	2.2204460492503131e-16, -2.8410607200157756e-13,
	-1.5332179970073412e-13}, /* L896 */
{1.6333359102583998e+01, 1.6265877533783168e-12,
	2.2204460492503131e-16, -1.4244161405940758e-13,
	-3.3328895199247199e-13}, /* L897 */
{9.1506269091671584e+00, 9.1229801491010676e-13,
	2.2204460492503131e-16, -4.4297898682543746e-14,
	3.1086244689504383e-14}, /* L898 */
{9.5895590672040569e+00, 9.5712326952934745e-13,
	2.2204460492503131e-16, -5.4023452378260117e-13,
	-1.0524914273446484e-13}, /* L899 */
{1.0686127970684332e+01, 1.0677569939332443e-12,
	2.2204460492503131e-16, 9.5701224722688494e-14,
	6.7723604502134549e-14}, /* L900 */
{1.2051073397037014e+01, 1.2054801601379950e-12,
	2.2204460492503131e-16, 1.4588330543574557e-12,
	1.1164402735630574e-12}, /* L901 */
{8.2533389636897816e+00, 8.2650553068219779e-13,
	2.2204460492503131e-16, -3.3639757646142243e-14,
	3.4794389591752406e-13}, /* L902 */
{1.0995587668965866e+01, 1.1023404411503179e-12,
	2.2204460492503131e-16, 1.1968204205459188e-13,
	-1.2922996006636822e-13}, /* L903 */
{1.1445814518305125e+01, 1.1487477635796495e-12,
	2.2204460492503131e-16, 8.8906659811982536e-13,
	2.1604940059205546e-13}, /* L904 */
{1.0947703736355882e+01, 1.0999708088821336e-12,
	2.2204460492503131e-16, 9.6367358537463588e-14,
	1.0147438445073931e-13}, /* L905 */
{1.1483461826144907e+01, 1.1550760348200129e-12,
	2.2204460492503131e-16, -5.7731597280508140e-14,
	-8.8373752760162461e-14}, /* L906 */
{1.0890590500790017e+01, 1.0966505481491140e-12,
	2.2204460492503131e-16, 1.0969003483296547e-13,
	3.6792791036077688e-13}, /* L907 */
{1.1563894896316020e+01, 1.1657341758564144e-12,
	2.2204460492503131e-16, -9.9742436532324064e-13,
	2.8526070394718772e-12}, /* L908 */
{9.2915438122499463e+00, 9.3769436659840721e-13,
	2.2204460492503131e-16, -2.3425705819590803e-14,
	6.4614980033184111e-14}, /* L909 */
{9.9934223600767460e+00, 1.0096368185941174e-12,
	2.2204460492503131e-16, -4.4175774149834979e-13,
	-6.3349325785111432e-13}, /* L910 */
{8.4440308851593695e+00, 8.5403906169290167e-13,
	2.2204460492503131e-16, 7.0567995891224200e-12,
	5.3539395139523549e-12}, /* L911 */
{8.8489722943209141e+00, 8.9597773644811696e-13,
	2.2204460492503131e-16, 4.5785597535541456e-12,
	6.2172489379008766e-15}, /* L912 */
{9.0720296470633119e+00, 9.1956997572140153e-13,
	2.2204460492503131e-16, 1.1302070390684094e-13,
	4.7761794519374234e-13}, /* L913 */
{9.7401685399985833e+00, 9.8837604767254561e-13,
	2.2204460492503131e-16, 9.4591001698063337e-14,
	-3.2862601528904634e-14}, /* L914 */
{9.9557534121727329e+00, 1.0113576642822864e-12,
	2.2204460492503131e-16, 4.6074255521943996e-13,
	-1.2623235789988030e-13}, /* L915 */
{9.9339676377992436e+00, 1.0102474412576612e-12,
	2.2204460492503131e-16, -3.8113956435381624e-13,
	4.3411940708892871e-12}, /* L916 */
{9.8583852373942786e+00, 1.0036554920489493e-12,
	2.2204460492503131e-16, 8.7707618945387367e-14,
	1.6520118606422329e-13}, /* L917 */
{6.9150435895278655e+00, 7.0476957603204937e-13,
	2.2204460492503131e-16, 3.7541081354675043e-12,
	9.8039354412549073e-12}, /* L918 */
{9.1409284586791273e+00, 9.3264285183636275e-13,
	2.2204460492503131e-16, -3.5293989952833726e-13,
	6.0329519158131006e-13}, /* L919 */
{8.2440347457951333e+00, 8.4204865302694998e-13,
	2.2204460492503131e-16, -1.9317880628477724e-14,
	5.9219296133505850e-13}, /* L920 */
{8.7665719200691949e+00, 8.9639407008235139e-13,
	2.2204460492503131e-16, 7.6805228843568329e-13,
	-1.5285550603039155e-12}, /* L921 */
{1.3183046829353204e+01, 1.3494483308562621e-12,
	2.2204460492503131e-16, -1.7175150190951172e-13,
	-2.4069635173873394e-13}, /* L922 */
{7.8840861115702161e+00, 8.0790929501972641e-13,
	2.2204460492503131e-16, 4.6296300126869028e-13,
	8.7574392182432348e-13}, /* L923 */
{1.0159648063539786e+01, 1.0422218643668657e-12,
	2.2204460492503131e-16, 1.7035262089848402e-12,
	1.9646506643766770e-12}, /* L924 */
{9.3373627045941827e+00, 9.5890483053917563e-13,
	2.2204460492503131e-16, -1.4432899320127035e-15,
	3.0908609005564358e-13}, /* L925 */
{1.1461141192473828e+01, 1.1782796960346786e-12,
	2.2204460492503131e-16, -2.9198865547641617e-14,
	-1.6209256159527285e-14}, /* L926 */
{8.1553526725774024e+00, 8.3932860661661834e-13,
	2.2204460492503131e-16, 2.7600144392181392e-13,
	-1.5198953207118393e-13}, /* L927 */
{1.1797432405991961e+01, 1.2154721673596214e-12,
	2.2204460492503131e-16, 4.4408920985006262e-16,
	2.7378099787256360e-13}, /* L928 */
{1.2446601983679299e+01, 1.2837370055862607e-12,
	2.2204460492503131e-16, 1.2194689702482719e-12,
	-5.8930638147103309e-13}, /* L929 */
{1.0972597956641225e+01, 1.1329270854787410e-12,
	2.2204460492503131e-16, -6.4726002335646626e-14,
	-3.8413716652030416e-14}, /* L930 */
{8.4867212305868307e+00, 8.7720108954414400e-13,
	2.2204460492503131e-16, 2.1338486533295509e-13,
	1.6608936448392342e-13}, /* L931 */
{8.2976257519751879e+00, 8.5857709830605700e-13,
	2.2204460492503131e-16, -2.8654856265575290e-13,
	3.1539215683551447e-12}, /* L932 */
{8.4158760859262802e+00, 8.7174711893567292e-13,
	2.2204460492503131e-16, -3.3262281817769690e-13,
	-6.9277916736609768e-14}, /* L933 */
{7.8434277921854898e+00, 8.1332163226477405e-13,
	2.2204460492503131e-16, -3.5282887722587475e-13,
	1.7541523789077473e-14}, /* L934 */
{9.0887843929102257e+00, 9.4346752632645803e-13,
	2.2204460492503131e-16, -3.2751579226442118e-14,
	-2.2726265314076954e-13}, /* L935 */
{1.0544354242370568e+01, 1.0957346141537982e-12,
	2.2204460492503131e-16, -1.5971668432257502e-12,
	9.5525809484797719e-12}, /* L936 */
{1.2002153407532481e+01, 1.2485568134934510e-12,
	2.2204460492503131e-16, -2.7677860003905153e-13,
	1.9140244944537699e-13}, /* L937 */
{1.0679121326131190e+01, 1.1121104037670193e-12,
	2.2204460492503131e-16, 4.5630166312093934e-13,
	-9.1038288019262836e-15}, /* L938 */
{8.6105034677008874e+00, 8.9764307098505469e-13,
	2.2204460492503131e-16, -2.7955415760061442e-13,
	7.9714013168086240e-14}, /* L939 */
{1.1961986957574991e+01, 1.2483625244641416e-12,
	2.2204460492503131e-16, 8.3333340228364250e-13,
	7.0343730840249918e-13}, /* L940 */
{9.7957115227728142e+00, 1.0233758285238537e-12,
	2.2204460492503131e-16, 0.0000000000000000e+00,
	1.8429702208777599e-13}, /* L941 */
{9.6942828106406189e+00, 1.0138556660876930e-12,
	2.2204460492503131e-16, 1.2727596754302795e-12,
	3.7503333771837788e-13}, /* L942 */
{1.1678438361510514e+01, 1.2226608614440693e-12,
	2.2204460492503131e-16, 4.9293902293356950e-13,
	-9.4368957093138306e-15}, /* L943 */
{1.1382962874235105e+01, 1.1929901511109620e-12,
	2.2204460492503131e-16, -7.1165295878472534e-14,
	-6.9499961341534799e-14}, /* L944 */
{1.0870122969975602e+01, 1.1404488464705764e-12,
	2.2204460492503131e-16, -1.3544720900426910e-14,
	-5.6177285046032921e-14}, /* L945 */
{9.2796002062085865e+00, 9.7460928216719367e-13,
	2.2204460492503131e-16, -8.7707618945387367e-14,
	8.5487172896137054e-14}, /* L946 */
{1.0106126670570916e+01, 1.0625389457175061e-12,
	2.2204460492503131e-16, 3.6415315207705135e-14,
	2.8643754035329039e-14}, /* L947 */
{1.1722839949838484e+01, 1.2338186028415521e-12,
	2.2204460492503131e-16, -1.5605294834131200e-12,
	-6.5569771834361745e-13}, /* L948 */
{9.6217090275652115e+00, 1.0137446437852304e-12,
	2.2204460492503131e-16, -2.0650148258027912e-14,
	-4.3742787170231168e-13}, /* L949 */
{9.8484230664083778e+00, 1.0387246618392965e-12,
	2.2204460492503131e-16, -4.6036507939106741e-12,
	7.0070615976192130e-12}, /* L950 */
{1.0046794904055520e+01, 1.0607625888781058e-12,
	2.2204460492503131e-16, -1.5165646516379638e-13,
	-2.0738966099997924e-13}, /* L951 */
{1.0820380363868004e+01, 1.1436407376663738e-12,
	2.2204460492503131e-16, 3.6415315207705135e-13,
	6.2350125062948791e-13}, /* L952 */
{9.1112295650738790e+00, 9.6400665228202342e-13,
	2.2204460492503131e-16, 1.9020340857878182e-12,
	-4.5363712786183896e-13}, /* L953 */
{9.4846062371189124e+00, 1.0045644871503612e-12,
	2.2204460492503131e-16, -4.2077452633293433e-13,
	1.4934720127257606e-12}, /* L954 */
{1.1103667191997831e+01, 1.1772804953125160e-12,
	2.2204460492503131e-16, 8.0380146982861334e-14,
	1.3287149158713873e-12}, /* L955 */
{8.7175750043242175e+00, 9.2525986872260546e-13,
	2.2204460492503131e-16, -3.1419311596891930e-12,
	1.1222134332911082e-12}, /* L956 */
{1.0557473423221234e+01, 1.1217138329300269e-12,
	2.2204460492503131e-16, -6.6613381477509392e-16,
	4.1966430330830917e-14}, /* L957 */
{9.7466095086920035e+00, 1.0366429936681243e-12,
	2.2204460492503131e-16, -9.4146912488213275e-14,
	5.9441340738430881e-13}, /* L958 */
{9.0328485624150652e+00, 9.6173069508154185e-13,
	2.2204460492503131e-16, -2.6578739209526248e-13,
	-1.8540724511240114e-14}, /* L959 */
{1.3895315341380449e+01, 1.4809820036987276e-12,
	2.2204460492503131e-16, 2.5313084961453569e-14,
	-8.1934459217336553e-13}, /* L960 */
{9.0323849033783770e+00, 9.6368692106135745e-13,
	2.2204460492503131e-16, -8.1379347705023974e-14,
	-1.5543122344752192e-14}, /* L961 */
{1.0350833717431327e+01, 1.1055045767704996e-12,
	2.2204460492503131e-16, 2.2470914018413168e-13,
	3.4638958368304884e-14}, /* L962 */
{1.0921406698471406e+01, 1.1676562494677967e-12,
	2.2204460492503131e-16, -2.1549428907974288e-13,
	-1.4588330543574557e-13}, /* L963 */
{1.2189317845236090e+01, 1.3045675650857902e-12,
	2.2204460492503131e-16, -1.8274270985330077e-13,
	-9.3591800975900696e-14}, /* L964 */
{7.9318669069267802e+00, 8.4979245862371044e-13,
	2.2204460492503131e-16, -2.4513724383723456e-13,
	-6.4392935428259079e-15}, /* L965 */
{1.1130954656834399e+01, 1.1937673072281996e-12,
	2.2204460492503131e-16, 2.9378721677630892e-12,
	2.2382096176443156e-13}, /* L966 */
{9.2362997170224350e+00, 9.9159569444395856e-13,
	2.2204460492503131e-16, -2.5746071941057380e-13,
	-2.8288482667448989e-13}, /* L967 */
{9.4284626717711593e+00, 1.0132727989997647e-12,
	2.2204460492503131e-16, -6.6058269965196814e-14,
	-2.2026824808563106e-13}, /* L968 */
{1.3707054208983855e+01, 1.4746129664566787e-12,
	2.2204460492503131e-16, -1.5765166949677223e-14,
	-1.6686652060116103e-13}, /* L969 */
{1.1446909557221781e+01, 1.2327361353925426e-12,
	2.2204460492503131e-16, 2.9087843245179101e-13,
	-9.3924867883288243e-14}, /* L970 */
{9.8254557939041192e+00, 1.0592100113671066e-12,
	2.2204460492503131e-16, -2.3414603589344551e-13,
	-5.8053561957649435e-13}, /* L971 */
{1.3618315541931494e+01, 1.4696022176963197e-12,
	2.2204460492503131e-16, -5.4212190292446394e-13,
	8.7885254629327392e-13}, /* L972 */
{9.6459423629827103e+00, 1.0419998197619407e-12,
	2.2204460492503131e-16, 5.7265303610165574e-13,
	1.1057821325266559e-13}, /* L973 */
{1.0501157178135733e+01, 1.1355499873744179e-12,
	2.2204460492503131e-16, -5.5877524829384129e-13,
	-1.0202949596305189e-13}, /* L974 */
{1.0316412365958021e+01, 1.1167178293192137e-12,
	2.2204460492503131e-16, -8.0202511298921308e-13,
	-1.6386891843467311e-13}, /* L975 */
{1.0151641420129716e+01, 1.1000089727986051e-12,
	2.2204460492503131e-16, 6.5281113847959205e-14,
	-4.3853809472693683e-14}, /* L976 */
{8.7379751747128793e+00, 9.4779739612249614e-13,
	2.2204460492503131e-16, 1.3944401189291966e-13,
	-1.5021317523178368e-13}, /* L977 */
{9.8126298184019856e+00, 1.0654532811571471e-12,
	2.2204460492503131e-16, -1.7419399256368706e-13,
	5.8841820305133297e-14}, /* L978 */
{1.3239532840079457e+01, 1.4390155733678966e-12,
	2.2204460492503131e-16, 1.7763568394002505e-14,
	-6.1384231031524905e-13}, /* L979 */
{1.1041838992514464e+01, 1.2013723349468819e-12,
	2.2204460492503131e-16, -2.6681989950816387e-12,
	3.2820413053968878e-12}, /* L980 */
{1.1217127676006534e+01, 1.2216894162975223e-12,
	2.2204460492503131e-16, 1.1501910535116622e-13,
	1.3478107518949400e-13}, /* L981 */
{8.4791259700988419e+00, 9.2442720145413659e-13,
	2.2204460492503131e-16, -5.9985350020497208e-13,
	-1.2619905120914154e-12}, /* L982 */
{1.1448628994182879e+01, 1.2494449919131512e-12,
	2.2204460492503131e-16, -1.1202150318467829e-13,
	1.7430501486614958e-13}, /* L983 */
{1.1029981930261446e+01, 1.2049805597769137e-12,
	2.2204460492503131e-16, -1.2145839889399213e-13,
	3.9146463848283020e-13}, /* L984 */
{1.0919799187059123e+01, 1.1941558852868184e-12,
	2.2204460492503131e-16, -8.9867002728283296e-12,
	1.9659829320062272e-12}, /* L985 */
{1.0241064467376354e+01, 1.1210685157969635e-12,
	2.2204460492503131e-16, 1.0524914273446484e-13,
	1.5543122344752192e-15}, /* L986 */
{8.4549156093491824e+00, 9.2648111404969313e-13,
	2.2204460492503131e-16, 2.2204460492503131e-14,
	2.9642954757491680e-13}, /* L987 */
{8.8208520061643405e+00, 9.6755936596082392e-13,
	2.2204460492503131e-16, -1.5387691121304670e-13,
	-1.0547118733938987e-13}, /* L988 */
{1.2405652182886818e+01, 1.3621534455943163e-12,
	2.2204460492503131e-16, 2.3092638912203256e-13,
	-3.3317792969000948e-13}, /* L989 */
{1.1107578028891034e+01, 1.2208567490290534e-12,
	2.2204460492503131e-16, 9.7477581562088744e-14,
	1.2891909761947318e-12}, /* L990 */
{9.0343106263842223e+00, 9.9398267394690265e-13,
	2.2204460492503131e-16, 1.0991207943789050e-13,
	-7.0699002208129968e-13}, /* L991 */
{1.0284024280353442e+01, 1.1326217741469691e-12,
	2.2204460492503131e-16, 2.0206059048177849e-14,
	-9.2814644858663087e-14}, /* L992 */
{8.8851981913937248e+00, 9.7954977462677562e-13,
	2.2204460492503131e-16, 7.1187500338965037e-12,
	-1.6326939800137552e-12}, /* L993 */
{1.4001260408274808e+01, 1.5451251389464460e-12,
	2.2204460492503131e-16, -1.1400880239875733e-12,
	2.9931612743894220e-13}, /* L994 */
{1.0292841300706829e+01, 1.1370210328820463e-12,
	2.2204460492503131e-16, 4.5785597535541456e-13,
	6.2683191970336338e-13}, /* L995 */
{1.3936749837815491e+01, 1.5411005804821798e-12,
	2.2204460492503131e-16, 8.9039886574937555e-14,
	-1.4277468096679513e-13}, /* L996 */
{1.1541251106258247e+01, 1.2774920010727442e-12,
	2.2204460492503131e-16, -6.0063065632220969e-13,
	1.4388490399142029e-13}, /* L997 */
{9.9814649669206350e+00, 1.1059486659803497e-12,
	2.2204460492503131e-16, -1.7119639039719914e-13,
	1.5809575870662229e-13}, /* L998 */
{1.0939629364123027e+01, 1.2133280491433140e-12,
	2.2204460492503131e-16, -9.5368157815300947e-14,
	3.7747582837255322e-15}, /* L999 */
{7.8078765965996340e+00, 8.6684825983951441e-13,
	2.2204460492503131e-16, 7.5495165674510645e-15,
	1.6742163211347361e-13}, /* L1000 */
{2.3549019000387378e+01, 5.2289318708265142e-12,
	2.2204460492503131e-16, -8.9506180245280120e-12,
	4.1280312501612570e-12}, /* L1001 */
{2.6398000009078743e+01, 8.7923002212164647e-12,
	2.2204460492503131e-16, -1.3117951169761000e-11,
	4.6029846600958990e-13}, /* L1002 */
{3.7420692245374873e+01, 1.6684598147520546e-11,
	2.2204460492503131e-16, 1.1437517599688363e-12,
	-5.7873705827660160e-12}, /* L1003 */
{5.0393900018547960e+01, 2.7974234040328838e-11,
	2.2204460492503131e-16, -3.7119196605317484e-12,
	-3.6116665214080967e-12}, /* L1004 */
{6.4066354190196932e+01, 4.2676764899773900e-11,
	2.2204460492503131e-16, 1.0669243266647754e-11,
	7.3929751209789174e-12}, /* L1005 */
{6.9029432745783822e+01, 5.3769266816772188e-11,
	2.2204460492503131e-16, -3.2964631024867685e-11,
	-2.3945401217417839e-11}, /* L1006 */
{6.0884428697543100e+01, 5.4306059649178451e-11,
	2.2204460492503131e-16, 1.2041700969689373e-11,
	-7.6226802647738623e-12}, /* L1007 */
{8.9131121164442703e+01, 8.9059880997721663e-11,
	2.2204460492503131e-16, -8.1148754382809329e-11,
	8.6431484191962227e-10}, /* L1008 */
{1.0694525002117500e+02, 1.1873307892429352e-10,
	2.2204460492503131e-16, -4.3724246445719928e-11,
	2.0131674105527964e-11}, /* L1009 */

#else  /* }  { */

/* Start of SP golden values */


{0.0000000000000000e+00, 0.0000000000000000e+00,
	0.0000000000000000e+00, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L1010 */
{0.0000000000000000e+00, 0.0000000000000000e+00,
	1.1920928955078125e-07, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L1011 */
{0.0000000000000000e+00, 0.0000000000000000e+00,
	1.1920928955078125e-07, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L1012 */
{6.8018096685409546e-01, 1.1920928955078125e-07,
	1.1920928955078125e-07, -5.9604644775390625e-08,
	-1.1920928955078125e-07}, /* L1013 */
{8.9273703098297119e-01, 2.0861625671386719e-07,
	1.1920928955078125e-07, -1.1920928955078125e-07,
	-2.3841857910156250e-07}, /* L1014 */
{7.1418994665145874e-01, 2.0861625671386719e-07,
	1.1920928955078125e-07, -5.9604644775390625e-08,
	1.1920928955078125e-07}, /* L1015 */
{3.6134567856788635e-01, 1.2665987014770508e-07,
	1.1920928955078125e-07, 2.3841857910156250e-07,
	7.1525573730468750e-07}, /* L1016 */
{4.3648514151573181e-01, 1.7881393432617188e-07,
	1.1920928955078125e-07, -5.9604644775390625e-08,
	3.5762786865234375e-07}, /* L1017 */
{4.7549185156822205e-01, 2.2351741790771484e-07,
	1.1920928955078125e-07, 3.6954879760742188e-06,
	-5.9604644775390625e-07}, /* L1018 */
{4.2266038060188293e-01, 2.2351741790771484e-07,
	1.1920928955078125e-07, 4.7683715820312500e-07,
	8.3446502685546875e-07}, /* L1019 */
{4.0575435757637024e-01, 2.3841857910156250e-07,
	1.1920928955078125e-07, 3.5762786865234375e-07,
	3.5762786865234375e-07}, /* L1020 */
{3.2275927066802979e-01, 2.0861625671386719e-07,
	1.1920928955078125e-07, -1.1920928955078125e-07,
	1.1920928955078125e-07}, /* L1021 */
{2.9586255550384521e-01, 2.0861625671386719e-07,
	1.1920928955078125e-07, -1.1920928955078125e-07,
	-2.3841857910156250e-07}, /* L1022 */
{7.8410917520523071e-01, 6.0349702835083008e-07,
	1.1920928955078125e-07, 7.1525573730468750e-07,
	-7.1525573730468750e-07}, /* L1023 */
{3.5955643653869629e-01, 2.9802322387695312e-07,
	1.1920928955078125e-07, -3.5762786865234375e-07,
	-3.5762786865234375e-07}, /* L1024 */
{4.0270313620567322e-01, 3.5762786865234375e-07,
	1.1920928955078125e-07, -2.3841857910156250e-07,
	3.5762786865234375e-07}, /* L1025 */
{2.9888099431991577e-01, 2.8312206268310547e-07,
	1.1920928955078125e-07, -7.1525573730468750e-07,
	-1.1920928955078125e-07}, /* L1026 */
{5.8850812911987305e-01, 5.9232115745544434e-07,
	1.1920928955078125e-07, -1.7285346984863281e-06,
	3.5762786865234375e-07}, /* L1027 */
{5.0337857007980347e-01, 5.3644180297851562e-07,
	1.1920928955078125e-07, -4.7683715820312500e-07,
	-4.7683715820312500e-07}, /* L1028 */
{4.5867058634757996e-01, 5.1595270633697510e-07,
	1.1920928955078125e-07, 7.1525573730468750e-07,
	-1.2516975402832031e-06}, /* L1029 */
{4.7820881009101868e-01, 5.6624412536621094e-07,
	1.1920928955078125e-07, 0.0000000000000000e+00,
	-1.0728836059570312e-06}, /* L1030 */
{9.7883027791976929e-01, 1.2218952178955078e-06,
	1.1920928955078125e-07, 8.3446502685546875e-07,
	2.3841857910156250e-07}, /* L1031 */
{4.2159116268157959e-01, 5.5134296417236328e-07,
	1.1920928955078125e-07, -2.6822090148925781e-06,
	-8.9406967163085938e-07}, /* L1032 */
{5.0135254859924316e-01, 6.8545341491699219e-07,
	1.1920928955078125e-07, 1.1920928955078125e-07,
	-1.7881393432617188e-07}, /* L1033 */
{1.0027021169662476e+00, 1.4305114746093750e-06,
	1.1920928955078125e-07, -3.6954879760742188e-06,
	-2.3841857910156250e-07}, /* L1034 */
{7.2194659709930420e-01, 1.0728836059570312e-06,
	1.1920928955078125e-07, -5.3644180297851562e-07,
	4.7683715820312500e-07}, /* L1035 */
{3.9529633522033691e-01, 6.1094760894775391e-07,
	1.1920928955078125e-07, -1.6093254089355469e-06,
	1.1920928955078125e-07}, /* L1036 */
{5.9419322013854980e-01, 9.5367431640625000e-07,
	1.1920928955078125e-07, 2.2649765014648438e-06,
	0.0000000000000000e+00}, /* L1037 */
{5.9087789058685303e-01, 9.8347663879394531e-07,
	1.1920928955078125e-07, 2.2649765014648438e-06,
	-2.9802322387695312e-06}, /* L1038 */
{6.3101136684417725e-01, 1.0877847671508789e-06,
	1.1920928955078125e-07, 2.3841857910156250e-07,
	1.1920928955078125e-06}, /* L1039 */
{1.1363973617553711e+00, 2.0265579223632812e-06,
	1.1920928955078125e-07, -5.9604644775390625e-07,
	2.3841857910156250e-07}, /* L1040 */
{5.0943696498870850e-01, 9.3877315521240234e-07,
	1.1920928955078125e-07, 2.8610229492187500e-06,
	-3.1590461730957031e-06}, /* L1041 */
{9.7332048416137695e-01, 1.8514692783355713e-06,
	1.1920928955078125e-07, -5.9604644775390625e-07,
	7.2717666625976562e-06}, /* L1042 */
{8.8116312026977539e-01, 1.7285346984863281e-06,
	1.1920928955078125e-07, 1.0728836059570312e-06,
	-1.0132789611816406e-06}, /* L1043 */
{1.0469392538070679e+00, 2.1159648895263672e-06,
	1.1920928955078125e-07, 0.0000000000000000e+00,
	-1.7285346984863281e-06}, /* L1044 */
{6.3979321718215942e-01, 1.3336539268493652e-06,
	1.1920928955078125e-07, -1.1920928955078125e-07,
	1.4305114746093750e-06}, /* L1045 */
{1.0980664491653442e+00, 2.3543834686279297e-06,
	1.1920928955078125e-07, 2.6583671569824219e-05,
	-2.1398067474365234e-05}, /* L1046 */
{7.8947657346725464e-01, 1.7397105693817139e-06,
	1.1920928955078125e-07, 3.3378601074218750e-06,
	-1.5497207641601562e-06}, /* L1047 */
{1.1061322689056396e+00, 2.5033950805664062e-06,
	1.1920928955078125e-07, 3.0994415283203125e-06,
	1.1920928955078125e-07}, /* L1048 */
{1.2958996295928955e+00, 3.0100345611572266e-06,
	1.1920928955078125e-07, -5.9604644775390625e-08,
	-1.6689300537109375e-06}, /* L1049 */
{6.1920803785324097e-01, 1.4752149581909180e-06,
	1.1920928955078125e-07, -1.9490718841552734e-05,
	4.4703483581542969e-05}, /* L1050 */
{9.3974453210830688e-01, 2.2947788238525391e-06,
	1.1920928955078125e-07, -1.4066696166992188e-05,
	-1.3649463653564453e-05}, /* L1051 */
{5.5696403980255127e-01, 1.3932585716247559e-06,
	1.1920928955078125e-07, -5.9604644775390625e-06,
	7.5101852416992188e-06}, /* L1052 */
{5.8767557144165039e-01, 1.5050172805786133e-06,
	1.1920928955078125e-07, 2.7418136596679688e-06,
	-1.3113021850585938e-06}, /* L1053 */
{9.4389802217483521e-01, 2.4735927581787109e-06,
	1.1920928955078125e-07, -1.6808509826660156e-05,
	9.0599060058593750e-06}, /* L1054 */
{9.3407374620437622e-01, 2.5033950805664062e-06,
	1.1920928955078125e-07, -7.7486038208007812e-07,
	-6.1392784118652344e-06}, /* L1055 */
{1.6670787334442139e+00, 4.5672059059143066e-06,
	1.1920928955078125e-07, -3.7550926208496094e-06,
	-2.0265579223632812e-06}, /* L1056 */
{6.6008597612380981e-01, 1.8477439880371094e-06,
	1.1920928955078125e-07, 0.0000000000000000e+00,
	5.9604644775390625e-07}, /* L1057 */
{9.2781543731689453e-01, 2.6524066925048828e-06,
	1.1920928955078125e-07, -4.8875808715820312e-06,
	-1.0728836059570312e-06}, /* L1058 */
{8.6735057830810547e-01, 2.5331974029541016e-06,
	1.1920928955078125e-07, 6.6757202148437500e-06,
	-1.1324882507324219e-06}, /* L1059 */
{8.6625766754150391e-01, 2.5816261768341064e-06,
	1.1920928955078125e-07, -1.7881393432617188e-06,
	-3.2186508178710938e-06}, /* L1060 */
{1.0391687154769897e+00, 3.1590461730957031e-06,
	1.1920928955078125e-07, 7.2717666625976562e-06,
	-2.1994113922119141e-05}, /* L1061 */
{1.0913528203964233e+00, 3.3825635910034180e-06,
	1.1920928955078125e-07, 4.7683715820312500e-07,
	3.5762786865234375e-07}, /* L1062 */
{1.2523679733276367e+00, 3.9562582969665527e-06,
	1.1920928955078125e-07, -5.1856040954589844e-06,
	1.9073486328125000e-06}, /* L1063 */
{6.2963581085205078e-01, 2.0265579223632812e-06,
	1.1920928955078125e-07, 9.5367431640625000e-07,
	4.7683715820312500e-07}, /* L1064 */
{5.0682407617568970e-01, 1.6614794731140137e-06,
	1.1920928955078125e-07, 4.7683715820312500e-07,
	9.5367431640625000e-07}, /* L1065 */
{1.0089418888092041e+00, 3.3676624298095703e-06,
	1.1920928955078125e-07, -5.9604644775390625e-08,
	-1.0132789611816406e-06}, /* L1066 */
{1.5701940059661865e+00, 5.3346157073974609e-06,
	1.1920928955078125e-07, 1.4305114746093750e-06,
	-3.3378601074218750e-06}, /* L1067 */
{1.4263415336608887e+00, 4.9322843551635742e-06,
	1.1920928955078125e-07, -1.3816356658935547e-04,
	-7.9035758972167969e-05}, /* L1068 */
{1.3898396492004395e+00, 4.8875808715820312e-06,
	1.1920928955078125e-07, -8.0466270446777344e-06,
	-4.9471855163574219e-06}, /* L1069 */
{9.5001077651977539e-01, 3.3974647521972656e-06,
	1.1920928955078125e-07, 9.5367431640625000e-07,
	1.5497207641601562e-06}, /* L1070 */
{1.0409712791442871e+00, 3.7848949432373047e-06,
	1.1920928955078125e-07, 1.4543533325195312e-05,
	2.7179718017578125e-05}, /* L1071 */
{1.2903363704681396e+00, 4.7683715820312500e-06,
	1.1920928955078125e-07, -4.7683715820312500e-07,
	-8.3446502685546875e-07}, /* L1072 */
{7.7579402923583984e-01, 2.9131770133972168e-06,
	1.1920928955078125e-07, -2.2053718566894531e-06,
	1.9073486328125000e-06}, /* L1073 */
{1.9140597581863403e+00, 7.3015689849853516e-06,
	1.1920928955078125e-07, 4.7683715820312500e-06,
	-1.1086463928222656e-05}, /* L1074 */
{1.0586640834808350e+00, 4.1015446186065674e-06,
	1.1920928955078125e-07, 1.1920928955078125e-06,
	-4.7683715820312500e-07}, /* L1075 */
{1.0454654693603516e+00, 4.1127204895019531e-06,
	1.1920928955078125e-07, -2.4437904357910156e-06,
	1.9073486328125000e-06}, /* L1076 */
{9.0949100255966187e-01, 3.6321580410003662e-06,
	1.1920928955078125e-07, 1.0251998901367188e-05,
	-4.5299530029296875e-06}, /* L1077 */
{8.6765336990356445e-01, 3.5166740417480469e-06,
	1.1920928955078125e-07, -1.7881393432617188e-07,
	1.1920928955078125e-06}, /* L1078 */
{1.6591906547546387e+00, 6.8247318267822266e-06,
	1.1920928955078125e-07, -6.3300132751464844e-05,
	-1.5711784362792969e-04}, /* L1079 */
{1.5803515911102295e+00, 6.5937638282775879e-06,
	1.1920928955078125e-07, 6.4373016357421875e-06,
	3.5762786865234375e-07}, /* L1080 */
{1.5871639251708984e+00, 6.7166984081268311e-06,
	1.1920928955078125e-07, -8.3446502685546875e-07,
	-1.0728836059570312e-06}, /* L1081 */
{1.5208110809326172e+00, 6.5267086029052734e-06,
	1.1920928955078125e-07, -1.9907951354980469e-05,
	-1.5854835510253906e-05}, /* L1082 */
{1.4109665155410767e+00, 6.1392784118652344e-06,
	1.1920928955078125e-07, -5.9604644775390625e-07,
	4.7683715820312500e-07}, /* L1083 */
{1.6604399681091309e+00, 7.3239207267761230e-06,
	1.1920928955078125e-07, -8.6426734924316406e-06,
	-1.0132789611816406e-05}, /* L1084 */
{1.6600131988525391e+00, 7.4207782745361328e-06,
	1.1920928955078125e-07, 1.5497207641601562e-06,
	2.3841857910156250e-07}, /* L1085 */
{1.0657552480697632e+00, 4.8279762268066406e-06,
	1.1920928955078125e-07, -2.7596950531005859e-05,
	-2.5689601898193359e-05}, /* L1086 */
{9.7807997465133667e-01, 4.4889748096466064e-06,
	1.1920928955078125e-07, -7.7486038208007812e-07,
	-1.1920928955078125e-07}, /* L1087 */
{1.1570127010345459e+00, 5.3793191909790039e-06,
	1.1920928955078125e-07, 3.0994415283203125e-06,
	-2.9563903808593750e-05}, /* L1088 */
{1.4557089805603027e+00, 6.8545341491699219e-06,
	1.1920928955078125e-07, 3.5762786865234375e-07,
	4.7683715820312500e-07}, /* L1089 */
{1.1683254241943359e+00, 5.5730342864990234e-06,
	1.1920928955078125e-07, -1.6516447067260742e-04,
	-4.8935413360595703e-05}, /* L1090 */
{1.2592644691467285e+00, 6.0796737670898438e-06,
	1.1920928955078125e-07, -4.1723251342773438e-07,
	7.1525573730468750e-07}, /* L1091 */
{1.0975710153579712e+00, 5.3644180297851562e-06,
	1.1920928955078125e-07, -1.6689300537109375e-06,
	-3.7550926208496094e-06}, /* L1092 */
{2.2108526229858398e+00, 1.0937452316284180e-05,
	1.1920928955078125e-07, -1.1324882507324219e-06,
	-1.2516975402832031e-06}, /* L1093 */
{2.0297622680664062e+00, 1.0162591934204102e-05,
	1.1920928955078125e-07, 1.5139579772949219e-05,
	-4.1723251342773438e-06}, /* L1094 */
{1.5676014423370361e+00, 7.9423189163208008e-06,
	1.1920928955078125e-07, 4.8875808715820312e-06,
	1.5497207641601562e-06}, /* L1095 */
{1.3372215032577515e+00, 6.8545341491699219e-06,
	1.1920928955078125e-07, -7.7486038208007812e-07,
	4.7683715820312500e-06}, /* L1096 */
{1.4568958282470703e+00, 7.5548887252807617e-06,
	1.1920928955078125e-07, 1.9073486328125000e-06,
	3.9339065551757812e-06}, /* L1097 */
{1.2471650838851929e+00, 6.5416097640991211e-06,
	1.1920928955078125e-07, -5.3644180297851562e-07,
	-2.9802322387695312e-07}, /* L1098 */
{1.0786615610122681e+00, 5.7220458984375000e-06,
	1.1920928955078125e-07, -2.6822090148925781e-06,
	0.0000000000000000e+00}, /* L1099 */
{1.4416582584381104e+00, 7.7337026596069336e-06,
	1.1920928955078125e-07, 1.7404556274414062e-05,
	8.8214874267578125e-06}, /* L1100 */
{1.2912023067474365e+00, 7.0035457611083984e-06,
	1.1920928955078125e-07, 6.0796737670898438e-06,
	1.4543533325195312e-05}, /* L1101 */
{1.4266119003295898e+00, 7.8231096267700195e-06,
	1.1920928955078125e-07, -1.8596649169921875e-05,
	-5.9604644775390625e-08}, /* L1102 */
{1.0443524122238159e+00, 5.7891011238098145e-06,
	1.1920928955078125e-07, 9.0599060058593750e-06,
	1.9073486328125000e-06}, /* L1103 */
{8.7233221530914307e-01, 4.8875808715820312e-06,
	1.1920928955078125e-07, -6.9737434387207031e-06,
	2.2649765014648438e-06}, /* L1104 */
{1.5466986894607544e+00, 8.7581574916839600e-06,
	1.1920928955078125e-07, -1.6450881958007812e-05,
	1.1801719665527344e-05}, /* L1105 */
{1.8489117622375488e+00, 1.0579824447631836e-05,
	1.1920928955078125e-07, 1.0013580322265625e-05,
	2.3841857910156250e-07}, /* L1106 */
{2.1134092807769775e+00, 1.2218952178955078e-05,
	1.1920928955078125e-07, -1.3113021850585938e-06,
	1.1920928955078125e-06}, /* L1107 */
{1.0867348909378052e+00, 6.3478946685791016e-06,
	1.1920928955078125e-07, -1.8477439880371094e-06,
	-7.2717666625976562e-06}, /* L1108 */
{1.6565171480178833e+00, 9.7751617431640625e-06,
	1.1920928955078125e-07, -6.5565109252929688e-06,
	7.2717666625976562e-06}, /* L1109 */
{1.5700103044509888e+00, 9.3579292297363281e-06,
	1.1920928955078125e-07, -3.7550926208496094e-06,
	1.9073486328125000e-06}, /* L1110 */
{9.6533346176147461e-01, 5.8114528656005859e-06,
	1.1920928955078125e-07, -1.9669532775878906e-05,
	-3.8146972656250000e-06}, /* L1111 */
{1.4190838336944580e+00, 8.6277723312377930e-06,
	1.1920928955078125e-07, -9.5367431640625000e-07,
	2.2649765014648438e-06}, /* L1112 */
{1.1650413274765015e+00, 7.1525573730468750e-06,
	1.1920928955078125e-07, -4.7683715820312500e-07,
	1.3113021850585938e-06}, /* L1113 */
{1.6706761121749878e+00, 1.0356307029724121e-05,
	1.1920928955078125e-07, 1.1920928955078125e-06,
	3.3378601074218750e-06}, /* L1114 */
{1.8690253496170044e+00, 1.1697411537170410e-05,
	1.1920928955078125e-07, -1.3530254364013672e-05,
	-5.1259994506835938e-06}, /* L1115 */
{1.2451384067535400e+00, 7.8678131103515625e-06,
	1.1920928955078125e-07, 1.6689300537109375e-05,
	-3.8266181945800781e-05}, /* L1116 */
{1.4018733501434326e+00, 8.9406967163085938e-06,
	1.1920928955078125e-07, -5.0663948059082031e-06,
	0.0000000000000000e+00}, /* L1117 */
{2.1110765933990479e+00, 1.3589859008789062e-05,
	1.1920928955078125e-07, -1.6450881958007812e-05,
	-1.9550323486328125e-05}, /* L1118 */
{1.7178971767425537e+00, 1.1160969734191895e-05,
	1.1920928955078125e-07, 5.6028366088867188e-06,
	2.2649765014648438e-06}, /* L1119 */
{1.3181906938552856e+00, 8.6426734924316406e-06,
	1.1920928955078125e-07, 8.3446502685546875e-07,
	1.3113021850585938e-06}, /* L1120 */
{1.2252202033996582e+00, 8.1062316894531250e-06,
	1.1920928955078125e-07, 1.7881393432617188e-06,
	8.5830688476562500e-06}, /* L1121 */
{1.6874964237213135e+00, 1.1265277862548828e-05,
	1.1920928955078125e-07, -3.0994415283203125e-06,
	4.7683715820312500e-06}, /* L1122 */
{2.1283390522003174e+00, 1.4334917068481445e-05,
	1.1920928955078125e-07, 1.3113021850585938e-06,
	-3.9339065551757812e-06}, /* L1123 */
{1.2017642259597778e+00, 8.1658363342285156e-06,
	1.1920928955078125e-07, -1.6689300537109375e-06,
	-2.0265579223632812e-06}, /* L1124 */
{1.8911085128784180e+00, 1.2964010238647461e-05,
	1.1920928955078125e-07, -5.1081180572509766e-05,
	1.7404556274414062e-05}, /* L1125 */
{1.6616483926773071e+00, 1.1488795280456543e-05,
	1.1920928955078125e-07, -2.9206275939941406e-06,
	-6.9737434387207031e-06}, /* L1126 */
{1.4078015089035034e+00, 9.8198652267456055e-06,
	1.1920928955078125e-07, 6.8426132202148438e-05,
	5.9723854064941406e-05}, /* L1127 */
{1.5084152221679688e+00, 1.0609626770019531e-05,
	1.1920928955078125e-07, -5.9604644775390625e-07,
	-5.5551528930664062e-05}, /* L1128 */
{1.5756088495254517e+00, 1.1175870895385742e-05,
	1.1920928955078125e-07, 8.3446502685546875e-07,
	-3.0398368835449219e-06}, /* L1129 */
{2.3708157539367676e+00, 1.6957521438598633e-05,
	1.1920928955078125e-07, -7.7486038208007812e-07,
	2.1457672119140625e-06}, /* L1130 */
{1.5120798349380493e+00, 1.0907649993896484e-05,
	1.1920928955078125e-07, -8.5651874542236328e-05,
	2.5272369384765625e-05}, /* L1131 */
{2.7950906753540039e+00, 2.0325183868408203e-05,
	1.1920928955078125e-07, -5.1856040954589844e-06,
	-7.4505805969238281e-06}, /* L1132 */
{1.3575928211212158e+00, 9.9539756774902344e-06,
	1.1920928955078125e-07, -1.6272068023681641e-05,
	-1.3530254364013672e-05}, /* L1133 */
{1.8224974870681763e+00, 1.3470649719238281e-05,
	1.1920928955078125e-07, -2.4855136871337891e-05,
	-2.3782253265380859e-05}, /* L1134 */
{1.3239212036132812e+00, 9.8645687103271484e-06,
	1.1920928955078125e-07, 2.0384788513183594e-05,
	-9.1195106506347656e-06}, /* L1135 */
{2.3055584430694580e+00, 1.7315149307250977e-05,
	1.1920928955078125e-07, 1.5497207641601562e-06,
	-6.5565109252929688e-07}, /* L1136 */
{1.6377103328704834e+00, 1.2397766113281250e-05,
	1.1920928955078125e-07, 2.3841857910156250e-06,
	-3.2424926757812500e-05}, /* L1137 */
{2.5683627128601074e+00, 1.9595026969909668e-05,
	1.1920928955078125e-07, 4.4107437133789062e-06,
	-1.2516975402832031e-06}, /* L1138 */
{1.9767295122146606e+00, 1.5199184417724609e-05,
	1.1920928955078125e-07, -8.9406967163085938e-06,
	-5.4836273193359375e-06}, /* L1139 */
{1.6994286775588989e+00, 1.3168901205062866e-05,
	1.1920928955078125e-07, 1.6450881958007812e-05,
	6.3180923461914062e-06}, /* L1140 */
{1.8375978469848633e+00, 1.4349818229675293e-05,
	1.1920928955078125e-07, -1.6570091247558594e-05,
	-2.0921230316162109e-05}, /* L1141 */
{1.8105823993682861e+00, 1.4245510101318359e-05,
	1.1920928955078125e-07, 2.0384788513183594e-05,
	1.2159347534179688e-05}, /* L1142 */
{2.3307569026947021e+00, 1.8477439880371094e-05,
	1.1920928955078125e-07, -7.3313713073730469e-06,
	-2.1517276763916016e-05}, /* L1143 */
{1.3041013479232788e+00, 1.0415911674499512e-05,
	1.1920928955078125e-07, 3.3378601074218750e-06,
	-4.5299530029296875e-06}, /* L1144 */
{2.1185142993927002e+00, 1.7046928405761719e-05,
	1.1920928955078125e-07, -1.9073486328125000e-06,
	-5.3644180297851562e-06}, /* L1145 */
{1.6652044057846069e+00, 1.3500452041625977e-05,
	1.1920928955078125e-07, -3.2246112823486328e-05,
	-2.2947788238525391e-05}, /* L1146 */
{3.0401215553283691e+00, 2.4825334548950195e-05,
	1.1920928955078125e-07, 7.5101852416992188e-06,
	1.0609626770019531e-05}, /* L1147 */
{1.8043446540832520e+00, 1.4841556549072266e-05,
	1.1920928955078125e-07, -1.0132789611816406e-05,
	-1.1742115020751953e-05}, /* L1148 */
{2.1798567771911621e+00, 1.8060207366943359e-05,
	1.1920928955078125e-07, -5.0067901611328125e-06,
	3.8146972656250000e-06}, /* L1149 */
{1.5401673316955566e+00, 1.2852251529693604e-05,
	1.1920928955078125e-07, -5.0663948059082031e-06,
	1.7881393432617188e-06}, /* L1150 */
{2.5070142745971680e+00, 2.1070241928100586e-05,
	1.1920928955078125e-07, 1.3828277587890625e-05,
	1.8954277038574219e-05}, /* L1151 */
{1.6487674713134766e+00, 1.3954937458038330e-05,
	1.1920928955078125e-07, -9.8347663879394531e-06,
	-5.4240226745605469e-06}, /* L1152 */
{1.4859261512756348e+00, 1.2665987014770508e-05,
	1.1920928955078125e-07, 2.9802322387695312e-06,
	3.9935111999511719e-05}, /* L1153 */
{1.6457158327102661e+00, 1.4126300811767578e-05,
	1.1920928955078125e-07, -1.6212463378906250e-05,
	1.3589859008789062e-05}, /* L1154 */
{1.8611181974411011e+00, 1.6085803508758545e-05,
	1.1920928955078125e-07, -1.1622905731201172e-05,
	-1.1682510375976562e-05}, /* L1155 */
{1.8321113586425781e+00, 1.5944242477416992e-05,
	1.1920928955078125e-07, -2.2232532501220703e-05,
	3.1352043151855469e-05}, /* L1156 */
{2.2074513435363770e+00, 1.9341707229614258e-05,
	1.1920928955078125e-07, -2.6404857635498047e-05,
	-2.7418136596679688e-06}, /* L1157 */
{2.0101280212402344e+00, 1.7732381820678711e-05,
	1.1920928955078125e-07, -3.1590461730957031e-06,
	-6.9141387939453125e-06}, /* L1158 */
{3.4258801937103271e+00, 3.0428171157836914e-05,
	1.1920928955078125e-07, -1.4126300811767578e-05,
	-1.9788742065429688e-05}, /* L1159 */
{1.8116010427474976e+00, 1.6197562217712402e-05,
	1.1920928955078125e-07, -1.6093254089355469e-06,
	7.6293945312500000e-06}, /* L1160 */
{2.0053453445434570e+00, 1.8049031496047974e-05,
	1.1920928955078125e-07, -3.2126903533935547e-05,
	-1.7106533050537109e-05}, /* L1161 */
{2.2388551235198975e+00, 2.0284205675125122e-05,
	1.1920928955078125e-07, -4.6491622924804688e-06,
	-1.3589859008789062e-05}, /* L1162 */
{1.6697667837142944e+00, 1.5228986740112305e-05,
	1.1920928955078125e-07, -1.5079975128173828e-05,
	-4.3272972106933594e-05}, /* L1163 */
{2.2406351566314697e+00, 2.0567327737808228e-05,
	1.1920928955078125e-07, 1.5735626220703125e-05,
	-9.5367431640625000e-06}, /* L1164 */
{2.2467515468597412e+00, 2.0757317543029785e-05,
	1.1920928955078125e-07, -1.4305114746093750e-06,
	5.1259994506835938e-06}, /* L1165 */
{2.3745467662811279e+00, 2.2079795598983765e-05,
	1.1920928955078125e-07, 3.7431716918945312e-05,
	-3.6358833312988281e-06}, /* L1166 */
{2.0955083370208740e+00, 1.9609928131103516e-05,
	1.1920928955078125e-07, 9.5367431640625000e-07,
	-2.7298927307128906e-05}, /* L1167 */
{1.7495329380035400e+00, 1.6480684280395508e-05,
	1.1920928955078125e-07, -1.4305114746093750e-05,
	-4.9769878387451172e-05}, /* L1168 */
{2.1758046150207520e+00, 2.0623207092285156e-05,
	1.1920928955078125e-07, 6.1154365539550781e-05,
	-3.0517578125000000e-05}, /* L1169 */
{2.2445225715637207e+00, 2.1405518054962158e-05,
	1.1920928955078125e-07, -8.4638595581054688e-06,
	-4.5299530029296875e-06}, /* L1170 */
{1.6459550857543945e+00, 1.5795230865478516e-05,
	1.1920928955078125e-07, 3.5762786865234375e-07,
	7.0333480834960938e-06}, /* L1171 */
{2.4256405830383301e+00, 2.3423694074153900e-05,
	1.1920928955078125e-07, 3.2901763916015625e-05,
	4.0531158447265625e-06}, /* L1172 */
{1.8588899374008179e+00, 1.8060207366943359e-05,
	1.1920928955078125e-07, -1.6927719116210938e-05,
	-7.7486038208007812e-07}, /* L1173 */
{2.1371707916259766e+00, 2.0891427993774414e-05,
	1.1920928955078125e-07, -5.3644180297851562e-06,
	-1.3709068298339844e-06}, /* L1174 */
{2.0060150623321533e+00, 1.9729137420654297e-05,
	1.1920928955078125e-07, -2.3782253265380859e-05,
	1.1920928955078125e-06}, /* L1175 */
{2.0059118270874023e+00, 1.9848346710205078e-05,
	1.1920928955078125e-07, -2.8014183044433594e-05,
	-3.5166740417480469e-05}, /* L1176 */
{2.0755820274353027e+00, 2.0660459995269775e-05,
	1.1920928955078125e-07, 4.1723251342773438e-06,
	7.1525573730468750e-07}, /* L1177 */
{3.0146615505218506e+00, 3.0189752578735352e-05,
	1.1920928955078125e-07, 3.5405158996582031e-05,
	-1.8298625946044922e-05}, /* L1178 */
{3.9156386852264404e+00, 3.9443373680114746e-05,
	1.1920928955078125e-07, -2.9802322387695312e-07,
	1.0251998901367188e-05}, /* L1179 */
{2.4558520317077637e+00, 2.4884939193725586e-05,
	1.1920928955078125e-07, 8.3446502685546875e-06,
	-5.3048133850097656e-06}, /* L1180 */
{2.8026320934295654e+00, 2.8565526008605957e-05,
	1.1920928955078125e-07, -1.9669532775878906e-06,
	-1.0848045349121094e-05}, /* L1181 */
{2.3371465206146240e+00, 2.3961067199707031e-05,
	1.1920928955078125e-07, 2.3841857910156250e-07,
	1.9073486328125000e-06}, /* L1182 */
{2.1054863929748535e+00, 2.1710991859436035e-05,
	1.1920928955078125e-07, 4.5299530029296875e-06,
	-3.8146972656250000e-06}, /* L1183 */
{2.3062880039215088e+00, 2.3931264877319336e-05,
	1.1920928955078125e-07, 1.1324882507324219e-04,
	-1.0037422180175781e-04}, /* L1184 */
{2.5199549198150635e+00, 2.6285648345947266e-05,
	1.1920928955078125e-07, -1.6748905181884766e-05,
	2.2053718566894531e-05}, /* L1185 */
{1.5906770229339600e+00, 1.6689300537109375e-05,
	1.1920928955078125e-07, 4.4107437133789062e-05,
	-1.6510486602783203e-05}, /* L1186 */
{2.2541122436523438e+00, 2.3782253265380859e-05,
	1.1920928955078125e-07, -3.5464763641357422e-05,
	-6.1392784118652344e-06}, /* L1187 */
{1.9265031814575195e+00, 2.0444393157958984e-05,
	1.1920928955078125e-07, -3.2544136047363281e-05,
	-4.9293041229248047e-05}, /* L1188 */
{2.2580652236938477e+00, 2.4095177650451660e-05,
	1.1920928955078125e-07, 1.0728836059570312e-05,
	-5.9962272644042969e-05}, /* L1189 */
{1.8595248460769653e+00, 1.9952654838562012e-05,
	1.1920928955078125e-07, -2.0265579223632812e-06,
	4.0411949157714844e-05}, /* L1190 */
{2.6842482089996338e+00, 2.8960406780242920e-05,
	1.1920928955078125e-07, -2.8252601623535156e-05,
	-1.4364719390869141e-05}, /* L1191 */
{2.4145283699035645e+00, 2.6196241378784180e-05,
	1.1920928955078125e-07, 6.4373016357421875e-06,
	-1.0728836059570312e-05}, /* L1192 */
{2.0791890621185303e+00, 2.2679567337036133e-05,
	1.1920928955078125e-07, -7.5697898864746094e-06,
	1.8835067749023438e-05}, /* L1193 */
{2.7559175491333008e+00, 3.0225142836570740e-05,
	1.1920928955078125e-07, -4.2915344238281250e-06,
	-8.3446502685546875e-07}, /* L1194 */
{2.5566635131835938e+00, 2.8196722269058228e-05,
	1.1920928955078125e-07, -9.7632408142089844e-05,
	3.1471252441406250e-05}, /* L1195 */
{3.8623738288879395e+00, 4.2855739593505859e-05,
	1.1920928955078125e-07, 3.3819675445556641e-04,
	2.2149085998535156e-04}, /* L1196 */
{2.4945464134216309e+00, 2.7805566787719727e-05,
	1.1920928955078125e-07, -1.3232231140136719e-05,
	-3.5762786865234375e-07}, /* L1197 */
{2.3874394893646240e+00, 2.6755034923553467e-05,
	1.1920928955078125e-07, 2.1457672119140625e-05,
	5.8412551879882812e-06}, /* L1198 */
{3.1719310283660889e+00, 3.5732984542846680e-05,
	1.1920928955078125e-07, -5.9604644775390625e-08,
	-5.6624412536621094e-06}, /* L1199 */
{2.5210285186767578e+00, 2.8550624847412109e-05,
	1.1920928955078125e-07, -4.7683715820312500e-06,
	1.0490417480468750e-05}, /* L1200 */
{3.5811295509338379e+00, 4.0769577026367188e-05,
	1.1920928955078125e-07, 4.7683715820312500e-06,
	1.8119812011718750e-05}, /* L1201 */
{2.6432023048400879e+00, 3.0249357223510742e-05,
	1.1920928955078125e-07, 1.9669532775878906e-05,
	7.0333480834960938e-06}, /* L1202 */
{2.3445589542388916e+00, 2.6971101760864258e-05,
	1.1920928955078125e-07, 1.2874603271484375e-05,
	-3.3378601074218750e-06}, /* L1203 */
{1.9561572074890137e+00, 2.2619962692260742e-05,
	1.1920928955078125e-07, 2.6226043701171875e-06,
	3.5762786865234375e-07}, /* L1204 */
{2.0115103721618652e+00, 2.3379921913146973e-05,
	1.1920928955078125e-07, 8.1062316894531250e-06,
	2.4199485778808594e-05}, /* L1205 */
{2.6887228488922119e+00, 3.1411647796630859e-05,
	1.1920928955078125e-07, -4.1723251342773438e-07,
	2.1457672119140625e-06}, /* L1206 */
{2.2429711818695068e+00, 2.6345252990722656e-05,
	1.1920928955078125e-07, 1.4436244964599609e-04,
	-5.9545040130615234e-05}, /* L1207 */
{2.2017180919647217e+00, 2.5987625122070312e-05,
	1.1920928955078125e-07, 8.4519386291503906e-05,
	-2.4557113647460938e-05}, /* L1208 */
{2.1833324432373047e+00, 2.5898218154907227e-05,
	1.1920928955078125e-07, -4.7147274017333984e-05,
	1.9073486328125000e-05}, /* L1209 */
{2.7066788673400879e+00, 3.2275915145874023e-05,
	1.1920928955078125e-07, 9.6917152404785156e-05,
	3.7431716918945312e-05}, /* L1210 */
{2.2679762840270996e+00, 2.7172267436981201e-05,
	1.1920928955078125e-07, -2.0503997802734375e-05,
	-8.4042549133300781e-06}, /* L1211 */
{2.2597937583923340e+00, 2.7209520339965820e-05,
	1.1920928955078125e-07, -2.0682811737060547e-05,
	-3.0577182769775391e-05}, /* L1212 */
{2.4088115692138672e+00, 2.9146671295166016e-05,
	1.1920928955078125e-07, 1.5497207641601562e-05,
	-4.5895576477050781e-06}, /* L1213 */
{2.9950757026672363e+00, 3.6418437957763672e-05,
	1.1920928955078125e-07, -1.2636184692382812e-05,
	-1.7046928405761719e-05}, /* L1214 */
{2.5846471786499023e+00, 3.1664967536926270e-05,
	1.1920928955078125e-07, 1.7772912979125977e-03,
	-2.7197599411010742e-04}, /* L1215 */
{2.6067717075347900e+00, 3.2007694244384766e-05,
	1.1920928955078125e-07, 1.5258789062500000e-05,
	-6.2584877014160156e-06}, /* L1216 */
{2.1771912574768066e+00, 2.6863068342208862e-05,
	1.1920928955078125e-07, -2.2053718566894531e-06,
	1.3709068298339844e-05}, /* L1217 */
{3.1068594455718994e+00, 3.8519501686096191e-05,
	1.1920928955078125e-07, 1.5497207641601562e-05,
	-6.7353248596191406e-06}, /* L1218 */
{2.5741207599639893e+00, 3.2067298889160156e-05,
	1.1920928955078125e-07, -8.5830688476562500e-06,
	1.5974044799804688e-05}, /* L1219 */
{3.2612531185150146e+00, 4.0821731090545654e-05,
	1.1920928955078125e-07, -6.0200691223144531e-06,
	-2.6702880859375000e-05}, /* L1220 */
{3.1061952114105225e+00, 3.9067119359970093e-05,
	1.1920928955078125e-07, 1.5139579772949219e-05,
	-3.5762786865234375e-07}, /* L1221 */
{3.9090692996978760e+00, 4.9397349357604980e-05,
	1.1920928955078125e-07, -8.5830688476562500e-06,
	-2.5033950805664062e-06}, /* L1222 */
{2.9082803726196289e+00, 3.6925077438354492e-05,
	1.1920928955078125e-07, -2.3841857910156250e-07,
	-6.5565109252929688e-07}, /* L1223 */
{2.2300553321838379e+00, 2.8446316719055176e-05,
	1.1920928955078125e-07, -1.8239021301269531e-05,
	-3.7372112274169922e-05}, /* L1224 */
{3.8737306594848633e+00, 4.9658119678497314e-05,
	1.1920928955078125e-07, -5.2392482757568359e-05,
	-1.5497207641601562e-05}, /* L1225 */
{2.3996686935424805e+00, 3.0897557735443115e-05,
	1.1920928955078125e-07, -7.5757503509521484e-05,
	-2.1457672119140625e-05}, /* L1226 */
{3.0302970409393311e+00, 3.9309263229370117e-05,
	1.1920928955078125e-07, 1.3022422790527344e-03,
	-4.0930509567260742e-04}, /* L1227 */
{2.0802607536315918e+00, 2.7030706405639648e-05,
	1.1920928955078125e-07, 5.4836273193359375e-06,
	5.8412551879882812e-06}, /* L1228 */
{3.0661604404449463e+00, 4.0024518966674805e-05,
	1.1920928955078125e-07, 1.5497207641601562e-06,
	8.7022781372070312e-06}, /* L1229 */
{2.2863128185272217e+00, 2.9981136322021484e-05,
	1.1920928955078125e-07, 1.6331672668457031e-05,
	-7.5697898864746094e-06}, /* L1230 */
{3.1289212703704834e+00, 4.1216611862182617e-05,
	1.1920928955078125e-07, 2.6226043701171875e-06,
	1.0728836059570312e-05}, /* L1231 */
{2.9346113204956055e+00, 3.8832426071166992e-05,
	1.1920928955078125e-07, -5.3644180297851562e-06,
	-1.4662742614746094e-05}, /* L1232 */
{2.3267719745635986e+00, 3.0927360057830811e-05,
	1.1920928955078125e-07, -1.1086463928222656e-05,
	8.1062316894531250e-06}, /* L1233 */
{2.2917885780334473e+00, 3.0666589736938477e-05,
	1.1920928955078125e-07, -5.5700540542602539e-04,
	-1.0199546813964844e-03}, /* L1234 */
{2.6463797092437744e+00, 3.5494565963745117e-05,
	1.1920928955078125e-07, -9.2387199401855469e-05,
	2.7060508728027344e-05}, /* L1235 */
{3.1678485870361328e+00, 4.2676925659179688e-05,
	1.1920928955078125e-07, -6.3180923461914062e-06,
	-2.4437904357910156e-06}, /* L1236 */
{3.2464599609375000e+00, 4.3928623199462891e-05,
	1.1920928955078125e-07, -1.5497207641601562e-05,
	3.7074089050292969e-05}, /* L1237 */
{3.2306761741638184e+00, 4.3913722038269043e-05,
	1.1920928955078125e-07, -7.1525573730468750e-06,
	2.9206275939941406e-05}, /* L1238 */
{2.3965263366699219e+00, 3.2735988497734070e-05,
	1.1920928955078125e-07, -2.4777650833129883e-04,
	1.2147426605224609e-04}, /* L1239 */
{3.2906377315521240e+00, 4.5120716094970703e-05,
	1.1920928955078125e-07, -3.4153461456298828e-05,
	-2.9683113098144531e-05}, /* L1240 */
{3.3776614665985107e+00, 4.6506524085998535e-05,
	1.1920928955078125e-07, -3.5166740417480469e-06,
	1.7881393432617188e-06}, /* L1241 */
{2.7369720935821533e+00, 3.7848949432373047e-05,
	1.1920928955078125e-07, -1.0728836059570312e-06,
	-1.0132789611816406e-05}, /* L1242 */
{4.4909911155700684e+00, 6.2376260757446289e-05,
	1.1920928955078125e-07, 1.1205673217773438e-05,
	-2.4378299713134766e-05}, /* L1243 */
{2.6878952980041504e+00, 3.7491321563720703e-05,
	1.1920928955078125e-07, -4.3272972106933594e-05,
	-4.2140483856201172e-05}, /* L1244 */
{2.1084623336791992e+00, 2.9534101486206055e-05,
	1.1920928955078125e-07, -1.0192394256591797e-05,
	1.3828277587890625e-05}, /* L1245 */
{2.8241481781005859e+00, 3.9726495742797852e-05,
	1.1920928955078125e-07, 2.8610229492187500e-06,
	-3.1590461730957031e-06}, /* L1246 */
{3.9472033977508545e+00, 5.5767595767974854e-05,
	1.1920928955078125e-07, 8.8214874267578125e-06,
	4.2200088500976562e-05}, /* L1247 */
{2.7856087684631348e+00, 3.9517879486083984e-05,
	1.1920928955078125e-07, 2.7418136596679688e-06,
	-2.5153160095214844e-05}, /* L1248 */
{3.1797544956207275e+00, 4.5299530029296875e-05,
	1.1920928955078125e-07, 4.0054321289062500e-05,
	4.0769577026367188e-05}, /* L1249 */
{3.2002224922180176e+00, 4.5806169509887695e-05,
	1.1920928955078125e-07, 3.5643577575683594e-05,
	1.0037422180175781e-04}, /* L1250 */
{2.9428439140319824e+00, 4.2289495468139648e-05,
	1.1920928955078125e-07, -5.0783157348632812e-05,
	3.9577484130859375e-05}, /* L1251 */
{3.3541893959045410e+00, 4.8384070396423340e-05,
	1.1920928955078125e-07, -2.4616718292236328e-05,
	-5.4121017456054688e-05}, /* L1252 */
{3.0121967792510986e+00, 4.3645501136779785e-05,
	1.1920928955078125e-07, -2.5999546051025391e-04,
	-1.1211633682250977e-04}, /* L1253 */
{2.7211909294128418e+00, 3.9577484130859375e-05,
	1.1920928955078125e-07, -1.9967555999755859e-05,
	1.7881393432617188e-06}, /* L1254 */
{2.6671855449676514e+00, 3.8951635360717773e-05,
	1.1920928955078125e-07, 4.1365623474121094e-05,
	9.5367431640625000e-07}, /* L1255 */
{3.5121285915374756e+00, 5.1498413085937500e-05,
	1.1920928955078125e-07, 1.6093254089355469e-05,
	3.4570693969726562e-06}, /* L1256 */
{2.9267933368682861e+00, 4.3094158172607422e-05,
	1.1920928955078125e-07, -7.1227550506591797e-05,
	-6.4253807067871094e-05}, /* L1257 */
{2.5106649398803711e+00, 3.7118792533874512e-05,
	1.1920928955078125e-07, 2.5391578674316406e-05,
	1.5211105346679688e-04}, /* L1258 */
{2.4577031135559082e+00, 3.6492943763732910e-05,
	1.1920928955078125e-07, -4.3272972106933594e-05,
	-3.0696392059326172e-05}, /* L1259 */
{3.2924635410308838e+00, 4.9069523811340332e-05,
	1.1920928955078125e-07, -6.5565109252929688e-05,
	-1.0550022125244141e-05}, /* L1260 */
{3.1647403240203857e+00, 4.7355890274047852e-05,
	1.1920928955078125e-07, 2.5033950805664062e-06,
	5.3405761718750000e-05}, /* L1261 */
{2.5652899742126465e+00, 3.8534402847290039e-05,
	1.1920928955078125e-07, 1.5497207641601562e-05,
	-7.1525573730468750e-06}, /* L1262 */
{3.0589282512664795e+00, 4.6133995056152344e-05,
	1.1920928955078125e-07, -1.3053417205810547e-05,
	-6.1035156250000000e-05}, /* L1263 */
{3.4289965629577637e+00, 5.1915645599365234e-05,
	1.1920928955078125e-07, -3.9935111999511719e-06,
	3.8862228393554688e-05}, /* L1264 */
{3.9899127483367920e+00, 6.0647726058959961e-05,
	1.1920928955078125e-07, -2.8550624847412109e-05,
	-3.5762786865234375e-07}, /* L1265 */
{2.8133091926574707e+00, 4.2930245399475098e-05,
	1.1920928955078125e-07, 1.9907951354980469e-05,
	-2.7418136596679688e-06}, /* L1266 */
{3.9885497093200684e+00, 6.1154365539550781e-05,
	1.1920928955078125e-07, -1.3113021850585938e-05,
	-1.2624263763427734e-04}, /* L1267 */
{3.0203218460083008e+00, 4.6454370021820068e-05,
	1.1920928955078125e-07, -1.1920928955078125e-05,
	-7.1287155151367188e-05}, /* L1268 */
{2.6234917640686035e+00, 4.0501356124877930e-05,
	1.1920928955078125e-07, -1.1265277862548828e-05,
	-8.7022781372070312e-06}, /* L1269 */
{3.4784512519836426e+00, 5.3912401199340820e-05,
	1.1920928955078125e-07, 1.5974044799804688e-05,
	-4.1723251342773438e-06}, /* L1270 */
{5.2191519737243652e+00, 8.1203877925872803e-05,
	1.1920928955078125e-07, 3.8146972656250000e-05,
	3.6478042602539062e-05}, /* L1271 */
{3.7924778461456299e+00, 5.9247016906738281e-05,
	1.1920928955078125e-07, 2.7549266815185547e-04,
	-3.7968158721923828e-05}, /* L1272 */
{3.3542623519897461e+00, 5.2586197853088379e-05,
	1.1920928955078125e-07, 4.5776367187500000e-05,
	-6.7532062530517578e-05}, /* L1273 */
{3.5926158428192139e+00, 5.6535005569458008e-05,
	1.1920928955078125e-07, -5.6028366088867188e-06,
	2.7656555175781250e-05}, /* L1274 */
{3.5994863510131836e+00, 5.6862831115722656e-05,
	1.1920928955078125e-07, -6.7114830017089844e-05,
	-6.7353248596191406e-05}, /* L1275 */
{3.8888278007507324e+00, 6.1661005020141602e-05,
	1.1920928955078125e-07, 3.2663345336914062e-05,
	3.3378601074218750e-05}, /* L1276 */
{3.9306416511535645e+00, 6.2577426433563232e-05,
	1.1920928955078125e-07, -8.1419944763183594e-05,
	-2.8014183044433594e-05}, /* L1277 */
{2.8954002857208252e+00, 4.6253204345703125e-05,
	1.1920928955078125e-07, 1.6450881958007812e-05,
	-9.8943710327148438e-06}, /* L1278 */
{2.8672094345092773e+00, 4.5999884605407715e-05,
	1.1920928955078125e-07, 7.4505805969238281e-05,
	-4.9054622650146484e-05}, /* L1279 */
{2.3275427818298340e+00, 3.7461519241333008e-05,
	1.1920928955078125e-07, -5.2809715270996094e-05,
	-3.3557415008544922e-05}, /* L1280 */
{2.8670883178710938e+00, 4.6312808990478516e-05,
	1.1920928955078125e-07, -1.8060207366943359e-05,
	-1.4662742614746094e-05}, /* L1281 */
{3.5310692787170410e+00, 5.7250261306762695e-05,
	1.1920928955078125e-07, -4.3511390686035156e-06,
	1.8477439880371094e-05}, /* L1282 */
{3.8918013572692871e+00, 6.3329935073852539e-05,
	1.1920928955078125e-07, 7.3909759521484375e-06,
	-1.0848045349121094e-05}, /* L1283 */
{3.1068062782287598e+00, 5.0749629735946655e-05,
	1.1920928955078125e-07, -5.3644180297851562e-05,
	-2.7418136596679688e-05}, /* L1284 */
{2.8671267032623291e+00, 4.6998262405395508e-05,
	1.1920928955078125e-07, -9.5367431640625000e-07,
	1.3351440429687500e-05}, /* L1285 */
{3.5216612815856934e+00, 5.7935714721679688e-05,
	1.1920928955078125e-07, -1.4781951904296875e-05,
	-8.7022781372070312e-06}, /* L1286 */
{2.7244505882263184e+00, 4.5001506805419922e-05,
	1.1920928955078125e-07, 1.8489360809326172e-04,
	-1.6993284225463867e-04}, /* L1287 */
{3.3593361377716064e+00, 5.5670738220214844e-05,
	1.1920928955078125e-07, -3.6418437957763672e-05,
	2.0742416381835938e-05}, /* L1288 */
{2.6397724151611328e+00, 4.3898820877075195e-05,
	1.1920928955078125e-07, -1.1086463928222656e-05,
	8.3446502685546875e-07}, /* L1289 */
{3.2254927158355713e+00, 5.3852796554565430e-05,
	1.1920928955078125e-07, -3.0815601348876953e-05,
	1.1920928955078125e-07}, /* L1290 */
{3.3631930351257324e+00, 5.6341290473937988e-05,
	1.1920928955078125e-07, -6.7949295043945312e-06,
	5.9962272644042969e-05}, /* L1291 */
{3.4079694747924805e+00, 5.7285651564598083e-05,
	1.1920928955078125e-07, -3.6001205444335938e-05,
	2.8610229492187500e-06}, /* L1292 */
{2.8880021572113037e+00, 4.8749148845672607e-05,
	1.1920928955078125e-07, -5.7220458984375000e-06,
	-1.2904405593872070e-04}, /* L1293 */
{3.8768889904022217e+00, 6.5632164478302002e-05,
	1.1920928955078125e-07, -4.0531158447265625e-06,
	3.4093856811523438e-05}, /* L1294 */
{3.2189145088195801e+00, 5.4687261581420898e-05,
	1.1920928955078125e-07, -2.3305416107177734e-05,
	-1.7583370208740234e-05}, /* L1295 */
{2.7826395034790039e+00, 4.7439709305763245e-05,
	1.1920928955078125e-07, -8.6188316345214844e-05,
	-1.3828277587890625e-05}, /* L1296 */
{2.9319143295288086e+00, 5.0157308578491211e-05,
	1.1920928955078125e-07, 1.3709068298339844e-05,
	-2.3841857910156250e-07}, /* L1297 */
{4.1965179443359375e+00, 7.2211027145385742e-05,
	1.1920928955078125e-07, -2.0766258239746094e-04,
	3.7491321563720703e-04}, /* L1298 */
{3.0189342498779297e+00, 5.2005052566528320e-05,
	1.1920928955078125e-07, 8.4638595581054688e-06,
	4.5299530029296875e-06}, /* L1299 */
{2.9598660469055176e+00, 5.1163136959075928e-05,
	1.1920928955078125e-07, -2.9206275939941406e-06,
	-2.3841857910156250e-06}, /* L1300 */
{4.8141779899597168e+00, 8.3506107330322266e-05,
	1.1920928955078125e-07, 2.9206275939941406e-05,
	-1.7285346984863281e-06}, /* L1301 */
{3.1006553173065186e+00, 5.3977011702954769e-05,
	1.1920928955078125e-07, 7.7128410339355469e-05,
	-1.2838840484619141e-04}, /* L1302 */
{2.6993238925933838e+00, 4.7147274017333984e-05,
	1.1920928955078125e-07, 4.4345855712890625e-05,
	-1.0132789611816406e-06}, /* L1303 */
{4.3526625633239746e+00, 7.6293945312500000e-05,
	1.1920928955078125e-07, 7.2121620178222656e-05,
	-2.3025274276733398e-04}, /* L1304 */
{4.0632801055908203e+00, 7.1555376052856445e-05,
	1.1920928955078125e-07, 1.8525123596191406e-04,
	4.5967102050781250e-04}, /* L1305 */
{6.7649230957031250e+00, 1.1935830116271973e-04,
	1.1920928955078125e-07, 1.1682510375976562e-05,
	1.9550323486328125e-05}, /* L1306 */
{4.0029668807983398e+00, 7.0869922637939453e-05,
	1.1920928955078125e-07, -1.7702579498291016e-05,
	-7.0333480834960938e-06}, /* L1307 */
{5.3224954605102539e+00, 9.4577670097351074e-05,
	1.1920928955078125e-07, 4.6491622924804688e-05,
	1.4436244964599609e-04}, /* L1308 */
{3.4629216194152832e+00, 6.1720609664916992e-05,
	1.1920928955078125e-07, 2.2411346435546875e-05,
	-2.9981136322021484e-05}, /* L1309 */
{3.6836194992065430e+00, 6.5892934799194336e-05,
	1.1920928955078125e-07, 1.6975402832031250e-04,
	-2.0557641983032227e-04}, /* L1310 */
{3.7666192054748535e+00, 6.7591667175292969e-05,
	1.1920928955078125e-07, -1.2642145156860352e-04,
	-3.4868717193603516e-05}, /* L1311 */
{3.0687901973724365e+00, 5.5253505706787109e-05,
	1.1920928955078125e-07, -2.9146671295166016e-05,
	2.9563903808593750e-05}, /* L1312 */
{2.6712586879730225e+00, 4.8249959945678711e-05,
	1.1920928955078125e-07, 3.4928321838378906e-05,
	-5.0127506256103516e-05}, /* L1313 */
{3.4850175380706787e+00, 6.3151121139526367e-05,
	1.1920928955078125e-07, 2.9563903808593750e-05,
	-3.0398368835449219e-06}, /* L1314 */
{3.4851601123809814e+00, 6.3360668718814850e-05,
	1.1920928955078125e-07, 3.4570693969726562e-06,
	-9.7155570983886719e-06}, /* L1315 */
{3.3319339752197266e+00, 6.0796737670898438e-05,
	1.1920928955078125e-07, 1.0681152343750000e-04,
	1.6474723815917969e-04}, /* L1316 */
{5.1887230873107910e+00, 9.4980001449584961e-05,
	1.1920928955078125e-07, -4.0411949157714844e-05,
	3.7908554077148438e-05}, /* L1317 */
{5.3918108940124512e+00, 9.8999589681625366e-05,
	1.1920928955078125e-07, 2.6702880859375000e-05,
	-4.9293041229248047e-05}, /* L1318 */
{3.7143328189849854e+00, 6.8426132202148438e-05,
	1.1920928955078125e-07, 2.7656555175781250e-05,
	-5.5789947509765625e-05}, /* L1319 */
{3.5686254501342773e+00, 6.5952539443969727e-05,
	1.1920928955078125e-07, -1.0555982589721680e-04,
	-1.0311603546142578e-05}, /* L1320 */
{4.0656347274780273e+00, 7.5370073318481445e-05,
	1.1920928955078125e-07, -2.6106834411621094e-05,
	2.5153160095214844e-05}, /* L1321 */
{4.2824273109436035e+00, 7.9661607742309570e-05,
	1.1920928955078125e-07, -1.9639730453491211e-04,
	-1.2457370758056641e-05}, /* L1322 */
{3.5407865047454834e+00, 6.6071748733520508e-05,
	1.1920928955078125e-07, 1.6641616821289062e-04,
	1.1157989501953125e-04}, /* L1323 */
{3.4998750686645508e+00, 6.5505504608154297e-05,
	1.1920928955078125e-07, -1.4424324035644531e-05,
	2.6583671569824219e-05}, /* L1324 */
{3.6763875484466553e+00, 6.9029629230499268e-05,
	1.1920928955078125e-07, 4.1007995605468750e-05,
	-2.9802322387695312e-06}, /* L1325 */
{5.0139293670654297e+00, 9.4443559646606445e-05,
	1.1920928955078125e-07, -7.1465969085693359e-05,
	-2.9385089874267578e-05}, /* L1326 */
{4.4658980369567871e+00, 8.4385275840759277e-05,
	1.1920928955078125e-07, 1.3113021850585938e-05,
	-1.7285346984863281e-06}, /* L1327 */
{3.1854162216186523e+00, 6.0379505157470703e-05,
	1.1920928955078125e-07, -1.7583370208740234e-05,
	1.8835067749023438e-05}, /* L1328 */
{3.8384883403778076e+00, 7.2985887527465820e-05,
	1.1920928955078125e-07, 2.1815299987792969e-05,
	-1.2397766113281250e-05}, /* L1329 */
{3.4356751441955566e+00, 6.5535306930541992e-05,
	1.1920928955078125e-07, -1.2516975402832031e-06,
	2.8729438781738281e-05}, /* L1330 */
{2.9541642665863037e+00, 5.6564807891845703e-05,
	1.1920928955078125e-07, 7.5137615203857422e-04,
	-2.8008222579956055e-04}, /* L1331 */
{3.7685103416442871e+00, 7.2330236434936523e-05,
	1.1920928955078125e-07, -1.6391277313232422e-05,
	-2.3543834686279297e-05}, /* L1332 */
{3.7530016899108887e+00, 7.2270631790161133e-05,
	1.1920928955078125e-07, 1.9073486328125000e-06,
	-3.3736228942871094e-05}, /* L1333 */
{3.2955565452575684e+00, 6.3657760620117188e-05,
	1.1920928955078125e-07, 2.4437904357910156e-05,
	1.7166137695312500e-05}, /* L1334 */
{4.7795829772949219e+00, 9.2595815658569336e-05,
	1.1920928955078125e-07, -1.2874603271484375e-05,
	-8.3446502685546875e-07}, /* L1335 */
{3.7617290019989014e+00, 7.3105096817016602e-05,
	1.1920928955078125e-07, 5.3763389587402344e-05,
	-3.1888484954833984e-05}, /* L1336 */
{3.8056991100311279e+00, 7.4177980422973633e-05,
	1.1920928955078125e-07, 3.4570693969726562e-06,
	-1.3113021850585938e-06}, /* L1337 */
{4.3724923133850098e+00, 8.5502862930297852e-05,
	1.1920928955078125e-07, -8.7857246398925781e-05,
	-2.7942657470703125e-04}, /* L1338 */
{3.7000031471252441e+00, 7.2583556175231934e-05,
	1.1920928955078125e-07, 2.2530555725097656e-05,
	-3.5464763641357422e-05}, /* L1339 */
{3.9001255035400391e+00, 7.6718628406524658e-05,
	1.1920928955078125e-07, -8.7797641754150391e-05,
	-1.4483928680419922e-05}, /* L1340 */
{4.4363026618957520e+00, 8.7529420852661133e-05,
	1.1920928955078125e-07, 7.1525573730468750e-07,
	3.8146972656250000e-06}, /* L1341 */
{4.4184427261352539e+00, 8.7440013885498047e-05,
	1.1920928955078125e-07, 2.4437904357910156e-05,
	2.3245811462402344e-05}, /* L1342 */
{3.0645101070404053e+00, 6.0901045799255371e-05,
	1.1920928955078125e-07, 2.5093555450439453e-04,
	5.7590007781982422e-04}, /* L1343 */
{3.2422950267791748e+00, 6.4581632614135742e-05,
	1.1920928955078125e-07, 1.7821788787841797e-04,
	5.9723854064941406e-05}, /* L1344 */
{3.6899039745330811e+00, 7.3730945587158203e-05,
	1.1920928955078125e-07, 1.9395351409912109e-04,
	9.5248222351074219e-05}, /* L1345 */
{3.9974186420440674e+00, 8.0078840255737305e-05,
	1.1920928955078125e-07, 4.6491622924804688e-05,
	-1.2278556823730469e-05}, /* L1346 */
{3.4381773471832275e+00, 6.9111585617065430e-05,
	1.1920928955078125e-07, -9.4294548034667969e-05,
	1.8656253814697266e-04}, /* L1347 */
{3.3473718166351318e+00, 6.7442655563354492e-05,
	1.1920928955078125e-07, 9.3460083007812500e-05,
	1.1563301086425781e-05}, /* L1348 */
{4.7897124290466309e+00, 9.6812844276428223e-05,
	1.1920928955078125e-07, -2.9861927032470703e-05,
	4.1842460632324219e-05}, /* L1349 */
{4.7768397331237793e+00, 9.6887350082397461e-05,
	1.1920928955078125e-07, 1.5878677368164062e-04,
	2.6476383209228516e-04}, /* L1350 */
{4.2064580917358398e+00, 8.5502862930297852e-05,
	1.1920928955078125e-07, 5.4001808166503906e-05,
	4.6372413635253906e-05}, /* L1351 */
{3.8003456592559814e+00, 7.7471137046813965e-05,
	1.1920928955078125e-07, 7.5101852416992188e-06,
	1.2636184692382812e-05}, /* L1352 */
{3.1709525585174561e+00, 6.4849853515625000e-05,
	1.1920928955078125e-07, 1.5330314636230469e-04,
	4.6968460083007812e-05}, /* L1353 */
{4.8793897628784180e+00, 1.0005198419094086e-04,
	1.1920928955078125e-07, 3.0994415283203125e-06,
	-2.5868415832519531e-05}, /* L1354 */
{4.4213376045227051e+00, 9.0926885604858398e-05,
	1.1920928955078125e-07, -1.3351440429687500e-05,
	-6.2227249145507812e-05}, /* L1355 */
{3.8869545459747314e+00, 8.0168247222900391e-05,
	1.1920928955078125e-07, 3.6239624023437500e-05,
	1.4305114746093750e-05}, /* L1356 */
{4.4384484291076660e+00, 9.1813504695892334e-05,
	1.1920928955078125e-07, 5.1379203796386719e-05,
	3.9458274841308594e-05}, /* L1357 */
{3.3497838973999023e+00, 6.9588422775268555e-05,
	1.1920928955078125e-07, 1.0526180267333984e-04,
	-4.7951936721801758e-04}, /* L1358 */
{4.2968616485595703e+00, 8.9406967163085938e-05,
	1.1920928955078125e-07, -5.0067901611328125e-06,
	-1.2087821960449219e-04}, /* L1359 */
{3.2734379768371582e+00, 6.8306922912597656e-05,
	1.1920928955078125e-07, 4.7683715820312500e-05,
	5.4121017456054688e-05}, /* L1360 */
{3.7476680278778076e+00, 7.8409910202026367e-05,
	1.1920928955078125e-07, -5.9604644775390625e-08,
	-2.1874904632568359e-05}, /* L1361 */
{2.6689467430114746e+00, 5.5998563766479492e-05,
	1.1920928955078125e-07, 1.8835067749023438e-05,
	6.7949295043945312e-06}, /* L1362 */
{4.1301960945129395e+00, 8.6911022663116455e-05,
	1.1920928955078125e-07, -8.0823898315429688e-05,
	-5.5909156799316406e-05}, /* L1363 */
{3.7226531505584717e+00, 7.8558921813964844e-05,
	1.1920928955078125e-07, -8.6426734924316406e-06,
	-1.4024972915649414e-04}, /* L1364 */
{4.2799062728881836e+00, 9.0651214122772217e-05,
	1.1920928955078125e-07, 1.0025501251220703e-04,
	9.7906589508056641e-04}, /* L1365 */
{4.6442990303039551e+00, 9.8556280136108398e-05,
	1.1920928955078125e-07, -5.0663948059082031e-06,
	3.0994415283203125e-06}, /* L1366 */
{4.7994618415832520e+00, 1.0213255882263184e-04,
	1.1920928955078125e-07, -4.9412250518798828e-05,
	1.4543533325195312e-05}, /* L1367 */
{3.9578948020935059e+00, 8.4459781646728516e-05,
	1.1920928955078125e-07, -3.6954879760742188e-05,
	-1.0728836059570312e-05}, /* L1368 */
{4.7142872810363770e+00, 1.0088086128234863e-04,
	1.1920928955078125e-07, 2.0503997802734375e-05,
	-3.2603740692138672e-05}, /* L1369 */
{5.0617432594299316e+00, 1.0862946510314941e-04,
	1.1920928955078125e-07, -1.1181831359863281e-04,
	4.1246414184570312e-05}, /* L1370 */
{5.4651422500610352e+00, 1.1759996414184570e-04,
	1.1920928955078125e-07, -2.6047229766845703e-05,
	1.0728836059570312e-05}, /* L1371 */
{4.6017537117004395e+00, 9.9293887615203857e-05,
	1.1920928955078125e-07, 1.2516975402832031e-05,
	-3.6478042602539062e-05}, /* L1372 */
{4.5816631317138672e+00, 9.9137425422668457e-05,
	1.1920928955078125e-07, 3.6954879760742188e-06,
	2.1100044250488281e-05}, /* L1373 */
{4.7823390960693359e+00, 1.0377168655395508e-04,
	1.1920928955078125e-07, -1.3709068298339844e-05,
	-1.1742115020751953e-05}, /* L1374 */
{4.1994113922119141e+00, 9.1386958956718445e-05,
	1.1920928955078125e-07, -6.6399574279785156e-05,
	9.4413757324218750e-05}, /* L1375 */
{4.8262686729431152e+00, 1.0529160499572754e-04,
	1.1920928955078125e-07, 2.7537345886230469e-05,
	7.2717666625976562e-06}, /* L1376 */
{3.3819701671600342e+00, 7.3999166488647461e-05,
	1.1920928955078125e-07, 7.6889991760253906e-05,
	1.5044212341308594e-04}, /* L1377 */
{3.3624505996704102e+00, 7.3760747909545898e-05,
	1.1920928955078125e-07, -3.3974647521972656e-05,
	2.9444694519042969e-05}, /* L1378 */
{4.9617981910705566e+00, 1.0913610458374023e-04,
	1.1920928955078125e-07, -1.7285346984863281e-06,
	-2.4974346160888672e-05}, /* L1379 */
{3.5646283626556396e+00, 7.8618526458740234e-05,
	1.1920928955078125e-07, 1.1563301086425781e-05,
	-1.9013881683349609e-05}, /* L1380 */
{3.5102624893188477e+00, 7.7642500400543213e-05,
	1.1920928955078125e-07, -3.1173229217529297e-05,
	9.8705291748046875e-05}, /* L1381 */
{6.0708155632019043e+00, 1.3461709022521973e-04,
	1.1920928955078125e-07, 5.2452087402343750e-06,
	2.3245811462402344e-05}, /* L1382 */
{5.0780024528503418e+00, 1.1290609836578369e-04,
	1.1920928955078125e-07, -2.0861625671386719e-05,
	-1.4662742614746094e-05}, /* L1383 */
{4.7435007095336914e+00, 1.0645389556884766e-04,
	1.1920928955078125e-07, 3.3431053161621094e-03,
	3.3942461013793945e-03}, /* L1384 */
{4.6372504234313965e+00, 1.0368227958679199e-04,
	1.1920928955078125e-07, -3.0100345611572266e-05,
	8.4877014160156250e-05}, /* L1385 */
{4.3456716537475586e+00, 9.7418669611215591e-05,
	1.1920928955078125e-07, 2.8550624847412109e-04,
	1.4424324035644531e-05}, /* L1386 */
{4.2961630821228027e+00, 9.6589326858520508e-05,
	1.1920928955078125e-07, 6.7949295043945312e-05,
	3.3974647521972656e-05}, /* L1387 */
{4.9144001007080078e+00, 1.1077523231506348e-04,
	1.1920928955078125e-07, 1.0597705841064453e-04,
	-6.3776969909667969e-06}, /* L1388 */
{4.4230256080627441e+00, 9.9927186965942383e-05,
	1.1920928955078125e-07, 2.7418136596679688e-05,
	-4.2319297790527344e-06}, /* L1389 */
{4.6450762748718262e+00, 1.0521709918975830e-04,
	1.1920928955078125e-07, 5.8412551879882812e-05,
	6.1631202697753906e-05}, /* L1390 */
{3.1887686252593994e+00, 7.2419643402099609e-05,
	1.1920928955078125e-07, 1.9311904907226562e-05,
	1.5497207641601562e-05}, /* L1391 */
{6.2474112510681152e+00, 1.4239549636840820e-04,
	1.1920928955078125e-07, -1.8680095672607422e-04,
	3.9577484130859375e-04}, /* L1392 */
{4.5461459159851074e+00, 1.0380148887634277e-04,
	1.1920928955078125e-07, -4.9412250518798828e-05,
	1.2040138244628906e-05}, /* L1393 */
{5.0377044677734375e+00, 1.1539459228515625e-04,
	1.1920928955078125e-07, -4.3505430221557617e-04,
	-8.9287757873535156e-05}, /* L1394 */
{6.0852775573730469e+00, 1.3966858386993408e-04,
	1.1920928955078125e-07, 1.6927719116210938e-05,
	4.3869018554687500e-05}, /* L1395 */
{4.5087976455688477e+00, 1.0374188423156738e-04,
	1.1920928955078125e-07, 2.1219253540039062e-05,
	7.1525573730468750e-06}, /* L1396 */
{5.5137805938720703e+00, 1.2719631195068359e-04,
	1.1920928955078125e-07, -1.8596649169921875e-05,
	-1.7404556274414062e-05}, /* L1397 */
{3.8598725795745850e+00, 8.9272856712341309e-05,
	1.1920928955078125e-07, 2.0146369934082031e-05,
	-1.8179416656494141e-05}, /* L1398 */
{3.4021766185760498e+00, 7.8886747360229492e-05,
	1.1920928955078125e-07, 2.3961067199707031e-05,
	3.1590461730957031e-05}, /* L1399 */
{5.9166455268859863e+00, 1.3754516839981079e-04,
	1.1920928955078125e-07, 1.0609626770019531e-05,
	-1.8179416656494141e-05}, /* L1400 */
{3.1801805496215820e+00, 7.4118375778198242e-05,
	1.1920928955078125e-07, -7.0333480834960938e-06,
	-7.0929527282714844e-06}, /* L1401 */
{4.5846505165100098e+00, 1.0737776756286621e-04,
	1.1920928955078125e-07, -2.8544664382934570e-04,
	1.0683536529541016e-03}, /* L1402 */
{6.6109290122985840e+00, 1.5487521886825562e-04,
	1.1920928955078125e-07, 7.2717666625976562e-06,
	-7.2121620178222656e-06}, /* L1403 */
{4.8248658180236816e+00, 1.1331588029861450e-04,
	1.1920928955078125e-07, -1.2457370758056641e-05,
	2.3961067199707031e-05}, /* L1404 */
{5.3237805366516113e+00, 1.2554973363876343e-04,
	1.1920928955078125e-07, -3.0612945556640625e-04,
	2.4306774139404297e-04}, /* L1405 */
{4.9872794151306152e+00, 1.1783838272094727e-04,
	1.1920928955078125e-07, -2.5516748428344727e-04,
	2.8669834136962891e-04}, /* L1406 */
{4.0393199920654297e+00, 9.5590949058532715e-05,
	1.1920928955078125e-07, -1.1384487152099609e-05,
	-4.3869018554687500e-05}, /* L1407 */
{3.8832790851593018e+00, 9.2133879661560059e-05,
	1.1920928955078125e-07, -2.1874904632568359e-05,
	6.3776969909667969e-05}, /* L1408 */
{5.4100017547607422e+00, 1.2868829071521759e-04,
	1.1920928955078125e-07, 1.7285346984863281e-05,
	-2.9802322387695312e-05}, /* L1409 */
{4.4211664199829102e+00, 1.0542571544647217e-04,
	1.1920928955078125e-07, 5.5551528930664062e-05,
	3.5881996154785156e-05}, /* L1410 */
{3.2668707370758057e+00, 7.8089535236358643e-05,
	1.1920928955078125e-07, 4.8637390136718750e-05,
	-4.0173530578613281e-05}, /* L1411 */
{6.1488976478576660e+00, 1.4734268188476562e-04,
	1.1920928955078125e-07, 2.3245811462402344e-05,
	1.5020370483398438e-05}, /* L1412 */
{5.3101110458374023e+00, 1.2756884098052979e-04,
	1.1920928955078125e-07, 2.7537345886230469e-05,
	-5.4538249969482422e-05}, /* L1413 */
{5.2199330329895020e+00, 1.2570619583129883e-04,
	1.1920928955078125e-07, -1.7344951629638672e-05,
	-2.4914741516113281e-05}, /* L1414 */
{4.4799566268920898e+00, 1.0815262794494629e-04,
	1.1920928955078125e-07, 1.3589859008789062e-05,
	6.7591667175292969e-05}, /* L1415 */
{5.8589501380920410e+00, 1.4179944992065430e-04,
	1.1920928955078125e-07, -7.7068805694580078e-05,
	3.6120414733886719e-05}, /* L1416 */
{3.6312186717987061e+00, 8.8095664978027344e-05,
	1.1920928955078125e-07, 2.5153160095214844e-05,
	7.9870223999023438e-06}, /* L1417 */
{4.9162602424621582e+00, 1.1957436800003052e-04,
	1.1920928955078125e-07, -4.2915344238281250e-06,
	-7.6234340667724609e-05}, /* L1418 */
{4.8697094917297363e+00, 1.1873245239257812e-04,
	1.1920928955078125e-07, -3.2007694244384766e-05,
	-1.1289119720458984e-04}, /* L1419 */
{5.6039214134216309e+00, 1.3706088066101074e-04,
	1.1920928955078125e-07, -8.9526176452636719e-05,
	-1.2260675430297852e-04}, /* L1420 */
{6.0624976158142090e+00, 1.4853477478027344e-04,
	1.1920928955078125e-07, -9.6559524536132812e-06,
	5.6385993957519531e-05}, /* L1421 */
{5.2167501449584961e+00, 1.2812018394470215e-04,
	1.1920928955078125e-07, -1.0073184967041016e-05,
	1.4543533325195312e-05}, /* L1422 */
{4.6749162673950195e+00, 1.1511531192809343e-04,
	1.1920928955078125e-07, -2.1779537200927734e-04,
	9.8466873168945312e-05}, /* L1423 */
{4.3700361251831055e+00, 1.0785460472106934e-04,
	1.1920928955078125e-07, 5.8531761169433594e-05,
	-1.4722347259521484e-05}, /* L1424 */
{4.4332079887390137e+00, 1.0967254638671875e-04,
	1.1920928955078125e-07, 1.7166137695312500e-05,
	1.8596649169921875e-05}, /* L1425 */
{5.1984019279479980e+00, 1.2895464897155762e-04,
	1.1920928955078125e-07, 1.5163421630859375e-04,
	-6.1392784118652344e-06}, /* L1426 */
{4.1160373687744141e+00, 1.0234117507934570e-04,
	1.1920928955078125e-07, -1.2093782424926758e-04,
	2.0217895507812500e-04}, /* L1427 */
{4.6941976547241211e+00, 1.1697411537170410e-04,
	1.1920928955078125e-07, 9.5486640930175781e-05,
	1.6212463378906250e-05}, /* L1428 */
{4.7335615158081055e+00, 1.1822581291198730e-04,
	1.1920928955078125e-07, -2.1815299987792969e-05,
	6.8664550781250000e-05}, /* L1429 */
{5.0993728637695312e+00, 1.2767314910888672e-04,
	1.1920928955078125e-07, -5.8770179748535156e-05,
	-2.1100044250488281e-05}, /* L1430 */
{6.7603044509887695e+00, 1.6964972019195557e-04,
	1.1920928955078125e-07, 6.4373016357421875e-06,
	2.3841857910156250e-07}, /* L1431 */
{3.6456432342529297e+00, 9.1709196567535400e-05,
	1.1920928955078125e-07, -3.5166740417480469e-05,
	2.4676322937011719e-05}, /* L1432 */
{3.6505048274993896e+00, 9.2049129307270050e-05,
	1.1920928955078125e-07, -4.0769577026367188e-05,
	1.8000602722167969e-05}, /* L1433 */
{4.8351521492004395e+00, 1.2222677469253540e-04,
	1.1920928955078125e-07, -2.5051832199096680e-04,
	-1.1861324310302734e-05}, /* L1434 */
{4.3703279495239258e+00, 1.1071562767028809e-04,
	1.1920928955078125e-07, 4.8398971557617188e-05,
	-2.6881694793701172e-05}, /* L1435 */
{6.1353759765625000e+00, 1.5580654144287109e-04,
	1.1920928955078125e-07, -8.7022781372070312e-06,
	-5.8114528656005859e-05}, /* L1436 */
{5.5625419616699219e+00, 1.4159083366394043e-04,
	1.1920928955078125e-07, -3.4868717193603516e-05,
	5.0902366638183594e-05}, /* L1437 */
{3.5406966209411621e+00, 9.0330839157104492e-05,
	1.1920928955078125e-07, -3.9935111999511719e-06,
	4.5299530029296875e-06}, /* L1438 */
{4.2404432296752930e+00, 1.0858476161956787e-04,
	1.1920928955078125e-07, 1.5187263488769531e-04,
	4.1961669921875000e-05}, /* L1439 */
{4.8489222526550293e+00, 1.2429058551788330e-04,
	1.1920928955078125e-07, 4.5895576477050781e-05,
	-2.3126602172851562e-05}, /* L1440 */
{4.3888530731201172e+00, 1.1283159255981445e-04,
	1.1920928955078125e-07, -2.3812055587768555e-04,
	-1.8435716629028320e-04}, /* L1441 */
{4.5411114692687988e+00, 1.1694431304931641e-04,
	1.1920928955078125e-07, 2.1696090698242188e-05,
	-1.0073184967041016e-05}, /* L1442 */
{4.7393536567687988e+00, 1.2253224849700928e-04,
	1.1920928955078125e-07, -4.2486190795898438e-04,
	2.0360946655273438e-04}, /* L1443 */
{4.0770010948181152e+00, 1.0547041893005371e-04,
	1.1920928955078125e-07, -9.0599060058593750e-06,
	-5.7220458984375000e-06}, /* L1444 */
{5.0433492660522461e+00, 1.3077259063720703e-04,
	1.1920928955078125e-07, 1.3470649719238281e-05,
	2.6106834411621094e-05}, /* L1445 */
{5.1698369979858398e+00, 1.3439357280731201e-04,
	1.1920928955078125e-07, -1.8024444580078125e-04,
	-2.6166439056396484e-05}, /* L1446 */
{3.8861188888549805e+00, 1.0123848915100098e-04,
	1.1920928955078125e-07, 3.3617019653320312e-05,
	5.4836273193359375e-05}, /* L1447 */
{4.3704109191894531e+00, 1.1411309242248535e-04,
	1.1920928955078125e-07, -4.1127204895019531e-05,
	-7.5101852416992188e-06}, /* L1448 */
{4.8980259895324707e+00, 1.2817978858947754e-04,
	1.1920928955078125e-07, -4.9412250518798828e-05,
	2.5391578674316406e-05}, /* L1449 */
{4.3612704277038574e+00, 1.1438317596912384e-04,
	1.1920928955078125e-07, 0.0000000000000000e+00,
	1.4185905456542969e-05}, /* L1450 */
{5.7527580261230469e+00, 1.5124678611755371e-04,
	1.1920928955078125e-07, 8.9406967163085938e-06,
	-1.2487173080444336e-04}, /* L1451 */
{5.5650038719177246e+00, 1.4662742614746094e-04,
	1.1920928955078125e-07, -4.2080879211425781e-05,
	3.1709671020507812e-05}, /* L1452 */
{4.2241549491882324e+00, 1.1154264211654663e-04,
	1.1920928955078125e-07, 2.3007392883300781e-05,
	1.7762184143066406e-05}, /* L1453 */
{4.0936546325683594e+00, 1.0834634304046631e-04,
	1.1920928955078125e-07, -6.5565109252929688e-06,
	2.9683113098144531e-05}, /* L1454 */
{4.0500717163085938e+00, 1.0743737220764160e-04,
	1.1920928955078125e-07, -4.4107437133789062e-06,
	-3.3736228942871094e-05}, /* L1455 */
{5.9028835296630859e+00, 1.5693157911300659e-04,
	1.1920928955078125e-07, 1.1444091796875000e-05,
	1.7285346984863281e-05}, /* L1456 */
{6.6958923339843750e+00, 1.7845630645751953e-04,
	1.1920928955078125e-07, 1.3744831085205078e-04,
	-2.1684169769287109e-04}, /* L1457 */
{4.7673230171203613e+00, 1.2730807065963745e-04,
	1.1920928955078125e-07, 1.3828277587890625e-05,
	2.1934509277343750e-05}, /* L1458 */
{6.1993622779846191e+00, 1.6592442989349365e-04,
	1.1920928955078125e-07, 3.0159950256347656e-05,
	4.1604042053222656e-05}, /* L1459 */
{4.9040460586547852e+00, 1.3155117630958557e-04,
	1.1920928955078125e-07, 4.6491622924804688e-05,
	5.9723854064941406e-05}, /* L1460 */
{4.4135026931762695e+00, 1.1867284774780273e-04,
	1.1920928955078125e-07, 6.8306922912597656e-05,
	-2.8371810913085938e-05}, /* L1461 */
{6.3232822418212891e+00, 1.7037242650985718e-04,
	1.1920928955078125e-07, 3.7789344787597656e-05,
	1.7881393432617188e-05}, /* L1462 */
{4.7820315361022949e+00, 1.2913346290588379e-04,
	1.1920928955078125e-07, -3.0994415283203125e-06,
	3.1590461730957031e-05}, /* L1463 */
{5.8575887680053711e+00, 1.5854835510253906e-04,
	1.1920928955078125e-07, 6.6757202148437500e-06,
	-9.7751617431640625e-05}, /* L1464 */
{4.6069049835205078e+00, 1.2494623661041260e-04,
	1.1920928955078125e-07, -2.0802021026611328e-05,
	-5.0187110900878906e-05}, /* L1465 */
{3.6946730613708496e+00, 1.0044500231742859e-04,
	1.1920928955078125e-07, -4.3690204620361328e-05,
	-7.5519084930419922e-05}, /* L1466 */
{4.4400382041931152e+00, 1.2096762657165527e-04,
	1.1920928955078125e-07, 2.5391578674316406e-05,
	-7.5161457061767578e-05}, /* L1467 */
{5.6785926818847656e+00, 1.5506148338317871e-04,
	1.1920928955078125e-07, 5.2690505981445312e-05,
	9.2983245849609375e-06}, /* L1468 */
{5.9646377563476562e+00, 1.6320496797561646e-04,
	1.1920928955078125e-07, -4.9471855163574219e-05,
	-8.1062316894531250e-05}, /* L1469 */
{4.9088644981384277e+00, 1.3473629951477051e-04,
	1.1920928955078125e-07, 6.3097476959228516e-04,
	8.0823898315429688e-05}, /* L1470 */
{3.7326440811157227e+00, 1.0259449481964111e-04,
	1.1920928955078125e-07, -1.1503696441650391e-05,
	2.7418136596679688e-06}, /* L1471 */
{4.1820335388183594e+00, 1.1519342660903931e-04,
	1.1920928955078125e-07, -9.2387199401855469e-06,
	-3.1769275665283203e-05}, /* L1472 */
{6.7988538742065430e+00, 1.8766522407531738e-04,
	1.1920928955078125e-07, -1.7344951629638672e-05,
	3.9458274841308594e-05}, /* L1473 */
{4.0071740150451660e+00, 1.1090934276580811e-04,
	1.1920928955078125e-07, 2.1839141845703125e-04,
	2.2232532501220703e-04}, /* L1474 */
{5.1238522529602051e+00, 1.4203786849975586e-04,
	1.1920928955078125e-07, 1.1086463928222656e-05,
	-6.0200691223144531e-06}, /* L1475 */
{5.8487634658813477e+00, 1.6246736049652100e-04,
	1.1920928955078125e-07, -4.4465065002441406e-05,
	1.9788742065429688e-05}, /* L1476 */
{5.4141168594360352e+00, 1.5072524547576904e-04,
	1.1920928955078125e-07, 1.3029575347900391e-04,
	-3.1292438507080078e-05}, /* L1477 */
{4.7024874687194824e+00, 1.3121962547302246e-04,
	1.1920928955078125e-07, -5.6087970733642578e-05,
	1.2695789337158203e-04}, /* L1478 */
{5.0653290748596191e+00, 1.4161411672830582e-04,
	1.1920928955078125e-07, 7.1167945861816406e-05,
	3.8862228393554688e-05}, /* L1479 */
{3.9772584438323975e+00, 1.1143088340759277e-04,
	1.1920928955078125e-07, 1.7881393432617188e-05,
	-3.5047531127929688e-05}, /* L1480 */
{5.0348796844482422e+00, 1.4251470565795898e-04,
	1.1920928955078125e-07, -2.3993849754333496e-03,
	8.5771083831787109e-04}, /* L1481 */
{5.5807471275329590e+00, 1.5701353549957275e-04,
	1.1920928955078125e-07, 2.5629997253417969e-05,
	2.0623207092285156e-05}, /* L1482 */
{5.0025205612182617e+00, 1.4105439186096191e-04,
	1.1920928955078125e-07, -2.1874904632568359e-05,
	6.1511993408203125e-05}, /* L1483 */
{7.4436874389648438e+00, 2.1032989025115967e-04,
	1.1920928955078125e-07, 2.1457672119140625e-05,
	1.8596649169921875e-05}, /* L1484 */
{4.9420204162597656e+00, 1.4011561870574951e-04,
	1.1920928955078125e-07, -7.4684619903564453e-05,
	1.5759468078613281e-04}, /* L1485 */
{5.3286194801330566e+00, 1.5120953321456909e-04,
	1.1920928955078125e-07, -3.9160251617431641e-05,
	5.3644180297851562e-05}, /* L1486 */
{4.9017491340637207e+00, 1.3938546180725098e-04,
	1.1920928955078125e-07, -4.1306018829345703e-05,
	3.4570693969726562e-06}, /* L1487 */
{6.1502108573913574e+00, 1.7523765563964844e-04,
	1.1920928955078125e-07, 2.8967857360839844e-05,
	1.8119812011718750e-05}, /* L1488 */
{5.3834056854248047e+00, 1.5372037887573242e-04,
	1.1920928955078125e-07, 1.9907951354980469e-05,
	-3.3378601074218750e-06}, /* L1489 */
{6.0058851242065430e+00, 1.7184019088745117e-04,
	1.1920928955078125e-07, -3.1232833862304688e-05,
	-4.7624111175537109e-05}, /* L1490 */
{6.1604924201965332e+00, 1.7675757408142090e-04,
	1.1920928955078125e-07, 4.7647953033447266e-04,
	-5.6785345077514648e-04}, /* L1491 */
{8.0020484924316406e+00, 2.2995471954345703e-04,
	1.1920928955078125e-07, 3.5762786865234375e-07,
	7.2240829467773438e-05}, /* L1492 */
{4.7145266532897949e+00, 1.3586878776550293e-04,
	1.1920928955078125e-07, -2.6023387908935547e-04,
	9.5605850219726562e-05}, /* L1493 */
{5.4914135932922363e+00, 1.5843100845813751e-04,
	1.1920928955078125e-07, -3.8325786590576172e-05,
	-1.2159347534179688e-05}, /* L1494 */
{6.3612146377563477e+00, 1.8393993377685547e-04,
	1.1920928955078125e-07, 1.9311904907226562e-05,
	-9.0897083282470703e-05}, /* L1495 */
{7.1484522819519043e+00, 2.0709633827209473e-04,
	1.1920928955078125e-07, 2.3841857910156250e-06,
	-8.2850456237792969e-06}, /* L1496 */
{4.1670236587524414e+00, 1.2096762657165527e-04,
	1.1920928955078125e-07, 2.4914741516113281e-05,
	-4.2498111724853516e-05}, /* L1497 */
{6.0602579116821289e+00, 1.7634034156799316e-04,
	1.1920928955078125e-07, 3.1590461730957031e-04,
	-2.3967027664184570e-04}, /* L1498 */
{4.9270291328430176e+00, 1.4361739158630371e-04,
	1.1920928955078125e-07, -1.6152858734130859e-05,
	1.8596649169921875e-05}, /* L1499 */
{6.3606724739074707e+00, 1.8579498282633722e-04,
	1.1920928955078125e-07, 4.8637390136718750e-05,
	7.9512596130371094e-05}, /* L1500 */
{5.2753887176513672e+00, 1.5440583229064941e-04,
	1.1920928955078125e-07, -1.5079975128173828e-05,
	-2.3424625396728516e-05}, /* L1501 */
{7.3513460159301758e+00, 2.1563470363616943e-04,
	1.1920928955078125e-07, -1.2916326522827148e-04,
	4.0173530578613281e-05}, /* L1502 */
{3.9155988693237305e+00, 1.1506676673889160e-04,
	1.1920928955078125e-07, -1.3768672943115234e-05,
	3.1232833862304688e-05}, /* L1503 */
{5.1235876083374023e+00, 1.5094876289367676e-04,
	1.1920928955078125e-07, 1.2397766113281250e-04,
	-2.0122528076171875e-04}, /* L1504 */
{5.6760935783386230e+00, 1.6748905181884766e-04,
	1.1920928955078125e-07, 3.5285949707031250e-05,
	4.6730041503906250e-05}, /* L1505 */
{5.1203889846801758e+00, 1.5139579772949219e-04,
	1.1920928955078125e-07, 9.5367431640625000e-07,
	-1.8715858459472656e-05}, /* L1506 */
{6.8399348258972168e+00, 2.0264089107513428e-04,
	1.1920928955078125e-07, -5.3763389587402344e-05,
	-4.9471855163574219e-06}, /* L1507 */
{5.9234356880187988e+00, 1.7586350440979004e-04,
	1.1920928955078125e-07, -3.7848949432373047e-05,
	-9.7155570983886719e-05}, /* L1508 */
{4.6010227203369141e+00, 1.3689696788787842e-04,
	1.1920928955078125e-07, -2.4139881134033203e-05,
	3.8146972656250000e-06}, /* L1509 */
{7.3738422393798828e+00, 2.1979212760925293e-04,
	1.1920928955078125e-07, -6.5326690673828125e-05,
	-1.6331672668457031e-05}, /* L1510 */
{5.5350818634033203e+00, 1.6538798809051514e-04,
	1.1920928955078125e-07, -3.0404329299926758e-04,
	2.0647048950195312e-04}, /* L1511 */
{5.2993330955505371e+00, 1.5858560800552368e-04,
	1.1920928955078125e-07, 3.6954879760742188e-05,
	9.0122222900390625e-05}, /* L1512 */
{5.4391717910766602e+00, 1.6328692436218262e-04,
	1.1920928955078125e-07, -6.0027837753295898e-04,
	-8.7380409240722656e-05}, /* L1513 */
{5.0555434226989746e+00, 1.5190243721008301e-04,
	1.1920928955078125e-07, -2.1755695343017578e-05,
	-1.6450881958007812e-05}, /* L1514 */
{5.5656056404113770e+00, 1.6754865646362305e-04,
	1.1920928955078125e-07, 1.5020370483398438e-05,
	-8.2910060882568359e-05}, /* L1515 */
{4.3916397094726562e+00, 1.3250112533569336e-04,
	1.1920928955078125e-07, -2.6518106460571289e-04,
	1.9311904907226562e-05}, /* L1516 */
{5.4428820610046387e+00, 1.6465783119201660e-04,
	1.1920928955078125e-07, 6.9522857666015625e-04,
	3.1399726867675781e-04}, /* L1517 */
{5.6694173812866211e+00, 1.7234683036804199e-04,
	1.1920928955078125e-07, 1.0383129119873047e-03,
	-1.8698573112487793e-03}, /* L1518 */
{6.7812099456787109e+00, 2.0582973957061768e-04,
	1.1920928955078125e-07, -9.0956687927246094e-05,
	7.0929527282714844e-05}, /* L1519 */
{5.1436595916748047e+00, 1.5643239021301270e-04,
	1.1920928955078125e-07, -2.0134449005126953e-04,
	2.5510787963867188e-05}, /* L1520 */
{6.1056780815124512e+00, 1.8599629402160645e-04,
	1.1920928955078125e-07, 6.8306922912597656e-05,
	2.9921531677246094e-05}, /* L1521 */
{4.7902460098266602e+00, 1.4621019363403320e-04,
	1.1920928955078125e-07, -3.4213066101074219e-05,
	3.3140182495117188e-05}, /* L1522 */
{6.3455085754394531e+00, 1.9407272338867188e-04,
	1.1920928955078125e-07, -4.2200088500976562e-05,
	-6.5565109252929688e-07}, /* L1523 */
{6.3733029365539551e+00, 1.9529461860656738e-04,
	1.1920928955078125e-07, -1.9907951354980469e-05,
	1.4424324035644531e-05}, /* L1524 */
{4.5927534103393555e+00, 1.4099478721618652e-04,
	1.1920928955078125e-07, -5.5789947509765625e-05,
	4.9710273742675781e-05}, /* L1525 */
{4.8711824417114258e+00, 1.4984607696533203e-04,
	1.1920928955078125e-07, -8.3088874816894531e-05,
	5.7816505432128906e-05}, /* L1526 */
{4.6142587661743164e+00, 1.4230608940124512e-04,
	1.1920928955078125e-07, 2.7179718017578125e-05,
	6.6399574279785156e-05}, /* L1527 */
{6.0828628540039062e+00, 1.8784403800964355e-04,
	1.1920928955078125e-07, -2.3841857910156250e-06,
	-1.7046928405761719e-05}, /* L1528 */
{5.3480257987976074e+00, 1.6564130783081055e-04,
	1.1920928955078125e-07, -6.1213970184326172e-05,
	6.2704086303710938e-05}, /* L1529 */
{6.4968309402465820e+00, 2.0140409469604492e-04,
	1.1920928955078125e-07, 2.0265579223632812e-05,
	-6.1094760894775391e-05}, /* L1530 */
{5.8082156181335449e+00, 1.8048286437988281e-04,
	1.1920928955078125e-07, -1.3518333435058594e-04,
	7.6174736022949219e-05}, /* L1531 */
{4.8875293731689453e+00, 1.5209615230560303e-04,
	1.1920928955078125e-07, -5.5491924285888672e-05,
	2.2649765014648438e-06}, /* L1532 */
{5.4844498634338379e+00, 1.7100572586059570e-04,
	1.1920928955078125e-07, -1.0466575622558594e-04,
	-2.1237134933471680e-04}, /* L1533 */
{5.9610209465026855e+00, 1.8626451492309570e-04,
	1.1920928955078125e-07, 1.3041496276855469e-04,
	-1.2099742889404297e-04}, /* L1534 */
{6.3852038383483887e+00, 1.9989907741546631e-04,
	1.1920928955078125e-07, 1.1587142944335938e-04,
	1.4650821685791016e-04}, /* L1535 */
{5.1573905944824219e+00, 1.6170740127563477e-04,
	1.1920928955078125e-07, -5.2452087402343750e-06,
	-1.7404556274414062e-05}, /* L1536 */
{5.2878279685974121e+00, 1.6614794731140137e-04,
	1.1920928955078125e-07, -3.0696392059326172e-05,
	-1.9669532775878906e-05}, /* L1537 */
{4.7292981147766113e+00, 1.4895200729370117e-04,
	1.1920928955078125e-07, 1.8131732940673828e-04,
	2.7060508728027344e-04}, /* L1538 */
{6.5145025253295898e+00, 2.0543485879898071e-04,
	1.1920928955078125e-07, -1.3470649719238281e-05,
	8.8691711425781250e-05}, /* L1539 */
{6.9765748977661133e+00, 2.2053718566894531e-04,
	1.1920928955078125e-07, 2.3961067199707031e-04,
	4.4476985931396484e-04}, /* L1540 */
{6.5441446304321289e+00, 2.0727515220642090e-04,
	1.1920928955078125e-07, 4.3499469757080078e-04,
	3.5548210144042969e-04}, /* L1541 */
{9.2936744689941406e+00, 2.9498338699340820e-04,
	1.1920928955078125e-07, 1.1360645294189453e-04,
	-7.9751014709472656e-05}, /* L1542 */
{6.6832408905029297e+00, 2.1445751190185547e-04,
	1.1920928955078125e-07, -5.4982304573059082e-03,
	-1.7100572586059570e-03}, /* L1543 */
{1.1340641975402832e+01, 3.6099553108215332e-04,
	1.1920928955078125e-07, 3.2782554626464844e-05,
	2.3245811462402344e-05}, /* L1544 */
{6.6539411544799805e+00, 2.1223723888397217e-04,
	1.1920928955078125e-07, 5.1259994506835938e-05,
	1.4948844909667969e-04}, /* L1545 */
{5.7673397064208984e+00, 1.8435716629028320e-04,
	1.1920928955078125e-07, -4.8041343688964844e-05,
	2.5868415832519531e-05}, /* L1546 */
{6.4843931198120117e+00, 2.0821392536163330e-04,
	1.1920928955078125e-07, -6.9642066955566406e-04,
	7.7426433563232422e-04}, /* L1547 */
{4.9204277992248535e+00, 1.5781819820404053e-04,
	1.1920928955078125e-07, -2.1934509277343750e-05,
	2.7298927307128906e-05}, /* L1548 */
{5.7416129112243652e+00, 1.8447637557983398e-04,
	1.1920928955078125e-07, -1.0371208190917969e-05,
	2.1457672119140625e-06}, /* L1549 */
{6.9889173507690430e+00, 2.2497773170471191e-04,
	1.1920928955078125e-07, -3.7491321563720703e-05,
	4.1246414184570312e-05}, /* L1550 */
{6.9942154884338379e+00, 2.2555887699127197e-04,
	1.1920928955078125e-07, 2.7775764465332031e-05,
	6.6757202148437500e-06}, /* L1551 */
{5.9428272247314453e+00, 1.9200146198272705e-04,
	1.1920928955078125e-07, -1.2576580047607422e-05,
	2.3126602172851562e-05}, /* L1552 */
{5.5200729370117188e+00, 1.8015503883361816e-04,
	1.1920928955078125e-07, -2.5536417961120605e-03,
	2.4120807647705078e-03}, /* L1553 */
{5.9261970520019531e+00, 1.9228458404541016e-04,
	1.1920928955078125e-07, 4.0280818939208984e-04,
	-2.1648406982421875e-04}, /* L1554 */
{4.9420609474182129e+00, 1.6057491302490234e-04,
	1.1920928955078125e-07, 7.2598457336425781e-05,
	-9.4294548034667969e-05}, /* L1555 */
{5.7787709236145020e+00, 1.8808245658874512e-04,
	1.1920928955078125e-07, 6.6518783569335938e-05,
	-3.5405158996582031e-05}, /* L1556 */
{6.7051978111267090e+00, 2.1863728761672974e-04,
	1.1920928955078125e-07, 3.0994415283203125e-06,
	-7.3313713073730469e-06}, /* L1557 */
{7.6644401550292969e+00, 2.5036931037902832e-04,
	1.1920928955078125e-07, 1.7642974853515625e-05,
	-8.9406967163085938e-07}, /* L1558 */
{5.3232679367065430e+00, 1.7424672842025757e-04,
	1.1920928955078125e-07, 5.1140785217285156e-05,
	-1.8960237503051758e-04}, /* L1559 */
{5.1175212860107422e+00, 1.6778707504272461e-04,
	1.1920928955078125e-07, -5.2273273468017578e-05,
	-2.4735927581787109e-05}, /* L1560 */
{7.2600560188293457e+00, 2.3847073316574097e-04,
	1.1920928955078125e-07, -1.1980533599853516e-05,
	-2.9206275939941406e-05}, /* L1561 */
{4.8857469558715820e+00, 1.6079843044281006e-04,
	1.1920928955078125e-07, -7.2598457336425781e-05,
	1.4972686767578125e-04}, /* L1562 */
{5.7856483459472656e+00, 1.9073486328125000e-04,
	1.1920928955078125e-07, -8.1121921539306641e-05,
	4.5895576477050781e-05}, /* L1563 */
{6.1987195014953613e+00, 2.0474568009376526e-04,
	1.1920928955078125e-07, 3.4451484680175781e-05,
	-3.4451484680175781e-05}, /* L1564 */
{5.5280623435974121e+00, 1.8292665481567383e-04,
	1.1920928955078125e-07, 4.3630599975585938e-05,
	1.1086463928222656e-04}, /* L1565 */
{5.2719717025756836e+00, 1.7476081848144531e-04,
	1.1920928955078125e-07, 2.7418136596679688e-06,
	1.2278556823730469e-05}, /* L1566 */
{5.8493833541870117e+00, 1.9428133964538574e-04,
	1.1920928955078125e-07, -8.6963176727294922e-05,
	-8.7559223175048828e-05}, /* L1567 */
{7.4994993209838867e+00, 2.4946220219135284e-04,
	1.1920928955078125e-07, -3.8743019104003906e-05,
	6.1750411987304688e-05}, /* L1568 */
{8.0564422607421875e+00, 2.6848539710044861e-04,
	1.1920928955078125e-07, 7.8320503234863281e-05,
	1.3828277587890625e-05}, /* L1569 */
{8.2448787689208984e+00, 2.7525424957275391e-04,
	1.1920928955078125e-07, 1.8954277038574219e-04,
	4.0173530578613281e-05}, /* L1570 */
{6.3698124885559082e+00, 2.1308660507202148e-04,
	1.1920928955078125e-07, 8.7261199951171875e-05,
	-1.3130903244018555e-04}, /* L1571 */
{7.7860383987426758e+00, 2.6084296405315399e-04,
	1.1920928955078125e-07, -4.9710273742675781e-05,
	1.8358230590820312e-05}, /* L1572 */
{6.2749595642089844e+00, 2.1065771579742432e-04,
	1.1920928955078125e-07, 2.1064281463623047e-04,
	-1.5228986740112305e-04}, /* L1573 */
{7.0988192558288574e+00, 2.3871660232543945e-04,
	1.1920928955078125e-07, 5.4597854614257812e-05,
	1.0812282562255859e-04}, /* L1574 */
{6.1754641532897949e+00, 2.0840764045715332e-04,
	1.1920928955078125e-07, 2.3710727691650391e-04,
	3.8146972656250000e-04}, /* L1575 */
{6.0608286857604980e+00, 2.0477175712585449e-04,
	1.1920928955078125e-07, -1.1539459228515625e-04,
	-2.9015541076660156e-04}, /* L1576 */
{7.0008625984191895e+00, 2.3673474788665771e-04,
	1.1920928955078125e-07, -1.1914968490600586e-04,
	1.4185905456542969e-04}, /* L1577 */
{6.7248425483703613e+00, 2.2769719362258911e-04,
	1.1920928955078125e-07, 3.3855438232421875e-05,
	3.6358833312988281e-05}, /* L1578 */
{6.7595577239990234e+00, 2.2929906845092773e-04,
	1.1920928955078125e-07, 6.0796737670898438e-05,
	-7.1167945861816406e-05}, /* L1579 */
{5.9898591041564941e+00, 2.0356476306915283e-04,
	1.1920928955078125e-07, 6.1988830566406250e-05,
	5.8412551879882812e-06}, /* L1580 */
{6.8751063346862793e+00, 2.3401901125907898e-04,
	1.1920928955078125e-07, -8.5234642028808594e-06,
	6.5803527832031250e-05}, /* L1581 */
{7.3971276283264160e+00, 2.5224685668945312e-04,
	1.1920928955078125e-07, 6.4134597778320312e-05,
	-1.3709068298339844e-05}, /* L1582 */
{6.3223195075988770e+00, 2.1603703498840332e-04,
	1.1920928955078125e-07, 8.7261199951171875e-05,
	1.8715858459472656e-05}, /* L1583 */
{5.6579871177673340e+00, 1.9365549087524414e-04,
	1.1920928955078125e-07, -8.6307525634765625e-05,
	-1.8417835235595703e-05}, /* L1584 */
{7.4046993255615234e+00, 2.5379657745361328e-04,
	1.1920928955078125e-07, -5.1140785217285156e-05,
	1.1444091796875000e-05}, /* L1585 */
{6.0522208213806152e+00, 2.0798295736312866e-04,
	1.1920928955078125e-07, -3.1769275665283203e-05,
	-8.6307525634765625e-05}, /* L1586 */
{5.4351930618286133e+00, 1.8714368343353271e-04,
	1.1920928955078125e-07, 4.3511390686035156e-04,
	4.6527385711669922e-04}, /* L1587 */
{9.4351921081542969e+00, 3.2550096511840820e-04,
	1.1920928955078125e-07, -4.7796964645385742e-04,
	-2.5969743728637695e-04}, /* L1588 */
{5.0385971069335938e+00, 1.7394125461578369e-04,
	1.1920928955078125e-07, -3.4928321838378906e-05,
	3.6716461181640625e-05}, /* L1589 */
{6.3993549346923828e+00, 2.2125244140625000e-04,
	1.1920928955078125e-07, -1.0251998901367188e-05,
	1.3113021850585938e-06}, /* L1590 */
{7.2028784751892090e+00, 2.4959444999694824e-04,
	1.1920928955078125e-07, 9.9897384643554688e-05,
	7.2598457336425781e-05}, /* L1591 */
{6.3808298110961914e+00, 2.2146757692098618e-04,
	1.1920928955078125e-07, 3.6787986755371094e-04,
	-6.9081783294677734e-05}, /* L1592 */
{8.0772647857666016e+00, 2.8081052005290985e-04,
	1.1920928955078125e-07, 1.6140937805175781e-04,
	2.1207332611083984e-04}, /* L1593 */
{6.4131917953491211e+00, 2.2350251674652100e-04,
	1.1920928955078125e-07, -1.4680624008178711e-04,
	-4.6044588088989258e-04}, /* L1594 */
{6.4220824241638184e+00, 2.2399425506591797e-04,
	1.1920928955078125e-07, 5.4955482482910156e-05,
	-1.9073486328125000e-04}, /* L1595 */
{6.0896100997924805e+00, 2.1272432059049606e-04,
	1.1920928955078125e-07, 1.1062622070312500e-04,
	1.3709068298339844e-05}, /* L1596 */
{6.5197033882141113e+00, 2.2843480110168457e-04,
	1.1920928955078125e-07, -3.8433074951171875e-04,
	2.2113323211669922e-04}, /* L1597 */
{6.2656197547912598e+00, 2.1961331367492676e-04,
	1.1920928955078125e-07, 5.9604644775390625e-07,
	7.3909759521484375e-06}, /* L1598 */
{5.9526052474975586e+00, 2.0903348922729492e-04,
	1.1920928955078125e-07, 1.2767314910888672e-04,
	1.3089179992675781e-04}, /* L1599 */
{5.3630847930908203e+00, 1.8861889839172363e-04,
	1.1920928955078125e-07, -3.6954879760742188e-05,
	3.2186508178710938e-06}, /* L1600 */
{5.8160314559936523e+00, 2.0493566989898682e-04,
	1.1920928955078125e-07, 8.9287757873535156e-05,
	-5.2988529205322266e-05}, /* L1601 */
{5.7849211692810059e+00, 2.0414590835571289e-04,
	1.1920928955078125e-07, 1.9192695617675781e-05,
	2.9325485229492188e-05}, /* L1602 */
{7.3695979118347168e+00, 2.6057288050651550e-04,
	1.1920928955078125e-07, -8.8214874267578125e-05,
	1.0168552398681641e-04}, /* L1603 */
{5.8746728897094727e+00, 2.0802021026611328e-04,
	1.1920928955078125e-07, 1.2874603271484375e-05,
	3.9339065551757812e-06}, /* L1604 */
{7.6387066841125488e+00, 2.7126073837280273e-04,
	1.1920928955078125e-07, 5.3381919860839844e-04,
	6.3467025756835938e-04}, /* L1605 */
{6.6640315055847168e+00, 2.3685395717620850e-04,
	1.1920928955078125e-07, 1.4805793762207031e-04,
	-1.2105703353881836e-04}, /* L1606 */
{7.4180846214294434e+00, 2.6440620422363281e-04,
	1.1920928955078125e-07, 7.5030326843261719e-04,
	3.3307075500488281e-04}, /* L1607 */
{6.1843800544738770e+00, 2.2045196965336800e-04,
	1.1920928955078125e-07, 6.1154365539550781e-05,
	-3.1888484954833984e-05}, /* L1608 */
{8.0226764678955078e+00, 2.8651952743530273e-04,
	1.1920928955078125e-07, -3.0696392059326172e-05,
	-1.5497207641601562e-05}, /* L1609 */
{6.4083571434020996e+00, 2.3349747061729431e-04,
	1.1920928955078125e-07, 7.7294111251831055e-03,
	8.8059902191162109e-04}, /* L1610 */
{6.6084260940551758e+00, 2.3680925369262695e-04,
	1.1920928955078125e-07, 1.3136863708496094e-04,
	8.0347061157226562e-05}, /* L1611 */
{5.6835446357727051e+00, 2.0396709442138672e-04,
	1.1920928955078125e-07, -3.3855438232421875e-05,
	-1.3530254364013672e-05}, /* L1612 */
{7.0634860992431641e+00, 2.6224553585052490e-04,
	1.1920928955078125e-07, 2.8293132781982422e-03,
	-6.3961744308471680e-03}, /* L1613 */
{8.3286542892456055e+00, 3.0000880360603333e-04,
	1.1920928955078125e-07, -1.8060207366943359e-04,
	7.6293945312500000e-06}, /* L1614 */
{6.0193595886230469e+00, 2.1710991859436035e-04,
	1.1920928955078125e-07, -7.6889991760253906e-06,
	-2.2649765014648438e-06}, /* L1615 */
{8.2057666778564453e+00, 2.9712915420532227e-04,
	1.1920928955078125e-07, -9.3710422515869141e-04,
	6.3157081604003906e-04}, /* L1616 */
{7.5656437873840332e+00, 2.7377344667911530e-04,
	1.1920928955078125e-07, 3.9339065551757812e-05,
	6.0796737670898438e-05}, /* L1617 */
{8.0642127990722656e+00, 2.9236078262329102e-04,
	1.1920928955078125e-07, -5.9366226196289062e-05,
	7.9870223999023438e-06}, /* L1618 */
{6.5877547264099121e+00, 2.3916363716125488e-04,
	1.1920928955078125e-07, 8.4757804870605469e-05,
	2.3603439331054688e-05}, /* L1619 */
{6.5712537765502930e+00, 2.3898482322692871e-04,
	1.1920928955078125e-07, -2.0802021026611328e-05,
	9.9897384643554688e-05}, /* L1620 */
{8.6658744812011719e+00, 3.1563639640808105e-04,
	1.1920928955078125e-07, -6.9141387939453125e-06,
	-4.5359134674072266e-05}, /* L1621 */
{6.7469592094421387e+00, 2.4625658988952637e-04,
	1.1920928955078125e-07, 1.2993812561035156e-04,
	4.3511390686035156e-05}, /* L1622 */
{7.2914371490478516e+00, 2.6673451066017151e-04,
	1.1920928955078125e-07, -8.1598758697509766e-04,
	-5.4031610488891602e-04}, /* L1623 */
{9.4930953979492188e+00, 3.4746527671813965e-04,
	1.1920928955078125e-07, 1.4543533325195312e-05,
	-4.3272972106933594e-05}, /* L1624 */
{5.7312974929809570e+00, 2.1012010984122753e-04,
	1.1920928955078125e-07, -5.6982040405273438e-05,
	9.1195106506347656e-05}, /* L1625 */
{5.9745678901672363e+00, 2.1940469741821289e-04,
	1.1920928955078125e-07, -4.5120716094970703e-05,
	-2.6881694793701172e-05}, /* L1626 */
{4.7506341934204102e+00, 1.7473101615905762e-04,
	1.1920928955078125e-07, -5.3107738494873047e-05,
	-2.4914741516113281e-05}, /* L1627 */
{7.3024945259094238e+00, 2.6917457580566406e-04,
	1.1920928955078125e-07, 1.3470649719238281e-04,
	-1.7821788787841797e-05}, /* L1628 */
{7.3836154937744141e+00, 2.7278065681457520e-04,
	1.1920928955078125e-07, 5.6147575378417969e-05,
	2.3281574249267578e-04}, /* L1629 */
{6.6289205551147461e+00, 2.4520978331565857e-04,
	1.1920928955078125e-07, 2.5522708892822266e-04,
	3.9613246917724609e-04}, /* L1630 */
{5.9359660148620605e+00, 2.1988153457641602e-04,
	1.1920928955078125e-07, -2.9522180557250977e-04,
	-2.6547908782958984e-04}, /* L1631 */
{6.3866081237792969e+00, 2.7644634246826172e-04,
	1.1920928955078125e-07, 4.7813892364501953e-02,
	-4.1634857654571533e-02}, /* L1632 */
{6.7924633026123047e+00, 2.5237351655960083e-04,
	1.1920928955078125e-07, -2.8592348098754883e-04,
	1.0669231414794922e-04}, /* L1633 */
{5.8325419425964355e+00, 2.1696090698242188e-04,
	1.1920928955078125e-07, -2.2530555725097656e-05,
	-3.9517879486083984e-05}, /* L1634 */
{8.8326196670532227e+00, 3.2913684844970703e-04,
	1.1920928955078125e-07, -1.5616416931152344e-05,
	1.9073486328125000e-06}, /* L1635 */
{7.7967424392700195e+00, 2.9098987579345703e-04,
	1.1920928955078125e-07, -3.0457973480224609e-05,
	6.8068504333496094e-05}, /* L1636 */
{7.0446209907531738e+00, 2.6366114616394043e-04,
	1.1920928955078125e-07, 5.5193901062011719e-05,
	-1.2505054473876953e-04}, /* L1637 */
{5.8722696304321289e+00, 2.1991133689880371e-04,
	1.1920928955078125e-07, 9.0599060058593750e-06,
	2.4461746215820312e-04}, /* L1638 */
{6.7226681709289551e+00, 2.5242567062377930e-04,
	1.1920928955078125e-07, 2.3245811462402344e-05,
	-1.6927719116210938e-05}, /* L1639 */
{7.3555049896240234e+00, 2.7644634246826172e-04,
	1.1920928955078125e-07, 2.7585029602050781e-04,
	1.1384487152099609e-04}, /* L1640 */
{7.1646018028259277e+00, 2.6959180831909180e-04,
	1.1920928955078125e-07, -1.8101930618286133e-04,
	-4.3749809265136719e-05}, /* L1641 */
{6.6215577125549316e+00, 2.4950504302978516e-04,
	1.1920928955078125e-07, 1.6331672668457031e-05,
	5.8174133300781250e-05}, /* L1642 */
{5.8195476531982422e+00, 2.1961331367492676e-04,
	1.1920928955078125e-07, 5.7458877563476562e-05,
	9.1791152954101562e-05}, /* L1643 */
{6.3836760520935059e+00, 2.4129450321197510e-04,
	1.1920928955078125e-07, 2.5033950805664062e-06,
	-2.5093555450439453e-05}, /* L1644 */
{9.0051755905151367e+00, 3.4102797508239746e-04,
	1.1920928955078125e-07, -3.5703182220458984e-05,
	-2.2363662719726562e-04}, /* L1645 */
{6.8281569480895996e+00, 2.5889277458190918e-04,
	1.1920928955078125e-07, 9.7036361694335938e-05,
	-2.4855136871337891e-05}, /* L1646 */
{8.8414764404296875e+00, 3.3578276634216309e-04,
	1.1920928955078125e-07, -1.4364719390869141e-05,
	1.1956691741943359e-04}, /* L1647 */
{9.4787073135375977e+00, 3.6081671714782715e-04,
	1.1920928955078125e-07, -2.1374225616455078e-04,
	-8.2969665527343750e-05}, /* L1648 */
{7.4477825164794922e+00, 2.8382986783981323e-04,
	1.1920928955078125e-07, -4.5675039291381836e-04,
	1.7809867858886719e-04}, /* L1649 */
{7.4903297424316406e+00, 2.8580427169799805e-04,
	1.1920928955078125e-07, 2.8610229492187500e-05,
	-8.5353851318359375e-05}, /* L1650 */
{7.1923398971557617e+00, 2.7483701705932617e-04,
	1.1920928955078125e-07, -5.8114528656005859e-05,
	-5.0842761993408203e-05}, /* L1651 */
{9.4947175979614258e+00, 3.6343932151794434e-04,
	1.1920928955078125e-07, -1.2582540512084961e-04,
	-1.3440847396850586e-04}, /* L1652 */
{5.4654045104980469e+00, 2.0959973335266113e-04,
	1.1920928955078125e-07, -1.1622905731201172e-05,
	-1.9204616546630859e-04}, /* L1653 */
{7.8130364418029785e+00, 2.9996037483215332e-04,
	1.1920928955078125e-07, 1.4662742614746094e-05,
	0.0000000000000000e+00}, /* L1654 */
{8.8489961624145508e+00, 3.4028291702270508e-04,
	1.1920928955078125e-07, -2.6226043701171875e-06,
	-2.9146671295166016e-05}, /* L1655 */
{6.8574461936950684e+00, 2.6428699493408203e-04,
	1.1920928955078125e-07, -1.2308359146118164e-04,
	-1.9216537475585938e-04}, /* L1656 */
{7.4716701507568359e+00, 2.8818845748901367e-04,
	1.1920928955078125e-07, 7.0571899414062500e-05,
	-8.6009502410888672e-05}, /* L1657 */
{6.2409458160400391e+00, 2.4127960205078125e-04,
	1.1920928955078125e-07, -4.3451786041259766e-05,
	-4.4167041778564453e-05}, /* L1658 */
{5.7782907485961914e+00, 2.2360682487487793e-04,
	1.1920928955078125e-07, -2.9188394546508789e-04,
	-1.1426210403442383e-04}, /* L1659 */
{7.1288127899169922e+00, 2.7626752853393555e-04,
	1.1920928955078125e-07, -5.8948993682861328e-05,
	-1.5914440155029297e-04}, /* L1660 */
{7.3286099433898926e+00, 2.8458237648010254e-04,
	1.1920928955078125e-07, -1.0550022125244141e-04,
	2.7155876159667969e-04}, /* L1661 */
{8.6960897445678711e+00, 3.3807754516601562e-04,
	1.1920928955078125e-07, -2.8473138809204102e-04,
	-5.3167343139648438e-05}, /* L1662 */
{8.4404230117797852e+00, 3.2868376001715660e-04,
	1.1920928955078125e-07, 1.7619132995605469e-04,
	1.0645389556884766e-04}, /* L1663 */
{7.0070075988769531e+00, 2.7343630790710449e-04,
	1.1920928955078125e-07, -2.8640031814575195e-04,
	-3.0982494354248047e-04}, /* L1664 */
{7.1653118133544922e+00, 2.8052553534507751e-04,
	1.1920928955078125e-07, 6.7937374114990234e-04,
	3.9863586425781250e-04}, /* L1665 */
{5.4770722389221191e+00, 2.1421909332275391e-04,
	1.1920928955078125e-07, 1.8715858459472656e-05,
	-6.4015388488769531e-05}, /* L1666 */
{6.1754908561706543e+00, 2.4187564849853516e-04,
	1.1920928955078125e-07, -1.0854005813598633e-04,
	1.5854835510253906e-05}, /* L1667 */
{8.1684961318969727e+00, 3.2046437263488770e-04,
	1.1920928955078125e-07, -3.6835670471191406e-05,
	3.3617019653320312e-05}, /* L1668 */
{7.9395952224731445e+00, 3.1191110610961914e-04,
	1.1920928955078125e-07, -6.3598155975341797e-05,
	-5.2452087402343750e-06}, /* L1669 */
{7.2965555191040039e+00, 2.8708763420581818e-04,
	1.1920928955078125e-07, 8.9526176452636719e-05,
	-9.6619129180908203e-05}, /* L1670 */
{6.1464676856994629e+00, 2.4226307868957520e-04,
	1.1920928955078125e-07, -5.8472156524658203e-05,
	-6.0796737670898438e-06}, /* L1671 */
{6.9402055740356445e+00, 2.7392804622650146e-04,
	1.1920928955078125e-07, -1.2093782424926758e-04,
	-4.6730041503906250e-05}, /* L1672 */
{7.8485608100891113e+00, 3.1125545501708984e-04,
	1.1920928955078125e-07, 1.1475086212158203e-03,
	1.1372566223144531e-03}, /* L1673 */
{8.3945627212524414e+00, 3.3235549926757812e-04,
	1.1920928955078125e-07, 7.0691108703613281e-05,
	5.4121017456054688e-05}, /* L1674 */
{9.3921451568603516e+00, 3.7246942520141602e-04,
	1.1920928955078125e-07, 2.6106834411621094e-05,
	-4.9412250518798828e-05}, /* L1675 */
{6.4424710273742676e+00, 2.5579333305358887e-04,
	1.1920928955078125e-07, -9.2983245849609375e-06,
	-9.1791152954101562e-05}, /* L1676 */
{6.0105714797973633e+00, 2.3901462554931641e-04,
	1.1920928955078125e-07, 7.7009201049804688e-05,
	4.6133995056152344e-05}, /* L1677 */
{1.0094603538513184e+01, 4.0227174758911133e-04,
	1.1920928955078125e-07, 2.1934509277343750e-05,
	-2.5600194931030273e-04}, /* L1678 */
{7.4718470573425293e+00, 2.9796361923217773e-04,
	1.1920928955078125e-07, 4.2915344238281250e-06,
	8.5830688476562500e-06}, /* L1679 */
{7.1870899200439453e+00, 2.8711557388305664e-04,
	1.1920928955078125e-07, 1.5366077423095703e-04,
	1.6105175018310547e-04}, /* L1680 */
{8.6702060699462891e+00, 3.5549700260162354e-04,
	1.1920928955078125e-07, 4.1091442108154297e-04,
	-4.9638748168945312e-03}, /* L1681 */
{9.6852750778198242e+00, 3.8848072290420532e-04,
	1.1920928955078125e-07, -3.4344196319580078e-04,
	-5.3715705871582031e-04}, /* L1682 */
{8.0611362457275391e+00, 3.2350420951843262e-04,
	1.1920928955078125e-07, 1.0108947753906250e-04,
	6.6518783569335938e-05}, /* L1683 */
{8.0878114700317383e+00, 3.2500922679901123e-04,
	1.1920928955078125e-07, -9.2327594757080078e-05,
	3.4332275390625000e-05}, /* L1684 */
{6.6700811386108398e+00, 2.6844441890716553e-04,
	1.1920928955078125e-07, -6.6220760345458984e-05,
	-1.1324882507324219e-06}, /* L1685 */
{8.7757596969604492e+00, 3.5375356674194336e-04,
	1.1920928955078125e-07, -8.9049339294433594e-05,
	2.2053718566894531e-05}, /* L1686 */
{7.8898215293884277e+00, 3.1843781471252441e-04,
	1.1920928955078125e-07, 5.6147575378417969e-05,
	-3.8206577301025391e-05}, /* L1687 */
{7.8435001373291016e+00, 3.1750649213790894e-04,
	1.1920928955078125e-07, -4.9018859863281250e-04,
	2.4139881134033203e-04}, /* L1688 */
{6.8878722190856934e+00, 2.7962028980255127e-04,
	1.1920928955078125e-07, 5.3644180297851562e-04,
	9.1743469238281250e-04}, /* L1689 */
{8.0054874420166016e+00, 3.2514333724975586e-04,
	1.1920928955078125e-07, -3.1340122222900391e-04,
	-2.7525424957275391e-04}, /* L1690 */
{6.1898012161254883e+00, 2.5136768817901611e-04,
	1.1920928955078125e-07, -2.5087594985961914e-04,
	6.8426132202148438e-05}, /* L1691 */
{8.3880691528320312e+00, 3.4102052450180054e-04,
	1.1920928955078125e-07, 6.9260597229003906e-05,
	5.9247016906738281e-05}, /* L1692 */
{7.6392235755920410e+00, 3.1103193759918213e-04,
	1.1920928955078125e-07, 8.7022781372070312e-06,
	4.0531158447265625e-06}, /* L1693 */
{5.9234805107116699e+00, 2.4158135056495667e-04,
	1.1920928955078125e-07, 7.2479248046875000e-05,
	-1.3524293899536133e-04}, /* L1694 */
{7.1599431037902832e+00, 2.9253959655761719e-04,
	1.1920928955078125e-07, 2.6094913482666016e-04,
	-5.3107738494873047e-05}, /* L1695 */
{6.9457530975341797e+00, 2.8434395790100098e-04,
	1.1920928955078125e-07, -3.8725137710571289e-04,
	4.7433376312255859e-04}, /* L1696 */
{7.5628337860107422e+00, 3.0997209250926971e-04,
	1.1920928955078125e-07, 3.4880638122558594e-04,
	-1.6421079635620117e-04}, /* L1697 */
{8.9344701766967773e+00, 3.6644935607910156e-04,
	1.1920928955078125e-07, -2.6404857635498047e-05,
	3.8146972656250000e-05}, /* L1698 */
{8.3928050994873047e+00, 3.4471787512302399e-04,
	1.1920928955078125e-07, 8.5592269897460938e-05,
	2.8729438781738281e-05}, /* L1699 */
{7.4448008537292480e+00, 3.0811131000518799e-04,
	1.1920928955078125e-07, 4.2700767517089844e-03,
	1.3093948364257812e-03}, /* L1700 */
{7.5336132049560547e+00, 3.1045079231262207e-04,
	1.1920928955078125e-07, -3.9225816726684570e-04,
	-1.7702579498291016e-04}, /* L1701 */
{8.3356781005859375e+00, 3.4401565790176392e-04,
	1.1920928955078125e-07, -9.5546245574951172e-05,
	1.1432170867919922e-04}, /* L1702 */
{7.3213653564453125e+00, 3.0249357223510742e-04,
	1.1920928955078125e-07, 7.4625015258789062e-05,
	3.0994415283203125e-06}, /* L1703 */
{8.3764381408691406e+00, 3.4719705581665039e-04,
	1.1920928955078125e-07, 1.1534690856933594e-03,
	7.1549415588378906e-04}, /* L1704 */
{8.1920614242553711e+00, 3.3940374851226807e-04,
	1.1920928955078125e-07, -3.0159950256347656e-05,
	7.0929527282714844e-05}, /* L1705 */
{6.5224223136901855e+00, 2.7072429656982422e-04,
	1.1920928955078125e-07, 5.2893161773681641e-04,
	-6.4909458160400391e-05}, /* L1706 */
{7.5301632881164551e+00, 3.1288713216781616e-04,
	1.1920928955078125e-07, -1.6272068023681641e-05,
	-6.8664550781250000e-05}, /* L1707 */
{6.9484806060791016e+00, 2.8948485851287842e-04,
	1.1920928955078125e-07, 4.6479701995849609e-04,
	7.6484680175781250e-04}, /* L1708 */
{8.4858427047729492e+00, 3.5366415977478027e-04,
	1.1920928955078125e-07, 1.1384487152099609e-04,
	5.6028366088867188e-05}, /* L1709 */
{8.1798229217529297e+00, 3.4136325120925903e-04,
	1.1920928955078125e-07, -3.2961368560791016e-05,
	-1.5985965728759766e-04}, /* L1710 */
{8.0417051315307617e+00, 3.3633410930633545e-04,
	1.1920928955078125e-07, 3.1614303588867188e-04,
	2.0956993103027344e-04}, /* L1711 */
{6.3120932579040527e+00, 2.6422739028930664e-04,
	1.1920928955078125e-07, 2.5510787963867188e-05,
	2.5308132171630859e-04}, /* L1712 */
{7.5596413612365723e+00, 3.1697191298007965e-04,
	1.1920928955078125e-07, -1.7523765563964844e-05,
	2.9826164245605469e-04}, /* L1713 */
{8.9704370498657227e+00, 3.7647783756256104e-04,
	1.1920928955078125e-07, 2.9087066650390625e-05,
	-4.6610832214355469e-05}, /* L1714 */
{7.8447594642639160e+00, 3.2970309257507324e-04,
	1.1920928955078125e-07, -1.6093254089355469e-05,
	6.9141387939453125e-05}, /* L1715 */
{8.7568292617797852e+00, 3.6856532096862793e-04,
	1.1920928955078125e-07, -7.0333480834960938e-06,
	5.1736831665039062e-05}, /* L1716 */
{7.1848812103271484e+00, 3.0285865068435669e-04,
	1.1920928955078125e-07, -9.7155570983886719e-06,
	-1.5765428543090820e-04}, /* L1717 */
{6.2608566284179688e+00, 2.6431679725646973e-04,
	1.1920928955078125e-07, -5.8889389038085938e-05,
	1.3959407806396484e-04}, /* L1718 */
{7.1052174568176270e+00, 3.0028820037841797e-04,
	1.1920928955078125e-07, -6.5267086029052734e-05,
	3.0994415283203125e-06}, /* L1719 */
{8.1239242553710938e+00, 3.4400448203086853e-04,
	1.1920928955078125e-07, -1.6486644744873047e-04,
	-2.2834539413452148e-04}, /* L1720 */
{7.3886308670043945e+00, 3.1322240829467773e-04,
	1.1920928955078125e-07, 2.7298927307128906e-05,
	1.8274784088134766e-04}, /* L1721 */
{6.5135970115661621e+00, 2.7655065059661865e-04,
	1.1920928955078125e-07, -1.0621547698974609e-04,
	1.3160705566406250e-04}, /* L1722 */
{7.9292917251586914e+00, 3.3712387084960938e-04,
	1.1920928955078125e-07, -6.6161155700683594e-05,
	1.1408329010009766e-04}, /* L1723 */
{6.8155994415283203e+00, 2.9048323631286621e-04,
	1.1920928955078125e-07, -1.8739700317382812e-04,
	3.0899047851562500e-04}, /* L1724 */
{1.2214772224426270e+01, 5.2075088024139404e-04,
	1.1920928955078125e-07, 1.6331672668457031e-05,
	1.2993812561035156e-05}, /* L1725 */
{8.2308912277221680e+00, 3.5136938095092773e-04,
	1.1920928955078125e-07, -9.0539455413818359e-05,
	-5.1736831665039062e-05}, /* L1726 */
{7.8772892951965332e+00, 3.3681560307741165e-04,
	1.1920928955078125e-07, 7.2717666625976562e-05,
	1.1563301086425781e-05}, /* L1727 */
{7.1280322074890137e+00, 3.0514597892761230e-04,
	1.1920928955078125e-07, 9.5725059509277344e-05,
	-7.9214572906494141e-05}, /* L1728 */
{6.7140235900878906e+00, 2.8777122497558594e-04,
	1.1920928955078125e-07, -2.1398067474365234e-05,
	2.8729438781738281e-05}, /* L1729 */
{9.4931888580322266e+00, 4.0748715400695801e-04,
	1.1920928955078125e-07, -3.7074089050292969e-05,
	-2.0051002502441406e-04}, /* L1730 */
{8.0390768051147461e+00, 3.4582614898681641e-04,
	1.1920928955078125e-07, 2.6059150695800781e-04,
	1.9061565399169922e-04}, /* L1731 */
{8.4637918472290039e+00, 3.6428309977054596e-04,
	1.1920928955078125e-07, 4.8875808715820312e-06,
	-6.5565109252929688e-06}, /* L1732 */
{6.7536096572875977e+00, 2.9107183218002319e-04,
	1.1920928955078125e-07, 2.0742416381835938e-05,
	2.9325485229492188e-05}, /* L1733 */
{7.7602891921997070e+00, 3.3496320247650146e-04,
	1.1920928955078125e-07, -4.4286251068115234e-05,
	-1.0490417480468750e-04}, /* L1734 */
{8.2205200195312500e+00, 3.5539269447326660e-04,
	1.1920928955078125e-07, 4.4465065002441406e-05,
	-1.1539459228515625e-04}, /* L1735 */
{9.7931032180786133e+00, 4.2398273944854736e-04,
	1.1920928955078125e-07, -1.1318922042846680e-04,
	-7.0571899414062500e-05}, /* L1736 */
{9.1870574951171875e+00, 3.9863586425781250e-04,
	1.1920928955078125e-07, 1.8012523651123047e-04,
	-4.4214725494384766e-04}, /* L1737 */
{6.1563978195190430e+00, 2.6717782020568848e-04,
	1.1920928955078125e-07, -3.3855438232421875e-05,
	3.3855438232421875e-05}, /* L1738 */
{6.8462176322937012e+00, 2.9757618904113770e-04,
	1.1920928955078125e-07, -1.4549493789672852e-04,
	6.2823295593261719e-05}, /* L1739 */
{1.1501506805419922e+01, 5.0055235624313354e-04,
	1.1920928955078125e-07, -3.1471252441406250e-05,
	-6.5267086029052734e-05}, /* L1740 */
{8.1276788711547852e+00, 3.5434588789939880e-04,
	1.1920928955078125e-07, -2.8783082962036133e-04,
	2.7835369110107422e-04}, /* L1741 */
{8.9012432098388672e+00, 3.8963556289672852e-04,
	1.1920928955078125e-07, 6.5410137176513672e-04,
	2.0003318786621094e-04}, /* L1742 */
{8.9505472183227539e+00, 3.9109587669372559e-04,
	1.1920928955078125e-07, -9.0599060058593750e-06,
	-3.4928321838378906e-05}, /* L1743 */
{6.8560595512390137e+00, 3.0006840825080872e-04,
	1.1920928955078125e-07, 4.6968460083007812e-05,
	-1.9645690917968750e-04}, /* L1744 */
{7.6387114524841309e+00, 3.3494830131530762e-04,
	1.1920928955078125e-07, 1.8584728240966797e-04,
	2.1016597747802734e-04}, /* L1745 */
{1.3856999397277832e+01, 6.0841441154479980e-04,
	1.1920928955078125e-07, 1.8370151519775391e-04,
	-1.0305643081665039e-04}, /* L1746 */
{9.5806503295898438e+00, 4.2113661766052246e-04,
	1.1920928955078125e-07, 1.6701221466064453e-04,
	-2.7120113372802734e-05}, /* L1747 */
{9.3762521743774414e+00, 4.1258335113525391e-04,
	1.1920928955078125e-07, 9.2983245849609375e-06,
	-2.7179718017578125e-05}, /* L1748 */
{7.1638541221618652e+00, 3.1572580337524414e-04,
	1.1920928955078125e-07, 9.1433525085449219e-05,
	6.5803527832031250e-05}, /* L1749 */
{1.0060608863830566e+01, 4.4420361518859863e-04,
	1.1920928955078125e-07, 9.4652175903320312e-05,
	2.0051002502441406e-04}, /* L1750 */
{1.0392632484436035e+01, 4.5907497406005859e-04,
	1.1920928955078125e-07, -6.9022178649902344e-05,
	-3.6299228668212891e-05}, /* L1751 */
{1.0086337089538574e+01, 4.4629722833633423e-04,
	1.1920928955078125e-07, -1.9544363021850586e-04,
	2.3961067199707031e-05}, /* L1752 */
{6.8485445976257324e+00, 3.0413269996643066e-04,
	1.1920928955078125e-07, 3.1352043151855469e-04,
	-1.0773539543151855e-03}, /* L1753 */
{7.3182778358459473e+00, 3.2487511634826660e-04,
	1.1920928955078125e-07, 1.4674663543701172e-04,
	3.5083293914794922e-04}, /* L1754 */
{1.1382732391357422e+01, 5.0559639930725098e-04,
	1.1920928955078125e-07, 1.1527538299560547e-04,
	-1.7821788787841797e-05}, /* L1755 */
{1.1784219741821289e+01, 5.2417814731597900e-04,
	1.1920928955078125e-07, -2.4318695068359375e-05,
	1.4448165893554688e-04}, /* L1756 */
{1.0092412948608398e+01, 4.4946372509002686e-04,
	1.1920928955078125e-07, -3.5822391510009766e-05,
	-1.7285346984863281e-06}, /* L1757 */
{8.1610031127929688e+00, 3.6394596099853516e-04,
	1.1920928955078125e-07, -3.4093856811523438e-05,
	-9.8705291748046875e-05}, /* L1758 */
{7.2934813499450684e+00, 3.2569468021392822e-04,
	1.1920928955078125e-07, -2.9087066650390625e-05,
	4.2796134948730469e-05}, /* L1759 */
{8.9696063995361328e+00, 4.0209293365478516e-04,
	1.1920928955078125e-07, 3.5285949707031250e-05,
	6.9642066955566406e-04}, /* L1760 */
{7.7596564292907715e+00, 3.4902349580079317e-04,
	1.1920928955078125e-07, -3.0612945556640625e-04,
	1.8527507781982422e-03}, /* L1761 */
{7.5170044898986816e+00, 3.3697485923767090e-04,
	1.1920928955078125e-07, -5.7280063629150391e-05,
	3.1471252441406250e-05}, /* L1762 */
{7.3801550865173340e+00, 3.3152103424072266e-04,
	1.1920928955078125e-07, 3.1113624572753906e-04,
	-3.6716461181640625e-05}, /* L1763 */
{7.7326264381408691e+00, 3.4764409065246582e-04,
	1.1920928955078125e-07, -1.4668703079223633e-04,
	1.5175342559814453e-04}, /* L1764 */
{9.9847259521484375e+00, 4.4937431812286377e-04,
	1.1920928955078125e-07, 5.2332878112792969e-05,
	2.6941299438476562e-05}, /* L1765 */
{7.6198606491088867e+00, 3.4343823790550232e-04,
	1.1920928955078125e-07, -4.8339366912841797e-05,
	6.9141387939453125e-05}, /* L1766 */
{9.3424644470214844e+00, 4.2179226875305176e-04,
	1.1920928955078125e-07, 9.6797943115234375e-05,
	8.2492828369140625e-05}, /* L1767 */
{1.0122292518615723e+01, 4.5834481716156006e-04,
	1.1920928955078125e-07, 1.8191337585449219e-04,
	3.9446353912353516e-04}, /* L1768 */
{7.8261585235595703e+00, 3.5451352596282959e-04,
	1.1920928955078125e-07, 2.7298927307128906e-05,
	-3.4487247467041016e-04}, /* L1769 */
{6.3397402763366699e+00, 2.8729438781738281e-04,
	1.1920928955078125e-07, 6.1154365539550781e-05,
	-7.3611736297607422e-05}, /* L1770 */
{8.0116338729858398e+00, 3.6415457725524902e-04,
	1.1920928955078125e-07, 2.9325485229492188e-05,
	-2.3478269577026367e-04}, /* L1771 */
{6.4598374366760254e+00, 2.9349327087402344e-04,
	1.1920928955078125e-07, -5.3763389587402344e-05,
	1.1920928955078125e-06}, /* L1772 */
{7.8836803436279297e+00, 3.5864114761352539e-04,
	1.1920928955078125e-07, 1.6093254089355469e-05,
	2.2649765014648438e-06}, /* L1773 */
{7.3308377265930176e+00, 3.3399462699890137e-04,
	1.1920928955078125e-07, 9.0599060058593750e-06,
	-5.1498413085937500e-05}, /* L1774 */
{8.9430446624755859e+00, 4.0802359580993652e-04,
	1.1920928955078125e-07, -2.8252601623535156e-05,
	7.9989433288574219e-05}, /* L1775 */
{7.7559614181518555e+00, 3.5418570041656494e-04,
	1.1920928955078125e-07, -6.0677528381347656e-05,
	1.2338161468505859e-04}, /* L1776 */
{8.5532112121582031e+00, 3.9142370223999023e-04,
	1.1920928955078125e-07, 3.3950805664062500e-04,
	2.3829936981201172e-04}, /* L1777 */
{8.1330900192260742e+00, 3.7238001823425293e-04,
	1.1920928955078125e-07, 8.1658363342285156e-05,
	-4.2259693145751953e-05}, /* L1778 */
{7.8867855072021484e+00, 3.6156177520751953e-04,
	1.1920928955078125e-07, 5.8531761169433594e-05,
	-3.3974647521972656e-05}, /* L1779 */
{9.2829980850219727e+00, 4.2662024497985840e-04,
	1.1920928955078125e-07, -7.8797340393066406e-05,
	-2.9522180557250977e-04}, /* L1780 */
{7.8920426368713379e+00, 3.6305189132690430e-04,
	1.1920928955078125e-07, -2.1296739578247070e-04,
	2.3496150970458984e-04}, /* L1781 */
{5.2652087211608887e+00, 2.4230778217315674e-04,
	1.1920928955078125e-07, -1.9311904907226562e-05,
	8.9406967163085938e-06}, /* L1782 */
{6.5016040802001953e+00, 2.9963254928588867e-04,
	1.1920928955078125e-07, 1.9443035125732422e-04,
	-1.8566846847534180e-04}, /* L1783 */
{9.1465921401977539e+00, 4.2220950126647949e-04,
	1.1920928955078125e-07, -2.5057792663574219e-04,
	8.3446502685546875e-05}, /* L1784 */
{7.5987195968627930e+00, 3.5110116004943848e-04,
	1.1920928955078125e-07, -7.4267387390136719e-05,
	-1.7285346984863281e-05}, /* L1785 */
{1.1630291938781738e+01, 5.3809583187103271e-04,
	1.1920928955078125e-07, 2.2125244140625000e-04,
	-6.9677829742431641e-05}, /* L1786 */
{7.4712214469909668e+00, 3.4604966640472412e-04,
	1.1920928955078125e-07, -1.1742115020751953e-05,
	-1.1265277862548828e-05}, /* L1787 */
{9.6669740676879883e+00, 4.4859945774078369e-04,
	1.1920928955078125e-07, 1.4150142669677734e-04,
	-5.3405761718750000e-05}, /* L1788 */
{8.1722412109375000e+00, 3.7953257560729980e-04,
	1.1920928955078125e-07, -3.0994415283203125e-06,
	-8.7618827819824219e-05}, /* L1789 */
{8.9006671905517578e+00, 4.1392445564270020e-04,
	1.1920928955078125e-07, -1.6689300537109375e-05,
	-4.3511390686035156e-06}, /* L1790 */
{7.6381330490112305e+00, 3.5577919334173203e-04,
	1.1920928955078125e-07, 2.3305416107177734e-04,
	3.1912326812744141e-04}, /* L1791 */
{8.4448270797729492e+00, 3.9374083280563354e-04,
	1.1920928955078125e-07, 1.0299682617187500e-04,
	-8.8632106781005859e-05}, /* L1792 */
{6.0394244194030762e+00, 2.8195232152938843e-04,
	1.1920928955078125e-07, -6.4432621002197266e-05,
	-2.7418136596679688e-05}, /* L1793 */
{8.4957714080810547e+00, 3.9707217365503311e-04,
	1.1920928955078125e-07, 6.4015388488769531e-05,
	-4.6670436859130859e-05}, /* L1794 */
{8.2524023056030273e+00, 3.8620829582214355e-04,
	1.1920928955078125e-07, 4.1007995605468750e-05,
	-2.1517276763916016e-05}, /* L1795 */
{8.9413251876831055e+00, 4.1896104812622070e-04,
	1.1920928955078125e-07, -2.0027160644531250e-05,
	-2.0265579223632812e-06}, /* L1796 */
{7.5875697135925293e+00, 3.5599619150161743e-04,
	1.1920928955078125e-07, -3.0398368835449219e-06,
	2.2053718566894531e-05}, /* L1797 */
{9.3489646911621094e+00, 4.3928623199462891e-04,
	1.1920928955078125e-07, 7.7486038208007812e-06,
	5.7220458984375000e-05}, /* L1798 */
{9.4379720687866211e+00, 4.4991075992584229e-04,
	1.1920928955078125e-07, -1.2984871864318848e-03,
	4.7528743743896484e-04}, /* L1799 */
{8.9030637741088867e+00, 4.1933357715606689e-04,
	1.1920928955078125e-07, 4.7206878662109375e-05,
	5.2809715270996094e-05}, /* L1800 */
{9.6848850250244141e+00, 4.5676529407501221e-04,
	1.1920928955078125e-07, 1.4591217041015625e-04,
	-3.2186508178710938e-06}, /* L1801 */
{8.3598384857177734e+00, 3.9549171924591064e-04,
	1.1920928955078125e-07, 4.7934055328369141e-04,
	-3.0088424682617188e-04}, /* L1802 */
{8.4960269927978516e+00, 4.0179770439863205e-04,
	1.1920928955078125e-07, -1.6629695892333984e-05,
	1.5556812286376953e-04}, /* L1803 */
{9.2985544204711914e+00, 4.4021688518114388e-04,
	1.1920928955078125e-07, 1.9252300262451172e-04,
	-2.1517276763916016e-04}, /* L1804 */
{9.7057590484619141e+00, 4.6023726463317871e-04,
	1.1920928955078125e-07, 2.8359889984130859e-04,
	-3.3080577850341797e-04}, /* L1805 */
{7.9213466644287109e+00, 3.7634372711181641e-04,
	1.1920928955078125e-07, -8.3565711975097656e-05,
	1.5676021575927734e-04}, /* L1806 */
{9.6130933761596680e+00, 4.5680999755859375e-04,
	1.1920928955078125e-07, 5.4717063903808594e-05,
	-3.5881996154785156e-05}, /* L1807 */
{7.3325204849243164e+00, 3.4882128238677979e-04,
	1.1920928955078125e-07, -6.3180923461914062e-05,
	9.5367431640625000e-07}, /* L1808 */
{1.3709208488464355e+01, 6.5575912594795227e-04,
	1.1920928955078125e-07, -1.9404292106628418e-03,
	2.8967857360839844e-05}, /* L1809 */
{8.5193071365356445e+00, 4.0632486343383789e-04,
	1.1920928955078125e-07, 1.9073486328125000e-04,
	2.9683113098144531e-05}, /* L1810 */
{9.9353561401367188e+00, 4.7567486763000488e-04,
	1.1920928955078125e-07, -6.5171718597412109e-04,
	5.9115886688232422e-04}, /* L1811 */
{8.1408920288085938e+00, 3.8932263851165771e-04,
	1.1920928955078125e-07, 8.8214874267578125e-05,
	-2.1833181381225586e-04}, /* L1812 */
{8.4855289459228516e+00, 4.0661357343196869e-04,
	1.1920928955078125e-07, 3.1280517578125000e-04,
	3.6406517028808594e-04}, /* L1813 */
{9.4413423538208008e+00, 4.5257806777954102e-04,
	1.1920928955078125e-07, 7.8797340393066406e-05,
	-1.3589859008789062e-05}, /* L1814 */
{8.0692148208618164e+00, 3.8731098175048828e-04,
	1.1920928955078125e-07, -6.3240528106689453e-05,
	-1.4781951904296875e-05}, /* L1815 */
{1.0032471656799316e+01, 4.8217177391052246e-04,
	1.1920928955078125e-07, 7.5101852416992188e-05,
	7.8201293945312500e-05}, /* L1816 */
{1.0497788429260254e+01, 5.0520896911621094e-04,
	1.1920928955078125e-07, 2.0062923431396484e-04,
	-1.1920928955078125e-07}, /* L1817 */
{8.5386505126953125e+00, 4.1130185127258301e-04,
	1.1920928955078125e-07, -4.8279762268066406e-05,
	5.9723854064941406e-05}, /* L1818 */
{6.9657130241394043e+00, 3.3596158027648926e-04,
	1.1920928955078125e-07, -5.9485435485839844e-05,
	8.4638595581054688e-06}, /* L1819 */
{6.6829357147216797e+00, 3.2269954681396484e-04,
	1.1920928955078125e-07, 2.9563903808593750e-05,
	2.8610229492187500e-05}, /* L1820 */
{9.6015148162841797e+00, 4.6496093273162842e-04,
	1.1920928955078125e-07, -1.8113851547241211e-04,
	-1.8864870071411133e-04}, /* L1821 */
{7.5750684738159180e+00, 3.6722421646118164e-04,
	1.1920928955078125e-07, 1.2636184692382812e-04,
	-3.3521652221679688e-04}, /* L1822 */
{8.1503810882568359e+00, 3.9502978324890137e-04,
	1.1920928955078125e-07, 2.3245811462402344e-05,
	1.1205673217773438e-05}, /* L1823 */
{9.1790513992309570e+00, 4.4545531272888184e-04,
	1.1920928955078125e-07, 1.5497207641601562e-05,
	-2.4437904357910156e-05}, /* L1824 */
{1.0218440055847168e+01, 4.9647688865661621e-04,
	1.1920928955078125e-07, -1.0848045349121094e-05,
	-1.1682510375976562e-05}, /* L1825 */
{1.0018550872802734e+01, 4.8764050006866455e-04,
	1.1920928955078125e-07, 3.7276744842529297e-04,
	-2.6851892471313477e-04}, /* L1826 */
{1.1475614547729492e+01, 5.5900216102600098e-04,
	1.1920928955078125e-07, -1.0490417480468750e-05,
	8.7022781372070312e-06}, /* L1827 */
{7.5149459838867188e+00, 3.6661699414253235e-04,
	1.1920928955078125e-07, 2.0074844360351562e-04,
	-1.8823146820068359e-04}, /* L1828 */
{8.7518529891967773e+00, 4.2748451232910156e-04,
	1.1920928955078125e-07, -1.0424852371215820e-04,
	-5.0067901611328125e-05}, /* L1829 */
{9.5794782638549805e+00, 4.6828389167785645e-04,
	1.1920928955078125e-07, 6.3180923461914062e-06,
	1.1920928955078125e-05}, /* L1830 */
{7.7948117256164551e+00, 3.8161873817443848e-04,
	1.1920928955078125e-07, 5.9127807617187500e-05,
	-2.4259090423583984e-05}, /* L1831 */
{6.8610491752624512e+00, 3.3641606569290161e-04,
	1.1920928955078125e-07, -2.8663873672485352e-04,
	-2.2703409194946289e-04}, /* L1832 */
{1.1438397407531738e+01, 5.6164711713790894e-04,
	1.1920928955078125e-07, -5.7816505432128906e-04,
	-3.6299228668212891e-04}, /* L1833 */
{9.0859918594360352e+00, 4.4649466872215271e-04,
	1.1920928955078125e-07, -2.4306774139404297e-04,
	2.6357173919677734e-04}, /* L1834 */
{9.2801256179809570e+00, 4.5673549175262451e-04,
	1.1920928955078125e-07, 2.9206275939941406e-05,
	-2.4962425231933594e-04}, /* L1835 */
{7.4274253845214844e+00, 3.6585330963134766e-04,
	1.1920928955078125e-07, 3.7789344787597656e-05,
	-1.9091367721557617e-04}, /* L1836 */
{1.1450325012207031e+01, 5.6454539299011230e-04,
	1.1920928955078125e-07, -3.2007694244384766e-05,
	6.1988830566406250e-06}, /* L1837 */
{8.5475053787231445e+00, 4.2253732681274414e-04,
	1.1920928955078125e-07, 3.9100646972656250e-04,
	2.8538703918457031e-04}, /* L1838 */
{7.4893050193786621e+00, 3.7036836147308350e-04,
	1.1920928955078125e-07, -3.2490491867065430e-04,
	4.2247772216796875e-04}, /* L1839 */
{1.1874397277832031e+01, 5.8771669864654541e-04,
	1.1920928955078125e-07, 1.9013881683349609e-04,
	1.1134147644042969e-04}, /* L1840 */
{9.4951753616333008e+00, 4.7510862350463867e-04,
	1.1920928955078125e-07, -4.7467350959777832e-03,
	-3.1897425651550293e-03}, /* L1841 */
{6.9518699645996094e+00, 3.4487247467041016e-04,
	1.1920928955078125e-07, -1.4883279800415039e-04,
	7.2121620178222656e-05}, /* L1842 */
{7.0681729316711426e+00, 3.5104155540466309e-04,
	1.1920928955078125e-07, 2.0813941955566406e-04,
	1.1444091796875000e-05}, /* L1843 */
{1.0756000518798828e+01, 5.3673237562179565e-04,
	1.1920928955078125e-07, 1.0007619857788086e-03,
	-1.9377470016479492e-03}, /* L1844 */
{8.8895196914672852e+00, 4.4274330139160156e-04,
	1.1920928955078125e-07, 2.7668476104736328e-04,
	-1.0246038436889648e-04}, /* L1845 */
{7.7958626747131348e+00, 3.8865208625793457e-04,
	1.1920928955078125e-07, 2.7418136596679688e-06,
	1.0967254638671875e-05}, /* L1846 */
{7.6057376861572266e+00, 3.7956237792968750e-04,
	1.1920928955078125e-07, 9.7751617431640625e-05,
	3.9935111999511719e-05}, /* L1847 */
{6.5784082412719727e+00, 3.2880157232284546e-04,
	1.1920928955078125e-07, 1.9431114196777344e-05,
	-3.0541419982910156e-04}, /* L1848 */
{8.9543466567993164e+00, 4.4825673103332520e-04,
	1.1920928955078125e-07, 2.4735927581787109e-04,
	-2.1570920944213867e-04}, /* L1849 */
{9.0601425170898438e+00, 4.5377761125564575e-04,
	1.1920928955078125e-07, 2.7298927307128906e-05,
	-8.4877014160156250e-05}, /* L1850 */
{1.0608367919921875e+01, 5.3188204765319824e-04,
	1.1920928955078125e-07, -4.9352645874023438e-05,
	-3.2126903533935547e-05}, /* L1851 */
{8.4174890518188477e+00, 4.2295455932617188e-04,
	1.1920928955078125e-07, -2.1207332611083984e-04,
	5.1617622375488281e-05}, /* L1852 */
{8.9814271926879883e+00, 4.5187771320343018e-04,
	1.1920928955078125e-07, -5.4836273193359375e-04,
	8.9180469512939453e-04}, /* L1853 */
{8.0059556961059570e+00, 4.0289759635925293e-04,
	1.1920928955078125e-07, -1.9848346710205078e-05,
	1.0836124420166016e-04}, /* L1854 */
{8.2595949172973633e+00, 4.1610747575759888e-04,
	1.1920928955078125e-07, -8.3506107330322266e-05,
	-1.3887882232666016e-05}, /* L1855 */
{9.0352134704589844e+00, 4.5570731163024902e-04,
	1.1920928955078125e-07, -3.3378601074218750e-05,
	3.0040740966796875e-05}, /* L1856 */
{8.3262290954589844e+00, 4.2049586772918701e-04,
	1.1920928955078125e-07, -8.8095664978027344e-05,
	-5.7816505432128906e-06}, /* L1857 */
{9.2682580947875977e+00, 4.6864151954650879e-04,
	1.1920928955078125e-07, -2.8300285339355469e-04,
	-8.7916851043701172e-05}, /* L1858 */
{9.8189849853515625e+00, 4.9709901213645935e-04,
	1.1920928955078125e-07, -1.1974573135375977e-04,
	-9.4830989837646484e-05}, /* L1859 */
{1.0359735488891602e+01, 5.2499771118164062e-04,
	1.1920928955078125e-07, 1.9323825836181641e-04,
	-2.0384788513183594e-05}, /* L1860 */
{6.5773878097534180e+00, 3.3459067344665527e-04,
	1.1920928955078125e-07, -1.4141798019409180e-03,
	8.0692768096923828e-04}, /* L1861 */
{8.6505784988403320e+00, 4.3940544128417969e-04,
	1.1920928955078125e-07, 9.0479850769042969e-05,
	3.2305717468261719e-05}, /* L1862 */
{6.9849939346313477e+00, 3.5546859726309776e-04,
	1.1920928955078125e-07, 5.6743621826171875e-04,
	-2.5689601898193359e-04}, /* L1863 */
{9.3527984619140625e+00, 4.7633051872253418e-04,
	1.1920928955078125e-07, 4.5061111450195312e-05,
	-8.8810920715332031e-06}, /* L1864 */
{8.6561861038208008e+00, 4.4298171997070312e-04,
	1.1920928955078125e-07, -5.4836273193359375e-04,
	-2.4150609970092773e-03}, /* L1865 */
{8.7005128860473633e+00, 4.4403225183486938e-04,
	1.1920928955078125e-07, -2.2590160369873047e-05,
	-3.5524368286132812e-05}, /* L1866 */
{7.5531415939331055e+00, 3.8588047027587891e-04,
	1.1920928955078125e-07, 2.9802322387695312e-05,
	-6.0737133026123047e-05}, /* L1867 */
{8.7230911254882812e+00, 4.4808536767959595e-04,
	1.1920928955078125e-07, -8.9961290359497070e-04,
	-2.3205280303955078e-03}, /* L1868 */
{8.5916881561279297e+00, 4.4009089469909668e-04,
	1.1920928955078125e-07, 1.0716915130615234e-04,
	-2.9814243316650391e-04}, /* L1869 */
{9.1893367767333984e+00, 4.7269463539123535e-04,
	1.1920928955078125e-07, 8.4483623504638672e-04,
	2.0468235015869141e-04}, /* L1870 */
{7.6518578529357910e+00, 3.9274990558624268e-04,
	1.1920928955078125e-07, 1.4424324035644531e-05,
	-4.1127204895019531e-06}, /* L1871 */
{1.2129143714904785e+01, 6.2337517738342285e-04,
	1.1920928955078125e-07, 1.0108947753906250e-04,
	-9.4175338745117188e-06}, /* L1872 */
{8.4717893600463867e+00, 4.3584406375885010e-04,
	1.1920928955078125e-07, 2.9087066650390625e-05,
	-5.7816505432128906e-06}, /* L1873 */
{8.3352432250976562e+00, 4.2951107025146484e-04,
	1.1920928955078125e-07, -2.9802322387695312e-06,
	-8.1658363342285156e-05}, /* L1874 */
{9.2474269866943359e+00, 4.7698616981506348e-04,
	1.1920928955078125e-07, -2.6881694793701172e-05,
	-8.8512897491455078e-05}, /* L1875 */
{9.2441177368164062e+00, 4.7749280929565430e-04,
	1.1920928955078125e-07, -1.6427040100097656e-04,
	1.6307830810546875e-04}, /* L1876 */
{9.9934844970703125e+00, 5.1665306091308594e-04,
	1.1920928955078125e-07, 4.7326087951660156e-05,
	1.1026859283447266e-04}, /* L1877 */
{1.1417752265930176e+01, 5.9089064598083496e-04,
	1.1920928955078125e-07, 5.2332878112792969e-05,
	-3.3318996429443359e-05}, /* L1878 */
{7.9370808601379395e+00, 4.1124224662780762e-04,
	1.1920928955078125e-07, 1.7428398132324219e-04,
	6.7710876464843750e-05}, /* L1879 */
{9.8608522415161133e+00, 5.1711872220039368e-04,
	1.1920928955078125e-07, -1.4584660530090332e-03,
	1.9093751907348633e-03}, /* L1880 */
{8.2230386734008789e+00, 4.2715668678283691e-04,
	1.1920928955078125e-07, 1.6713142395019531e-04,
	1.9180774688720703e-04}, /* L1881 */
{7.4083065986633301e+00, 3.8517266511917114e-04,
	1.1920928955078125e-07, 2.6941299438476562e-05,
	8.3327293395996094e-05}, /* L1882 */
{9.2573480606079102e+00, 4.8185419291257858e-04,
	1.1920928955078125e-07, -3.5166740417480469e-06,
	4.1961669921875000e-05}, /* L1883 */
{1.0731763839721680e+01, 5.5927038192749023e-04,
	1.1920928955078125e-07, -2.6583671569824219e-04,
	4.1246414184570312e-05}, /* L1884 */
{9.9990072250366211e+00, 5.2294135093688965e-04,
	1.1920928955078125e-07, -7.5775384902954102e-04,
	-6.0123205184936523e-04}, /* L1885 */
{1.0617819786071777e+01, 5.5624544620513916e-04,
	1.1920928955078125e-07, -1.2918114662170410e-03,
	-2.8576850891113281e-03}, /* L1886 */
{7.6358456611633301e+00, 3.9932131767272949e-04,
	1.1920928955078125e-07, -9.3579292297363281e-06,
	-5.2213668823242188e-05}, /* L1887 */
{8.3299045562744141e+00, 4.3621659278869629e-04,
	1.1920928955078125e-07, 1.8310546875000000e-04,
	1.8501281738281250e-04}, /* L1888 */
{9.2889890670776367e+00, 4.8676133155822754e-04,
	1.1920928955078125e-07, -9.2267990112304688e-05,
	7.0214271545410156e-05}, /* L1889 */
{7.5539221763610840e+00, 4.0073692798614502e-04,
	1.1920928955078125e-07, 4.8210620880126953e-03,
	1.6785860061645508e-03}, /* L1890 */
{8.1479606628417969e+00, 4.3424963951110840e-04,
	1.1920928955078125e-07, -1.3075470924377441e-03,
	-2.0909309387207031e-04}, /* L1891 */
{6.6375904083251953e+00, 3.4964084625244141e-04,
	1.1920928955078125e-07, 7.8320503234863281e-05,
	3.7717819213867188e-04}, /* L1892 */
{9.0733795166015625e+00, 4.7793984413146973e-04,
	1.1920928955078125e-07, -2.3221969604492188e-04,
	-3.7759542465209961e-04}, /* L1893 */
{7.9673933982849121e+00, 4.2000412940979004e-04,
	1.1920928955078125e-07, 6.5565109252929688e-05,
	8.2015991210937500e-05}, /* L1894 */
{1.0386767387390137e+01, 5.4809451103210449e-04,
	1.1920928955078125e-07, -7.5995922088623047e-05,
	-1.5854835510253906e-05}, /* L1895 */
{1.0470783233642578e+01, 5.5384635925292969e-04,
	1.1920928955078125e-07, 8.0704689025878906e-05,
	1.0120868682861328e-04}, /* L1896 */
{8.9655103683471680e+00, 4.7418475151062012e-04,
	1.1920928955078125e-07, 1.5819072723388672e-04,
	-1.6987323760986328e-05}, /* L1897 */
{1.0187598228454590e+01, 5.3933262825012207e-04,
	1.1920928955078125e-07, 6.5922737121582031e-05,
	3.7670135498046875e-05}, /* L1898 */
{1.1103092193603516e+01, 5.8859586715698242e-04,
	1.1920928955078125e-07, 8.8810920715332031e-05,
	1.5985965728759766e-04}, /* L1899 */
{1.1348529815673828e+01, 6.0232728719711304e-04,
	1.1920928955078125e-07, -3.8623809814453125e-05,
	9.5129013061523438e-05}, /* L1900 */
{1.0201865196228027e+01, 5.4249167442321777e-04,
	1.1920928955078125e-07, -1.1128187179565430e-04,
	5.1534175872802734e-04}, /* L1901 */
{1.0959078788757324e+01, 5.8294832706451416e-04,
	1.1920928955078125e-07, -2.4318695068359375e-04,
	2.3114681243896484e-04}, /* L1902 */
{9.6982774734497070e+00, 5.1629543304443359e-04,
	1.1920928955078125e-07, 1.3113021850585938e-05,
	2.3484230041503906e-05}, /* L1903 */
{1.1804619789123535e+01, 6.2921643257141113e-04,
	1.1920928955078125e-07, -2.6643276214599609e-05,
	2.1123886108398438e-04}, /* L1904 */
{1.0200138092041016e+01, 5.4486095905303955e-04,
	1.1920928955078125e-07, 8.7666511535644531e-04,
	-4.2217969894409180e-04}, /* L1905 */
{9.2188777923583984e+00, 4.9246102571487427e-04,
	1.1920928955078125e-07, 2.4676322937011719e-05,
	2.0623207092285156e-05}, /* L1906 */
{1.0456287384033203e+01, 5.5949389934539795e-04,
	1.1920928955078125e-07, -2.7060508728027344e-05,
	-3.4934282302856445e-04}, /* L1907 */
{9.0423278808593750e+00, 4.8449635505676270e-04,
	1.1920928955078125e-07, 7.0929527282714844e-05,
	-5.6469440460205078e-04}, /* L1908 */
{1.1014037132263184e+01, 5.9181451797485352e-04,
	1.1920928955078125e-07, -5.2487850189208984e-04,
	-6.7114830017089844e-05}, /* L1909 */
{8.3355932235717773e+00, 4.4730305671691895e-04,
	1.1920928955078125e-07, -1.0192394256591797e-05,
	5.1379203796386719e-05}, /* L1910 */
{1.0213484764099121e+01, 5.4895877838134766e-04,
	1.1920928955078125e-07, 4.4870376586914062e-04,
	1.3160705566406250e-04}, /* L1911 */
{9.5378265380859375e+00, 5.1292777061462402e-04,
	1.1920928955078125e-07, -7.9393386840820312e-05,
	7.3909759521484375e-05}, /* L1912 */
{1.0189579963684082e+01, 5.4869055747985840e-04,
	1.1920928955078125e-07, -1.3172626495361328e-05,
	6.8306922912597656e-05}, /* L1913 */
{1.2732538223266602e+01, 6.8700313568115234e-04,
	1.1920928955078125e-07, 6.9832801818847656e-04,
	3.5011768341064453e-04}, /* L1914 */
{8.5322532653808594e+00, 4.6125426888465881e-04,
	1.1920928955078125e-07, -1.0893344879150391e-03,
	-1.1384487152099609e-04}, /* L1915 */
{9.4907054901123047e+00, 5.1279366016387939e-04,
	1.1920928955078125e-07, 4.0650367736816406e-05,
	-2.2530555725097656e-05}, /* L1916 */
{7.6368107795715332e+00, 4.1300058364868164e-04,
	1.1920928955078125e-07, -2.1994113922119141e-05,
	1.7642974853515625e-05}, /* L1917 */
{8.9430675506591797e+00, 4.8416852951049805e-04,
	1.1920928955078125e-07, 1.5139579772949219e-05,
	3.0755996704101562e-05}, /* L1918 */
{9.6885662078857422e+00, 5.2526593208312988e-04,
	1.1920928955078125e-07, 2.2149085998535156e-04,
	9.6082687377929688e-05}, /* L1919 */
{1.1273062705993652e+01, 6.1184167861938477e-04,
	1.1920928955078125e-07, 2.1934509277343750e-05,
	1.4090538024902344e-04}, /* L1920 */
{8.2396593093872070e+00, 4.4792890548706055e-04,
	1.1920928955078125e-07, 2.2864341735839844e-04,
	2.9540061950683594e-04}, /* L1921 */
{9.3179578781127930e+00, 5.0947070121765137e-04,
	1.1920928955078125e-07, 2.4203062057495117e-03,
	-4.7564506530761719e-05}, /* L1922 */
{9.7452087402343750e+00, 5.3104758262634277e-04,
	1.1920928955078125e-07, -1.7464160919189453e-05,
	-7.8511238098144531e-04}, /* L1923 */
{9.1860475540161133e+00, 5.0061941146850586e-04,
	1.1920928955078125e-07, 4.9591064453125000e-05,
	-8.3684921264648438e-05}, /* L1924 */
{8.4290475845336914e+00, 4.5995414257049561e-04,
	1.1920928955078125e-07, 1.5830993652343750e-04,
	-1.2934207916259766e-05}, /* L1925 */
{9.1229066848754883e+00, 5.0601363182067871e-04,
	1.1920928955078125e-07, 6.1523914337158203e-04,
	-4.0934681892395020e-03}, /* L1926 */
{8.0631389617919922e+00, 4.4082850217819214e-04,
	1.1920928955078125e-07, -4.8696994781494141e-05,
	-3.5107135772705078e-05}, /* L1927 */
{8.6928014755249023e+00, 4.7783553600311279e-04,
	1.1920928955078125e-07, -9.1612339019775391e-04,
	-2.5457143783569336e-03}, /* L1928 */
{9.6367349624633789e+00, 5.2803754806518555e-04,
	1.1920928955078125e-07, -1.4740228652954102e-04,
	-2.4133920669555664e-04}, /* L1929 */
{1.1175786018371582e+01, 6.1327219009399414e-04,
	1.1920928955078125e-07, 2.1827220916748047e-04,
	2.4306774139404297e-04}, /* L1930 */
{1.0167559623718262e+01, 5.5964291095733643e-04,
	1.1920928955078125e-07, -2.8723478317260742e-04,
	4.0638446807861328e-04}, /* L1931 */
{1.0183979988098145e+01, 5.5974721908569336e-04,
	1.1920928955078125e-07, -3.2603740692138672e-05,
	2.4437904357910156e-05}, /* L1932 */
{8.8087539672851562e+00, 4.8625469207763672e-04,
	1.1920928955078125e-07, -1.1152029037475586e-03,
	-1.8329024314880371e-03}, /* L1933 */
{1.4495589256286621e+01, 8.0052018165588379e-04,
	1.1920928955078125e-07, -1.2446641921997070e-03,
	-1.2664198875427246e-03}, /* L1934 */
{1.0585183143615723e+01, 5.8382749557495117e-04,
	1.1920928955078125e-07, 1.5079975128173828e-04,
	1.0323524475097656e-04}, /* L1935 */
{1.0339366912841797e+01, 5.7132169604301453e-04,
	1.1920928955078125e-07, -4.0733814239501953e-04,
	-4.0030479431152344e-04}, /* L1936 */
{1.0962856292724609e+01, 6.0608610510826111e-04,
	1.1920928955078125e-07, -3.0040740966796875e-05,
	-2.4819374084472656e-04}, /* L1937 */
{1.0381913185119629e+01, 5.7502835988998413e-04,
	1.1920928955078125e-07, -3.5697221755981445e-04,
	2.5451183319091797e-04}, /* L1938 */
{1.1519732475280762e+01, 6.3921511173248291e-04,
	1.1920928955078125e-07, 1.3747215270996094e-03,
	-7.0559978485107422e-04}, /* L1939 */
{9.5184192657470703e+00, 5.3052604198455811e-04,
	1.1920928955078125e-07, -2.7453899383544922e-04,
	4.1484832763671875e-05}, /* L1940 */
{8.5668268203735352e+00, 4.7579407691955566e-04,
	1.1920928955078125e-07, 9.1314315795898438e-05,
	-2.3722648620605469e-04}, /* L1941 */
{9.4552268981933594e+00, 5.4079294204711914e-04,
	1.1920928955078125e-07, 4.3010711669921875e-04,
	-4.7474503517150879e-03}, /* L1942 */
{1.1977722167968750e+01, 6.6637992858886719e-04,
	1.1920928955078125e-07, 3.5047531127929688e-05,
	5.1021575927734375e-05}, /* L1943 */
{1.0210963249206543e+01, 5.6863576173782349e-04,
	1.1920928955078125e-07, -1.4752149581909180e-04,
	-1.4781951904296875e-05}, /* L1944 */
{1.2073630332946777e+01, 6.7320466041564941e-04,
	1.1920928955078125e-07, 5.0902366638183594e-05,
	7.1763992309570312e-05}, /* L1945 */
{7.5864367485046387e+00, 4.3940544128417969e-04,
	1.1920928955078125e-07, 1.1296272277832031e-03,
	-8.2113146781921387e-03}, /* L1946 */
{9.6716833114624023e+00, 5.4062157869338989e-04,
	1.1920928955078125e-07, 1.5103816986083984e-04,
	1.6689300537109375e-05}, /* L1947 */
{1.0730534553527832e+01, 6.0021877288818359e-04,
	1.1920928955078125e-07, -2.5868415832519531e-04,
	4.1961669921875000e-05}, /* L1948 */
{8.7035503387451172e+00, 4.8764050006866455e-04,
	1.1920928955078125e-07, 2.2232532501220703e-04,
	7.4315071105957031e-04}, /* L1949 */
{8.5631618499755859e+00, 4.8037990927696228e-04,
	1.1920928955078125e-07, -2.7400255203247070e-04,
	-2.9486417770385742e-04}, /* L1950 */
{8.8643732070922852e+00, 4.9737095832824707e-04,
	1.1920928955078125e-07, -1.7321109771728516e-04,
	-2.3066997528076172e-05}, /* L1951 */
{9.5164451599121094e+00, 5.3486227989196777e-04,
	1.1920928955078125e-07, 4.4643878936767578e-04,
	9.8109245300292969e-05}, /* L1952 */
{1.0712300300598145e+01, 6.0426443815231323e-04,
	1.1920928955078125e-07, -4.5710802078247070e-04,
	-7.0732831954956055e-04}, /* L1953 */
{9.5847721099853516e+00, 5.3951144218444824e-04,
	1.1920928955078125e-07, 3.0636787414550781e-05,
	-4.6730041503906250e-05}, /* L1954 */
{7.9309968948364258e+00, 4.4685602188110352e-04,
	1.1920928955078125e-07, 7.5221061706542969e-05,
	1.0347366333007812e-04}, /* L1955 */
{6.8448896408081055e+00, 3.8608908653259277e-04,
	1.1920928955078125e-07, -7.3850154876708984e-05,
	8.9406967163085938e-06}, /* L1956 */
{8.9013347625732422e+00, 5.0285458564758301e-04,
	1.1920928955078125e-07, 3.8087368011474609e-04,
	3.0231475830078125e-04}, /* L1957 */
{8.0350475311279297e+00, 4.5436620712280273e-04,
	1.1920928955078125e-07, -1.4233589172363281e-04,
	-1.1080503463745117e-04}, /* L1958 */
{1.0773261070251465e+01, 6.0981512069702148e-04,
	1.1920928955078125e-07, -2.5522708892822266e-04,
	-1.3500452041625977e-04}, /* L1959 */
{1.1945131301879883e+01, 6.8248808383941650e-04,
	1.1920928955078125e-07, -4.3541193008422852e-03,
	6.8250894546508789e-03}, /* L1960 */
{9.7029876708984375e+00, 5.5011361837387085e-04,
	1.1920928955078125e-07, 8.7380409240722656e-05,
	-1.8835067749023438e-05}, /* L1961 */
{9.8058280944824219e+00, 5.5676698684692383e-04,
	1.1920928955078125e-07, -1.3411045074462891e-05,
	-1.2248754501342773e-04}, /* L1962 */
{1.3611980438232422e+01, 7.7419006265699863e-04,
	1.1920928955078125e-07, 3.5655498504638672e-04,
	-2.2375583648681641e-04}, /* L1963 */
{8.4177064895629883e+00, 4.7904253005981445e-04,
	1.1920928955078125e-07, 5.0544738769531250e-05,
	-2.1189451217651367e-04}, /* L1964 */
{1.0175786972045898e+01, 5.7952105998992920e-04,
	1.1920928955078125e-07, -1.3244152069091797e-04,
	3.6311149597167969e-04}, /* L1965 */
{8.3086719512939453e+00, 4.7411024570465088e-04,
	1.1920928955078125e-07, -6.0033798217773438e-04,
	2.2900104522705078e-04}, /* L1966 */
{8.6043062210083008e+00, 4.9097090959548950e-04,
	1.1920928955078125e-07, 8.3446502685546875e-07,
	-1.5795230865478516e-05}, /* L1967 */
{1.0641353607177734e+01, 6.0817599296569824e-04,
	1.1920928955078125e-07, 5.7101249694824219e-05,
	-3.8707256317138672e-04}, /* L1968 */
{1.0268855094909668e+01, 5.8725476264953613e-04,
	1.1920928955078125e-07, -2.1457672119140625e-06,
	2.7763843536376953e-04}, /* L1969 */
{1.2710402488708496e+01, 7.2799623012542725e-04,
	1.1920928955078125e-07, 2.2530555725097656e-05,
	-5.0431489944458008e-04}, /* L1970 */
{1.1090595245361328e+01, 6.3568353652954102e-04,
	1.1920928955078125e-07, 5.5551528930664062e-05,
	4.3034553527832031e-05}, /* L1971 */
{1.1624182701110840e+01, 6.6687166690826416e-04,
	1.1920928955078125e-07, 1.5711784362792969e-04,
	2.2065639495849609e-04}, /* L1972 */
{1.0314638137817383e+01, 5.9263408184051514e-04,
	1.1920928955078125e-07, 2.4759769439697266e-04,
	4.5609474182128906e-04}, /* L1973 */
{1.0397470474243164e+01, 5.9762597084045410e-04,
	1.1920928955078125e-07, 2.0384788513183594e-05,
	1.8596649169921875e-05}, /* L1974 */
{7.9526839256286621e+00, 4.5779347419738770e-04,
	1.1920928955078125e-07, 1.0085105895996094e-04,
	-7.6770782470703125e-05}, /* L1975 */
{8.9509191513061523e+00, 5.1692128181457520e-04,
	1.1920928955078125e-07, 3.5035610198974609e-04,
	1.5652179718017578e-04}, /* L1976 */
{9.6313333511352539e+00, 5.5524706840515137e-04,
	1.1920928955078125e-07, -5.7697296142578125e-05,
	-6.1631202697753906e-05}, /* L1977 */
{1.0058417320251465e+01, 5.8156251907348633e-04,
	1.1920928955078125e-07, 3.1507015228271484e-04,
	-2.2852420806884766e-04}, /* L1978 */
{1.0616869926452637e+01, 6.1337649822235107e-04,
	1.1920928955078125e-07, 1.8596649169921875e-05,
	-9.7274780273437500e-05}, /* L1979 */
{9.6551551818847656e+00, 5.5843591690063477e-04,
	1.1920928955078125e-07, -7.4684619903564453e-05,
	5.7458877563476562e-05}, /* L1980 */
{9.6228322982788086e+00, 5.5742263793945312e-04,
	1.1920928955078125e-07, -1.2600421905517578e-04,
	2.7525424957275391e-04}, /* L1981 */
{1.0596381187438965e+01, 6.1428546905517578e-04,
	1.1920928955078125e-07, -4.6432018280029297e-05,
	1.3089179992675781e-04}, /* L1982 */
{1.2365359306335449e+01, 7.1737170219421387e-04,
	1.1920928955078125e-07, 1.7440319061279297e-04,
	-2.4855136871337891e-05}, /* L1983 */
{9.0907354354858398e+00, 5.2788853645324707e-04,
	1.1920928955078125e-07, 9.0479850769042969e-05,
	-1.0967254638671875e-05}, /* L1984 */
{9.0471115112304688e+00, 5.2592158317565918e-04,
	1.1920928955078125e-07, 8.5949897766113281e-05,
	1.7762184143066406e-05}, /* L1985 */
{1.0919524192810059e+01, 6.3553452491760254e-04,
	1.1920928955078125e-07, 5.7220458984375000e-05,
	1.1074542999267578e-04}, /* L1986 */
{9.3615312576293945e+00, 5.4559111595153809e-04,
	1.1920928955078125e-07, -1.4656782150268555e-04,
	2.0146369934082031e-04}, /* L1987 */
{9.8919372558593750e+00, 5.7685188949108124e-04,
	1.1920928955078125e-07, 1.1503696441650391e-04,
	-6.2584877014160156e-06}, /* L1988 */
{9.1773252487182617e+00, 5.3569674491882324e-04,
	1.1920928955078125e-07, -4.5537948608398438e-05,
	2.2327899932861328e-04}, /* L1989 */
{1.0185897827148438e+01, 5.9595331549644470e-04,
	1.1920928955078125e-07, -6.0927867889404297e-04,
	6.8533420562744141e-04}, /* L1990 */
{8.6529941558837891e+00, 5.0607323646545410e-04,
	1.1920928955078125e-07, -5.1140785217285156e-05,
	1.9717216491699219e-04}, /* L1991 */
{9.2955474853515625e+00, 5.4464489221572876e-04,
	1.1920928955078125e-07, 3.8146972656250000e-06,
	-1.4382600784301758e-04}, /* L1992 */
{9.4217214584350586e+00, 5.5211782455444336e-04,
	1.1920928955078125e-07, -6.5863132476806641e-05,
	-4.2617321014404297e-05}, /* L1993 */
{9.1833600997924805e+00, 5.3887069225311279e-04,
	1.1920928955078125e-07, -5.1856040954589844e-06,
	-6.4492225646972656e-05}, /* L1994 */
{1.0723596572875977e+01, 6.3091516494750977e-04,
	1.1920928955078125e-07, -9.6172094345092773e-04,
	1.8572807312011719e-04}, /* L1995 */
{1.4520234107971191e+01, 8.5377693176269531e-04,
	1.1920928955078125e-07, 1.4865398406982422e-04,
	7.2598457336425781e-05}, /* L1996 */
{8.6223506927490234e+00, 5.0773471593856812e-04,
	1.1920928955078125e-07, 2.6702880859375000e-05,
	-3.0374526977539062e-04}, /* L1997 */
{1.2070078849792480e+01, 7.1102380752563477e-04,
	1.1920928955078125e-07, -1.4424324035644531e-05,
	-6.3002109527587891e-05}, /* L1998 */
{1.1777620315551758e+01, 6.9475173950195312e-04,
	1.1920928955078125e-07, 7.6770782470703125e-05,
	-1.4966726303100586e-04}, /* L1999 */
{1.2227584838867188e+01, 7.2187930345535278e-04,
	1.1920928955078125e-07, 3.4451484680175781e-05,
	3.6478042602539062e-05}, /* L2000 */
{8.8412332534790039e+00, 5.2274763584136963e-04,
	1.1920928955078125e-07, -1.4603137969970703e-04,
	-7.0863962173461914e-04}, /* L2001 */
{1.3288765907287598e+01, 7.8594684600830078e-04,
	1.1920928955078125e-07, 1.0967254638671875e-05,
	8.1181526184082031e-05}, /* L2002 */
{1.4326131820678711e+01, 8.4811449050903320e-04,
	1.1920928955078125e-07, -5.1081180572509766e-05,
	1.9431114196777344e-05}, /* L2003 */
{1.0843397140502930e+01, 6.4434111118316650e-04,
	1.1920928955078125e-07, 9.0384483337402344e-04,
	-4.3058395385742188e-04}, /* L2004 */
{1.0322278022766113e+01, 6.1281025409698486e-04,
	1.1920928955078125e-07, -2.3847818374633789e-04,
	-3.7145614624023438e-04}, /* L2005 */
{1.0549732208251953e+01, 6.2641501426696777e-04,
	1.1920928955078125e-07, 1.6689300537109375e-05,
	-2.9683113098144531e-05}, /* L2006 */
{1.1172326087951660e+01, 6.6402554512023926e-04,
	1.1920928955078125e-07, 4.5418739318847656e-05,
	3.2782554626464844e-05}, /* L2007 */
{1.0778042793273926e+01, 6.4164400100708008e-04,
	1.1920928955078125e-07, -6.8366527557373047e-05,
	1.2004375457763672e-04}, /* L2008 */
{1.1256361007690430e+01, 6.7144632339477539e-04,
	1.1920928955078125e-07, -2.4515390396118164e-04,
	-1.3053417205810547e-05}, /* L2009 */
{8.3230304718017578e+00, 4.9619842320680618e-04,
	1.1920928955078125e-07, -2.8491020202636719e-05,
	-4.0531158447265625e-05}, /* L2010 */
{1.9389345169067383e+01, 2.3628771305084229e-03,
	1.1920928955078125e-07, -8.1286430358886719e-03,
	3.5625696182250977e-03}, /* L2011 */
{2.2398042678833008e+01, 4.0780454874038696e-03,
	1.1920928955078125e-07, -4.2932629585266113e-03,
	7.0285797119140625e-04}, /* L2012 */
{3.7127368927001953e+01, 8.9380443096160889e-03,
	1.1920928955078125e-07, -4.1711330413818359e-04,
	1.5066862106323242e-03}, /* L2013 */
{4.4158779144287109e+01, 1.3220252469182014e-02,
	1.1920928955078125e-07, -1.3178586959838867e-04,
	5.6421756744384766e-04}, /* L2014 */
{5.0687767028808594e+01, 1.8235534429550171e-02,
	1.1920928955078125e-07, 2.0543336868286133e-03,
	1.3195276260375977e-03}, /* L2015 */
{6.0456470489501953e+01, 2.5663286447525024e-02,
	1.1920928955078125e-07, 2.4507045745849609e-03,
	-4.9054622650146484e-05}, /* L2016 */
{6.7426277160644531e+01, 3.2831013202667236e-02,
	1.1920928955078125e-07, -7.8994035720825195e-04,
	-4.4494867324829102e-03}, /* L2017 */
{7.1163208007812500e+01, 4.6596020460128784e-02,
	1.1920928955078125e-07, -6.0402154922485352e-03,
	4.1137099266052246e-02}, /* L2018 */
{9.2498748779296875e+01, 5.6218922138214111e-02,
	1.1920928955078125e-07, -5.7453513145446777e-03,
	3.6135911941528320e-03}, /* L2019 */
#endif	/* } */

/* Always the last one. Common to both DP and SP */

{0.0000000000000000e+00, 0.0000000000000000e+00,
	0.0000000000000000e+00, 0.0000000000000000e+00,
	0.0000000000000000e+00}, /* L2020 */
};

#endif	/* LAPACK_V9B_SS13 */
