/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*	Copyright (c) 1984, 1986, 1987, 1988, 1989 AT&T	*/
/*	  All Rights Reserved  	*/


#ident	"%Z%%M%	%I%	%E% SMI"       /* SVr4.0 1.7*/


# include <stdio.h>
# include <sac.h>
# include <sys/types.h>
# include "misc.h"
# include "structs.h"

/*
 * possible error messages that can be generated by the sac
 */

struct errmsg Msgs[] = {
	"could not open _sactab", 1,		/* E_SACOPEN */
	"malloc failed", 2,			/* E_MALLOC */
	"_sactab file is corrupt", 3,		/* E_BADFILE */
	"_sactab version # is incorrect", 4,	/* E_BADVER */
	"can not chdir to home directory", 5,	/* E_CHDIR */
	"could not open _sacpipe", 6,		/* E_NOPIPE */
	"internal error - bad state", 7,	/* E_BADSTATE */
	"read of _sacpipe failed", 8,		/* E_BADREAD */
	"fattach failed", 9,		 	/* E_FATTACH */
	"I_SETSIG failed", 10,		 	/* E_SETSIG */
	"read failed", 11,			/* E_READ */
	"poll failed", 12,			/* E_POLL */
	"system error in _sysconfig", 13,	/* E_SYSCONF */
	"error interpreting _sysconfig", 14,	/* E_BADSYSCONF */
	"pipe failed", 15,			/* E_PIPE */
	"could not create _cmdpipe", 16,	/* E_CMDPIPE */
};

int	N_msgs = sizeof(Msgs) / sizeof(struct errmsg);	/* number of valid messages */
int	Stime;			/* sanity timer interval */
struct	sactab	*Sactab;	/* linked list head of PM info */
char	Scratch[SIZE];		/* general scratch buffer */
int	Sfd;			/* _sacpipe file descriptor */
int	Cfd;			/* command pipe file descriptor */
int	Nentries;		/* # of entries in internal version of _sactab */
