/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * Copyright(c)	1983,	1989
 *    The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 * 	This product includes software developed by the University of
 * 	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 *      from nameser.h	8.1 (Berkeley) 6/2/93
 *	$Id: nameser_compat.h,v 8.15 2002/07/17 07:01:02 marka Exp $
 */

#ifndef _ARPA_NAMESER_COMPAT_H
#define	_ARPA_NAMESER_COMPAT_H

#pragma ident	"%Z%%M%	%I%	%E% SMI"

#ifdef	__cplusplus
extern "C" {
#endif

#define	__BIND		19950621	/* (DEAD) interface version stamp. */

#ifndef BYTE_ORDER
#if (BSD >= 199103)
#include <machine/endian.h>
#else
#ifdef linux
#include <endian.h>
#else
#define	LITTLE_ENDIAN	1234	/* least-significant byte first (vax, pc) */
#define	BIG_ENDIAN	4321	/* most-significant byte first (IBM, net) */
#define	PDP_ENDIAN	3412	/* LSB first in word, MSW first in long (pdp) */

#if defined(vax) || defined(ns32000) || defined(sun386) || defined(i386) || \
	defined(__i386) || defined(__amd64) || \
	defined(MIPSEL) || defined(_MIPSEL) || defined(BIT_ZERO_ON_RIGHT) || \
	defined(__alpha__) || defined(__alpha) || \
	(defined(__Lynx__) && defined(__x86__))
#define	BYTE_ORDER	LITTLE_ENDIAN
#endif

#if defined(sel) || defined(pyr) || defined(mc68000) || defined(sparc) || \
    defined(__sparc) || \
    defined(is68k) || defined(tahoe) || defined(ibm032) || defined(ibm370) || \
    defined(MIPSEB) || defined(_MIPSEB) || defined(_IBMR2) || defined(DGUX) ||\
    defined(apollo) || defined(__convex__) || defined(_CRAY) || \
    defined(__hppa) || defined(__hp9000) || \
    defined(__hp9000s300) || defined(__hp9000s700) || \
    defined(__hp3000s900) || defined(MPE) || \
    defined(BIT_ZERO_ON_LEFT) || defined(m68k) || \
	(defined(__Lynx__) && \
	(defined(__68k__) || defined(__sparc__) || defined(__powerpc__)))
#define	BYTE_ORDER	BIG_ENDIAN
#endif
#endif /* linux */
#endif /* BSD */
#endif /* BYTE_ORDER */

#if !defined(BYTE_ORDER) || \
	(BYTE_ORDER != BIG_ENDIAN && BYTE_ORDER != LITTLE_ENDIAN && \
    BYTE_ORDER != PDP_ENDIAN)
	/*
	 * you must determine what the correct bit order is for
	 * your compiler - the next line is an intentional error
	 * which will force your compiles to bomb until you fix
	 * the above macros.
	 */
	error "Undefined or invalid BYTE_ORDER";
#endif

/*
 * Structure for query header.  The order of the fields is machine- and
 * compiler-dependent, depending on the byte/bit order and the layout
 * of bit fields.  We use bit fields only in int variables, as this
 * is all ANSI requires.  This requires a somewhat confusing rearrangement.
 */

typedef struct {
	unsigned	id :16;		/* query identification number */
#if BYTE_ORDER == BIG_ENDIAN
			/* fields in third byte */
	unsigned	qr: 1;		/* response flag */
	unsigned	opcode: 4;	/* purpose of message */
	unsigned	aa: 1;		/* authoritive answer */
	unsigned	tc: 1;		/* truncated message */
	unsigned	rd: 1;		/* recursion desired */
			/* fields in fourth byte */
	unsigned	ra: 1;		/* recursion available */
	unsigned	unused :1;	/* unused bits (MBZ as of 4.9.3a3) */
	unsigned	ad: 1;		/* authentic data from named */
	unsigned	cd: 1;		/* checking disabled by resolver */
	unsigned	rcode :4;	/* response code */
#endif
#if BYTE_ORDER == LITTLE_ENDIAN || BYTE_ORDER == PDP_ENDIAN
			/* fields in third byte */
	unsigned	rd :1;		/* recursion desired */
	unsigned	tc :1;		/* truncated message */
	unsigned	aa :1;		/* authoritive answer */
	unsigned	opcode :4;	/* purpose of message */
	unsigned	qr :1;		/* response flag */
			/* fields in fourth byte */
	unsigned	rcode :4;	/* response code */
	unsigned	cd: 1;		/* checking disabled by resolver */
	unsigned	ad: 1;		/* authentic data from named */
	unsigned	unused :1;	/* unused bits (MBZ as of 4.9.3a3) */
	unsigned	ra :1;		/* recursion available */
#endif
			/* remaining bytes */
	unsigned	qdcount :16;	/* number of question entries */
	unsigned	ancount :16;	/* number of answer entries */
	unsigned	nscount :16;	/* number of authority entries */
	unsigned	arcount :16;	/* number of resource entries */
} HEADER;

#define	PACKETSZ	NS_PACKETSZ
#define	MAXDNAME	NS_MAXDNAME
#define	MAXCDNAME	NS_MAXCDNAME
#define	MAXLABEL	NS_MAXLABEL
#define	HFIXEDSZ	NS_HFIXEDSZ
#define	QFIXEDSZ	NS_QFIXEDSZ
#define	RRFIXEDSZ	NS_RRFIXEDSZ
#define	INT32SZ		NS_INT32SZ
#define	INT16SZ		NS_INT16SZ
#define	INT8SZ		NS_INT8SZ
#define	INADDRSZ	NS_INADDRSZ
#define	IN6ADDRSZ	NS_IN6ADDRSZ
#define	INDIR_MASK	NS_CMPRSFLGS
#define	NAMESERVER_PORT	NS_DEFAULTPORT

#define	S_ZONE		ns_s_zn
#define	S_PREREQ	ns_s_pr
#define	S_UPDATE	ns_s_ud
#define	S_ADDT		ns_s_ar

#define	QUERY		ns_o_query
#define	IQUERY		ns_o_iquery
#define	STATUS		ns_o_status
#define	NS_NOTIFY_OP	ns_o_notify
#define	NS_UPDATE_OP	ns_o_update

#define	NOERROR		ns_r_noerror
#define	FORMERR		ns_r_formerr
#define	SERVFAIL	ns_r_servfail
#define	NXDOMAIN	ns_r_nxdomain
#define	NOTIMP		ns_r_notimpl
#define	REFUSED		ns_r_refused
#define	YXDOMAIN	ns_r_yxdomain
#define	YXRRSET		ns_r_yxrrset
#define	NXRRSET		ns_r_nxrrset
#define	NOTAUTH		ns_r_notauth
#define	NOTZONE		ns_r_notzone
/* #define	BADSIG		ns_r_badsig */
/* #define	BADKEY		ns_r_badkey */
/* #define	BADTIME		ns_r_badtime */

#define	DELETE		ns_uop_delete
#ifndef	ADD
#define	ADD		ns_uop_add
#endif

#define	T_A		ns_t_a
#define	T_NS		ns_t_ns
#define	T_MD		ns_t_md
#define	T_MF		ns_t_mf
#define	T_CNAME		ns_t_cname
#define	T_SOA		ns_t_soa
#define	T_MB		ns_t_mb
#define	T_MG		ns_t_mg
#define	T_MR		ns_t_mr
#define	T_NULL		ns_t_null
#define	T_WKS		ns_t_wks
#define	T_PTR		ns_t_ptr
#define	T_HINFO		ns_t_hinfo
#define	T_MINFO		ns_t_minfo
#define	T_MX		ns_t_mx
#define	T_TXT		ns_t_txt
#define	T_RP		ns_t_rp
#define	T_AFSDB		ns_t_afsdb
#define	T_X25		ns_t_x25
#define	T_ISDN		ns_t_isdn
#define	T_RT		ns_t_rt
#define	T_NSAP		ns_t_nsap
#define	T_NSAP_PTR	ns_t_nsap_ptr
#define	T_SIG		ns_t_sig
#define	T_KEY		ns_t_key
#define	T_PX		ns_t_px
#define	T_GPOS		ns_t_gpos
#define	T_AAAA		ns_t_aaaa
#define	T_LOC		ns_t_loc
#define	T_NXT		ns_t_nxt
#define	T_EID		ns_t_eid
#define	T_NIMLOC	ns_t_nimloc
#define	T_SRV		ns_t_srv
#define	T_ATMA		ns_t_atma
#define	T_NAPTR		ns_t_naptr
#define	T_A6		ns_t_a6
#define	T_TSIG		ns_t_tsig
#define	T_IXFR		ns_t_ixfr
#define	T_AXFR		ns_t_axfr
#define	T_MAILB		ns_t_mailb
#define	T_MAILA		ns_t_maila
#define	T_ANY		ns_t_any

#define	C_IN		ns_c_in
#define	C_CHAOS		ns_c_chaos
#define	C_HS		ns_c_hs
/* BIND_UPDATE */
#define	C_NONE		ns_c_none
#define	C_ANY		ns_c_any

#define	GETSHORT		NS_GET16
#define	GETLONG			NS_GET32
#define	PUTSHORT		NS_PUT16
#define	PUTLONG			NS_PUT32

#ifdef	__cplusplus
}
#endif

#endif	/* _ARPA_NAMESER_COMPAT_H */
