/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * RPC Language Protocol description file for NIS Plus
 *
 * Copyright 2009 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 *
 *
 * From 4.1 : @(#)nis.x	1.61 Copyright 1989 Sun Microsystems
 */

/* This gets stuffed into the source files. */
#if RPC_HDR
%#include <rpc/xdr.h>
#endif
#if defined(RPC_XDR) || defined(RPC_CLNT) || defined(RPC_SVC)
%#ifndef xdr_uint32_t
%#define xdr_uint32_t	xdr_u_int
%#endif
%#ifndef xdr_uint_t
%#define xdr_uint_t	xdr_u_int
%#endif
#endif
#if RPC_SVC
%#include "nis_svc.h"
#endif

/* Include the RPC Language description of NIS objects */
#include "nis_object.x"




/* 
 * These are the type of entries that are stored in the transaction log, 
 * note that modifications will appear as two entries, for names, they have
 * a "OLD" entry followed by a "NEW" entry. For entries in tables, there
 * is a remove followed by an add. It is done this way so that we can read
 * the log backwards to back out transactions and forwards to propogate
 * updated.
 */
enum log_entry_t {
	LOG_NOP = 0,
	ADD_NAME = 1,		/* Name Added to name space 		  */
	REM_NAME = 2,		/* Name removed from name space 	  */
	MOD_NAME_OLD = 3,	/* Name was modified in the name space 	  */
	MOD_NAME_NEW = 4,	/* Name was modified in the name space 	  */
	ADD_IBASE = 5,		/* Entry added to information base 	  */
	REM_IBASE = 6,		/* Entry removed from information base    */
	MOD_IBASE = 7,		/* Entry was modified in information base */
	UPD_STAMP = 8		/* Update timestamp (used as fenceposts)  */
};
	
/*
 * This result is returned from the name service when it is requested to 
 * dump logged entries from its transaction log. Information base updates
 * will have the name of the information base in the le_name field and
 * a canonical set of attribute/value pairs to fully specify the entry's
 * 'name'. 
 */
struct log_entry {
	uint32_t	le_time;	/* Time in seconds 		*/
	log_entry_t	le_type;	/* Type of log entry 		*/
	nis_name	le_princp;	/* Principal making the change	*/
	nis_name	le_name;	/* Name of table/dir involved 	*/
	nis_attr	le_attrs<>;	/* List of AV pairs.		*/
	nis_object	le_object;	/* Actual object value 		*/
};


/*
 * This structure defines a generic NIS tag list. The taglist contains
 * zero or tags, each of which is a type and a value. (u_int). 
 * These are used to report statistics (see tag definitions below)
 * and to set or reset state variables.
 */
struct nis_tag {
	u_int	tag_type;	/* Statistic tag (may vary) 	 */
	string	tag_val<>;	/* Statistic value may also vary */
};


%/*
% * Structures used for server binding.
% */
struct nis_bound_endpoint {
	endpoint ep;
	int generation;
	int rank;
	u_int flags;
	int hostnum;
	int epnum;
	nis_name uaddr;
	endpoint cbep;
};
typedef struct nis_bound_endpoint nis_bound_endpoint;
 
struct nis_bound_directory {
	int generation;
	int min_rank;           /* minimum rank of bound endpoints */
	int optimal_rank;       /* best possible rank of all endpoints */
	directory_obj dobj;
	nis_bound_endpoint BEP<>;
};
typedef struct nis_bound_directory nis_bound_directory;
%#define bep_len BEP.BEP_len
%#define bep_val BEP.BEP_val
 
struct nis_active_endpoint {
	endpoint ep;
	nis_name hostname;
	int rank;
	int uaddr_generation;
	nis_name uaddr;
	int cbep_generation;
	endpoint cbep;
};
typedef struct nis_active_endpoint nis_active_endpoint;
 
%/* defines for nis_bound_endpoint.flags */
%#define NIS_BOUND 0x1
%#define NIS_TRANSIENT_ERRORS 0x2



/* 
 * What's going on here? Well, it's like this. When the service
 * is being compiled it wants to have the service definition specific
 * info included, and when the client is being compiled it wants that
 * info. This includes the appropriate file which was generated by
 * make in the protocols directory (probably /usr/include/rpcsvc). 
 */
#ifdef RPC_SVC
%#include "nis_svc.h"
#endif
#ifdef RPC_CLNT
%#include "nis_clnt.h"
#endif


/*
 * Included below are the defines that become part of nis.h,
 * they are technically not part of the protocol, but do define
 * key aspects of the implementation and are therefore useful
 * in building a conforming server or client.
 */
#if RPC_HDR
%/*
% * Generic "hash" datastructures, used by all types of hashed data.
% */
%struct nis_hash_data {
%	nis_name		name;	   /* NIS name of hashed item      */
%	int			keychain;  /* It's hash key (for pop)      */
%	struct nis_hash_data	*next;	   /* Hash collision pointer       */
%	struct nis_hash_data	*prv_item; /* A serial, doubly linked list */
%	struct nis_hash_data	*nxt_item; /* of items in the hash table   */
%};
%typedef struct nis_hash_data NIS_HASH_ITEM;
%
%struct nis_hash_table {
%	NIS_HASH_ITEM	*keys[64];	/* A hash table of items           */
%	NIS_HASH_ITEM	*first;		/* The first "item" in serial list */
%};
%typedef struct nis_hash_table NIS_HASH_TABLE;
%
%/* Structure for storing dynamically allocated static data */
%struct nis_sdata {
%	void	*buf;	/* Memory allocation pointer 	*/
%	u_int	size;	/* Buffer size			*/
%};
%
%/* Generic client creating flags */
%#define ZMH_VC		1
%#define ZMH_DG		2
%#define ZMH_AUTH	4
%#define ZMH_NOFALLBACK 8
%
%/* Testing Access rights for objects */
%
%#define NIS_READ_ACC		1
%#define NIS_MODIFY_ACC		2
%#define NIS_CREATE_ACC		4
%#define NIS_DESTROY_ACC	8
%/* Test macros. a == access rights, m == desired rights. */
%#define NIS_WORLD(a, m)	(((a) & (m)) != 0)
%#define NIS_GROUP(a, m)	(((a) & ((m) << 8)) != 0)
%#define NIS_OWNER(a, m)	(((a) & ((m) << 16)) != 0)
%#define NIS_NOBODY(a, m)	(((a) & ((m) << 24)) != 0)
%/* 
% * EOL Alert - The following non-prefixed test macros are 
% * here for backward compatability, and will be not be present
% * in future releases - use the NIS_*() macros above.
% */
%#define WORLD(a, m)	(((a) & (m)) != 0)
%#define GROUP(a, m)	(((a) & ((m) << 8)) != 0)
%#define OWNER(a, m)	(((a) & ((m) << 16)) != 0)
%#define NOBODY(a, m)	(((a) & ((m) << 24)) != 0)
%
%#define OATYPE(d, n) (((d)->do_armask.do_armask_val+n)->oa_otype)
%#define OARIGHTS(d, n) (((d)->do_armask.do_armask_val+n)->oa_rights)
%#define WORLD_DEFAULT (NIS_READ_ACC)
%#define GROUP_DEFAULT (NIS_READ_ACC << 8)
%#define OWNER_DEFAULT ((NIS_READ_ACC +\
%			 NIS_MODIFY_ACC +\
%			 NIS_CREATE_ACC +\
%			 NIS_DESTROY_ACC) << 16)
%#define DEFAULT_RIGHTS (WORLD_DEFAULT | GROUP_DEFAULT | OWNER_DEFAULT)
%
%/* Result manipulation defines ... */
%#define NIS_RES_NUMOBJ(x)	((x)->objects.objects_len)
%#define NIS_RES_OBJECT(x)	((x)->objects.objects_val)
%#define NIS_RES_COOKIE(x)	((x)->cookie)
%#define NIS_RES_STATUS(x)	((x)->status)
%
%/* These defines make getting at the variant part of the object easier. */
%#define TA_data zo_data.objdata_u.ta_data
%#define EN_data zo_data.objdata_u.en_data
%#define DI_data zo_data.objdata_u.di_data
%#define LI_data zo_data.objdata_u.li_data
%#define GR_data zo_data.objdata_u.gr_data
%
%#define __type_of(o) ((o)->zo_data.zo_type)
%
%/* Declarations for the internal subroutines in nislib.c */
%enum name_pos {SAME_NAME, HIGHER_NAME, LOWER_NAME, NOT_SEQUENTIAL, BAD_NAME};
%typedef enum name_pos name_pos;
%
%/*
% * Defines for getting at column data in entry objects. Because RPCGEN
% * generates some rather wordy structures, we create some defines that
% * collapse the needed keystrokes to access a particular value using
% * these definitions they take an nis_object *, and an int and return
% * a u_char * for Value, and an int for length.
% */
%#define ENTRY_VAL(obj, col) \
%	(obj)->EN_data.en_cols.en_cols_val[col].ec_value.ec_value_val
%#define ENTRY_LEN(obj, col) \
%	(obj)->EN_data.en_cols.en_cols_val[col].ec_value.ec_value_len
%
%
%
%#ifdef __cplusplus
%}
%#endif
%
%/* Prototypes, and extern declarations for the NIS library functions. */
%#include <rpcsvc/nislib.h>
%#endif /* __NIS_RPCGEN_H */
%/* EDIT_START */
%
%/*
% * nis_3.h
% * 
% * This file contains definitions that are only of interest to the actual
% * service daemon and client stubs. Normal users of NIS will not include
% * this file.
% *
% * NOTE : This include file is automatically created by a combination 
% * of rpcgen and sed. DO NOT EDIT IT, change the nis.x file instead
% * and then remake this file.
% */
%#ifndef __nis_3_h
%#define __nis_3_h
%#ifdef __cplusplus
%extern "C" {
%#endif
#endif
