/***********************************************************************
*                                                                      *
*               This software is part of the ast package               *
*          Copyright (c) 1985-2009 AT&T Intellectual Property          *
*                      and is licensed under the                       *
*                  Common Public License, Version 1.0                  *
*                    by AT&T Intellectual Property                     *
*                                                                      *
*                A copy of the License is available at                 *
*            http://www.opensource.org/licenses/cpl1.0.txt             *
*         (with md5 checksum 059e8cd6165cb4c31e351f2b69388fd9)         *
*                                                                      *
*              Information and Software Systems Research               *
*                            AT&T Research                             *
*                           Florham Park NJ                            *
*                                                                      *
*                 Glenn Fowler <gsf@research.att.com>                  *
*                  David Korn <dgk@research.att.com>                   *
*                   Phong Vo <kpv@research.att.com>                    *
*                                                                      *
***********************************************************************/

/* : : generated by proto : : */
/* : : generated by ./lcgen : : */
                  

#ifndef _LC_H
#if !defined(__PROTO__)
#include <prototyped.h>
#endif
#if !defined(__LINKAGE__)
#define __LINKAGE__		/* 2004-08-11 transition */
#endif

#define _LC_H			1

#include <ast.h>

#define LC_abbreviated		0x00001
#define LC_checked		0x00002
#define LC_debug		0x00004
#define LC_default		0x00008
#define LC_defined		0x00010
#define LC_local		0x00020
#define LC_primary		0x00040
#define LC_qualified		0x00080
#define LC_undefined		0x00100
#define LC_utf8			0x00200
#define LC_verbose		0x00400
#define LC_user			0x10000
#define LC_language_attribute_max		2
#define LC_territory_language_max		4

struct Lc_s;

typedef struct Lc_info_s
{
	const struct Lc_s*	lc;
	unsigned long		number;
	__V_*			data;
} Lc_info_t;

typedef struct Lc_attribute_s
{
	const char*		name;
	unsigned long		flags;
	unsigned long		index;
} Lc_attribute_t;

typedef struct Lc_charset_s
{
	const char*		code;
	const char*		alternates;
	const char*		ms;
	unsigned long		index;
} Lc_charset_t;

typedef struct Lc_language_s
{
	const char*		code;
	const char*		name;
	const char*		alternates;
	const Lc_charset_t*	charset;
	unsigned long		flags;
	unsigned long		index;
	const Lc_attribute_t*	attributes[LC_language_attribute_max];
} Lc_language_t;

typedef struct Lc_territory_s
{
	const char*		code;
	const char*		name;
	unsigned long		flags;
	unsigned long		index;
	const Lc_language_t*	languages[LC_territory_language_max];
#ifdef _LC_TERRITORY_PRIVATE_
	_LC_TERRITORY_PRIVATE_
#endif
} Lc_territory_t;

typedef struct Lc_map_s
{
	const char*		code;
	const Lc_language_t*	language;
	const Lc_territory_t*	territory;
	const Lc_charset_t*	charset;
	const Lc_attribute_t*	attribute;
} Lc_map_t;

typedef struct Lc_attribute_list_s
{
	struct Lc_attribute_list_s*	next;
	const Lc_attribute_t*		attribute;
} Lc_attribute_list_t;

typedef struct Lc_s
{
	const char*		name;
	const char*		code;
	const Lc_language_t*	language;
	const Lc_territory_t*	territory;
	const Lc_charset_t*	charset;
	const Lc_attribute_list_t*	attributes;
	unsigned long		flags;
	unsigned long		index;
#ifdef _LC_PRIVATE_
	_LC_PRIVATE_
#endif
} Lc_t;

struct Lc_category_s;

typedef int (*Lc_category_set_f) __PROTO__((struct Lc_category_s*));

typedef struct Lc_category_s
{
	const char*		name;
	int			external;
	int			internal;
	Lc_category_set_f	setf;
	Lc_t*			prev;
} Lc_category_t;

#if _BLD_ast && defined(__EXPORT__)
#undef __MANGLE__
#define __MANGLE__ __LINKAGE__		__EXPORT__
#endif

extern __MANGLE__ size_t		lccanon __PROTO__((Lc_t*, unsigned long flags, char*, size_t));
extern __MANGLE__ Lc_category_t*	lccategories __PROTO__((void));
extern __MANGLE__ int		lcindex __PROTO__((int, int));
extern __MANGLE__ Lc_info_t*	lcinfo __PROTO__((int));
extern __MANGLE__ Lc_t*		lcmake __PROTO__((const char*));
extern __MANGLE__ Lc_t*		lcscan __PROTO__((Lc_t*));

#undef __MANGLE__
#define __MANGLE__ __LINKAGE__

#endif
