/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 *
 * ident	"%Z%%M%	%I%	%E% SMI"
 */
package org.opensolaris.os.dtrace;

import java.io.Serializable;
import java.beans.*;

/**
 * A numeric value generated by a D aggregating action such as {@code
 * count()} or {@code sum()}.
 * <p>
 * Immutable.
 *
 * @author Tom Erickson
 */
abstract class AbstractAggregationValue
        implements AggregationValue, Serializable
{
    static final long serialVersionUID = 2340811719178724026L;

    /** @serial */
    private final Number value;

    public
    AbstractAggregationValue(long v)
    {
	value = new Long(v);
    }

    public
    AbstractAggregationValue(double v)
    {
	value = new Double(v);
    }

    public Number
    getValue()
    {
	return value;
    }

    /**
     * Compares the specified object with this aggregation value for
     * equality.  Defines equality as having the same type and the same
     * numeric value.
     *
     * @return {@code true} if and only if the specified object is an
     * aggregation value of the same {@code Class} as this value, and
     * both values return equal numbers from {@link #getValue()}.
     */
    public boolean
    equals(Object o)
    {
	if (o instanceof AbstractAggregationValue) {
	    AbstractAggregationValue v = (AbstractAggregationValue)o;
	    return (value.equals(v.value) &&
		    (getClass() == v.getClass()));
	}
	return false;
    }

    /**
     * Overridden to ensure that equal instances have equal hash codes.
     */
    @Override
    public int
    hashCode()
    {
	return value.hashCode();
    }

    /**
     * Gets the string representation of {@link #getValue()}.
     *
     * @return the string representation of {@link #getValue()} returned
     * by {@link Object#toString()}
     */
    public String
    toString()
    {
	return value.toString();
    }
}
