/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2008 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"%Z%%M%	%I%	%E% SMI"

/*
 * FRUID Tag Registry
 * This file is AUTO-generated DO NOT EDIT
 *
 * Generated on Wed May 21 15:05:38 IST 2008 by dt207653.
 * From input file data.frureg
 *
 */


static const char *registry_version
	= "%Z%%M%  %I%  %E%  SMI";

fru_enum_t Vendor[] = {
	{ 0x0, "NO JEDEC CODE FOR THIS VENDOR" },
	{ 0x1, "AMD" },
	{ 0x2, "AMI" },
	{ 0x4, "Fujitsu" },
	{ 0x7, "Hitachi" },
	{ 0x8, "Inmos" },
	{ 0xb, "Intersil" },
	{ 0xd, "Mostek" },
	{ 0xe, "Freescale (formerly Motorola)" },
	{ 0x10, "NEC" },
	{ 0x13, "Conexant (Rockwell)" },
	{ 0x15, "Philips Semi. (Signetics)" },
	{ 0x16, "Synertek" },
	{ 0x19, "Xicor" },
	{ 0x1a, "Zilog" },
	{ 0x1c, "Mitsubishi" },
	{ 0x1f, "Atmel" },
	{ 0x20, "SGS/Thomson" },
	{ 0x23, "Wafer Scale Integration" },
	{ 0x25, "Tristar" },
	{ 0x26, "Visic" },
	{ 0x29, "MicrochipTechnology" },
	{ 0x2a, "Ricoh Ltd." },
	{ 0x2c, "Micron Technology" },
	{ 0x2f, "ACTEL" },
	{ 0x31, "Catalyst" },
	{ 0x32, "Panasonic" },
	{ 0x34, "Cypress" },
	{ 0x37, "Zarlink (formerly Plessey)" },
	{ 0x38, "UTMC" },
	{ 0x3b, "Integrated CMOS(Vertex)" },
	{ 0x3d, "Tektronix" },
	{ 0x3e, "Sun Microsystems" },
	{ 0x40, "ProMos/Mosel Vitelic" },
	{ 0x43, "Xerox" },
	{ 0x45, "SunDisk" },
	{ 0x46, "Elan Circuit Tech." },
	{ 0x4a, "Compaq" },
	{ 0x4c, "SCI" },
	{ 0x4f, "I3 Design System" },
	{ 0x51, "Crosspoint Solutions" },
	{ 0x52, "Alliance Semiconductor" },
	{ 0x54, "Hewlett-Packard" },
	{ 0x57, "New Media" },
	{ 0x58, "MHS Electronic" },
	{ 0x5b, "Kawasaki Steel" },
	{ 0x5d, "TECMAR" },
	{ 0x5e, "Exar" },
	{ 0x61, "Northern Telecom" },
	{ 0x62, "Sanyo" },
	{ 0x64, "Crystal Semiconductor" },
	{ 0x67, "Asparix" },
	{ 0x68, "Convex Computer" },
	{ 0x6b, "Transwitch" },
	{ 0x6d, "Cannon" },
	{ 0x6e, "Altera" },
	{ 0x70, "QUALCOMM" },
	{ 0x73, "AMS(Austria Micro)" },
	{ 0x75, "Aster Electronics" },
	{ 0x76, "Bay Networks(Synoptic)" },
	{ 0x79, "Thesys" },
	{ 0x7a, "Solbourne Computer" },
	{ 0x7c, "Dialog" },
	{ 0x83, "Fairchild" },
	{ 0x85, "GTE" },
	{ 0x86, "Harris" },
	{ 0x89, "Intel" },
	{ 0x8a, "I.T.T." },
	{ 0x8c, "Monolithic Memories" },
	{ 0x8f, "National" },
	{ 0x91, "RCA" },
	{ 0x92, "Raytheon" },
	{ 0x94, "Seeq" },
	{ 0x97, "Texas Instruments" },
	{ 0x98, "Toshiba" },
	{ 0x9b, "Eurotechnique" },
	{ 0x9d, "Lucent (AT&T)" },
	{ 0x9e, "Exel" },
	{ 0xa1, "Lattice Semi." },
	{ 0xa2, "NCR" },
	{ 0xa4, "IBM" },
	{ 0xa7, "Intl. CMOS Technology" },
	{ 0xa8, "SSSI" },
	{ 0xab, "VLSI" },
	{ 0xad, "Hyundai Electronics" },
	{ 0xae, "OKI Semiconductor" },
	{ 0xb0, "Sharp" },
	{ 0xb3, "IDT" },
	{ 0xb5, "DEC" },
	{ 0xb6, "LSI Logic" },
	{ 0xb9, "Thinking Machine" },
	{ 0xba, "Thomson CSF" },
	{ 0xbc, "Honeywell" },
	{ 0xbf, "SST" },
	{ 0xc1, "Infineon (formerly Siemens)" },
	{ 0xc2, "Macronix" },
	{ 0xc4, "Plus Logic" },
	{ 0xc7, "European Silicon Str." },
	{ 0xc8, "Apple Computer" },
	{ 0xc9, "Xilinx" },
	{ 0xcb, "Protocol Engines" },
	{ 0xcd, "Seiko Instruments" },
	{ 0xce, "Samsung" },
	{ 0xd0, "Klic" },
	{ 0xd3, "Tandem" },
	{ 0xd5, "Intg. Silicon Solutions" },
	{ 0xd6, "Brooktree" },
	{ 0xd9, "Performance Semi." },
	{ 0xda, "Winbond Electronic" },
	{ 0xdc, "Bright Micro" },
	{ 0xdf, "PCMCIA" },
	{ 0xe0, "LG Semi (formerly Goldstar)" },
	{ 0xe3, "Array Microsystems" },
	{ 0xe5, "Analog Devices" },
	{ 0xe6, "PMC-Sierra" },
	{ 0xe9, "Quality Semiconductor" },
	{ 0xea, "Nimbus Technology" },
	{ 0xec, "Micronas (ITT Intermetall)" },
	{ 0xef, "NEXCOM" },
	{ 0xf1, "Sony" },
	{ 0xf2, "Cray Research" },
	{ 0xf4, "Vitesse" },
	{ 0xf7, "Zentrum or ZMD" },
	{ 0xf8, "TRW" },
	{ 0xfb, "Allied-Signal" },
	{ 0xfd, "Media Vision" },
	{ 0xfe, "Level One Communication" },
	{ 0xff, "Seagate" },
	{ 0x101, "Cirrus Logic" },
	{ 0x102, "National Instruments" },
	{ 0x104, "Alcatel Mietec" },
	{ 0x107, "JTAG Technologies" },
	{ 0x108, "BAE Systems( formerly Loral)" },
	{ 0x10b, "Bestlink Systems" },
	{ 0x10d, "GENNUM" },
	{ 0x10e, "VideoLogic" },
	{ 0x110, "Chip Express" },
	{ 0x113, "TCSI" },
	{ 0x115, "Hughes Aircraft" },
	{ 0x116, "Lanstar Semiconductor" },
	{ 0x119, "Music Semi" },
	{ 0x11a, "Ericsson Components" },
	{ 0x11c, "Eon Silicon Devices" },
	{ 0x11f, "Integ. Memories Tech." },
	{ 0x120, "Corollary Inc." },
	{ 0x123, "EIV(Switzerland)" },
	{ 0x125, "Zarlink (formerly Mitel)" },
	{ 0x126, "Clearpoint" },
	{ 0x129, "Vanguard" },
	{ 0x12a, "Hagiwara Sys-Com" },
	{ 0x12c, "Celestica" },
	{ 0x12f, "Rohm Company Ltd." },
	{ 0x131, "Libit Signal Processing" },
	{ 0x132, "Mushkin Enhanced Memory" },
	{ 0x134, "Adaptec Inc." },
	{ 0x137, "AMIC Technology" },
	{ 0x138, "Adobe Systems" },
	{ 0x13b, "Newport Digital" },
	{ 0x13d, "T Square" },
	{ 0x13e, "Seiko Epson" },
	{ 0x140, "Viking Components" },
	{ 0x143, "Suwa Electronics" },
	{ 0x145, "Micron CMS" },
	{ 0x146, "American Computer & Digital Components Inc" },
	{ 0x149, "CPU Design" },
	{ 0x14a, "Price Point" },
	{ 0x14c, "Tellabs" },
	{ 0x14f, "Transcend Information" },
	{ 0x151, "CKD Corporation Ltd." },
	{ 0x152, "Capital Instruments, Inc." },
	{ 0x154, "Linvex Technology" },
	{ 0x157, "Dynamem, Inc." },
	{ 0x158, "NERA ASA" },
	{ 0x15b, "Acorn Computers" },
	{ 0x15d, "Oak Technology, Inc." },
	{ 0x15e, "Itec Memory" },
	{ 0x161, "Wintec Industries" },
	{ 0x162, "Super PC Memory" },
	{ 0x164, "Galvantech" },
	{ 0x167, "GateField" },
	{ 0x168, "Integrated Memory System" },
	{ 0x16b, "Goldenram" },
	{ 0x16d, "Cimaron Communications" },
	{ 0x16e, "Nippon Steel Semi. Corp." },
	{ 0x170, "AMCC" },
	{ 0x173, "Digital Microwave" },
	{ 0x175, "MIMOS Semiconductor" },
	{ 0x176, "Advanced Fibre" },
	{ 0x179, "Acbel Polytech Inc." },
	{ 0x17a, "Apacer Technology" },
	{ 0x17c, "FOXCONN" },
	{ 0x17d, "TBD" },
	{ 0x183, "ILC Data Device" },
	{ 0x185, "Micro Linear" },
	{ 0x186, "Univ. of NC" },
	{ 0x189, "Nchip" },
	{ 0x18a, "Galileo Tech" },
	{ 0x18c, "Graychip" },
	{ 0x18f, "Robert Bosch" },
	{ 0x191, "DATARAM" },
	{ 0x192, "United Microelec Corp." },
	{ 0x194, "Smart Modular" },
	{ 0x197, "Qlogic" },
	{ 0x198, "Kingston" },
	{ 0x19b, "SpaSE" },
	{ 0x19d, "Programmable Micro Corp" },
	{ 0x19e, "DoD" },
	{ 0x1a1, "Dallas Semiconductor" },
	{ 0x1a2, "Omnivision" },
	{ 0x1a4, "Novatel Wireless" },
	{ 0x1a7, "Cabletron" },
	{ 0x1a8, "Silicon Technology (Simple Technology)" },
	{ 0x1ab, "Vantis" },
	{ 0x1ad, "Century" },
	{ 0x1ae, "Hal Computers" },
	{ 0x1b0, "Juniper Networks" },
	{ 0x1b3, "Tundra Semiconductor" },
	{ 0x1b5, "LightSpeed Semi." },
	{ 0x1b6, "ZSP Corp." },
	{ 0x1b9, "Dynachip" },
	{ 0x1ba, "PNY Electronics" },
	{ 0x1bc, "MMC Networks" },
	{ 0x1bf, "Broadcom" },
	{ 0x1c1, "V3 Semiconductor" },
	{ 0x1c2, "Flextronics Semiconductor" },
	{ 0x1c4, "Transmeta" },
	{ 0x1c7, "Enhance 3000 Inc" },
	{ 0x1c8, "Tower Semiconductor" },
	{ 0x1cb, "Maxim Integrated Product" },
	{ 0x1cd, "Centaur Technology" },
	{ 0x1ce, "Unigen Corporation" },
	{ 0x1d0, "Memory Card Technology" },
	{ 0x1d3, "Aica Kogyo, Ltd." },
	{ 0x1d5, "MSC Vertriebs GmbH" },
	{ 0x1d6, "AKM Company, Ltd." },
	{ 0x1d9, "GSI Technology" },
	{ 0x1da, "Dane-Elec" },
	{ 0x1dc, "Lara Technology" },
	{ 0x1df, "Tanisys Technology" },
	{ 0x1e0, "Truevision" },
	{ 0x1e3, "MGV Memory" },
	{ 0x1e5, "Gadzoox Networks" },
	{ 0x1e6, "Multi Dimensional Cons." },
	{ 0x1e9, "Triscend" },
	{ 0x1ea, "XaQti" },
	{ 0x1ec, "Clear Logic" },
	{ 0x1ef, "Advantage Memory" },
	{ 0x1f1, "LeCroy" },
	{ 0x1f2, "Yamaha Corporation" },
	{ 0x1f4, "NetLogic Microsystems" },
	{ 0x1f7, "BF Goodrich Data." },
	{ 0x1f8, "Epigram" },
	{ 0x1fb, "Admor Memory" },
	{ 0x1fd, "Quadratics Superconductor" },
	{ 0x1fe, "3COM" },
	{ 0x201, "Camintonn Corporation" },
	{ 0x202, "ISOA Incorporated" },
	{ 0x204, "ADMtek Incorporated" },
	{ 0x207, "MOSAID Technologies" },
	{ 0x208, "Ardent Technologies" },
	{ 0x20b, "Allayer Technologies" },
	{ 0x20d, "Oasis Semiconductor" },
	{ 0x20e, "Novanet Semiconductor" },
	{ 0x210, "Power General" },
	{ 0x213, "Telocity" },
	{ 0x215, "Symagery Microsystems" },
	{ 0x216, "C-Port Corporation" },
	{ 0x219, "Malleable Technologies" },
	{ 0x21a, "Kendin Communications" },
	{ 0x21c, "Sanmina Corporation" },
	{ 0x21f, "Actrans System Inc." },
	{ 0x220, "ALPHA Technologies" },
	{ 0x223, "Align Manufacturing" },
	{ 0x225, "Chameleon Systems" },
	{ 0x226, "Aplus Flash Technology" },
	{ 0x229, "ADTEC Corporation" },
	{ 0x22a, "Kentron Technologies" },
	{ 0x22c, "Tachyon Semiconductor (ASIC Designs Inc)" },
	{ 0x22f, "Siemens AG" },
	{ 0x231, "Itautec Philco SA" },
	{ 0x232, "Radiata Inc." },
	{ 0x234, "Legend" },
	{ 0x237, "Enikia Incorporated" },
	{ 0x238, "SwitchOn Networks" },
	{ 0x23b, "ESS Technology" },
	{ 0x23d, "Excess Bandwidth" },
	{ 0x23e, "West bay Semiconductor" },
	{ 0x240, "Newport Communications" },
	{ 0x243, "Intellitech Corporation" },
	{ 0x245, "Ishoni Networks" },
	{ 0x246, "Silicon Spice" },
	{ 0x249, "Centillium Communications" },
	{ 0x24a, "W.L. Gore" },
	{ 0x24c, "GlobeSpan" },
	{ 0x24f, "Saifun Semiconductors" },
	{ 0x251, "MetaLink Technologies" },
	{ 0x252, "Feiya Technology" },
	{ 0x254, "Shikatronics" },
	{ 0x257, "Com-Tier" },
	{ 0x258, "Malaysia Micro Solutions" },
	{ 0x25b, "Anadigm (formerly Anadyne)" },
	{ 0x25d, "Mellanox Technologies" },
	{ 0x25e, "Tenx Technologies" },
	{ 0x261, "Skyup Technology" },
	{ 0x262, "HiNT Corporation" },
	{ 0x264, "MCI Computer GMBH" },
	{ 0x267, "AVED Memory" },
	{ 0x268, "Legerity" },
	{ 0x26b, "nCUBE" },
	{ 0x26d, "FDK Corporation" },
	{ 0x26e, "High Bandwidth Access" },
	{ 0x270, "BRECIS" },
	{ 0x273, "Chicory Systems" },
	{ 0x275, "Fast-Chip" },
	{ 0x276, "Zucotto Wireless" },
	{ 0x279, "eSilicon" },
	{ 0x27a, "Morphics Technology" },
	{ 0x27c, "Silicon Wave" },
	{ 0x283, "Agate Semiconductor" },
	{ 0x285, "HYPERTEC" },
	{ 0x286, "Adhoc Technologies" },
	{ 0x289, "Switchcore" },
	{ 0x28a, "Cisco Systems, Inc." },
	{ 0x28c, "WorkX AG (Wichmann WorkX AG)" },
	{ 0x28f, "E-M Solutions" },
	{ 0x291, "Advanced Hardware Arch." },
	{ 0x292, "Inova Semiconductors GmbH" },
	{ 0x294, "Delkin Devices" },
	{ 0x297, "SiberCore Technologies" },
	{ 0x298, "Southland Microsystems" },
	{ 0x29b, "Great Technology Microcomputer" },
	{ 0x29d, "HADCO Corporation" },
	{ 0x29e, "Corsair" },
	{ 0x2a1, "Silicon Laboratories, Inc. (Cygnal)" },
	{ 0x2a2, "Artesyn Technologies" },
	{ 0x2a4, "Peregrine Semiconductor" },
	{ 0x2a7, "MIPS Technologies" },
	{ 0x2a8, "Chrysalis ITS" },
	{ 0x2ab, "Win Technologies" },
	{ 0x2ad, "Extreme Packet Devices" },
	{ 0x2ae, "RF Micro Devices" },
	{ 0x2b0, "Sarnoff Corporation" },
	{ 0x2b3, "Benchmark Electronics" },
	{ 0x2b5, "SpecTek Incorporated" },
	{ 0x2b6, "Hi/fn" },
	{ 0x2b9, "AANetcom Incorporated" },
	{ 0x2ba, "Micro Memory Bank" },
	{ 0x2bc, "Virata Corporation" },
	{ 0x2bf, "DSP Group" },
	{ 0x2c1, "Chip2Chip Incorporated" },
	{ 0x2c2, "Phobos Corporation" },
	{ 0x2c4, "Nordic VLSI ASA" },
	{ 0x2c7, "Alchemy Semiconductor" },
	{ 0x2c8, "Agilent Technologies" },
	{ 0x2cb, "HanBit Electronics" },
	{ 0x2cd, "Element 14" },
	{ 0x2ce, "Pycon" },
	{ 0x2d0, "Sibyte, Incorporated" },
	{ 0x2d3, "I & C Technology" },
	{ 0x2d5, "Elektrobit" },
	{ 0x2d6, "Megic" },
	{ 0x2d9, "Hyperchip" },
	{ 0x2da, "Gemstone Communications" },
	{ 0x2dc, "3ParData" },
	{ 0x2df, "Helix AG" },
	{ 0x2e0, "Domosys" },
	{ 0x2e3, "Chiaro" },
	{ 0x2e5, "Exbit Technology" },
	{ 0x2e6, "Integrated Technology Express" },
	{ 0x2e9, "Jasmine Networks" },
	{ 0x2ea, "Caspian Networks" },
	{ 0x2ec, "Silicon Access Networks" },
	{ 0x2ef, "MultiLink Technology" },
	{ 0x2f1, "World Wide Packets" },
	{ 0x2f2, "APW Silicon Valley Division" },
	{ 0x2f4, "Xstream Logic" },
	{ 0x2f7, "Realchip" },
	{ 0x2f8, "Galaxy Power" },
	{ 0x2fb, "Accelerant Networks" },
	{ 0x2fd, "SandCraft" },
	{ 0x2fe, "Elpida" },
	{ 0x301, "Solectron" },
	{ 0x302, "Optosys Technologies" },
	{ 0x304, "TriMedia Technologies" },
	{ 0x307, "Optillion" },
	{ 0x308, "Terago Communications" },
	{ 0x30b, "Nanya Technology" },
	{ 0x30d, "Mysticom" },
	{ 0x30e, "LightSand Communications" },
	{ 0x310, "Agere Systems" },
	{ 0x313, "Golden Empire" },
	{ 0x315, "Tioga Technologies" },
	{ 0x316, "Netlist" },
	{ 0x319, "Centon Electronics" },
	{ 0x31a, "Tyco Electronics" },
	{ 0x31c, "Zettacom" },
	{ 0x31f, "Aspex Technology" },
	{ 0x320, "F5 Networks" },
	{ 0x323, "Acorn Networks" },
	{ 0x325, "Kingmax Semiconductor" },
	{ 0x326, "BOPS" },
	{ 0x329, "eMemory Technology" },
	{ 0x32a, "Procket Networks" },
	{ 0x32c, "Trebia Networks" },
	{ 0x32f, "Ample Communications" },
	{ 0x331, "Astute Networks" },
	{ 0x332, "Azanda Network Devices" },
	{ 0x334, "Tekmos" },
	{ 0x337, "Firecron Ltd" },
	{ 0x338, "Resonext Communications" },
	{ 0x33b, "Concept Computer" },
	{ 0x33d, "3Dlabs" },
	{ 0x33e, "ct Magazine" },
	{ 0x340, "Silicon Packets" },
	{ 0x343, "Semicon Devices Singapore" },
	{ 0x345, "Improv Systems" },
	{ 0x346, "INDUSYS GmbH" },
	{ 0x349, "Ritek Corp" },
	{ 0x34a, "empowerTel Networks" },
	{ 0x34c, "Cavium Networks" },
	{ 0x34f, "Intrinsity" },
	{ 0x351, "Terawave Communications" },
	{ 0x352, "IceFyre Semiconductor" },
	{ 0x354, "Picochip Designs Ltd" },
	{ 0x357, "Pijnenburg Securealink" },
	{ 0x358, "MemorySolutionN" },
	{ 0x35b, "Nazomi Communications" },
	{ 0x35d, "Rockwell Collins" },
	{ 0x35e, "Picocel Co. Ltd. (PAION)" },
	{ 0x361, "SiCon Video" },
	{ 0x362, "NanoAmp Solutions" },
	{ 0x364, "PrairieComm" },
	{ 0x367, "MtekVision" },
	{ 0x368, "Allegro Networks" },
	{ 0x36b, "NVIDIA" },
	{ 0x36d, "Peak Electronics" },
	{ 0x36e, "Litchfield Communication" },
	{ 0x370, "Teradiant Networks" },
	{ 0x373, "RAM Components" },
	{ 0x375, "ClearSpeed" },
	{ 0x376, "Matsushita Battery de Baja" },
	{ 0x379, "Utron Technology" },
	{ 0x37a, "Astec Intl" },
	{ 0x37c, "Redux Communications" },
	{ 0x383, "Buffalo (Formerly Melco)" },
	{ 0x385, "Cyan Technologies" },
	{ 0x386, "Global Locate" },
	{ 0x388, "TakeMS International AG" },
	{ 0x389, "Ikanos Communications" },
	{ 0x38a, "Princeton Technology" },
	{ 0x38c, "Elite Flash Storage" },
	{ 0x38f, "ATI Technologies" },
	{ 0x391, "NeoMagic" },
	{ 0x392, "AuroraNetics" },
	{ 0x394, "Mushkin" },
	{ 0x397, "TeraLogic" },
	{ 0x398, "Cicada Semiconductor" },
	{ 0x39b, "Magis Works" },
	{ 0x39d, "Cogency Semiconductor" },
	{ 0x39e, "Chipcon AS" },
	{ 0x3a1, "Programmable Silicon Soluctions" },
	{ 0x3a2, "ChipWrights" },
	{ 0x3a4, "Quicklogic" },
	{ 0x3a7, "Flasys" },
	{ 0x3a8, "BitBlitz Communications" },
	{ 0x3ab, "Purple Ray" },
	{ 0x3ad, "Delta Electronics" },
	{ 0x3ae, "Onex Communications" },
	{ 0x3b0, "Memory Experts Intl" },
	{ 0x3b3, "Dibcom" },
	{ 0x3b5, "API NetWorks" },
	{ 0x3b6, "Bay Microsystems" },
	{ 0x3b9, "Tachys Technologies" },
	{ 0x3ba, "Equator Technology" },
	{ 0x3bc, "SILCOM" },
	{ 0x3bf, "Sanera Systems" },
	{ 0x3c1, "Viasystems Group" },
	{ 0x3c2, "Simtek" },
	{ 0x3c4, "Satron Handelsges" },
	{ 0x3c7, "Corrent" },
	{ 0x3c8, "Infrant Technologies" },
	{ 0x3cb, "Hypertec" },
	{ 0x3cd, "PLX Technology" },
	{ 0x3ce, "Massana Design" },
	{ 0x3d0, "Valence Semiconductor" },
	{ 0x3d3, "Primarion" },
	{ 0x3d5, "Silverback Systems" },
	{ 0x3d6, "Jade Star Technologies" },
	{ 0x3d9, "Cambridge Silicon Radio" },
	{ 0x3da, "Swissbit" },
	{ 0x3dc, "eWave System" },
	{ 0x3df, "Alphamosaic Ltd" },
	{ 0x3e0, "Sandburst" },
	{ 0x3e3, "Ericsson Technology" },
	{ 0x3e5, "Mitac International" },
	{ 0x3e6, "Layer N Networks" },
	{ 0x3e9, "Marvell Semiconductors" },
	{ 0x3ea, "Netergy Microelectronic" },
	{ 0x3ec, "Internet Machines" },
	{ 0x3ef, "Accton Technology Corporation" },
	{ 0x3f1, "Europe Technologies-2" },
	{ 0x3f2, "Cortina Systems" },
	{ 0x3f4, "Raqia Networks" },
	{ 0x3f7, "Xelerated" },
	{ 0x3f8, "SimpleTech" },
	{ 0x3fb, "AVM gmbH" },
	{ 0x3fd, "Dot Hill Systems Corp." },
	{ 0x3fe, "TeraChip" },
	{ 0x401, "T-RAM Incorporated" },
	{ 0x402, "Innovics Wireless" },
	{ 0x404, "KeyEye Communications" },
	{ 0x407, "Dotcast" },
	{ 0x408, "Silicon Mountain Memory" },
	{ 0x40b, "Galazar Networks" },
	{ 0x40d, "Patriot Scientific" },
	{ 0x40e, "Neoaxiom Corporation" },
	{ 0x410, "Europe Technologies" },
	{ 0x413, "Digital Communications Technology Incorporated" },
	{ 0x415, "Fulcrum Microsystems" },
	{ 0x416, "Positivo Informatica Ltd" },
	{ 0x419, "Zhiying Software" },
	{ 0x41a, "Direct2Data" },
	{ 0x41c, "Skyworks Solutions" },
	{ 0x41f, "Zensys A/S" },
	{ 0x420, "Legend Silicon Corp" },
	{ 0x423, "Renesas Technology" },
	{ 0x425, "Phyworks" },
	{ 0x426, "MediaTek" },
	{ 0x429, "Wintegra Ltd" },
	{ 0x42a, "Mathstar" },
	{ 0x42c, "Oplus Technologies" },
	{ 0x42f, "Radia Communications" },
	{ 0x431, "Emuzed" },
	{ 0x432, "LOGIC Devices" },
	{ 0x434, "Quake Technologies" },
	{ 0x437, "Kongsberg Maritime" },
	{ 0x438, "Faraday Technology" },
	{ 0x43b, "ARM Ltd." },
	{ 0x43d, "Vativ Technologies" },
	{ 0x43e, "Endicott Interconnect Tech" },
	{ 0x440, "Bandspeed" },
	{ 0x443, "Ramaxel Technology" },
	{ 0x445, "Axis Communications" },
	{ 0x446, "Legacy Electronics" },
	{ 0x449, "MobilEye Technologies" },
	{ 0x44a, "Excel Semiconductor" },
	{ 0x44c, "VirtualDigm" },
	{ 0x44f, "Yield Microelectronics" },
	{ 0x451, "KINGBOX Technology Co. Ltd." },
	{ 0x452, "Ceva" },
	{ 0x454, "Advance Modules" },
	{ 0x457, "Goal Semiconductor" },
	{ 0x458, "ARC International" },
	{ 0x45b, "Key Stream" },
	{ 0x45d, "Adimos" },
	{ 0x45e, "SiGe Semiconductor" },
	{ 0x461, "Genesis Microchip Inc." },
	{ 0x462, "Vihana, Inc." },
	{ 0x464, "GateChange Technologies" },
	{ 0x467, "Gigaram" },
	{ 0x468, "Enigma Semiconductor Inc." },
	{ 0x46b, "Mediaworks Integrated Systems" },
	{ 0x46d, "Supreme Top Technology Ltd." },
	{ 0x46e, "MicroDisplay Corporation" },
	{ 0x470, "Sinett Corporation" },
	{ 0x473, "SiRF Technology" },
	{ 0x475, "SMaL Camera Technologies" },
	{ 0x476, "Thomson SC" },
	{ 0x479, "SigmaTel" },
	{ 0x47a, "Arkados" },
	{ 0x47c, "Eudar Technology Inc." },
	{ 0x483, "Teknovus" },
	{ 0x485, "Runcom Technologies" },
	{ 0x486, "RedSwitch" },
	{ 0x489, "Signia Technologies" },
	{ 0x48a, "Pixim" },
	{ 0x48c, "White Electronic Designs" },
	{ 0x48f, "3Y Power Technology" },
	{ 0x491, "Potentia Power Systems" },
	{ 0x492, "C-guys Incorporated" },
	{ 0x494, "Silicon-Based Technology" },
	{ 0x497, "XIOtech Corporation" },
	{ 0x498, "PortalPlayer" },
	{ 0x49b, "Phonex Broadband" },
	{ 0x49d, "Entropic Communications" },
	{ 0x49e, "Pacific Force Technology" },
	{ 0x4a1, "sci-worx GmbH" },
	{ 0x4a2, "Oasis Silicon Systems" },
	{ 0x4a4, "Raza Microelectronics" },
	{ 0x4a7, "Non-cents Productions" },
	{ 0x4a8, "US Modular" },
	{ 0x4ab, "StarCore" },
	{ 0x4ad, "Mindspeed" },
	{ 0x4ae, "Just Young Computer" },
	{ 0x4b0, "OCZ" },
	{ 0x4b3, "Inphi Corporation" },
	{ 0x4b5, "Vixel" },
	{ 0x4b6, "SolusTek" },
	{ 0x4b9, "Altium Ltd." },
	{ 0x4ba, "Insyte" },
	{ 0x4bc, "DigiVision" },
	{ 0x4bf, "Pericom" },
	{ 0x4c1, "LeWiz Communications" },
	{ 0x4c2, "CPU Technology" },
	{ 0x4c4, "DSP Group-2" },
	{ 0x4c7, "Chrontel" },
	{ 0x4c8, "Powerchip Semiconductor" },
	{ 0x4cb, "A-DATA Technology" },
	{ 0x4cd, "G Skill Intl" },
	{ 0x4ce, "Quanta Computer" },
	{ 0x4d0, "Afa Technologies" },
	{ 0x4d3, "iStor Networks" },
	{ 0x4d5, "Microsoft" },
	{ 0x4d6, "Open-Silicon" },
	{ 0x4d9, "Simmtec" },
	{ 0x4da, "Metanoia" },
	{ 0x4dc, "Lowrance Electronics" },
	{ 0x4df, "Fodus Communications" },
	{ 0x4e0, "Credence Systems Corp." },
	{ 0x4e3, "WIS Technologies" },
	{ 0x4e5, "High Density Devices AS" },
	{ 0x4e6, "Synopsys" },
	{ 0x4e9, "Century Micro Inc." },
	{ 0x4ea, "Icera Semiconductor" },
	{ 0x4ec, "ONeil Product Development" },
	{ 0x4ef, "Team Group Inc." },
	{ 0x4f1, "Toshiba Corporation" },
	{ 0x4f2, "Tensilica" },
	{ 0x4f4, "Bacoc Inc." },
	{ 0x4f7, "Airgo Networks" },
	{ 0x4f8, "Wisair Ltd." },
	{ 0x4fb, "Compete IT gmbH Co. KG" },
	{ 0x4fd, "Focus Enhancements" },
	{ 0x4fe, "Xyratex" },
	{ 0x501, "Specular Networks" },
	{ 0x502, "Patriot Memory" },
	{ 0x504, "Silicon Optix" },
	{ 0x507, "Stargen, Inc." },
	{ 0x508, "NetCell Corporation" },
	{ 0x50b, "Xsigo Systems, Inc." },
	{ 0x50d, "Tier 1 Multichip Solutions" },
	{ 0x50e, "CWRL Labs" },
	{ 0x510, "Gigaram, Inc." },
	{ 0x513, "P.A. Semi, Inc." },
	{ 0x515, "c2 Microsystems, Inc." },
	{ 0x516, "Level5 Networks" },
	{ 0x519, "02IC Co. Ltd" },
	{ 0x51a, "Tabula, Inc." },
	{ 0x51c, "Chelsio Communications" },
	{ 0x51f, "EADS Astrium" },
	{ 0x520, "ATO Semicon Co. Ltd." },
	{ 0x523, "Tzero" },
	{ 0x525, "Power-One" },
	{ 0x526, "Pulse~LINK Inc." },
	{ 0x529, "Telegent Systems USA, Inc." },
	{ 0x52a, "Atrua Technologies, Inc." },
	{ 0x52c, "eRide Inc." },
	{ 0x52f, "neoOne Technology, Inc." },
	{ 0x531, "Stream Processors, Inc." },
	{ 0x532, "Focus Enhancements." },
	{ 0x534, "uNav Microelectronics" },
	{ 0x537, "Newport Media, Inc." },
	{ 0x538, "VMTS" },
	{ 0x53b, "Solid State System Co., Ltd." },
	{ 0x53d, "Artimi" },
	{ 0x53e, "Power Quotient International" },
	{ 0x540, "ADTechnology" },
	{ 0x543, "Ventura Technology Group" },
	{ 0x545, "M.H.S. SAS" },
	{ 0x546, "Micro Star International" },
	{ 0x549, "Broad Reach Engineering Co." },
	{ 0x54a, "Semiconductor Mfg Intl Corp" },
	{ 0x54c, "FCI USA Inc." },
	{ 0x54f, "Spans Logic" },
	{ 0x551, "Qimonda" },
	{ 0x552, "New Japan Radio Co. Ltd." },
	{ 0x554, "Montalvo Systems" },
	{ 0x557, "AENEON" },
	{ 0x558, "Lorom Industrial Co. Ltd" },
	{ 0x55b, "Nethra Imaging" },
	{ 0x55d, "CompuStocx (CSX)" },
	{ 0x55e, "Methode" },
	{ 0x561, "Septentrio NV" },
	{ 0x562, "Goldenmars Technology Inc." },
	{ 0x564, "Cochlear Ltd." },
	{ 0x567, "Spansion, Inc." },
	{ 0x568, "Taiwan Semiconductor Mfg" },
	{ 0x56b, "Mobilygen Corporation" },
	{ 0x56d, "Cswitch Corporation" },
	{ 0x56e, "Haier (Beijing) IC Design Co." },
	{ 0x570, "Axel Electronics Co. Ltd." },
	{ 0x583, "U-Chip Technology Corp." },
	{ 0x585, "Greenfield Networks" },
	{ 0x586, "CompuRAM GmbH" },
	{ 0x589, "Excalibrus Technologies Ltd" },
	{ 0x58a, "SCM Microsystems" },
	{ 0x58c, "CHIPS & Systems Inc" },
	{ 0x58f, "Teradici" },
	{ 0x591, "g2 Microsystems" },
	{ 0x592, "PowerFlash Semiconductor" },
	{ 0x594, "NovaTech Solutions, S.A." },
	{ 0x597, "COS Memory AG" },
	{ 0x598, "Innovasic Semiconductor" },
	{ 0x59b, "Crucial Technology" },
	{ 0x59d, "Solarflare Communications" },
	{ 0x59e, "Xambala Inc." },
	{ 0x5a1, "Imaging Works, Inc." },
	{ 0x5a2, "Astute Networks, Inc." },
	{ 0x5a4, "Emulex" },
	{ 0x5a7, "Hon Hai Precision Industry" },
	{ 0x5a8, "White Rock Networks Inc." },
	{ 0x5ab, "Acbel Polytech Inc-2" },
	{ 0x5ad, "ULi Electronics Inc." },
	{ 0x5ae, "Magnum Semiconductor Inc." },
	{ 0x5b0, "Connex Technology, Inc." },
	{ 0x5b3, "Telecis Wireless, Inc." },
	{ 0x5b5, "Tarari, Inc." },
	{ 0x5b6, "Ambric, Inc." },
	{ 0x5b9, "Enuclia Semiconductor, Inc." },
	{ 0x5ba, "Virtium Technology Inc." },
	{ 0x5bc, "Kian Tech LLC" },
	{ 0x5bf, "Avago Technologies" },
	{ 0x5c1, "Sigma Designs" },
	{ 0x5c2, "SiCortex, Inc." },
	{ 0x5c4, "eASIC" },
	{ 0x5c7, "Rapport Inc." },
	{ 0x5c8, "Makway International" },
	{ 0x5cb, "SiConnect" },
	{ 0x5cd, "Validity Sensors" },
	{ 0x5ce, "Coney Technology Co. Ltd." },
	{ 0x5d0, "Neterion Inc." },
	{ 0x5d3, "Velogix" },
	{ 0x5d5, "iVivity Inc." },
	{ 0x5d6, "Walton Chaintech" },
	{ 0x5d9, "Radiospire Networks" },
	{ 0x5da, "Sensio Technologies, Inc." },
	{ 0x5dc, "Hexon Technology Pte Ltd" },
	{ 0x5df, "Connect One Ltd." },
	{ 0x5e0, "Opulan Technologies" },
	{ 0x5e3, "Kreton Corporation" },
	{ 0x5e5, "Altair Semiconductor" },
	{ 0x5e6, "NetEffect, Inc." },
	{ 0x5e9, "Emphany Systems Inc." },
	{ 0x5ea, "ApaceWave Technologies" },
	{ 0x5ec, "Tego" },
	{ 0x5ef, "MetaRAM" }
};

fru_enum_t FRU_Type[] = {
	{ 0x0, "Unknown FRU" },
	{ 0x101, "System Controller" },
	{ 0x102, "SP System Controller" },
	{ 0x201, "CPU Board" },
	{ 0x202, "WCI CPU Board CPU WIB" },
	{ 0x203, "Zulu CPU Board" },
	{ 0x204, "CPU Board V2" },
	{ 0x205, "CPU Board V3" },
	{ 0x206, "LW8_CPU_Board" },
	{ 0x207, "LW8 CPU Board V3" },
	{ 0x208, "DDR CPU Board" },
	{ 0x209, "LW8 DDR CPU Board" },
	{ 0x20a, "CPU Board V4" },
	{ 0x20b, "LW8 CPU Board V4" },
	{ 0x20c, "Thunder CPU Motherboard" },
	{ 0x20d, "Lightning CPU Motherboard" },
	{ 0x301, "L2 Board" },
	{ 0x302, "Logic Analyzer Board" },
	{ 0x303, "SP L2 Board" },
	{ 0x304, "Repeater Board V2" },
	{ 0x401, "DC IO Fan Tray" },
	{ 0x402, "DC CPU Fan Tray" },
	{ 0x403, "Rack Fan Tray" },
	{ 0x404, "ME Fan Tray" },
	{ 0x405, "MD IO Fan Tray" },
	{ 0x406, "MD CPU Fan Tray" },
	{ 0x407, "MD Top Fan Tray" },
	{ 0x408, "SP Fan Tray" },
	{ 0x409, "MD Bottom IO Fan Tray" },
	{ 0x40a, "LW8_Fan_Tray" },
	{ 0x40b, "MD Top IO High Volume Fan Tray" },
	{ 0x40c, "MD Bottom Left IO High Volume Fan Tray" },
	{ 0x40d, "MD Bottom Right IO High Volume Fan Tray" },
	{ 0x40e, "MD PAN1800 Top High Volume Fan Tray" },
	{ 0x40f, "MD PAN1800 Bottom Left High Volume Fan Tray" },
	{ 0x410, "MD PAN1800 Bottom Right High Volume Fan Tray" },
	{ 0x411, "Tachometer Sensor Fan Tray Board" },
	{ 0x501, "PCI IO Board" },
	{ 0x502, "CPCI IO Board" },
	{ 0x503, "SP CPCI IO Board" },
	{ 0x504, "WCI CPCI IO Board NonSP IO WIB" },
	{ 0x505, "WCI SP CPCI IO Board SPonly IO WIB" },
	{ 0x506, "LW8_PCI_Board" },
	{ 0x507, "PCIX IO Board" },
	{ 0x508, "XMIT PCIX Board" },
	{ 0x509, "LW8_PCIX_Board" },
	{ 0x50a, "LW8_PCI+_Board" },
	{ 0x50b, "PCIE IO Board" },
	{ 0x601, "A123 Power Supply" },
	{ 0x602, "A138 Power Supply" },
	{ 0x603, "A145 Power Supply" },
	{ 0x604, "A152 Power Supply" },
	{ 0x605, "A153 Power Supply" },
	{ 0x606, "A145E Power Supply" },
	{ 0x607, "A166_Module" },
	{ 0x608, "D142_Module" },
	{ 0x609, "A184 Power Supply" },
	{ 0x60a, "A185 Power Supply" },
	{ 0x60b, "A212 Power Supply" },
	{ 0x60c, "A213 Power Supply" },
	{ 0x60d, "A209 Power Supply" },
	{ 0x60e, "A195 Power Supply" },
	{ 0x701, "SP Centerplane" },
	{ 0x702, "DC Centerplane w/ID Board" },
	{ 0x703, "ME Centerplane w/ID Board" },
	{ 0x704, "MD Centerplane w/ID Board" },
	{ 0x705, "SP Replacement Centerplane" },
	{ 0x706, "DS Replacement Centerplane" },
	{ 0x707, "ME Replacement Centerplane" },
	{ 0x708, "MD Replacement Centerplane" },
	{ 0x709, "Generic Replacement ID Board" },
	{ 0x70a, "LW8_SCC" },
	{ 0x70b, "LW8_AC_Chassis" },
	{ 0x70c, "LW8_DC_Chassis" },
	{ 0x70d, "4900 Centerplane w/ID Board" },
	{ 0x70e, "6900 Centerplance w/ID Board" },
	{ 0x70f, "4900 Replacement Centerplane" },
	{ 0x710, "6900 Replacement Centerplane" },
	{ 0x711, "E2900_CHASSIS" },
	{ 0x712, "N1290_CHASSIS" },
	{ 0x713, "IOBox Centerplane" },
	{ 0x801, "Top Cap Asm Frame Manager" },
	{ 0x901, "RTS Seq" },
	{ 0xa01, "2MB Ecache" },
	{ 0xa02, "4MB Ecache" },
	{ 0xa03, "8MB Ecache" },
	{ 0xa04, "16MB Ecache" },
	{ 0xb00, "64 MB DIMM" },
	{ 0xb01, "128 MB DIMM" },
	{ 0xb02, "256 MB DIMM" },
	{ 0xb03, "512 MB DIMM" },
	{ 0xb04, "1024 MB DIMM" },
	{ 0xb05, "2048 MB DIMM" },
	{ 0xc01, "COU WIB Paroli Opt Mod" },
	{ 0xc02, "CPCI FF Paroli Single Link Mod" },
	{ 0xc03, "CPCI FF Paroli Double Link Mod" },
	{ 0xc04, "Optical Link Card" },
	{ 0xc05, "Copper Link Card" },
	{ 0xc06, "New_EnumCodeeo" },
	{ 0xd01, "2MB_WC_DIMM" },
	{ 0xd02, "10MB_WC_DIMM" },
	{ 0xd03, "20MB_WC_DIMM" },
	{ 0xd04, "40MB_WC_DIMM" },
	{ 0xd05, "Cluster_WC_DIMM" },
	{ 0xd06, "20MB_WC_ECC_DIMM" },
	{ 0xd07, "40MB_WC_ECC_DIMM" },
	{ 0xd08, "Cluster_WC_ECC_DIMM" },
	{ 0xe01, "LW8_PDB" },
	{ 0xe02, "LW8_Baseplane" },
	{ 0xe03, "LW8_Indicator_BD" },
	{ 0xe04, "LW8_Media_Bay" },
	{ 0xe05, "2900_Indicator_BD" },
	{ 0xe06, "1290_Indicator_BD" },
	{ 0xe07, "A224 Power Supply" },
	{ 0xe08, "A225 Power Supply" },
	{ 0xe09, "Lightning IO board" }
};

fru_enum_t CPU_Type[] = {
	{ 0x0, "Cheetah" },
	{ 0x1, "Jubatus" }
};

fru_enum_t Cause_Code[] = {
	{ 0x1f4, "ENGINEERING REVIEW NTF" },
	{ 0x1f5, "SHOTGUN" },
	{ 0x1f6, "DEFECTIVE COMPONENT REPLACED" },
	{ 0x1f7, "POWER SUPPLY REPLACE/REPAIR" },
	{ 0x1f8, "VIDEO PCB REPLACE/REPAIR" },
	{ 0x1f9, "DEFLECTION PCB REPLACE/REPAIR" },
	{ 0x1fa, "I/O PCB REPLACE/REPAIR" },
	{ 0x1fb, "SCRAP" },
	{ 0x1fc, "REPLACE BEZEL" },
	{ 0x1fd, "REPLACE BACKCOVER" },
	{ 0x1fe, "REPLACE BASE" },
	{ 0x1ff, "REPLACE CRT" },
	{ 0x200, "REPLACE SUBASSEMBLY (OTHER)" },
	{ 0x201, "HIGH VOLTAGE (Flyback) REPLACED" },
	{ 0x202, "B & W OUT OF ADJUSTMENT" },
	{ 0x203, "WHITE BALANCE OUT OF ADJUSTMENT" },
	{ 0x204, "CONVERGENCE OUT OF ADJUSTMENT" },
	{ 0x205, "REJUVENATION" },
	{ 0x206, "RESTORE CRT" },
	{ 0x207, "YOKE ASSEMBLY REPLACEMENT" },
	{ 0x208, "RFB1-P4 DA-CAPS" },
	{ 0x209, "BAD / DIRTY CONNECTION" },
	{ 0x20a, "THERMAL INTERMITTENT DEVICE" },
	{ 0x20b, "VOLTAGE MARGIN FAILURE" },
	{ 0x20c, "FREQUENCY MARGIN FAILURE" },
	{ 0x20d, "BAD DATE CODE" },
	{ 0x20e, "SHORTED TRACE" },
	{ 0x20f, "OPEN TRACE" },
	{ 0x210, "DEVICE DEAD/NO OUTPUT" },
	{ 0x211, "INTERMITTENT DEVICE" },
	{ 0x212, "REPLACE / FLASH PROM" },
	{ 0x213, "RECONFIGURE JUMPER / SWITCH" },
	{ 0x214, "REPLACE CONNECTOR" },
	{ 0x215, "BENT PIN" },
	{ 0x216, "MISSING COMPONENT(S)/HARDWARE" },
	{ 0x217, "WRONG COMPONENT(S)/HARDWARE" },
	{ 0x218, "COMPONENT INCORRECTLY INSTALLED" },
	{ 0x219, "COLD SOLDER" },
	{ 0x21a, "SOLDER BRIDGE" },
	{ 0x21b, "UNSOLDERED" },
	{ 0x21c, "CANNOT DUPLICATE ERROR" },
	{ 0x21d, "INADEQUATE DIAGNOSTICS" },
	{ 0x21e, "ECO INCORRECTLY INSTALLED" },
	{ 0x21f, "ADJUST TO SPEC" },
	{ 0x220, "ECO UPGRADE" },
	{ 0x221, "REPLACED FAN" },
	{ 0x222, "BURNT" },
	{ 0x223, "CLEAN & TEST" },
	{ 0x224, "DAMAGED FAB" },
	{ 0x225, "AUTO SCRAP" },
	{ 0x226, "REPLACED BLOWN FUSE" },
	{ 0x227, "REPLACED COMPONENT" },
	{ 0x228, "REPAIRED COMPONENT" },
	{ 0x229, "HIGH IMPEDANCE ETCH" },
	{ 0x22a, "SEATING PROBLEM" },
	{ 0x22b, "SOFTWARE PROBLEM" },
	{ 0x22c, "CONFIGURATION ERROR" },
	{ 0x22d, "OTHER" },
	{ 0x22e, "HEAD" },
	{ 0x22f, "SENSOR(S)" },
	{ 0x230, "MOTOR-REEL" },
	{ 0x231, "MOTOR-CAPSTAN" },
	{ 0x232, "MOTOR-STEPPER" },
	{ 0x233, "MOTOR-EJECT" },
	{ 0x234, "Code Not Used" },
	{ 0x235, "PCB-INTERFACE" },
	{ 0x236, "PCB-READ/WRITE" },
	{ 0x237, "PCB-SERVO" },
	{ 0x238, "PINCH ROLLER" },
	{ 0x239, "LEADER" },
	{ 0x23a, "REPLACED/REPAIRED DA/MAIN BOARD" },
	{ 0x23b, "REPLACED/REPAIRED AC ADAPTER" },
	{ 0x23c, "REPLACED/REPAIRED INVERTER PCB" },
	{ 0x23d, "REPLACED/REPAIRED USER CONTROL PCB" },
	{ 0x23e, "REPLACED FLAT PANEL" },
	{ 0x23f, "REPLACED/REPAIRED TMDS CABLE" },
	{ 0x240, "REPLACED/REPAIRED USER CONTROL CABLE" },
	{ 0x241, "REPLACED/REPAIRED BACKLIGHTS" },
	{ 0x242, "BLACK LEVEL ADJUST" },
	{ 0x243, "REPLACED/REPAIRED VIDEO INPUT CONNECTOR" },
	{ 0x244, "BATTERY REPLACEMENT" },
	{ 0x245, "RECHARGE BATTERY" },
	{ 0x246, "RETURN TO CUSTOMER" },
	{ 0x248, "NTF-MISSPULL" },
	{ 0x249, "NTF-MASS SWAP" },
	{ 0x24a, "NTF-SEATING ISSUE/BAD CONNECTION" },
	{ 0x24b, "NTF-CUSTOMER REQUEST REPLACEMENT" },
	{ 0x24c, "NTF-ECO UPGRADE PRIOR TO TEST" },
	{ 0x24d, "NTF-CANNOT DUPLICATE FAILURE" },
	{ 0x24e, "ROBOTICS MECHANICAL FAILURE-" },
	{ 0x24f, "MC ERB Good part - Multiple Parts Replaced" },
	{ 0x250, "Defective Component Replaced under Engineering Analysis" },
	{ 0x251, "Defective Component/Subassembly Replaced" },
	{ 0x252, "Excessive Components Replaced -SCRAP" },
	{ 0x253, "Black & White (B&W) out of adjustment" },
	{ 0x254, "New_EnumCodeWhite balance out of adjustment" },
	{ 0x255, "Convergence out of adjustment" },
	{ 0x256, "Rejuvination/Restore CRT" },
	{ 0x257, "NTF - Seating issue/bad connection" },
	{ 0x258, "Upgrade due to PURGE/ECO/FCO (Parts are Functional)" },
	{ 0x259, "Shorted Trace/Connection" },
	{ 0x25a, "Open Trace" },
	{ 0x25b, "Firmware Problem" },
	{ 0x25c, "Reconfigure Jumper/Switch" },
	{ 0x25d, "Bent pin repair" },
	{ 0x25e, "Missing Component(s)/Hardware" },
	{ 0x25f, "Wrong Component(s) Hardware" },
	{ 0x260, "Component/Hardware incorrectly  installed" },
	{ 0x261, "Solder Problem" },
	{ 0x262, "NTF - Cannot duplicate failure" },
	{ 0x263, "NTF-Misspull" },
	{ 0x264, "Adjust to specification" },
	{ 0x265, "Burnt - SCRAPPED" },
	{ 0x266, "Dirty" },
	{ 0x267, "Damaged - SCRAP" },
	{ 0x268, "Autoscrap" },
	{ 0x269, "This NTF was probablycausedbya seating issueor badconnect" },
	{ 0x26a, "Configuration Error" },
	{ 0x26b, "Battery Cell(s) replaced" },
	{ 0x26c, "Recharge Battery" },
	{ 0x26d, "Sent to OEM for Repair - Tested" },
	{ 0x26e, "MC ERB Good part- Misspull" },
	{ 0x26f, "Failure not duplicated,part successfullypassed alltesting" },
	{ 0x270, "NTF- Upgraded prior to test" },
	{ 0x271, "NTF ? Can not duplicate failure" },
	{ 0x272, "Robotics mechanical failure" },
	{ 0x273, "Incorrect torque setting" },
	{ 0x274, "Foreign Material" },
	{ 0x275, "ESD Compromised - Bag Missing" },
	{ 0x276, "ESD Compromised - Bag Torn" },
	{ 0x277, "ESD Compromised - Bag not folded closed" },
	{ 0x278, "ESD Compromised - Part not in approved ESD Box" },
	{ 0x279, "ESD Compromised - Clamshell damaged" },
	{ 0x27a, "Sent to OEM for Repair - NotTested" },
	{ 0x27b, "Non-Sun Unit" },
	{ 0x27c, "Sent to Sun Engineering for RCCA" },
	{ 0x27d, "Unreleased Product - SCRAP" },
	{ 0x27e, "ECO/DPCO SCRAP" },
	{ 0x27f, "Non-Economical to Repair-SCRAP" },
	{ 0x280, "Multiple Return SCRAP" },
	{ 0x281, "NTF - Tested Prior to Upgrade" },
	{ 0x282, "NTF- Assumed Good" },
	{ 0x283, "NTF- Multiple Return" },
	{ 0x284, "Damaged - Repaired" },
	{ 0x285, "Noisy - Audible Repaired" },
	{ 0x286, "Noisy - Audible SCRAPPED" },
	{ 0x287, "Tampered/Modified - SCRAPPED" },
	{ 0x288, "Environmental Failure" },
	{ 0x289, "Dirty - SCRAP" },
	{ 0x28a, "ESD - SCRAPPED" },
	{ 0x28b, "MictorConnector Reflow executed" },
	{ 0x28c, "SCRAP - Damaged CRT" },
	{ 0x28d, "SCRAP - Phosphor Aged/Defects" },
	{ 0x28e, "SCRAP - Damaged Flat Panel" },
	{ 0x28f, "Geometry adjustment" },
	{ 0x290, "Image Sizing adjustment" },
	{ 0x291, "Magnetic Field Damage" },
	{ 0x292, "Drive Mechnical/DLT assembly failure" },
	{ 0x293, "Re-servo track write" },
	{ 0x294, "Missing defect list" },
	{ 0x295, "Excessive defects" },
	{ 0x296, "Media Bad/Scratched" },
	{ 0x297, "Faulty/Broken  Wiring" },
	{ 0x298, "Defective component thatcaused fieldfailure.ReproducedbyRV" },
	{ 0x299, "Defective componentthatfailedduring RVtest nofieldfailure" },
	{ 0x29a, "MC ERB failure cause unknown" },
	{ 0x29b, "MC ERB Good part - Software" },
	{ 0x29c, "MC ERB Good part - Customer Sat" }
};

fru_enum_t Error_Type[] = {
	{ 0x1, "UE" },
	{ 0x2, "CE" }
};

fru_enum_t Error_Platform[] = {
	{ 0x1, "Serengeti" },
	{ 0x2, "Excalibur" },
	{ 0x3, "Daktari" },
	{ 0x4, "Starcat" },
	{ 0x5, "Wildcat" }
};

fru_enum_t AFT_Struct[] = {
	{ 0x0, "None" },
	{ 0x1, "CPU" },
	{ 0x2, "IO PCI" },
	{ 0x3, "IO CPCI" },
	{ 0x4, "IO SP CPCI" },
	{ 0x5, "WCI CPU" },
	{ 0x6, "WCI IO CPCI" },
	{ 0x7, "WCI IO SP CPCI" }
};

fru_enum_t Device_Type[] = {
	{ 0x0, "Unknown Device" },
	{ 0x66, "Excalibur Motherboard" },
	{ 0xca, "Excalibur CPU 1MB Module" },
	{ 0xcb, "Excalibur CPU 4MB Module" },
	{ 0xcc, "Excalibur CPU 8MB Module" },
	{ 0xfb, "Graphics_Board" },
	{ 0x100, "Motherboard" },
	{ 0x101, "Daktari Motherboard" },
	{ 0x102, "Littleneck Motherboard" },
	{ 0x103, "Cherrystone Centerplane" },
	{ 0x104, "A42 Motherboard" },
	{ 0x105, "Ontario Niagara CPU Board" },
	{ 0x106, "Erie Systemboard" },
	{ 0x107, "Ontario Niagara 8 Core 1.0 GHz CPU Board" },
	{ 0x108, "Ontario Niagara 8 Core 1.2 GHz CPU Board" },
	{ 0x109, "Ontario Niagara 6 Core 1.0 GHz CPU Board" },
	{ 0x10a, "Ontario Niagara 4 Core 1.0 GHz CPU Board" },
	{ 0x10b, "Erie 4 Core 1.0 GHz Systemboard" },
	{ 0x10c, "Erie 6 Core 1.0 GHz Systemboard" },
	{ 0x10d, "Erie 8 Core 1.0 GHz Systemboard" },
	{ 0x10e, "Boston 1.6 GHz CPU Module" },
	{ 0x10f, "Boston 1.8 GHz CPU Module" },
	{ 0x110, "Boston 2.0 GHz CPU Module" },
	{ 0x111, "Boston Motherboard" },
	{ 0x112, "Erie 8 Core 1.2 GHz Systemboard" },
	{ 0x113, "Huron 6 Core Motherboard" },
	{ 0x114, "Huron 8 Core Motherboard" },
	{ 0x115, "Huron 4 Core Motherboard" },
	{ 0x116, "Maramba 6 Core 1.2 GHz Motherboard" },
	{ 0x117, "Maramba 8 Core 1.2 GHz Motherboard" },
	{ 0x118, "Maramba 6 Core 1.4 GHz Motherboard" },
	{ 0x119, "Maramba 8 Core 1.4 GHz Motherboard" },
	{ 0x11a, "Thunder 1.2GHz Motherboard" },
	{ 0x11b, "Thunder 1.4GHz Motherboard" },
	{ 0x11c, "Lightning 1.2GHz Motherboard" },
	{ 0x11d, "Lightning 1.4GHz Motherboard" },
	{ 0x11e, "Lightning IO Board" },
	{ 0x11f, "Huron 2 Core Motherboard" },
	{ 0x120, "Maramba 4 Core 1.2 GHz Motherboard" },
	{ 0x121, "Monza 6 Core 1.2 GHz Motherboard" },
	{ 0x122, "Monza 8 Core 1.2 GHz Motherboard" },
	{ 0x123, "Scottsdale 6 Core 1.2 GHz Motherboard" },
	{ 0x124, "Scottsdale 8 Core 1.2 GHz Motherboard" },
	{ 0x125, "Scottsdale 8 Core 1.4 GHz Motherboard" },
	{ 0x126, "Scottsdale 4 Core 1.2 GHz Motherboard" },
	{ 0x127, "Mongo Motherboard" },
	{ 0x128, "Scottsdale 2 Core 1.2 GHz Motherboard" },
	{ 0x200, "CPU Module" },
	{ 0x201, "Daktari CPU Module" },
	{ 0x202, "A42 1.064 GHZ CPU Memory Module" },
	{ 0x203, "A42 1.280 GHZ CPU Memory Module" },
	{ 0x204, "SeSi CMP Module" },
	{ 0x205, "Maramba Memory Riser" },
	{ 0x300, "IO Board" },
	{ 0x301, "Daktari IO Board" },
	{ 0x302, "Ontario IO Board" },
	{ 0x303, "Cherrystone Riser" },
	{ 0x304, "Ontario Front IO Board" },
	{ 0x305, "G2 Front IO Board" },
	{ 0x306, "Ontario IO-E Board" },
	{ 0x307, "Boston Front IO Board" },
	{ 0x308, "Thumper 0 IO Board" },
	{ 0x309, "Jake Fan Power Board" },
	{ 0x30a, "Elwood Fan Power Board" },
	{ 0x30b, "Thumper F IO Board" },
	{ 0x400, "RSC Card" },
	{ 0x401, "Daktari RSC Card" },
	{ 0x402, "ALOM Card" },
	{ 0x403, "ALOM Plus Card" },
	{ 0x404, "Ontario Service Processor" },
	{ 0x405, "Boston Service Processor" },
	{ 0x406, "Pelton Service Processor" },
	{ 0x407, "Glendale Service Processor" },
	{ 0x408, "Scottsdale Service Processor" },
	{ 0x500, "Disk Backplane" },
	{ 0x501, "Daktari Disk Backplane" },
	{ 0x502, "Littleneck Disk Backplane" },
	{ 0x503, "Cherrystone Disk Backplane" },
	{ 0x504, "A42 SCSI Disk Backplane" },
	{ 0x505, "N42 SCSI Disk Backplane" },
	{ 0x506, "Ontario SAS Disk Backplane" },
	{ 0x507, "Boston SAS Disk Backplane" },
	{ 0x508, "Boston 4 Disk SAS Controller" },
	{ 0x509, "Boston 8 Disk SAS Controller" },
	{ 0x50a, "Boston 8 Disk RAID SAS Controller" },
	{ 0x50b, "Constellation 10.0 Midplane" },
	{ 0x50c, "Jake 4 Disk Backplane" },
	{ 0x50d, "Jake 8 Disk Backplane" },
	{ 0x50e, "Elwood 16 Disk Backplane" },
	{ 0x50f, "Elwood 8 Disk Backplane" },
	{ 0x510, "Constellation 48 Midplane" },
	{ 0x511, "Congo SAS Back Plane" },
	{ 0x512, "Jackal REM - no PBSRAM" },
	{ 0x513, "Jackal REM - PBSRAM" },
	{ 0x514, "Mongo ES Backplane" },
	{ 0x600, "PDB Board" },
	{ 0x601, "Daktari PDB Board" },
	{ 0x602, "Littleneck PDB Board" },
	{ 0x603, "Cherrystone PDB	Board" },
	{ 0x604, "N42 PDB Board" },
	{ 0x605, "Ontario Power Distribution Board" },
	{ 0x606, "G2 Power Distribution Board" },
	{ 0x607, "Boston Power Distribution Board" },
	{ 0x608, "N2 Power Distribution Board" },
	{ 0x609, "Pelton Power Distribution Board" },
	{ 0x60a, "Jake Power Distribution Board" },
	{ 0x60b, "Elwood Power Distribution Board" },
	{ 0x60c, "D2 Power Distribution Board" },
	{ 0x60d, "Turgo Power Distribution Board" },
	{ 0x60e, "Congo Power Distribution Board" },
	{ 0x700, "Power Supply" },
	{ 0x701, "Daktari Power Supply" },
	{ 0x702, "Littleneck Power Supply" },
	{ 0x703, "Cherrystone Power Supply" },
	{ 0x704, "A42 AC Power Supply" },
	{ 0x800, "GBIC Board" },
	{ 0x801, "Daktari GBIC Board" },
	{ 0x802, "N2 XAUI Copper Board" },
	{ 0x803, "N2 XAUI Optical Board" },
	{ 0x900, "LoopB Card" },
	{ 0x901, "Daktari LoopB Card" },
	{ 0xa00, "Galaxy 1x.0 Motherboard" },
	{ 0xa01, "Galaxy 1x.1.last Motherboard" },
	{ 0xa02, "Galaxy 1x.2.rohs Motherboard" },
	{ 0xa10, "Galaxy 2x.0 Motherboard" },
	{ 0xa11, "Galaxy 2x.1.last Motherboard" },
	{ 0xa12, "Galaxy 2x.2.rohs Motherboard" },
	{ 0xa20, "Galaxy 1e.0 Motherboard" },
	{ 0xa30, "Galaxy 2e.0 Motherboard" },
	{ 0xa40, "Galaxy 1f.0 Motherboard" },
	{ 0xa50, "Galaxy 2f.0 Motherboard" },
	{ 0xa60, "Galaxy 4.0 Motherboard" },
	{ 0xa61, "Dorado/Tucana Motherboard" },
	{ 0xa62, "Dorado 1U" },
	{ 0xa63, "Tucana - 2 Sockets" },
	{ 0xa64, "Dorado 2U - 16 Disk" },
	{ 0xa65, "Tucana - 4 Sockets" },
	{ 0xa66, "Dorado 2U - both 8 and 16 disk models" },
	{ 0xa67, "Lynx Motherboard" },
	{ 0xa68, "Lynx 1U - 8 Disk" },
	{ 0xa69, "Lynx 2U - 16 Disk" },
	{ 0xa70, "Glendale 4-core 1.17 GHz MB" },
	{ 0xa71, "Glendale 6-core 1.17 GHz MB" },
	{ 0xa72, "Glendale 8-core 1.17 GHz MB" },
	{ 0xa73, "Glendale 8-core 1.42 GHz MB" },
	{ 0xa74, "Doradi 1U - SunFire x4150" },
	{ 0xa75, "Doardi 2U - SunFire x4250" },
	{ 0xa76, "Tucani 2U - SunFire x4450" },
	{ 0xa77, "Aries 2U - Netra x4250" },
	{ 0xa78, "Argo 4U - Netra x4450" },
	{ 0xa79, "Venus 1U SunFire x2250" },
	{ 0xb01, "Gemini 0 Blade" },
	{ 0xb02, "Pegasus 0 Blade" },
	{ 0xb03, "Draco Motherboard" },
	{ 0xb04, "VELA Blade" },
	{ 0xb05, "Wolf Blade" },
	{ 0xb06, "St. Paul Blade" },
	{ 0xb07, "Hercules Blade" },
	{ 0xb08, "Virgo Blade" },
	{ 0xb09, "Gemini+ Blade" },
	{ 0xb0a, "Pegasus+ Blade" },
	{ 0xc00, "Chassis Management Module" },
	{ 0xc01, "C10 Chassis Management Module" },
	{ 0xc02, "C48 Chassis Management Module" },
	{ 0xc03, "Huron1" },
	{ 0xc04, "Huron2" },
	{ 0xc05, "NEM" },
	{ 0xc06, "NEM+" },
	{ 0xc07, "Hydra NEM" },
	{ 0xc08, "IB NEM 176" },
	{ 0xc09, "IB NEM 256" },
	{ 0xc0a, "Batoka 8 Core 1.2GHz CPU Module" },
	{ 0xc0b, "Batoka 6 Core 1.2GHz CPU Module" },
	{ 0xc0c, "Batoka 4 Core 1.2GHz CPU Module" },
	{ 0xc0d, "Batoka 8 Core 1.4GHz CPU Module" },
	{ 0xc0e, "Batoka 6 Core 1.4GHz CPU Module" },
	{ 0xc0f, "Batoka 4 Core 1.4GHz CPU Module" },
	{ 0xc10, "Batoka 8 Core 1.6GHz CPU Module" },
	{ 0xc11, "Batoka 6 Core 1.6GHz CPU Module" },
	{ 0xc12, "Batoka 4 Core 1.6GHz CPU Module" },
	{ 0xc13, "Batoka Memory Expansion Module" },
	{ 0xc14, "Batoka Motherboard" },
	{ 0xc15, "Batoka Service Processor" },
	{ 0xc16, "C48 Goa NEM" },
	{ 0xc17, "C10 Goa NEM" }
};

fru_enum_t Ecache_Mode[] = {
	{ 0x0, "Late_Write" },
	{ 0x1, "Late_Select" }
};

fru_enum_t Repair_Sympton_Code[] = {
	{ 0x1, "NTF" },
	{ 0x2, "ECO UPDATE" },
	{ 0x3, "FIRST PASS NTF" },
	{ 0x4, "POOR / MISSING ESD PROTECTION" },
	{ 0x5, "NO FAILURE INFORMATION" },
	{ 0x6, "RETEST ONLY" },
	{ 0x7, "DOWN REV" },
	{ 0x8, "DAMAGED - COSMETIC" },
	{ 0x9, "BURNT." },
	{ 0xa, "DAMAGED CONNECTIONS" },
	{ 0xb, "MECHANICAL / PHYSICAL DAMAGE" },
	{ 0xc, "NO POWER" },
	{ 0xd, "RECEIVED DAMAGED" },
	{ 0xe, "WILL NOT BOOT SCSI" },
	{ 0xf, "NOISY - AUDIBLE" },
	{ 0x10, "NOISE - ELECTRICAL" },
	{ 0x11, "SELF TEST FAILURE" },
	{ 0x12, "MECHANICAL FAILURE" },
	{ 0x13, "NONFUNCTIONAL/NO RESPONSE" },
	{ 0x14, "VTS/SUNDIAG ERROR" },
	{ 0x15, "WILL NOT BOOT UNIX" },
	{ 0x16, "MISSING COMPONENT(S)" },
	{ 0x17, "ETHERNET PROBLEM" },
	{ 0x18, "LOST POWER (INTERMITTENT)" },
	{ 0x19, "DIAGNOSTIC FAILURE (OTHER)" },
	{ 0x1a, "POST TEST FAILURE" },
	{ 0x1b, "WORKMANSHIP" },
	{ 0x1c, "DAMAGED CABLE" },
	{ 0x1d, "MISSING HARDWARE" },
	{ 0x1e, "ENVIRONMENTAL FAILURE" },
	{ 0x1f, "DEFECTIVE SCSI PORT" },
	{ 0x20, "DIRTY" },
	{ 0x21, "BAD FAN" },
	{ 0x22, "MODIFIED / ABUSED UNIT" },
	{ 0x23, "UNRELEASED PRODUCT" },
	{ 0x24, "NON-SUN UNIT" },
	{ 0x64, "DISTORTED VIDEO" },
	{ 0x65, "UNSTABLE VIDEO" },
	{ 0x66, "NO VIDEO" },
	{ 0x67, "DIM VIDEO" },
	{ 0x68, "POOR FOCUS" },
	{ 0x69, "IMAGE QUALITY" },
	{ 0x6a, "DAMAGED CRT" },
	{ 0x6b, "GEOMETRY OUT OF SPEC" },
	{ 0x6c, "IMAGE SIZING PROBLEM" },
	{ 0x6d, "PHOSPHOR AGED/DEFECTS" },
	{ 0x6e, "MISSING/POOR COLORS" },
	{ 0x6f, "BAD CONVERGENCE" },
	{ 0x70, "BLANKING VIDEO" },
	{ 0x71, "FLASHING VIDEO" },
	{ 0x72, "SHADOWING" },
	{ 0x73, "NO SYNC" },
	{ 0x74, "SPOT KILL" },
	{ 0x75, "RIGHTNESS UNIFORMITY" },
	{ 0x76, "DAMAGED FLAT PANEL" },
	{ 0x77, "DEFECTIVE FLAT PANEL" },
	{ 0x78, "DEFECTIVE ON-SCREEN DISPLAY" },
	{ 0x79, "DEFECTIVE AC/DC ADAPTER" },
	{ 0x7a, "DEFECTIVE/DIM BACKLIGHT" },
	{ 0x7b, "PANEL CONTAMINATION" },
	{ 0x7c, "PIXEL CONTAMINATION" },
	{ 0xc8, "BAD CPU/SRAM" },
	{ 0xc9, "SRAM PURGE FAIL" },
	{ 0xca, "E10K R-CORE FAILURE" },
	{ 0xcb, "PLASTIC CPU" },
	{ 0xcc, "MOUSE FAILURE" },
	{ 0xcd, "SYSTEM PANIC/TRAP ERROR" },
	{ 0xce, "FAILS A.T.E." },
	{ 0xcf, "TOD FAILURE" },
	{ 0xd0, "MEMORY FAILURE/ERROR" },
	{ 0xd1, "KEYBOARD FAILURE" },
	{ 0xd2, "DEFECTIVE SERIAL PORT" },
	{ 0xd3, "WATCHDOG RESET/TIMEOUT" },
	{ 0xd4, "WILL NOT SEE OTHER BOARDS" },
	{ 0xd5, "E-CACHE PARITY ERROR" },
	{ 0xd6, "PARITY ERROR (MEMORY)" },
	{ 0xd7, "DEFECTIVE PARALLEL PORT" },
	{ 0xd8, "ARB-STOP" },
	{ 0xd9, "GRANT PARITY ERROR" },
	{ 0xda, "HANGS (LOCK-UP)" },
	{ 0xdb, "POWER-ON SEQUENCE FAILURE" },
	{ 0xdc, "PARITY ERROR-PSI BUS" },
	{ 0xdd, "POWER STAT" },
	{ 0xde, "GRANT TIME-OUT" },
	{ 0xdf, "PARITY ERROR R-BUS" },
	{ 0xe0, "RECORD STOP" },
	{ 0xe1, "PLL ERROR" },
	{ 0xe2, "DTAG PARITY ERROR" },
	{ 0xe3, "INTERCONNECT TEST FAILURE" },
	{ 0xe4, "DATA BUS INTEGRITY ERROR" },
	{ 0x12c, "WILL NOT FORMAT" },
	{ 0x12d, "MISSING DEFECT LIST" },
	{ 0x12e, "EXCESSIVE DEFECTS" },
	{ 0x12f, "DRIVE FAULTS" },
	{ 0x130, "SEEK ERRORS" },
	{ 0x131, "READ/WRITE ERRORS" },
	{ 0x132, "WILL NOT SPIN UP" },
	{ 0x133, "EXCESSIVE SOFT ERRORS" },
	{ 0x134, "HARD-UNRECOVERABLE ECC-ERR" },
	{ 0x135, "WILL NOT COME READY" },
	{ 0x136, "MISSING (SOFT) LABEL" },
	{ 0x137, "DEFECTIVE BLOCKS" },
	{ 0x138, "PRINTER JAMS" },
	{ 0x139, "POOR PRINT QUALITY" },
	{ 0x13a, "WILL NOT EJECT MEDIA" },
	{ 0x13b, "WILL NOT LOAD MEDIA" },
	{ 0x13c, "ROBOTICS MECHANICAL FAILURE" },
	{ 0x190, "BATTERY VOLTAGE" },
	{ 0x191, "CONTROL VOLTAGE PROBLEM" },
	{ 0x192, "ENERGY OUTPUT PROBLEM" },
	{ 0x193, "FAILS CURRENT SHARE" },
	{ 0x194, "HIPOT/GND CONTINUITY PROBLEM" },
	{ 0x195, "REGULATION PROBLEM" },
	{ 0x196, "OUTPUT VOLTAGE PROBLEM" },
	{ 0x197, "IN_OUT VOLTAGE PROBLEM" },
	{ 0x198, "NTF - No Trouble Found" },
	{ 0x199, "Below Rev/Dash/MAL-Part is below acceptablelevelforuse" },
	{ 0x19a, "ESD Packaging Compromised/Damaged" },
	{ 0x19b, "Damaged i.e. Connector, physical, etc." },
	{ 0x19c, "Power Problem (i.e. No power, intermittant power, etc.)" },
	{ 0x19d, "SCSI Error Reported" },
	{ 0x19e, "Noisy - Audible duetomechanical orelectronicmalfunction" },
	{ 0x19f, "Fails Self Test" },
	{ 0x1a0, "Extended Assys Faulty (ie. Robotic Arm, etc." },
	{ 0x1a1, "Fails SUNVTS" },
	{ 0x1a2, "* Ethernet Error Reported" },
	{ 0x1a3, "Fails POST" },
	{ 0x1a4, "Dirty - Received dirty" },
	{ 0x1a5, "Fan Failure" },
	{ 0x1a6, "Non-Sun Unit - NonSununit sentback forrepair eitherwithin" },
	{ 0x1a7, "Excess Scrap" },
	{ 0x1a8, "Not Tested - Used when forwarding to OEM for Repair" },
	{ 0x1a9, "Video problems" },
	{ 0x1aa, "Unstable display" },
	{ 0x1ab, "Dim Screen" },
	{ 0x1ac, "Poor color" },
	{ 0x1ad, "Poor focus" },
	{ 0x1ae, "Poor Convergence" },
	{ 0x1af, "Sync Problem" },
	{ 0x1b0, "Uncorrectable Memory Error during POST" },
	{ 0x1b1, "Caused System Panic" },
	{ 0x1b2, "NVRAM Problem" },
	{ 0x1b3, "Uncorrectable DIMM Error - MainMemory DIMMisuncorrectable" },
	{ 0x1b4, "Watchdog Reset" },
	{ 0x1b5, "Cache Error*Must specify type of cacheerrorin commentssect" },
	{ 0x1b6, "Domainstop/Recordstop Failure     Limited tocertaintypesof" },
	{ 0x1b7, "Causes System Hang" },
	{ 0x1b8, "Fails Format" },
	{ 0x1b9, "Missing Defect List" },
	{ 0x1ba, "Increasing Defect List" },
	{ 0x1bb, "Seek Errors" },
	{ 0x1bc, "Read/Write Errors" },
	{ 0x1bd, "No Spin Up" },
	{ 0x1be, "Excessive Retry Errors" },
	{ 0x1bf, "Jamming" },
	{ 0x1c0, "Print Quality" },
	{ 0x1c1, "No Eject" },
	{ 0x1c2, "Media Not Recognized" },
	{ 0x1c3, "Battery Failure" },
	{ 0x1c4, "Low/High voltage output" },
	{ 0x1c5, "No voltage output" },
	{ 0x1c6, "Fails Current Share" },
	{ 0x1c7, "Hipot/Gnd Continuity Problem" },
	{ 0x1c8, "FCO - Part Pulled/Return due to Field Change Order" },
	{ 0x1c9, "Thermal Event/Smoke occurred" },
	{ 0x1ca, "Non-Functional LED" },
	{ 0x1cb, "Fault LED ?ON? with no other fault symptom" },
	{ 0x1cc, "Temperature sensitive related fault" },
	{ 0x1cd, "Cannot access" },
	{ 0x1ce, "Hangs the system" },
	{ 0x1cf, "Caused Data Corruption" },
	{ 0x1d0, "Leader Kit Loose/Broken" },
	{ 0x1d1, "Bad Track/Bad Sector" },
	{ 0x1d2, "Fatal Reset" },
	{ 0x1d3, "Cannot Mount" },
	{ 0x1d4, "Failure Prediction Threshold Exceeded" },
	{ 0x1d5, "G-List Exceeded" },
	{ 0x1d6, "Fails DEX * Mustspecify whattestfailedin commentssection" },
	{ 0x1d7, "Downlevel/Bad Firmware" },
	{ 0x1d8, "Bad Firmware (i.e. Corrupted, missing, etc.)" },
	{ 0x1d9, "Blown Fuse" },
	{ 0x1da, "Cannot be loaded" },
	{ 0x1db, "Excessive Soft Errors" },
	{ 0x1dc, "Not seen by system" },
	{ 0x1dd, "Termination Problem" },
	{ 0x1de, "Defective Cable" },
	{ 0x1df, "CPU Panic - CPU caused panic (includes Bad Traps)" },
	{ 0x1e0, "I/O Errors" },
	{ 0x1e1, "Safari Port Errors - Limited to certain types of systems" },
	{ 0x1e2, "SC Error Messages - Limited to certain types of systems" },
	{ 0x1e3, "Data Corruption - unexpected data results" },
	{ 0x1e4, "Correctable Memory Error during POST" },
	{ 0x1e5, "Correctable Memory Error during VTS" },
	{ 0x1e6, "Uncorrectable Memory Error during VTS" },
	{ 0x1e7, "Uncorrectable memory error beyond POST or VTS" },
	{ 0x1e8, "Correctable mem.errorsexceedingthresholdwithretirialpageon" },
	{ 0x1e9, "Correctable mem.errorexceedingthresholdwithretirialpage" },
	{ 0x1ea, "Fiber Channel Link Problem" },
	{ 0x1eb, "Fails Obdiag" },
	{ 0x1ec, "Video output  problems" },
	{ 0x1ed, "Termination Problem - Bad or wrong terminator" },
	{ 0x1ee, "Red State Exception" },
	{ 0x1ef, "Battery age replacement" },
	{ 0x1f0, "Burnout" },
	{ 0x1f1, "Blank screen" },
	{ 0x1f2, "Arching" },
	{ 0x1f3, "Screen burnt" },
	{ 0x1f4, "Downlevel Firmware" }
};

fru_enum_t Initiator_30[] = {
	{ 0x0, "Not Assigned" },
	{ 0x65, "Depot" },
	{ 0x66, "Field_Eng" },
	{ 0x67, "CTE" },
	{ 0x68, "Customer" },
	{ 0xc9, "SMS" },
	{ 0xca, "SCAPP" },
	{ 0xcb, "POST" },
	{ 0xcc, "OBP" },
	{ 0xcd, "OBDIAG" },
	{ 0xce, "Kernel" },
	{ 0xcf, "Driver" },
	{ 0xd0, "SUNVTS" },
	{ 0xd1, "AFR" },
	{ 0xd2, "COD" },
	{ 0xd3, "Fault Management" },
	{ 0xd4, "ES SP Software" }
};

fru_enum_t Power_Events_50[] = {
	{ 0x1, "power_on" },
	{ 0x2, "still_on" },
	{ 0x3, "power_off" }
};

fru_enum_t Error_Code[] = {
	{ 0x0, "UNKNOWN_SoftError" },
	{ 0x1, "Correctable ECC Errors" },
	{ 0x2, "Uncorrectable ECC Errors" },
	{ 0x3, "Correctable ECC error from E$" },
	{ 0x4, "Uncorrectable ECC error from E$" },
	{ 0x5, "Correctable ECC error from E$ for Write-back" },
	{ 0x6, "Uncorrectable ECC error from E$ for Write-back" },
	{ 0x7, "Copy-Out correctable ECC Error" },
	{ 0x8, "Copy-Out uncorrectble ECC Error" },
	{ 0x9, "Software Handled Correctable E$ Error" },
	{ 0xa, "Software Handled Uncorrectable E$ Error" },
	{ 0xb, "Correctable MTAG ECC Error" },
	{ 0xc, "Uncorrectable MTAG ECC Error" }
};

fru_enum_t Status_Event_Code_71[] = {
	{ 0x0, "UNKNOWN" },
	{ 0x7010008, "FMA Message R" },
	{ 0x7010108, "FMA Event Data R" },
	{ 0xfe000000, "Field Engineer Supplied" },
	{ 0xffff0001, "Excess" },
	{ 0xffff0002, "Obsolete" },
	{ 0xffff0003, "Not Repairable" },
	{ 0xffff0004, "Reliability" },
	{ 0xffff0005, "Economics" }
};

fru_enum_t Boolean_90[] = {
	{ 0x0, "False" },
	{ 0x1, "True" }
};

fru_enum_t SPD_Module_Bank_Density_110[] = {
	{ 0x10, "64MB" },
	{ 0x20, "128MB" },
	{ 0x40, "256MB" },
	{ 0x80, "512MB" },
	{ 0xff, "1GB" }
};

fru_enum_t SPD_Sun_Mod_Power_Parm_111[] = {
	{ 0x18, "2.4W" },
	{ 0x30, "4.8W" },
	{ 0x60, "9.6W" }
};

fru_enum_t SPD_Memory_Type[] = {
	{ 0x1, "Standard FPM DRAM" },
	{ 0x2, "EDO" },
	{ 0x3, "Pipelined Nibble" },
	{ 0x4, "Sync Dram (SDRAM)" },
	{ 0x5, "Multiplexed ROM" },
	{ 0x6, "SGRAM DDR" },
	{ 0x7, "SDRAM DDR" },
	{ 0x8, "DDR II SDRAM" },
	{ 0x9, "FBDIMM" },
	{ 0xb, "DDR3 SDRAM" }
};

fru_enum_t SPD_Err_Detect[] = {
	{ 0x0, "Non-parity" },
	{ 0x1, "Parity" },
	{ 0x2, "ECC" }
};

fru_enum_t Platform_Type[] = {
	{ 0x1, "SunFire12K" },
	{ 0x2, "SunFire15K" },
	{ 0x3, "SunFireE20K" },
	{ 0x4, "SunFireE25K" },
	{ 0x5, "Sun Fire 6800" },
	{ 0x6, "Sun Fire E4900" },
	{ 0x7, "Sun Fire E6900" },
	{ 0x8, "Sun Fire 4800" },
	{ 0x9, "Sun Fire 4810" },
	{ 0xa, "Sun Fire 3800" },
	{ 0xb, "Sun Fire V1280" },
	{ 0xc, "Netra 1280" },
	{ 0xd, "Sun Ultra 25" },
	{ 0xe, "Sun Ultra 45" }
};

fru_enum_t Message_Type[] = {
	{ 0x0, "Undefined" },
	{ 0x1, "Modified FMA message" },
	{ 0x2, "Free form text" },
	{ 0x3, "FMA event data in ascii" },
	{ 0x4, "Temporary_FMA_Data" }
};

fru_enum_t IPMI_LangCode[] = {
	{ 0x0, "English" },
	{ 0x1, "Afar" },
	{ 0x2, "Abkhazian" },
	{ 0x3, "Afrikaans" },
	{ 0x4, "Amharic" },
	{ 0x5, "Arabic" },
	{ 0x6, "Assamese" },
	{ 0x7, "Aymara" },
	{ 0x8, "Azerbaijani" },
	{ 0x9, "Bashkir" },
	{ 0xa, "Byelorussian" },
	{ 0xb, "Bulgarian" },
	{ 0xc, "Bihari" },
	{ 0xd, "Bislama" },
	{ 0xe, "Bengali" },
	{ 0xf, "Tibetan" },
	{ 0x10, "Breton" },
	{ 0x11, "Catalan" },
	{ 0x12, "Corsican" },
	{ 0x13, "Czech" },
	{ 0x14, "Welsh" },
	{ 0x15, "danish" },
	{ 0x16, "german" },
	{ 0x17, "Bhutani" },
	{ 0x18, "Greek" },
	{ 0x19, "english" },
	{ 0x1a, "Esperanto" },
	{ 0x1b, "Spanish" }
};

fru_enum_t Chassis_Name[] = {
	{ 0x1, "Other" },
	{ 0x2, "Unknown" },
	{ 0x3, "Desktop" },
	{ 0x4, "Low Profile Desktop" },
	{ 0x5, "Pizza Box" },
	{ 0x6, "Mini Tower" },
	{ 0x7, "Tower" },
	{ 0x8, "Portable" },
	{ 0x9, "Laptop" },
	{ 0xa, "Notebook" },
	{ 0xb, "Hand Held" },
	{ 0xc, "Docking Station" },
	{ 0xd, "All In One" },
	{ 0xe, "Sub Notebook" },
	{ 0xf, "Space-saving" },
	{ 0x10, "Lunch Box" },
	{ 0x11, "Main Server Chassis" },
	{ 0x12, "Expansion Chassis" },
	{ 0x13, "SubChassis" },
	{ 0x14, "Bus Expansion Chassis" },
	{ 0x15, "Peripheral Chassis" },
	{ 0x16, "RAID Chassis" },
	{ 0x17, "Rack Mount Chassis" }
};

fru_enum_t Vendor_Site_ID_Source_List[] = {
	{ 0x1, "VSID_OracleCS ERP 10.7" }
};

fru_enum_t Vendor_ID_Source_List[] = {
	{ 0x1, "VID_OracleCS ERP 10.7" }
};

fru_enum_t SSN_Rule_List[] = {
	{ 0x1, "Use commodity SN Data" },
	{ 0x2, "WWOPS SE Doc 923-3383" },
	{ 0x3, "Sun SPD JEDEC DIMM Spec" }
};

fru_enum_t Program_Vendor_ID_Source_List[] = {
	{ 0x1, "PVID_OracleCS ERP 10.7" }
};

fru_enum_t Format_Type_List[] = {
	{ 0x1, "Sun FRUID" },
	{ 0x2, "IPMI" },
	{ 0x3, "Mixed Sun/IPMI" },
	{ 0x4, "SPD" },
	{ 0x5, "PCI" },
	{ 0x6, "SCSI" }
};

fru_enum_t Dictionary_Name[] = {
	{ 0x1, "Test" }
};

fru_enum_t FRU_Shortnames[] = {
	{ 0x1, "PSU" },
	{ 0x2, "BP" },
	{ 0x3, "CPUM" },
	{ 0x4, "DISK" },
	{ 0x5, "ETH" },
	{ 0x6, "FIBRE" },
	{ 0x7, "GRAPX" },
	{ 0x8, "IO" },
	{ 0x9, "DIMM" },
	{ 0xa, "SIMM" },
	{ 0xb, "ECACHE" },
	{ 0xc, "PS" },
	{ 0xd, "RACK" },
	{ 0xe, "SWITCH" },
	{ 0xf, "SB" },
	{ 0x10, "CP" }
};


fru_enum_t ManR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Fru_Description" },
	{ 2, "Manufacture_Loc" },
	{ 3, "Sun_Part_No" },
	{ 4, "Sun_Serial_No" },
	{ 5, "Vendor_Name" },
	{ 6, "Initial_HW_Dash_Level" },
	{ 7, "Initial_HW_Rev_Level" },
	{ 8, "Fru_Shortname" }
};

fru_enum_t UsageR[] = {
	{ 0, "Number_of_Updates" },
	{ 1, "Last_Power_On" },
	{ 2, "Total_Errors" },
	{ 3, "Total_Inserts" },
	{ 4, "Total_Power_Ons_old" },
	{ 5, "Total_Time_On" }
};

fru_enum_t HW_Data_R[] = {
	{ 0, "HW_Dash_Level" },
	{ 1, "Hardware_Revision" }
};

fru_enum_t SG_CenterplaneR[] = {
	{ 0, "Board_Speed" },
	{ 1, "DomainAEthernetAddr" },
	{ 2, "DomainBEthernetAddr" },
	{ 3, "DomainCEthernetAddr" },
	{ 4, "DomainDEthernetAddr" },
	{ 5, "MasterSCEthernetAddr" },
	{ 6, "SlaveSCEthernetAddr" }
};

fru_enum_t SG_BoardParameterR[] = {
	{ 0, "Board_Speed" },
	{ 1, "SG_Bootbus_Timing" }
};

fru_enum_t L2_BoardR[] = {
	{ 0, "Board_Speed" }
};

fru_enum_t SP_FanTrayR[] = {
	{ 0, "Fan_Pair_Mask" },
	{ 1, "Fan_Startup_Delay" },
	{ 2, "Fan_Present_Mask" }
};

fru_enum_t ExcalCPUR[] = {
	{ 0, "Cache_Size" },
	{ 1, "CPU_Max_Safari_Speed" },
	{ 2, "CPU_Speed" },
	{ 3, "CPU_Type" },
	{ 4, "Ecache_Module_IDR" },
	{ 5, "SRAM_Manufacturer" },
	{ 6, "SRAM_Speed" }
};

fru_enum_t ExcalUsageR[] = {
	{ 0, "HoursAtHalfSpeed" },
	{ 1, "HoursAtOne32ndSpeed" },
	{ 2, "HoursAtFullSpeed" }
};

fru_enum_t Dak_MotherboardR[] = {
	{ 0, "PROM_Format_Version" },
	{ 1, "Device_Type" },
	{ 2, "Min_Bus_Speed" },
	{ 3, "Max_Bus_Speed" },
	{ 4, "Num_CPU_Module_Slots" },
	{ 5, "Ambient_Temp_Array" },
	{ 6, "Bootbus_Timing" },
	{ 7, "JTAG_Info_Pointer" },
	{ 8, "Min_Power_Rating" },
	{ 9, "Max_Power_Rating" },
	{ 10, "StickClock" },
	{ 11, "Junction_Temp_Array" },
	{ 12, "Reserved_24" }
};

fru_enum_t Dak_DualCPUModuleR[] = {
	{ 0, "PROM_Format_Version" },
	{ 1, "Device_Type" },
	{ 2, "Num_CPUs_in_Module" },
	{ 3, "Ambient_Temp_Array" },
	{ 4, "Junction_Temp_Array" },
	{ 5, "Cache_Size" },
	{ 6, "Cache_Timing" },
	{ 7, "Ecache_Features" },
	{ 8, "CPU_Speed" },
	{ 9, "Min_Bus_Speed" },
	{ 10, "Max_Bus_Speed" },
	{ 11, "JTAG_Info_Pointer" },
	{ 12, "Min_Power_Rating" },
	{ 13, "Max_Power_Rating" },
	{ 14, "CPU0_Features" },
	{ 15, "CPU1_Features" },
	{ 16, "CPU0_DIMMBank0_Map" },
	{ 17, "CPU0_DIMMBank1_Map" },
	{ 18, "CPU1_DIMMBank0_Map" },
	{ 19, "CPU1_DIMMBank1_Map" },
	{ 20, "Reserved" }
};

fru_enum_t Dak_RSCR[] = {
	{ 0, "PROM_Format_Version" },
	{ 1, "Device_Type" },
	{ 2, "Ethernet_Addr" },
	{ 3, "Ambient_Temp_Array" },
	{ 4, "Memory_Size" },
	{ 5, "Min_Power_Rating" },
	{ 6, "Max_Power_Rating" }
};

fru_enum_t Dak_IOBoardR[] = {
	{ 0, "PROM_Format_Version" },
	{ 1, "Device_Type" },
	{ 2, "Ambient_Temp_Array" },
	{ 3, "Min_Power_Rating" },
	{ 4, "Max_Power_Rating" }
};

fru_enum_t Dak_DBPR[] = {
	{ 0, "PROM_Format_Version" },
	{ 1, "Device_Type" },
	{ 2, "Ambient_Temp_Array" },
	{ 3, "WWN" },
	{ 4, "Min_Power_Rating" },
	{ 5, "Max_Power_Rating" },
	{ 6, "Max_Power_Distribution" }
};

fru_enum_t Dak_PDBR[] = {
	{ 0, "PROM_Format_Version" },
	{ 1, "Device_Type" },
	{ 2, "Ambient_Temp_Array" },
	{ 3, "Voltage_Rails" },
	{ 4, "Min_Power_Rating" },
	{ 5, "Max_Power_Rating" },
	{ 6, "Max_Power_Distribution" }
};

fru_enum_t Dak_PowersupplyR[] = {
	{ 0, "PROM_Format_Version" },
	{ 1, "Device_Type" },
	{ 2, "Max_Power_Distribution" }
};

fru_enum_t Dak_FCAL_GBICR[] = {
	{ 0, "PROM_Format_Version" },
	{ 1, "Device_Type" }
};

fru_enum_t Ecache_Module_IDR[] = {
	{ 0, "Lot_Code" },
	{ 1, "Date_Code" }
};

fru_enum_t EcacheR[] = {
	{ 0, "SRAM_Speed" },
	{ 1, "SRAM_Size" }
};

fru_enum_t DIMM_R[] = {
	{ 0, "DIMM_Speed" },
	{ 1, "DIMM_Size" }
};

fru_enum_t CPUBoardSpeedR[] = {
	{ 0, "CPU0_Speed" },
	{ 1, "CPU1_Speed" },
	{ 2, "CPU2_Speed" },
	{ 3, "CPU3_Speed" }
};

fru_enum_t SG_CPUSpeedR[] = {
	{ 0, "CPU0_SerialNum" },
	{ 1, "CPU0_Speed" },
	{ 2, "CPU1_SerialNum" },
	{ 3, "CPU1_Speed" },
	{ 4, "CPU2_SerialNum" },
	{ 5, "CPU2_Speed" },
	{ 6, "CPU3_SerialNum" },
	{ 7, "CPU3_Speed" }
};

fru_enum_t ExcalMotherboardR[] = {
	{ 0, "Ethernet_Addr" }
};

fru_enum_t Repair_DetailR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Repair_Vendor" },
	{ 2, "Repair_Location" },
	{ 3, "Case_Number" },
	{ 4, "Fault_Detail" },
	{ 5, "Dash_Number_In" },
	{ 6, "Dash_Number_Out" },
	{ 7, "Symptom_Code" },
	{ 8, "Cause_Code" },
	{ 9, "Components_Replaced" }
};

fru_enum_t Repair_Update[] = {
	{ 0, "HW_Dash_Level" },
	{ 1, "Hardware_Revision" },
	{ 2, "Firmware_Revision" },
	{ 3, "Total_Returns" },
	{ 4, "Total_Repairs" }
};

fru_enum_t Lit_DBPR[] = {
	{ 0, "PROM_Format_Version" },
	{ 1, "Device_Type" },
	{ 2, "Ambient_Temp_Array" },
	{ 3, "WWN" },
	{ 4, "Min_Power_Rating" },
	{ 5, "Max_Power_Rating" }
};

fru_enum_t DIMM_Conf_R[] = {
	{ 0, "SPD_Version" },
	{ 1, "Fru_Type" }
};

fru_enum_t InstallationR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Fru_Path" },
	{ 2, "Parent_Part_Number" },
	{ 3, "Parent_Serial_Number" },
	{ 4, "Parent_Dash_Level" },
	{ 5, "System_Id" },
	{ 6, "System_Tz" },
	{ 7, "Geo_North" },
	{ 8, "Geo_East" },
	{ 9, "Geo_Alt" },
	{ 10, "Geo_Location" }
};

fru_enum_t Power_EventsR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Event" }
};

fru_enum_t Power_SummaryR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Total_Time_On" },
	{ 2, "Total_Power_Ons" },
	{ 3, "Total_Power_Offs" }
};

fru_enum_t Temperature_HistoryR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Sensor" },
	{ 2, "Lowest" },
	{ 3, "Highest" },
	{ 4, "Latest" },
	{ 5, "Histogram" }
};

fru_enum_t Status_CurrentR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Status" }
};

fru_enum_t Status_EventsR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Old_Status" },
	{ 2, "New_Status" },
	{ 3, "Initiator" },
	{ 4, "Component" },
	{ 5, "Event_Code" },
	{ 6, "Message" }
};

fru_enum_t Soft_ErrorsR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Component" },
	{ 2, "Softerror_Code" },
	{ 3, "Syndrome" }
};

fru_enum_t ECO_CurrentR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Firmware_Revision" },
	{ 2, "Hardware_Revision" },
	{ 3, "HW_Dash_Level" }
};

fru_enum_t Customer_DataR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Cust_Data" }
};

fru_enum_t MD_Bottom_IO_FanTrayR[] = {
	{ 0, "Fan_Pair_Mask" },
	{ 1, "Fan_Startup_Delay" },
	{ 2, "Fan_Present_Mask" }
};

fru_enum_t MD_CPU_Three_FanTrayR[] = {
	{ 0, "Fan_Pair_Mask" },
	{ 1, "Fan_Startup_Delay" },
	{ 2, "Fan_Present_Mask" }
};

fru_enum_t ME_Three_FanTrayR[] = {
	{ 0, "Fan_Pair_Mask" },
	{ 1, "Fan_Startup_Delay" },
	{ 2, "Fan_Present_Mask" }
};

fru_enum_t DS_CPU_Six_FanTrayR[] = {
	{ 0, "Fan_Pair_Mask" },
	{ 1, "Fan_Startup_Delay" },
	{ 2, "Fan_Present_Mask" }
};

fru_enum_t DS_IO_Four_FanTrayR[] = {
	{ 0, "Fan_Pair_Mask" },
	{ 1, "Fan_Startup_Delay" },
	{ 2, "Fan_Present_Mask" }
};

fru_enum_t MD_Top_FanTrayR[] = {
	{ 0, "Fan_Pair_Mask" },
	{ 1, "Fan_Startup_Delay" },
	{ 2, "Fan_Present_Mask" }
};

fru_enum_t Repair_SummaryR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Total_Returns" },
	{ 2, "Total_Repairs" }
};

fru_enum_t Dak_DBPNameR[] = {
	{ 0, "Loop_A_Name" },
	{ 1, "Loop_B_Name" }
};

fru_enum_t Sheffield_RCP_FirmwareR[] = {
	{ 0, "Sun_Part_No" },
	{ 1, "HW_Dash_Level" }
};

fru_enum_t PROM_FirmwareR[] = {
	{ 0, "Sun_Part_No" },
	{ 1, "HW_Dash_Level" }
};

fru_enum_t Sheffield_Bridge_FirmwareR[] = {
	{ 0, "Sun_Part_No" },
	{ 1, "HW_Dash_Level" }
};

fru_enum_t Temperature_LimitsR[] = {
	{ 0, "Lowest_Temp_Limit" },
	{ 1, "Highest_Temp_Limit" }
};

fru_enum_t Error_SummaryR[] = {
	{ 0, "Hard_Errors" },
	{ 1, "Soft_Errors" }
};

fru_enum_t Temperature_ExcessR[] = {
	{ 0, "Time_Below" },
	{ 1, "Time_Above" }
};

fru_enum_t CPUR[] = {
	{ 0, "Num_CPUs_in_Module" },
	{ 1, "CPU_Speed" },
	{ 2, "Cache_Size" },
	{ 3, "RAM" }
};

fru_enum_t SG_FanTrayR[] = {
	{ 0, "Fan_Present_Mask" },
	{ 1, "Fan_Pair_Mask" },
	{ 2, "Fan_Startup_Delay" }
};

fru_enum_t SG_PowerSupplyR[] = {
	{ 0, "AMB_Warning_Level" },
	{ 1, "AMB_Shutdown_Level" },
	{ 2, "V1_CUR_Warning_Low_Line" },
	{ 3, "V1_CUR_Warning_High_Line" },
	{ 4, "V1_CUR_Shutdown_Low_Line" },
	{ 5, "V1_CUR_Shutdown_High_Line" },
	{ 6, "V1_VLT_Under_Warning" },
	{ 7, "V1_VLT_Under_Shutdown" },
	{ 8, "V1_VLT_Over_Warning" },
	{ 9, "V1_VLT_Over_Shutdown" },
	{ 10, "V1_Power_Rating_Low_Line" },
	{ 11, "V1_Power_Rating_High_Line" }
};

fru_enum_t Sheffield_Split_ModeR[] = {
	{ 0, "Sheffield_Split_Mode_Flags" },
	{ 1, "HostID0" },
	{ 2, "HostID1" },
	{ 3, "Sheffield_Fixed_Hardware" },
	{ 4, "Sheffield_SideA_Hardware" },
	{ 5, "Sheffield_SideB_Hardware" }
};

fru_enum_t SG_HostIdR[] = {
	{ 0, "SG_HostId_A" },
	{ 1, "SG_HostId_B" },
	{ 2, "SG_HostId_C" },
	{ 3, "SG_HostId_D" },
	{ 4, "SG_HostId_SC0" },
	{ 5, "SG_HostId_SC1" }
};

fru_enum_t WCI_CalibrationR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "WCI_A_Rcalibrated" },
	{ 2, "WCI_B_Rcalibrated" },
	{ 3, "WCI_Tcalibrated" }
};

fru_enum_t Wildcat_IO_DIMM_Lot[] = {
	{ 0, "Lot_Code" }
};

fru_enum_t Cum_Power_SummaryR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Total_Time_On" },
	{ 2, "Total_Power_Ons" },
	{ 3, "Total_Power_Offs" }
};

fru_enum_t Cum_Temperature_HistoryR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Sensor" },
	{ 2, "Lowest" },
	{ 3, "Highest" },
	{ 4, "Latest" },
	{ 5, "Histogram" }
};

fru_enum_t Configured_LevelR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Sun_Part_No" },
	{ 2, "Configured_Serial_No" },
	{ 3, "HW_Dash_Level" }
};

fru_enum_t SPD_ParametersR[] = {
	{ 0, "SPD_Bytes_Written_SPDMemory" },
	{ 1, "SPD_TotBytes_SPDMemory" },
	{ 2, "SPD_Fund_Memory_Type" },
	{ 3, "SPD_Row_Address_Bits" },
	{ 4, "SPD_Column_Address_Bits" },
	{ 5, "SPD_No_Banks_Assembly" },
	{ 6, "SPD_Data_Width_Module" },
	{ 7, "SPD_Mod_Data_Width" },
	{ 8, "SPD_Mod_Voltage_Interface" },
	{ 9, "SPD_Cycle_Time" },
	{ 10, "SPD_Access_Time" },
	{ 11, "SPD_Module_Config_Type" },
	{ 12, "SPD_Refresh_RateType" },
	{ 13, "SPD_Primary_SDRAM_Width" },
	{ 14, "SPD_Error_Check_SDRAM_Width" },
	{ 15, "SPD_Min_Clock_Delay" },
	{ 16, "SPD_Burst_Length_Support" },
	{ 17, "SPD_No_Banks_SDRAM_Device" },
	{ 18, "SPD_Device_Attrib_CAS" },
	{ 19, "SPD_Device_Attrib_CS" },
	{ 20, "SPD_Device_Attrib_Write" },
	{ 21, "SPD_Module_Attrib" },
	{ 22, "SPD_Device_Attrib_Gen" },
	{ 23, "SPD_Min_Cycle_Time_CL2tCC2" },
	{ 24, "SPD_Max_Access_Time_CL2tSAC2" },
	{ 25, "SPD_Min_Cycle_Time_CL1tCC1" },
	{ 26, "SPD_Max_Access_Time_CL1tSAC1" },
	{ 27, "SPD_Min_Row_Precharge_Time" },
	{ 28, "SPD_Min_Row_Delay" },
	{ 29, "SPD_Min_RAS_To_CAS_Delay" },
	{ 30, "SPD_Min_Ras_Pulse_Width" },
	{ 31, "SPD_Module_Bank_Density" },
	{ 32, "SPD_Sig_Input_Setup_Time" },
	{ 33, "SPD_Sig_Input_Hold_Time" },
	{ 34, "SPD_Data_Sig_Input_Setup_Time" },
	{ 35, "SPD_Data_Sig_Input_Hold_Time" },
	{ 36, "SPD_Sun_Copyright" },
	{ 37, "Spare_7bytes" },
	{ 38, "SPD_Data_Edition_Code" },
	{ 39, "SPD_TSHZ_Max_Nbrs_CAS_Lat" },
	{ 40, "SPD_TSLZ_CLK_To_Output" },
	{ 41, "SPD_Data_Revision_Code" },
	{ 42, "Checksum_8" },
	{ 43, "SPD_Old_Man_Code" },
	{ 44, "SPD_Old_Man_Loc" },
	{ 45, "SPD_Manufacturer_Part_No" },
	{ 46, "SPD_Man_Rev_Code_Pcb" },
	{ 47, "SPD_Man_Rev_Code_Comp" },
	{ 48, "SPD_Manufacture_Date_Week" },
	{ 49, "SPD_Manufacture_Date_Year" },
	{ 50, "SPD_Old_Assembly_Serial_No" },
	{ 51, "SPD_Old_Sun_Part_No" },
	{ 52, "SPD_Sun_Module_Power_Parm" },
	{ 53, "SPD_Sun_Mod_Power_Parm_2" },
	{ 54, "SPD_Sun_Mod_Cycle_Time" },
	{ 55, "SPD_Sun_Mod_Cycle_Time_TOH" },
	{ 56, "SPD_Old_Sun_Module_Label_Info" },
	{ 57, "SPD_Mode_Register_Data_1" },
	{ 58, "SPD_Mode_Register_Data_2" },
	{ 59, "Spare_8bytes" },
	{ 60, "SPD_Module_Freq" },
	{ 61, "SPD_CAS_Latencies" },
	{ 62, "SPD_Edge_Connect_Sig_Dq0" },
	{ 63, "SPD_Edge_Connect_Sig_Dq1" },
	{ 64, "SPD_Edge_Connect_Sig_Dq2" },
	{ 65, "SPD_Edge_Connect_Sig_Dq3" },
	{ 66, "SPD_Edge_Connect_Sig_Dq4" },
	{ 67, "SPD_Edge_Connect_Sig_Dq5" },
	{ 68, "SPD_Edge_Connect_Sig_Dq6" },
	{ 69, "SPD_Edge_Connect_Sig_Dq7" },
	{ 70, "SPD_Edge_Connect_Sig_Dq8" },
	{ 71, "SPD_Edge_Connect_Sig_Dq9" },
	{ 72, "SPD_Edge_Connect_Sig_Dq10" },
	{ 73, "SPD_Edge_Connect_Sig_Dq11" },
	{ 74, "SPD_Edge_Connect_Sig_Dq12" },
	{ 75, "SPD_Edge_Connect_Sig_Dq13" },
	{ 76, "SPD_Edge_Connect_Sig_Dq14" },
	{ 77, "SPD_Edge_Connect_Sig_Dq15" },
	{ 78, "SPD_Edge_Connect_Sig_Dq16" },
	{ 79, "SPD_Edge_Connect_Sig_Dq17" },
	{ 80, "SPD_Edge_Connect_Sig_Dq18" },
	{ 81, "SPD_Edge_Connect_Sig_Dq19" },
	{ 82, "SPD_Edge_Connect_Sig_Dq20" },
	{ 83, "SPD_Edge_Connect_Sig_Dq21" },
	{ 84, "SPD_Edge_Connect_Sig_Dq22" },
	{ 85, "SPD_Edge_Connect_Sig_Dq23" },
	{ 86, "SPD_Edge_Connect_Sig_Dq24" },
	{ 87, "SPD_Edge_Connect_Sig_Dq25" },
	{ 88, "SPD_Edge_Connect_Sig_Dq26" },
	{ 89, "SPD_Edge_Connect_Sig_Dq27" },
	{ 90, "SPD_Edge_Connect_Sig_Dq28" },
	{ 91, "SPD_Edge_Connect_Sig_Dq29" },
	{ 92, "SPD_Edge_Connect_Sig_Dq30" },
	{ 93, "SPD_Edge_Connect_Sig_Dq31" },
	{ 94, "SPD_Edge_Connect_Sig_Dq32" },
	{ 95, "SPD_Edge_Connect_Sig_Dq33" },
	{ 96, "SPD_Edge_Connect_Sig_Dq34" },
	{ 97, "SPD_Edge_Connect_Sig_Dq35" },
	{ 98, "SPD_Edge_Connect_Sig_Dq36" },
	{ 99, "SPD_Edge_Connect_Sig_Dq37" },
	{ 100, "SPD_Edge_Connect_Sig_Dq38" },
	{ 101, "SPD_Edge_Connect_Sig_Dq39" },
	{ 102, "SPD_Edge_Connect_Sig_Dq40" },
	{ 103, "SPD_Edge_Connect_Sig_Dq41" },
	{ 104, "SPD_Edge_Connect_Sig_Dq42" },
	{ 105, "SPD_Edge_Connect_Sig_Dq43" },
	{ 106, "SPD_Edge_Connect_Sig_Dq44" },
	{ 107, "SPD_Edge_Connect_Sig_Dq45" },
	{ 108, "SPD_Edge_Connect_Sig_Dq46" },
	{ 109, "SPD_Edge_Connect_Sig_Dq47" },
	{ 110, "SPD_Edge_Connect_Sig_Dq48" },
	{ 111, "SPD_Edge_Connect_Sig_Dq49" },
	{ 112, "SPD_Edge_Connect_Sig_Dq50" },
	{ 113, "SPD_Edge_Connect_Sig_Dq51" },
	{ 114, "SPD_Edge_Connect_Sig_Dq52" },
	{ 115, "SPD_Edge_Connect_Sig_Dq53" },
	{ 116, "SPD_Edge_Connect_Sig_Dq54" },
	{ 117, "SPD_Edge_Connect_Sig_Dq55" },
	{ 118, "SPD_Edge_Connect_Sig_Dq56" },
	{ 119, "SPD_Edge_Connect_Sig_Dq57" },
	{ 120, "SPD_Edge_Connect_Sig_Dq58" },
	{ 121, "SPD_Edge_Connect_Sig_Dq59" },
	{ 122, "SPD_Edge_Connect_Sig_Dq60" },
	{ 123, "SPD_Edge_Connect_Sig_Dq61" },
	{ 124, "SPD_Edge_Connect_Sig_Dq62" },
	{ 125, "SPD_Edge_Connect_Sig_Dq63" },
	{ 126, "SPD_Edge_Connect_Sig_Dq64" },
	{ 127, "SPD_Edge_Connect_Sig_Dq65" },
	{ 128, "SPD_Edge_Connect_Sig_Dq66" },
	{ 129, "SPD_Edge_Connect_Sig_Dq67" },
	{ 130, "SPD_Edge_Connect_Sig_Dq68" },
	{ 131, "SPD_Edge_Connect_Sig_Dq69" },
	{ 132, "SPD_Edge_Connect_Sig_Dq70" },
	{ 133, "SPD_Edge_Connect_Sig_Dq71" },
	{ 134, "SPD_Edge_Connect_Sig_Dq72" },
	{ 135, "SPD_Edge_Connect_Sig_Dq73" },
	{ 136, "SPD_Edge_Connect_Sig_Dq74" },
	{ 137, "SPD_Edge_Connect_Sig_Dq75" },
	{ 138, "SPD_Edge_Connect_Sig_Dq76" },
	{ 139, "SPD_Edge_Connect_Sig_Dq77" },
	{ 140, "SPD_Edge_Connect_Sig_Dq78" },
	{ 141, "SPD_Edge_Connect_Sig_Dq79" },
	{ 142, "SPD_Edge_Connect_Sig_Dq80" },
	{ 143, "SPD_Edge_Connect_Sig_Dq81" },
	{ 144, "SPD_Edge_Connect_Sig_Dq82" },
	{ 145, "SPD_Edge_Connect_Sig_Dq83" },
	{ 146, "SPD_Edge_Connect_Sig_Dq84" },
	{ 147, "SPD_Edge_Connect_Sig_Dq85" },
	{ 148, "SPD_Edge_Connect_Sig_Dq86" },
	{ 149, "SPD_Edge_Connect_Sig_Dq87" },
	{ 150, "SPD_Edge_Connect_Sig_Dq88" },
	{ 151, "SPD_Edge_Connect_Sig_Dq89" },
	{ 152, "SPD_Edge_Connect_Sig_Dq90" },
	{ 153, "SPD_Edge_Connect_Sig_Dq91" },
	{ 154, "SPD_Edge_Connect_Sig_Dq92" },
	{ 155, "SPD_Edge_Connect_Sig_Dq93" },
	{ 156, "SPD_Edge_Connect_Sig_Dq94" },
	{ 157, "SPD_Edge_Connect_Sig_Dq95" },
	{ 158, "SPD_Edge_Connect_Sig_Dq96" },
	{ 159, "SPD_Edge_Connect_Sig_Dq97" },
	{ 160, "SPD_Edge_Connect_Sig_Dq98" },
	{ 161, "SPD_Edge_Connect_Sig_Dq99" },
	{ 162, "SPD_Edge_Connect_Sig_Dq100" },
	{ 163, "SPD_Edge_Connect_Sig_Dq101" },
	{ 164, "SPD_Edge_Connect_Sig_Dq102" },
	{ 165, "SPD_Edge_Connect_Sig_Dq103" },
	{ 166, "SPD_Edge_Connect_Sig_Dq104" },
	{ 167, "SPD_Edge_Connect_Sig_Dq105" },
	{ 168, "SPD_Edge_Connect_Sig_Dq106" },
	{ 169, "SPD_Edge_Connect_Sig_Dq107" },
	{ 170, "SPD_Edge_Connect_Sig_Dq108" },
	{ 171, "SPD_Edge_Connect_Sig_Dq109" },
	{ 172, "SPD_Edge_Connect_Sig_Dq110" },
	{ 173, "SPD_Edge_Connect_Sig_Dq111" },
	{ 174, "SPD_Edge_Connect_Sig_Dq112" },
	{ 175, "SPD_Edge_Connect_Sig_Dq113" },
	{ 176, "SPD_Edge_Connect_Sig_Dq114" },
	{ 177, "SPD_Edge_Connect_Sig_Dq115" },
	{ 178, "SPD_Edge_Connect_Sig_Dq116" },
	{ 179, "SPD_Edge_Connect_Sig_Dq117" },
	{ 180, "SPD_Edge_Connect_Sig_Dq118" },
	{ 181, "SPD_Edge_Connect_Sig_Dq119" },
	{ 182, "SPD_Edge_Connect_Sig_Dq120" },
	{ 183, "SPD_Edge_Connect_Sig_Dq121" },
	{ 184, "SPD_Edge_Connect_Sig_Dq122" },
	{ 185, "SPD_Edge_Connect_Sig_Dq123" },
	{ 186, "SPD_Edge_Connect_Sig_Dq124" },
	{ 187, "SPD_Edge_Connect_Sig_Dq125" },
	{ 188, "SPD_Edge_Connect_Sig_Dq126" },
	{ 189, "SPD_Edge_Connect_Sig_Dq127" },
	{ 190, "SPD_Edge_Connect_Sig_Dq128" },
	{ 191, "SPD_Edge_Connect_Sig_Dq129" },
	{ 192, "SPD_Edge_Connect_Sig_Dq130" },
	{ 193, "SPD_Edge_Connect_Sig_Dq131" },
	{ 194, "SPD_Edge_Connect_Sig_Dq132" },
	{ 195, "SPD_Edge_Connect_Sig_Dq133" },
	{ 196, "SPD_Edge_Connect_Sig_Dq134" },
	{ 197, "SPD_Edge_Connect_Sig_Dq135" },
	{ 198, "SPD_Edge_Connect_Sig_Dq136" },
	{ 199, "SPD_Edge_Connect_Sig_Dq137" },
	{ 200, "SPD_Edge_Connect_Sig_Dq138" },
	{ 201, "SPD_Edge_Connect_Sig_Dq139" },
	{ 202, "SPD_Edge_Connect_Sig_Dq140" },
	{ 203, "SPD_Edge_Connect_Sig_Dq141" },
	{ 204, "SPD_Edge_Connect_Sig_Dq142" },
	{ 205, "SPD_Edge_Connect_Sig_Dq143" },
	{ 206, "SPD_Sun_Mod_Label_Info" },
	{ 207, "Spare_49bytes" }
};

fru_enum_t Laser_Power_EventsR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Event" }
};

fru_enum_t Laser_Power_SummaryR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Total_Time_On" },
	{ 2, "Total_Power_Ons" },
	{ 3, "Total_Power_Offs" }
};

fru_enum_t Laser_Cum_Power_SummaryR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Total_Time_On" },
	{ 2, "Total_Power_Ons" },
	{ 3, "Total_Power_Offs" }
};

fru_enum_t COD_CPUSpeedR[] = {
	{ 0, "CPU0_SerialNum" },
	{ 1, "CPU0_Speed" },
	{ 2, "CPU1_SerialNum" },
	{ 3, "CPU1_Speed" },
	{ 4, "CPU2_SerialNum" },
	{ 5, "CPU2_Speed" },
	{ 6, "CPU3_SerialNum" },
	{ 7, "CPU3_Speed" }
};

fru_enum_t EthernetMACAddr2R[] = {
	{ 0, "Ethernet_Addr" },
	{ 1, "Ethernet_Addr2" }
};

fru_enum_t Status_Proxy1R[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Version" },
	{ 2, "StatusMap31" }
};

fru_enum_t Status_Proxy2R[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Version" },
	{ 2, "StatusMap127" }
};

fru_enum_t Sun_Part_Number_DataR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Sun_Part_No" },
	{ 2, "Sun_Serial_No" },
	{ 3, "Vendor_Name" },
	{ 4, "Initial_HW_Dash_Level" }
};

fru_enum_t Fault_DataR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Error_Code" },
	{ 2, "Fault_Code" }
};

fru_enum_t BatteryWarrantyR[] = {
	{ 0, "WarrantyDuration" },
	{ 1, "RefreshCycle" },
	{ 2, "ShelfLife" }
};

fru_enum_t EthernetMACAddrRangeR[] = {
	{ 0, "Ethernet_Addr" },
	{ 1, "Ethernet_Addr_Range" }
};

fru_enum_t Drawer_DescriptionR[] = {
	{ 0, "Drawer_Type" },
	{ 1, "Access_Model" },
	{ 2, "Disk_Presence" },
	{ 3, "Power_Type" },
	{ 4, "Sun_Part_No" },
	{ 5, "Sun_Serial_No" },
	{ 6, "Diskslot1_Label" },
	{ 7, "Diskslot2_Label" },
	{ 8, "Fanslot1_Label" },
	{ 9, "Fanslot2_Label" },
	{ 10, "Psuslot1_Label" },
	{ 11, "Psuslot2_Label" },
	{ 12, "Scbslot_Label" },
	{ 13, "Rmmslot_Label" },
	{ 14, "Pdu1_Label" },
	{ 15, "Pdu2_Label" }
};

fru_enum_t Drawer_ConfigR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Drawer_Cfg" },
	{ 2, "Power_Supply_Cfg" },
	{ 3, "Location" },
	{ 4, "User_Label" }
};

fru_enum_t Drawer_InfoR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Drawer_Id" },
	{ 2, "Drawer_Type" },
	{ 3, "Access_Model" },
	{ 4, "Slot_Mode" },
	{ 5, "Reserved_Data" }
};

fru_enum_t CPUFirmwareR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "CPU_FW_Part_No" },
	{ 2, "CPU_FW_Dash_Level" }
};

fru_enum_t Netra_ACFirmwareR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "BCFW_Part_No" },
	{ 2, "BCFW_Dash_Level" },
	{ 3, "CMSW_Part_No" },
	{ 4, "CMSW_Dash_Level" },
	{ 5, "BMCFW_Part_No" },
	{ 6, "BMCFW_Dash_Level" }
};

fru_enum_t Fru_DescriptionR[] = {
	{ 0, "Fru_Type" },
	{ 1, "External_Label" },
	{ 2, "Min_Power_Rating" },
	{ 3, "Max_Power_Rating" },
	{ 4, "Fru_Description_StringG" },
	{ 5, "Fru_Description_StringL" }
};

fru_enum_t CPCI_Slot_DataR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Acceptable_Fru_Types" },
	{ 2, "Slot_Mode" },
	{ 3, "Boot_Devices" }
};

fru_enum_t MCNet_ConfigR[] = {
	{ 0, "MCNetIPSubnet" },
	{ 1, "MCNetIPSubnetMask" },
	{ 2, "MCNetOpaque" }
};

fru_enum_t Battery_StatusR[] = {
	{ 0, "WarrantyStartDate" },
	{ 1, "LastRechargeDate" },
	{ 2, "LastHealthCheckDate" },
	{ 3, "BatteryStatus" }
};

fru_enum_t Battery_WarrantyR[] = {
	{ 0, "WarrantyDuration" },
	{ 1, "RefreshCycle" },
	{ 2, "ShelfLife" }
};

fru_enum_t Config_LevelR[] = {
	{ 0, "Configured_Serial_No" },
	{ 1, "Fru_Description" },
	{ 2, "FRU_Part_And_Dash_No" }
};

fru_enum_t Chassis_InfoR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Chassis_Id" },
	{ 2, "Chassis_Type" },
	{ 3, "Access_Model" },
	{ 4, "Reserved_Data" }
};

fru_enum_t Netra_DMCFirmwareR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "BCFW_Part_No" },
	{ 2, "BCFW_Dash_Level" },
	{ 3, "CMSW_Part_No" },
	{ 4, "CMSW_Dash_Level" },
	{ 5, "BMCFW_Part_No" },
	{ 6, "BMCFW_Dash_Level" }
};

fru_enum_t Chassis_DataR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Chassis_Id" },
	{ 2, "Chassis_Type" },
	{ 3, "Access_Model" },
	{ 4, "Reserved_Data" }
};

fru_enum_t DMCFirmwareR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "BCFW_Part_No" },
	{ 2, "BCFW_Dash_Level" },
	{ 3, "CMSW_Part_No" },
	{ 4, "CMSW_Dash_Level" },
	{ 5, "BMCFW_Part_No" },
	{ 6, "BMCFW_Dash_Level" }
};

fru_enum_t MaintenanceR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "New_Description" },
	{ 2, "New_Sun_Part_No" }
};

fru_enum_t SPD_R[] = {
	{ 0, "SPD_Bytes_Written_SPDMemory" },
	{ 1, "SPD_TotBytes_SPDMemory" },
	{ 2, "SPD_Fundamental_Memory_Type" },
	{ 3, "SPD_Row_Address_Bits" },
	{ 4, "SPD_Column_Address_Bits" },
	{ 5, "SPD_No_Banks_Assembly" },
	{ 6, "SPD_Module_Data_Width" },
	{ 7, "SPD_Mod_Voltage_Interface" },
	{ 8, "SPD_Cycle_Time" },
	{ 9, "SPD_Access_Time" },
	{ 10, "SPD_DIMM_Config_Type" },
	{ 11, "SPD_Type_Specific" },
	{ 12, "SPD_Data_Revision_Code" },
	{ 13, "Checksum_8" },
	{ 14, "Vendor_Name" },
	{ 15, "SPD_Man_Loc" },
	{ 16, "SPD_Manufacturer_Part_No" },
	{ 17, "SPD_Module_Rev_Code" },
	{ 18, "SPD_Manufacture_Year" },
	{ 19, "SPD_Manufacture_Week" },
	{ 20, "SPD_Assembly_Serial_No" },
	{ 21, "SPD_Man_Specific" }
};

fru_enum_t PlatformR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Platform_Name" }
};

fru_enum_t PartNumber_ChangedR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "From_Part_No" },
	{ 2, "From_Serial_No" },
	{ 3, "From_Dash_No" },
	{ 4, "To_Part_No" },
	{ 5, "To_Serial_No" },
	{ 6, "To_Dash_No" }
};

fru_enum_t FRU_Props_PrivateR[] = {
	{ 0, "SpecPartNo" },
	{ 1, "Properties" }
};

fru_enum_t Fan_Speeds[] = {
	{ 0, "Fan_Revs_Per_Sec" },
	{ 1, "Tacho_Pulses_Per_Rev" }
};

fru_enum_t FRU_Props_Private2R[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "SpecPartNo" },
	{ 2, "Properties" }
};

fru_enum_t Status_Proxy3R[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Version" },
	{ 2, "StatusMap2" }
};

fru_enum_t DDR1PinSteerR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "DataBits" }
};

fru_enum_t Event_DataR[] = {
	{ 0, "Initiator" },
	{ 1, "Message_Type" },
	{ 2, "Diagcode" },
	{ 3, "UUID" }
};

fru_enum_t PSU_PVout1R[] = {
	{ 0, "PSU_Voltage" },
	{ 1, "PSU_Current" }
};

fru_enum_t PSU_PVstby1R[] = {
	{ 0, "PSU_Voltage" },
	{ 1, "PSU_Current" }
};

fru_enum_t SPD1_R[] = {
	{ 0, "SPD_Bytes_Written_SPDMemory" },
	{ 1, "SPD_TotBytes_SPDMemory" },
	{ 2, "SPD_Fundamental_Memory_Type" },
	{ 3, "SPD_Row_Address_Bits" },
	{ 4, "SPD_Column_Address_Bits" },
	{ 5, "SPD_No_Banks_Assembly" },
	{ 6, "SPD_Module_Data_Width" },
	{ 7, "SPD_Mod_Voltage_Interface" },
	{ 8, "SPD_Cycle_Time" },
	{ 9, "SPD_Access_Time" },
	{ 10, "SPD_DIMM_Config_Type" },
	{ 11, "SPD_Type_Specific" },
	{ 12, "SPD_Data_Revision_Code" },
	{ 13, "Checksum_8" },
	{ 14, "Vendor_Name" },
	{ 15, "SPD_Man_Loc" },
	{ 16, "SPD_Manufacturer_Part_No" },
	{ 17, "SPD_Module_Rev_Code" },
	{ 18, "SPD_Manufacture_Year" },
	{ 19, "SPD_Manufacture_Week" },
	{ 20, "SPD_Sun_Serial_No" },
	{ 21, "SPD_Man_Specific" }
};

fru_enum_t Sun_SPD_DataR[] = {
	{ 0, "SPD_Format_Version" },
	{ 1, "Sun_Part_Dash_Rev" },
	{ 2, "Certified_Platforms" },
	{ 3, "Sun_Key_Code" },
	{ 4, "Sun_Certification" }
};

fru_enum_t IPMI_BoardR[] = {
	{ 0, "Format_Version" },
	{ 1, "Lang_Code" },
	{ 2, "MFG_DateTime" },
	{ 3, "Manufacturer" },
	{ 4, "ProductName" },
	{ 5, "IPMISerialNo" },
	{ 6, "IPMIPartNo" },
	{ 7, "FRU_FileID" },
	{ 8, "BoardCustom_MfgInfo" }
};

fru_enum_t IPMI_ProductR[] = {
	{ 0, "Format_Version" },
	{ 1, "Lang_Code" },
	{ 2, "Manufacturer" },
	{ 3, "ProductName" },
	{ 4, "IPMIPartNo" },
	{ 5, "ProductVersion" },
	{ 6, "IPMISerialNo" },
	{ 7, "AssetTag" },
	{ 8, "FRU_FileID" },
	{ 9, "ProductCustom_MfgInfo" }
};

fru_enum_t IPMI_ChassisR[] = {
	{ 0, "Format_Version" },
	{ 1, "ChassisName" },
	{ 2, "IPMIPartNo" },
	{ 3, "IPMISerialNo" },
	{ 4, "ChassisCustom_MfgInfo" }
};

fru_enum_t Partner_Part_NumberR[] = {
	{ 0, "Vendor_Name" },
	{ 1, "Partner_Part_Number" }
};

fru_enum_t Sun_ManR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Sun_Fru_Description" },
	{ 2, "Vendor_Site_ID" },
	{ 3, "Vendor_Site_ID_Source" },
	{ 4, "SUN_PN" },
	{ 5, "SUN_SN" },
	{ 6, "SN_Format" },
	{ 7, "Vendor_ID" },
	{ 8, "Vendor_ID_Source" },
	{ 9, "Initial_HW_Dash_Level" },
	{ 10, "Initial_HW_Rev_Level" },
	{ 11, "Fru_Shortname" },
	{ 12, "Sun_Hazard_Class_Code" },
	{ 13, "Sun_Fru_Type" },
	{ 14, "Sun_SpecPartNo" }
};

fru_enum_t OTS_ManR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "OTS_ManR_Version" },
	{ 2, "Sun_Fru_Description" },
	{ 3, "Vendor_Site_ID" },
	{ 4, "Vendor_Site_ID_Source" },
	{ 5, "SUN_PN" },
	{ 6, "Commodity_SN" },
	{ 7, "SSN_Rule" },
	{ 8, "Vendor_ID" },
	{ 9, "Vendor_ID_Source" },
	{ 10, "Program_Vendor_ID" },
	{ 11, "Program_Vendor_ID_Source" },
	{ 12, "Initial_HW_Dash_Level" },
	{ 13, "Initial_HW_Rev_Level" },
	{ 14, "Fru_Shortname" },
	{ 15, "Format_Type" },
	{ 16, "Sun_Hazard_Class_Code" },
	{ 17, "Sun_Fru_Type" },
	{ 18, "Sun_SpecPartNo" }
};

fru_enum_t NetworkR[] = {
	{ 0, "ReqMBox" },
	{ 1, "GrantMBox" },
	{ 2, "IPAddr" },
	{ 3, "IPDiscovery" },
	{ 4, "IPGateway" },
	{ 5, "IPNetmask" }
};

fru_enum_t FMA_CodeR[] = {
	{ 0, "Code_Version" },
	{ 1, "Dictid" },
	{ 2, "Diag_Code" }
};

fru_enum_t Fault_Install_DataR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "MACADDR" },
	{ 2, "Status" },
	{ 3, "Initiator" },
	{ 4, "Message_Type" },
	{ 5, "Message_32" }
};

fru_enum_t Power_On_DataR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Power_On_Minutes" }
};

fru_enum_t Network1R[] = {
	{ 0, "ReqMBox" },
	{ 1, "GrantMBox" },
	{ 2, "IPAddr" },
	{ 3, "IPDiscovery" },
	{ 4, "IPGateway" },
	{ 5, "IPNetmask" },
	{ 6, "Ethernet_Addr2" }
};

fru_enum_t FMA_Event_DataR[] = {
	{ 0, "Fault_Diag_Secs" },
	{ 1, "FMA_CodeR" },
	{ 2, "UUID" },
	{ 3, "DE_Name" },
	{ 4, "DE_Version" },
	{ 5, "Diagdata" }
};

fru_enum_t FMA_MessageR[] = {
	{ 0, "Fault_Diag_Secs" },
	{ 1, "FMA_String" },
	{ 2, "UUID" },
	{ 3, "DE_Name" },
	{ 4, "DE_Version" },
	{ 5, "Diagdata" }
};

fru_enum_t OEM_Record_Header_S[] = {
	{ 0, "Record_Type_ID" },
	{ 1, "End_Of_Records" },
	{ 2, "Record_Length" },
	{ 3, "Record_Checksum" },
	{ 4, "Header_Checksum" }
};

fru_enum_t Chassis_Info_Area_S[] = {
	{ 0, "Chassis_Info_Area_Format_Version" },
	{ 1, "Chassis_Info_Area_Length" },
	{ 2, "ChassisType" },
	{ 3, "Chassis_Part_Number_Type_Length" },
	{ 4, "Chassis_Part_Number" },
	{ 5, "Chassis_Serial_Number_Type_Length" },
	{ 6, "Chassis_Serial_Number" },
	{ 7, "Custom_Chassis_Info_Type_Length" },
	{ 8, "Custom_Chassis_Info" },
	{ 9, "End_Of_Fields" },
	{ 10, "Zeros_Pad" },
	{ 11, "Chassis_Info_Checksum" }
};

fru_enum_t Board_Info_Area_S[] = {
	{ 0, "Board_Area_Format_Version" },
	{ 1, "Board_Area_Length" },
	{ 2, "Language_Code" },
	{ 3, "Mfg_Date_Time" },
	{ 4, "Board_Manufacturer_Type_Length" },
	{ 5, "Board_Manufacturer" },
	{ 6, "Board_Product_Name_Type_Length" },
	{ 7, "Board_Product_Name" },
	{ 8, "Board_Serial_Number_Type_Length" },
	{ 9, "Board_Serial_Number" },
	{ 10, "Board_Part_Number_Type_Length" },
	{ 11, "Board_Part_Number" },
	{ 12, "FRU_File_ID_Type_Length" },
	{ 13, "FRU_File_ID" },
	{ 14, "Custom_Mfg_Info_Type_Length" },
	{ 15, "Custom_Mfg_Info" },
	{ 16, "End_Of_Fields" },
	{ 17, "Zeros_Pad" },
	{ 18, "Board_Area_Checksum" }
};

fru_enum_t Product_Info_Area_S[] = {
	{ 0, "Product_Area_Format_Version" },
	{ 1, "Product_Area_Length" },
	{ 2, "Language_Code" },
	{ 3, "Manufacturer_Name_Type_Length" },
	{ 4, "Manufacturer_Name" },
	{ 5, "Product_Name_Type_Length" },
	{ 6, "Product_Name" },
	{ 7, "Product_Part_Model_Number_Type_Length" },
	{ 8, "Product_Part_Model_Number" },
	{ 9, "Product_Version_Type_Length" },
	{ 10, "Product_Version" },
	{ 11, "Product_Serial_Number_Type_Length" },
	{ 12, "Product_Serial_Number" },
	{ 13, "Asset_Tag_Type_Length" },
	{ 14, "Asset_Tag" },
	{ 15, "FRU_File_ID_Type_Length" },
	{ 16, "FRU_File_ID" },
	{ 17, "Custom_Product_Info_Type_Length" },
	{ 18, "Custom_Product_Info" },
	{ 19, "End_Of_Fields" },
	{ 20, "Zeros_Pad" },
	{ 21, "Product_Info_Area_Checksum" }
};

fru_enum_t IPMI_Common_Header_S[] = {
	{ 0, "Common_Header_Format_Version" },
	{ 1, "Internal_Use_Area_Starting_Offset" },
	{ 2, "Chassis_Info_Area_Starting_Offset" },
	{ 3, "Board_Area_Starting_Offset" },
	{ 4, "Product_Info_Area_Starting_Offset" },
	{ 5, "MultiRecord_Area_Starting_Offset" },
	{ 6, "PAD" },
	{ 7, "Common_Header_Checksum" }
};

fru_enum_t Sun_Man1R[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Sun_Fru_Description" },
	{ 2, "Vendor_ID_Code" },
	{ 3, "Vendor_ID_Code_Source" },
	{ 4, "Vendor_Name_And_Site_Location" },
	{ 5, "Sun_Part_Number" },
	{ 6, "Sun_Serial_Number" },
	{ 7, "Serial_Number_Format" },
	{ 8, "Initial_HW_Dash_Level" },
	{ 9, "Initial_HW_Rev_Level" },
	{ 10, "Sun_Fru_Shortname" },
	{ 11, "Sun_Hazard_Class_Code" },
	{ 12, "Sun_SpecPartNo" }
};

fru_enum_t SPD_DDR2_R[] = {
	{ 0, "SPD_Bytes_Written_SPDMemory" },
	{ 1, "SPD_TotBytes_SPDMemory" },
	{ 2, "SPD_Fundamental_Memory_Type" },
	{ 3, "SPD_Row_Address_Bits" },
	{ 4, "SPD_Column_Address_Bits" },
	{ 5, "SPD_No_Banks_Assembly" },
	{ 6, "SPD_Module_Data_Width" },
	{ 7, "SPD_Mod_Voltage_Interface" },
	{ 8, "SPD_Cycle_Time" },
	{ 9, "SPD_Access_Time" },
	{ 10, "SPD_DIMM_Config_Type" },
	{ 11, "SPD_Type_Specific" },
	{ 12, "SPD_Data_Revision_Code" },
	{ 13, "Checksum_8" },
	{ 14, "Vendor_Name" },
	{ 15, "Vendor_Name_Fill" },
	{ 16, "SPD_Man_Loc" },
	{ 17, "SPD_Manufacturer_Part_No" },
	{ 18, "SPD_Module_Rev_Code" },
	{ 19, "SPD_Manufacturing_Date" },
	{ 20, "SPD_Module_Serial_Number" },
	{ 21, "SPD_Man_Specific" }
};

fru_enum_t SPD_FBDIMM_R[] = {
	{ 0, "SPD_Bytes_Written_SPDMemory" },
	{ 1, "SPD_Data_Revision_Code" },
	{ 2, "SPD_Fundamental_Memory_Type" },
	{ 3, "SPD_Mod_Voltage_Interface" },
	{ 4, "SPD_SDRAM_Addressing" },
	{ 5, "SPD_Module_Physical_Attributes" },
	{ 6, "SPD_Module_Type_Thickness" },
	{ 7, "SPD_Module_Organization" },
	{ 8, "SPD_FBDIMM_Specific" },
	{ 9, "Vendor_Name" },
	{ 10, "SPD_Man_Loc" },
	{ 11, "SPD_Manufacturing_Date" },
	{ 12, "SPD_Module_Serial_Number" },
	{ 13, "SPD_CRC16" },
	{ 14, "SPD_Manufacturer_Part_No" },
	{ 15, "SPD_Module_Rev_Code" },
	{ 16, "SPD_SDRAM_Vendor_Name" },
	{ 17, "SPD_Man_Specific1" }
};

fru_enum_t Sun_SPD_DIMMR[] = {
	{ 0, "SPD_Format_Version" },
	{ 1, "Sun_PartNumber" },
	{ 2, "Sun_DashNumber" },
	{ 3, "Sun_RevNumber" },
	{ 4, "Certified_Platforms" },
	{ 5, "Sun_Key_Code" },
	{ 6, "Sun_Certification" },
	{ 7, "Fault_Install_DataR" },
	{ 8, "Power_On_DataR" }
};

fru_enum_t Status_Proxy_SparseR[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "Element_Count" },
	{ 2, "Sparse_Elements" }
};

fru_enum_t OTS_Man1R[] = {
	{ 0, "UNIX_Timestamp32" },
	{ 1, "OTS_ManR_Version" },
	{ 2, "Sun_Fru_Description" },
	{ 3, "Vendor_ID_Code" },
	{ 4, "Vendor_ID_Code_Source" },
	{ 5, "Vendor_Name_And_Site_Location" },
	{ 6, "Sun_Part_Number" },
	{ 7, "Commodity_Serial_Number" },
	{ 8, "Synthesized_Serial_Number_Rule" },
	{ 9, "Program_Vendor_ID_Code" },
	{ 10, "Program_Vendor_ID_Code_Source" },
	{ 11, "Program_Vendor_Name_And_Site_Location" },
	{ 12, "Initial_HW_Dash_Level" },
	{ 13, "Initial_HW_Rev_Level" },
	{ 14, "Sun_Fru_Shortname" },
	{ 15, "Sun_Hazard_Class_Code" },
	{ 16, "Sun_SpecPartNo" }
};

fru_enum_t SPD_DDR3_R[] = {
	{ 0, "SPD_Bytes_Written_SPDMemory" },
	{ 1, "SPD_Data_Revision_Code" },
	{ 2, "SPD_Fundamental_Memory_Type" },
	{ 3, "SPD_Module_Type" },
	{ 4, "SPD_Density_And_Banks" },
	{ 5, "SPD_SDRAM_Addressing" },
	{ 6, "SPD_Reserved" },
	{ 7, "SPD_Module_Organization" },
	{ 8, "SPD_DDR3_Specific" },
	{ 9, "Vendor_Name" },
	{ 10, "SPD_Man_Loc" },
	{ 11, "SPD_Manufacturing_Date" },
	{ 12, "SPD_Module_Serial_Number" },
	{ 13, "SPD_CRC16" },
	{ 14, "SPD_Manufacturer_Part_No" },
	{ 15, "SPD_Module_Rev_Code" },
	{ 16, "SPD_SDRAM_Vendor_Name" },
	{ 17, "SPD_Man_Specific1" }
};


fru_regdef_t Element_Defs[] = {
	{FRU_REVNO,
		"AFT_Structure",
		FRU_C,
		1,
		1,
		1,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_No,
		FRU_No,
		8,
		AFT_Struct,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"AMB_Shutdown_Level",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"AMB_Warning_Level",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Acceptable_Fru_Types",
		FRU_X,
		0,
		96,
		96,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Access_Model",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Ambient_Temp_Array",
		FRU_X,
		0,
		8,
		64,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"AssetTag",
		FRU_X,
		0,
		10,
		10,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Asset_Tag",
		FRU_X,
		0,
		8,
		64,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Asset_Tag_Type_Length",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"BCFW_Dash_Level",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"BCFW_Part_No",
		FRU_X,
		0,
		7,
		7,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"BMCFW_Dash_Level",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"BMCFW_Part_No",
		FRU_X,
		0,
		7,
		7,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"BatteryStatus",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"BatteryWarrantyR",
		FRU_G,
		1,
		16,
		16,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		3,
		BatteryWarrantyR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Battery_StatusR",
		FRU_C,
		2,
		13,
		13,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		4,
		Battery_StatusR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Battery_WarrantyR",
		FRU_C,
		2,
		12,
		12,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		3,
		Battery_WarrantyR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"BoardCustom_MfgInfo",
		FRU_X,
		0,
		100,
		100,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Board_Area_Checksum",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Board_Area_Format_Version",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Board_Area_Length",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Board_Area_Starting_Offset",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Board_Info_Area_S",
		FRU_X,
		0,
		156,
		156,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		19,
		Board_Info_Area_S,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Board_Manufacturer",
		FRU_X,
		0,
		63,
		63,
		FDTYPE_ByteArray,
		FDISP_Binary,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Board_Manufacturer_Type_Length",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Board_Part_Number",
		FRU_X,
		0,
		7,
		56,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Board_Part_Number_Type_Length",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Board_Product_Name",
		FRU_X,
		0,
		16,
		16,
		FDTYPE_ByteArray,
		FDISP_Binary,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Board_Product_Name_Type_Length",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Board_Serial_Number",
		FRU_X,
		0,
		30,
		30,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Board_Serial_Number_Type_Length",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Board_Speed",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Boot_Devices",
		FRU_X,
		0,
		25,
		25,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Bootbus_Timing",
		FRU_X,
		0,
		8,
		64,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CMSW_Dash_Level",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CMSW_Part_No",
		FRU_X,
		0,
		7,
		7,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"COD_CPUSpeedR",
		FRU_E,
		1,
		40,
		40,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		8,
		COD_CPUSpeedR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CODenabled",
		FRU_B,
		1,
		1,
		1,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		2,
		Boolean_90,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CPCI_Slot_DataR",
		FRU_F,
		1,
		886,
		886,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		4,
		CPCI_Slot_DataR,
		7,
		FRU_Linear,
		""},
	{FRU_REVNO,
		"CPU0_DIMMBank0_Map",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CPU0_DIMMBank1_Map",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CPU0_Features",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CPU0_SerialNum",
		FRU_X,
		0,
		8,
		64,
		FDTYPE_Binary,
		FDISP_Binary,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CPU0_Speed",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CPU1_DIMMBank0_Map",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CPU1_DIMMBank1_Map",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CPU1_Features",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CPU1_SerialNum",
		FRU_X,
		0,
		8,
		64,
		FDTYPE_Binary,
		FDISP_Binary,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CPU1_Speed",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CPU2_SerialNum",
		FRU_X,
		0,
		8,
		64,
		FDTYPE_Binary,
		FDISP_Binary,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CPU2_Speed",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CPU3_SerialNum",
		FRU_X,
		0,
		8,
		64,
		FDTYPE_Binary,
		FDISP_Binary,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CPU3_Speed",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CPUBoardSpeedR",
		FRU_C,
		2,
		8,
		8,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		4,
		CPUBoardSpeedR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CPUFirmwareR",
		FRU_C,
		1,
		13,
		13,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		3,
		CPUFirmwareR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CPUR",
		FRU_C,
		4,
		8,
		8,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		4,
		CPUR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CPU_FW_Dash_Level",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CPU_FW_Part_No",
		FRU_X,
		0,
		7,
		7,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CPU_Max_Safari_Speed",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CPU_Speed",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"CPU_Type",
		FRU_X,
		0,
		1,
		1,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_No,
		FRU_No,
		2,
		CPU_Type,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Cache_Size",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Cache_Timing",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Case_Number",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Case_Number_old",
		FRU_X,
		0,
		5,
		40,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Cause_Code",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		168,
		Cause_Code,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Certified_Platforms",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"ChassisCustom_MfgInfo",
		FRU_X,
		0,
		203,
		203,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"ChassisName",
		FRU_X,
		0,
		1,
		1,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		23,
		Chassis_Name,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"ChassisType",
		FRU_X,
		0,
		1,
		1,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_No,
		FRU_No,
		23,
		Chassis_Name,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Chassis_DataR",
		FRU_E,
		1,
		76,
		76,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		5,
		Chassis_DataR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Chassis_Id",
		FRU_X,
		0,
		6,
		6,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Chassis_InfoR",
		FRU_G,
		1,
		76,
		76,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		5,
		Chassis_InfoR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Chassis_Info_Area_Format_Version",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Chassis_Info_Area_Length",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Chassis_Info_Area_S",
		FRU_X,
		0,
		60,
		60,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		12,
		Chassis_Info_Area_S,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Chassis_Info_Area_Starting_Offset",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Chassis_Info_Checksum",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Chassis_Part_Number",
		FRU_X,
		0,
		7,
		56,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Chassis_Part_Number_Type_Length",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Chassis_Serial_Number",
		FRU_X,
		0,
		30,
		30,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Chassis_Serial_Number_Type_Length",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Chassis_Type",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Checksum_8",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Code_Version",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Commodity_SN",
		FRU_X,
		0,
		30,
		30,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Commodity_Serial_Number",
		FRU_X,
		0,
		30,
		30,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Common_Header_Format_Version",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Compatible_Part_No",
		FRU_C,
		5,
		9,
		9,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Component",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Components_Replaced",
		FRU_X,
		0,
		40,
		40,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Config_LevelR",
		FRU_E,
		1,
		109,
		109,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		3,
		Config_LevelR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Configured_LevelR",
		FRU_E,
		1,
		33,
		33,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		4,
		Configured_LevelR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Configured_Serial_No",
		FRU_X,
		0,
		20,
		20,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Container_Header",
		FRU_A,
		1,
		0,
		0,
		FDTYPE_UNDEFINED,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Cum_Power_SummaryR",
		FRU_C,
		4,
		16,
		16,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		4,
		Cum_Power_SummaryR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Cum_Temperature_HistoryR",
		FRU_E,
		2,
		32,
		32,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		6,
		Cum_Temperature_HistoryR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Cust_Data",
		FRU_X,
		0,
		80,
		80,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Custom_Chassis_Info",
		FRU_X,
		0,
		8,
		64,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Custom_Chassis_Info_Type_Length",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Custom_Mfg_Info",
		FRU_X,
		0,
		8,
		64,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Custom_Mfg_Info_Type_Length",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Custom_Product_Info",
		FRU_X,
		0,
		8,
		64,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Custom_Product_Info_Type_Length",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Customer_DataR",
		FRU_E,
		3,
		84,
		84,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		2,
		Customer_DataR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Customer_Private",
		FRU_F,
		1,
		256,
		256,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"DDR1PinSteerR",
		FRU_C,
		9,
		8,
		8,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		2,
		DDR1PinSteerR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"DE_Name",
		FRU_X,
		0,
		16,
		16,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"DE_Version",
		FRU_X,
		0,
		8,
		8,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"DIMM_Capacity",
		FRU_C,
		8,
		8,
		8,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"DIMM_Conf_R",
		FRU_B,
		1,
		4,
		4,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		2,
		DIMM_Conf_R,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"DIMM_Private74",
		FRU_E,
		1,
		74,
		74,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"DIMM_Private768",
		FRU_F,
		1,
		768,
		768,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"DIMM_R",
		FRU_E,
		2,
		4,
		4,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		2,
		DIMM_R,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"DIMM_Size",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"DIMM_Speed",
		FRU_E,
		1,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"DMCFirmwareR",
		FRU_C,
		2,
		31,
		31,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		7,
		DMCFirmwareR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"DS_CPU_Six_FanTrayR",
		FRU_B,
		5,
		4,
		4,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		3,
		DS_CPU_Six_FanTrayR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"DS_IO_Four_FanTrayR",
		FRU_B,
		6,
		4,
		4,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		3,
		DS_IO_Four_FanTrayR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Dak_DBPNameR",
		FRU_E,
		1,
		64,
		64,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		2,
		Dak_DBPNameR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Dak_DBPR",
		FRU_E,
		10,
		80,
		80,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		7,
		Dak_DBPR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Dak_DualCPUModuleR",
		FRU_F,
		1,
		121,
		121,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		21,
		Dak_DualCPUModuleR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Dak_FCAL_GBICR",
		FRU_B,
		11,
		4,
		4,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		2,
		Dak_FCAL_GBICR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Dak_IOBoardR",
		FRU_F,
		1,
		52,
		52,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		5,
		Dak_IOBoardR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Dak_MotherboardR",
		FRU_F,
		1,
		103,
		103,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		13,
		Dak_MotherboardR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Dak_PDBR",
		FRU_E,
		2,
		84,
		84,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		7,
		Dak_PDBR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Dak_PowersupplyR",
		FRU_C,
		11,
		24,
		24,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		3,
		Dak_PowersupplyR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Dak_RSCR",
		FRU_E,
		9,
		59,
		59,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		7,
		Dak_RSCR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Dash_Number_In",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Dash_Number_Out",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"DataBits",
		FRU_X,
		0,
		4,
		4,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Date_Code",
		FRU_X,
		0,
		8,
		8,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Date_Of_Repair",
		FRU_X,
		0,
		8,
		64,
		FDTYPE_Binary,
		FDISP_Time,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Device_Type",
		FRU_C,
		1,
		2,
		2,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_No,
		FRU_No,
		185,
		Device_Type,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Devices",
		FRU_B,
		3,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Binary,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Diag_Code",
		FRU_X,
		0,
		13,
		13,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Diagcode",
		FRU_X,
		0,
		16,
		16,
		FDTYPE_ByteArray,
		FDISP_MSGID,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Diagdata",
		FRU_X,
		0,
		64,
		64,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Dictid",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		1,
		Dictionary_Name,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Disk_Presence",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Diskslot1_Label",
		FRU_X,
		0,
		6,
		6,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Diskslot2_Label",
		FRU_X,
		0,
		6,
		6,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"DomainAEthernetAddr",
		FRU_X,
		0,
		6,
		48,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"DomainBEthernetAddr",
		FRU_X,
		0,
		6,
		48,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"DomainCEthernetAddr",
		FRU_X,
		0,
		6,
		48,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"DomainDEthernetAddr",
		FRU_X,
		0,
		6,
		48,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Drawer_Cfg",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Drawer_ConfigR",
		FRU_E,
		1,
		96,
		96,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		5,
		Drawer_ConfigR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Drawer_DescriptionR",
		FRU_E,
		1,
		77,
		77,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		16,
		Drawer_DescriptionR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Drawer_Id",
		FRU_X,
		0,
		6,
		6,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Drawer_InfoR",
		FRU_E,
		2,
		77,
		77,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		6,
		Drawer_InfoR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Drawer_Type",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"ECO_CurrentR",
		FRU_C,
		1,
		16,
		16,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		4,
		ECO_CurrentR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"EcacheR",
		FRU_E,
		1,
		3,
		3,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		2,
		EcacheR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Ecache_Features",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Ecache_Mode",
		FRU_A,
		1,
		1,
		1,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_No,
		FRU_No,
		2,
		Ecache_Mode,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Ecache_Module_IDR",
		FRU_E,
		1,
		84,
		84,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		2,
		Ecache_Module_IDR,
		4,
		FRU_Linear,
		""},
	{FRU_REVNO,
		"Element_Count",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Enclosure_Nickname",
		FRU_E,
		3,
		32,
		32,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"End_Of_Fields",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"End_Of_Records",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Error_Code",
		FRU_X,
		0,
		1,
		1,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		13,
		Error_Code,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Error_SummaryR",
		FRU_B,
		10,
		4,
		4,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		2,
		Error_SummaryR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"EthernetMACAddr2R",
		FRU_C,
		1,
		12,
		12,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		2,
		EthernetMACAddr2R,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"EthernetMACAddrRangeR",
		FRU_C,
		7,
		8,
		8,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		2,
		EthernetMACAddrRangeR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Ethernet_Addr",
		FRU_A,
		1,
		6,
		48,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Ethernet_Addr2",
		FRU_X,
		0,
		6,
		48,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Ethernet_Addr_Range",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Event",
		FRU_X,
		0,
		1,
		1,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		3,
		Power_Events_50,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Event_Code",
		FRU_X,
		0,
		4,
		4,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		9,
		Status_Event_Code_71,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Event_DataR",
		FRU_E,
		2,
		34,
		34,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		4,
		Event_DataR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"ExcalCPUR",
		FRU_E,
		1,
		94,
		94,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		7,
		ExcalCPUR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"ExcalMotherboardR",
		FRU_A,
		2,
		6,
		6,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		1,
		ExcalMotherboardR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"ExcalUsageR",
		FRU_C,
		1,
		9,
		9,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		3,
		ExcalUsageR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Experimental",
		FRU_F,
		1,
		128,
		128,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_Yes,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"External_Label",
		FRU_X,
		0,
		20,
		20,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"FMA_CodeR",
		FRU_X,
		0,
		16,
		16,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		3,
		FMA_CodeR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"FMA_DecodeR",
		FRU_G,
		1,
		0,
		0,
		FDTYPE_UNDEFINED,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"FMA_Event_DataR",
		FRU_X,
		0,
		128,
		128,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		6,
		FMA_Event_DataR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"FMA_MessageR",
		FRU_X,
		0,
		128,
		128,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		6,
		FMA_MessageR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"FMA_String",
		FRU_X,
		0,
		16,
		16,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"FRU_FileID",
		FRU_X,
		0,
		25,
		25,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"FRU_File_ID",
		FRU_X,
		0,
		11,
		11,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"FRU_File_ID_Type_Length",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"FRU_Part_And_Dash_No",
		FRU_X,
		0,
		9,
		9,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"FRU_Props_Private2R",
		FRU_E,
		1,
		63,
		63,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		3,
		FRU_Props_Private2R,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"FRU_Props_PrivateR",
		FRU_E,
		2,
		59,
		59,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		2,
		FRU_Props_PrivateR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Fan_Pair_Mask",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Fan_Present_Mask",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Fan_Revs_Per_Sec",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Fan_Speeds",
		FRU_C,
		1,
		28,
		28,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		2,
		Fan_Speeds,
		8,
		FRU_Linear,
		""},
	{FRU_REVNO,
		"Fan_Startup_Delay",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Fanslot1_Label",
		FRU_X,
		0,
		6,
		6,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Fanslot2_Label",
		FRU_X,
		0,
		6,
		6,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Fault_Code",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Fault_DataR",
		FRU_A,
		1,
		7,
		7,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		3,
		Fault_DataR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Fault_Detail",
		FRU_X,
		0,
		80,
		80,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Fault_Diag_Secs",
		FRU_X,
		0,
		8,
		64,
		FDTYPE_Binary,
		FDISP_Time,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Fault_Install_DataR",
		FRU_X,
		0,
		45,
		45,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		6,
		Fault_Install_DataR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Firmware_Revision",
		FRU_X,
		0,
		8,
		8,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Format_Type",
		FRU_X,
		0,
		1,
		1,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_No,
		FRU_No,
		6,
		Format_Type_List,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Format_Version",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"From_Dash_No",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"From_Part_No",
		FRU_X,
		0,
		7,
		7,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"From_Serial_No",
		FRU_X,
		0,
		6,
		6,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Fru_Description",
		FRU_X,
		0,
		80,
		80,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Fru_DescriptionR",
		FRU_F,
		1,
		382,
		382,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		6,
		Fru_DescriptionR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Fru_Description_StringG",
		FRU_X,
		0,
		64,
		64,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Fru_Description_StringL",
		FRU_X,
		0,
		256,
		256,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Fru_Path",
		FRU_X,
		0,
		128,
		128,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Fru_Shortname",
		FRU_X,
		0,
		16,
		16,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Fru_Type",
		FRU_A,
		2,
		2,
		2,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_No,
		FRU_No,
		116,
		FRU_Type,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Geo_Alt",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Geo_East",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Geo_Location",
		FRU_X,
		0,
		40,
		40,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Geo_North",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"GrantMBox",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"HW_Dash_Level",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"HW_Data_R",
		FRU_A,
		2,
		4,
		4,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		2,
		HW_Data_R,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Hard_Errors",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Hardware_Revision",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Hazard_Class_Code",
		FRU_A,
		4,
		2,
		2,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Header_Checksum",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Highest",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Highest_Temp_Limit",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Histogram",
		FRU_X,
		0,
		24,
		192,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		10,
		FRU_Linear,
		""},
	{FRU_REVNO,
		"HostID0",
		FRU_B,
		12,
		4,
		4,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"HostID1",
		FRU_B,
		13,
		4,
		4,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"HoursAtFullSpeed",
		FRU_X,
		0,
		3,
		24,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"HoursAtHalfSpeed",
		FRU_X,
		0,
		3,
		24,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"HoursAtOne32ndSpeed",
		FRU_X,
		0,
		3,
		24,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"IPAddr",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"IPDiscovery",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"IPGateway",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"IPMIPartNo",
		FRU_X,
		0,
		25,
		25,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"IPMISerialNo",
		FRU_X,
		0,
		25,
		25,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"IPMI_BoardR",
		FRU_F,
		1,
		255,
		255,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		9,
		IPMI_BoardR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"IPMI_ChassisR",
		FRU_F,
		3,
		255,
		255,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		5,
		IPMI_ChassisR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"IPMI_Common_Header_S",
		FRU_X,
		0,
		8,
		8,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		8,
		IPMI_Common_Header_S,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"IPMI_PRIVATE176",
		FRU_F,
		1,
		176,
		176,
		FDTYPE_ByteArray,
		FDISP_Binary,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"IPMI_ProductR",
		FRU_F,
		2,
		255,
		255,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		10,
		IPMI_ProductR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"IPNetmask",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Initial_HW_Dash_Level",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Initial_HW_Rev_Level",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Initiator",
		FRU_X,
		0,
		1,
		1,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		17,
		Initiator_30,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"InstallationR",
		FRU_F,
		1,
		1099,
		1099,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		11,
		InstallationR,
		5,
		FRU_Circular,
		""},
	{FRU_REVNO,
		"Internal_Use_Area_Starting_Offset",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"JTAG_Info_Pointer",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Junction_Temp_Array",
		FRU_X,
		0,
		8,
		64,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"L2_BoardR",
		FRU_B,
		1,
		2,
		2,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		1,
		L2_BoardR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Lang_Code",
		FRU_X,
		0,
		1,
		1,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		28,
		IPMI_LangCode,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Language_Code",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		28,
		IPMI_LangCode,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Laser_Cum_Power_SummaryR",
		FRU_C,
		6,
		16,
		16,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		4,
		Laser_Cum_Power_SummaryR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Laser_Power_EventsR",
		FRU_F,
		2,
		254,
		254,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		2,
		Laser_Power_EventsR,
		50,
		FRU_Circular,
		""},
	{FRU_REVNO,
		"Laser_Power_SummaryR",
		FRU_C,
		5,
		16,
		16,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		4,
		Laser_Power_SummaryR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"LastHealthCheckDate",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Time,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"LastRechargeDate",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Time,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Last_Power_On",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Time,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Latest",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Lit_DBPR",
		FRU_E,
		1,
		60,
		60,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		6,
		Lit_DBPR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Location",
		FRU_X,
		0,
		80,
		80,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Loop_A_Name",
		FRU_X,
		0,
		32,
		32,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Loop_B_Name",
		FRU_X,
		0,
		32,
		32,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Lot_Code",
		FRU_X,
		0,
		12,
		12,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Lowest",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Lowest_Temp_Limit",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"MACADDR",
		FRU_X,
		0,
		6,
		48,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"MCNetIPSubnet",
		FRU_X,
		0,
		3,
		24,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"MCNetIPSubnetMask",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"MCNetOpaque",
		FRU_X,
		0,
		8,
		64,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"MCNet_ConfigR",
		FRU_C,
		1,
		15,
		15,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		3,
		MCNet_ConfigR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"MD_Bottom_IO_FanTrayR",
		FRU_B,
		2,
		4,
		4,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		3,
		MD_Bottom_IO_FanTrayR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"MD_CPU_Three_FanTrayR",
		FRU_B,
		3,
		4,
		4,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		3,
		MD_CPU_Three_FanTrayR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"MD_Top_FanTrayR",
		FRU_B,
		8,
		4,
		4,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		3,
		MD_Top_FanTrayR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"ME_Three_FanTrayR",
		FRU_B,
		4,
		4,
		4,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		3,
		ME_Three_FanTrayR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"MFG_DateTime",
		FRU_X,
		0,
		3,
		24,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"MaintenanceR",
		FRU_F,
		1,
		264,
		264,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		3,
		MaintenanceR,
		5,
		FRU_Circular,
		""},
	{FRU_REVNO,
		"ManR",
		FRU_F,
		1,
		183,
		183,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		9,
		ManR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Manufacture_Loc",
		FRU_X,
		0,
		64,
		64,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Manufacturer",
		FRU_X,
		0,
		50,
		50,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Manufacturer_Name",
		FRU_X,
		0,
		63,
		63,
		FDTYPE_ByteArray,
		FDISP_Binary,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Manufacturer_Name_Type_Length",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Marker",
		FRU_C,
		1,
		8,
		64,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"MasterSCEthernetAddr",
		FRU_X,
		0,
		6,
		48,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Max_Ambient_Temp",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Max_Bus_Speed",
		FRU_A,
		1,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Max_Power_Distribution",
		FRU_X,
		0,
		20,
		160,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		4,
		FRU_Linear,
		""},
	{FRU_REVNO,
		"Max_Power_Rating",
		FRU_X,
		0,
		20,
		160,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		4,
		FRU_Linear,
		""},
	{FRU_REVNO,
		"Memory_Size",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Message",
		FRU_X,
		0,
		128,
		128,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Message_32",
		FRU_X,
		0,
		32,
		32,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Message_Type",
		FRU_X,
		0,
		1,
		1,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		5,
		Message_Type,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Mfg_Date_Time",
		FRU_X,
		0,
		3,
		24,
		FDTYPE_Binary,
		FDISP_Time,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Microcode_Version",
		FRU_C,
		3,
		16,
		16,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Min_Bus_Speed",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Min_Power_Rating",
		FRU_X,
		0,
		20,
		160,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		4,
		FRU_Linear,
		""},
	{FRU_REVNO,
		"Netra_ACFirmwareR",
		FRU_C,
		1,
		31,
		31,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		7,
		Netra_ACFirmwareR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Netra_DMCFirmwareR",
		FRU_G,
		1,
		31,
		31,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		7,
		Netra_DMCFirmwareR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Network1R",
		FRU_C,
		2,
		21,
		21,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		7,
		Network1R,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"NetworkR",
		FRU_C,
		2,
		15,
		15,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		6,
		NetworkR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"New_Description",
		FRU_X,
		0,
		32,
		32,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"New_Serial_No",
		FRU_C,
		3,
		12,
		12,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"New_Status",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"New_Sun_Part_No",
		FRU_X,
		0,
		16,
		16,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"No_CPU_Fans",
		FRU_B,
		3,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Binary,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Num_CPU_Module_Slots",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Num_CPUs_in_Module",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Number_of_Updates",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"OEM_Record_Header_S",
		FRU_X,
		0,
		5,
		5,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		5,
		OEM_Record_Header_S,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"OTS_Man1R",
		FRU_X,
		0,
		240,
		240,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		17,
		OTS_Man1R,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"OTS_ManR",
		FRU_X,
		0,
		124,
		124,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		19,
		OTS_ManR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"OTS_ManR_Version",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Binary,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Old_Status",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"PROM_FirmwareR",
		FRU_C,
		4,
		9,
		9,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		2,
		PROM_FirmwareR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"PROM_Format_Version",
		FRU_E,
		2,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"PSU_Current",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"PSU_PVout1R",
		FRU_A,
		3,
		4,
		4,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		2,
		PSU_PVout1R,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"PSU_PVstby1R",
		FRU_A,
		4,
		4,
		4,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		2,
		PSU_PVstby1R,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"PSU_Voltage",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Parent_Dash_Level",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Parent_Part_Number",
		FRU_X,
		0,
		7,
		7,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Parent_Serial_Number",
		FRU_X,
		0,
		6,
		6,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"PartNumber_ChangedR",
		FRU_E,
		1,
		34,
		34,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		7,
		PartNumber_ChangedR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Partner_Part_Number",
		FRU_X,
		0,
		20,
		20,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Partner_Part_NumberR",
		FRU_C,
		1,
		22,
		22,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		2,
		Partner_Part_NumberR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Pdu1_Label",
		FRU_X,
		0,
		6,
		6,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Pdu2_Label",
		FRU_X,
		0,
		6,
		6,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"PlatformId",
		FRU_A,
		3,
		2,
		2,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		14,
		Platform_Type,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"PlatformR",
		FRU_C,
		2,
		24,
		24,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		2,
		PlatformR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Platform_Name",
		FRU_C,
		3,
		20,
		20,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Power_EventsR",
		FRU_F,
		1,
		254,
		254,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		2,
		Power_EventsR,
		50,
		FRU_Circular,
		""},
	{FRU_REVNO,
		"Power_On_DataR",
		FRU_X,
		0,
		8,
		8,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		2,
		Power_On_DataR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Power_On_Minutes",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Time,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Power_SummaryR",
		FRU_C,
		2,
		16,
		16,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		4,
		Power_SummaryR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Power_Supply_Cfg",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Power_Type",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"ProductCustom_MfgInfo",
		FRU_X,
		0,
		83,
		83,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"ProductName",
		FRU_X,
		0,
		25,
		25,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"ProductVersion",
		FRU_X,
		0,
		10,
		10,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Product_Area_Format_Version",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Product_Area_Length",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Product_Info_Area_Checksum",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Product_Info_Area_S",
		FRU_X,
		0,
		165,
		165,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		22,
		Product_Info_Area_S,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Product_Info_Area_Starting_Offset",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Product_Name",
		FRU_X,
		0,
		16,
		16,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Product_Name_Type_Length",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Product_Part_Model_Number",
		FRU_X,
		0,
		7,
		56,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Product_Part_Model_Number_Type_Length",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Product_Serial_Number",
		FRU_X,
		0,
		30,
		30,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Product_Serial_Number_Type_Length",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Product_Version",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Product_Version_Type_Length",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Program_Vendor_ID",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Binary,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Program_Vendor_ID_Code",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Program_Vendor_ID_Code_Source",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		1,
		Program_Vendor_ID_Source_List,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Program_Vendor_ID_Source",
		FRU_X,
		0,
		1,
		1,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_No,
		FRU_No,
		1,
		Program_Vendor_ID_Source_List,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Program_Vendor_Name_And_Site_Location",
		FRU_X,
		0,
		64,
		64,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Properties",
		FRU_X,
		0,
		48,
		48,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Psuslot1_Label",
		FRU_X,
		0,
		6,
		6,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Psuslot2_Label",
		FRU_X,
		0,
		6,
		6,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"RAM",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Record_Checksum",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Record_Length",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Record_Type_ID",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"RefreshCycle",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Binary,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Repair_DetailR",
		FRU_F,
		1,
		884,
		884,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		10,
		Repair_DetailR,
		5,
		FRU_Circular,
		""},
	{FRU_REVNO,
		"Repair_Location",
		FRU_X,
		0,
		24,
		24,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Repair_SummaryR",
		FRU_B,
		1,
		6,
		6,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		3,
		Repair_SummaryR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Repair_Update",
		FRU_E,
		1,
		14,
		14,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		5,
		Repair_Update,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Repair_Vendor",
		FRU_X,
		0,
		16,
		16,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Repair_Vendor_old",
		FRU_X,
		0,
		15,
		15,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"ReqMBox",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Reserved",
		FRU_X,
		0,
		32,
		32,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Reserved_24",
		FRU_X,
		0,
		24,
		24,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Reserved_Data",
		FRU_X,
		0,
		64,
		64,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Rmmslot_Label",
		FRU_X,
		0,
		6,
		6,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SG_BoardParameterR",
		FRU_E,
		4,
		30,
		30,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		2,
		SG_BoardParameterR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SG_Bootbus_Timing",
		FRU_X,
		0,
		28,
		224,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		6,
		FRU_Linear,
		""},
	{FRU_REVNO,
		"SG_CPUSpeedR",
		FRU_E,
		0,
		40,
		40,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		8,
		SG_CPUSpeedR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SG_CenterplaneR",
		FRU_E,
		4,
		38,
		38,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		7,
		SG_CenterplaneR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SG_Cpu_Sparc_Freq",
		FRU_B,
		2,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SG_FanTrayR",
		FRU_B,
		9,
		4,
		4,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		3,
		SG_FanTrayR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SG_HostIdR",
		FRU_E,
		1,
		24,
		24,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		6,
		SG_HostIdR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SG_HostId_A",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SG_HostId_B",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SG_HostId_C",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SG_HostId_D",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SG_HostId_SC0",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SG_HostId_SC1",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SG_PowerSupplyR",
		FRU_C,
		1,
		14,
		14,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		12,
		SG_PowerSupplyR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SN_Format",
		FRU_X,
		0,
		20,
		20,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD1_R",
		FRU_F,
		2,
		128,
		128,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		22,
		SPD1_R,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Access_Time",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Assembly_Serial_No",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Burst_Length_Support",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Bytes_Written_SPDMemory",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_CAS_Latencies",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_CRC16",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Column_Address_Bits",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Cycle_Time",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_DDR2_R",
		FRU_X,
		0,
		128,
		128,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		22,
		SPD_DDR2_R,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_DDR3_R",
		FRU_X,
		0,
		176,
		176,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		18,
		SPD_DDR3_R,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_DDR3_Specific",
		FRU_X,
		0,
		109,
		109,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_DIMM_Config_Type",
		FRU_X,
		0,
		1,
		1,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_No,
		FRU_No,
		3,
		SPD_Err_Detect,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Data_Edition_Code",
		FRU_X,
		0,
		1,
		1,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Data_Revision_Code",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Data_Sig_Input_Hold_Time",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Data_Sig_Input_Setup_Time",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Data_Width_Module",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Density_And_Banks",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Device_Attrib_CAS",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Device_Attrib_CS",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Device_Attrib_Gen",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Device_Attrib_Write",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq0",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq1",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq10",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq100",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq101",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq102",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq103",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq104",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq105",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq106",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq107",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq108",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq109",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq11",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq110",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq111",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq112",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq113",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq114",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq115",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq116",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq117",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq118",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq119",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq12",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq120",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq121",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq122",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq123",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq124",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq125",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq126",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq127",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq128",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq129",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq13",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq130",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq131",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq132",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq133",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq134",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq135",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq136",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq137",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq138",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq139",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq14",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq140",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq141",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq142",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq143",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq15",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq16",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq17",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq18",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq19",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq2",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq20",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq20Dq142",
		FRU_X,
		0,
		492,
		3936,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq21",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq22",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq23",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq24",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq25",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq26",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq27",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq28",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq29",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq3",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq30",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq31",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq32",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq33",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq34",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq35",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq36",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq37",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq38",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq39",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq4",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq40",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq41",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq42",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq43",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq44",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq45",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq46",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq47",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq48",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq49",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq5",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq50",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq51",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq52",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq53",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq54",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq55",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq56",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq57",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq58",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq59",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq6",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq60",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq61",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq62",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq63",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq64",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq65",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq66",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq67",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq68",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq69",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq7",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq70",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq71",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq72",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq73",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq74",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq75",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq76",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq77",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq78",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq79",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq8",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq80",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq81",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq82",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq83",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq84",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq85",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq86",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq87",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq88",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq89",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq9",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq90",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq91",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq92",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq93",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq94",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq95",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq96",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq97",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq98",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Edge_Connect_Sig_Dq99",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Error_Check_SDRAM_Width",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_FBDIMM_R",
		FRU_X,
		0,
		176,
		176,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		18,
		SPD_FBDIMM_R,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_FBDIMM_Specific",
		FRU_X,
		0,
		109,
		109,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Format_Version",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Fund_Memory_Type",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Fundamental_Memory_Type",
		FRU_X,
		0,
		1,
		1,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_No,
		FRU_No,
		10,
		SPD_Memory_Type,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Man_Loc",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Man_Rev_Code_Comp",
		FRU_X,
		0,
		1,
		1,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Man_Rev_Code_Pcb",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Man_Specific",
		FRU_X,
		0,
		29,
		29,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Man_Specific1",
		FRU_X,
		0,
		26,
		26,
		FDTYPE_ByteArray,
		FDISP_Binary,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Manufacture_Date_Week",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Manufacture_Date_Year",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Manufacture_Week",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Manufacture_Year",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Manufacturer_Part_No",
		FRU_X,
		0,
		18,
		18,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Manufacturing_Date",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Max_Access_Time_CL1tSAC1",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Max_Access_Time_CL2tSAC2",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Min_Clock_Delay",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Min_Cycle_Time_CL1tCC1",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Min_Cycle_Time_CL2tCC2",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Min_RAS_To_CAS_Delay",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Min_Ras_Pulse_Width",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Min_Row_Delay",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Min_Row_Precharge_Time",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Mod_Data_Width",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Mod_Voltage_Interface",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Mode_Register_Data_1",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Mode_Register_Data_2",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Module_Attrib",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Module_Bank_Density",
		FRU_X,
		0,
		1,
		1,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		5,
		SPD_Module_Bank_Density_110,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Module_Config_Type",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Module_Data_Width",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Module_Freq",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Module_Organization",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Module_Physical_Attributes",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Module_Rev_Code",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Module_Serial_Number",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Module_Type",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Module_Type_Thickness",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_No_Banks_Assembly",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_No_Banks_SDRAM_Device",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Old_Assembly_Serial_No",
		FRU_X,
		0,
		3,
		24,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Old_Man_Code",
		FRU_X,
		0,
		8,
		64,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Old_Man_Loc",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Old_Sun_Module_Label_Info",
		FRU_X,
		0,
		8,
		64,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Old_Sun_Part_No",
		FRU_X,
		0,
		5,
		40,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_ParametersR",
		FRU_F,
		2,
		768,
		768,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		208,
		SPD_ParametersR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Primary_SDRAM_Width",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_R",
		FRU_E,
		1,
		123,
		123,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		22,
		SPD_R,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Refresh_RateType",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Reserved",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Row_Address_Bits",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_SDRAM_Addressing",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_SDRAM_Vendor_Name",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_No,
		FRU_No,
		746,
		Vendor,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Sig_Input_Hold_Time",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Sig_Input_Setup_Time",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Sun_Copyright",
		FRU_X,
		0,
		16,
		16,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Sun_Mod_Cycle_Time",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Sun_Mod_Cycle_Time_TOH",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Sun_Mod_Label_Info",
		FRU_X,
		0,
		15,
		15,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Sun_Mod_Power_Parm_2",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Sun_Module_Power_Parm",
		FRU_X,
		0,
		1,
		1,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		3,
		SPD_Sun_Mod_Power_Parm_111,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Sun_Serial_No",
		FRU_X,
		0,
		9,
		9,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Synthesized_Serial_Number",
		FRU_X,
		0,
		9,
		9,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_Yes,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_TSHZ_Max_Nbrs_CAS_Lat",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_TSLZ_CLK_To_Output",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_TotBytes_SPDMemory",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Type_Specific",
		FRU_X,
		0,
		50,
		50,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SPD_Version",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SP_FanTrayR",
		FRU_B,
		7,
		4,
		4,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		3,
		SP_FanTrayR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SRAM_Manufacturer",
		FRU_B,
		5,
		2,
		2,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_No,
		FRU_No,
		746,
		Vendor,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SRAM_Size",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SRAM_Speed",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SSN_Rule",
		FRU_X,
		0,
		1,
		1,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		3,
		SSN_Rule_List,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SUN_PN",
		FRU_X,
		0,
		7,
		7,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SUN_SN",
		FRU_X,
		0,
		30,
		30,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Safari_DIMM_Mapping_Pointer",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Scbslot_Label",
		FRU_X,
		0,
		6,
		6,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Segment_Trailer",
		FRU_A,
		1,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sensor",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Serial_Number_Format",
		FRU_X,
		0,
		20,
		20,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sheffield_Bridge_FirmwareR",
		FRU_C,
		3,
		9,
		9,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		2,
		Sheffield_Bridge_FirmwareR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sheffield_Fixed_Hardware",
		FRU_X,
		0,
		6,
		6,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sheffield_RCP_FirmwareR",
		FRU_C,
		2,
		9,
		9,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		2,
		Sheffield_RCP_FirmwareR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sheffield_SideA_Hardware",
		FRU_X,
		0,
		6,
		6,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sheffield_SideB_Hardware",
		FRU_X,
		0,
		6,
		6,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sheffield_Split_ModeR",
		FRU_C,
		1,
		27,
		27,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		6,
		Sheffield_Split_ModeR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sheffield_Split_Mode_Flags",
		FRU_X,
		0,
		1,
		1,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"ShelfLife",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Binary,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Shutdown_Temperature",
		FRU_B,
		2,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SlaveSCEthernetAddr",
		FRU_X,
		0,
		6,
		48,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Slot_Mode",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Soft_Errors",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Soft_ErrorsR",
		FRU_F,
		1,
		324,
		324,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		4,
		Soft_ErrorsR,
		20,
		FRU_Circular,
		""},
	{FRU_REVNO,
		"Softerror_Code",
		FRU_X,
		0,
		1,
		1,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		13,
		Error_Code,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Spare_49bytes",
		FRU_X,
		0,
		49,
		49,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Spare_64bytes",
		FRU_X,
		0,
		64,
		64,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Spare_7bytes",
		FRU_X,
		0,
		7,
		56,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Spare_8bytes",
		FRU_X,
		0,
		8,
		64,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sparse_Elements",
		FRU_X,
		0,
		256,
		256,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SpecPartNo",
		FRU_C,
		1,
		11,
		11,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Status",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"StatusMap127",
		FRU_X,
		0,
		127,
		127,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"StatusMap2",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"StatusMap31",
		FRU_X,
		0,
		31,
		31,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Status_CurrentR",
		FRU_B,
		1,
		5,
		5,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		2,
		Status_CurrentR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Status_EventsR",
		FRU_F,
		1,
		1404,
		1404,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		7,
		Status_EventsR,
		10,
		FRU_Circular,
		""},
	{FRU_REVNO,
		"Status_Proxy1R",
		FRU_E,
		1,
		36,
		36,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		3,
		Status_Proxy1R,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Status_Proxy2R",
		FRU_F,
		1,
		132,
		132,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		3,
		Status_Proxy2R,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Status_Proxy3R",
		FRU_A,
		2,
		7,
		7,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		3,
		Status_Proxy3R,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Status_Proxy_SparseR",
		FRU_F,
		1,
		261,
		261,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		3,
		Status_Proxy_SparseR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"StickClock",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sun_Certification",
		FRU_X,
		0,
		14,
		14,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sun_DashNumber",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sun_Fru_Description",
		FRU_X,
		0,
		30,
		30,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sun_Fru_Shortname",
		FRU_X,
		0,
		16,
		16,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sun_Fru_Type",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		116,
		FRU_Type,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sun_Hazard_Class_Code",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sun_Key_Code",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sun_Man1R",
		FRU_F,
		1,
		191,
		191,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		13,
		Sun_Man1R,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sun_ManR",
		FRU_F,
		1,
		136,
		136,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		15,
		Sun_ManR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sun_PartNumber",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sun_Part_Dash_Rev",
		FRU_X,
		0,
		6,
		48,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sun_Part_No",
		FRU_X,
		0,
		7,
		7,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sun_Part_Number",
		FRU_X,
		0,
		7,
		7,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sun_Part_Number_DataR",
		FRU_C,
		1,
		21,
		21,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		5,
		Sun_Part_Number_DataR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sun_RevNumber",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sun_SPD_DIMMR",
		FRU_X,
		0,
		80,
		80,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		9,
		Sun_SPD_DIMMR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sun_SPD_DataR",
		FRU_C,
		2,
		27,
		27,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		5,
		Sun_SPD_DataR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sun_Serial_No",
		FRU_X,
		0,
		6,
		6,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sun_Serial_Number",
		FRU_X,
		0,
		30,
		30,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Sun_SpecPartNo",
		FRU_X,
		0,
		11,
		11,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Symptom_Code",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		208,
		Repair_Sympton_Code,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Syndrome",
		FRU_X,
		0,
		10,
		10,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Synthesized_Serial_Number_Rule",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		3,
		SSN_Rule_List,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"SystemLocation",
		FRU_E,
		2,
		80,
		80,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"System_Id",
		FRU_X,
		0,
		20,
		20,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"System_Serial",
		FRU_C,
		2,
		20,
		20,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"System_Tz",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Tacho_Pulses_Per_Rev",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Temperature_ExcessR",
		FRU_C,
		5,
		8,
		8,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		2,
		Temperature_ExcessR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Temperature_HistoryR",
		FRU_E,
		1,
		32,
		32,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		6,
		Temperature_HistoryR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Temperature_LimitsR",
		FRU_B,
		4,
		2,
		2,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		2,
		Temperature_LimitsR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Temporary_FMA_Data",
		FRU_X,
		0,
		32,
		32,
		FDTYPE_ByteArray,
		FDISP_Hex,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Test_Cycles",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Test_Failures",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Test_Max_Temp",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Test_Tester_Id",
		FRU_X,
		0,
		1,
		1,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Test_Version",
		FRU_X,
		0,
		8,
		8,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Text_32",
		FRU_X,
		0,
		32,
		32,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Time_Above",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Time_Below",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"To_Dash_No",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"To_Part_No",
		FRU_X,
		0,
		7,
		7,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"To_Serial_No",
		FRU_X,
		0,
		6,
		6,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"ToeTagMessage",
		FRU_E,
		1,
		80,
		80,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Total_Errors",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Total_Inserts",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Total_Power_Offs",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Total_Power_Ons",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Total_Power_Ons_old",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Total_Repairs",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Total_Returns",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Total_Time_On",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"UNIX_Timestamp32",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Time,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"UNIX_Timestamp64",
		FRU_X,
		0,
		8,
		64,
		FDTYPE_Binary,
		FDISP_Time,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"UNKNOWN",
		FRU_X,
		0,
		0,
		0,
		FDTYPE_UNDEFINED,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"UUID",
		FRU_X,
		0,
		16,
		16,
		FDTYPE_ByteArray,
		FDISP_UUID,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"UsageR",
		FRU_E,
		1,
		20,
		20,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_No,
		6,
		UsageR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"User_Label",
		FRU_X,
		0,
		10,
		10,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"V1_CUR_Shutdown_High_Line",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"V1_CUR_Shutdown_Low_Line",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"V1_CUR_Warning_High_Line",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"V1_CUR_Warning_Low_Line",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"V1_Power_Rating_High_Line",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"V1_Power_Rating_Low_Line",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"V1_VLT_Over_Shutdown",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"V1_VLT_Over_Warning",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"V1_VLT_Under_Shutdown",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"V1_VLT_Under_Warning",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Vendor_ID",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Binary,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Vendor_ID_Code",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Vendor_ID_Code_Source",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		1,
		Vendor_ID_Source_List,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Vendor_ID_Source",
		FRU_X,
		0,
		1,
		1,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_No,
		FRU_No,
		1,
		Vendor_ID_Source_List,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Vendor_Name",
		FRU_X,
		0,
		2,
		2,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_No,
		FRU_No,
		746,
		Vendor,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Vendor_Name_And_Site_Description",
		FRU_X,
		0,
		30,
		30,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Vendor_Name_And_Site_Location",
		FRU_X,
		0,
		64,
		64,
		FDTYPE_ASCII,
		FDISP_String,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Vendor_Name_Fill",
		FRU_X,
		0,
		6,
		48,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Vendor_Site_ID",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Binary,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Vendor_Site_ID_Source",
		FRU_X,
		0,
		1,
		1,
		FDTYPE_Enumeration,
		FDISP_String,
		FRU_Yes,
		FRU_Yes,
		1,
		Vendor_Site_ID_Source_List,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Version",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Voltage_Rails",
		FRU_X,
		0,
		12,
		96,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		4,
		FRU_Linear,
		""},
	{FRU_REVNO,
		"WCI_A_Rcalibrated",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"WCI_B_Rcalibrated",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"WCI_CalibrationR",
		FRU_C,
		6,
		8,
		8,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_No,
		FRU_Yes,
		4,
		WCI_CalibrationR,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"WCI_Tcalibrated",
		FRU_X,
		0,
		2,
		16,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"WC_Max_WCI_Temp",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"WC_Min_WCI_Temp",
		FRU_X,
		0,
		1,
		8,
		FDTYPE_Binary,
		FDISP_Decimal,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"WWN",
		FRU_C,
		3,
		8,
		64,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"WarrantyDuration",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Binary,
		FRU_No,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"WarrantyStartDate",
		FRU_X,
		0,
		4,
		32,
		FDTYPE_Binary,
		FDISP_Time,
		FRU_Yes,
		FRU_Yes,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""},
	{FRU_REVNO,
		"Wildcat_IO_DIMM_Lot",
		FRU_E,
		1,
		124,
		124,
		FDTYPE_Record,
		FDISP_UNDEFINED,
		FRU_Yes,
		FRU_Yes,
		1,
		Wildcat_IO_DIMM_Lot,
		10,
		FRU_Linear,
		""},
	{FRU_REVNO,
		"Zeros_Pad",
		FRU_X,
		0,
		7,
		56,
		FDTYPE_Binary,
		FDISP_Hex,
		FRU_No,
		FRU_No,
		0,
		NULL,
		0,
		FRU_NOT_ITERATED,
		""}
};
