#!/usr/bin/ksh93

#
# CDDL HEADER START
#
# The contents of this file are subject to the terms of the
# Common Development and Distribution License (the "License").
# You may not use this file except in compliance with the License.
#
# You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
# or http://www.opensolaris.org/os/licensing.
# See the License for the specific language governing permissions
# and limitations under the License.
#
# When distributing Covered Code, include this CDDL HEADER in each
# file and include the License file at usr/src/OPENSOLARIS.LICENSE.
# If applicable, add the following below this CDDL HEADER, with the
# fields enclosed by brackets "[]" replaced with your own identifying
# information: Portions Copyright [yyyy] [name of copyright owner]
#
# CDDL HEADER END
#

#
# Copyright 2009 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#

# Solaris needs /usr/xpg6/bin:/usr/xpg4/bin because the tools in /usr/bin are not POSIX-conformant
export PATH=/usr/xpg6/bin:/usr/xpg4/bin:/bin:/usr/bin

# Make sure all math stuff runs in the "C" locale to avoid problems
# with alternative # radix point representations (e.g. ',' instead of
# '.' in de_DE.*-locales). This needs to be set _before_ any
# floating-point constants are defined in this script).
if [[ "${LC_ALL}" != "" ]] ; then
    export \
        LC_MONETARY="${LC_ALL}" \
        LC_MESSAGES="${LC_ALL}" \
        LC_COLLATE="${LC_ALL}" \
        LC_CTYPE="${LC_ALL}"
        unset LC_ALL
fi
export LC_NUMERIC=C

function fatal_error
{
	print -u2 "${progname}: $*"
	exit 1
}

function beep
{
	tput bel
	return 0
}

# array which holds frequency and sample data 
# (the data are created on demand, "sample_set" indicates whether the "sample" variable
# needs to be filled or not)
compound -A tones=(
	["C3"]=(  float freq=261.63  ; typeset sample_set="false" ; typeset -b sample )
	["C#3"]=( float freq=277.18  ; typeset sample_set="false" ; typeset -b sample )
	["D3"]=(  float freq=293.66  ; typeset sample_set="false" ; typeset -b sample )
	["D#3"]=( float freq=311.13  ; typeset sample_set="false" ; typeset -b sample )
	["E3"]=(  float freq=329.63  ; typeset sample_set="false" ; typeset -b sample )
	["F3"]=(  float freq=349.23  ; typeset sample_set="false" ; typeset -b sample )
	["F#3"]=( float freq=369.99  ; typeset sample_set="false" ; typeset -b sample )
	["G3"]=(  float freq=391.99  ; typeset sample_set="false" ; typeset -b sample )
	["G#3"]=( float freq=415.31  ; typeset sample_set="false" ; typeset -b sample )
	["A3"]=(  float freq=440.00  ; typeset sample_set="false" ; typeset -b sample )
	["A#3"]=( float freq=466.16  ; typeset sample_set="false" ; typeset -b sample )
	["B3"]=(  float freq=493.88  ; typeset sample_set="false" ; typeset -b sample )
	["C4"]=(  float freq=523.25  ; typeset sample_set="false" ; typeset -b sample )
	["C#4"]=( float freq=554.37  ; typeset sample_set="false" ; typeset -b sample )
	["D4"]=(  float freq=587.33  ; typeset sample_set="false" ; typeset -b sample )
	["D#4"]=( float freq=622.25  ; typeset sample_set="false" ; typeset -b sample )
	["E4"]=(  float freq=659.26  ; typeset sample_set="false" ; typeset -b sample )
	["F4"]=(  float freq=698.46  ; typeset sample_set="false" ; typeset -b sample )
	["F#4"]=( float freq=739.99  ; typeset sample_set="false" ; typeset -b sample )
	["G4"]=(  float freq=783.99  ; typeset sample_set="false" ; typeset -b sample )
	["G#4"]=( float freq=830.61  ; typeset sample_set="false" ; typeset -b sample )
	["A4"]=(  float freq=880.00  ; typeset sample_set="false" ; typeset -b sample )
	["A#4"]=( float freq=932.32  ; typeset sample_set="false" ; typeset -b sample )
	["B4"]=(  float freq=987.77  ; typeset sample_set="false" ; typeset -b sample )
	["C5"]=(  float freq=1046.5  ; typeset sample_set="false" ; typeset -b sample )

	# dummy entry for pause
	["p"]=(   float freq=NaN     ; typeset sample_set="false" ; typeset -b sample )
)

# alias table which translates the various names of "notes" to the matching entry
# in the "tones" table
compound -r -A notes=(
	["C3"]=(  val=tones["C3"]   ) ["key_d"]=(  val=tones["C3"]   )
	["C#3"]=( val=tones["C#3"]  ) ["key_r"]=(  val=tones["C#3"]  )
	["D3"]=(  val=tones["D3"]   ) ["key_f"]=(  val=tones["D3"]   )
	["D#3"]=( val=tones["D#3"]  ) ["key_t"]=(  val=tones["D#3"]  )
	["E3"]=(  val=tones["E3"]   ) ["key_g"]=(  val=tones["E3"]   )
	["F3"]=(  val=tones["F3"]   ) ["key_h"]=(  val=tones["F3"]   )
	["F#3"]=( val=tones["F#3"]  ) ["key_u"]=(  val=tones["F#3"]  )
	["G3"]=(  val=tones["G3"]   ) ["key_j"]=(  val=tones["G3"]   )
	["G#3"]=( val=tones["G#3"]  ) ["key_i"]=(  val=tones["G#3"]  )
	["A3"]=(  val=tones["A3"]   ) ["key_k"]=(  val=tones["A3"]   )
	["A#3"]=( val=tones["A#3"]  ) ["key_o"]=(  val=tones["A#3"]  )
	["B3"]=(  val=tones["B3"]   ) ["key_l"]=(  val=tones["B3"]   )
	["C4"]=(  val=tones["C4"]   ) ["key_D"]=(  val=tones["C4"]   )
	["C#4"]=( val=tones["C#4"]  ) ["key_R"]=(  val=tones["C#4"]  )
	["D4"]=(  val=tones["D4"]   ) ["key_F"]=(  val=tones["D4"]   )
	["D#4"]=( val=tones["D#4"]  ) ["key_T"]=(  val=tones["D#4"]  )
	["E4"]=(  val=tones["E4"]   ) ["key_G"]=(  val=tones["E4"]   )
	["F4"]=(  val=tones["F4"]   ) ["key_H"]=(  val=tones["F4"]   )
	["F#4"]=( val=tones["F#4"]  ) ["key_U"]=(  val=tones["F#4"]  )
	["G4"]=(  val=tones["G4"]   ) ["key_J"]=(  val=tones["G4"]   )
	["G#4"]=( val=tones["G#4"]  ) ["key_I"]=(  val=tones["G#4"]  )
	["A4"]=(  val=tones["A4"]   ) ["key_K"]=(  val=tones["A4"]   )
	["A#4"]=( val=tones["A#4"]  ) ["key_O"]=(  val=tones["A#4"]  )
	["B4"]=(  val=tones["B4"]   ) ["key_L"]=(  val=tones["B4"]   )
	["C5"]=(  val=tones["C5"]   )
)

# array used to convert a 14-bit unsigned PCM value to 
# inverted 8-bit u-law
# (values were "stolen" from usr/src/cmd/audio/utilities/g711.c
integer -r -a audio_pcmulinear14bittoulaw8bit=(
	0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00
	0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00
	0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00
	0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00
	0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00
	0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00
	0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00
	0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00
	0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00
	0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00
	0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00
	0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00
	0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00
	0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00
	0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00
	0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00
	0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00
	0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00
	0x00 0x00 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01
	0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01
	0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01
	0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01
	0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01
	0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01
	0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01
	0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01
	0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01
	0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01
	0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01
	0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01
	0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01
	0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01
	0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01
	0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01
	0x01 0x01 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02
	0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02
	0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02
	0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02
	0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02
	0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02
	0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02
	0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02
	0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02
	0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02
	0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02
	0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02
	0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02
	0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02
	0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02
	0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02
	0x02 0x02 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03
	0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03
	0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03
	0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03
	0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03
	0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03
	0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03
	0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03
	0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03
	0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03
	0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03
	0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03
	0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03
	0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03
	0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03
	0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03 0x03
	0x03 0x03 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04
	0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04
	0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04
	0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04
	0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04
	0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04
	0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04
	0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04
	0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04
	0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04
	0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04
	0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04
	0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04
	0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04
	0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04
	0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04 0x04
	0x04 0x04 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05
	0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05
	0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05
	0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05
	0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05
	0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05
	0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05
	0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05
	0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05
	0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05
	0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05
	0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05
	0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05
	0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05
	0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05
	0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05 0x05
	0x05 0x05 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06
	0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06
	0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06
	0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06
	0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06
	0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06
	0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06
	0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06
	0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06
	0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06
	0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06
	0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06
	0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06
	0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06
	0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06
	0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06 0x06
	0x06 0x06 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07
	0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07
	0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07
	0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07
	0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07
	0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07
	0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07
	0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07
	0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07
	0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07
	0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07
	0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07
	0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07
	0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07
	0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07
	0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07 0x07
	0x07 0x07 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08
	0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08
	0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08
	0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08
	0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08
	0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08
	0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08
	0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08
	0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08
	0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08
	0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08
	0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08
	0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08
	0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08
	0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08
	0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08 0x08
	0x08 0x08 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09
	0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09
	0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09
	0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09
	0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09
	0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09
	0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09
	0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09
	0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09
	0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09
	0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09
	0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09
	0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09
	0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09
	0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09
	0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09 0x09
	0x09 0x09 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a
	0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a
	0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a
	0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a
	0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a
	0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a
	0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a
	0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a
	0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a
	0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a
	0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a
	0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a
	0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a
	0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a
	0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a
	0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a 0x0a
	0x0a 0x0a 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b
	0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b
	0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b
	0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b
	0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b
	0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b
	0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b
	0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b
	0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b
	0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b
	0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b
	0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b
	0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b
	0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b
	0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b
	0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b 0x0b
	0x0b 0x0b 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c
	0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c
	0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c
	0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c
	0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c
	0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c
	0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c
	0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c
	0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c
	0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c
	0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c
	0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c
	0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c
	0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c
	0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c
	0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c 0x0c
	0x0c 0x0c 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d
	0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d
	0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d
	0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d
	0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d
	0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d
	0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d
	0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d
	0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d
	0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d
	0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d
	0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d
	0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d
	0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d
	0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d
	0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d 0x0d
	0x0d 0x0d 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e
	0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e
	0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e
	0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e
	0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e
	0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e
	0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e
	0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e
	0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e
	0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e
	0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e
	0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e
	0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e
	0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e
	0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e
	0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e 0x0e
	0x0e 0x0e 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f
	0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f
	0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f
	0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f
	0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f
	0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f
	0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f
	0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f
	0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f
	0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f
	0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f
	0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f
	0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f
	0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f
	0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f
	0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f 0x0f
	0x0f 0x0f 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10
	0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10
	0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10
	0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10
	0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10
	0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10
	0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10
	0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10
	0x10 0x10 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11
	0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11
	0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11
	0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11
	0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11
	0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11
	0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11
	0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11 0x11
	0x11 0x11 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12
	0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12
	0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12
	0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12
	0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12
	0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12
	0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12
	0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12 0x12
	0x12 0x12 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13
	0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13
	0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13
	0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13
	0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13
	0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13
	0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13
	0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13 0x13
	0x13 0x13 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14
	0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14
	0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14
	0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14
	0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14
	0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14
	0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14
	0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14 0x14
	0x14 0x14 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15
	0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15
	0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15
	0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15
	0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15
	0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15
	0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15
	0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15 0x15
	0x15 0x15 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16
	0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16
	0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16
	0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16
	0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16
	0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16
	0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16
	0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16 0x16
	0x16 0x16 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17
	0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17
	0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17
	0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17
	0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17
	0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17
	0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17
	0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17 0x17
	0x17 0x17 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18
	0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18
	0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18
	0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18
	0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18
	0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18
	0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18
	0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18 0x18
	0x18 0x18 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19
	0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19
	0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19
	0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19
	0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19
	0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19
	0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19
	0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19 0x19
	0x19 0x19 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a
	0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a
	0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a
	0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a
	0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a
	0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a
	0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a
	0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a 0x1a
	0x1a 0x1a 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b
	0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b
	0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b
	0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b
	0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b
	0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b
	0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b
	0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b 0x1b
	0x1b 0x1b 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c
	0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c
	0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c
	0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c
	0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c
	0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c
	0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c
	0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c 0x1c
	0x1c 0x1c 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d
	0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d
	0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d
	0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d
	0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d
	0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d
	0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d
	0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d 0x1d
	0x1d 0x1d 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e
	0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e
	0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e
	0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e
	0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e
	0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e
	0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e
	0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e 0x1e
	0x1e 0x1e 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f
	0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f
	0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f
	0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f
	0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f
	0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f
	0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f
	0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f 0x1f
	0x1f 0x1f 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20
	0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20
	0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20
	0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20 0x20
	0x20 0x20 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21
	0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21
	0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21
	0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21 0x21
	0x21 0x21 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22
	0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22
	0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22
	0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22 0x22
	0x22 0x22 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23
	0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23
	0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23
	0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23 0x23
	0x23 0x23 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24
	0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24
	0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24
	0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24 0x24
	0x24 0x24 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25
	0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25
	0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25
	0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25 0x25
	0x25 0x25 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26
	0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26
	0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26
	0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26 0x26
	0x26 0x26 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27
	0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27
	0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27
	0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27 0x27
	0x27 0x27 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28
	0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28
	0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28
	0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28 0x28
	0x28 0x28 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29
	0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29
	0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29
	0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29 0x29
	0x29 0x29 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a
	0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a
	0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a
	0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a 0x2a
	0x2a 0x2a 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b
	0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b
	0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b
	0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b 0x2b
	0x2b 0x2b 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c
	0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c
	0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c
	0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c 0x2c
	0x2c 0x2c 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d
	0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d
	0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d
	0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d 0x2d
	0x2d 0x2d 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e
	0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e
	0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e
	0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e 0x2e
	0x2e 0x2e 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f
	0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f
	0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f
	0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f 0x2f
	0x2f 0x2f 0x30 0x30 0x30 0x30 0x30 0x30 0x30 0x30 0x30 0x30 0x30 0x30 0x30 0x30
	0x30 0x30 0x30 0x30 0x30 0x30 0x30 0x30 0x30 0x30 0x30 0x30 0x30 0x30 0x30 0x30
	0x30 0x30 0x31 0x31 0x31 0x31 0x31 0x31 0x31 0x31 0x31 0x31 0x31 0x31 0x31 0x31
	0x31 0x31 0x31 0x31 0x31 0x31 0x31 0x31 0x31 0x31 0x31 0x31 0x31 0x31 0x31 0x31
	0x31 0x31 0x32 0x32 0x32 0x32 0x32 0x32 0x32 0x32 0x32 0x32 0x32 0x32 0x32 0x32
	0x32 0x32 0x32 0x32 0x32 0x32 0x32 0x32 0x32 0x32 0x32 0x32 0x32 0x32 0x32 0x32
	0x32 0x32 0x33 0x33 0x33 0x33 0x33 0x33 0x33 0x33 0x33 0x33 0x33 0x33 0x33 0x33
	0x33 0x33 0x33 0x33 0x33 0x33 0x33 0x33 0x33 0x33 0x33 0x33 0x33 0x33 0x33 0x33
	0x33 0x33 0x34 0x34 0x34 0x34 0x34 0x34 0x34 0x34 0x34 0x34 0x34 0x34 0x34 0x34
	0x34 0x34 0x34 0x34 0x34 0x34 0x34 0x34 0x34 0x34 0x34 0x34 0x34 0x34 0x34 0x34
	0x34 0x34 0x35 0x35 0x35 0x35 0x35 0x35 0x35 0x35 0x35 0x35 0x35 0x35 0x35 0x35
	0x35 0x35 0x35 0x35 0x35 0x35 0x35 0x35 0x35 0x35 0x35 0x35 0x35 0x35 0x35 0x35
	0x35 0x35 0x36 0x36 0x36 0x36 0x36 0x36 0x36 0x36 0x36 0x36 0x36 0x36 0x36 0x36
	0x36 0x36 0x36 0x36 0x36 0x36 0x36 0x36 0x36 0x36 0x36 0x36 0x36 0x36 0x36 0x36
	0x36 0x36 0x37 0x37 0x37 0x37 0x37 0x37 0x37 0x37 0x37 0x37 0x37 0x37 0x37 0x37
	0x37 0x37 0x37 0x37 0x37 0x37 0x37 0x37 0x37 0x37 0x37 0x37 0x37 0x37 0x37 0x37
	0x37 0x37 0x38 0x38 0x38 0x38 0x38 0x38 0x38 0x38 0x38 0x38 0x38 0x38 0x38 0x38
	0x38 0x38 0x38 0x38 0x38 0x38 0x38 0x38 0x38 0x38 0x38 0x38 0x38 0x38 0x38 0x38
	0x38 0x38 0x39 0x39 0x39 0x39 0x39 0x39 0x39 0x39 0x39 0x39 0x39 0x39 0x39 0x39
	0x39 0x39 0x39 0x39 0x39 0x39 0x39 0x39 0x39 0x39 0x39 0x39 0x39 0x39 0x39 0x39
	0x39 0x39 0x3a 0x3a 0x3a 0x3a 0x3a 0x3a 0x3a 0x3a 0x3a 0x3a 0x3a 0x3a 0x3a 0x3a
	0x3a 0x3a 0x3a 0x3a 0x3a 0x3a 0x3a 0x3a 0x3a 0x3a 0x3a 0x3a 0x3a 0x3a 0x3a 0x3a
	0x3a 0x3a 0x3b 0x3b 0x3b 0x3b 0x3b 0x3b 0x3b 0x3b 0x3b 0x3b 0x3b 0x3b 0x3b 0x3b
	0x3b 0x3b 0x3b 0x3b 0x3b 0x3b 0x3b 0x3b 0x3b 0x3b 0x3b 0x3b 0x3b 0x3b 0x3b 0x3b
	0x3b 0x3b 0x3c 0x3c 0x3c 0x3c 0x3c 0x3c 0x3c 0x3c 0x3c 0x3c 0x3c 0x3c 0x3c 0x3c
	0x3c 0x3c 0x3c 0x3c 0x3c 0x3c 0x3c 0x3c 0x3c 0x3c 0x3c 0x3c 0x3c 0x3c 0x3c 0x3c
	0x3c 0x3c 0x3d 0x3d 0x3d 0x3d 0x3d 0x3d 0x3d 0x3d 0x3d 0x3d 0x3d 0x3d 0x3d 0x3d
	0x3d 0x3d 0x3d 0x3d 0x3d 0x3d 0x3d 0x3d 0x3d 0x3d 0x3d 0x3d 0x3d 0x3d 0x3d 0x3d
	0x3d 0x3d 0x3e 0x3e 0x3e 0x3e 0x3e 0x3e 0x3e 0x3e 0x3e 0x3e 0x3e 0x3e 0x3e 0x3e
	0x3e 0x3e 0x3e 0x3e 0x3e 0x3e 0x3e 0x3e 0x3e 0x3e 0x3e 0x3e 0x3e 0x3e 0x3e 0x3e
	0x3e 0x3e 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f
	0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f 0x3f
	0x3f 0x3f 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40 0x40
	0x40 0x40 0x41 0x41 0x41 0x41 0x41 0x41 0x41 0x41 0x41 0x41 0x41 0x41 0x41 0x41
	0x41 0x41 0x42 0x42 0x42 0x42 0x42 0x42 0x42 0x42 0x42 0x42 0x42 0x42 0x42 0x42
	0x42 0x42 0x43 0x43 0x43 0x43 0x43 0x43 0x43 0x43 0x43 0x43 0x43 0x43 0x43 0x43
	0x43 0x43 0x44 0x44 0x44 0x44 0x44 0x44 0x44 0x44 0x44 0x44 0x44 0x44 0x44 0x44
	0x44 0x44 0x45 0x45 0x45 0x45 0x45 0x45 0x45 0x45 0x45 0x45 0x45 0x45 0x45 0x45
	0x45 0x45 0x46 0x46 0x46 0x46 0x46 0x46 0x46 0x46 0x46 0x46 0x46 0x46 0x46 0x46
	0x46 0x46 0x47 0x47 0x47 0x47 0x47 0x47 0x47 0x47 0x47 0x47 0x47 0x47 0x47 0x47
	0x47 0x47 0x48 0x48 0x48 0x48 0x48 0x48 0x48 0x48 0x48 0x48 0x48 0x48 0x48 0x48
	0x48 0x48 0x49 0x49 0x49 0x49 0x49 0x49 0x49 0x49 0x49 0x49 0x49 0x49 0x49 0x49
	0x49 0x49 0x4a 0x4a 0x4a 0x4a 0x4a 0x4a 0x4a 0x4a 0x4a 0x4a 0x4a 0x4a 0x4a 0x4a
	0x4a 0x4a 0x4b 0x4b 0x4b 0x4b 0x4b 0x4b 0x4b 0x4b 0x4b 0x4b 0x4b 0x4b 0x4b 0x4b
	0x4b 0x4b 0x4c 0x4c 0x4c 0x4c 0x4c 0x4c 0x4c 0x4c 0x4c 0x4c 0x4c 0x4c 0x4c 0x4c
	0x4c 0x4c 0x4d 0x4d 0x4d 0x4d 0x4d 0x4d 0x4d 0x4d 0x4d 0x4d 0x4d 0x4d 0x4d 0x4d
	0x4d 0x4d 0x4e 0x4e 0x4e 0x4e 0x4e 0x4e 0x4e 0x4e 0x4e 0x4e 0x4e 0x4e 0x4e 0x4e
	0x4e 0x4e 0x4f 0x4f 0x4f 0x4f 0x4f 0x4f 0x4f 0x4f 0x4f 0x4f 0x4f 0x4f 0x4f 0x4f
	0x4f 0x4f 0x50 0x50 0x50 0x50 0x50 0x50 0x50 0x50 0x51 0x51 0x51 0x51 0x51 0x51
	0x51 0x51 0x52 0x52 0x52 0x52 0x52 0x52 0x52 0x52 0x53 0x53 0x53 0x53 0x53 0x53
	0x53 0x53 0x54 0x54 0x54 0x54 0x54 0x54 0x54 0x54 0x55 0x55 0x55 0x55 0x55 0x55
	0x55 0x55 0x56 0x56 0x56 0x56 0x56 0x56 0x56 0x56 0x57 0x57 0x57 0x57 0x57 0x57
	0x57 0x57 0x58 0x58 0x58 0x58 0x58 0x58 0x58 0x58 0x59 0x59 0x59 0x59 0x59 0x59
	0x59 0x59 0x5a 0x5a 0x5a 0x5a 0x5a 0x5a 0x5a 0x5a 0x5b 0x5b 0x5b 0x5b 0x5b 0x5b
	0x5b 0x5b 0x5c 0x5c 0x5c 0x5c 0x5c 0x5c 0x5c 0x5c 0x5d 0x5d 0x5d 0x5d 0x5d 0x5d
	0x5d 0x5d 0x5e 0x5e 0x5e 0x5e 0x5e 0x5e 0x5e 0x5e 0x5f 0x5f 0x5f 0x5f 0x5f 0x5f
	0x5f 0x5f 0x60 0x60 0x60 0x60 0x61 0x61 0x61 0x61 0x62 0x62 0x62 0x62 0x63 0x63
	0x63 0x63 0x64 0x64 0x64 0x64 0x65 0x65 0x65 0x65 0x66 0x66 0x66 0x66 0x67 0x67
	0x67 0x67 0x68 0x68 0x68 0x68 0x69 0x69 0x69 0x69 0x6a 0x6a 0x6a 0x6a 0x6b 0x6b
	0x6b 0x6b 0x6c 0x6c 0x6c 0x6c 0x6d 0x6d 0x6d 0x6d 0x6e 0x6e 0x6e 0x6e 0x6f 0x6f
	0x6f 0x6f 0x70 0x70 0x71 0x71 0x72 0x72 0x73 0x73 0x74 0x74 0x75 0x75 0x76 0x76
	0x77 0x77 0x78 0x78 0x79 0x79 0x7a 0x7a 0x7b 0x7b 0x7c 0x7c 0x7d 0x7d 0x7e 0x7e
	0xff 0xfe 0xfe 0xfd 0xfd 0xfc 0xfc 0xfb 0xfb 0xfa 0xfa 0xf9 0xf9 0xf8 0xf8 0xf7
	0xf7 0xf6 0xf6 0xf5 0xf5 0xf4 0xf4 0xf3 0xf3 0xf2 0xf2 0xf1 0xf1 0xf0 0xf0 0xef
	0xef 0xef 0xef 0xee 0xee 0xee 0xee 0xed 0xed 0xed 0xed 0xec 0xec 0xec 0xec 0xeb
	0xeb 0xeb 0xeb 0xea 0xea 0xea 0xea 0xe9 0xe9 0xe9 0xe9 0xe8 0xe8 0xe8 0xe8 0xe7
	0xe7 0xe7 0xe7 0xe6 0xe6 0xe6 0xe6 0xe5 0xe5 0xe5 0xe5 0xe4 0xe4 0xe4 0xe4 0xe3
	0xe3 0xe3 0xe3 0xe2 0xe2 0xe2 0xe2 0xe1 0xe1 0xe1 0xe1 0xe0 0xe0 0xe0 0xe0 0xdf
	0xdf 0xdf 0xdf 0xdf 0xdf 0xdf 0xdf 0xde 0xde 0xde 0xde 0xde 0xde 0xde 0xde 0xdd
	0xdd 0xdd 0xdd 0xdd 0xdd 0xdd 0xdd 0xdc 0xdc 0xdc 0xdc 0xdc 0xdc 0xdc 0xdc 0xdb
	0xdb 0xdb 0xdb 0xdb 0xdb 0xdb 0xdb 0xda 0xda 0xda 0xda 0xda 0xda 0xda 0xda 0xd9
	0xd9 0xd9 0xd9 0xd9 0xd9 0xd9 0xd9 0xd8 0xd8 0xd8 0xd8 0xd8 0xd8 0xd8 0xd8 0xd7
	0xd7 0xd7 0xd7 0xd7 0xd7 0xd7 0xd7 0xd6 0xd6 0xd6 0xd6 0xd6 0xd6 0xd6 0xd6 0xd5
	0xd5 0xd5 0xd5 0xd5 0xd5 0xd5 0xd5 0xd4 0xd4 0xd4 0xd4 0xd4 0xd4 0xd4 0xd4 0xd3
	0xd3 0xd3 0xd3 0xd3 0xd3 0xd3 0xd3 0xd2 0xd2 0xd2 0xd2 0xd2 0xd2 0xd2 0xd2 0xd1
	0xd1 0xd1 0xd1 0xd1 0xd1 0xd1 0xd1 0xd0 0xd0 0xd0 0xd0 0xd0 0xd0 0xd0 0xd0 0xcf
	0xcf 0xcf 0xcf 0xcf 0xcf 0xcf 0xcf 0xcf 0xcf 0xcf 0xcf 0xcf 0xcf 0xcf 0xcf 0xce
	0xce 0xce 0xce 0xce 0xce 0xce 0xce 0xce 0xce 0xce 0xce 0xce 0xce 0xce 0xce 0xcd
	0xcd 0xcd 0xcd 0xcd 0xcd 0xcd 0xcd 0xcd 0xcd 0xcd 0xcd 0xcd 0xcd 0xcd 0xcd 0xcc
	0xcc 0xcc 0xcc 0xcc 0xcc 0xcc 0xcc 0xcc 0xcc 0xcc 0xcc 0xcc 0xcc 0xcc 0xcc 0xcb
	0xcb 0xcb 0xcb 0xcb 0xcb 0xcb 0xcb 0xcb 0xcb 0xcb 0xcb 0xcb 0xcb 0xcb 0xcb 0xca
	0xca 0xca 0xca 0xca 0xca 0xca 0xca 0xca 0xca 0xca 0xca 0xca 0xca 0xca 0xca 0xc9
	0xc9 0xc9 0xc9 0xc9 0xc9 0xc9 0xc9 0xc9 0xc9 0xc9 0xc9 0xc9 0xc9 0xc9 0xc9 0xc8
	0xc8 0xc8 0xc8 0xc8 0xc8 0xc8 0xc8 0xc8 0xc8 0xc8 0xc8 0xc8 0xc8 0xc8 0xc8 0xc7
	0xc7 0xc7 0xc7 0xc7 0xc7 0xc7 0xc7 0xc7 0xc7 0xc7 0xc7 0xc7 0xc7 0xc7 0xc7 0xc6
	0xc6 0xc6 0xc6 0xc6 0xc6 0xc6 0xc6 0xc6 0xc6 0xc6 0xc6 0xc6 0xc6 0xc6 0xc6 0xc5
	0xc5 0xc5 0xc5 0xc5 0xc5 0xc5 0xc5 0xc5 0xc5 0xc5 0xc5 0xc5 0xc5 0xc5 0xc5 0xc4
	0xc4 0xc4 0xc4 0xc4 0xc4 0xc4 0xc4 0xc4 0xc4 0xc4 0xc4 0xc4 0xc4 0xc4 0xc4 0xc3
	0xc3 0xc3 0xc3 0xc3 0xc3 0xc3 0xc3 0xc3 0xc3 0xc3 0xc3 0xc3 0xc3 0xc3 0xc3 0xc2
	0xc2 0xc2 0xc2 0xc2 0xc2 0xc2 0xc2 0xc2 0xc2 0xc2 0xc2 0xc2 0xc2 0xc2 0xc2 0xc1
	0xc1 0xc1 0xc1 0xc1 0xc1 0xc1 0xc1 0xc1 0xc1 0xc1 0xc1 0xc1 0xc1 0xc1 0xc1 0xc0
	0xc0 0xc0 0xc0 0xc0 0xc0 0xc0 0xc0 0xc0 0xc0 0xc0 0xc0 0xc0 0xc0 0xc0 0xc0 0xbf
	0xbf 0xbf 0xbf 0xbf 0xbf 0xbf 0xbf 0xbf 0xbf 0xbf 0xbf 0xbf 0xbf 0xbf 0xbf 0xbf
	0xbf 0xbf 0xbf 0xbf 0xbf 0xbf 0xbf 0xbf 0xbf 0xbf 0xbf 0xbf 0xbf 0xbf 0xbf 0xbe
	0xbe 0xbe 0xbe 0xbe 0xbe 0xbe 0xbe 0xbe 0xbe 0xbe 0xbe 0xbe 0xbe 0xbe 0xbe 0xbe
	0xbe 0xbe 0xbe 0xbe 0xbe 0xbe 0xbe 0xbe 0xbe 0xbe 0xbe 0xbe 0xbe 0xbe 0xbe 0xbd
	0xbd 0xbd 0xbd 0xbd 0xbd 0xbd 0xbd 0xbd 0xbd 0xbd 0xbd 0xbd 0xbd 0xbd 0xbd 0xbd
	0xbd 0xbd 0xbd 0xbd 0xbd 0xbd 0xbd 0xbd 0xbd 0xbd 0xbd 0xbd 0xbd 0xbd 0xbd 0xbc
	0xbc 0xbc 0xbc 0xbc 0xbc 0xbc 0xbc 0xbc 0xbc 0xbc 0xbc 0xbc 0xbc 0xbc 0xbc 0xbc
	0xbc 0xbc 0xbc 0xbc 0xbc 0xbc 0xbc 0xbc 0xbc 0xbc 0xbc 0xbc 0xbc 0xbc 0xbc 0xbb
	0xbb 0xbb 0xbb 0xbb 0xbb 0xbb 0xbb 0xbb 0xbb 0xbb 0xbb 0xbb 0xbb 0xbb 0xbb 0xbb
	0xbb 0xbb 0xbb 0xbb 0xbb 0xbb 0xbb 0xbb 0xbb 0xbb 0xbb 0xbb 0xbb 0xbb 0xbb 0xba
	0xba 0xba 0xba 0xba 0xba 0xba 0xba 0xba 0xba 0xba 0xba 0xba 0xba 0xba 0xba 0xba
	0xba 0xba 0xba 0xba 0xba 0xba 0xba 0xba 0xba 0xba 0xba 0xba 0xba 0xba 0xba 0xb9
	0xb9 0xb9 0xb9 0xb9 0xb9 0xb9 0xb9 0xb9 0xb9 0xb9 0xb9 0xb9 0xb9 0xb9 0xb9 0xb9
	0xb9 0xb9 0xb9 0xb9 0xb9 0xb9 0xb9 0xb9 0xb9 0xb9 0xb9 0xb9 0xb9 0xb9 0xb9 0xb8
	0xb8 0xb8 0xb8 0xb8 0xb8 0xb8 0xb8 0xb8 0xb8 0xb8 0xb8 0xb8 0xb8 0xb8 0xb8 0xb8
	0xb8 0xb8 0xb8 0xb8 0xb8 0xb8 0xb8 0xb8 0xb8 0xb8 0xb8 0xb8 0xb8 0xb8 0xb8 0xb7
	0xb7 0xb7 0xb7 0xb7 0xb7 0xb7 0xb7 0xb7 0xb7 0xb7 0xb7 0xb7 0xb7 0xb7 0xb7 0xb7
	0xb7 0xb7 0xb7 0xb7 0xb7 0xb7 0xb7 0xb7 0xb7 0xb7 0xb7 0xb7 0xb7 0xb7 0xb7 0xb6
	0xb6 0xb6 0xb6 0xb6 0xb6 0xb6 0xb6 0xb6 0xb6 0xb6 0xb6 0xb6 0xb6 0xb6 0xb6 0xb6
	0xb6 0xb6 0xb6 0xb6 0xb6 0xb6 0xb6 0xb6 0xb6 0xb6 0xb6 0xb6 0xb6 0xb6 0xb6 0xb5
	0xb5 0xb5 0xb5 0xb5 0xb5 0xb5 0xb5 0xb5 0xb5 0xb5 0xb5 0xb5 0xb5 0xb5 0xb5 0xb5
	0xb5 0xb5 0xb5 0xb5 0xb5 0xb5 0xb5 0xb5 0xb5 0xb5 0xb5 0xb5 0xb5 0xb5 0xb5 0xb4
	0xb4 0xb4 0xb4 0xb4 0xb4 0xb4 0xb4 0xb4 0xb4 0xb4 0xb4 0xb4 0xb4 0xb4 0xb4 0xb4
	0xb4 0xb4 0xb4 0xb4 0xb4 0xb4 0xb4 0xb4 0xb4 0xb4 0xb4 0xb4 0xb4 0xb4 0xb4 0xb3
	0xb3 0xb3 0xb3 0xb3 0xb3 0xb3 0xb3 0xb3 0xb3 0xb3 0xb3 0xb3 0xb3 0xb3 0xb3 0xb3
	0xb3 0xb3 0xb3 0xb3 0xb3 0xb3 0xb3 0xb3 0xb3 0xb3 0xb3 0xb3 0xb3 0xb3 0xb3 0xb2
	0xb2 0xb2 0xb2 0xb2 0xb2 0xb2 0xb2 0xb2 0xb2 0xb2 0xb2 0xb2 0xb2 0xb2 0xb2 0xb2
	0xb2 0xb2 0xb2 0xb2 0xb2 0xb2 0xb2 0xb2 0xb2 0xb2 0xb2 0xb2 0xb2 0xb2 0xb2 0xb1
	0xb1 0xb1 0xb1 0xb1 0xb1 0xb1 0xb1 0xb1 0xb1 0xb1 0xb1 0xb1 0xb1 0xb1 0xb1 0xb1
	0xb1 0xb1 0xb1 0xb1 0xb1 0xb1 0xb1 0xb1 0xb1 0xb1 0xb1 0xb1 0xb1 0xb1 0xb1 0xb0
	0xb0 0xb0 0xb0 0xb0 0xb0 0xb0 0xb0 0xb0 0xb0 0xb0 0xb0 0xb0 0xb0 0xb0 0xb0 0xb0
	0xb0 0xb0 0xb0 0xb0 0xb0 0xb0 0xb0 0xb0 0xb0 0xb0 0xb0 0xb0 0xb0 0xb0 0xb0 0xaf
	0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf
	0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf
	0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf
	0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xaf 0xae
	0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae
	0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae
	0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae
	0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xae 0xad
	0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad
	0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad
	0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad
	0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xad 0xac
	0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac
	0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac
	0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac
	0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xac 0xab
	0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab
	0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab
	0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab
	0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xab 0xaa
	0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa
	0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa
	0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa
	0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xaa 0xa9
	0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9
	0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9
	0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9
	0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa9 0xa8
	0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8
	0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8
	0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8
	0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa8 0xa7
	0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7
	0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7
	0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7
	0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa7 0xa6
	0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6
	0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6
	0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6
	0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa6 0xa5
	0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5
	0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5
	0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5
	0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa5 0xa4
	0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4
	0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4
	0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4
	0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa4 0xa3
	0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3
	0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3
	0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3
	0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa3 0xa2
	0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2
	0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2
	0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2
	0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa2 0xa1
	0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1
	0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1
	0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1
	0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa1 0xa0
	0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0
	0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0
	0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0
	0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0xa0 0x9f
	0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f
	0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f
	0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f
	0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f
	0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f
	0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f
	0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f
	0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9f 0x9e
	0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e
	0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e
	0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e
	0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e
	0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e
	0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e
	0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e
	0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9e 0x9d
	0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d
	0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d
	0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d
	0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d
	0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d
	0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d
	0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d
	0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9d 0x9c
	0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c
	0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c
	0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c
	0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c
	0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c
	0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c
	0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c
	0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9c 0x9b
	0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b
	0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b
	0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b
	0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b
	0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b
	0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b
	0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b
	0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9b 0x9a
	0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a
	0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a
	0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a
	0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a
	0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a
	0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a
	0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a
	0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x9a 0x99
	0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99
	0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99
	0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99
	0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99
	0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99
	0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99
	0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99
	0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x99 0x98
	0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98
	0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98
	0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98
	0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98
	0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98
	0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98
	0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98
	0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x98 0x97
	0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97
	0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97
	0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97
	0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97
	0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97
	0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97
	0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97
	0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x97 0x96
	0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96
	0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96
	0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96
	0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96
	0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96
	0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96
	0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96
	0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x96 0x95
	0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95
	0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95
	0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95
	0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95
	0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95
	0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95
	0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95
	0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x95 0x94
	0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94
	0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94
	0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94
	0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94
	0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94
	0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94
	0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94
	0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x94 0x93
	0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93
	0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93
	0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93
	0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93
	0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93
	0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93
	0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93
	0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x93 0x92
	0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92
	0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92
	0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92
	0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92
	0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92
	0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92
	0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92
	0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x92 0x91
	0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91
	0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91
	0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91
	0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91
	0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91
	0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91
	0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91
	0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x91 0x90
	0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
	0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
	0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
	0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
	0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
	0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
	0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
	0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x8f
	0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f
	0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f
	0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f
	0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f
	0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f
	0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f
	0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f
	0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f
	0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f
	0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f
	0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f
	0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f
	0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f
	0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f
	0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f
	0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8f 0x8e
	0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e
	0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e
	0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e
	0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e
	0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e
	0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e
	0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e
	0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e
	0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e
	0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e
	0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e
	0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e
	0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e
	0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e
	0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e
	0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8e 0x8d
	0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d
	0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d
	0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d
	0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d
	0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d
	0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d
	0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d
	0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d
	0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d
	0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d
	0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d
	0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d
	0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d
	0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d
	0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d
	0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8d 0x8c
	0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c
	0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c
	0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c
	0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c
	0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c
	0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c
	0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c
	0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c
	0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c
	0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c
	0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c
	0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c
	0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c
	0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c
	0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c
	0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8c 0x8b
	0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b
	0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b
	0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b
	0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b
	0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b
	0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b
	0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b
	0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b
	0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b
	0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b
	0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b
	0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b
	0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b
	0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b
	0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b
	0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8b 0x8a
	0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a
	0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a
	0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a
	0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a
	0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a
	0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a
	0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a
	0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a
	0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a
	0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a
	0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a
	0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a
	0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a
	0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a
	0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a
	0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x8a 0x89
	0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89
	0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89
	0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89
	0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89
	0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89
	0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89
	0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89
	0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89
	0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89
	0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89
	0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89
	0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89
	0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89
	0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89
	0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89
	0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x89 0x88
	0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88
	0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88
	0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88
	0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88
	0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88
	0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88
	0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88
	0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88
	0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88
	0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88
	0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88
	0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88
	0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88
	0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88
	0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88
	0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x88 0x87
	0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87
	0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87
	0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87
	0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87
	0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87
	0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87
	0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87
	0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87
	0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87
	0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87
	0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87
	0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87
	0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87
	0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87
	0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87
	0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x87 0x86
	0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86
	0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86
	0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86
	0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86
	0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86
	0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86
	0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86
	0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86
	0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86
	0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86
	0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86
	0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86
	0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86
	0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86
	0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86
	0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x86 0x85
	0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85
	0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85
	0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85
	0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85
	0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85
	0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85
	0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85
	0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85
	0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85
	0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85
	0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85
	0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85
	0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85
	0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85
	0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85
	0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x85 0x84
	0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84
	0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84
	0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84
	0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84
	0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84
	0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84
	0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84
	0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84
	0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84
	0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84
	0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84
	0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84
	0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84
	0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84
	0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84
	0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x84 0x83
	0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83
	0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83
	0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83
	0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83
	0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83
	0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83
	0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83
	0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83
	0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83
	0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83
	0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83
	0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83
	0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83
	0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83
	0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83
	0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x83 0x82
	0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82
	0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82
	0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82
	0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82
	0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82
	0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82
	0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82
	0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82
	0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82
	0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82
	0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82
	0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82
	0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82
	0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82
	0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82
	0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x82 0x81
	0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81
	0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81
	0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81
	0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81
	0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81
	0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81
	0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81
	0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81
	0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81
	0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81
	0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81
	0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81
	0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81
	0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81
	0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81
	0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x80
	0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80
	0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80
	0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80
	0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80
	0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80
	0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80
	0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80
	0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80
	0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80
	0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80
	0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80
	0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80
	0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80
	0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80
	0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80
	0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80
	0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80
	0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80
)

# base64 handling stuff
typeset -r base64chars="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"

function bytearraytobase64
{
	nameref bytearray=$1
	typeset out=""
	integer len
	integer i i0 i1 i2

	(( len=${#bytearray[*]}-1 ))
	for (( i=0 ; i < len ; i+=3 )) ; do
		(( i0=bytearray[i+0] , i1=bytearray[i+1] , i2=bytearray[i+2] ))

					out+="${base64chars:$(( i0 >> 2 )):1}"
					out+="${base64chars:$(( ((i0 & 0x03) << 4) | ((i1 & 0xf0) >> 4) )):1}"
		(( (i+1) < len )) && {	out+="${base64chars:$(( ((i1 & 0x0f) << 2) | ((i2 & 0xc0) >> 6) )):1}" ; } || out+="="
		(( (i+2) < len )) && {	out+="${base64chars:$(( i2 & 0x3f )):1}" ; } || out+="="
	done

	printf "%s" "${out}"
	return 0
}


# stack layout:
# stack.currpos = current position
# stack.data    = nameref to integer array
function stack_init
{
	nameref stk=$1
	stk.currpos=0
	return 0
}

function stack_put_byte
{
	nameref stk=$1
	stk.data[stk.currpos++]=$(( $2 & 0xFF ))
	return 0
}

function stack_put_uint16
{
	integer val=$2
	stack_put_byte $1 $(( (val >> 8) & 0xFF ))
	stack_put_byte $1 $(( val        & 0xFF ))
	return 0
}

# put an au(4) header on a stack variable
function audio_put_au_header
{
	nameref au=$1

	# au_magic: magic number
	stack_put_byte au $(('.'))
	stack_put_byte au $(('s'))
	stack_put_byte au $(('n'))
	stack_put_byte au $(('d'))
	# au_offset
	stack_put_byte au 0x00
	stack_put_byte au 0x00
	stack_put_byte au 0x00
	stack_put_byte au 0x1C
	# au_data_size  (0xFFFFFFFF = AUDIO_AU_UNKNOWN_SIZE   ((unsigned)(~0)))
	stack_put_byte au 0xFF
	stack_put_byte au 0xFF
	stack_put_byte au 0xFF
	stack_put_byte au 0xFF
	# au_encoding
	stack_put_byte au 0x00
	stack_put_byte au 0x00
	stack_put_byte au 0x00
	stack_put_byte au 1
	# au_sample_rate
	stack_put_byte au 0x00
	stack_put_byte au 0x00
	stack_put_byte au 0x1f
	stack_put_byte au 0x40
	# au_channels
	stack_put_byte au 0x00
	stack_put_byte au 0x00
	stack_put_byte au 0x00
	stack_put_byte au 0x01
	# dummy
	stack_put_byte au 0
	stack_put_byte au 0
	stack_put_byte au 0
	stack_put_byte au 0
	return 0
}

function print_piano_layout
{
    cat <<ENDOFTEXT
----------------------------------------------------
 |    #####  #####    |    #####  #####  #####    |
 |    #####  #####    |    #####  #####  #####    |
 |    #####  #####    |    #####  #####  #####    |
 |    #cis#  #dis#    |    #fis#  #gis#  #ais#    |
 |    #des#  # es#    |    #ges#  # as#  # b #    |
 |    \###/  \###/    |    \###/  \###/  \###/    |
 |      |      |      |      |      |      |      |
 |      |      |      |      |      |      |      |
 |   c  |   d  |   e  |   f  |   g  |   a  |   h  |
 |      |      |      |      |      |      |      |
/\-----/\-----/\-----/\-----/\-----/\-----/\-----/\-

Keys:                                                 
       R      T             U      I      O      
    D      F      G      H      J      K      L    
ENDOFTEXT
	return 0
}

function usage
{
	OPTIND=0
	getopts -a "${progname}" "${shpiano_usage}" OPT '-?'
	exit 2
}

# program start
builtin basename

typeset progname="${ basename "${0}" ; }"

typeset -r shpiano_usage=$'+
[-?\n@(#)\$Id: shpiano (Roland Mainz) 2009-05-09 \$\n]
[-author?Roland Mainz <roland.mainz@nrubsig.org>]
[-author?Valeria Elisabeth Mainz <valeria.mainz@no.such.email.toddler>]
[+NAME?shpiano - simple audio demo]
[+DESCRIPTION?\bshpiano\b is a small demo application which converts
        keyboard input into 8bit Mu-law audio samples which are
        send to /dev/audio.]
[b:babymode?Mode to entertain toddlers. Plays a sound for any key
	and ignores SIGINT. Requires ESC to quit the application.]
[+SEE ALSO?\bksh93\b(1), \bau\b(4), \baudio\b(7i)]
'
typeset babymode=false

while getopts -a "${progname}" "${shpiano_usage}" OPT ; do 
#	printmsg "## OPT=|${OPT}|, OPTARG=|${OPTARG}|"
	case ${OPT} in
		b)	babymode=true ;;
		+b)	babymode=false ;;
		*)	usage ;;
	esac
done
shift $((OPTIND-1))

float -r M_PI=3.14159265358979323846

float sample_rate=8000.
float duration=0.10
float freq
float w # temporary "wave" value
integer i
integer audiofd # audio device file descriptor
typeset key
compound audio=( integer currpos=0 ; integer -a data=( [0]=0 ) ) # stack object

clear
print_piano_layout

if ${babymode} ; then
	[[ -x /usr/bin/banner ]] || fatal_error "-n requires /usr/bin/banner"

	typeset lastkeys

	nameref curr_note=tones["A#4"]
	(( freq=curr_note.freq ))
	
	trap "" INT
fi

if [[ "${AUDIODEV}" == "" ]] ; then
	AUDIODEV="/dev/audio"
fi
print -u2 -f $"Playing sound to device %s\n" "${AUDIODEV}"

# open channel to audio device
redirect {audiofd}<> "${AUDIODEV}"
(( $? != 0 )) && fatal_error $"Could not open audio device."

# build pause sample
stack_init audio
for ((i=0 ; i < ((sample_rate*duration)/2.) ; i++)) ; do
	stack_put_byte audio 0
done
typeset -b pause_sample=${ bytearraytobase64 audio.data ; }

stack_init audio
audio_put_au_header audio
typeset -b au_header=${ bytearraytobase64 audio.data ; }

# begin playing
printf "%B" au_header >&${audiofd}


# warning: the math used here is so wrong that your head may
# explode when you continue reading this
while read -r -N 1 key?$'\r > ' ; do
	if [[ ${key} == $'\E' ]] || [[ ${babymode} != "true" && ${key} == ~(E)($'\E'|'q'|'Q') ]] ; then
		break # quit
	fi

	printf "\r"
	if [[ -v notes[key_${key}] ]] ; then
		nameref curr_note="${notes[key_${key}].val}"
		(( freq=curr_note.freq ))
	else
		if ${babymode} ; then
			nameref curr_note=tones["A#4"]
			(( freq=curr_note.freq ))
		else
			nameref curr_note=tones["p"]
			(( freq=1.*(1./duration) ))
		fi
	fi
	
	# babymode: print "keys" to screen via /usr/bin/banner
	if ${babymode} ; then
		lastkeys="${lastkeys/~(Er).*(........)/\1}${key}"
		banner "${lastkeys}"
	fi

#	printf "note=%s sample_rate=%f, freq=%f\n" "${!curr_note}" sample_rate freq >&2

	# Create sample data if they didn't exist yet and
	# store them in the "tones" array
	if ! ${curr_note.sample_set} ; then
		stack_init audio

		for ((i=0 ; i < (sample_rate*duration) ; i++)) ; do
			# first create the sinus wave...
			(( w=sin( ((i*freq)/sample_rate) * (2.*M_PI)) ))
			# ...scale it to 14bit signed PCM linear and...
			(( w=8192.+w*8191. ))
			# ...then convert it to 8bit ulaw
			# ("audio_pcmulinear14bittoulaw8bit" is unsigned but we use
			# "8192" above as starting point to do the "signed to unsigned"
			# conversion) ...
			stack_put_byte audio $(( audio_pcmulinear14bittoulaw8bit[int(w)] ))
		done

		curr_note.sample=${ bytearraytobase64 audio.data ; }
		curr_note.sample_set="true"
	fi
    
	# output sample
	{
		printf "%B" curr_note.sample
		printf "%B" pause_sample
	} >&${audiofd}
done

# close audio device
redirect {audiofd}<&-

print -u2 $"# done."
exit 0
#EOF.
