#
# Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
# CDDL HEADER START
#
# The contents of this file are subject to the terms of the
# Common Development and Distribution License, Version 1.0 only
# (the "License").  You may not use this file except in compliance
# with the License.
#
# You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
# or http://www.opensolaris.org/os/licensing.
# See the License for the specific language governing permissions
# and limitations under the License.
#
# When distributing Covered Code, include this CDDL HEADER in each
# file and include the License file at usr/src/OPENSOLARIS.LICENSE.
# If applicable, add the following below this CDDL HEADER, with the
# fields enclosed by brackets "[]" replaced with your own identifying
# information: Portions Copyright [yyyy] [name of copyright owner]
#
# CDDL HEADER END
#
# ident	"%Z%%M%	%I%	%E% SMI"
#
# mknames.awk	
#
# XCurses Library
#
# Copyright 1990, 1995 by Mortice Kern Systems Inc.  All rights reserved.
#
#  rcsid = $Header: /rd/src/libc/xcurses/rcs/mknames.awk 1.1 1995/05/11 15:12:57 ant Exp $
#

function header(file, array) {
print "/*" > file
printf " * %s\n", file > file
print " *" > file
print " * XCurses Library" > file
print " *" > file
print " * **** THIS FILE IS MACHINE GENERATED." > file
print " * **** DO NOT EDIT THIS FILE." > file
print " *" > file
print " * Copyright 1990, 1995 by Mortice Kern Systems Inc.  All rights reserved." > file
print " *" > file
print " */" > file
print > file
print "#if M_RCSID" > file
print "#ifndef lint" > file
printf "static char rcsID[] = \"$Header%s\"\n", "$" > file
print "#endif" > file
print "#endif" > file
print > file
printf "char *__m_%s[] = {\n", array > file
}

function tail(file) {
	printf("\t0\n};\n\n") >file;
	close(file);
}

BEGIN {
	header("boolname.c", "boolnames");
	header("boolcode.c", "boolcodes");
	header("boolfnam.c", "boolfnames");
	header("numname.c", "numnames");
	header("numcode.c", "numcodes");
	header("numfnam.c", "numfnames");
	header("strname.c", "strnames");
	header("strcode.c", "strcodes");
	header("strfnam.c", "strfnames");
}

$4 == "bool" {
	printf "\t\"%s\",\n", $1 > "boolfnam.c"
	printf "\t\"%s\",\n", $2 > "boolname.c"
	printf "\t\"%s\",\n", $3 > "boolcode.c"
}

$4 == "number" {
	printf "\t\"%s\",\n", $1 > "numfnam.c"
	printf "\t\"%s\",\n", $2 > "numname.c"
	printf "\t\"%s\",\n", $3 > "numcode.c"
}

$4 == "str" {
	printf "\t\"%s\",\n", $1 > "strfnam.c"
	printf "\t\"%s\",\n", $2 > "strname.c"
	printf "\t\"%s\",\n", $3 > "strcode.c"
}

END {
	tail("boolname.c");
	tail("boolcode.c");
	tail("boolfnam.c");
	tail("numname.c");
	tail("numcode.c");
	tail("numfnam.c");
	tail("strname.c");
	tail("strcode.c");
	tail("strfnam.c");
}
