/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"%Z%%M%	%I%	%E% SMI"

#include <sys/types.h>
#include <sys/param.h>  /* for NULL */
#include <sys/font.h>


/* BEGIN CSTYLED */
/* This is a derivation of a BDF font from the X consolidation */
/* COMMENT  */
/* COMMENT Donated by H. Kagotani <kagotani@cs.titech.ac.jp>; public domain */
/* COMMENT font from Japan */
/* COMMENT  */
/* FONT -Misc-Fixed-Medium-R-Normal--14-130-75-75-C-70-ISO8859-1 */
/* Copyright notice from .bdf file: */
/* COPYRIGHT "Public domain font.  Share and enjoy." */

static unsigned char FONTDATA[] = {

/* 0x01 */
0x00, /*         */
0x00, /*         */
0x18, /*    XX   */
0x18, /*    XX   */
0x3c, /*   XXXX  */
0x3c, /*   XXXX  */
0x7e, /*  XXXXXX */
0x7e, /*  XXXXXX */
0x3c, /*   XXXX  */
0x3c, /*   XXXX  */
0x18, /*    XX   */
0x18, /*    XX   */
0x00, /*         */
0x00, /*         */

/* 0x02 */
0x54, /*  X X X  */
0xaa, /* X X X X */
0x54, /*  X X X  */
0xaa, /* X X X X */
0x54, /*  X X X  */
0xaa, /* X X X X */
0x54, /*  X X X  */
0xaa, /* X X X X */
0x54, /*  X X X  */
0xaa, /* X X X X */
0x54, /*  X X X  */
0xaa, /* X X X X */
0x54, /*  X X X  */
0xaa, /* X X X X */

/* 0x0b */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0xf0, /* XXXX    */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* 0x0c */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0xf0, /* XXXX    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */

/* 0x0d */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x1e, /*    XXXX */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */

/* 0x0e */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x1e, /*    XXXX */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* 0x0f */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0xfe, /* XXXXXXX */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */

/* 0x10 */
0xfe, /* XXXXXXX */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* 0x11 */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0xfe, /* XXXXXXX */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* 0x12 */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0xfe, /* XXXXXXX */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* 0x13 */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0xfe, /* XXXXXXX */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* 0x14 */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0xfe, /* XXXXXXX */

/* 0x15 */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x1e, /*    XXXX */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */

/* 0x16 */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0xf0, /* XXXX    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */

/* 0x17 */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0xfe, /* XXXXXXX */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* 0x18 */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0xfe, /* XXXXXXX */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */

/* 0x19 */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */

/* ' ' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* '!' */
0x00, /*         */
0x00, /*         */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x00, /*         */
0x10, /*    X    */
0x10, /*    X    */
0x00, /*         */
0x00, /*         */

/* '"' */
0x00, /*         */
0x6c, /*  XX XX  */
0x24, /*   X  X  */
0x24, /*   X  X  */
0x48, /*  X  X   */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* '#' */
0x00, /*         */
0x00, /*         */
0x0a, /*     X X */
0x0a, /*     X X */
0x0a, /*     X X */
0x7e, /*  XXXXXX */
0x14, /*    X X  */
0x14, /*    X X  */
0x7e, /*  XXXXXX */
0x28, /*   X X   */
0x28, /*   X X   */
0x28, /*   X X   */
0x00, /*         */
0x00, /*         */

/* '$' */
0x00, /*         */
0x00, /*         */
0x08, /*     X   */
0x3c, /*   XXXX  */
0x4a, /*  X  X X */
0x4a, /*  X  X X */
0x28, /*   X X   */
0x1c, /*    XXX  */
0x0a, /*     X X */
0x4a, /*  X  X X */
0x4a, /*  X  X X */
0x3c, /*   XXXX  */
0x08, /*     X   */
0x00, /*         */

/* '%' */
0x00, /*         */
0x00, /*         */
0x32, /*   XX  X */
0x4a, /*  X  X X */
0x4c, /*  X  XX  */
0x38, /*   XXX   */
0x08, /*     X   */
0x10, /*    X    */
0x1c, /*    XXX  */
0x32, /*   XX  X */
0x52, /*  X X  X */
0x4c, /*  X  XX  */
0x00, /*         */
0x00, /*         */

/* '&' */
0x00, /*         */
0x00, /*         */
0x18, /*    XX   */
0x24, /*   X  X  */
0x24, /*   X  X  */
0x24, /*   X  X  */
0x18, /*    XX   */
0x32, /*   XX  X */
0x4a, /*  X  X X */
0x44, /*  X   X  */
0x4c, /*  X  XX  */
0x32, /*   XX  X */
0x00, /*         */
0x00, /*         */

/* ''' */
0x00, /*         */
0x18, /*    XX   */
0x08, /*     X   */
0x08, /*     X   */
0x10, /*    X    */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* '(' */
0x00, /*         */
0x02, /*       X */
0x04, /*      X  */
0x08, /*     X   */
0x08, /*     X   */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x08, /*     X   */
0x08, /*     X   */
0x04, /*      X  */
0x02, /*       X */

/* ')' */
0x00, /*         */
0x40, /*  X      */
0x20, /*   X     */
0x10, /*    X    */
0x10, /*    X    */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x10, /*    X    */
0x10, /*    X    */
0x20, /*   X     */
0x40, /*  X      */

/* '*' */
0x00, /*         */
0x00, /*         */
0x08, /*     X   */
0x2a, /*   X X X */
0x1c, /*    XXX  */
0x08, /*     X   */
0x1c, /*    XXX  */
0x2a, /*   X X X */
0x08, /*     X   */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* '+' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x7c, /*  XXXXX  */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* ',' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x30, /*   XX    */
0x10, /*    X    */
0x10, /*    X    */
0x20, /*   X     */

/* '-' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x7e, /*  XXXXXX */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* '.' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x08, /*     X   */
0x1c, /*    XXX  */
0x08, /*     X   */
0x00, /*         */

/* '/' */
0x00, /*         */
0x02, /*       X */
0x02, /*       X */
0x04, /*      X  */
0x04, /*      X  */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x10, /*    X    */
0x10, /*    X    */
0x20, /*   X     */
0x20, /*   X     */
0x40, /*  X      */
0x40, /*  X      */

/* '0' */
0x00, /*         */
0x00, /*         */
0x18, /*    XX   */
0x24, /*   X  X  */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x24, /*   X  X  */
0x18, /*    XX   */
0x00, /*         */
0x00, /*         */

/* '1' */
0x00, /*         */
0x00, /*         */
0x08, /*     X   */
0x18, /*    XX   */
0x28, /*   X X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x3e, /*   XXXXX */
0x00, /*         */
0x00, /*         */

/* '2' */
0x00, /*         */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x02, /*       X */
0x04, /*      X  */
0x04, /*      X  */
0x08, /*     X   */
0x10, /*    X    */
0x20, /*   X     */
0x7e, /*  XXXXXX */
0x00, /*         */
0x00, /*         */

/* '3' */
0x00, /*         */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x02, /*       X */
0x1c, /*    XXX  */
0x02, /*       X */
0x02, /*       X */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* '4' */
0x00, /*         */
0x00, /*         */
0x04, /*      X  */
0x0c, /*     XX  */
0x14, /*    X X  */
0x14, /*    X X  */
0x24, /*   X  X  */
0x24, /*   X  X  */
0x44, /*  X   X  */
0x7e, /*  XXXXXX */
0x04, /*      X  */
0x04, /*      X  */
0x00, /*         */
0x00, /*         */

/* '5' */
0x00, /*         */
0x00, /*         */
0x7e, /*  XXXXXX */
0x40, /*  X      */
0x40, /*  X      */
0x7c, /*  XXXXX  */
0x42, /*  X    X */
0x02, /*       X */
0x02, /*       X */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* '6' */
0x00, /*         */
0x00, /*         */
0x1c, /*    XXX  */
0x22, /*   X   X */
0x42, /*  X    X */
0x40, /*  X      */
0x5c, /*  X XXX  */
0x62, /*  XX   X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* '7' */
0x00, /*         */
0x00, /*         */
0x7e, /*  XXXXXX */
0x42, /*  X    X */
0x44, /*  X   X  */
0x04, /*      X  */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x00, /*         */
0x00, /*         */

/* '8' */
0x00, /*         */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x24, /*   X  X  */
0x18, /*    XX   */
0x24, /*   X  X  */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* '9' */
0x00, /*         */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x46, /*  X   XX */
0x3a, /*   XXX X */
0x02, /*       X */
0x42, /*  X    X */
0x44, /*  X   X  */
0x38, /*   XXX   */
0x00, /*         */
0x00, /*         */

/* ':' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x08, /*     X   */
0x1c, /*    XXX  */
0x08, /*     X   */
0x00, /*         */
0x00, /*         */
0x08, /*     X   */
0x1c, /*    XXX  */
0x08, /*     X   */
0x00, /*         */
0x00, /*         */

/* ';' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x18, /*    XX   */
0x18, /*    XX   */
0x00, /*         */
0x00, /*         */
0x18, /*    XX   */
0x08, /*     X   */
0x08, /*     X   */
0x10, /*    X    */
0x00, /*         */

/* '<' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x04, /*      X  */
0x08, /*     X   */
0x10, /*    X    */
0x20, /*   X     */
0x40, /*  X      */
0x20, /*   X     */
0x10, /*    X    */
0x08, /*     X   */
0x04, /*      X  */
0x00, /*         */
0x00, /*         */

/* '=' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x7e, /*  XXXXXX */
0x00, /*         */
0x00, /*         */
0x7e, /*  XXXXXX */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* '>' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x40, /*  X      */
0x20, /*   X     */
0x10, /*    X    */
0x08, /*     X   */
0x04, /*      X  */
0x08, /*     X   */
0x10, /*    X    */
0x20, /*   X     */
0x40, /*  X      */
0x00, /*         */
0x00, /*         */

/* '?' */
0x00, /*         */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x04, /*      X  */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x00, /*         */
0x08, /*     X   */
0x08, /*     X   */
0x00, /*         */
0x00, /*         */

/* '@' */
0x00, /*         */
0x00, /*         */
0x1c, /*    XXX  */
0x22, /*   X   X */
0x4e, /*  X  XXX */
0x52, /*  X X  X */
0x52, /*  X X  X */
0x52, /*  X X  X */
0x52, /*  X X  X */
0x4e, /*  X  XXX */
0x20, /*   X     */
0x1e, /*    XXXX */
0x00, /*         */
0x00, /*         */

/* 'A' */
0x00, /*         */
0x00, /*         */
0x18, /*    XX   */
0x24, /*   X  X  */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x7e, /*  XXXXXX */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x00, /*         */
0x00, /*         */

/* 'B' */
0x00, /*         */
0x00, /*         */
0x7c, /*  XXXXX  */
0x22, /*   X   X */
0x22, /*   X   X */
0x22, /*   X   X */
0x3c, /*   XXXX  */
0x22, /*   X   X */
0x22, /*   X   X */
0x22, /*   X   X */
0x22, /*   X   X */
0x7c, /*  XXXXX  */
0x00, /*         */
0x00, /*         */

/* 'C' */
0x00, /*         */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 'D' */
0x00, /*         */
0x00, /*         */
0x7c, /*  XXXXX  */
0x22, /*   X   X */
0x22, /*   X   X */
0x22, /*   X   X */
0x22, /*   X   X */
0x22, /*   X   X */
0x22, /*   X   X */
0x22, /*   X   X */
0x22, /*   X   X */
0x7c, /*  XXXXX  */
0x00, /*         */
0x00, /*         */

/* 'E' */
0x00, /*         */
0x00, /*         */
0x7e, /*  XXXXXX */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x78, /*  XXXX   */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x7e, /*  XXXXXX */
0x00, /*         */
0x00, /*         */

/* 'F' */
0x00, /*         */
0x00, /*         */
0x7e, /*  XXXXXX */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x78, /*  XXXX   */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x00, /*         */
0x00, /*         */

/* 'G' */
0x00, /*         */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x40, /*  X      */
0x40, /*  X      */
0x4e, /*  X  XXX */
0x42, /*  X    X */
0x42, /*  X    X */
0x46, /*  X   XX */
0x3a, /*   XXX X */
0x00, /*         */
0x00, /*         */

/* 'H' */
0x00, /*         */
0x00, /*         */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x7e, /*  XXXXXX */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x00, /*         */
0x00, /*         */

/* 'I' */
0x00, /*         */
0x00, /*         */
0x3e, /*   XXXXX */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x3e, /*   XXXXX */
0x00, /*         */
0x00, /*         */

/* 'J' */
0x00, /*         */
0x00, /*         */
0x0e, /*     XXX */
0x04, /*      X  */
0x04, /*      X  */
0x04, /*      X  */
0x04, /*      X  */
0x04, /*      X  */
0x04, /*      X  */
0x44, /*  X   X  */
0x44, /*  X   X  */
0x38, /*   XXX   */
0x00, /*         */
0x00, /*         */

/* 'K' */
0x00, /*         */
0x00, /*         */
0x42, /*  X    X */
0x44, /*  X   X  */
0x48, /*  X  X   */
0x50, /*  X X    */
0x60, /*  XX     */
0x50, /*  X X    */
0x48, /*  X  X   */
0x44, /*  X   X  */
0x42, /*  X    X */
0x42, /*  X    X */
0x00, /*         */
0x00, /*         */

/* 'L' */
0x00, /*         */
0x00, /*         */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x7e, /*  XXXXXX */
0x00, /*         */
0x00, /*         */

/* 'M' */
0x00, /*         */
0x00, /*         */
0x42, /*  X    X */
0x66, /*  XX  XX */
0x66, /*  XX  XX */
0x5a, /*  X XX X */
0x5a, /*  X XX X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x00, /*         */
0x00, /*         */

/* 'N' */
0x00, /*         */
0x00, /*         */
0x42, /*  X    X */
0x42, /*  X    X */
0x62, /*  XX   X */
0x62, /*  XX   X */
0x52, /*  X X  X */
0x4a, /*  X  X X */
0x46, /*  X   XX */
0x46, /*  X   XX */
0x42, /*  X    X */
0x42, /*  X    X */
0x00, /*         */
0x00, /*         */

/* 'O' */
0x00, /*         */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 'P' */
0x00, /*         */
0x00, /*         */
0x7c, /*  XXXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x7c, /*  XXXXX  */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x00, /*         */
0x00, /*         */

/* 'Q' */
0x00, /*         */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x72, /*  XXX  X */
0x4a, /*  X  X X */
0x46, /*  X   XX */
0x3c, /*   XXXX  */
0x04, /*      X  */
0x02, /*       X */

/* 'R' */
0x00, /*         */
0x00, /*         */
0x7c, /*  XXXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x7c, /*  XXXXX  */
0x48, /*  X  X   */
0x44, /*  X   X  */
0x42, /*  X    X */
0x42, /*  X    X */
0x00, /*         */
0x00, /*         */

/* 'S' */
0x00, /*         */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x40, /*  X      */
0x30, /*   XX    */
0x0c, /*     XX  */
0x02, /*       X */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 'T' */
0x00, /*         */
0x00, /*         */
0xfe, /* XXXXXXX */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x00, /*         */
0x00, /*         */

/* 'U' */
0x00, /*         */
0x00, /*         */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 'V' */
0x00, /*         */
0x00, /*         */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x24, /*   X  X  */
0x24, /*   X  X  */
0x24, /*   X  X  */
0x18, /*    XX   */
0x18, /*    XX   */
0x18, /*    XX   */
0x00, /*         */
0x00, /*         */

/* 'W' */
0x00, /*         */
0x00, /*         */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x5a, /*  X XX X */
0x5a, /*  X XX X */
0x66, /*  XX  XX */
0x66, /*  XX  XX */
0x42, /*  X    X */
0x00, /*         */
0x00, /*         */

/* 'X' */
0x00, /*         */
0x00, /*         */
0x42, /*  X    X */
0x42, /*  X    X */
0x24, /*   X  X  */
0x24, /*   X  X  */
0x18, /*    XX   */
0x18, /*    XX   */
0x24, /*   X  X  */
0x24, /*   X  X  */
0x42, /*  X    X */
0x42, /*  X    X */
0x00, /*         */
0x00, /*         */

/* 'Y' */
0x00, /*         */
0x00, /*         */
0x44, /*  X   X  */
0x44, /*  X   X  */
0x44, /*  X   X  */
0x28, /*   X X   */
0x28, /*   X X   */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x00, /*         */
0x00, /*         */

/* 'Z' */
0x00, /*         */
0x00, /*         */
0x7e, /*  XXXXXX */
0x02, /*       X */
0x04, /*      X  */
0x08, /*     X   */
0x08, /*     X   */
0x10, /*    X    */
0x20, /*   X     */
0x20, /*   X     */
0x40, /*  X      */
0x7e, /*  XXXXXX */
0x00, /*         */
0x00, /*         */

/* '[' */
0x00, /*         */
0x1e, /*    XXXX */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x1e, /*    XXXX */

/* '\' */
0x00, /*         */
0x40, /*  X      */
0x40, /*  X      */
0x20, /*   X     */
0x20, /*   X     */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x08, /*     X   */
0x08, /*     X   */
0x04, /*      X  */
0x04, /*      X  */
0x02, /*       X */
0x02, /*       X */

/* ']' */
0x00, /*         */
0x78, /*  XXXX   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x78, /*  XXXX   */

/* '^' */
0x00, /*         */
0x18, /*    XX   */
0x24, /*   X  X  */
0x42, /*  X    X */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* '_' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x7e, /*  XXXXXX */

/* '`' */
0x00, /*         */
0x0c, /*     XX  */
0x08, /*     X   */
0x08, /*     X   */
0x04, /*      X  */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* 'a' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x0e, /*     XXX */
0x32, /*   XX  X */
0x42, /*  X    X */
0x46, /*  X   XX */
0x3a, /*   XXX X */
0x00, /*         */
0x00, /*         */

/* 'b' */
0x00, /*         */
0x00, /*         */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x5c, /*  X XXX  */
0x62, /*  XX   X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x62, /*  XX   X */
0x5c, /*  X XXX  */
0x00, /*         */
0x00, /*         */

/* 'c' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 'd' */
0x00, /*         */
0x00, /*         */
0x02, /*       X */
0x02, /*       X */
0x02, /*       X */
0x3a, /*   XXX X */
0x46, /*  X   XX */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x46, /*  X   XX */
0x3a, /*   XXX X */
0x00, /*         */
0x00, /*         */

/* 'e' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x7e, /*  XXXXXX */
0x40, /*  X      */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 'f' */
0x00, /*         */
0x00, /*         */
0x0c, /*     XX  */
0x12, /*    X  X */
0x10, /*    X    */
0x10, /*    X    */
0x7c, /*  XXXXX  */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x00, /*         */
0x00, /*         */

/* 'g' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x3a, /*   XXX X */
0x44, /*  X   X  */
0x44, /*  X   X  */
0x44, /*  X   X  */
0x38, /*   XXX   */
0x20, /*   X     */
0x5c, /*  X XXX  */
0x42, /*  X    X */
0x3c, /*   XXXX  */

/* 'h' */
0x00, /*         */
0x00, /*         */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x5c, /*  X XXX  */
0x62, /*  XX   X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x00, /*         */
0x00, /*         */

/* 'i' */
0x00, /*         */
0x00, /*         */
0x08, /*     X   */
0x08, /*     X   */
0x00, /*         */
0x18, /*    XX   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x3e, /*   XXXXX */
0x00, /*         */
0x00, /*         */

/* 'j' */
0x00, /*         */
0x00, /*         */
0x04, /*      X  */
0x04, /*      X  */
0x00, /*         */
0x0c, /*     XX  */
0x04, /*      X  */
0x04, /*      X  */
0x04, /*      X  */
0x04, /*      X  */
0x04, /*      X  */
0x44, /*  X   X  */
0x44, /*  X   X  */
0x38, /*   XXX   */

/* 'k' */
0x00, /*         */
0x00, /*         */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x44, /*  X   X  */
0x48, /*  X  X   */
0x50, /*  X X    */
0x70, /*  XXX    */
0x48, /*  X  X   */
0x44, /*  X   X  */
0x42, /*  X    X */
0x00, /*         */
0x00, /*         */

/* 'l' */
0x00, /*         */
0x00, /*         */
0x18, /*    XX   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x3e, /*   XXXXX */
0x00, /*         */
0x00, /*         */

/* 'm' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x68, /*  XX X   */
0x54, /*  X X X  */
0x54, /*  X X X  */
0x54, /*  X X X  */
0x54, /*  X X X  */
0x54, /*  X X X  */
0x44, /*  X   X  */
0x00, /*         */
0x00, /*         */

/* 'n' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x5c, /*  X XXX  */
0x62, /*  XX   X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x00, /*         */
0x00, /*         */

/* 'o' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 'p' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x5c, /*  X XXX  */
0x62, /*  XX   X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x62, /*  XX   X */
0x5c, /*  X XXX  */
0x40, /*  X      */
0x40, /*  X      */

/* 'q' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x3a, /*   XXX X */
0x46, /*  X   XX */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x46, /*  X   XX */
0x3a, /*   XXX X */
0x02, /*       X */
0x02, /*       X */

/* 'r' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x5c, /*  X XXX  */
0x62, /*  XX   X */
0x42, /*  X    X */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x00, /*         */
0x00, /*         */

/* 's' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x20, /*   X     */
0x18, /*    XX   */
0x04, /*      X  */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 't' */
0x00, /*         */
0x00, /*         */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x7c, /*  XXXXX  */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x12, /*    X  X */
0x0c, /*     XX  */
0x00, /*         */
0x00, /*         */

/* 'u' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x46, /*  X   XX */
0x3a, /*   XXX X */
0x00, /*         */
0x00, /*         */

/* 'v' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x44, /*  X   X  */
0x44, /*  X   X  */
0x44, /*  X   X  */
0x28, /*   X X   */
0x28, /*   X X   */
0x10, /*    X    */
0x10, /*    X    */
0x00, /*         */
0x00, /*         */

/* 'w' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x44, /*  X   X  */
0x44, /*  X   X  */
0x54, /*  X X X  */
0x54, /*  X X X  */
0x54, /*  X X X  */
0x54, /*  X X X  */
0x28, /*   X X   */
0x00, /*         */
0x00, /*         */

/* 'x' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x42, /*  X    X */
0x42, /*  X    X */
0x24, /*   X  X  */
0x18, /*    XX   */
0x24, /*   X  X  */
0x42, /*  X    X */
0x42, /*  X    X */
0x00, /*         */
0x00, /*         */

/* 'y' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x46, /*  X   XX */
0x3a, /*   XXX X */
0x02, /*       X */
0x42, /*  X    X */
0x3c, /*   XXXX  */

/* 'z' */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x7e, /*  XXXXXX */
0x04, /*      X  */
0x08, /*     X   */
0x10, /*    X    */
0x10, /*    X    */
0x20, /*   X     */
0x7e, /*  XXXXXX */
0x00, /*         */
0x00, /*         */

/* '{' */
0x00, /*         */
0x06, /*      XX */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x10, /*    X    */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x06, /*      XX */

/* '|' */
0x00, /*         */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */

/* '}' */
0x00, /*         */
0x60, /*  XX     */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x08, /*     X   */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x60, /*  XX     */

/* '~' */
0x00, /*         */
0x20, /*   X     */
0x52, /*  X X  X */
0x4a, /*  X  X X */
0x04, /*      X  */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* 0x7f */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* 0xa0 */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* 0xa1 */
0x00, /*         */
0x00, /*         */
0x10, /*    X    */
0x10, /*    X    */
0x00, /*         */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x00, /*         */
0x00, /*         */

/* 0xa2 */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x10, /*    X    */
0x3e, /*   XXXXX */
0x52, /*  X X  X */
0x50, /*  X X    */
0x50, /*  X X    */
0x50, /*  X X    */
0x52, /*  X X  X */
0x3e, /*   XXXXX */
0x10, /*    X    */
0x00, /*         */

/* 0xa3 */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x18, /*    XX   */
0x24, /*   X  X  */
0x20, /*   X     */
0x20, /*   X     */
0x78, /*  XXXX   */
0x20, /*   X     */
0x20, /*   X     */
0x78, /*  XXXX   */
0x24, /*   X  X  */
0x00, /*         */
0x00, /*         */

/* 0xa4 */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x24, /*   X  X  */
0x24, /*   X  X  */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* 0xa5 */
0x00, /*         */
0x00, /*         */
0x42, /*  X    X */
0x24, /*   X  X  */
0x18, /*    XX   */
0x7e, /*  XXXXXX */
0x08, /*     X   */
0x08, /*     X   */
0x7e, /*  XXXXXX */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x00, /*         */
0x00, /*         */

/* 0xa6 */
0x00, /*         */
0x00, /*         */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x00, /*         */
0x00, /*         */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x00, /*         */
0x00, /*         */

/* 0xa7 */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x20, /*   X     */
0x18, /*    XX   */
0x24, /*   X  X  */
0x42, /*  X    X */
0x24, /*   X  X  */
0x18, /*    XX   */
0x04, /*      X  */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 0xa8 */
0x00, /*         */
0x48, /*  X  X   */
0x48, /*  X  X   */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* 0xa9 */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x5a, /*  X XX X */
0x66, /*  XX  XX */
0x62, /*  XX   X */
0x62, /*  XX   X */
0x62, /*  XX   X */
0x66, /*  XX  XX */
0x5a, /*  X XX X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 0xaa */
0x00, /*         */
0x1c, /*    XXX  */
0x22, /*   X   X */
0x1e, /*    XXXX */
0x22, /*   X   X */
0x26, /*   X  XX */
0x1a, /*    XX X */
0x00, /*         */
0x3e, /*   XXXXX */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* 0xab */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x0a, /*     X X */
0x14, /*    X X  */
0x28, /*   X X   */
0x50, /*  X X    */
0x28, /*   X X   */
0x14, /*    X X  */
0x0a, /*     X X */
0x00, /*         */
0x00, /*         */

/* 0xac */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0xf8, /* XXXXX   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x00, /*         */
0x00, /*         */

/* 0xad */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0xf0, /* XXXX    */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* 0xae */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x7a, /*  XXXX X */
0x66, /*  XX  XX */
0x66, /*  XX  XX */
0x7a, /*  XXXX X */
0x66, /*  XX  XX */
0x66, /*  XX  XX */
0x66, /*  XX  XX */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 0xaf */
0x00, /*         */
0x00, /*         */
0xf0, /* XXXX    */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* 0xb0 */
0x00, /*         */
0x30, /*   XX    */
0x48, /*  X  X   */
0x48, /*  X  X   */
0x30, /*   XX    */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* 0xb1 */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x10, /*    X    */
0x10, /*    X    */
0x7c, /*  XXXXX  */
0x10, /*    X    */
0x10, /*    X    */
0x7c, /*  XXXXX  */
0x00, /*         */
0x00, /*         */

/* 0xb2 */
0x00, /*         */
0x30, /*   XX    */
0x48, /*  X  X   */
0x08, /*     X   */
0x10, /*    X    */
0x20, /*   X     */
0x40, /*  X      */
0x78, /*  XXXX   */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* 0xb3 */
0x00, /*         */
0x30, /*   XX    */
0x48, /*  X  X   */
0x08, /*     X   */
0x30, /*   XX    */
0x08, /*     X   */
0x48, /*  X  X   */
0x30, /*   XX    */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* 0xb4 */
0x00, /*         */
0x08, /*     X   */
0x10, /*    X    */
0x20, /*   X     */
0x40, /*  X      */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* 0xb5 */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x44, /*  X   X  */
0x44, /*  X   X  */
0x44, /*  X   X  */
0x44, /*  X   X  */
0x6c, /*  XX XX  */
0x54, /*  X X X  */
0x40, /*  X      */
0x40, /*  X      */

/* 0xb6 */
0x00, /*         */
0x00, /*         */
0x3c, /*   XXXX  */
0x54, /*  X X X  */
0x54, /*  X X X  */
0x54, /*  X X X  */
0x54, /*  X X X  */
0x34, /*   XX X  */
0x14, /*    X X  */
0x14, /*    X X  */
0x14, /*    X X  */
0x14, /*    X X  */
0x14, /*    X X  */
0x1c, /*    XXX  */

/* 0xb7 */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x10, /*    X    */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* 0xb8 */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x10, /*    X    */
0x10, /*    X    */
0x20, /*   X     */

/* 0xb9 */
0x00, /*         */
0x00, /*         */
0x20, /*   X     */
0x60, /*  XX     */
0x20, /*   X     */
0x20, /*   X     */
0x20, /*   X     */
0x20, /*   X     */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* 0xba */
0x00, /*         */
0x00, /*         */
0x18, /*    XX   */
0x24, /*   X  X  */
0x24, /*   X  X  */
0x18, /*    XX   */
0x00, /*         */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */

/* 0xbb */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x50, /*  X X    */
0x28, /*   X X   */
0x14, /*    X X  */
0x0a, /*     X X */
0x14, /*    X X  */
0x28, /*   X X   */
0x50, /*  X X    */
0x00, /*         */
0x00, /*         */

/* 0xbc */
0x00, /*         */
0x00, /*         */
0x20, /*   X     */
0x62, /*  XX   X */
0x24, /*   X  X  */
0x24, /*   X  X  */
0x28, /*   X X   */
0x12, /*    X  X */
0x16, /*    X XX */
0x2a, /*   X X X */
0x4e, /*  X  XXX */
0x42, /*  X    X */
0x00, /*         */
0x00, /*         */

/* 0xbd */
0x00, /*         */
0x00, /*         */
0x20, /*   X     */
0x62, /*  XX   X */
0x24, /*   X  X  */
0x24, /*   X  X  */
0x28, /*   X X   */
0x14, /*    X X  */
0x1a, /*    XX X */
0x22, /*   X   X */
0x44, /*  X   X  */
0x4e, /*  X  XXX */
0x00, /*         */
0x00, /*         */

/* 0xbe */
0x00, /*         */
0x00, /*         */
0x62, /*  XX   X */
0x12, /*    X  X */
0x24, /*   X  X  */
0x18, /*    XX   */
0x68, /*  XX X   */
0x12, /*    X  X */
0x26, /*   X  XX */
0x2a, /*   X X X */
0x4e, /*  X  XXX */
0x02, /*       X */
0x00, /*         */
0x00, /*         */

/* 0xbf */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x08, /*     X   */
0x08, /*     X   */
0x00, /*         */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x04, /*      X  */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */

/* 0xc0 */
0x20, /*   X     */
0x18, /*    XX   */
0x00, /*         */
0x18, /*    XX   */
0x24, /*   X  X  */
0x42, /*  X    X */
0x42, /*  X    X */
0x7e, /*  XXXXXX */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x00, /*         */
0x00, /*         */

/* 0xc1 */
0x04, /*      X  */
0x18, /*    XX   */
0x00, /*         */
0x18, /*    XX   */
0x24, /*   X  X  */
0x42, /*  X    X */
0x42, /*  X    X */
0x7e, /*  XXXXXX */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x00, /*         */
0x00, /*         */

/* 0xc2 */
0x18, /*    XX   */
0x24, /*   X  X  */
0x00, /*         */
0x18, /*    XX   */
0x24, /*   X  X  */
0x42, /*  X    X */
0x42, /*  X    X */
0x7e, /*  XXXXXX */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x00, /*         */
0x00, /*         */

/* 0xc3 */
0x14, /*    X X  */
0x28, /*   X X   */
0x00, /*         */
0x18, /*    XX   */
0x24, /*   X  X  */
0x42, /*  X    X */
0x42, /*  X    X */
0x7e, /*  XXXXXX */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x00, /*         */
0x00, /*         */

/* 0xc4 */
0x24, /*   X  X  */
0x24, /*   X  X  */
0x00, /*         */
0x18, /*    XX   */
0x24, /*   X  X  */
0x42, /*  X    X */
0x42, /*  X    X */
0x7e, /*  XXXXXX */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x00, /*         */
0x00, /*         */

/* 0xc5 */
0x18, /*    XX   */
0x18, /*    XX   */
0x00, /*         */
0x18, /*    XX   */
0x24, /*   X  X  */
0x42, /*  X    X */
0x42, /*  X    X */
0x7e, /*  XXXXXX */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x00, /*         */
0x00, /*         */

/* 0xc6 */
0x00, /*         */
0x00, /*         */
0x3e, /*   XXXXX */
0x50, /*  X X    */
0x90, /* X  X    */
0x90, /* X  X    */
0xfc, /* XXXXXX  */
0x90, /* X  X    */
0x90, /* X  X    */
0x90, /* X  X    */
0x90, /* X  X    */
0x9e, /* X  XXXX */
0x00, /*         */
0x00, /*         */

/* 0xc7 */
0x00, /*         */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x08, /*     X   */
0x10, /*    X    */

/* 0xc8 */
0x20, /*   X     */
0x18, /*    XX   */
0x00, /*         */
0x7e, /*  XXXXXX */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x7c, /*  XXXXX  */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x7e, /*  XXXXXX */
0x00, /*         */
0x00, /*         */

/* 0xc9 */
0x04, /*      X  */
0x18, /*    XX   */
0x00, /*         */
0x7e, /*  XXXXXX */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x7c, /*  XXXXX  */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x7e, /*  XXXXXX */
0x00, /*         */
0x00, /*         */

/* 0xca */
0x18, /*    XX   */
0x24, /*   X  X  */
0x00, /*         */
0x7e, /*  XXXXXX */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x7c, /*  XXXXX  */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x7e, /*  XXXXXX */
0x00, /*         */
0x00, /*         */

/* 0xcb */
0x00, /*         */
0x24, /*   X  X  */
0x00, /*         */
0x7e, /*  XXXXXX */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x7c, /*  XXXXX  */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x7e, /*  XXXXXX */
0x00, /*         */
0x00, /*         */

/* 0xcc */
0x10, /*    X    */
0x0c, /*     XX  */
0x00, /*         */
0x3e, /*   XXXXX */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x3e, /*   XXXXX */
0x00, /*         */
0x00, /*         */

/* 0xcd */
0x04, /*      X  */
0x18, /*    XX   */
0x00, /*         */
0x3e, /*   XXXXX */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x3e, /*   XXXXX */
0x00, /*         */
0x00, /*         */

/* 0xce */
0x08, /*     X   */
0x14, /*    X X  */
0x00, /*         */
0x3e, /*   XXXXX */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x3e, /*   XXXXX */
0x00, /*         */
0x00, /*         */

/* 0xcf */
0x00, /*         */
0x14, /*    X X  */
0x00, /*         */
0x3e, /*   XXXXX */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x3e, /*   XXXXX */
0x00, /*         */
0x00, /*         */

/* 0xd0 */
0x00, /*         */
0x00, /*         */
0x78, /*  XXXX   */
0x44, /*  X   X  */
0x42, /*  X    X */
0x42, /*  X    X */
0xf2, /* XXXX  X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x44, /*  X   X  */
0x78, /*  XXXX   */
0x00, /*         */
0x00, /*         */

/* 0xd1 */
0x14, /*    X X  */
0x28, /*   X X   */
0x00, /*         */
0x62, /*  XX   X */
0x62, /*  XX   X */
0x52, /*  X X  X */
0x52, /*  X X  X */
0x4a, /*  X  X X */
0x4a, /*  X  X X */
0x4a, /*  X  X X */
0x46, /*  X   XX */
0x46, /*  X   XX */
0x00, /*         */
0x00, /*         */

/* 0xd2 */
0x20, /*   X     */
0x18, /*    XX   */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 0xd3 */
0x04, /*      X  */
0x18, /*    XX   */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 0xd4 */
0x18, /*    XX   */
0x24, /*   X  X  */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 0xd5 */
0x14, /*    X X  */
0x28, /*   X X   */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 0xd6 */
0x00, /*         */
0x24, /*   X  X  */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 0xd7 */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x82, /* X     X */
0x44, /*  X   X  */
0x28, /*   X X   */
0x10, /*    X    */
0x28, /*   X X   */
0x44, /*  X   X  */
0x82, /* X     X */
0x00, /*         */
0x00, /*         */

/* 0xd8 */
0x02, /*       X */
0x02, /*       X */
0x3c, /*   XXXX  */
0x46, /*  X   XX */
0x4a, /*  X  X X */
0x4a, /*  X  X X */
0x4a, /*  X  X X */
0x52, /*  X X  X */
0x52, /*  X X  X */
0x52, /*  X X  X */
0x62, /*  XX   X */
0x3c, /*   XXXX  */
0x40, /*  X      */
0x40, /*  X      */

/* 0xd9 */
0x20, /*   X     */
0x18, /*    XX   */
0x00, /*         */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 0xda */
0x04, /*      X  */
0x18, /*    XX   */
0x00, /*         */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 0xdb */
0x18, /*    XX   */
0x24, /*   X  X  */
0x00, /*         */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 0xdc */
0x00, /*         */
0x24, /*   X  X  */
0x00, /*         */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 0xdd */
0x04, /*      X  */
0x18, /*    XX   */
0x42, /*  X    X */
0x42, /*  X    X */
0x44, /*  X   X  */
0x24, /*   X  X  */
0x28, /*   X X   */
0x18, /*    XX   */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x10, /*    X    */
0x00, /*         */
0x00, /*         */

/* 0xde */
0x00, /*         */
0x00, /*         */
0x40, /*  X      */
0x40, /*  X      */
0x7c, /*  XXXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x7c, /*  XXXXX  */
0x40, /*  X      */
0x40, /*  X      */
0x00, /*         */
0x00, /*         */

/* 0xdf */
0x00, /*         */
0x00, /*         */
0x18, /*    XX   */
0x24, /*   X  X  */
0x24, /*   X  X  */
0x24, /*   X  X  */
0x38, /*   XXX   */
0x24, /*   X  X  */
0x22, /*   X   X */
0x22, /*   X   X */
0x22, /*   X   X */
0x7c, /*  XXXXX  */
0x00, /*         */
0x00, /*         */

/* 0xe0 */
0x00, /*         */
0x20, /*   X     */
0x10, /*    X    */
0x08, /*     X   */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x0e, /*     XXX */
0x32, /*   XX  X */
0x42, /*  X    X */
0x46, /*  X   XX */
0x3a, /*   XXX X */
0x00, /*         */
0x00, /*         */

/* 0xe1 */
0x00, /*         */
0x04, /*      X  */
0x08, /*     X   */
0x10, /*    X    */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x0e, /*     XXX */
0x32, /*   XX  X */
0x42, /*  X    X */
0x46, /*  X   XX */
0x3a, /*   XXX X */
0x00, /*         */
0x00, /*         */

/* 0xe2 */
0x00, /*         */
0x00, /*         */
0x18, /*    XX   */
0x24, /*   X  X  */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x0e, /*     XXX */
0x32, /*   XX  X */
0x42, /*  X    X */
0x46, /*  X   XX */
0x3a, /*   XXX X */
0x00, /*         */
0x00, /*         */

/* 0xe3 */
0x00, /*         */
0x00, /*         */
0x14, /*    X X  */
0x28, /*   X X   */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x0e, /*     XXX */
0x32, /*   XX  X */
0x42, /*  X    X */
0x46, /*  X   XX */
0x3a, /*   XXX X */
0x00, /*         */
0x00, /*         */

/* 0xe4 */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x24, /*   X  X  */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x0e, /*     XXX */
0x32, /*   XX  X */
0x42, /*  X    X */
0x46, /*  X   XX */
0x3a, /*   XXX X */
0x00, /*         */
0x00, /*         */

/* 0xe5 */
0x00, /*         */
0x10, /*    X    */
0x28, /*   X X   */
0x10, /*    X    */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x0e, /*     XXX */
0x32, /*   XX  X */
0x42, /*  X    X */
0x46, /*  X   XX */
0x3a, /*   XXX X */
0x00, /*         */
0x00, /*         */

/* 0xe6 */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x7c, /*  XXXXX  */
0x92, /* X  X  X */
0x32, /*   XX  X */
0x5e, /*  X XXXX */
0x90, /* X  X    */
0x92, /* X  X  X */
0x7c, /*  XXXXX  */
0x00, /*         */
0x00, /*         */

/* 0xe7 */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x08, /*     X   */
0x10, /*    X    */

/* 0xe8 */
0x00, /*         */
0x20, /*   X     */
0x10, /*    X    */
0x08, /*     X   */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x7e, /*  XXXXXX */
0x40, /*  X      */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 0xe9 */
0x00, /*         */
0x04, /*      X  */
0x08, /*     X   */
0x10, /*    X    */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x7e, /*  XXXXXX */
0x40, /*  X      */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 0xea */
0x00, /*         */
0x00, /*         */
0x18, /*    XX   */
0x24, /*   X  X  */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x7e, /*  XXXXXX */
0x40, /*  X      */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 0xeb */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x24, /*   X  X  */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x7e, /*  XXXXXX */
0x40, /*  X      */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 0xec */
0x00, /*         */
0x10, /*    X    */
0x08, /*     X   */
0x04, /*      X  */
0x00, /*         */
0x18, /*    XX   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x3e, /*   XXXXX */
0x00, /*         */
0x00, /*         */

/* 0xed */
0x00, /*         */
0x04, /*      X  */
0x08, /*     X   */
0x10, /*    X    */
0x00, /*         */
0x18, /*    XX   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x3e, /*   XXXXX */
0x00, /*         */
0x00, /*         */

/* 0xee */
0x00, /*         */
0x00, /*         */
0x18, /*    XX   */
0x24, /*   X  X  */
0x00, /*         */
0x18, /*    XX   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x3e, /*   XXXXX */
0x00, /*         */
0x00, /*         */

/* 0xef */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x14, /*    X X  */
0x00, /*         */
0x18, /*    XX   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x08, /*     X   */
0x3e, /*   XXXXX */
0x00, /*         */
0x00, /*         */

/* 0xf0 */
0x00, /*         */
0x28, /*   X X   */
0x10, /*    X    */
0x28, /*   X X   */
0x04, /*      X  */
0x3c, /*   XXXX  */
0x44, /*  X   X  */
0x44, /*  X   X  */
0x44, /*  X   X  */
0x44, /*  X   X  */
0x44, /*  X   X  */
0x38, /*   XXX   */
0x00, /*         */
0x00, /*         */

/* 0xf1 */
0x00, /*         */
0x00, /*         */
0x14, /*    X X  */
0x28, /*   X X   */
0x00, /*         */
0x5c, /*  X XXX  */
0x62, /*  XX   X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x00, /*         */
0x00, /*         */

/* 0xf2 */
0x00, /*         */
0x20, /*   X     */
0x10, /*    X    */
0x08, /*     X   */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 0xf3 */
0x00, /*         */
0x04, /*      X  */
0x08, /*     X   */
0x10, /*    X    */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 0xf4 */
0x00, /*         */
0x00, /*         */
0x18, /*    XX   */
0x24, /*   X  X  */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 0xf5 */
0x00, /*         */
0x00, /*         */
0x14, /*    X X  */
0x28, /*   X X   */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 0xf6 */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x24, /*   X  X  */
0x00, /*         */
0x3c, /*   XXXX  */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x3c, /*   XXXX  */
0x00, /*         */
0x00, /*         */

/* 0xf7 */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x30, /*   XX    */
0x00, /*         */
0xfc, /* XXXXXX  */
0x00, /*         */
0x30, /*   XX    */
0x00, /*         */
0x00, /*         */

/* 0xf8 */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x02, /*       X */
0x04, /*      X  */
0x3c, /*   XXXX  */
0x4a, /*  X  X X */
0x4a, /*  X  X X */
0x52, /*  X X  X */
0x52, /*  X X  X */
0x62, /*  XX   X */
0x3c, /*   XXXX  */
0x40, /*  X      */
0x40, /*  X      */

/* 0xf9 */
0x00, /*         */
0x00, /*         */
0x20, /*   X     */
0x10, /*    X    */
0x08, /*     X   */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x46, /*  X   XX */
0x3a, /*   XXX X */
0x00, /*         */
0x00, /*         */

/* 0xfa */
0x00, /*         */
0x00, /*         */
0x04, /*      X  */
0x08, /*     X   */
0x10, /*    X    */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x46, /*  X   XX */
0x3a, /*   XXX X */
0x00, /*         */
0x00, /*         */

/* 0xfb */
0x00, /*         */
0x00, /*         */
0x18, /*    XX   */
0x24, /*   X  X  */
0x00, /*         */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x46, /*  X   XX */
0x3a, /*   XXX X */
0x00, /*         */
0x00, /*         */

/* 0xfc */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x24, /*   X  X  */
0x00, /*         */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x46, /*  X   XX */
0x3a, /*   XXX X */
0x00, /*         */
0x00, /*         */

/* 0xfd */
0x00, /*         */
0x00, /*         */
0x04, /*      X  */
0x08, /*     X   */
0x10, /*    X    */
0x42, /*  X    X */
0x42, /*  X    X */
0x22, /*   X   X */
0x24, /*   X  X  */
0x14, /*    X X  */
0x1c, /*    XXX  */
0x08, /*     X   */
0x48, /*  X  X   */
0x30, /*   XX    */

/* 0xfe */
0x00, /*         */
0x00, /*         */
0x40, /*  X      */
0x40, /*  X      */
0x40, /*  X      */
0x5c, /*  X XXX  */
0x62, /*  XX   X */
0x42, /*  X    X */
0x42, /*  X    X */
0x42, /*  X    X */
0x62, /*  XX   X */
0x5c, /*  X XXX  */
0x40, /*  X      */
0x40, /*  X      */

/* 0xff */
0x00, /*         */
0x00, /*         */
0x00, /*         */
0x24, /*   X  X  */
0x00, /*         */
0x42, /*  X    X */
0x42, /*  X    X */
0x22, /*   X   X */
0x24, /*   X  X  */
0x14, /*    X X  */
0x1c, /*    XXX  */
0x08, /*     X   */
0x48, /*  X  X   */
0x30, /*   XX    */
};

static unsigned char *ENCODINGS[256] = {
	FONTDATA+238,
	FONTDATA+0,
	FONTDATA+14,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+28,
	FONTDATA+42,
	FONTDATA+56,
	FONTDATA+70,
	FONTDATA+84,
	FONTDATA+98,
	FONTDATA+112,
	FONTDATA+126,
	FONTDATA+140,
	FONTDATA+154,
	FONTDATA+168,
	FONTDATA+182,
	FONTDATA+196,
	FONTDATA+210,
	FONTDATA+224,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+252,
	FONTDATA+266,
	FONTDATA+280,
	FONTDATA+294,
	FONTDATA+308,
	FONTDATA+322,
	FONTDATA+336,
	FONTDATA+350,
	FONTDATA+364,
	FONTDATA+378,
	FONTDATA+392,
	FONTDATA+406,
	FONTDATA+420,
	FONTDATA+434,
	FONTDATA+448,
	FONTDATA+462,
	FONTDATA+476,
	FONTDATA+490,
	FONTDATA+504,
	FONTDATA+518,
	FONTDATA+532,
	FONTDATA+546,
	FONTDATA+560,
	FONTDATA+574,
	FONTDATA+588,
	FONTDATA+602,
	FONTDATA+616,
	FONTDATA+630,
	FONTDATA+644,
	FONTDATA+658,
	FONTDATA+672,
	FONTDATA+686,
	FONTDATA+700,
	FONTDATA+714,
	FONTDATA+728,
	FONTDATA+742,
	FONTDATA+756,
	FONTDATA+770,
	FONTDATA+784,
	FONTDATA+798,
	FONTDATA+812,
	FONTDATA+826,
	FONTDATA+840,
	FONTDATA+854,
	FONTDATA+868,
	FONTDATA+882,
	FONTDATA+896,
	FONTDATA+910,
	FONTDATA+924,
	FONTDATA+938,
	FONTDATA+952,
	FONTDATA+966,
	FONTDATA+980,
	FONTDATA+994,
	FONTDATA+1008,
	FONTDATA+1022,
	FONTDATA+1036,
	FONTDATA+1050,
	FONTDATA+1064,
	FONTDATA+1078,
	FONTDATA+1092,
	FONTDATA+1106,
	FONTDATA+1120,
	FONTDATA+1134,
	FONTDATA+1148,
	FONTDATA+1162,
	FONTDATA+1176,
	FONTDATA+1190,
	FONTDATA+1204,
	FONTDATA+1218,
	FONTDATA+1232,
	FONTDATA+1246,
	FONTDATA+1260,
	FONTDATA+1274,
	FONTDATA+1288,
	FONTDATA+1302,
	FONTDATA+1316,
	FONTDATA+1330,
	FONTDATA+1344,
	FONTDATA+1358,
	FONTDATA+1372,
	FONTDATA+1386,
	FONTDATA+1400,
	FONTDATA+1414,
	FONTDATA+1428,
	FONTDATA+1442,
	FONTDATA+1456,
	FONTDATA+1470,
	FONTDATA+1484,
	FONTDATA+1498,
	FONTDATA+1512,
	FONTDATA+1526,
	FONTDATA+1540,
	FONTDATA+1554,
	FONTDATA+1568,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+238,
	FONTDATA+1582,
	FONTDATA+1596,
	FONTDATA+1610,
	FONTDATA+1624,
	FONTDATA+1638,
	FONTDATA+1652,
	FONTDATA+1666,
	FONTDATA+1680,
	FONTDATA+1694,
	FONTDATA+1708,
	FONTDATA+1722,
	FONTDATA+1736,
	FONTDATA+1750,
	FONTDATA+1764,
	FONTDATA+1778,
	FONTDATA+1792,
	FONTDATA+1806,
	FONTDATA+1820,
	FONTDATA+1834,
	FONTDATA+1848,
	FONTDATA+1862,
	FONTDATA+1876,
	FONTDATA+1890,
	FONTDATA+1904,
	FONTDATA+1918,
	FONTDATA+1932,
	FONTDATA+1946,
	FONTDATA+1960,
	FONTDATA+1974,
	FONTDATA+1988,
	FONTDATA+2002,
	FONTDATA+2016,
	FONTDATA+2030,
	FONTDATA+2044,
	FONTDATA+2058,
	FONTDATA+2072,
	FONTDATA+2086,
	FONTDATA+2100,
	FONTDATA+2114,
	FONTDATA+2128,
	FONTDATA+2142,
	FONTDATA+2156,
	FONTDATA+2170,
	FONTDATA+2184,
	FONTDATA+2198,
	FONTDATA+2212,
	FONTDATA+2226,
	FONTDATA+2240,
	FONTDATA+2254,
	FONTDATA+2268,
	FONTDATA+2282,
	FONTDATA+2296,
	FONTDATA+2310,
	FONTDATA+2324,
	FONTDATA+2338,
	FONTDATA+2352,
	FONTDATA+2366,
	FONTDATA+2380,
	FONTDATA+2394,
	FONTDATA+2408,
	FONTDATA+2422,
	FONTDATA+2436,
	FONTDATA+2450,
	FONTDATA+2464,
	FONTDATA+2478,
	FONTDATA+2492,
	FONTDATA+2506,
	FONTDATA+2520,
	FONTDATA+2534,
	FONTDATA+2548,
	FONTDATA+2562,
	FONTDATA+2576,
	FONTDATA+2590,
	FONTDATA+2604,
	FONTDATA+2618,
	FONTDATA+2632,
	FONTDATA+2646,
	FONTDATA+2660,
	FONTDATA+2674,
	FONTDATA+2688,
	FONTDATA+2702,
	FONTDATA+2716,
	FONTDATA+2730,
	FONTDATA+2744,
	FONTDATA+2758,
	FONTDATA+2772,
	FONTDATA+2786,
	FONTDATA+2800,
	FONTDATA+2814,
	FONTDATA+2828,
	FONTDATA+2842,
	FONTDATA+2856,
	FONTDATA+2870,
	FONTDATA+2884,
	FONTDATA+2898,
	FONTDATA+2912,
};
bitmap_data_t   font_data_7x14 = {
    7, 14,	/* width, height */
    FONTDATA,	/* image */
    ENCODINGS,	/* encoding */
};

/* END CSTYLED */
