/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2009 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _SMBSRV_NTSTATUS_H
#define	_SMBSRV_NTSTATUS_H

/*
 * This file defines the list of NT status codes.
 *
 * Be careful not to confuse status codes with error
 * codes. The error codes are listed in nterror.h.
 */

#include <smbsrv/wintypes.h>


#ifdef __cplusplus
extern "C" {
#endif


/*
 * Status codes are 32-bit values in which the top 2 bits represent
 * the severity and the lower 16-bits contain a Win32 status code.
 * The severity levels are:
 *
 *      00  success
 *      01  information
 *      10  warning
 *      11  error
 *
 * NT also defines an application mask, which is included here
 * for completeness.
 */
#define	APPLICATION_ERROR_MASK		0x20000000
#define	ERROR_SEVERITY_SUCCESS		0x00000000
#define	ERROR_SEVERITY_INFORMATIONAL	0x40000000
#define	ERROR_SEVERITY_WARNING		0x80000000
#define	ERROR_SEVERITY_ERROR		0xC0000000

/*
 * Severity code helper macros.
 */
#define	NT_SC_SUCCESS(STATUS)	(ERROR_SEVERITY_SUCCESS+(STATUS))
#define	NT_SC_INFO(STATUS)	(ERROR_SEVERITY_INFORMATIONAL+(STATUS))
#define	NT_SC_WARNING(STATUS)	(ERROR_SEVERITY_WARNING+(STATUS))
#define	NT_SC_ERROR(STATUS)	(ERROR_SEVERITY_ERROR+(STATUS))

#define	NT_SC_IS_SUCCESS(S)	(((S) & 0xC0000000) == ERROR_SEVERITY_SUCCESS)
#define	NT_SC_IS_INFO(S) (((S) & 0xC0000000) == ERROR_SEVERITY_INFORMATIONAL)
#define	NT_SC_IS_WARNING(S)	(((S) & 0xC0000000) == ERROR_SEVERITY_WARNING)
#define	NT_SC_IS_ERROR(S)	(((S) & 0xC0000000) == ERROR_SEVERITY_ERROR)

#define	NT_SC_VALUE(S)		((S) & 0x0FFFFFFF)

/*
 * Win32 status codes
 */
#define	NT_STATUS_SUCCESS				0
#define	NT_STATUS_UNSUCCESSFUL				1
#define	NT_STATUS_NOT_IMPLEMENTED			2
#define	NT_STATUS_INVALID_INFO_CLASS			3
#define	NT_STATUS_INFO_LENGTH_MISMATCH			4
#define	NT_STATUS_BUFFER_OVERFLOW			5
#define	NT_STATUS_NO_MORE_FILES				6
#define	NT_STATUS_IN_PAGE_ERROR			NT_STATUS_NO_MORE_FILES
#define	NT_STATUS_PAGEFILE_QUOTA			7
#define	NT_STATUS_INVALID_HANDLE			8
#define	NT_STATUS_BAD_INITIAL_STACK			9
#define	NT_STATUS_BAD_INITIAL_PC			10
#define	NT_STATUS_INVALID_CID				11
#define	NT_STATUS_TIMER_NOT_CANCELED			12
#define	NT_STATUS_INVALID_PARAMETER			13
#define	NT_STATUS_NO_SUCH_DEVICE			14
#define	NT_STATUS_NO_SUCH_FILE				15
#define	NT_STATUS_INVALID_DEVICE_REQUEST		16
#define	NT_STATUS_END_OF_FILE				17
#define	NT_STATUS_WRONG_VOLUME				18
#define	NT_STATUS_NO_MEDIA_IN_DEVICE			19
#define	NT_STATUS_UNRECOGNIZED_MEDIA			20
#define	NT_STATUS_NONEXISTENT_SECTOR			21
#define	NT_STATUS_MORE_PROCESSING_REQUIRED		22
#define	NT_STATUS_NO_MEMORY				23
#define	NT_STATUS_CONFLICTING_ADDRESSES			24
#define	NT_STATUS_NOT_MAPPED_VIEW			25
#define	NT_STATUS_UNABLE_TO_FREE_VM			26
#define	NT_STATUS_NO_MORE_DATA			NT_STATUS_UNABLE_TO_FREE_VM
#define	NT_STATUS_UNABLE_TO_DELETE_SECTION		27
#define	NT_STATUS_INVALID_SYSTEM_SERVICE		28
#define	NT_STATUS_ILLEGAL_INSTRUCTION			29
#define	NT_STATUS_INVALID_LOCK_SEQUENCE			30
#define	NT_STATUS_INVALID_VIEW_SIZE			31
#define	NT_STATUS_INVALID_FILE_FOR_SECTION		32
#define	NT_STATUS_ALREADY_COMMITTED			33
#define	NT_STATUS_ACCESS_DENIED				34
#define	NT_STATUS_BUFFER_TOO_SMALL			35
#define	NT_STATUS_OBJECT_TYPE_MISMATCH			36
#define	NT_STATUS_NONCONTINUABLE_EXCEPTION		37
#define	NT_STATUS_INVALID_DISPOSITION			38
#define	NT_STATUS_UNWIND				39
#define	NT_STATUS_BAD_STACK				40
#define	NT_STATUS_INVALID_UNWIND_TARGET			41
#define	NT_STATUS_NOT_LOCKED				42
#define	NT_STATUS_PARITY_ERROR				43
#define	NT_STATUS_UNABLE_TO_DECOMMIT_VM			44
#define	NT_STATUS_NOT_COMMITTED				45
#define	NT_STATUS_INVALID_PORT_ATTRIBUTES		46
#define	NT_STATUS_PORT_MESSAGE_TOO_LONG			47
#define	NT_STATUS_INVALID_PARAMETER_MIX			48
#define	NT_STATUS_INVALID_QUOTA_LOWER			49
#define	NT_STATUS_DISK_CORRUPT_ERROR			50
#define	NT_STATUS_OBJECT_NAME_INVALID			51
#define	NT_STATUS_OBJECT_NAME_NOT_FOUND			52
#define	NT_STATUS_OBJECT_NAME_COLLISION			53
#define	NT_STATUS_HANDLE_NOT_WAITABLE			54
#define	NT_STATUS_PORT_DISCONNECTED			55
#define	NT_STATUS_DEVICE_ALREADY_ATTACHED		56
#define	NT_STATUS_OBJECT_PATH_INVALID			57
#define	NT_STATUS_OBJECT_PATH_NOT_FOUND			58
#define	NT_STATUS_OBJECT_PATH_SYNTAX_BAD		59
#define	NT_STATUS_DATA_OVERRUN				60
#define	NT_STATUS_DATA_LATE_ERROR			61
#define	NT_STATUS_DATA_ERROR				62
#define	NT_STATUS_CRC_ERROR				63
#define	NT_STATUS_SECTION_TOO_BIG			64
#define	NT_STATUS_PORT_CONNECTION_REFUSED		65
#define	NT_STATUS_INVALID_PORT_HANDLE			66
#define	NT_STATUS_SHARING_VIOLATION			67
#define	NT_STATUS_QUOTA_EXCEEDED			68
#define	NT_STATUS_INVALID_PAGE_PROTECTION		69
#define	NT_STATUS_MUTANT_NOT_OWNED			70
#define	NT_STATUS_SEMAPHORE_LIMIT_EXCEEDED		71
#define	NT_STATUS_PORT_ALREADY_SET			72
#define	NT_STATUS_SECTION_NOT_IMAGE			73
#define	NT_STATUS_SUSPEND_COUNT_EXCEEDED		74
#define	NT_STATUS_THREAD_IS_TERMINATING			75
#define	NT_STATUS_BAD_WORKING_SET_LIMIT			76
#define	NT_STATUS_INCOMPATIBLE_FILE_MAP			77
#define	NT_STATUS_SECTION_PROTECTION			78
#define	NT_STATUS_EAS_NOT_SUPPORTED			79
#define	NT_STATUS_EA_TOO_LARGE				80
#define	NT_STATUS_NONEXISTENT_EA_ENTRY			81
#define	NT_STATUS_NO_EAS_ON_FILE			82
#define	NT_STATUS_EA_CORRUPT_ERROR			83
#define	NT_STATUS_FILE_LOCK_CONFLICT			84
#define	NT_STATUS_LOCK_NOT_GRANTED			85
#define	NT_STATUS_DELETE_PENDING			86
#define	NT_STATUS_CTL_FILE_NOT_SUPPORTED		87
#define	NT_STATUS_UNKNOWN_REVISION			88
#define	NT_STATUS_REVISION_MISMATCH			89
#define	NT_STATUS_INVALID_OWNER				90
#define	NT_STATUS_INVALID_PRIMARY_GROUP			91
#define	NT_STATUS_NO_IMPERSONATION_TOKEN		92
#define	NT_STATUS_CANT_DISABLE_MANDATORY		93
#define	NT_STATUS_NO_LOGON_SERVERS			94
#define	NT_STATUS_NO_SUCH_LOGON_SESSION			95
#define	NT_STATUS_NO_SUCH_PRIVILEGE			96
#define	NT_STATUS_PRIVILEGE_NOT_HELD			97
#define	NT_STATUS_INVALID_ACCOUNT_NAME			98
#define	NT_STATUS_USER_EXISTS				99
#define	NT_STATUS_NO_SUCH_USER				100
#define	NT_STATUS_GROUP_EXISTS				101
#define	NT_STATUS_NO_SUCH_GROUP				102
#define	NT_STATUS_MEMBER_IN_GROUP			103
#define	NT_STATUS_MEMBER_NOT_IN_GROUP			104
#define	NT_STATUS_LAST_ADMIN				105
#define	NT_STATUS_WRONG_PASSWORD			106
#define	NT_STATUS_ILL_FORMED_PASSWORD			107
#define	NT_STATUS_PASSWORD_RESTRICTION			108
#define	NT_STATUS_LOGON_FAILURE				109
#define	NT_STATUS_ACCOUNT_RESTRICTION			110
#define	NT_STATUS_INVALID_LOGON_HOURS			111
#define	NT_STATUS_INVALID_WORKSTATION			112
#define	NT_STATUS_PASSWORD_EXPIRED			113
#define	NT_STATUS_ACCOUNT_DISABLED			114
#define	NT_STATUS_NONE_MAPPED				115
#define	NT_STATUS_TOO_MANY_LUIDS_REQUESTED		116
#define	NT_STATUS_LUIDS_EXHAUSTED			117
#define	NT_STATUS_INVALID_SUB_AUTHORITY			118
#define	NT_STATUS_INVALID_ACL				119
#define	NT_STATUS_INVALID_SID				120
#define	NT_STATUS_INVALID_SECURITY_DESCR		121
#define	NT_STATUS_PROCEDURE_NOT_FOUND			122
#define	NT_STATUS_INVALID_IMAGE_FORMAT			123
#define	NT_STATUS_NO_TOKEN				124
#define	NT_STATUS_BAD_INHERITANCE_ACL			125
#define	NT_STATUS_RANGE_NOT_LOCKED			126
#define	NT_STATUS_DISK_FULL				127
#define	NT_STATUS_SERVER_DISABLED			128
#define	NT_STATUS_SERVER_NOT_DISABLED			129
#define	NT_STATUS_TOO_MANY_GUIDS_REQUESTED		130
#define	NT_STATUS_GUIDS_EXHAUSTED			131
#define	NT_STATUS_INVALID_ID_AUTHORITY			132
#define	NT_STATUS_AGENTS_EXHAUSTED			133
#define	NT_STATUS_INVALID_VOLUME_LABEL			134
#define	NT_STATUS_SECTION_NOT_EXTENDED			135
#define	NT_STATUS_NOT_MAPPED_DATA			136
#define	NT_STATUS_RESOURCE_DATA_NOT_FOUND		137
#define	NT_STATUS_RESOURCE_TYPE_NOT_FOUND		138
#define	NT_STATUS_RESOURCE_NAME_NOT_FOUND		139
#define	NT_STATUS_ARRAY_BOUNDS_EXCEEDED			140
#define	NT_STATUS_FLOAT_DENORMAL_OPERAND		141
#define	NT_STATUS_FLOAT_DIVIDE_BY_ZERO			142
#define	NT_STATUS_FLOAT_INEXACT_RESULT			143
#define	NT_STATUS_FLOAT_INVALID_OPERATION		144
#define	NT_STATUS_FLOAT_OVERFLOW			145
#define	NT_STATUS_FLOAT_STACK_CHECK			146
#define	NT_STATUS_FLOAT_UNDERFLOW			147
#define	NT_STATUS_INTEGER_DIVIDE_BY_ZERO		148
#define	NT_STATUS_INTEGER_OVERFLOW			149
#define	NT_STATUS_PRIVILEGED_INSTRUCTION		150
#define	NT_STATUS_TOO_MANY_PAGING_FILES			151
#define	NT_STATUS_FILE_INVALID				152
#define	NT_STATUS_ALLOTTED_SPACE_EXCEEDED		153
#define	NT_STATUS_INSUFFICIENT_RESOURCES		154
#define	NT_STATUS_DFS_EXIT_PATH_FOUND			155
#define	NT_STATUS_DEVICE_DATA_ERROR			156
#define	NT_STATUS_DEVICE_NOT_CONNECTED			157
#define	NT_STATUS_DEVICE_POWER_FAILURE			158
#define	NT_STATUS_FREE_VM_NOT_AT_BASE			159
#define	NT_STATUS_MEMORY_NOT_ALLOCATED			160
#define	NT_STATUS_WORKING_SET_QUOTA			161
#define	NT_STATUS_MEDIA_WRITE_PROTECTED			162
#define	NT_STATUS_DEVICE_NOT_READY			163
#define	NT_STATUS_INVALID_GROUP_ATTRIBUTES		164
#define	NT_STATUS_BAD_IMPERSONATION_LEVEL		165
#define	NT_STATUS_CANT_OPEN_ANONYMOUS			166
#define	NT_STATUS_BAD_VALIDATION_CLASS			167
#define	NT_STATUS_BAD_TOKEN_TYPE			168
#define	NT_STATUS_BAD_MASTER_BOOT_RECORD		169
#define	NT_STATUS_INSTRUCTION_MISALIGNMENT		170
#define	NT_STATUS_INSTANCE_NOT_AVAILABLE		171
#define	NT_STATUS_PIPE_NOT_AVAILABLE			172
#define	NT_STATUS_INVALID_PIPE_STATE			173
#define	NT_STATUS_PIPE_BUSY				174
#define	NT_STATUS_ILLEGAL_FUNCTION			175
#define	NT_STATUS_PIPE_DISCONNECTED			176
#define	NT_STATUS_PIPE_CLOSING				177
#define	NT_STATUS_PIPE_CONNECTED			178
#define	NT_STATUS_PIPE_LISTENING			179
#define	NT_STATUS_INVALID_READ_MODE			180
#define	NT_STATUS_IO_TIMEOUT				181
#define	NT_STATUS_FILE_FORCED_CLOSED			182
#define	NT_STATUS_PROFILING_NOT_STARTED			183
#define	NT_STATUS_PROFILING_NOT_STOPPED			184
#define	NT_STATUS_COULD_NOT_INTERPRET			185
#define	NT_STATUS_FILE_IS_A_DIRECTORY			186
#define	NT_STATUS_NOT_SUPPORTED				187
#define	NT_STATUS_REMOTE_NOT_LISTENING			188
#define	NT_STATUS_DUPLICATE_NAME			189
#define	NT_STATUS_BAD_NETWORK_PATH			190
#define	NT_STATUS_NETWORK_BUSY				191
#define	NT_STATUS_DEVICE_DOES_NOT_EXIST			192
#define	NT_STATUS_TOO_MANY_COMMANDS			193
#define	NT_STATUS_ADAPTER_HARDWARE_ERROR		194
#define	NT_STATUS_INVALID_NETWORK_RESPONSE		195
#define	NT_STATUS_UNEXPECTED_NETWORK_ERROR		196
#define	NT_STATUS_BAD_REMOTE_ADAPTER			197
#define	NT_STATUS_PRINT_QUEUE_FULL			198
#define	NT_STATUS_NO_SPOOL_SPACE			199
#define	NT_STATUS_PRINT_CANCELLED			200
#define	NT_STATUS_NETWORK_NAME_DELETED			201
#define	NT_STATUS_NETWORK_ACCESS_DENIED			202
#define	NT_STATUS_BAD_DEVICE_TYPE			203
#define	NT_STATUS_BAD_NETWORK_NAME			204
#define	NT_STATUS_TOO_MANY_NAMES			205
#define	NT_STATUS_TOO_MANY_SESSIONS			206
#define	NT_STATUS_SHARING_PAUSED			207
#define	NT_STATUS_REQUEST_NOT_ACCEPTED			208
#define	NT_STATUS_REDIRECTOR_PAUSED			209
#define	NT_STATUS_NET_WRITE_FAULT			210
#define	NT_STATUS_PROFILING_AT_LIMIT			211
#define	NT_STATUS_NOT_SAME_DEVICE			212
#define	NT_STATUS_FILE_RENAMED				213
#define	NT_STATUS_VIRTUAL_CIRCUIT_CLOSED		214
#define	NT_STATUS_NO_SECURITY_ON_OBJECT			215
#define	NT_STATUS_CANT_WAIT				216
#define	NT_STATUS_PIPE_EMPTY				217
#define	NT_STATUS_CANT_ACCESS_DOMAIN_INFO		218
#define	NT_STATUS_CANT_TERMINATE_SELF			219
#define	NT_STATUS_INVALID_SERVER_STATE			220
#define	NT_STATUS_INVALID_DOMAIN_STATE			221
#define	NT_STATUS_INVALID_DOMAIN_ROLE			222
#define	NT_STATUS_NO_SUCH_DOMAIN			223
#define	NT_STATUS_DOMAIN_EXISTS				224
#define	NT_STATUS_DOMAIN_LIMIT_EXCEEDED			225
#define	NT_STATUS_OPLOCK_NOT_GRANTED			226
#define	NT_STATUS_INVALID_OPLOCK_PROTOCOL		227
#define	NT_STATUS_INTERNAL_DB_CORRUPTION		228
#define	NT_STATUS_INTERNAL_ERROR			229
#define	NT_STATUS_GENERIC_NOT_MAPPED			230
#define	NT_STATUS_BAD_DESCRIPTOR_FORMAT			231
#define	NT_STATUS_INVALID_USER_BUFFER			232
#define	NT_STATUS_UNEXPECTED_IO_ERROR			233
#define	NT_STATUS_UNEXPECTED_MM_CREATE_ERR		234
#define	NT_STATUS_UNEXPECTED_MM_MAP_ERROR		235
#define	NT_STATUS_UNEXPECTED_MM_EXTEND_ERR		236
#define	NT_STATUS_NOT_LOGON_PROCESS			237
#define	NT_STATUS_LOGON_SESSION_EXISTS			238
#define	NT_STATUS_INVALID_PARAMETER_1			239
#define	NT_STATUS_INVALID_PARAMETER_2			240
#define	NT_STATUS_INVALID_PARAMETER_3			241
#define	NT_STATUS_INVALID_PARAMETER_4			242
#define	NT_STATUS_INVALID_PARAMETER_5			243
#define	NT_STATUS_INVALID_PARAMETER_6			244
#define	NT_STATUS_INVALID_PARAMETER_7			245
#define	NT_STATUS_INVALID_PARAMETER_8			246
#define	NT_STATUS_INVALID_PARAMETER_9			247
#define	NT_STATUS_INVALID_PARAMETER_10			248
#define	NT_STATUS_INVALID_PARAMETER_11			249
#define	NT_STATUS_INVALID_PARAMETER_12			250
#define	NT_STATUS_REDIRECTOR_NOT_STARTED		251
#define	NT_STATUS_REDIRECTOR_STARTED			252
#define	NT_STATUS_STACK_OVERFLOW			253
#define	NT_STATUS_NO_SUCH_PACKAGE			254
#define	NT_STATUS_BAD_FUNCTION_TABLE			255
#define	NT_STATUS_DIRECTORY_NOT_EMPTY			257
#define	NT_STATUS_FILE_CORRUPT_ERROR			258
#define	NT_STATUS_NOT_A_DIRECTORY			259
#define	NT_STATUS_BAD_LOGON_SESSION_STATE		260
#define	NT_STATUS_LOGON_SESSION_COLLISION		261
#define	NT_STATUS_NAME_TOO_LONG				262
#define	NT_STATUS_FILES_OPEN				263
#define	NT_STATUS_SOME_NOT_MAPPED			NT_STATUS_FILES_OPEN
#define	NT_STATUS_CONNECTION_IN_USE			264
#define	NT_STATUS_MESSAGE_NOT_FOUND			265
#define	NT_STATUS_PROCESS_IS_TERMINATING		266
#define	NT_STATUS_INVALID_LOGON_TYPE			267
#define	NT_STATUS_NO_GUID_TRANSLATION			268
#define	NT_STATUS_CANNOT_IMPERSONATE			269
#define	NT_STATUS_IMAGE_ALREADY_LOADED			270
#define	NT_STATUS_ABIOS_NOT_PRESENT			271
#define	NT_STATUS_ABIOS_LID_NOT_EXIST			272
#define	NT_STATUS_ABIOS_LID_ALREADY_OWNED		273
#define	NT_STATUS_ABIOS_NOT_LID_OWNER			274
#define	NT_STATUS_ABIOS_INVALID_COMMAND			275
#define	NT_STATUS_ABIOS_INVALID_LID			276
#define	NT_STATUS_ABIOS_SELECTOR_NOT_AVAILABLE		277
#define	NT_STATUS_ABIOS_INVALID_SELECTOR		278
#define	NT_STATUS_NO_LDT				279
#define	NT_STATUS_INVALID_LDT_SIZE			280
#define	NT_STATUS_INVALID_LDT_OFFSET			281
#define	NT_STATUS_INVALID_LDT_DESCRIPTOR		282
#define	NT_STATUS_INVALID_IMAGE_NE_FORMAT		283
#define	NT_STATUS_RXACT_INVALID_STATE			284
#define	NT_STATUS_RXACT_COMMIT_FAILURE			285
#define	NT_STATUS_MAPPED_FILE_SIZE_ZERO			286
#define	NT_STATUS_TOO_MANY_OPENED_FILES			287
#define	NT_STATUS_CANCELLED				288
#define	NT_STATUS_CANNOT_DELETE				289
#define	NT_STATUS_INVALID_COMPUTER_NAME			290
#define	NT_STATUS_FILE_DELETED				291
#define	NT_STATUS_SPECIAL_ACCOUNT			292
#define	NT_STATUS_SPECIAL_GROUP				293
#define	NT_STATUS_SPECIAL_USER				294
#define	NT_STATUS_MEMBERS_PRIMARY_GROUP			295
#define	NT_STATUS_FILE_CLOSED				296
#define	NT_STATUS_TOO_MANY_THREADS			297
#define	NT_STATUS_THREAD_NOT_IN_PROCESS			298
#define	NT_STATUS_TOKEN_ALREADY_IN_USE			299
#define	NT_STATUS_PAGEFILE_QUOTA_EXCEEDED		300
#define	NT_STATUS_COMMITMENT_LIMIT			301
#define	NT_STATUS_INVALID_IMAGE_LE_FORMAT		302
#define	NT_STATUS_INVALID_IMAGE_NOT_MZ			303
#define	NT_STATUS_INVALID_IMAGE_PROTECT			304
#define	NT_STATUS_INVALID_IMAGE_WIN_16			305
#define	NT_STATUS_LOGON_SERVER_CONFLICT			306
#define	NT_STATUS_TIME_DIFFERENCE_AT_DC			307
#define	NT_STATUS_SYNCHRONIZATION_REQUIRED		308
#define	NT_STATUS_DLL_NOT_FOUND				309
#define	NT_STATUS_OPEN_FAILED				310
#define	NT_STATUS_IO_PRIVILEGE_FAILED			311
#define	NT_STATUS_ORDINAL_NOT_FOUND			312
#define	NT_STATUS_ENTRYPOINT_NOT_FOUND			313
#define	NT_STATUS_CONTROL_C_EXIT			314
#define	NT_STATUS_LOCAL_DISCONNECT			315
#define	NT_STATUS_REMOTE_DISCONNECT			316
#define	NT_STATUS_REMOTE_RESOURCES			317
#define	NT_STATUS_LINK_FAILED				318
#define	NT_STATUS_LINK_TIMEOUT				319
#define	NT_STATUS_INVALID_CONNECTION			320
#define	NT_STATUS_INVALID_ADDRESS			321
#define	NT_STATUS_DLL_INIT_FAILED			322
#define	NT_STATUS_MISSING_SYSTEMFILE			323
#define	NT_STATUS_UNHANDLED_EXCEPTION			324
#define	NT_STATUS_APP_INIT_FAILURE			325
#define	NT_STATUS_PAGEFILE_CREATE_FAILED		326
#define	NT_STATUS_NO_PAGEFILE				327
#define	NT_STATUS_INVALID_LEVEL				328
#define	NT_STATUS_WRONG_PASSWORD_CORE			329
#define	NT_STATUS_ILLEGAL_FLOAT_CONTEXT			330
#define	NT_STATUS_PIPE_BROKEN				331
#define	NT_STATUS_REGISTRY_CORRUPT			332
#define	NT_STATUS_REGISTRY_IO_FAILED			333
#define	NT_STATUS_NO_EVENT_PAIR				334
#define	NT_STATUS_UNRECOGNIZED_VOLUME			335
#define	NT_STATUS_SERIAL_NO_DEVICE_INITED		336
#define	NT_STATUS_NO_SUCH_ALIAS				337
#define	NT_STATUS_MEMBER_NOT_IN_ALIAS			338
#define	NT_STATUS_MEMBER_IN_ALIAS			339
#define	NT_STATUS_ALIAS_EXISTS				340
#define	NT_STATUS_LOGON_NOT_GRANTED			341
#define	NT_STATUS_TOO_MANY_SECRETS			342
#define	NT_STATUS_SECRET_TOO_LONG			343
#define	NT_STATUS_INTERNAL_DB_ERROR			344
#define	NT_STATUS_FULLSCREEN_MODE			345
#define	NT_STATUS_TOO_MANY_CONTEXT_IDS			346
#define	NT_STATUS_LOGON_TYPE_NOT_GRANTED		347
#define	NT_STATUS_NOT_REGISTRY_FILE			348
#define	NT_STATUS_NT_CROSS_ENCRYPTION_REQUIRED		349
#define	NT_STATUS_DOMAIN_CTRLR_CONFIG_ERROR		350
#define	NT_STATUS_FT_MISSING_MEMBER			351
#define	NT_STATUS_ILL_FORMED_SERVICE_ENTRY		352
#define	NT_STATUS_ILLEGAL_CHARACTER			353
#define	NT_STATUS_UNMAPPABLE_CHARACTER			354
#define	NT_STATUS_UNDEFINED_CHARACTER			355
#define	NT_STATUS_FLOPPY_VOLUME				356
#define	NT_STATUS_FLOPPY_ID_MARK_NOT_FOUND		357
#define	NT_STATUS_FLOPPY_WRONG_CYLINDER			358
#define	NT_STATUS_FLOPPY_UNKNOWN_ERROR			359
#define	NT_STATUS_FLOPPY_BAD_REGISTERS			360
#define	NT_STATUS_DISK_RECALIBRATE_FAILED		361
#define	NT_STATUS_DISK_OPERATION_FAILED			362
#define	NT_STATUS_DISK_RESET_FAILED			363
#define	NT_STATUS_SHARED_IRQ_BUSY			364
#define	NT_STATUS_FT_ORPHANING				365
#define	NT_STATUS_PARTITION_FAILURE			370
#define	NT_STATUS_INVALID_BLOCK_LENGTH			371
#define	NT_STATUS_DEVICE_NOT_PARTITIONED		372
#define	NT_STATUS_UNABLE_TO_LOCK_MEDIA			373
#define	NT_STATUS_UNABLE_TO_UNLOAD_MEDIA		374
#define	NT_STATUS_EOM_OVERFLOW				375
#define	NT_STATUS_NO_MEDIA				376
#define	NT_STATUS_NO_SUCH_MEMBER			378
#define	NT_STATUS_INVALID_MEMBER			379
#define	NT_STATUS_KEY_DELETED				380
#define	NT_STATUS_NO_LOG_SPACE				381
#define	NT_STATUS_TOO_MANY_SIDS				382
#define	NT_STATUS_LM_CROSS_ENCRYPTION_REQUIRED		383
#define	NT_STATUS_KEY_HAS_CHILDREN			384
#define	NT_STATUS_CHILD_MUST_BE_VOLATILE		385
#define	NT_STATUS_DEVICE_CONFIGURATION_ERROR		386
#define	NT_STATUS_DRIVER_INTERNAL_ERROR			387
#define	NT_STATUS_INVALID_DEVICE_STATE			388
#define	NT_STATUS_IO_DEVICE_ERROR			389
#define	NT_STATUS_DEVICE_PROTOCOL_ERROR			390
#define	NT_STATUS_BACKUP_CONTROLLER			391
#define	NT_STATUS_LOG_FILE_FULL				392
#define	NT_STATUS_TOO_LATE				393
#define	NT_STATUS_NO_TRUST_LSA_SECRET			394
#define	NT_STATUS_NO_TRUST_SAM_ACCOUNT			395
#define	NT_STATUS_TRUSTED_DOMAIN_FAILURE		396
#define	NT_STATUS_TRUSTED_RELATIONSHIP_FAILURE		397
#define	NT_STATUS_EVENTLOG_FILE_CORRUPT			398
#define	NT_STATUS_EVENTLOG_CANT_START			399
#define	NT_STATUS_TRUST_FAILURE				400
#define	NT_STATUS_MUTANT_LIMIT_EXCEEDED			401
#define	NT_STATUS_NETLOGON_NOT_STARTED			402
#define	NT_STATUS_ACCOUNT_EXPIRED			403
#define	NT_STATUS_POSSIBLE_DEADLOCK			404
#define	NT_STATUS_NETWORK_CREDENTIAL_CONFLICT		405
#define	NT_STATUS_REMOTE_SESSION_LIMIT			406
#define	NT_STATUS_EVENTLOG_FILE_CHANGED			407
#define	NT_STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT	408
#define	NT_STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT	409
#define	NT_STATUS_NOLOGON_SERVER_TRUST_ACCOUNT		410
#define	NT_STATUS_DOMAIN_TRUST_INCONSISTENT		411
#define	NT_STATUS_FS_DRIVER_REQUIRED			412
#define	NT_STATUS_NO_USER_SESSION_KEY			514
#define	NT_STATUS_USER_SESSION_DELETED			515
#define	NT_STATUS_RESOURCE_LANG_NOT_FOUND		516
#define	NT_STATUS_INSUFF_SERVER_RESOURCES		517
#define	NT_STATUS_INVALID_BUFFER_SIZE			518
#define	NT_STATUS_INVALID_ADDRESS_COMPONENT		519
#define	NT_STATUS_INVALID_ADDRESS_WILDCARD		520
#define	NT_STATUS_TOO_MANY_ADDRESSES			521
#define	NT_STATUS_ADDRESS_ALREADY_EXISTS		522
#define	NT_STATUS_ADDRESS_CLOSED			523
#define	NT_STATUS_CONNECTION_DISCONNECTED		524
#define	NT_STATUS_CONNECTION_RESET			525
#define	NT_STATUS_TOO_MANY_NODES			526
#define	NT_STATUS_TRANSACTION_ABORTED			527
#define	NT_STATUS_TRANSACTION_TIMED_OUT			528
#define	NT_STATUS_TRANSACTION_NO_RELEASE		529
#define	NT_STATUS_TRANSACTION_NO_MATCH			530
#define	NT_STATUS_TRANSACTION_RESPONDED			531
#define	NT_STATUS_TRANSACTION_INVALID_ID		532
#define	NT_STATUS_TRANSACTION_INVALID_TYPE		533
#define	NT_STATUS_NOT_SERVER_SESSION			534
#define	NT_STATUS_NOT_CLIENT_SESSION			535
#define	NT_STATUS_CANNOT_LOAD_REGISTRY_FILE		536
#define	NT_STATUS_DEBUG_ATTACH_FAILED			537
#define	NT_STATUS_SYSTEM_PROCESS_TERMINATED		538
#define	NT_STATUS_DATA_NOT_ACCEPTED			539
#define	NT_STATUS_NO_BROWSER_SERVERS_FOUND		540
#define	NT_STATUS_VDM_HARD_ERROR			541
#define	NT_STATUS_DRIVER_CANCEL_TIMEOUT			542
#define	NT_STATUS_REPLY_MESSAGE_MISMATCH		543
#define	NT_STATUS_MAPPED_ALIGNMENT			544
#define	NT_STATUS_IMAGE_CHECKSUM_MISMATCH		545
#define	NT_STATUS_LOST_WRITEBEHIND_DATA			546
#define	NT_STATUS_CLIENT_SERVER_PARAMETERS_INVALID	547
#define	NT_STATUS_PASSWORD_MUST_CHANGE			548
#define	NT_STATUS_NOT_FOUND				549
#define	NT_STATUS_NOT_TINY_STREAM			550
#define	NT_STATUS_RECOVERY_FAILURE			551
#define	NT_STATUS_STACK_OVERFLOW_READ			552
#define	NT_STATUS_FAIL_CHECK				553
#define	NT_STATUS_DUPLICATE_OBJECTID			554
#define	NT_STATUS_OBJECTID_EXISTS			555
#define	NT_STATUS_CONVERT_TO_LARGE			556
#define	NT_STATUS_RETRY					557
#define	NT_STATUS_FOUND_OUT_OF_SCOPE			558
#define	NT_STATUS_ALLOCATE_BUCKET			559
#define	NT_STATUS_PROPSET_NOT_FOUND			560
#define	NT_STATUS_MARSHALL_OVERFLOW			561
#define	NT_STATUS_INVALID_VARIANT			562
#define	NT_STATUS_DOMAIN_CONTROLLER_NOT_FOUND		563
#define	NT_STATUS_ACCOUNT_LOCKED_OUT			564
#define	NT_STATUS_HANDLE_NOT_CLOSABLE			565
#define	NT_STATUS_CONNECTION_REFUSED			566
#define	NT_STATUS_GRACEFUL_DISCONNECT			567
#define	NT_STATUS_ADDRESS_ALREADY_ASSOCIATED		568
#define	NT_STATUS_ADDRESS_NOT_ASSOCIATED		569
#define	NT_STATUS_CONNECTION_INVALID			570
#define	NT_STATUS_CONNECTION_ACTIVE			571
#define	NT_STATUS_NETWORK_UNREACHABLE			572
#define	NT_STATUS_HOST_UNREACHABLE			573
#define	NT_STATUS_PROTOCOL_UNREACHABLE			574
#define	NT_STATUS_PORT_UNREACHABLE			575
#define	NT_STATUS_REQUEST_ABORTED			576
#define	NT_STATUS_CONNECTION_ABORTED			577
#define	NT_STATUS_BAD_COMPRESSION_BUFFER		578
#define	NT_STATUS_USER_MAPPED_FILE			579
#define	NT_STATUS_AUDIT_FAILED				580
#define	NT_STATUS_TIMER_RESOLUTION_NOT_SET		581
#define	NT_STATUS_CONNECTION_COUNT_LIMIT		582
#define	NT_STATUS_LOGIN_TIME_RESTRICTION		583
#define	NT_STATUS_LOGIN_WKSTA_RESTRICTION		584
#define	NT_STATUS_IMAGE_MP_UP_MISMATCH			585
#define	NT_STATUS_INSUFFICIENT_LOGON_INFO		592
#define	NT_STATUS_BAD_DLL_ENTRYPOINT			593
#define	NT_STATUS_BAD_SERVICE_ENTRYPOINT		594
#define	NT_STATUS_LPC_REPLY_LOST			595
#define	NT_STATUS_IP_ADDRESS_CONFLICT1			596
#define	NT_STATUS_IP_ADDRESS_CONFLICT2			597
#define	NT_STATUS_REGISTRY_QUOTA_LIMIT			598
#define	NT_STATUS_PATH_NOT_COVERED			599
#define	NT_STATUS_NO_CALLBACK_ACTIVE			600
#define	NT_STATUS_LICENSE_QUOTA_EXCEEDED		601
#define	NT_STATUS_PWD_TOO_SHORT				602
#define	NT_STATUS_PWD_TOO_RECENT			603
#define	NT_STATUS_PWD_HISTORY_CONFLICT			604
#define	NT_STATUS_PLUGPLAY_NO_DEVICE			606
#define	NT_STATUS_UNSUPPORTED_COMPRESSION		607
#define	NT_STATUS_INVALID_HW_PROFILE			608
#define	NT_STATUS_INVALID_PLUGPLAY_DEVICE_PATH		609
#define	NT_STATUS_DRIVER_ORDINAL_NOT_FOUND		610
#define	NT_STATUS_DRIVER_ENTRYPOINT_NOT_FOUND		611
#define	NT_STATUS_RESOURCE_NOT_OWNED			612
#define	NT_STATUS_TOO_MANY_LINKS			613
#define	NT_STATUS_QUOTA_LIST_INCONSISTENT		614
#define	NT_STATUS_FILE_IS_OFFLINE			615

#define	RPC_NT_UUID_LOCAL_ONLY				0x40020056
#define	RPC_NT_SEND_INCOMPLETE				0x400200AF

#define	RPC_NT_INVALID_STRING_BINDING			0xC0020001
#define	RPC_NT_WRONG_KIND_OF_BINDING			0xC0020002
#define	RPC_NT_INVALID_BINDING				0xC0020003
#define	RPC_NT_PROTSEQ_NOT_SUPPORTED			0xC0020004
#define	RPC_NT_INVALID_RPC_PROTSEQ			0xC0020005
#define	RPC_NT_INVALID_STRING_UUID			0xC0020006
#define	RPC_NT_INVALID_ENDPOINT_FORMAT			0xC0020007
#define	RPC_NT_INVALID_NET_ADDR				0xC0020008
#define	RPC_NT_NO_ENDPOINT_FOUND			0xC0020009
#define	RPC_NT_INVALID_TIMEOUT				0xC002000A
#define	RPC_NT_OBJECT_NOT_FOUND				0xC002000B
#define	RPC_NT_ALREADY_REGISTERED			0xC002000C
#define	RPC_NT_TYPE_ALREADY_REGISTERED			0xC002000D
#define	RPC_NT_ALREADY_LISTENING			0xC002000E
#define	RPC_NT_NO_PROTSEQS_REGISTERED			0xC002000F
#define	RPC_NT_NOT_LISTENING				0xC0020010
#define	RPC_NT_UNKNOWN_MGR_TYPE				0xC0020011
#define	RPC_NT_UNKNOWN_IF				0xC0020012
#define	RPC_NT_NO_BINDINGS				0xC0020013
#define	RPC_NT_NO_PROTSEQS				0xC0020014
#define	RPC_NT_CANT_CREATE_ENDPOINT			0xC0020015
#define	RPC_NT_OUT_OF_RESOURCES				0xC0020016
#define	RPC_NT_SERVER_UNAVAILABLE			0xC0020017
#define	RPC_NT_SERVER_TOO_BUSY				0xC0020018
#define	RPC_NT_INVALID_NETWORK_OPTIONS			0xC0020019
#define	RPC_NT_NO_CALL_ACTIVE				0xC002001A
#define	RPC_NT_CALL_FAILED				0xC002001B
#define	RPC_NT_CALL_FAILED_DNE				0xC002001C
#define	RPC_NT_PROTOCOL_ERROR				0xC002001D
#define	RPC_NT_UNSUPPORTED_TRANS_SYN			0xC002001F
#define	RPC_NT_UNSUPPORTED_TYPE				0xC0020021
#define	RPC_NT_INVALID_TAG				0xC0020022
#define	RPC_NT_INVALID_BOUND				0xC0020023
#define	RPC_NT_NO_ENTRY_NAME				0xC0020024
#define	RPC_NT_INVALID_NAME_SYNTAX			0xC0020025
#define	RPC_NT_UNSUPPORTED_NAME_SYNTAX			0xC0020026
#define	RPC_NT_UUID_NO_ADDRESS				0xC0020028
#define	RPC_NT_DUPLICATE_ENDPOINT			0xC0020029
#define	RPC_NT_UNKNOWN_AUTHN_TYPE			0xC002002A
#define	RPC_NT_MAX_CALLS_TOO_SMALL			0xC002002B
#define	RPC_NT_STRING_TOO_LONG				0xC002002C
#define	RPC_NT_PROTSEQ_NOT_FOUND			0xC002002D
#define	RPC_NT_PROCNUM_OUT_OF_RANGE			0xC002002E
#define	RPC_NT_BINDING_HAS_NO_AUTH			0xC002002F
#define	RPC_NT_UNKNOWN_AUTHN_SERVICE			0xC0020030
#define	RPC_NT_UNKNOWN_AUTHN_LEVEL			0xC0020031
#define	RPC_NT_INVALID_AUTH_IDENTITY			0xC0020032
#define	RPC_NT_UNKNOWN_AUTHZ_SERVICE			0xC0020033
#define	EPT_NT_INVALID_ENTRY				0xC0020034
#define	EPT_NT_CANT_PERFORM_OP				0xC0020035
#define	EPT_NT_NOT_REGISTERED				0xC0020036
#define	RPC_NT_NOTHING_TO_EXPORT			0xC0020037
#define	RPC_NT_INCOMPLETE_NAME				0xC0020038
#define	RPC_NT_INVALID_VERS_OPTION			0xC0020039
#define	RPC_NT_NO_MORE_MEMBERS				0xC002003A
#define	RPC_NT_NOT_ALL_OBJS_UNEXPORTED			0xC002003B
#define	RPC_NT_INTERFACE_NOT_FOUND			0xC002003C
#define	RPC_NT_ENTRY_ALREADY_EXISTS			0xC002003D
#define	RPC_NT_ENTRY_NOT_FOUND				0xC002003E
#define	RPC_NT_NAME_SERVICE_UNAVAILABLE			0xC002003F
#define	RPC_NT_INVALID_NAF_ID				0xC0020040
#define	RPC_NT_CANNOT_SUPPORT				0xC0020041
#define	RPC_NT_NO_CONTEXT_AVAILABLE			0xC0020042
#define	RPC_NT_INTERNAL_ERROR				0xC0020043
#define	RPC_NT_ZERO_DIVIDE				0xC0020044
#define	RPC_NT_ADDRESS_ERROR				0xC0020045
#define	RPC_NT_FP_DIV_ZERO				0xC0020046
#define	RPC_NT_FP_UNDERFLOW				0xC0020047
#define	RPC_NT_FP_OVERFLOW				0xC0020048
#define	RPC_NT_CALL_IN_PROGRESS				0xC0020049
#define	RPC_NT_NO_MORE_BINDINGS				0xC002004A
#define	RPC_NT_GROUP_MEMBER_NOT_FOUND			0xC002004B
#define	EPT_NT_CANT_CREATE				0xC002004C
#define	RPC_NT_INVALID_OBJECT				0xC002004D
#define	RPC_NT_NO_INTERFACES				0xC002004F
#define	RPC_NT_CALL_CANCELLED				0xC0020050
#define	RPC_NT_BINDING_INCOMPLETE			0xC0020051
#define	RPC_NT_COMM_FAILURE				0xC0020052
#define	RPC_NT_UNSUPPORTED_AUTHN_LEVEL			0xC0020053
#define	RPC_NT_NO_PRINC_NAME				0xC0020054
#define	RPC_NT_NOT_RPC_ERROR				0xC0020055
#define	RPC_NT_SEC_PKG_ERROR				0xC0020057
#define	RPC_NT_NOT_CANCELLED				0xC0020058
#define	RPC_NT_INVALID_ASYNC_HANDLE			0xC0020062
#define	RPC_NT_INVALID_ASYNC_CALL			0xC0020063
#define	RPC_NT_PROXY_ACCESS_DENIED			0xC0020064

#define	RPC_NT_NO_MORE_ENTRIES				0xC0030001
#define	RPC_NT_SS_CHAR_TRANS_OPEN_FAIL			0xC0030002
#define	RPC_NT_SS_CHAR_TRANS_SHORT_FILE			0xC0030003
#define	RPC_NT_SS_IN_NULL_CONTEXT			0xC0030004
#define	RPC_NT_SS_CONTEXT_MISMATCH			0xC0030005
#define	RPC_NT_SS_CONTEXT_DAMAGED			0xC0030006
#define	RPC_NT_SS_HANDLES_MISMATCH			0xC0030007
#define	RPC_NT_SS_CANNOT_GET_CALL_HANDLE		0xC0030008
#define	RPC_NT_NULL_REF_POINTER				0xC0030009
#define	RPC_NT_ENUM_VALUE_OUT_OF_RANGE			0xC003000A
#define	RPC_NT_BYTE_COUNT_TOO_SMALL			0xC003000B
#define	RPC_NT_BAD_STUB_DATA				0xC003000C
#define	RPC_NT_INVALID_ES_ACTION			0xC0030059
#define	RPC_NT_WRONG_ES_VERSION				0xC003005A
#define	RPC_NT_WRONG_STUB_VERSION			0xC003005B
#define	RPC_NT_INVALID_PIPE_OBJECT			0xC003005C
#define	RPC_NT_INVALID_PIPE_OPERATION			0xC003005D
#define	RPC_NT_WRONG_PIPE_VERSION			0xC003005E
#define	RPC_NT_PIPE_CLOSED				0xC003005F
#define	RPC_NT_PIPE_DISCIPLINE_ERROR			0xC0030060
#define	RPC_NT_PIPE_EMPTY				0xC0030061

char *xlate_nt_status(DWORD ntstatus);


#ifdef __cplusplus
}
#endif


#endif /* _SMBSRV_NTSTATUS_H */
