/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2006 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation (the
 * "Data Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 *
 * Unicode and the Unicode logo are trademarks of Unicode, Inc., and may be
 * registered in some jurisdictions. All other trademarks and registered
 * trademarks mentioned herein are the property of their respective owners.
 */
/*
 * This file has been modified by Sun Microsystems, Inc.
 */

#ifndef _SYS_KICONV_EMEA1_H
#define	_SYS_KICONV_EMEA1_H

#pragma ident	"%Z%%M%	%I%	%E% SMI"

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/kiconv.h>

#ifdef	_KERNEL

/*
 * Mapping tables from CP737, CP852, CP857, CP862, CP866, CP1250, CP1251,
 * CP1253, CP1254, CP1255, CP1256, CP1257, ISO-8859-2, ISO-8859-3, ISO-8859-4,
 * ISO-8859-5, ISO-8859-6, ISO-8859-7, ISO-8859-8, ISO-8859-9, ISO-8859-10,
 * ISO-8859-11, ISO-8859-13, and KOI8-R to UTF-8.
 *
 * Indices are calculated by subtracting 0x80 from single byte character code
 * values.
 *
 * Each component has up to three UTF-8 character bytes; the first byte will
 * be used to figure out on how many bytes should be taken. If size figured
 * out has a value less than zero, that means that component isn't valid and
 * has no assigned character.
 */
static const kiconv_to_utf8_tbl_comp_t to_u8_tbl[24][128] = {
	{	/* CP737 -> UTF-8 */
		{ 0xCE, 0x91, 0x00 },	/* 0x80 */
		{ 0xCE, 0x92, 0x00 },	/* 0x81 */
		{ 0xCE, 0x93, 0x00 },	/* 0x82 */
		{ 0xCE, 0x94, 0x00 },	/* 0x83 */
		{ 0xCE, 0x95, 0x00 },	/* 0x84 */
		{ 0xCE, 0x96, 0x00 },	/* 0x85 */
		{ 0xCE, 0x97, 0x00 },	/* 0x86 */
		{ 0xCE, 0x98, 0x00 },	/* 0x87 */
		{ 0xCE, 0x99, 0x00 },	/* 0x88 */
		{ 0xCE, 0x9A, 0x00 },	/* 0x89 */
		{ 0xCE, 0x9B, 0x00 },	/* 0x8A */
		{ 0xCE, 0x9C, 0x00 },	/* 0x8B */
		{ 0xCE, 0x9D, 0x00 },	/* 0x8C */
		{ 0xCE, 0x9E, 0x00 },	/* 0x8D */
		{ 0xCE, 0x9F, 0x00 },	/* 0x8E */
		{ 0xCE, 0xA0, 0x00 },	/* 0x8F */
		{ 0xCE, 0xA1, 0x00 },	/* 0x90 */
		{ 0xCE, 0xA3, 0x00 },	/* 0x91 */
		{ 0xCE, 0xA4, 0x00 },	/* 0x92 */
		{ 0xCE, 0xA5, 0x00 },	/* 0x93 */
		{ 0xCE, 0xA6, 0x00 },	/* 0x94 */
		{ 0xCE, 0xA7, 0x00 },	/* 0x95 */
		{ 0xCE, 0xA8, 0x00 },	/* 0x96 */
		{ 0xCE, 0xA9, 0x00 },	/* 0x97 */
		{ 0xCE, 0xB1, 0x00 },	/* 0x98 */
		{ 0xCE, 0xB2, 0x00 },	/* 0x99 */
		{ 0xCE, 0xB3, 0x00 },	/* 0x9A */
		{ 0xCE, 0xB4, 0x00 },	/* 0x9B */
		{ 0xCE, 0xB5, 0x00 },	/* 0x9C */
		{ 0xCE, 0xB6, 0x00 },	/* 0x9D */
		{ 0xCE, 0xB7, 0x00 },	/* 0x9E */
		{ 0xCE, 0xB8, 0x00 },	/* 0x9F */
		{ 0xCE, 0xB9, 0x00 },	/* 0xA0 */
		{ 0xCE, 0xBA, 0x00 },	/* 0xA1 */
		{ 0xCE, 0xBB, 0x00 },	/* 0xA2 */
		{ 0xCE, 0xBC, 0x00 },	/* 0xA3 */
		{ 0xCE, 0xBD, 0x00 },	/* 0xA4 */
		{ 0xCE, 0xBE, 0x00 },	/* 0xA5 */
		{ 0xCE, 0xBF, 0x00 },	/* 0xA6 */
		{ 0xCF, 0x80, 0x00 },	/* 0xA7 */
		{ 0xCF, 0x81, 0x00 },	/* 0xA8 */
		{ 0xCF, 0x83, 0x00 },	/* 0xA9 */
		{ 0xCF, 0x82, 0x00 },	/* 0xAA */
		{ 0xCF, 0x84, 0x00 },	/* 0xAB */
		{ 0xCF, 0x85, 0x00 },	/* 0xAC */
		{ 0xCF, 0x86, 0x00 },	/* 0xAD */
		{ 0xCF, 0x87, 0x00 },	/* 0xAE */
		{ 0xCF, 0x88, 0x00 },	/* 0xAF */
		{ 0xE2, 0x96, 0x91 },	/* 0xB0 */
		{ 0xE2, 0x96, 0x92 },	/* 0xB1 */
		{ 0xE2, 0x96, 0x93 },	/* 0xB2 */
		{ 0xE2, 0x94, 0x82 },	/* 0xB3 */
		{ 0xE2, 0x94, 0xA4 },	/* 0xB4 */
		{ 0xE2, 0x95, 0xA1 },	/* 0xB5 */
		{ 0xE2, 0x95, 0xA2 },	/* 0xB6 */
		{ 0xE2, 0x95, 0x96 },	/* 0xB7 */
		{ 0xE2, 0x95, 0x95 },	/* 0xB8 */
		{ 0xE2, 0x95, 0xA3 },	/* 0xB9 */
		{ 0xE2, 0x95, 0x91 },	/* 0xBA */
		{ 0xE2, 0x95, 0x97 },	/* 0xBB */
		{ 0xE2, 0x95, 0x9D },	/* 0xBC */
		{ 0xE2, 0x95, 0x9C },	/* 0xBD */
		{ 0xE2, 0x95, 0x9B },	/* 0xBE */
		{ 0xE2, 0x94, 0x90 },	/* 0xBF */
		{ 0xE2, 0x94, 0x94 },	/* 0xC0 */
		{ 0xE2, 0x94, 0xB4 },	/* 0xC1 */
		{ 0xE2, 0x94, 0xAC },	/* 0xC2 */
		{ 0xE2, 0x94, 0x9C },	/* 0xC3 */
		{ 0xE2, 0x94, 0x80 },	/* 0xC4 */
		{ 0xE2, 0x94, 0xBC },	/* 0xC5 */
		{ 0xE2, 0x95, 0x9E },	/* 0xC6 */
		{ 0xE2, 0x95, 0x9F },	/* 0xC7 */
		{ 0xE2, 0x95, 0x9A },	/* 0xC8 */
		{ 0xE2, 0x95, 0x94 },	/* 0xC9 */
		{ 0xE2, 0x95, 0xA9 },	/* 0xCA */
		{ 0xE2, 0x95, 0xA6 },	/* 0xCB */
		{ 0xE2, 0x95, 0xA0 },	/* 0xCC */
		{ 0xE2, 0x95, 0x90 },	/* 0xCD */
		{ 0xE2, 0x95, 0xAC },	/* 0xCE */
		{ 0xE2, 0x95, 0xA7 },	/* 0xCF */
		{ 0xE2, 0x95, 0xA8 },	/* 0xD0 */
		{ 0xE2, 0x95, 0xA4 },	/* 0xD1 */
		{ 0xE2, 0x95, 0xA5 },	/* 0xD2 */
		{ 0xE2, 0x95, 0x99 },	/* 0xD3 */
		{ 0xE2, 0x95, 0x98 },	/* 0xD4 */
		{ 0xE2, 0x95, 0x92 },	/* 0xD5 */
		{ 0xE2, 0x95, 0x93 },	/* 0xD6 */
		{ 0xE2, 0x95, 0xAB },	/* 0xD7 */
		{ 0xE2, 0x95, 0xAA },	/* 0xD8 */
		{ 0xE2, 0x94, 0x98 },	/* 0xD9 */
		{ 0xE2, 0x94, 0x8C },	/* 0xDA */
		{ 0xE2, 0x96, 0x88 },	/* 0xDB */
		{ 0xE2, 0x96, 0x84 },	/* 0xDC */
		{ 0xE2, 0x96, 0x8C },	/* 0xDD */
		{ 0xE2, 0x96, 0x90 },	/* 0xDE */
		{ 0xE2, 0x96, 0x80 },	/* 0xDF */
		{ 0xCF, 0x89, 0x00 },	/* 0xE0 */
		{ 0xCE, 0xAC, 0x00 },	/* 0xE1 */
		{ 0xCE, 0xAD, 0x00 },	/* 0xE2 */
		{ 0xCE, 0xAE, 0x00 },	/* 0xE3 */
		{ 0xCF, 0x8A, 0x00 },	/* 0xE4 */
		{ 0xCE, 0xAF, 0x00 },	/* 0xE5 */
		{ 0xCF, 0x8C, 0x00 },	/* 0xE6 */
		{ 0xCF, 0x8D, 0x00 },	/* 0xE7 */
		{ 0xCF, 0x8B, 0x00 },	/* 0xE8 */
		{ 0xCF, 0x8E, 0x00 },	/* 0xE9 */
		{ 0xCE, 0x86, 0x00 },	/* 0xEA */
		{ 0xCE, 0x88, 0x00 },	/* 0xEB */
		{ 0xCE, 0x89, 0x00 },	/* 0xEC */
		{ 0xCE, 0x8A, 0x00 },	/* 0xED */
		{ 0xCE, 0x8C, 0x00 },	/* 0xEE */
		{ 0xCE, 0x8E, 0x00 },	/* 0xEF */
		{ 0xCE, 0x8F, 0x00 },	/* 0xF0 */
		{ 0xC2, 0xB1, 0x00 },	/* 0xF1 */
		{ 0xE2, 0x89, 0xA5 },	/* 0xF2 */
		{ 0xE2, 0x89, 0xA4 },	/* 0xF3 */
		{ 0xCE, 0xAA, 0x00 },	/* 0xF4 */
		{ 0xCE, 0xAB, 0x00 },	/* 0xF5 */
		{ 0xC3, 0xB7, 0x00 },	/* 0xF6 */
		{ 0xE2, 0x89, 0x88 },	/* 0xF7 */
		{ 0xC2, 0xB0, 0x00 },	/* 0xF8 */
		{ 0xE2, 0x88, 0x99 },	/* 0xF9 */
		{ 0xC2, 0xB7, 0x00 },	/* 0xFA */
		{ 0xE2, 0x88, 0x9A },	/* 0xFB */
		{ 0xE2, 0x81, 0xBF },	/* 0xFC */
		{ 0xC2, 0xB2, 0x00 },	/* 0xFD */
		{ 0xE2, 0x96, 0xA0 },	/* 0xFE */
		{ 0xC2, 0xA0, 0x00 },	/* 0xFF */
	},
	{	/* CP852 -> UTF-8 */
		{ 0xC3, 0x87, 0x00 },	/* 0x80 */
		{ 0xC3, 0xBC, 0x00 },	/* 0x81 */
		{ 0xC3, 0xA9, 0x00 },	/* 0x82 */
		{ 0xC3, 0xA2, 0x00 },	/* 0x83 */
		{ 0xC3, 0xA4, 0x00 },	/* 0x84 */
		{ 0xC5, 0xAF, 0x00 },	/* 0x85 */
		{ 0xC4, 0x87, 0x00 },	/* 0x86 */
		{ 0xC3, 0xA7, 0x00 },	/* 0x87 */
		{ 0xC5, 0x82, 0x00 },	/* 0x88 */
		{ 0xC3, 0xAB, 0x00 },	/* 0x89 */
		{ 0xC5, 0x90, 0x00 },	/* 0x8A */
		{ 0xC5, 0x91, 0x00 },	/* 0x8B */
		{ 0xC3, 0xAE, 0x00 },	/* 0x8C */
		{ 0xC5, 0xB9, 0x00 },	/* 0x8D */
		{ 0xC3, 0x84, 0x00 },	/* 0x8E */
		{ 0xC4, 0x86, 0x00 },	/* 0x8F */
		{ 0xC3, 0x89, 0x00 },	/* 0x90 */
		{ 0xC4, 0xB9, 0x00 },	/* 0x91 */
		{ 0xC4, 0xBA, 0x00 },	/* 0x92 */
		{ 0xC3, 0xB4, 0x00 },	/* 0x93 */
		{ 0xC3, 0xB6, 0x00 },	/* 0x94 */
		{ 0xC4, 0xBD, 0x00 },	/* 0x95 */
		{ 0xC4, 0xBE, 0x00 },	/* 0x96 */
		{ 0xC5, 0x9A, 0x00 },	/* 0x97 */
		{ 0xC5, 0x9B, 0x00 },	/* 0x98 */
		{ 0xC3, 0x96, 0x00 },	/* 0x99 */
		{ 0xC3, 0x9C, 0x00 },	/* 0x9A */
		{ 0xC5, 0xA4, 0x00 },	/* 0x9B */
		{ 0xC5, 0xA5, 0x00 },	/* 0x9C */
		{ 0xC5, 0x81, 0x00 },	/* 0x9D */
		{ 0xC3, 0x97, 0x00 },	/* 0x9E */
		{ 0xC4, 0x8D, 0x00 },	/* 0x9F */
		{ 0xC3, 0xA1, 0x00 },	/* 0xA0 */
		{ 0xC3, 0xAD, 0x00 },	/* 0xA1 */
		{ 0xC3, 0xB3, 0x00 },	/* 0xA2 */
		{ 0xC3, 0xBA, 0x00 },	/* 0xA3 */
		{ 0xC4, 0x84, 0x00 },	/* 0xA4 */
		{ 0xC4, 0x85, 0x00 },	/* 0xA5 */
		{ 0xC5, 0xBD, 0x00 },	/* 0xA6 */
		{ 0xC5, 0xBE, 0x00 },	/* 0xA7 */
		{ 0xC4, 0x98, 0x00 },	/* 0xA8 */
		{ 0xC4, 0x99, 0x00 },	/* 0xA9 */
		{ 0xC2, 0xAC, 0x00 },	/* 0xAA */
		{ 0xC5, 0xBA, 0x00 },	/* 0xAB */
		{ 0xC4, 0x8C, 0x00 },	/* 0xAC */
		{ 0xC5, 0x9F, 0x00 },	/* 0xAD */
		{ 0xC2, 0xAB, 0x00 },	/* 0xAE */
		{ 0xC2, 0xBB, 0x00 },	/* 0xAF */
		{ 0xE2, 0x96, 0x91 },	/* 0xB0 */
		{ 0xE2, 0x96, 0x92 },	/* 0xB1 */
		{ 0xE2, 0x96, 0x93 },	/* 0xB2 */
		{ 0xE2, 0x94, 0x82 },	/* 0xB3 */
		{ 0xE2, 0x94, 0xA4 },	/* 0xB4 */
		{ 0xC3, 0x81, 0x00 },	/* 0xB5 */
		{ 0xC3, 0x82, 0x00 },	/* 0xB6 */
		{ 0xC4, 0x9A, 0x00 },	/* 0xB7 */
		{ 0xC5, 0x9E, 0x00 },	/* 0xB8 */
		{ 0xE2, 0x95, 0xA3 },	/* 0xB9 */
		{ 0xE2, 0x95, 0x91 },	/* 0xBA */
		{ 0xE2, 0x95, 0x97 },	/* 0xBB */
		{ 0xE2, 0x95, 0x9D },	/* 0xBC */
		{ 0xC5, 0xBB, 0x00 },	/* 0xBD */
		{ 0xC5, 0xBC, 0x00 },	/* 0xBE */
		{ 0xE2, 0x94, 0x90 },	/* 0xBF */
		{ 0xE2, 0x94, 0x94 },	/* 0xC0 */
		{ 0xE2, 0x94, 0xB4 },	/* 0xC1 */
		{ 0xE2, 0x94, 0xAC },	/* 0xC2 */
		{ 0xE2, 0x94, 0x9C },	/* 0xC3 */
		{ 0xE2, 0x94, 0x80 },	/* 0xC4 */
		{ 0xE2, 0x94, 0xBC },	/* 0xC5 */
		{ 0xC4, 0x82, 0x00 },	/* 0xC6 */
		{ 0xC4, 0x83, 0x00 },	/* 0xC7 */
		{ 0xE2, 0x95, 0x9A },	/* 0xC8 */
		{ 0xE2, 0x95, 0x94 },	/* 0xC9 */
		{ 0xE2, 0x95, 0xA9 },	/* 0xCA */
		{ 0xE2, 0x95, 0xA6 },	/* 0xCB */
		{ 0xE2, 0x95, 0xA0 },	/* 0xCC */
		{ 0xE2, 0x95, 0x90 },	/* 0xCD */
		{ 0xE2, 0x95, 0xAC },	/* 0xCE */
		{ 0xC2, 0xA4, 0x00 },	/* 0xCF */
		{ 0xC4, 0x91, 0x00 },	/* 0xD0 */
		{ 0xC4, 0x90, 0x00 },	/* 0xD1 */
		{ 0xC4, 0x8E, 0x00 },	/* 0xD2 */
		{ 0xC3, 0x8B, 0x00 },	/* 0xD3 */
		{ 0xC4, 0x8F, 0x00 },	/* 0xD4 */
		{ 0xC5, 0x87, 0x00 },	/* 0xD5 */
		{ 0xC3, 0x8D, 0x00 },	/* 0xD6 */
		{ 0xC3, 0x8E, 0x00 },	/* 0xD7 */
		{ 0xC4, 0x9B, 0x00 },	/* 0xD8 */
		{ 0xE2, 0x94, 0x98 },	/* 0xD9 */
		{ 0xE2, 0x94, 0x8C },	/* 0xDA */
		{ 0xE2, 0x96, 0x88 },	/* 0xDB */
		{ 0xE2, 0x96, 0x84 },	/* 0xDC */
		{ 0xC5, 0xA2, 0x00 },	/* 0xDD */
		{ 0xC5, 0xAE, 0x00 },	/* 0xDE */
		{ 0xE2, 0x96, 0x80 },	/* 0xDF */
		{ 0xC3, 0x93, 0x00 },	/* 0xE0 */
		{ 0xC3, 0x9F, 0x00 },	/* 0xE1 */
		{ 0xC3, 0x94, 0x00 },	/* 0xE2 */
		{ 0xC5, 0x83, 0x00 },	/* 0xE3 */
		{ 0xC5, 0x84, 0x00 },	/* 0xE4 */
		{ 0xC5, 0x88, 0x00 },	/* 0xE5 */
		{ 0xC5, 0xA0, 0x00 },	/* 0xE6 */
		{ 0xC5, 0xA1, 0x00 },	/* 0xE7 */
		{ 0xC5, 0x94, 0x00 },	/* 0xE8 */
		{ 0xC3, 0x9A, 0x00 },	/* 0xE9 */
		{ 0xC5, 0x95, 0x00 },	/* 0xEA */
		{ 0xC5, 0xB0, 0x00 },	/* 0xEB */
		{ 0xC3, 0xBD, 0x00 },	/* 0xEC */
		{ 0xC3, 0x9D, 0x00 },	/* 0xED */
		{ 0xC5, 0xA3, 0x00 },	/* 0xEE */
		{ 0xC2, 0xB4, 0x00 },	/* 0xEF */
		{ 0xC2, 0xAD, 0x00 },	/* 0xF0 */
		{ 0xCB, 0x9D, 0x00 },	/* 0xF1 */
		{ 0xCB, 0x9B, 0x00 },	/* 0xF2 */
		{ 0xCB, 0x87, 0x00 },	/* 0xF3 */
		{ 0xCB, 0x98, 0x00 },	/* 0xF4 */
		{ 0xC2, 0xA7, 0x00 },	/* 0xF5 */
		{ 0xC3, 0xB7, 0x00 },	/* 0xF6 */
		{ 0xC2, 0xB8, 0x00 },	/* 0xF7 */
		{ 0xC2, 0xB0, 0x00 },	/* 0xF8 */
		{ 0xC2, 0xA8, 0x00 },	/* 0xF9 */
		{ 0xCB, 0x99, 0x00 },	/* 0xFA */
		{ 0xC5, 0xB1, 0x00 },	/* 0xFB */
		{ 0xC5, 0x98, 0x00 },	/* 0xFC */
		{ 0xC5, 0x99, 0x00 },	/* 0xFD */
		{ 0xE2, 0x96, 0xA0 },	/* 0xFE */
		{ 0xC2, 0xA0, 0x00 },	/* 0xFF */
	},
	{	/* CP857 -> UTF-8 */
		{ 0xC3, 0x87, 0x00 },	/* 0x80 */
		{ 0xC3, 0xBC, 0x00 },	/* 0x81 */
		{ 0xC3, 0xA9, 0x00 },	/* 0x82 */
		{ 0xC3, 0xA2, 0x00 },	/* 0x83 */
		{ 0xC3, 0xA4, 0x00 },	/* 0x84 */
		{ 0xC3, 0xA0, 0x00 },	/* 0x85 */
		{ 0xC3, 0xA5, 0x00 },	/* 0x86 */
		{ 0xC3, 0xA7, 0x00 },	/* 0x87 */
		{ 0xC3, 0xAA, 0x00 },	/* 0x88 */
		{ 0xC3, 0xAB, 0x00 },	/* 0x89 */
		{ 0xC3, 0xA8, 0x00 },	/* 0x8A */
		{ 0xC3, 0xAF, 0x00 },	/* 0x8B */
		{ 0xC3, 0xAE, 0x00 },	/* 0x8C */
		{ 0xC4, 0xB1, 0x00 },	/* 0x8D */
		{ 0xC3, 0x84, 0x00 },	/* 0x8E */
		{ 0xC3, 0x85, 0x00 },	/* 0x8F */
		{ 0xC3, 0x89, 0x00 },	/* 0x90 */
		{ 0xC3, 0xA6, 0x00 },	/* 0x91 */
		{ 0xC3, 0x86, 0x00 },	/* 0x92 */
		{ 0xC3, 0xB4, 0x00 },	/* 0x93 */
		{ 0xC3, 0xB6, 0x00 },	/* 0x94 */
		{ 0xC3, 0xB2, 0x00 },	/* 0x95 */
		{ 0xC3, 0xBB, 0x00 },	/* 0x96 */
		{ 0xC3, 0xB9, 0x00 },	/* 0x97 */
		{ 0xC4, 0xB0, 0x00 },	/* 0x98 */
		{ 0xC3, 0x96, 0x00 },	/* 0x99 */
		{ 0xC3, 0x9C, 0x00 },	/* 0x9A */
		{ 0xC3, 0xB8, 0x00 },	/* 0x9B */
		{ 0xC2, 0xA3, 0x00 },	/* 0x9C */
		{ 0xC3, 0x98, 0x00 },	/* 0x9D */
		{ 0xC5, 0x9E, 0x00 },	/* 0x9E */
		{ 0xC5, 0x9F, 0x00 },	/* 0x9F */
		{ 0xC3, 0xA1, 0x00 },	/* 0xA0 */
		{ 0xC3, 0xAD, 0x00 },	/* 0xA1 */
		{ 0xC3, 0xB3, 0x00 },	/* 0xA2 */
		{ 0xC3, 0xBA, 0x00 },	/* 0xA3 */
		{ 0xC3, 0xB1, 0x00 },	/* 0xA4 */
		{ 0xC3, 0x91, 0x00 },	/* 0xA5 */
		{ 0xC4, 0x9E, 0x00 },	/* 0xA6 */
		{ 0xC4, 0x9F, 0x00 },	/* 0xA7 */
		{ 0xC2, 0xBF, 0x00 },	/* 0xA8 */
		{ 0xC2, 0xAE, 0x00 },	/* 0xA9 */
		{ 0xC2, 0xAC, 0x00 },	/* 0xAA */
		{ 0xC2, 0xBD, 0x00 },	/* 0xAB */
		{ 0xC2, 0xBC, 0x00 },	/* 0xAC */
		{ 0xC2, 0xA1, 0x00 },	/* 0xAD */
		{ 0xC2, 0xAB, 0x00 },	/* 0xAE */
		{ 0xC2, 0xBB, 0x00 },	/* 0xAF */
		{ 0xE2, 0x96, 0x91 },	/* 0xB0 */
		{ 0xE2, 0x96, 0x92 },	/* 0xB1 */
		{ 0xE2, 0x96, 0x93 },	/* 0xB2 */
		{ 0xE2, 0x94, 0x82 },	/* 0xB3 */
		{ 0xE2, 0x94, 0xA4 },	/* 0xB4 */
		{ 0xC3, 0x81, 0x00 },	/* 0xB5 */
		{ 0xC3, 0x82, 0x00 },	/* 0xB6 */
		{ 0xC3, 0x80, 0x00 },	/* 0xB7 */
		{ 0xC2, 0xA9, 0x00 },	/* 0xB8 */
		{ 0xE2, 0x95, 0xA3 },	/* 0xB9 */
		{ 0xE2, 0x95, 0x91 },	/* 0xBA */
		{ 0xE2, 0x95, 0x97 },	/* 0xBB */
		{ 0xE2, 0x95, 0x9D },	/* 0xBC */
		{ 0xC2, 0xA2, 0x00 },	/* 0xBD */
		{ 0xC2, 0xA5, 0x00 },	/* 0xBE */
		{ 0xE2, 0x94, 0x90 },	/* 0xBF */
		{ 0xE2, 0x94, 0x94 },	/* 0xC0 */
		{ 0xE2, 0x94, 0xB4 },	/* 0xC1 */
		{ 0xE2, 0x94, 0xAC },	/* 0xC2 */
		{ 0xE2, 0x94, 0x9C },	/* 0xC3 */
		{ 0xE2, 0x94, 0x80 },	/* 0xC4 */
		{ 0xE2, 0x94, 0xBC },	/* 0xC5 */
		{ 0xC3, 0xA3, 0x00 },	/* 0xC6 */
		{ 0xC3, 0x83, 0x00 },	/* 0xC7 */
		{ 0xE2, 0x95, 0x9A },	/* 0xC8 */
		{ 0xE2, 0x95, 0x94 },	/* 0xC9 */
		{ 0xE2, 0x95, 0xA9 },	/* 0xCA */
		{ 0xE2, 0x95, 0xA6 },	/* 0xCB */
		{ 0xE2, 0x95, 0xA0 },	/* 0xCC */
		{ 0xE2, 0x95, 0x90 },	/* 0xCD */
		{ 0xE2, 0x95, 0xAC },	/* 0xCE */
		{ 0xC2, 0xA4, 0x00 },	/* 0xCF */
		{ 0xC2, 0xBA, 0x00 },	/* 0xD0 */
		{ 0xC2, 0xAA, 0x00 },	/* 0xD1 */
		{ 0xC3, 0x8A, 0x00 },	/* 0xD2 */
		{ 0xC3, 0x8B, 0x00 },	/* 0xD3 */
		{ 0xC3, 0x88, 0x00 },	/* 0xD4 */
		{ 0xFE, 0xFE, 0xFE },	/* 0xD5 (illegal character) */
		{ 0xC3, 0x8D, 0x00 },	/* 0xD6 */
		{ 0xC3, 0x8E, 0x00 },	/* 0xD7 */
		{ 0xC3, 0x8F, 0x00 },	/* 0xD8 */
		{ 0xE2, 0x94, 0x98 },	/* 0xD9 */
		{ 0xE2, 0x94, 0x8C },	/* 0xDA */
		{ 0xE2, 0x96, 0x88 },	/* 0xDB */
		{ 0xE2, 0x96, 0x84 },	/* 0xDC */
		{ 0xC2, 0xA6, 0x00 },	/* 0xDD */
		{ 0xC3, 0x8C, 0x00 },	/* 0xDE */
		{ 0xE2, 0x96, 0x80 },	/* 0xDF */
		{ 0xC3, 0x93, 0x00 },	/* 0xE0 */
		{ 0xC3, 0x9F, 0x00 },	/* 0xE1 */
		{ 0xC3, 0x94, 0x00 },	/* 0xE2 */
		{ 0xC3, 0x92, 0x00 },	/* 0xE3 */
		{ 0xC3, 0xB5, 0x00 },	/* 0xE4 */
		{ 0xC3, 0x95, 0x00 },	/* 0xE5 */
		{ 0xC2, 0xB5, 0x00 },	/* 0xE6 */
		{ 0xFE, 0xFE, 0xFE },	/* 0xE7 (illegal character) */
		{ 0xC3, 0x97, 0x00 },	/* 0xE8 */
		{ 0xC3, 0x9A, 0x00 },	/* 0xE9 */
		{ 0xC3, 0x9B, 0x00 },	/* 0xEA */
		{ 0xC3, 0x99, 0x00 },	/* 0xEB */
		{ 0xC3, 0xAC, 0x00 },	/* 0xEC */
		{ 0xC3, 0xBF, 0x00 },	/* 0xED */
		{ 0xC2, 0xAF, 0x00 },	/* 0xEE */
		{ 0xC2, 0xB4, 0x00 },	/* 0xEF */
		{ 0xC2, 0xAD, 0x00 },	/* 0xF0 */
		{ 0xC2, 0xB1, 0x00 },	/* 0xF1 */
		{ 0xFE, 0xFE, 0xFE },	/* 0xF2 (illegal character) */
		{ 0xC2, 0xBE, 0x00 },	/* 0xF3 */
		{ 0xC2, 0xB6, 0x00 },	/* 0xF4 */
		{ 0xC2, 0xA7, 0x00 },	/* 0xF5 */
		{ 0xC3, 0xB7, 0x00 },	/* 0xF6 */
		{ 0xC2, 0xB8, 0x00 },	/* 0xF7 */
		{ 0xC2, 0xB0, 0x00 },	/* 0xF8 */
		{ 0xC2, 0xA8, 0x00 },	/* 0xF9 */
		{ 0xC2, 0xB7, 0x00 },	/* 0xFA */
		{ 0xC2, 0xB9, 0x00 },	/* 0xFB */
		{ 0xC2, 0xB3, 0x00 },	/* 0xFC */
		{ 0xC2, 0xB2, 0x00 },	/* 0xFD */
		{ 0xE2, 0x96, 0xA0 },	/* 0xFE */
		{ 0xC2, 0xA0, 0x00 },	/* 0xFF */
	},
	{	/* CP862 -> UTF-8 */
		{ 0xD7, 0x90, 0x00 },	/* 0x80 */
		{ 0xD7, 0x91, 0x00 },	/* 0x81 */
		{ 0xD7, 0x92, 0x00 },	/* 0x82 */
		{ 0xD7, 0x93, 0x00 },	/* 0x83 */
		{ 0xD7, 0x94, 0x00 },	/* 0x84 */
		{ 0xD7, 0x95, 0x00 },	/* 0x85 */
		{ 0xD7, 0x96, 0x00 },	/* 0x86 */
		{ 0xD7, 0x97, 0x00 },	/* 0x87 */
		{ 0xD7, 0x98, 0x00 },	/* 0x88 */
		{ 0xD7, 0x99, 0x00 },	/* 0x89 */
		{ 0xD7, 0x9A, 0x00 },	/* 0x8A */
		{ 0xD7, 0x9B, 0x00 },	/* 0x8B */
		{ 0xD7, 0x9C, 0x00 },	/* 0x8C */
		{ 0xD7, 0x9D, 0x00 },	/* 0x8D */
		{ 0xD7, 0x9E, 0x00 },	/* 0x8E */
		{ 0xD7, 0x9F, 0x00 },	/* 0x8F */
		{ 0xD7, 0xA0, 0x00 },	/* 0x90 */
		{ 0xD7, 0xA1, 0x00 },	/* 0x91 */
		{ 0xD7, 0xA2, 0x00 },	/* 0x92 */
		{ 0xD7, 0xA3, 0x00 },	/* 0x93 */
		{ 0xD7, 0xA4, 0x00 },	/* 0x94 */
		{ 0xD7, 0xA5, 0x00 },	/* 0x95 */
		{ 0xD7, 0xA6, 0x00 },	/* 0x96 */
		{ 0xD7, 0xA7, 0x00 },	/* 0x97 */
		{ 0xD7, 0xA8, 0x00 },	/* 0x98 */
		{ 0xD7, 0xA9, 0x00 },	/* 0x99 */
		{ 0xD7, 0xAA, 0x00 },	/* 0x9A */
		{ 0xC2, 0xA2, 0x00 },	/* 0x9B */
		{ 0xC2, 0xA3, 0x00 },	/* 0x9C */
		{ 0xC2, 0xA5, 0x00 },	/* 0x9D */
		{ 0xE2, 0x82, 0xA7 },	/* 0x9E */
		{ 0xC6, 0x92, 0x00 },	/* 0x9F */
		{ 0xC3, 0xA1, 0x00 },	/* 0xA0 */
		{ 0xC3, 0xAD, 0x00 },	/* 0xA1 */
		{ 0xC3, 0xB3, 0x00 },	/* 0xA2 */
		{ 0xC3, 0xBA, 0x00 },	/* 0xA3 */
		{ 0xC3, 0xB1, 0x00 },	/* 0xA4 */
		{ 0xC3, 0x91, 0x00 },	/* 0xA5 */
		{ 0xC2, 0xAA, 0x00 },	/* 0xA6 */
		{ 0xC2, 0xBA, 0x00 },	/* 0xA7 */
		{ 0xC2, 0xBF, 0x00 },	/* 0xA8 */
		{ 0xE2, 0x8C, 0x90 },	/* 0xA9 */
		{ 0xC2, 0xAC, 0x00 },	/* 0xAA */
		{ 0xC2, 0xBD, 0x00 },	/* 0xAB */
		{ 0xC2, 0xBC, 0x00 },	/* 0xAC */
		{ 0xC2, 0xA1, 0x00 },	/* 0xAD */
		{ 0xC2, 0xAB, 0x00 },	/* 0xAE */
		{ 0xC2, 0xBB, 0x00 },	/* 0xAF */
		{ 0xE2, 0x96, 0x91 },	/* 0xB0 */
		{ 0xE2, 0x96, 0x92 },	/* 0xB1 */
		{ 0xE2, 0x96, 0x93 },	/* 0xB2 */
		{ 0xE2, 0x94, 0x82 },	/* 0xB3 */
		{ 0xE2, 0x94, 0xA4 },	/* 0xB4 */
		{ 0xE2, 0x95, 0xA1 },	/* 0xB5 */
		{ 0xE2, 0x95, 0xA2 },	/* 0xB6 */
		{ 0xE2, 0x95, 0x96 },	/* 0xB7 */
		{ 0xE2, 0x95, 0x95 },	/* 0xB8 */
		{ 0xE2, 0x95, 0xA3 },	/* 0xB9 */
		{ 0xE2, 0x95, 0x91 },	/* 0xBA */
		{ 0xE2, 0x95, 0x97 },	/* 0xBB */
		{ 0xE2, 0x95, 0x9D },	/* 0xBC */
		{ 0xE2, 0x95, 0x9C },	/* 0xBD */
		{ 0xE2, 0x95, 0x9B },	/* 0xBE */
		{ 0xE2, 0x94, 0x90 },	/* 0xBF */
		{ 0xE2, 0x94, 0x94 },	/* 0xC0 */
		{ 0xE2, 0x94, 0xB4 },	/* 0xC1 */
		{ 0xE2, 0x94, 0xAC },	/* 0xC2 */
		{ 0xE2, 0x94, 0x9C },	/* 0xC3 */
		{ 0xE2, 0x94, 0x80 },	/* 0xC4 */
		{ 0xE2, 0x94, 0xBC },	/* 0xC5 */
		{ 0xE2, 0x95, 0x9E },	/* 0xC6 */
		{ 0xE2, 0x95, 0x9F },	/* 0xC7 */
		{ 0xE2, 0x95, 0x9A },	/* 0xC8 */
		{ 0xE2, 0x95, 0x94 },	/* 0xC9 */
		{ 0xE2, 0x95, 0xA9 },	/* 0xCA */
		{ 0xE2, 0x95, 0xA6 },	/* 0xCB */
		{ 0xE2, 0x95, 0xA0 },	/* 0xCC */
		{ 0xE2, 0x95, 0x90 },	/* 0xCD */
		{ 0xE2, 0x95, 0xAC },	/* 0xCE */
		{ 0xE2, 0x95, 0xA7 },	/* 0xCF */
		{ 0xE2, 0x95, 0xA8 },	/* 0xD0 */
		{ 0xE2, 0x95, 0xA4 },	/* 0xD1 */
		{ 0xE2, 0x95, 0xA5 },	/* 0xD2 */
		{ 0xE2, 0x95, 0x99 },	/* 0xD3 */
		{ 0xE2, 0x95, 0x98 },	/* 0xD4 */
		{ 0xE2, 0x95, 0x92 },	/* 0xD5 */
		{ 0xE2, 0x95, 0x93 },	/* 0xD6 */
		{ 0xE2, 0x95, 0xAB },	/* 0xD7 */
		{ 0xE2, 0x95, 0xAA },	/* 0xD8 */
		{ 0xE2, 0x94, 0x98 },	/* 0xD9 */
		{ 0xE2, 0x94, 0x8C },	/* 0xDA */
		{ 0xE2, 0x96, 0x88 },	/* 0xDB */
		{ 0xE2, 0x96, 0x84 },	/* 0xDC */
		{ 0xE2, 0x96, 0x8C },	/* 0xDD */
		{ 0xE2, 0x96, 0x90 },	/* 0xDE */
		{ 0xE2, 0x96, 0x80 },	/* 0xDF */
		{ 0xCE, 0xB1, 0x00 },	/* 0xE0 */
		{ 0xC3, 0x9F, 0x00 },	/* 0xE1 */
		{ 0xCE, 0x93, 0x00 },	/* 0xE2 */
		{ 0xCF, 0x80, 0x00 },	/* 0xE3 */
		{ 0xCE, 0xA3, 0x00 },	/* 0xE4 */
		{ 0xCF, 0x83, 0x00 },	/* 0xE5 */
		{ 0xC2, 0xB5, 0x00 },	/* 0xE6 */
		{ 0xCF, 0x84, 0x00 },	/* 0xE7 */
		{ 0xCE, 0xA6, 0x00 },	/* 0xE8 */
		{ 0xCE, 0x98, 0x00 },	/* 0xE9 */
		{ 0xCE, 0xA9, 0x00 },	/* 0xEA */
		{ 0xCE, 0xB4, 0x00 },	/* 0xEB */
		{ 0xE2, 0x88, 0x9E },	/* 0xEC */
		{ 0xCF, 0x86, 0x00 },	/* 0xED */
		{ 0xCE, 0xB5, 0x00 },	/* 0xEE */
		{ 0xE2, 0x88, 0xA9 },	/* 0xEF */
		{ 0xE2, 0x89, 0xA1 },	/* 0xF0 */
		{ 0xC2, 0xB1, 0x00 },	/* 0xF1 */
		{ 0xE2, 0x89, 0xA5 },	/* 0xF2 */
		{ 0xE2, 0x89, 0xA4 },	/* 0xF3 */
		{ 0xE2, 0x8C, 0xA0 },	/* 0xF4 */
		{ 0xE2, 0x8C, 0xA1 },	/* 0xF5 */
		{ 0xC3, 0xB7, 0x00 },	/* 0xF6 */
		{ 0xE2, 0x89, 0x88 },	/* 0xF7 */
		{ 0xC2, 0xB0, 0x00 },	/* 0xF8 */
		{ 0xE2, 0x88, 0x99 },	/* 0xF9 */
		{ 0xC2, 0xB7, 0x00 },	/* 0xFA */
		{ 0xE2, 0x88, 0x9A },	/* 0xFB */
		{ 0xE2, 0x81, 0xBF },	/* 0xFC */
		{ 0xC2, 0xB2, 0x00 },	/* 0xFD */
		{ 0xE2, 0x96, 0xA0 },	/* 0xFE */
		{ 0xC2, 0xA0, 0x00 },	/* 0xFF */
	},
	{	/* CP866 -> UTF-8 */
		{ 0xD0, 0x90, 0x00 },	/* 0x80 */
		{ 0xD0, 0x91, 0x00 },	/* 0x81 */
		{ 0xD0, 0x92, 0x00 },	/* 0x82 */
		{ 0xD0, 0x93, 0x00 },	/* 0x83 */
		{ 0xD0, 0x94, 0x00 },	/* 0x84 */
		{ 0xD0, 0x95, 0x00 },	/* 0x85 */
		{ 0xD0, 0x96, 0x00 },	/* 0x86 */
		{ 0xD0, 0x97, 0x00 },	/* 0x87 */
		{ 0xD0, 0x98, 0x00 },	/* 0x88 */
		{ 0xD0, 0x99, 0x00 },	/* 0x89 */
		{ 0xD0, 0x9A, 0x00 },	/* 0x8A */
		{ 0xD0, 0x9B, 0x00 },	/* 0x8B */
		{ 0xD0, 0x9C, 0x00 },	/* 0x8C */
		{ 0xD0, 0x9D, 0x00 },	/* 0x8D */
		{ 0xD0, 0x9E, 0x00 },	/* 0x8E */
		{ 0xD0, 0x9F, 0x00 },	/* 0x8F */
		{ 0xD0, 0xA0, 0x00 },	/* 0x90 */
		{ 0xD0, 0xA1, 0x00 },	/* 0x91 */
		{ 0xD0, 0xA2, 0x00 },	/* 0x92 */
		{ 0xD0, 0xA3, 0x00 },	/* 0x93 */
		{ 0xD0, 0xA4, 0x00 },	/* 0x94 */
		{ 0xD0, 0xA5, 0x00 },	/* 0x95 */
		{ 0xD0, 0xA6, 0x00 },	/* 0x96 */
		{ 0xD0, 0xA7, 0x00 },	/* 0x97 */
		{ 0xD0, 0xA8, 0x00 },	/* 0x98 */
		{ 0xD0, 0xA9, 0x00 },	/* 0x99 */
		{ 0xD0, 0xAA, 0x00 },	/* 0x9A */
		{ 0xD0, 0xAB, 0x00 },	/* 0x9B */
		{ 0xD0, 0xAC, 0x00 },	/* 0x9C */
		{ 0xD0, 0xAD, 0x00 },	/* 0x9D */
		{ 0xD0, 0xAE, 0x00 },	/* 0x9E */
		{ 0xD0, 0xAF, 0x00 },	/* 0x9F */
		{ 0xD0, 0xB0, 0x00 },	/* 0xA0 */
		{ 0xD0, 0xB1, 0x00 },	/* 0xA1 */
		{ 0xD0, 0xB2, 0x00 },	/* 0xA2 */
		{ 0xD0, 0xB3, 0x00 },	/* 0xA3 */
		{ 0xD0, 0xB4, 0x00 },	/* 0xA4 */
		{ 0xD0, 0xB5, 0x00 },	/* 0xA5 */
		{ 0xD0, 0xB6, 0x00 },	/* 0xA6 */
		{ 0xD0, 0xB7, 0x00 },	/* 0xA7 */
		{ 0xD0, 0xB8, 0x00 },	/* 0xA8 */
		{ 0xD0, 0xB9, 0x00 },	/* 0xA9 */
		{ 0xD0, 0xBA, 0x00 },	/* 0xAA */
		{ 0xD0, 0xBB, 0x00 },	/* 0xAB */
		{ 0xD0, 0xBC, 0x00 },	/* 0xAC */
		{ 0xD0, 0xBD, 0x00 },	/* 0xAD */
		{ 0xD0, 0xBE, 0x00 },	/* 0xAE */
		{ 0xD0, 0xBF, 0x00 },	/* 0xAF */
		{ 0xE2, 0x96, 0x91 },	/* 0xB0 */
		{ 0xE2, 0x96, 0x92 },	/* 0xB1 */
		{ 0xE2, 0x96, 0x93 },	/* 0xB2 */
		{ 0xE2, 0x94, 0x82 },	/* 0xB3 */
		{ 0xE2, 0x94, 0xA4 },	/* 0xB4 */
		{ 0xE2, 0x95, 0xA1 },	/* 0xB5 */
		{ 0xE2, 0x95, 0xA2 },	/* 0xB6 */
		{ 0xE2, 0x95, 0x96 },	/* 0xB7 */
		{ 0xE2, 0x95, 0x95 },	/* 0xB8 */
		{ 0xE2, 0x95, 0xA3 },	/* 0xB9 */
		{ 0xE2, 0x95, 0x91 },	/* 0xBA */
		{ 0xE2, 0x95, 0x97 },	/* 0xBB */
		{ 0xE2, 0x95, 0x9D },	/* 0xBC */
		{ 0xE2, 0x95, 0x9C },	/* 0xBD */
		{ 0xE2, 0x95, 0x9B },	/* 0xBE */
		{ 0xE2, 0x94, 0x90 },	/* 0xBF */
		{ 0xE2, 0x94, 0x94 },	/* 0xC0 */
		{ 0xE2, 0x94, 0xB4 },	/* 0xC1 */
		{ 0xE2, 0x94, 0xAC },	/* 0xC2 */
		{ 0xE2, 0x94, 0x9C },	/* 0xC3 */
		{ 0xE2, 0x94, 0x80 },	/* 0xC4 */
		{ 0xE2, 0x94, 0xBC },	/* 0xC5 */
		{ 0xE2, 0x95, 0x9E },	/* 0xC6 */
		{ 0xE2, 0x95, 0x9F },	/* 0xC7 */
		{ 0xE2, 0x95, 0x9A },	/* 0xC8 */
		{ 0xE2, 0x95, 0x94 },	/* 0xC9 */
		{ 0xE2, 0x95, 0xA9 },	/* 0xCA */
		{ 0xE2, 0x95, 0xA6 },	/* 0xCB */
		{ 0xE2, 0x95, 0xA0 },	/* 0xCC */
		{ 0xE2, 0x95, 0x90 },	/* 0xCD */
		{ 0xE2, 0x95, 0xAC },	/* 0xCE */
		{ 0xE2, 0x95, 0xA7 },	/* 0xCF */
		{ 0xE2, 0x95, 0xA8 },	/* 0xD0 */
		{ 0xE2, 0x95, 0xA4 },	/* 0xD1 */
		{ 0xE2, 0x95, 0xA5 },	/* 0xD2 */
		{ 0xE2, 0x95, 0x99 },	/* 0xD3 */
		{ 0xE2, 0x95, 0x98 },	/* 0xD4 */
		{ 0xE2, 0x95, 0x92 },	/* 0xD5 */
		{ 0xE2, 0x95, 0x93 },	/* 0xD6 */
		{ 0xE2, 0x95, 0xAB },	/* 0xD7 */
		{ 0xE2, 0x95, 0xAA },	/* 0xD8 */
		{ 0xE2, 0x94, 0x98 },	/* 0xD9 */
		{ 0xE2, 0x94, 0x8C },	/* 0xDA */
		{ 0xE2, 0x96, 0x88 },	/* 0xDB */
		{ 0xE2, 0x96, 0x84 },	/* 0xDC */
		{ 0xE2, 0x96, 0x8C },	/* 0xDD */
		{ 0xE2, 0x96, 0x90 },	/* 0xDE */
		{ 0xE2, 0x96, 0x80 },	/* 0xDF */
		{ 0xD1, 0x80, 0x00 },	/* 0xE0 */
		{ 0xD1, 0x81, 0x00 },	/* 0xE1 */
		{ 0xD1, 0x82, 0x00 },	/* 0xE2 */
		{ 0xD1, 0x83, 0x00 },	/* 0xE3 */
		{ 0xD1, 0x84, 0x00 },	/* 0xE4 */
		{ 0xD1, 0x85, 0x00 },	/* 0xE5 */
		{ 0xD1, 0x86, 0x00 },	/* 0xE6 */
		{ 0xD1, 0x87, 0x00 },	/* 0xE7 */
		{ 0xD1, 0x88, 0x00 },	/* 0xE8 */
		{ 0xD1, 0x89, 0x00 },	/* 0xE9 */
		{ 0xD1, 0x8A, 0x00 },	/* 0xEA */
		{ 0xD1, 0x8B, 0x00 },	/* 0xEB */
		{ 0xD1, 0x8C, 0x00 },	/* 0xEC */
		{ 0xD1, 0x8D, 0x00 },	/* 0xED */
		{ 0xD1, 0x8E, 0x00 },	/* 0xEE */
		{ 0xD1, 0x8F, 0x00 },	/* 0xEF */
		{ 0xD0, 0x81, 0x00 },	/* 0xF0 */
		{ 0xD1, 0x91, 0x00 },	/* 0xF1 */
		{ 0xD0, 0x84, 0x00 },	/* 0xF2 */
		{ 0xD1, 0x94, 0x00 },	/* 0xF3 */
		{ 0xD0, 0x87, 0x00 },	/* 0xF4 */
		{ 0xD1, 0x97, 0x00 },	/* 0xF5 */
		{ 0xD0, 0x8E, 0x00 },	/* 0xF6 */
		{ 0xD1, 0x9E, 0x00 },	/* 0xF7 */
		{ 0xC2, 0xB0, 0x00 },	/* 0xF8 */
		{ 0xE2, 0x88, 0x99 },	/* 0xF9 */
		{ 0xC2, 0xB7, 0x00 },	/* 0xFA */
		{ 0xE2, 0x88, 0x9A },	/* 0xFB */
		{ 0xE2, 0x84, 0x96 },	/* 0xFC */
		{ 0xC2, 0xA4, 0x00 },	/* 0xFD */
		{ 0xE2, 0x96, 0xA0 },	/* 0xFE */
		{ 0xC2, 0xA0, 0x00 },	/* 0xFF */
	},
	{	/* CP1250 -> UTF-8 */
		{ 0xE2, 0x82, 0xAC },	/* 0x80 */
		{ 0xFE, 0xFE, 0xFE },	/* 0x81 (illegal character) */
		{ 0xE2, 0x80, 0x9A },	/* 0x82 */
		{ 0xFE, 0xFE, 0xFE },	/* 0x83 (illegal character) */
		{ 0xE2, 0x80, 0x9E },	/* 0x84 */
		{ 0xE2, 0x80, 0xA6 },	/* 0x85 */
		{ 0xE2, 0x80, 0xA0 },	/* 0x86 */
		{ 0xE2, 0x80, 0xA1 },	/* 0x87 */
		{ 0xFE, 0xFE, 0xFE },	/* 0x88 (illegal character) */
		{ 0xE2, 0x80, 0xB0 },	/* 0x89 */
		{ 0xC5, 0xA0, 0x00 },	/* 0x8A */
		{ 0xE2, 0x80, 0xB9 },	/* 0x8B */
		{ 0xC5, 0x9A, 0x00 },	/* 0x8C */
		{ 0xC5, 0xA4, 0x00 },	/* 0x8D */
		{ 0xC5, 0xBD, 0x00 },	/* 0x8E */
		{ 0xC5, 0xB9, 0x00 },	/* 0x8F */
		{ 0xFE, 0xFE, 0xFE },	/* 0x90 (illegal character) */
		{ 0xE2, 0x80, 0x98 },	/* 0x91 */
		{ 0xE2, 0x80, 0x99 },	/* 0x92 */
		{ 0xE2, 0x80, 0x9C },	/* 0x93 */
		{ 0xE2, 0x80, 0x9D },	/* 0x94 */
		{ 0xE2, 0x80, 0xA2 },	/* 0x95 */
		{ 0xE2, 0x80, 0x93 },	/* 0x96 */
		{ 0xE2, 0x80, 0x94 },	/* 0x97 */
		{ 0xFE, 0xFE, 0xFE },	/* 0x98 (illegal character) */
		{ 0xE2, 0x84, 0xA2 },	/* 0x99 */
		{ 0xC5, 0xA1, 0x00 },	/* 0x9A */
		{ 0xE2, 0x80, 0xBA },	/* 0x9B */
		{ 0xC5, 0x9B, 0x00 },	/* 0x9C */
		{ 0xC5, 0xA5, 0x00 },	/* 0x9D */
		{ 0xC5, 0xBE, 0x00 },	/* 0x9E */
		{ 0xC5, 0xBA, 0x00 },	/* 0x9F */
		{ 0xC2, 0xA0, 0x00 },	/* 0xA0 */
		{ 0xCB, 0x87, 0x00 },	/* 0xA1 */
		{ 0xCB, 0x98, 0x00 },	/* 0xA2 */
		{ 0xC5, 0x81, 0x00 },	/* 0xA3 */
		{ 0xC2, 0xA4, 0x00 },	/* 0xA4 */
		{ 0xC4, 0x84, 0x00 },	/* 0xA5 */
		{ 0xC2, 0xA6, 0x00 },	/* 0xA6 */
		{ 0xC2, 0xA7, 0x00 },	/* 0xA7 */
		{ 0xC2, 0xA8, 0x00 },	/* 0xA8 */
		{ 0xC2, 0xA9, 0x00 },	/* 0xA9 */
		{ 0xC5, 0x9E, 0x00 },	/* 0xAA */
		{ 0xC2, 0xAB, 0x00 },	/* 0xAB */
		{ 0xC2, 0xAC, 0x00 },	/* 0xAC */
		{ 0xC2, 0xAD, 0x00 },	/* 0xAD */
		{ 0xC2, 0xAE, 0x00 },	/* 0xAE */
		{ 0xC5, 0xBB, 0x00 },	/* 0xAF */
		{ 0xC2, 0xB0, 0x00 },	/* 0xB0 */
		{ 0xC2, 0xB1, 0x00 },	/* 0xB1 */
		{ 0xCB, 0x9B, 0x00 },	/* 0xB2 */
		{ 0xC5, 0x82, 0x00 },	/* 0xB3 */
		{ 0xC2, 0xB4, 0x00 },	/* 0xB4 */
		{ 0xC2, 0xB5, 0x00 },	/* 0xB5 */
		{ 0xC2, 0xB6, 0x00 },	/* 0xB6 */
		{ 0xC2, 0xB7, 0x00 },	/* 0xB7 */
		{ 0xC2, 0xB8, 0x00 },	/* 0xB8 */
		{ 0xC4, 0x85, 0x00 },	/* 0xB9 */
		{ 0xC5, 0x9F, 0x00 },	/* 0xBA */
		{ 0xC2, 0xBB, 0x00 },	/* 0xBB */
		{ 0xC4, 0xBD, 0x00 },	/* 0xBC */
		{ 0xCB, 0x9D, 0x00 },	/* 0xBD */
		{ 0xC4, 0xBE, 0x00 },	/* 0xBE */
		{ 0xC5, 0xBC, 0x00 },	/* 0xBF */
		{ 0xC5, 0x94, 0x00 },	/* 0xC0 */
		{ 0xC3, 0x81, 0x00 },	/* 0xC1 */
		{ 0xC3, 0x82, 0x00 },	/* 0xC2 */
		{ 0xC4, 0x82, 0x00 },	/* 0xC3 */
		{ 0xC3, 0x84, 0x00 },	/* 0xC4 */
		{ 0xC4, 0xB9, 0x00 },	/* 0xC5 */
		{ 0xC4, 0x86, 0x00 },	/* 0xC6 */
		{ 0xC3, 0x87, 0x00 },	/* 0xC7 */
		{ 0xC4, 0x8C, 0x00 },	/* 0xC8 */
		{ 0xC3, 0x89, 0x00 },	/* 0xC9 */
		{ 0xC4, 0x98, 0x00 },	/* 0xCA */
		{ 0xC3, 0x8B, 0x00 },	/* 0xCB */
		{ 0xC4, 0x9A, 0x00 },	/* 0xCC */
		{ 0xC3, 0x8D, 0x00 },	/* 0xCD */
		{ 0xC3, 0x8E, 0x00 },	/* 0xCE */
		{ 0xC4, 0x8E, 0x00 },	/* 0xCF */
		{ 0xC4, 0x90, 0x00 },	/* 0xD0 */
		{ 0xC5, 0x83, 0x00 },	/* 0xD1 */
		{ 0xC5, 0x87, 0x00 },	/* 0xD2 */
		{ 0xC3, 0x93, 0x00 },	/* 0xD3 */
		{ 0xC3, 0x94, 0x00 },	/* 0xD4 */
		{ 0xC5, 0x90, 0x00 },	/* 0xD5 */
		{ 0xC3, 0x96, 0x00 },	/* 0xD6 */
		{ 0xC3, 0x97, 0x00 },	/* 0xD7 */
		{ 0xC5, 0x98, 0x00 },	/* 0xD8 */
		{ 0xC5, 0xAE, 0x00 },	/* 0xD9 */
		{ 0xC3, 0x9A, 0x00 },	/* 0xDA */
		{ 0xC5, 0xB0, 0x00 },	/* 0xDB */
		{ 0xC3, 0x9C, 0x00 },	/* 0xDC */
		{ 0xC3, 0x9D, 0x00 },	/* 0xDD */
		{ 0xC5, 0xA2, 0x00 },	/* 0xDE */
		{ 0xC3, 0x9F, 0x00 },	/* 0xDF */
		{ 0xC5, 0x95, 0x00 },	/* 0xE0 */
		{ 0xC3, 0xA1, 0x00 },	/* 0xE1 */
		{ 0xC3, 0xA2, 0x00 },	/* 0xE2 */
		{ 0xC4, 0x83, 0x00 },	/* 0xE3 */
		{ 0xC3, 0xA4, 0x00 },	/* 0xE4 */
		{ 0xC4, 0xBA, 0x00 },	/* 0xE5 */
		{ 0xC4, 0x87, 0x00 },	/* 0xE6 */
		{ 0xC3, 0xA7, 0x00 },	/* 0xE7 */
		{ 0xC4, 0x8D, 0x00 },	/* 0xE8 */
		{ 0xC3, 0xA9, 0x00 },	/* 0xE9 */
		{ 0xC4, 0x99, 0x00 },	/* 0xEA */
		{ 0xC3, 0xAB, 0x00 },	/* 0xEB */
		{ 0xC4, 0x9B, 0x00 },	/* 0xEC */
		{ 0xC3, 0xAD, 0x00 },	/* 0xED */
		{ 0xC3, 0xAE, 0x00 },	/* 0xEE */
		{ 0xC4, 0x8F, 0x00 },	/* 0xEF */
		{ 0xC4, 0x91, 0x00 },	/* 0xF0 */
		{ 0xC5, 0x84, 0x00 },	/* 0xF1 */
		{ 0xC5, 0x88, 0x00 },	/* 0xF2 */
		{ 0xC3, 0xB3, 0x00 },	/* 0xF3 */
		{ 0xC3, 0xB4, 0x00 },	/* 0xF4 */
		{ 0xC5, 0x91, 0x00 },	/* 0xF5 */
		{ 0xC3, 0xB6, 0x00 },	/* 0xF6 */
		{ 0xC3, 0xB7, 0x00 },	/* 0xF7 */
		{ 0xC5, 0x99, 0x00 },	/* 0xF8 */
		{ 0xC5, 0xAF, 0x00 },	/* 0xF9 */
		{ 0xC3, 0xBA, 0x00 },	/* 0xFA */
		{ 0xC5, 0xB1, 0x00 },	/* 0xFB */
		{ 0xC3, 0xBC, 0x00 },	/* 0xFC */
		{ 0xC3, 0xBD, 0x00 },	/* 0xFD */
		{ 0xC5, 0xA3, 0x00 },	/* 0xFE */
		{ 0xCB, 0x99, 0x00 },	/* 0xFF */
	},
	{	/* CP1251 -> UTF-8 */
		{ 0xD0, 0x82, 0x00 },	/* 0x80 */
		{ 0xD0, 0x83, 0x00 },	/* 0x81 */
		{ 0xE2, 0x80, 0x9A },	/* 0x82 */
		{ 0xD1, 0x93, 0x00 },	/* 0x83 */
		{ 0xE2, 0x80, 0x9E },	/* 0x84 */
		{ 0xE2, 0x80, 0xA6 },	/* 0x85 */
		{ 0xE2, 0x80, 0xA0 },	/* 0x86 */
		{ 0xE2, 0x80, 0xA1 },	/* 0x87 */
		{ 0xE2, 0x82, 0xAC },	/* 0x88 */
		{ 0xE2, 0x80, 0xB0 },	/* 0x89 */
		{ 0xD0, 0x89, 0x00 },	/* 0x8A */
		{ 0xE2, 0x80, 0xB9 },	/* 0x8B */
		{ 0xD0, 0x8A, 0x00 },	/* 0x8C */
		{ 0xD0, 0x8C, 0x00 },	/* 0x8D */
		{ 0xD0, 0x8B, 0x00 },	/* 0x8E */
		{ 0xD0, 0x8F, 0x00 },	/* 0x8F */
		{ 0xD1, 0x92, 0x00 },	/* 0x90 */
		{ 0xE2, 0x80, 0x98 },	/* 0x91 */
		{ 0xE2, 0x80, 0x99 },	/* 0x92 */
		{ 0xE2, 0x80, 0x9C },	/* 0x93 */
		{ 0xE2, 0x80, 0x9D },	/* 0x94 */
		{ 0xE2, 0x80, 0xA2 },	/* 0x95 */
		{ 0xE2, 0x80, 0x93 },	/* 0x96 */
		{ 0xE2, 0x80, 0x94 },	/* 0x97 */
		{ 0xFE, 0xFE, 0xFE },	/* 0x98 (illegal character) */
		{ 0xE2, 0x84, 0xA2 },	/* 0x99 */
		{ 0xD1, 0x99, 0x00 },	/* 0x9A */
		{ 0xE2, 0x80, 0xBA },	/* 0x9B */
		{ 0xD1, 0x9A, 0x00 },	/* 0x9C */
		{ 0xD1, 0x9C, 0x00 },	/* 0x9D */
		{ 0xD1, 0x9B, 0x00 },	/* 0x9E */
		{ 0xD1, 0x9F, 0x00 },	/* 0x9F */
		{ 0xC2, 0xA0, 0x00 },	/* 0xA0 */
		{ 0xD0, 0x8E, 0x00 },	/* 0xA1 */
		{ 0xD1, 0x9E, 0x00 },	/* 0xA2 */
		{ 0xD0, 0x88, 0x00 },	/* 0xA3 */
		{ 0xC2, 0xA4, 0x00 },	/* 0xA4 */
		{ 0xD2, 0x90, 0x00 },	/* 0xA5 */
		{ 0xC2, 0xA6, 0x00 },	/* 0xA6 */
		{ 0xC2, 0xA7, 0x00 },	/* 0xA7 */
		{ 0xD0, 0x81, 0x00 },	/* 0xA8 */
		{ 0xC2, 0xA9, 0x00 },	/* 0xA9 */
		{ 0xD0, 0x84, 0x00 },	/* 0xAA */
		{ 0xC2, 0xAB, 0x00 },	/* 0xAB */
		{ 0xC2, 0xAC, 0x00 },	/* 0xAC */
		{ 0xC2, 0xAD, 0x00 },	/* 0xAD */
		{ 0xC2, 0xAE, 0x00 },	/* 0xAE */
		{ 0xD0, 0x87, 0x00 },	/* 0xAF */
		{ 0xC2, 0xB0, 0x00 },	/* 0xB0 */
		{ 0xC2, 0xB1, 0x00 },	/* 0xB1 */
		{ 0xD0, 0x86, 0x00 },	/* 0xB2 */
		{ 0xD1, 0x96, 0x00 },	/* 0xB3 */
		{ 0xD2, 0x91, 0x00 },	/* 0xB4 */
		{ 0xC2, 0xB5, 0x00 },	/* 0xB5 */
		{ 0xC2, 0xB6, 0x00 },	/* 0xB6 */
		{ 0xC2, 0xB7, 0x00 },	/* 0xB7 */
		{ 0xD1, 0x91, 0x00 },	/* 0xB8 */
		{ 0xE2, 0x84, 0x96 },	/* 0xB9 */
		{ 0xD1, 0x94, 0x00 },	/* 0xBA */
		{ 0xC2, 0xBB, 0x00 },	/* 0xBB */
		{ 0xD1, 0x98, 0x00 },	/* 0xBC */
		{ 0xD0, 0x85, 0x00 },	/* 0xBD */
		{ 0xD1, 0x95, 0x00 },	/* 0xBE */
		{ 0xD1, 0x97, 0x00 },	/* 0xBF */
		{ 0xD0, 0x90, 0x00 },	/* 0xC0 */
		{ 0xD0, 0x91, 0x00 },	/* 0xC1 */
		{ 0xD0, 0x92, 0x00 },	/* 0xC2 */
		{ 0xD0, 0x93, 0x00 },	/* 0xC3 */
		{ 0xD0, 0x94, 0x00 },	/* 0xC4 */
		{ 0xD0, 0x95, 0x00 },	/* 0xC5 */
		{ 0xD0, 0x96, 0x00 },	/* 0xC6 */
		{ 0xD0, 0x97, 0x00 },	/* 0xC7 */
		{ 0xD0, 0x98, 0x00 },	/* 0xC8 */
		{ 0xD0, 0x99, 0x00 },	/* 0xC9 */
		{ 0xD0, 0x9A, 0x00 },	/* 0xCA */
		{ 0xD0, 0x9B, 0x00 },	/* 0xCB */
		{ 0xD0, 0x9C, 0x00 },	/* 0xCC */
		{ 0xD0, 0x9D, 0x00 },	/* 0xCD */
		{ 0xD0, 0x9E, 0x00 },	/* 0xCE */
		{ 0xD0, 0x9F, 0x00 },	/* 0xCF */
		{ 0xD0, 0xA0, 0x00 },	/* 0xD0 */
		{ 0xD0, 0xA1, 0x00 },	/* 0xD1 */
		{ 0xD0, 0xA2, 0x00 },	/* 0xD2 */
		{ 0xD0, 0xA3, 0x00 },	/* 0xD3 */
		{ 0xD0, 0xA4, 0x00 },	/* 0xD4 */
		{ 0xD0, 0xA5, 0x00 },	/* 0xD5 */
		{ 0xD0, 0xA6, 0x00 },	/* 0xD6 */
		{ 0xD0, 0xA7, 0x00 },	/* 0xD7 */
		{ 0xD0, 0xA8, 0x00 },	/* 0xD8 */
		{ 0xD0, 0xA9, 0x00 },	/* 0xD9 */
		{ 0xD0, 0xAA, 0x00 },	/* 0xDA */
		{ 0xD0, 0xAB, 0x00 },	/* 0xDB */
		{ 0xD0, 0xAC, 0x00 },	/* 0xDC */
		{ 0xD0, 0xAD, 0x00 },	/* 0xDD */
		{ 0xD0, 0xAE, 0x00 },	/* 0xDE */
		{ 0xD0, 0xAF, 0x00 },	/* 0xDF */
		{ 0xD0, 0xB0, 0x00 },	/* 0xE0 */
		{ 0xD0, 0xB1, 0x00 },	/* 0xE1 */
		{ 0xD0, 0xB2, 0x00 },	/* 0xE2 */
		{ 0xD0, 0xB3, 0x00 },	/* 0xE3 */
		{ 0xD0, 0xB4, 0x00 },	/* 0xE4 */
		{ 0xD0, 0xB5, 0x00 },	/* 0xE5 */
		{ 0xD0, 0xB6, 0x00 },	/* 0xE6 */
		{ 0xD0, 0xB7, 0x00 },	/* 0xE7 */
		{ 0xD0, 0xB8, 0x00 },	/* 0xE8 */
		{ 0xD0, 0xB9, 0x00 },	/* 0xE9 */
		{ 0xD0, 0xBA, 0x00 },	/* 0xEA */
		{ 0xD0, 0xBB, 0x00 },	/* 0xEB */
		{ 0xD0, 0xBC, 0x00 },	/* 0xEC */
		{ 0xD0, 0xBD, 0x00 },	/* 0xED */
		{ 0xD0, 0xBE, 0x00 },	/* 0xEE */
		{ 0xD0, 0xBF, 0x00 },	/* 0xEF */
		{ 0xD1, 0x80, 0x00 },	/* 0xF0 */
		{ 0xD1, 0x81, 0x00 },	/* 0xF1 */
		{ 0xD1, 0x82, 0x00 },	/* 0xF2 */
		{ 0xD1, 0x83, 0x00 },	/* 0xF3 */
		{ 0xD1, 0x84, 0x00 },	/* 0xF4 */
		{ 0xD1, 0x85, 0x00 },	/* 0xF5 */
		{ 0xD1, 0x86, 0x00 },	/* 0xF6 */
		{ 0xD1, 0x87, 0x00 },	/* 0xF7 */
		{ 0xD1, 0x88, 0x00 },	/* 0xF8 */
		{ 0xD1, 0x89, 0x00 },	/* 0xF9 */
		{ 0xD1, 0x8A, 0x00 },	/* 0xFA */
		{ 0xD1, 0x8B, 0x00 },	/* 0xFB */
		{ 0xD1, 0x8C, 0x00 },	/* 0xFC */
		{ 0xD1, 0x8D, 0x00 },	/* 0xFD */
		{ 0xD1, 0x8E, 0x00 },	/* 0xFE */
		{ 0xD1, 0x8F, 0x00 },	/* 0xFF */
	},
	{	/* CP1253 -> UTF-8 */
		{ 0xE2, 0x82, 0xAC },	/* 0x80 */
		{ 0xFE, 0xFE, 0xFE },	/* 0x81 (illegal character) */
		{ 0xE2, 0x80, 0x9A },	/* 0x82 */
		{ 0xC6, 0x92, 0x00 },	/* 0x83 */
		{ 0xE2, 0x80, 0x9E },	/* 0x84 */
		{ 0xE2, 0x80, 0xA6 },	/* 0x85 */
		{ 0xE2, 0x80, 0xA0 },	/* 0x86 */
		{ 0xE2, 0x80, 0xA1 },	/* 0x87 */
		{ 0xFE, 0xFE, 0xFE },	/* 0x88 (illegal character) */
		{ 0xE2, 0x80, 0xB0 },	/* 0x89 */
		{ 0xFE, 0xFE, 0xFE },	/* 0x8A (illegal character) */
		{ 0xE2, 0x80, 0xB9 },	/* 0x8B */
		{ 0xFE, 0xFE, 0xFE },	/* 0x8C (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0x8D (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0x8E (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0x8F (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0x90 (illegal character) */
		{ 0xE2, 0x80, 0x98 },	/* 0x91 */
		{ 0xE2, 0x80, 0x99 },	/* 0x92 */
		{ 0xE2, 0x80, 0x9C },	/* 0x93 */
		{ 0xE2, 0x80, 0x9D },	/* 0x94 */
		{ 0xE2, 0x80, 0xA2 },	/* 0x95 */
		{ 0xE2, 0x80, 0x93 },	/* 0x96 */
		{ 0xE2, 0x80, 0x94 },	/* 0x97 */
		{ 0xFE, 0xFE, 0xFE },	/* 0x98 (illegal character) */
		{ 0xE2, 0x84, 0xA2 },	/* 0x99 */
		{ 0xFE, 0xFE, 0xFE },	/* 0x9A (illegal character) */
		{ 0xE2, 0x80, 0xBA },	/* 0x9B */
		{ 0xFE, 0xFE, 0xFE },	/* 0x9C (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0x9D (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0x9E (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0x9F (illegal character) */
		{ 0xC2, 0xA0, 0x00 },	/* 0xA0 */
		{ 0xCE, 0x85, 0x00 },	/* 0xA1 */
		{ 0xCE, 0x86, 0x00 },	/* 0xA2 */
		{ 0xC2, 0xA3, 0x00 },	/* 0xA3 */
		{ 0xC2, 0xA4, 0x00 },	/* 0xA4 */
		{ 0xC2, 0xA5, 0x00 },	/* 0xA5 */
		{ 0xC2, 0xA6, 0x00 },	/* 0xA6 */
		{ 0xC2, 0xA7, 0x00 },	/* 0xA7 */
		{ 0xC2, 0xA8, 0x00 },	/* 0xA8 */
		{ 0xC2, 0xA9, 0x00 },	/* 0xA9 */
		{ 0xFE, 0xFE, 0xFE },	/* 0xAA (illegal character) */
		{ 0xC2, 0xAB, 0x00 },	/* 0xAB */
		{ 0xC2, 0xAC, 0x00 },	/* 0xAC */
		{ 0xC2, 0xAD, 0x00 },	/* 0xAD */
		{ 0xC2, 0xAE, 0x00 },	/* 0xAE */
		{ 0xE2, 0x80, 0x95 },	/* 0xAF */
		{ 0xC2, 0xB0, 0x00 },	/* 0xB0 */
		{ 0xC2, 0xB1, 0x00 },	/* 0xB1 */
		{ 0xC2, 0xB2, 0x00 },	/* 0xB2 */
		{ 0xC2, 0xB3, 0x00 },	/* 0xB3 */
		{ 0xCE, 0x84, 0x00 },	/* 0xB4 */
		{ 0xC2, 0xB5, 0x00 },	/* 0xB5 */
		{ 0xC2, 0xB6, 0x00 },	/* 0xB6 */
		{ 0xC2, 0xB7, 0x00 },	/* 0xB7 */
		{ 0xCE, 0x88, 0x00 },	/* 0xB8 */
		{ 0xCE, 0x89, 0x00 },	/* 0xB9 */
		{ 0xCE, 0x8A, 0x00 },	/* 0xBA */
		{ 0xC2, 0xBB, 0x00 },	/* 0xBB */
		{ 0xCE, 0x8C, 0x00 },	/* 0xBC */
		{ 0xC2, 0xBD, 0x00 },	/* 0xBD */
		{ 0xCE, 0x8E, 0x00 },	/* 0xBE */
		{ 0xCE, 0x8F, 0x00 },	/* 0xBF */
		{ 0xCE, 0x90, 0x00 },	/* 0xC0 */
		{ 0xCE, 0x91, 0x00 },	/* 0xC1 */
		{ 0xCE, 0x92, 0x00 },	/* 0xC2 */
		{ 0xCE, 0x93, 0x00 },	/* 0xC3 */
		{ 0xCE, 0x94, 0x00 },	/* 0xC4 */
		{ 0xCE, 0x95, 0x00 },	/* 0xC5 */
		{ 0xCE, 0x96, 0x00 },	/* 0xC6 */
		{ 0xCE, 0x97, 0x00 },	/* 0xC7 */
		{ 0xCE, 0x98, 0x00 },	/* 0xC8 */
		{ 0xCE, 0x99, 0x00 },	/* 0xC9 */
		{ 0xCE, 0x9A, 0x00 },	/* 0xCA */
		{ 0xCE, 0x9B, 0x00 },	/* 0xCB */
		{ 0xCE, 0x9C, 0x00 },	/* 0xCC */
		{ 0xCE, 0x9D, 0x00 },	/* 0xCD */
		{ 0xCE, 0x9E, 0x00 },	/* 0xCE */
		{ 0xCE, 0x9F, 0x00 },	/* 0xCF */
		{ 0xCE, 0xA0, 0x00 },	/* 0xD0 */
		{ 0xCE, 0xA1, 0x00 },	/* 0xD1 */
		{ 0xFE, 0xFE, 0xFE },	/* 0xD2 (illegal character) */
		{ 0xCE, 0xA3, 0x00 },	/* 0xD3 */
		{ 0xCE, 0xA4, 0x00 },	/* 0xD4 */
		{ 0xCE, 0xA5, 0x00 },	/* 0xD5 */
		{ 0xCE, 0xA6, 0x00 },	/* 0xD6 */
		{ 0xCE, 0xA7, 0x00 },	/* 0xD7 */
		{ 0xCE, 0xA8, 0x00 },	/* 0xD8 */
		{ 0xCE, 0xA9, 0x00 },	/* 0xD9 */
		{ 0xCE, 0xAA, 0x00 },	/* 0xDA */
		{ 0xCE, 0xAB, 0x00 },	/* 0xDB */
		{ 0xCE, 0xAC, 0x00 },	/* 0xDC */
		{ 0xCE, 0xAD, 0x00 },	/* 0xDD */
		{ 0xCE, 0xAE, 0x00 },	/* 0xDE */
		{ 0xCE, 0xAF, 0x00 },	/* 0xDF */
		{ 0xCE, 0xB0, 0x00 },	/* 0xE0 */
		{ 0xCE, 0xB1, 0x00 },	/* 0xE1 */
		{ 0xCE, 0xB2, 0x00 },	/* 0xE2 */
		{ 0xCE, 0xB3, 0x00 },	/* 0xE3 */
		{ 0xCE, 0xB4, 0x00 },	/* 0xE4 */
		{ 0xCE, 0xB5, 0x00 },	/* 0xE5 */
		{ 0xCE, 0xB6, 0x00 },	/* 0xE6 */
		{ 0xCE, 0xB7, 0x00 },	/* 0xE7 */
		{ 0xCE, 0xB8, 0x00 },	/* 0xE8 */
		{ 0xCE, 0xB9, 0x00 },	/* 0xE9 */
		{ 0xCE, 0xBA, 0x00 },	/* 0xEA */
		{ 0xCE, 0xBB, 0x00 },	/* 0xEB */
		{ 0xCE, 0xBC, 0x00 },	/* 0xEC */
		{ 0xCE, 0xBD, 0x00 },	/* 0xED */
		{ 0xCE, 0xBE, 0x00 },	/* 0xEE */
		{ 0xCE, 0xBF, 0x00 },	/* 0xEF */
		{ 0xCF, 0x80, 0x00 },	/* 0xF0 */
		{ 0xCF, 0x81, 0x00 },	/* 0xF1 */
		{ 0xCF, 0x82, 0x00 },	/* 0xF2 */
		{ 0xCF, 0x83, 0x00 },	/* 0xF3 */
		{ 0xCF, 0x84, 0x00 },	/* 0xF4 */
		{ 0xCF, 0x85, 0x00 },	/* 0xF5 */
		{ 0xCF, 0x86, 0x00 },	/* 0xF6 */
		{ 0xCF, 0x87, 0x00 },	/* 0xF7 */
		{ 0xCF, 0x88, 0x00 },	/* 0xF8 */
		{ 0xCF, 0x89, 0x00 },	/* 0xF9 */
		{ 0xCF, 0x8A, 0x00 },	/* 0xFA */
		{ 0xCF, 0x8B, 0x00 },	/* 0xFB */
		{ 0xCF, 0x8C, 0x00 },	/* 0xFC */
		{ 0xCF, 0x8D, 0x00 },	/* 0xFD */
		{ 0xCF, 0x8E, 0x00 },	/* 0xFE */
		{ 0xFE, 0xFE, 0xFE },	/* 0xFF (illegal character) */
	},
	{	/* CP1254 -> UTF-8 */
		{ 0xE2, 0x82, 0xAC },	/* 0x80 */
		{ 0xFE, 0xFE, 0xFE },	/* 0x81 (illegal character) */
		{ 0xE2, 0x80, 0x9A },	/* 0x82 */
		{ 0xC6, 0x92, 0x00 },	/* 0x83 */
		{ 0xE2, 0x80, 0x9E },	/* 0x84 */
		{ 0xE2, 0x80, 0xA6 },	/* 0x85 */
		{ 0xE2, 0x80, 0xA0 },	/* 0x86 */
		{ 0xE2, 0x80, 0xA1 },	/* 0x87 */
		{ 0xCB, 0x86, 0x00 },	/* 0x88 */
		{ 0xE2, 0x80, 0xB0 },	/* 0x89 */
		{ 0xC5, 0xA0, 0x00 },	/* 0x8A */
		{ 0xE2, 0x80, 0xB9 },	/* 0x8B */
		{ 0xC5, 0x92, 0x00 },	/* 0x8C */
		{ 0xFE, 0xFE, 0xFE },	/* 0x8D (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0x8E (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0x8F (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0x90 (illegal character) */
		{ 0xE2, 0x80, 0x98 },	/* 0x91 */
		{ 0xE2, 0x80, 0x99 },	/* 0x92 */
		{ 0xE2, 0x80, 0x9C },	/* 0x93 */
		{ 0xE2, 0x80, 0x9D },	/* 0x94 */
		{ 0xE2, 0x80, 0xA2 },	/* 0x95 */
		{ 0xE2, 0x80, 0x93 },	/* 0x96 */
		{ 0xE2, 0x80, 0x94 },	/* 0x97 */
		{ 0xCB, 0x9C, 0x00 },	/* 0x98 */
		{ 0xE2, 0x84, 0xA2 },	/* 0x99 */
		{ 0xC5, 0xA1, 0x00 },	/* 0x9A */
		{ 0xE2, 0x80, 0xBA },	/* 0x9B */
		{ 0xC5, 0x93, 0x00 },	/* 0x9C */
		{ 0xFE, 0xFE, 0xFE },	/* 0x9D (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0x9E (illegal character) */
		{ 0xC5, 0xB8, 0x00 },	/* 0x9F */
		{ 0xC2, 0xA0, 0x00 },	/* 0xA0 */
		{ 0xC2, 0xA1, 0x00 },	/* 0xA1 */
		{ 0xC2, 0xA2, 0x00 },	/* 0xA2 */
		{ 0xC2, 0xA3, 0x00 },	/* 0xA3 */
		{ 0xC2, 0xA4, 0x00 },	/* 0xA4 */
		{ 0xC2, 0xA5, 0x00 },	/* 0xA5 */
		{ 0xC2, 0xA6, 0x00 },	/* 0xA6 */
		{ 0xC2, 0xA7, 0x00 },	/* 0xA7 */
		{ 0xC2, 0xA8, 0x00 },	/* 0xA8 */
		{ 0xC2, 0xA9, 0x00 },	/* 0xA9 */
		{ 0xC2, 0xAA, 0x00 },	/* 0xAA */
		{ 0xC2, 0xAB, 0x00 },	/* 0xAB */
		{ 0xC2, 0xAC, 0x00 },	/* 0xAC */
		{ 0xC2, 0xAD, 0x00 },	/* 0xAD */
		{ 0xC2, 0xAE, 0x00 },	/* 0xAE */
		{ 0xC2, 0xAF, 0x00 },	/* 0xAF */
		{ 0xC2, 0xB0, 0x00 },	/* 0xB0 */
		{ 0xC2, 0xB1, 0x00 },	/* 0xB1 */
		{ 0xC2, 0xB2, 0x00 },	/* 0xB2 */
		{ 0xC2, 0xB3, 0x00 },	/* 0xB3 */
		{ 0xC2, 0xB4, 0x00 },	/* 0xB4 */
		{ 0xC2, 0xB5, 0x00 },	/* 0xB5 */
		{ 0xC2, 0xB6, 0x00 },	/* 0xB6 */
		{ 0xC2, 0xB7, 0x00 },	/* 0xB7 */
		{ 0xC2, 0xB8, 0x00 },	/* 0xB8 */
		{ 0xC2, 0xB9, 0x00 },	/* 0xB9 */
		{ 0xC2, 0xBA, 0x00 },	/* 0xBA */
		{ 0xC2, 0xBB, 0x00 },	/* 0xBB */
		{ 0xC2, 0xBC, 0x00 },	/* 0xBC */
		{ 0xC2, 0xBD, 0x00 },	/* 0xBD */
		{ 0xC2, 0xBE, 0x00 },	/* 0xBE */
		{ 0xC2, 0xBF, 0x00 },	/* 0xBF */
		{ 0xC3, 0x80, 0x00 },	/* 0xC0 */
		{ 0xC3, 0x81, 0x00 },	/* 0xC1 */
		{ 0xC3, 0x82, 0x00 },	/* 0xC2 */
		{ 0xC3, 0x83, 0x00 },	/* 0xC3 */
		{ 0xC3, 0x84, 0x00 },	/* 0xC4 */
		{ 0xC3, 0x85, 0x00 },	/* 0xC5 */
		{ 0xC3, 0x86, 0x00 },	/* 0xC6 */
		{ 0xC3, 0x87, 0x00 },	/* 0xC7 */
		{ 0xC3, 0x88, 0x00 },	/* 0xC8 */
		{ 0xC3, 0x89, 0x00 },	/* 0xC9 */
		{ 0xC3, 0x8A, 0x00 },	/* 0xCA */
		{ 0xC3, 0x8B, 0x00 },	/* 0xCB */
		{ 0xC3, 0x8C, 0x00 },	/* 0xCC */
		{ 0xC3, 0x8D, 0x00 },	/* 0xCD */
		{ 0xC3, 0x8E, 0x00 },	/* 0xCE */
		{ 0xC3, 0x8F, 0x00 },	/* 0xCF */
		{ 0xC4, 0x9E, 0x00 },	/* 0xD0 */
		{ 0xC3, 0x91, 0x00 },	/* 0xD1 */
		{ 0xC3, 0x92, 0x00 },	/* 0xD2 */
		{ 0xC3, 0x93, 0x00 },	/* 0xD3 */
		{ 0xC3, 0x94, 0x00 },	/* 0xD4 */
		{ 0xC3, 0x95, 0x00 },	/* 0xD5 */
		{ 0xC3, 0x96, 0x00 },	/* 0xD6 */
		{ 0xC3, 0x97, 0x00 },	/* 0xD7 */
		{ 0xC3, 0x98, 0x00 },	/* 0xD8 */
		{ 0xC3, 0x99, 0x00 },	/* 0xD9 */
		{ 0xC3, 0x9A, 0x00 },	/* 0xDA */
		{ 0xC3, 0x9B, 0x00 },	/* 0xDB */
		{ 0xC3, 0x9C, 0x00 },	/* 0xDC */
		{ 0xC4, 0xB0, 0x00 },	/* 0xDD */
		{ 0xC5, 0x9E, 0x00 },	/* 0xDE */
		{ 0xC3, 0x9F, 0x00 },	/* 0xDF */
		{ 0xC3, 0xA0, 0x00 },	/* 0xE0 */
		{ 0xC3, 0xA1, 0x00 },	/* 0xE1 */
		{ 0xC3, 0xA2, 0x00 },	/* 0xE2 */
		{ 0xC3, 0xA3, 0x00 },	/* 0xE3 */
		{ 0xC3, 0xA4, 0x00 },	/* 0xE4 */
		{ 0xC3, 0xA5, 0x00 },	/* 0xE5 */
		{ 0xC3, 0xA6, 0x00 },	/* 0xE6 */
		{ 0xC3, 0xA7, 0x00 },	/* 0xE7 */
		{ 0xC3, 0xA8, 0x00 },	/* 0xE8 */
		{ 0xC3, 0xA9, 0x00 },	/* 0xE9 */
		{ 0xC3, 0xAA, 0x00 },	/* 0xEA */
		{ 0xC3, 0xAB, 0x00 },	/* 0xEB */
		{ 0xC3, 0xAC, 0x00 },	/* 0xEC */
		{ 0xC3, 0xAD, 0x00 },	/* 0xED */
		{ 0xC3, 0xAE, 0x00 },	/* 0xEE */
		{ 0xC3, 0xAF, 0x00 },	/* 0xEF */
		{ 0xC4, 0x9F, 0x00 },	/* 0xF0 */
		{ 0xC3, 0xB1, 0x00 },	/* 0xF1 */
		{ 0xC3, 0xB2, 0x00 },	/* 0xF2 */
		{ 0xC3, 0xB3, 0x00 },	/* 0xF3 */
		{ 0xC3, 0xB4, 0x00 },	/* 0xF4 */
		{ 0xC3, 0xB5, 0x00 },	/* 0xF5 */
		{ 0xC3, 0xB6, 0x00 },	/* 0xF6 */
		{ 0xC3, 0xB7, 0x00 },	/* 0xF7 */
		{ 0xC3, 0xB8, 0x00 },	/* 0xF8 */
		{ 0xC3, 0xB9, 0x00 },	/* 0xF9 */
		{ 0xC3, 0xBA, 0x00 },	/* 0xFA */
		{ 0xC3, 0xBB, 0x00 },	/* 0xFB */
		{ 0xC3, 0xBC, 0x00 },	/* 0xFC */
		{ 0xC4, 0xB1, 0x00 },	/* 0xFD */
		{ 0xC5, 0x9F, 0x00 },	/* 0xFE */
		{ 0xC3, 0xBF, 0x00 },	/* 0xFF */
	},
	{	/* CP1255 -> UTF-8 */
		{ 0xE2, 0x82, 0xAC },	/* 0x80 */
		{ 0xFE, 0xFE, 0xFE },	/* 0x81 (illegal character) */
		{ 0xE2, 0x80, 0x9A },	/* 0x82 */
		{ 0xC6, 0x92, 0x00 },	/* 0x83 */
		{ 0xE2, 0x80, 0x9E },	/* 0x84 */
		{ 0xE2, 0x80, 0xA6 },	/* 0x85 */
		{ 0xE2, 0x80, 0xA0 },	/* 0x86 */
		{ 0xE2, 0x80, 0xA1 },	/* 0x87 */
		{ 0xCB, 0x86, 0x00 },	/* 0x88 */
		{ 0xE2, 0x80, 0xB0 },	/* 0x89 */
		{ 0xFE, 0xFE, 0xFE },	/* 0x8A (illegal character) */
		{ 0xE2, 0x80, 0xB9 },	/* 0x8B */
		{ 0xFE, 0xFE, 0xFE },	/* 0x8C (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0x8D (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0x8E (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0x8F (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0x90 (illegal character) */
		{ 0xE2, 0x80, 0x98 },	/* 0x91 */
		{ 0xE2, 0x80, 0x99 },	/* 0x92 */
		{ 0xE2, 0x80, 0x9C },	/* 0x93 */
		{ 0xE2, 0x80, 0x9D },	/* 0x94 */
		{ 0xE2, 0x80, 0xA2 },	/* 0x95 */
		{ 0xE2, 0x80, 0x93 },	/* 0x96 */
		{ 0xE2, 0x80, 0x94 },	/* 0x97 */
		{ 0xCB, 0x9C, 0x00 },	/* 0x98 */
		{ 0xE2, 0x84, 0xA2 },	/* 0x99 */
		{ 0xFE, 0xFE, 0xFE },	/* 0x9A (illegal character) */
		{ 0xE2, 0x80, 0xBA },	/* 0x9B */
		{ 0xFE, 0xFE, 0xFE },	/* 0x9C (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0x9D (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0x9E (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0x9F (illegal character) */
		{ 0xC2, 0xA0, 0x00 },	/* 0xA0 */
		{ 0xC2, 0xA1, 0x00 },	/* 0xA1 */
		{ 0xC2, 0xA2, 0x00 },	/* 0xA2 */
		{ 0xC2, 0xA3, 0x00 },	/* 0xA3 */
		{ 0xE2, 0x82, 0xAA },	/* 0xA4 */
		{ 0xC2, 0xA5, 0x00 },	/* 0xA5 */
		{ 0xC2, 0xA6, 0x00 },	/* 0xA6 */
		{ 0xC2, 0xA7, 0x00 },	/* 0xA7 */
		{ 0xC2, 0xA8, 0x00 },	/* 0xA8 */
		{ 0xC2, 0xA9, 0x00 },	/* 0xA9 */
		{ 0xC3, 0x97, 0x00 },	/* 0xAA */
		{ 0xC2, 0xAB, 0x00 },	/* 0xAB */
		{ 0xC2, 0xAC, 0x00 },	/* 0xAC */
		{ 0xC2, 0xAD, 0x00 },	/* 0xAD */
		{ 0xC2, 0xAE, 0x00 },	/* 0xAE */
		{ 0xC2, 0xAF, 0x00 },	/* 0xAF */
		{ 0xC2, 0xB0, 0x00 },	/* 0xB0 */
		{ 0xC2, 0xB1, 0x00 },	/* 0xB1 */
		{ 0xC2, 0xB2, 0x00 },	/* 0xB2 */
		{ 0xC2, 0xB3, 0x00 },	/* 0xB3 */
		{ 0xC2, 0xB4, 0x00 },	/* 0xB4 */
		{ 0xC2, 0xB5, 0x00 },	/* 0xB5 */
		{ 0xC2, 0xB6, 0x00 },	/* 0xB6 */
		{ 0xC2, 0xB7, 0x00 },	/* 0xB7 */
		{ 0xC2, 0xB8, 0x00 },	/* 0xB8 */
		{ 0xC2, 0xB9, 0x00 },	/* 0xB9 */
		{ 0xC3, 0xB7, 0x00 },	/* 0xBA */
		{ 0xC2, 0xBB, 0x00 },	/* 0xBB */
		{ 0xC2, 0xBC, 0x00 },	/* 0xBC */
		{ 0xC2, 0xBD, 0x00 },	/* 0xBD */
		{ 0xC2, 0xBE, 0x00 },	/* 0xBE */
		{ 0xC2, 0xBF, 0x00 },	/* 0xBF */
		{ 0xD6, 0xB0, 0x00 },	/* 0xC0 */
		{ 0xD6, 0xB1, 0x00 },	/* 0xC1 */
		{ 0xD6, 0xB2, 0x00 },	/* 0xC2 */
		{ 0xD6, 0xB3, 0x00 },	/* 0xC3 */
		{ 0xD6, 0xB4, 0x00 },	/* 0xC4 */
		{ 0xD6, 0xB5, 0x00 },	/* 0xC5 */
		{ 0xD6, 0xB6, 0x00 },	/* 0xC6 */
		{ 0xD6, 0xB7, 0x00 },	/* 0xC7 */
		{ 0xD6, 0xB8, 0x00 },	/* 0xC8 */
		{ 0xD6, 0xB9, 0x00 },	/* 0xC9 */
		{ 0xFE, 0xFE, 0xFE },	/* 0xCA (illegal character) */
		{ 0xD6, 0xBB, 0x00 },	/* 0xCB */
		{ 0xD6, 0xBC, 0x00 },	/* 0xCC */
		{ 0xD6, 0xBD, 0x00 },	/* 0xCD */
		{ 0xD6, 0xBE, 0x00 },	/* 0xCE */
		{ 0xD6, 0xBF, 0x00 },	/* 0xCF */
		{ 0xD7, 0x80, 0x00 },	/* 0xD0 */
		{ 0xD7, 0x81, 0x00 },	/* 0xD1 */
		{ 0xD7, 0x82, 0x00 },	/* 0xD2 */
		{ 0xD7, 0x83, 0x00 },	/* 0xD3 */
		{ 0xD7, 0xB0, 0x00 },	/* 0xD4 */
		{ 0xD7, 0xB1, 0x00 },	/* 0xD5 */
		{ 0xD7, 0xB2, 0x00 },	/* 0xD6 */
		{ 0xD7, 0xB3, 0x00 },	/* 0xD7 */
		{ 0xD7, 0xB4, 0x00 },	/* 0xD8 */
		{ 0xFE, 0xFE, 0xFE },	/* 0xD9 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xDA (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xDB (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xDC (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xDD (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xDE (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xDF (illegal character) */
		{ 0xD7, 0x90, 0x00 },	/* 0xE0 */
		{ 0xD7, 0x91, 0x00 },	/* 0xE1 */
		{ 0xD7, 0x92, 0x00 },	/* 0xE2 */
		{ 0xD7, 0x93, 0x00 },	/* 0xE3 */
		{ 0xD7, 0x94, 0x00 },	/* 0xE4 */
		{ 0xD7, 0x95, 0x00 },	/* 0xE5 */
		{ 0xD7, 0x96, 0x00 },	/* 0xE6 */
		{ 0xD7, 0x97, 0x00 },	/* 0xE7 */
		{ 0xD7, 0x98, 0x00 },	/* 0xE8 */
		{ 0xD7, 0x99, 0x00 },	/* 0xE9 */
		{ 0xD7, 0x9A, 0x00 },	/* 0xEA */
		{ 0xD7, 0x9B, 0x00 },	/* 0xEB */
		{ 0xD7, 0x9C, 0x00 },	/* 0xEC */
		{ 0xD7, 0x9D, 0x00 },	/* 0xED */
		{ 0xD7, 0x9E, 0x00 },	/* 0xEE */
		{ 0xD7, 0x9F, 0x00 },	/* 0xEF */
		{ 0xD7, 0xA0, 0x00 },	/* 0xF0 */
		{ 0xD7, 0xA1, 0x00 },	/* 0xF1 */
		{ 0xD7, 0xA2, 0x00 },	/* 0xF2 */
		{ 0xD7, 0xA3, 0x00 },	/* 0xF3 */
		{ 0xD7, 0xA4, 0x00 },	/* 0xF4 */
		{ 0xD7, 0xA5, 0x00 },	/* 0xF5 */
		{ 0xD7, 0xA6, 0x00 },	/* 0xF6 */
		{ 0xD7, 0xA7, 0x00 },	/* 0xF7 */
		{ 0xD7, 0xA8, 0x00 },	/* 0xF8 */
		{ 0xD7, 0xA9, 0x00 },	/* 0xF9 */
		{ 0xD7, 0xAA, 0x00 },	/* 0xFA */
		{ 0xFE, 0xFE, 0xFE },	/* 0xFB (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xFC (illegal character) */
		{ 0xE2, 0x80, 0x8E },	/* 0xFD */
		{ 0xE2, 0x80, 0x8F },	/* 0xFE */
		{ 0xFE, 0xFE, 0xFE },	/* 0xFF (illegal character) */
	},
	{	/* CP1256 -> UTF-8 */
		{ 0xE2, 0x82, 0xAC },	/* 0x80 */
		{ 0xD9, 0xBE, 0x00 },	/* 0x81 */
		{ 0xE2, 0x80, 0x9A },	/* 0x82 */
		{ 0xC6, 0x92, 0x00 },	/* 0x83 */
		{ 0xE2, 0x80, 0x9E },	/* 0x84 */
		{ 0xE2, 0x80, 0xA6 },	/* 0x85 */
		{ 0xE2, 0x80, 0xA0 },	/* 0x86 */
		{ 0xE2, 0x80, 0xA1 },	/* 0x87 */
		{ 0xCB, 0x86, 0x00 },	/* 0x88 */
		{ 0xE2, 0x80, 0xB0 },	/* 0x89 */
		{ 0xD9, 0xB9, 0x00 },	/* 0x8A */
		{ 0xE2, 0x80, 0xB9 },	/* 0x8B */
		{ 0xC5, 0x92, 0x00 },	/* 0x8C */
		{ 0xDA, 0x86, 0x00 },	/* 0x8D */
		{ 0xDA, 0x98, 0x00 },	/* 0x8E */
		{ 0xDA, 0x88, 0x00 },	/* 0x8F */
		{ 0xDA, 0xAF, 0x00 },	/* 0x90 */
		{ 0xE2, 0x80, 0x98 },	/* 0x91 */
		{ 0xE2, 0x80, 0x99 },	/* 0x92 */
		{ 0xE2, 0x80, 0x9C },	/* 0x93 */
		{ 0xE2, 0x80, 0x9D },	/* 0x94 */
		{ 0xE2, 0x80, 0xA2 },	/* 0x95 */
		{ 0xE2, 0x80, 0x93 },	/* 0x96 */
		{ 0xE2, 0x80, 0x94 },	/* 0x97 */
		{ 0xDA, 0xA9, 0x00 },	/* 0x98 */
		{ 0xE2, 0x84, 0xA2 },	/* 0x99 */
		{ 0xDA, 0x91, 0x00 },	/* 0x9A */
		{ 0xE2, 0x80, 0xBA },	/* 0x9B */
		{ 0xC5, 0x93, 0x00 },	/* 0x9C */
		{ 0xE2, 0x80, 0x8C },	/* 0x9D */
		{ 0xE2, 0x80, 0x8D },	/* 0x9E */
		{ 0xDA, 0xBA, 0x00 },	/* 0x9F */
		{ 0xC2, 0xA0, 0x00 },	/* 0xA0 */
		{ 0xD8, 0x8C, 0x00 },	/* 0xA1 */
		{ 0xC2, 0xA2, 0x00 },	/* 0xA2 */
		{ 0xC2, 0xA3, 0x00 },	/* 0xA3 */
		{ 0xC2, 0xA4, 0x00 },	/* 0xA4 */
		{ 0xC2, 0xA5, 0x00 },	/* 0xA5 */
		{ 0xC2, 0xA6, 0x00 },	/* 0xA6 */
		{ 0xC2, 0xA7, 0x00 },	/* 0xA7 */
		{ 0xC2, 0xA8, 0x00 },	/* 0xA8 */
		{ 0xC2, 0xA9, 0x00 },	/* 0xA9 */
		{ 0xDA, 0xBE, 0x00 },	/* 0xAA */
		{ 0xC2, 0xAB, 0x00 },	/* 0xAB */
		{ 0xC2, 0xAC, 0x00 },	/* 0xAC */
		{ 0xC2, 0xAD, 0x00 },	/* 0xAD */
		{ 0xC2, 0xAE, 0x00 },	/* 0xAE */
		{ 0xC2, 0xAF, 0x00 },	/* 0xAF */
		{ 0xC2, 0xB0, 0x00 },	/* 0xB0 */
		{ 0xC2, 0xB1, 0x00 },	/* 0xB1 */
		{ 0xC2, 0xB2, 0x00 },	/* 0xB2 */
		{ 0xC2, 0xB3, 0x00 },	/* 0xB3 */
		{ 0xC2, 0xB4, 0x00 },	/* 0xB4 */
		{ 0xC2, 0xB5, 0x00 },	/* 0xB5 */
		{ 0xC2, 0xB6, 0x00 },	/* 0xB6 */
		{ 0xC2, 0xB7, 0x00 },	/* 0xB7 */
		{ 0xC2, 0xB8, 0x00 },	/* 0xB8 */
		{ 0xC2, 0xB9, 0x00 },	/* 0xB9 */
		{ 0xD8, 0x9B, 0x00 },	/* 0xBA */
		{ 0xC2, 0xBB, 0x00 },	/* 0xBB */
		{ 0xC2, 0xBC, 0x00 },	/* 0xBC */
		{ 0xC2, 0xBD, 0x00 },	/* 0xBD */
		{ 0xC2, 0xBE, 0x00 },	/* 0xBE */
		{ 0xD8, 0x9F, 0x00 },	/* 0xBF */
		{ 0xDB, 0x81, 0x00 },	/* 0xC0 */
		{ 0xD8, 0xA1, 0x00 },	/* 0xC1 */
		{ 0xD8, 0xA2, 0x00 },	/* 0xC2 */
		{ 0xD8, 0xA3, 0x00 },	/* 0xC3 */
		{ 0xD8, 0xA4, 0x00 },	/* 0xC4 */
		{ 0xD8, 0xA5, 0x00 },	/* 0xC5 */
		{ 0xD8, 0xA6, 0x00 },	/* 0xC6 */
		{ 0xD8, 0xA7, 0x00 },	/* 0xC7 */
		{ 0xD8, 0xA8, 0x00 },	/* 0xC8 */
		{ 0xD8, 0xA9, 0x00 },	/* 0xC9 */
		{ 0xD8, 0xAA, 0x00 },	/* 0xCA */
		{ 0xD8, 0xAB, 0x00 },	/* 0xCB */
		{ 0xD8, 0xAC, 0x00 },	/* 0xCC */
		{ 0xD8, 0xAD, 0x00 },	/* 0xCD */
		{ 0xD8, 0xAE, 0x00 },	/* 0xCE */
		{ 0xD8, 0xAF, 0x00 },	/* 0xCF */
		{ 0xD8, 0xB0, 0x00 },	/* 0xD0 */
		{ 0xD8, 0xB1, 0x00 },	/* 0xD1 */
		{ 0xD8, 0xB2, 0x00 },	/* 0xD2 */
		{ 0xD8, 0xB3, 0x00 },	/* 0xD3 */
		{ 0xD8, 0xB4, 0x00 },	/* 0xD4 */
		{ 0xD8, 0xB5, 0x00 },	/* 0xD5 */
		{ 0xD8, 0xB6, 0x00 },	/* 0xD6 */
		{ 0xC3, 0x97, 0x00 },	/* 0xD7 */
		{ 0xD8, 0xB7, 0x00 },	/* 0xD8 */
		{ 0xD8, 0xB8, 0x00 },	/* 0xD9 */
		{ 0xD8, 0xB9, 0x00 },	/* 0xDA */
		{ 0xD8, 0xBA, 0x00 },	/* 0xDB */
		{ 0xD9, 0x80, 0x00 },	/* 0xDC */
		{ 0xD9, 0x81, 0x00 },	/* 0xDD */
		{ 0xD9, 0x82, 0x00 },	/* 0xDE */
		{ 0xD9, 0x83, 0x00 },	/* 0xDF */
		{ 0xC3, 0xA0, 0x00 },	/* 0xE0 */
		{ 0xD9, 0x84, 0x00 },	/* 0xE1 */
		{ 0xC3, 0xA2, 0x00 },	/* 0xE2 */
		{ 0xD9, 0x85, 0x00 },	/* 0xE3 */
		{ 0xD9, 0x86, 0x00 },	/* 0xE4 */
		{ 0xD9, 0x87, 0x00 },	/* 0xE5 */
		{ 0xD9, 0x88, 0x00 },	/* 0xE6 */
		{ 0xC3, 0xA7, 0x00 },	/* 0xE7 */
		{ 0xC3, 0xA8, 0x00 },	/* 0xE8 */
		{ 0xC3, 0xA9, 0x00 },	/* 0xE9 */
		{ 0xC3, 0xAA, 0x00 },	/* 0xEA */
		{ 0xC3, 0xAB, 0x00 },	/* 0xEB */
		{ 0xD9, 0x89, 0x00 },	/* 0xEC */
		{ 0xD9, 0x8A, 0x00 },	/* 0xED */
		{ 0xC3, 0xAE, 0x00 },	/* 0xEE */
		{ 0xC3, 0xAF, 0x00 },	/* 0xEF */
		{ 0xD9, 0x8B, 0x00 },	/* 0xF0 */
		{ 0xD9, 0x8C, 0x00 },	/* 0xF1 */
		{ 0xD9, 0x8D, 0x00 },	/* 0xF2 */
		{ 0xD9, 0x8E, 0x00 },	/* 0xF3 */
		{ 0xC3, 0xB4, 0x00 },	/* 0xF4 */
		{ 0xD9, 0x8F, 0x00 },	/* 0xF5 */
		{ 0xD9, 0x90, 0x00 },	/* 0xF6 */
		{ 0xC3, 0xB7, 0x00 },	/* 0xF7 */
		{ 0xD9, 0x91, 0x00 },	/* 0xF8 */
		{ 0xC3, 0xB9, 0x00 },	/* 0xF9 */
		{ 0xD9, 0x92, 0x00 },	/* 0xFA */
		{ 0xC3, 0xBB, 0x00 },	/* 0xFB */
		{ 0xC3, 0xBC, 0x00 },	/* 0xFC */
		{ 0xE2, 0x80, 0x8E },	/* 0xFD */
		{ 0xE2, 0x80, 0x8F },	/* 0xFE */
		{ 0xDB, 0x92, 0x00 },	/* 0xFF */
	},
	{	/* CP1257 -> UTF-8 */
		{ 0xE2, 0x82, 0xAC },	/* 0x80 */
		{ 0xFE, 0xFE, 0xFE },	/* 0x81 (illegal character) */
		{ 0xE2, 0x80, 0x9A },	/* 0x82 */
		{ 0xFE, 0xFE, 0xFE },	/* 0x83 (illegal character) */
		{ 0xE2, 0x80, 0x9E },	/* 0x84 */
		{ 0xE2, 0x80, 0xA6 },	/* 0x85 */
		{ 0xE2, 0x80, 0xA0 },	/* 0x86 */
		{ 0xE2, 0x80, 0xA1 },	/* 0x87 */
		{ 0xFE, 0xFE, 0xFE },	/* 0x88 (illegal character) */
		{ 0xE2, 0x80, 0xB0 },	/* 0x89 */
		{ 0xFE, 0xFE, 0xFE },	/* 0x8A (illegal character) */
		{ 0xE2, 0x80, 0xB9 },	/* 0x8B */
		{ 0xFE, 0xFE, 0xFE },	/* 0x8C (illegal character) */
		{ 0xC2, 0xA8, 0x00 },	/* 0x8D */
		{ 0xCB, 0x87, 0x00 },	/* 0x8E */
		{ 0xC2, 0xB8, 0x00 },	/* 0x8F */
		{ 0xFE, 0xFE, 0xFE },	/* 0x90 (illegal character) */
		{ 0xE2, 0x80, 0x98 },	/* 0x91 */
		{ 0xE2, 0x80, 0x99 },	/* 0x92 */
		{ 0xE2, 0x80, 0x9C },	/* 0x93 */
		{ 0xE2, 0x80, 0x9D },	/* 0x94 */
		{ 0xE2, 0x80, 0xA2 },	/* 0x95 */
		{ 0xE2, 0x80, 0x93 },	/* 0x96 */
		{ 0xE2, 0x80, 0x94 },	/* 0x97 */
		{ 0xFE, 0xFE, 0xFE },	/* 0x98 (illegal character) */
		{ 0xE2, 0x84, 0xA2 },	/* 0x99 */
		{ 0xFE, 0xFE, 0xFE },	/* 0x9A (illegal character) */
		{ 0xE2, 0x80, 0xBA },	/* 0x9B */
		{ 0xFE, 0xFE, 0xFE },	/* 0x9C (illegal character) */
		{ 0xC2, 0xAF, 0x00 },	/* 0x9D */
		{ 0xCB, 0x9B, 0x00 },	/* 0x9E */
		{ 0xFE, 0xFE, 0xFE },	/* 0x9F (illegal character) */
		{ 0xC2, 0xA0, 0x00 },	/* 0xA0 */
		{ 0xFE, 0xFE, 0xFE },	/* 0xA1 (illegal character) */
		{ 0xC2, 0xA2, 0x00 },	/* 0xA2 */
		{ 0xC2, 0xA3, 0x00 },	/* 0xA3 */
		{ 0xC2, 0xA4, 0x00 },	/* 0xA4 */
		{ 0xFE, 0xFE, 0xFE },	/* 0xA5 (illegal character) */
		{ 0xC2, 0xA6, 0x00 },	/* 0xA6 */
		{ 0xC2, 0xA7, 0x00 },	/* 0xA7 */
		{ 0xC3, 0x98, 0x00 },	/* 0xA8 */
		{ 0xC2, 0xA9, 0x00 },	/* 0xA9 */
		{ 0xC5, 0x96, 0x00 },	/* 0xAA */
		{ 0xC2, 0xAB, 0x00 },	/* 0xAB */
		{ 0xC2, 0xAC, 0x00 },	/* 0xAC */
		{ 0xC2, 0xAD, 0x00 },	/* 0xAD */
		{ 0xC2, 0xAE, 0x00 },	/* 0xAE */
		{ 0xC3, 0x86, 0x00 },	/* 0xAF */
		{ 0xC2, 0xB0, 0x00 },	/* 0xB0 */
		{ 0xC2, 0xB1, 0x00 },	/* 0xB1 */
		{ 0xC2, 0xB2, 0x00 },	/* 0xB2 */
		{ 0xC2, 0xB3, 0x00 },	/* 0xB3 */
		{ 0xC2, 0xB4, 0x00 },	/* 0xB4 */
		{ 0xC2, 0xB5, 0x00 },	/* 0xB5 */
		{ 0xC2, 0xB6, 0x00 },	/* 0xB6 */
		{ 0xC2, 0xB7, 0x00 },	/* 0xB7 */
		{ 0xC3, 0xB8, 0x00 },	/* 0xB8 */
		{ 0xC2, 0xB9, 0x00 },	/* 0xB9 */
		{ 0xC5, 0x97, 0x00 },	/* 0xBA */
		{ 0xC2, 0xBB, 0x00 },	/* 0xBB */
		{ 0xC2, 0xBC, 0x00 },	/* 0xBC */
		{ 0xC2, 0xBD, 0x00 },	/* 0xBD */
		{ 0xC2, 0xBE, 0x00 },	/* 0xBE */
		{ 0xC3, 0xA6, 0x00 },	/* 0xBF */
		{ 0xC4, 0x84, 0x00 },	/* 0xC0 */
		{ 0xC4, 0xAE, 0x00 },	/* 0xC1 */
		{ 0xC4, 0x80, 0x00 },	/* 0xC2 */
		{ 0xC4, 0x86, 0x00 },	/* 0xC3 */
		{ 0xC3, 0x84, 0x00 },	/* 0xC4 */
		{ 0xC3, 0x85, 0x00 },	/* 0xC5 */
		{ 0xC4, 0x98, 0x00 },	/* 0xC6 */
		{ 0xC4, 0x92, 0x00 },	/* 0xC7 */
		{ 0xC4, 0x8C, 0x00 },	/* 0xC8 */
		{ 0xC3, 0x89, 0x00 },	/* 0xC9 */
		{ 0xC5, 0xB9, 0x00 },	/* 0xCA */
		{ 0xC4, 0x96, 0x00 },	/* 0xCB */
		{ 0xC4, 0xA2, 0x00 },	/* 0xCC */
		{ 0xC4, 0xB6, 0x00 },	/* 0xCD */
		{ 0xC4, 0xAA, 0x00 },	/* 0xCE */
		{ 0xC4, 0xBB, 0x00 },	/* 0xCF */
		{ 0xC5, 0xA0, 0x00 },	/* 0xD0 */
		{ 0xC5, 0x83, 0x00 },	/* 0xD1 */
		{ 0xC5, 0x85, 0x00 },	/* 0xD2 */
		{ 0xC3, 0x93, 0x00 },	/* 0xD3 */
		{ 0xC5, 0x8C, 0x00 },	/* 0xD4 */
		{ 0xC3, 0x95, 0x00 },	/* 0xD5 */
		{ 0xC3, 0x96, 0x00 },	/* 0xD6 */
		{ 0xC3, 0x97, 0x00 },	/* 0xD7 */
		{ 0xC5, 0xB2, 0x00 },	/* 0xD8 */
		{ 0xC5, 0x81, 0x00 },	/* 0xD9 */
		{ 0xC5, 0x9A, 0x00 },	/* 0xDA */
		{ 0xC5, 0xAA, 0x00 },	/* 0xDB */
		{ 0xC3, 0x9C, 0x00 },	/* 0xDC */
		{ 0xC5, 0xBB, 0x00 },	/* 0xDD */
		{ 0xC5, 0xBD, 0x00 },	/* 0xDE */
		{ 0xC3, 0x9F, 0x00 },	/* 0xDF */
		{ 0xC4, 0x85, 0x00 },	/* 0xE0 */
		{ 0xC4, 0xAF, 0x00 },	/* 0xE1 */
		{ 0xC4, 0x81, 0x00 },	/* 0xE2 */
		{ 0xC4, 0x87, 0x00 },	/* 0xE3 */
		{ 0xC3, 0xA4, 0x00 },	/* 0xE4 */
		{ 0xC3, 0xA5, 0x00 },	/* 0xE5 */
		{ 0xC4, 0x99, 0x00 },	/* 0xE6 */
		{ 0xC4, 0x93, 0x00 },	/* 0xE7 */
		{ 0xC4, 0x8D, 0x00 },	/* 0xE8 */
		{ 0xC3, 0xA9, 0x00 },	/* 0xE9 */
		{ 0xC5, 0xBA, 0x00 },	/* 0xEA */
		{ 0xC4, 0x97, 0x00 },	/* 0xEB */
		{ 0xC4, 0xA3, 0x00 },	/* 0xEC */
		{ 0xC4, 0xB7, 0x00 },	/* 0xED */
		{ 0xC4, 0xAB, 0x00 },	/* 0xEE */
		{ 0xC4, 0xBC, 0x00 },	/* 0xEF */
		{ 0xC5, 0xA1, 0x00 },	/* 0xF0 */
		{ 0xC5, 0x84, 0x00 },	/* 0xF1 */
		{ 0xC5, 0x86, 0x00 },	/* 0xF2 */
		{ 0xC3, 0xB3, 0x00 },	/* 0xF3 */
		{ 0xC5, 0x8D, 0x00 },	/* 0xF4 */
		{ 0xC3, 0xB5, 0x00 },	/* 0xF5 */
		{ 0xC3, 0xB6, 0x00 },	/* 0xF6 */
		{ 0xC3, 0xB7, 0x00 },	/* 0xF7 */
		{ 0xC5, 0xB3, 0x00 },	/* 0xF8 */
		{ 0xC5, 0x82, 0x00 },	/* 0xF9 */
		{ 0xC5, 0x9B, 0x00 },	/* 0xFA */
		{ 0xC5, 0xAB, 0x00 },	/* 0xFB */
		{ 0xC3, 0xBC, 0x00 },	/* 0xFC */
		{ 0xC5, 0xBC, 0x00 },	/* 0xFD */
		{ 0xC5, 0xBE, 0x00 },	/* 0xFE */
		{ 0xCB, 0x99, 0x00 },	/* 0xFF */
	},
	{	/* ISO 8859-2 -> UTF-8 */
		{ 0xC2, 0x80, 0x00 },	/* 0x80 */
		{ 0xC2, 0x81, 0x00 },	/* 0x81 */
		{ 0xC2, 0x82, 0x00 },	/* 0x82 */
		{ 0xC2, 0x83, 0x00 },	/* 0x83 */
		{ 0xC2, 0x84, 0x00 },	/* 0x84 */
		{ 0xC2, 0x85, 0x00 },	/* 0x85 */
		{ 0xC2, 0x86, 0x00 },	/* 0x86 */
		{ 0xC2, 0x87, 0x00 },	/* 0x87 */
		{ 0xC2, 0x88, 0x00 },	/* 0x88 */
		{ 0xC2, 0x89, 0x00 },	/* 0x89 */
		{ 0xC2, 0x8A, 0x00 },	/* 0x8A */
		{ 0xC2, 0x8B, 0x00 },	/* 0x8B */
		{ 0xC2, 0x8C, 0x00 },	/* 0x8C */
		{ 0xC2, 0x8D, 0x00 },	/* 0x8D */
		{ 0xC2, 0x8E, 0x00 },	/* 0x8E */
		{ 0xC2, 0x8F, 0x00 },	/* 0x8F */
		{ 0xC2, 0x90, 0x00 },	/* 0x90 */
		{ 0xC2, 0x91, 0x00 },	/* 0x91 */
		{ 0xC2, 0x92, 0x00 },	/* 0x92 */
		{ 0xC2, 0x93, 0x00 },	/* 0x93 */
		{ 0xC2, 0x94, 0x00 },	/* 0x94 */
		{ 0xC2, 0x95, 0x00 },	/* 0x95 */
		{ 0xC2, 0x96, 0x00 },	/* 0x96 */
		{ 0xC2, 0x97, 0x00 },	/* 0x97 */
		{ 0xC2, 0x98, 0x00 },	/* 0x98 */
		{ 0xC2, 0x99, 0x00 },	/* 0x99 */
		{ 0xC2, 0x9A, 0x00 },	/* 0x9A */
		{ 0xC2, 0x9B, 0x00 },	/* 0x9B */
		{ 0xC2, 0x9C, 0x00 },	/* 0x9C */
		{ 0xC2, 0x9D, 0x00 },	/* 0x9D */
		{ 0xC2, 0x9E, 0x00 },	/* 0x9E */
		{ 0xC2, 0x9F, 0x00 },	/* 0x9F */
		{ 0xC2, 0xA0, 0x00 },	/* 0xA0 */
		{ 0xC4, 0x84, 0x00 },	/* 0xA1 */
		{ 0xCB, 0x98, 0x00 },	/* 0xA2 */
		{ 0xC5, 0x81, 0x00 },	/* 0xA3 */
		{ 0xC2, 0xA4, 0x00 },	/* 0xA4 */
		{ 0xC4, 0xBD, 0x00 },	/* 0xA5 */
		{ 0xC5, 0x9A, 0x00 },	/* 0xA6 */
		{ 0xC2, 0xA7, 0x00 },	/* 0xA7 */
		{ 0xC2, 0xA8, 0x00 },	/* 0xA8 */
		{ 0xC5, 0xA0, 0x00 },	/* 0xA9 */
		{ 0xC5, 0x9E, 0x00 },	/* 0xAA */
		{ 0xC5, 0xA4, 0x00 },	/* 0xAB */
		{ 0xC5, 0xB9, 0x00 },	/* 0xAC */
		{ 0xC2, 0xAD, 0x00 },	/* 0xAD */
		{ 0xC5, 0xBD, 0x00 },	/* 0xAE */
		{ 0xC5, 0xBB, 0x00 },	/* 0xAF */
		{ 0xC2, 0xB0, 0x00 },	/* 0xB0 */
		{ 0xC4, 0x85, 0x00 },	/* 0xB1 */
		{ 0xCB, 0x9B, 0x00 },	/* 0xB2 */
		{ 0xC5, 0x82, 0x00 },	/* 0xB3 */
		{ 0xC2, 0xB4, 0x00 },	/* 0xB4 */
		{ 0xC4, 0xBE, 0x00 },	/* 0xB5 */
		{ 0xC5, 0x9B, 0x00 },	/* 0xB6 */
		{ 0xCB, 0x87, 0x00 },	/* 0xB7 */
		{ 0xC2, 0xB8, 0x00 },	/* 0xB8 */
		{ 0xC5, 0xA1, 0x00 },	/* 0xB9 */
		{ 0xC5, 0x9F, 0x00 },	/* 0xBA */
		{ 0xC5, 0xA5, 0x00 },	/* 0xBB */
		{ 0xC5, 0xBA, 0x00 },	/* 0xBC */
		{ 0xCB, 0x9D, 0x00 },	/* 0xBD */
		{ 0xC5, 0xBE, 0x00 },	/* 0xBE */
		{ 0xC5, 0xBC, 0x00 },	/* 0xBF */
		{ 0xC5, 0x94, 0x00 },	/* 0xC0 */
		{ 0xC3, 0x81, 0x00 },	/* 0xC1 */
		{ 0xC3, 0x82, 0x00 },	/* 0xC2 */
		{ 0xC4, 0x82, 0x00 },	/* 0xC3 */
		{ 0xC3, 0x84, 0x00 },	/* 0xC4 */
		{ 0xC4, 0xB9, 0x00 },	/* 0xC5 */
		{ 0xC4, 0x86, 0x00 },	/* 0xC6 */
		{ 0xC3, 0x87, 0x00 },	/* 0xC7 */
		{ 0xC4, 0x8C, 0x00 },	/* 0xC8 */
		{ 0xC3, 0x89, 0x00 },	/* 0xC9 */
		{ 0xC4, 0x98, 0x00 },	/* 0xCA */
		{ 0xC3, 0x8B, 0x00 },	/* 0xCB */
		{ 0xC4, 0x9A, 0x00 },	/* 0xCC */
		{ 0xC3, 0x8D, 0x00 },	/* 0xCD */
		{ 0xC3, 0x8E, 0x00 },	/* 0xCE */
		{ 0xC4, 0x8E, 0x00 },	/* 0xCF */
		{ 0xC4, 0x90, 0x00 },	/* 0xD0 */
		{ 0xC5, 0x83, 0x00 },	/* 0xD1 */
		{ 0xC5, 0x87, 0x00 },	/* 0xD2 */
		{ 0xC3, 0x93, 0x00 },	/* 0xD3 */
		{ 0xC3, 0x94, 0x00 },	/* 0xD4 */
		{ 0xC5, 0x90, 0x00 },	/* 0xD5 */
		{ 0xC3, 0x96, 0x00 },	/* 0xD6 */
		{ 0xC3, 0x97, 0x00 },	/* 0xD7 */
		{ 0xC5, 0x98, 0x00 },	/* 0xD8 */
		{ 0xC5, 0xAE, 0x00 },	/* 0xD9 */
		{ 0xC3, 0x9A, 0x00 },	/* 0xDA */
		{ 0xC5, 0xB0, 0x00 },	/* 0xDB */
		{ 0xC3, 0x9C, 0x00 },	/* 0xDC */
		{ 0xC3, 0x9D, 0x00 },	/* 0xDD */
		{ 0xC5, 0xA2, 0x00 },	/* 0xDE */
		{ 0xC3, 0x9F, 0x00 },	/* 0xDF */
		{ 0xC5, 0x95, 0x00 },	/* 0xE0 */
		{ 0xC3, 0xA1, 0x00 },	/* 0xE1 */
		{ 0xC3, 0xA2, 0x00 },	/* 0xE2 */
		{ 0xC4, 0x83, 0x00 },	/* 0xE3 */
		{ 0xC3, 0xA4, 0x00 },	/* 0xE4 */
		{ 0xC4, 0xBA, 0x00 },	/* 0xE5 */
		{ 0xC4, 0x87, 0x00 },	/* 0xE6 */
		{ 0xC3, 0xA7, 0x00 },	/* 0xE7 */
		{ 0xC4, 0x8D, 0x00 },	/* 0xE8 */
		{ 0xC3, 0xA9, 0x00 },	/* 0xE9 */
		{ 0xC4, 0x99, 0x00 },	/* 0xEA */
		{ 0xC3, 0xAB, 0x00 },	/* 0xEB */
		{ 0xC4, 0x9B, 0x00 },	/* 0xEC */
		{ 0xC3, 0xAD, 0x00 },	/* 0xED */
		{ 0xC3, 0xAE, 0x00 },	/* 0xEE */
		{ 0xC4, 0x8F, 0x00 },	/* 0xEF */
		{ 0xC4, 0x91, 0x00 },	/* 0xF0 */
		{ 0xC5, 0x84, 0x00 },	/* 0xF1 */
		{ 0xC5, 0x88, 0x00 },	/* 0xF2 */
		{ 0xC3, 0xB3, 0x00 },	/* 0xF3 */
		{ 0xC3, 0xB4, 0x00 },	/* 0xF4 */
		{ 0xC5, 0x91, 0x00 },	/* 0xF5 */
		{ 0xC3, 0xB6, 0x00 },	/* 0xF6 */
		{ 0xC3, 0xB7, 0x00 },	/* 0xF7 */
		{ 0xC5, 0x99, 0x00 },	/* 0xF8 */
		{ 0xC5, 0xAF, 0x00 },	/* 0xF9 */
		{ 0xC3, 0xBA, 0x00 },	/* 0xFA */
		{ 0xC5, 0xB1, 0x00 },	/* 0xFB */
		{ 0xC3, 0xBC, 0x00 },	/* 0xFC */
		{ 0xC3, 0xBD, 0x00 },	/* 0xFD */
		{ 0xC5, 0xA3, 0x00 },	/* 0xFE */
		{ 0xCB, 0x99, 0x00 },	/* 0xFF */
	},
	{	/* ISO 8859-3 -> UTF-8 */
		{ 0xC2, 0x80, 0x00 },	/* 0x80 */
		{ 0xC2, 0x81, 0x00 },	/* 0x81 */
		{ 0xC2, 0x82, 0x00 },	/* 0x82 */
		{ 0xC2, 0x83, 0x00 },	/* 0x83 */
		{ 0xC2, 0x84, 0x00 },	/* 0x84 */
		{ 0xC2, 0x85, 0x00 },	/* 0x85 */
		{ 0xC2, 0x86, 0x00 },	/* 0x86 */
		{ 0xC2, 0x87, 0x00 },	/* 0x87 */
		{ 0xC2, 0x88, 0x00 },	/* 0x88 */
		{ 0xC2, 0x89, 0x00 },	/* 0x89 */
		{ 0xC2, 0x8A, 0x00 },	/* 0x8A */
		{ 0xC2, 0x8B, 0x00 },	/* 0x8B */
		{ 0xC2, 0x8C, 0x00 },	/* 0x8C */
		{ 0xC2, 0x8D, 0x00 },	/* 0x8D */
		{ 0xC2, 0x8E, 0x00 },	/* 0x8E */
		{ 0xC2, 0x8F, 0x00 },	/* 0x8F */
		{ 0xC2, 0x90, 0x00 },	/* 0x90 */
		{ 0xC2, 0x91, 0x00 },	/* 0x91 */
		{ 0xC2, 0x92, 0x00 },	/* 0x92 */
		{ 0xC2, 0x93, 0x00 },	/* 0x93 */
		{ 0xC2, 0x94, 0x00 },	/* 0x94 */
		{ 0xC2, 0x95, 0x00 },	/* 0x95 */
		{ 0xC2, 0x96, 0x00 },	/* 0x96 */
		{ 0xC2, 0x97, 0x00 },	/* 0x97 */
		{ 0xC2, 0x98, 0x00 },	/* 0x98 */
		{ 0xC2, 0x99, 0x00 },	/* 0x99 */
		{ 0xC2, 0x9A, 0x00 },	/* 0x9A */
		{ 0xC2, 0x9B, 0x00 },	/* 0x9B */
		{ 0xC2, 0x9C, 0x00 },	/* 0x9C */
		{ 0xC2, 0x9D, 0x00 },	/* 0x9D */
		{ 0xC2, 0x9E, 0x00 },	/* 0x9E */
		{ 0xC2, 0x9F, 0x00 },	/* 0x9F */
		{ 0xC2, 0xA0, 0x00 },	/* 0xA0 */
		{ 0xC4, 0xA6, 0x00 },	/* 0xA1 */
		{ 0xCB, 0x98, 0x00 },	/* 0xA2 */
		{ 0xC2, 0xA3, 0x00 },	/* 0xA3 */
		{ 0xC2, 0xA4, 0x00 },	/* 0xA4 */
		{ 0xFE, 0xFE, 0xFE },	/* 0xA5 (illegal character) */
		{ 0xC4, 0xA4, 0x00 },	/* 0xA6 */
		{ 0xC2, 0xA7, 0x00 },	/* 0xA7 */
		{ 0xC2, 0xA8, 0x00 },	/* 0xA8 */
		{ 0xC4, 0xB0, 0x00 },	/* 0xA9 */
		{ 0xC5, 0x9E, 0x00 },	/* 0xAA */
		{ 0xC4, 0x9E, 0x00 },	/* 0xAB */
		{ 0xC4, 0xB4, 0x00 },	/* 0xAC */
		{ 0xC2, 0xAD, 0x00 },	/* 0xAD */
		{ 0xFE, 0xFE, 0xFE },	/* 0xAE (illegal character) */
		{ 0xC5, 0xBB, 0x00 },	/* 0xAF */
		{ 0xC2, 0xB0, 0x00 },	/* 0xB0 */
		{ 0xC4, 0xA7, 0x00 },	/* 0xB1 */
		{ 0xC2, 0xB2, 0x00 },	/* 0xB2 */
		{ 0xC2, 0xB3, 0x00 },	/* 0xB3 */
		{ 0xC2, 0xB4, 0x00 },	/* 0xB4 */
		{ 0xC2, 0xB5, 0x00 },	/* 0xB5 */
		{ 0xC4, 0xA5, 0x00 },	/* 0xB6 */
		{ 0xC2, 0xB7, 0x00 },	/* 0xB7 */
		{ 0xC2, 0xB8, 0x00 },	/* 0xB8 */
		{ 0xC4, 0xB1, 0x00 },	/* 0xB9 */
		{ 0xC5, 0x9F, 0x00 },	/* 0xBA */
		{ 0xC4, 0x9F, 0x00 },	/* 0xBB */
		{ 0xC4, 0xB5, 0x00 },	/* 0xBC */
		{ 0xC2, 0xBD, 0x00 },	/* 0xBD */
		{ 0xFE, 0xFE, 0xFE },	/* 0xBE (illegal character) */
		{ 0xC5, 0xBC, 0x00 },	/* 0xBF */
		{ 0xC3, 0x80, 0x00 },	/* 0xC0 */
		{ 0xC3, 0x81, 0x00 },	/* 0xC1 */
		{ 0xC3, 0x82, 0x00 },	/* 0xC2 */
		{ 0xFE, 0xFE, 0xFE },	/* 0xC3 (illegal character) */
		{ 0xC3, 0x84, 0x00 },	/* 0xC4 */
		{ 0xC4, 0x8A, 0x00 },	/* 0xC5 */
		{ 0xC4, 0x88, 0x00 },	/* 0xC6 */
		{ 0xC3, 0x87, 0x00 },	/* 0xC7 */
		{ 0xC3, 0x88, 0x00 },	/* 0xC8 */
		{ 0xC3, 0x89, 0x00 },	/* 0xC9 */
		{ 0xC3, 0x8A, 0x00 },	/* 0xCA */
		{ 0xC3, 0x8B, 0x00 },	/* 0xCB */
		{ 0xC3, 0x8C, 0x00 },	/* 0xCC */
		{ 0xC3, 0x8D, 0x00 },	/* 0xCD */
		{ 0xC3, 0x8E, 0x00 },	/* 0xCE */
		{ 0xC3, 0x8F, 0x00 },	/* 0xCF */
		{ 0xFE, 0xFE, 0xFE },	/* 0xD0 (illegal character) */
		{ 0xC3, 0x91, 0x00 },	/* 0xD1 */
		{ 0xC3, 0x92, 0x00 },	/* 0xD2 */
		{ 0xC3, 0x93, 0x00 },	/* 0xD3 */
		{ 0xC3, 0x94, 0x00 },	/* 0xD4 */
		{ 0xC4, 0xA0, 0x00 },	/* 0xD5 */
		{ 0xC3, 0x96, 0x00 },	/* 0xD6 */
		{ 0xC3, 0x97, 0x00 },	/* 0xD7 */
		{ 0xC4, 0x9C, 0x00 },	/* 0xD8 */
		{ 0xC3, 0x99, 0x00 },	/* 0xD9 */
		{ 0xC3, 0x9A, 0x00 },	/* 0xDA */
		{ 0xC3, 0x9B, 0x00 },	/* 0xDB */
		{ 0xC3, 0x9C, 0x00 },	/* 0xDC */
		{ 0xC5, 0xAC, 0x00 },	/* 0xDD */
		{ 0xC5, 0x9C, 0x00 },	/* 0xDE */
		{ 0xC3, 0x9F, 0x00 },	/* 0xDF */
		{ 0xC3, 0xA0, 0x00 },	/* 0xE0 */
		{ 0xC3, 0xA1, 0x00 },	/* 0xE1 */
		{ 0xC3, 0xA2, 0x00 },	/* 0xE2 */
		{ 0xFE, 0xFE, 0xFE },	/* 0xE3 (illegal character) */
		{ 0xC3, 0xA4, 0x00 },	/* 0xE4 */
		{ 0xC4, 0x8B, 0x00 },	/* 0xE5 */
		{ 0xC4, 0x89, 0x00 },	/* 0xE6 */
		{ 0xC3, 0xA7, 0x00 },	/* 0xE7 */
		{ 0xC3, 0xA8, 0x00 },	/* 0xE8 */
		{ 0xC3, 0xA9, 0x00 },	/* 0xE9 */
		{ 0xC3, 0xAA, 0x00 },	/* 0xEA */
		{ 0xC3, 0xAB, 0x00 },	/* 0xEB */
		{ 0xC3, 0xAC, 0x00 },	/* 0xEC */
		{ 0xC3, 0xAD, 0x00 },	/* 0xED */
		{ 0xC3, 0xAE, 0x00 },	/* 0xEE */
		{ 0xC3, 0xAF, 0x00 },	/* 0xEF */
		{ 0xFE, 0xFE, 0xFE },	/* 0xF0 (illegal character) */
		{ 0xC3, 0xB1, 0x00 },	/* 0xF1 */
		{ 0xC3, 0xB2, 0x00 },	/* 0xF2 */
		{ 0xC3, 0xB3, 0x00 },	/* 0xF3 */
		{ 0xC3, 0xB4, 0x00 },	/* 0xF4 */
		{ 0xC4, 0xA1, 0x00 },	/* 0xF5 */
		{ 0xC3, 0xB6, 0x00 },	/* 0xF6 */
		{ 0xC3, 0xB7, 0x00 },	/* 0xF7 */
		{ 0xC4, 0x9D, 0x00 },	/* 0xF8 */
		{ 0xC3, 0xB9, 0x00 },	/* 0xF9 */
		{ 0xC3, 0xBA, 0x00 },	/* 0xFA */
		{ 0xC3, 0xBB, 0x00 },	/* 0xFB */
		{ 0xC3, 0xBC, 0x00 },	/* 0xFC */
		{ 0xC5, 0xAD, 0x00 },	/* 0xFD */
		{ 0xC5, 0x9D, 0x00 },	/* 0xFE */
		{ 0xCB, 0x99, 0x00 },	/* 0xFF */
	},
	{	/* ISO 8859-4 -> UTF-8 */
		{ 0xC2, 0x80, 0x00 },	/* 0x80 */
		{ 0xC2, 0x81, 0x00 },	/* 0x81 */
		{ 0xC2, 0x82, 0x00 },	/* 0x82 */
		{ 0xC2, 0x83, 0x00 },	/* 0x83 */
		{ 0xC2, 0x84, 0x00 },	/* 0x84 */
		{ 0xC2, 0x85, 0x00 },	/* 0x85 */
		{ 0xC2, 0x86, 0x00 },	/* 0x86 */
		{ 0xC2, 0x87, 0x00 },	/* 0x87 */
		{ 0xC2, 0x88, 0x00 },	/* 0x88 */
		{ 0xC2, 0x89, 0x00 },	/* 0x89 */
		{ 0xC2, 0x8A, 0x00 },	/* 0x8A */
		{ 0xC2, 0x8B, 0x00 },	/* 0x8B */
		{ 0xC2, 0x8C, 0x00 },	/* 0x8C */
		{ 0xC2, 0x8D, 0x00 },	/* 0x8D */
		{ 0xC2, 0x8E, 0x00 },	/* 0x8E */
		{ 0xC2, 0x8F, 0x00 },	/* 0x8F */
		{ 0xC2, 0x90, 0x00 },	/* 0x90 */
		{ 0xC2, 0x91, 0x00 },	/* 0x91 */
		{ 0xC2, 0x92, 0x00 },	/* 0x92 */
		{ 0xC2, 0x93, 0x00 },	/* 0x93 */
		{ 0xC2, 0x94, 0x00 },	/* 0x94 */
		{ 0xC2, 0x95, 0x00 },	/* 0x95 */
		{ 0xC2, 0x96, 0x00 },	/* 0x96 */
		{ 0xC2, 0x97, 0x00 },	/* 0x97 */
		{ 0xC2, 0x98, 0x00 },	/* 0x98 */
		{ 0xC2, 0x99, 0x00 },	/* 0x99 */
		{ 0xC2, 0x9A, 0x00 },	/* 0x9A */
		{ 0xC2, 0x9B, 0x00 },	/* 0x9B */
		{ 0xC2, 0x9C, 0x00 },	/* 0x9C */
		{ 0xC2, 0x9D, 0x00 },	/* 0x9D */
		{ 0xC2, 0x9E, 0x00 },	/* 0x9E */
		{ 0xC2, 0x9F, 0x00 },	/* 0x9F */
		{ 0xC2, 0xA0, 0x00 },	/* 0xA0 */
		{ 0xC4, 0x84, 0x00 },	/* 0xA1 */
		{ 0xC4, 0xB8, 0x00 },	/* 0xA2 */
		{ 0xC5, 0x96, 0x00 },	/* 0xA3 */
		{ 0xC2, 0xA4, 0x00 },	/* 0xA4 */
		{ 0xC4, 0xA8, 0x00 },	/* 0xA5 */
		{ 0xC4, 0xBB, 0x00 },	/* 0xA6 */
		{ 0xC2, 0xA7, 0x00 },	/* 0xA7 */
		{ 0xC2, 0xA8, 0x00 },	/* 0xA8 */
		{ 0xC5, 0xA0, 0x00 },	/* 0xA9 */
		{ 0xC4, 0x92, 0x00 },	/* 0xAA */
		{ 0xC4, 0xA2, 0x00 },	/* 0xAB */
		{ 0xC5, 0xA6, 0x00 },	/* 0xAC */
		{ 0xC2, 0xAD, 0x00 },	/* 0xAD */
		{ 0xC5, 0xBD, 0x00 },	/* 0xAE */
		{ 0xC2, 0xAF, 0x00 },	/* 0xAF */
		{ 0xC2, 0xB0, 0x00 },	/* 0xB0 */
		{ 0xC4, 0x85, 0x00 },	/* 0xB1 */
		{ 0xCB, 0x9B, 0x00 },	/* 0xB2 */
		{ 0xC5, 0x97, 0x00 },	/* 0xB3 */
		{ 0xC2, 0xB4, 0x00 },	/* 0xB4 */
		{ 0xC4, 0xA9, 0x00 },	/* 0xB5 */
		{ 0xC4, 0xBC, 0x00 },	/* 0xB6 */
		{ 0xCB, 0x87, 0x00 },	/* 0xB7 */
		{ 0xC2, 0xB8, 0x00 },	/* 0xB8 */
		{ 0xC5, 0xA1, 0x00 },	/* 0xB9 */
		{ 0xC4, 0x93, 0x00 },	/* 0xBA */
		{ 0xC4, 0xA3, 0x00 },	/* 0xBB */
		{ 0xC5, 0xA7, 0x00 },	/* 0xBC */
		{ 0xC5, 0x8A, 0x00 },	/* 0xBD */
		{ 0xC5, 0xBE, 0x00 },	/* 0xBE */
		{ 0xC5, 0x8B, 0x00 },	/* 0xBF */
		{ 0xC4, 0x80, 0x00 },	/* 0xC0 */
		{ 0xC3, 0x81, 0x00 },	/* 0xC1 */
		{ 0xC3, 0x82, 0x00 },	/* 0xC2 */
		{ 0xC3, 0x83, 0x00 },	/* 0xC3 */
		{ 0xC3, 0x84, 0x00 },	/* 0xC4 */
		{ 0xC3, 0x85, 0x00 },	/* 0xC5 */
		{ 0xC3, 0x86, 0x00 },	/* 0xC6 */
		{ 0xC4, 0xAE, 0x00 },	/* 0xC7 */
		{ 0xC4, 0x8C, 0x00 },	/* 0xC8 */
		{ 0xC3, 0x89, 0x00 },	/* 0xC9 */
		{ 0xC4, 0x98, 0x00 },	/* 0xCA */
		{ 0xC3, 0x8B, 0x00 },	/* 0xCB */
		{ 0xC4, 0x96, 0x00 },	/* 0xCC */
		{ 0xC3, 0x8D, 0x00 },	/* 0xCD */
		{ 0xC3, 0x8E, 0x00 },	/* 0xCE */
		{ 0xC4, 0xAA, 0x00 },	/* 0xCF */
		{ 0xC4, 0x90, 0x00 },	/* 0xD0 */
		{ 0xC5, 0x85, 0x00 },	/* 0xD1 */
		{ 0xC5, 0x8C, 0x00 },	/* 0xD2 */
		{ 0xC4, 0xB6, 0x00 },	/* 0xD3 */
		{ 0xC3, 0x94, 0x00 },	/* 0xD4 */
		{ 0xC3, 0x95, 0x00 },	/* 0xD5 */
		{ 0xC3, 0x96, 0x00 },	/* 0xD6 */
		{ 0xC3, 0x97, 0x00 },	/* 0xD7 */
		{ 0xC3, 0x98, 0x00 },	/* 0xD8 */
		{ 0xC5, 0xB2, 0x00 },	/* 0xD9 */
		{ 0xC3, 0x9A, 0x00 },	/* 0xDA */
		{ 0xC3, 0x9B, 0x00 },	/* 0xDB */
		{ 0xC3, 0x9C, 0x00 },	/* 0xDC */
		{ 0xC5, 0xA8, 0x00 },	/* 0xDD */
		{ 0xC5, 0xAA, 0x00 },	/* 0xDE */
		{ 0xC3, 0x9F, 0x00 },	/* 0xDF */
		{ 0xC4, 0x81, 0x00 },	/* 0xE0 */
		{ 0xC3, 0xA1, 0x00 },	/* 0xE1 */
		{ 0xC3, 0xA2, 0x00 },	/* 0xE2 */
		{ 0xC3, 0xA3, 0x00 },	/* 0xE3 */
		{ 0xC3, 0xA4, 0x00 },	/* 0xE4 */
		{ 0xC3, 0xA5, 0x00 },	/* 0xE5 */
		{ 0xC3, 0xA6, 0x00 },	/* 0xE6 */
		{ 0xC4, 0xAF, 0x00 },	/* 0xE7 */
		{ 0xC4, 0x8D, 0x00 },	/* 0xE8 */
		{ 0xC3, 0xA9, 0x00 },	/* 0xE9 */
		{ 0xC4, 0x99, 0x00 },	/* 0xEA */
		{ 0xC3, 0xAB, 0x00 },	/* 0xEB */
		{ 0xC4, 0x97, 0x00 },	/* 0xEC */
		{ 0xC3, 0xAD, 0x00 },	/* 0xED */
		{ 0xC3, 0xAE, 0x00 },	/* 0xEE */
		{ 0xC4, 0xAB, 0x00 },	/* 0xEF */
		{ 0xC4, 0x91, 0x00 },	/* 0xF0 */
		{ 0xC5, 0x86, 0x00 },	/* 0xF1 */
		{ 0xC5, 0x8D, 0x00 },	/* 0xF2 */
		{ 0xC4, 0xB7, 0x00 },	/* 0xF3 */
		{ 0xC3, 0xB4, 0x00 },	/* 0xF4 */
		{ 0xC3, 0xB5, 0x00 },	/* 0xF5 */
		{ 0xC3, 0xB6, 0x00 },	/* 0xF6 */
		{ 0xC3, 0xB7, 0x00 },	/* 0xF7 */
		{ 0xC3, 0xB8, 0x00 },	/* 0xF8 */
		{ 0xC5, 0xB3, 0x00 },	/* 0xF9 */
		{ 0xC3, 0xBA, 0x00 },	/* 0xFA */
		{ 0xC3, 0xBB, 0x00 },	/* 0xFB */
		{ 0xC3, 0xBC, 0x00 },	/* 0xFC */
		{ 0xC5, 0xA9, 0x00 },	/* 0xFD */
		{ 0xC5, 0xAB, 0x00 },	/* 0xFE */
		{ 0xCB, 0x99, 0x00 },	/* 0xFF */
	},
	{	/* ISO 8859-5 -> UTF-8 */
		{ 0xC2, 0x80, 0x00 },	/* 0x80 */
		{ 0xC2, 0x81, 0x00 },	/* 0x81 */
		{ 0xC2, 0x82, 0x00 },	/* 0x82 */
		{ 0xC2, 0x83, 0x00 },	/* 0x83 */
		{ 0xC2, 0x84, 0x00 },	/* 0x84 */
		{ 0xC2, 0x85, 0x00 },	/* 0x85 */
		{ 0xC2, 0x86, 0x00 },	/* 0x86 */
		{ 0xC2, 0x87, 0x00 },	/* 0x87 */
		{ 0xC2, 0x88, 0x00 },	/* 0x88 */
		{ 0xC2, 0x89, 0x00 },	/* 0x89 */
		{ 0xC2, 0x8A, 0x00 },	/* 0x8A */
		{ 0xC2, 0x8B, 0x00 },	/* 0x8B */
		{ 0xC2, 0x8C, 0x00 },	/* 0x8C */
		{ 0xC2, 0x8D, 0x00 },	/* 0x8D */
		{ 0xC2, 0x8E, 0x00 },	/* 0x8E */
		{ 0xC2, 0x8F, 0x00 },	/* 0x8F */
		{ 0xC2, 0x90, 0x00 },	/* 0x90 */
		{ 0xC2, 0x91, 0x00 },	/* 0x91 */
		{ 0xC2, 0x92, 0x00 },	/* 0x92 */
		{ 0xC2, 0x93, 0x00 },	/* 0x93 */
		{ 0xC2, 0x94, 0x00 },	/* 0x94 */
		{ 0xC2, 0x95, 0x00 },	/* 0x95 */
		{ 0xC2, 0x96, 0x00 },	/* 0x96 */
		{ 0xC2, 0x97, 0x00 },	/* 0x97 */
		{ 0xC2, 0x98, 0x00 },	/* 0x98 */
		{ 0xC2, 0x99, 0x00 },	/* 0x99 */
		{ 0xC2, 0x9A, 0x00 },	/* 0x9A */
		{ 0xC2, 0x9B, 0x00 },	/* 0x9B */
		{ 0xC2, 0x9C, 0x00 },	/* 0x9C */
		{ 0xC2, 0x9D, 0x00 },	/* 0x9D */
		{ 0xC2, 0x9E, 0x00 },	/* 0x9E */
		{ 0xC2, 0x9F, 0x00 },	/* 0x9F */
		{ 0xC2, 0xA0, 0x00 },	/* 0xA0 */
		{ 0xD0, 0x81, 0x00 },	/* 0xA1 */
		{ 0xD0, 0x82, 0x00 },	/* 0xA2 */
		{ 0xD0, 0x83, 0x00 },	/* 0xA3 */
		{ 0xD0, 0x84, 0x00 },	/* 0xA4 */
		{ 0xD0, 0x85, 0x00 },	/* 0xA5 */
		{ 0xD0, 0x86, 0x00 },	/* 0xA6 */
		{ 0xD0, 0x87, 0x00 },	/* 0xA7 */
		{ 0xD0, 0x88, 0x00 },	/* 0xA8 */
		{ 0xD0, 0x89, 0x00 },	/* 0xA9 */
		{ 0xD0, 0x8A, 0x00 },	/* 0xAA */
		{ 0xD0, 0x8B, 0x00 },	/* 0xAB */
		{ 0xD0, 0x8C, 0x00 },	/* 0xAC */
		{ 0xC2, 0xAD, 0x00 },	/* 0xAD */
		{ 0xD0, 0x8E, 0x00 },	/* 0xAE */
		{ 0xD0, 0x8F, 0x00 },	/* 0xAF */
		{ 0xD0, 0x90, 0x00 },	/* 0xB0 */
		{ 0xD0, 0x91, 0x00 },	/* 0xB1 */
		{ 0xD0, 0x92, 0x00 },	/* 0xB2 */
		{ 0xD0, 0x93, 0x00 },	/* 0xB3 */
		{ 0xD0, 0x94, 0x00 },	/* 0xB4 */
		{ 0xD0, 0x95, 0x00 },	/* 0xB5 */
		{ 0xD0, 0x96, 0x00 },	/* 0xB6 */
		{ 0xD0, 0x97, 0x00 },	/* 0xB7 */
		{ 0xD0, 0x98, 0x00 },	/* 0xB8 */
		{ 0xD0, 0x99, 0x00 },	/* 0xB9 */
		{ 0xD0, 0x9A, 0x00 },	/* 0xBA */
		{ 0xD0, 0x9B, 0x00 },	/* 0xBB */
		{ 0xD0, 0x9C, 0x00 },	/* 0xBC */
		{ 0xD0, 0x9D, 0x00 },	/* 0xBD */
		{ 0xD0, 0x9E, 0x00 },	/* 0xBE */
		{ 0xD0, 0x9F, 0x00 },	/* 0xBF */
		{ 0xD0, 0xA0, 0x00 },	/* 0xC0 */
		{ 0xD0, 0xA1, 0x00 },	/* 0xC1 */
		{ 0xD0, 0xA2, 0x00 },	/* 0xC2 */
		{ 0xD0, 0xA3, 0x00 },	/* 0xC3 */
		{ 0xD0, 0xA4, 0x00 },	/* 0xC4 */
		{ 0xD0, 0xA5, 0x00 },	/* 0xC5 */
		{ 0xD0, 0xA6, 0x00 },	/* 0xC6 */
		{ 0xD0, 0xA7, 0x00 },	/* 0xC7 */
		{ 0xD0, 0xA8, 0x00 },	/* 0xC8 */
		{ 0xD0, 0xA9, 0x00 },	/* 0xC9 */
		{ 0xD0, 0xAA, 0x00 },	/* 0xCA */
		{ 0xD0, 0xAB, 0x00 },	/* 0xCB */
		{ 0xD0, 0xAC, 0x00 },	/* 0xCC */
		{ 0xD0, 0xAD, 0x00 },	/* 0xCD */
		{ 0xD0, 0xAE, 0x00 },	/* 0xCE */
		{ 0xD0, 0xAF, 0x00 },	/* 0xCF */
		{ 0xD0, 0xB0, 0x00 },	/* 0xD0 */
		{ 0xD0, 0xB1, 0x00 },	/* 0xD1 */
		{ 0xD0, 0xB2, 0x00 },	/* 0xD2 */
		{ 0xD0, 0xB3, 0x00 },	/* 0xD3 */
		{ 0xD0, 0xB4, 0x00 },	/* 0xD4 */
		{ 0xD0, 0xB5, 0x00 },	/* 0xD5 */
		{ 0xD0, 0xB6, 0x00 },	/* 0xD6 */
		{ 0xD0, 0xB7, 0x00 },	/* 0xD7 */
		{ 0xD0, 0xB8, 0x00 },	/* 0xD8 */
		{ 0xD0, 0xB9, 0x00 },	/* 0xD9 */
		{ 0xD0, 0xBA, 0x00 },	/* 0xDA */
		{ 0xD0, 0xBB, 0x00 },	/* 0xDB */
		{ 0xD0, 0xBC, 0x00 },	/* 0xDC */
		{ 0xD0, 0xBD, 0x00 },	/* 0xDD */
		{ 0xD0, 0xBE, 0x00 },	/* 0xDE */
		{ 0xD0, 0xBF, 0x00 },	/* 0xDF */
		{ 0xD1, 0x80, 0x00 },	/* 0xE0 */
		{ 0xD1, 0x81, 0x00 },	/* 0xE1 */
		{ 0xD1, 0x82, 0x00 },	/* 0xE2 */
		{ 0xD1, 0x83, 0x00 },	/* 0xE3 */
		{ 0xD1, 0x84, 0x00 },	/* 0xE4 */
		{ 0xD1, 0x85, 0x00 },	/* 0xE5 */
		{ 0xD1, 0x86, 0x00 },	/* 0xE6 */
		{ 0xD1, 0x87, 0x00 },	/* 0xE7 */
		{ 0xD1, 0x88, 0x00 },	/* 0xE8 */
		{ 0xD1, 0x89, 0x00 },	/* 0xE9 */
		{ 0xD1, 0x8A, 0x00 },	/* 0xEA */
		{ 0xD1, 0x8B, 0x00 },	/* 0xEB */
		{ 0xD1, 0x8C, 0x00 },	/* 0xEC */
		{ 0xD1, 0x8D, 0x00 },	/* 0xED */
		{ 0xD1, 0x8E, 0x00 },	/* 0xEE */
		{ 0xD1, 0x8F, 0x00 },	/* 0xEF */
		{ 0xE2, 0x84, 0x96 },	/* 0xF0 */
		{ 0xD1, 0x91, 0x00 },	/* 0xF1 */
		{ 0xD1, 0x92, 0x00 },	/* 0xF2 */
		{ 0xD1, 0x93, 0x00 },	/* 0xF3 */
		{ 0xD1, 0x94, 0x00 },	/* 0xF4 */
		{ 0xD1, 0x95, 0x00 },	/* 0xF5 */
		{ 0xD1, 0x96, 0x00 },	/* 0xF6 */
		{ 0xD1, 0x97, 0x00 },	/* 0xF7 */
		{ 0xD1, 0x98, 0x00 },	/* 0xF8 */
		{ 0xD1, 0x99, 0x00 },	/* 0xF9 */
		{ 0xD1, 0x9A, 0x00 },	/* 0xFA */
		{ 0xD1, 0x9B, 0x00 },	/* 0xFB */
		{ 0xD1, 0x9C, 0x00 },	/* 0xFC */
		{ 0xC2, 0xA7, 0x00 },	/* 0xFD */
		{ 0xD1, 0x9E, 0x00 },	/* 0xFE */
		{ 0xD1, 0x9F, 0x00 },	/* 0xFF */
	},
	{	/* ISO 8859-6 -> UTF-8 */
		{ 0xC2, 0x80, 0x00 },	/* 0x80 */
		{ 0xC2, 0x81, 0x00 },	/* 0x81 */
		{ 0xC2, 0x82, 0x00 },	/* 0x82 */
		{ 0xC2, 0x83, 0x00 },	/* 0x83 */
		{ 0xC2, 0x84, 0x00 },	/* 0x84 */
		{ 0xC2, 0x85, 0x00 },	/* 0x85 */
		{ 0xC2, 0x86, 0x00 },	/* 0x86 */
		{ 0xC2, 0x87, 0x00 },	/* 0x87 */
		{ 0xC2, 0x88, 0x00 },	/* 0x88 */
		{ 0xC2, 0x89, 0x00 },	/* 0x89 */
		{ 0xC2, 0x8A, 0x00 },	/* 0x8A */
		{ 0xC2, 0x8B, 0x00 },	/* 0x8B */
		{ 0xC2, 0x8C, 0x00 },	/* 0x8C */
		{ 0xC2, 0x8D, 0x00 },	/* 0x8D */
		{ 0xC2, 0x8E, 0x00 },	/* 0x8E */
		{ 0xC2, 0x8F, 0x00 },	/* 0x8F */
		{ 0xC2, 0x90, 0x00 },	/* 0x90 */
		{ 0xC2, 0x91, 0x00 },	/* 0x91 */
		{ 0xC2, 0x92, 0x00 },	/* 0x92 */
		{ 0xC2, 0x93, 0x00 },	/* 0x93 */
		{ 0xC2, 0x94, 0x00 },	/* 0x94 */
		{ 0xC2, 0x95, 0x00 },	/* 0x95 */
		{ 0xC2, 0x96, 0x00 },	/* 0x96 */
		{ 0xC2, 0x97, 0x00 },	/* 0x97 */
		{ 0xC2, 0x98, 0x00 },	/* 0x98 */
		{ 0xC2, 0x99, 0x00 },	/* 0x99 */
		{ 0xC2, 0x9A, 0x00 },	/* 0x9A */
		{ 0xC2, 0x9B, 0x00 },	/* 0x9B */
		{ 0xC2, 0x9C, 0x00 },	/* 0x9C */
		{ 0xC2, 0x9D, 0x00 },	/* 0x9D */
		{ 0xC2, 0x9E, 0x00 },	/* 0x9E */
		{ 0xC2, 0x9F, 0x00 },	/* 0x9F */
		{ 0xC2, 0xA0, 0x00 },	/* 0xA0 */
		{ 0xFE, 0xFE, 0xFE },	/* 0xA1 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xA2 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xA3 (illegal character) */
		{ 0xC2, 0xA4, 0x00 },	/* 0xA4 */
		{ 0xFE, 0xFE, 0xFE },	/* 0xA5 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xA6 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xA7 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xA8 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xA9 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xAA (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xAB (illegal character) */
		{ 0xD8, 0x8C, 0x00 },	/* 0xAC */
		{ 0xC2, 0xAD, 0x00 },	/* 0xAD */
		{ 0xFE, 0xFE, 0xFE },	/* 0xAE (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xAF (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xB0 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xB1 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xB2 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xB3 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xB4 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xB5 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xB6 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xB7 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xB8 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xB9 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xBA (illegal character) */
		{ 0xD8, 0x9B, 0x00 },	/* 0xBB */
		{ 0xFE, 0xFE, 0xFE },	/* 0xBC (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xBD (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xBE (illegal character) */
		{ 0xD8, 0x9F, 0x00 },	/* 0xBF */
		{ 0xFE, 0xFE, 0xFE },	/* 0xC0 (illegal character) */
		{ 0xD8, 0xA1, 0x00 },	/* 0xC1 */
		{ 0xD8, 0xA2, 0x00 },	/* 0xC2 */
		{ 0xD8, 0xA3, 0x00 },	/* 0xC3 */
		{ 0xD8, 0xA4, 0x00 },	/* 0xC4 */
		{ 0xD8, 0xA5, 0x00 },	/* 0xC5 */
		{ 0xD8, 0xA6, 0x00 },	/* 0xC6 */
		{ 0xD8, 0xA7, 0x00 },	/* 0xC7 */
		{ 0xD8, 0xA8, 0x00 },	/* 0xC8 */
		{ 0xD8, 0xA9, 0x00 },	/* 0xC9 */
		{ 0xD8, 0xAA, 0x00 },	/* 0xCA */
		{ 0xD8, 0xAB, 0x00 },	/* 0xCB */
		{ 0xD8, 0xAC, 0x00 },	/* 0xCC */
		{ 0xD8, 0xAD, 0x00 },	/* 0xCD */
		{ 0xD8, 0xAE, 0x00 },	/* 0xCE */
		{ 0xD8, 0xAF, 0x00 },	/* 0xCF */
		{ 0xD8, 0xB0, 0x00 },	/* 0xD0 */
		{ 0xD8, 0xB1, 0x00 },	/* 0xD1 */
		{ 0xD8, 0xB2, 0x00 },	/* 0xD2 */
		{ 0xD8, 0xB3, 0x00 },	/* 0xD3 */
		{ 0xD8, 0xB4, 0x00 },	/* 0xD4 */
		{ 0xD8, 0xB5, 0x00 },	/* 0xD5 */
		{ 0xD8, 0xB6, 0x00 },	/* 0xD6 */
		{ 0xD8, 0xB7, 0x00 },	/* 0xD7 */
		{ 0xD8, 0xB8, 0x00 },	/* 0xD8 */
		{ 0xD8, 0xB9, 0x00 },	/* 0xD9 */
		{ 0xD8, 0xBA, 0x00 },	/* 0xDA */
		{ 0xFE, 0xFE, 0xFE },	/* 0xDB (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xDC (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xDD (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xDE (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xDF (illegal character) */
		{ 0xD9, 0x80, 0x00 },	/* 0xE0 */
		{ 0xD9, 0x81, 0x00 },	/* 0xE1 */
		{ 0xD9, 0x82, 0x00 },	/* 0xE2 */
		{ 0xD9, 0x83, 0x00 },	/* 0xE3 */
		{ 0xD9, 0x84, 0x00 },	/* 0xE4 */
		{ 0xD9, 0x85, 0x00 },	/* 0xE5 */
		{ 0xD9, 0x86, 0x00 },	/* 0xE6 */
		{ 0xD9, 0x87, 0x00 },	/* 0xE7 */
		{ 0xD9, 0x88, 0x00 },	/* 0xE8 */
		{ 0xD9, 0x89, 0x00 },	/* 0xE9 */
		{ 0xD9, 0x8A, 0x00 },	/* 0xEA */
		{ 0xD9, 0x8B, 0x00 },	/* 0xEB */
		{ 0xD9, 0x8C, 0x00 },	/* 0xEC */
		{ 0xD9, 0x8D, 0x00 },	/* 0xED */
		{ 0xD9, 0x8E, 0x00 },	/* 0xEE */
		{ 0xD9, 0x8F, 0x00 },	/* 0xEF */
		{ 0xD9, 0x90, 0x00 },	/* 0xF0 */
		{ 0xD9, 0x91, 0x00 },	/* 0xF1 */
		{ 0xD9, 0x92, 0x00 },	/* 0xF2 */
		{ 0xFE, 0xFE, 0xFE },	/* 0xF3 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xF4 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xF5 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xF6 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xF7 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xF8 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xF9 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xFA (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xFB (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xFC (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xFD (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xFE (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xFF (illegal character) */
	},
	{	/* ISO 8859-7 -> UTF-8 */
		{ 0xC2, 0x80, 0x00 },	/* 0x80 */
		{ 0xC2, 0x81, 0x00 },	/* 0x81 */
		{ 0xC2, 0x82, 0x00 },	/* 0x82 */
		{ 0xC2, 0x83, 0x00 },	/* 0x83 */
		{ 0xC2, 0x84, 0x00 },	/* 0x84 */
		{ 0xC2, 0x85, 0x00 },	/* 0x85 */
		{ 0xC2, 0x86, 0x00 },	/* 0x86 */
		{ 0xC2, 0x87, 0x00 },	/* 0x87 */
		{ 0xC2, 0x88, 0x00 },	/* 0x88 */
		{ 0xC2, 0x89, 0x00 },	/* 0x89 */
		{ 0xC2, 0x8A, 0x00 },	/* 0x8A */
		{ 0xC2, 0x8B, 0x00 },	/* 0x8B */
		{ 0xC2, 0x8C, 0x00 },	/* 0x8C */
		{ 0xC2, 0x8D, 0x00 },	/* 0x8D */
		{ 0xC2, 0x8E, 0x00 },	/* 0x8E */
		{ 0xC2, 0x8F, 0x00 },	/* 0x8F */
		{ 0xC2, 0x90, 0x00 },	/* 0x90 */
		{ 0xC2, 0x91, 0x00 },	/* 0x91 */
		{ 0xC2, 0x92, 0x00 },	/* 0x92 */
		{ 0xC2, 0x93, 0x00 },	/* 0x93 */
		{ 0xC2, 0x94, 0x00 },	/* 0x94 */
		{ 0xC2, 0x95, 0x00 },	/* 0x95 */
		{ 0xC2, 0x96, 0x00 },	/* 0x96 */
		{ 0xC2, 0x97, 0x00 },	/* 0x97 */
		{ 0xC2, 0x98, 0x00 },	/* 0x98 */
		{ 0xC2, 0x99, 0x00 },	/* 0x99 */
		{ 0xC2, 0x9A, 0x00 },	/* 0x9A */
		{ 0xC2, 0x9B, 0x00 },	/* 0x9B */
		{ 0xC2, 0x9C, 0x00 },	/* 0x9C */
		{ 0xC2, 0x9D, 0x00 },	/* 0x9D */
		{ 0xC2, 0x9E, 0x00 },	/* 0x9E */
		{ 0xC2, 0x9F, 0x00 },	/* 0x9F */
		{ 0xC2, 0xA0, 0x00 },	/* 0xA0 */
		{ 0xE2, 0x80, 0x98 },	/* 0xA1 */
		{ 0xE2, 0x80, 0x99 },	/* 0xA2 */
		{ 0xC2, 0xA3, 0x00 },	/* 0xA3 */
		{ 0xFE, 0xFE, 0xFE },	/* 0xA4 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xA5 (illegal character) */
		{ 0xC2, 0xA6, 0x00 },	/* 0xA6 */
		{ 0xC2, 0xA7, 0x00 },	/* 0xA7 */
		{ 0xC2, 0xA8, 0x00 },	/* 0xA8 */
		{ 0xC2, 0xA9, 0x00 },	/* 0xA9 */
		{ 0xFE, 0xFE, 0xFE },	/* 0xAA (illegal character) */
		{ 0xC2, 0xAB, 0x00 },	/* 0xAB */
		{ 0xC2, 0xAC, 0x00 },	/* 0xAC */
		{ 0xC2, 0xAD, 0x00 },	/* 0xAD */
		{ 0xFE, 0xFE, 0xFE },	/* 0xAE (illegal character) */
		{ 0xE2, 0x80, 0x95 },	/* 0xAF */
		{ 0xC2, 0xB0, 0x00 },	/* 0xB0 */
		{ 0xC2, 0xB1, 0x00 },	/* 0xB1 */
		{ 0xC2, 0xB2, 0x00 },	/* 0xB2 */
		{ 0xC2, 0xB3, 0x00 },	/* 0xB3 */
		{ 0xCE, 0x84, 0x00 },	/* 0xB4 */
		{ 0xCE, 0x85, 0x00 },	/* 0xB5 */
		{ 0xCE, 0x86, 0x00 },	/* 0xB6 */
		{ 0xC2, 0xB7, 0x00 },	/* 0xB7 */
		{ 0xCE, 0x88, 0x00 },	/* 0xB8 */
		{ 0xCE, 0x89, 0x00 },	/* 0xB9 */
		{ 0xCE, 0x8A, 0x00 },	/* 0xBA */
		{ 0xC2, 0xBB, 0x00 },	/* 0xBB */
		{ 0xCE, 0x8C, 0x00 },	/* 0xBC */
		{ 0xC2, 0xBD, 0x00 },	/* 0xBD */
		{ 0xCE, 0x8E, 0x00 },	/* 0xBE */
		{ 0xCE, 0x8F, 0x00 },	/* 0xBF */
		{ 0xCE, 0x90, 0x00 },	/* 0xC0 */
		{ 0xCE, 0x91, 0x00 },	/* 0xC1 */
		{ 0xCE, 0x92, 0x00 },	/* 0xC2 */
		{ 0xCE, 0x93, 0x00 },	/* 0xC3 */
		{ 0xCE, 0x94, 0x00 },	/* 0xC4 */
		{ 0xCE, 0x95, 0x00 },	/* 0xC5 */
		{ 0xCE, 0x96, 0x00 },	/* 0xC6 */
		{ 0xCE, 0x97, 0x00 },	/* 0xC7 */
		{ 0xCE, 0x98, 0x00 },	/* 0xC8 */
		{ 0xCE, 0x99, 0x00 },	/* 0xC9 */
		{ 0xCE, 0x9A, 0x00 },	/* 0xCA */
		{ 0xCE, 0x9B, 0x00 },	/* 0xCB */
		{ 0xCE, 0x9C, 0x00 },	/* 0xCC */
		{ 0xCE, 0x9D, 0x00 },	/* 0xCD */
		{ 0xCE, 0x9E, 0x00 },	/* 0xCE */
		{ 0xCE, 0x9F, 0x00 },	/* 0xCF */
		{ 0xCE, 0xA0, 0x00 },	/* 0xD0 */
		{ 0xCE, 0xA1, 0x00 },	/* 0xD1 */
		{ 0xFE, 0xFE, 0xFE },	/* 0xD2 (illegal character) */
		{ 0xCE, 0xA3, 0x00 },	/* 0xD3 */
		{ 0xCE, 0xA4, 0x00 },	/* 0xD4 */
		{ 0xCE, 0xA5, 0x00 },	/* 0xD5 */
		{ 0xCE, 0xA6, 0x00 },	/* 0xD6 */
		{ 0xCE, 0xA7, 0x00 },	/* 0xD7 */
		{ 0xCE, 0xA8, 0x00 },	/* 0xD8 */
		{ 0xCE, 0xA9, 0x00 },	/* 0xD9 */
		{ 0xCE, 0xAA, 0x00 },	/* 0xDA */
		{ 0xCE, 0xAB, 0x00 },	/* 0xDB */
		{ 0xCE, 0xAC, 0x00 },	/* 0xDC */
		{ 0xCE, 0xAD, 0x00 },	/* 0xDD */
		{ 0xCE, 0xAE, 0x00 },	/* 0xDE */
		{ 0xCE, 0xAF, 0x00 },	/* 0xDF */
		{ 0xCE, 0xB0, 0x00 },	/* 0xE0 */
		{ 0xCE, 0xB1, 0x00 },	/* 0xE1 */
		{ 0xCE, 0xB2, 0x00 },	/* 0xE2 */
		{ 0xCE, 0xB3, 0x00 },	/* 0xE3 */
		{ 0xCE, 0xB4, 0x00 },	/* 0xE4 */
		{ 0xCE, 0xB5, 0x00 },	/* 0xE5 */
		{ 0xCE, 0xB6, 0x00 },	/* 0xE6 */
		{ 0xCE, 0xB7, 0x00 },	/* 0xE7 */
		{ 0xCE, 0xB8, 0x00 },	/* 0xE8 */
		{ 0xCE, 0xB9, 0x00 },	/* 0xE9 */
		{ 0xCE, 0xBA, 0x00 },	/* 0xEA */
		{ 0xCE, 0xBB, 0x00 },	/* 0xEB */
		{ 0xCE, 0xBC, 0x00 },	/* 0xEC */
		{ 0xCE, 0xBD, 0x00 },	/* 0xED */
		{ 0xCE, 0xBE, 0x00 },	/* 0xEE */
		{ 0xCE, 0xBF, 0x00 },	/* 0xEF */
		{ 0xCF, 0x80, 0x00 },	/* 0xF0 */
		{ 0xCF, 0x81, 0x00 },	/* 0xF1 */
		{ 0xCF, 0x82, 0x00 },	/* 0xF2 */
		{ 0xCF, 0x83, 0x00 },	/* 0xF3 */
		{ 0xCF, 0x84, 0x00 },	/* 0xF4 */
		{ 0xCF, 0x85, 0x00 },	/* 0xF5 */
		{ 0xCF, 0x86, 0x00 },	/* 0xF6 */
		{ 0xCF, 0x87, 0x00 },	/* 0xF7 */
		{ 0xCF, 0x88, 0x00 },	/* 0xF8 */
		{ 0xCF, 0x89, 0x00 },	/* 0xF9 */
		{ 0xCF, 0x8A, 0x00 },	/* 0xFA */
		{ 0xCF, 0x8B, 0x00 },	/* 0xFB */
		{ 0xCF, 0x8C, 0x00 },	/* 0xFC */
		{ 0xCF, 0x8D, 0x00 },	/* 0xFD */
		{ 0xCF, 0x8E, 0x00 },	/* 0xFE */
		{ 0xFE, 0xFE, 0xFE },	/* 0xFF (illegal character) */
	},
	{	/* ISO 8859-8 -> UTF-8 */
		{ 0xC2, 0x80, 0x00 },	/* 0x80 */
		{ 0xC2, 0x81, 0x00 },	/* 0x81 */
		{ 0xC2, 0x82, 0x00 },	/* 0x82 */
		{ 0xC2, 0x83, 0x00 },	/* 0x83 */
		{ 0xC2, 0x84, 0x00 },	/* 0x84 */
		{ 0xC2, 0x85, 0x00 },	/* 0x85 */
		{ 0xC2, 0x86, 0x00 },	/* 0x86 */
		{ 0xC2, 0x87, 0x00 },	/* 0x87 */
		{ 0xC2, 0x88, 0x00 },	/* 0x88 */
		{ 0xC2, 0x89, 0x00 },	/* 0x89 */
		{ 0xC2, 0x8A, 0x00 },	/* 0x8A */
		{ 0xC2, 0x8B, 0x00 },	/* 0x8B */
		{ 0xC2, 0x8C, 0x00 },	/* 0x8C */
		{ 0xC2, 0x8D, 0x00 },	/* 0x8D */
		{ 0xC2, 0x8E, 0x00 },	/* 0x8E */
		{ 0xC2, 0x8F, 0x00 },	/* 0x8F */
		{ 0xC2, 0x90, 0x00 },	/* 0x90 */
		{ 0xC2, 0x91, 0x00 },	/* 0x91 */
		{ 0xC2, 0x92, 0x00 },	/* 0x92 */
		{ 0xC2, 0x93, 0x00 },	/* 0x93 */
		{ 0xC2, 0x94, 0x00 },	/* 0x94 */
		{ 0xC2, 0x95, 0x00 },	/* 0x95 */
		{ 0xC2, 0x96, 0x00 },	/* 0x96 */
		{ 0xC2, 0x97, 0x00 },	/* 0x97 */
		{ 0xC2, 0x98, 0x00 },	/* 0x98 */
		{ 0xC2, 0x99, 0x00 },	/* 0x99 */
		{ 0xC2, 0x9A, 0x00 },	/* 0x9A */
		{ 0xC2, 0x9B, 0x00 },	/* 0x9B */
		{ 0xC2, 0x9C, 0x00 },	/* 0x9C */
		{ 0xC2, 0x9D, 0x00 },	/* 0x9D */
		{ 0xC2, 0x9E, 0x00 },	/* 0x9E */
		{ 0xC2, 0x9F, 0x00 },	/* 0x9F */
		{ 0xC2, 0xA0, 0x00 },	/* 0xA0 */
		{ 0xFE, 0xFE, 0xFE },	/* 0xA1 (illegal character) */
		{ 0xC2, 0xA2, 0x00 },	/* 0xA2 */
		{ 0xC2, 0xA3, 0x00 },	/* 0xA3 */
		{ 0xC2, 0xA4, 0x00 },	/* 0xA4 */
		{ 0xC2, 0xA5, 0x00 },	/* 0xA5 */
		{ 0xC2, 0xA6, 0x00 },	/* 0xA6 */
		{ 0xC2, 0xA7, 0x00 },	/* 0xA7 */
		{ 0xC2, 0xA8, 0x00 },	/* 0xA8 */
		{ 0xC2, 0xA9, 0x00 },	/* 0xA9 */
		{ 0xC3, 0x97, 0x00 },	/* 0xAA */
		{ 0xC2, 0xAB, 0x00 },	/* 0xAB */
		{ 0xC2, 0xAC, 0x00 },	/* 0xAC */
		{ 0xC2, 0xAD, 0x00 },	/* 0xAD */
		{ 0xC2, 0xAE, 0x00 },	/* 0xAE */
		{ 0xC2, 0xAF, 0x00 },	/* 0xAF */
		{ 0xC2, 0xB0, 0x00 },	/* 0xB0 */
		{ 0xC2, 0xB1, 0x00 },	/* 0xB1 */
		{ 0xC2, 0xB2, 0x00 },	/* 0xB2 */
		{ 0xC2, 0xB3, 0x00 },	/* 0xB3 */
		{ 0xC2, 0xB4, 0x00 },	/* 0xB4 */
		{ 0xC2, 0xB5, 0x00 },	/* 0xB5 */
		{ 0xC2, 0xB6, 0x00 },	/* 0xB6 */
		{ 0xC2, 0xB7, 0x00 },	/* 0xB7 */
		{ 0xC2, 0xB8, 0x00 },	/* 0xB8 */
		{ 0xC2, 0xB9, 0x00 },	/* 0xB9 */
		{ 0xC3, 0xB7, 0x00 },	/* 0xBA */
		{ 0xC2, 0xBB, 0x00 },	/* 0xBB */
		{ 0xC2, 0xBC, 0x00 },	/* 0xBC */
		{ 0xC2, 0xBD, 0x00 },	/* 0xBD */
		{ 0xC2, 0xBE, 0x00 },	/* 0xBE */
		{ 0xFE, 0xFE, 0xFE },	/* 0xBF (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xC0 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xC1 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xC2 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xC3 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xC4 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xC5 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xC6 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xC7 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xC8 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xC9 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xCA (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xCB (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xCC (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xCD (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xCE (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xCF (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xD0 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xD1 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xD2 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xD3 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xD4 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xD5 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xD6 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xD7 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xD8 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xD9 (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xDA (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xDB (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xDC (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xDD (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xDE (illegal character) */
		{ 0xE2, 0x80, 0x97 },	/* 0xDF */
		{ 0xD7, 0x90, 0x00 },	/* 0xE0 */
		{ 0xD7, 0x91, 0x00 },	/* 0xE1 */
		{ 0xD7, 0x92, 0x00 },	/* 0xE2 */
		{ 0xD7, 0x93, 0x00 },	/* 0xE3 */
		{ 0xD7, 0x94, 0x00 },	/* 0xE4 */
		{ 0xD7, 0x95, 0x00 },	/* 0xE5 */
		{ 0xD7, 0x96, 0x00 },	/* 0xE6 */
		{ 0xD7, 0x97, 0x00 },	/* 0xE7 */
		{ 0xD7, 0x98, 0x00 },	/* 0xE8 */
		{ 0xD7, 0x99, 0x00 },	/* 0xE9 */
		{ 0xD7, 0x9A, 0x00 },	/* 0xEA */
		{ 0xD7, 0x9B, 0x00 },	/* 0xEB */
		{ 0xD7, 0x9C, 0x00 },	/* 0xEC */
		{ 0xD7, 0x9D, 0x00 },	/* 0xED */
		{ 0xD7, 0x9E, 0x00 },	/* 0xEE */
		{ 0xD7, 0x9F, 0x00 },	/* 0xEF */
		{ 0xD7, 0xA0, 0x00 },	/* 0xF0 */
		{ 0xD7, 0xA1, 0x00 },	/* 0xF1 */
		{ 0xD7, 0xA2, 0x00 },	/* 0xF2 */
		{ 0xD7, 0xA3, 0x00 },	/* 0xF3 */
		{ 0xD7, 0xA4, 0x00 },	/* 0xF4 */
		{ 0xD7, 0xA5, 0x00 },	/* 0xF5 */
		{ 0xD7, 0xA6, 0x00 },	/* 0xF6 */
		{ 0xD7, 0xA7, 0x00 },	/* 0xF7 */
		{ 0xD7, 0xA8, 0x00 },	/* 0xF8 */
		{ 0xD7, 0xA9, 0x00 },	/* 0xF9 */
		{ 0xD7, 0xAA, 0x00 },	/* 0xFA */
		{ 0xFE, 0xFE, 0xFE },	/* 0xFB (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xFC (illegal character) */
		{ 0xE2, 0x80, 0x8E },	/* 0xFD */
		{ 0xE2, 0x80, 0x8F },	/* 0xFE */
		{ 0xFE, 0xFE, 0xFE },	/* 0xFF (illegal character) */
	},
	{	/* ISO 8859-9 -> UTF-8 */
		{ 0xC2, 0x80, 0x00 },	/* 0x80 */
		{ 0xC2, 0x81, 0x00 },	/* 0x81 */
		{ 0xC2, 0x82, 0x00 },	/* 0x82 */
		{ 0xC2, 0x83, 0x00 },	/* 0x83 */
		{ 0xC2, 0x84, 0x00 },	/* 0x84 */
		{ 0xC2, 0x85, 0x00 },	/* 0x85 */
		{ 0xC2, 0x86, 0x00 },	/* 0x86 */
		{ 0xC2, 0x87, 0x00 },	/* 0x87 */
		{ 0xC2, 0x88, 0x00 },	/* 0x88 */
		{ 0xC2, 0x89, 0x00 },	/* 0x89 */
		{ 0xC2, 0x8A, 0x00 },	/* 0x8A */
		{ 0xC2, 0x8B, 0x00 },	/* 0x8B */
		{ 0xC2, 0x8C, 0x00 },	/* 0x8C */
		{ 0xC2, 0x8D, 0x00 },	/* 0x8D */
		{ 0xC2, 0x8E, 0x00 },	/* 0x8E */
		{ 0xC2, 0x8F, 0x00 },	/* 0x8F */
		{ 0xC2, 0x90, 0x00 },	/* 0x90 */
		{ 0xC2, 0x91, 0x00 },	/* 0x91 */
		{ 0xC2, 0x92, 0x00 },	/* 0x92 */
		{ 0xC2, 0x93, 0x00 },	/* 0x93 */
		{ 0xC2, 0x94, 0x00 },	/* 0x94 */
		{ 0xC2, 0x95, 0x00 },	/* 0x95 */
		{ 0xC2, 0x96, 0x00 },	/* 0x96 */
		{ 0xC2, 0x97, 0x00 },	/* 0x97 */
		{ 0xC2, 0x98, 0x00 },	/* 0x98 */
		{ 0xC2, 0x99, 0x00 },	/* 0x99 */
		{ 0xC2, 0x9A, 0x00 },	/* 0x9A */
		{ 0xC2, 0x9B, 0x00 },	/* 0x9B */
		{ 0xC2, 0x9C, 0x00 },	/* 0x9C */
		{ 0xC2, 0x9D, 0x00 },	/* 0x9D */
		{ 0xC2, 0x9E, 0x00 },	/* 0x9E */
		{ 0xC2, 0x9F, 0x00 },	/* 0x9F */
		{ 0xC2, 0xA0, 0x00 },	/* 0xA0 */
		{ 0xC2, 0xA1, 0x00 },	/* 0xA1 */
		{ 0xC2, 0xA2, 0x00 },	/* 0xA2 */
		{ 0xC2, 0xA3, 0x00 },	/* 0xA3 */
		{ 0xC2, 0xA4, 0x00 },	/* 0xA4 */
		{ 0xC2, 0xA5, 0x00 },	/* 0xA5 */
		{ 0xC2, 0xA6, 0x00 },	/* 0xA6 */
		{ 0xC2, 0xA7, 0x00 },	/* 0xA7 */
		{ 0xC2, 0xA8, 0x00 },	/* 0xA8 */
		{ 0xC2, 0xA9, 0x00 },	/* 0xA9 */
		{ 0xC2, 0xAA, 0x00 },	/* 0xAA */
		{ 0xC2, 0xAB, 0x00 },	/* 0xAB */
		{ 0xC2, 0xAC, 0x00 },	/* 0xAC */
		{ 0xC2, 0xAD, 0x00 },	/* 0xAD */
		{ 0xC2, 0xAE, 0x00 },	/* 0xAE */
		{ 0xC2, 0xAF, 0x00 },	/* 0xAF */
		{ 0xC2, 0xB0, 0x00 },	/* 0xB0 */
		{ 0xC2, 0xB1, 0x00 },	/* 0xB1 */
		{ 0xC2, 0xB2, 0x00 },	/* 0xB2 */
		{ 0xC2, 0xB3, 0x00 },	/* 0xB3 */
		{ 0xC2, 0xB4, 0x00 },	/* 0xB4 */
		{ 0xC2, 0xB5, 0x00 },	/* 0xB5 */
		{ 0xC2, 0xB6, 0x00 },	/* 0xB6 */
		{ 0xC2, 0xB7, 0x00 },	/* 0xB7 */
		{ 0xC2, 0xB8, 0x00 },	/* 0xB8 */
		{ 0xC2, 0xB9, 0x00 },	/* 0xB9 */
		{ 0xC2, 0xBA, 0x00 },	/* 0xBA */
		{ 0xC2, 0xBB, 0x00 },	/* 0xBB */
		{ 0xC2, 0xBC, 0x00 },	/* 0xBC */
		{ 0xC2, 0xBD, 0x00 },	/* 0xBD */
		{ 0xC2, 0xBE, 0x00 },	/* 0xBE */
		{ 0xC2, 0xBF, 0x00 },	/* 0xBF */
		{ 0xC3, 0x80, 0x00 },	/* 0xC0 */
		{ 0xC3, 0x81, 0x00 },	/* 0xC1 */
		{ 0xC3, 0x82, 0x00 },	/* 0xC2 */
		{ 0xC3, 0x83, 0x00 },	/* 0xC3 */
		{ 0xC3, 0x84, 0x00 },	/* 0xC4 */
		{ 0xC3, 0x85, 0x00 },	/* 0xC5 */
		{ 0xC3, 0x86, 0x00 },	/* 0xC6 */
		{ 0xC3, 0x87, 0x00 },	/* 0xC7 */
		{ 0xC3, 0x88, 0x00 },	/* 0xC8 */
		{ 0xC3, 0x89, 0x00 },	/* 0xC9 */
		{ 0xC3, 0x8A, 0x00 },	/* 0xCA */
		{ 0xC3, 0x8B, 0x00 },	/* 0xCB */
		{ 0xC3, 0x8C, 0x00 },	/* 0xCC */
		{ 0xC3, 0x8D, 0x00 },	/* 0xCD */
		{ 0xC3, 0x8E, 0x00 },	/* 0xCE */
		{ 0xC3, 0x8F, 0x00 },	/* 0xCF */
		{ 0xC4, 0x9E, 0x00 },	/* 0xD0 */
		{ 0xC3, 0x91, 0x00 },	/* 0xD1 */
		{ 0xC3, 0x92, 0x00 },	/* 0xD2 */
		{ 0xC3, 0x93, 0x00 },	/* 0xD3 */
		{ 0xC3, 0x94, 0x00 },	/* 0xD4 */
		{ 0xC3, 0x95, 0x00 },	/* 0xD5 */
		{ 0xC3, 0x96, 0x00 },	/* 0xD6 */
		{ 0xC3, 0x97, 0x00 },	/* 0xD7 */
		{ 0xC3, 0x98, 0x00 },	/* 0xD8 */
		{ 0xC3, 0x99, 0x00 },	/* 0xD9 */
		{ 0xC3, 0x9A, 0x00 },	/* 0xDA */
		{ 0xC3, 0x9B, 0x00 },	/* 0xDB */
		{ 0xC3, 0x9C, 0x00 },	/* 0xDC */
		{ 0xC4, 0xB0, 0x00 },	/* 0xDD */
		{ 0xC5, 0x9E, 0x00 },	/* 0xDE */
		{ 0xC3, 0x9F, 0x00 },	/* 0xDF */
		{ 0xC3, 0xA0, 0x00 },	/* 0xE0 */
		{ 0xC3, 0xA1, 0x00 },	/* 0xE1 */
		{ 0xC3, 0xA2, 0x00 },	/* 0xE2 */
		{ 0xC3, 0xA3, 0x00 },	/* 0xE3 */
		{ 0xC3, 0xA4, 0x00 },	/* 0xE4 */
		{ 0xC3, 0xA5, 0x00 },	/* 0xE5 */
		{ 0xC3, 0xA6, 0x00 },	/* 0xE6 */
		{ 0xC3, 0xA7, 0x00 },	/* 0xE7 */
		{ 0xC3, 0xA8, 0x00 },	/* 0xE8 */
		{ 0xC3, 0xA9, 0x00 },	/* 0xE9 */
		{ 0xC3, 0xAA, 0x00 },	/* 0xEA */
		{ 0xC3, 0xAB, 0x00 },	/* 0xEB */
		{ 0xC3, 0xAC, 0x00 },	/* 0xEC */
		{ 0xC3, 0xAD, 0x00 },	/* 0xED */
		{ 0xC3, 0xAE, 0x00 },	/* 0xEE */
		{ 0xC3, 0xAF, 0x00 },	/* 0xEF */
		{ 0xC4, 0x9F, 0x00 },	/* 0xF0 */
		{ 0xC3, 0xB1, 0x00 },	/* 0xF1 */
		{ 0xC3, 0xB2, 0x00 },	/* 0xF2 */
		{ 0xC3, 0xB3, 0x00 },	/* 0xF3 */
		{ 0xC3, 0xB4, 0x00 },	/* 0xF4 */
		{ 0xC3, 0xB5, 0x00 },	/* 0xF5 */
		{ 0xC3, 0xB6, 0x00 },	/* 0xF6 */
		{ 0xC3, 0xB7, 0x00 },	/* 0xF7 */
		{ 0xC3, 0xB8, 0x00 },	/* 0xF8 */
		{ 0xC3, 0xB9, 0x00 },	/* 0xF9 */
		{ 0xC3, 0xBA, 0x00 },	/* 0xFA */
		{ 0xC3, 0xBB, 0x00 },	/* 0xFB */
		{ 0xC3, 0xBC, 0x00 },	/* 0xFC */
		{ 0xC4, 0xB1, 0x00 },	/* 0xFD */
		{ 0xC5, 0x9F, 0x00 },	/* 0xFE */
		{ 0xC3, 0xBF, 0x00 },	/* 0xFF */
	},
	{	/* ISO 8859-10 -> UTF-8 */
		{ 0xC2, 0x80, 0x00 },	/* 0x80 */
		{ 0xC2, 0x81, 0x00 },	/* 0x81 */
		{ 0xC2, 0x82, 0x00 },	/* 0x82 */
		{ 0xC2, 0x83, 0x00 },	/* 0x83 */
		{ 0xC2, 0x84, 0x00 },	/* 0x84 */
		{ 0xC2, 0x85, 0x00 },	/* 0x85 */
		{ 0xC2, 0x86, 0x00 },	/* 0x86 */
		{ 0xC2, 0x87, 0x00 },	/* 0x87 */
		{ 0xC2, 0x88, 0x00 },	/* 0x88 */
		{ 0xC2, 0x89, 0x00 },	/* 0x89 */
		{ 0xC2, 0x8A, 0x00 },	/* 0x8A */
		{ 0xC2, 0x8B, 0x00 },	/* 0x8B */
		{ 0xC2, 0x8C, 0x00 },	/* 0x8C */
		{ 0xC2, 0x8D, 0x00 },	/* 0x8D */
		{ 0xC2, 0x8E, 0x00 },	/* 0x8E */
		{ 0xC2, 0x8F, 0x00 },	/* 0x8F */
		{ 0xC2, 0x90, 0x00 },	/* 0x90 */
		{ 0xC2, 0x91, 0x00 },	/* 0x91 */
		{ 0xC2, 0x92, 0x00 },	/* 0x92 */
		{ 0xC2, 0x93, 0x00 },	/* 0x93 */
		{ 0xC2, 0x94, 0x00 },	/* 0x94 */
		{ 0xC2, 0x95, 0x00 },	/* 0x95 */
		{ 0xC2, 0x96, 0x00 },	/* 0x96 */
		{ 0xC2, 0x97, 0x00 },	/* 0x97 */
		{ 0xC2, 0x98, 0x00 },	/* 0x98 */
		{ 0xC2, 0x99, 0x00 },	/* 0x99 */
		{ 0xC2, 0x9A, 0x00 },	/* 0x9A */
		{ 0xC2, 0x9B, 0x00 },	/* 0x9B */
		{ 0xC2, 0x9C, 0x00 },	/* 0x9C */
		{ 0xC2, 0x9D, 0x00 },	/* 0x9D */
		{ 0xC2, 0x9E, 0x00 },	/* 0x9E */
		{ 0xC2, 0x9F, 0x00 },	/* 0x9F */
		{ 0xC2, 0xA0, 0x00 },	/* 0xA0 */
		{ 0xC4, 0x84, 0x00 },	/* 0xA1 */
		{ 0xC4, 0x92, 0x00 },	/* 0xA2 */
		{ 0xC4, 0xA2, 0x00 },	/* 0xA3 */
		{ 0xC4, 0xAA, 0x00 },	/* 0xA4 */
		{ 0xC4, 0xA8, 0x00 },	/* 0xA5 */
		{ 0xC4, 0xB6, 0x00 },	/* 0xA6 */
		{ 0xC2, 0xA7, 0x00 },	/* 0xA7 */
		{ 0xC4, 0xBB, 0x00 },	/* 0xA8 */
		{ 0xC4, 0x90, 0x00 },	/* 0xA9 */
		{ 0xC5, 0xA0, 0x00 },	/* 0xAA */
		{ 0xC5, 0xA6, 0x00 },	/* 0xAB */
		{ 0xC5, 0xBD, 0x00 },	/* 0xAC */
		{ 0xC2, 0xAD, 0x00 },	/* 0xAD */
		{ 0xC5, 0xAA, 0x00 },	/* 0xAE */
		{ 0xC5, 0x8A, 0x00 },	/* 0xAF */
		{ 0xC2, 0xB0, 0x00 },	/* 0xB0 */
		{ 0xC4, 0x85, 0x00 },	/* 0xB1 */
		{ 0xC4, 0x93, 0x00 },	/* 0xB2 */
		{ 0xC4, 0xA3, 0x00 },	/* 0xB3 */
		{ 0xC4, 0xAB, 0x00 },	/* 0xB4 */
		{ 0xC4, 0xA9, 0x00 },	/* 0xB5 */
		{ 0xC4, 0xB7, 0x00 },	/* 0xB6 */
		{ 0xC2, 0xB7, 0x00 },	/* 0xB7 */
		{ 0xC4, 0xBC, 0x00 },	/* 0xB8 */
		{ 0xC4, 0x91, 0x00 },	/* 0xB9 */
		{ 0xC5, 0xA1, 0x00 },	/* 0xBA */
		{ 0xC5, 0xA7, 0x00 },	/* 0xBB */
		{ 0xC5, 0xBE, 0x00 },	/* 0xBC */
		{ 0xE2, 0x88, 0x92 },	/* 0xBD */
		{ 0xC5, 0xAB, 0x00 },	/* 0xBE */
		{ 0xC5, 0x8B, 0x00 },	/* 0xBF */
		{ 0xC4, 0x80, 0x00 },	/* 0xC0 */
		{ 0xC3, 0x81, 0x00 },	/* 0xC1 */
		{ 0xC3, 0x82, 0x00 },	/* 0xC2 */
		{ 0xC3, 0x83, 0x00 },	/* 0xC3 */
		{ 0xC3, 0x84, 0x00 },	/* 0xC4 */
		{ 0xC3, 0x85, 0x00 },	/* 0xC5 */
		{ 0xC3, 0x86, 0x00 },	/* 0xC6 */
		{ 0xC4, 0xAE, 0x00 },	/* 0xC7 */
		{ 0xC4, 0x8C, 0x00 },	/* 0xC8 */
		{ 0xC3, 0x89, 0x00 },	/* 0xC9 */
		{ 0xC4, 0x98, 0x00 },	/* 0xCA */
		{ 0xC3, 0x8B, 0x00 },	/* 0xCB */
		{ 0xC4, 0x96, 0x00 },	/* 0xCC */
		{ 0xC3, 0x8D, 0x00 },	/* 0xCD */
		{ 0xC3, 0x8E, 0x00 },	/* 0xCE */
		{ 0xC3, 0x8F, 0x00 },	/* 0xCF */
		{ 0xC3, 0x90, 0x00 },	/* 0xD0 */
		{ 0xC5, 0x85, 0x00 },	/* 0xD1 */
		{ 0xC5, 0x8C, 0x00 },	/* 0xD2 */
		{ 0xC3, 0x93, 0x00 },	/* 0xD3 */
		{ 0xC3, 0x94, 0x00 },	/* 0xD4 */
		{ 0xC3, 0x95, 0x00 },	/* 0xD5 */
		{ 0xC3, 0x96, 0x00 },	/* 0xD6 */
		{ 0xC5, 0xA8, 0x00 },	/* 0xD7 */
		{ 0xC3, 0x98, 0x00 },	/* 0xD8 */
		{ 0xC5, 0xB2, 0x00 },	/* 0xD9 */
		{ 0xC3, 0x9A, 0x00 },	/* 0xDA */
		{ 0xC3, 0x9B, 0x00 },	/* 0xDB */
		{ 0xC3, 0x9C, 0x00 },	/* 0xDC */
		{ 0xC3, 0x9D, 0x00 },	/* 0xDD */
		{ 0xC3, 0x9E, 0x00 },	/* 0xDE */
		{ 0xC3, 0x9F, 0x00 },	/* 0xDF */
		{ 0xC4, 0x81, 0x00 },	/* 0xE0 */
		{ 0xC3, 0xA1, 0x00 },	/* 0xE1 */
		{ 0xC3, 0xA2, 0x00 },	/* 0xE2 */
		{ 0xC3, 0xA3, 0x00 },	/* 0xE3 */
		{ 0xC3, 0xA4, 0x00 },	/* 0xE4 */
		{ 0xC3, 0xA5, 0x00 },	/* 0xE5 */
		{ 0xC3, 0xA6, 0x00 },	/* 0xE6 */
		{ 0xC4, 0xAF, 0x00 },	/* 0xE7 */
		{ 0xC4, 0x8D, 0x00 },	/* 0xE8 */
		{ 0xC3, 0xA9, 0x00 },	/* 0xE9 */
		{ 0xC4, 0x99, 0x00 },	/* 0xEA */
		{ 0xC3, 0xAB, 0x00 },	/* 0xEB */
		{ 0xC4, 0x97, 0x00 },	/* 0xEC */
		{ 0xC3, 0xAD, 0x00 },	/* 0xED */
		{ 0xC3, 0xAE, 0x00 },	/* 0xEE */
		{ 0xC3, 0xAF, 0x00 },	/* 0xEF */
		{ 0xC3, 0xB0, 0x00 },	/* 0xF0 */
		{ 0xC5, 0x86, 0x00 },	/* 0xF1 */
		{ 0xC5, 0x8D, 0x00 },	/* 0xF2 */
		{ 0xC3, 0xB3, 0x00 },	/* 0xF3 */
		{ 0xC3, 0xB4, 0x00 },	/* 0xF4 */
		{ 0xC3, 0xB5, 0x00 },	/* 0xF5 */
		{ 0xC3, 0xB6, 0x00 },	/* 0xF6 */
		{ 0xC5, 0xA9, 0x00 },	/* 0xF7 */
		{ 0xC3, 0xB8, 0x00 },	/* 0xF8 */
		{ 0xC5, 0xB3, 0x00 },	/* 0xF9 */
		{ 0xC3, 0xBA, 0x00 },	/* 0xFA */
		{ 0xC3, 0xBB, 0x00 },	/* 0xFB */
		{ 0xC3, 0xBC, 0x00 },	/* 0xFC */
		{ 0xC3, 0xBD, 0x00 },	/* 0xFD */
		{ 0xC3, 0xBE, 0x00 },	/* 0xFE */
		{ 0xC4, 0xB8, 0x00 },	/* 0xFF */
	},
	{	/* ISO 8859-11 -> UTF-8 */
		{ 0xC2, 0x80, 0x00 },	/* 0x80 */
		{ 0xC2, 0x81, 0x00 },	/* 0x81 */
		{ 0xC2, 0x82, 0x00 },	/* 0x82 */
		{ 0xC2, 0x83, 0x00 },	/* 0x83 */
		{ 0xC2, 0x84, 0x00 },	/* 0x84 */
		{ 0xC2, 0x85, 0x00 },	/* 0x85 */
		{ 0xC2, 0x86, 0x00 },	/* 0x86 */
		{ 0xC2, 0x87, 0x00 },	/* 0x87 */
		{ 0xC2, 0x88, 0x00 },	/* 0x88 */
		{ 0xC2, 0x89, 0x00 },	/* 0x89 */
		{ 0xC2, 0x8A, 0x00 },	/* 0x8A */
		{ 0xC2, 0x8B, 0x00 },	/* 0x8B */
		{ 0xC2, 0x8C, 0x00 },	/* 0x8C */
		{ 0xC2, 0x8D, 0x00 },	/* 0x8D */
		{ 0xC2, 0x8E, 0x00 },	/* 0x8E */
		{ 0xC2, 0x8F, 0x00 },	/* 0x8F */
		{ 0xC2, 0x90, 0x00 },	/* 0x90 */
		{ 0xC2, 0x91, 0x00 },	/* 0x91 */
		{ 0xC2, 0x92, 0x00 },	/* 0x92 */
		{ 0xC2, 0x93, 0x00 },	/* 0x93 */
		{ 0xC2, 0x94, 0x00 },	/* 0x94 */
		{ 0xC2, 0x95, 0x00 },	/* 0x95 */
		{ 0xC2, 0x96, 0x00 },	/* 0x96 */
		{ 0xC2, 0x97, 0x00 },	/* 0x97 */
		{ 0xC2, 0x98, 0x00 },	/* 0x98 */
		{ 0xC2, 0x99, 0x00 },	/* 0x99 */
		{ 0xC2, 0x9A, 0x00 },	/* 0x9A */
		{ 0xC2, 0x9B, 0x00 },	/* 0x9B */
		{ 0xC2, 0x9C, 0x00 },	/* 0x9C */
		{ 0xC2, 0x9D, 0x00 },	/* 0x9D */
		{ 0xC2, 0x9E, 0x00 },	/* 0x9E */
		{ 0xC2, 0x9F, 0x00 },	/* 0x9F */
		{ 0xFE, 0xFE, 0xFE },	/* 0xA0 (illegal character) */
		{ 0xE0, 0xB8, 0x81 },	/* 0xA1 */
		{ 0xE0, 0xB8, 0x82 },	/* 0xA2 */
		{ 0xE0, 0xB8, 0x83 },	/* 0xA3 */
		{ 0xE0, 0xB8, 0x84 },	/* 0xA4 */
		{ 0xE0, 0xB8, 0x85 },	/* 0xA5 */
		{ 0xE0, 0xB8, 0x86 },	/* 0xA6 */
		{ 0xE0, 0xB8, 0x87 },	/* 0xA7 */
		{ 0xE0, 0xB8, 0x88 },	/* 0xA8 */
		{ 0xE0, 0xB8, 0x89 },	/* 0xA9 */
		{ 0xE0, 0xB8, 0x8A },	/* 0xAA */
		{ 0xE0, 0xB8, 0x8B },	/* 0xAB */
		{ 0xE0, 0xB8, 0x8C },	/* 0xAC */
		{ 0xE0, 0xB8, 0x8D },	/* 0xAD */
		{ 0xE0, 0xB8, 0x8E },	/* 0xAE */
		{ 0xE0, 0xB8, 0x8F },	/* 0xAF */
		{ 0xE0, 0xB8, 0x90 },	/* 0xB0 */
		{ 0xE0, 0xB8, 0x91 },	/* 0xB1 */
		{ 0xE0, 0xB8, 0x92 },	/* 0xB2 */
		{ 0xE0, 0xB8, 0x93 },	/* 0xB3 */
		{ 0xE0, 0xB8, 0x94 },	/* 0xB4 */
		{ 0xE0, 0xB8, 0x95 },	/* 0xB5 */
		{ 0xE0, 0xB8, 0x96 },	/* 0xB6 */
		{ 0xE0, 0xB8, 0x97 },	/* 0xB7 */
		{ 0xE0, 0xB8, 0x98 },	/* 0xB8 */
		{ 0xE0, 0xB8, 0x99 },	/* 0xB9 */
		{ 0xE0, 0xB8, 0x9A },	/* 0xBA */
		{ 0xE0, 0xB8, 0x9B },	/* 0xBB */
		{ 0xE0, 0xB8, 0x9C },	/* 0xBC */
		{ 0xE0, 0xB8, 0x9D },	/* 0xBD */
		{ 0xE0, 0xB8, 0x9E },	/* 0xBE */
		{ 0xE0, 0xB8, 0x9F },	/* 0xBF */
		{ 0xE0, 0xB8, 0xA0 },	/* 0xC0 */
		{ 0xE0, 0xB8, 0xA1 },	/* 0xC1 */
		{ 0xE0, 0xB8, 0xA2 },	/* 0xC2 */
		{ 0xE0, 0xB8, 0xA3 },	/* 0xC3 */
		{ 0xE0, 0xB8, 0xA4 },	/* 0xC4 */
		{ 0xE0, 0xB8, 0xA5 },	/* 0xC5 */
		{ 0xE0, 0xB8, 0xA6 },	/* 0xC6 */
		{ 0xE0, 0xB8, 0xA7 },	/* 0xC7 */
		{ 0xE0, 0xB8, 0xA8 },	/* 0xC8 */
		{ 0xE0, 0xB8, 0xA9 },	/* 0xC9 */
		{ 0xE0, 0xB8, 0xAA },	/* 0xCA */
		{ 0xE0, 0xB8, 0xAB },	/* 0xCB */
		{ 0xE0, 0xB8, 0xAC },	/* 0xCC */
		{ 0xE0, 0xB8, 0xAD },	/* 0xCD */
		{ 0xE0, 0xB8, 0xAE },	/* 0xCE */
		{ 0xE0, 0xB8, 0xAF },	/* 0xCF */
		{ 0xE0, 0xB8, 0xB0 },	/* 0xD0 */
		{ 0xE0, 0xB8, 0xB1 },	/* 0xD1 */
		{ 0xE0, 0xB8, 0xB2 },	/* 0xD2 */
		{ 0xE0, 0xB8, 0xB3 },	/* 0xD3 */
		{ 0xE0, 0xB8, 0xB4 },	/* 0xD4 */
		{ 0xE0, 0xB8, 0xB5 },	/* 0xD5 */
		{ 0xE0, 0xB8, 0xB6 },	/* 0xD6 */
		{ 0xE0, 0xB8, 0xB7 },	/* 0xD7 */
		{ 0xE0, 0xB8, 0xB8 },	/* 0xD8 */
		{ 0xE0, 0xB8, 0xB9 },	/* 0xD9 */
		{ 0xE0, 0xB8, 0xBA },	/* 0xDA */
		{ 0xFE, 0xFE, 0xFE },	/* 0xDB (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xDC (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xDD (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xDE (illegal character) */
		{ 0xE0, 0xB8, 0xBF },	/* 0xDF */
		{ 0xE0, 0xB9, 0x80 },	/* 0xE0 */
		{ 0xE0, 0xB9, 0x81 },	/* 0xE1 */
		{ 0xE0, 0xB9, 0x82 },	/* 0xE2 */
		{ 0xE0, 0xB9, 0x83 },	/* 0xE3 */
		{ 0xE0, 0xB9, 0x84 },	/* 0xE4 */
		{ 0xE0, 0xB9, 0x85 },	/* 0xE5 */
		{ 0xE0, 0xB9, 0x86 },	/* 0xE6 */
		{ 0xE0, 0xB9, 0x87 },	/* 0xE7 */
		{ 0xE0, 0xB9, 0x88 },	/* 0xE8 */
		{ 0xE0, 0xB9, 0x89 },	/* 0xE9 */
		{ 0xE0, 0xB9, 0x8A },	/* 0xEA */
		{ 0xE0, 0xB9, 0x8B },	/* 0xEB */
		{ 0xE0, 0xB9, 0x8C },	/* 0xEC */
		{ 0xE0, 0xB9, 0x8D },	/* 0xED */
		{ 0xE0, 0xB9, 0x8E },	/* 0xEE */
		{ 0xE0, 0xB9, 0x8F },	/* 0xEF */
		{ 0xE0, 0xB9, 0x90 },	/* 0xF0 */
		{ 0xE0, 0xB9, 0x91 },	/* 0xF1 */
		{ 0xE0, 0xB9, 0x92 },	/* 0xF2 */
		{ 0xE0, 0xB9, 0x93 },	/* 0xF3 */
		{ 0xE0, 0xB9, 0x94 },	/* 0xF4 */
		{ 0xE0, 0xB9, 0x95 },	/* 0xF5 */
		{ 0xE0, 0xB9, 0x96 },	/* 0xF6 */
		{ 0xE0, 0xB9, 0x97 },	/* 0xF7 */
		{ 0xE0, 0xB9, 0x98 },	/* 0xF8 */
		{ 0xE0, 0xB9, 0x99 },	/* 0xF9 */
		{ 0xE0, 0xB9, 0x9A },	/* 0xFA */
		{ 0xE0, 0xB9, 0x9B },	/* 0xFB */
		{ 0xFE, 0xFE, 0xFE },	/* 0xFC (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xFD (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xFE (illegal character) */
		{ 0xFE, 0xFE, 0xFE },	/* 0xFF (illegal character) */
	},
	{	/* ISO 8859-13 -> UTF-8 */
		{ 0xC2, 0x80, 0x00 },	/* 0x80 */
		{ 0xC2, 0x81, 0x00 },	/* 0x81 */
		{ 0xC2, 0x82, 0x00 },	/* 0x82 */
		{ 0xC2, 0x83, 0x00 },	/* 0x83 */
		{ 0xC2, 0x84, 0x00 },	/* 0x84 */
		{ 0xC2, 0x85, 0x00 },	/* 0x85 */
		{ 0xC2, 0x86, 0x00 },	/* 0x86 */
		{ 0xC2, 0x87, 0x00 },	/* 0x87 */
		{ 0xC2, 0x88, 0x00 },	/* 0x88 */
		{ 0xC2, 0x89, 0x00 },	/* 0x89 */
		{ 0xC2, 0x8A, 0x00 },	/* 0x8A */
		{ 0xC2, 0x8B, 0x00 },	/* 0x8B */
		{ 0xC2, 0x8C, 0x00 },	/* 0x8C */
		{ 0xC2, 0x8D, 0x00 },	/* 0x8D */
		{ 0xC2, 0x8E, 0x00 },	/* 0x8E */
		{ 0xC2, 0x8F, 0x00 },	/* 0x8F */
		{ 0xC2, 0x90, 0x00 },	/* 0x90 */
		{ 0xC2, 0x91, 0x00 },	/* 0x91 */
		{ 0xC2, 0x92, 0x00 },	/* 0x92 */
		{ 0xC2, 0x93, 0x00 },	/* 0x93 */
		{ 0xC2, 0x94, 0x00 },	/* 0x94 */
		{ 0xC2, 0x95, 0x00 },	/* 0x95 */
		{ 0xC2, 0x96, 0x00 },	/* 0x96 */
		{ 0xC2, 0x97, 0x00 },	/* 0x97 */
		{ 0xC2, 0x98, 0x00 },	/* 0x98 */
		{ 0xC2, 0x99, 0x00 },	/* 0x99 */
		{ 0xC2, 0x9A, 0x00 },	/* 0x9A */
		{ 0xC2, 0x9B, 0x00 },	/* 0x9B */
		{ 0xC2, 0x9C, 0x00 },	/* 0x9C */
		{ 0xC2, 0x9D, 0x00 },	/* 0x9D */
		{ 0xC2, 0x9E, 0x00 },	/* 0x9E */
		{ 0xC2, 0x9F, 0x00 },	/* 0x9F */
		{ 0xC2, 0xA0, 0x00 },	/* 0xA0 */
		{ 0xE2, 0x80, 0x9D },	/* 0xA1 */
		{ 0xC2, 0xA2, 0x00 },	/* 0xA2 */
		{ 0xC2, 0xA3, 0x00 },	/* 0xA3 */
		{ 0xC2, 0xA4, 0x00 },	/* 0xA4 */
		{ 0xE2, 0x80, 0x9E },	/* 0xA5 */
		{ 0xC2, 0xA6, 0x00 },	/* 0xA6 */
		{ 0xC2, 0xA7, 0x00 },	/* 0xA7 */
		{ 0xC3, 0x98, 0x00 },	/* 0xA8 */
		{ 0xC2, 0xA9, 0x00 },	/* 0xA9 */
		{ 0xC5, 0x96, 0x00 },	/* 0xAA */
		{ 0xC2, 0xAB, 0x00 },	/* 0xAB */
		{ 0xC2, 0xAC, 0x00 },	/* 0xAC */
		{ 0xC2, 0xAD, 0x00 },	/* 0xAD */
		{ 0xC2, 0xAE, 0x00 },	/* 0xAE */
		{ 0xC3, 0x86, 0x00 },	/* 0xAF */
		{ 0xC2, 0xB0, 0x00 },	/* 0xB0 */
		{ 0xC2, 0xB1, 0x00 },	/* 0xB1 */
		{ 0xC2, 0xB2, 0x00 },	/* 0xB2 */
		{ 0xC2, 0xB3, 0x00 },	/* 0xB3 */
		{ 0xE2, 0x80, 0x9C },	/* 0xB4 */
		{ 0xC2, 0xB5, 0x00 },	/* 0xB5 */
		{ 0xC2, 0xB6, 0x00 },	/* 0xB6 */
		{ 0xC2, 0xB7, 0x00 },	/* 0xB7 */
		{ 0xC3, 0xB8, 0x00 },	/* 0xB8 */
		{ 0xC2, 0xB9, 0x00 },	/* 0xB9 */
		{ 0xC5, 0x97, 0x00 },	/* 0xBA */
		{ 0xC2, 0xBB, 0x00 },	/* 0xBB */
		{ 0xC2, 0xBC, 0x00 },	/* 0xBC */
		{ 0xC2, 0xBD, 0x00 },	/* 0xBD */
		{ 0xC2, 0xBE, 0x00 },	/* 0xBE */
		{ 0xC3, 0xA6, 0x00 },	/* 0xBF */
		{ 0xC4, 0x84, 0x00 },	/* 0xC0 */
		{ 0xC4, 0xAE, 0x00 },	/* 0xC1 */
		{ 0xC4, 0x80, 0x00 },	/* 0xC2 */
		{ 0xC4, 0x86, 0x00 },	/* 0xC3 */
		{ 0xC3, 0x84, 0x00 },	/* 0xC4 */
		{ 0xC3, 0x85, 0x00 },	/* 0xC5 */
		{ 0xC4, 0x98, 0x00 },	/* 0xC6 */
		{ 0xC4, 0x92, 0x00 },	/* 0xC7 */
		{ 0xC4, 0x8C, 0x00 },	/* 0xC8 */
		{ 0xC3, 0x89, 0x00 },	/* 0xC9 */
		{ 0xC5, 0xB9, 0x00 },	/* 0xCA */
		{ 0xC4, 0x96, 0x00 },	/* 0xCB */
		{ 0xC4, 0xA2, 0x00 },	/* 0xCC */
		{ 0xC4, 0xB6, 0x00 },	/* 0xCD */
		{ 0xC4, 0xAA, 0x00 },	/* 0xCE */
		{ 0xC4, 0xBB, 0x00 },	/* 0xCF */
		{ 0xC5, 0xA0, 0x00 },	/* 0xD0 */
		{ 0xC5, 0x83, 0x00 },	/* 0xD1 */
		{ 0xC5, 0x85, 0x00 },	/* 0xD2 */
		{ 0xC3, 0x93, 0x00 },	/* 0xD3 */
		{ 0xC5, 0x8C, 0x00 },	/* 0xD4 */
		{ 0xC3, 0x95, 0x00 },	/* 0xD5 */
		{ 0xC3, 0x96, 0x00 },	/* 0xD6 */
		{ 0xC3, 0x97, 0x00 },	/* 0xD7 */
		{ 0xC5, 0xB2, 0x00 },	/* 0xD8 */
		{ 0xC5, 0x81, 0x00 },	/* 0xD9 */
		{ 0xC5, 0x9A, 0x00 },	/* 0xDA */
		{ 0xC5, 0xAA, 0x00 },	/* 0xDB */
		{ 0xC3, 0x9C, 0x00 },	/* 0xDC */
		{ 0xC5, 0xBB, 0x00 },	/* 0xDD */
		{ 0xC5, 0xBD, 0x00 },	/* 0xDE */
		{ 0xC3, 0x9F, 0x00 },	/* 0xDF */
		{ 0xC4, 0x85, 0x00 },	/* 0xE0 */
		{ 0xC4, 0xAF, 0x00 },	/* 0xE1 */
		{ 0xC4, 0x81, 0x00 },	/* 0xE2 */
		{ 0xC4, 0x87, 0x00 },	/* 0xE3 */
		{ 0xC3, 0xA4, 0x00 },	/* 0xE4 */
		{ 0xC3, 0xA5, 0x00 },	/* 0xE5 */
		{ 0xC4, 0x99, 0x00 },	/* 0xE6 */
		{ 0xC4, 0x93, 0x00 },	/* 0xE7 */
		{ 0xC4, 0x8D, 0x00 },	/* 0xE8 */
		{ 0xC3, 0xA9, 0x00 },	/* 0xE9 */
		{ 0xC5, 0xBA, 0x00 },	/* 0xEA */
		{ 0xC4, 0x97, 0x00 },	/* 0xEB */
		{ 0xC4, 0xA3, 0x00 },	/* 0xEC */
		{ 0xC4, 0xB7, 0x00 },	/* 0xED */
		{ 0xC4, 0xAB, 0x00 },	/* 0xEE */
		{ 0xC4, 0xBC, 0x00 },	/* 0xEF */
		{ 0xC5, 0xA1, 0x00 },	/* 0xF0 */
		{ 0xC5, 0x84, 0x00 },	/* 0xF1 */
		{ 0xC5, 0x86, 0x00 },	/* 0xF2 */
		{ 0xC3, 0xB3, 0x00 },	/* 0xF3 */
		{ 0xC5, 0x8D, 0x00 },	/* 0xF4 */
		{ 0xC3, 0xB5, 0x00 },	/* 0xF5 */
		{ 0xC3, 0xB6, 0x00 },	/* 0xF6 */
		{ 0xC3, 0xB7, 0x00 },	/* 0xF7 */
		{ 0xC5, 0xB3, 0x00 },	/* 0xF8 */
		{ 0xC5, 0x82, 0x00 },	/* 0xF9 */
		{ 0xC5, 0x9B, 0x00 },	/* 0xFA */
		{ 0xC5, 0xAB, 0x00 },	/* 0xFB */
		{ 0xC3, 0xBC, 0x00 },	/* 0xFC */
		{ 0xC5, 0xBC, 0x00 },	/* 0xFD */
		{ 0xC5, 0xBE, 0x00 },	/* 0xFE */
		{ 0xE2, 0x80, 0x99 },	/* 0xFF */
	},
	{	/* KOI8-R -> UTF-8 */
		{ 0xE2, 0x94, 0x80 },	/* 0x80 */
		{ 0xE2, 0x94, 0x82 },	/* 0x81 */
		{ 0xE2, 0x94, 0x8C },	/* 0x82 */
		{ 0xE2, 0x94, 0x90 },	/* 0x83 */
		{ 0xE2, 0x94, 0x94 },	/* 0x84 */
		{ 0xE2, 0x94, 0x98 },	/* 0x85 */
		{ 0xE2, 0x94, 0x9C },	/* 0x86 */
		{ 0xE2, 0x94, 0xA4 },	/* 0x87 */
		{ 0xE2, 0x94, 0xAC },	/* 0x88 */
		{ 0xE2, 0x94, 0xB4 },	/* 0x89 */
		{ 0xE2, 0x94, 0xBC },	/* 0x8A */
		{ 0xE2, 0x96, 0x80 },	/* 0x8B */
		{ 0xE2, 0x96, 0x84 },	/* 0x8C */
		{ 0xE2, 0x96, 0x88 },	/* 0x8D */
		{ 0xE2, 0x96, 0x8C },	/* 0x8E */
		{ 0xE2, 0x96, 0x90 },	/* 0x8F */
		{ 0xE2, 0x96, 0x91 },	/* 0x90 */
		{ 0xE2, 0x96, 0x92 },	/* 0x91 */
		{ 0xE2, 0x96, 0x93 },	/* 0x92 */
		{ 0xE2, 0x8C, 0xA0 },	/* 0x93 */
		{ 0xE2, 0x96, 0xA0 },	/* 0x94 */
		{ 0xE2, 0x88, 0x99 },	/* 0x95 */
		{ 0xE2, 0x88, 0x9A },	/* 0x96 */
		{ 0xE2, 0x89, 0x88 },	/* 0x97 */
		{ 0xE2, 0x89, 0xA4 },	/* 0x98 */
		{ 0xE2, 0x89, 0xA5 },	/* 0x99 */
		{ 0xC2, 0xA0, 0x00 },	/* 0x9A */
		{ 0xE2, 0x8C, 0xA1 },	/* 0x9B */
		{ 0xC2, 0xB0, 0x00 },	/* 0x9C */
		{ 0xC2, 0xB2, 0x00 },	/* 0x9D */
		{ 0xC2, 0xB7, 0x00 },	/* 0x9E */
		{ 0xC3, 0xB7, 0x00 },	/* 0x9F */
		{ 0xE2, 0x95, 0x90 },	/* 0xA0 */
		{ 0xE2, 0x95, 0x91 },	/* 0xA1 */
		{ 0xE2, 0x95, 0x92 },	/* 0xA2 */
		{ 0xD1, 0x91, 0x00 },	/* 0xA3 */
		{ 0xE2, 0x95, 0x93 },	/* 0xA4 */
		{ 0xE2, 0x95, 0x94 },	/* 0xA5 */
		{ 0xE2, 0x95, 0x95 },	/* 0xA6 */
		{ 0xE2, 0x95, 0x96 },	/* 0xA7 */
		{ 0xE2, 0x95, 0x97 },	/* 0xA8 */
		{ 0xE2, 0x95, 0x98 },	/* 0xA9 */
		{ 0xE2, 0x95, 0x99 },	/* 0xAA */
		{ 0xE2, 0x95, 0x9A },	/* 0xAB */
		{ 0xE2, 0x95, 0x9B },	/* 0xAC */
		{ 0xE2, 0x95, 0x9C },	/* 0xAD */
		{ 0xE2, 0x95, 0x9D },	/* 0xAE */
		{ 0xE2, 0x95, 0x9E },	/* 0xAF */
		{ 0xE2, 0x95, 0x9F },	/* 0xB0 */
		{ 0xE2, 0x95, 0xA0 },	/* 0xB1 */
		{ 0xE2, 0x95, 0xA1 },	/* 0xB2 */
		{ 0xD0, 0x81, 0x00 },	/* 0xB3 */
		{ 0xE2, 0x95, 0xA2 },	/* 0xB4 */
		{ 0xE2, 0x95, 0xA3 },	/* 0xB5 */
		{ 0xE2, 0x95, 0xA4 },	/* 0xB6 */
		{ 0xE2, 0x95, 0xA5 },	/* 0xB7 */
		{ 0xE2, 0x95, 0xA6 },	/* 0xB8 */
		{ 0xE2, 0x95, 0xA7 },	/* 0xB9 */
		{ 0xE2, 0x95, 0xA8 },	/* 0xBA */
		{ 0xE2, 0x95, 0xA9 },	/* 0xBB */
		{ 0xE2, 0x95, 0xAA },	/* 0xBC */
		{ 0xE2, 0x95, 0xAB },	/* 0xBD */
		{ 0xE2, 0x95, 0xAC },	/* 0xBE */
		{ 0xC2, 0xA9, 0x00 },	/* 0xBF */
		{ 0xD1, 0x8E, 0x00 },	/* 0xC0 */
		{ 0xD0, 0xB0, 0x00 },	/* 0xC1 */
		{ 0xD0, 0xB1, 0x00 },	/* 0xC2 */
		{ 0xD1, 0x86, 0x00 },	/* 0xC3 */
		{ 0xD0, 0xB4, 0x00 },	/* 0xC4 */
		{ 0xD0, 0xB5, 0x00 },	/* 0xC5 */
		{ 0xD1, 0x84, 0x00 },	/* 0xC6 */
		{ 0xD0, 0xB3, 0x00 },	/* 0xC7 */
		{ 0xD1, 0x85, 0x00 },	/* 0xC8 */
		{ 0xD0, 0xB8, 0x00 },	/* 0xC9 */
		{ 0xD0, 0xB9, 0x00 },	/* 0xCA */
		{ 0xD0, 0xBA, 0x00 },	/* 0xCB */
		{ 0xD0, 0xBB, 0x00 },	/* 0xCC */
		{ 0xD0, 0xBC, 0x00 },	/* 0xCD */
		{ 0xD0, 0xBD, 0x00 },	/* 0xCE */
		{ 0xD0, 0xBE, 0x00 },	/* 0xCF */
		{ 0xD0, 0xBF, 0x00 },	/* 0xD0 */
		{ 0xD1, 0x8F, 0x00 },	/* 0xD1 */
		{ 0xD1, 0x80, 0x00 },	/* 0xD2 */
		{ 0xD1, 0x81, 0x00 },	/* 0xD3 */
		{ 0xD1, 0x82, 0x00 },	/* 0xD4 */
		{ 0xD1, 0x83, 0x00 },	/* 0xD5 */
		{ 0xD0, 0xB6, 0x00 },	/* 0xD6 */
		{ 0xD0, 0xB2, 0x00 },	/* 0xD7 */
		{ 0xD1, 0x8C, 0x00 },	/* 0xD8 */
		{ 0xD1, 0x8B, 0x00 },	/* 0xD9 */
		{ 0xD0, 0xB7, 0x00 },	/* 0xDA */
		{ 0xD1, 0x88, 0x00 },	/* 0xDB */
		{ 0xD1, 0x8D, 0x00 },	/* 0xDC */
		{ 0xD1, 0x89, 0x00 },	/* 0xDD */
		{ 0xD1, 0x87, 0x00 },	/* 0xDE */
		{ 0xD1, 0x8A, 0x00 },	/* 0xDF */
		{ 0xD0, 0xAE, 0x00 },	/* 0xE0 */
		{ 0xD0, 0x90, 0x00 },	/* 0xE1 */
		{ 0xD0, 0x91, 0x00 },	/* 0xE2 */
		{ 0xD0, 0xA6, 0x00 },	/* 0xE3 */
		{ 0xD0, 0x94, 0x00 },	/* 0xE4 */
		{ 0xD0, 0x95, 0x00 },	/* 0xE5 */
		{ 0xD0, 0xA4, 0x00 },	/* 0xE6 */
		{ 0xD0, 0x93, 0x00 },	/* 0xE7 */
		{ 0xD0, 0xA5, 0x00 },	/* 0xE8 */
		{ 0xD0, 0x98, 0x00 },	/* 0xE9 */
		{ 0xD0, 0x99, 0x00 },	/* 0xEA */
		{ 0xD0, 0x9A, 0x00 },	/* 0xEB */
		{ 0xD0, 0x9B, 0x00 },	/* 0xEC */
		{ 0xD0, 0x9C, 0x00 },	/* 0xED */
		{ 0xD0, 0x9D, 0x00 },	/* 0xEE */
		{ 0xD0, 0x9E, 0x00 },	/* 0xEF */
		{ 0xD0, 0x9F, 0x00 },	/* 0xF0 */
		{ 0xD0, 0xAF, 0x00 },	/* 0xF1 */
		{ 0xD0, 0xA0, 0x00 },	/* 0xF2 */
		{ 0xD0, 0xA1, 0x00 },	/* 0xF3 */
		{ 0xD0, 0xA2, 0x00 },	/* 0xF4 */
		{ 0xD0, 0xA3, 0x00 },	/* 0xF5 */
		{ 0xD0, 0x96, 0x00 },	/* 0xF6 */
		{ 0xD0, 0x92, 0x00 },	/* 0xF7 */
		{ 0xD0, 0xAC, 0x00 },	/* 0xF8 */
		{ 0xD0, 0xAB, 0x00 },	/* 0xF9 */
		{ 0xD0, 0x97, 0x00 },	/* 0xFA */
		{ 0xD0, 0xA8, 0x00 },	/* 0xFB */
		{ 0xD0, 0xAD, 0x00 },	/* 0xFC */
		{ 0xD0, 0xA9, 0x00 },	/* 0xFD */
		{ 0xD0, 0xA7, 0x00 },	/* 0xFE */
		{ 0xD0, 0xAA, 0x00 },	/* 0xFF */
	}
};

/*
 * Mapping tables from UTF-8 to CP737, CP852, CP857, CP862, CP866, CP1250,
 * CP1251, CP1253, CP1254, CP1255, CP1256, CP1257, ISO-8859-2, ISO-8859-3,
 * ISO-8859-4, ISO-8859-5, ISO-8859-6, ISO-8859-7, ISO-8859-8, ISO-8859-9,
 * ISO-8859-10, ISO-8859-11, ISO-8859-13, and KOI8-R.
 *
 * Each table is sorted with UTF-8 values to be used with binary search.
 * UTF-8 character byte values are saved at uint32_t:24 contiguously as
 * scalar values.
 */
static const kiconv_to_sb_tbl_comp_t to_sb_tbl[24][128] = {
	{	/* UTF-8 -> CP737 */
		{ 0x00C2A0, 0xFF },
		{ 0x00C2B0, 0xF8 },
		{ 0x00C2B1, 0xF1 },
		{ 0x00C2B2, 0xFD },
		{ 0x00C2B7, 0xFA },
		{ 0x00C3B7, 0xF6 },
		{ 0x00CE86, 0xEA },
		{ 0x00CE88, 0xEB },
		{ 0x00CE89, 0xEC },
		{ 0x00CE8A, 0xED },
		{ 0x00CE8C, 0xEE },
		{ 0x00CE8E, 0xEF },
		{ 0x00CE8F, 0xF0 },
		{ 0x00CE91, 0x80 },
		{ 0x00CE92, 0x81 },
		{ 0x00CE93, 0x82 },
		{ 0x00CE94, 0x83 },
		{ 0x00CE95, 0x84 },
		{ 0x00CE96, 0x85 },
		{ 0x00CE97, 0x86 },
		{ 0x00CE98, 0x87 },
		{ 0x00CE99, 0x88 },
		{ 0x00CE9A, 0x89 },
		{ 0x00CE9B, 0x8A },
		{ 0x00CE9C, 0x8B },
		{ 0x00CE9D, 0x8C },
		{ 0x00CE9E, 0x8D },
		{ 0x00CE9F, 0x8E },
		{ 0x00CEA0, 0x8F },
		{ 0x00CEA1, 0x90 },
		{ 0x00CEA3, 0x91 },
		{ 0x00CEA4, 0x92 },
		{ 0x00CEA5, 0x93 },
		{ 0x00CEA6, 0x94 },
		{ 0x00CEA7, 0x95 },
		{ 0x00CEA8, 0x96 },
		{ 0x00CEA9, 0x97 },
		{ 0x00CEAA, 0xF4 },
		{ 0x00CEAB, 0xF5 },
		{ 0x00CEAC, 0xE1 },
		{ 0x00CEAD, 0xE2 },
		{ 0x00CEAE, 0xE3 },
		{ 0x00CEAF, 0xE5 },
		{ 0x00CEB1, 0x98 },
		{ 0x00CEB2, 0x99 },
		{ 0x00CEB3, 0x9A },
		{ 0x00CEB4, 0x9B },
		{ 0x00CEB5, 0x9C },
		{ 0x00CEB6, 0x9D },
		{ 0x00CEB7, 0x9E },
		{ 0x00CEB8, 0x9F },
		{ 0x00CEB9, 0xA0 },
		{ 0x00CEBA, 0xA1 },
		{ 0x00CEBB, 0xA2 },
		{ 0x00CEBC, 0xA3 },
		{ 0x00CEBD, 0xA4 },
		{ 0x00CEBE, 0xA5 },
		{ 0x00CEBF, 0xA6 },
		{ 0x00CF80, 0xA7 },
		{ 0x00CF81, 0xA8 },
		{ 0x00CF82, 0xAA },
		{ 0x00CF83, 0xA9 },
		{ 0x00CF84, 0xAB },
		{ 0x00CF85, 0xAC },
		{ 0x00CF86, 0xAD },
		{ 0x00CF87, 0xAE },
		{ 0x00CF88, 0xAF },
		{ 0x00CF89, 0xE0 },
		{ 0x00CF8A, 0xE4 },
		{ 0x00CF8B, 0xE8 },
		{ 0x00CF8C, 0xE6 },
		{ 0x00CF8D, 0xE7 },
		{ 0x00CF8E, 0xE9 },
		{ 0xE281BF, 0xFC },
		{ 0xE28899, 0xF9 },
		{ 0xE2889A, 0xFB },
		{ 0xE28988, 0xF7 },
		{ 0xE289A4, 0xF3 },
		{ 0xE289A5, 0xF2 },
		{ 0xE29480, 0xC4 },
		{ 0xE29482, 0xB3 },
		{ 0xE2948C, 0xDA },
		{ 0xE29490, 0xBF },
		{ 0xE29494, 0xC0 },
		{ 0xE29498, 0xD9 },
		{ 0xE2949C, 0xC3 },
		{ 0xE294A4, 0xB4 },
		{ 0xE294AC, 0xC2 },
		{ 0xE294B4, 0xC1 },
		{ 0xE294BC, 0xC5 },
		{ 0xE29590, 0xCD },
		{ 0xE29591, 0xBA },
		{ 0xE29592, 0xD5 },
		{ 0xE29593, 0xD6 },
		{ 0xE29594, 0xC9 },
		{ 0xE29595, 0xB8 },
		{ 0xE29596, 0xB7 },
		{ 0xE29597, 0xBB },
		{ 0xE29598, 0xD4 },
		{ 0xE29599, 0xD3 },
		{ 0xE2959A, 0xC8 },
		{ 0xE2959B, 0xBE },
		{ 0xE2959C, 0xBD },
		{ 0xE2959D, 0xBC },
		{ 0xE2959E, 0xC6 },
		{ 0xE2959F, 0xC7 },
		{ 0xE295A0, 0xCC },
		{ 0xE295A1, 0xB5 },
		{ 0xE295A2, 0xB6 },
		{ 0xE295A3, 0xB9 },
		{ 0xE295A4, 0xD1 },
		{ 0xE295A5, 0xD2 },
		{ 0xE295A6, 0xCB },
		{ 0xE295A7, 0xCF },
		{ 0xE295A8, 0xD0 },
		{ 0xE295A9, 0xCA },
		{ 0xE295AA, 0xD8 },
		{ 0xE295AB, 0xD7 },
		{ 0xE295AC, 0xCE },
		{ 0xE29680, 0xDF },
		{ 0xE29684, 0xDC },
		{ 0xE29688, 0xDB },
		{ 0xE2968C, 0xDD },
		{ 0xE29690, 0xDE },
		{ 0xE29691, 0xB0 },
		{ 0xE29692, 0xB1 },
		{ 0xE29693, 0xB2 },
		{ 0xE296A0, 0xFE },
	},
	{	/* UTF-8 -> CP852 */
		{ 0x00C2A0, 0xFF },
		{ 0x00C2A4, 0xCF },
		{ 0x00C2A7, 0xF5 },
		{ 0x00C2A8, 0xF9 },
		{ 0x00C2AB, 0xAE },
		{ 0x00C2AC, 0xAA },
		{ 0x00C2AD, 0xF0 },
		{ 0x00C2B0, 0xF8 },
		{ 0x00C2B4, 0xEF },
		{ 0x00C2B8, 0xF7 },
		{ 0x00C2BB, 0xAF },
		{ 0x00C381, 0xB5 },
		{ 0x00C382, 0xB6 },
		{ 0x00C384, 0x8E },
		{ 0x00C387, 0x80 },
		{ 0x00C389, 0x90 },
		{ 0x00C38B, 0xD3 },
		{ 0x00C38D, 0xD6 },
		{ 0x00C38E, 0xD7 },
		{ 0x00C393, 0xE0 },
		{ 0x00C394, 0xE2 },
		{ 0x00C396, 0x99 },
		{ 0x00C397, 0x9E },
		{ 0x00C39A, 0xE9 },
		{ 0x00C39C, 0x9A },
		{ 0x00C39D, 0xED },
		{ 0x00C39F, 0xE1 },
		{ 0x00C3A1, 0xA0 },
		{ 0x00C3A2, 0x83 },
		{ 0x00C3A4, 0x84 },
		{ 0x00C3A7, 0x87 },
		{ 0x00C3A9, 0x82 },
		{ 0x00C3AB, 0x89 },
		{ 0x00C3AD, 0xA1 },
		{ 0x00C3AE, 0x8C },
		{ 0x00C3B3, 0xA2 },
		{ 0x00C3B4, 0x93 },
		{ 0x00C3B6, 0x94 },
		{ 0x00C3B7, 0xF6 },
		{ 0x00C3BA, 0xA3 },
		{ 0x00C3BC, 0x81 },
		{ 0x00C3BD, 0xEC },
		{ 0x00C482, 0xC6 },
		{ 0x00C483, 0xC7 },
		{ 0x00C484, 0xA4 },
		{ 0x00C485, 0xA5 },
		{ 0x00C486, 0x8F },
		{ 0x00C487, 0x86 },
		{ 0x00C48C, 0xAC },
		{ 0x00C48D, 0x9F },
		{ 0x00C48E, 0xD2 },
		{ 0x00C48F, 0xD4 },
		{ 0x00C490, 0xD1 },
		{ 0x00C491, 0xD0 },
		{ 0x00C498, 0xA8 },
		{ 0x00C499, 0xA9 },
		{ 0x00C49A, 0xB7 },
		{ 0x00C49B, 0xD8 },
		{ 0x00C4B9, 0x91 },
		{ 0x00C4BA, 0x92 },
		{ 0x00C4BD, 0x95 },
		{ 0x00C4BE, 0x96 },
		{ 0x00C581, 0x9D },
		{ 0x00C582, 0x88 },
		{ 0x00C583, 0xE3 },
		{ 0x00C584, 0xE4 },
		{ 0x00C587, 0xD5 },
		{ 0x00C588, 0xE5 },
		{ 0x00C590, 0x8A },
		{ 0x00C591, 0x8B },
		{ 0x00C594, 0xE8 },
		{ 0x00C595, 0xEA },
		{ 0x00C598, 0xFC },
		{ 0x00C599, 0xFD },
		{ 0x00C59A, 0x97 },
		{ 0x00C59B, 0x98 },
		{ 0x00C59E, 0xB8 },
		{ 0x00C59F, 0xAD },
		{ 0x00C5A0, 0xE6 },
		{ 0x00C5A1, 0xE7 },
		{ 0x00C5A2, 0xDD },
		{ 0x00C5A3, 0xEE },
		{ 0x00C5A4, 0x9B },
		{ 0x00C5A5, 0x9C },
		{ 0x00C5AE, 0xDE },
		{ 0x00C5AF, 0x85 },
		{ 0x00C5B0, 0xEB },
		{ 0x00C5B1, 0xFB },
		{ 0x00C5B9, 0x8D },
		{ 0x00C5BA, 0xAB },
		{ 0x00C5BB, 0xBD },
		{ 0x00C5BC, 0xBE },
		{ 0x00C5BD, 0xA6 },
		{ 0x00C5BE, 0xA7 },
		{ 0x00CB87, 0xF3 },
		{ 0x00CB98, 0xF4 },
		{ 0x00CB99, 0xFA },
		{ 0x00CB9B, 0xF2 },
		{ 0x00CB9D, 0xF1 },
		{ 0xE29480, 0xC4 },
		{ 0xE29482, 0xB3 },
		{ 0xE2948C, 0xDA },
		{ 0xE29490, 0xBF },
		{ 0xE29494, 0xC0 },
		{ 0xE29498, 0xD9 },
		{ 0xE2949C, 0xC3 },
		{ 0xE294A4, 0xB4 },
		{ 0xE294AC, 0xC2 },
		{ 0xE294B4, 0xC1 },
		{ 0xE294BC, 0xC5 },
		{ 0xE29590, 0xCD },
		{ 0xE29591, 0xBA },
		{ 0xE29594, 0xC9 },
		{ 0xE29597, 0xBB },
		{ 0xE2959A, 0xC8 },
		{ 0xE2959D, 0xBC },
		{ 0xE295A0, 0xCC },
		{ 0xE295A3, 0xB9 },
		{ 0xE295A6, 0xCB },
		{ 0xE295A9, 0xCA },
		{ 0xE295AC, 0xCE },
		{ 0xE29680, 0xDF },
		{ 0xE29684, 0xDC },
		{ 0xE29688, 0xDB },
		{ 0xE29691, 0xB0 },
		{ 0xE29692, 0xB1 },
		{ 0xE29693, 0xB2 },
		{ 0xE296A0, 0xFE },
	},
	{	/* UTF-8 -> CP857 */
		{ 0x00C2A0, 0xFF },
		{ 0x00C2A1, 0xAD },
		{ 0x00C2A2, 0xBD },
		{ 0x00C2A3, 0x9C },
		{ 0x00C2A4, 0xCF },
		{ 0x00C2A5, 0xBE },
		{ 0x00C2A6, 0xDD },
		{ 0x00C2A7, 0xF5 },
		{ 0x00C2A8, 0xF9 },
		{ 0x00C2A9, 0xB8 },
		{ 0x00C2AA, 0xD1 },
		{ 0x00C2AB, 0xAE },
		{ 0x00C2AC, 0xAA },
		{ 0x00C2AD, 0xF0 },
		{ 0x00C2AE, 0xA9 },
		{ 0x00C2AF, 0xEE },
		{ 0x00C2B0, 0xF8 },
		{ 0x00C2B1, 0xF1 },
		{ 0x00C2B2, 0xFD },
		{ 0x00C2B3, 0xFC },
		{ 0x00C2B4, 0xEF },
		{ 0x00C2B5, 0xE6 },
		{ 0x00C2B6, 0xF4 },
		{ 0x00C2B7, 0xFA },
		{ 0x00C2B8, 0xF7 },
		{ 0x00C2B9, 0xFB },
		{ 0x00C2BA, 0xD0 },
		{ 0x00C2BB, 0xAF },
		{ 0x00C2BC, 0xAC },
		{ 0x00C2BD, 0xAB },
		{ 0x00C2BE, 0xF3 },
		{ 0x00C2BF, 0xA8 },
		{ 0x00C380, 0xB7 },
		{ 0x00C381, 0xB5 },
		{ 0x00C382, 0xB6 },
		{ 0x00C383, 0xC7 },
		{ 0x00C384, 0x8E },
		{ 0x00C385, 0x8F },
		{ 0x00C386, 0x92 },
		{ 0x00C387, 0x80 },
		{ 0x00C388, 0xD4 },
		{ 0x00C389, 0x90 },
		{ 0x00C38A, 0xD2 },
		{ 0x00C38B, 0xD3 },
		{ 0x00C38C, 0xDE },
		{ 0x00C38D, 0xD6 },
		{ 0x00C38E, 0xD7 },
		{ 0x00C38F, 0xD8 },
		{ 0x00C391, 0xA5 },
		{ 0x00C392, 0xE3 },
		{ 0x00C393, 0xE0 },
		{ 0x00C394, 0xE2 },
		{ 0x00C395, 0xE5 },
		{ 0x00C396, 0x99 },
		{ 0x00C397, 0xE8 },
		{ 0x00C398, 0x9D },
		{ 0x00C399, 0xEB },
		{ 0x00C39A, 0xE9 },
		{ 0x00C39B, 0xEA },
		{ 0x00C39C, 0x9A },
		{ 0x00C39F, 0xE1 },
		{ 0x00C3A0, 0x85 },
		{ 0x00C3A1, 0xA0 },
		{ 0x00C3A2, 0x83 },
		{ 0x00C3A3, 0xC6 },
		{ 0x00C3A4, 0x84 },
		{ 0x00C3A5, 0x86 },
		{ 0x00C3A6, 0x91 },
		{ 0x00C3A7, 0x87 },
		{ 0x00C3A8, 0x8A },
		{ 0x00C3A9, 0x82 },
		{ 0x00C3AA, 0x88 },
		{ 0x00C3AB, 0x89 },
		{ 0x00C3AC, 0xEC },
		{ 0x00C3AD, 0xA1 },
		{ 0x00C3AE, 0x8C },
		{ 0x00C3AF, 0x8B },
		{ 0x00C3B1, 0xA4 },
		{ 0x00C3B2, 0x95 },
		{ 0x00C3B3, 0xA2 },
		{ 0x00C3B4, 0x93 },
		{ 0x00C3B5, 0xE4 },
		{ 0x00C3B6, 0x94 },
		{ 0x00C3B7, 0xF6 },
		{ 0x00C3B8, 0x9B },
		{ 0x00C3B9, 0x97 },
		{ 0x00C3BA, 0xA3 },
		{ 0x00C3BB, 0x96 },
		{ 0x00C3BC, 0x81 },
		{ 0x00C3BF, 0xED },
		{ 0x00C49E, 0xA6 },
		{ 0x00C49F, 0xA7 },
		{ 0x00C4B0, 0x98 },
		{ 0x00C4B1, 0x8D },
		{ 0x00C59E, 0x9E },
		{ 0x00C59F, 0x9F },
		{ 0xE29480, 0xC4 },
		{ 0xE29482, 0xB3 },
		{ 0xE2948C, 0xDA },
		{ 0xE29490, 0xBF },
		{ 0xE29494, 0xC0 },
		{ 0xE29498, 0xD9 },
		{ 0xE2949C, 0xC3 },
		{ 0xE294A4, 0xB4 },
		{ 0xE294AC, 0xC2 },
		{ 0xE294B4, 0xC1 },
		{ 0xE294BC, 0xC5 },
		{ 0xE29590, 0xCD },
		{ 0xE29591, 0xBA },
		{ 0xE29594, 0xC9 },
		{ 0xE29597, 0xBB },
		{ 0xE2959A, 0xC8 },
		{ 0xE2959D, 0xBC },
		{ 0xE295A0, 0xCC },
		{ 0xE295A3, 0xB9 },
		{ 0xE295A6, 0xCB },
		{ 0xE295A9, 0xCA },
		{ 0xE295AC, 0xCE },
		{ 0xE29680, 0xDF },
		{ 0xE29684, 0xDC },
		{ 0xE29688, 0xDB },
		{ 0xE29691, 0xB0 },
		{ 0xE29692, 0xB1 },
		{ 0xE29693, 0xB2 },
		{ 0xE296A0, 0xFE },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
	},
	{	/* UTF-8 -> CP862 */
		{ 0x00C2A0, 0xFF },
		{ 0x00C2A1, 0xAD },
		{ 0x00C2A2, 0x9B },
		{ 0x00C2A3, 0x9C },
		{ 0x00C2A5, 0x9D },
		{ 0x00C2AA, 0xA6 },
		{ 0x00C2AB, 0xAE },
		{ 0x00C2AC, 0xAA },
		{ 0x00C2B0, 0xF8 },
		{ 0x00C2B1, 0xF1 },
		{ 0x00C2B2, 0xFD },
		{ 0x00C2B5, 0xE6 },
		{ 0x00C2B7, 0xFA },
		{ 0x00C2BA, 0xA7 },
		{ 0x00C2BB, 0xAF },
		{ 0x00C2BC, 0xAC },
		{ 0x00C2BD, 0xAB },
		{ 0x00C2BF, 0xA8 },
		{ 0x00C391, 0xA5 },
		{ 0x00C39F, 0xE1 },
		{ 0x00C3A1, 0xA0 },
		{ 0x00C3AD, 0xA1 },
		{ 0x00C3B1, 0xA4 },
		{ 0x00C3B3, 0xA2 },
		{ 0x00C3B7, 0xF6 },
		{ 0x00C3BA, 0xA3 },
		{ 0x00C692, 0x9F },
		{ 0x00CE93, 0xE2 },
		{ 0x00CE98, 0xE9 },
		{ 0x00CEA3, 0xE4 },
		{ 0x00CEA6, 0xE8 },
		{ 0x00CEA9, 0xEA },
		{ 0x00CEB1, 0xE0 },
		{ 0x00CEB4, 0xEB },
		{ 0x00CEB5, 0xEE },
		{ 0x00CF80, 0xE3 },
		{ 0x00CF83, 0xE5 },
		{ 0x00CF84, 0xE7 },
		{ 0x00CF86, 0xED },
		{ 0x00D790, 0x80 },
		{ 0x00D791, 0x81 },
		{ 0x00D792, 0x82 },
		{ 0x00D793, 0x83 },
		{ 0x00D794, 0x84 },
		{ 0x00D795, 0x85 },
		{ 0x00D796, 0x86 },
		{ 0x00D797, 0x87 },
		{ 0x00D798, 0x88 },
		{ 0x00D799, 0x89 },
		{ 0x00D79A, 0x8A },
		{ 0x00D79B, 0x8B },
		{ 0x00D79C, 0x8C },
		{ 0x00D79D, 0x8D },
		{ 0x00D79E, 0x8E },
		{ 0x00D79F, 0x8F },
		{ 0x00D7A0, 0x90 },
		{ 0x00D7A1, 0x91 },
		{ 0x00D7A2, 0x92 },
		{ 0x00D7A3, 0x93 },
		{ 0x00D7A4, 0x94 },
		{ 0x00D7A5, 0x95 },
		{ 0x00D7A6, 0x96 },
		{ 0x00D7A7, 0x97 },
		{ 0x00D7A8, 0x98 },
		{ 0x00D7A9, 0x99 },
		{ 0x00D7AA, 0x9A },
		{ 0xE281BF, 0xFC },
		{ 0xE282A7, 0x9E },
		{ 0xE28899, 0xF9 },
		{ 0xE2889A, 0xFB },
		{ 0xE2889E, 0xEC },
		{ 0xE288A9, 0xEF },
		{ 0xE28988, 0xF7 },
		{ 0xE289A1, 0xF0 },
		{ 0xE289A4, 0xF3 },
		{ 0xE289A5, 0xF2 },
		{ 0xE28C90, 0xA9 },
		{ 0xE28CA0, 0xF4 },
		{ 0xE28CA1, 0xF5 },
		{ 0xE29480, 0xC4 },
		{ 0xE29482, 0xB3 },
		{ 0xE2948C, 0xDA },
		{ 0xE29490, 0xBF },
		{ 0xE29494, 0xC0 },
		{ 0xE29498, 0xD9 },
		{ 0xE2949C, 0xC3 },
		{ 0xE294A4, 0xB4 },
		{ 0xE294AC, 0xC2 },
		{ 0xE294B4, 0xC1 },
		{ 0xE294BC, 0xC5 },
		{ 0xE29590, 0xCD },
		{ 0xE29591, 0xBA },
		{ 0xE29592, 0xD5 },
		{ 0xE29593, 0xD6 },
		{ 0xE29594, 0xC9 },
		{ 0xE29595, 0xB8 },
		{ 0xE29596, 0xB7 },
		{ 0xE29597, 0xBB },
		{ 0xE29598, 0xD4 },
		{ 0xE29599, 0xD3 },
		{ 0xE2959A, 0xC8 },
		{ 0xE2959B, 0xBE },
		{ 0xE2959C, 0xBD },
		{ 0xE2959D, 0xBC },
		{ 0xE2959E, 0xC6 },
		{ 0xE2959F, 0xC7 },
		{ 0xE295A0, 0xCC },
		{ 0xE295A1, 0xB5 },
		{ 0xE295A2, 0xB6 },
		{ 0xE295A3, 0xB9 },
		{ 0xE295A4, 0xD1 },
		{ 0xE295A5, 0xD2 },
		{ 0xE295A6, 0xCB },
		{ 0xE295A7, 0xCF },
		{ 0xE295A8, 0xD0 },
		{ 0xE295A9, 0xCA },
		{ 0xE295AA, 0xD8 },
		{ 0xE295AB, 0xD7 },
		{ 0xE295AC, 0xCE },
		{ 0xE29680, 0xDF },
		{ 0xE29684, 0xDC },
		{ 0xE29688, 0xDB },
		{ 0xE2968C, 0xDD },
		{ 0xE29690, 0xDE },
		{ 0xE29691, 0xB0 },
		{ 0xE29692, 0xB1 },
		{ 0xE29693, 0xB2 },
		{ 0xE296A0, 0xFE },
	},
	{	/* UTF-8 -> CP866 */
		{ 0x00C2A0, 0xFF },
		{ 0x00C2A4, 0xFD },
		{ 0x00C2B0, 0xF8 },
		{ 0x00C2B7, 0xFA },
		{ 0x00D081, 0xF0 },
		{ 0x00D084, 0xF2 },
		{ 0x00D087, 0xF4 },
		{ 0x00D08E, 0xF6 },
		{ 0x00D090, 0x80 },
		{ 0x00D091, 0x81 },
		{ 0x00D092, 0x82 },
		{ 0x00D093, 0x83 },
		{ 0x00D094, 0x84 },
		{ 0x00D095, 0x85 },
		{ 0x00D096, 0x86 },
		{ 0x00D097, 0x87 },
		{ 0x00D098, 0x88 },
		{ 0x00D099, 0x89 },
		{ 0x00D09A, 0x8A },
		{ 0x00D09B, 0x8B },
		{ 0x00D09C, 0x8C },
		{ 0x00D09D, 0x8D },
		{ 0x00D09E, 0x8E },
		{ 0x00D09F, 0x8F },
		{ 0x00D0A0, 0x90 },
		{ 0x00D0A1, 0x91 },
		{ 0x00D0A2, 0x92 },
		{ 0x00D0A3, 0x93 },
		{ 0x00D0A4, 0x94 },
		{ 0x00D0A5, 0x95 },
		{ 0x00D0A6, 0x96 },
		{ 0x00D0A7, 0x97 },
		{ 0x00D0A8, 0x98 },
		{ 0x00D0A9, 0x99 },
		{ 0x00D0AA, 0x9A },
		{ 0x00D0AB, 0x9B },
		{ 0x00D0AC, 0x9C },
		{ 0x00D0AD, 0x9D },
		{ 0x00D0AE, 0x9E },
		{ 0x00D0AF, 0x9F },
		{ 0x00D0B0, 0xA0 },
		{ 0x00D0B1, 0xA1 },
		{ 0x00D0B2, 0xA2 },
		{ 0x00D0B3, 0xA3 },
		{ 0x00D0B4, 0xA4 },
		{ 0x00D0B5, 0xA5 },
		{ 0x00D0B6, 0xA6 },
		{ 0x00D0B7, 0xA7 },
		{ 0x00D0B8, 0xA8 },
		{ 0x00D0B9, 0xA9 },
		{ 0x00D0BA, 0xAA },
		{ 0x00D0BB, 0xAB },
		{ 0x00D0BC, 0xAC },
		{ 0x00D0BD, 0xAD },
		{ 0x00D0BE, 0xAE },
		{ 0x00D0BF, 0xAF },
		{ 0x00D180, 0xE0 },
		{ 0x00D181, 0xE1 },
		{ 0x00D182, 0xE2 },
		{ 0x00D183, 0xE3 },
		{ 0x00D184, 0xE4 },
		{ 0x00D185, 0xE5 },
		{ 0x00D186, 0xE6 },
		{ 0x00D187, 0xE7 },
		{ 0x00D188, 0xE8 },
		{ 0x00D189, 0xE9 },
		{ 0x00D18A, 0xEA },
		{ 0x00D18B, 0xEB },
		{ 0x00D18C, 0xEC },
		{ 0x00D18D, 0xED },
		{ 0x00D18E, 0xEE },
		{ 0x00D18F, 0xEF },
		{ 0x00D191, 0xF1 },
		{ 0x00D194, 0xF3 },
		{ 0x00D197, 0xF5 },
		{ 0x00D19E, 0xF7 },
		{ 0xE28496, 0xFC },
		{ 0xE28899, 0xF9 },
		{ 0xE2889A, 0xFB },
		{ 0xE29480, 0xC4 },
		{ 0xE29482, 0xB3 },
		{ 0xE2948C, 0xDA },
		{ 0xE29490, 0xBF },
		{ 0xE29494, 0xC0 },
		{ 0xE29498, 0xD9 },
		{ 0xE2949C, 0xC3 },
		{ 0xE294A4, 0xB4 },
		{ 0xE294AC, 0xC2 },
		{ 0xE294B4, 0xC1 },
		{ 0xE294BC, 0xC5 },
		{ 0xE29590, 0xCD },
		{ 0xE29591, 0xBA },
		{ 0xE29592, 0xD5 },
		{ 0xE29593, 0xD6 },
		{ 0xE29594, 0xC9 },
		{ 0xE29595, 0xB8 },
		{ 0xE29596, 0xB7 },
		{ 0xE29597, 0xBB },
		{ 0xE29598, 0xD4 },
		{ 0xE29599, 0xD3 },
		{ 0xE2959A, 0xC8 },
		{ 0xE2959B, 0xBE },
		{ 0xE2959C, 0xBD },
		{ 0xE2959D, 0xBC },
		{ 0xE2959E, 0xC6 },
		{ 0xE2959F, 0xC7 },
		{ 0xE295A0, 0xCC },
		{ 0xE295A1, 0xB5 },
		{ 0xE295A2, 0xB6 },
		{ 0xE295A3, 0xB9 },
		{ 0xE295A4, 0xD1 },
		{ 0xE295A5, 0xD2 },
		{ 0xE295A6, 0xCB },
		{ 0xE295A7, 0xCF },
		{ 0xE295A8, 0xD0 },
		{ 0xE295A9, 0xCA },
		{ 0xE295AA, 0xD8 },
		{ 0xE295AB, 0xD7 },
		{ 0xE295AC, 0xCE },
		{ 0xE29680, 0xDF },
		{ 0xE29684, 0xDC },
		{ 0xE29688, 0xDB },
		{ 0xE2968C, 0xDD },
		{ 0xE29690, 0xDE },
		{ 0xE29691, 0xB0 },
		{ 0xE29692, 0xB1 },
		{ 0xE29693, 0xB2 },
		{ 0xE296A0, 0xFE },
	},
	{	/* UTF-8 -> CP1250 */
		{ 0x00C2A0, 0xA0 },
		{ 0x00C2A4, 0xA4 },
		{ 0x00C2A6, 0xA6 },
		{ 0x00C2A7, 0xA7 },
		{ 0x00C2A8, 0xA8 },
		{ 0x00C2A9, 0xA9 },
		{ 0x00C2AB, 0xAB },
		{ 0x00C2AC, 0xAC },
		{ 0x00C2AD, 0xAD },
		{ 0x00C2AE, 0xAE },
		{ 0x00C2B0, 0xB0 },
		{ 0x00C2B1, 0xB1 },
		{ 0x00C2B4, 0xB4 },
		{ 0x00C2B5, 0xB5 },
		{ 0x00C2B6, 0xB6 },
		{ 0x00C2B7, 0xB7 },
		{ 0x00C2B8, 0xB8 },
		{ 0x00C2BB, 0xBB },
		{ 0x00C381, 0xC1 },
		{ 0x00C382, 0xC2 },
		{ 0x00C384, 0xC4 },
		{ 0x00C387, 0xC7 },
		{ 0x00C389, 0xC9 },
		{ 0x00C38B, 0xCB },
		{ 0x00C38D, 0xCD },
		{ 0x00C38E, 0xCE },
		{ 0x00C393, 0xD3 },
		{ 0x00C394, 0xD4 },
		{ 0x00C396, 0xD6 },
		{ 0x00C397, 0xD7 },
		{ 0x00C39A, 0xDA },
		{ 0x00C39C, 0xDC },
		{ 0x00C39D, 0xDD },
		{ 0x00C39F, 0xDF },
		{ 0x00C3A1, 0xE1 },
		{ 0x00C3A2, 0xE2 },
		{ 0x00C3A4, 0xE4 },
		{ 0x00C3A7, 0xE7 },
		{ 0x00C3A9, 0xE9 },
		{ 0x00C3AB, 0xEB },
		{ 0x00C3AD, 0xED },
		{ 0x00C3AE, 0xEE },
		{ 0x00C3B3, 0xF3 },
		{ 0x00C3B4, 0xF4 },
		{ 0x00C3B6, 0xF6 },
		{ 0x00C3B7, 0xF7 },
		{ 0x00C3BA, 0xFA },
		{ 0x00C3BC, 0xFC },
		{ 0x00C3BD, 0xFD },
		{ 0x00C482, 0xC3 },
		{ 0x00C483, 0xE3 },
		{ 0x00C484, 0xA5 },
		{ 0x00C485, 0xB9 },
		{ 0x00C486, 0xC6 },
		{ 0x00C487, 0xE6 },
		{ 0x00C48C, 0xC8 },
		{ 0x00C48D, 0xE8 },
		{ 0x00C48E, 0xCF },
		{ 0x00C48F, 0xEF },
		{ 0x00C490, 0xD0 },
		{ 0x00C491, 0xF0 },
		{ 0x00C498, 0xCA },
		{ 0x00C499, 0xEA },
		{ 0x00C49A, 0xCC },
		{ 0x00C49B, 0xEC },
		{ 0x00C4B9, 0xC5 },
		{ 0x00C4BA, 0xE5 },
		{ 0x00C4BD, 0xBC },
		{ 0x00C4BE, 0xBE },
		{ 0x00C581, 0xA3 },
		{ 0x00C582, 0xB3 },
		{ 0x00C583, 0xD1 },
		{ 0x00C584, 0xF1 },
		{ 0x00C587, 0xD2 },
		{ 0x00C588, 0xF2 },
		{ 0x00C590, 0xD5 },
		{ 0x00C591, 0xF5 },
		{ 0x00C594, 0xC0 },
		{ 0x00C595, 0xE0 },
		{ 0x00C598, 0xD8 },
		{ 0x00C599, 0xF8 },
		{ 0x00C59A, 0x8C },
		{ 0x00C59B, 0x9C },
		{ 0x00C59E, 0xAA },
		{ 0x00C59F, 0xBA },
		{ 0x00C5A0, 0x8A },
		{ 0x00C5A1, 0x9A },
		{ 0x00C5A2, 0xDE },
		{ 0x00C5A3, 0xFE },
		{ 0x00C5A4, 0x8D },
		{ 0x00C5A5, 0x9D },
		{ 0x00C5AE, 0xD9 },
		{ 0x00C5AF, 0xF9 },
		{ 0x00C5B0, 0xDB },
		{ 0x00C5B1, 0xFB },
		{ 0x00C5B9, 0x8F },
		{ 0x00C5BA, 0x9F },
		{ 0x00C5BB, 0xAF },
		{ 0x00C5BC, 0xBF },
		{ 0x00C5BD, 0x8E },
		{ 0x00C5BE, 0x9E },
		{ 0x00CB87, 0xA1 },
		{ 0x00CB98, 0xA2 },
		{ 0x00CB99, 0xFF },
		{ 0x00CB9B, 0xB2 },
		{ 0x00CB9D, 0xBD },
		{ 0xE28093, 0x96 },
		{ 0xE28094, 0x97 },
		{ 0xE28098, 0x91 },
		{ 0xE28099, 0x92 },
		{ 0xE2809A, 0x82 },
		{ 0xE2809C, 0x93 },
		{ 0xE2809D, 0x94 },
		{ 0xE2809E, 0x84 },
		{ 0xE280A0, 0x86 },
		{ 0xE280A1, 0x87 },
		{ 0xE280A2, 0x95 },
		{ 0xE280A6, 0x85 },
		{ 0xE280B0, 0x89 },
		{ 0xE280B9, 0x8B },
		{ 0xE280BA, 0x9B },
		{ 0xE282AC, 0x80 },
		{ 0xE284A2, 0x99 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
	},
	{	/* UTF-8 -> CP1251 */
		{ 0x00C2A0, 0xA0 },
		{ 0x00C2A4, 0xA4 },
		{ 0x00C2A6, 0xA6 },
		{ 0x00C2A7, 0xA7 },
		{ 0x00C2A9, 0xA9 },
		{ 0x00C2AB, 0xAB },
		{ 0x00C2AC, 0xAC },
		{ 0x00C2AD, 0xAD },
		{ 0x00C2AE, 0xAE },
		{ 0x00C2B0, 0xB0 },
		{ 0x00C2B1, 0xB1 },
		{ 0x00C2B5, 0xB5 },
		{ 0x00C2B6, 0xB6 },
		{ 0x00C2B7, 0xB7 },
		{ 0x00C2BB, 0xBB },
		{ 0x00D081, 0xA8 },
		{ 0x00D082, 0x80 },
		{ 0x00D083, 0x81 },
		{ 0x00D084, 0xAA },
		{ 0x00D085, 0xBD },
		{ 0x00D086, 0xB2 },
		{ 0x00D087, 0xAF },
		{ 0x00D088, 0xA3 },
		{ 0x00D089, 0x8A },
		{ 0x00D08A, 0x8C },
		{ 0x00D08B, 0x8E },
		{ 0x00D08C, 0x8D },
		{ 0x00D08E, 0xA1 },
		{ 0x00D08F, 0x8F },
		{ 0x00D090, 0xC0 },
		{ 0x00D091, 0xC1 },
		{ 0x00D092, 0xC2 },
		{ 0x00D093, 0xC3 },
		{ 0x00D094, 0xC4 },
		{ 0x00D095, 0xC5 },
		{ 0x00D096, 0xC6 },
		{ 0x00D097, 0xC7 },
		{ 0x00D098, 0xC8 },
		{ 0x00D099, 0xC9 },
		{ 0x00D09A, 0xCA },
		{ 0x00D09B, 0xCB },
		{ 0x00D09C, 0xCC },
		{ 0x00D09D, 0xCD },
		{ 0x00D09E, 0xCE },
		{ 0x00D09F, 0xCF },
		{ 0x00D0A0, 0xD0 },
		{ 0x00D0A1, 0xD1 },
		{ 0x00D0A2, 0xD2 },
		{ 0x00D0A3, 0xD3 },
		{ 0x00D0A4, 0xD4 },
		{ 0x00D0A5, 0xD5 },
		{ 0x00D0A6, 0xD6 },
		{ 0x00D0A7, 0xD7 },
		{ 0x00D0A8, 0xD8 },
		{ 0x00D0A9, 0xD9 },
		{ 0x00D0AA, 0xDA },
		{ 0x00D0AB, 0xDB },
		{ 0x00D0AC, 0xDC },
		{ 0x00D0AD, 0xDD },
		{ 0x00D0AE, 0xDE },
		{ 0x00D0AF, 0xDF },
		{ 0x00D0B0, 0xE0 },
		{ 0x00D0B1, 0xE1 },
		{ 0x00D0B2, 0xE2 },
		{ 0x00D0B3, 0xE3 },
		{ 0x00D0B4, 0xE4 },
		{ 0x00D0B5, 0xE5 },
		{ 0x00D0B6, 0xE6 },
		{ 0x00D0B7, 0xE7 },
		{ 0x00D0B8, 0xE8 },
		{ 0x00D0B9, 0xE9 },
		{ 0x00D0BA, 0xEA },
		{ 0x00D0BB, 0xEB },
		{ 0x00D0BC, 0xEC },
		{ 0x00D0BD, 0xED },
		{ 0x00D0BE, 0xEE },
		{ 0x00D0BF, 0xEF },
		{ 0x00D180, 0xF0 },
		{ 0x00D181, 0xF1 },
		{ 0x00D182, 0xF2 },
		{ 0x00D183, 0xF3 },
		{ 0x00D184, 0xF4 },
		{ 0x00D185, 0xF5 },
		{ 0x00D186, 0xF6 },
		{ 0x00D187, 0xF7 },
		{ 0x00D188, 0xF8 },
		{ 0x00D189, 0xF9 },
		{ 0x00D18A, 0xFA },
		{ 0x00D18B, 0xFB },
		{ 0x00D18C, 0xFC },
		{ 0x00D18D, 0xFD },
		{ 0x00D18E, 0xFE },
		{ 0x00D18F, 0xFF },
		{ 0x00D191, 0xB8 },
		{ 0x00D192, 0x90 },
		{ 0x00D193, 0x83 },
		{ 0x00D194, 0xBA },
		{ 0x00D195, 0xBE },
		{ 0x00D196, 0xB3 },
		{ 0x00D197, 0xBF },
		{ 0x00D198, 0xBC },
		{ 0x00D199, 0x9A },
		{ 0x00D19A, 0x9C },
		{ 0x00D19B, 0x9E },
		{ 0x00D19C, 0x9D },
		{ 0x00D19E, 0xA2 },
		{ 0x00D19F, 0x9F },
		{ 0x00D290, 0xA5 },
		{ 0x00D291, 0xB4 },
		{ 0xE28093, 0x96 },
		{ 0xE28094, 0x97 },
		{ 0xE28098, 0x91 },
		{ 0xE28099, 0x92 },
		{ 0xE2809A, 0x82 },
		{ 0xE2809C, 0x93 },
		{ 0xE2809D, 0x94 },
		{ 0xE2809E, 0x84 },
		{ 0xE280A0, 0x86 },
		{ 0xE280A1, 0x87 },
		{ 0xE280A2, 0x95 },
		{ 0xE280A6, 0x85 },
		{ 0xE280B0, 0x89 },
		{ 0xE280B9, 0x8B },
		{ 0xE280BA, 0x9B },
		{ 0xE282AC, 0x88 },
		{ 0xE28496, 0xB9 },
		{ 0xE284A2, 0x99 },
		{ 0xFFFFFF, 0x00 },
	},
	{	/* UTF-8 -> CP1253 */
		{ 0x00C2A0, 0xA0 },
		{ 0x00C2A3, 0xA3 },
		{ 0x00C2A4, 0xA4 },
		{ 0x00C2A5, 0xA5 },
		{ 0x00C2A6, 0xA6 },
		{ 0x00C2A7, 0xA7 },
		{ 0x00C2A8, 0xA8 },
		{ 0x00C2A9, 0xA9 },
		{ 0x00C2AB, 0xAB },
		{ 0x00C2AC, 0xAC },
		{ 0x00C2AD, 0xAD },
		{ 0x00C2AE, 0xAE },
		{ 0x00C2B0, 0xB0 },
		{ 0x00C2B1, 0xB1 },
		{ 0x00C2B2, 0xB2 },
		{ 0x00C2B3, 0xB3 },
		{ 0x00C2B5, 0xB5 },
		{ 0x00C2B6, 0xB6 },
		{ 0x00C2B7, 0xB7 },
		{ 0x00C2BB, 0xBB },
		{ 0x00C2BD, 0xBD },
		{ 0x00C692, 0x83 },
		{ 0x00CE84, 0xB4 },
		{ 0x00CE85, 0xA1 },
		{ 0x00CE86, 0xA2 },
		{ 0x00CE88, 0xB8 },
		{ 0x00CE89, 0xB9 },
		{ 0x00CE8A, 0xBA },
		{ 0x00CE8C, 0xBC },
		{ 0x00CE8E, 0xBE },
		{ 0x00CE8F, 0xBF },
		{ 0x00CE90, 0xC0 },
		{ 0x00CE91, 0xC1 },
		{ 0x00CE92, 0xC2 },
		{ 0x00CE93, 0xC3 },
		{ 0x00CE94, 0xC4 },
		{ 0x00CE95, 0xC5 },
		{ 0x00CE96, 0xC6 },
		{ 0x00CE97, 0xC7 },
		{ 0x00CE98, 0xC8 },
		{ 0x00CE99, 0xC9 },
		{ 0x00CE9A, 0xCA },
		{ 0x00CE9B, 0xCB },
		{ 0x00CE9C, 0xCC },
		{ 0x00CE9D, 0xCD },
		{ 0x00CE9E, 0xCE },
		{ 0x00CE9F, 0xCF },
		{ 0x00CEA0, 0xD0 },
		{ 0x00CEA1, 0xD1 },
		{ 0x00CEA3, 0xD3 },
		{ 0x00CEA4, 0xD4 },
		{ 0x00CEA5, 0xD5 },
		{ 0x00CEA6, 0xD6 },
		{ 0x00CEA7, 0xD7 },
		{ 0x00CEA8, 0xD8 },
		{ 0x00CEA9, 0xD9 },
		{ 0x00CEAA, 0xDA },
		{ 0x00CEAB, 0xDB },
		{ 0x00CEAC, 0xDC },
		{ 0x00CEAD, 0xDD },
		{ 0x00CEAE, 0xDE },
		{ 0x00CEAF, 0xDF },
		{ 0x00CEB0, 0xE0 },
		{ 0x00CEB1, 0xE1 },
		{ 0x00CEB2, 0xE2 },
		{ 0x00CEB3, 0xE3 },
		{ 0x00CEB4, 0xE4 },
		{ 0x00CEB5, 0xE5 },
		{ 0x00CEB6, 0xE6 },
		{ 0x00CEB7, 0xE7 },
		{ 0x00CEB8, 0xE8 },
		{ 0x00CEB9, 0xE9 },
		{ 0x00CEBA, 0xEA },
		{ 0x00CEBB, 0xEB },
		{ 0x00CEBC, 0xEC },
		{ 0x00CEBD, 0xED },
		{ 0x00CEBE, 0xEE },
		{ 0x00CEBF, 0xEF },
		{ 0x00CF80, 0xF0 },
		{ 0x00CF81, 0xF1 },
		{ 0x00CF82, 0xF2 },
		{ 0x00CF83, 0xF3 },
		{ 0x00CF84, 0xF4 },
		{ 0x00CF85, 0xF5 },
		{ 0x00CF86, 0xF6 },
		{ 0x00CF87, 0xF7 },
		{ 0x00CF88, 0xF8 },
		{ 0x00CF89, 0xF9 },
		{ 0x00CF8A, 0xFA },
		{ 0x00CF8B, 0xFB },
		{ 0x00CF8C, 0xFC },
		{ 0x00CF8D, 0xFD },
		{ 0x00CF8E, 0xFE },
		{ 0xE28093, 0x96 },
		{ 0xE28094, 0x97 },
		{ 0xE28095, 0xAF },
		{ 0xE28098, 0x91 },
		{ 0xE28099, 0x92 },
		{ 0xE2809A, 0x82 },
		{ 0xE2809C, 0x93 },
		{ 0xE2809D, 0x94 },
		{ 0xE2809E, 0x84 },
		{ 0xE280A0, 0x86 },
		{ 0xE280A1, 0x87 },
		{ 0xE280A2, 0x95 },
		{ 0xE280A6, 0x85 },
		{ 0xE280B0, 0x89 },
		{ 0xE280B9, 0x8B },
		{ 0xE280BA, 0x9B },
		{ 0xE282AC, 0x80 },
		{ 0xE284A2, 0x99 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
	},
	{	/* UTF-8 -> CP1254 */
		{ 0x00C2A0, 0xA0 },
		{ 0x00C2A1, 0xA1 },
		{ 0x00C2A2, 0xA2 },
		{ 0x00C2A3, 0xA3 },
		{ 0x00C2A4, 0xA4 },
		{ 0x00C2A5, 0xA5 },
		{ 0x00C2A6, 0xA6 },
		{ 0x00C2A7, 0xA7 },
		{ 0x00C2A8, 0xA8 },
		{ 0x00C2A9, 0xA9 },
		{ 0x00C2AA, 0xAA },
		{ 0x00C2AB, 0xAB },
		{ 0x00C2AC, 0xAC },
		{ 0x00C2AD, 0xAD },
		{ 0x00C2AE, 0xAE },
		{ 0x00C2AF, 0xAF },
		{ 0x00C2B0, 0xB0 },
		{ 0x00C2B1, 0xB1 },
		{ 0x00C2B2, 0xB2 },
		{ 0x00C2B3, 0xB3 },
		{ 0x00C2B4, 0xB4 },
		{ 0x00C2B5, 0xB5 },
		{ 0x00C2B6, 0xB6 },
		{ 0x00C2B7, 0xB7 },
		{ 0x00C2B8, 0xB8 },
		{ 0x00C2B9, 0xB9 },
		{ 0x00C2BA, 0xBA },
		{ 0x00C2BB, 0xBB },
		{ 0x00C2BC, 0xBC },
		{ 0x00C2BD, 0xBD },
		{ 0x00C2BE, 0xBE },
		{ 0x00C2BF, 0xBF },
		{ 0x00C380, 0xC0 },
		{ 0x00C381, 0xC1 },
		{ 0x00C382, 0xC2 },
		{ 0x00C383, 0xC3 },
		{ 0x00C384, 0xC4 },
		{ 0x00C385, 0xC5 },
		{ 0x00C386, 0xC6 },
		{ 0x00C387, 0xC7 },
		{ 0x00C388, 0xC8 },
		{ 0x00C389, 0xC9 },
		{ 0x00C38A, 0xCA },
		{ 0x00C38B, 0xCB },
		{ 0x00C38C, 0xCC },
		{ 0x00C38D, 0xCD },
		{ 0x00C38E, 0xCE },
		{ 0x00C38F, 0xCF },
		{ 0x00C391, 0xD1 },
		{ 0x00C392, 0xD2 },
		{ 0x00C393, 0xD3 },
		{ 0x00C394, 0xD4 },
		{ 0x00C395, 0xD5 },
		{ 0x00C396, 0xD6 },
		{ 0x00C397, 0xD7 },
		{ 0x00C398, 0xD8 },
		{ 0x00C399, 0xD9 },
		{ 0x00C39A, 0xDA },
		{ 0x00C39B, 0xDB },
		{ 0x00C39C, 0xDC },
		{ 0x00C39F, 0xDF },
		{ 0x00C3A0, 0xE0 },
		{ 0x00C3A1, 0xE1 },
		{ 0x00C3A2, 0xE2 },
		{ 0x00C3A3, 0xE3 },
		{ 0x00C3A4, 0xE4 },
		{ 0x00C3A5, 0xE5 },
		{ 0x00C3A6, 0xE6 },
		{ 0x00C3A7, 0xE7 },
		{ 0x00C3A8, 0xE8 },
		{ 0x00C3A9, 0xE9 },
		{ 0x00C3AA, 0xEA },
		{ 0x00C3AB, 0xEB },
		{ 0x00C3AC, 0xEC },
		{ 0x00C3AD, 0xED },
		{ 0x00C3AE, 0xEE },
		{ 0x00C3AF, 0xEF },
		{ 0x00C3B1, 0xF1 },
		{ 0x00C3B2, 0xF2 },
		{ 0x00C3B3, 0xF3 },
		{ 0x00C3B4, 0xF4 },
		{ 0x00C3B5, 0xF5 },
		{ 0x00C3B6, 0xF6 },
		{ 0x00C3B7, 0xF7 },
		{ 0x00C3B8, 0xF8 },
		{ 0x00C3B9, 0xF9 },
		{ 0x00C3BA, 0xFA },
		{ 0x00C3BB, 0xFB },
		{ 0x00C3BC, 0xFC },
		{ 0x00C3BF, 0xFF },
		{ 0x00C49E, 0xD0 },
		{ 0x00C49F, 0xF0 },
		{ 0x00C4B0, 0xDD },
		{ 0x00C4B1, 0xFD },
		{ 0x00C592, 0x8C },
		{ 0x00C593, 0x9C },
		{ 0x00C59E, 0xDE },
		{ 0x00C59F, 0xFE },
		{ 0x00C5A0, 0x8A },
		{ 0x00C5A1, 0x9A },
		{ 0x00C5B8, 0x9F },
		{ 0x00C692, 0x83 },
		{ 0x00CB86, 0x88 },
		{ 0x00CB9C, 0x98 },
		{ 0xE28093, 0x96 },
		{ 0xE28094, 0x97 },
		{ 0xE28098, 0x91 },
		{ 0xE28099, 0x92 },
		{ 0xE2809A, 0x82 },
		{ 0xE2809C, 0x93 },
		{ 0xE2809D, 0x94 },
		{ 0xE2809E, 0x84 },
		{ 0xE280A0, 0x86 },
		{ 0xE280A1, 0x87 },
		{ 0xE280A2, 0x95 },
		{ 0xE280A6, 0x85 },
		{ 0xE280B0, 0x89 },
		{ 0xE280B9, 0x8B },
		{ 0xE280BA, 0x9B },
		{ 0xE282AC, 0x80 },
		{ 0xE284A2, 0x99 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
	},
	{	/* UTF-8 -> CP1255 */
		{ 0x00C2A0, 0xA0 },
		{ 0x00C2A1, 0xA1 },
		{ 0x00C2A2, 0xA2 },
		{ 0x00C2A3, 0xA3 },
		{ 0x00C2A5, 0xA5 },
		{ 0x00C2A6, 0xA6 },
		{ 0x00C2A7, 0xA7 },
		{ 0x00C2A8, 0xA8 },
		{ 0x00C2A9, 0xA9 },
		{ 0x00C2AB, 0xAB },
		{ 0x00C2AC, 0xAC },
		{ 0x00C2AD, 0xAD },
		{ 0x00C2AE, 0xAE },
		{ 0x00C2AF, 0xAF },
		{ 0x00C2B0, 0xB0 },
		{ 0x00C2B1, 0xB1 },
		{ 0x00C2B2, 0xB2 },
		{ 0x00C2B3, 0xB3 },
		{ 0x00C2B4, 0xB4 },
		{ 0x00C2B5, 0xB5 },
		{ 0x00C2B6, 0xB6 },
		{ 0x00C2B7, 0xB7 },
		{ 0x00C2B8, 0xB8 },
		{ 0x00C2B9, 0xB9 },
		{ 0x00C2BB, 0xBB },
		{ 0x00C2BC, 0xBC },
		{ 0x00C2BD, 0xBD },
		{ 0x00C2BE, 0xBE },
		{ 0x00C2BF, 0xBF },
		{ 0x00C397, 0xAA },
		{ 0x00C3B7, 0xBA },
		{ 0x00C692, 0x83 },
		{ 0x00CB86, 0x88 },
		{ 0x00CB9C, 0x98 },
		{ 0x00D6B0, 0xC0 },
		{ 0x00D6B1, 0xC1 },
		{ 0x00D6B2, 0xC2 },
		{ 0x00D6B3, 0xC3 },
		{ 0x00D6B4, 0xC4 },
		{ 0x00D6B5, 0xC5 },
		{ 0x00D6B6, 0xC6 },
		{ 0x00D6B7, 0xC7 },
		{ 0x00D6B8, 0xC8 },
		{ 0x00D6B9, 0xC9 },
		{ 0x00D6BB, 0xCB },
		{ 0x00D6BC, 0xCC },
		{ 0x00D6BD, 0xCD },
		{ 0x00D6BE, 0xCE },
		{ 0x00D6BF, 0xCF },
		{ 0x00D780, 0xD0 },
		{ 0x00D781, 0xD1 },
		{ 0x00D782, 0xD2 },
		{ 0x00D783, 0xD3 },
		{ 0x00D790, 0xE0 },
		{ 0x00D791, 0xE1 },
		{ 0x00D792, 0xE2 },
		{ 0x00D793, 0xE3 },
		{ 0x00D794, 0xE4 },
		{ 0x00D795, 0xE5 },
		{ 0x00D796, 0xE6 },
		{ 0x00D797, 0xE7 },
		{ 0x00D798, 0xE8 },
		{ 0x00D799, 0xE9 },
		{ 0x00D79A, 0xEA },
		{ 0x00D79B, 0xEB },
		{ 0x00D79C, 0xEC },
		{ 0x00D79D, 0xED },
		{ 0x00D79E, 0xEE },
		{ 0x00D79F, 0xEF },
		{ 0x00D7A0, 0xF0 },
		{ 0x00D7A1, 0xF1 },
		{ 0x00D7A2, 0xF2 },
		{ 0x00D7A3, 0xF3 },
		{ 0x00D7A4, 0xF4 },
		{ 0x00D7A5, 0xF5 },
		{ 0x00D7A6, 0xF6 },
		{ 0x00D7A7, 0xF7 },
		{ 0x00D7A8, 0xF8 },
		{ 0x00D7A9, 0xF9 },
		{ 0x00D7AA, 0xFA },
		{ 0x00D7B0, 0xD4 },
		{ 0x00D7B1, 0xD5 },
		{ 0x00D7B2, 0xD6 },
		{ 0x00D7B3, 0xD7 },
		{ 0x00D7B4, 0xD8 },
		{ 0xE2808E, 0xFD },
		{ 0xE2808F, 0xFE },
		{ 0xE28093, 0x96 },
		{ 0xE28094, 0x97 },
		{ 0xE28098, 0x91 },
		{ 0xE28099, 0x92 },
		{ 0xE2809A, 0x82 },
		{ 0xE2809C, 0x93 },
		{ 0xE2809D, 0x94 },
		{ 0xE2809E, 0x84 },
		{ 0xE280A0, 0x86 },
		{ 0xE280A1, 0x87 },
		{ 0xE280A2, 0x95 },
		{ 0xE280A6, 0x85 },
		{ 0xE280B0, 0x89 },
		{ 0xE280B9, 0x8B },
		{ 0xE280BA, 0x9B },
		{ 0xE282AA, 0xA4 },
		{ 0xE282AC, 0x80 },
		{ 0xE284A2, 0x99 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
	},
	{	/* UTF-8 -> CP1256 */
		{ 0x00C2A0, 0xA0 },
		{ 0x00C2A2, 0xA2 },
		{ 0x00C2A3, 0xA3 },
		{ 0x00C2A4, 0xA4 },
		{ 0x00C2A5, 0xA5 },
		{ 0x00C2A6, 0xA6 },
		{ 0x00C2A7, 0xA7 },
		{ 0x00C2A8, 0xA8 },
		{ 0x00C2A9, 0xA9 },
		{ 0x00C2AB, 0xAB },
		{ 0x00C2AC, 0xAC },
		{ 0x00C2AD, 0xAD },
		{ 0x00C2AE, 0xAE },
		{ 0x00C2AF, 0xAF },
		{ 0x00C2B0, 0xB0 },
		{ 0x00C2B1, 0xB1 },
		{ 0x00C2B2, 0xB2 },
		{ 0x00C2B3, 0xB3 },
		{ 0x00C2B4, 0xB4 },
		{ 0x00C2B5, 0xB5 },
		{ 0x00C2B6, 0xB6 },
		{ 0x00C2B7, 0xB7 },
		{ 0x00C2B8, 0xB8 },
		{ 0x00C2B9, 0xB9 },
		{ 0x00C2BB, 0xBB },
		{ 0x00C2BC, 0xBC },
		{ 0x00C2BD, 0xBD },
		{ 0x00C2BE, 0xBE },
		{ 0x00C397, 0xD7 },
		{ 0x00C3A0, 0xE0 },
		{ 0x00C3A2, 0xE2 },
		{ 0x00C3A7, 0xE7 },
		{ 0x00C3A8, 0xE8 },
		{ 0x00C3A9, 0xE9 },
		{ 0x00C3AA, 0xEA },
		{ 0x00C3AB, 0xEB },
		{ 0x00C3AE, 0xEE },
		{ 0x00C3AF, 0xEF },
		{ 0x00C3B4, 0xF4 },
		{ 0x00C3B7, 0xF7 },
		{ 0x00C3B9, 0xF9 },
		{ 0x00C3BB, 0xFB },
		{ 0x00C3BC, 0xFC },
		{ 0x00C592, 0x8C },
		{ 0x00C593, 0x9C },
		{ 0x00C692, 0x83 },
		{ 0x00CB86, 0x88 },
		{ 0x00D88C, 0xA1 },
		{ 0x00D89B, 0xBA },
		{ 0x00D89F, 0xBF },
		{ 0x00D8A1, 0xC1 },
		{ 0x00D8A2, 0xC2 },
		{ 0x00D8A3, 0xC3 },
		{ 0x00D8A4, 0xC4 },
		{ 0x00D8A5, 0xC5 },
		{ 0x00D8A6, 0xC6 },
		{ 0x00D8A7, 0xC7 },
		{ 0x00D8A8, 0xC8 },
		{ 0x00D8A9, 0xC9 },
		{ 0x00D8AA, 0xCA },
		{ 0x00D8AB, 0xCB },
		{ 0x00D8AC, 0xCC },
		{ 0x00D8AD, 0xCD },
		{ 0x00D8AE, 0xCE },
		{ 0x00D8AF, 0xCF },
		{ 0x00D8B0, 0xD0 },
		{ 0x00D8B1, 0xD1 },
		{ 0x00D8B2, 0xD2 },
		{ 0x00D8B3, 0xD3 },
		{ 0x00D8B4, 0xD4 },
		{ 0x00D8B5, 0xD5 },
		{ 0x00D8B6, 0xD6 },
		{ 0x00D8B7, 0xD8 },
		{ 0x00D8B8, 0xD9 },
		{ 0x00D8B9, 0xDA },
		{ 0x00D8BA, 0xDB },
		{ 0x00D980, 0xDC },
		{ 0x00D981, 0xDD },
		{ 0x00D982, 0xDE },
		{ 0x00D983, 0xDF },
		{ 0x00D984, 0xE1 },
		{ 0x00D985, 0xE3 },
		{ 0x00D986, 0xE4 },
		{ 0x00D987, 0xE5 },
		{ 0x00D988, 0xE6 },
		{ 0x00D989, 0xEC },
		{ 0x00D98A, 0xED },
		{ 0x00D98B, 0xF0 },
		{ 0x00D98C, 0xF1 },
		{ 0x00D98D, 0xF2 },
		{ 0x00D98E, 0xF3 },
		{ 0x00D98F, 0xF5 },
		{ 0x00D990, 0xF6 },
		{ 0x00D991, 0xF8 },
		{ 0x00D992, 0xFA },
		{ 0x00D9B9, 0x8A },
		{ 0x00D9BE, 0x81 },
		{ 0x00DA86, 0x8D },
		{ 0x00DA88, 0x8F },
		{ 0x00DA91, 0x9A },
		{ 0x00DA98, 0x8E },
		{ 0x00DAA9, 0x98 },
		{ 0x00DAAF, 0x90 },
		{ 0x00DABA, 0x9F },
		{ 0x00DABE, 0xAA },
		{ 0x00DB81, 0xC0 },
		{ 0x00DB92, 0xFF },
		{ 0xE2808C, 0x9D },
		{ 0xE2808D, 0x9E },
		{ 0xE2808E, 0xFD },
		{ 0xE2808F, 0xFE },
		{ 0xE28093, 0x96 },
		{ 0xE28094, 0x97 },
		{ 0xE28098, 0x91 },
		{ 0xE28099, 0x92 },
		{ 0xE2809A, 0x82 },
		{ 0xE2809C, 0x93 },
		{ 0xE2809D, 0x94 },
		{ 0xE2809E, 0x84 },
		{ 0xE280A0, 0x86 },
		{ 0xE280A1, 0x87 },
		{ 0xE280A2, 0x95 },
		{ 0xE280A6, 0x85 },
		{ 0xE280B0, 0x89 },
		{ 0xE280B9, 0x8B },
		{ 0xE280BA, 0x9B },
		{ 0xE282AC, 0x80 },
		{ 0xE284A2, 0x99 },
	},
	{	/* UTF-8 -> CP1257 */
		{ 0x00C2A0, 0xA0 },
		{ 0x00C2A2, 0xA2 },
		{ 0x00C2A3, 0xA3 },
		{ 0x00C2A4, 0xA4 },
		{ 0x00C2A6, 0xA6 },
		{ 0x00C2A7, 0xA7 },
		{ 0x00C2A8, 0x8D },
		{ 0x00C2A9, 0xA9 },
		{ 0x00C2AB, 0xAB },
		{ 0x00C2AC, 0xAC },
		{ 0x00C2AD, 0xAD },
		{ 0x00C2AE, 0xAE },
		{ 0x00C2AF, 0x9D },
		{ 0x00C2B0, 0xB0 },
		{ 0x00C2B1, 0xB1 },
		{ 0x00C2B2, 0xB2 },
		{ 0x00C2B3, 0xB3 },
		{ 0x00C2B4, 0xB4 },
		{ 0x00C2B5, 0xB5 },
		{ 0x00C2B6, 0xB6 },
		{ 0x00C2B7, 0xB7 },
		{ 0x00C2B8, 0x8F },
		{ 0x00C2B9, 0xB9 },
		{ 0x00C2BB, 0xBB },
		{ 0x00C2BC, 0xBC },
		{ 0x00C2BD, 0xBD },
		{ 0x00C2BE, 0xBE },
		{ 0x00C384, 0xC4 },
		{ 0x00C385, 0xC5 },
		{ 0x00C386, 0xAF },
		{ 0x00C389, 0xC9 },
		{ 0x00C393, 0xD3 },
		{ 0x00C395, 0xD5 },
		{ 0x00C396, 0xD6 },
		{ 0x00C397, 0xD7 },
		{ 0x00C398, 0xA8 },
		{ 0x00C39C, 0xDC },
		{ 0x00C39F, 0xDF },
		{ 0x00C3A4, 0xE4 },
		{ 0x00C3A5, 0xE5 },
		{ 0x00C3A6, 0xBF },
		{ 0x00C3A9, 0xE9 },
		{ 0x00C3B3, 0xF3 },
		{ 0x00C3B5, 0xF5 },
		{ 0x00C3B6, 0xF6 },
		{ 0x00C3B7, 0xF7 },
		{ 0x00C3B8, 0xB8 },
		{ 0x00C3BC, 0xFC },
		{ 0x00C480, 0xC2 },
		{ 0x00C481, 0xE2 },
		{ 0x00C484, 0xC0 },
		{ 0x00C485, 0xE0 },
		{ 0x00C486, 0xC3 },
		{ 0x00C487, 0xE3 },
		{ 0x00C48C, 0xC8 },
		{ 0x00C48D, 0xE8 },
		{ 0x00C492, 0xC7 },
		{ 0x00C493, 0xE7 },
		{ 0x00C496, 0xCB },
		{ 0x00C497, 0xEB },
		{ 0x00C498, 0xC6 },
		{ 0x00C499, 0xE6 },
		{ 0x00C4A2, 0xCC },
		{ 0x00C4A3, 0xEC },
		{ 0x00C4AA, 0xCE },
		{ 0x00C4AB, 0xEE },
		{ 0x00C4AE, 0xC1 },
		{ 0x00C4AF, 0xE1 },
		{ 0x00C4B6, 0xCD },
		{ 0x00C4B7, 0xED },
		{ 0x00C4BB, 0xCF },
		{ 0x00C4BC, 0xEF },
		{ 0x00C581, 0xD9 },
		{ 0x00C582, 0xF9 },
		{ 0x00C583, 0xD1 },
		{ 0x00C584, 0xF1 },
		{ 0x00C585, 0xD2 },
		{ 0x00C586, 0xF2 },
		{ 0x00C58C, 0xD4 },
		{ 0x00C58D, 0xF4 },
		{ 0x00C596, 0xAA },
		{ 0x00C597, 0xBA },
		{ 0x00C59A, 0xDA },
		{ 0x00C59B, 0xFA },
		{ 0x00C5A0, 0xD0 },
		{ 0x00C5A1, 0xF0 },
		{ 0x00C5AA, 0xDB },
		{ 0x00C5AB, 0xFB },
		{ 0x00C5B2, 0xD8 },
		{ 0x00C5B3, 0xF8 },
		{ 0x00C5B9, 0xCA },
		{ 0x00C5BA, 0xEA },
		{ 0x00C5BB, 0xDD },
		{ 0x00C5BC, 0xFD },
		{ 0x00C5BD, 0xDE },
		{ 0x00C5BE, 0xFE },
		{ 0x00CB87, 0x8E },
		{ 0x00CB99, 0xFF },
		{ 0x00CB9B, 0x9E },
		{ 0xE28093, 0x96 },
		{ 0xE28094, 0x97 },
		{ 0xE28098, 0x91 },
		{ 0xE28099, 0x92 },
		{ 0xE2809A, 0x82 },
		{ 0xE2809C, 0x93 },
		{ 0xE2809D, 0x94 },
		{ 0xE2809E, 0x84 },
		{ 0xE280A0, 0x86 },
		{ 0xE280A1, 0x87 },
		{ 0xE280A2, 0x95 },
		{ 0xE280A6, 0x85 },
		{ 0xE280B0, 0x89 },
		{ 0xE280B9, 0x8B },
		{ 0xE280BA, 0x9B },
		{ 0xE282AC, 0x80 },
		{ 0xE284A2, 0x99 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
	},
	{	/* UTF-8 -> ISO 8859-2 */
		{ 0x00C280, 0x80 },
		{ 0x00C281, 0x81 },
		{ 0x00C282, 0x82 },
		{ 0x00C283, 0x83 },
		{ 0x00C284, 0x84 },
		{ 0x00C285, 0x85 },
		{ 0x00C286, 0x86 },
		{ 0x00C287, 0x87 },
		{ 0x00C288, 0x88 },
		{ 0x00C289, 0x89 },
		{ 0x00C28A, 0x8A },
		{ 0x00C28B, 0x8B },
		{ 0x00C28C, 0x8C },
		{ 0x00C28D, 0x8D },
		{ 0x00C28E, 0x8E },
		{ 0x00C28F, 0x8F },
		{ 0x00C290, 0x90 },
		{ 0x00C291, 0x91 },
		{ 0x00C292, 0x92 },
		{ 0x00C293, 0x93 },
		{ 0x00C294, 0x94 },
		{ 0x00C295, 0x95 },
		{ 0x00C296, 0x96 },
		{ 0x00C297, 0x97 },
		{ 0x00C298, 0x98 },
		{ 0x00C299, 0x99 },
		{ 0x00C29A, 0x9A },
		{ 0x00C29B, 0x9B },
		{ 0x00C29C, 0x9C },
		{ 0x00C29D, 0x9D },
		{ 0x00C29E, 0x9E },
		{ 0x00C29F, 0x9F },
		{ 0x00C2A0, 0xA0 },
		{ 0x00C2A4, 0xA4 },
		{ 0x00C2A7, 0xA7 },
		{ 0x00C2A8, 0xA8 },
		{ 0x00C2AD, 0xAD },
		{ 0x00C2B0, 0xB0 },
		{ 0x00C2B4, 0xB4 },
		{ 0x00C2B8, 0xB8 },
		{ 0x00C381, 0xC1 },
		{ 0x00C382, 0xC2 },
		{ 0x00C384, 0xC4 },
		{ 0x00C387, 0xC7 },
		{ 0x00C389, 0xC9 },
		{ 0x00C38B, 0xCB },
		{ 0x00C38D, 0xCD },
		{ 0x00C38E, 0xCE },
		{ 0x00C393, 0xD3 },
		{ 0x00C394, 0xD4 },
		{ 0x00C396, 0xD6 },
		{ 0x00C397, 0xD7 },
		{ 0x00C39A, 0xDA },
		{ 0x00C39C, 0xDC },
		{ 0x00C39D, 0xDD },
		{ 0x00C39F, 0xDF },
		{ 0x00C3A1, 0xE1 },
		{ 0x00C3A2, 0xE2 },
		{ 0x00C3A4, 0xE4 },
		{ 0x00C3A7, 0xE7 },
		{ 0x00C3A9, 0xE9 },
		{ 0x00C3AB, 0xEB },
		{ 0x00C3AD, 0xED },
		{ 0x00C3AE, 0xEE },
		{ 0x00C3B3, 0xF3 },
		{ 0x00C3B4, 0xF4 },
		{ 0x00C3B6, 0xF6 },
		{ 0x00C3B7, 0xF7 },
		{ 0x00C3BA, 0xFA },
		{ 0x00C3BC, 0xFC },
		{ 0x00C3BD, 0xFD },
		{ 0x00C482, 0xC3 },
		{ 0x00C483, 0xE3 },
		{ 0x00C484, 0xA1 },
		{ 0x00C485, 0xB1 },
		{ 0x00C486, 0xC6 },
		{ 0x00C487, 0xE6 },
		{ 0x00C48C, 0xC8 },
		{ 0x00C48D, 0xE8 },
		{ 0x00C48E, 0xCF },
		{ 0x00C48F, 0xEF },
		{ 0x00C490, 0xD0 },
		{ 0x00C491, 0xF0 },
		{ 0x00C498, 0xCA },
		{ 0x00C499, 0xEA },
		{ 0x00C49A, 0xCC },
		{ 0x00C49B, 0xEC },
		{ 0x00C4B9, 0xC5 },
		{ 0x00C4BA, 0xE5 },
		{ 0x00C4BD, 0xA5 },
		{ 0x00C4BE, 0xB5 },
		{ 0x00C581, 0xA3 },
		{ 0x00C582, 0xB3 },
		{ 0x00C583, 0xD1 },
		{ 0x00C584, 0xF1 },
		{ 0x00C587, 0xD2 },
		{ 0x00C588, 0xF2 },
		{ 0x00C590, 0xD5 },
		{ 0x00C591, 0xF5 },
		{ 0x00C594, 0xC0 },
		{ 0x00C595, 0xE0 },
		{ 0x00C598, 0xD8 },
		{ 0x00C599, 0xF8 },
		{ 0x00C59A, 0xA6 },
		{ 0x00C59B, 0xB6 },
		{ 0x00C59E, 0xAA },
		{ 0x00C59F, 0xBA },
		{ 0x00C5A0, 0xA9 },
		{ 0x00C5A1, 0xB9 },
		{ 0x00C5A2, 0xDE },
		{ 0x00C5A3, 0xFE },
		{ 0x00C5A4, 0xAB },
		{ 0x00C5A5, 0xBB },
		{ 0x00C5AE, 0xD9 },
		{ 0x00C5AF, 0xF9 },
		{ 0x00C5B0, 0xDB },
		{ 0x00C5B1, 0xFB },
		{ 0x00C5B9, 0xAC },
		{ 0x00C5BA, 0xBC },
		{ 0x00C5BB, 0xAF },
		{ 0x00C5BC, 0xBF },
		{ 0x00C5BD, 0xAE },
		{ 0x00C5BE, 0xBE },
		{ 0x00CB87, 0xB7 },
		{ 0x00CB98, 0xA2 },
		{ 0x00CB99, 0xFF },
		{ 0x00CB9B, 0xB2 },
		{ 0x00CB9D, 0xBD },
	},
	{	/* UTF-8 -> ISO 8859-3 */
		{ 0x00C280, 0x80 },
		{ 0x00C281, 0x81 },
		{ 0x00C282, 0x82 },
		{ 0x00C283, 0x83 },
		{ 0x00C284, 0x84 },
		{ 0x00C285, 0x85 },
		{ 0x00C286, 0x86 },
		{ 0x00C287, 0x87 },
		{ 0x00C288, 0x88 },
		{ 0x00C289, 0x89 },
		{ 0x00C28A, 0x8A },
		{ 0x00C28B, 0x8B },
		{ 0x00C28C, 0x8C },
		{ 0x00C28D, 0x8D },
		{ 0x00C28E, 0x8E },
		{ 0x00C28F, 0x8F },
		{ 0x00C290, 0x90 },
		{ 0x00C291, 0x91 },
		{ 0x00C292, 0x92 },
		{ 0x00C293, 0x93 },
		{ 0x00C294, 0x94 },
		{ 0x00C295, 0x95 },
		{ 0x00C296, 0x96 },
		{ 0x00C297, 0x97 },
		{ 0x00C298, 0x98 },
		{ 0x00C299, 0x99 },
		{ 0x00C29A, 0x9A },
		{ 0x00C29B, 0x9B },
		{ 0x00C29C, 0x9C },
		{ 0x00C29D, 0x9D },
		{ 0x00C29E, 0x9E },
		{ 0x00C29F, 0x9F },
		{ 0x00C2A0, 0xA0 },
		{ 0x00C2A3, 0xA3 },
		{ 0x00C2A4, 0xA4 },
		{ 0x00C2A7, 0xA7 },
		{ 0x00C2A8, 0xA8 },
		{ 0x00C2AD, 0xAD },
		{ 0x00C2B0, 0xB0 },
		{ 0x00C2B2, 0xB2 },
		{ 0x00C2B3, 0xB3 },
		{ 0x00C2B4, 0xB4 },
		{ 0x00C2B5, 0xB5 },
		{ 0x00C2B7, 0xB7 },
		{ 0x00C2B8, 0xB8 },
		{ 0x00C2BD, 0xBD },
		{ 0x00C380, 0xC0 },
		{ 0x00C381, 0xC1 },
		{ 0x00C382, 0xC2 },
		{ 0x00C384, 0xC4 },
		{ 0x00C387, 0xC7 },
		{ 0x00C388, 0xC8 },
		{ 0x00C389, 0xC9 },
		{ 0x00C38A, 0xCA },
		{ 0x00C38B, 0xCB },
		{ 0x00C38C, 0xCC },
		{ 0x00C38D, 0xCD },
		{ 0x00C38E, 0xCE },
		{ 0x00C38F, 0xCF },
		{ 0x00C391, 0xD1 },
		{ 0x00C392, 0xD2 },
		{ 0x00C393, 0xD3 },
		{ 0x00C394, 0xD4 },
		{ 0x00C396, 0xD6 },
		{ 0x00C397, 0xD7 },
		{ 0x00C399, 0xD9 },
		{ 0x00C39A, 0xDA },
		{ 0x00C39B, 0xDB },
		{ 0x00C39C, 0xDC },
		{ 0x00C39F, 0xDF },
		{ 0x00C3A0, 0xE0 },
		{ 0x00C3A1, 0xE1 },
		{ 0x00C3A2, 0xE2 },
		{ 0x00C3A4, 0xE4 },
		{ 0x00C3A7, 0xE7 },
		{ 0x00C3A8, 0xE8 },
		{ 0x00C3A9, 0xE9 },
		{ 0x00C3AA, 0xEA },
		{ 0x00C3AB, 0xEB },
		{ 0x00C3AC, 0xEC },
		{ 0x00C3AD, 0xED },
		{ 0x00C3AE, 0xEE },
		{ 0x00C3AF, 0xEF },
		{ 0x00C3B1, 0xF1 },
		{ 0x00C3B2, 0xF2 },
		{ 0x00C3B3, 0xF3 },
		{ 0x00C3B4, 0xF4 },
		{ 0x00C3B6, 0xF6 },
		{ 0x00C3B7, 0xF7 },
		{ 0x00C3B9, 0xF9 },
		{ 0x00C3BA, 0xFA },
		{ 0x00C3BB, 0xFB },
		{ 0x00C3BC, 0xFC },
		{ 0x00C488, 0xC6 },
		{ 0x00C489, 0xE6 },
		{ 0x00C48A, 0xC5 },
		{ 0x00C48B, 0xE5 },
		{ 0x00C49C, 0xD8 },
		{ 0x00C49D, 0xF8 },
		{ 0x00C49E, 0xAB },
		{ 0x00C49F, 0xBB },
		{ 0x00C4A0, 0xD5 },
		{ 0x00C4A1, 0xF5 },
		{ 0x00C4A4, 0xA6 },
		{ 0x00C4A5, 0xB6 },
		{ 0x00C4A6, 0xA1 },
		{ 0x00C4A7, 0xB1 },
		{ 0x00C4B0, 0xA9 },
		{ 0x00C4B1, 0xB9 },
		{ 0x00C4B4, 0xAC },
		{ 0x00C4B5, 0xBC },
		{ 0x00C59C, 0xDE },
		{ 0x00C59D, 0xFE },
		{ 0x00C59E, 0xAA },
		{ 0x00C59F, 0xBA },
		{ 0x00C5AC, 0xDD },
		{ 0x00C5AD, 0xFD },
		{ 0x00C5BB, 0xAF },
		{ 0x00C5BC, 0xBF },
		{ 0x00CB98, 0xA2 },
		{ 0x00CB99, 0xFF },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
	},
	{	/* UTF-8 -> ISO 8859-4 */
		{ 0x00C280, 0x80 },
		{ 0x00C281, 0x81 },
		{ 0x00C282, 0x82 },
		{ 0x00C283, 0x83 },
		{ 0x00C284, 0x84 },
		{ 0x00C285, 0x85 },
		{ 0x00C286, 0x86 },
		{ 0x00C287, 0x87 },
		{ 0x00C288, 0x88 },
		{ 0x00C289, 0x89 },
		{ 0x00C28A, 0x8A },
		{ 0x00C28B, 0x8B },
		{ 0x00C28C, 0x8C },
		{ 0x00C28D, 0x8D },
		{ 0x00C28E, 0x8E },
		{ 0x00C28F, 0x8F },
		{ 0x00C290, 0x90 },
		{ 0x00C291, 0x91 },
		{ 0x00C292, 0x92 },
		{ 0x00C293, 0x93 },
		{ 0x00C294, 0x94 },
		{ 0x00C295, 0x95 },
		{ 0x00C296, 0x96 },
		{ 0x00C297, 0x97 },
		{ 0x00C298, 0x98 },
		{ 0x00C299, 0x99 },
		{ 0x00C29A, 0x9A },
		{ 0x00C29B, 0x9B },
		{ 0x00C29C, 0x9C },
		{ 0x00C29D, 0x9D },
		{ 0x00C29E, 0x9E },
		{ 0x00C29F, 0x9F },
		{ 0x00C2A0, 0xA0 },
		{ 0x00C2A4, 0xA4 },
		{ 0x00C2A7, 0xA7 },
		{ 0x00C2A8, 0xA8 },
		{ 0x00C2AD, 0xAD },
		{ 0x00C2AF, 0xAF },
		{ 0x00C2B0, 0xB0 },
		{ 0x00C2B4, 0xB4 },
		{ 0x00C2B8, 0xB8 },
		{ 0x00C381, 0xC1 },
		{ 0x00C382, 0xC2 },
		{ 0x00C383, 0xC3 },
		{ 0x00C384, 0xC4 },
		{ 0x00C385, 0xC5 },
		{ 0x00C386, 0xC6 },
		{ 0x00C389, 0xC9 },
		{ 0x00C38B, 0xCB },
		{ 0x00C38D, 0xCD },
		{ 0x00C38E, 0xCE },
		{ 0x00C394, 0xD4 },
		{ 0x00C395, 0xD5 },
		{ 0x00C396, 0xD6 },
		{ 0x00C397, 0xD7 },
		{ 0x00C398, 0xD8 },
		{ 0x00C39A, 0xDA },
		{ 0x00C39B, 0xDB },
		{ 0x00C39C, 0xDC },
		{ 0x00C39F, 0xDF },
		{ 0x00C3A1, 0xE1 },
		{ 0x00C3A2, 0xE2 },
		{ 0x00C3A3, 0xE3 },
		{ 0x00C3A4, 0xE4 },
		{ 0x00C3A5, 0xE5 },
		{ 0x00C3A6, 0xE6 },
		{ 0x00C3A9, 0xE9 },
		{ 0x00C3AB, 0xEB },
		{ 0x00C3AD, 0xED },
		{ 0x00C3AE, 0xEE },
		{ 0x00C3B4, 0xF4 },
		{ 0x00C3B5, 0xF5 },
		{ 0x00C3B6, 0xF6 },
		{ 0x00C3B7, 0xF7 },
		{ 0x00C3B8, 0xF8 },
		{ 0x00C3BA, 0xFA },
		{ 0x00C3BB, 0xFB },
		{ 0x00C3BC, 0xFC },
		{ 0x00C480, 0xC0 },
		{ 0x00C481, 0xE0 },
		{ 0x00C484, 0xA1 },
		{ 0x00C485, 0xB1 },
		{ 0x00C48C, 0xC8 },
		{ 0x00C48D, 0xE8 },
		{ 0x00C490, 0xD0 },
		{ 0x00C491, 0xF0 },
		{ 0x00C492, 0xAA },
		{ 0x00C493, 0xBA },
		{ 0x00C496, 0xCC },
		{ 0x00C497, 0xEC },
		{ 0x00C498, 0xCA },
		{ 0x00C499, 0xEA },
		{ 0x00C4A2, 0xAB },
		{ 0x00C4A3, 0xBB },
		{ 0x00C4A8, 0xA5 },
		{ 0x00C4A9, 0xB5 },
		{ 0x00C4AA, 0xCF },
		{ 0x00C4AB, 0xEF },
		{ 0x00C4AE, 0xC7 },
		{ 0x00C4AF, 0xE7 },
		{ 0x00C4B6, 0xD3 },
		{ 0x00C4B7, 0xF3 },
		{ 0x00C4B8, 0xA2 },
		{ 0x00C4BB, 0xA6 },
		{ 0x00C4BC, 0xB6 },
		{ 0x00C585, 0xD1 },
		{ 0x00C586, 0xF1 },
		{ 0x00C58A, 0xBD },
		{ 0x00C58B, 0xBF },
		{ 0x00C58C, 0xD2 },
		{ 0x00C58D, 0xF2 },
		{ 0x00C596, 0xA3 },
		{ 0x00C597, 0xB3 },
		{ 0x00C5A0, 0xA9 },
		{ 0x00C5A1, 0xB9 },
		{ 0x00C5A6, 0xAC },
		{ 0x00C5A7, 0xBC },
		{ 0x00C5A8, 0xDD },
		{ 0x00C5A9, 0xFD },
		{ 0x00C5AA, 0xDE },
		{ 0x00C5AB, 0xFE },
		{ 0x00C5B2, 0xD9 },
		{ 0x00C5B3, 0xF9 },
		{ 0x00C5BD, 0xAE },
		{ 0x00C5BE, 0xBE },
		{ 0x00CB87, 0xB7 },
		{ 0x00CB99, 0xFF },
		{ 0x00CB9B, 0xB2 },
	},
	{	/* UTF-8 -> ISO 8859-5 */
		{ 0x00C280, 0x80 },
		{ 0x00C281, 0x81 },
		{ 0x00C282, 0x82 },
		{ 0x00C283, 0x83 },
		{ 0x00C284, 0x84 },
		{ 0x00C285, 0x85 },
		{ 0x00C286, 0x86 },
		{ 0x00C287, 0x87 },
		{ 0x00C288, 0x88 },
		{ 0x00C289, 0x89 },
		{ 0x00C28A, 0x8A },
		{ 0x00C28B, 0x8B },
		{ 0x00C28C, 0x8C },
		{ 0x00C28D, 0x8D },
		{ 0x00C28E, 0x8E },
		{ 0x00C28F, 0x8F },
		{ 0x00C290, 0x90 },
		{ 0x00C291, 0x91 },
		{ 0x00C292, 0x92 },
		{ 0x00C293, 0x93 },
		{ 0x00C294, 0x94 },
		{ 0x00C295, 0x95 },
		{ 0x00C296, 0x96 },
		{ 0x00C297, 0x97 },
		{ 0x00C298, 0x98 },
		{ 0x00C299, 0x99 },
		{ 0x00C29A, 0x9A },
		{ 0x00C29B, 0x9B },
		{ 0x00C29C, 0x9C },
		{ 0x00C29D, 0x9D },
		{ 0x00C29E, 0x9E },
		{ 0x00C29F, 0x9F },
		{ 0x00C2A0, 0xA0 },
		{ 0x00C2A7, 0xFD },
		{ 0x00C2AD, 0xAD },
		{ 0x00D081, 0xA1 },
		{ 0x00D082, 0xA2 },
		{ 0x00D083, 0xA3 },
		{ 0x00D084, 0xA4 },
		{ 0x00D085, 0xA5 },
		{ 0x00D086, 0xA6 },
		{ 0x00D087, 0xA7 },
		{ 0x00D088, 0xA8 },
		{ 0x00D089, 0xA9 },
		{ 0x00D08A, 0xAA },
		{ 0x00D08B, 0xAB },
		{ 0x00D08C, 0xAC },
		{ 0x00D08E, 0xAE },
		{ 0x00D08F, 0xAF },
		{ 0x00D090, 0xB0 },
		{ 0x00D091, 0xB1 },
		{ 0x00D092, 0xB2 },
		{ 0x00D093, 0xB3 },
		{ 0x00D094, 0xB4 },
		{ 0x00D095, 0xB5 },
		{ 0x00D096, 0xB6 },
		{ 0x00D097, 0xB7 },
		{ 0x00D098, 0xB8 },
		{ 0x00D099, 0xB9 },
		{ 0x00D09A, 0xBA },
		{ 0x00D09B, 0xBB },
		{ 0x00D09C, 0xBC },
		{ 0x00D09D, 0xBD },
		{ 0x00D09E, 0xBE },
		{ 0x00D09F, 0xBF },
		{ 0x00D0A0, 0xC0 },
		{ 0x00D0A1, 0xC1 },
		{ 0x00D0A2, 0xC2 },
		{ 0x00D0A3, 0xC3 },
		{ 0x00D0A4, 0xC4 },
		{ 0x00D0A5, 0xC5 },
		{ 0x00D0A6, 0xC6 },
		{ 0x00D0A7, 0xC7 },
		{ 0x00D0A8, 0xC8 },
		{ 0x00D0A9, 0xC9 },
		{ 0x00D0AA, 0xCA },
		{ 0x00D0AB, 0xCB },
		{ 0x00D0AC, 0xCC },
		{ 0x00D0AD, 0xCD },
		{ 0x00D0AE, 0xCE },
		{ 0x00D0AF, 0xCF },
		{ 0x00D0B0, 0xD0 },
		{ 0x00D0B1, 0xD1 },
		{ 0x00D0B2, 0xD2 },
		{ 0x00D0B3, 0xD3 },
		{ 0x00D0B4, 0xD4 },
		{ 0x00D0B5, 0xD5 },
		{ 0x00D0B6, 0xD6 },
		{ 0x00D0B7, 0xD7 },
		{ 0x00D0B8, 0xD8 },
		{ 0x00D0B9, 0xD9 },
		{ 0x00D0BA, 0xDA },
		{ 0x00D0BB, 0xDB },
		{ 0x00D0BC, 0xDC },
		{ 0x00D0BD, 0xDD },
		{ 0x00D0BE, 0xDE },
		{ 0x00D0BF, 0xDF },
		{ 0x00D180, 0xE0 },
		{ 0x00D181, 0xE1 },
		{ 0x00D182, 0xE2 },
		{ 0x00D183, 0xE3 },
		{ 0x00D184, 0xE4 },
		{ 0x00D185, 0xE5 },
		{ 0x00D186, 0xE6 },
		{ 0x00D187, 0xE7 },
		{ 0x00D188, 0xE8 },
		{ 0x00D189, 0xE9 },
		{ 0x00D18A, 0xEA },
		{ 0x00D18B, 0xEB },
		{ 0x00D18C, 0xEC },
		{ 0x00D18D, 0xED },
		{ 0x00D18E, 0xEE },
		{ 0x00D18F, 0xEF },
		{ 0x00D191, 0xF1 },
		{ 0x00D192, 0xF2 },
		{ 0x00D193, 0xF3 },
		{ 0x00D194, 0xF4 },
		{ 0x00D195, 0xF5 },
		{ 0x00D196, 0xF6 },
		{ 0x00D197, 0xF7 },
		{ 0x00D198, 0xF8 },
		{ 0x00D199, 0xF9 },
		{ 0x00D19A, 0xFA },
		{ 0x00D19B, 0xFB },
		{ 0x00D19C, 0xFC },
		{ 0x00D19E, 0xFE },
		{ 0x00D19F, 0xFF },
		{ 0xE28496, 0xF0 },
	},
	{	/* UTF-8 -> ISO 8859-6 */
		{ 0x00C280, 0x80 },
		{ 0x00C281, 0x81 },
		{ 0x00C282, 0x82 },
		{ 0x00C283, 0x83 },
		{ 0x00C284, 0x84 },
		{ 0x00C285, 0x85 },
		{ 0x00C286, 0x86 },
		{ 0x00C287, 0x87 },
		{ 0x00C288, 0x88 },
		{ 0x00C289, 0x89 },
		{ 0x00C28A, 0x8A },
		{ 0x00C28B, 0x8B },
		{ 0x00C28C, 0x8C },
		{ 0x00C28D, 0x8D },
		{ 0x00C28E, 0x8E },
		{ 0x00C28F, 0x8F },
		{ 0x00C290, 0x90 },
		{ 0x00C291, 0x91 },
		{ 0x00C292, 0x92 },
		{ 0x00C293, 0x93 },
		{ 0x00C294, 0x94 },
		{ 0x00C295, 0x95 },
		{ 0x00C296, 0x96 },
		{ 0x00C297, 0x97 },
		{ 0x00C298, 0x98 },
		{ 0x00C299, 0x99 },
		{ 0x00C29A, 0x9A },
		{ 0x00C29B, 0x9B },
		{ 0x00C29C, 0x9C },
		{ 0x00C29D, 0x9D },
		{ 0x00C29E, 0x9E },
		{ 0x00C29F, 0x9F },
		{ 0x00C2A0, 0xA0 },
		{ 0x00C2A4, 0xA4 },
		{ 0x00C2AD, 0xAD },
		{ 0x00D88C, 0xAC },
		{ 0x00D89B, 0xBB },
		{ 0x00D89F, 0xBF },
		{ 0x00D8A1, 0xC1 },
		{ 0x00D8A2, 0xC2 },
		{ 0x00D8A3, 0xC3 },
		{ 0x00D8A4, 0xC4 },
		{ 0x00D8A5, 0xC5 },
		{ 0x00D8A6, 0xC6 },
		{ 0x00D8A7, 0xC7 },
		{ 0x00D8A8, 0xC8 },
		{ 0x00D8A9, 0xC9 },
		{ 0x00D8AA, 0xCA },
		{ 0x00D8AB, 0xCB },
		{ 0x00D8AC, 0xCC },
		{ 0x00D8AD, 0xCD },
		{ 0x00D8AE, 0xCE },
		{ 0x00D8AF, 0xCF },
		{ 0x00D8B0, 0xD0 },
		{ 0x00D8B1, 0xD1 },
		{ 0x00D8B2, 0xD2 },
		{ 0x00D8B3, 0xD3 },
		{ 0x00D8B4, 0xD4 },
		{ 0x00D8B5, 0xD5 },
		{ 0x00D8B6, 0xD6 },
		{ 0x00D8B7, 0xD7 },
		{ 0x00D8B8, 0xD8 },
		{ 0x00D8B9, 0xD9 },
		{ 0x00D8BA, 0xDA },
		{ 0x00D980, 0xE0 },
		{ 0x00D981, 0xE1 },
		{ 0x00D982, 0xE2 },
		{ 0x00D983, 0xE3 },
		{ 0x00D984, 0xE4 },
		{ 0x00D985, 0xE5 },
		{ 0x00D986, 0xE6 },
		{ 0x00D987, 0xE7 },
		{ 0x00D988, 0xE8 },
		{ 0x00D989, 0xE9 },
		{ 0x00D98A, 0xEA },
		{ 0x00D98B, 0xEB },
		{ 0x00D98C, 0xEC },
		{ 0x00D98D, 0xED },
		{ 0x00D98E, 0xEE },
		{ 0x00D98F, 0xEF },
		{ 0x00D990, 0xF0 },
		{ 0x00D991, 0xF1 },
		{ 0x00D992, 0xF2 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
	},
	{	/* UTF-8 -> ISO 8859-7 */
		{ 0x00C280, 0x80 },
		{ 0x00C281, 0x81 },
		{ 0x00C282, 0x82 },
		{ 0x00C283, 0x83 },
		{ 0x00C284, 0x84 },
		{ 0x00C285, 0x85 },
		{ 0x00C286, 0x86 },
		{ 0x00C287, 0x87 },
		{ 0x00C288, 0x88 },
		{ 0x00C289, 0x89 },
		{ 0x00C28A, 0x8A },
		{ 0x00C28B, 0x8B },
		{ 0x00C28C, 0x8C },
		{ 0x00C28D, 0x8D },
		{ 0x00C28E, 0x8E },
		{ 0x00C28F, 0x8F },
		{ 0x00C290, 0x90 },
		{ 0x00C291, 0x91 },
		{ 0x00C292, 0x92 },
		{ 0x00C293, 0x93 },
		{ 0x00C294, 0x94 },
		{ 0x00C295, 0x95 },
		{ 0x00C296, 0x96 },
		{ 0x00C297, 0x97 },
		{ 0x00C298, 0x98 },
		{ 0x00C299, 0x99 },
		{ 0x00C29A, 0x9A },
		{ 0x00C29B, 0x9B },
		{ 0x00C29C, 0x9C },
		{ 0x00C29D, 0x9D },
		{ 0x00C29E, 0x9E },
		{ 0x00C29F, 0x9F },
		{ 0x00C2A0, 0xA0 },
		{ 0x00C2A3, 0xA3 },
		{ 0x00C2A6, 0xA6 },
		{ 0x00C2A7, 0xA7 },
		{ 0x00C2A8, 0xA8 },
		{ 0x00C2A9, 0xA9 },
		{ 0x00C2AB, 0xAB },
		{ 0x00C2AC, 0xAC },
		{ 0x00C2AD, 0xAD },
		{ 0x00C2B0, 0xB0 },
		{ 0x00C2B1, 0xB1 },
		{ 0x00C2B2, 0xB2 },
		{ 0x00C2B3, 0xB3 },
		{ 0x00C2B7, 0xB7 },
		{ 0x00C2BB, 0xBB },
		{ 0x00C2BD, 0xBD },
		{ 0x00CABC, 0xA2 },
		{ 0x00CABD, 0xA1 },
		{ 0x00CE84, 0xB4 },
		{ 0x00CE85, 0xB5 },
		{ 0x00CE86, 0xB6 },
		{ 0x00CE88, 0xB8 },
		{ 0x00CE89, 0xB9 },
		{ 0x00CE8A, 0xBA },
		{ 0x00CE8C, 0xBC },
		{ 0x00CE8E, 0xBE },
		{ 0x00CE8F, 0xBF },
		{ 0x00CE90, 0xC0 },
		{ 0x00CE91, 0xC1 },
		{ 0x00CE92, 0xC2 },
		{ 0x00CE93, 0xC3 },
		{ 0x00CE94, 0xC4 },
		{ 0x00CE95, 0xC5 },
		{ 0x00CE96, 0xC6 },
		{ 0x00CE97, 0xC7 },
		{ 0x00CE98, 0xC8 },
		{ 0x00CE99, 0xC9 },
		{ 0x00CE9A, 0xCA },
		{ 0x00CE9B, 0xCB },
		{ 0x00CE9C, 0xCC },
		{ 0x00CE9D, 0xCD },
		{ 0x00CE9E, 0xCE },
		{ 0x00CE9F, 0xCF },
		{ 0x00CEA0, 0xD0 },
		{ 0x00CEA1, 0xD1 },
		{ 0x00CEA3, 0xD3 },
		{ 0x00CEA4, 0xD4 },
		{ 0x00CEA5, 0xD5 },
		{ 0x00CEA6, 0xD6 },
		{ 0x00CEA7, 0xD7 },
		{ 0x00CEA8, 0xD8 },
		{ 0x00CEA9, 0xD9 },
		{ 0x00CEAA, 0xDA },
		{ 0x00CEAB, 0xDB },
		{ 0x00CEAC, 0xDC },
		{ 0x00CEAD, 0xDD },
		{ 0x00CEAE, 0xDE },
		{ 0x00CEAF, 0xDF },
		{ 0x00CEB0, 0xE0 },
		{ 0x00CEB1, 0xE1 },
		{ 0x00CEB2, 0xE2 },
		{ 0x00CEB3, 0xE3 },
		{ 0x00CEB4, 0xE4 },
		{ 0x00CEB5, 0xE5 },
		{ 0x00CEB6, 0xE6 },
		{ 0x00CEB7, 0xE7 },
		{ 0x00CEB8, 0xE8 },
		{ 0x00CEB9, 0xE9 },
		{ 0x00CEBA, 0xEA },
		{ 0x00CEBB, 0xEB },
		{ 0x00CEBC, 0xEC },
		{ 0x00CEBD, 0xED },
		{ 0x00CEBE, 0xEE },
		{ 0x00CEBF, 0xEF },
		{ 0x00CF80, 0xF0 },
		{ 0x00CF81, 0xF1 },
		{ 0x00CF82, 0xF2 },
		{ 0x00CF83, 0xF3 },
		{ 0x00CF84, 0xF4 },
		{ 0x00CF85, 0xF5 },
		{ 0x00CF86, 0xF6 },
		{ 0x00CF87, 0xF7 },
		{ 0x00CF88, 0xF8 },
		{ 0x00CF89, 0xF9 },
		{ 0x00CF8A, 0xFA },
		{ 0x00CF8B, 0xFB },
		{ 0x00CF8C, 0xFC },
		{ 0x00CF8D, 0xFD },
		{ 0x00CF8E, 0xFE },
		{ 0xE28095, 0xAF },
		{ 0xE28098, 0xA1 },
		{ 0xE28099, 0xA2 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
	},
	{	/* UTF-8 -> ISO 8859-8 */
		{ 0x00C280, 0x80 },
		{ 0x00C281, 0x81 },
		{ 0x00C282, 0x82 },
		{ 0x00C283, 0x83 },
		{ 0x00C284, 0x84 },
		{ 0x00C285, 0x85 },
		{ 0x00C286, 0x86 },
		{ 0x00C287, 0x87 },
		{ 0x00C288, 0x88 },
		{ 0x00C289, 0x89 },
		{ 0x00C28A, 0x8A },
		{ 0x00C28B, 0x8B },
		{ 0x00C28C, 0x8C },
		{ 0x00C28D, 0x8D },
		{ 0x00C28E, 0x8E },
		{ 0x00C28F, 0x8F },
		{ 0x00C290, 0x90 },
		{ 0x00C291, 0x91 },
		{ 0x00C292, 0x92 },
		{ 0x00C293, 0x93 },
		{ 0x00C294, 0x94 },
		{ 0x00C295, 0x95 },
		{ 0x00C296, 0x96 },
		{ 0x00C297, 0x97 },
		{ 0x00C298, 0x98 },
		{ 0x00C299, 0x99 },
		{ 0x00C29A, 0x9A },
		{ 0x00C29B, 0x9B },
		{ 0x00C29C, 0x9C },
		{ 0x00C29D, 0x9D },
		{ 0x00C29E, 0x9E },
		{ 0x00C29F, 0x9F },
		{ 0x00C2A0, 0xA0 },
		{ 0x00C2A2, 0xA2 },
		{ 0x00C2A3, 0xA3 },
		{ 0x00C2A4, 0xA4 },
		{ 0x00C2A5, 0xA5 },
		{ 0x00C2A6, 0xA6 },
		{ 0x00C2A7, 0xA7 },
		{ 0x00C2A8, 0xA8 },
		{ 0x00C2A9, 0xA9 },
		{ 0x00C2AB, 0xAB },
		{ 0x00C2AC, 0xAC },
		{ 0x00C2AD, 0xAD },
		{ 0x00C2AE, 0xAE },
		{ 0x00C2AF, 0xAF },
		{ 0x00C2B0, 0xB0 },
		{ 0x00C2B1, 0xB1 },
		{ 0x00C2B2, 0xB2 },
		{ 0x00C2B3, 0xB3 },
		{ 0x00C2B4, 0xB4 },
		{ 0x00C2B5, 0xB5 },
		{ 0x00C2B6, 0xB6 },
		{ 0x00C2B7, 0xB7 },
		{ 0x00C2B8, 0xB8 },
		{ 0x00C2B9, 0xB9 },
		{ 0x00C2BB, 0xBB },
		{ 0x00C2BC, 0xBC },
		{ 0x00C2BD, 0xBD },
		{ 0x00C2BE, 0xBE },
		{ 0x00C397, 0xAA },
		{ 0x00C3B7, 0xBA },
		{ 0x00D790, 0xE0 },
		{ 0x00D791, 0xE1 },
		{ 0x00D792, 0xE2 },
		{ 0x00D793, 0xE3 },
		{ 0x00D794, 0xE4 },
		{ 0x00D795, 0xE5 },
		{ 0x00D796, 0xE6 },
		{ 0x00D797, 0xE7 },
		{ 0x00D798, 0xE8 },
		{ 0x00D799, 0xE9 },
		{ 0x00D79A, 0xEA },
		{ 0x00D79B, 0xEB },
		{ 0x00D79C, 0xEC },
		{ 0x00D79D, 0xED },
		{ 0x00D79E, 0xEE },
		{ 0x00D79F, 0xEF },
		{ 0x00D7A0, 0xF0 },
		{ 0x00D7A1, 0xF1 },
		{ 0x00D7A2, 0xF2 },
		{ 0x00D7A3, 0xF3 },
		{ 0x00D7A4, 0xF4 },
		{ 0x00D7A5, 0xF5 },
		{ 0x00D7A6, 0xF6 },
		{ 0x00D7A7, 0xF7 },
		{ 0x00D7A8, 0xF8 },
		{ 0x00D7A9, 0xF9 },
		{ 0x00D7AA, 0xFA },
		{ 0xE2808E, 0xFD },
		{ 0xE2808F, 0xFE },
		{ 0xE28097, 0xDF },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
	},
	{	/* UTF-8 -> ISO 8859-9 */
		{ 0x00C280, 0x80 },
		{ 0x00C281, 0x81 },
		{ 0x00C282, 0x82 },
		{ 0x00C283, 0x83 },
		{ 0x00C284, 0x84 },
		{ 0x00C285, 0x85 },
		{ 0x00C286, 0x86 },
		{ 0x00C287, 0x87 },
		{ 0x00C288, 0x88 },
		{ 0x00C289, 0x89 },
		{ 0x00C28A, 0x8A },
		{ 0x00C28B, 0x8B },
		{ 0x00C28C, 0x8C },
		{ 0x00C28D, 0x8D },
		{ 0x00C28E, 0x8E },
		{ 0x00C28F, 0x8F },
		{ 0x00C290, 0x90 },
		{ 0x00C291, 0x91 },
		{ 0x00C292, 0x92 },
		{ 0x00C293, 0x93 },
		{ 0x00C294, 0x94 },
		{ 0x00C295, 0x95 },
		{ 0x00C296, 0x96 },
		{ 0x00C297, 0x97 },
		{ 0x00C298, 0x98 },
		{ 0x00C299, 0x99 },
		{ 0x00C29A, 0x9A },
		{ 0x00C29B, 0x9B },
		{ 0x00C29C, 0x9C },
		{ 0x00C29D, 0x9D },
		{ 0x00C29E, 0x9E },
		{ 0x00C29F, 0x9F },
		{ 0x00C2A0, 0xA0 },
		{ 0x00C2A1, 0xA1 },
		{ 0x00C2A2, 0xA2 },
		{ 0x00C2A3, 0xA3 },
		{ 0x00C2A4, 0xA4 },
		{ 0x00C2A5, 0xA5 },
		{ 0x00C2A6, 0xA6 },
		{ 0x00C2A7, 0xA7 },
		{ 0x00C2A8, 0xA8 },
		{ 0x00C2A9, 0xA9 },
		{ 0x00C2AA, 0xAA },
		{ 0x00C2AB, 0xAB },
		{ 0x00C2AC, 0xAC },
		{ 0x00C2AD, 0xAD },
		{ 0x00C2AE, 0xAE },
		{ 0x00C2AF, 0xAF },
		{ 0x00C2B0, 0xB0 },
		{ 0x00C2B1, 0xB1 },
		{ 0x00C2B2, 0xB2 },
		{ 0x00C2B3, 0xB3 },
		{ 0x00C2B4, 0xB4 },
		{ 0x00C2B5, 0xB5 },
		{ 0x00C2B6, 0xB6 },
		{ 0x00C2B7, 0xB7 },
		{ 0x00C2B8, 0xB8 },
		{ 0x00C2B9, 0xB9 },
		{ 0x00C2BA, 0xBA },
		{ 0x00C2BB, 0xBB },
		{ 0x00C2BC, 0xBC },
		{ 0x00C2BD, 0xBD },
		{ 0x00C2BE, 0xBE },
		{ 0x00C2BF, 0xBF },
		{ 0x00C380, 0xC0 },
		{ 0x00C381, 0xC1 },
		{ 0x00C382, 0xC2 },
		{ 0x00C383, 0xC3 },
		{ 0x00C384, 0xC4 },
		{ 0x00C385, 0xC5 },
		{ 0x00C386, 0xC6 },
		{ 0x00C387, 0xC7 },
		{ 0x00C388, 0xC8 },
		{ 0x00C389, 0xC9 },
		{ 0x00C38A, 0xCA },
		{ 0x00C38B, 0xCB },
		{ 0x00C38C, 0xCC },
		{ 0x00C38D, 0xCD },
		{ 0x00C38E, 0xCE },
		{ 0x00C38F, 0xCF },
		{ 0x00C391, 0xD1 },
		{ 0x00C392, 0xD2 },
		{ 0x00C393, 0xD3 },
		{ 0x00C394, 0xD4 },
		{ 0x00C395, 0xD5 },
		{ 0x00C396, 0xD6 },
		{ 0x00C397, 0xD7 },
		{ 0x00C398, 0xD8 },
		{ 0x00C399, 0xD9 },
		{ 0x00C39A, 0xDA },
		{ 0x00C39B, 0xDB },
		{ 0x00C39C, 0xDC },
		{ 0x00C39F, 0xDF },
		{ 0x00C3A0, 0xE0 },
		{ 0x00C3A1, 0xE1 },
		{ 0x00C3A2, 0xE2 },
		{ 0x00C3A3, 0xE3 },
		{ 0x00C3A4, 0xE4 },
		{ 0x00C3A5, 0xE5 },
		{ 0x00C3A6, 0xE6 },
		{ 0x00C3A7, 0xE7 },
		{ 0x00C3A8, 0xE8 },
		{ 0x00C3A9, 0xE9 },
		{ 0x00C3AA, 0xEA },
		{ 0x00C3AB, 0xEB },
		{ 0x00C3AC, 0xEC },
		{ 0x00C3AD, 0xED },
		{ 0x00C3AE, 0xEE },
		{ 0x00C3AF, 0xEF },
		{ 0x00C3B1, 0xF1 },
		{ 0x00C3B2, 0xF2 },
		{ 0x00C3B3, 0xF3 },
		{ 0x00C3B4, 0xF4 },
		{ 0x00C3B5, 0xF5 },
		{ 0x00C3B6, 0xF6 },
		{ 0x00C3B7, 0xF7 },
		{ 0x00C3B8, 0xF8 },
		{ 0x00C3B9, 0xF9 },
		{ 0x00C3BA, 0xFA },
		{ 0x00C3BB, 0xFB },
		{ 0x00C3BC, 0xFC },
		{ 0x00C3BF, 0xFF },
		{ 0x00C49E, 0xD0 },
		{ 0x00C49F, 0xF0 },
		{ 0x00C4B0, 0xDD },
		{ 0x00C4B1, 0xFD },
		{ 0x00C59E, 0xDE },
		{ 0x00C59F, 0xFE },
	},
	{	/* UTF-8 -> ISO 8859-10 */
		{ 0x00C280, 0x80 },
		{ 0x00C281, 0x81 },
		{ 0x00C282, 0x82 },
		{ 0x00C283, 0x83 },
		{ 0x00C284, 0x84 },
		{ 0x00C285, 0x85 },
		{ 0x00C286, 0x86 },
		{ 0x00C287, 0x87 },
		{ 0x00C288, 0x88 },
		{ 0x00C289, 0x89 },
		{ 0x00C28A, 0x8A },
		{ 0x00C28B, 0x8B },
		{ 0x00C28C, 0x8C },
		{ 0x00C28D, 0x8D },
		{ 0x00C28E, 0x8E },
		{ 0x00C28F, 0x8F },
		{ 0x00C290, 0x90 },
		{ 0x00C291, 0x91 },
		{ 0x00C292, 0x92 },
		{ 0x00C293, 0x93 },
		{ 0x00C294, 0x94 },
		{ 0x00C295, 0x95 },
		{ 0x00C296, 0x96 },
		{ 0x00C297, 0x97 },
		{ 0x00C298, 0x98 },
		{ 0x00C299, 0x99 },
		{ 0x00C29A, 0x9A },
		{ 0x00C29B, 0x9B },
		{ 0x00C29C, 0x9C },
		{ 0x00C29D, 0x9D },
		{ 0x00C29E, 0x9E },
		{ 0x00C29F, 0x9F },
		{ 0x00C2A0, 0xA0 },
		{ 0x00C2A7, 0xA7 },
		{ 0x00C2AD, 0xAD },
		{ 0x00C2B0, 0xB0 },
		{ 0x00C2B7, 0xB7 },
		{ 0x00C381, 0xC1 },
		{ 0x00C382, 0xC2 },
		{ 0x00C383, 0xC3 },
		{ 0x00C384, 0xC4 },
		{ 0x00C385, 0xC5 },
		{ 0x00C386, 0xC6 },
		{ 0x00C389, 0xC9 },
		{ 0x00C38B, 0xCB },
		{ 0x00C38D, 0xCD },
		{ 0x00C38E, 0xCE },
		{ 0x00C38F, 0xCF },
		{ 0x00C390, 0xD0 },
		{ 0x00C393, 0xD3 },
		{ 0x00C394, 0xD4 },
		{ 0x00C395, 0xD5 },
		{ 0x00C396, 0xD6 },
		{ 0x00C398, 0xD8 },
		{ 0x00C39A, 0xDA },
		{ 0x00C39B, 0xDB },
		{ 0x00C39C, 0xDC },
		{ 0x00C39D, 0xDD },
		{ 0x00C39E, 0xDE },
		{ 0x00C39F, 0xDF },
		{ 0x00C3A1, 0xE1 },
		{ 0x00C3A2, 0xE2 },
		{ 0x00C3A3, 0xE3 },
		{ 0x00C3A4, 0xE4 },
		{ 0x00C3A5, 0xE5 },
		{ 0x00C3A6, 0xE6 },
		{ 0x00C3A9, 0xE9 },
		{ 0x00C3AB, 0xEB },
		{ 0x00C3AD, 0xED },
		{ 0x00C3AE, 0xEE },
		{ 0x00C3AF, 0xEF },
		{ 0x00C3B0, 0xF0 },
		{ 0x00C3B3, 0xF3 },
		{ 0x00C3B4, 0xF4 },
		{ 0x00C3B5, 0xF5 },
		{ 0x00C3B6, 0xF6 },
		{ 0x00C3B8, 0xF8 },
		{ 0x00C3BA, 0xFA },
		{ 0x00C3BB, 0xFB },
		{ 0x00C3BC, 0xFC },
		{ 0x00C3BD, 0xFD },
		{ 0x00C3BE, 0xFE },
		{ 0x00C480, 0xC0 },
		{ 0x00C481, 0xE0 },
		{ 0x00C484, 0xA1 },
		{ 0x00C485, 0xB1 },
		{ 0x00C48C, 0xC8 },
		{ 0x00C48D, 0xE8 },
		{ 0x00C490, 0xA9 },
		{ 0x00C491, 0xB9 },
		{ 0x00C492, 0xA2 },
		{ 0x00C493, 0xB2 },
		{ 0x00C496, 0xCC },
		{ 0x00C497, 0xEC },
		{ 0x00C498, 0xCA },
		{ 0x00C499, 0xEA },
		{ 0x00C4A2, 0xA3 },
		{ 0x00C4A3, 0xB3 },
		{ 0x00C4A8, 0xA5 },
		{ 0x00C4A9, 0xB5 },
		{ 0x00C4AA, 0xA4 },
		{ 0x00C4AB, 0xB4 },
		{ 0x00C4AE, 0xC7 },
		{ 0x00C4AF, 0xE7 },
		{ 0x00C4B6, 0xA6 },
		{ 0x00C4B7, 0xB6 },
		{ 0x00C4B8, 0xFF },
		{ 0x00C4BB, 0xA8 },
		{ 0x00C4BC, 0xB8 },
		{ 0x00C585, 0xD1 },
		{ 0x00C586, 0xF1 },
		{ 0x00C58A, 0xAF },
		{ 0x00C58B, 0xBF },
		{ 0x00C58C, 0xD2 },
		{ 0x00C58D, 0xF2 },
		{ 0x00C5A0, 0xAA },
		{ 0x00C5A1, 0xBA },
		{ 0x00C5A6, 0xAB },
		{ 0x00C5A7, 0xBB },
		{ 0x00C5A8, 0xD7 },
		{ 0x00C5A9, 0xF7 },
		{ 0x00C5AA, 0xAE },
		{ 0x00C5AB, 0xBE },
		{ 0x00C5B2, 0xD9 },
		{ 0x00C5B3, 0xF9 },
		{ 0x00C5BD, 0xAC },
		{ 0x00C5BE, 0xBC },
		{ 0xE28892, 0xBD },
	},
	{	/* UTF-8 -> ISO 8859-11 */
		{ 0x00C280, 0x80 },
		{ 0x00C281, 0x81 },
		{ 0x00C282, 0x82 },
		{ 0x00C283, 0x83 },
		{ 0x00C284, 0x84 },
		{ 0x00C285, 0x85 },
		{ 0x00C286, 0x86 },
		{ 0x00C287, 0x87 },
		{ 0x00C288, 0x88 },
		{ 0x00C289, 0x89 },
		{ 0x00C28A, 0x8A },
		{ 0x00C28B, 0x8B },
		{ 0x00C28C, 0x8C },
		{ 0x00C28D, 0x8D },
		{ 0x00C28E, 0x8E },
		{ 0x00C28F, 0x8F },
		{ 0x00C290, 0x90 },
		{ 0x00C291, 0x91 },
		{ 0x00C292, 0x92 },
		{ 0x00C293, 0x93 },
		{ 0x00C294, 0x94 },
		{ 0x00C295, 0x95 },
		{ 0x00C296, 0x96 },
		{ 0x00C297, 0x97 },
		{ 0x00C298, 0x98 },
		{ 0x00C299, 0x99 },
		{ 0x00C29A, 0x9A },
		{ 0x00C29B, 0x9B },
		{ 0x00C29C, 0x9C },
		{ 0x00C29D, 0x9D },
		{ 0x00C29E, 0x9E },
		{ 0x00C29F, 0x9F },
		{ 0xE0B881, 0xA1 },
		{ 0xE0B882, 0xA2 },
		{ 0xE0B883, 0xA3 },
		{ 0xE0B884, 0xA4 },
		{ 0xE0B885, 0xA5 },
		{ 0xE0B886, 0xA6 },
		{ 0xE0B887, 0xA7 },
		{ 0xE0B888, 0xA8 },
		{ 0xE0B889, 0xA9 },
		{ 0xE0B88A, 0xAA },
		{ 0xE0B88B, 0xAB },
		{ 0xE0B88C, 0xAC },
		{ 0xE0B88D, 0xAD },
		{ 0xE0B88E, 0xAE },
		{ 0xE0B88F, 0xAF },
		{ 0xE0B890, 0xB0 },
		{ 0xE0B891, 0xB1 },
		{ 0xE0B892, 0xB2 },
		{ 0xE0B893, 0xB3 },
		{ 0xE0B894, 0xB4 },
		{ 0xE0B895, 0xB5 },
		{ 0xE0B896, 0xB6 },
		{ 0xE0B897, 0xB7 },
		{ 0xE0B898, 0xB8 },
		{ 0xE0B899, 0xB9 },
		{ 0xE0B89A, 0xBA },
		{ 0xE0B89B, 0xBB },
		{ 0xE0B89C, 0xBC },
		{ 0xE0B89D, 0xBD },
		{ 0xE0B89E, 0xBE },
		{ 0xE0B89F, 0xBF },
		{ 0xE0B8A0, 0xC0 },
		{ 0xE0B8A1, 0xC1 },
		{ 0xE0B8A2, 0xC2 },
		{ 0xE0B8A3, 0xC3 },
		{ 0xE0B8A4, 0xC4 },
		{ 0xE0B8A5, 0xC5 },
		{ 0xE0B8A6, 0xC6 },
		{ 0xE0B8A7, 0xC7 },
		{ 0xE0B8A8, 0xC8 },
		{ 0xE0B8A9, 0xC9 },
		{ 0xE0B8AA, 0xCA },
		{ 0xE0B8AB, 0xCB },
		{ 0xE0B8AC, 0xCC },
		{ 0xE0B8AD, 0xCD },
		{ 0xE0B8AE, 0xCE },
		{ 0xE0B8AF, 0xCF },
		{ 0xE0B8B0, 0xD0 },
		{ 0xE0B8B1, 0xD1 },
		{ 0xE0B8B2, 0xD2 },
		{ 0xE0B8B3, 0xD3 },
		{ 0xE0B8B4, 0xD4 },
		{ 0xE0B8B5, 0xD5 },
		{ 0xE0B8B6, 0xD6 },
		{ 0xE0B8B7, 0xD7 },
		{ 0xE0B8B8, 0xD8 },
		{ 0xE0B8B9, 0xD9 },
		{ 0xE0B8BA, 0xDA },
		{ 0xE0B8BF, 0xDF },
		{ 0xE0B980, 0xE0 },
		{ 0xE0B981, 0xE1 },
		{ 0xE0B982, 0xE2 },
		{ 0xE0B983, 0xE3 },
		{ 0xE0B984, 0xE4 },
		{ 0xE0B985, 0xE5 },
		{ 0xE0B986, 0xE6 },
		{ 0xE0B987, 0xE7 },
		{ 0xE0B988, 0xE8 },
		{ 0xE0B989, 0xE9 },
		{ 0xE0B98A, 0xEA },
		{ 0xE0B98B, 0xEB },
		{ 0xE0B98C, 0xEC },
		{ 0xE0B98D, 0xED },
		{ 0xE0B98E, 0xEE },
		{ 0xE0B98F, 0xEF },
		{ 0xE0B990, 0xF0 },
		{ 0xE0B991, 0xF1 },
		{ 0xE0B992, 0xF2 },
		{ 0xE0B993, 0xF3 },
		{ 0xE0B994, 0xF4 },
		{ 0xE0B995, 0xF5 },
		{ 0xE0B996, 0xF6 },
		{ 0xE0B997, 0xF7 },
		{ 0xE0B998, 0xF8 },
		{ 0xE0B999, 0xF9 },
		{ 0xE0B99A, 0xFA },
		{ 0xE0B99B, 0xFB },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
		{ 0xFFFFFF, 0x00 },
	},
	{	/* UTF-8 -> ISO 8859-13 */
		{ 0x00C280, 0x80 },
		{ 0x00C281, 0x81 },
		{ 0x00C282, 0x82 },
		{ 0x00C283, 0x83 },
		{ 0x00C284, 0x84 },
		{ 0x00C285, 0x85 },
		{ 0x00C286, 0x86 },
		{ 0x00C287, 0x87 },
		{ 0x00C288, 0x88 },
		{ 0x00C289, 0x89 },
		{ 0x00C28A, 0x8A },
		{ 0x00C28B, 0x8B },
		{ 0x00C28C, 0x8C },
		{ 0x00C28D, 0x8D },
		{ 0x00C28E, 0x8E },
		{ 0x00C28F, 0x8F },
		{ 0x00C290, 0x90 },
		{ 0x00C291, 0x91 },
		{ 0x00C292, 0x92 },
		{ 0x00C293, 0x93 },
		{ 0x00C294, 0x94 },
		{ 0x00C295, 0x95 },
		{ 0x00C296, 0x96 },
		{ 0x00C297, 0x97 },
		{ 0x00C298, 0x98 },
		{ 0x00C299, 0x99 },
		{ 0x00C29A, 0x9A },
		{ 0x00C29B, 0x9B },
		{ 0x00C29C, 0x9C },
		{ 0x00C29D, 0x9D },
		{ 0x00C29E, 0x9E },
		{ 0x00C29F, 0x9F },
		{ 0x00C2A0, 0xA0 },
		{ 0x00C2A2, 0xA2 },
		{ 0x00C2A3, 0xA3 },
		{ 0x00C2A4, 0xA4 },
		{ 0x00C2A6, 0xA6 },
		{ 0x00C2A7, 0xA7 },
		{ 0x00C2A9, 0xA9 },
		{ 0x00C2AB, 0xAB },
		{ 0x00C2AC, 0xAC },
		{ 0x00C2AD, 0xAD },
		{ 0x00C2AE, 0xAE },
		{ 0x00C2B0, 0xB0 },
		{ 0x00C2B1, 0xB1 },
		{ 0x00C2B2, 0xB2 },
		{ 0x00C2B3, 0xB3 },
		{ 0x00C2B5, 0xB5 },
		{ 0x00C2B6, 0xB6 },
		{ 0x00C2B7, 0xB7 },
		{ 0x00C2B9, 0xB9 },
		{ 0x00C2BB, 0xBB },
		{ 0x00C2BC, 0xBC },
		{ 0x00C2BD, 0xBD },
		{ 0x00C2BE, 0xBE },
		{ 0x00C384, 0xC4 },
		{ 0x00C385, 0xC5 },
		{ 0x00C386, 0xAF },
		{ 0x00C389, 0xC9 },
		{ 0x00C393, 0xD3 },
		{ 0x00C395, 0xD5 },
		{ 0x00C396, 0xD6 },
		{ 0x00C397, 0xD7 },
		{ 0x00C398, 0xA8 },
		{ 0x00C39C, 0xDC },
		{ 0x00C39F, 0xDF },
		{ 0x00C3A4, 0xE4 },
		{ 0x00C3A5, 0xE5 },
		{ 0x00C3A6, 0xBF },
		{ 0x00C3A9, 0xE9 },
		{ 0x00C3B3, 0xF3 },
		{ 0x00C3B5, 0xF5 },
		{ 0x00C3B6, 0xF6 },
		{ 0x00C3B7, 0xF7 },
		{ 0x00C3B8, 0xB8 },
		{ 0x00C3BC, 0xFC },
		{ 0x00C480, 0xC2 },
		{ 0x00C481, 0xE2 },
		{ 0x00C484, 0xC0 },
		{ 0x00C485, 0xE0 },
		{ 0x00C486, 0xC3 },
		{ 0x00C487, 0xE3 },
		{ 0x00C48C, 0xC8 },
		{ 0x00C48D, 0xE8 },
		{ 0x00C492, 0xC7 },
		{ 0x00C493, 0xE7 },
		{ 0x00C496, 0xCB },
		{ 0x00C497, 0xEB },
		{ 0x00C498, 0xC6 },
		{ 0x00C499, 0xE6 },
		{ 0x00C4A2, 0xCC },
		{ 0x00C4A3, 0xEC },
		{ 0x00C4AA, 0xCE },
		{ 0x00C4AB, 0xEE },
		{ 0x00C4AE, 0xC1 },
		{ 0x00C4AF, 0xE1 },
		{ 0x00C4B6, 0xCD },
		{ 0x00C4B7, 0xED },
		{ 0x00C4BB, 0xCF },
		{ 0x00C4BC, 0xEF },
		{ 0x00C581, 0xD9 },
		{ 0x00C582, 0xF9 },
		{ 0x00C583, 0xD1 },
		{ 0x00C584, 0xF1 },
		{ 0x00C585, 0xD2 },
		{ 0x00C586, 0xF2 },
		{ 0x00C58C, 0xD4 },
		{ 0x00C58D, 0xF4 },
		{ 0x00C596, 0xAA },
		{ 0x00C597, 0xBA },
		{ 0x00C59A, 0xDA },
		{ 0x00C59B, 0xFA },
		{ 0x00C5A0, 0xD0 },
		{ 0x00C5A1, 0xF0 },
		{ 0x00C5AA, 0xDB },
		{ 0x00C5AB, 0xFB },
		{ 0x00C5B2, 0xD8 },
		{ 0x00C5B3, 0xF8 },
		{ 0x00C5B9, 0xCA },
		{ 0x00C5BA, 0xEA },
		{ 0x00C5BB, 0xDD },
		{ 0x00C5BC, 0xFD },
		{ 0x00C5BD, 0xDE },
		{ 0x00C5BE, 0xFE },
		{ 0xE28099, 0xFF },
		{ 0xE2809C, 0xB4 },
		{ 0xE2809D, 0xA1 },
		{ 0xE2809E, 0xA5 },
	},
	{	/* UTF-8 -> KOI8-R */
		{ 0x00C2A0, 0x9A },
		{ 0x00C2A9, 0xBF },
		{ 0x00C2B0, 0x9C },
		{ 0x00C2B2, 0x9D },
		{ 0x00C2B7, 0x9E },
		{ 0x00C3B7, 0x9F },
		{ 0x00D081, 0xB3 },
		{ 0x00D090, 0xE1 },
		{ 0x00D091, 0xE2 },
		{ 0x00D092, 0xF7 },
		{ 0x00D093, 0xE7 },
		{ 0x00D094, 0xE4 },
		{ 0x00D095, 0xE5 },
		{ 0x00D096, 0xF6 },
		{ 0x00D097, 0xFA },
		{ 0x00D098, 0xE9 },
		{ 0x00D099, 0xEA },
		{ 0x00D09A, 0xEB },
		{ 0x00D09B, 0xEC },
		{ 0x00D09C, 0xED },
		{ 0x00D09D, 0xEE },
		{ 0x00D09E, 0xEF },
		{ 0x00D09F, 0xF0 },
		{ 0x00D0A0, 0xF2 },
		{ 0x00D0A1, 0xF3 },
		{ 0x00D0A2, 0xF4 },
		{ 0x00D0A3, 0xF5 },
		{ 0x00D0A4, 0xE6 },
		{ 0x00D0A5, 0xE8 },
		{ 0x00D0A6, 0xE3 },
		{ 0x00D0A7, 0xFE },
		{ 0x00D0A8, 0xFB },
		{ 0x00D0A9, 0xFD },
		{ 0x00D0AA, 0xFF },
		{ 0x00D0AB, 0xF9 },
		{ 0x00D0AC, 0xF8 },
		{ 0x00D0AD, 0xFC },
		{ 0x00D0AE, 0xE0 },
		{ 0x00D0AF, 0xF1 },
		{ 0x00D0B0, 0xC1 },
		{ 0x00D0B1, 0xC2 },
		{ 0x00D0B2, 0xD7 },
		{ 0x00D0B3, 0xC7 },
		{ 0x00D0B4, 0xC4 },
		{ 0x00D0B5, 0xC5 },
		{ 0x00D0B6, 0xD6 },
		{ 0x00D0B7, 0xDA },
		{ 0x00D0B8, 0xC9 },
		{ 0x00D0B9, 0xCA },
		{ 0x00D0BA, 0xCB },
		{ 0x00D0BB, 0xCC },
		{ 0x00D0BC, 0xCD },
		{ 0x00D0BD, 0xCE },
		{ 0x00D0BE, 0xCF },
		{ 0x00D0BF, 0xD0 },
		{ 0x00D180, 0xD2 },
		{ 0x00D181, 0xD3 },
		{ 0x00D182, 0xD4 },
		{ 0x00D183, 0xD5 },
		{ 0x00D184, 0xC6 },
		{ 0x00D185, 0xC8 },
		{ 0x00D186, 0xC3 },
		{ 0x00D187, 0xDE },
		{ 0x00D188, 0xDB },
		{ 0x00D189, 0xDD },
		{ 0x00D18A, 0xDF },
		{ 0x00D18B, 0xD9 },
		{ 0x00D18C, 0xD8 },
		{ 0x00D18D, 0xDC },
		{ 0x00D18E, 0xC0 },
		{ 0x00D18F, 0xD1 },
		{ 0x00D191, 0xA3 },
		{ 0xE28899, 0x95 },
		{ 0xE2889A, 0x96 },
		{ 0xE28988, 0x97 },
		{ 0xE289A4, 0x98 },
		{ 0xE289A5, 0x99 },
		{ 0xE28CA0, 0x93 },
		{ 0xE28CA1, 0x9B },
		{ 0xE29480, 0x80 },
		{ 0xE29482, 0x81 },
		{ 0xE2948C, 0x82 },
		{ 0xE29490, 0x83 },
		{ 0xE29494, 0x84 },
		{ 0xE29498, 0x85 },
		{ 0xE2949C, 0x86 },
		{ 0xE294A4, 0x87 },
		{ 0xE294AC, 0x88 },
		{ 0xE294B4, 0x89 },
		{ 0xE294BC, 0x8A },
		{ 0xE29590, 0xA0 },
		{ 0xE29591, 0xA1 },
		{ 0xE29592, 0xA2 },
		{ 0xE29593, 0xA4 },
		{ 0xE29594, 0xA5 },
		{ 0xE29595, 0xA6 },
		{ 0xE29596, 0xA7 },
		{ 0xE29597, 0xA8 },
		{ 0xE29598, 0xA9 },
		{ 0xE29599, 0xAA },
		{ 0xE2959A, 0xAB },
		{ 0xE2959B, 0xAC },
		{ 0xE2959C, 0xAD },
		{ 0xE2959D, 0xAE },
		{ 0xE2959E, 0xAF },
		{ 0xE2959F, 0xB0 },
		{ 0xE295A0, 0xB1 },
		{ 0xE295A1, 0xB2 },
		{ 0xE295A2, 0xB4 },
		{ 0xE295A3, 0xB5 },
		{ 0xE295A4, 0xB6 },
		{ 0xE295A5, 0xB7 },
		{ 0xE295A6, 0xB8 },
		{ 0xE295A7, 0xB9 },
		{ 0xE295A8, 0xBA },
		{ 0xE295A9, 0xBB },
		{ 0xE295AA, 0xBC },
		{ 0xE295AB, 0xBD },
		{ 0xE295AC, 0xBE },
		{ 0xE29680, 0x8B },
		{ 0xE29684, 0x8C },
		{ 0xE29688, 0x8D },
		{ 0xE2968C, 0x8E },
		{ 0xE29690, 0x8F },
		{ 0xE29691, 0x90 },
		{ 0xE29692, 0x91 },
		{ 0xE29693, 0x92 },
		{ 0xE296A0, 0x94 },
	}
};

#endif	/* _KERNEL */

#ifdef __cplusplus
}
#endif

#endif /* _SYS_KICONV_EMEA1_H */
