/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
/*
 * ICU License - ICU 1.8.1 and later
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1995-2006 International Business Machines Corporation and
 * others
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 * -----------------------------------------------------------------------------
 * All trademarks and registered trademarks mentioned herein are the property of
 * their respective owners.
 */
/*
 * This file has been modified by Sun Microsystems, Inc.
 */

#ifndef _SYS_KICONV_EMEA2_H
#define	_SYS_KICONV_EMEA2_H

#pragma ident	"%Z%%M%	%I%	%E% SMI"

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/kiconv.h>

#ifdef	_KERNEL

/*
 * Mapping tables from CP720 to UTF-8.
 *
 * Indices are calculated by subtracting 0x80 from single byte character code
 * values.
 *
 * Each component has up to three UTF-8 character bytes; the first byte will
 * be used to figure out on how many bytes should be taken. If size figured
 * out has a value less than zero, that means that component isn't valid and
 * has no assigned character.
 *
 * We only provide mappings that will guarantee exact 1-to-1 roundtrip code
 * conversions for the maximum compatibility with previous CP720 conversions
 * in our storage products. (The same also goes to the other table at below.)
 */
static const kiconv_to_utf8_tbl_comp_t cp720_to_u8_tbl[128] = {
	{ 0xC2, 0x80, 0x00 },	/* 0x80 */
	{ 0xC2, 0x81, 0x00 },	/* 0x81 */
	{ 0xC3, 0xA9, 0x00 },	/* 0x82 */
	{ 0xC3, 0xA2, 0x00 },	/* 0x83 */
	{ 0xC2, 0x84, 0x00 },	/* 0x84 */
	{ 0xC3, 0xA0, 0x00 },	/* 0x85 */
	{ 0xC2, 0x86, 0x00 },	/* 0x86 */
	{ 0xC3, 0xA7, 0x00 },	/* 0x87 */
	{ 0xC3, 0xAA, 0x00 },	/* 0x88 */
	{ 0xC3, 0xAB, 0x00 },	/* 0x89 */
	{ 0xC3, 0xA8, 0x00 },	/* 0x8A */
	{ 0xC3, 0xAF, 0x00 },	/* 0x8B */
	{ 0xC3, 0xAE, 0x00 },	/* 0x8C */
	{ 0xC2, 0x8D, 0x00 },	/* 0x8D */
	{ 0xC2, 0x8E, 0x00 },	/* 0x8E */
	{ 0xC2, 0x8F, 0x00 },	/* 0x8F */
	{ 0xC2, 0x90, 0x00 },	/* 0x90 */
	{ 0xD9, 0x91, 0x00 },	/* 0x91 */
	{ 0xD9, 0x92, 0x00 },	/* 0x92 */
	{ 0xC3, 0xB4, 0x00 },	/* 0x93 */
	{ 0xC2, 0xA4, 0x00 },	/* 0x94 */
	{ 0xD9, 0x80, 0x00 },	/* 0x95 */
	{ 0xC3, 0xBB, 0x00 },	/* 0x96 */
	{ 0xC3, 0xB9, 0x00 },	/* 0x97 */
	{ 0xD8, 0xA1, 0x00 },	/* 0x98 */
	{ 0xD8, 0xA2, 0x00 },	/* 0x99 */
	{ 0xD8, 0xA3, 0x00 },	/* 0x9A */
	{ 0xD8, 0xA4, 0x00 },	/* 0x9B */
	{ 0xC2, 0xA3, 0x00 },	/* 0x9C */
	{ 0xD8, 0xA5, 0x00 },	/* 0x9D */
	{ 0xD8, 0xA6, 0x00 },	/* 0x9E */
	{ 0xD8, 0xA7, 0x00 },	/* 0x9F */
	{ 0xD8, 0xA8, 0x00 },	/* 0xA0 */
	{ 0xD8, 0xA9, 0x00 },	/* 0xA1 */
	{ 0xD8, 0xAA, 0x00 },	/* 0xA2 */
	{ 0xD8, 0xAB, 0x00 },	/* 0xA3 */
	{ 0xD8, 0xAC, 0x00 },	/* 0xA4 */
	{ 0xD8, 0xAD, 0x00 },	/* 0xA5 */
	{ 0xD8, 0xAE, 0x00 },	/* 0xA6 */
	{ 0xD8, 0xAF, 0x00 },	/* 0xA7 */
	{ 0xD8, 0xB0, 0x00 },	/* 0xA8 */
	{ 0xD8, 0xB1, 0x00 },	/* 0xA9 */
	{ 0xD8, 0xB2, 0x00 },	/* 0xAA */
	{ 0xD8, 0xB3, 0x00 },	/* 0xAB */
	{ 0xD8, 0xB4, 0x00 },	/* 0xAC */
	{ 0xD8, 0xB5, 0x00 },	/* 0xAD */
	{ 0xC2, 0xAB, 0x00 },	/* 0xAE */
	{ 0xC2, 0xBB, 0x00 },	/* 0xAF */
	{ 0xE2, 0x96, 0x91 },	/* 0xB0 */
	{ 0xE2, 0x96, 0x92 },	/* 0xB1 */
	{ 0xE2, 0x96, 0x93 },	/* 0xB2 */
	{ 0xE2, 0x94, 0x82 },	/* 0xB3 */
	{ 0xE2, 0x94, 0xA4 },	/* 0xB4 */
	{ 0xE2, 0x95, 0xA1 },	/* 0xB5 */
	{ 0xE2, 0x95, 0xA2 },	/* 0xB6 */
	{ 0xE2, 0x95, 0x96 },	/* 0xB7 */
	{ 0xE2, 0x95, 0x95 },	/* 0xB8 */
	{ 0xE2, 0x95, 0xA3 },	/* 0xB9 */
	{ 0xE2, 0x95, 0x91 },	/* 0xBA */
	{ 0xE2, 0x95, 0x97 },	/* 0xBB */
	{ 0xE2, 0x95, 0x9D },	/* 0xBC */
	{ 0xE2, 0x95, 0x9C },	/* 0xBD */
	{ 0xE2, 0x95, 0x9B },	/* 0xBE */
	{ 0xE2, 0x94, 0x90 },	/* 0xBF */
	{ 0xE2, 0x94, 0x94 },	/* 0xC0 */
	{ 0xE2, 0x94, 0xB4 },	/* 0xC1 */
	{ 0xE2, 0x94, 0xAC },	/* 0xC2 */
	{ 0xE2, 0x94, 0x9C },	/* 0xC3 */
	{ 0xE2, 0x94, 0x80 },	/* 0xC4 */
	{ 0xE2, 0x94, 0xBC },	/* 0xC5 */
	{ 0xE2, 0x95, 0x9E },	/* 0xC6 */
	{ 0xE2, 0x95, 0x9F },	/* 0xC7 */
	{ 0xE2, 0x95, 0x9A },	/* 0xC8 */
	{ 0xE2, 0x95, 0x94 },	/* 0xC9 */
	{ 0xE2, 0x95, 0xA9 },	/* 0xCA */
	{ 0xE2, 0x95, 0xA6 },	/* 0xCB */
	{ 0xE2, 0x95, 0xA0 },	/* 0xCC */
	{ 0xE2, 0x95, 0x90 },	/* 0xCD */
	{ 0xE2, 0x95, 0xAC },	/* 0xCE */
	{ 0xE2, 0x95, 0xA7 },	/* 0xCF */
	{ 0xE2, 0x95, 0xA8 },	/* 0xD0 */
	{ 0xE2, 0x95, 0xA4 },	/* 0xD1 */
	{ 0xE2, 0x95, 0xA5 },	/* 0xD2 */
	{ 0xE2, 0x95, 0x99 },	/* 0xD3 */
	{ 0xE2, 0x95, 0x98 },	/* 0xD4 */
	{ 0xE2, 0x95, 0x92 },	/* 0xD5 */
	{ 0xE2, 0x95, 0x93 },	/* 0xD6 */
	{ 0xE2, 0x95, 0xAB },	/* 0xD7 */
	{ 0xE2, 0x95, 0xAA },	/* 0xD8 */
	{ 0xE2, 0x94, 0x98 },	/* 0xD9 */
	{ 0xE2, 0x94, 0x8C },	/* 0xDA */
	{ 0xE2, 0x96, 0x88 },	/* 0xDB */
	{ 0xE2, 0x96, 0x84 },	/* 0xDC */
	{ 0xE2, 0x96, 0x8C },	/* 0xDD */
	{ 0xE2, 0x96, 0x90 },	/* 0xDE */
	{ 0xE2, 0x96, 0x80 },	/* 0xDF */
	{ 0xD8, 0xB6, 0x00 },	/* 0xE0 */
	{ 0xD8, 0xB7, 0x00 },	/* 0xE1 */
	{ 0xD8, 0xB8, 0x00 },	/* 0xE2 */
	{ 0xD8, 0xB9, 0x00 },	/* 0xE3 */
	{ 0xD8, 0xBA, 0x00 },	/* 0xE4 */
	{ 0xD9, 0x81, 0x00 },	/* 0xE5 */
	{ 0xC2, 0xB5, 0x00 },	/* 0xE6 */
	{ 0xD9, 0x82, 0x00 },	/* 0xE7 */
	{ 0xD9, 0x83, 0x00 },	/* 0xE8 */
	{ 0xD9, 0x84, 0x00 },	/* 0xE9 */
	{ 0xD9, 0x85, 0x00 },	/* 0xEA */
	{ 0xD9, 0x86, 0x00 },	/* 0xEB */
	{ 0xD9, 0x87, 0x00 },	/* 0xEC */
	{ 0xD9, 0x88, 0x00 },	/* 0xED */
	{ 0xD9, 0x89, 0x00 },	/* 0xEE */
	{ 0xD9, 0x8A, 0x00 },	/* 0xEF */
	{ 0xE2, 0x89, 0xA1 },	/* 0xF0 */
	{ 0xD9, 0x8B, 0x00 },	/* 0xF1 */
	{ 0xD9, 0x8C, 0x00 },	/* 0xF2 */
	{ 0xD9, 0x8D, 0x00 },	/* 0xF3 */
	{ 0xD9, 0x8E, 0x00 },	/* 0xF4 */
	{ 0xD9, 0x8F, 0x00 },	/* 0xF5 */
	{ 0xD9, 0x90, 0x00 },	/* 0xF6 */
	{ 0xE2, 0x89, 0x88 },	/* 0xF7 */
	{ 0xC2, 0xB0, 0x00 },	/* 0xF8 */
	{ 0xE2, 0x88, 0x99 },	/* 0xF9 */
	{ 0xC2, 0xB7, 0x00 },	/* 0xFA */
	{ 0xE2, 0x88, 0x9A },	/* 0xFB */
	{ 0xE2, 0x81, 0xBF },	/* 0xFC */
	{ 0xC2, 0xB2, 0x00 },	/* 0xFD */
	{ 0xE2, 0x96, 0xA0 },	/* 0xFE */
	{ 0xC2, 0xA0, 0x00 },	/* 0xFF */
};

/*
 * Mapping tables from UTF-8 to CP720.
 *
 * The table is sorted with UTF-8 values to be used with binary search.
 * UTF-8 character byte values are saved at uint32_t:24 contiguously as
 * scalar values.
 */
static const kiconv_to_sb_tbl_comp_t u8_to_cp720_tbl[128] = {
	{ 0x00C280, 0x80 },
	{ 0x00C281, 0x81 },
	{ 0x00C284, 0x84 },
	{ 0x00C286, 0x86 },
	{ 0x00C28D, 0x8D },
	{ 0x00C28E, 0x8E },
	{ 0x00C28F, 0x8F },
	{ 0x00C290, 0x90 },
	{ 0x00C2A0, 0xFF },
	{ 0x00C2A3, 0x9C },
	{ 0x00C2A4, 0x94 },
	{ 0x00C2AB, 0xAE },
	{ 0x00C2B0, 0xF8 },
	{ 0x00C2B2, 0xFD },
	{ 0x00C2B5, 0xE6 },
	{ 0x00C2B7, 0xFA },
	{ 0x00C2BB, 0xAF },
	{ 0x00C3A0, 0x85 },
	{ 0x00C3A2, 0x83 },
	{ 0x00C3A7, 0x87 },
	{ 0x00C3A8, 0x8A },
	{ 0x00C3A9, 0x82 },
	{ 0x00C3AA, 0x88 },
	{ 0x00C3AB, 0x89 },
	{ 0x00C3AE, 0x8C },
	{ 0x00C3AF, 0x8B },
	{ 0x00C3B4, 0x93 },
	{ 0x00C3B9, 0x97 },
	{ 0x00C3BB, 0x96 },
	{ 0x00D8A1, 0x98 },
	{ 0x00D8A2, 0x99 },
	{ 0x00D8A3, 0x9A },
	{ 0x00D8A4, 0x9B },
	{ 0x00D8A5, 0x9D },
	{ 0x00D8A6, 0x9E },
	{ 0x00D8A7, 0x9F },
	{ 0x00D8A8, 0xA0 },
	{ 0x00D8A9, 0xA1 },
	{ 0x00D8AA, 0xA2 },
	{ 0x00D8AB, 0xA3 },
	{ 0x00D8AC, 0xA4 },
	{ 0x00D8AD, 0xA5 },
	{ 0x00D8AE, 0xA6 },
	{ 0x00D8AF, 0xA7 },
	{ 0x00D8B0, 0xA8 },
	{ 0x00D8B1, 0xA9 },
	{ 0x00D8B2, 0xAA },
	{ 0x00D8B3, 0xAB },
	{ 0x00D8B4, 0xAC },
	{ 0x00D8B5, 0xAD },
	{ 0x00D8B6, 0xE0 },
	{ 0x00D8B7, 0xE1 },
	{ 0x00D8B8, 0xE2 },
	{ 0x00D8B9, 0xE3 },
	{ 0x00D8BA, 0xE4 },
	{ 0x00D980, 0x95 },
	{ 0x00D981, 0xE5 },
	{ 0x00D982, 0xE7 },
	{ 0x00D983, 0xE8 },
	{ 0x00D984, 0xE9 },
	{ 0x00D985, 0xEA },
	{ 0x00D986, 0xEB },
	{ 0x00D987, 0xEC },
	{ 0x00D988, 0xED },
	{ 0x00D989, 0xEE },
	{ 0x00D98A, 0xEF },
	{ 0x00D98B, 0xF1 },
	{ 0x00D98C, 0xF2 },
	{ 0x00D98D, 0xF3 },
	{ 0x00D98E, 0xF4 },
	{ 0x00D98F, 0xF5 },
	{ 0x00D990, 0xF6 },
	{ 0x00D991, 0x91 },
	{ 0x00D992, 0x92 },
	{ 0xE281BF, 0xFC },
	{ 0xE28899, 0xF9 },
	{ 0xE2889A, 0xFB },
	{ 0xE28988, 0xF7 },
	{ 0xE289A1, 0xF0 },
	{ 0xE29480, 0xC4 },
	{ 0xE29482, 0xB3 },
	{ 0xE2948C, 0xDA },
	{ 0xE29490, 0xBF },
	{ 0xE29494, 0xC0 },
	{ 0xE29498, 0xD9 },
	{ 0xE2949C, 0xC3 },
	{ 0xE294A4, 0xB4 },
	{ 0xE294AC, 0xC2 },
	{ 0xE294B4, 0xC1 },
	{ 0xE294BC, 0xC5 },
	{ 0xE29590, 0xCD },
	{ 0xE29591, 0xBA },
	{ 0xE29592, 0xD5 },
	{ 0xE29593, 0xD6 },
	{ 0xE29594, 0xC9 },
	{ 0xE29595, 0xB8 },
	{ 0xE29596, 0xB7 },
	{ 0xE29597, 0xBB },
	{ 0xE29598, 0xD4 },
	{ 0xE29599, 0xD3 },
	{ 0xE2959A, 0xC8 },
	{ 0xE2959B, 0xBE },
	{ 0xE2959C, 0xBD },
	{ 0xE2959D, 0xBC },
	{ 0xE2959E, 0xC6 },
	{ 0xE2959F, 0xC7 },
	{ 0xE295A0, 0xCC },
	{ 0xE295A1, 0xB5 },
	{ 0xE295A2, 0xB6 },
	{ 0xE295A3, 0xB9 },
	{ 0xE295A4, 0xD1 },
	{ 0xE295A5, 0xD2 },
	{ 0xE295A6, 0xCB },
	{ 0xE295A7, 0xCF },
	{ 0xE295A8, 0xD0 },
	{ 0xE295A9, 0xCA },
	{ 0xE295AA, 0xD8 },
	{ 0xE295AB, 0xD7 },
	{ 0xE295AC, 0xCE },
	{ 0xE29680, 0xDF },
	{ 0xE29684, 0xDC },
	{ 0xE29688, 0xDB },
	{ 0xE2968C, 0xDD },
	{ 0xE29690, 0xDE },
	{ 0xE29691, 0xB0 },
	{ 0xE29692, 0xB1 },
	{ 0xE29693, 0xB2 },
	{ 0xE296A0, 0xFE },
};

#endif	/* _KERNEL */

#ifdef __cplusplus
}
#endif

#endif /* _SYS_KICONV_EMEA2_H */
