/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _SYS_FM_CPU_AMD_H
#define	_SYS_FM_CPU_AMD_H

#pragma ident	"%Z%%M%	%I%	%E% SMI"

#ifdef __cplusplus
extern "C" {
#endif

/*
 * AMD model-specific ereports.  These supplement the generic ereport
 * members specified in GMCA.h.
 */

/* Ereport class subcategory for AMD processors */
#define	FM_EREPORT_CPU_AMD	"amd"

/*
 * Ereport payload definitions
 */
#define	FM_EREPORT_PAYLOAD_NAME_SYND		"syndrome"
#define	FM_EREPORT_PAYLOAD_NAME_SYND_TYPE	"syndrome-type"
#define	FM_EREPORT_PAYLOAD_NAME_RESOURCE	"resource"

#define	FM_EREPORT_PAYLOAD_FLAG_SYND		0x0000000000000001
#define	FM_EREPORT_PAYLOAD_FLAG_SYND_TYPE	0x0000000000000002
#define	FM_EREPORT_PAYLOAD_FLAG_RESOURCE	0x0000000000000004
#define	FM_EREPORT_PAYLOAD_FLAG_STACK		0x0000000000000008

/*
 * Model specific payload for each ereport type is specified using the
 * following groupings of the individual flag values above.
 */
#define	FM_EREPORT_PAYLOAD_FLAGS_COMMON 0x0ULL	/* empty */

#define	FM_EREPORT_PAYLOAD_FLAGS_SYND \
	(FM_EREPORT_PAYLOAD_FLAG_SYND | FM_EREPORT_PAYLOAD_FLAG_SYND_TYPE)
#define	FM_EREPORT_PAYLOAD_FLAGS_RESOURCE \
	(FM_EREPORT_PAYLOAD_FLAG_RESOURCE)
#define	FM_EREPORT_PAYLOAD_FLAGS_NB \
	FM_EREPORT_PAYLOAD_FLAG_STACK

#define	FM_EREPORT_PAYLOAD_FLAGS_1(f1) \
	(FM_EREPORT_PAYLOAD_FLAGS_COMMON | FM_EREPORT_PAYLOAD_FLAGS_##f1)
#define	FM_EREPORT_PAYLOAD_FLAGS_2(f1, f2) \
	(FM_EREPORT_PAYLOAD_FLAGS_COMMON | FM_EREPORT_PAYLOAD_FLAGS_##f1 | \
	FM_EREPORT_PAYLOAD_FLAGS_##f2)

#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_DC_INF_SYS_ECC1 \
	FM_EREPORT_PAYLOAD_FLAGS_2(SYND, RESOURCE)
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_DC_INF_L2_ECC1 \
	FM_EREPORT_PAYLOAD_FLAGS_1(SYND)
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_DC_INF_SYS_ECCM \
	FM_EREPORT_PAYLOAD_FLAGS_2(SYND, RESOURCE)
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_DC_INF_L2_ECCM \
	FM_EREPORT_PAYLOAD_FLAGS_1(SYND)
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_DC_DATA_ECC1 \
	FM_EREPORT_PAYLOAD_FLAGS_1(SYND)
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_DC_DATA_ECC1_UC \
	FM_EREPORT_PAYLOAD_FLAGS_1(SYND)
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_DC_DATA_ECCM \
	FM_EREPORT_PAYLOAD_FLAGS_1(SYND)
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_DC_TAG_PAR \
	FM_EREPORT_PAYLOAD_FLAGS_COMMON
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_DC_STAG_PAR \
	FM_EREPORT_PAYLOAD_FLAGS_COMMON
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_DC_L1TLB_PAR \
	FM_EREPORT_PAYLOAD_FLAGS_COMMON
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_DC_L2TLB_PAR \
	FM_EREPORT_PAYLOAD_FLAGS_COMMON

#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_IC_INF_SYS_ECC1 \
	FM_EREPORT_PAYLOAD_FLAGS_COMMON
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_IC_INF_L2_ECC1 \
	FM_EREPORT_PAYLOAD_FLAGS_COMMON
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_IC_INF_SYS_ECCM \
	FM_EREPORT_PAYLOAD_FLAGS_COMMON
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_IC_INF_L2_ECCM \
	FM_EREPORT_PAYLOAD_FLAGS_COMMON
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_IC_DATA_PAR \
	FM_EREPORT_PAYLOAD_FLAGS_COMMON
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_IC_TAG_PAR \
	FM_EREPORT_PAYLOAD_FLAGS_COMMON
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_IC_STAG_PAR \
	FM_EREPORT_PAYLOAD_FLAGS_COMMON
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_IC_L1TLB_PAR \
	FM_EREPORT_PAYLOAD_FLAGS_COMMON
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_IC_L2TLB_PAR \
	FM_EREPORT_PAYLOAD_FLAGS_COMMON
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_IC_RDDE \
	FM_EREPORT_PAYLOAD_FLAGS_COMMON

#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_BU_L2D_ECC1 \
	FM_EREPORT_PAYLOAD_FLAGS_1(SYND)
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_BU_L2D_ECCM \
	FM_EREPORT_PAYLOAD_FLAGS_1(SYND)
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_BU_L2T_PAR \
	FM_EREPORT_PAYLOAD_FLAGS_COMMON
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_BU_L2T_ECC1 \
	FM_EREPORT_PAYLOAD_FLAGS_1(SYND)
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_BU_L2T_ECCM \
	FM_EREPORT_PAYLOAD_FLAGS_1(SYND)
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_BU_S_RDE \
	FM_EREPORT_PAYLOAD_FLAGS_COMMON
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_BU_S_ECC1 \
	FM_EREPORT_PAYLOAD_FLAGS_2(SYND, RESOURCE)
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_BU_S_ECCM \
	FM_EREPORT_PAYLOAD_FLAGS_2(SYND, RESOURCE)

#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_LS_S_RDE \
	FM_EREPORT_PAYLOAD_FLAGS_COMMON

#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_NB_MEM_CE \
	FM_EREPORT_PAYLOAD_FLAGS_2(SYND, RESOURCE)
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_NB_MEM_UE \
	FM_EREPORT_PAYLOAD_FLAGS_2(SYND, RESOURCE)
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_NB_HT_CRC \
	FM_EREPORT_PAYLOAD_FLAGS_COMMON
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_NB_HT_SYNC \
	FM_EREPORT_PAYLOAD_FLAGS_COMMON
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_NB_MA \
	FM_EREPORT_PAYLOAD_FLAGS_1(NB)
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_NB_TA \
	FM_EREPORT_PAYLOAD_FLAGS_1(NB)
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_NB_GART_WALK \
	FM_EREPORT_PAYLOAD_FLAGS_COMMON
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_NB_RMW \
	FM_EREPORT_PAYLOAD_FLAGS_COMMON
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_NB_WDOG \
	FM_EREPORT_PAYLOAD_FLAGS_COMMON
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_NB_DRAMADDR_PAR \
	FM_EREPORT_PAYLOAD_FLAGS_COMMON
#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_MC_TESTFAIL \
	FM_EREPORT_PAYLOAD_FLAG_RESOURCE

#define	FM_EREPORT_PAYLOAD_FLAGS_CPU_AMD_UNKNOWN \
	FM_EREPORT_PAYLOAD_FLAGS_COMMON

#define	FM_EREPORT_CPU_AMD_DC_INF_SYS_ECC1	"dc.inf_sys_ecc1"
#define	FM_EREPORT_CPU_AMD_DC_INF_SYS_ECCM	"dc.inf_sys_eccm"
#define	FM_EREPORT_CPU_AMD_DC_INF_L2_ECC1	"dc.inf_l2_ecc1"
#define	FM_EREPORT_CPU_AMD_DC_INF_L2_ECCM	"dc.inf_l2_eccm"
#define	FM_EREPORT_CPU_AMD_DC_DATA_ECC1		"dc.data_ecc1"
#define	FM_EREPORT_CPU_AMD_DC_DATA_ECC1_UC	"dc.data_ecc1_uc"
#define	FM_EREPORT_CPU_AMD_DC_DATA_ECCM		"dc.data_eccm"
#define	FM_EREPORT_CPU_AMD_DC_TAG_PAR		"dc.tag_par"
#define	FM_EREPORT_CPU_AMD_DC_STAG_PAR		"dc.stag_par"
#define	FM_EREPORT_CPU_AMD_DC_L1TLB_PAR		"dc.l1tlb_par"
#define	FM_EREPORT_CPU_AMD_DC_L2TLB_PAR		"dc.l2tlb_par"

#define	FM_EREPORT_CPU_AMD_IC_INF_SYS_ECC1	"ic.inf_sys_ecc1"
#define	FM_EREPORT_CPU_AMD_IC_INF_SYS_ECCM	"ic.inf_sys_eccm"
#define	FM_EREPORT_CPU_AMD_IC_INF_L2_ECC1	"ic.inf_l2_ecc1"
#define	FM_EREPORT_CPU_AMD_IC_INF_L2_ECCM	"ic.inf_l2_eccm"
#define	FM_EREPORT_CPU_AMD_IC_DATA_PAR		"ic.data_par"
#define	FM_EREPORT_CPU_AMD_IC_TAG_PAR		"ic.tag_par"
#define	FM_EREPORT_CPU_AMD_IC_STAG_PAR		"ic.stag_par"
#define	FM_EREPORT_CPU_AMD_IC_L1TLB_PAR		"ic.l1tlb_par"
#define	FM_EREPORT_CPU_AMD_IC_L2TLB_PAR		"ic.l2tlb_par"
#define	FM_EREPORT_CPU_AMD_IC_RDDE		"ic.rdde"

#define	FM_EREPORT_CPU_AMD_BU_L2D_ECC1		"bu.l2d_ecc1"
#define	FM_EREPORT_CPU_AMD_BU_L2D_ECCM		"bu.l2d_eccm"
#define	FM_EREPORT_CPU_AMD_BU_L2T_PAR		"bu.l2t_par"
#define	FM_EREPORT_CPU_AMD_BU_L2T_ECC1		"bu.l2t_ecc1"
#define	FM_EREPORT_CPU_AMD_BU_L2T_ECCM		"bu.l2t_eccm"
#define	FM_EREPORT_CPU_AMD_BU_S_RDE		"bu.s_rde"
#define	FM_EREPORT_CPU_AMD_BU_S_ECC1		"bu.s_ecc1"
#define	FM_EREPORT_CPU_AMD_BU_S_ECCM		"bu.s_eccm"

#define	FM_EREPORT_CPU_AMD_LS_S_RDE		"ls.s_rde"

#define	FM_EREPORT_CPU_AMD_NB_MEM_CE		"nb.mem_ce"
#define	FM_EREPORT_CPU_AMD_NB_MEM_UE		"nb.mem_ue"
#define	FM_EREPORT_CPU_AMD_NB_HT_CRC		"nb.ht_crc"
#define	FM_EREPORT_CPU_AMD_NB_HT_SYNC		"nb.ht_sync"
#define	FM_EREPORT_CPU_AMD_NB_MA		"nb.ma"
#define	FM_EREPORT_CPU_AMD_NB_TA		"nb.ta"
#define	FM_EREPORT_CPU_AMD_NB_GART_WALK		"nb.gart_walk"
#define	FM_EREPORT_CPU_AMD_NB_RMW		"nb.rmw"
#define	FM_EREPORT_CPU_AMD_NB_WDOG		"nb.wdog"
#define	FM_EREPORT_CPU_AMD_NB_DRAMADDR_PAR	"nb.dramaddr_par"

#define	FM_EREPORT_CPU_AMD_MC_TESTFAIL		"mc.cs_testfail"

#define	FM_EREPORT_CPU_AMD_UNKNOWN		"unknown"

#ifdef __cplusplus
}
#endif

#endif /* _SYS_FM_CPU_AMD_H */
